// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=1ba28481accff89ed45808c7bf4ea45f58ad4bfb$
//

#include "libcef_dll/ctocpp/web_plugin_info_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall") CefString CefWebPluginInfoCToCpp::GetName() {
  shutdown_checker::AssertNotShutdown();

  cef_web_plugin_info_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_name))
    return CefString();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_name(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall") CefString CefWebPluginInfoCToCpp::GetPath() {
  shutdown_checker::AssertNotShutdown();

  cef_web_plugin_info_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_path))
    return CefString();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_path(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall") CefString CefWebPluginInfoCToCpp::GetVersion() {
  shutdown_checker::AssertNotShutdown();

  cef_web_plugin_info_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_version))
    return CefString();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_version(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall") CefString CefWebPluginInfoCToCpp::GetDescription() {
  shutdown_checker::AssertNotShutdown();

  cef_web_plugin_info_t* _struct = GetStruct();
  if (CEF_MEMBER_MISSING(_struct, get_description))
    return CefString();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_description(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

// CONSTRUCTOR - Do not edit by hand.

CefWebPluginInfoCToCpp::CefWebPluginInfoCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefWebPluginInfoCToCpp::~CefWebPluginInfoCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_web_plugin_info_t*
CefCToCppRefCounted<CefWebPluginInfoCToCpp,
                    CefWebPluginInfo,
                    cef_web_plugin_info_t>::UnwrapDerived(CefWrapperType type,
                                                          CefWebPluginInfo* c) {
  NOTREACHED() << "Unexpected class type: " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefWebPluginInfoCToCpp,
                                   CefWebPluginInfo,
                                   cef_web_plugin_info_t>::kWrapperType =
    WT_WEB_PLUGIN_INFO;
