// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=82ca98c4f8fbbac643f826f882ae4e4efe80e821$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_RESPONSE_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_RESPONSE_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include "include/capi/cef_response_capi.h"
#include "include/cef_response.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefResponseCToCpp : public CefCToCppRefCounted<CefResponseCToCpp,
                                                     CefResponse,
                                                     cef_response_t> {
 public:
  CefResponseCToCpp();
  virtual ~CefResponseCToCpp();

  // CefResponse methods.
  bool IsReadOnly() OVERRIDE;
  cef_errorcode_t GetError() OVERRIDE;
  void SetError(cef_errorcode_t error) OVERRIDE;
  int GetStatus() OVERRIDE;
  void SetStatus(int status) OVERRIDE;
  CefString GetStatusText() OVERRIDE;
  void SetStatusText(const CefString& statusText) OVERRIDE;
  CefString GetMimeType() OVERRIDE;
  void SetMimeType(const CefString& mimeType) OVERRIDE;
  CefString GetCharset() OVERRIDE;
  void SetCharset(const CefString& charset) OVERRIDE;
  CefString GetHeaderByName(const CefString& name) OVERRIDE;
  void SetHeaderByName(const CefString& name,
                       const CefString& value,
                       bool overwrite) OVERRIDE;
  void GetHeaderMap(HeaderMap& headerMap) OVERRIDE;
  void SetHeaderMap(const HeaderMap& headerMap) OVERRIDE;
  CefString GetURL() OVERRIDE;
  void SetURL(const CefString& url) OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_RESPONSE_CTOCPP_H_
