// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=0261f2feb842f255f84c013f69076056e9710d98$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_DOMNODE_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_DOMNODE_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include "include/capi/cef_dom_capi.h"
#include "include/cef_dom.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefDOMNodeCToCpp
    : public CefCToCppRefCounted<CefDOMNodeCToCpp, CefDOMNode, cef_domnode_t> {
 public:
  CefDOMNodeCToCpp();
  virtual ~CefDOMNodeCToCpp();

  // CefDOMNode methods.
  Type GetType() OVERRIDE;
  bool IsText() OVERRIDE;
  bool IsElement() OVERRIDE;
  bool IsEditable() OVERRIDE;
  bool IsFormControlElement() OVERRIDE;
  CefString GetFormControlElementType() OVERRIDE;
  bool IsSame(CefRefPtr<CefDOMNode> that) OVERRIDE;
  CefString GetName() OVERRIDE;
  CefString GetValue() OVERRIDE;
  bool SetValue(const CefString& value) OVERRIDE;
  CefString GetAsMarkup() OVERRIDE;
  CefRefPtr<CefDOMDocument> GetDocument() OVERRIDE;
  CefRefPtr<CefDOMNode> GetParent() OVERRIDE;
  CefRefPtr<CefDOMNode> GetPreviousSibling() OVERRIDE;
  CefRefPtr<CefDOMNode> GetNextSibling() OVERRIDE;
  bool HasChildren() OVERRIDE;
  CefRefPtr<CefDOMNode> GetFirstChild() OVERRIDE;
  CefRefPtr<CefDOMNode> GetLastChild() OVERRIDE;
  CefString GetElementTagName() OVERRIDE;
  bool HasElementAttributes() OVERRIDE;
  bool HasElementAttribute(const CefString& attrName) OVERRIDE;
  CefString GetElementAttribute(const CefString& attrName) OVERRIDE;
  void GetElementAttributes(AttributeMap& attrMap) OVERRIDE;
  bool SetElementAttribute(const CefString& attrName,
                           const CefString& value) OVERRIDE;
  CefString GetElementInnerText() OVERRIDE;
  CefRect GetElementBounds() OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_DOMNODE_CTOCPP_H_
