// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=9fbe1de9cf7f32c551c535e190d4c82b4947765d$
//

#include <dlfcn.h>
#include <stdio.h>

#include "include/capi/cef_app_capi.h"
#include "include/capi/cef_browser_capi.h"
#include "include/capi/cef_command_line_capi.h"
#include "include/capi/cef_cookie_capi.h"
#include "include/capi/cef_crash_util_capi.h"
#include "include/capi/cef_drag_data_capi.h"
#include "include/capi/cef_file_util_capi.h"
#include "include/capi/cef_image_capi.h"
#include "include/capi/cef_media_router_capi.h"
#include "include/capi/cef_menu_model_capi.h"
#include "include/capi/cef_origin_whitelist_capi.h"
#include "include/capi/cef_parser_capi.h"
#include "include/capi/cef_path_util_capi.h"
#include "include/capi/cef_print_settings_capi.h"
#include "include/capi/cef_process_message_capi.h"
#include "include/capi/cef_process_util_capi.h"
#include "include/capi/cef_request_capi.h"
#include "include/capi/cef_request_context_capi.h"
#include "include/capi/cef_resource_bundle_capi.h"
#include "include/capi/cef_response_capi.h"
#include "include/capi/cef_scheme_capi.h"
#include "include/capi/cef_server_capi.h"
#include "include/capi/cef_ssl_info_capi.h"
#include "include/capi/cef_stream_capi.h"
#include "include/capi/cef_task_capi.h"
#include "include/capi/cef_thread_capi.h"
#include "include/capi/cef_trace_capi.h"
#include "include/capi/cef_urlrequest_capi.h"
#include "include/capi/cef_v8_capi.h"
#include "include/capi/cef_values_capi.h"
#include "include/capi/cef_waitable_event_capi.h"
#include "include/capi/cef_web_plugin_capi.h"
#include "include/capi/cef_xml_reader_capi.h"
#include "include/capi/cef_zip_reader_capi.h"
#include "include/capi/test/cef_test_helpers_capi.h"
#include "include/capi/test/cef_translator_test_capi.h"
#include "include/capi/views/cef_browser_view_capi.h"
#include "include/capi/views/cef_display_capi.h"
#include "include/capi/views/cef_label_button_capi.h"
#include "include/capi/views/cef_menu_button_capi.h"
#include "include/capi/views/cef_panel_capi.h"
#include "include/capi/views/cef_scroll_view_capi.h"
#include "include/capi/views/cef_textfield_capi.h"
#include "include/capi/views/cef_window_capi.h"
#include "include/cef_api_hash.h"
#include "include/cef_version.h"
#include "include/internal/cef_logging_internal.h"
#include "include/internal/cef_string_list.h"
#include "include/internal/cef_string_map.h"
#include "include/internal/cef_string_multimap.h"
#include "include/internal/cef_string_types.h"
#include "include/internal/cef_thread_internal.h"
#include "include/internal/cef_time.h"
#include "include/internal/cef_trace_event_internal.h"
#include "include/wrapper/cef_library_loader.h"

// GLOBAL WRAPPER FUNCTIONS - Do not edit by hand.

namespace {

void* g_libcef_handle = nullptr;

void* libcef_get_ptr(const char* path, const char* name) {
  void* ptr = dlsym(g_libcef_handle, name);
  if (!ptr) {
    fprintf(stderr, "dlsym %s: %s\n", path, dlerror());
  }
  return ptr;
}

typedef int (*cef_execute_process_ptr)(const struct _cef_main_args_t*,
                                       struct _cef_app_t*,
                                       void*);
typedef int (*cef_initialize_ptr)(const struct _cef_main_args_t*,
                                  const struct _cef_settings_t*,
                                  struct _cef_app_t*,
                                  void*);
typedef void (*cef_shutdown_ptr)();
typedef void (*cef_do_message_loop_work_ptr)();
typedef void (*cef_run_message_loop_ptr)();
typedef void (*cef_quit_message_loop_ptr)();
typedef void (*cef_set_osmodal_loop_ptr)(int);
typedef void (*cef_enable_highdpi_support_ptr)();
typedef int (*cef_crash_reporting_enabled_ptr)();
typedef void (*cef_set_crash_key_value_ptr)(const cef_string_t*,
                                            const cef_string_t*);
typedef int (*cef_create_directory_ptr)(const cef_string_t*);
typedef int (*cef_get_temp_directory_ptr)(cef_string_t*);
typedef int (*cef_create_new_temp_directory_ptr)(const cef_string_t*,
                                                 cef_string_t*);
typedef int (*cef_create_temp_directory_in_directory_ptr)(const cef_string_t*,
                                                          const cef_string_t*,
                                                          cef_string_t*);
typedef int (*cef_directory_exists_ptr)(const cef_string_t*);
typedef int (*cef_delete_file_ptr)(const cef_string_t*, int);
typedef int (*cef_zip_directory_ptr)(const cef_string_t*,
                                     const cef_string_t*,
                                     int);
typedef void (*cef_load_crlsets_file_ptr)(const cef_string_t*);
typedef int (*cef_add_cross_origin_whitelist_entry_ptr)(const cef_string_t*,
                                                        const cef_string_t*,
                                                        const cef_string_t*,
                                                        int);
typedef int (*cef_remove_cross_origin_whitelist_entry_ptr)(const cef_string_t*,
                                                           const cef_string_t*,
                                                           const cef_string_t*,
                                                           int);
typedef int (*cef_clear_cross_origin_whitelist_ptr)();
typedef int (*cef_parse_url_ptr)(const cef_string_t*, struct _cef_urlparts_t*);
typedef int (*cef_create_url_ptr)(const struct _cef_urlparts_t*, cef_string_t*);
typedef cef_string_userfree_t (*cef_format_url_for_security_display_ptr)(
    const cef_string_t*);
typedef cef_string_userfree_t (*cef_get_mime_type_ptr)(const cef_string_t*);
typedef void (*cef_get_extensions_for_mime_type_ptr)(const cef_string_t*,
                                                     cef_string_list_t);
typedef cef_string_userfree_t (*cef_base64encode_ptr)(const void*, size_t);
typedef struct _cef_binary_value_t* (*cef_base64decode_ptr)(
    const cef_string_t*);
typedef cef_string_userfree_t (*cef_uriencode_ptr)(const cef_string_t*, int);
typedef cef_string_userfree_t (*cef_uridecode_ptr)(const cef_string_t*,
                                                   int,
                                                   cef_uri_unescape_rule_t);
typedef struct _cef_value_t* (*cef_parse_json_ptr)(const cef_string_t*,
                                                   cef_json_parser_options_t);
typedef struct _cef_value_t* (
    *cef_parse_json_buffer_ptr)(const void*, size_t, cef_json_parser_options_t);
typedef struct _cef_value_t* (*cef_parse_jsonand_return_error_ptr)(
    const cef_string_t*,
    cef_json_parser_options_t,
    cef_string_t*);
typedef cef_string_userfree_t (*cef_write_json_ptr)(struct _cef_value_t*,
                                                    cef_json_writer_options_t);
typedef int (*cef_get_path_ptr)(cef_path_key_t, cef_string_t*);
typedef int (*cef_launch_process_ptr)(struct _cef_command_line_t*);
typedef int (*cef_register_scheme_handler_factory_ptr)(
    const cef_string_t*,
    const cef_string_t*,
    struct _cef_scheme_handler_factory_t*);
typedef int (*cef_clear_scheme_handler_factories_ptr)();
typedef int (*cef_is_cert_status_error_ptr)(cef_cert_status_t);
typedef int (*cef_currently_on_ptr)(cef_thread_id_t);
typedef int (*cef_post_task_ptr)(cef_thread_id_t, struct _cef_task_t*);
typedef int (*cef_post_delayed_task_ptr)(cef_thread_id_t,
                                         struct _cef_task_t*,
                                         int64);
typedef int (*cef_begin_tracing_ptr)(const cef_string_t*,
                                     struct _cef_completion_callback_t*);
typedef int (*cef_end_tracing_ptr)(const cef_string_t*,
                                   struct _cef_end_tracing_callback_t*);
typedef int64 (*cef_now_from_system_trace_time_ptr)();
typedef int (*cef_register_extension_ptr)(const cef_string_t*,
                                          const cef_string_t*,
                                          struct _cef_v8handler_t*);
typedef void (*cef_visit_web_plugin_info_ptr)(
    struct _cef_web_plugin_info_visitor_t*);
typedef void (*cef_refresh_web_plugins_ptr)();
typedef void (*cef_unregister_internal_web_plugin_ptr)(const cef_string_t*);
typedef void (*cef_register_web_plugin_crash_ptr)(const cef_string_t*);
typedef void (*cef_is_web_plugin_unstable_ptr)(
    const cef_string_t*,
    struct _cef_web_plugin_unstable_callback_t*);
typedef void (*cef_register_widevine_cdm_ptr)(
    const cef_string_t*,
    struct _cef_register_cdm_callback_t*);
typedef void (*cef_execute_java_script_with_user_gesture_for_tests_ptr)(
    struct _cef_frame_t*,
    const cef_string_t*);
typedef int (*cef_browser_host_create_browser_ptr)(
    const struct _cef_window_info_t*,
    struct _cef_client_t*,
    const cef_string_t*,
    const struct _cef_browser_settings_t*,
    struct _cef_dictionary_value_t*,
    struct _cef_request_context_t*);
typedef struct _cef_browser_t* (*cef_browser_host_create_browser_sync_ptr)(
    const struct _cef_window_info_t*,
    struct _cef_client_t*,
    const cef_string_t*,
    const struct _cef_browser_settings_t*,
    struct _cef_dictionary_value_t*,
    struct _cef_request_context_t*);
typedef struct _cef_command_line_t* (*cef_command_line_create_ptr)();
typedef struct _cef_command_line_t* (*cef_command_line_get_global_ptr)();
typedef struct _cef_cookie_manager_t* (
    *cef_cookie_manager_get_global_manager_ptr)(
    struct _cef_completion_callback_t*);
typedef struct _cef_drag_data_t* (*cef_drag_data_create_ptr)();
typedef struct _cef_image_t* (*cef_image_create_ptr)();
typedef struct _cef_media_router_t* (*cef_media_router_get_global_ptr)(
    struct _cef_completion_callback_t*);
typedef struct _cef_menu_model_t* (*cef_menu_model_create_ptr)(
    struct _cef_menu_model_delegate_t*);
typedef struct _cef_print_settings_t* (*cef_print_settings_create_ptr)();
typedef struct _cef_process_message_t* (*cef_process_message_create_ptr)(
    const cef_string_t*);
typedef struct _cef_request_t* (*cef_request_create_ptr)();
typedef struct _cef_post_data_t* (*cef_post_data_create_ptr)();
typedef struct _cef_post_data_element_t* (*cef_post_data_element_create_ptr)();
typedef struct _cef_request_context_t* (
    *cef_request_context_get_global_context_ptr)();
typedef struct _cef_request_context_t* (
    *cef_request_context_create_context_ptr)(
    const struct _cef_request_context_settings_t*,
    struct _cef_request_context_handler_t*);
typedef struct _cef_request_context_t* (*cef_create_context_shared_ptr)(
    struct _cef_request_context_t*,
    struct _cef_request_context_handler_t*);
typedef struct _cef_resource_bundle_t* (*cef_resource_bundle_get_global_ptr)();
typedef struct _cef_response_t* (*cef_response_create_ptr)();
typedef void (*cef_server_create_ptr)(const cef_string_t*,
                                      uint16,
                                      int,
                                      struct _cef_server_handler_t*);
typedef struct _cef_stream_reader_t* (*cef_stream_reader_create_for_file_ptr)(
    const cef_string_t*);
typedef struct _cef_stream_reader_t* (
    *cef_stream_reader_create_for_data_ptr)(void*, size_t);
typedef struct _cef_stream_reader_t* (
    *cef_stream_reader_create_for_handler_ptr)(struct _cef_read_handler_t*);
typedef struct _cef_stream_writer_t* (*cef_stream_writer_create_for_file_ptr)(
    const cef_string_t*);
typedef struct _cef_stream_writer_t* (
    *cef_stream_writer_create_for_handler_ptr)(struct _cef_write_handler_t*);
typedef struct _cef_task_runner_t* (
    *cef_task_runner_get_for_current_thread_ptr)();
typedef struct _cef_task_runner_t* (*cef_task_runner_get_for_thread_ptr)(
    cef_thread_id_t);
typedef struct _cef_thread_t* (*cef_thread_create_ptr)(const cef_string_t*,
                                                       cef_thread_priority_t,
                                                       cef_message_loop_type_t,
                                                       int,
                                                       cef_com_init_mode_t);
typedef struct _cef_urlrequest_t* (*cef_urlrequest_create_ptr)(
    struct _cef_request_t*,
    struct _cef_urlrequest_client_t*,
    struct _cef_request_context_t*);
typedef struct _cef_v8context_t* (*cef_v8context_get_current_context_ptr)();
typedef struct _cef_v8context_t* (*cef_v8context_get_entered_context_ptr)();
typedef int (*cef_v8context_in_context_ptr)();
typedef struct _cef_v8value_t* (*cef_v8value_create_undefined_ptr)();
typedef struct _cef_v8value_t* (*cef_v8value_create_null_ptr)();
typedef struct _cef_v8value_t* (*cef_v8value_create_bool_ptr)(int);
typedef struct _cef_v8value_t* (*cef_v8value_create_int_ptr)(int32);
typedef struct _cef_v8value_t* (*cef_v8value_create_uint_ptr)(uint32);
typedef struct _cef_v8value_t* (*cef_v8value_create_double_ptr)(double);
typedef struct _cef_v8value_t* (*cef_v8value_create_date_ptr)(
    const cef_time_t*);
typedef struct _cef_v8value_t* (*cef_v8value_create_string_ptr)(
    const cef_string_t*);
typedef struct _cef_v8value_t* (*cef_v8value_create_object_ptr)(
    struct _cef_v8accessor_t*,
    struct _cef_v8interceptor_t*);
typedef struct _cef_v8value_t* (*cef_v8value_create_array_ptr)(int);
typedef struct _cef_v8value_t* (*cef_v8value_create_array_buffer_ptr)(
    void*,
    size_t,
    struct _cef_v8array_buffer_release_callback_t*);
typedef struct _cef_v8value_t* (*cef_v8value_create_function_ptr)(
    const cef_string_t*,
    struct _cef_v8handler_t*);
typedef struct _cef_v8stack_trace_t* (*cef_v8stack_trace_get_current_ptr)(int);
typedef struct _cef_value_t* (*cef_value_create_ptr)();
typedef struct _cef_binary_value_t* (*cef_binary_value_create_ptr)(const void*,
                                                                   size_t);
typedef struct _cef_dictionary_value_t* (*cef_dictionary_value_create_ptr)();
typedef struct _cef_list_value_t* (*cef_list_value_create_ptr)();
typedef struct _cef_waitable_event_t* (*cef_waitable_event_create_ptr)(int,
                                                                       int);
typedef struct _cef_xml_reader_t* (*cef_xml_reader_create_ptr)(
    struct _cef_stream_reader_t*,
    cef_xml_encoding_type_t,
    const cef_string_t*);
typedef struct _cef_zip_reader_t* (*cef_zip_reader_create_ptr)(
    struct _cef_stream_reader_t*);
typedef struct _cef_translator_test_t* (*cef_translator_test_create_ptr)();
typedef struct _cef_translator_test_ref_ptr_library_t* (
    *cef_translator_test_ref_ptr_library_create_ptr)(int);
typedef struct _cef_translator_test_ref_ptr_library_child_t* (
    *cef_translator_test_ref_ptr_library_child_create_ptr)(int, int);
typedef struct _cef_translator_test_ref_ptr_library_child_child_t* (
    *cef_translator_test_ref_ptr_library_child_child_create_ptr)(int, int, int);
typedef struct _cef_translator_test_scoped_library_t* (
    *cef_translator_test_scoped_library_create_ptr)(int);
typedef struct _cef_translator_test_scoped_library_child_t* (
    *cef_translator_test_scoped_library_child_create_ptr)(int, int);
typedef struct _cef_translator_test_scoped_library_child_child_t* (
    *cef_translator_test_scoped_library_child_child_create_ptr)(int, int, int);
typedef struct _cef_browser_view_t* (*cef_browser_view_create_ptr)(
    struct _cef_client_t*,
    const cef_string_t*,
    const struct _cef_browser_settings_t*,
    struct _cef_dictionary_value_t*,
    struct _cef_request_context_t*,
    struct _cef_browser_view_delegate_t*);
typedef struct _cef_browser_view_t* (*cef_browser_view_get_for_browser_ptr)(
    struct _cef_browser_t*);
typedef struct _cef_display_t* (*cef_display_get_primary_ptr)();
typedef struct _cef_display_t* (
    *cef_display_get_nearest_point_ptr)(const cef_point_t*, int);
typedef struct _cef_display_t* (
    *cef_display_get_matching_bounds_ptr)(const cef_rect_t*, int);
typedef size_t (*cef_display_get_count_ptr)();
typedef void (*cef_display_get_alls_ptr)(size_t*, struct _cef_display_t**);
typedef struct _cef_label_button_t* (*cef_label_button_create_ptr)(
    struct _cef_button_delegate_t*,
    const cef_string_t*);
typedef struct _cef_menu_button_t* (*cef_menu_button_create_ptr)(
    struct _cef_menu_button_delegate_t*,
    const cef_string_t*);
typedef struct _cef_panel_t* (*cef_panel_create_ptr)(
    struct _cef_panel_delegate_t*);
typedef struct _cef_scroll_view_t* (*cef_scroll_view_create_ptr)(
    struct _cef_view_delegate_t*);
typedef struct _cef_textfield_t* (*cef_textfield_create_ptr)(
    struct _cef_textfield_delegate_t*);
typedef struct _cef_window_t* (*cef_window_create_top_level_ptr)(
    struct _cef_window_delegate_t*);
typedef const char* (*cef_api_hash_ptr)(int);
typedef int (*cef_version_info_ptr)(int);
typedef int (*cef_get_min_log_level_ptr)();
typedef int (*cef_get_vlog_level_ptr)(const char*, size_t);
typedef void (*cef_log_ptr)(const char*, int, int, const char*);
typedef cef_string_list_t (*cef_string_list_alloc_ptr)();
typedef size_t (*cef_string_list_size_ptr)(cef_string_list_t);
typedef int (*cef_string_list_value_ptr)(cef_string_list_t,
                                         size_t,
                                         cef_string_t*);
typedef void (*cef_string_list_append_ptr)(cef_string_list_t,
                                           const cef_string_t*);
typedef void (*cef_string_list_clear_ptr)(cef_string_list_t);
typedef void (*cef_string_list_free_ptr)(cef_string_list_t);
typedef cef_string_list_t (*cef_string_list_copy_ptr)(cef_string_list_t);
typedef cef_string_map_t (*cef_string_map_alloc_ptr)();
typedef size_t (*cef_string_map_size_ptr)(cef_string_map_t);
typedef int (*cef_string_map_find_ptr)(cef_string_map_t,
                                       const cef_string_t*,
                                       cef_string_t*);
typedef int (*cef_string_map_key_ptr)(cef_string_map_t, size_t, cef_string_t*);
typedef int (*cef_string_map_value_ptr)(cef_string_map_t,
                                        size_t,
                                        cef_string_t*);
typedef int (*cef_string_map_append_ptr)(cef_string_map_t,
                                         const cef_string_t*,
                                         const cef_string_t*);
typedef void (*cef_string_map_clear_ptr)(cef_string_map_t);
typedef void (*cef_string_map_free_ptr)(cef_string_map_t);
typedef cef_string_multimap_t (*cef_string_multimap_alloc_ptr)();
typedef size_t (*cef_string_multimap_size_ptr)(cef_string_multimap_t);
typedef size_t (*cef_string_multimap_find_count_ptr)(cef_string_multimap_t,
                                                     const cef_string_t*);
typedef int (*cef_string_multimap_enumerate_ptr)(cef_string_multimap_t,
                                                 const cef_string_t*,
                                                 size_t,
                                                 cef_string_t*);
typedef int (*cef_string_multimap_key_ptr)(cef_string_multimap_t,
                                           size_t,
                                           cef_string_t*);
typedef int (*cef_string_multimap_value_ptr)(cef_string_multimap_t,
                                             size_t,
                                             cef_string_t*);
typedef int (*cef_string_multimap_append_ptr)(cef_string_multimap_t,
                                              const cef_string_t*,
                                              const cef_string_t*);
typedef void (*cef_string_multimap_clear_ptr)(cef_string_multimap_t);
typedef void (*cef_string_multimap_free_ptr)(cef_string_multimap_t);
typedef int (*cef_string_wide_set_ptr)(const wchar_t*,
                                       size_t,
                                       cef_string_wide_t*,
                                       int);
typedef int (*cef_string_utf8_set_ptr)(const char*,
                                       size_t,
                                       cef_string_utf8_t*,
                                       int);
typedef int (*cef_string_utf16_set_ptr)(const char16*,
                                        size_t,
                                        cef_string_utf16_t*,
                                        int);
typedef void (*cef_string_wide_clear_ptr)(cef_string_wide_t*);
typedef void (*cef_string_utf8_clear_ptr)(cef_string_utf8_t*);
typedef void (*cef_string_utf16_clear_ptr)(cef_string_utf16_t*);
typedef int (*cef_string_wide_cmp_ptr)(const cef_string_wide_t*,
                                       const cef_string_wide_t*);
typedef int (*cef_string_utf8_cmp_ptr)(const cef_string_utf8_t*,
                                       const cef_string_utf8_t*);
typedef int (*cef_string_utf16_cmp_ptr)(const cef_string_utf16_t*,
                                        const cef_string_utf16_t*);
typedef int (*cef_string_wide_to_utf8_ptr)(const wchar_t*,
                                           size_t,
                                           cef_string_utf8_t*);
typedef int (*cef_string_utf8_to_wide_ptr)(const char*,
                                           size_t,
                                           cef_string_wide_t*);
typedef int (*cef_string_wide_to_utf16_ptr)(const wchar_t*,
                                            size_t,
                                            cef_string_utf16_t*);
typedef int (*cef_string_utf16_to_wide_ptr)(const char16*,
                                            size_t,
                                            cef_string_wide_t*);
typedef int (*cef_string_utf8_to_utf16_ptr)(const char*,
                                            size_t,
                                            cef_string_utf16_t*);
typedef int (*cef_string_utf16_to_utf8_ptr)(const char16*,
                                            size_t,
                                            cef_string_utf8_t*);
typedef int (*cef_string_ascii_to_wide_ptr)(const char*,
                                            size_t,
                                            cef_string_wide_t*);
typedef int (*cef_string_ascii_to_utf16_ptr)(const char*,
                                             size_t,
                                             cef_string_utf16_t*);
typedef cef_string_userfree_wide_t (*cef_string_userfree_wide_alloc_ptr)();
typedef cef_string_userfree_utf8_t (*cef_string_userfree_utf8_alloc_ptr)();
typedef cef_string_userfree_utf16_t (*cef_string_userfree_utf16_alloc_ptr)();
typedef void (*cef_string_userfree_wide_free_ptr)(cef_string_userfree_wide_t);
typedef void (*cef_string_userfree_utf8_free_ptr)(cef_string_userfree_utf8_t);
typedef void (*cef_string_userfree_utf16_free_ptr)(cef_string_userfree_utf16_t);
typedef int (*cef_string_utf16_to_lower_ptr)(const char16*,
                                             size_t,
                                             cef_string_utf16_t*);
typedef int (*cef_string_utf16_to_upper_ptr)(const char16*,
                                             size_t,
                                             cef_string_utf16_t*);
typedef cef_platform_thread_id_t (*cef_get_current_platform_thread_id_ptr)();
typedef cef_platform_thread_handle_t (
    *cef_get_current_platform_thread_handle_ptr)();
typedef int (*cef_time_to_timet_ptr)(const cef_time_t*, time_t*);
typedef int (*cef_time_from_timet_ptr)(time_t, cef_time_t*);
typedef int (*cef_time_to_doublet_ptr)(const cef_time_t*, double*);
typedef int (*cef_time_from_doublet_ptr)(double, cef_time_t*);
typedef int (*cef_time_now_ptr)(cef_time_t*);
typedef int (*cef_time_delta_ptr)(const cef_time_t*,
                                  const cef_time_t*,
                                  long long*);
typedef void (*cef_trace_event_instant_ptr)(const char*,
                                            const char*,
                                            const char*,
                                            uint64,
                                            const char*,
                                            uint64,
                                            int);
typedef void (*cef_trace_event_begin_ptr)(const char*,
                                          const char*,
                                          const char*,
                                          uint64,
                                          const char*,
                                          uint64,
                                          int);
typedef void (*cef_trace_event_end_ptr)(const char*,
                                        const char*,
                                        const char*,
                                        uint64,
                                        const char*,
                                        uint64,
                                        int);
typedef void (*cef_trace_counter_ptr)(const char*,
                                      const char*,
                                      const char*,
                                      uint64,
                                      const char*,
                                      uint64,
                                      int);
typedef void (*cef_trace_counter_id_ptr)(const char*,
                                         const char*,
                                         uint64,
                                         const char*,
                                         uint64,
                                         const char*,
                                         uint64,
                                         int);
typedef void (*cef_trace_event_async_begin_ptr)(const char*,
                                                const char*,
                                                uint64,
                                                const char*,
                                                uint64,
                                                const char*,
                                                uint64,
                                                int);
typedef void (*cef_trace_event_async_step_into_ptr)(const char*,
                                                    const char*,
                                                    uint64,
                                                    uint64,
                                                    const char*,
                                                    uint64,
                                                    int);
typedef void (*cef_trace_event_async_step_past_ptr)(const char*,
                                                    const char*,
                                                    uint64,
                                                    uint64,
                                                    const char*,
                                                    uint64,
                                                    int);
typedef void (*cef_trace_event_async_end_ptr)(const char*,
                                              const char*,
                                              uint64,
                                              const char*,
                                              uint64,
                                              const char*,
                                              uint64,
                                              int);

struct libcef_pointers {
  cef_execute_process_ptr cef_execute_process;
  cef_initialize_ptr cef_initialize;
  cef_shutdown_ptr cef_shutdown;
  cef_do_message_loop_work_ptr cef_do_message_loop_work;
  cef_run_message_loop_ptr cef_run_message_loop;
  cef_quit_message_loop_ptr cef_quit_message_loop;
  cef_set_osmodal_loop_ptr cef_set_osmodal_loop;
  cef_enable_highdpi_support_ptr cef_enable_highdpi_support;
  cef_crash_reporting_enabled_ptr cef_crash_reporting_enabled;
  cef_set_crash_key_value_ptr cef_set_crash_key_value;
  cef_create_directory_ptr cef_create_directory;
  cef_get_temp_directory_ptr cef_get_temp_directory;
  cef_create_new_temp_directory_ptr cef_create_new_temp_directory;
  cef_create_temp_directory_in_directory_ptr
      cef_create_temp_directory_in_directory;
  cef_directory_exists_ptr cef_directory_exists;
  cef_delete_file_ptr cef_delete_file;
  cef_zip_directory_ptr cef_zip_directory;
  cef_load_crlsets_file_ptr cef_load_crlsets_file;
  cef_add_cross_origin_whitelist_entry_ptr cef_add_cross_origin_whitelist_entry;
  cef_remove_cross_origin_whitelist_entry_ptr
      cef_remove_cross_origin_whitelist_entry;
  cef_clear_cross_origin_whitelist_ptr cef_clear_cross_origin_whitelist;
  cef_parse_url_ptr cef_parse_url;
  cef_create_url_ptr cef_create_url;
  cef_format_url_for_security_display_ptr cef_format_url_for_security_display;
  cef_get_mime_type_ptr cef_get_mime_type;
  cef_get_extensions_for_mime_type_ptr cef_get_extensions_for_mime_type;
  cef_base64encode_ptr cef_base64encode;
  cef_base64decode_ptr cef_base64decode;
  cef_uriencode_ptr cef_uriencode;
  cef_uridecode_ptr cef_uridecode;
  cef_parse_json_ptr cef_parse_json;
  cef_parse_json_buffer_ptr cef_parse_json_buffer;
  cef_parse_jsonand_return_error_ptr cef_parse_jsonand_return_error;
  cef_write_json_ptr cef_write_json;
  cef_get_path_ptr cef_get_path;
  cef_launch_process_ptr cef_launch_process;
  cef_register_scheme_handler_factory_ptr cef_register_scheme_handler_factory;
  cef_clear_scheme_handler_factories_ptr cef_clear_scheme_handler_factories;
  cef_is_cert_status_error_ptr cef_is_cert_status_error;
  cef_currently_on_ptr cef_currently_on;
  cef_post_task_ptr cef_post_task;
  cef_post_delayed_task_ptr cef_post_delayed_task;
  cef_begin_tracing_ptr cef_begin_tracing;
  cef_end_tracing_ptr cef_end_tracing;
  cef_now_from_system_trace_time_ptr cef_now_from_system_trace_time;
  cef_register_extension_ptr cef_register_extension;
  cef_visit_web_plugin_info_ptr cef_visit_web_plugin_info;
  cef_refresh_web_plugins_ptr cef_refresh_web_plugins;
  cef_unregister_internal_web_plugin_ptr cef_unregister_internal_web_plugin;
  cef_register_web_plugin_crash_ptr cef_register_web_plugin_crash;
  cef_is_web_plugin_unstable_ptr cef_is_web_plugin_unstable;
  cef_register_widevine_cdm_ptr cef_register_widevine_cdm;
  cef_execute_java_script_with_user_gesture_for_tests_ptr
      cef_execute_java_script_with_user_gesture_for_tests;
  cef_browser_host_create_browser_ptr cef_browser_host_create_browser;
  cef_browser_host_create_browser_sync_ptr cef_browser_host_create_browser_sync;
  cef_command_line_create_ptr cef_command_line_create;
  cef_command_line_get_global_ptr cef_command_line_get_global;
  cef_cookie_manager_get_global_manager_ptr
      cef_cookie_manager_get_global_manager;
  cef_drag_data_create_ptr cef_drag_data_create;
  cef_image_create_ptr cef_image_create;
  cef_media_router_get_global_ptr cef_media_router_get_global;
  cef_menu_model_create_ptr cef_menu_model_create;
  cef_print_settings_create_ptr cef_print_settings_create;
  cef_process_message_create_ptr cef_process_message_create;
  cef_request_create_ptr cef_request_create;
  cef_post_data_create_ptr cef_post_data_create;
  cef_post_data_element_create_ptr cef_post_data_element_create;
  cef_request_context_get_global_context_ptr
      cef_request_context_get_global_context;
  cef_request_context_create_context_ptr cef_request_context_create_context;
  cef_create_context_shared_ptr cef_create_context_shared;
  cef_resource_bundle_get_global_ptr cef_resource_bundle_get_global;
  cef_response_create_ptr cef_response_create;
  cef_server_create_ptr cef_server_create;
  cef_stream_reader_create_for_file_ptr cef_stream_reader_create_for_file;
  cef_stream_reader_create_for_data_ptr cef_stream_reader_create_for_data;
  cef_stream_reader_create_for_handler_ptr cef_stream_reader_create_for_handler;
  cef_stream_writer_create_for_file_ptr cef_stream_writer_create_for_file;
  cef_stream_writer_create_for_handler_ptr cef_stream_writer_create_for_handler;
  cef_task_runner_get_for_current_thread_ptr
      cef_task_runner_get_for_current_thread;
  cef_task_runner_get_for_thread_ptr cef_task_runner_get_for_thread;
  cef_thread_create_ptr cef_thread_create;
  cef_urlrequest_create_ptr cef_urlrequest_create;
  cef_v8context_get_current_context_ptr cef_v8context_get_current_context;
  cef_v8context_get_entered_context_ptr cef_v8context_get_entered_context;
  cef_v8context_in_context_ptr cef_v8context_in_context;
  cef_v8value_create_undefined_ptr cef_v8value_create_undefined;
  cef_v8value_create_null_ptr cef_v8value_create_null;
  cef_v8value_create_bool_ptr cef_v8value_create_bool;
  cef_v8value_create_int_ptr cef_v8value_create_int;
  cef_v8value_create_uint_ptr cef_v8value_create_uint;
  cef_v8value_create_double_ptr cef_v8value_create_double;
  cef_v8value_create_date_ptr cef_v8value_create_date;
  cef_v8value_create_string_ptr cef_v8value_create_string;
  cef_v8value_create_object_ptr cef_v8value_create_object;
  cef_v8value_create_array_ptr cef_v8value_create_array;
  cef_v8value_create_array_buffer_ptr cef_v8value_create_array_buffer;
  cef_v8value_create_function_ptr cef_v8value_create_function;
  cef_v8stack_trace_get_current_ptr cef_v8stack_trace_get_current;
  cef_value_create_ptr cef_value_create;
  cef_binary_value_create_ptr cef_binary_value_create;
  cef_dictionary_value_create_ptr cef_dictionary_value_create;
  cef_list_value_create_ptr cef_list_value_create;
  cef_waitable_event_create_ptr cef_waitable_event_create;
  cef_xml_reader_create_ptr cef_xml_reader_create;
  cef_zip_reader_create_ptr cef_zip_reader_create;
  cef_translator_test_create_ptr cef_translator_test_create;
  cef_translator_test_ref_ptr_library_create_ptr
      cef_translator_test_ref_ptr_library_create;
  cef_translator_test_ref_ptr_library_child_create_ptr
      cef_translator_test_ref_ptr_library_child_create;
  cef_translator_test_ref_ptr_library_child_child_create_ptr
      cef_translator_test_ref_ptr_library_child_child_create;
  cef_translator_test_scoped_library_create_ptr
      cef_translator_test_scoped_library_create;
  cef_translator_test_scoped_library_child_create_ptr
      cef_translator_test_scoped_library_child_create;
  cef_translator_test_scoped_library_child_child_create_ptr
      cef_translator_test_scoped_library_child_child_create;
  cef_browser_view_create_ptr cef_browser_view_create;
  cef_browser_view_get_for_browser_ptr cef_browser_view_get_for_browser;
  cef_display_get_primary_ptr cef_display_get_primary;
  cef_display_get_nearest_point_ptr cef_display_get_nearest_point;
  cef_display_get_matching_bounds_ptr cef_display_get_matching_bounds;
  cef_display_get_count_ptr cef_display_get_count;
  cef_display_get_alls_ptr cef_display_get_alls;
  cef_label_button_create_ptr cef_label_button_create;
  cef_menu_button_create_ptr cef_menu_button_create;
  cef_panel_create_ptr cef_panel_create;
  cef_scroll_view_create_ptr cef_scroll_view_create;
  cef_textfield_create_ptr cef_textfield_create;
  cef_window_create_top_level_ptr cef_window_create_top_level;
  cef_api_hash_ptr cef_api_hash;
  cef_version_info_ptr cef_version_info;
  cef_get_min_log_level_ptr cef_get_min_log_level;
  cef_get_vlog_level_ptr cef_get_vlog_level;
  cef_log_ptr cef_log;
  cef_string_list_alloc_ptr cef_string_list_alloc;
  cef_string_list_size_ptr cef_string_list_size;
  cef_string_list_value_ptr cef_string_list_value;
  cef_string_list_append_ptr cef_string_list_append;
  cef_string_list_clear_ptr cef_string_list_clear;
  cef_string_list_free_ptr cef_string_list_free;
  cef_string_list_copy_ptr cef_string_list_copy;
  cef_string_map_alloc_ptr cef_string_map_alloc;
  cef_string_map_size_ptr cef_string_map_size;
  cef_string_map_find_ptr cef_string_map_find;
  cef_string_map_key_ptr cef_string_map_key;
  cef_string_map_value_ptr cef_string_map_value;
  cef_string_map_append_ptr cef_string_map_append;
  cef_string_map_clear_ptr cef_string_map_clear;
  cef_string_map_free_ptr cef_string_map_free;
  cef_string_multimap_alloc_ptr cef_string_multimap_alloc;
  cef_string_multimap_size_ptr cef_string_multimap_size;
  cef_string_multimap_find_count_ptr cef_string_multimap_find_count;
  cef_string_multimap_enumerate_ptr cef_string_multimap_enumerate;
  cef_string_multimap_key_ptr cef_string_multimap_key;
  cef_string_multimap_value_ptr cef_string_multimap_value;
  cef_string_multimap_append_ptr cef_string_multimap_append;
  cef_string_multimap_clear_ptr cef_string_multimap_clear;
  cef_string_multimap_free_ptr cef_string_multimap_free;
  cef_string_wide_set_ptr cef_string_wide_set;
  cef_string_utf8_set_ptr cef_string_utf8_set;
  cef_string_utf16_set_ptr cef_string_utf16_set;
  cef_string_wide_clear_ptr cef_string_wide_clear;
  cef_string_utf8_clear_ptr cef_string_utf8_clear;
  cef_string_utf16_clear_ptr cef_string_utf16_clear;
  cef_string_wide_cmp_ptr cef_string_wide_cmp;
  cef_string_utf8_cmp_ptr cef_string_utf8_cmp;
  cef_string_utf16_cmp_ptr cef_string_utf16_cmp;
  cef_string_wide_to_utf8_ptr cef_string_wide_to_utf8;
  cef_string_utf8_to_wide_ptr cef_string_utf8_to_wide;
  cef_string_wide_to_utf16_ptr cef_string_wide_to_utf16;
  cef_string_utf16_to_wide_ptr cef_string_utf16_to_wide;
  cef_string_utf8_to_utf16_ptr cef_string_utf8_to_utf16;
  cef_string_utf16_to_utf8_ptr cef_string_utf16_to_utf8;
  cef_string_ascii_to_wide_ptr cef_string_ascii_to_wide;
  cef_string_ascii_to_utf16_ptr cef_string_ascii_to_utf16;
  cef_string_userfree_wide_alloc_ptr cef_string_userfree_wide_alloc;
  cef_string_userfree_utf8_alloc_ptr cef_string_userfree_utf8_alloc;
  cef_string_userfree_utf16_alloc_ptr cef_string_userfree_utf16_alloc;
  cef_string_userfree_wide_free_ptr cef_string_userfree_wide_free;
  cef_string_userfree_utf8_free_ptr cef_string_userfree_utf8_free;
  cef_string_userfree_utf16_free_ptr cef_string_userfree_utf16_free;
  cef_string_utf16_to_lower_ptr cef_string_utf16_to_lower;
  cef_string_utf16_to_upper_ptr cef_string_utf16_to_upper;
  cef_get_current_platform_thread_id_ptr cef_get_current_platform_thread_id;
  cef_get_current_platform_thread_handle_ptr
      cef_get_current_platform_thread_handle;
  cef_time_to_timet_ptr cef_time_to_timet;
  cef_time_from_timet_ptr cef_time_from_timet;
  cef_time_to_doublet_ptr cef_time_to_doublet;
  cef_time_from_doublet_ptr cef_time_from_doublet;
  cef_time_now_ptr cef_time_now;
  cef_time_delta_ptr cef_time_delta;
  cef_trace_event_instant_ptr cef_trace_event_instant;
  cef_trace_event_begin_ptr cef_trace_event_begin;
  cef_trace_event_end_ptr cef_trace_event_end;
  cef_trace_counter_ptr cef_trace_counter;
  cef_trace_counter_id_ptr cef_trace_counter_id;
  cef_trace_event_async_begin_ptr cef_trace_event_async_begin;
  cef_trace_event_async_step_into_ptr cef_trace_event_async_step_into;
  cef_trace_event_async_step_past_ptr cef_trace_event_async_step_past;
  cef_trace_event_async_end_ptr cef_trace_event_async_end;

} g_libcef_pointers = {0};

#define INIT_ENTRY(name)                                            \
  g_libcef_pointers.name = (name##_ptr)libcef_get_ptr(path, #name); \
  if (!g_libcef_pointers.name) {                                    \
    return 0;                                                       \
  }

int libcef_init_pointers(const char* path) {
  INIT_ENTRY(cef_execute_process);
  INIT_ENTRY(cef_initialize);
  INIT_ENTRY(cef_shutdown);
  INIT_ENTRY(cef_do_message_loop_work);
  INIT_ENTRY(cef_run_message_loop);
  INIT_ENTRY(cef_quit_message_loop);
  INIT_ENTRY(cef_set_osmodal_loop);
  INIT_ENTRY(cef_enable_highdpi_support);
  INIT_ENTRY(cef_crash_reporting_enabled);
  INIT_ENTRY(cef_set_crash_key_value);
  INIT_ENTRY(cef_create_directory);
  INIT_ENTRY(cef_get_temp_directory);
  INIT_ENTRY(cef_create_new_temp_directory);
  INIT_ENTRY(cef_create_temp_directory_in_directory);
  INIT_ENTRY(cef_directory_exists);
  INIT_ENTRY(cef_delete_file);
  INIT_ENTRY(cef_zip_directory);
  INIT_ENTRY(cef_load_crlsets_file);
  INIT_ENTRY(cef_add_cross_origin_whitelist_entry);
  INIT_ENTRY(cef_remove_cross_origin_whitelist_entry);
  INIT_ENTRY(cef_clear_cross_origin_whitelist);
  INIT_ENTRY(cef_parse_url);
  INIT_ENTRY(cef_create_url);
  INIT_ENTRY(cef_format_url_for_security_display);
  INIT_ENTRY(cef_get_mime_type);
  INIT_ENTRY(cef_get_extensions_for_mime_type);
  INIT_ENTRY(cef_base64encode);
  INIT_ENTRY(cef_base64decode);
  INIT_ENTRY(cef_uriencode);
  INIT_ENTRY(cef_uridecode);
  INIT_ENTRY(cef_parse_json);
  INIT_ENTRY(cef_parse_json_buffer);
  INIT_ENTRY(cef_parse_jsonand_return_error);
  INIT_ENTRY(cef_write_json);
  INIT_ENTRY(cef_get_path);
  INIT_ENTRY(cef_launch_process);
  INIT_ENTRY(cef_register_scheme_handler_factory);
  INIT_ENTRY(cef_clear_scheme_handler_factories);
  INIT_ENTRY(cef_is_cert_status_error);
  INIT_ENTRY(cef_currently_on);
  INIT_ENTRY(cef_post_task);
  INIT_ENTRY(cef_post_delayed_task);
  INIT_ENTRY(cef_begin_tracing);
  INIT_ENTRY(cef_end_tracing);
  INIT_ENTRY(cef_now_from_system_trace_time);
  INIT_ENTRY(cef_register_extension);
  INIT_ENTRY(cef_visit_web_plugin_info);
  INIT_ENTRY(cef_refresh_web_plugins);
  INIT_ENTRY(cef_unregister_internal_web_plugin);
  INIT_ENTRY(cef_register_web_plugin_crash);
  INIT_ENTRY(cef_is_web_plugin_unstable);
  INIT_ENTRY(cef_register_widevine_cdm);
  INIT_ENTRY(cef_execute_java_script_with_user_gesture_for_tests);
  INIT_ENTRY(cef_browser_host_create_browser);
  INIT_ENTRY(cef_browser_host_create_browser_sync);
  INIT_ENTRY(cef_command_line_create);
  INIT_ENTRY(cef_command_line_get_global);
  INIT_ENTRY(cef_cookie_manager_get_global_manager);
  INIT_ENTRY(cef_drag_data_create);
  INIT_ENTRY(cef_image_create);
  INIT_ENTRY(cef_media_router_get_global);
  INIT_ENTRY(cef_menu_model_create);
  INIT_ENTRY(cef_print_settings_create);
  INIT_ENTRY(cef_process_message_create);
  INIT_ENTRY(cef_request_create);
  INIT_ENTRY(cef_post_data_create);
  INIT_ENTRY(cef_post_data_element_create);
  INIT_ENTRY(cef_request_context_get_global_context);
  INIT_ENTRY(cef_request_context_create_context);
  INIT_ENTRY(cef_create_context_shared);
  INIT_ENTRY(cef_resource_bundle_get_global);
  INIT_ENTRY(cef_response_create);
  INIT_ENTRY(cef_server_create);
  INIT_ENTRY(cef_stream_reader_create_for_file);
  INIT_ENTRY(cef_stream_reader_create_for_data);
  INIT_ENTRY(cef_stream_reader_create_for_handler);
  INIT_ENTRY(cef_stream_writer_create_for_file);
  INIT_ENTRY(cef_stream_writer_create_for_handler);
  INIT_ENTRY(cef_task_runner_get_for_current_thread);
  INIT_ENTRY(cef_task_runner_get_for_thread);
  INIT_ENTRY(cef_thread_create);
  INIT_ENTRY(cef_urlrequest_create);
  INIT_ENTRY(cef_v8context_get_current_context);
  INIT_ENTRY(cef_v8context_get_entered_context);
  INIT_ENTRY(cef_v8context_in_context);
  INIT_ENTRY(cef_v8value_create_undefined);
  INIT_ENTRY(cef_v8value_create_null);
  INIT_ENTRY(cef_v8value_create_bool);
  INIT_ENTRY(cef_v8value_create_int);
  INIT_ENTRY(cef_v8value_create_uint);
  INIT_ENTRY(cef_v8value_create_double);
  INIT_ENTRY(cef_v8value_create_date);
  INIT_ENTRY(cef_v8value_create_string);
  INIT_ENTRY(cef_v8value_create_object);
  INIT_ENTRY(cef_v8value_create_array);
  INIT_ENTRY(cef_v8value_create_array_buffer);
  INIT_ENTRY(cef_v8value_create_function);
  INIT_ENTRY(cef_v8stack_trace_get_current);
  INIT_ENTRY(cef_value_create);
  INIT_ENTRY(cef_binary_value_create);
  INIT_ENTRY(cef_dictionary_value_create);
  INIT_ENTRY(cef_list_value_create);
  INIT_ENTRY(cef_waitable_event_create);
  INIT_ENTRY(cef_xml_reader_create);
  INIT_ENTRY(cef_zip_reader_create);
  INIT_ENTRY(cef_translator_test_create);
  INIT_ENTRY(cef_translator_test_ref_ptr_library_create);
  INIT_ENTRY(cef_translator_test_ref_ptr_library_child_create);
  INIT_ENTRY(cef_translator_test_ref_ptr_library_child_child_create);
  INIT_ENTRY(cef_translator_test_scoped_library_create);
  INIT_ENTRY(cef_translator_test_scoped_library_child_create);
  INIT_ENTRY(cef_translator_test_scoped_library_child_child_create);
  INIT_ENTRY(cef_browser_view_create);
  INIT_ENTRY(cef_browser_view_get_for_browser);
  INIT_ENTRY(cef_display_get_primary);
  INIT_ENTRY(cef_display_get_nearest_point);
  INIT_ENTRY(cef_display_get_matching_bounds);
  INIT_ENTRY(cef_display_get_count);
  INIT_ENTRY(cef_display_get_alls);
  INIT_ENTRY(cef_label_button_create);
  INIT_ENTRY(cef_menu_button_create);
  INIT_ENTRY(cef_panel_create);
  INIT_ENTRY(cef_scroll_view_create);
  INIT_ENTRY(cef_textfield_create);
  INIT_ENTRY(cef_window_create_top_level);
  INIT_ENTRY(cef_api_hash);
  INIT_ENTRY(cef_version_info);
  INIT_ENTRY(cef_get_min_log_level);
  INIT_ENTRY(cef_get_vlog_level);
  INIT_ENTRY(cef_log);
  INIT_ENTRY(cef_string_list_alloc);
  INIT_ENTRY(cef_string_list_size);
  INIT_ENTRY(cef_string_list_value);
  INIT_ENTRY(cef_string_list_append);
  INIT_ENTRY(cef_string_list_clear);
  INIT_ENTRY(cef_string_list_free);
  INIT_ENTRY(cef_string_list_copy);
  INIT_ENTRY(cef_string_map_alloc);
  INIT_ENTRY(cef_string_map_size);
  INIT_ENTRY(cef_string_map_find);
  INIT_ENTRY(cef_string_map_key);
  INIT_ENTRY(cef_string_map_value);
  INIT_ENTRY(cef_string_map_append);
  INIT_ENTRY(cef_string_map_clear);
  INIT_ENTRY(cef_string_map_free);
  INIT_ENTRY(cef_string_multimap_alloc);
  INIT_ENTRY(cef_string_multimap_size);
  INIT_ENTRY(cef_string_multimap_find_count);
  INIT_ENTRY(cef_string_multimap_enumerate);
  INIT_ENTRY(cef_string_multimap_key);
  INIT_ENTRY(cef_string_multimap_value);
  INIT_ENTRY(cef_string_multimap_append);
  INIT_ENTRY(cef_string_multimap_clear);
  INIT_ENTRY(cef_string_multimap_free);
  INIT_ENTRY(cef_string_wide_set);
  INIT_ENTRY(cef_string_utf8_set);
  INIT_ENTRY(cef_string_utf16_set);
  INIT_ENTRY(cef_string_wide_clear);
  INIT_ENTRY(cef_string_utf8_clear);
  INIT_ENTRY(cef_string_utf16_clear);
  INIT_ENTRY(cef_string_wide_cmp);
  INIT_ENTRY(cef_string_utf8_cmp);
  INIT_ENTRY(cef_string_utf16_cmp);
  INIT_ENTRY(cef_string_wide_to_utf8);
  INIT_ENTRY(cef_string_utf8_to_wide);
  INIT_ENTRY(cef_string_wide_to_utf16);
  INIT_ENTRY(cef_string_utf16_to_wide);
  INIT_ENTRY(cef_string_utf8_to_utf16);
  INIT_ENTRY(cef_string_utf16_to_utf8);
  INIT_ENTRY(cef_string_ascii_to_wide);
  INIT_ENTRY(cef_string_ascii_to_utf16);
  INIT_ENTRY(cef_string_userfree_wide_alloc);
  INIT_ENTRY(cef_string_userfree_utf8_alloc);
  INIT_ENTRY(cef_string_userfree_utf16_alloc);
  INIT_ENTRY(cef_string_userfree_wide_free);
  INIT_ENTRY(cef_string_userfree_utf8_free);
  INIT_ENTRY(cef_string_userfree_utf16_free);
  INIT_ENTRY(cef_string_utf16_to_lower);
  INIT_ENTRY(cef_string_utf16_to_upper);
  INIT_ENTRY(cef_get_current_platform_thread_id);
  INIT_ENTRY(cef_get_current_platform_thread_handle);
  INIT_ENTRY(cef_time_to_timet);
  INIT_ENTRY(cef_time_from_timet);
  INIT_ENTRY(cef_time_to_doublet);
  INIT_ENTRY(cef_time_from_doublet);
  INIT_ENTRY(cef_time_now);
  INIT_ENTRY(cef_time_delta);
  INIT_ENTRY(cef_trace_event_instant);
  INIT_ENTRY(cef_trace_event_begin);
  INIT_ENTRY(cef_trace_event_end);
  INIT_ENTRY(cef_trace_counter);
  INIT_ENTRY(cef_trace_counter_id);
  INIT_ENTRY(cef_trace_event_async_begin);
  INIT_ENTRY(cef_trace_event_async_step_into);
  INIT_ENTRY(cef_trace_event_async_step_past);
  INIT_ENTRY(cef_trace_event_async_end);
  return 1;
}

}  // namespace

int cef_load_library(const char* path) {
  if (g_libcef_handle)
    return 0;

  g_libcef_handle = dlopen(path, RTLD_LAZY | RTLD_LOCAL | RTLD_FIRST);
  if (!g_libcef_handle) {
    fprintf(stderr, "dlopen %s: %s\n", path, dlerror());
    return 0;
  }

  if (!libcef_init_pointers(path)) {
    cef_unload_library();
    return 0;
  }

  return 1;
}

int cef_unload_library() {
  int result = 0;
  if (g_libcef_handle) {
    result = !dlclose(g_libcef_handle);
    if (!result) {
      fprintf(stderr, "dlclose: %s\n", dlerror());
    }
    g_libcef_handle = nullptr;
  }
  return result;
}

NO_SANITIZE("cfi-icall")
int cef_execute_process(const struct _cef_main_args_t* args,
                        struct _cef_app_t* application,
                        void* windows_sandbox_info) {
  return g_libcef_pointers.cef_execute_process(args, application,
                                               windows_sandbox_info);
}

NO_SANITIZE("cfi-icall")
int cef_initialize(const struct _cef_main_args_t* args,
                   const struct _cef_settings_t* settings,
                   struct _cef_app_t* application,
                   void* windows_sandbox_info) {
  return g_libcef_pointers.cef_initialize(args, settings, application,
                                          windows_sandbox_info);
}

NO_SANITIZE("cfi-icall") void cef_shutdown() {
  g_libcef_pointers.cef_shutdown();
}

NO_SANITIZE("cfi-icall") void cef_do_message_loop_work() {
  g_libcef_pointers.cef_do_message_loop_work();
}

NO_SANITIZE("cfi-icall") void cef_run_message_loop() {
  g_libcef_pointers.cef_run_message_loop();
}

NO_SANITIZE("cfi-icall") void cef_quit_message_loop() {
  g_libcef_pointers.cef_quit_message_loop();
}

NO_SANITIZE("cfi-icall") void cef_set_osmodal_loop(int osModalLoop) {
  g_libcef_pointers.cef_set_osmodal_loop(osModalLoop);
}

NO_SANITIZE("cfi-icall") void cef_enable_highdpi_support() {
  g_libcef_pointers.cef_enable_highdpi_support();
}

NO_SANITIZE("cfi-icall") int cef_crash_reporting_enabled() {
  return g_libcef_pointers.cef_crash_reporting_enabled();
}

NO_SANITIZE("cfi-icall")
void cef_set_crash_key_value(const cef_string_t* key,
                             const cef_string_t* value) {
  g_libcef_pointers.cef_set_crash_key_value(key, value);
}

NO_SANITIZE("cfi-icall")
int cef_create_directory(const cef_string_t* full_path) {
  return g_libcef_pointers.cef_create_directory(full_path);
}

NO_SANITIZE("cfi-icall") int cef_get_temp_directory(cef_string_t* temp_dir) {
  return g_libcef_pointers.cef_get_temp_directory(temp_dir);
}

NO_SANITIZE("cfi-icall")
int cef_create_new_temp_directory(const cef_string_t* prefix,
                                  cef_string_t* new_temp_path) {
  return g_libcef_pointers.cef_create_new_temp_directory(prefix, new_temp_path);
}

NO_SANITIZE("cfi-icall")
int cef_create_temp_directory_in_directory(const cef_string_t* base_dir,
                                           const cef_string_t* prefix,
                                           cef_string_t* new_dir) {
  return g_libcef_pointers.cef_create_temp_directory_in_directory(
      base_dir, prefix, new_dir);
}

NO_SANITIZE("cfi-icall") int cef_directory_exists(const cef_string_t* path) {
  return g_libcef_pointers.cef_directory_exists(path);
}

NO_SANITIZE("cfi-icall")
int cef_delete_file(const cef_string_t* path, int recursive) {
  return g_libcef_pointers.cef_delete_file(path, recursive);
}

NO_SANITIZE("cfi-icall")
int cef_zip_directory(const cef_string_t* src_dir,
                      const cef_string_t* dest_file,
                      int include_hidden_files) {
  return g_libcef_pointers.cef_zip_directory(src_dir, dest_file,
                                             include_hidden_files);
}

NO_SANITIZE("cfi-icall") void cef_load_crlsets_file(const cef_string_t* path) {
  g_libcef_pointers.cef_load_crlsets_file(path);
}

NO_SANITIZE("cfi-icall")
int cef_add_cross_origin_whitelist_entry(const cef_string_t* source_origin,
                                         const cef_string_t* target_protocol,
                                         const cef_string_t* target_domain,
                                         int allow_target_subdomains) {
  return g_libcef_pointers.cef_add_cross_origin_whitelist_entry(
      source_origin, target_protocol, target_domain, allow_target_subdomains);
}

NO_SANITIZE("cfi-icall")
int cef_remove_cross_origin_whitelist_entry(const cef_string_t* source_origin,
                                            const cef_string_t* target_protocol,
                                            const cef_string_t* target_domain,
                                            int allow_target_subdomains) {
  return g_libcef_pointers.cef_remove_cross_origin_whitelist_entry(
      source_origin, target_protocol, target_domain, allow_target_subdomains);
}

NO_SANITIZE("cfi-icall") int cef_clear_cross_origin_whitelist() {
  return g_libcef_pointers.cef_clear_cross_origin_whitelist();
}

NO_SANITIZE("cfi-icall")
int cef_parse_url(const cef_string_t* url, struct _cef_urlparts_t* parts) {
  return g_libcef_pointers.cef_parse_url(url, parts);
}

NO_SANITIZE("cfi-icall")
int cef_create_url(const struct _cef_urlparts_t* parts, cef_string_t* url) {
  return g_libcef_pointers.cef_create_url(parts, url);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_t cef_format_url_for_security_display(
    const cef_string_t* origin_url) {
  return g_libcef_pointers.cef_format_url_for_security_display(origin_url);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_t cef_get_mime_type(const cef_string_t* extension) {
  return g_libcef_pointers.cef_get_mime_type(extension);
}

NO_SANITIZE("cfi-icall")
void cef_get_extensions_for_mime_type(const cef_string_t* mime_type,
                                      cef_string_list_t extensions) {
  g_libcef_pointers.cef_get_extensions_for_mime_type(mime_type, extensions);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_t cef_base64encode(const void* data, size_t data_size) {
  return g_libcef_pointers.cef_base64encode(data, data_size);
}

NO_SANITIZE("cfi-icall")
struct _cef_binary_value_t* cef_base64decode(const cef_string_t* data) {
  return g_libcef_pointers.cef_base64decode(data);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_t cef_uriencode(const cef_string_t* text, int use_plus) {
  return g_libcef_pointers.cef_uriencode(text, use_plus);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_t cef_uridecode(const cef_string_t* text,
                                    int convert_to_utf8,
                                    cef_uri_unescape_rule_t unescape_rule) {
  return g_libcef_pointers.cef_uridecode(text, convert_to_utf8, unescape_rule);
}

NO_SANITIZE("cfi-icall")
struct _cef_value_t* cef_parse_json(const cef_string_t* json_string,
                                    cef_json_parser_options_t options) {
  return g_libcef_pointers.cef_parse_json(json_string, options);
}

NO_SANITIZE("cfi-icall")
struct _cef_value_t* cef_parse_json_buffer(const void* json,
                                           size_t json_size,
                                           cef_json_parser_options_t options) {
  return g_libcef_pointers.cef_parse_json_buffer(json, json_size, options);
}

NO_SANITIZE("cfi-icall")
struct _cef_value_t* cef_parse_jsonand_return_error(
    const cef_string_t* json_string,
    cef_json_parser_options_t options,
    cef_string_t* error_msg_out) {
  return g_libcef_pointers.cef_parse_jsonand_return_error(json_string, options,
                                                          error_msg_out);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_t cef_write_json(struct _cef_value_t* node,
                                     cef_json_writer_options_t options) {
  return g_libcef_pointers.cef_write_json(node, options);
}

NO_SANITIZE("cfi-icall")
int cef_get_path(cef_path_key_t key, cef_string_t* path) {
  return g_libcef_pointers.cef_get_path(key, path);
}

NO_SANITIZE("cfi-icall")
int cef_launch_process(struct _cef_command_line_t* command_line) {
  return g_libcef_pointers.cef_launch_process(command_line);
}

NO_SANITIZE("cfi-icall")
int cef_register_scheme_handler_factory(
    const cef_string_t* scheme_name,
    const cef_string_t* domain_name,
    struct _cef_scheme_handler_factory_t* factory) {
  return g_libcef_pointers.cef_register_scheme_handler_factory(
      scheme_name, domain_name, factory);
}

NO_SANITIZE("cfi-icall") int cef_clear_scheme_handler_factories() {
  return g_libcef_pointers.cef_clear_scheme_handler_factories();
}

NO_SANITIZE("cfi-icall")
int cef_is_cert_status_error(cef_cert_status_t status) {
  return g_libcef_pointers.cef_is_cert_status_error(status);
}

NO_SANITIZE("cfi-icall") int cef_currently_on(cef_thread_id_t threadId) {
  return g_libcef_pointers.cef_currently_on(threadId);
}

NO_SANITIZE("cfi-icall")
int cef_post_task(cef_thread_id_t threadId, struct _cef_task_t* task) {
  return g_libcef_pointers.cef_post_task(threadId, task);
}

NO_SANITIZE("cfi-icall")
int cef_post_delayed_task(cef_thread_id_t threadId,
                          struct _cef_task_t* task,
                          int64 delay_ms) {
  return g_libcef_pointers.cef_post_delayed_task(threadId, task, delay_ms);
}

NO_SANITIZE("cfi-icall")
int cef_begin_tracing(const cef_string_t* categories,
                      struct _cef_completion_callback_t* callback) {
  return g_libcef_pointers.cef_begin_tracing(categories, callback);
}

NO_SANITIZE("cfi-icall")
int cef_end_tracing(const cef_string_t* tracing_file,
                    struct _cef_end_tracing_callback_t* callback) {
  return g_libcef_pointers.cef_end_tracing(tracing_file, callback);
}

NO_SANITIZE("cfi-icall") int64 cef_now_from_system_trace_time() {
  return g_libcef_pointers.cef_now_from_system_trace_time();
}

NO_SANITIZE("cfi-icall")
int cef_register_extension(const cef_string_t* extension_name,
                           const cef_string_t* javascript_code,
                           struct _cef_v8handler_t* handler) {
  return g_libcef_pointers.cef_register_extension(extension_name,
                                                  javascript_code, handler);
}

NO_SANITIZE("cfi-icall")
void cef_visit_web_plugin_info(struct _cef_web_plugin_info_visitor_t* visitor) {
  g_libcef_pointers.cef_visit_web_plugin_info(visitor);
}

NO_SANITIZE("cfi-icall") void cef_refresh_web_plugins() {
  g_libcef_pointers.cef_refresh_web_plugins();
}

NO_SANITIZE("cfi-icall")
void cef_unregister_internal_web_plugin(const cef_string_t* path) {
  g_libcef_pointers.cef_unregister_internal_web_plugin(path);
}

NO_SANITIZE("cfi-icall")
void cef_register_web_plugin_crash(const cef_string_t* path) {
  g_libcef_pointers.cef_register_web_plugin_crash(path);
}

NO_SANITIZE("cfi-icall")
void cef_is_web_plugin_unstable(
    const cef_string_t* path,
    struct _cef_web_plugin_unstable_callback_t* callback) {
  g_libcef_pointers.cef_is_web_plugin_unstable(path, callback);
}

NO_SANITIZE("cfi-icall")
void cef_register_widevine_cdm(const cef_string_t* path,
                               struct _cef_register_cdm_callback_t* callback) {
  g_libcef_pointers.cef_register_widevine_cdm(path, callback);
}

NO_SANITIZE("cfi-icall")
void cef_execute_java_script_with_user_gesture_for_tests(
    struct _cef_frame_t* frame,
    const cef_string_t* javascript) {
  g_libcef_pointers.cef_execute_java_script_with_user_gesture_for_tests(
      frame, javascript);
}

NO_SANITIZE("cfi-icall")
int cef_browser_host_create_browser(
    const struct _cef_window_info_t* windowInfo,
    struct _cef_client_t* client,
    const cef_string_t* url,
    const struct _cef_browser_settings_t* settings,
    struct _cef_dictionary_value_t* extra_info,
    struct _cef_request_context_t* request_context) {
  return g_libcef_pointers.cef_browser_host_create_browser(
      windowInfo, client, url, settings, extra_info, request_context);
}

NO_SANITIZE("cfi-icall")
struct _cef_browser_t* cef_browser_host_create_browser_sync(
    const struct _cef_window_info_t* windowInfo,
    struct _cef_client_t* client,
    const cef_string_t* url,
    const struct _cef_browser_settings_t* settings,
    struct _cef_dictionary_value_t* extra_info,
    struct _cef_request_context_t* request_context) {
  return g_libcef_pointers.cef_browser_host_create_browser_sync(
      windowInfo, client, url, settings, extra_info, request_context);
}

NO_SANITIZE("cfi-icall") struct _cef_command_line_t* cef_command_line_create() {
  return g_libcef_pointers.cef_command_line_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_command_line_t* cef_command_line_get_global() {
  return g_libcef_pointers.cef_command_line_get_global();
}

NO_SANITIZE("cfi-icall")
struct _cef_cookie_manager_t* cef_cookie_manager_get_global_manager(
    struct _cef_completion_callback_t* callback) {
  return g_libcef_pointers.cef_cookie_manager_get_global_manager(callback);
}

NO_SANITIZE("cfi-icall") struct _cef_drag_data_t* cef_drag_data_create() {
  return g_libcef_pointers.cef_drag_data_create();
}

NO_SANITIZE("cfi-icall") struct _cef_image_t* cef_image_create() {
  return g_libcef_pointers.cef_image_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_media_router_t* cef_media_router_get_global(
    struct _cef_completion_callback_t* callback) {
  return g_libcef_pointers.cef_media_router_get_global(callback);
}

NO_SANITIZE("cfi-icall")
struct _cef_menu_model_t* cef_menu_model_create(
    struct _cef_menu_model_delegate_t* delegate) {
  return g_libcef_pointers.cef_menu_model_create(delegate);
}

NO_SANITIZE("cfi-icall")
struct _cef_print_settings_t* cef_print_settings_create() {
  return g_libcef_pointers.cef_print_settings_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_process_message_t* cef_process_message_create(
    const cef_string_t* name) {
  return g_libcef_pointers.cef_process_message_create(name);
}

NO_SANITIZE("cfi-icall") struct _cef_request_t* cef_request_create() {
  return g_libcef_pointers.cef_request_create();
}

NO_SANITIZE("cfi-icall") struct _cef_post_data_t* cef_post_data_create() {
  return g_libcef_pointers.cef_post_data_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_post_data_element_t* cef_post_data_element_create() {
  return g_libcef_pointers.cef_post_data_element_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_request_context_t* cef_request_context_get_global_context() {
  return g_libcef_pointers.cef_request_context_get_global_context();
}

NO_SANITIZE("cfi-icall")
struct _cef_request_context_t* cef_request_context_create_context(
    const struct _cef_request_context_settings_t* settings,
    struct _cef_request_context_handler_t* handler) {
  return g_libcef_pointers.cef_request_context_create_context(settings,
                                                              handler);
}

NO_SANITIZE("cfi-icall")
struct _cef_request_context_t* cef_create_context_shared(
    struct _cef_request_context_t* other,
    struct _cef_request_context_handler_t* handler) {
  return g_libcef_pointers.cef_create_context_shared(other, handler);
}

NO_SANITIZE("cfi-icall")
struct _cef_resource_bundle_t* cef_resource_bundle_get_global() {
  return g_libcef_pointers.cef_resource_bundle_get_global();
}

NO_SANITIZE("cfi-icall") struct _cef_response_t* cef_response_create() {
  return g_libcef_pointers.cef_response_create();
}

NO_SANITIZE("cfi-icall")
void cef_server_create(const cef_string_t* address,
                       uint16 port,
                       int backlog,
                       struct _cef_server_handler_t* handler) {
  g_libcef_pointers.cef_server_create(address, port, backlog, handler);
}

NO_SANITIZE("cfi-icall")
struct _cef_stream_reader_t* cef_stream_reader_create_for_file(
    const cef_string_t* fileName) {
  return g_libcef_pointers.cef_stream_reader_create_for_file(fileName);
}

NO_SANITIZE("cfi-icall")
struct _cef_stream_reader_t* cef_stream_reader_create_for_data(void* data,
                                                               size_t size) {
  return g_libcef_pointers.cef_stream_reader_create_for_data(data, size);
}

NO_SANITIZE("cfi-icall")
struct _cef_stream_reader_t* cef_stream_reader_create_for_handler(
    struct _cef_read_handler_t* handler) {
  return g_libcef_pointers.cef_stream_reader_create_for_handler(handler);
}

NO_SANITIZE("cfi-icall")
struct _cef_stream_writer_t* cef_stream_writer_create_for_file(
    const cef_string_t* fileName) {
  return g_libcef_pointers.cef_stream_writer_create_for_file(fileName);
}

NO_SANITIZE("cfi-icall")
struct _cef_stream_writer_t* cef_stream_writer_create_for_handler(
    struct _cef_write_handler_t* handler) {
  return g_libcef_pointers.cef_stream_writer_create_for_handler(handler);
}

NO_SANITIZE("cfi-icall")
struct _cef_task_runner_t* cef_task_runner_get_for_current_thread() {
  return g_libcef_pointers.cef_task_runner_get_for_current_thread();
}

NO_SANITIZE("cfi-icall")
struct _cef_task_runner_t* cef_task_runner_get_for_thread(
    cef_thread_id_t threadId) {
  return g_libcef_pointers.cef_task_runner_get_for_thread(threadId);
}

NO_SANITIZE("cfi-icall")
struct _cef_thread_t* cef_thread_create(
    const cef_string_t* display_name,
    cef_thread_priority_t priority,
    cef_message_loop_type_t message_loop_type,
    int stoppable,
    cef_com_init_mode_t com_init_mode) {
  return g_libcef_pointers.cef_thread_create(
      display_name, priority, message_loop_type, stoppable, com_init_mode);
}

NO_SANITIZE("cfi-icall")
struct _cef_urlrequest_t* cef_urlrequest_create(
    struct _cef_request_t* request,
    struct _cef_urlrequest_client_t* client,
    struct _cef_request_context_t* request_context) {
  return g_libcef_pointers.cef_urlrequest_create(request, client,
                                                 request_context);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8context_t* cef_v8context_get_current_context() {
  return g_libcef_pointers.cef_v8context_get_current_context();
}

NO_SANITIZE("cfi-icall")
struct _cef_v8context_t* cef_v8context_get_entered_context() {
  return g_libcef_pointers.cef_v8context_get_entered_context();
}

NO_SANITIZE("cfi-icall") int cef_v8context_in_context() {
  return g_libcef_pointers.cef_v8context_in_context();
}

NO_SANITIZE("cfi-icall") struct _cef_v8value_t* cef_v8value_create_undefined() {
  return g_libcef_pointers.cef_v8value_create_undefined();
}

NO_SANITIZE("cfi-icall") struct _cef_v8value_t* cef_v8value_create_null() {
  return g_libcef_pointers.cef_v8value_create_null();
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_bool(int value) {
  return g_libcef_pointers.cef_v8value_create_bool(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_int(int32 value) {
  return g_libcef_pointers.cef_v8value_create_int(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_uint(uint32 value) {
  return g_libcef_pointers.cef_v8value_create_uint(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_double(double value) {
  return g_libcef_pointers.cef_v8value_create_double(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_date(const cef_time_t* date) {
  return g_libcef_pointers.cef_v8value_create_date(date);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_string(const cef_string_t* value) {
  return g_libcef_pointers.cef_v8value_create_string(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_object(
    struct _cef_v8accessor_t* accessor,
    struct _cef_v8interceptor_t* interceptor) {
  return g_libcef_pointers.cef_v8value_create_object(accessor, interceptor);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_array(int length) {
  return g_libcef_pointers.cef_v8value_create_array(length);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_array_buffer(
    void* buffer,
    size_t length,
    struct _cef_v8array_buffer_release_callback_t* release_callback) {
  return g_libcef_pointers.cef_v8value_create_array_buffer(buffer, length,
                                                           release_callback);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8value_t* cef_v8value_create_function(
    const cef_string_t* name,
    struct _cef_v8handler_t* handler) {
  return g_libcef_pointers.cef_v8value_create_function(name, handler);
}

NO_SANITIZE("cfi-icall")
struct _cef_v8stack_trace_t* cef_v8stack_trace_get_current(int frame_limit) {
  return g_libcef_pointers.cef_v8stack_trace_get_current(frame_limit);
}

NO_SANITIZE("cfi-icall") struct _cef_value_t* cef_value_create() {
  return g_libcef_pointers.cef_value_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_binary_value_t* cef_binary_value_create(const void* data,
                                                    size_t data_size) {
  return g_libcef_pointers.cef_binary_value_create(data, data_size);
}

NO_SANITIZE("cfi-icall")
struct _cef_dictionary_value_t* cef_dictionary_value_create() {
  return g_libcef_pointers.cef_dictionary_value_create();
}

NO_SANITIZE("cfi-icall") struct _cef_list_value_t* cef_list_value_create() {
  return g_libcef_pointers.cef_list_value_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_waitable_event_t* cef_waitable_event_create(
    int automatic_reset,
    int initially_signaled) {
  return g_libcef_pointers.cef_waitable_event_create(automatic_reset,
                                                     initially_signaled);
}

NO_SANITIZE("cfi-icall")
struct _cef_xml_reader_t* cef_xml_reader_create(
    struct _cef_stream_reader_t* stream,
    cef_xml_encoding_type_t encodingType,
    const cef_string_t* URI) {
  return g_libcef_pointers.cef_xml_reader_create(stream, encodingType, URI);
}

NO_SANITIZE("cfi-icall")
struct _cef_zip_reader_t* cef_zip_reader_create(
    struct _cef_stream_reader_t* stream) {
  return g_libcef_pointers.cef_zip_reader_create(stream);
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_t* cef_translator_test_create() {
  return g_libcef_pointers.cef_translator_test_create();
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_ref_ptr_library_t*
cef_translator_test_ref_ptr_library_create(int value) {
  return g_libcef_pointers.cef_translator_test_ref_ptr_library_create(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_ref_ptr_library_child_t*
cef_translator_test_ref_ptr_library_child_create(int value, int other_value) {
  return g_libcef_pointers.cef_translator_test_ref_ptr_library_child_create(
      value, other_value);
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_ref_ptr_library_child_child_t*
cef_translator_test_ref_ptr_library_child_child_create(int value,
                                                       int other_value,
                                                       int other_other_value) {
  return g_libcef_pointers
      .cef_translator_test_ref_ptr_library_child_child_create(
          value, other_value, other_other_value);
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_scoped_library_t*
cef_translator_test_scoped_library_create(int value) {
  return g_libcef_pointers.cef_translator_test_scoped_library_create(value);
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_scoped_library_child_t*
cef_translator_test_scoped_library_child_create(int value, int other_value) {
  return g_libcef_pointers.cef_translator_test_scoped_library_child_create(
      value, other_value);
}

NO_SANITIZE("cfi-icall")
struct _cef_translator_test_scoped_library_child_child_t*
cef_translator_test_scoped_library_child_child_create(int value,
                                                      int other_value,
                                                      int other_other_value) {
  return g_libcef_pointers
      .cef_translator_test_scoped_library_child_child_create(value, other_value,
                                                             other_other_value);
}

NO_SANITIZE("cfi-icall")
struct _cef_browser_view_t* cef_browser_view_create(
    struct _cef_client_t* client,
    const cef_string_t* url,
    const struct _cef_browser_settings_t* settings,
    struct _cef_dictionary_value_t* extra_info,
    struct _cef_request_context_t* request_context,
    struct _cef_browser_view_delegate_t* delegate) {
  return g_libcef_pointers.cef_browser_view_create(
      client, url, settings, extra_info, request_context, delegate);
}

NO_SANITIZE("cfi-icall")
struct _cef_browser_view_t* cef_browser_view_get_for_browser(
    struct _cef_browser_t* browser) {
  return g_libcef_pointers.cef_browser_view_get_for_browser(browser);
}

NO_SANITIZE("cfi-icall") struct _cef_display_t* cef_display_get_primary() {
  return g_libcef_pointers.cef_display_get_primary();
}

NO_SANITIZE("cfi-icall")
struct _cef_display_t* cef_display_get_nearest_point(const cef_point_t* point,
                                                     int input_pixel_coords) {
  return g_libcef_pointers.cef_display_get_nearest_point(point,
                                                         input_pixel_coords);
}

NO_SANITIZE("cfi-icall")
struct _cef_display_t* cef_display_get_matching_bounds(const cef_rect_t* bounds,
                                                       int input_pixel_coords) {
  return g_libcef_pointers.cef_display_get_matching_bounds(bounds,
                                                           input_pixel_coords);
}

NO_SANITIZE("cfi-icall") size_t cef_display_get_count() {
  return g_libcef_pointers.cef_display_get_count();
}

NO_SANITIZE("cfi-icall")
void cef_display_get_alls(size_t* displaysCount,
                          struct _cef_display_t** displays) {
  g_libcef_pointers.cef_display_get_alls(displaysCount, displays);
}

NO_SANITIZE("cfi-icall")
struct _cef_label_button_t* cef_label_button_create(
    struct _cef_button_delegate_t* delegate,
    const cef_string_t* text) {
  return g_libcef_pointers.cef_label_button_create(delegate, text);
}

NO_SANITIZE("cfi-icall")
struct _cef_menu_button_t* cef_menu_button_create(
    struct _cef_menu_button_delegate_t* delegate,
    const cef_string_t* text) {
  return g_libcef_pointers.cef_menu_button_create(delegate, text);
}

NO_SANITIZE("cfi-icall")
struct _cef_panel_t* cef_panel_create(struct _cef_panel_delegate_t* delegate) {
  return g_libcef_pointers.cef_panel_create(delegate);
}

NO_SANITIZE("cfi-icall")
struct _cef_scroll_view_t* cef_scroll_view_create(
    struct _cef_view_delegate_t* delegate) {
  return g_libcef_pointers.cef_scroll_view_create(delegate);
}

NO_SANITIZE("cfi-icall")
struct _cef_textfield_t* cef_textfield_create(
    struct _cef_textfield_delegate_t* delegate) {
  return g_libcef_pointers.cef_textfield_create(delegate);
}

NO_SANITIZE("cfi-icall")
struct _cef_window_t* cef_window_create_top_level(
    struct _cef_window_delegate_t* delegate) {
  return g_libcef_pointers.cef_window_create_top_level(delegate);
}

NO_SANITIZE("cfi-icall") const char* cef_api_hash(int entry) {
  return g_libcef_pointers.cef_api_hash(entry);
}

NO_SANITIZE("cfi-icall") int cef_version_info(int entry) {
  return g_libcef_pointers.cef_version_info(entry);
}

NO_SANITIZE("cfi-icall") int cef_get_min_log_level() {
  return g_libcef_pointers.cef_get_min_log_level();
}

NO_SANITIZE("cfi-icall")
int cef_get_vlog_level(const char* file_start, size_t N) {
  return g_libcef_pointers.cef_get_vlog_level(file_start, N);
}

NO_SANITIZE("cfi-icall")
void cef_log(const char* file, int line, int severity, const char* message) {
  g_libcef_pointers.cef_log(file, line, severity, message);
}

NO_SANITIZE("cfi-icall") cef_string_list_t cef_string_list_alloc() {
  return g_libcef_pointers.cef_string_list_alloc();
}

NO_SANITIZE("cfi-icall") size_t cef_string_list_size(cef_string_list_t list) {
  return g_libcef_pointers.cef_string_list_size(list);
}

NO_SANITIZE("cfi-icall")
int cef_string_list_value(cef_string_list_t list,
                          size_t index,
                          cef_string_t* value) {
  return g_libcef_pointers.cef_string_list_value(list, index, value);
}

NO_SANITIZE("cfi-icall")
void cef_string_list_append(cef_string_list_t list, const cef_string_t* value) {
  g_libcef_pointers.cef_string_list_append(list, value);
}

NO_SANITIZE("cfi-icall") void cef_string_list_clear(cef_string_list_t list) {
  g_libcef_pointers.cef_string_list_clear(list);
}

NO_SANITIZE("cfi-icall") void cef_string_list_free(cef_string_list_t list) {
  g_libcef_pointers.cef_string_list_free(list);
}

NO_SANITIZE("cfi-icall")
cef_string_list_t cef_string_list_copy(cef_string_list_t list) {
  return g_libcef_pointers.cef_string_list_copy(list);
}

NO_SANITIZE("cfi-icall") cef_string_map_t cef_string_map_alloc() {
  return g_libcef_pointers.cef_string_map_alloc();
}

NO_SANITIZE("cfi-icall") size_t cef_string_map_size(cef_string_map_t map) {
  return g_libcef_pointers.cef_string_map_size(map);
}

NO_SANITIZE("cfi-icall")
int cef_string_map_find(cef_string_map_t map,
                        const cef_string_t* key,
                        cef_string_t* value) {
  return g_libcef_pointers.cef_string_map_find(map, key, value);
}

NO_SANITIZE("cfi-icall")
int cef_string_map_key(cef_string_map_t map, size_t index, cef_string_t* key) {
  return g_libcef_pointers.cef_string_map_key(map, index, key);
}

NO_SANITIZE("cfi-icall")
int cef_string_map_value(cef_string_map_t map,
                         size_t index,
                         cef_string_t* value) {
  return g_libcef_pointers.cef_string_map_value(map, index, value);
}

NO_SANITIZE("cfi-icall")
int cef_string_map_append(cef_string_map_t map,
                          const cef_string_t* key,
                          const cef_string_t* value) {
  return g_libcef_pointers.cef_string_map_append(map, key, value);
}

NO_SANITIZE("cfi-icall") void cef_string_map_clear(cef_string_map_t map) {
  g_libcef_pointers.cef_string_map_clear(map);
}

NO_SANITIZE("cfi-icall") void cef_string_map_free(cef_string_map_t map) {
  g_libcef_pointers.cef_string_map_free(map);
}

NO_SANITIZE("cfi-icall") cef_string_multimap_t cef_string_multimap_alloc() {
  return g_libcef_pointers.cef_string_multimap_alloc();
}

NO_SANITIZE("cfi-icall")
size_t cef_string_multimap_size(cef_string_multimap_t map) {
  return g_libcef_pointers.cef_string_multimap_size(map);
}

NO_SANITIZE("cfi-icall")
size_t cef_string_multimap_find_count(cef_string_multimap_t map,
                                      const cef_string_t* key) {
  return g_libcef_pointers.cef_string_multimap_find_count(map, key);
}

NO_SANITIZE("cfi-icall")
int cef_string_multimap_enumerate(cef_string_multimap_t map,
                                  const cef_string_t* key,
                                  size_t value_index,
                                  cef_string_t* value) {
  return g_libcef_pointers.cef_string_multimap_enumerate(map, key, value_index,
                                                         value);
}

NO_SANITIZE("cfi-icall")
int cef_string_multimap_key(cef_string_multimap_t map,
                            size_t index,
                            cef_string_t* key) {
  return g_libcef_pointers.cef_string_multimap_key(map, index, key);
}

NO_SANITIZE("cfi-icall")
int cef_string_multimap_value(cef_string_multimap_t map,
                              size_t index,
                              cef_string_t* value) {
  return g_libcef_pointers.cef_string_multimap_value(map, index, value);
}

NO_SANITIZE("cfi-icall")
int cef_string_multimap_append(cef_string_multimap_t map,
                               const cef_string_t* key,
                               const cef_string_t* value) {
  return g_libcef_pointers.cef_string_multimap_append(map, key, value);
}

NO_SANITIZE("cfi-icall")
void cef_string_multimap_clear(cef_string_multimap_t map) {
  g_libcef_pointers.cef_string_multimap_clear(map);
}

NO_SANITIZE("cfi-icall")
void cef_string_multimap_free(cef_string_multimap_t map) {
  g_libcef_pointers.cef_string_multimap_free(map);
}

NO_SANITIZE("cfi-icall")
int cef_string_wide_set(const wchar_t* src,
                        size_t src_len,
                        cef_string_wide_t* output,
                        int copy) {
  return g_libcef_pointers.cef_string_wide_set(src, src_len, output, copy);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf8_set(const char* src,
                        size_t src_len,
                        cef_string_utf8_t* output,
                        int copy) {
  return g_libcef_pointers.cef_string_utf8_set(src, src_len, output, copy);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf16_set(const char16* src,
                         size_t src_len,
                         cef_string_utf16_t* output,
                         int copy) {
  return g_libcef_pointers.cef_string_utf16_set(src, src_len, output, copy);
}

NO_SANITIZE("cfi-icall") void cef_string_wide_clear(cef_string_wide_t* str) {
  g_libcef_pointers.cef_string_wide_clear(str);
}

NO_SANITIZE("cfi-icall") void cef_string_utf8_clear(cef_string_utf8_t* str) {
  g_libcef_pointers.cef_string_utf8_clear(str);
}

NO_SANITIZE("cfi-icall") void cef_string_utf16_clear(cef_string_utf16_t* str) {
  g_libcef_pointers.cef_string_utf16_clear(str);
}

NO_SANITIZE("cfi-icall")
int cef_string_wide_cmp(const cef_string_wide_t* str1,
                        const cef_string_wide_t* str2) {
  return g_libcef_pointers.cef_string_wide_cmp(str1, str2);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf8_cmp(const cef_string_utf8_t* str1,
                        const cef_string_utf8_t* str2) {
  return g_libcef_pointers.cef_string_utf8_cmp(str1, str2);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf16_cmp(const cef_string_utf16_t* str1,
                         const cef_string_utf16_t* str2) {
  return g_libcef_pointers.cef_string_utf16_cmp(str1, str2);
}

NO_SANITIZE("cfi-icall")
int cef_string_wide_to_utf8(const wchar_t* src,
                            size_t src_len,
                            cef_string_utf8_t* output) {
  return g_libcef_pointers.cef_string_wide_to_utf8(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf8_to_wide(const char* src,
                            size_t src_len,
                            cef_string_wide_t* output) {
  return g_libcef_pointers.cef_string_utf8_to_wide(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_wide_to_utf16(const wchar_t* src,
                             size_t src_len,
                             cef_string_utf16_t* output) {
  return g_libcef_pointers.cef_string_wide_to_utf16(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf16_to_wide(const char16* src,
                             size_t src_len,
                             cef_string_wide_t* output) {
  return g_libcef_pointers.cef_string_utf16_to_wide(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf8_to_utf16(const char* src,
                             size_t src_len,
                             cef_string_utf16_t* output) {
  return g_libcef_pointers.cef_string_utf8_to_utf16(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf16_to_utf8(const char16* src,
                             size_t src_len,
                             cef_string_utf8_t* output) {
  return g_libcef_pointers.cef_string_utf16_to_utf8(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_ascii_to_wide(const char* src,
                             size_t src_len,
                             cef_string_wide_t* output) {
  return g_libcef_pointers.cef_string_ascii_to_wide(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_ascii_to_utf16(const char* src,
                              size_t src_len,
                              cef_string_utf16_t* output) {
  return g_libcef_pointers.cef_string_ascii_to_utf16(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_wide_t cef_string_userfree_wide_alloc() {
  return g_libcef_pointers.cef_string_userfree_wide_alloc();
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_utf8_t cef_string_userfree_utf8_alloc() {
  return g_libcef_pointers.cef_string_userfree_utf8_alloc();
}

NO_SANITIZE("cfi-icall")
cef_string_userfree_utf16_t cef_string_userfree_utf16_alloc() {
  return g_libcef_pointers.cef_string_userfree_utf16_alloc();
}

NO_SANITIZE("cfi-icall")
void cef_string_userfree_wide_free(cef_string_userfree_wide_t str) {
  g_libcef_pointers.cef_string_userfree_wide_free(str);
}

NO_SANITIZE("cfi-icall")
void cef_string_userfree_utf8_free(cef_string_userfree_utf8_t str) {
  g_libcef_pointers.cef_string_userfree_utf8_free(str);
}

NO_SANITIZE("cfi-icall")
void cef_string_userfree_utf16_free(cef_string_userfree_utf16_t str) {
  g_libcef_pointers.cef_string_userfree_utf16_free(str);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf16_to_lower(const char16* src,
                              size_t src_len,
                              cef_string_utf16_t* output) {
  return g_libcef_pointers.cef_string_utf16_to_lower(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
int cef_string_utf16_to_upper(const char16* src,
                              size_t src_len,
                              cef_string_utf16_t* output) {
  return g_libcef_pointers.cef_string_utf16_to_upper(src, src_len, output);
}

NO_SANITIZE("cfi-icall")
cef_platform_thread_id_t cef_get_current_platform_thread_id() {
  return g_libcef_pointers.cef_get_current_platform_thread_id();
}

NO_SANITIZE("cfi-icall")
cef_platform_thread_handle_t cef_get_current_platform_thread_handle() {
  return g_libcef_pointers.cef_get_current_platform_thread_handle();
}

NO_SANITIZE("cfi-icall")
int cef_time_to_timet(const cef_time_t* cef_time, time_t* time) {
  return g_libcef_pointers.cef_time_to_timet(cef_time, time);
}

NO_SANITIZE("cfi-icall")
int cef_time_from_timet(time_t time, cef_time_t* cef_time) {
  return g_libcef_pointers.cef_time_from_timet(time, cef_time);
}

NO_SANITIZE("cfi-icall")
int cef_time_to_doublet(const cef_time_t* cef_time, double* time) {
  return g_libcef_pointers.cef_time_to_doublet(cef_time, time);
}

NO_SANITIZE("cfi-icall")
int cef_time_from_doublet(double time, cef_time_t* cef_time) {
  return g_libcef_pointers.cef_time_from_doublet(time, cef_time);
}

NO_SANITIZE("cfi-icall") int cef_time_now(cef_time_t* cef_time) {
  return g_libcef_pointers.cef_time_now(cef_time);
}

NO_SANITIZE("cfi-icall")
int cef_time_delta(const cef_time_t* cef_time1,
                   const cef_time_t* cef_time2,
                   long long* delta) {
  return g_libcef_pointers.cef_time_delta(cef_time1, cef_time2, delta);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_instant(const char* category,
                             const char* name,
                             const char* arg1_name,
                             uint64 arg1_val,
                             const char* arg2_name,
                             uint64 arg2_val,
                             int copy) {
  g_libcef_pointers.cef_trace_event_instant(category, name, arg1_name, arg1_val,
                                            arg2_name, arg2_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_begin(const char* category,
                           const char* name,
                           const char* arg1_name,
                           uint64 arg1_val,
                           const char* arg2_name,
                           uint64 arg2_val,
                           int copy) {
  g_libcef_pointers.cef_trace_event_begin(category, name, arg1_name, arg1_val,
                                          arg2_name, arg2_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_end(const char* category,
                         const char* name,
                         const char* arg1_name,
                         uint64 arg1_val,
                         const char* arg2_name,
                         uint64 arg2_val,
                         int copy) {
  g_libcef_pointers.cef_trace_event_end(category, name, arg1_name, arg1_val,
                                        arg2_name, arg2_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_counter(const char* category,
                       const char* name,
                       const char* value1_name,
                       uint64 value1_val,
                       const char* value2_name,
                       uint64 value2_val,
                       int copy) {
  g_libcef_pointers.cef_trace_counter(category, name, value1_name, value1_val,
                                      value2_name, value2_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_counter_id(const char* category,
                          const char* name,
                          uint64 id,
                          const char* value1_name,
                          uint64 value1_val,
                          const char* value2_name,
                          uint64 value2_val,
                          int copy) {
  g_libcef_pointers.cef_trace_counter_id(category, name, id, value1_name,
                                         value1_val, value2_name, value2_val,
                                         copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_async_begin(const char* category,
                                 const char* name,
                                 uint64 id,
                                 const char* arg1_name,
                                 uint64 arg1_val,
                                 const char* arg2_name,
                                 uint64 arg2_val,
                                 int copy) {
  g_libcef_pointers.cef_trace_event_async_begin(
      category, name, id, arg1_name, arg1_val, arg2_name, arg2_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_async_step_into(const char* category,
                                     const char* name,
                                     uint64 id,
                                     uint64 step,
                                     const char* arg1_name,
                                     uint64 arg1_val,
                                     int copy) {
  g_libcef_pointers.cef_trace_event_async_step_into(category, name, id, step,
                                                    arg1_name, arg1_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_async_step_past(const char* category,
                                     const char* name,
                                     uint64 id,
                                     uint64 step,
                                     const char* arg1_name,
                                     uint64 arg1_val,
                                     int copy) {
  g_libcef_pointers.cef_trace_event_async_step_past(category, name, id, step,
                                                    arg1_name, arg1_val, copy);
}

NO_SANITIZE("cfi-icall")
void cef_trace_event_async_end(const char* category,
                               const char* name,
                               uint64 id,
                               const char* arg1_name,
                               uint64 arg1_val,
                               const char* arg2_name,
                               uint64 arg2_val,
                               int copy) {
  g_libcef_pointers.cef_trace_event_async_end(
      category, name, id, arg1_name, arg1_val, arg2_name, arg2_val, copy);
}
