// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=2332af38a85b938ce097ee671f957fa20622004e$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_MEDIA_ROUTE_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_MEDIA_ROUTE_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include "include/capi/cef_media_router_capi.h"
#include "include/cef_media_router.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefMediaRouteCToCpp : public CefCToCppRefCounted<CefMediaRouteCToCpp,
                                                       CefMediaRoute,
                                                       cef_media_route_t> {
 public:
  CefMediaRouteCToCpp();
  virtual ~CefMediaRouteCToCpp();

  // CefMediaRoute methods.
  CefString GetId() OVERRIDE;
  CefRefPtr<CefMediaSource> GetSource() OVERRIDE;
  CefRefPtr<CefMediaSink> GetSink() OVERRIDE;
  void SendRouteMessage(const void* message, size_t message_size) OVERRIDE;
  void Terminate() OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_MEDIA_ROUTE_CTOCPP_H_
