// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=db05a06c80f30f0d25b2eec12b50bbf0310e36fb$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_TEST_TRANSLATOR_TEST_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_TEST_TRANSLATOR_TEST_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include <map>
#include <vector>
#include "include/capi/test/cef_translator_test_capi.h"
#include "include/test/cef_translator_test.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefTranslatorTestCToCpp
    : public CefCToCppRefCounted<CefTranslatorTestCToCpp,
                                 CefTranslatorTest,
                                 cef_translator_test_t> {
 public:
  CefTranslatorTestCToCpp();
  virtual ~CefTranslatorTestCToCpp();

  // CefTranslatorTest methods.
  void GetVoid() OVERRIDE;
  bool GetBool() OVERRIDE;
  int GetInt() OVERRIDE;
  double GetDouble() OVERRIDE;
  long GetLong() OVERRIDE;
  size_t GetSizet() OVERRIDE;
  bool SetVoid() OVERRIDE;
  bool SetBool(bool val) OVERRIDE;
  bool SetInt(int val) OVERRIDE;
  bool SetDouble(double val) OVERRIDE;
  bool SetLong(long val) OVERRIDE;
  bool SetSizet(size_t val) OVERRIDE;
  bool SetIntList(const std::vector<int>& val) OVERRIDE;
  bool GetIntListByRef(IntList& val) OVERRIDE;
  size_t GetIntListSize() OVERRIDE;
  CefString GetString() OVERRIDE;
  bool SetString(const CefString& val) OVERRIDE;
  void GetStringByRef(CefString& val) OVERRIDE;
  bool SetStringList(const std::vector<CefString>& val) OVERRIDE;
  bool GetStringListByRef(StringList& val) OVERRIDE;
  bool SetStringMap(const StringMap& val) OVERRIDE;
  bool GetStringMapByRef(std::map<CefString, CefString>& val) OVERRIDE;
  bool SetStringMultimap(
      const std::multimap<CefString, CefString>& val) OVERRIDE;
  bool GetStringMultimapByRef(StringMultimap& val) OVERRIDE;
  CefPoint GetPoint() OVERRIDE;
  bool SetPoint(const CefPoint& val) OVERRIDE;
  void GetPointByRef(CefPoint& val) OVERRIDE;
  bool SetPointList(const std::vector<CefPoint>& val) OVERRIDE;
  bool GetPointListByRef(PointList& val) OVERRIDE;
  size_t GetPointListSize() OVERRIDE;
  CefRefPtr<CefTranslatorTestRefPtrLibrary> GetRefPtrLibrary(int val) OVERRIDE;
  int SetRefPtrLibrary(CefRefPtr<CefTranslatorTestRefPtrLibrary> val) OVERRIDE;
  CefRefPtr<CefTranslatorTestRefPtrLibrary> SetRefPtrLibraryAndReturn(
      CefRefPtr<CefTranslatorTestRefPtrLibrary> val) OVERRIDE;
  int SetChildRefPtrLibrary(
      CefRefPtr<CefTranslatorTestRefPtrLibraryChild> val) OVERRIDE;
  CefRefPtr<CefTranslatorTestRefPtrLibrary>
  SetChildRefPtrLibraryAndReturnParent(
      CefRefPtr<CefTranslatorTestRefPtrLibraryChild> val) OVERRIDE;
  bool SetRefPtrLibraryList(
      const std::vector<CefRefPtr<CefTranslatorTestRefPtrLibrary>>& val,
      int val1,
      int val2) OVERRIDE;
  bool GetRefPtrLibraryListByRef(RefPtrLibraryList& val,
                                 int val1,
                                 int val2) OVERRIDE;
  size_t GetRefPtrLibraryListSize() OVERRIDE;
  int SetRefPtrClient(CefRefPtr<CefTranslatorTestRefPtrClient> val) OVERRIDE;
  CefRefPtr<CefTranslatorTestRefPtrClient> SetRefPtrClientAndReturn(
      CefRefPtr<CefTranslatorTestRefPtrClient> val) OVERRIDE;
  int SetChildRefPtrClient(
      CefRefPtr<CefTranslatorTestRefPtrClientChild> val) OVERRIDE;
  CefRefPtr<CefTranslatorTestRefPtrClient> SetChildRefPtrClientAndReturnParent(
      CefRefPtr<CefTranslatorTestRefPtrClientChild> val) OVERRIDE;
  bool SetRefPtrClientList(
      const std::vector<CefRefPtr<CefTranslatorTestRefPtrClient>>& val,
      int val1,
      int val2) OVERRIDE;
  bool GetRefPtrClientListByRef(
      RefPtrClientList& val,
      CefRefPtr<CefTranslatorTestRefPtrClient> val1,
      CefRefPtr<CefTranslatorTestRefPtrClient> val2) OVERRIDE;
  size_t GetRefPtrClientListSize() OVERRIDE;
  CefOwnPtr<CefTranslatorTestScopedLibrary> GetOwnPtrLibrary(int val) OVERRIDE;
  int SetOwnPtrLibrary(CefOwnPtr<CefTranslatorTestScopedLibrary> val) OVERRIDE;
  CefOwnPtr<CefTranslatorTestScopedLibrary> SetOwnPtrLibraryAndReturn(
      CefOwnPtr<CefTranslatorTestScopedLibrary> val) OVERRIDE;
  int SetChildOwnPtrLibrary(
      CefOwnPtr<CefTranslatorTestScopedLibraryChild> val) OVERRIDE;
  CefOwnPtr<CefTranslatorTestScopedLibrary>
  SetChildOwnPtrLibraryAndReturnParent(
      CefOwnPtr<CefTranslatorTestScopedLibraryChild> val) OVERRIDE;
  int SetOwnPtrClient(CefOwnPtr<CefTranslatorTestScopedClient> val) OVERRIDE;
  CefOwnPtr<CefTranslatorTestScopedClient> SetOwnPtrClientAndReturn(
      CefOwnPtr<CefTranslatorTestScopedClient> val) OVERRIDE;
  int SetChildOwnPtrClient(
      CefOwnPtr<CefTranslatorTestScopedClientChild> val) OVERRIDE;
  CefOwnPtr<CefTranslatorTestScopedClient> SetChildOwnPtrClientAndReturnParent(
      CefOwnPtr<CefTranslatorTestScopedClientChild> val) OVERRIDE;
  int SetRawPtrLibrary(CefRawPtr<CefTranslatorTestScopedLibrary> val) OVERRIDE;
  int SetChildRawPtrLibrary(
      CefRawPtr<CefTranslatorTestScopedLibraryChild> val) OVERRIDE;
  bool SetRawPtrLibraryList(
      const std::vector<CefRawPtr<CefTranslatorTestScopedLibrary>>& val,
      int val1,
      int val2) OVERRIDE;
  int SetRawPtrClient(CefRawPtr<CefTranslatorTestScopedClient> val) OVERRIDE;
  int SetChildRawPtrClient(
      CefRawPtr<CefTranslatorTestScopedClientChild> val) OVERRIDE;
  bool SetRawPtrClientList(
      const std::vector<CefRawPtr<CefTranslatorTestScopedClient>>& val,
      int val1,
      int val2) OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_TEST_TRANSLATOR_TEST_CTOCPP_H_
