// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=77fee821efba296de9f9c01aa42f77596fb381d1$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_REQUEST_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_REQUEST_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include "include/capi/cef_request_capi.h"
#include "include/cef_request.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefRequestCToCpp
    : public CefCToCppRefCounted<CefRequestCToCpp, CefRequest, cef_request_t> {
 public:
  CefRequestCToCpp();
  virtual ~CefRequestCToCpp();

  // CefRequest methods.
  bool IsReadOnly() OVERRIDE;
  CefString GetURL() OVERRIDE;
  void SetURL(const CefString& url) OVERRIDE;
  CefString GetMethod() OVERRIDE;
  void SetMethod(const CefString& method) OVERRIDE;
  void SetReferrer(const CefString& referrer_url,
                   ReferrerPolicy policy) OVERRIDE;
  CefString GetReferrerURL() OVERRIDE;
  ReferrerPolicy GetReferrerPolicy() OVERRIDE;
  CefRefPtr<CefPostData> GetPostData() OVERRIDE;
  void SetPostData(CefRefPtr<CefPostData> postData) OVERRIDE;
  void GetHeaderMap(HeaderMap& headerMap) OVERRIDE;
  void SetHeaderMap(const HeaderMap& headerMap) OVERRIDE;
  CefString GetHeaderByName(const CefString& name) OVERRIDE;
  void SetHeaderByName(const CefString& name,
                       const CefString& value,
                       bool overwrite) OVERRIDE;
  void Set(const CefString& url,
           const CefString& method,
           CefRefPtr<CefPostData> postData,
           const HeaderMap& headerMap) OVERRIDE;
  int GetFlags() OVERRIDE;
  void SetFlags(int flags) OVERRIDE;
  CefString GetFirstPartyForCookies() OVERRIDE;
  void SetFirstPartyForCookies(const CefString& url) OVERRIDE;
  ResourceType GetResourceType() OVERRIDE;
  TransitionType GetTransitionType() OVERRIDE;
  uint64 GetIdentifier() OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_REQUEST_CTOCPP_H_
