// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=643127d0c9772dbab1980c797ceef47a12f00f48$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_LIST_VALUE_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_LIST_VALUE_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include "include/capi/cef_values_capi.h"
#include "include/cef_values.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefListValueCToCpp : public CefCToCppRefCounted<CefListValueCToCpp,
                                                      CefListValue,
                                                      cef_list_value_t> {
 public:
  CefListValueCToCpp();
  virtual ~CefListValueCToCpp();

  // CefListValue methods.
  bool IsValid() OVERRIDE;
  bool IsOwned() OVERRIDE;
  bool IsReadOnly() OVERRIDE;
  bool IsSame(CefRefPtr<CefListValue> that) OVERRIDE;
  bool IsEqual(CefRefPtr<CefListValue> that) OVERRIDE;
  CefRefPtr<CefListValue> Copy() OVERRIDE;
  bool SetSize(size_t size) OVERRIDE;
  size_t GetSize() OVERRIDE;
  bool Clear() OVERRIDE;
  bool Remove(size_t index) OVERRIDE;
  CefValueType GetType(size_t index) OVERRIDE;
  CefRefPtr<CefValue> GetValue(size_t index) OVERRIDE;
  bool GetBool(size_t index) OVERRIDE;
  int GetInt(size_t index) OVERRIDE;
  double GetDouble(size_t index) OVERRIDE;
  CefString GetString(size_t index) OVERRIDE;
  CefRefPtr<CefBinaryValue> GetBinary(size_t index) OVERRIDE;
  CefRefPtr<CefDictionaryValue> GetDictionary(size_t index) OVERRIDE;
  CefRefPtr<CefListValue> GetList(size_t index) OVERRIDE;
  bool SetValue(size_t index, CefRefPtr<CefValue> value) OVERRIDE;
  bool SetNull(size_t index) OVERRIDE;
  bool SetBool(size_t index, bool value) OVERRIDE;
  bool SetInt(size_t index, int value) OVERRIDE;
  bool SetDouble(size_t index, double value) OVERRIDE;
  bool SetString(size_t index, const CefString& value) OVERRIDE;
  bool SetBinary(size_t index, CefRefPtr<CefBinaryValue> value) OVERRIDE;
  bool SetDictionary(size_t index,
                     CefRefPtr<CefDictionaryValue> value) OVERRIDE;
  bool SetList(size_t index, CefRefPtr<CefListValue> value) OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_LIST_VALUE_CTOCPP_H_
