// Copyright (c) 2021 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=10d0f381490e63f0b95af48a93ea47e92459b5a3$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_COMMAND_LINE_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_COMMAND_LINE_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include <vector>
#include "include/capi/cef_command_line_capi.h"
#include "include/cef_command_line.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefCommandLineCToCpp : public CefCToCppRefCounted<CefCommandLineCToCpp,
                                                        CefCommandLine,
                                                        cef_command_line_t> {
 public:
  CefCommandLineCToCpp();
  virtual ~CefCommandLineCToCpp();

  // CefCommandLine methods.
  bool IsValid() OVERRIDE;
  bool IsReadOnly() OVERRIDE;
  CefRefPtr<CefCommandLine> Copy() OVERRIDE;
  void InitFromArgv(int argc, const char* const* argv) OVERRIDE;
  void InitFromString(const CefString& command_line) OVERRIDE;
  void Reset() OVERRIDE;
  void GetArgv(std::vector<CefString>& argv) OVERRIDE;
  CefString GetCommandLineString() OVERRIDE;
  CefString GetProgram() OVERRIDE;
  void SetProgram(const CefString& program) OVERRIDE;
  bool HasSwitches() OVERRIDE;
  bool HasSwitch(const CefString& name) OVERRIDE;
  CefString GetSwitchValue(const CefString& name) OVERRIDE;
  void GetSwitches(SwitchMap& switches) OVERRIDE;
  void AppendSwitch(const CefString& name) OVERRIDE;
  void AppendSwitchWithValue(const CefString& name,
                             const CefString& value) OVERRIDE;
  bool HasArguments() OVERRIDE;
  void GetArguments(ArgumentList& arguments) OVERRIDE;
  void AppendArgument(const CefString& argument) OVERRIDE;
  void PrependWrapper(const CefString& wrapper) OVERRIDE;
};

#endif  // CEF_LIBCEF_DLL_CTOCPP_COMMAND_LINE_CTOCPP_H_
