// Copyright (c) 2026 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=d8155b7c0ac56023d5fc592de229fd241ff83290$
//

#include "libcef_dll/ctocpp/run_context_menu_callback_ctocpp.h"

#include "libcef_dll/shutdown_checker.h"

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
void CefRunContextMenuCallbackCToCpp::Continue(int command_id,
                                               cef_event_flags_t event_flags) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->cont) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->cont(_struct, command_id, event_flags);
}

NO_SANITIZE("cfi-icall") void CefRunContextMenuCallbackCToCpp::Cancel() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->cancel) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->cancel(_struct);
}

// CONSTRUCTOR - Do not edit by hand.

CefRunContextMenuCallbackCToCpp::CefRunContextMenuCallbackCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefRunContextMenuCallbackCToCpp::~CefRunContextMenuCallbackCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_run_context_menu_callback_t* CefCToCppRefCounted<
    CefRunContextMenuCallbackCToCpp,
    CefRunContextMenuCallback,
    cef_run_context_menu_callback_t>::UnwrapDerived(CefWrapperType type,
                                                    CefRunContextMenuCallback*
                                                        c) {
  CHECK(false) << __func__ << " called with unexpected class type " << type;
  return nullptr;
}

template <>
CefWrapperType
    CefCToCppRefCounted<CefRunContextMenuCallbackCToCpp,
                        CefRunContextMenuCallback,
                        cef_run_context_menu_callback_t>::kWrapperType =
        WT_RUN_CONTEXT_MENU_CALLBACK;
