// Copyright (c) 2026 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=6acc056d7d21c54b14687a7d683094b7812dbca7$
//

#include "libcef_dll/ctocpp/test/api_version_test_ctocpp.h"

#include <algorithm>

#include "libcef_dll/cpptoc/test/api_version_test_ref_ptr_client_child_cpptoc.h"
#include "libcef_dll/cpptoc/test/api_version_test_ref_ptr_client_child_v2_cpptoc.h"
#include "libcef_dll/cpptoc/test/api_version_test_ref_ptr_client_cpptoc.h"
#include "libcef_dll/cpptoc/test/api_version_test_scoped_client_child_cpptoc.h"
#include "libcef_dll/cpptoc/test/api_version_test_scoped_client_child_v2_cpptoc.h"
#include "libcef_dll/cpptoc/test/api_version_test_scoped_client_cpptoc.h"
#include "libcef_dll/ctocpp/test/api_version_test_ref_ptr_library_child_ctocpp.h"
#include "libcef_dll/ctocpp/test/api_version_test_ref_ptr_library_ctocpp.h"
#include "libcef_dll/ctocpp/test/api_version_test_scoped_library_child_ctocpp.h"
#include "libcef_dll/ctocpp/test/api_version_test_scoped_library_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// STATIC METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTest> CefApiVersionTest::Create() {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = cef_api_version_test_create();

  // Return type: refptr_same
  return CefApiVersionTestCToCpp_Wrap(_retval);
}

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTestRefPtrLibrary> CefApiVersionTestCToCpp::
    GetRefPtrLibrary(int val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_ref_ptr_library) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_ref_ptr_library(_struct, val);

  // Return type: refptr_same
  return CefApiVersionTestRefPtrLibraryCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetRefPtrLibrary(
    CefRefPtr<CefApiVersionTestRefPtrLibrary> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_ref_ptr_library) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_ref_ptr_library(
      _struct, CefApiVersionTestRefPtrLibraryCToCpp_Unwrap(val));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTestRefPtrLibrary> CefApiVersionTestCToCpp::
    SetRefPtrLibraryAndReturn(CefRefPtr<CefApiVersionTestRefPtrLibrary> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_ref_ptr_library_and_return) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->set_ref_ptr_library_and_return(
      _struct, CefApiVersionTestRefPtrLibraryCToCpp_Unwrap(val));

  // Return type: refptr_same
  return CefApiVersionTestRefPtrLibraryCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildRefPtrLibrary(
    CefRefPtr<CefApiVersionTestRefPtrLibraryChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_ref_ptr_library) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_ref_ptr_library(
      _struct, CefApiVersionTestRefPtrLibraryChildCToCpp_Unwrap(val));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTestRefPtrLibrary> CefApiVersionTestCToCpp::
    SetChildRefPtrLibraryAndReturnParent(
        CefRefPtr<CefApiVersionTestRefPtrLibraryChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_ref_ptr_library_and_return_parent) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->set_child_ref_ptr_library_and_return_parent(
      _struct, CefApiVersionTestRefPtrLibraryChildCToCpp_Unwrap(val));

  // Return type: refptr_same
  return CefApiVersionTestRefPtrLibraryCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
bool CefApiVersionTestCToCpp::SetRefPtrLibraryList(
    const std::vector<CefRefPtr<CefApiVersionTestRefPtrLibrary>>& val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_ref_ptr_library_list) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Translate param: val; type: refptr_vec_same_byref_const
  const size_t valCount = val.size();
  cef_api_version_test_ref_ptr_library_t** valList = NULL;
  if (valCount > 0) {
    valList = new cef_api_version_test_ref_ptr_library_t*[valCount];
    DCHECK(valList);
    if (valList) {
      for (size_t i = 0; i < valCount; ++i) {
        valList[i] = CefApiVersionTestRefPtrLibraryCToCpp_Unwrap(val[i]);
      }
    }
  }

  // Execute
  int _retval =
      _struct->set_ref_ptr_library_list(_struct, valCount, valList, val1, val2);

  // Restore param:val; type: refptr_vec_same_byref_const
  if (valList) {
    delete[] valList;
  }

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefApiVersionTestCToCpp::GetRefPtrLibraryListByRef(RefPtrLibraryList& val,
                                                        int val1,
                                                        int val2) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_ref_ptr_library_list_by_ref) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Translate param: val; type: refptr_vec_same_byref
  size_t valSize = val.size();
  size_t valCount = std::max(GetRefPtrLibraryListSize(), valSize);
  cef_api_version_test_ref_ptr_library_t** valList = NULL;
  if (valCount > 0) {
    valList = new cef_api_version_test_ref_ptr_library_t*[valCount];
    DCHECK(valList);
    if (valList) {
      memset(valList, 0,
             sizeof(cef_api_version_test_ref_ptr_library_t*) * valCount);
    }
    if (valList && valSize > 0) {
      for (size_t i = 0; i < valSize; ++i) {
        valList[i] = CefApiVersionTestRefPtrLibraryCToCpp_Unwrap(val[i]);
      }
    }
  }

  // Execute
  int _retval = _struct->get_ref_ptr_library_list_by_ref(_struct, &valCount,
                                                         valList, val1, val2);

  // Restore param:val; type: refptr_vec_same_byref
  val.clear();
  if (valCount > 0 && valList) {
    for (size_t i = 0; i < valCount; ++i) {
      val.push_back(CefApiVersionTestRefPtrLibraryCToCpp_Wrap(valList[i]));
    }
    delete[] valList;
  }

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
size_t CefApiVersionTestCToCpp::GetRefPtrLibraryListSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_ref_ptr_library_list_size) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  size_t _retval = _struct->get_ref_ptr_library_list_size(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetRefPtrClient(
    CefRefPtr<CefApiVersionTestRefPtrClient> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_ref_ptr_client) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_ref_ptr_client(
      _struct, CefApiVersionTestRefPtrClientCppToC_Wrap(val));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTestRefPtrClient> CefApiVersionTestCToCpp::
    SetRefPtrClientAndReturn(CefRefPtr<CefApiVersionTestRefPtrClient> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_ref_ptr_client_and_return) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->set_ref_ptr_client_and_return(
      _struct, CefApiVersionTestRefPtrClientCppToC_Wrap(val));

  // Return type: refptr_diff
  return CefApiVersionTestRefPtrClientCppToC_Unwrap(_retval);
}

#if CEF_API_REMOVED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildRefPtrClient(
    CefRefPtr<CefApiVersionTestRefPtrClientChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_ref_ptr_client) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_ref_ptr_client(
      _struct, CefApiVersionTestRefPtrClientChildCppToC_Wrap(val));

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_REMOVED(13302)

#if CEF_API_REMOVED(13302)
NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTestRefPtrClient> CefApiVersionTestCToCpp::
    SetChildRefPtrClientAndReturnParent(
        CefRefPtr<CefApiVersionTestRefPtrClientChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_ref_ptr_client_and_return_parent) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->set_child_ref_ptr_client_and_return_parent(
      _struct, CefApiVersionTestRefPtrClientChildCppToC_Wrap(val));

  // Return type: refptr_diff
  return CefApiVersionTestRefPtrClientCppToC_Unwrap(_retval);
}
#endif  // CEF_API_REMOVED(13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildRefPtrClient(
    CefRefPtr<CefApiVersionTestRefPtrClientChildV2> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_ref_ptr_client_v2) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_ref_ptr_client_v2(
      _struct, CefApiVersionTestRefPtrClientChildV2CppToC_Wrap(val));

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_ADDED(13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
CefRefPtr<CefApiVersionTestRefPtrClient> CefApiVersionTestCToCpp::
    SetChildRefPtrClientAndReturnParent(
        CefRefPtr<CefApiVersionTestRefPtrClientChildV2> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_ref_ptr_client_and_return_parent_v2) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: refptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->set_child_ref_ptr_client_and_return_parent_v2(
      _struct, CefApiVersionTestRefPtrClientChildV2CppToC_Wrap(val));

  // Return type: refptr_diff
  return CefApiVersionTestRefPtrClientCppToC_Unwrap(_retval);
}
#endif  // CEF_API_ADDED(13302)

NO_SANITIZE("cfi-icall")
bool CefApiVersionTestCToCpp::SetRefPtrClientList(
    const std::vector<CefRefPtr<CefApiVersionTestRefPtrClient>>& val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_ref_ptr_client_list) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Translate param: val; type: refptr_vec_diff_byref_const
  const size_t valCount = val.size();
  cef_api_version_test_ref_ptr_client_t** valList = NULL;
  if (valCount > 0) {
    valList = new cef_api_version_test_ref_ptr_client_t*[valCount];
    DCHECK(valList);
    if (valList) {
      for (size_t i = 0; i < valCount; ++i) {
        valList[i] = CefApiVersionTestRefPtrClientCppToC_Wrap(val[i]);
      }
    }
  }

  // Execute
  int _retval =
      _struct->set_ref_ptr_client_list(_struct, valCount, valList, val1, val2);

  // Restore param:val; type: refptr_vec_diff_byref_const
  if (valList) {
    delete[] valList;
  }

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefApiVersionTestCToCpp::GetRefPtrClientListByRef(
    RefPtrClientList& val,
    CefRefPtr<CefApiVersionTestRefPtrClient> val1,
    CefRefPtr<CefApiVersionTestRefPtrClient> val2) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_ref_ptr_client_list_by_ref) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val1; type: refptr_diff
  DCHECK(val1.get());
  if (!val1.get()) {
    return false;
  }
  // Verify param: val2; type: refptr_diff
  DCHECK(val2.get());
  if (!val2.get()) {
    return false;
  }

  // Translate param: val; type: refptr_vec_diff_byref
  size_t valSize = val.size();
  size_t valCount = std::max(GetRefPtrLibraryListSize(), valSize);
  cef_api_version_test_ref_ptr_client_t** valList = NULL;
  if (valCount > 0) {
    valList = new cef_api_version_test_ref_ptr_client_t*[valCount];
    DCHECK(valList);
    if (valList) {
      memset(valList, 0,
             sizeof(cef_api_version_test_ref_ptr_client_t*) * valCount);
    }
    if (valList && valSize > 0) {
      for (size_t i = 0; i < valSize; ++i) {
        valList[i] = CefApiVersionTestRefPtrClientCppToC_Wrap(val[i]);
      }
    }
  }

  // Execute
  int _retval = _struct->get_ref_ptr_client_list_by_ref(
      _struct, &valCount, valList,
      CefApiVersionTestRefPtrClientCppToC_Wrap(val1),
      CefApiVersionTestRefPtrClientCppToC_Wrap(val2));

  // Restore param:val; type: refptr_vec_diff_byref
  val.clear();
  if (valCount > 0 && valList) {
    for (size_t i = 0; i < valCount; ++i) {
      val.push_back(CefApiVersionTestRefPtrClientCppToC_Unwrap(valList[i]));
    }
    delete[] valList;
  }

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
size_t CefApiVersionTestCToCpp::GetRefPtrClientListSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_ref_ptr_client_list_size) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  size_t _retval = _struct->get_ref_ptr_client_list_size(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefOwnPtr<CefApiVersionTestScopedLibrary> CefApiVersionTestCToCpp::
    GetOwnPtrLibrary(int val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_own_ptr_library) {
    return CefOwnPtr<CefApiVersionTestScopedLibrary>();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_own_ptr_library(_struct, val);

  // Return type: ownptr_same
  return CefApiVersionTestScopedLibraryCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetOwnPtrLibrary(
    CefOwnPtr<CefApiVersionTestScopedLibrary> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_own_ptr_library) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_own_ptr_library(
      _struct, CefApiVersionTestScopedLibraryCToCpp_UnwrapOwn(std::move(val)));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefOwnPtr<CefApiVersionTestScopedLibrary> CefApiVersionTestCToCpp::
    SetOwnPtrLibraryAndReturn(CefOwnPtr<CefApiVersionTestScopedLibrary> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_own_ptr_library_and_return) {
    return CefOwnPtr<CefApiVersionTestScopedLibrary>();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return CefOwnPtr<CefApiVersionTestScopedLibrary>();
  }

  // Execute
  auto* _retval = _struct->set_own_ptr_library_and_return(
      _struct, CefApiVersionTestScopedLibraryCToCpp_UnwrapOwn(std::move(val)));

  // Return type: ownptr_same
  return CefApiVersionTestScopedLibraryCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildOwnPtrLibrary(
    CefOwnPtr<CefApiVersionTestScopedLibraryChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_own_ptr_library) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_own_ptr_library(
      _struct,
      CefApiVersionTestScopedLibraryChildCToCpp_UnwrapOwn(std::move(val)));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefOwnPtr<CefApiVersionTestScopedLibrary> CefApiVersionTestCToCpp::
    SetChildOwnPtrLibraryAndReturnParent(
        CefOwnPtr<CefApiVersionTestScopedLibraryChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_own_ptr_library_and_return_parent) {
    return CefOwnPtr<CefApiVersionTestScopedLibrary>();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_same
  DCHECK(val.get());
  if (!val.get()) {
    return CefOwnPtr<CefApiVersionTestScopedLibrary>();
  }

  // Execute
  auto* _retval = _struct->set_child_own_ptr_library_and_return_parent(
      _struct,
      CefApiVersionTestScopedLibraryChildCToCpp_UnwrapOwn(std::move(val)));

  // Return type: ownptr_same
  return CefApiVersionTestScopedLibraryCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetOwnPtrClient(
    CefOwnPtr<CefApiVersionTestScopedClient> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_own_ptr_client) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_own_ptr_client(
      _struct, CefApiVersionTestScopedClientCppToC_WrapOwn(std::move(val)));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefOwnPtr<CefApiVersionTestScopedClient> CefApiVersionTestCToCpp::
    SetOwnPtrClientAndReturn(CefOwnPtr<CefApiVersionTestScopedClient> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_own_ptr_client_and_return) {
    return CefOwnPtr<CefApiVersionTestScopedClient>();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return CefOwnPtr<CefApiVersionTestScopedClient>();
  }

  // Execute
  auto* _retval = _struct->set_own_ptr_client_and_return(
      _struct, CefApiVersionTestScopedClientCppToC_WrapOwn(std::move(val)));

  // Return type: ownptr_diff
  return CefApiVersionTestScopedClientCppToC_UnwrapOwn(_retval);
}

#if CEF_API_REMOVED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildOwnPtrClient(
    CefOwnPtr<CefApiVersionTestScopedClientChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_own_ptr_client) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_own_ptr_client(
      _struct,
      CefApiVersionTestScopedClientChildCppToC_WrapOwn(std::move(val)));

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_REMOVED(13302)

#if CEF_API_REMOVED(13302)
NO_SANITIZE("cfi-icall")
CefOwnPtr<CefApiVersionTestScopedClient> CefApiVersionTestCToCpp::
    SetChildOwnPtrClientAndReturnParent(
        CefOwnPtr<CefApiVersionTestScopedClientChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_own_ptr_client_and_return_parent) {
    return CefOwnPtr<CefApiVersionTestScopedClient>();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return CefOwnPtr<CefApiVersionTestScopedClient>();
  }

  // Execute
  auto* _retval = _struct->set_child_own_ptr_client_and_return_parent(
      _struct,
      CefApiVersionTestScopedClientChildCppToC_WrapOwn(std::move(val)));

  // Return type: ownptr_diff
  return CefApiVersionTestScopedClientCppToC_UnwrapOwn(_retval);
}
#endif  // CEF_API_REMOVED(13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildOwnPtrClient(
    CefOwnPtr<CefApiVersionTestScopedClientChildV2> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_own_ptr_client_v2) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_own_ptr_client_v2(
      _struct,
      CefApiVersionTestScopedClientChildV2CppToC_WrapOwn(std::move(val)));

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_ADDED(13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
CefOwnPtr<CefApiVersionTestScopedClient> CefApiVersionTestCToCpp::
    SetChildOwnPtrClientAndReturnParent(
        CefOwnPtr<CefApiVersionTestScopedClientChildV2> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_own_ptr_client_and_return_parent_v2) {
    return CefOwnPtr<CefApiVersionTestScopedClient>();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: ownptr_diff
  DCHECK(val.get());
  if (!val.get()) {
    return CefOwnPtr<CefApiVersionTestScopedClient>();
  }

  // Execute
  auto* _retval = _struct->set_child_own_ptr_client_and_return_parent_v2(
      _struct,
      CefApiVersionTestScopedClientChildV2CppToC_WrapOwn(std::move(val)));

  // Return type: ownptr_diff
  return CefApiVersionTestScopedClientCppToC_UnwrapOwn(_retval);
}
#endif  // CEF_API_ADDED(13302)

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetRawPtrLibrary(
    CefRawPtr<CefApiVersionTestScopedLibrary> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_raw_ptr_library) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: rawptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_raw_ptr_library(
      _struct, CefApiVersionTestScopedLibraryCToCpp_UnwrapRaw(val));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildRawPtrLibrary(
    CefRawPtr<CefApiVersionTestScopedLibraryChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_raw_ptr_library) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: rawptr_same
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Execute
  int _retval = _struct->set_child_raw_ptr_library(
      _struct, CefApiVersionTestScopedLibraryChildCToCpp_UnwrapRaw(val));

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
bool CefApiVersionTestCToCpp::SetRawPtrLibraryList(
    const std::vector<CefRawPtr<CefApiVersionTestScopedLibrary>>& val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_raw_ptr_library_list) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Translate param: val; type: rawptr_vec_same_byref_const
  const size_t valCount = val.size();
  cef_api_version_test_scoped_library_t** valList = NULL;
  if (valCount > 0) {
    valList = new cef_api_version_test_scoped_library_t*[valCount];
    DCHECK(valList);
    if (valList) {
      for (size_t i = 0; i < valCount; ++i) {
        valList[i] = CefApiVersionTestScopedLibraryCToCpp_UnwrapRaw(val[i]);
      }
    }
  }

  // Execute
  int _retval =
      _struct->set_raw_ptr_library_list(_struct, valCount, valList, val1, val2);

  // Restore param:val; type: rawptr_vec_same_byref_const
  if (valList) {
    delete[] valList;
  }

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetRawPtrClient(
    CefRawPtr<CefApiVersionTestScopedClient> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_raw_ptr_client) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: rawptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: rawptr_diff
  auto [valPtr, valStruct] = CefApiVersionTestScopedClientCppToC_WrapRaw(val);

  // Execute
  int _retval = _struct->set_raw_ptr_client(_struct, valStruct);

  // Return type: simple
  return _retval;
}

#if CEF_API_REMOVED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildRawPtrClient(
    CefRawPtr<CefApiVersionTestScopedClientChild> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_raw_ptr_client) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: rawptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: rawptr_diff
  auto [valPtr, valStruct] =
      CefApiVersionTestScopedClientChildCppToC_WrapRaw(val);

  // Execute
  int _retval = _struct->set_child_raw_ptr_client(_struct, valStruct);

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_REMOVED(13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestCToCpp::SetChildRawPtrClient(
    CefRawPtr<CefApiVersionTestScopedClientChildV2> val) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_child_raw_ptr_client_v2) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: val; type: rawptr_diff
  DCHECK(val);
  if (!val) {
    return 0;
  }

  // Translate param: val; type: rawptr_diff
  auto [valPtr, valStruct] =
      CefApiVersionTestScopedClientChildV2CppToC_WrapRaw(val);

  // Execute
  int _retval = _struct->set_child_raw_ptr_client_v2(_struct, valStruct);

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_ADDED(13302)

NO_SANITIZE("cfi-icall")
bool CefApiVersionTestCToCpp::SetRawPtrClientList(
    const std::vector<CefRawPtr<CefApiVersionTestScopedClient>>& val,
    int val1,
    int val2) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_raw_ptr_client_list) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Translate param: val; type: rawptr_vec_diff_byref_const
  const size_t valCount = val.size();
  cef_api_version_test_scoped_client_t** valList = NULL;
  if (valCount > 0) {
    valList = new cef_api_version_test_scoped_client_t*[valCount];
    DCHECK(valList);
    if (valList) {
      for (size_t i = 0; i < valCount; ++i) {
        valList[i] =
            CefApiVersionTestScopedClientCppToC_WrapRawAndRelease(val[i]);
      }
    }
  }

  // Execute
  int _retval =
      _struct->set_raw_ptr_client_list(_struct, valCount, valList, val1, val2);

  // Restore param:val; type: rawptr_vec_diff_byref_const
  if (valCount > 0) {
    for (size_t i = 0; i < valCount; ++i) {
      delete CefApiVersionTestScopedClientCppToC_GetWrapper(valList[i]);
    }
  }
  if (valList) {
    delete[] valList;
  }

  // Return type: bool
  return _retval ? true : false;
}

// CONSTRUCTOR - Do not edit by hand.

CefApiVersionTestCToCpp::CefApiVersionTestCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefApiVersionTestCToCpp::~CefApiVersionTestCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_api_version_test_t* CefCToCppRefCounted<
    CefApiVersionTestCToCpp,
    CefApiVersionTest,
    cef_api_version_test_t>::UnwrapDerived(CefWrapperType type,
                                           CefApiVersionTest* c) {
  CHECK(false) << __func__ << " called with unexpected class type " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefApiVersionTestCToCpp,
                                   CefApiVersionTest,
                                   cef_api_version_test_t>::kWrapperType =
    WT_API_VERSION_TEST;
