// Copyright (c) 2026 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=d56ebe54fe5edc84367e25894f7cf69e04e3cd7e$
//

#include "libcef_dll/ctocpp/request_context_ctocpp.h"

#include "libcef_dll/cpptoc/completion_callback_cpptoc.h"
#include "libcef_dll/cpptoc/preference_observer_cpptoc.h"
#include "libcef_dll/cpptoc/request_context_handler_cpptoc.h"
#include "libcef_dll/cpptoc/resolve_callback_cpptoc.h"
#include "libcef_dll/cpptoc/scheme_handler_factory_cpptoc.h"
#include "libcef_dll/cpptoc/setting_observer_cpptoc.h"
#include "libcef_dll/ctocpp/cookie_manager_ctocpp.h"
#include "libcef_dll/ctocpp/dictionary_value_ctocpp.h"
#include "libcef_dll/ctocpp/media_router_ctocpp.h"
#include "libcef_dll/ctocpp/registration_ctocpp.h"
#include "libcef_dll/ctocpp/value_ctocpp.h"

// STATIC METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
CefRefPtr<CefRequestContext> CefRequestContext::GetGlobalContext() {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = cef_request_context_get_global_context();

  // Return type: refptr_same
  return CefRequestContextCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefRequestContext> CefRequestContext::CreateContext(
    const CefRequestContextSettings& settings,
    CefRefPtr<CefRequestContextHandler> handler) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: handler

  // Execute
  auto* _retval = cef_request_context_create_context(
      &settings, CefRequestContextHandlerCppToC_Wrap(handler));

  // Return type: refptr_same
  return CefRequestContextCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefRequestContext> CefRequestContext::CreateContext(
    CefRefPtr<CefRequestContext> other,
    CefRefPtr<CefRequestContextHandler> handler) {
  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: other; type: refptr_same
  DCHECK(other.get());
  if (!other.get()) {
    return nullptr;
  }
  // Unverified params: handler

  // Execute
  auto* _retval = cef_request_context_cef_create_context_shared(
      CefRequestContextCToCpp_Unwrap(other),
      CefRequestContextHandlerCppToC_Wrap(handler));

  // Return type: refptr_same
  return CefRequestContextCToCpp_Wrap(_retval);
}

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::IsSame(CefRefPtr<CefRequestContext> other) {
  auto* _struct = GetStruct();
  if (!_struct->is_same) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: other; type: refptr_same
  DCHECK(other.get());
  if (!other.get()) {
    return false;
  }

  // Execute
  int _retval =
      _struct->is_same(_struct, CefRequestContextCToCpp_Unwrap(other));

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::IsSharingWith(
    CefRefPtr<CefRequestContext> other) {
  auto* _struct = GetStruct();
  if (!_struct->is_sharing_with) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: other; type: refptr_same
  DCHECK(other.get());
  if (!other.get()) {
    return false;
  }

  // Execute
  int _retval =
      _struct->is_sharing_with(_struct, CefRequestContextCToCpp_Unwrap(other));

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefRequestContextCToCpp::IsGlobal() {
  auto* _struct = GetStruct();
  if (!_struct->is_global) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_global(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefRequestContextHandler> CefRequestContextCToCpp::GetHandler() {
  auto* _struct = GetStruct();
  if (!_struct->get_handler) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_handler(_struct);

  // Return type: refptr_diff
  return CefRequestContextHandlerCppToC_Unwrap(_retval);
}

NO_SANITIZE("cfi-icall") CefString CefRequestContextCToCpp::GetCachePath() {
  auto* _struct = GetStruct();
  if (!_struct->get_cache_path) {
    return CefString();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_cache_path(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefCookieManager> CefRequestContextCToCpp::GetCookieManager(
    CefRefPtr<CefCompletionCallback> callback) {
  auto* _struct = GetStruct();
  if (!_struct->get_cookie_manager) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: callback

  // Execute
  auto* _retval = _struct->get_cookie_manager(
      _struct, CefCompletionCallbackCppToC_Wrap(callback));

  // Return type: refptr_same
  return CefCookieManagerCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::RegisterSchemeHandlerFactory(
    const CefString& scheme_name,
    const CefString& domain_name,
    CefRefPtr<CefSchemeHandlerFactory> factory) {
  auto* _struct = GetStruct();
  if (!_struct->register_scheme_handler_factory) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: scheme_name; type: string_byref_const
  DCHECK(!scheme_name.empty());
  if (scheme_name.empty()) {
    return false;
  }
  // Unverified params: domain_name, factory

  // Execute
  int _retval = _struct->register_scheme_handler_factory(
      _struct, scheme_name.GetStruct(), domain_name.GetStruct(),
      CefSchemeHandlerFactoryCppToC_Wrap(factory));

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::ClearSchemeHandlerFactories() {
  auto* _struct = GetStruct();
  if (!_struct->clear_scheme_handler_factories) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->clear_scheme_handler_factories(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::ClearCertificateExceptions(
    CefRefPtr<CefCompletionCallback> callback) {
  auto* _struct = GetStruct();
  if (!_struct->clear_certificate_exceptions) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: callback

  // Execute
  _struct->clear_certificate_exceptions(
      _struct, CefCompletionCallbackCppToC_Wrap(callback));
}

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::ClearHttpAuthCredentials(
    CefRefPtr<CefCompletionCallback> callback) {
  auto* _struct = GetStruct();
  if (!_struct->clear_http_auth_credentials) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: callback

  // Execute
  _struct->clear_http_auth_credentials(
      _struct, CefCompletionCallbackCppToC_Wrap(callback));
}

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::CloseAllConnections(
    CefRefPtr<CefCompletionCallback> callback) {
  auto* _struct = GetStruct();
  if (!_struct->close_all_connections) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: callback

  // Execute
  _struct->close_all_connections(_struct,
                                 CefCompletionCallbackCppToC_Wrap(callback));
}

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::ResolveHost(
    const CefString& origin,
    CefRefPtr<CefResolveCallback> callback) {
  auto* _struct = GetStruct();
  if (!_struct->resolve_host) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: origin; type: string_byref_const
  DCHECK(!origin.empty());
  if (origin.empty()) {
    return;
  }
  // Verify param: callback; type: refptr_diff
  DCHECK(callback.get());
  if (!callback.get()) {
    return;
  }

  // Execute
  _struct->resolve_host(_struct, origin.GetStruct(),
                        CefResolveCallbackCppToC_Wrap(callback));
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefMediaRouter> CefRequestContextCToCpp::GetMediaRouter(
    CefRefPtr<CefCompletionCallback> callback) {
  auto* _struct = GetStruct();
  if (!_struct->get_media_router) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: callback

  // Execute
  auto* _retval = _struct->get_media_router(
      _struct, CefCompletionCallbackCppToC_Wrap(callback));

  // Return type: refptr_same
  return CefMediaRouterCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefValue> CefRequestContextCToCpp::GetWebsiteSetting(
    const CefString& requesting_url,
    const CefString& top_level_url,
    cef_content_setting_types_t content_type) {
  auto* _struct = GetStruct();
  if (!_struct->get_website_setting) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: requesting_url, top_level_url

  // Execute
  auto* _retval =
      _struct->get_website_setting(_struct, requesting_url.GetStruct(),
                                   top_level_url.GetStruct(), content_type);

  // Return type: refptr_same
  return CefValueCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::SetWebsiteSetting(
    const CefString& requesting_url,
    const CefString& top_level_url,
    cef_content_setting_types_t content_type,
    CefRefPtr<CefValue> value) {
  auto* _struct = GetStruct();
  if (!_struct->set_website_setting) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: requesting_url, top_level_url, value

  // Execute
  _struct->set_website_setting(_struct, requesting_url.GetStruct(),
                               top_level_url.GetStruct(), content_type,
                               CefValueCToCpp_Unwrap(value));
}

NO_SANITIZE("cfi-icall")
cef_content_setting_values_t CefRequestContextCToCpp::GetContentSetting(
    const CefString& requesting_url,
    const CefString& top_level_url,
    cef_content_setting_types_t content_type) {
  auto* _struct = GetStruct();
  if (!_struct->get_content_setting) {
    return CEF_CONTENT_SETTING_VALUE_DEFAULT;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: requesting_url, top_level_url

  // Execute
  cef_content_setting_values_t _retval =
      _struct->get_content_setting(_struct, requesting_url.GetStruct(),
                                   top_level_url.GetStruct(), content_type);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::SetContentSetting(
    const CefString& requesting_url,
    const CefString& top_level_url,
    cef_content_setting_types_t content_type,
    cef_content_setting_values_t value) {
  auto* _struct = GetStruct();
  if (!_struct->set_content_setting) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: requesting_url, top_level_url

  // Execute
  _struct->set_content_setting(_struct, requesting_url.GetStruct(),
                               top_level_url.GetStruct(), content_type, value);
}

#if CEF_API_ADDED(13401)
NO_SANITIZE("cfi-icall")
CefRefPtr<CefRegistration> CefRequestContextCToCpp::AddSettingObserver(
    CefRefPtr<CefSettingObserver> observer) {
  auto* _struct = GetStruct();
  if (!_struct->add_setting_observer) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: observer; type: refptr_diff
  DCHECK(observer.get());
  if (!observer.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->add_setting_observer(
      _struct, CefSettingObserverCppToC_Wrap(observer));

  // Return type: refptr_same
  return CefRegistrationCToCpp_Wrap(_retval);
}
#endif  // CEF_API_ADDED(13401)

NO_SANITIZE("cfi-icall")
void CefRequestContextCToCpp::SetChromeColorScheme(cef_color_variant_t variant,
                                                   cef_color_t user_color) {
  auto* _struct = GetStruct();
  if (!_struct->set_chrome_color_scheme) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_chrome_color_scheme(_struct, variant, user_color);
}

NO_SANITIZE("cfi-icall")
cef_color_variant_t CefRequestContextCToCpp::GetChromeColorSchemeMode() {
  auto* _struct = GetStruct();
  if (!_struct->get_chrome_color_scheme_mode) {
    return CEF_COLOR_VARIANT_SYSTEM;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_color_variant_t _retval = _struct->get_chrome_color_scheme_mode(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
cef_color_t CefRequestContextCToCpp::GetChromeColorSchemeColor() {
  auto* _struct = GetStruct();
  if (!_struct->get_chrome_color_scheme_color) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_color_t _retval = _struct->get_chrome_color_scheme_color(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
cef_color_variant_t CefRequestContextCToCpp::GetChromeColorSchemeVariant() {
  auto* _struct = GetStruct();
  if (!_struct->get_chrome_color_scheme_variant) {
    return CEF_COLOR_VARIANT_SYSTEM;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_color_variant_t _retval =
      _struct->get_chrome_color_scheme_variant(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::HasPreference(const CefString& name) {
  auto* _struct = reinterpret_cast<cef_preference_manager_t*>(GetStruct());
  if (!_struct->has_preference) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: name; type: string_byref_const
  DCHECK(!name.empty());
  if (name.empty()) {
    return false;
  }

  // Execute
  int _retval = _struct->has_preference(_struct, name.GetStruct());

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefValue> CefRequestContextCToCpp::GetPreference(
    const CefString& name) {
  auto* _struct = reinterpret_cast<cef_preference_manager_t*>(GetStruct());
  if (!_struct->get_preference) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: name; type: string_byref_const
  DCHECK(!name.empty());
  if (name.empty()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->get_preference(_struct, name.GetStruct());

  // Return type: refptr_same
  return CefValueCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefDictionaryValue> CefRequestContextCToCpp::GetAllPreferences(
    bool include_defaults) {
  auto* _struct = reinterpret_cast<cef_preference_manager_t*>(GetStruct());
  if (!_struct->get_all_preferences) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_all_preferences(_struct, include_defaults);

  // Return type: refptr_same
  return CefDictionaryValueCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::CanSetPreference(const CefString& name) {
  auto* _struct = reinterpret_cast<cef_preference_manager_t*>(GetStruct());
  if (!_struct->can_set_preference) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: name; type: string_byref_const
  DCHECK(!name.empty());
  if (name.empty()) {
    return false;
  }

  // Execute
  int _retval = _struct->can_set_preference(_struct, name.GetStruct());

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefRequestContextCToCpp::SetPreference(const CefString& name,
                                            CefRefPtr<CefValue> value,
                                            CefString& error) {
  auto* _struct = reinterpret_cast<cef_preference_manager_t*>(GetStruct());
  if (!_struct->set_preference) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: name; type: string_byref_const
  DCHECK(!name.empty());
  if (name.empty()) {
    return false;
  }
  // Unverified params: value

  // Execute
  int _retval = _struct->set_preference(_struct, name.GetStruct(),
                                        CefValueCToCpp_Unwrap(value),
                                        error.GetWritableStruct());

  // Return type: bool
  return _retval ? true : false;
}

#if CEF_API_ADDED(13401)
NO_SANITIZE("cfi-icall")
CefRefPtr<CefRegistration> CefRequestContextCToCpp::AddPreferenceObserver(
    const CefString& name,
    CefRefPtr<CefPreferenceObserver> observer) {
  auto* _struct = reinterpret_cast<cef_preference_manager_t*>(GetStruct());
  if (!_struct->add_preference_observer) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: observer; type: refptr_diff
  DCHECK(observer.get());
  if (!observer.get()) {
    return nullptr;
  }
  // Unverified params: name

  // Execute
  auto* _retval = _struct->add_preference_observer(
      _struct, name.GetStruct(), CefPreferenceObserverCppToC_Wrap(observer));

  // Return type: refptr_same
  return CefRegistrationCToCpp_Wrap(_retval);
}
#endif  // CEF_API_ADDED(13401)

// CONSTRUCTOR - Do not edit by hand.

CefRequestContextCToCpp::CefRequestContextCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefRequestContextCToCpp::~CefRequestContextCToCpp() {}

template <>
cef_request_context_t* CefCToCppRefCounted<
    CefRequestContextCToCpp,
    CefRequestContext,
    cef_request_context_t>::UnwrapDerived(CefWrapperType type,
                                          CefRequestContext* c) {
  CHECK(false) << __func__ << " called with unexpected class type " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefRequestContextCToCpp,
                                   CefRequestContext,
                                   cef_request_context_t>::kWrapperType =
    WT_REQUEST_CONTEXT;
