// Copyright (c) 2025 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_STRINGS_H_
#define CEF_INCLUDE_CEF_PACK_STRINGS_H_
#pragma once

// ---------------------------------------------------------------------------
// From app_locale_settings.h:

#define IDS_MINIMUM_UI_FONT_SIZE 400
#define IDS_UI_FONT_FAMILY 398
#define IDS_UI_FONT_SIZE_SCALER 399
#define IDS_WEB_FONT_FAMILY 692
#define IDS_WEB_FONT_SIZE 691

// ---------------------------------------------------------------------------
// From auto_image_annotation_strings.h:

#define IDS_AX_UNLABELED_IMAGE_ROLE_DESCRIPTION 48640
#define IDS_AX_IMAGE_ELIGIBLE_FOR_ANNOTATION 48642
#define IDS_AX_IMAGE_ANNOTATION_PENDING 48643
#define IDS_AX_IMAGE_ANNOTATION_ADULT 48644
#define IDS_AX_IMAGE_ANNOTATION_NO_DESCRIPTION 48645
#define IDS_AX_IMAGE_ANNOTATION_OCR_CONTEXT 48646
#define IDS_AX_IMAGE_ANNOTATION_DESCRIPTION_CONTEXT 48647
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLUS 48648
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_BACKWARD 48649
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_FORWARD 48650
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALL 48651
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHAT 48652
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHECK 48653
#define IDS_AX_IMAGE_ANNOTATION_ICON_X 48654
#define IDS_AX_IMAGE_ANNOTATION_ICON_DELETE 48655
#define IDS_AX_IMAGE_ANNOTATION_ICON_EDIT 48656
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI 48657
#define IDS_AX_IMAGE_ANNOTATION_ICON_END_CALL 48658
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_DOWNWARD 48659
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEART 48660
#define IDS_AX_IMAGE_ANNOTATION_ICON_HOME 48661
#define IDS_AX_IMAGE_ANNOTATION_ICON_INFO 48662
#define IDS_AX_IMAGE_ANNOTATION_ICON_LAUNCH_APPS 48663
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_UP 48664
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_BARS 48665
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_DOTS 48666
#define IDS_AX_IMAGE_ANNOTATION_ICON_NOTIFICATIONS 48667
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAUSE 48668
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLAY 48669
#define IDS_AX_IMAGE_ANNOTATION_ICON_REFRESH 48670
#define IDS_AX_IMAGE_ANNOTATION_ICON_MAGNIFYING_GLASS 48671
#define IDS_AX_IMAGE_ANNOTATION_ICON_SEND 48672
#define IDS_AX_IMAGE_ANNOTATION_ICON_SETTINGS 48673
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHARE 48674
#define IDS_AX_IMAGE_ANNOTATION_ICON_STAR 48675
#define IDS_AX_IMAGE_ANNOTATION_ICON_TAKE_PHOTO 48676
#define IDS_AX_IMAGE_ANNOTATION_ICON_TIME 48677
#define IDS_AX_IMAGE_ANNOTATION_ICON_VIDEOCAM 48678
#define IDS_AX_IMAGE_ANNOTATION_ICON_EXPAND 48679
#define IDS_AX_IMAGE_ANNOTATION_ICON_CONTRACT 48680
#define IDS_AX_IMAGE_ANNOTATION_ICON_GOOGLE 48681
#define IDS_AX_IMAGE_ANNOTATION_ICON_TWITTER 48682
#define IDS_AX_IMAGE_ANNOTATION_ICON_FACEBOOK 48683
#define IDS_AX_IMAGE_ANNOTATION_ICON_ASSISTANT 48684
#define IDS_AX_IMAGE_ANNOTATION_ICON_WEATHER 48685
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_CART 48686
#define IDS_AX_IMAGE_ANNOTATION_ICON_UPLOAD 48687
#define IDS_AX_IMAGE_ANNOTATION_ICON_QUESTION 48688
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC 48689
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC_MUTE 48690
#define IDS_AX_IMAGE_ANNOTATION_ICON_GALLERY 48691
#define IDS_AX_IMAGE_ANNOTATION_ICON_COMPASS 48692
#define IDS_AX_IMAGE_ANNOTATION_ICON_PEOPLE 48693
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_UPWARD 48694
#define IDS_AX_IMAGE_ANNOTATION_ICON_ENVELOPE 48695
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI_FACE 48696
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAPERCLIP 48697
#define IDS_AX_IMAGE_ANNOTATION_ICON_CAST 48698
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_UP 48699
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_DOWN 48700
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_STATE 48701
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_MUTE 48702
#define IDS_AX_IMAGE_ANNOTATION_ICON_STOP 48703
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_BAG 48704
#define IDS_AX_IMAGE_ANNOTATION_ICON_LIST 48705
#define IDS_AX_IMAGE_ANNOTATION_ICON_LOCATION 48706
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALENDAR 48707
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_DOWN 48708
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEADSET 48709
#define IDS_AX_IMAGE_ANNOTATION_ICON_REDO 48710
#define IDS_AX_IMAGE_ANNOTATION_ICON_UNDO 48711
#define IDS_AX_IMAGE_ANNOTATION_ICON_DOWNLOAD 48712
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_DOWNWARD 48713
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_UPWARD 48714
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_FORWARD 48715
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_BACKWARD 48716
#define IDS_AX_IMAGE_ANNOTATION_ICON_HISTORY 48717
#define IDS_AX_IMAGE_ANNOTATION_ICON_PERSON 48718
#define IDS_AX_IMAGE_ANNOTATION_ICON_HAPPY_FACE 48719
#define IDS_AX_IMAGE_ANNOTATION_ICON_SAD_FACE 48720
#define IDS_AX_IMAGE_ANNOTATION_ICON_MOON 48721
#define IDS_AX_IMAGE_ANNOTATION_ICON_CLOUD 48722
#define IDS_AX_IMAGE_ANNOTATION_ICON_SUN 48723

// ---------------------------------------------------------------------------
// From blink_strings.h:

#define IDS_DETAILS_WITHOUT_SUMMARY_LABEL 45090
#define IDS_FORM_CALENDAR_CLEAR 45091
#define IDS_FORM_CALENDAR_TODAY 45092
#define IDS_FORM_SUBMIT_LABEL 45093
#define IDS_FORM_INPUT_ALT 45094
#define IDS_FORM_RESET_LABEL 45095
#define IDS_FORM_FILE_BUTTON_LABEL 45096
#define IDS_FORM_MULTIPLE_FILES_BUTTON_LABEL 45097
#define IDS_FORM_FILE_NO_FILE_LABEL 45098
#define IDS_FORM_FILE_MULTIPLE_UPLOAD 45099
#define IDS_FORM_OTHER_COLOR_LABEL 45100
#define IDS_FORM_OTHER_DATE_LABEL 45101
#define IDS_FORM_OTHER_MONTH_LABEL 45102
#define IDS_FORM_OTHER_WEEK_LABEL 45103
#define IDS_FORM_PLACEHOLDER_FOR_DAY_OF_MONTH_FIELD 45104
#define IDS_FORM_PLACEHOLDER_FOR_MONTH_FIELD 45105
#define IDS_FORM_PLACEHOLDER_FOR_YEAR_FIELD 45106
#define IDS_FORM_SELECT_MENU_LIST_TEXT 45107
#define IDS_FORM_THIS_MONTH_LABEL 45108
#define IDS_FORM_THIS_WEEK_LABEL 45109
#define IDS_FORM_WEEK_NUMBER_LABEL 45110
#define IDS_DEBUGGER_PAUSED_IN_ANOTHER_TAB 45111
#define IDS_VIEW_SOURCE_LINE_WRAP 45112
#define IDS_FORM_INPUT_WEEK_TEMPLATE 45113
#define IDS_FORM_VALIDATION_VALUE_MISSING_MULTIPLE_FILE 45114
#define IDS_FORM_VALIDATION_TYPE_MISMATCH 45115
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY 45116
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_DOMAIN 45117
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_LOCAL 45118
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOMAIN 45119
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOTS 45120
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_LOCAL 45121
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_NO_AT_SIGN 45122
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_MULTIPLE_EMAIL 45123
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL 45124
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL_DATETIME 45125
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW 45126
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW_DATETIME 45127
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW 45128
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW_DATETIME 45129
#define IDS_FORM_VALIDATION_REVERSED_RANGE_OUT_OF_RANGE_TIME 45130
#define IDS_FORM_VALIDATION_RANGE_REVERSED 45131
#define IDS_FORM_VALIDATION_RANGE_INVALID_DATETIME 45132
#define IDS_FORM_VALIDATION_BAD_INPUT_DATETIME 45133
#define IDS_FORM_VALIDATION_BAD_INPUT_NUMBER 45134
#define IDS_PRETTY_PRINT_JSON 45135
#define IDS_FORM_VALIDATION_VALUE_MISSING 45136
#define IDS_FORM_VALIDATION_VALUE_MISSING_CHECKBOX 45137
#define IDS_FORM_VALIDATION_VALUE_MISSING_FILE 45138
#define IDS_FORM_VALIDATION_VALUE_MISSING_RADIO 45139
#define IDS_FORM_VALIDATION_VALUE_MISSING_SELECT 45140
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL 45141
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_URL 45142
#define IDS_FORM_VALIDATION_PATTERN_MISMATCH 45143
#define IDS_FORM_VALIDATION_STEP_MISMATCH 45144
#define IDS_FORM_VALIDATION_STEP_MISMATCH_CLOSE_TO_LIMIT 45145
#define IDS_FORM_VALIDATION_TOO_LONG 45146
#define IDS_FORM_VALIDATION_TOO_SHORT 45147
#define IDS_FORM_VALIDATION_TOO_SHORT_PLURAL 45148
#define IDS_MEDIA_SESSION_FILE_SOURCE 45149
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS 45150
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS_SUBMENU_TITLE 45151
#define IDS_MEDIA_TRACK_IDENTIFIER_VERBOSE_TITLE_NUMBERED 45152
#define IDS_MEDIA_OVERFLOW_MENU_SHOW_AUDIO_TRACK_MENU_BUTTON 45153
#define IDS_MEDIA_OVERFLOW_MENU_SHOW_VIDEO_TRACK_MENU_BUTTON 45154
#define IDS_MEDIA_OVERFLOW_MENU_TRACK_SELECTION_SUBMENU_TITLE 45155
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED 45156
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_SUBMENU_TITLE 45157
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_25X_TITLE 45158
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_5X_TITLE 45159
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_75X_TITLE 45160
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_NORMAL_TITLE 45161
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_25X_TITLE 45162
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_5X_TITLE 45163
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_75X_TITLE 45164
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_2X_TITLE 45165
#define IDS_MEDIA_OVERFLOW_MENU_CAST 45166
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_FULLSCREEN 45167
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_FULLSCREEN 45168
#define IDS_MEDIA_OVERFLOW_MENU_MUTE 45169
#define IDS_MEDIA_OVERFLOW_MENU_UNMUTE 45170
#define IDS_MEDIA_OVERFLOW_MENU_PLAY 45171
#define IDS_MEDIA_OVERFLOW_MENU_PAUSE 45172
#define IDS_MEDIA_OVERFLOW_MENU_DOWNLOAD 45173
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_PICTURE_IN_PICTURE 45174
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_PICTURE_IN_PICTURE 45175
#define IDS_MEDIA_PICTURE_IN_PICTURE_INTERSTITIAL_TEXT 45176
#define IDS_MEDIA_REMOTING_CAST_TEXT 45177
#define IDS_MEDIA_REMOTING_CAST_TO_UNKNOWN_DEVICE_TEXT 45178
#define IDS_MEDIA_REMOTING_STOP_TEXT 45179
#define IDS_MEDIA_REMOTING_STOP_BY_PLAYBACK_QUALITY_TEXT 45180
#define IDS_MEDIA_REMOTING_STOP_BY_ERROR_TEXT 45181
#define IDS_MEDIA_SCRUBBING_MESSAGE_TEXT 45182
#define IDS_MEDIA_TRACKS_NO_LABEL 45183
#define IDS_MEDIA_TRACKS_OFF 45184
#define IDS_PLUGIN_INITIALIZATION_ERROR 45185
#define IDS_MEDIA_PLAYBACK_ERROR 45186
#define IDS_UNITS_KIBIBYTES 45187
#define IDS_UNITS_MEBIBYTES 45188
#define IDS_UNITS_GIBIBYTES 45189
#define IDS_UNITS_TEBIBYTES 45190
#define IDS_UNITS_PEBIBYTES 45191

// ---------------------------------------------------------------------------
// From branded_strings.h:

#define IDS_RELAUNCH_CONFIRMATION_DIALOG_TITLE 800
#define IDS_SETTINGS_ABOUT_PROGRAM 801
#define IDS_SETTINGS_GET_HELP_USING_CHROME 802
#define IDS_SETTINGS_UPGRADE_UPDATING 803
#define IDS_SETTINGS_UPGRADE_UPDATING_PERCENT 804
#define IDS_SETTINGS_UPGRADE_SUCCESSFUL_RELAUNCH 805
#define IDS_SETTINGS_UPGRADE_UP_TO_DATE 806
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_OFFLINE 809
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_SIGNED_OUT 810
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_NO_PASSWORDS 811
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT_GOOGLE_ACCOUNT 812
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT 813
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_GENERIC 814
#define IDS_SETTINGS_NO_COMPROMISED_CREDENTIALS_LABEL 815
#define IDS_SETTINGS_SIGNED_OUT_USER_LABEL 816
#define IDS_SETTINGS_SIGNED_OUT_USER_HAS_COMPROMISED_CREDENTIALS_LABEL 817
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION_GENERATION 818
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_DESCRIPTION 819
#define IDS_SETTINGS_AUTOFILL_AI_DESCRIPTION 820
#define IDS_SETTINGS_AUTOFILL_AI_DESCRIPTION_FEATURE_ON 821
#define IDS_SETTINGS_AUTOFILL_AI_DESCRIPTION_FEATURE_OFF 822
#define IDS_SETTINGS_AUTOFILL_AI_TOGGLE_SUB_LABEL 823
#define IDS_SETTINGS_AUTOFILL_AI_WHEN_ON_USE_TO_FILL 824
#define IDS_SETTINGS_DEFAULT_BROWSER_DEFAULT 825
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT 826
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT_AND_PIN 827
#define IDS_SETTINGS_DEFAULT_BROWSER_ERROR 828
#define IDS_SETTINGS_DEFAULT_BROWSER_SECONDARY 829
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_TWO 830
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_TWO 831
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_THINGS_TO_CONSIDER_BULLET_TWO 832
#define IDS_SETTINGS_PRELOAD_PAGES_THINGS_TO_CONSIDER_BULLET_ONE 833
#define IDS_SETTINGS_SPELLING_PREF_DESC 834
#define IDS_SETTINGS_RESTART_TO_APPLY_CHANGES 835
#define IDS_SETTINGS_SIGNIN_ALLOWED 836
#define IDS_SETTINGS_SIGNIN_ALLOWED_DESC 837
#define IDS_SETTINGS_SIGNIN_ALLOWED_DESC_2 838
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_BLOCKED 839
#define IDS_SETTINGS_SITE_SITE_DETAILS_CAMERA_BLOCKED_BY_OS 840
#define IDS_SETTINGS_SITE_SITE_DETAILS_MICROPHONE_BLOCKED_BY_OS 841
#define IDS_SETTINGS_SITE_SITE_DETAILS_LOCATION_BLOCKED_BY_OS 842
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_BY_OS 843
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_BY_OS 844
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_BY_OS 845
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_WITH_EXCEPTION_RADIO_SUBLABEL 846
#define IDS_SETTINGS_SITE_DATA_PAGE_DELETE_ON_EXIT_EXCEPTIONS_SUB_HEADING 847
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_BODY 848
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION2 849
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_PRIVACY_DESCRIPTION1 850
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL 851
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_SUB_LABEL 852
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION3 853
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION2 854
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_TITLE 855
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION 856
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_SUBLABEL 857
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_AND_NOTIFICATIONS_SETTING_SUBLABEL 858
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_TWO 859
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_TWO 860
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_ONE 861
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_LEARN_MORE_LABEL 862
#define IDS_SETTINGS_SECURE_DNS_DESCRIPTION 863
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_SINGULAR 864
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_PLURAL 865
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITHOUT_COUNTS 866
#define IDS_SETTINGS_CUSTOMIZE_YOUR_CHROME_PROFILE 867
#define IDS_SETTING_NAME_YOUR_PROFILE 868
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT_SECONDARY_WITH_ACCOUNT 869
#define IDS_SETTINGS_PEOPLE_EXPLICIT_SIGN_IN_PROMPT_SECONDARY_WITH_NO_ACCOUNT 870
#define IDS_SETTINGS_PEOPLE_EXPLICIT_SIGN_IN_PROMPT_SECONDARY_WITH_NO_ACCOUNT_WITH_BOOKMARKS 871
#define IDS_SETTINGS_PEOPLE_ACCOUNT_AWARE_SIGNIN_ACCOUNT_ROW_TITLE 872
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTIONS_TITLE 874
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTIONS_DESC 875
#define IDS_SETTINGS_PEOPLE_SIGNIN_SECTION_SIGNED_OUT_TITLE 876
#define IDS_SETTINGS_SYNC_DATA_ENCRYPTED_TEXT 877
#define IDS_SETTINGS_SYNC_DISCONNECT_TITLE 878
#define IDS_SETTINGS_SUGGEST_PREF_DESC 879
#define IDS_SETTINGS_SEARCH_AGGREGATOR_PREF_DESC 880
#define IDS_SETTINGS_SYNC_SIGN_IN_PROMPT_WITH_NO_ACCOUNT 881
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_DESC 882
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_DESC_WITH_LINKED_SERVICES 883
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_LINKED_SERVICES_DESC 884
#define IDS_SETTINGS_ERROR_PASSPHRASE_USER_ERROR_DESCRIPTION 885
#define IDS_SETTINGS_ERROR_TRUSTED_VAULT_USER_ERROR_DESCRIPTION 886
#define IDS_SETTINGS_ERROR_UPGRADE_CLIENT_USER_ERROR_DESCRIPTION 887
#define IDS_SETTINGS_PENDING_STATE_DESCRIPTION 888
#define IDS_SETTINGS_ERROR_PASSPHRASE_USER_ERROR_DESCRIPTION_WITH_EMAIL 889
#define IDS_SETTINGS_SIGN_OUT 890
#define IDS_SETTINGS_ACCOUNT_DATA_DASHBOARD 891
#define IDS_SETTINGS_ENCRYPT_ACCOUNT_DATA_WITH_PASSPHRASE_LABEL 892
#define IDS_SETTINGS_ENCRYPT_ACCOUNT_DATA_WITH_PASSPHRASE_EXPLANATION_TEXT 893
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_ACCOUNT_DATA_ENCRYPTION 894
#define IDS_SETTINGS_PAGE_CONTENT_THINGS_TO_CONSIDER_BULLET_TWO 895
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_SETTING_DESCRIPTION 896
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING_DESCRIPTION 897
#define IDS_SETTINGS_PERFORMANCE_PRELOAD_TOGGLE_SUMMARY 898
#define IDS_SETTINGS_LANGUAGES_IS_DISPLAYED_IN_THIS_LANGUAGE 899
#define IDS_SETTINGS_LANGUAGES_DISPLAY_IN_THIS_LANGUAGE 900
#define IDS_SETTINGS_SYSTEM_BACKGROUND_APPS_LABEL 901
#define IDS_SETTINGS_RESET_PROFILE_FEEDBACK 902
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_NOTHING_TO_DO 903
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_HEADER 904
#define IDS_SETTINGS_SAFETY_HUB_EMPTY_STATE_MODULE_SUBHEADER 905
#define IDS_SETTINGS_SAFETY_HUB_VERSION_MODULE_UPPERCASE_NAME 906
#define IDS_SETTINGS_SAFETY_HUB_VERSION_MODULE_LOWERCASE_NAME 907
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_NO_PASSWORDS 908
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_MODULE_HEADER 909
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_DATA_HEADER 910
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_DATA_SUBHEADER 911
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_INCOGNITO_HEADER 912
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_SAFE_BROWSING_SUBHEADER 913
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_HEADER_RESTART 914
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_HEADER_UPDATED 915
#define IDS_SETTINGS_SAFETY_HUB_VERSION_NAVIGATION_ARIA_LABEL 916
#define IDS_SETTINGS_SAFETY_HUB_VERSION_RELAUNCH_ARIA_LABEL 917
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_ONE_PERMISSION_LABEL 918
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_TWO_PERMISSIONS_LABEL 919
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_THREE_PERMISSIONS_LABEL 920
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_FOUR_OR_MORE_PERMISSIONS_LABEL 921
#define IDS_SETTINGS_SAFETY_HUB_ABUSIVE_NOTIFICATION_PERMISSIONS_SETTING_SUBLABEL 922
#define IDS_SETTINGS_SECURE_CONNECTIONS_SECTION_DESCRIPTION 923
#define IDS_SETTINGS_HTTPS_FIRST_MODE_SUBTITLE 924
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_FULL_SUBLABEL 925
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_INCOGNITO_SUBLABEL 926
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DISABLED_SUBLABEL 927
#define IDS_PRODUCT_NAME 101
#define IDS_SHORT_PRODUCT_NAME 103
#define IDS_SXS_SHORTCUT_NAME 928
#define IDS_SHORTCUT_NAME_BETA 929
#define IDS_SHORTCUT_NAME_DEV 930
#define IDS_PRODUCT_DESCRIPTION 931
#define IDS_WELCOME_TO_CHROME 932
#define IDS_PRODUCT_LOGO_ENTERPRISE_ALT_TEXT 937
#define IDS_SHORTCUT_NEW_WINDOW 938
#define IDS_TASK_MANAGER_TITLE 939
#define IDS_TASK_MANAGER_SEARCH_PLACEHOLDER 940
#define IDS_TASK_MANAGER_SEARCH_ACCESSIBILITY_NAME 941
#define IDS_TASK_MANAGER_CLEAR_SEARCH_BUTTON_ACCESSIBILITY_NAME 942
#define IDS_TASK_MANAGER_KILL_ACCESSIBILITY_NAME 943
#define IDS_TASK_MANAGER_TASK_KILL_SUCCESS_ACCESSIBILITY_MESSAGE 944
#define IDS_TASK_MANAGER_TASK_KILL_FAIL_ACCESSIBILITY_MESSAGE 945
#define IDS_TASK_MANAGER_CATEGORY_TABS_AND_EXTENSIONS_NAME 946
#define IDS_TASK_MANAGER_CATEGORY_SYSTEM_NAME 947
#define IDS_TASK_MANAGER_CATEGORY_BROWSER_NAME 948
#define IDS_TASK_MANAGER_CATEGORY_ALL_NAME 949
#define IDS_SESSION_CRASHED_VIEW_UMA_OPTIN 950
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION_IN_BULLET_POINTS 951
#define IDS_BROWSER_WINDOW_TITLE_FORMAT 475
#define IDS_CAPTIVE_PORTAL_BROWSER_WINDOW_TITLE_FORMAT 952
#define IDS_ACCESSIBLE_BROWSER_WINDOW_TITLE_FORMAT 694
#define IDS_ACCESSIBLE_BETA_BROWSER_WINDOW_TITLE_FORMAT 953
#define IDS_ACCESSIBLE_DEV_BROWSER_WINDOW_TITLE_FORMAT 954
#define IDS_ACCESSIBLE_CANARY_BROWSER_WINDOW_TITLE_FORMAT 955
#define IDS_ABOUT_VERSION_COMPANY_NAME 956
#define IDS_ABOUT_VERSION_COPYRIGHT 957
#define IDS_ABOUT_TERMS_OF_SERVICE 961
#define IDS_WIN_XP_VISTA_OBSOLETE 963
#define IDS_WIN_7_OBSOLETE 964
#define IDS_WIN_8_OBSOLETE 965
#define IDS_WIN_8_1_OBSOLETE 966
#define IDS_ACCNAME_APP 437
#define IDS_BROWSER_HUNGBROWSER_MESSAGE 968
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES 969
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES_ORIGIN 970
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_NOT_FOUND 971
#define IDS_UNINSTALL_CLOSE_APP 972
#define IDS_UNINSTALL_VERIFY 973
#define IDS_UNINSTALL_CHROME 974
#define IDS_FR_CUSTOMIZE_DEFAULT_BROWSER 975
#define IDS_STATUS_TRAY_KEEP_CHROME_RUNNING_IN_BACKGROUND 976
#define IDS_STATUS_TRAY_KEEP_CHROME_RUNNING_IN_BACKGROUND_SETTING 977
#define IDS_CANT_WRITE_USER_DIRECTORY_SUMMARY 978
#define IDS_PROFILE_TOO_NEW_ERROR 980
#define IDS_PREFERENCES_UNREADABLE_ERROR 981
#define IDS_PREFERENCES_CORRUPT_ERROR 982
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_C 984
#define IDS_PASSWORD_MANAGER_TITLE_BRAND 985
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SAVING_ON_DEVICE 986
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 987
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 988
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT 990
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT 991
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT 992
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT 993
#define IDS_PASSWORDS_PAGE_DELETE_ALL_DATA_AUTHENTICATION_PROMPT 994
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT 995
#define IDS_INSTALL_HIGHER_VERSION 996
#define IDS_INSTALL_FAILED 997
#define IDS_SAME_VERSION_REPAIR_FAILED 998
#define IDS_INSTALL_OS_NOT_SUPPORTED 999
#define IDS_INSTALL_OS_ERROR 1000
#define IDS_INSTALL_SINGLETON_ACQUISITION_FAILED 1001
#define IDS_INSTALL_TEMP_DIR_FAILED 1002
#define IDS_INSTALL_UNCOMPRESSION_FAILED 1003
#define IDS_INSTALL_INVALID_ARCHIVE 1004
#define IDS_INSTALL_INSUFFICIENT_RIGHTS 1005
#define IDS_INSTALL_EXISTING_VERSION_LAUNCHED 1006
#define IDS_ELEVATION_SERVICE_DESCRIPTION 1007
#define IDS_TRACING_SERVICE_DESCRIPTION 1008
#define IDS_PASSWORD_MANAGER_IMPORT_DIALOG_TITLE 1009
#define IDS_PASSWORD_MANAGER_EXPORT_DIALOG_TITLE 1010
#define IDS_SHORTCUT_TOOLTIP 1011
#define IDS_UNINSTALL_DELETE_PROFILE 1012
#define IDS_UNINSTALL_SET_DEFAULT_BROWSER 1013
#define IDS_UNINSTALL_BUTTON_TEXT 1014
#define IDS_PIN_INFOBAR_TEXT 1015
#define IDS_PIN_INFOBAR_BUTTON 1016
#define IDS_DEFAULT_BROWSER_INFOBAR_TEXT 1019
#define IDS_DEFAULT_BROWSER_PIN_INFOBAR_TEXT 1020
#define IDS_PDF_INFOBAR_TEXT 1021
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNKNOWN_SOURCE 1022
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_BLOCKED_LEARN_MORE_LINK 1023
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_LOCAL_DECRYPTION 1024
#define IDS_DOWNLOAD_STATUS_CRX_INSTALL_RUNNING 1025
#define IDS_PROMPT_DOWNLOAD_CHANGES_SETTINGS 1026
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_URL 1027
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_CONTENT 1028
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING 1029
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_FILETYPE 1030
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS 1031
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_COOKIE_THEFT 1032
#define IDS_BLOCK_DOWNLOAD_REASON_UNCOMMON 1033
#define IDS_BLOCK_DOWNLOAD_REASON_UNCOMMON_SUSPICIOUS_ARCHIVE 1034
#define IDS_BLOCK_DOWNLOAD_REASON_POTENTIALLY_UNWANTED 1035
#define IDS_BLOCK_DOWNLOAD_REASON_INSECURE 1036
#define IDS_BLOCK_DOWNLOAD_REASON_UNVERIFIED_NO_SAFE_BROWSING 1037
#define IDS_DOWNLOAD_WARNING_BYPASS_PROMPT_LEARN_MORE_LINK 1038
#define IDS_DOWNLOAD_WARNING_BYPASS_PROMPT_LEARN_MORE_LINK_ACCESSIBLE 1039
#define IDS_ABANDON_DOWNLOAD_DIALOG_BROWSER_MESSAGE 1040
#define IDS_MISSING_GOOGLE_API_KEYS 1042
#define IDS_EXTENSION_INSTALLED_HEADING 1043
#define IDS_EXTENSION_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX 1044
#define IDS_EXTENSION_ALERT_ITEM_BLOCKLISTED_MALWARE 1045
#define IDS_EXTENSIONS_ALERT_ITEM_BLOCKLISTED_MALWARE_TITLE 1046
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_KEEP_DIALOG_DESCRIPTION 1047
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_DESCRIPTION 1048
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_DISABLED_SUBTITLE 1049
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISABLED_SUBTITLE 1050
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_REMOVE_BUTTON_ACC_LABEL 1051
#define IDS_SAFETY_CHECK_EXTENSIONS_MALWARE 1052
#define IDS_SAFETY_CHECK_EXTENSIONS_POLICY_VIOLATION 1053
#define IDS_SAFETY_CHECK_EXTENSIONS_UNPUBLISHED 1054
#define IDS_EXTENSIONS_SAFETY_CHECK_PRIMARY_LABEL 1055
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE 1056
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE_ON 1057
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE_OFF 1058
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES 1059
#define IDS_EXTENSIONS_SC_DESCRIPTION 1060
#define IDS_EXTENSIONS_ITEM_SHOW_ACCESS_REQUESTS_IN_TOOLBAR 1061
#define IDS_EXTENSIONS_INCOGNITO_WARNING 1062
#define IDS_EXTENSIONS_UNINSTALL 1063
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_IN_CHROME 1064
#define IDS_PENDING_CHANGE_WARNING 1065
#define IDS_EXTENSIONS_MULTIPLE_UNSUPPORTED_DISABLED_BODY 1066
#define IDS_EXTENSIONS_SINGLE_UNSUPPORTED_DISABLED_BODY 1067
#define IDS_APPMENU_TOOLTIP 438
#define IDS_APPMENU_TOOLTIP_UPDATE_AVAILABLE 1068
#define IDS_APPMENU_TOOLTIP_ALERT 1069
#define IDS_OPEN_IN_CHROME 1070
#define IDS_ABOUT 1071
#define IDS_RELAUNCH_TO_UPDATE 1072
#define IDS_CUSTOMIZE_CHROME 1076
#define IDS_OTHER_CHROME_PROFILES_TITLE 1077
#define IDS_MANAGE_CHROME_PROFILES 1078
#define IDS_VIEW_PASSWORDS 1079
#define IDS_CHROME_SIGNIN_TITLE 1080
#define IDS_PROFILES_DICE_SYNC_PROMO 1081
#define IDS_SYNC_WRONG_EMAIL 1082
#define IDS_SYNC_USED_PROFILE_ERROR 1083
#define IDS_SESSION_RESTORE_TURN_OFF_RESTORE_FROM_SESSION 1084
#define IDS_SESSION_RESTORE_TURN_OFF_RESTORE_FROM_RESTART 1085
#define IDS_SESSION_RESTORE_TURN_ON 1086
#define IDS_SESSION_RESTORE_LINK 1087
#define IDS_ENTERPRISE_VALUE_PROPOSITION_PROFILE_REQUIRED_BY_ORG_TITLE 1088
#define IDS_ENTERPRISE_SIGNIN_TITLE 1089
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITHOUT_PROFILE_CREATION 1090
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITH_PROFILE_CREATION 1091
#define IDS_ENTERPRISE_VALUE_PROPOSITION_PROFILE_REQUIRED_BY_ORG_KNOWN_DOMAIN_TITLE 1092
#define IDS_ENTERPRISE_VALUE_PROPOSITION_PROFILE_SUGGESTED_TITLE 1093
#define IDS_ONE_CLICK_SIGNIN_DIALOG_TITLE_NEW 1094
#define IDS_ONE_CLICK_SIGNIN_DIALOG_MESSAGE_NEW 1095
#define IDS_MANAGEMENT_DIALOG_BROWSER_MANAGED 1096
#define IDS_MANAGEMENT_DIALOG_BROWSER_MANAGED_BY 1097
#define IDS_MANAGEMENT_DIALOG_BROWSER_MANAGED_BY_MULTIPLE_ORGANIZATIONS 1098
#define IDS_MANAGED_PROFILE_INTERSTITIAL_PRIMARY_PARAGRAPH 1099
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_TITLE 1100
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_BODY_PART_1 1101
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_TITLE_FALLBACK 1102
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_UNKNOWN_BROWSER 1103
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_KNOWN_BROWSER 1104
#define IDS_NTP_CUSTOMIZE_BUTTON_LABEL 508
#define IDS_NTP_MODULES_SETUP_LIST_TITLE 1105
#define IDS_IPH_CUSTOMIZE_CHROME_AUTO_OPEN_BODY 1106
#define IDS_IPH_CUSTOMIZE_CHROME_AUTO_OPEN_SCREENREADER 1107
#define IDS_IPH_REALBOX_CONTEXTUAL_ENTRYPOINT 1108
#define IDS_IPH_REALBOX_CONTEXTUAL_ENTRYPOINT_SCREENREADER 1109
#define IDS_SIGNIN_EMAIL_CONFIRMATION_TITLE 1110
#define IDS_AVATAR_BUTTON_INTERCEPT_BUBBLE_CHROME_SIGNIN_TEXT 1111
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_TITLE 1112
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_DECLINE_TEXT 1113
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE_V2 1114
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_TITLE 1115
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2 1116
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2_SUPERVISED 1117
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC 1118
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_DESC 1119
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_SUBTITLE 1120
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_SUBTITLE_WITH_BOOKMARKS 1121
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_SUBTITLE_SUPERVISED 1122
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TEXT_SIGNIN_REMINDER 1123
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TEXT_SIGNIN_REMINDER_SCREENREADER 1124
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_NO_UNSYNCED_TITLE 1125
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_NO_UNSYNCED_BODY 1126
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_NO_UNSYNCED_DATA_BODY 1127
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_VERIFY_BODY 1128
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_UNSYNCED_BODY 1129
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_TEXT 1130
#define IDS_SYNC_PASSPHRASE_DIALOG_FOOTER 1131
#define IDS_SYNC_PASSPHRASE_DIALOG_FOOTER_LINK_ACC 1132
#define IDS_SYNC_PASSPHRASE_DIALOG_BODY 1133
#define IDS_AVATAR_BUTTON_INTERCEPT_BUBBLE_CHROME_SIGNIN_ACCESSIBILITY_LABEL 1134
#define IDS_AVATAR_BUTTON_SIGNIN_PENDING_ACCESSIBILITY_LABEL 1135
#define IDS_AUTOFILL_SIGNIN_PROMO_SUBTITLE_PASSWORD 1136
#define IDS_AUTOFILL_SIGNIN_PROMO_SUBTITLE_ADDRESS 1137
#define IDS_PROFILE_CUSTOMIZATION_TEXT 1138
#define IDS_PROFILE_CUSTOMIZATION_TITLE_V2 1139
#define IDS_PROFILE_MENU_SIGNIN_PROMO_BUTTON 1144
#define IDS_PROFILE_MENU_PLACEHOLDER_PROFILE_NAME 1145
#define IDS_PROFILE_MENU_SIGN_OUT_WHEN_SIGNIN_PENDING 1146
#define IDS_PROFILE_MENU_PROFILES_LIST_TITLE 1147
#define IDS_PROFILE_MENU_MANAGE_PROFILES 1148
#define IDS_PROFILE_MENU_SIGN_OUT 1149
#define IDS_PROFILE_MENU_ADD_PROFILE 1150
#define IDS_APP_ALSO_DELETE_APPS_DATA 1152
#define IDS_APP_SHORTCUTS_SUBDIR_NAME 1153
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_CANARY 1154
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_BETA 1155
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_DEV 1156
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_AND_VIDEO 1158
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_ONLY 1159
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_VIDEO_ONLY 1160
#define IDS_WEBHID_SYSTEM_TRAY_ICON_TITLE 1161
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_TITLE 1162
#define IDS_LOGIN_POD_USER_REMOVE_WARNING_SYNC 1165
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TITLE 1166
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TEXT 1167
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TITLE 1168
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TEXT 1169
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_GUEST_TEXT 1170
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_FRIENDS_TEXT 1171
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_TEXT 1172
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_ADD_USER 1173
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_APP_MENU 1174
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORD_MANAGER 1175
#define IDS_TUTORIAL_PASSWORD_MANAGER_SUCCESS_BODY 1176
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_BODY 1177
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_PAGES 1178
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_SEARCH 1179
#define IDS_WEBSTORE_APP_DESCRIPTION 377
#define IDS_INBOUND_MDNS_RULE_NAME 1180
#define IDS_INBOUND_MDNS_RULE_NAME_BETA 1181
#define IDS_INBOUND_MDNS_RULE_NAME_CANARY 1182
#define IDS_INBOUND_MDNS_RULE_NAME_DEV 1183
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION 1184
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_BETA 1185
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_CANARY 1186
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_DEV 1187
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT 1188
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT_ONCE 1189
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TEXT 1190
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB_INAPP 1191
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD_INAPP 1192
#define IDS_AVATAR_BUTTON_MAKING_CHROME_YOURS 1193
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE 1194
#define IDS_UPDATE_RECOMMENDED 1195
#define IDS_RELAUNCH_AND_UPDATE 1196
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE_ALT 1197
#define IDS_UPDATE_RECOMMENDED_ALT 1198
#define IDS_REINSTALL_APP 1199
#define IDS_UPGRADE_BUBBLE_MENU_ITEM 1200
#define IDS_UPGRADE_BUBBLE_TITLE 1201
#define IDS_UPGRADE_BUBBLE_TEXT 1202
#define IDS_SYNC_ERROR_USER_MENU_UPGRADE_BUTTON 1203
#define IDS_SYNC_ERROR_PASSPHRASE_USER_MENU_ERROR_DESCRIPTION 1204
#define IDS_SYNC_ERROR_TRUSTED_VAULT_USER_MENU_ERROR_DESCRIPTION 1205
#define IDS_SYNC_ERROR_UPGRADE_CLIENT_USER_MENU_TITLE 1206
#define IDS_SYNC_ERROR_UPGRADE_CLIENT_USER_MENU_ERROR_DESCRIPTION 1207
#define IDS_SYNC_UPGRADE_CLIENT 1208
#define IDS_SYNC_UPGRADE_CLIENT_BUTTON 1209
#define IDS_RECOVERY_BUBBLE_TITLE 1210
#define IDS_RUN_RECOVERY 1211
#define IDS_RECOVERY_BUBBLE_TEXT 1212
#define IDS_CRITICAL_NOTIFICATION_TITLE 1213
#define IDS_CRITICAL_NOTIFICATION_TITLE_ALTERNATE 1214
#define IDS_CRITICAL_NOTIFICATION_TEXT 1215
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_TAB 1216
#define IDS_DESKTOP_MEDIA_PICKER_SCREEN_PERMISSION_TEXT_MAC 1217
#define IDS_DESKTOP_MEDIA_PICKER_SCREEN_PERMISSION_TEXT_PERIOD_MAC 1218
#define IDS_DESKTOP_MEDIA_PICKER_WINDOW_PERMISSION_TEXT_MAC 1219
#define IDS_DESKTOP_MEDIA_PICKER_WINDOW_PERMISSION_TEXT_PERIOD_MAC 1220
#define IDS_DESKTOP_MEDIA_PICKER_PERMISSION_RESTART_TEXT_MAC 1221
#define IDS_SIDE_PANEL_CUSTOMIZE_CHROME_TITLE 672
#define IDS_HISTORY_HISTORY_MENU_ITEM 1239
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_IPH 1240
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_IPH_SCREENREADER 1241
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_FOLLOWUP_IPH 1242
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_FOLLOWUP_IPH_SCREENREADER 1243
#define IDS_LENS_OVERLAY_COPY 1244
#define IDS_LENS_OVERLAY_COPY_TEXT 1245
#define IDS_LENS_OVERLAY_COPY_TOAST_MESSAGE 1246
#define IDS_LENS_OVERLAY_COPY_AS_IMAGE_TOAST_MESSAGE 1247
#define IDS_LENS_OVERLAY_FEEDBACK_TOAST_MESSAGE 1248
#define IDS_LENS_OVERLAY_FEEDBACK_TOAST_MESSAGE_ALT 1249
#define IDS_LENS_OVERLAY_SEND_FEEDBACK_BUTTON_LABEL 1250
#define IDS_LENS_OVERLAY_CLOSE_FEEDBACK_TOAST_ACCESSIBILITY_LABEL 1251
#define IDS_LENS_OVERLAY_MORE_OPTIONS_BUTTON_LABEL 1252
#define IDS_LENS_OVERLAY_MY_ACTIVITY 1253
#define IDS_LENS_OVERLAY_TOAST_PAGE_CONTENT_NOT_FOUND_MESSAGE 1254
#define IDS_LENS_OVERLAY_TOAST_DISMISS_MESSAGE 1255
#define IDS_LENS_OVERLAY_TRANSLATE 1256
#define IDS_LENS_OVERLAY_SELECT_TEXT 1257
#define IDS_LENS_OVERLAY_COPY_AS_IMAGE 1258
#define IDS_LENS_OVERLAY_SAVE_AS_IMAGE 1259
#define IDS_LENS_OVERLAY_LEARN_MORE 1260
#define IDS_LENS_OVERLAY_INITIAL_TOAST_LABEL 1261
#define IDS_LENS_OVERLAY_INITIAL_TOAST_MESSAGE 1262
#define IDS_LENS_OVERLAY_INITIAL_TOAST_LABEL_SIMPLIFIED 1263
#define IDS_LENS_OVERLAY_INITIAL_TOAST_MESSAGE_SIMPLIFIED 1264
#define IDS_LENS_OVERLAY_INITIAL_TOAST_MESSAGE_SELECT_TEXT 1265
#define IDS_LENS_OVERLAY_INITIAL_TOAST_ERROR_MESSAGE 1266
#define IDS_LENS_OVERLAY_INITIAL_TOAST_ERROR_EXIT_BUTTON_TEXT 1267
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_DRAG_MESSAGE 1268
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_TEXT_HIGHLIGHT_MESSAGE 1269
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_CLICK_MESSAGE 1270
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_LIVE_PAGE_MESSAGE 1271
#define IDS_LENS_OVERLAY_AUTO_DETECT_LANGUAGE_LABEL 1272
#define IDS_LENS_OVERLAY_TRANSLATE_BUTTON_LABEL 1273
#define IDS_LENS_OVERLAY_SOURCE_LANGUAGE_PICKER_MENU_TITLE 1274
#define IDS_LENS_OVERLAY_TARGET_LANGUAGE_PICKER_MENU_TITLE 1275
#define IDS_LENS_OVERLAY_RECENT_LANGUAGES_LABEL 1276
#define IDS_LENS_OVERLAY_ALL_LANGUAGES_LABEL 1277
#define IDS_LENS_OVERLAY_DETECTED_LABEL 1278
#define IDS_LENS_OVERLAY_DETECT_LANGUAGE_LABEL 1279
#define IDS_LENS_SEND_FEEDBACK 1280
#define IDS_LENS_SEND_FEEDBACK_PLACEHOLDER 1281
#define IDS_LENS_OVERLAY_RENDERER_LABEL 1282
#define IDS_LENS_OVERLAY_CLOSE_TRANSLATE_SCREEN_LABEL 1283
#define IDS_LENS_OVERLAY_LANGUAGE_PICKER_LABEL 1284
#define IDS_LENS_OVERLAY_SOURCE_LANGUAGE_ACCESSIBILITY_LABEL 1285
#define IDS_LENS_OVERLAY_TARGET_LANGUAGE_ACCESSIBILITY_LABEL 1286
#define IDS_LENS_OVERLAY_SEARCH_LANGUAGE_PICKER_LABEL 1287
#define IDS_LENS_OVERLAY_TOP_LEFT_CORNER_SLIDER_ACCESSIBILITY_LABEL 1288
#define IDS_LENS_OVERLAY_TOP_RIGHT_CORNER_SLIDER_ACCESSIBILITY_LABEL 1289
#define IDS_LENS_OVERLAY_BOTTOM_RIGHT_CORNER_SLIDER_ACCESSIBILITY_LABEL 1290
#define IDS_LENS_OVERLAY_BOTTOM_LEFT_CORNER_SLIDER_ACCESSIBILITY_LABEL 1291
#define IDS_LENS_OVERLAY_SEARCH_SCREENSHOT_ACCESSIBILITY_LABEL 1292
#define IDS_LENS_OVERLAY_TRANSLATE_BUTTON_IPH 1293
#define IDS_LENS_OVERLAY_TRANSLATE_BUTTON_IPH_SCREENREADER 1294
#define IDS_CONTENT_CONTEXT_LENS_OVERLAY 1295
#define IDS_CONTENT_LENS_OVERLAY_ENTRYPOINT_LABEL 1296
#define IDS_CONTENT_LENS_OVERLAY_HOMEWORK_ENTRYPOINT_LABEL 1297
#define IDS_CONTENT_LENS_OVERLAY_ASK_GOOGLE_ENTRYPOINT_LABEL 1298
#define IDS_SIDE_PANEL_LENS_OVERLAY_TOOLBAR_TOOLTIP 1299
#define IDS_LENS_OVERLAY_ENTRYPOINT_LABEL_ALT1 1300
#define IDS_LENS_OVERLAY_ENTRYPOINT_LABEL_ALT2 1301
#define IDS_LENS_OVERLAY_ENTRYPOINT_LABEL_ALT3 1302
#define IDS_LENS_OVERLAY_IMAGE_ENTRYPOINT_LABEL_ALT1 1303
#define IDS_LENS_OVERLAY_IMAGE_ENTRYPOINT_LABEL_ALT2 1304
#define IDS_LENS_OVERLAY_IMAGE_ENTRYPOINT_LABEL_ALT3 1305
#define IDS_LENS_OVERLAY_VIDEO_ENTRYPOINT_LABEL_ALT1 1306
#define IDS_LENS_OVERLAY_VIDEO_ENTRYPOINT_LABEL_ALT2 1307
#define IDS_LENS_OVERLAY_VIDEO_ENTRYPOINT_LABEL_ALT3 1308
#define IDS_AI_MODE_ENTRYPOINT_LABEL 1309
#define IDS_SIDE_PANEL_LENS_OVERLAY_GENERIC_ERROR_PAGE_FIRST_LINE 1310
#define IDS_SIDE_PANEL_LENS_OVERLAY_GENERIC_ERROR_PAGE_SECOND_LINE 1311
#define IDS_SIDE_PANEL_LENS_OVERLAY_PROTECTED_PAGE_ERROR_FIRST_LINE 1312
#define IDS_SIDE_PANEL_LENS_OVERLAY_PROTECTED_PAGE_ERROR_SECOND_LINE 1313
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CANCEL_BUTTON 1314
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CONTINUE_BUTTON 1315
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CSB_DESCRIPTION 1316
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_DESCRIPTION 1317
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_LEARN_MORE_LINK 1318
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_TITLE 1319
#define IDS_SHOW_LENS_OVERLAY 1321
#define IDS_CONTEXT_MENU_SHOW_GOOGLE_LENS_SHORTCUT 1320
#define IDS_LENS_CONTEXTUAL_SEARCH_DEFAULT_QUERY 1322
#define IDS_LENS_CONTEXTUAL_SEARCH_ZERO_STATE_QUERY 1323
#define IDS_LENS_COMPOSEBOX_HINT_TEXT 1324
#define IDS_CONTEXT_MENU_SHOW_AI_MODE_OMNIBOX_BUTTON 1325
#define IDS_WIN_NOTIFICATION_SETTINGS_CONTEXT_MENU_ITEM_NAME 1328
#define IDS_RELAUNCH_RECOMMENDED_TITLE 1329
#define IDS_RELAUNCH_RECOMMENDED_BODY 1330
#define IDS_RELAUNCH_REQUIRED_TITLE_DAYS 1331
#define IDS_RELAUNCH_REQUIRED_TITLE_HOURS 1332
#define IDS_RELAUNCH_REQUIRED_TITLE_MINUTES 1333
#define IDS_RELAUNCH_REQUIRED_TITLE_SECONDS 1334
#define IDS_RELAUNCH_REQUIRED_BODY 1335
#define IDS_ADVANCED_PROTECTION_RELAUNCH_REQUIRED_BODY 1336
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_TOOLTIP 1337
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_ERROR 1338
#define IDS_ENTERPRISE_STARTUP_RELAUNCH_BUTTON 1339
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WEB_CONTENTS_ONLY 1340
#define IDS_IDLE_BUBBLE_TITLE_CLOSE 1341
#define IDS_IDLE_BUBBLE_BODY_CLOSE_AND_CLEAR 1342
#define IDS_IDLE_BUBBLE_BODY_CLEAR 1343
#define IDS_IDLE_BUBBLE_BODY_CLOSE 1344
#define IDS_IDLE_TIMEOUT_CLOSE_TITLE 1345
#define IDS_IDLE_TIMEOUT_CLEAR_TITLE 1346
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_TITLE 1347
#define IDS_IDLE_TIMEOUT_CLOSE_BODY 1348
#define IDS_IDLE_TIMEOUT_CLEAR_BODY 1349
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_BODY 1350
#define IDS_IDLE_DISMISS_BUTTON 1351
#define IDS_HATS_BUBBLE_TITLE 1352
#define IDS_EXTENSION_PERMISSIONS_BLOCKED_BY_PARENT_PROMPT_MESSAGE 1354
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_APP 1355
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_EXTENSION 1356
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_THEME 1357
#define IDS_EXTENSION_EXTERNAL_INITIAL_INSTALL_PROMPT_TITLE_EXTENSION 1358
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ABORT_BUTTON 1359
#define IDS_ENTERPRISE_WELCOME_PROFILE_INFORMATION_DETAILS 1360
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE 1361
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_V2 1362
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_KEEP_EVERYTHING_IN_CHROME 1363
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE 1364
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_KEEP_WORK_AND_LIFE_SEPARATE 1365
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_GOT_ANOTHER_GOOGLE_ACCOUNT 1366
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_KEEP_TASKS_SEPARATE 1367
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_TITLE 1368
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TEXT 1369
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TEXT 1370
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_TITLE 1371
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SUBTITLE 1372
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_SUPPORTED_BY_GLIC_FLOW_BODY 1373
#define IDS_FRE_SIGN_IN_TITLE_0 1374
#define IDS_FRE_DEFAULT_BROWSER_TITLE 1375
#define IDS_FRE_DEFAULT_BROWSER_AND_PINNING_TITLE 1376
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE_NEW 1377
#define IDS_FRE_DEFAULT_BROWSER_AND_PINNING_SUBTITLE 1378
#define IDS_FRE_DEFAULT_BROWSER_ILLUSTRATION_ALT_TEXT 1379
#define IDS_APP_MENU_TOOLTIP_DEFAULT_PROMPT 1380
#define IDS_APP_MENU_BUTTON_DEFAULT_PROMPT 1381
#define IDS_SET_BROWSER_AS_DEFAULT_MENU_ITEM 1382
#define IDS_PROFILE_SWITCH_PROMO 1383
#define IDS_PROFILE_SWITCH_PROMO_SCREENREADER 1384
#define IDS_PASSWORD_MANAGER_IPH_BODY_WEB_APP_PROFILE_SWITCH 1385
#define IDS_SIGNOUT_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNOUT_IPH_TEXT 1386
#define IDS_SIGNOUT_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNOUT_IPH_TEXT_SCREENREADER 1387
#define IDS_QUIET_NOTIFICATION_IPH_TEXT 1388
#define IDS_QUIET_NOTIFICATION_IPH_TEXT_SCREENREADER 1389
#define IDS_CHROMELABS_RELAUNCH_FOOTER_MESSAGE 1390
#define IDS_SERIAL_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 1391
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_TITLE 1392
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_TITLE 1393
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION 1394
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION_UPDATED 1395
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_ACCEPT 1396
#define IDS_SETTINGS_SECURITY_JAVASCRIPT_OPTIMIZATION_LINK_ROW_ENABLED 1397
#define IDS_SETTINGS_SECURITY_JAVASCRIPT_OPTIMIZATION_LINK_ROW_DISABLED 1398
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_DESCRIPTION 1399
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_ALLOWED_SUB_LABEL 1400
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_SUB_LABEL 1401
#define IDS_FRIENDLY_COMPANY_NAME 1402
#define IDS_NO_UPDATE_RESPONSE 1403
#define IDS_INSTALL_UPDATER_FAILED 1404
#define IDS_INSTALLER_DISPLAY_NAME 1405
#define IDS_CLOSE_BUTTON 1406
#define IDS_MINIMIZE_BUTTON 1407
#define IDS_INITIALIZING 1408
#define IDS_WAITING_TO_CONNECT 1409
#define IDS_DOWNLOADING_SHORT 1410
#define IDS_DOWNLOADING_LONG 1411
#define IDS_DOWNLOADING_VERY_LONG 1412
#define IDS_DOWNLOADING_COMPLETED 1413
#define IDS_DOWNLOADING 1414
#define IDS_WAITING_TO_INSTALL 1415
#define IDS_INSTALLING 1416
#define IDS_CANCELING 1417
#define IDS_TEXT_RESTART_BROWSER 1418
#define IDS_TEXT_RESTART_ALL_BROWSERS 1419
#define IDS_TEXT_RESTART_COMPUTER 1420
#define IDS_UPDATER_CLOSE 1421
#define IDS_RESTART_NOW 1422
#define IDS_RESTART_LATER 1423
#define IDS_GET_HELP_TEXT 1424
#define IDS_INSTALLATION_STOPPED_WINDOW_TITLE 1425
#define IDS_INSTALL_STOPPED 1426
#define IDS_RESUME_INSTALLATION 1427
#define IDS_CANCEL_INSTALLATION 1428
#define IDS_BUNDLE_INSTALLED_SUCCESSFULLY 1429
#define IDS_UPDATER_OS_NOT_SUPPORTED 1430
#define IDS_EXTRA_CODE 1431
#define IDS_UNABLE_TO_GET_SETUP_LOCK 1432
#define IDS_WRONG_USER_ELEVATION_REQUIRED_ERROR 1433
#define IDS_WRONG_USER_DEELEVATION_REQUIRED_ERROR 1434
#define IDS_GENERIC_STARTUP_ERROR 1435
#define IDS_NO_NETWORK_PRESENT_ERROR 1436
#define IDS_ERROR_HTTPSTATUS_UNAUTHORIZED 1437
#define IDS_ERROR_HTTPSTATUS_FORBIDDEN 1438
#define IDS_ERROR_HTTPSTATUS_PROXY_AUTH_REQUIRED 1439
#define IDS_UNKNOWN_APPLICATION 1440
#define IDS_RESTRICTED_RESPONSE_FROM_SERVER 1441
#define IDS_OS_NOT_SUPPORTED 1442
#define IDS_HW_NOT_SUPPORTED 1443
#define IDS_NO_HASH 1444
#define IDS_UNSUPPORTED_PROTOCOL 1445
#define IDS_INTERNAL 1446
#define IDS_GENERIC_UPDATE_CHECK_ERROR 1447
#define IDS_DOWNLOAD_HASH_MISMATCH 1448
#define IDS_UPDATER_DISK_FULL 1449
#define IDS_GENERIC_DOWNLOAD_ERROR 1450
#define IDS_UNPACK_CACHING_ERROR 1451
#define IDS_GENERIC_UNPACK_ERROR 1452
#define IDS_SERVICE_ERROR_CANCELLED 1453
#define IDS_GENERIC_SERVICE_ERROR 1454
#define IDS_GENERIC_INSTALL_ERROR 1455
#define IDS_GENERIC_INSTALLER_ERROR 1456
#define IDS_INSTALL_REBOOT 1457
#define IDS_APP_INSTALL_DISABLED_BY_GROUP_POLICY 1458
#define IDS_INVALID_INSTALLER_FILENAME 1459
#define IDS_INSTALLER_FAILED_TO_START 1460
#define IDS_INSTALLER_TIMED_OUT 1461
#define IDS_GENERIC_METAINSTALLER_ERROR 1462
#define IDS_FAILED_TO_ELEVATE_METAINSTALLER 1463
#define IDS_UPDATER_SERVICE_DISPLAY_NAME 1464
#define IDS_INTERNAL_UPDATER_SERVICE_DISPLAY_NAME 1465
#define IDS_UPDATER_SERVICE_DESCRIPTION 1466
#define IDS_MEMORY_SAVER_DIALOG_BODY 1467
#define IDS_MEMORY_SAVER_MODE_PROMO_TITLE 390
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_V1 1468
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_SINGULAR_V1 1469
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_UPDATED_V3 1470
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_SIGNED_IN 1471
#define IDS_CREATE_SHORTCUT_NOT_APPS_DIALOG_SUBTITLE 1472
#define IDS_CLEAR_BROWSING_DATA_TOAST_BODY 1474
#define IDS_GLIC_PROMO_TITLE 1475
#define IDS_GLIC_TAB_STRIP_BUTTON_TOOLTIP 1476
#define IDS_GLIC_TAB_STRIP_BUTTON_TOOLTIP_CLOSE 1477
#define IDS_GLIC_THREE_DOT_MENU_ITEM 1478
#define IDS_GLIC_STATUS_ICON_TOOLTIP 1479
#define IDS_GLIC_STATUS_ICON_TOOLTIP_CANARY 1480
#define IDS_GLIC_STATUS_ICON_TOOLTIP_DEV 1481
#define IDS_GLIC_STATUS_ICON_TOOLTIP_BETA 1482
#define IDS_GLIC_STATUS_ICON_TOOLTIP_CLOSE 1483
#define IDS_GLIC_STATUS_ICON_TOOLTIP_CLOSE_CANARY 1484
#define IDS_GLIC_STATUS_ICON_TOOLTIP_CLOSE_DEV 1485
#define IDS_GLIC_STATUS_ICON_TOOLTIP_CLOSE_BETA 1486
#define IDS_GLIC_STATUS_ICON_TOOLTIP_TOGGLE 1487
#define IDS_GLIC_STATUS_ICON_TOOLTIP_TOGGLE_CANARY 1488
#define IDS_GLIC_STATUS_ICON_TOOLTIP_TOGGLE_DEV 1489
#define IDS_GLIC_STATUS_ICON_TOOLTIP_TOGGLE_BETA 1490
#define IDS_GLIC_STATUS_ICON_MENU_SHOW 1491
#define IDS_GLIC_STATUS_ICON_MENU_CLOSE 1492
#define IDS_GLIC_STATUS_ICON_MENU_TOGGLE 1493
#define IDS_GLIC_INELIGIBLE_PROFILE_NOTICE 1494
#define IDS_SETTINGS_GLIC_PAGE_TITLE 1495
#define IDS_SETTINGS_GLIC_SECTION_TITLE 1496
#define IDS_SETTINGS_GLIC_ROW_LABEL 1497
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_GLIC 1498
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_GLIC_NO_PROFILE 1499
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_GLIC 1500
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_GLIC_NO_PROFILE 1501
#define IDS_PROFILE_PICKER_ADD_PROFILE_HELPER_GLIC 1502
#define IDS_GLIC_CONTEXTUAL_CUEING_ANNOUNCEMENT 1503
#define IDS_EXTENSION_INSTALLED_PROMO_EXPLICIT_SIGNIN_MESSAGE 1504
#define IDS_BOOKMARK_INSTALLED_PROMO_EXPLICIT_SIGNIN_MESSAGE 1505
#define IDS_DICE_MIGRATION_DIALOG_TITLE 1506
#define IDS_DICE_MIGRATION_DIALOG_DESCRIPTION 1507
#define IDS_DICE_MIGRATION_DIALOG_OK_BUTTON 1508
#define IDS_DICE_MIGRATION_CONFIRMATION_TOAST_MESSAGE 1509
#define IDS_DICE_MIGRATION_CONFIRMATION_TOAST_BUTTON 1510
#define IDS_PROFILE_MENU_ACCOUNT_SETTINGS_BUTTON 1511
#define IDS_IOS_DESKTOP_ESB_PROMO_BUBBLE_DESCRIPTION_QR 1512
#define IDS_IOS_DESKTOP_ESB_PROMO_BUBBLE_DESCRIPTION_REMINDER 1513
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_FOOTER_DESCRIPTION_REMINDER 1514
#define IDS_IOS_DESKTOP_PROMO_REMINDER_CONFIRMATION 1515
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_REMINDER_CONFIRMATION 1516
#define IDS_DEFAULT_SEARCH_ENGINE_RESET_NOTIFICATION_TITLE 1517
#define IDS_DEFAULT_SEARCH_ENGINE_RESET_NOTIFICATION_BODY 1518
#define IDS_DEFAULT_SEARCH_ENGINE_RESET_NOTIFICATION_GOT_IT_BUTTON 1519
#define IDS_DEFAULT_SEARCH_ENGINE_RESET_NOTIFICATION_LEARN_MORE_BUTTON 1520

// ---------------------------------------------------------------------------
// From cef_strings.h:

#define IDS_TEXT_FILES 56910
#define IDS_CONTENT_CONTEXT_NO_SPELLING_SUGGESTIONS 56911

// ---------------------------------------------------------------------------
// From components_branded_strings.h:

#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_BODY 34140
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_HEADER 34141
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_CLIENT 34142
#define IDS_ERRORPAGES_SUGGESTION_PROXY_DISABLE_PLATFORM 34143
#define IDS_PAYMENTS_AUTOFILL_MANDATORY_REAUTH_PROMPT 34144
#define IDS_PAYMENTS_AUTOFILL_EDIT_CARD_MANDATORY_REAUTH_PROMPT 34145
#define IDS_FLAGS_UI_RELAUNCH_NOTICE 34146
#define IDS_CRASH_DISABLED_MESSAGE 34147
#define IDS_SHORT_PRODUCT_LOGO_ALT_TEXT 34148
#define IDS_VERSION_UI_LICENSE 34149
#define IDS_PAGE_INFO_INTERNAL_PAGE 34152
#define IDS_SESSION_CRASHED_VIEW_MESSAGE 34153
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 34154
#define IDS_INTERNAL_DEBUG_PAGES_DISABLED_BODY 34155

// ---------------------------------------------------------------------------
// From components_strings.h:

#define IDS_ASH_ARC_APP_COMPAT_DISABLED_COMPAT_MODE_BUTTON_TOOLTIP_PHONE 34170
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_TITLE 34171
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_BODY 34172
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_ACCEPT 34173
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_DONT_ASK_ME 34174
#define IDS_ASH_ARC_NEARBY_SHARE_FILE_PREPARATION_PROGRESS 34175
#define IDS_ASH_ARC_NEARBY_SHARE_FILES_PREPARATION_PROGRESS 34176
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE 34177
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE_PH 34178
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_TITLE 34179
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE 34180
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE_PH 34181
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_STORAGE_BUTTON 34182
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZE_SETTINGS 34183
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TITLE 34184
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_TITLE 34185
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY 34186
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY_UNRESIZABLE 34187
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_CLOSE 34188
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_LINK 34189
#define IDS_ARC_COMPAT_MODE_DISABLE_RESIZE_LOCK_TOAST 34190
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_ICON 34191
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_THROBBER 34192
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_MESSAGE 34193
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_AOD_MESSAGE 34194
#define IDS_ARC_GHOST_WINDOW_APP_FIXUP_MESSAGE 34195
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_TITLE 34196
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY 34197
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY_WITH_LEARN_MORE 34198
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_SUBSCRIPTION_BODY_WITH_LEARN_MORE 34199
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_LEARN_MORE_LABEL 34200
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_ALLOW_BUTTON 34201
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_DONT_ALLOW_BUTTON 34202
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_TITLE 34203
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_DAYS_UNTIL_DEADLINE 34204
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_ACCEPT_BUTTON_LABEL 34205
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_TITLE 34206
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SAVE_WORK_MESSAGE 34207
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_DAYS_UNTIL_DEADLINE 34208
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_NOW_BUTTON_LABEL 34209
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SKIP_BUTTON_LABEL 34210
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_BUTTON_LABEL 34211
#define IDS_ARC_VM_DATA_MIGRATION_LOADING_SCREEN_MESSAGE 34212
#define IDS_ARC_VM_DATA_MIGRATION_WELCOME_SCREEN_TITLE 34213
#define IDS_ARC_VM_DATA_MIGRATION_WHAT_TO_EXPECT_TITLE 34214
#define IDS_ARC_VM_DATA_MIGRATION_UPDATE_DESCRIPTION 34215
#define IDS_ARC_VM_DATA_MIGRATION_BLOCKING_BEHAVIOR_DESCRIPTION 34216
#define IDS_ARC_VM_DATA_MIGRATION_CONNECT_TO_CHARGER_MESSAGE 34217
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_FREE_DISK_SPACE_MESSAGE 34218
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_BATTERY_MESSAGE 34219
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_UPDATE_BUTTON_LABEL 34220
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_SKIP_BUTTON_LABEL 34221
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_SCREEN_TITLE 34222
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_DESCRIPTION 34223
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_RESUME_BUTTON_LABEL 34224
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_SCREEN_TITLE 34225
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_DESCRIPTION 34226
#define IDS_ARC_VM_DATA_MIGRATION_SUCCESS_SCREEN_TITLE 34227
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_FINISH_BUTTON_LABEL 34228
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_SCREEN_TITLE 34229
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_DESCRIPTION 34230
#define IDS_ARC_VM_DATA_MIGRATION_SEND_FEEDBACK_MESSAGE 34231
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_REPORT_BUTTON_LABEL 34232
#define IDS_ARC_VM_PRELOAD_NOTIFICATION_TITLE 34233
#define IDS_ARC_VM_PRELOAD_STARTED_MESSAGE 34234
#define IDS_ARC_VM_PRELOAD_SUCCEEDED_MESSAGE 34235
#define IDS_ARC_VM_PRELOAD_FAILED_MESSAGE 34236
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_LOCAL_SAVE 34237
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_UPLOAD_SAVE 34238
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_SAVE_NO_THANKS 34239
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_NO_THANKS 34240
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_ACCEPT 34241
#define IDS_AUTOFILL_GOOGLE_PAY_LOGO_ACCESSIBLE_NAME 34244
#define IDS_AUTOFILL_CHROME_LOGO_ACCESSIBLE_NAME 34245
#define IDS_AUTOFILL_FIELD_LABEL_PHONE 34246
#define IDS_AUTOFILL_FIELD_LABEL_BILLING_ADDRESS 34247
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_LOCAL_SAVE_ACCEPT 34249
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_UPLOAD_SAVE_ACCEPT 34250
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CONTINUE 34252
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_LOCAL 34253
#define IDS_AUTOFILL_SAVE_CARD_ONLY_PROMPT_EXPLANATION_LOCAL 34255
#define IDS_AUTOFILL_SAVE_CARD_WITH_CVC_PROMPT_EXPLANATION_LOCAL 34256
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_LOCAL 34257
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_LOCAL 34258
#define IDS_AUTOFILL_FIX_FLOW_PROMPT_SAVE_CARD_LABEL 34259
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD 34260
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V3 34261
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V4 34262
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_SECURITY 34263
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_TO_CLOUD 34264
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARD_DESCRIPTION 34265
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARD_DESCRIPTION_WITH_NICKNAME 34266
#define IDS_AUTOFILL_CARD_SAVED 34270
#define IDS_AUTOFILL_CVC_SAVED 34271
#define IDS_AUTOFILL_DONE 34272
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION 34273
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3 34274
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_UPLOAD 34275
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_SECURITY 34276
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME 34280
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME_TOOLTIP 34281
#define IDS_AUTOFILL_SAVE_CARD_CARDHOLDER_NAME_FIX_FLOW_HEADER 34282
#define IDS_AUTOFILL_SAVE_CARD_UPDATE_EXPIRATION_DATE_TITLE 34283
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_TOOLTIP 34286
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_AND_CARDHOLDER_NAME_TOOLTIP 34287
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_LOADING_THROBBER_ACCESSIBLE_NAME 34288
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_LOADING_THROBBER_ACCESSIBLE_NAME 34289
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_TITLE 34290
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_EXPLANATION_LOCAL 34291
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_EXPLANATION_UPLOAD 34292
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_CARD_NUMBER_LABEL 34293
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_CVC_LABEL 34294
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_CVC_PLACEHOLDER 34295
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_EXPIRATION_DATE_LABEL 34296
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_EXPIRATION_DATE_PLACEHOLDER 34297
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_NAME_ON_CARD_LABEL 34298
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_ACCEPT 34299
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_INVALID_CARD_NUMBER 34300
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_INVALID_CVC 34301
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_INVALID_EXPIRATION_DATE 34302
#define IDS_AUTOFILL_SAVE_AND_FILL_DIALOG_INVALID_NAME_ON_CARD 34303
#define IDS_AUTOFILL_PENDING_DIALOG_LOADING_ACCESSIBILITY_DESCRIPTION 34304
#define IDS_AUTOFILL_MASKED_SERVER_CARD_RISK_BASED_UNMASKING_ERROR_TITLE 34305
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_TITLE 34306
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_TITLE 34307
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_DESCRIPTION 34308
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_DESCRIPTION 34309
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_TITLE 34310
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_DESCRIPTION 34311
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_TEMPORARY_ERROR_TITLE 34312
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_PERMANENT_ERROR_TITLE 34313
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_TEMPORARY_ERROR_DESCRIPTION 34314
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_PERMANENT_ERROR_DESCRIPTION 34315
#define IDS_AUTOFILL_ERROR_DIALOG_NEGATIVE_BUTTON_LABEL 34316
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC 34317
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_SECURITY_CODE 34318
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_PERMANENT 34319
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_NETWORK 34320
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_BACK_OF_CARD 34321
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_FRONT_OF_CARD 34322
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION 34323
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION_FOR_AMEX 34324
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_DEFAULT 34325
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_EXPIRED_CARD 34326
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_VIRTUAL_CARD 34327
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_TITLE 34328
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE 34332
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE_SECURITY_CODE 34333
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_EXPIRED_TITLE 34334
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRM_BUTTON 34349
#define IDS_AUTOFILL_CARD_UNMASK_VERIFY_BUTTON 34350
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_MONTH 34351
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_YEAR 34352
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_IN_PROGRESS 34353
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_SUCCESS 34354
#define IDS_AUTOFILL_CARD_UNMASK_INVALID_EXPIRATION_DATE 34355
#define IDS_AUTOFILL_EXPIRATION_DATE_SEPARATOR 34356
#define IDS_AUTOFILL_CARD_UNMASK_NEW_CARD_LINK 34357
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_CVC 34358
#define IDS_AUTOFILL_DIALOG_ACCESSIBLE_NAME_SECURITY_CODE 34359
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_BAR_MESSAGE 34360
#define IDS_AUTOFILL_MASKED_SERVER_CARD_RISK_BASED_UNMASK_PROGRESS_BAR_MESSAGE 34361
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_DIALOG_TITLE 34362
#define IDS_AUTOFILL_IBAN_UNMASK_PROGRESS_DIALOG_TITLE 34363
#define IDS_AUTOFILL_IBAN_UNMASK_PROGRESS_BAR_MESSAGE 34364
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_DIALOG_TITLE 34365
#define IDS_AUTOFILL_CARD_UNMASK_CANCEL_BUTTON_LABEL 34366
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_MESSAGE 34367
#define IDS_AUTOFILL_3DS_FETCH_VCN_PROGRESS_DIALOG_LOADING_MESSAGE 34369
#define IDS_AUTOFILL_3DS_FETCH_VCN_PROGRESS_DIALOG_CONFIRMATION_MESSAGE 34370
#define IDS_AUTOFILL_IBAN_UNMASK_ERROR_DIALOG_TITLE 34371
#define IDS_AUTOFILL_IBAN_UNMASK_ERROR_DIALOG_MESSAGE 34372
#define IDS_PAYMENTS_AUTOFILL_FILLING_MANDATORY_REAUTH 34373
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE 34382
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE_ERROR 34383
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION 34384
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_OK_BUTTON_LABEL 34385
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION_ERROR 34386
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL 34387
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL_ERROR 34388
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_TITLE 34389
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_CANCEL_BUTTON_LABEL 34390
#define IDS_AUTOFILL_WALLET_MANAGEMENT_LINK_TEXT 34391
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT_LONG 34392
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_LOCAL 34393
#define IDS_AUTOFILL_SAVE_IBAN_LABEL 34394
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_SAVE_ACCEPT 34395
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_NICKNAME 34396
#define IDS_AUTOFILL_SAVE_IBAN_PLACEHOLDER 34397
#define IDS_IBAN_NICKNAME_COUNT_BY 34398
#define IDS_AUTOFILL_IBAN_SAVED 34399
#define IDS_AUTOFILL_MANAGE_SAVED_PAYMENT_METHODS 34400
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_SERVER 34401
#define IDS_AUTOFILL_UPLOAD_IBAN_PROMPT_EXPLANATION 34402
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_TITLE 34408
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_EXPLANATION 34409
#define IDS_AUTOFILL_MANDATORY_REAUTH_ICON_TOOLTIP 465
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_TITLE 34410
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_EXPLANATION 34411
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_SETTINGS_LINK 34412
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_TITLE 34416
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EDUCATIONAL_BODY_LABEL 34417
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_LEARN_MORE_LINK_LABEL 34418
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARD_NUMBER_LABEL 34419
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_ENROLLED_CARD_UNMASK_PROGRESS_DIALOG_TITLE 34420
#define IDS_AUTOFILL_VIRTUAL_CARD_ENTRY_PREFIX 34421
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_FALLBACK_ICON_TOOLTIP 464
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_TITLE_VIRTUAL_CARD 34422
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EDUCATIONAL_BODY_LABEL_VIRTUAL_CARD 34423
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_LEARN_MORE_LINK_LABEL_VIRTUAL_CARD 34424
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARD_NUMBER_LABEL_VIRTUAL_CARD 34425
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EXP_DATE_LABEL_VIRTUAL_CARD 34426
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARDHOLDER_NAME_LABEL_VIRTUAL_CARD 34427
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CVC_LABEL_VIRTUAL_CARD 34428
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_VIRTUAL_CARD_LABEL 34429
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_ICON_TOOLTIP_VIRTUAL_CARD 34430
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_BUTTON_TOOLTIP_NORMAL_VIRTUAL_CARD 34431
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_BUTTON_TOOLTIP_CLICKED_VIRTUAL_CARD 34432
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL 34433
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_ACCEPT_BUTTON_LABEL 34434
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_TITLE_LABEL 34435
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_CONTENT_LABEL 34436
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_SKIP 34437
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_NO_THANKS 34438
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_LEARN_MORE_LINK_LABEL 34439
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_CARD_IMAGE_TOOLTIP 34440
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_OPTION_VALUE 34441
#define IDS_AUTOFILL_IBAN_SUGGESTION_OPTION_VALUE 34442
#define IDS_AUTOFILL_VIRTUAL_CARD_NUMBER_SWITCH_LABEL 34443
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_LOADING_THROBBER_ACCESSIBLE_NAME 34444
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL 34456
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL_SCREENREADER 34457
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_TITLE 34458
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARD_NUMBER_LABEL_VIRTUAL_CARD_IOS 34459
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EXP_DATE_LABEL_VIRTUAL_CARD_IOS 34460
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_NAME_ON_CARD_LABEL_VIRTUAL_CARD_IOS 34461
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CVC_LABEL_VIRTUAL_CARD_IOS 34462
#define IDS_AUTOFILL_VIRTUAL_CARD_DISABLED_SUGGESTION_OPTION_VALUE 34463
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_SUGGESTION_IPH_BUBBLE_LABEL 34464
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_SUGGESTION_IPH_BUBBLE_LABEL_SCREENREADER 34465
#define IDS_AUTOFILL_CARD_BNPL_AFFIRM_OR_ZIP_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP 34466
#define IDS_AUTOFILL_CARD_BNPL_AFFIRM_OR_ZIP_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP_SCREENREADER 34467
#define IDS_AUTOFILL_CARD_BNPL_AFFIRM_ZIP_OR_KLARNA_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP 34468
#define IDS_AUTOFILL_CARD_BNPL_AFFIRM_ZIP_OR_KLARNA_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP_SCREENREADER 34469
#define IDS_AUTOFILL_CARD_BNPL_SUGGESTION_WITH_GOOGLE_PAY_IPH_BUBBLE_LABEL_DESKTOP 34470
#define IDS_AUTOFILL_CARD_BNPL_SUGGESTION_WITH_GOOGLE_PAY_IPH_BUBBLE_LABEL_DESKTOP_SCREENREADER 34471
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_PAYMENT_OPTION_AFFIRM_AND_AFTERPAY 34472
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_PAYMENT_OPTION_ZIP 34473
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_PAYMENT_OPTION_KLARNA 34474
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_PAYMENT_OPTION_NOT_SUPPORTED_BY_MERCHANT 34475
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_PAYMENT_OPTION_CHECKOUT_AMOUNT_TOO_LOW 34476
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_PAYMENT_OPTION_CHECKOUT_AMOUNT_TOO_HIGH 34477
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_FOOTNOTE_HIDE_OPTION 34478
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_FOOTNOTE_HIDE_OPTION_PAYMENT_SETTINGS_LINK_TEXT 34479
#define IDS_AUTOFILL_CARD_BNPL_SELECT_PROVIDER_TITLE 34480
#define IDS_AUTOFILL_BNPL_SELECT_PROVIDER_TITLE_DESCRIPTION 34481
#define IDS_AUTOFILL_CARD_BNPL_LINKED_ISSUER_PILL_LABEL 34482
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_SUGGESTION_IPH_BUBBLE_FALLBACK_LABEL 34483
#define IDS_AUTOFILL_DISABLED_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP 34484
#define IDS_AUTOFILL_DISABLED_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP_SCREENREADER 34485
#define IDS_AUTOFILL_CARD_AUTH_SELECTION_DIALOG_TITLE_MULTIPLE_OPTIONS 34486
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_ISSUER_CONFIRMATION_TEXT 34487
#define IDS_AUTOFILL_AUTHENTICATION_MODE_SECURITY_CODE 34488
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_TEXT_MESSAGE 34489
#define IDS_AUTOFILL_AUTHENTICATION_MODE_TEXT_MESSAGE 34490
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_EMAIL 34491
#define IDS_AUTOFILL_AUTHENTICATION_MODE_THREE_DOMAIN_SECURE 34492
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CURRENT_INFO_NOT_SEEN_TEXT 34493
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_CONTINUE 34494
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_SEND 34495
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CVC_CHALLENGE_INFO 34496
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_THREE_DOMAIN_SECURE_CHALLENGE_INFO 34497
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TITLE 34498
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_FOOTER_MESSAGE 34499
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_NEW_CODE_MESSAGE 34500
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TEXTFIELD_PLACEHOLDER_MESSAGE 34501
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_PENDING_MESSAGE 34502
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_VERIFICATION_CODE_EXPIRED_LABEL 34503
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_ENTER_CORRECT_CODE_LABEL 34504
#define IDS_AUTOFILL_LOADING_AND_CONSENT_DIALOG_TITLE_VCN_3DS 34505
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_DESCRIPTION_VCN_3DS 34506
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_OK_BUTTON_LABEL_VCN_3DS 34507
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_ACCEPTANCE_ACCESSIBILITY_ANNOUNCEMENT 34508
#define IDS_AUTOFILL_REGULAR_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL_IOS 34509
#define IDS_AUTOFILL_BNPL_PAY_LATER_OPTIONS_TEXT 34510
#define IDS_AUTOFILL_BNPL_CREDIT_CARD_SUGGESTION_LABEL 34511
#define IDS_AUTOFILL_BNPL_CREDIT_CARD_SUGGESTION_LABEL_TWO_ISSUERS 34512
#define IDS_AUTOFILL_BNPL_CREDIT_CARD_SUGGESTION_LABEL_THREE_ISSUERS 34513
#define IDS_AUTOFILL_BNPL_SUGGESTION_LABEL_FOR_UNAVAILABLE_PURCHASE 34514
#define IDS_AUTOFILL_BNPL_SETTINGS_LABEL 34515
#define IDS_AUTOFILL_BNPL_SETTINGS_SUBLABEL 34516
#define IDS_AUTOFILL_BNPL_AFFIRM 34517
#define IDS_AUTOFILL_BNPL_ZIP 34518
#define IDS_AUTOFILL_BNPL_AFTER_PAY 34519
#define IDS_AUTOFILL_BNPL_KLARNA 34520
#define IDS_AUTOFILL_GOOGLE_PAY_AND_AFFIRM_LOGO_ACCESSIBLE_NAME 34521
#define IDS_AUTOFILL_GOOGLE_PAY_AND_ZIP_LOGO_ACCESSIBLE_NAME 34522
#define IDS_AUTOFILL_GOOGLE_PAY_AND_AFTERPAY_LOGO_ACCESSIBLE_NAME 34523
#define IDS_AUTOFILL_GOOGLE_PAY_AND_KLARNA_LOGO_ACCESSIBLE_NAME 34524
#define IDS_AUTOFILL_BNPL_FILLED_CARD_INFORMATION_BUBBLE_TITLE 34525
#define IDS_AUTOFILL_BNPL_FILLED_CARD_INFORMATION_BUBBLE_EDUCATIONAL_BODY_LABEL 34526
#define IDS_AUTOFILL_BNPL_TOS_OK_BUTTON_LABEL 34527
#define IDS_AUTOFILL_BNPL_TOS_CANCEL_BUTTON_LABEL 34529
#define IDS_AUTOFILL_BNPL_TOS_UNLINKED_TITLE 34530
#define IDS_AUTOFILL_BNPL_TOS_LINKED_TITLE 34531
#define IDS_AUTOFILL_BNPL_TOS_TITLE_DESCRIPTION 34532
#define IDS_AUTOFILL_BNPL_TOS_REVIEW_TEXT 34533
#define IDS_AUTOFILL_BNPL_TOS_APPROVE_TEXT 34534
#define IDS_AUTOFILL_BNPL_TOS_LINK_TEXT 34535
#define IDS_AUTOFILL_BNPL_FETCH_VCN_PROGRESS_DIALOG_TITLE 34536
#define IDS_AUTOFILL_BNPL_PROGRESS_DIALOG_LOADING_MESSAGE 34537
#define IDS_AUTOFILL_BNPL_FETCH_VCN_PROGRESS_DIALOG_CONFIRMATION_MESSAGE 34538
#define IDS_AUTOFILL_BNPL_ERROR_DIALOG_TITLE 34539
#define IDS_AUTOFILL_BNPL_TEMPORARY_ERROR_DESCRIPTION 34540
#define IDS_AUTOFILL_BNPL_PERMANENT_ERROR_DESCRIPTION 34541
#define IDS_AUTOFILL_BNPL_ERROR_OK_BUTTON 34542
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_TEXT_FOR_SUGGESTIONS 34544
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_IPH_BUBBLE_LABEL 34545
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_IPH_BUBBLE_LABEL_SCREENREADER 34546
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_LABEL 34547
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_TOGGLE_SUBLABEL_WITH_LEARN_LINK 34548
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_TOGGLE_SUBLABEL_WITH_ISSUER_TERMS_APPLY_TEXT_AND_LEARN_LINK 34549
#define IDS_AUTOFILL_SETTINGS_PAGE_BENEFITS_TERMS_TAG_FOR_CREDIT_CARD_LIST_ENTRY 34550
#define IDS_AUTOFILL_SETTINGS_PAGE_BENEFITS_TERMS_ARIA_LABEL 34551
#define IDS_AUTOFILL_OFFERS_CASHBACK 34558
#define IDS_AUTOFILL_CARD_LINKED_OFFER_REMINDER_TITLE 34559
#define IDS_AUTOFILL_OFFERS_REMINDER_POSITIVE_BUTTON_LABEL 34560
#define IDS_AUTOFILL_PROMO_CODE_SUGGESTIONS_FOOTER_TEXT 34561
#define IDS_AUTOFILL_OFFERS_REMINDER_ICON_TOOLTIP_TEXT 459
#define IDS_AUTOFILL_OFFERS_REMINDER_DESCRIPTION_TEXT 34562
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_REMINDER_TITLE 34565
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_TITLE 34566
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_NORMAL 34567
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_CLICKED 34568
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_VALUE_PROP_TEXT 34569
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_USE_THIS_CODE_TEXT 34570
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_CANT_FIND_CODE_MESSAGE 34571
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_OTP_INPUT_HINT 34572
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_POSITIVE_BUTTON_LABEL 34573
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_NEGATIVE_BUTTON_LABEL 34574
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_LABEL 34630
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_SUBLABEL 34631
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_LABEL 34634
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_ARIA_LABEL_FOR_NO_CVC_SAVED 34635
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_SUBLABEL 34636
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_WITH_DELETE_LINK_SUBLABEL 34637
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_TITLE 34638
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_DESCRIPTION 34639
#define IDS_AUTOFILL_SETTINGS_PAGE_CVC_TAG_FOR_CREDIT_CARD_LIST_ENTRY 34640
#define IDS_AUTOFILL_CVC_SUGGESTION_MAIN_TEXT 34643
#define IDS_AUTOFILL_SETTINGS_PAGE_CVC_SAVED_LABEL 34644
#define IDS_AUTOFILL_SETTINGS_PAGE_SUMMARY_SEPARATED_BY_PIPE 34645
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_SUCCESS_TITLE_TEXT 34648
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_TITLE_TEXT 34649
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_SUCCESS_TITLE_TEXT 34650
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_FAILURE_TITLE_TEXT 34651
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_SUCCESS_TITLE_TEXT 34652
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_TITLE_TEXT 34653
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 34654
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 34655
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 34656
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 34657
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_FAILURE_HIT_MAX_STRIKE_DESCRIPTION_TEXT 34658
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 34659
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 34660
#define IDS_AUTOFILL_SAVE_CARD_AND_VIRTUAL_CARD_ENROLL_CONFIRMATION_BUTTON_TEXT 34661
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_OK_BUTTON_ACCESSIBLE_NAME 34662
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_OK_BUTTON_ACCESSIBLE_NAME 34663
#define IDS_AUTOFILL_CLEAR_FORM_MENU_ITEM 34665
#define IDS_AUTOFILL_UNDO_MENU_ITEM 34666
#define IDS_AUTOFILL_WARNING_INSECURE_CONNECTION 34667
#define IDS_AUTOFILL_WARNING_MIXED_FORM 34668
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_CONFIRMATION_BODY 34669
#define IDS_AUTOFILL_DELETE_CREDIT_CARD_SUGGESTION_CONFIRMATION_BODY 34670
#define IDS_AUTOFILL_DELETE_PROFILE_SUGGESTION_CONFIRMATION_BODY 34671
#define IDS_AUTOFILL_REMOVE_HOME_PROFILE_SUGGESTION_CONFIRMATION_TITLE 34672
#define IDS_AUTOFILL_REMOVE_HOME_PROFILE_SUGGESTION_CONFIRMATION_BODY 34673
#define IDS_AUTOFILL_REMOVE_WORK_PROFILE_SUGGESTION_CONFIRMATION_TITLE 34674
#define IDS_AUTOFILL_REMOVE_WORK_PROFILE_SUGGESTION_CONFIRMATION_BODY 34675
#define IDS_AUTOFILL_REMOVE_ACCOUNT_NAME_AND_EMAIL_PROFILE_SUGGESTION_CONFIRMATION_TITLE 34676
#define IDS_AUTOFILL_REMOVE_ACCOUNT_NAME_AND_EMAIL_PROFILE_SUGGESTION_CONFIRMATION_BODY 34677
#define IDS_AUTOFILL_REMOVE_SUGGESTION_BUTTON 34678
#define IDS_AUTOFILL_DELETE_SUGGESTION_BUTTON 34679
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_TOOLTIP 34680
#define IDS_AUTOFILL_AUTOCOMPLETE_ENTRY_DELETED_A11Y_HINT 34681
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_A11Y_HINT 34682
#define IDS_HOME_SUGGESTION_VOICE_OVER 34683
#define IDS_WORK_SUGGESTION_VOICE_OVER 34684
#define IDS_AUTOFILL_CC_AMEX 34685
#define IDS_AUTOFILL_CC_AMEX_SHORT 34686
#define IDS_AUTOFILL_CC_DINERS 34687
#define IDS_AUTOFILL_CC_DISCOVER 34688
#define IDS_AUTOFILL_CC_ELO 34689
#define IDS_AUTOFILL_CC_GOOGLE_PAY 34690
#define IDS_AUTOFILL_CC_JCB 34691
#define IDS_AUTOFILL_CC_MASTERCARD 34692
#define IDS_AUTOFILL_CC_MIR 34693
#define IDS_AUTOFILL_CC_TROY 34694
#define IDS_AUTOFILL_CC_UNION_PAY 34695
#define IDS_AUTOFILL_CC_VERVE 34696
#define IDS_AUTOFILL_CC_VISA 34697
#define IDS_AUTOFILL_CC_GENERIC 34698
#define IDS_AUTOFILL_IBAN_GENERIC 34699
#define IDS_AUTOFILL_LOYALTY_CARD_GENERIC 34700
#define IDS_AUTOFILL_LOYALTY_CARDS_SUBMENU_TITLE 34701
#define IDS_AUTOFILL_LOYALTY_CARDS_ALL_YOUR_CARDS_SUBMENU_TITLE 34702
#define IDS_AUTOFILL_ADDRESS_SUMMARY_SEPARATOR 34703
#define IDS_AUTOFILL_DEVELOPER_TOOLS 34704
#define IDS_AUTOFILL_TEST_ADDRESS_BY_COUNTRY 34705
#define IDS_AUTOFILL_TEST_ADDRESS_SELECTED_A11Y_HINT 34706
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILLED_FORM 34707
#define IDS_AUTOFILL_A11Y_ANNOUNCE_EXPANDABLE_ONLY_ENTRY 34708
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILLED_CARD_INFORMATION_ENTRY 34709
#define IDS_AUTOFILL_A11Y_ANNOUNCE_EDIT_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 34710
#define IDS_AUTOFILL_A11Y_ANNOUNCE_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 34711
#define IDS_AUTOFILL_A11Y_ANNOUNCE_CLEARED_FORM 34712
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 34713
#define IDS_AUTOFILL_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 34714
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 34715
#define IDS_AUTOFILL_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 34716
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 34717
#define IDS_AUTOFILL_HIDE_SUGGESTIONS 34718
#define IDS_AUTOFILL_EDIT_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 34719
#define IDS_AUTOFILL_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 34720
#define IDS_AUTOFILL_HOUSE_NUMBER_SUGGESTION_SECONDARY_TEXT_OPTION_SELECTED 34721
#define IDS_AUTOFILL_STREET_NAME_SUGGESTION_SECONDARY_TEXT_OPTION_SELECTED 34722
#define IDS_AUTOFILL_HOUSE_NUMBER_SUGGESTION_SECONDARY_TEXT 34723
#define IDS_AUTOFILL_STREET_NAME_SUGGESTION_SECONDARY_TEXT 34724
#define IDS_AUTOFILL_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 34725
#define IDS_AUTOFILL_IDENTITY_CREDENTIAL_PROVIDED_MINOR_TEXT 34726
#define IDS_AUTOFILL_IDENTITY_CREDENTIAL_VERIFIED_MINOR_TEXT 34727
#define IDS_AUTOFILL_IDENTITY_CREDENTIAL_VERIFIED_EMAIL_LABEL 34728
#define IDS_AUTOFILL_IDENTITY_CREDENTIAL_LABEL_TEXT 34729
#define IDS_AUTOFILL_MANAGE_ADDRESSES 34730
#define IDS_AUTOFILL_MANAGE_PAYMENT_METHODS 34731
#define IDS_AUTOFILL_MANAGE_PASSWORDS 34732
#define IDS_AUTOFILL_MANAGE_LOYALTY_CARDS 34733
#define IDS_AUTOFILL_MANAGE_LOYALTY_CARDS_A11Y_HINT 34734
#define IDS_AUTOFILL_SCAN_CREDIT_CARD 34735
#define IDS_AUTOFILL_SHOW_ALL_SAVED_FALLBACK 34736
#define IDS_AUTOFILL_SAVE_AND_FILL_SUGGESTION_TITLE 34737
#define IDS_AUTOFILL_LOCAL_SAVE_AND_FILL_SUGGESTION_DESCRIPTION 34738
#define IDS_AUTOFILL_SERVER_SAVE_AND_FILL_SUGGESTION_DESCRIPTION 34739
#define IDS_AUTOFILL_POPUP_ACCESSIBLE_NODE_DATA 34740
#define IDS_AUTOFILL_IPH_EXTERNAL_ACCOUNT_PROFILE_SUGGESTION 34741
#define IDS_AUTOFILL_IPH_HOME_AND_WORK_ACCOUNT_PROFILE_SUGGESTION 34742
#define IDS_AUTOFILL_IPH_HOME_AND_WORK_ACCOUNT_PROFILE_SUGGESTION_SCREENREADER 34743
#define IDS_AUTOFILL_IPH_HOME_AND_WORK_ACCOUNT_PROFILE_SUGGESTION_TITLE 34744
#define IDS_AUTOFILL_IPH_ACCOUNT_NAME_EMAIL_SUGGESTION 34745
#define IDS_AUTOFILL_IPH_ACCOUNT_NAME_EMAIL_SUGGESTION_SCREENREADER 34746
#define IDS_AUTOFILL_IPH_ACCOUNT_NAME_EMAIL_SUGGESTION_TITLE 34747
#define IDS_AUTOFILL_SUGGESTION_LABEL_SEPARATOR 34748
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR 34749
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR_V2 34750
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_NAME 34751
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_CARD_NUMBER 34752
#define IDS_AUTOFILL_LOADING_REGIONS 34753
#define IDS_AUTOFILL_ADDRESSES 34754
#define IDS_AUTOFILL_ADDRESSES_TABLE_ARIA_LABEL 34755
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_SUBLABEL 34756
#define IDS_AUTOFILL_LOCAL_PROFILE_ICON_ACCESSIBILITY_LABEL 34757
#define IDS_AUTOFILL_HOME_PROFILE_ICON_ACCESSIBILITY_LABEL 34758
#define IDS_AUTOFILL_WORK_PROFILE_ICON_ACCESSIBILITY_LABEL 34759
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_SUBLABEL 34760
#define IDS_AUTOFILL_DELETE_ACCOUNT_ADDRESS_RECORD_TYPE_NOTICE 34761
#define IDS_AUTOFILL_DELETE_SYNC_ADDRESS_RECORD_TYPE_NOTICE 34762
#define IDS_AUTOFILL_DELETE_LOCAL_ADDRESS_RECORD_TYPE_NOTICE 34763
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_RECORD_TYPE_NOTICE 34764
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_MIGRATION_RECORD_TYPE_NOTICE 34765
#define IDS_AUTOFILL_ADDRESS_ALREADY_SAVED_IN_ACCOUNT_RECORD_TYPE_NOTICE 34766
#define IDS_AUTOFILL_ADDRESS_WILL_BE_SAVED_IN_ACCOUNT_RECORD_TYPE_NOTICE 34767
#define IDS_AUTOFILL_ADDRESS_HOME_RECORD_TYPE_NOTICE 34768
#define IDS_AUTOFILL_ADDRESS_WORK_RECORD_TYPE_NOTICE 34769
#define IDS_AUTOFILL_ADDRESS_HOME_AND_WORK_RECORD_TYPE_NOTICE 34770
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELD_FORM_ERROR 34771
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELDS_FORM_ERROR 34772
#define IDS_AUTOFILL_LOCAL_ADDRESS_ICON_A11Y_LABEL 34773
#define IDS_AUTOFILL_HOME_ADDRESS_ICON_A11Y_LABEL 34774
#define IDS_AUTOFILL_WORK_ADDRESS_ICON_A11Y_LABEL 34775
#define IDS_AUTOFILL_HOME_WORK_ADDRESS_EDIT_A11Y_LABEL 34776
#define IDS_AUTOFILL_SYNC_TOGGLE_LABEL 34777
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_TITLE 34778
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_SUBLABEL 34779
#define IDS_AUTOFILL_PAYMENT_METHODS 34780
#define IDS_AUTOFILL_PAYMENT_METHODS_TABLE_ARIA_LABEL 34781
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_LABEL 34782
#define IDS_AUTOFILL_DISABLE_SETTINGS_EXPLANATION_TITLE 34783
#define IDS_AUTOFILL_DISABLE_SETTINGS_EXPLANATION 34784
#define IDS_AUTOFILL_DISABLE_SETTINGS_BUTTON_LABEL 34785
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_LABEL 34786
#define IDS_AUTOFILL_DELETE_ADDRESS_CONFIRMATION_DIALOG_TITLE 34787
#define IDS_SYNC_DATATYPE_PAYMENTS 34799
#define IDS_SYNC_DATATYPE_PAYMENTS_AND_INFO 34800
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_OK_BUTTON_LABEL 34806
#define IDS_AUTOFILL_SAVE_ADDRESS_WITH_MORE_INFO_ADDRESS_PROMPT_TITLE 34807
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_MIGRATION_OK_BUTTON_LABEL 34808
#define IDS_AUTOFILL_ACCOUNT_MIGRATE_ADDRESS_PROMPT_TITLE 34809
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OK_BUTTON_LABEL 34810
#define IDS_AUTOFILL_ADD_NEW_INFO_ADDRESS_PROMPT_TITLE 34811
#define IDS_AUTOFILL_UPDATE_ADDRESS_ADD_NEW_INFO_PROMPT_OK_BUTTON_LABEL 34812
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_OK_BUTTON_LABEL 34813
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_CANCEL_BUTTON_LABEL 34814
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_NEW_VALUES_SECTION_LABEL 34815
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OLD_VALUES_SECTION_LABEL 34816
#define IDS_AUTOFILL_MIGRATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 34817
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_PROMPT_ADDRESS_SOURCE_NOTICE 34818
#define IDS_AUTOFILL_UPDATE_PROMPT_ACCOUNT_ADDRESS_SOURCE_NOTICE 34819
#define IDS_AUTOFILL_SYNCABLE_PROFILE_MIGRATION_PROMPT_NOTICE 34820
#define IDS_AUTOFILL_LOCAL_PROFILE_MIGRATION_PROMPT_NOTICE 34821
#define IDS_AUTOFILL_SAVE_PROMPT_ADDRESS_SECTION_A11Y_LABEL 34822
#define IDS_AUTOFILL_SAVE_PROMPT_PHONE_SECTION_A11Y_LABEL 34823
#define IDS_AUTOFILL_SAVE_PROMPT_EMAIL_SECTION_A11Y_LABEL 34824
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_TITLE 466
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 34846
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_EDIT_BUTTON_TOOLTIP 34828
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_TITLE 34826
#define IDS_AUTOFILL_UPDATE_ADDRESS_ADD_NEW_INFO_PROMPT_CANCEL_BUTTON_LABEL 34847
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_PROMPT_TITLE 34848
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_EDITOR_TITLE 34849
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_INTO_CHROME_PROMPT_BODY_TEXT 34850
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_INTO_ACCOUNT_PROMPT_BODY_TEXT 34851
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 34852
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_NAME_EMAIL_HOME_WORK_MERGE_PROMPT_TITLE 34853
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_NAME_EMAIL_HOME_WORK_MERGE_OK_BUTTON_LABEL 34854
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_NAME_EMAIL_HOME_WORK_MERGE_CANCEL_BUTTON_LABEL 34855
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_TITLE 34829
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 34856
#define IDS_AUTOFILL_MIGRATE_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 34857
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_UPDATE 34858
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_DIALOG_OK_BUTTON_LABEL 34859
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_CANCEL_BUTTON_LABEL 34860
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_FILL_ADDRESS_A11Y_ADDON 34861
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_EXPAND_SHORTCUT 34862
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_EXPAND_SHORTCUT_RTL 34863
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_SUBMENU_HINT 34864
#define IDS_AUTOFILL_SIGNIN_PROMO_TITLE_PASSWORD 34865
#define IDS_AUTOFILL_VERIFY_PROMO_SUBTITLE_PASSWORD 34866
#define IDS_AUTOFILL_POPUP_SEARCH_BAR_CLEAR_SEARCH_BUTTON_A11Y_NAME 34867
#define IDS_AUTOFILL_POPUP_SEARCH_BAR_PASSWORDS_INPUT_PLACEHOLDER 34868
#define IDS_AUTOFILL_POPUP_SEARCH_BAR_PASSWORDS_NOT_FOUND 34869
#define IDS_AUTOFILL_SIGNIN_PROMO_TITLE_ADDRESS 34870
#define IDS_AUTOFILL_VERIFY_PROMO_SUBTITLE_ADDRESS 34871
#define IDS_AUTOFILL_IPH_LOYALTY_CARD_SUGGESTION_TITLE 34872
#define IDS_AUTOFILL_IPH_LOYALTY_CARD_SUGGESTION_BODY 34873
#define IDS_AUTOFILL_IPH_LOYALTY_CARD_SUGGESTION_SCREENREADER 34874
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_RECOVERY_SHOWN_A11Y_ANNOUNCEMENT 34875
#define IDS_AUTOFILL_CONTACT_INFO_TITLE 34876
#define IDS_AUTOFILL_PAYMENTS_TITLE 34877
#define IDS_AUTOFILL_IDENTITY_DOCS_TITLE 34878
#define IDS_AUTOFILL_TRAVEL_TITLE 34879
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_HISPANIC_MUNICIPIO 34880
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_FRENCH_LOCALITY_2 34881
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_JAPANESE_ALTERNATIVE_NAME 34882
#define IDS_AUTOFILL_AI_DRIVERS_LICENSE_ENTITY_NAME 34884
#define IDS_AUTOFILL_AI_NATIONAL_ID_CARD_ENTITY_NAME 34885
#define IDS_AUTOFILL_AI_PASSPORT_ENTITY_NAME 34886
#define IDS_AUTOFILL_AI_VEHICLE_ENTITY_NAME 34887
#define IDS_AUTOFILL_AI_KNOWN_TRAVELER_NUMBER_ENTITY_NAME 34888
#define IDS_AUTOFILL_AI_REDRESS_NUMBER_ENTITY_NAME 34889
#define IDS_AUTOFILL_AI_FLIGHT_RESERVATION_ENTITY_NAME 34890
#define IDS_AUTOFILL_AI_VEHICLES_TITLE 34891
#define IDS_AUTOFILL_AI_TRAVEL_INFO_TITLE 34892
#define IDS_AUTOFILL_AI_FLIGHT_RESERVATIONS_TITLE 34893
#define IDS_AUTOFILL_AI_ADD_DRIVERS_LICENSE_ENTITY 34894
#define IDS_AUTOFILL_AI_ADD_NATIONAL_ID_CARD_ENTITY 34895
#define IDS_AUTOFILL_AI_ADD_PASSPORT_ENTITY 34896
#define IDS_AUTOFILL_AI_ADD_VEHICLE_ENTITY 34897
#define IDS_AUTOFILL_AI_ADD_KNOWN_TRAVELER_NUMBER_ENTITY 34898
#define IDS_AUTOFILL_AI_ADD_REDRESS_NUMBER_ENTITY 34899
#define IDS_AUTOFILL_AI_EDIT_DRIVERS_LICENSE_ENTITY 34900
#define IDS_AUTOFILL_AI_EDIT_NATIONAL_ID_CARD_ENTITY 34901
#define IDS_AUTOFILL_AI_EDIT_PASSPORT_ENTITY 34902
#define IDS_AUTOFILL_AI_EDIT_VEHICLE_ENTITY 34903
#define IDS_AUTOFILL_AI_EDIT_KNOWN_TRAVELER_NUMBER_ENTITY 34904
#define IDS_AUTOFILL_AI_EDIT_REDRESS_NUMBER_ENTITY 34905
#define IDS_AUTOFILL_AI_DELETE_DRIVERS_LICENSE_ENTITY 34906
#define IDS_AUTOFILL_AI_DELETE_NATIONAL_ID_CARD_ENTITY 34907
#define IDS_AUTOFILL_AI_DELETE_PASSPORT_ENTITY 34908
#define IDS_AUTOFILL_AI_DELETE_VEHICLE_ENTITY 34909
#define IDS_AUTOFILL_AI_DELETE_KNOWN_TRAVELER_NUMBER_ENTITY 34910
#define IDS_AUTOFILL_AI_DELETE_REDRESS_NUMBER_ENTITY 34911
#define IDS_AUTOFILL_AI_DRIVERS_LICENSE_NAME_ATTRIBUTE_NAME 34912
#define IDS_AUTOFILL_AI_DRIVERS_LICENSE_STATE_ATTRIBUTE_NAME 34913
#define IDS_AUTOFILL_AI_DRIVERS_LICENSE_NUMBER_ATTRIBUTE_NAME 34914
#define IDS_AUTOFILL_AI_DRIVERS_LICENSE_EXPIRATION_DATE_ATTRIBUTE_NAME 34915
#define IDS_AUTOFILL_AI_DRIVERS_LICENSE_ISSUE_DATE_ATTRIBUTE_NAME 34916
#define IDS_AUTOFILL_AI_NATIONAL_ID_CARD_NAME_ATTRIBUTE_NAME 34917
#define IDS_AUTOFILL_AI_NATIONAL_ID_CARD_NUMBER_ATTRIBUTE_NAME 34918
#define IDS_AUTOFILL_AI_NATIONAL_ID_CARD_COUNTRY_ATTRIBUTE_NAME 34919
#define IDS_AUTOFILL_AI_NATIONAL_ID_CARD_EXPIRATION_DATE_ATTRIBUTE_NAME 34920
#define IDS_AUTOFILL_AI_NATIONAL_ID_CARD_ISSUE_DATE_ATTRIBUTE_NAME 34921
#define IDS_AUTOFILL_AI_KNOWN_TRAVELER_NUMBER_NAME_ATTRIBUTE_NAME 34922
#define IDS_AUTOFILL_AI_KNOWN_TRAVELER_NUMBER_ATTRIBUTE_NAME 34923
#define IDS_AUTOFILL_AI_KNOWN_TRAVELER_NUMBER_EXPIRATION_DATE_ATTRIBUTE_NAME 34924
#define IDS_AUTOFILL_AI_REDRESS_NUMBER_NAME_ATTRIBUTE_NAME 34925
#define IDS_AUTOFILL_AI_REDRESS_NUMBER_ATTRIBUTE_NAME 34926
#define IDS_AUTOFILL_AI_PASSPORT_NAME_ATTRIBUTE_NAME 34927
#define IDS_AUTOFILL_AI_PASSPORT_NUMBER_ATTRIBUTE_NAME 34928
#define IDS_AUTOFILL_AI_PASSPORT_COUNTRY_ATTRIBUTE_NAME 34929
#define IDS_AUTOFILL_AI_PASSPORT_EXPIRATION_DATE_ATTRIBUTE_NAME 34930
#define IDS_AUTOFILL_AI_PASSPORT_ISSUE_DATE_ATTRIBUTE_NAME 34931
#define IDS_AUTOFILL_AI_VEHICLE_MAKE_ATTRIBUTE_NAME 34932
#define IDS_AUTOFILL_AI_VEHICLE_MODEL_ATTRIBUTE_NAME 34933
#define IDS_AUTOFILL_AI_VEHICLE_YEAR_ATTRIBUTE_NAME 34934
#define IDS_AUTOFILL_AI_VEHICLE_OWNER_ATTRIBUTE_NAME 34935
#define IDS_AUTOFILL_AI_VEHICLE_PLATE_NUMBER_ATTRIBUTE_NAME 34936
#define IDS_AUTOFILL_AI_VEHICLE_PLATE_STATE_ATTRIBUTE_NAME 34937
#define IDS_AUTOFILL_AI_VEHICLE_VEHICLE_IDENTIFICATION_NUMBER_ATTRIBUTE_NAME 34938
#define IDS_AUTOFILL_AI_MANAGE_SUGGESTION_MAIN_TEXT 34939
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_NO_THANKS_BUTTON 34940
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_SAVE_BUTTON 34941
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_UPDATE_DIALOG_UPDATE_BUTTON 34942
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_FOOTER_DETAILS 34943
#define IDS_AUTOFILL_AI_OPT_IN_IPH_TITLE 34944
#define IDS_AUTOFILL_AI_OPT_IN_IPH_BODY 34945
#define IDS_AUTOFILL_AI_OPT_IN_IPH_TURN_ON 34946
#define IDS_AUTOFILL_AI_OPT_IN_IPH_MAYBE_LATER 34947
#define IDS_AUTOFILL_AI_VALUABLES_IPH_TITLE 34948
#define IDS_AUTOFILL_AI_VALUABLES_IPH_BODY 34949
#define IDS_AUTOFILL_AI_VALUABLES_IPH_SCREENREADER 34950
#define IDS_AUTOFILL_AI_SAVE_DRIVERS_LICENSE_ENTITY_DIALOG_TITLE 34951
#define IDS_AUTOFILL_AI_SAVE_NATIONAL_ID_CARD_ENTITY_DIALOG_TITLE 34952
#define IDS_AUTOFILL_AI_SAVE_PASSPORT_ENTITY_DIALOG_TITLE 34953
#define IDS_AUTOFILL_AI_SAVE_VEHICLE_ENTITY_DIALOG_TITLE 34954
#define IDS_AUTOFILL_AI_SAVE_KNOWN_TRAVELER_NUMBER_ENTITY_DIALOG_TITLE 34955
#define IDS_AUTOFILL_AI_SAVE_REDRESS_NUMBER_ENTITY_DIALOG_TITLE 34956
#define IDS_AUTOFILL_AI_UPDATE_DRIVERS_LICENSE_ENTITY_DIALOG_TITLE 34957
#define IDS_AUTOFILL_AI_UPDATE_NATIONAL_ID_CARD_ENTITY_DIALOG_TITLE 34958
#define IDS_AUTOFILL_AI_UPDATE_PASSPORT_ENTITY_DIALOG_TITLE 34959
#define IDS_AUTOFILL_AI_UPDATE_VEHICLE_ENTITY_DIALOG_TITLE 34960
#define IDS_AUTOFILL_AI_UPDATE_KNOWN_TRAVELER_NUMBER_ENTITY_DIALOG_TITLE 34961
#define IDS_AUTOFILL_AI_UPDATE_REDRESS_NUMBER_ENTITY_DIALOG_TITLE 34962
#define IDS_AUTOFILL_GOOGLE_WALLET_TITLE 34963
#define IDS_AUTOFILL_AI_UPDATE_ENTITY_DIALOG_SUBTITLE 34964
#define IDS_AUTOFILL_AI_UPDATE_ENTITY_TO_WALLET_DIALOG_SUBTITLE 34965
#define IDS_AUTOFILL_AI_SAVE_ENTITY_DIALOG_SUBTITLE 34966
#define IDS_AUTOFILL_AI_SAVE_ENTITY_TO_WALLET_DIALOG_SUBTITLE 34967
#define IDS_AUTOFILL_AI_UPDATE_ENTITY_DIALOG_UPDATED_ATTRIBUTE_ACCESSIBLE_NAME 34968
#define IDS_AUTOFILL_AI_UPDATE_ENTITY_DIALOG_NEW_ATTRIBUTE_ACCESSIBLE_NAME 34969
#define IDS_AUTOFILL_AI_FFR_WHEN_ON_TITLE 34970
#define IDS_AUTOFILL_AI_FFR_WHEN_ON_DESCRIPTION 34971
#define IDS_AUTOFILL_AI_FFR_CONSIDER_DESCRIPTION 34972
#define IDS_AUTOFILL_AI_FFR_CONSIDER_LEARN_MORE 34973
#define IDS_BOOKMARK_BAR_FOLDER_NAME 147
#define IDS_BOOKMARK_BAR_MOBILE_FOLDER_NAME 149
#define IDS_BOOKMARK_BAR_OTHER_FOLDER_NAME 148
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DOMAIN_NAME 34976
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DEFAULT_NAME 150
#define IDS_BOOKMARK_EDITOR_TITLE 34977
#define IDS_BOOKMARK_MOVE_DIALOG_TITLE 34978
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_NAME 34979
#define IDS_BOOKMARK_BUBBLE_REMOVE_BOOKMARK 34980
#define IDS_BOOKMARK_MANAGER_NAME_INPUT_PLACE_HOLDER 34981
#define IDS_BOOKMARK_MANAGER_URL_INPUT_PLACE_HOLDER 34982
#define IDS_TOOLTIP_STAR 469
#define IDS_CLEAR_BROWSING_DATA_CALCULATING 34983
#define IDS_DEL_BROWSING_HISTORY_COUNTER 34984
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SYNCED 34985
#define IDS_DEL_NO_BROWSING_HISTORY_TEXT 34986
#define IDS_DEL_NO_BROWSING_HISTORY_SYNC_TEXT 34987
#define IDS_DEL_BROWSING_HISTORY_DOMAIN_COUNT_TEXT 34988
#define IDS_DEL_BROWSING_HISTORY_DOMAIN_COUNT_SYNC_TEXT 34989
#define IDS_DEL_BROWSING_HISTORY_COUNTER_MULTIPLE_DOMAINS_TEXT 34990
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SINGLE_DOMAIN_TEXT 34991
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SINGLE_DOMAIN_SYNC_TEXT 34992
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE 34993
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY 34994
#define IDS_DEL_CACHE_COUNTER_BASIC 34995
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE_BASIC 34996
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY_BASIC 34997
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED 34998
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED_UPPER_ESTIMATE 34999
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED_ALMOST_EMPTY 35000
#define IDS_DEL_PASSWORDS_COUNTER 35001
#define IDS_DEL_PASSWORDS_COUNTER_SYNCED 35002
#define IDS_DEL_ACCOUNT_PASSWORDS_COUNTER 35003
#define IDS_DEL_PASSWORDS_DOMAINS_DISPLAY 35004
#define IDS_DEL_PASSWORDS_COUNTER_AND_X_MORE 35005
#define IDS_DEL_SIGNIN_DATA_COUNTER 35006
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_NONE 35007
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_COMBINATION 35008
#define IDS_DEL_SITE_SETTINGS_COUNTER 35009
#define IDS_DEL_AUTOFILL_COUNTER_EMPTY 35010
#define IDS_DEL_AUTOFILL_COUNTER_PAYMENT_METHODS 35011
#define IDS_DEL_AUTOFILL_COUNTER_ADDRESSES 35012
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS 35013
#define IDS_DEL_AUTOFILL_COUNTER_USER_ANNOTATION_ENTRIES 35014
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_LONG 35015
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_SHORT 35016
#define IDS_DEL_AUTOFILL_COUNTER_ONE_TYPE_SYNCED 35017
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES 35018
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES_SYNCED 35019
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES 35020
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES_SYNCED 35021
#define IDS_DEL_AUTOFILL_SYNCABLE_NON_SYNCABLE_COMBINATION 35022
#define IDS_DEL_COOKIES_COUNTER 35023
#define IDS_DEL_COOKIES_COUNTER_ADVANCED 35024
#define IDS_DEL_COOKIES_COUNTER_ADVANCED_WITH_SIGNED_IN_EXCEPTION 35025
#define IDS_ANDROID_DEL_COOKIES_COUNTER_ADVANCED 35026
#define IDS_DEL_DOWNLOADS_COUNTER 35027
#define IDS_DEL_HOSTED_APPS_COUNTER 35028
#define IDS_DEL_HOSTED_APPS_COUNTER_AND_X_MORE 35029
#define IDS_DEL_TABS_COUNTER 35030
#define IDS_TABS_COUNT 35031
#define IDS_WINDOWS_COUNT 35032
#define IDS_DEL_TABS_MULTIWINDOW_COUNTER 35033
#define IDS_DEL_GOOGLE_COOKIES_SIGNOUT_LINK 35034
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_TITLE 35035
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_CONTENT 35036
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_NO_THANKS 35037
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_GET_DISCOUNTS 35038
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_TITLE 35039
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_CONTENT 35040
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_DONE 35041
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_ACCEPT_BUTTON 35042
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_TITLE 35043
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_BODY 35044
#define IDS_NTP_CART_DISCOUNT_STEP_ONE_CONTENT 662
#define IDS_OMNIBOX_TRACK_PRICE 444
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE 35045
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION 35046
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_EMAIL_DESCRIPTION 35047
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ACTION_BUTTON 35048
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_DESCRIPTION 35049
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_BUTTON 35050
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE_FIRST_RUN 35051
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION_FIRST_RUN 35052
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_CANCEL_BUTTON 35053
#define IDS_PRICE_TRACKING_SAVE_DESCRIPTION 35054
#define IDS_PRICE_TRACKING_SAVE_LOCATION 35055
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_BODY 35056
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_TITLE 35057
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_LEARN_MORE_LINK_TEXT 35058
#define IDS_PRICE_TRACKING_NOT_NOW 35059
#define IDS_PRICE_TRACKING_YES_IM_IN 35060
#define IDS_OMNIBOX_TRACKING_PRICE 35061
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_TITLE 35062
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_ACTION_BUTTON 35063
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_UNTRACK_BUTTON 35064
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_TITLE 35065
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION 35066
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION_BOOKMARK_REMOVED 35067
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_ACTION_BUTTON 35068
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION 35069
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION_EMAIL_OFF 35070
#define IDS_BOOKMARKS_MANAGER_TRACKED_PRODUCTS 35071
#define IDS_BOOKMARKS_MANAGER_UNTRACK_BUTTON 35072
#define IDS_PRICE_TRACKING_SIDE_PANEL_IPH 35073
#define IDS_SIDE_PANEL_TRACKED_PRODUCTS 35074
#define IDS_PRICE_TRACKING_CHIP_IPH 35075
#define IDS_SIDE_PANEL_UNTRACK_BUTTON 35076
#define IDS_SIDE_PANEL_TRACK_BUTTON 35077
#define IDS_BOOKMARKS_MENU_UNTRACK_PRICE 35078
#define IDS_BOOKMARKS_MENU_TRACK_PRICE 35079
#define IDS_PRICE_TRACKING_UNTRACK_PRODUCT_ACCESSIBILITY 35080
#define IDS_PRICE_TRACKING_TRACK_PRODUCT_ACCESSIBILITY 35081
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_BUTTON 35082
#define IDS_PRICE_TRACKING_SETTINGS_TITLE 35083
#define IDS_PRICE_TRACKING_SETTINGS_EMAIL_DESCRIPTION 35084
#define IDS_PRICE_TRACKING_SETTINGS_POPUP_DESCRIPTION 35085
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_MESSAGE 35086
#define IDS_SHOPPING_COLLECTION_IPH_TITLE 35087
#define IDS_SHOPPING_COLLECTION_IPH_BODY 35088
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TITLE 35089
#define IDS_PRICE_HISTORY_TITLE 35090
#define IDS_PRICE_HISTORY_TITLE_MULTIPLE_OPTIONS 35091
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_LOW_PRICE 35092
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_HIGH_PRICE 35093
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_TYPICAL_PRICE 35094
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_TITLE 35095
#define IDS_SHOPPING_INSIGHTS_ICON_TOOLTIP_TEXT 35096
#define IDS_SHOPPING_INSIGHTS_BUYING_OPTIONS 35097
#define IDS_PRICE_HISTORY_TODAY_PRICE 35098
#define IDS_PRICE_HISTORY_YESTERDAY_PRICE 35099
#define IDS_PRICE_HISTORY_DESCRIPTION 35100
#define IDS_PRICE_HISTORY_GRAPH_ACCESSIBILITY 35101
#define IDS_SHOPPING_INSIGHTS_COLLECT_FEEDBACK 35102
#define IDS_SHOPPING_INSIGHTS_FEEDBACK_FORM_TITLE 35103
#define IDS_PRICE_HISTORY_SINGLE_OPTION_LOW_PRICE 35104
#define IDS_PRICE_HISTORY_SINGLE_OPTION_HIGH_PRICE 35105
#define IDS_PRICE_HISTORY_SINGLE_OPTION_TYPICAL_PRICE 35106
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_DESCRIPTION 35107
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_ERROR 35108
#define IDS_DISCOUNT_USE_THIS_CODE_AT_CHECKOUT_WITH_EXPIRATION_DATE 35109
#define IDS_DISCOUNT_USE_THIS_CODE_AT_CHECKOUT 35110
#define IDS_DISCOUNT_EXPIRATION_DATE 35111
#define IDS_TWO_STRINGS_CONNECTOR 35112
#define IDS_TWO_STRINGS_CONNECTOR_WITH_SPACE 35113
#define IDS_SELLER_TERMS_AND_CONDITIONS_DIALOG_TITLE 35114
#define IDS_SELLER_TERMS_AND_CONDITIONS_DIALOG_FOOTER 35115
#define IDS_SEE_SELLER_TERMS_AND_CONDITIONS 35116
#define IDS_DISCOUNTS_COUPON_CODE_BUTTON_TOOLTIP 35117
#define IDS_DISCOUNTS_COUPON_CODE_BUTTON_TOOLTIP_CLICKED 35118
#define IDS_PRICE_DROP_POPUP_CONTENT_TITLE 35131
#define IDS_PRICE_DROP_POPUP_CONTENT_TEXT 35132
#define IDS_PRICE_DROP_POPUP_ACTION_BUTTON 35133
#define IDS_PRICE_DROP_POPUP_UNTRACK_BUTTON 35134
#define IDS_PRICE_RANGE_ALL_OPTIONS 35135
#define IDS_PRICE_RANGE_ALL_OPTIONS_ONE_TYPICAL_PRICE 35136
#define IDS_PRICE_RANGE_SINGLE_OPTION 35137
#define IDS_PRICE_RANGE_SINGLE_OPTION_ONE_TYPICAL_PRICE 35138
#define IDS_PRICE_TRACKING_DESCRIPTION 35139
#define IDS_PRICE_INSIGHTS_BUYING_OPTIONS_TITLE 35140
#define IDS_PRICE_INSIGHTS_BUYING_OPTIONS_SUBTITLE 35141
#define IDS_PRICE_INSIGHTS_TRACK_BUTTON_TITLE 35142
#define IDS_PRICE_INSIGHTS_TRACKING_BUTTON_TITLE 35143
#define IDS_INSIGHTS_ICON_EXPANDED_TEXT_GOOD_DEAL 35144
#define IDS_INSIGHTS_RICH_IPH_TEXT 35145
#define IDS_PRICE_INSIGHTS_ACCESSIBILITY 35146
#define IDS_PRICE_INSIGHTS_GRAPH_ACCESSIBILITY_LABEL 35147
#define IDS_PRICE_INSIGHTS_SNACKBAR_BUTTON_TITLE 35148
#define IDS_PRICE_INSIGHTS_SNACKBAR_MESSAGE_TITLE_NOTIFICATION_DISABLED 35149
#define IDS_PRICE_INSIGHTS_SNACKBAR_MESSAGE_TITLE_NOTIFICATION_ENABLED 35150
#define IDS_PRICE_RANGE_ACCESSIBILITY_DESCRIPTION 35151
#define IDS_BUYING_OPTIONS_ACCESSIBILITY_DESCRIPTION 35152
#define IDS_PRICE_TRACKING_DESCRIPTION_TRACKED 35153
#define IDS_PRICE_HISTORY_TITLE_WITH_VARIANTS 35154
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_TITLE 35155
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_MESSAGE 35156
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_CLOSE 35157
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_REDIRECT 35158
#define IDS_PRICE_INSIGHTS_UNTRACK_SNACKBAR_MESSAGE 35159
#define IDS_PRICE_INSIGHTS_UNTRACK_SNACKBAR_BUTTON_TITLE 35160
#define IDS_PRICE_HISTORY_TITLE_SINGLE_OPTION 35161
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_LOW_PRICE 35162
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_HIGH_PRICE 35163
#define IDS_SHOPPING_COLLECTION_FOLDER_NAME 35164
#define IDS_DISCOUNT_CODE_COPY_BUTTON_TEXT 35165
#define IDS_DISCOUNT_ICON_EXPANDED_TEXT 35166
#define IDS_COMPARE_ADD_NEW_COLUMN 35175
#define IDS_COMPARE_ADDED_TO_TABLE_TOAST_ACTION_BUTTON 35176
#define IDS_COMPARE_CITATION_A11Y_LABEL 35177
#define IDS_COMPARE_DEFAULT_PAGE_TITLE 35178
#define IDS_COMPARE_DEFAULT_TABLE_TITLE 35179
#define IDS_COMPARE_DELETE 35180
#define IDS_COMPARE_DISCLAIMER 35181
#define IDS_COMPARE_EMPTY_PRODUCT_SELECTOR 35182
#define IDS_COMPARE_EMPTY_SELECTION_MENU 35183
#define IDS_COMPARE_EMPTY_STATE_TITLE 35184
#define IDS_COMPARE_EMPTY_STATE_TITLE_DESCRIPTION 35185
#define IDS_COMPARE_ENTRY_POINT_DEFAULT 35186
#define IDS_COMPARE_ENTRY_POINT 35187
#define IDS_COMPARE_FEEDBACK_PLACEHOLDER 35188
#define IDS_COMPARE_LEARN_MORE 35189
#define IDS_COMPARE_LEARN_MORE_A11Y_LABEL 35190
#define IDS_COMPARE_OFFLINE_TOAST_MESSAGE 35191
#define IDS_COMPARE_OPEN_PRODUCT_PAGE_IN_NEW_TAB 35192
#define IDS_COMPARE_PAGE_ACTION_ADD_DEFAULT 35193
#define IDS_COMPARE_PAGE_ACTION_ADDED_DEFAULT 35194
#define IDS_COMPARE_PAGE_ACTION_ADD 35195
#define IDS_COMPARE_PAGE_ACTION_ADDED 35196
#define IDS_COMPARE_PRICE_ROW_TITLE 35197
#define IDS_COMPARE_PRODUCT_SUMMARY_ROW_TITLE 35198
#define IDS_COMPARE_RECENTLY_VIEWED_TABS_SECTION 35199
#define IDS_COMPARE_REMOVE_COLUMN 35200
#define IDS_COMPARE_RENAME 35201
#define IDS_COMPARE_SEE_ALL 35202
#define IDS_COMPARE_SUGGESTIONS_SECTION 35203
#define IDS_COMPARE_TABLE_FULL_MESSAGE 35204
#define IDS_COMPARE_TABLE_MENU_A11Y_LABEL 35205
#define IDS_COMPARE_TITLE_INPUT_A11Y_LABEL 35206
#define IDS_TOOLTIP_COMPARE_ENTRY_POINT_CLOSE 35207
#define IDS_COMPARE_SYNC_PROMO_MESSAGE 35208
#define IDS_COMPARE_SYNC_PROMO_DESCRIPTION 35209
#define IDS_COMPARE_SYNC_PROMO_BUTTON 35210
#define IDS_COMPARE_ERROR_TITLE 35211
#define IDS_COMPARE_ERROR_DESCRIPTION 35212
#define IDS_COMPARE_TABLE_LIST_ITEM_TITLE 35213
#define IDS_COMPARE_NUM_ITEMS 35214
#define IDS_COMPARE_YOUR_COMPARISON_TABLES 35215
#define IDS_COMPARE_CONTEXT_MENU_OPEN_IN_NEW_TAB 35216
#define IDS_COMPARE_CONTEXT_MENU_OPEN_IN_NEW_WINDOW 35217
#define IDS_COMPARE_CONTEXT_MENU_OPEN_ALL_WITH_COUNT 35218
#define IDS_COMPARE_CONTEXT_MENU_OPEN_ALL_IN_NEW_WINDOW_WITH_COUNT 35219
#define IDS_COMPARE_CONTEXT_MENU_RENAME 35220
#define IDS_COMPARE_CONTEXT_MENU_DELETE 35221
#define IDS_COMPARE_NUM_ITEMS_SELECTED 35222
#define IDS_COMPARE_EDIT_MORE 35223
#define IDS_COMPARE_TABLE_DELETION_TOAST_MESSAGE 35224
#define IDS_COMPARE_UNDO_TABLE_DELETION 35225
#define IDS_COMPARE_DESCRIPTION_NOT_AVAILABLE 35226
#define IDS_COMPARE_DISCLOSURE_TITLE 35227
#define IDS_COMPARE_DISCLOSURE_ITEMS_HEADER 35228
#define IDS_COMPARE_DISCLOSURE_ABOUT_AI_ITEM 35229
#define IDS_COMPARE_DISCLOSURE_TAB_ITEM 35230
#define IDS_COMPARE_DISCLOSURE_ACCOUNT_ITEM 35231
#define IDS_COMPARE_DISCLOSURE_DATA_ITEM 35232
#define IDS_COMPARE_DISCLOSURE_ACCEPT 35233
#define IDS_COMPARE_DISCLOSURE_DECLINE 35234
#define IDS_COMPARE_MENU_LABEL 35235
#define IDS_COMPARE_SHOW_ALL_COMPARISON_TABLES 35236
#define IDS_COMPARE_ADD_TAB_TO_COMPARISON_TABLE 35237
#define IDS_COMPARE_NEW_COMPARISON_TABLE 35238
#define IDS_SETTINGS_TITLE 35239
#define IDS_SETTINGS_HIDE_ADVANCED_SETTINGS 35240
#define IDS_SETTINGS_SHOW_ADVANCED_SETTINGS 35241
#define IDS_NETWORK_PREDICTION_ENABLED_DESCRIPTION 35242
#define IDS_SYSTEM_TITLE 35243
#define IDS_OPTIONS_PROXIES_CONFIGURE_BUTTON 35244
#define IDS_COMPOSE_SUGGESTION_MAIN_TEXT 35245
#define IDS_COMPOSE_CONTEXT_MENU_TEXT 35246
#define IDS_COMPOSE_SUGGESTION_LABEL 35247
#define IDS_COMPOSE_SUGGESTION_SAVED_TEXT 35248
#define IDS_COMPOSE_SUGGESTION_SAVED_LABEL 35249
#define IDS_COMPOSE_SUGGESTION_AX_MESSAGE_ON_SHOW_PROACTIVE 35250
#define IDS_COMPOSE_SUGGESTION_AX_MESSAGE_ON_SHOW_RESUME 35251
#define IDS_COMPOSE_DONT_SHOW_ON_THIS_SITE_CHILD_SUGGESTION_TEXT 35252
#define IDS_COMPOSE_DISABLE_HELP_ME_WRITE_CHILD_SUGGESTION_TEXT 35253
#define IDS_COMPOSE_GO_TO_SETTINGS_CHILD_SUGGESTION_TEXT 35254
#define IDS_COMPOSE_FRE_TITLE 35255
#define IDS_COMPOSE_FRE_MAIN_TOP 35256
#define IDS_COMPOSE_FRE_MAIN_MID 35257
#define IDS_COMPOSE_FRE_MAIN_MID_ENTERPRISE 35258
#define IDS_COMPOSE_FRE_OK_BUTTON 35259
#define IDS_COMPOSE_FRE_MSBB_TITLE 35260
#define IDS_COMPOSE_FRE_MSBB_MAIN 35261
#define IDS_COMPOSE_FRE_MSBB_SETTINGS_BUTTON 35262
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_TEXT 35263
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_TEXT_SCREENREADER 35264
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_CLOSE_BUTTON_LABEL_TEXT 35265
#define IDS_COMPOSE_DIALOG_TITLE 35266
#define IDS_COMPOSE_INPUT_PLACEHOLDER_TITLE 35267
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_1 35268
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_2 35269
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_3 35270
#define IDS_COMPOSE_INPUT_FOOTER 35271
#define IDS_COMPOSE_INPUT_FOOTER_ENTERPRISE 35272
#define IDS_COMPOSE_INPUT_MODE_POLISH 35273
#define IDS_COMPOSE_INPUT_MODE_ELABORATE 35274
#define IDS_COMPOSE_INPUT_MODE_FORMALIZE 35275
#define IDS_COMPOSE_SUBMIT_BUTTON 35276
#define IDS_COMPOSE_EDIT_UPDATE_BUTTON 35277
#define IDS_COMPOSE_EDIT 35278
#define IDS_COMPOSE_MODIFIERS_MENU_TITLE 35279
#define IDS_COMPOSE_MODIFIERS_MENU_LABEL 35280
#define IDS_COMPOSE_MENU_RETRY_OPTION 35281
#define IDS_COMPOSE_MENU_LENGTH_TITLE 35282
#define IDS_COMPOSE_MENU_SHORTER_OPTION 35283
#define IDS_COMPOSE_MENU_LONGER_OPTION 35284
#define IDS_COMPOSE_MENU_TONE_TITLE 35285
#define IDS_COMPOSE_MENU_CASUAL_OPTION 35286
#define IDS_COMPOSE_MENU_FORMAL_OPTION 35287
#define IDS_COMPOSE_UNDO_BUTTON_TEXT 35288
#define IDS_COMPOSE_UNDO_LABEL 35289
#define IDS_COMPOSE_REDO_BUTTON_TEXT 35290
#define IDS_COMPOSE_REDO_LABEL 35291
#define IDS_COMPOSE_RESUBMIT 35292
#define IDS_COMPOSE_INSERT_BUTTON 35293
#define IDS_COMPOSE_REPLACE_BUTTON 35294
#define IDS_COMPOSE_THUMBS_DOWN 35295
#define IDS_COMPOSE_THUMBS_UP 35296
#define IDS_COMPOSE_RESULT_TEXT_LABEL 35297
#define IDS_COMPOSE_RESULT_LOADING_A11Y_MESSAGE 35298
#define IDS_COMPOSE_RESULT_UPDATED_A11Y_MESSAGE 35299
#define IDS_COMPOSE_UNDO_RESULT_A11Y_MESSAGE 35300
#define IDS_COMPOSE_REDO_RESULT_A11Y_MESSAGE 35301
#define IDS_COMPOSE_ERROR_TOO_SHORT 35302
#define IDS_COMPOSE_ERROR_TOO_LONG 35303
#define IDS_COMPOSE_ERROR_TRY_AGAIN 35304
#define IDS_COMPOSE_ERROR_TRY_AGAIN_LATER 35305
#define IDS_COMPOSE_ERROR_FILTERED 35306
#define IDS_COMPOSE_ERROR_FILTERED_BACK_BUTTON 35307
#define IDS_COMPOSE_ERROR_UNSUPPORTED_LANGUAGE 35308
#define IDS_COMPOSE_ERROR_PERMISSION_DENIED 35309
#define IDS_COMPOSE_ERROR_REQUEST_THROTTLED 35310
#define IDS_COMPOSE_ERROR_OFFLINE 35311
#define IDS_COMPOSE_FOOTER_FISHFOOD 35312
#define IDS_COMPOSE_EXPERIMENTAL_DISCLAIMER_FOOTER 35313
#define IDS_COMPOSE_REFINEMENTS_EXPERIMENTAL_DISCLAIMER_FOOTER 35314
#define IDS_COMPOSE_FOOTER_FISHFOOD_ON_DEVICE_USED 35315
#define IDS_COMPOSE_FEEDBACK_PLACEHOLDER 35316
#define IDS_CRASH_TITLE 35317
#define IDS_CRASH_CRASH_COUNT_BANNER_FORMAT 35318
#define IDS_CRASH_SHOW_DEVELOPER_DETAILS 35319
#define IDS_CRASH_CAPTURE_TIME_FORMAT 35320
#define IDS_CRASH_REPORT_STATUS 35321
#define IDS_CRASH_REPORT_STATUS_NOT_UPLOADED 35322
#define IDS_CRASH_REPORT_STATUS_PENDING 35323
#define IDS_CRASH_REPORT_STATUS_PENDING_USER_REQUESTED 35324
#define IDS_CRASH_REPORT_STATUS_UPLOADED 35325
#define IDS_CRASH_REPORT_UPLOADED_ID 35326
#define IDS_CRASH_REPORT_UPLOADED_TIME 35327
#define IDS_CRASH_REPORT_LOCAL_ID 35328
#define IDS_CRASH_REPORT_FILE_SIZE 35329
#define IDS_CRASH_BUG_LINK_LABEL 35330
#define IDS_CRASH_NO_CRASHES_MESSAGE 35331
#define IDS_CRASH_DISABLED_HEADER 35332
#define IDS_CRASH_UPLOAD_MESSAGE 35333
#define IDS_CRASH_UPLOAD_NOW_LINK_TEXT 35334
#define IDS_HTTP_POST_WARNING_TITLE 35335
#define IDS_HTTP_POST_WARNING 35336
#define IDS_HTTP_POST_WARNING_RESEND 35337
#define IDS_DOM_DISTILLER_JAVASCRIPT_DISABLED_CONTENT 35338
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_URL 35339
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD 35340
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD_FAILED 35341
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL 35342
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL_FAILED 35343
#define IDS_DOM_DISTILLER_WEBUI_REFRESH 35344
#define IDS_DOM_DISTILLER_WEBUI_FETCHING_ENTRIES 35345
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_TITLE 35346
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_CONTENT 35347
#define IDS_DOM_DISTILLER_VIEWER_LOADING_TITLE 35348
#define IDS_DOM_DISTILLER_VIEWER_CUSTOMIZE_APPEARANCE 35349
#define IDS_DOM_DISTILLER_VIEWER_FONT_STYLE 35350
#define IDS_DOM_DISTILLER_VIEWER_SANS_SERIF_FONT 35351
#define IDS_DOM_DISTILLER_VIEWER_SERIF_FONT 35352
#define IDS_DOM_DISTILLER_VIEWER_MONOSPACE_FONT 35353
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR 35354
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_LIGHT 35355
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_SEPIA 35356
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_DARK 35357
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE 35358
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_SMALL 35359
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_LARGE 35360
#define IDS_DOM_DISTILLER_VIEWER_CLOSE 35361
#define IDS_DOM_DISTILLER_VIEWER_NO_DATA_CONTENT 35362
#define IDS_DOM_DISTILLER_WEBUI_TITLE 35363
#define IDS_DOM_DISTILLER_VIEWER_TITLE_SUFFIX 35364
#define IDS_ENTERPRISE_COPY_PREVENTION_MISSING_LIST_ERROR 35365
#define IDS_ENTERPRISE_COPY_PREVENTION_DISABLE_CONTAINS_WILDCARD_ERROR 35366
#define IDS_ENTERPRISE_COPY_PREVENTION_WARNING_MESSAGE 35367
#define IDS_ENTERPRISE_DATA_CONTROLS_COPY_PREVENTION_WARNING_MESSAGE 35368
#define IDS_DATA_CONTROLS_CLIPBOARD_PASTE_BLOCK_TITLE 35369
#define IDS_DATA_CONTROLS_CLIPBOARD_PASTE_WARN_TITLE 35370
#define IDS_DATA_CONTROLS_CLIPBOARD_COPY_BLOCK_TITLE 35371
#define IDS_DATA_CONTROLS_CLIPBOARD_COPY_WARN_TITLE 35372
#define IDS_DATA_CONTROLS_CLIPBOARD_SHARE_WARN_TITLE 35373
#define IDS_DATA_CONTROLS_CLIPBOARD_ACTION_WARN_TITLE 35374
#define IDS_DATA_CONTROLS_BLOCKED_LABEL 35375
#define IDS_DATA_CONTROLS_WARNED_LABEL 35376
#define IDS_DATA_CONTROLS_WARNED_LABEL_WITH_DOMAIN 35377
#define IDS_DATA_CONTROLS_PASTE_WARN_CONTINUE_BUTTON 35378
#define IDS_DATA_CONTROLS_COPY_WARN_CONTINUE_BUTTON 35379
#define IDS_DATA_CONTROLS_SHARE_WARN_CONTINUE_BUTTON 35380
#define IDS_DATA_CONTROLS_PASTE_WARN_CANCEL_BUTTON 35381
#define IDS_DATA_CONTROLS_COPY_WARN_CANCEL_BUTTON 35382
#define IDS_DATA_CONTROLS_SHARE_WARN_CANCEL_BUTTON 35383
#define IDS_DATA_CONTROLS_BLOCKED_LABEL_WITH_DOMAIN 35384
#define IDS_ERRORPAGE_NET_BUTTON_DETAILS 35385
#define IDS_ERRORPAGE_NET_BUTTON_HIDE_DETAILS 35386
#define IDS_ERRORPAGES_BUTTON_RELOAD 35387
#define IDS_ERRORPAGES_BUTTON_SHOW_SAVED_COPY 35388
#define IDS_ERRORPAGE_FUN_DISABLED 35389
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_REPOST_SUMMARY 35394
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_HEADER 35395
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_BODY 35396
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_HEADER 35397
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_BODY 35398
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_HEADER 35399
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_BODY 35400
#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_HEADER 35401
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_BODY 35402
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_HEADER 35403
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_BODY 35404
#define IDS_ERRORPAGES_SUGGESTION_CAPTIVE_PORTAL_SIGNIN 35405
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_HEADER 35407
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_BODY 35408
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_HEADER 35409
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_BODY 35410
#define IDS_ERRORPAGES_SUGGESTION_NAVIGATE_TO_ORIGIN 35411
#define IDS_ERRORPAGES_HEADING_NOT_AVAILABLE 35412
#define IDS_ERRORPAGES_HEADING_NETWORK_ACCESS_DENIED 35413
#define IDS_ERRORPAGES_HEADING_INTERNET_DISCONNECTED 35414
#define IDS_ERRORPAGES_HEADING_YOU_ARE_OFFLINE 35415
#define IDS_ERRORPAGES_MESSAGE_IWA_INVALID_WEB_BUNDLE 35416
#define IDS_ERRORPAGES_MESSAGE_IWA_CONNECTION_REFUSED 35417
#define IDS_ERRORPAGES_MESSAGE_IWA_INSTALLED_IN_DEV_MODE 35418
#define IDS_ERRORPAGES_MESSAGE_IWA_PAGE_NOT_FOUND 35419
#define IDS_ERRORPAGES_HEADING_CACHE_READ_FAILURE 35420
#define IDS_ERRORPAGES_HEADING_CONNECTION_INTERRUPTED 35421
#define IDS_ERRORPAGES_HEADING_NOT_FOUND 35422
#define IDS_ERRORPAGES_HEADING_FILE_NOT_FOUND 35423
#define IDS_ERRORPAGES_HEADING_BLOCKED 35424
#define IDS_ERRORPAGES_HEADING_BLOCKED_SCHEME 35425
#define IDS_ERRORPAGES_SUMMARY_NOT_AVAILABLE 35426
#define IDS_ERRORPAGES_SUMMARY_TIMED_OUT 35427
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_RESET 35428
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_CLOSED 35429
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_FAILED 35430
#define IDS_ERRORPAGES_SUMMARY_NETWORK_CHANGED 35431
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_REFUSED 35432
#define IDS_ERRORPAGES_SUMMARY_NAME_NOT_RESOLVED 35433
#define IDS_ERRORPAGES_SUMMARY_ICANN_NAME_COLLISION 35434
#define IDS_ERRORPAGES_SUMMARY_ADDRESS_UNREACHABLE 35435
#define IDS_ERRORPAGES_SUMMARY_FILE_ACCESS_DENIED 35436
#define IDS_ERRORPAGES_SUMMARY_NETWORK_ACCESS_DENIED 35437
#define IDS_ERRORPAGES_SUMMARY_PROXY_CONNECTION_FAILED 35438
#define IDS_ERRORPAGES_SUMMARY_CACHE_READ_FAILURE 35439
#define IDS_ERRORPAGES_SUMMARY_NETWORK_IO_SUSPENDED 35440
#define IDS_ERRORPAGES_SUMMARY_NOT_FOUND 35441
#define IDS_ERRORPAGES_SUMMARY_FILE_NOT_FOUND 35442
#define IDS_ERRORPAGES_SUMMARY_TOO_MANY_REDIRECTS 35443
#define IDS_ERRORPAGES_SUMMARY_EMPTY_RESPONSE 35444
#define IDS_ERRORPAGES_SUMMARY_INVALID_RESPONSE 35445
#define IDS_ERRORPAGES_SUMMARY_DNS_PROBE_RUNNING 35446
#define IDS_ERRORPAGES_HEADING_ACCESS_DENIED 35447
#define IDS_ERRORPAGES_HEADING_FILE_ACCESS_DENIED 35448
#define IDS_ERRORPAGES_SUMMARY_FORBIDDEN 35449
#define IDS_ERRORPAGES_SUMMARY_GONE 35450
#define IDS_ERRORPAGES_HEADING_PAGE_NOT_WORKING 35451
#define IDS_ERRORPAGES_SUMMARY_CONTACT_SITE_OWNER 35452
#define IDS_ERRORPAGES_SUMMARY_WEBSITE_CANNOT_HANDLE_REQUEST 35453
#define IDS_ERRORPAGES_SUMMARY_GATEWAY_TIMEOUT 35454
#define IDS_ERRORPAGES_SUMMARY_SSL_SECURITY_ERROR 35455
#define IDS_ERRORPAGES_SUMMARY_SSL_VERSION_OR_CIPHER_MISMATCH 35456
#define IDS_ERRORPAGES_HEADING_INSECURE_CONNECTION 35457
#define IDS_ERRORPAGES_SUMMARY_BAD_SSL_CLIENT_AUTH_CERT 35458
#define IDS_ERRORPAGES_SUMMARY_SSL_CLIENT_AUTH_SIGNATURE_FAILED 35459
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_EXTENSION 35460
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_ADMINISTRATOR 35461
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_SECURITY 35462
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_LOCAL_NETWORK_ACCESS_CHECKS 35463
#define IDS_ERRORPAGES_HTTP_POST_WARNING 35464
#define IDS_ERRORPAGES_HEADING_LINKPREVIEW_NON_HTTPS_FORBIDDEN 35465
#define IDS_ERRORPAGES_SUMMARY_LINKPREVIEW_NON_HTTPS_FORBIDDEN 35466
#define IDS_ERRORPAGES_SUGGESTION_LIST_HEADER 35467
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_SUMMARY 35468
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_DNS_SUMMARY 35470
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SECURE_DNS_SUMMARY 35471
#define IDS_ERRORPAGES_SUGGESTION_CHECK_FIREWALL_ANTIVIRUS_SUMMARY 35472
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SUMMARY 35473
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_ADDRESS_SUMMARY 35474
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY 35475
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY_STANDALONE 35476
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY 35477
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY_STANDALONE 35478
#define IDS_ERRORPAGES_SUGGESTION_DELETE_COOKIES_SUMMARY 35479
#define IDS_ERRORPAGES_SUGGESTION_CHECK_HARDWARE_SUMMARY 35483
#define IDS_ERRORPAGES_SUGGESTION_CHECK_WIFI_SUMMARY 35484
#define IDS_ERRORPAGES_SUGGESTION_DISABLE_EXTENSION_SUMMARY 35485
#define IDS_ERRORPAGES_CHECK_TYPO_SUMMARY 35486
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE 35487
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_STANDALONE 35488
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_CHECK_TYPO_STANDALONE 35489
#define IDS_ERRORPAGES_GAME_INSTRUCTIONS 35490
#define IDS_ERRORPAGE_DINO_GAME_DESCRIPTION 35491
#define IDS_ERRORPAGE_DINO_ARIA_LABEL 35492
#define IDS_ERRORPAGE_DINO_GAME_START 35493
#define IDS_ERRORPAGE_DINO_GAME_OVER 35494
#define IDS_ERRORPAGE_DINO_HIGH_SCORE 35495
#define IDS_ERRORPAGE_DINO_JUMP 35496
#define IDS_ERRORPAGE_DINO_SLOW_SPEED_TOGGLE 35497
#define IDS_FIND_IN_PAGE_ACCESSIBLE_TITLE 35498
#define IDS_FIND_IN_PAGE_COUNT 35499
#define IDS_ACCESSIBLE_FIND_IN_PAGE_COUNT 35500
#define IDS_ACCESSIBLE_FIND_IN_PAGE_NO_RESULTS 35501
#define IDS_FIND_IN_PAGE_PREVIOUS_TOOLTIP 35502
#define IDS_FIND_IN_PAGE_NEXT_TOOLTIP 35503
#define IDS_FIND_IN_PAGE_CLOSE_TOOLTIP 35504
#define IDS_FLAGS_UI_SEARCH_PLACEHOLDER 35505
#define IDS_FLAGS_UI_SEARCH_LABEL 35506
#define IDS_FLAGS_UI_TITLE 35507
#define IDS_FLAGS_UI_PAGE_RESET 35508
#define IDS_FLAGS_UI_PAGE_WARNING 35509
#define IDS_FLAGS_UI_PAGE_WARNING_EXPLANATION 35510
#define IDS_FLAGS_UI_OWNER_WARNING 35511
#define IDS_FLAGS_UI_AVAILABLE_FEATURE 35512
#define IDS_FLAGS_UI_UNAVAILABLE_FEATURE 35513
#define IDS_FLAGS_UI_ENABLED_FEATURE 35514
#define IDS_FLAGS_UI_DISABLED_FEATURE 35515
#define IDS_FLAGS_UI_NO_RESULTS 35516
#define IDS_FLAGS_UI_NOT_AVAILABLE_ON_PLATFORM 35517
#define IDS_FLAGS_UI_RELAUNCH 35518
#define IDS_FLAGS_UI_CLEAR_SEARCH 35519
#define IDS_FLAGS_UI_RESET_ACKNOWLEDGED 35520
#define IDS_FLAGS_UI_EXPERIMENT_ENABLED 35521
#define IDS_FLAGS_UI_SEARCH_RESULTS_SINGULAR 35522
#define IDS_FLAGS_UI_SEARCH_RESULTS_PLURAL 35523
#define IDS_DEPRECATED_FEATURES_SEARCH_PLACEHOLDER 35524
#define IDS_DEPRECATED_FEATURES_TITLE 35525
#define IDS_DEPRECATED_FEATURES_HEADING 35526
#define IDS_DEPRECATED_FEATURES_PAGE_WARNING_EXPLANATION 35527
#define IDS_DEPRECATED_FEATURES_NO_RESULTS 35528
#define IDS_EXIT_FULLSCREEN_MODE 35529
#define IDS_FULLSCREEN_HOLD_TO_EXIT_FULLSCREEN 35530
#define IDS_FULLSCREEN_HOLD_TO_EXIT_FULLSCREEN_WITH_ORIGIN 35531
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN 35532
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN_WITH_ORIGIN 35533
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN_TWO_KEYS 35534
#define IDS_PRESS_TO_EXIT_MOUSELOCK 35535
#define IDS_PRESS_TO_EXIT_MOUSELOCK_WITH_ORIGIN 35536
#define IDS_PRESS_TO_EXIT_MOUSELOCK_TWO_KEYS 35537
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS 35538
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS 35539
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS_AND_EXIT 35540
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS_AND_EXIT 35541
#define IDS_FULLSCREEN_TOUCH_BASED_EXIT_FULLSCREEN_WITH_ORIGIN 35542
#define IDS_FULLSCREEN_TOUCH_BASED_EXIT_FULLSCREEN 35543
#define IDS_TOUCH_BASED_EXIT_MOUSELOCK_WITH_ORIGIN 35544
#define IDS_TOUCH_BASED_EXIT_MOUSELOCK 35545
#define IDS_FULLSCREEN_TOUCH_BASED_INSTRUCTIONS_TO_SEE_DOWNLOADS 35546
#define IDS_FULLSCREEN_TOUCH_BASED_INSTRUCTIONS_TO_SEE_DOWNLOADS_AND_EXIT 35547
#define IDS_GLOBAL_MEDIA_CONTROLS_BACK_TO_TAB 35548
#define IDS_GLOBAL_MEDIA_CONTROLS_DISMISS_ICON_TOOLTIP_TEXT 35549
#define IDS_GLOBAL_MEDIA_CONTROLS_CAST_HEADER_TEXT 35550
#define IDS_GLOBAL_MEDIA_CONTROLS_CLOSE_DEVICE_LIST_TEXT 35551
#define IDS_GLOBAL_MEDIA_CONTROLS_UNKNOWN_SOURCE_TEXT 35552
#define IDS_GLOBAL_MEDIA_CONTROLS_UNKNOWN_DEVICE_TEXT 35553
#define IDS_GLOBAL_MEDIA_CONTROLS_MEDIA_LIVE_TEXT 35554
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_DETAILS 35555
#define IDS_HEAVY_AD_INTERVENTION_HEADING 35556
#define IDS_HEAVY_AD_INTERVENTION_SUMMARY 35557
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_RELOAD 35558
#define IDS_HISTORY_CLUSTERS_ACTION_MENU_DESCRIPTION 35559
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 35560
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_WARNING 35561
#define IDS_HISTORY_CLUSTERS_BY_GROUP_TAB_LABEL 35562
#define IDS_HISTORY_CLUSTERS_BY_DATE_TAB_LABEL 35563
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_SEARCH_TERMS 35564
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_MULTIPLE_HOSTNAMES 35565
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_OTHER_MATCHING_VISITS 35566
#define IDS_HISTORY_CLUSTERS_HIDE_PAGE 35567
#define IDS_HISTORY_CLUSTERS_HIDE_VISITS 35568
#define IDS_HISTORY_CLUSTERS_LOAD_MORE_BUTTON_LABEL 35569
#define IDS_HISTORY_CLUSTERS_NO_RESULTS 35570
#define IDS_HISTORY_CLUSTERS_NO_SEARCH_RESULTS 35571
#define IDS_HISTORY_CLUSTERS_SHOW_SIDE_PANEL 35572
#define IDS_HISTORY_CLUSTERS_OPEN_ALL_IN_TABGROUP 35573
#define IDS_HISTORY_CLUSTERS_OPEN_INCOGNITO 35574
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_TAB 35575
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_WINDOW 35576
#define IDS_HISTORY_CLUSTERS_RELATED_SEARCHES_HEADER 35577
#define IDS_HISTORY_CLUSTERS_REMOVE_ALL_ITEMS 35578
#define IDS_HISTORY_CLUSTERS_REMOVE_PAGE 35579
#define IDS_HISTORY_CLUSTERS_REMOVE_ITEM_TOAST 35580
#define IDS_HISTORY_CLUSTERS_REMOVE_SELECTED_ITEMS 35581
#define IDS_HISTORY_CLUSTERS_SAVED_IN_TABGROUP_LABEL 35582
#define IDS_HISTORY_CLUSTERS_CUT 35583
#define IDS_HISTORY_CLUSTERS_COPY 35584
#define IDS_HISTORY_CLUSTERS_PASTE 35585
#define IDS_HISTORY_CLUSTERS_COPY_LINK 35586
#define IDS_HISTORY_CLUSTERS_SHOW_LESS_BUTTON_LABEL 35587
#define IDS_HISTORY_CLUSTERS_SHOW_MORE_BUTTON_LABEL 35588
#define IDS_HISTORY_ACTION_MENU_DESCRIPTION 35589
#define IDS_HISTORY_ARIA_ROLE_DESCRIPTION 35590
#define IDS_HISTORY_CANCEL_EDITING_BUTTON 35591
#define IDS_HISTORY_DATE_WITH_RELATIVE_TIME 35592
#define IDS_HISTORY_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 35593
#define IDS_HISTORY_DELETE_PRIOR_VISITS_WARNING 35594
#define IDS_HISTORY_DELETE_SELECTED_ENTRIES_BUTTON 35595
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_DELETE 35596
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_LABEL 35597
#define IDS_HISTORY_ENTRY_BOOKMARKED 35598
#define IDS_HISTORY_ENTRY_SUMMARY 35599
#define IDS_HISTORY_FOUND_SEARCH_RESULTS 35600
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY_GMA_ONLY 35601
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY_GAA_ONLY 35602
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY_GMA_AND_GAA 35603
#define IDS_HISTORY_LOADING 35604
#define IDS_HISTORY_MORE_FROM_SITE 35605
#define IDS_HISTORY_NO_RESULTS 35606
#define IDS_HISTORY_NO_SEARCH_RESULTS 35607
#define IDS_HISTORY_OPEN_CLEAR_BROWSING_DATA_DIALOG 35608
#define IDS_HISTORY_OTHER_SESSIONS_COLLAPSE_SESSION 35609
#define IDS_HISTORY_OTHER_SESSIONS_EXPAND_SESSION 35610
#define IDS_HISTORY_OTHER_SESSIONS_HIDE_FOR_NOW 35611
#define IDS_HISTORY_OTHER_SESSIONS_OPEN_ALL 35612
#define IDS_HISTORY_REMOVE_BOOKMARK 35613
#define IDS_HISTORY_REMOVE_PAGE 35614
#define IDS_HISTORY_REMOVE_PAGE_SUCCESS 35615
#define IDS_HISTORY_REMOVE_SELECTED_ITEMS 35616
#define IDS_HISTORY_SEARCH_BUTTON 35617
#define IDS_HISTORY_SEARCH_RESULT 35618
#define IDS_HISTORY_SEARCH_RESULTS 35619
#define IDS_HISTORY_SEARCH_EXACT_MATCH_RESULT 35620
#define IDS_HISTORY_SEARCH_EXACT_MATCH_RESULTS 35621
#define IDS_HISTORY_SEARCH_EMBEDDINGS_MATCH_RESULT 35622
#define IDS_HISTORY_SEARCH_EMBEDDINGS_MATCH_RESULTS 35623
#define IDS_HISTORY_SHOW_HISTORY 35624
#define IDS_HISTORY_SHOW_SIDE_PANEL 35625
#define IDS_HISTORY_SHOWFULLHISTORY_LINK 35626
#define IDS_HISTORY_START_EDITING_BUTTON 35627
#define IDS_HISTORY_TITLE 35628
#define IDS_HISTORY_UNKNOWN_DEVICE 35629
#define IDS_ACTOR_TASK 35630
#define IDS_HISTORY_EMBEDDINGS_DISCLAIMER 35631
#define IDS_HISTORY_EMBEDDINGS_DISCLAIMER_LOGGING_OFF 35632
#define IDS_HISTORY_EMBEDDINGS_PROMO_LABEL 35633
#define IDS_HISTORY_EMBEDDINGS_PROMO_CLOSE 35634
#define IDS_HISTORY_EMBEDDINGS_PROMO_HEADING 35635
#define IDS_HISTORY_EMBEDDINGS_PROMO_BODY 35636
#define IDS_HISTORY_EMBEDDINGS_ANSWERS_PROMO_HEADING 35637
#define IDS_HISTORY_EMBEDDINGS_ANSWERS_PROMO_BODY 35638
#define IDS_HISTORY_EMBEDDIGNS_PROMO_SETTINGS_LINK_TEXT 35639
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_ARIA_LABEL 35640
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_DATE 35641
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_GROUP 35642
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_1 35643
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_2 35644
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_3 35645
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_1_ARIA_LABEL 35646
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_2_ARIA_LABEL 35647
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_3_ARIA_LABEL 35648
#define IDS_HISTORY_EMBEDDINGS_HEADING 35649
#define IDS_HISTORY_EMBEDDINGS_HEADING_LOADING 35650
#define IDS_HISTORY_EMBEDDINGS_WITH_ANSWERS_RESULTS_HEADING 35651
#define IDS_HISTORY_EMBEDDINGS_FOOTER 35652
#define IDS_HISTORY_EMBEDDINGS_FEEDBACK_PLACEHOLDER 35653
#define IDS_HISTORY_EMBEDDINGS_IPH_BODY 35654
#define IDS_HISTORY_EMBEDDINGS_IPH_ACTION 35655
#define IDS_HISTORY_EMBEDDINGS_SEARCH_PROMPT 35656
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_1 35657
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_2 35658
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_3 35659
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_4 35660
#define IDS_HISTORY_EMBEDDINGS_ANSWER_HEADING 35661
#define IDS_HISTORY_EMBEDDINGS_ANSWER_LOADING_HEADING 35662
#define IDS_HISTORY_EMBEDDINGS_ANSWER_SOURCE_VISIT_DATE_LABEL 35663
#define IDS_HISTORY_EMBEDDINGS_ANSWERER_ERROR_UNANSWERABLE 35664
#define IDS_HISTORY_EMBEDDINGS_ANSWERER_ERROR_MODEL_UNAVAILABLE 35665
#define IDS_HISTORY_EMBEDDINGS_ANSWERER_ERROR_TRY_AGAIN 35666
#define IDS_COMPARE_HISTORY_EMPTY 35667
#define IDS_COMPARE_HISTORY_HEADER 35668
#define IDS_COMPARE_HISTORY_INFO 35669
#define IDS_COMPARE_HISTORY_MENU_ARIA_LABEL 35670
#define IDS_COMPARE_HISTORY_MENU_ITEM 35671
#define IDS_COMPARE_HISTORY_REMOVE 35672
#define IDS_COMPARE_HISTORY_ROW 35673
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE 35674
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_IFRAME 35675
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL 35676
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL_IFRAME 35677
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_EXTENSION 35678
#define IDS_JAVASCRIPT_MESSAGEBOX_SUPPRESS_OPTION 35679
#define IDS_BEFOREUNLOAD_MESSAGEBOX_TITLE 35680
#define IDS_BEFOREUNLOAD_APP_MESSAGEBOX_TITLE 35681
#define IDS_BEFOREUNLOAD_MESSAGEBOX_OK_BUTTON_LABEL 35682
#define IDS_BEFOREUNLOAD_MESSAGEBOX_MESSAGE 35683
#define IDS_BEFORERELOAD_MESSAGEBOX_TITLE 35684
#define IDS_BEFORERELOAD_APP_MESSAGEBOX_TITLE 35685
#define IDS_BEFORERELOAD_MESSAGEBOX_OK_BUTTON_LABEL 35686
#define IDS_LIVE_CAPTION_BUBBLE_TITLE 35687
#define IDS_LIVE_CAPTION_BUBBLE_CLOSE 35688
#define IDS_LIVE_CAPTION_BUBBLE_EXPAND 35689
#define IDS_LIVE_CAPTION_BUBBLE_COLLAPSE 35690
#define IDS_LIVE_CAPTION_BUBBLE_BACK_TO_TAB 35691
#define IDS_LIVE_CAPTION_BUBBLE_PIN 35692
#define IDS_LIVE_CAPTION_BUBBLE_UNPIN 35693
#define IDS_LIVE_CAPTION_BUBBLE_ERROR 35694
#define IDS_LIVE_CAPTION_BUBBLE_CONTENT_SETTINGS 35695
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR 35696
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR_CHECKBOX 35697
#define IDS_LIVE_CAPTION_BUBBLE_APPEAR_SCREENREADER_ANNOUNCEMENT 35698
#define IDS_LIVE_CAPTION_CAPTION_LANGUAGE_AUTODETECTED 35699
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE 35700
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE_AUTODETECTED 35701
#define IDS_LIVE_CAPTION_BUBBLE_CAPTION_SETTINGS 35702
#define IDS_LIVE_CAPTION_BUBBLE_SCROLL_BUTTON_SCROLLING 35703
#define IDS_LIVE_CAPTION_BUBBLE_SCROLL_BUTTON_LOCKED 35704
#define IDS_LIVE_CAPTION_DOWNLOAD_PROGRESS 35705
#define IDS_LIVE_CAPTION_LANGUAGE_DOWNLOAD_FAILED 35706
#define IDS_LIVE_CAPTION_TRANSLATING 35707
#define IDS_LOGIN_DIALOG_TITLE 35708
#define IDS_LOGIN_DIALOG_OK_BUTTON_LABEL 35709
#define IDS_LOGIN_DIALOG_AUTHORITY 35710
#define IDS_LOGIN_DIALOG_PROXY_AUTHORITY 35711
#define IDS_LOGIN_DIALOG_NOT_PRIVATE 35712
#define IDS_LOGIN_DIALOG_USERNAME_FIELD 35713
#define IDS_LOGIN_DIALOG_PASSWORD_FIELD 35714
#define IDS_MANAGEMENT_TITLE 35715
#define IDS_MANAGEMENT_TOOLBAR_TITLE 35716
#define IDS_MANAGEMENT_SUBTITLE_MANAGED_BY 35718
#define IDS_MANAGEMENT_NOT_MANAGED_SUBTITLE 35719
#define IDS_MANAGEMENT_SUBTITLE 35720
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY 35721
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY 35722
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_SAME_MANAGED_BY 35723
#define IDS_MANAGEMENT_SUBTITLE_PROFILE_MANAGED_BY 35724
#define IDS_MANAGEMENT_BROWSER_NOTICE 35725
#define IDS_MANAGEMENT_NOT_MANAGED_NOTICE 35726
#define IDS_MANAGEMENT_PROFILE_NOTICE 35727
#define IDS_MANAGEMENT_LEARN_MORE_ACCCESSIBILITY_TEXT 35728
#define IDS_MANAGEMENT_EXTENSION_REPORTING 35780
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED 35781
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED_BY 35782
#define IDS_MANAGEMENT_EXTENSIONS_NAME 35783
#define IDS_MANAGEMENT_EXTENSIONS_PERMISSIONS 35784
#define IDS_MANAGEMENT_APPLICATION_REPORTING 35785
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED 35786
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED_BY 35787
#define IDS_MANAGEMENT_APPLICATIONS_NAME 35788
#define IDS_MANAGEMENT_APPLICATIONS_PERMISSIONS 35789
#define IDS_MANAGEMENT_APPLICATIONS_RUN_ON_OS_LOGIN 35790
#define IDS_MANAGEMENT_MANAGED_WEBSITES 35791
#define IDS_MANAGEMENT_MANAGED_WEBSITES_EXPLANATION 35792
#define IDS_MANAGEMENT_MANAGED_WEBSITES_BY_EXPLANATION 35793
#define IDS_MANAGEMENT_BROWSER_REPORTING 35794
#define IDS_MANAGEMENT_BROWSER_REPORTING_EXPLANATION 35795
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME 35796
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME_ADDRESS 35797
#define IDS_MANAGEMENT_EXTENSION_REPORT_USERNAME 35798
#define IDS_MANAGEMENT_EXTENSION_REPORT_VERSION 35799
#define IDS_MANAGEMENT_EXTENSION_REPORT_EXTENSIONS_PLUGINS 35800
#define IDS_MANAGEMENT_EXTENSION_REPORT_USER_BROWSING_DATA 35801
#define IDS_MANAGEMENT_EXTENSION_REPORT_PERF_CRASH 35802
#define IDS_MANAGEMENT_EXTENSION_REPORT_VISITED_URL 35803
#define IDS_MANAGEMENT_LEGACY_TECH_REPORT 35804
#define IDS_MANAGEMENT_LEGACY_TECH_REPORT_NO_LINK 35805
#define IDS_MANAGEMENT_PROFILE_REPORTING_EXPLANATION 35806
#define IDS_MANAGEMENT_PROFILE_REPORTING_OVERVIEW 35807
#define IDS_MANAGEMENT_PROFILE_REPORTING_USERNAME 35808
#define IDS_MANAGEMENT_PROFILE_REPORTING_BROWSER 35809
#define IDS_MANAGEMENT_PROFILE_REPORTING_EXTENSION 35810
#define IDS_MANAGEMENT_PROFILE_REPORTING_POLICY 35811
#define IDS_MANAGEMENT_PROFILE_REPORTING_LEARN_MORE 35812
#define IDS_MANAGEMENT_THREAT_PROTECTION_MORE 35813
#define IDS_MANAGEMENT_FILE_ATTACHED_EVENT 35814
#define IDS_MANAGEMENT_FILE_DOWNLOADED_EVENT 35815
#define IDS_MANAGEMENT_TEXT_ENTERED_EVENT 35816
#define IDS_MANAGEMENT_PAGE_PRINTED_EVENT 35817
#define IDS_MANAGEMENT_FILE_TRANSFER_EVENT 35818
#define IDS_MANAGEMENT_SCREEN_CAPTURE_EVENT 35819
#define IDS_MANAGEMENT_EXTENSION_TELEMETRY_EVENT 35820
#define IDS_MANAGEMENT_FILE_ATTACHED_VISIBLE_DATA 35821
#define IDS_MANAGEMENT_FILE_DOWNLOADED_VISIBLE_DATA 35822
#define IDS_MANAGEMENT_TEXT_ENTERED_VISIBLE_DATA 35823
#define IDS_MANAGEMENT_PAGE_PRINTED_VISIBLE_DATA 35824
#define IDS_MANAGEMENT_FILE_TRANSFER_VISIBLE_DATA 35825
#define IDS_MANAGEMENT_SCREEN_CAPTURE_DATA 35826
#define IDS_MANAGEMENT_EXTENSION_TELEMETRY_VISIBLE_DATA 35827
#define IDS_MANAGEMENT_DEVICE_SIGNALS_DISCLOSURE 35832
#define IDS_MANAGEMENT_THREAT_PROTECTION 35833
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION 35834
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION_BY 35835
#define IDS_MANAGEMENT_CONNECTORS_EVENT 35836
#define IDS_MANAGEMENT_CONNECTORS_VISIBLE_DATA 35837
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_EVENT 35838
#define IDS_MANAGEMENT_PAGE_VISITED_EVENT 35839
#define IDS_MANAGEMENT_PAGE_VISITED_VISIBLE_DATA 35840
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_VISIBLE_DATA 35841
#define IDS_MANAGEMENT_DIALOG_BROWSING_DATA_MANAGEMENT 35842
#define IDS_MANAGEMENT_DIALOG_DEVICE_SIGNALS 35843
#define IDS_MANAGEMENT_DIALOG_PROFILE_MANAGED_BY 35844
#define IDS_MANAGEMENT_DIALOG_THINGS_TO_CONSIDER_SUBTITLE 35845
#define IDS_MANAGED_PROFILE_INTERSTITIAL_TAB_TITLE 35846
#define IDS_MANAGEMENT_BANNER_PROMOTION_TITLE 35847
#define IDS_MANAGEMENT_BANNER_PROMOTION_DESC 35848
#define IDS_MANAGEMENT_BANNER_PROMOTION_BTN 35849
#define IDS_MANAGEMENT_BANNER_ARIA_LABEL 35850
#define IDS_MANAGEMENT_BANNER_NEW_TAB_ARIA_DESCRIPTION 35851
#define IDS_MANAGEMENT_BANNER_DISMISS_ARIA_LABEL 35852
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PREVIOUS_TRACK 35853
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_BACKWARD 35854
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_REPLAY_10 35855
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PLAY 35856
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PAUSE 35857
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_FORWARD_10 35858
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_FORWARD 35859
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_NEXT_TRACK 35860
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_ENTER_PIP 35861
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_EXIT_PIP 35862
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_MUTE 35863
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_UNMUTE 35864
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SHOW_DEVICE_LIST 35865
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_HIDE_DEVICE_LIST 35866
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_STOP_CASTING 35867
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_TIME_SCRUBBER 35868
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACCESSIBLE_NAME 35869
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_LABEL 35870
#define IDS_DEFAULT_TAB_TITLE 474
#define IDS_DOWNLOAD_TAB_TITLE 35871
#define IDS_SAD_TAB_TITLE 35872
#define IDS_SAD_TAB_MESSAGE 35873
#define IDS_SAD_TAB_HELP_MESSAGE 35874
#define IDS_SAD_TAB_HELP_LINK 35875
#define IDS_SAD_TAB_RELOAD_LABEL 35876
#define IDS_SAD_TAB_OOM_TITLE 35878
#define IDS_SAD_TAB_RELOAD_TITLE 35879
#define IDS_SAD_TAB_OOM_MESSAGE_TABS 35880
#define IDS_SAD_TAB_OOM_MESSAGE_NOTABS 35881
#define IDS_SAD_TAB_RELOAD_TRY 35882
#define IDS_SAD_TAB_RELOAD_INCOGNITO 35883
#define IDS_SAD_TAB_RELOAD_RESTART_BROWSER 35886
#define IDS_SAD_TAB_RELOAD_RESTART_DEVICE 35887
#define IDS_SAD_TAB_ERROR_CODE 35889
#define IDS_NEW_TAB_TITLE 484
#define IDS_NEW_INCOGNITO_TAB_TITLE 35890
#define IDS_INCOGNITO_TAB_LEARN_MORE_ACCESSIBILITY_LABEL 35891
#define IDS_NEW_TAB_OTR_HEADING 35892
#define IDS_NEW_TAB_OTR_DESCRIPTION 35893
#define IDS_NEW_TAB_OTR_LEARN_MORE_LINK 35894
#define IDS_NEW_TAB_OTR_MESSAGE_WARNING 35895
#define IDS_NEW_TAB_UNDO_THUMBNAIL_REMOVE 485
#define IDS_NEW_TAB_OTR_TITLE 35896
#define IDS_NEW_TAB_OTR_SUBTITLE 35897
#define IDS_NEW_TAB_OTR_SUBTITLE_WITH_READING_LIST 35898
#define IDS_NEW_TAB_OTR_NOT_SAVED 35899
#define IDS_NEW_TAB_OTR_VISIBLE 35900
#define IDS_NEW_TAB_OPENS_HC_ARTICLE_IN_NEW_TAB 35901
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 154
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUGGESTION_CONTENTS 153
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUFFIX 152
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA 151
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 158
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUGGESTION_CONTENTS 157
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUFFIX 156
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS 155
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 162
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUGGESTION_CONTENTS 161
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUFFIX 160
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD 159
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 166
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 165
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 164
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 163
#define IDS_OMNIBOX_PEDAL_TRANSLATE_HINT 170
#define IDS_OMNIBOX_PEDAL_TRANSLATE_SUGGESTION_CONTENTS 169
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE_SUFFIX 168
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE 167
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_HINT 174
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_SUGGESTION_CONTENTS 173
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME_SUFFIX 172
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME 171
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUGGESTION_CONTENTS 177
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUFFIX 176
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK 175
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_HINT 35902
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_SUGGESTION_CONTENTS 35903
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_SUFFIX 35904
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2 35905
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_HINT 182
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUGGESTION_CONTENTS 181
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUFFIX 180
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS 179
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_HINT 186
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_SUGGESTION_CONTENTS 185
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES_SUFFIX 184
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES 183
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_HINT 190
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUGGESTION_CONTENTS 189
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUFFIX 188
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES 187
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_HINT 194
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_SUGGESTION_CONTENTS 193
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC_SUFFIX 192
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC 191
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_HINT 198
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUGGESTION_CONTENTS 197
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUFFIX 196
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS 195
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_HINT 206
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUGGESTION_CONTENTS 205
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUFFIX 204
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC 203
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_HINT 210
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUGGESTION_CONTENTS 209
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUFFIX 208
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET 207
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_HINT 214
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUGGESTION_CONTENTS 213
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUFFIX 212
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE 211
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_HINT 218
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUGGESTION_CONTENTS 217
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUFFIX 216
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT 215
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_HINT 222
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUGGESTION_CONTENTS 221
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUFFIX 220
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE 219
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_HINT 226
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUGGESTION_CONTENTS 225
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUFFIX 224
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE 223
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_HINT 230
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUGGESTION_CONTENTS 229
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUFFIX 228
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM 227
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_HINT 202
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUGGESTION_CONTENTS 201
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUFFIX 200
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS 199
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_HINT 234
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUGGESTION_CONTENTS 233
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUFFIX 232
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT 231
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_HINT 238
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUGGESTION_CONTENTS 237
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUFFIX 236
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD 235
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_HINT 35906
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUGGESTION_CONTENTS 35907
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUFFIX 35908
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS 35909
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 242
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUGGESTION_CONTENTS 241
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUFFIX 240
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME 239
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_HINT 246
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_SUGGESTION_CONTENTS 245
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE_SUFFIX 244
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE 243
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_HINT 250
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUGGESTION_CONTENTS 249
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUFFIX 248
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY 247
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 254
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUGGESTION_CONTENTS 253
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUFFIX 252
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS 251
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_HINT 258
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUGGESTION_CONTENTS 257
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUFFIX 256
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS 255
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 262
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUGGESTION_CONTENTS 261
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUFFIX 260
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY 259
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_HINT 266
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUGGESTION_CONTENTS 265
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUFFIX 264
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE 263
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_HINT 270
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUGGESTION_CONTENTS 269
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUFFIX 268
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY 267
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_HINT 274
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUGGESTION_CONTENTS 273
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUFFIX 272
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS 271
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_HINT 278
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUGGESTION_CONTENTS 277
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUFFIX 276
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES 275
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_HINT 282
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUGGESTION_CONTENTS 281
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUFFIX 280
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES 279
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_HINT 35910
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUGGESTION_CONTENTS 35911
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUFFIX 35912
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY 35913
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 286
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 285
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 284
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 283
#define IDS_ANDROID_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 35914
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 35915
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 35916
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 35917
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 35918
#define IDS_IOS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 35919
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 35920
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 35921
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 35922
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 35923
#define IDS_IOS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 35924
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 35925
#define IDS_IOS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 35926
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 35927
#define IDS_IOS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 35928
#define IDS_IOS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 35929
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 35930
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 35931
#define IDS_AUTOCOMPLETE_SEARCH_DESCRIPTION 35932
#define IDS_AUTOCOMPLETE_ASK_DESCRIPTION 35933
#define IDS_AUTOCOMPLETE_SEARCH_IN_SIDE_PANEL_DESCRIPTION 35934
#define IDS_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION_LABEL 35935
#define IDS_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION_LABEL_ALT 35936
#define IDS_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION_LABEL_ALT2 35937
#define IDS_OMNIBOX_TOOLBELT_LABEL 35938
#define IDS_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION_HINT 35939
#define IDS_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION_SUGGESTION_CONTENTS 35940
#define IDS_ACC_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION_SUFFIX 35941
#define IDS_ACC_CONTEXTUAL_SEARCH_OPEN_LENS_ACTION 35942
#define IDS_STARTER_PACK_BOOKMARKS_ACTION_HINT 35943
#define IDS_STARTER_PACK_BOOKMARKS_ACTION_SUGGESTION_CONTENTS 35944
#define IDS_ACC_STARTER_PACK_BOOKMARKS_ACTION_SUFFIX 35945
#define IDS_ACC_STARTER_PACK_BOOKMARKS_ACTION 35946
#define IDS_STARTER_PACK_HISTORY_ACTION_HINT 35947
#define IDS_STARTER_PACK_HISTORY_ACTION_SUGGESTION_CONTENTS 35948
#define IDS_ACC_STARTER_PACK_HISTORY_ACTION_SUFFIX 35949
#define IDS_ACC_STARTER_PACK_HISTORY_ACTION 35950
#define IDS_STARTER_PACK_TABS_ACTION_HINT 35951
#define IDS_STARTER_PACK_TABS_ACTION_SUGGESTION_CONTENTS 35952
#define IDS_ACC_STARTER_PACK_TABS_ACTION_SUFFIX 35953
#define IDS_ACC_STARTER_PACK_TABS_ACTION 35954
#define IDS_STARTER_PACK_AI_MODE_ACTION_HINT 35955
#define IDS_STARTER_PACK_AI_MODE_ACTION_SUGGESTION_CONTENTS 35956
#define IDS_ACC_STARTER_PACK_AI_MODE_ACTION_SUFFIX 35957
#define IDS_ACC_STARTER_PACK_AI_MODE_ACTION 35958
#define IDS_EMPTY_KEYWORD_VALUE 471
#define IDS_EMPTY_STARTER_PACK_AI_MODE_VALUE 35959
#define IDS_LINK_FROM_CLIPBOARD 35960
#define IDS_TEXT_FROM_CLIPBOARD 35961
#define IDS_IMAGE_FROM_CLIPBOARD 35962
#define IDS_SECURE_CONNECTION_EV 35963
#define IDS_SECURE_VERBOSE_STATE 35964
#define IDS_NOT_SECURE_VERBOSE_STATE 35965
#define IDS_DANGEROUS_VERBOSE_STATE 35966
#define IDS_OFFLINE_VERBOSE_STATE 35967
#define IDS_OMNIBOX_EMPTY_HINT 35968
#define IDS_OMNIBOX_EMPTY_HINT_WITH_DSE_NAME 35969
#define IDS_OMNIBOX_EMPTY_HINT_WITH_DSE_NAME_FOR_AI_MODE 35970
#define IDS_OMNIBOX_NAVATTACH_GALLERY 35971
#define IDS_OMNIBOX_NAVATTACH_FILES 35972
#define IDS_OMNIBOX_NAVATTACH_TABS 35973
#define IDS_OMNIBOX_ADDITIONAL_TEXT_DASH_TEMPLATE 35975
#define IDS_OMNIBOX_TAB_SUGGEST_HINT 35976
#define IDS_OMNIBOX_HISTORY_EMBEDDING_HINT 35977
#define IDS_OMNIBOX_FILE 35978
#define IDS_OMNIBOX_READER_MODE 35979
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_BUGANIZER 35980
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_COMMA_SEPARATED_VALUES 35981
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_APPS_SCRIPT 35982
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_DOCS 35983
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_DRAWINGS 35984
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_DRIVE 35985
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_DRIVE_FOLDER 35986
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_FORMS 35987
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_JAMBOARD 35988
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_PHOTOS 35989
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_SITES 35990
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_SHEETS 35991
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_GOOGLE_SLIDES 35992
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_IMAGE_JPEG 35993
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_IMAGE_PNG 35994
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_IMAGE_SVG 35995
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_JIRA 35996
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_JSON 35997
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_MARKDOWN 35998
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_MS_EXCEL 35999
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_MS_POWERPOINT 36000
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_MS_WORD 36001
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_OPEN_DOCUMENT_PRESENTATION 36002
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_OPEN_DOCUMENT_SPREADSHEET 36003
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_OPEN_DOCUMENT_TEXT 36004
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_PDF 36005
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_PLAIN_TEXT 36006
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_RICH_TEXT_FORMAT 36007
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_SALESFORCE 36008
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_SLACK 36009
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_VIDEO_MP4 36010
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_VIDEO_QUICKTIME 36011
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_VIDEO_WEBM 36012
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_ZIP_FILE 36013
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_TEMPLATE 36014
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_DATE 36015
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_OWNER 36016
#define IDS_CONTENT_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_FILE_TYPE_DESCRIPTION 36017
#define IDS_PERSON_SUGGESTION_DESCRIPTION 36018
#define IDS_ACCURACY_CHECK_VERBOSE_STATE 36019
#define IDS_OMNIBOX_HISTORY_CLUSTERS_SEARCH_HINT 36020
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_HINT 36021
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUGGESTION_CONTENTS 36022
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUFFIX 36023
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH 36024
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST_SUFFIX 36025
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST 36026
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_HINT 36027
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_CONTENTS 36028
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_HINT 36029
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_CONTENTS 36030
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_HINT 36031
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_CONTENTS 36032
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_AIM_HINT 36033
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_AIM_CONTENTS 36034
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_TAB_SWITCH_HINT 36035
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_TAB_SWITCH_CONTENTS 36036
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_HINT 36037
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_CONTENTS 36038
#define IDS_ACC_OMNIBOX_ACTION_IN_EXTENSION_SUGGEST_SUFFIX 36039
#define IDS_ACC_AUTOCOMPLETE_HISTORY 36040
#define IDS_ACC_AUTOCOMPLETE_SEARCH_HISTORY 36041
#define IDS_ACC_AUTOCOMPLETE_SEARCH 36042
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH 36043
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH_ENTITY 36044
#define IDS_ACC_AUTOCOMPLETE_QUICK_ANSWER 36045
#define IDS_ACC_AUTOCOMPLETE_BOOKMARK 36046
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_IMAGE 36047
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_TEXT 36048
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_URL 36049
#define IDS_ACC_SEARCH_ICON 472
#define IDS_ACC_AUTOCOMPLETE_N_OF_M 36050
#define IDS_ACC_TAB_SWITCH_SUFFIX 36051
#define IDS_ACC_TAB_SWITCH_BUTTON_FOCUSED_PREFIX 36052
#define IDS_ACC_TAB_SWITCH_BUTTON 36053
#define IDS_ACC_MULTIPLE_ACTIONS_SUFFIX 36054
#define IDS_ACC_KEYWORD_SUFFIX 36055
#define IDS_ACC_KEYWORD_MODE 36056
#define IDS_ACC_ASK_KEYWORD_MODE 36057
#define IDS_ACC_KEYWORD_MODE_WITH_SHORTCUT 36058
#define IDS_ACC_ASK_KEYWORD_MODE_WITH_SHORTCUT 36059
#define IDS_ACC_THUMBS_UP_SUGGESTION_FOCUSED_PREFIX 36060
#define IDS_ACC_THUMBS_UP_SUGGESTION_BUTTON 36061
#define IDS_ACC_THUMBS_DOWN_SUGGESTION_FOCUSED_PREFIX 36062
#define IDS_ACC_THUMBS_DOWN_SUGGESTION_BUTTON 36063
#define IDS_ACC_REMOVE_SUGGESTION_SUFFIX 36064
#define IDS_ACC_REMOVE_SUGGESTION_FOCUSED_PREFIX 36065
#define IDS_ACC_REMOVE_SUGGESTION_BUTTON 36066
#define IDS_ACC_AI_MODE_PLACEHOLDER_TEXT 36067
#define IDS_ACC_AI_MODE_BUTTON_FOCUSED 36068
#define IDS_ACC_CHROME_TIP 36069
#define IDS_ACC_DISMISS_CHROME_TIP_SUFFIX 36070
#define IDS_ACC_DISMISS_CHROME_TIP_FOCUSED_PREFIX 36071
#define IDS_ACC_DISMISS_CHROME_TIP_BUTTON 36072
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_NAME 36073
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_KEYWORD 36074
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_NAME 36075
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_KEYWORD 36076
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_NAME 36077
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_KEYWORD 36078
#define IDS_SEARCH_ENGINES_STARTER_PACK_GEMINI_NAME 36079
#define IDS_SEARCH_ENGINES_STARTER_PACK_GEMINI_KEYWORD 36080
#define IDS_SEARCH_ENGINES_STARTER_PACK_PAGE_NAME 36081
#define IDS_SEARCH_ENGINES_STARTER_PACK_PAGE_KEYWORD 36082
#define IDS_SEARCH_ENGINES_STARTER_PACK_AI_MODE_NAME 36083
#define IDS_SEARCH_ENGINES_STARTER_PACK_AI_MODE_KEYWORD 36084
#define IDS_STARTER_PACK_PAGE_KEYWORD_TEXT 36085
#define IDS_STARTER_PACK_PAGE_EMPTY_QUERY_MATCH_TEXT 36086
#define IDS_OMNIBOX_INSTANT_KEYWORD_ASK_TEXT 36087
#define IDS_OMNIBOX_INSTANT_KEYWORD_SEARCH_TEXT 36088
#define IDS_OMNIBOX_SELECTED_KEYWORD_ASK_TEXT 36089
#define IDS_OMNIBOX_TAB_SEARCH_NO_RESULTS_FOUND 36090
#define IDS_OMNIBOX_GEMINI_IPH 36091
#define IDS_OMNIBOX_FEATURED_ENTERPRISE_SITE_SEARCH_IPH 36092
#define IDS_OMNIBOX_FEATURED_ENTERPRISE_SEARCH_AGGREGATOR_IPH 36093
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SETTINGS_PROMO_IPH 36094
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SETTINGS_PROMO_IPH_LINK_TEXT 36095
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_DISCLAIMER_IPH 36096
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_DISCLAIMER_IPH_LINK_TEXT 36097
#define IDS_ACC_OMNIBOX_IPH_LINK_SELECTED 36098
#define IDS_ACC_OMNIBOX_TOOLBELT_NEXT_SUFFIX 36099
#define IDS_OMNIBOX_HISTORY_SCOPE_PROMO_IPH 36100
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SCOPE_PROMO_IPH 36101
#define IDS_OMNIBOX_ONE_LINE_CALCULATOR_SUGGESTION_TEMPLATE 36102
#define IDS_OMNIBOX_HEADER_POPULAR_TOPICS 36103
#define IDS_OMNIBOX_BOOKMARKS_SCOPE_PLACEHOLDER_TEXT 36104
#define IDS_OMNIBOX_HISTORY_SCOPE_PLACEHOLDER_TEXT 36105
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SCOPE_PLACEHOLDER_TEXT 36106
#define IDS_OMNIBOX_TABS_SCOPE_PLACEHOLDER_TEXT 36107
#define IDS_OMNIBOX_GEMINI_SCOPE_PLACEHOLDER_TEXT 36108
#define IDS_OMNIBOX_PAGE_SCOPE_PLACEHOLDER_TEXT 36109
#define IDS_OMNIBOX_AI_MODE_SCOPE_PLACEHOLDER_TEXT 36110
#define IDS_OMNIBOX_HUB_OPEN_TABS_HEADER 36111
#define IDS_OMNIBOX_HUB_SEARCH_HEADER 36112
#define IDS_OMNIBOX_HUB_HISTORY_HEADER 36113
#define IDS_OMNIBOX_HUB_TYPED_MATCH_HEADER 36114
#define IDS_PAGE_INFO_SECURE_SUMMARY 36115
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY 36116
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY_SHORT 36117
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY 36118
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY_SHORT 36119
#define IDS_PAGE_INFO_SAFE_BROWSING_SUMMARY 36120
#define IDS_PAGE_INFO_EXTENSION_PAGE 36121
#define IDS_PAGE_INFO_VIEW_SOURCE_PAGE 36122
#define IDS_PAGE_INFO_DEVTOOLS_PAGE 36123
#define IDS_PAGE_INFO_READER_MODE_PAGE_SECURE 36124
#define IDS_PAGE_INFO_READER_MODE_PAGE 36125
#define IDS_PAGE_INFO_SAFETY_TIP_MORE_INFO_LINK 36126
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_LEAVE_BUTTON 36127
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_TITLE 36128
#define IDS_PAGE_INFO_SAFETY_TIP_DESCRIPTION 36129
#define IDS_PAGE_INFO_FILE_PAGE 36130
#define IDS_PAGE_INFO_SECURE_DETAILS 36131
#define IDS_PAGE_INFO_MIXED_CONTENT_DETAILS 36132
#define IDS_PAGE_INFO_LEGACY_TLS_DETAILS 36133
#define IDS_PAGE_INFO_NOT_SECURE_DETAILS 36134
#define IDS_PAGE_INFO_MALWARE_DETAILS 36135
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_DETAILS 36136
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_DETAILS 36137
#define IDS_PAGE_INFO_SECURITY_TAB_INSECURE_IDENTITY 36138
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SUMMARY 36139
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SAVED_PASSWORD_SUMMARY 36140
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SAVED 36141
#define IDS_PAGE_INFO_CHECK_PASSWORDS_BUTTON 36142
#define IDS_PAGE_INFO_INVALID_CERTIFICATE_DESCRIPTION 36143
#define IDS_PAGE_INFO_RESET_INVALID_CERTIFICATE_DECISIONS_BUTTON 36144
#define IDS_PAGE_INFO_HELP_CENTER_LINK 36145
#define IDS_PAGE_INFO_SECURITY_TAB_DEPRECATED_SIGNATURE_ALGORITHM 36146
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_CONNECTION_TEXT 36147
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_ERROR 36148
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_WARNING 36149
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_FORM_WARNING 36150
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_SENTENCE_LINK 36151
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS 36152
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS_AEAD 36153
#define IDS_PAGE_INFO_SECURITY_TAB_NOT_ENCRYPTED_CONNECTION_TEXT 36154
#define IDS_PAGE_INFO_SECURITY_TAB_SSL_VERSION 36155
#define IDS_PAGE_INFO_SECURITY_TAB_UNKNOWN_PARTY 36156
#define IDS_PAGE_INFO_SECURITY_TAB_WEAK_ENCRYPTION_CONNECTION_TEXT 36157
#define IDS_PAGE_INFO_CERT_INFO_BUTTON 36158
#define IDS_PAGE_INFO_ADDRESS 36159
#define IDS_PAGE_INFO_PARTIAL_ADDRESS 36160
#define IDS_PAGE_INFO_SECURITY_TAB_SECURE_IDENTITY_EV_VERIFIED 36161
#define IDS_PAGE_INFO_CERTIFICATE 36162
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK 36163
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK 36164
#define IDS_PAGE_INFO_CERTIFICATE_BUTTON_TEXT 36165
#define IDS_PAGE_INFO_CERTIFICATE_VALID_PARENTHESIZED 36166
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_PARENTHESIZED 36167
#define IDS_PAGE_INFO_CERTIFICATE_IS_VALID 36168
#define IDS_PAGE_INFO_CERTIFICATE_DETAILS 36169
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK_TOOLTIP 36170
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK_TOOLTIP 36171
#define IDS_PAGE_INFO_QWAC_STATUS_TITLE 36172
#define IDS_PAGE_INFO_COOKIES 36174
#define IDS_PAGE_INFO_COOKIES_BUTTON_TEXT 36175
#define IDS_PAGE_INFO_NUM_COOKIES_PARENTHESIZED 36176
#define IDS_PAGE_INFO_NUM_COOKIES 36177
#define IDS_PAGE_INFO_COOKIES_TOOLTIP 36178
#define IDS_PAGE_INFO_BUTTON_TEXT_AUTOMATIC_BY_DEFAULT 36179
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_DEFAULT 36180
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ALLOW 36181
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_BLOCK 36182
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ASK 36183
#define IDS_PAGE_INFO_MENU_ITEM_ALLOW 36184
#define IDS_PAGE_INFO_MENU_ITEM_BLOCK 36185
#define IDS_PAGE_INFO_MENU_ITEM_ASK 36186
#define IDS_PAGE_INFO_MENU_ITEM_ADS_BLOCK 36187
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED 36188
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_ONCE 36189
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED 36190
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_INCOGNITO 36191
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_GUEST 36192
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_INSECURE 36193
#define IDS_PAGE_INFO_STATE_TEXT_MUTED 36194
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_BY_DEFAULT 36195
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_BY_DEFAULT 36196
#define IDS_PAGE_INFO_SELECTOR_TOOLTIP 36197
#define IDS_PAGE_INFO_SELECTOR_STORAGE_ACCESS_TOOLTIP 36198
#define IDS_PAGE_INFO_STATE_TEXT_AR_ASK 36199
#define IDS_PAGE_INFO_STATE_TEXT_AUTO_PICTURE_IN_PICTURE_ASK 36200
#define IDS_PAGE_INFO_STATE_TEXT_AUTOMATIC_DOWNLOADS_ASK 36201
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_DEVICES_ASK 36202
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_ASK 36203
#define IDS_PAGE_INFO_STATE_TEXT_CAPTURED_SURFACE_CONTROL_ASK 36204
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_PAN_TILT_ZOOM_ASK 36205
#define IDS_PAGE_INFO_STATE_TEXT_CLIPBOARD_ASK 36206
#define IDS_PAGE_INFO_STATE_TEXT_FILE_SYSTEM_WRITE_ASK 36207
#define IDS_PAGE_INFO_STATE_TEXT_HAND_TRACKING_ASK 36208
#define IDS_PAGE_INFO_STATE_TEXT_HID_DEVICES_ASK 36209
#define IDS_PAGE_INFO_STATE_TEXT_KEYBOARD_LOCK_ASK 36210
#define IDS_PAGE_INFO_STATE_TEXT_LOCATION_ASK 36211
#define IDS_PAGE_INFO_STATE_TEXT_MIC_ASK 36212
#define IDS_PAGE_INFO_STATE_TEXT_MIDI_SYSEX_ASK 36213
#define IDS_PAGE_INFO_STATE_TEXT_NOTIFICATIONS_ASK 36214
#define IDS_PAGE_INFO_STATE_TEXT_POINTER_LOCK_ASK 36215
#define IDS_PAGE_INFO_STATE_TEXT_USB_ASK 36216
#define IDS_PAGE_INFO_STATE_TEXT_VR_ASK 36217
#define IDS_PAGE_INFO_STATE_TEXT_FONT_ACCESS_ASK 36218
#define IDS_PAGE_INFO_STATE_TEXT_SERIAL_ASK 36219
#define IDS_PAGE_INFO_STATE_TEXT_IDLE_DETECTION_ASK 36220
#define IDS_PAGE_INFO_STATE_TEXT_WINDOW_MANAGEMENT_ASK 36221
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_SCANNING_ASK 36222
#define IDS_PAGE_INFO_STATE_TEXT_STORAGE_ACCESS_ASK 36223
#define IDS_PAGE_INFO_STATE_TEXT_WEB_APP_INSTALLATION_ASK 36224
#define IDS_PAGE_INFO_STATE_TEXT_WEB_PRINTING_ASK 36225
#define IDS_PAGE_INFO_STATE_TEXT_LOCAL_NETWORK_ACCESS_ASK 36226
#define IDS_PAGE_INFO_USB_DEVICE_SECONDARY_LABEL 36227
#define IDS_PAGE_INFO_USB_DEVICE_ALLOWED_BY_POLICY_LABEL 36228
#define IDS_PAGE_INFO_DELETE_USB_DEVICE_WITH_NAME 36229
#define IDS_PAGE_INFO_SERIAL_PORT_SECONDARY_LABEL 36230
#define IDS_PAGE_INFO_SERIAL_PORT_ALLOWED_BY_POLICY_LABEL 36231
#define IDS_PAGE_INFO_DELETE_SERIAL_PORT_WITH_NAME 36232
#define IDS_PAGE_INFO_BLUETOOTH_DEVICE_SECONDARY_LABEL 36233
#define IDS_PAGE_INFO_DELETE_BLUETOOTH_DEVICE_WITH_NAME 36234
#define IDS_PAGE_INFO_HID_DEVICE_SECONDARY_LABEL 36235
#define IDS_PAGE_INFO_HID_DEVICE_ALLOWED_BY_POLICY_LABEL 36236
#define IDS_PAGE_INFO_DELETE_HID_DEVICE_WITH_NAME 36237
#define IDS_PAGE_INFO_SMART_CARD_READER_ALLOWED_BY_POLICY_LABEL 36238
#define IDS_PAGE_INFO_SMART_CARD_READER_SECONDARY_LABEL 36239
#define IDS_PAGE_INFO_DELETE_SMART_CARD_READER_WITH_NAME 36240
#define IDS_PAGE_INFO_SITE_SETTINGS_LINK 36241
#define IDS_PAGE_INFO_SITE_SETTINGS_TOOLTIP 36242
#define IDS_PAGE_INFO_CAMERA_SYSTEM_SETTINGS_DESCRIPTION 36245
#define IDS_PAGE_INFO_MICROPHONE_SYSTEM_SETTINGS_DESCRIPTION 36246
#define IDS_PAGE_INFO_LOCATION_SYSTEM_SETTINGS_DESCRIPTION 36247
#define IDS_PAGE_INFO_CLIPBOARD_SYSTEM_SETTINGS_DESCRIPTION 36248
#define IDS_PAGE_INFO_SETTINGS_OF_A_SYSTEM_LINK 36249
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_POLICY 36250
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_POLICY 36251
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_POLICY 36252
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_EXTENSION 36253
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_EXTENSION 36254
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_EXTENSION 36255
#define IDS_PAGE_INFO_PERMISSION_AUTOMATICALLY_BLOCKED 36256
#define IDS_PAGE_INFO_PERMISSION_ADS_SUBTITLE 36257
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_POLICY 36258
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_EXTENSION 36259
#define IDS_PAGE_INFO_INFOBAR_TEXT 36260
#define IDS_PAGE_INFO_INFOBAR_BUTTON 36261
#define IDS_PAGE_INFO_PERMISSION_USING_NOW 36262
#define IDS_PAGE_INFO_PERMISSION_RECENTLY_USED 36263
#define IDS_PAGE_INFO_PERMISSION_USED_TIME_AGO 36264
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS 36265
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SYNC 36266
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SIGNED_IN_NON_SYNC 36267
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE 36268
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE_WITH_ORG_NAME 36269
#define IDS_PAGE_INFO_CHANGE_PASSWORD_BUTTON 36270
#define IDS_PAGE_INFO_PROTECT_ACCOUNT_BUTTON 36271
#define IDS_PAGE_INFO_IGNORE_PASSWORD_WARNING_BUTTON 36272
#define IDS_PAGE_INFO_ALLOWLIST_PASSWORD_REUSE_BUTTON 36273
#define IDS_PAGE_INFO_BILLING_SUMMARY 36274
#define IDS_PAGE_INFO_BILLING_DETAILS 36275
#define IDS_PAGE_INFO_VR_PRESENTING_TEXT 36276
#define IDS_PAGE_INFO_VR_TURN_OFF_BUTTON_TEXT 36277
#define IDS_CERT_INFO_SUBJECT_GROUP 36278
#define IDS_CERT_INFO_ISSUER_GROUP 36279
#define IDS_CERT_INFO_COMMON_NAME_LABEL 36280
#define IDS_CERT_INFO_ORGANIZATION_LABEL 36281
#define IDS_CERT_INFO_ORGANIZATIONAL_UNIT_LABEL 36282
#define IDS_CERT_INFO_SERIAL_NUMBER_LABEL 36283
#define IDS_CERT_INFO_VALIDITY_GROUP 36284
#define IDS_CERT_INFO_ISSUED_ON_LABEL 36285
#define IDS_CERT_INFO_EXPIRES_ON_LABEL 36286
#define IDS_CERT_INFO_FINGERPRINTS_GROUP 36287
#define IDS_CERT_INFO_SHA256_FINGERPRINT_LABEL 36288
#define IDS_CERT_INFO_SHA256_SPKI_FINGERPRINT_LABEL 36289
#define IDS_CERT_DETAILS_EXTENSIONS 36290
#define IDS_CERT_X509_SUBJECT_ALT_NAME 36291
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_BUTTON 36292
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_HEADER 36293
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_BUTTON_TOOLTIP 36294
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON 36295
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON_TOOLTIP 36296
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_REMEMBER_THIS_SETTING 36297
#define IDS_PAGE_INFO_RESET_PERMISSIONS 36298
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_HEADER 36299
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TITLE 36300
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_DESCRIPTION_PLACEHOLDER 36301
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_TOOLTIP 36302
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TOOLTIP 36303
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_SUBPAGE_FROM_LABEL 36304
#define IDS_PAGE_INFO_COOKIES_HEADER 36305
#define IDS_PAGE_INFO_COOKIES_DESCRIPTION 36306
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_GRANT_DESCRIPTION 36307
#define IDS_PAGE_INFO_TRACKING_PROTECTION_DESCRIPTION 36308
#define IDS_PAGE_INFO_TRACKING_PROTECTION_BLOCKED_COOKIES_DESCRIPTION 36309
#define IDS_PAGE_INFO_TRACKING_PROTECTION_INCOGNITO_BLOCKED_COOKIES_DESCRIPTION 36310
#define IDS_PAGE_INFO_COOKIES_SETTINGS_LINK 36311
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SETTINGS_LINK 36312
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TITLE 36313
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TOGGLE_TOOLTIP 36314
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_MANAGED_BY_SETTINGS_TOOLTIP 36315
#define IDS_PAGE_INFO_COOKIES_ALLOWED_SITES_COUNT 36316
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TITLE 36317
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TOOLTIP 36318
#define IDS_PAGE_INFO_RWS_BUTTON_TOOLTIP 36319
#define IDS_PAGE_INFO_RWS_BUTTON_TITLE 36320
#define IDS_PAGE_INFO_RWS_BUTTON_SUBTITLE 36321
#define IDS_PAGE_INFO_COOKIES_SITE_NOT_WORKING_TITLE 36322
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_NOT_WORKING_DESCRIPTION_TEMPORARY 36323
#define IDS_PAGE_INFO_COOKIES_THIRD_PARTY_COOKIES_LABEL 36324
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_LIMITED_RESTART_TITLE 36325
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_BLOCKED_RESTART_TITLE 36326
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_RESTART_DESCRIPTION 36327
#define IDS_PAGE_INFO_TRACKING_PROTECTION_PERMANENT_ALLOWED_TITLE 36328
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_PERMANENT_ALLOWED_DESCRIPTION 36329
#define IDS_PAGE_INFO_COOKIE_SYNC_DESCRIPTION 36330
#define IDS_PAGE_INFO_SYNC_SETTINGS_LINK 36331
#define IDS_MERCHANT_TRUST_SIDE_PANEL_TITLE 36332
#define IDS_PAGE_INFO_MERCHANT_TRUST_HEADER 36333
#define IDS_PAGE_INFO_MERCHANT_TRUST_DESCRIPTION 36334
#define IDS_PAGE_INFO_MERCHANT_TRUST_VIEW_ALL_REVIEWS 36335
#define IDS_PAGE_INFO_MERCHANT_TRUST_STAR_RATING_AND_COUNT_A11Y_DESCRIPTION 36336
#define IDS_PAGE_INFO_MERCHANT_TRUST_STAR_RATING_A11Y_DESCRIPTION 36337
#define IDS_PAGE_INFO_MERCHANT_TRUST_REVIEWS_SUMMARY_TITLE 36338
#define IDS_PAGE_INFO_MERCHANT_TRUST_HATS_BUTTON 36339
#define IDS_PAGE_INFO_MERCHANT_TRUST_HATS_LOADING_BUTTON 36340
#define IDS_PAGE_INFO_MERCHANT_TRUST_HATS_FAILED_BUTTON 36341
#define IDS_PAGE_INFO_HISTORY 36342
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_TODAY 36343
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_YESTERDAY 36344
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DAYS 36345
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DATE 36346
#define IDS_PAGE_INFO_ENTERPRISE_WARN_SUMMARY 36347
#define IDS_PAGE_INFO_ENTERPRISE_WARN_DETAILS 36348
#define IDS_PAGE_INFO_ENTERPRISE_BLOCK_SUMMARY 36349
#define IDS_PAGE_INFO_ENTERPRISE_BLOCK_DETAILS 36350
#define IDS_PAGE_INFO_AD_PRIVACY_HEADER 36351
#define IDS_PAGE_INFO_AD_PRIVACY_TOOLTIP 36352
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_DESCRIPTION 36353
#define IDS_PAGE_INFO_AD_PRIVACY_FLEDGE_DESCRIPTION 36354
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_AND_FLEDGE_DESCRIPTION 36355
#define IDS_PAGE_INFO_AD_PRIVACY_SUBPAGE_MANAGE_BUTTON 36356
#define IDS_PAINT_PREVIEW_COMPOSITOR_SERVICE_DISPLAY_NAME 36357
#define IDS_LEAK_CHECK_CREDENTIALS 36358
#define IDS_CREDENTIAL_LEAK_TITLE_CHANGE 36359
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK_GPM 36360
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 36361
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_BRANDED 36362
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 36363
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 36364
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_NON_BRANDED 36365
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 36366
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE 36368
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE 36369
#define IDS_PASSWORD_MANAGER_EMPTY_LOGIN 36370
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS 36371
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_AND_PASSKEYS 36372
#define IDS_PASSWORD_MANAGER_GENERATE_PASSWORD 36373
#define IDS_PASSWORD_MANAGER_SHOW_PASSWORDS_TAB_TITLE 36374
#define IDS_PASSWORD_MANAGER_DEFAULT_EXPORT_FILENAME 36375
#define IDS_PASSWORD_MANAGER_PASSWORD_FOR_ACCOUNT 36376
#define IDS_PASSWORD_MANAGER_USE_SCREEN_LOCK 36377
#define IDS_PASSWORD_MANAGER_PASSKEY 36378
#define IDS_PASSWORD_MANAGER_USE_GENERIC_DEVICE 36379
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_CHROME_PROFILE 36380
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_ICLOUD_KEYCHAIN 36381
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_GOOGLE_PASSWORD_MANAGER 36382
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_WINDOWS_HELLO 36383
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_PHONE 36384
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_PROVIDER 36385
#define IDS_PASSWORD_MANAGER_PASSWORD_FROM_GOOGLE_PASSWORD_MANAGER 36386
#define IDS_PASSWORD_MANAGER_USE_DIFFERENT_PASSKEY 36387
#define IDS_PASSWORD_MANAGER_USE_PASSKEY 36388
#define IDS_PASSWORD_MANAGER_FILLING_REAUTH 36389
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_TITLE_WIN 36397
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_MESSAGE_WIN 36398
#define IDS_PASSWORD_MANAGER_TURN_ON_FILLING_REAUTH_WIN 36399
#define IDS_PASSWORD_MANAGER_TURN_OFF_FILLING_REAUTH_WIN 36400
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_CONFIRMATION_TITLE_WIN 36401
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_CONFIRMATION_DESCRIPTION_WIN 36402
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_ACCEPT_BUTTON 36417
#define IDS_PASSWORD_MANAGER_SETTINGS 36418
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_CANCEL_BUTTON 36419
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_FOOTER_MOVE_PASSWORD 36424
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LINK_TEXT_MOVE_PASSWORD 36425
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_SUGGESTED_PASSWORDS_SECTION_TITLE 36426
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_ALL_PASSWORDS_SECTION_TITLE 36427
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_FILL_PASSWORD_ENTRY 36428
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_VIEW_DETAILS_ENTRY 36429
#define IDS_PASSWORD_MANAGER_PENDING_STATE 36430
#define IDS_PASSWORD_MANAGER_UI_TROUBLE_SIGNING_IN 36431
#define IDS_PASSWORD_MANAGER_UI_PROACTIVE_RECOVERY_SUGGESTION 36432
#define IDS_PASSWORD_MANAGER_UI_PROACTIVE_RECOVERY_FOOTER_BRANDED 36433
#define IDS_PASSWORD_MANAGER_UI_PROACTIVE_RECOVERY_FOOTER_NON_BRANDED 36434
#define IDS_PASSWORD_MANAGER_UI_BACKUP_PASSWORD_TAG 36435
#define IDS_PAYMENTS_TITLE 36436
#define IDS_PAYMENTS_ERROR_MESSAGE_DIALOG_TITLE 36437
#define IDS_PAYMENTS_METHOD_OF_PAYMENT_LABEL 36438
#define IDS_PAYMENTS_CONTACT_DETAILS_LABEL 36439
#define IDS_PAYMENTS_ADD_CONTACT_DETAILS_LABEL 36440
#define IDS_PAYMENTS_EDIT_CONTACT_DETAILS_LABEL 36441
#define IDS_PAYMENTS_ADD_MORE_INFORMATION 36442
#define IDS_PAYMENTS_ADD_PHONE_NUMBER 36443
#define IDS_PAYMENTS_ADD_RECIPIENT 36444
#define IDS_PAYMENTS_ADD_VALID_ADDRESS 36445
#define IDS_PAYMENTS_ADD_EMAIL 36446
#define IDS_PAYMENTS_ADD_NAME 36447
#define IDS_PAYMENTS_ORDER_SUMMARY_LABEL 36448
#define IDS_PAYMENT_REQUEST_PAYMENT_METHOD_SECTION_NAME 36449
#define IDS_PAYMENT_REQUEST_CONTACT_INFO_SECTION_NAME 36450
#define IDS_PAYMENTS_SHIPPING_SUMMARY_LABEL 36451
#define IDS_PAYMENTS_SHIPPING_ADDRESS_LABEL 36452
#define IDS_PAYMENTS_SHIPPING_OPTION_LABEL 36453
#define IDS_PAYMENTS_DELIVERY_SUMMARY_LABEL 36454
#define IDS_PAYMENTS_DELIVERY_ADDRESS_LABEL 36455
#define IDS_PAYMENTS_DELIVERY_OPTION_LABEL 36456
#define IDS_PAYMENTS_PICKUP_SUMMARY_LABEL 36457
#define IDS_PAYMENTS_PICKUP_ADDRESS_LABEL 36458
#define IDS_PAYMENTS_PICKUP_OPTION_LABEL 36459
#define IDS_PAYMENTS_EDIT_BUTTON 36460
#define IDS_PAYMENTS_PAY_BUTTON 36461
#define IDS_PAYMENTS_CONTINUE_BUTTON 36462
#define IDS_PAYMENTS_ADD_CONTACT 36463
#define IDS_PAYMENTS_ADD_CARD 36464
#define IDS_PAYMENTS_ADD_ADDRESS 36465
#define IDS_PAYMENTS_EDIT_ADDRESS 36466
#define IDS_PAYMENTS_CANCEL_PAYMENT 36467
#define IDS_PAYMENTS_CONFIRM_BUTTON 36468
#define IDS_PAYMENTS_NAME_FIELD_IN_CONTACT_DETAILS 36469
#define IDS_PAYMENTS_PHONE_FIELD_IN_CONTACT_DETAILS 36470
#define IDS_PAYMENTS_EMAIL_FIELD_IN_CONTACT_DETAILS 36471
#define IDS_PAYMENTS_LOADING_MESSAGE 36472
#define IDS_PAYMENTS_PROCESSING_MESSAGE 36473
#define IDS_PAYMENTS_CHECKING_OPTION 36474
#define IDS_PAYMENTS_UPDATED_LABEL 36475
#define IDS_PAYMENTS_ERROR_MESSAGE 36476
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS 36477
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_IN 36478
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_OUT 36479
#define IDS_SETTINGS_CAN_MAKE_PAYMENT_TOGGLE_LABEL 36480
#define IDS_PAYMENTS_REQUIRED_FIELD_MESSAGE 36481
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRED 36482
#define IDS_PAYMENTS_VALIDATION_UNSUPPORTED_CREDIT_CARD_TYPE 36483
#define IDS_PAYMENTS_PHONE_INVALID_VALIDATION_MESSAGE 36484
#define IDS_PAYMENTS_EMAIL_INVALID_VALIDATION_MESSAGE 36485
#define IDS_PAYMENTS_CARD_NUMBER_INVALID_VALIDATION_MESSAGE 36486
#define IDS_PAYMENTS_INVALID_ADDRESS 36487
#define IDS_PAYMENTS_BILLING_ADDRESS_REQUIRED 36488
#define IDS_PAYMENTS_MORE_INFORMATION_REQUIRED 36489
#define IDS_PAYMENTS_PHONE_NUMBER_REQUIRED 36490
#define IDS_PAYMENTS_RECIPIENT_REQUIRED 36491
#define IDS_PAYMENTS_EMAIL_REQUIRED 36492
#define IDS_PAYMENTS_NAME_REQUIRED 36493
#define IDS_PREF_EDIT_DIALOG_FIELD_REQUIRED_VALIDATION_MESSAGE 36494
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SECTION_TOTAL_FORMAT 36495
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SHEET_TOTAL_FORMAT 36496
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MORE_ITEMS 36497
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MULTIPLE_CURRENCY_INDICATOR 36498
#define IDS_PAYMENTS_SELECT_SHIPPING_ADDRESS_FOR_SHIPPING_METHODS 36499
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_ADDRESS 36500
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_OPTION 36501
#define IDS_PAYMENTS_SELECT_DELIVERY_ADDRESS_FOR_DELIVERY_METHODS 36502
#define IDS_PAYMENTS_UNSUPPORTED_DELIVERY_ADDRESS 36503
#define IDS_PAYMENTS_SELECT_PICKUP_ADDRESS_FOR_PICKUP_METHODS 36504
#define IDS_PAYMENTS_UNSUPPORTED_PICKUP_ADDRESS 36505
#define IDS_PAYMENTS_ANDROID_APP_ERROR 36506
#define IDS_PAYMENT_REQUEST_PAYMENT_METHODS_PREVIEW 36508
#define IDS_PAYMENT_REQUEST_SHIPPING_ADDRESSES_PREVIEW 36509
#define IDS_PAYMENT_REQUEST_SHIPPING_OPTIONS_PREVIEW 36510
#define IDS_PAYMENT_REQUEST_CONTACTS_PREVIEW 36511
#define IDS_PAYMENTS_BACK 36512
#define IDS_PAYMENTS_CLOSE 36513
#define IDS_PAYMENTS_EDIT 36514
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_FORMAT 36515
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_SELECTED_FORMAT 36516
#define IDS_PAYMENTS_PROFILE_LABELS_ACCESSIBLE_FORMAT 36517
#define IDS_PAYMENTS_ACCESSIBLE_LABEL_WITH_ERROR 36518
#define IDS_PAYMENTS_ORDER_SUMMARY_ACCESSIBLE_LABEL 36519
#define IDS_PAYMENTS_ITEM_ICON 36520
#define IDS_PAYMENT_HANDLER_SHEET_DESCRIPTION 36521
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_HALF 36522
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_FULL 36523
#define IDS_PAYMENT_HANDLER_SHEET_CLOSED 36524
#define IDS_PAYMENT_HANDLER_ICON 36525
#define IDS_SECURE_PAYMENT_CONFIRMATION_INLINE_TITLE 36526
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_PURCHASE 36527
#define IDS_SECURE_PAYMENT_CONFIRMATION_INLINE_DESCRIPTION 36530
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LABEL 36531
#define IDS_SECURE_PAYMENT_CONFIRMATION_STORE_LABEL 36534
#define IDS_SECURE_PAYMENT_CONFIRMATION_TOTAL_LABEL 36535
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_BUTTON_LABEL 36536
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LINK_LABEL 36537
#define IDS_NO_MATCHING_CREDENTIAL_DESCRIPTION 36538
#define IDS_PDF_DOWNLOAD_ORIGINAL 36548
#define IDS_PDF_DOWNLOAD_EDITED 36549
#define IDS_PDF_PRESENT 36550
#define IDS_PDF_NEED_PASSWORD 36551
#define IDS_PDF_PASSWORD_DIALOG_TITLE 36552
#define IDS_PDF_PASSWORD_SUBMIT 36553
#define IDS_PDF_PASSWORD_INVALID 36554
#define IDS_PDF_SIDEBAR_LABEL 36555
#define IDS_PDF_PAGE_LOADING 36556
#define IDS_PDF_ERROR_DIALOG_TITLE 36557
#define IDS_PDF_PAGE_LOAD_FAILED 36558
#define IDS_PDF_PAGE_RELOAD_BUTTON 36559
#define IDS_PDF_BOOKMARKS 36560
#define IDS_PDF_BOOKMARK_EXPAND_ICON_ARIA_LABEL 36561
#define IDS_PDF_PROPERTIES_DIALOG_TITLE 36562
#define IDS_PDF_PROPERTIES_FILE_NAME 36563
#define IDS_PDF_PROPERTIES_FILE_SIZE 36564
#define IDS_PDF_PROPERTIES_TITLE 36565
#define IDS_PDF_PROPERTIES_AUTHOR 36566
#define IDS_PDF_PROPERTIES_SUBJECT 36567
#define IDS_PDF_PROPERTIES_KEYWORDS 36568
#define IDS_PDF_PROPERTIES_CREATED 36569
#define IDS_PDF_PROPERTIES_MODIFIED 36570
#define IDS_PDF_PROPERTIES_APPLICATION 36571
#define IDS_PDF_PROPERTIES_PDF_PRODUCER 36572
#define IDS_PDF_PROPERTIES_PDF_VERSION 36573
#define IDS_PDF_PROPERTIES_PAGE_COUNT 36574
#define IDS_PDF_PROPERTIES_PAGE_SIZE 36575
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_INCH 36576
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_MM 36577
#define IDS_PDF_PROPERTIES_PAGE_SIZE_PORTRAIT 36578
#define IDS_PDF_PROPERTIES_PAGE_SIZE_LANDSCAPE 36579
#define IDS_PDF_PROPERTIES_PAGE_SIZE_SQUARE 36580
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VARIABLE 36581
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW 36582
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_NO 36583
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_YES 36584
#define IDS_PDF_TOOLTIP_ROTATE_CCW 36585
#define IDS_PDF_ROTATION_STATE_LABEL_0 36586
#define IDS_PDF_ROTATION_STATE_LABEL_90 36587
#define IDS_PDF_ROTATION_STATE_LABEL_180 36588
#define IDS_PDF_ROTATION_STATE_LABEL_270 36589
#define IDS_PDF_TOOLTIP_DOWNLOAD 36590
#define IDS_PDF_TOOLTIP_PRINT 36591
#define IDS_PDF_TOOLTIP_FIT_PAGE 36592
#define IDS_PDF_TOOLTIP_FIT_WIDTH 36593
#define IDS_PDF_TWO_UP_VIEW_ENABLE 36594
#define IDS_PDF_ANNOTATIONS_SHOW_TOGGLE 36595
#define IDS_PDF_ZOOM_TEXT_INPUT_ARIA_LABEL 36596
#define IDS_PDF_TOOLTIP_ZOOM_IN 36597
#define IDS_PDF_TOOLTIP_ZOOM_OUT 36598
#define IDS_PDF_TOOLTIP_THUMBNAILS 36599
#define IDS_PDF_TOOLTIP_DOCUMENT_OUTLINE 36600
#define IDS_PDF_TOOLTIP_ATTACHMENTS 36601
#define IDS_PDF_TOOLTIP_DOWNLOAD_ATTACHMENT 36602
#define IDS_PDF_LABEL_PAGE_NUMBER 36603
#define IDS_PDF_LOADING_TO_A11Y_TREE 36604
#define IDS_PDF_LOADED_TO_A11Y_TREE 36605
#define IDS_PDF_OVERSIZE_ATTACHMENT_WARNING 36606
#define IDS_PDF_PAGE_INDEX 36607
#define IDS_PDF_DOCUMENT_PAGE_COUNT 36608
#define IDS_PDF_THUMBNAIL_PAGE_ARIA_LABEL 36609
#define IDS_PDF_ANNOTATION_PEN 36610
#define IDS_PDF_ANNOTATION_HIGHLIGHTER 36611
#define IDS_PDF_ANNOTATION_ERASER 36612
#define IDS_PDF_ANNOTATION_UNDO 36613
#define IDS_PDF_ANNOTATION_REDO 36614
#define IDS_PDF_ANNOTATION_COLOR_BLACK 36615
#define IDS_PDF_ANNOTATION_COLOR_RED 36616
#define IDS_PDF_ANNOTATION_COLOR_YELLOW 36617
#define IDS_PDF_ANNOTATION_COLOR_GREEN 36618
#define IDS_PDF_ANNOTATION_COLOR_WHITE 36619
#define IDS_PDF_ANNOTATION_COLOR_ORANGE 36620
#define IDS_PDF_ANNOTATION_COLOR_BLUE 36621
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_GREY 36622
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_ORANGE 36623
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_GREEN 36624
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_BLUE 36625
#define IDS_PDF_INK2_DRAW 36626
#define IDS_PDF_INK2_ANNOTATION_TOOL 36627
#define IDS_PDF_INK2_ANNOTATION_SIZE 36628
#define IDS_PDF_INK2_ANNOTATION_COLOR 36629
#define IDS_PDF_INK2_ANNOTATION_SIZE_EXTRA_THIN 36630
#define IDS_PDF_INK2_ANNOTATION_SIZE_THIN 36631
#define IDS_PDF_INK2_ANNOTATION_SIZE_MEDIUM 36632
#define IDS_PDF_INK2_ANNOTATION_SIZE_THICK 36633
#define IDS_PDF_INK2_ANNOTATION_SIZE_EXTRA_THICK 36634
#define IDS_PDF_INK2_ANNOTATION_COLOR_LIGHT_RED 36635
#define IDS_PDF_INK2_ANNOTATION_COLOR_LIGHT_YELLOW 36636
#define IDS_PDF_INK2_ANNOTATION_COLOR_DARK_GREY_1 36637
#define IDS_PDF_INK2_ANNOTATION_COLOR_DARK_GREY_2 36638
#define IDS_PDF_INK2_ANNOTATION_COLOR_RED_1 36639
#define IDS_PDF_INK2_ANNOTATION_COLOR_YELLOW_1 36640
#define IDS_PDF_INK2_ANNOTATION_COLOR_GREEN_1 36641
#define IDS_PDF_INK2_ANNOTATION_COLOR_CYAN_1 36642
#define IDS_PDF_INK2_ANNOTATION_COLOR_BLUE_1 36643
#define IDS_PDF_INK2_ANNOTATION_COLOR_TAN_1 36644
#define IDS_PDF_INK2_ANNOTATION_COLOR_RED_2 36645
#define IDS_PDF_INK2_ANNOTATION_COLOR_YELLOW_2 36646
#define IDS_PDF_INK2_ANNOTATION_COLOR_GREEN_2 36647
#define IDS_PDF_INK2_ANNOTATION_COLOR_CYAN_2 36648
#define IDS_PDF_INK2_ANNOTATION_COLOR_BLUE_2 36649
#define IDS_PDF_INK2_ANNOTATION_COLOR_TAN_2 36650
#define IDS_PDF_INK2_ANNOTATION_COLOR_RED_3 36651
#define IDS_PDF_INK2_ANNOTATION_COLOR_YELLOW_3 36652
#define IDS_PDF_INK2_ANNOTATION_COLOR_GREEN_3 36653
#define IDS_PDF_INK2_ANNOTATION_COLOR_CYAN_3 36654
#define IDS_PDF_INK2_ANNOTATION_COLOR_BLUE_3 36655
#define IDS_PDF_INK2_ANNOTATION_COLOR_TAN_3 36656
#define IDS_PDF_INK2_TEXT_ANNOTATION 36657
#define IDS_PDF_INK2_TEXT_FONT 36658
#define IDS_PDF_INK2_TEXT_FONT_SANS_SERIF 36659
#define IDS_PDF_INK2_TEXT_FONT_SERIF 36660
#define IDS_PDF_INK2_TEXT_FONT_MONOSPACE 36661
#define IDS_PDF_INK2_TEXT_FONT_SIZE 36662
#define IDS_PDF_INK2_TEXT_STYLES 36663
#define IDS_PDF_INK2_TEXT_STYLE_BOLD 36664
#define IDS_PDF_INK2_TEXT_STYLE_ITALIC 36665
#define IDS_PDF_INK2_TEXT_ALIGNMENT 36666
#define IDS_PDF_INK2_TEXT_ALIGN_LEFT 36667
#define IDS_PDF_INK2_TEXT_ALIGN_CENTER 36668
#define IDS_PDF_INK2_TEXT_ALIGN_RIGHT 36669
#define IDS_PDF_INK2_TEXT_COLOR 36670
#define IDS_AX_ROLE_DESCRIPTION_PDF_HIGHLIGHT 36671
#define IDS_AX_ROLE_DESCRIPTION_PDF_POPUP_NOTE 36672
#define IDS_PDF_TOOLTIP_SAVE_TO_DRIVE 36673
#define IDS_SAVE_TO_DRIVE_DIALOG_CANCEL_UPLOAD_BUTTON_LABEL 36674
#define IDS_SAVE_TO_DRIVE_DIALOG_CONNECTION_ERROR_MESSAGE 36675
#define IDS_SAVE_TO_DRIVE_DIALOG_ERROR_TITLE 36676
#define IDS_SAVE_TO_DRIVE_DIALOG_MANAGE_STORAGE_BUTTON_LABEL 36677
#define IDS_SAVE_TO_DRIVE_DIALOG_OPEN_IN_DRIVE_BUTTON_LABEL 36678
#define IDS_SAVE_TO_DRIVE_DIALOG_RETRY_BUTTON_LABEL 36679
#define IDS_SAVE_TO_DRIVE_DIALOG_SESSION_TIMEOUT_ERROR_MESSAGE 36680
#define IDS_SAVE_TO_DRIVE_DIALOG_STORAGE_FULL_ERROR_MESSAGE 36681
#define IDS_SAVE_TO_DRIVE_DIALOG_SUCCESS_MESSAGE 36682
#define IDS_SAVE_TO_DRIVE_DIALOG_SUCCESS_TITLE 36683
#define IDS_SAVE_TO_DRIVE_DIALOG_UNKNOWN_ERROR_MESSAGE 36684
#define IDS_SAVE_TO_DRIVE_DIALOG_UPLOAD_STATUS_DONE 36685
#define IDS_SAVE_TO_DRIVE_DIALOG_UPLOAD_STATUS_WITH_SEPARATOR 36686
#define IDS_SAVE_TO_DRIVE_DIALOG_UPLOADING_TITLE 36687
#define IDS_PDF_OCR_FEATURE_ALERT 36688
#define IDS_PDF_OCR_IN_PROGRESS 36689
#define IDS_PDF_OCR_COMPLETED 36690
#define IDS_PDF_OCR_NO_RESULT 36691
#define IDS_PDF_OCR_POSTAMBLE_PAGE 36692
#define IDS_PDF_SEARCHIFY_IN_PROGRESS 36693
#define IDS_GEOLOCATION_INFOBAR_TEXT 36694
#define IDS_PROTECTED_MEDIA_IDENTIFIER_PERMISSION_FRAGMENT 36725
#define IDS_PROTECTED_MEDIA_IDENTIFIER_PER_ORIGIN_PROVISIONING_INFOBAR_TEXT 36726
#define IDS_GEOLOCATION_INFOBAR_PERMISSION_FRAGMENT 36727
#define IDS_NOTIFICATION_PERMISSIONS_FRAGMENT 36728
#define IDS_MIDI_SYSEX_PERMISSION_FRAGMENT 36729
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT 36730
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT_WITH_COUNT 36731
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT 36732
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT_WITH_COUNT 36733
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT 36734
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT_WITH_COUNT 36735
#define IDS_ACCESSIBILITY_EVENTS_PERMISSION_FRAGMENT 36736
#define IDS_CLIPBOARD_PERMISSION_FRAGMENT 36737
#define IDS_VR_PERMISSION_FRAGMENT 36738
#define IDS_AR_PERMISSION_FRAGMENT 36739
#define IDS_HAND_TRACKING_PERMISSION_FRAGMENT 36740
#define IDS_KEYBOARD_LOCK_PERMISSIONS_FRAGMENT 36741
#define IDS_POINTER_LOCK_PERMISSIONS_FRAGMENT 36742
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_PROMPT_TITLE 36743
#define IDS_STORAGE_ACCESS_PERMISSION_FRAGMENT 36744
#define IDS_STORAGE_ACCESS_PERMISSION_EXPLANATION 36745
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_EXPLANATION 36746
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_LINK 36747
#define IDS_WINDOW_MANAGEMENT_PERMISSION_FRAGMENT 36748
#define IDS_FONT_ACCESS_PERMISSION_FRAGMENT 36749
#define IDS_IDLE_DETECTION_PERMISSION_FRAGMENT 36750
#define IDS_IDENTITY_PROVIDER_PERMISSION_FRAGMENT 36751
#define IDS_MULTI_DOWNLOAD_PERMISSION_FRAGMENT 36752
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_FRAGMENT 36753
#define IDS_WEB_APP_INSTALLATION_PERMISSION_FRAGMENT 36754
#define IDS_LOCAL_NETWORK_ACCESS_PERMISSION_FRAGMENT 36755
#define IDS_PERMISSION_ALLOW 36756
#define IDS_PERMISSION_DENY 36757
#define IDS_PERMISSION_ALLOW_THIS_TIME 36758
#define IDS_PERMISSION_ALLOW_EVERY_VISIT 36759
#define IDS_PERMISSION_ALLOW_WHILE_VISITING 36760
#define IDS_PERMISSION_DONT_ALLOW 36761
#define IDS_PERMISSION_NEVER_ALLOW 36762
#define IDS_PERMISSION_ALLOW_APPROXIMATE_GEO 36763
#define IDS_PERMISSION_ALLOW_PRECISE_GEO 36764
#define IDS_PERMISSION_ALLOW_PRECISE_GEO_DESCRIPTION 36765
#define IDS_PERMISSION_ALLOW_APPROXIMATE_GEO_DESCRIPTION 36766
#define IDS_PERMISSION_ALLOW_PRECISE_GEO_LONG_DESCRIPTION 36767
#define IDS_PERMISSION_ALLOW_APPROXIMATE_GEO_LONG_DESCRIPTION 36768
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PROMPT 36769
#define IDS_BLUETOOTH_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 36770
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PAIR_BUTTON_TEXT 36771
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL 36772
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL_TOOLTIP 36773
#define IDS_BLUETOOTH_DEVICE_CHOOSER_ADAPTER_OFF 36774
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 36775
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 36776
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_WITH_ID 36777
#define IDS_BLUETOOTH_SCANNING_PROMPT 36778
#define IDS_BLUETOOTH_SCANNING_DEVICE_UNKNOWN 36779
#define IDS_BLUETOOTH_SCANNING_PROMPT_NO_DEVICES_FOUND_PROMPT 36780
#define IDS_BLUETOOTH_SCANNING_PROMPT_ALLOW_BUTTON_TEXT 36781
#define IDS_BLUETOOTH_SCANNING_PROMPT_BLOCK_BUTTON_TEXT 36782
#define IDS_DEVICE_CHOOSER_CANCEL_BUTTON_TEXT 36783
#define IDS_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 36784
#define IDS_USB_DEVICE_CHOOSER_PROMPT 36785
#define IDS_USB_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 36786
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL 36787
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL_TOOLTIP 36788
#define IDS_GEOLOCATION_PERMISSION_CHIP 36789
#define IDS_NOTIFICATION_PERMISSIONS_CHIP 36790
#define IDS_MIDI_SYSEX_PERMISSION_CHIP 36791
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_CHIP 36792
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_CHIP 36793
#define IDS_MEDIA_CAPTURE_VIDEO_AND_AUDIO_PERMISSION_CHIP 36794
#define IDS_CLIPBOARD_PERMISSION_CHIP 36795
#define IDS_SAA_PERMISSION_CHIP 36796
#define IDS_IDLE_DETECTION_PERMISSION_CHIP 36797
#define IDS_KEYBOARD_LOCK_PERMISSION_CHIP 36798
#define IDS_KEYBOARD_AND_POINTER_LOCK_PERMISSION_CHIP 36799
#define IDS_POINTER_LOCK_PERMISSION_CHIP 36800
#define IDS_WEB_APP_INSTALLATION_PERMISSION_CHIP 36801
#define IDS_AR_PERMISSION_CHIP 36802
#define IDS_PERMISSIONS_AR_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36803
#define IDS_PERMISSIONS_AR_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36804
#define IDS_PERMISSIONS_AR_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36805
#define IDS_VR_PERMISSION_CHIP 36806
#define IDS_PERMISSIONS_VR_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36807
#define IDS_PERMISSIONS_VR_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36808
#define IDS_PERMISSIONS_VR_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36809
#define IDS_HAND_TRACKING_PERMISSION_CHIP 36810
#define IDS_HAND_TRACKING_PERMISSION_BLOCKED_CHIP 36811
#define IDS_PERMISSIONS_HAND_TRACKING_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36812
#define IDS_PERMISSIONS_HAND_TRACKING_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36813
#define IDS_PERMISSIONS_HAND_TRACKING_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36814
#define IDS_GEOLOCATION_PERMISSION_BLOCKED_CHIP 36815
#define IDS_NOTIFICATION_PERMISSIONS_BLOCKED_CHIP 36816
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_CHIP 36817
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_BLOCKED_CHIP 36818
#define IDS_PERMISSIONS_CAPTURED_SURFACE_CONTROL_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36819
#define IDS_PERMISSIONS_CAPTURED_SURFACE_CONTROL_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36820
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_CONFIRMATION 36821
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_ONCE_CONFIRMATION 36822
#define IDS_PERMISSIONS_PERMISSION_NOT_ALLOWED_CONFIRMATION 36823
#define IDS_PERMISSIONS_NOTIFICATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36824
#define IDS_PERMISSIONS_NOTIFICATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36825
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36826
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36827
#define IDS_PERMISSIONS_GEOLOCATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36828
#define IDS_PERMISSIONS_CAMERA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36829
#define IDS_PERMISSIONS_CAMERA_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36830
#define IDS_PERMISSIONS_CAMERA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36831
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36832
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36833
#define IDS_PERMISSIONS_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36834
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36835
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36836
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36837
#define IDS_PERMISSIONS_SAA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36838
#define IDS_PERMISSIONS_SAA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36839
#define IDS_PERMISSIONS_KEYBOARD_LOCK_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36840
#define IDS_PERMISSIONS_KEYBOARD_LOCK_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36841
#define IDS_PERMISSIONS_POINTER_LOCK_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36842
#define IDS_PERMISSIONS_POINTER_LOCK_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36843
#define IDS_PERMISSIONS_WEB_INSTALL_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36844
#define IDS_PERMISSIONS_WEB_INSTALL_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 36845
#define IDS_REQUEST_QUOTA_INFOBAR_TEXT 36849
#define IDS_REQUEST_LARGE_QUOTA_INFOBAR_TEXT 36850
#define IDS_REQUEST_QUOTA_PERMISSION_FRAGMENT 36851
#define IDS_EMBEDDED_PROMPT_ADMIN_BLOCKED 36852
#define IDS_EMBEDDED_PROMPT_ADMIN_ALLOWED 36853
#define IDS_EMBEDDED_PROMPT_PREVIOUSLY_ALLOWED 36854
#define IDS_EMBEDDED_PROMPT_PREVIOUSLY_NOT_ALLOWED 36855
#define IDS_PERMISSION_OFF_FOR_CHROME 36856
#define IDS_PERMISSION_CHROME_NEEDS_PERMISSION 36857
#define IDS_GEOLOCATION_NAME_FRAGMENT 36858
#define IDS_CAMERA_PERMISSION_NAME_FRAGMENT 36859
#define IDS_MICROPHONE_PERMISSION_NAME_FRAGMENT 36860
#define IDS_CAMERA_AND_MICROPHONE_PERMISSION_NAME_FRAGMENT 36861
#define IDS_MACOS_NAME_FRAGMENT 36862
#define IDS_WINDOWS_NAME_FRAGMENT 36863
#define IDS_CHROMEOS_NAME_FRAGMENT 36864
#define IDS_EMBEDDED_PROMPT_OK_LABEL 36866
#define IDS_EMBEDDED_PROMPT_CONTINUE_ALLOWING 36867
#define IDS_EMBEDDED_PROMPT_STOP_ALLOWING 36868
#define IDS_EMBEDDED_PROMPT_OPEN_SYSTEM_SETTINGS 36870
#define IDS_EMBEDDED_PROMPT_CONTINUE_NOT_ALLOWING 36871
#define IDS_PERMISSION_PROMPT_SURVEY_CUSTOM_INVITATION 36872
#define IDS_POLICY_DM_STATUS_SUCCESS 36873
#define IDS_POLICY_DM_STATUS_REQUEST_INVALID 36874
#define IDS_POLICY_DM_STATUS_REQUEST_FAILED 36875
#define IDS_POLICY_DM_STATUS_TEMPORARY_UNAVAILABLE 36876
#define IDS_POLICY_DM_STATUS_HTTP_STATUS_ERROR 36877
#define IDS_POLICY_DM_STATUS_RESPONSE_DECODING_ERROR 36878
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_NOT_SUPPORTED 36879
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NOT_FOUND 36880
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_TOKEN_INVALID 36881
#define IDS_POLICY_DM_STATUS_SERVICE_ACTIVATION_PENDING 36882
#define IDS_POLICY_DM_STATUS_SERVICE_INVALID_SERIAL_NUMBER 36883
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_ID_CONFLICT 36884
#define IDS_POLICY_DM_STATUS_SERVICE_MISSING_LICENSES 36885
#define IDS_POLICY_DM_STATUS_SERVICE_DEPROVISIONED 36886
#define IDS_POLICY_DM_STATUS_SERVICE_POLICY_NOT_FOUND 36887
#define IDS_POLICY_DM_STATUS_UNKNOWN_ERROR 36888
#define IDS_POLICY_DM_STATUS_INVALID_PACKAGED_DEVICE_FOR_KIOSK 36889
#define IDS_POLICY_DM_STATUS_ORG_UNIT_ENROLLMENT_LIMIT_EXCEEDED 36890
#define IDS_POLICY_DM_STATUS_SERVICE_DOMAIN_MISMATCH 36891
#define IDS_POLICY_DM_STATUS_CANNOT_SIGN_REQUEST 36892
#define IDS_POLICY_DM_STATUS_REQUEST_TOO_LARGE 36893
#define IDS_POLICY_DM_STATUS_SERVICE_TOO_MANY_REQUESTS 36894
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NEEDS_RESET 36895
#define IDS_POLICY_DM_STATUS_CONSUMER_ACCOUNT_WITH_PACKAGED_LICENSE 36896
#define IDS_POLICY_DM_STATUS_ENTERPRISE_ACCOUNT_IS_NOT_ELIGIBLE_TO_ENROLL 36897
#define IDS_POLICY_ACTION_BLOCKED_BY_ORGANIZATION 36898
#define IDS_POLICY_VALIDATION_OK 36899
#define IDS_POLICY_VALIDATION_BAD_INITIAL_SIGNATURE 36900
#define IDS_POLICY_VALIDATION_BAD_SIGNATURE 36901
#define IDS_POLICY_VALIDATION_ERROR_CODE_PRESENT 36902
#define IDS_POLICY_VALIDATION_PAYLOAD_PARSE_ERROR 36903
#define IDS_POLICY_VALIDATION_WRONG_POLICY_TYPE 36904
#define IDS_POLICY_VALIDATION_WRONG_SETTINGS_ENTITY_ID 36905
#define IDS_POLICY_VALIDATION_BAD_TIMESTAMP 36906
#define IDS_POLICY_VALIDATION_BAD_DM_TOKEN 36907
#define IDS_POLICY_VALIDATION_BAD_DEVICE_ID 36908
#define IDS_POLICY_VALIDATION_BAD_USER 36909
#define IDS_POLICY_VALIDATION_POLICY_PARSE_ERROR 36910
#define IDS_POLICY_VALIDATION_BAD_KEY_VERIFICATION_SIGNATURE 36911
#define IDS_POLICY_VALIDATION_VALUE_WARNING 36912
#define IDS_POLICY_VALIDATION_VALUE_ERROR 36913
#define IDS_POLICY_VALIDATION_UNKNOWN_ERROR 36914
#define IDS_POLICY_STORE_STATUS_OK 36915
#define IDS_POLICY_STORE_STATUS_LOAD_ERROR 36916
#define IDS_POLICY_STORE_STATUS_STORE_ERROR 36917
#define IDS_POLICY_STORE_STATUS_PARSE_ERROR 36918
#define IDS_POLICY_STORE_STATUS_SERIALIZE_ERROR 36919
#define IDS_POLICY_STORE_STATUS_VALIDATION_ERROR 36920
#define IDS_POLICY_STORE_STATUS_BAD_STATE 36921
#define IDS_POLICY_STORE_STATUS_UNKNOWN_ERROR 36922
#define IDS_POLICY_ASSOCIATION_STATE_ACTIVE 36923
#define IDS_POLICY_ASSOCIATION_STATE_UNMANAGED 36924
#define IDS_POLICY_ASSOCIATION_STATE_DEPROVISIONED 36925
#define IDS_POLICY_TYPE_ERROR 36926
#define IDS_POLICY_OUT_OF_RANGE_ERROR 36927
#define IDS_POLICY_VALUE_FORMAT_ERROR 36928
#define IDS_POLICY_INVALID_FILE_EXTENSION_ERROR 36929
#define IDS_POLICY_INVALID_HASH_ERROR 36930
#define IDS_POLICY_INVALID_SELECTION_ERROR 36931
#define IDS_POLICY_PAPER_SIZE_CUSTOM_NO_SIZE_ERROR 36932
#define IDS_POLICY_PAPER_SIZE_NOT_CUSTOM_ERROR 36933
#define IDS_POLICY_INVALID_ACCOUNT_PATTERN_FORMAT_ERROR 36934
#define IDS_POLICY_INVALID_PROTOCOL_ERROR 36935
#define IDS_POLICY_INVALID_ORIGIN_ERROR 36936
#define IDS_POLICY_EMPTY_ORIGIN_LIST_ERROR 36937
#define IDS_POLICY_INVALID_EXTENSION_ID_ERROR 36939
#define IDS_POLICY_INVALID_UPDATE_URL_ERROR 36940
#define IDS_POLICY_URL_PATH_SPECIFIED_ERROR 36941
#define IDS_POLICY_MISSING_VENDOR_ID_ERROR 36942
#define IDS_POLICY_INVALID_NUMBER_OF_URLS_ERROR 36943
#define IDS_POLICY_BRUSCHETTA_UNINSTALLABLE_ERROR 36944
#define IDS_POLICY_CLOUD_SOURCE_ONLY_ERROR 36945
#define IDS_POLICY_CLOUD_USER_ONLY_ERROR 36946
#define IDS_POLICY_CLOUD_MANAGEMENT_ENROLLMENT_ONLY_ERROR 36947
#define IDS_POLICY_DEFAULT_SEARCH_DISABLED 36948
#define IDS_POLICY_NOT_SPECIFIED_ERROR 36949
#define IDS_POLICY_EXTENSION_SETTINGS_ORIGIN_LIMIT_WARNING 36950
#define IDS_POLICY_URL_ALLOW_BLOCK_LIST_MAX_FILTERS_LIMIT_WARNING 36951
#define IDS_POLICY_ERROR_WITH_PATH 36952
#define IDS_POLICY_SCHEMA_VALIDATION_ERROR 36953
#define IDS_POLICY_INVALID_JSON_ERROR 36954
#define IDS_POLICY_INVALID_URL_ERROR 36955
#define IDS_POLICY_URL_NOT_HTTPS_ERROR 36956
#define IDS_POLICY_INVALID_SEARCH_URL_ERROR 36957
#define IDS_POLICY_INVALID_SECURE_DNS_MODE_ERROR 36958
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_ERROR 36959
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_ERROR 36960
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_SIZE_ERROR 36961
#define IDS_POLICY_SECURE_DNS_TEMPLATES_IRRELEVANT_MODE_ERROR 36962
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_MODE_ERROR 36963
#define IDS_POLICY_SECURE_DNS_TEMPLATES_UNSET_MODE_ERROR 36964
#define IDS_POLICY_SECURE_DNS_TEMPLATES_NOT_SPECIFIED_ERROR 36965
#define IDS_POLICY_INVALID_PROXY_MODE_ERROR 36966
#define IDS_POLICY_OFF_CWS_URL_ERROR 36968
#define IDS_POLICY_HOMEPAGE_LOCATION_ERROR 36969
#define IDS_POLICY_PROXY_MODE_DISABLED_ERROR 36970
#define IDS_POLICY_PROXY_MODE_AUTO_DETECT_ERROR 36971
#define IDS_POLICY_PROXY_MODE_PAC_URL_ERROR 36972
#define IDS_POLICY_PROXY_MODE_FIXED_SERVERS_ERROR 36973
#define IDS_POLICY_PROXY_MODE_SYSTEM_ERROR 36974
#define IDS_POLICY_PROXY_BOTH_SPECIFIED_ERROR 36975
#define IDS_POLICY_PROXY_NEITHER_SPECIFIED_ERROR 36976
#define IDS_POLICY_DEVELOPER_TOOLS_EXTENSIONS_CONFLICT_MESSAGE 36977
#define IDS_POLICY_OVERRIDDEN 36978
#define IDS_POLICY_VALUE_DEPRECATED 36979
#define IDS_POLICY_DEPENDENCY_ERROR 36980
#define IDS_POLICY_DEPENDENCY_ERROR_ANY_VALUE 36981
#define IDS_POLICY_IDLE_TIMEOUT_ACTIONS_DEPENDENCY_ERROR 36982
#define IDS_POLICY_USER_IS_NOT_AFFILIATED_ERROR 36983
#define IDS_POLICY_LEVEL_ERROR 36988
#define IDS_POLICY_OK 36989
#define IDS_POLICY_UNSET 36990
#define IDS_POLICY_UNKNOWN 36991
#define IDS_POLICY_PROTO_PARSING_ERROR 36992
#define IDS_POLICY_HEX_COLOR_ERROR 36993
#define IDS_POLICY_SITE_SEARCH_SETTINGS_MAX_PROVIDERS_LIMIT_ERROR 36994
#define IDS_POLICY_SITE_SEARCH_SETTINGS_MAX_FEATURED_PROVIDERS_LIMIT_ERROR 36995
#define IDS_POLICY_SITE_SEARCH_SETTINGS_DUPLICATED_SHORTCUT 36996
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_CONTAINS_SPACE 36997
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_STARTS_WITH_AT 36998
#define IDS_SEARCH_POLICY_SETTINGS_NO_VALID_PROVIDER 36999
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_IS_EMPTY 37000
#define IDS_SEARCH_POLICY_SETTINGS_NAME_IS_EMPTY 37001
#define IDS_SEARCH_POLICY_SETTINGS_URL_IS_EMPTY 37002
#define IDS_SEARCH_POLICY_SETTINGS_URL_DOESNT_SUPPORT_REPLACEMENT 37003
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_EQUALS_DSP_KEYWORD 37004
#define IDS_POLICY_SITE_SEARCH_SETTINGS_SHORTCUT_EQUALS_SEARCH_AGGREGATOR_KEYWORD 37005
#define IDS_SEARCH_POLICY_SETTINGS_URL_NOT_HTTPS 37006
#define IDS_POLICY_DATA_CONTROLS_MUTUALLY_EXCLUSIVE_KEYS 37007
#define IDS_POLICY_DATA_CONTROLS_MUTUALLY_EXCLUSIVE_KEY_SETS 37008
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_CONDITION 37009
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_RESTRICTION 37010
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_LEVEL 37011
#define IDS_POLICY_NTP_SHORTCUTS_MAX_SHORTCUTS_LIMIT_ERROR 37012
#define IDS_POLICY_NTP_SHORTCUTS_NO_VALID_PROVIDER 37013
#define IDS_POLICY_NTP_SHORTCUTS_DUPLICATED_URL 37014
#define IDS_POLICY_NTP_SHORTCUTS_NAME_TOO_LONG 37015
#define IDS_POLICY_NTP_SHORTCUTS_URL_TOO_LONG 37016
#define IDS_POLICY_TITLE 37017
#define IDS_POLICY_FILTER_PLACEHOLDER 37018
#define IDS_POLICY_RELOAD_POLICIES 37019
#define IDS_POLICY_RELOADING_POLICIES 37020
#define IDS_POLICY_RELOAD_POLICIES_DONE 37021
#define IDS_EXPORT_POLICIES_JSON 37022
#define IDS_EXPORT_POLICIES_JSON_DONE 37023
#define IDS_UPLOAD_REPORT 37024
#define IDS_REPORT_UPLOADING 37025
#define IDS_REPORT_UPLOADED 37026
#define IDS_POLICY_STATUS 37027
#define IDS_POLICY_STATUS_DEVICE 37028
#define IDS_POLICY_STATUS_USER 37029
#define IDS_POLICY_STATUS_MACHINE 37030
#define IDS_POLICY_STATUS_UPDATER 37031
#define IDS_POLICY_STATUS_ERROR_MANAGED_NO_POLICY 37032
#define IDS_POLICY_STATUS_FLEX_ORG_NO_POLICY 37033
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DOMAIN 37034
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_TOKEN 37035
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DEVICE_ID 37036
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_MACHINE_NAME 37037
#define IDS_POLICY_LABEL_USERNAME 37038
#define IDS_POLICY_LABEL_GAIA_ID 37039
#define IDS_POLICY_LABEL_CLIENT_ID 37040
#define IDS_POLICY_LABEL_PROFILE_ID 37041
#define IDS_POLICY_LABEL_ASSET_ID 37042
#define IDS_POLICY_LABEL_LOCATION 37043
#define IDS_POLICY_LABEL_DIRECTORY_API_ID 37044
#define IDS_POLICY_LABEL_MANAGED_BY 37045
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_FETCH_ATTEMPT 37046
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_REFRESH 37047
#define IDS_POLICY_LABEL_LAST_CLOUD_REPORT_SENT_TIMESTAMP 37048
#define IDS_POLICY_NOT_SPECIFIED 37049
#define IDS_POLICY_LABEL_PUSH_POLICIES 37050
#define IDS_POLICY_PUSH_POLICIES_ON 37051
#define IDS_POLICY_PUSH_POLICIES_OFF 37052
#define IDS_POLICY_NEVER_FETCHED 37053
#define IDS_POLICY_LABEL_REFRESH_INTERVAL 37054
#define IDS_POLICY_LABEL_CONFLICT 37055
#define IDS_POLICY_LABEL_SUPERSEDING 37056
#define IDS_POLICY_LABEL_CONFLICT_VALUE 37057
#define IDS_POLICY_LABEL_SUPERSEDED_VALUE 37058
#define IDS_POLICY_LABEL_ERROR 37059
#define IDS_POLICY_LABEL_DEPRECATED 37060
#define IDS_POLICY_LABEL_FUTURE 37061
#define IDS_POLICY_LABEL_IGNORED 37062
#define IDS_POLICY_LABEL_VALUE 37063
#define IDS_POLICY_LABEL_VERSION 37064
#define IDS_POLICY_LABEL_STATUS 37065
#define IDS_POLICY_LABEL_INFO 37066
#define IDS_POLICY_LABEL_PRECEDENCE 37067
#define IDS_POLICY_SHOW_UNSET 37068
#define IDS_POLICY_NO_POLICIES_SET 37069
#define IDS_POLICY_HEADER_SCOPE 37070
#define IDS_POLICY_HEADER_LEVEL 37071
#define IDS_POLICY_HEADER_NAMESPACE 37072
#define IDS_POLICY_HEADER_NAME 37073
#define IDS_POLICY_HEADER_VALUE 37074
#define IDS_POLICY_HEADER_STATUS 37075
#define IDS_POLICY_HEADER_SOURCE 37076
#define IDS_POLICY_HEADER_WARNING 37077
#define IDS_POLICY_SHOW_MORE 37078
#define IDS_POLICY_SHOW_LESS 37079
#define IDS_POLICY_LEARN_MORE 37080
#define IDS_POLICY_SCOPE_USER 37081
#define IDS_POLICY_SCOPE_ALL_USERS 37082
#define IDS_POLICY_SCOPE_DEVICE 37083
#define IDS_POLICY_LEVEL_RECOMMENDED 37084
#define IDS_POLICY_LEVEL_MANDATORY 37085
#define IDS_POLICY_SOURCE_ENTERPRISE_DEFAULT 37086
#define IDS_POLICY_SOURCE_DEFAULT 37087
#define IDS_POLICY_SOURCE_COMMAND_LINE 37088
#define IDS_POLICY_SOURCE_CLOUD 37089
#define IDS_POLICY_SOURCE_MERGED 37090
#define IDS_POLICY_SOURCE_CLOUD_FROM_ASH 37091
#define IDS_POLICY_SOURCE_RESTRICTED_MANAGED_GUEST_SESSION_OVERRIDE 37092
#define IDS_POLICY_SOURCE_ACTIVE_DIRECTORY 37093
#define IDS_POLICY_SOURCE_PLATFORM 37094
#define IDS_POLICY_SOURCE_DEVICE_LOCAL_ACCOUNT_OVERRIDE 37095
#define IDS_POLICY_RISK_TAG_FULL_ADMIN_ACCESS 37096
#define IDS_POLICY_RISK_TAG_SYSTEM_SECURITY 37097
#define IDS_POLICY_RISK_TAG_WEBSITE_SHARING 37098
#define IDS_POLICY_RISK_TAG_ADMIN_SHARING 37099
#define IDS_POLICY_RISK_TAG_FILTERING 37100
#define IDS_POLICY_RISK_TAG_LOCAL_DATA_ACCESS 37101
#define IDS_POLICY_RISK_TAG_GOOGLE_SHARING 37102
#define IDS_POLICY_SHOW_EXPANDED_STATUS 37103
#define IDS_POLICY_HIDE_EXPANDED_STATUS 37104
#define IDS_POLICY_LIST_MERGING_WRONG_POLICY_TYPE_SPECIFIED 37105
#define IDS_POLICY_DICTIONARY_MERGING_WRONG_POLICY_TYPE_SPECIFIED 37106
#define IDS_POLICY_DICTIONARY_MERGING_POLICY_NOT_ALLOWED 37107
#define IDS_POLICY_CONFLICT_SAME_VALUE 37108
#define IDS_POLICY_CONFLICT_DIFF_VALUE 37109
#define IDS_POLICY_MIGRATED_OLD_POLICY 37110
#define IDS_POLICY_MIGRATED_NEW_POLICY 37111
#define IDS_POLICY_BLOCKED 37112
#define IDS_POLICY_INVALID 37113
#define IDS_POLICY_IGNORED_BY_GROUP_MERGING 37114
#define IDS_POLICY_INVALID_VALUE 37115
#define IDS_POLICY_IGNORED_MANDATORY_REPORTING_POLICY 37116
#define IDS_POLICY_IGNORED_CHROME_PROFILE 37117
#define IDS_POLICY_IGNORED_UNAFFILIATED 37118
#define IDS_POLICY_IGNORED_EXTENSION 37119
#define IDS_POLICY_PRECEDENCE_PLATFORM_MACHINE 37120
#define IDS_POLICY_PRECEDENCE_PLATFORM_USER 37121
#define IDS_POLICY_PRECEDENCE_CLOUD_MACHINE 37122
#define IDS_POLICY_PRECEDENCE_CLOUD_USER 37123
#define IDS_POLICY_SPELLCHECK_UNKNOWN_LANGUAGE 37124
#define IDS_POLICY_SPELLCHECK_BLOCKLIST_IGNORE 37125
#define IDS_POLICY_DEFAULT_GEO_POLICY_ARC_CONFLICT 37126
#define IDS_POLICY_LABEL_IS_AFFILIATED 37127
#define IDS_POLICY_IS_AFFILIATED_YES 37128
#define IDS_POLICY_IS_AFFILIATED_NO 37129
#define IDS_POLICY_LABEL_IS_OFFHOURS_ACTIVE 37130
#define IDS_POLICY_OFFHOURS_ACTIVE 37131
#define IDS_POLICY_OFFHOURS_NOT_ACTIVE 37132
#define IDS_POLICY_SIGNIN_PROFILE 37133
#define IDS_POLICY_COPY_VALUE 37134
#define IDS_COPY_POLICIES_JSON 37135
#define IDS_COPY_POLICIES_DONE 37136
#define IDS_VIEW_POLICY_LOGS 37137
#define IDS_POLICY_MORE_ACTIONS 37138
#define IDS_POLICY_TABLE_COLUMN_SORT 37139
#define IDS_POLICY_TABLE_COLUMN_SORT_ASCENDING 37140
#define IDS_POLICY_TABLE_COLUMN_SORT_DESCENDING 37141
#define IDS_POLICY_BANNER_PROMOTION_TITLE 37142
#define IDS_POLICY_BANNER_PROMOTION_DESC 37143
#define IDS_POLICY_BANNER_PROMOTION_BTN 37144
#define IDS_POLICY_LOGS_TITLE 37145
#define IDS_VERSION_INFO 37146
#define IDS_EXPORT_POLICY_LOGS_JSON 37147
#define IDS_REFRESH_POLICY_LOGS 37148
#define IDS_POLICY_TEST_TITLE 37149
#define IDS_POLICY_TEST_RESTART_AND_APPLY 37150
#define IDS_POLICY_TEST_APPLY 37151
#define IDS_POLICY_TEST_IMPORT 37152
#define IDS_POLICY_TEST_DESC 37153
#define IDS_POLICY_TEST_REVERT 37154
#define IDS_POLICY_TEST_TABLE_SCOPE 37155
#define IDS_POLICY_TEST_ADD 37156
#define IDS_POLICY_SELECT_NAME 37157
#define IDS_POLICY_TEST_TABLE_PRESET 37158
#define IDS_LOCAL_TEST_POLICIES_ENABLED 37159
#define IDS_POLICY_TEST_PRESET_CUSTOM 37160
#define IDS_POLICY_TEST_PRESET_LOCAL_MACHINE 37161
#define IDS_POLICY_TEST_PRESET_CLOUD_ACCOUNT 37162
#define IDS_POLICY_TEST_USER_AFFILIATED 37163
#define IDS_CHROME_URLS_DISABLED_PAGE_HEADER 37164
#define IDS_CHROME_URLS_DISABLED_PAGE_TITLE 37165
#define IDS_CHROME_URLS_DISABLED_PAGE_MESSAGE 37166
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_PASTE 37167
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_COPY_VM 37168
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_TOAST_BUTTON 37169
#define IDS_POLICY_DLP_ANDROID_APPS 37170
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_DISMISS_BUTTON 37171
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_PASTE 37172
#define IDS_POLICY_DLP_CLIPBOARD_WARN_PROCEED_BUTTON 37173
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_COPY_VM 37174
#define IDS_POLICY_DLP_PRINTING_BLOCKED_TITLE 37175
#define IDS_POLICY_DLP_PRINTING_BLOCKED_MESSAGE 37176
#define IDS_POLICY_DLP_PRINTING_WARN_TITLE 37177
#define IDS_POLICY_DLP_PRINTING_WARN_MESSAGE 37178
#define IDS_POLICY_DLP_PRINTING_WARN_CONTINUE_BUTTON 37179
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_TITLE 37180
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_MESSAGE 37181
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_TITLE 37182
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_MESSAGE 37183
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_TITLE 37184
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_MESSAGE 37185
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_TITLE 37186
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_MESSAGE 37187
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_TITLE 37188
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_MESSAGE 37189
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_TITLE 37190
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_MESSAGE 37191
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_CONTINUE_BUTTON 37192
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_TITLE 37193
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_MESSAGE 37194
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_CONTINUE_BUTTON 37195
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_TITLE 37196
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_MESSAGE 37197
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CONTINUE_BUTTON 37198
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CANCEL_BUTTON 37199
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_TITLE 37200
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_TITLE 37201
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_TITLE 37202
#define IDS_POLICY_DLP_FILES_MOVE_WARN_TITLE 37203
#define IDS_POLICY_DLP_FILES_COPY_WARN_TITLE 37204
#define IDS_POLICY_DLP_FILES_OPEN_WARN_TITLE 37205
#define IDS_POLICY_DLP_FILES_DOWNLOAD_REVIEW_TITLE 37206
#define IDS_POLICY_DLP_FILES_TRANSFER_REVIEW_TITLE 37207
#define IDS_POLICY_DLP_FILES_UPLOAD_REVIEW_TITLE 37208
#define IDS_POLICY_DLP_FILES_MOVE_REVIEW_TITLE 37209
#define IDS_POLICY_DLP_FILES_COPY_REVIEW_TITLE 37210
#define IDS_POLICY_DLP_FILES_OPEN_REVIEW_TITLE 37211
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_MESSAGE 37212
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_MESSAGE 37213
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_MESSAGE 37214
#define IDS_POLICY_DLP_FILES_MOVE_WARN_MESSAGE 37215
#define IDS_POLICY_DLP_FILES_COPY_WARN_MESSAGE 37216
#define IDS_POLICY_DLP_FILES_OPEN_WARN_MESSAGE 37217
#define IDS_POLICY_DLP_FILES_WARN_MESSAGE 37218
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_CONTINUE_BUTTON 37219
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_CONTINUE_BUTTON 37220
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_CONTINUE_BUTTON 37221
#define IDS_POLICY_DLP_FILES_MOVE_WARN_CONTINUE_BUTTON 37222
#define IDS_POLICY_DLP_FILES_COPY_WARN_CONTINUE_BUTTON 37223
#define IDS_POLICY_DLP_FILES_OPEN_WARN_CONTINUE_BUTTON 37224
#define IDS_POLICY_DLP_FILES_DESTINATION_REMOVABLE_STORAGE 37225
#define IDS_POLICY_DLP_FILES_REVIEW_BUTTON 37226
#define IDS_POLICY_DLP_FILES_DISMISS_BUTTON 37227
#define IDS_POLICY_DLP_FILES_OK_BUTTON 37228
#define IDS_POLICY_DLP_WARN_CANCEL_BUTTON 37229
#define IDS_POLICY_DLP_CLIPBOARD_BUBBLE_MESSAGE 37230
#define IDS_POLICY_DLP_FROM_YOUR_ADMIN_MESSAGE 37231
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_TITLE 37232
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_MESSAGE 37233
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_TITLE 37234
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_MESSAGE 37235
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_TITLE 37236
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_MESSAGE 37237
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCKED_TITLE 37238
#define IDS_POLICY_DLP_FILES_TRANSFER_BLOCKED_TITLE 37239
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCKED_TITLE 37240
#define IDS_POLICY_DLP_FILES_MOVE_BLOCKED_TITLE 37241
#define IDS_POLICY_DLP_FILES_COPY_BLOCKED_TITLE 37242
#define IDS_POLICY_DLP_FILES_OPEN_BLOCKED_TITLE 37243
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_SINGLE_FILE_MESSAGE 37244
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_MESSAGE 37245
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_SINGLE_FILE_MESSAGE 37246
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_MESSAGE 37247
#define IDS_POLICY_DLP_FILES_BLOCK_MESSAGE 37248
#define IDS_POLICY_DLP_FILES_DOWNLOAD_JUSTIFICATION_LABEL 37249
#define IDS_POLICY_DLP_FILES_UPLOAD_JUSTIFICATION_LABEL 37250
#define IDS_POLICY_DLP_FILES_COPY_JUSTIFICATION_LABEL 37251
#define IDS_POLICY_DLP_FILES_MOVE_JUSTIFICATION_LABEL 37252
#define IDS_POLICY_DLP_FILES_OPEN_JUSTIFICATION_LABEL 37253
#define IDS_POLICY_DLP_FILES_TRANSFER_JUSTIFICATION_LABEL 37254
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_TITLE 37255
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_TITLE 37256
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_TITLE 37257
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_TITLE 37258
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_TITLE 37259
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_TITLE 37260
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_MESSAGE 37261
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_MESSAGE 37262
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_MESSAGE 37263
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_MESSAGE 37264
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_MESSAGE 37265
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_MESSAGE 37266
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_DATA_CONTROLS_ACCESSIBLE_NAME 37267
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_MALWARE_PROTECTION_ACCESSIBLE_NAME 37268
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_SENSITIVE_DATA_PROTECTION_ACCESSIBLE_NAME 37269
#define IDS_POLICY_DLP_FILES_JUSTIFICATION_TEXTAREA_ACCESSIBLE_DESCRIPTION 37270
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_TITLE 37271
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_MESSAGE 37272
#define IDS_POLICY_REBOOT_BUTTON 37273
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_DIALOG_MESSAGE 37274
#define IDS_REBOOT_SCHEDULED_TITLE_MINUTES 37275
#define IDS_REBOOT_SCHEDULED_TITLE_SECONDS 37276
#define IDS_POLICY_DEVICE_POST_REBOOT_TITLE 37277
#define IDS_POLICY_BROWSING_DATA_DEPENDENCY_APPLIED_INFO 37278
#define IDS_POLICY_BROWSING_DATA_PLATFORM_UNSUPPORTED 37279
#define IDS_POLICY_NOT_SUPPORTED_AS_USER_POLICY_ON_IOS 37280
#define IDS_POLICY_GEN_AI_DEFAULT_SETTINGS_CONTROL_MESSAGE 37281
#define IDS_POLICY_GEN_AI_DEFAULT_SETTINGS_NO_CONTROL_MESSAGE 37282
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_TITLE 37283
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_BUTTON 37284
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_CANCEL_BUTTON 37285
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_DISPLAY_SOURCE 37286
#define IDS_POLICY_SKYVAULT_MIGRATION_BANNER 37287
#define IDS_POLICY_SKYVAULT_MISCONFIGURED_POLICY_MESSAGE 37288
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_UPLOAD_TITLE 37289
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_RECORDING_UPLOAD_TITLE 37290
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_UPLOAD_ONEDRIVE_MESSAGE 37291
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_UPLOAD_CANCEL_BUTTON 37292
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_SIGN_IN_TITLE 37293
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_SIGN_IN_BUTTON 37294
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_SIGN_IN_CANCEL_BUTTON 37295
#define IDS_POLICY_SKYVAULT_CLOUD_PROVIDER_GOOGLE_DRIVE 37296
#define IDS_POLICY_SKYVAULT_CLOUD_PROVIDER_ONEDRIVE 37297
#define IDS_POLICY_SKYVAULT_MIGRATION_PROGRESS_TITLE 37298
#define IDS_POLICY_SKYVAULT_MIGRATION_PROGRESS_MESSAGE 37299
#define IDS_POLICY_SKYVAULT_MIGRATION_COMPLETED_TITLE 37300
#define IDS_POLICY_SKYVAULT_MIGRATION_COMPLETED_MESSAGE 37301
#define IDS_POLICY_SKYVAULT_MIGRATION_COMPLETED_BUTTON 37302
#define IDS_POLICY_SKYVAULT_MIGRATION_CONFIG_ERROR_TITLE 37303
#define IDS_POLICY_SKYVAULT_MIGRATION_CONFIG_ERROR_MESSAGE 37304
#define IDS_POLICY_SKYVAULT_MIGRATION_ERROR_TITLE 37305
#define IDS_POLICY_SKYVAULT_MIGRATION_ERROR_MESSAGE 37306
#define IDS_POLICY_SKYVAULT_MIGRATION_ERROR_BUTTON 37307
#define IDS_POLICY_SKYVAULT_MIGRATION_SIGN_IN_TITLE 37308
#define IDS_POLICY_SKYVAULT_MIGRATION_SIGN_IN_MESSAGE 37309
#define IDS_POLICY_SKYVAULT_MIGRATION_SIGN_IN_BUTTON 37310
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_HOURS 37311
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_HOUR 37312
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_MINUTES 37313
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_MINUTE 37314
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_START_MESSAGE 37315
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_START_ON_MESSAGE 37316
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_DONE_MESSAGE 37317
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_NOW_BUTTON 37318
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_IN_HOURS_BUTTON 37319
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_IN_MINUTES_BUTTON 37320
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_TITLE_HOURS 37321
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_TITLE_HOUR 37322
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_TITLE_MINUTES 37323
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_TITLE_MINUTE 37324
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_START_MESSAGE 37325
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_STORE_MESSAGE 37326
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_DELETE_NOW_BUTTON 37327
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_DELETE_IN_HOURS_BUTTON 37328
#define IDS_POLICY_SKYVAULT_DELETION_DIALOG_DELETE_IN_MINUTES_BUTTON 37329
#define IDS_POLICY_SKYVAULT_DELETION_COMPLETED_TITLE 37330
#define IDS_POLICY_SKYVAULT_DELETION_COMPLETED_MESSAGE 37331
#define IDS_POLICY_SKYVAULT_DELETION_BANNER 37332
#define IDS_POLICY_SKYVAULT_MIGRATION_UPLOAD_ERROR_NO_SPACE 37333
#define IDS_POLICY_SKYVAULT_MIGRATION_UPLOAD_ERROR_FILE_NOT_EXIST 37334
#define IDS_POLICY_SKYVAULT_MIGRATION_UPLOAD_ERROR_ODFS_SIGN_IN 37335
#define IDS_POLICY_SKYVAULT_MIGRATION_UPLOAD_ERROR_NO_INTERNET 37336
#define IDS_POLICY_SKYVAULT_MIGRATION_UPLOAD_ERROR_GENERIC 37337
#define PRINT_PREVIEW_MEDIA_ASME_F_28X40IN 37338
#define PRINT_PREVIEW_MEDIA_ISO_2A0_1189X1682MM 37339
#define PRINT_PREVIEW_MEDIA_ISO_A0_841X1189MM 37340
#define PRINT_PREVIEW_MEDIA_ISO_A0X3_1189X2523MM 37341
#define PRINT_PREVIEW_MEDIA_ISO_A10_26X37MM 37342
#define PRINT_PREVIEW_MEDIA_ISO_A1_594X841MM 37343
#define PRINT_PREVIEW_MEDIA_ISO_A1X3_841X1783MM 37344
#define PRINT_PREVIEW_MEDIA_ISO_A1X4_841X2378MM 37345
#define PRINT_PREVIEW_MEDIA_ISO_A2_420X594MM 37346
#define PRINT_PREVIEW_MEDIA_ISO_A2X3_594X1261MM 37347
#define PRINT_PREVIEW_MEDIA_ISO_A2X4_594X1682MM 37348
#define PRINT_PREVIEW_MEDIA_ISO_A2X5_594X2102MM 37349
#define PRINT_PREVIEW_MEDIA_ISO_A3_297X420MM 37350
#define PRINT_PREVIEW_MEDIA_ISO_A3_EXTRA_322X445MM 37351
#define PRINT_PREVIEW_MEDIA_ISO_A3X3_420X891MM 37352
#define PRINT_PREVIEW_MEDIA_ISO_A3X4_420X1189MM 37353
#define PRINT_PREVIEW_MEDIA_ISO_A3X5_420X1486MM 37354
#define PRINT_PREVIEW_MEDIA_ISO_A3X6_420X1783MM 37355
#define PRINT_PREVIEW_MEDIA_ISO_A3X7_420X2080MM 37356
#define PRINT_PREVIEW_MEDIA_ISO_A4_210X297MM 37357
#define PRINT_PREVIEW_MEDIA_ISO_A4_EXTRA_235_5X322_3MM 37358
#define PRINT_PREVIEW_MEDIA_ISO_A4_TAB_225X297MM 37359
#define PRINT_PREVIEW_MEDIA_ISO_A4X3_297X630MM 37360
#define PRINT_PREVIEW_MEDIA_ISO_A4X4_297X841MM 37361
#define PRINT_PREVIEW_MEDIA_ISO_A4X5_297X1051MM 37362
#define PRINT_PREVIEW_MEDIA_ISO_A4X6_297X1261MM 37363
#define PRINT_PREVIEW_MEDIA_ISO_A4X7_297X1471MM 37364
#define PRINT_PREVIEW_MEDIA_ISO_A4X8_297X1682MM 37365
#define PRINT_PREVIEW_MEDIA_ISO_A4X9_297X1892MM 37366
#define PRINT_PREVIEW_MEDIA_ISO_A5_148X210MM 37367
#define PRINT_PREVIEW_MEDIA_ISO_A5_EXTRA_174X235MM 37368
#define PRINT_PREVIEW_MEDIA_ISO_A6_105X148MM 37369
#define PRINT_PREVIEW_MEDIA_ISO_A7_74X105MM 37370
#define PRINT_PREVIEW_MEDIA_ISO_A8_52X74MM 37371
#define PRINT_PREVIEW_MEDIA_ISO_A9_37X52MM 37372
#define PRINT_PREVIEW_MEDIA_ISO_B0_1000X1414MM 37373
#define PRINT_PREVIEW_MEDIA_ISO_B10_31X44MM 37374
#define PRINT_PREVIEW_MEDIA_ISO_B1_707X1000MM 37375
#define PRINT_PREVIEW_MEDIA_ISO_B2_500X707MM 37376
#define PRINT_PREVIEW_MEDIA_ISO_B3_353X500MM 37377
#define PRINT_PREVIEW_MEDIA_ISO_B4_250X353MM 37378
#define PRINT_PREVIEW_MEDIA_ISO_B5_176X250MM 37379
#define PRINT_PREVIEW_MEDIA_ISO_B5_EXTRA_201X276MM 37380
#define PRINT_PREVIEW_MEDIA_ISO_B6C4_125X324MM 37381
#define PRINT_PREVIEW_MEDIA_ISO_B6_125X176MM 37382
#define PRINT_PREVIEW_MEDIA_ISO_B7_88X125MM 37383
#define PRINT_PREVIEW_MEDIA_ISO_B8_62X88MM 37384
#define PRINT_PREVIEW_MEDIA_ISO_B9_44X62MM 37385
#define PRINT_PREVIEW_MEDIA_ISO_C0_917X1297MM 37386
#define PRINT_PREVIEW_MEDIA_ISO_C10_28X40MM 37387
#define PRINT_PREVIEW_MEDIA_ISO_C1_648X917MM 37388
#define PRINT_PREVIEW_MEDIA_ISO_C2_458X648MM 37389
#define PRINT_PREVIEW_MEDIA_ISO_C3_324X458MM 37390
#define PRINT_PREVIEW_MEDIA_ISO_C4_229X324MM 37391
#define PRINT_PREVIEW_MEDIA_ISO_C5_162X229MM 37392
#define PRINT_PREVIEW_MEDIA_ISO_C6C5_114X229MM 37393
#define PRINT_PREVIEW_MEDIA_ISO_C6_114X162MM 37394
#define PRINT_PREVIEW_MEDIA_ISO_C7C6_81X162MM 37395
#define PRINT_PREVIEW_MEDIA_ISO_C7_81X114MM 37396
#define PRINT_PREVIEW_MEDIA_ISO_C8_57X81MM 37397
#define PRINT_PREVIEW_MEDIA_ISO_C9_40X57MM 37398
#define PRINT_PREVIEW_MEDIA_ISO_DL_110X220MM 37399
#define PRINT_PREVIEW_MEDIA_ISO_ID_1_53_98X85_6MM 37400
#define PRINT_PREVIEW_MEDIA_ISO_RA0_860X1220MM 37401
#define PRINT_PREVIEW_MEDIA_ISO_RA1_610X860MM 37402
#define PRINT_PREVIEW_MEDIA_ISO_RA2_430X610MM 37403
#define PRINT_PREVIEW_MEDIA_ISO_RA3_305X430MM 37404
#define PRINT_PREVIEW_MEDIA_ISO_RA4_215X305MM 37405
#define PRINT_PREVIEW_MEDIA_ISO_SRA0_900X1280MM 37406
#define PRINT_PREVIEW_MEDIA_ISO_SRA1_640X900MM 37407
#define PRINT_PREVIEW_MEDIA_ISO_SRA2_450X640MM 37408
#define PRINT_PREVIEW_MEDIA_ISO_SRA3_320X450MM 37409
#define PRINT_PREVIEW_MEDIA_ISO_SRA4_225X320MM 37410
#define PRINT_PREVIEW_MEDIA_JIS_B0_1030X1456MM 37411
#define PRINT_PREVIEW_MEDIA_JIS_B1_728X1030MM 37412
#define PRINT_PREVIEW_MEDIA_JIS_B2_515X728MM 37413
#define PRINT_PREVIEW_MEDIA_JIS_B3_364X515MM 37414
#define PRINT_PREVIEW_MEDIA_JIS_B4_257X364MM 37415
#define PRINT_PREVIEW_MEDIA_JIS_B5_182X257MM 37416
#define PRINT_PREVIEW_MEDIA_JIS_B6_128X182MM 37417
#define PRINT_PREVIEW_MEDIA_JIS_B7_91X128MM 37418
#define PRINT_PREVIEW_MEDIA_JIS_B8_64X91MM 37419
#define PRINT_PREVIEW_MEDIA_JIS_B9_45X64MM 37420
#define PRINT_PREVIEW_MEDIA_JIS_B10_32X45MM 37421
#define PRINT_PREVIEW_MEDIA_JIS_EXEC_216X330MM 37422
#define PRINT_PREVIEW_MEDIA_JPN_CHOU2_111_1X146MM 37423
#define PRINT_PREVIEW_MEDIA_JPN_CHOU3_120X235MM 37424
#define PRINT_PREVIEW_MEDIA_JPN_CHOU4_90X205MM 37425
#define PRINT_PREVIEW_MEDIA_JPN_CHOU40_90X225MM 37426
#define PRINT_PREVIEW_MEDIA_JPN_HAGAKI_100X148MM 37427
#define PRINT_PREVIEW_MEDIA_JPN_KAHU_240X322_1MM 37428
#define PRINT_PREVIEW_MEDIA_JPN_KAKU1_270X382MM 37429
#define PRINT_PREVIEW_MEDIA_JPN_KAKU2_240X332MM 37430
#define PRINT_PREVIEW_MEDIA_JPN_KAKU3_216X277MM 37431
#define PRINT_PREVIEW_MEDIA_JPN_KAKU4_197X267MM 37432
#define PRINT_PREVIEW_MEDIA_JPN_KAKU5_190X240MM 37433
#define PRINT_PREVIEW_MEDIA_JPN_KAKU7_142X205MM 37434
#define PRINT_PREVIEW_MEDIA_JPN_KAKU8_119X197MM 37435
#define PRINT_PREVIEW_MEDIA_JPN_OUFUKU_148X200MM 37436
#define PRINT_PREVIEW_MEDIA_JPN_YOU4_105X235MM 37437
#define PRINT_PREVIEW_MEDIA_JPN_YOU6_98X190MM 37438
#define PRINT_PREVIEW_MEDIA_NA_10X11_10X11IN 37439
#define PRINT_PREVIEW_MEDIA_NA_10X13_10X13IN 37440
#define PRINT_PREVIEW_MEDIA_NA_10X14_10X14IN 37441
#define PRINT_PREVIEW_MEDIA_NA_10X15_10X15IN 37442
#define PRINT_PREVIEW_MEDIA_NA_11X12_11X12IN 37443
#define PRINT_PREVIEW_MEDIA_NA_11X15_11X15IN 37444
#define PRINT_PREVIEW_MEDIA_NA_12X19_12X19IN 37445
#define PRINT_PREVIEW_MEDIA_NA_5X7_5X7IN 37446
#define PRINT_PREVIEW_MEDIA_NA_6X9_6X9IN 37447
#define PRINT_PREVIEW_MEDIA_NA_7X9_7X9IN 37448
#define PRINT_PREVIEW_MEDIA_NA_9X11_9X11IN 37449
#define PRINT_PREVIEW_MEDIA_NA_A2_4_375X5_75IN 37450
#define PRINT_PREVIEW_MEDIA_NA_ARCH_A_9X12IN 37451
#define PRINT_PREVIEW_MEDIA_NA_ARCH_B_12X18IN 37452
#define PRINT_PREVIEW_MEDIA_NA_ARCH_C_18X24IN 37453
#define PRINT_PREVIEW_MEDIA_NA_ARCH_D_24X36IN 37454
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E_36X48IN 37455
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E2_26X38IN 37456
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E3_27X39IN 37457
#define PRINT_PREVIEW_MEDIA_NA_B_PLUS_12X19_17IN 37458
#define PRINT_PREVIEW_MEDIA_NA_C5_6_5X9_5IN 37459
#define PRINT_PREVIEW_MEDIA_NA_C_17X22IN 37460
#define PRINT_PREVIEW_MEDIA_NA_D_22X34IN 37461
#define PRINT_PREVIEW_MEDIA_NA_EDP_11X14IN 37462
#define PRINT_PREVIEW_MEDIA_NA_EUR_EDP_12X14IN 37463
#define PRINT_PREVIEW_MEDIA_NA_E_34X44IN 37464
#define PRINT_PREVIEW_MEDIA_NA_EXECUTIVE_7_25X10_5IN 37465
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_EUR_8_5X12IN 37466
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_US_11X14_875IN 37467
#define PRINT_PREVIEW_MEDIA_NA_FOOLSCAP_8_5X13IN 37468
#define PRINT_PREVIEW_MEDIA_NA_F_44X68IN 37469
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LEGAL_8X13IN 37470
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LETTER_8X10IN 37471
#define PRINT_PREVIEW_MEDIA_NA_INDEX_3X5_3X5IN 37472
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_4X6IN 37473
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_EXT_6X8IN 37474
#define PRINT_PREVIEW_MEDIA_NA_INDEX_5X8_5X8IN 37475
#define PRINT_PREVIEW_MEDIA_NA_INVOICE_5_5X8_5IN 37476
#define PRINT_PREVIEW_MEDIA_NA_LEDGER_11X17IN 37477
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_8_5X14IN 37478
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_EXTRA_9_5X15IN 37479
#define PRINT_PREVIEW_MEDIA_NA_LETTER_8_5X11IN 37480
#define PRINT_PREVIEW_MEDIA_NA_LETTER_EXTRA_9_5X12IN 37481
#define PRINT_PREVIEW_MEDIA_NA_LETTER_PLUS_8_5X12_69IN 37482
#define PRINT_PREVIEW_MEDIA_NA_MONARCH_3_875X7_5IN 37483
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_9_3_875X8_875IN 37484
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_10_4_125X9_5IN 37485
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_11_4_5X10_375IN 37486
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_12_4_75X11IN 37487
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_14_5X11_5IN 37488
#define PRINT_PREVIEW_MEDIA_NA_OFICIO_8_5X13_4IN 37489
#define PRINT_PREVIEW_MEDIA_NA_PERSONAL_3_625X6_5IN 37490
#define PRINT_PREVIEW_MEDIA_NA_QUARTO_8_5X10_83IN 37491
#define PRINT_PREVIEW_MEDIA_NA_SUPER_A_8_94X14IN 37492
#define PRINT_PREVIEW_MEDIA_NA_SUPER_B_13X19IN 37493
#define PRINT_PREVIEW_MEDIA_NA_WIDE_FORMAT_30X42IN 37494
#define PRINT_PREVIEW_MEDIA_OE_12X16_12X16IN 37495
#define PRINT_PREVIEW_MEDIA_OE_14X17_14X17IN 37496
#define PRINT_PREVIEW_MEDIA_OE_18X22_18X22IN 37497
#define PRINT_PREVIEW_MEDIA_OE_A2PLUS_17X24IN 37498
#define PRINT_PREVIEW_MEDIA_OE_BUSINESS_CARD_2X3_5IN 37499
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_10R_10X12IN 37500
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_12R_12X15IN 37501
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_14X18_14X18IN 37502
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_16R_16X20IN 37503
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_20R_20X24IN 37504
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22R_22X29_5IN 37505
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22X28_22X28IN 37506
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24R_24X31_5IN 37507
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24X30_24X30IN 37508
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_30R_30X40IN 37509
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_L_3_5X5IN 37510
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_S8R_8X12IN 37511
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_4X4IN 37512
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_5X5IN 37513
#define PRINT_PREVIEW_MEDIA_OM_16K_184X260MM 37514
#define PRINT_PREVIEW_MEDIA_OM_16K_195X270MM 37515
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X85MM 37516
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X91MM 37517
#define PRINT_PREVIEW_MEDIA_OM_CARD_54X86MM 37518
#define PRINT_PREVIEW_MEDIA_OM_DAI_PA_KAI_275X395MM 37519
#define PRINT_PREVIEW_MEDIA_OM_DSC_PHOTO_89X119MM 37520
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_210X330MM 37521
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_SP_215X315MM 37522
#define PRINT_PREVIEW_MEDIA_OM_INVITE_220X220MM 37523
#define PRINT_PREVIEW_MEDIA_OM_ITALIAN_110X230MM 37524
#define PRINT_PREVIEW_MEDIA_OM_JUURO_KU_KAI_198X275MM 37525
#define PRINT_PREVIEW_MEDIA_OM_LARGE_PHOTO_200X300 37526
#define PRINT_PREVIEW_MEDIA_OM_MEDIUM_PHOTO_130X180MM 37527
#define PRINT_PREVIEW_MEDIA_OM_PA_KAI_267X389MM 37528
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X40_300X400MM 37529
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X45_300X450MM 37530
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_35X46_350X460MM 37531
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_40X60_400X600MM 37532
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X75_500X750MM 37533
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X76_500X760MM 37534
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_60X90_600X900MM 37535
#define PRINT_PREVIEW_MEDIA_OM_SQUARE_PHOTO_89X89MM 37536
#define PRINT_PREVIEW_MEDIA_OM_WIDE_PHOTO_100X200MM 37537
#define PRINT_PREVIEW_MEDIA_OM_SMALL_PHOTO_100X150MM 37538
#define PRINT_PREVIEW_MEDIA_PRC_16K_146X215MM 37539
#define PRINT_PREVIEW_MEDIA_PRC_1_102X165MM 37540
#define PRINT_PREVIEW_MEDIA_PRC_2_102X176MM 37541
#define PRINT_PREVIEW_MEDIA_PRC_32K_97X151MM 37542
#define PRINT_PREVIEW_MEDIA_PRC_4_110X208MM 37543
#define PRINT_PREVIEW_MEDIA_PRC_6_120X320MM 37544
#define PRINT_PREVIEW_MEDIA_PRC_7_160X230MM 37545
#define PRINT_PREVIEW_MEDIA_PRC_8_120X309MM 37546
#define PRINT_PREVIEW_MEDIA_ROC_16K_7_75X10_75IN 37547
#define PRINT_PREVIEW_MEDIA_ROC_8K_10_75X15_5IN 37548
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_INCHES 37549
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_MM 37550
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_INCHES 37551
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_MM 37552
#define IDS_PRINT_PREVIEW_FRIENDLY_WIN_NETWORK_PRINTER_NAME 37553
#define IDS_PRINT_COMPOSITOR_SERVICE_DISPLAY_NAME 37554
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_TITLE 37958
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_1 37959
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_2 37960
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_3 37961
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_EXPAND_LABEL 37962
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_4 37963
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DECLINE_BUTTON 37964
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_ACCEPT_BUTTON 37965
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_SAVING_LABEL 37966
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_1 37967
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_2 37968
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_3 37969
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_LINK 37970
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_TITLE 37971
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_1 37972
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_1 37973
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_2 37974
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_EXPAND_LABEL 37975
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_2 37976
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_ACK_BUTTON 37977
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_SETTINGS_BUTTON 37978
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_1 37979
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_1 37980
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_2 37981
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_3 37982
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_2 37983
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_DESCRIPTION 37984
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_TITLE 37985
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_1 37986
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_2 37987
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_3 37988
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_ACK_BUTTON 37989
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_SETTINGS_BUTTON 37990
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_TITLE 37991
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_1 37992
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_2 37993
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_3 37994
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_EXPAND_LABEL 37995
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_4 37996
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_ACK_BUTTON 37997
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_SETTINGS_BUTTON 37998
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_1 37999
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_1 38000
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_1 38001
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_2 38002
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_2 38003
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_3 38004
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_2 38005
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_4 38006
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_5 38007
#define IDS_PRIVACY_SANDBOX_M1_DIALOG_MORE_BUTTON 38008
#define IDS_SETTINGS_TOPICS_PAGE_TITLE 38009
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_LABEL 38010
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_SUB_LABEL_V2 38011
#define IDS_SETTINGS_TOPICS_PAGE_DISCLAIMER_DESKTOP 38012
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_CANONICAL 38013
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_DISABLED 38014
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY_TEXT_V2 38015
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY_TEXT_HEADING 38016
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY_TEXT_V2 38017
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY_TEXT_HEADING 38018
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC 38019
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC_A11Y_LABEL 38020
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC 38021
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC_A11Y_LABEL 38022
#define IDS_SETTINGS_TOPICS_PAGE_UNBLOCK_TOPIC_A11Y_LABEL 38023
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_CANONICAL 38024
#define IDS_SETTINGS_TOPICS_PAGE_FIRST_LEVEL_TOPIC_DESCRIPTOR 38025
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_TITLE 38026
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_BODY 38027
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_CLANK_TITLE 38028
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_CLANK_BODY 38029
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_DESCRIPTION 38030
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_LEARN_MORE_LINK 38031
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_DESCRIPTION_LEARN_MORE_ARIA_LABEL 38032
#define IDS_SETTINGS_UNBLOCK_TOPIC_TOAST_BODY 38033
#define IDS_SETTINGS_UNBLOCK_TOPIC_TOAST_BUTTON_TEXT 38034
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER_V2 38035
#define IDS_SETTINGS_UNBLOCK_TOPIC_BUTTON_TEXT_V2 38036
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_HEADING_NEW 38037
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_NEW 38038
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_HEADING 38039
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_DESCRIPTION 38040
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_EXPLANATION 38041
#define IDS_SETTINGS_TOPICS_PAGE_ACTIVE_TOPICS_HEADING 38042
#define IDS_SETTINGS_TOPICS_PAGE_ACTIVE_TOPICS_DESCRIPTION 38043
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_STATUS_LABEL 38044
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TIME_LABEL 38045
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_SOURCE_LABEL 38046
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TEXT_LABEL 38047
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_SETTINGS 38048
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_DEFAULT 38049
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_CONFIRMATION 38050
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_ACTIVE 38051
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_INACTIVE 38052
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_NOT_REQUIRED 38053
#define IDS_PRIVACY_SANDBOX_TOPICS_INVALID_TOPIC 38054
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_1 38055
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_2 38056
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_3 38057
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_4 38058
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_5 38059
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_6 38060
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_7 38061
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_8 38062
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_9 38063
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_10 38064
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_11 38065
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_12 38066
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_13 38067
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_14 38068
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_15 38069
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_16 38070
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_17 38071
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_18 38072
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_19 38073
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_20 38074
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_21 38075
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_22 38076
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_23 38077
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_24 38078
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_25 38079
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_26 38080
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_27 38081
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_28 38082
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_29 38083
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_30 38084
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_31 38085
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_32 38086
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_33 38087
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_34 38088
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_35 38089
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_36 38090
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_37 38091
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_38 38092
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_39 38093
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_40 38094
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_41 38095
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_42 38096
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_43 38097
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_44 38098
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_45 38099
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_46 38100
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_47 38101
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_48 38102
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_49 38103
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_50 38104
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_51 38105
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_52 38106
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_53 38107
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_54 38108
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_55 38109
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_56 38110
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_57 38111
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_58 38112
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_59 38113
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_60 38114
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_61 38115
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_62 38116
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_63 38117
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_64 38118
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_65 38119
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_66 38120
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_67 38121
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_68 38122
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_69 38123
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_70 38124
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_71 38125
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_72 38126
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_73 38127
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_74 38128
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_75 38129
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_76 38130
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_77 38131
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_78 38132
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_79 38133
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_80 38134
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_81 38135
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_82 38136
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_83 38137
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_84 38138
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_85 38139
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_86 38140
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_87 38141
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_88 38142
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_89 38143
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_90 38144
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_91 38145
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_92 38146
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_93 38147
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_94 38148
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_95 38149
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_96 38150
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_97 38151
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_98 38152
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_99 38153
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_100 38154
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_101 38155
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_102 38156
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_103 38157
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_104 38158
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_105 38159
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_106 38160
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_107 38161
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_108 38162
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_109 38163
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_110 38164
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_111 38165
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_112 38166
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_113 38167
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_114 38168
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_115 38169
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_116 38170
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_117 38171
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_118 38172
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_119 38173
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_120 38174
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_121 38175
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_122 38176
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_123 38177
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_124 38178
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_125 38179
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_126 38180
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_127 38181
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_128 38182
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_129 38183
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_130 38184
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_131 38185
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_132 38186
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_133 38187
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_134 38188
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_135 38189
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_136 38190
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_137 38191
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_138 38192
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_139 38193
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_140 38194
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_141 38195
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_142 38196
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_143 38197
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_144 38198
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_145 38199
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_146 38200
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_147 38201
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_148 38202
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_149 38203
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_150 38204
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_151 38205
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_152 38206
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_153 38207
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_154 38208
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_155 38209
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_156 38210
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_157 38211
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_158 38212
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_159 38213
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_160 38214
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_161 38215
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_162 38216
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_163 38217
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_164 38218
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_165 38219
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_166 38220
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_167 38221
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_168 38222
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_169 38223
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_170 38224
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_171 38225
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_172 38226
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_173 38227
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_174 38228
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_175 38229
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_176 38230
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_177 38231
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_178 38232
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_179 38233
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_180 38234
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_181 38235
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_182 38236
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_183 38237
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_184 38238
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_185 38239
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_186 38240
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_187 38241
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_188 38242
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_189 38243
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_190 38244
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_191 38245
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_192 38246
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_193 38247
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_194 38248
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_195 38249
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_196 38250
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_197 38251
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_198 38252
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_199 38253
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_200 38254
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_201 38255
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_202 38256
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_203 38257
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_204 38258
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_205 38259
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_206 38260
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_207 38261
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_208 38262
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_209 38263
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_210 38264
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_211 38265
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_212 38266
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_213 38267
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_214 38268
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_215 38269
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_216 38270
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_217 38271
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_218 38272
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_219 38273
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_220 38274
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_221 38275
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_222 38276
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_223 38277
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_224 38278
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_225 38279
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_226 38280
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_227 38281
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_228 38282
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_229 38283
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_230 38284
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_231 38285
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_232 38286
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_233 38287
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_234 38288
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_235 38289
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_236 38290
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_237 38291
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_238 38292
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_239 38293
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_240 38294
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_241 38295
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_242 38296
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_243 38297
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_244 38298
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_245 38299
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_246 38300
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_247 38301
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_248 38302
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_249 38303
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_250 38304
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_251 38305
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_252 38306
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_253 38307
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_254 38308
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_255 38309
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_256 38310
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_257 38311
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_258 38312
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_259 38313
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_260 38314
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_261 38315
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_262 38316
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_263 38317
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_264 38318
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_265 38319
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_266 38320
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_267 38321
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_268 38322
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_269 38323
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_270 38324
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_271 38325
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_272 38326
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_273 38327
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_274 38328
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_275 38329
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_276 38330
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_277 38331
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_278 38332
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_279 38333
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_280 38334
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_281 38335
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_282 38336
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_283 38337
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_284 38338
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_285 38339
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_286 38340
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_287 38341
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_288 38342
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_289 38343
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_290 38344
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_291 38345
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_292 38346
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_293 38347
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_294 38348
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_295 38349
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_296 38350
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_297 38351
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_298 38352
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_299 38353
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_300 38354
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_301 38355
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_302 38356
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_303 38357
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_304 38358
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_305 38359
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_306 38360
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_307 38361
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_308 38362
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_309 38363
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_310 38364
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_311 38365
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_312 38366
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_313 38367
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_314 38368
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_315 38369
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_316 38370
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_317 38371
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_318 38372
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_319 38373
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_320 38374
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_321 38375
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_322 38376
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_323 38377
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_324 38378
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_325 38379
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_326 38380
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_327 38381
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_328 38382
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_329 38383
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_330 38384
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_331 38385
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_332 38386
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_333 38387
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_334 38388
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_335 38389
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_336 38390
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_337 38391
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_338 38392
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_339 38393
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_340 38394
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_341 38395
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_342 38396
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_343 38397
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_344 38398
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_345 38399
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_346 38400
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_347 38401
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_348 38402
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_349 38403
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_350 38404
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_351 38405
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_352 38406
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_353 38407
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_354 38408
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_355 38409
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_356 38410
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_357 38411
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_358 38412
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_359 38413
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_360 38414
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_361 38415
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_362 38416
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_363 38417
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_364 38418
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_365 38419
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_366 38420
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_367 38421
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_368 38422
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_369 38423
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_370 38424
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_371 38425
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_372 38426
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_373 38427
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_374 38428
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_375 38429
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_376 38430
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_377 38431
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_378 38432
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_379 38433
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_380 38434
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_381 38435
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_382 38436
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_383 38437
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_384 38438
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_385 38439
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_386 38440
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_387 38441
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_388 38442
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_389 38443
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_390 38444
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_391 38445
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_392 38446
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_393 38447
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_394 38448
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_395 38449
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_396 38450
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_397 38451
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_398 38452
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_399 38453
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_400 38454
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_401 38455
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_402 38456
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_403 38457
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_404 38458
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_405 38459
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_406 38460
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_407 38461
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_408 38462
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_409 38463
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_410 38464
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_411 38465
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_412 38466
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_413 38467
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_414 38468
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_415 38469
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_416 38470
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_417 38471
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_418 38472
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_419 38473
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_420 38474
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_421 38475
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_422 38476
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_423 38477
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_424 38478
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_425 38479
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_426 38480
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_427 38481
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_428 38482
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_429 38483
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_430 38484
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_431 38485
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_432 38486
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_433 38487
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_434 38488
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_435 38489
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_436 38490
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_437 38491
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_438 38492
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_439 38493
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_440 38494
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_441 38495
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_442 38496
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_443 38497
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_444 38498
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_445 38499
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_446 38500
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_447 38501
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_448 38502
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_449 38503
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_450 38504
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_451 38505
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_452 38506
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_453 38507
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_454 38508
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_455 38509
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_456 38510
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_457 38511
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_458 38512
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_459 38513
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_460 38514
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_461 38515
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_462 38516
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_463 38517
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_464 38518
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_465 38519
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_466 38520
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_467 38521
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_468 38522
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_469 38523
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_470 38524
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_471 38525
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_472 38526
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_473 38527
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_474 38528
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_475 38529
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_476 38530
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_477 38531
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_478 38532
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_479 38533
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_480 38534
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_481 38535
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_482 38536
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_483 38537
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_484 38538
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_485 38539
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_486 38540
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_487 38541
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_488 38542
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_489 38543
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_490 38544
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_491 38545
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_492 38546
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_493 38547
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_494 38548
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_495 38549
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_496 38550
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_497 38551
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_498 38552
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_499 38553
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_500 38554
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_501 38555
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_502 38556
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_503 38557
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_504 38558
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_505 38559
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_506 38560
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_507 38561
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_508 38562
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_509 38563
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_510 38564
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_511 38565
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_512 38566
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_513 38567
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_514 38568
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_515 38569
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_516 38570
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_517 38571
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_518 38572
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_519 38573
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_520 38574
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_521 38575
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_522 38576
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_523 38577
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_524 38578
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_525 38579
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_526 38580
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_527 38581
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_528 38582
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_529 38583
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_530 38584
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_531 38585
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_532 38586
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_533 38587
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_534 38588
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_535 38589
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_536 38590
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_537 38591
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_538 38592
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_539 38593
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_540 38594
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_541 38595
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_542 38596
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_543 38597
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_544 38598
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_545 38599
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_546 38600
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_547 38601
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_548 38602
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_549 38603
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_550 38604
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_551 38605
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_552 38606
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_553 38607
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_554 38608
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_555 38609
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_556 38610
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_557 38611
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_558 38612
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_559 38613
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_560 38614
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_561 38615
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_562 38616
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_563 38617
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_564 38618
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_565 38619
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_566 38620
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_567 38621
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_568 38622
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_569 38623
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_570 38624
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_571 38625
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_572 38626
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_573 38627
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_574 38628
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_575 38629
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_576 38630
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_577 38631
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_578 38632
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_579 38633
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_580 38634
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_581 38635
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_582 38636
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_583 38637
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_584 38638
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_585 38639
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_586 38640
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_587 38641
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_588 38642
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_589 38643
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_590 38644
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_591 38645
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_592 38646
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_593 38647
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_594 38648
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_595 38649
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_596 38650
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_597 38651
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_598 38652
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_599 38653
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_600 38654
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_601 38655
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_602 38656
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_603 38657
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_604 38658
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_605 38659
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_606 38660
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_607 38661
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_608 38662
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_609 38663
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_610 38664
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_611 38665
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_612 38666
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_613 38667
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_614 38668
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_615 38669
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_616 38670
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_617 38671
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_618 38672
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_619 38673
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_620 38674
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_621 38675
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_622 38676
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_623 38677
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_624 38678
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_625 38679
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_626 38680
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_627 38681
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_628 38682
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_629 38683
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_DESCRIPTION 38684
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_ONE_TITLE 38685
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_ONE_DESCRIPTION 38686
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_TWO_TITLE 38687
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_TWO_DESCRIPTION 38688
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_ADVANCED_CATEGORY 38689
#define IDS_TRACKING_PROTECTION_BLOCK_COOKIES_TOGGLE_TITLE 38690
#define IDS_TRACKING_PROTECTION_BLOCK_COOKIES_TOGGLE_SUMMARY 38691
#define IDS_TRACKING_PROTECTION_ALLOWED_GROUP_TITLE 38692
#define IDS_TRACKING_PROTECTION_ALLOWED_GROUP_DESCRIPTION 38693
#define IDS_TRACKING_PROTECTION_NEVER_EXPIRES_LABEL 38694
#define IDS_TRACKING_PROTECTION_EXPIRES_TODAY_LABEL 38695
#define IDS_TRACKING_PROTECTION_EXPIRES_LABEL 38696
#define IDS_TRACKING_PROTECTION_DELETE_SITE_LABEL 38697
#define IDS_REGISTER_PROTOCOL_HANDLER_TOOLTIP 441
#define IDS_REGISTER_PROTOCOL_HANDLER_MAILTO_NAME 38698
#define IDS_REGISTER_PROTOCOL_HANDLER_WEBCAL_NAME 38699
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM 38700
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE 38701
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_FRAGMENT 38702
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE_FRAGMENT 38703
#define IDS_REGISTER_PROTOCOL_HANDLER_ACCEPT 38704
#define IDS_REGISTER_PROTOCOL_HANDLER_DENY 38705
#define IDS_REGISTER_PROTOCOL_HANDLER_IGNORE 38706
#define IDS_RESET_PASSWORD_TITLE 38707
#define IDS_RESET_PASSWORD_WARNING_HEADING 38708
#define IDS_RESET_PASSWORD_WARNING_HEADING_V2 38709
#define IDS_RESET_PASSWORD_WARNING_HEADING_WITH_ORG_NAME 38710
#define IDS_RESET_PASSWORD_HEADING 38711
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH 38712
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_V2 38713
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 38714
#define IDS_RESET_PASSWORD_BUTTON 38715
#define IDS_RESET_PASSWORD_LEARN_MORE 38716
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH 38717
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 38718
#define IDS_SAVED_TAB_GROUPS_CREATION_JUST_NOW 38719
#define IDS_SAVED_TAB_GROUPS_CREATION_MINUTES_AGO_FORMAT 38720
#define IDS_SAVED_TAB_GROUPS_CREATION_HOURS_AGO_FORMAT 38721
#define IDS_SAVED_TAB_GROUPS_CREATION_DAYS_AGO_FORMAT 38722
#define IDS_SAVED_TAB_GROUPS_CREATION_MONTHS_AGO_FORMAT 38723
#define IDS_SAVED_TAB_GROUPS_CREATION_YEARS_AGO_FORMAT 38724
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_SUBTITLE 38725
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_SUBTITLE_NON_EEA 38726
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_CHANGE_DEFAULT_ENGINE 38727
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_CONFIRMATION_TOAST_LABEL 38728
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_ENTRY_POINT_SUBTITLE 38729
#define IDS_SEARCH_ENGINE_CHOICE_BUTTON_TITLE 38730
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_TITLE 38731
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE 38732
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_INFO_LINK 38733
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_INFO_LINK_A11Y_LABEL 38734
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_WITH_DEFINITION1 38735
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_WITH_DEFINITION2 38736
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_TITLE 38740
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_FIRST_PARAGRAPH 38741
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_SECOND_PARAGRAPH 38742
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_THIRD_PARAGRAPH 38743
#define IDS_SEARCH_ENGINE_FALLBACK_MARKETING_SNIPPET 38744
#define IDS_SEARCH_ENGINE_CHOICE_MORE_BUTTON 38745
#define IDS_SEARCH_ENGINE_CHOICE_CONTINUE_BUTTON 38746
#define IDS_SEARCH_ENGINE_CHOICE_CHEVRON_A11Y_LABEL 38747
#define IDS_SEARCH_ENGINE_CHOICE_LIST_A11Y_LABEL 38748
#define IDS_SEARCH_ENGINE_CHOICE_GUEST_SESSION_CHECKBOX 38749
#define IDS_SSL_OPEN_DETAILS_BUTTON 38750
#define IDS_SSL_CLOSE_DETAILS_BUTTON 38751
#define IDS_CAPTIVE_PORTAL_AUTHORIZATION_DIALOG_NAME 38752
#define IDS_CAPTIVE_PORTAL_HEADING_WIRED 38753
#define IDS_CAPTIVE_PORTAL_HEADING_WIFI 38754
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIRED 38755
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI 38756
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI_SSID 38757
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIRED 38758
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI 38759
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI_SSID 38760
#define IDS_CAPTIVE_PORTAL_BUTTON_OPEN_LOGIN_PAGE 38761
#define IDS_MITM_SOFTWARE_HEADING 38762
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_ENTERPRISE 38763
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_NONENTERPRISE 38764
#define IDS_MITM_SOFTWARE_EXPLANATION_ENTERPRISE 38765
#define IDS_MITM_SOFTWARE_EXPLANATION_NONENTERPRISE 38766
#define IDS_MITM_SOFTWARE_EXPLANATION 38767
#define IDS_LOOKALIKE_URL_TITLE 38768
#define IDS_LOOKALIKE_URL_HEADING 38769
#define IDS_LOOKALIKE_URL_IGNORE 38770
#define IDS_LOOKALIKE_URL_CONTINUE 38771
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH 38772
#define IDS_LOOKALIKE_URL_HEADING_NO_SUGGESTED_URL 38773
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH_NO_SUGGESTED_URL 38774
#define IDS_LOOKALIKE_URL_BACK_TO_SAFETY 38775
#define IDS_LOOKALIKE_URL_CLOSE_PAGE 38776
#define IDS_ENTERPRISE_BLOCK_TITLE 38777
#define IDS_ENTERPRISE_BLOCK_HEADING 38778
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH 38779
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH_CUSTOM_MESSAGE 38780
#define IDS_ENTERPRISE_BLOCK_GO_BACK 38781
#define IDS_ENTERPRISE_WARN_TITLE 38782
#define IDS_ENTERPRISE_WARN_HEADING 38783
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH 38784
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH_CUSTOM_MESSAGE 38785
#define IDS_ENTERPRISE_WARN_GO_BACK 38786
#define IDS_ENTERPRISE_WARN_CONTINUE_TO_SITE 38787
#define IDS_ENTERPRISE_INTERSTITIALS_LEARN_MORE_ACCCESSIBILITY_TEXT 38788
#define IDS_CLOCK_ERROR_TITLE 38789
#define IDS_CLOCK_ERROR_AHEAD_HEADING 38790
#define IDS_CLOCK_ERROR_BEHIND_HEADING 38791
#define IDS_CLOCK_ERROR_UPDATE_DATE_AND_TIME 38792
#define IDS_CLOCK_ERROR_PRIMARY_PARAGRAPH 38793
#define IDS_CLOCK_ERROR_EXPLANATION 38794
#define IDS_SSL_V2_TITLE 38795
#define IDS_SSL_V2_HEADING 38796
#define IDS_SSL_V2_PRIMARY_PARAGRAPH 38797
#define IDS_SSL_OVERRIDABLE_SAFETY_BUTTON 38798
#define IDS_SSL_OVERRIDABLE_CLOSE_PAGE_BUTTON 38799
#define IDS_SSL_OVERRIDABLE_PROCEED_PARAGRAPH 38800
#define IDS_SSL_RELOAD 38801
#define IDS_SSL_NONOVERRIDABLE_PINNED 38802
#define IDS_SSL_NONOVERRIDABLE_HSTS 38803
#define IDS_SSL_NONOVERRIDABLE_REVOKED 38804
#define IDS_SSL_NONOVERRIDABLE_MORE 38805
#define IDS_SSL_NONOVERRIDABLE_INVALID 38806
#define IDS_SAFEBROWSING_V3_TITLE 38807
#define IDS_SAFEBROWSING_V3_OPEN_DETAILS_BUTTON 38808
#define IDS_SAFEBROWSING_V3_CLOSE_DETAILS_BUTTON 38809
#define IDS_SAFEBROWSING_OVERRIDABLE_SAFETY_BUTTON 38810
#define IDS_SAFEBROWSING_HEADING 38811
#define IDS_MALWARE_V3_PRIMARY_PARAGRAPH 38812
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH 38813
#define IDS_MALWARE_V3_PROCEED_PARAGRAPH 38814
#define IDS_SAFE_BROWSING_SCOUT_REPORTING_AGREE 38815
#define IDS_SAFE_BROWSING_ENHANCED_PROTECTION_MESSAGE 38816
#define IDS_HARMFUL_V3_PRIMARY_PARAGRAPH 38817
#define IDS_HARMFUL_V3_EXPLANATION_PARAGRAPH 38818
#define IDS_HARMFUL_V3_PROCEED_PARAGRAPH 38819
#define IDS_PHISHING_V4_PRIMARY_PARAGRAPH 38820
#define IDS_PHISHING_V4_EXPLANATION_PARAGRAPH 38821
#define IDS_PHISHING_V4_PROCEED_PARAGRAPH 38822
#define IDS_MALWARE_WEBVIEW_HEADING 38823
#define IDS_MALWARE_WEBVIEW_EXPLANATION_PARAGRAPH 38824
#define IDS_PHISHING_WEBVIEW_HEADING 38825
#define IDS_PHISHING_WEBVIEW_EXPLANATION_PARAGRAPH 38826
#define IDS_HARMFUL_WEBVIEW_HEADING 38827
#define IDS_HARMFUL_WEBVIEW_EXPLANATION_PARAGRAPH 38828
#define IDS_BILLING_WEBVIEW_HEADING 38829
#define IDS_BILLING_WEBVIEW_EXPLANATION_PARAGRAPH 38830
#define IDS_SUPERVISED_USER_URL_BLOCKED_MESSAGE 38831
#define IDS_SUPERVISED_USER_LEARN_MORE 38832
#define IDS_CONNECTION_HELP_SHOW_MORE 38833
#define IDS_CONNECTION_HELP_SHOW_LESS 38834
#define IDS_CONNECTION_HELP_TITLE 38835
#define IDS_CONNECTION_HELP_HEADING 38836
#define IDS_CONNECTION_HELP_GENERAL_HELP 38837
#define IDS_CONNECTION_HELP_SPECIFIC_ERROR_HEADING 38838
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_TITLE 38839
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_TITLE 38840
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_TITLE 38841
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_DETAILS 38842
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_DETAILS 38843
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_DETAILS 38844
#define IDS_CONNECTION_HELP_MITM_SOFTWARE_TITLE 38845
#define IDS_CONNECTION_HELP_MITM_SOFTWARE_DETAILS 38846
#define IDS_BILLING_TITLE 38847
#define IDS_BILLING_HEADING 38848
#define IDS_BILLING_PRIMARY_PARAGRAPH 38849
#define IDS_BILLING_PRIMARY_BUTTON 38850
#define IDS_BILLING_PROCEED_BUTTON 38851
#define IDS_BLOCKED_INTERCEPTION_HEADING 38852
#define IDS_KNOWN_INTERCEPTION_TITLE 38853
#define IDS_KNOWN_INTERCEPTION_HEADER 38854
#define IDS_KNOWN_INTERCEPTION_BODY1 38855
#define IDS_KNOWN_INTERCEPTION_BODY2 38856
#define IDS_KNOWN_INTERCEPTION_INFOBAR_HEADING 38857
#define IDS_KNOWN_INTERCEPTION_INFOBAR_BUTTON_TEXT 38858
#define IDS_LEGACY_TLS_HEADING 38859
#define IDS_LEGACY_TLS_PRIMARY_PARAGRAPH 38860
#define IDS_LEGACY_TLS_EXPLANATION 38861
#define IDS_INSECURE_FORM_TITLE 38862
#define IDS_INSECURE_FORM_HEADING 38863
#define IDS_INSECURE_FORM_PRIMARY_PARAGRAPH 38864
#define IDS_INSECURE_FORM_BACK_BUTTON 38865
#define IDS_INSECURE_FORM_SUBMIT_BUTTON 38866
#define IDS_HTTPS_ONLY_MODE_TITLE 38867
#define IDS_HTTPS_ONLY_MODE_HEADING 38868
#define IDS_HTTPS_ONLY_MODE_PRIMARY_PARAGRAPH 38869
#define IDS_HTTPS_ONLY_BALANCED_MODE_HEADING 38870
#define IDS_HTTPS_ONLY_BALANCED_MODE_PRIMARY_PARAGRAPH 38871
#define IDS_HTTPS_ONLY_MODE_WITH_ADVANCED_PROTECTION_PRIMARY_PARAGRAPH 38872
#define IDS_HTTPS_ONLY_MODE_WITH_SITE_ENGAGEMENT_PRIMARY_PARAGRAPH 38874
#define IDS_HTTPS_ONLY_MODE_FOR_TYPICALLY_SECURE_BROWSING_PRIMARY_PARAGRAPH 38875
#define IDS_HTTPS_ONLY_MODE_FOR_INCOGNITO_PRIMARY_PARAGRAPH 38876
#define IDS_HTTPS_ONLY_MODE_BACK_BUTTON 38877
#define IDS_HTTPS_ONLY_MODE_SUBMIT_BUTTON 38878
#define IDS_ABH_PROMPT_TITLE 38879
#define IDS_ABH_PROMPT_BALANCED_MODE_FIRST_ITEM_TEXT 38880
#define IDS_ABH_PROMPT_BALANCED_MODE_SECOND_ITEM_TEXT 38881
#define IDS_ABH_PROMPT_SECONDARY_TEXT 38882
#define IDS_ABH_PROMPT_LEARN_MORE_LINK 38883
#define IDS_ABH_PROMPT_SITE_ENGAGEMENT_PRIMARY_PARAGRAPH 38884
#define IDS_ABH_PROMPT_TYPICALLY_SECURE_BROWSING_PRIMARY_PARAGRAPH 38885
#define IDS_ABH_PROMPT_INCOGNITO_PRIMARY_PARAGRAPH 38886
#define IDS_ABH_PROMPT_ADVANCED_PROTECTION_PRIMARY_PARAGRAPH 38887
#define IDS_SHARING_DEVICE_TYPE_COMPUTER 38888
#define IDS_SHARING_DEVICE_TYPE_DEVICE 38889
#define IDS_SHARING_DEVICE_TYPE_PHONE 38890
#define IDS_SHARING_DEVICE_TYPE_TABLET 38891
#define IDS_SEND_TAB_PUSH_NOTIFICATION_TITLE_DEAULT_DEVICE_NAME 38892
#define IDS_SEND_TAB_PUSH_NOTIFICATION_TITLE_USER_GIVEN_DEVICE_NAME 38893
#define IDS_SEND_TAB_PUSH_NOTIFICATION_BODY 38894
#define IDS_SEND_TAB_PUSH_NOTIFICATION_PLACEHOLDER_TITLE 38895
#define IDS_SEND_TAB_PUSH_NOTIFICATION_PLACEHOLDER_BODY 38896
#define IDS_SITE_SETTINGS_TYPE_ADS 38897
#define IDS_SITE_SETTINGS_TYPE_ADS_MID_SENTENCE 38898
#define IDS_SITE_SETTINGS_TYPE_ANTI_ABUSE 38899
#define IDS_SITE_SETTINGS_TYPE_AR 38900
#define IDS_SITE_SETTINGS_TYPE_AR_MID_SENTENCE 38901
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS 38902
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS_MID_SENTENCE 38903
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_FULLSCREEN 38904
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_FULLSCREEN_MID_SENTENCE 38905
#define IDS_SITE_SETTINGS_TYPE_AUTO_PICTURE_IN_PICTURE 38906
#define IDS_SITE_SETTINGS_TYPE_AUTO_PICTURE_IN_PICTURE_MID_SENTENCE 38907
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC 38908
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC_MID_SENTENCE 38909
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES 38910
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES_MID_SENTENCE 38911
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING 38912
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING_MID_SENTENCE 38913
#define IDS_SITE_SETTINGS_TYPE_CAMERA 38914
#define IDS_SITE_SETTINGS_TYPE_CAMERA_MID_SENTENCE 38915
#define IDS_SITE_SETTINGS_TYPE_CAMERA_WITH_COUNT 38916
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM 38917
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_MID_SENTENCE 38918
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_WITH_COUNT 38919
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL 38920
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_MID_SENTENCE 38921
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_SHARED_TABS 38922
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_SHARED_TABS_MID_SENTENCE 38923
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_SUB_MENU 38924
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD 38925
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD_MID_SENTENCE 38926
#define IDS_SITE_SETTINGS_TYPE_COOKIES 38927
#define IDS_SITE_SETTINGS_TYPE_COOKIES_MID_SENTENCE 38928
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API 38929
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API_MID_SENTENCE 38930
#define IDS_SITE_SETTINGS_TYPE_HAND_TRACKING 38931
#define IDS_SITE_SETTINGS_TYPE_HAND_TRACKING_MID_SENTENCE 38932
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION 38933
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION_MID_SENTENCE 38934
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT 38935
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_MID_SENTENCE 38936
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_OPTIMIZER 38937
#define IDS_SITE_SETTINGS_TYPE_LOCATION 38938
#define IDS_SITE_SETTINGS_TYPE_LOCATION_MID_SENTENCE 38939
#define IDS_SITE_SETTINGS_TYPE_MIC 38940
#define IDS_SITE_SETTINGS_TYPE_MIC_MID_SENTENCE 38941
#define IDS_SITE_SETTINGS_TYPE_MIC_WITH_COUNT 38942
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX 38943
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX_MID_SENTENCE 38944
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS 38945
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS_MID_SENTENCE 38946
#define IDS_SITE_SETTINGS_TYPE_NFC 38947
#define IDS_SITE_SETTINGS_TYPE_NFC_MID_SENTENCE 38948
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS 38949
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS_MID_SENTENCE 38950
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS 38951
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS_MID_SENTENCE 38952
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID 38953
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID_MID_SENTENCE 38954
#define IDS_SITE_SETTINGS_TYPE_SENSORS 38955
#define IDS_SITE_SETTINGS_TYPE_SENSORS_MID_SENTENCE 38956
#define IDS_SITE_SETTINGS_TYPE_SOUND 38957
#define IDS_SITE_SETTINGS_TYPE_SOUND_MID_SENTENCE 38958
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES 38959
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES_MID_SENTENCE 38960
#define IDS_SITE_SETTINGS_TYPE_VR 38961
#define IDS_SITE_SETTINGS_TYPE_VR_MID_SENTENCE 38962
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS 38963
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS_MID_SENTENCE 38964
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE 38965
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE_MID_SENTENCE 38966
#define IDS_SITE_SETTINGS_TYPE_LOCAL_NETWORK_ACCESS 38967
#define IDS_SITE_SETTINGS_TYPE_LOCAL_NETWORK_ACCESS_MID_SENTENCE 38968
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT 38969
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT_MID_SENTENCE 38970
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS 38971
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS_MID_SENTENCE 38972
#define IDS_SITE_SETTINGS_TYPE_HANDLERS 38973
#define IDS_SITE_SETTINGS_TYPE_HANDLERS_MID_SENTENCE 38974
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES 38975
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES_MID_SENTENCE 38976
#define IDS_SITE_SETTINGS_TYPE_IMAGES 38977
#define IDS_SITE_SETTINGS_TYPE_IMAGES_MID_SENTENCE 38978
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT 38979
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT_MID_SENTENCE 38980
#define IDS_SITE_SETTINGS_TYPE_KEYBOARD_LOCK 38981
#define IDS_SITE_SETTINGS_TYPE_KEYBOARD_LOCK_MID_SENTENCE 38982
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER 38983
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER_MID_SENTENCE 38984
#define IDS_SITE_SETTINGS_TYPE_PDF_DOCUMENTS 38985
#define IDS_SITE_SETTINGS_TYPE_POINTER_LOCK 38986
#define IDS_SITE_SETTINGS_TYPE_POINTER_LOCK_MID_SENTENCE 38987
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS 38988
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS_MID_SENTENCE 38989
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS 38991
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS_MID_SENTENCE 38992
#define IDS_SITE_SETTINGS_TYPE_WEB_APP_INSTALLATION 38993
#define IDS_SITE_SETTINGS_TYPE_WEB_APP_INSTALLATION_MID_SENTENCE 38994
#define IDS_SITE_SETTINGS_TYPE_WEB_PRINTING 38995
#define IDS_SITE_SETTINGS_TYPE_WEB_PRINTING_MID_SENTENCE 38996
#define IDS_SITE_SETTINGS_TYPE_PERFORMANCE 38997
#define IDS_SITE_SETTINGS_TYPE_PERFORMANCE_SUBLABEL 38998
#define IDS_SITE_SETTINGS_TYPE_OFFER_WRITING_HELP 38999
#define IDS_SMS_INFOBAR_TITLE 39000
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED 39001
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED_FROM_EMBEDDED_FRAME 39002
#define IDS_SMS_INFOBAR_BUTTON_OK 39003
#define IDS_CERT_ERROR_NO_SUBJECT_ALTERNATIVE_NAMES_DETAILS 39004
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DETAILS 39005
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DESCRIPTION 39006
#define IDS_CERT_ERROR_EXPIRED_DETAILS 39007
#define IDS_CERT_ERROR_EXPIRED_DESCRIPTION 39008
#define IDS_CERT_ERROR_NOT_YET_VALID_DETAILS 39009
#define IDS_CERT_ERROR_NOT_YET_VALID_DESCRIPTION 39010
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DETAILS 39011
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DESCRIPTION 39012
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DESCRIPTION 39013
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DETAILS 39014
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DESCRIPTION 39015
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DETAILS 39016
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DESCRIPTION 39017
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DETAILS 39018
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DESCRIPTION 39019
#define IDS_CERT_ERROR_REVOKED_CERT_DETAILS 39020
#define IDS_CERT_ERROR_REVOKED_CERT_DESCRIPTION 39021
#define IDS_CERT_ERROR_INVALID_CERT_DETAILS 39022
#define IDS_CERT_ERROR_INVALID_CERT_DESCRIPTION 39023
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DETAILS 39024
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DESCRIPTION 39025
#define IDS_CERT_ERROR_WEAK_KEY_DETAILS 39026
#define IDS_CERT_ERROR_WEAK_KEY_DESCRIPTION 39027
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DETAILS 39028
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DESCRIPTION 39029
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DETAILS 39030
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DESCRIPTION 39031
#define IDS_CERT_ERROR_NON_UNIQUE_NAME_DETAILS 39032
#define IDS_CERT_ERROR_NON_UNIQUE_NAME_DESCRIPTION 39033
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DETAILS 39034
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DESCRIPTION 39035
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DETAILS 39036
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DESCRIPTION 39037
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DETAILS 39038
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DESCRIPTION 39039
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DETAILS 39040
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DESCRIPTION 39041
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DETAILS 39042
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DETAILS_V2 39043
#define IDS_ALWAYS_ALLOW_ADS 39044
#define IDS_BLOCKED_ADS_PROMPT_EXPLANATION 39045
#define IDS_BLOCKED_ADS_PROMPT_TITLE 39046
#define IDS_BLOCK_INTERSTITIAL_TITLE 39053
#define IDS_CHILD_BLOCK_INTERSTITIAL_HEADER 39054
#define IDS_BLOCK_INTERSTITIAL_HEADER_ACCESS_REQUESTS_DISABLED 39055
#define IDS_CHILD_BLOCK_INTERSTITIAL_MESSAGE_V2 39056
#define IDS_SUPERVISED_USER_INTERSTITIAL_MESSAGE_BLOCK_ALL 39057
#define IDS_SUPERVISED_USER_INTERSTITIAL_MESSAGE_SAFE_SITES 39058
#define IDS_SUPERVISED_USER_INTERSTITIAL_MESSAGE_MANUAL 39059
#define IDS_CHILD_BLOCK_INTERSTITIAL_MESSAGE_NOT_SIGNED_IN 39060
#define IDS_REQUEST_SENT_OK 39061
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_BUTTON 39062
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_INSTEAD_BUTTON 39063
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_A_MESSAGE_BUTTON 39064
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_MESSAGE 39065
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_SINGLE_PARENT 39066
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_MULTI_PARENT 39067
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_SINGLE_PARENT 39068
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_MULTI_PARENT 39069
#define IDS_BLOCK_INTERSTITIAL_SHOW_DETAILS 39070
#define IDS_BLOCK_INTERSTITIAL_HIDE_DETAILS 39071
#define IDS_GENERIC_SITE_BLOCK_HEADER 39072
#define IDS_SUPERVISED_USER_BLOCK_HEADER 39073
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_SINGLE_PARENT 39074
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_MULTI_PARENT 39075
#define IDS_SUPERVISED_USER_BLOCK_MESSAGE_SAFE_SITES 39076
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_SINGLE_PARENT 39077
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_MULTI_PARENT 39078
#define IDS_SUPERVISED_USER_VERIFY_PAGE_TAB_TITLE 39079
#define IDS_SUPERVISED_USER_VERIFY_PAGE_PRIMARY_HEADING 39080
#define IDS_SUPERVISED_USER_VERIFY_PAGE_PRIMARY_PARAGRAPH 39081
#define IDS_SUPERVISED_USER_VERIFY_PAGE_PRIMARY_BUTTON 39082
#define IDS_SUPERVISED_USER_VERIFY_PAGE_SUBFRAME_YOUTUBE_HEADING 39083
#define IDS_SUPERVISED_USER_VERIFY_PAGE_SUBFRAME_BLOCKED_SITE_HEADING 39084
#define IDS_PARENT_WEBSITE_APPROVAL_BLOCK_ALL_URL 39085
#define IDS_PARENT_WEBSITE_APPROVAL_SAFE_SITES_URL 39086
#define IDS_PARENT_WEBSITE_APPROVAL_MANUAL_URL 39087
#define IDS_PARENT_WEBSITE_APPROVAL_DIALOG_A11Y_NAME 39088
#define IDS_PARENTAL_LOCAL_APPROVAL_DIALOG_GENERIC_ERROR_TITLE 39089
#define IDS_PARENTAL_LOCAL_APPROVAL_DIALOG_GENERIC_ERROR_DESCRIPTION 39090
#define IDS_PARENTAL_LOCAL_APPROVAL_DIALOG_GENERIC_ERROR_BACK_BUTTON 39091
#define IDS_PARENTAL_LOCAL_APPROVAL_SNACKBAR_GENERIC_ERROR_TITLE 39092
#define IDS_PARENTAL_LOCAL_APPROVAL_SNACKBAR_GENERIC_ERROR_BACK_BUTTON 39093
#define IDS_SYNC_BASIC_ENCRYPTION_DATA 39097
#define IDS_SYNC_DATATYPE_AUTOFILL 39098
#define IDS_SYNC_DATATYPE_BOOKMARKS 39099
#define IDS_SYNC_DATATYPE_PASSWORDS 39100
#define IDS_SYNC_DATATYPE_PASSWORDS_AND_PASSKEYS 39101
#define IDS_SYNC_DATATYPE_PREFERENCES 39102
#define IDS_SYNC_DATATYPE_TABS 39103
#define IDS_SYNC_DATATYPE_TYPED_URLS 39104
#define IDS_SYNC_DATATYPE_HISTORY_AND_TABS 39105
#define IDS_SYNC_DATATYPE_READING_LIST 39106
#define IDS_SYNC_EMPTY_PASSPHRASE_ERROR 39107
#define IDS_SYNC_ENCRYPTION_SECTION_TITLE 39108
#define IDS_SYNC_FULL_ENCRYPTION_DATA 39109
#define IDS_SYNC_LOGIN_SETTING_UP 39110
#define IDS_SYNC_PASSPHRASE_LABEL 39111
#define IDS_SYNC_PASSPHRASE_MISMATCH_ERROR 39112
#define IDS_SYNC_ENTER_PASSPHRASE_BODY_WITH_DATE 39113
#define IDS_SYNC_ENTER_PASSPHRASE_BODY 39114
#define IDS_BULK_UPLOAD_SUBTITLE 39115
#define IDS_BULK_UPLOAD_BOOKMARK_FOLDER_SUBTITLE 39116
#define IDS_TAB_GROUP_COLOR_GREY 39117
#define IDS_TAB_GROUP_COLOR_BLUE 39118
#define IDS_TAB_GROUP_COLOR_RED 39119
#define IDS_TAB_GROUP_COLOR_YELLOW 39120
#define IDS_TAB_GROUP_COLOR_GREEN 39121
#define IDS_TAB_GROUP_COLOR_PINK 39122
#define IDS_TAB_GROUP_COLOR_PURPLE 39123
#define IDS_TAB_GROUP_COLOR_CYAN 39124
#define IDS_TAB_GROUP_COLOR_ORANGE 39125
#define IDS_TAB_RESUME_DECORATORS_VISITED_X_AGO 39126
#define IDS_TAB_RESUME_DECORATORS_VISITED_RECENTLY 39127
#define IDS_TAB_RESUME_DECORATORS_FREQUENTLY_VISITED 39128
#define IDS_TAB_RESUME_DECORATORS_CONTINUE_READING 39129
#define IDS_TAB_RESUME_DECORATORS_MOST_RECENT 39130
#define IDS_TAB_RESUME_DECORATORS_TIME_OF_DAY 39131
#define IDS_TAB_RESUME_DECORATORS_VISITED_X_AGO_IOS 39132
#define IDS_TAB_RESUME_DECORATORS_VISITED_RECENTLY_IOS 39133
#define IDS_TAB_RESUME_DECORATORS_FREQUENTLY_VISITED_IOS 39134
#define IDS_TAB_RESUME_DECORATORS_MOST_RECENT_IOS 39135
#define IDS_TAB_RESUME_N_MINUTES_AGO_NARROW 39136
#define IDS_TAB_RESUME_N_HOURS_AGO_NARROW 39137
#define IDS_TRANSLATE_NOTIFICATION_UNDO 39153
#define IDS_TRANSLATE_DETECTED_LANGUAGE 39154
#define IDS_BOOKMARK_BAR_UNDO 39155
#define IDS_BOOKMARK_BAR_REDO 39156
#define IDS_BOOKMARK_BAR_UNDO_ADD 39157
#define IDS_BOOKMARK_BAR_REDO_ADD 39158
#define IDS_BOOKMARK_BAR_UNDO_DELETE 39159
#define IDS_BOOKMARK_BAR_REDO_DELETE 39160
#define IDS_BOOKMARK_BAR_UNDO_EDIT 39161
#define IDS_BOOKMARK_BAR_REDO_EDIT 39162
#define IDS_BOOKMARK_BAR_UNDO_MOVE 39163
#define IDS_BOOKMARK_BAR_REDO_MOVE 39164
#define IDS_BOOKMARK_BAR_UNDO_REORDER 39165
#define IDS_BOOKMARK_BAR_REDO_REORDER 39166
#define IDS_IMPORTED_FROM_SAFARI_FOLDER 39167
#define IDS_IMPORTED_FOLDER 39168
#define IDS_CLOSE_TUTORIAL 39169
#define IDS_CLOSE_PROMO 39170
#define IDS_HELP_BUBBLE 39171
#define IDS_PROMO_DISMISS_BUTTON 39172
#define IDS_PROMO_SNOOZE_BUTTON 39173
#define IDS_PROMO_SHOW_TUTORIAL_BUTTON 385
#define IDS_TUTORIAL_RESTART_TUTORIAL 39174
#define IDS_PROMO_LEARN_MORE_BUTTON 39175
#define IDS_TUTORIAL_CLOSE_TUTORIAL 39176
#define IDS_TUTORIAL_NEXT_BUTTON 39177
#define IDS_PROMO_MANAGE_BUTTON 39178
#define IDS_VERSION_UI_TITLE 39179
#define IDS_VERSION_UI_OFFICIAL 39180
#define IDS_VERSION_UI_UNOFFICIAL 39181
#define IDS_VERSION_UI_32BIT 39182
#define IDS_VERSION_UI_64BIT 39183
#define IDS_VERSION_UI_64BIT_ARM 39186
#define IDS_VERSION_UI_32BIT_TRANSLATED_INTEL 39187
#define IDS_VERSION_UI_64BIT_TRANSLATED_INTEL 39185
#define IDS_VERSION_UI_REVISION 39188
#define IDS_VERSION_UI_OS 39189
#define IDS_VERSION_UI_USER_AGENT 39191
#define IDS_VERSION_UI_COMMAND_LINE 39192
#define IDS_VERSION_UI_COPY_LABEL 39196
#define IDS_VERSION_UI_COPY_NOTICE 39197
#define IDS_VERSION_UI_EXECUTABLE_PATH 39198
#define IDS_VERSION_UI_PROFILE_PATH 39199
#define IDS_VERSION_UI_MODULE_PATH 39200
#define IDS_VERSION_UI_USER_DATA_PATH 39201
#define IDS_VERSION_UI_PATH_NOTFOUND 39202
#define IDS_VERSION_UI_VARIATIONS 39203
#define IDS_VERSION_UI_VARIATIONS_SEED_NAME 39204
#define IDS_VERSION_UI_VARIATIONS_CMD 39205
#define IDS_VERSION_UI_COPY_VARIATIONS_LABEL 39206
#define IDS_VERSION_UI_COPY_VARIATIONS_NOTICE 39207
#define IDS_VERSION_UI_COHORT_NAME 39208
#define IDS_COLLABORATION_SIGNIN_TITLE 39212
#define IDS_COLLABORATION_SIGNIN_DESCRIPTION 39213
#define IDS_COLLABORATION_SIGNIN_BOTTOM_SHEET_TITLE 39214
#define IDS_COLLABORATION_SIGNIN_BOTTOM_SHEET_DESCRIPTION 39215
#define IDS_COLLABORATION_SIGNIN_SYNC_DISMISS 39216
#define IDS_COLLABORATION_SYNC_TITLE 39217
#define IDS_COLLABORATION_SYNC_DESCRIPTION 39218
#define IDS_COLLABORATION_ONE_GROUP_REMOVED_NOTIFICATION 39219
#define IDS_COLLABORATION_ONE_UNNAMED_GROUP_REMOVED_NOTIFICATION 39220
#define IDS_COLLABORATION_TWO_GROUPS_REMOVED_NOTIFICATION 39221
#define IDS_COLLABORATION_SEVERAL_GROUPS_REMOVED_NOTIFICATION 39222
#define IDS_COLLABORATION_RECENT_ACTIVITY_MENU_OPTION 39223
#define IDS_COLLABORATION_SOMETHING_WENT_WRONG_HEADER 39224
#define IDS_COLLABORATION_SOMETHING_WENT_WRONG_BODY 39225
#define IDS_COLLABORATION_LINK_FAILED_HEADER 39226
#define IDS_COLLABORATION_LINK_FAILED_BODY 39227
#define IDS_COLLABORATION_CHROME_OUT_OF_DATE_ERROR_DIALOG_HEADER 39228
#define IDS_COLLABORATION_SHARE_BUTTON_CHROME_OUT_OF_DATE_ERROR_DIALOG_BODY 39229
#define IDS_COLLABORATION_JOIN_BUTTON_CHROME_OUT_OF_DATE_ERROR_DIALOG_BODY 39230
#define IDS_COLLABORATION_CHROME_OUT_OF_DATE_ERROR_DIALOG_UPDATE_BUTTON 39231
#define IDS_COLLABORATION_CHROME_OUT_OF_DATE_ERROR_DIALOG_NOT_NOW_BUTTON 39232
#define IDS_COLLABORATION_CHROME_OUT_OF_DATE_ERROR_DIALOG_CONTINUE_BODY 39233
#define IDS_COLLABORATION_SIGNED_OUT_HEADER 39234
#define IDS_COLLABORATION_SIGNED_OUT_BODY 39235
#define IDS_COLLABORATION_SIGNED_OUT_POSITIVE_BUTTON 39236
#define IDS_COLLABORATION_GROUP_IS_FULL_DESCRIPTION 39237
#define IDS_COLLABORATION_GROUP_IS_FULL_ERROR_DIALOG_HEADER 39238
#define IDS_COLLABORATION_GROUP_IS_FULL_ERROR_DIALOG_BODY 39239
#define IDS_COLLABORATION_ENTREPRISE_SIGNIN_DISABLED_HEADER 39240
#define IDS_COLLABORATION_ENTREPRISE_SIGNIN_DISABLED_BODY 39241
#define IDS_COLLABORATION_ENTREPRISE_SIGNIN_DISABLED_SYNC_HISTORY_BODY 39242
#define IDS_COLLABORATION_ENTREPRISE_SYNC_DISABLED_HEADER 39243
#define IDS_COLLABORATION_ENTREPRISE_SYNC_DISABLED_BODY 39244
#define IDS_COLLABORATION_ENTREPRISE_TABS_SYNC_DISABLED_BODY 39245
#define IDS_COLLABORATION_ENTREPRISE_GROUP_CLOSED_HEADER 39246
#define IDS_COLLABORATION_ENTREPRISE_GROUP_CLOSED_BODY 39247
#define IDS_COLLABORATION_ENTREPRISE_SHARING_OFF_HEADER 39248
#define IDS_COLLABORATION_ENTREPRISE_SHARING_OFF_BODY 39249
#define IDS_COLLABORATION_SHARED_TAB_GROUPS_PANEL_OUT_OF_DATE_MESSAGE_CELL_TEXT 39253
#define IDS_COLLABORATION_SHARED_TAB_GROUPS_AVAILABLE_AGAIN_IPH_MESSAGE 39254
#define IDS_DATA_SHARING_RECENT_ACTIVITY_USER_SELF 39255
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_ADDED 39256
#define IDS_DATA_SHARING_RECENT_ACTIVITY_MEMBER_ADDED_THIS_TAB 39257
#define IDS_DATA_SHARING_RECENT_ACTIVITY_MEMBER_CHANGED_THIS_TAB 39258
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_REMOVED 39259
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_UPDATED 39260
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_GROUP_NAME_UPDATED 39261
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_GROUP_COLOR_UPDATED 39262
#define DATA_SHARING_GROUP_LABEL_NEW_ACTIVITY 39263
#define IDS_DATA_SHARING_RECENT_ACTIVITY_USER_JOINED_GROUP 39264
#define IDS_DATA_SHARING_RECENT_ACTIVITY_USER_LEFT_GROUP 39265
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TIME_DELTA 39266
#define IDS_DATA_SHARING_RECENT_ACTIVITY_SEPARATOR 39267
#define IDS_DATA_SHARING_RECENT_ACTIVITY_DESCRIPTION_FULL 39268
#define IDS_DATA_SHARING_RECENT_ACTIVITY_EMPTY 39269
#define IDS_DATA_SHARING_RECENT_ACTIVITY_JUST_NOW 39270
#define IDS_DATA_SHARING_RECENT_ACTIVITY_UNKNOWN_USER 39271
#define IDS_DATA_SHARING_SHARED_TAB_GROUPS_ACTIVITY 39272
#define IDS_DATA_SHARING_TOAST_TAB_REMOVED 39273
#define IDS_DATA_SHARING_TOAST_TAB_UPDATED 39274
#define IDS_DATA_SHARING_TOAST_TAB_REMOVED_ACTION 39275
#define IDS_DATA_SHARING_TOAST_NEW_MEMBER 39276
#define IDS_DATA_SHARING_TOAST_NEW_MEMBER_MULTIPLE_MEMBERS 39277
#define IDS_DATA_SHARING_TOAST_NEW_MEMBER_ACTION 39278
#define IDS_DATA_SHARING_TOAST_BLOCK_LEAVE 39279
#define IDS_DATA_SHARING_TOAST_BLOCK_LEAVE_MULTIPLE_GROUPS 39280
#define IDS_DATA_SHARING_TAB_GROUP_DEFAULT_TITLE_TABS_COUNT 39281
#define IDS_COLLABORATION_SHARED_TAB_GROUPS_COMMENTS_TITLE 39282
#define IDS_COLLABORATION_SHARED_TAB_GROUPS_COMMENTS_TITLE_WITH_NAME 39283
#define IDS_CONTEXTUAL_TASKS_CONTEXTUAL_TASKS_TITLE 39284
#define IDS_CANCEL 505
#define IDS_CONTINUE 39344
#define IDS_CLOSE 39345
#define IDS_CLEAR 39346
#define IDS_DONE 483
#define IDS_LEARN_MORE 423
#define IDS_OK 571
#define IDS_RELOAD 39347
#define IDS_ADD 39348
#define IDS_MOVE 39349
#define IDS_REMOVE 39350
#define IDS_OPEN 39351
#define IDS_RESTORE 39352
#define IDS_SAVE 39353
#define IDS_MENU 39354
#define IDS_INSTALL 39355
#define IDS_UPDATE 39356
#define IDS_NO_THANKS 39359
#define IDS_NOT_NOW 39360
#define IDS_TURN_OFF 39361
#define IDS_PLUGIN_NOT_SUPPORTED 39362
#define IDS_PRINT 39363
#define IDS_RECENT_TABS 39364
#define IDS_RECENTLY_CLOSED 39365
#define IDS_YOUR_DEVICES 39366
#define IDS_CHOOSE 39367
#define IDS_ACCNAME_BACK 410
#define IDS_ACCNAME_FORWARD 413
#define IDS_ACCNAME_OK 39368
#define IDS_ACCNAME_CANCEL 39369
#define IDS_ACCNAME_DONE 39370
#define IDS_ACCNAME_SAVE 39371
#define IDS_ACCNAME_CLOSE 674
#define IDS_ACCNAME_OPEN 39372
#define IDS_ACCNAME_OPEN_IN_NEW_TAB 39373
#define IDS_ACCNAME_PREVIOUS 39374
#define IDS_ACCNAME_NEXT 39375
#define IDS_ACCNAME_LOCATION 473
#define IDS_ACCNAME_TAB_LIST 39376
#define IDS_UTILITY_PROCESS_JSON_PARSER_NAME 39377
#define IDS_SESSION_CRASHED_VIEW_RESTORE_BUTTON 39378
#define IDS_SESSION_CRASHED_VIEW_STARTUP_PAGES_BUTTON 39379
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_PRIVACY 39380
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_SAFETY_CHECK 39381
#define IDS_CONTENT_BOOKMARK_PARSER_SERVICE_DISPLAY_NAME 39382
#define IDS_PATCH_SERVICE_DISPLAY_NAME 39383
#define IDS_PASSWORD_MANAGER_CSV_PASSWORD_PARSER_SERVICE_DISPLAY_NAME 39384
#define IDS_UNZIP_SERVICE_DISPLAY_NAME 39385
#define IDS_INTERNAL_DEBUG_PAGES_DISABLED_HEADING 39386

// ---------------------------------------------------------------------------
// From extensions_strings.h:

#define IDS_EXTENSION_BAD_FILE_ENCODING 44740
#define IDS_EXTENSION_CANT_GET_ABSOLUTE_PATH 44741
#define IDS_EXTENSION_CONTAINS_PRIVATE_KEY 44742
#define IDS_EXTENSION_CRX_EXISTS 44743
#define IDS_EXTENSION_CONTENT_SCRIPT_FILE_TOO_LARGE 44744
#define IDS_EXTENSION_CONTENT_SCRIPT_FILE_BAD_JS_MIME_TYPE 44745
#define IDS_EXTENSION_CONTENT_SCRIPT_FILE_BAD_CSS_MIME_TYPE 44746
#define IDS_EXTENSION_DIRECTORY_NO_EXISTS 44747
#define IDS_EXTENSION_ERROR_WHILE_SIGNING 44748
#define IDS_EXTENSION_FAILED_DURING_PACKAGING 44749
#define IDS_EXTENSION_LOAD_ABOUT_PAGE_FAILED 44750
#define IDS_EXTENSION_LOAD_BACKGROUND_SCRIPT_FAILED 44751
#define IDS_EXTENSION_LOAD_BACKGROUND_PAGE_FAILED 44752
#define IDS_EXTENSION_LOAD_CSS_FAILED 44753
#define IDS_EXTENSION_LOAD_JAVASCRIPT_FAILED 44754
#define IDS_EXTENSION_LOAD_OPTIONS_PAGE_FAILED 44755
#define IDS_EXTENSION_LOCALES_NO_DEFAULT_LOCALE_SPECIFIED 44756
#define IDS_EXTENSION_MANIFEST_UNREADABLE 44757
#define IDS_EXTENSION_MANIFEST_INVALID 44758
#define IDS_EXTENSION_PACKAGE_IMAGE_ERROR 44759
#define IDS_EXTENSION_PACKAGE_UNZIP_ERROR 44760
#define IDS_EXTENSION_PRIVATE_KEY_EXISTS 44761
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_READ 44762
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_EXPORT 44763
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_OUTPUT 44764
#define IDS_EXTENSION_PRIVATE_KEY_INVALID 44765
#define IDS_EXTENSION_PRIVATE_KEY_NO_EXISTS 44766
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_PATH 44767
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_FORMAT 44768
#define IDS_EXTENSION_PUBLIC_KEY_FAILED_TO_EXPORT 44769
#define IDS_EXTENSION_SHARING_VIOLATION 44770
#define IDS_EXTENSION_CANT_INSTALL_POLICY_BLOCKED 44771
#define IDS_EXTENSION_CANT_MODIFY_POLICY_REQUIRED 44772
#define IDS_EXTENSION_CANT_UNINSTALL_POLICY_REQUIRED 44773
#define IDS_EXTENSION_MANIFEST_VERSION_NOT_SUPPORTED 44774
#define IDS_DEVICE_NAME_WITH_PRODUCT_SERIAL 44775
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR 44776
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR_SERIAL 44777
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR 44778
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR_SERIAL 44779
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR 44780
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR_SERIAL 44781
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR 44782
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR_SERIAL 44783
#define IDS_DEVICE_PERMISSIONS_PROMPT_SINGLE_SELECTION 44784
#define IDS_DEVICE_PERMISSIONS_PROMPT_MULTIPLE_SELECTION 44785
#define IDS_CAMERA_FACING_USER 44786
#define IDS_CAMERA_FACING_ENVIRONMENT 44787
#define IDS_EXTENSION_USB_DEVICE_PRODUCT_NAME_AND_VENDOR 44788
#define IDS_EXTENSION_TASK_MANAGER_APPVIEW_TAG_PREFIX 44789
#define IDS_EXTENSION_TASK_MANAGER_EXTENSIONOPTIONS_TAG_PREFIX 44790
#define IDS_EXTENSION_TASK_MANAGER_MIMEHANDLERVIEW_TAG_PREFIX 44791
#define IDS_EXTENSION_TASK_MANAGER_WEBVIEW_TAG_PREFIX 44792
#define IDS_EXTENSION_WARNINGS_NETWORK_DELAY 44793
#define IDS_EXTENSION_WARNINGS_DOWNLOAD_FILENAME_CONFLICT 44794
#define IDS_EXTENSION_WARNING_RELOAD_TOO_FREQUENT 44795
#define IDS_EXTENSION_WARNING_RULESET_FAILED_TO_LOAD 44796
#define IDS_EXTENSION_WARNING_ENABLED_RULE_COUNT_EXCEEDED 44797
#define IDS_EXTENSION_INSTALL_PROCESS_CRASHED 44798
#define IDS_EXTENSION_PACKAGE_ERROR_CODE 44799
#define IDS_EXTENSION_PACKAGE_ERROR_MESSAGE 44800
#define IDS_EXTENSION_PACKAGE_INSTALL_ERROR 44801
#define IDS_EXTENSION_WEBGL_NOT_SUPPORTED 44802

// ---------------------------------------------------------------------------
// From generated_resources.h:

#define IDS_ACCESS_CODE_CAST_ACCESS_CODE_MESSAGE 1600
#define IDS_ACCESS_CODE_CAST_BACK 1601
#define IDS_ACCESS_CODE_CAST_CAST 1602
#define IDS_ACCESS_CODE_CAST_CONNECT 1603
#define IDS_ACCESS_CODE_CAST_DIALOG_TITLE 1604
#define IDS_ACCESS_CODE_CAST_ENTER_CHARACTER 1605
#define IDS_ACCESS_CODE_CAST_ERROR_ACCESS_CODE 1606
#define IDS_ACCESS_CODE_CAST_ERROR_DIFFERENT_NETWORK 1607
#define IDS_ACCESS_CODE_CAST_ERROR_NETWORK 1608
#define IDS_ACCESS_CODE_CAST_ERROR_PERMISSION 1609
#define IDS_ACCESS_CODE_CAST_ERROR_TOO_MANY_REQUESTS 1610
#define IDS_ACCESS_CODE_CAST_ERROR_UNKNOWN 1611
#define IDS_ACCESS_CODE_CAST_ERROR_PROFILE_SYNC 1612
#define IDS_ACCESS_CODE_CAST_INPUT_ARIA_LABEL 1613
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_DAYS 1614
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_HOURS 1615
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_MONTHS 1616
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_YEARS 1617
#define IDS_ACCESS_CODE_CAST_SUBMIT 1618
#define IDS_ACCESS_CODE_CAST_USE_CAMERA 1619
#define IDS_APP_MANAGEMENT_CAMERA 1620
#define IDS_APP_MANAGEMENT_LOCATION 1621
#define IDS_APP_MANAGEMENT_MICROPHONE 1622
#define IDS_APP_MANAGEMENT_NOTIFICATIONS 1623
#define IDS_APP_MANAGEMENT_PERMISSIONS 1625
#define IDS_APP_MANAGEMENT_PERMISSIONS_WITH_ORIGIN 1626
#define IDS_APP_MANAGEMENT_MORE_SETTINGS 1627
#define IDS_APP_MANAGEMENT_WINDOW 1628
#define IDS_APP_MANAGEMENT_UNINSTALL_APP 1629
#define IDS_APP_MANAGEMENT_RUN_ON_OS_LOGIN 1630
#define IDS_APP_MANAGEMENT_POLICY_APP_POLICY_STRING 1631
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_TITLE 1632
#define IDS_APP_MANAGEMENT_INTENT_SHARING_APP_OPEN 1633
#define IDS_APP_MANAGEMENT_INTENT_SHARING_BROWSER_OPEN 1634
#define IDS_APP_MANAGEMENT_INTENT_SHARING_TAB_EXPLANATION 1635
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_DIALOG_TITLE 1636
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_CHANGE_BUTTON 1637
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TITLE 1638
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_1_APP 1639
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_2_APPS 1640
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_3_APPS 1641
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_4_APPS 1642
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_5_OR_MORE_APPS 1643
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_1_APP 1644
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_2_APPS 1645
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_3_APPS 1646
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_4_APPS 1647
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_5_OR_MORE_APPS 1648
#define IDS_APP_MANAGEMENT_APP_VERSION_TITLE 1649
#define IDS_APP_MANAGEMENT_APP_SIZE_TITLE 1650
#define IDS_APP_MANAGEMENT_APP_DATA_SIZE_TITLE 1651
#define IDS_APP_MANAGEMENT_FILE_HANDLING_HEADER 1652
#define IDS_APP_MANAGEMENT_FILE_HANDLING_OVERFLOW_DIALOG_TITLE 1653
#define IDS_APP_MANAGEMENT_FILE_HANDLING_SET_DEFAULTS_LINK 1654
#define IDS_APP_MANAGEMENT_FILE_HANDLING_TYPES 1655
#define IDS_APP_MANAGEMENT_APP_CONTENT_TITLE 1656
#define IDS_APP_MANAGEMENT_APP_CONTENT_SUBTITLE 1657
#define IDS_APP_MANAGEMENT_APP_CONTENT_DIALOG_SUBTITLE 1658
#define IDS_BOOKMARK_GROUP_FROM_IE 1659
#define IDS_BOOKMARK_GROUP_FROM_EDGE 1660
#define IDS_BOOKMARK_GROUP_FROM_FIREFOX 1661
#define IDS_BOOKMARK_GROUP_FROM_SAFARI 1662
#define IDS_BOOKMARK_GROUP 1663
#define IDS_UNNAMED_BOOKMARK_BUTTON_ACCESSIBLE_NAME 1664
#define IDS_BOOKMARK_BAR_SHOW_APPS_SHORTCUT 1665
#define IDS_BOOKMARK_BAR_SHOW_TAB_GROUPS 1666
#define IDS_BOOKMARK_BAR_SHOW_READING_LIST 1667
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS_DEFAULT_NAME 1668
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS 1669
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_NAME 675
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_TOOLTIP 676
#define IDS_BOOKMARK_BAR_OVERFLOW_BUTTON_TOOLTIP 683
#define IDS_BOOKMARK_BAR_OPEN_ALL 1670
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT 1671
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_WINDOW 1672
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_INCOGNITO 1673
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_TAB_GROUP 1674
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_TAB 1675
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_WINDOW 1676
#define IDS_BOOKMARK_BAR_OPEN_INCOGNITO 1677
#define IDS_BOOKMARK_BAR_OPEN_IN_SPLIT_VIEW 1678
#define IDS_BOOKMARK_BAR_EDIT 1679
#define IDS_BOOKMARK_BAR_RENAME_FOLDER 1680
#define IDS_BOOKMARK_BAR_REMOVE 1681
#define IDS_BOOKMARK_BAR_ADD_NEW_BOOKMARK 1682
#define IDS_BOOKMARK_BAR_NEW_FOLDER 1683
#define IDS_SHOW_BOOKMARK_BAR 1684
#define IDS_HIDE_BOOKMARK_BAR 1685
#define IDS_BOOKMARK_BAR_SHOULD_OPEN_ALL 1686
#define IDS_BOOKMARK_BAR_ALREADY_CREATED_GROUP 1687
#define IDS_BOOKMARK_BAR_CREATE_NEW_GROUP_BUTTON 1688
#define IDS_BOOKMARK_BAR_REPLACE_OLD_GROUP_BUTTON 1689
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARKED 1690
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARK 1691
#define IDS_BOOKMARK_BUBBLE_EDIT_BOOKMARK 1692
#define IDS_BOOKMARK_BUBBLE_NAME_LABEL 1693
#define IDS_BOOKMARK_BUBBLE_SAVED_TO 1694
#define IDS_BOOKMARK_AX_BUBBLE_NAME_LABEL 1695
#define IDS_BOOKMARK_BUBBLE_FOLDER_LABEL 1696
#define IDS_BOOKMARK_AX_BUBBLE_FOLDER_LABEL 1697
#define IDS_BOOKMARK_BUBBLE_OPTIONS 1698
#define IDS_BOOKMARK_BUBBLE_CHOOSER_ANOTHER_FOLDER 1699
#define IDS_BOOKMARK_DICE_PROMO_SYNC_MESSAGE 1700
#define IDS_BOOKMARK_VERIFY_PROMO_SUBTITLE 1701
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE 1702
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE_V2 1703
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE_V3 1704
#define IDS_BOOKMARK_FOOTNOTE_DESKTOP_TO_IOS_PROMO_MESSAGE 1705
#define IDS_BOOKMARK_EDITOR_NAME_LABEL 1706
#define IDS_BOOKMARK_AX_EDITOR_NAME_LABEL 1707
#define IDS_BOOKMARK_AX_EDITOR_URL_LABEL 1709
#define IDS_BOOKMARK_EDITOR_URL_LABEL 1710
#define IDS_BOOKMARK_EDITOR_CONFIRM_DELETE 1711
#define IDS_TAB_GROUP_TO_BOOKMARK_FOLDER_SUBTITLE 1712
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_BUTTON 1713
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_MENU_ITEM 1714
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE 1715
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE_NEW 1716
#define IDS_UNNAMED_BOOKMARK_FOLDER 678
#define IDS_BOOKMARK_ALL_TABS_DIALOG_TITLE 1717
#define IDS_TAB_GROUP_TO_BOOKMARK_FOLDER_TITLE 1718
#define IDS_BOOKMARK_MANAGER_TITLE 396
#define IDS_BOOKMARK_MANAGER_SEARCH_BUTTON 1719
#define IDS_BOOKMARK_MANAGER 1720
#define IDS_BOOKMARK_MANAGER_ORGANIZE_MENU 1721
#define IDS_BOOKMARK_MANAGER_INVALID_URL 1722
#define IDS_EXPORT_BOOKMARKS_DEFAULT_FILENAME 1723
#define IDS_BOOKMARK_MANAGER_ADD_BOOKMARK_TITLE 1724
#define IDS_BOOKMARK_MANAGER_ADD_FOLDER_TITLE 1725
#define IDS_BOOKMARK_MANAGER_CLEAR_SEARCH 1726
#define IDS_BOOKMARK_MANAGER_EMPTY_LIST 1727
#define IDS_BOOKMARK_MANAGER_EMPTY_UNMODIFIABLE_LIST 1728
#define IDS_BOOKMARK_MANAGER_FOLDER_LABEL 1729
#define IDS_BOOKMARK_MANAGER_FOLDER_RENAME_TITLE 1730
#define IDS_BOOKMARK_MANAGER_FOLDER_LIST_CHANGED 1731
#define IDS_BOOKMARK_MANAGER_LIST_AX_LABEL 1732
#define IDS_BOOKMARK_MANAGER_MENU_ADD_BOOKMARK 1733
#define IDS_BOOKMARK_MANAGER_MENU_ADD_FOLDER 1734
#define IDS_BOOKMARK_MANAGER_MENU_CUT 1735
#define IDS_BOOKMARK_MANAGER_MENU_COPY 1736
#define IDS_BOOKMARK_MANAGER_MENU_PASTE 1737
#define IDS_BOOKMARK_MANAGER_MENU_EXPORT 1738
#define IDS_BOOKMARK_MANAGER_MENU_HELP_CENTER 1739
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT 1740
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_BEGAN 1741
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_ENDED 1742
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL 1743
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_WITH_COUNT 1744
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW 1745
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW_WITH_COUNT 1746
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO 1747
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO_WITH_COUNT 1748
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_TAB_GROUP 1749
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_TAB_GROUP_WITH_COUNT 1750
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB 1751
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_WINDOW 1752
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_INCOGNITO 1753
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB_GROUP 1754
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_SPLIT_VIEW 1755
#define IDS_BOOKMARK_MANAGER_MENU_RENAME 1756
#define IDS_BOOKMARK_MANAGER_MENU_SHOW_IN_FOLDER 1757
#define IDS_BOOKMARK_MANAGER_MENU_SORT 1758
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS 1759
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_AX_LABEL 1760
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_MULTI_AX_LABEL 1761
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_TITLE 1762
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_CONFIRM 1763
#define IDS_BOOKMARK_MANAGER_ITEMS_SELECTED 1764
#define IDS_BOOKMARK_MANAGER_ITEMS_UNSELECTED 1765
#define IDS_BOOKMARK_MANAGER_SIDEBAR_AX_LABEL 1766
#define IDS_BOOKMARK_MANAGER_TOAST_FOLDER_SORTED 1767
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_DELETED 1768
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_DELETED 1769
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_COPIED 1770
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_COPIED 1771
#define IDS_BOOKMARKS_MENU 1772
#define IDS_BOOKMARKS_AND_LISTS_MENU 1773
#define IDS_SHOW_BOOKMARK_SIDE_PANEL 1774
#define IDS_BOOKMARK_THIS_TAB 1775
#define IDS_BOOKMARK_ALL_TABS 1776
#define IDS_BOOKMARKS_LIST_TITLE 1777
#define IDS_TOOLTIP_STARRED 1778
#define IDS_BOOKMARK_SCREEN_READER_CREATED 1779
#define IDS_BOOKMARK_SCREEN_READER_FOLDER_CREATED 1780
#define IDS_BOOKMARK_SCREEN_READER_REORDERED 1781
#define IDS_BOOKMARK_SCREEN_READER_MOVED 1782
#define IDS_TOOLTIP_TAB_ALERT_STATE_GLIC_ACCESSING 1783
#define IDS_TOOLTIP_TAB_ALERT_STATE_GLIC_SHARING 1784
#define IDS_TAB_AX_LABEL_GLIC_ACCESSING 1785
#define IDS_TAB_AX_LABEL_GLIC_SHARING 1786
#define IDS_GLIC_PROMO_BODY 1787
#define IDS_GLIC_STATUS_ICON_MENU_CUSTOMIZE_KEYBOARD_SHORTCUT 1788
#define IDS_GLIC_STATUS_ICON_MENU_EXIT 1789
#define IDS_GLIC_STATUS_ICON_MENU_SETTINGS 1790
#define IDS_GLIC_OS_WIDGET_TOGGLE_HELP_BUBBLE 1791
#define IDS_GLIC_OS_WIDGET_KEYBOARD_SHORTCUT_HELP_BUBBLE 1792
#define IDS_GLIC_OFFLINE_NOTICE_HEADER 1793
#define IDS_GLIC_OFFLINE_NOTICE_ACTION 1794
#define IDS_GLIC_OFFLINE_NOTICE_ACTION_BUTTON 1795
#define IDS_GLIC_UNRESPONSIVE_MESSAGE 1796
#define IDS_GLIC_ERROR_NOTICE_HEADER 1797
#define IDS_GLIC_ERROR_NOTICE 1798
#define IDS_GLIC_ERROR_NOTICE_ACTION_BUTTON 1799
#define IDS_GLIC_NOTICE_CLOSE_BUTTON_LABEL 1800
#define IDS_GLIC_SIGN_IN_NOTICE_HEADER 1801
#define IDS_GLIC_SIGN_IN_NOTICE 1802
#define IDS_GLIC_SIGN_IN_NOTICE_ACTION_BUTTON 1803
#define IDS_GLIC_INELIGIBLE_PROFILE_NOTICE_HEADER 1804
#define IDS_GLIC_INELIGIBLE_PROFILE_NOTICE_ACTION_BUTTON 1805
#define IDS_GLIC_DISABLED_BY_ADMIN_NOTICE 1806
#define IDS_GLIC_DISABLED_BY_ADMIN_NOTICE_WITH_LINK 1807
#define IDS_GLIC_DISABLED_BY_ADMIN_NOTICE_CLOSE_BUTTON 1808
#define IDS_GLIC_DISABLED_BY_ADMIN_NOTICE_HEADER 1809
#define IDS_SETTINGS_GLIC_ROW_SUBLABEL 1810
#define IDS_SETTINGS_GLIC_POLICY_DISABLED_MESSAGE 1811
#define IDS_SETTINGS_GLIC_PREFERENCES_SECTION 1812
#define IDS_SETTINGS_GLIC_PERMISSIONS_SECTION 1813
#define IDS_SETTINGS_GLIC_BUTTON_TOGGLE 1814
#define IDS_SETTINGS_GLIC_BUTTON_TOGGLE_SUBLABEL 1815
#define IDS_SETTINGS_GLIC_OS_WIDGET_TOGGLE 1816
#define IDS_SETTINGS_GLIC_OS_WIDGET_TOGGLE_SUBLABEL 1817
#define IDS_SETTINGS_GLIC_KEYBOARD_SHORTCUT 1818
#define IDS_SETTINGS_GLIC_KEYBOARD_SHORTCUT_SUBLABEL 1819
#define IDS_SETTINGS_GLIC_KEYBOARD_SHORTCUT_LEARN_MORE_LABEL 1820
#define IDS_SETTINGS_GLIC_NAVIGATION_SHORTCUT 1821
#define IDS_SETTINGS_GLIC_NAVIGATION_SHORTCUT_SUBLABEL 1822
#define IDS_SETTINGS_GLIC_CLOSED_CAPTIONING 1823
#define IDS_SETTINGS_GLIC_CLOSED_CAPTIONING_SUBLABEL 1824
#define IDS_SETTINGS_GLIC_PERMISSIONS_LOCATION_TOGGLE 1825
#define IDS_SETTINGS_GLIC_PERMISSIONS_LOCATION_TOGGLE_SUBLABEL 1826
#define IDS_SETTINGS_GLIC_PERMISSIONS_LOCATION_TOGGLE_SUBLABEL_DATA_PROTECTED 1827
#define IDS_SETTINGS_GLIC_PERMISSIONS_MICROPHONE_TOGGLE 1828
#define IDS_SETTINGS_GLIC_PERMISSIONS_MICROPHONE_TOGGLE_SUBLABEL 1829
#define IDS_SETTINGS_GLIC_PERMISSIONS_MICROPHONE_TOGGLE_SUBLABEL_DATA_PROTECTED 1830
#define IDS_SETTINGS_GLIC_PERMISSIONS_TAB_ACCESS_TOGGLE 1831
#define IDS_SETTINGS_GLIC_PERMISSIONS_TAB_ACCESS_TOGGLE_SUBLABEL 1832
#define IDS_SETTINGS_GLIC_PERMISSIONS_TAB_ACCESS_TOGGLE_SUBLABEL_DATA_PROTECTED 1833
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_TOGGLE 1834
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_TOGGLE_SUBLABEL 1835
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_TOGGLE_SUBLABEL_DATA_PROTECTED 1836
#define IDS_SETTINGS_GLIC_PERMISSIONS_WEB_ACTUATION_TOGGLE 1837
#define IDS_SETTINGS_GLIC_PERMISSIONS_WEB_ACTUATION_TOGGLE_SUBLABEL 1838
#define IDS_SETTINGS_GLIC_PERMISSIONS_ACTIVITY_BUTTON 1839
#define IDS_SETTINGS_GLIC_PERMISSIONS_ACTIVITY_BUTTON_SUBLABEL 1840
#define IDS_SETTINGS_GLIC_PERMISSIONS_ACTIVITY_BUTTON_URL 1841
#define IDS_SETTINGS_GLIC_EXTENSIONS_BUTTON 1842
#define IDS_SETTINGS_GLIC_EXTENSIONS_BUTTON_SUBLABEL 1843
#define IDS_SETTINGS_GLIC_PERMISSIONS_TAB_ACCESS_WHEN_ON_1 1844
#define IDS_SETTINGS_GLIC_PERMISSIONS_TAB_ACCESS_CONSIDER_1 1845
#define IDS_SETTINGS_GLIC_PERMISSIONS_TAB_ACCESS_CONSIDER_1_LEARN_MORE_LABEL 1846
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_WHEN_ON_1 1847
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_WHEN_ON_2 1848
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_CONSIDER_1 1849
#define IDS_SETTINGS_GLIC_PERMISSIONS_DEFAULT_TAB_ACCESS_CONSIDER_2 1850
#define IDS_SETTINGS_GLIC_PERSONAL_CONTEXT_LABEL 1851
#define IDS_SETTINGS_GLIC_PERSONAL_CONTEXT 1852
#define IDS_SETTINGS_GLIC_PERMISSIONS_WEB_ACTUATION_TOGGLE_WHEN_ON_1 1853
#define IDS_SETTINGS_GLIC_PERMISSIONS_WEB_ACTUATION_TOGGLE_WHEN_ON_2 1854
#define IDS_SETTINGS_GLIC_PERMISSIONS_WEB_ACTUATION_TOGGLE_CONSIDER_1 1855
#define IDS_SETTINGS_GLIC_PERMISSIONS_WEB_ACTUATION_TOGGLE_CONSIDER_2 1856
#define IDS_GLIC_PIN 1857
#define IDS_GLIC_UNPIN 1858
#define IDS_GLIC_SCREEN_PICKER_REQUESTER 1859
#define IDS_GLIC_SCREEN_PICKER_HEADLINE 1860
#define IDS_GLIC_SCREEN_PICKER_DESCRIPTION 1861
#define IDS_GLIC_SCREEN_PICKER_CTA 1862
#define IDS_GLIC_WINDOW_TITLE 1863
#define IDS_GLIC_WINDOW_TITLE_FIRST_LOAD 1864
#define IDS_GLIC_WINDOW_FIRST_FOCUS_LOST_ANNOUNCEMENT 1865
#define IDS_TASK_MANAGER_GLIC_RENDERER_PREFIX 1866
#define IDS_TAB_CXMENU_GLIC_START_SHARE 1867
#define IDS_TAB_CXMENU_GLIC_STOP_SHARE 1868
#define IDS_TAB_CXMENU_GLIC_SHARE_LIMIT 1869
#define IDS_GLIC_BUTTON_CXMENU_UNPIN 1870
#define IDS_GLIC_BUTTON_ENTRYPOINT_LABEL 1871
#define IDS_CONTENT_CONTEXT_GLICSHAREIMAGE 1872
#define IDS_GLIC_PROMO_CONFIRM 1873
#define IDS_GLIC_TRYIT_TITLE 1874
#define IDS_GLIC_TRYIT_BODY 1875
#define IDS_GLOBAL_MEDIA_CONTROLS_ICON_TOOLTIP_TEXT 430
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL_WITH_COLON 1876
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL 1877
#define IDS_GLOBAL_MEDIA_CONTROLS_STOP_CASTING_BUTTON_LABEL 1878
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION 1879
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_SHOW_LANGUAGE 1880
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_PROGRESS 1881
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR 1882
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 1883
#define IDS_GLOBAL_MEDIA_CONTROLS_CAPTION_SETTINGS 1884
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_TRANSLATE_TARGET_LANGUAGE_ACCNAME 1885
#define IDS_GLOBAL_MEDIA_CONTROLS_DIALOG_NAME 1886
#define IDS_GLOBAL_MEDIA_CONTROLS_SHOW_DEVICE_LIST 1887
#define IDS_GLOBAL_MEDIA_CONTROLS_HIDE_DEVICE_LIST 1888
#define IDS_GLOBAL_MEDIA_CONTROLS_CONTROL_CAST_SESSIONS_PROMO 1889
#define IDS_GMC_LOCAL_MEDIA_CAST_SESSIONS_PROMO 1890
#define IDS_GMC_LOCAL_MEDIA_CAST_START_PROMO 1891
#define IDS_MEDIA_TOOLBAR_CONTEXT_REPORT_CAST_ISSUE 427
#define IDS_MEDIA_TOOLBAR_CONTEXT_SHOW_OTHER_SESSIONS 429
#define IDS_MEDIA_PREVIEW_CAMERA_ACCESSIBLE_NAME 1892
#define IDS_MEDIA_PREVIEW_VIDEO_STREAM_ACCESSIBLE_NAME 1893
#define IDS_MEDIA_PREVIEW_NO_CAMERAS_FOUND 1894
#define IDS_MEDIA_PREVIEW_NO_CAMERAS_FOUND_COMBOBOX 1895
#define IDS_MEDIA_PREVIEW_VIDEO_STREAM_PREVIEW_BADGE 1896
#define IDS_MEDIA_PREVIEW_MIC_ACCESSIBLE_NAME 1897
#define IDS_MEDIA_PREVIEW_AUDIO_STREAM_ACCESSIBLE_NAME 1898
#define IDS_MEDIA_PREVIEW_NO_MICS_FOUND 1899
#define IDS_MEDIA_PREVIEW_NO_MICS_FOUND_COMBOBOX 1900
#define IDS_MEDIA_PREVIEW_SYSTEM_DEFAULT_MIC 1901
#define IDS_MEDIA_PREVIEW_SYSTEM_DEFAULT_MIC_PARENTHETICAL 1902
#define IDS_MEDIA_PREVIEW_ANNOUNCE_SELECTED_DEVICE_CHANGE 1903
#define IDS_MEDIA_ROUTER_ICON_TOOLTIP_TEXT 428
#define IDS_MEDIA_ROUTER_MENU_ITEM_TITLE 1904
#define IDS_MEDIA_ROUTER_PRESENTATION_CAST_MODE 1905
#define IDS_MEDIA_ROUTER_DESKTOP_MIRROR_CAST_MODE 1906
#define IDS_MEDIA_ROUTER_TAB_MIRROR_CAST_MODE 1907
#define IDS_MEDIA_ROUTER_ALTERNATIVE_SOURCES_BUTTON 1908
#define IDS_MEDIA_ROUTER_ABOUT 422
#define IDS_MEDIA_ROUTER_HELP 424
#define IDS_MEDIA_ROUTER_ALWAYS_SHOW_TOOLBAR_ACTION 425
#define IDS_MEDIA_ROUTER_SHOWN_BY_POLICY 1909
#define IDS_MEDIA_ROUTER_TOGGLE_MEDIA_REMOTING 426
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_WITH_HOSTNAME 1910
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT 1911
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_DESKTOP 1912
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_TAB 1913
#define IDS_MEDIA_ROUTER_ISSUE_UNABLE_TO_CAST_DESKTOP 1914
#define IDS_MEDIA_ROUTER_ISSUE_TAB_AUDIO_NOT_SUPPORTED 1915
#define IDS_MEDIA_ROUTER_ISSUE_DESKTOP_AUDIO_NOT_SUPPORTED 1916
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_PENDING_AUTHORIZATION 1918
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_NOT_ALLOWED 1919
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_NOTIFICATION_DISABLED 1920
#define IDS_MEDIA_ROUTER_ISSUE_FAILED_TO_CAST 1921
#define IDS_MEDIA_ROUTER_ISSUE_CANNOT_TERMINATE 1922
#define IDS_MEDIA_ROUTER_STATUS_LOOKING_FOR_DEVICES 1923
#define IDS_MEDIA_ROUTER_STATUS_NO_DEVICES_FOUND 1924
#define IDS_MEDIA_ROUTER_NO_DEVICES_FOUND_BUTTON 1925
#define IDS_MEDIA_ROUTER_DESTINATION_MISSING 1926
#define IDS_MEDIA_ROUTER_LOCAL_DISCOVERY_PERMISSION_REJECTED_BUTTON 1927
#define IDS_MEDIA_ROUTER_LOCAL_DISCOVERY_PERMISSION_REJECTED_LABEL 1928
#define IDS_MEDIA_ROUTER_LOCAL_DISCOVERY_PERMISSION_REJECTED_LINK 1929
#define IDS_MEDIA_ROUTER_SINK_AVAILABLE 1930
#define IDS_MEDIA_ROUTER_SINK_CONNECTING 1931
#define IDS_MEDIA_ROUTER_SINK_DISCONNECTING 1932
#define IDS_MEDIA_ROUTER_SINK_PAUSED 1933
#define IDS_MEDIA_ROUTER_STOP_CASTING 1934
#define IDS_MEDIA_ROUTER_SOURCE_NOT_SUPPORTED 1935
#define IDS_MEDIA_ROUTER_AVAILABLE_SPECIFIC_SITES 1936
#define IDS_MEDIA_ROUTER_CASTING_DESKTOP 1937
#define IDS_MEDIA_ROUTER_CASTING_TAB 1938
#define IDS_MEDIA_ROUTER_PRESENTATION_ROUTE_DESCRIPTION 1939
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE 1940
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_GENERIC_ACCESSIBLE_NAME 1941
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_SCREEN_ACCESSIBLE_NAME 1942
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_TAB_ACCESSIBLE_NAME 1943
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME 1944
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_GENERIC_ACCESSIBLE_NAME 1945
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_SCREEN_ACCESSIBLE_NAME 1946
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_TAB_ACCESSIBLE_NAME 1947
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP 1948
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_GENERIC_ACCESSIBLE_NAME 1949
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_SCREEN_ACCESSIBLE_NAME 1950
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_TAB_ACCESSIBLE_NAME 1951
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_TITLE 1952
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_BODY_TEXT 1953
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CHECKBOX 1954
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_OPTIMIZE_BUTTON 1955
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON 1956
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON_MACOS 1957
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_DEPRECATED 1958
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_REMOVED 1959
#define IDS_MEDIA_ROUTER_WIRED_DISPLAY_SINK_NAME 1960
#define IDS_MEDIA_ROUTER_FEEDBACK_TITLE 1961
#define IDS_MEDIA_ROUTER_FEEDBACK_NA 1962
#define IDS_MEDIA_ROUTER_FEEDBACK_FORM_DESCRIPTION 1963
#define IDS_MEDIA_ROUTER_FEEDBACK_HEADER 1964
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_ANSWER 1965
#define IDS_MEDIA_ROUTER_FEEDBACK_REQUIRED 1966
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_QUESTION 1967
#define IDS_MEDIA_ROUTER_FEEDBACK_PROMPT 1968
#define IDS_MEDIA_ROUTER_FEEDBACK_MIRRORING_QUALITY_SUBHEADING 1969
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTHNESS 1970
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_QUALITY 1971
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_QUALITY 1972
#define IDS_MEDIA_ROUTER_FEEDBACK_CONTENT_QUESTION 1973
#define IDS_MEDIA_ROUTER_FEEDBACK_ADDITIONAL_COMMENTS 1974
#define IDS_MEDIA_ROUTER_FEEDBACK_ALLOW_CONTACT_BY_EMAIL 1975
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_EMAIL_ADDRESS 1976
#define IDS_MEDIA_ROUTER_FEEDBACK_EMAIL_FIELD 1977
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_BUTTON 1978
#define IDS_MEDIA_ROUTER_FEEDBACK_DISCARD_CONFIRMATION 1979
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_BUG_OR_ERROR 1980
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_FEATURE_REQUEST 1981
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_PROJECTION_QUALITY 1982
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_DISCOVERY 1983
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_OTHER 1984
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_FREEZES 1985
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_JERKY 1986
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_STUTTER 1987
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTH 1988
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_PERFECT 1989
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_UNWATCHABLE 1990
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_POOR 1991
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_ACCEPTABLE 1992
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GOOD 1993
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GREAT 1994
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_UNINTELLIGIBLE 1995
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_POOR 1996
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_ACCEPTABLE 1997
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_GOOD 1998
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_PERFECT 1999
#define IDS_MEDIA_ROUTER_FEEDBACK_SENDING 2000
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_FAIL 2001
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_SUCCESS 2002
#define IDS_MEDIA_ROUTER_FEEDBACK_RESENDING 2003
#define IDS_MEDIA_ROUTER_FEEDBACK_LOGS_HEADER 2004
#define IDS_MEDIA_ROUTER_FEEDBACK_FINE_LOGS_WARNING 2005
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS_HTML 2006
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS 2007
#define IDS_MEDIA_ROUTER_FEEDBACK_PRIVACY_DATA_USAGE 2008
#define IDS_MEDIA_ROUTER_FEEDBACK_SETUP_VISIBILITY_QUESTION 2009
#define IDS_MEDIA_ROUTER_FEEDBACK_YES 2010
#define IDS_MEDIA_ROUTER_FEEDBACK_NO 2011
#define IDS_MEDIA_ROUTER_FEEDBACK_DID_NOT_TRY 2012
#define IDS_MEDIA_ROUTER_FEEDBACK_SOFTWARE_QUESTION 2013
#define IDS_MEDIA_ROUTER_FEEDBACK_UNKNOWN 2014
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_QUESTION 2015
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_SAME_WIFI 2016
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_DIFFERENT_WIFI 2017
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_WIRED_PC 2018
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_CAST_SCREEN 2019
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_PAUSED 2020
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_CAN_PAUSE 2021
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_PAUSED 2022
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_TAB_CAN_PAUSE 2023
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE 2024
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE_UNKNOWN 2025
#define IDS_AVATAR_BUTTON_GUEST 2026
#define IDS_AVATAR_BUTTON_GUEST_TOOLTIP 2027
#define IDS_GUEST_BUBBLE_ACCESSIBLE_TITLE 2028
#define IDS_INCOGNITO_BUBBLE_ACCESSIBLE_TITLE 2029
#define IDS_AVATAR_BUTTON_INCOGNITO 2030
#define IDS_AVATAR_BUTTON_INCOGNITO_TOOLTIP 2031
#define IDS_AVATAR_BUTTON_SYNC_ERROR 2032
#define IDS_AVATAR_BUTTON_SYNC_ERROR_TOOLTIP 2033
#define IDS_AVATAR_BUTTON_SYNC_PAUSED 2034
#define IDS_AVATAR_BUTTON_SIGNIN_PAUSED 2035
#define IDS_AVATAR_BUTTON_WORK 2036
#define IDS_AVATAR_BUTTON_SCHOOL 2037
#define IDS_AVATAR_BUTTON_GREETING 2038
#define IDS_AVATAR_BUTTON_PASSKEYS_ERROR_UNLOCK 2039
#define IDS_AVATAR_BUTTON_PASSKEYS_ERROR_GET 2040
#define IDS_AVATAR_BUTTON_PASSKEYS_ERROR_VERIFY 2041
#define IDS_PROFILE_MENU_PASSKEYS_ERROR_DESCRIPTION_UNLOCK 2042
#define IDS_PROFILE_MENU_PASSKEYS_ERROR_DESCRIPTION_GET 2043
#define IDS_PROFILE_MENU_PASSKEYS_ERROR_DESCRIPTION_VERIFY 2044
#define IDS_PROFILE_MENU_PASSKEYS_ERROR_BUTTON_UNLOCK 2045
#define IDS_PROFILE_MENU_PASSKEYS_ERROR_BUTTON_GET 2046
#define IDS_PROFILE_MENU_PASSKEYS_ERROR_BUTTON_VERIFY 2047
#define IDS_PROFILES_MENU_NAME 2048
#define IDS_PROFILES_PROFILE_BUBBLE_ACCESSIBLE_TITLE 2051
#define IDS_PROFILES_EXIT_PROFILE_BUTTON 2052
#define IDS_PROFILES_ACCOUNT_REMOVAL_TITLE 2053
#define IDS_PROFILES_SYNC_COMPLETE_TITLE 2054
#define IDS_PROFILES_DICE_SIGNIN_BUTTON 2055
#define IDS_EXTENSIONS_EXPLICIT_SIGNIN_BUTTON 2056
#define IDS_PROFILES_DICE_WEB_ONLY_SIGNIN_BUTTON 2057
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON 2058
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON_NO_NAME 2059
#define IDS_PROFILES_DICE_SYNC_DISABLED_TITLE 2060
#define IDS_PROFILES_DASHER_FEATURE_DISABLED_TITLE 2061
#define IDS_PROFILES_DICE_SYNC_PAUSED_TITLE 2062
#define IDS_PROFILES_SIGNIN_PROMO 2063
#define IDS_PROFILES_VERIFY_ACCOUNT_BUTTON 2064
#define IDS_PROFILE_MENU_SIGNIN_PROMO_DESCRIPTION 2065
#define IDS_PROFILE_MENU_SIGNIN_PROMO_DESCRIPTION_WITH_BOOKMARKS 2066
#define IDS_PROFILE_MENU_PROFILE_IDENTIFIER_WITH_SEPARATOR 2067
#define IDS_PROFILE_MENU_PROFILE_MANAGED_HEADER 2068
#define IDS_GUEST_PROFILE_MENU_CLOSE_X_WINDOWS_BUTTON 2069
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_X_WINDOWS_BUTTON 2070
#define IDS_PROFILES_PROFILE_MANAGE_ACCOUNTS_BUTTON 2071
#define IDS_PROFILES_PROFILE_HIDE_MANAGE_ACCOUNTS_BUTTON 2072
#define IDS_PROFILE_MENU_OPEN_GUEST_PROFILE 2073
#define IDS_PROFILE_MENU_CLOSE_PROFILE_X_WINDOWS_BUTTON 2074
#define IDS_PROFILES_OPEN_SYNC_SETTINGS_BUTTON 2075
#define IDS_PROFILE_MENU_CUSTOMIZE_PROFILE_BUTTON 2076
#define IDS_PROFILE_MENU_OPEN_ACCOUNT_SETTINGS 2077
#define IDS_PROFILE_MENU_AUTOFILL_SETTINGS_BUTTON 2078
#define IDS_PROFILE_MENU_BATCH_UPLOAD_BUTTON 2079
#define IDS_PROFILES_MANAGED_BY 2080
#define IDS_PROFILES_MANAGE_PROFILES_BUTTON_TOOLTIP 2081
#define IDS_PROFILES_CUSTOMIZE_PROFILE_BUTTON_TOOLTIP 2082
#define IDS_PROFILES_GUEST_PROFILE_NAME 2083
#define IDS_DEFAULT_PROFILE_NAME 2084
#define IDS_LEGACY_DEFAULT_PROFILE_NAME 2085
#define IDS_NEW_NUMBERED_PROFILE_NAME 2086
#define IDS_SINGLE_PROFILE_DISPLAY_NAME 2087
#define IDS_GUEST_PROFILE_NAME 2088
#define IDS_DEFAULT_AVATAR_NAME_8 2089
#define IDS_DEFAULT_AVATAR_NAME_9 2090
#define IDS_DEFAULT_AVATAR_NAME_10 2091
#define IDS_DEFAULT_AVATAR_NAME_11 2092
#define IDS_DEFAULT_AVATAR_NAME_12 2093
#define IDS_DEFAULT_AVATAR_NAME_13 2094
#define IDS_DEFAULT_AVATAR_NAME_14 2095
#define IDS_DEFAULT_AVATAR_NAME_15 2096
#define IDS_DEFAULT_AVATAR_NAME_16 2097
#define IDS_DEFAULT_AVATAR_NAME_17 2098
#define IDS_DEFAULT_AVATAR_NAME_18 2099
#define IDS_DEFAULT_AVATAR_NAME_19 2100
#define IDS_DEFAULT_AVATAR_NAME_20 2101
#define IDS_DEFAULT_AVATAR_NAME_21 2102
#define IDS_DEFAULT_AVATAR_NAME_22 2103
#define IDS_DEFAULT_AVATAR_NAME_23 2104
#define IDS_DEFAULT_AVATAR_NAME_24 2105
#define IDS_DEFAULT_AVATAR_NAME_25 2106
#define IDS_DEFAULT_AVATAR_NAME_26 2107
#define IDS_DEFAULT_AVATAR_LABEL_0 2108
#define IDS_DEFAULT_AVATAR_LABEL_1 2109
#define IDS_DEFAULT_AVATAR_LABEL_2 2110
#define IDS_DEFAULT_AVATAR_LABEL_3 2111
#define IDS_DEFAULT_AVATAR_LABEL_4 2112
#define IDS_DEFAULT_AVATAR_LABEL_5 2113
#define IDS_DEFAULT_AVATAR_LABEL_6 2114
#define IDS_DEFAULT_AVATAR_LABEL_7 2115
#define IDS_DEFAULT_AVATAR_LABEL_8 2116
#define IDS_DEFAULT_AVATAR_LABEL_9 2117
#define IDS_DEFAULT_AVATAR_LABEL_10 2118
#define IDS_DEFAULT_AVATAR_LABEL_11 2119
#define IDS_DEFAULT_AVATAR_LABEL_12 2120
#define IDS_DEFAULT_AVATAR_LABEL_13 2121
#define IDS_DEFAULT_AVATAR_LABEL_14 2122
#define IDS_DEFAULT_AVATAR_LABEL_15 2123
#define IDS_DEFAULT_AVATAR_LABEL_16 2124
#define IDS_DEFAULT_AVATAR_LABEL_17 2125
#define IDS_DEFAULT_AVATAR_LABEL_18 2126
#define IDS_DEFAULT_AVATAR_LABEL_19 2127
#define IDS_DEFAULT_AVATAR_LABEL_20 2128
#define IDS_DEFAULT_AVATAR_LABEL_21 2129
#define IDS_DEFAULT_AVATAR_LABEL_22 2130
#define IDS_DEFAULT_AVATAR_LABEL_23 2131
#define IDS_DEFAULT_AVATAR_LABEL_24 2132
#define IDS_DEFAULT_AVATAR_LABEL_25 2133
#define IDS_DEFAULT_AVATAR_LABEL_26 2134
#define IDS_DEFAULT_AVATAR_LABEL_27 2135
#define IDS_DEFAULT_AVATAR_LABEL_28 2136
#define IDS_DEFAULT_AVATAR_LABEL_29 2137
#define IDS_DEFAULT_AVATAR_LABEL_30 2138
#define IDS_DEFAULT_AVATAR_LABEL_31 2139
#define IDS_DEFAULT_AVATAR_LABEL_32 2140
#define IDS_DEFAULT_AVATAR_LABEL_33 2141
#define IDS_DEFAULT_AVATAR_LABEL_34 2142
#define IDS_DEFAULT_AVATAR_LABEL_35 2143
#define IDS_DEFAULT_AVATAR_LABEL_36 2144
#define IDS_DEFAULT_AVATAR_LABEL_37 2145
#define IDS_DEFAULT_AVATAR_LABEL_38 2146
#define IDS_DEFAULT_AVATAR_LABEL_39 2147
#define IDS_DEFAULT_AVATAR_LABEL_40 2148
#define IDS_DEFAULT_AVATAR_LABEL_41 2149
#define IDS_DEFAULT_AVATAR_LABEL_42 2150
#define IDS_DEFAULT_AVATAR_LABEL_43 2151
#define IDS_DEFAULT_AVATAR_LABEL_44 2152
#define IDS_DEFAULT_AVATAR_LABEL_45 2153
#define IDS_DEFAULT_AVATAR_LABEL_46 2154
#define IDS_DEFAULT_AVATAR_LABEL_47 2155
#define IDS_DEFAULT_AVATAR_LABEL_48 2156
#define IDS_DEFAULT_AVATAR_LABEL_49 2157
#define IDS_DEFAULT_AVATAR_LABEL_50 2158
#define IDS_DEFAULT_AVATAR_LABEL_51 2159
#define IDS_DEFAULT_AVATAR_LABEL_52 2160
#define IDS_DEFAULT_AVATAR_LABEL_53 2161
#define IDS_DEFAULT_AVATAR_LABEL_54 2162
#define IDS_DEFAULT_AVATAR_LABEL_55 2163
#define IDS_PROFILES_LOCAL_PROFILE_STATE 2164
#define IDS_PROFILES_CREATE_BUTTON_LABEL 2165
#define IDS_PROFILES_MANAGE_BUTTON_LABEL 2166
#define IDS_PROFILES_DEFAULT_NAME 376
#define IDS_SYNC_LOGIN_NAME_PROHIBITED 2167
#define IDS_SUPERVISED_USER_NOT_ALLOWED_BY_POLICY 2168
#define IDS_OLD_PROFILES_DISABLED_TITLE 2169
#define IDS_OLD_PROFILES_DISABLED_MESSAGE 2170
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION 2171
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION_WITH_DOMAIN 2172
#define IDS_OLD_PROFILES_DISABLED_REMOVED_OLD_PROFILE 2173
#define IDS_SYNC_USER_NAME_IN_USE_ERROR 2174
#define IDS_SYNC_USER_NAME_IN_USE_BY_ERROR 2175
#define IDS_SCREEN_LOCK_SIGN_OUT 2176
#define IDS_PROFILE_CUSTOMIZATION_DONE_BUTTON_LABEL 2182
#define IDS_PROFILE_CUSTOMIZATION_WELCOME 2183
#define IDS_PROFILE_CUSTOMIZATION_INPUT_LABEL 2184
#define IDS_PROFILE_CUSTOMIZATION_INPUT_PLACEHOLDER 2185
#define IDS_PROFILE_CUSTOMIZATION_INPUT_ERROR_MESSAGE 2186
#define IDS_PROFILE_CUSTOMIZATION_SKIP_BUTTON_LABEL 2187
#define IDS_PROFILE_CUSTOMIZATION_DELETE_PROFILE_BUTTON_LABEL 2188
#define IDS_PROFILE_CUSTOMIZATION_LOCAL_PROFILE_CREATION_TITLE 2189
#define IDS_PROFILE_CUSTOMIZATION_AVATAR_SELECTION_BACK_BUTTON_LABEL 2190
#define IDS_ENTERPRISE_PROFILE_WELCOME_TITLE 2191
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_MANAGED_BY 2192
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_STRICT_SEPARATION 2193
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_SEPARATION 2194
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED 2195
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_ACCOUNT_MANAGED 2196
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED_BY 2197
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_EMAIL_MANAGED_BY 2198
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED_BY 2199
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED 2200
#define IDS_ENTERPRISE_WELCOME_PROFILE_REQUIRED_TITLE 2201
#define IDS_ENTERPRISE_WELCOME_PROFILE_SETUP_TITLE 2202
#define IDS_ENTERPRISE_WELCOME_PROFILE_WILL_BE_MANAGED_TITLE 2203
#define IDS_ENTERPRISE_PROFILE_WELCOME_CREATE_PROFILE_BUTTON 2204
#define IDS_ENTERPRISE_PROFILE_WELCOME_LINK_DATA_CHECKBOX 2205
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_SCHOOL_TITLE 2206
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_WORK_TITLE 2207
#define IDS_ENTERPRISE_WELCOME_PROFILE_OIDC_DISCLOSURE_TITLE 2208
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_ALREADY_SIGNED_IN_TITLE 2209
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_ALREADY_SIGNED_IN_ENFORCED_SUBTITLE 2210
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_ALREADY_SIGNED_IN_SUBTITLE 2211
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_SUBTITLE 2212
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_KNOWN_DOMAIN_SUBTITLE 2213
#define IDS_ENTERPRISE_WELCOME_PROFILE_INFORMATION_TITLE 2214
#define IDS_ENTERPRISE_WELCOME_DEVICE_INFORMATION_TITLE 2215
#define IDS_ENTERPRISE_WELCOME_DEVICE_INFORMATION_DETAILS 2216
#define IDS_ENTERPRISE_PROFILE_WELCOME_BACK 2217
#define IDS_ENTERPRISE_OIDC_WELCOME_PROCESSING_SUBTITLE 2218
#define IDS_ENTERPRISE_OIDC_WELCOME_LONG_PROCESSING_SUBTITLE 2219
#define IDS_ENTERPRISE_OIDC_WELCOME_SUCCESS_TITLE 2220
#define IDS_ENTERPRISE_OIDC_WELCOME_SUCCESS_SUBTITLE 2221
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_TITLE 2222
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_SUBTITLE 2223
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_RETRY_LABEL 2224
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_TITLE 2225
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_SUBTITLE 2226
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_NO_SIGNIN_TITLE 2227
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_NO_SIGNIN_SUBTITLE 2228
#define IDS_ENTERPRISE_VALUE_PROPOSITION_CONSUMER_SUBTITLE 2229
#define IDS_ENTERPRISE_VALUE_PROPOSITION_CONSUMER_SUBTITLE_WITH_BOOKMARKS 2230
#define IDS_ENTERPRISE_VALUE_PROPOSITION_SCHOOL_SUBTITLE 2231
#define IDS_ENTERPRISE_VALUE_PROPOSITION_WORK_SUBTITLE 2232
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_WORK_TITLE 2233
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_SCHOOL_TITLE 2234
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_ALREADY_SIGNED_IN_TITLE 2235
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_CONSUMER_TITLE 2236
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_SCHOOL_CHOICE 2237
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_WORK_CHOICE 2238
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_ALREADY_SIGNED_IN_CHOICE 2239
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE_SCHOOL_NOT_RECOMMENDED 2240
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE_WORK_NOT_RECOMMENDED 2241
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE_DETAILS 2242
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE_ALREADY_SIGNED_IN_DETAILS 2243
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_WORK_CHOICE 2244
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_SCHOOL_CHOICE 2245
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_ALREADY_SIGNED_IN_CHOICE 2246
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_CHOICE_DETAILS 2247
#define IDS_BROWSING_HISTORY_COUNT 2248
#define IDS_BOOKMARKS_COUNT 2249
#define IDS_EXTENSIONS_COUNT 2250
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_WITH_THREE_COUNTS_CHOICE_DETAILS 2251
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_WITH_TWO_COUNTS_CHOICE_DETAILS 2252
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_WITH_ONE_COUNT_CHOICE_DETAILS 2253
#define IDS_SUPERVISED_USER_PROFILE_SIGNIN_IPH_TITLE 2254
#define IDS_SUPERVISED_USER_PROFILE_SIGNIN_IPH_TEXT 2255
#define IDS_MANAGED_BY_PARENT_A11Y 2256
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_KIDS_BODY 2257
#define IDS_PROFILE_PICKER_ADD_SPACE_BUTTON 2258
#define IDS_PROFILE_PICKER_BROWSE_AS_GUEST_BUTTON 2259
#define IDS_PROFILE_PICKER_BACK_BUTTON_ARIA_LABEL 2260
#define IDS_PROFILE_PICKER_BACK_BUTTON_SIGN_IN_LABEL 2261
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_KEEP_WORK_AND_LIFE_SEPARATE 2262
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_GOT_ANOTHER_GOOGLE_ACCOUNT 2263
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_KEEP_TASKS_SEPARATE 2264
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_SHARING_A_COMPUTER 2265
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_SHARING_A_COMPUTER 2266
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE_KEEP_EVERYTHING_IN_CHROME 2267
#define IDS_PROFILE_PICKER_PROFILE_CARD_NEEDS_SIGNIN_PROMPT 2268
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL_SUPERVISED 2269
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL 2270
#define IDS_PROFILE_PICKER_PROFILE_CARD_INPUT_LABEL 2271
#define IDS_PROFILE_PICKER_PROFILE_MORE_ACTIONS_ARIA_LABEL 2272
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_TEXT 2273
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_CONFIRM 2274
#define IDS_PROFILE_PICKER_PROFILE_MENU_CUSTOMIZE_TEXT 2275
#define IDS_PROFILE_PICKER_PROFILE_MENU_INCOGNITO_TEXT 2276
#define IDS_PROFILE_PICKER_ASK_ON_STARTUP 2277
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE_TITLE 2278
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_ALLOWED_TITLE 2279
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_ALLOWED_BODY 2280
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_WRONG_ACCOUNT_TITLE 2281
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_WRONG_ACCOUNT_BODY 2282
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_TIMEOUT_TITLE 2283
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_TIMEOUT_BODY 2284
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_SUPPORTED_BY_GLIC_FLOW_TITLE 2285
#define IDS_PROFILE_PICKER_REMOVE_WARNING_HISTORY 2286
#define IDS_PROFILE_PICKER_REMOVE_WARNING_PASSWORDS 2287
#define IDS_PROFILE_PICKER_REMOVE_WARNING_BOOKMARKS 2288
#define IDS_PROFILE_PICKER_REMOVE_WARNING_AUTOFILL 2289
#define IDS_PROFILE_PICKER_REMOVE_WARNING_CALCULATING 2290
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_SIGNIN_BUTTON_LABEL 2291
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_NOT_NOW_BUTTON_LABEL 2292
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_STAY_SIGNED_OUT_BUTTON_LABEL 2293
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_CUSTOMIZE_AVATAR_BUTTON_LABEL 2294
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_AVATAR_TEXT 2295
#define IDS_PROFILE_PICKER_TAKE_A_TOUR_BUTTON_LABEL 2296
#define IDS_PROFILE_PICKER_IPH_NEXT_BUTTON_LABEL 2297
#define IDS_PROFILE_PICKER_IPH_DONE_BUTTON_LABEL 2298
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TITLE 2299
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TITLE 2300
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TITLE 2301
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TEXT 2302
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SWITCH_BUTTON_LABEL 2303
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_BY_DESCRIPTION 2304
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_DESCRIPTION 2305
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE 2306
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE_TITLE 2307
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE 2308
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE_UNO 2309
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE_UNO_BOOKMARKS 2310
#define IDS_FRE_SIGN_IN_SUBTITLE_0 2311
#define IDS_FRE_SIGN_IN_SUBTITLE_1 2312
#define IDS_FRE_DEVICES_CARD_TITLE 2313
#define IDS_FRE_DEVICES_CARD_DESCRIPTION 2314
#define IDS_FRE_SECURITY_CARD_TITLE 2315
#define IDS_FRE_SECURITY_CARD_DESCRIPTION 2316
#define IDS_FRE_BACKUP_CARD_TITLE 2317
#define IDS_FRE_BACKUP_CARD_TITLE_V2 2318
#define IDS_UNO_FRE_BACKUP_CARD_DESCRIPTION 2319
#define IDS_UNO_FRE_BACKUP_CARD_DESCRIPTION_WITH_PASSWORDS 2320
#define IDS_FRE_DECLINE_SIGN_IN_BUTTON_TITLE 2321
#define IDS_FRE_STAY_SIGNED_OUT_BUTTON_TITLE 2322
#define IDS_FRE_ACCEPT_SIGN_IN_BUTTON_TITLE 2323
#define IDS_FRE_MANAGED_DESCRIPTION 2324
#define IDS_FRE_MANAGED_BY_DESCRIPTION 2325
#define IDS_FRE_DEFAULT_BROWSER_TITLE_NEW 2326
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE 2327
#define IDS_FRE_DEFAULT_BROWSER_SET_AS_DEFAULT 2328
#define IDS_FRE_DEFAULT_BROWSER_SKIP 2329
#define IDS_BATCH_UPLOAD_TITLE 2330
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_ITEMS_WITH_DEDUPLICATION 2331
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_PASSWORDS_WITH_DEDUPLICATION 2332
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_PASSWORDS_COMBO_WITH_DEDUPLICATION 2333
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_BOOKMARKS_WITH_DEDUPLICATION 2334
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_BOOKMARKS_COMBO_WITH_DEDUPLICATION 2335
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_ITEMS 2336
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_PASSWORDS 2337
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_PASSWORDS_COMBO 2338
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_BOOKMARKS 2339
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_BOOKMARKS_COMBO 2340
#define IDS_BATCH_UPLOAD_SECTION_TITLE_PASSWORDS 2341
#define IDS_BATCH_UPLOAD_SECTION_TITLE_BOOKMARKS 2342
#define IDS_BATCH_UPLOAD_SECTION_TITLE_READING_LIST 2343
#define IDS_BATCH_UPLOAD_SECTION_TITLE_ADDRESSES 2344
#define IDS_BATCH_UPLOAD_SECTION_TITLE_EXTENSIONS 2345
#define IDS_BATCH_UPLOAD_SECTION_TITLE_THEMES_WITH_DESCRIPTION 2346
#define IDS_BATCH_UPLOAD_SAVE_TO_ACCOUNT_OK_BUTTON_LABEL 2347
#define IDS_BATCH_UPLOAD_AVATAR_BUTTON_SAVING_TO_ACCOUNT 2348
#define IDS_BATCH_UPLOAD_LAST_ITEM_SELECTED_SCREEN_READER 2349
#define IDS_BATCH_UPLOAD_SCREEN_READER_ITEM_COUNT_SELECTED 2350
#define IDS_BATCH_UPLOAD_SCREEN_READER_SELECT_ALL 2351
#define IDS_BATCH_UPLOAD_SCREEN_READER_SELECT_NONE 2352
#define IDS_BATCH_UPLOAD_PROMO_TITLE 2353
#define IDS_BATCH_UPLOAD_PROMO_TITLE_OK_BUTTON_LABEL 2354
#define IDS_BATCH_UPLOAD_PROMO_SUBTITLE_BOOKMARKS 2355
#define IDS_BATCH_UPLOAD_PROMO_SUBTITLE_BOOKMARKS_COMBO 2356
#define IDS_SIGNOUT_CONFIRMATION_EXTENSIONS_SECTION_TITLE 2357
#define IDS_SIGNOUT_CONFIRMATION_EXTENSIONS_SECTION_TOOLTIP 2358
#define IDS_SIGNOUT_CONFIRMATION_UNSYNCED_DATA_WITH_ACCOUNT_EXTENSIONS 2359
#define IDS_HISTORY_SYNC_OPT_IN_TITLE 2360
#define IDS_HISTORY_SYNC_OPT_IN_SUBTITLE 2361
#define IDS_HISTORY_SYNC_OPT_IN_SUBTITLE_WITH_EMAIL 2362
#define IDS_HISTORY_SYNC_OPT_IN_DESCRIPTION 2363
#define IDS_HISTORY_SYNC_OPT_IN_ACCEPT_BUTTON 2364
#define IDS_HISTORY_SYNC_OPT_IN_REJECT_BUTTON 2365
#define IDS_TABS_DISABLED_ERROR_DESCRIPTION 2366
#define IDS_AVATAR_BUTTON_SYNC_HISTORY 2367
#define IDS_AVATAR_BUTTON_SYNC_PROMO 2368
#define IDS_AVATAR_BUTTON_BATCH_UPLOAD_PROMO 2369
#define IDS_AVATAR_BUTTON_BATCH_UPLOAD_PROMO_WITH_BOOKMARK_CLEANUP_PROMO 2370
#define IDS_PROFILE_MENU_SYNC_PROMO_SYNC_HISTORY_DESCRIPTION 2371
#define IDS_PROFILE_MENU_SYNC_PROMO_BUTTON_LABEL 2372
#define IDS_PROFILE_MENU_DESCRIPTION_WITH_SYNC_PROMO 2373
#define IDS_PROFILE_MENU_BUTTON_LABEL_WITH_SYNC_PROMO 2374
#define IDS_PROFILE_MENU_PROMO_DESCRIPTION_WITH_BATCH_UPLOAD 2375
#define IDS_PROFILE_MENU_PROMO_BUTTON_WITH_BATCH_UPLOAD 2376
#define IDS_PROFILE_MENU_PROMO_DESCRIPTION_WITH_BATCH_UPLOAD_BOOKMARK_CLEANUP 2377
#define IDS_SIGN_IN_BENEFITS_IPH_TEXT 2378
#define IDS_TYPE_A_SHORTCUT 2379
#define IDS_SHORTCUT_SET 2380
#define IDS_SHORTCUT_NOT_SET 2381
#define IDS_SHORTCUT_INCLUDE_START_MODIFIER 2382
#define IDS_SHORTCUT_TOO_MANY_MODIFIERS 2383
#define IDS_SHORTCUT_NEED_CHARACTER 2384
#define IDS_SETTINGS_EMPTY_STRING 7663
#define IDS_SETTINGS_CONTINUE 7664
#define IDS_SETTINGS_GOT_IT 7665
#define IDS_SETTINGS_MORE_ACTIONS 498
#define IDS_SETTINGS_MORE_ACTIONS_BUTTON_ARIA_LABEL 7666
#define IDS_SETTINGS_OPENS_IN_NEW_TAB 7667
#define IDS_SETTINGS_SEND_FEEDBACK_ROLE_DESCRIPTION 7668
#define IDS_SETTINGS_COLUMN_HEADING_WHEN_ON 7669
#define IDS_SETTINGS_COLUMN_HEADING_CONSIDER 7670
#define IDS_SETTINGS_COLUMN_HEADING_WHEN_USED 7671
#define IDS_RELAUNCH_CONFIRMATION_DIALOG_BODY 7672
#define IDS_SETTINGS_ABOUT_PAGE_BROWSER_VERSION 7673
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_UPDATE_ERRORS 7674
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_SYSTEM_REQUIREMENTS 7675
#define IDS_SETTINGS_ABOUT_PAGE_RELAUNCH 4684
#define IDS_SETTINGS_ACCESSIBILITY 7682
#define IDS_SETTINGS_ACCESSIBILITY_WEB_STORE 7683
#define IDS_SETTINGS_MORE_FEATURES_LINK 7684
#define IDS_SETTINGS_MORE_FEATURES_LINK_DESCRIPTION 7685
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_TITLE 7686
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_SUBTITLE 7687
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_COMPLETE 7688
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_ERROR 7689
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_PROGRESS 7690
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOADING 7691
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_TITLE 7692
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_SUBTITLE 7693
#define IDS_SETTINGS_AX_TREE_FIXING_TITLE 7694
#define IDS_SETTINGS_AX_TREE_FIXING_SUBTITLE 7695
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_TITLE 7696
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_TITLE 7697
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_SUBTITLE 7698
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE 7699
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_PROGRESS 7700
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_COMPLETE 7701
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR 7702
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 7703
#define IDS_SETTINGS_CAPTIONS_MASK_OFFENSIVE_WORDS_TITLE 7704
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_TITLE 7705
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_SUBTITLE 7706
#define IDS_SETTINGS_ACCESSIBILITY_FOCUS_HIGHLIGHT_DESCRIPTION 5420
#define IDS_SETTINGS_OVERSCROLL_HISTORY_NAVIGATION_TITLE 5352
#define IDS_SETTINGS_OVERSCROLL_HISTORY_NAVIGATION_SUBTITLE 7707
#define IDS_SETTINGS_ACCESSIBILITY_TOAST_FREQUENCY_TITLE 7708
#define IDS_SETTINGS_ACCESSIBILITY_TOAST_FREQUENCY_DESCRIPTION 7709
#define IDS_SETTINGS_APPEARANCE 7710
#define IDS_SETTINGS_CUSTOM_WEB_ADDRESS 7711
#define IDS_SETTINGS_ENTER_CUSTOM_WEB_ADDRESS 7712
#define IDS_SETTINGS_HOME_BUTTON_DISABLED 7713
#define IDS_SETTINGS_THEMES 7714
#define IDS_SETTINGS_RESET_TO_DEFAULT 7721
#define IDS_SETTINGS_RESET_TO_DEFAULT_THEME 7722
#define IDS_SETTINGS_CUSTOMIZE_TOOLBAR 7723
#define IDS_SETTINGS_RESET_TOOLBAR_TO_DEFAULT 7724
#define IDS_SETTINGS_CHROME_COLORS 7725
#define IDS_SETTINGS_COLOR_SCHEME_MODE 7726
#define IDS_SETTINGS_SHOW_HOME_BUTTON 7727
#define IDS_SETTINGS_SHOW_BOOKMARKS_BAR 7728
#define IDS_SETTINGS_ALLOW_SPLIT_VIEW_DRAG_AND_DROP 7729
#define IDS_SETTINGS_SHOW_TAB_GROUPS_IN_BOOKMARKS_BAR 7730
#define IDS_SETTINGS_AUTO_PIN_NEW_TAB_GROUPS 7731
#define IDS_SETTINGS_HOVER_CARD_TITLE 7732
#define IDS_SETTINGS_SHOW_HOVER_CARD_IMAGES 7733
#define IDS_SETTINGS_SHOW_HOVER_CARD_MEMORY_USAGE 7734
#define IDS_SETTINGS_SHOW_HOVER_CARD_MEMORY_USAGE_STANDALONE 7735
#define IDS_SETTINGS_SIDE_PANEL_POSITION 7736
#define IDS_SETTINGS_TAB_SEARCH_POSITION 7737
#define IDS_SETTINGS_UI_FEATURE_ALIGN_LEFT 7738
#define IDS_SETTINGS_UI_FEATURE_ALIGN_RIGHT 7739
#define IDS_SETTINGS_HOME_PAGE_NTP 7740
#define IDS_SETTINGS_CHANGE_HOME_PAGE 7741
#define IDS_SETTINGS_ADVANCED 7744
#define IDS_SETTINGS_BASIC 7745
#define IDS_SETTINGS_MENU_BUTTON_LABEL 7746
#define IDS_SETTINGS_MENU_EXTENSIONS_LINK_TOOLTIP 7747
#define IDS_SETTINGS_SEARCH_PROMPT 7748
#define IDS_SETTINGS_SEARCH_NO_RESULTS_HELP 7749
#define IDS_SETTINGS_SETTINGS 7750
#define IDS_SETTINGS_ALT_PAGE_TITLE 7751
#define IDS_SETTINGS_SUBPAGE_BUTTON 7752
#define IDS_SETTINGS_RESTART 7753
#define IDS_SETTINGS_CONTROLLED_BY_EXTENSION 7754
#define IDS_SETTINGS_CLEAR 7755
#define IDS_SETTINGS_CUSTOM 7756
#define IDS_SETTINGS_DELETE 7757
#define IDS_SETTINGS_EDIT 7758
#define IDS_SETTINGS_END_TIME 7759
#define IDS_SETTINGS_NOT_VALID 7760
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS 7761
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS_FOR_CONTENT_TYPE 7762
#define IDS_SETTINGS_INPUT_MAX_LENGTH_DESCRIPTION 7763
#define IDS_SETTINGS_RETRY 7764
#define IDS_SETTINGS_SLIDER_MIN_MAX_ARIA_ROLE_DESCRIPTION 7765
#define IDS_SETTINGS_START_TIME 7766
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7767
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7768
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7769
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7770
#define IDS_PASSWORDS_PAGE_DELETE_ALL_DATA_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7771
#define IDS_SETTINGS_AUTOFILL_AND_PASSWORDS 7772
#define IDS_SETTINGS_YOUR_SAVED_INFO 7773
#define IDS_SETTINGS_YOUR_SAVED_INFO_DESCRIPTION 7774
#define IDS_SETTINGS_YOUR_SAVED_INFO_AUTOFILL_SETTINGS_LABEL 7775
#define IDS_SETTINGS_YOUR_SAVED_INFO_AUTOFILL_SETTINGS_DESCRIPTION 7776
#define IDS_SETTINGS_RELATED_SERVICES_TITLE 7777
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7778
#define IDS_SETTINGS_GOOGLE_PAYMENTS 7779
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_ADD_TITLE 7780
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EDIT_TITLE 7781
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_COUNTRY 7782
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_PHONE 7783
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EMAIL 7784
#define IDS_SETTINGS_AUTOFILL_DETAIL 7785
#define IDS_SETTINGS_AUTOFILL_DROPDOWN_NO_OPTION_SELECTED 7786
#define IDS_SETTINGS_AUTOFILL_CARD_DESCRIPTION 7787
#define IDS_SETTINGS_AUTOFILL_CARD_A11Y_LABELED 7788
#define IDS_SETTINGS_AUTOFILL_CARD_EXP_DATE_A11Y_LABELED 7789
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_ADDRESS 7790
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD 7791
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD_WITH_CVC 7792
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_HOME_ADDRESS 7793
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_WORK_ADDRESS 7794
#define IDS_AUTOFILL_ADD_VIRTUAL_CARD 7795
#define IDS_AUTOFILL_REMOVE_VIRTUAL_CARD 7796
#define IDS_AUTOFILL_EDIT_SERVER_CREDIT_CARD 7797
#define IDS_AUTOFILL_VIRTUAL_CARD_TURNED_ON_LABEL 7798
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_TITLE 7799
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_LABEL 7800
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_CONFIRM_BUTTON_LABEL 7801
#define IDS_SETTINGS_ADDRESS_REMOVE 7802
#define IDS_SETTINGS_ADDRESS_REMOVE_CONFIRMATION_TITLE 7803
#define IDS_SETTINGS_ADDRESS_REMOVED_MESSAGE 7804
#define IDS_SETTINGS_EDIT_CREDIT_CARD_TITLE 7805
#define IDS_SETTINGS_LOCAL_CARD_REMOVE_CONFIRMATION_TITLE 7806
#define IDS_SETTINGS_LOCAL_PAYMENT_METHOD_REMOVE_CONFIRMATION_DESCRIPTION 7807
#define IDS_SETTINGS_PAYMENTS_MANAGE_CREDIT_CARDS 7808
#define IDS_SETTINGS_GOOGLE_WALLET 7809
#define IDS_SETTINGS_PAYMENTS_MANAGE_LOYALTY_CARDS_AND_PAYMENT_METHODS 7810
#define IDS_SETTINGS_REMOTE_WALLET_PASSES_LINK_LABEL 7811
#define IDS_SETTINGS_PAYMENTS_SAVED_TO_THIS_DEVICE_ONLY 7812
#define IDS_SETTINGS_CREDIT_AND_DEBIT_CARD_TITLE 7813
#define IDS_SETTINGS_ADD_CREDIT_CARD_TITLE 7814
#define IDS_SETTINGS_REMOTE_PAYMENT_METHODS_LINK_LABEL 7815
#define IDS_SETTINGS_NAME_ON_CREDIT_CARD 7816
#define IDS_SETTINGS_CREDIT_CARD_NUMBER 7817
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_DATE 7818
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_MONTH 7819
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_YEAR 7820
#define IDS_SETTINGS_CREDIT_CARD_EXPIRED 7821
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME 7822
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME_INVALID 7823
#define IDS_SETTINGS_CREDIT_CARD_CVC_TITLE 7824
#define IDS_SETTINGS_CREDIT_CARD_CVC_IMAGE_TITLE 7825
#define IDS_SETTINGS_CREDIT_CARD_CVC_IMAGE_TITLE_AMEX 7826
#define IDS_SETTINGS_CREDIT_CARD_CVC_PLACEHOLDER 7827
#define IDS_SETTINGS_ADD_PAYMENT_METHODS 7828
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_CREDIT_OR_DEBIT_CARD 7829
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_IBAN 7830
#define IDS_SETTINGS_IBAN_SAVED_TO_THIS_DEVICE_ONLY 7831
#define IDS_SETTINGS_IBAN_INVALID_VALIDATION_MESSAGE 7832
#define IDS_IBAN_NICKNAME 7833
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_IBAN 7834
#define IDS_SETTINGS_AUTOFILL_A11Y_IBAN_DESCRIPTION 7835
#define IDS_SETTINGS_ADD_IBAN_TITLE 7836
#define IDS_SETTINGS_EDIT_IBAN_TITLE 7837
#define IDS_SETTINGS_IBAN_EDIT 7838
#define IDS_SETTINGS_LOCAL_IBAN_REMOVE_CONFIRMATION_TITLE 7839
#define IDS_SETTINGS_PASSWORD_MANAGER 7840
#define IDS_SETTINGS_PASSWORD_MANAGER_DESCRIPTION 7841
#define IDS_SETTINGS_PAYMENT_METHODS_NONE 7842
#define IDS_AUTOFILL_PASSKEYS_TITLE 7843
#define IDS_SETTINGS_PASSKEYS_LENGTH_ERROR 7844
#define IDS_SETTINGS_PASSKEYS_SITE_LABEL 7845
#define IDS_SETTINGS_PASSKEYS_DIALOG_TITLE 7846
#define IDS_SETTINGS_PASSKEYS_EDIT_DIALOG_FOOTNOTE 7847
#define IDS_SETTINGS_ADDRESS_NONE 7848
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL 7849
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_SIGNED_OUT_ENABLED_DESC 7850
#define IDS_SETTINGS_CHECK_PASSWORDS_PROGRESS 7851
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT 7852
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT_SHORT 7853
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT_SHORT 7854
#define IDS_SETTINGS_REUSED_PASSWORDS_COUNT_SHORT 7855
#define IDS_SETTINGS_AUTOFILL_AI_PAGE_TITLE 7856
#define IDS_SETTINGS_AUTOFILL_AI_WHEN_ON_SAVED_INFO 7857
#define IDS_SETTINGS_AUTOFILL_AI_TO_CONSIDER_DATA_USAGE 7858
#define IDS_SETTINGS_AUTOFILL_AI_ENTERPRISE_LOGGING_MANAGED_DISABLED 7859
#define IDS_SETTINGS_AUTOFILL_AI_ENTITY_INSTANCES_HEADER 7860
#define IDS_SETTINGS_AUTOFILL_AI_ENTITY_INSTANCES_NONE 7861
#define IDS_SETTINGS_AUTOFILL_AI_MORE_ACTIONS_FOR_ENTITY_INSTANCE 7862
#define IDS_SETTINGS_AUTOFILL_AI_DELETE_ENTITY_INSTANCE_DIALOG_TEXT 7863
#define IDS_SETTINGS_AUTOFILL_AI_ACCESSIBILITY_LABEL_MONTH_DROPDOWN 7864
#define IDS_SETTINGS_AUTOFILL_AI_ACCESSIBILITY_LABEL_DAY_DROPDOWN 7865
#define IDS_SETTINGS_AUTOFILL_AI_ACCESSIBILITY_LABEL_YEAR_DROPDOWN 7866
#define IDS_SETTINGS_AUTOFILL_AI_MONTH_DROPDOWN_NO_OPTION_SELECTED 7867
#define IDS_SETTINGS_AUTOFILL_AI_DAY_DROPDOWN_NO_OPTION_SELECTED 7868
#define IDS_SETTINGS_AUTOFILL_AI_YEAR_DROPDOWN_NO_OPTION_SELECTED 7869
#define IDS_SETTINGS_AUTOFILL_AI_ADD_OR_EDIT_DIALOG_DATE_VALIDATION_ERROR 7870
#define IDS_SETTINGS_AUTOFILL_AI_ADD_OR_EDIT_DIALOG_VALIDATION_ERROR 7871
#define IDS_AUTOFILL_MANAGE_PASSKEYS_LABEL 7872
#define IDS_AUTOFILL_MANAGE_PASSKEYS_NO_SUPPORT 7873
#define IDS_AUTOFILL_MANAGE_PASSKEYS_TITLE 7874
#define IDS_AUTOFILL_MANAGE_PASSKEYS_SUB_TITLE_WIN 7875
#define IDS_AUTOFILL_MANAGE_PASSKEYS_SEARCH 7877
#define IDS_AUTOFILL_MANAGE_PASSKEYS_DELETE_CONFIRMATION_TITLE 7878
#define IDS_AUTOFILL_MANAGE_PASSKEYS_DELETE_CONFIRMATION_DESCRIPTION 7879
#define IDS_AUTOFILL_MANAGE_PASSKEYS_CANNOT_DELETE_TITLE 7880
#define IDS_AUTOFILL_MANAGE_PASSKEYS_CANNOT_DELETE_BODY 7881
#define IDS_AUTOFILL_MANAGE_PASSKEYS_MORE_ACTIONS_LABEL 7882
#define IDS_SETTINGS_PASSWORD_SHOW_PASSWORD_A11Y 7883
#define IDS_SETTINGS_PASSWORD_HIDE_PASSWORD_A11Y 7884
#define IDS_SETTINGS_HOME_AND_WORK_ADDRESS_EDIT 7885
#define IDS_SETTINGS_HOME_AND_WORK_ADDRESS_REMOVE 7886
#define IDS_SETTINGS_HOME_ADDRESS_REMOVE_CONFIRMATION_DIALOG_TITLE 7887
#define IDS_SETTINGS_WORK_ADDRESS_REMOVE_CONFIRMATION_DIALOG_TITLE 7888
#define IDS_SETTINGS_NAME_EMAIL_ADDRESS_REMOVE_CONFIRMATION_DIALOG_TITLE 7889
#define IDS_SETTINGS_HOME_ADDRESS_REMOVE_CONFIRMATION_DIALOG_NOTICE 7890
#define IDS_SETTINGS_WORK_ADDRESS_REMOVE_CONFIRMATION_DIALOG_NOTICE 7891
#define IDS_SETTINGS_NAME_EMAIL_ADDRESS_REMOVE_CONFIRMATION_DIALOG_NOTICE 7892
#define IDS_SETTINGS_HOME_AND_WORK_ADDRESS_REMOVE_CONFIRMATION_DIALOG_ACTION_OK 7893
#define IDS_SETTINGS_HOME_AND_WORK_ADDRESS_REMOVED_MESSAGE 7894
#define IDS_SETTINGS_NAME_EMAIL_ADDRESS_REMOVED_MESSAGE 7895
#define IDS_SETTINGS_DEFAULT_BROWSER 7896
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT_BUTTON 7897
#define IDS_SETTINGS_CLEAR_PERIOD_TITLE 7898
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC 7899
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_ERROR 7900
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PASSPHRASE_ERROR 7901
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PAUSED 7902
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY 7903
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC 7904
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_WITH_EXCEPTION 7905
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SUPERVISED_PROFILE 7906
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SIGNED_IN_PROFILE 7907
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY 7908
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY_SIGNED_IN_NO_LINK 7909
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_GOOGLE_DSE 7910
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_NON_GOOGLE_DSE 7911
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_PREPOPULATED_DSE 7912
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_NON_PREPOPULATED_DSE 7913
#define IDS_SETTINGS_CLEAR_DOWNLOAD_HISTORY 7914
#define IDS_SETTINGS_CLEAR_CACHE 7915
#define IDS_SETTINGS_CLEAR_COOKIES 7916
#define IDS_SETTINGS_CLEAR_PASSWORDS 7917
#define IDS_SETTINGS_CLEAR_FORM_DATA 7918
#define IDS_SETTINGS_CLEAR_HOSTED_APP_DATA 7919
#define IDS_SETTINGS_CLEAR_PERIOD_15_MIN 7920
#define IDS_SETTINGS_CLEAR_PERIOD_15_MINUTES 7921
#define IDS_SETTINGS_CLEAR_PERIOD_HOUR 7922
#define IDS_SETTINGS_CLEAR_PERIOD_24_HOURS 7923
#define IDS_SETTINGS_CLEAR_PERIOD_7_DAYS 7924
#define IDS_SETTINGS_CLEAR_PERIOD_FOUR_WEEKS 7925
#define IDS_SETTINGS_CLEAR_PERIOD_EVERYTHING 7926
#define IDS_SETTINGS_NOTIFICATION_WARNING 7927
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_SHOW_MORE 7928
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_MORE 7929
#define IDS_SETTINGS_MANAGE_IN_GOOGLE_PASSWORD_MANAGER 7930
#define IDS_SETTINGS_MANAGE_IN_YOUR_GOOGLE_ACCOUNT 7931
#define IDS_SETTINGS_MANAGE_IN_YOUR_GEMINI_APPS_ACTIVITY 7932
#define IDS_SETTINGS_GEMINI_APPS_ACTIVITY 7933
#define IDS_SETTINGS_PASSWORDS_AND_PASSKEYS 7934
#define IDS_SETTINGS_SEARCH_HISTORY 7935
#define IDS_SETTINGS_MY_ACTIVITY 7936
#define IDS_SETTINGS_OTHER_DATA_TITLE 7937
#define IDS_SETTINGS_OTHER_GOOGLE_DATA_TITLE 7938
#define IDS_SETTINGS_DELETE_DATA_FROM_DEVICE 7939
#define IDS_SETTINGS_DELETION_CONFIRMATION_TOAST_LABEL 7940
#define IDS_SETTINGS_DELETION_CONFIRMATION_ALL_TIME_TOAST_LABEL 7941
#define IDS_SETTINGS_MANAGE_OTHER_GOOGLE_DATA_LABEL 7942
#define IDS_SETTINGS_MANAGE_OTHER_DATA_LABEL 7943
#define IDS_SETTINGS_MANAGE_OTHER_DATA_SUB_LABEL 7944
#define IDS_SETTINGS_MANAGE_PASSWORDS_SUB_LABEL 7945
#define IDS_SETTINGS_SEARCH_GEMINI_PASSWORDS_OTHER_DATA_SUB_LABEL 7946
#define IDS_SETTINGS_OTHER_DATA_DESCRIPTION 7947
#define IDS_SETTINGS_DOWNLOADS 7948
#define IDS_SETTINGS_DOWNLOAD_LOCATION 7949
#define IDS_SETTINGS_CHANGE_DOWNLOAD_LOCATION 7950
#define IDS_SETTINGS_PROMPT_FOR_DOWNLOAD 7951
#define IDS_SETTINGS_OPEN_FILE_TYPES_AUTOMATICALLY 7952
#define IDS_SETTINGS_DOWNLOADS_SHOW_WHEN_FINISHED 7953
#define IDS_SETTINGS_ON_STARTUP 7954
#define IDS_SETTINGS_ON_STARTUP_OPEN_NEW_TAB 7955
#define IDS_SETTINGS_ON_STARTUP_CONTINUE 7956
#define IDS_SETTINGS_ON_STARTUP_OPEN_SPECIFIC 7957
#define IDS_SETTINGS_ON_STARTUP_CONTINUE_AND_OPEN_SPECIFIC 7958
#define IDS_SETTINGS_ON_STARTUP_USE_CURRENT 7959
#define IDS_SETTINGS_ON_STARTUP_ADD_NEW_PAGE 7960
#define IDS_SETTINGS_ON_STARTUP_EDIT_PAGE 7961
#define IDS_SETTINGS_ON_STARTUP_SITE_URL 7962
#define IDS_SETTINGS_ON_STARTUP_REMOVE 7963
#define IDS_SETTINGS_ON_STARTUP_PAGE_TOOLTIP 7964
#define IDS_SETTINGS_INVALID_URL 7965
#define IDS_SETTINGS_URL_TOOL_LONG 7966
#define IDS_SETTINGS_PERFORMANCE_PAGE_TITLE 7967
#define IDS_SETTINGS_PERFORMANCE_GENERAL_PAGE_TITLE 7968
#define IDS_SETTINGS_PERFORMANCE_MEMORY_PAGE_TITLE 7969
#define IDS_SETTINGS_PERFORMANCE_SPEED_PAGE_TITLE 7970
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_SETTING 7971
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_HEURISTICS_LABEL 7972
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_RECOMMENDED_BADGE 7973
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_ON_TIMER_LABEL 7974
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7975
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CHOOSE_DISCARD_TIME_ARIA_LABEL 7976
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CONSERVATIVE_LABEL 7977
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_MEDIUM_LABEL 7978
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_AGGRESSIVE_LABEL 7979
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CONSERVATIVE_DESCRIPTION 7980
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_MEDIUM_DESCRIPTION 7981
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_AGGRESSIVE_DESCRIPTION 7982
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_BUTTON_ARIA_LABEL 7983
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_SAVE_BUTTON_ARIA_LABEL 7984
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_HEADER 7985
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_DESCRIPTION 7986
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADDITIONAL_SITES 7987
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS 7988
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS_EMPTY 7989
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_MANUAL 7990
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ACTIVE_SITE_ARIA_DESCRIPTION 7991
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_HELP 7992
#define IDS_SETTINGS_PERFORMANCE_BATTERY_PAGE_TITLE 7993
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING 7994
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_ON_BATTERY_LABEL 7995
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_BELOW_THRESHOLD_LABEL 7996
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7997
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_LINK_OS_SETTING_DESCRIPTION 7998
#define IDS_SETTINGS_PERFORMANCE_DISCARD_RING_TREATMENT_ENABLED_LABEL 7999
#define IDS_SETTINGS_PERFORMANCE_DISCARD_RING_TREATMENT_ENABLED_DESCRIPTION_WITH_LEARN_LINK 8000
#define IDS_SETTINGS_PERFORMANCE_TAB_HOVER_PREVIEW_CARD_LINK_TITLE 8001
#define IDS_SETTINGS_PERFORMANCE_TAB_HOVER_PREVIEW_CARD_LINK_SUBTITLE 8002
#define IDS_SETTINGS_PERFORMANCE_INTERVENTION_NOTIFICATION_ENABLED_LABEL 8003
#define IDS_SETTINGS_PERFORMANCE_INTERVENTION_NOTIFICATION_ENABLED_DESCRIPTION 8004
#define IDS_SETTINGS_LANGUAGES_PAGE_TITLE 8005
#define IDS_SETTINGS_LANGUAGES_CARD_TITLE 8006
#define IDS_SETTINGS_LANGUAGE_SEARCH 8007
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_TO_TOP 8008
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_UP 8009
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_DOWN 8010
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_REMOVE 8011
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_ADD 8012
#define IDS_SETTINGS_LANGUAGES_MANAGE_LANGUAGES_TITLE 8013
#define IDS_SETTINGS_LANGUAGES_NO_LANGUAGES_ADDED 8014
#define IDS_SETTINGS_LANGUAGES_EXPAND_ACCESSIBILITY_LABEL 8015
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_HEADER 8016
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_DESC 8017
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE 8018
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE_SUBLABEL 8019
#define IDS_SETTINGS_LANGUAGES_TRANSLATE_TARGET 8020
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_TITLE 8021
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_BODY 8022
#define IDS_SETTINGS_LANGUAGES_ADD_ARIA_LABEL 8023
#define IDS_SETTINGS_LANGUAGES_REMOVE_AUTOMATIC_ARIA_LABEL 8024
#define IDS_SETTINGS_LANGUAGES_REMOVE_NEVER_ARIA_LABEL 8025
#define IDS_SETTINGS_TRANSLATE_PAGE_TITLE 8026
#define IDS_SETTINGS_TARGET_TRANSLATE_LABEL 8027
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE 8028
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE_ADD_ARIA_LABEL 8029
#define IDS_SETTINGS_LANGUAGES_NEVER_LANGUAGES 8030
#define IDS_SETTINGS_LANGUAGES_NEVER_TRANSLATE_ADD_ARIA_LABEL 8031
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_TITLE 8032
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_BASIC_LABEL 8033
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_LABEL 8034
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_DESCRIPTION 8035
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_SPELL_CHECK 8036
#define IDS_SETTING_LANGUAGES_SPELL_CHECK_DISABLED_REASON 8037
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_LANGUAGES_LIST_TITLE 8038
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_MANAGE 8039
#define IDS_SETTINGS_LANGUAGES_EDIT_DICTIONARY_TITLE 8040
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD 8041
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_BUTTON 8042
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_DUPLICATE_ERROR 8043
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_LENGTH_ERROR 8044
#define IDS_SETTINGS_LANGUAGES_DELETE_DICTIONARY_WORD_BUTTON 8045
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS 8046
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS_NONE 8047
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED 8048
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED_HELP 8049
#define IDS_SETTINGS_PRELOAD_PAGES_TITLE 8052
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_TITLE 8053
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_EXPAND_A11Y_LABEL 8054
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_SUMMARY 8055
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_ONE 8056
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_TITLE 8057
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_SUMMARY 8058
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_EXPAND_A11Y_LABEL 8059
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_ONE 8060
#define IDS_SETTINGS_PRIVACY 8061
#define IDS_SETTINGS_PRIVACY_V2 8062
#define IDS_SETTINGS_PRIVACY_MORE 8063
#define IDS_SETTINGS_AI_COMPOSE_SUBLABEL_V2 8065
#define IDS_SETTINGS_OFFER_WRITING_HELP_TOGGLE_LABEL 8066
#define IDS_SETTINGS_OFFER_WRITING_HELP_TOGGLE_SUB_LABEL 8067
#define IDS_SETTINGS_OFFER_WRITING_HELP_ENABLED_SUB_LABEL 8068
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SUB_LABEL 8069
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SITES_LABEL_V2 8070
#define IDS_SETTINGS_OFFER_WRITING_HELP_NO_DISABLED_SITES 8071
#define IDS_SETTINGS_OFFER_WRITING_HELP_REMOVE_SITE_ARIA_LABEL 8072
#define IDS_SETTINGS_COMPOSE_SETTING_LINK_A11Y 8073
#define IDS_SETTINGS_COMPOSE_WHEN_ON_WRITING_HELP 8074
#define IDS_SETTINGS_COMPOSE_WHEN_ON_WRITING_EXAMPLES 8075
#define IDS_SETTINGS_COMPOSE_WHEN_ON_WRITING_REFERENCES 8076
#define IDS_SETTINGS_COMPOSE_CONSIDER_DATA 8077
#define IDS_SETTINGS_ANTI_ABUSE_ENABLED_SUB_LABEL 8078
#define IDS_SETTINGS_ANTI_ABUSE_DISABLED_SUB_LABEL 8079
#define IDS_SETTINGS_ANTI_ABUSE_DESCRIPTION 8080
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_ONE 8081
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_TWO 8082
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_THREE 8083
#define IDS_SETTINGS_ANTI_ABUSE_THINGS_TO_CONSIDER_SECTION_ONE 8084
#define IDS_SETTINGS_PRIVACY_SANDBOX_TITLE 8085
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG 8086
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG_MORE 8087
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_LABEL 8088
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_SUB_LABEL 8089
#define IDS_SETTINGS_AD_PRIVACY_RESTRICTED_LINK_ROW_SUB_LABEL 8090
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TITLE 8091
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_LABEL 8092
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_ENABLED 8093
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_DISABLED 8094
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_LABEL 8095
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_ENABLED 8096
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_DISABLED 8097
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_LABEL 8098
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_ENABLED 8099
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_DISABLED 8100
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_REGION_A11Y_DESCRIPTION 8101
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_REGION_A11Y_DESCRIPTION 8102
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_V2 8103
#define IDS_SETTINGS_FLEDGE_PAGE_TITLE 8104
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_LABEL 8105
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_SUB_LABEL 8106
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_HEADING 8107
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION 8108
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE 8109
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_DISABLED 8110
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_EMPTY 8111
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_REGION_A11Y_DESCRIPTION 8112
#define IDS_SETTINGS_FLEDGE_PAGE_SEE_ALL_SITES_LABEL 8113
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE 8114
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE_A11Y_LABEL 8115
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_HEADING 8116
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION 8117
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION_EMPTY 8118
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_REGION_A11Y_DESCRIPTION 8119
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE 8120
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE_A11Y_LABEL 8121
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_HEADING 8122
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_1 8123
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_2 8124
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_3 8125
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE_A11Y_LABEL 8126
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TITLE 8127
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_LABEL 8128
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_SUB_LABEL 8129
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_1 8130
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_2 8131
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_3 8132
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_1 8133
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_2 8134
#define IDS_SETTINGS_PRIVACY_GUIDE_LABEL 8135
#define IDS_SETTINGS_PRIVACY_GUIDE_SUBLABEL 8136
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_HEADER 8137
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_START_BUTTON 8138
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_LABEL 8139
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_ROLE_DESC 8140
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_BUTTON 8141
#define IDS_SETTINGS_PRIVACY_GUIDE_STEPS 8142
#define IDS_SETTINGS_PRIVACY_GUIDE_NEXT_BUTTON 8143
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_HEADER 8144
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_SUB_HEADER 8145
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_HEADER 8146
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER 8147
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER_NO_LINKS 8148
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_LEAVE_BUTTON 8149
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_LABEL 8150
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL_AD_TOPICS 8151
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_LABEL 8152
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_AI_SETTINGS_LABEL 8153
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_CARD_HEADER 8154
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION1 8155
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION2 8156
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION1 8157
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_CARD_HEADER 8158
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_AND_TABS_SYNC_CARD_HEADER 8159
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_SETTING_LABEL 8160
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_AND_TABS_SYNC_SETTING_LABEL 8161
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION1 8162
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_AND_TABS_SYNC_FEATURE_DESCRIPTION1 8163
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION2 8164
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_PRIVACY_DESCRIPTION1 8165
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_HEADER 8166
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_HEADER 8167
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION1 8168
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION2 8169
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION3 8170
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION1 8171
#define IDS_SETTINGS_SAFETY_CHECK_ICON_INFO_ARIA_LABEL 8174
#define IDS_SETTINGS_SAFETY_CHECK_ICON_WARNING_ARIA_LABEL 8175
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW 8176
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_ARIA_LABEL 8177
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_LABEL 8178
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_PRIMARY_LABEL 8179
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SECONDARY_LABEL 8180
#define IDS_SETTINGS_SAFETY_HUB_REVOKED_PERMISSIONS_SECONDARY_LABEL 8181
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_BULK_LABEL 8182
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_LABEL 8183
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_LABEL 8184
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_DISABLED_BY_ADMIN 8185
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_PRIMARY_LABEL 8186
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_FEATURE_UNAVAILABLE 8187
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED 8188
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD 8189
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD_AVAILABLE_ENHANCED 8190
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_ENHANCED 8191
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_SAFE 8192
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_OFF 8193
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_USER 8194
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_ADMIN 8195
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_EXTENSIONS 8196
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_IGNORED_TOAST_LABEL 8197
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCKED_TOAST_LABEL 8198
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_RESET_TOAST_LABEL 8199
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_COUNT_LABEL 8200
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_LABEL 8201
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_ARIA_LABEL 8202
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_LABEL 8203
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_ARIA_LABEL 8204
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_LABEL 8205
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_ARIA_LABEL 8206
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_MORE_ACTIONS_ARIA_LABEL 8207
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_LABEL 8208
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_TOAST_LABEL 8209
#define IDS_SETTINGS_SAFETY_CHECK_TOAST_UNDO_BUTTON_LABEL 8210
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC 8211
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION 8212
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION_DESC 8213
#define IDS_SETTINGS_SAFEBROWSING_ENABLE_REPORTING_DESC 8214
#define IDS_SETTINGS_SAFEBROWSING_SECTION_LABEL 8215
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED 8216
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC_UPDATED 8217
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_EXPAND_ACCESSIBILITY_LABEL 8218
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_ONE 8219
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_THREE 8220
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FOUR 8221
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FIVE 8222
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_TWO 8223
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_THREE 8224
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_FOUR 8225
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_ONE 8226
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_TWO 8227
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_THREE 8228
#define IDS_SETTINGS_SAFEBROWSING_STANDARD 8229
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC 8230
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_EXPAND_ACCESSIBILITY_LABEL 8233
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_ONE 8234
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_HELP_IMPROVE 8235
#define IDS_SETTINGS_SAFEBROWSING_NONE 8236
#define IDS_SETTINGS_SAFEBROWSING_NONE_DESC 8237
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_TITLE 8238
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_DESC 8239
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_CONFIRM 8240
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK 8241
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TITLE 8242
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TEXT 8243
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_LEARN_MORE_ACCESSIBILITY_LABEL 8244
#define IDS_SETTINGS_PERMISSIONS 8245
#define IDS_SETTINGS_PERMISSIONS_DESCRIPTION 8246
#define IDS_SETTINGS_SECURITY 8247
#define IDS_SETTINGS_SECURITY_DESCRIPTION 8248
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM 8249
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM_DESC 8250
#define IDS_SETTINGS_SECURITY_TITLE 8251
#define IDS_SETTINGS_SECURITY_STANDARD_BUNDLE_TITLE 8252
#define IDS_SETTINGS_SECURITY_ENHANCED_BUNDLE_TITLE 8253
#define IDS_SETTINGS_SECURITY_SAFE_BROWSING_TITLE 8254
#define IDS_SETTINGS_SECURITY_SAFE_BROWSING_DESCRIPTION 8255
#define IDS_SETTINGS_SECURITY_SAFE_BROWSING_STANDARD_TITLE 8256
#define IDS_SETTINGS_SECURITY_SAFE_BROWSING_ENHANCED_TITLE 8257
#define IDS_SETTINGS_SECURE_CONNECTIONS_SECTION_TITLE 8258
#define IDS_SETTINGS_HTTPS_ONLY_MODE 8259
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION 8260
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION_ADVANCED_PROTECTION 8261
#define IDS_SETTINGS_HTTPS_FIRST_MODE_TITLE 8262
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DESCRIPTION 8263
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DESCRIPTION_ADVANCED_PROTECTION 8264
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_FULL_LABEL 8265
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_INCOGNITO_LABEL 8266
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DISABLED_LABEL 8267
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_STRICT_LABEL 8268
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_STRICT_SUBLABEL 8269
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_BALANCED_LABEL 8270
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_BALANCED_SUBLABEL 8271
#define IDS_SETTINGS_MANAGE_CERTIFICATES 8272
#define IDS_SETTINGS_MANAGE_CERTIFICATES_DESCRIPTION 8273
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES 8274
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES_DESCRIPTION 8275
#define IDS_SETTINGS_MANAGE 8276
#define IDS_SETTINGS_SECURE_DNS 8277
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION 8279
#define IDS_SETTINGS_SECURE_DNS_DROPDOWN_ACCESSIBILITY_LABEL 8280
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_DESCRIPTION 8281
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_PRIVACY_POLICY 8282
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_MANAGED_ENVIRONMENT 8283
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_PARENTAL_CONTROL 8284
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_DESCRIPTION 8285
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_PLACEHOLDER 8286
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_FORMAT_ERROR 8287
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_CONNECTION_ERROR 8288
#define IDS_SETTINGS_SECURITY_JAVASCRIPT_OPTIMIZATION_LINK_TITLE 8289
#define IDS_SETTINGS_CONTENT_SETTINGS 8290
#define IDS_SETTINGS_SITE_SETTINGS 8291
#define IDS_SETTINGS_SITE_SETTINGS_DESCRIPTION 8292
#define IDS_SETTINGS_CLEAR_DATA 8293
#define IDS_SETTINGS_CLEARING_DATA 8294
#define IDS_SETTINGS_CLEARED_DATA 8295
#define IDS_SETTINGS_CLEAR_BROWSING_DATA 8296
#define IDS_SETTINGS_CLEAR_DATA_DESCRIPTION 8297
#define IDS_SETTINGS_TITLE_AND_COUNT 8298
#define IDS_SETTINGS_SYNC_AND_GOOGLE_SERVICES_PRIVACY_DESC_UNIFIED_CONSENT 8299
#define IDS_SETTINGS_SEARCH_AGGREGATOR_PREF 8300
#define IDS_SETTINGS_RECENT_PERMISSIONS_NO_CHANGES 8301
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_ONE_ITEM 8302
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_TWO_ITEMS 8303
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_MORE_THAN_TWO_ITEMS 8304
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_ONE_ITEM 8305
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_TWO_ITEMS 8306
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_MORE_THAN_TWO_ITEMS 8307
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_ONE_ITEM 8308
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_TWO_ITEMS 8309
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_MORE_THAN_TWO_ITEMS 8310
#define IDS_SETTINGS_RESET_PROMPT_TITLE 8311
#define IDS_SETTINGS_RESET 8312
#define IDS_SETTINGS_RESET_SETTINGS_TRIGGER 8313
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_TITLE 8314
#define IDS_SETTINGS_RESET_BANNER_TEXT 8315
#define IDS_SETTINGS_RESET_BANNER_RESET_BUTTON_TEXT 8316
#define IDS_SETTINGS_RESET_LEARN_MORE_ACCESSIBILITY_TEXT 8317
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_V2_TITLE 8318
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_V2_BODY 8319
#define IDS_SETTINGS_RESET_PINNED_TABS 8320
#define IDS_SETTINGS_RESET_EXTENSIONS 8321
#define IDS_SETTINGS_RESET_HOMEPAGE 8322
#define IDS_SETTINGS_RESET_DSE 8323
#define IDS_SETTINGS_SEARCH 8326
#define IDS_SETTINGS_SEARCH_EXPLANATION_ACCESSIBILITY_LABEL 8327
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES 8328
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 8329
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_EXPLANATION 8330
#define IDS_SETTINGS_SEARCH_ENGINES 8331
#define IDS_SETTINGS_SEARCH_ENGINES_PAGE_EXPLANATION 8332
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH 8333
#define IDS_SETTINGS_SEARCH_ENGINES_SUBTITLE_FOR_POLICY 8334
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SITE_SEARCH 8335
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE 8336
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_SEARCH_ENGINE 8337
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SITE_SEARCH 8338
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_SITE_SEARCH 8339
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_TITLE 8340
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_DESCRIPTION 8341
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_DESCRIPTION_FOR_POLICY 8342
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES 8343
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES_EXPLANATION 8344
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH 8345
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION 8346
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION_STARTER_PACK 8347
#define IDS_SETTINGS_SEARCH_ENGINES_NO_SITES_ADDED 8348
#define IDS_SETTINGS_SEARCH_ENGINES_INACTIVE_SHORTCUTS 8349
#define IDS_SETTINGS_SEARCH_ENGINES_NO_OTHER_ENGINES 8350
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES 8351
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES_EXPLANATION 8352
#define IDS_SETTINGS_SEARCH_ENGINES_NAME 8353
#define IDS_SETTINGS_SEARCH_ENGINES_SHORTCUT 8354
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL 8355
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL_EXPLANATION 8356
#define IDS_SETTINGS_SEARCH_ENGINES_MAKE_DEFAULT 8357
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE 8358
#define IDS_SETTINGS_SEARCH_ENGINES_DEACTIVATE 8359
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_DETAILS 8360
#define IDS_SETTINGS_SEARCH_ENGINES_MANAGE_EXTENSION 8361
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TITLE 8362
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION 8363
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION_STARTER_PACK 8364
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_SPACE_OR_TAB 8365
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TAB 8366
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_SITES 8367
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_INACTIVE_SITES 8368
#define IDS_SETTINGS_SEARCH_ENGINES_MORE_ACTIONS_ARIA_LABEL 8369
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE_BUTTON_ARIA_LABEL 8370
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SITE_SEARCH_BUTTON_ARIA_LABEL 8371
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE_BUTTON_ARIA_LABEL 8372
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_HOST 8373
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_ANY_HOST 8374
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES 8375
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_DESCRIPTION 8376
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SEARCH 8377
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT 8378
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_MOST_VISITED 8379
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_STORAGE 8380
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_NAME 8381
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_HEADER 8382
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_EDIT_HEADER 8383
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANT_LABEL 8384
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANTS 8385
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_HEADER 8386
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_SITE_DETAILS 8387
#define IDS_SETTINGS_SITE_SETTINGS_SITE_ENTRY_PARTITIONED_LABEL 8388
#define IDS_SETTINGS_SITE_SETTINGS_SITE_REPRESENTATION_SEPARATOR 8389
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR 8390
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR_DESCRIPTION 8391
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DEFAULT_BEHAVIOR_DESC 8392
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DESC 8393
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS 8394
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION 8395
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION_SHORT 8396
#define IDS_SETTINGS_SITE_SETTINGS_ADS_DESCRIPTION 8397
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED 8398
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED 8399
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED_EXCEPTIONS 8400
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED_EXCEPTIONS 8401
#define IDS_SETTINGS_SITE_SETTINGS_AR_DESCRIPTION 8402
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED 8403
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED 8404
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED_EXCEPTIONS 8405
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED_EXCEPTIONS 8406
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_DESCRIPTION 8407
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED 8408
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED 8409
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED_EXCEPTIONS 8410
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED_EXCEPTIONS 8411
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_DESCRIPTION 8412
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_ALLOWED 8413
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_BLOCKED 8414
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_ALLOWED_EXCEPTIONS 8415
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_BLOCKED_EXCEPTIONS 8416
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_DESCRIPTION 8417
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED 8418
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED 8419
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_SUB_LABEL 8420
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED_EXCEPTIONS 8421
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_EXCEPTIONS 8422
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_DESCRIPTION 8423
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_ALLOWED 8424
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_BLOCKED 8425
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_DESCRIPTION 8426
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_ALLOWED 8427
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_BLOCKED 8428
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_ALLOWED_EXCEPTIONS 8429
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_BLOCKED_EXCEPTIONS 8430
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_DESCRIPTION 8431
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED 8432
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED 8433
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_SUB_LABEL 8434
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED_EXCEPTIONS 8435
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_EXCEPTIONS 8436
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_DESCRIPTION 8437
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED 8438
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED 8439
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED_EXCEPTIONS 8440
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED_EXCEPTIONS 8441
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_DESCRIPTION 8442
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED 8443
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED 8444
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED_EXCEPTIONS 8445
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED_EXCEPTIONS 8446
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_DESCRIPTION 8447
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED 8448
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED 8449
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED_EXCEPTIONS 8450
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED_EXCEPTIONS 8451
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_DESCRIPTION 8452
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_ALLOWED 8453
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED 8454
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED_EXCEPTIONS 8455
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_DESCRIPTION 8456
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED 8457
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED 8458
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED_EXCEPTIONS 8459
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED_EXCEPTIONS 8460
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_DESCRIPTION 8461
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_ALLOWED_EXCEPTIONS 8462
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_BLOCKED_EXCEPTIONS 8463
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_DESCRIPTION 8464
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_ALLOWED_EXCEPTIONS 8465
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_BLOCKED_EXCEPTIONS 8466
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_DESCRIPTION 8467
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ALLOWED 8468
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCKED 8469
#define IDS_SITE_SETTINGS_SMART_CARD_READERS 8470
#define IDS_SITE_SETTINGS_SMART_CARD_READERS_DESCRIPTION 8471
#define IDS_SITE_SETTINGS_SMART_CARDS_DEFAULT_DESCRIPTION 8472
#define IDS_SITE_SETTINGS_SMART_CARDS_ALLOWED 8473
#define IDS_SITE_SETTINGS_SMART_CARDS_BLOCKED 8474
#define IDS_SITE_SETTINGS_NO_SMART_CARD_READERS_FOUND 8475
#define IDS_SITE_SETTINGS_RESET_SMART_CARD_CONFIRMATION 8476
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_DESCRIPTION 8477
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED 8478
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED 8479
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_SUB_LABEL 8480
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED_EXCEPTIONS 8481
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_EXCEPTIONS 8482
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_DESCRIPTION 8483
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_ALLOWED_EXCEPTIONS 8484
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCKED_EXCEPTIONS 8485
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_DESCRIPTION 8486
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED 8487
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED 8488
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED_EXCEPTIONS 8489
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED_EXCEPTIONS 8490
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_ALLOWED 8491
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED 8492
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_UNFAMILIAR_SITES 8493
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_UNFAMILIAR_SITES_SUB_LABEL 8494
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_UNFAMILIAR_SITES_SAFE_BROWSING_OFF_SUB_LABEL 8495
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_ALLOWED_EXCEPTIONS 8496
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_EXCEPTIONS 8497
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_DESCRIPTION 8498
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_ALLOWED 8499
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_BLOCKED 8500
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_ALLOWED_EXCEPTIONS 8501
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_BLOCKED_EXCEPTIONS 8502
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_DESCRIPTION 8503
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED 8504
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED 8505
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_SUB_LABEL 8506
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED_EXCEPTIONS 8507
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_EXCEPTIONS 8508
#define IDS_SETTINGS_SITE_SETTINGS_MIC_DESCRIPTION 8509
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED 8510
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED 8511
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_SUB_LABEL 8512
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED_EXCEPTIONS 8513
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_EXCEPTIONS 8514
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_DESCRIPTION 8515
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED 8516
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED 8517
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED_EXCEPTIONS 8518
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED_EXCEPTIONS 8519
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_DESCRIPTION 8520
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED 8521
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED 8522
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_SUB_LABEL 8523
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED_EXCEPTIONS 8524
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_EXCEPTIONS 8525
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DESCRIPTION 8526
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED 8527
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL 8528
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL_SUB_LABEL 8529
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ASK_STATE 8530
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_QUIET 8531
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_CPSS 8532
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_LOUD 8533
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_TITLE 8534
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED 8535
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_SUB_LABEL 8536
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED_EXCEPTIONS 8537
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_EXCEPTIONS 8538
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_DESCRIPTION 8539
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED 8540
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED 8541
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED_EXCEPTIONS 8542
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED_EXCEPTIONS 8543
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_DESCRIPTION 8544
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_ALLOWED 8545
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_DESCRIPTION 8546
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_ALLOWED 8547
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_BLOCKED 8548
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_ALLOWED_EXCEPTIONS 8549
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_BLOCKED_EXCEPTIONS 8550
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_DESCRIPTION 8551
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED 8552
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED 8553
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED_EXCEPTIONS 8554
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED_EXCEPTIONS 8555
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_DESCRIPTION 8556
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_ALLOWED 8557
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED 8558
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED_SUB_LABEL 8559
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_EXPLANATION 8560
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_ALLOWED 8561
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED 8562
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED_SUB_LABEL 8563
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_ALLOWED_EXCEPTIONS 8564
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED_EXCEPTIONS 8565
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_DESCRIPTION 8567
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_ALLOWED 8568
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED 8569
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED_EXCEPTIONS 8570
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_DESCRIPTION 8571
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ALLOWED 8572
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_BLOCKED 8573
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_DESCRIPTION 8574
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED 8575
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED 8576
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_SUB_LABEL 8577
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED_EXCEPTIONS 8578
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_EXCEPTIONS 8579
#define IDS_SETTINGS_SITE_SETTINGS_USB_DESCRIPTION 8580
#define IDS_SETTINGS_SITE_SETTINGS_USB_ALLOWED 8581
#define IDS_SETTINGS_SITE_SETTINGS_USB_BLOCKED 8582
#define IDS_SETTINGS_SITE_SETTINGS_VR_DESCRIPTION 8583
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED 8584
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED 8585
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED_EXCEPTIONS 8586
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED_EXCEPTIONS 8587
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_DESCRIPTION 8588
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_ASK 8589
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_BLOCK 8590
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_ALLOWED_EXCEPTIONS 8591
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_BLOCKED_EXCEPTIONS 8592
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_DESCRIPTION 8593
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_ASK 8594
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_BLOCK 8595
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_ALLOWED_EXCEPTIONS 8596
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_BLOCKED_EXCEPTIONS 8597
#define IDS_SETTINGS_SITE_SETTINGS_ZOOM_LEVELS_DESCRIPTION 8598
#define IDS_SETTINGS_SITE_SETTINGS_AR_ASK 8599
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCK 8600
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_ASK 8601
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_BLOCK 8602
#define IDS_SETTINGS_SITE_SETTINGS_LOCAL_NETWORK_ACCESS_DESCRIPTION 8603
#define IDS_SETTINGS_SITE_SETTINGS_LOCAL_NETWORK_ACCESS_ASK 8604
#define IDS_SETTINGS_SITE_SETTINGS_LOCAL_NETWORK_ACCESS_BLOCK 8605
#define IDS_SETTINGS_SITE_SETTINGS_LOCAL_NETWORK_ACCESS_ALLOWED_EXCEPTIONS 8606
#define IDS_SETTINGS_SITE_SETTINGS_LOCAL_NETWORK_ACCESS_BLOCKED_EXCEPTIONS 8607
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DESCRIPTION 8608
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_TITLE 8609
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_LABEL 8610
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_ENABLED 8611
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED 8612
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_RADIO_LABEL 8613
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_RADIO_LABEL 8614
#define IDS_SETTINGS_COOKIES_RELATED_WEBSITE_SETS_TOGGLE_LABEL 8615
#define IDS_SETTINGS_COOKIES_RELATED_WEBSITE_SETS_TOGGLE_SUB_LABEL 8616
#define IDS_SETTINGS_COOKIES_ALL_SITES_LINK 8617
#define IDS_SETTINGS_TRACKING_PROTECTION_PAGE_DESCRIPTION 8618
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_ONE 8619
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_ONE_DESCRIPTION 8620
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO 8621
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO_DESCRIPTION 8622
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO_LEARN_MORE_ARIA_LABEL 8623
#define IDS_SETTINGS_TRACKING_PROTECTION_ADVANCED_LABEL 8624
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_TOGGLE_LABEL 8625
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_TOGGLE_SUB_LABEL 8626
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_LEARN_MORE_ARIA_LABEL 8627
#define IDS_SETTINGS_TRACKING_PROTECTION_DO_NOT_TRACK_TOGGLE_SUB_LABEL 8628
#define IDS_SETTINGS_TRACKING_PROTECTION_SITES_ALLOWED_COOKIES_TITLE 8629
#define IDS_SETTINGS_TRACKING_PROTECTION_SITES_ALLOWED_COOKIES_DESCRIPTION 8630
#define IDS_SETTINGS_SITE_SETTINGS_APP_PROTOCOL_HANDLERS 8631
#define IDS_SETTINGS_SITE_SETTINGS_APP_ALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 8632
#define IDS_SETTINGS_SITE_SETTINGS_APP_DISALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 8633
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ASK 8634
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCK 8635
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCK 8636
#define IDS_SETTINGS_SITE_SETTINGS_PDF_DOWNLOAD_PDFS 8637
#define IDS_SETTINGS_SITE_SETTINGS_RECENT_ACTIVITY 8638
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ASK_RECOMMENDED 8639
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_ZOOM_LEVEL 8640
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_SENDING 8641
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATICALLY_BLOCKED_NOTIFICATIONS 8642
#define IDS_SETTINGS_SITE_SETTINGS_SHOW_BLOCKED_NOTIFICATIONS_INDICATOR 8643
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_ASK_RECOMMENDED 8644
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_BLOCKED 8645
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_DESCRIPTION 8646
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK 8647
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED 8648
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK_EXCEPTIONS 8649
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED_EXCEPTIONS 8650
#define IDS_SETTINGS_SITE_SETTINGS_BLOCKED 8651
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW 8652
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK 8653
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY 8654
#define IDS_SETTINGS_SITE_SETTINGS_ASK_DEFAULT_MENU 8655
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_DEFAULT_MENU 8656
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DEFAULT_MENU 8657
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_DEFAULT_MENU 8658
#define IDS_SETTINGS_SITE_SETTINGS_ACTION_BLOCK_ON_UNFAMILIAR_SITES_DEFAULT_MENU 8659
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_DEFAULT_MENU 8660
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_MENU 8661
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_MENU 8662
#define IDS_SETTINGS_SITE_SETTINGS_ASK_MENU 8663
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_MENU 8664
#define IDS_SETTINGS_SITE_SETTINGS_RESET_MENU 8665
#define IDS_SETTINGS_SITE_SETTINGS_RESET_FROM_LIST_A11Y 8666
#define IDS_SETTINGS_SITE_SETTINGS_VIEW_FROM_LIST_A11Y 8667
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY_MENU 8668
#define IDS_SETTINGS_SITE_SETTINGS_USAGE 8669
#define IDS_SETTINGS_SITE_SETTINGS_USAGE_NONE 8670
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS 8671
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS_MORE 8672
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT 8673
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT_MORE 8674
#define IDS_SETTINGS_SITE_SETTINGS_ALLOWLISTED 8675
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_BLOCKLISTED_SINGULAR 8676
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_NOT_BLOCKLISTED_SINGULAR 8677
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_KILL_SWITCH 8678
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_INSECURE_ORIGIN 8679
#define IDS_SETTINGS_SITE_SETTINGS_RESET_BUTTON 8680
#define IDS_SETTINGS_SITE_SETTINGS_DELETE 8681
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIES_EXCEPTION_LABEL 8682
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_DIALOG_TITLE 8683
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_DIALOG_TITLE 8684
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_LEARN_MORE 8685
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_LEARN_MORE_ACCESSIBILITY 8686
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_DESCRIPTION 8687
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_DESCRIPTION 8688
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_LABEL 8689
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_LABEL 8690
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DETAILS_SUBPAGE_ACCESSIBILITY_LABEL 8691
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_MEMBERSHIP_LABEL 8692
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_MORE_ACTIONS_TITLE 8693
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_SHOW_RELATED_SITES_BUTTON 8694
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_SITE_DELETE_STORAGE_BUTTON 8695
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION 8696
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION 8697
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_RWS_STORAGE_CONFIRMATION 8698
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION_INSTALLED 8699
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION_INSTALLED 8700
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_RWS_STORAGE_CONFIRMATION_INSTALLED 8701
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_SIGN_OUT 8702
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_SIGN_OUT 8703
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_RWS_STORAGE_SIGN_OUT 8704
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_DIALOG_TITLE 8705
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_CONFIRMATION 8706
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_DIALOG_TITLE 8707
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION 8708
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION_NEW 8709
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_SIGN_OUT 8710
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_OFFLINE_DATA 8711
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_AD_PERSONALIZATION 8712
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_OFFLINE_DATA 8713
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_DIALOG_TITLE 8714
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_APP_DIALOG_TITLE 8715
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_PARTITIONED_DIALOG_TITLE 8716
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_DIALOG_TITLE 8717
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_DIALOG_TITLE 8718
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_PLURAL_DIALOG_TITLE 8719
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_LOGOUT 8720
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_LOGOUT 8721
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_OFFLINE_DATA 8722
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_PERMISSIONS 8723
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_CONFIRM 8724
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_SITE 8725
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_ALL 8726
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE 8727
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_IS_DEFAULT 8728
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_SET_DEFAULT 8729
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE 8730
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_ONLY 8731
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_SITE_EXCEPTION_DESC 8732
#define IDS_SETTINGS_SITE_SETTINGS_NO_ZOOMED_SITES 8733
#define IDS_SETTINGS_SITE_NO_SITES_ADDED 8734
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_AUTOPLAY 8735
#define IDS_SETTINGS_SITE_SETTINGS_EMPTY_ALL_SITES_PAGE 8736
#define IDS_SETTINGS_SITE_SETTINGS_NO_SITES_FOUND 8737
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_DESCRIPTION 8738
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ASK 8739
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCK 8740
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ALLOWED_EXCEPTIONS 8741
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCKED_EXCEPTIONS 8742
#define IDS_SETTINGS_SITE_SETTINGS_EXTENSION_ID_DESCRIPTION 8743
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_ALLOWED_SUB_LABEL 8744
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_BLOCKED_SUB_LABEL 8745
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_DELETE_ON_EXIT_SUB_LABEL 8746
#define IDS_SETTINGS_EXPIRES_AFTER_TIME_LABEL 8747
#define IDS_SETTINGS_SITE_DATA_PAGE_TITLE 8748
#define IDS_SETTINGS_SITE_DATA_PAGE_DESCRIPTION 8749
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_HEADING 8750
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 8751
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_LABEL 8752
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_SUB_LABEL 8753
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_LABEL 8754
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_LABEL 8755
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_SUB_LABEL 8756
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 8757
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 8758
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 8759
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_EXCEPTIONS_SUB_HEADING 8760
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_TITLE 8761
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_DESCRIPTION 8762
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CONFIRM_BUTTON 8763
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CANCEL_BUTTON 8764
#define IDS_SETTINGS_ADD_SITE_TO_ALLOW_LIST_LABEL 8765
#define IDS_SETTINGS_ADD_SITE_TO_BLOCK_LIST_LABEL 8766
#define IDS_SETTINGS_ADD_SITE_CONTEXT_MENU_LABEL 8767
#define IDS_SETTINGS_STORAGE_ACCESS_DESCRIPTION 8768
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED 8769
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED 8770
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_EXCEPTIONS 8771
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_EXCEPTIONS 8772
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_ALL 8773
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_SITE 8774
#define IDS_SETTINGS_STORAGE_ACCESS_OPEN_EXPAND 8775
#define IDS_SETTINGS_STORAGE_ACCESS_CLOSE_EXPAND 8776
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_SITE_LABEL 8777
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_SITE_LABEL 8778
#define IDS_SETTINGS_NO_BLUETOOTH_DEVICES_FOUND 8779
#define IDS_SETTINGS_NO_USB_DEVICES_FOUND 8780
#define IDS_SETTINGS_NO_SERIAL_PORTS_FOUND 8781
#define IDS_SETTINGS_NO_HID_DEVICES_FOUND 8782
#define IDS_SETTINGS_RESET_BLUETOOTH_CONFIRMATION 8783
#define IDS_SETTINGS_RESET_HID_CONFIRMATION 8784
#define IDS_SETTINGS_RESET_SERIAL_PORTS_CONFIRMATION 8785
#define IDS_SETTINGS_RESET_USB_CONFIRMATION 8786
#define IDS_SETTINGS_ADD_SITE_TITLE 8787
#define IDS_SETTINGS_ADD_SITES_TITLE 8788
#define IDS_SETTINGS_EDIT_SITE_TITLE 8789
#define IDS_SETTINGS_ADD_SITE 8790
#define IDS_SETTINGS_SITE_SETTINGS_NUM_COOKIES 8791
#define IDS_SETTINGS_PEOPLE 8792
#define IDS_SETTINGS_CHANGE_PICTURE_PROFILE_PHOTO 8793
#define IDS_SETTINGS_PEOPLE_SIGN_IN 8794
#define IDS_SETTINGS_PEOPLE_VERIFY_ACCOUNT_BUTTON 8795
#define IDS_SETTINGS_TURN_OFF_SYNC_MANAGED_PROFILE_EXPLANATION 8796
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE 8797
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE_SUPERVISED_PROFILE 8798
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_MANAGED_CONFIRM 8799
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_CHECKBOX 8800
#define IDS_SETTINGS_SYNC_SETTINGS_SAVED_TOAST_LABEL 8801
#define IDS_SETTINGS_CHROME_SIGNIN_OPTION_SAVED_TOAST_LABEL 8802
#define IDS_SETTINGS_PROFILE_NAME_INPUT_LABEL 8803
#define IDS_SETTINGS_PROFILE_SHORTCUT_TOGGLE_LABEL 8804
#define IDS_SETTINGS_CUSTOMIZE_PROFILE 8805
#define IDS_SETTINGS_PICK_A_THEME_COLOR 8806
#define IDS_SETTINGS_PICK_AN_AVATAR 8807
#define IDS_SETTINGS_CREATE_SHORTCUT 8808
#define IDS_SETTINGS_CREATE_SHORTCUT_SUBTITLE 8809
#define IDS_SETTINGS_ACCOUNT_PAGE_TITLE 8810
#define IDS_SETTINGS_ACCOUNT_DATATYPES_HEADING 8811
#define IDS_SETTINGS_ACCOUNT_BODY 8812
#define IDS_SETTINGS_ACCOUNT_SYNC_DISABLED 8813
#define IDS_SETTINGS_ACCOUNT_HISTORY_TOGGLE 8814
#define IDS_SETTINGS_GOOGLE_SERVICES_PAGE_TITLE 8815
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPLANATION 8816
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION 8817
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION_SUPERVISED_PROFILE 8818
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPAND_ACCESSIBILITY_LABEL 8819
#define IDS_SETTINGS_SYNC_WILL_START 8820
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_LABEL 8821
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_TEXT 8822
#define IDS_SETTINGS_ENCRYPT_WITH_SYNC_PASSPHRASE_LABEL 8823
#define IDS_SETTINGS_PASSPHRASE_EXPLANATION_TEXT 8824
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_ENCRYPTION 8825
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_TOGGLE 8826
#define IDS_SETTINGS_PASSPHRASE_RECOVER 8827
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE 8828
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE_V2 8829
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_WAA_TITLE 8830
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_LINKED_SERVICES_TITLE 8831
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_PLACEHOLDER 8832
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_SIGNIN 8833
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_DO_NOT_SIGNIN 8834
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_ALWAYS_ASK 8835
#define IDS_SETTINGS_GOOGLE_ACCOUNT 8836
#define IDS_SETTINGS_MANAGE_GOOGLE_ACCOUNT 8837
#define IDS_SETTINGS_IMPORT_SETTINGS_TITLE 8838
#define IDS_SETTINGS_IMPORT_FROM_LABEL 8839
#define IDS_SETTINGS_IMPORT_ITEMS_LABEL 8840
#define IDS_SETTINGS_IMPORT_LOADING_PROFILES 8841
#define IDS_SETTINGS_IMPORT_HISTORY_CHECKBOX 8842
#define IDS_SETTINGS_IMPORT_FAVORITES_CHECKBOX 8843
#define IDS_SETTINGS_IMPORT_PASSWORDS_CHECKBOX 8844
#define IDS_SETTINGS_IMPORT_SEARCH_ENGINES_CHECKBOX 8845
#define IDS_SETTINGS_IMPORT_AUTOFILL_FORM_DATA_CHECKBOX 8846
#define IDS_SETTINGS_IMPORT_CHOOSE_FILE 8847
#define IDS_SETTINGS_IMPORT_COMMIT 8848
#define IDS_SETTINGS_IMPORT_SUCCESS 8849
#define IDS_SETTINGS_IMPORT_NO_PROFILE_FOUND 8850
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_LABEL 8851
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_SUBLABEL_V2 8852
#define IDS_SETTINGS_HISTORY_SEARCH_LEARN_MORE_A11Y_LABEL 8853
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_PAGE_CONTENT 8854
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_SEARCH_FROM 8855
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_LOG_START 8856
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_DATA 8857
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_DATA_ENCRYPTED 8858
#define IDS_SETTINGS_HISTORY_SEARCH_SUBLABEL_ON 8859
#define IDS_SETTINGS_HISTORY_SEARCH_SUBLABEL_OFF 8860
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_SETTING_SUBLABEL_V2 8861
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_WHEN_ON_PAGE_CONTENT 8862
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_WHEN_ON_RECALL_INFO 8863
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_CONSIDER_DATA_ENCRYPTED 8864
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_CONSIDER_OUTDATED 8865
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_SUBLABEL_ON 8866
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_SUBLABEL_OFF 8867
#define IDS_SETTINGS_PAGE_ZOOM_LABEL 8868
#define IDS_SETTINGS_FONT_SIZE_LABEL 8869
#define IDS_SETTINGS_VERY_SMALL_FONT 8870
#define IDS_SETTINGS_SMALL_FONT 8871
#define IDS_SETTINGS_MEDIUM_FONT 8872
#define IDS_SETTINGS_LARGE_FONT 8873
#define IDS_SETTINGS_VERY_LARGE_FONT 8874
#define IDS_SETTINGS_CUSTOMIZE_FONTS 8875
#define IDS_SETTINGS_FONTS 8876
#define IDS_SETTINGS_STANDARD_FONT_LABEL 8877
#define IDS_SETTINGS_SERIF_FONT_LABEL 8878
#define IDS_SETTINGS_SANS_SERIF_FONT_LABEL 8879
#define IDS_SETTINGS_FIXED_WIDTH_FONT_LABEL 8880
#define IDS_SETTINGS_MATH_FONT_LABEL 8881
#define IDS_SETTINGS_MINIMUM_FONT_SIZE_LABEL 8882
#define IDS_SETTINGS_TINY_FONT_SIZE 8883
#define IDS_SETTINGS_HUGE_FONT_SIZE 8884
#define IDS_SETTINGS_QUICK_BROWN_FOX 8885
#define IDS_SETTINGS_SYSTEM 8886
#define IDS_SETTINGS_SYSTEM_HARDWARE_ACCELERATION_LABEL 8887
#define IDS_SETTINGS_SYSTEM_FEATURE_NOTIFICATIONS_LABEL 8888
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_LABEL 8889
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_EXTENSION_LABEL 8890
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_POLICY_LABEL 8891
#define IDS_PAGE_NOT_AVAILABLE_FOR_GUEST_HEADING 8892
#define IDS_SETTINGS_SECURITY_KEYS_TITLE 8893
#define IDS_SETTINGS_SECURITY_KEYS_DESC 8894
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN 8895
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_BUTTON 8896
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_DESC 8897
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_INITIAL_TITLE 8898
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CREATE_TITLE 8899
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CHANGE_TITLE 8900
#define IDS_SETTINGS_SECURITY_KEYS_RESET 8901
#define IDS_SETTINGS_SECURITY_KEYS_RESET_DESC 8902
#define IDS_SETTINGS_SECURITY_KEYS_RESET_TITLE 8903
#define IDS_SETTINGS_SECURITY_KEYS_RESET_CONFIRM_TITLE 8904
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP1 8905
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP2 8906
#define IDS_SETTINGS_SECURITY_KEYS_NO_RESET 8907
#define IDS_SETTINGS_SECURITY_KEYS_RESET_ERROR 8908
#define IDS_SETTINGS_SECURITY_KEYS_RESET_SUCCESS 8909
#define IDS_SETTINGS_SECURITY_KEYS_RESET_NOTALLOWED 8910
#define IDS_SETTINGS_SECURITY_KEYS_NO_PIN 8911
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN_INTRO 8912
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT 8913
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_SIN 8914
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_PL 8915
#define IDS_SETTINGS_SECURITY_KEYS_SAME_PIN_AS_CURRENT 8916
#define IDS_SETTINGS_SECURITY_KEYS_NEW_PIN 8917
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CONFIRM 8918
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN 8919
#define IDS_SETTINGS_SECURITY_KEYS_PIN 8920
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_SHORT_SMALL 8921
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_LONG 8922
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_INVALID 8923
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_MISMATCH 8924
#define IDS_SETTINGS_SECURITY_KEYS_CONFIRM_PIN 8925
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SUCCESS 8926
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR 8927
#define IDS_SETTINGS_SECURITY_KEYS_PIN_HARD_LOCK 8928
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SOFT_LOCK 8929
#define IDS_SETTINGS_SECURITY_KEYS_SHOW_PINS 8930
#define IDS_SETTINGS_SECURITY_KEYS_HIDE_PINS 8931
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_LABEL 8932
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_USERNAME_LABEL 8933
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_DISPLAYNAME_LABEL 8934
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_WEBSITE_LABEL 8935
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DESC 8936
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DIALOG_TITLE 8937
#define IDS_SETTINGS_SECURITY_KEYS_UPDATE_CREDENTIAL_DIALOG_TITLE 8938
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_TITLE 8939
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_CREDENTIAL 8940
#define IDS_SETTINGS_SECURITY_KEYS_INPUT_ERROR_TOO_LONG 8941
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_CREDENTIALS 8942
#define IDS_SETTINGS_SECURITY_KEYS_NO_CREDENTIAL_MANAGEMENT 8943
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_REMOVED 8944
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_PIN 8945
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_ERROR 8946
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_SUCCESS 8947
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_FAILED 8948
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_SUCCESS 8949
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_FAILED 8950
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_LABEL 8951
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_DESCRIPTION 8952
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DIALOG_TITLE 8953
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ADD_TITLE 8954
#define IDS_SETTINGS_SECURITY_KEYS_BIO_CHOOSE_NAME 8955
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL 8956
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL_TOO_LONG 8957
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_NO_ENROLLMENTS_LABEL 8958
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLMENTS_LABEL 8959
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_LABEL 8960
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_TRY_AGAIN_LABEL 8961
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_FAILED_LABEL 8962
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_COMPLETE_LABEL 8963
#define IDS_SETTINGS_SECURITY_KEYS_NO_BIOMETRIC_ENROLLMENT 8964
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DELETE 8965
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NO_PIN 8966
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_STORAGE_FULL 8967
#define IDS_SETTINGS_SECURITY_KEYS_TOUCH_TO_CONTINUE 8968
#define IDS_SETTINGS_SECURITY_KEYS_PIN_PROMPT 8969
#define IDS_SETTINGS_SECURITY_KEYS_FORCE_PIN_CHANGE 8970
#define IDS_SETTINGS_EXTENSION_OR_APP_DISPLAY_NAME 8971
#define IDS_SETTINGS_SAFETY_HUB 8972
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_BUTTON_LABEL 8973
#define IDS_SETTINGS_SAFETY_HUB_PAGE_CARD_SECTION_HEADER 8974
#define IDS_SETTINGS_SAFETY_HUB_PAGE_MODULE_SECTION_HEADER 8975
#define IDS_SETTINGS_SAFETY_HUB_EMPTY_STATE_MODULE_HEADER 8976
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_RECENTLY 8977
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_SOME_TIME_AGO 8978
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_HEADER_NO_WEAK_OR_REUSED 8979
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_SIGN_IN 8980
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_GO_TO_PASSWORD_MANAGER 8981
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_HEADER_NO_PASSWORDS 8982
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_NO_PASSWORDS_POLICY 8983
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_NAVIGATION_ARIA_LABEL 8984
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_ENHANCED_HEADER 8985
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_ENHANCED_SUBHEADER 8986
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_STANDARD_HEADER 8987
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_STANDARD_SUBHEADER 8988
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_HEADER 8989
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_MANAGED_SUBHEADER 8990
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_EXTENSION_SUBHEADER 8991
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_USER_SUBHEADER 8992
#define IDS_SETTINGS_SAFETY_HUB_SB_NAVIGATION_ARIA_LABEL 8993
#define IDS_SETTINGS_SAFETY_HUB_GO_SITE_SETTINGS_ITEM 8994
#define IDS_SETTINGS_SAFETY_HUB_GO_NOTIFICATION_SETTINGS_ITEM 8995
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_INCOGNITO_SUBHEADER 8996
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_SAFE_BROWSING_HEADER 8997
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_SUBHEADER_RESTART 8998
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATION_PERMISSIONS_PRIMARY_LABEL 8999
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATION_PERMISSIONS_SECONDARY_LABEL 9000
#define IDS_SETTINGS_SAFETY_HUB_REVOKED_PERMISSIONS_MENU_NOTIFICATION 9001
#define IDS_SETTINGS_SAFETY_HUB_REVIEW_NOTIFICATION_PERMISSIONS_MENU_NOTIFICATION 9002
#define IDS_SETTINGS_SAFETY_HUB_COMPROMISED_PASSWORDS_MENU_NOTIFICATION 9003
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MENU_NOTIFICATION 9004
#define IDS_SETTINGS_SAFETY_HUB_SAFE_BROWSING_MENU_NOTIFICATION 9005
#define IDS_SETTINGS_SAFETY_HUB_PASSWORDS_MODULE_NAME 9006
#define IDS_SETTINGS_SAFETY_HUB_SAFE_BROWSING_MODULE_NAME 9007
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MODULE_UPPERCASE_NAME 9008
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MODULE_LOWERCASE_NAME 9009
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATIONS_MODULE_UPPERCASE_NAME 9010
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATIONS_MODULE_LOWERCASE_NAME 9011
#define IDS_SETTINGS_SAFETY_HUB_PERMISSIONS_MODULE_UPPERCASE_NAME 9012
#define IDS_SETTINGS_SAFETY_HUB_PERMISSIONS_MODULE_LOWERCASE_NAME 9013
#define IDS_SETTINGS_SAFETY_HUB_MODULE_NAME_SEPARATOR 9014
#define IDS_SETTINGS_AI_INNOVATIONS_PAGE_TITLE 9015
#define IDS_SETTINGS_AI_PAGE_MAIN_TITLE 9016
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL_1 9017
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL_2 9018
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL_3 9019
#define IDS_SETTINGS_AI_PAGE_MAIN_MANAGED_SUBLABEL_3 9020
#define IDS_SETTINGS_AI_PAGE_MAIN_MANAGED_LEARN_MORE_ACCESSIBILITY_LABEL 9021
#define IDS_SETTINGS_AI_SUBPAGE_SUBLABEL_AI 9022
#define IDS_SETTINGS_AI_SUBPAGE_SUBLABEL_REVIEWERS 9023
#define IDS_SETTINGS_AI_SUBPAGE_SUBLABEL_LOGGING_MANAGED_DISABLED 9024
#define IDS_SETTINGS_AI_SUBPAGE_FEATURE_MANAGED_DISABLED_LABEL 9025
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE2_LABEL 9026
#define IDS_SETTINGS_TAB_ORGANIZER_SUB_LABEL 9027
#define IDS_SETTINGS_AUTOTABS_SETTING_LINK_A11Y 9028
#define IDS_SETTINGS_TAB_ORGANIZER_WHEN_ON_AUTO_GROUPS 9029
#define IDS_SETTINGS_TAB_ORGANIZER_WHEN_ON_IMPROVE_FOCUS 9030
#define IDS_SETTINGS_TAB_ORGANIZER_CONSIDER_DATA 9031
#define IDS_SETTINGS_COMPARE_SETTING_SUBLABEL 9032
#define IDS_SETTINGS_COMPARE_SETTING_LINK_A11Y 9033
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_DETAILS 9034
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_SUGGEST 9035
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_FILTER 9036
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_REVIEWS 9037
#define IDS_SETTINGS_COMPARE_CONSIDER_DATA 9038
#define IDS_SETTINGS_COMPARE_CONSIDER_TABLES_IN_ACCOUNT 9039
#define IDS_SETTINGS_PASSWORD_CHANGE_LABEL 9040
#define IDS_SETTINGS_PASSWORD_CHANGE_SUBLABEL 9041
#define IDS_SETTINGS_PASSWORD_CHANGE_DATA_BREACH 9042
#define IDS_SETTINGS_PASSWORD_CHANGE_WHERE_SAVED 9043
#define IDS_SETTINGS_PASSWORD_CHANGE_EXPERIMENTAL 9044
#define IDS_SETTINGS_PASSWORD_CHANGE_CONTENT 9045
#define IDS_SETTINGS_PASSWORD_CHANGE_ENCRYPTION 9046
#define IDS_SETTINGS_SAFEBROWSING_TURN_ON_ENHANCED_TOAST_BUTTON 9047
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_ON_TOAST_MESSAGE 9048
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_OFF_TOAST_MESSAGE 9049
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_LABEL 9050
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 9051
#define IDS_SETTINGS_SUBPAGE_LEARN_MORE_ARIA_LABEL 9052
#define IDS_SETTINGS_CAPTIONS 9053
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_TITLE 9054
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_SUBTITLE 9055
#define IDS_SETTINGS_CAPTIONS_TEXT_SIZE 9056
#define IDS_SETTINGS_CAPTIONS_TEXT_FONT 9057
#define IDS_SETTINGS_CAPTIONS_TEXT_COLOR 9058
#define IDS_SETTINGS_CAPTIONS_TEXT_OPACITY 9059
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_OPACITY 9060
#define IDS_SETTINGS_CAPTIONS_OPACITY_OPAQUE 9061
#define IDS_SETTINGS_CAPTIONS_OPACITY_SEMI_TRANSPARENT 9062
#define IDS_SETTINGS_CAPTIONS_OPACITY_TRANSPARENT 9063
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW 9064
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_NONE 9065
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_RAISED 9066
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DEPRESSED 9067
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_UNIFORM 9068
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DROP_SHADOW 9069
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_COLOR 9070
#define IDS_SETTINGS_CAPTIONS_COLOR_BLACK 9071
#define IDS_SETTINGS_CAPTIONS_COLOR_WHITE 9072
#define IDS_SETTINGS_CAPTIONS_COLOR_RED 9073
#define IDS_SETTINGS_CAPTIONS_COLOR_GREEN 9074
#define IDS_SETTINGS_CAPTIONS_COLOR_BLUE 9075
#define IDS_SETTINGS_CAPTIONS_COLOR_YELLOW 9076
#define IDS_SETTINGS_CAPTIONS_COLOR_CYAN 9077
#define IDS_SETTINGS_CAPTIONS_COLOR_MAGENTA 9078
#define IDS_SETTINGS_CAPTIONS_DEFAULT_SETTING 9079
#define IDS_SETTINGS_CAPTIONS_LANGUAGE 9080
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_TITLE 9081
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_SUBTITLE 9082
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_SUBTITLE_LIVE_CAPTION_ONLY 9083
#define IDS_SETTINGS_CAPTIONS_LIVE_TRANSLATE_TARGET_LANGUAGE 9084
#define IDS_SETTINGS_CAPTIONS_LIVE_TRANSLATE_TARGET_LANGUAGE_SUBTITLE 9085
#define IDS_SETTINGS_CAPTIONS_REMOVE_LANGUAGE_LABEL 9086
#define IDS_SETTINGS_CAPTIONS_MAKE_DEFAULT_LANGUAGE_LABEL 9087
#define IDS_SETTINGS_CAPTIONS_DEFAULT_LANGUAGE_LABEL 9088
#define IDS_SETTINGS_NEARBY_SHARE_TITLE 9089
#define IDS_SETTINGS_NEARBY_SHARE_TITLE_PH 9090
#define IDS_SETTINGS_NEARBY_SHARE_SET_UP_BUTTON_TITLE 9091
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ROW_TITLE 9092
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_DIALOG_TITLE 9093
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_FIELD_LABEL 9094
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DEVICE_NAME 9095
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_TITLE 9096
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_DESCRIPTION 9097
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_ARIA_LABEL 9098
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ARIA_DESCRIPTION 9099
#define IDS_SETTINGS_NEARBY_SHARE_CONFIRM_DEVICE_NAME 9100
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_LABEL 9101
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_ROW_TITLE 9102
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DATA_USAGE 9103
#define IDS_SETTINGS_NEARBY_SHARE_UPDATE_DATA_USAGE 9104
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_DIALOG_TITLE 9105
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_LABEL 9106
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_DESCRIPTION 9107
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_LABEL 9108
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_DESCRIPTION 9109
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_TOOLTIP 9110
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_LABEL 9111
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_DESCRIPTION 9112
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_DATA_DESCRIPTION 9113
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_WIFI_ONLY_DESCRIPTION 9114
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_OFFLINE_DESCRIPTION 9115
#define IDS_SETTINGS_NEARBY_SHARE_CONTACT_VISIBILITY_ROW_TITLE 9116
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_VISIBILITY 9117
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_TITLE 9118
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_SAVE 9119
#define IDS_SETTINGS_NEARBY_SHARE_DESCRIPTION 9120
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_TITLE 9121
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_ON 9122
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_OFF 9123
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION 9124
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION_DESC 9125
#define IDS_SETTINGS_SPELLING_PREF 9126
#define IDS_SETTINGS_ENABLE_LOGGING_PREF 9127
#define IDS_SETTINGS_ENABLE_LOGGING_PREF_DESC 9128
#define IDS_SETTINGS_SUGGEST_PREF 9129
#define IDS_SETTINGS_PEOPLE_SIGNED_IN_TO_ACCOUNT 9130
#define IDS_SETTINGS_PEOPLE_SYNCING_TO_ACCOUNT 9131
#define IDS_SETTINGS_PEOPLE_SYNC_PAUSED 9132
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT 9133
#define IDS_SETTINGS_PEOPLE_SYNC_TURN_OFF 9134
#define IDS_SETTINGS_SETTINGS_CHECKBOX_LABEL 9135
#define IDS_SETTINGS_PEOPLE_SYNC_NOT_WORKING 9136
#define IDS_SETTINGS_PEOPLE_SYNC_PASSWORDS_NOT_WORKING 9137
#define IDS_SETTINGS_SYNC_ADVANCED_PAGE_TITLE 9138
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_PAGE_TITLE 9139
#define IDS_SETTINGS_PEOPLE_SYNC_ANOTHER_ACCOUNT 9140
#define IDS_SETTINGS_TURN_ON_SYNC_BUTTON_UPDATE_SETTINGS_UI_ENABLED 9141
#define IDS_SETTINGS_ACCOUNT_AWARE_SIGNIN_BUTTON_LABEL 9142
#define IDS_SETTINGS_ERROR_PASSWORDS_USER_ERROR_DESCRIPTION 9143
#define IDS_SETTINGS_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_ERROR_DESCRIPTION 9144
#define IDS_SETTINGS_PEOPLE_ACCOUNT_AWARE_SIGNIN_ACCOUNT_ROW_SUBTITLE_WITH_EMAIL 9145
#define IDS_SETTINGS_PEOPLE_ACCOUNT_AWARE_SIGNIN_ACCOUNT_ROW_SUBTITLE_WITH_EMAIL_WITH_BOOKMARKS 9146
#define IDS_SETTINGS_PEOPLE_ACCOUNT_AWARE_SIGNIN_ACCOUNT_ROW_SUBTITLE_WITH_EMAIL_SIMPLE 9147
#define IDS_SETTINGS_CHANGE_ACCOUNT 9148
#define IDS_SETTINGS_SYNC_DISCONNECT_CONFIRM 9149
#define IDS_SETTINGS_PEOPLE_SIGN_OUT 9150
#define IDS_SETTINGS_AUTOFILL_CHECKBOX_LABEL 9151
#define IDS_SETTINGS_HISTORY_CHECKBOX_LABEL 9152
#define IDS_SETTINGS_EXTENSIONS_CHECKBOX_LABEL 9153
#define IDS_SETTINGS_OPEN_TABS_CHECKBOX_LABEL 9154
#define IDS_SETTINGS_SAVED_TAB_GROUPS_CHECKBOX_LABEL 9155
#define IDS_SETTINGS_PRODUCT_COMPARISONS_CHECKBOX_LABEL 9156
#define IDS_SETTINGS_WIFI_CONFIGURATIONS_CHECKBOX_LABEL 9157
#define IDS_SETTINGS_SYNC_EVERYTHING_CHECKBOX_LABEL 9158
#define IDS_SETTINGS_APPS_CHECKBOX_LABEL 9159
#define IDS_SETTINGS_APPS_CHECKBOX_SUBLABEL 9160
#define IDS_SETTINGS_NON_PERSONALIZED_SERVICES_SECTION_LABEL 9161
#define IDS_SETTINGS_CUSTOMIZE_SYNC 9162
#define IDS_SETTINGS_SYNC_DATA 9163
#define IDS_SETTINGS_PASSWORDS_AND_PASSKEYS_CHECKBOX_LABEL 9164
#define IDS_SETTINGS_PASSPHRASE_PLACEHOLDER 9165
#define IDS_SETTINGS_EXISTING_PASSPHRASE_TITLE 9166
#define IDS_SETTINGS_SUBMIT_PASSPHRASE 9167
#define IDS_SETTINGS_ENCRYPT_WITH_GOOGLE_CREDENTIALS_LABEL 9168
#define IDS_SETTINGS_ENCRYPT_ACCOUNT_DATA_WITH_GOOGLE_CREDENTIALS_LABEL 9169
#define IDS_SETTINGS_BOOKMARKS_CHECKBOX_LABEL 9170
#define IDS_SETTINGS_READING_LIST_CHECKBOX_LABEL 9171
#define IDS_SETTINGS_ENCRYPTION_OPTIONS 9172
#define IDS_SETTINGS_MISMATCHED_PASSPHRASE_ERROR 9173
#define IDS_SETTINGS_EMPTY_PASSPHRASE_ERROR 9174
#define IDS_SETTINGS_INCORRECT_PASSPHRASE_ERROR 9175
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_TITLE_UNIFIED_CONSENT 9176
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_BROWSER_PAGE_TITLE 9177
#define IDS_SETTINGS_SYNC_SYNC_AND_NON_PERSONALIZED_SERVICES 9178
#define IDS_SETTINGS_PASSPHRASE_CONFIRMATION_PLACEHOLDER 9179
#define IDS_SETTINGS_SYNC_LOADING 9180
#define IDS_SETTINGS_SYNC_TIMEOUT 9181
#define IDS_SETTINGS_SYNC 9182
#define IDS_SETTINGS_SYNC_SETTINGS_CANCEL_SYNC 9183
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_TITLE 9184
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_BODY 9185
#define IDS_SYNC_UNAVAILABLE_FOR_NON_GOOGLE_ACCOUNT 9186
#define IDS_SETTINGS_ABOUT_UPGRADE_CHECK_STARTED 9189
#define IDS_SETTINGS_UPDATE_TO_ROLLBACK_VERSION_DISALLOWED 9190
#define IDS_SETTINGS_THEME_CHECKBOX_LABEL 9192
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_TITLE 9196
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES 9197
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_LOCAL_CERTIFICATES 9198
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_CERTIFICATES 9199
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_HASH_COPIED_TOAST 9200
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM 9201
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_TITLE 9202
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_MANAGE_LINK 9203
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_VIEW_LINK 9204
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_MANAGE_LINK_ARIA_DESCRIPTION 9205
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_ADMIN_CERTS_TITLE 9206
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_USER_CERTS_TITLE 9207
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_TRUSTED_CERTS_LIST 9208
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_INTERMEDIATE_CERTS_LIST 9209
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DISTRUSTED_CERTS_LIST 9210
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_NO_CERTIFICATES_ROW 9211
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_EXPORT_BUTTON_LABEL 9212
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_EXPORT_BUTTON_ARIA_LABEL 9213
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_BUTTON_LABEL 9214
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_BUTTON_ARIA_LABEL 9215
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_AND_BIND_BUTTON_LABEL 9216
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_AND_BIND_BUTTON_ARIA_LABEL 9217
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_NUM_CERTS 9218
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_DESCRIPTION 9219
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_LOCAL_CERTIFICATES_DESCRIPTION 9220
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_CERTIFICATES_DESCRIPTION 9221
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_LEARN_MORE_LINK 9222
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_LEARN_MORE_LINK_ARIA_LABEL 9223
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_TOGGLE_LABEL 9224
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CUSTOM_CERTS_TITLE 9225
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_FROM_PLATFORM 9226
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_FROM_ADMIN 9227
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_FROM_EXTENSION 9228
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_CERT_TITLE 9229
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_SERVER_CERT_DESCRIPTION 9231
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_READ_FILE_ERROR 9232
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_MULTIPLE_CERT_ERROR 9233
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_ERROR_TITLE 9234
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_ERROR 9235
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_ENTER_PASSWORD_TITLE 9236
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_ERROR_TITLE 9237
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_INVALID_FILE 9238
#define IDS_CERTIFICATE_MANAGER_V2_SUBPAGE_BACK_BUTTON_ARIA_LABEL 9243
#define IDS_CERTIFICATE_MANAGER_V2_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 9244
#define IDS_CERTIFICATE_MANAGER_V2_LIST_EXPAND_ARIA_LABEL 9245
#define IDS_CERTIFICATE_MANAGER_V2_CERT_ENTRY_VIEW_ARIA_LABEL 9246
#define IDS_CERTIFICATE_MANAGER_V2_CERT_ENTRY_DELETE_ARIA_LABEL 9247
#define IDS_CERTIFICATE_MANAGER_V2_CERT_HASH_COPY_ARIA_LABEL 9248
#define IDS_SUPPORT_TOOL_ISSUE_DETAILS_PAGE_TITLE 9272
#define IDS_SUPPORT_TOOL_DATA_SELECTION_PAGE_TITLE 9273
#define IDS_SUPPORT_TOOL_REVIEW_PII_PAGE_TITLE 9274
#define IDS_SUPPORT_TOOL_DATA_EXPORT_DONE_PAGE_TITLE 9275
#define IDS_SUPPORT_TOOL_DATA_EXPORTED_TEXT 9276
#define IDS_SUPPORT_TOOL_SUPPORT_CASE_ID 9277
#define IDS_SUPPORT_TOOL_EMAIL 9278
#define IDS_SUPPORT_TOOL_DESCRIBE_ISSUE_TEXT 9279
#define IDS_SUPPORT_TOOL_ISSUE_DESCRIPTION_PLACEHOLDER 9280
#define IDS_SUPPORT_TOOL_PII_WARNING_TEXT 9281
#define IDS_SUPPORT_TOOL_INCLUDE_ALL_PII_RADIO_BUTTON 9282
#define IDS_SUPPORT_TOOL_REMOVE_PII_RADIO_BUTTON 9283
#define IDS_SUPPORT_TOOL_PII_REMOVAL_DISCLAIMER 9284
#define IDS_SUPPORT_TOOL_MANUALLY_SELECT_PII_RADIO_BUTTON 9285
#define IDS_SUPPORT_TOOL_CANCEL_BUTTON_TEXT 9286
#define IDS_SUPPORT_TOOL_EXPORT_BUTTON_TEXT 9287
#define IDS_SUPPORT_TOOL_BACK_BUTTON_TEXT 9288
#define IDS_SUPPORT_TOOL_DISMISS_BUTTON_TEXT 9289
#define IDS_SUPPORT_TOOL_CONTINUE_BUTTON_TEXT 9290
#define IDS_SUPPORT_TOOL_DATA_COLLECTION_SPINNER 9291
#define IDS_SUPPORT_TOOL_DATA_EXPORT_SPINNER 9292
#define IDS_SUPPORT_TOOL_TAB_TITLE 9293
#define IDS_SUPPORT_TOOL_URL_GENERATOR_PAGE_TITLE 9294
#define IDS_SUPPORT_TOOL_DATA_COLLECTOR_LIST_TITLE 9295
#define IDS_SUPPORT_TOOL_GET_LINK_TEXT 9296
#define IDS_SUPPORT_TOOL_COPY_LINK_DESCRIPTION 9297
#define IDS_SUPPORT_TOOL_COPY_LINK_BUTTON_TEXT 9298
#define IDS_SUPPORT_TOOL_COPY_TOKEN_BUTTON_TEXT 9299
#define IDS_SUPPORT_TOOL_DONT_INCLUDE_EMAIL 9300
#define IDS_SUPPORT_TOOL_LINK_COPIED_TEXT 9301
#define IDS_SUPPORT_TOOL_TOKEN_COPIED_TEXT 9302
#define IDS_SUPPORT_TOOL_SELECT_DATA_COLLECTOR_ERROR 9303
#define IDS_SUPPORT_TOOL_SELECT_ALL 9304
#define IDS_SUPPORT_TOOL_CHROME_SYSTEM_INFO 9305
#define IDS_SUPPORT_TOOL_CRASH_IDS 9306
#define IDS_SUPPORT_TOOL_MEMORY_DETAILS 9307
#define IDS_SUPPORT_TOOL_UI_HIEARCHY 9308
#define IDS_SUPPORT_TOOL_ADDITIONAL_CROS_PLATFROM_LOGS 9309
#define IDS_SUPPORT_TOOL_DEVICE_EVENT 9310
#define IDS_SUPPORT_TOOL_INTEL_WIFI_DEBUG_DUMP 9311
#define IDS_SUPPORT_TOOL_TOUCH_EVENTS 9312
#define IDS_SUPPORT_TOOL_CHROMEOS_FLEX_LOGS 9313
#define IDS_SUPPORT_TOOL_DBUS_DETAILS 9314
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_ROUTES 9315
#define IDS_SUPPORT_TOOL_CHROMEOS_SHILL_LOGS 9316
#define IDS_SUPPORT_TOOL_POLICIES 9317
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_STATE 9318
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_LOGS 9319
#define IDS_SUPPORT_TOOL_CHROMEOS_CHROME_USER_LOGS 9320
#define IDS_SUPPORT_TOOL_CHROMEOS_BLUETOOTH_FLOSS 9321
#define IDS_SUPPORT_TOOL_CHROMEOS_CONNECTED_INPUT_DEVICES 9322
#define IDS_SUPPORT_TOOL_CHROMEOS_TRAFFIC_COUNTERS 9323
#define IDS_SUPPORT_TOOL_CHROMEOS_VIRTUAL_KEYBOARD 9324
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_HEALTH 9325
#define IDS_SUPPORT_TOOL_PERFORMANCE 9326
#define IDS_SUPPORT_TOOL_SIGN_IN 9327
#define IDS_SUPPORT_TOOL_CHROMEOS_APP_SERVICE 9328
#define IDS_SUPPORT_TOOL_CHROMEOS_KIOSK_APP_LEVEL_LOGS 9329
#define IDS_SUPPORT_TOOL_ANDROID_APP_INFO 9330
#define IDS_SUPPORT_TOOL_WIFI_SSID 9331
#define IDS_SUPPORT_TOOL_CELLULAR_LOCATION_INFO 9332
#define IDS_SUPPORT_TOOL_EMAIL_ADDRESS 9333
#define IDS_SUPPORT_TOOL_GAIA_ID 9334
#define IDS_SUPPORT_TOOL_STABLE_IDENTIDIERS 9335
#define IDS_SUPPORT_TOOL_PRINTING_IPP_ADDRESS 9336
#define IDS_SUPPORT_TOOL_IP_ADDRESS 9337
#define IDS_SUPPORT_TOOL_MAC_ADDRESS 9338
#define IDS_SUPPORT_TOOL_WINDOW_TITLES 9339
#define IDS_SUPPORT_TOOL_URLS 9340
#define IDS_SUPPORT_TOOL_SERIAL_NUMBERS 9341
#define IDS_SUPPORT_TOOL_REMOVABLE_STORAGE_NAMES 9342
#define IDS_SUPPORT_TOOL_EAP 9343
#define IDS_EXTENSIONS_ALLOW_FILE_ACCESS 9344
#define IDS_EXTENSIONS_ALLOW_ON_ALL_URLS 9345
#define IDS_EXTENSIONS_ALLOW_ON_FOLLOWING_SITES 9346
#define IDS_EXTENSIONS_VIEW_ACTIVITY_LOG 9347
#define IDS_EXTENSIONS_BACKGROUND_PAGE 9348
#define IDS_EXTENSIONS_SERVICE_WORKER_BACKGROUND 9349
#define IDS_EXTENSIONS_CORRUPTED_EXTENSION 9350
#define IDS_EXTENSIONS_ENABLE_ERROR_COLLECTION 9351
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_DISABLED 9352
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_ENABLED 9353
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_ENABLED_WITH_SITE_ACCESS 9354
#define IDS_EXTENSIONS_ERROR_NO_ERRORS_CODE_MESSAGE 9355
#define IDS_EXTENSIONS_INSTALL_DROP_TARGET 9356
#define IDS_EXTENSIONS_INSTALL_WARNINGS 9357
#define IDS_EXTENSIONS_LOG_LEVEL_ERROR 9358
#define IDS_EXTENSIONS_LOG_LEVEL_INFO 9359
#define IDS_EXTENSIONS_LOG_LEVEL_WARN 9360
#define IDS_EXTENSIONS_PATH 9361
#define IDS_EXTENSIONS_PERMISSIONS_OFF 9362
#define IDS_EXTENSIONS_RELOAD_TERMINATED 9363
#define IDS_EXTENSIONS_REPAIR_CORRUPTED 9364
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_ICON_TOOLTIP 9365
#define IDS_EXTENSIONS_VIEW_IFRAME 9366
#define IDS_EXTENSIONS_VIEW_INACTIVE 9367
#define IDS_EXTENSIONS_VIEW_INCOGNITO 9368
#define IDS_EXTENSIONS_DEVELOPER_MODE 9369
#define IDS_EXTENSIONS_DISABLED_UNSUPPORTED_DEVELOPER_MODE 9370
#define IDS_EXTENSIONS_DISABLED_UNSUPPORTED_DEVELOPER_MODE_DETAILS 9371
#define IDS_EXTENSIONS_DISABLED_UNSUPPORTED_DEVELOPER_MODE_TOAST 9372
#define IDS_EXTENSIONS_DISABLED_UPDATE_REQUIRED_BY_POLICY 9373
#define IDS_EXTENSIONS_DISABLED_PUBLISHED_IN_STORE_REQUIRED_BY_POLICY 9374
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_ALLOW 9375
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_TITLE 9376
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_WARNING 9377
#define IDS_EXTENSIONS_MENU_BUTTON_LABEL 9378
#define IDS_EXTENSIONS_ERROR_PAGE_HEADING 9379
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_ALLOW_ALL_EXTENSIONS 9380
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_CUSTOMIZE_PER_EXTENSION 9381
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_RESTRICT_EXTENSIONS 9382
#define IDS_EXTENSIONS_ERROR_ANONYMOUS_FUNCTION 9383
#define IDS_EXTENSIONS_ERROR_CONTEXT 9384
#define IDS_EXTENSIONS_ERROR_CONTEXT_UNKNOWN 9385
#define IDS_EXTENSIONS_CLEAR_ACTIVITIES 9386
#define IDS_EXTENSIONS_ERROR_CLEAR_ALL 9387
#define IDS_EXTENSIONS_A11Y_CLEAR_ENTRY 9388
#define IDS_EXTENSIONS_ERROR_STACK_TRACE 9389
#define IDS_EXTENSIONS_ERROR_LINES_NOT_SHOWN 9390
#define IDS_EXTENSIONS_HOST_PERMISSIONS_DESCRIPTION 9391
#define IDS_EXTENSIONS_PERMISSIONS_LEARN_MORE_A11Y_LABEL 9392
#define IDS_EXTENSIONS_HOST_PERMISSIONS_EDIT 9393
#define IDS_EXTENSIONS_ITEM_ERRORS 9394
#define IDS_EXTENSIONS_ITEM_WARNINGS 9395
#define IDS_EXTENSIONS_ITEM_HOST_PERMISSIONS_HEADING 9396
#define IDS_EXTENSIONS_NEW_HOST_PERMISSIONS_HEADING 9397
#define IDS_EXTENSIONS_HOST_PERMISSIONS_SUB_HEADING 9398
#define IDS_EXTENSIONS_HOST_ACCESS_ON_CLICK 9399
#define IDS_EXTENSIONS_HOST_ACCESS_ASK_ON_EVERY_VISIT 9400
#define IDS_EXTENSIONS_HOST_ACCESS_ON_SPECIFIC_SITES 9401
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_SPECIFIC_SITES 9402
#define IDS_EXTENSIONS_HOST_ACCESS_ON_ALL_SITES 9403
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_ALL_SITES 9404
#define IDS_EXTENSIONS_ITEM_ALLOWED_HOSTS 9405
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_LINE 9406
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_MULTI_LINE 9407
#define IDS_EXTENSIONS_ACTIVITY_LOG_PAGE_HEADING 9408
#define IDS_EXTENSIONS_ACTIVITY_LOG_SEARCH_LABEL 9409
#define IDS_EXTENSIONS_ACTIVITY_LOG_TYPE_COLUMN 9410
#define IDS_EXTENSIONS_ACTIVITY_LOG_NAME_COLUMN 9411
#define IDS_EXTENSIONS_ACTIVITY_LOG_COUNT_COLUMN 9412
#define IDS_EXTENSIONS_ACTIVITY_LOG_TIME_COLUMN 9413
#define IDS_EXTENSIONS_ACTIVITY_LOG_HISTORY_TAB_HEADING 9414
#define IDS_EXTENSIONS_ACTIVITY_LOG_STREAM_TAB_HEADING 9415
#define IDS_EXTENSIONS_START_ACTIVITY_STREAM 9416
#define IDS_EXTENSIONS_STOP_ACTIVITY_STREAM 9417
#define IDS_EXTENSIONS_EMPTY_STREAM_STARTED 9418
#define IDS_EXTENSIONS_EMPTY_STREAM_STOPPED 9419
#define IDS_EXTENSIONS_ACTIVITY_ARGUMENTS_HEADING 9420
#define IDS_EXTENSIONS_WEB_REQUEST_INFO_HEADING 9421
#define IDS_EXTENSIONS_ACTIVITY_LOG_MORE_ACTIONS_LABEL 9422
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPAND_ALL 9423
#define IDS_EXTENSIONS_ACTIVITY_LOG_COLLAPSE_ALL 9424
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPORT_HISTORY 9425
#define IDS_EXTENSIONS_ITEM_ID 9426
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS 9427
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS_EXTRA 9428
#define IDS_EXTENSIONS_ITEM_NO_ACTIVE_VIEWS 9429
#define IDS_EXTENSIONS_ITEM_ALLOW_INCOGNITO 9430
#define IDS_EXTENSIONS_ITEM_ALLOW_USER_SCRIPTS 9431
#define IDS_EXTENSIONS_ALLOW_USER_SCRIPTS_WARNING 9432
#define IDS_EXTENSIONS_ITEM_DEPENDENCIES 9433
#define IDS_EXTENSIONS_DEPENDENT_ENTRY 9434
#define IDS_EXTENSIONS_ITEM_DESCRIPTION 9435
#define IDS_EXTENSIONS_ITEM_DETAILS 9436
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_LABEL 9437
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 9438
#define IDS_EXTENSIONS_EXTENSION_A11Y_ASSOCIATION 9439
#define IDS_EXTENSIONS_APP_ICON 9440
#define IDS_EXTENSIONS_EXTENSION_ICON 9441
#define IDS_EXTENSIONS_ITEM_ID_HEADING 9442
#define IDS_EXTENSIONS_EXTENSION_ENABLED 9443
#define IDS_EXTENSIONS_APP_ENABLED 9444
#define IDS_EXTENSIONS_ITEM_OFF 9445
#define IDS_EXTENSIONS_ITEM_ON 9446
#define IDS_EXTENSIONS_ITEM_EXTENSION_WEBSITE 9447
#define IDS_EXTENSIONS_ITEM_CHROME_WEB_STORE 9448
#define IDS_EXTENSIONS_VIEW_IN_DEVTOOLS 9449
#define IDS_EXTENSIONS_ITEM_OPTIONS 9450
#define IDS_EXTENSIONS_ITEM_PERMISSIONS 9451
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_EMPTY 9452
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_AND_SITE_ACCESS_EMPTY 9453
#define IDS_EXTENSIONS_ITEM_PIN_TO_TOOLBAR 9454
#define IDS_EXTENSIONS_ITEM_REMOVE_EXTENSION 9455
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS 9456
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_ADD_HOST 9457
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_EMPTY 9458
#define IDS_EXTENSIONS_REMOVE_SITES_DIALOG_TITLE 9459
#define IDS_EXTENSIONS_ITEM_SOURCE 9460
#define IDS_EXTENSIONS_ITEM_SOURCE_INSTALLED_BY_DEFAULT 9461
#define IDS_EXTENSIONS_ITEM_SOURCE_POLICY 9462
#define IDS_EXTENSIONS_ITEM_SOURCE_SIDELOADED 9463
#define IDS_EXTENSIONS_ITEM_SOURCE_UNPACKED 9464
#define IDS_EXTENSIONS_ITEM_SOURCE_WEBSTORE 9465
#define IDS_EXTENSIONS_ITEM_VERSION 9466
#define IDS_EXTENSIONS_ITEM_RELOADED 9467
#define IDS_EXTENSIONS_ITEM_RELOADING 9468
#define IDS_EXTENSIONS_LOAD_ERROR_HEADING 9469
#define IDS_EXTENSIONS_LOAD_ERROR_ERROR_LABEL 9470
#define IDS_EXTENSIONS_LOAD_ERROR_FILE_LABEL 9471
#define IDS_EXTENSIONS_LOAD_ERROR_COULD_NOT_LOAD_MANIFEST 9472
#define IDS_EXTENSIONS_LOAD_ERROR_RETRY 9473
#define IDS_EXTENSIONS_LOADING_ACTIVITIES 9474
#define IDS_MISSING_OR_UNINSTALLED_EXTENSION 9475
#define IDS_EXTENSIONS_NO_ACTIVITIES 9476
#define IDS_EXTENSIONS_NO_INSTALLED_ITEMS 9477
#define IDS_EXTENSIONS_NO_DESCRIPTION 9478
#define IDS_EXTENSIONS_OPENS_IN_NEW_TAB 9479
#define IDS_EXTENSIONS_PACK_DIALOG_TITLE 9480
#define IDS_EXTENSIONS_PACK_DIALOG_WARNING_TITLE 9481
#define IDS_EXTENSIONS_PACK_DIALOG_ERROR_TITLE 9482
#define IDS_EXTENSIONS_PACK_DIALOG_PROCEED_ANYWAY 9483
#define IDS_EXTENSIONS_PACK_DIALOG_BROWSE_BUTTON 9484
#define IDS_EXTENSIONS_PACK_DIALOG_EXTENSION_ROOT_LABEL 9485
#define IDS_EXTENSIONS_PACK_DIALOG_KEY_FILE_LABEL 9486
#define IDS_EXTENSIONS_PACK_DIALOG_CONFIRM_BUTTON 9487
#define IDS_EXTENSIONS_TOOLBAR_TITLE 9488
#define IDS_EXTENSIONS_SEARCH 9489
#define IDS_EXTENSIONS_SITE_PERMISSIONS 9490
#define IDS_EXTENSIONS_SITE_PERMISSIONS_PAGE_TITLE 9491
#define IDS_EXTENSIONS_SITE_PERMISSIONS_VIEW_ALL_SITES 9492
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_PAGE_TITLE 9493
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_ONE_EXTENSION 9494
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_EXTENSION_COUNT 9495
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_ALL_SITES 9496
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_THIS_SITE 9497
#define IDS_EXTENSIONS_SITE_SETTINGS 9498
#define IDS_EXTENSIONS_PERMITTED_SITES 9499
#define IDS_EXTENSIONS_RESTRICTED_SITES 9500
#define IDS_EXTENSIONS_NO_SITES_ADDED 9501
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ADD_SITE_DIALOG_TITLE 9502
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_SITE_DIALOG_TITLE 9503
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_URL 9504
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS_DIALOG_TITLE 9505
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS 9506
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ASK_ON_EVERY_VISIT 9507
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_ERROR 9508
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_LABEL 9509
#define IDS_EXTENSIONS_SITE_PERMISSIONS_INCLUDES_SUBDOMAINS 9510
#define IDS_EXTENSIONS_EDIT_SHORTCUT_INPUT_LABEL 9511
#define IDS_EXTENSIONS_EDIT_SHORTCUT_BUTTON_LABEL 9512
#define IDS_EXTENSIONS_SET_SHORTCUT_IN_SYSTEM_SETTINGS 9513
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_LABEL 9514
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_GLOBAL 9515
#define IDS_EXTENSIONS_APPS_TITLE 9516
#define IDS_EXTENSIONS_REMOVE 9517
#define IDS_EXTENSIONS_MORE_OPTIONS 9518
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_TITLE 9519
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_ERROR 9520
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_LABEL 9521
#define IDS_EXTENSIONS_SIDEBAR_EXTENSIONS 9522
#define IDS_EXTENSIONS_SIDEBAR_DISCOVER_MORE 9523
#define IDS_EXTENSIONS_WHATS_NEW_SIDEBAR_PROMO 9524
#define IDS_EXTENSIONS_SIDEBAR_KEYBOARD_SHORTCUTS 9525
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED 9526
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED_DONE 9527
#define IDS_EXTENSIONS_TOOLBAR_PACK 9528
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW 9529
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW_TOOLTIP 9530
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_DONE 9531
#define IDS_EXTENSIONS_TOOLBAR_UPDATING_TOAST 9532
#define IDS_EXTENSIONS_SUBPAGE_BUTTON 9533
#define IDS_EXTENSIONS_SECTION_HEADER 9534
#define IDS_EXTENSIONS_SAFETY_HUB_HEADER 9535
#define IDS_EXTENSIONS_SC_MALWARE 9536
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_OFF 9537
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_ON 9538
#define IDS_EXTENSIONS_SC_UNPUBLISHED_OFF 9539
#define IDS_EXTENSIONS_SC_UNPUBLISHED_ON 9540
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES_ON 9541
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES_OFF 9542
#define IDS_EXTENSIONS_SC_TITLE 9543
#define IDS_EXTENSIONS_SC_KEEP_EXT 9544
#define IDS_EXTENSIONS_SC_THREEDOT_DETAILS 9545
#define IDS_EXTENSIONS_SC_REMOVE_ALL 9546
#define IDS_EXTENSIONS_SC_ALL_DONE_FOR_NOW 9547
#define IDS_EXTENSIONS_SC_REMOVE_BUTTON_A11Y_LABEL 9548
#define IDS_EXTENSIONS_SC_OPTION_MENU_A11Y_LABEL 9549
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_TITLE 9550
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_WARNING_HEADER 9551
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_WARNING_SUBTITLE 9552
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISABLED_HEADER 9553
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_WARNING_HEADER 9554
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_WARNING_SUBTITLE 9555
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_DISABLED_HEADER 9556
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_REMOVE_BUTTON 9557
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISMISS_BUTTON 9558
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_FIND_ALTERNATIVE_BUTTON 9559
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_KEEP_FOR_NOW_BUTTON 9560
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_ACTION_MENU_BUTTON_LABEL 9561
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_FIND_ALTERNATIVE_BUTTON_ACC_LABEL 9562
#define IDS_EXTENSIONS_MV2_DEPRECATION_UNSUPPORTED_EXTENSION_OFF_TEXT 9563
#define IDS_EXTENSIONS_CANT_INSTALL_MV2_EXTENSION 9564
#define IDS_EXTENSIONS_ZERO_STATE_IPH_HEADER 9576
#define IDS_EXTENSIONS_ZERO_STATE_IPH_HEADER_V2 9577
#define IDS_EXTENSIONS_ZERO_STATE_CHIPS_IPH_DESCRIPTION 9578
#define IDS_EXTENSIONS_ZERO_STATE_CHIPS_WITH_LINK_IPH_LINK_LABEL 9579
#define IDS_EXTENSIONS_ZERO_STATE_CHIPS_WITH_LINK_IPH_DESCRIPTION 9580
#define IDS_EXTENSIONS_ZERO_STATE_PLAIN_LINK_IPH_DESCRIPTION 9581
#define IDS_EXTENSIONS_ZERO_STATE_IPH_SHOPPING_CATEGORY_LABEL 9582
#define IDS_EXTENSIONS_ZERO_STATE_IPH_WRITING_HELP_COLLECTION_LABEL 9583
#define IDS_EXTENSIONS_ZERO_STATE_IPH_PRODUCTIVITY_CATEGORY_LABEL 9584
#define IDS_EXTENSIONS_ZERO_STATE_IPH_AI_PRODUCTIVITY_COLLECTION_LABEL 9585
#define IDS_EXTENSIONS_ZERO_STATE_IPH_DISMISS_BUTTON_TITLE 9586
#define IDS_EXTENSIONS_ZERO_STATE_IPH_SHOPPING_CATEGORY_LINK 9587
#define IDS_EXTENSIONS_ZERO_STATE_IPH_WRITING_HELP_COLLECTION_LINK 9588
#define IDS_EXTENSIONS_ZERO_STATE_IPH_PRODUCTIVITY_CATEGORY_LINK 9589
#define IDS_EXTENSIONS_ZERO_STATE_IPH_AI_PRODUCTIVITY_COLLECTION_LINK 9590
#define IDS_EXTENSIONS_ZERO_STATE_IPH_WEB_STORE_LINK 9591
#define IDS_EXTENSIONS_ZERO_STATE_IPH_DISMISS_BUTTON_TEXT 9592
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_SUBTITLE 9593
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_TITLE 9594
#define IDS_NEARBY_CONFIRMATION_PAGE_TITLE 9595
#define IDS_QUICK_SHARE_V2_VISIBILITY_SECTION_TITLE 9596
#define IDS_QUICK_SHARE_V2_VISIBILITY_SECTION_SUBTITLE_ON_DISABLED 9597
#define IDS_QUICK_SHARE_V2_VISIBILITY_YOUR_DEVICES_SUBLABEL 9598
#define IDS_QUICK_SHARE_V2_VISIBILITY_CONTACTS_SUBLABEL 9599
#define IDS_QUICK_SHARE_V2_VISIBILITY_EVERYONE_LABEL 9600
#define IDS_QUICK_SHARE_V2_VISIBILITY_EVERYONE_SUBLABEL 9601
#define IDS_QUICK_SHARE_V2_VISIBILITY_ONLY_FOR_TEN_MINUTES_LABEL 9602
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOAD_FAILED 9603
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOADING 9604
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE 9605
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE_PH 9606
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_TITLE 9607
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE 9608
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE_PH 9609
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL 9610
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL_SELF_SHARE 9611
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_NONE 9612
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME 9613
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME_SELF_SHARE 9614
#define IDS_NEARBY_CONTACT_VISIBILITY_ZERO_STATE_TEXT 9615
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_YOUR_DEVICES 9616
#define IDS_NEARBY_DEVICE_NAME_EMPTY_ERROR 9617
#define IDS_NEARBY_DEVICE_NAME_TOO_LONG_ERROR 9618
#define IDS_NEARBY_DEVICE_NAME_INVALID_CHARACTERS_ERROR 9619
#define IDS_NEARBY_DISCOVERY_PAGE_INFO 9620
#define IDS_NEARBY_DISCOVERY_PAGE_SUBTITLE 9621
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE 9622
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE_PH 9623
#define IDS_NEARBY_DISCOVERY_PAGE_PLACEHOLDER 9624
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME 9625
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME_HELP 9626
#define IDS_NEARBY_ONBOARDING_PAGE_SUBTITLE 9627
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE 9628
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE_PH 9629
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY 9630
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY_HELP_ALL_CONTACTS 9631
#define IDS_NEARBY_VISIBILITY_PAGE_MANAGE_CONTACTS 9632
#define IDS_NEARBY_VISIBILITY_PAGE_SUBTITLE 9633
#define IDS_NEARBY_VISIBILITY_PAGE_TITLE 9634
#define IDS_NEARBY_SHARE_FEATURE_NAME 9635
#define IDS_NEARBY_SHARE_FEATURE_NAME_PH 9636
#define IDS_NEARBY_ACTIONS_ACCEPT 9637
#define IDS_NEARBY_ACTIONS_CANCEL 9638
#define IDS_NEARBY_ACTIONS_CLOSE 9639
#define IDS_NEARBY_ACTIONS_CONFIRM 9640
#define IDS_NEARBY_ACTIONS_DECLINE 9641
#define IDS_NEARBY_ACTIONS_NEXT 9642
#define IDS_NEARBY_ACTIONS_REJECT 9643
#define IDS_NEARBY_DEFAULT_DEVICE_NAME 9644
#define IDS_NEARBY_ERROR_CANCELLED 9645
#define IDS_NEARBY_ERROR_CANT_RECEIVE 9646
#define IDS_NEARBY_ERROR_CANT_SHARE 9647
#define IDS_NEARBY_ERROR_NO_RESPONSE 9648
#define IDS_NEARBY_ERROR_TRANSFER_IN_PROGRESS 9649
#define IDS_NEARBY_ERROR_NOT_ENOUGH_SPACE 9650
#define IDS_NEARBY_ERROR_REJECTED 9651
#define IDS_NEARBY_ERROR_SOMETHING_WRONG 9652
#define IDS_NEARBY_ERROR_TIME_OUT 9653
#define IDS_NEARBY_ERROR_TRY_AGAIN 9654
#define IDS_NEARBY_ERROR_UNSUPPORTED_FILE_TYPE 9655
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_APPS 9656
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_APPS 9657
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_IMAGES 9658
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_IMAGES 9659
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_UNKNOWN 9660
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 9661
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_VIDEOS 9662
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_VIDEOS 9663
#define IDS_NEARBY_SECURE_CONNECTION_ID 9664
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_ADDRESSES 9665
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_ADDRESSES 9666
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_LINKS 9667
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_LINKS 9668
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_PHONE_NUMBERS 9669
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_PHONE_NUMBERS 9670
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_UNKNOWN 9671
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 9672
#define IDS_NEARBY_CAPITALIZED_UNKNOWN_ATTACHMENTS 9673
#define IDS_NEARBY_NOT_CAPITALIZED_UNKNOWN_ATTACHMENTS 9674
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE 9675
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_MINUTES 9676
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_SECONDS 9677
#define IDS_NEARBY_HIGH_VISIBILITY_HELP_TEXT 9678
#define IDS_NEARBY_HIGH_VISIBILITY_TIMEOUT_TEXT 9679
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_ERROR 9680
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_DESCRIPTION 9681
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_ERROR 9682
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION 9683
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION_PH 9684
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_TITLE 9685
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_CONNECTION_ID 9686
#define IDS_NEARBY_PREVIEW_TITLE_MULTIPLE_FILE 9687
#define IDS_NEARBY_ACCOUNT_ROW_LABEL 9688
#define IDS_NEARBY_ACCOUNT_ROW_LABEL_PH 9689
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP 9690
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP_PH 9691
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_BOTTOM 9692
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS 9693
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS_DESCRIPTION 9694
#define IDS_NEARBY_VISIBILITY_CONTACTS_BUTTON 9695
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS 9696
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS_DESCRIPTION 9697
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES 9698
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES_DESCRIPTION 9699
#define IDS_NEARBY_VISIBILITY_ALL_CONTACTS_TOGGLE 9700
#define IDS_NEARBY_VISIBLITY_HIDDEN 9701
#define IDS_NEARBY_VISIBLITY_HIDDEN_DESCRIPTION 9702
#define IDS_NEARBY_VISIBLITY_UNKNOWN 9703
#define IDS_NEARBY_VISIBLITY_UNKNOWN_DESCRIPTION 9704
#define IDS_NEARBY_NOTIFICATION_ACTION_COPY_TO_CLIPBOARD 9705
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_FOLDER 9706
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_NETWORK_LIST 9707
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_URL 9708
#define IDS_NEARBY_NOTIFICATION_ACCEPT_ACTION 9709
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE 9710
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE_WIFI_CREDENTIALS 9711
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE 9712
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE_PH 9713
#define IDS_NEARBY_NOTIFICATION_DECLINE_ACTION 9714
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE 9715
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE_PH 9716
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_MESSAGE 9717
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_TITLE 9718
#define IDS_NEARBY_NOTIFICATION_SET_UP_ACTION 9719
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_ACTION 9720
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_TITLE 9721
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_MESSAGE 9722
#define IDS_NEARBY_NOTIFICATION_GO_TO_SETTINGS_ACTION 9723
#define IDS_NEARBY_NOTIFICATION_DISMISS_ACTION 9724
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE 9725
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE_WIFI_CREDENTIALS 9726
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE 9727
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE_WIFI_CREDENTIALS 9728
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE 9729
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE_WIFI_CREDENTIALS 9730
#define IDS_NEARBY_NOTIFICATION_SEND_FAILURE_TITLE 9731
#define IDS_NEARBY_NOTIFICATION_SEND_PROGRESS_TITLE 9732
#define IDS_NEARBY_NOTIFICATION_SEND_SUCCESS_TITLE 9733
#define IDS_NEARBY_NOTIFICATION_SOURCE 9734
#define IDS_NEARBY_NOTIFICATION_SOURCE_PH 9735
#define IDS_NEARBY_NOTIFICATION_SENDER_CANCELLED 9736
#define IDS_WHATS_NEW_TITLE 9737
#define IDS_PASSWORD_MANAGER_UI_TITLE 9738
#define IDS_PASSWORD_MANAGER_UI_DESCRIPTION 9739
#define IDS_PASSWORD_MANAGER_UI_SEARCH_PROMPT 9740
#define IDS_PASSWORD_MANAGER_UI_CHECKUP 9741
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS 9742
#define IDS_PASSWORD_MANAGER_UI_SETTINGS 9743
#define IDS_PASSWORD_MANAGER_UI_SAVE_PASSWORDS_TOGGLE_LABEL 9744
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_LABEL 9745
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_DESC 9746
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS_DESCRIPTION 9747
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_BUTTON 9748
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_TITLE 9749
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_DESCRIPTION 9750
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_TITLE 9751
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_DESCRIPTION 9752
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_TITLE 9753
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_DESCRIPTION 9754
#define IDS_PASSWORD_MANAGER_UI_SHARE 9755
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_DESCRIPTION 9756
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_TITLE 9757
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_LOADING_TITLE 9758
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_SUCCESS_TITLE 9759
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CANCELED_TITLE 9760
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_FAMILY_MEMBER 9761
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NO_OTHER_FAMILY_MEMBERS 9762
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_FAMILY_PICKER_DESCRIPTION 9763
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_DESCRIPTION_SINGLE 9764
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_DESCRIPTION_MULTIPLE 9765
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_FOOTER_WEBSITE 9766
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_FOOTER_ANDROID_APP 9767
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_VIEW_FAMILY 9768
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_MEMBER_UNAVAILABLE 9769
#define IDS_PASSWORD_MANAGER_UI_SHARING_IS_MANAGED_BY_ADMIN 9770
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_AVAILABLE 9771
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_TRY_AGAIN 9772
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_GOT_IT 9773
#define IDS_PASSWORD_MANAGER_UI_SHARE_DIALOG_TITLE 9774
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BANNER_TITLE 9775
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_ACCOUNT_STORE_USERS 9776
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SYNCING_USERS 9777
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SIGNEDOUT_USERS 9778
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_DEVICE 9779
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_ACCOUNT 9780
#define IDS_PASSWORD_MANAGER_UI_IMPORT_STORE_PICKER_ACCESSIBLE_NAME 9781
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SELECT_FILE_DESCRIPTION 9782
#define IDS_PASSWORD_MANAGER_UI_SELECT_FILE 9783
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_PASSWORD 9784
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_URL 9785
#define IDS_PASSWORD_MANAGER_UI_IMPORT_INVALID_URL 9786
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_URL 9787
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_USERNAME 9788
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_PASSWORD 9789
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_NOTE 9790
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_ACCOUNT 9791
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_DEVICE 9792
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_UNKNOWN 9793
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_BAD_FORMAT 9794
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FILE_SIZE_EXCEEDED 9795
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_LIMIT_EXCEEDED 9796
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_TITLE 9797
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TITLE 9798
#define IDS_PASSWORD_MANAGER_UI_IMPORT_COMPLETE_TITLE 9799
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DELETE_FILE_OPTION 9800
#define IDS_PASSWORD_MANAGER_UI_IMPORT_VIEW_PASSWORDS 9801
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ALREADY_ACTIVE 9802
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TIP 9803
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FAILURES_SUMMARY 9804
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BAD_ROWS_FORMAT 9805
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_ACCOUNT 9806
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_DEVICE 9807
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_TITLE 9808
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_DESCRIPTION 9809
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CANCEL 9810
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SKIP 9811
#define IDS_PASSWORD_MANAGER_UI_IMPORT_REPLACE 9812
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TITLE 9813
#define IDS_PASSWORD_MANAGER_UI_DOWNLOAD_FILE 9814
#define IDS_PASSWORD_MANAGER_UI_EXPORT_BANNER_DESCRIPTION 9815
#define IDS_PASSWORD_MANAGER_UI_EXPORT_SUCCESSFUL 9816
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TRY_AGAIN 9817
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TITLE 9818
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIPS 9819
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ENOUGH_SPACE 9820
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ANOTHER_FOLDER 9821
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_TITLE 9822
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RESULT 9823
#define IDS_PASSWORD_MANAGER_UI_JUST_NOW 9824
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_COUNT 9825
#define IDS_PASSWORD_MANAGER_UI_NO_COMPROMISED_PASSWORDS 9826
#define IDS_PASSWORD_MANAGER_UI_HAS_COMPROMISED_PASSWORDS 9827
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_COUNT 9828
#define IDS_PASSWORD_MANAGER_UI_NO_REUSED_PASSWORDS 9829
#define IDS_PASSWORD_MANAGER_UI_HAS_REUSED_PASSWORDS 9830
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_COUNT 9831
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_GREEN_STATE_A11Y 9832
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_YELLOW_STATE_A11Y 9833
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RED_STATE_A11Y 9834
#define IDS_PASSWORD_MANAGER_UI_NO_WEAK_PASSWORDS 9835
#define IDS_PASSWORD_MANAGER_UI_HAS_WEAK_PASSWORDS 9836
#define IDS_PASSWORD_MANAGER_UI_CHECK_PASSWORDS_AFTER_ERROR 9837
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_TITLE 9838
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_DESCRIPTION 9839
#define IDS_PASSWORD_MANAGER_UI_ALLOWED_ACTOR_LOGIN_SITES_TITLE 9840
#define IDS_PASSWORD_MANAGER_UI_ALLOWED_ACTOR_LOGIN_SITES_DESCRIPTION 9841
#define IDS_PASSWORD_MANAGER_UI_REMOVE_ACTOR_LOGIN_PERMISSION_DIALOG_TITLE 9842
#define IDS_PASSWORD_MANAGER_UI_REMOVE_ACTOR_LOGIN_PERMISSION_DIALOG_DESCRIPTION 9843
#define IDS_PASSWORD_MANAGER_UI_REMOVE_ACTOR_LOGIN_PERMISSION_DIALOG_CONFIRMATION 9844
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_ACCOUNTS 9845
#define IDS_PASSWORD_MANAGER_UI_USERNAME_LABEL 9846
#define IDS_PASSWORD_MANAGER_UI_SITES_LABEL 9847
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LABEL 9848
#define IDS_PASSWORD_MANAGER_UI_NOTE_LABEL 9849
#define IDS_PASSWORD_MANAGER_UI_NO_NOTE_ADDED 9850
#define IDS_PASSWORD_MANAGER_UI_COPY_PASSWORD 9851
#define IDS_PASSWORD_MANAGER_UI_COPY_USERNAME 9852
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD 9853
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD 9854
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD_A11Y 9855
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD_A11Y 9856
#define IDS_PASSWORD_MANAGER_UI_FEDERATION_LABEL 9857
#define IDS_PASSWORD_MANAGER_UI_USERNAME_COPIED_TO_CLIPBOARD 9858
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_COPIED_TO_CLIPBOARD 9859
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD 9860
#define IDS_PASSWORD_MANAGER_UI_WEBSITE_LABEL 9861
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_FOOTNOTE 9862
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LEAKED 9863
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED 9864
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED_AND_LEAKED 9865
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON 9866
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON_ARIA_DESCRIPTION 9867
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS 9868
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS_ARIA_DESCRIPTION 9869
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_DESCRIPTION 9870
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_DESCRIPTION 9871
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_DESCRIPTION 9872
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_SIGNED_OUT 9873
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OFFLINE 9874
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_COMPROMISED_SECTION 9875
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_NO_PASSWORDS 9876
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_QUOTA_LIMIT 9877
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OTHER_ERROR 9878
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RUNNING_LABEL 9879
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROGRESS 9880
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_CANCELED 9881
#define IDS_PASSWORD_MANAGER_UI_MUTED_COMPROMISED_PASSWORDS 9882
#define IDS_PASSWORD_MANAGER_UI_MUTE_ISSUE 9883
#define IDS_PASSWORD_MANAGER_UI_UNMUTE_ISSUE 9884
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_CREDENTIALS_WITH_REUSED_PASSWORD 9885
#define IDS_PASSWORD_MANAGER_UI_HELP 9886
#define IDS_PASSWORD_MANAGER_UI_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_LABEL_WIN 9889
#define IDS_PASSWORD_MANAGER_UI_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_SUBLABEL_WIN 9890
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSWORD 9893
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_EDIT_FOOTNOTE 9894
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DELETED 9895
#define IDS_PASSWORD_MANAGER_UI_UNDO 9896
#define IDS_PASSWORD_MANAGER_UI_SEARCH_RESULT 9897
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_IN_APP 9898
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_MANAGER_PIN 9899
#define IDS_PASSWORD_MANAGER_UI_ALREADY_CHANGED_PASSWORD 9900
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_DESCRIPTION 9901
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_TITLE 9902
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_TITLE 9903
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_DESCRIPTION 9904
#define IDS_PASSWORD_MANAGER_UI_SHOW_MORE 9905
#define IDS_PASSWORD_MANAGER_UI_NOT_VALID_WEB_ADDRESS 9906
#define IDS_PASSWORD_MANAGER_UI_MISSING_TLD 9907
#define IDS_PASSWORD_MANAGER_UI_USERNAME_ALREADY_USED 9908
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT 9909
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT_WARNING 9910
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT 9911
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT_DESCRIPTION 9912
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD 9913
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD_ARIA_DESCRIPTION 9914
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TO_ACCOUNT 9915
#define IDS_PASSWORD_MANAGER_UI_OPENS_IN_NEW_TAB 9916
#define IDS_PASSWORD_MANAGER_UI_VIEW_PASSWORD_ARIA_DESCRIPTION 9917
#define IDS_PASSWORD_MANAGER_UI_RUN_CHECKUP_ARIA_DESCRIPTION 9918
#define IDS_PASSWORD_MANAGER_UI_REMOVE_BLOCKED_SITE_ARIA_DESCRIPTION 9919
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_ACCOUNT_STORE_USERS 9920
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SYNCING_USERS 9921
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SIGNEDOUT_USERS 9922
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_TITLE 9923
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_DESCRIPTION 9924
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_ACTION 9925
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_TITLE 9926
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_DESCRIPTION 9927
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_TITLE 9928
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_DESCRIPTION 9929
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_TITLE 9930
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_DESCRIPTION 9931
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_TOGGLE_SUB_LABEL 9932
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_WITH_PASSKEYS_TOGGLE_LABEL 9933
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_TITLE 9934
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_BODY 9935
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_ACCOUNT_CHECKBOX_LABEL 9936
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_DEVICE_CHECKBOX_LABEL 9937
#define IDS_PASSWORD_MANAGER_UI_APPS_LABEL 9938
#define IDS_PASSWORD_MANAGER_UI_SITES_AND_APPS_LABEL 9939
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_CHECKUP_ARIA_DESCRIPTION 9940
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_PASSWORDS_ARIA_DESCRIPTION 9941
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_PASSWORD_SETTINGS_ARIA_DESCRIPTION 9942
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TITLE 9943
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_DESCRIPTION 9944
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_BUTTON 9945
#define IDS_PASSWORD_MANAGER_UI_MANAGE_PASSKEYS_LABEL 9947
#define IDS_PASSWORD_MANAGER_UI_NO_PASSWORDS_FOUND 9948
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSKEY 9949
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_LABEL 9950
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_PLACEHOLDER 9951
#define IDS_PASSWORD_MANAGER_UI_USERNAME_PLACEHOLDER 9952
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_TITLE 9953
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_DESCRIPTION 9954
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_HIDDEN_INFO_LABEL 9955
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_MANAGEMENT_INFO_LABEL 9956
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_UPGRADE_TOGGLE_LABEL 9957
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_UPGRADE_TOGGLE_SUBLABEL 9958
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_TITLE 9959
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_DESCRIPTION 9960
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_BUTTON 9961
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_TOAST_MESSAGE 9962
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_TITLE 9963
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DESCRIPTION 9964
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DELETE_ALL 9965
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRM 9966
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_SUCCESS_TOAST 9967
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRMATION_TITLE 9968
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRMATION_TITLE_LOCAL 9969
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRMATION_DESCIPTION 9970
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DOMAINS_DISPLAY_ONE 9971
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DOMAINS_DISPLAY_TWO 9972
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DOMAINS_DISPLAY_TWO_AND_X_MORE 9973
#define IDS_PASSWORD_MANAGER_PASSWORDS_COUNTER 9974
#define IDS_PASSWORD_MANAGER_PASSKEYS_COUNTER 9975
#define IDS_PASSWORD_MANAGER_UI_COPY_DISPLAY_NAME_LABEL 9976
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_COPIED_TO_CLIPBOARD 9977
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DELETED 9978
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LIST_ARIA_LABEL 9979
#define IDS_PASSWORD_MANAGER_UI_DEVICE_ONLY_PASSWORDS_ICON_TOOLTIP 9980
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_ARIA_LABEL 9981
#define IDS_PASSWORD_MANAGER_UI_BACKUP_PASSWORD_DETAILS_CARD_ARIA_LABEL 9982
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_EDIT_BUTTON_ARIA_LABEL 9983
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_EDIT_BUTTON_NO_USERNAME_ARIA_LABEL 9984
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_DELETE_BUTTON_ARIA_LABEL 9985
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_DELETE_BUTTON_NO_USERNAME_ARIA_LABEL 9986
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_NO_USERNAME_ARIA_LABEL 9987
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_ARIA_LABEL 9988
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_EDIT_BUTTON_ARIA_LABEL 9989
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_EDIT_BUTTON_NO_USERNAME_ARIA_LABEL 9990
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_DELETE_BUTTON_ARIA_LABEL 9991
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_DELETE_BUTTON_NO_USERNAME_ARIA_LABEL 9992
#define IDS_PASSWORD_MANAGER_UI_FEDERATED_CREDENTIAL_ARIA_LABEL 9993
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_TO_ACCOUNT 9994
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_TITLE 9995
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_DESCRIPTION 9996
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_ACTION_BUTTON 9997
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_IN_SETTINGS_SUB_LABEL 9998
#define IDS_PASSWORD_MANAGER_UI_NO_USERNAME 10004
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_MOVED_TOAST_MESSAGE 10005
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_TITLE 10006
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_DESCRIPTION 10007
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_ACTION_BUTTON 10008
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_DESCRIPTION 10009
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_TITLE 10010
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_SAVE_BUTTON 10011
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LIST_ITEM_DEVICE_ONLY_ACCESSIBLE_TEXT 10012
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LIST_ITEM_ARIA_LABEL 10013
#define IDS_PASSWORD_MANAGER_UI_PROMO_CARD_ARIA_LABEL 10014
#define IDS_PASSWORD_MANAGER_UI_CLOSE_PROMO_CARD_BUTTON_ARIA_LABEL 10015
#define IDS_PASSWORD_MANAGER_PIN_CHANGED 10016
#define IDS_PASSWORD_MANAGER_UI_CONFIRM 10017
#define IDS_PASSWORD_MANAGER_UI_DISCONNECT_CLOUD_AUTHENTICATOR_DIALOG_TITLE 10018
#define IDS_PASSWORD_MANAGER_UI_DISCONNECT_CLOUD_AUTHENTICATOR_DIALOG_DESCRIPTION 10019
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_CANCEL 10020
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_CONTINUE 10021
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGED_TITLE 10022
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FAILED_TITLE 10023
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FAILED_BODY 10024
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FAILED_ACCEPT_BUTTON 10025
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_OMNIBOX_SIGN_IN_CHECK 10026
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_OMNIBOX_CHANGING_PASSWORD 10027
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_TOAST_SIGN_IN_TO_CONTINUE 10028
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_CHANGE_PASSWORD 10029
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_DIALOG_TITLE 10030
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_DIALOG_DETAILS_WITHOUT_PRIVACY_NOTICE 10031
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_DIALOG_DETAILS_WITH_PRIVACY_NOTICE 10032
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_DIALOG_LINK_WITHOUT_PRIVACY_NOTICE 10033
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_DIALOG_LINK_WITH_PRIVACY_NOTICE 10034
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_PRIVACY_NOTICE 10035
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_SETTINGS_DESCRIPTION 10036
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_SETTINGS_TITLE 10037
#define IDS_SETTINGS_PASSWORD_CHANGE_SUBLABEL_WITH_LEARN_MORE 10038
#define IDS_PASSWORD_MANAGER_UI_OTP_DURING_PASSWORD_CHANGE_TITLE 10039
#define IDS_PASSWORD_MANAGER_UI_OTP_DURING_PASSWORD_CHANGE_BODY 10040
#define IDS_PASSWORD_MANAGER_UI_OTP_DURING_PASSWORD_CHANGE_ACTION 10041
#define IDS_PASSWORD_MANAGER_UI_BACKUP_PASSWORD_SETTINGS_DESCRIPTION 10042
#define IDS_PASSWORD_MANAGER_UI_BACKUP_PASSWORD_SETTINGS_DESCRIPTION_DETAILS 10043
#define IDS_PASSWORD_MANAGER_UI_OTP_DIALOG_TITLE 10044
#define IDS_PASSWORD_MANAGER_UI_OTP_DIALOG_DETAILS 10045
#define IDS_PASSWORD_MANAGER_UI_VIEW_DETAILS_BUTTON 10046
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_UNCHANGED 10047
#define IDS_UTILITY_PROCESS_PRINTING_SERVICE_NAME 10048
#define IDS_UTILITY_PROCESS_PRINT_BACKEND_SERVICE_NAME 10049
#define IDS_PRINT_INVALID_PRINTER_SETTINGS 10050
#define IDS_PRINT_PREVIEW_TITLE 10051
#define IDS_PRINT_PREVIEW_DESCRIPTION 10052
#define IDS_PRINT_PREVIEW_LOADING 10053
#define IDS_PRINT_PREVIEW_FAILED 10054
#define IDS_PRINT_PREVIEW_INVALID_PRINTER_SETTINGS 10055
#define IDS_PRINT_PREVIEW_PRINT_BUTTON 10056
#define IDS_PRINT_PREVIEW_SAVE_BUTTON 10057
#define IDS_PRINT_PREVIEW_PRINTING 10058
#define IDS_PRINT_PREVIEW_SAVING 10059
#define IDS_PRINT_PREVIEW_OPTION_ALL_PAGES 10060
#define IDS_PRINT_PREVIEW_OPTION_ODD_PAGES 10061
#define IDS_PRINT_PREVIEW_OPTION_EVEN_PAGES 10062
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_PAGES 10063
#define IDS_PRINT_PREVIEW_DESTINATION_LABEL 10064
#define IDS_PRINT_PREVIEW_OPTION_BW 10065
#define IDS_PRINT_PREVIEW_OPTION_COLLATE 10066
#define IDS_PRINT_PREVIEW_OPTION_COLOR 10067
#define IDS_PRINT_PREVIEW_OPTION_LANDSCAPE 10068
#define IDS_PRINT_PREVIEW_OPTION_PORTRAIT 10069
#define IDS_PRINT_PREVIEW_OPTION_TWO_SIDED 10070
#define IDS_PRINT_PREVIEW_PRINT_ON_BOTH_SIDES_LABEL 10071
#define IDS_PRINT_PREVIEW_OPTION_LONG_EDGE 10072
#define IDS_PRINT_PREVIEW_OPTION_SHORT_EDGE 10073
#define IDS_PRINT_PREVIEW_PAGES_LABEL 10074
#define IDS_PRINT_PREVIEW_LAYOUT_LABEL 10075
#define IDS_PRINT_PREVIEW_COPIES_LABEL 10076
#define IDS_PRINT_PREVIEW_SCALING_LABEL 10077
#define IDS_PRINT_PREVIEW_OPTION_DEFAULT_SCALING 10078
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_SCALING 10079
#define IDS_PRINT_PREVIEW_PAGES_PER_SHEET_LABEL 10080
#define IDS_PRINT_PREVIEW_EXAMPLE_PAGE_RANGE_TEXT 10081
#define IDS_PRINT_PREVIEW_PRINT_TO_PDF 10082
#define IDS_PRINT_PREVIEW_SHEET_SUMMARY_LABEL 10083
#define IDS_PRINT_PREVIEW_PAGE_SUMMARY_LABEL 10084
#define IDS_PRINT_PREVIEW_PAGE_RANGE_SYNTAX_INSTRUCTION 10085
#define IDS_PRINT_PREVIEW_PAGE_RANGE_LIMIT_INSTRUCTION_WITH_VALUE 10086
#define IDS_PRINT_PREVIEW_COPIES_INSTRUCTION 10087
#define IDS_PRINT_PREVIEW_SCALING_INSTRUCTION 10088
#define IDS_PRINT_PREVIEW_PRINT_PAGES_LABEL 10089
#define IDS_PRINT_PREVIEW_OPTIONS_LABEL 10090
#define IDS_PRINT_PREVIEW_OPTION_HEADER_FOOTER 10091
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAGE 10092
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAPER 10093
#define IDS_PRINT_PREVIEW_OPTION_BACKGROUND_COLORS_AND_IMAGES 10094
#define IDS_PRINT_PREVIEW_OPTION_SELECTION_ONLY 10095
#define IDS_PRINT_PREVIEW_OPTION_RASTERIZE 10096
#define IDS_PRINT_PREVIEW_MARGINS_LABEL 10097
#define IDS_PRINT_PREVIEW_DEFAULT_MARGINS 10098
#define IDS_PRINT_PREVIEW_NO_MARGINS 10099
#define IDS_PRINT_PREVIEW_CUSTOM_MARGINS 10100
#define IDS_PRINT_PREVIEW_MINIMUM_MARGINS 10101
#define IDS_PRINT_PREVIEW_TOP_MARGIN_LABEL 10102
#define IDS_PRINT_PREVIEW_BOTTOM_MARGIN_LABEL 10103
#define IDS_PRINT_PREVIEW_LEFT_MARGIN_LABEL 10104
#define IDS_PRINT_PREVIEW_RIGHT_MARGIN_LABEL 10105
#define IDS_PRINT_PREVIEW_MEDIA_SIZE_LABEL 10106
#define IDS_PRINT_PREVIEW_DPI_LABEL 10107
#define IDS_PRINT_PREVIEW_NON_ISOTROPIC_DPI_ITEM_LABEL 10108
#define IDS_PRINT_PREVIEW_DPI_ITEM_LABEL 10109
#define IDS_PRINT_PREVIEW_DESTINATION_SEARCH_TITLE 10110
#define IDS_PRINT_PREVIEW_SEARCH_BOX_PLACEHOLDER 10111
#define IDS_PRINT_PREVIEW_NO_DESTINATIONS_MESSAGE 10112
#define IDS_PRINT_PREVIEW_PRINT_DESTINATIONS_TITLE 10113
#define IDS_PRINT_PREVIEW_MANAGE 10114
#define IDS_PRINT_PREVIEW_SEE_MORE 10115
#define IDS_PRINT_PREVIEW_SEE_MORE_DESTINATIONS_LABEL 10116
#define IDS_PRINT_PREVIEW_EXTENSION_DESTINATION_ICON_TOOLTIP 10117
#define IDS_MORE_OPTIONS_LABEL 10118
#define IDS_PRINT_PREVIEW_COULD_NOT_PRINT 10119
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_SEARCH_BOX_PLACEHOLDER 10120
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_TITLE 10121
#define IDS_PRINT_PREVIEW_NO_ADVANCED_SETTINGS_MATCH_SEARCH_HINT 10122
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_CONFIRM 10123
#define IDS_PRINT_PREVIEW_NEW_SHOW_ADVANCED_OPTIONS 10124
#define IDS_PRINT_PREVIEW_BUTTON_SELECT 10125
#define IDS_PRINT_PREVIEW_BUTTON_GO_BACK 10126
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_DIALOG_TITLE 10127
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_PERMISSION_MESSAGE 10128
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_ERROR_MESSAGE 10129
#define IDS_PRINT_PREVIEW_MANAGED_SETTINGS_TEXT 10130
#define IDS_PRINT_PREVIEW_SYSTEM_DIALOG_OPTION 10161
#define IDS_DEFAULT_PRINT_DOCUMENT_TITLE 10164
#define IDS_PRINT_SPOOL_FAILED_TITLE_TEXT 10165
#define IDS_PRINT_SPOOL_FAILED_ERROR_TEXT 10166
#define IDS_VR_SHELL_SITE_IS_TRACKING_LOCATION 10167
#define IDS_VR_SHELL_SITE_IS_USING_MICROPHONE 10168
#define IDS_VR_SHELL_SITE_IS_USING_CAMERA 10169
#define IDS_VR_SHELL_SITE_IS_SHARING_SCREEN 10170
#define IDS_VR_SHELL_BG_IS_USING_MICROPHONE 10171
#define IDS_VR_SHELL_BG_IS_USING_CAMERA 10172
#define IDS_VR_SHELL_BG_IS_SHARING_SCREEN 10173
#define IDS_VR_SHELL_SITE_CAN_TRACK_LOCATION 10174
#define IDS_VR_SHELL_SITE_CAN_USE_MICROPHONE 10175
#define IDS_VR_SHELL_SITE_CAN_USE_CAMERA 10176
#define IDS_VR_SHELL_SITE_CAN_SHARE_SCREEN 10177
#define IDS_VR_SHELL_SITE_IS_USING_BLUETOOTH 10178
#define IDS_VR_SHELL_SITE_CAN_USE_BLUETOOTH 10180
#define IDS_DESKTOP_PROMPT_DOFF_HEADSET 10181
#define IDS_VR_DESKTOP_GENERIC_PERMISSION_PROMPT 10182
#define IDS_VR_SHELL_SITE_IS_USING_USB 10183
#define IDS_VR_SHELL_SITE_IS_USING_MIDI 10184
#define IDS_VR_SHELL_SITE_CAN_USE_MIDI 10185
#define IDS_VR_WEB_VR_TIMEOUT_MESSAGE 10186
#define IDS_WILDCARD 10187
#define IDS_BACKGROUND_APP_INSTALLED_BALLOON_TITLE 10188
#define IDS_BACKGROUND_APP_INSTALLED_BALLOON_BODY 10189
#define IDS_BACKGROUND_CRASHED_APP_BALLOON_MESSAGE 10190
#define IDS_BACKGROUND_CRASHED_EXTENSION_BALLOON_MESSAGE 10191
#define IDS_BACKGROUND_APP_NOT_INSTALLED 10192
#define IDS_PERMISSIONS_REQUESTED_SCREENREADER_ANNOUNCEMENT 10193
#define IDS_PERMISSIONS_EXPIRED_SCREENREADER_ANNOUNCEMENT 10194
#define IDS_PERMISSIONS_BUBBLE_PROMPT 10195
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_ONE_PERM 10196
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS 10197
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS_MORE 10198
#define IDS_PERMISSIONS_BUBBLE_PROMPT_THIS_FILE 10199
#define IDS_PERMISSION_CUSTOMIZE 10200
#define IDS_ALTERNATE_NAV_URL_VIEW_LABEL 10201
#define IDS_DOWNLOAD_HISTORY_TITLE 10202
#define IDS_TAB_LOADING_TITLE 696
#define IDS_HOVER_CARD_FILE_URL_SOURCE 10203
#define IDS_HOVER_CARD_BLOB_URL_SOURCE 10204
#define IDS_HOVER_CARD_CRASHED_TITLE 10205
#define IDS_HISTORY_SEARCH_PROMPT 10206
#define IDS_HISTORY_DELETE 10207
#define IDS_HISTORY_OPEN 10208
#define IDS_HISTORY_ITEMS_SELECTED 10209
#define IDS_HISTORY_ITEMS_UNSELECTED 10210
#define IDS_HISTORY_HISTORY_MENU_DESCRIPTION 10211
#define IDS_HISTORY_NO_SYNCED_RESULTS 10212
#define IDS_HISTORY_OPEN_TABS_MENU_ITEM 10213
#define IDS_HISTORY_TURN_ON_SYNC_BUTTON 10214
#define IDS_HISTORY_TURN_ON_SYNC_PROMO 10215
#define IDS_HISTORY_TURN_ON_SYNC_PROMO_DESC 10216
#define IDS_HISTORY_SYNC_HISTORY_PROMO 10217
#define IDS_RECENT_TABS_SYNC_HISTORY_PROMO_BODY_SIGNED_OUT 10218
#define IDS_RECENT_TABS_SYNC_HISTORY_PROMO_BODY_PENDING_SIGN_IN 10219
#define IDS_RECENT_TABS_SYNC_HISTORY_PROMO_BODY_PENDING_SIGN_IN_SYNC_HISTORY_ON 10220
#define IDS_RECENT_TABS_SYNC_HISTORY_PROMO_BODY_SIGNED_IN_SYNC_OFF 10221
#define IDS_HISTORY_SYNC_HISTORY_BUTTON 10222
#define IDS_EDIT 10223
#define IDS_CLEAR_SEARCH 10224
#define IDS_CONFIRM 10225
#define IDS_DISABLE 10226
#define IDS_SEARCH_CLEARED 10227
#define IDS_SEARCH_RESULTS 10228
#define IDS_SEARCH_RESULTS_SINGULAR 10229
#define IDS_SEARCH_RESULTS_PLURAL 10230
#define IDS_SEARCH_RESULT_BUBBLE_TEXT 10231
#define IDS_SEARCH_RESULTS_BUBBLE_TEXT 10232
#define IDS_SEARCH_NO_RESULTS 10233
#define IDS_SHOW_BUBBLE_INACTIVE_DESCRIPTION 10234
#define IDS_FOCUS_HELP_BUBBLE_DESCRIPTION 10235
#define IDS_FOCUS_HELP_BUBBLE_TOGGLE_DESCRIPTION 10236
#define IDS_FOCUS_HELP_BUBBLE_TUTORIAL_DESCRIPTION 10237
#define IDS_CONTENT_CONTEXT_INSPECTELEMENT 10238
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_DIALOG_TITLE 10239
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_ENABLE 10240
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_DISABLE 10241
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_ENABLE 10242
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_DISABLE 10243
#define IDS_CONTENT_CONTEXT_BACK 10244
#define IDS_CONTENT_CONTEXT_FORWARD 10245
#define IDS_CONTENT_CONTEXT_SAVEPAGEAS 10246
#define IDS_CONTENT_CONTEXT_PRINT 10247
#define IDS_CONTENT_CONTEXT_VIEWPAGESOURCE 10248
#define IDS_CONTENT_CONTEXT_OPENLINKWITH 10249
#define IDS_CONTENT_CONTEXT_OPENLINKWITH_CONFIGURE 10250
#define IDS_CONTENT_CONTEXT_INSPECTBACKGROUNDPAGE 10251
#define IDS_CONTENT_CONTEXT_READING_MODE 10252
#define IDS_CONTENT_CONTEXT_CLOSE_GLIC 10253
#define IDS_CONTENT_CONTEXT_RELOAD 10254
#define IDS_CONTENT_CONTEXT_RESTART_APP 10255
#define IDS_CONTENT_CONTEXT_RELOAD_PACKAGED_APP 10256
#define IDS_CONTENT_CONTEXT_TRANSLATE 10257
#define IDS_CONTENT_CONTEXT_EXIT_FULLSCREEN 10258
#define IDS_CONTENT_CONTEXT_RELOADFRAME 10259
#define IDS_CONTENT_CONTEXT_VIEWFRAMESOURCE 10260
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB 10261
#define IDS_CONTENT_CONTEXT_OPENLINKNEWWINDOW 10262
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD 10263
#define IDS_CONTENT_CONTEXT_OPENLINKSPLITVIEW 10264
#define IDS_CONTENT_CONTEXT_OPENLINKLEFTVIEW 10265
#define IDS_CONTENT_CONTEXT_OPENLINKRIGHTVIEW 10266
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILES 10267
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILE 10268
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP 10269
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP_SAMEAPP 10270
#define IDS_CONTENT_CONTEXT_OPENLINKWEBAPP_NEWTAB 10271
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW 10272
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_ALTCLICK 10273
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_ALTHOVER 10274
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_LONGPRESS 10275
#define IDS_CONTENT_CONTEXT_SAVELINKAS 10276
#define IDS_CONTENT_CONTEXT_COPYLINKLOCATION 10277
#define IDS_CONTENT_CONTEXT_COPYEMAILADDRESS 10278
#define IDS_CONTENT_CONTEXT_COPYLINKTEXT 10279
#define IDS_CONTENT_CONTEXT_COPYLINKTOTEXT 10280
#define IDS_CONTENT_CONTEXT_ADD_A_NOTE 10281
#define IDS_CONTENT_CONTEXT_REMOVELINKTOTEXT 10282
#define IDS_CONTENT_CONTEXT_RESHARELINKTOTEXT 10283
#define IDS_CONTENT_CONTEXT_SAVEIMAGEAS 10284
#define IDS_CONTENT_CONTEXT_COPYIMAGELOCATION 10285
#define IDS_CONTENT_CONTEXT_COPYIMAGE 10286
#define IDS_CONTENT_CONTEXT_OPENIMAGENEWTAB 10287
#define IDS_CONTENT_CONTEXT_OPEN_ORIGINAL_IMAGE_NEW_TAB 10288
#define IDS_CONTENT_CONTEXT_LOAD_IMAGE 10289
#define IDS_CONTENT_CONTEXT_LOOP 10290
#define IDS_CONTENT_CONTEXT_CONTROLS 10291
#define IDS_CONTENT_CONTEXT_ROTATECW 10292
#define IDS_CONTENT_CONTEXT_ROTATECCW 10293
#define IDS_CONTENT_CONTEXT_SAVEVIDEOFRAMEAS 10294
#define IDS_CONTENT_CONTEXT_SAVEVIDEOAS 10295
#define IDS_CONTENT_CONTEXT_COPYVIDEOLOCATION 10296
#define IDS_CONTENT_CONTEXT_COPYVIDEOFRAME 10297
#define IDS_CONTENT_CONTEXT_SEARCHFORVIDEOFRAME 10298
#define IDS_CONTENT_CONTEXT_OPENVIDEONEWTAB 10299
#define IDS_CONTENT_CONTEXT_SAVEAUDIOAS 10300
#define IDS_CONTENT_CONTEXT_COPYAUDIOLOCATION 10301
#define IDS_CONTENT_CONTEXT_OPENAUDIONEWTAB 10302
#define IDS_CONTENT_CONTEXT_PICTUREINPICTURE 10303
#define IDS_CONTENT_CONTEXT_UNDO 10304
#define IDS_CONTENT_CONTEXT_REDO 10305
#define IDS_CONTENT_CONTEXT_CUT 10306
#define IDS_CONTENT_CONTEXT_COPY 10307
#define IDS_CONTENT_CONTEXT_PASTE 10308
#define IDS_CONTENT_CONTEXT_PASTE_AND_MATCH_STYLE 10309
#define IDS_CONTENT_CONTEXT_ADD_TO_DICTIONARY 10310
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_MENU_OPTION 10311
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND 10312
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND_ONCE 10313
#define IDS_CONTENT_CONTEXT_RUN_LAYOUT_EXTRACTION 10314
#define IDS_CONTENT_CONTEXT_SPELLING_ASK_GOOGLE 10315
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TITLE 10316
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_ENABLE 10317
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_DISABLE 10318
#define IDS_CONTENT_CONTEXT_SPELLING_CHECKING 10319
#define IDS_CONTENT_CONTEXT_SPELLING_NO_SUGGESTIONS_FROM_GOOGLE 10320
#define IDS_CONTENT_CONTEXT_SELECTALL 10321
#define IDS_CONTENT_CONTEXT_PARTIAL_TRANSLATE 10322
#define IDS_CONTENT_CONTEXT_SEARCHWEBFOR 10323
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORNEWTAB 10324
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORIMAGE 10325
#define IDS_CONTENT_CONTEXT_SEARCHLENSFORIMAGE 10326
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT1 10327
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH 10328
#define IDS_CONTENT_CONTEXT_GOTOURL 10329
#define IDS_CONTENT_CONTEXT_GENERATEPASSWORD 10330
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_USE_PASSKEY_FROM_ANOTHER_DEVICE 10331
#define IDS_CONTENT_CONTEXT_MORE_APPS 10332
#define IDS_CONTENT_CONTEXT_OPEN_WITH_APP 10333
#define IDS_CONTENT_CONTEXT_AUTOFILL_FEEDBACK 10334
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_SELECT_PASSWORD 10335
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_IMPORT_PASSWORDS 10336
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_SUGGEST_PASSWORD 10337
#define IDS_SHARE_MENU_TITLE 10340
#define IDS_CONTENT_CONTEXT_PLUGIN_RUN 10341
#define IDS_CONTENT_CONTEXT_PLUGIN_HIDE 10342
#define IDS_CONTENT_CONTEXT_ENABLE_FLASH 10343
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MENU 10345
#define IDS_CONTENT_CONTEXT_LANGUAGE_SETTINGS 10344
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MULTI_LINGUAL 10346
#define IDS_CONTENT_CONTEXT_CHECK_SPELLING_WHILE_TYPING 10347
#define IDS_ADDRESSES_AND_MORE_SUBMENU_OPTION 10348
#define IDS_PASSWORDS_AND_AUTOFILL_MENU 10349
#define IDS_RELAUNCH_TO_UPDATE_ALT 10350
#define IDS_RELAUNCH_TO_UPDATE_ALT_MINOR_TEXT 10351
#define IDS_NEW_TAB 10352
#define IDS_NEW_INCOGNITO_TAB 10353
#define IDS_SHOW_AS_TAB 10354
#define IDS_NEW_WINDOW 10355
#define IDS_NEW_INCOGNITO_WINDOW 10356
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE_WITH_EMAIL 10357
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE 10358
#define IDS_PROFILE_ROW_SYNC_IS_ON 10359
#define IDS_PROFILE_ROW_TURN_ON_SYNC 10360
#define IDS_PROFILE_ROW_SYNC_ERROR_MESSAGE 10361
#define IDS_EDIT2 10362
#define IDS_CUT 10363
#define IDS_COPY 10364
#define IDS_PASTE 10365
#define IDS_DELETE 10366
#define IDS_FIND 10367
#define IDS_FIND_AND_EDIT_MENU 10368
#define IDS_PAYMENT_METHOD_SUBMENU_OPTION 10369
#define IDS_SAVE_AND_SHARE_MENU 10370
#define IDS_CAST_SAVE_AND_SHARE_MENU 10371
#define IDS_SAVE_AND_SHARE_MENU_CAST 10372
#define IDS_SAVE_AND_SHARE_MENU_SAVE 10373
#define IDS_SAVE_AND_SHARE_MENU_SHARE 10374
#define IDS_SAVE_PAGE 10375
#define IDS_MORE_TOOLS_MENU 10376
#define IDS_ZOOM_MENU 10377
#define IDS_ZOOM_MENU2 10378
#define IDS_ZOOM_PLUS 10379
#define IDS_ZOOM_PLUS2 10380
#define IDS_ZOOM_NORMAL 10381
#define IDS_ZOOM_MINUS 10382
#define IDS_ZOOM_MINUS2 10383
#define IDS_COPY_URL 10384
#define IDS_OPEN_IN_APP_WINDOW 10385
#define IDS_MOVE_TAB_TO_NEW_WINDOW 10386
#define IDS_SEARCH_TABS 10387
#define IDS_CLOSE_PROFILE 10388
#define IDS_MANAGE_GOOGLE_ACCOUNT 10389
#define IDS_OPEN_GUEST_PROFILE 10390
#define IDS_ADD_NEW_PROFILE 10391
#define IDS_ACCNAME_ZOOM_PLUS2 10395
#define IDS_ACCNAME_ZOOM_MINUS2 10396
#define IDS_VIEW_SOURCE 10397
#define IDS_FEEDBACK 10398
#define IDS_DEV_TOOLS 10399
#define IDS_DEV_TOOLS_ELEMENTS 10400
#define IDS_DEV_TOOLS_CONSOLE 10401
#define IDS_DEV_TOOLS_DEVICES 10402
#define IDS_TASK_MANAGER 10403
#define IDS_TAKE_SCREENSHOT 10404
#define IDS_RESTORE_ALL_TABS 10405
#define IDS_RESTORE_TAB 10406
#define IDS_REOPEN_WINDOW 10407
#define IDS_REOPEN_GROUP 10408
#define IDS_RESTORE_WINDOW 10409
#define IDS_RESTORE_GROUP 10410
#define IDS_NAME_WINDOW 10411
#define IDS_CHROMELABS 10412
#define IDS_TOS_NOTIFICATION_TITLE 10415
#define IDS_TOS_NOTIFICATION_BODY_TEXT 10416
#define IDS_TOS_NOTIFICATION_ACK_BUTTON_TEXT 10417
#define IDS_TOS_NOTIFICATION_REVIEW_BUTTON_TEXT 10418
#define IDS_TOS_NOTIFICATION_LINK 10419
#define IDS_HELP_MENU 10420
#define IDS_MANAGED 10421
#define IDS_MANAGED_BY 10422
#define IDS_MANAGED_BY_PARENT 10423
#define IDS_PROFILE_MANAGED_BY 10424
#define IDS_BROWSER_PROFILE_MANAGED 10425
#define IDS_CHROME_WHATS_NEW 10426
#define IDS_IMPORT_SETTINGS_MENU_LABEL 10427
#define IDS_PROFILING_ENABLED 10428
#define IDS_FULLSCREEN 10429
#define IDS_CLEAR_BROWSING_DATA 10430
#define IDS_SHOW_DOWNLOADS 10431
#define IDS_FIND_EXTENSIONS 10432
#define IDS_SHOW_EXTENSIONS 10433
#define IDS_EXTENSIONS_SUBMENU 10434
#define IDS_EXTENSIONS_SUBMENU_MANAGE_EXTENSIONS_ITEM 10435
#define IDS_EXTENSIONS_SUBMENU_CHROME_WEBSTORE_ITEM 10436
#define IDS_SHOW_PERFORMANCE 10437
#define IDS_SHOW_SEARCH_COMPANION 10438
#define IDS_SHOW_TRANSLATE 10439
#define IDS_SETTINGS 10440
#define IDS_OPTIONS 10441
#define IDS_HELP_PAGE 10442
#define IDS_BETA_FORUM 10443
#define IDS_GET_HELP 10444
#define IDS_EXIT 10445
#define IDS_AUTOCOMPLETE_MATCH_DESCRIPTION_SEPARATOR 667
#define IDS_MANAGE_SEARCH_ENGINES 10446
#define IDS_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 10447
#define IDS_SEARCH_ENGINES_EDITOR_KEYWORD_COLUMN 10448
#define IDS_SEARCH_ENGINES_EDITOR_DESCRIPTION_COLUMN 10449
#define IDS_SEARCH_ENGINES_EDITOR_DEFAULT_ENGINE 10450
#define IDS_DOWNLOAD_INTERRUPTED_STATUS 10451
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_ACCESS_DENIED 10452
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_ACCESS_DENIED 10453
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_PATH_TOO_LONG 10454
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_PATH_TOO_LONG 10455
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_DISK_FULL 10456
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_DISK_FULL 10457
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_LARGE 10458
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_LARGE 10459
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_TEMPORARY_PROBLEM 10460
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_TEMPORARY_PROBLEM 10461
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_VIRUS 10462
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_VIRUS 10463
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_BLOCKED 10464
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_BLOCKED 10465
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CONTENT_LENGTH_MISMATCH 10466
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CONTENT_LENGTH_MISMATCH 10467
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SECURITY_CHECK_FAILED 10468
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SECURITY_CHECK_FAILED 10469
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_SHORT 10470
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_SHORT 10471
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_SAME_AS_SOURCE 10472
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_SAME_AS_SOURCE 10473
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_TIMEOUT 10474
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_TIMEOUT 10475
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_DISCONNECTED 10476
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_DISCONNECTED 10477
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_DOWN 10478
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_DOWN 10479
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_ERROR 10480
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_ERROR 10481
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NO_FILE 10482
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NO_FILE 10483
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_PROBLEM 10484
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_PROBLEM 10485
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_WEB_DRIVE_ERROR 10486
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SHUTDOWN 10487
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SHUTDOWN 10488
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CRASH 10489
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CRASH 10490
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNAUTHORIZED 10491
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNAUTHORIZED 10492
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_CERT_PROBLEM 10493
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_CERT_PROBLEM 10494
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FORBIDDEN 10495
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FORBIDDEN 10496
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNREACHABLE 10497
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNREACHABLE 10498
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN_WHEN_COMPLETE 10499
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN 10500
#define IDS_DOWNLOAD_STATUS_STARTING 10501
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS 10512
#define IDS_DOWNLOAD_STATUS_SIZES 10513
#define IDS_DOWNLOAD_STATUS_OPEN_IN 10514
#define IDS_DOWNLOAD_STATUS_OPEN_WHEN_COMPLETE 10515
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_SHORT 10516
#define IDS_DOWNLOAD_STATUS_CANCELLED 10517
#define IDS_DOWNLOAD_STATUS_REMOVED 10518
#define IDS_DOWNLOAD_STATUS_UPLOADING 10519
#define IDS_DOWNLOAD_STATUS_UPLOADED 10520
#define IDS_DOWNLOAD_STATUS_UPLOAD_INTERRUPTED 10521
#define IDS_DOWNLOAD_STATUS_INTERRUPTED 10522
#define IDS_DOWNLOAD_UNCONFIRMED_PREFIX 10523
#define IDS_PROMPT_DANGEROUS_DOWNLOAD 10524
#define IDS_PROMPT_DANGEROUS_DOWNLOAD_EXTENSION 10525
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT 10526
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT_IN_ADVANCED_PROTECTION 10527
#define IDS_PROMPT_DEEP_SCANNING_APP_DOWNLOAD 10528
#define IDS_PROMPT_CONFIRM_INSECURE_DOWNLOAD 10529
#define IDS_PROMPT_DOWNLOAD_BLOCKED_TOO_LARGE 10530
#define IDS_PROMPT_DOWNLOAD_BLOCKED_PASSWORD_PROTECTED 10531
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_WARNING 10532
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_BLOCKED 10533
#define IDS_PROMPT_DOWNLOAD_BLOCKED_SCAN_FAILED 10534
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_OPENED_DANGEROUS 10535
#define IDS_PROMPT_DOWNLOAD_INSECURE_WARNING 10536
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED 10537
#define IDS_PROMPT_APP_DEEP_SCANNING 10538
#define IDS_PROMPT_DEEP_SCANNING 10539
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD_IN_ADVANCED_PROTECTION 10540
#define IDS_BLOCK_REASON_DEEP_SCANNING_UPDATED 10541
#define IDS_BLOCK_REASON_DEEP_SCANNING_SECOND_UPDATED 10542
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING_UPDATED 10543
#define IDS_BLOCK_REASON_PROMPT_FOR_LOCAL_PASSWORD_SCANNING 10544
#define IDS_DEEP_SCANNED_OPENED_DANGEROUS_DESCRIPTION 10545
#define IDS_BLOCK_REASON_SENSITIVE_CONTENT_WARNING 10546
#define IDS_SENSITIVE_CONTENT_BLOCKED_DESCRIPTION 10547
#define IDS_BLOCKED_TOO_LARGE_DESCRIPTION 10548
#define IDS_BLOCKED_PASSWORD_PROTECTED_DESCRIPTION 10549
#define IDS_DEEP_SCANNED_FAILED_DESCRIPTION 10550
#define IDS_DOWNLOADS_TOAST_DELETED_FROM_HISTORY_STILL_ON_DEVICE 10551
#define IDS_DOWNLOADS_TOAST_DELETED_FROM_HISTORY 10552
#define IDS_DOWNLOADS_TOAST_COPIED_DOWNLOAD_LINK 10553
#define IDS_DOWNLOADS_TOAST_COPY_DOWNLOAD_LINK_FAILED 10554
#define IDS_EMAIL_VERIFIED 10555
#define IDS_CONFIRM_KEEP_DANGEROUS_DOWNLOAD_TITLE 10559
#define IDS_CONFIRM_DOWNLOAD 10560
#define IDS_CONTINUE_EXTENSION_DOWNLOAD 10561
#define IDS_DISCARD_DOWNLOAD 10562
#define IDS_OPEN_DOWNLOAD_NOW 10563
#define IDS_SCAN_DOWNLOAD 10564
#define IDS_REVIEW_DOWNLOAD 10565
#define IDS_OPEN_DOWNLOAD_ANYWAY 10566
#define IDS_DOWNLOAD_LINK_PAUSE 10567
#define IDS_DOWNLOAD_HISTORY_SEARCH 10568
#define IDS_DOWNLOAD_NO_DOWNLOADS 10569
#define IDS_DOWNLOAD_LINK_RESUME 10570
#define IDS_DOWNLOAD_LINK_CANCEL 10571
#define IDS_DOWNLOAD_LINK_RETRY 10572
#define IDS_DOWNLOAD_LINK_SHOW_IN_WEB_DRIVE 10573
#define IDS_DOWNLOAD_LINK_SHOW 10574
#define IDS_DOWNLOAD_TAB_CANCELLED 10575
#define IDS_DOWNLOAD_FILE_REMOVED 10576
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS_TIME_UNKNOWN 10577
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS 10578
#define IDS_DOWNLOAD_TAB_PROGRESS_SIZE 10579
#define IDS_DOWNLOAD_PROGRESS_PAUSED 10580
#define IDS_DOWNLOAD_LINK_CLEAR_ALL 10581
#define IDS_DOWNLOAD_LINK_OPEN_DOWNLOADS_FOLDER 10582
#define IDS_DOWNLOAD_MORE_ACTIONS 10583
#define IDS_DOWNLOAD_ACTION_MENU_DESCRIPTION 10584
#define IDS_DOWNLOAD_BY_EXTENSION_URL 10585
#define IDS_DOWNLOADS_PAGE_INITIATOR_LINE 10586
#define IDS_DOWNLOAD_IN_INCOGNITO 10587
#define IDS_UNDO_DESCRIPTION 482
#define IDS_DOWNLOAD_UNDO 10588
#define IDS_DOWNLOAD_TOAST_CLEARED_ALL 10589
#define IDS_DOWNLOAD_DEEP_SCAN 10590
#define IDS_DOWNLOAD_DEEP_SCAN_UPDATED 10591
#define IDS_DOWNLOAD_BYPASS_DEEP_SCAN 10592
#define IDS_DOWNLOAD_LOCAL_PASSWORD_SCAN 10593
#define IDS_DOWNLOAD_KEEP_DANGEROUS_FILE 10594
#define IDS_DOWNLOAD_KEEP_SUSPICIOUS_FILE 10595
#define IDS_DOWNLOAD_KEEP_UNVERIFIED_FILE 10596
#define IDS_DOWNLOAD_KEEP_INSECURE_FILE 10597
#define IDS_DOWNLOAD_DELETE_FROM_HISTORY 10598
#define IDS_DOWNLOAD_COPY_DOWNLOAD_LINK 10599
#define IDS_DOWNLOAD_DANGEROUS_ICON_ACCESSIBLE_LABEL 10600
#define IDS_DOWNLOAD_SUSPICIOUS_ICON_ACCESSIBLE_LABEL 10601
#define IDS_DOWNLOAD_INSECURE_ICON_ACCESSIBLE_LABEL 10602
#define IDS_DOWNLOAD_UNVERIFIED_ICON_ACCESSIBLE_LABEL 10603
#define IDS_DOWNLOAD_SCREENREADER_SAVED_DANGEROUS 10604
#define IDS_DOWNLOAD_SCREENREADER_SAVED_SUSPICIOUS 10605
#define IDS_DOWNLOAD_SCREENREADER_SAVED_INSECURE 10606
#define IDS_DOWNLOAD_SCREENREADER_SAVED_UNVERIFIED 10607
#define IDS_DOWNLOAD_SCREENREADER_PAUSED 10608
#define IDS_DOWNLOAD_SCREENREADER_RESUMED 10609
#define IDS_DOWNLOAD_SCREENREADER_CANCELED 10610
#define IDS_DOWNLOAD_WARNING_BYPASS_DIALOG_TITLE 10611
#define IDS_DOWNLOAD_WARNING_BYPASS_PROMPT_DESCRIPTION 10612
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_ACCESSIBLE_ALERT 10613
#define IDS_DOWNLOAD_STATUS_PERCENT_COMPLETE_ACCESSIBLE_ALERT 10614
#define IDS_DOWNLOAD_STATUS_TIME_REMAINING_ACCESSIBLE_ALERT 10615
#define IDS_DOWNLOAD_FAILED_ACCESSIBLE_ALERT 10616
#define IDS_DOWNLOAD_CANCELLED_ACCESSIBLE_ALERT 10617
#define IDS_DOWNLOAD_COMPLETE_ACCESSIBLE_ALERT 10618
#define IDS_DOWNLOAD_PAUSED_ACCESSIBLE_ALERT 10619
#define IDS_PROMPT_DEEP_SCANNING_ACCESSIBLE_ALERT 10620
#define IDS_DEEP_SCANNING_ACCESSIBLE_ALERT 10621
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED_ACCESSIBLE_ALERT 10622
#define IDS_DOWNLOAD_NOTIFICATION_COPY_TO_CLIPBOARD 10623
#define IDS_DOWNLOAD_MENU_SHOW 10624
#define IDS_DOWNLOAD_MENU_OPEN_WHEN_COMPLETE 10625
#define IDS_DOWNLOAD_MENU_OPEN 10626
#define IDS_DOWNLOAD_MENU_ALWAYS_OPEN_TYPE 10627
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN 10628
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN_ALWAYS 10629
#define IDS_DOWNLOAD_MENU_CANCEL 10630
#define IDS_DOWNLOAD_MENU_PAUSE_ITEM 10631
#define IDS_DOWNLOAD_MENU_RESUME_ITEM 10632
#define IDS_DOWNLOAD_MENU_DISCARD 10633
#define IDS_DOWNLOAD_MENU_KEEP 10634
#define IDS_DOWNLOAD_MENU_LEARN_MORE_SCANNING 10635
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INTERRUPTED 10636
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INSECURE 10637
#define IDS_DOWNLOAD_MENU_DEEP_SCAN 10638
#define IDS_ABANDON_DOWNLOAD_DIALOG_TITLE 10649
#define IDS_ABANDON_DOWNLOAD_DIALOG_CONTINUE_BUTTON 10650
#define IDS_ABANDON_DOWNLOAD_DIALOG_INCOGNITO_MESSAGE 10651
#define IDS_ABANDON_DOWNLOAD_DIALOG_GUEST_MESSAGE 10652
#define IDS_ABANDON_DOWNLOAD_DIALOG_EXIT_BUTTON 10653
#define IDS_DOWNLOAD_BUBBLE_HEADER_LABEL 10654
#define IDS_DOWNLOAD_BUBBLE_FOOTER_LABEL 10655
#define IDS_DOWNLOAD_BUBBLE_FOOTER_TOOLTIP_LABEL 10656
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO 10657
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_CUSTOM_ACTION 10658
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_DISMISS 10659
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_TITLE 10660
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_MESSAGE_WITH_SEPARATOR 10661
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_WITH_SYMBOL 10662
#define IDS_DOWNLOAD_BUBBLE_STATUS_RESUMING 10663
#define IDS_DOWNLOAD_BUBBLE_STATUS_DONE 10664
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_DONE_UPDATED 10665
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_INSECURE 10666
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_SUSPICIOUS 10667
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_DANGEROUS 10668
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_UNVERIFIED 10669
#define IDS_DOWNLOAD_BUBBLE_STATUS_BLOCKED 10670
#define IDS_DOWNLOAD_BUBBLE_STATUS_MALWARE 10671
#define IDS_DOWNLOAD_BUBBLE_STATUS_SUSPICIOUS 10672
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNED_FAILED_UPDATED 10673
#define IDS_DOWNLOAD_BUBBLE_CHECKBOX_BYPASS 10674
#define IDS_DOWNLOAD_BUBBLE_CONTINUE 10675
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_INSECURE_FILE 10676
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_SUSPICIOUS_FILE 10677
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_UNVERIFIED_FILE 10678
#define IDS_DOWNLOAD_BUBBLE_DELETE 10679
#define IDS_DOWNLOAD_BUBBLE_DELETE_FROM_HISTORY 10680
#define IDS_DOWNLOAD_BUBBLE_MAIN_BUTTON_SUBPAGE 10681
#define IDS_DOWNLOAD_BUBBLE_RESUME 10682
#define IDS_DOWNLOAD_BUBBLE_SCAN 10683
#define IDS_DOWNLOAD_BUBBLE_OPEN 10684
#define IDS_DOWNLOAD_BUBBLE_SCAN_UPDATED 10685
#define IDS_DOWNLOAD_BUBBLE_OPEN_UPDATED 10686
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW 10687
#define IDS_DOWNLOAD_BUBBLE_REVIEW 10688
#define IDS_DOWNLOAD_BUBBLE_RETRY 10689
#define IDS_DOWNLOAD_BUBBLE_OPEN_ANYWAY 10690
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_DISK_FULL 10691
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_DISK_FULL 10692
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_PATH_TOO_LONG 10693
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_PATH_TOO_LONG 10694
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NEEDS_PERMISSION 10695
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_TOO_LARGE 10696
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_TOO_LARGE 10697
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_UNFINISHED 10698
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_BLOCKED_ORGANIZATION 10699
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_WRONG 10700
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NETWORK_ERROR 10701
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_SITE_UNAVAILABLE 10702
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNAVAILABLE 10703
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_UNAVAILABLE 10704
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNFINISHED 10705
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_INSECURE 10706
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS 10707
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DECEPTIVE 10708
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS_FILE_TYPE 10709
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_UNCOMMON_FILE 10710
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_NO_SAFE_BROWSING 10711
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LABEL 10712
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LINK 10713
#define IDS_DOWNLOAD_BUBBLE_STATUS_DANGEROUS 10714
#define IDS_DOWNLOAD_BUBBLE_STATUS_ENCRYPTED 10715
#define IDS_DOWNLOAD_BUBBLE_STATUS_TOO_BIG 10716
#define IDS_DOWNLOAD_BUBBLE_STATUS_ADVANCED_PROTECTION 10717
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ADVANCED_PROTECTION 10718
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNCOMMON_FILE 10719
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNCOMMON_FILE 10720
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNKNOWN_SOURCE 10721
#define IDS_DOWNLOAD_BUBBLE_STATUS_SENSITIVE_CONTENT 10722
#define IDS_DOWNLOAD_BUBBLE_STATUS_SCAN_FAILED 10723
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_WARNING 10724
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_BLOCK 10725
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ENCRYPTED 10726
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_TOO_BIG 10727
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING 10728
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_SECONDARY 10729
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_ENTERPRISE_SECONDARY 10730
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_DISCARD 10731
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_CANCEL 10732
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SCAN_FAILED 10733
#define IDS_DOWNLOAD_BUBBLE_TRY_AGAIN 10734
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING_ENTERPRISE 10735
#define IDS_DOWNLOAD_BUBBLE_INCOGNITO_INFORMATION_ROW 10736
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION 10737
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION_ACCESSIBILITY 10738
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION 10739
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION_ACCESSIBILITY 10740
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION 10741
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION_ACCESSIBILITY 10742
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION 10743
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION_ACCESSIBILITY 10744
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION 10745
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION_ACCESSIBILITY 10746
#define IDS_DOWNLOAD_BUBBLE_BACK_RECENT_DOWNLOADS 10747
#define IDS_DOWNLOAD_BUBBLE_CANCEL_MAIN_BUTTON_ACCESSIBILITY 10748
#define IDS_DOWNLOAD_BUBBLE_DELETE_MAIN_BUTTON_ACCESSIBILITY 10749
#define IDS_DOWNLOAD_BUBBLE_KEEP_MAIN_BUTTON_ACCESSIBILITY 10750
#define IDS_DOWNLOAD_BUBBLE_SCAN_MAIN_BUTTON_ACCESSIBILITY 10751
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW_MAIN_BUTTON_ACCESSIBILITY 10752
#define IDS_DOWNLOAD_BUBBLE_RESUME_MAIN_BUTTON_ACCESSIBILITY 10753
#define IDS_DOWNLOAD_BUBBLE_REVIEW_MAIN_BUTTON_ACCESSIBILITY 10754
#define IDS_DOWNLOAD_BUBBLE_RETRY_MAIN_BUTTON_ACCESSIBILITY 10755
#define IDS_DOWNLOAD_BUBBLE_OPEN_MAIN_BUTTON_ACCESSIBILITY 10756
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW 10757
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_REMINDER 10758
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_LINK 10759
#define IDS_DOWNLOAD_BUBBLE_TOOLTIP_IN_PROGRESS_COUNT 10760
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT 10763
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_ARCHIVE_MALWARE 10764
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_PROMPT_UPDATED 10765
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING 10766
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_UPDATED 10767
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_ENCRYPTED_ARCHIVE 10768
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_DEEP_SCANNING_LINK 10769
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT 10770
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_EMPTY 10771
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_INVALID 10772
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT 10773
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT_EMPTY 10774
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT_INVALID 10775
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_IMMEDIATE_DEEP_SCAN_IN_PROGRESS 10776
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_IMMEDIATE_DEEP_SCAN_CANCEL 10777
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_IMMEDIATE_DEEP_SCAN_BYPASS 10778
#define IDS_DOWNLOAD_BUBBLE_STATUS_LOCAL_DECRYPTION_STATUS 10779
#define IDS_DOWNLOAD_BUBBLE_STATUS_PASSWORD_NEEDED 10780
#define IDS_DOWNLOAD_BUBBLE_ACCEPT_LOCAL_DECRYPTION 10781
#define IDS_DOWNLOAD_BUBBLE_BYPASS_LOCAL_DECRYPTION 10782
#define IDS_DOWNLOAD_BUBBLE_LOCAL_DECRYPTION_CANCEL 10783
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_LOCAL_DECRYPTION_IN_PROGRESS 10784
#define IDS_DOWNLOAD_BUBBLE_STATUS_LOCAL_DECRYPTING 10785
#define IDS_DOWNLOAD_LOCAL_DECRYPTION_PROMPT_ALERT 10786
#define IDS_WEB_APP_WITH_APP_TITLE 10787
#define IDS_OMNIBOX_PWA_INSTALL_ICON_LABEL 453
#define IDS_OMNIBOX_PWA_INSTALL_ICON_TOOLTIP 688
#define IDS_WEBAPP_UPDATE_REVIEW_ACCEPT_BUTTON 10788
#define IDS_WEBAPP_UPDATE_REVIEW_UNINSTALL_BUTTON 10789
#define IDS_WEBAPP_UPDATE_REVIEW_IGNORE_BUTTON 10790
#define IDS_ADD_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 10791
#define IDS_CREATE_SHORTCUTS_BUTTON_LABEL 10792
#define IDS_CREATE_SHORTCUT_NOT_APPS_DIALOG_TITLE 10793
#define IDS_CREATE_SHORTCUT_NOT_APPS_AX_BUBBLE_LABEL 10794
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 10795
#define IDS_INSTALL_PWA_BUTTON_LABEL 10796
#define IDS_INSTALL_PWA_DIALOG_TITLE 10797
#define IDS_WEB_APP_DETAILED_INSTALL_DIALOG_DESCRIPTION_TITLE 10798
#define IDS_DIY_APP_INSTALL_DIALOG_TITLE 10799
#define IDS_DIY_APP_INSTALL_DIALOG_SUBTITLE 10800
#define IDS_DIY_APP_AX_BUBBLE_NAME_LABEL 10801
#define IDS_INSTALL_PWA_DIALOG_ORIGIN_LABEL 10802
#define IDS_BOOKMARK_APP_AX_BUBBLE_NAME_LABEL 10803
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TAB 10804
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_WINDOW 10805
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TABBED_WINDOW 10806
#define IDS_WEB_APP_INSTALL_NOT_SUPPORTED_DIALOG_TITLE_INCOGNITO_MODE 10807
#define IDS_WEB_APP_INSTALL_NOT_SUPPORTED_DIALOG_TITLE_GUEST_MODE 10808
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME 10809
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_ICON 10810
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_ICON 10811
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_LOGO 10812
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_LOGO 10813
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_URL 10814
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_URL 10815
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_LOGO_AND_URL 10816
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_LOGO_AND_URL 10817
#define IDS_WEBAPP_UPDATE_NEW_EXPLANATION 10818
#define IDS_WEBAPP_UPDATE_EXPLANATION 10819
#define IDS_WEBAPP_UPDATE_CURRENT_ICON 10820
#define IDS_WEBAPP_UPDATE_NEW_ICON 10821
#define IDS_WEBAPP_UPDATE_NEGATIVE_BUTTON 10822
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION 10823
#define IDS_FINISH_POLICY_WEB_APP_INSTALATION_RESTART 10824
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION_NOT_NOW 10825
#define IDS_ADD_TO_OS_LAUNCH_SURFACE 10830
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE 10831
#define IDS_INSTALL_DIY_TO_OS_LAUNCH_SURFACE 10832
#define IDS_UNINSTALL_FROM_OS_LAUNCH_SURFACE 10833
#define IDS_REVIEW_APP_UPDATE 10834
#define IDS_APPLICATION_INFO_WEB_STORE_LINK 10835
#define IDS_APPLICATION_INFO_HOMEPAGE_LINK 10836
#define IDS_ARC_APPLICATION_INFO_MANAGE_LINK 10837
#define IDS_APPLICATION_INFO_APP_OVERVIEW_TITLE 10838
#define IDS_APPLICATION_INFO_APP_PERMISSIONS_TITLE 10839
#define IDS_APPLICATION_INFO_UNINSTALL_BUTTON_TEXT 10840
#define IDS_APPLICATION_INFO_LICENSES_BUTTON_TEXT 10841
#define IDS_APPLICATION_INFO_SIZE_LABEL 10842
#define IDS_APPLICATION_INFO_VERSION_LABEL 10843
#define IDS_APPLICATION_INFO_CREATE_SHORTCUTS_BUTTON_TEXT 10844
#define IDS_APPLICATION_INFO_LAUNCH_OPTIONS_ACCNAME 10845
#define IDS_APPLICATION_INFO_SIZE_LOADING_LABEL 10846
#define IDS_APPLICATION_INFO_SIZE_SMALL_LABEL 10847
#define IDS_APPLICATION_INFO_REVOKE_PERMISSION_ALT_TEXT 10848
#define IDS_APPLICATION_INFO_APP_NO_PERMISSIONS_TEXT 10849
#define IDS_APPLICATION_INFO_EXTENSION_NO_PERMISSIONS_TEXT 10850
#define IDS_APPLICATION_INFO_RETAINED_FILES 10851
#define IDS_APPLICATION_INFO_RETAINED_DEVICES 10852
#define IDS_CREATE_SHORTCUTS_TITLE 10853
#define IDS_CREATE_SHORTCUTS_LABEL 10854
#define IDS_CREATE_SHORTCUTS_DESKTOP_CHKBOX 10855
#define IDS_CREATE_SHORTCUTS_MENU_CHKBOX 10856
#define IDS_CREATE_SHORTCUTS_COMMIT 10857
#define IDS_CREATE_SHORTCUTS_START_MENU_CHKBOX 10858
#define IDS_PIN_TO_TASKBAR_CHKBOX 10859
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_TITLE 10860
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_LABEL 10861
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_TITLE 10862
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_LABEL 10863
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_TITLE 10864
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_LABEL 10865
#define IDS_MANAGE 10866
#define IDS_LIST_BULLET 10867
#define IDS_BLOCKED_DOWNLOAD_NO_ACTION 10868
#define IDS_BLOCKED_DOWNLOAD_UNBLOCK 10869
#define IDS_ALLOWED_DOWNLOAD_TITLE 10870
#define IDS_BLOCKED_DOWNLOAD_TITLE 10871
#define IDS_BLOCKED_DOWNLOADS_EXPLANATION 10872
#define IDS_ALLOWED_DOWNLOAD_NO_ACTION 10873
#define IDS_ALLOWED_DOWNLOAD_BLOCK 10874
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_TITLE 10875
#define IDS_ACCESSED_ON_DEVICE_SITE_DATA_TITLE 10876
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_MESSAGE 10877
#define IDS_ACCESSED_ON_DEVICE_SITE_DATA_MESSAGE 10878
#define IDS_BLOCKED_COOKIES_INFO 10879
#define IDS_BLOCKED_IMAGES_TITLE 10880
#define IDS_BLOCKED_IMAGES_MESSAGE 10881
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_UNBLOCK 10882
#define IDS_BLOCKED_IMAGES_UNBLOCK 10883
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_NO_ACTION 10884
#define IDS_ALLOWED_ON_DEVICE_SITE_DATA_NO_ACTION 10885
#define IDS_ALLOWED_ON_DEVICE_SITE_DATA_BLOCK 10886
#define IDS_BLOCKED_IMAGES_NO_ACTION 10887
#define IDS_BLOCKED_POPUPS_TOOLTIP 10888
#define IDS_BLOCKED_POPUPS_TITLE 10889
#define IDS_BLOCKED_POPUPS_REDIRECTS_UNBLOCK 10890
#define IDS_BLOCKED_POPUPS_REDIRECTS_NO_ACTION 10891
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ALLOW 10892
#define IDS_BLOCKED_MEDIASTREAM_MIC_ALLOW 10893
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ALLOW 10894
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ASK 10895
#define IDS_BLOCKED_MEDIASTREAM_MIC_ASK 10896
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ASK 10897
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_BLOCK 10898
#define IDS_ALLOWED_MEDIASTREAM_MIC_BLOCK 10899
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_BLOCK 10900
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 10901
#define IDS_BLOCKED_MEDIASTREAM_MIC_NO_ACTION 10902
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_NO_ACTION 10903
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 10904
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_PAN_TILT_ZOOM_NO_ACTION 10905
#define IDS_ALLOWED_MEDIASTREAM_MIC_NO_ACTION 10906
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_NO_ACTION 10907
#define IDS_ALLOWED_CAMERA_PAN_TILT_ZOOM_NO_ACTION 10908
#define IDS_BLOCKED_POPUPS_EXPLANATORY_TEXT 10909
#define IDS_BLOCKED_JAVASCRIPT_TITLE 10910
#define IDS_BLOCKED_JAVASCRIPT_MESSAGE 10911
#define IDS_BLOCKED_JAVASCRIPT_UNBLOCK 10912
#define IDS_BLOCKED_JAVASCRIPT_NO_ACTION 10913
#define IDS_BLOCKED_SOUND_TITLE 10914
#define IDS_BLOCKED_SOUND_UNBLOCK 10915
#define IDS_BLOCKED_SOUND_NO_ACTION 10916
#define IDS_NOTIFICATIONS_OFF_EXPLANATORY_TEXT 442
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_TITLE 10917
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DESCRIPTION 10918
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_DESCRIPTION 10919
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 10920
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_COMPACT_ALLOW_BUTTON 10921
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CONTINUE_BLOCKING_BUTTON 10922
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_EARLY_PROMO 10923
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 10924
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 10925
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ABUSIVE_DESCRIPTION 10926
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DISRUPTIVE_DESCRIPTION 10927
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 10928
#define IDS_GEOLOCATION_OFF_EXPLANATORY_TEXT 10929
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_TITLE 10930
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 10931
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 10932
#define IDS_STORAGE_ACCESS_PERMISSION_BUBBLE_MESSAGE 10933
#define IDS_STORAGE_ACCESS_PERMISSION_ALLOWED_TOOLTIP 10934
#define IDS_STORAGE_ACCESS_PERMISSION_BLOCKED_TOOLTIP 10935
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_BLOCKED_TITLE 10936
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_ALLOWED_TITLE 10937
#define IDS_COOKIE_CONTROLS_BUBBLE_SITE_NOT_WORKING_TITLE 10938
#define IDS_TRACKING_PROTECTION_BUBBLE_SITE_NOT_WORKING_DESCRIPTION 10939
#define IDS_TRACKING_PROTECTION_BUBBLE_LIMITING_RESTART_TITLE 10940
#define IDS_TRACKING_PROTECTION_BUBBLE_BLOCKING_RESTART_TITLE 10941
#define IDS_TRACKING_PROTECTION_BUBBLE_BLOCKING_RESTART_DESCRIPTION 10942
#define IDS_TRACKING_PROTECTION_BUBBLE_PERMANENT_ALLOWED_TITLE 10943
#define IDS_TRACKING_PROTECTION_BUBBLE_PERMANENT_ALLOWED_DESCRIPTION 10944
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_TITLE 10945
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_DESCRIPTION 10946
#define IDS_COOKIE_CONTROLS_BUBBLE_RELOADING_LABEL 10947
#define IDS_COOKIE_CONTROLS_BUBBLE_THIRD_PARTY_COOKIES_LABEL 10948
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_FORM_PLACEHOLDER 10949
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_ALLOWED_LABEL 10950
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_BLOCKED_LABEL 10951
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_LIMITED_LABEL 10952
#define IDS_TRACKING_PROTECTION_PAGE_ACTION_SITE_NOT_WORKING_LABEL 10953
#define IDS_COOKIE_CONTROLS_PROMO_TITLE 10954
#define IDS_COOKIE_CONTROLS_PROMO_TEXT 10955
#define IDS_COOKIE_CONTROLS_PROMO_CLOSE_BUTTON_TEXT 10956
#define IDS_COOKIE_CONTROLS_PROMO_SEE_HOW_BUTTON_TEXT 10957
#define IDS_CERT_SELECTOR_SUBJECT_COLUMN 10958
#define IDS_CERT_SELECTOR_ISSUER_COLUMN 10959
#define IDS_CERT_SELECTOR_PROVIDER_COLUMN 10960
#define IDS_CERT_SELECTOR_SERIAL_COLUMN 10961
#define IDS_CERT_EXPORT_TYPE_BASE64_ALL 10962
#define IDS_CERT_EXPORT_TYPE_BASE64 10963
#define IDS_CERT_EXPORT_TYPE_BASE64_CHAIN 10964
#define IDS_CERT_EXPORT_TYPE_DER 10965
#define IDS_CERT_EXPORT_TYPE_PKCS7 10966
#define IDS_CERT_EXPORT_TYPE_PKCS7_CHAIN 10967
#define IDS_CERT_INFO_DIALOG_TITLE 10968
#define IDS_CERT_INFO_GENERAL_TAB_LABEL 10969
#define IDS_CERT_INFO_DETAILS_TAB_LABEL 10970
#define IDS_CERT_INFO_MODIFICATIONS_TAB_LABEL 10971
#define IDS_CERT_INFO_TRUST_LABEL 10972
#define IDS_CERT_INFO_TRUST_STATE_LABEL 10973
#define IDS_CERT_INFO_TRUST_STATE_DISTRUSTED 10974
#define IDS_CERT_INFO_TRUST_STATE_HINT 10975
#define IDS_CERT_INFO_TRUST_STATE_TRUSTED 10976
#define IDS_CERT_INFO_CONSTRAINTS_LABEL 10977
#define IDS_CERT_INFO_ADD_CONSTRAINTS_LABEL 10978
#define IDS_CERT_INFO_ADD_CONSTRAINTS_BUTTON_LABEL 10979
#define IDS_CERT_INFO_ADD_CONSTRAINTS_PLACEHOLDER 10980
#define IDS_CERT_INFO_ADD_CONSTRAINT_ERROR_MESSAGE 10981
#define IDS_CERT_INFO_DELETE_CONSTRAINT_ERROR_MESSAGE 10982
#define IDS_CERT_INFO_TRUST_STATE_ERROR_MESSAGE 10983
#define IDS_CERT_USAGE_SSL_CLIENT 10984
#define IDS_CERT_USAGE_SSL_SERVER 10985
#define IDS_CERT_USAGE_OBJECT_SIGNER 10986
#define IDS_CERT_USAGE_SSL_CA 10987
#define IDS_CERT_INFO_IDN_VALUE_FORMAT 10988
#define IDS_CERT_INFO_FIELD_NOT_PRESENT 10989
#define IDS_CERT_DETAILS_CERTIFICATE_HIERARCHY_LABEL 10990
#define IDS_CERT_DETAILS_CERTIFICATE_FIELDS_LABEL 10991
#define IDS_CERT_DETAILS_CERTIFICATE_FIELD_VALUE_LABEL 10992
#define IDS_CERT_DETAILS_CERTIFICATE 10993
#define IDS_CERT_DETAILS_VERSION 10994
#define IDS_CERT_DETAILS_VERSION_FORMAT 10995
#define IDS_CERT_DETAILS_SERIAL_NUMBER 10996
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_ALG 10997
#define IDS_CERT_DETAILS_ISSUER 10998
#define IDS_CERT_DETAILS_VALIDITY 10999
#define IDS_CERT_DETAILS_NOT_BEFORE 11000
#define IDS_CERT_DETAILS_NOT_AFTER 11001
#define IDS_CERT_DETAILS_SUBJECT 11002
#define IDS_CERT_DETAILS_SUBJECT_KEY_INFO 11003
#define IDS_CERT_DETAILS_SUBJECT_KEY_ALG 11004
#define IDS_CERT_DETAILS_SUBJECT_KEY 11005
#define IDS_CERT_RSA_PUBLIC_KEY_DUMP_FORMAT 11006
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_VALUE 11007
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE 11008
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE_A11Y_LABEL 11009
#define IDS_CERT_OID_AVA_COMMON_NAME 11010
#define IDS_CERT_OID_AVA_STATE_OR_PROVINCE 11011
#define IDS_CERT_OID_AVA_ORGANIZATION_NAME 11012
#define IDS_CERT_OID_AVA_ORGANIZATIONAL_UNIT_NAME 11013
#define IDS_CERT_OID_AVA_DN_QUALIFIER 11014
#define IDS_CERT_OID_AVA_COUNTRY_NAME 11015
#define IDS_CERT_OID_AVA_SERIAL_NUMBER 11016
#define IDS_CERT_OID_AVA_LOCALITY 11017
#define IDS_CERT_OID_AVA_DC 11018
#define IDS_CERT_OID_RFC1274_MAIL 11019
#define IDS_CERT_OID_RFC1274_UID 11020
#define IDS_CERT_OID_PKCS9_EMAIL_ADDRESS 11021
#define IDS_CERT_OID_BUSINESS_CATEGORY 11022
#define IDS_CERT_OID_EV_INCORPORATION_LOCALITY 11023
#define IDS_CERT_OID_EV_INCORPORATION_STATE 11024
#define IDS_CERT_OID_EV_INCORPORATION_COUNTRY 11025
#define IDS_CERT_OID_AVA_STREET_ADDRESS 11026
#define IDS_CERT_OID_AVA_POSTAL_CODE 11027
#define IDS_CERT_OID_PKCS1_RSA_ENCRYPTION 11028
#define IDS_CERT_OID_PKCS1_MD2_WITH_RSA_ENCRYPTION 11029
#define IDS_CERT_OID_PKCS1_MD4_WITH_RSA_ENCRYPTION 11030
#define IDS_CERT_OID_PKCS1_MD5_WITH_RSA_ENCRYPTION 11031
#define IDS_CERT_OID_PKCS1_SHA1_WITH_RSA_ENCRYPTION 11032
#define IDS_CERT_OID_PKCS1_SHA256_WITH_RSA_ENCRYPTION 11033
#define IDS_CERT_OID_PKCS1_SHA384_WITH_RSA_ENCRYPTION 11034
#define IDS_CERT_OID_PKCS1_SHA512_WITH_RSA_ENCRYPTION 11035
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA1_SIGNATURE 11036
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA256_SIGNATURE 11037
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA384_SIGNATURE 11038
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA512_SIGNATURE 11039
#define IDS_CERT_OID_ANSIX962_EC_PUBLIC_KEY 11040
#define IDS_CERT_OID_SECG_EC_SECP256R1 11041
#define IDS_CERT_OID_SECG_EC_SECP384R1 11042
#define IDS_CERT_OID_SECG_EC_SECP521R1 11043
#define IDS_CERT_EXT_NS_CERT_TYPE 11044
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL 11045
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL_CA 11046
#define IDS_CERT_EXT_NS_CERT_BASE_URL 11047
#define IDS_CERT_EXT_NS_CERT_REVOCATION_URL 11048
#define IDS_CERT_EXT_NS_CA_REVOCATION_URL 11049
#define IDS_CERT_EXT_NS_CERT_RENEWAL_URL 11050
#define IDS_CERT_EXT_NS_CA_POLICY_URL 11051
#define IDS_CERT_EXT_NS_SSL_SERVER_NAME 11052
#define IDS_CERT_EXT_NS_COMMENT 11053
#define IDS_CERT_EXT_NS_LOST_PASSWORD_URL 11054
#define IDS_CERT_EXT_NS_CERT_RENEWAL_TIME 11055
#define IDS_CERT_X509_SUBJECT_DIRECTORY_ATTR 11056
#define IDS_CERT_X509_SUBJECT_KEYID 11057
#define IDS_CERT_KEYID_FORMAT 11058
#define IDS_CERT_ISSUER_FORMAT 11059
#define IDS_CERT_SERIAL_NUMBER_FORMAT 11060
#define IDS_CERT_X509_KEY_USAGE 11061
#define IDS_CERT_X509_ISSUER_ALT_NAME 11062
#define IDS_CERT_X509_BASIC_CONSTRAINTS 11063
#define IDS_CERT_X509_NAME_CONSTRAINTS 11064
#define IDS_CERT_X509_CRL_DIST_POINTS 11065
#define IDS_CERT_X509_CERT_POLICIES 11066
#define IDS_CERT_X509_SCT_LIST 11067
#define IDS_CERT_QC_STATEMENTS 11068
#define IDS_CERT_X509_POLICY_MAPPINGS 11069
#define IDS_CERT_X509_POLICY_CONSTRAINTS 11070
#define IDS_CERT_X509_AUTH_KEYID 11071
#define IDS_CERT_X509_EXT_KEY_USAGE 11072
#define IDS_CERT_X509_AUTH_INFO_ACCESS 11073
#define IDS_CERT_X509_KEY_USAGE_SIGNING 11074
#define IDS_CERT_X509_KEY_USAGE_NONREP 11075
#define IDS_CERT_X509_KEY_USAGE_ENCIPHERMENT 11076
#define IDS_CERT_X509_KEY_USAGE_DATA_ENCIPHERMENT 11077
#define IDS_CERT_X509_KEY_USAGE_KEY_AGREEMENT 11078
#define IDS_CERT_X509_KEY_USAGE_CERT_SIGNER 11079
#define IDS_CERT_X509_KEY_USAGE_CRL_SIGNER 11080
#define IDS_CERT_X509_KEY_USAGE_ENCIPHER_ONLY 11081
#define IDS_CERT_X509_KEY_USAGE_DECIPHER_ONLY 11082
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_CA 11083
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_NOT_CA 11084
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN 11085
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN_UNLIMITED 11086
#define IDS_CERT_PKIX_CPS_POINTER_QUALIFIER 11087
#define IDS_CERT_PKIX_USER_NOTICE_QUALIFIER 11088
#define IDS_CERT_REVOCATION_REASON_UNUSED 11089
#define IDS_CERT_REVOCATION_REASON_KEY_COMPROMISE 11090
#define IDS_CERT_REVOCATION_REASON_CA_COMPROMISE 11091
#define IDS_CERT_REVOCATION_REASON_AFFILIATION_CHANGED 11092
#define IDS_CERT_REVOCATION_REASON_SUPERSEDED 11093
#define IDS_CERT_REVOCATION_REASON_CESSATION_OF_OPERATION 11094
#define IDS_CERT_REVOCATION_REASON_CERTIFICATE_HOLD 11095
#define IDS_CERT_OCSP_RESPONDER_FORMAT 11096
#define IDS_CERT_CA_ISSUERS_FORMAT 11097
#define IDS_CERT_UNKNOWN_OID_INFO_FORMAT 11098
#define IDS_CERT_EXT_KEY_USAGE_FORMAT 11099
#define IDS_CERT_MULTILINE_INFO_START_FORMAT 11100
#define IDS_CERT_GENERAL_NAME_RFC822_NAME 11101
#define IDS_CERT_GENERAL_NAME_DNS_NAME 11102
#define IDS_CERT_GENERAL_NAME_X400_ADDRESS 11103
#define IDS_CERT_GENERAL_NAME_DIRECTORY_NAME 11104
#define IDS_CERT_GENERAL_NAME_EDI_PARTY_NAME 11105
#define IDS_CERT_GENERAL_NAME_URI 11106
#define IDS_CERT_GENERAL_NAME_IP_ADDRESS 11107
#define IDS_CERT_GENERAL_NAME_REGISTERED_ID 11108
#define IDS_CERT_EXT_MS_APP_POLICIES 11109
#define IDS_CERT_EXT_MS_CERT_TEMPLATE 11110
#define IDS_CERT_EXT_MS_CERT_TYPE 11111
#define IDS_CERT_EXT_MS_CA_VERSION 11112
#define IDS_CERT_EXT_MS_NT_PRINCIPAL_NAME 11113
#define IDS_CERT_EXT_MS_NTDS_REPLICATION 11114
#define IDS_CERT_EKU_ANY_EKU 11115
#define IDS_CERT_EKU_TLS_WEB_SERVER_AUTHENTICATION 11116
#define IDS_CERT_EKU_TLS_WEB_CLIENT_AUTHENTICATION 11117
#define IDS_CERT_EKU_CODE_SIGNING 11118
#define IDS_CERT_EKU_EMAIL_PROTECTION 11119
#define IDS_CERT_EKU_TIME_STAMPING 11120
#define IDS_CERT_EKU_OCSP_SIGNING 11121
#define IDS_CERT_POLICY_ETSI_QEVCP_W 11122
#define IDS_CERT_POLICY_ETSI_QNCP_W 11123
#define IDS_CERT_QC_ETSI_QCS_QCCOMPLIANCE 11124
#define IDS_CERT_QC_ETSI_QCS_QCTYPE 11125
#define IDS_CERT_QC_ETSI_QCT_WEB 11126
#define IDS_CERT_EKU_MS_INDIVIDUAL_CODE_SIGNING 11127
#define IDS_CERT_EKU_MS_COMMERCIAL_CODE_SIGNING 11128
#define IDS_CERT_EKU_MS_TRUST_LIST_SIGNING 11129
#define IDS_CERT_EKU_MS_TIME_STAMPING 11130
#define IDS_CERT_EKU_MS_SERVER_GATED_CRYPTO 11131
#define IDS_CERT_EKU_MS_ENCRYPTING_FILE_SYSTEM 11132
#define IDS_CERT_EKU_MS_FILE_RECOVERY 11133
#define IDS_CERT_EKU_MS_WINDOWS_HARDWARE_DRIVER_VERIFICATION 11134
#define IDS_CERT_EKU_MS_QUALIFIED_SUBORDINATION 11135
#define IDS_CERT_EKU_MS_KEY_RECOVERY 11136
#define IDS_CERT_EKU_MS_DOCUMENT_SIGNING 11137
#define IDS_CERT_EKU_MS_LIFETIME_SIGNING 11138
#define IDS_CERT_EKU_MS_SMART_CARD_LOGON 11139
#define IDS_CERT_EKU_MS_KEY_RECOVERY_AGENT 11140
#define IDS_CERT_EKU_NETSCAPE_INTERNATIONAL_STEP_UP 11141
#define IDS_CERT_EXTENSION_CRITICAL 11142
#define IDS_CERT_EXTENSION_NON_CRITICAL 11143
#define IDS_CERT_DUMP_ERROR 11144
#define IDS_CERT_EXTENSION_DUMP_ERROR 11145
#define IDS_CERTIFICATE_MANAGER_TITLE 11146
#define IDS_CERT_MANAGER_HARDWARE_BACKED_KEY_FORMAT 11147
#define IDS_CERT_MANAGER_HARDWARE_BACKED 11148
#define IDS_CERT_MANAGER_EXTENSION_PROVIDED_FORMAT 11149
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR 11150
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR_LEARN_MORE 11151
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR_OPT_OUT 11152
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR_RESTART_NEEDED 11153
#define IDS_DEV_TOOLS_INFOBAR_LABEL 11154
#define IDS_DEV_TOOLS_CONFIRM_ADD_FILE_SYSTEM_MESSAGE 11155
#define IDS_DEV_TOOLS_EDIT_DIRECTORY_PERMISSION_TITLE 11156
#define IDS_DEV_TOOLS_CONFIRM_ALLOW_BUTTON 11157
#define IDS_DEV_TOOLS_CONFIRM_DENY_BUTTON 11158
#define IDS_RELOAD_MENU_NORMAL_RELOAD_ITEM 415
#define IDS_RELOAD_MENU_HARD_RELOAD_ITEM 416
#define IDS_RELOAD_MENU_EMPTY_AND_HARD_RELOAD_ITEM 417
#define IDS_TAB_SHARING_INFOBAR_SHARING_CURRENT_TAB_LABEL 11159
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_UNTITLED_TAB_LABEL 11160
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_TAB_LABEL 11161
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_TAB_TO_THIS_TAB_LABEL 11162
#define IDS_TAB_SHARING_INFOBAR_SHARE_BUTTON 11163
#define IDS_TAB_SHARING_INFOBAR_STOP_BUTTON 11164
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_BUTTON 11165
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURER_BUTTON 11166
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURED_BUTTON 11167
#define IDS_TAB_SHARING_INFOBAR_CAPTURED_SURFACE_CONTROL_PERMISSION_BUTTON 11168
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_LABEL 11169
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_NO_DEVICE_NAME_LABEL 11170
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_LABEL 11171
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_NO_DEVICE_NAME_LABEL 11172
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_LABEL 11173
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_NO_DEVICE_NAME_LABEL 11174
#define IDS_TAB_CASTING_INFOBAR_CAST_BUTTON 11175
#define IDS_TAB_CASTING_INFOBAR_STOP_BUTTON 11176
#define IDS_TASK_MANAGER_KILL 11177
#define IDS_TASK_MANAGER_KILL_V2 11178
#define IDS_TASK_MANAGER_PROCESS_ID_COLUMN 11179
#define IDS_TASK_MANAGER_GDI_HANDLES_COLUMN 11180
#define IDS_TASK_MANAGER_USER_HANDLES_COLUMN 11181
#define IDS_TASK_MANAGER_TASK_COLUMN 11182
#define IDS_TASK_MANAGER_NET_COLUMN 11183
#define IDS_TASK_MANAGER_CPU_COLUMN 11184
#define IDS_TASK_MANAGER_START_TIME_COLUMN 11185
#define IDS_TASK_MANAGER_CPU_TIME_COLUMN 11186
#define IDS_TASK_MANAGER_MEM_FOOTPRINT_COLUMN 11187
#define IDS_TASK_MANAGER_SWAPPED_MEM_COLUMN 11188
#define IDS_TASK_MANAGER_PROFILE_NAME_COLUMN 11189
#define IDS_TASK_MANAGER_IDLE_WAKEUPS_COLUMN 11190
#define IDS_TASK_MANAGER_HARD_FAULTS_COLUMN 11191
#define IDS_TASK_MANAGER_OPEN_FD_COUNT_COLUMN 11192
#define IDS_TASK_MANAGER_PROCESS_PRIORITY_COLUMN 11193
#define IDS_TASK_MANAGER_WEBCORE_IMAGE_CACHE_COLUMN 11194
#define IDS_TASK_MANAGER_WEBCORE_SCRIPTS_CACHE_COLUMN 11195
#define IDS_TASK_MANAGER_WEBCORE_CSS_CACHE_COLUMN 11196
#define IDS_TASK_MANAGER_VIDEO_MEMORY_COLUMN 11197
#define IDS_TASK_MANAGER_SQLITE_MEMORY_USED_COLUMN 11198
#define IDS_TASK_MANAGER_JAVASCRIPT_MEMORY_ALLOCATED_COLUMN 11199
#define IDS_TASK_MANAGER_KEEPALIVE_COUNT_COLUMN 11200
#define IDS_TASK_MANAGER_MEM_CELL_TEXT 11201
#define IDS_TASK_MANAGER_CACHE_SIZE_CELL_TEXT 11202
#define IDS_TASK_MANAGER_NA_CELL_TEXT 11203
#define IDS_TASK_MANAGER_BACKGROUNDED_TEXT 11204
#define IDS_TASK_MANAGER_FOREGROUNDED_TEXT 11205
#define IDS_TASK_MANAGER_HANDLES_CELL_TEXT 11206
#define IDS_TASK_MANAGER_TASK_GROUP_CONNECT_TEXT 11207
#define IDS_TASK_MANAGER_WEB_BROWSER_CELL_TEXT 11208
#define IDS_TASK_MANAGER_EXTENSION_PREFIX 11209
#define IDS_TASK_MANAGER_EXTENSION_INCOGNITO_PREFIX 11210
#define IDS_TASK_MANAGER_APP_PREFIX 11211
#define IDS_TASK_MANAGER_APP_INCOGNITO_PREFIX 11212
#define IDS_TASK_MANAGER_TAB_PREFIX 11213
#define IDS_TASK_MANAGER_TAB_INCOGNITO_PREFIX 11214
#define IDS_TASK_MANAGER_BACKGROUND_APP_PREFIX 11215
#define IDS_TASK_MANAGER_BACKGROUND_PREFIX 11216
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_PREFIX 11217
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_PREFIX 11218
#define IDS_TASK_MANAGER_PRELOADED_RENDERER_FOR_UI 11219
#define IDS_TASK_MANAGER_NO_STATE_PREFETCH_PREFIX 11220
#define IDS_TASK_MANAGER_PRERENDER_PREFIX 11221
#define IDS_TASK_MANAGER_SPARE_RENDERER_PREFIX 11222
#define IDS_TASK_MANAGER_UNKNOWN_RENDERER_PREFIX 11223
#define IDS_TASK_MANAGER_DEDICATED_WORKER_PREFIX 11224
#define IDS_TASK_MANAGER_SHARED_WORKER_PREFIX 11225
#define IDS_TASK_MANAGER_SERVICE_WORKER_PREFIX 11226
#define IDS_TASK_MANAGER_UTILITY_PREFIX 11227
#define IDS_TASK_MANAGER_GPU_PREFIX 11228
#define IDS_TASK_MANAGER_PRINT_PREFIX 11229
#define IDS_TASK_MANAGER_SUBFRAME_PREFIX 11230
#define IDS_TASK_MANAGER_SUBFRAME_INCOGNITO_PREFIX 11231
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_SUBFRAME_PREFIX 11232
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_SUBFRAME_PREFIX 11233
#define IDS_TASK_MANAGER_PORTAL_PREFIX 11234
#define IDS_TASK_MANAGER_PORTAL_INCOGNITO_PREFIX 11235
#define IDS_TASK_MANAGER_FENCED_FRAME_PREFIX 11236
#define IDS_TASK_MANAGER_FENCED_FRAME_INCOGNITO_PREFIX 11237
#define IDS_TASK_MANAGER_ARC_PREFIX 11238
#define IDS_TASK_MANAGER_TOOL_PREFIX 11239
#define IDS_TASK_MANAGER_ARC_PREFIX_BACKGROUND_SERVICE 11240
#define IDS_TASK_MANAGER_ARC_PREFIX_RECEIVER 11241
#define IDS_TASK_MANAGER_ARC_SYSTEM 11242
#define IDS_TASK_MANAGER_LINUX_VM_PREFIX 11243
#define IDS_TASK_MANAGER_PLUGIN_VM_PREFIX 11244
#define IDS_TASK_MANAGER_OMNIBOX 11245
#define IDS_UTILITY_PROCESS_FILE_UTILITY_NAME 11246
#define IDS_UTILITY_PROCESS_PROFILE_IMPORTER_NAME 11247
#define IDS_UTILITY_PROCESS_QRCODE_GENERATOR_SERVICE_NAME 11248
#define IDS_UTILITY_PROCESS_WIFI_CREDENTIALS_GETTER_NAME 11249
#define IDS_UTILITY_PROCESS_IMAGE_WRITER_NAME 11250
#define IDS_UTILITY_PROCESS_MEDIA_GALLERY_UTILITY_NAME 11251
#define IDS_UTILITY_PROCESS_NOOP_SERVICE_NAME 11252
#define IDS_SERVICE_PROCESS_DOCUMENT_ANALYSIS_NAME 11253
#define IDS_THEME_INSTALL_INFOBAR_LABEL 11254
#define IDS_THEME_INSTALL_INFOBAR_UNDO_BUTTON 11255
#define IDS_CRITICAL_NOTIFICATION_RESTART 11256
#define IDS_EXTENSION_DISABLED_ERROR_LABEL 11257
#define IDS_EXTENSION_IS_BLOCKLISTED 11258
#define IDS_EXTENSION_DISABLED_REMOTE_INSTALL_ERROR_TITLE 11259
#define IDS_EXTENSION_DISABLED_ERROR_TITLE 11260
#define IDS_EXTENSION_SITE_RELOAD_PAGE_BUBBLE_HEADING 11261
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_OK_BUTTON 11262
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_SINGLE_EXTENSION_TITLE 11263
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_MULTIPLE_EXTENSIONS_TITLE 11264
#define IDS_APP_UNINSTALL_PROMPT_TITLE 11265
#define IDS_ARC_APP_UNINSTALL_PROMPT_DATA_REMOVAL_WARNING 11266
#define IDS_EXTENSION_UNINSTALL_PROMPT_TITLE 11267
#define IDS_EXTENSION_CONFIRM_PERMISSIONS 11268
#define IDS_EXTENSION_INSTALL_PROMPT_TITLE 11269
#define IDS_EXTENSION_REQUEST_PROMPT_TITLE 11270
#define IDS_EXTENSION_PENDING_REQUEST_PROMPT_TITLE 11271
#define IDS_EXTENSION_BLOCKED_BY_POLICY_PROMPT_TITLE 11272
#define IDS_EXTENSION_RE_ENABLE_PROMPT_TITLE 11273
#define IDS_EXTENSION_PERMISSIONS_PROMPT_TITLE 11274
#define IDS_EXTENSION_REMOTE_INSTALL_PROMPT_TITLE 11275
#define IDS_EXTENSION_REPAIR_PROMPT_TITLE 11276
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 11277
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_APP 11278
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 11279
#define IDS_EXTENSION_ALERT_TITLE 11280
#define IDS_APP_ALERT_TITLE 11281
#define IDS_EXTENSION_AND_APP_ALERT_TITLE 11282
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_TITLE 11283
#define IDS_POLICY_BLOCKED_EXTENSIONS_ALERT_ITEM_TITLE 11284
#define IDS_BLOCKLISTED_EXTENSIONS_ALERT_ITEM 11285
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_ITEM_DETAIL 11286
#define IDS_EXTENSION_ALERT_ITEM_OK 11287
#define IDS_EXTENSION_ALERT_ITEM_DETAILS 11288
#define IDS_EXTENSION_PROMPT_APP_CONNECT_FROM_INCOGNITO 11289
#define IDS_EXTENSION_PROMPT_EXTENSION_CONNECT_FROM_INCOGNITO 11290
#define IDS_EXTENSION_PROMPT_WILL_HAVE_ACCESS_TO 11291
#define IDS_EXTENSION_PROMPT_WILL_NOW_HAVE_ACCESS_TO 11292
#define IDS_EXTENSION_PROMPT_WANTS_ACCESS_TO 11293
#define IDS_EXTENSION_PROMPT_CAN_ACCESS 11294
#define IDS_EXTENSION_PROMPT_GRANT_PERMISSIONS_CHECKBOX 11295
#define IDS_EXTENSION_PROMPT_MESSAGE_FROM_ADMIN 11296
#define IDS_EXTENSION_PERMISSION_LINE 11297
#define IDS_EXTENSION_RATING_COUNT 11298
#define IDS_EXTENSION_PROMPT_RATING_ACCESSIBLE_TEXT 11299
#define IDS_EXTENSION_PROMPT_NO_RATINGS_ACCESSIBLE_TEXT 11300
#define IDS_EXTENSION_USER_COUNT 11301
#define IDS_EXTENSION_PROMPT_STORE_LINK 11302
#define IDS_EXTENSIONS_LOAD_ERROR_ALERT_HEADING 11303
#define IDS_EXTENSIONS_LOAD_ERROR_MESSAGE 11304
#define IDS_EXTENSION_PROMPT_WARNING_FULL_ACCESS 11305
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS 11306
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS_READ_ONLY 11307
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_CAPTURE 11308
#define IDS_EXTENSION_PROMPT_WARNING_VIDEO_CAPTURE 11309
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_AND_VIDEO_CAPTURE 11310
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH 11311
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_DEVICES 11312
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_PRIVATE 11313
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_SERIAL 11314
#define IDS_EXTENSION_PROMPT_WARNING_BOOKMARKS 11315
#define IDS_EXTENSION_PROMPT_WARNING_READING_LIST 11316
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD 11317
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_READWRITE 11318
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_WRITE 11319
#define IDS_EXTENSION_PROMPT_WARNING_DEBUGGER 11320
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_WEB_REQUEST 11321
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_NET_REQUEST 11322
#define IDS_EXTENSION_PROMPT_WARNING_DOCUMENT_SCAN 11323
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_HARDWARE_PLATFORM 11324
#define IDS_EXTENSION_PROMPT_WARNING_FAVICON 11325
#define IDS_EXTENSION_PROMPT_WARNING_GEOLOCATION 11326
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ 11327
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ_ON_ALL_DEVICES 11328
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_WRITE_ON_ALL_DEVICES 11329
#define IDS_EXTENSION_PROMPT_WARNING_HOME_PAGE_SETTING_OVERRIDE 11330
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST 11331
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST_READ_ONLY 11332
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS 11333
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS_READ_ONLY 11334
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS 11335
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS_READ_ONLY 11336
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST 11337
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST_READ_ONLY 11338
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN 11339
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN_LIST 11340
#define IDS_EXTENSION_PROMPT_WARNING_INPUT 11341
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN 11342
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_LOGIN 11343
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_UI 11344
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_STORAGE 11345
#define IDS_EXTENSION_PROMPT_WARNING_MANAGEMENT 11346
#define IDS_EXTENSION_PROMPT_WARNING_MDNS 11347
#define IDS_EXTENSION_PROMPT_WARNING_NETWORK_STATE 11348
#define IDS_EXTENSION_PROMPT_WARNING_NETWORKING_PRIVATE 11349
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING 11350
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING_METRICS 11351
#define IDS_EXTENSION_PROMPT_WARNING_SEARCH_SETTINGS_OVERRIDE 11352
#define IDS_EXTENSION_PROMPT_WARNING_SERIAL 11353
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_ANY_HOST 11354
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAIN 11355
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAINS 11356
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOST 11357
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOSTS 11358
#define IDS_EXTENSION_PROMPT_WARNING_SPEECH_RECOGNITION 11359
#define IDS_EXTENSION_PROMPT_WARNING_START_PAGE_SETTING_OVERRIDE 11360
#define IDS_EXTENSION_PROMPT_WARNING_SYSTEM_STORAGE 11361
#define IDS_EXTENSION_PROMPT_WARNING_TAB_GROUPS 11362
#define IDS_EXTENSION_PROMPT_WARNING_TOPSITES 11363
#define IDS_EXTENSION_PROMPT_WARNING_TTS_ENGINE 11364
#define IDS_EXTENSION_PROMPT_WARNING_U2F_DEVICES 11365
#define IDS_EXTENSION_PROMPT_WARNING_NOTIFICATIONS 11366
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE 11367
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST 11368
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_PRODUCT 11369
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_VENDOR 11370
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_PRODUCT 11371
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_VENDOR 11372
#define IDS_EXTENSION_PROMPT_WARNING_VPN 11373
#define IDS_EXTENSION_PROMPT_WARNING_CONTENT_SETTINGS 11374
#define IDS_EXTENSION_PROMPT_WARNING_PRIVACY 11375
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS 11376
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS_OPEN 11377
#define IDS_EXTENSION_PROMPT_WARNING_IDENTITY_EMAIL 11378
#define IDS_EXTENSION_PROMPT_WARNING_WALLPAPER 11379
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_DIRECTORY 11380
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_WRITE_DIRECTORY 11381
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ 11382
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE 11383
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_DELETE 11384
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE_DELETE 11385
#define IDS_EXTENSION_PROMPT_WARNING_SYNCFILESYSTEM 11386
#define IDS_EXTENSION_PROMPT_WARNING_NATIVE_MESSAGING 11387
#define IDS_EXTENSION_PROMPT_WARNING_SCREENLOCK_PRIVATE 11388
#define IDS_EXTENSION_PROMPT_WARNING_ACTIVITY_LOG_PRIVATE 11389
#define IDS_EXTENSION_PROMPT_WARNING_DESKTOP_CAPTURE 11390
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_MODIFY 11391
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ 11392
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ_MODIFY 11393
#define IDS_EXTENSION_PROMPT_WARNING_PLATFORMKEYS 11394
#define IDS_EXTENSION_PROMPT_WARNING_CERTIFICATEPROVIDER 11395
#define IDS_EXTENSION_PROMPT_WARNING_SETTINGS_PRIVATE 11396
#define IDS_EXTENSION_PROMPT_WARNING_AUTOFILL_PRIVATE 11397
#define IDS_EXTENSION_PROMPT_WARNING_PASSWORDS_PRIVATE 11398
#define IDS_EXTENSION_PROMPT_WARNING_USERS_PRIVATE 11399
#define IDS_EXTENSION_PROMPT_WARNING_NEW_TAB_PAGE_OVERRIDE 11400
#define IDS_EXTENSION_PROMPT_WARNING_TRANSIENT_BACKGROUND 11401
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_DEVICE_ATTRIBUTES 11402
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_KIOSK_INPUT 11403
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_NETWORKING_ATTRIBUTES 11404
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_PLATFORMKEYS 11405
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE_ENABLED_WIN 11406
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE 11408
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REMOTE_APPS 11409
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_ATTACHED_DEVICE_INFO 11410
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_BLUETOOTH_PERIPHERALS_INFO 11411
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS 11412
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS_NETWORK_INFO_FOR_MLAB 11413
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_EVENTS 11414
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_MANAGEMENT_AUDIO 11415
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY 11416
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_SERIAL_NUMBER 11417
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_NETWORK_INFORMATION 11418
#define IDS_EXTENSION_PROMPT_WARNING_OMNIBOX_DIRECT_INPUT 11419
#define IDS_EXTENSION_CANT_DOWNGRADE_VERSION 11420
#define IDS_APP_CANT_DOWNGRADE_VERSION 11421
#define IDS_EXTENSION_MOVE_DIRECTORY_TO_PROFILE_FAILED 11424
#define IDS_EXTENSION_INSTALL_NOT_ENABLED 11425
#define IDS_EXTENSION_INSTALL_INCORRECT_APP_CONTENT_TYPE 11426
#define IDS_EXTENSION_INSTALL_INCORRECT_INSTALL_HOST 11427
#define IDS_EXTENSION_INSTALL_UNEXPECTED_ID 11428
#define IDS_EXTENSION_INSTALL_DISALLOWED_ON_SITE 11429
#define IDS_EXTENSION_INSTALL_UNEXPECTED_VERSION 11430
#define IDS_EXTENSION_INSTALL_DEPENDENCY_OLD_VERSION 11431
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_SHARED_MODULE 11432
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_ALLOWLISTED 11433
#define IDS_EXTENSION_INSTALL_GALLERY_ONLY 11434
#define IDS_EXTENSION_INSTALL_KIOSK_MODE_ONLY 11435
#define IDS_EXTENSION_OVERLAPPING_WEB_EXTENT 11436
#define IDS_EXTENSION_INVALID_IMAGE_PATH 11437
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_BODY_PART_2 11439
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO 11441
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO_WITH_SHORTCUT 11442
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO 11443
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO_WITH_SHORTCUT 11444
#define IDS_EXTENSION_INSTALLED_OMNIBOX_KEYWORD_INFO 11445
#define IDS_EXTENSION_INSTALLED_MANAGE_INFO 11446
#define IDS_EXTENSION_INSTALLED_MANAGE_SHORTCUTS 11447
#define IDS_EXTENSION_LAUNCH_WEB_AUTH_FLOW_TAB_INFO_BAR_TEXT 11448
#define IDS_EXTENSION_INSTALLED_DICE_PROMO_SYNC_MESSAGE 11449
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_TITLE 11450
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_READ_ONLY 11451
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_WRITABLE 11452
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_TITLE_LABEL 11453
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_ADDRESS_LABEL 11454
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_PORT_LABEL 11455
#define IDS_EXTENSIONS_CONTEXT_MENU_SITE_PERMISSIONS 11456
#define IDS_EXTENSIONS_CONTEXT_MENU_CANT_ACCESS_PAGE 11457
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS 11458
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_GRANTED 11459
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_BLOCKED 11460
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK_V2 11461
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE_V2 11462
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES_V2 11463
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_PERMISSIONS_PAGE 11464
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK 11465
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE 11466
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES 11467
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_LEARN_MORE 11468
#define IDS_EXTENSIONS_CONTEXT_MENU_PIN_TO_TOOLBAR 11469
#define IDS_EXTENSIONS_CONTEXT_MENU_UNPIN_FROM_TOOLBAR 11470
#define IDS_EXTENSIONS_OPTIONS_MENU_ITEM 11471
#define IDS_EXTENSIONS_INSTALLED_BY_ADMIN 11472
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR 11473
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR 11474
#define IDS_EXTENSIONS_PINNED_BY_ADMIN 11475
#define IDS_MANAGE_EXTENSION 11476
#define IDS_MANAGE_EXTENSIONS 11477
#define IDS_VIEW_WEB_PERMISSIONS 11478
#define IDS_EXTENSION_ACTION_INSPECT_POPUP 11479
#define IDS_EXTENSIONS_WANTS_ACCESS_TO_SITE 11480
#define IDS_EXTENSIONS_HAS_ACCESS_TO_SITE 11481
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON 11482
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_DISMISSED_TEXT 11483
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_SINGLE_EXTENSION 11484
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_MULTIPLE_EXTENSIONS 11485
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_HAS_ACCESS 11486
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_BLOCKED_ACCESS 11487
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_REQUESTS_ACCESS 11488
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_ALLOWED_ACCESS 11489
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_BLOCKED_ACCESS 11490
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_HAS_ACCESS 11491
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_REQUESTS_ACCESS 11492
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_PINNED_TEXT 11493
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_INSTALLED_TEXT 11494
#define IDS_EXTENSIONS_DISABLE 11495
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR_ACCESSIBLE_NAME 11496
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR_ACCESSIBLE_NAME 11497
#define IDS_EXTENSIONS_PINNED_BY_ADMIN_ACCESSIBLE_NAME 11498
#define IDS_EXTENSIONS_SUBMENU_OPEN_SIDE_PANEL_ITEM 11499
#define IDS_EXTENSIONS_SUBMENU_CLOSE_SIDE_PANEL_ITEM 11500
#define IDS_EXTENSIONS_LOCKED_SUPERVISED_USER 11504
#define IDS_EXTENSION_LOAD_FROM_DIRECTORY 11505
#define IDS_EXTENSION_COMMANDS_GENERIC_ACTIVATE 11506
#define IDS_EXTENSIONS_SUPERVISED_USER_PARENTAL_PERMISSION_FAILURE 11507
#define IDS_EXTENSION_PACK_DIALOG_HEADING 11508
#define IDS_EXTENSION_PACK_DIALOG_SELECT_KEY 11509
#define IDS_EXTENSION_PACK_DIALOG_KEY_FILE_TYPE_DESCRIPTION 11510
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_REQUIRED 11511
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_INVALID 11512
#define IDS_EXTENSION_PACK_DIALOG_ERROR_KEY_INVALID 11513
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_NEW 11514
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_UPDATE 11515
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_CONTINUE_BUTTON 11516
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_TITLE 11517
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_WARNING_TEXT 11518
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 11519
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_APP 11520
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 11521
#define IDS_EXTENSION_INSTALL_PROMPT_ASK_A_PARENT_BUTTON 11522
#define IDS_EXTENSION_INSTALL_BLOCKED_BY_PARENT_PROMPT_TITLE 11523
#define IDS_EXTENSION_ENABLE_BLOCKED_BY_PARENT_PROMPT_TITLE 11524
#define IDS_PARENT_PERMISSION_PROMPT_GO_GET_A_PARENT_FOR_EXTENSION_LABEL 11525
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_EXTENSION 11526
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_APP 11527
#define IDS_PARENT_PERMISSION_PROMPT_CHILD_WANTS_TO_INSTALL_LABEL 11528
#define IDS_PARENT_PERMISSION_PROMPT_APPROVE_BUTTON 11529
#define IDS_PARENT_PERMISSION_PROMPT_CANCEL_BUTTON 11530
#define IDS_PARENT_PERMISSION_PROMPT_SELECT_PARENT_LABEL 11531
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_LABEL 11532
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_VERIFY_LABEL 11533
#define IDS_PARENT_PROMPT_ENTER_PASSWORD_TO_ALLOW_EXTENSION_LABEL 11534
#define IDS_SKIP_PARENT_PERMISSION_EXTENSION_INFORMATION 11535
#define IDS_PARENT_PERMISSION_PROMPT_ENTER_PASSWORD_LABEL 11536
#define IDS_PARENT_PERMISSION_PROMPT_PASSWORD_INCORRECT_LABEL 11537
#define IDS_EXTENSION_INSTALL_PROMPT_REQUEST_BUTTON 11538
#define IDS_EXTENSION_PROMPT_UNINSTALL_BUTTON 11539
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE 11540
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE_FROM_EXTENSION 11541
#define IDS_EXTENSION_PROMPT_UNINSTALL_TITLE 11542
#define IDS_EXTENSION_PROMPT_UNINSTALL_APP_BUTTON 11543
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_NAME_BULLET_POINT 11544
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_TITLE 11545
#define IDS_EXTENSION_PROMPT_UNINSTALL_TRIGGERED_BY_EXTENSION 11546
#define IDS_EXTENSION_PROMPT_RE_ENABLE_BUTTON 11547
#define IDS_EXTENSION_PROMPT_PERMISSIONS_BUTTON 11548
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ACCEPT_BUTTON 11549
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ABORT_BUTTON 11550
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_EXTENSION 11551
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_APP 11552
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_EXTENSION 11553
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_APP 11554
#define IDS_EXTENSION_WEB_STORE_TITLE 11555
#define IDS_EXTENSION_WEB_STORE_TITLE_SHORT 478
#define IDS_EXTENSIONS_SHOW_DETAILS 11556
#define IDS_EXTENSIONS_HIDE_DETAILS 11557
#define IDS_WEBSTORE_DOWNLOAD_ACCESS_DENIED 11558
#define IDS_EXTENSION_WARNINGS_WRENCH_MENU_ITEM 11559
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_EXTENSION 11560
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_APP 11561
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_THEME 11562
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_TITLE 11563
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_APP 11564
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_EXTENSION 11565
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_THEME 11566
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE 11567
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE_LEARN_MORE 11568
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_KEEP_DIALOG_TITLE 11569
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_KEEP_DIALOG_OK_BUTTON 11570
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_TITLE 11571
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_PLURAL_TITLE 11572
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_OK_BUTTON 11573
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_CANCEL_BUTTON 11574
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_REENABLE_DIALOG_TITLE 11575
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_REENABLE_DIALOG_OK_BUTTON 11576
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_CHANGE_IT_BACK 11577
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_KEEP_IT 11578
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_GENERIC 11579
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 11580
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_BODY_GENERIC 11581
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_GENERIC 11582
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 11583
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_OTHER 11584
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_BODY_GENERIC 11585
#define IDS_FORCE_INSTALLED_DEPRECATED_APPS_CONTENT 11586
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_TITLE 11587
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_CONTENT 11588
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_GO_TO_SITE_BUTTON 11589
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_PLURAL 11590
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_WITH_APP_NAME 11591
#define IDS_DEPRECATED_APPS_MONITOR_RENDERER 11592
#define IDS_DEPRECATED_APPS_LEARN_MORE 11593
#define IDS_DEPRECATED_APPS_LEARN_MORE_AX_LABEL 11594
#define IDS_DEPRECATED_APPS_DELETION_LINK 11595
#define IDS_DEPRECATED_APPS_OK_LABEL 11596
#define IDS_DEPRECATED_APPS_CANCEL_LABEL 11597
#define IDS_EXTENSIONS_MENU_TITLE 11598
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP 11599
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP_ACCESSIBLE_NAME 11600
#define IDS_EXTENSIONS_MENU_PIN_BUTTON_TOOLTIP 11601
#define IDS_EXTENSIONS_MENU_UNPIN_BUTTON_TOOLTIP 11602
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA_SHORT 11603
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA 11604
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA_SHORT 11605
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA 11606
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA_SHORT 11607
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA 11608
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_LABEL 11609
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_NOT_ALLOWED_LABEL 11610
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ON_TOOLTIP 11611
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_OFF_TOOLTIP 11612
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ACCESSIBLE_NAME 11613
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_ENTERPRISE_TOOLTIP_ICON_TEXT 11614
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_DESCRIPTION_TEXT 11615
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TEXT 11616
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TOOLTIP 11617
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_TITLE 11618
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TEXT 11619
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TOOLTIP 11620
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_ACCESSIBLE_NAME 11621
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TEXT 11622
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TOOLTIP 11623
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_ACCESSIBLE_NAME 11624
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ON_TOOLTIP 11625
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_OFF_TOOLTIP 11626
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ACCESSIBLE_NAME 11627
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_TOOLTIP 11628
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_ACCESSIBLE_NAME 11629
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_PINNED_ACCESSIBLE_NAME 11630
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_NONE 11631
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_DISCOVER_EXTENSIONS 11632
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_TOOLTIP 11633
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_ENTERPRISE_EXTENSION_SITE_ACCESS_TOOLTIP 11634
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 11635
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_ENTERPRISE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 11636
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_HAS_ACCESS_TOOLTIP 11637
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_BLOCKED_ACCESS_TOOLTIP 11638
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_REQUESTS_TOOLTIP 11639
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_CLICK 11640
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_SITE 11641
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_ALL_SITES 11642
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON 11643
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON_TOOLTIP 11644
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_LABEL 11645
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_ON 11646
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_OFF 11647
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_LABEL 11648
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_TEXT 11649
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_TEXT 11650
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_TEXT 11651
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_DESCRIPTION 11652
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_DESCRIPTION 11653
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_DESCRIPTION 11654
#define IDS_EXTENSIONS_CONTROLLED_HOME_DIALOG_TITLE 11655
#define IDS_EXTENSIONS_CONTROLLED_HOME_DIALOG_DESCRIPTION 11656
#define IDS_EXTENSIONS_CONTROLLED_HOME_DIALOG_LEARN_MORE_LINK 11657
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_SEARCH_ENGINE 11658
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_TITLE 11659
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_HEADING 11660
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_ALLOW 11661
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_DENY 11662
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_BUBBLE_TITLE 11663
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_BUBBLE_HEADING 11664
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_ALLOW 11665
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_DENY 11666
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_BUBBLE_TITLE 11667
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_BUBBLE_HEADING 11668
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_ALLOW 11669
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_DENY 11670
#define IDS_EXTENSIONS_NTP_CONTROLLED_FIRST_LINE 11671
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE 11672
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE_EXTENSION_SPECIFIC 11673
#define IDS_EXTENSIONS_SETTINGS_API_THIRD_LINE_CONFIRMATION 11674
#define IDS_EXTENSION_CONTROLLED_RESTORE_SETTINGS 11675
#define IDS_EXTENSION_CONTROLLED_KEEP_CHANGES 11676
#define IDS_SUB_APPS_INSTALL_DIALOG_TITLE 11677
#define IDS_SUB_APPS_INSTALL_DIALOG_DESCRIPTION 11678
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_DESCRIPTION 11679
#define IDS_SUB_APPS_INSTALL_DIALOG_MANAGE_PERMISSIONS_LINK 11680
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_BUTTON 11681
#define IDS_SUB_APPS_INSTALL_DIALOG_CANCEL_BUTTON 11682
#define IDS_WEB_APP_MENU_BUTTON_TOOLTIP 11683
#define IDS_WEB_APP_MENU_BUTTON_TOOLTIP_UPDATE_AVAILABLE 11684
#define IDS_WEB_APP_MENU_BUTTON_UPDATE 11685
#define IDS_WEB_APP_ENABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 11686
#define IDS_WEB_APP_DISABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 11687
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_ENABLED_ALERT 11688
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_DISABLED_ALERT 11689
#define IDS_APP_HOME_TITLE 11690
#define IDS_APP_HOME_OPEN_IN_WINDOW 11691
#define IDS_APP_HOME_LAUNCH_AT_STARTUP 11692
#define IDS_APP_HOME_CREATE_SHORTCUT 11693
#define IDS_APP_HOME_INSTALL_LOCALLY 11694
#define IDS_APP_HOME_UNINSTALL_APP 11695
#define IDS_APP_HOME_REMOVE_APP 11696
#define IDS_APP_HOME_APP_SETTINGS 11697
#define IDS_ACCNAME_APP_HOME_NOT_INSTALLED 11698
#define IDS_APP_HOME_APP_NO_APPS 11699
#define IDS_APP_HOME_APP_LEARN_INSTALL 11700
#define IDS_WEB_APP_SETTINGS_TITLE 11701
#define IDS_WEB_APP_SETTINGS_LINK 11702
#define IDS_WEB_APP_SETTINGS_LINK_TOOLTIP 11703
#define IDS_COMPONENTS_TITLE 11704
#define IDS_COMPONENTS_VERSION 11705
#define IDS_COMPONENTS_NONE_INSTALLED 11706
#define IDS_COMPONENTS_NO_COMPONENTS 11707
#define IDS_COMPONENTS_CHECK_FOR_UPDATE 11708
#define IDS_COMPONENTS_STATUS_LABEL 11709
#define IDS_COMPONENTS_CHECKING_LABEL 11710
#define IDS_COMPONENTS_SVC_STATUS_NEW 11711
#define IDS_COMPONENTS_SVC_STATUS_CHECKING 11712
#define IDS_COMPONENTS_SVC_STATUS_UPDATE 11713
#define IDS_COMPONENTS_SVC_STATUS_DNL 11714
#define IDS_COMPONENTS_SVC_STATUS_DECOMPRESSING 11715
#define IDS_COMPONENTS_SVC_STATUS_PATCHING 11716
#define IDS_COMPONENTS_SVC_STATUS_UPDATING 11717
#define IDS_COMPONENTS_SVC_STATUS_UPDATED 11718
#define IDS_COMPONENTS_SVC_STATUS_UPTODATE 11719
#define IDS_COMPONENTS_SVC_STATUS_UPDATE_ERROR 11720
#define IDS_COMPONENTS_UNKNOWN 11721
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_TITLE 11722
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM 11723
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM_WITHOUT_STRONG 11724
#define IDS_PASSWORD_GENERATION_NUDGE_CANCEL_BUTTON 11725
#define IDS_PASSWORD_MANAGER_CONFIRM_SAVED_TITLE 11726
#define IDS_PASSWORD_MANAGER_CONFIRM_UPDATE_TITLE 11727
#define IDS_PASSWORD_GENERATION_EDITING_SUGGESTION 11728
#define IDS_SAVE_PASSWORD 11729
#define IDS_SAVE_ACCOUNT 11730
#define IDS_ADD_USERNAME_TITLE 11731
#define IDS_ADD_USERNAME 11732
#define IDS_ADD_USERNAME_BODY 11733
#define IDS_UPDATE_PASSWORD 11734
#define IDS_VERIFY_IT_IS_YOU 11735
#define IDS_PASSWORD_ERROR_DESCRIPTION_SIGN_IN 11736
#define IDS_PASSWORD_ERROR_DESCRIPTION_SIGN_UP 11737
#define IDS_PASSWORD_ERROR_VERIFY_BUTTON_TITLE 11738
#define IDS_SAVE_PASSWORD_DIFFERENT_DOMAINS_TITLE 11740
#define IDS_UPDATE_PASSWORD_DIFFERENT_DOMAINS_TITLE 11741
#define IDS_SAVE_PASSWORD_FOOTER 11742
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SYNCED_TO_ACCOUNT 11743
#define IDS_PASSWORD_BUBBLES_FOOTER_SYNCED_TO_ACCOUNT 11744
#define IDS_PASSWORD_BUBBLES_FOOTER_SAVING_ON_DEVICE 11745
#define IDS_PASSWORD_GENERATION_PROMPT_GOOGLE_PASSWORD_MANAGER 11746
#define IDS_PASSWORD_GENERATION_NUDGE_TITLE 11747
#define IDS_PASSWORD_MANAGEMENT_BUBBLE_FOOTER_ACCOUNT_STORE_USERS 11748
#define IDS_PASSWORD_MANAGER_GENERATED_PASSWORD_SAVED_MESSAGE_DESCRIPTION 11749
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 11750
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 11751
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_TITLE 11752
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_DESCRIPTION 11753
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_CONFIRM_BUTTON_LABEL 11754
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_WARNING_DESCRIPTION 11755
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_SIGN_IN 11756
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_BUTTON 11757
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORD_BUTTON 11758
#define IDS_SETTINGS_PASSWORDS_ANDROID_APP 11759
#define IDS_SHARED_PASSWORDS_NOTIFICATION_GOT_IT_BUTTON 11760
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_SINGLE_PASSWORD 11761
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_MULTIPLE_PASSWORD 11762
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TITLE 11763
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_A 11764
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_B 11765
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_C 11766
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_A 11767
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_B 11768
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SIGNIN_MESSAGE 11769
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SYNC_MESSAGE 11770
#define IDS_WEBRTC_LOGS_TITLE 11771
#define IDS_WEBRTC_TEXT_LOGS_LOG_COUNT_BANNER_FORMAT 11772
#define IDS_WEBRTC_EVENT_LOGS_LOG_COUNT_BANNER_FORMAT 11773
#define IDS_WEBRTC_LOGS_LOG_HEADER_FORMAT 11774
#define IDS_WEBRTC_LOGS_LOG_LOCAL_FILE_LABEL_FORMAT 11775
#define IDS_WEBRTC_LOGS_NO_LOCAL_LOG_FILE_MESSAGE 11776
#define IDS_WEBRTC_LOGS_LOG_UPLOAD_TIME_FORMAT 11777
#define IDS_WEBRTC_LOGS_LOG_FAILED_UPLOAD_TIME_FORMAT 11778
#define IDS_WEBRTC_LOGS_LOG_REPORT_ID_FORMAT 11779
#define IDS_WEBRTC_LOGS_BUG_LINK_LABEL 11780
#define IDS_WEBRTC_LOGS_LOG_PENDING_MESSAGE 11781
#define IDS_WEBRTC_LOGS_LOG_ACTIVELY_UPLOADED_MESSAGE 11782
#define IDS_WEBRTC_LOGS_LOG_NOT_UPLOADED_MESSAGE 11783
#define IDS_WEBRTC_LOGS_EVENT_LOG_LOCAL_LOG_ID 11784
#define IDS_WEBRTC_LOGS_NO_TEXT_LOGS_MESSAGE 11785
#define IDS_WEBRTC_LOGS_NO_EVENT_LOGS_MESSAGE 11786
#define IDS_PLUGIN_HIDE 11787
#define IDS_PLUGIN_BLOCKED 11788
#define IDS_PLUGIN_BLOCKED_BY_POLICY 11789
#define IDS_PLUGIN_NOT_AUTHORIZED 11790
#define IDS_PLUGIN_DISABLED 11791
#define IDS_PLUGIN_DEPRECATED 11792
#define IDS_SESSION_CRASHED_BUBBLE_TITLE 11793
#define IDS_SESSION_CRASHED_BUBBLE_UMA_LINK_TEXT 11794
#define IDS_IDLE_BUBBLE_TITLE_CLEAR 11795
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_TITLE 11796
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_MESSAGE 11797
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_BUTTON_LABEL 11798
#define IDS_BAD_FLAGS_WARNING_MESSAGE 11799
#define IDS_BAD_FEATURES_WARNING_MESSAGE 11800
#define IDS_BAD_ENVIRONMENT_VARIABLES_WARNING_MESSAGE 11801
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT_TITLE 11802
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT 11803
#define IDS_ALLOW_INSECURE_CONTENT_BUTTON 11804
#define IDS_ADD_TO_SHELF_INFOBAR_TITLE 11805
#define IDS_ADD_TO_SHELF_INFOBAR_ADD_BUTTON 11806
#define IDS_ABOUT_SYS_TITLE 11807
#define IDS_ABOUT_SYS_DESC 11808
#define IDS_ABOUT_SYS_TABLE_TITLE 11809
#define IDS_ABOUT_SYS_LOG_FILE_TABLE_TITLE 11810
#define IDS_ABOUT_SYS_EXPAND_ALL 11811
#define IDS_ABOUT_SYS_COLLAPSE_ALL 11812
#define IDS_ABOUT_SYS_EXPAND 11813
#define IDS_ABOUT_SYS_COLLAPSE 11814
#define IDS_ABOUT_SYS_PARSE_ERROR 11815
#define IDS_ABOUT_BROWSER_SWITCH_TITLE 11816
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_UNKNOWN_BROWSER 11817
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_KNOWN_BROWSER 11818
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_UNKNOWN_BROWSER 11819
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_KNOWN_BROWSER 11820
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_UNKNOWN_BROWSER 11821
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_KNOWN_BROWSER 11822
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_UNKNOWN_BROWSER 11823
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_KNOWN_BROWSER 11824
#define IDS_ABOUT_BROWSER_SWITCH_PROTOCOL_ERROR 11825
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_DESC 11826
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_TITLE 11827
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_NOTHING_SHOWN 11828
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_LBS_DISABLED 11829
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_TITLE 11830
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_DESC 11831
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER 11832
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_PROTOCOL_REASON 11833
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_RULE_REASON 11834
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_INVERT_RULE_REASON 11835
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_DEFAULT_REASON 11836
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_INVALID_URL 11837
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_TITLE 11838
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_DESC 11839
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SOURCE 11840
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_NOT_CONFIGURED 11841
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NOT_FETCHED 11842
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_DOWNLOAD_BUTTON 11843
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_LAST_DOWNLOAD_DATE 11844
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NEXT_DOWNLOAD_DATE 11845
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_TITLE 11846
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_DESCRIPTION 11847
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_FIRST_PARAGRAPH 11848
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_SECOND_PARAGRAPH 11849
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_RULE 11850
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_OPENS_IN 11851
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_SOURCE 11852
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TITLE 11853
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_DESCRIPTION 11854
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_FIRST_PARAGRAPH 11855
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_SECOND_PARAGRAPH 11856
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_RULE 11857
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_SOURCE 11858
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_POLICIES_DOWNLOAD_BUTTON 11859
#define IDS_ABOUT_BOX_ERROR_DURING_UPDATE_CHECK 11860
#define IDS_ABOUT_BOX_GOOGLE_UPDATE_ERROR 11861
#define IDS_ABOUT_BOX_ERROR_UPDATE_CHECK_FAILED 11862
#define IDS_ABOUT_BOX_EXTERNAL_UPDATE_IS_RUNNING 11863
#define IDS_OMNIBOX_PLACEHOLDER_TEXT 440
#define IDS_OMNIBOX_AIM_PLACEHOLDER_TEXT 11864
#define IDS_PASTE_AND_GO 11865
#define IDS_PASTE_AND_SEARCH 11866
#define IDS_PASTE_AND_GO_EMPTY 11867
#define IDS_OMNIBOX_KEYWORD_TEXT 11868
#define IDS_OMNIBOX_KEYWORD_TEXT_MD 11869
#define IDS_OMNIBOX_CLEAR_ALL 470
#define IDS_OMNIBOX_WHY_THIS_SUGGESTION 11870
#define IDS_OMNIBOX_CLOSE_IPH_SUGGESTION 11871
#define IDS_OMNIBOX_THUMBS_UP_SUGGESTION 11872
#define IDS_OMNIBOX_THUMBS_DOWN_SUGGESTION 11873
#define IDS_OMNIBOX_REMOVE_SUGGESTION 668
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_TITLE 11874
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_DESCRIPTION 11875
#define IDS_CONTEXT_MENU_SHOW_FULL_URLS 11876
#define IDS_CONTEXT_MENU_SHOW_SEARCH_TOOLS 11877
#define IDS_WEBUI_OMNIBOX_PLACEHOLDER_TEXT 11878
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MD 671
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_SHORT 11879
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MULTIMODAL 11880
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_CONTEXTUAL 11881
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_CONTEXTUAL_PDF 11882
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_PRIMARY 11883
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_PRIMARY_PDF 11884
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_SECONDARY 11885
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_ERROR_TEXT 11886
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_PRIMARY_ALT 11887
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_NO_SUGGEST_TEXT 11888
#define IDS_GOOGLE_SEARCH_BOX_MULTIMODAL_IMAGE_THUMBNAIL 11889
#define IDS_GOOGLE_LENS_SEARCH_BOX_EMPTY_HINT 11890
#define IDS_NTP_SEARCH_BOX_DYNAMIC_PLACEHOLDER_ASK_GOOGLE 11891
#define IDS_NTP_SEARCH_BOX_DYNAMIC_PLACEHOLDER_PLAN 11892
#define IDS_NTP_SEARCH_BOX_DYNAMIC_PLACEHOLDER_COMPARE 11893
#define IDS_NTP_SEARCH_BOX_DYNAMIC_PLACEHOLDER_RESEARCH 11894
#define IDS_NTP_SEARCH_BOX_DYNAMIC_PLACEHOLDER_TEACH 11895
#define IDS_NTP_SEARCH_BOX_DYNAMIC_PLACEHOLDER_WRITE 11896
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TOOLTIP 11897
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TITLE 487
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT_TOOLTIP 11898
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT 488
#define IDS_NTP_CUSTOM_LINKS_SHORTCUT_DETAILS_TITLE 11899
#define IDS_NTP_CUSTOM_LINKS_MORE_ACTIONS 11900
#define IDS_NTP_ENTERPRISE_SHORTCUT_SUBTITLE 11901
#define IDS_UPLOAD_IMAGE_FORMAT 11902
#define IDS_NTP_CUSTOM_LINKS_NAME 499
#define IDS_NTP_CUSTOM_LINKS_URL 503
#define IDS_NTP_CUSTOM_LINKS_REMOVE 496
#define IDS_NTP_CUSTOM_LINKS_CANCEL 491
#define IDS_NTP_CUSTOM_LINKS_DONE 494
#define IDS_NTP_CUSTOM_LINKS_DETAILS 11903
#define IDS_NTP_CUSTOM_LINKS_INVALID_URL 489
#define IDS_NTP_CUSTOM_LINKS_CANT_CREATE 492
#define IDS_NTP_CUSTOM_LINKS_CANT_EDIT 493
#define IDS_NTP_CUSTOM_LINKS_CANT_REMOVE 11904
#define IDS_NTP_CUSTOM_LINKS_HELP_PIN 11905
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_REMOVED 497
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_EDITED 495
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_ADDED 490
#define IDS_NTP_CUSTOM_LINKS_ALREADY_EXISTS 502
#define IDS_NTP_CONFIRM_MSG_RESTORE_DEFAULTS 500
#define IDS_NTP_CONFIRM_MSG_RESTORE_ENTERPRISE_DEFAULTS 11906
#define IDS_NTP_CUSTOM_BG_CHROME_WALLPAPERS 11907
#define IDS_NTP_CUSTOM_BG_UPLOAD_AN_IMAGE 11908
#define IDS_NTP_CUSTOM_BG_SELECT_A_COLLECTION 11909
#define IDS_NTP_CUSTOM_BG_DAILY_REFRESH 518
#define IDS_NTP_CUSTOM_BG_RESTORE_DEFAULT 11910
#define IDS_NTP_CUSTOM_BG_CANCEL 11911
#define IDS_NTP_CONNECTION_ERROR_NO_PERIOD 11912
#define IDS_NTP_CONNECTION_ERROR 11913
#define IDS_NTP_ERROR_MORE_INFO 11914
#define IDS_NTP_CUSTOM_BG_BACKGROUNDS_UNAVAILABLE 11915
#define IDS_NTP_CUSTOM_BG_BACK_LABEL 11916
#define IDS_NTP_CUSTOM_BG_IMAGE_SELECTED 11917
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_LABEL 509
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_WALLPAPER_SEARCH_LABEL 11918
#define IDS_NTP_DISMISS 11919
#define IDS_NTP_DISMISS_PROMO 11920
#define IDS_NTP_DOODLE_SHARE_LABEL 566
#define IDS_NTP_DOODLE_SHARE_DIALOG_CLOSE_LABEL 11921
#define IDS_NTP_DOODLE_SHARE_DIALOG_FACEBOOK_LABEL 565
#define IDS_NTP_DOODLE_SHARE_DIALOG_TWITTER_LABEL 567
#define IDS_NTP_DOODLE_SHARE_DIALOG_MAIL_LABEL 564
#define IDS_NTP_DOODLE_SHARE_DIALOG_COPY_LABEL 562
#define IDS_NTP_DOODLE_SHARE_DIALOG_LINK_LABEL 563
#define IDS_NTP_CUSTOMIZE_APPEARANCE_LABEL 11922
#define IDS_NTP_CUSTOMIZE_THEMES_HEADER 11923
#define IDS_NTP_CUSTOMIZE_MENU_SHORTCUTS_LABEL 520
#define IDS_NTP_CUSTOMIZE_MENU_TOOLBAR_LABEL 11924
#define IDS_NTP_CUSTOMIZE_MENU_EXTENSIONS_LABEL 11925
#define IDS_NTP_CUSTOMIZE_MENU_MODULES_LABEL 521
#define IDS_NTP_CUSTOMIZE_NO_BACKGROUND_LABEL 517
#define IDS_NTP_CUSTOMIZE_CHROME_CHANGE_THEME_LABEL 11926
#define IDS_NTP_CUSTOMIZE_FOOTER_HEADER 11927
#define IDS_NTP_CUSTOMIZE_TOOLS_HEADER 11928
#define IDS_NTP_MANAGED_BY_SEARCH_ENGINE 11929
#define IDS_NTP_MANAGED_BY_EXTENSION 11930
#define IDS_NTP_CUSTOMIZE_CHROME_MANAGED_NEW_TAB_PAGE_ACCESSIBILITY 11931
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_CLASSIC_CHROME_LABEL 11932
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_CLASSIC_CHROME_COMPLETE 11933
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_UPLOADED_IMAGE_COMPLETE 11934
#define IDS_NTP_CUSTOMIZE_CHROME_FOLLOW_THEME_LABEL 11935
#define IDS_NTP_CUSTOMIZE_UPLOADED_IMAGE_LABEL 11936
#define IDS_NTP_CUSTOMIZE_YOUR_UPLOADED_IMAGE_LABEL 11937
#define IDS_NTP_CUSTOMIZE_YOUR_SEARCHED_IMAGE_LABEL 11938
#define IDS_NTP_CUSTOMIZE_CHROME_CURRENT_THEME_LABEL 11939
#define IDS_NTP_CUSTOMIZE_SHOW_CARDS_LABEL 11940
#define IDS_NTP_CUSTOMIZE_SHOW_FOOTER_LABEL 11941
#define IDS_NTP_CUSTOMIZE_SHOW_CHIPS_LABEL 11942
#define IDS_NTP_CUSTOMIZE_SHOW_SHORTCUTS_LABEL 11943
#define IDS_NTP_CUSTOMIZE_SHOW_PERSONAL_SHORTCUTS_LABEL 11944
#define IDS_NTP_CUSTOMIZE_SHOW_PERSONAL_SHORTCUTS_DESC 11945
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_LABEL 516
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_LABEL 515
#define IDS_NTP_CUSTOMIZE_ENTERPRISE_SHORTCUTS_LABEL 11946
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_DESC 522
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_DESC 519
#define IDS_NTP_CUSTOMIZE_ENTERPRISE_SHORTCUTS_DESC 11947
#define IDS_NTP_CUSTOMIZE_COLOR_PICKER_LABEL 506
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_TITLE 11948
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_ARIA_LABEL 11949
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_DELETE_TITLE 11950
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_DELETE_A11Y_LABEL 11951
#define IDS_NTP_THEME_MANAGED_DIALOG_TITLE 569
#define IDS_NTP_THEME_MANAGED_DIALOG_BODY 570
#define IDS_NTP_THEMES_CONTAINER_LABEL 523
#define IDS_NTP_CUSTOMIZE_DEFAULT_LABEL 510
#define IDS_NTP_CUSTOMIZE_GREY_DEFAULT_LABEL 11952
#define IDS_NTP_COLORS_WARM_GREY 11953
#define IDS_NTP_COLORS_COOL_GREY 11954
#define IDS_NTP_COLORS_MIDNIGHT_BLUE 11955
#define IDS_NTP_COLORS_BLACK 11956
#define IDS_NTP_COLORS_BEIGE_AND_WHITE 11957
#define IDS_NTP_COLORS_YELLOW_AND_WHITE 11958
#define IDS_NTP_COLORS_GREEN_AND_WHITE 11959
#define IDS_NTP_COLORS_LIGHT_TEAL_AND_WHITE 11960
#define IDS_NTP_COLORS_LIGHT_PURPLE_AND_WHITE 11961
#define IDS_NTP_COLORS_PINK_AND_WHITE 11962
#define IDS_NTP_COLORS_BEIGE 11963
#define IDS_NTP_COLORS_ORANGE 11964
#define IDS_NTP_COLORS_LIGHT_GREEN 11965
#define IDS_NTP_COLORS_LIGHT_TEAL 11966
#define IDS_NTP_COLORS_LIGHT_BLUE 11967
#define IDS_NTP_COLORS_PINK 11968
#define IDS_NTP_COLORS_DARK_PINK_AND_RED 11969
#define IDS_NTP_COLORS_DARK_RED_AND_ORANGE 11970
#define IDS_NTP_COLORS_DARK_GREEN 11971
#define IDS_NTP_COLORS_DARK_TEAL 11972
#define IDS_NTP_COLORS_DARK_BLUE 11973
#define IDS_NTP_COLORS_DARK_PURPLE 11974
#define IDS_NTP_COLORS_BLUE 11975
#define IDS_NTP_COLORS_GREY 11976
#define IDS_NTP_COLORS_AQUA 11977
#define IDS_NTP_COLORS_GREEN 11978
#define IDS_NTP_COLORS_VIRIDIAN 11979
#define IDS_NTP_COLORS_CITRON 11980
#define IDS_NTP_COLORS_APRICOT 11981
#define IDS_NTP_COLORS_ROSE 11982
#define IDS_NTP_COLORS_FUCHSIA 11983
#define IDS_NTP_COLORS_VIOLET 11984
#define IDS_NTP_COLORS_BATCH_UPLOAD_DESCRIPTION 11985
#define IDS_NTP_UNDO_DISMISS_PROMO_BUTTON_TOAST 660
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_GROUP_LABEL 11986
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_LIGHT_LABEL 11987
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_DARK_LABEL 11988
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_SYSTEM_LABEL 11989
#define IDS_NTP_CUSTOMIZE_CHROME_WEBSTORE_LABEL 11990
#define IDS_NTP_SHOW_MORE_BUTTON_LABEL 11991
#define IDS_NTP_SHOW_LESS_BUTTON_LABEL 11992
#define IDS_NTP_WEBSTORE_SHOPPING_CATEOGRY_LABEL 11993
#define IDS_NTP_WEBSTORE_WRITTING_HELP_COLLECTION_LABEL 11994
#define IDS_NTP_WEBSTORE_PRODUCTIVITY_CATEOGRY_LABEL 11995
#define IDS_NTP_WEBSTORE_TOAST_MESSAGE 11996
#define IDS_NTP_WEBSTORE_TOAST_BUTTON_TEXT 11997
#define IDS_NTP_WALLPAPER_SEARCH_FEEDBACK_PLACEHOLDER 11998
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION 11999
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_HISTORY 12000
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_INSPIRATION 12001
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_HISTORY_AND_INSPIRATION 12002
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_TITLE 12003
#define IDS_NTP_WALLPAPER_SEARCH_TILE_LABEL 12004
#define IDS_NTP_WALLPAPER_SEARCH_PAGE_HEADER 12005
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_HEADER 12006
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_DESCRIPTION 12007
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_DESCRIPTION_WITH_HISTORY 12008
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_TITLE 12009
#define IDS_NTP_WALLPAPER_SEARCH_OPTIONAL_DETAILS_LABEL 12010
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_RED_LABEL 12011
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_BLUE_LABEL 12012
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_YELLOW_LABEL 12013
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_GREEN_LABEL 12014
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_BLACK_LABEL 12015
#define IDS_NTP_WALLPAPER_SEARCH_REQUEST_THROTTLED_DESCRIPTION 12016
#define IDS_NTP_WALLPAPER_SEARCH_REQUEST_THROTTLED_TITLE 12017
#define IDS_NTP_WALLPAPER_SEARCH_SUBMIT_BTN_TEXT 12018
#define IDS_NTP_WALLPAPER_SEARCH_TRY_AGAIN_CTA 12019
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_NO_DESCRIPTOR 12020
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL 12021
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTOR_B 12022
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTOR_C 12023
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTORS_B_AND_C 12024
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL 12025
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTOR_B 12026
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTOR_C 12027
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTORS_B_AND_C 12028
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LABEL 12029
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_DEFAULT_OPTION_LABEL 12030
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_LABEL 12031
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DEFAULT_OPTION_LABEL 12032
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_LABEL 12033
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_DEFAULT_OPTION_LABEL 12034
#define IDS_LEARN_MORE_ABOUT_FEATURE_A11Y_LABEL 12035
#define IDS_THUMBS_DOWN_OPENS_FEEDBACK_FORM_A11Y_LABEL 12036
#define IDS_THUMBS_UP_RESULTS_A11Y_LABEL 12037
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_HEADER 12038
#define IDS_NTP_WALLPAPER_SEARCH_LOADING_A11Y_MESSAGE 12039
#define IDS_NTP_WALLPAPER_SEARCH_SUCCESS_A11Y_MESSAGE 12040
#define IDS_NTP_WALLPAPER_SEARCH_DISCLAIMER 12041
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_CARD_TOGGLE_TITLE 12042
#define IDS_NTP_WALLPAPER_SEARCH_DESCRIPTORS_CHANGED_A11Y_MESSAGE 12043
#define IDS_NTP_WALLPAPER_SEARCH_SIGNED_OUT_DESCRIPTION 12044
#define IDS_NTP_WALLPAPER_SEARCH_SIGNED_OUT_TITLE 12045
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_DESSERTS 12046
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_INTERIORS 12047
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_LANDSCAPE 12048
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_NATURE 12049
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_OUTER_SPACE 12050
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_PLACES 12051
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_STRUCTURES 12052
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CAKE_POPS 12053
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CHEESECAKE 12054
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_FRUIT_TART 12055
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ICE_CREAM 12056
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MACARON 12057
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PANNA_COTTA 12058
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CHEMISTRY_LAB 12059
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HALLWAY 12060
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_KITCHEN 12061
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LIVING_ROOM 12062
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_READING_NOOK 12063
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_DESERT 12064
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_FOREST 12065
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HIGHLANDS 12066
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MEADOW 12067
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MOUNTAIN 12068
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_OCEAN 12069
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RAINFOREST 12070
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RICE_PADDY 12071
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SALT_FLAT 12072
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SHORELINE 12073
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_TUNDRA 12074
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_WATERFALL 12075
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_AURORA_BOREALIS 12076
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CLIFF 12077
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CRASHING_WAVES 12078
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CREEK 12079
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ECLIPSES 12080
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_FLOWERS 12081
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LIGHTNING 12082
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_NIGHT_SKY 12083
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PALM_TREE 12084
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RAINBOW 12085
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RIVER 12086
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SLOT_CANYON 12087
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SUNSET 12088
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ASTEROID 12089
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_COMET 12090
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MOON 12091
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_NEBULA 12092
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PLANET 12093
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SPACE_STATION 12094
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_STARS 12095
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CHICHEN_ITZA 12096
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_GRAND_CANYON 12097
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_GRAND_TETON_NATIONAL_PARK 12098
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_GREAT_PYRAMID_OF_GIZA 12099
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ROCKY_MOUNTAINS_NATIONAL_PARK 12100
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_THE_COLOSSEUM 12101
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ZION_NATIONAL_PARK 12102
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_BRICK_BUILDING 12103
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CASTLE 12104
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HIGHWAY 12105
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HOUSE 12106
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LIGHTHOUSE 12107
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PIER 12108
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_ANIMATED 12109
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_COLORED_PENCIL 12110
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_CYBERPUNK 12111
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_DREAM 12112
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_EXPRESSIONISM 12113
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_FANTASY 12114
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_IMPRESSIONISM 12115
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_OIL_PAINTING 12116
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_ORGANIC 12117
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_PHOTOGRAPHY 12118
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_SPLATTER 12119
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_STEAMPUNK 12120
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_WATERCOLOR 12121
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_CHAOTIC 12122
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_CREATIVE 12123
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DARK 12124
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DREAMY 12125
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_EXCITED 12126
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_HAPPY 12127
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_INTELLECTUAL 12128
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_ORDERLY 12129
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_ROMANTIC 12130
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SERENE 12131
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SNOWY 12132
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SUBDUED 12133
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SUNNY 12134
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_THOUGHTFUL 12135
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_WHIMSICAL 12136
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_WILD 12137
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_1 12138
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_2 12139
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_3 12140
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_4 12141
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_5 12142
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_6 12143
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_7 12144
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_8 12145
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_9 12146
#define IDS_NTP_WALLPAPER_SEARCH_SEPARATOR 12147
#define IDS_NTP_CUSTOMIZE_TOOLBAR_BUTTON_A11Y_LABEL 12148
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CHOOSE_ICONS_LABEL 12149
#define IDS_NTP_CUSTOMIZE_TOOLBAR_ENTERPRISE_ENABLED_LABEL 12150
#define IDS_NTP_CUSTOMIZE_TOOLBAR_REORDER_TIP_LABEL 12151
#define IDS_NTP_CUSTOMIZE_TOOLBAR_RESET_TO_DEFAULT_ANNOUNCEMENT 12152
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_NAVIGATION 12153
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_YOUR_CHROME 12154
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_SIDE_PANELS 12155
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_TOOLS_AND_ACTIONS 12156
#define IDS_NTP_CUSTOMIZE_TOOLBAR_RESET_TO_DEFAULT_BUTTON_LABEL 12157
#define IDS_NTP_COMPOSE_ENTRYPOINT 12158
#define IDS_NTP_COMPOSE_ENTRYPOINT_A11Y_LABEL 12159
#define IDS_NTP_COMPOSE_PLACEHOLDER_TEXT 12160
#define IDS_NTP_COMPOSE_CANCEL_BUTTON_A11Y_LABEL 12161
#define IDS_NTP_COMPOSE_CANCEL_BUTTON_A11Y_LABEL_INPUT 12162
#define IDS_NTP_COMPOSE_IMAGE_UPLOAD_BUTTON_A11Y_LABEL 12163
#define IDS_NTP_COMPOSE_PDF_UPLOAD_BUTTON_A11Y_LABEL 12164
#define IDS_NTP_COMPOSE_SUBMIT_BUTTON_A11Y_LABEL 12165
#define IDS_NTP_COMPOSE_DELETE_FILE_A11Y_LABEL 12166
#define IDS_NTP_COMPOSE_FILE_UPLOAD_STARTED_A11Y_TEXT 12167
#define IDS_NTP_COMPOSE_FILE_UPLOAD_COMPLETE_A11Y_TEXT 12168
#define IDS_NTP_COMPOSE_FILE_UPLOAD_INVALID_EMPTY_SIZE 12169
#define IDS_NTP_COMPOSE_FILE_UPLOAD_INVALID_TOO_LARGE 12170
#define IDS_NTP_COMPOSE_FILE_UPLOAD_IMAGE_PROCESSING_ERROR 12171
#define IDS_NTP_COMPOSE_FILE_UPLOAD_VALIDATION_FAILED 12172
#define IDS_NTP_COMPOSE_DRAG_AND_DROP_HINT 12173
#define IDS_NTP_COMPOSE_MAX_FILES_REACHED_ERROR 12174
#define IDS_NTP_COMPOSE_FILE_TYPE_NOT_ALLOWED_ERROR 12175
#define IDS_NTP_COMPOSE_FILE_UPLOAD_FAILED 12176
#define IDS_NTP_COMPOSE_FILE_UPLOAD_EXPIRED 12177
#define IDS_NTP_COMPOSE_MOST_RECENT_TABS 12178
#define IDS_NTP_COMPOSE_ADD_IMAGE 12179
#define IDS_NTP_COMPOSE_ADD_FILE 12180
#define IDS_NTP_COMPOSE_ADD_CONTEXT 12181
#define IDS_NTP_COMPOSE_ADD_CONTEXT_TITLE 12182
#define IDS_NTP_COMPOSE_SUGGESTIONS_INFO 12183
#define IDS_NTP_COMPOSE_SMART_COMPOSE_A11Y_LABEL 12184
#define IDS_NTP_COMPOSE_SMART_COMPOSE_TAB 12185
#define IDS_NTP_COMPOSE_DEEP_SEARCH 12186
#define IDS_NTP_COMPOSE_ASK_ABOUT_THIS_TAB 12187
#define IDS_NTP_COMPOSE_ASK_ABOUT_THIS_TAB_ARIA_LABEL 12188
#define IDS_NTP_COMPOSE_CREATE_IMAGES 12189
#define IDS_COMPOSE_DEEP_SEARCH_PLACEHOLDER 12190
#define IDS_COMPOSE_CREATE_IMAGE_PLACEHOLDER 12191
#define IDS_NTP_ACTION_CHIP_TAB_HEADING_1 12192
#define IDS_NTP_ACTION_CHIP_TAB_HEADING_2 12193
#define IDS_NTP_ACTION_CHIP_TAB_BODY_1 12194
#define IDS_NTP_ACTION_CHIP_TAB_BODY_2 12195
#define IDS_NTP_ACTION_CHIP_CREATE_IMAGE_HEADING 12196
#define IDS_NTP_ACTION_CHIP_CREATE_IMAGE_BODY_1 12197
#define IDS_NTP_ACTION_CHIP_CREATE_IMAGE_BODY_2 12198
#define IDS_NTP_ACTION_CHIP_DEEP_SEARCH_HEADING 12199
#define IDS_NTP_ACTION_CHIP_DEEP_SEARCH_BODY 12200
#define IDS_COMPOSE_REMOVE_TOOL_CHIP_A11Y_LABEL 12201
#define IDS_NTP_MODULES_SETUP_LIST_DISABLE_TOAST_MESSAGE 12202
#define IDS_NTP_MODULES_SETUP_LIST_DISMISS_TOAST_MESSAGE 12203
#define IDS_NTP_MODULES_SETUP_LIST_INFO 12204
#define IDS_NTP_MODULES_INFO_BUTTON_TITLE 574
#define IDS_NTP_MODULES_DISMISS_TOAST_MESSAGE 572
#define IDS_NTP_MODULES_DISABLE_TOAST_MESSAGE 573
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_MESSAGE 12205
#define IDS_NTP_MODULES_DISMISS_BUTTON_TEXT 575
#define IDS_NTP_MODULES_DRIVE_MORE_ACTIONS_BUTTON_TEXT 12206
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT 576
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT_V2 12207
#define IDS_NTP_MODULES_MORE_ACTIONS 12208
#define IDS_NTP_MODULE_HEADER_MORE_ACTIONS_MENU 12209
#define IDS_NTP_MODULES_CUSTOMIZE_BUTTON_TEXT 577
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_TODAY 12210
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_YESTERDAY 12211
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_WEEK 12212
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_MONTH 12213
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PREVIOUSLY 12214
#define IDS_NTP_MODULES_SHOPPING_TASKS_SENTENCE 12215
#define IDS_NTP_MODULES_SHOPPING_TASKS_LOWER 12216
#define IDS_NTP_MODULES_DRIVE_DISABLE_BUTTON_TEXT 12217
#define IDS_NTP_MODULES_DRIVE_DISABLE_BUTTON_TEXT_V2 12218
#define IDS_NTP_MODULES_DRIVE_NAME 12219
#define IDS_NTP_MODULES_FILES_SENTENCE 12220
#define IDS_NTP_MODULES_DUMMY_LOWER 597
#define IDS_NTP_MODULES_DUMMY_TITLE 600
#define IDS_NTP_MODULES_DRIVE_INFO 599
#define IDS_NTP_MODULES_MICROSOFT_FILES_NAME 12221
#define IDS_NTP_MODULES_MICROSOFT_FILES_INFO 12222
#define IDS_NTP_MODULES_MICROSOFT_FILES_DISABLE_BUTTON_TEXT 12223
#define IDS_NTP_MODULES_MICROSOFT_FILES_TRENDING_JUSTIFICATION_TEXT 12224
#define IDS_NTP_MODULES_MICROSOFT_FILES_OPENED_TODAY_JUSTIFICATION_TEXT 12225
#define IDS_NTP_MODULES_MICROSOFT_FILES_OPENED_YESTERDAY_JUSTIFICATION_TEXT 12226
#define IDS_NTP_MODULES_MICROSOFT_FILES_OPENED_PAST_WEEK_JUSTIFICATION_TEXT 12227
#define IDS_NTP_MODULES_MICROSOFT_FILES_SHARED_BY_JUSTIFICATION_TEXT 12228
#define IDS_NTP_MODULES_DISMISS_FOR_HOURS_BUTTON_TEXT 12229
#define IDS_NTP_MODULES_DISMISS_FOR_DAYS_BUTTON_TEXT 12230
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISMISS_TOAST_MESSAGE 12231
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISABLE_TOAST_MESSAGE 12232
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_INFO 12233
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_MORE_ACTIONS 12234
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_TITLE 12235
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISABLE_BUTTON_TEXT 12236
#define IDS_NTP_MODULES_MICROSOFT_SIGN_OUT_BUTTON_TEXT 12237
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_TITLE 12238
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_DISABLE_BUTTON_TEXT 12239
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_DISMISS_TOAST_MESSAGE 12240
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_INFO 12241
#define IDS_NTP_MODULES_CALENDAR_DOUBLE_BOOKED 12242
#define IDS_NTP_MODULES_CALENDAR_JOIN_MEETING_BUTTON_TEXT 12243
#define IDS_NTP_MODULES_CALENDAR_JOIN_MEETING_BUTTON_ACCNAME 12244
#define IDS_NTP_MODULES_CALENDAR_IN_PROGRESS 12245
#define IDS_NTP_MODULES_CALENDAR_IN_X_MIN 12246
#define IDS_NTP_MODULES_CALENDAR_IN_X_HR 12247
#define IDS_NTP_MODULES_CALENDAR_SEE_MORE 12248
#define IDS_NTP_MODULES_CALENDAR_SEE_MORE_ACCNAME 12249
#define IDS_NTP_MODULES_KALEIDOSCOPE_TITLE 603
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_TITLE 621
#define IDS_NTP_MODULES_TASKS_INFO 586
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_CLOSE 622
#define IDS_NTP_MODULES_SHOPPING_TASKS_RELATED 12250
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_AMOUNT 629
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_UP_TO_AMOUNT 630
#define IDS_NTP_MODULES_CUSTOMIZE_IPH 12251
#define IDS_NTP_MODULES_FEED_TITLE 602
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING 12252
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING_FOR 12253
#define IDS_NTP_MODULES_SHOW_ALL 648
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_BOOKMARKED 654
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_INFO 649
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_WITH_DISCOUNT_INFO 12254
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SENTENCE2 650
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_NAME 12255
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISMISS_BUTTON 12256
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_DROPDOWN_TEXT 12257
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DONE_BUTTON 12258
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_OPEN_ALL_IN_NEW_TAB_GROUP_BUTTON_TEXT 655
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SHOW_ALL_BUTTON 12259
#define IDS_ACCNAME_SHOW_ALL 652
#define IDS_ACCNAME_SEARCH_SUGG 653
#define IDS_NTP_MODULES_TAB_RESUMPTION_DISMISS_BUTTON 12260
#define IDS_NTP_MODULES_TAB_RESUMPTION_INFO 12261
#define IDS_NTP_MODULES_TAB_RESUMPTION_MULTI_DISMISS 12262
#define IDS_NTP_MODULES_TAB_RESUMPTION_SINGLE_DISMISS 12263
#define IDS_NTP_MODULES_TAB_RESUMPTION_RECENTLY_OPENED 12264
#define IDS_NTP_MODULES_TAB_RESUMPTION_DEVICE_PREFIX 12265
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_DISMISS_BUTTON 12266
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_TITLE 12267
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_SEE_MORE 12268
#define IDS_NTP_MODULES_MICROSOFT_AUTHENTICATION_NAME 12269
#define IDS_NTP_MODULES_TAB_GROUPS_DISMISS_TOAST_MESSAGE 12270
#define IDS_NTP_MODULES_TAB_GROUPS_DISABLE_TOAST_MESSAGE 12271
#define IDS_NTP_MODULES_TAB_GROUPS_INFO 12272
#define IDS_NTP_MODULES_TAB_GROUPS_TITLE 12273
#define IDS_NTP_MODULES_TAB_GROUPS_TIME_DELTA 12274
#define IDS_NTP_MODULES_TAB_GROUPS_RECENTLY_USED 12275
#define IDS_NTP_MODULES_TAB_GROUPS_ZERO_STATE_TITLE 12276
#define IDS_NTP_MODULES_TAB_GROUPS_ZERO_STATE_TEXT 12277
#define IDS_NTP_MICROSOFT_AUTHENTICATION_DISABLE_BUTTON_TEXT 12278
#define IDS_NTP_MICROSOFT_AUTHENTICATION_DISMISS_BUTTON_TEXT 12279
#define IDS_NTP_MICROSOFT_AUTHENTICATION_HEADING 12280
#define IDS_NTP_MICROSOFT_AUTHENTICATION_SUBHEADING 12281
#define IDS_NTP_MICROSOFT_AUTHENTICATION_SIGN_IN_BUTTON_TEXT 12282
#define IDS_NTP_MICROSOFT_AUTHENTICATION_SIDE_PANEL_DESCRIPTION 12283
#define IDS_NTP_MOBILE_PROMO_HEADER 12284
#define IDS_NTP_MOBILE_PROMO_DESCRIPTION 12285
#define IDS_NTP_MOBILE_PROMO_QR_CODE_LABEL 12286
#define IDS_EXTENSIONS_PROMO_PERFORMANCE 12287
#define IDS_EXTENSIONS_PROMO_PRIVACY 12288
#define IDS_EXTENSIONS_PROMO_NEUTRAL 12289
#define IDS_NEW_TAB_FOOTER_NAME 12290
#define IDS_OPENS_MANAGEMENT_PAGE 12291
#define IDS_HIDE_NEW_TAB_FOOTER 12292
#define IDS_NEW_TAB_FOOTER_BACKGROUND_ATTRIBUTION_ARIA_DESC 12293
#define IDS_NEW_TAB_FOOTER_BACKGROUND_ATTRIBUTION_TEXT 12294
#define IDS_STAR_VIEW_MENU_ADD_BOOKMARK 12295
#define IDS_STAR_VIEW_MENU_EDIT_BOOKMARK 12296
#define IDS_STAR_VIEW_MENU_MOVE_TO_READ_LATER 12297
#define IDS_STAR_VIEW_MENU_MARK_AS_READ 12298
#define IDS_READ_LATER_TITLE 395
#define IDS_READ_LATER_EXPAND_BUTTON_ARIA_LABEL 12299
#define IDS_READ_LATER_COLLAPSE_BUTTON_ARIA_LABEL 12300
#define IDS_READ_LATER_MENU_UNREAD_HEADER 12301
#define IDS_READ_LATER_MENU_READ_HEADER 12302
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_READ 12303
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_UNREAD 12304
#define IDS_READ_LATER_MENU_EMPTY_STATE_ADD_FROM_DIALOG_SUBHEADER 12305
#define IDS_READ_LATER_MENU_EMPTY_STATE_HEADER 12306
#define IDS_READ_LATER_MENU_EMPTY_STATE_SUBHEADER 12307
#define IDS_READ_LATER_ADD_CURRENT_TAB 12308
#define IDS_READ_LATER_CANT_ADD_CURRENT_TAB 12309
#define IDS_READ_LATER_MARK_CURRENT_TAB_READ 12310
#define IDS_READ_LATER_REMOVE_CURRENT_TAB 12311
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_UNREAD 12312
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_READ 12313
#define IDS_READ_LATER_CONTEXT_MENU_DELETE 12314
#define IDS_READING_LIST_MENU 12315
#define IDS_READING_LIST_MENU_ADD_TAB 12316
#define IDS_READING_LIST_MENU_SHOW_UI 12317
#define IDS_ACCNAME_SIDE_PANEL_RESIZE 12318
#define IDS_ACCNAME_SIDE_PANEL_CLOSE 12319
#define IDS_SIDE_PANEL_RESIZE_ACCESSIBLE_ALERT 12320
#define IDS_SIDE_PANEL_RESIZE_LEFT_SIDE_ACCESSIBLE_ALERT 12321
#define IDS_SIDE_PANEL_RESIZE_RIGHT_SIDE_ACCESSIBLE_ALERT 12322
#define IDS_ACCNAME_SIDE_PANEL_SELECTOR 12323
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_SHOW 12324
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_HIDE 12325
#define IDS_SIDE_PANEL_COMPANION_TITLE 12326
#define IDS_SIDE_PANEL_COMPANION_TOOLBAR_TOOLTIP 12327
#define IDS_SIDE_PANEL_COMPANION_PROMO 12328
#define IDS_SIDE_PANEL_COMPANION_PROMO_PINNING 12329
#define IDS_SIDE_PANEL_COMPANION_PROMO_SCREEN_READER 12330
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_FIRST_LINE 12331
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_SECOND_LINE 12332
#define IDS_SHOW_CUSTOMIZE_CHROME_SIDE_PANEL 12333
#define IDS_SHOW_CUSTOMIZE_CHROME_TOOLBAR 12334
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_UNPIN 12335
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_PIN 12336
#define IDS_SIDE_PANEL_HEADER_UNPIN_BUTTON_TOOLTIP 12337
#define IDS_SIDE_PANEL_HEADER_PIN_BUTTON_TOOLTIP 12338
#define IDS_SIDE_PANEL_UNPINNED 12339
#define IDS_SIDE_PANEL_PINNED 12340
#define IDS_PINNED_ACTION_BUTTON_ACCESSIBLE_TITLE 12341
#define IDS_SIDE_PANEL_GENERIC_PINNABLE_IPH 12342
#define IDS_SIDE_PANEL_GENERIC_PINNABLE_IPH_SCREENREADER 12343
#define IDS_SIDE_PANEL_HEADER_MORE_INFO_BUTTON_TOOLTIP 12344
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_TITLE 12345
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_SUBTITLE 12346
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_FOLDER_SUBTITLE 12347
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_OK_BUTTON_LABEL 12348
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_TITLE 12349
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_SUBTITLE 12350
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_FOLDER_SUBTITLE 12351
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_OK_BUTTON_LABEL 12352
#define IDS_BOOKMARKS_SORT_BY_TYPE 12353
#define IDS_BOOKMARKS_ALL_BOOKMARKS 12354
#define IDS_BOOKMARKS_ALL_BOOKMARKS_OPEN_SIDE_PANEL 12355
#define IDS_BOOKMARKS_ACCOUNT_BOOKMARKS 12356
#define IDS_BOOKMARKS_DEVICE_BOOKMARKS 12357
#define IDS_BOOKMARKS_LABEL_TRACKED_PRODUCTS 12358
#define IDS_BOOKMARKS_SORT_NEWEST 12359
#define IDS_BOOKMARKS_SORT_NEWEST_LOWER 12360
#define IDS_BOOKMARKS_SORT_OLDEST 12361
#define IDS_BOOKMARKS_SORT_OLDEST_LOWER 12362
#define IDS_BOOKMARKS_SORT_ALPHABETICALLY 12363
#define IDS_BOOKMARKS_SORT_REVERSE_ALPHABETICALLY 12364
#define IDS_BOOKMARKS_SORT_LAST_OPENED 12365
#define IDS_BOOKMARKS_SORT_LAST_OPENED_LOWER 12366
#define IDS_BOOKMARKS_VISUAL_VIEW 12367
#define IDS_BOOKMARKS_COMPACT_VIEW 12368
#define IDS_BOOKMARKS_SORT_MENU_A11Y_LABEL 12369
#define IDS_BOOKMARKS_CREATE_NEW_FOLDER_A11Y_LABEL 12370
#define IDS_BOOKMARKS_NEW_FOLDER_TOOLTIP 12371
#define IDS_BOOKMARKS_EDIT_BOOKMARK_LIST_A11Y_LABEL 12372
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE 12373
#define IDS_BOOKMARKS_EMPTY_STATE_BODY 12374
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_FOLDER 12375
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_FOLDER 12376
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_GUEST 12377
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_GUEST 12378
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_SEARCH 12379
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_SEARCH 12380
#define IDS_BOOKMARK_FOLDER_CHILD_COUNT 12381
#define IDS_BOOKMARKS_EDIT_BOOKMARK 12382
#define IDS_BOOKMARKS_EDIT_MOVE_TO_ANOTHER_FOLDER 12383
#define IDS_BOOKMARKS_EDIT_MORE 12384
#define IDS_BOOKMARKS_EDIT_MOVE_TO 12385
#define IDS_BOOKMARKS_EDIT_NEW_FOLDER 12386
#define IDS_BOOKMARKS_EDIT_CANCEL 12387
#define IDS_BOOKMARKS_EDIT_SAVE 12388
#define IDS_BOOKMARKS_EDIT_NAME 12389
#define IDS_BOOKMARKS_EDIT_URL 12390
#define IDS_BOOKMARK_DELETION_COUNT 12391
#define IDS_UNDO_BOOKMARK_DELETION 12392
#define IDS_BOOKMARKS_MOVE_TO_BOOKMARKS_BAR 12393
#define IDS_BOOKMARKS_MOVE_TO_ALL_BOOKMARKS 12394
#define IDS_BOOKMARKS_EDIT 12395
#define IDS_BOOKMARKS_RENAME 12396
#define IDS_BOOKMARKS_URL_FOLDER_DESCRIPTION 12397
#define IDS_BOOKMARKS_DISABLED_FEATURE 12398
#define IDS_BOOKMARKS_BACK_BUTTON_LABEL 12399
#define IDS_BOOKMARKS_BACK_BUTTON_TOOLTIP 12400
#define IDS_BOOKMARKS_FORWARD_BUTTON_LABEL 12401
#define IDS_BOOKMARK_OPTIONS_LABEL 12402
#define IDS_FOLDER_OPTIONS_LABEL 12403
#define IDS_BOOKMARKS_OPEN_FOLDER_LABEL 12404
#define IDS_BOOKMARKS_OPEN_BOOKMARK_LABEL 12405
#define IDS_BOOKMARKS_SELECT_FOLDER_LABEL 12406
#define IDS_BOOKMARKS_SELECT_BOOKMARK_LABEL 12407
#define IDS_BOOKMARKS_DESELECT_FOLDER_LABEL 12408
#define IDS_BOOKMARKS_DESELECT_BOOKMARK_LABEL 12409
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_TRACKING 12410
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_CHANGE 12411
#define IDS_BOOKMARKS_CHECKBOX_LABEL 12412
#define IDS_BOOKMARKS_PRIMARY_FILTER_HEADING 12413
#define IDS_BOOKMARKS_SECONDARY_FILTER_HEADING 12414
#define IDS_SHOW_READING_MODE_SIDE_PANEL 12415
#define IDS_READING_MODE_TITLE 12416
#define IDS_READING_MODE_NOT_SELECTABLE_HEADER 12417
#define IDS_READING_MODE_EMPTY_STATE_HEADER 12418
#define IDS_READING_MODE_EMPTY_STATE_SUBHEADER 12419
#define IDS_READING_MODE_TOOLBAR_LABEL 12420
#define IDS_READING_MODE_READ_ALOUD_TOOLBAR_LABEL 12421
#define IDS_READING_MODE_FONT_SIZE 12422
#define IDS_READING_MODE_FONT_NAME_COMBOBOX_LABEL 12423
#define IDS_READING_MODE_DECREASE_FONT_SIZE_BUTTON_LABEL 12424
#define IDS_READING_MODE_INCREASE_FONT_SIZE_BUTTON_LABEL 12425
#define IDS_READING_MODE_INCREASE_FONT_SIZE_ANNOUNCEMENT 12426
#define IDS_READING_MODE_DECREASE_FONT_SIZE_ANNOUNCEMENT 12427
#define IDS_READING_MODE_DISABLE_LINKS_BUTTON_LABEL 12428
#define IDS_READING_MODE_ENABLE_LINKS_BUTTON_LABEL 12429
#define IDS_READING_MODE_DISABLE_IMAGES_BUTTON_LABEL 12430
#define IDS_READING_MODE_ENABLE_IMAGES_BUTTON_LABEL 12431
#define IDS_READING_MODE_COLORS_COMBOBOX_LABEL 12432
#define IDS_READING_MODE_LINE_SPACING_COMBOBOX_LABEL 12433
#define IDS_READING_MODE_LETTER_SPACING_COMBOBOX_LABEL 12434
#define IDS_READING_MODE_SPACING_COMBOBOX_STANDARD 12435
#define IDS_READING_MODE_SPACING_COMBOBOX_LOOSE 12436
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_LOOSE 12437
#define IDS_READING_MODE_SPACING_COMBOBOX_WIDE 12438
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_WIDE 12439
#define IDS_READING_MODE_DEFAULT_COLOR_LABEL 12440
#define IDS_READING_MODE_LIGHT_COLOR_LABEL 12441
#define IDS_READING_MODE_DARK_COLOR_LABEL 12442
#define IDS_READING_MODE_YELLOW_COLOR_LABEL 12443
#define IDS_READING_MODE_HIGH_CONTRAST_COLOR_LABEL 12444
#define IDS_READING_MODE_LOW_CONTRAST_COLOR_LABEL 12445
#define IDS_READING_MODE_SEPIA_LIGHT_COLOR_LABEL 12446
#define IDS_READING_MODE_SEPIA_DARK_COLOR_LABEL 12447
#define IDS_READING_MODE_BLUE_COLOR_LABEL 12448
#define IDS_READING_MODE_VOICE_HIGHLIGHT 12449
#define IDS_READING_MODE_AUTO_HIGHLIGHT_LABEL 12450
#define IDS_READING_MODE_WORD_HIGHLIGHT_LABEL 12451
#define IDS_READING_MODE_PHRASE_HIGHLIGHT_LABEL 12452
#define IDS_READING_MODE_SENTENCE_HIGHLIGHT_LABEL 12453
#define IDS_READING_MODE_OFF_HIGHLIGHT_LABEL 12454
#define IDS_READ_ANYTHING_LOADING 12455
#define IDS_READING_MODE_FONT_RESET 12456
#define IDS_READING_MODE_FONT_RESET_TOOLTIP 12457
#define IDS_READING_MODE_TURN_HIGHLIGHT_OFF 12458
#define IDS_READING_MODE_TURN_HIGHLIGHT_ON 12459
#define IDS_READING_MODE_PLAY_DESCRIPTION 12460
#define IDS_READING_MODE_PLAY_SPEECH 12461
#define IDS_READING_MODE_PLAY_TOOLTIP 12462
#define IDS_READING_MODE_PREVIEW_TOOLTIP 12463
#define IDS_READING_MODE_PAUSE_TOOLTIP 12464
#define IDS_READING_MODE_STOP_SPEECH 12465
#define IDS_READING_MODE_NAVIGATE_PREVIOUS_SENTENCE 12466
#define IDS_READING_MODE_NAVIGATE_NEXT_SENTENCE 12467
#define IDS_READING_MODE_MORE_OPTIONS 12468
#define IDS_READING_MODE_VOICE_SPEED 12469
#define IDS_READING_MODE_VOICE_SPEED_WITH_RATE 12470
#define IDS_READING_MODE_VOICE_SPEED_OPTION_TITLE 12471
#define IDS_READING_MODE_VOICE_SELECTION 12472
#define IDS_READING_MODE_SYSTEM_VOICE 12473
#define IDS_READING_MODE_ITEM_SELECTED 12474
#define IDS_READING_MODE_LANGUAGE_MENU 12475
#define IDS_READING_MODE_LANGUAGE_MENU_TITLE 12476
#define IDS_READING_MODE_LANGUAGE_MENU_CLOSE 12477
#define IDS_READING_MODE_LANGUAGE_MENU_NO_RESULTS 12478
#define IDS_READING_MODE_LANGUAGE_MENU_SEARCH_LABEL 12479
#define IDS_READING_MODE_LANGUAGE_MENU_SEARCH_CLEAR 12480
#define IDS_READING_MODE_LANGUAGE_MENU_DOWNLOADING 12481
#define IDS_READING_MODE_VOICE_MENU_DOWNLOADING 12482
#define IDS_READING_MODE_LANGUAGE_DOWNLOAD_UNAVAILALBLE 12483
#define IDS_READING_MODE_LANGUAGE_DOWNLOAD_UNAVAILALBLE_LEARN_MORE_LINK 12484
#define IDS_READING_MODE_LANGUAGE_MENU_VOICES_UNAVAILABLE 12485
#define IDS_READING_MODE_LANGUAGE_MENU_NO_INTERNET 12486
#define IDS_READING_MODE_CANT_USE_READ_ALOUD 12487
#define IDS_READING_MODE_VOICE_MENU_NO_INTERNET 12488
#define IDS_READING_MODE_LANGUAGE_MENU_DOWNLOAD_FAILED 12489
#define IDS_READING_MODE_LANGUAGE_MENU_NO_SPACE 12490
#define IDS_READING_MODE_TOAST_NO_SPACE 12491
#define IDS_READING_MODE_VOICE_MENU_NO_SPACE 12492
#define IDS_READING_MODE_VOICE_MENU_PREVIEW_LANGUAGE 12493
#define IDS_READING_MODE_LANGUAGE_MENU_NO_SPACE_BUT_VOICES_EXIST 12494
#define IDS_READING_MODE_LANGUAGE_MENU_ITEM_LABEL 12495
#define IDS_READING_MODE_VOICE_DOWNLOADED_TITLE 12496
#define IDS_READING_MODE_VOICE_DOWNLOADED_MESSAGE 12497
#define IDS_READING_MODE_SIDE_PANEL_PROMO 12498
#define IDS_READING_MODE_SIDE_PANEL_PROMO_PINNING 12499
#define IDS_READING_MODE_VOICE_PREVIEW_STRING 12500
#define IDS_READING_MODE_FONT_LOADING_STRING 12501
#define IDS_GOOGLE_LENS_TITLE 12502
#define IDS_LENS_DEFAULT_TITLE 12503
#define IDS_TOOLTIP_BACK 409
#define IDS_ACCDESCRIPTION_BACK 411
#define IDS_TOOLTIP_CHROMELABS_BUTTON 12504
#define IDS_TOOLTIP_LEFT_ALIGNED_SIDE_PANEL_BUTTON 12505
#define IDS_TOOLTIP_CHROMELABS_COMBOBOX 12506
#define IDS_TOOLTIP_CHROMELABS_FEEDBACK_BUTTON 12507
#define IDS_TOOLTIP_FORWARD 412
#define IDS_ACCDESCRIPTION_FORWARD 414
#define IDS_TOOLTIP_DOWNLOAD_ICON 12508
#define IDS_TOOLTIP_DOWNLOAD_ICON_NEW_DOWNLOAD 12509
#define IDS_TOOLTIP_HOME 419
#define IDS_TOOLTIP_RELOAD 12510
#define IDS_TOOLTIP_RELOAD_WITH_MENU 12511
#define IDS_TOOLTIP_STOP 695
#define IDS_TOOLTIP_EXTENSIONS_BUTTON 421
#define IDS_TOOLTIP_OVERFLOW_BUTTON 12512
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 12513
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 12514
#define IDS_ACC_NAME_EXTENSIONS_BUTTON 12515
#define IDS_ACC_NAME_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 12516
#define IDS_ACC_NAME_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 12517
#define IDS_TOOLTIP_EXTENSIONS_SITE_ACCESS_BUTTON 12518
#define IDS_TOOLTIP_SIDE_PANEL_SHOW 433
#define IDS_TOOLTIP_SIDE_PANEL_HIDE 12519
#define IDS_TOOLTIP_SIDE_PANEL 12520
#define IDS_TOOLTIP_LOCATION_ICON 439
#define IDS_TOOLTIP_NEW_TAB 393
#define IDS_TOOLTIP_TAB_SCROLL_LEADING 12522
#define IDS_TOOLTIP_TAB_SCROLL_TRAILING 12523
#define IDS_TOOLTIP_MIC_SEARCH 541
#define IDS_TOOLTIP_LENS_SEARCH 543
#define IDS_TOOLTIP_LENS_REINVOKE_VISUAL_SELECTION_A11Y_LABEL 12524
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_CLOSE_BUTTON_LABEL 544
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE 545
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE_SHORT 12525
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_TITLE 546
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_UPLOAD_FILE_TITLE 547
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OR_TEXT 548
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TEXT_PLACEHOLDER 549
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_SEARCH_BUTTON_LABEL 550
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_DROP_TITLE 551
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_LOADING_TEXT 552
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_TEXT 553
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_SUBTITLE_TEXT 554
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_BUTTON_LABEL 555
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_TYPE 556
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_SIZE 557
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_FILES 558
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_SCHEME 559
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_CONFORMANCE 560
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_URLS 561
#define IDS_TOOLTIP_SAVE_CREDIT_CARD 461
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_PENDING 12526
#define IDS_TOOLTIP_SAVE_CVC 12527
#define IDS_TOOLTIP_SAVE_IBAN 12528
#define IDS_TOOLTIP_MIGRATE_LOCAL_CARD 462
#define IDS_TOOLTIP_TRANSLATE 455
#define IDS_TOOLTIP_ZOOM 456
#define IDS_TOOLTIP_ZOOM_EXTENSION_ICON 12529
#define IDS_ZOOM_SET_DEFAULT 12530
#define IDS_TOOLTIP_FIND 454
#define IDS_TOOLTIP_TAB_SEARCH 406
#define IDS_DECLUTTER_SELECTOR_HEADING_NO_DEDUPE 12531
#define IDS_DECLUTTER_SELECTOR_HEADING 12532
#define IDS_DECLUTTER_SELECTOR_SUBHEADING 12533
#define IDS_DECLUTTER_TITLE 12534
#define IDS_DECLUTTER_INACTIVE_TITLE_NO_DEDUPE 12535
#define IDS_DECLUTTER_INACTIVE_TITLE 12536
#define IDS_DECLUTTER_INACTIVE_BODY 12537
#define IDS_DECLUTTER_DUPLICATE_TITLE 12538
#define IDS_DECLUTTER_DUPLICATE_BODY 12539
#define IDS_DECLUTTER_EMPTY_TITLE 12540
#define IDS_DECLUTTER_EMPTY_BODY_NO_DEDUPE 12541
#define IDS_DECLUTTER_EMPTY_BODY 12542
#define IDS_DUPLICATE_ITEM_TITLE_SINGLE 12543
#define IDS_DUPLICATE_ITEM_TITLE_MULTI 12544
#define IDS_TOOLTIP_TAB_DECLUTTER_NO_DEDUPE 12545
#define IDS_TAB_DECLUTTER_NO_DEDUPE 12546
#define IDS_ACCNAME_TAB_DECLUTTER_NO_DEDUPE 12547
#define IDS_TOOLTIP_TAB_DECLUTTER 12548
#define IDS_TAB_DECLUTTER 12549
#define IDS_ACCNAME_TAB_DECLUTTER 12550
#define IDS_DECLUTTER_TIMESTAMP 12551
#define IDS_DECLUTTER_MENU_NO_DEDUPE 12552
#define IDS_DECLUTTER_MENU 12553
#define IDS_DECLUTTER_CLOSE_TABS 12554
#define IDS_DECLUTTER_CLOSE_TAB_ARIA_LABEL 12555
#define IDS_DECLUTTER_CLOSE_TAB_TOOLTIP 12556
#define IDS_DECLUTTER_A11Y_TAB_EXCLUDED 12557
#define IDS_TOOLTIP_TAB_ORGANIZE 12558
#define IDS_TAB_ORGANIZE 12559
#define IDS_TOOLTIP_TAB_ORGANIZE_CLOSE 12560
#define IDS_TAB_ORGANIZATION_FEEDBACK_PLACEHOLDER 12561
#define IDS_TAB_ORGANIZE_MENU 12562
#define IDS_TAB_ORGANIZATION_SUCCESS_IPH 12563
#define IDS_TAB_ORGANIZATION_SUCCESS_IPH_SCREENREADER 12564
#define IDS_TAB_ORGANIZATION_SELECTOR_ARIA_LABEL 12565
#define IDS_SPLIT_VIEW_NTP_EMPTY_TITLE 12566
#define IDS_SPLIT_VIEW_NTP_EMPTY_BODY 12567
#define IDS_SPLIT_VIEW_NTP_TITLE 12568
#define IDS_SPLIT_VIEW_NTP_TAB_TITLE 12569
#define IDS_ACCNAME_SPLIT_VIEW_MINI_TOOLBAR_MENU_BUTTON 12570
#define IDS_SPLIT_VIEW_NTP_CLOSE_BUTTON_ARIA_LABEL 12571
#define IDS_SPLIT_VIEW_TITLE_IPH 12572
#define IDS_SPLIT_VIEW_BODY_IPH 12573
#define IDS_SPLIT_VIEW_PIN_ACTION_IPH 12574
#define IDS_SPLIT_VIEW_DISMISS_ACTION_IPH 12575
#define IDS_SPLIT_VIEW_TAB_SWITCH_ENTRY_IPH_TITLE 12576
#define IDS_SPLIT_VIEW_TAB_SWITCH_ENTRY_IPH_BODY 12577
#define IDS_SPLIT_VIEW_TAB_SWITCH_STEP_IPH_BODY 12578
#define IDS_SPLIT_VIEW_TAB_SWITCH_COMPLETION_IPH_BODY 12579
#define IDS_SPLIT_VIEW_TOOLBAR_BUTTON_STEP_IPH_BODY 12580
#define IDS_SPLIT_VIEW_DRAG_ENTRYPOINT_LABEL 12581
#define IDS_SWITCH_TO_VERTICAL_TAB 12582
#define IDS_SWITCH_TO_HORIZONTAL_TAB 12583
#define IDS_TOOLTIP_INTENT_PICKER_ICON 452
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_WITH 12584
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_IN_APP 12585
#define IDS_INTENT_PICKER_BUBBLE_VIEW_REMEMBER_SELECTION 12586
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN 12587
#define IDS_INTENT_PICKER_BUBBLE_VIEW_STAY_IN_CHROME 12588
#define IDS_INTENT_PICKER_BUBBLE_VIEW_INITIATING_ORIGIN 12589
#define IDS_INTENT_CHIP_OPEN_IN_APP 12590
#define IDR_INTENT_PICKER_SUPPORTED_LINKS_INFOBAR_MESSAGE 12591
#define IDR_INTENT_PICKER_SUPPORTED_LINKS_INFOBAR_OK_LABEL 12592
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_BUTTON_DECLINE 12600
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_REMINDER_CONFIRMATION_TITLE 12601
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_REMINDER_CONFIRMATION_BUTTON 12602
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_BUTTON_ACCEPT_QR 12603
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_BUTTON_ACCEPT_REMINDER 12604
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_LENS_FEATURE_NAME 12605
#define IDS_IOS_DESKTOP_PROMO_BUBBLE_ENHANCED_BROWSING_FEATURE_NAME 12606
#define IDS_IOS_DEVICE_TYPE_IPHONE 12607
#define IDS_IOS_DEVICE_TYPE_IPAD 12608
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_TITLE 12609
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_FOOTER_TITLE 12610
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_FOOTER_TITLE_REMINDER 12611
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_BUTTON_DECLINE 12612
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_SUBTITLE 12613
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_FOOTER_DESCRIPTION_QR 12614
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_TITLE 12615
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_FOOTER_TITLE 12616
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_BUTTON_DECLINE 12617
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_SUBTITLE 12618
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_FOOTER_DESCRIPTION_QR 12619
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_TITLE 12620
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_FOOTER_TITLE 12621
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_BUTTON_DECLINE 12622
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_SUBTITLE 12623
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_FOOTER_DESCRIPTION_QR 12624
#define IDS_IOS_DESKTOP_ESB_PROMO_BUBBLE_TITLE_QR 12625
#define IDS_IOS_DESKTOP_ESB_PROMO_BUBBLE_TITLE_REMINDER 12626
#define IDS_IOS_DESKTOP_LENS_PROMO_BUBBLE_TITLE_QR 12627
#define IDS_IOS_DESKTOP_LENS_PROMO_BUBBLE_TITLE_REMINDER 12628
#define IDS_IOS_DESKTOP_LENS_PROMO_BUBBLE_DESCRIPTION 12629
#define IDS_ACCESSIBLE_INCOGNITO_WINDOW_TITLE_FORMAT 12630
#define IDS_ACCESSIBLE_GUEST_WINDOW_TITLE_FORMAT 12631
#define IDS_ACCESSIBLE_WINDOW_TITLE_WITH_PROFILE_FORMAT 12632
#define IDS_ACCNAME_APP_UPGRADE_RECOMMENDED 12633
#define IDS_ACCNAME_FULLSCREEN 12634
#define IDS_ACCNAME_EXIT_FULLSCREEN 12635
#define IDS_ACCNAME_FULLSCREEN_DISABLED 12636
#define IDS_ACCNAME_HOME 420
#define IDS_ACCNAME_RELOAD 418
#define IDS_ACCNAME_SPLIT_TABS_TOOLBAR_BUTTON_PINNED 12637
#define IDS_ACCNAME_SPLIT_TABS_TOOLBAR_BUTTON_ENABLED 12638
#define IDS_ACCNAME_FIND 12639
#define IDS_ACCNAME_BOOKMARKS 686
#define IDS_ACCNAME_SAVED_TAB_GROUPS 679
#define IDS_ACCNAME_SAVED_TAB_GROUPS_CHEVRON 680
#define IDS_SAVED_TAB_GROUPS_OVERFLOW_BUTTON_TOOLTIP 681
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_SYNC_DISABLED 12640
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_SYNC_ENABLED 12641
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_LEARN_MORE 12642
#define IDS_ACCNAME_TAB_GROUPS_EVERYTHING 12643
#define IDS_TAB_GROUPS_EVERYTHING_BUTTON_TOOLTIP 12644
#define IDS_ACCNAME_BOOKMARKS_CHEVRON 682
#define IDS_ACCNAME_BOOKMARK_BUTTON_ROLE_DESCRIPTION 12645
#define IDS_ACCNAME_BOOKMARK_FOLDER_BUTTON_ROLE_DESCRIPTION 689
#define IDS_ACCNAME_SAVED_TAB_GROUP_BUTTON_ROLE_DESCRIPTION 12646
#define IDS_ACCNAME_CHROMELABS_BUTTON 12647
#define IDS_ACCNAME_LEFT_ALIGNED_SIDE_PANEL_BUTTON 12648
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_ADDED_BY_ENTERPRISE_POLICY 12649
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_REMOVED_BY_ENTERPRISE_POLICY 12650
#define IDS_ACCNAME_CHROMELABS_COMBOBOX 12651
#define IDS_ACCNAME_CHROMELABS_COMBOBOX_MAC 12652
#define IDS_ACCNAME_SEPARATOR 690
#define IDS_ACCNAME_EXTENSIONS 12653
#define IDS_ACCNAME_NEWTAB 394
#define IDS_ACCNAME_MINIMIZE 12654
#define IDS_ACCNAME_MAXIMIZE 12655
#define IDS_ACCNAME_RESTORE 12656
#define IDS_ACCNAME_CLOSE_TAB 12657
#define IDS_ACCNAME_ZOOM_SET_DEFAULT 12658
#define IDS_ACCNAME_TAB_SEARCH 405
#define IDS_ACCNAME_TAB_ORGANIZE 12659
#define IDS_ACCNAME_TAB_SCROLL_LEADING 12660
#define IDS_ACCNAME_TAB_SCROLL_TRAILING 12661
#define IDS_ACCNAME_MUTE_TAB 673
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_LEADING_SCROLL_BUTTON 12662
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_TRAILING_SCROLL_BUTTON 12663
#define IDS_TOOLBAR_BUTTON_UNPINNED 12664
#define IDS_TOOLBAR_BUTTON_PINNED 12665
#define IDS_ALLOWED_CLIPBOARD_TITLE 12666
#define IDS_BLOCKED_CLIPBOARD_TITLE 12667
#define IDS_ALLOWED_CLIPBOARD_MESSAGE 12668
#define IDS_ALLOWED_CLIPBOARD_BLOCK 12669
#define IDS_ALLOWED_CLIPBOARD_NO_ACTION 12670
#define IDS_BLOCKED_CLIPBOARD_MESSAGE 12671
#define IDS_BLOCKED_CLIPBOARD_UNBLOCK 12672
#define IDS_BLOCKED_CLIPBOARD_NO_ACTION 12673
#define IDS_BACK_NAVIGATION_MENU_PROMO 12674
#define IDS_BACK_NAVIGATION_MENU_PROMO_ACCESSIBLE_TEXT 12675
#define IDS_BOOKMARK_PROMO_0 12676
#define IDS_BOOKMARK_PROMO_1 12677
#define IDS_BOOKMARK_PROMO_2 12678
#define IDS_CHROME_TIP 12679
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_TITLE 12680
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_BODY 12681
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_TITLE 12682
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_BODY 12683
#define IDS_EXTENSIONS_ZERO_STATE_PROMO_IPH_TITLE 12684
#define IDS_EXTENSIONS_ZERO_STATE_PROMO_CUSTOM_ACTION_IPH_DESCRIPTION 12685
#define IDS_EXTENSIONS_ZERO_STATE_PROMO_CUSTOM_ACTION_IPH_ACCEPT 12686
#define IDS_GLOBAL_MEDIA_CONTROLS_PROMO 12687
#define IDS_INCOGNITOWINDOW_PROMO_0 12688
#define IDS_INCOGNITOWINDOW_PROMO_1 12689
#define IDS_INCOGNITOWINDOW_PROMO_2 12690
#define IDS_INCOGNITOWINDOW_PROMO_3 12691
#define IDS_NEWTAB_PROMO_0 12692
#define IDS_NEWTAB_PROMO_1 12693
#define IDS_NEWTAB_PROMO_2 12694
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO 12695
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO_PINNING 12696
#define IDS_READING_LIST_DISCOVERY_PROMO 12697
#define IDS_READING_LIST_DISCOVERY_PROMO_PINNING 12698
#define IDS_READING_LIST_ENTRY_POINT_PROMO 12699
#define IDS_DESKTOP_PWA_INSTALL_PROMO 12700
#define IDS_DESKTOP_PWA_LINK_CAPTURING_TEXT 12701
#define IDS_DESKTOP_PWA_LINK_CAPTURING_SETTINGS 12702
#define IDS_UPDATED_CONNECTION_SECURITY_INDICATORS_PROMO 12703
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO 12704
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO_PINNING 12705
#define IDS_TAB_GROUPS_UNNAMED_GROUP_TOOLTIP 12706
#define IDS_TAB_GROUPS_NAMED_GROUP_TOOLTIP 12707
#define IDS_SHARED_HIGHLIGHTING_PROMO 12708
#define IDS_TAB_AUDIO_MUTING_PROMO 12709
#define IDS_BATTERY_SAVER_MODE_PROMO_TITLE 388
#define IDS_BATTERY_SAVER_MODE_PROMO_TEXT 12710
#define IDS_BATTERY_SAVER_MODE_PROMO_ACTION_TEXT 387
#define IDS_MEMORY_SAVER_MODE_PROMO_TEXT 12711
#define IDS_MEMORY_SAVER_MODE_PROMO_ACTION_TEXT 389
#define IDS_DISCARD_RING_PROMO_TITLE 12712
#define IDS_DISCARD_RING_PROMO_TEXT 12713
#define IDS_DISCARD_RING_PROMO_ACTION_TEXT 12714
#define IDS_DISCARD_RING_SETTINGS_TOAST 12715
#define IDS_TUTORIAL_GENERIC_SUCCESS_TITLE 12716
#define IDS_TUTORIAL_TAB_GROUP_ADD_TAB_TO_GROUP 12717
#define IDS_TUTORIAL_ADD_TAB_TO_GROUP_WITH_EXISTING_GROUP_IN_TAB_STRIP 12718
#define IDS_TUTORIAL_TAB_GROUP_EDIT_BUBBLE 12719
#define IDS_TUTORIAL_TAB_GROUP_DRAG_TAB 12720
#define IDS_TUTORIAL_TAB_GROUP_COLLAPSE 12721
#define IDS_TUTORIAL_TAB_GROUP_SUCCESS_DESCRIPTION 12722
#define IDS_TUTORIAL_SAVED_TAB_GROUP_ADD_TAB_TO_GROUP 12723
#define IDS_TUTORIAL_SAVED_TAB_GROUP_OPEN_EDITOR 12724
#define IDS_TUTORIAL_SAVED_TAB_GROUP_NAME_SAVE_GROUP 12725
#define IDS_TUTORIAL_SAVED_TAB_GROUP_HIDE_GROUP 12726
#define IDS_TUTORIAL_SAVED_TAB_GROUP_REOPEN_GROUP 12727
#define IDS_TUTORIAL_SAVED_TAB_GROUP_SUCCESS_DESCRIPTION 12728
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_OPEN_SIDE_PANEL 12729
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_ADD_TAB 12730
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_MARK_READ 12731
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_CLICK_DROPDOWN 12732
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_SUCCESS_BODY 12733
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_BODY 12734
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_POINTER_BODY 12735
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_CUSTOM_ACTION 12736
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_START_TUTORIAL_IPH 12737
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_OPEN_SIDE_PANEL 12738
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CHANGE_THEME 12739
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SELECT_COLLECTION 12740
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_APPLY_THEME 12741
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CLICK_BACK_ARROW 12742
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SUCCESS_BODY 12743
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_MENU 12744
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORDS_MENU 12745
#define IDS_TUTORIAL_PASSWORD_MANAGER_SELECT_SETTINGS 12746
#define IDS_TUTORIAL_PASSWORD_MANAGER_ADD_SHORTCUT 12747
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_INSTALL 12748
#define IDS_TUTORIAL_LENS_OVERLAY_INTRO_HEADER 12749
#define IDS_TUTORIAL_LENS_OVERLAY_INTRO_BODY 12750
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_ADDRESS_BAR 12751
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_LENS 12752
#define IDS_TUTORIAL_LENS_OVERLAY_HOMEWORK_INTRO_HEADER 12753
#define IDS_TUTORIAL_LENS_OVERLAY_HOMEWORK_INTRO_BODY 12754
#define IDS_TUTORIAL_LENS_OVERLAY_HOMEWORK_CLICK_LENS 12755
#define IDS_TUTORIAL_LENS_OVERLAY_SELECT 12756
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_SEARCH_BOX 12757
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_PIN_ICON 12758
#define IDS_TUTORIAL_LENS_OVERLAY_SUCCESS_BODY 12759
#define IDS_BROWSER_HANGMONITOR 12760
#define IDS_BROWSER_HANGMONITOR_RENDERER_TITLE 12761
#define IDS_BROWSER_HANGMONITOR_RENDERER 12762
#define IDS_BROWSER_HANGMONITOR_IFRAME_TITLE 12763
#define IDS_BROWSER_HANGMONITOR_RENDERER_WAIT 12764
#define IDS_BROWSER_HANGMONITOR_RENDERER_END 12765
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR 12766
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR_KILLBUTTON 12767
#define IDS_PASSWORDS_AUTO_SIGNIN_TITLE 12768
#define IDS_PASSWORDS_AUTO_SIGNIN_DESCRIPTION 12769
#define IDS_PASSWORDS_VIA_FEDERATION 12770
#define IDS_CONFIRM_MESSAGEBOX_YES_BUTTON_LABEL 12771
#define IDS_CONFIRM_MESSAGEBOX_NO_BUTTON_LABEL 12772
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_TITLE 12773
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_DESCRIPTION 12774
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_TITLE 12775
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_ACCEPT 12776
#define IDS_TAILORED_SECURITY_DISPLAY_SOURCE 12777
#define IDS_PASSWORD_MANAGER_CANCEL_BUTTON 12778
#define IDS_PASSWORD_MANAGER_USERNAME_LABEL 12779
#define IDS_PASSWORD_MANAGER_PASSWORD_LABEL 12780
#define IDS_PASSWORD_MANAGER_UPDATED_BUBBLE_TITLE 12781
#define IDS_PASSWORD_MANAGER_MORE_TO_FIX_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 12782
#define IDS_PASSWORD_MANAGER_SAFE_STATE_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 12783
#define IDS_PASSWORD_MANAGER_CHECK_REMAINING_BUTTON 12784
#define IDS_PASSWORD_MANAGER_SAVE_BUTTON 12785
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_CANCEL_BUTTON 12786
#define IDS_PASSWORD_MANAGER_UPDATE_BUTTON 12787
#define IDS_PASSWORD_MANAGER_BUBBLE_BLOCKLIST_BUTTON 12788
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_ACCESSIBLE_NAME 12789
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_ACCOUNT 12790
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_DEVICE 12791
#define IDS_PASSWORD_MANAGER_IPH_TITLE_SAVE_TO_ACCOUNT 386
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_TO_ACCOUNT 12792
#define IDS_PASSWORDS_SAVE_PRIMING_PROMO_BODY_TEMPLATE 12793
#define IDS_PASSWORDS_SAVE_PRIMING_PROMO_BODY_SIGNED_IN 12794
#define IDS_PASSWORDS_SAVE_PRIMING_PROMO_BODY_NOT_SIGNED_IN 12795
#define IDS_PASSWORDS_SAVE_PRIMING_PROMO_SCREENREADER 12796
#define IDS_PASSWORDS_SAVE_RECOVERY_PROMO_BODY 12797
#define IDS_PASSWORDS_SAVE_RECOVERY_PROMO_SCREENREADER 12798
#define IDS_PASSWORD_MANAGER_TOOLTIP_BLOCKED 12799
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE 12800
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE_SCREENREADER 12801
#define IDS_PASSWORD_MANAGER_IPH_SHARE_PASSWORD_BUTTON 12802
#define IDS_PASSWORD_MANAGER_IPH_SHARE_PASSWORD_BUTTON_SCREENREADER 12803
#define IDS_PASSWORD_MANAGER_IPH_ACCOUNT_STORAGE_TOGGLE 12804
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_TITLE 12805
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN 12806
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN_SCREENREADER 12807
#define IDS_PASSWORD_MANAGER_TOOLTIP_SAVE 12808
#define IDS_PASSWORD_MANAGER_TOOLTIP_MANAGE 451
#define IDS_PASSWORD_MANAGER_TOOLTIP_MOVE 12809
#define IDS_PASSWORD_MANAGER_TOOLTIP_PROTECT 12810
#define IDS_PASSWORD_MANAGER_TOOLTIP_SHARED_NOTIFICATION 12811
#define IDS_PASSWORD_MANAGER_TOOLTIP_KEYCHAIN_ERROR 12812
#define IDS_IMPORT_FROM_IE 12832
#define IDS_IMPORT_FROM_EDGE 12833
#define IDS_IMPORT_FROM_FIREFOX 12834
#define IDS_IMPORT_FROM_ICEWEASEL 12835
#define IDS_IMPORT_FROM_SAFARI 12836
#define IDS_IMPORT_FROM_BOOKMARKS_HTML_FILE 12837
#define IDS_IMPORTER_LOCK_TITLE 12841
#define IDS_IMPORTER_LOCK_TEXT 12842
#define IDS_IMPORTER_LOCK_OK 12843
#define IDS_FEEDBACK_REPORT_APP_TITLE 12844
#define IDS_FEEDBACK_REPORT_PAGE_TITLE 12845
#define IDS_FEEDBACK_REPORT_PAGE_TITLE_SAD_TAB_FLOW 12846
#define IDS_FEEDBACK_MINIMIZE_BUTTON_LABEL 12847
#define IDS_FEEDBACK_CLOSE_BUTTON_LABEL 12848
#define IDS_FEEDBACK_FREE_TEXT_LABEL 12849
#define IDS_FEEDBACK_FREE_TEXT_AI_LABEL 12850
#define IDS_FEEDBACK_REPORT_URL_LABEL 12851
#define IDS_FEEDBACK_USER_EMAIL_LABEL 12852
#define IDS_FEEDBACK_ANONYMOUS_EMAIL_OPTION 12853
#define IDS_FEEDBACK_CONSENT_CHECKBOX_LABEL 12854
#define IDS_FEEDBACK_SCREENSHOT_LABEL 12855
#define IDS_FEEDBACK_SCREENSHOT_A11Y_TEXT 12856
#define IDS_FEEDBACK_OFFLINE_DIALOG_TITLE 12857
#define IDS_FEEDBACK_OFFLINE_DIALOG_TEXT 12858
#define IDS_FEEDBACK_INCLUDE_SYSTEM_INFORMATION_CHKBOX 12859
#define IDS_FEEDBACK_ATTACH_FILE_NOTE 12862
#define IDS_FEEDBACK_ATTACH_FILE_LABEL 12863
#define IDS_FEEDBACK_ATTACH_FILE_TO_BIG 12864
#define IDS_FEEDBACK_INCLUDE_AUTOFILL_METADATA_CHECKBOX 12865
#define IDS_FEEDBACK_IWLWIFI_DEBUG_DUMP_EXPLAINER 12866
#define IDS_FEEDBACK_LOG_ID_CHECKBOX_LABEL 12867
#define IDS_FEEDBACK_PRIVACY_NOTE 12868
#define IDS_FEEDBACK_NO_DESCRIPTION 12869
#define IDS_FEEDBACK_OFFENSIVE_CHECKBOX_LABEL 12870
#define IDS_FEEDBACK_SEND_REPORT 12871
#define IDS_FEEDBACK_AUTOFILL_METADATA_PAGE_TITLE 12872
#define IDS_FEEDBACK_SYSINFO_PAGE_TITLE 12873
#define IDS_FEEDBACK_SYSINFO_PAGE_LOADING 12874
#define IDS_FEEDBACK_ADDITIONAL_INFO_LABEL 12875
#define IDS_CLEAR_BROWSING_DATA_TITLE 12876
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE 12877
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_TITLE 12878
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_OK 12879
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE 12880
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_TITLE 12881
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_OK 12882
#define IDS_MEDIA_SELECTED_MIC_LABEL 12883
#define IDS_MEDIA_SELECTED_CAMERA_LABEL 12884
#define IDS_MEDIA_MENU_NO_DEVICE_TITLE 12885
#define IDS_MEDIA_CONTROLS_TITLE_PLACEHOLDER_INCOGNITO 12886
#define IDS_ZOOMLEVELS_CHROME_ERROR_PAGES_LABEL 12887
#define IDS_STORAGE_ACCESS_MANAGE_TEXT 12888
#define IDS_STORAGE_ACCESS_MANAGE_TOOLTIP 12889
#define IDS_UPGRADE_ERROR 12896
#define IDS_UPGRADE_ERROR_DETAILS 12897
#define IDS_UPGRADE_DISABLED_BY_POLICY 12898
#define IDS_UPGRADE_DISABLED_BY_POLICY_MANUAL 12899
#define IDS_REPORT_AN_ISSUE 12900
#define IDS_REENABLE_UPDATES 12901
#define IDS_PICTURE_IN_PICTURE_TITLE_TEXT 12902
#define IDS_PICTURE_IN_PICTURE_PAUSE_CONTROL_TEXT 12903
#define IDS_PICTURE_IN_PICTURE_PLAY_CONTROL_TEXT 12904
#define IDS_PICTURE_IN_PICTURE_REPLAY_CONTROL_TEXT 12905
#define IDS_PICTURE_IN_PICTURE_BACK_TO_TAB_CONTROL_TEXT 12906
#define IDS_PICTURE_IN_PICTURE_SKIP_AD_CONTROL_TEXT 12907
#define IDS_PICTURE_IN_PICTURE_LIVE_STATUS_TEXT 12908
#define IDS_PICTURE_IN_PICTURE_MUTE_MICROPHONE_TEXT 12909
#define IDS_PICTURE_IN_PICTURE_UNMUTE_MICROPHONE_TEXT 12910
#define IDS_PICTURE_IN_PICTURE_TURN_ON_CAMERA_TEXT 12911
#define IDS_PICTURE_IN_PICTURE_TURN_OFF_CAMERA_TEXT 12912
#define IDS_PICTURE_IN_PICTURE_HANG_UP_TEXT 12913
#define IDS_PICTURE_IN_PICTURE_CLOSE_CONTROL_TEXT 12914
#define IDS_PICTURE_IN_PICTURE_MINIMIZE_CONTROL_TEXT 12915
#define IDS_PICTURE_IN_PICTURE_LIVE_CAPTION_CONTROL_TEXT 12916
#define IDS_PICTURE_IN_PICTURE_REPLAY_10_TEXT 12917
#define IDS_PICTURE_IN_PICTURE_FORWARD_10_TEXT 12918
#define IDS_PICTURE_IN_PICTURE_RESIZE_HANDLE_TEXT 12919
#define IDS_PICTURE_IN_PICTURE_PLAY_PAUSE_CONTROL_ACCESSIBLE_TEXT 12920
#define IDS_PICTURE_IN_PICTURE_NEXT_TRACK_CONTROL_ACCESSIBLE_TEXT 12921
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_TRACK_CONTROL_ACCESSIBLE_TEXT 12922
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_SLIDE_CONTROL_ACCESSIBLE_TEXT 12923
#define IDS_PICTURE_IN_PICTURE_NEXT_SLIDE_CONTROL_ACCESSIBLE_TEXT 12924
#define IDS_AUTO_PICTURE_IN_PICTURE_DESCRIPTION 12925
#define IDS_LOAD_STATE_WAITING_FOR_SOCKET_SLOT 12926
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE 12927
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE_GENERIC 12928
#define IDS_LOAD_STATE_WAITING_FOR_CACHE 12929
#define IDS_LOAD_STATE_ESTABLISHING_PROXY_TUNNEL 12930
#define IDS_LOAD_STATE_RESOLVING_PROXY_FOR_URL 12931
#define IDS_LOAD_STATE_RESOLVING_HOST_IN_PAC_FILE 12932
#define IDS_LOAD_STATE_DOWNLOADING_PAC_FILE 12933
#define IDS_LOAD_STATE_RESOLVING_HOST 12934
#define IDS_LOAD_STATE_CONNECTING 12935
#define IDS_LOAD_STATE_SSL_HANDSHAKE 12936
#define IDS_LOAD_STATE_SENDING_REQUEST 12937
#define IDS_LOAD_STATE_SENDING_REQUEST_WITH_PROGRESS 12938
#define IDS_LOAD_STATE_WAITING_FOR_RESPONSE 12939
#define IDS_TAB_CXMENU_NEWTABTORIGHT 12940
#define IDS_TAB_CXMENU_NEWTABTOLEFT 12941
#define IDS_TAB_CXMENU_RELOAD 12942
#define IDS_TAB_CXMENU_DUPLICATE 12943
#define IDS_TAB_CXMENU_CLOSETAB 12944
#define IDS_TAB_CXMENU_CLOSEOTHERTABS 12945
#define IDS_TAB_CXMENU_CLOSETABSTORIGHT 12946
#define IDS_TAB_CXMENU_CLOSETABSTOLEFT 12947
#define IDS_TAB_CXMENU_CLOSEALLTABS 12948
#define IDS_TAB_CXMENU_FOCUS_THIS_TAB 12949
#define IDS_TAB_CXMENU_PIN_TAB 12950
#define IDS_TAB_CXMENU_UNPIN_TAB 12951
#define IDS_TAB_CXMENU_SOUND_MUTE_SITE 12952
#define IDS_TAB_CXMENU_SOUND_UNMUTE_SITE 12953
#define IDS_TAB_CXMENU_READ_LATER 12954
#define IDS_TAB_CXMENU_ADD_TAB_TO_GROUP 12955
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_GROUP 12956
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_SPLIT 12957
#define IDS_TAB_CXMENU_NEW_SPLIT_WITH_CURRENT 12958
#define IDS_TAB_CXMENU_ARRANGE_SPLIT 12959
#define IDS_TAB_CXMENU_SWAP_WITH_ACTIVE_SPLIT 12960
#define IDS_TAB_CXMENU_SUBMENU_NEW_GROUP 12961
#define IDS_TAB_CXMENU_REMOVE_TAB_FROM_GROUP 12962
#define IDS_TAB_CXMENU_PLACEHOLDER_GROUP_TITLE 12963
#define IDS_TAB_CXMENU_MOVE_TABS_TO_NEW_WINDOW 12964
#define IDS_TAB_CXMENU_MOVETOANOTHERWINDOW 12965
#define IDS_TAB_CXMENU_MOVETOANOTHERNEWWINDOW 12966
#define IDS_TAB_CXMENU_ORGANIZE_TABS 12967
#define IDS_TAB_CXMENU_COMMERCE_PRODUCT_SPEC 12968
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_COMPARISON_TABLE 12969
#define IDS_TOOLTIP_WEBUI_TAB_STRIP_TAB_COUNTER 12973
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_NEW_TAB 12974
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_CLOSE_TAB 12975
#define IDS_ACCNAME_SPLIT_TABS_RESIZE 12976
#define IDS_PIN_SPLIT_TAB_TOGGLE 12977
#define IDS_SPLIT_TAB_REVERSE_VIEWS 12978
#define IDS_SPLIT_TAB_CLOSE 12979
#define IDS_SPLIT_TAB_CLOSE_LEFT_VIEW 12980
#define IDS_SPLIT_TAB_CLOSE_RIGHT_VIEW 12981
#define IDS_SPLIT_TAB_CLOSE_TOP_VIEW 12982
#define IDS_SPLIT_TAB_CLOSE_BOTTOM_VIEW 12983
#define IDS_SPLIT_TAB_SEPARATE_VIEWS 12984
#define IDS_SPLIT_TAB_SWAP_LEFT_VIEW 12985
#define IDS_SPLIT_TAB_SWAP_RIGHT_VIEW 12986
#define IDS_SPLIT_TAB_SWAP_TOP_VIEW 12987
#define IDS_SPLIT_TAB_SWAP_BOTTOM_VIEW 12988
#define IDS_SPLIT_TAB_SEND_FEEDBACK 12989
#define IDS_TAB_SEARCH_PROMO 12990
#define IDS_TAB_SEARCH_TOOLBAR_BUTTON_PROMO_TITLE 12991
#define IDS_TAB_SEARCH_TOOLBAR_BUTTON_PROMO_BODY 12992
#define IDS_TAB_SEARCH_TOOLBAR_BUTTON_PROMO_ACTION 12993
#define IDS_TAB_SEARCH_SEARCH_TABS 12994
#define IDS_TAB_SEARCH_NO_RESULTS_FOUND 12995
#define IDS_TAB_SEARCH_CLOSE_TAB 12996
#define IDS_TAB_SEARCH_SUBMIT_FEEDBACK 12997
#define IDS_TAB_SEARCH_A11Y_TAB_CLOSED 12998
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB 12999
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS 13000
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB_FOR 13001
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS_FOR 13002
#define IDS_TAB_SEARCH_A11Y_OPEN_TAB 13003
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB 13004
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB_GROUP 13005
#define IDS_TAB_SEARCH_MEDIA_TABS 13006
#define IDS_TAB_SEARCH_OPEN_TABS 13007
#define IDS_TAB_SEARCH_RECENTLY_CLOSED 13008
#define IDS_TAB_SEARCH_RECENTLY_CLOSED_TABS 13009
#define IDS_TAB_SEARCH_ONE_TAB 13010
#define IDS_TAB_SEARCH_TAB_COUNT 13011
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED_ITEMS 13012
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED 13013
#define IDS_TAB_SEARCH_COLLAPSE_RECENTLY_CLOSED 13014
#define IDS_TAB_SEARCH_TAB_NAME 13015
#define IDS_TAB_SEARCH_MENU 13016
#define IDS_TAB_ORGANIZATION_TAB_NAME 13017
#define IDS_TAB_ORGANIZATION_CREATE_GROUP 13018
#define IDS_TAB_ORGANIZATION_CREATE_GROUPS 13019
#define IDS_TAB_ORGANIZATION_DISMISS 13020
#define IDS_TAB_ORGANIZATION_NEW_TABS 13021
#define IDS_TAB_ORGANIZATION_NOT_STARTED_TITLE 13022
#define IDS_TAB_ORGANIZATION_NOT_STARTED_TITLE_FRE 13023
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY 13024
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_HEADER 13025
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_BULLET_1 13026
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_BULLET_2 13027
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_BULLET_3 13028
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_SIGNED_OUT 13029
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON 13030
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_FRE 13031
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_SIGNED_OUT 13032
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_ARIA_LABEL 13033
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_FRE_ARIA_LABEL 13034
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_SIGNED_OUT_ARIA_LABEL 13035
#define IDS_TAB_ORGANIZATION_IN_PROGRESS_TITLE 13036
#define IDS_TAB_ORGANIZATION_SUCCESS_MISSING_ACTIVE_TAB_TITLE 13037
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE_SINGLE 13038
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE_MULTI 13039
#define IDS_TAB_ORGANIZATION_FAILURE_TITLE_GENERIC 13040
#define IDS_TAB_ORGANIZATION_FAILURE_TITLE_GROUPING 13041
#define IDS_TAB_ORGANIZATION_FAILURE_BODY_GENERIC 13042
#define IDS_TAB_ORGANIZATION_FAILURE_BODY_GROUPING 13043
#define IDS_TAB_ORGANIZATION_TIP_TITLE 13044
#define IDS_TAB_ORGANIZATION_TIP_BODY 13045
#define IDS_TAB_ORGANIZATION_TIP_ACTION 13046
#define IDS_TAB_ORGANIZATION_TIP_ARIA_DESCRIPTION 13047
#define IDS_TAB_ORGANIZATION_DISCLAIMER_1 13048
#define IDS_TAB_ORGANIZATION_DISCLAIMER_2 13049
#define IDS_TAB_ORGANIZATION_LEARN_MORE 13050
#define IDS_TAB_ORGANIZATION_LEARN_MORE_ARIA_LABEL 13051
#define IDS_TAB_ORGANIZATION_CLOSE_TAB_ARIA_LABEL 13052
#define IDS_TAB_ORGANIZATION_CLOSE_TAB_TOOLTIP 13053
#define IDS_TAB_ORGANIZATION_CLEAR_SUGGESTIONS 13054
#define IDS_TAB_ORGANIZATION_CLEAR_ARIA_LABEL 13055
#define IDS_TAB_ORGANIZATION_INPUT_ARIA_LABEL 13056
#define IDS_TAB_ORGANIZATION_EDIT_ARIA_LABEL 13057
#define IDS_TAB_ORGANIZATION_REJECT_ARIA_LABEL 13058
#define IDS_TAB_ORGANIZATION_THUMBS_DOWN 13059
#define IDS_TAB_ORGANIZATION_THUMBS_UP 13060
#define IDS_AUTO_TAB_GROUPS_SELECTOR_HEADING 13061
#define IDS_AUTO_TAB_GROUPS_SELECTOR_SUBHEADING 13062
#define IDS_TAB_ORGANIZATION_BACK_BUTTON_ARIA_LABEL 13063
#define IDS_TAB_ORGANIZATION_A11Y_TAB_EXCLUDED 13064
#define IDS_BROWSER_WINDOW_TITLE_MENU_ENTRY 13065
#define IDS_TABS_TITLE_CXMENU 13066
#define IDS_SAVED_TAB_GROUP_TABS_COUNT 13067
#define IDS_CREATE_NEW_TAB_GROUP 13068
#define IDS_GROUP_UNGROUPED_TABS 13069
#define IDS_SAVED_TAB_GROUPS_MENU 13070
#define IDS_OPEN_GROUP_IN_BROWSER_MENU 13071
#define IDS_NEW_TAB_IN_GROUP 13072
#define IDS_NEW_TAB_IN_GROUP_NO_GROUPS 13073
#define IDS_NEW_TAB_IN_GROUP_NO_NAME 13074
#define IDS_NEW_TAB_GROUP 13075
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_APP_MENU_SYNCED_BODY 13076
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_DEFAULT_BODY_A11Y 13077
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_APP_MENU_NOT_SYNCED_BODY 13078
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_BOOKMARKS_BAR_SYNCED_BODY 13079
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_BOOKMARKS_BAR_NOT_SYNCED_BODY 13080
#define IDS_SAVED_TAB_GROUPS_UNSUPPORTED_ERROR 13081
#define IDS_TAB_GROUP_DELETION_DIALOG_MISSING_EMAIL 13082
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_SYNCED_DELETE 13083
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_SYNCED_UNGROUP 13084
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_NOT_SYNCED_DELETE 13085
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_NOT_SYNCED_UNGROUP 13086
#define IDS_TAB_GROUP_DELETION_DIALOG_DONT_ASK 13087
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_DELETE 13088
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_UNGROUP 13089
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_CLOSE_TAB_AND_DELETE 13090
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_REMOVE_TAB_AND_DELETE 13091
#define IDS_TAB_GROUP_DELETION_DIALOG_OK_TEXT_DELETE 13092
#define IDS_TAB_GROUP_DELETION_DIALOG_OK_TEXT_UNGROUP 13093
#define IDS_TAB_GROUP_HEADER_CXMENU_TAB_GROUP_TITLE_ACCESSIBLE_NAME 13094
#define IDS_TAB_GROUP_HEADER_CXMENU_TAB_GROUP_FACE_PILE_ACCESSIBLE_NAME 13095
#define IDS_TAB_GROUP_HEADER_CXMENU_NEW_TAB_IN_GROUP 13096
#define IDS_TAB_GROUP_HEADER_CXMENU_UNGROUP 13097
#define IDS_TAB_GROUP_HEADER_CXMENU_SHARE_GROUP 13098
#define IDS_TAB_GROUP_HEADER_CXMENU_RECENT_ACTIVITY 13099
#define IDS_TAB_GROUP_HEADER_CXMENU_MANAGE_GROUP 13100
#define IDS_TAB_GROUP_HEADER_CXMENU_CLOSE_GROUP 13101
#define IDS_TAB_GROUP_HEADER_CXMENU_HIDE_GROUP 13102
#define IDS_TAB_GROUP_HEADER_CXMENU_DELETE_GROUP 13103
#define IDS_TAB_GROUP_HEADER_CXMENU_MOVE_GROUP_TO_NEW_WINDOW 13104
#define IDS_TAB_GROUP_HEADER_CXMENU_OPEN_GROUP_IN_NEW_WINDOW 13105
#define IDS_TAB_GROUP_HEADER_CXMENU_PIN_GROUP 13106
#define IDS_TAB_GROUP_HEADER_CXMENU_UNPIN_GROUP 13107
#define IDS_TAB_GROUP_HEADER_CXMENU_CONVERT_GROUP_TO_BOOKMARK_FOLDER 13108
#define IDS_TAB_GROUP_HEADER_CXMENU_SEND_FEEDBACK 13109
#define IDS_TAB_GROUP_HEADER_BUBBLE_TITLE_PLACEHOLDER 13110
#define IDS_DATA_SHARING_SHARE_GROUP_TITLE 13111
#define IDS_DATA_SHARING_COPY_LINK 13112
#define IDS_DATA_SHARING_COPY_LINK_SUCCESS 13113
#define IDS_DATA_SHARING_MANAGE_GROUP_TITLE 13114
#define IDS_DATA_SHARING_MANAGE_STOP_SHARING_OPTION 13115
#define IDS_DATA_SHARING_MANAGE_ACTIVITY_LOG_OPTION 13116
#define IDS_DATA_SHARING_OWNER_STOP_SHARING_DIALOG_TITLE 13117
#define IDS_DATA_SHARING_OWNER_REMOVE_MEMBER_DIALOG_TITLE 13118
#define IDS_DATA_SHARING_OWNER_REMOVE_MEMBER_DIALOG_CONFIRM 13119
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_TITLE 13120
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_CONFIRM 13121
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE 13122
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE_ZERO 13123
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE_SINGULAR 13124
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE_PLURAL 13125
#define IDS_DATA_SHARING_PREVIEW_DIALOG_CONFIRM 13126
#define IDS_DATA_SHARING_PREVIEW_DIALOG_DETAILS_TITLE 13127
#define IDS_DATA_SHARING_LINK_FAILED_TITLE 13128
#define IDS_DATA_SHARING_LEAVE_DIALOG_TITLE 13129
#define IDS_DATA_SHARING_BLOCK_LEAVE_DIALOG_TITLE 13130
#define IDS_DATA_SHARING_BLOCK_LEAVE_DIALOG_CONFIRM 13131
#define IDS_DATA_SHARING_NEED_SIGN_IN 13132
#define IDS_DATA_SHARING_NEED_SYNC 13133
#define IDS_DATA_SHARING_NEED_SYNC_TAB_GROUPS 13134
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT 13135
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT_BUTTON 13136
#define IDS_DATA_SHARING_GOT_IT 13137
#define IDS_DATA_SHARING_SOMETHING_WRONG 13138
#define IDS_DATA_SHARING_ORGANIZATION_DISALLOW_SIGN_IN 13139
#define IDS_DATA_SHARING_ORGANIZATION_LIMIT_SAVE 13140
#define IDS_DATA_SHARING_SIGNED_OUT 13141
#define IDS_DATA_SHARING_GROUP_FULL 13142
#define IDS_DATA_SHARING_DELETE_LAST_TAB_TITLE 13143
#define IDS_DATA_SHARING_DELETE_LAST_TAB_CONFIRM 13144
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_CANCEL 13145
#define IDS_DATA_SHARING_MEMBER_DELETE_LAST_TAB_CANCEL 13146
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TITLE 13147
#define IDS_DATA_SHARING_RECENT_ACTIVITY_LATEST_UPDATE_TAB 13148
#define IDS_DATA_SHARING_RECENT_ACTIVITY_LATEST_UPDATE_GROUP 13149
#define IDS_DATA_SHARING_SHARE_GROUP_BODY 13150
#define IDS_DATA_SHARING_SHARE_GROUP_SHARE_AS 13151
#define IDS_DATA_SHARING_MANAGE_SHARE_WISELY 13152
#define IDS_DATA_SHARING_OWNER_STOP_SHARING_DIALOG_BODY 13153
#define IDS_DATA_SHARING_OWNER_REMOVE_MEMBER_DIALOG_BODY 13154
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_BODY 13155
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_BODY_NO_GROUP_TITLE 13156
#define IDS_DATA_SHARING_PREVIEW_DIALOG_BODY 13157
#define IDS_DATA_SHARING_PREVIEW_DIALOG_DETAILS_TABS_IN_GROUP 13158
#define IDS_DATA_SHARING_LINK_FAILED_BODY 13159
#define IDS_DATA_SHARING_JOIN_GROUP_JOIN_AS 13160
#define IDS_DATA_SHARING_GET_GROUP_PREVIEW_ARIA_LABEL 13161
#define IDS_DATA_SHARING_PREVIEW_A11Y_NAME 13162
#define IDS_DATA_SHARING_LEAVE_DIALOG_BODY 13163
#define IDS_DATA_SHARING_LEAVE_DIALOG_BODY_NO_GROUP_TITLE 13164
#define IDS_DATA_SHARING_LEAVE_DIALOG_CONFIRM 13165
#define IDS_DATA_SHARING_BLOCK_DIALOG_TITLE 13166
#define IDS_DATA_SHARING_BLOCK_DIALOG_BODY 13167
#define IDS_DATA_SHARING_BLOCK_LEAVE_DIALOG_BODY 13168
#define IDS_DATA_SHARING_BLOCK_LEAVE_LEARN_MORE 13169
#define IDS_DATA_SHARING_NEED_SIGN_IN_BODY 13170
#define IDS_DATA_SHARING_NEED_SIGN_IN_CONTINUE_BUTTON 13171
#define IDS_DATA_SHARING_NEED_SYNC_BODY 13172
#define IDS_DATA_SHARING_NEED_SYNC_TAB_GROUPS_BODY 13173
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT_BODY 13174
#define IDS_SYNC_HISTORY_TITLE 13175
#define IDS_DATA_SHARING_NEED_SIGN_IN_AND_SYNC_HISTORY_BODY 13176
#define IDS_DATA_SHARING_NEED_SYNC_HISTORY_BODY 13177
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT_SYNC_HISTORY_BODY 13178
#define IDS_SYNC_HISTORY_BUTTON 13179
#define IDS_SYNC_HISTORY_FOOTER 13180
#define IDS_DATA_SHARING_SOMETHING_WRONG_BODY 13181
#define IDS_DATA_SHARING_SHARE_ERROR_BODY 13182
#define IDS_DATA_SHARING_JOIN_WARNING 13183
#define IDS_DATA_SHARING_ORGANIZATION_DISALLOW_SIGN_IN_BODY 13184
#define IDS_DATA_SHARING_ORGANIZATION_LIMIT_SAVE_BODY 13185
#define IDS_DATA_SHARING_SIGNED_OUT_BODY 13186
#define IDS_DATA_SHARING_SETTINGS 13187
#define IDS_DATA_SHARING_GROUP_FULL_BODY 13188
#define IDS_DATA_SHARING_OWNER_CANNOT_SHARE 13189
#define IDS_DATA_SHARING_DELETE_LAST_DIALOG_HEADER 13190
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_BODY 13191
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_BODY_SINGULAR 13192
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_BODY_2 13193
#define IDS_DATA_SHARING_MEMBER_DELETE_LAST_TAB_BODY 13194
#define IDS_DATA_SHARING_MEMBER_DELETE_LAST_TAB_BODY_SINGULAR 13195
#define IDS_DATA_SHARING_RECENT_ACTIVITY_NO_UPDATES 13196
#define IDS_DATA_SHARING_PAGE_ACTION_ADDED_NEW_TAB 13197
#define IDS_DATA_SHARING_PAGE_ACTION_CHANGED_TAB 13198
#define IDS_DATA_SHARING_USER_ED_FIRST_TAB_CHANGE 13199
#define IDS_DATA_SHARING_SHARED_GROUPS_FEEDBACK 13200
#define IDS_DATA_SHARING_SHARED_GROUPS_FEEDBACK_IPH 13201
#define IDS_DATA_SHARING_SHARED_GROUPS_FEEDBACK_IPH_SCREENREADER 13202
#define IDS_DATA_SHARING_LEARN_ABOUT_SHARED_GROUPS 13203
#define IDS_DATA_SHARING_PEOPLE_WITH_ACCESS 13204
#define IDS_DATA_SHARING_LINK_EDIT_ACCESS 13205
#define IDS_DATA_SHARING_LINK_JOIN_TOGGLE 13206
#define IDS_DATA_SHARING_CANCEL 13207
#define IDS_DATA_SHARING_CLOSE 13208
#define IDS_DATA_SHARING_BACK 13209
#define IDS_DATA_SHARING_BLOCK 13210
#define IDS_DATA_SHARING_REMOVE 13211
#define IDS_DATA_SHARING_LEAVE_GROUP 13212
#define IDS_DATA_SHARING_KEEP_GROUP 13213
#define IDS_DATA_SHARING_DELETE_GROUP 13214
#define IDS_DATA_SHARING_LOADING 13215
#define IDS_DATA_SHARING_COPY_LINK_FAILED 13216
#define IDS_DATA_SHARING_YOU 13217
#define IDS_DATA_SHARING_OWNER 13218
#define IDS_DATA_SHARING_MEMBER_COUNT_SINGULAR 13219
#define IDS_DATA_SHARING_MEMBER_COUNT_PLURAL 13220
#define IDS_DATA_SHARING_TAB_COUNT_SINGULAR 13221
#define IDS_DATA_SHARING_TAB_COUNT_PLURAL 13222
#define IDS_DATA_SHARING_MORE_OPTIONS 13223
#define IDS_DATA_SHARING_MORE_OPTIONS_DESCRIPTION 13224
#define IDS_APP_MENU_RELOAD 13225
#define IDS_APP_MENU_NEW_WEB_PAGE 13226
#define IDS_APP_MENU_COPY_LINK 13227
#define IDS_APP_MENU_CREATE_QR_CODE 13228
#define IDS_APP_MENU_BUTTON_UPDATE 13229
#define IDS_APP_MENU_BUTTON_UPDATE_ALT1 13230
#define IDS_APP_MENU_BUTTON_UPDATE_ALT2 13231
#define IDS_APP_MENU_BUTTON_UPDATE_ALT3 13232
#define IDS_APP_MENU_BUTTON_ERROR 13233
#define IDS_APP_MENU_BUTTON_ACTION_REQUIRED 13234
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TITLE 13235
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TEXT 13236
#define IDS_MEDIA_SCREEN_AND_AUDIO_CAPTURE_CONFIRMATION_TEXT 13237
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_TEXT 13238
#define IDS_MEDIA_SCREEN_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 13239
#define IDS_MEDIA_WINDOW_CAPTURE_NOTIFICATION_TEXT 13240
#define IDS_MEDIA_WINDOW_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 13241
#define IDS_MEDIA_TAB_CAPTURE_NOTIFICATION_TEXT 13242
#define IDS_MEDIA_TAB_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 13243
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_HIDE 13244
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_SOURCE 13245
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_STOP 13246
#define IDS_PLATFORM_KEYS_SELECT_CERT_DIALOG_TEXT 13247
#define IDS_UNSAFE_FRAME_MESSAGE 13248
#define IDS_CLIENT_CERT_DIALOG_TITLE 13249
#define IDS_CLIENT_CERT_DIALOG_TEXT 13250
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TITLE 13251
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_ENROLLMENT 13252
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CLIENT_AUTH 13253
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_LIST_CERTS 13254
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_IMPORT 13255
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_EXPORT 13256
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_PASSWORD_FIELD 13257
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_OK_BUTTON_LABEL 13258
#define IDS_FR_ENABLE_LOGGING 13260
#define IDS_CRASHED_TAB_FEEDBACK_MESSAGE 13264
#define IDS_CRASHED_TAB_FEEDBACK_LINK 13265
#define IDS_KILLED_TAB_FEEDBACK_MESSAGE 13267
#define IDS_HIDE_ICONS_NOT_SUPPORTED 13268
#define IDS_RELAUNCH_BUTTON 13269
#define IDS_HELP_MANAGED_BY_YOUR_PARENT 13270
#define IDS_TOOLBAR_INFORM_SET_HOME_PAGE 13273
#define IDS_MANAGE_EXTENSIONS_SETTING_WINDOWS_TITLE 13274
#define IDS_CONTROLLED_SETTING_POLICY 486
#define IDS_CONTROLLED_SETTING_EXTENSION 13275
#define IDS_CONTROLLED_SETTING_EXTENSION_WITHOUT_NAME 13276
#define IDS_CONTROLLED_SETTING_RECOMMENDED 13277
#define IDS_CONTROLLED_SETTING_HAS_RECOMMENDATION 13278
#define IDS_CONTROLLED_SETTING_CHILD_RESTRICTION 13279
#define IDS_CONTROLLED_SETTING_PARENT 13280
#define IDS_EXTENSIONS_INSTALL_LOCATION_UNKNOWN 13281
#define IDS_EXTENSIONS_INSTALL_LOCATION_3RD_PARTY 13282
#define IDS_EXTENSIONS_INSTALL_LOCATION_ENTERPRISE 13283
#define IDS_EXTENSIONS_INSTALL_LOCATION_SHARED_MODULE 13284
#define IDS_EXTENSIONS_BLOCKLISTED_MALWARE 13285
#define IDS_EXTENSIONS_BLOCKLISTED_SECURITY_VULNERABILITY 13286
#define IDS_EXTENSIONS_BLOCKLISTED_CWS_POLICY_VIOLATION 13287
#define IDS_EXTENSIONS_BLOCKLISTED_POTENTIALLY_UNWANTED 13288
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING 13289
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING_LEARN_MORE 13290
#define IDS_EXTENSIONS_ACCESS_REQUESTS_LEARN_MORE 13291
#define IDS_UPLOAD_MOVE_TO_ACCOUNT_DIALOG_TITLE 13292
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_DIALOG_SUBTITLE 13293
#define IDS_BOOKMARK_UPLOAD_MOVE_TO_ACCOUNT_DIALOG_SUBTITLE 13294
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_DIALOG_OK_BUTTON_LABEL 13295
#define IDS_BOOKMARK_MOVE_TO_ACCOUNT_ICON_TOOLTIP 13296
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION 13297
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_TITLE 13298
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_EXPLANATION 13299
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_DEFAULT_TOOL_NAME 13300
#define IDS_RESET_PROFILE_SETTINGS_LOCALE 13301
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_URLS 13302
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_TYPE 13303
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE 13304
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE_IS_NTP 13305
#define IDS_RESET_PROFILE_SETTINGS_YES 13306
#define IDS_RESET_PROFILE_SETTINGS_NO 13307
#define IDS_RESET_PROFILE_SETTINGS_SHOW_HOME_BUTTON 13308
#define IDS_RESET_PROFILE_SETTINGS_DSE 13309
#define IDS_RESET_PROFILE_SETTINGS_EXTENSIONS 13310
#define IDS_RESET_PROFILE_SETTINGS_SHORTCUTS 13311
#define IDS_RESET_PROFILE_SETTINGS_PROCESSING_SHORTCUTS 13312
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_MONTH 13314
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_YEAR 13315
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT 13316
#define IDS_OMNIBOX_ICON_SEND_TAB_TO_SELF 447
#define IDS_OMNIBOX_TOOLTIP_SEND_TAB_TO_SELF 448
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_TODAY_SEND_TAB_TO_SELF 13318
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAY_SEND_TAB_TO_SELF 13319
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAYS_SEND_TAB_TO_SELF 13320
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_FROM_DEVICE 13321
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_TITLE 432
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_LABEL 13322
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_A11Y_NAME 431
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_HINT_TEXT 13323
#define IDS_MENU_SEND_TAB_TO_SELF 13324
#define IDS_SEND_TAB_TO_SELF 13325
#define IDS_SEND_TAB_TO_SELF_SENDING_ANNOUNCE 13328
#define IDS_SEND_TAB_TO_SELF_MANAGE_DEVICES_LINK 13329
#define IDS_SEND_TAB_TO_SELF_SIGN_IN_PROMO_LABEL 13330
#define IDS_SEND_TAB_TO_SELF_NO_TARGET_DEVICE_LABEL 13331
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_PAGE 13332
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_IMAGE 13333
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_LINK 13334
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_LABEL 449
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_TOOLTIP 450
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TITLE 13335
#define IDS_SHARING_HUB_GENERATE_QR_CODE_LABEL 13336
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_URL_TEXTFIELD_ACCESSIBLE_NAME 13337
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TOOLTIP 13338
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_DOWNLOAD_BUTTON_LABEL 13339
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_COPY_BUTTON_LABEL 13340
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_TOO_LONG 13341
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_UNKNOWN 13342
#define IDS_SHARING_HUB_TITLE 13343
#define IDS_SHARING_HUB_TOOLTIP 468
#define IDS_SHARING_HUB_SCREENSHOT_LABEL 13344
#define IDS_SHARING_HUB_COPY_LINK_LABEL 13345
#define IDS_SHARING_HUB_SAVE_PAGE_LABEL 13346
#define IDS_SHARING_HUB_MEDIA_ROUTER_LABEL 13347
#define IDS_SHARING_HUB_SHARE_LABEL 13348
#define IDS_BROWSER_SHARING_SCREENSHOT_POST_CAPTURE_TITLE 13349
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_DOWNLOAD_BUTTON_LABEL 13350
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_EDIT_BUTTON_LABEL 13351
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_SHARE_BUTTON_LABEL 13352
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SELECTION 13353
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CROP 13354
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_TEXT 13355
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ELLIPSE 13356
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_RECTANGLE 13357
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_LINE 13358
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ARROW 13359
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_BRUSH 13360
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_EMOJI 13361
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_HIGHLIGHTER 13362
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_UNDO 13363
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_REDO 13364
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_IN 13365
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_OUT 13366
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_COMMIT_CROP 13367
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_COMMIT_CROP 13368
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_CANCEL_CROP 13369
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CANCEL_CROP 13370
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_DOWNLOAD_IMAGE 13371
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_COPY 13372
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TITLE 13373
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_TEXT_CLEAR 13374
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_LEFT 13375
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_CENTER 13376
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_RIGHT 13377
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_NONE 13378
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_SMALL 13379
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_LARGE 13380
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_DEFAULT 13381
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_MONOSPACE 13382
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_ITALIC 13383
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_OUTLINE 13384
#define IDS_CONTEXT_MENU_PASTE_FROM_CLIPBOARD 13385
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT_UNKNOWN_DEVICE 13386
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT 13387
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT_UNKNOWN_DEVICE 13388
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT 13389
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_DESCRIPTION 13390
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_MULTIPLE_DEVICES 13391
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_SINGLE_DEVICE 13392
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_MULTIPLE_DEVICES 13393
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_SINGLE_DEVICE 13394
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE_UNKNOWN_DEVICE 13395
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE 13396
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_DESCRIPTION 13397
#define IDS_OMNIBOX_TOOLTIP_SHARED_CLIPBOARD 13398
#define IDS_COLLECTED_COOKIES_DIALOG_TITLE 13399
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_LABEL 13400
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_LABEL 13401
#define IDS_COLLECTED_COOKIES_BLOCKED_THIRD_PARTY_BLOCKING_ENABLED 13402
#define IDS_COLLECTED_COOKIES_ALLOW_BUTTON 13403
#define IDS_COLLECTED_COOKIES_SESSION_ONLY_BUTTON 13404
#define IDS_COLLECTED_COOKIES_BLOCK_BUTTON 13405
#define IDS_COLLECTED_COOKIES_ALLOW_RULE_CREATED 13406
#define IDS_COLLECTED_COOKIES_BLOCK_RULE_CREATED 13407
#define IDS_COLLECTED_COOKIES_SESSION_RULE_CREATED 13408
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_TAB_LABEL 13409
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_TAB_LABEL 13410
#define IDS_COLLECTED_COOKIES_ALLOWED_AUX_TEXT 13411
#define IDS_COLLECTED_COOKIES_BLOCKED_AUX_TEXT 13412
#define IDS_COLLECTED_COOKIES_CLEAR_ON_EXIT_AUX_TEXT 13413
#define IDS_COLLECTED_COOKIES_INFOBAR_MESSAGE 13414
#define IDS_COLLECTED_COOKIES_INFOBAR_BUTTON 13415
#define IDS_COLLECTED_COOKIES_PARTITIONED_COOKIE 13416
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_TITLE 13417
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SUBTITLE 13418
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SETTINGS_LINK 13419
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_TITLE 13420
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_SUBTITLE 13421
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_TITLE 13422
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_SUBTITLE 13423
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_EMPTY_STATE_LABEL 13424
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_RELATED_APPS_TITLE 13425
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_RELATED_APPS_SUBTITLE 13426
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_RELATED_APPS_SETTINGS_LINK_TOOLTIP 13427
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_MENU_ITEM 13428
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_THIRD_PARTY_MENU_ITEM 13429
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCK_MENU_ITEM 13430
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_MENU_ITEM 13431
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOWED_STATE_SUBTITLE 13432
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCKED_STATE_SUBTITLE 13433
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_STATE_SUBTITLE 13434
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_STATE_SUBTITLE 13435
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_SESSION_ONLY_STATE_SUBTITLE 13436
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_CONTEXT_MENU_TOOLTIP 13437
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_DELETE_BUTTON_TOOLTIP 13438
#define IDS_ACCNAME_INFOBAR_CONTAINER 476
#define IDS_ACCNAME_INFOBAR 13439
#define IDS_ONE_CLICK_BUBBLE_UNDO 13440
#define IDS_ONE_CLICK_SIGNIN_BUBBLE_MESSAGE 13441
#define IDS_ONE_CLICK_SIGNIN_DIALOG_OK_BUTTON 13442
#define IDS_ONE_CLICK_SIGNIN_DIALOG_UNDO_BUTTON 13443
#define IDS_ONE_CLICK_SIGNIN_DIALOG_ADVANCED 13444
#define IDS_ENTERPRISE_SIGNIN_CANCEL 13445
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_PROFILE 13446
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_WORK_PROFILE 13447
#define IDS_ENTERPRISE_SIGNIN_CONTINUE 13448
#define IDS_ENTERPRISE_SIGNIN_ALERT 13449
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_TITLE 13450
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_DESCRIPTION 13451
#define IDS_MANAGED_WITH_HYPERLINK 13454
#define IDS_MANAGED_BY_WITH_HYPERLINK 13455
#define IDS_PROFILE_MANAGED_BY_WITH_HYPERLINK 13456
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_WITH_HYPERLINK 13457
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_WITH_HYPERLINK 13458
#define IDS_BROWSER_AND_PROFILE_SAME_MANAGED_BY_WITH_HYPERLINK 13459
#define IDS_MANAGED_BY_PARENT_WITH_HYPERLINK 13460
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_TOOLTIP 13461
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_TOOLTIP 13462
#define IDS_COOKIES_COOKIE_EXPIRES_SESSION 13463
#define IDS_COOKIES_COOKIE_SENDFOR_ANY 13464
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE 13465
#define IDS_COOKIES_COOKIE_SENDFOR_SAME_SITE 13466
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE_SAME_SITE 13467
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_YES 13468
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_NO 13469
#define IDS_COOKIES_COOKIES 13470
#define IDS_COOKIES_WEB_DATABASES 13471
#define IDS_COOKIES_LOCAL_STORAGE 13472
#define IDS_COOKIES_SESSION_STORAGE 13473
#define IDS_COOKIES_INDEXED_DBS 13474
#define IDS_COOKIES_FILE_SYSTEMS 13475
#define IDS_COOKIES_FILE_SYSTEM_USAGE_NONE 13476
#define IDS_COOKIES_SERVICE_WORKER 13477
#define IDS_COOKIES_SERVICE_WORKERS 13478
#define IDS_COOKIES_SHARED_WORKERS 13479
#define IDS_COOKIES_CACHE_STORAGE 13480
#define IDS_APP_DEFAULT_PAGE_NAME 13481
#define IDS_APP_LAUNCHER_TAB_TITLE 13482
#define IDS_NEW_TAB_GUEST_SESSION_HEADING 13483
#define IDS_NEW_TAB_GUEST_SESSION_DESCRIPTION 13484
#define IDS_NEW_TAB_GUEST_SESSION_LEARN_MORE_ACCESSIBILITY_TEXT 13485
#define IDS_NEW_TAB_ENTERPRISE_GUEST_SESSION_LEARN_MORE_ACCESSIBILITY_TEXT 13486
#define IDS_NEW_TAB_TILE_GRID_ACCESSIBLE_DESCRIPTION 13487
#define IDS_NEW_TAB_APP_INSTALL_HINT_LABEL 13488
#define IDS_NEW_TAB_MOST_VISITED 13489
#define IDS_NEW_TAB_RESTORE_THUMBNAILS_SHORT_LINK 501
#define IDS_NEW_TAB_ATTRIBUTION_INTRO 568
#define IDS_NEW_TAB_THUMBNAIL_REMOVED_NOTIFICATION 13490
#define IDS_NEW_TAB_REMOVE_THUMBNAIL_TOOLTIP 13491
#define IDS_NEW_TAB_PAGE_SWITCHER_CHANGE_TITLE 13492
#define IDS_NEW_TAB_PAGE_SWITCHER_SAME_TITLE 13493
#define IDS_NEW_TAB_VOICE_AUDIO_ERROR 528
#define IDS_NEW_TAB_VOICE_CLOSE_TOOLTIP 529
#define IDS_NEW_TAB_VOICE_DETAILS 530
#define IDS_NEW_TAB_VOICE_LANGUAGE_ERROR 531
#define IDS_NEW_TAB_VOICE_LISTENING 533
#define IDS_NEW_TAB_VOICE_NETWORK_ERROR 534
#define IDS_NEW_TAB_VOICE_NO_TRANSLATION 535
#define IDS_NEW_TAB_VOICE_NO_VOICE 536
#define IDS_NEW_TAB_VOICE_OTHER_ERROR 537
#define IDS_NEW_TAB_VOICE_PERMISSION_ERROR 538
#define IDS_NEW_TAB_VOICE_LEARN_MORE_ACCESSIBILITY_LABEL 532
#define IDS_NEW_TAB_VOICE_READY 539
#define IDS_NEW_TAB_VOICE_TRY_AGAIN 540
#define IDS_NEW_TAB_VOICE_WAITING 542
#define IDS_NEW_TAB_VOICE_SEARCH_CLOSED 13494
#define IDS_NEW_TAB_APP_OPTIONS 13495
#define IDS_NEW_TAB_APP_DETAILS 13496
#define IDS_NEW_TAB_APP_CREATE_SHORTCUT 13497
#define IDS_NEW_TAB_APP_INSTALL_LOCALLY 13498
#define IDS_APP_CONTEXT_MENU_SHOW_INFO 13499
#define IDS_APP_CONTEXT_MENU_OPEN_PINNED 13500
#define IDS_APP_CONTEXT_MENU_OPEN_REGULAR 13501
#define IDS_APP_CONTEXT_MENU_OPEN_WINDOW 13502
#define IDS_APP_CONTEXT_MENU_OPEN_FULLSCREEN 13503
#define IDS_APP_CONTEXT_MENU_OPEN_MAXIMIZED 13504
#define IDS_APP_CONTEXT_MENU_OPEN_TAB 13505
#define IDS_APP_CONTEXT_MENU_RUN_ON_OS_LOGIN 13510
#define IDS_APPS_PAGE_DEPRECATED_APP_TITLE 13513
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_TITLE 13514
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_PROCEED_BUTTON 13515
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_CANCEL_BUTTON 13516
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_BODY_TEXT 13517
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_DEFAULT_BODY_TEXT 13518
#define IDS_SYNC_CONFIRMATION_SETTINGS_INFO 13519
#define IDS_SYNC_CONFIRMATION_CONFIRM_BUTTON_LABEL 13520
#define IDS_SYNC_CONFIRMATION_SETTINGS_BUTTON_LABEL 13521
#define IDS_SYNC_CONFIRMATION_REFRESHED_SETTINGS_BUTTON_LABEL 13522
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_TITLE 13523
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE 13524
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE_SIGNIN_INTERCEPT_V2 13525
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_BOOKMARKS 13526
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_READING_LIST 13527
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_AUTOFILL 13528
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_EXTENSIONS 13529
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_HISTORY_AND_MORE 13530
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_DESC 13531
#define IDS_SYNC_CONFIRMATION_WELCOME_TITLE_SIGNIN_INTERCEPT 13532
#define IDS_SYNC_CONFIRMATION_TURN_ON_SYNC_BUTTON_LABEL 13533
#define IDS_SYNC_DISABLED_CONFIRMATION_CHROME_SYNC_TITLE 13534
#define IDS_SYNC_DISABLED_CONFIRMATION_DETAILS 13535
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_LABEL 13536
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_MANAGED_ACCOUNT_SIGNOUT_DISALLOWED_LABEL 13537
#define IDS_SYNC_DISABLED_CONFIRMATION_UNDO_BUTTON_LABEL 13538
#define IDS_SYNC_LOADING_CONFIRMATION_TITLE 13539
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL 13540
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_AVATAR_BUTTON_SEPARATE_BROWSING_TEXT 13541
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_AVATAR_BUTTON_SWITCH_PROFILE_TEXT 13542
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CREATE_PROFILE_BUTTON_LABEL 13543
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_STAY_HERE_BUTTON_LABEL 13544
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_TITLE_SUPERVISED 13545
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_BUTTON_LABEL 13546
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_SWITCH_BUTTON_LABEL 13547
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_DESC_SUPERVISED 13548
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_CONTINUE_BUTTON_LABEL 13549
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_ACCEPT_TEXT 13550
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_BY_TOKEN 13551
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_DISCLAIMER 13552
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_BY_DISCLAIMER 13553
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TITLE_SIGNIN_REMINDER 13554
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_OK_BUTTON 13555
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_TITLE 13556
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_DELETE_AND_SIGNOUT_BUTTON 13557
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_TEXT_LINK 13558
#define IDS_SYNC_PASSPHRASE_DIALOG_FOOTER_LINK 13559
#define IDS_SYNC_PASSPHRASE_DIALOG_TITLE 13560
#define IDS_SYNC_PASSPHRASE_DIALOG_OK_BUTTON 13561
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_CLOSE 13562
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_PROFILE_NAME 13563
#define IDS_SIGNIN_ERROR_TITLE 13564
#define IDS_SIGNIN_ERROR_EMAIL_TITLE 13565
#define IDS_SIGNIN_ERROR_CLOSE_BUTTON_LABEL 13566
#define IDS_SIGNIN_ERROR_OK_BUTTON_LABEL 13567
#define IDS_SIGNIN_ERROR_SWITCH_BUTTON_LABEL 13568
#define IDS_SIGNIN_ACCESSIBLE_CLOSE_BUTTON 13569
#define IDS_SIGNIN_ACCESSIBLE_BACK_BUTTON 13570
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_TITLE 13571
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_SUBTITLE 13572
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_TITLE 13573
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_SUBTITLE 13574
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CLOSE_BUTTON_LABEL 13575
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CONFIRM_BUTTON_LABEL 13576
#define IDS_PLUGIN_CRASHED_PROMPT 13577
#define IDS_PLUGIN_DISCONNECTED_PROMPT 13578
#define IDS_RELOAD_PAGE_WITH_PLUGIN 13579
#define IDS_PLUGIN_INITIALIZATION_ERROR_PROMPT 13580
#define IDS_EXTERNAL_PROTOCOL_TITLE 13581
#define IDS_EXTERNAL_PROTOCOL_MESSAGE_WITH_INITIATING_ORIGIN 13582
#define IDS_EXTERNAL_PROTOCOL_MESSAGE 13583
#define IDS_EXTERNAL_PROTOCOL_OK_BUTTON_TEXT 13584
#define IDS_EXTERNAL_PROTOCOL_CANCEL_BUTTON_TEXT 13585
#define IDS_EXTERNAL_PROTOCOL_CHECKBOX_PER_ORIGIN_TEXT 13586
#define IDS_DIRECTORY_LISTING_HEADER 13588
#define IDS_DIRECTORY_LISTING_PARENT 13589
#define IDS_DIRECTORY_LISTING_NAME 13590
#define IDS_DIRECTORY_LISTING_SIZE 13591
#define IDS_DIRECTORY_LISTING_DATE_MODIFIED 13592
#define IDS_SAVE_PAGE_DESC_HTML_ONLY 13593
#define IDS_SAVE_PAGE_DESC_SINGLE_FILE 13594
#define IDS_SAVE_PAGE_DESC_COMPLETE 13595
#define IDS_PROFILE_ERROR_DIALOG_TITLE 13596
#define IDS_COULDNT_OPEN_PROFILE_ERROR 13597
#define IDS_OPEN_PROFILE_DATA_LOSS 13598
#define IDS_PROFILE_ERROR_DIALOG_CHECKBOX 13599
#define IDS_PROFILE_ERROR_FEEDBACK_DESCRIPTION 13600
#define IDS_COULDNT_STARTUP_PROFILE_ERROR 13601
#define IDS_REFUSE_TO_RUN_AS_ROOT 13602
#define IDS_REFUSE_TO_RUN_AS_ROOT_2 13603
#define IDS_PROFILE_ON_NETWORK_WARNING 13604
#define IDS_CANT_WRITE_USER_DIRECTORY_TITLE 13605
#define IDS_RECENT_TABS_MENU 13606
#define IDS_RECENTLY_CLOSED_WINDOW 13607
#define IDS_RECENTLY_CLOSED_GROUP 13608
#define IDS_RECENTLY_CLOSED_GROUP_UNNAMED 13609
#define IDS_RECENT_TABS_NO_DEVICE_TABS 13610
#define IDS_RECENT_TABS_LOGIN_FOR_DEVICE_TABS 13611
#define IDS_RECENT_TABS_SEE_DEVICE_TABS 13612
#define IDS_HISTORY_MENU 13613
#define IDS_DEFAULT_DOWNLOAD_FILENAME 13614
#define IDS_DEFAULT_BROWSER_INFOBAR_OK_BUTTON_LABEL 13616
#define IDS_USED_EXISTING_BROWSER 13622
#define IDS_DECLINE_RECOVERY 13623
#define IDS_SYNC_ACCOUNT_SYNCING 13624
#define IDS_SYNC_ACCOUNT_SYNCING_CUSTOM_DATA_TYPES 13625
#define IDS_SIGNIN_ERROR_DISPLAY_SOURCE 13626
#define IDS_SIGNIN_ERROR_BUBBLE_VIEW_TITLE 13627
#define IDS_SYNC_ERROR_BUBBLE_VIEW_TITLE 13628
#define IDS_SYNC_ERROR_PASSWORDS_BUBBLE_VIEW_TITLE 13629
#define IDS_SYNC_ERROR_USER_MENU_TITLE 13630
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_ERROR_DESCRIPTION 13631
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_MENU_ERROR_DESCRIPTION 13632
#define IDS_SYNC_NEEDS_VERIFICATION_BUBBLE_VIEW_TITLE 13633
#define IDS_SYNC_ERROR_USER_MENU_CONFIRM_SYNC_SETTINGS_BUTTON 13634
#define IDS_SYNC_ERROR_USER_MENU_SIGNOUT_BUTTON 13635
#define IDS_SYNC_ERROR_USER_MENU_CONFIRM_SYNC_SETTINGS_BUTTON_MAYBE_TITLE_CASE 13636
#define IDS_SYNC_ERROR_USER_MENU_SIGNOUT_BUTTON_MAYBE_TITLE_CASE 13637
#define IDS_SYNC_EMPTY_STRING 13643
#define IDS_SYNC_OVERVIEW 13644
#define IDS_SYNC_START_SYNC_BUTTON_LABEL 13645
#define IDS_SIGNED_IN_WITH_SYNC_DISABLED_BY_POLICY 13646
#define IDS_SYNC_SETTINGS_NOT_CONFIRMED 13648
#define IDS_SYNC_SETUP_IN_PROGRESS 13649
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR 13650
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR_NEEDS_SIGNOUT 13651
#define IDS_SYNC_STATUS_NEEDS_PASSWORD 13652
#define IDS_SYNC_STATUS_NEEDS_PASSWORD_BUTTON 13653
#define IDS_SYNC_STATUS_NEEDS_KEYS_BUTTON 13654
#define IDS_SYNC_STATUS_NEEDS_PASSWORD_BUTTON_MAYBE_TITLE_CASE 13655
#define IDS_SYNC_STATUS_NEEDS_KEYS_BUTTON_MAYBE_TITLE_CASE 13656
#define IDS_SYNC_RELOGIN_ERROR 13657
#define IDS_SYNC_RELOGIN_BUTTON 13658
#define IDS_SYNC_RELOGIN_BUTTON_MAYBE_TITLE_CASE 13659
#define IDS_SYNC_ADVANCED_OPTIONS 13661
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM 13663
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM_WITH_DATE 13664
#define IDS_SYNC_FULL_ACCOUNT_DATA_ENCRYPTION_BODY_CUSTOM 13665
#define IDS_SYNC_FULL_ACCOUNT_DATA_ENCRYPTION_BODY_CUSTOM_WITH_DATE 13666
#define IDS_PARTIAL_TRANSLATE_BUBBLE_WAITING_TITLE 13667
#define IDS_TRANSLATE_BUBBLE_BEFORE_TRANSLATE_TITLE 13668
#define IDS_TRANSLATE_BUBBLE_TRANSLATED_TITLE 13669
#define IDS_PARTIAL_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 13670
#define IDS_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 13671
#define IDS_TRANSLATE_BUBBLE_SOURCE_LANG_COMBOBOX_ACCNAME 13672
#define IDS_TRANSLATE_BUBBLE_TARGET_LANG_COMBOBOX_ACCNAME 13673
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_COMPLETE_ANNOUNCEMENT 13674
#define IDS_TRANSLATE_BUBBLE_ADVANCED_BUTTON 13675
#define IDS_TRANSLATE_BUBBLE_ADVANCED_MENU_BUTTON 13676
#define IDS_TRANSLATE_BUBBLE_CHANGE_TARGET_LANGUAGE 13677
#define IDS_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 13678
#define IDS_TRANSLATE_BUBBLE_OPEN_LANGUAGE_SETTINGS 13679
#define IDS_PARTIAL_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 13680
#define IDS_TRANSLATE_BUBBLE_ACCEPT 13681
#define IDS_TRANSLATE_BUBBLE_DENY 13682
#define IDS_TRANSLATE_BUBBLE_ALWAYS_TRANSLATE_LANG 13683
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_LANG 13684
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_SITE 13685
#define IDS_TRANSLATE_BUBBLE_TRANSLATING 13686
#define IDS_TRANSLATE_BUBBLE_REVERT 13687
#define IDS_TRANSLATE_BUBBLE_TRY_AGAIN 13688
#define IDS_TRANSLATE_BUBBLE_ALWAYS 13689
#define IDS_TRANSLATE_BUBBLE_OPTIONS_MENU_BUTTON 13690
#define IDS_TRANSLATE_BUBBLE_PAGE_LANGUAGE 13691
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_LANGUAGE 13692
#define IDS_TRANSLATE_BUBBLE_ADVANCED_TARGET 13693
#define IDS_TRANSLATE_BUBBLE_ADVANCED_SOURCE 13694
#define IDS_PARTIAL_TRANSLATE_BUBBLE_ADVANCED_SOURCE 13695
#define IDS_PARTIAL_TRANSLATE_BUBBLE_TRANSLATE_FULL_PAGE 13696
#define IDS_TRANSLATE_BUBBLE_RESET 13697
#define IDS_NOTIFICATION_BUTTON_SETTINGS 13698
#define IDS_NOTIFICATION_BUTTON_CLOSE 13699
#define IDS_NOTIFICATION_BUTTON_MORE 13700
#define IDS_NOTIFICATION_REPLY_PLACEHOLDER 13701
#define IDS_NOTIFICATION_MUTED_MESSAGE 13702
#define IDS_NOTIFICATION_MUTED_TITLE 13703
#define IDS_NOTIFICATION_MUTED_ACTION_SHOW 13704
#define IDS_NOTIFICATION_MUTED_ACTION_SNOOZE 13705
#define IDS_ALLOWED_GEOLOCATION_TITLE 13848
#define IDS_BLOCKED_GEOLOCATION_TITLE 13849
#define IDS_ALLOWED_GEOLOCATION_MESSAGE 13850
#define IDS_ALLOWED_GEOLOCATION_BLOCK 13851
#define IDS_ALLOWED_GEOLOCATION_NO_ACTION 13852
#define IDS_BLOCKED_GEOLOCATION_MESSAGE 13853
#define IDS_BLOCKED_GEOLOCATION_UNBLOCK 13854
#define IDS_BLOCKED_GEOLOCATION_NO_ACTION 13855
#define IDS_GEOLOCATION 13856
#define IDS_GEOLOCATION_WILL_ASK_AGAIN 13857
#define IDS_GEOLOCATION_TURNED_OFF_IN_OS 13858
#define IDS_GEOLOCATION_TURNED_OFF 13859
#define IDS_ALLOWED_MIDI_SYSEX_TITLE 13860
#define IDS_BLOCKED_MIDI_SYSEX_TITLE 13861
#define IDS_ALLOWED_MIDI_SYSEX_MESSAGE 13862
#define IDS_ALLOWED_MIDI_SYSEX_BLOCK 13863
#define IDS_ALLOWED_MIDI_SYSEX_NO_ACTION 13864
#define IDS_BLOCKED_MIDI_SYSEX_MESSAGE 13865
#define IDS_BLOCKED_MIDI_SYSEX_UNBLOCK 13866
#define IDS_BLOCKED_MIDI_SYSEX_NO_ACTION 13867
#define IDS_MICROPHONE_CAMERA_ALLOWED 13868
#define IDS_MICROPHONE_CAMERA_BLOCKED 13869
#define IDS_MICROPHONE_ACCESSED 13870
#define IDS_CAMERA_ACCESSED 13871
#define IDS_MICROPHONE_BLOCKED 13872
#define IDS_CAMERA_BLOCKED 13873
#define IDS_MICROPHONE_CAMERA_ALLOWED_TITLE 13874
#define IDS_MICROPHONE_CAMERA_BLOCKED_TITLE 13875
#define IDS_MICROPHONE_ACCESSED_TITLE 13876
#define IDS_CAMERA_ACCESSED_TITLE 13877
#define IDS_MICROPHONE_BLOCKED_TITLE 13878
#define IDS_CAMERA_BLOCKED_TITLE 13879
#define IDS_MEDIASTREAM_SETTING_CHANGED_MESSAGE 13880
#define IDS_TURNED_OFF 13888
#define IDS_OPEN_SETTINGS_LINK 13889
#define IDS_A11Y_OMNIBOX_CHIP_HINT 443
#define IDS_A11Y_INDICATORS_ANNOUNCEMENT 13890
#define IDS_MICROPHONE_CAMERA_IN_USE 13891
#define IDS_MICROPHONE_CAMERA_NOT_ALLOWED 13892
#define IDS_MICROPHONE_IN_USE 13893
#define IDS_CAMERA_IN_USE 13894
#define IDS_MICROPHONE_NOT_ALLOWED 13895
#define IDS_CAMERA_NOT_ALLOWED 13896
#define IDS_CAMERA_CANNOT_ACCESS 13897
#define IDS_MICROPHONE_CANNOT_ACCESS 13898
#define IDS_CAMERA_MICROPHONE_CANNOT_ACCESS 13899
#define IDS_MANAGE_PASSWORDS_CONFIRM_GENERATED_TEXT 13900
#define IDS_PASSWORDS_WEB_LINK 13901
#define IDS_MANAGE_PASSWORDS_LINK 13903
#define IDS_MANAGE_PASSWORDS_TITLE 13904
#define IDS_MANAGE_PASSWORDS_NO_PASSWORDS_TITLE 13905
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_TITLE 13906
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_NO_PASSWORDS_TITLE 13907
#define IDS_MANAGE_PASSWORDS_SHOW_PASSWORD 13908
#define IDS_MANAGE_PASSWORDS_HIDE_PASSWORD 13909
#define IDS_MANAGE_PASSWORDS_EMPTY_NOTE 13910
#define IDS_MANAGE_PASSWORDS_EDIT_USERNAME_TOOLTIP 13911
#define IDS_MANAGE_PASSWORDS_EDIT_NOTE_TOOLTIP 13912
#define IDS_MANAGE_PASSWORDS_NOTE_ACCESSIBLE_NAME 13913
#define IDS_MANAGE_PASSWORDS_NOTE_TEXTFIELD 13914
#define IDS_MANAGE_PASSWORDS_UPDATE 13915
#define IDS_MANAGE_PASSWORDS_USERNAME_ACCESSIBLE_NAME 13916
#define IDS_MANAGE_PASSWORDS_USERNAME_TEXTFIELD 13917
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE_MD 13918
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_MANY_DEVICES 13919
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_LOCAL_DEVICE 13920
#define IDS_AUTO_SIGNIN_FIRST_RUN_TEXT 13921
#define IDS_AUTO_SIGNIN_FIRST_RUN_OK 13922
#define IDS_FILE_SELECTION_DIALOG_INFOBAR 13931
#define IDS_IMAGE_FILES 13934
#define IDS_AUDIO_FILES 13935
#define IDS_VIDEO_FILES 13936
#define IDS_CUSTOM_FILES 13937
#define IDS_SENSORS_ALLOWED_TOOLTIP 13938
#define IDS_MOTION_SENSORS_ALLOWED_TOOLTIP 13939
#define IDS_SENSORS_BLOCKED_TOOLTIP 13940
#define IDS_MOTION_SENSORS_BLOCKED_TOOLTIP 13941
#define IDS_BLOCKED_SENSORS_UNBLOCK 13942
#define IDS_BLOCKED_SENSORS_NO_ACTION 13943
#define IDS_ALLOWED_SENSORS_TITLE 13944
#define IDS_BLOCKED_SENSORS_TITLE 13945
#define IDS_ALLOWED_SENSORS_MESSAGE 13946
#define IDS_ALLOWED_MOTION_SENSORS_MESSAGE 13947
#define IDS_BLOCKED_SENSORS_MESSAGE 13948
#define IDS_BLOCKED_MOTION_SENSORS_MESSAGE 13949
#define IDS_ALLOWED_SENSORS_NO_ACTION 13950
#define IDS_ALLOWED_SENSORS_BLOCK 13951
#define IDS_LIVE_CAPTION_PROMO 13958
#define IDS_LIVE_CAPTION_PROMO_SCREENREADER 13959
#define IDS_ENABLE_CARET_BROWSING_INFO 13960
#define IDS_CARET_BROWSING_DO_NOT_ASK 13967
#define IDS_ENABLE_CARET_BROWSING_TITLE 13968
#define IDS_ENABLE_CARET_BROWSING_TURN_ON 13969
#define IDS_MEDIA_GALLERIES_DIALOG_HEADER 13970
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_WRITE 13971
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_DELETE 13972
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_ONLY 13973
#define IDS_MEDIA_GALLERIES_PERMISSION_SUGGESTIONS 13974
#define IDS_MEDIA_GALLERIES_LAST_ATTACHED 13975
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY 13976
#define IDS_MEDIA_GALLERIES_DIALOG_CONFIRM 13977
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY_TITLE 13978
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_ATTACHED 13979
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_NOT_ATTACHED 13980
#define IDS_MEDIA_GALLERIES_DIALOG_DELETE 13981
#define IDS_CHROME_SHORTCUT_DESCRIPTION 14003
#define IDS_WEBSTORE_NAME_STORE 378
#define IDS_DESKTOP_MEDIA_PICKER_TITLE 14004
#define IDS_DISPLAY_MEDIA_PICKER_TITLE 14005
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_SCREEN_ONLY 14006
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WINDOW_ONLY 14007
#define IDS_DESKTOP_MEDIA_PICKER_TEXT 14008
#define IDS_DISPLAY_MEDIA_PICKER_TEXT 14009
#define IDS_DESKTOP_MEDIA_PICKER_TEXT_DELEGATED 14010
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_SCREEN_WITH_MUTE_WARNING 14011
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_SYSTEM_AUDIO 14012
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_APPLICATION_AUDIO 14013
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_ALL_AUDIO_OUTPUT 14014
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_TAB_AUDIO 14015
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB 14016
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB_OR_SCREEN 14017
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB_OR_WINDOW 14018
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_SCREEN 14019
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_WINDOW 14020
#define IDS_DESKTOP_MEDIA_PICKER_SINGLE_SCREEN_NAME 14021
#define IDS_DESKTOP_MEDIA_PICKER_MULTIPLE_SCREEN_NAME 14022
#define IDS_DESKTOP_MEDIA_PICKER_MANAGED 14023
#define IDS_DESKTOP_MEDIA_PICKER_PERMISSION_BUTTON_MAC 14024
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_SCREEN 14025
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_WINDOW 14026
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_THIS_TAB 14027
#define IDS_DESKTOP_MEDIA_PICKER_EMPTY_PREVIEW 14028
#define IDS_DESKTOP_MEDIA_PICKER_PREVIEW_ACCESSIBLE_NAME 14029
#define IDS_DESKTOP_MEDIA_SOURCE_EMPTY_ACCESSIBLE_NAME 14030
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_WINDOW_TEXT 14031
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_WINDOW_BUTTON 14032
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_SCREEN_TEXT 14033
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_SCREEN_BUTTON 14034
#define IDS_SHARE_THIS_TAB_DIALOG_TITLE 14035
#define IDS_SHARE_THIS_TAB_DIALOG_TEXT 14036
#define IDS_SHARE_THIS_TAB_DIALOG_ALLOW 14037
#define IDS_SHARE_THIS_TAB_AUDIO_SHARE 14038
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TITLE 14039
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TEXT 14040
#define IDS_TOOLTIP_TAB_ALERT_STATE_MEDIA_RECORDING 14041
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_RECORDING 14042
#define IDS_TOOLTIP_TAB_ALERT_STATE_VIDEO_RECORDING 14043
#define IDS_TOOLTIP_TAB_ALERT_STATE_TAB_CAPTURING 14044
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_PLAYING 14045
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_MUTING 14046
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_CONNECTED 14047
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_SCAN_ACTIVE 14048
#define IDS_TOOLTIP_TAB_ALERT_STATE_USB_CONNECTED 14049
#define IDS_TOOLTIP_TAB_ALERT_STATE_HID_CONNECTED 14050
#define IDS_TOOLTIP_TAB_ALERT_STATE_SERIAL_CONNECTED 14051
#define IDS_TOOLTIP_TAB_ALERT_STATE_PIP_PLAYING 14052
#define IDS_TOOLTIP_TAB_ALERT_STATE_DESKTOP_CAPTURING 14053
#define IDS_TOOLTIP_TAB_ALERT_STATE_VR_PRESENTING 14054
#define IDS_TAB_AX_LABEL_MEDIA_RECORDING_FORMAT 14055
#define IDS_TAB_AX_LABEL_AUDIO_RECORDING_FORMAT 14056
#define IDS_TAB_AX_LABEL_VIDEO_RECORDING_FORMAT 14057
#define IDS_TAB_AX_LABEL_TAB_CAPTURING_FORMAT 14058
#define IDS_TAB_AX_LABEL_PIP_PLAYING_FORMAT 14059
#define IDS_TAB_AX_LABEL_AUDIO_PLAYING_FORMAT 14060
#define IDS_TAB_AX_LABEL_AUDIO_MUTING_FORMAT 14061
#define IDS_TAB_AX_LABEL_BLUETOOTH_CONNECTED_FORMAT 14062
#define IDS_TAB_AX_LABEL_BLUETOOTH_SCAN_ACTIVE_FORMAT 14063
#define IDS_TAB_AX_LABEL_USB_CONNECTED_FORMAT 14064
#define IDS_TAB_AX_LABEL_HID_CONNECTED_FORMAT 14065
#define IDS_TAB_AX_LABEL_SERIAL_CONNECTED_FORMAT 14066
#define IDS_TAB_AX_LABEL_NETWORK_ERROR_FORMAT 14067
#define IDS_TAB_AX_LABEL_CRASHED_FORMAT 14068
#define IDS_TAB_AX_LABEL_DESKTOP_CAPTURING_FORMAT 14069
#define IDS_TAB_AX_LABEL_VR_PRESENTING 14070
#define IDS_TAB_AX_LABEL_SPLIT_TAB_LEFT_VIEW_FORMAT 14071
#define IDS_TAB_AX_LABEL_SPLIT_TAB_RIGHT_VIEW_FORMAT 14072
#define IDS_TAB_AX_LABEL_UNNAMED_GROUP_FORMAT 14073
#define IDS_TAB_AX_LABEL_NAMED_GROUP_FORMAT 14074
#define IDS_TAB_AX_LABEL_PINNED_FORMAT 14075
#define IDS_TAB_AX_LABEL_PERMISSION_REQUESTED_FORMAT 14076
#define IDS_GROUP_AX_LABEL_UNNAMED_GROUP_FORMAT 14077
#define IDS_GROUP_AX_LABEL_NAMED_GROUP_FORMAT 14078
#define IDS_GROUP_AX_LABEL_COLLAPSED 14079
#define IDS_GROUP_AX_LABEL_EXPANDED 14080
#define IDS_GROUP_AX_LABEL_UNNAMED_SAVED_GROUP_FORMAT 14081
#define IDS_GROUP_AX_LABEL_NAMED_SAVED_GROUP_FORMAT 14082
#define IDS_GROUP_AX_LABEL_GROUP_MENU_ITEM_FORMAT 14083
#define IDS_SAVED_GROUP_AX_LABEL_OPENED 14084
#define IDS_SAVED_GROUP_AX_LABEL_CLOSED 14085
#define IDS_SAVED_GROUP_AX_LABEL_SHARED 14086
#define IDS_TAB_AX_ANNOUNCE_MOVED_RIGHT 14087
#define IDS_TAB_AX_ANNOUNCE_MOVED_LEFT 14088
#define IDS_TAB_AX_ANNOUNCE_MOVED_FIRST 14089
#define IDS_TAB_AX_ANNOUNCE_MOVED_LAST 14090
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_UNNAMED_GROUP 14091
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_NAMED_GROUP 14092
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_UNNAMED_GROUP 14093
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_NAMED_GROUP 14094
#define IDS_PAGE_LOADING_AX_TITLE_FORMAT 14095
#define IDS_TAB_AX_INACTIVE_TAB 14096
#define IDS_TAB_AX_MEMORY_SAVINGS 14097
#define IDS_TAB_AX_MEMORY_USAGE 14098
#define IDS_TAB_AX_HIGH_MEMORY_USAGE 14099
#define IDS_PROFILE_IN_USE_LINUX_QUIT 14100
#define IDS_PROFILE_IN_USE_LINUX_RELAUNCH 14101
#define IDS_DESKTOP_MEDIA_PICKER_SHARE 14119
#define IDS_PUSH_MESSAGING_GENERIC_NOTIFICATION_BODY 14120
#define IDS_DEVICE_PERMISSIONS_DIALOG_SELECT 14121
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL 14122
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL_TOOLTIP 14123
#define IDS_DEVICE_LOG_TITLE 14124
#define IDS_DEVICE_AUTO_REFRESH 14125
#define IDS_DEVICE_SELECT_TYPES 14126
#define IDS_DEVICE_LOG_REFRESH 14127
#define IDS_DEVICE_LOG_CLEAR 14128
#define IDS_DEVICE_LOG_CLEAR_TYPES 14129
#define IDS_DEVICE_LOG_NO_ENTRIES 14130
#define IDS_DEVICE_LOG_LEVEL_LABEL 14131
#define IDS_DEVICE_LOG_LEVEL_ERROR 14132
#define IDS_DEVICE_LOG_LEVEL_USER 14133
#define IDS_DEVICE_LOG_LEVEL_EVENT 14134
#define IDS_DEVICE_LOG_LEVEL_DEBUG 14135
#define IDS_DEVICE_LOG_TYPE_LOGIN 14136
#define IDS_DEVICE_LOG_TYPE_NETWORK 14137
#define IDS_DEVICE_LOG_TYPE_POWER 14138
#define IDS_DEVICE_LOG_TYPE_BLUETOOTH 14139
#define IDS_DEVICE_LOG_TYPE_USB 14140
#define IDS_DEVICE_LOG_TYPE_HID 14141
#define IDS_DEVICE_LOG_TYPE_PRINTER 14142
#define IDS_DEVICE_LOG_TYPE_FIDO 14143
#define IDS_DEVICE_LOG_TYPE_SERIAL 14144
#define IDS_DEVICE_LOG_TYPE_CAMERA 14145
#define IDS_DEVICE_LOG_TYPE_GEOLOCATION 14146
#define IDS_DEVICE_LOG_TYPE_EXTENSIONS 14147
#define IDS_DEVICE_LOG_TYPE_DISPLAY 14148
#define IDS_DEVICE_LOG_TYPE_FIRMWARE 14149
#define IDS_DEVICE_LOG_FILEINFO 14150
#define IDS_DEVICE_LOG_TIME_DETAIL 14151
#define IDS_DEVICE_LOG_ENTRY 14152
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION 14153
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION_TITLE 14154
#define IDS_WEBHID_SYSTEM_TRAY_ICON_HID_SETTINGS 14155
#define IDS_WEBHID_SYSTEM_TRAY_ICON_ABOUT_HID_DEVICE 14156
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_USB_SETTINGS 14157
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_ABOUT_USB_DEVICE 14158
#define IDS_DEVICE_CONNECTED_BY_EXTENSION 14161
#define IDS_DEFAULT_AUDIO_DEVICE_NAME 14170
#define IDS_COMMUNICATIONS_AUDIO_DEVICE_NAME 14171
#define IDS_SERIAL_DEVICE_CHOOSER_ADAPTER_OFF 14179
#define IDS_SERIAL_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 14180
#define IDS_SERIAL_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 14181
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN 14182
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN_TOOLTIP 14183
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_SCANNING_STATUS 14184
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_RE_SCAN_LINK 14185
#define IDS_DEVICE_CHOOSER_PAIRED_STATUS_TEXT 14186
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_AND_PAIRED_STATUS_TEXT 14187
#define IDS_DEVICE_CHOOSER_ACCNAME_COMPATIBLE_DEVICES_LIST 14188
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_NAME 14189
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_ID_AND_PRODUCT_ID 14190
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_NAME 14191
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_ID 14192
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_ID 14193
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_NAME 14194
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_ANY_VENDOR 14195
#define IDS_SERIAL_PORT_CHOOSER_PROMPT 14196
#define IDS_SERIAL_PORT_CHOOSER_CONNECT_BUTTON_TEXT 14197
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL 14198
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL_TOOLTIP 14199
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_NAME 14200
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_NAME 14201
#define IDS_SERIAL_PORT_CHOOSER_NAME_WITH_PATH 14202
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_ID 14203
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_ID 14204
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_ANY_PORT 14205
#define IDS_HID_CHOOSER_PROMPT 14206
#define IDS_HID_CHOOSER_ITEM_WITHOUT_NAME 14207
#define IDS_HID_CHOOSER_LOADING_LABEL 14208
#define IDS_HID_CHOOSER_LOADING_LABEL_TOOLTIP 14209
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID_AND_PRODUCT_ID 14210
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID 14211
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_AND_USAGE_PAGE 14212
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_PAGE 14213
#define IDS_HID_POLICY_DESCRIPTION_FOR_ANY_DEVICE 14214
#define IDS_WEB_APP_FILE_HANDLING_LIST_SEPARATOR 14215
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION 14216
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION_MULTIPLE 14217
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_STICKY_CHOICE 14218
#define IDS_WEB_APP_FILE_HANDLING_POSITIVE_BUTTON 14219
#define IDS_WEB_APP_FILE_HANDLING_NEGATIVE_BUTTON 14220
#define IDS_WEB_APP_PERMISSION_NEGATIVE_BUTTON 14221
#define IDS_PROTOCOL_HANDLER_INTENT_PICKER_QUESTION 14222
#define IDS_FONT_ACCESS_CHOOSER_PROMPT_ORIGIN 14223
#define IDS_FONT_ACCESS_CHOOSER_NO_FONTS_FOUND_PROMPT 14224
#define IDS_FONT_ACCESS_CHOOSER_IMPORT_BUTTON_TEXT 14225
#define IDS_FONT_ACCESS_CHOOSER_CANCEL_BUTTON_TEXT 14226
#define IDS_FONT_ACCESS_CHOOSER_SELECT_ALL_CHECKBOX_TEXT 14227
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL 14228
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL_TOOLTIP 14229
#define IDS_IME_API_ACTIVATED_WARNING 14230
#define IDS_IME_API_NEVER_SHOW 14231
#define IDS_BLOCKED_ADS_PROMPT_TOOLTIP 14232
#define IDS_UTILITY_PROCESS_UTILITY_WIN_NAME 14233
#define IDS_UTILITY_PROCESS_QUARANTINE_SERVICE_NAME 14234
#define IDS_REDIRECT_BLOCKED_MESSAGE 14235
#define IDS_REDIRECT_BLOCKED_TITLE 14236
#define IDS_REDIRECT_BLOCKED_TOOLTIP 14237
#define IDS_ALWAYS_ALLOW_REDIRECTS 14238
#define IDS_OPEN_REDIRECT 14239
#define IDS_UTILITY_PROCESS_SYSTEM_SIGNALS_NAME 14240
#define IDS_CONTROLLED_BY_AUTOMATION 14243
#define IDS_CHROME_FOR_TESTING_DISCLAIMER 14244
#define IDS_DOWNLOAD_CHROME 14245
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_TITLE 14247
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_MESSAGE 14248
#define IDS_CONFIRM_FILE_UPLOAD_TITLE 14249
#define IDS_CONFIRM_FILE_UPLOAD_TEXT 14250
#define IDS_CONFIRM_FILE_UPLOAD_OK_BUTTON 14251
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_TITLE 14252
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_ALLOW_TEXT 14253
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_FILE_TEXT 14254
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_DIRECTORY_TEXT 14255
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_FILE_TEXT 14256
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_DIRECTORY_TEXT 14257
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_FILE_TEXT 14258
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_DIRECTORY_TEXT 14259
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_FILE_TEXT 14260
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_DIRECTORY_TEXT 14261
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_TITLE 14262
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_TITLE 14263
#define IDS_FILE_SYSTEM_ACCESS_READ_FILE_PERMISSION_TITLE 14264
#define IDS_FILE_SYSTEM_ACCESS_READ_DIRECTORY_PERMISSION_TITLE 14265
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_ALLOW_TEXT 14266
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_ALLOW_TEXT 14267
#define IDS_FILE_SYSTEM_ACCESS_VIEW_FILE_PERMISSION_ALLOW_TEXT 14268
#define IDS_FILE_SYSTEM_ACCESS_VIEW_DIRECTORY_PERMISSION_ALLOW_TEXT 14269
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_CANCEL_TEXT 14270
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_CANCEL_TEXT 14271
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_CANCEL_TEXT 14272
#define IDS_FILE_SYSTEM_ACCESS_VIEW_FILE_PERMISSION_CANCEL_TEXT 14273
#define IDS_FILE_SYSTEM_ACCESS_VIEW_DIRECTORY_PERMISSION_CANCEL_TEXT 14274
#define IDS_FILE_SYSTEM_ACCESS_RESTORE_PERMISSION_DESCRIPTION 14275
#define IDS_FILE_SYSTEM_ACCESS_WRITE_USAGE_TOOLTIP 14276
#define IDS_FILE_SYSTEM_ACCESS_DIRECTORY_USAGE_TOOLTIP 457
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_FILE_TEXT 14277
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_TEXT 14278
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_DIRECTORY_TEXT 14279
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_DIRECTORIES_TEXT 14280
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_AND_DIRECTORIES_TEXT 14281
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_FILE_TEXT 14282
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_TEXT 14283
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_DIRECTORY_TEXT 14284
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_DIRECTORIES_TEXT 14285
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_AND_DIRECTORIES_TEXT 14286
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READ_AND_WRITE 14287
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SAVE_CHANGES 14288
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_VIEW_CHANGES 14289
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_FILES_TEXT 14290
#define IDS_FILE_SYSTEM_ACCESS_USAGE_EXPAND 14291
#define IDS_FILE_SYSTEM_ACCESS_USAGE_COLLAPSE 14292
#define IDS_FILE_SYSTEM_ACCESS_USAGE_REMOVE_ACCESS 14293
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_DIRECTORY_TITLE 14294
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_WRITABLE_DIRECTORY_TITLE 14295
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_SAVE_FILE_TITLE 14296
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_FILE_TITLE 14297
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_FILES_TITLE 14298
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TITLE 14299
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TEXT 14300
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_BUTTON 14301
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TITLE 14302
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TEXT 14303
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_BUTTON 14304
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TITLE 14305
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TEXT 14306
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_DONT_SAVE 14307
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_SAVE 14308
#define IDS_RELAUNCH_ACCEPT_BUTTON 14309
#define IDS_RELAUNCH_REQUIRED_CANCEL_BUTTON 14310
#define IDS_IDLE_TIMEOUT_INCOGNITO 14311
#define IDS_IDLE_TIMEOUT_CLOSE_COUNTDOWN 14312
#define IDS_IDLE_TIMEOUT_CLEAR_COUNTDOWN 14313
#define IDS_WEBAUTHN_GENERIC_TITLE 14314
#define IDS_WEBAUTHN_CONTINUE 14315
#define IDS_WEBAUTHN_TRANSPORT_USB 14316
#define IDS_WEBAUTHN_TRANSPORT_INTERNAL 14318
#define IDS_WEBAUTHN_TRANSPORT_CABLE 14319
#define IDS_WEBAUTHN_TRANSPORT_WINDOWS_HELLO_OR_SECURITY_KEY 14320
#define IDS_WEBAUTHN_TRANSPORT_WINDOWS_HELLO 14321
#define IDS_WEBAUTHN_TRANSPORT_ICLOUD_KEYCHAIN 14322
#define IDS_WEBAUTHN_TRANSPORT_EXTERNAL_SECURITY_KEY 14323
#define IDS_WEBAUTHN_USB_ACTIVATE_DESCRIPTION 14324
#define IDS_WEBAUTHN_ERROR_GENERIC_TITLE 14325
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_TITLE 14326
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_TITLE 14327
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_REGISTER_DESCRIPTION 14328
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_SIGN_DESCRIPTION 14329
#define IDS_WEBAUTHN_ERROR_TIMEOUT_DESCRIPTION 14330
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_TITLE 14331
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_DESCRIPTION 14332
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_TITLE 14333
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_DESCRIPTION 14334
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_TITLE 14335
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_DESCRIPTION 14336
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_TITLE 14337
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_DESCRIPTION 14338
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_NEXT 14339
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_TITLE 14340
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 14341
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_NEXT 14342
#define IDS_WEBAUTHN_LOADING 14343
#define IDS_WEBAUTHN_TRANSPORT_POPUP_PAIR_PHONE 14345
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE 14346
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE_DEVICE 14347
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION 14348
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DEVICE_NAME_DESCRIPTION 14349
#define IDS_WEBAUTHN_CABLEV2_CONNECTING_TITLE 14350
#define IDS_WEBAUTHN_CABLEV2_CONNECTED_DESCRIPTION 14351
#define IDS_WEBAUTHN_CABLEV2_ERROR_DESCRIPTION 14352
#define IDS_WEBAUTHN_CABLEV2_ERROR_CLOSE 14353
#define IDS_WEBAUTHN_PASSKEY_PHONE_OR_TABLET_LABEL 14354
#define IDS_WEBAUTHN_PASSKEY_PHONE_TABLET_OR_SECURITY_KEY_LABEL 14355
#define IDS_WEBAUTHN_PHONE_CONFIRMATION_TITLE 14356
#define IDS_WEBAUTHN_PIN_ENTRY_TITLE 14357
#define IDS_WEBAUTHN_PIN_ENTRY_DESCRIPTION 14358
#define IDS_WEBAUTHN_PIN_ENTRY_PIN_LABEL 14359
#define IDS_WEBAUTHN_PIN_ENTRY_NEXT 14360
#define IDS_WEBAUTHN_PIN_SETUP_DESCRIPTION 14361
#define IDS_WEBAUTHN_PIN_SETUP_CONFIRMATION_LABEL 14362
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_INVALID_CHARACTERS 14363
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_TOO_SHORT 14364
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED_RETRIES 14365
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED 14366
#define IDS_WEBAUTHN_PIN_SETUP_ERROR_FAILED 14367
#define IDS_WEBAUTHN_PIN_TAP_AGAIN_DESCRIPTION 14368
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_MISMATCH 14369
#define IDS_WEBAUTHN_CLIENT_PIN_SOFT_BLOCK_DESCRIPTION 14370
#define IDS_WEBAUTHN_CLIENT_PIN_HARD_BLOCK_DESCRIPTION 14371
#define IDS_WEBAUTHN_CLIENT_PIN_AUTHENTICATOR_REMOVED_DESCRIPTION 14372
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_SAME_AS_CURRENT 14373
#define IDS_WEBAUTHN_USE_PHONE_WITH_NAME 14374
#define IDS_WEBAUTHN_INLINE_ENROLLMENT_CANCEL_LABEL 14375
#define IDS_WEBAUTHN_UV_RETRY_TITLE 14376
#define IDS_WEBAUTHN_UV_RETRY_DESCRIPTION 14377
#define IDS_WEBAUTHN_UV_RETRY_ERROR_FAILED_RETRIES 14378
#define IDS_WEBAUTHN_UV_ERROR_LOCKED 14379
#define IDS_WEBAUTHN_FORCE_PIN_CHANGE 14380
#define IDS_WEBAUTHN_UNKNOWN_ACCOUNT 14381
#define IDS_WEBAUTHN_RESIDENT_KEY_PRIVACY 14382
#define IDS_WEBAUTHN_RESIDENT_KEY_PREFERRED_PRIVACY 14383
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_TITLE 14384
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_DESC 14385
#define IDS_WEBAUTHN_STORAGE_FULL_DESC 14386
#define IDS_WEBAUTHN_ATTESTATION_WARNING 14387
#define IDS_WEBAUTHN_ENTERPRISE_ATTESTATION_WARNING 14388
#define IDS_WEBAUTHN_RETRY 14389
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_TITLE 14390
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DESCRIPTION 14391
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DENY 14392
#define IDS_WEBAUTHN_MANAGE_DEVICES 14393
#define IDS_WEBAUTHN_CREATE_PASSKEY_TITLE 14394
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA 14395
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_INCOGNITO 14396
#define IDS_WEBAUTHN_CREATE_PASSKEY_CHOOSE_DEVICE_TITLE 14397
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_TITLE 14398
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_BODY 14399
#define IDS_WEBAUTHN_USE_PASSKEY_TITLE 14400
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_TITLE 14401
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_BODY 14402
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_TITLE 14403
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_BODY 14404
#define IDS_WEBAUTHN_USE_PASSKEY_QR_TITLE 14405
#define IDS_WEBAUTHN_USE_PASSKEY_QR_BODY 14406
#define IDS_WEBAUTHN_QR_CODE_ALT_TEXT 14407
#define IDS_WEBAUTHN_USE_A_DIFFERENT_PASSKEY 14408
#define IDS_WEBAUTHN_QR_CREATE_PASSKEY_ON_SECURITY_KEY_LABEL 14409
#define IDS_WEBAUTHN_QR_USE_PASSKEY_ON_SECURITY_KEY_LABEL 14410
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_FOR_RP_TITLE 14411
#define IDS_WEBAUTHN_THIS_DEVICE_LABEL 14412
#define IDS_WEBAUTHN_FROM_PHONE_LABEL 14413
#define IDS_WEBAUTHN_OTHER_DEVICES_LABEL 14414
#define IDS_WEBAUTHN_SOURCE_CHROME_PROFILE 14415
#define IDS_WEBAUTHN_SOURCE_ICLOUD_KEYCHAIN 14416
#define IDS_WEBAUTHN_SOURCE_WINDOWS_HELLO 14417
#define IDS_WEBAUTHN_SOURCE_GOOGLE_PASSWORD_MANAGER 14418
#define IDS_WEBAUTHN_SOURCE_USB_SECURITY_KEY 14419
#define IDS_WEBAUTHN_PASSKEYS_AND_SECURITY_KEYS 14420
#define IDS_WEBAUTHN_PASSKEYS 14421
#define IDS_WEBAUTHN_USE_YOUR_PHONE_OR_TABLET 14422
#define IDS_WEBAUTHN_USE_YOUR_PHONE_OR_TABLET_CREATE_DESCRIPTION 14423
#define IDS_WEBAUTHN_USE_YOUR_PHONE_OR_TABLET_SIGN_IN_DESCRIPTION 14424
#define IDS_WEBAUTHN_USE_YOUR_SECURITY_KEY 14425
#define IDS_WEBAUTHN_USE_YOUR_SECURITY_KEY_CREATE_DESCRIPTION 14426
#define IDS_WEBAUTHN_USE_YOUR_SECURITY_KEY_SIGN_IN_DESCRIPTION 14427
#define IDS_WEBAUTHN_CREATE 14428
#define IDS_WEBAUTHN_CREATE_PASSKEY 14429
#define IDS_WEBAUTHN_GPM_CREATE_PASSKEY_TITLE 14430
#define IDS_WEBAUTHN_GPM_CREATE_PASSKEY_DESC 14431
#define IDS_WEBAUTHN_SAVE_ANOTHER_WAY 14432
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_CREATION_TITLE 14433
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_CREATION_DESC 14434
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_ASSERTION_TITLE 14435
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_ASSERTION_DESC 14436
#define IDS_WEBAUTHN_USE_A_DIFFERENT_DEVICE 14437
#define IDS_WEBAUTHN_TOUCH_ID_ASSERTION_DESC 14438
#define IDS_WEBAUTHN_TOUCH_ID_CONTINUE 14439
#define IDS_WEBAUTHN_TOUCH_ID_LOCKED 14440
#define IDS_WEBAUTHN_TOUCH_ID_ENTER_PASSWORD 14441
#define IDS_WEBAUTHN_GPM_ERROR_TITLE 14442
#define IDS_WEBAUTHN_GPM_ERROR_DESC 14443
#define IDS_WEBAUTHN_SIGN_IN_AGAIN_TITLE 14444
#define IDS_WEBAUTHN_SIGN_IN_AGAIN_DESCRIPTION 14445
#define IDS_WEBAUTHN_GPM_INCOGNITO_CREATE_TITLE 14446
#define IDS_WEBAUTHN_GPM_INCOGNITO_CREATE_DESC 14447
#define IDS_WEBAUTHN_GPM_PIN_OPTION_NUMBERS 14448
#define IDS_WEBAUTHN_GPM_PIN_OPTION_ALPHANUMERIC 14449
#define IDS_WEBAUTHN_GPM_CREATE_PIN_TITLE 14450
#define IDS_WEBAUTHN_GPM_CREATE_ALPHANUMERIC_PIN_ACCESSIBILITY 14451
#define IDS_WEBAUTHN_GPM_CREATE_SIX_DIGIT_PIN_ACCESSIBILITY 14452
#define IDS_WEBAUTHN_GPM_CREATE_SIX_DIGIT_PIN_ACCESSIBILITY_WITH_FOCUSED_DIGIT 14453
#define IDS_WEBAUTHN_GPM_CREATE_PIN_DESC 14454
#define IDS_WEBAUTHN_GPM_ENTER_PIN_TITLE 14455
#define IDS_WEBAUTHN_GPM_ENTER_ALPHANUMERIC_PIN_ACCESSIBILITY 14456
#define IDS_WEBAUTHN_GPM_ENTER_ALPHANUMERIC_PIN_ACCESSIBILITY_WITH_WEBSITE 14457
#define IDS_WEBAUTHN_GPM_ENTER_SIX_DIGIT_PIN_ACCESSIBILITY 14458
#define IDS_WEBAUTHN_GPM_ENTER_SIX_DIGIT_PIN_ACCESSIBILITY_WITH_FOCUSED_DIGIT 14459
#define IDS_WEBAUTHN_GPM_ENTER_PIN_DESC 14460
#define IDS_WEBAUTHN_GPM_SIX_DIGIT_PIN_ACCESSIBILITY_LABEL 14461
#define IDS_WEBAUTHN_FORGOT_GPM_PIN_BUTTON 14462
#define IDS_WEBAUTHN_GPM_PIN_OPTIONS_BUTTON 14463
#define IDS_WEBAUTHN_GPM_WRONG_PIN_ERROR 14464
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_TITLE 14465
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_PIN_CREATED_TITLE 14466
#define IDS_WEBAUTHN_SHOW_PIN 14467
#define IDS_WEBAUTHN_HIDE_PIN 14468
#define IDS_WEBAUTHN_CHANGE_PIN 14469
#define IDS_WEBAUTHN_LOCKED_GPM_PIN_TITLE 14470
#define IDS_WEBAUTHN_LOCKED_GPM_PIN_DESCRIPTION 14471
#define IDS_WEBAUTHN_GPM_PIN_DIGIT_HINT 14472
#define IDS_WEBAUTHN_GPM_PIN_LENGTH_HINT 14473
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_LABEL 14474
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_LINK 14475
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATE_NEEDED_TITLE 14476
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATE_NEEDED_LABEL 14477
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATED_TITLE 14478
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATED_LABEL 14479
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATED_LINK 14480
#define IDS_WEBAUTHN_GPM_PASSKEY_DELETED_TITLE 14481
#define IDS_WEBAUTHN_GPM_PASSKEY_DELETED_LABEL 14482
#define IDS_WEBAUTHN_GPM_PASSKEY_DOESNT_WORK_LABEL 14483
#define IDS_WEBAUTHN_GPM_PASSKEY_DELETED_LINK 14484
#define IDS_WEBAUTHN_SIGN_IN_TO_WEBSITE_DIALOG_TITLE 14485
#define IDS_PASSKEY_UPGRADE_BUBBLE_TITLE 14486
#define IDS_PASSKEY_UPGRADE_BUBBLE_DESCRIPTION 14487
#define IDS_PASSKEY_UPGRADE_BUBBLE_LEARN_MORE 14488
#define IDS_PASSKEY_UPGRADE_BUBBLE_MANAGE_BUTTON 14489
#define IDS_WEB_DIGITAL_CREDENTIALS_BLUETOOTH_POWER_ON_MANUAL_TITLE 14490
#define IDS_WEB_DIGITAL_CREDENTIALS_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 14491
#define IDS_WEB_DIGITAL_CREDENTIALS_BLUETOOTH_POWER_ON_MANUAL_NEXT 14492
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_TITLE 14493
#define IDS_WEB_DIGITAL_CREDENTIALS_PRESENTATION_QR_BODY 14494
#define IDS_WEB_DIGITAL_CREDENTIALS_ISSUANCE_QR_BODY 14495
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_CODE_ALT_TEXT 14496
#define IDS_WEB_DIGITAL_CREDENTIALS_CABLEV2_CONNECTING_TITLE 14497
#define IDS_WEB_DIGITAL_CREDENTIALS_CABLEV2_CONNECTED_TITLE 14498
#define IDS_WEB_DIGITAL_CREDENTIALS_FLOW_CANCEL_BUTTON_TEXT 14499
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_DIALOG_TITLE 14500
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_LOW_RISK_DIALOG_TEXT 14501
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_LOW_RISK_NEGATIVE_BUTTON_TEXT 14502
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_HIGH_RISK_DIALOG_TEXT 14503
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_HIGH_RISK_NEGATIVE_BUTTON_TEXT 14504
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_POSITIVE_BUTTON_TEXT 14505
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_REQUEST_ABORTED_DIALOG_TEXT 14506
#define IDS_INCOGNITO_PROFILE_MENU_TITLE 14507
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON 14508
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_PRIMARY_TEXT 14509
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_SECONDARY_TEXT 14510
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_CLOSE_WINDOWS_BUTTON 14511
#define IDS_INCOGNITO_HISTORY_BUBBLE_PRIMARY_TEXT 14512
#define IDS_INCOGNITO_HISTORY_BUBBLE_SECONDARY_TEXT 14513
#define IDS_INCOGNITO_HISTORY_BUBBLE_CLOSE_INCOGNITO_BUTTON_TEXT 14514
#define IDS_INCOGNITO_HISTORY_BUBBLE_CANCEL_BUTTON_TEXT 14515
#define IDS_NOTIFICATION_DEFAULT_HELPFUL_BUTTON_TEXT 14516
#define IDS_NOTIFICATION_DEFAULT_UNHELPFUL_BUTTON_TEXT 14517
#define IDS_DEEP_SCANNING_DIALOG_TITLE 14518
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_PENDING_MESSAGE 14519
#define IDS_DEEP_SCANNING_DIALOG_PRINT_PENDING_MESSAGE 14520
#define IDS_DEEP_SCANNING_DIALOG_SUCCESS_MESSAGE 14521
#define IDS_DEEP_SCANNING_DIALOG_PRINT_SUCCESS_MESSAGE 14522
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAILURE_MESSAGE 14523
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAIL_CLOSED_MESSAGE 14524
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_WARNING_MESSAGE 14525
#define IDS_DEEP_SCANNING_DIALOG_PRINT_WARNING_MESSAGE 14526
#define IDS_DEEP_SCANNING_DIALOG_TIMEOUT_MESSAGE 14527
#define IDS_DEEP_SCANNING_DIALOG_PROCEED_BUTTON 14528
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_WARNING_BUTTON 14529
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_UPLOAD_BUTTON 14530
#define IDS_DEEP_SCANNING_DIALOG_LARGE_FILE_FAILURE_MESSAGE 14531
#define IDS_DEEP_SCANNING_DIALOG_LARGE_PRINT_FAILURE_MESSAGE 14532
#define IDS_DEEP_SCANNING_DIALOG_ENCRYPTED_FILE_FAILURE_MESSAGE 14533
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE 14534
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_CUSTOM_MESSAGE 14535
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE_LEARN_MORE_LINK 14536
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_DISCARD_FILE_BUTTON 14537
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_BYPASS_JUSTIFICATION_LABEL 14538
#define IDS_DEEP_SCANNING_DIALOG_PASTE_BYPASS_JUSTIFICATION_LABEL 14539
#define IDS_DEEP_SCANNING_DIALOG_PRINT_BYPASS_JUSTIFICATION_LABEL 14540
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOAD_BYPASS_JUSTIFICATION_LABEL 14541
#define IDS_DEEP_SCANNING_DIALOG_BYPASS_JUSTIFICATION_TEXT_LIMIT_LABEL 14542
#define IDS_DATA_SHARING_BUBBLE_DIALOG_TITLE 14543
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_TEXT 14544
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_CLOSE_BUTTON_ARIA_LABEL_TEXT 14545
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_TITLE 14546
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_TITLE 14547
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_MAIN_TEXT 14548
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_MAIN_TEXT 14549
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_ACCEPT_BUTTON 14550
#define IDS_TAILORED_SECURITY_DIALOG_SETTINGS_BUTTON 14551
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_TITLE 14552
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_BODY 14553
#define IDS_TAILORED_SECURITY_UNCONSENTED_ACCEPT_BUTTON 14554
#define IDS_TAILORED_SECURITY_UNCONSENTED_CANCEL_BUTTON 14555
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_TITLE 14556
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_DESCRIPTION 14557
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_TITLE 14558
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_DESCRIPTION 14559
#define IDS_TAILORED_SECURITY_CONSENTED_MESSAGE_OK_BUTTON 14560
#define IDS_TAILORED_SECURITY_CONSENTED_ENHANCED_PROTECTION_ENABLE_MESSAGE_TITLE 14561
#define IDS_PROMPT_APP_UNINSTALL_TITLE 14562
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_NON_GOOGLE 14563
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_GOOGLE 14564
#define IDS_APP_UNINSTALL_PROMPT_LEARN_MORE 14565
#define IDS_APP_UNINSTALL_PROMPT_ADDITIONAL_UNINSTALLS_MESSAGE 14566
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_TITLE 14567
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_DESCRIPTION 14568
#define IDS_UTILITY_PROCESS_SPEECH_RECOGNITION_SERVICE_NAME 14569
#define IDS_APP_PAUSE_PROMPT_TITLE 14570
#define IDS_APP_PAUSE_HEADING 14571
#define IDS_APP_PAUSE_HEADING_FOR_WEB_APPS 14572
#define IDS_APP_BLOCK_PROMPT_TITLE 14573
#define IDS_APP_BLOCK_HEADING_FOR_CHILD 14574
#define IDS_APP_BLOCK_HEADING 14575
#define IDS_APP_LOCAL_BLOCK_PROMPT_TITLE 14576
#define IDS_APP_LOCAL_BLOCK_PROMPT_MULTIPLE_TITLE 14577
#define IDS_APP_LOCAL_BLOCK_HEADING 14578
#define IDS_ENTERPRISE_EXTENSION_REQUEST_APPROVED_TITLE 14579
#define IDS_ENTERPRISE_EXTENSION_REQUEST_REJECTED_TITLE 14580
#define IDS_ENTERPRISE_EXTENSION_REQUEST_FORCE_INSTALLED_TITLE 14581
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_INSTALL 14582
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_VIEW 14583
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION 14584
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_PLACEHOLDER 14585
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_LENGTH_LIMIT 14586
#define IDS_NAME_WINDOW_PROMPT_TITLE 14587
#define IDS_NAME_WINDOW_PROMPT_FIELD_LABEL 14588
#define IDS_CHROMELABS_RELAUNCH_BUTTON_LABEL 14589
#define IDS_WINDOW_TITLE_EXPERIMENTS 14590
#define IDS_CHROMELABS_SEND_FEEDBACK 14591
#define IDS_CHROMELABS_SEND_FEEDBACK_DESCRIPTION_PLACEHOLDER 14592
#define IDS_CHROMELABS_DEFAULT 14593
#define IDS_CHROMELABS_ENABLED 14594
#define IDS_CHROMELABS_DISABLED 14595
#define IDS_CHROMELABS_ENABLED_WITH_VARIATION_NAME 14596
#define IDS_LENS_REGION_SEARCH_BUBBLE_TEXT 14597
#define IDS_CAPTURE_REGION_BUBBLE_TEXT 14598
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_NAME 14599
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_DESCRIPTION 14600
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_DESCRIPTION 14603
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_ACCEPT 14604
#define IDS_TAILORED_SECURITY_CONSENTED_PROMOTION_MESSAGE_TURN_ON 14605
#define IDS_TAILORED_SECURITY_CONSENTED_ESB_OFF_MESSAGE_TITLE 14606
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_IN 14607
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_UP 14608
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_USE 14609
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_CONTINUE 14610
#define IDS_ACCOUNT_SELECTION_SHEET_SUBTITLE_FOR_EMBED 14611
#define IDS_ACCOUNT_SELECTION_CONTINUE 14612
#define IDS_ACCOUNT_SELECTION_CHOOSE_AN_ACCOUNT 14613
#define IDS_ACCOUNT_SELECTION_CHOOSE_AN_ACCOUNT_BUTTON 14614
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_NAME 14615
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_EMAIL 14616
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_PICTURE 14617
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_PHONE 14618
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_USERNAME 14619
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP_OR_TOS 14620
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP 14621
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_TOS 14622
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT 14623
#define IDS_ACCOUNT_SELECTION_USE_OTHER_ACCOUNT 14624
#define IDS_ACCOUNT_SELECTION_USE_OTHER_ACCOUNT_MULTI_IDP 14625
#define IDS_ACCOUNT_SELECTION_OPENS_IN_NEW_TAB 14626
#define IDS_ACCOUNT_SELECTION_BACK 14627
#define IDS_SIGNIN_CONTINUE 14628
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_DIALOG_BODY 14629
#define IDS_SIGNIN_GENERIC_ERROR_DIALOG_SUMMARY 14630
#define IDS_SIGNIN_GENERIC_ERROR_DIALOG_DESCRIPTION 14631
#define IDS_SIGNIN_UNAUTHORIZED_CLIENT_ERROR_DIALOG_SUMMARY 14632
#define IDS_SIGNIN_UNAUTHORIZED_CLIENT_ERROR_DIALOG_DESCRIPTION 14633
#define IDS_SIGNIN_INVALID_REQUEST_ERROR_DIALOG_SUMMARY 14634
#define IDS_SIGNIN_INVALID_REQUEST_ERROR_DIALOG_DESCRIPTION 14635
#define IDS_SIGNIN_ACCESS_DENIED_ERROR_DIALOG_SUMMARY 14636
#define IDS_SIGNIN_ACCESS_DENIED_ERROR_DIALOG_DESCRIPTION 14637
#define IDS_SIGNIN_SERVER_ERROR_DIALOG_SUMMARY 14638
#define IDS_SIGNIN_SERVER_ERROR_DIALOG_DESCRIPTION 14639
#define IDS_SIGNIN_TEMPORARILY_UNAVAILABLE_ERROR_DIALOG_SUMMARY 14640
#define IDS_SIGNIN_TEMPORARILY_UNAVAILABLE_ERROR_DIALOG_DESCRIPTION 14641
#define IDS_SIGNIN_ERROR_DIALOG_GOT_IT_BUTTON 14642
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_BUTTON 14643
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_PROMPT 14644
#define IDS_SIGNIN_ERROR_DIALOG_TRY_OTHER_WAYS_PROMPT 14645
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_RETRY_PROMPT 14646
#define IDS_SIGNIN_ERROR_DIALOG_TRY_OTHER_WAYS_RETRY_PROMPT 14647
#define IDS_MULTI_IDP_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT 14648
#define IDS_MULTI_IDP_ACCOUNT_ORIGIN_AND_LAST_USED 14649
#define IDS_USED_ON_THIS_SITE 14650
#define IDS_VERIFY_SHEET_TITLE 14651
#define IDS_VERIFY_SHEET_TITLE_AUTO_REAUTHN 14652
#define IDS_AUTO_REAUTHN_OPTOUT_CHECKBOX 14653
#define IDS_FILTERED_ACCOUNT_MESSAGE 14654
#define IDS_BATTERY_SAVER_BUTTON_TOOLTIP 435
#define IDS_BATTERY_SAVER_BUTTON_ACCNAME 434
#define IDS_BATTERY_SAVER_BUBBLE_TITLE 14686
#define IDS_BATTERY_SAVER_BUBBLE_DESCRIPTION 14687
#define IDS_BATTERY_SAVER_SESSION_TURN_OFF 14688
#define IDS_MEMORY_SAVER_CHIP_LABEL 14689
#define IDS_MEMORY_SAVER_CHIP_ACCNAME 460
#define IDS_MEMORY_SAVER_CHIP_WITH_SAVINGS_ACCNAME 14690
#define IDS_MEMORY_SAVER_CHIP_SAVINGS_LABEL 14691
#define IDS_MEMORY_SAVER_DIALOG_TITLE 14692
#define IDS_MEMORY_SAVER_DIALOG_SETTINGS_BUTTON 14693
#define IDS_MEMORY_SAVER_DIALOG_SAVINGS_ACCNAME 14694
#define IDS_MEMORY_SAVER_DIALOG_BUTTON_ADD_TO_EXCLUSION_LIST 14695
#define IDS_MEMORY_SAVER_DIALOG_SAVINGS_LABEL 14696
#define IDS_MEMORY_SAVER_DIALOG_SMALL_SAVINGS_LABEL 14697
#define IDS_MEMORY_SAVER_DIALOG_MEDIUM_SAVINGS_LABEL 14698
#define IDS_MEMORY_SAVER_DIALOG_LARGE_SAVINGS_LABEL 14699
#define IDS_MEMORY_SAVER_DIALOG_VERY_LARGE_SAVINGS_LABEL 14700
#define IDS_HOVERCARD_TAB_MEMORY_USAGE 14701
#define IDS_HOVERCARD_TAB_HIGH_MEMORY_USAGE 14702
#define IDS_HOVERCARD_INACTIVE_TAB_MEMORY_SAVINGS 14703
#define IDS_HOVERCARD_INACTIVE_TAB 14704
#define IDS_PERFORMANCE_INTERVENTION_CLOSE_BUTTON_ACCNAME 14705
#define IDS_PERFORMANCE_INTERVENTION_SINGLE_SUGGESTED_ROW_ACCNAME 14706
#define IDS_PERFORMANCE_INTERVENTION_TAB_LIST_ACCNAME 14707
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_V1 14708
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_UPDATED_V1 14709
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_UPDATED_V2 14710
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON_V1 14711
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON_UPDATED_V1 14712
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON_UPDATED_V2 14713
#define IDS_PERFORMANCE_INTERVENTION_DISMISS_BUTTON 14714
#define IDS_PERFORMANCE_INTERVENTION_BUTTON_TOOLTIP 14715
#define IDS_PERFORMANCE_INTERVENTION_BUTTON_ACCNAME 14716
#define IDS_TOAST_MENU_BUTTON_NAME 14717
#define IDS_LINK_COPIED_TOAST_BODY 14718
#define IDS_IMAGE_COPIED_TOAST_BODY 14719
#define IDS_VIDEO_FRAME_COPIED_TOAST_BODY 14720
#define IDS_LINK_COPIED_TO_HIGHLIGHT_TOAST_BODY 14721
#define IDS_READING_LIST_TOAST_BODY 14722
#define IDS_READING_LIST_TOAST_BUTTON 14723
#define IDS_CLOSE_PINNED_TAB_TOAST_BODY 14724
#define IDS_TOAST_CLOSE_TOOLTIP 14725
#define IDS_GEMINI_WORKING_ON_TASK_BODY 14726
#define IDS_NON_MILESTONE_UPDATE_TOAST_BODY 14727
#define IDS_GLIC_SHARE_IMAGE_FAILED_TOAST_BODY 14728
#define IDS_COPIED_TO_CLIPBOARD_TOAST_BODY 14729
#define IDS_PROTECTED_AUDIENCE_DEBUGGING_DISCLAIMER 14733
#define IDS_TEST_THIRD_PARTY_COOKIE_BLOCKING_PHASEOUT_INFO 14734
#define IDS_OVERFLOW_MENU_ITEM_TEXT_PROFILE 14735
#define IDS_OVERFLOW_MENU_ITEM_TEXT_DOWNLOADS 14736
#define IDS_OVERFLOW_MENU_ITEM_TEXT_EXTENSIONS 14737
#define IDS_OVERFLOW_MENU_ITEM_TEXT_FORWARD 14738
#define IDS_OVERFLOW_MENU_ITEM_TEXT_HOME 14739
#define IDS_OVERFLOW_MENU_ITEM_TEXT_LABS 14740
#define IDS_OVERFLOW_MENU_ITEM_TEXT_MEDIA_CONTROLS 14741
#define IDS_OVERFLOW_MENU_ITEM_TEXT_NEW_TAB 14742
#define IDS_OVERFLOW_MENU_ITEM_TEXT_SIDE_PANEL 14743
#define IDS_PROMISE_STATUS_WAITING 14744
#define IDS_PROMISE_STATUS_INSTALLING 14745
#define IDS_PROMISE_APP_ACCESSIBLE_LABEL_WAITING 14746
#define IDS_PROMISE_APP_ACCESSIBLE_LABEL_INSTALLING 14747
#define IDS_PROMISE_APP_PLACEHOLDER_ACCESSIBLE_LABEL_WAITING 14748
#define IDS_PROMISE_APP_PLACEHOLDER_ACCESSIBLE_LABEL_INSTALLING 14749
#define IDS_IWA_INSTALLER_DISABLED_TITLE 14750
#define IDS_IWA_INSTALLER_DISABLED_CHANGE_PREFERENCE 14751
#define IDS_IWA_INSTALLER_DISABLED_SUBTITLE 14752
#define IDS_IWA_INSTALLER_ALREADY_INSTALLED_TITLE 14753
#define IDS_IWA_INSTALLER_ALREADY_INSTALLED_SUBTITLE 14754
#define IDS_IWA_INSTALLER_BODY_SCREENREADER_NAME 14755
#define IDS_IWA_INSTALLER_DETAILS_SCREENREADER_NAME 14756
#define IDS_IWA_INSTALLER_PROGRESS_SCREENREADER_NAME 14757
#define IDS_IWA_INSTALLER_INSTALL_SUBTITLE 14758
#define IDS_IWA_INSTALLER_INSTALL_PROGRESS 14759
#define IDS_IWA_INSTALLER_SHOW_METADATA_SUBTITLE 14760
#define IDS_IWA_INSTALLER_SHOW_METADATA_APP_NAME_LABEL 14761
#define IDS_IWA_INSTALLER_SHOW_METADATA_APP_VERSION_LABEL 14762
#define IDS_IWA_INSTALLER_CONFIRM_TITLE 14763
#define IDS_IWA_INSTALLER_CONFIRM_SUBTITLE 14764
#define IDS_IWA_INSTALLER_CONFIRM_LEARN_MORE 14765
#define IDS_IWA_INSTALLER_CONFIRM_CONTINUE 14766
#define IDS_IWA_INSTALLER_INSTALL_FAILED_TITLE 14767
#define IDS_IWA_INSTALLER_INSTALL_FAILED_SUBTITLE 14768
#define IDS_IWA_INSTALLER_INSTALL_FAILED_RETRY 14769
#define IDS_IWA_INSTALLER_SUCCESS_SUBTITLE 14770
#define IDS_IWA_INSTALLER_SUCCESS_FINISH 14771
#define IDS_IWA_INSTALLER_SUCCESS_LAUNCH_APPLICATION 14772
#define IDS_IWA_INSTALLER_VERIFICATION_TITLE 14773
#define IDS_IWA_INSTALLER_VERIFICATION_SUBTITLE 14774
#define IDS_IWA_INSTALLER_VERIFICATION_STATUS 14775
#define IDS_IWA_INSTALLER_VERIFICATION_ERROR_TITLE 14776
#define IDS_IWA_INSTALLER_VERIFICATION_ERROR_SUBTITLE 14777
#define IDS_ISOLATED_WEB_APPS_OPENED_TABS_COUNTER_NOTIFICATION_TITLE 14779
#define IDS_ISOLATED_WEB_APPS_OPENED_TABS_COUNTER_NOTIFICATION_MESSAGE 14780
#define IDS_ISOLATED_WEB_APPS_OPENED_TABS_COUNTER_NOTIFICATION_BUTTON_SETTINGS 14781
#define IDS_ISOLATED_WEB_APPS_OPENED_TABS_COUNTER_NOTIFICATION_CLOSE_BUTTON 14782
#define IDS_THUMBS_DOWN 14789
#define IDS_THUMBS_UP 14790
#define IDS_EXPERIMENTAL_FEATURE_DISCLAIMER 14791
#define IDS_PDF_SEARCHIFY_IPH_TITLE 14793
#define IDS_PDF_SEARCHIFY_IPH_BODY 14794
#define IDS_PDF_SEARCHIFY_IPH_BODY_SCREEN_READER 14795
#define IDS_SELECT_AUDIO_OUTPUT_DIALOG_TITLE 14796
#define IDS_SELECT_AUDIO_OUTPUT_DIALOG_CHOOSE_DEVICE 14797
#define IDS_CHROME_NO_LONGER_SHOW_WARNINGS_NOTIFICATION_TITLE 14813
#define IDS_CHROME_NO_LONGER_SHOW_WARNINGS_NOTIFICATION_BODY 14814
#define IDS_CHROME_NO_LONGER_SHOW_WARNINGS_NOTIFICATION_TITLE_NEW 14815
#define IDS_CHROME_NO_LONGER_SHOW_WARNINGS_NOTIFICATION_BODY_NEW 14816
#define IDS_MERCHANT_TRUST_IPH_TITLE 14817
#define IDS_MERCHANT_TRUST_IPH_BODY 14818
#define IDS_MERCHANT_TRUST_IPH_BODY_SCREEN_READER 14819
#define IDS_ALLOWED_PROTECTED_CONTENT_IDENTIFIERS_TITLE 14824
#define IDS_BLOCKED_PROTECTED_CONTENT_IDENTIFIERS_TITLE 14825
#define IDS_ALLOWED_PROTECTED_CONTENT_IDENTIFIERS_MESSAGE 14826
#define IDS_ALLOWED_PROTECTED_CONTENT_IDENTIFIERS_BLOCK 14827
#define IDS_ALLOWED_PROTECTED_CONTENT_IDENTIFIERS_NO_ACTION 14828
#define IDS_BLOCKED_PROTECTED_CONTENT_IDENTIFIERS_MESSAGE 14829
#define IDS_BLOCKED_PROTECTED_CONTENT_IDENTIFIERS_UNBLOCK 14830
#define IDS_BLOCKED_PROTECTED_CONTENT_IDENTIFIERS_NO_ACTION 14831
#define IDS_NTP_CUSTOMIZATION_PROMO 14832
#define IDS_NTP_EXTENSIONS_PROMO 14833
#define IDS_NTP_SIGN_IN_PROMO_WITH_BOOKMARKS 14834
#define IDS_ACCOUNT_CHOOSER_SINGLE_ACCOUNT_TITLE 14835
#define IDS_ACCOUNT_CHOOSER_MULTI_ACCOUNT_TITLE 14836
#define IDS_ACCOUNT_CHOOSER_SUBTITLE 14837
#define IDS_SAVE_TO_DRIVE_FOLDER_NAME 14838
#define IDS_ACCOUNT_CHOOSER_DRIVE 14839
#define IDS_ACCOUNT_CHOOSER_ADD_ACCOUNT 14840
#define IDS_ACCOUNT_CHOOSER_RADIO_GROUP_ACCESSIBILITY_LABEL 14841
#define IDS_ACCOUNT_CHOOSER_HEADER_ACCESSIBILITY_LABEL 14842
#define IDS_TIPS_NOTIFICATIONS_HELPFUL_BUTTON_TEXT 14843
#define IDS_TIPS_NOTIFICATIONS_ENHANCED_SAFE_BROWSING_TITLE 14844
#define IDS_TIPS_NOTIFICATIONS_ENHANCED_SAFE_BROWSING_SUBTITLE 14845
#define IDS_TIPS_NOTIFICATIONS_QUICK_DELETE_TITLE 14846
#define IDS_TIPS_NOTIFICATIONS_QUICK_DELETE_SUBTITLE 14847
#define IDS_TIPS_NOTIFICATIONS_GOOGLE_LENS_TITLE 14848
#define IDS_TIPS_NOTIFICATIONS_GOOGLE_LENS_SUBTITLE 14849
#define IDS_TIPS_NOTIFICATIONS_BOTTOM_OMNIBOX_TITLE 14850
#define IDS_TIPS_NOTIFICATIONS_BOTTOM_OMNIBOX_SUBTITLE 14851

// ---------------------------------------------------------------------------
// From locale_settings.h:

#define IDS_SPELLCHECK_DICTIONARY 145
#define IDS_EDITBOOKMARK_DIALOG_WIDTH_CHARS 16000
#define IDS_EDITBOOKMARK_DIALOG_HEIGHT_LINES 16001
#define IDS_WEBSTORE_URL 479
#define IDS_MEDIA_GALLERIES_DIALOG_CONTENT_WIDTH_CHARS 16002

// ---------------------------------------------------------------------------
// From omnibox_pedal_synonyms.h:

#define IDS_OMNIBOX_PEDALS_IGNORE_GROUP 287
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_CLEAR_BROWSER_CACHE 39590
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_OPTIONAL_GOOGLE_CHROME 373
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_DELETE 374
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_INFORMATION 375
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_MANAGE_CHROME_PASSWORDS 39591
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_GOOGLE_CHROME 367
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_MANAGER 368
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_PASSWORDS 369
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_MANAGE_PAYMENT_METHODS 39592
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_OPTIONAL_GOOGLE_CHROME 364
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CHANGE 365
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CREDIT_CARD_INFORMATION 366
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_ENTER_INCOGNITO_MODE 39593
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_GOOGLE_CHROME 361
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_CREATE 362
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_INCOGNITO_WINDOW 363
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_TRANSLATE_THIS_PAGE 39594
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_OPTIONAL_GOOGLE_CHROME 357
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_CHANGE_LANGUAGE 358
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_THIS_PAGE 359
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_UPDATE_CHROME 39595
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_GOOGLE_CHROME 355
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_INSTALL 356
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_RUN_CHROME_SAFETY_CHECK 39596
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_ACTIVATE 351
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_GOOGLE_CHROME 352
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_CHECKUP 353
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_PASSWORDS 354
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_MANAGE_SECURITY_SETTINGS 39597
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ANY_OPTIONAL_GOOGLE_CHROME 348
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_ENHANCED_PROTECTION 349
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_OPTIONAL_ALTER 350
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_CHROME_COOKIE_SETTINGS 39598
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_COOKIE_SETTINGS 345
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_REQUIRED_GOOGLE_CHROME 346
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_OPTIONAL_THIRD_PARTY 347
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_ADD_ADDRESS 39599
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_CONTROL 342
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_SHIPPING_ADDRESSES 343
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_OPTIONAL_GOOGLE_CHROME 344
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_CHANGE_CHROME_BROWSER_SYNC_SETTINGS 39600
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_SYNC_SETTINGS 340
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ANY_REQUIRED_GOOGLE_CHROME 341
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_ADJUST_SITE_PERMISSIONS 39601
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_SITE_PERMISSIONS 338
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ANY_REQUIRED_GOOGLE_CHROME 339
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_CREATE_GOOGLE_DOC 39602
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_GOOGLE_WORKSPACE 332
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ANY_REQUIRED_CREATE 333
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_DOCUMENT 334
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_CREATE_GOOGLE_SHEET 39603
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ANY_REQUIRED_CREATE 329
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_GOOGLE_WORKSPACE 330
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_SPREADSHEET 331
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE_GOOGLE_SLIDE 39604
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE 326
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_PRESENTATION 327
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ANY_REQUIRED_WORKSPACE 328
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_CREATE_GOOGLE_CAL_INVITE 39605
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_SCHEDULE 323
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_WORKSPACE 324
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_MEETING 325
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_CREATE_GOOGLE_SITE 39606
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_CREATE 320
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_WORKSPACE 321
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_WEBSITE 322
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_CREATE_GOOGLE_KEEP_NOTE 39607
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_CREATE 317
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_WORKSPACE 318
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_NOTES 319
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_CREATE_GOOGLE_FORM 39608
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_CREATE 314
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_WORKSPACE 315
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_SURVEY 316
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_CHROME_FEATURES 39609
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_OPTIONAL_MAKE_THE_MOST_OF 335
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ANY_OPTIONAL_BROWSER 336
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_NEW_CHROME_FEATURES 337
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL_MY_GOOGLE_ACCOUNT 39610
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_GOOGLE_ACCOUNT 311
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ANY_OPTIONAL_BROWSER 312
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL 313
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE_GMAIL_PASSWORD 39611
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_GOOGLE_ACCOUNT_PASSWORD 370
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ANY_OPTIONAL_BROWSER 371
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE 372
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_CLOSE_INCOGNITO_WINDOW 39612
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_DELETE 39613
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_INCOGNITO_WINDOW 39614
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_CHROME_DINO 39615
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_PLAY_CHROME_DINO_GAME 360
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_FIND_LOST_PHONE 39616
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_HELP_ME_LOCATE 309
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_LOST_DEVICE 310
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_CHANGE_GOOGLE_PRIVACY_SETTINGS 39617
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_MANAGE_GOOGLE_PRIVACY_SETTINGS 308
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHANGE_CHROME_SETTINGS 39618
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_OPTIONAL_CONTROL 306
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHROME_BROWSER_SETTINGS 307
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_MANAGE_CHROME_DOWNLOADS 39619
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CONTROL 304
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CHROME_BROWSER_DOWNLOADS 305
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_SEE_CHROME_HISTORY 39620
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_REVISIT 302
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_GOOGLE_CHROME_BROWSING_HISTORY 303
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_THIS_PAGE 39621
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_LINK_WITH_QR_CODE 301
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROME_ACCESSIBILITY 39622
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 299
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 300
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_CHANGE_BROWSER_FONT 39623
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_OPTIONAL_CUSTOMIZE 296
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_GOOGLE_CHROME 297
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_FONT_SIZING 298
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CUSTOMIZE_CHROME_APPEARANCE 39624
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_OPTIONAL_CUSTOMIZE 294
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CHROME_BACKGROUNDS 295
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_ADD_CUSTOM_SEARCH 39625
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_CUSTOMIZE 291
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_CUSTOM_SEARCH_ENGINES 292
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_GOOGLE_CHROME 293
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROMEOS_ACCESSIBILITY 39626
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 39627
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 39628
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_ALWAYS_OPEN_LINKS_IN_CHROME 39629
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_HOW_TO_MAKE_CHROME_MY_DEFAULT_BROWSER 288
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_SELECT 289
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_DEFAULT_BROWSER 290

// ---------------------------------------------------------------------------
// From permission_element_generated_strings.h:

#define IDS_PERMISSION_REQUEST_CAMERA_af 54900
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_af 54901
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_af 54902
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_af 54903
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_af 54904
#define IDS_PERMISSION_REQUEST_MICROPHONE_af 54905
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_af 54906
#define IDS_PERMISSION_REQUEST_GEOLOCATION_af 54907
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_af 54908
#define IDS_PERMISSION_REQUEST_USING_LOCATION_af 54909
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_af 54910
#define IDS_PERMISSION_REQUEST_CAMERA_am 54911
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_am 54912
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_am 54913
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_am 54914
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_am 54915
#define IDS_PERMISSION_REQUEST_MICROPHONE_am 54916
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_am 54917
#define IDS_PERMISSION_REQUEST_GEOLOCATION_am 54918
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_am 54919
#define IDS_PERMISSION_REQUEST_USING_LOCATION_am 54920
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_am 54921
#define IDS_PERMISSION_REQUEST_CAMERA_ar 54922
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ar 54923
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ar 54924
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ar 54925
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ar 54926
#define IDS_PERMISSION_REQUEST_MICROPHONE_ar 54927
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ar 54928
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ar 54929
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ar 54930
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ar 54931
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ar 54932
#define IDS_PERMISSION_REQUEST_CAMERA_as 54933
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_as 54934
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_as 54935
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_as 54936
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_as 54937
#define IDS_PERMISSION_REQUEST_MICROPHONE_as 54938
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_as 54939
#define IDS_PERMISSION_REQUEST_GEOLOCATION_as 54940
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_as 54941
#define IDS_PERMISSION_REQUEST_USING_LOCATION_as 54942
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_as 54943
#define IDS_PERMISSION_REQUEST_CAMERA_az 54944
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_az 54945
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_az 54946
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_az 54947
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_az 54948
#define IDS_PERMISSION_REQUEST_MICROPHONE_az 54949
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_az 54950
#define IDS_PERMISSION_REQUEST_GEOLOCATION_az 54951
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_az 54952
#define IDS_PERMISSION_REQUEST_USING_LOCATION_az 54953
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_az 54954
#define IDS_PERMISSION_REQUEST_CAMERA_be 54955
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_be 54956
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_be 54957
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_be 54958
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_be 54959
#define IDS_PERMISSION_REQUEST_MICROPHONE_be 54960
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_be 54961
#define IDS_PERMISSION_REQUEST_GEOLOCATION_be 54962
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_be 54963
#define IDS_PERMISSION_REQUEST_USING_LOCATION_be 54964
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_be 54965
#define IDS_PERMISSION_REQUEST_CAMERA_bg 54966
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bg 54967
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bg 54968
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bg 54969
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bg 54970
#define IDS_PERMISSION_REQUEST_MICROPHONE_bg 54971
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bg 54972
#define IDS_PERMISSION_REQUEST_GEOLOCATION_bg 54973
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bg 54974
#define IDS_PERMISSION_REQUEST_USING_LOCATION_bg 54975
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bg 54976
#define IDS_PERMISSION_REQUEST_CAMERA_bn 54977
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bn 54978
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bn 54979
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bn 54980
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bn 54981
#define IDS_PERMISSION_REQUEST_MICROPHONE_bn 54982
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bn 54983
#define IDS_PERMISSION_REQUEST_GEOLOCATION_bn 54984
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bn 54985
#define IDS_PERMISSION_REQUEST_USING_LOCATION_bn 54986
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bn 54987
#define IDS_PERMISSION_REQUEST_CAMERA_bs 54988
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bs 54989
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bs 54990
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bs 54991
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bs 54992
#define IDS_PERMISSION_REQUEST_MICROPHONE_bs 54993
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bs 54994
#define IDS_PERMISSION_REQUEST_GEOLOCATION_bs 54995
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bs 54996
#define IDS_PERMISSION_REQUEST_USING_LOCATION_bs 54997
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bs 54998
#define IDS_PERMISSION_REQUEST_CAMERA_ca 54999
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ca 55000
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ca 55001
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ca 55002
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ca 55003
#define IDS_PERMISSION_REQUEST_MICROPHONE_ca 55004
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ca 55005
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ca 55006
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ca 55007
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ca 55008
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ca 55009
#define IDS_PERMISSION_REQUEST_CAMERA_cs 55010
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_cs 55011
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_cs 55012
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_cs 55013
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_cs 55014
#define IDS_PERMISSION_REQUEST_MICROPHONE_cs 55015
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_cs 55016
#define IDS_PERMISSION_REQUEST_GEOLOCATION_cs 55017
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_cs 55018
#define IDS_PERMISSION_REQUEST_USING_LOCATION_cs 55019
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_cs 55020
#define IDS_PERMISSION_REQUEST_CAMERA_cy 55021
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_cy 55022
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_cy 55023
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_cy 55024
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_cy 55025
#define IDS_PERMISSION_REQUEST_MICROPHONE_cy 55026
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_cy 55027
#define IDS_PERMISSION_REQUEST_GEOLOCATION_cy 55028
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_cy 55029
#define IDS_PERMISSION_REQUEST_USING_LOCATION_cy 55030
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_cy 55031
#define IDS_PERMISSION_REQUEST_CAMERA_da 55032
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_da 55033
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_da 55034
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_da 55035
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_da 55036
#define IDS_PERMISSION_REQUEST_MICROPHONE_da 55037
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_da 55038
#define IDS_PERMISSION_REQUEST_GEOLOCATION_da 55039
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_da 55040
#define IDS_PERMISSION_REQUEST_USING_LOCATION_da 55041
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_da 55042
#define IDS_PERMISSION_REQUEST_CAMERA_de 55043
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_de 55044
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_de 55045
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_de 55046
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_de 55047
#define IDS_PERMISSION_REQUEST_MICROPHONE_de 55048
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_de 55049
#define IDS_PERMISSION_REQUEST_GEOLOCATION_de 55050
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_de 55051
#define IDS_PERMISSION_REQUEST_USING_LOCATION_de 55052
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_de 55053
#define IDS_PERMISSION_REQUEST_CAMERA_el 55054
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_el 55055
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_el 55056
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_el 55057
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_el 55058
#define IDS_PERMISSION_REQUEST_MICROPHONE_el 55059
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_el 55060
#define IDS_PERMISSION_REQUEST_GEOLOCATION_el 55061
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_el 55062
#define IDS_PERMISSION_REQUEST_USING_LOCATION_el 55063
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_el 55064
#define IDS_PERMISSION_REQUEST_CAMERA_en_GB 55065
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_en_GB 55066
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_en_GB 55067
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_en_GB 55068
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_en_GB 55069
#define IDS_PERMISSION_REQUEST_MICROPHONE_en_GB 55070
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_en_GB 55071
#define IDS_PERMISSION_REQUEST_GEOLOCATION_en_GB 55072
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_en_GB 55073
#define IDS_PERMISSION_REQUEST_USING_LOCATION_en_GB 55074
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_en_GB 55075
#define IDS_PERMISSION_REQUEST_CAMERA_es_419 55076
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_es_419 55077
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_es_419 55078
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_es_419 55079
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_es_419 55080
#define IDS_PERMISSION_REQUEST_MICROPHONE_es_419 55081
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_es_419 55082
#define IDS_PERMISSION_REQUEST_GEOLOCATION_es_419 55083
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_es_419 55084
#define IDS_PERMISSION_REQUEST_USING_LOCATION_es_419 55085
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_es_419 55086
#define IDS_PERMISSION_REQUEST_CAMERA_es 55087
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_es 55088
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_es 55089
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_es 55090
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_es 55091
#define IDS_PERMISSION_REQUEST_MICROPHONE_es 55092
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_es 55093
#define IDS_PERMISSION_REQUEST_GEOLOCATION_es 55094
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_es 55095
#define IDS_PERMISSION_REQUEST_USING_LOCATION_es 55096
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_es 55097
#define IDS_PERMISSION_REQUEST_CAMERA_et 55098
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_et 55099
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_et 55100
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_et 55101
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_et 55102
#define IDS_PERMISSION_REQUEST_MICROPHONE_et 55103
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_et 55104
#define IDS_PERMISSION_REQUEST_GEOLOCATION_et 55105
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_et 55106
#define IDS_PERMISSION_REQUEST_USING_LOCATION_et 55107
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_et 55108
#define IDS_PERMISSION_REQUEST_CAMERA_eu 55109
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_eu 55110
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_eu 55111
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_eu 55112
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_eu 55113
#define IDS_PERMISSION_REQUEST_MICROPHONE_eu 55114
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_eu 55115
#define IDS_PERMISSION_REQUEST_GEOLOCATION_eu 55116
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_eu 55117
#define IDS_PERMISSION_REQUEST_USING_LOCATION_eu 55118
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_eu 55119
#define IDS_PERMISSION_REQUEST_CAMERA_fa 55120
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fa 55121
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fa 55122
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fa 55123
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fa 55124
#define IDS_PERMISSION_REQUEST_MICROPHONE_fa 55125
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fa 55126
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fa 55127
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fa 55128
#define IDS_PERMISSION_REQUEST_USING_LOCATION_fa 55129
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fa 55130
#define IDS_PERMISSION_REQUEST_CAMERA_fi 55131
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fi 55132
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fi 55133
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fi 55134
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fi 55135
#define IDS_PERMISSION_REQUEST_MICROPHONE_fi 55136
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fi 55137
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fi 55138
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fi 55139
#define IDS_PERMISSION_REQUEST_USING_LOCATION_fi 55140
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fi 55141
#define IDS_PERMISSION_REQUEST_CAMERA_fil 55142
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fil 55143
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fil 55144
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fil 55145
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fil 55146
#define IDS_PERMISSION_REQUEST_MICROPHONE_fil 55147
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fil 55148
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fil 55149
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fil 55150
#define IDS_PERMISSION_REQUEST_USING_LOCATION_fil 55151
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fil 55152
#define IDS_PERMISSION_REQUEST_CAMERA_fr_CA 55153
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fr_CA 55154
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fr_CA 55155
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fr_CA 55156
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fr_CA 55157
#define IDS_PERMISSION_REQUEST_MICROPHONE_fr_CA 55158
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fr_CA 55159
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fr_CA 55160
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fr_CA 55161
#define IDS_PERMISSION_REQUEST_USING_LOCATION_fr_CA 55162
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fr_CA 55163
#define IDS_PERMISSION_REQUEST_CAMERA_fr 55164
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fr 55165
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fr 55166
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fr 55167
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fr 55168
#define IDS_PERMISSION_REQUEST_MICROPHONE_fr 55169
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fr 55170
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fr 55171
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fr 55172
#define IDS_PERMISSION_REQUEST_USING_LOCATION_fr 55173
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fr 55174
#define IDS_PERMISSION_REQUEST_CAMERA_gl 55175
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_gl 55176
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_gl 55177
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_gl 55178
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_gl 55179
#define IDS_PERMISSION_REQUEST_MICROPHONE_gl 55180
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_gl 55181
#define IDS_PERMISSION_REQUEST_GEOLOCATION_gl 55182
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_gl 55183
#define IDS_PERMISSION_REQUEST_USING_LOCATION_gl 55184
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_gl 55185
#define IDS_PERMISSION_REQUEST_CAMERA_gu 55186
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_gu 55187
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_gu 55188
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_gu 55189
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_gu 55190
#define IDS_PERMISSION_REQUEST_MICROPHONE_gu 55191
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_gu 55192
#define IDS_PERMISSION_REQUEST_GEOLOCATION_gu 55193
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_gu 55194
#define IDS_PERMISSION_REQUEST_USING_LOCATION_gu 55195
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_gu 55196
#define IDS_PERMISSION_REQUEST_CAMERA_hi 55197
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hi 55198
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hi 55199
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hi 55200
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hi 55201
#define IDS_PERMISSION_REQUEST_MICROPHONE_hi 55202
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hi 55203
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hi 55204
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hi 55205
#define IDS_PERMISSION_REQUEST_USING_LOCATION_hi 55206
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hi 55207
#define IDS_PERMISSION_REQUEST_CAMERA_hr 55208
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hr 55209
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hr 55210
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hr 55211
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hr 55212
#define IDS_PERMISSION_REQUEST_MICROPHONE_hr 55213
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hr 55214
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hr 55215
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hr 55216
#define IDS_PERMISSION_REQUEST_USING_LOCATION_hr 55217
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hr 55218
#define IDS_PERMISSION_REQUEST_CAMERA_hu 55219
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hu 55220
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hu 55221
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hu 55222
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hu 55223
#define IDS_PERMISSION_REQUEST_MICROPHONE_hu 55224
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hu 55225
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hu 55226
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hu 55227
#define IDS_PERMISSION_REQUEST_USING_LOCATION_hu 55228
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hu 55229
#define IDS_PERMISSION_REQUEST_CAMERA_hy 55230
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hy 55231
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hy 55232
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hy 55233
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hy 55234
#define IDS_PERMISSION_REQUEST_MICROPHONE_hy 55235
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hy 55236
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hy 55237
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hy 55238
#define IDS_PERMISSION_REQUEST_USING_LOCATION_hy 55239
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hy 55240
#define IDS_PERMISSION_REQUEST_CAMERA_id 55241
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_id 55242
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_id 55243
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_id 55244
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_id 55245
#define IDS_PERMISSION_REQUEST_MICROPHONE_id 55246
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_id 55247
#define IDS_PERMISSION_REQUEST_GEOLOCATION_id 55248
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_id 55249
#define IDS_PERMISSION_REQUEST_USING_LOCATION_id 55250
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_id 55251
#define IDS_PERMISSION_REQUEST_CAMERA_is 55252
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_is 55253
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_is 55254
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_is 55255
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_is 55256
#define IDS_PERMISSION_REQUEST_MICROPHONE_is 55257
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_is 55258
#define IDS_PERMISSION_REQUEST_GEOLOCATION_is 55259
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_is 55260
#define IDS_PERMISSION_REQUEST_USING_LOCATION_is 55261
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_is 55262
#define IDS_PERMISSION_REQUEST_CAMERA_it 55263
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_it 55264
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_it 55265
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_it 55266
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_it 55267
#define IDS_PERMISSION_REQUEST_MICROPHONE_it 55268
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_it 55269
#define IDS_PERMISSION_REQUEST_GEOLOCATION_it 55270
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_it 55271
#define IDS_PERMISSION_REQUEST_USING_LOCATION_it 55272
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_it 55273
#define IDS_PERMISSION_REQUEST_CAMERA_iw 55274
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_iw 55275
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_iw 55276
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_iw 55277
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_iw 55278
#define IDS_PERMISSION_REQUEST_MICROPHONE_iw 55279
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_iw 55280
#define IDS_PERMISSION_REQUEST_GEOLOCATION_iw 55281
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_iw 55282
#define IDS_PERMISSION_REQUEST_USING_LOCATION_iw 55283
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_iw 55284
#define IDS_PERMISSION_REQUEST_CAMERA_ja 55285
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ja 55286
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ja 55287
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ja 55288
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ja 55289
#define IDS_PERMISSION_REQUEST_MICROPHONE_ja 55290
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ja 55291
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ja 55292
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ja 55293
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ja 55294
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ja 55295
#define IDS_PERMISSION_REQUEST_CAMERA_ka 55296
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ka 55297
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ka 55298
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ka 55299
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ka 55300
#define IDS_PERMISSION_REQUEST_MICROPHONE_ka 55301
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ka 55302
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ka 55303
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ka 55304
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ka 55305
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ka 55306
#define IDS_PERMISSION_REQUEST_CAMERA_kk 55307
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_kk 55308
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_kk 55309
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_kk 55310
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_kk 55311
#define IDS_PERMISSION_REQUEST_MICROPHONE_kk 55312
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_kk 55313
#define IDS_PERMISSION_REQUEST_GEOLOCATION_kk 55314
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_kk 55315
#define IDS_PERMISSION_REQUEST_USING_LOCATION_kk 55316
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_kk 55317
#define IDS_PERMISSION_REQUEST_CAMERA_km 55318
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_km 55319
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_km 55320
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_km 55321
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_km 55322
#define IDS_PERMISSION_REQUEST_MICROPHONE_km 55323
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_km 55324
#define IDS_PERMISSION_REQUEST_GEOLOCATION_km 55325
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_km 55326
#define IDS_PERMISSION_REQUEST_USING_LOCATION_km 55327
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_km 55328
#define IDS_PERMISSION_REQUEST_CAMERA_kn 55329
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_kn 55330
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_kn 55331
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_kn 55332
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_kn 55333
#define IDS_PERMISSION_REQUEST_MICROPHONE_kn 55334
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_kn 55335
#define IDS_PERMISSION_REQUEST_GEOLOCATION_kn 55336
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_kn 55337
#define IDS_PERMISSION_REQUEST_USING_LOCATION_kn 55338
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_kn 55339
#define IDS_PERMISSION_REQUEST_CAMERA_ko 55340
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ko 55341
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ko 55342
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ko 55343
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ko 55344
#define IDS_PERMISSION_REQUEST_MICROPHONE_ko 55345
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ko 55346
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ko 55347
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ko 55348
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ko 55349
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ko 55350
#define IDS_PERMISSION_REQUEST_CAMERA_ky 55351
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ky 55352
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ky 55353
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ky 55354
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ky 55355
#define IDS_PERMISSION_REQUEST_MICROPHONE_ky 55356
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ky 55357
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ky 55358
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ky 55359
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ky 55360
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ky 55361
#define IDS_PERMISSION_REQUEST_CAMERA_lo 55362
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lo 55363
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lo 55364
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lo 55365
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lo 55366
#define IDS_PERMISSION_REQUEST_MICROPHONE_lo 55367
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lo 55368
#define IDS_PERMISSION_REQUEST_GEOLOCATION_lo 55369
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lo 55370
#define IDS_PERMISSION_REQUEST_USING_LOCATION_lo 55371
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lo 55372
#define IDS_PERMISSION_REQUEST_CAMERA_lt 55373
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lt 55374
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lt 55375
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lt 55376
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lt 55377
#define IDS_PERMISSION_REQUEST_MICROPHONE_lt 55378
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lt 55379
#define IDS_PERMISSION_REQUEST_GEOLOCATION_lt 55380
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lt 55381
#define IDS_PERMISSION_REQUEST_USING_LOCATION_lt 55382
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lt 55383
#define IDS_PERMISSION_REQUEST_CAMERA_lv 55384
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lv 55385
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lv 55386
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lv 55387
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lv 55388
#define IDS_PERMISSION_REQUEST_MICROPHONE_lv 55389
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lv 55390
#define IDS_PERMISSION_REQUEST_GEOLOCATION_lv 55391
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lv 55392
#define IDS_PERMISSION_REQUEST_USING_LOCATION_lv 55393
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lv 55394
#define IDS_PERMISSION_REQUEST_CAMERA_mk 55395
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mk 55396
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mk 55397
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mk 55398
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mk 55399
#define IDS_PERMISSION_REQUEST_MICROPHONE_mk 55400
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mk 55401
#define IDS_PERMISSION_REQUEST_GEOLOCATION_mk 55402
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mk 55403
#define IDS_PERMISSION_REQUEST_USING_LOCATION_mk 55404
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mk 55405
#define IDS_PERMISSION_REQUEST_CAMERA_ml 55406
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ml 55407
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ml 55408
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ml 55409
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ml 55410
#define IDS_PERMISSION_REQUEST_MICROPHONE_ml 55411
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ml 55412
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ml 55413
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ml 55414
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ml 55415
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ml 55416
#define IDS_PERMISSION_REQUEST_CAMERA_mn 55417
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mn 55418
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mn 55419
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mn 55420
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mn 55421
#define IDS_PERMISSION_REQUEST_MICROPHONE_mn 55422
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mn 55423
#define IDS_PERMISSION_REQUEST_GEOLOCATION_mn 55424
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mn 55425
#define IDS_PERMISSION_REQUEST_USING_LOCATION_mn 55426
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mn 55427
#define IDS_PERMISSION_REQUEST_CAMERA_mr 55428
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mr 55429
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mr 55430
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mr 55431
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mr 55432
#define IDS_PERMISSION_REQUEST_MICROPHONE_mr 55433
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mr 55434
#define IDS_PERMISSION_REQUEST_GEOLOCATION_mr 55435
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mr 55436
#define IDS_PERMISSION_REQUEST_USING_LOCATION_mr 55437
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mr 55438
#define IDS_PERMISSION_REQUEST_CAMERA_ms 55439
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ms 55440
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ms 55441
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ms 55442
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ms 55443
#define IDS_PERMISSION_REQUEST_MICROPHONE_ms 55444
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ms 55445
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ms 55446
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ms 55447
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ms 55448
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ms 55449
#define IDS_PERMISSION_REQUEST_CAMERA_my 55450
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_my 55451
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_my 55452
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_my 55453
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_my 55454
#define IDS_PERMISSION_REQUEST_MICROPHONE_my 55455
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_my 55456
#define IDS_PERMISSION_REQUEST_GEOLOCATION_my 55457
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_my 55458
#define IDS_PERMISSION_REQUEST_USING_LOCATION_my 55459
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_my 55460
#define IDS_PERMISSION_REQUEST_CAMERA_ne 55461
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ne 55462
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ne 55463
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ne 55464
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ne 55465
#define IDS_PERMISSION_REQUEST_MICROPHONE_ne 55466
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ne 55467
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ne 55468
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ne 55469
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ne 55470
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ne 55471
#define IDS_PERMISSION_REQUEST_CAMERA_nl 55472
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_nl 55473
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_nl 55474
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_nl 55475
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_nl 55476
#define IDS_PERMISSION_REQUEST_MICROPHONE_nl 55477
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_nl 55478
#define IDS_PERMISSION_REQUEST_GEOLOCATION_nl 55479
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_nl 55480
#define IDS_PERMISSION_REQUEST_USING_LOCATION_nl 55481
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_nl 55482
#define IDS_PERMISSION_REQUEST_CAMERA_no 55483
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_no 55484
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_no 55485
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_no 55486
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_no 55487
#define IDS_PERMISSION_REQUEST_MICROPHONE_no 55488
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_no 55489
#define IDS_PERMISSION_REQUEST_GEOLOCATION_no 55490
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_no 55491
#define IDS_PERMISSION_REQUEST_USING_LOCATION_no 55492
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_no 55493
#define IDS_PERMISSION_REQUEST_CAMERA_or 55494
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_or 55495
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_or 55496
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_or 55497
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_or 55498
#define IDS_PERMISSION_REQUEST_MICROPHONE_or 55499
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_or 55500
#define IDS_PERMISSION_REQUEST_GEOLOCATION_or 55501
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_or 55502
#define IDS_PERMISSION_REQUEST_USING_LOCATION_or 55503
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_or 55504
#define IDS_PERMISSION_REQUEST_CAMERA_pa 55505
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pa 55506
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pa 55507
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pa 55508
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pa 55509
#define IDS_PERMISSION_REQUEST_MICROPHONE_pa 55510
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pa 55511
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pa 55512
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pa 55513
#define IDS_PERMISSION_REQUEST_USING_LOCATION_pa 55514
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pa 55515
#define IDS_PERMISSION_REQUEST_CAMERA_pl 55516
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pl 55517
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pl 55518
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pl 55519
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pl 55520
#define IDS_PERMISSION_REQUEST_MICROPHONE_pl 55521
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pl 55522
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pl 55523
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pl 55524
#define IDS_PERMISSION_REQUEST_USING_LOCATION_pl 55525
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pl 55526
#define IDS_PERMISSION_REQUEST_CAMERA_pt_BR 55527
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pt_BR 55528
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pt_BR 55529
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pt_BR 55530
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pt_BR 55531
#define IDS_PERMISSION_REQUEST_MICROPHONE_pt_BR 55532
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pt_BR 55533
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pt_BR 55534
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pt_BR 55535
#define IDS_PERMISSION_REQUEST_USING_LOCATION_pt_BR 55536
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pt_BR 55537
#define IDS_PERMISSION_REQUEST_CAMERA_pt_PT 55538
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pt_PT 55539
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pt_PT 55540
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pt_PT 55541
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pt_PT 55542
#define IDS_PERMISSION_REQUEST_MICROPHONE_pt_PT 55543
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pt_PT 55544
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pt_PT 55545
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pt_PT 55546
#define IDS_PERMISSION_REQUEST_USING_LOCATION_pt_PT 55547
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pt_PT 55548
#define IDS_PERMISSION_REQUEST_CAMERA_ro 55549
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ro 55550
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ro 55551
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ro 55552
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ro 55553
#define IDS_PERMISSION_REQUEST_MICROPHONE_ro 55554
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ro 55555
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ro 55556
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ro 55557
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ro 55558
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ro 55559
#define IDS_PERMISSION_REQUEST_CAMERA_ru 55560
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ru 55561
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ru 55562
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ru 55563
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ru 55564
#define IDS_PERMISSION_REQUEST_MICROPHONE_ru 55565
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ru 55566
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ru 55567
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ru 55568
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ru 55569
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ru 55570
#define IDS_PERMISSION_REQUEST_CAMERA_si 55571
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_si 55572
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_si 55573
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_si 55574
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_si 55575
#define IDS_PERMISSION_REQUEST_MICROPHONE_si 55576
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_si 55577
#define IDS_PERMISSION_REQUEST_GEOLOCATION_si 55578
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_si 55579
#define IDS_PERMISSION_REQUEST_USING_LOCATION_si 55580
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_si 55581
#define IDS_PERMISSION_REQUEST_CAMERA_sk 55582
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sk 55583
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sk 55584
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sk 55585
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sk 55586
#define IDS_PERMISSION_REQUEST_MICROPHONE_sk 55587
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sk 55588
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sk 55589
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sk 55590
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sk 55591
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sk 55592
#define IDS_PERMISSION_REQUEST_CAMERA_sl 55593
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sl 55594
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sl 55595
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sl 55596
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sl 55597
#define IDS_PERMISSION_REQUEST_MICROPHONE_sl 55598
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sl 55599
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sl 55600
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sl 55601
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sl 55602
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sl 55603
#define IDS_PERMISSION_REQUEST_CAMERA_sq 55604
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sq 55605
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sq 55606
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sq 55607
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sq 55608
#define IDS_PERMISSION_REQUEST_MICROPHONE_sq 55609
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sq 55610
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sq 55611
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sq 55612
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sq 55613
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sq 55614
#define IDS_PERMISSION_REQUEST_CAMERA_sr_Latn 55615
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sr_Latn 55616
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sr_Latn 55617
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sr_Latn 55618
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sr_Latn 55619
#define IDS_PERMISSION_REQUEST_MICROPHONE_sr_Latn 55620
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sr_Latn 55621
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sr_Latn 55622
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sr_Latn 55623
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sr_Latn 55624
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sr_Latn 55625
#define IDS_PERMISSION_REQUEST_CAMERA_sr 55626
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sr 55627
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sr 55628
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sr 55629
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sr 55630
#define IDS_PERMISSION_REQUEST_MICROPHONE_sr 55631
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sr 55632
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sr 55633
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sr 55634
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sr 55635
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sr 55636
#define IDS_PERMISSION_REQUEST_CAMERA_sv 55637
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sv 55638
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sv 55639
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sv 55640
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sv 55641
#define IDS_PERMISSION_REQUEST_MICROPHONE_sv 55642
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sv 55643
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sv 55644
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sv 55645
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sv 55646
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sv 55647
#define IDS_PERMISSION_REQUEST_CAMERA_sw 55648
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sw 55649
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sw 55650
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sw 55651
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sw 55652
#define IDS_PERMISSION_REQUEST_MICROPHONE_sw 55653
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sw 55654
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sw 55655
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sw 55656
#define IDS_PERMISSION_REQUEST_USING_LOCATION_sw 55657
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sw 55658
#define IDS_PERMISSION_REQUEST_CAMERA_ta 55659
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ta 55660
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ta 55661
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ta 55662
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ta 55663
#define IDS_PERMISSION_REQUEST_MICROPHONE_ta 55664
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ta 55665
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ta 55666
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ta 55667
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ta 55668
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ta 55669
#define IDS_PERMISSION_REQUEST_CAMERA_te 55670
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_te 55671
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_te 55672
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_te 55673
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_te 55674
#define IDS_PERMISSION_REQUEST_MICROPHONE_te 55675
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_te 55676
#define IDS_PERMISSION_REQUEST_GEOLOCATION_te 55677
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_te 55678
#define IDS_PERMISSION_REQUEST_USING_LOCATION_te 55679
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_te 55680
#define IDS_PERMISSION_REQUEST_CAMERA_th 55681
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_th 55682
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_th 55683
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_th 55684
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_th 55685
#define IDS_PERMISSION_REQUEST_MICROPHONE_th 55686
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_th 55687
#define IDS_PERMISSION_REQUEST_GEOLOCATION_th 55688
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_th 55689
#define IDS_PERMISSION_REQUEST_USING_LOCATION_th 55690
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_th 55691
#define IDS_PERMISSION_REQUEST_CAMERA_tr 55692
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_tr 55693
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_tr 55694
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_tr 55695
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_tr 55696
#define IDS_PERMISSION_REQUEST_MICROPHONE_tr 55697
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_tr 55698
#define IDS_PERMISSION_REQUEST_GEOLOCATION_tr 55699
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_tr 55700
#define IDS_PERMISSION_REQUEST_USING_LOCATION_tr 55701
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_tr 55702
#define IDS_PERMISSION_REQUEST_CAMERA_uk 55703
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_uk 55704
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_uk 55705
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_uk 55706
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_uk 55707
#define IDS_PERMISSION_REQUEST_MICROPHONE_uk 55708
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_uk 55709
#define IDS_PERMISSION_REQUEST_GEOLOCATION_uk 55710
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_uk 55711
#define IDS_PERMISSION_REQUEST_USING_LOCATION_uk 55712
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_uk 55713
#define IDS_PERMISSION_REQUEST_CAMERA_ur 55714
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ur 55715
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ur 55716
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ur 55717
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ur 55718
#define IDS_PERMISSION_REQUEST_MICROPHONE_ur 55719
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ur 55720
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ur 55721
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ur 55722
#define IDS_PERMISSION_REQUEST_USING_LOCATION_ur 55723
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ur 55724
#define IDS_PERMISSION_REQUEST_CAMERA_uz 55725
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_uz 55726
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_uz 55727
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_uz 55728
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_uz 55729
#define IDS_PERMISSION_REQUEST_MICROPHONE_uz 55730
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_uz 55731
#define IDS_PERMISSION_REQUEST_GEOLOCATION_uz 55732
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_uz 55733
#define IDS_PERMISSION_REQUEST_USING_LOCATION_uz 55734
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_uz 55735
#define IDS_PERMISSION_REQUEST_CAMERA_vi 55736
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_vi 55737
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_vi 55738
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_vi 55739
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_vi 55740
#define IDS_PERMISSION_REQUEST_MICROPHONE_vi 55741
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_vi 55742
#define IDS_PERMISSION_REQUEST_GEOLOCATION_vi 55743
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_vi 55744
#define IDS_PERMISSION_REQUEST_USING_LOCATION_vi 55745
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_vi 55746
#define IDS_PERMISSION_REQUEST_CAMERA_zh_CN 55747
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_CN 55748
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_CN 55749
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_CN 55750
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_CN 55751
#define IDS_PERMISSION_REQUEST_MICROPHONE_zh_CN 55752
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_CN 55753
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zh_CN 55754
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_CN 55755
#define IDS_PERMISSION_REQUEST_USING_LOCATION_zh_CN 55756
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_CN 55757
#define IDS_PERMISSION_REQUEST_CAMERA_zh_HK 55758
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_HK 55759
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_HK 55760
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_HK 55761
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_HK 55762
#define IDS_PERMISSION_REQUEST_MICROPHONE_zh_HK 55763
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_HK 55764
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zh_HK 55765
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_HK 55766
#define IDS_PERMISSION_REQUEST_USING_LOCATION_zh_HK 55767
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_HK 55768
#define IDS_PERMISSION_REQUEST_CAMERA_zh_TW 55769
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_TW 55770
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_TW 55771
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_TW 55772
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_TW 55773
#define IDS_PERMISSION_REQUEST_MICROPHONE_zh_TW 55774
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_TW 55775
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zh_TW 55776
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_TW 55777
#define IDS_PERMISSION_REQUEST_USING_LOCATION_zh_TW 55778
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_TW 55779
#define IDS_PERMISSION_REQUEST_CAMERA_zu 55780
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zu 55781
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zu 55782
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zu 55783
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zu 55784
#define IDS_PERMISSION_REQUEST_MICROPHONE_zu 55785
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zu 55786
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zu 55787
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zu 55788
#define IDS_PERMISSION_REQUEST_USING_LOCATION_zu 55789
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zu 55790

// ---------------------------------------------------------------------------
// From permission_element_strings.h:

#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED 45200
#define IDS_PERMISSION_REQUEST_CAMERA 45201
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED 45202
#define IDS_PERMISSION_REQUEST_MICROPHONE 45203
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED 45204
#define IDS_PERMISSION_REQUEST_GEOLOCATION 45205
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED 45206
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE 45207
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED 45208
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION 45209
#define IDS_PERMISSION_REQUEST_USING_LOCATION 45210

// ---------------------------------------------------------------------------
// From platform_locale_settings.h:

#define IDS_STANDARD_FONT_FAMILY 106
#define IDS_FIXED_FONT_FAMILY 107
#define IDS_FIXED_FONT_FAMILY_ALT_WIN 108
#define IDS_SERIF_FONT_FAMILY 109
#define IDS_SANS_SERIF_FONT_FAMILY 110
#define IDS_NTP_FONT_FAMILY 16100
#define IDS_CURSIVE_FONT_FAMILY 111
#define IDS_FANTASY_FONT_FAMILY 112
#define IDS_MATH_FONT_FAMILY 113
#define IDS_STANDARD_FONT_FAMILY_CYRILLIC 131
#define IDS_FIXED_FONT_FAMILY_ARABIC 129
#define IDS_FIXED_FONT_FAMILY_CYRILLIC 132
#define IDS_SANS_SERIF_FONT_FAMILY_ARABIC 130
#define IDS_SERIF_FONT_FAMILY_CYRILLIC 133
#define IDS_SANS_SERIF_FONT_FAMILY_CYRILLIC 134
#define IDS_STANDARD_FONT_FAMILY_GREEK 135
#define IDS_FIXED_FONT_FAMILY_GREEK 136
#define IDS_SERIF_FONT_FAMILY_GREEK 137
#define IDS_SANS_SERIF_FONT_FAMILY_GREEK 138
#define IDS_STANDARD_FONT_FAMILY_JAPANESE 114
#define IDS_FIXED_FONT_FAMILY_JAPANESE 115
#define IDS_SERIF_FONT_FAMILY_JAPANESE 116
#define IDS_SANS_SERIF_FONT_FAMILY_JAPANESE 117
#define IDS_STANDARD_FONT_FAMILY_KOREAN 118
#define IDS_FIXED_FONT_FAMILY_KOREAN 139
#define IDS_SERIF_FONT_FAMILY_KOREAN 119
#define IDS_SANS_SERIF_FONT_FAMILY_KOREAN 120
#define IDS_CURSIVE_FONT_FAMILY_KOREAN 140
#define IDS_STANDARD_FONT_FAMILY_SIMPLIFIED_HAN 121
#define IDS_FIXED_FONT_FAMILY_SIMPLIFIED_HAN 141
#define IDS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 122
#define IDS_SANS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 123
#define IDS_CURSIVE_FONT_FAMILY_SIMPLIFIED_HAN 127
#define IDS_STANDARD_FONT_FAMILY_TRADITIONAL_HAN 124
#define IDS_FIXED_FONT_FAMILY_TRADITIONAL_HAN 142
#define IDS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 125
#define IDS_SANS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 126
#define IDS_CURSIVE_FONT_FAMILY_TRADITIONAL_HAN 128
#define IDS_MINIMUM_FONT_SIZE 143
#define IDS_MINIMUM_LOGICAL_FONT_SIZE 144

// ---------------------------------------------------------------------------
// From services_strings.h:

#define IDS_PROXY_RESOLVER_DISPLAY_NAME 45020
#define IDS_WINDOWS_SYSTEM_PROXY_RESOLVER_DISPLAY_NAME 45021
#define IDS_PDF_OCR_RESULT_BEGIN 45022
#define IDS_PDF_OCR_RESULT_END 45023

// ---------------------------------------------------------------------------
// From ui_strings.h:

#define IDS_TIME_SECS 48980
#define IDS_TIME_LONG_SECS 48981
#define IDS_TIME_LONG_SECS_2ND 48982
#define IDS_TIME_MINS 48983
#define IDS_TIME_LONG_MINS 48984
#define IDS_TIME_LONG_MINS_1ST 48985
#define IDS_TIME_LONG_MINS_2ND 48986
#define IDS_TIME_HOURS 48987
#define IDS_TIME_HOURS_1ST 48988
#define IDS_TIME_HOURS_2ND 48989
#define IDS_TIME_DAYS 48990
#define IDS_TIME_DAYS_1ST 48991
#define IDS_TIME_MONTHS 48992
#define IDS_TIME_YEARS 48993
#define IDS_TIME_REMAINING_SECS 48994
#define IDS_TIME_REMAINING_LONG_SECS 48995
#define IDS_TIME_REMAINING_MINS 48996
#define IDS_TIME_REMAINING_LONG_MINS 48997
#define IDS_TIME_REMAINING_HOURS 48998
#define IDS_TIME_REMAINING_DAYS 48999
#define IDS_TIME_REMAINING_MONTHS 49000
#define IDS_TIME_REMAINING_YEARS 49001
#define IDS_TIME_ELAPSED_SECS 49002
#define IDS_TIME_ELAPSED_LONG_SECS 49003
#define IDS_TIME_ELAPSED_MINS 49004
#define IDS_TIME_ELAPSED_LONG_MINS 49005
#define IDS_TIME_ELAPSED_HOURS 49006
#define IDS_TIME_ELAPSED_DAYS 49007
#define IDS_TIME_ELAPSED_MONTHS 49008
#define IDS_TIME_ELAPSED_YEARS 49009
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_SECS 49010
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_MINS 49011
#define IDS_TIME_TITLE_CASE_ELAPSED_HOURS 49012
#define IDS_TIME_TITLE_CASE_ELAPSED_DAYS 49013
#define IDS_TIME_TITLE_CASE_ELAPSED_MONTHS 49014
#define IDS_TIME_TITLE_CASE_ELAPSED_YEARS 49015
#define IDS_PAST_TIME_TODAY 49016
#define IDS_PAST_TIME_YESTERDAY 49017
#define IDS_TIME_TOMORROW 49018
#define IDS_APP_MENU_EMPTY_SUBMENU 49019
#define IDS_APP_MENU_AX_ANNOUNCE_EMPTY_SUBMENU 49020
#define IDS_CLIPBOARD_MENU_HTML 49021
#define IDS_CLIPBOARD_MENU_IMAGE 49022
#define IDS_CLIPBOARD_MENU_RTF_CONTENT 49023
#define IDS_CLIPBOARD_MENU_WEB_SMART_PASTE 49024
#define IDS_CLIPBOARD_MENU_CLIPBOARD 49025
#define IDS_CLIPBOARD_MENU_DELETE_ALL 49026
#define IDS_EXTENSION_PINNED 49027
#define IDS_EXTENSION_UNPINNED 49028
#define IDS_NEW_BADGE 49029
#define IDS_NEW_BADGE_SCREEN_READER_MESSAGE 49030
#define IDS_SENTENCE_END 49031
#define IDS_CONCAT_TWO_STRINGS_WITH_COMMA 49032
#define IDS_CONCAT_THREE_STRINGS_WITH_COMMA 49033
#define IDS_CONCAT_TWO_STRINGS_WITH_PERIODS 49034
#define IDS_APP_UNTITLED_SHORTCUT_FILE_NAME 49035
#define IDS_APP_SAVEAS_ALL_FILES 49036
#define IDS_APP_SAVEAS_EXTENSION_FORMAT 49037
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_TITLE 49038
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_MENU 49046
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_DEFAULT 49047
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_LTR 49048
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_RTL 49049
#define IDS_SELECT_FOLDER_DIALOG_TITLE 49050
#define IDS_SAVE_AS_DIALOG_TITLE 49051
#define IDS_OPEN_FILE_DIALOG_TITLE 49052
#define IDS_OPEN_FILES_DIALOG_TITLE 49053
#define IDS_SAVEAS_ALL_FILES 49054
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_UPLOAD_BUTTON 49055
#define IDS_APP_ACCNAME_BACK 49056
#define IDS_APP_ACCNAME_CENTER 49057
#define IDS_APP_ACCNAME_CLOSE 404
#define IDS_APP_ACCNAME_MINIMIZE 401
#define IDS_APP_ACCNAME_MAXIMIZE 402
#define IDS_APP_ACCNAME_RESTORE 403
#define IDS_APP_ACCNAME_MENU 49058
#define IDS_APP_ACCNAME_COLOR_CHOOSER_HEX_INPUT 49059
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHERE 49060
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFTEDGE 49061
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHTEDGE 49062
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHOME 49063
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLEND 49064
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEUP 49065
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEDOWN 49066
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFT 49067
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHT 49068
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLUP 49069
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLDOWN 49070
#define IDS_APP_TABLE_COLUMN_NOT_SORTED_ACCNAME 49071
#define IDS_APP_TABLE_COLUMN_SORTED_ASC_ACCNAME 49072
#define IDS_APP_TABLE_COLUMN_SORTED_DESC_ACCNAME 49073
#define IDS_APP_TABLE_HEADER_NOT_SORTED_ACCNAME 49074
#define IDS_APP_TABLE_HEADER_NOT_SORTED_ACCNAME_MAC 49075
#define IDS_APP_TABLE_HEADER_SORTED_ASC_ACCNAME 49076
#define IDS_APP_TABLE_HEADER_SORTED_DESC_ACCNAME 49077
#define IDS_APP_UNDO 49078
#define IDS_APP_CUT 49079
#define IDS_APP_COPY 407
#define IDS_APP_PASTE 49080
#define IDS_APP_DELETE 49081
#define IDS_APP_SELECT_ALL 408
#define IDS_APP_SELECT 49082
#define IDS_CONTENT_CONTEXT_EMOJI 49083
#define IDS_APP_OK 49086
#define IDS_APP_CANCEL 49087
#define IDS_APP_CLOSE 49088
#define IDS_APP_CONTINUE 49089
#define IDS_APP_TURN_ON 49090
#define IDS_APP_ESC_KEY 49091
#define IDS_APP_TAB_KEY 49092
#define IDS_APP_INSERT_KEY 49093
#define IDS_APP_HOME_KEY 49094
#define IDS_APP_DELETE_KEY 49095
#define IDS_APP_END_KEY 49096
#define IDS_APP_PAGEUP_KEY 49097
#define IDS_APP_PAGEDOWN_KEY 49098
#define IDS_APP_LEFT_ARROW_KEY 49099
#define IDS_APP_RIGHT_ARROW_KEY 49100
#define IDS_APP_UP_ARROW_KEY 49101
#define IDS_APP_DOWN_ARROW_KEY 49102
#define IDS_APP_ENTER_KEY 49103
#define IDS_APP_SPACE_KEY 49104
#define IDS_APP_F1_KEY 49105
#define IDS_APP_F5_KEY 49106
#define IDS_APP_F6_KEY 49107
#define IDS_APP_F11_KEY 49108
#define IDS_APP_BACKSPACE_KEY 49109
#define IDS_APP_COMMA_KEY 49110
#define IDS_APP_PERIOD_KEY 49111
#define IDS_APP_MEDIA_NEXT_TRACK_KEY 49112
#define IDS_APP_MEDIA_PLAY_PAUSE_KEY 49113
#define IDS_APP_MEDIA_PREV_TRACK_KEY 49114
#define IDS_APP_MEDIA_STOP_KEY 49115
#define IDS_APP_ALT_KEY 49116
#define IDS_APP_COMMAND_KEY 49117
#define IDS_APP_CTRL_KEY 480
#define IDS_APP_SEARCH_KEY 49118
#define IDS_APP_SHIFT_KEY 49119
#define IDS_APP_WINDOWS_KEY 49120
#define IDS_APP_BYTES 49125
#define IDS_APP_KIBIBYTES 49126
#define IDS_APP_MEBIBYTES 49127
#define IDS_APP_GIBIBYTES 49128
#define IDS_APP_TEBIBYTES 49129
#define IDS_APP_PEBIBYTES 49130
#define IDS_APP_BYTES_PER_SECOND 49131
#define IDS_APP_KIBIBYTES_PER_SECOND 49132
#define IDS_APP_MEBIBYTES_PER_SECOND 49133
#define IDS_APP_GIBIBYTES_PER_SECOND 49134
#define IDS_APP_TEBIBYTES_PER_SECOND 49135
#define IDS_APP_PEBIBYTES_PER_SECOND 49136
#define IDS_MESSAGE_CENTER_ACCESSIBLE_NAME 49137
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME 49138
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME_PLURAL 49139
#define IDS_MESSAGE_CENTER_EXPAND_NOTIFICATION 49140
#define IDS_MESSAGE_CENTER_COLLAPSE_NOTIFICATION 49141
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_MESSAGE_WITH_DIVIDER 49142
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_HEADER_OVERFLOW_INDICATOR 49143
#define IDS_MESSAGE_CENTER_NOTIFICATION_PROGRESS_PERCENTAGE 49144
#define IDS_MESSAGE_CENTER_NOTIFICATION_CHROMEOS_SYSTEM 49145
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_PLACEHOLDER 49146
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_ACCESSIBLE_NAME 49147
#define IDS_MESSAGE_NOTIFICATION_NOW_STRING_SHORTEST 49148
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST 49149
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST 49150
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST 49151
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST 49152
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST_FUTURE 49153
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST_FUTURE 49154
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST_FUTURE 49155
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST_FUTURE 49156
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_SITE 49157
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_APP 49158
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS 49159
#define IDS_MESSAGE_CENTER_DONT_BLOCK_NOTIFICATIONS 49160
#define IDS_MESSAGE_CENTER_SETTINGS_DONE 49161
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_ACCESSIBLE_NAME 49162
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_TOOLTIP 49163
#define IDS_MESSAGE_CENTER_NOTIFICATION_SNOOZE_BUTTON_TOOLTIP 49164
#define IDS_MESSAGE_NOTIFICATION_SETTINGS_BUTTON_ACCESSIBLE_NAME 49165
#define IDS_MESSAGE_NOTIFICATION_ACCESSIBLE_NAME 49166
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_DEVICE_INFO 49167
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_SUCCESS 49168
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_TITLE 49169
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_MESSAGE 49170
#define IDS_CLIPBOARD_HISTORY_MENU_PNG_IMAGE 49172
#define IDS_CLIPBOARD_HISTORY_MENU_HTML_IMAGE 49173
#define IDS_CLIPBOARD_HISTORY_MENU_TITLE 49174
#define IDS_CLIPBOARD_HISTORY_DELETE_ITEM_TEXT 49175
#define IDS_CLIPBOARD_HISTORY_DELETE_BUTTON_HOVER_TEXT 49176
#define IDS_CLIPBOARD_HISTORY_ITEM_DELETION 49177
#define IDS_DISPLAY_TOUCH_CALIBRATION_EXIT_LABEL 49178
#define IDS_DISPLAY_TOUCH_CALIBRATION_SECONDARY_SKIP_LABEL 49179
#define IDS_DISPLAY_TOUCH_CALIBRATION_PRIMARY_SKIP_LABEL 49180
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_LABEL_TEXT 49181
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_SUBLABEL_TEXT 49182
#define IDS_DISPLAY_TOUCH_CALIBRATION_TAP_HERE_LABEL 49183
#define IDS_DISPLAY_TOUCH_CALIBRATION_FINISH_LABEL 49184
#define IDS_DISPLAY_TOUCH_CALIBRATION_A11Y_TARGET_MOVED_TOP_RIGHT 49185
#define IDS_DISPLAY_TOUCH_CALIBRATION_A11Y_TARGET_MOVED_BOTTOM_LEFT 49186
#define IDS_DISPLAY_TOUCH_CALIBRATION_A11Y_TARGET_MOVED_BOTTOM_RIGHT 49187
#define IDS_DISPLAY_NAME_UNKNOWN 49188
#define IDS_DISPLAY_NAME_INTERNAL 49189
#define IDS_CROSTINI_USE_LOW_DENSITY 49190
#define IDS_CROSTINI_USE_HIGH_DENSITY 49191
#define IDS_CROSTINI_APP_RESTART_BODY 49192
#define IDS_SATURATED_BADGE_CONTENT 49193
#define IDS_BADGE_UNREAD_NOTIFICATIONS_SATURATED 49194
#define IDS_BADGE_UNREAD_NOTIFICATIONS_UNSPECIFIED 49195
#define IDS_BADGE_UNREAD_NOTIFICATIONS 49196
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_LABEL 687
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_NO_DEVICES 49197
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_CALL_BUTTON_LABEL 49198
#define IDS_BROWSER_SHARING_OMNIBOX_SENDING_LABEL 467
#define IDS_BROWSER_SHARING_DIALOG_DEVICE_SUBTITLE_LAST_ACTIVE_DAYS 49199
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_INITIATING_ORIGIN 49200
#define IDS_BROWSER_SHARING_CONTENT_TYPE_TEXT 49201
#define IDS_BROWSER_SHARING_CONTENT_TYPE_NUMBER 49202
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_GENERIC_ERROR 49203
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_INTERNAL_ERROR 49204
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_NETWORK_ERROR 49205
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_ACK_TIMEOUT 49206
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_INTERNAL_ERROR 49207
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TITLE_PAYLOAD_TOO_LARGE 49208
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TEXT_PAYLOAD_TOO_LARGE 49209
#define IDS_SETTINGS_PASSWORD_SHOW 49213
#define IDS_SETTINGS_PASSWORD_HIDE 49214
#define IDS_TABLE_VIEW_AX_ANNOUNCE_ROW_SELECTED 49215
#define IDS_LINK_COPIED 49216
#define IDS_INCOGNITO_NAVIGATION_BLOCKED_PAGE_TITLE 49217
#define IDS_INCOGNITO_NAVIGATION_MESSAGE 49218
#define IDS_INCOGNITO_NAVIGATION_INSTRUCTIONS 49219
#define IDS_INCOGNITO_NAVIGATION_INSTRUCTIONS_STEP_1 49220
#define IDS_INCOGNITO_NAVIGATION_INSTRUCTIONS_STEP_2 49221
#define IDS_INCOGNITO_NAVIGATION_INSTRUCTIONS_STEP_3 49222
#define IDS_INCOGNITO_NAVIGATION_INSTRUCTIONS_STEP_4 49223
#define IDS_INCOGNITO_NAVIGATION_MISSING_TITLE 49224
#define IDS_INCOGNITO_NAVIGATION_MISSING_EXTENSIONS 49225

#endif  // CEF_INCLUDE_CEF_PACK_STRINGS_H_
