// Copyright (c) 2025 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the make_api_versions_header.py tool. Versions
// are managed using the version_manager.py tool. For usage details see
// https://bitbucket.org/chromiumembedded/cef/wiki/ApiVersioning.md
//

#ifndef CEF_INCLUDE_CEF_API_VERSIONS_H_
#define CEF_INCLUDE_CEF_API_VERSIONS_H_

#include "include/base/cef_build.h"

// Added February 21, 2025.
#define CEF_API_VERSION_13300 13300
#if defined(OS_WIN)
#define CEF_API_HASH_13300 "45d39c3669ba75467e3e609f626c31506c0eae22"
#elif defined(OS_MAC)
#define CEF_API_HASH_13300 "80c0b59ba9dd783aa71fae0aa5f7dad64620e8c9"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13300 "2508f3f0b0e5dfa191036fa6c04f8dcfa18c94b9"
#endif

// Added February 21, 2025.
#define CEF_API_VERSION_13301 13301
#if defined(OS_WIN)
#define CEF_API_HASH_13301 "7109702038d51512d35dd2ed77231f9100e38214"
#elif defined(OS_MAC)
#define CEF_API_HASH_13301 "fda40a5df44628cac50a589ff979c0746011591e"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13301 "aa073dd1c586812503ca293c718358460d8c2dd6"
#endif

// Added February 21, 2025.
#define CEF_API_VERSION_13302 13302
#if defined(OS_WIN)
#define CEF_API_HASH_13302 "18799961f4461a9cbae2aed89ac04b73ab7c37f3"
#elif defined(OS_MAC)
#define CEF_API_HASH_13302 "4aa24470ba3a4bd9c06bc0e4a201b896394a86b5"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13302 "d5597ebfa30081953425e897209a8387b9584205"
#endif

// Added February 21, 2025.
#define CEF_API_VERSION_13303 13303
#if defined(OS_WIN)
#define CEF_API_HASH_13303 "20016fd6a9b87ef4c539cd1f42bf1ca09b6903ca"
#elif defined(OS_MAC)
#define CEF_API_HASH_13303 "f2cdce2b9a4b635c28b5b92c42c35625a937380c"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13303 "f3a696ee30ce1e00490a58df017393c126c89709"
#endif

// Added February 21, 2025.
#define CEF_API_VERSION_13304 13304
#if defined(OS_WIN)
#define CEF_API_HASH_13304 "19c014af0082aa901398e006381b6980e4f806e9"
#elif defined(OS_MAC)
#define CEF_API_HASH_13304 "98964c37b8917d83da4b173e22905503d38ad08f"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13304 "f1ababb4ff51ecbf77c481cee3721ef0eca9c8ca"
#endif

// Added February 21, 2025.
#define CEF_API_VERSION_13400 13400
#if defined(OS_WIN)
#define CEF_API_HASH_13400 "6ab74b90e88b7397aab9911baac5484f12466eef"
#elif defined(OS_MAC)
#define CEF_API_HASH_13400 "ba5ab71db4f9447f19eb7b1943024981c88064dd"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13400 "ea2106b5bc012c25d735521e0c7fb719d433ea4a"
#endif

// Added March 10, 2025.
#define CEF_API_VERSION_13401 13401
#if defined(OS_WIN)
#define CEF_API_HASH_13401 "751255204f006b8b883a8baf552a2da792f8aa44"
#elif defined(OS_MAC)
#define CEF_API_HASH_13401 "b54732b528bc2669481ec0cf17c7b97b033720b9"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13401 "b14bee2c0fd250da67faea421f620b58e5dea9a2"
#endif

// Added March 12, 2025.
#define CEF_API_VERSION_13500 13500
#if defined(OS_WIN)
#define CEF_API_HASH_13500 "3e78b6fe5fd31d69049499450849ada17a720a53"
#elif defined(OS_MAC)
#define CEF_API_HASH_13500 "9862177631e8059a497d6086058168dd47477ab7"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13500 "5b7c2284ed2542cf6212981d62ca9122fb2a4e88"
#endif

// Added April 07, 2025.
#define CEF_API_VERSION_13600 13600
#if defined(OS_WIN)
#define CEF_API_HASH_13600 "a8832519b4eb058567d68b65be1e1c9e80aae566"
#elif defined(OS_MAC)
#define CEF_API_HASH_13600 "22c77d1f2305de8a6147f14e52f074b4a4e5222c"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13600 "eb353ba7b8b9bcbef890217971cd8ec41efeaa75"
#endif

// Added April 22, 2025.
#define CEF_API_VERSION_13601 13601
#if defined(OS_WIN)
#define CEF_API_HASH_13601 "116a4153047ee1ee67f17fc938f084ee72b24e54"
#elif defined(OS_MAC)
#define CEF_API_HASH_13601 "ff885fe921f9eae1a5ce6a71b30b0c37b306bf56"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13601 "40b224f295a20694241c5db49721bc90a3796f30"
#endif

// Added May 07, 2025.
#define CEF_API_VERSION_13700 13700
#if defined(OS_WIN)
#define CEF_API_HASH_13700 "65c7157dd3e8eba9bcc38db2bd7f26508c717f3e"
#elif defined(OS_MAC)
#define CEF_API_HASH_13700 "9e84009c92c25aa80935727b5e4526b23439a575"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13700 "e5ac12b1bd88b9ece6ceaa57848aaba61ab85242"
#endif

// Added June 02, 2025.
#define CEF_API_VERSION_13800 13800
#if defined(OS_WIN)
#define CEF_API_HASH_13800 "1cde3ec27f93747ba42c0f2aa00467a5a16adfd4"
#elif defined(OS_MAC)
#define CEF_API_HASH_13800 "09110c1f3bbe0e8a8c26ddf6df3388d73a6593d1"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13800 "72c83a1455706c0f964505a6edcbf00c4a00575d"
#endif

// Added July 09, 2025.
#define CEF_API_VERSION_13900 13900
#if defined(OS_WIN)
#define CEF_API_HASH_13900 "707508ab72072116ce0500e3d2bdd9f34b2d5cd8"
#elif defined(OS_MAC)
#define CEF_API_HASH_13900 "9b3ef316d9a3f554899c36139cfccb17767ca254"
#elif defined(OS_LINUX)
#define CEF_API_HASH_13900 "fd0b7f8ab5869224972340454690a42e91939488"
#endif

// Added August 25, 2025.
#define CEF_API_VERSION_14000 14000
#if defined(OS_WIN)
#define CEF_API_HASH_14000 "a77810510fbf0ff5ee9768cf572941a9311c316c"
#elif defined(OS_MAC)
#define CEF_API_HASH_14000 "a280e368310e8ea75a21dc7ba8f192657b7c8455"
#elif defined(OS_LINUX)
#define CEF_API_HASH_14000 "a9f5630f5a4fd8f43e003aff6f8a2cba7bcff18f"
#endif

// Added October 06, 2025.
#define CEF_API_VERSION_14100 14100
#if defined(OS_WIN)
#define CEF_API_HASH_14100 "2948bec685a469a829d99eb1e6b08ede0ff9b197"
#elif defined(OS_MAC)
#define CEF_API_HASH_14100 "9537beb8d28175dca77510c03f5bea55617a9f22"
#elif defined(OS_LINUX)
#define CEF_API_HASH_14100 "f0f231efab94eb818114490804b13fce61ab7f4e"
#endif

// Added October 15, 2025.
#define CEF_API_VERSION_14200 14200
#if defined(OS_WIN)
#define CEF_API_HASH_14200 "1ce1d0945fb904ca48c16e2c2bdbbf25bfb7b12e"
#elif defined(OS_MAC)
#define CEF_API_HASH_14200 "4ef1c19a09a8ca2e523fea4f79215a6934de1071"
#elif defined(OS_LINUX)
#define CEF_API_HASH_14200 "18761cd4725392883e0d77a1db53b08a4cae7ac6"
#endif

// Next version last updated November 10, 2025.
#define CEF_API_VERSION_999998 999998
#if defined(OS_WIN)
#define CEF_API_HASH_999998 "1ce1d0945fb904ca48c16e2c2bdbbf25bfb7b12e"
#elif defined(OS_MAC)
#define CEF_API_HASH_999998 "4ef1c19a09a8ca2e523fea4f79215a6934de1071"
#elif defined(OS_LINUX)
#define CEF_API_HASH_999998 "18761cd4725392883e0d77a1db53b08a4cae7ac6"
#endif

// Experimental version last updated November 10, 2025.
#define CEF_API_VERSION_999999 999999
#if defined(OS_WIN)
#define CEF_API_HASH_999999 "09bf35f97989dc19b6e2e4b03b3cc1d2919e6e6d"
#elif defined(OS_MAC)
#define CEF_API_HASH_999999 "f7d2c12b247ae249e50e6a9409ef02c34efa49f8"
#elif defined(OS_LINUX)
#define CEF_API_HASH_999999 "63b8448ba1309c3eb870376b0a28f88bbfe78d5f"
#endif

// Oldest supported CEF version.
#define CEF_API_VERSION_MIN CEF_API_VERSION_13300

// Newest supported CEF version.
#define CEF_API_VERSION_LAST CEF_API_VERSION_14200

#endif  // CEF_INCLUDE_CEF_API_VERSIONS_H_
