// Copyright (c) 2025 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=adbdc655c03b77064d898e276724c625178fabd8$
//

#ifndef CEF_LIBCEF_DLL_CTOCPP_TEST_API_VERSION_TEST_CTOCPP_H_
#define CEF_LIBCEF_DLL_CTOCPP_TEST_API_VERSION_TEST_CTOCPP_H_
#pragma once

#if !defined(WRAPPING_CEF_SHARED)
#error This file can be included wrapper-side only
#endif

#include <vector>

#include "include/capi/test/cef_api_version_test_capi.h"
#include "include/test/cef_api_version_test.h"
#include "libcef_dll/ctocpp/ctocpp_ref_counted.h"

// Wrap a C structure with a C++ class.
// This class may be instantiated and accessed wrapper-side only.
class CefApiVersionTestCToCpp
    : public CefCToCppRefCounted<CefApiVersionTestCToCpp,
                                 CefApiVersionTest,
                                 cef_api_version_test_t> {
 public:
  CefApiVersionTestCToCpp();
  virtual ~CefApiVersionTestCToCpp();

  // CefApiVersionTest methods.
  CefRefPtr<CefApiVersionTestRefPtrLibrary> GetRefPtrLibrary(int val) override;
  int SetRefPtrLibrary(CefRefPtr<CefApiVersionTestRefPtrLibrary> val) override;
  CefRefPtr<CefApiVersionTestRefPtrLibrary> SetRefPtrLibraryAndReturn(
      CefRefPtr<CefApiVersionTestRefPtrLibrary> val) override;
  int SetChildRefPtrLibrary(
      CefRefPtr<CefApiVersionTestRefPtrLibraryChild> val) override;
  CefRefPtr<CefApiVersionTestRefPtrLibrary>
  SetChildRefPtrLibraryAndReturnParent(
      CefRefPtr<CefApiVersionTestRefPtrLibraryChild> val) override;
  bool SetRefPtrLibraryList(
      const std::vector<CefRefPtr<CefApiVersionTestRefPtrLibrary>>& val,
      int val1,
      int val2) override;
  bool GetRefPtrLibraryListByRef(RefPtrLibraryList& val,
                                 int val1,
                                 int val2) override;
  size_t GetRefPtrLibraryListSize() override;
  int SetRefPtrClient(CefRefPtr<CefApiVersionTestRefPtrClient> val) override;
  CefRefPtr<CefApiVersionTestRefPtrClient> SetRefPtrClientAndReturn(
      CefRefPtr<CefApiVersionTestRefPtrClient> val) override;
#if CEF_API_REMOVED(13302)
  int SetChildRefPtrClient(
      CefRefPtr<CefApiVersionTestRefPtrClientChild> val) override;
#endif
#if CEF_API_REMOVED(13302)
  CefRefPtr<CefApiVersionTestRefPtrClient> SetChildRefPtrClientAndReturnParent(
      CefRefPtr<CefApiVersionTestRefPtrClientChild> val) override;
#endif
#if CEF_API_ADDED(13302)
  int SetChildRefPtrClient(
      CefRefPtr<CefApiVersionTestRefPtrClientChildV2> val) override;
#endif
#if CEF_API_ADDED(13302)
  CefRefPtr<CefApiVersionTestRefPtrClient> SetChildRefPtrClientAndReturnParent(
      CefRefPtr<CefApiVersionTestRefPtrClientChildV2> val) override;
#endif
  bool SetRefPtrClientList(
      const std::vector<CefRefPtr<CefApiVersionTestRefPtrClient>>& val,
      int val1,
      int val2) override;
  bool GetRefPtrClientListByRef(
      RefPtrClientList& val,
      CefRefPtr<CefApiVersionTestRefPtrClient> val1,
      CefRefPtr<CefApiVersionTestRefPtrClient> val2) override;
  size_t GetRefPtrClientListSize() override;
  CefOwnPtr<CefApiVersionTestScopedLibrary> GetOwnPtrLibrary(int val) override;
  int SetOwnPtrLibrary(CefOwnPtr<CefApiVersionTestScopedLibrary> val) override;
  CefOwnPtr<CefApiVersionTestScopedLibrary> SetOwnPtrLibraryAndReturn(
      CefOwnPtr<CefApiVersionTestScopedLibrary> val) override;
  int SetChildOwnPtrLibrary(
      CefOwnPtr<CefApiVersionTestScopedLibraryChild> val) override;
  CefOwnPtr<CefApiVersionTestScopedLibrary>
  SetChildOwnPtrLibraryAndReturnParent(
      CefOwnPtr<CefApiVersionTestScopedLibraryChild> val) override;
  int SetOwnPtrClient(CefOwnPtr<CefApiVersionTestScopedClient> val) override;
  CefOwnPtr<CefApiVersionTestScopedClient> SetOwnPtrClientAndReturn(
      CefOwnPtr<CefApiVersionTestScopedClient> val) override;
#if CEF_API_REMOVED(13302)
  int SetChildOwnPtrClient(
      CefOwnPtr<CefApiVersionTestScopedClientChild> val) override;
#endif
#if CEF_API_REMOVED(13302)
  CefOwnPtr<CefApiVersionTestScopedClient> SetChildOwnPtrClientAndReturnParent(
      CefOwnPtr<CefApiVersionTestScopedClientChild> val) override;
#endif
#if CEF_API_ADDED(13302)
  int SetChildOwnPtrClient(
      CefOwnPtr<CefApiVersionTestScopedClientChildV2> val) override;
#endif
#if CEF_API_ADDED(13302)
  CefOwnPtr<CefApiVersionTestScopedClient> SetChildOwnPtrClientAndReturnParent(
      CefOwnPtr<CefApiVersionTestScopedClientChildV2> val) override;
#endif
  int SetRawPtrLibrary(CefRawPtr<CefApiVersionTestScopedLibrary> val) override;
  int SetChildRawPtrLibrary(
      CefRawPtr<CefApiVersionTestScopedLibraryChild> val) override;
  bool SetRawPtrLibraryList(
      const std::vector<CefRawPtr<CefApiVersionTestScopedLibrary>>& val,
      int val1,
      int val2) override;
  int SetRawPtrClient(CefRawPtr<CefApiVersionTestScopedClient> val) override;
#if CEF_API_REMOVED(13302)
  int SetChildRawPtrClient(
      CefRawPtr<CefApiVersionTestScopedClientChild> val) override;
#endif
#if CEF_API_ADDED(13302)
  int SetChildRawPtrClient(
      CefRawPtr<CefApiVersionTestScopedClientChildV2> val) override;
#endif
  bool SetRawPtrClientList(
      const std::vector<CefRawPtr<CefApiVersionTestScopedClient>>& val,
      int val1,
      int val2) override;
};

constexpr auto CefApiVersionTestCToCpp_Wrap = CefApiVersionTestCToCpp::Wrap;
constexpr auto CefApiVersionTestCToCpp_Unwrap = CefApiVersionTestCToCpp::Unwrap;

#endif  // CEF_LIBCEF_DLL_CTOCPP_TEST_API_VERSION_TEST_CTOCPP_H_
