// Copyright (c) 2025 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=be05fee839be1ee90b85a19391253287856c5400$
//

#include "libcef_dll/ctocpp/views/window_ctocpp.h"

#include "libcef_dll/cpptoc/views/view_delegate_cpptoc.h"
#include "libcef_dll/cpptoc/views/window_delegate_cpptoc.h"
#include "libcef_dll/ctocpp/image_ctocpp.h"
#include "libcef_dll/ctocpp/menu_model_ctocpp.h"
#include "libcef_dll/ctocpp/views/box_layout_ctocpp.h"
#include "libcef_dll/ctocpp/views/browser_view_ctocpp.h"
#include "libcef_dll/ctocpp/views/button_ctocpp.h"
#include "libcef_dll/ctocpp/views/display_ctocpp.h"
#include "libcef_dll/ctocpp/views/fill_layout_ctocpp.h"
#include "libcef_dll/ctocpp/views/layout_ctocpp.h"
#include "libcef_dll/ctocpp/views/overlay_controller_ctocpp.h"
#include "libcef_dll/ctocpp/views/panel_ctocpp.h"
#include "libcef_dll/ctocpp/views/scroll_view_ctocpp.h"
#include "libcef_dll/ctocpp/views/textfield_ctocpp.h"
#include "libcef_dll/ctocpp/views/view_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// STATIC METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
CefRefPtr<CefWindow> CefWindow::CreateTopLevelWindow(
    CefRefPtr<CefWindowDelegate> delegate) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: delegate

  // Execute
  auto* _retval =
      cef_window_create_top_level(CefWindowDelegateCppToC_Wrap(delegate));

  // Return type: refptr_same
  return CefWindowCToCpp_Wrap(_retval);
}

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Show() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->show) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->show(_struct);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::ShowAsBrowserModalDialog(
    CefRefPtr<CefBrowserView> browser_view) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->show_as_browser_modal_dialog) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: browser_view; type: refptr_same
  DCHECK(browser_view.get());
  if (!browser_view.get()) {
    return;
  }

  // Execute
  _struct->show_as_browser_modal_dialog(
      _struct, CefBrowserViewCToCpp_Unwrap(browser_view));
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Hide() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->hide) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->hide(_struct);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::CenterWindow(const CefSize& size) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->center_window) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->center_window(_struct, &size);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Close() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->close) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->close(_struct);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsClosed() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->is_closed) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_closed(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Activate() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->activate) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->activate(_struct);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Deactivate() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->deactivate) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->deactivate(_struct);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsActive() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->is_active) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_active(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::BringToTop() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->bring_to_top) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->bring_to_top(_struct);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetAlwaysOnTop(bool on_top) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_always_on_top) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_always_on_top(_struct, on_top);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsAlwaysOnTop() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->is_always_on_top) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_always_on_top(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Maximize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->maximize) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->maximize(_struct);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Minimize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->minimize) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->minimize(_struct);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Restore() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->restore) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->restore(_struct);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetFullscreen(bool fullscreen) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_fullscreen) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_fullscreen(_struct, fullscreen);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsMaximized() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->is_maximized) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_maximized(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsMinimized() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->is_minimized) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_minimized(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsFullscreen() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->is_fullscreen) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_fullscreen(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefView> CefWindowCToCpp::GetFocusedView() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_focused_view) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_focused_view(_struct);

  // Return type: refptr_same
  return CefViewCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetTitle(const CefString& title) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_title) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: title

  // Execute
  _struct->set_title(_struct, title.GetStruct());
}

NO_SANITIZE("cfi-icall") CefString CefWindowCToCpp::GetTitle() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_title) {
    return CefString();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_title(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetWindowIcon(CefRefPtr<CefImage> image) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_window_icon) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: image; type: refptr_same
  DCHECK(image.get());
  if (!image.get()) {
    return;
  }

  // Execute
  _struct->set_window_icon(_struct, CefImageCToCpp_Unwrap(image));
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefImage> CefWindowCToCpp::GetWindowIcon() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_window_icon) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_window_icon(_struct);

  // Return type: refptr_same
  return CefImageCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetWindowAppIcon(CefRefPtr<CefImage> image) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_window_app_icon) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: image; type: refptr_same
  DCHECK(image.get());
  if (!image.get()) {
    return;
  }

  // Execute
  _struct->set_window_app_icon(_struct, CefImageCToCpp_Unwrap(image));
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefImage> CefWindowCToCpp::GetWindowAppIcon() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_window_app_icon) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_window_app_icon(_struct);

  // Return type: refptr_same
  return CefImageCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefOverlayController> CefWindowCToCpp::AddOverlayView(
    CefRefPtr<CefView> view,
    cef_docking_mode_t docking_mode,
    bool can_activate) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->add_overlay_view) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->add_overlay_view(_struct, CefViewCToCpp_Unwrap(view),
                                            docking_mode, can_activate);

  // Return type: refptr_same
  return CefOverlayControllerCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::ShowMenu(CefRefPtr<CefMenuModel> menu_model,
                               const CefPoint& screen_point,
                               cef_menu_anchor_position_t anchor_position) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->show_menu) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: menu_model; type: refptr_same
  DCHECK(menu_model.get());
  if (!menu_model.get()) {
    return;
  }

  // Execute
  _struct->show_menu(_struct, CefMenuModelCToCpp_Unwrap(menu_model),
                     &screen_point, anchor_position);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::CancelMenu() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->cancel_menu) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->cancel_menu(_struct);
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefDisplay> CefWindowCToCpp::GetDisplay() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_display) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_display(_struct);

  // Return type: refptr_same
  return CefDisplayCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRect CefWindowCToCpp::GetClientAreaBoundsInScreen() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_client_area_bounds_in_screen) {
    return CefRect();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_rect_t _retval = _struct->get_client_area_bounds_in_screen(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetDraggableRegions(
    const std::vector<CefDraggableRegion>& regions) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_draggable_regions) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Unverified params: regions

  // Translate param: regions; type: simple_vec_byref_const
  const size_t regionsCount = regions.size();
  cef_draggable_region_t* regionsList = NULL;
  if (regionsCount > 0) {
    regionsList = new cef_draggable_region_t[regionsCount];
    DCHECK(regionsList);
    if (regionsList) {
      for (size_t i = 0; i < regionsCount; ++i) {
        regionsList[i] = regions[i];
      }
    }
  }

  // Execute
  _struct->set_draggable_regions(_struct, regionsCount, regionsList);

  // Restore param:regions; type: simple_vec_byref_const
  if (regionsList) {
    delete[] regionsList;
  }
}

NO_SANITIZE("cfi-icall") CefWindowHandle CefWindowCToCpp::GetWindowHandle() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_window_handle) {
    return kNullWindowHandle;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_window_handle_t _retval = _struct->get_window_handle(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SendKeyPress(int key_code, uint32_t event_flags) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->send_key_press) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->send_key_press(_struct, key_code, event_flags);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SendMouseMove(int screen_x, int screen_y) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->send_mouse_move) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->send_mouse_move(_struct, screen_x, screen_y);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SendMouseEvents(cef_mouse_button_type_t button,
                                      bool mouse_down,
                                      bool mouse_up) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->send_mouse_events) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->send_mouse_events(_struct, button, mouse_down, mouse_up);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetAccelerator(int command_id,
                                     int key_code,
                                     bool shift_pressed,
                                     bool ctrl_pressed,
                                     bool alt_pressed,
                                     bool high_priority) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_accelerator) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_accelerator(_struct, command_id, key_code, shift_pressed,
                           ctrl_pressed, alt_pressed, high_priority);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::RemoveAccelerator(int command_id) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->remove_accelerator) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->remove_accelerator(_struct, command_id);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::RemoveAllAccelerators() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->remove_all_accelerators) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->remove_all_accelerators(_struct);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetThemeColor(int color_id, cef_color_t color) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_theme_color) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_theme_color(_struct, color_id, color);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::ThemeChanged() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->theme_changed) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->theme_changed(_struct);
}

NO_SANITIZE("cfi-icall")
cef_runtime_style_t CefWindowCToCpp::GetRuntimeStyle() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_runtime_style) {
    return CEF_RUNTIME_STYLE_DEFAULT;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_runtime_style_t _retval = _struct->get_runtime_style(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefWindow> CefWindowCToCpp::AsWindow() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->as_window) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->as_window(_struct);

  // Return type: refptr_same
  return CefWindowCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefFillLayout> CefWindowCToCpp::SetToFillLayout() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->set_to_fill_layout) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->set_to_fill_layout(_struct);

  // Return type: refptr_same
  return CefFillLayoutCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefBoxLayout> CefWindowCToCpp::SetToBoxLayout(
    const CefBoxLayoutSettings& settings) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->set_to_box_layout) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->set_to_box_layout(_struct, &settings);

  // Return type: refptr_same
  return CefBoxLayoutCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefLayout> CefWindowCToCpp::GetLayout() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->get_layout) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_layout(_struct);

  // Return type: refptr_same
  return CefLayoutCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::Layout() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->layout) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->layout(_struct);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::AddChildView(CefRefPtr<CefView> view) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->add_child_view) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return;
  }

  // Execute
  _struct->add_child_view(_struct, CefViewCToCpp_Unwrap(view));
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::AddChildViewAt(CefRefPtr<CefView> view, int index) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->add_child_view_at) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return;
  }
  // Verify param: index; type: simple_byval
  DCHECK_GE(index, 0);
  if (index < 0) {
    return;
  }

  // Execute
  _struct->add_child_view_at(_struct, CefViewCToCpp_Unwrap(view), index);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::ReorderChildView(CefRefPtr<CefView> view, int index) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->reorder_child_view) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return;
  }

  // Execute
  _struct->reorder_child_view(_struct, CefViewCToCpp_Unwrap(view), index);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::RemoveChildView(CefRefPtr<CefView> view) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->remove_child_view) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return;
  }

  // Execute
  _struct->remove_child_view(_struct, CefViewCToCpp_Unwrap(view));
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::RemoveAllChildViews() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->remove_all_child_views) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->remove_all_child_views(_struct);
}

NO_SANITIZE("cfi-icall") size_t CefWindowCToCpp::GetChildViewCount() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->get_child_view_count) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  size_t _retval = _struct->get_child_view_count(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefView> CefWindowCToCpp::GetChildViewAt(int index) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_panel_t*>(GetStruct());
  if (!_struct->get_child_view_at) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: index; type: simple_byval
  DCHECK_GE(index, 0);
  if (index < 0) {
    return nullptr;
  }

  // Execute
  auto* _retval = _struct->get_child_view_at(_struct, index);

  // Return type: refptr_same
  return CefViewCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefBrowserView> CefWindowCToCpp::AsBrowserView() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->as_browser_view) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->as_browser_view(_struct);

  // Return type: refptr_same
  return CefBrowserViewCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefButton> CefWindowCToCpp::AsButton() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->as_button) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->as_button(_struct);

  // Return type: refptr_same
  return CefButtonCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefPanel> CefWindowCToCpp::AsPanel() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->as_panel) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->as_panel(_struct);

  // Return type: refptr_same
  return CefPanelCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefScrollView> CefWindowCToCpp::AsScrollView() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->as_scroll_view) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->as_scroll_view(_struct);

  // Return type: refptr_same
  return CefScrollViewCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefTextfield> CefWindowCToCpp::AsTextfield() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->as_textfield) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->as_textfield(_struct);

  // Return type: refptr_same
  return CefTextfieldCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall") CefString CefWindowCToCpp::GetTypeString() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_type_string) {
    return CefString();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->get_type_string(_struct);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall")
CefString CefWindowCToCpp::ToString(bool include_children) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->to_string) {
    return CefString();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_string_userfree_t _retval = _struct->to_string(_struct, include_children);

  // Return type: string
  CefString _retvalStr;
  _retvalStr.AttachToUserFree(_retval);
  return _retvalStr;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsValid() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_valid) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_valid(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsAttached() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_attached) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_attached(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsSame(CefRefPtr<CefView> that) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_same) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: that; type: refptr_same
  DCHECK(that.get());
  if (!that.get()) {
    return false;
  }

  // Execute
  int _retval = _struct->is_same(_struct, CefViewCToCpp_Unwrap(that));

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefViewDelegate> CefWindowCToCpp::GetDelegate() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_delegate) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_delegate(_struct);

  // Return type: refptr_diff
  return CefViewDelegateCppToC_Unwrap(_retval);
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefWindow> CefWindowCToCpp::GetWindow() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_window) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_window(_struct);

  // Return type: refptr_same
  return CefWindowCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall") int CefWindowCToCpp::GetID() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_id) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_id(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetID(int id) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_id) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_id(_struct, id);
}

NO_SANITIZE("cfi-icall") int CefWindowCToCpp::GetGroupID() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_group_id) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_group_id(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetGroupID(int group_id) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_group_id) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_group_id(_struct, group_id);
}

NO_SANITIZE("cfi-icall") CefRefPtr<CefView> CefWindowCToCpp::GetParentView() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_parent_view) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_parent_view(_struct);

  // Return type: refptr_same
  return CefViewCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
CefRefPtr<CefView> CefWindowCToCpp::GetViewForID(int id) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_view_for_id) {
    return nullptr;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = _struct->get_view_for_id(_struct, id);

  // Return type: refptr_same
  return CefViewCToCpp_Wrap(_retval);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetBounds(const CefRect& bounds) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_bounds) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_bounds(_struct, &bounds);
}

NO_SANITIZE("cfi-icall") CefRect CefWindowCToCpp::GetBounds() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_bounds) {
    return CefRect();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_rect_t _retval = _struct->get_bounds(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") CefRect CefWindowCToCpp::GetBoundsInScreen() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_bounds_in_screen) {
    return CefRect();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_rect_t _retval = _struct->get_bounds_in_screen(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetSize(const CefSize& size) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_size) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_size(_struct, &size);
}

NO_SANITIZE("cfi-icall") CefSize CefWindowCToCpp::GetSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_size) {
    return CefSize();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_size_t _retval = _struct->get_size(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetPosition(const CefPoint& position) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_position) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_position(_struct, &position);
}

NO_SANITIZE("cfi-icall") CefPoint CefWindowCToCpp::GetPosition() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_position) {
    return CefPoint();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_point_t _retval = _struct->get_position(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetInsets(const CefInsets& insets) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_insets) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_insets(_struct, &insets);
}

NO_SANITIZE("cfi-icall") CefInsets CefWindowCToCpp::GetInsets() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_insets) {
    return CefInsets();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_insets_t _retval = _struct->get_insets(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") CefSize CefWindowCToCpp::GetPreferredSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_preferred_size) {
    return CefSize();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_size_t _retval = _struct->get_preferred_size(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SizeToPreferredSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->size_to_preferred_size) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->size_to_preferred_size(_struct);
}

NO_SANITIZE("cfi-icall") CefSize CefWindowCToCpp::GetMinimumSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_minimum_size) {
    return CefSize();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_size_t _retval = _struct->get_minimum_size(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") CefSize CefWindowCToCpp::GetMaximumSize() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_maximum_size) {
    return CefSize();
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_size_t _retval = _struct->get_maximum_size(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") int CefWindowCToCpp::GetHeightForWidth(int width) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_height_for_width) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_height_for_width(_struct, width);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::InvalidateLayout() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->invalidate_layout) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->invalidate_layout(_struct);
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetVisible(bool visible) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_visible) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_visible(_struct, visible);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsVisible() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_visible) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_visible(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsDrawn() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_drawn) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_drawn(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetEnabled(bool enabled) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_enabled) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_enabled(_struct, enabled);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsEnabled() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_enabled) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_enabled(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::SetFocusable(bool focusable) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_focusable) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_focusable(_struct, focusable);
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsFocusable() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_focusable) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_focusable(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::IsAccessibilityFocusable() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->is_accessibility_focusable) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->is_accessibility_focusable(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") bool CefWindowCToCpp::HasFocus() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->has_focus) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->has_focus(_struct);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall") void CefWindowCToCpp::RequestFocus() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->request_focus) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->request_focus(_struct);
}

NO_SANITIZE("cfi-icall")
void CefWindowCToCpp::SetBackgroundColor(cef_color_t color) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->set_background_color) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_background_color(_struct, color);
}

NO_SANITIZE("cfi-icall") cef_color_t CefWindowCToCpp::GetBackgroundColor() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_background_color) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_color_t _retval = _struct->get_background_color(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
cef_color_t CefWindowCToCpp::GetThemeColor(int color_id) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->get_theme_color) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  cef_color_t _retval = _struct->get_theme_color(_struct, color_id);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
bool CefWindowCToCpp::ConvertPointToScreen(CefPoint& point) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->convert_point_to_screen) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->convert_point_to_screen(_struct, &point);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefWindowCToCpp::ConvertPointFromScreen(CefPoint& point) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->convert_point_from_screen) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->convert_point_from_screen(_struct, &point);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefWindowCToCpp::ConvertPointToWindow(CefPoint& point) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->convert_point_to_window) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->convert_point_to_window(_struct, &point);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefWindowCToCpp::ConvertPointFromWindow(CefPoint& point) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->convert_point_from_window) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->convert_point_from_window(_struct, &point);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefWindowCToCpp::ConvertPointToView(CefRefPtr<CefView> view,
                                         CefPoint& point) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->convert_point_to_view) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return false;
  }

  // Execute
  int _retval = _struct->convert_point_to_view(
      _struct, CefViewCToCpp_Unwrap(view), &point);

  // Return type: bool
  return _retval ? true : false;
}

NO_SANITIZE("cfi-icall")
bool CefWindowCToCpp::ConvertPointFromView(CefRefPtr<CefView> view,
                                           CefPoint& point) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = reinterpret_cast<cef_view_t*>(GetStruct());
  if (!_struct->convert_point_from_view) {
    return false;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Verify param: view; type: refptr_same
  DCHECK(view.get());
  if (!view.get()) {
    return false;
  }

  // Execute
  int _retval = _struct->convert_point_from_view(
      _struct, CefViewCToCpp_Unwrap(view), &point);

  // Return type: bool
  return _retval ? true : false;
}

// CONSTRUCTOR - Do not edit by hand.

CefWindowCToCpp::CefWindowCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefWindowCToCpp::~CefWindowCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_window_t*
CefCToCppRefCounted<CefWindowCToCpp, CefWindow, cef_window_t>::UnwrapDerived(
    CefWrapperType type,
    CefWindow* c) {
  CHECK(false) << __func__ << " called with unexpected class type " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<CefWindowCToCpp, CefWindow, cef_window_t>::
    kWrapperType = WT_WINDOW;
