// Copyright (c) 2025 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=e3d8479eda4010ed380bf84780a167623fc85a42$
//

#include "libcef_dll/cpptoc/views/menu_button_delegate_cpptoc.h"

#include "libcef_dll/ctocpp/views/button_ctocpp.h"
#include "libcef_dll/ctocpp/views/menu_button_ctocpp.h"
#include "libcef_dll/ctocpp/views/menu_button_pressed_lock_ctocpp.h"
#include "libcef_dll/ctocpp/views/view_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

namespace {

// MEMBER FUNCTIONS - Body may be edited by hand.

void CEF_CALLBACK menu_button_delegate_on_menu_button_pressed(
    struct _cef_menu_button_delegate_t* self,
    struct _cef_menu_button_t* menu_button,
    const cef_point_t* screen_point,
    struct _cef_menu_button_pressed_lock_t* button_pressed_lock) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: menu_button; type: refptr_diff
  DCHECK(menu_button);
  if (!menu_button) {
    return;
  }
  // Verify param: screen_point; type: simple_byref_const
  DCHECK(screen_point);
  if (!screen_point) {
    return;
  }
  // Verify param: button_pressed_lock; type: refptr_diff
  DCHECK(button_pressed_lock);
  if (!button_pressed_lock) {
    return;
  }

  // Translate param: screen_point; type: simple_byref_const
  CefPoint screen_pointVal = screen_point ? *screen_point : CefPoint();

  // Execute
  CefMenuButtonDelegateCppToC::Get(self)->OnMenuButtonPressed(
      CefMenuButtonCToCpp_Wrap(menu_button), screen_pointVal,
      CefMenuButtonPressedLockCToCpp_Wrap(button_pressed_lock));
}

void CEF_CALLBACK
menu_button_delegate_on_button_pressed(struct _cef_button_delegate_t* self,
                                       struct _cef_button_t* button) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: button; type: refptr_diff
  DCHECK(button);
  if (!button) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnButtonPressed(CefButtonCToCpp_Wrap(button));
}

void CEF_CALLBACK menu_button_delegate_on_button_state_changed(
    struct _cef_button_delegate_t* self,
    struct _cef_button_t* button) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: button; type: refptr_diff
  DCHECK(button);
  if (!button) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnButtonStateChanged(CefButtonCToCpp_Wrap(button));
}

cef_size_t CEF_CALLBACK
menu_button_delegate_get_preferred_size(struct _cef_view_delegate_t* self,
                                        struct _cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval = CefMenuButtonDelegateCppToC::Get(
                           reinterpret_cast<cef_menu_button_delegate_t*>(self))
                           ->GetPreferredSize(CefViewCToCpp_Wrap(view));

  // Return type: simple
  return _retval;
}

cef_size_t CEF_CALLBACK
menu_button_delegate_get_minimum_size(struct _cef_view_delegate_t* self,
                                      struct _cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval = CefMenuButtonDelegateCppToC::Get(
                           reinterpret_cast<cef_menu_button_delegate_t*>(self))
                           ->GetMinimumSize(CefViewCToCpp_Wrap(view));

  // Return type: simple
  return _retval;
}

cef_size_t CEF_CALLBACK
menu_button_delegate_get_maximum_size(struct _cef_view_delegate_t* self,
                                      struct _cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return CefSize();
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return CefSize();
  }

  // Execute
  cef_size_t _retval = CefMenuButtonDelegateCppToC::Get(
                           reinterpret_cast<cef_menu_button_delegate_t*>(self))
                           ->GetMaximumSize(CefViewCToCpp_Wrap(view));

  // Return type: simple
  return _retval;
}

int CEF_CALLBACK
menu_button_delegate_get_height_for_width(struct _cef_view_delegate_t* self,
                                          struct _cef_view_t* view,
                                          int width) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return 0;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return 0;
  }

  // Execute
  int _retval = CefMenuButtonDelegateCppToC::Get(
                    reinterpret_cast<cef_menu_button_delegate_t*>(self))
                    ->GetHeightForWidth(CefViewCToCpp_Wrap(view), width);

  // Return type: simple
  return _retval;
}

void CEF_CALLBACK
menu_button_delegate_on_parent_view_changed(struct _cef_view_delegate_t* self,
                                            struct _cef_view_t* view,
                                            int added,
                                            struct _cef_view_t* parent) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }
  // Verify param: parent; type: refptr_diff
  DCHECK(parent);
  if (!parent) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnParentViewChanged(CefViewCToCpp_Wrap(view), added ? true : false,
                            CefViewCToCpp_Wrap(parent));
}

void CEF_CALLBACK
menu_button_delegate_on_child_view_changed(struct _cef_view_delegate_t* self,
                                           struct _cef_view_t* view,
                                           int added,
                                           struct _cef_view_t* child) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }
  // Verify param: child; type: refptr_diff
  DCHECK(child);
  if (!child) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnChildViewChanged(CefViewCToCpp_Wrap(view), added ? true : false,
                           CefViewCToCpp_Wrap(child));
}

void CEF_CALLBACK
menu_button_delegate_on_window_changed(struct _cef_view_delegate_t* self,
                                       struct _cef_view_t* view,
                                       int added) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnWindowChanged(CefViewCToCpp_Wrap(view), added ? true : false);
}

void CEF_CALLBACK
menu_button_delegate_on_layout_changed(struct _cef_view_delegate_t* self,
                                       struct _cef_view_t* view,
                                       const cef_rect_t* new_bounds) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }
  // Verify param: new_bounds; type: simple_byref_const
  DCHECK(new_bounds);
  if (!new_bounds) {
    return;
  }

  // Translate param: new_bounds; type: simple_byref_const
  CefRect new_boundsVal = new_bounds ? *new_bounds : CefRect();

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnLayoutChanged(CefViewCToCpp_Wrap(view), new_boundsVal);
}

void CEF_CALLBACK
menu_button_delegate_on_focus(struct _cef_view_delegate_t* self,
                              struct _cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnFocus(CefViewCToCpp_Wrap(view));
}

void CEF_CALLBACK
menu_button_delegate_on_blur(struct _cef_view_delegate_t* self,
                             struct _cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnBlur(CefViewCToCpp_Wrap(view));
}

void CEF_CALLBACK
menu_button_delegate_on_theme_changed(struct _cef_view_delegate_t* self,
                                      struct _cef_view_t* view) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  DCHECK(self);
  if (!self) {
    return;
  }
  // Verify param: view; type: refptr_diff
  DCHECK(view);
  if (!view) {
    return;
  }

  // Execute
  CefMenuButtonDelegateCppToC::Get(
      reinterpret_cast<cef_menu_button_delegate_t*>(self))
      ->OnThemeChanged(CefViewCToCpp_Wrap(view));
}

}  // namespace

// CONSTRUCTOR - Do not edit by hand.

CefMenuButtonDelegateCppToC::CefMenuButtonDelegateCppToC() {
  GetStruct()->on_menu_button_pressed =
      menu_button_delegate_on_menu_button_pressed;
  GetStruct()->base.on_button_pressed = menu_button_delegate_on_button_pressed;
  GetStruct()->base.on_button_state_changed =
      menu_button_delegate_on_button_state_changed;
  GetStruct()->base.base.get_preferred_size =
      menu_button_delegate_get_preferred_size;
  GetStruct()->base.base.get_minimum_size =
      menu_button_delegate_get_minimum_size;
  GetStruct()->base.base.get_maximum_size =
      menu_button_delegate_get_maximum_size;
  GetStruct()->base.base.get_height_for_width =
      menu_button_delegate_get_height_for_width;
  GetStruct()->base.base.on_parent_view_changed =
      menu_button_delegate_on_parent_view_changed;
  GetStruct()->base.base.on_child_view_changed =
      menu_button_delegate_on_child_view_changed;
  GetStruct()->base.base.on_window_changed =
      menu_button_delegate_on_window_changed;
  GetStruct()->base.base.on_layout_changed =
      menu_button_delegate_on_layout_changed;
  GetStruct()->base.base.on_focus = menu_button_delegate_on_focus;
  GetStruct()->base.base.on_blur = menu_button_delegate_on_blur;
  GetStruct()->base.base.on_theme_changed =
      menu_button_delegate_on_theme_changed;
}

// DESTRUCTOR - Do not edit by hand.

CefMenuButtonDelegateCppToC::~CefMenuButtonDelegateCppToC() {
  shutdown_checker::AssertNotShutdown();
}

template <>
CefRefPtr<CefMenuButtonDelegate> CefCppToCRefCounted<
    CefMenuButtonDelegateCppToC,
    CefMenuButtonDelegate,
    cef_menu_button_delegate_t>::UnwrapDerived(CefWrapperType type,
                                               cef_menu_button_delegate_t* s) {
  CHECK(false) << __func__ << " called with unexpected class type " << type;
  return nullptr;
}

template <>
CefWrapperType CefCppToCRefCounted<CefMenuButtonDelegateCppToC,
                                   CefMenuButtonDelegate,
                                   cef_menu_button_delegate_t>::kWrapperType =
    WT_MENU_BUTTON_DELEGATE;
