// Copyright (c) 2025 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_STRINGS_H_
#define CEF_INCLUDE_CEF_PACK_STRINGS_H_
#pragma once

// ---------------------------------------------------------------------------
// From app_locale_settings.h:

#define IDS_MINIMUM_UI_FONT_SIZE 400
#define IDS_UI_FONT_FAMILY 398
#define IDS_UI_FONT_SIZE_SCALER 399
#define IDS_WEB_FONT_FAMILY 692
#define IDS_WEB_FONT_SIZE 691

// ---------------------------------------------------------------------------
// From auto_image_annotation_strings.h:

#define IDS_AX_UNLABELED_IMAGE_ROLE_DESCRIPTION 54110
#define IDS_AX_IMAGE_ELIGIBLE_FOR_ANNOTATION 54112
#define IDS_AX_IMAGE_ANNOTATION_PENDING 54113
#define IDS_AX_IMAGE_ANNOTATION_ADULT 54114
#define IDS_AX_IMAGE_ANNOTATION_NO_DESCRIPTION 54115
#define IDS_AX_IMAGE_ANNOTATION_OCR_CONTEXT 54116
#define IDS_AX_IMAGE_ANNOTATION_DESCRIPTION_CONTEXT 54117
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLUS 54118
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_BACKWARD 54119
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_FORWARD 54120
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALL 54121
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHAT 54122
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHECK 54123
#define IDS_AX_IMAGE_ANNOTATION_ICON_X 54124
#define IDS_AX_IMAGE_ANNOTATION_ICON_DELETE 54125
#define IDS_AX_IMAGE_ANNOTATION_ICON_EDIT 54126
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI 54127
#define IDS_AX_IMAGE_ANNOTATION_ICON_END_CALL 54128
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_DOWNWARD 54129
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEART 54130
#define IDS_AX_IMAGE_ANNOTATION_ICON_HOME 54131
#define IDS_AX_IMAGE_ANNOTATION_ICON_INFO 54132
#define IDS_AX_IMAGE_ANNOTATION_ICON_LAUNCH_APPS 54133
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_UP 54134
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_BARS 54135
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_DOTS 54136
#define IDS_AX_IMAGE_ANNOTATION_ICON_NOTIFICATIONS 54137
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAUSE 54138
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLAY 54139
#define IDS_AX_IMAGE_ANNOTATION_ICON_REFRESH 54140
#define IDS_AX_IMAGE_ANNOTATION_ICON_MAGNIFYING_GLASS 54141
#define IDS_AX_IMAGE_ANNOTATION_ICON_SEND 54142
#define IDS_AX_IMAGE_ANNOTATION_ICON_SETTINGS 54143
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHARE 54144
#define IDS_AX_IMAGE_ANNOTATION_ICON_STAR 54145
#define IDS_AX_IMAGE_ANNOTATION_ICON_TAKE_PHOTO 54146
#define IDS_AX_IMAGE_ANNOTATION_ICON_TIME 54147
#define IDS_AX_IMAGE_ANNOTATION_ICON_VIDEOCAM 54148
#define IDS_AX_IMAGE_ANNOTATION_ICON_EXPAND 54149
#define IDS_AX_IMAGE_ANNOTATION_ICON_CONTRACT 54150
#define IDS_AX_IMAGE_ANNOTATION_ICON_GOOGLE 54151
#define IDS_AX_IMAGE_ANNOTATION_ICON_TWITTER 54152
#define IDS_AX_IMAGE_ANNOTATION_ICON_FACEBOOK 54153
#define IDS_AX_IMAGE_ANNOTATION_ICON_ASSISTANT 54154
#define IDS_AX_IMAGE_ANNOTATION_ICON_WEATHER 54155
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_CART 54156
#define IDS_AX_IMAGE_ANNOTATION_ICON_UPLOAD 54157
#define IDS_AX_IMAGE_ANNOTATION_ICON_QUESTION 54158
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC 54159
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC_MUTE 54160
#define IDS_AX_IMAGE_ANNOTATION_ICON_GALLERY 54161
#define IDS_AX_IMAGE_ANNOTATION_ICON_COMPASS 54162
#define IDS_AX_IMAGE_ANNOTATION_ICON_PEOPLE 54163
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_UPWARD 54164
#define IDS_AX_IMAGE_ANNOTATION_ICON_ENVELOPE 54165
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI_FACE 54166
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAPERCLIP 54167
#define IDS_AX_IMAGE_ANNOTATION_ICON_CAST 54168
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_UP 54169
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_DOWN 54170
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_STATE 54171
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_MUTE 54172
#define IDS_AX_IMAGE_ANNOTATION_ICON_STOP 54173
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_BAG 54174
#define IDS_AX_IMAGE_ANNOTATION_ICON_LIST 54175
#define IDS_AX_IMAGE_ANNOTATION_ICON_LOCATION 54176
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALENDAR 54177
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_DOWN 54178
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEADSET 54179
#define IDS_AX_IMAGE_ANNOTATION_ICON_REDO 54180
#define IDS_AX_IMAGE_ANNOTATION_ICON_UNDO 54181
#define IDS_AX_IMAGE_ANNOTATION_ICON_DOWNLOAD 54182
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_DOWNWARD 54183
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_UPWARD 54184
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_FORWARD 54185
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_BACKWARD 54186
#define IDS_AX_IMAGE_ANNOTATION_ICON_HISTORY 54187
#define IDS_AX_IMAGE_ANNOTATION_ICON_PERSON 54188
#define IDS_AX_IMAGE_ANNOTATION_ICON_HAPPY_FACE 54189
#define IDS_AX_IMAGE_ANNOTATION_ICON_SAD_FACE 54190
#define IDS_AX_IMAGE_ANNOTATION_ICON_MOON 54191
#define IDS_AX_IMAGE_ANNOTATION_ICON_CLOUD 54192
#define IDS_AX_IMAGE_ANNOTATION_ICON_SUN 54193

// ---------------------------------------------------------------------------
// From blink_strings.h:

#define IDS_DETAILS_WITHOUT_SUMMARY_LABEL 50000
#define IDS_FORM_CALENDAR_CLEAR 50001
#define IDS_FORM_CALENDAR_TODAY 50002
#define IDS_FORM_SUBMIT_LABEL 50003
#define IDS_FORM_INPUT_ALT 50004
#define IDS_FORM_RESET_LABEL 50005
#define IDS_FORM_FILE_BUTTON_LABEL 50006
#define IDS_FORM_MULTIPLE_FILES_BUTTON_LABEL 50007
#define IDS_FORM_FILE_NO_FILE_LABEL 50008
#define IDS_FORM_FILE_MULTIPLE_UPLOAD 50009
#define IDS_FORM_OTHER_COLOR_LABEL 50010
#define IDS_FORM_OTHER_DATE_LABEL 50011
#define IDS_FORM_OTHER_MONTH_LABEL 50012
#define IDS_FORM_OTHER_WEEK_LABEL 50013
#define IDS_FORM_PLACEHOLDER_FOR_DAY_OF_MONTH_FIELD 50014
#define IDS_FORM_PLACEHOLDER_FOR_MONTH_FIELD 50015
#define IDS_FORM_PLACEHOLDER_FOR_YEAR_FIELD 50016
#define IDS_FORM_SELECT_MENU_LIST_TEXT 50017
#define IDS_FORM_THIS_MONTH_LABEL 50018
#define IDS_FORM_THIS_WEEK_LABEL 50019
#define IDS_FORM_WEEK_NUMBER_LABEL 50020
#define IDS_DEBUGGER_PAUSED_IN_ANOTHER_TAB 50021
#define IDS_VIEW_SOURCE_LINE_WRAP 50022
#define IDS_FORM_INPUT_WEEK_TEMPLATE 50023
#define IDS_FORM_VALIDATION_VALUE_MISSING_MULTIPLE_FILE 50024
#define IDS_FORM_VALIDATION_TYPE_MISMATCH 50025
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY 50026
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_DOMAIN 50027
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_LOCAL 50028
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOMAIN 50029
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOTS 50030
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_LOCAL 50031
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_NO_AT_SIGN 50032
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_MULTIPLE_EMAIL 50033
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL 50034
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL_DATETIME 50035
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW 50036
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW_DATETIME 50037
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW 50038
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW_DATETIME 50039
#define IDS_FORM_VALIDATION_REVERSED_RANGE_OUT_OF_RANGE_TIME 50040
#define IDS_FORM_VALIDATION_RANGE_REVERSED 50041
#define IDS_FORM_VALIDATION_RANGE_INVALID_DATETIME 50042
#define IDS_FORM_VALIDATION_BAD_INPUT_DATETIME 50043
#define IDS_FORM_VALIDATION_BAD_INPUT_NUMBER 50044
#define IDS_PRETTY_PRINT_JSON 50045
#define IDS_FORM_VALIDATION_VALUE_MISSING 50046
#define IDS_FORM_VALIDATION_VALUE_MISSING_CHECKBOX 50047
#define IDS_FORM_VALIDATION_VALUE_MISSING_FILE 50048
#define IDS_FORM_VALIDATION_VALUE_MISSING_RADIO 50049
#define IDS_FORM_VALIDATION_VALUE_MISSING_SELECT 50050
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL 50051
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_URL 50052
#define IDS_FORM_VALIDATION_PATTERN_MISMATCH 50053
#define IDS_FORM_VALIDATION_STEP_MISMATCH 50054
#define IDS_FORM_VALIDATION_STEP_MISMATCH_CLOSE_TO_LIMIT 50055
#define IDS_FORM_VALIDATION_TOO_LONG 50056
#define IDS_FORM_VALIDATION_TOO_SHORT 50057
#define IDS_FORM_VALIDATION_TOO_SHORT_PLURAL 50058
#define IDS_MEDIA_SESSION_FILE_SOURCE 50059
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS 50060
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS_SUBMENU_TITLE 50061
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED 50062
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_SUBMENU_TITLE 50063
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_25X_TITLE 50064
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_5X_TITLE 50065
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_75X_TITLE 50066
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_NORMAL_TITLE 50067
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_25X_TITLE 50068
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_5X_TITLE 50069
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_75X_TITLE 50070
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_2X_TITLE 50071
#define IDS_MEDIA_OVERFLOW_MENU_CAST 50072
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_FULLSCREEN 50073
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_FULLSCREEN 50074
#define IDS_MEDIA_OVERFLOW_MENU_MUTE 50075
#define IDS_MEDIA_OVERFLOW_MENU_UNMUTE 50076
#define IDS_MEDIA_OVERFLOW_MENU_PLAY 50077
#define IDS_MEDIA_OVERFLOW_MENU_PAUSE 50078
#define IDS_MEDIA_OVERFLOW_MENU_DOWNLOAD 50079
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_PICTURE_IN_PICTURE 50080
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_PICTURE_IN_PICTURE 50081
#define IDS_MEDIA_PICTURE_IN_PICTURE_INTERSTITIAL_TEXT 50082
#define IDS_MEDIA_REMOTING_CAST_TEXT 50083
#define IDS_MEDIA_REMOTING_CAST_TO_UNKNOWN_DEVICE_TEXT 50084
#define IDS_MEDIA_REMOTING_STOP_TEXT 50085
#define IDS_MEDIA_REMOTING_STOP_BY_PLAYBACK_QUALITY_TEXT 50086
#define IDS_MEDIA_REMOTING_STOP_BY_ERROR_TEXT 50087
#define IDS_MEDIA_SCRUBBING_MESSAGE_TEXT 50088
#define IDS_MEDIA_TRACKS_NO_LABEL 50089
#define IDS_MEDIA_TRACKS_OFF 50090
#define IDS_PLUGIN_INITIALIZATION_ERROR 50091
#define IDS_MEDIA_PLAYBACK_ERROR 50092
#define IDS_UNITS_KIBIBYTES 50093
#define IDS_UNITS_MEBIBYTES 50094
#define IDS_UNITS_GIBIBYTES 50095
#define IDS_UNITS_TEBIBYTES 50096
#define IDS_UNITS_PEBIBYTES 50097

// ---------------------------------------------------------------------------
// From branded_strings.h:

#define IDS_RELAUNCH_CONFIRMATION_DIALOG_TITLE 800
#define IDS_SETTINGS_ABOUT_PROGRAM 801
#define IDS_SETTINGS_GET_HELP_USING_CHROME 802
#define IDS_SETTINGS_UPGRADE_UPDATING 803
#define IDS_SETTINGS_UPGRADE_UPDATING_PERCENT 804
#define IDS_SETTINGS_UPGRADE_SUCCESSFUL_RELAUNCH 805
#define IDS_SETTINGS_UPGRADE_UP_TO_DATE 806
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_OFFLINE 809
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_SIGNED_OUT 810
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_NO_PASSWORDS 811
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT_GOOGLE_ACCOUNT 812
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT 813
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_GENERIC 814
#define IDS_SETTINGS_NO_COMPROMISED_CREDENTIALS_LABEL 815
#define IDS_SETTINGS_SIGNED_OUT_USER_LABEL 816
#define IDS_SETTINGS_SIGNED_OUT_USER_HAS_COMPROMISED_CREDENTIALS_LABEL 817
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION_GENERATION 818
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_DESCRIPTION 819
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_WHEN_ON_SAVED_INFO 820
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_WHEN_ON_USE_TO_FILL 821
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_DESCRIPTION 822
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_TOGGLE_SUB_LABEL 823
#define IDS_SETTINGS_DEFAULT_BROWSER_DEFAULT 824
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT 825
#define IDS_SETTINGS_DEFAULT_BROWSER_ERROR 826
#define IDS_SETTINGS_DEFAULT_BROWSER_SECONDARY 827
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_TWO 828
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_TWO 829
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_THINGS_TO_CONSIDER_BULLET_TWO 830
#define IDS_SETTINGS_PRELOAD_PAGES_THINGS_TO_CONSIDER_BULLET_ONE 831
#define IDS_SETTINGS_SPELLING_PREF_DESC 832
#define IDS_SETTINGS_RESTART_TO_APPLY_CHANGES 833
#define IDS_SETTINGS_SIGNIN_ALLOWED 834
#define IDS_SETTINGS_SIGNIN_ALLOWED_DESC 835
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_BLOCKED 836
#define IDS_SETTINGS_SITE_SITE_DETAILS_CAMERA_BLOCKED_BY_OS 837
#define IDS_SETTINGS_SITE_SITE_DETAILS_MICROPHONE_BLOCKED_BY_OS 838
#define IDS_SETTINGS_SITE_SITE_DETAILS_LOCATION_BLOCKED_BY_OS 839
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_BY_OS 840
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_BY_OS 841
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_BY_OS 842
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_SUBLABEL 843
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_WITH_EXCEPTION_RADIO_SUBLABEL 844
#define IDS_SETTINGS_SITE_DATA_PAGE_DELETE_ON_EXIT_EXCEPTIONS_SUB_HEADING 845
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_BODY 846
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION2 847
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_PRIVACY_DESCRIPTION1 848
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL 849
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_SUB_LABEL 850
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION3 851
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION2 852
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_TITLE 853
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_TYPES 854
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_USAGE 855
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_MANAGEMENT 856
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_TYPES 857
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_USAGE 858
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION 859
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_TRIALS_OFF 860
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_LISTS_EMPTY 861
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_TITLE 862
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_1 863
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_2 864
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_3 865
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_1 866
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION 867
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION_TRIALS_OFF 868
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_SUBLABEL 869
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_TWO 870
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_TWO 871
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_ONE 872
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_LEARN_MORE_LABEL 873
#define IDS_SETTINGS_SECURE_DNS_DESCRIPTION 874
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_SINGULAR 875
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_PLURAL 876
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITHOUT_COUNTS 877
#define IDS_SETTINGS_CUSTOMIZE_YOUR_CHROME_PROFILE 878
#define IDS_SETTING_NAME_YOUR_PROFILE 879
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT_SECONDARY_WITH_ACCOUNT 880
#define IDS_SETTINGS_PEOPLE_EXPLICIT_SIGN_IN_PROMPT_SECONDARY_WITH_NO_ACCOUNT 881
#define IDS_SETTINGS_PEOPLE_ACCOUNT_AWARE_SIGNIN_ACCOUNT_ROW_TITLE 882
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTIONS_TITLE 884
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTIONS_DESC 885
#define IDS_SETTINGS_SYNC_DATA_ENCRYPTED_TEXT 886
#define IDS_SETTINGS_SYNC_DISCONNECT_TITLE 887
#define IDS_SETTINGS_SUGGEST_PREF_DESC 888
#define IDS_SETTINGS_SYNC_SIGN_IN_PROMPT_WITH_NO_ACCOUNT 889
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_DESC 890
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_DESC_WITH_LINKED_SERVICES 891
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_LINKED_SERVICES_DESC 892
#define IDS_SETTINGS_ERROR_PASSPHRASE_USER_ERROR_DESCRIPTION 893
#define IDS_SETTINGS_ERROR_TRUSTED_VAULT_USER_ERROR_DESCRIPTION 894
#define IDS_SETTINGS_ERROR_UPGRADE_CLIENT_USER_ERROR_DESCRIPTION 895
#define IDS_SETTINGS_PENDING_STATE_DESCRIPTION 896
#define IDS_SETTINGS_ERROR_PASSPHRASE_USER_ERROR_DESCRIPTION_WITH_EMAIL 897
#define IDS_SETTINGS_SIGN_OUT 898
#define IDS_SETTINGS_PAGE_CONTENT_THINGS_TO_CONSIDER_BULLET_TWO 899
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_SETTING_DESCRIPTION 900
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING_DESCRIPTION 901
#define IDS_SETTINGS_PERFORMANCE_PRELOAD_TOGGLE_SUMMARY 902
#define IDS_SETTINGS_LANGUAGES_IS_DISPLAYED_IN_THIS_LANGUAGE 903
#define IDS_SETTINGS_LANGUAGES_DISPLAY_IN_THIS_LANGUAGE 904
#define IDS_SETTINGS_SYSTEM_BACKGROUND_APPS_LABEL 905
#define IDS_SETTINGS_RESET_PROFILE_FEEDBACK 906
#define IDS_SETTINGS_CHROME_CERTIFICATES 907
#define IDS_SETTINGS_CHROME_CERTIFICATES_DESCRIPTION 908
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_NOTHING_TO_DO 909
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_HEADER 910
#define IDS_SETTINGS_SAFETY_HUB_EMPTY_STATE_MODULE_SUBHEADER 911
#define IDS_SETTINGS_SAFETY_HUB_VERSION_MODULE_UPPERCASE_NAME 912
#define IDS_SETTINGS_SAFETY_HUB_VERSION_MODULE_LOWERCASE_NAME 913
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_NO_PASSWORDS 914
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_MODULE_HEADER 915
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_DATA_HEADER 916
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_DATA_SUBHEADER 917
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_INCOGNITO_HEADER 918
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_SAFE_BROWSING_SUBHEADER 919
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_HEADER_RESTART 920
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_HEADER_UPDATED 921
#define IDS_SETTINGS_SAFETY_HUB_VERSION_NAVIGATION_ARIA_LABEL 922
#define IDS_SETTINGS_SAFETY_HUB_VERSION_RELAUNCH_ARIA_LABEL 923
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_ONE_PERMISSION_LABEL 924
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_TWO_PERMISSIONS_LABEL 925
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_THREE_PERMISSIONS_LABEL 926
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_REMOVED_FOUR_OR_MORE_PERMISSIONS_LABEL 927
#define IDS_SETTINGS_SAFETY_HUB_ABUSIVE_NOTIFICATION_PERMISSIONS_SETTING_SUBLABEL 928
#define IDS_SETTINGS_SECURE_CONNECTIONS_SECTION_DESCRIPTION 929
#define IDS_SETTINGS_HTTPS_FIRST_MODE_SUBTITLE 930
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_FULL_SUBLABEL 931
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_INCOGNITO_SUBLABEL 932
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DISABLED_SUBLABEL 933
#define IDS_PRODUCT_NAME 101
#define IDS_SHORT_PRODUCT_NAME 103
#define IDS_SXS_SHORTCUT_NAME 934
#define IDS_SHORTCUT_NAME_BETA 935
#define IDS_SHORTCUT_NAME_DEV 936
#define IDS_PRODUCT_DESCRIPTION 937
#define IDS_WELCOME_TO_CHROME 938
#define IDS_PRODUCT_LOGO_ENTERPRISE_ALT_TEXT 943
#define IDS_SHORTCUT_NEW_WINDOW 944
#define IDS_TASK_MANAGER_TITLE 945
#define IDS_TASK_MANAGER_SEARCH_PLACEHOLDER 946
#define IDS_TASK_MANAGER_SEARCH_ACCESSIBILITY_NAME 947
#define IDS_TASK_MANAGER_CLEAR_SEARCH_BUTTON_ACCESSIBILITY_NAME 948
#define IDS_TASK_MANAGER_KILL_ACCESSIBILITY_NAME 949
#define IDS_TASK_MANAGER_CATEGORY_TABS_AND_EXTENSIONS_NAME 950
#define IDS_TASK_MANAGER_CATEGORY_SYSTEM_NAME 951
#define IDS_TASK_MANAGER_CATEGORY_BROWSER_NAME 952
#define IDS_SESSION_CRASHED_VIEW_UMA_OPTIN 953
#define IDS_BROWSER_WINDOW_TITLE_FORMAT 475
#define IDS_CAPTIVE_PORTAL_BROWSER_WINDOW_TITLE_FORMAT 954
#define IDS_ACCESSIBLE_BROWSER_WINDOW_TITLE_FORMAT 694
#define IDS_ACCESSIBLE_BETA_BROWSER_WINDOW_TITLE_FORMAT 955
#define IDS_ACCESSIBLE_DEV_BROWSER_WINDOW_TITLE_FORMAT 956
#define IDS_ACCESSIBLE_CANARY_BROWSER_WINDOW_TITLE_FORMAT 957
#define IDS_ABOUT_VERSION_COMPANY_NAME 958
#define IDS_ABOUT_VERSION_COPYRIGHT 959
#define IDS_ABOUT_TERMS_OF_SERVICE 963
#define IDS_WIN_XP_VISTA_OBSOLETE 965
#define IDS_WIN_7_OBSOLETE 966
#define IDS_WIN_8_OBSOLETE 967
#define IDS_WIN_8_1_OBSOLETE 968
#define IDS_ACCNAME_APP 437
#define IDS_BROWSER_HUNGBROWSER_MESSAGE 970
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES 971
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES_ORIGIN 972
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_NOT_FOUND 973
#define IDS_UNINSTALL_CLOSE_APP 974
#define IDS_UNINSTALL_VERIFY 975
#define IDS_UNINSTALL_CHROME 976
#define IDS_FR_CUSTOMIZE_DEFAULT_BROWSER 977
#define IDS_STATUS_TRAY_KEEP_CHROME_RUNNING_IN_BACKGROUND 978
#define IDS_CANT_WRITE_USER_DIRECTORY_SUMMARY 979
#define IDS_PROFILE_TOO_NEW_ERROR 981
#define IDS_PREFERENCES_UNREADABLE_ERROR 982
#define IDS_PREFERENCES_CORRUPT_ERROR 983
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_C 985
#define IDS_PASSWORD_MANAGER_TITLE_BRAND 986
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SAVING_ON_DEVICE 987
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 988
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 989
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT 991
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT 992
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT 993
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT 994
#define IDS_PASSWORDS_PAGE_DELETE_ALL_DATA_AUTHENTICATION_PROMPT 995
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT 996
#define IDS_INSTALL_HIGHER_VERSION 997
#define IDS_INSTALL_FAILED 998
#define IDS_SAME_VERSION_REPAIR_FAILED 999
#define IDS_SETUP_PATCH_FAILED 1000
#define IDS_INSTALL_OS_NOT_SUPPORTED 1001
#define IDS_INSTALL_OS_ERROR 1002
#define IDS_INSTALL_SINGLETON_ACQUISITION_FAILED 1003
#define IDS_INSTALL_TEMP_DIR_FAILED 1004
#define IDS_INSTALL_UNCOMPRESSION_FAILED 1005
#define IDS_INSTALL_INVALID_ARCHIVE 1006
#define IDS_INSTALL_INSUFFICIENT_RIGHTS 1007
#define IDS_INSTALL_EXISTING_VERSION_LAUNCHED 1008
#define IDS_ELEVATION_SERVICE_DESCRIPTION 1009
#define IDS_TRACING_SERVICE_DESCRIPTION 1010
#define IDS_SHORTCUT_TOOLTIP 1011
#define IDS_UNINSTALL_DELETE_PROFILE 1012
#define IDS_UNINSTALL_SET_DEFAULT_BROWSER 1013
#define IDS_UNINSTALL_BUTTON_TEXT 1014
#define IDS_DEFAULT_BROWSER_INFOBAR_TEXT 1015
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNKNOWN_SOURCE 1016
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_BLOCKED_LEARN_MORE_LINK 1017
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_LOCAL_DECRYPTION 1018
#define IDS_DOWNLOAD_STATUS_CRX_INSTALL_RUNNING 1019
#define IDS_PROMPT_DOWNLOAD_CHANGES_SETTINGS 1020
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_URL 1021
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_CONTENT 1022
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING 1023
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_FILETYPE 1024
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS 1025
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_COOKIE_THEFT 1026
#define IDS_BLOCK_DOWNLOAD_REASON_DANGEROUS_COOKIE_THEFT_AND_ACCOUNT 1027
#define IDS_BLOCK_DOWNLOAD_REASON_UNCOMMON 1028
#define IDS_BLOCK_DOWNLOAD_REASON_UNCOMMON_SUSPICIOUS_ARCHIVE 1029
#define IDS_BLOCK_DOWNLOAD_REASON_POTENTIALLY_UNWANTED 1030
#define IDS_BLOCK_DOWNLOAD_REASON_INSECURE 1031
#define IDS_BLOCK_DOWNLOAD_REASON_UNVERIFIED_NO_SAFE_BROWSING 1032
#define IDS_DOWNLOAD_WARNING_BYPASS_PROMPT_LEARN_MORE_LINK 1033
#define IDS_DOWNLOAD_WARNING_BYPASS_PROMPT_LEARN_MORE_LINK_ACCESSIBLE 1034
#define IDS_ABANDON_DOWNLOAD_DIALOG_BROWSER_MESSAGE 1035
#define IDS_MISSING_GOOGLE_API_KEYS 1037
#define IDS_EXTENSION_INSTALLED_HEADING 1038
#define IDS_EXTENSION_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX 1039
#define IDS_EXTENSION_ALERT_ITEM_BLOCKLISTED_MALWARE 1040
#define IDS_EXTENSIONS_ALERT_ITEM_BLOCKLISTED_MALWARE_TITLE 1041
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_KEEP_DIALOG_DESCRIPTION 1042
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_DESCRIPTION 1043
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_DISABLED_SUBTITLE 1044
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISABLED_SUBTITLE 1045
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_REMOVE_BUTTON_ACC_LABEL 1046
#define IDS_SAFETY_CHECK_EXTENSIONS_MALWARE 1047
#define IDS_SAFETY_CHECK_EXTENSIONS_POLICY_VIOLATION 1048
#define IDS_SAFETY_CHECK_EXTENSIONS_UNPUBLISHED 1049
#define IDS_EXTENSIONS_SAFETY_CHECK_PRIMARY_LABEL 1050
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE 1051
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE_ON 1052
#define IDS_EXTENSIONS_SAFETY_CHECK_OFFSTORE_OFF 1053
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES 1054
#define IDS_EXTENSIONS_SC_DESCRIPTION 1055
#define IDS_EXTENSIONS_ITEM_SHOW_ACCESS_REQUESTS_IN_TOOLBAR 1056
#define IDS_EXTENSIONS_INCOGNITO_WARNING 1057
#define IDS_EXTENSIONS_UNINSTALL 1058
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_IN_CHROME 1059
#define IDS_EXTENSIONS_MULTIPLE_UNSUPPORTED_DISABLED_BODY 1060
#define IDS_EXTENSIONS_SINGLE_UNSUPPORTED_DISABLED_BODY 1061
#define IDS_APPMENU_TOOLTIP 438
#define IDS_APPMENU_TOOLTIP_UPDATE_AVAILABLE 1062
#define IDS_APPMENU_TOOLTIP_ALERT 1063
#define IDS_OPEN_IN_CHROME 1064
#define IDS_ABOUT 1065
#define IDS_RELAUNCH_TO_UPDATE 1066
#define IDS_VIEW_PASSWORDS 1070
#define IDS_CHROME_SIGNIN_TITLE 1071
#define IDS_PROFILES_DICE_SYNC_PROMO 1072
#define IDS_SYNC_WRONG_EMAIL 1073
#define IDS_SYNC_USED_PROFILE_ERROR 1074
#define IDS_ENTERPRISE_SIGNIN_TITLE 1075
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITHOUT_PROFILE_CREATION 1076
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITH_PROFILE_CREATION 1077
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_TITLE 1078
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_CREATION 1079
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_ISOLATION_NOTICE 1080
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_EXPLANATION 1081
#define IDS_ENTERPRISE_VALUE_PROPOSITION_PROFILE_REQUIRED_BY_ORG_TITLE 1082
#define IDS_ENTERPRISE_VALUE_PROPOSITION_PROFILE_REQUIRED_BY_ORG_KNOWN_DOMAIN_TITLE 1083
#define IDS_ENTERPRISE_VALUE_PROPOSITION_PROFILE_SUGGESTED_TITLE 1084
#define IDS_ONE_CLICK_SIGNIN_DIALOG_TITLE_NEW 1085
#define IDS_ONE_CLICK_SIGNIN_DIALOG_MESSAGE_NEW 1086
#define IDS_MANAGEMENT_DIALOG_BROWSER_MANAGED 1087
#define IDS_MANAGEMENT_DIALOG_BROWSER_MANAGED_BY 1088
#define IDS_MANAGEMENT_DIALOG_BROWSER_MANAGED_BY_MULTIPLE_ORGANIZATIONS 1089
#define IDS_MANAGED_PROFILE_INTERSTITIAL_PRIMARY_PARAGRAPH 1090
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_TITLE 1091
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_BODY_PART_1 1092
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_TITLE_FALLBACK 1093
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_UNKNOWN_BROWSER 1094
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_KNOWN_BROWSER 1095
#define IDS_NTP_CUSTOMIZE_BUTTON_LABEL 508
#define IDS_SIGNIN_EMAIL_CONFIRMATION_TITLE 1096
#define IDS_AVATAR_BUTTON_INTERCEPT_BUBBLE_CHROME_SIGNIN_TEXT 1097
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_TITLE 1098
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_DECLINE_TEXT 1099
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE 1100
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE_V2 1101
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_TITLE 1102
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC 1103
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2 1104
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2_SUPERVISED 1105
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC 1106
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_DESC 1107
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC_MANAGED_DEVICE 1108
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_DEVICE 1109
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_SUBTITLE 1110
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_SUBTITLE_SUPERVISED 1111
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TEXT_SIGNIN_REMINDER 1112
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TEXT_SIGNIN_REMINDER_SCREENREADER 1113
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_NO_UNSYNCED_TITLE 1114
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_NO_UNSYNCED_BODY 1115
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_VERIFY_BODY 1116
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_UNSYNCED_BODY 1117
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_TEXT 1118
#define IDS_SYNC_PASSPHRASE_DIALOG_FOOTER 1119
#define IDS_SYNC_PASSPHRASE_DIALOG_FOOTER_LINK_ACC 1120
#define IDS_SYNC_PASSPHRASE_DIALOG_BODY 1121
#define IDS_AVATAR_BUTTON_INTERCEPT_BUBBLE_CHROME_SIGNIN_ACCESSIBILITY_LABEL 1122
#define IDS_AVATAR_BUTTON_SIGNIN_PENDING_ACCESSIBILITY_LABEL 1123
#define IDS_AUTOFILL_SIGNIN_PROMO_SUBTITLE_PASSWORD 1124
#define IDS_AUTOFILL_SIGNIN_PROMO_SUBTITLE_ADDRESS 1125
#define IDS_PROFILE_CUSTOMIZATION_TEXT 1126
#define IDS_PROFILE_CUSTOMIZATION_TITLE_V2 1127
#define IDS_PROFILE_MENU_SIGNIN_PROMO_BUTTON 1132
#define IDS_PROFILE_MENU_PLACEHOLDER_PROFILE_NAME 1133
#define IDS_PROFILE_MENU_SIGN_OUT_WHEN_SIGNIN_PENDING 1134
#define IDS_PROFILE_MENU_PROFILES_LIST_TITLE 1135
#define IDS_PROFILE_MENU_MANAGE_PROFILES 1136
#define IDS_PROFILE_MENU_SIGN_OUT 1137
#define IDS_PROFILE_MENU_ADD_PROFILE 1138
#define IDS_APP_ALSO_DELETE_APPS_DATA 1140
#define IDS_APP_SHORTCUTS_SUBDIR_NAME 1141
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_CANARY 1142
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_BETA 1143
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_DEV 1144
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_AND_VIDEO 1146
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_ONLY 1147
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_VIDEO_ONLY 1148
#define IDS_WEBHID_SYSTEM_TRAY_ICON_TITLE 1149
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_TITLE 1150
#define IDS_LOGIN_POD_USER_REMOVE_WARNING_SYNC 1153
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TITLE 1154
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TEXT 1155
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TITLE 1156
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TEXT 1157
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_GUEST_TEXT 1158
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_FRIENDS_TEXT 1159
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_TEXT 1160
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_ADD_USER 1161
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_APP_MENU 1162
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORD_MANAGER 1163
#define IDS_TUTORIAL_PASSWORD_MANAGER_SUCCESS_BODY 1164
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_BODY 1165
#define IDS_SIDE_PANEL_GENERIC_MENU_IPH 1166
#define IDS_SIDE_PANEL_GENERIC_MENU_IPH_SCREENREADER 1167
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_PAGES 1168
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_SEARCH 1169
#define IDS_WEBSTORE_APP_DESCRIPTION 377
#define IDS_INBOUND_MDNS_RULE_NAME 1170
#define IDS_INBOUND_MDNS_RULE_NAME_BETA 1171
#define IDS_INBOUND_MDNS_RULE_NAME_CANARY 1172
#define IDS_INBOUND_MDNS_RULE_NAME_DEV 1173
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION 1174
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_BETA 1175
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_CANARY 1176
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_DEV 1177
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT 1178
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT_ONCE 1179
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TEXT 1180
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB_INAPP 1181
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD_INAPP 1182
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE 1183
#define IDS_UPDATE_RECOMMENDED 1184
#define IDS_RELAUNCH_AND_UPDATE 1185
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE_ALT 1186
#define IDS_UPDATE_RECOMMENDED_ALT 1187
#define IDS_REINSTALL_APP 1188
#define IDS_UPGRADE_BUBBLE_MENU_ITEM 1189
#define IDS_UPGRADE_BUBBLE_TITLE 1190
#define IDS_UPGRADE_BUBBLE_TEXT 1191
#define IDS_SYNC_ERROR_USER_MENU_UPGRADE_BUTTON 1192
#define IDS_SYNC_ERROR_PASSPHRASE_USER_MENU_ERROR_DESCRIPTION 1193
#define IDS_SYNC_ERROR_TRUSTED_VAULT_USER_MENU_ERROR_DESCRIPTION 1194
#define IDS_SYNC_ERROR_UPGRADE_CLIENT_USER_MENU_TITLE 1195
#define IDS_SYNC_ERROR_UPGRADE_CLIENT_USER_MENU_ERROR_DESCRIPTION 1196
#define IDS_SYNC_UPGRADE_CLIENT 1197
#define IDS_SYNC_UPGRADE_CLIENT_BUTTON 1198
#define IDS_RECOVERY_BUBBLE_TITLE 1199
#define IDS_RUN_RECOVERY 1200
#define IDS_RECOVERY_BUBBLE_TEXT 1201
#define IDS_CRITICAL_NOTIFICATION_TITLE 1202
#define IDS_CRITICAL_NOTIFICATION_TITLE_ALTERNATE 1203
#define IDS_CRITICAL_NOTIFICATION_TEXT 1204
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_TAB 1205
#define IDS_DESKTOP_MEDIA_PICKER_SCREEN_PERMISSION_TEXT_MAC 1206
#define IDS_DESKTOP_MEDIA_PICKER_SCREEN_PERMISSION_TEXT_PERIOD_MAC 1207
#define IDS_DESKTOP_MEDIA_PICKER_WINDOW_PERMISSION_TEXT_MAC 1208
#define IDS_DESKTOP_MEDIA_PICKER_WINDOW_PERMISSION_TEXT_PERIOD_MAC 1209
#define IDS_DESKTOP_MEDIA_PICKER_PERMISSION_RESTART_TEXT_MAC 1210
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_IPH 1228
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_IPH_SCREENREADER 1229
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_FOLLOWUP_IPH 1230
#define IDS_SIDE_PANEL_LENS_OVERLAY_PINNABLE_FOLLOWUP_IPH_SCREENREADER 1231
#define IDS_LENS_OVERLAY_COPY 1232
#define IDS_LENS_OVERLAY_COPY_TEXT 1233
#define IDS_LENS_OVERLAY_COPY_TOAST_MESSAGE 1234
#define IDS_LENS_OVERLAY_COPY_AS_IMAGE_TOAST_MESSAGE 1235
#define IDS_LENS_OVERLAY_MORE_OPTIONS_BUTTON_LABEL 1236
#define IDS_LENS_OVERLAY_MY_ACTIVITY 1237
#define IDS_LENS_OVERLAY_TOAST_DISMISS_MESSAGE 1238
#define IDS_LENS_OVERLAY_TRANSLATE 1239
#define IDS_LENS_OVERLAY_SELECT_TEXT 1240
#define IDS_LENS_OVERLAY_COPY_AS_IMAGE 1241
#define IDS_LENS_OVERLAY_SAVE_AS_IMAGE 1242
#define IDS_LENS_OVERLAY_LEARN_MORE 1243
#define IDS_LENS_OVERLAY_INITIAL_TOAST_LABEL 1244
#define IDS_LENS_OVERLAY_INITIAL_TOAST_MESSAGE 1245
#define IDS_LENS_OVERLAY_INITIAL_TOAST_MESSAGE_SELECT_TEXT 1246
#define IDS_LENS_OVERLAY_INITIAL_TOAST_ERROR_MESSAGE 1247
#define IDS_LENS_OVERLAY_INITIAL_TOAST_ERROR_EXIT_BUTTON_TEXT 1248
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_DRAG_MESSAGE 1249
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_TEXT_HIGHLIGHT_MESSAGE 1250
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_CLICK_MESSAGE 1251
#define IDS_LENS_OVERLAY_CURSOR_TOOLTIP_LIVE_PAGE_MESSAGE 1252
#define IDS_LENS_OVERLAY_AUTO_DETECT_LANGUAGE_LABEL 1253
#define IDS_LENS_OVERLAY_TRANSLATE_BUTTON_LABEL 1254
#define IDS_LENS_OVERLAY_SOURCE_LANGUAGE_PICKER_MENU_TITLE 1255
#define IDS_LENS_OVERLAY_TARGET_LANGUAGE_PICKER_MENU_TITLE 1256
#define IDS_LENS_OVERLAY_RECENT_LANGUAGES_LABEL 1257
#define IDS_LENS_OVERLAY_ALL_LANGUAGES_LABEL 1258
#define IDS_LENS_OVERLAY_DETECTED_LABEL 1259
#define IDS_LENS_OVERLAY_DETECT_LANGUAGE_LABEL 1260
#define IDS_LENS_SEND_FEEDBACK 1261
#define IDS_LENS_SEND_FEEDBACK_PLACEHOLDER 1262
#define IDS_LENS_OVERLAY_RENDERER_LABEL 1263
#define IDS_LENS_OVERLAY_CLOSE_TRANSLATE_SCREEN_LABEL 1264
#define IDS_LENS_OVERLAY_LANGUAGE_PICKER_LABEL 1265
#define IDS_LENS_OVERLAY_SOURCE_LANGUAGE_ACCESSIBILITY_LABEL 1266
#define IDS_LENS_OVERLAY_TARGET_LANGUAGE_ACCESSIBILITY_LABEL 1267
#define IDS_LENS_OVERLAY_SEARCH_LANGUAGE_PICKER_LABEL 1268
#define IDS_LENS_OVERLAY_TRANSLATE_BUTTON_IPH 1269
#define IDS_LENS_OVERLAY_TRANSLATE_BUTTON_IPH_SCREENREADER 1270
#define IDS_CONTENT_CONTEXT_LENS_OVERLAY 1271
#define IDS_CONTENT_LENS_OVERLAY_ENTRYPOINT_LABEL 1272
#define IDS_SIDE_PANEL_LENS_OVERLAY_TOOLBAR_TOOLTIP 1273
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CANCEL_BUTTON 1274
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CONTINUE_BUTTON 1275
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_CSB_DESCRIPTION 1276
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_DESCRIPTION 1277
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_LEARN_MORE_LINK 1278
#define IDS_LENS_PERMISSION_BUBBLE_DIALOG_TITLE 1279
#define IDS_SHOW_LENS_OVERLAY 1281
#define IDS_CONTEXT_MENU_SHOW_GOOGLE_LENS_SHORTCUT 1280
#define IDS_WELCOME_HEADER 1284
#define IDS_WIN_NOTIFICATION_SETTINGS_CONTEXT_MENU_ITEM_NAME 1285
#define IDS_RELAUNCH_RECOMMENDED_TITLE 1286
#define IDS_RELAUNCH_RECOMMENDED_BODY 1287
#define IDS_RELAUNCH_REQUIRED_TITLE_DAYS 1288
#define IDS_RELAUNCH_REQUIRED_TITLE_HOURS 1289
#define IDS_RELAUNCH_REQUIRED_TITLE_MINUTES 1290
#define IDS_RELAUNCH_REQUIRED_TITLE_SECONDS 1291
#define IDS_RELAUNCH_REQUIRED_BODY 1292
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_TOOLTIP 1293
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_ERROR 1294
#define IDS_ENTERPRISE_STARTUP_RELAUNCH_BUTTON 1295
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WEB_CONTENTS_ONLY 1296
#define IDS_IDLE_BUBBLE_TITLE_CLOSE 1297
#define IDS_IDLE_BUBBLE_BODY_CLOSE_AND_CLEAR 1298
#define IDS_IDLE_BUBBLE_BODY_CLEAR 1299
#define IDS_IDLE_BUBBLE_BODY_CLOSE 1300
#define IDS_IDLE_TIMEOUT_CLOSE_TITLE 1301
#define IDS_IDLE_TIMEOUT_CLEAR_TITLE 1302
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_TITLE 1303
#define IDS_IDLE_TIMEOUT_CLOSE_BODY 1304
#define IDS_IDLE_TIMEOUT_CLEAR_BODY 1305
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_BODY 1306
#define IDS_IDLE_DISMISS_BUTTON 1307
#define IDS_HATS_BUBBLE_TITLE 1308
#define IDS_EXTENSION_PERMISSIONS_BLOCKED_BY_PARENT_PROMPT_MESSAGE 1309
#define IDS_ENTERPRISE_WELCOME_PROFILE_INFORMATION_DETAILS 1310
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE 1311
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_V2 1312
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE 1313
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE 1314
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_TITLE 1315
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TEXT 1316
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TEXT 1317
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_TITLE 1318
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SUBTITLE 1319
#define IDS_FRE_SIGN_IN_TITLE_0 1320
#define IDS_FRE_DEFAULT_BROWSER_TITLE 1321
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE_NEW 1322
#define IDS_FRE_DEFAULT_BROWSER_ILLUSTRATION_ALT_TEXT 1323
#define IDS_APP_MENU_TOOLTIP_DEFAULT_PROMPT 1324
#define IDS_APP_MENU_BUTTON_DEFAULT_PROMPT 1325
#define IDS_SET_BROWSER_AS_DEFAULT_MENU_ITEM 1326
#define IDS_PROFILE_SWITCH_PROMO 1327
#define IDS_PROFILE_SWITCH_PROMO_SCREENREADER 1328
#define IDS_PASSWORD_MANAGER_IPH_BODY_WEB_APP_PROFILE_SWITCH 1329
#define IDS_SIGNOUT_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNOUT_IPH_TEXT 1330
#define IDS_SIGNOUT_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNOUT_IPH_TEXT_SCREENREADER 1331
#define IDS_QUIET_NOTIFICATION_IPH_TEXT 1333
#define IDS_QUIET_NOTIFICATION_IPH_TEXT_SCREENREADER 1334
#define IDS_CHROMELABS_RELAUNCH_FOOTER_MESSAGE 1335
#define IDS_SERIAL_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 1336
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_TITLE 1337
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_TITLE 1338
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION 1339
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION_UPDATED 1340
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_ACCEPT 1341
#define IDS_SETTINGS_SECURITY_V8_LINK_DESCRIPTION 1342
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_DESCRIPTION 1343
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_ALLOWED_SUB_LABEL 1344
#define IDS_FRIENDLY_COMPANY_NAME 1345
#define IDS_NO_UPDATE_RESPONSE 1346
#define IDS_INSTALL_UPDATER_FAILED 1347
#define IDS_INSTALLER_DISPLAY_NAME 1348
#define IDS_CLOSE_BUTTON 1349
#define IDS_MINIMIZE_BUTTON 1350
#define IDS_INITIALIZING 1351
#define IDS_WAITING_TO_CONNECT 1352
#define IDS_DOWNLOADING_SHORT 1353
#define IDS_DOWNLOADING_LONG 1354
#define IDS_DOWNLOADING_VERY_LONG 1355
#define IDS_DOWNLOADING_COMPLETED 1356
#define IDS_DOWNLOADING 1357
#define IDS_WAITING_TO_INSTALL 1358
#define IDS_INSTALLING 1359
#define IDS_CANCELING 1360
#define IDS_TEXT_RESTART_BROWSER 1361
#define IDS_TEXT_RESTART_ALL_BROWSERS 1362
#define IDS_TEXT_RESTART_COMPUTER 1363
#define IDS_UPDATER_CLOSE 1364
#define IDS_RESTART_NOW 1365
#define IDS_RESTART_LATER 1366
#define IDS_GET_HELP_TEXT 1367
#define IDS_INSTALLATION_STOPPED_WINDOW_TITLE 1368
#define IDS_INSTALL_STOPPED 1369
#define IDS_RESUME_INSTALLATION 1370
#define IDS_CANCEL_INSTALLATION 1371
#define IDS_BUNDLE_INSTALLED_SUCCESSFULLY 1372
#define IDS_UPDATER_OS_NOT_SUPPORTED 1373
#define IDS_EXTRA_CODE 1374
#define IDS_UNABLE_TO_GET_SETUP_LOCK 1375
#define IDS_WRONG_USER_ELEVATION_REQUIRED_ERROR 1376
#define IDS_WRONG_USER_DEELEVATION_REQUIRED_ERROR 1377
#define IDS_GENERIC_STARTUP_ERROR 1378
#define IDS_NO_NETWORK_PRESENT_ERROR 1379
#define IDS_ERROR_HTTPSTATUS_UNAUTHORIZED 1380
#define IDS_ERROR_HTTPSTATUS_FORBIDDEN 1381
#define IDS_ERROR_HTTPSTATUS_PROXY_AUTH_REQUIRED 1382
#define IDS_UNKNOWN_APPLICATION 1383
#define IDS_RESTRICTED_RESPONSE_FROM_SERVER 1384
#define IDS_OS_NOT_SUPPORTED 1385
#define IDS_HW_NOT_SUPPORTED 1386
#define IDS_NO_HASH 1387
#define IDS_UNSUPPORTED_PROTOCOL 1388
#define IDS_INTERNAL 1389
#define IDS_GENERIC_UPDATE_CHECK_ERROR 1390
#define IDS_DOWNLOAD_HASH_MISMATCH 1391
#define IDS_GENERIC_DOWNLOAD_ERROR 1392
#define IDS_UNPACK_CACHING_ERROR 1393
#define IDS_GENERIC_UNPACK_ERROR 1394
#define IDS_SERVICE_ERROR_CANCELLED 1395
#define IDS_GENERIC_SERVICE_ERROR 1396
#define IDS_GENERIC_INSTALL_ERROR 1397
#define IDS_GENERIC_INSTALLER_ERROR 1398
#define IDS_INSTALL_REBOOT 1399
#define IDS_APP_INSTALL_DISABLED_BY_GROUP_POLICY 1400
#define IDS_INVALID_INSTALLER_FILENAME 1401
#define IDS_INSTALLER_FAILED_TO_START 1402
#define IDS_INSTALLER_TIMED_OUT 1403
#define IDS_GENERIC_METAINSTALLER_ERROR 1404
#define IDS_FAILED_TO_ELEVATE_METAINSTALLER 1405
#define IDS_UPDATER_SERVICE_DISPLAY_NAME 1406
#define IDS_INTERNAL_UPDATER_SERVICE_DISPLAY_NAME 1407
#define IDS_UPDATER_SERVICE_DESCRIPTION 1408
#define IDS_MEMORY_SAVER_DIALOG_BODY 1409
#define IDS_MEMORY_SAVER_MODE_PROMO_TITLE 390
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_V1 1410
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_V2 1411
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_V3 1412
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_SINGULAR_V1 1413
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_SINGULAR_V2 1414
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_BODY_SINGULAR_V3 1415
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_SIGNED_IN 1416
#define IDS_CREATE_SHORTCUT_NOT_APPS_DIALOG_SUBTITLE 1417
#define IDS_CLEAR_BROWSING_DATA_TOAST_BODY 1419
#define IDS_EXTENSIONS_EXPLICIT_SIGNIN_BUTTON 1420
#define IDS_EXTENSION_INSTALLED_PROMO_EXPLICIT_SIGNIN_MESSAGE 1421

// ---------------------------------------------------------------------------
// From cef_strings.h:

#define IDS_TEXT_FILES 63330
#define IDS_CONTENT_CONTEXT_NO_SPELLING_SUGGESTIONS 63331

// ---------------------------------------------------------------------------
// From components_branded_strings.h:

#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_BODY 38100
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_HEADER 38101
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_CLIENT 38102
#define IDS_ERRORPAGES_SUGGESTION_PROXY_DISABLE_PLATFORM 38103
#define IDS_PAYMENTS_AUTOFILL_MANDATORY_REAUTH_PROMPT 38104
#define IDS_PAYMENTS_AUTOFILL_EDIT_CARD_MANDATORY_REAUTH_PROMPT 38105
#define IDS_FLAGS_UI_RELAUNCH_NOTICE 38106
#define IDS_CRASH_DISABLED_MESSAGE 38107
#define IDS_SHORT_PRODUCT_LOGO_ALT_TEXT 38108
#define IDS_VERSION_UI_LICENSE 38109
#define IDS_PAGE_INFO_INTERNAL_PAGE 38112
#define IDS_SESSION_CRASHED_VIEW_MESSAGE 38113
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 38114
#define IDS_INTERNAL_DEBUG_PAGES_DISABLED_BODY 38115

// ---------------------------------------------------------------------------
// From components_strings.h:

#define IDS_ASH_ARC_APP_COMPAT_DISABLED_COMPAT_MODE_BUTTON_TOOLTIP_PHONE 38140
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_TITLE 38141
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_BODY 38142
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_ACCEPT 38143
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_DONT_ASK_ME 38144
#define IDS_ASH_ARC_NEARBY_SHARE_FILE_PREPARATION_PROGRESS 38145
#define IDS_ASH_ARC_NEARBY_SHARE_FILES_PREPARATION_PROGRESS 38146
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE 38147
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE_PH 38148
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_TITLE 38149
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE 38150
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE_PH 38151
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_STORAGE_BUTTON 38152
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZE_SETTINGS 38153
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TITLE 38154
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_TITLE 38155
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY 38156
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY_UNRESIZABLE 38157
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_CLOSE 38158
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_LINK 38159
#define IDS_ARC_COMPAT_MODE_DISABLE_RESIZE_LOCK_TOAST 38160
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_ICON 38161
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_THROBBER 38162
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_MESSAGE 38163
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_AOD_MESSAGE 38164
#define IDS_ARC_GHOST_WINDOW_APP_FIXUP_MESSAGE 38165
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_TITLE 38166
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY 38167
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY_WITH_LEARN_MORE 38168
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_SUBSCRIPTION_BODY_WITH_LEARN_MORE 38169
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_LEARN_MORE_LABEL 38170
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_ALLOW_BUTTON 38171
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_DONT_ALLOW_BUTTON 38172
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_TITLE 38173
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_DAYS_UNTIL_DEADLINE 38174
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_ACCEPT_BUTTON_LABEL 38175
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_TITLE 38176
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SAVE_WORK_MESSAGE 38177
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_DAYS_UNTIL_DEADLINE 38178
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_NOW_BUTTON_LABEL 38179
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SKIP_BUTTON_LABEL 38180
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_BUTTON_LABEL 38181
#define IDS_ARC_VM_DATA_MIGRATION_LOADING_SCREEN_MESSAGE 38182
#define IDS_ARC_VM_DATA_MIGRATION_WELCOME_SCREEN_TITLE 38183
#define IDS_ARC_VM_DATA_MIGRATION_WHAT_TO_EXPECT_TITLE 38184
#define IDS_ARC_VM_DATA_MIGRATION_UPDATE_DESCRIPTION 38185
#define IDS_ARC_VM_DATA_MIGRATION_BLOCKING_BEHAVIOR_DESCRIPTION 38186
#define IDS_ARC_VM_DATA_MIGRATION_CONNECT_TO_CHARGER_MESSAGE 38187
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_FREE_DISK_SPACE_MESSAGE 38188
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_BATTERY_MESSAGE 38189
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_UPDATE_BUTTON_LABEL 38190
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_SKIP_BUTTON_LABEL 38191
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_SCREEN_TITLE 38192
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_DESCRIPTION 38193
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_RESUME_BUTTON_LABEL 38194
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_SCREEN_TITLE 38195
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_DESCRIPTION 38196
#define IDS_ARC_VM_DATA_MIGRATION_SUCCESS_SCREEN_TITLE 38197
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_FINISH_BUTTON_LABEL 38198
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_SCREEN_TITLE 38199
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_DESCRIPTION 38200
#define IDS_ARC_VM_DATA_MIGRATION_SEND_FEEDBACK_MESSAGE 38201
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_REPORT_BUTTON_LABEL 38202
#define IDS_ARC_VM_PRELOAD_NOTIFICATION_TITLE 38203
#define IDS_ARC_VM_PRELOAD_STARTED_MESSAGE 38204
#define IDS_ARC_VM_PRELOAD_SUCCEEDED_MESSAGE 38205
#define IDS_ARC_VM_PRELOAD_FAILED_MESSAGE 38206
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_LOCAL_SAVE 38207
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_UPLOAD_SAVE 38208
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_SAVE_NO_THANKS 38209
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_NO_THANKS 38210
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_ACCEPT 38211
#define IDS_AUTOFILL_GOOGLE_PAY_LOGO_ACCESSIBLE_NAME 38214
#define IDS_AUTOFILL_FIELD_LABEL_PHONE 38215
#define IDS_AUTOFILL_FIELD_LABEL_BILLING_ADDRESS 38216
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_LOCAL_SAVE_ACCEPT 38218
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_UPLOAD_SAVE_ACCEPT 38219
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CONTINUE 38221
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_LOCAL 38222
#define IDS_AUTOFILL_SAVE_CARD_ONLY_PROMPT_EXPLANATION_LOCAL 38223
#define IDS_AUTOFILL_SAVE_CARD_WITH_CVC_PROMPT_EXPLANATION_LOCAL 38224
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_LOCAL 38225
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_LOCAL 38226
#define IDS_AUTOFILL_FIX_FLOW_PROMPT_SAVE_CARD_LABEL 38227
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD 38228
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V3 38229
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V4 38230
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_SECURITY 38231
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_TO_CLOUD 38232
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARD_DESCRIPTION 38233
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARD_DESCRIPTION_WITH_NICKNAME 38234
#define IDS_AUTOFILL_CARD_SAVED 38238
#define IDS_AUTOFILL_CVC_SAVED 38239
#define IDS_AUTOFILL_DONE 38240
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION 38241
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3 38242
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_UPLOAD 38243
#define IDS_AUTOFILL_SAVE_CARD_WITH_CVC_PROMPT_EXPLANATION_UPLOAD 38244
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_SECURITY 38245
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME 38247
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME_TOOLTIP 38248
#define IDS_AUTOFILL_SAVE_CARD_CARDHOLDER_NAME_FIX_FLOW_HEADER 38249
#define IDS_AUTOFILL_SAVE_CARD_UPDATE_EXPIRATION_DATE_TITLE 38250
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_TOOLTIP 38253
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_AND_CARDHOLDER_NAME_TOOLTIP 38254
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_LOADING_THROBBER_ACCESSIBLE_NAME 38255
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_LOADING_THROBBER_ACCESSIBLE_NAME 38256
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_ANIMATION_LABEL 38257
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_TITLE 38258
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BUTTON_LABEL 38259
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BODY_TEXT 38260
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_OFFER 38261
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_DONE 38262
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_FIX 38263
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_CHECKBOX_UNCHECK_WARNING 38264
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_OFFER 38265
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_DONE 38266
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_ERROR 38267
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_FIX 38268
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_INVALID_CARD_REMOVED 38269
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_SAVE 38270
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_CANCEL 38271
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_DONE 38272
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_VIEW_CARDS 38273
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_LABEL_INVALID_CARDS 38274
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TRASH_CAN_BUTTON_TOOLTIP 38275
#define IDS_AUTOFILL_MASKED_SERVER_CARD_RISK_BASED_UNMASKING_ERROR_TITLE 38276
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_TITLE 38277
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_TITLE 38278
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_DESCRIPTION 38279
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_DESCRIPTION 38280
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_TITLE 38281
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_DESCRIPTION 38282
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_TEMPORARY_ERROR_TITLE 38283
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_PERMANENT_ERROR_TITLE 38284
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_TEMPORARY_ERROR_DESCRIPTION 38285
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_PERMANENT_ERROR_DESCRIPTION 38286
#define IDS_AUTOFILL_ERROR_DIALOG_NEGATIVE_BUTTON_LABEL 38287
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC 38288
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_SECURITY_CODE 38289
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_PERMANENT 38290
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_NETWORK 38291
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_BACK_OF_CARD 38292
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_FRONT_OF_CARD 38293
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION 38294
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION_FOR_AMEX 38295
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_DEFAULT 38296
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_EXPIRED_CARD 38297
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_VIRTUAL_CARD 38298
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_TITLE 38299
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE 38303
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE_SECURITY_CODE 38304
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_EXPIRED_TITLE 38305
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRM_BUTTON 38320
#define IDS_AUTOFILL_CARD_UNMASK_VERIFY_BUTTON 38321
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_MONTH 38322
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_YEAR 38323
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_IN_PROGRESS 38324
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_SUCCESS 38325
#define IDS_AUTOFILL_CARD_UNMASK_INVALID_EXPIRATION_DATE 38326
#define IDS_AUTOFILL_EXPIRATION_DATE_SEPARATOR 38327
#define IDS_AUTOFILL_CARD_UNMASK_NEW_CARD_LINK 38328
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_CVC 38329
#define IDS_AUTOFILL_DIALOG_ACCESSIBLE_NAME_SECURITY_CODE 38330
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_BAR_MESSAGE 38331
#define IDS_AUTOFILL_MASKED_SERVER_CARD_RISK_BASED_UNMASK_PROGRESS_BAR_MESSAGE 38332
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_DIALOG_TITLE 38333
#define IDS_AUTOFILL_IBAN_UNMASK_PROGRESS_DIALOG_TITLE 38334
#define IDS_AUTOFILL_IBAN_UNMASK_PROGRESS_BAR_MESSAGE 38335
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_DIALOG_TITLE 38336
#define IDS_AUTOFILL_CARD_UNMASK_CANCEL_BUTTON_LABEL 38337
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_MESSAGE 38338
#define IDS_AUTOFILL_3DS_FETCH_VCN_PROGRESS_DIALOG_LOADING_MESSAGE 38339
#define IDS_AUTOFILL_3DS_FETCH_VCN_PROGRESS_DIALOG_CONFIRMATION_MESSAGE 38340
#define IDS_AUTOFILL_IBAN_UNMASK_ERROR_DIALOG_TITLE 38341
#define IDS_AUTOFILL_IBAN_UNMASK_ERROR_DIALOG_MESSAGE 38342
#define IDS_PAYMENTS_AUTOFILL_FILLING_MANDATORY_REAUTH 38343
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE 38350
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE_ERROR 38351
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION 38352
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_OK_BUTTON_LABEL 38353
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION_ERROR 38354
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL 38355
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL_ERROR 38356
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_TITLE 38357
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_CANCEL_BUTTON_LABEL 38358
#define IDS_AUTOFILL_WALLET_MANAGEMENT_LINK_TEXT 38359
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT_LONG 38360
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_LOCAL 38361
#define IDS_AUTOFILL_SAVE_IBAN_LABEL 38362
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_SAVE_ACCEPT 38363
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_NICKNAME 38364
#define IDS_AUTOFILL_SAVE_IBAN_PLACEHOLDER 38365
#define IDS_IBAN_NICKNAME_COUNT_BY 38366
#define IDS_AUTOFILL_IBAN_SAVED 38367
#define IDS_AUTOFILL_MANAGE_SAVED_PAYMENT_METHODS 38368
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_SERVER 38369
#define IDS_AUTOFILL_UPLOAD_IBAN_PROMPT_EXPLANATION 38370
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_TITLE 38376
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_EXPLANATION 38377
#define IDS_AUTOFILL_MANDATORY_REAUTH_ICON_TOOLTIP 465
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_TITLE 38378
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_EXPLANATION 38379
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_SETTINGS_LINK 38380
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_TITLE 38384
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EDUCATIONAL_BODY_LABEL 38385
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_LEARN_MORE_LINK_LABEL 38386
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARD_NUMBER_LABEL 38387
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_ENROLLED_CARD_UNMASK_PROGRESS_DIALOG_TITLE 38388
#define IDS_AUTOFILL_VIRTUAL_CARD_ENTRY_PREFIX 38389
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_FALLBACK_ICON_TOOLTIP 464
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_TITLE_VIRTUAL_CARD 38390
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EDUCATIONAL_BODY_LABEL_VIRTUAL_CARD 38391
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_LEARN_MORE_LINK_LABEL_VIRTUAL_CARD 38392
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARD_NUMBER_LABEL_VIRTUAL_CARD 38393
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EXP_DATE_LABEL_VIRTUAL_CARD 38394
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARDHOLDER_NAME_LABEL_VIRTUAL_CARD 38395
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CVC_LABEL_VIRTUAL_CARD 38396
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_VIRTUAL_CARD_LABEL 38397
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_ICON_TOOLTIP_VIRTUAL_CARD 38398
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_BUTTON_TOOLTIP_NORMAL_VIRTUAL_CARD 38399
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_BUTTON_TOOLTIP_CLICKED_VIRTUAL_CARD 38400
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_NUMBER_SUGGESTION_LABEL 38401
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_EXPIRY_DATE_SUGGESTION_LABEL 38402
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_EXPIRY_YEAR_SUGGESTION_LABEL 38403
#define IDS_AUTOFILL_PAYMENTS_MANUAL_FALLBACK_AUTOFILL_POPUP_CC_EXPIRY_MONTH_SUGGESTION_LABEL 38404
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL 38405
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_ACCEPT_BUTTON_LABEL 38406
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_TITLE_LABEL 38407
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_CONTENT_LABEL 38408
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_SKIP 38409
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_NO_THANKS 38410
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_LEARN_MORE_LINK_LABEL 38411
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_CARD_IMAGE_TOOLTIP 38412
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_OPTION_VALUE 38413
#define IDS_AUTOFILL_VIRTUAL_CARD_NUMBER_SWITCH_LABEL 38414
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_LOADING_THROBBER_ACCESSIBLE_NAME 38415
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL 38426
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL_SCREENREADER 38427
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_TITLE 38428
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CARD_NUMBER_LABEL_VIRTUAL_CARD_IOS 38429
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_EXP_DATE_LABEL_VIRTUAL_CARD_IOS 38430
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_NAME_ON_CARD_LABEL_VIRTUAL_CARD_IOS 38431
#define IDS_AUTOFILL_FILLED_CARD_INFORMATION_BUBBLE_CVC_LABEL_VIRTUAL_CARD_IOS 38432
#define IDS_AUTOFILL_VIRTUAL_CARD_DISABLED_SUGGESTION_OPTION_VALUE 38433
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_SUGGESTION_IPH_BUBBLE_LABEL 38434
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_SUGGESTION_IPH_BUBBLE_LABEL_SCREENREADER 38435
#define IDS_AUTOFILL_CARD_INFO_RETRIEVAL_SUGGESTION_IPH_BUBBLE_FALLBACK_LABEL 38436
#define IDS_AUTOFILL_DISABLED_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP 38437
#define IDS_AUTOFILL_DISABLED_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL_DESKTOP_SCREENREADER 38438
#define IDS_AUTOFILL_CARD_AUTH_SELECTION_DIALOG_TITLE_MULTIPLE_OPTIONS 38439
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_ISSUER_CONFIRMATION_TEXT 38440
#define IDS_AUTOFILL_AUTHENTICATION_MODE_SECURITY_CODE 38441
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_TEXT_MESSAGE 38442
#define IDS_AUTOFILL_AUTHENTICATION_MODE_TEXT_MESSAGE 38443
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_EMAIL 38444
#define IDS_AUTOFILL_AUTHENTICATION_MODE_THREE_DOMAIN_SECURE 38445
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CURRENT_INFO_NOT_SEEN_TEXT 38446
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_CONTINUE 38447
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_SEND 38448
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CVC_CHALLENGE_INFO 38449
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_THREE_DOMAIN_SECURE_CHALLENGE_INFO 38450
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TITLE 38451
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_FOOTER_MESSAGE 38452
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_NEW_CODE_MESSAGE 38453
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TEXTFIELD_PLACEHOLDER_MESSAGE 38454
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_PENDING_MESSAGE 38455
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_VERIFICATION_CODE_EXPIRED_LABEL 38456
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_ENTER_CORRECT_CODE_LABEL 38457
#define IDS_AUTOFILL_LOADING_AND_CONSENT_DIALOG_TITLE_VCN_3DS 38458
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_DESCRIPTION_VCN_3DS 38459
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_OK_BUTTON_LABEL_VCN_3DS 38460
#define IDS_AUTOFILL_PAYMENTS_WINDOW_USER_CONSENT_DIALOG_ACCEPTANCE_ACCESSIBILITY_ANNOUNCEMENT 38461
#define IDS_AUTOFILL_REGULAR_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL_IOS 38462
#define IDS_AUTOFILL_BNPL_CREDIT_CARD_SUGGESTION_MAIN_TEXT 38463
#define IDS_AUTOFILL_BNPL_CREDIT_CARD_SUGGESTION_LABEL 38464
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_TEXT_FOR_SUGGESTIONS 38465
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_IPH_BUBBLE_LABEL 38466
#define IDS_AUTOFILL_CREDIT_CARD_BENEFIT_IPH_BUBBLE_LABEL_SCREENREADER 38467
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_LABEL 38468
#define IDS_AUTOFILL_SETTINGS_PAGE_CARD_BENEFITS_TOGGLE_SUBLABEL_WITH_LEARN_LINK 38469
#define IDS_AUTOFILL_SETTINGS_PAGE_BENEFITS_TERMS_TAG_FOR_CREDIT_CARD_LIST_ENTRY 38470
#define IDS_AUTOFILL_SETTINGS_PAGE_BENEFITS_TERMS_ARIA_LABEL 38471
#define IDS_AUTOFILL_OFFERS_CASHBACK 38477
#define IDS_AUTOFILL_CARD_LINKED_OFFER_REMINDER_TITLE 38478
#define IDS_AUTOFILL_OFFERS_REMINDER_POSITIVE_BUTTON_LABEL 38479
#define IDS_AUTOFILL_PROMO_CODE_SUGGESTIONS_FOOTER_TEXT 38480
#define IDS_AUTOFILL_OFFERS_REMINDER_ICON_TOOLTIP_TEXT 459
#define IDS_AUTOFILL_OFFERS_REMINDER_DESCRIPTION_TEXT 38481
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_REMINDER_TITLE 38484
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_TITLE 38485
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_NORMAL 38486
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_CLICKED 38487
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_VALUE_PROP_TEXT 38488
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_USE_THIS_CODE_TEXT 38489
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_CANT_FIND_CODE_MESSAGE 38490
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_OTP_INPUT_HINT 38491
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_POSITIVE_BUTTON_LABEL 38492
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_NEGATIVE_BUTTON_LABEL 38493
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_LABEL 38514
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_SUBLABEL 38515
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_LABEL 38518
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_ARIA_LABEL_FOR_NO_CVC_SAVED 38519
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_SUBLABEL 38520
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_WITH_DELETE_LINK_SUBLABEL 38521
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_TITLE 38522
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_DESCRIPTION 38523
#define IDS_AUTOFILL_SETTINGS_PAGE_CVC_TAG_FOR_CREDIT_CARD_LIST_ENTRY 38524
#define IDS_AUTOFILL_CVC_SUGGESTION_MAIN_TEXT 38526
#define IDS_AUTOFILL_SETTINGS_PAGE_CVC_SAVED_LABEL 38527
#define IDS_AUTOFILL_SETTINGS_PAGE_SUMMARY_SEPARATED_BY_PIPE 38528
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_SUCCESS_TITLE_TEXT 38531
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_TITLE_TEXT 38532
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_SUCCESS_TITLE_TEXT 38533
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_FAILURE_TITLE_TEXT 38534
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_SUCCESS_TITLE_TEXT 38535
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_TITLE_TEXT 38536
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 38537
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 38538
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 38539
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 38540
#define IDS_AUTOFILL_SAVE_IBAN_CONFIRMATION_FAILURE_HIT_MAX_STRIKE_DESCRIPTION_TEXT 38541
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_SUCCESS_DESCRIPTION_TEXT 38542
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_DESCRIPTION_TEXT 38543
#define IDS_AUTOFILL_SAVE_CARD_AND_VIRTUAL_CARD_ENROLL_CONFIRMATION_BUTTON_TEXT 38544
#define IDS_AUTOFILL_SAVE_CARD_CONFIRMATION_FAILURE_OK_BUTTON_ACCESSIBLE_NAME 38545
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLL_CONFIRMATION_FAILURE_OK_BUTTON_ACCESSIBLE_NAME 38546
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_TRIGGER_SUGGESTION_MAIN_TEXT 38548
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FILL_ALL_MAIN_TEXT 38549
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FILL_LABEL_TEXT 38550
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FILL_LABEL_SEPARATOR 38551
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FILL_SUGGESTION_AND_ONE_MORE_FIELD 38552
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FILL_SUGGESTION_AND_N_MORE_FIELDS 38553
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_TITLE 38554
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_NO_THANKS_BUTTON 38555
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_SAVE_BUTTON 38556
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SAVE_DIALOG_FOOTER_DETAILS 38557
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_ERROR_POPUP_MAIN_TEXT 38558
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_NO_INFO_POPUP_MAIN_TEXT 38559
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_MANAGE_PREDICTION_IMPROVEMENTS 38560
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_EDIT_INFORMATION_SUGGESTION_MAIN_TEXT 38561
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_LOADING_SUGGESTIONS_A11Y_HINT 38562
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_SUGGESTIONS_LOADED_A11Y_HINT 38563
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_DETAILS 38564
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FEEDBACK_TEXT 38565
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FEEDBACK_SUGGESTION_MANAGE_LINK_A11Y_HINT 38566
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FEEDBACK_SUGGESTION_FEEDBACK_BUTTONS_A11Y_HINT 38567
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FEEDBACK_THUMBS_UP_BUTTON_TOOLTIP 38568
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FEEDBACK_THUMBS_DOWN_BUTTON_TOOLTIP 38569
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_FEEDBACK_PLACEHOLDER 38570
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_IPH_TITLE 38571
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_IPH_BODY 38572
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_IPH_GO_TO_SETTINGS 38573
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_BOOTSTRAPPING_IPH 38574
#define IDS_AUTOFILL_PREDICTION_IMPROVEMENTS_BOOTSTRAPPING_IPH_SCREENREADER 38575
#define IDS_AUTOFILL_CLEAR_FORM_MENU_ITEM 38576
#define IDS_AUTOFILL_UNDO_MENU_ITEM 38577
#define IDS_AUTOFILL_WARNING_INSECURE_CONNECTION 38578
#define IDS_AUTOFILL_WARNING_MIXED_FORM 38579
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_CONFIRMATION_BODY 38580
#define IDS_AUTOFILL_DELETE_CREDIT_CARD_SUGGESTION_CONFIRMATION_BODY 38581
#define IDS_AUTOFILL_DELETE_PROFILE_SUGGESTION_CONFIRMATION_BODY 38582
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_TOOLTIP 38583
#define IDS_AUTOFILL_AUTOCOMPLETE_ENTRY_DELETED_A11Y_HINT 38584
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_A11Y_HINT 38585
#define IDS_AUTOFILL_CC_AMEX 38586
#define IDS_AUTOFILL_CC_AMEX_SHORT 38587
#define IDS_AUTOFILL_CC_DINERS 38588
#define IDS_AUTOFILL_CC_DISCOVER 38589
#define IDS_AUTOFILL_CC_ELO 38590
#define IDS_AUTOFILL_CC_GOOGLE_PAY 38591
#define IDS_AUTOFILL_CC_JCB 38592
#define IDS_AUTOFILL_CC_MASTERCARD 38593
#define IDS_AUTOFILL_CC_MIR 38594
#define IDS_AUTOFILL_CC_TROY 38595
#define IDS_AUTOFILL_CC_UNION_PAY 38596
#define IDS_AUTOFILL_CC_VERVE 38597
#define IDS_AUTOFILL_CC_VISA 38598
#define IDS_AUTOFILL_CC_GENERIC 38599
#define IDS_AUTOFILL_ADDRESS_SUMMARY_SEPARATOR 38600
#define IDS_AUTOFILL_DEVELOPER_TOOLS 38601
#define IDS_AUTOFILL_TEST_ADDRESS_BY_COUNTRY 38602
#define IDS_AUTOFILL_TEST_ADDRESS_SELECTED_A11Y_HINT 38603
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILLED_FORM 38604
#define IDS_AUTOFILL_A11Y_ANNOUNCE_EXPANDABLE_ONLY_ENTRY 38605
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILLED_CARD_INFORMATION_ENTRY 38606
#define IDS_AUTOFILL_A11Y_ANNOUNCE_EDIT_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 38607
#define IDS_AUTOFILL_A11Y_ANNOUNCE_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 38608
#define IDS_AUTOFILL_A11Y_ANNOUNCE_CLEARED_FORM 38609
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 38610
#define IDS_AUTOFILL_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 38611
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 38612
#define IDS_AUTOFILL_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 38613
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 38614
#define IDS_AUTOFILL_HIDE_SUGGESTIONS 38615
#define IDS_AUTOFILL_EDIT_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 38616
#define IDS_AUTOFILL_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 38617
#define IDS_AUTOFILL_HOUSE_NUMBER_SUGGESTION_SECONDARY_TEXT_OPTION_SELECTED 38618
#define IDS_AUTOFILL_STREET_NAME_SUGGESTION_SECONDARY_TEXT_OPTION_SELECTED 38619
#define IDS_AUTOFILL_HOUSE_NUMBER_SUGGESTION_SECONDARY_TEXT 38620
#define IDS_AUTOFILL_STREET_NAME_SUGGESTION_SECONDARY_TEXT 38621
#define IDS_AUTOFILL_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 38622
#define IDS_AUTOFILL_MANAGE_ADDRESSES 38623
#define IDS_AUTOFILL_MANAGE_PAYMENT_METHODS 38624
#define IDS_AUTOFILL_MANAGE_PASSWORDS 38625
#define IDS_AUTOFILL_SCAN_CREDIT_CARD 38626
#define IDS_AUTOFILL_SHOW_ALL_SAVED_FALLBACK 38627
#define IDS_AUTOFILL_SHOW_ACCOUNT_CARDS 38628
#define IDS_AUTOFILL_SAVE_AND_FILL_SUGGESTION_TITLE 38629
#define IDS_AUTOFILL_LOCAL_SAVE_AND_FILL_SUGGESTION_DESCRIPTION 38630
#define IDS_AUTOFILL_SERVER_SAVE_AND_FILL_SUGGESTION_DESCRIPTION 38631
#define IDS_AUTOFILL_POPUP_ACCESSIBLE_NODE_DATA 38632
#define IDS_AUTOFILL_IPH_EXTERNAL_ACCOUNT_PROFILE_SUGGESTION 38633
#define IDS_AUTOFILL_SUGGESTION_LABEL_SEPARATOR 38634
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR 38635
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR_V2 38636
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_NAME 38637
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_CARD_NUMBER 38638
#define IDS_AUTOFILL_LOADING_REGIONS 38639
#define IDS_AUTOFILL_ADDRESSES 38640
#define IDS_AUTOFILL_ADDRESSES_TABLE_ARIA_LABEL 38641
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_SUBLABEL 38642
#define IDS_AUTOFILL_LOCAL_PROFILE_ACCESSIBILITY_LABEL 38643
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_SUBLABEL 38644
#define IDS_AUTOFILL_DELETE_ACCOUNT_ADDRESS_RECORD_TYPE_NOTICE 38645
#define IDS_AUTOFILL_DELETE_SYNC_ADDRESS_RECORD_TYPE_NOTICE 38646
#define IDS_AUTOFILL_DELETE_LOCAL_ADDRESS_RECORD_TYPE_NOTICE 38647
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_RECORD_TYPE_NOTICE 38648
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_MIGRATION_RECORD_TYPE_NOTICE 38649
#define IDS_AUTOFILL_ADDRESS_ALREADY_SAVED_IN_ACCOUNT_RECORD_TYPE_NOTICE 38650
#define IDS_AUTOFILL_ADDRESS_WILL_BE_SAVED_IN_ACCOUNT_RECORD_TYPE_NOTICE 38651
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELD_FORM_ERROR 38652
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELDS_FORM_ERROR 38653
#define IDS_AUTOFILL_LOCAL_ADDRESS_ICON_A11Y_LABEL 38654
#define IDS_AUTOFILL_SYNC_TOGGLE_LABEL 38655
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_TITLE 38656
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_SUBLABEL 38657
#define IDS_AUTOFILL_PAYMENT_METHODS 38658
#define IDS_AUTOFILL_PAYMENT_METHODS_TABLE_ARIA_LABEL 38659
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_LABEL 38660
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_LABEL 38661
#define IDS_AUTOFILL_DELETE_ADDRESS_CONFIRMATION_DIALOG_TITLE 38662
#define IDS_SYNC_DATATYPE_PAYMENTS 38668
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_OK_BUTTON_LABEL 38673
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_MIGRATION_OK_BUTTON_LABEL 38674
#define IDS_AUTOFILL_ACCOUNT_MIGRATE_ADDRESS_PROMPT_TITLE 38675
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OK_BUTTON_LABEL 38676
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_OK_BUTTON_LABEL 38677
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_CANCEL_BUTTON_LABEL 38678
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_NEW_VALUES_SECTION_LABEL 38679
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OLD_VALUES_SECTION_LABEL 38680
#define IDS_AUTOFILL_MIGRATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 38681
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_PROMPT_ADDRESS_SOURCE_NOTICE 38682
#define IDS_AUTOFILL_UPDATE_PROMPT_ACCOUNT_ADDRESS_SOURCE_NOTICE 38683
#define IDS_AUTOFILL_SYNCABLE_PROFILE_MIGRATION_PROMPT_NOTICE 38684
#define IDS_AUTOFILL_LOCAL_PROFILE_MIGRATION_PROMPT_NOTICE 38685
#define IDS_AUTOFILL_SAVE_PROMPT_ADDRESS_SECTION_A11Y_LABEL 38686
#define IDS_AUTOFILL_SAVE_PROMPT_PHONE_SECTION_A11Y_LABEL 38687
#define IDS_AUTOFILL_SAVE_PROMPT_EMAIL_SECTION_A11Y_LABEL 38688
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_TITLE 466
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 38706
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_EDIT_BUTTON_TOOLTIP 38692
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_TITLE 38690
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_PROMPT_TITLE 38707
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_EDITOR_TITLE 38708
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_INTO_CHROME_PROMPT_BODY_TEXT 38709
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_INTO_ACCOUNT_PROMPT_BODY_TEXT 38710
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 38711
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_TITLE 38693
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 38712
#define IDS_AUTOFILL_MIGRATE_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 38713
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_UPDATE 38714
#define IDS_AUTOFILL_ADD_NEW_ADDRESS_DIALOG_OK_BUTTON_LABEL 38715
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_CANCEL_BUTTON_LABEL 38716
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_FILL_ADDRESS_A11Y_ADDON 38717
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_EXPAND_SHORTCUT 38718
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_EXPAND_SHORTCUT_RTL 38719
#define IDS_AUTOFILL_EXPANDABLE_SUGGESTION_SUBMENU_HINT 38720
#define IDS_AUTOFILL_SIGNIN_PROMO_TITLE_PASSWORD 38721
#define IDS_AUTOFILL_VERIFY_PROMO_SUBTITLE_PASSWORD 38722
#define IDS_AUTOFILL_POPUP_SEARCH_BAR_CLEAR_SEARCH_BUTTON_A11Y_NAME 38723
#define IDS_AUTOFILL_POPUP_SEARCH_BAR_PASSWORDS_INPUT_PLACEHOLDER 38724
#define IDS_AUTOFILL_POPUP_SEARCH_BAR_PASSWORDS_NOT_FOUND 38725
#define IDS_AUTOFILL_SIGNIN_PROMO_TITLE_ADDRESS 38726
#define IDS_AUTOFILL_VERIFY_PROMO_SUBTITLE_ADDRESS 38727
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_HISPANIC_MUNICIPIO 38728
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_FRENCH_LOCALITY_2 38729
#define IDS_AUTOFILL_ADDRESS_EDIT_DIALOG_JAPANESE_ALTERNATIVE_NAME 38730
#define IDS_BOOKMARK_BAR_FOLDER_NAME 147
#define IDS_BOOKMARK_BAR_MOBILE_FOLDER_NAME 149
#define IDS_BOOKMARK_BAR_OTHER_FOLDER_NAME 148
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DOMAIN_NAME 38733
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DEFAULT_NAME 150
#define IDS_BOOKMARK_EDITOR_TITLE 38734
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_NAME 38735
#define IDS_BOOKMARK_BUBBLE_REMOVE_BOOKMARK 38736
#define IDS_BOOKMARK_MANAGER_NAME_INPUT_PLACE_HOLDER 38737
#define IDS_BOOKMARK_MANAGER_URL_INPUT_PLACE_HOLDER 38738
#define IDS_TOOLTIP_STAR 469
#define IDS_CLEAR_BROWSING_DATA_CALCULATING 38739
#define IDS_DEL_BROWSING_HISTORY_COUNTER 38740
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SYNCED 38741
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE 38742
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY 38743
#define IDS_DEL_CACHE_COUNTER_BASIC 38744
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE_BASIC 38745
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY_BASIC 38746
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED 38747
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED_UPPER_ESTIMATE 38748
#define IDS_ANDROID_DEL_CACHE_COUNTER_ADVANCED_ALMOST_EMPTY 38749
#define IDS_DEL_PASSWORDS_COUNTER 38750
#define IDS_DEL_PASSWORDS_COUNTER_SYNCED 38751
#define IDS_DEL_ACCOUNT_PASSWORDS_COUNTER 38752
#define IDS_DEL_PASSWORDS_DOMAINS_DISPLAY 38753
#define IDS_DEL_PASSWORDS_COUNTER_AND_X_MORE 38754
#define IDS_DEL_SIGNIN_DATA_COUNTER 38755
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_NONE 38756
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_COMBINATION 38757
#define IDS_DEL_SITE_SETTINGS_COUNTER 38758
#define IDS_DEL_AUTOFILL_COUNTER_EMPTY 38759
#define IDS_DEL_AUTOFILL_COUNTER_PAYMENT_METHODS 38760
#define IDS_DEL_AUTOFILL_COUNTER_ADDRESSES 38761
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS 38762
#define IDS_DEL_AUTOFILL_COUNTER_USER_ANNOTATION_ENTRIES 38763
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_LONG 38764
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_SHORT 38765
#define IDS_DEL_AUTOFILL_COUNTER_ONE_TYPE_SYNCED 38766
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES 38767
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES_SYNCED 38768
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES 38769
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES_SYNCED 38770
#define IDS_DEL_AUTOFILL_SYNCABLE_NON_SYNCABLE_COMBINATION 38771
#define IDS_DEL_COOKIES_COUNTER 38772
#define IDS_DEL_COOKIES_COUNTER_ADVANCED 38773
#define IDS_DEL_COOKIES_COUNTER_ADVANCED_WITH_SIGNED_IN_EXCEPTION 38774
#define IDS_ANDROID_DEL_COOKIES_COUNTER_ADVANCED 38775
#define IDS_DEL_DOWNLOADS_COUNTER 38776
#define IDS_DEL_HOSTED_APPS_COUNTER 38777
#define IDS_DEL_HOSTED_APPS_COUNTER_AND_X_MORE 38778
#define IDS_DEL_TABS_COUNTER 38779
#define IDS_TABS_COUNT 38780
#define IDS_WINDOWS_COUNT 38781
#define IDS_DEL_TABS_MULTIWINDOW_COUNTER 38782
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_TITLE 38783
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_CONTENT 38784
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_NO_THANKS 38785
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_GET_DISCOUNTS 38786
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_TITLE 38787
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_CONTENT 38788
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_DONE 38789
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_ACCEPT_BUTTON 38790
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_TITLE 38791
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_BODY 38792
#define IDS_NTP_CART_DISCOUNT_STEP_ONE_CONTENT 662
#define IDS_OMNIBOX_TRACK_PRICE 444
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE 38793
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION 38794
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_EMAIL_DESCRIPTION 38795
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ACTION_BUTTON 38796
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_DESCRIPTION 38797
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_BUTTON 38798
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE_FIRST_RUN 38799
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION_FIRST_RUN 38800
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_CANCEL_BUTTON 38801
#define IDS_PRICE_TRACKING_SAVE_DESCRIPTION 38802
#define IDS_PRICE_TRACKING_SAVE_LOCATION 38803
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_BODY 38804
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_TITLE 38805
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_LEARN_MORE_LINK_TEXT 38806
#define IDS_PRICE_TRACKING_NOT_NOW 38807
#define IDS_PRICE_TRACKING_YES_IM_IN 38808
#define IDS_OMNIBOX_TRACKING_PRICE 38809
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_TITLE 38810
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_ACTION_BUTTON 38811
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_UNTRACK_BUTTON 38812
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_TITLE 38813
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION 38814
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION_BOOKMARK_REMOVED 38815
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_ACTION_BUTTON 38816
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION 38817
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION_EMAIL_OFF 38818
#define IDS_BOOKMARKS_MANAGER_TRACKED_PRODUCTS 38819
#define IDS_BOOKMARKS_MANAGER_UNTRACK_BUTTON 38820
#define IDS_PRICE_TRACKING_SIDE_PANEL_IPH 38821
#define IDS_SIDE_PANEL_TRACKED_PRODUCTS 38822
#define IDS_PRICE_TRACKING_CHIP_IPH 38823
#define IDS_SIDE_PANEL_UNTRACK_BUTTON 38824
#define IDS_SIDE_PANEL_TRACK_BUTTON 38825
#define IDS_BOOKMARKS_MENU_UNTRACK_PRICE 38826
#define IDS_BOOKMARKS_MENU_TRACK_PRICE 38827
#define IDS_PRICE_TRACKING_UNTRACK_PRODUCT_ACCESSIBILITY 38828
#define IDS_PRICE_TRACKING_TRACK_PRODUCT_ACCESSIBILITY 38829
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_BUTTON 38830
#define IDS_PRICE_TRACKING_SETTINGS_TITLE 38831
#define IDS_PRICE_TRACKING_SETTINGS_EMAIL_DESCRIPTION 38832
#define IDS_PRICE_TRACKING_SETTINGS_POPUP_DESCRIPTION 38833
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_MESSAGE 38834
#define IDS_SHOPPING_COLLECTION_IPH_TITLE 38835
#define IDS_SHOPPING_COLLECTION_IPH_BODY 38836
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TITLE 38837
#define IDS_PRICE_HISTORY_TITLE 38838
#define IDS_PRICE_HISTORY_TITLE_MULTIPLE_OPTIONS 38839
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_LOW_PRICE 38840
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_HIGH_PRICE 38841
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_TYPICAL_PRICE 38842
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_TITLE 38843
#define IDS_SHOPPING_INSIGHTS_ICON_TOOLTIP_TEXT 38844
#define IDS_SHOPPING_INSIGHTS_BUYING_OPTIONS 38845
#define IDS_PRICE_HISTORY_TODAY_PRICE 38846
#define IDS_PRICE_HISTORY_YESTERDAY_PRICE 38847
#define IDS_PRICE_HISTORY_DESCRIPTION 38848
#define IDS_PRICE_HISTORY_GRAPH_ACCESSIBILITY 38849
#define IDS_SHOPPING_INSIGHTS_COLLECT_FEEDBACK 38850
#define IDS_SHOPPING_INSIGHTS_FEEDBACK_FORM_TITLE 38851
#define IDS_PRICE_HISTORY_SINGLE_OPTION_LOW_PRICE 38852
#define IDS_PRICE_HISTORY_SINGLE_OPTION_HIGH_PRICE 38853
#define IDS_PRICE_HISTORY_SINGLE_OPTION_TYPICAL_PRICE 38854
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_DESCRIPTION 38855
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_ERROR 38856
#define IDS_DISCOUNT_USE_THIS_CODE_AT_CHECKOUT_WITH_EXPIRATION_DATE 38857
#define IDS_DISCOUNT_EXPIRATION_DATE 38858
#define IDS_TWO_STRINGS_CONNECTOR 38859
#define IDS_TWO_STRINGS_CONNECTOR_WITH_SPACE 38860
#define IDS_SELLER_TERMS_AND_CONDITIONS_DIALOG_TITLE 38861
#define IDS_SELLER_TERMS_AND_CONDITIONS_DIALOG_FOOTER 38862
#define IDS_SEE_SELLER_TERMS_AND_CONDITIONS 38863
#define IDS_DISCOUNTS_COUPON_CODE_BUTTON_TOOLTIP 38864
#define IDS_DISCOUNTS_COUPON_CODE_BUTTON_TOOLTIP_CLICKED 38865
#define IDS_PRICE_DROP_POPUP_CONTENT_TITLE 38878
#define IDS_PRICE_DROP_POPUP_CONTENT_TEXT 38879
#define IDS_PRICE_DROP_POPUP_ACTION_BUTTON 38880
#define IDS_PRICE_DROP_POPUP_UNTRACK_BUTTON 38881
#define IDS_PRICE_RANGE_ALL_OPTIONS 38882
#define IDS_PRICE_RANGE_ALL_OPTIONS_ONE_TYPICAL_PRICE 38883
#define IDS_PRICE_RANGE_SINGLE_OPTION 38884
#define IDS_PRICE_RANGE_SINGLE_OPTION_ONE_TYPICAL_PRICE 38885
#define IDS_PRICE_TRACKING_DESCRIPTION 38886
#define IDS_PRICE_INSIGHTS_BUYING_OPTIONS_TITLE 38887
#define IDS_PRICE_INSIGHTS_BUYING_OPTIONS_SUBTITLE 38888
#define IDS_PRICE_INSIGHTS_TRACK_BUTTON_TITLE 38889
#define IDS_PRICE_INSIGHTS_TRACKING_BUTTON_TITLE 38890
#define IDS_INSIGHTS_ICON_EXPANDED_TEXT_GOOD_DEAL 38891
#define IDS_INSIGHTS_RICH_IPH_TEXT 38892
#define IDS_INSIGHTS_ICON_PRICE_HIGH_EXPANDED_TEXT 38893
#define IDS_INSIGHTS_ICON_EXPANDED_TEXT_PRICE_HISTORY 38894
#define IDS_PRICE_INSIGHTS_ACCESSIBILITY 38895
#define IDS_PRICE_INSIGHTS_GRAPH_ACCESSIBILITY_LABEL 38896
#define IDS_PRICE_INSIGHTS_SNACKBAR_BUTTON_TITLE 38897
#define IDS_PRICE_INSIGHTS_SNACKBAR_MESSAGE_TITLE_NOTIFICATION_DISABLED 38898
#define IDS_PRICE_INSIGHTS_SNACKBAR_MESSAGE_TITLE_NOTIFICATION_ENABLED 38899
#define IDS_PRICE_RANGE_ACCESSIBILITY_DESCRIPTION 38900
#define IDS_BUYING_OPTIONS_ACCESSIBILITY_DESCRIPTION 38901
#define IDS_PRICE_TRACKING_DESCRIPTION_TRACKED 38902
#define IDS_PRICE_HISTORY_TITLE_WITH_VARIANTS 38903
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_TITLE 38904
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_MESSAGE 38905
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_CLOSE 38906
#define IDS_IOS_PRICE_INSIGHTS_PRICE_TRACK_PERMISSION_REDIRECT_ALERT_REDIRECT 38907
#define IDS_PRICE_INSIGHTS_UNTRACK_SNACKBAR_MESSAGE 38908
#define IDS_PRICE_INSIGHTS_UNTRACK_SNACKBAR_BUTTON_TITLE 38909
#define IDS_PRICE_HISTORY_TITLE_SINGLE_OPTION 38910
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_LOW_PRICE 38911
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_HIGH_PRICE 38912
#define IDS_SHOPPING_COLLECTION_FOLDER_NAME 38913
#define IDS_DISCOUNT_CODE_COPY_BUTTON_TEXT 38914
#define IDS_DISCOUNT_ICON_EXPANDED_TEXT 38915
#define IDS_COMPARE_ADD_NEW_COLUMN 38923
#define IDS_COMPARE_ADDED_TO_TABLE_TOAST_ACTION_BUTTON 38924
#define IDS_COMPARE_CITATION_A11Y_LABEL 38925
#define IDS_COMPARE_DEFAULT_PAGE_TITLE 38926
#define IDS_COMPARE_DEFAULT_TABLE_TITLE 38927
#define IDS_COMPARE_DELETE 38928
#define IDS_COMPARE_DISCLAIMER 38929
#define IDS_COMPARE_EMPTY_PRODUCT_SELECTOR 38930
#define IDS_COMPARE_EMPTY_SELECTION_MENU 38931
#define IDS_COMPARE_EMPTY_STATE_TITLE 38932
#define IDS_COMPARE_EMPTY_STATE_TITLE_DESCRIPTION 38933
#define IDS_COMPARE_ENTRY_POINT_DEFAULT 38934
#define IDS_COMPARE_ENTRY_POINT 38935
#define IDS_COMPARE_FEEDBACK_PLACEHOLDER 38936
#define IDS_COMPARE_LEARN_MORE 38937
#define IDS_COMPARE_LEARN_MORE_A11Y_LABEL 38938
#define IDS_COMPARE_OFFLINE_TOAST_MESSAGE 38939
#define IDS_COMPARE_OPEN_PRODUCT_PAGE_IN_NEW_TAB 38940
#define IDS_COMPARE_PAGE_ACTION_ADD_DEFAULT 38941
#define IDS_COMPARE_PAGE_ACTION_ADDED_DEFAULT 38942
#define IDS_COMPARE_PAGE_ACTION_ADD 38943
#define IDS_COMPARE_PAGE_ACTION_ADDED 38944
#define IDS_COMPARE_PRICE_ROW_TITLE 38945
#define IDS_COMPARE_PRODUCT_SUMMARY_ROW_TITLE 38946
#define IDS_COMPARE_RECENTLY_VIEWED_TABS_SECTION 38947
#define IDS_COMPARE_REMOVE_COLUMN 38948
#define IDS_COMPARE_RENAME 38949
#define IDS_COMPARE_SEE_ALL 38950
#define IDS_COMPARE_SUGGESTIONS_SECTION 38951
#define IDS_COMPARE_TABLE_FULL_MESSAGE 38952
#define IDS_COMPARE_TABLE_MENU_A11Y_LABEL 38953
#define IDS_COMPARE_TITLE_INPUT_A11Y_LABEL 38954
#define IDS_TOOLTIP_COMPARE_ENTRY_POINT_CLOSE 38955
#define IDS_COMPARE_SYNC_PROMO_MESSAGE 38956
#define IDS_COMPARE_SYNC_PROMO_DESCRIPTION 38957
#define IDS_COMPARE_SYNC_PROMO_BUTTON 38958
#define IDS_COMPARE_ERROR_TITLE 38959
#define IDS_COMPARE_ERROR_DESCRIPTION 38960
#define IDS_COMPARE_TABLE_LIST_ITEM_TITLE 38961
#define IDS_COMPARE_NUM_ITEMS 38962
#define IDS_COMPARE_YOUR_COMPARISON_TABLES 38963
#define IDS_COMPARE_CONTEXT_MENU_OPEN_IN_NEW_TAB 38964
#define IDS_COMPARE_CONTEXT_MENU_OPEN_IN_NEW_WINDOW 38965
#define IDS_COMPARE_CONTEXT_MENU_OPEN_ALL_WITH_COUNT 38966
#define IDS_COMPARE_CONTEXT_MENU_OPEN_ALL_IN_NEW_WINDOW_WITH_COUNT 38967
#define IDS_COMPARE_CONTEXT_MENU_RENAME 38968
#define IDS_COMPARE_CONTEXT_MENU_DELETE 38969
#define IDS_COMPARE_NUM_ITEMS_SELECTED 38970
#define IDS_COMPARE_EDIT_MORE 38971
#define IDS_COMPARE_TABLE_DELETION_TOAST_MESSAGE 38972
#define IDS_COMPARE_UNDO_TABLE_DELETION 38973
#define IDS_COMPARE_DISCLOSURE_TITLE 38974
#define IDS_COMPARE_DISCLOSURE_ITEMS_HEADER 38975
#define IDS_COMPARE_DISCLOSURE_ABOUT_AI_ITEM 38976
#define IDS_COMPARE_DISCLOSURE_TAB_ITEM 38977
#define IDS_COMPARE_DISCLOSURE_ACCOUNT_ITEM 38978
#define IDS_COMPARE_DISCLOSURE_DATA_ITEM 38979
#define IDS_COMPARE_DISCLOSURE_ACCEPT 38980
#define IDS_COMPARE_DISCLOSURE_DECLINE 38981
#define IDS_COMPARE_MENU_LABEL 38982
#define IDS_COMPARE_SHOW_ALL_COMPARISON_TABLES 38983
#define IDS_COMPARE_ADD_TAB_TO_COMPARISON_TABLE 38984
#define IDS_COMPARE_NEW_COMPARISON_TABLE 38985
#define IDS_SETTINGS_TITLE 38986
#define IDS_SETTINGS_HIDE_ADVANCED_SETTINGS 38987
#define IDS_SETTINGS_SHOW_ADVANCED_SETTINGS 38988
#define IDS_NETWORK_PREDICTION_ENABLED_DESCRIPTION 38989
#define IDS_OPTIONS_PROXIES_CONFIGURE_BUTTON 38990
#define IDS_COMPOSE_SUGGESTION_MAIN_TEXT 38991
#define IDS_COMPOSE_CONTEXT_MENU_TEXT 38992
#define IDS_COMPOSE_SUGGESTION_LABEL 38993
#define IDS_COMPOSE_SUGGESTION_SAVED_TEXT 38994
#define IDS_COMPOSE_SUGGESTION_SAVED_LABEL 38995
#define IDS_COMPOSE_SUGGESTION_AX_MESSAGE_ON_SHOW_PROACTIVE 38996
#define IDS_COMPOSE_SUGGESTION_AX_MESSAGE_ON_SHOW_RESUME 38997
#define IDS_COMPOSE_DONT_SHOW_ON_THIS_SITE_CHILD_SUGGESTION_TEXT 38998
#define IDS_COMPOSE_DISABLE_HELP_ME_WRITE_CHILD_SUGGESTION_TEXT 38999
#define IDS_COMPOSE_GO_TO_SETTINGS_CHILD_SUGGESTION_TEXT 39000
#define IDS_COMPOSE_FRE_TITLE 39001
#define IDS_COMPOSE_FRE_MAIN_TOP 39002
#define IDS_COMPOSE_FRE_MAIN_MID 39003
#define IDS_COMPOSE_FRE_OK_BUTTON 39004
#define IDS_COMPOSE_FRE_MSBB_TITLE 39005
#define IDS_COMPOSE_FRE_MSBB_MAIN 39006
#define IDS_COMPOSE_FRE_MSBB_SETTINGS_BUTTON 39007
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_TEXT 39008
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_TEXT_SCREENREADER 39009
#define IDS_COMPOSE_MSBB_IPH_BUBBLE_CLOSE_BUTTON_LABEL_TEXT 39010
#define IDS_COMPOSE_DIALOG_TITLE 39011
#define IDS_COMPOSE_INPUT_PLACEHOLDER_TITLE 39012
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_1 39013
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_2 39014
#define IDS_COMPOSE_INPUT_PLACEHOLDER_LINE_3 39015
#define IDS_COMPOSE_INPUT_FOOTER 39016
#define IDS_COMPOSE_INPUT_MODE_POLISH 39017
#define IDS_COMPOSE_INPUT_MODE_ELABORATE 39018
#define IDS_COMPOSE_INPUT_MODE_FORMALIZE 39019
#define IDS_COMPOSE_SUBMIT_BUTTON 39020
#define IDS_COMPOSE_EDIT_UPDATE_BUTTON 39021
#define IDS_COMPOSE_EDIT 39022
#define IDS_COMPOSE_MODIFIERS_MENU_TITLE 39023
#define IDS_COMPOSE_MODIFIERS_MENU_LABEL 39024
#define IDS_COMPOSE_MENU_RETRY_OPTION 39025
#define IDS_COMPOSE_MENU_LENGTH_TITLE 39026
#define IDS_COMPOSE_MENU_SHORTER_OPTION 39027
#define IDS_COMPOSE_MENU_LONGER_OPTION 39028
#define IDS_COMPOSE_MENU_TONE_TITLE 39029
#define IDS_COMPOSE_MENU_CASUAL_OPTION 39030
#define IDS_COMPOSE_MENU_FORMAL_OPTION 39031
#define IDS_COMPOSE_UNDO_BUTTON_TEXT 39032
#define IDS_COMPOSE_UNDO_LABEL 39033
#define IDS_COMPOSE_REDO_BUTTON_TEXT 39034
#define IDS_COMPOSE_REDO_LABEL 39035
#define IDS_COMPOSE_RESUBMIT 39036
#define IDS_COMPOSE_INSERT_BUTTON 39037
#define IDS_COMPOSE_REPLACE_BUTTON 39038
#define IDS_COMPOSE_THUMBS_DOWN 39039
#define IDS_COMPOSE_THUMBS_UP 39040
#define IDS_COMPOSE_RESULT_TEXT_LABEL 39041
#define IDS_COMPOSE_RESULT_LOADING_A11Y_MESSAGE 39042
#define IDS_COMPOSE_RESULT_UPDATED_A11Y_MESSAGE 39043
#define IDS_COMPOSE_UNDO_RESULT_A11Y_MESSAGE 39044
#define IDS_COMPOSE_REDO_RESULT_A11Y_MESSAGE 39045
#define IDS_COMPOSE_ERROR_TOO_SHORT 39046
#define IDS_COMPOSE_ERROR_TOO_LONG 39047
#define IDS_COMPOSE_ERROR_TRY_AGAIN 39048
#define IDS_COMPOSE_ERROR_TRY_AGAIN_LATER 39049
#define IDS_COMPOSE_ERROR_FILTERED 39050
#define IDS_COMPOSE_ERROR_FILTERED_BACK_BUTTON 39051
#define IDS_COMPOSE_ERROR_UNSUPPORTED_LANGUAGE 39052
#define IDS_COMPOSE_ERROR_PERMISSION_DENIED 39053
#define IDS_COMPOSE_ERROR_REQUEST_THROTTLED 39054
#define IDS_COMPOSE_ERROR_OFFLINE 39055
#define IDS_COMPOSE_FOOTER_FISHFOOD 39056
#define IDS_COMPOSE_EXPERIMENTAL_DISCLAIMER_FOOTER 39057
#define IDS_COMPOSE_REFINEMENTS_EXPERIMENTAL_DISCLAIMER_FOOTER 39058
#define IDS_COMPOSE_FOOTER_FISHFOOD_ON_DEVICE_USED 39059
#define IDS_COMPOSE_FEEDBACK_PLACEHOLDER 39060
#define IDS_CRASH_TITLE 39061
#define IDS_CRASH_CRASH_COUNT_BANNER_FORMAT 39062
#define IDS_CRASH_SHOW_DEVELOPER_DETAILS 39063
#define IDS_CRASH_CAPTURE_TIME_FORMAT 39064
#define IDS_CRASH_REPORT_STATUS 39065
#define IDS_CRASH_REPORT_STATUS_NOT_UPLOADED 39066
#define IDS_CRASH_REPORT_STATUS_PENDING 39067
#define IDS_CRASH_REPORT_STATUS_PENDING_USER_REQUESTED 39068
#define IDS_CRASH_REPORT_STATUS_UPLOADED 39069
#define IDS_CRASH_REPORT_UPLOADED_ID 39070
#define IDS_CRASH_REPORT_UPLOADED_TIME 39071
#define IDS_CRASH_REPORT_LOCAL_ID 39072
#define IDS_CRASH_REPORT_FILE_SIZE 39073
#define IDS_CRASH_BUG_LINK_LABEL 39074
#define IDS_CRASH_NO_CRASHES_MESSAGE 39075
#define IDS_CRASH_DISABLED_HEADER 39076
#define IDS_CRASH_UPLOAD_MESSAGE 39077
#define IDS_CRASH_UPLOAD_NOW_LINK_TEXT 39078
#define IDS_HTTP_POST_WARNING_TITLE 39079
#define IDS_HTTP_POST_WARNING 39080
#define IDS_HTTP_POST_WARNING_RESEND 39081
#define IDS_DOM_DISTILLER_JAVASCRIPT_DISABLED_CONTENT 39082
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_URL 39083
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD 39084
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD_FAILED 39085
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL 39086
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL_FAILED 39087
#define IDS_DOM_DISTILLER_WEBUI_REFRESH 39088
#define IDS_DOM_DISTILLER_WEBUI_FETCHING_ENTRIES 39089
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_TITLE 39090
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_CONTENT 39091
#define IDS_DOM_DISTILLER_VIEWER_LOADING_TITLE 39092
#define IDS_DOM_DISTILLER_VIEWER_CUSTOMIZE_APPEARANCE 39093
#define IDS_DOM_DISTILLER_VIEWER_FONT_STYLE 39094
#define IDS_DOM_DISTILLER_VIEWER_SANS_SERIF_FONT 39095
#define IDS_DOM_DISTILLER_VIEWER_SERIF_FONT 39096
#define IDS_DOM_DISTILLER_VIEWER_MONOSPACE_FONT 39097
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR 39098
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_LIGHT 39099
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_SEPIA 39100
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_DARK 39101
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE 39102
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_SMALL 39103
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_LARGE 39104
#define IDS_DOM_DISTILLER_VIEWER_CLOSE 39105
#define IDS_DOM_DISTILLER_VIEWER_NO_DATA_CONTENT 39106
#define IDS_DOM_DISTILLER_WEBUI_TITLE 39107
#define IDS_DOM_DISTILLER_VIEWER_TITLE_SUFFIX 39108
#define IDS_ENTERPRISE_COPY_PREVENTION_MISSING_LIST_ERROR 39109
#define IDS_ENTERPRISE_COPY_PREVENTION_DISABLE_CONTAINS_WILDCARD_ERROR 39110
#define IDS_ENTERPRISE_COPY_PREVENTION_WARNING_MESSAGE 39111
#define IDS_ENTERPRISE_DATA_CONTROLS_COPY_PREVENTION_WARNING_MESSAGE 39112
#define IDS_ERRORPAGE_NET_BUTTON_DETAILS 39113
#define IDS_ERRORPAGE_NET_BUTTON_HIDE_DETAILS 39114
#define IDS_ERRORPAGES_BUTTON_RELOAD 39115
#define IDS_ERRORPAGES_BUTTON_SHOW_SAVED_COPY 39116
#define IDS_ERRORPAGE_FUN_DISABLED 39117
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_REPOST_SUMMARY 39122
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_PRIVATE_NETWORK_ACCESS 39123
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_HEADER 39124
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_BODY 39125
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_HEADER 39126
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_BODY 39127
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_HEADER 39128
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_BODY 39129
#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_HEADER 39130
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_BODY 39131
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_HEADER 39132
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_BODY 39133
#define IDS_ERRORPAGES_SUGGESTION_CAPTIVE_PORTAL_SIGNIN 39134
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_HEADER 39136
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_BODY 39137
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_HEADER 39138
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_BODY 39139
#define IDS_ERRORPAGES_SUGGESTION_NAVIGATE_TO_ORIGIN 39140
#define IDS_ERRORPAGES_HEADING_NOT_AVAILABLE 39141
#define IDS_ERRORPAGES_HEADING_NETWORK_ACCESS_DENIED 39142
#define IDS_ERRORPAGES_HEADING_INTERNET_DISCONNECTED 39143
#define IDS_ERRORPAGES_HEADING_YOU_ARE_OFFLINE 39144
#define IDS_ERRORPAGES_MESSAGE_IWA_INVALID_WEB_BUNDLE 39145
#define IDS_ERRORPAGES_MESSAGE_IWA_CONNECTION_REFUSED 39146
#define IDS_ERRORPAGES_MESSAGE_IWA_INSTALLED_IN_DEV_MODE 39147
#define IDS_ERRORPAGES_HEADING_CACHE_READ_FAILURE 39148
#define IDS_ERRORPAGES_HEADING_CONNECTION_INTERRUPTED 39149
#define IDS_ERRORPAGES_HEADING_NOT_FOUND 39150
#define IDS_ERRORPAGES_HEADING_FILE_NOT_FOUND 39151
#define IDS_ERRORPAGES_HEADING_BLOCKED 39152
#define IDS_ERRORPAGES_HEADING_BLOCKED_SCHEME 39153
#define IDS_ERRORPAGES_SUMMARY_NOT_AVAILABLE 39154
#define IDS_ERRORPAGES_SUMMARY_TIMED_OUT 39155
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_RESET 39156
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_CLOSED 39157
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_FAILED 39158
#define IDS_ERRORPAGES_SUMMARY_NETWORK_CHANGED 39159
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_REFUSED 39160
#define IDS_ERRORPAGES_SUMMARY_NAME_NOT_RESOLVED 39161
#define IDS_ERRORPAGES_SUMMARY_ICANN_NAME_COLLISION 39162
#define IDS_ERRORPAGES_SUMMARY_ADDRESS_UNREACHABLE 39163
#define IDS_ERRORPAGES_SUMMARY_FILE_ACCESS_DENIED 39164
#define IDS_ERRORPAGES_SUMMARY_NETWORK_ACCESS_DENIED 39165
#define IDS_ERRORPAGES_SUMMARY_PROXY_CONNECTION_FAILED 39166
#define IDS_ERRORPAGES_SUMMARY_CACHE_READ_FAILURE 39167
#define IDS_ERRORPAGES_SUMMARY_NETWORK_IO_SUSPENDED 39168
#define IDS_ERRORPAGES_SUMMARY_NOT_FOUND 39169
#define IDS_ERRORPAGES_SUMMARY_FILE_NOT_FOUND 39170
#define IDS_ERRORPAGES_SUMMARY_TOO_MANY_REDIRECTS 39171
#define IDS_ERRORPAGES_SUMMARY_EMPTY_RESPONSE 39172
#define IDS_ERRORPAGES_SUMMARY_INVALID_RESPONSE 39173
#define IDS_ERRORPAGES_SUMMARY_DNS_PROBE_RUNNING 39174
#define IDS_ERRORPAGES_HEADING_ACCESS_DENIED 39175
#define IDS_ERRORPAGES_HEADING_FILE_ACCESS_DENIED 39176
#define IDS_ERRORPAGES_SUMMARY_FORBIDDEN 39177
#define IDS_ERRORPAGES_SUMMARY_GONE 39178
#define IDS_ERRORPAGES_HEADING_PAGE_NOT_WORKING 39179
#define IDS_ERRORPAGES_SUMMARY_CONTACT_SITE_OWNER 39180
#define IDS_ERRORPAGES_SUMMARY_WEBSITE_CANNOT_HANDLE_REQUEST 39181
#define IDS_ERRORPAGES_SUMMARY_GATEWAY_TIMEOUT 39182
#define IDS_ERRORPAGES_SUMMARY_SSL_SECURITY_ERROR 39183
#define IDS_ERRORPAGES_SUMMARY_SSL_VERSION_OR_CIPHER_MISMATCH 39184
#define IDS_ERRORPAGES_HEADING_INSECURE_CONNECTION 39185
#define IDS_ERRORPAGES_SUMMARY_BAD_SSL_CLIENT_AUTH_CERT 39186
#define IDS_ERRORPAGES_SUMMARY_SSL_CLIENT_AUTH_SIGNATURE_FAILED 39187
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_EXTENSION 39188
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_ADMINISTRATOR 39189
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_SECURITY 39190
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_PRIVATE_NETWORK_ACCESS_CHECKS 39191
#define IDS_ERRORPAGES_HTTP_POST_WARNING 39192
#define IDS_ERRORPAGES_HEADING_LINKPREVIEW_NON_HTTPS_FORBIDDEN 39193
#define IDS_ERRORPAGES_SUMMARY_LINKPREVIEW_NON_HTTPS_FORBIDDEN 39194
#define IDS_ERRORPAGES_SUGGESTION_LIST_HEADER 39195
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_SUMMARY 39196
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_DNS_SUMMARY 39198
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SECURE_DNS_SUMMARY 39199
#define IDS_ERRORPAGES_SUGGESTION_CHECK_FIREWALL_ANTIVIRUS_SUMMARY 39200
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SUMMARY 39201
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_ADDRESS_SUMMARY 39202
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY 39203
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY_STANDALONE 39204
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY 39205
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY_STANDALONE 39206
#define IDS_ERRORPAGES_SUGGESTION_DELETE_COOKIES_SUMMARY 39207
#define IDS_ERRORPAGES_SUGGESTION_CHECK_HARDWARE_SUMMARY 39211
#define IDS_ERRORPAGES_SUGGESTION_CHECK_WIFI_SUMMARY 39212
#define IDS_ERRORPAGES_SUGGESTION_DISABLE_EXTENSION_SUMMARY 39213
#define IDS_ERRORPAGES_CHECK_TYPO_SUMMARY 39214
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE 39215
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_STANDALONE 39216
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_CHECK_TYPO_STANDALONE 39217
#define IDS_ERRORPAGES_GAME_INSTRUCTIONS 39218
#define IDS_ERRORPAGE_DINO_GAME_DESCRIPTION 39219
#define IDS_ERRORPAGE_DINO_ARIA_LABEL 39220
#define IDS_ERRORPAGE_DINO_GAME_START 39221
#define IDS_ERRORPAGE_DINO_GAME_OVER 39222
#define IDS_ERRORPAGE_DINO_HIGH_SCORE 39223
#define IDS_ERRORPAGE_DINO_JUMP 39224
#define IDS_ERRORPAGE_DINO_SLOW_SPEED_TOGGLE 39225
#define IDS_FIND_IN_PAGE_ACCESSIBLE_TITLE 39226
#define IDS_FIND_IN_PAGE_COUNT 39227
#define IDS_ACCESSIBLE_FIND_IN_PAGE_COUNT 39228
#define IDS_ACCESSIBLE_FIND_IN_PAGE_NO_RESULTS 39229
#define IDS_FIND_IN_PAGE_PREVIOUS_TOOLTIP 39230
#define IDS_FIND_IN_PAGE_NEXT_TOOLTIP 39231
#define IDS_FIND_IN_PAGE_CLOSE_TOOLTIP 39232
#define IDS_FLAGS_UI_SEARCH_PLACEHOLDER 39233
#define IDS_FLAGS_UI_SEARCH_LABEL 39234
#define IDS_FLAGS_UI_TITLE 39235
#define IDS_FLAGS_UI_PAGE_RESET 39236
#define IDS_FLAGS_UI_PAGE_WARNING 39237
#define IDS_FLAGS_UI_PAGE_WARNING_EXPLANATION 39238
#define IDS_FLAGS_UI_OWNER_WARNING 39239
#define IDS_FLAGS_UI_AVAILABLE_FEATURE 39240
#define IDS_FLAGS_UI_UNAVAILABLE_FEATURE 39241
#define IDS_FLAGS_UI_ENABLED_FEATURE 39242
#define IDS_FLAGS_UI_DISABLED_FEATURE 39243
#define IDS_FLAGS_UI_NO_RESULTS 39244
#define IDS_FLAGS_UI_NOT_AVAILABLE_ON_PLATFORM 39245
#define IDS_FLAGS_UI_RELAUNCH 39246
#define IDS_FLAGS_UI_CLEAR_SEARCH 39247
#define IDS_FLAGS_UI_RESET_ACKNOWLEDGED 39248
#define IDS_FLAGS_UI_EXPERIMENT_ENABLED 39249
#define IDS_FLAGS_UI_SEARCH_RESULTS_SINGULAR 39250
#define IDS_FLAGS_UI_SEARCH_RESULTS_PLURAL 39251
#define IDS_DEPRECATED_FEATURES_SEARCH_PLACEHOLDER 39252
#define IDS_DEPRECATED_FEATURES_TITLE 39253
#define IDS_DEPRECATED_FEATURES_HEADING 39254
#define IDS_DEPRECATED_FEATURES_PAGE_WARNING_EXPLANATION 39255
#define IDS_DEPRECATED_FEATURES_NO_RESULTS 39256
#define IDS_EXIT_FULLSCREEN_MODE 39257
#define IDS_FULLSCREEN_HOLD_TO_EXIT_FULLSCREEN 39258
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN 39259
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN_TWO_KEYS 39260
#define IDS_PRESS_TO_EXIT_MOUSELOCK 39261
#define IDS_PRESS_TO_EXIT_MOUSELOCK_TWO_KEYS 39262
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS 39263
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS 39264
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS_AND_EXIT 39265
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS_AND_EXIT 39266
#define IDS_GLOBAL_MEDIA_CONTROLS_BACK_TO_TAB 39267
#define IDS_GLOBAL_MEDIA_CONTROLS_DISMISS_ICON_TOOLTIP_TEXT 39268
#define IDS_GLOBAL_MEDIA_CONTROLS_CAST_HEADER_TEXT 39269
#define IDS_GLOBAL_MEDIA_CONTROLS_CLOSE_DEVICE_LIST_TEXT 39270
#define IDS_GLOBAL_MEDIA_CONTROLS_UNKNOWN_SOURCE_TEXT 39271
#define IDS_GLOBAL_MEDIA_CONTROLS_UNKNOWN_DEVICE_TEXT 39272
#define IDS_GLOBAL_MEDIA_CONTROLS_MEDIA_LIVE_TEXT 39273
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_DETAILS 39274
#define IDS_HEAVY_AD_INTERVENTION_HEADING 39275
#define IDS_HEAVY_AD_INTERVENTION_SUMMARY 39276
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_RELOAD 39277
#define IDS_HISTORY_CLUSTERS_ACTION_MENU_DESCRIPTION 39278
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 39279
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_WARNING 39280
#define IDS_HISTORY_CLUSTERS_BY_GROUP_TAB_LABEL 39281
#define IDS_HISTORY_CLUSTERS_BY_DATE_TAB_LABEL 39282
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_SEARCH_TERMS 39283
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_MULTIPLE_HOSTNAMES 39284
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_OTHER_MATCHING_VISITS 39285
#define IDS_HISTORY_CLUSTERS_HIDE_PAGE 39286
#define IDS_HISTORY_CLUSTERS_HIDE_VISITS 39287
#define IDS_HISTORY_CLUSTERS_LOAD_MORE_BUTTON_LABEL 39288
#define IDS_HISTORY_CLUSTERS_NO_RESULTS 39289
#define IDS_HISTORY_CLUSTERS_NO_SEARCH_RESULTS 39290
#define IDS_HISTORY_CLUSTERS_SHOW_SIDE_PANEL 39291
#define IDS_HISTORY_CLUSTERS_OPEN_ALL_IN_TABGROUP 39292
#define IDS_HISTORY_CLUSTERS_OPEN_INCOGNITO 39293
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_TAB 39294
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_WINDOW 39295
#define IDS_HISTORY_CLUSTERS_RELATED_SEARCHES_HEADER 39296
#define IDS_HISTORY_CLUSTERS_REMOVE_ALL_ITEMS 39297
#define IDS_HISTORY_CLUSTERS_REMOVE_PAGE 39298
#define IDS_HISTORY_CLUSTERS_REMOVE_ITEM_TOAST 39299
#define IDS_HISTORY_CLUSTERS_REMOVE_SELECTED_ITEMS 39300
#define IDS_HISTORY_CLUSTERS_SAVED_IN_TABGROUP_LABEL 39301
#define IDS_HISTORY_CLUSTERS_CUT 39302
#define IDS_HISTORY_CLUSTERS_COPY 39303
#define IDS_HISTORY_CLUSTERS_PASTE 39304
#define IDS_HISTORY_CLUSTERS_COPY_LINK 39305
#define IDS_HISTORY_CLUSTERS_SHOW_LESS_BUTTON_LABEL 39306
#define IDS_HISTORY_CLUSTERS_SHOW_MORE_BUTTON_LABEL 39307
#define IDS_HISTORY_ACTION_MENU_DESCRIPTION 39308
#define IDS_HISTORY_ARIA_ROLE_DESCRIPTION 39309
#define IDS_HISTORY_CANCEL_EDITING_BUTTON 39310
#define IDS_HISTORY_DATE_WITH_RELATIVE_TIME 39311
#define IDS_HISTORY_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 39312
#define IDS_HISTORY_DELETE_PRIOR_VISITS_WARNING 39313
#define IDS_HISTORY_DELETE_SELECTED_ENTRIES_BUTTON 39314
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_DELETE 39315
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_LABEL 39316
#define IDS_HISTORY_ENTRY_BOOKMARKED 39317
#define IDS_HISTORY_ENTRY_SUMMARY 39318
#define IDS_HISTORY_FOUND_SEARCH_RESULTS 39319
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY 39320
#define IDS_HISTORY_LOADING 39321
#define IDS_HISTORY_MORE_FROM_SITE 39322
#define IDS_HISTORY_NO_RESULTS 39323
#define IDS_HISTORY_NO_SEARCH_RESULTS 39324
#define IDS_HISTORY_OPEN_CLEAR_BROWSING_DATA_DIALOG 39325
#define IDS_HISTORY_OTHER_SESSIONS_COLLAPSE_SESSION 39326
#define IDS_HISTORY_OTHER_SESSIONS_EXPAND_SESSION 39327
#define IDS_HISTORY_OTHER_SESSIONS_HIDE_FOR_NOW 39328
#define IDS_HISTORY_OTHER_SESSIONS_OPEN_ALL 39329
#define IDS_HISTORY_REMOVE_BOOKMARK 39330
#define IDS_HISTORY_REMOVE_PAGE 39331
#define IDS_HISTORY_REMOVE_PAGE_SUCCESS 39332
#define IDS_HISTORY_REMOVE_SELECTED_ITEMS 39333
#define IDS_HISTORY_SEARCH_BUTTON 39334
#define IDS_HISTORY_SEARCH_RESULT 39335
#define IDS_HISTORY_SEARCH_RESULTS 39336
#define IDS_HISTORY_SEARCH_EXACT_MATCH_RESULT 39337
#define IDS_HISTORY_SEARCH_EXACT_MATCH_RESULTS 39338
#define IDS_HISTORY_SEARCH_EMBEDDINGS_MATCH_RESULT 39339
#define IDS_HISTORY_SEARCH_EMBEDDINGS_MATCH_RESULTS 39340
#define IDS_HISTORY_SHOW_HISTORY 39341
#define IDS_HISTORY_SHOWFULLHISTORY_LINK 39342
#define IDS_HISTORY_START_EDITING_BUTTON 39343
#define IDS_HISTORY_TITLE 39344
#define IDS_HISTORY_UNKNOWN_DEVICE 39345
#define IDS_HISTORY_EMBEDDINGS_DISCLAIMER 39346
#define IDS_HISTORY_EMBEDDINGS_PROMO_LABEL 39347
#define IDS_HISTORY_EMBEDDINGS_PROMO_CLOSE 39348
#define IDS_HISTORY_EMBEDDINGS_PROMO_HEADING 39349
#define IDS_HISTORY_EMBEDDINGS_PROMO_BODY 39350
#define IDS_HISTORY_EMBEDDINGS_ANSWERS_PROMO_HEADING 39351
#define IDS_HISTORY_EMBEDDINGS_ANSWERS_PROMO_BODY 39352
#define IDS_HISTORY_EMBEDDIGNS_PROMO_SETTINGS_LINK_TEXT 39353
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_ARIA_LABEL 39354
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_DATE 39355
#define IDS_HISTORY_EMBEDDINGS_SHOW_BY_GROUP 39356
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_1 39357
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_2 39358
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_3 39359
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_1_ARIA_LABEL 39360
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_2_ARIA_LABEL 39361
#define IDS_HISTORY_EMBEDDINGS_SUGGESTION_3_ARIA_LABEL 39362
#define IDS_HISTORY_EMBEDDINGS_HEADING 39363
#define IDS_HISTORY_EMBEDDINGS_HEADING_LOADING 39364
#define IDS_HISTORY_EMBEDDINGS_WITH_ANSWERS_RESULTS_HEADING 39365
#define IDS_HISTORY_EMBEDDINGS_FOOTER 39366
#define IDS_HISTORY_EMBEDDINGS_FEEDBACK_PLACEHOLDER 39367
#define IDS_HISTORY_EMBEDDINGS_IPH_BODY 39368
#define IDS_HISTORY_EMBEDDINGS_IPH_ACTION 39369
#define IDS_HISTORY_EMBEDDINGS_SEARCH_PROMPT 39370
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_1 39371
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_2 39372
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_3 39373
#define IDS_HISTORY_EMBEDDINGS_SEARCH_ANSWERS_ALTERNATIVE_PROMPT_4 39374
#define IDS_HISTORY_EMBEDDINGS_ANSWER_HEADING 39375
#define IDS_HISTORY_EMBEDDINGS_ANSWER_LOADING_HEADING 39376
#define IDS_HISTORY_EMBEDDINGS_ANSWER_SOURCE_VISIT_DATE_LABEL 39377
#define IDS_HISTORY_EMBEDDINGS_ANSWERER_ERROR_UNANSWERABLE 39378
#define IDS_HISTORY_EMBEDDINGS_ANSWERER_ERROR_MODEL_UNAVAILABLE 39379
#define IDS_HISTORY_EMBEDDINGS_ANSWERER_ERROR_TRY_AGAIN 39380
#define IDS_COMPARE_HISTORY_EMPTY 39381
#define IDS_COMPARE_HISTORY_HEADER 39382
#define IDS_COMPARE_HISTORY_INFO 39383
#define IDS_COMPARE_HISTORY_MENU_ARIA_LABEL 39384
#define IDS_COMPARE_HISTORY_MENU_ITEM 39385
#define IDS_COMPARE_HISTORY_REMOVE 39386
#define IDS_COMPARE_HISTORY_ROW 39387
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE 39388
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_IFRAME 39389
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL 39390
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL_IFRAME 39391
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_EXTENSION 39392
#define IDS_JAVASCRIPT_MESSAGEBOX_SUPPRESS_OPTION 39393
#define IDS_BEFOREUNLOAD_MESSAGEBOX_TITLE 39394
#define IDS_BEFOREUNLOAD_APP_MESSAGEBOX_TITLE 39395
#define IDS_BEFOREUNLOAD_MESSAGEBOX_OK_BUTTON_LABEL 39396
#define IDS_BEFOREUNLOAD_MESSAGEBOX_MESSAGE 39397
#define IDS_BEFORERELOAD_MESSAGEBOX_TITLE 39398
#define IDS_BEFORERELOAD_APP_MESSAGEBOX_TITLE 39399
#define IDS_BEFORERELOAD_MESSAGEBOX_OK_BUTTON_LABEL 39400
#define IDS_LIVE_CAPTION_BUBBLE_TITLE 39401
#define IDS_LIVE_CAPTION_BUBBLE_CLOSE 39402
#define IDS_LIVE_CAPTION_BUBBLE_EXPAND 39403
#define IDS_LIVE_CAPTION_BUBBLE_COLLAPSE 39404
#define IDS_LIVE_CAPTION_BUBBLE_BACK_TO_TAB 39405
#define IDS_LIVE_CAPTION_BUBBLE_PIN 39406
#define IDS_LIVE_CAPTION_BUBBLE_UNPIN 39407
#define IDS_LIVE_CAPTION_BUBBLE_ERROR 39408
#define IDS_LIVE_CAPTION_BUBBLE_CONTENT_SETTINGS 39409
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR 39410
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR_CHECKBOX 39411
#define IDS_LIVE_CAPTION_BUBBLE_APPEAR_SCREENREADER_ANNOUNCEMENT 39412
#define IDS_LIVE_CAPTION_CAPTION_LANGUAGE_AUTODETECTED 39413
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE 39414
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE_AUTODETECTED 39415
#define IDS_LIVE_CAPTION_BUBBLE_CAPTION_SETTINGS 39416
#define IDS_LIVE_CAPTION_DOWNLOAD_PROGRESS 39417
#define IDS_LIVE_CAPTION_LANGUAGE_DOWNLOAD_FAILED 39418
#define IDS_LIVE_CAPTION_TRANSLATING 39419
#define IDS_LOGIN_DIALOG_TITLE 39420
#define IDS_LOGIN_DIALOG_OK_BUTTON_LABEL 39421
#define IDS_LOGIN_DIALOG_AUTHORITY 39422
#define IDS_LOGIN_DIALOG_PROXY_AUTHORITY 39423
#define IDS_LOGIN_DIALOG_NOT_PRIVATE 39424
#define IDS_LOGIN_DIALOG_USERNAME_FIELD 39425
#define IDS_LOGIN_DIALOG_PASSWORD_FIELD 39426
#define IDS_MANAGEMENT_TITLE 39427
#define IDS_MANAGEMENT_TOOLBAR_TITLE 39428
#define IDS_MANAGEMENT_SUBTITLE_MANAGED_BY 39430
#define IDS_MANAGEMENT_NOT_MANAGED_SUBTITLE 39431
#define IDS_MANAGEMENT_SUBTITLE 39432
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY 39433
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY 39434
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_SAME_MANAGED_BY 39435
#define IDS_MANAGEMENT_SUBTITLE_PROFILE_MANAGED_BY 39436
#define IDS_MANAGEMENT_BROWSER_NOTICE 39437
#define IDS_MANAGEMENT_NOT_MANAGED_NOTICE 39438
#define IDS_MANAGEMENT_PROFILE_NOTICE 39439
#define IDS_MANAGEMENT_LEARN_MORE_ACCCESSIBILITY_TEXT 39440
#define IDS_MANAGEMENT_EXTENSION_REPORTING 39486
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED 39487
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED_BY 39488
#define IDS_MANAGEMENT_EXTENSIONS_NAME 39489
#define IDS_MANAGEMENT_EXTENSIONS_PERMISSIONS 39490
#define IDS_MANAGEMENT_APPLICATION_REPORTING 39491
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED 39492
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED_BY 39493
#define IDS_MANAGEMENT_APPLICATIONS_NAME 39494
#define IDS_MANAGEMENT_APPLICATIONS_PERMISSIONS 39495
#define IDS_MANAGEMENT_APPLICATIONS_RUN_ON_OS_LOGIN 39496
#define IDS_MANAGEMENT_MANAGED_WEBSITES 39497
#define IDS_MANAGEMENT_MANAGED_WEBSITES_EXPLANATION 39498
#define IDS_MANAGEMENT_MANAGED_WEBSITES_BY_EXPLANATION 39499
#define IDS_MANAGEMENT_BROWSER_REPORTING 39500
#define IDS_MANAGEMENT_BROWSER_REPORTING_EXPLANATION 39501
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME 39502
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME_ADDRESS 39503
#define IDS_MANAGEMENT_EXTENSION_REPORT_USERNAME 39504
#define IDS_MANAGEMENT_EXTENSION_REPORT_VERSION 39505
#define IDS_MANAGEMENT_EXTENSION_REPORT_EXTENSIONS_PLUGINS 39506
#define IDS_MANAGEMENT_EXTENSION_REPORT_USER_BROWSING_DATA 39507
#define IDS_MANAGEMENT_EXTENSION_REPORT_PERF_CRASH 39508
#define IDS_MANAGEMENT_EXTENSION_REPORT_VISITED_URL 39509
#define IDS_MANAGEMENT_LEGACY_TECH_REPORT 39510
#define IDS_MANAGEMENT_LEGACY_TECH_REPORT_NO_LINK 39511
#define IDS_MANAGEMENT_PROFILE_REPORTING_EXPLANATION 39512
#define IDS_MANAGEMENT_PROFILE_REPORTING_OVERVIEW 39513
#define IDS_MANAGEMENT_PROFILE_REPORTING_USERNAME 39514
#define IDS_MANAGEMENT_PROFILE_REPORTING_BROWSER 39515
#define IDS_MANAGEMENT_PROFILE_REPORTING_EXTENSION 39516
#define IDS_MANAGEMENT_PROFILE_REPORTING_POLICY 39517
#define IDS_MANAGEMENT_PROFILE_REPORTING_LEARN_MORE 39518
#define IDS_MANAGEMENT_THREAT_PROTECTION 39519
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION 39520
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION_BY 39521
#define IDS_MANAGEMENT_CONNECTORS_EVENT 39522
#define IDS_MANAGEMENT_CONNECTORS_VISIBLE_DATA 39523
#define IDS_MANAGEMENT_FILE_ATTACHED_EVENT 39524
#define IDS_MANAGEMENT_FILE_DOWNLOADED_EVENT 39525
#define IDS_MANAGEMENT_TEXT_ENTERED_EVENT 39526
#define IDS_MANAGEMENT_PAGE_PRINTED_EVENT 39527
#define IDS_MANAGEMENT_FILE_TRANSFER_EVENT 39528
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_EVENT 39529
#define IDS_MANAGEMENT_PAGE_VISITED_EVENT 39530
#define IDS_MANAGEMENT_SCREEN_CAPTURE_EVENT 39531
#define IDS_MANAGEMENT_EXTENSION_TELEMETRY_EVENT 39532
#define IDS_MANAGEMENT_FILE_ATTACHED_VISIBLE_DATA 39533
#define IDS_MANAGEMENT_FILE_DOWNLOADED_VISIBLE_DATA 39534
#define IDS_MANAGEMENT_TEXT_ENTERED_VISIBLE_DATA 39535
#define IDS_MANAGEMENT_PAGE_PRINTED_VISIBLE_DATA 39536
#define IDS_MANAGEMENT_FILE_TRANSFER_VISIBLE_DATA 39537
#define IDS_MANAGEMENT_SCREEN_CAPTURE_DATA 39538
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_VISIBLE_DATA 39539
#define IDS_MANAGEMENT_PAGE_VISITED_VISIBLE_DATA 39540
#define IDS_MANAGEMENT_EXTENSION_TELEMETRY_VISIBLE_DATA 39541
#define IDS_MANAGEMENT_DEVICE_SIGNALS_DISCLOSURE 39546
#define IDS_MANAGEMENT_DIALOG_BROWSING_DATA_MANAGEMENT 39547
#define IDS_MANAGEMENT_DIALOG_DEVICE_SIGNALS 39548
#define IDS_MANAGEMENT_DIALOG_PROFILE_MANAGED_BY 39549
#define IDS_MANAGEMENT_DIALOG_THINGS_TO_CONSIDER_SUBTITLE 39550
#define IDS_MANAGED_PROFILE_INTERSTITIAL_TAB_TITLE 39551
#define IDS_MANAGED_PROFILE_INTERSTITIAL_HEADING 39552
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PREVIOUS_TRACK 39553
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_BACKWARD 39554
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_REPLAY_10 39555
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PLAY 39556
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PAUSE 39557
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_FORWARD_10 39558
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_FORWARD 39559
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_NEXT_TRACK 39560
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_ENTER_PIP 39561
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_EXIT_PIP 39562
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_MUTE 39563
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_UNMUTE 39564
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SHOW_DEVICE_LIST 39565
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_HIDE_DEVICE_LIST 39566
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_STOP_CASTING 39567
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_TIME_SCRUBBER 39568
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACCESSIBLE_NAME 39569
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_LABEL 39570
#define IDS_DEFAULT_TAB_TITLE 474
#define IDS_DOWNLOAD_TAB_TITLE 39571
#define IDS_SAD_TAB_TITLE 39572
#define IDS_SAD_TAB_MESSAGE 39573
#define IDS_SAD_TAB_HELP_MESSAGE 39574
#define IDS_SAD_TAB_HELP_LINK 39575
#define IDS_SAD_TAB_RELOAD_LABEL 39576
#define IDS_SAD_TAB_OOM_TITLE 39578
#define IDS_SAD_TAB_RELOAD_TITLE 39579
#define IDS_SAD_TAB_OOM_MESSAGE_TABS 39580
#define IDS_SAD_TAB_OOM_MESSAGE_NOTABS 39581
#define IDS_SAD_TAB_RELOAD_TRY 39582
#define IDS_SAD_TAB_RELOAD_INCOGNITO 39583
#define IDS_SAD_TAB_RELOAD_RESTART_BROWSER 39586
#define IDS_SAD_TAB_RELOAD_RESTART_DEVICE 39587
#define IDS_SAD_TAB_ERROR_CODE 39589
#define IDS_NEW_TAB_TITLE 484
#define IDS_NEW_INCOGNITO_TAB_TITLE 39590
#define IDS_INCOGNITO_TAB_LEARN_MORE_ACCESSIBILITY_LABEL 39591
#define IDS_NEW_TAB_OTR_HEADING 39592
#define IDS_NEW_TAB_OTR_DESCRIPTION 39593
#define IDS_NEW_TAB_OTR_LEARN_MORE_LINK 39594
#define IDS_NEW_TAB_OTR_MESSAGE_WARNING 39595
#define IDS_NEW_TAB_UNDO_THUMBNAIL_REMOVE 485
#define IDS_NEW_TAB_OTR_TITLE 39596
#define IDS_NEW_TAB_OTR_SUBTITLE 39597
#define IDS_NEW_TAB_OTR_SUBTITLE_WITH_READING_LIST 39598
#define IDS_NEW_TAB_OTR_NOT_SAVED 39599
#define IDS_NEW_TAB_OTR_VISIBLE 39600
#define IDS_NEW_TAB_OTR_COOKIE_CONTROLS_CONTROLLED_TOOLTIP_TEXT 39601
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE 39602
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE_SUBLABEL 39603
#define IDS_NEW_TAB_OTR_THIRD_PARTY_BLOCKED_COOKIE 39604
#define IDS_NEW_TAB_OPENS_HC_ARTICLE_IN_NEW_TAB 39605
#define IDS_NEW_TAB_OTR_THIRD_PARTY_BLOCKED_COOKIE_SUBLABEL 39606
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 154
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUGGESTION_CONTENTS 153
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUFFIX 152
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA 151
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 158
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUGGESTION_CONTENTS 157
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUFFIX 156
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS 155
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 162
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUGGESTION_CONTENTS 161
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUFFIX 160
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD 159
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 166
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 165
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 164
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 163
#define IDS_OMNIBOX_PEDAL_TRANSLATE_HINT 170
#define IDS_OMNIBOX_PEDAL_TRANSLATE_SUGGESTION_CONTENTS 169
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE_SUFFIX 168
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE 167
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_HINT 174
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_SUGGESTION_CONTENTS 173
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME_SUFFIX 172
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME 171
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUGGESTION_CONTENTS 177
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUFFIX 176
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK 175
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_HINT 39609
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_SUGGESTION_CONTENTS 39610
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2_SUFFIX 39611
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_V2 39612
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_HINT 182
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUGGESTION_CONTENTS 181
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUFFIX 180
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS 179
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_HINT 186
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_SUGGESTION_CONTENTS 185
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES_SUFFIX 184
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES 183
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_HINT 190
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUGGESTION_CONTENTS 189
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUFFIX 188
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES 187
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_HINT 194
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_SUGGESTION_CONTENTS 193
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC_SUFFIX 192
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC 191
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_HINT 198
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUGGESTION_CONTENTS 197
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUFFIX 196
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS 195
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_HINT 206
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUGGESTION_CONTENTS 205
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUFFIX 204
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC 203
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_HINT 210
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUGGESTION_CONTENTS 209
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUFFIX 208
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET 207
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_HINT 214
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUGGESTION_CONTENTS 213
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUFFIX 212
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE 211
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_HINT 218
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUGGESTION_CONTENTS 217
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUFFIX 216
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT 215
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_HINT 222
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUGGESTION_CONTENTS 221
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUFFIX 220
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE 219
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_HINT 226
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUGGESTION_CONTENTS 225
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUFFIX 224
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE 223
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_HINT 230
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUGGESTION_CONTENTS 229
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUFFIX 228
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM 227
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_HINT 202
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUGGESTION_CONTENTS 201
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUFFIX 200
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS 199
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_HINT 234
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUGGESTION_CONTENTS 233
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUFFIX 232
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT 231
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_HINT 238
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUGGESTION_CONTENTS 237
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUFFIX 236
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD 235
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_HINT 39613
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUGGESTION_CONTENTS 39614
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUFFIX 39615
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS 39616
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 242
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUGGESTION_CONTENTS 241
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUFFIX 240
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME 239
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_HINT 246
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_SUGGESTION_CONTENTS 245
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE_SUFFIX 244
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE 243
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_HINT 250
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUGGESTION_CONTENTS 249
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUFFIX 248
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY 247
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 254
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUGGESTION_CONTENTS 253
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUFFIX 252
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS 251
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_HINT 258
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUGGESTION_CONTENTS 257
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUFFIX 256
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS 255
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 262
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUGGESTION_CONTENTS 261
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUFFIX 260
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY 259
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_HINT 266
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUGGESTION_CONTENTS 265
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUFFIX 264
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE 263
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_HINT 270
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUGGESTION_CONTENTS 269
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUFFIX 268
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY 267
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_HINT 274
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUGGESTION_CONTENTS 273
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUFFIX 272
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS 271
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_HINT 278
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUGGESTION_CONTENTS 277
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUFFIX 276
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES 275
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_HINT 282
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUGGESTION_CONTENTS 281
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUFFIX 280
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES 279
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_HINT 39617
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUGGESTION_CONTENTS 39618
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUFFIX 39619
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY 39620
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 286
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 285
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 284
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 283
#define IDS_ANDROID_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 39621
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 39622
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 39623
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 39624
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 39625
#define IDS_IOS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 39626
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 39627
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 39628
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 39629
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 39630
#define IDS_IOS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 39631
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 39632
#define IDS_IOS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 39633
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 39634
#define IDS_IOS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 39635
#define IDS_IOS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 39636
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 39637
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 39638
#define IDS_AUTOCOMPLETE_SEARCH_DESCRIPTION 39639
#define IDS_EMPTY_KEYWORD_VALUE 471
#define IDS_LINK_FROM_CLIPBOARD 39640
#define IDS_TEXT_FROM_CLIPBOARD 39641
#define IDS_IMAGE_FROM_CLIPBOARD 39642
#define IDS_SECURE_CONNECTION_EV 39643
#define IDS_SECURE_VERBOSE_STATE 39644
#define IDS_NOT_SECURE_VERBOSE_STATE 39645
#define IDS_DANGEROUS_VERBOSE_STATE 39646
#define IDS_OFFLINE_VERBOSE_STATE 39647
#define IDS_OMNIBOX_EMPTY_HINT 39648
#define IDS_OMNIBOX_ADDITIONAL_TEXT_DASH_TEMPLATE 39650
#define IDS_OMNIBOX_ADDITIONAL_TEXT_PARENTHESIS_TEMPLATE 39651
#define IDS_OMNIBOX_TAB_SUGGEST_HINT 39652
#define IDS_OMNIBOX_HISTORY_EMBEDDING_HINT 39653
#define IDS_OMNIBOX_FILE 39654
#define IDS_OMNIBOX_READER_MODE 39655
#define IDS_DRIVE_SUGGESTION_DOCUMENT 39656
#define IDS_DRIVE_SUGGESTION_FORM 39657
#define IDS_DRIVE_SUGGESTION_SPREADSHEET 39658
#define IDS_DRIVE_SUGGESTION_PRESENTATION 39659
#define IDS_DRIVE_SUGGESTION_GENERAL 39660
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE 39661
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_DATE 39662
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_OWNER 39663
#define IDS_ACCURACY_CHECK_VERBOSE_STATE 39664
#define IDS_OMNIBOX_HISTORY_CLUSTERS_SEARCH_HINT 39665
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_HINT 39666
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUGGESTION_CONTENTS 39667
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUFFIX 39668
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH 39669
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST_SUFFIX 39670
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST 39671
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_HINT 39672
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_CONTENTS 39673
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_HINT 39674
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_CONTENTS 39675
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_HINT 39676
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_CONTENTS 39677
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_HINT 39678
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_CONTENTS 39679
#define IDS_ACC_OMNIBOX_ACTION_IN_EXTENSION_SUGGEST_SUFFIX 39680
#define IDS_ACC_AUTOCOMPLETE_HISTORY 39681
#define IDS_ACC_AUTOCOMPLETE_SEARCH_HISTORY 39682
#define IDS_ACC_AUTOCOMPLETE_SEARCH 39683
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH 39684
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH_ENTITY 39685
#define IDS_ACC_AUTOCOMPLETE_QUICK_ANSWER 39686
#define IDS_ACC_AUTOCOMPLETE_BOOKMARK 39687
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_IMAGE 39688
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_TEXT 39689
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_URL 39690
#define IDS_ACC_SEARCH_ICON 472
#define IDS_ACC_AUTOCOMPLETE_N_OF_M 39691
#define IDS_ACC_TAB_SWITCH_SUFFIX 39692
#define IDS_ACC_TAB_SWITCH_BUTTON_FOCUSED_PREFIX 39693
#define IDS_ACC_TAB_SWITCH_BUTTON 39694
#define IDS_ACC_MULTIPLE_ACTIONS_SUFFIX 39695
#define IDS_ACC_KEYWORD_SUFFIX 39696
#define IDS_ACC_KEYWORD_MODE 39697
#define IDS_ACC_ASK_KEYWORD_MODE 39698
#define IDS_ACC_THUMBS_UP_SUGGESTION_FOCUSED_PREFIX 39699
#define IDS_ACC_THUMBS_UP_SUGGESTION_BUTTON 39700
#define IDS_ACC_THUMBS_DOWN_SUGGESTION_FOCUSED_PREFIX 39701
#define IDS_ACC_THUMBS_DOWN_SUGGESTION_BUTTON 39702
#define IDS_ACC_REMOVE_SUGGESTION_SUFFIX 39703
#define IDS_ACC_REMOVE_SUGGESTION_FOCUSED_PREFIX 39704
#define IDS_ACC_REMOVE_SUGGESTION_BUTTON 39705
#define IDS_TOOLTIP_HEADER_SHOW_SUGGESTIONS_BUTTON 670
#define IDS_TOOLTIP_HEADER_HIDE_SUGGESTIONS_BUTTON 669
#define IDS_ACC_HEADER_SHOW_SUGGESTIONS_BUTTON 39706
#define IDS_ACC_HEADER_HIDE_SUGGESTIONS_BUTTON 39707
#define IDS_ACC_HEADER_SECTION_SHOWN 39708
#define IDS_ACC_HEADER_SECTION_HIDDEN 39709
#define IDS_ACC_CHROME_TIP 39710
#define IDS_ACC_DISMISS_CHROME_TIP_SUFFIX 39711
#define IDS_ACC_DISMISS_CHROME_TIP_FOCUSED_PREFIX 39712
#define IDS_ACC_DISMISS_CHROME_TIP_BUTTON 39713
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_NAME 39714
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_KEYWORD 39715
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_NAME 39716
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_KEYWORD 39717
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_NAME 39718
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_KEYWORD 39719
#define IDS_SEARCH_ENGINES_STARTER_PACK_GEMINI_NAME 39720
#define IDS_SEARCH_ENGINES_STARTER_PACK_GEMINI_KEYWORD 39721
#define IDS_OMNIBOX_INSTANT_KEYWORD_ASK_TEXT 39722
#define IDS_OMNIBOX_INSTANT_KEYWORD_SEARCH_TEXT 39723
#define IDS_OMNIBOX_SELECTED_KEYWORD_ASK_TEXT 39724
#define IDS_OMNIBOX_TAB_SEARCH_NO_RESULTS_FOUND 39725
#define IDS_OMNIBOX_GEMINI_IPH 39726
#define IDS_OMNIBOX_FEATURED_ENTERPRISE_SITE_SEARCH_IPH 39727
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SETTINGS_PROMO_IPH 39728
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SETTINGS_PROMO_IPH_LINK_TEXT 39729
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_DISCLAIMER_IPH 39730
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_DISCLAIMER_IPH_LINK_TEXT 39731
#define IDS_ACC_OMNIBOX_IPH_LINK_SELECTED 39732
#define IDS_OMNIBOX_HISTORY_SCOPE_PROMO_IPH 39733
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SCOPE_PROMO_IPH 39734
#define IDS_OMNIBOX_ONE_LINE_CALCULATOR_SUGGESTION_TEMPLATE 39735
#define IDS_OMNIBOX_HEADER_POPULAR_TOPICS 39736
#define IDS_OMNIBOX_BOOKMARKS_SCOPE_PLACEHOLDER_TEXT 39737
#define IDS_OMNIBOX_HISTORY_SCOPE_PLACEHOLDER_TEXT 39738
#define IDS_OMNIBOX_HISTORY_EMBEDDINGS_SCOPE_PLACEHOLDER_TEXT 39739
#define IDS_OMNIBOX_TABS_SCOPE_PLACEHOLDER_TEXT 39740
#define IDS_OMNIBOX_GEMINI_SCOPE_PLACEHOLDER_TEXT 39741
#define IDS_OMNIBOX_HUB_OPEN_TABS_HEADER 39742
#define IDS_OMNIBOX_HUB_SEARCH_HEADER 39743
#define IDS_OMNIBOX_HUB_HISTORY_HEADER 39744
#define IDS_PAGE_INFO_SECURE_SUMMARY 39745
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY 39746
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY_SHORT 39747
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY 39748
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY_SHORT 39749
#define IDS_PAGE_INFO_SAFE_BROWSING_SUMMARY 39750
#define IDS_PAGE_INFO_EXTENSION_PAGE 39751
#define IDS_PAGE_INFO_VIEW_SOURCE_PAGE 39752
#define IDS_PAGE_INFO_DEVTOOLS_PAGE 39753
#define IDS_PAGE_INFO_READER_MODE_PAGE_SECURE 39754
#define IDS_PAGE_INFO_READER_MODE_PAGE 39755
#define IDS_PAGE_INFO_SAFETY_TIP_MORE_INFO_LINK 39756
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_LEAVE_BUTTON 39757
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_TITLE 39758
#define IDS_PAGE_INFO_SAFETY_TIP_DESCRIPTION 39759
#define IDS_PAGE_INFO_FILE_PAGE 39760
#define IDS_PAGE_INFO_SECURE_DETAILS 39761
#define IDS_PAGE_INFO_ADMIN_PROVIDED_CERT_DETAILS 39762
#define IDS_PAGE_INFO_MIXED_CONTENT_DETAILS 39763
#define IDS_PAGE_INFO_LEGACY_TLS_DETAILS 39764
#define IDS_PAGE_INFO_NOT_SECURE_DETAILS 39765
#define IDS_PAGE_INFO_MALWARE_DETAILS 39766
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_DETAILS 39767
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_DETAILS 39768
#define IDS_PAGE_INFO_SECURITY_TAB_INSECURE_IDENTITY 39769
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SUMMARY 39770
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SAVED_PASSWORD_SUMMARY 39771
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SAVED 39772
#define IDS_PAGE_INFO_CHECK_PASSWORDS_BUTTON 39773
#define IDS_PAGE_INFO_INVALID_CERTIFICATE_DESCRIPTION 39774
#define IDS_PAGE_INFO_RESET_INVALID_CERTIFICATE_DECISIONS_BUTTON 39775
#define IDS_PAGE_INFO_HELP_CENTER_LINK 39776
#define IDS_PAGE_INFO_SECURITY_TAB_DEPRECATED_SIGNATURE_ALGORITHM 39777
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_CONNECTION_TEXT 39778
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_ERROR 39779
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_WARNING 39780
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_FORM_WARNING 39781
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_SENTENCE_LINK 39782
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS 39783
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS_AEAD 39784
#define IDS_PAGE_INFO_SECURITY_TAB_NOT_ENCRYPTED_CONNECTION_TEXT 39785
#define IDS_PAGE_INFO_SECURITY_TAB_SSL_VERSION 39786
#define IDS_PAGE_INFO_SECURITY_TAB_UNKNOWN_PARTY 39787
#define IDS_PAGE_INFO_SECURITY_TAB_WEAK_ENCRYPTION_CONNECTION_TEXT 39788
#define IDS_PAGE_INFO_CERT_INFO_BUTTON 39789
#define IDS_PAGE_INFO_ADDRESS 39790
#define IDS_PAGE_INFO_PARTIAL_ADDRESS 39791
#define IDS_PAGE_INFO_SECURITY_TAB_SECURE_IDENTITY_EV_VERIFIED 39792
#define IDS_PAGE_INFO_CERTIFICATE 39793
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK 39794
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK 39795
#define IDS_PAGE_INFO_CERTIFICATE_BUTTON_TEXT 39796
#define IDS_PAGE_INFO_CERTIFICATE_VALID_PARENTHESIZED 39797
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_PARENTHESIZED 39798
#define IDS_PAGE_INFO_CERTIFICATE_IS_VALID 39799
#define IDS_PAGE_INFO_CERTIFICATE_DETAILS 39800
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK_TOOLTIP 39801
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK_TOOLTIP 39802
#define IDS_PAGE_INFO_COOKIES 39804
#define IDS_PAGE_INFO_COOKIES_BUTTON_TEXT 39805
#define IDS_PAGE_INFO_NUM_COOKIES_PARENTHESIZED 39806
#define IDS_PAGE_INFO_NUM_COOKIES 39807
#define IDS_PAGE_INFO_COOKIES_TOOLTIP 39808
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_USER 39809
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_ONCE_BY_USER 39810
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_USER 39811
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_USER 39812
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_USER 39813
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_USER 39814
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_DEFAULT 39815
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_DEFAULT 39816
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_DEFAULT 39817
#define IDS_PAGE_INFO_BUTTON_TEXT_AUTOMATIC_BY_DEFAULT 39818
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_DEFAULT 39819
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_DEFAULT 39820
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ALLOW 39821
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_BLOCK 39822
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ASK 39823
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_DETECT_IMPORTANT_CONTENT 39824
#define IDS_PAGE_INFO_MENU_ITEM_ALLOW 39825
#define IDS_PAGE_INFO_MENU_ITEM_BLOCK 39826
#define IDS_PAGE_INFO_MENU_ITEM_ASK 39827
#define IDS_PAGE_INFO_MENU_ITEM_DETECT_IMPORTANT_CONTENT 39828
#define IDS_PAGE_INFO_MENU_ITEM_ADS_BLOCK 39829
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED 39830
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_ONCE 39831
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED 39832
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_INCOGNITO 39833
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_GUEST 39834
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_INSECURE 39835
#define IDS_PAGE_INFO_STATE_TEXT_MUTED 39836
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_BY_DEFAULT 39837
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_BY_DEFAULT 39838
#define IDS_PAGE_INFO_SELECTOR_TOOLTIP 39839
#define IDS_PAGE_INFO_SELECTOR_STORAGE_ACCESS_TOOLTIP 39840
#define IDS_PAGE_INFO_STATE_TEXT_AR_ASK 39841
#define IDS_PAGE_INFO_STATE_TEXT_AUTO_PICTURE_IN_PICTURE_ASK 39842
#define IDS_PAGE_INFO_STATE_TEXT_AUTOMATIC_DOWNLOADS_ASK 39843
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_DEVICES_ASK 39844
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_ASK 39845
#define IDS_PAGE_INFO_STATE_TEXT_CAPTURED_SURFACE_CONTROL_ASK 39846
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_PAN_TILT_ZOOM_ASK 39847
#define IDS_PAGE_INFO_STATE_TEXT_CLIPBOARD_ASK 39848
#define IDS_PAGE_INFO_STATE_TEXT_FILE_SYSTEM_WRITE_ASK 39849
#define IDS_PAGE_INFO_STATE_TEXT_HAND_TRACKING_ASK 39850
#define IDS_PAGE_INFO_STATE_TEXT_HID_DEVICES_ASK 39851
#define IDS_PAGE_INFO_STATE_TEXT_KEYBOARD_LOCK_ASK 39852
#define IDS_PAGE_INFO_STATE_TEXT_LOCATION_ASK 39853
#define IDS_PAGE_INFO_STATE_TEXT_MIC_ASK 39854
#define IDS_PAGE_INFO_STATE_TEXT_MIDI_SYSEX_ASK 39855
#define IDS_PAGE_INFO_STATE_TEXT_NOTIFICATIONS_ASK 39856
#define IDS_PAGE_INFO_STATE_TEXT_POINTER_LOCK_ASK 39857
#define IDS_PAGE_INFO_STATE_TEXT_USB_ASK 39858
#define IDS_PAGE_INFO_STATE_TEXT_VR_ASK 39859
#define IDS_PAGE_INFO_STATE_TEXT_FONT_ACCESS_ASK 39860
#define IDS_PAGE_INFO_STATE_TEXT_SERIAL_ASK 39861
#define IDS_PAGE_INFO_STATE_TEXT_IDLE_DETECTION_ASK 39862
#define IDS_PAGE_INFO_STATE_TEXT_WINDOW_MANAGEMENT_ASK 39863
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_SCANNING_ASK 39864
#define IDS_PAGE_INFO_STATE_TEXT_STORAGE_ACCESS_ASK 39865
#define IDS_PAGE_INFO_STATE_TEXT_WEB_APP_INSTALLATION_ASK 39866
#define IDS_PAGE_INFO_STATE_TEXT_WEB_PRINTING_ASK 39867
#define IDS_PAGE_INFO_USB_DEVICE_SECONDARY_LABEL 39868
#define IDS_PAGE_INFO_USB_DEVICE_ALLOWED_BY_POLICY_LABEL 39869
#define IDS_PAGE_INFO_DELETE_USB_DEVICE_WITH_NAME 39870
#define IDS_PAGE_INFO_SERIAL_PORT_SECONDARY_LABEL 39871
#define IDS_PAGE_INFO_SERIAL_PORT_ALLOWED_BY_POLICY_LABEL 39872
#define IDS_PAGE_INFO_DELETE_SERIAL_PORT_WITH_NAME 39873
#define IDS_PAGE_INFO_BLUETOOTH_DEVICE_SECONDARY_LABEL 39874
#define IDS_PAGE_INFO_DELETE_BLUETOOTH_DEVICE_WITH_NAME 39875
#define IDS_PAGE_INFO_HID_DEVICE_SECONDARY_LABEL 39876
#define IDS_PAGE_INFO_HID_DEVICE_ALLOWED_BY_POLICY_LABEL 39877
#define IDS_PAGE_INFO_DELETE_HID_DEVICE_WITH_NAME 39878
#define IDS_PAGE_INFO_SMART_CARD_READER_ALLOWED_BY_POLICY_LABEL 39879
#define IDS_PAGE_INFO_SMART_CARD_READER_SECONDARY_LABEL 39880
#define IDS_PAGE_INFO_DELETE_SMART_CARD_READER_WITH_NAME 39881
#define IDS_PAGE_INFO_SITE_SETTINGS_LINK 39882
#define IDS_PAGE_INFO_SITE_SETTINGS_TOOLTIP 39883
#define IDS_PAGE_INFO_CAMERA_SYSTEM_SETTINGS_DESCRIPTION 39886
#define IDS_PAGE_INFO_MICROPHONE_SYSTEM_SETTINGS_DESCRIPTION 39887
#define IDS_PAGE_INFO_LOCATION_SYSTEM_SETTINGS_DESCRIPTION 39888
#define IDS_PAGE_INFO_SETTINGS_OF_A_SYSTEM_LINK 39889
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_POLICY 39890
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_POLICY 39891
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_POLICY 39892
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_EXTENSION 39893
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_EXTENSION 39894
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_EXTENSION 39895
#define IDS_PAGE_INFO_PERMISSION_AUTOMATICALLY_BLOCKED 39896
#define IDS_PAGE_INFO_PERMISSION_ADS_SUBTITLE 39897
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_POLICY 39898
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_EXTENSION 39899
#define IDS_PAGE_INFO_INFOBAR_TEXT 39900
#define IDS_PAGE_INFO_INFOBAR_BUTTON 39901
#define IDS_PAGE_INFO_PERMISSION_USING_NOW 39902
#define IDS_PAGE_INFO_PERMISSION_RECENTLY_USED 39903
#define IDS_PAGE_INFO_PERMISSION_USED_TIME_AGO 39904
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS 39905
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SYNC 39906
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SIGNED_IN_NON_SYNC 39907
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE 39908
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE_WITH_ORG_NAME 39909
#define IDS_PAGE_INFO_CHANGE_PASSWORD_BUTTON 39910
#define IDS_PAGE_INFO_PROTECT_ACCOUNT_BUTTON 39911
#define IDS_PAGE_INFO_IGNORE_PASSWORD_WARNING_BUTTON 39912
#define IDS_PAGE_INFO_ALLOWLIST_PASSWORD_REUSE_BUTTON 39913
#define IDS_PAGE_INFO_BILLING_SUMMARY 39914
#define IDS_PAGE_INFO_BILLING_DETAILS 39915
#define IDS_PAGE_INFO_VR_PRESENTING_TEXT 39916
#define IDS_PAGE_INFO_VR_TURN_OFF_BUTTON_TEXT 39917
#define IDS_CERT_INFO_SUBJECT_GROUP 39918
#define IDS_CERT_INFO_ISSUER_GROUP 39919
#define IDS_CERT_INFO_COMMON_NAME_LABEL 39920
#define IDS_CERT_INFO_ORGANIZATION_LABEL 39921
#define IDS_CERT_INFO_ORGANIZATIONAL_UNIT_LABEL 39922
#define IDS_CERT_INFO_SERIAL_NUMBER_LABEL 39923
#define IDS_CERT_INFO_VALIDITY_GROUP 39924
#define IDS_CERT_INFO_ISSUED_ON_LABEL 39925
#define IDS_CERT_INFO_EXPIRES_ON_LABEL 39926
#define IDS_CERT_INFO_FINGERPRINTS_GROUP 39927
#define IDS_CERT_INFO_SHA256_FINGERPRINT_LABEL 39928
#define IDS_CERT_INFO_SHA256_SPKI_FINGERPRINT_LABEL 39929
#define IDS_CERT_DETAILS_EXTENSIONS 39930
#define IDS_CERT_X509_SUBJECT_ALT_NAME 39931
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_BUTTON 39932
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_HEADER 39933
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_BUTTON_TOOLTIP 39934
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON 39935
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON_TOOLTIP 39936
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_REMEMBER_THIS_SETTING 39937
#define IDS_PAGE_INFO_RESET_PERMISSIONS 39938
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_HEADER 39939
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TITLE 39940
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_DESCRIPTION_PLACEHOLDER 39941
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_TOOLTIP 39942
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TOOLTIP 39943
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_SUBPAGE_FROM_LABEL 39944
#define IDS_PAGE_INFO_COOKIES_HEADER 39945
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_LABEL_ALLOWED 39946
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_LABEL_BLOCKED 39947
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_INFO_BUTTON_LABEL_LIMITED 39948
#define IDS_PAGE_INFO_COOKIES_DESCRIPTION 39949
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_GRANT_DESCRIPTION 39950
#define IDS_PAGE_INFO_TRACKING_PROTECTION_DESCRIPTION 39951
#define IDS_PAGE_INFO_TRACKING_PROTECTION_BLOCKED_COOKIES_DESCRIPTION 39952
#define IDS_PAGE_INFO_TRACKING_PROTECTION_INCOGNITO_BLOCKED_COOKIES_DESCRIPTION 39953
#define IDS_PAGE_INFO_COOKIES_SETTINGS_LINK 39954
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SETTINGS_LINK 39955
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TITLE 39956
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TOGGLE_TOOLTIP 39957
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_MANAGED_BY_SETTINGS_TOOLTIP 39958
#define IDS_PAGE_INFO_COOKIES_ALLOWED_SITES_COUNT 39959
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TITLE 39960
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TOOLTIP 39961
#define IDS_PAGE_INFO_RWS_BUTTON_TOOLTIP 39962
#define IDS_PAGE_INFO_RWS_BUTTON_TITLE 39963
#define IDS_PAGE_INFO_RWS_BUTTON_SUBTITLE 39964
#define IDS_PAGE_INFO_COOKIES_SITE_NOT_WORKING_TITLE 39965
#define IDS_PAGE_INFO_TRACKING_PROTECTION_SITE_NOT_WORKING_DESCRIPTION_TEMPORARY 39966
#define IDS_PAGE_INFO_COOKIES_THIRD_PARTY_COOKIES_LABEL 39967
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_LIMITED_RESTART_TITLE 39968
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_BLOCKED_RESTART_TITLE 39969
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_RESTART_DESCRIPTION 39970
#define IDS_PAGE_INFO_TRACKING_PROTECTION_PERMANENT_ALLOWED_TITLE 39971
#define IDS_PAGE_INFO_TRACKING_PROTECTION_COOKIES_PERMANENT_ALLOWED_DESCRIPTION 39972
#define IDS_MERCHANT_TRUST_SIDE_PANEL_TITLE 39973
#define IDS_PAGE_INFO_MERCHANT_TRUST_HEADER 39974
#define IDS_PAGE_INFO_MERCHANT_TRUST_DESCRIPTION 39975
#define IDS_PAGE_INFO_MERCHANT_TRUST_VIEW_ALL_REVIEWS 39976
#define IDS_PAGE_INFO_MERCHANT_TRUST_STAR_RATING_AND_COUNT_A11Y_DESCRIPTION 39977
#define IDS_PAGE_INFO_MERCHANT_TRUST_STAR_RATING_A11Y_DESCRIPTION 39978
#define IDS_PAGE_INFO_MERCHANT_TRUST_REVIEWS_SUMMARY_TITLE 39979
#define IDS_PAGE_INFO_MERCHANT_TRUST_HATS_BUTTON 39980
#define IDS_PAGE_INFO_MERCHANT_TRUST_HATS_LOADING_BUTTON 39981
#define IDS_PAGE_INFO_MERCHANT_TRUST_HATS_FAILED_BUTTON 39982
#define IDS_PAGE_INFO_HISTORY 39983
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_TODAY 39984
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_YESTERDAY 39985
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DAYS 39986
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DATE 39987
#define IDS_PAGE_INFO_ENTERPRISE_WARN_SUMMARY 39988
#define IDS_PAGE_INFO_ENTERPRISE_WARN_DETAILS 39989
#define IDS_PAGE_INFO_ENTERPRISE_BLOCK_SUMMARY 39990
#define IDS_PAGE_INFO_ENTERPRISE_BLOCK_DETAILS 39991
#define IDS_PAGE_INFO_AD_PRIVACY_HEADER 39992
#define IDS_PAGE_INFO_AD_PRIVACY_TOOLTIP 39993
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_DESCRIPTION 39994
#define IDS_PAGE_INFO_AD_PRIVACY_FLEDGE_DESCRIPTION 39995
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_AND_FLEDGE_DESCRIPTION 39996
#define IDS_PAGE_INFO_AD_PRIVACY_SUBPAGE_MANAGE_BUTTON 39997
#define IDS_PAINT_PREVIEW_COMPOSITOR_SERVICE_DISPLAY_NAME 39998
#define IDS_LEAK_CHECK_CREDENTIALS 39999
#define IDS_CREDENTIAL_LEAK_TITLE_CHANGE 40000
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK_GPM 40001
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 40002
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_BRANDED 40003
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 40004
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 40005
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_NON_BRANDED 40006
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 40007
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE 40009
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE 40010
#define IDS_PASSWORD_MANAGER_EMPTY_LOGIN 40011
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS 40012
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_AND_PASSKEYS 40013
#define IDS_PASSWORD_MANAGER_GENERATE_PASSWORD 40014
#define IDS_PASSWORD_MANAGER_EXCEPTIONS_TAB_TITLE 40015
#define IDS_PASSWORD_MANAGER_SHOW_PASSWORDS_TAB_TITLE 40016
#define IDS_PASSWORD_MANAGER_SMART_LOCK 40017
#define IDS_PASSWORD_MANAGER_DEFAULT_EXPORT_FILENAME 40018
#define IDS_PASSWORD_MANAGER_PASSWORD_FOR_ACCOUNT 40019
#define IDS_PASSWORD_MANAGER_USE_TOUCH_ID 40020
#define IDS_PASSWORD_MANAGER_USE_SCREEN_LOCK 40021
#define IDS_PASSWORD_MANAGER_PASSKEY 40022
#define IDS_PASSWORD_MANAGER_USE_WINDOWS_HELLO 40023
#define IDS_PASSWORD_MANAGER_USE_GENERIC_DEVICE 40024
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_CHROME_PROFILE 40025
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_ICLOUD_KEYCHAIN 40026
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_GOOGLE_PASSWORD_MANAGER 40027
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_WINDOWS_HELLO 40028
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_PHONE 40029
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_CHROME_PROFILE_NEW 40030
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_ICLOUD_KEYCHAIN_NEW 40031
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_GOOGLE_PASSWORD_MANAGER_NEW 40032
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_WINDOWS_HELLO_NEW 40033
#define IDS_PASSWORD_MANAGER_PASSKEY_FROM_PHONE_NEW 40034
#define IDS_PASSWORD_MANAGER_USE_DEVICE_PASSKEY 40035
#define IDS_PASSWORD_MANAGER_USE_DIFFERENT_PASSKEY 40036
#define IDS_PASSWORD_MANAGER_USE_PASSKEY 40037
#define IDS_PASSWORD_MANAGER_FILLING_REAUTH 40046
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_TITLE_WIN 40047
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_MESSAGE_WIN 40048
#define IDS_PASSWORD_MANAGER_TURN_ON_FILLING_REAUTH_WIN 40049
#define IDS_PASSWORD_MANAGER_TURN_OFF_FILLING_REAUTH_WIN 40050
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_CONFIRMATION_TITLE_WIN 40051
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_CONFIRMATION_DESCRIPTION_WIN 40052
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_ACCEPT_BUTTON 40067
#define IDS_PASSWORD_MANAGER_SETTINGS 40068
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_CANCEL_BUTTON 40069
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_FOOTER_MOVE_PASSWORD 40074
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LINK_TEXT_MOVE_PASSWORD 40075
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_SUGGESTED_PASSWORDS_SECTION_TITLE 40076
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_ALL_PASSWORDS_SECTION_TITLE 40077
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_FILL_PASSWORD_ENTRY 40078
#define IDS_PASSWORD_MANAGER_MANUAL_FALLBACK_VIEW_DETAILS_ENTRY 40079
#define IDS_PAYMENTS_TITLE 40080
#define IDS_PAYMENTS_ERROR_MESSAGE_DIALOG_TITLE 40081
#define IDS_PAYMENTS_METHOD_OF_PAYMENT_LABEL 40082
#define IDS_PAYMENTS_CONTACT_DETAILS_LABEL 40083
#define IDS_PAYMENTS_ADD_CONTACT_DETAILS_LABEL 40084
#define IDS_PAYMENTS_EDIT_CONTACT_DETAILS_LABEL 40085
#define IDS_PAYMENTS_ADD_MORE_INFORMATION 40086
#define IDS_PAYMENTS_ADD_PHONE_NUMBER 40087
#define IDS_PAYMENTS_ADD_RECIPIENT 40088
#define IDS_PAYMENTS_ADD_VALID_ADDRESS 40089
#define IDS_PAYMENTS_ADD_EMAIL 40090
#define IDS_PAYMENTS_ADD_NAME 40091
#define IDS_PAYMENTS_ORDER_SUMMARY_LABEL 40092
#define IDS_PAYMENT_REQUEST_PAYMENT_METHOD_SECTION_NAME 40093
#define IDS_PAYMENT_REQUEST_CONTACT_INFO_SECTION_NAME 40094
#define IDS_PAYMENTS_SHIPPING_SUMMARY_LABEL 40095
#define IDS_PAYMENTS_SHIPPING_ADDRESS_LABEL 40096
#define IDS_PAYMENTS_SHIPPING_OPTION_LABEL 40097
#define IDS_PAYMENTS_DELIVERY_SUMMARY_LABEL 40098
#define IDS_PAYMENTS_DELIVERY_ADDRESS_LABEL 40099
#define IDS_PAYMENTS_DELIVERY_OPTION_LABEL 40100
#define IDS_PAYMENTS_PICKUP_SUMMARY_LABEL 40101
#define IDS_PAYMENTS_PICKUP_ADDRESS_LABEL 40102
#define IDS_PAYMENTS_PICKUP_OPTION_LABEL 40103
#define IDS_PAYMENTS_EDIT_BUTTON 40104
#define IDS_PAYMENTS_PAY_BUTTON 40105
#define IDS_PAYMENTS_CONTINUE_BUTTON 40106
#define IDS_PAYMENTS_ADD_CONTACT 40107
#define IDS_PAYMENTS_ADD_CARD 40108
#define IDS_PAYMENTS_ADD_ADDRESS 40109
#define IDS_PAYMENTS_EDIT_ADDRESS 40110
#define IDS_PAYMENTS_CANCEL_PAYMENT 40111
#define IDS_PAYMENTS_NAME_FIELD_IN_CONTACT_DETAILS 40112
#define IDS_PAYMENTS_PHONE_FIELD_IN_CONTACT_DETAILS 40113
#define IDS_PAYMENTS_EMAIL_FIELD_IN_CONTACT_DETAILS 40114
#define IDS_PAYMENTS_LOADING_MESSAGE 40115
#define IDS_PAYMENTS_PROCESSING_MESSAGE 40116
#define IDS_PAYMENTS_CHECKING_OPTION 40117
#define IDS_PAYMENTS_UPDATED_LABEL 40118
#define IDS_PAYMENTS_ERROR_MESSAGE 40119
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS 40120
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_IN 40121
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_OUT 40122
#define IDS_SETTINGS_CAN_MAKE_PAYMENT_TOGGLE_LABEL 40123
#define IDS_PAYMENTS_REQUIRED_FIELD_MESSAGE 40124
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRED 40125
#define IDS_PAYMENTS_VALIDATION_UNSUPPORTED_CREDIT_CARD_TYPE 40126
#define IDS_PAYMENTS_PHONE_INVALID_VALIDATION_MESSAGE 40127
#define IDS_PAYMENTS_EMAIL_INVALID_VALIDATION_MESSAGE 40128
#define IDS_PAYMENTS_CARD_NUMBER_INVALID_VALIDATION_MESSAGE 40129
#define IDS_PAYMENTS_INVALID_ADDRESS 40130
#define IDS_PAYMENTS_BILLING_ADDRESS_REQUIRED 40131
#define IDS_PAYMENTS_MORE_INFORMATION_REQUIRED 40132
#define IDS_PAYMENTS_PHONE_NUMBER_REQUIRED 40133
#define IDS_PAYMENTS_RECIPIENT_REQUIRED 40134
#define IDS_PAYMENTS_EMAIL_REQUIRED 40135
#define IDS_PAYMENTS_NAME_REQUIRED 40136
#define IDS_PREF_EDIT_DIALOG_FIELD_REQUIRED_VALIDATION_MESSAGE 40137
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SECTION_TOTAL_FORMAT 40138
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SHEET_TOTAL_FORMAT 40139
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MORE_ITEMS 40140
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MULTIPLE_CURRENCY_INDICATOR 40141
#define IDS_PAYMENTS_SELECT_SHIPPING_ADDRESS_FOR_SHIPPING_METHODS 40142
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_ADDRESS 40143
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_OPTION 40144
#define IDS_PAYMENTS_SELECT_DELIVERY_ADDRESS_FOR_DELIVERY_METHODS 40145
#define IDS_PAYMENTS_UNSUPPORTED_DELIVERY_ADDRESS 40146
#define IDS_PAYMENTS_SELECT_PICKUP_ADDRESS_FOR_PICKUP_METHODS 40147
#define IDS_PAYMENTS_UNSUPPORTED_PICKUP_ADDRESS 40148
#define IDS_PAYMENTS_ANDROID_APP_ERROR 40149
#define IDS_PAYMENT_REQUEST_PAYMENT_METHODS_PREVIEW 40151
#define IDS_PAYMENT_REQUEST_SHIPPING_ADDRESSES_PREVIEW 40152
#define IDS_PAYMENT_REQUEST_SHIPPING_OPTIONS_PREVIEW 40153
#define IDS_PAYMENT_REQUEST_CONTACTS_PREVIEW 40154
#define IDS_PAYMENTS_BACK 40155
#define IDS_PAYMENTS_CLOSE 40156
#define IDS_PAYMENTS_EDIT 40157
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_FORMAT 40158
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_SELECTED_FORMAT 40159
#define IDS_PAYMENTS_PROFILE_LABELS_ACCESSIBLE_FORMAT 40160
#define IDS_PAYMENTS_ACCESSIBLE_LABEL_WITH_ERROR 40161
#define IDS_PAYMENTS_ORDER_SUMMARY_ACCESSIBLE_LABEL 40162
#define IDS_PAYMENT_HANDLER_SHEET_DESCRIPTION 40163
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_HALF 40164
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_FULL 40165
#define IDS_PAYMENT_HANDLER_SHEET_CLOSED 40166
#define IDS_PAYMENT_HANDLER_ICON 40167
#define IDS_SECURE_PAYMENT_CONFIRMATION_INLINE_TITLE 40168
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_PURCHASE 40169
#define IDS_SECURE_PAYMENT_CONFIRMATION_INLINE_DESCRIPTION 40170
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LABEL 40171
#define IDS_SECURE_PAYMENT_CONFIRMATION_STORE_LABEL 40174
#define IDS_SECURE_PAYMENT_CONFIRMATION_TOTAL_LABEL 40175
#define IDS_SECURE_PAYMENT_CONFIRMATION_NETWORK_LABEL 40176
#define IDS_SECURE_PAYMENT_CONFIRMATION_ISSUER_LABEL 40177
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_BUTTON_LABEL 40178
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LINK_LABEL 40179
#define IDS_NO_MATCHING_CREDENTIAL_DESCRIPTION 40180
#define IDS_PDF_DOWNLOAD_ORIGINAL 40187
#define IDS_PDF_DOWNLOAD_EDITED 40188
#define IDS_PDF_PRESENT 40189
#define IDS_PDF_NEED_PASSWORD 40190
#define IDS_PDF_PASSWORD_DIALOG_TITLE 40191
#define IDS_PDF_PASSWORD_SUBMIT 40192
#define IDS_PDF_PASSWORD_INVALID 40193
#define IDS_PDF_PAGE_LOADING 40194
#define IDS_PDF_ERROR_DIALOG_TITLE 40195
#define IDS_PDF_PAGE_LOAD_FAILED 40196
#define IDS_PDF_PAGE_RELOAD_BUTTON 40197
#define IDS_PDF_BOOKMARKS 40198
#define IDS_PDF_BOOKMARK_EXPAND_ICON_ARIA_LABEL 40199
#define IDS_PDF_PROPERTIES_DIALOG_TITLE 40200
#define IDS_PDF_PROPERTIES_FILE_NAME 40201
#define IDS_PDF_PROPERTIES_FILE_SIZE 40202
#define IDS_PDF_PROPERTIES_TITLE 40203
#define IDS_PDF_PROPERTIES_AUTHOR 40204
#define IDS_PDF_PROPERTIES_SUBJECT 40205
#define IDS_PDF_PROPERTIES_KEYWORDS 40206
#define IDS_PDF_PROPERTIES_CREATED 40207
#define IDS_PDF_PROPERTIES_MODIFIED 40208
#define IDS_PDF_PROPERTIES_APPLICATION 40209
#define IDS_PDF_PROPERTIES_PDF_PRODUCER 40210
#define IDS_PDF_PROPERTIES_PDF_VERSION 40211
#define IDS_PDF_PROPERTIES_PAGE_COUNT 40212
#define IDS_PDF_PROPERTIES_PAGE_SIZE 40213
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_INCH 40214
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_MM 40215
#define IDS_PDF_PROPERTIES_PAGE_SIZE_PORTRAIT 40216
#define IDS_PDF_PROPERTIES_PAGE_SIZE_LANDSCAPE 40217
#define IDS_PDF_PROPERTIES_PAGE_SIZE_SQUARE 40218
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VARIABLE 40219
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW 40220
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_NO 40221
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_YES 40222
#define IDS_PDF_TOOLTIP_ROTATE_CCW 40223
#define IDS_PDF_ROTATION_STATE_LABEL_0 40224
#define IDS_PDF_ROTATION_STATE_LABEL_90 40225
#define IDS_PDF_ROTATION_STATE_LABEL_180 40226
#define IDS_PDF_ROTATION_STATE_LABEL_270 40227
#define IDS_PDF_TOOLTIP_DOWNLOAD 40228
#define IDS_PDF_TOOLTIP_PRINT 40229
#define IDS_PDF_TOOLTIP_FIT_PAGE 40230
#define IDS_PDF_TOOLTIP_FIT_WIDTH 40231
#define IDS_PDF_TWO_UP_VIEW_ENABLE 40232
#define IDS_PDF_ANNOTATIONS_SHOW_TOGGLE 40233
#define IDS_PDF_ZOOM_TEXT_INPUT_ARIA_LABEL 40234
#define IDS_PDF_TOOLTIP_ZOOM_IN 40235
#define IDS_PDF_TOOLTIP_ZOOM_OUT 40236
#define IDS_PDF_TOOLTIP_THUMBNAILS 40237
#define IDS_PDF_TOOLTIP_DOCUMENT_OUTLINE 40238
#define IDS_PDF_TOOLTIP_ATTACHMENTS 40239
#define IDS_PDF_TOOLTIP_DOWNLOAD_ATTACHMENT 40240
#define IDS_PDF_LABEL_PAGE_NUMBER 40241
#define IDS_PDF_LOADING_TO_A11Y_TREE 40242
#define IDS_PDF_LOADED_TO_A11Y_TREE 40243
#define IDS_PDF_OVERSIZE_ATTACHMENT_WARNING 40244
#define IDS_PDF_PAGE_INDEX 40245
#define IDS_PDF_DOCUMENT_PAGE_COUNT 40246
#define IDS_PDF_THUMBNAIL_PAGE_ARIA_LABEL 40247
#define IDS_PDF_ANNOTATION_ANNOTATE 40248
#define IDS_PDF_ANNOTATION_UNAVAILABLE 40249
#define IDS_PDF_ANNOTATION_EDIT_IN_DEFAULT_VIEW 40250
#define IDS_PDF_ANNOTATION_RESET_ROTATE 40251
#define IDS_PDF_ANNOTATION_RESET_TWO_PAGE_VIEW 40252
#define IDS_PDF_ANNOTATION_RESET_ROTATE_AND_TWO_PAGE_VIEW 40253
#define IDS_PDF_ANNOTATION_DOCUMENT_TOO_LARGE 40254
#define IDS_PDF_ANNOTATION_DOCUMENT_PROTECTED 40255
#define IDS_PDF_ANNOTATION_DOCUMENT_ROTATED 40256
#define IDS_PDF_ANNOTATION_PEN 40257
#define IDS_PDF_ANNOTATION_HIGHLIGHTER 40258
#define IDS_PDF_ANNOTATION_ERASER 40259
#define IDS_PDF_ANNOTATION_UNDO 40260
#define IDS_PDF_ANNOTATION_REDO 40261
#define IDS_PDF_ANNOTATION_EXPAND 40262
#define IDS_PDF_ANNOTATION_COLOR_BLACK 40263
#define IDS_PDF_ANNOTATION_COLOR_RED 40264
#define IDS_PDF_ANNOTATION_COLOR_YELLOW 40265
#define IDS_PDF_ANNOTATION_COLOR_GREEN 40266
#define IDS_PDF_ANNOTATION_COLOR_CYAN 40267
#define IDS_PDF_ANNOTATION_COLOR_PURPLE 40268
#define IDS_PDF_ANNOTATION_COLOR_BROWN 40269
#define IDS_PDF_ANNOTATION_COLOR_WHITE 40270
#define IDS_PDF_ANNOTATION_COLOR_CRIMSON 40271
#define IDS_PDF_ANNOTATION_COLOR_AMBER 40272
#define IDS_PDF_ANNOTATION_COLOR_AVOCADO_GREEN 40273
#define IDS_PDF_ANNOTATION_COLOR_COBALT_BLUE 40274
#define IDS_PDF_ANNOTATION_COLOR_DEEP_PURPLE 40275
#define IDS_PDF_ANNOTATION_COLOR_DARK_BROWN 40276
#define IDS_PDF_ANNOTATION_COLOR_DARK_GREY 40277
#define IDS_PDF_ANNOTATION_COLOR_HOT_PINK 40278
#define IDS_PDF_ANNOTATION_COLOR_ORANGE 40279
#define IDS_PDF_ANNOTATION_COLOR_LIME 40280
#define IDS_PDF_ANNOTATION_COLOR_BLUE 40281
#define IDS_PDF_ANNOTATION_COLOR_VIOLET 40282
#define IDS_PDF_ANNOTATION_COLOR_TEAL 40283
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_GREY 40284
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_PINK 40285
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_ORANGE 40286
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_GREEN 40287
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_BLUE 40288
#define IDS_PDF_ANNOTATION_COLOR_LAVENDER 40289
#define IDS_PDF_ANNOTATION_COLOR_LIGHT_TEAL 40290
#define IDS_PDF_ANNOTATION_SIZE1 40291
#define IDS_PDF_ANNOTATION_SIZE2 40292
#define IDS_PDF_ANNOTATION_SIZE3 40293
#define IDS_PDF_ANNOTATION_SIZE4 40294
#define IDS_PDF_ANNOTATION_SIZE8 40295
#define IDS_PDF_ANNOTATION_SIZE12 40296
#define IDS_PDF_ANNOTATION_SIZE16 40297
#define IDS_PDF_ANNOTATION_SIZE20 40298
#define IDS_PDF_INK2_DRAW 40299
#define IDS_PDF_INK2_ANNOTATION_SIZE 40300
#define IDS_PDF_INK2_ANNOTATION_COLOR 40301
#define IDS_PDF_INK2_ANNOTATION_SIZE_EXTRA_THIN 40302
#define IDS_PDF_INK2_ANNOTATION_SIZE_THIN 40303
#define IDS_PDF_INK2_ANNOTATION_SIZE_MEDIUM 40304
#define IDS_PDF_INK2_ANNOTATION_SIZE_THICK 40305
#define IDS_PDF_INK2_ANNOTATION_SIZE_EXTRA_THICK 40306
#define IDS_PDF_INK2_ANNOTATION_COLOR_LIGHT_RED 40307
#define IDS_PDF_INK2_ANNOTATION_COLOR_LIGHT_YELLOW 40308
#define IDS_PDF_INK2_ANNOTATION_COLOR_DARK_GREY_1 40309
#define IDS_PDF_INK2_ANNOTATION_COLOR_DARK_GREY_2 40310
#define IDS_PDF_INK2_ANNOTATION_COLOR_RED_1 40311
#define IDS_PDF_INK2_ANNOTATION_COLOR_YELLOW_1 40312
#define IDS_PDF_INK2_ANNOTATION_COLOR_GREEN_1 40313
#define IDS_PDF_INK2_ANNOTATION_COLOR_BLUE_1 40314
#define IDS_PDF_INK2_ANNOTATION_COLOR_TAN_1 40315
#define IDS_PDF_INK2_ANNOTATION_COLOR_RED_2 40316
#define IDS_PDF_INK2_ANNOTATION_COLOR_YELLOW_2 40317
#define IDS_PDF_INK2_ANNOTATION_COLOR_GREEN_2 40318
#define IDS_PDF_INK2_ANNOTATION_COLOR_BLUE_2 40319
#define IDS_PDF_INK2_ANNOTATION_COLOR_TAN_2 40320
#define IDS_PDF_INK2_ANNOTATION_COLOR_RED_3 40321
#define IDS_PDF_INK2_ANNOTATION_COLOR_YELLOW_3 40322
#define IDS_PDF_INK2_ANNOTATION_COLOR_GREEN_3 40323
#define IDS_PDF_INK2_ANNOTATION_COLOR_BLUE_3 40324
#define IDS_PDF_INK2_ANNOTATION_COLOR_TAN_3 40325
#define IDS_AX_ROLE_DESCRIPTION_PDF_HIGHLIGHT 40326
#define IDS_AX_ROLE_DESCRIPTION_PDF_POPUP_NOTE 40327
#define IDS_PDF_OCR_FEATURE_ALERT 40328
#define IDS_PDF_OCR_IN_PROGRESS 40329
#define IDS_PDF_OCR_IN_PROGRESS_AX_UNLABELED_IMAGE 40330
#define IDS_PDF_OCR_COMPLETED 40331
#define IDS_PDF_OCR_NO_RESULT 40332
#define IDS_PDF_OCR_POSTAMBLE_PAGE 40333
#define IDS_PDF_SEARCHIFY_IN_PROGRESS 40334
#define IDS_GEOLOCATION_INFOBAR_TEXT 40335
#define IDS_PROTECTED_MEDIA_IDENTIFIER_PERMISSION_FRAGMENT 40364
#define IDS_PROTECTED_MEDIA_IDENTIFIER_PER_ORIGIN_PROVISIONING_INFOBAR_TEXT 40365
#define IDS_GEOLOCATION_INFOBAR_PERMISSION_FRAGMENT 40366
#define IDS_NOTIFICATION_PERMISSIONS_FRAGMENT 40367
#define IDS_MIDI_SYSEX_PERMISSION_FRAGMENT 40368
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT 40369
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT_WITH_COUNT 40370
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT 40371
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT_WITH_COUNT 40372
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT 40373
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT_WITH_COUNT 40374
#define IDS_ACCESSIBILITY_EVENTS_PERMISSION_FRAGMENT 40375
#define IDS_CLIPBOARD_PERMISSION_FRAGMENT 40376
#define IDS_VR_PERMISSION_FRAGMENT 40377
#define IDS_AR_PERMISSION_FRAGMENT 40378
#define IDS_HAND_TRACKING_PERMISSION_FRAGMENT 40379
#define IDS_KEYBOARD_LOCK_PERMISSIONS_FRAGMENT 40380
#define IDS_POINTER_LOCK_PERMISSIONS_FRAGMENT 40381
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_PROMPT_TITLE 40382
#define IDS_STORAGE_ACCESS_PERMISSION_FRAGMENT 40383
#define IDS_STORAGE_ACCESS_PERMISSION_EXPLANATION 40384
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_EXPLANATION 40385
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_LINK 40386
#define IDS_WINDOW_MANAGEMENT_PERMISSION_FRAGMENT 40387
#define IDS_FONT_ACCESS_PERMISSION_FRAGMENT 40388
#define IDS_IDLE_DETECTION_PERMISSION_FRAGMENT 40389
#define IDS_IDENTITY_PROVIDER_PERMISSION_FRAGMENT 40390
#define IDS_MULTI_DOWNLOAD_PERMISSION_FRAGMENT 40391
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_FRAGMENT 40392
#define IDS_WEB_APP_INSTALLATION_PERMISSION_FRAGMENT 40393
#define IDS_PERMISSION_ALLOW 40394
#define IDS_PERMISSION_DENY 40395
#define IDS_PERMISSION_ALLOW_THIS_TIME 40396
#define IDS_PERMISSION_ALLOW_EVERY_VISIT 40397
#define IDS_PERMISSION_ALLOW_WHILE_VISITING 40398
#define IDS_PERMISSION_DONT_ALLOW 40399
#define IDS_PERMISSION_NEVER_ALLOW 40400
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PROMPT 40401
#define IDS_BLUETOOTH_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 40402
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PAIR_BUTTON_TEXT 40403
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL 40404
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL_TOOLTIP 40405
#define IDS_BLUETOOTH_DEVICE_CHOOSER_ADAPTER_OFF 40406
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 40407
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 40408
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_WITH_ID 40409
#define IDS_BLUETOOTH_SCANNING_PROMPT 40410
#define IDS_BLUETOOTH_SCANNING_DEVICE_UNKNOWN 40411
#define IDS_BLUETOOTH_SCANNING_PROMPT_NO_DEVICES_FOUND_PROMPT 40412
#define IDS_BLUETOOTH_SCANNING_PROMPT_ALLOW_BUTTON_TEXT 40413
#define IDS_BLUETOOTH_SCANNING_PROMPT_BLOCK_BUTTON_TEXT 40414
#define IDS_DEVICE_CHOOSER_CANCEL_BUTTON_TEXT 40415
#define IDS_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 40416
#define IDS_USB_DEVICE_CHOOSER_PROMPT 40417
#define IDS_USB_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 40418
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL 40419
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL_TOOLTIP 40420
#define IDS_PRIVATE_NETWORK_DEVICE_CHOOSER_PROMPT_ORIGIN 40421
#define IDS_PRIVATE_NETWORK_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 40422
#define IDS_GEOLOCATION_PERMISSION_CHIP 40423
#define IDS_NOTIFICATION_PERMISSIONS_CHIP 40424
#define IDS_MIDI_SYSEX_PERMISSION_CHIP 40425
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_CHIP 40426
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_CHIP 40427
#define IDS_MEDIA_CAPTURE_VIDEO_AND_AUDIO_PERMISSION_CHIP 40428
#define IDS_CLIPBOARD_PERMISSION_CHIP 40429
#define IDS_SAA_PERMISSION_CHIP 40430
#define IDS_VR_PERMISSION_CHIP 40431
#define IDS_AR_PERMISSION_CHIP 40432
#define IDS_IDLE_DETECTION_PERMISSION_CHIP 40433
#define IDS_KEYBOARD_LOCK_PERMISSION_CHIP 40434
#define IDS_KEYBOARD_AND_POINTER_LOCK_PERMISSION_CHIP 40435
#define IDS_POINTER_LOCK_PERMISSION_CHIP 40436
#define IDS_WEB_APP_INSTALLATION_PERMISSION_CHIP 40437
#define IDS_HAND_TRACKING_PERMISSION_CHIP 40438
#define IDS_HAND_TRACKING_PERMISSION_BLOCKED_CHIP 40439
#define IDS_PERMISSIONS_HAND_TRACKING_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40440
#define IDS_PERMISSIONS_HAND_TRACKING_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40441
#define IDS_PERMISSIONS_HAND_TRACKING_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40442
#define IDS_GEOLOCATION_PERMISSION_BLOCKED_CHIP 40443
#define IDS_NOTIFICATION_PERMISSIONS_BLOCKED_CHIP 40444
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_CHIP 40445
#define IDS_CAPTURED_SURFACE_CONTROL_PERMISSION_BLOCKED_CHIP 40446
#define IDS_PERMISSIONS_CAPTURED_SURFACE_CONTROL_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40447
#define IDS_PERMISSIONS_CAPTURED_SURFACE_CONTROL_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40448
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_CONFIRMATION 40449
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_ONCE_CONFIRMATION 40450
#define IDS_PERMISSIONS_PERMISSION_NOT_ALLOWED_CONFIRMATION 40451
#define IDS_PERMISSIONS_NOTIFICATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40452
#define IDS_PERMISSIONS_NOTIFICATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40453
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40454
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40455
#define IDS_PERMISSIONS_GEOLOCATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40456
#define IDS_PERMISSIONS_CAMERA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40457
#define IDS_PERMISSIONS_CAMERA_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40458
#define IDS_PERMISSIONS_CAMERA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40459
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40460
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40461
#define IDS_PERMISSIONS_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40462
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40463
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40464
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40465
#define IDS_PERMISSIONS_SAA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40466
#define IDS_PERMISSIONS_SAA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40467
#define IDS_PERMISSIONS_KEYBOARD_LOCK_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40468
#define IDS_PERMISSIONS_KEYBOARD_LOCK_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40469
#define IDS_PERMISSIONS_POINTER_LOCK_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40470
#define IDS_PERMISSIONS_POINTER_LOCK_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40471
#define IDS_PERMISSIONS_WEB_INSTALL_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40472
#define IDS_PERMISSIONS_WEB_INSTALL_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 40473
#define IDS_REQUEST_QUOTA_INFOBAR_TEXT 40477
#define IDS_REQUEST_LARGE_QUOTA_INFOBAR_TEXT 40478
#define IDS_REQUEST_QUOTA_PERMISSION_FRAGMENT 40479
#define IDS_EMBEDDED_PROMPT_ADMIN_BLOCKED 40480
#define IDS_EMBEDDED_PROMPT_ADMIN_ALLOWED 40481
#define IDS_EMBEDDED_PROMPT_PREVIOUSLY_ALLOWED 40482
#define IDS_EMBEDDED_PROMPT_PREVIOUSLY_NOT_ALLOWED 40483
#define IDS_PERMISSION_OFF_FOR_CHROME 40484
#define IDS_PERMISSION_CHROME_NEEDS_PERMISSION 40485
#define IDS_GEOLOCATION_NAME_FRAGMENT 40486
#define IDS_CAMERA_PERMISSION_NAME_FRAGMENT 40487
#define IDS_MICROPHONE_PERMISSION_NAME_FRAGMENT 40488
#define IDS_CAMERA_AND_MICROPHONE_PERMISSION_NAME_FRAGMENT 40489
#define IDS_MACOS_NAME_FRAGMENT 40490
#define IDS_WINDOWS_NAME_FRAGMENT 40491
#define IDS_CHROMEOS_NAME_FRAGMENT 40492
#define IDS_EMBEDDED_PROMPT_OK_LABEL 40494
#define IDS_EMBEDDED_PROMPT_CONTINUE_ALLOWING 40495
#define IDS_EMBEDDED_PROMPT_STOP_ALLOWING 40496
#define IDS_EMBEDDED_PROMPT_OPEN_SYSTEM_SETTINGS 40498
#define IDS_EMBEDDED_PROMPT_CONTINUE_NOT_ALLOWING 40499
#define IDS_PERMISSION_PROMPT_SURVEY_CUSTOM_INVITATION 40500
#define IDS_POLICY_DM_STATUS_SUCCESS 40501
#define IDS_POLICY_DM_STATUS_REQUEST_INVALID 40502
#define IDS_POLICY_DM_STATUS_REQUEST_FAILED 40503
#define IDS_POLICY_DM_STATUS_TEMPORARY_UNAVAILABLE 40504
#define IDS_POLICY_DM_STATUS_HTTP_STATUS_ERROR 40505
#define IDS_POLICY_DM_STATUS_RESPONSE_DECODING_ERROR 40506
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_NOT_SUPPORTED 40507
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NOT_FOUND 40508
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_TOKEN_INVALID 40509
#define IDS_POLICY_DM_STATUS_SERVICE_ACTIVATION_PENDING 40510
#define IDS_POLICY_DM_STATUS_SERVICE_INVALID_SERIAL_NUMBER 40511
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_ID_CONFLICT 40512
#define IDS_POLICY_DM_STATUS_SERVICE_MISSING_LICENSES 40513
#define IDS_POLICY_DM_STATUS_SERVICE_DEPROVISIONED 40514
#define IDS_POLICY_DM_STATUS_SERVICE_POLICY_NOT_FOUND 40515
#define IDS_POLICY_DM_STATUS_UNKNOWN_ERROR 40516
#define IDS_POLICY_DM_STATUS_INVALID_PACKAGED_DEVICE_FOR_KIOSK 40517
#define IDS_POLICY_DM_STATUS_ORG_UNIT_ENROLLMENT_LIMIT_EXCEEDED 40518
#define IDS_POLICY_DM_STATUS_SERVICE_DOMAIN_MISMATCH 40519
#define IDS_POLICY_DM_STATUS_CANNOT_SIGN_REQUEST 40520
#define IDS_POLICY_DM_STATUS_REQUEST_TOO_LARGE 40521
#define IDS_POLICY_DM_STATUS_SERVICE_TOO_MANY_REQUESTS 40522
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NEEDS_RESET 40523
#define IDS_POLICY_DM_STATUS_CONSUMER_ACCOUNT_WITH_PACKAGED_LICENSE 40524
#define IDS_POLICY_DM_STATUS_ENTERPRISE_ACCOUNT_IS_NOT_ELIGIBLE_TO_ENROLL 40525
#define IDS_POLICY_ACTION_BLOCKED_BY_ORGANIZATION 40526
#define IDS_POLICY_VALIDATION_OK 40527
#define IDS_POLICY_VALIDATION_BAD_INITIAL_SIGNATURE 40528
#define IDS_POLICY_VALIDATION_BAD_SIGNATURE 40529
#define IDS_POLICY_VALIDATION_ERROR_CODE_PRESENT 40530
#define IDS_POLICY_VALIDATION_PAYLOAD_PARSE_ERROR 40531
#define IDS_POLICY_VALIDATION_WRONG_POLICY_TYPE 40532
#define IDS_POLICY_VALIDATION_WRONG_SETTINGS_ENTITY_ID 40533
#define IDS_POLICY_VALIDATION_BAD_TIMESTAMP 40534
#define IDS_POLICY_VALIDATION_BAD_DM_TOKEN 40535
#define IDS_POLICY_VALIDATION_BAD_DEVICE_ID 40536
#define IDS_POLICY_VALIDATION_BAD_USER 40537
#define IDS_POLICY_VALIDATION_POLICY_PARSE_ERROR 40538
#define IDS_POLICY_VALIDATION_BAD_KEY_VERIFICATION_SIGNATURE 40539
#define IDS_POLICY_VALIDATION_VALUE_WARNING 40540
#define IDS_POLICY_VALIDATION_VALUE_ERROR 40541
#define IDS_POLICY_VALIDATION_UNKNOWN_ERROR 40542
#define IDS_POLICY_STORE_STATUS_OK 40543
#define IDS_POLICY_STORE_STATUS_LOAD_ERROR 40544
#define IDS_POLICY_STORE_STATUS_STORE_ERROR 40545
#define IDS_POLICY_STORE_STATUS_PARSE_ERROR 40546
#define IDS_POLICY_STORE_STATUS_SERIALIZE_ERROR 40547
#define IDS_POLICY_STORE_STATUS_VALIDATION_ERROR 40548
#define IDS_POLICY_STORE_STATUS_BAD_STATE 40549
#define IDS_POLICY_STORE_STATUS_UNKNOWN_ERROR 40550
#define IDS_POLICY_ASSOCIATION_STATE_ACTIVE 40551
#define IDS_POLICY_ASSOCIATION_STATE_UNMANAGED 40552
#define IDS_POLICY_ASSOCIATION_STATE_DEPROVISIONED 40553
#define IDS_POLICY_TYPE_ERROR 40554
#define IDS_POLICY_OUT_OF_RANGE_ERROR 40555
#define IDS_POLICY_VALUE_FORMAT_ERROR 40556
#define IDS_POLICY_INVALID_FILE_EXTENSION_ERROR 40557
#define IDS_POLICY_INVALID_HASH_ERROR 40558
#define IDS_POLICY_INVALID_SELECTION_ERROR 40559
#define IDS_POLICY_PAPER_SIZE_CUSTOM_NO_SIZE_ERROR 40560
#define IDS_POLICY_PAPER_SIZE_NOT_CUSTOM_ERROR 40561
#define IDS_POLICY_INVALID_ACCOUNT_PATTERN_FORMAT_ERROR 40562
#define IDS_POLICY_INVALID_PROTOCOL_ERROR 40563
#define IDS_POLICY_INVALID_ORIGIN_ERROR 40564
#define IDS_POLICY_EMPTY_ORIGIN_LIST_ERROR 40565
#define IDS_POLICY_INVALID_EXTENSION_ID_ERROR 40567
#define IDS_POLICY_INVALID_UPDATE_URL_ERROR 40568
#define IDS_POLICY_URL_PATH_SPECIFIED_ERROR 40569
#define IDS_POLICY_MISSING_VENDOR_ID_ERROR 40570
#define IDS_POLICY_INVALID_NUMBER_OF_URLS_ERROR 40571
#define IDS_POLICY_BRUSCHETTA_UNINSTALLABLE_ERROR 40572
#define IDS_POLICY_CLOUD_SOURCE_ONLY_ERROR 40573
#define IDS_POLICY_CLOUD_USER_ONLY_ERROR 40574
#define IDS_POLICY_CLOUD_MANAGEMENT_ENROLLMENT_ONLY_ERROR 40575
#define IDS_POLICY_DEFAULT_SEARCH_DISABLED 40576
#define IDS_POLICY_NOT_SPECIFIED_ERROR 40577
#define IDS_POLICY_EXTENSION_SETTINGS_ORIGIN_LIMIT_WARNING 40578
#define IDS_POLICY_URL_ALLOW_BLOCK_LIST_MAX_FILTERS_LIMIT_WARNING 40579
#define IDS_POLICY_ERROR_WITH_PATH 40580
#define IDS_POLICY_SCHEMA_VALIDATION_ERROR 40581
#define IDS_POLICY_INVALID_JSON_ERROR 40582
#define IDS_POLICY_INVALID_URL_ERROR 40583
#define IDS_POLICY_URL_NOT_HTTPS_ERROR 40584
#define IDS_POLICY_INVALID_SEARCH_URL_ERROR 40585
#define IDS_POLICY_INVALID_SECURE_DNS_MODE_ERROR 40586
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_ERROR 40587
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_ERROR 40588
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_SIZE_ERROR 40589
#define IDS_POLICY_SECURE_DNS_TEMPLATES_IRRELEVANT_MODE_ERROR 40590
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_MODE_ERROR 40591
#define IDS_POLICY_SECURE_DNS_TEMPLATES_UNSET_MODE_ERROR 40592
#define IDS_POLICY_SECURE_DNS_TEMPLATES_NOT_SPECIFIED_ERROR 40593
#define IDS_POLICY_INVALID_PROXY_MODE_ERROR 40594
#define IDS_POLICY_OFF_CWS_URL_ERROR 40596
#define IDS_POLICY_HOMEPAGE_LOCATION_ERROR 40597
#define IDS_POLICY_PROXY_MODE_DISABLED_ERROR 40598
#define IDS_POLICY_PROXY_MODE_AUTO_DETECT_ERROR 40599
#define IDS_POLICY_PROXY_MODE_PAC_URL_ERROR 40600
#define IDS_POLICY_PROXY_MODE_FIXED_SERVERS_ERROR 40601
#define IDS_POLICY_PROXY_MODE_SYSTEM_ERROR 40602
#define IDS_POLICY_PROXY_BOTH_SPECIFIED_ERROR 40603
#define IDS_POLICY_PROXY_NEITHER_SPECIFIED_ERROR 40604
#define IDS_POLICY_DEVELOPER_TOOLS_EXTENSIONS_CONFLICT_MESSAGE 40605
#define IDS_POLICY_OVERRIDDEN 40606
#define IDS_POLICY_VALUE_DEPRECATED 40607
#define IDS_POLICY_DEPENDENCY_ERROR 40608
#define IDS_POLICY_DEPENDENCY_ERROR_ANY_VALUE 40609
#define IDS_POLICY_IDLE_TIMEOUT_ACTIONS_DEPENDENCY_ERROR 40610
#define IDS_POLICY_USER_IS_NOT_AFFILIATED_ERROR 40611
#define IDS_POLICY_LEVEL_ERROR 40616
#define IDS_POLICY_OK 40617
#define IDS_POLICY_UNSET 40618
#define IDS_POLICY_UNKNOWN 40619
#define IDS_POLICY_PROTO_PARSING_ERROR 40620
#define IDS_POLICY_HEX_COLOR_ERROR 40621
#define IDS_POLICY_SITE_SEARCH_SETTINGS_MAX_PROVIDERS_LIMIT_ERROR 40622
#define IDS_POLICY_SITE_SEARCH_SETTINGS_MAX_FEATURED_PROVIDERS_LIMIT_ERROR 40623
#define IDS_POLICY_SITE_SEARCH_SETTINGS_DUPLICATED_SHORTCUT 40624
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_CONTAINS_SPACE 40625
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_STARTS_WITH_AT 40626
#define IDS_SEARCH_POLICY_SETTINGS_NO_VALID_PROVIDER 40627
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_IS_EMPTY 40628
#define IDS_SEARCH_POLICY_SETTINGS_NAME_IS_EMPTY 40629
#define IDS_SEARCH_POLICY_SETTINGS_URL_IS_EMPTY 40630
#define IDS_SEARCH_POLICY_SETTINGS_URL_DOESNT_SUPPORT_REPLACEMENT 40631
#define IDS_SEARCH_POLICY_SETTINGS_SHORTCUT_EQUALS_DSP_KEYWORD 40632
#define IDS_POLICY_SITE_SEARCH_SETTINGS_SHORTCUT_EQUALS_SEARCH_AGGREGATOR_KEYWORD 40633
#define IDS_SEARCH_POLICY_SETTINGS_URL_NOT_HTTPS 40634
#define IDS_POLICY_DATA_CONTROLS_MUTUALLY_EXCLUSIVE_KEYS 40635
#define IDS_POLICY_DATA_CONTROLS_MUTUALLY_EXCLUSIVE_KEY_SETS 40636
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_CONDITION 40637
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_RESTRICTION 40638
#define IDS_POLICY_DATA_CONTROLS_UNSUPPORTED_LEVEL 40639
#define IDS_POLICY_TITLE 40640
#define IDS_POLICY_FILTER_PLACEHOLDER 40641
#define IDS_POLICY_RELOAD_POLICIES 40642
#define IDS_POLICY_RELOADING_POLICIES 40643
#define IDS_POLICY_RELOAD_POLICIES_DONE 40644
#define IDS_EXPORT_POLICIES_JSON 40645
#define IDS_EXPORT_POLICIES_JSON_DONE 40646
#define IDS_UPLOAD_REPORT 40647
#define IDS_REPORT_UPLOADING 40648
#define IDS_REPORT_UPLOADED 40649
#define IDS_POLICY_STATUS 40650
#define IDS_POLICY_STATUS_DEVICE 40651
#define IDS_POLICY_STATUS_USER 40652
#define IDS_POLICY_STATUS_MACHINE 40653
#define IDS_POLICY_STATUS_UPDATER 40654
#define IDS_POLICY_STATUS_ERROR_MANAGED_NO_POLICY 40655
#define IDS_POLICY_STATUS_FLEX_ORG_NO_POLICY 40656
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DOMAIN 40657
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_TOKEN 40658
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DEVICE_ID 40659
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_MACHINE_NAME 40660
#define IDS_POLICY_LABEL_USERNAME 40661
#define IDS_POLICY_LABEL_GAIA_ID 40662
#define IDS_POLICY_LABEL_CLIENT_ID 40663
#define IDS_POLICY_LABEL_PROFILE_ID 40664
#define IDS_POLICY_LABEL_ASSET_ID 40665
#define IDS_POLICY_LABEL_LOCATION 40666
#define IDS_POLICY_LABEL_DIRECTORY_API_ID 40667
#define IDS_POLICY_LABEL_MANAGED_BY 40668
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_FETCH_ATTEMPT 40669
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_REFRESH 40670
#define IDS_POLICY_LABEL_LAST_CLOUD_REPORT_SENT_TIMESTAMP 40671
#define IDS_POLICY_NOT_SPECIFIED 40672
#define IDS_POLICY_LABEL_PUSH_POLICIES 40673
#define IDS_POLICY_PUSH_POLICIES_ON 40674
#define IDS_POLICY_PUSH_POLICIES_OFF 40675
#define IDS_POLICY_NEVER_FETCHED 40676
#define IDS_POLICY_LABEL_REFRESH_INTERVAL 40677
#define IDS_POLICY_LABEL_CONFLICT 40678
#define IDS_POLICY_LABEL_SUPERSEDING 40679
#define IDS_POLICY_LABEL_CONFLICT_VALUE 40680
#define IDS_POLICY_LABEL_SUPERSEDED_VALUE 40681
#define IDS_POLICY_LABEL_ERROR 40682
#define IDS_POLICY_LABEL_DEPRECATED 40683
#define IDS_POLICY_LABEL_FUTURE 40684
#define IDS_POLICY_LABEL_IGNORED 40685
#define IDS_POLICY_LABEL_VALUE 40686
#define IDS_POLICY_LABEL_VERSION 40687
#define IDS_POLICY_LABEL_STATUS 40688
#define IDS_POLICY_LABEL_INFO 40689
#define IDS_POLICY_LABEL_PRECEDENCE 40690
#define IDS_POLICY_SHOW_UNSET 40691
#define IDS_POLICY_NO_POLICIES_SET 40692
#define IDS_POLICY_HEADER_SCOPE 40693
#define IDS_POLICY_HEADER_LEVEL 40694
#define IDS_POLICY_HEADER_NAMESPACE 40695
#define IDS_POLICY_HEADER_NAME 40696
#define IDS_POLICY_HEADER_VALUE 40697
#define IDS_POLICY_HEADER_STATUS 40698
#define IDS_POLICY_HEADER_SOURCE 40699
#define IDS_POLICY_HEADER_WARNING 40700
#define IDS_POLICY_SHOW_MORE 40701
#define IDS_POLICY_SHOW_LESS 40702
#define IDS_POLICY_LEARN_MORE 40703
#define IDS_POLICY_SCOPE_USER 40704
#define IDS_POLICY_SCOPE_ALL_USERS 40705
#define IDS_POLICY_SCOPE_DEVICE 40706
#define IDS_POLICY_LEVEL_RECOMMENDED 40707
#define IDS_POLICY_LEVEL_MANDATORY 40708
#define IDS_POLICY_SOURCE_ENTERPRISE_DEFAULT 40709
#define IDS_POLICY_SOURCE_DEFAULT 40710
#define IDS_POLICY_SOURCE_COMMAND_LINE 40711
#define IDS_POLICY_SOURCE_CLOUD 40712
#define IDS_POLICY_SOURCE_MERGED 40713
#define IDS_POLICY_SOURCE_CLOUD_FROM_ASH 40714
#define IDS_POLICY_SOURCE_RESTRICTED_MANAGED_GUEST_SESSION_OVERRIDE 40715
#define IDS_POLICY_SOURCE_ACTIVE_DIRECTORY 40716
#define IDS_POLICY_SOURCE_PLATFORM 40717
#define IDS_POLICY_SOURCE_DEVICE_LOCAL_ACCOUNT_OVERRIDE 40718
#define IDS_POLICY_RISK_TAG_FULL_ADMIN_ACCESS 40719
#define IDS_POLICY_RISK_TAG_SYSTEM_SECURITY 40720
#define IDS_POLICY_RISK_TAG_WEBSITE_SHARING 40721
#define IDS_POLICY_RISK_TAG_ADMIN_SHARING 40722
#define IDS_POLICY_RISK_TAG_FILTERING 40723
#define IDS_POLICY_RISK_TAG_LOCAL_DATA_ACCESS 40724
#define IDS_POLICY_RISK_TAG_GOOGLE_SHARING 40725
#define IDS_POLICY_SHOW_EXPANDED_STATUS 40726
#define IDS_POLICY_HIDE_EXPANDED_STATUS 40727
#define IDS_POLICY_LIST_MERGING_WRONG_POLICY_TYPE_SPECIFIED 40728
#define IDS_POLICY_DICTIONARY_MERGING_WRONG_POLICY_TYPE_SPECIFIED 40729
#define IDS_POLICY_DICTIONARY_MERGING_POLICY_NOT_ALLOWED 40730
#define IDS_POLICY_CONFLICT_SAME_VALUE 40731
#define IDS_POLICY_CONFLICT_DIFF_VALUE 40732
#define IDS_POLICY_MIGRATED_OLD_POLICY 40733
#define IDS_POLICY_MIGRATED_NEW_POLICY 40734
#define IDS_POLICY_BLOCKED 40735
#define IDS_POLICY_INVALID 40736
#define IDS_POLICY_IGNORED_BY_GROUP_MERGING 40737
#define IDS_POLICY_INVALID_VALUE 40738
#define IDS_POLICY_IGNORED_MANDATORY_REPORTING_POLICY 40739
#define IDS_POLICY_IGNORED_CHROME_PROFILE 40740
#define IDS_POLICY_IGNORED_UNAFFILIATED 40741
#define IDS_POLICY_PRECEDENCE_PLATFORM_MACHINE 40742
#define IDS_POLICY_PRECEDENCE_PLATFORM_USER 40743
#define IDS_POLICY_PRECEDENCE_CLOUD_MACHINE 40744
#define IDS_POLICY_PRECEDENCE_CLOUD_USER 40745
#define IDS_POLICY_SPELLCHECK_UNKNOWN_LANGUAGE 40746
#define IDS_POLICY_SPELLCHECK_BLOCKLIST_IGNORE 40747
#define IDS_POLICY_DEFAULT_GEO_POLICY_ARC_CONFLICT 40748
#define IDS_POLICY_LABEL_IS_AFFILIATED 40749
#define IDS_POLICY_IS_AFFILIATED_YES 40750
#define IDS_POLICY_IS_AFFILIATED_NO 40751
#define IDS_POLICY_LABEL_IS_OFFHOURS_ACTIVE 40752
#define IDS_POLICY_OFFHOURS_ACTIVE 40753
#define IDS_POLICY_OFFHOURS_NOT_ACTIVE 40754
#define IDS_POLICY_SIGNIN_PROFILE 40755
#define IDS_POLICY_COPY_VALUE 40756
#define IDS_COPY_POLICIES_JSON 40757
#define IDS_COPY_POLICIES_DONE 40758
#define IDS_VIEW_POLICY_LOGS 40759
#define IDS_POLICY_MORE_ACTIONS 40760
#define IDS_POLICY_TABLE_COLUMN_SORT 40761
#define IDS_POLICY_TABLE_COLUMN_SORT_ASCENDING 40762
#define IDS_POLICY_TABLE_COLUMN_SORT_DESCENDING 40763
#define IDS_POLICY_BANNER_PROMOTION_TITLE 40764
#define IDS_POLICY_BANNER_PROMOTION_DESC 40765
#define IDS_POLICY_BANNER_PROMOTION_BTN 40766
#define IDS_POLICY_LOGS_TITLE 40767
#define IDS_VERSION_INFO 40768
#define IDS_EXPORT_POLICY_LOGS_JSON 40769
#define IDS_REFRESH_POLICY_LOGS 40770
#define IDS_POLICY_TEST_TITLE 40771
#define IDS_POLICY_TEST_RESTART_AND_APPLY 40772
#define IDS_POLICY_TEST_APPLY 40773
#define IDS_POLICY_TEST_IMPORT 40774
#define IDS_POLICY_TEST_DESC 40775
#define IDS_POLICY_TEST_REVERT 40776
#define IDS_POLICY_TEST_TABLE_SCOPE 40777
#define IDS_POLICY_TEST_ADD 40778
#define IDS_POLICY_SELECT_NAME 40779
#define IDS_POLICY_TEST_TABLE_PRESET 40780
#define IDS_LOCAL_TEST_POLICIES_ENABLED 40781
#define IDS_POLICY_TEST_PRESET_CUSTOM 40782
#define IDS_POLICY_TEST_PRESET_LOCAL_MACHINE 40783
#define IDS_POLICY_TEST_PRESET_CLOUD_ACCOUNT 40784
#define IDS_POLICY_TEST_USER_AFFILIATED 40785
#define IDS_CHROME_URLS_DISABLED_PAGE_HEADER 40786
#define IDS_CHROME_URLS_DISABLED_PAGE_TITLE 40787
#define IDS_CHROME_URLS_DISABLED_PAGE_MESSAGE 40788
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_PASTE 40789
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_COPY_VM 40790
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_TOAST_BUTTON 40791
#define IDS_POLICY_DLP_ANDROID_APPS 40792
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_DISMISS_BUTTON 40793
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_PASTE 40794
#define IDS_POLICY_DLP_CLIPBOARD_WARN_PROCEED_BUTTON 40795
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_COPY_VM 40796
#define IDS_POLICY_DLP_PRINTING_BLOCKED_TITLE 40797
#define IDS_POLICY_DLP_PRINTING_BLOCKED_MESSAGE 40798
#define IDS_POLICY_DLP_PRINTING_WARN_TITLE 40799
#define IDS_POLICY_DLP_PRINTING_WARN_MESSAGE 40800
#define IDS_POLICY_DLP_PRINTING_WARN_CONTINUE_BUTTON 40801
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_TITLE 40802
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_MESSAGE 40803
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_TITLE 40804
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_MESSAGE 40805
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_TITLE 40806
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_MESSAGE 40807
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_TITLE 40808
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_MESSAGE 40809
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_TITLE 40810
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_MESSAGE 40811
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_TITLE 40812
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_MESSAGE 40813
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_CONTINUE_BUTTON 40814
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_TITLE 40815
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_MESSAGE 40816
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_CONTINUE_BUTTON 40817
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_TITLE 40818
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_MESSAGE 40819
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CONTINUE_BUTTON 40820
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CANCEL_BUTTON 40821
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_TITLE 40822
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_TITLE 40823
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_TITLE 40824
#define IDS_POLICY_DLP_FILES_MOVE_WARN_TITLE 40825
#define IDS_POLICY_DLP_FILES_COPY_WARN_TITLE 40826
#define IDS_POLICY_DLP_FILES_OPEN_WARN_TITLE 40827
#define IDS_POLICY_DLP_FILES_DOWNLOAD_REVIEW_TITLE 40828
#define IDS_POLICY_DLP_FILES_TRANSFER_REVIEW_TITLE 40829
#define IDS_POLICY_DLP_FILES_UPLOAD_REVIEW_TITLE 40830
#define IDS_POLICY_DLP_FILES_MOVE_REVIEW_TITLE 40831
#define IDS_POLICY_DLP_FILES_COPY_REVIEW_TITLE 40832
#define IDS_POLICY_DLP_FILES_OPEN_REVIEW_TITLE 40833
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_MESSAGE 40834
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_MESSAGE 40835
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_MESSAGE 40836
#define IDS_POLICY_DLP_FILES_MOVE_WARN_MESSAGE 40837
#define IDS_POLICY_DLP_FILES_COPY_WARN_MESSAGE 40838
#define IDS_POLICY_DLP_FILES_OPEN_WARN_MESSAGE 40839
#define IDS_POLICY_DLP_FILES_WARN_MESSAGE 40840
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_CONTINUE_BUTTON 40841
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_CONTINUE_BUTTON 40842
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_CONTINUE_BUTTON 40843
#define IDS_POLICY_DLP_FILES_MOVE_WARN_CONTINUE_BUTTON 40844
#define IDS_POLICY_DLP_FILES_COPY_WARN_CONTINUE_BUTTON 40845
#define IDS_POLICY_DLP_FILES_OPEN_WARN_CONTINUE_BUTTON 40846
#define IDS_POLICY_DLP_FILES_DESTINATION_REMOVABLE_STORAGE 40847
#define IDS_POLICY_DLP_FILES_REVIEW_BUTTON 40848
#define IDS_POLICY_DLP_FILES_DISMISS_BUTTON 40849
#define IDS_POLICY_DLP_FILES_OK_BUTTON 40850
#define IDS_POLICY_DLP_WARN_CANCEL_BUTTON 40851
#define IDS_POLICY_DLP_CLIPBOARD_BUBBLE_MESSAGE 40852
#define IDS_POLICY_DLP_FROM_YOUR_ADMIN_MESSAGE 40853
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_TITLE 40854
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_MESSAGE 40855
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_TITLE 40856
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_MESSAGE 40857
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_TITLE 40858
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_MESSAGE 40859
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCKED_TITLE 40860
#define IDS_POLICY_DLP_FILES_TRANSFER_BLOCKED_TITLE 40861
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCKED_TITLE 40862
#define IDS_POLICY_DLP_FILES_MOVE_BLOCKED_TITLE 40863
#define IDS_POLICY_DLP_FILES_COPY_BLOCKED_TITLE 40864
#define IDS_POLICY_DLP_FILES_OPEN_BLOCKED_TITLE 40865
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_SINGLE_FILE_MESSAGE 40866
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_MESSAGE 40867
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_SINGLE_FILE_MESSAGE 40868
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_MESSAGE 40869
#define IDS_POLICY_DLP_FILES_BLOCK_MESSAGE 40870
#define IDS_POLICY_DLP_FILES_DOWNLOAD_JUSTIFICATION_LABEL 40871
#define IDS_POLICY_DLP_FILES_UPLOAD_JUSTIFICATION_LABEL 40872
#define IDS_POLICY_DLP_FILES_COPY_JUSTIFICATION_LABEL 40873
#define IDS_POLICY_DLP_FILES_MOVE_JUSTIFICATION_LABEL 40874
#define IDS_POLICY_DLP_FILES_OPEN_JUSTIFICATION_LABEL 40875
#define IDS_POLICY_DLP_FILES_TRANSFER_JUSTIFICATION_LABEL 40876
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_TITLE 40877
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_TITLE 40878
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_TITLE 40879
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_TITLE 40880
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_TITLE 40881
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_TITLE 40882
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_MESSAGE 40883
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_MESSAGE 40884
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_MESSAGE 40885
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_MESSAGE 40886
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_MESSAGE 40887
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_MESSAGE 40888
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_DATA_CONTROLS_ACCESSIBLE_NAME 40889
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_MALWARE_PROTECTION_ACCESSIBLE_NAME 40890
#define IDS_POLICY_DLP_FILES_LEARN_MORE_ABOUT_SENSITIVE_DATA_PROTECTION_ACCESSIBLE_NAME 40891
#define IDS_POLICY_DLP_FILES_JUSTIFICATION_TEXTAREA_ACCESSIBLE_DESCRIPTION 40892
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_TITLE 40893
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_MESSAGE 40894
#define IDS_POLICY_REBOOT_BUTTON 40895
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_DIALOG_MESSAGE 40896
#define IDS_REBOOT_SCHEDULED_TITLE_MINUTES 40897
#define IDS_REBOOT_SCHEDULED_TITLE_SECONDS 40898
#define IDS_POLICY_DEVICE_POST_REBOOT_TITLE 40899
#define IDS_POLICY_BROWSING_DATA_DEPENDENCY_APPLIED_INFO 40900
#define IDS_POLICY_NOT_SUPPORTED_AS_USER_POLICY_ON_IOS 40901
#define IDS_POLICY_GEN_AI_DEFAULT_SETTINGS_CONTROL_MESSAGE 40902
#define IDS_POLICY_GEN_AI_DEFAULT_SETTINGS_NO_CONTROL_MESSAGE 40903
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_TITLE 40904
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_BUTTON 40905
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_CANCEL_BUTTON 40906
#define IDS_POLICY_SKYVAULT_DOWNLOAD_SIGN_IN_DISPLAY_SOURCE 40907
#define IDS_POLICY_SKYVAULT_MIGRATION_BANNER 40908
#define IDS_POLICY_SKYVAULT_MISCONFIGURED_POLICY_MESSAGE 40909
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_UPLOAD_TITLE 40910
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_RECORDING_UPLOAD_TITLE 40911
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_UPLOAD_ONEDRIVE_MESSAGE 40912
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_UPLOAD_CANCEL_BUTTON 40913
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_SIGN_IN_TITLE 40914
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_SIGN_IN_BUTTON 40915
#define IDS_POLICY_SKYVAULT_SCREENCAPTURE_SIGN_IN_CANCEL_BUTTON 40916
#define IDS_POLICY_SKYVAULT_CLOUD_PROVIDER_GOOGLE_DRIVE 40917
#define IDS_POLICY_SKYVAULT_CLOUD_PROVIDER_ONEDRIVE 40918
#define IDS_POLICY_SKYVAULT_MIGRATION_PROGRESS_TITLE 40919
#define IDS_POLICY_SKYVAULT_MIGRATION_PROGRESS_MESSAGE 40920
#define IDS_POLICY_SKYVAULT_MIGRATION_COMPLETED_TITLE 40921
#define IDS_POLICY_SKYVAULT_MIGRATION_COMPLETED_MESSAGE 40922
#define IDS_POLICY_SKYVAULT_MIGRATION_COMPLETED_BUTTON 40923
#define IDS_POLICY_SKYVAULT_MIGRATION_CONFIG_ERROR_TITLE 40924
#define IDS_POLICY_SKYVAULT_MIGRATION_CONFIG_ERROR_MESSAGE 40925
#define IDS_POLICY_SKYVAULT_MIGRATION_ERROR_TITLE 40926
#define IDS_POLICY_SKYVAULT_MIGRATION_ERROR_MESSAGE 40927
#define IDS_POLICY_SKYVAULT_MIGRATION_ERROR_BUTTON 40928
#define IDS_POLICY_SKYVAULT_MIGRATION_SIGN_IN_TITLE 40929
#define IDS_POLICY_SKYVAULT_MIGRATION_SIGN_IN_MESSAGE 40930
#define IDS_POLICY_SKYVAULT_MIGRATION_SIGN_IN_BUTTON 40931
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_HOURS 40932
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_HOUR 40933
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_MINUTES 40934
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_TITLE_MINUTE 40935
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_START_MESSAGE 40936
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_DONE_MESSAGE 40937
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_NOW_BUTTON 40938
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_IN_HOURS_BUTTON 40939
#define IDS_POLICY_SKYVAULT_MIGRATION_DIALOG_UPLOAD_IN_MINUTES_BUTTON 40940
#define PRINT_PREVIEW_MEDIA_ASME_F_28X40IN 40941
#define PRINT_PREVIEW_MEDIA_ISO_2A0_1189X1682MM 40942
#define PRINT_PREVIEW_MEDIA_ISO_A0_841X1189MM 40943
#define PRINT_PREVIEW_MEDIA_ISO_A0X3_1189X2523MM 40944
#define PRINT_PREVIEW_MEDIA_ISO_A10_26X37MM 40945
#define PRINT_PREVIEW_MEDIA_ISO_A1_594X841MM 40946
#define PRINT_PREVIEW_MEDIA_ISO_A1X3_841X1783MM 40947
#define PRINT_PREVIEW_MEDIA_ISO_A1X4_841X2378MM 40948
#define PRINT_PREVIEW_MEDIA_ISO_A2_420X594MM 40949
#define PRINT_PREVIEW_MEDIA_ISO_A2X3_594X1261MM 40950
#define PRINT_PREVIEW_MEDIA_ISO_A2X4_594X1682MM 40951
#define PRINT_PREVIEW_MEDIA_ISO_A2X5_594X2102MM 40952
#define PRINT_PREVIEW_MEDIA_ISO_A3_297X420MM 40953
#define PRINT_PREVIEW_MEDIA_ISO_A3_EXTRA_322X445MM 40954
#define PRINT_PREVIEW_MEDIA_ISO_A3X3_420X891MM 40955
#define PRINT_PREVIEW_MEDIA_ISO_A3X4_420X1189MM 40956
#define PRINT_PREVIEW_MEDIA_ISO_A3X5_420X1486MM 40957
#define PRINT_PREVIEW_MEDIA_ISO_A3X6_420X1783MM 40958
#define PRINT_PREVIEW_MEDIA_ISO_A3X7_420X2080MM 40959
#define PRINT_PREVIEW_MEDIA_ISO_A4_210X297MM 40960
#define PRINT_PREVIEW_MEDIA_ISO_A4_EXTRA_235_5X322_3MM 40961
#define PRINT_PREVIEW_MEDIA_ISO_A4_TAB_225X297MM 40962
#define PRINT_PREVIEW_MEDIA_ISO_A4X3_297X630MM 40963
#define PRINT_PREVIEW_MEDIA_ISO_A4X4_297X841MM 40964
#define PRINT_PREVIEW_MEDIA_ISO_A4X5_297X1051MM 40965
#define PRINT_PREVIEW_MEDIA_ISO_A4X6_297X1261MM 40966
#define PRINT_PREVIEW_MEDIA_ISO_A4X7_297X1471MM 40967
#define PRINT_PREVIEW_MEDIA_ISO_A4X8_297X1682MM 40968
#define PRINT_PREVIEW_MEDIA_ISO_A4X9_297X1892MM 40969
#define PRINT_PREVIEW_MEDIA_ISO_A5_148X210MM 40970
#define PRINT_PREVIEW_MEDIA_ISO_A5_EXTRA_174X235MM 40971
#define PRINT_PREVIEW_MEDIA_ISO_A6_105X148MM 40972
#define PRINT_PREVIEW_MEDIA_ISO_A7_74X105MM 40973
#define PRINT_PREVIEW_MEDIA_ISO_A8_52X74MM 40974
#define PRINT_PREVIEW_MEDIA_ISO_A9_37X52MM 40975
#define PRINT_PREVIEW_MEDIA_ISO_B0_1000X1414MM 40976
#define PRINT_PREVIEW_MEDIA_ISO_B10_31X44MM 40977
#define PRINT_PREVIEW_MEDIA_ISO_B1_707X1000MM 40978
#define PRINT_PREVIEW_MEDIA_ISO_B2_500X707MM 40979
#define PRINT_PREVIEW_MEDIA_ISO_B3_353X500MM 40980
#define PRINT_PREVIEW_MEDIA_ISO_B4_250X353MM 40981
#define PRINT_PREVIEW_MEDIA_ISO_B5_176X250MM 40982
#define PRINT_PREVIEW_MEDIA_ISO_B5_EXTRA_201X276MM 40983
#define PRINT_PREVIEW_MEDIA_ISO_B6C4_125X324MM 40984
#define PRINT_PREVIEW_MEDIA_ISO_B6_125X176MM 40985
#define PRINT_PREVIEW_MEDIA_ISO_B7_88X125MM 40986
#define PRINT_PREVIEW_MEDIA_ISO_B8_62X88MM 40987
#define PRINT_PREVIEW_MEDIA_ISO_B9_44X62MM 40988
#define PRINT_PREVIEW_MEDIA_ISO_C0_917X1297MM 40989
#define PRINT_PREVIEW_MEDIA_ISO_C10_28X40MM 40990
#define PRINT_PREVIEW_MEDIA_ISO_C1_648X917MM 40991
#define PRINT_PREVIEW_MEDIA_ISO_C2_458X648MM 40992
#define PRINT_PREVIEW_MEDIA_ISO_C3_324X458MM 40993
#define PRINT_PREVIEW_MEDIA_ISO_C4_229X324MM 40994
#define PRINT_PREVIEW_MEDIA_ISO_C5_162X229MM 40995
#define PRINT_PREVIEW_MEDIA_ISO_C6C5_114X229MM 40996
#define PRINT_PREVIEW_MEDIA_ISO_C6_114X162MM 40997
#define PRINT_PREVIEW_MEDIA_ISO_C7C6_81X162MM 40998
#define PRINT_PREVIEW_MEDIA_ISO_C7_81X114MM 40999
#define PRINT_PREVIEW_MEDIA_ISO_C8_57X81MM 41000
#define PRINT_PREVIEW_MEDIA_ISO_C9_40X57MM 41001
#define PRINT_PREVIEW_MEDIA_ISO_DL_110X220MM 41002
#define PRINT_PREVIEW_MEDIA_ISO_ID_1_53_98X85_6MM 41003
#define PRINT_PREVIEW_MEDIA_ISO_RA0_860X1220MM 41004
#define PRINT_PREVIEW_MEDIA_ISO_RA1_610X860MM 41005
#define PRINT_PREVIEW_MEDIA_ISO_RA2_430X610MM 41006
#define PRINT_PREVIEW_MEDIA_ISO_RA3_305X430MM 41007
#define PRINT_PREVIEW_MEDIA_ISO_RA4_215X305MM 41008
#define PRINT_PREVIEW_MEDIA_ISO_SRA0_900X1280MM 41009
#define PRINT_PREVIEW_MEDIA_ISO_SRA1_640X900MM 41010
#define PRINT_PREVIEW_MEDIA_ISO_SRA2_450X640MM 41011
#define PRINT_PREVIEW_MEDIA_ISO_SRA3_320X450MM 41012
#define PRINT_PREVIEW_MEDIA_ISO_SRA4_225X320MM 41013
#define PRINT_PREVIEW_MEDIA_JIS_B0_1030X1456MM 41014
#define PRINT_PREVIEW_MEDIA_JIS_B1_728X1030MM 41015
#define PRINT_PREVIEW_MEDIA_JIS_B2_515X728MM 41016
#define PRINT_PREVIEW_MEDIA_JIS_B3_364X515MM 41017
#define PRINT_PREVIEW_MEDIA_JIS_B4_257X364MM 41018
#define PRINT_PREVIEW_MEDIA_JIS_B5_182X257MM 41019
#define PRINT_PREVIEW_MEDIA_JIS_B6_128X182MM 41020
#define PRINT_PREVIEW_MEDIA_JIS_B7_91X128MM 41021
#define PRINT_PREVIEW_MEDIA_JIS_B8_64X91MM 41022
#define PRINT_PREVIEW_MEDIA_JIS_B9_45X64MM 41023
#define PRINT_PREVIEW_MEDIA_JIS_B10_32X45MM 41024
#define PRINT_PREVIEW_MEDIA_JIS_EXEC_216X330MM 41025
#define PRINT_PREVIEW_MEDIA_JPN_CHOU2_111_1X146MM 41026
#define PRINT_PREVIEW_MEDIA_JPN_CHOU3_120X235MM 41027
#define PRINT_PREVIEW_MEDIA_JPN_CHOU4_90X205MM 41028
#define PRINT_PREVIEW_MEDIA_JPN_CHOU40_90X225MM 41029
#define PRINT_PREVIEW_MEDIA_JPN_HAGAKI_100X148MM 41030
#define PRINT_PREVIEW_MEDIA_JPN_KAHU_240X322_1MM 41031
#define PRINT_PREVIEW_MEDIA_JPN_KAKU1_270X382MM 41032
#define PRINT_PREVIEW_MEDIA_JPN_KAKU2_240X332MM 41033
#define PRINT_PREVIEW_MEDIA_JPN_KAKU3_216X277MM 41034
#define PRINT_PREVIEW_MEDIA_JPN_KAKU4_197X267MM 41035
#define PRINT_PREVIEW_MEDIA_JPN_KAKU5_190X240MM 41036
#define PRINT_PREVIEW_MEDIA_JPN_KAKU7_142X205MM 41037
#define PRINT_PREVIEW_MEDIA_JPN_KAKU8_119X197MM 41038
#define PRINT_PREVIEW_MEDIA_JPN_OUFUKU_148X200MM 41039
#define PRINT_PREVIEW_MEDIA_JPN_YOU4_105X235MM 41040
#define PRINT_PREVIEW_MEDIA_JPN_YOU6_98X190MM 41041
#define PRINT_PREVIEW_MEDIA_NA_10X11_10X11IN 41042
#define PRINT_PREVIEW_MEDIA_NA_10X13_10X13IN 41043
#define PRINT_PREVIEW_MEDIA_NA_10X14_10X14IN 41044
#define PRINT_PREVIEW_MEDIA_NA_10X15_10X15IN 41045
#define PRINT_PREVIEW_MEDIA_NA_11X12_11X12IN 41046
#define PRINT_PREVIEW_MEDIA_NA_11X15_11X15IN 41047
#define PRINT_PREVIEW_MEDIA_NA_12X19_12X19IN 41048
#define PRINT_PREVIEW_MEDIA_NA_5X7_5X7IN 41049
#define PRINT_PREVIEW_MEDIA_NA_6X9_6X9IN 41050
#define PRINT_PREVIEW_MEDIA_NA_7X9_7X9IN 41051
#define PRINT_PREVIEW_MEDIA_NA_9X11_9X11IN 41052
#define PRINT_PREVIEW_MEDIA_NA_A2_4_375X5_75IN 41053
#define PRINT_PREVIEW_MEDIA_NA_ARCH_A_9X12IN 41054
#define PRINT_PREVIEW_MEDIA_NA_ARCH_B_12X18IN 41055
#define PRINT_PREVIEW_MEDIA_NA_ARCH_C_18X24IN 41056
#define PRINT_PREVIEW_MEDIA_NA_ARCH_D_24X36IN 41057
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E_36X48IN 41058
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E2_26X38IN 41059
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E3_27X39IN 41060
#define PRINT_PREVIEW_MEDIA_NA_B_PLUS_12X19_17IN 41061
#define PRINT_PREVIEW_MEDIA_NA_C5_6_5X9_5IN 41062
#define PRINT_PREVIEW_MEDIA_NA_C_17X22IN 41063
#define PRINT_PREVIEW_MEDIA_NA_D_22X34IN 41064
#define PRINT_PREVIEW_MEDIA_NA_EDP_11X14IN 41065
#define PRINT_PREVIEW_MEDIA_NA_EUR_EDP_12X14IN 41066
#define PRINT_PREVIEW_MEDIA_NA_E_34X44IN 41067
#define PRINT_PREVIEW_MEDIA_NA_EXECUTIVE_7_25X10_5IN 41068
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_EUR_8_5X12IN 41069
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_US_11X14_875IN 41070
#define PRINT_PREVIEW_MEDIA_NA_FOOLSCAP_8_5X13IN 41071
#define PRINT_PREVIEW_MEDIA_NA_F_44X68IN 41072
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LEGAL_8X13IN 41073
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LETTER_8X10IN 41074
#define PRINT_PREVIEW_MEDIA_NA_INDEX_3X5_3X5IN 41075
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_4X6IN 41076
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_EXT_6X8IN 41077
#define PRINT_PREVIEW_MEDIA_NA_INDEX_5X8_5X8IN 41078
#define PRINT_PREVIEW_MEDIA_NA_INVOICE_5_5X8_5IN 41079
#define PRINT_PREVIEW_MEDIA_NA_LEDGER_11X17IN 41080
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_8_5X14IN 41081
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_EXTRA_9_5X15IN 41082
#define PRINT_PREVIEW_MEDIA_NA_LETTER_8_5X11IN 41083
#define PRINT_PREVIEW_MEDIA_NA_LETTER_EXTRA_9_5X12IN 41084
#define PRINT_PREVIEW_MEDIA_NA_LETTER_PLUS_8_5X12_69IN 41085
#define PRINT_PREVIEW_MEDIA_NA_MONARCH_3_875X7_5IN 41086
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_9_3_875X8_875IN 41087
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_10_4_125X9_5IN 41088
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_11_4_5X10_375IN 41089
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_12_4_75X11IN 41090
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_14_5X11_5IN 41091
#define PRINT_PREVIEW_MEDIA_NA_OFICIO_8_5X13_4IN 41092
#define PRINT_PREVIEW_MEDIA_NA_PERSONAL_3_625X6_5IN 41093
#define PRINT_PREVIEW_MEDIA_NA_QUARTO_8_5X10_83IN 41094
#define PRINT_PREVIEW_MEDIA_NA_SUPER_A_8_94X14IN 41095
#define PRINT_PREVIEW_MEDIA_NA_SUPER_B_13X19IN 41096
#define PRINT_PREVIEW_MEDIA_NA_WIDE_FORMAT_30X42IN 41097
#define PRINT_PREVIEW_MEDIA_OE_12X16_12X16IN 41098
#define PRINT_PREVIEW_MEDIA_OE_14X17_14X17IN 41099
#define PRINT_PREVIEW_MEDIA_OE_18X22_18X22IN 41100
#define PRINT_PREVIEW_MEDIA_OE_A2PLUS_17X24IN 41101
#define PRINT_PREVIEW_MEDIA_OE_BUSINESS_CARD_2X3_5IN 41102
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_10R_10X12IN 41103
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_12R_12X15IN 41104
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_14X18_14X18IN 41105
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_16R_16X20IN 41106
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_20R_20X24IN 41107
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22R_22X29_5IN 41108
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22X28_22X28IN 41109
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24R_24X31_5IN 41110
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24X30_24X30IN 41111
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_30R_30X40IN 41112
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_L_3_5X5IN 41113
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_S8R_8X12IN 41114
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_4X4IN 41115
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_5X5IN 41116
#define PRINT_PREVIEW_MEDIA_OM_16K_184X260MM 41117
#define PRINT_PREVIEW_MEDIA_OM_16K_195X270MM 41118
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X85MM 41119
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X91MM 41120
#define PRINT_PREVIEW_MEDIA_OM_CARD_54X86MM 41121
#define PRINT_PREVIEW_MEDIA_OM_DAI_PA_KAI_275X395MM 41122
#define PRINT_PREVIEW_MEDIA_OM_DSC_PHOTO_89X119MM 41123
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_210X330MM 41124
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_SP_215X315MM 41125
#define PRINT_PREVIEW_MEDIA_OM_INVITE_220X220MM 41126
#define PRINT_PREVIEW_MEDIA_OM_ITALIAN_110X230MM 41127
#define PRINT_PREVIEW_MEDIA_OM_JUURO_KU_KAI_198X275MM 41128
#define PRINT_PREVIEW_MEDIA_OM_LARGE_PHOTO_200X300 41129
#define PRINT_PREVIEW_MEDIA_OM_MEDIUM_PHOTO_130X180MM 41130
#define PRINT_PREVIEW_MEDIA_OM_PA_KAI_267X389MM 41131
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X40_300X400MM 41132
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X45_300X450MM 41133
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_35X46_350X460MM 41134
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_40X60_400X600MM 41135
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X75_500X750MM 41136
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X76_500X760MM 41137
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_60X90_600X900MM 41138
#define PRINT_PREVIEW_MEDIA_OM_SQUARE_PHOTO_89X89MM 41139
#define PRINT_PREVIEW_MEDIA_OM_WIDE_PHOTO_100X200MM 41140
#define PRINT_PREVIEW_MEDIA_OM_SMALL_PHOTO_100X150MM 41141
#define PRINT_PREVIEW_MEDIA_PRC_16K_146X215MM 41142
#define PRINT_PREVIEW_MEDIA_PRC_1_102X165MM 41143
#define PRINT_PREVIEW_MEDIA_PRC_2_102X176MM 41144
#define PRINT_PREVIEW_MEDIA_PRC_32K_97X151MM 41145
#define PRINT_PREVIEW_MEDIA_PRC_4_110X208MM 41146
#define PRINT_PREVIEW_MEDIA_PRC_6_120X320MM 41147
#define PRINT_PREVIEW_MEDIA_PRC_7_160X230MM 41148
#define PRINT_PREVIEW_MEDIA_PRC_8_120X309MM 41149
#define PRINT_PREVIEW_MEDIA_ROC_16K_7_75X10_75IN 41150
#define PRINT_PREVIEW_MEDIA_ROC_8K_10_75X15_5IN 41151
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_INCHES 41152
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_MM 41153
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_INCHES 41154
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_MM 41155
#define IDS_PRINT_PREVIEW_FRIENDLY_WIN_NETWORK_PRINTER_NAME 41156
#define IDS_PRINT_COMPOSITOR_SERVICE_DISPLAY_NAME 41157
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_TITLE 41561
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_1 41562
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_2 41563
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_3 41564
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_EXPAND_LABEL 41565
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_4 41566
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DECLINE_BUTTON 41567
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_ACCEPT_BUTTON 41568
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_SAVING_LABEL 41569
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_1 41570
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_2 41571
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_3 41572
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_LINK 41573
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_TITLE 41574
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_1 41575
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_1 41576
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_2 41577
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_EXPAND_LABEL 41578
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_2 41579
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_ACK_BUTTON 41580
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_SETTINGS_BUTTON 41581
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_1 41582
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_1 41583
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_2 41584
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_3 41585
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_2 41586
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_DESCRIPTION 41587
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_TITLE 41588
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_1 41589
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_2 41590
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_3 41591
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_ACK_BUTTON 41592
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_SETTINGS_BUTTON 41593
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_TITLE 41594
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_1 41595
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_2 41596
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_3 41597
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_EXPAND_LABEL 41598
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_4 41599
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_ACK_BUTTON 41600
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_SETTINGS_BUTTON 41601
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_1 41602
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_1 41603
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_1 41604
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_2 41605
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_2 41606
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_3 41607
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_2 41608
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_4 41609
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_5 41610
#define IDS_PRIVACY_SANDBOX_M1_DIALOG_MORE_BUTTON 41611
#define IDS_SETTINGS_TOPICS_PAGE_TITLE 41612
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_LABEL 41613
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_SUB_LABEL_V2 41614
#define IDS_SETTINGS_TOPICS_PAGE_DISCLAIMER_DESKTOP 41615
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_CANONICAL 41616
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_DISABLED 41617
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY_TEXT_V2 41618
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY_TEXT_HEADING 41619
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY_TEXT_V2 41620
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY_TEXT_HEADING 41621
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC 41622
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC_A11Y_LABEL 41623
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC 41624
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC_A11Y_LABEL 41625
#define IDS_SETTINGS_TOPICS_PAGE_UNBLOCK_TOPIC_A11Y_LABEL 41626
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_CANONICAL 41627
#define IDS_SETTINGS_TOPICS_PAGE_FIRST_LEVEL_TOPIC_DESCRIPTOR 41628
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_TITLE 41629
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_BODY 41630
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_CLANK_TITLE 41631
#define IDS_SETTINGS_MANAGE_TOPICS_DIALOG_CLANK_BODY 41632
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_DESCRIPTION 41633
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_LEARN_MORE_LINK 41634
#define IDS_SETTINGS_MANAGE_TOPICS_PAGE_DESCRIPTION_LEARN_MORE_ARIA_LABEL 41635
#define IDS_SETTINGS_UNBLOCK_TOPIC_TOAST_BODY 41636
#define IDS_SETTINGS_UNBLOCK_TOPIC_TOAST_BUTTON_TEXT 41637
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER_V2 41638
#define IDS_SETTINGS_UNBLOCK_TOPIC_BUTTON_TEXT_V2 41639
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_HEADING_NEW 41640
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_NEW 41641
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_HEADING 41642
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_DESCRIPTION 41643
#define IDS_SETTINGS_TOPICS_PAGE_MANAGE_TOPICS_EXPLANATION 41644
#define IDS_SETTINGS_TOPICS_PAGE_ACTIVE_TOPICS_HEADING 41645
#define IDS_SETTINGS_TOPICS_PAGE_ACTIVE_TOPICS_DESCRIPTION 41646
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_NEW 41647
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER_NEW 41648
#define IDS_SETTINGS_FLEDGE_PAGE_EXPLANATION 41649
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_STATUS_LABEL 41650
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TIME_LABEL 41651
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_SOURCE_LABEL 41652
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TEXT_LABEL 41653
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_SETTINGS 41654
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_DEFAULT 41655
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_CONFIRMATION 41656
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_ACTIVE 41657
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_INACTIVE 41658
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_NOT_REQUIRED 41659
#define IDS_PRIVACY_SANDBOX_TOPICS_INVALID_TOPIC 41660
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_1 41661
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_2 41662
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_3 41663
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_4 41664
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_5 41665
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_6 41666
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_7 41667
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_8 41668
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_9 41669
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_10 41670
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_11 41671
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_12 41672
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_13 41673
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_14 41674
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_15 41675
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_16 41676
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_17 41677
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_18 41678
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_19 41679
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_20 41680
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_21 41681
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_22 41682
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_23 41683
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_24 41684
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_25 41685
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_26 41686
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_27 41687
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_28 41688
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_29 41689
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_30 41690
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_31 41691
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_32 41692
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_33 41693
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_34 41694
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_35 41695
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_36 41696
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_37 41697
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_38 41698
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_39 41699
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_40 41700
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_41 41701
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_42 41702
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_43 41703
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_44 41704
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_45 41705
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_46 41706
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_47 41707
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_48 41708
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_49 41709
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_50 41710
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_51 41711
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_52 41712
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_53 41713
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_54 41714
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_55 41715
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_56 41716
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_57 41717
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_58 41718
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_59 41719
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_60 41720
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_61 41721
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_62 41722
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_63 41723
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_64 41724
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_65 41725
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_66 41726
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_67 41727
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_68 41728
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_69 41729
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_70 41730
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_71 41731
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_72 41732
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_73 41733
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_74 41734
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_75 41735
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_76 41736
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_77 41737
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_78 41738
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_79 41739
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_80 41740
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_81 41741
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_82 41742
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_83 41743
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_84 41744
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_85 41745
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_86 41746
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_87 41747
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_88 41748
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_89 41749
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_90 41750
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_91 41751
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_92 41752
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_93 41753
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_94 41754
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_95 41755
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_96 41756
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_97 41757
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_98 41758
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_99 41759
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_100 41760
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_101 41761
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_102 41762
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_103 41763
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_104 41764
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_105 41765
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_106 41766
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_107 41767
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_108 41768
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_109 41769
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_110 41770
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_111 41771
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_112 41772
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_113 41773
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_114 41774
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_115 41775
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_116 41776
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_117 41777
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_118 41778
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_119 41779
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_120 41780
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_121 41781
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_122 41782
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_123 41783
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_124 41784
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_125 41785
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_126 41786
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_127 41787
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_128 41788
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_129 41789
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_130 41790
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_131 41791
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_132 41792
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_133 41793
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_134 41794
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_135 41795
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_136 41796
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_137 41797
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_138 41798
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_139 41799
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_140 41800
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_141 41801
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_142 41802
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_143 41803
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_144 41804
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_145 41805
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_146 41806
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_147 41807
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_148 41808
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_149 41809
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_150 41810
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_151 41811
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_152 41812
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_153 41813
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_154 41814
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_155 41815
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_156 41816
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_157 41817
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_158 41818
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_159 41819
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_160 41820
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_161 41821
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_162 41822
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_163 41823
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_164 41824
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_165 41825
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_166 41826
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_167 41827
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_168 41828
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_169 41829
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_170 41830
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_171 41831
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_172 41832
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_173 41833
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_174 41834
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_175 41835
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_176 41836
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_177 41837
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_178 41838
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_179 41839
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_180 41840
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_181 41841
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_182 41842
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_183 41843
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_184 41844
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_185 41845
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_186 41846
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_187 41847
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_188 41848
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_189 41849
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_190 41850
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_191 41851
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_192 41852
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_193 41853
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_194 41854
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_195 41855
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_196 41856
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_197 41857
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_198 41858
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_199 41859
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_200 41860
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_201 41861
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_202 41862
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_203 41863
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_204 41864
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_205 41865
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_206 41866
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_207 41867
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_208 41868
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_209 41869
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_210 41870
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_211 41871
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_212 41872
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_213 41873
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_214 41874
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_215 41875
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_216 41876
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_217 41877
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_218 41878
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_219 41879
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_220 41880
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_221 41881
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_222 41882
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_223 41883
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_224 41884
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_225 41885
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_226 41886
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_227 41887
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_228 41888
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_229 41889
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_230 41890
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_231 41891
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_232 41892
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_233 41893
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_234 41894
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_235 41895
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_236 41896
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_237 41897
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_238 41898
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_239 41899
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_240 41900
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_241 41901
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_242 41902
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_243 41903
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_244 41904
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_245 41905
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_246 41906
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_247 41907
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_248 41908
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_249 41909
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_250 41910
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_251 41911
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_252 41912
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_253 41913
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_254 41914
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_255 41915
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_256 41916
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_257 41917
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_258 41918
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_259 41919
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_260 41920
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_261 41921
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_262 41922
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_263 41923
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_264 41924
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_265 41925
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_266 41926
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_267 41927
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_268 41928
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_269 41929
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_270 41930
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_271 41931
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_272 41932
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_273 41933
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_274 41934
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_275 41935
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_276 41936
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_277 41937
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_278 41938
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_279 41939
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_280 41940
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_281 41941
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_282 41942
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_283 41943
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_284 41944
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_285 41945
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_286 41946
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_287 41947
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_288 41948
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_289 41949
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_290 41950
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_291 41951
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_292 41952
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_293 41953
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_294 41954
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_295 41955
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_296 41956
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_297 41957
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_298 41958
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_299 41959
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_300 41960
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_301 41961
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_302 41962
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_303 41963
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_304 41964
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_305 41965
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_306 41966
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_307 41967
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_308 41968
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_309 41969
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_310 41970
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_311 41971
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_312 41972
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_313 41973
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_314 41974
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_315 41975
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_316 41976
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_317 41977
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_318 41978
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_319 41979
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_320 41980
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_321 41981
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_322 41982
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_323 41983
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_324 41984
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_325 41985
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_326 41986
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_327 41987
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_328 41988
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_329 41989
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_330 41990
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_331 41991
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_332 41992
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_333 41993
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_334 41994
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_335 41995
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_336 41996
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_337 41997
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_338 41998
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_339 41999
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_340 42000
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_341 42001
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_342 42002
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_343 42003
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_344 42004
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_345 42005
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_346 42006
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_347 42007
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_348 42008
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_349 42009
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_350 42010
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_351 42011
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_352 42012
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_353 42013
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_354 42014
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_355 42015
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_356 42016
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_357 42017
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_358 42018
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_359 42019
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_360 42020
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_361 42021
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_362 42022
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_363 42023
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_364 42024
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_365 42025
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_366 42026
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_367 42027
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_368 42028
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_369 42029
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_370 42030
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_371 42031
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_372 42032
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_373 42033
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_374 42034
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_375 42035
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_376 42036
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_377 42037
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_378 42038
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_379 42039
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_380 42040
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_381 42041
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_382 42042
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_383 42043
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_384 42044
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_385 42045
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_386 42046
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_387 42047
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_388 42048
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_389 42049
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_390 42050
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_391 42051
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_392 42052
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_393 42053
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_394 42054
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_395 42055
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_396 42056
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_397 42057
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_398 42058
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_399 42059
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_400 42060
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_401 42061
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_402 42062
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_403 42063
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_404 42064
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_405 42065
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_406 42066
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_407 42067
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_408 42068
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_409 42069
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_410 42070
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_411 42071
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_412 42072
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_413 42073
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_414 42074
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_415 42075
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_416 42076
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_417 42077
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_418 42078
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_419 42079
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_420 42080
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_421 42081
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_422 42082
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_423 42083
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_424 42084
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_425 42085
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_426 42086
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_427 42087
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_428 42088
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_429 42089
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_430 42090
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_431 42091
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_432 42092
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_433 42093
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_434 42094
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_435 42095
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_436 42096
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_437 42097
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_438 42098
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_439 42099
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_440 42100
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_441 42101
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_442 42102
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_443 42103
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_444 42104
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_445 42105
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_446 42106
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_447 42107
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_448 42108
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_449 42109
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_450 42110
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_451 42111
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_452 42112
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_453 42113
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_454 42114
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_455 42115
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_456 42116
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_457 42117
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_458 42118
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_459 42119
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_460 42120
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_461 42121
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_462 42122
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_463 42123
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_464 42124
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_465 42125
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_466 42126
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_467 42127
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_468 42128
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_469 42129
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_470 42130
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_471 42131
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_472 42132
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_473 42133
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_474 42134
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_475 42135
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_476 42136
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_477 42137
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_478 42138
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_479 42139
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_480 42140
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_481 42141
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_482 42142
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_483 42143
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_484 42144
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_485 42145
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_486 42146
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_487 42147
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_488 42148
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_489 42149
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_490 42150
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_491 42151
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_492 42152
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_493 42153
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_494 42154
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_495 42155
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_496 42156
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_497 42157
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_498 42158
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_499 42159
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_500 42160
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_501 42161
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_502 42162
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_503 42163
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_504 42164
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_505 42165
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_506 42166
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_507 42167
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_508 42168
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_509 42169
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_510 42170
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_511 42171
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_512 42172
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_513 42173
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_514 42174
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_515 42175
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_516 42176
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_517 42177
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_518 42178
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_519 42179
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_520 42180
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_521 42181
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_522 42182
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_523 42183
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_524 42184
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_525 42185
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_526 42186
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_527 42187
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_528 42188
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_529 42189
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_530 42190
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_531 42191
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_532 42192
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_533 42193
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_534 42194
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_535 42195
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_536 42196
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_537 42197
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_538 42198
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_539 42199
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_540 42200
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_541 42201
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_542 42202
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_543 42203
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_544 42204
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_545 42205
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_546 42206
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_547 42207
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_548 42208
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_549 42209
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_550 42210
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_551 42211
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_552 42212
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_553 42213
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_554 42214
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_555 42215
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_556 42216
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_557 42217
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_558 42218
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_559 42219
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_560 42220
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_561 42221
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_562 42222
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_563 42223
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_564 42224
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_565 42225
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_566 42226
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_567 42227
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_568 42228
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_569 42229
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_570 42230
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_571 42231
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_572 42232
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_573 42233
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_574 42234
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_575 42235
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_576 42236
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_577 42237
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_578 42238
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_579 42239
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_580 42240
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_581 42241
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_582 42242
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_583 42243
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_584 42244
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_585 42245
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_586 42246
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_587 42247
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_588 42248
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_589 42249
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_590 42250
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_591 42251
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_592 42252
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_593 42253
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_594 42254
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_595 42255
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_596 42256
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_597 42257
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_598 42258
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_599 42259
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_600 42260
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_601 42261
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_602 42262
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_603 42263
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_604 42264
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_605 42265
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_606 42266
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_607 42267
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_608 42268
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_609 42269
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_610 42270
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_611 42271
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_612 42272
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_613 42273
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_614 42274
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_615 42275
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_616 42276
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_617 42277
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_618 42278
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_619 42279
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_620 42280
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_621 42281
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_622 42282
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_623 42283
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_624 42284
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_625 42285
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_626 42286
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_627 42287
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_628 42288
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_629 42289
#define IDS_PRIVACY_SANDBOX_IP_PROTECTION_TITLE 42290
#define IDS_PRIVACY_SANDBOX_IP_PROTECTION_SUMMARY 42291
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_DESCRIPTION 42292
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_ONE_TITLE 42293
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_ONE_DESCRIPTION 42294
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_TWO_TITLE 42295
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_BULLET_TWO_DESCRIPTION 42296
#define IDS_PRIVACY_SANDBOX_TRACKING_PROTECTION_ADVANCED_CATEGORY 42297
#define IDS_TRACKING_PROTECTION_BLOCK_COOKIES_TOGGLE_TITLE 42298
#define IDS_TRACKING_PROTECTION_BLOCK_COOKIES_TOGGLE_SUMMARY 42299
#define IDS_TRACKING_PROTECTION_ALLOWED_GROUP_TITLE 42300
#define IDS_TRACKING_PROTECTION_ALLOWED_GROUP_DESCRIPTION 42301
#define IDS_TRACKING_PROTECTION_NEVER_EXPIRES_LABEL 42302
#define IDS_TRACKING_PROTECTION_EXPIRES_TODAY_LABEL 42303
#define IDS_TRACKING_PROTECTION_EXPIRES_LABEL 42304
#define IDS_TRACKING_PROTECTION_DELETE_SITE_LABEL 42305
#define IDS_REGISTER_PROTOCOL_HANDLER_TOOLTIP 441
#define IDS_REGISTER_PROTOCOL_HANDLER_MAILTO_NAME 42306
#define IDS_REGISTER_PROTOCOL_HANDLER_WEBCAL_NAME 42307
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM 42308
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE 42309
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_FRAGMENT 42310
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE_FRAGMENT 42311
#define IDS_REGISTER_PROTOCOL_HANDLER_ACCEPT 42312
#define IDS_REGISTER_PROTOCOL_HANDLER_DENY 42313
#define IDS_REGISTER_PROTOCOL_HANDLER_IGNORE 42314
#define IDS_RESET_PASSWORD_TITLE 42315
#define IDS_RESET_PASSWORD_WARNING_HEADING 42316
#define IDS_RESET_PASSWORD_WARNING_HEADING_V2 42317
#define IDS_RESET_PASSWORD_WARNING_HEADING_WITH_ORG_NAME 42318
#define IDS_RESET_PASSWORD_HEADING 42319
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH 42320
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_V2 42321
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 42322
#define IDS_RESET_PASSWORD_BUTTON 42323
#define IDS_RESET_PASSWORD_LEARN_MORE 42324
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH 42325
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 42326
#define IDS_SAVED_TAB_GROUPS_CREATION_FORMAT 42327
#define IDS_SAVED_TAB_GROUPS_CREATION_JUST_NOW 42328
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_TITLE 42329
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE 42330
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_INFO_LINK 42331
#define IDS_SEARCH_ENGINE_CHOICE_PAGE_SUBTITLE_INFO_LINK_A11Y_LABEL 42332
#define IDS_SEARCH_ENGINE_CHOICE_BUTTON_TITLE 42333
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_TITLE 42335
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_FIRST_PARAGRAPH 42336
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_SECOND_PARAGRAPH 42337
#define IDS_SEARCH_ENGINE_CHOICE_INFO_DIALOG_BODY_THIRD_PARAGRAPH 42338
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_SUBTITLE 42339
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_SUBTITLE_NON_EEA 42340
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_ENTRY_POINT_SUBTITLE 42341
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_CHANGE_DEFAULT_ENGINE 42342
#define IDS_SEARCH_ENGINE_FALLBACK_MARKETING_SNIPPET 42343
#define IDS_SEARCH_ENGINE_CHOICE_MORE_BUTTON 42344
#define IDS_SEARCH_ENGINE_CHOICE_CONTINUE_BUTTON 42345
#define IDS_SEARCH_ENGINE_CHOICE_CHEVRON_A11Y_LABEL 42346
#define IDS_SEARCH_ENGINE_CHOICE_SETTINGS_CONFIRMATION_TOAST_LABEL 42347
#define IDS_SEARCH_ENGINE_CHOICE_LIST_A11Y_LABEL 42348
#define IDS_SEARCH_ENGINE_CHOICE_GUEST_SESSION_CHECKBOX 42349
#define IDS_SSL_OPEN_DETAILS_BUTTON 42350
#define IDS_SSL_CLOSE_DETAILS_BUTTON 42351
#define IDS_CAPTIVE_PORTAL_AUTHORIZATION_DIALOG_NAME 42352
#define IDS_CAPTIVE_PORTAL_HEADING_WIRED 42353
#define IDS_CAPTIVE_PORTAL_HEADING_WIFI 42354
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIRED 42355
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI 42356
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI_SSID 42357
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIRED 42358
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI 42359
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI_SSID 42360
#define IDS_CAPTIVE_PORTAL_BUTTON_OPEN_LOGIN_PAGE 42361
#define IDS_MITM_SOFTWARE_HEADING 42362
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_ENTERPRISE 42363
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_NONENTERPRISE 42364
#define IDS_MITM_SOFTWARE_EXPLANATION_ENTERPRISE 42365
#define IDS_MITM_SOFTWARE_EXPLANATION_NONENTERPRISE 42366
#define IDS_MITM_SOFTWARE_EXPLANATION 42367
#define IDS_LOOKALIKE_URL_TITLE 42368
#define IDS_LOOKALIKE_URL_HEADING 42369
#define IDS_LOOKALIKE_URL_IGNORE 42370
#define IDS_LOOKALIKE_URL_CONTINUE 42371
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH 42372
#define IDS_LOOKALIKE_URL_HEADING_NO_SUGGESTED_URL 42373
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH_NO_SUGGESTED_URL 42374
#define IDS_LOOKALIKE_URL_BACK_TO_SAFETY 42375
#define IDS_LOOKALIKE_URL_CLOSE_PAGE 42376
#define IDS_ENTERPRISE_BLOCK_TITLE 42377
#define IDS_ENTERPRISE_BLOCK_HEADING 42378
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH 42379
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH_CUSTOM_MESSAGE 42380
#define IDS_ENTERPRISE_BLOCK_GO_BACK 42381
#define IDS_ENTERPRISE_WARN_TITLE 42382
#define IDS_ENTERPRISE_WARN_HEADING 42383
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH 42384
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH_CUSTOM_MESSAGE 42385
#define IDS_ENTERPRISE_WARN_GO_BACK 42386
#define IDS_ENTERPRISE_WARN_CONTINUE_TO_SITE 42387
#define IDS_ENTERPRISE_INTERSTITIALS_LEARN_MORE_ACCCESSIBILITY_TEXT 42388
#define IDS_CLOCK_ERROR_TITLE 42389
#define IDS_CLOCK_ERROR_AHEAD_HEADING 42390
#define IDS_CLOCK_ERROR_BEHIND_HEADING 42391
#define IDS_CLOCK_ERROR_UPDATE_DATE_AND_TIME 42392
#define IDS_CLOCK_ERROR_PRIMARY_PARAGRAPH 42393
#define IDS_CLOCK_ERROR_EXPLANATION 42394
#define IDS_SSL_V2_TITLE 42395
#define IDS_SSL_V2_HEADING 42396
#define IDS_SSL_V2_PRIMARY_PARAGRAPH 42397
#define IDS_SSL_V2_RECURRENT_ERROR_PARAGRAPH 42398
#define IDS_SSL_OVERRIDABLE_SAFETY_BUTTON 42399
#define IDS_SSL_OVERRIDABLE_CLOSE_PAGE_BUTTON 42400
#define IDS_SSL_OVERRIDABLE_PROCEED_PARAGRAPH 42401
#define IDS_SSL_RELOAD 42402
#define IDS_SSL_NONOVERRIDABLE_PINNED 42403
#define IDS_SSL_NONOVERRIDABLE_HSTS 42404
#define IDS_SSL_NONOVERRIDABLE_REVOKED 42405
#define IDS_SSL_NONOVERRIDABLE_MORE 42406
#define IDS_SSL_NONOVERRIDABLE_INVALID 42407
#define IDS_SAFEBROWSING_V3_TITLE 42408
#define IDS_SAFEBROWSING_V3_OPEN_DETAILS_BUTTON 42409
#define IDS_SAFEBROWSING_V3_CLOSE_DETAILS_BUTTON 42410
#define IDS_SAFEBROWSING_OVERRIDABLE_SAFETY_BUTTON 42411
#define IDS_SAFEBROWSING_HEADING 42412
#define IDS_MALWARE_V3_PRIMARY_PARAGRAPH 42413
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH 42414
#define IDS_MALWARE_V3_PROCEED_PARAGRAPH 42415
#define IDS_SAFE_BROWSING_SCOUT_REPORTING_AGREE 42416
#define IDS_SAFE_BROWSING_ENHANCED_PROTECTION_MESSAGE 42417
#define IDS_HARMFUL_V3_PRIMARY_PARAGRAPH 42418
#define IDS_HARMFUL_V3_EXPLANATION_PARAGRAPH 42419
#define IDS_HARMFUL_V3_PROCEED_PARAGRAPH 42420
#define IDS_PHISHING_V4_PRIMARY_PARAGRAPH 42421
#define IDS_PHISHING_V4_EXPLANATION_PARAGRAPH 42422
#define IDS_PHISHING_V4_PROCEED_PARAGRAPH 42423
#define IDS_MALWARE_WEBVIEW_HEADING 42424
#define IDS_MALWARE_WEBVIEW_EXPLANATION_PARAGRAPH 42425
#define IDS_PHISHING_WEBVIEW_HEADING 42426
#define IDS_PHISHING_WEBVIEW_EXPLANATION_PARAGRAPH 42427
#define IDS_HARMFUL_WEBVIEW_HEADING 42428
#define IDS_HARMFUL_WEBVIEW_EXPLANATION_PARAGRAPH 42429
#define IDS_BILLING_WEBVIEW_HEADING 42430
#define IDS_BILLING_WEBVIEW_EXPLANATION_PARAGRAPH 42431
#define IDS_SUPERVISED_USER_URL_BLOCKED_MESSAGE 42432
#define IDS_SUPERVISED_USER_LEARN_MORE 42433
#define IDS_CONNECTION_HELP_SHOW_MORE 42434
#define IDS_CONNECTION_HELP_SHOW_LESS 42435
#define IDS_CONNECTION_HELP_TITLE 42436
#define IDS_CONNECTION_HELP_HEADING 42437
#define IDS_CONNECTION_HELP_GENERAL_HELP 42438
#define IDS_CONNECTION_HELP_SPECIFIC_ERROR_HEADING 42439
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_TITLE 42440
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_TITLE 42441
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_TITLE 42442
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_DETAILS 42443
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_DETAILS 42444
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_DETAILS 42445
#define IDS_CONNECTION_HELP_MITM_SOFTWARE_TITLE 42446
#define IDS_CONNECTION_HELP_MITM_SOFTWARE_DETAILS 42447
#define IDS_BILLING_TITLE 42448
#define IDS_BILLING_HEADING 42449
#define IDS_BILLING_PRIMARY_PARAGRAPH 42450
#define IDS_BILLING_PRIMARY_BUTTON 42451
#define IDS_BILLING_PROCEED_BUTTON 42452
#define IDS_BLOCKED_INTERCEPTION_HEADING 42453
#define IDS_KNOWN_INTERCEPTION_TITLE 42454
#define IDS_KNOWN_INTERCEPTION_HEADER 42455
#define IDS_KNOWN_INTERCEPTION_BODY1 42456
#define IDS_KNOWN_INTERCEPTION_BODY2 42457
#define IDS_KNOWN_INTERCEPTION_INFOBAR_HEADING 42458
#define IDS_KNOWN_INTERCEPTION_INFOBAR_BUTTON_TEXT 42459
#define IDS_LEGACY_TLS_HEADING 42460
#define IDS_LEGACY_TLS_PRIMARY_PARAGRAPH 42461
#define IDS_LEGACY_TLS_EXPLANATION 42462
#define IDS_INSECURE_FORM_TITLE 42463
#define IDS_INSECURE_FORM_HEADING 42464
#define IDS_INSECURE_FORM_PRIMARY_PARAGRAPH 42465
#define IDS_INSECURE_FORM_BACK_BUTTON 42466
#define IDS_INSECURE_FORM_SUBMIT_BUTTON 42467
#define IDS_HTTPS_ONLY_MODE_TITLE 42468
#define IDS_HTTPS_ONLY_MODE_HEADING 42469
#define IDS_HTTPS_ONLY_MODE_PRIMARY_PARAGRAPH 42470
#define IDS_HTTPS_ONLY_BALANCED_MODE_HEADING 42471
#define IDS_HTTPS_ONLY_BALANCED_MODE_PRIMARY_PARAGRAPH 42472
#define IDS_HTTPS_ONLY_MODE_WITH_ADVANCED_PROTECTION_PRIMARY_PARAGRAPH 42473
#define IDS_HTTPS_ONLY_MODE_WITH_SITE_ENGAGEMENT_PRIMARY_PARAGRAPH 42474
#define IDS_HTTPS_ONLY_MODE_FOR_TYPICALLY_SECURE_BROWSING_PRIMARY_PARAGRAPH 42475
#define IDS_HTTPS_ONLY_MODE_FOR_INCOGNITO_PRIMARY_PARAGRAPH 42476
#define IDS_HTTPS_ONLY_MODE_BACK_BUTTON 42477
#define IDS_HTTPS_ONLY_MODE_SUBMIT_BUTTON 42478
#define IDS_SHARING_DEVICE_TYPE_COMPUTER 42479
#define IDS_SHARING_DEVICE_TYPE_DEVICE 42480
#define IDS_SHARING_DEVICE_TYPE_PHONE 42481
#define IDS_SHARING_DEVICE_TYPE_TABLET 42482
#define IDS_SEND_TAB_PUSH_NOTIFICATION_TITLE_DEAULT_DEVICE_NAME 42483
#define IDS_SEND_TAB_PUSH_NOTIFICATION_TITLE_USER_GIVEN_DEVICE_NAME 42484
#define IDS_SEND_TAB_PUSH_NOTIFICATION_BODY 42485
#define IDS_SEND_TAB_PUSH_NOTIFICATION_PLACEHOLDER_TITLE 42486
#define IDS_SEND_TAB_PUSH_NOTIFICATION_PLACEHOLDER_BODY 42487
#define IDS_SITE_SETTINGS_TYPE_ADS 42488
#define IDS_SITE_SETTINGS_TYPE_ADS_MID_SENTENCE 42489
#define IDS_SITE_SETTINGS_TYPE_ANTI_ABUSE 42490
#define IDS_SITE_SETTINGS_TYPE_AR 42491
#define IDS_SITE_SETTINGS_TYPE_AR_MID_SENTENCE 42492
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS 42493
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS_MID_SENTENCE 42494
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_FULLSCREEN 42495
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_FULLSCREEN_MID_SENTENCE 42496
#define IDS_SITE_SETTINGS_TYPE_AUTO_PICTURE_IN_PICTURE 42497
#define IDS_SITE_SETTINGS_TYPE_AUTO_PICTURE_IN_PICTURE_MID_SENTENCE 42498
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC 42499
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC_MID_SENTENCE 42500
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES 42501
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES_MID_SENTENCE 42502
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING 42503
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING_MID_SENTENCE 42504
#define IDS_SITE_SETTINGS_TYPE_CAMERA 42505
#define IDS_SITE_SETTINGS_TYPE_CAMERA_MID_SENTENCE 42506
#define IDS_SITE_SETTINGS_TYPE_CAMERA_WITH_COUNT 42507
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM 42508
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_MID_SENTENCE 42509
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_WITH_COUNT 42510
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_MID_SENTENCE 42511
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_SHARED_TABS 42512
#define IDS_SITE_SETTINGS_TYPE_CAPTURED_SURFACE_CONTROL_SUB_MENU 42513
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD 42514
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD_MID_SENTENCE 42515
#define IDS_SITE_SETTINGS_TYPE_COOKIES 42516
#define IDS_SITE_SETTINGS_TYPE_COOKIES_MID_SENTENCE 42517
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API 42518
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API_MID_SENTENCE 42519
#define IDS_SITE_SETTINGS_TYPE_HAND_TRACKING 42520
#define IDS_SITE_SETTINGS_TYPE_HAND_TRACKING_MID_SENTENCE 42521
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION 42522
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION_MID_SENTENCE 42523
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT 42524
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_MID_SENTENCE 42525
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_OPTIMIZER 42526
#define IDS_SITE_SETTINGS_TYPE_LOCATION 42527
#define IDS_SITE_SETTINGS_TYPE_LOCATION_MID_SENTENCE 42528
#define IDS_SITE_SETTINGS_TYPE_MIC 42529
#define IDS_SITE_SETTINGS_TYPE_MIC_MID_SENTENCE 42530
#define IDS_SITE_SETTINGS_TYPE_MIC_WITH_COUNT 42531
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX 42532
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX_MID_SENTENCE 42533
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS 42534
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS_MID_SENTENCE 42535
#define IDS_SITE_SETTINGS_TYPE_NFC 42536
#define IDS_SITE_SETTINGS_TYPE_NFC_MID_SENTENCE 42537
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS 42538
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS_MID_SENTENCE 42539
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS 42540
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS_MID_SENTENCE 42541
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID 42542
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID_MID_SENTENCE 42543
#define IDS_SITE_SETTINGS_TYPE_SENSORS 42544
#define IDS_SITE_SETTINGS_TYPE_SENSORS_MID_SENTENCE 42545
#define IDS_SITE_SETTINGS_TYPE_SOUND 42546
#define IDS_SITE_SETTINGS_TYPE_SOUND_MID_SENTENCE 42547
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES 42548
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES_MID_SENTENCE 42549
#define IDS_SITE_SETTINGS_TYPE_VR 42550
#define IDS_SITE_SETTINGS_TYPE_VR_MID_SENTENCE 42551
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS 42552
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS_MID_SENTENCE 42553
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE 42554
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE_MID_SENTENCE 42555
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS 42556
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS_MID_SENTENCE 42557
#define IDS_SITE_SETTINGS_TYPE_HANDLERS 42558
#define IDS_SITE_SETTINGS_TYPE_HANDLERS_MID_SENTENCE 42559
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES 42560
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES_MID_SENTENCE 42561
#define IDS_SITE_SETTINGS_TYPE_IMAGES 42562
#define IDS_SITE_SETTINGS_TYPE_IMAGES_MID_SENTENCE 42563
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT 42564
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT_MID_SENTENCE 42565
#define IDS_SITE_SETTINGS_TYPE_KEYBOARD_LOCK 42566
#define IDS_SITE_SETTINGS_TYPE_KEYBOARD_LOCK_MID_SENTENCE 42567
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER 42568
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER_MID_SENTENCE 42569
#define IDS_SITE_SETTINGS_TYPE_PDF_DOCUMENTS 42570
#define IDS_SITE_SETTINGS_TYPE_POINTER_LOCK 42571
#define IDS_SITE_SETTINGS_TYPE_POINTER_LOCK_MID_SENTENCE 42572
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS 42573
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS_MID_SENTENCE 42574
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS 42576
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS_MID_SENTENCE 42577
#define IDS_SITE_SETTINGS_TYPE_WEB_APP_INSTALLATION 42578
#define IDS_SITE_SETTINGS_TYPE_WEB_APP_INSTALLATION_MID_SENTENCE 42579
#define IDS_SITE_SETTINGS_TYPE_WEB_PRINTING 42580
#define IDS_SITE_SETTINGS_TYPE_WEB_PRINTING_MID_SENTENCE 42581
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT 42582
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT_MID_SENTENCE 42583
#define IDS_SITE_SETTINGS_TYPE_PERFORMANCE 42584
#define IDS_SITE_SETTINGS_TYPE_PERFORMANCE_SUBLABEL 42585
#define IDS_SITE_SETTINGS_TYPE_OFFER_WRITING_HELP 42586
#define IDS_SMS_INFOBAR_TITLE 42587
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED 42588
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED_FROM_EMBEDDED_FRAME 42589
#define IDS_SMS_INFOBAR_BUTTON_OK 42590
#define IDS_CERT_ERROR_NO_SUBJECT_ALTERNATIVE_NAMES_DETAILS 42591
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DETAILS 42592
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DESCRIPTION 42593
#define IDS_CERT_ERROR_EXPIRED_DETAILS 42594
#define IDS_CERT_ERROR_EXPIRED_DESCRIPTION 42595
#define IDS_CERT_ERROR_NOT_YET_VALID_DETAILS 42596
#define IDS_CERT_ERROR_NOT_YET_VALID_DESCRIPTION 42597
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DETAILS 42598
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DESCRIPTION 42599
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DESCRIPTION 42600
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DETAILS 42601
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DESCRIPTION 42602
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DETAILS 42603
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DESCRIPTION 42604
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DETAILS 42605
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DESCRIPTION 42606
#define IDS_CERT_ERROR_REVOKED_CERT_DETAILS 42607
#define IDS_CERT_ERROR_REVOKED_CERT_DESCRIPTION 42608
#define IDS_CERT_ERROR_INVALID_CERT_DETAILS 42609
#define IDS_CERT_ERROR_INVALID_CERT_DESCRIPTION 42610
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DETAILS 42611
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DESCRIPTION 42612
#define IDS_CERT_ERROR_WEAK_KEY_DETAILS 42613
#define IDS_CERT_ERROR_WEAK_KEY_DESCRIPTION 42614
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DETAILS 42615
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DESCRIPTION 42616
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DETAILS 42617
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DESCRIPTION 42618
#define IDS_CERT_ERROR_NON_UNIQUE_NAME_DETAILS 42619
#define IDS_CERT_ERROR_NON_UNIQUE_NAME_DESCRIPTION 42620
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DETAILS 42621
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DESCRIPTION 42622
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DETAILS 42623
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DESCRIPTION 42624
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DETAILS 42625
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DESCRIPTION 42626
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DETAILS 42627
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DESCRIPTION 42628
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DETAILS 42629
#define IDS_ALWAYS_ALLOW_ADS 42630
#define IDS_BLOCKED_ADS_PROMPT_EXPLANATION 42631
#define IDS_BLOCKED_ADS_PROMPT_TITLE 42632
#define IDS_BLOCK_INTERSTITIAL_TITLE 42639
#define IDS_CHILD_BLOCK_INTERSTITIAL_HEADER 42640
#define IDS_BLOCK_INTERSTITIAL_HEADER_ACCESS_REQUESTS_DISABLED 42641
#define IDS_CHILD_BLOCK_INTERSTITIAL_MESSAGE_V2 42642
#define IDS_CHILD_BLOCK_INTERSTITIAL_MESSAGE_NOT_SIGNED_IN 42643
#define IDS_REQUEST_SENT_OK 42644
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_BUTTON 42645
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_INSTEAD_BUTTON 42646
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_A_MESSAGE_BUTTON 42647
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_MESSAGE 42648
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_SINGLE_PARENT 42649
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_MULTI_PARENT 42650
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_SINGLE_PARENT 42651
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_MULTI_PARENT 42652
#define IDS_BLOCK_INTERSTITIAL_SHOW_DETAILS 42653
#define IDS_BLOCK_INTERSTITIAL_HIDE_DETAILS 42654
#define IDS_GENERIC_SITE_BLOCK_HEADER 42655
#define IDS_SUPERVISED_USER_BLOCK_HEADER 42656
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_SINGLE_PARENT 42657
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_MULTI_PARENT 42658
#define IDS_SUPERVISED_USER_BLOCK_MESSAGE_SAFE_SITES 42659
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_SINGLE_PARENT 42660
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_MULTI_PARENT 42661
#define IDS_SUPERVISED_USER_VERIFY_PAGE_TAB_TITLE 42662
#define IDS_SUPERVISED_USER_VERIFY_PAGE_PRIMARY_HEADING 42663
#define IDS_SUPERVISED_USER_VERIFY_PAGE_PRIMARY_PARAGRAPH 42664
#define IDS_SUPERVISED_USER_VERIFY_PAGE_PRIMARY_BUTTON 42665
#define IDS_SUPERVISED_USER_VERIFY_PAGE_SUBFRAME_YOUTUBE_HEADING 42666
#define IDS_SUPERVISED_USER_VERIFY_PAGE_SUBFRAME_BLOCKED_SITE_HEADING 42667
#define IDS_PARENT_WEBSITE_APPROVAL_BLOCK_ALL_URL 42668
#define IDS_PARENT_WEBSITE_APPROVAL_SAFE_SITES_URL 42669
#define IDS_PARENT_WEBSITE_APPROVAL_MANUAL_URL 42670
#define IDS_SYNC_BASIC_ENCRYPTION_DATA 42671
#define IDS_SYNC_DATATYPE_AUTOFILL 42672
#define IDS_SYNC_DATATYPE_BOOKMARKS 42673
#define IDS_SYNC_DATATYPE_PASSWORDS 42674
#define IDS_SYNC_DATATYPE_PREFERENCES 42675
#define IDS_SYNC_DATATYPE_TABS 42676
#define IDS_SYNC_DATATYPE_TYPED_URLS 42677
#define IDS_SYNC_DATATYPE_HISTORY_AND_TABS 42678
#define IDS_SYNC_DATATYPE_READING_LIST 42679
#define IDS_SYNC_EMPTY_PASSPHRASE_ERROR 42680
#define IDS_SYNC_ENCRYPTION_SECTION_TITLE 42681
#define IDS_SYNC_FULL_ENCRYPTION_DATA 42682
#define IDS_SYNC_LOGIN_SETTING_UP 42683
#define IDS_SYNC_PASSPHRASE_LABEL 42684
#define IDS_SYNC_PASSPHRASE_MISMATCH_ERROR 42685
#define IDS_SYNC_ENTER_PASSPHRASE_BODY_WITH_DATE 42686
#define IDS_SYNC_ENTER_PASSPHRASE_BODY 42687
#define IDS_BULK_UPLOAD_SUBTITLE 42688
#define IDS_BULK_UPLOAD_BOOKMARK_FOLDER_SUBTITLE 42689
#define IDS_TAB_GROUP_COLOR_GREY 42690
#define IDS_TAB_GROUP_COLOR_BLUE 42691
#define IDS_TAB_GROUP_COLOR_RED 42692
#define IDS_TAB_GROUP_COLOR_YELLOW 42693
#define IDS_TAB_GROUP_COLOR_GREEN 42694
#define IDS_TAB_GROUP_COLOR_PINK 42695
#define IDS_TAB_GROUP_COLOR_PURPLE 42696
#define IDS_TAB_GROUP_COLOR_CYAN 42697
#define IDS_TAB_GROUP_COLOR_ORANGE 42698
#define IDS_TAB_RESUME_DECORATORS_VISITED_X_AGO 42699
#define IDS_TAB_RESUME_DECORATORS_VISITED_RECENTLY 42700
#define IDS_TAB_RESUME_DECORATORS_FREQUENTLY_VISITED 42701
#define IDS_TAB_RESUME_DECORATORS_CONTINUE_READING 42702
#define IDS_TAB_RESUME_DECORATORS_MOST_RECENT 42703
#define IDS_TAB_RESUME_DECORATORS_TIME_OF_DAY 42704
#define IDS_TAB_RESUME_DECORATORS_VISITED_X_AGO_IOS 42705
#define IDS_TAB_RESUME_DECORATORS_VISITED_RECENTLY_IOS 42706
#define IDS_TAB_RESUME_DECORATORS_FREQUENTLY_VISITED_IOS 42707
#define IDS_TAB_RESUME_DECORATORS_MOST_RECENT_IOS 42708
#define IDS_TAB_RESUME_N_MINUTES_AGO_NARROW 42709
#define IDS_TAB_RESUME_N_HOURS_AGO_NARROW 42710
#define IDS_TRANSLATE_NOTIFICATION_UNDO 42726
#define IDS_TRANSLATE_DETECTED_LANGUAGE 42727
#define IDS_BOOKMARK_BAR_UNDO 42728
#define IDS_BOOKMARK_BAR_REDO 42729
#define IDS_BOOKMARK_BAR_UNDO_ADD 42730
#define IDS_BOOKMARK_BAR_REDO_ADD 42731
#define IDS_BOOKMARK_BAR_UNDO_DELETE 42732
#define IDS_BOOKMARK_BAR_REDO_DELETE 42733
#define IDS_BOOKMARK_BAR_UNDO_EDIT 42734
#define IDS_BOOKMARK_BAR_REDO_EDIT 42735
#define IDS_BOOKMARK_BAR_UNDO_MOVE 42736
#define IDS_BOOKMARK_BAR_REDO_MOVE 42737
#define IDS_BOOKMARK_BAR_UNDO_REORDER 42738
#define IDS_BOOKMARK_BAR_REDO_REORDER 42739
#define IDS_CLOSE_TUTORIAL 42740
#define IDS_CLOSE_PROMO 42741
#define IDS_PROMO_DISMISS_BUTTON 42742
#define IDS_PROMO_SNOOZE_BUTTON 42743
#define IDS_PROMO_SHOW_TUTORIAL_BUTTON 385
#define IDS_TUTORIAL_RESTART_TUTORIAL 42744
#define IDS_PROMO_LEARN_MORE_BUTTON 42745
#define IDS_TUTORIAL_CLOSE_TUTORIAL 42746
#define IDS_TUTORIAL_NEXT_BUTTON 42747
#define IDS_VERSION_UI_TITLE 42748
#define IDS_VERSION_UI_OFFICIAL 42749
#define IDS_VERSION_UI_UNOFFICIAL 42750
#define IDS_VERSION_UI_32BIT 42751
#define IDS_VERSION_UI_64BIT 42752
#define IDS_VERSION_UI_64BIT_ARM 42755
#define IDS_VERSION_UI_32BIT_TRANSLATED_INTEL 42756
#define IDS_VERSION_UI_64BIT_TRANSLATED_INTEL 42754
#define IDS_VERSION_UI_REVISION 42757
#define IDS_VERSION_UI_OS 42758
#define IDS_VERSION_UI_USER_AGENT 42760
#define IDS_VERSION_UI_COMMAND_LINE 42761
#define IDS_VERSION_UI_COPY_LABEL 42765
#define IDS_VERSION_UI_COPY_NOTICE 42766
#define IDS_VERSION_UI_EXECUTABLE_PATH 42767
#define IDS_VERSION_UI_PROFILE_PATH 42768
#define IDS_VERSION_UI_MODULE_PATH 42769
#define IDS_VERSION_UI_USER_DATA_PATH 42770
#define IDS_VERSION_UI_PATH_NOTFOUND 42771
#define IDS_VERSION_UI_VARIATIONS 42772
#define IDS_VERSION_UI_VARIATIONS_SEED_NAME 42773
#define IDS_VERSION_UI_VARIATIONS_CMD 42774
#define IDS_VERSION_UI_COPY_VARIATIONS_LABEL 42775
#define IDS_VERSION_UI_COPY_VARIATIONS_NOTICE 42776
#define IDS_VERSION_UI_COHORT_NAME 42777
#define IDS_COLLABORATION_SIGNIN_TITLE 42781
#define IDS_COLLABORATION_SIGNIN_DESCRIPTION 42782
#define IDS_COLLABORATION_SIGNIN_BOTTOM_SHEET_TITLE 42783
#define IDS_COLLABORATION_SIGNIN_BOTTOM_SHEET_DESCRIPTION 42784
#define IDS_COLLABORATION_SIGNIN_SYNC_DISMISS 42785
#define IDS_COLLABORATION_SYNC_TITLE 42786
#define IDS_COLLABORATION_SYNC_DESCRIPTION 42787
#define IDS_COLLABORATION_ONE_GROUP_REMOVED_NOTIFICATION 42788
#define IDS_COLLABORATION_TWO_GROUPS_REMOVED_NOTIFICATION 42789
#define IDS_COLLABORATION_SEVERAL_GROUPS_REMOVED_NOTIFICATION 42790
#define IDS_COLLABORATION_SOMETHING_WENT_WRONG_HEADER 42791
#define IDS_COLLABORATION_SOMETHING_WENT_WRONG_BODY 42792
#define IDS_DATA_SHARING_RECENT_ACTIVITY_USER_SELF 42796
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_ADDED 42797
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_REMOVED 42798
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_UPDATED 42799
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_GROUP_NAME_UPDATED 42800
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TAB_GROUP_COLOR_UPDATED 42801
#define IDS_DATA_SHARING_RECENT_ACTIVITY_USER_JOINED_GROUP 42802
#define IDS_DATA_SHARING_RECENT_ACTIVITY_USER_LEFT_GROUP 42803
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TIME_DELTA 42804
#define IDS_DATA_SHARING_RECENT_ACTIVITY_SEPARATOR 42805
#define IDS_DATA_SHARING_RECENT_ACTIVITY_DESCRIPTION_FULL 42806
#define IDS_DATA_SHARING_RECENT_ACTIVITY_EMPTY 42807
#define IDS_CARDBOARD_PRODUCT_SAFETY 42850
#define IDS_USE_ANOTHER_DEVICE 42851
#define IDS_VR_MENU 42852
#define IDS_CANCEL 505
#define IDS_CLOSE 42853
#define IDS_CLEAR 42854
#define IDS_DONE 483
#define IDS_LEARN_MORE 423
#define IDS_OK 571
#define IDS_RELOAD 42855
#define IDS_ADD 42856
#define IDS_REMOVE 42857
#define IDS_SAVE 42858
#define IDS_MENU 42859
#define IDS_INSTALL 42860
#define IDS_UPDATE 42861
#define IDS_NO_THANKS 42864
#define IDS_NOT_NOW 42865
#define IDS_TURN_OFF 42866
#define IDS_PLUGIN_NOT_SUPPORTED 42867
#define IDS_PRINT 42868
#define IDS_RECENT_TABS 42869
#define IDS_RECENTLY_CLOSED 42870
#define IDS_YOUR_DEVICES 42871
#define IDS_CHOOSE 42872
#define IDS_ACCNAME_BACK 410
#define IDS_ACCNAME_FORWARD 413
#define IDS_ACCNAME_OK 42873
#define IDS_ACCNAME_CANCEL 42874
#define IDS_ACCNAME_DONE 42875
#define IDS_ACCNAME_SAVE 42876
#define IDS_ACCNAME_CLOSE 674
#define IDS_ACCNAME_OPEN 42877
#define IDS_ACCNAME_OPEN_IN_NEW_TAB 42878
#define IDS_ACCNAME_PREVIOUS 42879
#define IDS_ACCNAME_NEXT 42880
#define IDS_ACCNAME_LOCATION 473
#define IDS_ACCNAME_TAB_LIST 42881
#define IDS_UTILITY_PROCESS_JSON_PARSER_NAME 42882
#define IDS_SESSION_CRASHED_VIEW_RESTORE_BUTTON 42883
#define IDS_SESSION_CRASHED_VIEW_STARTUP_PAGES_BUTTON 42884
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_PRIVACY 42885
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_SAFETY_CHECK 42886
#define IDS_PATCH_SERVICE_DISPLAY_NAME 42887
#define IDS_PASSWORD_MANAGER_CSV_PASSWORD_PARSER_SERVICE_DISPLAY_NAME 42888
#define IDS_UNZIP_SERVICE_DISPLAY_NAME 42889
#define IDS_INTERNAL_DEBUG_PAGES_DISABLED_HEADING 42890

// ---------------------------------------------------------------------------
// From extensions_strings.h:

#define IDS_EXTENSION_BAD_FILE_ENCODING 49610
#define IDS_EXTENSION_CANT_GET_ABSOLUTE_PATH 49611
#define IDS_EXTENSION_CONTAINS_PRIVATE_KEY 49612
#define IDS_EXTENSION_CRX_EXISTS 49613
#define IDS_EXTENSION_CONTENT_SCRIPT_FILE_TOO_LARGE 49614
#define IDS_EXTENSION_DIRECTORY_NO_EXISTS 49615
#define IDS_EXTENSION_ERROR_WHILE_SIGNING 49616
#define IDS_EXTENSION_FAILED_DURING_PACKAGING 49617
#define IDS_EXTENSION_LOAD_ABOUT_PAGE_FAILED 49618
#define IDS_EXTENSION_LOAD_BACKGROUND_SCRIPT_FAILED 49619
#define IDS_EXTENSION_LOAD_BACKGROUND_PAGE_FAILED 49620
#define IDS_EXTENSION_LOAD_CSS_FAILED 49621
#define IDS_EXTENSION_LOAD_JAVASCRIPT_FAILED 49622
#define IDS_EXTENSION_LOAD_OPTIONS_PAGE_FAILED 49623
#define IDS_EXTENSION_LOCALES_NO_DEFAULT_LOCALE_SPECIFIED 49624
#define IDS_EXTENSION_MANIFEST_UNREADABLE 49625
#define IDS_EXTENSION_MANIFEST_INVALID 49626
#define IDS_EXTENSION_PACKAGE_IMAGE_ERROR 49627
#define IDS_EXTENSION_PACKAGE_UNZIP_ERROR 49628
#define IDS_EXTENSION_PRIVATE_KEY_EXISTS 49629
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_READ 49630
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_EXPORT 49631
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_GENERATE 49632
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_OUTPUT 49633
#define IDS_EXTENSION_PRIVATE_KEY_INVALID 49634
#define IDS_EXTENSION_PRIVATE_KEY_NO_EXISTS 49635
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_PATH 49636
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_FORMAT 49637
#define IDS_EXTENSION_PUBLIC_KEY_FAILED_TO_EXPORT 49638
#define IDS_EXTENSION_SHARING_VIOLATION 49639
#define IDS_EXTENSION_CANT_INSTALL_POLICY_BLOCKED 49640
#define IDS_EXTENSION_CANT_MODIFY_POLICY_REQUIRED 49641
#define IDS_EXTENSION_CANT_UNINSTALL_POLICY_REQUIRED 49642
#define IDS_EXTENSION_MANIFEST_VERSION_NOT_SUPPORTED 49643
#define IDS_DEVICE_NAME_WITH_PRODUCT_SERIAL 49644
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR 49645
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR_SERIAL 49646
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR 49647
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR_SERIAL 49648
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR 49649
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR_SERIAL 49650
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR 49651
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR_SERIAL 49652
#define IDS_DEVICE_PERMISSIONS_PROMPT_SINGLE_SELECTION 49653
#define IDS_DEVICE_PERMISSIONS_PROMPT_MULTIPLE_SELECTION 49654
#define IDS_CAMERA_FACING_USER 49655
#define IDS_CAMERA_FACING_ENVIRONMENT 49656
#define IDS_EXTENSION_USB_DEVICE_PRODUCT_NAME_AND_VENDOR 49657
#define IDS_EXTENSION_TASK_MANAGER_APPVIEW_TAG_PREFIX 49658
#define IDS_EXTENSION_TASK_MANAGER_EXTENSIONOPTIONS_TAG_PREFIX 49659
#define IDS_EXTENSION_TASK_MANAGER_MIMEHANDLERVIEW_TAG_PREFIX 49660
#define IDS_EXTENSION_TASK_MANAGER_WEBVIEW_TAG_PREFIX 49661
#define IDS_EXTENSION_WARNINGS_NETWORK_DELAY 49662
#define IDS_EXTENSION_WARNINGS_DOWNLOAD_FILENAME_CONFLICT 49663
#define IDS_EXTENSION_WARNING_RELOAD_TOO_FREQUENT 49664
#define IDS_EXTENSION_WARNING_RULESET_FAILED_TO_LOAD 49665
#define IDS_EXTENSION_WARNING_ENABLED_RULE_COUNT_EXCEEDED 49666
#define IDS_EXTENSION_INSTALL_PROCESS_CRASHED 49667
#define IDS_EXTENSION_PACKAGE_ERROR_CODE 49668
#define IDS_EXTENSION_PACKAGE_ERROR_MESSAGE 49669
#define IDS_EXTENSION_PACKAGE_INSTALL_ERROR 49670
#define IDS_EXTENSION_WEBGL_NOT_SUPPORTED 49671

// ---------------------------------------------------------------------------
// From generated_resources.h:

#define IDS_ACCESS_CODE_CAST_ACCESS_CODE_MESSAGE 1600
#define IDS_ACCESS_CODE_CAST_BACK 1601
#define IDS_ACCESS_CODE_CAST_CAST 1602
#define IDS_ACCESS_CODE_CAST_CONNECT 1603
#define IDS_ACCESS_CODE_CAST_DIALOG_TITLE 1604
#define IDS_ACCESS_CODE_CAST_ENTER_CHARACTER 1605
#define IDS_ACCESS_CODE_CAST_ERROR_ACCESS_CODE 1606
#define IDS_ACCESS_CODE_CAST_ERROR_DIFFERENT_NETWORK 1607
#define IDS_ACCESS_CODE_CAST_ERROR_NETWORK 1608
#define IDS_ACCESS_CODE_CAST_ERROR_PERMISSION 1609
#define IDS_ACCESS_CODE_CAST_ERROR_TOO_MANY_REQUESTS 1610
#define IDS_ACCESS_CODE_CAST_ERROR_UNKNOWN 1611
#define IDS_ACCESS_CODE_CAST_ERROR_PROFILE_SYNC 1612
#define IDS_ACCESS_CODE_CAST_INPUT_ARIA_LABEL 1613
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_DAYS 1614
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_HOURS 1615
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_MONTHS 1616
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_YEARS 1617
#define IDS_ACCESS_CODE_CAST_SUBMIT 1618
#define IDS_ACCESS_CODE_CAST_USE_CAMERA 1619
#define IDS_APP_MANAGEMENT_CAMERA 1620
#define IDS_APP_MANAGEMENT_LOCATION 1621
#define IDS_APP_MANAGEMENT_MICROPHONE 1622
#define IDS_APP_MANAGEMENT_NO_APPS_FOUND 1623
#define IDS_APP_MANAGEMENT_NOTIFICATIONS 1624
#define IDS_APP_MANAGEMENT_PERMISSIONS 1626
#define IDS_APP_MANAGEMENT_PERMISSIONS_WITH_ORIGIN 1627
#define IDS_APP_MANAGEMENT_MORE_SETTINGS 1628
#define IDS_APP_MANAGEMENT_PIN_TO_SHELF 1629
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES 1630
#define IDS_APP_MANAGEMENT_WINDOW 1631
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES_TEXT 1632
#define IDS_APP_MANAGEMENT_PRINTING 1633
#define IDS_APP_MANAGEMENT_SEARCH_PROMPT 1634
#define IDS_APP_MANAGEMENT_UNINSTALL_APP 1635
#define IDS_APP_MANAGEMENT_CONTACTS 1636
#define IDS_APP_MANAGEMENT_STORAGE 1637
#define IDS_APP_MANAGEMENT_RUN_ON_OS_LOGIN 1638
#define IDS_APP_MANAGEMENT_POLICY_APP_POLICY_STRING 1639
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_TITLE 1640
#define IDS_APP_MANAGEMENT_INTENT_SHARING_APP_OPEN 1641
#define IDS_APP_MANAGEMENT_INTENT_SHARING_BROWSER_OPEN 1642
#define IDS_APP_MANAGEMENT_INTENT_SHARING_TAB_EXPLANATION 1643
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_DIALOG_TITLE 1644
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_CHANGE_BUTTON 1645
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TITLE 1646
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_1_APP 1647
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_2_APPS 1648
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_3_APPS 1649
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_4_APPS 1650
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_5_OR_MORE_APPS 1651
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_1_APP 1652
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_2_APPS 1653
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_3_APPS 1654
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_4_APPS 1655
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_5_OR_MORE_APPS 1656
#define IDS_APP_MANAGEMENT_APP_DETAILS_TITLE 1657
#define IDS_APP_MANAGEMENT_APP_DETAILS_TOOLTIP_WEB_A11Y 1658
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_WEB_STORE 1659
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_PLAY_STORE 1660
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_BROWSER 1661
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_AND_SOURCE_COMBINED 1662
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_AND_SOURCE_PREINSTALLED_APP 1663
#define IDS_APP_MANAGEMENT_APP_DETAILS_VERSION 1664
#define IDS_APP_MANAGEMENT_APP_DETAILS_STORAGE_TITLE 1665
#define IDS_APP_MANAGEMENT_APP_DETAILS_APP_SIZE 1666
#define IDS_APP_MANAGEMENT_APP_DETAILS_DATA_SIZE 1667
#define IDS_APP_MANAGEMENT_APP_LANGUAGE_LABEL 1668
#define IDS_APP_MANAGEMENT_ARC_MANAGE_PERMISSIONS 1669
#define IDS_APP_MANAGEMENT_PERMISSION_ASK 1670
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED 1671
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_WITH_DETAILS 1672
#define IDS_APP_MANAGEMENT_PERMISSION_DENIED 1673
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_TURN_ON_SYSTEM_CAMERA_ACCESS_BUTTON 1674
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_TURN_ON_SYSTEM_MICROPHONE_ACCESS_BUTTON 1675
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_TURN_ON_SYSTEM_LOCATION_ACCESS_BUTTON 1676
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_DETAILS_AND_TURN_ON_SYSTEM_CAMERA_ACCESS_BUTTON 1677
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_DETAILS_AND_TURN_ON_SYSTEM_MICROPHONE_ACCESS_BUTTON 1678
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_TEXT_WITH_DETAILS_AND_TURN_ON_SYSTEM_LOCATION_ACCESS_BUTTON 1679
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_CAMERA_CONNECTED_TEXT 1680
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_MICROPHONE_CONNECTED_TEXT 1681
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_CAMERA_CONNECTED_TEXT_WITH_DETAILS 1682
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_NO_MICROPHONE_CONNECTED_TEXT_WITH_DETAILS 1683
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_MICROPHONE_HW_SWITCH_ACTIVE_TEXT 1684
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_BUT_MICROPHONE_HW_SWITCH_ACTIVE_TEXT_WITH_DETAILS 1685
#define IDS_APP_MANAGEMENT_FILE_HANDLING_HEADER 1686
#define IDS_APP_MANAGEMENT_FILE_HANDLING_OVERFLOW_DIALOG_TITLE 1687
#define IDS_APP_MANAGEMENT_FILE_HANDLING_SET_DEFAULTS_LINK 1688
#define IDS_APP_MANAGEMENT_FILE_HANDLING_TYPES 1689
#define IDS_APP_MANAGEMENT_SUB_APPS_LIST_HEADING 1690
#define IDS_APP_MANAGEMENT_PARENT_APP_PERMISSION_EXPLANATION 1691
#define IDS_APP_MANAGEMENT_SUB_APP_PERMISSION_EXPLANATION 1692
#define IDS_APP_MANAGEMENT_APP_CONTENT_TITLE 1693
#define IDS_APP_MANAGEMENT_APP_CONTENT_SUBTITLE 1694
#define IDS_APP_MANAGEMENT_APP_CONTENT_DIALOG_SUBTITLE 1695
#define IDS_BOOKMARK_GROUP_FROM_IE 1696
#define IDS_BOOKMARK_GROUP_FROM_EDGE 1697
#define IDS_BOOKMARK_GROUP_FROM_FIREFOX 1698
#define IDS_BOOKMARK_GROUP_FROM_SAFARI 1699
#define IDS_BOOKMARK_GROUP 1700
#define IDS_UNNAMED_BOOKMARK_BUTTON_ACCESSIBLE_NAME 1701
#define IDS_BOOKMARK_BAR_SHOW_APPS_SHORTCUT 1702
#define IDS_BOOKMARK_BAR_SHOW_TAB_GROUPS 1703
#define IDS_BOOKMARK_BAR_SHOW_READING_LIST 1704
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS_DEFAULT_NAME 1705
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS 1706
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_NAME 675
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_TOOLTIP 676
#define IDS_BOOKMARK_BAR_OVERFLOW_BUTTON_TOOLTIP 683
#define IDS_BOOKMARK_BAR_OPEN_ALL 1707
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT 1708
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_WINDOW 1709
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_INCOGNITO 1710
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_TAB_GROUP 1711
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_TAB 1712
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_WINDOW 1713
#define IDS_BOOKMARK_BAR_OPEN_INCOGNITO 1714
#define IDS_BOOKMARK_BAR_EDIT 1715
#define IDS_BOOKMARK_BAR_RENAME_FOLDER 1716
#define IDS_BOOKMARK_BAR_REMOVE 1717
#define IDS_BOOKMARK_BAR_ADD_NEW_BOOKMARK 1718
#define IDS_BOOKMARK_BAR_NEW_FOLDER 1719
#define IDS_SHOW_BOOKMARK_BAR 1720
#define IDS_HIDE_BOOKMARK_BAR 1721
#define IDS_BOOKMARK_BAR_SHOULD_OPEN_ALL 1722
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARKED 1723
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARK 1724
#define IDS_BOOKMARK_BUBBLE_EDIT_BOOKMARK 1725
#define IDS_BOOKMARK_BUBBLE_NAME_LABEL 1726
#define IDS_BOOKMARK_BUBBLE_SAVED_TO 1727
#define IDS_BOOKMARK_AX_BUBBLE_NAME_LABEL 1728
#define IDS_BOOKMARK_BUBBLE_FOLDER_LABEL 1729
#define IDS_BOOKMARK_AX_BUBBLE_FOLDER_LABEL 1730
#define IDS_BOOKMARK_BUBBLE_OPTIONS 1731
#define IDS_BOOKMARK_BUBBLE_CHOOSER_ANOTHER_FOLDER 1732
#define IDS_BOOKMARK_DICE_PROMO_SYNC_MESSAGE 1733
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE 1734
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE_V2 1735
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE_V3 1736
#define IDS_BOOKMARK_FOOTNOTE_DESKTOP_TO_IOS_PROMO_MESSAGE 1737
#define IDS_BOOKMARK_EDITOR_NAME_LABEL 1738
#define IDS_BOOKMARK_AX_EDITOR_NAME_LABEL 1739
#define IDS_BOOKMARK_AX_EDITOR_URL_LABEL 1741
#define IDS_BOOKMARK_EDITOR_URL_LABEL 1742
#define IDS_BOOKMARK_EDITOR_CONFIRM_DELETE 1743
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_BUTTON 1744
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_MENU_ITEM 1745
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE 1746
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE_NEW 1747
#define IDS_UNNAMED_BOOKMARK_FOLDER 678
#define IDS_BOOKMARK_ALL_TABS_DIALOG_TITLE 1748
#define IDS_BOOKMARK_MANAGER_TITLE 396
#define IDS_BOOKMARK_MANAGER_SEARCH_BUTTON 1749
#define IDS_BOOKMARK_MANAGER 1750
#define IDS_BOOKMARK_MANAGER_ORGANIZE_MENU 1751
#define IDS_BOOKMARK_MANAGER_INVALID_URL 1752
#define IDS_EXPORT_BOOKMARKS_DEFAULT_FILENAME 1753
#define IDS_BOOKMARK_MANAGER_ADD_BOOKMARK_TITLE 1754
#define IDS_BOOKMARK_MANAGER_ADD_FOLDER_TITLE 1755
#define IDS_BOOKMARK_MANAGER_CLEAR_SEARCH 1756
#define IDS_BOOKMARK_MANAGER_EMPTY_LIST 1757
#define IDS_BOOKMARK_MANAGER_EMPTY_UNMODIFIABLE_LIST 1758
#define IDS_BOOKMARK_MANAGER_FOLDER_LABEL 1759
#define IDS_BOOKMARK_MANAGER_FOLDER_RENAME_TITLE 1760
#define IDS_BOOKMARK_MANAGER_FOLDER_LIST_CHANGED 1761
#define IDS_BOOKMARK_MANAGER_LIST_AX_LABEL 1762
#define IDS_BOOKMARK_MANAGER_MENU_ADD_BOOKMARK 1763
#define IDS_BOOKMARK_MANAGER_MENU_ADD_FOLDER 1764
#define IDS_BOOKMARK_MANAGER_MENU_CUT 1765
#define IDS_BOOKMARK_MANAGER_MENU_COPY 1766
#define IDS_BOOKMARK_MANAGER_MENU_PASTE 1767
#define IDS_BOOKMARK_MANAGER_MENU_EXPORT 1768
#define IDS_BOOKMARK_MANAGER_MENU_HELP_CENTER 1769
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT 1770
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_BEGAN 1771
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_ENDED 1772
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL 1773
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_WITH_COUNT 1774
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW 1775
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW_WITH_COUNT 1776
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO 1777
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO_WITH_COUNT 1778
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_TAB_GROUP_WITH_COUNT 1779
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB 1780
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_WINDOW 1781
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_INCOGNITO 1782
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB_GROUP 1783
#define IDS_BOOKMARK_MANAGER_MENU_RENAME 1784
#define IDS_BOOKMARK_MANAGER_MENU_SHOW_IN_FOLDER 1785
#define IDS_BOOKMARK_MANAGER_MENU_SORT 1786
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS 1787
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_AX_LABEL 1788
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_MULTI_AX_LABEL 1789
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_TITLE 1790
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_CONFIRM 1791
#define IDS_BOOKMARK_MANAGER_ITEMS_SELECTED 1792
#define IDS_BOOKMARK_MANAGER_ITEMS_UNSELECTED 1793
#define IDS_BOOKMARK_MANAGER_SIDEBAR_AX_LABEL 1794
#define IDS_BOOKMARK_MANAGER_TOAST_FOLDER_SORTED 1795
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_DELETED 1796
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_DELETED 1797
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_COPIED 1798
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_COPIED 1799
#define IDS_BOOKMARKS_MENU 1800
#define IDS_BOOKMARKS_AND_LISTS_MENU 1801
#define IDS_SHOW_BOOKMARK_SIDE_PANEL 1802
#define IDS_BOOKMARK_THIS_TAB 1803
#define IDS_BOOKMARK_ALL_TABS 1804
#define IDS_BOOKMARKS_LIST_TITLE 1805
#define IDS_TOOLTIP_STARRED 1806
#define IDS_BOOKMARK_SCREEN_READER_CREATED 1807
#define IDS_BOOKMARK_SCREEN_READER_FOLDER_CREATED 1808
#define IDS_BOOKMARK_SCREEN_READER_REORDERED 1809
#define IDS_BOOKMARK_SCREEN_READER_MOVED 1810
#define IDS_GLOBAL_MEDIA_CONTROLS_ICON_TOOLTIP_TEXT 430
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL_WITH_COLON 1811
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL 1812
#define IDS_GLOBAL_MEDIA_CONTROLS_STOP_CASTING_BUTTON_LABEL 1813
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_ENGLISH_ONLY 1814
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION 1815
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_SHOW_LANGUAGE 1816
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_PROGRESS 1817
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR 1818
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 1819
#define IDS_GLOBAL_MEDIA_CONTROLS_CAPTION_SETTINGS 1820
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_TRANSLATE_TARGET_LANGUAGE_ACCNAME 1821
#define IDS_GLOBAL_MEDIA_CONTROLS_DIALOG_NAME 1822
#define IDS_GLOBAL_MEDIA_CONTROLS_SHOW_DEVICE_LIST 1823
#define IDS_GLOBAL_MEDIA_CONTROLS_HIDE_DEVICE_LIST 1824
#define IDS_GLOBAL_MEDIA_CONTROLS_CONTROL_CAST_SESSIONS_PROMO 1825
#define IDS_GMC_LOCAL_MEDIA_CAST_SESSIONS_PROMO 1826
#define IDS_GMC_LOCAL_MEDIA_CAST_START_PROMO 1827
#define IDS_MEDIA_TOOLBAR_CONTEXT_REPORT_CAST_ISSUE 427
#define IDS_MEDIA_TOOLBAR_CONTEXT_SHOW_OTHER_SESSIONS 429
#define IDS_MEDIA_PREVIEW_CAMERA_ACCESSIBLE_NAME 1828
#define IDS_MEDIA_PREVIEW_VIDEO_STREAM_ACCESSIBLE_NAME 1829
#define IDS_MEDIA_PREVIEW_NO_CAMERAS_FOUND 1830
#define IDS_MEDIA_PREVIEW_NO_CAMERAS_FOUND_COMBOBOX 1831
#define IDS_MEDIA_PREVIEW_VIDEO_STREAM_PREVIEW_BADGE 1832
#define IDS_MEDIA_PREVIEW_MIC_ACCESSIBLE_NAME 1833
#define IDS_MEDIA_PREVIEW_AUDIO_STREAM_ACCESSIBLE_NAME 1834
#define IDS_MEDIA_PREVIEW_NO_MICS_FOUND 1835
#define IDS_MEDIA_PREVIEW_NO_MICS_FOUND_COMBOBOX 1836
#define IDS_MEDIA_PREVIEW_SYSTEM_DEFAULT_MIC 1837
#define IDS_MEDIA_PREVIEW_SYSTEM_DEFAULT_MIC_PARENTHETICAL 1838
#define IDS_MEDIA_PREVIEW_ANNOUNCE_SELECTED_DEVICE_CHANGE 1839
#define IDS_MEDIA_ROUTER_ICON_TOOLTIP_TEXT 428
#define IDS_MEDIA_ROUTER_MENU_ITEM_TITLE 1840
#define IDS_MEDIA_ROUTER_PRESENTATION_CAST_MODE 1841
#define IDS_MEDIA_ROUTER_DESKTOP_MIRROR_CAST_MODE 1842
#define IDS_MEDIA_ROUTER_TAB_MIRROR_CAST_MODE 1843
#define IDS_MEDIA_ROUTER_ALTERNATIVE_SOURCES_BUTTON 1844
#define IDS_MEDIA_ROUTER_ABOUT 422
#define IDS_MEDIA_ROUTER_HELP 424
#define IDS_MEDIA_ROUTER_ALWAYS_SHOW_TOOLBAR_ACTION 425
#define IDS_MEDIA_ROUTER_SHOWN_BY_POLICY 1845
#define IDS_MEDIA_ROUTER_TOGGLE_MEDIA_REMOTING 426
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_WITH_HOSTNAME 1846
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT 1847
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_DESKTOP 1848
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_TAB 1849
#define IDS_MEDIA_ROUTER_ISSUE_UNABLE_TO_CAST_DESKTOP 1850
#define IDS_MEDIA_ROUTER_ISSUE_TAB_AUDIO_NOT_SUPPORTED 1851
#define IDS_MEDIA_ROUTER_ISSUE_DESKTOP_AUDIO_NOT_SUPPORTED 1852
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_PENDING_AUTHORIZATION 1854
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_NOT_ALLOWED 1855
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_NOTIFICATION_DISABLED 1856
#define IDS_MEDIA_ROUTER_ISSUE_FAILED_TO_CAST 1857
#define IDS_MEDIA_ROUTER_ISSUE_CANNOT_TERMINATE 1858
#define IDS_MEDIA_ROUTER_STATUS_LOOKING_FOR_DEVICES 1859
#define IDS_MEDIA_ROUTER_STATUS_NO_DEVICES_FOUND 1860
#define IDS_MEDIA_ROUTER_NO_DEVICES_FOUND_BUTTON 1861
#define IDS_MEDIA_ROUTER_DESTINATION_MISSING 1862
#define IDS_MEDIA_ROUTER_LOCAL_DISCOVERY_PERMISSION_REJECTED_BUTTON 1863
#define IDS_MEDIA_ROUTER_LOCAL_DISCOVERY_PERMISSION_REJECTED_LABEL 1864
#define IDS_MEDIA_ROUTER_LOCAL_DISCOVERY_PERMISSION_REJECTED_LINK 1865
#define IDS_MEDIA_ROUTER_SINK_AVAILABLE 1866
#define IDS_MEDIA_ROUTER_SINK_CONNECTING 1867
#define IDS_MEDIA_ROUTER_SINK_DISCONNECTING 1868
#define IDS_MEDIA_ROUTER_SINK_PAUSED 1869
#define IDS_MEDIA_ROUTER_STOP_CASTING 1870
#define IDS_MEDIA_ROUTER_SOURCE_NOT_SUPPORTED 1871
#define IDS_MEDIA_ROUTER_AVAILABLE_SPECIFIC_SITES 1872
#define IDS_MEDIA_ROUTER_CASTING_DESKTOP 1873
#define IDS_MEDIA_ROUTER_CASTING_TAB 1874
#define IDS_MEDIA_ROUTER_PRESENTATION_ROUTE_DESCRIPTION 1875
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE 1876
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_GENERIC_ACCESSIBLE_NAME 1877
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_SCREEN_ACCESSIBLE_NAME 1878
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_TAB_ACCESSIBLE_NAME 1879
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME 1880
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_GENERIC_ACCESSIBLE_NAME 1881
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_SCREEN_ACCESSIBLE_NAME 1882
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_TAB_ACCESSIBLE_NAME 1883
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP 1884
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_GENERIC_ACCESSIBLE_NAME 1885
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_SCREEN_ACCESSIBLE_NAME 1886
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_TAB_ACCESSIBLE_NAME 1887
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_TITLE 1888
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_BODY_TEXT 1889
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CHECKBOX 1890
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_OPTIMIZE_BUTTON 1891
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON 1892
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON_MACOS 1893
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_DEPRECATED 1894
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_REMOVED 1895
#define IDS_MEDIA_ROUTER_WIRED_DISPLAY_SINK_NAME 1896
#define IDS_MEDIA_ROUTER_FEEDBACK_TITLE 1897
#define IDS_MEDIA_ROUTER_FEEDBACK_NA 1898
#define IDS_MEDIA_ROUTER_FEEDBACK_FORM_DESCRIPTION 1899
#define IDS_MEDIA_ROUTER_FEEDBACK_HEADER 1900
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_ANSWER 1901
#define IDS_MEDIA_ROUTER_FEEDBACK_REQUIRED 1902
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_QUESTION 1903
#define IDS_MEDIA_ROUTER_FEEDBACK_PROMPT 1904
#define IDS_MEDIA_ROUTER_FEEDBACK_MIRRORING_QUALITY_SUBHEADING 1905
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTHNESS 1906
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_QUALITY 1907
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_QUALITY 1908
#define IDS_MEDIA_ROUTER_FEEDBACK_CONTENT_QUESTION 1909
#define IDS_MEDIA_ROUTER_FEEDBACK_ADDITIONAL_COMMENTS 1910
#define IDS_MEDIA_ROUTER_FEEDBACK_ALLOW_CONTACT_BY_EMAIL 1911
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_EMAIL_ADDRESS 1912
#define IDS_MEDIA_ROUTER_FEEDBACK_EMAIL_FIELD 1913
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_BUTTON 1914
#define IDS_MEDIA_ROUTER_FEEDBACK_DISCARD_CONFIRMATION 1915
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_BUG_OR_ERROR 1916
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_FEATURE_REQUEST 1917
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_PROJECTION_QUALITY 1918
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_DISCOVERY 1919
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_OTHER 1920
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_FREEZES 1921
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_JERKY 1922
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_STUTTER 1923
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTH 1924
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_PERFECT 1925
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_UNWATCHABLE 1926
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_POOR 1927
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_ACCEPTABLE 1928
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GOOD 1929
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GREAT 1930
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_UNINTELLIGIBLE 1931
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_POOR 1932
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_ACCEPTABLE 1933
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_GOOD 1934
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_PERFECT 1935
#define IDS_MEDIA_ROUTER_FEEDBACK_SENDING 1936
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_FAIL 1937
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_SUCCESS 1938
#define IDS_MEDIA_ROUTER_FEEDBACK_RESENDING 1939
#define IDS_MEDIA_ROUTER_FEEDBACK_LOGS_HEADER 1940
#define IDS_MEDIA_ROUTER_FEEDBACK_FINE_LOGS_WARNING 1941
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS_HTML 1942
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS 1943
#define IDS_MEDIA_ROUTER_FEEDBACK_PRIVACY_DATA_USAGE 1944
#define IDS_MEDIA_ROUTER_FEEDBACK_SETUP_VISIBILITY_QUESTION 1945
#define IDS_MEDIA_ROUTER_FEEDBACK_YES 1946
#define IDS_MEDIA_ROUTER_FEEDBACK_NO 1947
#define IDS_MEDIA_ROUTER_FEEDBACK_DID_NOT_TRY 1948
#define IDS_MEDIA_ROUTER_FEEDBACK_SOFTWARE_QUESTION 1949
#define IDS_MEDIA_ROUTER_FEEDBACK_UNKNOWN 1950
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_QUESTION 1951
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_SAME_WIFI 1952
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_DIFFERENT_WIFI 1953
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_WIRED_PC 1954
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_CAST_SCREEN 1955
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_PAUSED 1956
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_CAN_PAUSE 1957
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_PAUSED 1958
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_TAB_CAN_PAUSE 1959
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE 1960
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE_UNKNOWN 1961
#define IDS_AVATAR_BUTTON_GUEST 1962
#define IDS_AVATAR_BUTTON_GUEST_TOOLTIP 1963
#define IDS_GUEST_BUBBLE_ACCESSIBLE_TITLE 1964
#define IDS_INCOGNITO_BUBBLE_ACCESSIBLE_TITLE 1965
#define IDS_AVATAR_BUTTON_INCOGNITO 1966
#define IDS_AVATAR_BUTTON_INCOGNITO_TOOLTIP 1967
#define IDS_AVATAR_BUTTON_SYNC_ERROR 1968
#define IDS_AVATAR_BUTTON_SYNC_ERROR_TOOLTIP 1969
#define IDS_AVATAR_BUTTON_SYNC_PAUSED 1970
#define IDS_AVATAR_BUTTON_SIGNIN_PAUSED 1971
#define IDS_AVATAR_BUTTON_WORK 1972
#define IDS_AVATAR_BUTTON_SCHOOL 1973
#define IDS_AVATAR_BUTTON_GREETING 1974
#define IDS_PROFILES_MENU_NAME 1975
#define IDS_PROFILES_PROFILE_BUBBLE_ACCESSIBLE_TITLE 1978
#define IDS_PROFILES_EXIT_PROFILE_BUTTON 1979
#define IDS_PROFILES_ACCOUNT_REMOVAL_TITLE 1980
#define IDS_PROFILES_SYNC_COMPLETE_TITLE 1981
#define IDS_PROFILES_DICE_SIGNIN_BUTTON 1982
#define IDS_EXTENSIONS_EXPLICIT_SIGNIN_BUTTON_WITH_ACCOUNT_AWARENESS 1983
#define IDS_PROFILES_DICE_WEB_ONLY_SIGNIN_BUTTON 1984
#define IDS_PROFILES_DICE_NOT_SYNCING_TITLE 1985
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON 1986
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON_NO_NAME 1987
#define IDS_PROFILES_DICE_SYNC_DISABLED_TITLE 1988
#define IDS_PROFILES_DASHER_FEATURE_DISABLED_TITLE 1989
#define IDS_PROFILES_DICE_SYNC_PAUSED_TITLE 1990
#define IDS_PROFILES_CLOSE_X_WINDOWS_BUTTON 1991
#define IDS_PROFILES_SIGNIN_PROMO 1992
#define IDS_PROFILES_VERIFY_ACCOUNT_BUTTON 1993
#define IDS_PROFILES_CREDIT_CARDS_LINK 1994
#define IDS_PROFILES_ADDRESSES_LINK 1995
#define IDS_PROFILE_MENU_SIGNIN_PROMO_DESCRIPTION 1996
#define IDS_PROFILE_MENU_PROFILE_IDENTIFIER_WITH_SEPARATOR 1997
#define IDS_PROFILE_MENU_PROFILE_MANAGED_HEADER 1998
#define IDS_PROFILES_LIST_PROFILES_TITLE 1999
#define IDS_PROFILES_PROFILE_MANAGE_ACCOUNTS_BUTTON 2000
#define IDS_PROFILES_PROFILE_HIDE_MANAGE_ACCOUNTS_BUTTON 2001
#define IDS_PROFILE_MENU_OPEN_GUEST_PROFILE 2002
#define IDS_PROFILE_MENU_CLOSE_PROFILE_X_WINDOWS_BUTTON 2003
#define IDS_PROFILE_MENU_ADD_NEW_PROFILE 2004
#define IDS_PROFILES_OPEN_SYNC_SETTINGS_BUTTON 2005
#define IDS_PROFILE_MENU_CUSTOMIZE_PROFILE_BUTTON 2006
#define IDS_PROFILE_MENU_OPEN_ACCOUNT_SETTINGS 2007
#define IDS_PROFILE_MENU_AUTOFILL_SETTINGS_BUTTON 2008
#define IDS_PROFILES_MANAGED_BY 2009
#define IDS_PROFILES_MANAGE_PROFILES_BUTTON_TOOLTIP 2010
#define IDS_PROFILES_CUSTOMIZE_PROFILE_BUTTON_TOOLTIP 2011
#define IDS_PROFILES_GUEST_PROFILE_NAME 2012
#define IDS_DEFAULT_PROFILE_NAME 2013
#define IDS_LEGACY_DEFAULT_PROFILE_NAME 2014
#define IDS_NEW_NUMBERED_PROFILE_NAME 2015
#define IDS_SINGLE_PROFILE_DISPLAY_NAME 2016
#define IDS_GUEST_PROFILE_NAME 2017
#define IDS_DEFAULT_AVATAR_NAME_8 2018
#define IDS_DEFAULT_AVATAR_NAME_9 2019
#define IDS_DEFAULT_AVATAR_NAME_10 2020
#define IDS_DEFAULT_AVATAR_NAME_11 2021
#define IDS_DEFAULT_AVATAR_NAME_12 2022
#define IDS_DEFAULT_AVATAR_NAME_13 2023
#define IDS_DEFAULT_AVATAR_NAME_14 2024
#define IDS_DEFAULT_AVATAR_NAME_15 2025
#define IDS_DEFAULT_AVATAR_NAME_16 2026
#define IDS_DEFAULT_AVATAR_NAME_17 2027
#define IDS_DEFAULT_AVATAR_NAME_18 2028
#define IDS_DEFAULT_AVATAR_NAME_19 2029
#define IDS_DEFAULT_AVATAR_NAME_20 2030
#define IDS_DEFAULT_AVATAR_NAME_21 2031
#define IDS_DEFAULT_AVATAR_NAME_22 2032
#define IDS_DEFAULT_AVATAR_NAME_23 2033
#define IDS_DEFAULT_AVATAR_NAME_24 2034
#define IDS_DEFAULT_AVATAR_NAME_25 2035
#define IDS_DEFAULT_AVATAR_NAME_26 2036
#define IDS_DEFAULT_AVATAR_LABEL_0 2037
#define IDS_DEFAULT_AVATAR_LABEL_1 2038
#define IDS_DEFAULT_AVATAR_LABEL_2 2039
#define IDS_DEFAULT_AVATAR_LABEL_3 2040
#define IDS_DEFAULT_AVATAR_LABEL_4 2041
#define IDS_DEFAULT_AVATAR_LABEL_5 2042
#define IDS_DEFAULT_AVATAR_LABEL_6 2043
#define IDS_DEFAULT_AVATAR_LABEL_7 2044
#define IDS_DEFAULT_AVATAR_LABEL_8 2045
#define IDS_DEFAULT_AVATAR_LABEL_9 2046
#define IDS_DEFAULT_AVATAR_LABEL_10 2047
#define IDS_DEFAULT_AVATAR_LABEL_11 2048
#define IDS_DEFAULT_AVATAR_LABEL_12 2049
#define IDS_DEFAULT_AVATAR_LABEL_13 2050
#define IDS_DEFAULT_AVATAR_LABEL_14 2051
#define IDS_DEFAULT_AVATAR_LABEL_15 2052
#define IDS_DEFAULT_AVATAR_LABEL_16 2053
#define IDS_DEFAULT_AVATAR_LABEL_17 2054
#define IDS_DEFAULT_AVATAR_LABEL_18 2055
#define IDS_DEFAULT_AVATAR_LABEL_19 2056
#define IDS_DEFAULT_AVATAR_LABEL_20 2057
#define IDS_DEFAULT_AVATAR_LABEL_21 2058
#define IDS_DEFAULT_AVATAR_LABEL_22 2059
#define IDS_DEFAULT_AVATAR_LABEL_23 2060
#define IDS_DEFAULT_AVATAR_LABEL_24 2061
#define IDS_DEFAULT_AVATAR_LABEL_25 2062
#define IDS_DEFAULT_AVATAR_LABEL_26 2063
#define IDS_DEFAULT_AVATAR_LABEL_27 2064
#define IDS_DEFAULT_AVATAR_LABEL_28 2065
#define IDS_DEFAULT_AVATAR_LABEL_29 2066
#define IDS_DEFAULT_AVATAR_LABEL_30 2067
#define IDS_DEFAULT_AVATAR_LABEL_31 2068
#define IDS_DEFAULT_AVATAR_LABEL_32 2069
#define IDS_DEFAULT_AVATAR_LABEL_33 2070
#define IDS_DEFAULT_AVATAR_LABEL_34 2071
#define IDS_DEFAULT_AVATAR_LABEL_35 2072
#define IDS_DEFAULT_AVATAR_LABEL_36 2073
#define IDS_DEFAULT_AVATAR_LABEL_37 2074
#define IDS_DEFAULT_AVATAR_LABEL_38 2075
#define IDS_DEFAULT_AVATAR_LABEL_39 2076
#define IDS_DEFAULT_AVATAR_LABEL_40 2077
#define IDS_DEFAULT_AVATAR_LABEL_41 2078
#define IDS_DEFAULT_AVATAR_LABEL_42 2079
#define IDS_DEFAULT_AVATAR_LABEL_43 2080
#define IDS_DEFAULT_AVATAR_LABEL_44 2081
#define IDS_DEFAULT_AVATAR_LABEL_45 2082
#define IDS_DEFAULT_AVATAR_LABEL_46 2083
#define IDS_DEFAULT_AVATAR_LABEL_47 2084
#define IDS_DEFAULT_AVATAR_LABEL_48 2085
#define IDS_DEFAULT_AVATAR_LABEL_49 2086
#define IDS_DEFAULT_AVATAR_LABEL_50 2087
#define IDS_DEFAULT_AVATAR_LABEL_51 2088
#define IDS_DEFAULT_AVATAR_LABEL_52 2089
#define IDS_DEFAULT_AVATAR_LABEL_53 2090
#define IDS_DEFAULT_AVATAR_LABEL_54 2091
#define IDS_DEFAULT_AVATAR_LABEL_55 2092
#define IDS_PROFILES_LOCAL_PROFILE_STATE 2093
#define IDS_PROFILES_CREATE_BUTTON_LABEL 2094
#define IDS_PROFILES_MANAGE_BUTTON_LABEL 2095
#define IDS_PROFILES_DEFAULT_NAME 376
#define IDS_SYNC_LOGIN_NAME_PROHIBITED 2096
#define IDS_SUPERVISED_USER_NOT_ALLOWED_BY_POLICY 2097
#define IDS_OLD_PROFILES_DISABLED_TITLE 2098
#define IDS_OLD_PROFILES_DISABLED_MESSAGE 2099
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION 2100
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION_WITH_DOMAIN 2101
#define IDS_OLD_PROFILES_DISABLED_REMOVED_OLD_PROFILE 2102
#define IDS_SYNC_USER_NAME_IN_USE_ERROR 2103
#define IDS_SYNC_USER_NAME_IN_USE_BY_ERROR 2104
#define IDS_SCREEN_LOCK_SIGN_OUT 2105
#define IDS_PROFILE_CUSTOMIZATION_DONE_BUTTON_LABEL 2111
#define IDS_PROFILE_CUSTOMIZATION_WELCOME 2112
#define IDS_PROFILE_CUSTOMIZATION_INPUT_LABEL 2113
#define IDS_PROFILE_CUSTOMIZATION_INPUT_PLACEHOLDER 2114
#define IDS_PROFILE_CUSTOMIZATION_INPUT_ERROR_MESSAGE 2115
#define IDS_PROFILE_CUSTOMIZATION_SKIP_BUTTON_LABEL 2116
#define IDS_PROFILE_CUSTOMIZATION_DELETE_PROFILE_BUTTON_LABEL 2117
#define IDS_PROFILE_CUSTOMIZATION_LOCAL_PROFILE_CREATION_TITLE 2118
#define IDS_PROFILE_CUSTOMIZATION_AVATAR_SELECTION_BACK_BUTTON_LABEL 2119
#define IDS_ENTERPRISE_PROFILE_WELCOME_TITLE 2120
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_MANAGED_BY 2121
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_STRICT_SEPARATION 2122
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_SEPARATION 2123
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED 2124
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_ACCOUNT_MANAGED 2125
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED_BY 2126
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_EMAIL_MANAGED_BY 2127
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED_BY 2128
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED 2129
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITH_SYNC 2130
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITHOUT_SYNC 2131
#define IDS_ENTERPRISE_WELCOME_PROFILE_REQUIRED_TITLE 2132
#define IDS_ENTERPRISE_WELCOME_PROFILE_SETUP_TITLE 2133
#define IDS_ENTERPRISE_WELCOME_PROFILE_WILL_BE_MANAGED_TITLE 2134
#define IDS_ENTERPRISE_PROFILE_WELCOME_CREATE_PROFILE_BUTTON 2135
#define IDS_ENTERPRISE_PROFILE_WELCOME_LINK_DATA_CHECKBOX 2136
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_TITLE 2137
#define IDS_ENTERPRISE_WELCOME_PROFILE_OIDC_DISCLOSURE_TITLE 2138
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_SUBTITLE 2139
#define IDS_ENTERPRISE_WELCOME_PROFILE_DISCLOSURE_KNOWN_DOMAIN_SUBTITLE 2140
#define IDS_ENTERPRISE_WELCOME_PROFILE_INFORMATION_TITLE 2141
#define IDS_ENTERPRISE_WELCOME_DEVICE_INFORMATION_TITLE 2142
#define IDS_ENTERPRISE_WELCOME_DEVICE_INFORMATION_DETAILS 2143
#define IDS_ENTERPRISE_OIDC_WELCOME_PROCESSING_SUBTITLE 2144
#define IDS_ENTERPRISE_OIDC_WELCOME_LONG_PROCESSING_SUBTITLE 2145
#define IDS_ENTERPRISE_OIDC_WELCOME_SUCCESS_TITLE 2146
#define IDS_ENTERPRISE_OIDC_WELCOME_SUCCESS_SUBTITLE 2147
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_TITLE 2148
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_SUBTITLE 2149
#define IDS_ENTERPRISE_OIDC_WELCOME_TIMEOUT_RETRY_LABEL 2150
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_TITLE 2151
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_SUBTITLE 2152
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_NO_SIGNIN_TITLE 2153
#define IDS_ENTERPRISE_OIDC_WELCOME_ERROR_NO_SIGNIN_SUBTITLE 2154
#define IDS_ENTERPRISE_VALUE_PROPOSITION_SUBTITLE 2155
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_WORK_TITLE 2156
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_SCHOOL_TITLE 2157
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_CONSUMER_TITLE 2158
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE 2159
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE_NOT_RECOMMENDED 2160
#define IDS_ENTERPRISE_WELCOME_SEPARATE_BROWSING_DATA_CHOICE_DETAILS 2161
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_CHOICE 2162
#define IDS_ENTERPRISE_WELCOME_MERGE_BROWSING_DATA_CHOICE_DETAILS 2163
#define IDS_SUPERVISED_USER_PROFILE_SIGNIN_IPH_TITLE 2164
#define IDS_SUPERVISED_USER_PROFILE_SIGNIN_IPH_TEXT 2165
#define IDS_MANAGED_BY_PARENT_A11Y 2166
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_KIDS_BODY 2167
#define IDS_PROFILE_PICKER_ADD_SPACE_BUTTON 2168
#define IDS_PROFILE_PICKER_BROWSE_AS_GUEST_BUTTON 2169
#define IDS_PROFILE_PICKER_BACK_BUTTON_ARIA_LABEL 2170
#define IDS_PROFILE_PICKER_BACK_BUTTON_SIGN_IN_LABEL 2171
#define IDS_PROFILE_PICKER_PROFILE_CARD_NEEDS_SIGNIN_PROMPT 2172
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL_SUPERVISED 2173
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL 2174
#define IDS_PROFILE_PICKER_PROFILE_CARD_INPUT_LABEL 2175
#define IDS_PROFILE_PICKER_PROFILE_MORE_ACTIONS_ARIA_LABEL 2176
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_TEXT 2177
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_CONFIRM 2178
#define IDS_PROFILE_PICKER_PROFILE_MENU_CUSTOMIZE_TEXT 2179
#define IDS_PROFILE_PICKER_PROFILE_MENU_INCOGNITO_TEXT 2180
#define IDS_PROFILE_PICKER_ASK_ON_STARTUP 2181
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE_TITLE 2182
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_ALLOWED_TITLE 2183
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_NOT_ALLOWED_BODY 2184
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_WRONG_ACCOUNT_TITLE 2185
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_DIALOG_WRONG_ACCOUNT_BODY 2186
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_TIMEOUT_TITLE 2187
#define IDS_PROFILE_PICKER_FORCE_SIGN_IN_ERROR_TIMEOUT_BODY 2188
#define IDS_PROFILE_PICKER_REMOVE_WARNING_HISTORY 2189
#define IDS_PROFILE_PICKER_REMOVE_WARNING_PASSWORDS 2190
#define IDS_PROFILE_PICKER_REMOVE_WARNING_BOOKMARKS 2191
#define IDS_PROFILE_PICKER_REMOVE_WARNING_AUTOFILL 2192
#define IDS_PROFILE_PICKER_REMOVE_WARNING_CALCULATING 2193
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_SIGNIN_BUTTON_LABEL 2194
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_NOT_NOW_BUTTON_LABEL 2195
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_CUSTOMIZE_AVATAR_BUTTON_LABEL 2196
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_AVATAR_TEXT 2197
#define IDS_PROFILE_PICKER_TAKE_A_TOUR_BUTTON_LABEL 2198
#define IDS_PROFILE_PICKER_IPH_NEXT_BUTTON_LABEL 2199
#define IDS_PROFILE_PICKER_IPH_DONE_BUTTON_LABEL 2200
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TITLE 2201
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TITLE 2202
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TITLE 2203
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TEXT 2204
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SWITCH_BUTTON_LABEL 2205
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_BY_DESCRIPTION 2206
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_DESCRIPTION 2207
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE 2208
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE_TITLE 2209
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE 2210
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE_UNO 2211
#define IDS_FRE_SIGN_IN_SUBTITLE_0 2212
#define IDS_FRE_SIGN_IN_SUBTITLE_1 2213
#define IDS_FRE_DEVICES_CARD_TITLE 2214
#define IDS_FRE_DEVICES_CARD_DESCRIPTION 2215
#define IDS_FRE_SECURITY_CARD_TITLE 2216
#define IDS_FRE_SECURITY_CARD_DESCRIPTION 2217
#define IDS_FRE_BACKUP_CARD_TITLE 2218
#define IDS_FRE_BACKUP_CARD_DESCRIPTION 2219
#define IDS_UNO_FRE_BACKUP_CARD_DESCRIPTION 2220
#define IDS_FRE_DECLINE_SIGN_IN_BUTTON_TITLE 2221
#define IDS_FRE_ACCEPT_SIGN_IN_BUTTON_TITLE 2222
#define IDS_FRE_MANAGED_DESCRIPTION 2223
#define IDS_FRE_MANAGED_BY_DESCRIPTION 2224
#define IDS_FRE_DEFAULT_BROWSER_TITLE_NEW 2225
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE 2226
#define IDS_FRE_DEFAULT_BROWSER_SET_AS_DEFAULT 2227
#define IDS_FRE_DEFAULT_BROWSER_SKIP 2228
#define IDS_BATCH_UPLOAD_TITLE 2229
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_ITEMS 2230
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_PASSWORDS 2231
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_PASSWORDS_COMBO 2232
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_BOOKMARKS 2233
#define IDS_BATCH_UPLOAD_SUBTITLE_DESCRIPTION_BOOKMARKS_COMBO 2234
#define IDS_BATCH_UPLOAD_SECTION_TITLE_PASSWORDS 2235
#define IDS_BATCH_UPLOAD_SECTION_TITLE_BOOKMARKS 2236
#define IDS_BATCH_UPLOAD_SECTION_TITLE_ADDRESSES 2237
#define IDS_BATCH_UPLOAD_SAVE_TO_ACCOUNT_OK_BUTTON_LABEL 2238
#define IDS_BATCH_UPLOAD_AVATAR_BUTTON_SAVING_TO_ACCOUNT 2239
#define IDS_BATCH_UPLOAD_LAST_ITEM_SELECTED_SCREEN_READER 2240
#define IDS_BATCH_UPLOAD_SCREEN_READER_ITEM_COUNT_SELECTED 2241
#define IDS_BATCH_UPLOAD_SCREEN_READER_SELECT_ALL 2242
#define IDS_BATCH_UPLOAD_SCREEN_READER_SELECT_NONE 2243
#define IDS_TYPE_A_SHORTCUT 2244
#define IDS_SHORTCUT_SET 2245
#define IDS_SHORTCUT_NOT_SET 2246
#define IDS_SHORTCUT_INCLUDE_START_MODIFIER 2247
#define IDS_SHORTCUT_TOO_MANY_MODIFIERS 2248
#define IDS_SHORTCUT_NEED_CHARACTER 2249
#define IDS_SETTINGS_EMPTY_STRING 7507
#define IDS_SETTINGS_CONTINUE 7508
#define IDS_SETTINGS_GOT_IT 7509
#define IDS_SETTINGS_MORE_ACTIONS 498
#define IDS_SETTINGS_OPENS_IN_NEW_TAB 7510
#define IDS_SETTINGS_SEND_FEEDBACK_ROLE_DESCRIPTION 7511
#define IDS_SETTINGS_COLUMN_HEADING_WHEN_ON 7512
#define IDS_SETTINGS_COLUMN_HEADING_CONSIDER 7513
#define IDS_SETTINGS_COLUMN_HEADING_WHEN_USED 7514
#define IDS_RELAUNCH_CONFIRMATION_DIALOG_BODY 7515
#define IDS_SETTINGS_ABOUT_PAGE_BROWSER_VERSION 7516
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_UPDATE_ERRORS 7517
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_SYSTEM_REQUIREMENTS 7518
#define IDS_SETTINGS_ABOUT_PAGE_RELAUNCH 4580
#define IDS_SETTINGS_ACCESSIBILITY 7525
#define IDS_SETTINGS_ACCESSIBILITY_WEB_STORE 7526
#define IDS_SETTINGS_MORE_FEATURES_LINK 7527
#define IDS_SETTINGS_MORE_FEATURES_LINK_DESCRIPTION 7528
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_TITLE 7529
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_SUBTITLE 7530
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_COMPLETE 7531
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_ERROR 7532
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOAD_PROGRESS 7533
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_DOWNLOADING 7534
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_TITLE 7535
#define IDS_SETTINGS_MAIN_NODE_ANNOTATIONS_SUBTITLE 7536
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_TITLE 7537
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_TITLE 7538
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_SUBTITLE 7539
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE_ENGLISH_ONLY 7540
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE 7541
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_PROGRESS 7542
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_COMPLETE 7543
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR 7544
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 7545
#define IDS_SETTINGS_CAPTIONS_MASK_OFFENSIVE_WORDS_TITLE 7546
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_TITLE 7547
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_SUBTITLE 7548
#define IDS_SETTINGS_ACCESSIBILITY_FOCUS_HIGHLIGHT_DESCRIPTION 5305
#define IDS_SETTINGS_OVERSCROLL_HISTORY_NAVIGATION_TITLE 5237
#define IDS_SETTINGS_OVERSCROLL_HISTORY_NAVIGATION_SUBTITLE 7549
#define IDS_SETTINGS_APPEARANCE 7550
#define IDS_SETTINGS_CUSTOM_WEB_ADDRESS 7551
#define IDS_SETTINGS_ENTER_CUSTOM_WEB_ADDRESS 7552
#define IDS_SETTINGS_HOME_BUTTON_DISABLED 7553
#define IDS_SETTINGS_THEMES 7554
#define IDS_SETTINGS_RESET_TO_DEFAULT 7561
#define IDS_SETTINGS_CUSTOMIZE_TOOLBAR 7562
#define IDS_SETTINGS_CHROME_COLORS 7563
#define IDS_SETTINGS_COLOR_SCHEME_MODE 7564
#define IDS_SETTINGS_SHOW_HOME_BUTTON 7565
#define IDS_SETTINGS_SHOW_BOOKMARKS_BAR 7566
#define IDS_SETTINGS_SHOW_TAB_GROUPS_IN_BOOKMARKS_BAR 7567
#define IDS_SETTINGS_AUTO_PIN_NEW_TAB_GROUPS 7568
#define IDS_SETTINGS_HOVER_CARD_TITLE 7569
#define IDS_SETTINGS_SHOW_HOVER_CARD_IMAGES 7570
#define IDS_SETTINGS_SHOW_HOVER_CARD_MEMORY_USAGE 7571
#define IDS_SETTINGS_SHOW_HOVER_CARD_MEMORY_USAGE_STANDALONE 7572
#define IDS_SETTINGS_SIDE_PANEL_POSITION 7573
#define IDS_SETTINGS_TAB_SEARCH_POSITION 7574
#define IDS_SETTINGS_UI_FEATURE_ALIGN_LEFT 7575
#define IDS_SETTINGS_UI_FEATURE_ALIGN_RIGHT 7576
#define IDS_SETTINGS_HOME_PAGE_NTP 7577
#define IDS_SETTINGS_CHANGE_HOME_PAGE 7578
#define IDS_SETTINGS_WEB_STORE 7579
#define IDS_SETTINGS_ADVANCED 7582
#define IDS_SETTINGS_BASIC 7583
#define IDS_SETTINGS_MENU_BUTTON_LABEL 7584
#define IDS_SETTINGS_MENU_EXTENSIONS_LINK_TOOLTIP 7585
#define IDS_SETTINGS_SEARCH_PROMPT 7586
#define IDS_SETTINGS_SEARCH_NO_RESULTS_HELP 7587
#define IDS_SETTINGS_SETTINGS 7588
#define IDS_SETTINGS_ALT_PAGE_TITLE 7589
#define IDS_SETTINGS_SUBPAGE_BUTTON 7590
#define IDS_SETTINGS_RESTART 7591
#define IDS_SETTINGS_CONTROLLED_BY_EXTENSION 7592
#define IDS_SETTINGS_CLEAR 7593
#define IDS_SETTINGS_CUSTOM 7594
#define IDS_SETTINGS_DELETE 7595
#define IDS_SETTINGS_EDIT 7596
#define IDS_SETTINGS_END_TIME 7597
#define IDS_SETTINGS_NOT_VALID 7598
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS 7599
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS_FOR_CONTENT_TYPE 7600
#define IDS_SETTINGS_INPUT_MAX_LENGTH_DESCRIPTION 7601
#define IDS_SETTINGS_RETRY 7602
#define IDS_SETTINGS_SLIDER_MIN_MAX_ARIA_ROLE_DESCRIPTION 7603
#define IDS_SETTINGS_START_TIME 7604
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7605
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7606
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7607
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7608
#define IDS_PASSWORDS_PAGE_DELETE_ALL_DATA_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7609
#define IDS_SETTINGS_AUTOFILL_AND_PASSWORDS 7610
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 7611
#define IDS_SETTINGS_GOOGLE_PAYMENTS 7612
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_ADD_TITLE 7613
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EDIT_TITLE 7614
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_COUNTRY 7615
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_PHONE 7616
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EMAIL 7617
#define IDS_SETTINGS_AUTOFILL_DETAIL 7618
#define IDS_SETTINGS_AUTOFILL_CARD_DESCRIPTION 7619
#define IDS_SETTINGS_AUTOFILL_CARD_A11Y_LABELED 7620
#define IDS_SETTINGS_AUTOFILL_CARD_EXP_DATE_A11Y_LABELED 7621
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_ADDRESS 7622
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD 7623
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD_WITH_CVC 7624
#define IDS_AUTOFILL_ADD_VIRTUAL_CARD 7625
#define IDS_AUTOFILL_REMOVE_VIRTUAL_CARD 7626
#define IDS_AUTOFILL_EDIT_SERVER_CREDIT_CARD 7627
#define IDS_AUTOFILL_VIRTUAL_CARD_TURNED_ON_LABEL 7628
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_TITLE 7629
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_LABEL 7630
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_CONFIRM_BUTTON_LABEL 7631
#define IDS_SETTINGS_ADDRESS_REMOVE 7632
#define IDS_SETTINGS_ADDRESS_REMOVE_CONFIRMATION_TITLE 7633
#define IDS_SETTINGS_ADDRESS_REMOVED_MESSAGE 7634
#define IDS_SETTINGS_EDIT_CREDIT_CARD_TITLE 7635
#define IDS_SETTINGS_LOCAL_CARD_REMOVE_CONFIRMATION_TITLE 7636
#define IDS_SETTINGS_LOCAL_PAYMENT_METHOD_REMOVE_CONFIRMATION_DESCRIPTION 7637
#define IDS_SETTINGS_PAYMENTS_MANAGE_CREDIT_CARDS 7638
#define IDS_SETTINGS_PAYMENTS_SAVED_TO_THIS_DEVICE_ONLY 7639
#define IDS_SETTINGS_ADD_CREDIT_CARD_TITLE 7640
#define IDS_SETTINGS_MIGRATABLE_CARDS_LABEL 7641
#define IDS_SETTINGS_SINGLE_MIGRATABLE_CARD_INFO 7642
#define IDS_SETTINGS_MULTIPLE_MIGRATABLE_CARDS_INFO 7643
#define IDS_SETTINGS_REMOTE_PAYMENT_METHODS_LINK_LABEL 7644
#define IDS_SETTINGS_NAME_ON_CREDIT_CARD 7645
#define IDS_SETTINGS_CREDIT_CARD_NUMBER 7646
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_DATE 7647
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_MONTH 7648
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_YEAR 7649
#define IDS_SETTINGS_CREDIT_CARD_EXPIRED 7650
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME 7651
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME_INVALID 7652
#define IDS_SETTINGS_CREDIT_CARD_CVC_TITLE 7653
#define IDS_SETTINGS_CREDIT_CARD_CVC_IMAGE_TITLE 7654
#define IDS_SETTINGS_CREDIT_CARD_CVC_IMAGE_TITLE_AMEX 7655
#define IDS_SETTINGS_CREDIT_CARD_CVC_PLACEHOLDER 7656
#define IDS_SETTINGS_ADD_PAYMENT_METHODS 7657
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_CREDIT_OR_DEBIT_CARD 7658
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_IBAN 7659
#define IDS_SETTINGS_IBAN_SAVED_TO_THIS_DEVICE_ONLY 7660
#define IDS_SETTINGS_IBAN_INVALID_VALIDATION_MESSAGE 7661
#define IDS_IBAN_NICKNAME 7662
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_IBAN 7663
#define IDS_SETTINGS_AUTOFILL_A11Y_IBAN_DESCRIPTION 7664
#define IDS_SETTINGS_ADD_IBAN_TITLE 7665
#define IDS_SETTINGS_EDIT_IBAN_TITLE 7666
#define IDS_SETTINGS_IBAN_EDIT 7667
#define IDS_SETTINGS_LOCAL_IBAN_REMOVE_CONFIRMATION_TITLE 7668
#define IDS_SETTINGS_PASSWORD_MANAGER 7669
#define IDS_SETTINGS_PASSWORD_MANAGER_DESCRIPTION 7670
#define IDS_SETTINGS_PAYMENT_METHODS_NONE 7671
#define IDS_SETTINGS_PASSKEYS_LENGTH_ERROR 7672
#define IDS_SETTINGS_PASSKEYS_SITE_LABEL 7673
#define IDS_SETTINGS_PASSKEYS_DIALOG_TITLE 7674
#define IDS_SETTINGS_PASSKEYS_EDIT_DIALOG_FOOTNOTE 7675
#define IDS_SETTINGS_ADDRESS_NONE 7676
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL 7677
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_SIGNED_OUT_ENABLED_DESC 7678
#define IDS_SETTINGS_CHECK_PASSWORDS_PROGRESS 7679
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT 7680
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT_SHORT 7681
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT_SHORT 7682
#define IDS_SETTINGS_REUSED_PASSWORDS_COUNT_SHORT 7683
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_PAGE_TITLE 7684
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_TO_CONSIDER_NEW_FEATURE 7685
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_TO_CONSIDER_DATA_USAGE 7686
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_TO_CONSIDER_STORAGE 7687
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_TO_CONSIDER_IMPROVEMENT 7688
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_USER_ANNOTATIONS_HEADER 7689
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_USER_ANNOTATIONS_NONE 7690
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_DELETE_ENTRY_DIALOG_TITLE 7691
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_DELETE_ENTRY_DIALOG_TEXT 7692
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_DELETE_ALL_ENTRIES_BUTTON_LABEL 7693
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_DELETE_ALL_ENTRIES_DIALOG_TITLE 7694
#define IDS_SETTINGS_AUTOFILL_PREDICTION_IMPROVEMENTS_DELETE_ALL_ENTRIES_DIALOG_TEXT 7695
#define IDS_AUTOFILL_MANAGE_PASSKEYS_LABEL 7696
#define IDS_AUTOFILL_MANAGE_PASSKEYS_NO_SUPPORT 7697
#define IDS_AUTOFILL_MANAGE_PASSKEYS_TITLE 7698
#define IDS_AUTOFILL_MANAGE_PASSKEYS_SUB_TITLE_WIN 7699
#define IDS_AUTOFILL_MANAGE_PASSKEYS_SEARCH 7701
#define IDS_AUTOFILL_MANAGE_PASSKEYS_DELETE_CONFIRMATION_TITLE 7702
#define IDS_AUTOFILL_MANAGE_PASSKEYS_DELETE_CONFIRMATION_DESCRIPTION 7703
#define IDS_AUTOFILL_MANAGE_PASSKEYS_CANNOT_DELETE_TITLE 7704
#define IDS_AUTOFILL_MANAGE_PASSKEYS_CANNOT_DELETE_BODY 7705
#define IDS_AUTOFILL_MANAGE_PASSKEYS_MORE_ACTIONS_LABEL 7706
#define IDS_SETTINGS_PASSWORD_SHOW_PASSWORD_A11Y 7707
#define IDS_SETTINGS_PASSWORD_HIDE_PASSWORD_A11Y 7708
#define IDS_SETTINGS_DEFAULT_BROWSER 7709
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT_BUTTON 7710
#define IDS_SETTINGS_CLEAR_PERIOD_TITLE 7791
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC 7792
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_ERROR 7793
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PASSPHRASE_ERROR 7794
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PAUSED 7795
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY 7796
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC 7797
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_WITH_EXCEPTION 7798
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SUPERVISED_PROFILE 7799
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SIGNED_IN_PROFILE 7800
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY 7801
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY_SIGNED_IN_NO_LINK 7802
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_GOOGLE_DSE 7803
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_NON_GOOGLE_DSE 7804
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_PREPOPULATED_DSE 7805
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_NON_PREPOPULATED_DSE 7806
#define IDS_SETTINGS_CLEAR_DOWNLOAD_HISTORY 7807
#define IDS_SETTINGS_CLEAR_CACHE 7808
#define IDS_SETTINGS_CLEAR_COOKIES 7809
#define IDS_SETTINGS_CLEAR_PASSWORDS 7810
#define IDS_SETTINGS_CLEAR_FORM_DATA 7811
#define IDS_SETTINGS_CLEAR_HOSTED_APP_DATA 7812
#define IDS_SETTINGS_CLEAR_PERIOD_HOUR 7813
#define IDS_SETTINGS_CLEAR_PERIOD_24_HOURS 7814
#define IDS_SETTINGS_CLEAR_PERIOD_7_DAYS 7815
#define IDS_SETTINGS_CLEAR_PERIOD_FOUR_WEEKS 7816
#define IDS_SETTINGS_CLEAR_PERIOD_EVERYTHING 7817
#define IDS_SETTINGS_NOTIFICATION_WARNING 7818
#define IDS_SETTINGS_DOWNLOADS 7819
#define IDS_SETTINGS_DOWNLOAD_LOCATION 7820
#define IDS_SETTINGS_CHANGE_DOWNLOAD_LOCATION 7821
#define IDS_SETTINGS_PROMPT_FOR_DOWNLOAD 7822
#define IDS_SETTINGS_OPEN_FILE_TYPES_AUTOMATICALLY 7823
#define IDS_SETTINGS_DOWNLOADS_SHOW_WHEN_FINISHED 7824
#define IDS_SETTINGS_ON_STARTUP 7825
#define IDS_SETTINGS_ON_STARTUP_OPEN_NEW_TAB 7826
#define IDS_SETTINGS_ON_STARTUP_CONTINUE 7827
#define IDS_SETTINGS_ON_STARTUP_OPEN_SPECIFIC 7828
#define IDS_SETTINGS_ON_STARTUP_CONTINUE_AND_OPEN_SPECIFIC 7829
#define IDS_SETTINGS_ON_STARTUP_USE_CURRENT 7830
#define IDS_SETTINGS_ON_STARTUP_ADD_NEW_PAGE 7831
#define IDS_SETTINGS_ON_STARTUP_EDIT_PAGE 7832
#define IDS_SETTINGS_ON_STARTUP_SITE_URL 7833
#define IDS_SETTINGS_ON_STARTUP_REMOVE 7834
#define IDS_SETTINGS_ON_STARTUP_PAGE_TOOLTIP 7835
#define IDS_SETTINGS_INVALID_URL 7836
#define IDS_SETTINGS_URL_TOOL_LONG 7837
#define IDS_SETTINGS_PERFORMANCE_PAGE_TITLE 7838
#define IDS_SETTINGS_PERFORMANCE_GENERAL_PAGE_TITLE 7839
#define IDS_SETTINGS_PERFORMANCE_MEMORY_PAGE_TITLE 7840
#define IDS_SETTINGS_PERFORMANCE_SPEED_PAGE_TITLE 7841
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_SETTING 7842
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_HEURISTICS_LABEL 7843
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_RECOMMENDED_BADGE 7844
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_ON_TIMER_LABEL 7845
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7846
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CHOOSE_DISCARD_TIME_ARIA_LABEL 7847
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CONSERVATIVE_LABEL 7848
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_MEDIUM_LABEL 7849
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_AGGRESSIVE_LABEL 7850
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_CONSERVATIVE_DESCRIPTION 7851
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_MEDIUM_DESCRIPTION 7852
#define IDS_SETTINGS_PERFORMANCE_MEMORY_SAVER_MODE_AGGRESSIVE_DESCRIPTION 7853
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_BUTTON_ARIA_LABEL 7854
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_SAVE_BUTTON_ARIA_LABEL 7855
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_HEADER 7856
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_DESCRIPTION 7857
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADDITIONAL_SITES 7858
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS 7859
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS_EMPTY 7860
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_MANUAL 7861
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ACTIVE_SITE_ARIA_DESCRIPTION 7862
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_HELP 7863
#define IDS_SETTINGS_PERFORMANCE_BATTERY_PAGE_TITLE 7864
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING 7865
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_ON_BATTERY_LABEL 7866
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_BELOW_THRESHOLD_LABEL 7867
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7868
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_LINK_OS_SETTING_DESCRIPTION 7869
#define IDS_SETTINGS_PERFORMANCE_DISCARD_RING_TREATMENT_ENABLED_LABEL 7870
#define IDS_SETTINGS_PERFORMANCE_DISCARD_RING_TREATMENT_ENABLED_DESCRIPTION_WITH_LEARN_LINK 7871
#define IDS_SETTINGS_PERFORMANCE_TAB_HOVER_PREVIEW_CARD_LINK_TITLE 7872
#define IDS_SETTINGS_PERFORMANCE_TAB_HOVER_PREVIEW_CARD_LINK_SUBTITLE 7873
#define IDS_SETTINGS_PERFORMANCE_INTERVENTION_NOTIFICATION_ENABLED_LABEL 7874
#define IDS_SETTINGS_PERFORMANCE_INTERVENTION_NOTIFICATION_ENABLED_DESCRIPTION 7875
#define IDS_SETTINGS_LANGUAGES_PAGE_TITLE 7876
#define IDS_SETTINGS_LANGUAGES_CARD_TITLE 7877
#define IDS_SETTINGS_LANGUAGE_SEARCH 7878
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_TO_TOP 7879
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_UP 7880
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_DOWN 7881
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_REMOVE 7882
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_ADD 7883
#define IDS_SETTINGS_LANGUAGES_MANAGE_LANGUAGES_TITLE 7884
#define IDS_SETTINGS_LANGUAGES_NO_LANGUAGES_ADDED 7885
#define IDS_SETTINGS_LANGUAGES_EXPAND_ACCESSIBILITY_LABEL 7886
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_HEADER 7887
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_DESC 7888
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE 7889
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE_SUBLABEL 7890
#define IDS_SETTINGS_LANGUAGES_TRANSLATE_TARGET 7891
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_TITLE 7892
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_BODY 7893
#define IDS_SETTINGS_LANGUAGES_ADD_ARIA_LABEL 7894
#define IDS_SETTINGS_LANGUAGES_REMOVE_AUTOMATIC_ARIA_LABEL 7895
#define IDS_SETTINGS_LANGUAGES_REMOVE_NEVER_ARIA_LABEL 7896
#define IDS_SETTINGS_TRANSLATE_PAGE_TITLE 7897
#define IDS_SETTINGS_TARGET_TRANSLATE_LABEL 7898
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE 7899
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE_ADD_ARIA_LABEL 7900
#define IDS_SETTINGS_LANGUAGES_NEVER_LANGUAGES 7901
#define IDS_SETTINGS_LANGUAGES_NEVER_TRANSLATE_ADD_ARIA_LABEL 7902
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_TITLE 7903
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_BASIC_LABEL 7904
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_LABEL 7905
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_DESCRIPTION 7906
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_SPELL_CHECK 7907
#define IDS_SETTING_LANGUAGES_SPELL_CHECK_DISABLED_REASON 7908
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_LANGUAGES_LIST_TITLE 7909
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_MANAGE 7910
#define IDS_SETTINGS_LANGUAGES_EDIT_DICTIONARY_TITLE 7911
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD 7912
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_BUTTON 7913
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_DUPLICATE_ERROR 7914
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_LENGTH_ERROR 7915
#define IDS_SETTINGS_LANGUAGES_DELETE_DICTIONARY_WORD_BUTTON 7916
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS 7917
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS_NONE 7918
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED 7919
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED_HELP 7920
#define IDS_SETTINGS_PRELOAD_PAGES_TITLE 7923
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_TITLE 7924
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_EXPAND_A11Y_LABEL 7925
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_SUMMARY 7926
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_ONE 7927
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_TITLE 7928
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_SUMMARY 7929
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_EXPAND_A11Y_LABEL 7930
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_ONE 7931
#define IDS_SETTINGS_PRIVACY 7932
#define IDS_SETTINGS_PRIVACY_V2 7933
#define IDS_SETTINGS_PRIVACY_MORE 7934
#define IDS_SETTINGS_AI_COMPOSE_SUBLABEL_V2 7936
#define IDS_SETTINGS_OFFER_WRITING_HELP_TOGGLE_LABEL 7937
#define IDS_SETTINGS_OFFER_WRITING_HELP_TOGGLE_SUB_LABEL 7938
#define IDS_SETTINGS_OFFER_WRITING_HELP_ENABLED_SUB_LABEL 7939
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SUB_LABEL 7940
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SITES_LABEL 7941
#define IDS_SETTINGS_OFFER_WRITING_HELP_DISABLED_SITES_LABEL_V2 7942
#define IDS_SETTINGS_OFFER_WRITING_HELP_NO_DISABLED_SITES 7943
#define IDS_SETTINGS_OFFER_WRITING_HELP_REMOVE_SITE_ARIA_LABEL 7944
#define IDS_SETTINGS_COMPOSE_SETTING_LINK_A11Y 7945
#define IDS_SETTINGS_COMPOSE_WHEN_ON_WRITING_HELP 7946
#define IDS_SETTINGS_COMPOSE_WHEN_ON_WRITING_EXAMPLES 7947
#define IDS_SETTINGS_COMPOSE_WHEN_ON_WRITING_REFERENCES 7948
#define IDS_SETTINGS_COMPOSE_CONSIDER_DATA 7949
#define IDS_SETTINGS_ANTI_ABUSE_ENABLED_SUB_LABEL 7950
#define IDS_SETTINGS_ANTI_ABUSE_DISABLED_SUB_LABEL 7951
#define IDS_SETTINGS_ANTI_ABUSE_DESCRIPTION 7952
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_ONE 7953
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_TWO 7954
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_THREE 7955
#define IDS_SETTINGS_ANTI_ABUSE_THINGS_TO_CONSIDER_SECTION_ONE 7956
#define IDS_SETTINGS_PRIVACY_SANDBOX_TITLE 7957
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG 7958
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG_MORE 7959
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_LABEL 7960
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_SUB_LABEL 7961
#define IDS_SETTINGS_AD_PRIVACY_RESTRICTED_LINK_ROW_SUB_LABEL 7962
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TITLE 7963
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_LABEL 7964
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_ENABLED 7965
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_DISABLED 7966
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_LABEL 7967
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_ENABLED 7968
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_DISABLED 7969
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_LABEL 7970
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_ENABLED 7971
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_DISABLED 7972
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_REGION_A11Y_DESCRIPTION 7973
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_REGION_A11Y_DESCRIPTION 7974
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_V2 7975
#define IDS_SETTINGS_FLEDGE_PAGE_TITLE 7976
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_LABEL 7977
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_SUB_LABEL 7978
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_HEADING 7979
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION 7980
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE 7981
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_DISABLED 7982
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_EMPTY 7983
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_REGION_A11Y_DESCRIPTION 7984
#define IDS_SETTINGS_FLEDGE_PAGE_SEE_ALL_SITES_LABEL 7985
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE 7986
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE_A11Y_LABEL 7987
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_HEADING 7988
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION 7989
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION_EMPTY 7990
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_REGION_A11Y_DESCRIPTION 7991
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE 7992
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE_A11Y_LABEL 7993
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_HEADING 7994
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_1 7995
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_2 7996
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_3 7997
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE_A11Y_LABEL 7998
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TITLE 7999
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_LABEL 8000
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_SUB_LABEL 8001
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_1 8002
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_2 8003
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_3 8004
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_1 8005
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_2 8006
#define IDS_SETTINGS_PRIVACY_GUIDE_LABEL 8007
#define IDS_SETTINGS_PRIVACY_GUIDE_SUBLABEL 8008
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_HEADER 8009
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_START_BUTTON 8010
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_LABEL 8011
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_ROLE_DESC 8012
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_BUTTON 8013
#define IDS_SETTINGS_PRIVACY_GUIDE_STEPS 8014
#define IDS_SETTINGS_PRIVACY_GUIDE_NEXT_BUTTON 8015
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_HEADER 8016
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_SUB_HEADER 8017
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_HEADER 8018
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER 8019
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER_NO_LINKS 8020
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_LEAVE_BUTTON 8021
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_LABEL 8022
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL_AD_TOPICS 8023
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_LABEL 8024
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_AI_SETTINGS_LABEL 8025
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_CARD_HEADER 8026
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION1 8027
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION2 8028
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION1 8029
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_CARD_HEADER 8030
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_SETTING_LABEL 8031
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION1 8032
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION2 8033
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_PRIVACY_DESCRIPTION1 8034
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_HEADER 8035
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_SUBHEADER 8036
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION1 8037
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION2 8038
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION1 8039
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION2 8040
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_SUBHEADER 8041
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION1 8042
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION2 8043
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_PRIVACY_DESCRIPTION1 8044
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_HEADER 8045
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION1 8046
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION2 8047
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION3 8048
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION1 8049
#define IDS_SETTINGS_SAFETY_CHECK_ICON_INFO_ARIA_LABEL 8052
#define IDS_SETTINGS_SAFETY_CHECK_ICON_WARNING_ARIA_LABEL 8053
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW 8054
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_ARIA_LABEL 8055
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_LABEL 8056
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_ONE_PERMISSION_LABEL 8057
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_TWO_PERMISSIONS_LABEL 8058
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_THREE_PERMISSIONS_LABEL 8059
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_FOUR_OR_MORE_PERMISSIONS_LABEL 8060
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_PRIMARY_LABEL 8061
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SECONDARY_LABEL 8062
#define IDS_SETTINGS_SAFETY_HUB_REVOKED_PERMISSIONS_SECONDARY_LABEL 8063
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_BULK_LABEL 8064
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_LABEL 8065
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_LABEL 8066
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_DISABLED_BY_ADMIN 8067
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_PRIMARY_LABEL 8068
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_FEATURE_UNAVAILABLE 8069
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED 8070
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD 8071
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD_AVAILABLE_ENHANCED 8072
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_ENHANCED 8073
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_SAFE 8074
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_OFF 8075
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_USER 8076
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_ADMIN 8077
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_EXTENSIONS 8078
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_IGNORED_TOAST_LABEL 8079
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCKED_TOAST_LABEL 8080
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_RESET_TOAST_LABEL 8081
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_COUNT_LABEL 8082
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_LABEL 8083
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_ARIA_LABEL 8084
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_LABEL 8085
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_ARIA_LABEL 8086
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_LABEL 8087
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_ARIA_LABEL 8088
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_MORE_ACTIONS_ARIA_LABEL 8089
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_LABEL 8090
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_TOAST_LABEL 8091
#define IDS_SETTINGS_SAFETY_CHECK_TOAST_UNDO_BUTTON_LABEL 8092
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC 8093
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION 8094
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION_DESC 8095
#define IDS_SETTINGS_SAFEBROWSING_ENABLE_REPORTING_DESC 8096
#define IDS_SETTINGS_SAFEBROWSING_SECTION_LABEL 8097
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED 8098
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC 8099
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC_UPDATED 8100
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_EXPAND_ACCESSIBILITY_LABEL 8101
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_ONE 8102
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_THREE 8103
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FOUR 8104
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FIVE 8105
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_TWO 8106
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_THREE 8107
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_FOUR 8108
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_WHEN_ON_BULLET_FIVE 8109
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_ONE 8110
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_TWO 8111
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_THINGS_TO_CONSIDER_BULLET_THREE 8112
#define IDS_SETTINGS_SAFEBROWSING_STANDARD 8113
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC 8114
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_EXPAND_ACCESSIBILITY_LABEL 8117
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_ONE 8118
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_HELP_IMPROVE 8119
#define IDS_SETTINGS_SAFEBROWSING_NONE 8120
#define IDS_SETTINGS_SAFEBROWSING_NONE_DESC 8121
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_TITLE 8122
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_DESC 8123
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_CONFIRM 8124
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK 8125
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TITLE 8126
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TEXT 8127
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_LEARN_MORE_ACCESSIBILITY_LABEL 8128
#define IDS_SETTINGS_PERMISSIONS 8129
#define IDS_SETTINGS_PERMISSIONS_DESCRIPTION 8130
#define IDS_SETTINGS_SECURITY 8131
#define IDS_SETTINGS_SECURITY_DESCRIPTION 8132
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM 8133
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM_DESC 8134
#define IDS_SETTINGS_SECURE_CONNECTIONS_SECTION_TITLE 8135
#define IDS_SETTINGS_HTTPS_ONLY_MODE 8136
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION 8137
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION_ADVANCED_PROTECTION 8138
#define IDS_SETTINGS_HTTPS_FIRST_MODE_TITLE 8139
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DESCRIPTION 8140
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DESCRIPTION_ADVANCED_PROTECTION 8141
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_FULL_LABEL 8142
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_INCOGNITO_LABEL 8143
#define IDS_SETTINGS_HTTPS_FIRST_MODE_DISABLED_LABEL 8144
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_STRICT_LABEL 8145
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_STRICT_SUBLABEL 8146
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_BALANCED_LABEL 8147
#define IDS_SETTINGS_HTTPS_FIRST_MODE_ENABLED_BALANCED_SUBLABEL 8148
#define IDS_SETTINGS_MANAGE_CERTIFICATES 8149
#define IDS_SETTINGS_MANAGE_CERTIFICATES_DESCRIPTION 8150
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES 8151
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES_DESCRIPTION 8152
#define IDS_SETTINGS_MANAGE 8153
#define IDS_SETTINGS_SECURE_DNS 8154
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION 8156
#define IDS_SETTINGS_SECURE_DNS_DROPDOWN_ACCESSIBILITY_LABEL 8157
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_DESCRIPTION 8158
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_PRIVACY_POLICY 8159
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_MANAGED_ENVIRONMENT 8160
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_PARENTAL_CONTROL 8161
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_DESCRIPTION 8162
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_PLACEHOLDER 8163
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_FORMAT_ERROR 8164
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_CONNECTION_ERROR 8165
#define IDS_SETTINGS_SECURITY_V8_LINK_TITLE 8166
#define IDS_SETTINGS_CONTENT_SETTINGS 8167
#define IDS_SETTINGS_SITE_SETTINGS 8168
#define IDS_SETTINGS_SITE_SETTINGS_DESCRIPTION 8169
#define IDS_SETTINGS_CLEAR_DATA 8170
#define IDS_SETTINGS_CLEARING_DATA 8171
#define IDS_SETTINGS_CLEARED_DATA 8172
#define IDS_SETTINGS_CLEAR_BROWSING_DATA 8173
#define IDS_SETTINGS_CLEAR_DATA_DESCRIPTION 8174
#define IDS_SETTINGS_TITLE_AND_COUNT 8175
#define IDS_SETTINGS_SYNC_AND_GOOGLE_SERVICES_PRIVACY_DESC_UNIFIED_CONSENT 8176
#define IDS_SETTINGS_RECENT_PERMISSIONS_NO_CHANGES 8177
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_ONE_ITEM 8178
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_TWO_ITEMS 8179
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_MORE_THAN_TWO_ITEMS 8180
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_ONE_ITEM 8181
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_TWO_ITEMS 8182
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_MORE_THAN_TWO_ITEMS 8183
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_ONE_ITEM 8184
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_TWO_ITEMS 8185
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_MORE_THAN_TWO_ITEMS 8186
#define IDS_SETTINGS_RESET_PROMPT_TITLE 8187
#define IDS_SETTINGS_RESET 8188
#define IDS_SETTINGS_RESET_SETTINGS_TRIGGER 8189
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_TITLE 8190
#define IDS_SETTINGS_RESET_BANNER_TEXT 8191
#define IDS_SETTINGS_RESET_BANNER_RESET_BUTTON_TEXT 8192
#define IDS_SETTINGS_RESET_LEARN_MORE_ACCESSIBILITY_TEXT 8193
#define IDS_SETTINGS_SEARCH 8196
#define IDS_SETTINGS_SEARCH_EXPLANATION_ACCESSIBILITY_LABEL 8197
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES 8198
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 8199
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_EXPLANATION 8200
#define IDS_SETTINGS_SEARCH_ENGINES 8201
#define IDS_SETTINGS_SEARCH_ENGINES_PAGE_EXPLANATION 8202
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH 8203
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SITE_SEARCH 8204
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE 8205
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SITE_SEARCH 8206
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_SITE_SEARCH 8207
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_TITLE 8208
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_DESCRIPTION 8209
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES 8210
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES_EXPLANATION 8211
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH 8212
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION 8213
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION_STARTER_PACK 8214
#define IDS_SETTINGS_SEARCH_ENGINES_NO_SITES_ADDED 8215
#define IDS_SETTINGS_SEARCH_ENGINES_INACTIVE_SHORTCUTS 8216
#define IDS_SETTINGS_SEARCH_ENGINES_NO_OTHER_ENGINES 8217
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES 8218
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES_EXPLANATION 8219
#define IDS_SETTINGS_SEARCH_ENGINES_NAME 8220
#define IDS_SETTINGS_SEARCH_ENGINES_SHORTCUT 8221
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL 8222
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL_EXPLANATION 8223
#define IDS_SETTINGS_SEARCH_ENGINES_MAKE_DEFAULT 8224
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE 8225
#define IDS_SETTINGS_SEARCH_ENGINES_DEACTIVATE 8226
#define IDS_SETTINGS_SEARCH_ENGINES_VIEW_DETAILS 8227
#define IDS_SETTINGS_SEARCH_ENGINES_MANAGE_EXTENSION 8228
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TITLE 8229
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION 8230
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION_STARTER_PACK 8231
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_SPACE_OR_TAB 8232
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TAB 8233
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_SITES 8234
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_INACTIVE_SITES 8235
#define IDS_SETTINGS_SEARCH_ENGINES_MORE_ACTIONS_ARIA_LABEL 8236
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE_BUTTON_ARIA_LABEL 8237
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SITE_SEARCH_BUTTON_ARIA_LABEL 8238
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE_BUTTON_ARIA_LABEL 8239
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_HOST 8240
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_ANY_HOST 8241
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES 8242
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_DESCRIPTION 8243
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SEARCH 8244
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT 8245
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_MOST_VISITED 8246
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_STORAGE 8247
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_NAME 8248
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_HEADER 8249
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_EDIT_HEADER 8250
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANT_LABEL 8251
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANTS 8252
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_HEADER 8253
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_SITE_DETAILS 8254
#define IDS_SETTINGS_SITE_SETTINGS_SITE_ENTRY_PARTITIONED_LABEL 8255
#define IDS_SETTINGS_SITE_SETTINGS_SITE_REPRESENTATION_SEPARATOR 8256
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR 8257
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR_DESCRIPTION 8258
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DEFAULT_BEHAVIOR_DESC 8259
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS 8260
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION 8261
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION_SHORT 8262
#define IDS_SETTINGS_SITE_SETTINGS_ADS_DESCRIPTION 8263
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED 8264
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED 8265
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED_EXCEPTIONS 8266
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED_EXCEPTIONS 8267
#define IDS_SETTINGS_SITE_SETTINGS_AR_DESCRIPTION 8268
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED 8269
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED 8270
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED_EXCEPTIONS 8271
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED_EXCEPTIONS 8272
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_DESCRIPTION 8273
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED 8274
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED 8275
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED_EXCEPTIONS 8276
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED_EXCEPTIONS 8277
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_DESCRIPTION 8278
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_ALLOWED 8279
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_BLOCKED 8280
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_ALLOWED_EXCEPTIONS 8281
#define IDS_SETTINGS_SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE_BLOCKED_EXCEPTIONS 8282
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_DESCRIPTION 8283
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED 8284
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED 8285
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_SUB_LABEL 8286
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED_EXCEPTIONS 8287
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_EXCEPTIONS 8288
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_DESCRIPTION 8289
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_ALLOWED 8290
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_BLOCKED 8291
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_DESCRIPTION 8292
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_ALLOWED 8293
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_BLOCKED 8294
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_ALLOWED_EXCEPTIONS 8295
#define IDS_SETTINGS_SITE_SETTINGS_CAPTURED_SURFACE_CONTROL_BLOCKED_EXCEPTIONS 8296
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_DESCRIPTION 8297
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED 8298
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED 8299
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_SUB_LABEL 8300
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED_EXCEPTIONS 8301
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_EXCEPTIONS 8302
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_DESCRIPTION 8303
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED 8304
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED 8305
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED_EXCEPTIONS 8306
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED_EXCEPTIONS 8307
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_DESCRIPTION 8308
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED 8309
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED 8310
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED_EXCEPTIONS 8311
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED_EXCEPTIONS 8312
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_DESCRIPTION 8313
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED 8314
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED 8315
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED_EXCEPTIONS 8316
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED_EXCEPTIONS 8317
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_DESCRIPTION 8318
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_ALLOWED 8319
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED 8320
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED_EXCEPTIONS 8321
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_DESCRIPTION 8322
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED 8323
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED 8324
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED_EXCEPTIONS 8325
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED_EXCEPTIONS 8326
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_DESCRIPTION 8327
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_ALLOWED_EXCEPTIONS 8328
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_FULLSCREEN_BLOCKED_EXCEPTIONS 8329
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_DESCRIPTION 8330
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_ALLOWED_EXCEPTIONS 8331
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_BLOCKED_EXCEPTIONS 8332
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_DESCRIPTION 8333
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ALLOWED 8334
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCKED 8335
#define IDS_SITE_SETTINGS_SMART_CARD_READERS 8336
#define IDS_SITE_SETTINGS_SMART_CARD_READERS_DESCRIPTION 8337
#define IDS_SITE_SETTINGS_SMART_CARDS_DEFAULT_DESCRIPTION 8338
#define IDS_SITE_SETTINGS_SMART_CARDS_ALLOWED 8339
#define IDS_SITE_SETTINGS_SMART_CARDS_BLOCKED 8340
#define IDS_SITE_SETTINGS_NO_SMART_CARD_READERS_FOUND 8341
#define IDS_SITE_SETTINGS_RESET_SMART_CARD_CONFIRMATION 8342
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_DESCRIPTION 8343
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED 8344
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED 8345
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_SUB_LABEL 8346
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED_EXCEPTIONS 8347
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_EXCEPTIONS 8348
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_DESCRIPTION 8349
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_ALLOWED_EXCEPTIONS 8350
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCKED_EXCEPTIONS 8351
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_DESCRIPTION 8352
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED 8353
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED 8354
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED_EXCEPTIONS 8355
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED_EXCEPTIONS 8356
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_ALLOWED 8357
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED 8358
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_SUB_LABEL 8359
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_ALLOWED_EXCEPTIONS 8360
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_OPTIMIZER_BLOCKED_EXCEPTIONS 8361
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_DESCRIPTION 8362
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_ALLOWED 8363
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_BLOCKED 8364
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_ALLOWED_EXCEPTIONS 8365
#define IDS_SETTINGS_SITE_SETTINGS_KEYBOARD_LOCK_BLOCKED_EXCEPTIONS 8366
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_DESCRIPTION 8367
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED 8368
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED 8369
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_SUB_LABEL 8370
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED_EXCEPTIONS 8371
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_EXCEPTIONS 8372
#define IDS_SETTINGS_SITE_SETTINGS_MIC_DESCRIPTION 8373
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED 8374
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED 8375
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_SUB_LABEL 8376
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED_EXCEPTIONS 8377
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_EXCEPTIONS 8378
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_DESCRIPTION 8379
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED 8380
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED 8381
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED_EXCEPTIONS 8382
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED_EXCEPTIONS 8383
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_DESCRIPTION 8384
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED 8385
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED 8386
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_SUB_LABEL 8387
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED_EXCEPTIONS 8388
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_EXCEPTIONS 8389
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DESCRIPTION 8390
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED 8391
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL 8392
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL_SUB_LABEL 8393
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ASK_STATE 8394
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_QUIET 8395
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_CPSS 8396
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSION_LOUD 8397
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED 8398
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_SUB_LABEL 8399
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED_EXCEPTIONS 8400
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_EXCEPTIONS 8401
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_DESCRIPTION 8402
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED 8403
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED 8404
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED_EXCEPTIONS 8405
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED_EXCEPTIONS 8406
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_DESCRIPTION 8407
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_ALLOWED 8408
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_DESCRIPTION 8409
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_ALLOWED 8410
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_BLOCKED 8411
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_ALLOWED_EXCEPTIONS 8412
#define IDS_SETTINGS_SITE_SETTINGS_POINTER_LOCK_BLOCKED_EXCEPTIONS 8413
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_DESCRIPTION 8414
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED 8415
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED 8416
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED_EXCEPTIONS 8417
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED_EXCEPTIONS 8418
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_DESCRIPTION 8419
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_ALLOWED 8420
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED 8421
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED_SUB_LABEL 8422
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_EXPLANATION 8423
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_ALLOWED 8424
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED 8425
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED_SUB_LABEL 8426
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_ALLOWED_EXCEPTIONS 8427
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED_EXCEPTIONS 8428
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_DESCRIPTION 8430
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_ALLOWED 8431
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED 8432
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED_EXCEPTIONS 8433
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_DESCRIPTION 8434
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ALLOWED 8435
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_BLOCKED 8436
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_DESCRIPTION 8437
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED 8438
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED 8439
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_SUB_LABEL 8440
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED_EXCEPTIONS 8441
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_EXCEPTIONS 8442
#define IDS_SETTINGS_SITE_SETTINGS_USB_DESCRIPTION 8443
#define IDS_SETTINGS_SITE_SETTINGS_USB_ALLOWED 8444
#define IDS_SETTINGS_SITE_SETTINGS_USB_BLOCKED 8445
#define IDS_SETTINGS_SITE_SETTINGS_VR_DESCRIPTION 8446
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED 8447
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED 8448
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED_EXCEPTIONS 8449
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED_EXCEPTIONS 8450
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_DESCRIPTION 8451
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_ASK 8452
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_BLOCK 8453
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_ALLOWED_EXCEPTIONS 8454
#define IDS_SETTINGS_SITE_SETTINGS_WEB_APP_INSTALLATION_BLOCKED_EXCEPTIONS 8455
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_DESCRIPTION 8456
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_ASK 8457
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_BLOCK 8458
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_ALLOWED_EXCEPTIONS 8459
#define IDS_SETTINGS_SITE_SETTINGS_WEB_PRINTING_BLOCKED_EXCEPTIONS 8460
#define IDS_SETTINGS_SITE_SETTINGS_ZOOM_LEVELS_DESCRIPTION 8461
#define IDS_SETTINGS_SITE_SETTINGS_AR_ASK 8462
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCK 8463
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_ASK 8464
#define IDS_SETTINGS_SITE_SETTINGS_HAND_TRACKING_BLOCK 8465
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DESCRIPTION 8466
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DEFAULT_BEHAVIOR_HEADING 8467
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_ALIGNED_PAGE_DESCRIPTION 8468
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 8469
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 8470
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 8471
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 8472
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_TITLE 8473
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_LABEL 8474
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_ENABLED 8475
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED_INCOGNITO 8476
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED 8477
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_RADIO_LABEL 8478
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_EXPAND_A11Y_LABEL 8479
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_BULLET_1 8480
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_BULLET_2 8481
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_RADIO_LABEL 8482
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_EXPAND_A11Y_LABEL 8483
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_BULLET_1 8484
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_BULLET_2 8485
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_RADIO_LABEL 8486
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_EXPAND_A11Y_LABEL 8487
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_BULLET_1 8488
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_BULLET_2 8489
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_TWO_RWS 8490
#define IDS_SETTINGS_COOKIES_RELATED_WEBSITE_SETS_TOGGLE_LABEL 8491
#define IDS_SETTINGS_COOKIES_RELATED_WEBSITE_SETS_TOGGLE_SUB_LABEL 8492
#define IDS_SETTINGS_COOKIES_ALL_SITES_LINK 8493
#define IDS_SETTINGS_TRACKING_PROTECTION_PAGE_DESCRIPTION 8494
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_ONE 8495
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_ONE_DESCRIPTION 8496
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO 8497
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO_DESCRIPTION 8498
#define IDS_SETTINGS_TRACKING_PROTECTION_BULLET_TWO_LEARN_MORE_ARIA_LABEL 8499
#define IDS_SETTINGS_TRACKING_PROTECTION_ADVANCED_LABEL 8500
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_TOGGLE_LABEL 8501
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_TOGGLE_SUB_LABEL 8502
#define IDS_SETTINGS_TRACKING_PROTECTION_THIRD_PARTY_COOKIES_LEARN_MORE_ARIA_LABEL 8503
#define IDS_SETTINGS_TRACKING_PROTECTION_DO_NOT_TRACK_TOGGLE_SUB_LABEL 8504
#define IDS_SETTINGS_TRACKING_PROTECTION_SITES_ALLOWED_COOKIES_TITLE 8505
#define IDS_SETTINGS_TRACKING_PROTECTION_SITES_ALLOWED_COOKIES_DESCRIPTION 8506
#define IDS_SETTINGS_SITE_SETTINGS_APP_PROTOCOL_HANDLERS 8507
#define IDS_SETTINGS_SITE_SETTINGS_APP_ALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 8508
#define IDS_SETTINGS_SITE_SETTINGS_APP_DISALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 8509
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ASK 8510
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCK 8511
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCK 8512
#define IDS_SETTINGS_SITE_SETTINGS_PDF_DOWNLOAD_PDFS 8513
#define IDS_SETTINGS_SITE_SETTINGS_RECENT_ACTIVITY 8514
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ASK_RECOMMENDED 8515
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_ZOOM_LEVEL 8516
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_SENDING 8517
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATICALLY_BLOCKED_NOTIFICATIONS 8518
#define IDS_SETTINGS_SITE_SETTINGS_SHOW_BLOCKED_NOTIFICATIONS_INDICATOR 8519
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW 8520
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK 8521
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY 8522
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO 8523
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW_SITES 8524
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_ASK_RECOMMENDED 8525
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_BLOCKED 8526
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_DESCRIPTION 8527
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK 8528
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED 8529
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK_EXCEPTIONS 8530
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED_EXCEPTIONS 8531
#define IDS_SETTINGS_SITE_SETTINGS_BLOCKED 8532
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW 8533
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK 8534
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY 8535
#define IDS_SETTINGS_SITE_SETTINGS_ASK_DEFAULT_MENU 8536
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_DEFAULT_MENU 8537
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DEFAULT_MENU 8538
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_DEFAULT_MENU 8539
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_DEFAULT_MENU 8540
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_MENU 8541
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_MENU 8542
#define IDS_SETTINGS_SITE_SETTINGS_ASK_MENU 8543
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_MENU 8544
#define IDS_SETTINGS_SITE_SETTINGS_RESET_MENU 8545
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY_MENU 8546
#define IDS_SETTINGS_SITE_SETTINGS_USAGE 8547
#define IDS_SETTINGS_SITE_SETTINGS_USAGE_NONE 8548
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS 8549
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS_MORE 8550
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT 8551
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT_MORE 8552
#define IDS_SETTINGS_SITE_SETTINGS_ALLOWLISTED 8553
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_BLOCKLISTED_SINGULAR 8554
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_NOT_BLOCKLISTED_SINGULAR 8555
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_KILL_SWITCH 8556
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_INSECURE_ORIGIN 8557
#define IDS_SETTINGS_SITE_SETTINGS_RESET_BUTTON 8558
#define IDS_SETTINGS_SITE_SETTINGS_DELETE 8559
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIES_EXCEPTION_LABEL 8560
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_DIALOG_TITLE 8561
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_DIALOG_TITLE 8562
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_LEARN_MORE 8563
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_LEARN_MORE_ACCESSIBILITY 8564
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_DESCRIPTION 8565
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_DESCRIPTION 8566
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_LABEL 8567
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_LABEL 8568
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DETAILS_SUBPAGE_ACCESSIBILITY_LABEL 8569
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_MEMBERSHIP_LABEL 8570
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_MORE_ACTIONS_TITLE 8571
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_SHOW_RELATED_SITES_BUTTON 8572
#define IDS_SETTINGS_SITE_SETTINGS_RELATED_WEBSITE_SETS_SITE_DELETE_STORAGE_BUTTON 8573
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION 8574
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION 8575
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION_INSTALLED 8576
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION_INSTALLED 8577
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_SIGN_OUT 8578
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_SIGN_OUT 8579
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_DIALOG_TITLE 8580
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_CONFIRMATION 8581
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_DIALOG_TITLE 8582
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION 8583
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION_NEW 8584
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_SIGN_OUT 8585
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_OFFLINE_DATA 8586
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_AD_PERSONALIZATION 8587
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_OFFLINE_DATA 8588
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_DIALOG_TITLE 8589
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_APP_DIALOG_TITLE 8590
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_PARTITIONED_DIALOG_TITLE 8591
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_DIALOG_TITLE 8592
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_DIALOG_TITLE 8593
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_PLURAL_DIALOG_TITLE 8594
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_LOGOUT 8595
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_LOGOUT 8596
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_OFFLINE_DATA 8597
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_PERMISSIONS 8598
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_CONFIRM 8599
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_SITE 8600
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_ALL 8601
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE 8602
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_IS_DEFAULT 8603
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_SET_DEFAULT 8604
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE 8605
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_ONLY 8606
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_SITE_EXCEPTION_DESC 8607
#define IDS_SETTINGS_SITE_SETTINGS_NO_ZOOMED_SITES 8608
#define IDS_SETTINGS_SITE_NO_SITES_ADDED 8609
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_AUTOPLAY 8610
#define IDS_SETTINGS_SITE_SETTINGS_EMPTY_ALL_SITES_PAGE 8611
#define IDS_SETTINGS_SITE_SETTINGS_NO_SITES_FOUND 8612
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_DESCRIPTION 8613
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ASK 8614
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCK 8615
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ALLOWED_EXCEPTIONS 8616
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCKED_EXCEPTIONS 8617
#define IDS_SETTINGS_SITE_SETTINGS_EXTENSION_ID_DESCRIPTION 8618
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_ALLOWED_SUB_LABEL 8619
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_BLOCKED_SUB_LABEL 8620
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_DELETE_ON_EXIT_SUB_LABEL 8621
#define IDS_SETTINGS_EXPIRES_AFTER_TIME_LABEL 8622
#define IDS_SETTINGS_SITE_DATA_PAGE_TITLE 8623
#define IDS_SETTINGS_SITE_DATA_PAGE_DESCRIPTION 8624
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_HEADING 8625
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 8626
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_LABEL 8627
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_SUB_LABEL 8628
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_LABEL 8629
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_LABEL 8630
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_SUB_LABEL 8631
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 8632
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 8633
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 8634
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_EXCEPTIONS_SUB_HEADING 8635
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_TITLE 8636
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_DESCRIPTION 8637
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CONFIRM_BUTTON 8638
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CANCEL_BUTTON 8639
#define IDS_SETTINGS_ADD_SITE_TO_ALLOW_LIST_LABEL 8640
#define IDS_SETTINGS_ADD_SITE_TO_BLOCK_LIST_LABEL 8641
#define IDS_SETTINGS_ADD_SITE_CONTEXT_MENU_LABEL 8642
#define IDS_SETTINGS_STORAGE_ACCESS_DESCRIPTION 8643
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED 8644
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED 8645
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_EXCEPTIONS 8646
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_EXCEPTIONS 8647
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_ALL 8648
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_SITE 8649
#define IDS_SETTINGS_STORAGE_ACCESS_OPEN_EXPAND 8650
#define IDS_SETTINGS_STORAGE_ACCESS_CLOSE_EXPAND 8651
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_SITE_LABEL 8652
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_SITE_LABEL 8653
#define IDS_SETTINGS_NO_BLUETOOTH_DEVICES_FOUND 8654
#define IDS_SETTINGS_NO_USB_DEVICES_FOUND 8655
#define IDS_SETTINGS_NO_SERIAL_PORTS_FOUND 8656
#define IDS_SETTINGS_NO_HID_DEVICES_FOUND 8657
#define IDS_SETTINGS_RESET_BLUETOOTH_CONFIRMATION 8658
#define IDS_SETTINGS_RESET_HID_CONFIRMATION 8659
#define IDS_SETTINGS_RESET_SERIAL_PORTS_CONFIRMATION 8660
#define IDS_SETTINGS_RESET_USB_CONFIRMATION 8661
#define IDS_SETTINGS_ADD_SITE_TITLE 8662
#define IDS_SETTINGS_ADD_SITES_TITLE 8663
#define IDS_SETTINGS_EDIT_SITE_TITLE 8664
#define IDS_SETTINGS_ADD_SITE 8665
#define IDS_SETTINGS_SITE_SETTINGS_NUM_COOKIES 8666
#define IDS_SETTINGS_PEOPLE 8667
#define IDS_SETTINGS_CHANGE_PICTURE_PROFILE_PHOTO 8668
#define IDS_SETTINGS_PEOPLE_SIGN_IN 8669
#define IDS_SETTINGS_PEOPLE_VERIFY_ACCOUNT_BUTTON 8670
#define IDS_SETTINGS_TURN_OFF_SYNC_MANAGED_PROFILE_EXPLANATION 8671
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE 8672
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE_SUPERVISED_PROFILE 8673
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_MANAGED_CONFIRM 8674
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_CHECKBOX 8675
#define IDS_SETTINGS_SYNC_SETTINGS_SAVED_TOAST_LABEL 8676
#define IDS_SETTINGS_CHROME_SIGNIN_OPTION_SAVED_TOAST_LABEL 8677
#define IDS_SETTINGS_PROFILE_NAME_INPUT_LABEL 8678
#define IDS_SETTINGS_PROFILE_SHORTCUT_TOGGLE_LABEL 8679
#define IDS_SETTINGS_CUSTOMIZE_PROFILE 8680
#define IDS_SETTINGS_PICK_A_THEME_COLOR 8681
#define IDS_SETTINGS_PICK_AN_AVATAR 8682
#define IDS_SETTINGS_CREATE_SHORTCUT 8683
#define IDS_SETTINGS_CREATE_SHORTCUT_SUBTITLE 8684
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPLANATION 8685
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION 8686
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION_SUPERVISED_PROFILE 8687
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPAND_ACCESSIBILITY_LABEL 8688
#define IDS_SETTINGS_SYNC_WILL_START 8689
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_LABEL 8690
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_TEXT 8691
#define IDS_SETTINGS_ENCRYPT_WITH_SYNC_PASSPHRASE_LABEL 8692
#define IDS_SETTINGS_PASSPHRASE_EXPLANATION_TEXT 8693
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_ENCRYPTION 8694
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_TOGGLE 8695
#define IDS_SETTINGS_PASSPHRASE_RECOVER 8696
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE 8697
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE_V2 8698
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_WAA_TITLE 8699
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_LINKED_SERVICES_TITLE 8700
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_PLACEHOLDER 8701
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_SIGNIN 8702
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_DO_NOT_SIGNIN 8703
#define IDS_SETTINGS_SIGNIN_CHROME_SIGNIN_OPTION_ALWAYS_ASK 8704
#define IDS_SETTINGS_MANAGE_GOOGLE_ACCOUNT 8705
#define IDS_SETTINGS_IMPORT_SETTINGS_TITLE 8706
#define IDS_SETTINGS_IMPORT_FROM_LABEL 8707
#define IDS_SETTINGS_IMPORT_ITEMS_LABEL 8708
#define IDS_SETTINGS_IMPORT_LOADING_PROFILES 8709
#define IDS_SETTINGS_IMPORT_HISTORY_CHECKBOX 8710
#define IDS_SETTINGS_IMPORT_FAVORITES_CHECKBOX 8711
#define IDS_SETTINGS_IMPORT_PASSWORDS_CHECKBOX 8712
#define IDS_SETTINGS_IMPORT_SEARCH_ENGINES_CHECKBOX 8713
#define IDS_SETTINGS_IMPORT_AUTOFILL_FORM_DATA_CHECKBOX 8714
#define IDS_SETTINGS_IMPORT_CHOOSE_FILE 8715
#define IDS_SETTINGS_IMPORT_COMMIT 8716
#define IDS_SETTINGS_IMPORT_SUCCESS 8717
#define IDS_SETTINGS_IMPORT_NO_PROFILE_FOUND 8718
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_LABEL 8719
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_SUBLABEL 8720
#define IDS_SETTINGS_HISTORY_SEARCH_SETTING_SUBLABEL_V2 8721
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_BULLET_ONE 8722
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_BULLET_ONE 8723
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_BULLET_TWO 8724
#define IDS_SETTINGS_HISTORY_SEARCH_LEARN_MORE_A11Y_LABEL 8725
#define IDS_SETTINGS_HISTORY_SEARCH_ANSWERS_SETTING_SUBLABEL 8726
#define IDS_SETTINGS_HISTORY_SEARCH_ANSWERS_WHEN_ON_BULLET_ONE 8727
#define IDS_SETTINGS_HISTORY_SEARCH_ANSWERS_WHEN_ON_BULLET_TWO 8728
#define IDS_SETTINGS_HISTORY_SEARCH_ANSWERS_CONSIDER_BULLET_ONE 8729
#define IDS_SETTINGS_HISTORY_SEARCH_ANSWERS_CONSIDER_BULLET_TWO 8730
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_PAGE_CONTENT 8731
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_SEARCH_FROM 8732
#define IDS_SETTINGS_HISTORY_SEARCH_WHEN_ON_LOG_START 8733
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_DATA 8734
#define IDS_SETTINGS_HISTORY_SEARCH_CONSIDER_DATA_ENCRYPTED 8735
#define IDS_SETTINGS_HISTORY_SEARCH_SUBLABEL_ON 8736
#define IDS_SETTINGS_HISTORY_SEARCH_SUBLABEL_OFF 8737
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_SETTING_SUBLABEL_V2 8738
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_WHEN_ON_PAGE_CONTENT 8739
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_WHEN_ON_RECALL_INFO 8740
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_CONSIDER_DATA_ENCRYPTED 8741
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_CONSIDER_OUTDATED 8742
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_SUBLABEL_ON 8743
#define IDS_SETTINGS_HISTORY_SEARCH_WITH_ANSWERS_SUBLABEL_OFF 8744
#define IDS_SETTINGS_PAGE_ZOOM_LABEL 8745
#define IDS_SETTINGS_FONT_SIZE_LABEL 8746
#define IDS_SETTINGS_VERY_SMALL_FONT 8747
#define IDS_SETTINGS_SMALL_FONT 8748
#define IDS_SETTINGS_MEDIUM_FONT 8749
#define IDS_SETTINGS_LARGE_FONT 8750
#define IDS_SETTINGS_VERY_LARGE_FONT 8751
#define IDS_SETTINGS_CUSTOMIZE_FONTS 8752
#define IDS_SETTINGS_FONTS 8753
#define IDS_SETTINGS_STANDARD_FONT_LABEL 8754
#define IDS_SETTINGS_SERIF_FONT_LABEL 8755
#define IDS_SETTINGS_SANS_SERIF_FONT_LABEL 8756
#define IDS_SETTINGS_FIXED_WIDTH_FONT_LABEL 8757
#define IDS_SETTINGS_MATH_FONT_LABEL 8758
#define IDS_SETTINGS_MINIMUM_FONT_SIZE_LABEL 8759
#define IDS_SETTINGS_TINY_FONT_SIZE 8760
#define IDS_SETTINGS_HUGE_FONT_SIZE 8761
#define IDS_SETTINGS_QUICK_BROWN_FOX 8762
#define IDS_SETTINGS_SYSTEM 8763
#define IDS_SETTINGS_SYSTEM_HARDWARE_ACCELERATION_LABEL 8764
#define IDS_SETTINGS_SYSTEM_FEATURE_NOTIFICATIONS_LABEL 8765
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_LABEL 8766
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_EXTENSION_LABEL 8767
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_POLICY_LABEL 8768
#define IDS_PAGE_NOT_AVAILABLE_FOR_GUEST_HEADING 8777
#define IDS_SETTINGS_SECURITY_KEYS_TITLE 8778
#define IDS_SETTINGS_SECURITY_KEYS_DESC 8779
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN 8780
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_BUTTON 8781
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_DESC 8782
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_INITIAL_TITLE 8783
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CREATE_TITLE 8784
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CHANGE_TITLE 8785
#define IDS_SETTINGS_SECURITY_KEYS_RESET 8786
#define IDS_SETTINGS_SECURITY_KEYS_RESET_DESC 8787
#define IDS_SETTINGS_SECURITY_KEYS_RESET_TITLE 8788
#define IDS_SETTINGS_SECURITY_KEYS_RESET_CONFIRM_TITLE 8789
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP1 8790
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP2 8791
#define IDS_SETTINGS_SECURITY_KEYS_NO_RESET 8792
#define IDS_SETTINGS_SECURITY_KEYS_RESET_ERROR 8793
#define IDS_SETTINGS_SECURITY_KEYS_RESET_SUCCESS 8794
#define IDS_SETTINGS_SECURITY_KEYS_RESET_NOTALLOWED 8795
#define IDS_SETTINGS_SECURITY_KEYS_NO_PIN 8796
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN_INTRO 8797
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT 8798
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_SIN 8799
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_PL 8800
#define IDS_SETTINGS_SECURITY_KEYS_SAME_PIN_AS_CURRENT 8801
#define IDS_SETTINGS_SECURITY_KEYS_NEW_PIN 8802
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CONFIRM 8803
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN 8804
#define IDS_SETTINGS_SECURITY_KEYS_PIN 8805
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_SHORT_SMALL 8806
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_LONG 8807
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_INVALID 8808
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_MISMATCH 8809
#define IDS_SETTINGS_SECURITY_KEYS_CONFIRM_PIN 8810
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SUCCESS 8811
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR 8812
#define IDS_SETTINGS_SECURITY_KEYS_PIN_HARD_LOCK 8813
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SOFT_LOCK 8814
#define IDS_SETTINGS_SECURITY_KEYS_SHOW_PINS 8815
#define IDS_SETTINGS_SECURITY_KEYS_HIDE_PINS 8816
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_LABEL 8817
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_USERNAME_LABEL 8818
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_DISPLAYNAME_LABEL 8819
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_WEBSITE_LABEL 8820
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DESC 8821
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DIALOG_TITLE 8822
#define IDS_SETTINGS_SECURITY_KEYS_UPDATE_CREDENTIAL_DIALOG_TITLE 8823
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_TITLE 8824
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_CREDENTIAL 8825
#define IDS_SETTINGS_SECURITY_KEYS_INPUT_ERROR_TOO_LONG 8826
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_CREDENTIALS 8827
#define IDS_SETTINGS_SECURITY_KEYS_NO_CREDENTIAL_MANAGEMENT 8828
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_REMOVED 8829
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_PIN 8830
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_ERROR 8831
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_SUCCESS 8832
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_FAILED 8833
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_SUCCESS 8834
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_FAILED 8835
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_LABEL 8836
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_DESCRIPTION 8837
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DIALOG_TITLE 8838
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ADD_TITLE 8839
#define IDS_SETTINGS_SECURITY_KEYS_BIO_CHOOSE_NAME 8840
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL 8841
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL_TOO_LONG 8842
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_NO_ENROLLMENTS_LABEL 8843
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLMENTS_LABEL 8844
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_LABEL 8845
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_TRY_AGAIN_LABEL 8846
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_FAILED_LABEL 8847
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_COMPLETE_LABEL 8848
#define IDS_SETTINGS_SECURITY_KEYS_NO_BIOMETRIC_ENROLLMENT 8849
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DELETE 8850
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NO_PIN 8851
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_STORAGE_FULL 8852
#define IDS_SETTINGS_SECURITY_KEYS_TOUCH_TO_CONTINUE 8853
#define IDS_SETTINGS_SECURITY_KEYS_PIN_PROMPT 8854
#define IDS_SETTINGS_SECURITY_KEYS_FORCE_PIN_CHANGE 8855
#define IDS_SETTINGS_SECURITY_KEYS_PHONE_EDIT_DIALOG_TITLE 8856
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_YOUR_DEVICES 8857
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_SYNCED_DESC 8858
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DEVICES 8859
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DESC 8860
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE 8861
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE_DESC 8862
#define IDS_SETTINGS_EXTENSION_OR_APP_DISPLAY_NAME 8863
#define IDS_SETTINGS_SAFETY_HUB 8864
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_BUTTON_LABEL 8865
#define IDS_SETTINGS_SAFETY_HUB_PAGE_CARD_SECTION_HEADER 8866
#define IDS_SETTINGS_SAFETY_HUB_PAGE_MODULE_SECTION_HEADER 8867
#define IDS_SETTINGS_SAFETY_HUB_EMPTY_STATE_MODULE_HEADER 8868
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_RECENTLY 8869
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_SOME_TIME_AGO 8870
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_HEADER_NO_WEAK_OR_REUSED 8871
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_SIGN_IN 8872
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_GO_TO_PASSWORD_MANAGER 8873
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_HEADER_NO_PASSWORDS 8874
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_CHECK_SUBHEADER_NO_PASSWORDS_POLICY 8875
#define IDS_SETTINGS_SAFETY_HUB_PASSWORD_NAVIGATION_ARIA_LABEL 8876
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_ENHANCED_HEADER 8877
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_ENHANCED_SUBHEADER 8878
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_STANDARD_HEADER 8879
#define IDS_SETTINGS_SAFETY_HUB_SB_ON_STANDARD_SUBHEADER 8880
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_HEADER 8881
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_MANAGED_SUBHEADER 8882
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_EXTENSION_SUBHEADER 8883
#define IDS_SETTINGS_SAFETY_HUB_SB_OFF_USER_SUBHEADER 8884
#define IDS_SETTINGS_SAFETY_HUB_SB_NAVIGATION_ARIA_LABEL 8885
#define IDS_SETTINGS_SAFETY_HUB_GO_SITE_SETTINGS_ITEM 8886
#define IDS_SETTINGS_SAFETY_HUB_GO_NOTIFICATION_SETTINGS_ITEM 8887
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_INCOGNITO_SUBHEADER 8888
#define IDS_SETTINGS_SAFETY_HUB_USER_EDU_SAFE_BROWSING_HEADER 8889
#define IDS_SETTINGS_SAFETY_HUB_VERSION_CARD_SUBHEADER_RESTART 8890
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATION_PERMISSIONS_PRIMARY_LABEL 8891
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATION_PERMISSIONS_SECONDARY_LABEL 8892
#define IDS_SETTINGS_SAFETY_HUB_UNUSED_SITE_PERMISSIONS_MENU_NOTIFICATION 8893
#define IDS_SETTINGS_SAFETY_HUB_REVOKED_PERMISSIONS_MENU_NOTIFICATION 8894
#define IDS_SETTINGS_SAFETY_HUB_REVIEW_NOTIFICATION_PERMISSIONS_MENU_NOTIFICATION 8895
#define IDS_SETTINGS_SAFETY_HUB_COMPROMISED_PASSWORDS_MENU_NOTIFICATION 8896
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MENU_NOTIFICATION 8897
#define IDS_SETTINGS_SAFETY_HUB_SAFE_BROWSING_MENU_NOTIFICATION 8898
#define IDS_SETTINGS_SAFETY_HUB_PASSWORDS_MODULE_NAME 8899
#define IDS_SETTINGS_SAFETY_HUB_SAFE_BROWSING_MODULE_NAME 8900
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MODULE_UPPERCASE_NAME 8901
#define IDS_SETTINGS_SAFETY_HUB_EXTENSIONS_MODULE_LOWERCASE_NAME 8902
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATIONS_MODULE_UPPERCASE_NAME 8903
#define IDS_SETTINGS_SAFETY_HUB_NOTIFICATIONS_MODULE_LOWERCASE_NAME 8904
#define IDS_SETTINGS_SAFETY_HUB_PERMISSIONS_MODULE_UPPERCASE_NAME 8905
#define IDS_SETTINGS_SAFETY_HUB_PERMISSIONS_MODULE_LOWERCASE_NAME 8906
#define IDS_SETTINGS_SAFETY_HUB_MODULE_NAME_SEPARATOR 8907
#define IDS_SETTINGS_AI_PAGE_TITLE 8908
#define IDS_SETTINGS_AI_INNOVATIONS_PAGE_TITLE 8909
#define IDS_SETTINGS_AI_PAGE_MAIN_TITLE 8910
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL_1 8911
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL_2 8912
#define IDS_SETTINGS_AI_PAGE_MAIN_SUBLABEL_3 8913
#define IDS_SETTINGS_AI_PAGE_MAIN_MANAGED_SUBLABEL_3 8914
#define IDS_SETTINGS_AI_PAGE_MAIN_MANAGED_LEARN_MORE_ACCESSIBILITY_LABEL 8915
#define IDS_SETTINGS_AI_SUBPAGE_SUBLABEL_AI 8916
#define IDS_SETTINGS_AI_SUBPAGE_SUBLABEL_REVIEWERS 8917
#define IDS_SETTINGS_AI_SUBPAGE_SUBLABEL_LOGGING_MANAGED_DISABLED 8918
#define IDS_SETTINGS_AI_SUBPAGE_FEATURE_MANAGED_DISABLED_LABEL 8919
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE2_LABEL 8920
#define IDS_SETTINGS_TAB_ORGANIZER_SUB_LABEL 8921
#define IDS_SETTINGS_AUTOTABS_SETTING_LINK_A11Y 8922
#define IDS_SETTINGS_TAB_ORGANIZER_WHEN_ON_AUTO_GROUPS 8923
#define IDS_SETTINGS_TAB_ORGANIZER_WHEN_ON_IMPROVE_FOCUS 8924
#define IDS_SETTINGS_TAB_ORGANIZER_CONSIDER_DATA 8925
#define IDS_SETTINGS_EXPERIMENTAL_ADVANCED_FEATURE3_LABEL 8926
#define IDS_SETTINGS_AI_THEMES_SUB_LABEL 8927
#define IDS_SETTINGS_COMPARE_SETTING_SUBLABEL 8928
#define IDS_SETTINGS_COMPARE_SETTING_LINK_A11Y 8929
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_DETAILS 8930
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_SUGGEST 8931
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_FILTER 8932
#define IDS_SETTINGS_COMPARE_WHEN_ON_PRODUCT_REVIEWS 8933
#define IDS_SETTINGS_COMPARE_CONSIDER_DATA 8934
#define IDS_SETTINGS_COMPARE_CONSIDER_TABLES_IN_ACCOUNT 8935
#define IDS_SETTINGS_PASSWORD_CHANGE_LABEL 8936
#define IDS_SETTINGS_PASSWORD_CHANGE_SUBLABEL 8937
#define IDS_SETTINGS_PASSWORD_CHANGE_DATA_BREACH 8938
#define IDS_SETTINGS_PASSWORD_CHANGE_WHERE_SAVED 8939
#define IDS_SETTINGS_PASSWORD_CHANGE_EXPERIMENTAL 8940
#define IDS_SETTINGS_PASSWORD_CHANGE_CONTENT 8941
#define IDS_SETTINGS_PASSWORD_CHANGE_ENCRYPTION 8942
#define IDS_SETTINGS_SAFEBROWSING_TURN_ON_ENHANCED_TOAST_BUTTON 8943
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_ON_TOAST_MESSAGE 8944
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_OFF_TOAST_MESSAGE 8945
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_LABEL 8946
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 8947
#define IDS_SETTINGS_SUBPAGE_LEARN_MORE_ARIA_LABEL 8948
#define IDS_SETTINGS_CAPTIONS 8949
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_TITLE 8950
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_SUBTITLE 8951
#define IDS_SETTINGS_CAPTIONS_TEXT_SIZE 8952
#define IDS_SETTINGS_CAPTIONS_TEXT_FONT 8953
#define IDS_SETTINGS_CAPTIONS_TEXT_COLOR 8954
#define IDS_SETTINGS_CAPTIONS_TEXT_OPACITY 8955
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_OPACITY 8956
#define IDS_SETTINGS_CAPTIONS_OPACITY_OPAQUE 8957
#define IDS_SETTINGS_CAPTIONS_OPACITY_SEMI_TRANSPARENT 8958
#define IDS_SETTINGS_CAPTIONS_OPACITY_TRANSPARENT 8959
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW 8960
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_NONE 8961
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_RAISED 8962
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DEPRESSED 8963
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_UNIFORM 8964
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DROP_SHADOW 8965
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_COLOR 8966
#define IDS_SETTINGS_CAPTIONS_COLOR_BLACK 8967
#define IDS_SETTINGS_CAPTIONS_COLOR_WHITE 8968
#define IDS_SETTINGS_CAPTIONS_COLOR_RED 8969
#define IDS_SETTINGS_CAPTIONS_COLOR_GREEN 8970
#define IDS_SETTINGS_CAPTIONS_COLOR_BLUE 8971
#define IDS_SETTINGS_CAPTIONS_COLOR_YELLOW 8972
#define IDS_SETTINGS_CAPTIONS_COLOR_CYAN 8973
#define IDS_SETTINGS_CAPTIONS_COLOR_MAGENTA 8974
#define IDS_SETTINGS_CAPTIONS_DEFAULT_SETTING 8975
#define IDS_SETTINGS_CAPTIONS_LANGUAGE 8976
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_TITLE 8977
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_SUBTITLE 8978
#define IDS_SETTINGS_CAPTIONS_LIVE_TRANSLATE_TARGET_LANGUAGE 8979
#define IDS_SETTINGS_CAPTIONS_LIVE_TRANSLATE_TARGET_LANGUAGE_SUBTITLE 8980
#define IDS_SETTINGS_CAPTIONS_REMOVE_LANGUAGE_LABEL 8981
#define IDS_SETTINGS_CAPTIONS_MAKE_DEFAULT_LANGUAGE_LABEL 8982
#define IDS_SETTINGS_CAPTIONS_DEFAULT_LANGUAGE_LABEL 8983
#define IDS_SETTINGS_NEARBY_SHARE_TITLE 8984
#define IDS_SETTINGS_NEARBY_SHARE_TITLE_PH 8985
#define IDS_SETTINGS_NEARBY_SHARE_SET_UP_BUTTON_TITLE 8986
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ROW_TITLE 8987
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_DIALOG_TITLE 8988
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_FIELD_LABEL 8989
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DEVICE_NAME 8990
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_TITLE 8991
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_DESCRIPTION 8992
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_ARIA_LABEL 8993
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ARIA_DESCRIPTION 8994
#define IDS_SETTINGS_NEARBY_SHARE_CONFIRM_DEVICE_NAME 8995
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_LABEL 8996
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_ROW_TITLE 8997
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DATA_USAGE 8998
#define IDS_SETTINGS_NEARBY_SHARE_UPDATE_DATA_USAGE 8999
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_DIALOG_TITLE 9000
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_LABEL 9001
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_DESCRIPTION 9002
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_LABEL 9003
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_DESCRIPTION 9004
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_TOOLTIP 9005
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_LABEL 9006
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_DESCRIPTION 9007
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_DATA_DESCRIPTION 9008
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_WIFI_ONLY_DESCRIPTION 9009
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_OFFLINE_DESCRIPTION 9010
#define IDS_SETTINGS_NEARBY_SHARE_CONTACT_VISIBILITY_ROW_TITLE 9011
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_VISIBILITY 9012
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_TITLE 9013
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_SAVE 9014
#define IDS_SETTINGS_NEARBY_SHARE_DESCRIPTION 9015
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_TITLE 9016
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_ON 9017
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_OFF 9018
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION 9019
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION_DESC 9020
#define IDS_SETTINGS_SPELLING_PREF 9021
#define IDS_SETTINGS_ENABLE_LOGGING_PREF 9022
#define IDS_SETTINGS_ENABLE_LOGGING_PREF_DESC 9023
#define IDS_SETTINGS_LINKDOCTOR_PREF 9024
#define IDS_SETTINGS_LINKDOCTOR_PREF_DESC 9025
#define IDS_SETTINGS_SUGGEST_PREF 9026
#define IDS_SETTINGS_PEOPLE_SIGNED_IN_TO_ACCOUNT 9027
#define IDS_SETTINGS_PEOPLE_SYNCING_TO_ACCOUNT 9028
#define IDS_SETTINGS_PEOPLE_SYNC_PAUSED 9029
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT 9030
#define IDS_SETTINGS_PEOPLE_SYNC_TURN_OFF 9031
#define IDS_SETTINGS_SETTINGS_CHECKBOX_LABEL 9032
#define IDS_SETTINGS_PEOPLE_SYNC_NOT_WORKING 9033
#define IDS_SETTINGS_PEOPLE_SYNC_PASSWORDS_NOT_WORKING 9034
#define IDS_SETTINGS_SYNC_ADVANCED_PAGE_TITLE 9035
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_PAGE_TITLE 9036
#define IDS_SETTINGS_PEOPLE_SYNC_ANOTHER_ACCOUNT 9037
#define IDS_SETTINGS_TURN_ON_SYNC_BUTTON_UPDATE_SETTINGS_UI_ENABLED 9038
#define IDS_SETTINGS_ACCOUNT_AWARE_SIGNIN_BUTTON_LABEL 9039
#define IDS_SETTINGS_ERROR_PASSWORDS_USER_ERROR_DESCRIPTION 9040
#define IDS_SETTINGS_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_ERROR_DESCRIPTION 9041
#define IDS_SETTINGS_PEOPLE_ACCOUNT_AWARE_SIGNIN_ACCOUNT_ROW_SUBTITLE_WITH_EMAIL 9042
#define IDS_SETTINGS_CHANGE_ACCOUNT 9043
#define IDS_SETTINGS_SYNC_DISCONNECT_CONFIRM 9044
#define IDS_SETTINGS_PEOPLE_SIGN_OUT 9045
#define IDS_SETTINGS_AUTOFILL_CHECKBOX_LABEL 9046
#define IDS_SETTINGS_HISTORY_CHECKBOX_LABEL 9047
#define IDS_SETTINGS_EXTENSIONS_CHECKBOX_LABEL 9048
#define IDS_SETTINGS_OPEN_TABS_CHECKBOX_LABEL 9049
#define IDS_SETTINGS_SAVED_TAB_GROUPS_CHECKBOX_LABEL 9050
#define IDS_SETTINGS_PRODUCT_COMPARISONS_CHECKBOX_LABEL 9051
#define IDS_SETTINGS_WIFI_CONFIGURATIONS_CHECKBOX_LABEL 9052
#define IDS_SETTINGS_SYNC_EVERYTHING_CHECKBOX_LABEL 9053
#define IDS_SETTINGS_APPS_CHECKBOX_LABEL 9054
#define IDS_SETTINGS_APPS_CHECKBOX_SUBLABEL 9055
#define IDS_SETTINGS_NON_PERSONALIZED_SERVICES_SECTION_LABEL 9056
#define IDS_SETTINGS_CUSTOMIZE_SYNC 9057
#define IDS_SETTINGS_SYNC_DATA 9058
#define IDS_SETTINGS_PASSWORDS_AND_PASSKEYS_CHECKBOX_LABEL 9059
#define IDS_SETTINGS_PASSPHRASE_PLACEHOLDER 9060
#define IDS_SETTINGS_EXISTING_PASSPHRASE_TITLE 9061
#define IDS_SETTINGS_SUBMIT_PASSPHRASE 9062
#define IDS_SETTINGS_ENCRYPT_WITH_GOOGLE_CREDENTIALS_LABEL 9063
#define IDS_SETTINGS_BOOKMARKS_CHECKBOX_LABEL 9064
#define IDS_SETTINGS_READING_LIST_CHECKBOX_LABEL 9065
#define IDS_SETTINGS_ENCRYPTION_OPTIONS 9066
#define IDS_SETTINGS_MISMATCHED_PASSPHRASE_ERROR 9067
#define IDS_SETTINGS_EMPTY_PASSPHRASE_ERROR 9068
#define IDS_SETTINGS_INCORRECT_PASSPHRASE_ERROR 9069
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_TITLE_UNIFIED_CONSENT 9070
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_DEVICE_PAGE_TITLE 9071
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_BROWSER_PAGE_TITLE 9072
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_SUBTITLE_UNIFIED_CONSENT 9073
#define IDS_SETTINGS_NEW_MANAGE_BROWSER_SYNCED_DATA_TITLE 9074
#define IDS_SETTINGS_SYNC_SYNC_AND_NON_PERSONALIZED_SERVICES 9075
#define IDS_SETTINGS_PASSPHRASE_CONFIRMATION_PLACEHOLDER 9076
#define IDS_SETTINGS_SYNC_LOADING 9077
#define IDS_SETTINGS_SYNC_TIMEOUT 9078
#define IDS_SETTINGS_SYNC 9079
#define IDS_SETTINGS_SYNC_SETTINGS_CANCEL_SYNC 9080
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_TITLE 9081
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_BODY 9082
#define IDS_SYNC_UNAVAILABLE_FOR_NON_GOOGLE_ACCOUNT 9083
#define IDS_SETTINGS_ABOUT_UPGRADE_CHECK_STARTED 9086
#define IDS_SETTINGS_UPDATE_TO_ROLLBACK_VERSION_DISALLOWED 9087
#define IDS_SETTINGS_THEME_CHECKBOX_LABEL 9089
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_TITLE 9093
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES 9094
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_LOCAL_CERTIFICATES 9095
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_CERTIFICATES 9096
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_HASH_COPIED_TOAST 9097
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM 9098
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_TITLE 9099
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_MANAGE_LINK 9100
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_VIEW_LINK 9101
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_MANAGE_LINK_ARIA_DESCRIPTION 9102
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_ADMIN_CERTS_TITLE 9103
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_USER_CERTS_TITLE 9104
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_TRUSTED_CERTS_LIST 9105
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_INTERMEDIATE_CERTS_LIST 9106
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DISTRUSTED_CERTS_LIST 9107
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_NO_CERTIFICATES_ROW 9108
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_EXPORT_BUTTON_LABEL 9109
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_EXPORT_BUTTON_ARIA_LABEL 9110
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_BUTTON_LABEL 9111
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_BUTTON_ARIA_LABEL 9112
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_AND_BIND_BUTTON_LABEL 9113
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_AND_BIND_BUTTON_ARIA_LABEL 9114
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_NUM_CERTS 9115
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_DESCRIPTION 9116
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_LOCAL_CERTIFICATES_DESCRIPTION 9117
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_CERTIFICATES_DESCRIPTION 9118
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_LEARN_MORE_LINK 9119
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CRS_LEARN_MORE_LINK_ARIA_LABEL 9120
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_PLATFORM_CERTS_TOGGLE_LABEL 9121
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CUSTOM_CERTS_TITLE 9122
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_FROM_PLATFORM 9123
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_FROM_ADMIN 9124
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_CLIENT_CERTIFICATES_FROM_EXTENSION 9125
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_CERT_TITLE 9126
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_SERVER_CERT_DESCRIPTION 9128
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_READ_FILE_ERROR 9129
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_MULTIPLE_CERT_ERROR 9130
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_ERROR_TITLE 9131
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_DELETE_ERROR 9132
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_ENTER_PASSWORD_TITLE 9133
#define IDS_SETTINGS_CERTIFICATE_MANAGER_V2_IMPORT_ERROR_TITLE 9134
#define IDS_CERTIFICATE_MANAGER_V2_SUBPAGE_BACK_BUTTON_ARIA_LABEL 9140
#define IDS_CERTIFICATE_MANAGER_V2_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 9141
#define IDS_CERTIFICATE_MANAGER_V2_LIST_EXPAND_ARIA_LABEL 9142
#define IDS_CERTIFICATE_MANAGER_V2_CERT_ENTRY_VIEW_ARIA_LABEL 9143
#define IDS_CERTIFICATE_MANAGER_V2_CERT_ENTRY_DELETE_ARIA_LABEL 9144
#define IDS_CERTIFICATE_MANAGER_V2_CERT_HASH_COPY_ARIA_LABEL 9145
#define IDS_SUPPORT_TOOL_ISSUE_DETAILS_PAGE_TITLE 9146
#define IDS_SUPPORT_TOOL_DATA_SELECTION_PAGE_TITLE 9147
#define IDS_SUPPORT_TOOL_REVIEW_PII_PAGE_TITLE 9148
#define IDS_SUPPORT_TOOL_DATA_EXPORT_DONE_PAGE_TITLE 9149
#define IDS_SUPPORT_TOOL_DATA_EXPORTED_TEXT 9150
#define IDS_SUPPORT_TOOL_SUPPORT_CASE_ID 9151
#define IDS_SUPPORT_TOOL_EMAIL 9152
#define IDS_SUPPORT_TOOL_DESCRIBE_ISSUE_TEXT 9153
#define IDS_SUPPORT_TOOL_ISSUE_DESCRIPTION_PLACEHOLDER 9154
#define IDS_SUPPORT_TOOL_PII_WARNING_TEXT 9155
#define IDS_SUPPORT_TOOL_INCLUDE_ALL_PII_RADIO_BUTTON 9156
#define IDS_SUPPORT_TOOL_REMOVE_PII_RADIO_BUTTON 9157
#define IDS_SUPPORT_TOOL_PII_REMOVAL_DISCLAIMER 9158
#define IDS_SUPPORT_TOOL_MANUALLY_SELECT_PII_RADIO_BUTTON 9159
#define IDS_SUPPORT_TOOL_CANCEL_BUTTON_TEXT 9160
#define IDS_SUPPORT_TOOL_EXPORT_BUTTON_TEXT 9161
#define IDS_SUPPORT_TOOL_BACK_BUTTON_TEXT 9162
#define IDS_SUPPORT_TOOL_DISMISS_BUTTON_TEXT 9163
#define IDS_SUPPORT_TOOL_CONTINUE_BUTTON_TEXT 9164
#define IDS_SUPPORT_TOOL_DATA_COLLECTION_SPINNER 9165
#define IDS_SUPPORT_TOOL_DATA_EXPORT_SPINNER 9166
#define IDS_SUPPORT_TOOL_TAB_TITLE 9167
#define IDS_SUPPORT_TOOL_URL_GENERATOR_PAGE_TITLE 9168
#define IDS_SUPPORT_TOOL_DATA_COLLECTOR_LIST_TITLE 9169
#define IDS_SUPPORT_TOOL_GET_LINK_TEXT 9170
#define IDS_SUPPORT_TOOL_COPY_LINK_DESCRIPTION 9171
#define IDS_SUPPORT_TOOL_COPY_LINK_BUTTON_TEXT 9172
#define IDS_SUPPORT_TOOL_COPY_TOKEN_BUTTON_TEXT 9173
#define IDS_SUPPORT_TOOL_DONT_INCLUDE_EMAIL 9174
#define IDS_SUPPORT_TOOL_LINK_COPIED_TEXT 9175
#define IDS_SUPPORT_TOOL_TOKEN_COPIED_TEXT 9176
#define IDS_SUPPORT_TOOL_SELECT_DATA_COLLECTOR_ERROR 9177
#define IDS_SUPPORT_TOOL_SELECT_ALL 9178
#define IDS_SUPPORT_TOOL_CHROME_SYSTEM_INFO 9179
#define IDS_SUPPORT_TOOL_CRASH_IDS 9180
#define IDS_SUPPORT_TOOL_MEMORY_DETAILS 9181
#define IDS_SUPPORT_TOOL_UI_HIEARCHY 9182
#define IDS_SUPPORT_TOOL_ADDITIONAL_CROS_PLATFROM_LOGS 9183
#define IDS_SUPPORT_TOOL_DEVICE_EVENT 9184
#define IDS_SUPPORT_TOOL_INTEL_WIFI_DEBUG_DUMP 9185
#define IDS_SUPPORT_TOOL_TOUCH_EVENTS 9186
#define IDS_SUPPORT_TOOL_CHROMEOS_FLEX_LOGS 9187
#define IDS_SUPPORT_TOOL_DBUS_DETAILS 9188
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_ROUTES 9189
#define IDS_SUPPORT_TOOL_CHROMEOS_SHILL_LOGS 9190
#define IDS_SUPPORT_TOOL_POLICIES 9191
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_STATE 9192
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_LOGS 9193
#define IDS_SUPPORT_TOOL_CHROMEOS_CHROME_USER_LOGS 9194
#define IDS_SUPPORT_TOOL_CHROMEOS_BLUETOOTH_FLOSS 9195
#define IDS_SUPPORT_TOOL_CHROMEOS_CONNECTED_INPUT_DEVICES 9196
#define IDS_SUPPORT_TOOL_CHROMEOS_TRAFFIC_COUNTERS 9197
#define IDS_SUPPORT_TOOL_CHROMEOS_VIRTUAL_KEYBOARD 9198
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_HEALTH 9199
#define IDS_SUPPORT_TOOL_PERFORMANCE 9200
#define IDS_SUPPORT_TOOL_SIGN_IN 9201
#define IDS_SUPPORT_TOOL_CHROMEOS_APP_SERVICE 9202
#define IDS_SUPPORT_TOOL_ANDROID_APP_INFO 9203
#define IDS_SUPPORT_TOOL_WIFI_SSID 9204
#define IDS_SUPPORT_TOOL_CELLULAR_LOCATION_INFO 9205
#define IDS_SUPPORT_TOOL_EMAIL_ADDRESS 9206
#define IDS_SUPPORT_TOOL_GAIA_ID 9207
#define IDS_SUPPORT_TOOL_STABLE_IDENTIDIERS 9208
#define IDS_SUPPORT_TOOL_PRINTING_IPP_ADDRESS 9209
#define IDS_SUPPORT_TOOL_IP_ADDRESS 9210
#define IDS_SUPPORT_TOOL_MAC_ADDRESS 9211
#define IDS_SUPPORT_TOOL_WINDOW_TITLES 9212
#define IDS_SUPPORT_TOOL_URLS 9213
#define IDS_SUPPORT_TOOL_SERIAL_NUMBERS 9214
#define IDS_SUPPORT_TOOL_REMOVABLE_STORAGE_NAMES 9215
#define IDS_SUPPORT_TOOL_EAP 9216
#define IDS_EXTENSIONS_ALLOW_FILE_ACCESS 9217
#define IDS_EXTENSIONS_ALLOW_ON_ALL_URLS 9218
#define IDS_EXTENSIONS_ALLOW_ON_FOLLOWING_SITES 9219
#define IDS_EXTENSIONS_VIEW_ACTIVITY_LOG 9220
#define IDS_EXTENSIONS_BACKGROUND_PAGE 9221
#define IDS_EXTENSIONS_SERVICE_WORKER_BACKGROUND 9222
#define IDS_EXTENSIONS_CORRUPTED_EXTENSION 9223
#define IDS_EXTENSIONS_ENABLE_ERROR_COLLECTION 9224
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_DISABLED 9225
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_ENABLED 9226
#define IDS_EXTENSIONS_ENABLE_TOGGLE_TOOLTIP_ENABLED_WITH_SITE_ACCESS 9227
#define IDS_EXTENSIONS_ERROR_NO_ERRORS_CODE_MESSAGE 9228
#define IDS_EXTENSIONS_INSTALL_DROP_TARGET 9229
#define IDS_EXTENSIONS_INSTALL_WARNINGS 9230
#define IDS_EXTENSIONS_LOG_LEVEL_ERROR 9231
#define IDS_EXTENSIONS_LOG_LEVEL_INFO 9232
#define IDS_EXTENSIONS_LOG_LEVEL_WARN 9233
#define IDS_EXTENSIONS_PATH 9234
#define IDS_EXTENSIONS_PERMISSIONS_OFF 9235
#define IDS_EXTENSIONS_RELOAD_TERMINATED 9236
#define IDS_EXTENSIONS_REPAIR_CORRUPTED 9237
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_ICON_TOOLTIP 9238
#define IDS_EXTENSIONS_VIEW_IFRAME 9239
#define IDS_EXTENSIONS_VIEW_INACTIVE 9240
#define IDS_EXTENSIONS_VIEW_INCOGNITO 9241
#define IDS_EXTENSIONS_DEVELOPER_MODE 9242
#define IDS_EXTENSIONS_DISABLED_UNSUPPORTED_DEVELOPER_MODE 9243
#define IDS_EXTENSIONS_DISABLED_UNSUPPORTED_DEVELOPER_MODE_DETAILS 9244
#define IDS_EXTENSIONS_DISABLED_UNSUPPORTED_DEVELOPER_MODE_TOAST 9245
#define IDS_EXTENSIONS_DISABLED_UPDATE_REQUIRED_BY_POLICY 9246
#define IDS_EXTENSIONS_DISABLED_PUBLISHED_IN_STORE_REQUIRED_BY_POLICY 9247
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_ALLOW 9248
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_TITLE 9249
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_WARNING 9250
#define IDS_EXTENSIONS_MENU_BUTTON_LABEL 9251
#define IDS_EXTENSIONS_ERROR_PAGE_HEADING 9252
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_ALLOW_ALL_EXTENSIONS 9253
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_CUSTOMIZE_PER_EXTENSION 9254
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_RESTRICT_EXTENSIONS 9255
#define IDS_EXTENSIONS_ERROR_ANONYMOUS_FUNCTION 9256
#define IDS_EXTENSIONS_ERROR_CONTEXT 9257
#define IDS_EXTENSIONS_ERROR_CONTEXT_UNKNOWN 9258
#define IDS_EXTENSIONS_CLEAR_ACTIVITIES 9259
#define IDS_EXTENSIONS_ERROR_CLEAR_ALL 9260
#define IDS_EXTENSIONS_A11Y_CLEAR_ENTRY 9261
#define IDS_EXTENSIONS_ERROR_STACK_TRACE 9262
#define IDS_EXTENSIONS_ERROR_LINES_NOT_SHOWN 9263
#define IDS_EXTENSIONS_HOST_PERMISSIONS_DESCRIPTION 9264
#define IDS_EXTENSIONS_PERMISSIONS_LEARN_MORE_A11Y_LABEL 9265
#define IDS_EXTENSIONS_HOST_PERMISSIONS_EDIT 9266
#define IDS_EXTENSIONS_ITEM_ERRORS 9267
#define IDS_EXTENSIONS_ITEM_HOST_PERMISSIONS_HEADING 9268
#define IDS_EXTENSIONS_NEW_HOST_PERMISSIONS_HEADING 9269
#define IDS_EXTENSIONS_HOST_PERMISSIONS_SUB_HEADING 9270
#define IDS_EXTENSIONS_HOST_ACCESS_ON_CLICK 9271
#define IDS_EXTENSIONS_HOST_ACCESS_ASK_ON_EVERY_VISIT 9272
#define IDS_EXTENSIONS_HOST_ACCESS_ON_SPECIFIC_SITES 9273
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_SPECIFIC_SITES 9274
#define IDS_EXTENSIONS_HOST_ACCESS_ON_ALL_SITES 9275
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_ALL_SITES 9276
#define IDS_EXTENSIONS_ITEM_ALLOWED_HOSTS 9277
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_LINE 9278
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_MULTI_LINE 9279
#define IDS_EXTENSIONS_ACTIVITY_LOG_PAGE_HEADING 9280
#define IDS_EXTENSIONS_ACTIVITY_LOG_SEARCH_LABEL 9281
#define IDS_EXTENSIONS_ACTIVITY_LOG_TYPE_COLUMN 9282
#define IDS_EXTENSIONS_ACTIVITY_LOG_NAME_COLUMN 9283
#define IDS_EXTENSIONS_ACTIVITY_LOG_COUNT_COLUMN 9284
#define IDS_EXTENSIONS_ACTIVITY_LOG_TIME_COLUMN 9285
#define IDS_EXTENSIONS_ACTIVITY_LOG_HISTORY_TAB_HEADING 9286
#define IDS_EXTENSIONS_ACTIVITY_LOG_STREAM_TAB_HEADING 9287
#define IDS_EXTENSIONS_START_ACTIVITY_STREAM 9288
#define IDS_EXTENSIONS_STOP_ACTIVITY_STREAM 9289
#define IDS_EXTENSIONS_EMPTY_STREAM_STARTED 9290
#define IDS_EXTENSIONS_EMPTY_STREAM_STOPPED 9291
#define IDS_EXTENSIONS_ACTIVITY_ARGUMENTS_HEADING 9292
#define IDS_EXTENSIONS_WEB_REQUEST_INFO_HEADING 9293
#define IDS_EXTENSIONS_ACTIVITY_LOG_MORE_ACTIONS_LABEL 9294
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPAND_ALL 9295
#define IDS_EXTENSIONS_ACTIVITY_LOG_COLLAPSE_ALL 9296
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPORT_HISTORY 9297
#define IDS_EXTENSIONS_ITEM_ID 9298
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS 9299
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS_EXTRA 9300
#define IDS_EXTENSIONS_ITEM_NO_ACTIVE_VIEWS 9301
#define IDS_EXTENSIONS_ITEM_ALLOW_INCOGNITO 9302
#define IDS_EXTENSIONS_ITEM_DEPENDENCIES 9303
#define IDS_EXTENSIONS_DEPENDENT_ENTRY 9304
#define IDS_EXTENSIONS_ITEM_DESCRIPTION 9305
#define IDS_EXTENSIONS_ITEM_DETAILS 9306
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_LABEL 9307
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 9308
#define IDS_EXTENSIONS_EXTENSION_A11Y_ASSOCIATION 9309
#define IDS_EXTENSIONS_APP_ICON 9310
#define IDS_EXTENSIONS_EXTENSION_ICON 9311
#define IDS_EXTENSIONS_ITEM_ID_HEADING 9312
#define IDS_EXTENSIONS_EXTENSION_ENABLED 9313
#define IDS_EXTENSIONS_APP_ENABLED 9314
#define IDS_EXTENSIONS_ITEM_OFF 9315
#define IDS_EXTENSIONS_ITEM_ON 9316
#define IDS_EXTENSIONS_ITEM_EXTENSION_WEBSITE 9317
#define IDS_EXTENSIONS_ITEM_CHROME_WEB_STORE 9318
#define IDS_EXTENSIONS_ITEM_OPTIONS 9319
#define IDS_EXTENSIONS_ITEM_PERMISSIONS 9320
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_EMPTY 9321
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_AND_SITE_ACCESS_EMPTY 9322
#define IDS_EXTENSIONS_ITEM_PIN_TO_TOOLBAR 9323
#define IDS_EXTENSIONS_ITEM_REMOVE_EXTENSION 9324
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS 9325
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_ADD_HOST 9326
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_EMPTY 9327
#define IDS_EXTENSIONS_REMOVE_SITES_DIALOG_TITLE 9328
#define IDS_EXTENSIONS_ITEM_SOURCE 9329
#define IDS_EXTENSIONS_ITEM_SOURCE_INSTALLED_BY_DEFAULT 9330
#define IDS_EXTENSIONS_ITEM_SOURCE_POLICY 9331
#define IDS_EXTENSIONS_ITEM_SOURCE_SIDELOADED 9332
#define IDS_EXTENSIONS_ITEM_SOURCE_UNPACKED 9333
#define IDS_EXTENSIONS_ITEM_SOURCE_WEBSTORE 9334
#define IDS_EXTENSIONS_ITEM_VERSION 9335
#define IDS_EXTENSIONS_ITEM_RELOADED 9336
#define IDS_EXTENSIONS_ITEM_RELOADING 9337
#define IDS_EXTENSIONS_LOAD_ERROR_HEADING 9338
#define IDS_EXTENSIONS_LOAD_ERROR_ERROR_LABEL 9339
#define IDS_EXTENSIONS_LOAD_ERROR_FILE_LABEL 9340
#define IDS_EXTENSIONS_LOAD_ERROR_COULD_NOT_LOAD_MANIFEST 9341
#define IDS_EXTENSIONS_LOAD_ERROR_RETRY 9342
#define IDS_EXTENSIONS_LOADING_ACTIVITIES 9343
#define IDS_MISSING_OR_UNINSTALLED_EXTENSION 9344
#define IDS_EXTENSIONS_NO_ACTIVITIES 9345
#define IDS_EXTENSIONS_NO_INSTALLED_ITEMS 9346
#define IDS_EXTENSIONS_NO_DESCRIPTION 9347
#define IDS_EXTENSIONS_OPENS_IN_NEW_TAB 9348
#define IDS_EXTENSIONS_PACK_DIALOG_TITLE 9349
#define IDS_EXTENSIONS_PACK_DIALOG_WARNING_TITLE 9350
#define IDS_EXTENSIONS_PACK_DIALOG_ERROR_TITLE 9351
#define IDS_EXTENSIONS_PACK_DIALOG_PROCEED_ANYWAY 9352
#define IDS_EXTENSIONS_PACK_DIALOG_BROWSE_BUTTON 9353
#define IDS_EXTENSIONS_PACK_DIALOG_EXTENSION_ROOT_LABEL 9354
#define IDS_EXTENSIONS_PACK_DIALOG_KEY_FILE_LABEL 9355
#define IDS_EXTENSIONS_PACK_DIALOG_CONFIRM_BUTTON 9356
#define IDS_EXTENSIONS_TOOLBAR_TITLE 9357
#define IDS_EXTENSIONS_SEARCH 9358
#define IDS_EXTENSIONS_SITE_PERMISSIONS 9359
#define IDS_EXTENSIONS_SITE_PERMISSIONS_PAGE_TITLE 9360
#define IDS_EXTENSIONS_SITE_PERMISSIONS_VIEW_ALL_SITES 9361
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_PAGE_TITLE 9362
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_ONE_EXTENSION 9363
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_EXTENSION_COUNT 9364
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_ALL_SITES 9365
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_THIS_SITE 9366
#define IDS_EXTENSIONS_SITE_SETTINGS 9367
#define IDS_EXTENSIONS_PERMITTED_SITES 9368
#define IDS_EXTENSIONS_RESTRICTED_SITES 9369
#define IDS_EXTENSIONS_NO_SITES_ADDED 9370
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ADD_SITE_DIALOG_TITLE 9371
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_SITE_DIALOG_TITLE 9372
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_URL 9373
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS_DIALOG_TITLE 9374
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS 9375
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ASK_ON_EVERY_VISIT 9376
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_ERROR 9377
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_LABEL 9378
#define IDS_EXTENSIONS_SITE_PERMISSIONS_INCLUDES_SUBDOMAINS 9379
#define IDS_EXTENSIONS_EDIT_SHORTCUT_INPUT_LABEL 9380
#define IDS_EXTENSIONS_EDIT_SHORTCUT_BUTTON_LABEL 9381
#define IDS_EXTENSIONS_SET_SHORTCUT_IN_SYSTEM_SETTINGS 9382
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_LABEL 9383
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_GLOBAL 9384
#define IDS_EXTENSIONS_APPS_TITLE 9385
#define IDS_EXTENSIONS_REMOVE 9386
#define IDS_EXTENSIONS_MORE_OPTIONS 9387
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_TITLE 9388
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_ERROR 9389
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_LABEL 9390
#define IDS_EXTENSIONS_SIDEBAR_EXTENSIONS 9391
#define IDS_EXTENSIONS_SIDEBAR_DISCOVER_MORE 9392
#define IDS_EXTENSIONS_SIDEBAR_KEYBOARD_SHORTCUTS 9393
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED 9394
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED_DONE 9395
#define IDS_EXTENSIONS_TOOLBAR_PACK 9396
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW 9397
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW_TOOLTIP 9398
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_DONE 9399
#define IDS_EXTENSIONS_TOOLBAR_UPDATING_TOAST 9400
#define IDS_EXTENSIONS_SUBPAGE_BUTTON 9401
#define IDS_EXTENSIONS_SECTION_HEADER 9402
#define IDS_EXTENSIONS_SC_MALWARE 9403
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_OFF 9404
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_ON 9405
#define IDS_EXTENSIONS_SC_UNPUBLISHED_OFF 9406
#define IDS_EXTENSIONS_SC_UNPUBLISHED_ON 9407
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES_ON 9408
#define IDS_EXTENSIONS_SAFETY_CHECK_NO_PRIVACY_PRACTICES_OFF 9409
#define IDS_EXTENSIONS_SC_TITLE 9410
#define IDS_EXTENSIONS_SC_KEEP_EXT 9411
#define IDS_EXTENSIONS_SC_THREEDOT_DETAILS 9412
#define IDS_EXTENSIONS_SC_REMOVE_ALL 9413
#define IDS_EXTENSIONS_SC_ALL_DONE_FOR_NOW 9414
#define IDS_EXTENSIONS_SC_REMOVE_BUTTON_A11Y_LABEL 9415
#define IDS_EXTENSIONS_SC_OPTION_MENU_A11Y_LABEL 9416
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_TITLE 9417
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_WARNING_HEADER 9418
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_WARNING_SUBTITLE 9419
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISABLED_HEADER 9420
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_WARNING_HEADER 9421
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_WARNING_SUBTITLE 9422
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_DISABLED_HEADER 9423
#define IDS_EXTENSIONS_MV2_DEPRECATION_MESSAGE_REMOVE_BUTTON 9424
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_DISMISS_BUTTON 9425
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_FIND_ALTERNATIVE_BUTTON 9426
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_KEEP_FOR_NOW_BUTTON 9427
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_ACTION_MENU_BUTTON_LABEL 9428
#define IDS_EXTENSIONS_MV2_DEPRECATION_PANEL_FIND_ALTERNATIVE_BUTTON_ACC_LABEL 9429
#define IDS_EXTENSIONS_MV2_DEPRECATION_UNSUPPORTED_EXTENSION_OFF_TEXT 9430
#define IDS_EXTENSIONS_CANT_INSTALL_MV2_EXTENSION 9431
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_SUBTITLE 9443
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_TITLE 9444
#define IDS_NEARBY_CONFIRMATION_PAGE_TITLE 9445
#define IDS_QUICK_SHARE_V2_VISIBILITY_SECTION_TITLE 9446
#define IDS_QUICK_SHARE_V2_VISIBILITY_SECTION_SUBTITLE_ON_DISABLED 9447
#define IDS_QUICK_SHARE_V2_VISIBILITY_YOUR_DEVICES_SUBLABEL 9448
#define IDS_QUICK_SHARE_V2_VISIBILITY_CONTACTS_SUBLABEL 9449
#define IDS_QUICK_SHARE_V2_VISIBILITY_EVERYONE_LABEL 9450
#define IDS_QUICK_SHARE_V2_VISIBILITY_EVERYONE_SUBLABEL 9451
#define IDS_QUICK_SHARE_V2_VISIBILITY_ONLY_FOR_TEN_MINUTES_LABEL 9452
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOAD_FAILED 9453
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOADING 9454
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE 9455
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE_PH 9456
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_TITLE 9457
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE 9458
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE_PH 9459
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL 9460
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL_SELF_SHARE 9461
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_NONE 9462
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME 9463
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME_SELF_SHARE 9464
#define IDS_NEARBY_CONTACT_VISIBILITY_ZERO_STATE_TEXT 9465
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_YOUR_DEVICES 9466
#define IDS_NEARBY_DEVICE_NAME_EMPTY_ERROR 9467
#define IDS_NEARBY_DEVICE_NAME_TOO_LONG_ERROR 9468
#define IDS_NEARBY_DEVICE_NAME_INVALID_CHARACTERS_ERROR 9469
#define IDS_NEARBY_DISCOVERY_PAGE_INFO 9470
#define IDS_NEARBY_DISCOVERY_PAGE_SUBTITLE 9471
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE 9472
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE_PH 9473
#define IDS_NEARBY_DISCOVERY_PAGE_PLACEHOLDER 9474
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME 9475
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME_HELP 9476
#define IDS_NEARBY_ONBOARDING_PAGE_SUBTITLE 9477
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE 9478
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE_PH 9479
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY 9480
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY_HELP_ALL_CONTACTS 9481
#define IDS_NEARBY_VISIBILITY_PAGE_MANAGE_CONTACTS 9482
#define IDS_NEARBY_VISIBILITY_PAGE_SUBTITLE 9483
#define IDS_NEARBY_VISIBILITY_PAGE_TITLE 9484
#define IDS_NEARBY_SHARE_FEATURE_NAME 9485
#define IDS_NEARBY_SHARE_FEATURE_NAME_PH 9486
#define IDS_NEARBY_ACTIONS_ACCEPT 9487
#define IDS_NEARBY_ACTIONS_CANCEL 9488
#define IDS_NEARBY_ACTIONS_CLOSE 9489
#define IDS_NEARBY_ACTIONS_CONFIRM 9490
#define IDS_NEARBY_ACTIONS_DECLINE 9491
#define IDS_NEARBY_ACTIONS_NEXT 9492
#define IDS_NEARBY_ACTIONS_REJECT 9493
#define IDS_NEARBY_DEFAULT_DEVICE_NAME 9494
#define IDS_NEARBY_ERROR_CANCELLED 9495
#define IDS_NEARBY_ERROR_CANT_RECEIVE 9496
#define IDS_NEARBY_ERROR_CANT_SHARE 9497
#define IDS_NEARBY_ERROR_NO_RESPONSE 9498
#define IDS_NEARBY_ERROR_TRANSFER_IN_PROGRESS 9499
#define IDS_NEARBY_ERROR_NOT_ENOUGH_SPACE 9500
#define IDS_NEARBY_ERROR_REJECTED 9501
#define IDS_NEARBY_ERROR_SOMETHING_WRONG 9502
#define IDS_NEARBY_ERROR_TIME_OUT 9503
#define IDS_NEARBY_ERROR_TRY_AGAIN 9504
#define IDS_NEARBY_ERROR_UNSUPPORTED_FILE_TYPE 9505
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_APPS 9506
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_APPS 9507
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_IMAGES 9508
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_IMAGES 9509
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_UNKNOWN 9510
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 9511
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_VIDEOS 9512
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_VIDEOS 9513
#define IDS_NEARBY_SECURE_CONNECTION_ID 9514
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_ADDRESSES 9515
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_ADDRESSES 9516
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_LINKS 9517
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_LINKS 9518
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_PHONE_NUMBERS 9519
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_PHONE_NUMBERS 9520
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_UNKNOWN 9521
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 9522
#define IDS_NEARBY_CAPITALIZED_UNKNOWN_ATTACHMENTS 9523
#define IDS_NEARBY_NOT_CAPITALIZED_UNKNOWN_ATTACHMENTS 9524
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE 9525
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_MINUTES 9526
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_SECONDS 9527
#define IDS_NEARBY_HIGH_VISIBILITY_HELP_TEXT 9528
#define IDS_NEARBY_HIGH_VISIBILITY_TIMEOUT_TEXT 9529
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_ERROR 9530
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_DESCRIPTION 9531
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_ERROR 9532
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION 9533
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION_PH 9534
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_TITLE 9535
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_CONNECTION_ID 9536
#define IDS_NEARBY_PREVIEW_TITLE_MULTIPLE_FILE 9537
#define IDS_NEARBY_ACCOUNT_ROW_LABEL 9538
#define IDS_NEARBY_ACCOUNT_ROW_LABEL_PH 9539
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP 9540
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP_PH 9541
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_BOTTOM 9542
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS 9543
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS_DESCRIPTION 9544
#define IDS_NEARBY_VISIBILITY_CONTACTS_BUTTON 9545
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS 9546
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS_DESCRIPTION 9547
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES 9548
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES_DESCRIPTION 9549
#define IDS_NEARBY_VISIBILITY_ALL_CONTACTS_TOGGLE 9550
#define IDS_NEARBY_VISIBLITY_HIDDEN 9551
#define IDS_NEARBY_VISIBLITY_HIDDEN_DESCRIPTION 9552
#define IDS_NEARBY_VISIBLITY_UNKNOWN 9553
#define IDS_NEARBY_VISIBLITY_UNKNOWN_DESCRIPTION 9554
#define IDS_NEARBY_NOTIFICATION_ACTION_COPY_TO_CLIPBOARD 9555
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_FOLDER 9556
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_NETWORK_LIST 9557
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_URL 9558
#define IDS_NEARBY_NOTIFICATION_ACCEPT_ACTION 9559
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE 9560
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE_WIFI_CREDENTIALS 9561
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE 9562
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE_PH 9563
#define IDS_NEARBY_NOTIFICATION_DECLINE_ACTION 9564
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE 9565
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE_PH 9566
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_MESSAGE 9567
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_TITLE 9568
#define IDS_NEARBY_NOTIFICATION_SET_UP_ACTION 9569
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_ACTION 9570
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_TITLE 9571
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_MESSAGE 9572
#define IDS_NEARBY_NOTIFICATION_GO_TO_SETTINGS_ACTION 9573
#define IDS_NEARBY_NOTIFICATION_DISMISS_ACTION 9574
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE 9575
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE_WIFI_CREDENTIALS 9576
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE 9577
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE_WIFI_CREDENTIALS 9578
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE 9579
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE_WIFI_CREDENTIALS 9580
#define IDS_NEARBY_NOTIFICATION_SEND_FAILURE_TITLE 9581
#define IDS_NEARBY_NOTIFICATION_SEND_PROGRESS_TITLE 9582
#define IDS_NEARBY_NOTIFICATION_SEND_SUCCESS_TITLE 9583
#define IDS_NEARBY_NOTIFICATION_SOURCE 9584
#define IDS_NEARBY_NOTIFICATION_SOURCE_PH 9585
#define IDS_NEARBY_NOTIFICATION_SENDER_CANCELLED 9586
#define IDS_WHATS_NEW_TITLE 9587
#define IDS_PASSWORD_MANAGER_UI_TITLE 9588
#define IDS_PASSWORD_MANAGER_UI_DESCRIPTION 9589
#define IDS_PASSWORD_MANAGER_UI_SEARCH_PROMPT 9590
#define IDS_PASSWORD_MANAGER_UI_CHECKUP 9591
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS 9592
#define IDS_PASSWORD_MANAGER_UI_SETTINGS 9593
#define IDS_PASSWORD_MANAGER_UI_SAVE_PASSWORDS_TOGGLE_LABEL 9594
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_LABEL 9595
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_DESC 9596
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS_DESCRIPTION 9597
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_BUTTON 9598
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_TITLE 9599
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_DESCRIPTION 9600
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_TITLE 9601
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_DESCRIPTION 9602
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_TITLE 9603
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_DESCRIPTION 9604
#define IDS_PASSWORD_MANAGER_UI_SHARE 9605
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_DESCRIPTION 9606
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_TITLE 9607
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_LOADING_TITLE 9608
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_SUCCESS_TITLE 9609
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CANCELED_TITLE 9610
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_FAMILY_MEMBER 9611
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NO_OTHER_FAMILY_MEMBERS 9612
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_FAMILY_PICKER_DESCRIPTION 9613
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_DESCRIPTION_SINGLE 9614
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_DESCRIPTION_MULTIPLE 9615
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_FOOTER_WEBSITE 9616
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CONFIRMATION_FOOTER_ANDROID_APP 9617
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_VIEW_FAMILY 9618
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_MEMBER_UNAVAILABLE 9619
#define IDS_PASSWORD_MANAGER_UI_SHARING_IS_MANAGED_BY_ADMIN 9620
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_AVAILABLE 9621
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_TRY_AGAIN 9622
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_GOT_IT 9623
#define IDS_PASSWORD_MANAGER_UI_SHARE_DIALOG_TITLE 9624
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BANNER_TITLE 9625
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_ACCOUNT_STORE_USERS 9626
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SYNCING_USERS 9627
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SIGNEDOUT_USERS 9628
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_DEVICE 9629
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_ACCOUNT 9630
#define IDS_PASSWORD_MANAGER_UI_IMPORT_STORE_PICKER_ACCESSIBLE_NAME 9631
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SELECT_FILE_DESCRIPTION 9632
#define IDS_PASSWORD_MANAGER_UI_SELECT_FILE 9633
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_PASSWORD 9634
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_URL 9635
#define IDS_PASSWORD_MANAGER_UI_IMPORT_INVALID_URL 9636
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_URL 9637
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_USERNAME 9638
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_PASSWORD 9639
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_NOTE 9640
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_ACCOUNT 9641
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_DEVICE 9642
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_UNKNOWN 9643
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_BAD_FORMAT 9644
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FILE_SIZE_EXCEEDED 9645
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_LIMIT_EXCEEDED 9646
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_TITLE 9647
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TITLE 9648
#define IDS_PASSWORD_MANAGER_UI_IMPORT_COMPLETE_TITLE 9649
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DELETE_FILE_OPTION 9650
#define IDS_PASSWORD_MANAGER_UI_IMPORT_VIEW_PASSWORDS 9651
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ALREADY_ACTIVE 9652
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TIP 9653
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FAILURES_SUMMARY 9654
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BAD_ROWS_FORMAT 9655
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_ACCOUNT 9656
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_DEVICE 9657
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_TITLE 9658
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_DESCRIPTION 9659
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CANCEL 9660
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SKIP 9661
#define IDS_PASSWORD_MANAGER_UI_IMPORT_REPLACE 9662
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TITLE 9663
#define IDS_PASSWORD_MANAGER_UI_DOWNLOAD_FILE 9664
#define IDS_PASSWORD_MANAGER_UI_EXPORT_BANNER_DESCRIPTION 9665
#define IDS_PASSWORD_MANAGER_UI_EXPORT_SUCCESSFUL 9666
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TRY_AGAIN 9667
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TITLE 9668
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIPS 9669
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ENOUGH_SPACE 9670
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ANOTHER_FOLDER 9671
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_TITLE 9672
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RESULT 9673
#define IDS_PASSWORD_MANAGER_UI_JUST_NOW 9674
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_COUNT 9675
#define IDS_PASSWORD_MANAGER_UI_NO_COMPROMISED_PASSWORDS 9676
#define IDS_PASSWORD_MANAGER_UI_HAS_COMPROMISED_PASSWORDS 9677
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_COUNT 9678
#define IDS_PASSWORD_MANAGER_UI_NO_REUSED_PASSWORDS 9679
#define IDS_PASSWORD_MANAGER_UI_HAS_REUSED_PASSWORDS 9680
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_COUNT 9681
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_GREEN_STATE_A11Y 9682
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_YELLOW_STATE_A11Y 9683
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RED_STATE_A11Y 9684
#define IDS_PASSWORD_MANAGER_UI_NO_WEAK_PASSWORDS 9685
#define IDS_PASSWORD_MANAGER_UI_HAS_WEAK_PASSWORDS 9686
#define IDS_PASSWORD_MANAGER_UI_CHECK_PASSWORDS_AFTER_ERROR 9687
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_TITLE 9688
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_DESCRIPTION 9689
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_ACCOUNTS 9690
#define IDS_PASSWORD_MANAGER_UI_USERNAME_LABEL 9691
#define IDS_PASSWORD_MANAGER_UI_SITES_LABEL 9692
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LABEL 9693
#define IDS_PASSWORD_MANAGER_UI_NOTE_LABEL 9694
#define IDS_PASSWORD_MANAGER_UI_NO_NOTE_ADDED 9695
#define IDS_PASSWORD_MANAGER_UI_COPY_PASSWORD 9696
#define IDS_PASSWORD_MANAGER_UI_COPY_USERNAME 9697
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD 9698
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD 9699
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD_A11Y 9700
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD_A11Y 9701
#define IDS_PASSWORD_MANAGER_UI_FEDERATION_LABEL 9702
#define IDS_PASSWORD_MANAGER_UI_USERNAME_COPIED_TO_CLIPBOARD 9703
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_COPIED_TO_CLIPBOARD 9704
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD 9705
#define IDS_PASSWORD_MANAGER_UI_WEBSITE_LABEL 9706
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_FOOTNOTE 9707
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LEAKED 9708
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED 9709
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED_AND_LEAKED 9710
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON 9711
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON_ARIA_DESCRIPTION 9712
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS 9713
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS_ARIA_DESCRIPTION 9714
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_DESCRIPTION 9715
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_DESCRIPTION 9716
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_DESCRIPTION 9717
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_SIGNED_OUT 9718
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OFFLINE 9719
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_COMPROMISED_SECTION 9720
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_NO_PASSWORDS 9721
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_QUOTA_LIMIT 9722
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OTHER_ERROR 9723
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RUNNING_LABEL 9724
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROGRESS 9725
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_CANCELED 9726
#define IDS_PASSWORD_MANAGER_UI_MUTED_COMPROMISED_PASSWORDS 9727
#define IDS_PASSWORD_MANAGER_UI_MUTE_ISSUE 9728
#define IDS_PASSWORD_MANAGER_UI_UNMUTE_ISSUE 9729
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_CREDENTIALS_WITH_REUSED_PASSWORD 9730
#define IDS_PASSWORD_MANAGER_UI_HELP 9731
#define IDS_PASSWORD_MANAGER_UI_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_LABEL_WIN 9734
#define IDS_PASSWORD_MANAGER_UI_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_SUBLABEL_WIN 9735
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSWORD 9738
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_EDIT_FOOTNOTE 9739
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DELETED 9740
#define IDS_PASSWORD_MANAGER_UI_UNDO 9741
#define IDS_PASSWORD_MANAGER_UI_SEARCH_RESULT 9742
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_IN_APP 9743
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_MANAGER_PIN 9744
#define IDS_PASSWORD_MANAGER_UI_ALREADY_CHANGED_PASSWORD 9745
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_DESCRIPTION 9746
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_TITLE 9747
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_TITLE 9748
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_DESCRIPTION 9749
#define IDS_PASSWORD_MANAGER_UI_SHOW_MORE 9750
#define IDS_PASSWORD_MANAGER_UI_NOT_VALID_WEB_ADDRESS 9751
#define IDS_PASSWORD_MANAGER_UI_MISSING_TLD 9752
#define IDS_PASSWORD_MANAGER_UI_USERNAME_ALREADY_USED 9753
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT 9754
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT_WARNING 9755
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT 9756
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT_DESCRIPTION 9757
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD 9758
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD_ARIA_DESCRIPTION 9759
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TO_ACCOUNT 9760
#define IDS_PASSWORD_MANAGER_UI_OPENS_IN_NEW_TAB 9761
#define IDS_PASSWORD_MANAGER_UI_VIEW_PASSWORD_ARIA_DESCRIPTION 9762
#define IDS_PASSWORD_MANAGER_UI_RUN_CHECKUP_ARIA_DESCRIPTION 9763
#define IDS_PASSWORD_MANAGER_UI_REMOVE_BLOCKED_SITE_ARIA_DESCRIPTION 9764
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_ACCOUNT_STORE_USERS 9765
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SYNCING_USERS 9766
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SIGNEDOUT_USERS 9767
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_TITLE 9768
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_DESCRIPTION 9769
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_ACTION 9770
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_TITLE 9771
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_DESCRIPTION 9772
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_TITLE 9773
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_DESCRIPTION 9774
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_TITLE 9775
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_DESCRIPTION 9776
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_TOGGLE_SUB_LABEL 9777
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_WITH_PASSKEYS_TOGGLE_LABEL 9778
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_TITLE 9779
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_BODY 9780
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_ACCOUNT_CHECKBOX_LABEL 9781
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_DEVICE_CHECKBOX_LABEL 9782
#define IDS_PASSWORD_MANAGER_UI_APPS_LABEL 9783
#define IDS_PASSWORD_MANAGER_UI_SITES_AND_APPS_LABEL 9784
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_CHECKUP_ARIA_DESCRIPTION 9785
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_PASSWORDS_ARIA_DESCRIPTION 9786
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TITLE 9787
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_DESCRIPTION 9788
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_BUTTON 9789
#define IDS_PASSWORD_MANAGER_UI_MANAGE_PASSKEYS_LABEL 9791
#define IDS_PASSWORD_MANAGER_UI_NO_PASSWORDS_FOUND 9792
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSKEY 9793
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_LABEL 9794
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_PLACEHOLDER 9795
#define IDS_PASSWORD_MANAGER_UI_USERNAME_PLACEHOLDER 9796
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_TITLE 9797
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_DESCRIPTION 9798
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_MANAGEMENT_INFO_LABEL 9799
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_TITLE 9800
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_DESCRIPTION 9801
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_BUTTON 9802
#define IDS_PASSKEYS_MANAGER_UI_UNENROLL_TOAST_MESSAGE 9803
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_TITLE 9804
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DESCRIPTION 9805
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DELETE_ALL 9806
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRM 9807
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_SUCCESS_TOAST 9808
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRMATION_TITLE 9809
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRMATION_TITLE_LOCAL 9810
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_CONFIRMATION_DESCIPTION 9811
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DOMAINS_DISPLAY_ONE 9812
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DOMAINS_DISPLAY_TWO 9813
#define IDS_PASSWORD_MANAGER_UI_FULL_RESET_DOMAINS_DISPLAY_TWO_AND_X_MORE 9814
#define IDS_PASSWORD_MANAGER_PASSWORDS_COUNTER 9815
#define IDS_PASSWORD_MANAGER_PASSKEYS_COUNTER 9816
#define IDS_PASSWORD_MANAGER_UI_COPY_DISPLAY_NAME_LABEL 9817
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_COPIED_TO_CLIPBOARD 9818
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DELETED 9819
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LIST_ARIA_LABEL 9820
#define IDS_PASSWORD_MANAGER_UI_DEVICE_ONLY_PASSWORDS_ICON_TOOLTIP 9821
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_ARIA_LABEL 9822
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_EDIT_BUTTON_ARIA_LABEL 9823
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_EDIT_BUTTON_NO_USERNAME_ARIA_LABEL 9824
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_DELETE_BUTTON_ARIA_LABEL 9825
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DETAILS_CARD_DELETE_BUTTON_NO_USERNAME_ARIA_LABEL 9826
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_NO_USERNAME_ARIA_LABEL 9827
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_ARIA_LABEL 9828
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_EDIT_BUTTON_ARIA_LABEL 9829
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_EDIT_BUTTON_NO_USERNAME_ARIA_LABEL 9830
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_DELETE_BUTTON_ARIA_LABEL 9831
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DETAILS_CARD_DELETE_BUTTON_NO_USERNAME_ARIA_LABEL 9832
#define IDS_PASSWORD_MANAGER_UI_FEDERATED_CREDENTIAL_ARIA_LABEL 9833
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_TO_ACCOUNT 9834
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_TITLE 9835
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_DESCRIPTION 9836
#define IDS_PASSWORD_MANAGER_UI_MOVE_SINGLE_PASSWORD_ACTION_BUTTON 9837
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_IN_SETTINGS_SUB_LABEL 9838
#define IDS_PASSWORD_MANAGER_UI_NO_USERNAME 9844
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_MOVED_TOAST_MESSAGE 9845
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_TITLE 9846
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_DESCRIPTION 9847
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_PROMO_CARD_ACTION_BUTTON 9848
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_DESCRIPTION 9849
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_TITLE 9850
#define IDS_PASSWORD_MANAGER_SAVE_IN_ACCOUNT_BUBBLE_SAVE_BUTTON 9851
#define IDS_PASSWORD_MANAGER_MANAGEMENT_BUBBLE_LIST_ITEM_DEVICE_ONLY_ACCESSIBLE_TEXT 9852
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LIST_ITEM_ARIA_LABEL 9853
#define IDS_PASSWORD_MANAGER_UI_PROMO_CARD_ARIA_LABEL 9854
#define IDS_PASSWORD_MANAGER_UI_CLOSE_PROMO_CARD_BUTTON_ARIA_LABEL 9855
#define IDS_PASSWORD_MANAGER_PIN_CHANGED 9856
#define IDS_PASSWORD_MANAGER_UI_CONFIRM 9857
#define IDS_PASSWORD_MANAGER_UI_DISCONNECT_CLOUD_AUTHENTICATOR_DIALOG_TITLE 9858
#define IDS_PASSWORD_MANAGER_UI_DISCONNECT_CLOUD_AUTHENTICATOR_DIALOG_DESCRIPTION 9859
#define IDS_PASSWORD_MANAGER_UI_SIGN_IN_CHECK_TITLE 9860
#define IDS_PASSWORD_MANAGER_UI_SIGN_IN_CHECK_DETAILS 9861
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_CANCEL 9862
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_INFO_BUBBLE_TITLE 9863
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_INFO_BUBBLE_DETAILS 9864
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_CONTINUE 9865
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_PRIVACY_NOTICE_TITLE 9866
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_PRIVACY_NOTICE_SUBTITLE 9867
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_PRIVACY_NOTICE_ITEM_EXPERIMENTAL 9868
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_PRIVACY_NOTICE_ITEM_HUMAN_REVIEW 9869
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_PRIVACY_NOTICE_ITEM_ENCRYPTED 9870
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGED_TITLE 9871
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FAILED_TITLE 9872
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FAILED_BODY 9873
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FAILED_ACTION 9874
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_FOOTER 9875
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_OMNIBOX_SIGN_IN_CHECK 9876
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_OMNIBOX_CHANGING_PASSWORD 9877
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_RETRY_TITLE 9878
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_RETRY_BODY 9879
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_RETRY_ACTION 9880
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_CHANGE_PASSWORD 9881
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_BUBBLE_TITLE 9882
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_LEAK_BUBBLE_DETAILS 9883
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_SETTINGS_LINK 9884
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_CHANGE_ICON_TOOLTIP 9885
#define IDS_UTILITY_PROCESS_PRINTING_SERVICE_NAME 9886
#define IDS_UTILITY_PROCESS_PRINT_BACKEND_SERVICE_NAME 9887
#define IDS_PRINT_INVALID_PRINTER_SETTINGS 9888
#define IDS_PRINT_PREVIEW_TITLE 9889
#define IDS_PRINT_PREVIEW_DESCRIPTION 9890
#define IDS_PRINT_PREVIEW_LOADING 9891
#define IDS_PRINT_PREVIEW_FAILED 9892
#define IDS_PRINT_PREVIEW_INVALID_PRINTER_SETTINGS 9893
#define IDS_PRINT_PREVIEW_PRINT_BUTTON 9894
#define IDS_PRINT_PREVIEW_SAVE_BUTTON 9895
#define IDS_PRINT_PREVIEW_PRINTING 9896
#define IDS_PRINT_PREVIEW_SAVING 9897
#define IDS_PRINT_PREVIEW_OPTION_ALL_PAGES 9898
#define IDS_PRINT_PREVIEW_OPTION_ODD_PAGES 9899
#define IDS_PRINT_PREVIEW_OPTION_EVEN_PAGES 9900
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_PAGES 9901
#define IDS_PRINT_PREVIEW_DESTINATION_LABEL 9902
#define IDS_PRINT_PREVIEW_OPTION_BW 9903
#define IDS_PRINT_PREVIEW_OPTION_COLLATE 9904
#define IDS_PRINT_PREVIEW_OPTION_COLOR 9905
#define IDS_PRINT_PREVIEW_OPTION_LANDSCAPE 9906
#define IDS_PRINT_PREVIEW_OPTION_PORTRAIT 9907
#define IDS_PRINT_PREVIEW_OPTION_TWO_SIDED 9908
#define IDS_PRINT_PREVIEW_PRINT_ON_BOTH_SIDES_LABEL 9909
#define IDS_PRINT_PREVIEW_OPTION_LONG_EDGE 9910
#define IDS_PRINT_PREVIEW_OPTION_SHORT_EDGE 9911
#define IDS_PRINT_PREVIEW_BORDERLESS_LABEL 9912
#define IDS_PRINT_PREVIEW_PAGES_LABEL 9913
#define IDS_PRINT_PREVIEW_LAYOUT_LABEL 9914
#define IDS_PRINT_PREVIEW_COPIES_LABEL 9915
#define IDS_PRINT_PREVIEW_SCALING_LABEL 9916
#define IDS_PRINT_PREVIEW_OPTION_DEFAULT_SCALING 9917
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_SCALING 9918
#define IDS_PRINT_PREVIEW_PAGES_PER_SHEET_LABEL 9919
#define IDS_PRINT_PREVIEW_EXAMPLE_PAGE_RANGE_TEXT 9920
#define IDS_PRINT_PREVIEW_PRINT_TO_PDF 9921
#define IDS_PRINT_PREVIEW_SHEET_SUMMARY_LABEL 9922
#define IDS_PRINT_PREVIEW_PAGE_SUMMARY_LABEL 9923
#define IDS_PRINT_PREVIEW_PAGE_RANGE_SYNTAX_INSTRUCTION 9924
#define IDS_PRINT_PREVIEW_PAGE_RANGE_LIMIT_INSTRUCTION_WITH_VALUE 9925
#define IDS_PRINT_PREVIEW_COPIES_INSTRUCTION 9926
#define IDS_PRINT_PREVIEW_SCALING_INSTRUCTION 9927
#define IDS_PRINT_PREVIEW_PRINT_PAGES_LABEL 9928
#define IDS_PRINT_PREVIEW_OPTIONS_LABEL 9929
#define IDS_PRINT_PREVIEW_OPTION_HEADER_FOOTER 9930
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAGE 9931
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAPER 9932
#define IDS_PRINT_PREVIEW_OPTION_BACKGROUND_COLORS_AND_IMAGES 9933
#define IDS_PRINT_PREVIEW_OPTION_SELECTION_ONLY 9934
#define IDS_PRINT_PREVIEW_OPTION_RASTERIZE 9935
#define IDS_PRINT_PREVIEW_MARGINS_LABEL 9936
#define IDS_PRINT_PREVIEW_DEFAULT_MARGINS 9937
#define IDS_PRINT_PREVIEW_NO_MARGINS 9938
#define IDS_PRINT_PREVIEW_CUSTOM_MARGINS 9939
#define IDS_PRINT_PREVIEW_MINIMUM_MARGINS 9940
#define IDS_PRINT_PREVIEW_TOP_MARGIN_LABEL 9941
#define IDS_PRINT_PREVIEW_BOTTOM_MARGIN_LABEL 9942
#define IDS_PRINT_PREVIEW_LEFT_MARGIN_LABEL 9943
#define IDS_PRINT_PREVIEW_RIGHT_MARGIN_LABEL 9944
#define IDS_PRINT_PREVIEW_MEDIA_SIZE_LABEL 9945
#define IDS_PRINT_PREVIEW_MEDIA_TYPE_LABEL 9946
#define IDS_PRINT_PREVIEW_DPI_LABEL 9947
#define IDS_PRINT_PREVIEW_NON_ISOTROPIC_DPI_ITEM_LABEL 9948
#define IDS_PRINT_PREVIEW_DPI_ITEM_LABEL 9949
#define IDS_PRINT_PREVIEW_DESTINATION_SEARCH_TITLE 9950
#define IDS_PRINT_PREVIEW_SEARCH_BOX_PLACEHOLDER 9951
#define IDS_PRINT_PREVIEW_NO_DESTINATIONS_MESSAGE 9952
#define IDS_PRINT_PREVIEW_PRINT_DESTINATIONS_TITLE 9953
#define IDS_PRINT_PREVIEW_MANAGE 9954
#define IDS_PRINT_PREVIEW_SEE_MORE 9955
#define IDS_PRINT_PREVIEW_SEE_MORE_DESTINATIONS_LABEL 9956
#define IDS_PRINT_PREVIEW_EXTENSION_DESTINATION_ICON_TOOLTIP 9957
#define IDS_MORE_OPTIONS_LABEL 9958
#define IDS_PRINT_PREVIEW_COULD_NOT_PRINT 9959
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_SEARCH_BOX_PLACEHOLDER 9960
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_TITLE 9961
#define IDS_PRINT_PREVIEW_NO_ADVANCED_SETTINGS_MATCH_SEARCH_HINT 9962
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_CONFIRM 9963
#define IDS_PRINT_PREVIEW_NEW_SHOW_ADVANCED_OPTIONS 9964
#define IDS_PRINT_PREVIEW_BUTTON_SELECT 9965
#define IDS_PRINT_PREVIEW_BUTTON_GO_BACK 9966
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_DIALOG_TITLE 9967
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_PERMISSION_MESSAGE 9968
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_ERROR_MESSAGE 9969
#define IDS_PRINT_PREVIEW_MANAGED_SETTINGS_TEXT 9970
#define IDS_PRINT_PREVIEW_SYSTEM_DIALOG_OPTION 9999
#define IDS_DEFAULT_PRINT_DOCUMENT_TITLE 10002
#define IDS_PRINT_SPOOL_FAILED_TITLE_TEXT 10003
#define IDS_PRINT_SPOOL_FAILED_ERROR_TEXT 10004
#define IDS_VR_SHELL_SITE_IS_TRACKING_LOCATION 10005
#define IDS_VR_SHELL_SITE_IS_USING_MICROPHONE 10006
#define IDS_VR_SHELL_SITE_IS_USING_CAMERA 10007
#define IDS_VR_SHELL_SITE_IS_SHARING_SCREEN 10008
#define IDS_VR_SHELL_BG_IS_USING_MICROPHONE 10009
#define IDS_VR_SHELL_BG_IS_USING_CAMERA 10010
#define IDS_VR_SHELL_BG_IS_SHARING_SCREEN 10011
#define IDS_VR_SHELL_SITE_CAN_TRACK_LOCATION 10012
#define IDS_VR_SHELL_SITE_CAN_USE_MICROPHONE 10013
#define IDS_VR_SHELL_SITE_CAN_USE_CAMERA 10014
#define IDS_VR_SHELL_SITE_CAN_SHARE_SCREEN 10015
#define IDS_VR_SHELL_SITE_IS_USING_BLUETOOTH 10016
#define IDS_VR_SHELL_SITE_CAN_USE_BLUETOOTH 10018
#define IDS_DESKTOP_PROMPT_DOFF_HEADSET 10019
#define IDS_VR_DESKTOP_GENERIC_PERMISSION_PROMPT 10020
#define IDS_VR_SHELL_SITE_IS_USING_USB 10021
#define IDS_VR_SHELL_SITE_IS_USING_MIDI 10022
#define IDS_VR_SHELL_SITE_CAN_USE_MIDI 10023
#define IDS_VR_WEB_VR_TIMEOUT_MESSAGE 10024
#define IDS_WILDCARD 10025
#define IDS_BACKGROUND_APP_INSTALLED_BALLOON_TITLE 10026
#define IDS_BACKGROUND_APP_INSTALLED_BALLOON_BODY 10027
#define IDS_BACKGROUND_CRASHED_APP_BALLOON_MESSAGE 10028
#define IDS_BACKGROUND_CRASHED_EXTENSION_BALLOON_MESSAGE 10029
#define IDS_BACKGROUND_APP_NOT_INSTALLED 10030
#define IDS_PERMISSIONS_REQUESTED_SCREENREADER_ANNOUNCEMENT 10031
#define IDS_PERMISSIONS_EXPIRED_SCREENREADER_ANNOUNCEMENT 10032
#define IDS_PERMISSIONS_BUBBLE_PROMPT 10033
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_ONE_PERM 10034
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS 10035
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS_MORE 10036
#define IDS_PERMISSIONS_BUBBLE_PROMPT_THIS_FILE 10037
#define IDS_PERMISSION_CUSTOMIZE 10038
#define IDS_ALTERNATE_NAV_URL_VIEW_LABEL 10039
#define IDS_DOWNLOAD_HISTORY_TITLE 10040
#define IDS_TAB_LOADING_TITLE 696
#define IDS_HOVER_CARD_FILE_URL_SOURCE 10041
#define IDS_HOVER_CARD_BLOB_URL_SOURCE 10042
#define IDS_HOVER_CARD_CRASHED_TITLE 10043
#define IDS_HISTORY_SEARCH_PROMPT 10044
#define IDS_HISTORY_DELETE 10045
#define IDS_HISTORY_ITEMS_SELECTED 10046
#define IDS_HISTORY_ITEMS_UNSELECTED 10047
#define IDS_HISTORY_HISTORY_MENU_DESCRIPTION 10048
#define IDS_HISTORY_HISTORY_MENU_ITEM 10049
#define IDS_HISTORY_NO_SYNCED_RESULTS 10050
#define IDS_HISTORY_OPEN_TABS_MENU_ITEM 10051
#define IDS_HISTORY_TURN_ON_SYNC_BUTTON 10052
#define IDS_HISTORY_TURN_ON_SYNC_PROMO 10053
#define IDS_HISTORY_TURN_ON_SYNC_PROMO_DESC 10054
#define IDS_EDIT 10055
#define IDS_CLEAR_SEARCH 10056
#define IDS_CONFIRM 10057
#define IDS_DISABLE 10058
#define IDS_SEARCH_CLEARED 10059
#define IDS_SEARCH_RESULTS 10060
#define IDS_SEARCH_RESULTS_SINGULAR 10061
#define IDS_SEARCH_RESULTS_PLURAL 10062
#define IDS_SEARCH_RESULT_BUBBLE_TEXT 10063
#define IDS_SEARCH_RESULTS_BUBBLE_TEXT 10064
#define IDS_SEARCH_NO_RESULTS 10065
#define IDS_SHOW_BUBBLE_INACTIVE_DESCRIPTION 10066
#define IDS_FOCUS_HELP_BUBBLE_DESCRIPTION 10067
#define IDS_FOCUS_HELP_BUBBLE_TOGGLE_DESCRIPTION 10068
#define IDS_FOCUS_HELP_BUBBLE_TUTORIAL_DESCRIPTION 10069
#define IDS_CONTENT_CONTEXT_INSPECTELEMENT 10070
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_DIALOG_TITLE 10071
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_ENABLE 10072
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_DISABLE 10073
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_ENABLE 10074
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_DISABLE 10075
#define IDS_CONTENT_CONTEXT_BACK 10076
#define IDS_CONTENT_CONTEXT_FORWARD 10077
#define IDS_CONTENT_CONTEXT_SAVEPAGEAS 10078
#define IDS_CONTENT_CONTEXT_PRINT 10079
#define IDS_CONTENT_CONTEXT_VIEWPAGESOURCE 10080
#define IDS_CONTENT_CONTEXT_OPENLINKWITH 10081
#define IDS_CONTENT_CONTEXT_OPENLINKWITH_CONFIGURE 10082
#define IDS_CONTENT_CONTEXT_INSPECTBACKGROUNDPAGE 10083
#define IDS_CONTENT_CONTEXT_READING_MODE 10084
#define IDS_CONTENT_CONTEXT_CLOSE_GLIC 10085
#define IDS_CONTENT_CONTEXT_RELOAD 10086
#define IDS_CONTENT_CONTEXT_RESTART_APP 10087
#define IDS_CONTENT_CONTEXT_RELOAD_PACKAGED_APP 10088
#define IDS_CONTENT_CONTEXT_TRANSLATE 10089
#define IDS_CONTENT_CONTEXT_EXIT_FULLSCREEN 10090
#define IDS_CONTENT_CONTEXT_RELOADFRAME 10091
#define IDS_CONTENT_CONTEXT_VIEWFRAMESOURCE 10092
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB 10093
#define IDS_CONTENT_CONTEXT_OPENLINKNEWWINDOW 10094
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD 10095
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILES 10096
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILE 10097
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP 10098
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP_SAMEAPP 10099
#define IDS_CONTENT_CONTEXT_OPENLINKWEBAPP_NEWTAB 10100
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW 10101
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_ALTCLICK 10102
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_ALTHOVER 10103
#define IDS_CONTENT_CONTEXT_OPENLINKPREVIEW_TRIGGER_LONGPRESS 10104
#define IDS_CONTENT_CONTEXT_SAVELINKAS 10105
#define IDS_CONTENT_CONTEXT_COPYLINKLOCATION 10106
#define IDS_CONTENT_CONTEXT_COPYEMAILADDRESS 10107
#define IDS_CONTENT_CONTEXT_COPYLINKTEXT 10108
#define IDS_CONTENT_CONTEXT_COPYLINKTOTEXT 10109
#define IDS_CONTENT_CONTEXT_ADD_A_NOTE 10110
#define IDS_CONTENT_CONTEXT_REMOVELINKTOTEXT 10111
#define IDS_CONTENT_CONTEXT_RESHARELINKTOTEXT 10112
#define IDS_CONTENT_CONTEXT_SAVEIMAGEAS 10113
#define IDS_CONTENT_CONTEXT_COPYIMAGELOCATION 10114
#define IDS_CONTENT_CONTEXT_COPYIMAGE 10115
#define IDS_CONTENT_CONTEXT_OPENIMAGENEWTAB 10116
#define IDS_CONTENT_CONTEXT_OPEN_ORIGINAL_IMAGE_NEW_TAB 10117
#define IDS_CONTENT_CONTEXT_LOAD_IMAGE 10118
#define IDS_CONTENT_CONTEXT_LOOP 10119
#define IDS_CONTENT_CONTEXT_CONTROLS 10120
#define IDS_CONTENT_CONTEXT_ROTATECW 10121
#define IDS_CONTENT_CONTEXT_ROTATECCW 10122
#define IDS_CONTENT_CONTEXT_SAVEVIDEOFRAMEAS 10123
#define IDS_CONTENT_CONTEXT_SAVEVIDEOAS 10124
#define IDS_CONTENT_CONTEXT_COPYVIDEOLOCATION 10125
#define IDS_CONTENT_CONTEXT_COPYVIDEOFRAME 10126
#define IDS_CONTENT_CONTEXT_SEARCHFORVIDEOFRAME 10127
#define IDS_CONTENT_CONTEXT_OPENVIDEONEWTAB 10128
#define IDS_CONTENT_CONTEXT_SAVEAUDIOAS 10129
#define IDS_CONTENT_CONTEXT_COPYAUDIOLOCATION 10130
#define IDS_CONTENT_CONTEXT_OPENAUDIONEWTAB 10131
#define IDS_CONTENT_CONTEXT_PICTUREINPICTURE 10132
#define IDS_CONTENT_CONTEXT_UNDO 10133
#define IDS_CONTENT_CONTEXT_REDO 10134
#define IDS_CONTENT_CONTEXT_CUT 10135
#define IDS_CONTENT_CONTEXT_COPY 10136
#define IDS_CONTENT_CONTEXT_PASTE 10137
#define IDS_CONTENT_CONTEXT_PASTE_AND_MATCH_STYLE 10138
#define IDS_CONTENT_CONTEXT_ADD_TO_DICTIONARY 10139
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_MENU_OPTION 10140
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND 10141
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND_ONCE 10142
#define IDS_CONTENT_CONTEXT_RUN_LAYOUT_EXTRACTION 10143
#define IDS_CONTENT_CONTEXT_SPELLING_ASK_GOOGLE 10144
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TITLE 10145
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_ENABLE 10146
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_DISABLE 10147
#define IDS_CONTENT_CONTEXT_SPELLING_CHECKING 10148
#define IDS_CONTENT_CONTEXT_SPELLING_NO_SUGGESTIONS_FROM_GOOGLE 10149
#define IDS_CONTENT_CONTEXT_SELECTALL 10150
#define IDS_CONTENT_CONTEXT_PARTIAL_TRANSLATE 10151
#define IDS_CONTENT_CONTEXT_SEARCHWEBFOR 10152
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORNEWTAB 10153
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORIMAGE 10154
#define IDS_CONTENT_CONTEXT_SEARCHLENSFORIMAGE 10155
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT1 10156
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH 10157
#define IDS_CONTENT_CONTEXT_GOTOURL 10158
#define IDS_CONTENT_CONTEXT_GENERATEPASSWORD 10159
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_USE_PASSKEY_FROM_ANOTHER_DEVICE 10160
#define IDS_CONTENT_CONTEXT_MORE_APPS 10161
#define IDS_CONTENT_CONTEXT_OPEN_WITH_APP 10162
#define IDS_CONTENT_CONTEXT_AUTOFILL_FEEDBACK 10163
#define IDS_CONTENT_CONTEXT_AUTOFILL_PREDICTION_IMPROVEMENTS 10164
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_SELECT_PASSWORD 10165
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_IMPORT_PASSWORDS 10166
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_PASSWORDS_SUGGEST_PASSWORD 10167
#define IDS_SHARE_MENU_TITLE 10169
#define IDS_CONTENT_CONTEXT_PLUGIN_RUN 10170
#define IDS_CONTENT_CONTEXT_PLUGIN_HIDE 10171
#define IDS_CONTENT_CONTEXT_ENABLE_FLASH 10172
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MENU 10174
#define IDS_CONTENT_CONTEXT_LANGUAGE_SETTINGS 10173
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MULTI_LINGUAL 10175
#define IDS_CONTENT_CONTEXT_CHECK_SPELLING_WHILE_TYPING 10176
#define IDS_ADDRESSES_AND_MORE_SUBMENU_OPTION 10177
#define IDS_PASSWORDS_AND_AUTOFILL_MENU 10178
#define IDS_RELAUNCH_TO_UPDATE_ALT 10179
#define IDS_RELAUNCH_TO_UPDATE_ALT_MINOR_TEXT 10180
#define IDS_NEW_TAB 10181
#define IDS_NEW_INCOGNITO_TAB 10182
#define IDS_SHOW_AS_TAB 10183
#define IDS_NEW_WINDOW 10184
#define IDS_NEW_INCOGNITO_WINDOW 10185
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE_WITH_EMAIL 10186
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE 10187
#define IDS_PROFILE_ROW_SYNC_IS_ON 10188
#define IDS_PROFILE_ROW_TURN_ON_SYNC 10189
#define IDS_PROFILE_ROW_SYNC_ERROR_MESSAGE 10190
#define IDS_PROFILE_ROW_SIGN_IN_AGAIN 10191
#define IDS_EDIT2 10192
#define IDS_CUT 10193
#define IDS_COPY 10194
#define IDS_PASTE 10195
#define IDS_DELETE 10196
#define IDS_FIND 10197
#define IDS_FIND_AND_EDIT_MENU 10198
#define IDS_PAYMENT_METHOD_SUBMENU_OPTION 10199
#define IDS_SAVE_AND_SHARE_MENU 10200
#define IDS_CAST_SAVE_AND_SHARE_MENU 10201
#define IDS_SAVE_AND_SHARE_MENU_CAST 10202
#define IDS_SAVE_AND_SHARE_MENU_SAVE 10203
#define IDS_SAVE_AND_SHARE_MENU_SHARE 10204
#define IDS_SAVE_PAGE 10205
#define IDS_MORE_TOOLS_MENU 10206
#define IDS_ZOOM_MENU 10207
#define IDS_ZOOM_MENU2 10208
#define IDS_ZOOM_PLUS 10209
#define IDS_ZOOM_PLUS2 10210
#define IDS_ZOOM_NORMAL 10211
#define IDS_ZOOM_MINUS 10212
#define IDS_ZOOM_MINUS2 10213
#define IDS_COPY_URL 10214
#define IDS_OPEN_IN_APP_WINDOW 10215
#define IDS_MOVE_TAB_TO_NEW_WINDOW 10216
#define IDS_SEARCH_TABS 10217
#define IDS_CUSTOMIZE_CHROME 10218
#define IDS_CLOSE_PROFILE 10219
#define IDS_MANAGE_GOOGLE_ACCOUNT 10220
#define IDS_OTHER_CHROME_PROFILES_TITLE 10221
#define IDS_OPEN_GUEST_PROFILE 10222
#define IDS_ADD_NEW_PROFILE 10223
#define IDS_MANAGE_CHROME_PROFILES 10224
#define IDS_ACCNAME_ZOOM_PLUS2 10227
#define IDS_ACCNAME_ZOOM_MINUS2 10228
#define IDS_VIEW_SOURCE 10229
#define IDS_FEEDBACK 10230
#define IDS_DEV_TOOLS 10231
#define IDS_DEV_TOOLS_ELEMENTS 10232
#define IDS_DEV_TOOLS_CONSOLE 10233
#define IDS_DEV_TOOLS_DEVICES 10234
#define IDS_TASK_MANAGER 10235
#define IDS_TAKE_SCREENSHOT 10236
#define IDS_RESTORE_ALL_TABS 10237
#define IDS_RESTORE_TAB 10238
#define IDS_REOPEN_WINDOW 10239
#define IDS_REOPEN_GROUP 10240
#define IDS_RESTORE_WINDOW 10241
#define IDS_RESTORE_GROUP 10242
#define IDS_NAME_WINDOW 10243
#define IDS_CHROMELABS 10244
#define IDS_TOS_NOTIFICATION_TITLE 10247
#define IDS_TOS_NOTIFICATION_BODY_TEXT 10248
#define IDS_TOS_NOTIFICATION_ACK_BUTTON_TEXT 10249
#define IDS_TOS_NOTIFICATION_REVIEW_BUTTON_TEXT 10250
#define IDS_TOS_NOTIFICATION_LINK 10251
#define IDS_HELP_MENU 10252
#define IDS_MANAGED 10253
#define IDS_MANAGED_BY 10254
#define IDS_MANAGED_BY_PARENT 10255
#define IDS_PROFILE_MANAGED_BY 10256
#define IDS_BROWSER_PROFILE_MANAGED 10257
#define IDS_CHROME_TIPS 10258
#define IDS_CHROME_WHATS_NEW 10259
#define IDS_IMPORT_SETTINGS_MENU_LABEL 10260
#define IDS_PROFILING_ENABLED 10261
#define IDS_FULLSCREEN 10262
#define IDS_CLEAR_BROWSING_DATA 10263
#define IDS_SHOW_DOWNLOADS 10264
#define IDS_SHOW_EXTENSIONS 10265
#define IDS_EXTENSIONS_SUBMENU 10266
#define IDS_EXTENSIONS_SUBMENU_MANAGE_EXTENSIONS_ITEM 10267
#define IDS_EXTENSIONS_SUBMENU_CHROME_WEBSTORE_ITEM 10268
#define IDS_SHOW_PERFORMANCE 10269
#define IDS_SHOW_SEARCH_COMPANION 10270
#define IDS_SHOW_TRANSLATE 10271
#define IDS_SETTINGS 10272
#define IDS_OPTIONS 10273
#define IDS_HELP_PAGE 10274
#define IDS_BETA_FORUM 10275
#define IDS_GET_HELP 10276
#define IDS_EXIT 10277
#define IDS_AUTOCOMPLETE_MATCH_DESCRIPTION_SEPARATOR 667
#define IDS_MANAGE_SEARCH_ENGINES 10278
#define IDS_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 10279
#define IDS_SEARCH_ENGINES_EDITOR_KEYWORD_COLUMN 10280
#define IDS_SEARCH_ENGINES_EDITOR_DESCRIPTION_COLUMN 10281
#define IDS_SEARCH_ENGINES_EDITOR_DEFAULT_ENGINE 10282
#define IDS_ACCNAME_DOWNLOADS_BAR 10283
#define IDS_HIDE_DOWNLOADS 10284
#define IDS_SHOW_ALL_DOWNLOADS 10285
#define IDS_DOWNLOAD_STARTED 10286
#define IDS_DOWNLOAD_INTERRUPTED_STATUS 10287
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_ACCESS_DENIED 10288
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_ACCESS_DENIED 10289
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_PATH_TOO_LONG 10290
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_PATH_TOO_LONG 10291
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_DISK_FULL 10292
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_DISK_FULL 10293
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_LARGE 10294
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_LARGE 10295
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_TEMPORARY_PROBLEM 10296
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_TEMPORARY_PROBLEM 10297
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_VIRUS 10298
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_VIRUS 10299
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_BLOCKED 10300
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_BLOCKED 10301
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CONTENT_LENGTH_MISMATCH 10302
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CONTENT_LENGTH_MISMATCH 10303
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SECURITY_CHECK_FAILED 10304
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SECURITY_CHECK_FAILED 10305
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_SHORT 10306
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_SHORT 10307
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_SAME_AS_SOURCE 10308
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_SAME_AS_SOURCE 10309
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_TIMEOUT 10310
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_TIMEOUT 10311
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_DISCONNECTED 10312
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_DISCONNECTED 10313
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_DOWN 10314
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_DOWN 10315
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_ERROR 10316
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_ERROR 10317
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NO_FILE 10318
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NO_FILE 10319
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_PROBLEM 10320
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_PROBLEM 10321
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_WEB_DRIVE_ERROR 10322
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SHUTDOWN 10323
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SHUTDOWN 10324
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CRASH 10325
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CRASH 10326
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNAUTHORIZED 10327
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNAUTHORIZED 10328
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_CERT_PROBLEM 10329
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_CERT_PROBLEM 10330
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FORBIDDEN 10331
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FORBIDDEN 10332
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNREACHABLE 10333
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNREACHABLE 10334
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN_WHEN_COMPLETE 10335
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN 10336
#define IDS_DOWNLOAD_STATUS_STARTING 10337
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS 10348
#define IDS_DOWNLOAD_STATUS_SIZES 10349
#define IDS_DOWNLOAD_STATUS_OPEN_IN 10350
#define IDS_DOWNLOAD_STATUS_OPEN_WHEN_COMPLETE 10351
#define IDS_DOWNLOAD_STATUS_OPENING 10352
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_SHORT 10353
#define IDS_DOWNLOAD_STATUS_CANCELLED 10354
#define IDS_DOWNLOAD_STATUS_REMOVED 10355
#define IDS_DOWNLOAD_STATUS_UPLOADING 10356
#define IDS_DOWNLOAD_STATUS_UPLOADED 10357
#define IDS_DOWNLOAD_STATUS_UPLOAD_INTERRUPTED 10358
#define IDS_DOWNLOAD_STATUS_INTERRUPTED 10359
#define IDS_DOWNLOAD_UNCONFIRMED_PREFIX 10360
#define IDS_PROMPT_DANGEROUS_DOWNLOAD 10361
#define IDS_PROMPT_DANGEROUS_DOWNLOAD_EXTENSION 10362
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT 10363
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT_IN_ADVANCED_PROTECTION 10364
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD 10365
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD_SHORT 10366
#define IDS_PROMPT_DEEP_SCANNING_APP_DOWNLOAD 10367
#define IDS_PROMPT_CONFIRM_INSECURE_DOWNLOAD 10368
#define IDS_PROMPT_DOWNLOAD_BLOCKED_TOO_LARGE 10369
#define IDS_PROMPT_DOWNLOAD_BLOCKED_PASSWORD_PROTECTED 10370
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_SAFE 10371
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_WARNING 10372
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_BLOCKED 10373
#define IDS_PROMPT_DOWNLOAD_BLOCKED_SCAN_FAILED 10374
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_OPENED_DANGEROUS 10375
#define IDS_PROMPT_DOWNLOAD_INSECURE_WARNING 10376
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED 10377
#define IDS_PROMPT_APP_DEEP_SCANNING 10378
#define IDS_PROMPT_DEEP_SCANNING 10379
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD_IN_ADVANCED_PROTECTION 10380
#define IDS_BLOCK_REASON_DEEP_SCANNING_UPDATED 10381
#define IDS_BLOCK_REASON_DEEP_SCANNING_SECOND_UPDATED 10382
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING_UPDATED 10383
#define IDS_BLOCK_REASON_PROMPT_FOR_LOCAL_PASSWORD_SCANNING 10384
#define IDS_DEEP_SCANNED_OPENED_DANGEROUS_DESCRIPTION 10385
#define IDS_BLOCK_REASON_SENSITIVE_CONTENT_WARNING 10386
#define IDS_SENSITIVE_CONTENT_BLOCKED_DESCRIPTION 10387
#define IDS_BLOCKED_TOO_LARGE_DESCRIPTION 10388
#define IDS_BLOCKED_PASSWORD_PROTECTED_DESCRIPTION 10389
#define IDS_DEEP_SCANNED_FAILED_DESCRIPTION 10390
#define IDS_DOWNLOADS_TOAST_DELETED_FROM_HISTORY_STILL_ON_DEVICE 10391
#define IDS_DOWNLOADS_TOAST_DELETED_FROM_HISTORY 10392
#define IDS_DOWNLOADS_TOAST_COPIED_DOWNLOAD_LINK 10393
#define IDS_CONFIRM_KEEP_DANGEROUS_DOWNLOAD_TITLE 10397
#define IDS_CONFIRM_DOWNLOAD 10398
#define IDS_CONTINUE_EXTENSION_DOWNLOAD 10399
#define IDS_DISCARD_DOWNLOAD 10400
#define IDS_OPEN_DOWNLOAD_NOW 10401
#define IDS_SCAN_DOWNLOAD 10402
#define IDS_REVIEW_DOWNLOAD 10403
#define IDS_OPEN_DOWNLOAD_ANYWAY 10404
#define IDS_DOWNLOAD_LINK_PAUSE 10405
#define IDS_DOWNLOAD_HISTORY_SEARCH 10406
#define IDS_DOWNLOAD_NO_DOWNLOADS 10407
#define IDS_DOWNLOAD_ITEM_DROPDOWN_BUTTON_ACCESSIBLE_TEXT 10408
#define IDS_DOWNLOAD_LINK_RESUME 10409
#define IDS_DOWNLOAD_LINK_CANCEL 10410
#define IDS_DOWNLOAD_LINK_RETRY 10411
#define IDS_DOWNLOAD_LINK_SHOW_IN_WEB_DRIVE 10412
#define IDS_DOWNLOAD_LINK_SHOW 10413
#define IDS_DOWNLOAD_TAB_CANCELLED 10414
#define IDS_DOWNLOAD_FILE_REMOVED 10415
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS_TIME_UNKNOWN 10416
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS 10417
#define IDS_DOWNLOAD_TAB_PROGRESS_SIZE 10418
#define IDS_DOWNLOAD_PROGRESS_PAUSED 10419
#define IDS_DOWNLOAD_LINK_CLEAR_ALL 10420
#define IDS_DOWNLOAD_LINK_OPEN_DOWNLOADS_FOLDER 10421
#define IDS_DOWNLOAD_MORE_ACTIONS 10422
#define IDS_DOWNLOAD_ACTION_MENU_DESCRIPTION 10423
#define IDS_DOWNLOAD_BY_EXTENSION_URL 10424
#define IDS_DOWNLOADS_PAGE_REFERRER_LINE 10425
#define IDS_DOWNLOAD_IN_INCOGNITO 10426
#define IDS_UNDO_DESCRIPTION 482
#define IDS_DOWNLOAD_UNDO 10427
#define IDS_DOWNLOAD_TOAST_CLEARED_ALL 10428
#define IDS_DOWNLOAD_DEEP_SCAN 10429
#define IDS_DOWNLOAD_DEEP_SCAN_UPDATED 10430
#define IDS_DOWNLOAD_BYPASS_DEEP_SCAN 10431
#define IDS_DOWNLOAD_LOCAL_PASSWORD_SCAN 10432
#define IDS_DOWNLOAD_KEEP_DANGEROUS_FILE 10433
#define IDS_DOWNLOAD_KEEP_SUSPICIOUS_FILE 10434
#define IDS_DOWNLOAD_KEEP_UNVERIFIED_FILE 10435
#define IDS_DOWNLOAD_KEEP_INSECURE_FILE 10436
#define IDS_DOWNLOAD_DELETE_FROM_HISTORY 10437
#define IDS_DOWNLOAD_COPY_DOWNLOAD_LINK 10438
#define IDS_DOWNLOAD_DANGEROUS_ICON_ACCESSIBLE_LABEL 10439
#define IDS_DOWNLOAD_SUSPICIOUS_ICON_ACCESSIBLE_LABEL 10440
#define IDS_DOWNLOAD_INSECURE_ICON_ACCESSIBLE_LABEL 10441
#define IDS_DOWNLOAD_UNVERIFIED_ICON_ACCESSIBLE_LABEL 10442
#define IDS_DOWNLOAD_SCREENREADER_SAVED_DANGEROUS 10443
#define IDS_DOWNLOAD_SCREENREADER_SAVED_SUSPICIOUS 10444
#define IDS_DOWNLOAD_SCREENREADER_SAVED_INSECURE 10445
#define IDS_DOWNLOAD_SCREENREADER_SAVED_UNVERIFIED 10446
#define IDS_DOWNLOAD_SCREENREADER_PAUSED 10447
#define IDS_DOWNLOAD_SCREENREADER_RESUMED 10448
#define IDS_DOWNLOAD_SCREENREADER_CANCELED 10449
#define IDS_DOWNLOAD_WARNING_BYPASS_DIALOG_TITLE 10450
#define IDS_DOWNLOAD_WARNING_BYPASS_PROMPT_DESCRIPTION 10451
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_ACCESSIBLE_ALERT 10452
#define IDS_DOWNLOAD_STATUS_PERCENT_COMPLETE_ACCESSIBLE_ALERT 10453
#define IDS_DOWNLOAD_STATUS_TIME_REMAINING_ACCESSIBLE_ALERT 10454
#define IDS_DOWNLOAD_FAILED_ACCESSIBLE_ALERT 10455
#define IDS_DOWNLOAD_CANCELLED_ACCESSIBLE_ALERT 10456
#define IDS_DOWNLOAD_COMPLETE_ACCESSIBLE_ALERT 10457
#define IDS_DOWNLOAD_PAUSED_ACCESSIBLE_ALERT 10458
#define IDS_PROMPT_DEEP_SCANNING_ACCESSIBLE_ALERT 10459
#define IDS_DEEP_SCANNING_ACCESSIBLE_ALERT 10460
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED_ACCESSIBLE_ALERT 10461
#define IDS_DOWNLOAD_NOTIFICATION_COPY_TO_CLIPBOARD 10462
#define IDS_DOWNLOAD_MENU_SHOW 10463
#define IDS_DOWNLOAD_MENU_OPEN_WHEN_COMPLETE 10464
#define IDS_DOWNLOAD_MENU_OPEN 10465
#define IDS_DOWNLOAD_MENU_ALWAYS_OPEN_TYPE 10466
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN 10467
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN_ALWAYS 10468
#define IDS_DOWNLOAD_MENU_CANCEL 10469
#define IDS_DOWNLOAD_MENU_PAUSE_ITEM 10470
#define IDS_DOWNLOAD_MENU_RESUME_ITEM 10471
#define IDS_DOWNLOAD_MENU_DISCARD 10472
#define IDS_DOWNLOAD_MENU_KEEP 10473
#define IDS_DOWNLOAD_MENU_LEARN_MORE_SCANNING 10474
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INTERRUPTED 10475
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INSECURE 10476
#define IDS_DOWNLOAD_MENU_DEEP_SCAN 10477
#define IDS_ABANDON_DOWNLOAD_DIALOG_TITLE 10488
#define IDS_ABANDON_DOWNLOAD_DIALOG_CONTINUE_BUTTON 10489
#define IDS_ABANDON_DOWNLOAD_DIALOG_INCOGNITO_MESSAGE 10490
#define IDS_ABANDON_DOWNLOAD_DIALOG_GUEST_MESSAGE 10491
#define IDS_ABANDON_DOWNLOAD_DIALOG_EXIT_BUTTON 10492
#define IDS_DOWNLOAD_BUBBLE_HEADER_LABEL 10493
#define IDS_DOWNLOAD_BUBBLE_FOOTER_LABEL 10494
#define IDS_DOWNLOAD_BUBBLE_FOOTER_TOOLTIP_LABEL 10495
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO 10496
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_CUSTOM_ACTION 10497
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_DISMISS 10498
#define IDS_DOWNLOAD_BUBBLE_ESB_PROMO_TITLE 10499
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_MESSAGE_WITH_SEPARATOR 10500
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_WITH_SYMBOL 10501
#define IDS_DOWNLOAD_BUBBLE_STATUS_RESUMING 10502
#define IDS_DOWNLOAD_BUBBLE_STATUS_DONE 10503
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_DONE_UPDATED 10504
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_INSECURE 10505
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_SUSPICIOUS 10506
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_DANGEROUS 10507
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_UNVERIFIED 10508
#define IDS_DOWNLOAD_BUBBLE_STATUS_BLOCKED 10509
#define IDS_DOWNLOAD_BUBBLE_STATUS_MALWARE 10510
#define IDS_DOWNLOAD_BUBBLE_STATUS_SUSPICIOUS 10511
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNED_FAILED_UPDATED 10512
#define IDS_DOWNLOAD_BUBBLE_CHECKBOX_BYPASS 10513
#define IDS_DOWNLOAD_BUBBLE_CONTINUE 10514
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_INSECURE_FILE 10515
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_SUSPICIOUS_FILE 10516
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_UNVERIFIED_FILE 10517
#define IDS_DOWNLOAD_BUBBLE_DELETE 10518
#define IDS_DOWNLOAD_BUBBLE_DELETE_FROM_HISTORY 10519
#define IDS_DOWNLOAD_BUBBLE_MAIN_BUTTON_SUBPAGE 10520
#define IDS_DOWNLOAD_BUBBLE_RESUME 10521
#define IDS_DOWNLOAD_BUBBLE_SCAN 10522
#define IDS_DOWNLOAD_BUBBLE_OPEN 10523
#define IDS_DOWNLOAD_BUBBLE_SCAN_UPDATED 10524
#define IDS_DOWNLOAD_BUBBLE_OPEN_UPDATED 10525
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW 10526
#define IDS_DOWNLOAD_BUBBLE_REVIEW 10527
#define IDS_DOWNLOAD_BUBBLE_RETRY 10528
#define IDS_DOWNLOAD_BUBBLE_OPEN_ANYWAY 10529
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_DISK_FULL 10530
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_DISK_FULL 10531
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_PATH_TOO_LONG 10532
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_PATH_TOO_LONG 10533
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NEEDS_PERMISSION 10534
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_TOO_LARGE 10535
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_TOO_LARGE 10536
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_UNFINISHED 10537
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_BLOCKED_ORGANIZATION 10538
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_WRONG 10539
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NETWORK_ERROR 10540
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_SITE_UNAVAILABLE 10541
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNAVAILABLE 10542
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_UNAVAILABLE 10543
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNFINISHED 10544
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_INSECURE 10545
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS 10546
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DECEPTIVE 10547
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS_FILE_TYPE 10548
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_UNCOMMON_FILE 10549
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_NO_SAFE_BROWSING 10550
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LABEL 10551
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LINK 10552
#define IDS_DOWNLOAD_BUBBLE_STATUS_DANGEROUS 10553
#define IDS_DOWNLOAD_BUBBLE_STATUS_ENCRYPTED 10554
#define IDS_DOWNLOAD_BUBBLE_STATUS_TOO_BIG 10555
#define IDS_DOWNLOAD_BUBBLE_STATUS_ADVANCED_PROTECTION 10556
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ADVANCED_PROTECTION 10557
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNCOMMON_FILE 10558
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNCOMMON_FILE 10559
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNKNOWN_SOURCE 10560
#define IDS_DOWNLOAD_BUBBLE_STATUS_SENSITIVE_CONTENT 10561
#define IDS_DOWNLOAD_BUBBLE_STATUS_SCAN_FAILED 10562
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_WARNING 10563
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_BLOCK 10564
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ENCRYPTED 10565
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_TOO_BIG 10566
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING 10567
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_SECONDARY 10568
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_ENTERPRISE_SECONDARY 10569
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_DISCARD 10570
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_CANCEL 10571
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SCAN_FAILED 10572
#define IDS_DOWNLOAD_BUBBLE_TRY_AGAIN 10573
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING_ENTERPRISE 10574
#define IDS_DOWNLOAD_BUBBLE_INCOGNITO_INFORMATION_ROW 10575
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION 10576
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION_ACCESSIBILITY 10577
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION 10578
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION_ACCESSIBILITY 10579
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION 10580
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION_ACCESSIBILITY 10581
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION 10582
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION_ACCESSIBILITY 10583
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION 10584
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION_ACCESSIBILITY 10585
#define IDS_DOWNLOAD_BUBBLE_BACK_RECENT_DOWNLOADS 10586
#define IDS_DOWNLOAD_BUBBLE_CANCEL_MAIN_BUTTON_ACCESSIBILITY 10587
#define IDS_DOWNLOAD_BUBBLE_DELETE_MAIN_BUTTON_ACCESSIBILITY 10588
#define IDS_DOWNLOAD_BUBBLE_KEEP_MAIN_BUTTON_ACCESSIBILITY 10589
#define IDS_DOWNLOAD_BUBBLE_SCAN_MAIN_BUTTON_ACCESSIBILITY 10590
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW_MAIN_BUTTON_ACCESSIBILITY 10591
#define IDS_DOWNLOAD_BUBBLE_RESUME_MAIN_BUTTON_ACCESSIBILITY 10592
#define IDS_DOWNLOAD_BUBBLE_REVIEW_MAIN_BUTTON_ACCESSIBILITY 10593
#define IDS_DOWNLOAD_BUBBLE_RETRY_MAIN_BUTTON_ACCESSIBILITY 10594
#define IDS_DOWNLOAD_BUBBLE_OPEN_MAIN_BUTTON_ACCESSIBILITY 10595
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW 10596
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_REMINDER 10597
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_LINK 10598
#define IDS_DOWNLOAD_BUBBLE_TOOLTIP_IN_PROGRESS_COUNT 10599
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT 10602
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT_AND_ACCOUNT 10603
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_ARCHIVE_MALWARE 10604
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_PROMPT_UPDATED 10605
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING 10606
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_UPDATED 10607
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_ENCRYPTED_ARCHIVE 10608
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_DEEP_SCANNING_LINK 10609
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT 10610
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_EMPTY 10611
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_INVALID 10612
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT 10613
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT_EMPTY 10614
#define IDS_DOWNLOAD_BUBBLE_PASSWORD_PROMPT_ACCESSIBLE_ALERT_INVALID 10615
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_IMMEDIATE_DEEP_SCAN_IN_PROGRESS 10616
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_IMMEDIATE_DEEP_SCAN_CANCEL 10617
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_IMMEDIATE_DEEP_SCAN_BYPASS 10618
#define IDS_DOWNLOAD_BUBBLE_STATUS_LOCAL_DECRYPTION_STATUS 10619
#define IDS_DOWNLOAD_BUBBLE_STATUS_PASSWORD_NEEDED 10620
#define IDS_DOWNLOAD_BUBBLE_ACCEPT_LOCAL_DECRYPTION 10621
#define IDS_DOWNLOAD_BUBBLE_BYPASS_LOCAL_DECRYPTION 10622
#define IDS_DOWNLOAD_BUBBLE_LOCAL_DECRYPTION_CANCEL 10623
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_LOCAL_DECRYPTION_IN_PROGRESS 10624
#define IDS_DOWNLOAD_BUBBLE_STATUS_LOCAL_DECRYPTING 10625
#define IDS_DOWNLOAD_LOCAL_DECRYPTION_PROMPT_ALERT 10626
#define IDS_WEB_APP_WITH_APP_TITLE 10627
#define IDS_OMNIBOX_PWA_INSTALL_ICON_LABEL 453
#define IDS_OMNIBOX_PWA_INSTALL_ICON_TOOLTIP 688
#define IDS_ADD_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 10628
#define IDS_CREATE_SHORTCUTS_BUTTON_LABEL 10629
#define IDS_CREATE_SHORTCUT_NOT_APPS_DIALOG_TITLE 10630
#define IDS_CREATE_SHORTCUT_NOT_APPS_AX_BUBBLE_LABEL 10631
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 10632
#define IDS_INSTALL_PWA_BUTTON_LABEL 10633
#define IDS_INSTALL_PWA_DIALOG_TITLE 10634
#define IDS_WEB_APP_DETAILED_INSTALL_DIALOG_DESCRIPTION_TITLE 10635
#define IDS_DIY_APP_INSTALL_DIALOG_TITLE 10636
#define IDS_DIY_APP_INSTALL_DIALOG_SUBTITLE 10637
#define IDS_DIY_APP_AX_BUBBLE_NAME_LABEL 10638
#define IDS_BOOKMARK_APP_AX_BUBBLE_NAME_LABEL 10639
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TAB 10640
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_WINDOW 10641
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TABBED_WINDOW 10642
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME 10643
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_ICON 10644
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_ICON 10645
#define IDS_WEBAPP_UPDATE_EXPLANATION 10646
#define IDS_WEBAPP_UPDATE_CURRENT_ICON 10647
#define IDS_WEBAPP_UPDATE_NEW_ICON 10648
#define IDS_WEBAPP_UPDATE_NEGATIVE_BUTTON 10649
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION 10650
#define IDS_FINISH_POLICY_WEB_APP_INSTALATION_RESTART 10651
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION_NOT_NOW 10652
#define IDS_ADD_TO_OS_LAUNCH_SURFACE 10657
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE 10658
#define IDS_INSTALL_DIY_TO_OS_LAUNCH_SURFACE 10659
#define IDS_UNINSTALL_FROM_OS_LAUNCH_SURFACE 10660
#define IDS_APPLICATION_INFO_WEB_STORE_LINK 10661
#define IDS_APPLICATION_INFO_HOMEPAGE_LINK 10662
#define IDS_ARC_APPLICATION_INFO_MANAGE_LINK 10663
#define IDS_APPLICATION_INFO_APP_OVERVIEW_TITLE 10664
#define IDS_APPLICATION_INFO_APP_PERMISSIONS_TITLE 10665
#define IDS_APPLICATION_INFO_UNINSTALL_BUTTON_TEXT 10666
#define IDS_APPLICATION_INFO_LICENSES_BUTTON_TEXT 10667
#define IDS_APPLICATION_INFO_SIZE_LABEL 10668
#define IDS_APPLICATION_INFO_VERSION_LABEL 10669
#define IDS_APPLICATION_INFO_CREATE_SHORTCUTS_BUTTON_TEXT 10670
#define IDS_APPLICATION_INFO_LAUNCH_OPTIONS_ACCNAME 10671
#define IDS_APPLICATION_INFO_SIZE_LOADING_LABEL 10672
#define IDS_APPLICATION_INFO_SIZE_SMALL_LABEL 10673
#define IDS_APPLICATION_INFO_REVOKE_PERMISSION_ALT_TEXT 10674
#define IDS_APPLICATION_INFO_APP_NO_PERMISSIONS_TEXT 10675
#define IDS_APPLICATION_INFO_EXTENSION_NO_PERMISSIONS_TEXT 10676
#define IDS_APPLICATION_INFO_RETAINED_FILES 10677
#define IDS_APPLICATION_INFO_RETAINED_DEVICES 10678
#define IDS_CREATE_SHORTCUTS_TITLE 10679
#define IDS_CREATE_SHORTCUTS_LABEL 10680
#define IDS_CREATE_SHORTCUTS_DESKTOP_CHKBOX 10681
#define IDS_CREATE_SHORTCUTS_MENU_CHKBOX 10682
#define IDS_CREATE_SHORTCUTS_COMMIT 10683
#define IDS_CREATE_SHORTCUTS_START_MENU_CHKBOX 10684
#define IDS_PIN_TO_TASKBAR_CHKBOX 10685
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_TITLE 10686
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_LABEL 10687
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_TITLE 10688
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_LABEL 10689
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_TITLE 10690
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_LABEL 10691
#define IDS_MANAGE 10692
#define IDS_LIST_BULLET 10693
#define IDS_BLOCKED_DOWNLOAD_NO_ACTION 10694
#define IDS_BLOCKED_DOWNLOAD_UNBLOCK 10695
#define IDS_ALLOWED_DOWNLOAD_TITLE 10696
#define IDS_BLOCKED_DOWNLOAD_TITLE 10697
#define IDS_BLOCKED_DOWNLOADS_EXPLANATION 10698
#define IDS_ALLOWED_DOWNLOAD_NO_ACTION 10699
#define IDS_ALLOWED_DOWNLOAD_BLOCK 10700
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_TITLE 10701
#define IDS_ACCESSED_ON_DEVICE_SITE_DATA_TITLE 10702
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_MESSAGE 10703
#define IDS_ACCESSED_ON_DEVICE_SITE_DATA_MESSAGE 10704
#define IDS_BLOCKED_COOKIES_INFO 10705
#define IDS_BLOCKED_IMAGES_TITLE 10706
#define IDS_BLOCKED_IMAGES_MESSAGE 10707
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_UNBLOCK 10708
#define IDS_BLOCKED_IMAGES_UNBLOCK 10709
#define IDS_BLOCKED_ON_DEVICE_SITE_DATA_NO_ACTION 10710
#define IDS_ALLOWED_ON_DEVICE_SITE_DATA_NO_ACTION 10711
#define IDS_ALLOWED_ON_DEVICE_SITE_DATA_BLOCK 10712
#define IDS_BLOCKED_IMAGES_NO_ACTION 10713
#define IDS_BLOCKED_POPUPS_TOOLTIP 10714
#define IDS_BLOCKED_POPUPS_TITLE 10715
#define IDS_BLOCKED_POPUPS_REDIRECTS_UNBLOCK 10716
#define IDS_BLOCKED_POPUPS_REDIRECTS_NO_ACTION 10717
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ALLOW 10718
#define IDS_BLOCKED_MEDIASTREAM_MIC_ALLOW 10719
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ALLOW 10720
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ASK 10721
#define IDS_BLOCKED_MEDIASTREAM_MIC_ASK 10722
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ASK 10723
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_BLOCK 10724
#define IDS_ALLOWED_MEDIASTREAM_MIC_BLOCK 10725
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_BLOCK 10726
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 10727
#define IDS_BLOCKED_MEDIASTREAM_MIC_NO_ACTION 10728
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_NO_ACTION 10729
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 10730
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_PAN_TILT_ZOOM_NO_ACTION 10731
#define IDS_ALLOWED_MEDIASTREAM_MIC_NO_ACTION 10732
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_NO_ACTION 10733
#define IDS_ALLOWED_CAMERA_PAN_TILT_ZOOM_NO_ACTION 10734
#define IDS_BLOCKED_POPUPS_EXPLANATORY_TEXT 10735
#define IDS_BLOCKED_JAVASCRIPT_TITLE 10736
#define IDS_BLOCKED_JAVASCRIPT_MESSAGE 10737
#define IDS_BLOCKED_JAVASCRIPT_UNBLOCK 10738
#define IDS_BLOCKED_JAVASCRIPT_NO_ACTION 10739
#define IDS_BLOCKED_SOUND_TITLE 10740
#define IDS_BLOCKED_SOUND_UNBLOCK 10741
#define IDS_BLOCKED_SOUND_NO_ACTION 10742
#define IDS_NOTIFICATIONS_OFF_EXPLANATORY_TEXT 442
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_TITLE 10743
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DESCRIPTION 10744
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_DESCRIPTION 10745
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 10746
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_COMPACT_ALLOW_BUTTON 10747
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CONTINUE_BLOCKING_BUTTON 10748
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_EARLY_PROMO 10749
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 10750
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 10751
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ABUSIVE_DESCRIPTION 10752
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DISRUPTIVE_DESCRIPTION 10753
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 10754
#define IDS_GEOLOCATION_OFF_EXPLANATORY_TEXT 10755
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_TITLE 10756
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 10757
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 10758
#define IDS_STORAGE_ACCESS_PERMISSION_BUBBLE_MESSAGE 10759
#define IDS_STORAGE_ACCESS_PERMISSION_ALLOWED_TOOLTIP 10760
#define IDS_STORAGE_ACCESS_PERMISSION_BLOCKED_TOOLTIP 10761
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_BLOCKED_TITLE 10762
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_ALLOWED_TITLE 10763
#define IDS_COOKIE_CONTROLS_BUBBLE_SITE_NOT_WORKING_TITLE 10764
#define IDS_TRACKING_PROTECTION_BUBBLE_SITE_NOT_WORKING_DESCRIPTION 10765
#define IDS_TRACKING_PROTECTION_BUBBLE_LIMITING_RESTART_TITLE 10766
#define IDS_TRACKING_PROTECTION_BUBBLE_BLOCKING_RESTART_TITLE 10767
#define IDS_TRACKING_PROTECTION_BUBBLE_BLOCKING_RESTART_DESCRIPTION 10768
#define IDS_TRACKING_PROTECTION_BUBBLE_PERMANENT_ALLOWED_TITLE 10769
#define IDS_TRACKING_PROTECTION_BUBBLE_PERMANENT_ALLOWED_DESCRIPTION 10770
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_TITLE 10771
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_DESCRIPTION 10772
#define IDS_COOKIE_CONTROLS_BUBBLE_RELOADING_LABEL 10773
#define IDS_COOKIE_CONTROLS_BUBBLE_THIRD_PARTY_COOKIES_LABEL 10774
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_FORM_PLACEHOLDER 10775
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_ALLOWED_LABEL 10776
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_BLOCKED_LABEL 10777
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_LIMITED_LABEL 10778
#define IDS_TRACKING_PROTECTION_PAGE_ACTION_SITE_NOT_WORKING_LABEL 10779
#define IDS_COOKIE_CONTROLS_PROMO_TITLE 10780
#define IDS_COOKIE_CONTROLS_PROMO_TEXT 10781
#define IDS_COOKIE_CONTROLS_PROMO_CLOSE_BUTTON_TEXT 10782
#define IDS_COOKIE_CONTROLS_PROMO_SEE_HOW_BUTTON_TEXT 10783
#define IDS_CERT_SELECTOR_SUBJECT_COLUMN 10784
#define IDS_CERT_SELECTOR_ISSUER_COLUMN 10785
#define IDS_CERT_SELECTOR_PROVIDER_COLUMN 10786
#define IDS_CERT_SELECTOR_SERIAL_COLUMN 10787
#define IDS_CERT_EXPORT_TYPE_BASE64_ALL 10788
#define IDS_CERT_EXPORT_TYPE_BASE64 10789
#define IDS_CERT_EXPORT_TYPE_BASE64_CHAIN 10790
#define IDS_CERT_EXPORT_TYPE_DER 10791
#define IDS_CERT_EXPORT_TYPE_PKCS7 10792
#define IDS_CERT_EXPORT_TYPE_PKCS7_CHAIN 10793
#define IDS_CERT_INFO_DIALOG_TITLE 10794
#define IDS_CERT_INFO_GENERAL_TAB_LABEL 10795
#define IDS_CERT_INFO_DETAILS_TAB_LABEL 10796
#define IDS_CERT_INFO_MODIFICATIONS_TAB_LABEL 10797
#define IDS_CERT_INFO_TRUST_LABEL 10798
#define IDS_CERT_INFO_TRUST_STATE_LABEL 10799
#define IDS_CERT_INFO_TRUST_STATE_DISTRUSTED 10800
#define IDS_CERT_INFO_TRUST_STATE_HINT 10801
#define IDS_CERT_INFO_TRUST_STATE_TRUSTED 10802
#define IDS_CERT_INFO_CONSTRAINTS_LABEL 10803
#define IDS_CERT_INFO_ADD_CONSTRAINTS_LABEL 10804
#define IDS_CERT_INFO_ADD_CONSTRAINTS_BUTTON_LABEL 10805
#define IDS_CERT_INFO_ADD_CONSTRAINTS_PLACEHOLDER 10806
#define IDS_CERT_INFO_ADD_CONSTRAINT_ERROR_MESSAGE 10807
#define IDS_CERT_INFO_DELETE_CONSTRAINT_ERROR_MESSAGE 10808
#define IDS_CERT_INFO_TRUST_STATE_ERROR_MESSAGE 10809
#define IDS_CERT_USAGE_SSL_CLIENT 10810
#define IDS_CERT_USAGE_SSL_SERVER 10811
#define IDS_CERT_USAGE_OBJECT_SIGNER 10812
#define IDS_CERT_USAGE_SSL_CA 10813
#define IDS_CERT_INFO_IDN_VALUE_FORMAT 10814
#define IDS_CERT_INFO_FIELD_NOT_PRESENT 10815
#define IDS_CERT_DETAILS_CERTIFICATE_HIERARCHY_LABEL 10816
#define IDS_CERT_DETAILS_CERTIFICATE_FIELDS_LABEL 10817
#define IDS_CERT_DETAILS_CERTIFICATE_FIELD_VALUE_LABEL 10818
#define IDS_CERT_DETAILS_CERTIFICATE 10819
#define IDS_CERT_DETAILS_VERSION 10820
#define IDS_CERT_DETAILS_VERSION_FORMAT 10821
#define IDS_CERT_DETAILS_SERIAL_NUMBER 10822
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_ALG 10823
#define IDS_CERT_DETAILS_ISSUER 10824
#define IDS_CERT_DETAILS_VALIDITY 10825
#define IDS_CERT_DETAILS_NOT_BEFORE 10826
#define IDS_CERT_DETAILS_NOT_AFTER 10827
#define IDS_CERT_DETAILS_SUBJECT 10828
#define IDS_CERT_DETAILS_SUBJECT_KEY_INFO 10829
#define IDS_CERT_DETAILS_SUBJECT_KEY_ALG 10830
#define IDS_CERT_DETAILS_SUBJECT_KEY 10831
#define IDS_CERT_RSA_PUBLIC_KEY_DUMP_FORMAT 10832
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_VALUE 10833
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE 10834
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE_A11Y_LABEL 10835
#define IDS_CERT_OID_AVA_COMMON_NAME 10836
#define IDS_CERT_OID_AVA_STATE_OR_PROVINCE 10837
#define IDS_CERT_OID_AVA_ORGANIZATION_NAME 10838
#define IDS_CERT_OID_AVA_ORGANIZATIONAL_UNIT_NAME 10839
#define IDS_CERT_OID_AVA_DN_QUALIFIER 10840
#define IDS_CERT_OID_AVA_COUNTRY_NAME 10841
#define IDS_CERT_OID_AVA_SERIAL_NUMBER 10842
#define IDS_CERT_OID_AVA_LOCALITY 10843
#define IDS_CERT_OID_AVA_DC 10844
#define IDS_CERT_OID_RFC1274_MAIL 10845
#define IDS_CERT_OID_RFC1274_UID 10846
#define IDS_CERT_OID_PKCS9_EMAIL_ADDRESS 10847
#define IDS_CERT_OID_BUSINESS_CATEGORY 10848
#define IDS_CERT_OID_EV_INCORPORATION_LOCALITY 10849
#define IDS_CERT_OID_EV_INCORPORATION_STATE 10850
#define IDS_CERT_OID_EV_INCORPORATION_COUNTRY 10851
#define IDS_CERT_OID_AVA_STREET_ADDRESS 10852
#define IDS_CERT_OID_AVA_POSTAL_CODE 10853
#define IDS_CERT_OID_PKCS1_RSA_ENCRYPTION 10854
#define IDS_CERT_OID_PKCS1_MD2_WITH_RSA_ENCRYPTION 10855
#define IDS_CERT_OID_PKCS1_MD4_WITH_RSA_ENCRYPTION 10856
#define IDS_CERT_OID_PKCS1_MD5_WITH_RSA_ENCRYPTION 10857
#define IDS_CERT_OID_PKCS1_SHA1_WITH_RSA_ENCRYPTION 10858
#define IDS_CERT_OID_PKCS1_SHA256_WITH_RSA_ENCRYPTION 10859
#define IDS_CERT_OID_PKCS1_SHA384_WITH_RSA_ENCRYPTION 10860
#define IDS_CERT_OID_PKCS1_SHA512_WITH_RSA_ENCRYPTION 10861
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA1_SIGNATURE 10862
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA256_SIGNATURE 10863
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA384_SIGNATURE 10864
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA512_SIGNATURE 10865
#define IDS_CERT_OID_ANSIX962_EC_PUBLIC_KEY 10866
#define IDS_CERT_OID_SECG_EC_SECP256R1 10867
#define IDS_CERT_OID_SECG_EC_SECP384R1 10868
#define IDS_CERT_OID_SECG_EC_SECP521R1 10869
#define IDS_CERT_EXT_NS_CERT_TYPE 10870
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL 10871
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL_CA 10872
#define IDS_CERT_EXT_NS_CERT_BASE_URL 10873
#define IDS_CERT_EXT_NS_CERT_REVOCATION_URL 10874
#define IDS_CERT_EXT_NS_CA_REVOCATION_URL 10875
#define IDS_CERT_EXT_NS_CERT_RENEWAL_URL 10876
#define IDS_CERT_EXT_NS_CA_POLICY_URL 10877
#define IDS_CERT_EXT_NS_SSL_SERVER_NAME 10878
#define IDS_CERT_EXT_NS_COMMENT 10879
#define IDS_CERT_EXT_NS_LOST_PASSWORD_URL 10880
#define IDS_CERT_EXT_NS_CERT_RENEWAL_TIME 10881
#define IDS_CERT_X509_SUBJECT_DIRECTORY_ATTR 10882
#define IDS_CERT_X509_SUBJECT_KEYID 10883
#define IDS_CERT_KEYID_FORMAT 10884
#define IDS_CERT_ISSUER_FORMAT 10885
#define IDS_CERT_SERIAL_NUMBER_FORMAT 10886
#define IDS_CERT_X509_KEY_USAGE 10887
#define IDS_CERT_X509_ISSUER_ALT_NAME 10888
#define IDS_CERT_X509_BASIC_CONSTRAINTS 10889
#define IDS_CERT_X509_NAME_CONSTRAINTS 10890
#define IDS_CERT_X509_CRL_DIST_POINTS 10891
#define IDS_CERT_X509_CERT_POLICIES 10892
#define IDS_CERT_X509_SCT_LIST 10893
#define IDS_CERT_X509_POLICY_MAPPINGS 10894
#define IDS_CERT_X509_POLICY_CONSTRAINTS 10895
#define IDS_CERT_X509_AUTH_KEYID 10896
#define IDS_CERT_X509_EXT_KEY_USAGE 10897
#define IDS_CERT_X509_AUTH_INFO_ACCESS 10898
#define IDS_CERT_X509_KEY_USAGE_SIGNING 10899
#define IDS_CERT_X509_KEY_USAGE_NONREP 10900
#define IDS_CERT_X509_KEY_USAGE_ENCIPHERMENT 10901
#define IDS_CERT_X509_KEY_USAGE_DATA_ENCIPHERMENT 10902
#define IDS_CERT_X509_KEY_USAGE_KEY_AGREEMENT 10903
#define IDS_CERT_X509_KEY_USAGE_CERT_SIGNER 10904
#define IDS_CERT_X509_KEY_USAGE_CRL_SIGNER 10905
#define IDS_CERT_X509_KEY_USAGE_ENCIPHER_ONLY 10906
#define IDS_CERT_X509_KEY_USAGE_DECIPHER_ONLY 10907
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_CA 10908
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_NOT_CA 10909
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN 10910
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN_UNLIMITED 10911
#define IDS_CERT_PKIX_CPS_POINTER_QUALIFIER 10912
#define IDS_CERT_PKIX_USER_NOTICE_QUALIFIER 10913
#define IDS_CERT_REVOCATION_REASON_UNUSED 10914
#define IDS_CERT_REVOCATION_REASON_KEY_COMPROMISE 10915
#define IDS_CERT_REVOCATION_REASON_CA_COMPROMISE 10916
#define IDS_CERT_REVOCATION_REASON_AFFILIATION_CHANGED 10917
#define IDS_CERT_REVOCATION_REASON_SUPERSEDED 10918
#define IDS_CERT_REVOCATION_REASON_CESSATION_OF_OPERATION 10919
#define IDS_CERT_REVOCATION_REASON_CERTIFICATE_HOLD 10920
#define IDS_CERT_OCSP_RESPONDER_FORMAT 10921
#define IDS_CERT_CA_ISSUERS_FORMAT 10922
#define IDS_CERT_UNKNOWN_OID_INFO_FORMAT 10923
#define IDS_CERT_EXT_KEY_USAGE_FORMAT 10924
#define IDS_CERT_MULTILINE_INFO_START_FORMAT 10925
#define IDS_CERT_GENERAL_NAME_RFC822_NAME 10926
#define IDS_CERT_GENERAL_NAME_DNS_NAME 10927
#define IDS_CERT_GENERAL_NAME_X400_ADDRESS 10928
#define IDS_CERT_GENERAL_NAME_DIRECTORY_NAME 10929
#define IDS_CERT_GENERAL_NAME_EDI_PARTY_NAME 10930
#define IDS_CERT_GENERAL_NAME_URI 10931
#define IDS_CERT_GENERAL_NAME_IP_ADDRESS 10932
#define IDS_CERT_GENERAL_NAME_REGISTERED_ID 10933
#define IDS_CERT_EXT_MS_APP_POLICIES 10934
#define IDS_CERT_EXT_MS_CERT_TEMPLATE 10935
#define IDS_CERT_EXT_MS_CERT_TYPE 10936
#define IDS_CERT_EXT_MS_CA_VERSION 10937
#define IDS_CERT_EXT_MS_NT_PRINCIPAL_NAME 10938
#define IDS_CERT_EXT_MS_NTDS_REPLICATION 10939
#define IDS_CERT_EKU_ANY_EKU 10940
#define IDS_CERT_EKU_TLS_WEB_SERVER_AUTHENTICATION 10941
#define IDS_CERT_EKU_TLS_WEB_CLIENT_AUTHENTICATION 10942
#define IDS_CERT_EKU_CODE_SIGNING 10943
#define IDS_CERT_EKU_EMAIL_PROTECTION 10944
#define IDS_CERT_EKU_TIME_STAMPING 10945
#define IDS_CERT_EKU_OCSP_SIGNING 10946
#define IDS_CERT_EKU_MS_INDIVIDUAL_CODE_SIGNING 10947
#define IDS_CERT_EKU_MS_COMMERCIAL_CODE_SIGNING 10948
#define IDS_CERT_EKU_MS_TRUST_LIST_SIGNING 10949
#define IDS_CERT_EKU_MS_TIME_STAMPING 10950
#define IDS_CERT_EKU_MS_SERVER_GATED_CRYPTO 10951
#define IDS_CERT_EKU_MS_ENCRYPTING_FILE_SYSTEM 10952
#define IDS_CERT_EKU_MS_FILE_RECOVERY 10953
#define IDS_CERT_EKU_MS_WINDOWS_HARDWARE_DRIVER_VERIFICATION 10954
#define IDS_CERT_EKU_MS_QUALIFIED_SUBORDINATION 10955
#define IDS_CERT_EKU_MS_KEY_RECOVERY 10956
#define IDS_CERT_EKU_MS_DOCUMENT_SIGNING 10957
#define IDS_CERT_EKU_MS_LIFETIME_SIGNING 10958
#define IDS_CERT_EKU_MS_SMART_CARD_LOGON 10959
#define IDS_CERT_EKU_MS_KEY_RECOVERY_AGENT 10960
#define IDS_CERT_EKU_NETSCAPE_INTERNATIONAL_STEP_UP 10961
#define IDS_CERT_EXTENSION_CRITICAL 10962
#define IDS_CERT_EXTENSION_NON_CRITICAL 10963
#define IDS_CERT_DUMP_ERROR 10964
#define IDS_CERT_EXTENSION_DUMP_ERROR 10965
#define IDS_CERTIFICATE_MANAGER_TITLE 10966
#define IDS_CERT_MANAGER_HARDWARE_BACKED_KEY_FORMAT 10967
#define IDS_CERT_MANAGER_HARDWARE_BACKED 10968
#define IDS_CERT_MANAGER_EXTENSION_PROVIDED_FORMAT 10969
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR 10970
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR_LEARN_MORE 10971
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR_OPT_OUT 10972
#define IDS_DEV_TOOLS_SHARED_PROCESS_INFOBAR_RESTART_NEEDED 10973
#define IDS_DEV_TOOLS_INFOBAR_LABEL 10974
#define IDS_DEV_TOOLS_CONFIRM_ADD_FILE_SYSTEM_MESSAGE 10975
#define IDS_DEV_TOOLS_CONFIRM_ALLOW_BUTTON 10976
#define IDS_DEV_TOOLS_CONFIRM_DENY_BUTTON 10977
#define IDS_RELOAD_MENU_NORMAL_RELOAD_ITEM 415
#define IDS_RELOAD_MENU_HARD_RELOAD_ITEM 416
#define IDS_RELOAD_MENU_EMPTY_AND_HARD_RELOAD_ITEM 417
#define IDS_TAB_SHARING_INFOBAR_SHARING_CURRENT_TAB_LABEL 10978
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_UNTITLED_TAB_LABEL 10979
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_TAB_LABEL 10980
#define IDS_TAB_SHARING_INFOBAR_SHARE_BUTTON 10981
#define IDS_TAB_SHARING_INFOBAR_STOP_BUTTON 10982
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_BUTTON 10983
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURER_BUTTON 10984
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURED_BUTTON 10985
#define IDS_TAB_SHARING_INFOBAR_CAPTURED_SURFACE_CONTROL_PERMISSION_BUTTON 10986
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_LABEL 10987
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_NO_DEVICE_NAME_LABEL 10988
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_LABEL 10989
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_NO_DEVICE_NAME_LABEL 10990
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_LABEL 10991
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_NO_DEVICE_NAME_LABEL 10992
#define IDS_TAB_CASTING_INFOBAR_CAST_BUTTON 10993
#define IDS_TAB_CASTING_INFOBAR_STOP_BUTTON 10994
#define IDS_TASK_MANAGER_KILL 10995
#define IDS_TASK_MANAGER_PROCESS_ID_COLUMN 10996
#define IDS_TASK_MANAGER_GDI_HANDLES_COLUMN 10997
#define IDS_TASK_MANAGER_USER_HANDLES_COLUMN 10998
#define IDS_TASK_MANAGER_TASK_COLUMN 10999
#define IDS_TASK_MANAGER_NACL_DEBUG_STUB_PORT_COLUMN 11000
#define IDS_TASK_MANAGER_NET_COLUMN 11001
#define IDS_TASK_MANAGER_CPU_COLUMN 11002
#define IDS_TASK_MANAGER_START_TIME_COLUMN 11003
#define IDS_TASK_MANAGER_CPU_TIME_COLUMN 11004
#define IDS_TASK_MANAGER_MEM_FOOTPRINT_COLUMN 11005
#define IDS_TASK_MANAGER_SWAPPED_MEM_COLUMN 11006
#define IDS_TASK_MANAGER_PROFILE_NAME_COLUMN 11007
#define IDS_TASK_MANAGER_IDLE_WAKEUPS_COLUMN 11008
#define IDS_TASK_MANAGER_HARD_FAULTS_COLUMN 11009
#define IDS_TASK_MANAGER_OPEN_FD_COUNT_COLUMN 11010
#define IDS_TASK_MANAGER_PROCESS_PRIORITY_COLUMN 11011
#define IDS_TASK_MANAGER_WEBCORE_IMAGE_CACHE_COLUMN 11012
#define IDS_TASK_MANAGER_WEBCORE_SCRIPTS_CACHE_COLUMN 11013
#define IDS_TASK_MANAGER_WEBCORE_CSS_CACHE_COLUMN 11014
#define IDS_TASK_MANAGER_VIDEO_MEMORY_COLUMN 11015
#define IDS_TASK_MANAGER_SQLITE_MEMORY_USED_COLUMN 11016
#define IDS_TASK_MANAGER_JAVASCRIPT_MEMORY_ALLOCATED_COLUMN 11017
#define IDS_TASK_MANAGER_KEEPALIVE_COUNT_COLUMN 11018
#define IDS_TASK_MANAGER_MEM_CELL_TEXT 11019
#define IDS_TASK_MANAGER_CACHE_SIZE_CELL_TEXT 11020
#define IDS_TASK_MANAGER_NA_CELL_TEXT 11021
#define IDS_TASK_MANAGER_BACKGROUNDED_TEXT 11022
#define IDS_TASK_MANAGER_FOREGROUNDED_TEXT 11023
#define IDS_TASK_MANAGER_UNKNOWN_VALUE_TEXT 11024
#define IDS_TASK_MANAGER_DISABLED_NACL_DBG_TEXT 11025
#define IDS_TASK_MANAGER_HANDLES_CELL_TEXT 11026
#define IDS_TASK_MANAGER_WEB_BROWSER_CELL_TEXT 11027
#define IDS_TASK_MANAGER_EXTENSION_PREFIX 11028
#define IDS_TASK_MANAGER_EXTENSION_INCOGNITO_PREFIX 11029
#define IDS_TASK_MANAGER_APP_PREFIX 11030
#define IDS_TASK_MANAGER_APP_INCOGNITO_PREFIX 11031
#define IDS_TASK_MANAGER_TAB_PREFIX 11032
#define IDS_TASK_MANAGER_TAB_INCOGNITO_PREFIX 11033
#define IDS_TASK_MANAGER_BACKGROUND_APP_PREFIX 11034
#define IDS_TASK_MANAGER_BACKGROUND_PREFIX 11035
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_PREFIX 11036
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_PREFIX 11037
#define IDS_TASK_MANAGER_PLUGIN_PREFIX 11038
#define IDS_TASK_MANAGER_PLUGIN_BROKER_PREFIX 11039
#define IDS_TASK_MANAGER_PRELOADED_RENDERER_FOR_UI 11040
#define IDS_TASK_MANAGER_NO_STATE_PREFETCH_PREFIX 11041
#define IDS_TASK_MANAGER_PRERENDER_PREFIX 11042
#define IDS_TASK_MANAGER_SPARE_RENDERER_PREFIX 11043
#define IDS_TASK_MANAGER_UNKNOWN_RENDERER_PREFIX 11044
#define IDS_TASK_MANAGER_DEDICATED_WORKER_PREFIX 11045
#define IDS_TASK_MANAGER_SHARED_WORKER_PREFIX 11046
#define IDS_TASK_MANAGER_SERVICE_WORKER_PREFIX 11047
#define IDS_TASK_MANAGER_UNKNOWN_PLUGIN_NAME 11048
#define IDS_TASK_MANAGER_UTILITY_PREFIX 11049
#define IDS_TASK_MANAGER_NACL_PREFIX 11050
#define IDS_TASK_MANAGER_NACL_BROKER_PREFIX 11051
#define IDS_TASK_MANAGER_GPU_PREFIX 11052
#define IDS_TASK_MANAGER_PRINT_PREFIX 11053
#define IDS_TASK_MANAGER_SUBFRAME_PREFIX 11054
#define IDS_TASK_MANAGER_SUBFRAME_INCOGNITO_PREFIX 11055
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_SUBFRAME_PREFIX 11056
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_SUBFRAME_PREFIX 11057
#define IDS_TASK_MANAGER_PORTAL_PREFIX 11058
#define IDS_TASK_MANAGER_PORTAL_INCOGNITO_PREFIX 11059
#define IDS_TASK_MANAGER_FENCED_FRAME_PREFIX 11060
#define IDS_TASK_MANAGER_FENCED_FRAME_INCOGNITO_PREFIX 11061
#define IDS_TASK_MANAGER_ARC_PREFIX 11062
#define IDS_TASK_MANAGER_TOOL_PREFIX 11063
#define IDS_TASK_MANAGER_ARC_PREFIX_BACKGROUND_SERVICE 11064
#define IDS_TASK_MANAGER_ARC_PREFIX_RECEIVER 11065
#define IDS_TASK_MANAGER_ARC_SYSTEM 11066
#define IDS_TASK_MANAGER_LINUX_VM_PREFIX 11067
#define IDS_TASK_MANAGER_PLUGIN_VM_PREFIX 11068
#define IDS_UTILITY_PROCESS_FILE_UTILITY_NAME 11070
#define IDS_UTILITY_PROCESS_PROFILE_IMPORTER_NAME 11071
#define IDS_UTILITY_PROCESS_QRCODE_GENERATOR_SERVICE_NAME 11072
#define IDS_UTILITY_PROCESS_WIFI_CREDENTIALS_GETTER_NAME 11073
#define IDS_UTILITY_PROCESS_IMAGE_WRITER_NAME 11074
#define IDS_UTILITY_PROCESS_MEDIA_GALLERY_UTILITY_NAME 11075
#define IDS_UTILITY_PROCESS_NOOP_SERVICE_NAME 11076
#define IDS_SERVICE_PROCESS_DOCUMENT_ANALYSIS_NAME 11077
#define IDS_THEME_INSTALL_INFOBAR_LABEL 11078
#define IDS_THEME_INSTALL_INFOBAR_UNDO_BUTTON 11079
#define IDS_CRITICAL_NOTIFICATION_RESTART 11080
#define IDS_EXTENSION_DISABLED_ERROR_LABEL 11081
#define IDS_EXTENSION_IS_BLOCKLISTED 11082
#define IDS_EXTENSION_DISABLED_REMOTE_INSTALL_ERROR_TITLE 11083
#define IDS_EXTENSION_DISABLED_ERROR_TITLE 11084
#define IDS_EXTENSION_SITE_RELOAD_PAGE_BUBBLE_HEADING 11085
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_OK_BUTTON 11086
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_SINGLE_EXTENSION_TITLE 11087
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_MULTIPLE_EXTENSIONS_TITLE 11088
#define IDS_APP_UNINSTALL_PROMPT_TITLE 11089
#define IDS_ARC_APP_UNINSTALL_PROMPT_DATA_REMOVAL_WARNING 11090
#define IDS_EXTENSION_UNINSTALL_PROMPT_TITLE 11091
#define IDS_EXTENSION_CONFIRM_PERMISSIONS 11092
#define IDS_EXTENSION_INSTALL_PROMPT_TITLE 11093
#define IDS_EXTENSION_REQUEST_PROMPT_TITLE 11094
#define IDS_EXTENSION_PENDING_REQUEST_PROMPT_TITLE 11095
#define IDS_EXTENSION_BLOCKED_BY_POLICY_PROMPT_TITLE 11096
#define IDS_EXTENSION_RE_ENABLE_PROMPT_TITLE 11097
#define IDS_EXTENSION_PERMISSIONS_PROMPT_TITLE 11098
#define IDS_EXTENSION_REMOTE_INSTALL_PROMPT_TITLE 11099
#define IDS_EXTENSION_REPAIR_PROMPT_TITLE 11100
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_APP 11101
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_EXTENSION 11102
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_THEME 11103
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 11104
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_APP 11105
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 11106
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ABORT_BUTTON 11107
#define IDS_EXTENSION_ALERT_TITLE 11108
#define IDS_APP_ALERT_TITLE 11109
#define IDS_EXTENSION_AND_APP_ALERT_TITLE 11110
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_TITLE 11111
#define IDS_POLICY_BLOCKED_EXTENSIONS_ALERT_ITEM_TITLE 11112
#define IDS_BLOCKLISTED_EXTENSIONS_ALERT_ITEM 11113
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_ITEM_DETAIL 11114
#define IDS_EXTENSION_ALERT_ITEM_OK 11115
#define IDS_EXTENSION_ALERT_ITEM_DETAILS 11116
#define IDS_EXTENSION_PROMPT_APP_CONNECT_FROM_INCOGNITO 11117
#define IDS_EXTENSION_PROMPT_EXTENSION_CONNECT_FROM_INCOGNITO 11118
#define IDS_EXTENSION_PROMPT_WILL_HAVE_ACCESS_TO 11119
#define IDS_EXTENSION_PROMPT_WILL_NOW_HAVE_ACCESS_TO 11120
#define IDS_EXTENSION_PROMPT_WANTS_ACCESS_TO 11121
#define IDS_EXTENSION_PROMPT_CAN_ACCESS 11122
#define IDS_EXTENSION_PROMPT_GRANT_PERMISSIONS_CHECKBOX 11123
#define IDS_EXTENSION_PROMPT_MESSAGE_FROM_ADMIN 11124
#define IDS_EXTENSION_PERMISSION_LINE 11125
#define IDS_EXTENSION_RATING_COUNT 11126
#define IDS_EXTENSION_PROMPT_RATING_ACCESSIBLE_TEXT 11127
#define IDS_EXTENSION_PROMPT_NO_RATINGS_ACCESSIBLE_TEXT 11128
#define IDS_EXTENSION_USER_COUNT 11129
#define IDS_EXTENSION_PROMPT_STORE_LINK 11130
#define IDS_EXTENSIONS_LOAD_ERROR_ALERT_HEADING 11131
#define IDS_EXTENSIONS_LOAD_ERROR_MESSAGE 11132
#define IDS_EXTENSION_PROMPT_WARNING_FULL_ACCESS 11133
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS 11134
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS_READ_ONLY 11135
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_CAPTURE 11136
#define IDS_EXTENSION_PROMPT_WARNING_VIDEO_CAPTURE 11137
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_AND_VIDEO_CAPTURE 11138
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH 11139
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_DEVICES 11140
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_PRIVATE 11141
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_SERIAL 11142
#define IDS_EXTENSION_PROMPT_WARNING_BOOKMARKS 11143
#define IDS_EXTENSION_PROMPT_WARNING_READING_LIST 11144
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD 11145
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_READWRITE 11146
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_WRITE 11147
#define IDS_EXTENSION_PROMPT_WARNING_DEBUGGER 11148
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_WEB_REQUEST 11149
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_NET_REQUEST 11150
#define IDS_EXTENSION_PROMPT_WARNING_DOCUMENT_SCAN 11151
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_HARDWARE_PLATFORM 11152
#define IDS_EXTENSION_PROMPT_WARNING_FAVICON 11153
#define IDS_EXTENSION_PROMPT_WARNING_GEOLOCATION 11154
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ 11155
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ_ON_ALL_DEVICES 11156
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_WRITE_ON_ALL_DEVICES 11157
#define IDS_EXTENSION_PROMPT_WARNING_HOME_PAGE_SETTING_OVERRIDE 11158
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST 11159
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST_READ_ONLY 11160
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS 11161
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS_READ_ONLY 11162
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS 11163
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS_READ_ONLY 11164
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST 11165
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST_READ_ONLY 11166
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN 11167
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN_LIST 11168
#define IDS_EXTENSION_PROMPT_WARNING_INPUT 11169
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN 11170
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_UI 11171
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_STORAGE 11172
#define IDS_EXTENSION_PROMPT_WARNING_MANAGEMENT 11173
#define IDS_EXTENSION_PROMPT_WARNING_MDNS 11174
#define IDS_EXTENSION_PROMPT_WARNING_NETWORK_STATE 11175
#define IDS_EXTENSION_PROMPT_WARNING_NETWORKING_PRIVATE 11176
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING 11177
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING_METRICS 11178
#define IDS_EXTENSION_PROMPT_WARNING_SEARCH_SETTINGS_OVERRIDE 11179
#define IDS_EXTENSION_PROMPT_WARNING_SERIAL 11180
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_ANY_HOST 11181
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAIN 11182
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAINS 11183
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOST 11184
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOSTS 11185
#define IDS_EXTENSION_PROMPT_WARNING_SPEECH_RECOGNITION 11186
#define IDS_EXTENSION_PROMPT_WARNING_START_PAGE_SETTING_OVERRIDE 11187
#define IDS_EXTENSION_PROMPT_WARNING_SYSTEM_STORAGE 11188
#define IDS_EXTENSION_PROMPT_WARNING_TAB_GROUPS 11189
#define IDS_EXTENSION_PROMPT_WARNING_TOPSITES 11190
#define IDS_EXTENSION_PROMPT_WARNING_TTS_ENGINE 11191
#define IDS_EXTENSION_PROMPT_WARNING_U2F_DEVICES 11192
#define IDS_EXTENSION_PROMPT_WARNING_NOTIFICATIONS 11193
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE 11194
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST 11195
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_PRODUCT 11196
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_VENDOR 11197
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_PRODUCT 11198
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_VENDOR 11199
#define IDS_EXTENSION_PROMPT_WARNING_VPN 11200
#define IDS_EXTENSION_PROMPT_WARNING_CONTENT_SETTINGS 11201
#define IDS_EXTENSION_PROMPT_WARNING_PRIVACY 11202
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS 11203
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS_OPEN 11204
#define IDS_EXTENSION_PROMPT_WARNING_IDENTITY_EMAIL 11205
#define IDS_EXTENSION_PROMPT_WARNING_WALLPAPER 11206
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_DIRECTORY 11207
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_WRITE_DIRECTORY 11208
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ 11209
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE 11210
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_DELETE 11211
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE_DELETE 11212
#define IDS_EXTENSION_PROMPT_WARNING_SYNCFILESYSTEM 11213
#define IDS_EXTENSION_PROMPT_WARNING_NATIVE_MESSAGING 11214
#define IDS_EXTENSION_PROMPT_WARNING_SCREENLOCK_PRIVATE 11215
#define IDS_EXTENSION_PROMPT_WARNING_ACTIVITY_LOG_PRIVATE 11216
#define IDS_EXTENSION_PROMPT_WARNING_DESKTOP_CAPTURE 11217
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_MODIFY 11218
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ 11219
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ_MODIFY 11220
#define IDS_EXTENSION_PROMPT_WARNING_PLATFORMKEYS 11221
#define IDS_EXTENSION_PROMPT_WARNING_CERTIFICATEPROVIDER 11222
#define IDS_EXTENSION_PROMPT_WARNING_SETTINGS_PRIVATE 11223
#define IDS_EXTENSION_PROMPT_WARNING_AUTOFILL_PRIVATE 11224
#define IDS_EXTENSION_PROMPT_WARNING_PASSWORDS_PRIVATE 11225
#define IDS_EXTENSION_PROMPT_WARNING_USERS_PRIVATE 11226
#define IDS_EXTENSION_PROMPT_WARNING_NEW_TAB_PAGE_OVERRIDE 11227
#define IDS_EXTENSION_PROMPT_WARNING_TRANSIENT_BACKGROUND 11228
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_DEVICE_ATTRIBUTES 11229
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_KIOSK_INPUT 11230
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_NETWORKING_ATTRIBUTES 11231
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_PLATFORMKEYS 11232
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE_ENABLED_WIN 11233
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE 11235
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REMOTE_APPS 11236
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_ATTACHED_DEVICE_INFO 11237
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_BLUETOOTH_PERIPHERALS_INFO 11238
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS 11239
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS_NETWORK_INFO_FOR_MLAB 11240
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_EVENTS 11241
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_MANAGEMENT_AUDIO 11242
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY 11243
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_SERIAL_NUMBER 11244
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_NETWORK_INFORMATION 11245
#define IDS_EXTENSION_PROMPT_WARNING_OMNIBOX_DIRECT_INPUT 11246
#define IDS_EXTENSION_CANT_DOWNGRADE_VERSION 11247
#define IDS_APP_CANT_DOWNGRADE_VERSION 11248
#define IDS_EXTENSION_MOVE_DIRECTORY_TO_PROFILE_FAILED 11251
#define IDS_EXTENSION_INSTALL_NOT_ENABLED 11252
#define IDS_EXTENSION_INSTALL_INCORRECT_APP_CONTENT_TYPE 11253
#define IDS_EXTENSION_INSTALL_INCORRECT_INSTALL_HOST 11254
#define IDS_EXTENSION_INSTALL_UNEXPECTED_ID 11255
#define IDS_EXTENSION_INSTALL_DISALLOWED_ON_SITE 11256
#define IDS_EXTENSION_INSTALL_UNEXPECTED_VERSION 11257
#define IDS_EXTENSION_INSTALL_DEPENDENCY_OLD_VERSION 11258
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_SHARED_MODULE 11259
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_ALLOWLISTED 11260
#define IDS_EXTENSION_INSTALL_GALLERY_ONLY 11261
#define IDS_EXTENSION_INSTALL_KIOSK_MODE_ONLY 11262
#define IDS_EXTENSION_OVERLAPPING_WEB_EXTENT 11263
#define IDS_EXTENSION_INVALID_IMAGE_PATH 11264
#define IDS_EXTENSION_ASKS_IDENTITY_WHILE_SIGNED_IN_WEB_ONLY_BODY_PART_2 11266
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO 11268
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO_WITH_SHORTCUT 11269
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO 11270
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO_WITH_SHORTCUT 11271
#define IDS_EXTENSION_INSTALLED_OMNIBOX_KEYWORD_INFO 11272
#define IDS_EXTENSION_INSTALLED_MANAGE_INFO 11273
#define IDS_EXTENSION_INSTALLED_MANAGE_SHORTCUTS 11274
#define IDS_EXTENSION_LAUNCH_WEB_AUTH_FLOW_TAB_INFO_BAR_TEXT 11275
#define IDS_EXTENSION_INSTALLED_DICE_PROMO_SYNC_MESSAGE 11276
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_TITLE 11277
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_READ_ONLY 11278
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_WRITABLE 11279
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_TITLE_LABEL 11280
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_ADDRESS_LABEL 11281
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_PORT_LABEL 11282
#define IDS_EXTENSIONS_WANTS_ACCESS_TO_SITE 11283
#define IDS_EXTENSIONS_HAS_ACCESS_TO_SITE 11284
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON 11285
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_DISMISSED_TEXT 11286
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_SINGLE_EXTENSION 11287
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_MULTIPLE_EXTENSIONS 11288
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_HAS_ACCESS 11289
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_BLOCKED_ACCESS 11290
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_REQUESTS_ACCESS 11291
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_ALLOWED_ACCESS 11292
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_BLOCKED_ACCESS 11293
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_HAS_ACCESS 11294
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_REQUESTS_ACCESS 11295
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_PINNED_TEXT 11296
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_INSTALLED_TEXT 11297
#define IDS_EXTENSIONS_CONTEXT_MENU_SITE_PERMISSIONS 11298
#define IDS_EXTENSIONS_CONTEXT_MENU_CANT_ACCESS_PAGE 11299
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS 11300
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_GRANTED 11301
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_BLOCKED 11302
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK_V2 11303
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE_V2 11304
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES_V2 11305
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_PERMISSIONS_PAGE 11306
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK 11307
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE 11308
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES 11309
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_LEARN_MORE 11310
#define IDS_EXTENSIONS_CONTEXT_MENU_PIN_TO_TOOLBAR 11311
#define IDS_EXTENSIONS_CONTEXT_MENU_UNPIN_FROM_TOOLBAR 11312
#define IDS_EXTENSIONS_OPTIONS_MENU_ITEM 11313
#define IDS_EXTENSIONS_INSTALLED_BY_ADMIN 11314
#define IDS_EXTENSIONS_DISABLE 11315
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR 11316
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR 11317
#define IDS_EXTENSIONS_PINNED_BY_ADMIN 11318
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR_ACCESSIBLE_NAME 11319
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR_ACCESSIBLE_NAME 11320
#define IDS_EXTENSIONS_PINNED_BY_ADMIN_ACCESSIBLE_NAME 11321
#define IDS_EXTENSIONS_SUBMENU_OPEN_SIDE_PANEL_ITEM 11322
#define IDS_EXTENSIONS_SUBMENU_CLOSE_SIDE_PANEL_ITEM 11323
#define IDS_MANAGE_EXTENSION 11324
#define IDS_MANAGE_EXTENSIONS 11325
#define IDS_VIEW_WEB_PERMISSIONS 11326
#define IDS_EXTENSION_ACTION_INSPECT_POPUP 11327
#define IDS_EXTENSIONS_LOCKED_SUPERVISED_USER 11331
#define IDS_EXTENSION_LOAD_FROM_DIRECTORY 11332
#define IDS_EXTENSION_COMMANDS_GENERIC_ACTIVATE 11333
#define IDS_EXTENSIONS_SUPERVISED_USER_PARENTAL_PERMISSION_FAILURE 11334
#define IDS_EXTENSION_PACK_DIALOG_HEADING 11335
#define IDS_EXTENSION_PACK_DIALOG_SELECT_KEY 11336
#define IDS_EXTENSION_PACK_DIALOG_KEY_FILE_TYPE_DESCRIPTION 11337
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_REQUIRED 11338
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_INVALID 11339
#define IDS_EXTENSION_PACK_DIALOG_ERROR_KEY_INVALID 11340
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_NEW 11341
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_UPDATE 11342
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_CONTINUE_BUTTON 11343
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_TITLE 11344
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_WARNING_TEXT 11345
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 11346
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_APP 11347
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 11348
#define IDS_EXTENSION_INSTALL_PROMPT_ASK_A_PARENT_BUTTON 11349
#define IDS_EXTENSION_INSTALL_BLOCKED_BY_PARENT_PROMPT_TITLE 11350
#define IDS_EXTENSION_ENABLE_BLOCKED_BY_PARENT_PROMPT_TITLE 11351
#define IDS_PARENT_PERMISSION_PROMPT_GO_GET_A_PARENT_FOR_EXTENSION_LABEL 11352
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_EXTENSION 11353
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_APP 11354
#define IDS_PARENT_PERMISSION_PROMPT_CHILD_WANTS_TO_INSTALL_LABEL 11355
#define IDS_PARENT_PERMISSION_PROMPT_APPROVE_BUTTON 11356
#define IDS_PARENT_PERMISSION_PROMPT_CANCEL_BUTTON 11357
#define IDS_PARENT_PERMISSION_PROMPT_SELECT_PARENT_LABEL 11358
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_LABEL 11359
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_VERIFY_LABEL 11360
#define IDS_PARENT_PROMPT_ENTER_PASSWORD_TO_ALLOW_EXTENSION_LABEL 11361
#define IDS_SKIP_PARENT_PERMISSION_EXTENSION_INFORMATION 11362
#define IDS_PARENT_PERMISSION_PROMPT_ENTER_PASSWORD_LABEL 11363
#define IDS_PARENT_PERMISSION_PROMPT_PASSWORD_INCORRECT_LABEL 11364
#define IDS_EXTENSION_INSTALL_PROMPT_REQUEST_BUTTON 11365
#define IDS_EXTENSION_PROMPT_UNINSTALL_BUTTON 11366
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE 11367
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE_FROM_EXTENSION 11368
#define IDS_EXTENSION_PROMPT_UNINSTALL_TITLE 11369
#define IDS_EXTENSION_PROMPT_UNINSTALL_APP_BUTTON 11370
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_NAME_BULLET_POINT 11371
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_TITLE 11372
#define IDS_EXTENSION_PROMPT_UNINSTALL_TRIGGERED_BY_EXTENSION 11373
#define IDS_EXTENSION_PROMPT_RE_ENABLE_BUTTON 11374
#define IDS_EXTENSION_PROMPT_PERMISSIONS_BUTTON 11375
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ACCEPT_BUTTON 11376
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ABORT_BUTTON 11377
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_EXTENSION 11378
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_APP 11379
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_EXTENSION 11380
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_APP 11381
#define IDS_EXTENSION_WEB_STORE_TITLE 11382
#define IDS_EXTENSION_WEB_STORE_TITLE_SHORT 478
#define IDS_EXTENSIONS_SHOW_DETAILS 11383
#define IDS_EXTENSIONS_HIDE_DETAILS 11384
#define IDS_WEBSTORE_DOWNLOAD_ACCESS_DENIED 11385
#define IDS_EXTENSION_WARNINGS_WRENCH_MENU_ITEM 11386
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_EXTENSION 11387
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_APP 11388
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_THEME 11389
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_TITLE 11390
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_APP 11391
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_EXTENSION 11392
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_THEME 11393
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE 11394
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE_LEARN_MORE 11395
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_KEEP_DIALOG_TITLE 11396
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_KEEP_DIALOG_OK_BUTTON 11397
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_TITLE 11398
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_PLURAL_TITLE 11399
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_OK_BUTTON 11400
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_DISABLED_DIALOG_CANCEL_BUTTON 11401
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_REENABLE_DIALOG_TITLE 11402
#define IDS_EXTENSIONS_MANIFEST_V2_DEPRECATION_REENABLE_DIALOG_OK_BUTTON 11403
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_CHANGE_IT_BACK 11404
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_KEEP_IT 11405
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_GENERIC 11406
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 11407
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_BODY_GENERIC 11408
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_GENERIC 11409
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 11410
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_OTHER 11411
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_BODY_GENERIC 11412
#define IDS_FORCE_INSTALLED_DEPRECATED_APPS_CONTENT 11413
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_TITLE 11414
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_CONTENT 11415
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_GO_TO_SITE_BUTTON 11416
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_PLURAL 11417
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_WITH_APP_NAME 11418
#define IDS_DEPRECATED_APPS_MONITOR_RENDERER 11419
#define IDS_DEPRECATED_APPS_LEARN_MORE 11420
#define IDS_DEPRECATED_APPS_LEARN_MORE_AX_LABEL 11421
#define IDS_DEPRECATED_APPS_DELETION_LINK 11422
#define IDS_DEPRECATED_APPS_OK_LABEL 11423
#define IDS_DEPRECATED_APPS_CANCEL_LABEL 11424
#define IDS_EXTENSIONS_MENU_TITLE 11425
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP 11426
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP_ACCESSIBLE_NAME 11427
#define IDS_EXTENSIONS_MENU_PIN_BUTTON_TOOLTIP 11428
#define IDS_EXTENSIONS_MENU_UNPIN_BUTTON_TOOLTIP 11429
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA_SHORT 11430
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA 11431
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA_SHORT 11432
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA 11433
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA_SHORT 11434
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA 11435
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_LABEL 11436
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_NOT_ALLOWED_LABEL 11437
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ON_TOOLTIP 11438
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_OFF_TOOLTIP 11439
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ACCESSIBLE_NAME 11440
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_ENTERPRISE_TOOLTIP_ICON_TEXT 11441
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_DESCRIPTION_TEXT 11442
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TEXT 11443
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TOOLTIP 11444
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_TITLE 11445
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TEXT 11446
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TOOLTIP 11447
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TEXT 11448
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TOOLTIP 11449
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ON_TOOLTIP 11450
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_OFF_TOOLTIP 11451
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ACCESSIBLE_NAME 11452
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_TOOLTIP 11453
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_ACCESSIBLE_NAME 11454
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_PINNED_ACCESSIBLE_NAME 11455
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_NONE 11456
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_DISCOVER_EXTENSIONS 11457
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_TOOLTIP 11458
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_ENTERPRISE_EXTENSION_SITE_ACCESS_TOOLTIP 11459
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 11460
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_ENTERPRISE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 11461
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_HAS_ACCESS_TOOLTIP 11462
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_BLOCKED_ACCESS_TOOLTIP 11463
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_BUTTON_REQUESTS_TOOLTIP 11464
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_CLICK 11465
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_SITE 11466
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_ALL_SITES 11467
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON 11468
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON_TOOLTIP 11469
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_LABEL 11470
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_ON 11471
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_OFF 11472
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_LABEL 11473
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_TEXT 11474
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_TEXT 11475
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_TEXT 11476
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_DESCRIPTION 11477
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_DESCRIPTION 11478
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_DESCRIPTION 11479
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_HOME_PAGE_BUBBLE 11480
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE_SPECIFIC 11481
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE 11482
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_SEARCH_ENGINE 11483
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_TITLE 11484
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_HEADING 11485
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_ALLOW 11486
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_DENY 11487
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_BUBBLE_TITLE 11488
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_BUBBLE_HEADING 11489
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_ALLOW 11490
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_DISCOVERY_REQUEST_DENY 11491
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_BUBBLE_TITLE 11492
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_BUBBLE_HEADING 11493
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_ALLOW 11494
#define IDS_EXTENSIONS_DOCUMENT_SCAN_API_START_SCAN_REQUEST_DENY 11495
#define IDS_EXTENSIONS_NTP_CONTROLLED_FIRST_LINE 11496
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE 11497
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE_EXTENSION_SPECIFIC 11498
#define IDS_EXTENSIONS_SETTINGS_API_THIRD_LINE_CONFIRMATION 11499
#define IDS_EXTENSION_CONTROLLED_RESTORE_SETTINGS 11500
#define IDS_EXTENSION_CONTROLLED_KEEP_CHANGES 11501
#define IDS_SUB_APPS_INSTALL_DIALOG_TITLE 11502
#define IDS_SUB_APPS_INSTALL_DIALOG_DESCRIPTION 11503
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_DESCRIPTION 11504
#define IDS_SUB_APPS_INSTALL_DIALOG_MANAGE_PERMISSIONS_LINK 11505
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_BUTTON 11506
#define IDS_SUB_APPS_INSTALL_DIALOG_CANCEL_BUTTON 11507
#define IDS_WEB_APP_MENU_BUTTON_TOOLTIP 11508
#define IDS_WEB_APP_ENABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 11509
#define IDS_WEB_APP_DISABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 11510
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_ENABLED_ALERT 11511
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_DISABLED_ALERT 11512
#define IDS_APP_HOME_TITLE 11513
#define IDS_APP_HOME_OPEN_IN_WINDOW 11514
#define IDS_APP_HOME_LAUNCH_AT_STARTUP 11515
#define IDS_APP_HOME_CREATE_SHORTCUT 11516
#define IDS_APP_HOME_INSTALL_LOCALLY 11517
#define IDS_APP_HOME_UNINSTALL_APP 11518
#define IDS_APP_HOME_REMOVE_APP 11519
#define IDS_APP_HOME_APP_SETTINGS 11520
#define IDS_ACCNAME_APP_HOME_NOT_INSTALLED 11521
#define IDS_APP_HOME_APP_NO_APPS 11522
#define IDS_APP_HOME_APP_LEARN_INSTALL 11523
#define IDS_WEB_APP_SETTINGS_TITLE 11524
#define IDS_WEB_APP_SETTINGS_LINK 11525
#define IDS_WEB_APP_SETTINGS_LINK_TOOLTIP 11526
#define IDS_COMPONENTS_TITLE 11527
#define IDS_COMPONENTS_VERSION 11528
#define IDS_COMPONENTS_NONE_INSTALLED 11529
#define IDS_COMPONENTS_NO_COMPONENTS 11530
#define IDS_COMPONENTS_CHECK_FOR_UPDATE 11531
#define IDS_COMPONENTS_STATUS_LABEL 11532
#define IDS_COMPONENTS_CHECKING_LABEL 11533
#define IDS_COMPONENTS_SVC_STATUS_NEW 11534
#define IDS_COMPONENTS_SVC_STATUS_CHECKING 11535
#define IDS_COMPONENTS_SVC_STATUS_UPDATE 11536
#define IDS_COMPONENTS_SVC_STATUS_DNL_DIFF 11537
#define IDS_COMPONENTS_SVC_STATUS_DNL 11538
#define IDS_COMPONENTS_SVC_STATUS_UPDT_DIFF 11539
#define IDS_COMPONENTS_SVC_STATUS_UPDATING 11540
#define IDS_COMPONENTS_SVC_STATUS_UPDATED 11541
#define IDS_COMPONENTS_SVC_STATUS_UPTODATE 11542
#define IDS_COMPONENTS_SVC_STATUS_UPDATE_ERROR 11543
#define IDS_COMPONENTS_UNKNOWN 11544
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_TITLE 11545
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM 11546
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM_WITHOUT_STRONG 11547
#define IDS_PASSWORD_GENERATION_NUDGE_CANCEL_BUTTON 11548
#define IDS_PASSWORD_MANAGER_CONFIRM_SAVED_TITLE 11549
#define IDS_PASSWORD_MANAGER_CONFIRM_UPDATE_TITLE 11550
#define IDS_PASSWORD_GENERATION_EDITING_SUGGESTION 11551
#define IDS_SAVE_PASSWORD 11552
#define IDS_SAVE_ACCOUNT 11553
#define IDS_ADD_USERNAME_TITLE 11554
#define IDS_ADD_USERNAME 11555
#define IDS_ADD_USERNAME_BODY 11556
#define IDS_UPDATE_PASSWORD 11557
#define IDS_VERIFY_IT_IS_YOU 11558
#define IDS_PASSWORD_ERROR_DESCRIPTION_SIGN_IN 11559
#define IDS_PASSWORD_ERROR_DESCRIPTION_SIGN_UP 11560
#define IDS_PASSWORD_ERROR_VERIFY_BUTTON_TITLE 11566
#define IDS_SAVE_PASSWORD_DIFFERENT_DOMAINS_TITLE 11568
#define IDS_UPDATE_PASSWORD_DIFFERENT_DOMAINS_TITLE 11569
#define IDS_SAVE_PASSWORD_FOOTER 11570
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SYNCED_TO_ACCOUNT 11571
#define IDS_PASSWORD_BUBBLES_FOOTER_SYNCED_TO_ACCOUNT 11572
#define IDS_PASSWORD_BUBBLES_FOOTER_SAVING_ON_DEVICE 11573
#define IDS_PASSWORD_GENERATION_PROMPT_GOOGLE_PASSWORD_MANAGER 11574
#define IDS_PASSWORD_GENERATION_NUDGE_TITLE 11575
#define IDS_PASSWORD_MANAGEMENT_BUBBLE_FOOTER_ACCOUNT_STORE_USERS 11576
#define IDS_PASSWORD_MANAGER_GENERATED_PASSWORD_SAVED_MESSAGE_DESCRIPTION 11577
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 11578
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 11579
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_TITLE 11580
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_DESCRIPTION 11581
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_CONFIRMATION_CONFIRM_BUTTON_LABEL 11582
#define IDS_PASSWORD_CROSS_DOMAIN_FILLING_WARNING_DESCRIPTION 11583
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_SIGN_IN 11584
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_BUTTON 11585
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORD_BUTTON 11586
#define IDS_SETTINGS_PASSWORDS_ANDROID_APP 11587
#define IDS_SHARED_PASSWORDS_NOTIFICATION_GOT_IT_BUTTON 11588
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_SINGLE_PASSWORD 11589
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_MULTIPLE_PASSWORD 11590
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TITLE 11591
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_A 11592
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_B 11593
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_C 11594
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_A 11595
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_B 11596
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SIGNIN_MESSAGE 11597
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SYNC_MESSAGE 11598
#define IDS_WEBRTC_LOGS_TITLE 11599
#define IDS_WEBRTC_TEXT_LOGS_LOG_COUNT_BANNER_FORMAT 11600
#define IDS_WEBRTC_EVENT_LOGS_LOG_COUNT_BANNER_FORMAT 11601
#define IDS_WEBRTC_LOGS_LOG_HEADER_FORMAT 11602
#define IDS_WEBRTC_LOGS_LOG_LOCAL_FILE_LABEL_FORMAT 11603
#define IDS_WEBRTC_LOGS_NO_LOCAL_LOG_FILE_MESSAGE 11604
#define IDS_WEBRTC_LOGS_LOG_UPLOAD_TIME_FORMAT 11605
#define IDS_WEBRTC_LOGS_LOG_FAILED_UPLOAD_TIME_FORMAT 11606
#define IDS_WEBRTC_LOGS_LOG_REPORT_ID_FORMAT 11607
#define IDS_WEBRTC_LOGS_BUG_LINK_LABEL 11608
#define IDS_WEBRTC_LOGS_LOG_PENDING_MESSAGE 11609
#define IDS_WEBRTC_LOGS_LOG_ACTIVELY_UPLOADED_MESSAGE 11610
#define IDS_WEBRTC_LOGS_LOG_NOT_UPLOADED_MESSAGE 11611
#define IDS_WEBRTC_LOGS_EVENT_LOG_LOCAL_LOG_ID 11612
#define IDS_WEBRTC_LOGS_NO_TEXT_LOGS_MESSAGE 11613
#define IDS_WEBRTC_LOGS_NO_EVENT_LOGS_MESSAGE 11614
#define IDS_PLUGIN_HIDE 11615
#define IDS_PLUGIN_BLOCKED 11616
#define IDS_PLUGIN_BLOCKED_BY_POLICY 11617
#define IDS_PLUGIN_NOT_AUTHORIZED 11619
#define IDS_PLUGIN_DISABLED 11620
#define IDS_PLUGIN_DEPRECATED 11621
#define IDS_SESSION_CRASHED_BUBBLE_TITLE 11622
#define IDS_SESSION_CRASHED_BUBBLE_UMA_LINK_TEXT 11623
#define IDS_IDLE_BUBBLE_TITLE_CLEAR 11624
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_TITLE 11625
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_MESSAGE 11626
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_BUTTON_LABEL 11627
#define IDS_BAD_FLAGS_WARNING_MESSAGE 11628
#define IDS_BAD_FEATURES_WARNING_MESSAGE 11629
#define IDS_BAD_ENVIRONMENT_VARIABLES_WARNING_MESSAGE 11630
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT_TITLE 11631
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT 11632
#define IDS_ALLOW_INSECURE_CONTENT_BUTTON 11633
#define IDS_ADD_TO_SHELF_INFOBAR_TITLE 11634
#define IDS_ADD_TO_SHELF_INFOBAR_ADD_BUTTON 11635
#define IDS_ABOUT_SYS_TITLE 11636
#define IDS_ABOUT_SYS_DESC 11637
#define IDS_ABOUT_SYS_TABLE_TITLE 11638
#define IDS_ABOUT_SYS_LOG_FILE_TABLE_TITLE 11639
#define IDS_ABOUT_SYS_EXPAND_ALL 11640
#define IDS_ABOUT_SYS_COLLAPSE_ALL 11641
#define IDS_ABOUT_SYS_EXPAND 11642
#define IDS_ABOUT_SYS_COLLAPSE 11643
#define IDS_ABOUT_SYS_PARSE_ERROR 11644
#define IDS_ABOUT_BROWSER_SWITCH_TITLE 11645
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_UNKNOWN_BROWSER 11646
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_KNOWN_BROWSER 11647
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_UNKNOWN_BROWSER 11648
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_KNOWN_BROWSER 11649
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_UNKNOWN_BROWSER 11650
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_KNOWN_BROWSER 11651
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_UNKNOWN_BROWSER 11652
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_KNOWN_BROWSER 11653
#define IDS_ABOUT_BROWSER_SWITCH_PROTOCOL_ERROR 11654
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_DESC 11655
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_TITLE 11656
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_NOTHING_SHOWN 11657
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_LBS_DISABLED 11658
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_TITLE 11659
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_DESC 11660
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER 11661
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_PROTOCOL_REASON 11662
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_RULE_REASON 11663
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_INVERT_RULE_REASON 11664
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_DEFAULT_REASON 11665
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_INVALID_URL 11666
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_TITLE 11667
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_DESC 11668
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SOURCE 11669
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_NOT_CONFIGURED 11670
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NOT_FETCHED 11671
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_DOWNLOAD_BUTTON 11672
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_LAST_DOWNLOAD_DATE 11673
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NEXT_DOWNLOAD_DATE 11674
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_TITLE 11675
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_DESCRIPTION 11676
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_FIRST_PARAGRAPH 11677
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_SECOND_PARAGRAPH 11678
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_RULE 11679
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_OPENS_IN 11680
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_SOURCE 11681
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TITLE 11682
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_DESCRIPTION 11683
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_FIRST_PARAGRAPH 11684
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_SECOND_PARAGRAPH 11685
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_RULE 11686
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_SOURCE 11687
#define IDS_NACL_APP_MISSING_ARCH_MESSAGE 11688
#define IDS_ABOUT_BOX_ERROR_DURING_UPDATE_CHECK 11689
#define IDS_ABOUT_BOX_GOOGLE_UPDATE_ERROR 11690
#define IDS_ABOUT_BOX_ERROR_UPDATE_CHECK_FAILED 11691
#define IDS_ABOUT_BOX_EXTERNAL_UPDATE_IS_RUNNING 11692
#define IDS_OMNIBOX_PLACEHOLDER_TEXT 440
#define IDS_PASTE_AND_GO 11693
#define IDS_PASTE_AND_SEARCH 11694
#define IDS_PASTE_AND_GO_EMPTY 11695
#define IDS_OMNIBOX_KEYWORD_TEXT 11696
#define IDS_OMNIBOX_KEYWORD_TEXT_MD 11697
#define IDS_OMNIBOX_CLEAR_ALL 470
#define IDS_OMNIBOX_WHY_THIS_SUGGESTION 11698
#define IDS_OMNIBOX_CLOSE_IPH_SUGGESTION 11699
#define IDS_OMNIBOX_THUMBS_UP_SUGGESTION 11700
#define IDS_OMNIBOX_THUMBS_DOWN_SUGGESTION 11701
#define IDS_OMNIBOX_REMOVE_SUGGESTION 668
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_TITLE 11702
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_DESCRIPTION 11703
#define IDS_CONTEXT_MENU_SHOW_FULL_URLS 11704
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MD 671
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_SHORT 11705
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MULTIMODAL 11706
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_CONTEXTUAL 11707
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_CONTEXTUAL_PDF 11708
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_PRIMARY 11709
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_PRIMARY_PDF 11710
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_LOADING_HINT_SECONDARY 11711
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_ERROR_TEXT 11712
#define IDS_GOOGLE_SEARCH_BOX_CONTEXTUAL_NO_SUGGEST_TEXT 11713
#define IDS_GOOGLE_SEARCH_BOX_MULTIMODAL_IMAGE_THUMBNAIL 11714
#define IDS_GOOGLE_LENS_SEARCH_BOX_EMPTY_HINT 11715
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TOOLTIP 11716
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TITLE 487
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT_TOOLTIP 11717
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT 488
#define IDS_NTP_CUSTOM_LINKS_MORE_ACTIONS 11718
#define IDS_UPLOAD_IMAGE_FORMAT 11719
#define IDS_NTP_CUSTOM_LINKS_NAME 499
#define IDS_NTP_CUSTOM_LINKS_URL 503
#define IDS_NTP_CUSTOM_LINKS_REMOVE 496
#define IDS_NTP_CUSTOM_LINKS_CANCEL 491
#define IDS_NTP_CUSTOM_LINKS_DONE 494
#define IDS_NTP_CUSTOM_LINKS_INVALID_URL 489
#define IDS_NTP_CUSTOM_LINKS_CANT_CREATE 492
#define IDS_NTP_CUSTOM_LINKS_CANT_EDIT 493
#define IDS_NTP_CUSTOM_LINKS_CANT_REMOVE 11720
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_REMOVED 497
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_EDITED 495
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_ADDED 490
#define IDS_NTP_CUSTOM_LINKS_ALREADY_EXISTS 502
#define IDS_NTP_CONFIRM_MSG_RESTORE_DEFAULTS 500
#define IDS_NTP_CUSTOM_BG_CHROME_WALLPAPERS 11721
#define IDS_NTP_CUSTOM_BG_UPLOAD_AN_IMAGE 11722
#define IDS_NTP_CUSTOM_BG_SELECT_A_COLLECTION 11723
#define IDS_NTP_CUSTOM_BG_DAILY_REFRESH 518
#define IDS_NTP_CUSTOM_BG_RESTORE_DEFAULT 11724
#define IDS_NTP_CUSTOM_BG_CANCEL 11725
#define IDS_NTP_CONNECTION_ERROR_NO_PERIOD 11726
#define IDS_NTP_CONNECTION_ERROR 11727
#define IDS_NTP_ERROR_MORE_INFO 11728
#define IDS_NTP_CUSTOM_BG_BACKGROUNDS_UNAVAILABLE 11729
#define IDS_NTP_CUSTOM_BG_BACK_LABEL 11730
#define IDS_NTP_CUSTOM_BG_IMAGE_SELECTED 11731
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_LABEL 509
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_WALLPAPER_SEARCH_LABEL 11732
#define IDS_NTP_DISMISS_PROMO 11733
#define IDS_NTP_DOODLE_SHARE_LABEL 566
#define IDS_NTP_DOODLE_SHARE_DIALOG_CLOSE_LABEL 11734
#define IDS_NTP_DOODLE_SHARE_DIALOG_FACEBOOK_LABEL 565
#define IDS_NTP_DOODLE_SHARE_DIALOG_TWITTER_LABEL 567
#define IDS_NTP_DOODLE_SHARE_DIALOG_MAIL_LABEL 564
#define IDS_NTP_DOODLE_SHARE_DIALOG_COPY_LABEL 562
#define IDS_NTP_DOODLE_SHARE_DIALOG_LINK_LABEL 563
#define IDS_NTP_CUSTOMIZE_APPEARANCE_LABEL 11735
#define IDS_NTP_CUSTOMIZE_THEMES_HEADER 11736
#define IDS_NTP_CUSTOMIZE_MENU_SHORTCUTS_LABEL 520
#define IDS_NTP_CUSTOMIZE_MENU_TOOLBAR_LABEL 11737
#define IDS_NTP_CUSTOMIZE_MENU_EXTENSIONS_LABEL 11738
#define IDS_NTP_CUSTOMIZE_MENU_MODULES_LABEL 521
#define IDS_NTP_CUSTOMIZE_NO_BACKGROUND_LABEL 517
#define IDS_NTP_CUSTOMIZE_CHROME_CHANGE_THEME_LABEL 11739
#define IDS_NTP_CUSTOMIZE_CHROME_MANAGED_NEW_TAB_PAGE 11740
#define IDS_NTP_CUSTOMIZE_CHROME_MANAGED_NEW_TAB_PAGE_ACCESSIBILITY 11741
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_CLASSIC_CHROME_LABEL 11742
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_CLASSIC_CHROME_COMPLETE 11743
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_UPLOADED_IMAGE_COMPLETE 11744
#define IDS_NTP_CUSTOMIZE_CHROME_FOLLOW_THEME_LABEL 11745
#define IDS_NTP_CUSTOMIZE_UPLOADED_IMAGE_LABEL 11746
#define IDS_NTP_CUSTOMIZE_YOUR_UPLOADED_IMAGE_LABEL 11747
#define IDS_NTP_CUSTOMIZE_YOUR_SEARCHED_IMAGE_LABEL 11748
#define IDS_NTP_CUSTOMIZE_CHROME_CURRENT_THEME_LABEL 11749
#define IDS_NTP_CUSTOMIZE_SHOW_CARDS_LABEL 11750
#define IDS_NTP_CUSTOMIZE_SHOW_SHORTCUTS_LABEL 11751
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_LABEL 516
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_LABEL 515
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_DESC 522
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_DESC 519
#define IDS_NTP_CUSTOMIZE_COLOR_PICKER_LABEL 506
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_TITLE 11752
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_ARIA_LABEL 11753
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_DELETE_TITLE 11754
#define IDS_NTP_CUSTOMIZE_COLOR_HUE_SLIDER_DELETE_A11Y_LABEL 11755
#define IDS_NTP_THEME_MANAGED_DIALOG_TITLE 569
#define IDS_NTP_THEME_MANAGED_DIALOG_BODY 570
#define IDS_NTP_THEMES_CONTAINER_LABEL 523
#define IDS_NTP_CUSTOMIZE_DEFAULT_LABEL 510
#define IDS_NTP_CUSTOMIZE_GREY_DEFAULT_LABEL 11756
#define IDS_NTP_COLORS_WARM_GREY 11757
#define IDS_NTP_COLORS_COOL_GREY 11758
#define IDS_NTP_COLORS_MIDNIGHT_BLUE 11759
#define IDS_NTP_COLORS_BLACK 11760
#define IDS_NTP_COLORS_BEIGE_AND_WHITE 11761
#define IDS_NTP_COLORS_YELLOW_AND_WHITE 11762
#define IDS_NTP_COLORS_GREEN_AND_WHITE 11763
#define IDS_NTP_COLORS_LIGHT_TEAL_AND_WHITE 11764
#define IDS_NTP_COLORS_LIGHT_PURPLE_AND_WHITE 11765
#define IDS_NTP_COLORS_PINK_AND_WHITE 11766
#define IDS_NTP_COLORS_BEIGE 11767
#define IDS_NTP_COLORS_ORANGE 11768
#define IDS_NTP_COLORS_LIGHT_GREEN 11769
#define IDS_NTP_COLORS_LIGHT_TEAL 11770
#define IDS_NTP_COLORS_LIGHT_BLUE 11771
#define IDS_NTP_COLORS_PINK 11772
#define IDS_NTP_COLORS_DARK_PINK_AND_RED 11773
#define IDS_NTP_COLORS_DARK_RED_AND_ORANGE 11774
#define IDS_NTP_COLORS_DARK_GREEN 11775
#define IDS_NTP_COLORS_DARK_TEAL 11776
#define IDS_NTP_COLORS_DARK_BLUE 11777
#define IDS_NTP_COLORS_DARK_PURPLE 11778
#define IDS_NTP_COLORS_BLUE 11779
#define IDS_NTP_COLORS_GREY 11780
#define IDS_NTP_COLORS_AQUA 11781
#define IDS_NTP_COLORS_GREEN 11782
#define IDS_NTP_COLORS_VIRIDIAN 11783
#define IDS_NTP_COLORS_CITRON 11784
#define IDS_NTP_COLORS_APRICOT 11785
#define IDS_NTP_COLORS_ROSE 11786
#define IDS_NTP_COLORS_FUCHSIA 11787
#define IDS_NTP_COLORS_VIOLET 11788
#define IDS_NTP_UNDO_DISMISS_PROMO_BUTTON_TOAST 660
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_GROUP_LABEL 11789
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_LIGHT_LABEL 11790
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_DARK_LABEL 11791
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_SYSTEM_LABEL 11792
#define IDS_NTP_CUSTOMIZE_CHROME_WEBSTORE_LABEL 11793
#define IDS_NTP_WEBSTORE_SHOPPING_CATEOGRY_LABEL 11794
#define IDS_NTP_WEBSTORE_WRITTING_HELP_COLLECTION_LABEL 11795
#define IDS_NTP_WEBSTORE_PRODUCTIVITY_CATEOGRY_LABEL 11796
#define IDS_NTP_WEBSTORE_TOAST_MESSAGE 11797
#define IDS_NTP_WEBSTORE_TOAST_BUTTON_TEXT 11798
#define IDS_NTP_WALLPAPER_SEARCH_FEEDBACK_PLACEHOLDER 11799
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION 11800
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_HISTORY 11801
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_INSPIRATION 11802
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_DESCRIPTION_WITH_HISTORY_AND_INSPIRATION 11803
#define IDS_NTP_WALLPAPER_SEARCH_GENERIC_ERROR_TITLE 11804
#define IDS_NTP_WALLPAPER_SEARCH_TILE_LABEL 11805
#define IDS_NTP_WALLPAPER_SEARCH_PAGE_HEADER 11806
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_HEADER 11807
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_DESCRIPTION 11808
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_DESCRIPTION_WITH_HISTORY 11809
#define IDS_NTP_WALLPAPER_SEARCH_OFFLINE_TITLE 11810
#define IDS_NTP_WALLPAPER_SEARCH_OPTIONAL_DETAILS_LABEL 11811
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_RED_LABEL 11812
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_BLUE_LABEL 11813
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_YELLOW_LABEL 11814
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_GREEN_LABEL 11815
#define IDS_NTP_WALLPAPER_SEARCH_COLOR_BLACK_LABEL 11816
#define IDS_NTP_WALLPAPER_SEARCH_REQUEST_THROTTLED_DESCRIPTION 11817
#define IDS_NTP_WALLPAPER_SEARCH_REQUEST_THROTTLED_TITLE 11818
#define IDS_NTP_WALLPAPER_SEARCH_SUBMIT_BTN_TEXT 11819
#define IDS_NTP_WALLPAPER_SEARCH_TRY_AGAIN_CTA 11820
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_NO_DESCRIPTOR 11821
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL 11822
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTOR_B 11823
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTOR_C 11824
#define IDS_NTP_WALLPAPER_SEARCH_HISTORY_RESULT_LABEL_WITH_DESCRIPTORS_B_AND_C 11825
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL 11826
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTOR_B 11827
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTOR_C 11828
#define IDS_NTP_WALLPAPER_SEARCH_RESULT_LABEL_WITH_DESCRIPTORS_B_AND_C 11829
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LABEL 11830
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_DEFAULT_OPTION_LABEL 11831
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_LABEL 11832
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DEFAULT_OPTION_LABEL 11833
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_LABEL 11834
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_DEFAULT_OPTION_LABEL 11835
#define IDS_LEARN_MORE_ABOUT_FEATURE_A11Y_LABEL 11836
#define IDS_THUMBS_DOWN_OPENS_FEEDBACK_FORM_A11Y_LABEL 11837
#define IDS_THUMBS_UP_RESULTS_A11Y_LABEL 11838
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_HEADER 11839
#define IDS_NTP_WALLPAPER_SEARCH_LOADING_A11Y_MESSAGE 11840
#define IDS_NTP_WALLPAPER_SEARCH_SUCCESS_A11Y_MESSAGE 11841
#define IDS_NTP_WALLPAPER_SEARCH_DISCLAIMER 11842
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_CARD_TOGGLE_TITLE 11843
#define IDS_NTP_WALLPAPER_SEARCH_DESCRIPTORS_CHANGED_A11Y_MESSAGE 11844
#define IDS_NTP_WALLPAPER_SEARCH_SIGNED_OUT_DESCRIPTION 11845
#define IDS_NTP_WALLPAPER_SEARCH_SIGNED_OUT_TITLE 11846
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_DESSERTS 11847
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_INTERIORS 11848
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_LANDSCAPE 11849
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_NATURE 11850
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_OUTER_SPACE 11851
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_PLACES 11852
#define IDS_NTP_WALLPAPER_SEARCH_CATEGORY_STRUCTURES 11853
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CAKE_POPS 11854
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CHEESECAKE 11855
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_FRUIT_TART 11856
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ICE_CREAM 11857
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MACARON 11858
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PANNA_COTTA 11859
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CHEMISTRY_LAB 11860
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HALLWAY 11861
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_KITCHEN 11862
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LIVING_ROOM 11863
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_READING_NOOK 11864
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_DESERT 11865
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_FOREST 11866
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HIGHLANDS 11867
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MEADOW 11868
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MOUNTAIN 11869
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_OCEAN 11870
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RAINFOREST 11871
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RICE_PADDY 11872
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SALT_FLAT 11873
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SHORELINE 11874
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_TUNDRA 11875
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_WATERFALL 11876
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_AURORA_BOREALIS 11877
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CLIFF 11878
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CRASHING_WAVES 11879
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CREEK 11880
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ECLIPSES 11881
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_FLOWERS 11882
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LIGHTNING 11883
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_NIGHT_SKY 11884
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PALM_TREE 11885
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RAINBOW 11886
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_RIVER 11887
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SLOT_CANYON 11888
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SUNSET 11889
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ASTEROID 11890
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_COMET 11891
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_MOON 11892
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_NEBULA 11893
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PLANET 11894
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_SPACE_STATION 11895
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_STARS 11896
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CHICHEN_ITZA 11897
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_GRAND_CANYON 11898
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_GRAND_TETON_NATIONAL_PARK 11899
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_GREAT_PYRAMID_OF_GIZA 11900
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ROCKY_MOUNTAINS_NATIONAL_PARK 11901
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_THE_COLOSSEUM 11902
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_ZION_NATIONAL_PARK 11903
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_BRICK_BUILDING 11904
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_CASTLE 11905
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HIGHWAY 11906
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_HOUSE 11907
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_LIGHTHOUSE 11908
#define IDS_NTP_WALLPAPER_SEARCH_SUBJECT_PIER 11909
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_ANIMATED 11910
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_COLORED_PENCIL 11911
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_CYBERPUNK 11912
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_DREAM 11913
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_EXPRESSIONISM 11914
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_FANTASY 11915
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_IMPRESSIONISM 11916
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_OIL_PAINTING 11917
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_ORGANIC 11918
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_PHOTOGRAPHY 11919
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_SPLATTER 11920
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_STEAMPUNK 11921
#define IDS_NTP_WALLPAPER_SEARCH_STYLE_WATERCOLOR 11922
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_CHAOTIC 11923
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_CREATIVE 11924
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DARK 11925
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_DREAMY 11926
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_EXCITED 11927
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_HAPPY 11928
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_INTELLECTUAL 11929
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_ORDERLY 11930
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_ROMANTIC 11931
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SERENE 11932
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SNOWY 11933
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SUBDUED 11934
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_SUNNY 11935
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_THOUGHTFUL 11936
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_WHIMSICAL 11937
#define IDS_NTP_WALLPAPER_SEARCH_MOOD_WILD 11938
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_1 11939
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_2 11940
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_3 11941
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_4 11942
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_5 11943
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_6 11944
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_7 11945
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_8 11946
#define IDS_NTP_WALLPAPER_SEARCH_INSPIRATION_DESCRIPTION_9 11947
#define IDS_NTP_WALLPAPER_SEARCH_SEPARATOR 11948
#define IDS_NTP_CUSTOMIZE_TOOLBAR_BUTTON_A11Y_LABEL 11949
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CHOOSE_ICONS_LABEL 11950
#define IDS_NTP_CUSTOMIZE_TOOLBAR_REORDER_TIP_LABEL 11951
#define IDS_NTP_CUSTOMIZE_TOOLBAR_RESET_TO_DEFAULT_ANNOUNCEMENT 11952
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_NAVIGATION 11953
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_YOUR_CHROME 11954
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_SIDE_PANELS 11955
#define IDS_NTP_CUSTOMIZE_TOOLBAR_CATEGORY_TOOLS_AND_ACTIONS 11956
#define IDS_NTP_CUSTOMIZE_TOOLBAR_RESET_TO_DEFAULT_BUTTON_LABEL 11957
#define IDS_NTP_MODULES_INFO_BUTTON_TITLE 574
#define IDS_NTP_MODULES_DISMISS_TOAST_MESSAGE 572
#define IDS_NTP_MODULES_DISABLE_TOAST_MESSAGE 573
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_MESSAGE 11958
#define IDS_NTP_MODULES_DISMISS_BUTTON_TEXT 575
#define IDS_NTP_MODULES_DRIVE_MORE_ACTIONS_BUTTON_TEXT 11959
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT 576
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT_V2 11960
#define IDS_NTP_MODULES_MORE_ACTIONS 11961
#define IDS_NTP_MODULE_HEADER_MORE_ACTIONS_MENU 11962
#define IDS_NTP_MODULES_CUSTOMIZE_BUTTON_TEXT 577
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_TODAY 11963
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_YESTERDAY 11964
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_WEEK 11965
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_MONTH 11966
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PREVIOUSLY 11967
#define IDS_NTP_MODULES_SHOPPING_TASKS_SENTENCE 11968
#define IDS_NTP_MODULES_SHOPPING_TASKS_LOWER 11969
#define IDS_NTP_MODULES_DRIVE_DISABLE_BUTTON_TEXT 11970
#define IDS_NTP_MODULES_DRIVE_DISABLE_BUTTON_TEXT_V2 11971
#define IDS_NTP_MODULES_DRIVE_NAME 11972
#define IDS_NTP_MODULES_FILES_SENTENCE 11973
#define IDS_NTP_MODULES_DUMMY_LOWER 597
#define IDS_NTP_MODULES_DUMMY_TITLE 600
#define IDS_NTP_MODULES_DRIVE_INFO 599
#define IDS_NTP_MODULES_MICROSOFT_FILES_NAME 11974
#define IDS_NTP_MODULES_MICROSOFT_FILES_INFO 11975
#define IDS_NTP_MODULES_MICROSOFT_FILES_DISABLE_BUTTON_TEXT 11976
#define IDS_NTP_MODULES_MICROSOFT_FILES_TRENDING_JUSTIFICATION_TEXT 11977
#define IDS_NTP_MODULES_DISMISS_FOR_HOURS_BUTTON_TEXT 11978
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISMISS_TOAST_MESSAGE 11979
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISABLE_TOAST_MESSAGE 11980
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_INFO 11981
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_MORE_ACTIONS 11982
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_TITLE 11983
#define IDS_NTP_MODULES_GOOGLE_CALENDAR_DISABLE_BUTTON_TEXT 11984
#define IDS_NTP_MODULES_MICROSOFT_SIGN_OUT_BUTTON_TEXT 11985
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_TITLE 11986
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_DISABLE_BUTTON_TEXT 11987
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_DISMISS_TOAST_MESSAGE 11988
#define IDS_NTP_MODULES_OUTLOOK_CALENDAR_INFO 11989
#define IDS_NTP_MODULES_CALENDAR_DOUBLE_BOOKED 11990
#define IDS_NTP_MODULES_CALENDAR_JOIN_MEETING_BUTTON_TEXT 11991
#define IDS_NTP_MODULES_CALENDAR_IN_PROGRESS 11992
#define IDS_NTP_MODULES_CALENDAR_IN_X_MIN 11993
#define IDS_NTP_MODULES_CALENDAR_IN_X_HR 11994
#define IDS_NTP_MODULES_CALENDAR_SEE_MORE 11995
#define IDS_NTP_MODULES_KALEIDOSCOPE_TITLE 603
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_TITLE 621
#define IDS_NTP_MODULES_TASKS_INFO 586
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_CLOSE 622
#define IDS_NTP_MODULES_SHOPPING_TASKS_RELATED 11996
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_AMOUNT 629
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_UP_TO_AMOUNT 630
#define IDS_NTP_MODULES_CUSTOMIZE_IPH 11997
#define IDS_NTP_MODULES_FEED_TITLE 602
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING 11998
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING_FOR 11999
#define IDS_NTP_MODULES_SHOW_ALL 648
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_BOOKMARKED 654
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_INFO 649
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_WITH_DISCOUNT_INFO 12000
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SENTENCE2 650
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_NAME 12001
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISMISS_BUTTON 12002
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_DROPDOWN_TEXT 12003
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DONE_BUTTON 12004
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_OPEN_ALL_IN_NEW_TAB_GROUP_BUTTON_TEXT 655
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SHOW_ALL_BUTTON 12005
#define IDS_ACCNAME_SHOW_ALL 652
#define IDS_ACCNAME_SEARCH_SUGG 653
#define IDS_NTP_MODULES_TAB_RESUMPTION_DISMISS_BUTTON 12006
#define IDS_NTP_TAB_RESUMPTION_TITLE 12007
#define IDS_NTP_MODULES_TAB_RESUMPTION_INFO 12008
#define IDS_NTP_MODULES_TAB_RESUMPTION_MULTI_DISMISS 12009
#define IDS_NTP_MODULES_TAB_RESUMPTION_SINGLE_DISMISS 12010
#define IDS_NTP_MODULES_TAB_RESUMPTION_RECENTLY_OPENED 12011
#define IDS_NTP_MODULES_TAB_RESUMPTION_DEVICE_PREFIX 12012
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_DISMISS_BUTTON 12013
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_TITLE 12014
#define IDS_NTP_MODULES_MOST_RELEVANT_TAB_RESUMPTION_SEE_MORE 12015
#define IDS_NTP_MODULES_MICROSOFT_AUTHENTICATION_NAME 12016
#define IDS_NTP_MICROSOFT_AUTHENTICATION_DISABLE_BUTTON_TEXT 12017
#define IDS_NTP_MICROSOFT_AUTHENTICATION_DISMISS_BUTTON_TEXT 12018
#define IDS_NTP_MICROSOFT_AUTHENTICATION_HEADING 12019
#define IDS_NTP_MICROSOFT_AUTHENTICATION_SUBHEADING 12020
#define IDS_NTP_MICROSOFT_AUTHENTICATION_SIGN_IN_BUTTON_TEXT 12021
#define IDS_NTP_MICROSOFT_AUTHENTICATION_SIDE_PANEL_DESCRIPTION 12022
#define IDS_NTP_MOBILE_PROMO_HEADER 12023
#define IDS_NTP_MOBILE_PROMO_DESCRIPTION 12024
#define IDS_NTP_MOBILE_PROMO_QR_CODE_LABEL 12025
#define IDS_EXTENSIONS_PROMO_PERFORMANCE 12026
#define IDS_EXTENSIONS_PROMO_PRIVACY 12027
#define IDS_EXTENSIONS_PROMO_NEUTRAL 12028
#define IDS_STAR_VIEW_MENU_ADD_BOOKMARK 12029
#define IDS_STAR_VIEW_MENU_EDIT_BOOKMARK 12030
#define IDS_STAR_VIEW_MENU_MOVE_TO_READ_LATER 12031
#define IDS_STAR_VIEW_MENU_MARK_AS_READ 12032
#define IDS_READ_LATER_TITLE 395
#define IDS_READ_LATER_MENU_UNREAD_HEADER 12033
#define IDS_READ_LATER_MENU_READ_HEADER 12034
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_READ 12035
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_UNREAD 12036
#define IDS_READ_LATER_MENU_EMPTY_STATE_ADD_FROM_DIALOG_SUBHEADER 12037
#define IDS_READ_LATER_MENU_EMPTY_STATE_HEADER 12038
#define IDS_READ_LATER_MENU_EMPTY_STATE_SUBHEADER 12039
#define IDS_READ_LATER_ADD_CURRENT_TAB 12040
#define IDS_READ_LATER_CANT_ADD_CURRENT_TAB 12041
#define IDS_READ_LATER_MARK_CURRENT_TAB_READ 12042
#define IDS_READ_LATER_REMOVE_CURRENT_TAB 12043
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_UNREAD 12044
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_READ 12045
#define IDS_READ_LATER_CONTEXT_MENU_DELETE 12046
#define IDS_READING_LIST_MENU 12047
#define IDS_READING_LIST_MENU_ADD_TAB 12048
#define IDS_READING_LIST_MENU_SHOW_UI 12049
#define IDS_ACCNAME_SIDE_PANEL_RESIZE 12050
#define IDS_ACCNAME_SIDE_PANEL_CLOSE 12051
#define IDS_SIDE_PANEL_RESIZE_ACCESSIBLE_ALERT 12052
#define IDS_SIDE_PANEL_RESIZE_LEFT_SIDE_ACCESSIBLE_ALERT 12053
#define IDS_SIDE_PANEL_RESIZE_RIGHT_SIDE_ACCESSIBLE_ALERT 12054
#define IDS_ACCNAME_SIDE_PANEL_SELECTOR 12055
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_SHOW 12056
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_HIDE 12057
#define IDS_SIDE_PANEL_COMPANION_TITLE 12058
#define IDS_SIDE_PANEL_COMPANION_TOOLBAR_TOOLTIP 12059
#define IDS_SIDE_PANEL_COMPANION_PROMO 12060
#define IDS_SIDE_PANEL_COMPANION_PROMO_PINNING 12061
#define IDS_SIDE_PANEL_COMPANION_PROMO_SCREEN_READER 12062
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_FIRST_LINE 12063
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_SECOND_LINE 12064
#define IDS_SHOW_CUSTOMIZE_CHROME_SIDE_PANEL 12065
#define IDS_SHOW_CUSTOMIZE_CHROME_TOOLBAR 12066
#define IDS_SIDE_PANEL_CUSTOMIZE_CHROME_TITLE 672
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_UNPIN 12067
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_PIN 12068
#define IDS_SIDE_PANEL_HEADER_UNPIN_BUTTON_TOOLTIP 12069
#define IDS_SIDE_PANEL_HEADER_PIN_BUTTON_TOOLTIP 12070
#define IDS_SIDE_PANEL_UNPINNED 12071
#define IDS_SIDE_PANEL_PINNED 12072
#define IDS_PINNED_ACTION_BUTTON_ACCESSIBLE_TITLE 12073
#define IDS_SIDE_PANEL_GENERIC_PINNABLE_IPH 12074
#define IDS_SIDE_PANEL_GENERIC_PINNABLE_IPH_SCREENREADER 12075
#define IDS_SIDE_PANEL_HEADER_MORE_INFO_BUTTON_TOOLTIP 12076
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_TITLE 12077
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_SUBTITLE 12078
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_FOLDER_SUBTITLE 12079
#define IDS_BOOKMARKS_MOVE_TO_ACCOUNT_DIALOG_OK_BUTTON_LABEL 12080
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_TITLE 12081
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_SUBTITLE 12082
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_FOLDER_SUBTITLE 12083
#define IDS_BOOKMARKS_MOVE_TO_DEVICE_DIALOG_OK_BUTTON_LABEL 12084
#define IDS_BOOKMARKS_SORT_BY_TYPE 12085
#define IDS_BOOKMARKS_ALL_BOOKMARKS 12086
#define IDS_BOOKMARKS_ALL_BOOKMARKS_OPEN_SIDE_PANEL 12087
#define IDS_BOOKMARKS_ACCOUNT_BOOKMARKS 12088
#define IDS_BOOKMARKS_DEVICE_BOOKMARKS 12089
#define IDS_BOOKMARKS_LABEL_TRACKED_PRODUCTS 12090
#define IDS_BOOKMARKS_SORT_NEWEST 12091
#define IDS_BOOKMARKS_SORT_NEWEST_LOWER 12092
#define IDS_BOOKMARKS_SORT_OLDEST 12093
#define IDS_BOOKMARKS_SORT_OLDEST_LOWER 12094
#define IDS_BOOKMARKS_SORT_ALPHABETICALLY 12095
#define IDS_BOOKMARKS_SORT_REVERSE_ALPHABETICALLY 12096
#define IDS_BOOKMARKS_SORT_LAST_OPENED 12097
#define IDS_BOOKMARKS_SORT_LAST_OPENED_LOWER 12098
#define IDS_BOOKMARKS_VISUAL_VIEW 12099
#define IDS_BOOKMARKS_COMPACT_VIEW 12100
#define IDS_BOOKMARKS_SORT_MENU_A11Y_LABEL 12101
#define IDS_BOOKMARKS_CREATE_NEW_FOLDER_A11Y_LABEL 12102
#define IDS_BOOKMARKS_NEW_FOLDER_TOOLTIP 12103
#define IDS_BOOKMARKS_EDIT_BOOKMARK_LIST_A11Y_LABEL 12104
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE 12105
#define IDS_BOOKMARKS_EMPTY_STATE_BODY 12106
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_FOLDER 12107
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_FOLDER 12108
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_GUEST 12109
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_GUEST 12110
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_SEARCH 12111
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_SEARCH 12112
#define IDS_BOOKMARK_FOLDER_CHILD_COUNT 12113
#define IDS_BOOKMARKS_EDIT_BOOKMARK 12114
#define IDS_BOOKMARKS_EDIT_MOVE_TO_ANOTHER_FOLDER 12115
#define IDS_BOOKMARKS_EDIT_MORE 12116
#define IDS_BOOKMARKS_EDIT_MOVE_TO 12117
#define IDS_BOOKMARKS_EDIT_NEW_FOLDER 12118
#define IDS_BOOKMARKS_EDIT_CANCEL 12119
#define IDS_BOOKMARKS_EDIT_SAVE 12120
#define IDS_BOOKMARKS_EDIT_NAME 12121
#define IDS_BOOKMARKS_EDIT_URL 12122
#define IDS_BOOKMARK_DELETION_COUNT 12123
#define IDS_UNDO_BOOKMARK_DELETION 12124
#define IDS_BOOKMARKS_MOVE_TO_BOOKMARKS_BAR 12125
#define IDS_BOOKMARKS_MOVE_TO_ALL_BOOKMARKS 12126
#define IDS_BOOKMARKS_EDIT 12127
#define IDS_BOOKMARKS_RENAME 12128
#define IDS_BOOKMARKS_URL_FOLDER_DESCRIPTION 12129
#define IDS_BOOKMARKS_DISABLED_FEATURE 12130
#define IDS_BOOKMARKS_BACK_BUTTON_LABEL 12131
#define IDS_BOOKMARKS_BACK_BUTTON_TOOLTIP 12132
#define IDS_BOOKMARKS_FORWARD_BUTTON_LABEL 12133
#define IDS_BOOKMARK_OPTIONS_LABEL 12134
#define IDS_FOLDER_OPTIONS_LABEL 12135
#define IDS_BOOKMARKS_OPEN_FOLDER_LABEL 12136
#define IDS_BOOKMARKS_OPEN_BOOKMARK_LABEL 12137
#define IDS_BOOKMARKS_SELECT_FOLDER_LABEL 12138
#define IDS_BOOKMARKS_SELECT_BOOKMARK_LABEL 12139
#define IDS_BOOKMARKS_DESELECT_FOLDER_LABEL 12140
#define IDS_BOOKMARKS_DESELECT_BOOKMARK_LABEL 12141
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_TRACKING 12142
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_CHANGE 12143
#define IDS_BOOKMARKS_CHECKBOX_LABEL 12144
#define IDS_BOOKMARKS_PRIMARY_FILTER_HEADING 12145
#define IDS_BOOKMARKS_SECONDARY_FILTER_HEADING 12146
#define IDS_SHOW_READING_MODE_SIDE_PANEL 12147
#define IDS_READING_MODE_TITLE 12148
#define IDS_READING_MODE_NOT_SELECTABLE_HEADER 12149
#define IDS_READING_MODE_EMPTY_STATE_HEADER 12150
#define IDS_READING_MODE_EMPTY_STATE_SUBHEADER 12151
#define IDS_READING_MODE_TOOLBAR_LABEL 12152
#define IDS_READING_MODE_READ_ALOUD_TOOLBAR_LABEL 12153
#define IDS_READING_MODE_FONT_SIZE 12154
#define IDS_READING_MODE_FONT_NAME_COMBOBOX_LABEL 12155
#define IDS_READING_MODE_DECREASE_FONT_SIZE_BUTTON_LABEL 12156
#define IDS_READING_MODE_INCREASE_FONT_SIZE_BUTTON_LABEL 12157
#define IDS_READING_MODE_DISABLE_LINKS_BUTTON_LABEL 12158
#define IDS_READING_MODE_ENABLE_LINKS_BUTTON_LABEL 12159
#define IDS_READING_MODE_DISABLE_IMAGES_BUTTON_LABEL 12160
#define IDS_READING_MODE_ENABLE_IMAGES_BUTTON_LABEL 12161
#define IDS_READING_MODE_COLORS_COMBOBOX_LABEL 12162
#define IDS_READING_MODE_LINE_SPACING_COMBOBOX_LABEL 12163
#define IDS_READING_MODE_LETTER_SPACING_COMBOBOX_LABEL 12164
#define IDS_READING_MODE_SPACING_COMBOBOX_STANDARD 12165
#define IDS_READING_MODE_SPACING_COMBOBOX_LOOSE 12166
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_LOOSE 12167
#define IDS_READING_MODE_SPACING_COMBOBOX_WIDE 12168
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_WIDE 12169
#define IDS_READING_MODE_DEFAULT_COLOR_LABEL 12170
#define IDS_READING_MODE_LIGHT_COLOR_LABEL 12171
#define IDS_READING_MODE_DARK_COLOR_LABEL 12172
#define IDS_READING_MODE_YELLOW_COLOR_LABEL 12173
#define IDS_READING_MODE_BLUE_COLOR_LABEL 12174
#define IDS_READING_MODE_VOICE_HIGHLIGHT 12175
#define IDS_READING_MODE_AUTO_HIGHLIGHT_LABEL 12176
#define IDS_READING_MODE_WORD_HIGHLIGHT_LABEL 12177
#define IDS_READING_MODE_PHRASE_HIGHLIGHT_LABEL 12178
#define IDS_READING_MODE_SENTENCE_HIGHLIGHT_LABEL 12179
#define IDS_READING_MODE_OFF_HIGHLIGHT_LABEL 12180
#define IDS_READ_ANYTHING_LOADING 12181
#define IDS_READING_MODE_FONT_RESET 12182
#define IDS_READING_MODE_TURN_HIGHLIGHT_OFF 12183
#define IDS_READING_MODE_TURN_HIGHLIGHT_ON 12184
#define IDS_READING_MODE_PLAY_DESCRIPTION 12185
#define IDS_READING_MODE_PLAY_SPEECH 12186
#define IDS_READING_MODE_PLAY_TOOLTIP 12187
#define IDS_READING_MODE_PREVIEW_TOOLTIP 12188
#define IDS_READING_MODE_PAUSE_TOOLTIP 12189
#define IDS_READING_MODE_STOP_SPEECH 12190
#define IDS_READING_MODE_NAVIGATE_PREVIOUS_SENTENCE 12191
#define IDS_READING_MODE_NAVIGATE_NEXT_SENTENCE 12192
#define IDS_READING_MODE_MORE_OPTIONS 12193
#define IDS_READING_MODE_VOICE_SPEED 12194
#define IDS_READING_MODE_VOICE_SPEED_WITH_RATE 12195
#define IDS_READING_MODE_VOICE_SELECTION 12196
#define IDS_READING_MODE_SYSTEM_VOICE 12197
#define IDS_READING_MODE_ITEM_SELECTED 12198
#define IDS_READING_MODE_LANGUAGE_MENU 12199
#define IDS_READING_MODE_LANGUAGE_MENU_TITLE 12200
#define IDS_READING_MODE_LANGUAGE_MENU_CLOSE 12201
#define IDS_READING_MODE_LANGUAGE_MENU_NO_RESULTS 12202
#define IDS_READING_MODE_LANGUAGE_MENU_SEARCH_LABEL 12203
#define IDS_READING_MODE_LANGUAGE_MENU_SEARCH_CLEAR 12204
#define IDS_READING_MODE_LANGUAGE_MENU_DOWNLOADING 12205
#define IDS_READING_MODE_VOICE_MENU_DOWNLOADING 12206
#define IDS_READING_MODE_LANGUAGE_DOWNLOAD_UNAVAILALBLE 12207
#define IDS_READING_MODE_LANGUAGE_DOWNLOAD_UNAVAILALBLE_LEARN_MORE_LINK 12208
#define IDS_READING_MODE_LANGUAGE_MENU_VOICES_UNAVAILABLE 12209
#define IDS_READING_MODE_LANGUAGE_MENU_NO_INTERNET 12210
#define IDS_READING_MODE_CANT_USE_READ_ALOUD 12211
#define IDS_READING_MODE_VOICE_MENU_NO_INTERNET 12212
#define IDS_READING_MODE_LANGUAGE_MENU_DOWNLOAD_FAILED 12213
#define IDS_READING_MODE_LANGUAGE_MENU_NO_SPACE 12214
#define IDS_READING_MODE_TOAST_NO_SPACE 12215
#define IDS_READING_MODE_VOICE_MENU_NO_SPACE 12216
#define IDS_READING_MODE_VOICE_MENU_PREVIEW_LANGUAGE 12217
#define IDS_READING_MODE_LANGUAGE_MENU_NO_SPACE_BUT_VOICES_EXIST 12218
#define IDS_READING_MODE_LANGUAGE_MENU_ITEM_LABEL 12219
#define IDS_READING_MODE_VOICE_DOWNLOADED_TITLE 12220
#define IDS_READING_MODE_VOICE_DOWNLOADED_MESSAGE 12221
#define IDS_READING_MODE_SIDE_PANEL_PROMO 12222
#define IDS_READING_MODE_SIDE_PANEL_PROMO_PINNING 12223
#define IDS_READING_MODE_VOICE_PREVIEW_STRING 12224
#define IDS_READING_MODE_FONT_LOADING_STRING 12225
#define IDS_GOOGLE_LENS_TITLE 12226
#define IDS_LENS_DEFAULT_TITLE 12227
#define IDS_TOOLTIP_BACK 409
#define IDS_ACCDESCRIPTION_BACK 411
#define IDS_TOOLTIP_CHROMELABS_BUTTON 12228
#define IDS_TOOLTIP_LEFT_ALIGNED_SIDE_PANEL_BUTTON 12229
#define IDS_TOOLTIP_CHROMELABS_COMBOBOX 12230
#define IDS_TOOLTIP_CHROMELABS_FEEDBACK_BUTTON 12231
#define IDS_TOOLTIP_FORWARD 412
#define IDS_ACCDESCRIPTION_FORWARD 414
#define IDS_TOOLTIP_DOWNLOAD_ICON 12232
#define IDS_TOOLTIP_HOME 419
#define IDS_TOOLTIP_RELOAD 12233
#define IDS_TOOLTIP_RELOAD_WITH_MENU 12234
#define IDS_TOOLTIP_STOP 695
#define IDS_TOOLTIP_EXTENSIONS_BUTTON 421
#define IDS_TOOLTIP_OVERFLOW_BUTTON 12235
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 12236
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 12237
#define IDS_ACC_NAME_EXTENSIONS_BUTTON 12238
#define IDS_ACC_NAME_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 12239
#define IDS_ACC_NAME_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 12240
#define IDS_TOOLTIP_EXTENSIONS_SITE_ACCESS_BUTTON 12241
#define IDS_TOOLTIP_SIDE_PANEL_SHOW 433
#define IDS_TOOLTIP_SIDE_PANEL_HIDE 12242
#define IDS_TOOLTIP_SIDE_PANEL 12243
#define IDS_TOOLTIP_LOCATION_ICON 439
#define IDS_TOOLTIP_NEW_TAB 393
#define IDS_TOOLTIP_MIC_SEARCH 541
#define IDS_TOOLTIP_LENS_SEARCH 543
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_CLOSE_BUTTON_LABEL 544
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE 545
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE_SHORT 12245
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_TITLE 546
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_UPLOAD_FILE_TITLE 547
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OR_TEXT 548
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TEXT_PLACEHOLDER 549
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_SEARCH_BUTTON_LABEL 550
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_DROP_TITLE 551
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_LOADING_TEXT 552
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_TEXT 553
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_SUBTITLE_TEXT 554
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_BUTTON_LABEL 555
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_TYPE 556
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_SIZE 557
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_FILES 558
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_SCHEME 559
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_CONFORMANCE 560
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_URLS 561
#define IDS_TOOLTIP_SAVE_CREDIT_CARD 461
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_PENDING 12246
#define IDS_TOOLTIP_SAVE_CVC 12247
#define IDS_TOOLTIP_SAVE_IBAN 12248
#define IDS_TOOLTIP_MIGRATE_LOCAL_CARD 462
#define IDS_TOOLTIP_TRANSLATE 455
#define IDS_TOOLTIP_ZOOM 456
#define IDS_TOOLTIP_ZOOM_EXTENSION_ICON 12249
#define IDS_ZOOM_SET_DEFAULT 12250
#define IDS_TOOLTIP_FIND 454
#define IDS_TOOLTIP_TAB_SEARCH 406
#define IDS_DECLUTTER_SELECTOR_HEADING_NO_DEDUPE 12251
#define IDS_DECLUTTER_SELECTOR_HEADING 12252
#define IDS_DECLUTTER_SELECTOR_SUBHEADING 12253
#define IDS_DECLUTTER_TITLE 12254
#define IDS_DECLUTTER_INACTIVE_TITLE_NO_DEDUPE 12255
#define IDS_DECLUTTER_INACTIVE_TITLE 12256
#define IDS_DECLUTTER_INACTIVE_BODY 12257
#define IDS_DECLUTTER_DUPLICATE_TITLE 12258
#define IDS_DECLUTTER_DUPLICATE_BODY 12259
#define IDS_DECLUTTER_EMPTY_TITLE 12260
#define IDS_DECLUTTER_EMPTY_BODY_NO_DEDUPE 12261
#define IDS_DECLUTTER_EMPTY_BODY 12262
#define IDS_DUPLICATE_ITEM_TITLE_SINGLE 12263
#define IDS_DUPLICATE_ITEM_TITLE_MULTI 12264
#define IDS_TOOLTIP_TAB_DECLUTTER_NO_DEDUPE 12265
#define IDS_TAB_DECLUTTER_NO_DEDUPE 12266
#define IDS_ACCNAME_TAB_DECLUTTER_NO_DEDUPE 12267
#define IDS_TOOLTIP_TAB_DECLUTTER 12268
#define IDS_TAB_DECLUTTER 12269
#define IDS_ACCNAME_TAB_DECLUTTER 12270
#define IDS_DECLUTTER_TIMESTAMP 12271
#define IDS_DECLUTTER_MENU_NO_DEDUPE 12272
#define IDS_DECLUTTER_MENU 12273
#define IDS_DECLUTTER_CLOSE_TABS 12274
#define IDS_DECLUTTER_CLOSE_TAB_ARIA_LABEL 12275
#define IDS_DECLUTTER_CLOSE_TAB_TOOLTIP 12276
#define IDS_DECLUTTER_A11Y_TAB_EXCLUDED 12277
#define IDS_TOOLTIP_TAB_ORGANIZE 12278
#define IDS_TAB_ORGANIZE 12279
#define IDS_TOOLTIP_TAB_ORGANIZE_CLOSE 12280
#define IDS_TAB_ORGANIZATION_FEEDBACK_PLACEHOLDER 12281
#define IDS_TAB_ORGANIZE_MENU 12282
#define IDS_TAB_ORGANIZATION_SUCCESS_IPH 12283
#define IDS_TAB_ORGANIZATION_SUCCESS_IPH_SCREENREADER 12284
#define IDS_TAB_ORGANIZATION_SELECTOR_ARIA_LABEL 12285
#define IDS_IPH_EXPERIMENTAL_AI_PROMO 12286
#define IDS_IPH_EXPERIMENTAL_AI_PROMO_BODY 12287
#define IDS_IPH_EXPERIMENTAL_AI_PROMO_BUTTON_CONTINUE 12288
#define IDS_TOOLTIP_INTENT_PICKER_ICON 452
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_WITH 12289
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_IN_APP 12290
#define IDS_INTENT_PICKER_BUBBLE_VIEW_REMEMBER_SELECTION 12291
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN 12292
#define IDS_INTENT_PICKER_BUBBLE_VIEW_STAY_IN_CHROME 12293
#define IDS_INTENT_PICKER_BUBBLE_VIEW_INITIATING_ORIGIN 12294
#define IDS_INTENT_CHIP_OPEN_IN_APP 12295
#define IDR_INTENT_PICKER_SUPPORTED_LINKS_INFOBAR_MESSAGE 12296
#define IDR_INTENT_PICKER_SUPPORTED_LINKS_INFOBAR_OK_LABEL 12297
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_TITLE 12305
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_FOOTER_TITLE 12306
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_BUTTON_DECLINE 12307
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_SUBTITLE 12308
#define IDS_IOS_DESKTOP_PASSWORD_PROMO_BUBBLE_FOOTER_DESCRIPTION_QR 12309
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_TITLE 12310
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_FOOTER_TITLE 12311
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_BUTTON_DECLINE 12312
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_SUBTITLE 12313
#define IDS_IOS_DESKTOP_ADDRESS_PROMO_BUBBLE_FOOTER_DESCRIPTION_QR 12314
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_TITLE 12315
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_FOOTER_TITLE 12316
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_BUTTON_DECLINE 12317
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_SUBTITLE 12318
#define IDS_IOS_DESKTOP_PAYMENT_PROMO_BUBBLE_FOOTER_DESCRIPTION_QR 12319
#define IDS_ACCESSIBLE_INCOGNITO_WINDOW_TITLE_FORMAT 12320
#define IDS_ACCESSIBLE_GUEST_WINDOW_TITLE_FORMAT 12321
#define IDS_ACCESSIBLE_WINDOW_TITLE_WITH_PROFILE_FORMAT 12322
#define IDS_ACCNAME_APP_UPGRADE_RECOMMENDED 12323
#define IDS_ACCNAME_FULLSCREEN 12324
#define IDS_ACCNAME_EXIT_FULLSCREEN 12325
#define IDS_ACCNAME_FULLSCREEN_DISABLED 12326
#define IDS_ACCNAME_HOME 420
#define IDS_ACCNAME_RELOAD 418
#define IDS_ACCNAME_FIND 12327
#define IDS_ACCNAME_BOOKMARKS 686
#define IDS_ACCNAME_SAVED_TAB_GROUPS 679
#define IDS_ACCNAME_SAVED_TAB_GROUPS_CHEVRON 680
#define IDS_SAVED_TAB_GROUPS_OVERFLOW_BUTTON_TOOLTIP 681
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_SYNC_DISABLED 12328
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_SYNC_ENABLED 12329
#define IDS_TAB_GROUP_EDITOR_BUBBLE_FOOTER_LEARN_MORE 12330
#define IDS_ACCNAME_TAB_GROUPS_EVERYTHING 12331
#define IDS_TAB_GROUPS_EVERYTHING_BUTTON_TOOLTIP 12332
#define IDS_ACCNAME_BOOKMARKS_CHEVRON 682
#define IDS_ACCNAME_BOOKMARK_BUTTON_ROLE_DESCRIPTION 12333
#define IDS_ACCNAME_BOOKMARK_FOLDER_BUTTON_ROLE_DESCRIPTION 689
#define IDS_ACCNAME_SAVED_TAB_GROUP_BUTTON_ROLE_DESCRIPTION 12334
#define IDS_ACCNAME_CHROMELABS_BUTTON 12335
#define IDS_ACCNAME_LEFT_ALIGNED_SIDE_PANEL_BUTTON 12336
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_ADDED_BY_ENTERPRISE_POLICY 12337
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_REMOVED_BY_ENTERPRISE_POLICY 12338
#define IDS_ACCNAME_CHROMELABS_COMBOBOX 12339
#define IDS_ACCNAME_CHROMELABS_COMBOBOX_MAC 12340
#define IDS_ACCNAME_SEPARATOR 690
#define IDS_ACCNAME_EXTENSIONS 12341
#define IDS_ACCNAME_NEWTAB 394
#define IDS_ACCNAME_MINIMIZE 12342
#define IDS_ACCNAME_MAXIMIZE 12343
#define IDS_ACCNAME_RESTORE 12344
#define IDS_ACCNAME_CLOSE_TAB 12345
#define IDS_ACCNAME_ZOOM_SET_DEFAULT 12346
#define IDS_ACCNAME_TAB_SEARCH 405
#define IDS_ACCNAME_TAB_ORGANIZE 12347
#define IDS_ACCNAME_TAB_SCROLL_LEADING 12348
#define IDS_ACCNAME_TAB_SCROLL_TRAILING 12349
#define IDS_ACCNAME_MUTE_TAB 673
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_LEADING_SCROLL_BUTTON 12350
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_TRAILING_SCROLL_BUTTON 12351
#define IDS_TOOLBAR_BUTTON_UNPINNED 12352
#define IDS_TOOLBAR_BUTTON_PINNED 12353
#define IDS_ALLOWED_CLIPBOARD_TITLE 12354
#define IDS_BLOCKED_CLIPBOARD_TITLE 12355
#define IDS_ALLOWED_CLIPBOARD_MESSAGE 12356
#define IDS_ALLOWED_CLIPBOARD_BLOCK 12357
#define IDS_ALLOWED_CLIPBOARD_NO_ACTION 12358
#define IDS_BLOCKED_CLIPBOARD_MESSAGE 12359
#define IDS_BLOCKED_CLIPBOARD_UNBLOCK 12360
#define IDS_BLOCKED_CLIPBOARD_NO_ACTION 12361
#define IDS_BACK_NAVIGATION_MENU_PROMO 12362
#define IDS_BACK_NAVIGATION_MENU_PROMO_ACCESSIBLE_TEXT 12363
#define IDS_BOOKMARK_PROMO_0 12364
#define IDS_BOOKMARK_PROMO_1 12365
#define IDS_BOOKMARK_PROMO_2 12366
#define IDS_CHROME_TIP 12367
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_TITLE 12368
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_BODY 12369
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_TITLE 12370
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_BODY 12371
#define IDS_GLOBAL_MEDIA_CONTROLS_PROMO 12372
#define IDS_INCOGNITOWINDOW_PROMO_0 12373
#define IDS_INCOGNITOWINDOW_PROMO_1 12374
#define IDS_INCOGNITOWINDOW_PROMO_2 12375
#define IDS_INCOGNITOWINDOW_PROMO_3 12376
#define IDS_NEWTAB_PROMO_0 12377
#define IDS_NEWTAB_PROMO_1 12378
#define IDS_NEWTAB_PROMO_2 12379
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO 12380
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO_PINNING 12381
#define IDS_READING_LIST_DISCOVERY_PROMO 12382
#define IDS_READING_LIST_DISCOVERY_PROMO_PINNING 12383
#define IDS_READING_LIST_ENTRY_POINT_PROMO 12384
#define IDS_DESKTOP_PWA_INSTALL_PROMO 12385
#define IDS_DESKTOP_PWA_LINK_CAPTURING_TEXT 12386
#define IDS_DESKTOP_PWA_LINK_CAPTURING_SETTINGS 12387
#define IDS_UPDATED_CONNECTION_SECURITY_INDICATORS_PROMO 12388
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO 12389
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO_PINNING 12390
#define IDS_TAB_GROUPS_UNNAMED_GROUP_TOOLTIP 12391
#define IDS_TAB_GROUPS_NAMED_GROUP_TOOLTIP 12392
#define IDS_SHARED_HIGHLIGHTING_PROMO 12393
#define IDS_TAB_AUDIO_MUTING_PROMO 12394
#define IDS_BATTERY_SAVER_MODE_PROMO_TITLE 388
#define IDS_BATTERY_SAVER_MODE_PROMO_TEXT 12395
#define IDS_BATTERY_SAVER_MODE_PROMO_ACTION_TEXT 387
#define IDS_MEMORY_SAVER_MODE_PROMO_TEXT 12396
#define IDS_MEMORY_SAVER_MODE_PROMO_ACTION_TEXT 389
#define IDS_DISCARD_RING_PROMO_TITLE 12397
#define IDS_DISCARD_RING_PROMO_TEXT 12398
#define IDS_DISCARD_RING_PROMO_ACTION_TEXT 12399
#define IDS_DISCARD_RING_SETTINGS_TOAST 12400
#define IDS_TUTORIAL_GENERIC_SUCCESS_TITLE 12401
#define IDS_TUTORIAL_TAB_GROUP_ADD_TAB_TO_GROUP 12402
#define IDS_TUTORIAL_ADD_TAB_TO_GROUP_WITH_EXISTING_GROUP_IN_TAB_STRIP 12403
#define IDS_TUTORIAL_TAB_GROUP_EDIT_BUBBLE 12404
#define IDS_TUTORIAL_TAB_GROUP_DRAG_TAB 12405
#define IDS_TUTORIAL_TAB_GROUP_COLLAPSE 12406
#define IDS_TUTORIAL_TAB_GROUP_SUCCESS_DESCRIPTION 12407
#define IDS_TUTORIAL_SAVED_TAB_GROUP_ADD_TAB_TO_GROUP 12408
#define IDS_TUTORIAL_SAVED_TAB_GROUP_OPEN_EDITOR 12409
#define IDS_TUTORIAL_SAVED_TAB_GROUP_NAME_SAVE_GROUP 12410
#define IDS_TUTORIAL_SAVED_TAB_GROUP_HIDE_GROUP 12411
#define IDS_TUTORIAL_SAVED_TAB_GROUP_REOPEN_GROUP 12412
#define IDS_TUTORIAL_SAVED_TAB_GROUP_SUCCESS_DESCRIPTION 12413
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_OPEN_SIDE_PANEL 12414
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_ADD_TAB 12415
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_MARK_READ 12416
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_CLICK_DROPDOWN 12417
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_SUCCESS_BODY 12418
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_BODY 12419
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_POINTER_BODY 12420
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_CUSTOM_ACTION 12421
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_START_TUTORIAL_IPH 12422
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_OPEN_SIDE_PANEL 12423
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CHANGE_THEME 12424
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SELECT_COLLECTION 12425
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_APPLY_THEME 12426
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CLICK_BACK_ARROW 12427
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SUCCESS_BODY 12428
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_MENU 12429
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORDS_MENU 12430
#define IDS_TUTORIAL_PASSWORD_MANAGER_SELECT_SETTINGS 12431
#define IDS_TUTORIAL_PASSWORD_MANAGER_ADD_SHORTCUT 12432
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_INSTALL 12433
#define IDS_TUTORIAL_LENS_OVERLAY_INTRO_HEADER 12434
#define IDS_TUTORIAL_LENS_OVERLAY_INTRO_BODY 12435
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_ADDRESS_BAR 12436
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_LENS 12437
#define IDS_TUTORIAL_LENS_OVERLAY_SELECT 12438
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_SEARCH_BOX 12439
#define IDS_TUTORIAL_LENS_OVERLAY_CLICK_PIN_ICON 12440
#define IDS_TUTORIAL_LENS_OVERLAY_SUCCESS_BODY 12441
#define IDS_BROWSER_HANGMONITOR 12442
#define IDS_BROWSER_HANGMONITOR_RENDERER_TITLE 12443
#define IDS_BROWSER_HANGMONITOR_RENDERER 12444
#define IDS_BROWSER_HANGMONITOR_IFRAME_TITLE 12445
#define IDS_BROWSER_HANGMONITOR_RENDERER_WAIT 12446
#define IDS_BROWSER_HANGMONITOR_RENDERER_END 12447
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR 12448
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR_KILLBUTTON 12449
#define IDS_PASSWORDS_AUTO_SIGNIN_TITLE 12450
#define IDS_PASSWORDS_AUTO_SIGNIN_DESCRIPTION 12451
#define IDS_PASSWORDS_VIA_FEDERATION 12452
#define IDS_CONFIRM_MESSAGEBOX_YES_BUTTON_LABEL 12453
#define IDS_CONFIRM_MESSAGEBOX_NO_BUTTON_LABEL 12454
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_TITLE 12455
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_DESCRIPTION 12456
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_TITLE 12457
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_ACCEPT 12458
#define IDS_TAILORED_SECURITY_DISPLAY_SOURCE 12459
#define IDS_PASSWORD_MANAGER_CANCEL_BUTTON 12460
#define IDS_PASSWORD_MANAGER_USERNAME_LABEL 12461
#define IDS_PASSWORD_MANAGER_PASSWORD_LABEL 12462
#define IDS_PASSWORD_MANAGER_UPDATED_BUBBLE_TITLE 12463
#define IDS_PASSWORD_MANAGER_MORE_TO_FIX_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 12464
#define IDS_PASSWORD_MANAGER_SAFE_STATE_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 12465
#define IDS_PASSWORD_MANAGER_CHECK_REMAINING_BUTTON 12466
#define IDS_PASSWORD_MANAGER_SAVE_BUTTON 12467
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_CANCEL_BUTTON 12468
#define IDS_PASSWORD_MANAGER_UPDATE_BUTTON 12469
#define IDS_PASSWORD_MANAGER_BUBBLE_BLOCKLIST_BUTTON 12470
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_ACCESSIBLE_NAME 12471
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_ACCOUNT 12472
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_DEVICE 12473
#define IDS_PASSWORD_MANAGER_IPH_TITLE_SAVE_TO_ACCOUNT 386
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_TO_ACCOUNT 12474
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE 12475
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE_SCREENREADER 12476
#define IDS_PASSWORD_MANAGER_IPH_SHARE_PASSWORD_BUTTON 12477
#define IDS_PASSWORD_MANAGER_IPH_SHARE_PASSWORD_BUTTON_SCREENREADER 12478
#define IDS_PASSWORD_MANAGER_IPH_ACCOUNT_STORAGE_TOGGLE 12479
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_TITLE 12480
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN 12481
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN_SCREENREADER 12482
#define IDS_PASSWORD_MANAGER_TOOLTIP_SAVE 12483
#define IDS_PASSWORD_MANAGER_TOOLTIP_MANAGE 451
#define IDS_PASSWORD_MANAGER_TOOLTIP_MOVE 12484
#define IDS_PASSWORD_MANAGER_TOOLTIP_PROTECT 12485
#define IDS_PASSWORD_MANAGER_TOOLTIP_SHARED_NOTIFICATION 12486
#define IDS_PASSWORD_MANAGER_TOOLTIP_KEYCHAIN_ERROR 12487
#define IDS_PASSWORD_MANAGER_IMPORT_DIALOG_TITLE 12488
#define IDS_PASSWORD_MANAGER_EXPORT_DIALOG_TITLE 12489
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_TITLE_GPM 12490
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_DESCRIPTION_GPM 12491
#define IDS_PASSWORD_MANAGER_SAVE_UNSYNCED_CREDENTIALS_BUTTON_GPM 12492
#define IDS_PASSWORD_MANAGER_DISCARD_UNSYNCED_CREDENTIALS_BUTTON 12493
#define IDS_IMPORT_FROM_IE 12511
#define IDS_IMPORT_FROM_EDGE 12512
#define IDS_IMPORT_FROM_FIREFOX 12513
#define IDS_IMPORT_FROM_ICEWEASEL 12514
#define IDS_IMPORT_FROM_SAFARI 12515
#define IDS_IMPORT_FROM_BOOKMARKS_HTML_FILE 12516
#define IDS_IMPORTER_LOCK_TITLE 12520
#define IDS_IMPORTER_LOCK_TEXT 12521
#define IDS_IMPORTER_LOCK_OK 12522
#define IDS_FEEDBACK_REPORT_APP_TITLE 12523
#define IDS_FEEDBACK_REPORT_PAGE_TITLE 12524
#define IDS_FEEDBACK_REPORT_PAGE_TITLE_SAD_TAB_FLOW 12525
#define IDS_FEEDBACK_MINIMIZE_BUTTON_LABEL 12526
#define IDS_FEEDBACK_CLOSE_BUTTON_LABEL 12527
#define IDS_FEEDBACK_FREE_TEXT_LABEL 12528
#define IDS_FEEDBACK_FREE_TEXT_AI_LABEL 12529
#define IDS_FEEDBACK_REPORT_URL_LABEL 12530
#define IDS_FEEDBACK_USER_EMAIL_LABEL 12531
#define IDS_FEEDBACK_ANONYMOUS_EMAIL_OPTION 12532
#define IDS_FEEDBACK_CONSENT_CHECKBOX_LABEL 12533
#define IDS_FEEDBACK_SCREENSHOT_LABEL 12534
#define IDS_FEEDBACK_SCREENSHOT_A11Y_TEXT 12535
#define IDS_FEEDBACK_OFFLINE_DIALOG_TITLE 12536
#define IDS_FEEDBACK_OFFLINE_DIALOG_TEXT 12537
#define IDS_FEEDBACK_INCLUDE_SYSTEM_INFORMATION_CHKBOX 12538
#define IDS_FEEDBACK_ATTACH_FILE_NOTE 12541
#define IDS_FEEDBACK_ATTACH_FILE_LABEL 12542
#define IDS_FEEDBACK_ATTACH_FILE_TO_BIG 12543
#define IDS_FEEDBACK_INCLUDE_AUTOFILL_METADATA_CHECKBOX 12544
#define IDS_FEEDBACK_IWLWIFI_DEBUG_DUMP_EXPLAINER 12545
#define IDS_FEEDBACK_LOG_ID_CHECKBOX_LABEL 12546
#define IDS_FEEDBACK_PRIVACY_NOTE 12547
#define IDS_FEEDBACK_NO_DESCRIPTION 12548
#define IDS_FEEDBACK_OFFENSIVE_CHECKBOX_LABEL 12549
#define IDS_FEEDBACK_SEND_REPORT 12550
#define IDS_FEEDBACK_AUTOFILL_METADATA_PAGE_TITLE 12551
#define IDS_FEEDBACK_SYSINFO_PAGE_TITLE 12552
#define IDS_FEEDBACK_SYSINFO_PAGE_LOADING 12553
#define IDS_FEEDBACK_ADDITIONAL_INFO_LABEL 12554
#define IDS_CLEAR_BROWSING_DATA_TITLE 12555
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE 12556
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_TITLE 12557
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_OK 12558
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE 12559
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_TITLE 12560
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_OK 12561
#define IDS_MEDIA_SELECTED_MIC_LABEL 12562
#define IDS_MEDIA_SELECTED_CAMERA_LABEL 12563
#define IDS_MEDIA_MENU_NO_DEVICE_TITLE 12564
#define IDS_MEDIA_CONTROLS_TITLE_PLACEHOLDER_INCOGNITO 12565
#define IDS_ZOOMLEVELS_CHROME_ERROR_PAGES_LABEL 12566
#define IDS_STORAGE_ACCESS_MANAGE_TEXT 12567
#define IDS_STORAGE_ACCESS_MANAGE_TOOLTIP 12568
#define IDS_UPGRADE_ERROR 12575
#define IDS_UPGRADE_ERROR_DETAILS 12576
#define IDS_UPGRADE_DISABLED_BY_POLICY 12577
#define IDS_UPGRADE_DISABLED_BY_POLICY_MANUAL 12578
#define IDS_REPORT_AN_ISSUE 12579
#define IDS_REENABLE_UPDATES 12580
#define IDS_PICTURE_IN_PICTURE_TITLE_TEXT 12581
#define IDS_PICTURE_IN_PICTURE_PAUSE_CONTROL_TEXT 12582
#define IDS_PICTURE_IN_PICTURE_PLAY_CONTROL_TEXT 12583
#define IDS_PICTURE_IN_PICTURE_REPLAY_CONTROL_TEXT 12584
#define IDS_PICTURE_IN_PICTURE_BACK_TO_TAB_CONTROL_TEXT 12585
#define IDS_PICTURE_IN_PICTURE_SKIP_AD_CONTROL_TEXT 12586
#define IDS_PICTURE_IN_PICTURE_MUTE_MICROPHONE_TEXT 12587
#define IDS_PICTURE_IN_PICTURE_UNMUTE_MICROPHONE_TEXT 12588
#define IDS_PICTURE_IN_PICTURE_TURN_ON_CAMERA_TEXT 12589
#define IDS_PICTURE_IN_PICTURE_TURN_OFF_CAMERA_TEXT 12590
#define IDS_PICTURE_IN_PICTURE_HANG_UP_TEXT 12591
#define IDS_PICTURE_IN_PICTURE_CLOSE_CONTROL_TEXT 12592
#define IDS_PICTURE_IN_PICTURE_MINIMIZE_CONTROL_TEXT 12593
#define IDS_PICTURE_IN_PICTURE_REPLAY_10_TEXT 12594
#define IDS_PICTURE_IN_PICTURE_FORWARD_10_TEXT 12595
#define IDS_PICTURE_IN_PICTURE_RESIZE_HANDLE_TEXT 12596
#define IDS_PICTURE_IN_PICTURE_PLAY_PAUSE_CONTROL_ACCESSIBLE_TEXT 12597
#define IDS_PICTURE_IN_PICTURE_NEXT_TRACK_CONTROL_ACCESSIBLE_TEXT 12598
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_TRACK_CONTROL_ACCESSIBLE_TEXT 12599
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_SLIDE_CONTROL_ACCESSIBLE_TEXT 12600
#define IDS_PICTURE_IN_PICTURE_NEXT_SLIDE_CONTROL_ACCESSIBLE_TEXT 12601
#define IDS_AUTO_PICTURE_IN_PICTURE_DESCRIPTION 12602
#define IDS_LOAD_STATE_WAITING_FOR_SOCKET_SLOT 12603
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE 12604
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE_GENERIC 12605
#define IDS_LOAD_STATE_WAITING_FOR_CACHE 12606
#define IDS_LOAD_STATE_ESTABLISHING_PROXY_TUNNEL 12607
#define IDS_LOAD_STATE_RESOLVING_PROXY_FOR_URL 12608
#define IDS_LOAD_STATE_RESOLVING_HOST_IN_PAC_FILE 12609
#define IDS_LOAD_STATE_DOWNLOADING_PAC_FILE 12610
#define IDS_LOAD_STATE_RESOLVING_HOST 12611
#define IDS_LOAD_STATE_CONNECTING 12612
#define IDS_LOAD_STATE_SSL_HANDSHAKE 12613
#define IDS_LOAD_STATE_SENDING_REQUEST 12614
#define IDS_LOAD_STATE_SENDING_REQUEST_WITH_PROGRESS 12615
#define IDS_LOAD_STATE_WAITING_FOR_RESPONSE 12616
#define IDS_TAB_CXMENU_NEWTABTORIGHT 12617
#define IDS_TAB_CXMENU_NEWTABTOLEFT 12618
#define IDS_TAB_CXMENU_RELOAD 12619
#define IDS_TAB_CXMENU_DUPLICATE 12620
#define IDS_TAB_CXMENU_CLOSETAB 12621
#define IDS_TAB_CXMENU_CLOSEOTHERTABS 12622
#define IDS_TAB_CXMENU_CLOSETABSTORIGHT 12623
#define IDS_TAB_CXMENU_CLOSETABSTOLEFT 12624
#define IDS_TAB_CXMENU_CLOSEALLTABS 12625
#define IDS_TAB_CXMENU_FOCUS_THIS_TAB 12626
#define IDS_TAB_CXMENU_PIN_TAB 12627
#define IDS_TAB_CXMENU_UNPIN_TAB 12628
#define IDS_TAB_CXMENU_SOUND_MUTE_SITE 12629
#define IDS_TAB_CXMENU_SOUND_UNMUTE_SITE 12630
#define IDS_TAB_CXMENU_READ_LATER 12631
#define IDS_TAB_CXMENU_ADD_TAB_TO_GROUP 12632
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_GROUP 12633
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_SPLIT 12634
#define IDS_TAB_CXMENU_SUBMENU_NEW_GROUP 12635
#define IDS_TAB_CXMENU_REMOVE_TAB_FROM_GROUP 12636
#define IDS_TAB_CXMENU_PLACEHOLDER_GROUP_TITLE 12637
#define IDS_TAB_CXMENU_MOVE_TABS_TO_NEW_WINDOW 12638
#define IDS_TAB_CXMENU_MOVETOANOTHERWINDOW 12639
#define IDS_TAB_CXMENU_MOVETOANOTHERNEWWINDOW 12640
#define IDS_TAB_CXMENU_ORGANIZE_TABS 12641
#define IDS_TAB_CXMENU_COMMERCE_PRODUCT_SPEC 12642
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_COMPARISON_TABLE 12643
#define IDS_WEBUI_TAB_STRIP_PROMO 12647
#define IDS_TOOLTIP_WEBUI_TAB_STRIP_TAB_COUNTER 12648
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_NEW_TAB 12649
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_CLOSE_TAB 12650
#define IDS_TAB_SEARCH_PROMO 12651
#define IDS_TAB_SEARCH_SEARCH_TABS 12652
#define IDS_TAB_SEARCH_NO_RESULTS_FOUND 12653
#define IDS_TAB_SEARCH_CLOSE_TAB 12654
#define IDS_TAB_SEARCH_SUBMIT_FEEDBACK 12655
#define IDS_TAB_SEARCH_A11Y_TAB_CLOSED 12656
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB 12657
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS 12658
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB_FOR 12659
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS_FOR 12660
#define IDS_TAB_SEARCH_A11Y_OPEN_TAB 12661
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB 12662
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB_GROUP 12663
#define IDS_TAB_SEARCH_MEDIA_TABS 12664
#define IDS_TAB_SEARCH_OPEN_TABS 12665
#define IDS_TAB_SEARCH_RECENTLY_CLOSED 12666
#define IDS_TAB_SEARCH_RECENTLY_CLOSED_TABS 12667
#define IDS_TAB_SEARCH_ONE_TAB 12668
#define IDS_TAB_SEARCH_TAB_COUNT 12669
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED_ITEMS 12670
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED 12671
#define IDS_TAB_SEARCH_COLLAPSE_RECENTLY_CLOSED 12672
#define IDS_TAB_SEARCH_TAB_NAME 12673
#define IDS_TAB_ORGANIZATION_TAB_NAME 12674
#define IDS_TAB_ORGANIZATION_CREATE_GROUP 12675
#define IDS_TAB_ORGANIZATION_CREATE_GROUPS 12676
#define IDS_TAB_ORGANIZATION_DISMISS 12677
#define IDS_TAB_ORGANIZATION_NEW_TABS 12678
#define IDS_TAB_ORGANIZATION_NOT_STARTED_TITLE 12679
#define IDS_TAB_ORGANIZATION_NOT_STARTED_TITLE_FRE 12680
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY 12681
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_HEADER 12682
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_BULLET_1 12683
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_BULLET_2 12684
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_FRE_BULLET_3 12685
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BODY_SIGNED_OUT 12686
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON 12687
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_FRE 12688
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_SIGNED_OUT 12689
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_ARIA_LABEL 12690
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_FRE_ARIA_LABEL 12691
#define IDS_TAB_ORGANIZATION_NOT_STARTED_BUTTON_SIGNED_OUT_ARIA_LABEL 12692
#define IDS_TAB_ORGANIZATION_IN_PROGRESS_TITLE 12693
#define IDS_TAB_ORGANIZATION_SUCCESS_MISSING_ACTIVE_TAB_TITLE 12694
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE_SINGLE 12695
#define IDS_TAB_ORGANIZATION_SUCCESS_TITLE_MULTI 12696
#define IDS_TAB_ORGANIZATION_FAILURE_TITLE_GENERIC 12697
#define IDS_TAB_ORGANIZATION_FAILURE_TITLE_GROUPING 12698
#define IDS_TAB_ORGANIZATION_FAILURE_BODY_GENERIC 12699
#define IDS_TAB_ORGANIZATION_FAILURE_BODY_GROUPING 12700
#define IDS_TAB_ORGANIZATION_TIP_TITLE 12701
#define IDS_TAB_ORGANIZATION_TIP_BODY 12702
#define IDS_TAB_ORGANIZATION_TIP_ACTION 12703
#define IDS_TAB_ORGANIZATION_TIP_ARIA_DESCRIPTION 12704
#define IDS_TAB_ORGANIZATION_DISCLAIMER_1 12705
#define IDS_TAB_ORGANIZATION_DISCLAIMER_2 12706
#define IDS_TAB_ORGANIZATION_LEARN_MORE 12707
#define IDS_TAB_ORGANIZATION_LEARN_MORE_ARIA_LABEL 12708
#define IDS_TAB_ORGANIZATION_CLOSE_TAB_ARIA_LABEL 12709
#define IDS_TAB_ORGANIZATION_CLOSE_TAB_TOOLTIP 12710
#define IDS_TAB_ORGANIZATION_CLEAR_SUGGESTIONS 12711
#define IDS_TAB_ORGANIZATION_CLEAR_ARIA_LABEL 12712
#define IDS_TAB_ORGANIZATION_INPUT_ARIA_LABEL 12713
#define IDS_TAB_ORGANIZATION_EDIT_ARIA_LABEL 12714
#define IDS_TAB_ORGANIZATION_REJECT_ARIA_LABEL 12715
#define IDS_TAB_ORGANIZATION_THUMBS_DOWN 12716
#define IDS_TAB_ORGANIZATION_THUMBS_UP 12717
#define IDS_AUTO_TAB_GROUPS_SELECTOR_HEADING 12718
#define IDS_AUTO_TAB_GROUPS_SELECTOR_SUBHEADING 12719
#define IDS_TAB_ORGANIZATION_BACK_BUTTON_ARIA_LABEL 12720
#define IDS_TAB_ORGANIZATION_A11Y_TAB_EXCLUDED 12721
#define IDS_BROWSER_WINDOW_TITLE_MENU_ENTRY 12722
#define IDS_TABS_TITLE_CXMENU 12723
#define IDS_SAVED_TAB_GROUP_TABS_COUNT 12724
#define IDS_CREATE_NEW_TAB_GROUP 12725
#define IDS_SAVED_TAB_GROUPS_MENU 12726
#define IDS_OPEN_GROUP_IN_BROWSER_MENU 12727
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_APP_MENU_SYNCED_BODY 12728
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_DEFAULT_BODY_A11Y 12729
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_APP_MENU_NOT_SYNCED_BODY 12730
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_BOOKMARKS_BAR_SYNCED_BODY 12731
#define IDS_SAVED_TAB_GROUPS_V2_INTRO_IPH_BOOKMARKS_BAR_NOT_SYNCED_BODY 12732
#define IDS_SAVED_TAB_GROUPS_UNSUPPORTED_ERROR 12733
#define IDS_TAB_GROUP_DELETION_DIALOG_MISSING_EMAIL 12734
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_SYNCED_DELETE 12735
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_SYNCED_UNGROUP 12736
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_NOT_SYNCED_DELETE 12737
#define IDS_TAB_GROUP_DELETION_DIALOG_BODY_NOT_SYNCED_UNGROUP 12738
#define IDS_TAB_GROUP_DELETION_DIALOG_DONT_ASK 12739
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_DELETE 12740
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_UNGROUP 12741
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_CLOSE_TAB_AND_DELETE 12742
#define IDS_TAB_GROUP_DELETION_DIALOG_TITLE_REMOVE_TAB_AND_DELETE 12743
#define IDS_TAB_GROUP_DELETION_DIALOG_OK_TEXT_DELETE 12744
#define IDS_TAB_GROUP_DELETION_DIALOG_OK_TEXT_UNGROUP 12745
#define IDS_TAB_GROUP_HEADER_CXMENU_TAB_GROUP_TITLE_ACCESSIBLE_NAME 12746
#define IDS_TAB_GROUP_HEADER_CXMENU_SAVE_GROUP 12747
#define IDS_TAB_GROUP_HEADER_CXMENU_UNSAVE_GROUP 12748
#define IDS_TAB_GROUP_HEADER_CXMENU_NEW_TAB_IN_GROUP 12749
#define IDS_TAB_GROUP_HEADER_CXMENU_UNGROUP 12750
#define IDS_TAB_GROUP_HEADER_CXMENU_SHARE_GROUP 12751
#define IDS_TAB_GROUP_HEADER_CXMENU_RECENT_ACTIVITY 12752
#define IDS_TAB_GROUP_HEADER_CXMENU_MANAGE_GROUP 12753
#define IDS_TAB_GROUP_HEADER_CXMENU_CLOSE_GROUP 12754
#define IDS_TAB_GROUP_HEADER_CXMENU_HIDE_GROUP 12755
#define IDS_TAB_GROUP_HEADER_CXMENU_DELETE_GROUP 12756
#define IDS_TAB_GROUP_HEADER_CXMENU_MOVE_GROUP_TO_NEW_WINDOW 12757
#define IDS_TAB_GROUP_HEADER_CXMENU_OPEN_GROUP_IN_NEW_WINDOW 12758
#define IDS_TAB_GROUP_HEADER_CXMENU_PIN_GROUP 12759
#define IDS_TAB_GROUP_HEADER_CXMENU_UNPIN_GROUP 12760
#define IDS_TAB_GROUP_HEADER_CXMENU_SEND_FEEDBACK 12761
#define IDS_TAB_GROUP_HEADER_BUBBLE_TITLE_PLACEHOLDER 12762
#define IDS_DATA_SHARING_SHARE_GROUP_TITLE 12763
#define IDS_DATA_SHARING_MANAGE_GROUP_TITLE 12764
#define IDS_DATA_SHARING_MANAGE_STOP_SHARING_OPTION 12765
#define IDS_DATA_SHARING_MANAGE_ACTIVITY_LOG_OPTION 12766
#define IDS_DATA_SHARING_OWNER_STOP_SHARING_DIALOG_TITLE 12767
#define IDS_DATA_SHARING_OWNER_REMOVE_MEMBER_DIALOG_TITLE 12768
#define IDS_DATA_SHARING_OWNER_REMOVE_MEMBER_DIALOG_CONFIRM 12769
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_TITLE 12770
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_CONFIRM 12771
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE 12772
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE_ZERO 12773
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE_SINGULAR 12774
#define IDS_DATA_SHARING_PREVIEW_DIALOG_TITLE_PLURAL 12775
#define IDS_DATA_SHARING_PREVIEW_DIALOG_CONFIRM 12776
#define IDS_DATA_SHARING_PREVIEW_DIALOG_DETAILS_TITLE 12777
#define IDS_DATA_SHARING_LINK_FAILED_TITLE 12778
#define IDS_DATA_SHARING_LEAVE_DIALOG_TITLE 12779
#define IDS_DATA_SHARING_BLOCK_LEAVE_DIALOG_TITLE 12780
#define IDS_DATA_SHARING_BLOCK_LEAVE_DIALOG_CONFIRM 12781
#define IDS_DATA_SHARING_NEED_SIGN_IN 12782
#define IDS_DATA_SHARING_NEED_SYNC 12783
#define IDS_DATA_SHARING_NEED_SYNC_TAB_GROUPS 12784
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT 12785
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT_BUTTON 12786
#define IDS_DATA_SHARING_GOT_IT 12787
#define IDS_DATA_SHARING_SOMETHING_WRONG 12788
#define IDS_DATA_SHARING_ORGANIZATION_DISALLOW_SIGN_IN 12789
#define IDS_DATA_SHARING_ORGANIZATION_LIMIT_SAVE 12790
#define IDS_DATA_SHARING_SIGNED_OUT 12791
#define IDS_DATA_SHARING_GROUP_FULL 12792
#define IDS_DATA_SHARING_DELETE_LAST_TAB_TITLE 12793
#define IDS_DATA_SHARING_DELETE_LAST_TAB_CONFIRM 12794
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_CANCEL 12795
#define IDS_DATA_SHARING_MEMBER_DELETE_LAST_TAB_CANCEL 12796
#define IDS_DATA_SHARING_RECENT_ACTIVITY_TITLE 12797
#define IDS_DATA_SHARING_RECENT_ACTIVITY_LATEST_UPDATE_TAB 12798
#define IDS_DATA_SHARING_RECENT_ACTIVITY_LATEST_UPDATE_GROUP 12799
#define IDS_DATA_SHARING_SHARE_GROUP_BODY 12800
#define IDS_DATA_SHARING_SHARE_GROUP_SHARE_AS 12801
#define IDS_DATA_SHARING_MANAGE_SHARE_WISELY 12802
#define IDS_DATA_SHARING_OWNER_STOP_SHARING_DIALOG_BODY 12803
#define IDS_DATA_SHARING_OWNER_REMOVE_MEMBER_DIALOG_BODY 12804
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_BODY 12805
#define IDS_DATA_SHARING_OWNER_DELETE_DIALOG_BODY_NO_GROUP_TITLE 12806
#define IDS_DATA_SHARING_PREVIEW_DIALOG_BODY 12807
#define IDS_DATA_SHARING_PREVIEW_DIALOG_DETAILS_TABS_IN_GROUP 12808
#define IDS_DATA_SHARING_LINK_FAILED_BODY 12809
#define IDS_DATA_SHARING_JOIN_GROUP_JOIN_AS 12810
#define IDS_DATA_SHARING_GET_GROUP_PREVIEW_ARIA_LABEL 12811
#define IDS_DATA_SHARING_LEAVE_DIALOG_BODY 12812
#define IDS_DATA_SHARING_LEAVE_DIALOG_BODY_NO_GROUP_TITLE 12813
#define IDS_DATA_SHARING_LEAVE_DIALOG_CONFIRM 12814
#define IDS_DATA_SHARING_BLOCK_DIALOG_TITLE 12815
#define IDS_DATA_SHARING_BLOCK_LEAVE_DIALOG_BODY 12816
#define IDS_DATA_SHARING_BLOCK_LEAVE_LEARN_MORE 12817
#define IDS_DATA_SHARING_NEED_SIGN_IN_BODY 12818
#define IDS_DATA_SHARING_NEED_SIGN_IN_CONTINUE_BUTTON 12819
#define IDS_DATA_SHARING_NEED_SYNC_BODY 12820
#define IDS_DATA_SHARING_NEED_SYNC_TAB_GROUPS_BODY 12821
#define IDS_DATA_SHARING_NEED_VERIFY_ACCOUNT_BODY 12822
#define IDS_DATA_SHARING_SOMETHING_WRONG_BODY 12823
#define IDS_DATA_SHARING_SHARE_ERROR_BODY 12824
#define IDS_DATA_SHARING_JOIN_WARNING 12825
#define IDS_DATA_SHARING_ORGANIZATION_DISALLOW_SIGN_IN_BODY 12826
#define IDS_DATA_SHARING_ORGANIZATION_LIMIT_SAVE_BODY 12827
#define IDS_DATA_SHARING_SIGNED_OUT_BODY 12828
#define IDS_DATA_SHARING_SETTINGS 12829
#define IDS_DATA_SHARING_GROUP_FULL_BODY 12830
#define IDS_DATA_SHARING_OWNER_CANNOT_SHARE 12831
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_BODY 12832
#define IDS_DATA_SHARING_OWNER_DELETE_LAST_TAB_BODY_2 12833
#define IDS_DATA_SHARING_MEMBER_DELETE_LAST_TAB_BODY 12834
#define IDS_DATA_SHARING_RECENT_ACTIVITY_MEMBER_ADDED_THIS_TAB 12835
#define IDS_DATA_SHARING_RECENT_ACTIVITY_MEMBER_CHANGED_THIS_TAB 12836
#define IDS_DATA_SHARING_PAGE_ACTION_ADDED_NEW_TAB 12837
#define IDS_DATA_SHARING_PAGE_ACTION_CHANGED_TAB 12838
#define IDS_DATA_SHARING_TOAST_TAB_REMOVED 12839
#define IDS_DATA_SHARING_TOAST_TAB_REMOVED_ACTION 12840
#define IDS_DATA_SHARING_TOAST_NEW_MEMBER 12841
#define IDS_DATA_SHARING_TOAST_NEW_MEMBER_ACTION 12842
#define IDS_DATA_SHARING_TOAST_BLOCK_LEAVE 12843
#define IDS_DATA_SHARING_USER_ED_FIRST_TAB_CHANGE 12844
#define IDS_DATA_SHARING_LEARN_ABOUT_SHARED_GROUPS 12845
#define IDS_DATA_SHARING_PEOPLE_WITH_ACCESS 12846
#define IDS_DATA_SHARING_LINK_EDIT_ACCESS 12847
#define IDS_DATA_SHARING_LINK_JOIN_TOGGLE 12848
#define IDS_DATA_SHARING_CANCEL 12849
#define IDS_DATA_SHARING_CLOSE 12850
#define IDS_DATA_SHARING_BACK 12851
#define IDS_DATA_SHARING_BLOCK 12852
#define IDS_DATA_SHARING_REMOVE 12853
#define IDS_DATA_SHARING_LEAVE_GROUP 12854
#define IDS_DATA_SHARING_LOADING 12855
#define IDS_DATA_SHARING_COPY_LINK 12856
#define IDS_DATA_SHARING_COPY_LINK_SUCCESS 12857
#define IDS_DATA_SHARING_COPY_LINK_FAILED 12858
#define IDS_DATA_SHARING_YOU 12859
#define IDS_DATA_SHARING_OWNER 12860
#define IDS_DATA_SHARING_MEMBER_COUNT_SINGULAR 12861
#define IDS_DATA_SHARING_MEMBER_COUNT_PLURAL 12862
#define IDS_DATA_SHARING_TAB_COUNT_SINGULAR 12863
#define IDS_DATA_SHARING_TAB_COUNT_PLURAL 12864
#define IDS_DATA_SHARING_MORE_OPTIONS 12865
#define IDS_DATA_SHARING_MORE_OPTIONS_DESCRIPTION 12866
#define IDS_APP_MENU_RELOAD 12867
#define IDS_APP_MENU_NEW_WEB_PAGE 12868
#define IDS_APP_MENU_COPY_LINK 12869
#define IDS_APP_MENU_CREATE_QR_CODE 12870
#define IDS_APP_MENU_BUTTON_UPDATE 12871
#define IDS_APP_MENU_BUTTON_UPDATE_ALT1 12872
#define IDS_APP_MENU_BUTTON_UPDATE_ALT2 12873
#define IDS_APP_MENU_BUTTON_UPDATE_ALT3 12874
#define IDS_APP_MENU_BUTTON_ERROR 12875
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TITLE 12876
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TEXT 12877
#define IDS_MEDIA_SCREEN_AND_AUDIO_CAPTURE_CONFIRMATION_TEXT 12878
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_TEXT 12879
#define IDS_MEDIA_SCREEN_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 12880
#define IDS_MEDIA_WINDOW_CAPTURE_NOTIFICATION_TEXT 12881
#define IDS_MEDIA_TAB_CAPTURE_NOTIFICATION_TEXT 12882
#define IDS_MEDIA_TAB_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 12883
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_HIDE 12884
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_SOURCE 12885
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_STOP 12886
#define IDS_PLATFORM_KEYS_SELECT_CERT_DIALOG_TEXT 12887
#define IDS_UNSAFE_FRAME_MESSAGE 12888
#define IDS_CLIENT_CERT_DIALOG_TITLE 12889
#define IDS_CLIENT_CERT_DIALOG_TEXT 12890
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TITLE 12891
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_ENROLLMENT 12892
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CLIENT_AUTH 12893
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_LIST_CERTS 12894
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_IMPORT 12895
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_EXPORT 12896
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_PASSWORD_FIELD 12897
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_OK_BUTTON_LABEL 12898
#define IDS_FR_ENABLE_LOGGING 12900
#define IDS_CRASHED_TAB_FEEDBACK_MESSAGE 12904
#define IDS_CRASHED_TAB_FEEDBACK_LINK 12905
#define IDS_KILLED_TAB_FEEDBACK_MESSAGE 12907
#define IDS_HIDE_ICONS_NOT_SUPPORTED 12908
#define IDS_RELAUNCH_BUTTON 12909
#define IDS_HELP_MANAGED_BY_YOUR_PARENT 12910
#define IDS_TOOLBAR_INFORM_SET_HOME_PAGE 12913
#define IDS_MANAGE_EXTENSIONS_SETTING_WINDOWS_TITLE 12914
#define IDS_CONTROLLED_SETTING_POLICY 486
#define IDS_CONTROLLED_SETTING_EXTENSION 12915
#define IDS_CONTROLLED_SETTING_EXTENSION_WITHOUT_NAME 12916
#define IDS_CONTROLLED_SETTING_RECOMMENDED 12917
#define IDS_CONTROLLED_SETTING_HAS_RECOMMENDATION 12918
#define IDS_CONTROLLED_SETTING_CHILD_RESTRICTION 12919
#define IDS_CONTROLLED_SETTING_PARENT 12920
#define IDS_EXTENSIONS_INSTALL_LOCATION_UNKNOWN 12921
#define IDS_EXTENSIONS_INSTALL_LOCATION_3RD_PARTY 12922
#define IDS_EXTENSIONS_INSTALL_LOCATION_ENTERPRISE 12923
#define IDS_EXTENSIONS_INSTALL_LOCATION_SHARED_MODULE 12924
#define IDS_EXTENSIONS_BLOCKLISTED_MALWARE 12925
#define IDS_EXTENSIONS_BLOCKLISTED_SECURITY_VULNERABILITY 12926
#define IDS_EXTENSIONS_BLOCKLISTED_CWS_POLICY_VIOLATION 12927
#define IDS_EXTENSIONS_BLOCKLISTED_POTENTIALLY_UNWANTED 12928
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING 12929
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING_LEARN_MORE 12930
#define IDS_EXTENSIONS_ACCESS_REQUESTS_LEARN_MORE 12931
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_DIALOG_TITLE 12932
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_DIALOG_SUBTITLE 12933
#define IDS_EXTENSIONS_MOVE_TO_ACCOUNT_DIALOG_OK_BUTTON_LABEL 12934
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION 12935
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION_IN_BULLET_POINTS 12936
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_TITLE 12937
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_EXPLANATION 12938
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_DEFAULT_TOOL_NAME 12939
#define IDS_RESET_PROFILE_SETTINGS_LOCALE 12940
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_URLS 12941
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_TYPE 12942
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE 12943
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE_IS_NTP 12944
#define IDS_RESET_PROFILE_SETTINGS_YES 12945
#define IDS_RESET_PROFILE_SETTINGS_NO 12946
#define IDS_RESET_PROFILE_SETTINGS_SHOW_HOME_BUTTON 12947
#define IDS_RESET_PROFILE_SETTINGS_DSE 12948
#define IDS_RESET_PROFILE_SETTINGS_EXTENSIONS 12949
#define IDS_RESET_PROFILE_SETTINGS_SHORTCUTS 12950
#define IDS_RESET_PROFILE_SETTINGS_PROCESSING_SHORTCUTS 12951
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_MONTH 12953
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_YEAR 12954
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT 12955
#define IDS_OMNIBOX_ICON_SEND_TAB_TO_SELF 447
#define IDS_OMNIBOX_TOOLTIP_SEND_TAB_TO_SELF 448
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_TODAY_SEND_TAB_TO_SELF 12957
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAY_SEND_TAB_TO_SELF 12958
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAYS_SEND_TAB_TO_SELF 12959
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_FROM_DEVICE 12960
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_TITLE 432
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_LABEL 12961
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_A11Y_NAME 431
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_HINT_TEXT 12962
#define IDS_MENU_SEND_TAB_TO_SELF 12963
#define IDS_SEND_TAB_TO_SELF 12964
#define IDS_SEND_TAB_TO_SELF_SENDING_ANNOUNCE 12967
#define IDS_SEND_TAB_TO_SELF_MANAGE_DEVICES_LINK 12968
#define IDS_SEND_TAB_TO_SELF_SIGN_IN_PROMO_LABEL 12969
#define IDS_SEND_TAB_TO_SELF_NO_TARGET_DEVICE_LABEL 12970
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_PAGE 12971
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_IMAGE 12972
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_LINK 12973
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_LABEL 449
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_TOOLTIP 450
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TITLE 12974
#define IDS_SHARING_HUB_GENERATE_QR_CODE_LABEL 12975
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_URL_TEXTFIELD_ACCESSIBLE_NAME 12976
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TOOLTIP 12977
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_DOWNLOAD_BUTTON_LABEL 12978
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_COPY_BUTTON_LABEL 12979
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_TOO_LONG 12980
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_UNKNOWN 12981
#define IDS_SHARING_HUB_TITLE 12982
#define IDS_SHARING_HUB_TOOLTIP 468
#define IDS_SHARING_HUB_SCREENSHOT_LABEL 12983
#define IDS_SHARING_HUB_COPY_LINK_LABEL 12984
#define IDS_SHARING_HUB_SAVE_PAGE_LABEL 12985
#define IDS_SHARING_HUB_MEDIA_ROUTER_LABEL 12986
#define IDS_SHARING_HUB_SHARE_LABEL 12987
#define IDS_BROWSER_SHARING_SCREENSHOT_POST_CAPTURE_TITLE 12988
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_DOWNLOAD_BUTTON_LABEL 12989
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_EDIT_BUTTON_LABEL 12990
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_SHARE_BUTTON_LABEL 12991
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SELECTION 12992
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CROP 12993
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_TEXT 12994
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ELLIPSE 12995
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_RECTANGLE 12996
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_LINE 12997
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ARROW 12998
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_BRUSH 12999
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_EMOJI 13000
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_HIGHLIGHTER 13001
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_UNDO 13002
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_REDO 13003
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_IN 13004
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_OUT 13005
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_COMMIT_CROP 13006
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_COMMIT_CROP 13007
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_CANCEL_CROP 13008
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CANCEL_CROP 13009
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_DOWNLOAD_IMAGE 13010
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_COPY 13011
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TITLE 13012
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_TEXT_CLEAR 13013
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_LEFT 13014
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_CENTER 13015
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_RIGHT 13016
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_NONE 13017
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_SMALL 13018
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_LARGE 13019
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_DEFAULT 13020
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_MONOSPACE 13021
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_ITALIC 13022
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_OUTLINE 13023
#define IDS_CONTEXT_MENU_PASTE_FROM_CLIPBOARD 13024
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT_UNKNOWN_DEVICE 13025
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT 13026
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT_UNKNOWN_DEVICE 13027
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT 13028
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_DESCRIPTION 13029
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_MULTIPLE_DEVICES 13030
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_SINGLE_DEVICE 13031
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_MULTIPLE_DEVICES 13032
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_SINGLE_DEVICE 13033
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE_UNKNOWN_DEVICE 13034
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE 13035
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_DESCRIPTION 13036
#define IDS_OMNIBOX_TOOLTIP_SHARED_CLIPBOARD 13037
#define IDS_COLLECTED_COOKIES_DIALOG_TITLE 13038
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_LABEL 13039
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_LABEL 13040
#define IDS_COLLECTED_COOKIES_BLOCKED_THIRD_PARTY_BLOCKING_ENABLED 13041
#define IDS_COLLECTED_COOKIES_ALLOW_BUTTON 13042
#define IDS_COLLECTED_COOKIES_SESSION_ONLY_BUTTON 13043
#define IDS_COLLECTED_COOKIES_BLOCK_BUTTON 13044
#define IDS_COLLECTED_COOKIES_ALLOW_RULE_CREATED 13045
#define IDS_COLLECTED_COOKIES_BLOCK_RULE_CREATED 13046
#define IDS_COLLECTED_COOKIES_SESSION_RULE_CREATED 13047
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_TAB_LABEL 13048
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_TAB_LABEL 13049
#define IDS_COLLECTED_COOKIES_ALLOWED_AUX_TEXT 13050
#define IDS_COLLECTED_COOKIES_BLOCKED_AUX_TEXT 13051
#define IDS_COLLECTED_COOKIES_CLEAR_ON_EXIT_AUX_TEXT 13052
#define IDS_COLLECTED_COOKIES_INFOBAR_MESSAGE 13053
#define IDS_COLLECTED_COOKIES_INFOBAR_BUTTON 13054
#define IDS_COLLECTED_COOKIES_PARTITIONED_COOKIE 13055
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_TITLE 13056
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SUBTITLE 13057
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SETTINGS_LINK 13058
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_TITLE 13059
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_SUBTITLE 13060
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_TITLE 13061
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_SUBTITLE 13062
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_EMPTY_STATE_LABEL 13063
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_RELATED_APPS_TITLE 13064
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_RELATED_APPS_SUBTITLE 13065
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_RELATED_APPS_SETTINGS_LINK_TOOLTIP 13066
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_MENU_ITEM 13067
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_THIRD_PARTY_MENU_ITEM 13068
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCK_MENU_ITEM 13069
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_MENU_ITEM 13070
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOWED_STATE_SUBTITLE 13071
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCKED_STATE_SUBTITLE 13072
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_STATE_SUBTITLE 13073
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_STATE_SUBTITLE 13074
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_SESSION_ONLY_STATE_SUBTITLE 13075
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_CONTEXT_MENU_TOOLTIP 13076
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_DELETE_BUTTON_TOOLTIP 13077
#define IDS_ACCNAME_INFOBAR_CONTAINER 476
#define IDS_ACCNAME_INFOBAR 13078
#define IDS_ONE_CLICK_BUBBLE_UNDO 13079
#define IDS_ONE_CLICK_SIGNIN_BUBBLE_MESSAGE 13080
#define IDS_ONE_CLICK_SIGNIN_DIALOG_OK_BUTTON 13081
#define IDS_ONE_CLICK_SIGNIN_DIALOG_UNDO_BUTTON 13082
#define IDS_ONE_CLICK_SIGNIN_DIALOG_ADVANCED 13083
#define IDS_ENTERPRISE_SIGNIN_CANCEL 13084
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_PROFILE 13085
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_WORK_PROFILE 13086
#define IDS_ENTERPRISE_SIGNIN_CONTINUE 13087
#define IDS_ENTERPRISE_SIGNIN_ALERT 13088
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_TITLE 13089
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_DESCRIPTION 13090
#define IDS_MANAGED_WITH_HYPERLINK 13093
#define IDS_MANAGED_BY_WITH_HYPERLINK 13094
#define IDS_PROFILE_MANAGED_BY_WITH_HYPERLINK 13095
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_WITH_HYPERLINK 13096
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_WITH_HYPERLINK 13097
#define IDS_BROWSER_AND_PROFILE_SAME_MANAGED_BY_WITH_HYPERLINK 13098
#define IDS_MANAGED_BY_PARENT_WITH_HYPERLINK 13099
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_TOOLTIP 13100
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_TOOLTIP 13101
#define IDS_COOKIES_COOKIE_EXPIRES_SESSION 13102
#define IDS_COOKIES_COOKIE_SENDFOR_ANY 13103
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE 13104
#define IDS_COOKIES_COOKIE_SENDFOR_SAME_SITE 13105
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE_SAME_SITE 13106
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_YES 13107
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_NO 13108
#define IDS_COOKIES_COOKIES 13109
#define IDS_COOKIES_WEB_DATABASES 13110
#define IDS_COOKIES_LOCAL_STORAGE 13111
#define IDS_COOKIES_SESSION_STORAGE 13112
#define IDS_COOKIES_INDEXED_DBS 13113
#define IDS_COOKIES_FILE_SYSTEMS 13114
#define IDS_COOKIES_FILE_SYSTEM_USAGE_NONE 13115
#define IDS_COOKIES_SERVICE_WORKER 13116
#define IDS_COOKIES_SERVICE_WORKERS 13117
#define IDS_COOKIES_SHARED_WORKERS 13118
#define IDS_COOKIES_CACHE_STORAGE 13119
#define IDS_APP_DEFAULT_PAGE_NAME 13120
#define IDS_APP_LAUNCHER_TAB_TITLE 13121
#define IDS_NEW_TAB_GUEST_SESSION_HEADING 13122
#define IDS_NEW_TAB_GUEST_SESSION_DESCRIPTION 13123
#define IDS_NEW_TAB_GUEST_SESSION_LEARN_MORE_ACCESSIBILITY_TEXT 13124
#define IDS_NEW_TAB_ENTERPRISE_GUEST_SESSION_LEARN_MORE_ACCESSIBILITY_TEXT 13125
#define IDS_NEW_TAB_TILE_GRID_ACCESSIBLE_DESCRIPTION 13126
#define IDS_NEW_TAB_APP_INSTALL_HINT_LABEL 13127
#define IDS_NEW_TAB_MOST_VISITED 13128
#define IDS_NEW_TAB_RESTORE_THUMBNAILS_SHORT_LINK 501
#define IDS_NEW_TAB_ATTRIBUTION_INTRO 568
#define IDS_NEW_TAB_THUMBNAIL_REMOVED_NOTIFICATION 13129
#define IDS_NEW_TAB_REMOVE_THUMBNAIL_TOOLTIP 13130
#define IDS_NEW_TAB_PAGE_SWITCHER_CHANGE_TITLE 13131
#define IDS_NEW_TAB_PAGE_SWITCHER_SAME_TITLE 13132
#define IDS_NEW_TAB_VOICE_AUDIO_ERROR 528
#define IDS_NEW_TAB_VOICE_CLOSE_TOOLTIP 529
#define IDS_NEW_TAB_VOICE_DETAILS 530
#define IDS_NEW_TAB_VOICE_LANGUAGE_ERROR 531
#define IDS_NEW_TAB_VOICE_LISTENING 533
#define IDS_NEW_TAB_VOICE_NETWORK_ERROR 534
#define IDS_NEW_TAB_VOICE_NO_TRANSLATION 535
#define IDS_NEW_TAB_VOICE_NO_VOICE 536
#define IDS_NEW_TAB_VOICE_OTHER_ERROR 537
#define IDS_NEW_TAB_VOICE_PERMISSION_ERROR 538
#define IDS_NEW_TAB_VOICE_LEARN_MORE_ACCESSIBILITY_LABEL 532
#define IDS_NEW_TAB_VOICE_READY 539
#define IDS_NEW_TAB_VOICE_TRY_AGAIN 540
#define IDS_NEW_TAB_VOICE_WAITING 542
#define IDS_NEW_TAB_VOICE_SEARCH_CLOSED 13133
#define IDS_NEW_TAB_APP_OPTIONS 13134
#define IDS_NEW_TAB_APP_DETAILS 13135
#define IDS_NEW_TAB_APP_CREATE_SHORTCUT 13136
#define IDS_NEW_TAB_APP_INSTALL_LOCALLY 13137
#define IDS_APP_CONTEXT_MENU_SHOW_INFO 13138
#define IDS_APP_CONTEXT_MENU_OPEN_PINNED 13139
#define IDS_APP_CONTEXT_MENU_OPEN_REGULAR 13140
#define IDS_APP_CONTEXT_MENU_OPEN_WINDOW 13141
#define IDS_APP_CONTEXT_MENU_OPEN_FULLSCREEN 13142
#define IDS_APP_CONTEXT_MENU_OPEN_MAXIMIZED 13143
#define IDS_APP_CONTEXT_MENU_OPEN_TAB 13144
#define IDS_APP_CONTEXT_MENU_RUN_ON_OS_LOGIN 13149
#define IDS_APPS_PAGE_DEPRECATED_APP_TITLE 13152
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_TITLE 13153
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_PROCEED_BUTTON 13154
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_CANCEL_BUTTON 13155
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_BODY_TEXT 13156
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_DEFAULT_BODY_TEXT 13157
#define IDS_SYNC_CONFIRMATION_SETTINGS_INFO 13158
#define IDS_SYNC_CONFIRMATION_CONFIRM_BUTTON_LABEL 13159
#define IDS_SYNC_CONFIRMATION_SETTINGS_BUTTON_LABEL 13160
#define IDS_SYNC_CONFIRMATION_REFRESHED_SETTINGS_BUTTON_LABEL 13161
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_TITLE 13162
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE 13163
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE_SIGNIN_INTERCEPT_V2 13164
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_BOOKMARKS 13165
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_READING_LIST 13166
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_AUTOFILL 13167
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_EXTENSIONS 13168
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_HISTORY_AND_MORE 13169
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_DESC 13170
#define IDS_SYNC_CONFIRMATION_WELCOME_TITLE_SIGNIN_INTERCEPT 13171
#define IDS_SYNC_CONFIRMATION_TURN_ON_SYNC_BUTTON_LABEL 13172
#define IDS_SYNC_DISABLED_CONFIRMATION_CHROME_SYNC_TITLE 13173
#define IDS_SYNC_DISABLED_CONFIRMATION_DETAILS 13174
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_LABEL 13175
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_MANAGED_ACCOUNT_SIGNOUT_DISALLOWED_LABEL 13176
#define IDS_SYNC_DISABLED_CONFIRMATION_UNDO_BUTTON_LABEL 13177
#define IDS_SYNC_LOADING_CONFIRMATION_TITLE 13178
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL 13179
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_AVATAR_BUTTON_SEPARATE_BROWSING_TEXT 13180
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_AVATAR_BUTTON_SWITCH_PROFILE_TEXT 13181
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CREATE_PROFILE_BUTTON_LABEL 13182
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_STAY_HERE_BUTTON_LABEL 13183
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_TITLE_SUPERVISED 13184
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_BUTTON_LABEL 13185
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_SWITCH_BUTTON_LABEL 13186
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CONFIRM_SWITCH_BUTTON_LABEL 13187
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_DESC_SUPERVISED 13188
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_CONTINUE_BUTTON_LABEL 13189
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_ACCEPT_TEXT 13190
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC 13191
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_BY_TOKEN 13192
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_DISCLAIMER 13193
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_BY_DISCLAIMER 13194
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_TITLE_SIGNIN_REMINDER 13195
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CHROME_SIGNIN_IPH_OK_BUTTON 13196
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_TITLE 13197
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_SIGNOUT_BUTTON 13198
#define IDS_CHROME_SIGNOUT_CONFIRMATION_PROMPT_DELETE_AND_SIGNOUT_BUTTON 13199
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_TEXT_LINK 13200
#define IDS_SYNC_PASSPHRASE_DIALOG_FOOTER_LINK 13201
#define IDS_SYNC_PASSPHRASE_DIALOG_TITLE 13202
#define IDS_SYNC_PASSPHRASE_DIALOG_OK_BUTTON 13203
#define IDS_CLOSE_WARNING_FOR_CLEAR_COOKIES_ON_EXIT_CLOSE 13204
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_PROFILE_NAME 13205
#define IDS_SIGNIN_ERROR_TITLE 13206
#define IDS_SIGNIN_ERROR_EMAIL_TITLE 13207
#define IDS_SIGNIN_ERROR_CLOSE_BUTTON_LABEL 13208
#define IDS_SIGNIN_ERROR_OK_BUTTON_LABEL 13209
#define IDS_SIGNIN_ERROR_SWITCH_BUTTON_LABEL 13210
#define IDS_SIGNIN_ACCESSIBLE_CLOSE_BUTTON 13211
#define IDS_SIGNIN_ACCESSIBLE_BACK_BUTTON 13212
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_TITLE 13213
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_SUBTITLE 13214
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_TITLE 13215
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_SUBTITLE 13216
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CLOSE_BUTTON_LABEL 13217
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CONFIRM_BUTTON_LABEL 13218
#define IDS_PLUGIN_CRASHED_PROMPT 13219
#define IDS_PLUGIN_DISCONNECTED_PROMPT 13220
#define IDS_RELOAD_PAGE_WITH_PLUGIN 13221
#define IDS_PLUGIN_INITIALIZATION_ERROR_PROMPT 13222
#define IDS_EXTERNAL_PROTOCOL_TITLE 13223
#define IDS_EXTERNAL_PROTOCOL_MESSAGE_WITH_INITIATING_ORIGIN 13224
#define IDS_EXTERNAL_PROTOCOL_MESSAGE 13225
#define IDS_EXTERNAL_PROTOCOL_OK_BUTTON_TEXT 13226
#define IDS_EXTERNAL_PROTOCOL_CANCEL_BUTTON_TEXT 13227
#define IDS_EXTERNAL_PROTOCOL_CHECKBOX_PER_ORIGIN_TEXT 13228
#define IDS_DIRECTORY_LISTING_HEADER 13230
#define IDS_DIRECTORY_LISTING_PARENT 13231
#define IDS_DIRECTORY_LISTING_NAME 13232
#define IDS_DIRECTORY_LISTING_SIZE 13233
#define IDS_DIRECTORY_LISTING_DATE_MODIFIED 13234
#define IDS_SAVE_PAGE_DESC_HTML_ONLY 13235
#define IDS_SAVE_PAGE_DESC_SINGLE_FILE 13236
#define IDS_SAVE_PAGE_DESC_COMPLETE 13237
#define IDS_PROFILE_ERROR_DIALOG_TITLE 13238
#define IDS_COULDNT_OPEN_PROFILE_ERROR 13239
#define IDS_OPEN_PROFILE_DATA_LOSS 13240
#define IDS_PROFILE_ERROR_DIALOG_CHECKBOX 13241
#define IDS_PROFILE_ERROR_FEEDBACK_DESCRIPTION 13242
#define IDS_COULDNT_STARTUP_PROFILE_ERROR 13243
#define IDS_REFUSE_TO_RUN_AS_ROOT 13244
#define IDS_REFUSE_TO_RUN_AS_ROOT_2 13245
#define IDS_PROFILE_ON_NETWORK_WARNING 13246
#define IDS_CANT_WRITE_USER_DIRECTORY_TITLE 13247
#define IDS_RECENT_TABS_MENU 13248
#define IDS_RECENTLY_CLOSED_WINDOW 13249
#define IDS_RECENTLY_CLOSED_GROUP 13250
#define IDS_RECENTLY_CLOSED_GROUP_UNNAMED 13251
#define IDS_RECENT_TABS_NO_DEVICE_TABS 13252
#define IDS_RECENT_TABS_LOGIN_FOR_DEVICE_TABS 13253
#define IDS_HISTORY_MENU 13254
#define IDS_DEFAULT_DOWNLOAD_FILENAME 13255
#define IDS_DEFAULT_BROWSER_INFOBAR_OK_BUTTON_LABEL 13257
#define IDS_USED_EXISTING_BROWSER 13263
#define IDS_DECLINE_RECOVERY 13264
#define IDS_SYNC_ACCOUNT_SYNCING 13265
#define IDS_SYNC_ACCOUNT_SYNCING_CUSTOM_DATA_TYPES 13266
#define IDS_SIGNIN_ERROR_DISPLAY_SOURCE 13267
#define IDS_SIGNIN_ERROR_BUBBLE_VIEW_TITLE 13268
#define IDS_SYNC_ERROR_BUBBLE_VIEW_TITLE 13269
#define IDS_SYNC_ERROR_PASSWORDS_BUBBLE_VIEW_TITLE 13270
#define IDS_SYNC_ERROR_USER_MENU_TITLE 13271
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE 13272
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_ERROR_DESCRIPTION 13273
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE_SIGNED_IN_ONLY 13274
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_EVERYTHING_USER_MENU_TITLE 13275
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_MENU_ERROR_DESCRIPTION 13276
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_MENU_TITLE 13277
#define IDS_SYNC_NEEDS_VERIFICATION_BUBBLE_VIEW_TITLE 13278
#define IDS_SIGNIN_PAUSED_USER_MENU_VERIFY_MESSAGE 13279
#define IDS_SYNC_ERROR_USER_MENU_SIGNIN_BUTTON 13280
#define IDS_SYNC_ERROR_USER_MENU_PASSPHRASE_BUTTON 13281
#define IDS_SYNC_ERROR_USER_MENU_RETRIEVE_KEYS_BUTTON 13282
#define IDS_SYNC_ERROR_USER_MENU_CONFIRM_SYNC_SETTINGS_BUTTON 13283
#define IDS_SYNC_ERROR_USER_MENU_SIGNOUT_BUTTON 13284
#define IDS_SYNC_EMPTY_STRING 13290
#define IDS_SYNC_OVERVIEW 13291
#define IDS_SYNC_START_SYNC_BUTTON_LABEL 13292
#define IDS_SIGNED_IN_WITH_SYNC_DISABLED_BY_POLICY 13293
#define IDS_SYNC_SETTINGS_NOT_CONFIRMED 13295
#define IDS_SYNC_SETUP_IN_PROGRESS 13296
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR 13297
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR_NEEDS_SIGNOUT 13298
#define IDS_SYNC_STATUS_NEEDS_PASSWORD 13299
#define IDS_SYNC_STATUS_NEEDS_PASSWORD_BUTTON 13300
#define IDS_SYNC_STATUS_NEEDS_KEYS_BUTTON 13301
#define IDS_SYNC_RELOGIN_ERROR 13302
#define IDS_SYNC_RELOGIN_BUTTON 13303
#define IDS_SYNC_ADVANCED_OPTIONS 13308
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM 13310
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM_WITH_DATE 13311
#define IDS_PARTIAL_TRANSLATE_BUBBLE_WAITING_TITLE 13312
#define IDS_TRANSLATE_BUBBLE_BEFORE_TRANSLATE_TITLE 13313
#define IDS_TRANSLATE_BUBBLE_TRANSLATED_TITLE 13314
#define IDS_PARTIAL_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 13315
#define IDS_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 13316
#define IDS_TRANSLATE_BUBBLE_SOURCE_LANG_COMBOBOX_ACCNAME 13317
#define IDS_TRANSLATE_BUBBLE_TARGET_LANG_COMBOBOX_ACCNAME 13318
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_COMPLETE_ANNOUNCEMENT 13319
#define IDS_TRANSLATE_BUBBLE_ADVANCED_BUTTON 13320
#define IDS_TRANSLATE_BUBBLE_ADVANCED_MENU_BUTTON 13321
#define IDS_TRANSLATE_BUBBLE_CHANGE_TARGET_LANGUAGE 13322
#define IDS_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 13323
#define IDS_TRANSLATE_BUBBLE_OPEN_LANGUAGE_SETTINGS 13324
#define IDS_PARTIAL_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 13325
#define IDS_TRANSLATE_BUBBLE_ACCEPT 13326
#define IDS_TRANSLATE_BUBBLE_DENY 13327
#define IDS_TRANSLATE_BUBBLE_ALWAYS_TRANSLATE_LANG 13328
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_LANG 13329
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_SITE 13330
#define IDS_TRANSLATE_BUBBLE_TRANSLATING 13331
#define IDS_TRANSLATE_BUBBLE_REVERT 13332
#define IDS_TRANSLATE_BUBBLE_TRY_AGAIN 13333
#define IDS_TRANSLATE_BUBBLE_ALWAYS 13334
#define IDS_TRANSLATE_BUBBLE_OPTIONS_MENU_BUTTON 13335
#define IDS_TRANSLATE_BUBBLE_PAGE_LANGUAGE 13336
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_LANGUAGE 13337
#define IDS_TRANSLATE_BUBBLE_ADVANCED_TARGET 13338
#define IDS_TRANSLATE_BUBBLE_ADVANCED_SOURCE 13339
#define IDS_PARTIAL_TRANSLATE_BUBBLE_ADVANCED_SOURCE 13340
#define IDS_PARTIAL_TRANSLATE_BUBBLE_TRANSLATE_FULL_PAGE 13341
#define IDS_TRANSLATE_BUBBLE_RESET 13342
#define IDS_NOTIFICATION_BUTTON_SETTINGS 13343
#define IDS_NOTIFICATION_BUTTON_CLOSE 13344
#define IDS_NOTIFICATION_BUTTON_MORE 13345
#define IDS_NOTIFICATION_REPLY_PLACEHOLDER 13346
#define IDS_NOTIFICATION_MUTED_MESSAGE 13347
#define IDS_NOTIFICATION_MUTED_TITLE 13348
#define IDS_NOTIFICATION_MUTED_ACTION_SHOW 13349
#define IDS_NOTIFICATION_MUTED_ACTION_SNOOZE 13350
#define IDS_ALLOWED_GEOLOCATION_TITLE 13493
#define IDS_BLOCKED_GEOLOCATION_TITLE 13494
#define IDS_ALLOWED_GEOLOCATION_MESSAGE 13495
#define IDS_ALLOWED_GEOLOCATION_BLOCK 13496
#define IDS_ALLOWED_GEOLOCATION_NO_ACTION 13497
#define IDS_BLOCKED_GEOLOCATION_MESSAGE 13498
#define IDS_BLOCKED_GEOLOCATION_UNBLOCK 13499
#define IDS_BLOCKED_GEOLOCATION_NO_ACTION 13500
#define IDS_GEOLOCATION 13501
#define IDS_GEOLOCATION_WILL_ASK_AGAIN 13502
#define IDS_GEOLOCATION_TURNED_OFF_IN_OS 13503
#define IDS_GEOLOCATION_TURNED_OFF 13504
#define IDS_ALLOWED_MIDI_SYSEX_TITLE 13505
#define IDS_BLOCKED_MIDI_SYSEX_TITLE 13506
#define IDS_ALLOWED_MIDI_SYSEX_MESSAGE 13507
#define IDS_ALLOWED_MIDI_SYSEX_BLOCK 13508
#define IDS_ALLOWED_MIDI_SYSEX_NO_ACTION 13509
#define IDS_BLOCKED_MIDI_SYSEX_MESSAGE 13510
#define IDS_BLOCKED_MIDI_SYSEX_UNBLOCK 13511
#define IDS_BLOCKED_MIDI_SYSEX_NO_ACTION 13512
#define IDS_MICROPHONE_CAMERA_ALLOWED 13513
#define IDS_MICROPHONE_CAMERA_BLOCKED 13514
#define IDS_MICROPHONE_ACCESSED 13515
#define IDS_CAMERA_ACCESSED 13516
#define IDS_MICROPHONE_BLOCKED 13517
#define IDS_CAMERA_BLOCKED 13518
#define IDS_MICROPHONE_CAMERA_ALLOWED_TITLE 13519
#define IDS_MICROPHONE_CAMERA_BLOCKED_TITLE 13520
#define IDS_MICROPHONE_ACCESSED_TITLE 13521
#define IDS_CAMERA_ACCESSED_TITLE 13522
#define IDS_MICROPHONE_BLOCKED_TITLE 13523
#define IDS_CAMERA_BLOCKED_TITLE 13524
#define IDS_MEDIASTREAM_SETTING_CHANGED_MESSAGE 13525
#define IDS_TURNED_OFF 13533
#define IDS_OPEN_SETTINGS_LINK 13534
#define IDS_A11Y_OMNIBOX_CHIP_HINT 443
#define IDS_A11Y_INDICATORS_ANNOUNCEMENT 13535
#define IDS_MICROPHONE_CAMERA_IN_USE 13536
#define IDS_MICROPHONE_CAMERA_NOT_ALLOWED 13537
#define IDS_MICROPHONE_IN_USE 13538
#define IDS_CAMERA_IN_USE 13539
#define IDS_MICROPHONE_NOT_ALLOWED 13540
#define IDS_CAMERA_NOT_ALLOWED 13541
#define IDS_CAMERA_CANNOT_ACCESS 13542
#define IDS_MICROPHONE_CANNOT_ACCESS 13543
#define IDS_CAMERA_MICROPHONE_CANNOT_ACCESS 13544
#define IDS_MANAGE_PASSWORDS_CONFIRM_GENERATED_TEXT 13545
#define IDS_PASSWORDS_WEB_LINK 13546
#define IDS_MANAGE_PASSWORDS_LINK 13548
#define IDS_MANAGE_PASSWORDS_TITLE 13549
#define IDS_MANAGE_PASSWORDS_NO_PASSWORDS_TITLE 13550
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_TITLE 13551
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_NO_PASSWORDS_TITLE 13552
#define IDS_MANAGE_PASSWORDS_SHOW_PASSWORD 13553
#define IDS_MANAGE_PASSWORDS_HIDE_PASSWORD 13554
#define IDS_MANAGE_PASSWORDS_EMPTY_NOTE 13555
#define IDS_MANAGE_PASSWORDS_EDIT_USERNAME_TOOLTIP 13556
#define IDS_MANAGE_PASSWORDS_EDIT_NOTE_TOOLTIP 13557
#define IDS_MANAGE_PASSWORDS_NOTE_ACCESSIBLE_NAME 13558
#define IDS_MANAGE_PASSWORDS_NOTE_TEXTFIELD 13559
#define IDS_MANAGE_PASSWORDS_UPDATE 13560
#define IDS_MANAGE_PASSWORDS_USERNAME_ACCESSIBLE_NAME 13561
#define IDS_MANAGE_PASSWORDS_USERNAME_TEXTFIELD 13562
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE_MD 13563
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_MANY_DEVICES 13564
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_LOCAL_DEVICE 13565
#define IDS_AUTO_SIGNIN_FIRST_RUN_TEXT 13566
#define IDS_AUTO_SIGNIN_FIRST_RUN_OK 13567
#define IDS_FILE_SELECTION_DIALOG_INFOBAR 13576
#define IDS_IMAGE_FILES 13579
#define IDS_AUDIO_FILES 13580
#define IDS_VIDEO_FILES 13581
#define IDS_CUSTOM_FILES 13582
#define IDS_SENSORS_ALLOWED_TOOLTIP 13583
#define IDS_MOTION_SENSORS_ALLOWED_TOOLTIP 13584
#define IDS_SENSORS_BLOCKED_TOOLTIP 13585
#define IDS_MOTION_SENSORS_BLOCKED_TOOLTIP 13586
#define IDS_BLOCKED_SENSORS_UNBLOCK 13587
#define IDS_BLOCKED_SENSORS_NO_ACTION 13588
#define IDS_ALLOWED_SENSORS_TITLE 13589
#define IDS_BLOCKED_SENSORS_TITLE 13590
#define IDS_ALLOWED_SENSORS_MESSAGE 13591
#define IDS_ALLOWED_MOTION_SENSORS_MESSAGE 13592
#define IDS_BLOCKED_SENSORS_MESSAGE 13593
#define IDS_BLOCKED_MOTION_SENSORS_MESSAGE 13594
#define IDS_ALLOWED_SENSORS_NO_ACTION 13595
#define IDS_ALLOWED_SENSORS_BLOCK 13596
#define IDS_LIVE_CAPTION_PROMO 13603
#define IDS_LIVE_CAPTION_PROMO_SCREENREADER 13604
#define IDS_ENABLE_CARET_BROWSING_INFO 13605
#define IDS_CARET_BROWSING_DO_NOT_ASK 13612
#define IDS_ENABLE_CARET_BROWSING_TITLE 13613
#define IDS_ENABLE_CARET_BROWSING_TURN_ON 13614
#define IDS_MEDIA_GALLERIES_DIALOG_HEADER 13615
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_WRITE 13616
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_DELETE 13617
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_ONLY 13618
#define IDS_MEDIA_GALLERIES_PERMISSION_SUGGESTIONS 13619
#define IDS_MEDIA_GALLERIES_LAST_ATTACHED 13620
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY 13621
#define IDS_MEDIA_GALLERIES_DIALOG_CONFIRM 13622
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY_TITLE 13623
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_ATTACHED 13624
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_NOT_ATTACHED 13625
#define IDS_MEDIA_GALLERIES_DIALOG_DELETE 13626
#define IDS_CHROME_SHORTCUT_DESCRIPTION 13648
#define IDS_WEBSTORE_NAME_STORE 378
#define IDS_DESKTOP_MEDIA_PICKER_TITLE 13649
#define IDS_DISPLAY_MEDIA_PICKER_TITLE 13650
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_SCREEN_ONLY 13651
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WINDOW_ONLY 13652
#define IDS_DESKTOP_MEDIA_PICKER_TEXT 13653
#define IDS_DISPLAY_MEDIA_PICKER_TEXT 13654
#define IDS_DESKTOP_MEDIA_PICKER_TEXT_DELEGATED 13655
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_SCREEN_WITH_MUTE_WARNING 13656
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_SYSTEM_AUDIO 13657
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_TAB_AUDIO 13658
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB 13659
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB_OR_SCREEN 13660
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_SCREEN 13661
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_WINDOW 13662
#define IDS_DESKTOP_MEDIA_PICKER_SINGLE_SCREEN_NAME 13663
#define IDS_DESKTOP_MEDIA_PICKER_MULTIPLE_SCREEN_NAME 13664
#define IDS_DESKTOP_MEDIA_PICKER_MANAGED 13665
#define IDS_DESKTOP_MEDIA_PICKER_PERMISSION_BUTTON_MAC 13666
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_SCREEN 13667
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_WINDOW 13668
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_THIS_TAB 13669
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_OTHER_TAB 13670
#define IDS_DESKTOP_MEDIA_PICKER_EMPTY_PREVIEW 13671
#define IDS_DESKTOP_MEDIA_PICKER_PREVIEW_ACCESSIBLE_NAME 13672
#define IDS_DESKTOP_MEDIA_SOURCE_EMPTY_ACCESSIBLE_NAME 13673
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_WINDOW_TEXT 13674
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_WINDOW_BUTTON 13675
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_SCREEN_TEXT 13676
#define IDS_DESKTOP_MEDIA_PICKER_DELEGATED_SOURCE_LIST_SCREEN_BUTTON 13677
#define IDS_SHARE_THIS_TAB_DIALOG_TITLE 13678
#define IDS_SHARE_THIS_TAB_DIALOG_TEXT 13679
#define IDS_SHARE_THIS_TAB_DIALOG_ALLOW 13680
#define IDS_SHARE_THIS_TAB_AUDIO_SHARE 13681
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TITLE 13682
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TEXT 13683
#define IDS_TOOLTIP_TAB_ALERT_STATE_MEDIA_RECORDING 13684
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_RECORDING 13685
#define IDS_TOOLTIP_TAB_ALERT_STATE_VIDEO_RECORDING 13686
#define IDS_TOOLTIP_TAB_ALERT_STATE_TAB_CAPTURING 13687
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_PLAYING 13688
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_MUTING 13689
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_CONNECTED 13690
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_SCAN_ACTIVE 13691
#define IDS_TOOLTIP_TAB_ALERT_STATE_USB_CONNECTED 13692
#define IDS_TOOLTIP_TAB_ALERT_STATE_HID_CONNECTED 13693
#define IDS_TOOLTIP_TAB_ALERT_STATE_SERIAL_CONNECTED 13694
#define IDS_TOOLTIP_TAB_ALERT_STATE_PIP_PLAYING 13695
#define IDS_TOOLTIP_TAB_ALERT_STATE_DESKTOP_CAPTURING 13696
#define IDS_TOOLTIP_TAB_ALERT_STATE_VR_PRESENTING 13697
#define IDS_TAB_AX_LABEL_MEDIA_RECORDING_FORMAT 13698
#define IDS_TAB_AX_LABEL_AUDIO_RECORDING_FORMAT 13699
#define IDS_TAB_AX_LABEL_VIDEO_RECORDING_FORMAT 13700
#define IDS_TAB_AX_LABEL_TAB_CAPTURING_FORMAT 13701
#define IDS_TAB_AX_LABEL_PIP_PLAYING_FORMAT 13702
#define IDS_TAB_AX_LABEL_AUDIO_PLAYING_FORMAT 13703
#define IDS_TAB_AX_LABEL_AUDIO_MUTING_FORMAT 13704
#define IDS_TAB_AX_LABEL_BLUETOOTH_CONNECTED_FORMAT 13705
#define IDS_TAB_AX_LABEL_BLUETOOTH_SCAN_ACTIVE_FORMAT 13706
#define IDS_TAB_AX_LABEL_USB_CONNECTED_FORMAT 13707
#define IDS_TAB_AX_LABEL_HID_CONNECTED_FORMAT 13708
#define IDS_TAB_AX_LABEL_SERIAL_CONNECTED_FORMAT 13709
#define IDS_TAB_AX_LABEL_NETWORK_ERROR_FORMAT 13710
#define IDS_TAB_AX_LABEL_CRASHED_FORMAT 13711
#define IDS_TAB_AX_LABEL_DESKTOP_CAPTURING_FORMAT 13712
#define IDS_TAB_AX_LABEL_VR_PRESENTING 13713
#define IDS_TAB_AX_LABEL_UNNAMED_GROUP_FORMAT 13714
#define IDS_TAB_AX_LABEL_NAMED_GROUP_FORMAT 13715
#define IDS_TAB_AX_LABEL_PINNED_FORMAT 13716
#define IDS_TAB_AX_LABEL_PERMISSION_REQUESTED_FORMAT 13717
#define IDS_GROUP_AX_LABEL_UNNAMED_GROUP_FORMAT 13718
#define IDS_GROUP_AX_LABEL_NAMED_GROUP_FORMAT 13719
#define IDS_GROUP_AX_LABEL_COLLAPSED 13720
#define IDS_GROUP_AX_LABEL_EXPANDED 13721
#define IDS_GROUP_AX_LABEL_UNNAMED_SAVED_GROUP_FORMAT 13722
#define IDS_GROUP_AX_LABEL_NAMED_SAVED_GROUP_FORMAT 13723
#define IDS_SAVED_GROUP_AX_LABEL_OPENED 13724
#define IDS_SAVED_GROUP_AX_LABEL_CLOSED 13725
#define IDS_TAB_AX_ANNOUNCE_MOVED_RIGHT 13726
#define IDS_TAB_AX_ANNOUNCE_MOVED_LEFT 13727
#define IDS_TAB_AX_ANNOUNCE_MOVED_FIRST 13728
#define IDS_TAB_AX_ANNOUNCE_MOVED_LAST 13729
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_UNNAMED_GROUP 13730
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_NAMED_GROUP 13731
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_UNNAMED_GROUP 13732
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_NAMED_GROUP 13733
#define IDS_PAGE_LOADING_AX_TITLE_FORMAT 13734
#define IDS_TAB_AX_INACTIVE_TAB 13735
#define IDS_TAB_AX_MEMORY_SAVINGS 13736
#define IDS_TAB_AX_MEMORY_USAGE 13737
#define IDS_TAB_AX_HIGH_MEMORY_USAGE 13738
#define IDS_PROFILE_IN_USE_LINUX_QUIT 13739
#define IDS_PROFILE_IN_USE_LINUX_RELAUNCH 13740
#define IDS_DESKTOP_MEDIA_PICKER_SHARE 13758
#define IDS_PUSH_MESSAGING_GENERIC_NOTIFICATION_BODY 13759
#define IDS_DEVICE_PERMISSIONS_DIALOG_SELECT 13760
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL 13761
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL_TOOLTIP 13762
#define IDS_DEVICE_LOG_TITLE 13763
#define IDS_DEVICE_AUTO_REFRESH 13764
#define IDS_DEVICE_SELECT_TYPES 13765
#define IDS_DEVICE_LOG_REFRESH 13766
#define IDS_DEVICE_LOG_CLEAR 13767
#define IDS_DEVICE_LOG_CLEAR_TYPES 13768
#define IDS_DEVICE_LOG_NO_ENTRIES 13769
#define IDS_DEVICE_LOG_LEVEL_LABEL 13770
#define IDS_DEVICE_LOG_LEVEL_ERROR 13771
#define IDS_DEVICE_LOG_LEVEL_USER 13772
#define IDS_DEVICE_LOG_LEVEL_EVENT 13773
#define IDS_DEVICE_LOG_LEVEL_DEBUG 13774
#define IDS_DEVICE_LOG_TYPE_LOGIN 13775
#define IDS_DEVICE_LOG_TYPE_NETWORK 13776
#define IDS_DEVICE_LOG_TYPE_POWER 13777
#define IDS_DEVICE_LOG_TYPE_BLUETOOTH 13778
#define IDS_DEVICE_LOG_TYPE_USB 13779
#define IDS_DEVICE_LOG_TYPE_HID 13780
#define IDS_DEVICE_LOG_TYPE_PRINTER 13781
#define IDS_DEVICE_LOG_TYPE_FIDO 13782
#define IDS_DEVICE_LOG_TYPE_SERIAL 13783
#define IDS_DEVICE_LOG_TYPE_CAMERA 13784
#define IDS_DEVICE_LOG_TYPE_GEOLOCATION 13785
#define IDS_DEVICE_LOG_TYPE_EXTENSIONS 13786
#define IDS_DEVICE_LOG_TYPE_DISPLAY 13787
#define IDS_DEVICE_LOG_TYPE_FIRMWARE 13788
#define IDS_DEVICE_LOG_FILEINFO 13789
#define IDS_DEVICE_LOG_TIME_DETAIL 13790
#define IDS_DEVICE_LOG_ENTRY 13791
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION 13792
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION_TITLE 13793
#define IDS_WEBHID_SYSTEM_TRAY_ICON_HID_SETTINGS 13794
#define IDS_WEBHID_SYSTEM_TRAY_ICON_ABOUT_HID_DEVICE 13795
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_USB_SETTINGS 13796
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_ABOUT_USB_DEVICE 13797
#define IDS_DEVICE_CONNECTED_BY_EXTENSION 13800
#define IDS_DEFAULT_AUDIO_DEVICE_NAME 13809
#define IDS_COMMUNICATIONS_AUDIO_DEVICE_NAME 13810
#define IDS_SERIAL_DEVICE_CHOOSER_ADAPTER_OFF 13811
#define IDS_SERIAL_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 13812
#define IDS_SERIAL_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 13813
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN 13814
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN_TOOLTIP 13815
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_SCANNING_STATUS 13816
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_RE_SCAN_LINK 13817
#define IDS_DEVICE_CHOOSER_PAIRED_STATUS_TEXT 13818
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_AND_PAIRED_STATUS_TEXT 13819
#define IDS_DEVICE_CHOOSER_ACCNAME_COMPATIBLE_DEVICES_LIST 13820
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_NAME 13821
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_ID_AND_PRODUCT_ID 13822
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_NAME 13823
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_ID 13824
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_ID 13825
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_NAME 13826
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_ANY_VENDOR 13827
#define IDS_SERIAL_PORT_CHOOSER_PROMPT 13828
#define IDS_SERIAL_PORT_CHOOSER_NAME_WITH_PATH 13829
#define IDS_SERIAL_PORT_CHOOSER_CONNECT_BUTTON_TEXT 13830
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL 13831
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL_TOOLTIP 13832
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_NAME 13833
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_ID 13834
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_ID 13835
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_NAME 13836
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_ANY_PORT 13837
#define IDS_HID_CHOOSER_PROMPT 13838
#define IDS_HID_CHOOSER_ITEM_WITHOUT_NAME 13839
#define IDS_HID_CHOOSER_LOADING_LABEL 13840
#define IDS_HID_CHOOSER_LOADING_LABEL_TOOLTIP 13841
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID_AND_PRODUCT_ID 13842
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID 13843
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_AND_USAGE_PAGE 13844
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_PAGE 13845
#define IDS_HID_POLICY_DESCRIPTION_FOR_ANY_DEVICE 13846
#define IDS_WEB_APP_FILE_HANDLING_LIST_SEPARATOR 13847
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION 13848
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION_MULTIPLE 13849
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_STICKY_CHOICE 13850
#define IDS_WEB_APP_FILE_HANDLING_POSITIVE_BUTTON 13851
#define IDS_WEB_APP_FILE_HANDLING_NEGATIVE_BUTTON 13852
#define IDS_WEB_APP_PERMISSION_NEGATIVE_BUTTON 13853
#define IDS_PROTOCOL_HANDLER_INTENT_PICKER_QUESTION 13854
#define IDS_FONT_ACCESS_CHOOSER_PROMPT_ORIGIN 13855
#define IDS_FONT_ACCESS_CHOOSER_NO_FONTS_FOUND_PROMPT 13856
#define IDS_FONT_ACCESS_CHOOSER_IMPORT_BUTTON_TEXT 13857
#define IDS_FONT_ACCESS_CHOOSER_CANCEL_BUTTON_TEXT 13858
#define IDS_FONT_ACCESS_CHOOSER_SELECT_ALL_CHECKBOX_TEXT 13859
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL 13860
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL_TOOLTIP 13861
#define IDS_IME_API_ACTIVATED_WARNING 13862
#define IDS_IME_API_NEVER_SHOW 13863
#define IDS_BLOCKED_ADS_PROMPT_TOOLTIP 13864
#define IDS_UTILITY_PROCESS_UTILITY_WIN_NAME 13865
#define IDS_UTILITY_PROCESS_QUARANTINE_SERVICE_NAME 13866
#define IDS_REDIRECT_BLOCKED_MESSAGE 13867
#define IDS_REDIRECT_BLOCKED_TITLE 13868
#define IDS_REDIRECT_BLOCKED_TOOLTIP 13869
#define IDS_ALWAYS_ALLOW_REDIRECTS 13870
#define IDS_OPEN_REDIRECT 13871
#define IDS_UTILITY_PROCESS_SYSTEM_SIGNALS_NAME 13872
#define IDS_CONTROLLED_BY_AUTOMATION 13875
#define IDS_CHROME_FOR_TESTING_DISCLAIMER 13876
#define IDS_DOWNLOAD_CHROME 13877
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_TITLE 13879
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_MESSAGE 13880
#define IDS_CONFIRM_FILE_UPLOAD_TITLE 13881
#define IDS_CONFIRM_FILE_UPLOAD_TEXT 13882
#define IDS_CONFIRM_FILE_UPLOAD_OK_BUTTON 13883
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_TITLE 13884
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_ALLOW_TEXT 13885
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_FILE_TEXT 13886
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_DIRECTORY_TEXT 13887
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_FILE_TEXT 13888
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_DIRECTORY_TEXT 13889
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_FILE_TEXT 13890
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_DIRECTORY_TEXT 13891
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_FILE_TEXT 13892
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_DIRECTORY_TEXT 13893
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_TITLE 13894
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_TITLE 13895
#define IDS_FILE_SYSTEM_ACCESS_READ_FILE_PERMISSION_TITLE 13896
#define IDS_FILE_SYSTEM_ACCESS_READ_DIRECTORY_PERMISSION_TITLE 13897
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_ALLOW_TEXT 13898
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_ALLOW_TEXT 13899
#define IDS_FILE_SYSTEM_ACCESS_VIEW_FILE_PERMISSION_ALLOW_TEXT 13900
#define IDS_FILE_SYSTEM_ACCESS_VIEW_DIRECTORY_PERMISSION_ALLOW_TEXT 13901
#define IDS_FILE_SYSTEM_ACCESS_RESTORE_PERMISSION_DESCRIPTION 13902
#define IDS_FILE_SYSTEM_ACCESS_WRITE_USAGE_TOOLTIP 13903
#define IDS_FILE_SYSTEM_ACCESS_DIRECTORY_USAGE_TOOLTIP 457
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_FILE_TEXT 13904
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_TEXT 13905
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_DIRECTORY_TEXT 13906
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_DIRECTORIES_TEXT 13907
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_AND_DIRECTORIES_TEXT 13908
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_FILE_TEXT 13909
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_TEXT 13910
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_DIRECTORY_TEXT 13911
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_DIRECTORIES_TEXT 13912
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_AND_DIRECTORIES_TEXT 13913
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READ_AND_WRITE 13914
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SAVE_CHANGES 13915
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_VIEW_CHANGES 13916
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_FILES_TEXT 13917
#define IDS_FILE_SYSTEM_ACCESS_USAGE_EXPAND 13918
#define IDS_FILE_SYSTEM_ACCESS_USAGE_COLLAPSE 13919
#define IDS_FILE_SYSTEM_ACCESS_USAGE_REMOVE_ACCESS 13920
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_DIRECTORY_TITLE 13921
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_WRITABLE_DIRECTORY_TITLE 13922
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_SAVE_FILE_TITLE 13923
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TITLE 13924
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TEXT 13925
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_BUTTON 13926
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TITLE 13927
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TEXT 13928
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_BUTTON 13929
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TITLE 13930
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TEXT 13931
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_DONT_SAVE 13932
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_SAVE 13933
#define IDS_RELAUNCH_ACCEPT_BUTTON 13934
#define IDS_RELAUNCH_REQUIRED_CANCEL_BUTTON 13935
#define IDS_IDLE_TIMEOUT_INCOGNITO 13936
#define IDS_IDLE_TIMEOUT_CLOSE_COUNTDOWN 13937
#define IDS_IDLE_TIMEOUT_CLEAR_COUNTDOWN 13938
#define IDS_WEBAUTHN_GENERIC_TITLE 13939
#define IDS_WEBAUTHN_CONTINUE 13940
#define IDS_WEBAUTHN_TRANSPORT_USB 13941
#define IDS_WEBAUTHN_TRANSPORT_INTERNAL 13943
#define IDS_WEBAUTHN_TRANSPORT_CABLE 13944
#define IDS_WEBAUTHN_TRANSPORT_WINDOWS_HELLO_OR_SECURITY_KEY 13945
#define IDS_WEBAUTHN_TRANSPORT_WINDOWS_HELLO 13946
#define IDS_WEBAUTHN_TRANSPORT_ICLOUD_KEYCHAIN 13947
#define IDS_WEBAUTHN_TRANSPORT_EXTERNAL_SECURITY_KEY 13948
#define IDS_WEBAUTHN_USB_ACTIVATE_DESCRIPTION 13949
#define IDS_WEBAUTHN_ERROR_GENERIC_TITLE 13950
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_TITLE 13951
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_TITLE 13952
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_REGISTER_DESCRIPTION 13953
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_SIGN_DESCRIPTION 13954
#define IDS_WEBAUTHN_ERROR_TIMEOUT_DESCRIPTION 13955
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_TITLE 13956
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_DESCRIPTION 13957
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_TITLE 13958
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_DESCRIPTION 13959
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_TITLE 13960
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_DESCRIPTION 13961
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_TITLE 13962
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_DESCRIPTION 13963
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_NEXT 13964
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_TITLE 13965
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 13966
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_NEXT 13967
#define IDS_WEBAUTHN_LOADING 13968
#define IDS_WEBAUTHN_TRANSPORT_POPUP_USB 13970
#define IDS_WEBAUTHN_TRANSPORT_POPUP_PAIR_PHONE 13971
#define IDS_WEBAUTHN_TRANSPORT_POPUP_INTERNAL 13972
#define IDS_WEBAUTHN_TRANSPORT_POPUP_CABLE 13973
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE 13974
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE_DEVICE 13975
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION 13976
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DEVICE_NAME_DESCRIPTION 13977
#define IDS_WEBAUTHN_CABLEV2_CONNECTING_TITLE 13978
#define IDS_WEBAUTHN_CABLEV2_CONNECTED_DESCRIPTION 13979
#define IDS_WEBAUTHN_CABLEV2_ERROR_DESCRIPTION 13980
#define IDS_WEBAUTHN_CABLEV2_ERROR_CLOSE 13981
#define IDS_WEBAUTHN_PASSKEY_PHONE_OR_TABLET_LABEL 13982
#define IDS_WEBAUTHN_PASSKEY_PHONE_TABLET_OR_SECURITY_KEY_LABEL 13983
#define IDS_WEBAUTHN_PASSKEY_DIFFERENT_PHONE_OR_TABLET_LABEL 13984
#define IDS_WEBAUTHN_PASSKEY_DIFFERENT_PHONE_TABLET_OR_SECURITY_KEY_LABEL 13985
#define IDS_WEBAUTHN_PHONE_CONFIRMATION_TITLE 13986
#define IDS_WEBAUTHN_PIN_ENTRY_TITLE 13987
#define IDS_WEBAUTHN_PIN_ENTRY_DESCRIPTION 13988
#define IDS_WEBAUTHN_PIN_ENTRY_PIN_LABEL 13989
#define IDS_WEBAUTHN_PIN_ENTRY_NEXT 13990
#define IDS_WEBAUTHN_PIN_SETUP_DESCRIPTION 13991
#define IDS_WEBAUTHN_PIN_SETUP_CONFIRMATION_LABEL 13992
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_INVALID_CHARACTERS 13993
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_TOO_SHORT 13994
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED_RETRIES 13995
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED 13996
#define IDS_WEBAUTHN_PIN_SETUP_ERROR_FAILED 13997
#define IDS_WEBAUTHN_PIN_TAP_AGAIN_DESCRIPTION 13998
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_MISMATCH 13999
#define IDS_WEBAUTHN_CLIENT_PIN_SOFT_BLOCK_DESCRIPTION 14000
#define IDS_WEBAUTHN_CLIENT_PIN_HARD_BLOCK_DESCRIPTION 14001
#define IDS_WEBAUTHN_CLIENT_PIN_AUTHENTICATOR_REMOVED_DESCRIPTION 14002
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_SAME_AS_CURRENT 14003
#define IDS_WEBAUTHN_USE_PHONE_WITH_NAME 14004
#define IDS_WEBAUTHN_INLINE_ENROLLMENT_CANCEL_LABEL 14005
#define IDS_WEBAUTHN_UV_RETRY_TITLE 14006
#define IDS_WEBAUTHN_UV_RETRY_DESCRIPTION 14007
#define IDS_WEBAUTHN_UV_RETRY_ERROR_FAILED_RETRIES 14008
#define IDS_WEBAUTHN_UV_ERROR_LOCKED 14009
#define IDS_WEBAUTHN_FORCE_PIN_CHANGE 14010
#define IDS_WEBAUTHN_UNKNOWN_ACCOUNT 14011
#define IDS_WEBAUTHN_RESIDENT_KEY_PRIVACY 14012
#define IDS_WEBAUTHN_RESIDENT_KEY_PREFERRED_PRIVACY 14013
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_TITLE 14014
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_DESC 14015
#define IDS_WEBAUTHN_STORAGE_FULL_DESC 14016
#define IDS_WEBAUTHN_ATTESTATION_WARNING 14017
#define IDS_WEBAUTHN_ENTERPRISE_ATTESTATION_WARNING 14018
#define IDS_WEBAUTHN_RETRY 14019
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_TITLE 14020
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DESCRIPTION 14021
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DENY 14022
#define IDS_WEBAUTHN_MANAGE_DEVICES 14023
#define IDS_WEBAUTHN_CREATE_PASSKEY_TITLE 14024
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA 14025
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_INCOGNITO 14026
#define IDS_WEBAUTHN_CREATE_PASSKEY_CHOOSE_DEVICE_TITLE 14027
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_TITLE 14028
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_BODY 14029
#define IDS_WEBAUTHN_USE_PASSKEY_TITLE 14030
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_TITLE 14031
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_BODY 14032
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_TITLE 14033
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_BODY 14034
#define IDS_WEBAUTHN_USE_PASSKEY_QR_TITLE 14035
#define IDS_WEBAUTHN_USE_PASSKEY_QR_BODY 14036
#define IDS_WEBAUTHN_QR_CODE_ALT_TEXT 14037
#define IDS_WEBAUTHN_USE_A_DIFFERENT_PASSKEY 14038
#define IDS_WEBAUTHN_QR_CREATE_PASSKEY_ON_SECURITY_KEY_LABEL 14039
#define IDS_WEBAUTHN_QR_USE_PASSKEY_ON_SECURITY_KEY_LABEL 14040
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_FOR_RP_TITLE 14041
#define IDS_WEBAUTHN_THIS_DEVICE_LABEL 14042
#define IDS_WEBAUTHN_FROM_PHONE_LABEL 14043
#define IDS_WEBAUTHN_OTHER_DEVICES_LABEL 14044
#define IDS_WEBAUTHN_SOURCE_CHROME_PROFILE 14045
#define IDS_WEBAUTHN_SOURCE_CHROME_PROFILE_NEW 14046
#define IDS_WEBAUTHN_SOURCE_ICLOUD_KEYCHAIN 14047
#define IDS_WEBAUTHN_SOURCE_ICLOUD_KEYCHAIN_NEW 14048
#define IDS_WEBAUTHN_SOURCE_CUSTOM_VENDOR 14049
#define IDS_WEBAUTHN_SOURCE_WINDOWS_HELLO 14050
#define IDS_WEBAUTHN_SOURCE_WINDOWS_HELLO_NEW 14051
#define IDS_WEBAUTHN_SOURCE_GOOGLE_PASSWORD_MANAGER 14052
#define IDS_WEBAUTHN_SOURCE_USB_SECURITY_KEY 14053
#define IDS_WEBAUTHN_SOURCE_PHONE 14054
#define IDS_WEBAUTHN_PASSKEYS_AND_SECURITY_KEYS 14055
#define IDS_WEBAUTHN_PASSKEYS 14056
#define IDS_WEBAUTHN_USE_YOUR_PHONE_OR_TABLET 14057
#define IDS_WEBAUTHN_USE_YOUR_PHONE_OR_TABLET_CREATE_DESCRIPTION 14058
#define IDS_WEBAUTHN_USE_YOUR_PHONE_OR_TABLET_SIGN_IN_DESCRIPTION 14059
#define IDS_WEBAUTHN_USE_YOUR_SECURITY_KEY 14060
#define IDS_WEBAUTHN_USE_YOUR_SECURITY_KEY_CREATE_DESCRIPTION 14061
#define IDS_WEBAUTHN_USE_YOUR_SECURITY_KEY_SIGN_IN_DESCRIPTION 14062
#define IDS_WEBAUTHN_CREATE 14063
#define IDS_WEBAUTHN_CREATE_PASSKEY 14064
#define IDS_WEBAUTHN_GPM_CREATE_PASSKEY_TITLE 14065
#define IDS_WEBAUTHN_GPM_CREATE_PASSKEY_DESC 14066
#define IDS_WEBAUTHN_SAVE_ANOTHER_WAY 14067
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_CREATION_TITLE 14068
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_CREATION_DESC 14069
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_ASSERTION_TITLE 14070
#define IDS_WEBAUTHN_GPM_TRUST_THIS_COMPUTER_ASSERTION_DESC 14071
#define IDS_WEBAUTHN_USE_A_DIFFERENT_DEVICE 14072
#define IDS_WEBAUTHN_TOUCH_ID_ASSERTION_DESC 14073
#define IDS_WEBAUTHN_TOUCH_ID_CONTINUE 14074
#define IDS_WEBAUTHN_TOUCH_ID_LOCKED 14075
#define IDS_WEBAUTHN_TOUCH_ID_ENTER_PASSWORD 14076
#define IDS_WEBAUTHN_GPM_ERROR_TITLE 14077
#define IDS_WEBAUTHN_GPM_ERROR_DESC 14078
#define IDS_WEBAUTHN_SIGN_IN_AGAIN_TITLE 14079
#define IDS_WEBAUTHN_SIGN_IN_AGAIN_DESCRIPTION 14080
#define IDS_WEBAUTHN_GPM_INCOGNITO_CREATE_TITLE 14081
#define IDS_WEBAUTHN_GPM_INCOGNITO_CREATE_DESC 14082
#define IDS_WEBAUTHN_GPM_PIN_OPTION_NUMBERS 14083
#define IDS_WEBAUTHN_GPM_PIN_OPTION_ALPHANUMERIC 14084
#define IDS_WEBAUTHN_GPM_CREATE_PIN_TITLE 14085
#define IDS_WEBAUTHN_GPM_CREATE_ALPHANUMERIC_PIN_ACCESSIBILITY 14086
#define IDS_WEBAUTHN_GPM_CREATE_SIX_DIGIT_PIN_ACCESSIBILITY 14087
#define IDS_WEBAUTHN_GPM_CREATE_SIX_DIGIT_PIN_ACCESSIBILITY_WITH_FOCUSED_DIGIT 14088
#define IDS_WEBAUTHN_GPM_CREATE_PIN_DESC 14089
#define IDS_WEBAUTHN_GPM_ENTER_PIN_TITLE 14090
#define IDS_WEBAUTHN_GPM_ENTER_ALPHANUMERIC_PIN_ACCESSIBILITY 14091
#define IDS_WEBAUTHN_GPM_ENTER_ALPHANUMERIC_PIN_ACCESSIBILITY_WITH_WEBSITE 14092
#define IDS_WEBAUTHN_GPM_ENTER_SIX_DIGIT_PIN_ACCESSIBILITY 14093
#define IDS_WEBAUTHN_GPM_ENTER_SIX_DIGIT_PIN_ACCESSIBILITY_WITH_FOCUSED_DIGIT 14094
#define IDS_WEBAUTHN_GPM_ENTER_PIN_DESC 14095
#define IDS_WEBAUTHN_GPM_SIX_DIGIT_PIN_ACCESSIBILITY_LABEL 14096
#define IDS_WEBAUTHN_FORGOT_GPM_PIN_BUTTON 14097
#define IDS_WEBAUTHN_GPM_PIN_OPTIONS_BUTTON 14098
#define IDS_WEBAUTHN_GPM_WRONG_PIN_ERROR 14099
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_TITLE 14100
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_PIN_CREATED_TITLE 14101
#define IDS_WEBAUTHN_SHOW_PIN 14102
#define IDS_WEBAUTHN_HIDE_PIN 14103
#define IDS_WEBAUTHN_CHANGE_PIN 14104
#define IDS_WEBAUTHN_LOCKED_GPM_PIN_TITLE 14105
#define IDS_WEBAUTHN_LOCKED_GPM_PIN_DESCRIPTION 14106
#define IDS_WEBAUTHN_GPM_PIN_DIGIT_HINT 14107
#define IDS_WEBAUTHN_GPM_PIN_LENGTH_HINT 14108
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_LABEL 14109
#define IDS_WEBAUTHN_GPM_PASSKEY_SAVED_LINK 14110
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATE_NEEDED_TITLE 14111
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATE_NEEDED_LABEL 14112
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATED_TITLE 14113
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATED_LABEL 14114
#define IDS_WEBAUTHN_GPM_PASSKEY_UPDATED_LINK 14115
#define IDS_WEBAUTHN_GPM_PASSKEY_DELETED_TITLE 14116
#define IDS_WEBAUTHN_GPM_PASSKEY_DELETED_LABEL 14117
#define IDS_WEBAUTHN_GPM_PASSKEY_DELETED_LINK 14118
#define IDS_WEBAUTHN_AMBIENT_BUBBLE_TITLE 14119
#define IDS_WEB_DIGITAL_CREDENTIALS_BLUETOOTH_POWER_ON_MANUAL_TITLE 14120
#define IDS_WEB_DIGITAL_CREDENTIALS_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 14121
#define IDS_WEB_DIGITAL_CREDENTIALS_BLUETOOTH_POWER_ON_MANUAL_NEXT 14122
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_TITLE 14123
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_BODY 14124
#define IDS_WEB_DIGITAL_CREDENTIALS_QR_CODE_ALT_TEXT 14125
#define IDS_WEB_DIGITAL_CREDENTIALS_CABLEV2_CONNECTING_TITLE 14126
#define IDS_WEB_DIGITAL_CREDENTIALS_CABLEV2_CONNECTED_TITLE 14127
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_DIALOG_TITLE 14128
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_LOW_RISK_DIALOG_TEXT 14129
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_LOW_RISK_NEGATIVE_BUTTON_TEXT 14130
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_HIGH_RISK_DIALOG_TEXT 14131
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_HIGH_RISK_NEGATIVE_BUTTON_TEXT 14132
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_POSITIVE_BUTTON_TEXT 14133
#define IDS_WEB_DIGITAL_CREDENTIALS_INTERSTITIAL_REQUEST_ABORTED_DIALOG_TEXT 14134
#define IDS_INCOGNITO_PROFILE_MENU_TITLE 14135
#define IDS_INCOGNITO_WINDOW_COUNT_MESSAGE 14136
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON 14137
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON_NEW 14138
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_PRIMARY_TEXT 14139
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_SECONDARY_TEXT 14140
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_CLOSE_WINDOWS_BUTTON 14141
#define IDS_INCOGNITO_HISTORY_BUBBLE_PRIMARY_TEXT 14142
#define IDS_INCOGNITO_HISTORY_BUBBLE_SECONDARY_TEXT 14143
#define IDS_INCOGNITO_HISTORY_BUBBLE_CLOSE_INCOGNITO_BUTTON_TEXT 14144
#define IDS_INCOGNITO_HISTORY_BUBBLE_CANCEL_BUTTON_TEXT 14145
#define IDS_GUEST_WINDOW_COUNT_MESSAGE 14146
#define IDS_GUEST_PROFILE_MENU_CLOSE_BUTTON 14147
#define IDS_NOTIFICATION_DEFAULT_HELPFUL_BUTTON_TEXT 14148
#define IDS_NOTIFICATION_DEFAULT_UNHELPFUL_BUTTON_TEXT 14149
#define IDS_DEEP_SCANNING_DIALOG_TITLE 14150
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_PENDING_MESSAGE 14151
#define IDS_DEEP_SCANNING_DIALOG_PRINT_PENDING_MESSAGE 14152
#define IDS_DEEP_SCANNING_DIALOG_SUCCESS_MESSAGE 14153
#define IDS_DEEP_SCANNING_DIALOG_PRINT_SUCCESS_MESSAGE 14154
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAILURE_MESSAGE 14155
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAIL_CLOSED_MESSAGE 14156
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_WARNING_MESSAGE 14157
#define IDS_DEEP_SCANNING_DIALOG_PRINT_WARNING_MESSAGE 14158
#define IDS_DEEP_SCANNING_DIALOG_TIMEOUT_MESSAGE 14159
#define IDS_DEEP_SCANNING_DIALOG_PROCEED_BUTTON 14160
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_WARNING_BUTTON 14161
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_UPLOAD_BUTTON 14162
#define IDS_DEEP_SCANNING_DIALOG_LARGE_FILE_FAILURE_MESSAGE 14163
#define IDS_DEEP_SCANNING_DIALOG_LARGE_PRINT_FAILURE_MESSAGE 14164
#define IDS_DEEP_SCANNING_DIALOG_ENCRYPTED_FILE_FAILURE_MESSAGE 14165
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE 14166
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_CUSTOM_MESSAGE 14167
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE_LEARN_MORE_LINK 14168
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_DISCARD_FILE_BUTTON 14169
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_BYPASS_JUSTIFICATION_LABEL 14170
#define IDS_DEEP_SCANNING_DIALOG_PASTE_BYPASS_JUSTIFICATION_LABEL 14171
#define IDS_DEEP_SCANNING_DIALOG_PRINT_BYPASS_JUSTIFICATION_LABEL 14172
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOAD_BYPASS_JUSTIFICATION_LABEL 14173
#define IDS_DEEP_SCANNING_DIALOG_BYPASS_JUSTIFICATION_TEXT_LIMIT_LABEL 14174
#define IDS_DATA_CONTROLS_CLIPBOARD_PASTE_BLOCK_TITLE 14175
#define IDS_DATA_CONTROLS_CLIPBOARD_PASTE_WARN_TITLE 14176
#define IDS_DATA_CONTROLS_CLIPBOARD_COPY_BLOCK_TITLE 14177
#define IDS_DATA_CONTROLS_CLIPBOARD_COPY_WARN_TITLE 14178
#define IDS_DATA_CONTROLS_BLOCKED_LABEL 14179
#define IDS_DATA_CONTROLS_WARNED_LABEL 14180
#define IDS_DATA_CONTROLS_PASTE_WARN_CONTINUE_BUTTON 14181
#define IDS_DATA_CONTROLS_COPY_WARN_CONTINUE_BUTTON 14182
#define IDS_DATA_CONTROLS_PASTE_WARN_CANCEL_BUTTON 14183
#define IDS_DATA_CONTROLS_COPY_WARN_CANCEL_BUTTON 14184
#define IDS_DATA_SHARING_BUBBLE_DIALOG_TITLE 14185
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_TITLE 14186
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_MESSAGE 14187
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_ACCEPT_BUTTON 14188
#define IDS_DEEP_SCANNING_INFO_DIALOG_TITLE 14189
#define IDS_APP_DEEP_SCANNING_INFO_DIALOG_MESSAGE 14190
#define IDS_DEEP_SCANNING_INFO_DIALOG_MESSAGE 14191
#define IDS_DEEP_SCANNING_INFO_DIALOG_ACCEPT_BUTTON 14192
#define IDS_DEEP_SCANNING_INFO_DIALOG_CANCEL_BUTTON 14193
#define IDS_DEEP_SCANNING_INFO_DIALOG_OPEN_NOW_BUTTON 14194
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_TEXT 14195
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_CLOSE_BUTTON_ARIA_LABEL_TEXT 14196
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_TITLE 14197
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_TITLE 14198
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_MAIN_TEXT 14199
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_MAIN_TEXT 14200
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_ACCEPT_BUTTON 14201
#define IDS_TAILORED_SECURITY_DIALOG_SETTINGS_BUTTON 14202
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_TITLE 14203
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_BODY 14204
#define IDS_TAILORED_SECURITY_UNCONSENTED_ACCEPT_BUTTON 14205
#define IDS_TAILORED_SECURITY_UNCONSENTED_CANCEL_BUTTON 14206
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_TITLE 14207
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_DESCRIPTION 14208
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_TITLE 14209
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_DESCRIPTION 14210
#define IDS_TAILORED_SECURITY_CONSENTED_MESSAGE_OK_BUTTON 14211
#define IDS_TAILORED_SECURITY_CONSENTED_ENHANCED_PROTECTION_ENABLE_MESSAGE_TITLE 14212
#define IDS_PROMPT_APP_UNINSTALL_TITLE 14213
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_NON_GOOGLE 14214
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_GOOGLE 14215
#define IDS_APP_UNINSTALL_PROMPT_LEARN_MORE 14216
#define IDS_APP_UNINSTALL_PROMPT_ADDITIONAL_UNINSTALLS_MESSAGE 14217
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_TITLE 14218
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_DESCRIPTION 14219
#define IDS_UTILITY_PROCESS_SPEECH_RECOGNITION_SERVICE_NAME 14220
#define IDS_APP_PAUSE_PROMPT_TITLE 14221
#define IDS_APP_PAUSE_HEADING 14222
#define IDS_APP_PAUSE_HEADING_FOR_WEB_APPS 14223
#define IDS_APP_BLOCK_PROMPT_TITLE 14224
#define IDS_APP_BLOCK_HEADING_FOR_CHILD 14225
#define IDS_APP_BLOCK_HEADING 14226
#define IDS_APP_LOCAL_BLOCK_PROMPT_TITLE 14227
#define IDS_APP_LOCAL_BLOCK_PROMPT_MULTIPLE_TITLE 14228
#define IDS_APP_LOCAL_BLOCK_HEADING 14229
#define IDS_ENTERPRISE_EXTENSION_REQUEST_APPROVED_TITLE 14230
#define IDS_ENTERPRISE_EXTENSION_REQUEST_REJECTED_TITLE 14231
#define IDS_ENTERPRISE_EXTENSION_REQUEST_FORCE_INSTALLED_TITLE 14232
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_INSTALL 14233
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_VIEW 14234
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION 14235
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_PLACEHOLDER 14236
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_LENGTH_LIMIT 14237
#define IDS_NAME_WINDOW_PROMPT_TITLE 14238
#define IDS_NAME_WINDOW_PROMPT_FIELD_LABEL 14239
#define IDS_CHROMELABS_RELAUNCH_BUTTON_LABEL 14240
#define IDS_WINDOW_TITLE_EXPERIMENTS 14241
#define IDS_CHROMELABS_SEND_FEEDBACK 14242
#define IDS_CHROMELABS_SEND_FEEDBACK_DESCRIPTION_PLACEHOLDER 14243
#define IDS_CHROMELABS_DEFAULT 14244
#define IDS_CHROMELABS_ENABLED 14245
#define IDS_CHROMELABS_DISABLED 14246
#define IDS_CHROMELABS_ENABLED_WITH_VARIATION_NAME 14247
#define IDS_TAB_SCROLLING_EXPERIMENT_NAME 14248
#define IDS_TAB_SCROLLING_EXPERIMENT_DESCRIPTION 14249
#define IDS_TABS_SHRINK_TO_PINNED_TAB_WIDTH 14250
#define IDS_TABS_SHRINK_TO_MEDIUM_WIDTH 14251
#define IDS_TABS_SHRINK_TO_LARGE_WIDTH 14252
#define IDS_TABS_DO_NOT_SHRINK 14253
#define IDS_LENS_REGION_SEARCH_BUBBLE_TEXT 14254
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_NAME 14255
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_DESCRIPTION 14256
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_DESCRIPTION 14259
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_ACCEPT 14260
#define IDS_TAILORED_SECURITY_CONSENTED_PROMOTION_MESSAGE_TURN_ON 14261
#define IDS_TAILORED_SECURITY_CONSENTED_ESB_OFF_MESSAGE_TITLE 14262
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_IN 14263
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_UP 14264
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_USE 14265
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_CONTINUE 14266
#define IDS_ACCOUNT_SELECTION_CONTINUE 14267
#define IDS_ACCOUNT_SELECTION_CHOOSE_AN_ACCOUNT 14268
#define IDS_ACCOUNT_SELECTION_CHOOSE_AN_ACCOUNT_BUTTON 14269
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_NAME 14270
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_EMAIL 14271
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_PICTURE 14272
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP_OR_TOS 14273
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP 14274
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_TOS 14275
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT 14276
#define IDS_ACCOUNT_SELECTION_USE_OTHER_ACCOUNT 14277
#define IDS_ACCOUNT_SELECTION_USE_OTHER_ACCOUNT_MULTI_IDP 14278
#define IDS_ACCOUNT_SELECTION_BACK 14279
#define IDS_SIGNIN_CONTINUE 14280
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_DIALOG_BODY 14281
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_BUTTON_TEXT 14282
#define IDS_SIGNIN_GENERIC_ERROR_DIALOG_SUMMARY 14283
#define IDS_SIGNIN_GENERIC_ERROR_DIALOG_DESCRIPTION 14284
#define IDS_SIGNIN_UNAUTHORIZED_CLIENT_ERROR_DIALOG_SUMMARY 14285
#define IDS_SIGNIN_UNAUTHORIZED_CLIENT_ERROR_DIALOG_DESCRIPTION 14286
#define IDS_SIGNIN_INVALID_REQUEST_ERROR_DIALOG_SUMMARY 14287
#define IDS_SIGNIN_INVALID_REQUEST_ERROR_DIALOG_DESCRIPTION 14288
#define IDS_SIGNIN_ACCESS_DENIED_ERROR_DIALOG_SUMMARY 14289
#define IDS_SIGNIN_ACCESS_DENIED_ERROR_DIALOG_DESCRIPTION 14290
#define IDS_SIGNIN_SERVER_ERROR_DIALOG_SUMMARY 14291
#define IDS_SIGNIN_SERVER_ERROR_DIALOG_DESCRIPTION 14292
#define IDS_SIGNIN_TEMPORARILY_UNAVAILABLE_ERROR_DIALOG_SUMMARY 14293
#define IDS_SIGNIN_TEMPORARILY_UNAVAILABLE_ERROR_DIALOG_DESCRIPTION 14294
#define IDS_SIGNIN_ERROR_DIALOG_GOT_IT_BUTTON 14295
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_BUTTON 14296
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_PROMPT 14297
#define IDS_SIGNIN_ERROR_DIALOG_TRY_OTHER_WAYS_PROMPT 14298
#define IDS_SIGNIN_ERROR_DIALOG_MORE_DETAILS_RETRY_PROMPT 14299
#define IDS_SIGNIN_ERROR_DIALOG_TRY_OTHER_WAYS_RETRY_PROMPT 14300
#define IDS_MULTI_IDP_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT 14301
#define IDS_MULTI_IDP_CHOOSE_AN_ACCOUNT_TITLE 14302
#define IDS_MULTI_IDP_ACCOUNT_ORIGIN_AND_LAST_USED 14303
#define IDS_MULTI_IDP_ACCOUNT_LAST_USED_ON_THIS_SITE 14304
#define IDS_MULTI_IDP_ACCOUNT_USED_TIME_AGO 14305
#define IDS_VERIFY_SHEET_TITLE 14306
#define IDS_VERIFY_SHEET_TITLE_AUTO_REAUTHN 14307
#define IDS_AUTO_REAUTHN_OPTOUT_CHECKBOX 14308
#define IDS_FILTERED_ACCOUNT_MESSAGE 14309
#define IDS_BATTERY_SAVER_BUTTON_TOOLTIP 435
#define IDS_BATTERY_SAVER_BUTTON_ACCNAME 434
#define IDS_BATTERY_SAVER_BUBBLE_TITLE 14341
#define IDS_BATTERY_SAVER_BUBBLE_DESCRIPTION 14342
#define IDS_BATTERY_SAVER_SESSION_TURN_OFF 14343
#define IDS_MEMORY_SAVER_CHIP_LABEL 14344
#define IDS_MEMORY_SAVER_CHIP_ACCNAME 460
#define IDS_MEMORY_SAVER_CHIP_WITH_SAVINGS_ACCNAME 14345
#define IDS_MEMORY_SAVER_CHIP_SAVINGS_LABEL 14346
#define IDS_MEMORY_SAVER_DIALOG_TITLE 14347
#define IDS_MEMORY_SAVER_DIALOG_SETTINGS_BUTTON 14348
#define IDS_MEMORY_SAVER_DIALOG_SAVINGS_ACCNAME 14349
#define IDS_MEMORY_SAVER_DIALOG_BUTTON_ADD_TO_EXCLUSION_LIST 14350
#define IDS_MEMORY_SAVER_DIALOG_SAVINGS_LABEL 14351
#define IDS_MEMORY_SAVER_DIALOG_SMALL_SAVINGS_LABEL 14352
#define IDS_MEMORY_SAVER_DIALOG_MEDIUM_SAVINGS_LABEL 14353
#define IDS_MEMORY_SAVER_DIALOG_LARGE_SAVINGS_LABEL 14354
#define IDS_MEMORY_SAVER_DIALOG_VERY_LARGE_SAVINGS_LABEL 14355
#define IDS_HOVERCARD_TAB_MEMORY_USAGE 14356
#define IDS_HOVERCARD_TAB_HIGH_MEMORY_USAGE 14357
#define IDS_HOVERCARD_INACTIVE_TAB_MEMORY_SAVINGS 14358
#define IDS_HOVERCARD_INACTIVE_TAB 14359
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_V1 14360
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_V2 14361
#define IDS_PERFORMANCE_INTERVENTION_DIALOG_TITLE_V3 14362
#define IDS_PERFORMANCE_INTERVENTION_CLOSE_BUTTON_ACCNAME 14363
#define IDS_PERFORMANCE_INTERVENTION_SINGLE_SUGGESTED_ROW_ACCNAME 14364
#define IDS_PERFORMANCE_INTERVENTION_TAB_LIST_ACCNAME 14365
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON_V1 14366
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON_V2 14367
#define IDS_PERFORMANCE_INTERVENTION_DEACTIVATE_TABS_BUTTON_V3 14368
#define IDS_PERFORMANCE_INTERVENTION_DISMISS_BUTTON 14369
#define IDS_PERFORMANCE_INTERVENTION_BUTTON_TOOLTIP 14370
#define IDS_PERFORMANCE_INTERVENTION_BUTTON_ACCNAME 14371
#define IDS_TOAST_MENU_BUTTON_NAME 14372
#define IDS_LINK_COPIED_TOAST_BODY 14373
#define IDS_IMAGE_COPIED_TOAST_BODY 14374
#define IDS_LINK_COPIED_TO_HIGHLIGHT_TOAST_BODY 14375
#define IDS_READING_LIST_TOAST_BODY 14376
#define IDS_READING_LIST_TOAST_BUTTON 14377
#define IDS_TOAST_CLOSE_TOOLTIP 14378
#define IDS_TOAST_MENU_ITEM_DISMISS 14379
#define IDS_TOAST_MENU_ITEM_DONT_SHOW_AGAIN 14380
#define IDS_ACCNAME_SIDEBAR_WEBVIEW_LOCATION_BAR 14381
#define IDS_SIDEBAR_WEBVIEW_TITLE 14382
#define IDS_PROTECTED_AUDIENCE_DEBUGGING_DISCLAIMER 14386
#define IDS_TEST_THIRD_PARTY_COOKIE_BLOCKING_PHASEOUT_INFO 14387
#define IDS_OVERFLOW_MENU_ITEM_TEXT_PROFILE 14388
#define IDS_OVERFLOW_MENU_ITEM_TEXT_DOWNLOADS 14389
#define IDS_OVERFLOW_MENU_ITEM_TEXT_EXTENSIONS 14390
#define IDS_OVERFLOW_MENU_ITEM_TEXT_FORWARD 14391
#define IDS_OVERFLOW_MENU_ITEM_TEXT_HOME 14392
#define IDS_OVERFLOW_MENU_ITEM_TEXT_LABS 14393
#define IDS_OVERFLOW_MENU_ITEM_TEXT_MEDIA_CONTROLS 14394
#define IDS_OVERFLOW_MENU_ITEM_TEXT_NEW_TAB 14395
#define IDS_OVERFLOW_MENU_ITEM_TEXT_SIDE_PANEL 14396
#define IDS_PROMISE_STATUS_WAITING 14397
#define IDS_PROMISE_STATUS_INSTALLING 14398
#define IDS_PROMISE_APP_ACCESSIBLE_LABEL_WAITING 14399
#define IDS_PROMISE_APP_ACCESSIBLE_LABEL_INSTALLING 14400
#define IDS_PROMISE_APP_PLACEHOLDER_ACCESSIBLE_LABEL_WAITING 14401
#define IDS_PROMISE_APP_PLACEHOLDER_ACCESSIBLE_LABEL_INSTALLING 14402
#define IDS_IWA_INSTALLER_DISABLED_TITLE 14403
#define IDS_IWA_INSTALLER_DISABLED_CHANGE_PREFERENCE 14404
#define IDS_IWA_INSTALLER_DISABLED_SUBTITLE 14405
#define IDS_IWA_INSTALLER_ALREADY_INSTALLED_TITLE 14406
#define IDS_IWA_INSTALLER_ALREADY_INSTALLED_SUBTITLE 14407
#define IDS_IWA_INSTALLER_BODY_SCREENREADER_NAME 14408
#define IDS_IWA_INSTALLER_DETAILS_SCREENREADER_NAME 14409
#define IDS_IWA_INSTALLER_PROGRESS_SCREENREADER_NAME 14410
#define IDS_IWA_INSTALLER_INSTALL_SUBTITLE 14411
#define IDS_IWA_INSTALLER_INSTALL_PROGRESS 14412
#define IDS_IWA_INSTALLER_SHOW_METADATA_SUBTITLE 14413
#define IDS_IWA_INSTALLER_SHOW_METADATA_APP_NAME_LABEL 14414
#define IDS_IWA_INSTALLER_SHOW_METADATA_APP_VERSION_LABEL 14415
#define IDS_IWA_INSTALLER_CONFIRM_TITLE 14416
#define IDS_IWA_INSTALLER_CONFIRM_SUBTITLE 14417
#define IDS_IWA_INSTALLER_CONFIRM_LEARN_MORE 14418
#define IDS_IWA_INSTALLER_CONFIRM_CONTINUE 14419
#define IDS_IWA_INSTALLER_INSTALL_FAILED_TITLE 14420
#define IDS_IWA_INSTALLER_INSTALL_FAILED_SUBTITLE 14421
#define IDS_IWA_INSTALLER_INSTALL_FAILED_RETRY 14422
#define IDS_IWA_INSTALLER_SUCCESS_SUBTITLE 14423
#define IDS_IWA_INSTALLER_SUCCESS_FINISH 14424
#define IDS_IWA_INSTALLER_SUCCESS_LAUNCH_APPLICATION 14425
#define IDS_IWA_INSTALLER_VERIFICATION_TITLE 14426
#define IDS_IWA_INSTALLER_VERIFICATION_SUBTITLE 14427
#define IDS_IWA_INSTALLER_VERIFICATION_STATUS 14428
#define IDS_IWA_INSTALLER_VERIFICATION_ERROR_TITLE 14429
#define IDS_IWA_INSTALLER_VERIFICATION_ERROR_SUBTITLE 14430
#define IDS_THUMBS_DOWN 14432
#define IDS_THUMBS_UP 14433
#define IDS_EXPERIMENTAL_FEATURE_DISCLAIMER 14434
#define IDS_PDF_SEARCHIFY_IPH_TITLE 14436
#define IDS_PDF_SEARCHIFY_IPH_BODY 14437
#define IDS_PDF_SEARCHIFY_IPH_BODY_SCREEN_READER 14438
#define IDS_SELECT_AUDIO_OUTPUT_DIALOG_TITLE 14439
#define IDS_SELECT_AUDIO_OUTPUT_DIALOG_CHOOSE_DEVICE 14440
#define IDS_CHROME_NO_LONGER_SHOW_WARNINGS_NOTIFICATION_TITLE 14442
#define IDS_CHROME_NO_LONGER_SHOW_WARNINGS_NOTIFICATION_BODY 14443
#define IDS_MERCHANT_TRUST_IPH_TITLE 14444
#define IDS_MERCHANT_TRUST_IPH_BODY 14445
#define IDS_MERCHANT_TRUST_IPH_BODY_SCREEN_READER 14446

// ---------------------------------------------------------------------------
// From locale_settings.h:

#define IDS_SPELLCHECK_DICTIONARY 145
#define IDS_EDITBOOKMARK_DIALOG_WIDTH_CHARS 17000
#define IDS_EDITBOOKMARK_DIALOG_HEIGHT_LINES 17001
#define IDS_THEMES_GALLERY_URL 17002
#define IDS_WEBSTORE_URL 479
#define IDS_MEDIA_GALLERIES_DIALOG_CONTENT_WIDTH_CHARS 17003
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_DIALOG 17006
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_HISTORY 17007

// ---------------------------------------------------------------------------
// From omnibox_pedal_synonyms.h:

#define IDS_OMNIBOX_PEDALS_IGNORE_GROUP 287
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_CLEAR_BROWSER_CACHE 43840
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_OPTIONAL_GOOGLE_CHROME 373
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_DELETE 374
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_INFORMATION 375
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_MANAGE_CHROME_PASSWORDS 43841
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_GOOGLE_CHROME 367
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_MANAGER 368
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_PASSWORDS 369
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_MANAGE_PAYMENT_METHODS 43842
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_OPTIONAL_GOOGLE_CHROME 364
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CHANGE 365
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CREDIT_CARD_INFORMATION 366
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_ENTER_INCOGNITO_MODE 43843
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_GOOGLE_CHROME 361
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_CREATE 362
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_INCOGNITO_WINDOW 363
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_TRANSLATE_THIS_PAGE 43844
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_OPTIONAL_GOOGLE_CHROME 357
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_CHANGE_LANGUAGE 358
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_THIS_PAGE 359
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_UPDATE_CHROME 43845
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_GOOGLE_CHROME 355
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_INSTALL 356
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_RUN_CHROME_SAFETY_CHECK 43846
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_ACTIVATE 351
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_GOOGLE_CHROME 352
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_CHECKUP 353
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_PASSWORDS 354
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_MANAGE_SECURITY_SETTINGS 43847
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ANY_OPTIONAL_GOOGLE_CHROME 348
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_ENHANCED_PROTECTION 349
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_OPTIONAL_ALTER 350
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_CHROME_COOKIE_SETTINGS 43848
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_COOKIE_SETTINGS 345
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_REQUIRED_GOOGLE_CHROME 346
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_OPTIONAL_THIRD_PARTY 347
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_ADD_ADDRESS 43849
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_CONTROL 342
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_SHIPPING_ADDRESSES 343
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_OPTIONAL_GOOGLE_CHROME 344
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_CHANGE_CHROME_BROWSER_SYNC_SETTINGS 43850
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_SYNC_SETTINGS 340
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ANY_REQUIRED_GOOGLE_CHROME 341
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_ADJUST_SITE_PERMISSIONS 43851
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_SITE_PERMISSIONS 338
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ANY_REQUIRED_GOOGLE_CHROME 339
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_CREATE_GOOGLE_DOC 43852
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_GOOGLE_WORKSPACE 332
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ANY_REQUIRED_CREATE 333
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_DOCUMENT 334
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_CREATE_GOOGLE_SHEET 43853
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ANY_REQUIRED_CREATE 329
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_GOOGLE_WORKSPACE 330
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_SPREADSHEET 331
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE_GOOGLE_SLIDE 43854
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE 326
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_PRESENTATION 327
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ANY_REQUIRED_WORKSPACE 328
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_CREATE_GOOGLE_CAL_INVITE 43855
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_SCHEDULE 323
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_WORKSPACE 324
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_MEETING 325
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_CREATE_GOOGLE_SITE 43856
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_CREATE 320
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_WORKSPACE 321
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_WEBSITE 322
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_CREATE_GOOGLE_KEEP_NOTE 43857
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_CREATE 317
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_WORKSPACE 318
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_NOTES 319
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_CREATE_GOOGLE_FORM 43858
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_CREATE 314
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_WORKSPACE 315
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_SURVEY 316
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_CHROME_FEATURES 43859
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_OPTIONAL_MAKE_THE_MOST_OF 335
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ANY_OPTIONAL_BROWSER 336
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_NEW_CHROME_FEATURES 337
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL_MY_GOOGLE_ACCOUNT 43860
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_GOOGLE_ACCOUNT 311
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ANY_OPTIONAL_BROWSER 312
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL 313
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE_GMAIL_PASSWORD 43861
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_GOOGLE_ACCOUNT_PASSWORD 370
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ANY_OPTIONAL_BROWSER 371
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE 372
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_CLOSE_INCOGNITO_WINDOW 43862
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_DELETE 43863
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_INCOGNITO_WINDOW 43864
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_CHROME_DINO 43865
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_PLAY_CHROME_DINO_GAME 360
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_FIND_LOST_PHONE 43866
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_HELP_ME_LOCATE 309
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_LOST_DEVICE 310
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_CHANGE_GOOGLE_PRIVACY_SETTINGS 43867
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_MANAGE_GOOGLE_PRIVACY_SETTINGS 308
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHANGE_CHROME_SETTINGS 43868
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_OPTIONAL_CONTROL 306
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHROME_BROWSER_SETTINGS 307
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_MANAGE_CHROME_DOWNLOADS 43869
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CONTROL 304
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CHROME_BROWSER_DOWNLOADS 305
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_SEE_CHROME_HISTORY 43870
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_REVISIT 302
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_GOOGLE_CHROME_BROWSING_HISTORY 303
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_THIS_PAGE 43871
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_LINK_WITH_QR_CODE 301
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROME_ACCESSIBILITY 43872
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 299
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 300
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_CHANGE_BROWSER_FONT 43873
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_OPTIONAL_CUSTOMIZE 296
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_GOOGLE_CHROME 297
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_FONT_SIZING 298
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CUSTOMIZE_CHROME_APPEARANCE 43874
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_OPTIONAL_CUSTOMIZE 294
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CHROME_BACKGROUNDS 295
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_ADD_CUSTOM_SEARCH 43875
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_CUSTOMIZE 291
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_CUSTOM_SEARCH_ENGINES 292
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_GOOGLE_CHROME 293
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROMEOS_ACCESSIBILITY 43876
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 43877
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 43878
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_ALWAYS_OPEN_LINKS_IN_CHROME 43879
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_HOW_TO_MAKE_CHROME_MY_DEFAULT_BROWSER 288
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_SELECT 289
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_DEFAULT_BROWSER 290

// ---------------------------------------------------------------------------
// From permission_element_generated_strings.h:

#define IDS_PERMISSION_REQUEST_CAMERA_af 61020
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_af 61021
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_af 61022
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_af 61023
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_af 61024
#define IDS_PERMISSION_REQUEST_MICROPHONE_af 61025
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_af 61026
#define IDS_PERMISSION_REQUEST_GEOLOCATION_af 61027
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_af 61028
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_af 61029
#define IDS_PERMISSION_REQUEST_CAMERA_am 61030
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_am 61031
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_am 61032
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_am 61033
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_am 61034
#define IDS_PERMISSION_REQUEST_MICROPHONE_am 61035
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_am 61036
#define IDS_PERMISSION_REQUEST_GEOLOCATION_am 61037
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_am 61038
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_am 61039
#define IDS_PERMISSION_REQUEST_CAMERA_ar 61040
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ar 61041
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ar 61042
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ar 61043
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ar 61044
#define IDS_PERMISSION_REQUEST_MICROPHONE_ar 61045
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ar 61046
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ar 61047
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ar 61048
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ar 61049
#define IDS_PERMISSION_REQUEST_CAMERA_as 61050
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_as 61051
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_as 61052
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_as 61053
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_as 61054
#define IDS_PERMISSION_REQUEST_MICROPHONE_as 61055
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_as 61056
#define IDS_PERMISSION_REQUEST_GEOLOCATION_as 61057
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_as 61058
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_as 61059
#define IDS_PERMISSION_REQUEST_CAMERA_az 61060
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_az 61061
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_az 61062
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_az 61063
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_az 61064
#define IDS_PERMISSION_REQUEST_MICROPHONE_az 61065
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_az 61066
#define IDS_PERMISSION_REQUEST_GEOLOCATION_az 61067
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_az 61068
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_az 61069
#define IDS_PERMISSION_REQUEST_CAMERA_be 61070
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_be 61071
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_be 61072
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_be 61073
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_be 61074
#define IDS_PERMISSION_REQUEST_MICROPHONE_be 61075
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_be 61076
#define IDS_PERMISSION_REQUEST_GEOLOCATION_be 61077
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_be 61078
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_be 61079
#define IDS_PERMISSION_REQUEST_CAMERA_bg 61080
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bg 61081
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bg 61082
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bg 61083
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bg 61084
#define IDS_PERMISSION_REQUEST_MICROPHONE_bg 61085
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bg 61086
#define IDS_PERMISSION_REQUEST_GEOLOCATION_bg 61087
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bg 61088
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bg 61089
#define IDS_PERMISSION_REQUEST_CAMERA_bn 61090
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bn 61091
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bn 61092
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bn 61093
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bn 61094
#define IDS_PERMISSION_REQUEST_MICROPHONE_bn 61095
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bn 61096
#define IDS_PERMISSION_REQUEST_GEOLOCATION_bn 61097
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bn 61098
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bn 61099
#define IDS_PERMISSION_REQUEST_CAMERA_bs 61100
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_bs 61101
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_bs 61102
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_bs 61103
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_bs 61104
#define IDS_PERMISSION_REQUEST_MICROPHONE_bs 61105
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_bs 61106
#define IDS_PERMISSION_REQUEST_GEOLOCATION_bs 61107
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_bs 61108
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_bs 61109
#define IDS_PERMISSION_REQUEST_CAMERA_ca 61110
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ca 61111
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ca 61112
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ca 61113
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ca 61114
#define IDS_PERMISSION_REQUEST_MICROPHONE_ca 61115
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ca 61116
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ca 61117
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ca 61118
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ca 61119
#define IDS_PERMISSION_REQUEST_CAMERA_cs 61120
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_cs 61121
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_cs 61122
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_cs 61123
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_cs 61124
#define IDS_PERMISSION_REQUEST_MICROPHONE_cs 61125
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_cs 61126
#define IDS_PERMISSION_REQUEST_GEOLOCATION_cs 61127
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_cs 61128
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_cs 61129
#define IDS_PERMISSION_REQUEST_CAMERA_cy 61130
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_cy 61131
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_cy 61132
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_cy 61133
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_cy 61134
#define IDS_PERMISSION_REQUEST_MICROPHONE_cy 61135
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_cy 61136
#define IDS_PERMISSION_REQUEST_GEOLOCATION_cy 61137
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_cy 61138
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_cy 61139
#define IDS_PERMISSION_REQUEST_CAMERA_da 61140
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_da 61141
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_da 61142
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_da 61143
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_da 61144
#define IDS_PERMISSION_REQUEST_MICROPHONE_da 61145
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_da 61146
#define IDS_PERMISSION_REQUEST_GEOLOCATION_da 61147
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_da 61148
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_da 61149
#define IDS_PERMISSION_REQUEST_CAMERA_de 61150
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_de 61151
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_de 61152
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_de 61153
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_de 61154
#define IDS_PERMISSION_REQUEST_MICROPHONE_de 61155
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_de 61156
#define IDS_PERMISSION_REQUEST_GEOLOCATION_de 61157
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_de 61158
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_de 61159
#define IDS_PERMISSION_REQUEST_CAMERA_el 61160
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_el 61161
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_el 61162
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_el 61163
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_el 61164
#define IDS_PERMISSION_REQUEST_MICROPHONE_el 61165
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_el 61166
#define IDS_PERMISSION_REQUEST_GEOLOCATION_el 61167
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_el 61168
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_el 61169
#define IDS_PERMISSION_REQUEST_CAMERA_en_GB 61170
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_en_GB 61171
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_en_GB 61172
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_en_GB 61173
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_en_GB 61174
#define IDS_PERMISSION_REQUEST_MICROPHONE_en_GB 61175
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_en_GB 61176
#define IDS_PERMISSION_REQUEST_GEOLOCATION_en_GB 61177
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_en_GB 61178
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_en_GB 61179
#define IDS_PERMISSION_REQUEST_CAMERA_es_419 61180
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_es_419 61181
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_es_419 61182
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_es_419 61183
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_es_419 61184
#define IDS_PERMISSION_REQUEST_MICROPHONE_es_419 61185
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_es_419 61186
#define IDS_PERMISSION_REQUEST_GEOLOCATION_es_419 61187
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_es_419 61188
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_es_419 61189
#define IDS_PERMISSION_REQUEST_CAMERA_es 61190
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_es 61191
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_es 61192
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_es 61193
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_es 61194
#define IDS_PERMISSION_REQUEST_MICROPHONE_es 61195
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_es 61196
#define IDS_PERMISSION_REQUEST_GEOLOCATION_es 61197
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_es 61198
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_es 61199
#define IDS_PERMISSION_REQUEST_CAMERA_et 61200
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_et 61201
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_et 61202
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_et 61203
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_et 61204
#define IDS_PERMISSION_REQUEST_MICROPHONE_et 61205
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_et 61206
#define IDS_PERMISSION_REQUEST_GEOLOCATION_et 61207
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_et 61208
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_et 61209
#define IDS_PERMISSION_REQUEST_CAMERA_eu 61210
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_eu 61211
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_eu 61212
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_eu 61213
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_eu 61214
#define IDS_PERMISSION_REQUEST_MICROPHONE_eu 61215
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_eu 61216
#define IDS_PERMISSION_REQUEST_GEOLOCATION_eu 61217
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_eu 61218
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_eu 61219
#define IDS_PERMISSION_REQUEST_CAMERA_fa 61220
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fa 61221
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fa 61222
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fa 61223
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fa 61224
#define IDS_PERMISSION_REQUEST_MICROPHONE_fa 61225
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fa 61226
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fa 61227
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fa 61228
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fa 61229
#define IDS_PERMISSION_REQUEST_CAMERA_fi 61230
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fi 61231
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fi 61232
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fi 61233
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fi 61234
#define IDS_PERMISSION_REQUEST_MICROPHONE_fi 61235
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fi 61236
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fi 61237
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fi 61238
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fi 61239
#define IDS_PERMISSION_REQUEST_CAMERA_fil 61240
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fil 61241
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fil 61242
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fil 61243
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fil 61244
#define IDS_PERMISSION_REQUEST_MICROPHONE_fil 61245
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fil 61246
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fil 61247
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fil 61248
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fil 61249
#define IDS_PERMISSION_REQUEST_CAMERA_fr_CA 61250
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fr_CA 61251
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fr_CA 61252
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fr_CA 61253
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fr_CA 61254
#define IDS_PERMISSION_REQUEST_MICROPHONE_fr_CA 61255
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fr_CA 61256
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fr_CA 61257
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fr_CA 61258
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fr_CA 61259
#define IDS_PERMISSION_REQUEST_CAMERA_fr 61260
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_fr 61261
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_fr 61262
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_fr 61263
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_fr 61264
#define IDS_PERMISSION_REQUEST_MICROPHONE_fr 61265
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_fr 61266
#define IDS_PERMISSION_REQUEST_GEOLOCATION_fr 61267
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_fr 61268
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_fr 61269
#define IDS_PERMISSION_REQUEST_CAMERA_gl 61270
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_gl 61271
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_gl 61272
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_gl 61273
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_gl 61274
#define IDS_PERMISSION_REQUEST_MICROPHONE_gl 61275
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_gl 61276
#define IDS_PERMISSION_REQUEST_GEOLOCATION_gl 61277
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_gl 61278
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_gl 61279
#define IDS_PERMISSION_REQUEST_CAMERA_gu 61280
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_gu 61281
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_gu 61282
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_gu 61283
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_gu 61284
#define IDS_PERMISSION_REQUEST_MICROPHONE_gu 61285
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_gu 61286
#define IDS_PERMISSION_REQUEST_GEOLOCATION_gu 61287
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_gu 61288
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_gu 61289
#define IDS_PERMISSION_REQUEST_CAMERA_hi 61290
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hi 61291
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hi 61292
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hi 61293
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hi 61294
#define IDS_PERMISSION_REQUEST_MICROPHONE_hi 61295
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hi 61296
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hi 61297
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hi 61298
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hi 61299
#define IDS_PERMISSION_REQUEST_CAMERA_hr 61300
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hr 61301
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hr 61302
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hr 61303
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hr 61304
#define IDS_PERMISSION_REQUEST_MICROPHONE_hr 61305
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hr 61306
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hr 61307
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hr 61308
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hr 61309
#define IDS_PERMISSION_REQUEST_CAMERA_hu 61310
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hu 61311
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hu 61312
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hu 61313
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hu 61314
#define IDS_PERMISSION_REQUEST_MICROPHONE_hu 61315
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hu 61316
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hu 61317
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hu 61318
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hu 61319
#define IDS_PERMISSION_REQUEST_CAMERA_hy 61320
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_hy 61321
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_hy 61322
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_hy 61323
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_hy 61324
#define IDS_PERMISSION_REQUEST_MICROPHONE_hy 61325
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_hy 61326
#define IDS_PERMISSION_REQUEST_GEOLOCATION_hy 61327
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_hy 61328
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_hy 61329
#define IDS_PERMISSION_REQUEST_CAMERA_id 61330
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_id 61331
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_id 61332
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_id 61333
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_id 61334
#define IDS_PERMISSION_REQUEST_MICROPHONE_id 61335
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_id 61336
#define IDS_PERMISSION_REQUEST_GEOLOCATION_id 61337
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_id 61338
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_id 61339
#define IDS_PERMISSION_REQUEST_CAMERA_is 61340
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_is 61341
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_is 61342
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_is 61343
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_is 61344
#define IDS_PERMISSION_REQUEST_MICROPHONE_is 61345
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_is 61346
#define IDS_PERMISSION_REQUEST_GEOLOCATION_is 61347
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_is 61348
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_is 61349
#define IDS_PERMISSION_REQUEST_CAMERA_it 61350
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_it 61351
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_it 61352
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_it 61353
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_it 61354
#define IDS_PERMISSION_REQUEST_MICROPHONE_it 61355
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_it 61356
#define IDS_PERMISSION_REQUEST_GEOLOCATION_it 61357
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_it 61358
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_it 61359
#define IDS_PERMISSION_REQUEST_CAMERA_iw 61360
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_iw 61361
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_iw 61362
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_iw 61363
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_iw 61364
#define IDS_PERMISSION_REQUEST_MICROPHONE_iw 61365
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_iw 61366
#define IDS_PERMISSION_REQUEST_GEOLOCATION_iw 61367
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_iw 61368
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_iw 61369
#define IDS_PERMISSION_REQUEST_CAMERA_ja 61370
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ja 61371
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ja 61372
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ja 61373
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ja 61374
#define IDS_PERMISSION_REQUEST_MICROPHONE_ja 61375
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ja 61376
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ja 61377
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ja 61378
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ja 61379
#define IDS_PERMISSION_REQUEST_CAMERA_ka 61380
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ka 61381
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ka 61382
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ka 61383
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ka 61384
#define IDS_PERMISSION_REQUEST_MICROPHONE_ka 61385
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ka 61386
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ka 61387
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ka 61388
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ka 61389
#define IDS_PERMISSION_REQUEST_CAMERA_kk 61390
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_kk 61391
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_kk 61392
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_kk 61393
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_kk 61394
#define IDS_PERMISSION_REQUEST_MICROPHONE_kk 61395
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_kk 61396
#define IDS_PERMISSION_REQUEST_GEOLOCATION_kk 61397
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_kk 61398
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_kk 61399
#define IDS_PERMISSION_REQUEST_CAMERA_km 61400
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_km 61401
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_km 61402
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_km 61403
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_km 61404
#define IDS_PERMISSION_REQUEST_MICROPHONE_km 61405
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_km 61406
#define IDS_PERMISSION_REQUEST_GEOLOCATION_km 61407
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_km 61408
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_km 61409
#define IDS_PERMISSION_REQUEST_CAMERA_kn 61410
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_kn 61411
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_kn 61412
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_kn 61413
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_kn 61414
#define IDS_PERMISSION_REQUEST_MICROPHONE_kn 61415
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_kn 61416
#define IDS_PERMISSION_REQUEST_GEOLOCATION_kn 61417
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_kn 61418
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_kn 61419
#define IDS_PERMISSION_REQUEST_CAMERA_ko 61420
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ko 61421
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ko 61422
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ko 61423
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ko 61424
#define IDS_PERMISSION_REQUEST_MICROPHONE_ko 61425
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ko 61426
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ko 61427
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ko 61428
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ko 61429
#define IDS_PERMISSION_REQUEST_CAMERA_ky 61430
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ky 61431
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ky 61432
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ky 61433
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ky 61434
#define IDS_PERMISSION_REQUEST_MICROPHONE_ky 61435
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ky 61436
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ky 61437
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ky 61438
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ky 61439
#define IDS_PERMISSION_REQUEST_CAMERA_lo 61440
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lo 61441
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lo 61442
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lo 61443
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lo 61444
#define IDS_PERMISSION_REQUEST_MICROPHONE_lo 61445
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lo 61446
#define IDS_PERMISSION_REQUEST_GEOLOCATION_lo 61447
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lo 61448
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lo 61449
#define IDS_PERMISSION_REQUEST_CAMERA_lt 61450
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lt 61451
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lt 61452
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lt 61453
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lt 61454
#define IDS_PERMISSION_REQUEST_MICROPHONE_lt 61455
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lt 61456
#define IDS_PERMISSION_REQUEST_GEOLOCATION_lt 61457
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lt 61458
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lt 61459
#define IDS_PERMISSION_REQUEST_CAMERA_lv 61460
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_lv 61461
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_lv 61462
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_lv 61463
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_lv 61464
#define IDS_PERMISSION_REQUEST_MICROPHONE_lv 61465
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_lv 61466
#define IDS_PERMISSION_REQUEST_GEOLOCATION_lv 61467
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_lv 61468
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_lv 61469
#define IDS_PERMISSION_REQUEST_CAMERA_mk 61470
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mk 61471
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mk 61472
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mk 61473
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mk 61474
#define IDS_PERMISSION_REQUEST_MICROPHONE_mk 61475
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mk 61476
#define IDS_PERMISSION_REQUEST_GEOLOCATION_mk 61477
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mk 61478
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mk 61479
#define IDS_PERMISSION_REQUEST_CAMERA_ml 61480
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ml 61481
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ml 61482
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ml 61483
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ml 61484
#define IDS_PERMISSION_REQUEST_MICROPHONE_ml 61485
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ml 61486
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ml 61487
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ml 61488
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ml 61489
#define IDS_PERMISSION_REQUEST_CAMERA_mn 61490
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mn 61491
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mn 61492
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mn 61493
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mn 61494
#define IDS_PERMISSION_REQUEST_MICROPHONE_mn 61495
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mn 61496
#define IDS_PERMISSION_REQUEST_GEOLOCATION_mn 61497
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mn 61498
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mn 61499
#define IDS_PERMISSION_REQUEST_CAMERA_mr 61500
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_mr 61501
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_mr 61502
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_mr 61503
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_mr 61504
#define IDS_PERMISSION_REQUEST_MICROPHONE_mr 61505
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_mr 61506
#define IDS_PERMISSION_REQUEST_GEOLOCATION_mr 61507
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_mr 61508
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_mr 61509
#define IDS_PERMISSION_REQUEST_CAMERA_ms 61510
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ms 61511
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ms 61512
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ms 61513
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ms 61514
#define IDS_PERMISSION_REQUEST_MICROPHONE_ms 61515
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ms 61516
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ms 61517
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ms 61518
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ms 61519
#define IDS_PERMISSION_REQUEST_CAMERA_my 61520
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_my 61521
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_my 61522
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_my 61523
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_my 61524
#define IDS_PERMISSION_REQUEST_MICROPHONE_my 61525
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_my 61526
#define IDS_PERMISSION_REQUEST_GEOLOCATION_my 61527
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_my 61528
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_my 61529
#define IDS_PERMISSION_REQUEST_CAMERA_ne 61530
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ne 61531
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ne 61532
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ne 61533
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ne 61534
#define IDS_PERMISSION_REQUEST_MICROPHONE_ne 61535
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ne 61536
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ne 61537
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ne 61538
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ne 61539
#define IDS_PERMISSION_REQUEST_CAMERA_nl 61540
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_nl 61541
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_nl 61542
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_nl 61543
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_nl 61544
#define IDS_PERMISSION_REQUEST_MICROPHONE_nl 61545
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_nl 61546
#define IDS_PERMISSION_REQUEST_GEOLOCATION_nl 61547
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_nl 61548
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_nl 61549
#define IDS_PERMISSION_REQUEST_CAMERA_no 61550
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_no 61551
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_no 61552
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_no 61553
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_no 61554
#define IDS_PERMISSION_REQUEST_MICROPHONE_no 61555
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_no 61556
#define IDS_PERMISSION_REQUEST_GEOLOCATION_no 61557
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_no 61558
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_no 61559
#define IDS_PERMISSION_REQUEST_CAMERA_or 61560
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_or 61561
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_or 61562
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_or 61563
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_or 61564
#define IDS_PERMISSION_REQUEST_MICROPHONE_or 61565
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_or 61566
#define IDS_PERMISSION_REQUEST_GEOLOCATION_or 61567
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_or 61568
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_or 61569
#define IDS_PERMISSION_REQUEST_CAMERA_pa 61570
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pa 61571
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pa 61572
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pa 61573
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pa 61574
#define IDS_PERMISSION_REQUEST_MICROPHONE_pa 61575
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pa 61576
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pa 61577
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pa 61578
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pa 61579
#define IDS_PERMISSION_REQUEST_CAMERA_pl 61580
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pl 61581
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pl 61582
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pl 61583
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pl 61584
#define IDS_PERMISSION_REQUEST_MICROPHONE_pl 61585
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pl 61586
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pl 61587
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pl 61588
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pl 61589
#define IDS_PERMISSION_REQUEST_CAMERA_pt_BR 61590
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pt_BR 61591
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pt_BR 61592
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pt_BR 61593
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pt_BR 61594
#define IDS_PERMISSION_REQUEST_MICROPHONE_pt_BR 61595
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pt_BR 61596
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pt_BR 61597
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pt_BR 61598
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pt_BR 61599
#define IDS_PERMISSION_REQUEST_CAMERA_pt_PT 61600
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_pt_PT 61601
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_pt_PT 61602
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_pt_PT 61603
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_pt_PT 61604
#define IDS_PERMISSION_REQUEST_MICROPHONE_pt_PT 61605
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_pt_PT 61606
#define IDS_PERMISSION_REQUEST_GEOLOCATION_pt_PT 61607
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_pt_PT 61608
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_pt_PT 61609
#define IDS_PERMISSION_REQUEST_CAMERA_ro 61610
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ro 61611
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ro 61612
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ro 61613
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ro 61614
#define IDS_PERMISSION_REQUEST_MICROPHONE_ro 61615
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ro 61616
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ro 61617
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ro 61618
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ro 61619
#define IDS_PERMISSION_REQUEST_CAMERA_ru 61620
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ru 61621
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ru 61622
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ru 61623
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ru 61624
#define IDS_PERMISSION_REQUEST_MICROPHONE_ru 61625
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ru 61626
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ru 61627
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ru 61628
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ru 61629
#define IDS_PERMISSION_REQUEST_CAMERA_si 61630
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_si 61631
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_si 61632
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_si 61633
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_si 61634
#define IDS_PERMISSION_REQUEST_MICROPHONE_si 61635
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_si 61636
#define IDS_PERMISSION_REQUEST_GEOLOCATION_si 61637
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_si 61638
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_si 61639
#define IDS_PERMISSION_REQUEST_CAMERA_sk 61640
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sk 61641
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sk 61642
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sk 61643
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sk 61644
#define IDS_PERMISSION_REQUEST_MICROPHONE_sk 61645
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sk 61646
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sk 61647
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sk 61648
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sk 61649
#define IDS_PERMISSION_REQUEST_CAMERA_sl 61650
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sl 61651
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sl 61652
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sl 61653
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sl 61654
#define IDS_PERMISSION_REQUEST_MICROPHONE_sl 61655
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sl 61656
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sl 61657
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sl 61658
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sl 61659
#define IDS_PERMISSION_REQUEST_CAMERA_sq 61660
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sq 61661
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sq 61662
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sq 61663
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sq 61664
#define IDS_PERMISSION_REQUEST_MICROPHONE_sq 61665
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sq 61666
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sq 61667
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sq 61668
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sq 61669
#define IDS_PERMISSION_REQUEST_CAMERA_sr_Latn 61670
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sr_Latn 61671
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sr_Latn 61672
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sr_Latn 61673
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sr_Latn 61674
#define IDS_PERMISSION_REQUEST_MICROPHONE_sr_Latn 61675
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sr_Latn 61676
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sr_Latn 61677
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sr_Latn 61678
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sr_Latn 61679
#define IDS_PERMISSION_REQUEST_CAMERA_sr 61680
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sr 61681
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sr 61682
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sr 61683
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sr 61684
#define IDS_PERMISSION_REQUEST_MICROPHONE_sr 61685
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sr 61686
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sr 61687
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sr 61688
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sr 61689
#define IDS_PERMISSION_REQUEST_CAMERA_sv 61690
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sv 61691
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sv 61692
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sv 61693
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sv 61694
#define IDS_PERMISSION_REQUEST_MICROPHONE_sv 61695
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sv 61696
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sv 61697
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sv 61698
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sv 61699
#define IDS_PERMISSION_REQUEST_CAMERA_sw 61700
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_sw 61701
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_sw 61702
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_sw 61703
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_sw 61704
#define IDS_PERMISSION_REQUEST_MICROPHONE_sw 61705
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_sw 61706
#define IDS_PERMISSION_REQUEST_GEOLOCATION_sw 61707
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_sw 61708
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_sw 61709
#define IDS_PERMISSION_REQUEST_CAMERA_ta 61710
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ta 61711
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ta 61712
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ta 61713
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ta 61714
#define IDS_PERMISSION_REQUEST_MICROPHONE_ta 61715
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ta 61716
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ta 61717
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ta 61718
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ta 61719
#define IDS_PERMISSION_REQUEST_CAMERA_te 61720
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_te 61721
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_te 61722
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_te 61723
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_te 61724
#define IDS_PERMISSION_REQUEST_MICROPHONE_te 61725
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_te 61726
#define IDS_PERMISSION_REQUEST_GEOLOCATION_te 61727
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_te 61728
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_te 61729
#define IDS_PERMISSION_REQUEST_CAMERA_th 61730
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_th 61731
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_th 61732
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_th 61733
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_th 61734
#define IDS_PERMISSION_REQUEST_MICROPHONE_th 61735
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_th 61736
#define IDS_PERMISSION_REQUEST_GEOLOCATION_th 61737
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_th 61738
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_th 61739
#define IDS_PERMISSION_REQUEST_CAMERA_tr 61740
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_tr 61741
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_tr 61742
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_tr 61743
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_tr 61744
#define IDS_PERMISSION_REQUEST_MICROPHONE_tr 61745
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_tr 61746
#define IDS_PERMISSION_REQUEST_GEOLOCATION_tr 61747
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_tr 61748
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_tr 61749
#define IDS_PERMISSION_REQUEST_CAMERA_uk 61750
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_uk 61751
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_uk 61752
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_uk 61753
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_uk 61754
#define IDS_PERMISSION_REQUEST_MICROPHONE_uk 61755
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_uk 61756
#define IDS_PERMISSION_REQUEST_GEOLOCATION_uk 61757
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_uk 61758
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_uk 61759
#define IDS_PERMISSION_REQUEST_CAMERA_ur 61760
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_ur 61761
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_ur 61762
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_ur 61763
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_ur 61764
#define IDS_PERMISSION_REQUEST_MICROPHONE_ur 61765
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_ur 61766
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ur 61767
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ur 61768
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ur 61769
#define IDS_PERMISSION_REQUEST_CAMERA_uz 61770
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_uz 61771
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_uz 61772
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_uz 61773
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_uz 61774
#define IDS_PERMISSION_REQUEST_MICROPHONE_uz 61775
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_uz 61776
#define IDS_PERMISSION_REQUEST_GEOLOCATION_uz 61777
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_uz 61778
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_uz 61779
#define IDS_PERMISSION_REQUEST_CAMERA_vi 61780
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_vi 61781
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_vi 61782
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_vi 61783
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_vi 61784
#define IDS_PERMISSION_REQUEST_MICROPHONE_vi 61785
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_vi 61786
#define IDS_PERMISSION_REQUEST_GEOLOCATION_vi 61787
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_vi 61788
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_vi 61789
#define IDS_PERMISSION_REQUEST_CAMERA_zh_CN 61790
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_CN 61791
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_CN 61792
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_CN 61793
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_CN 61794
#define IDS_PERMISSION_REQUEST_MICROPHONE_zh_CN 61795
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_CN 61796
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zh_CN 61797
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_CN 61798
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_CN 61799
#define IDS_PERMISSION_REQUEST_CAMERA_zh_HK 61800
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_HK 61801
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_HK 61802
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_HK 61803
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_HK 61804
#define IDS_PERMISSION_REQUEST_MICROPHONE_zh_HK 61805
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_HK 61806
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zh_HK 61807
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_HK 61808
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_HK 61809
#define IDS_PERMISSION_REQUEST_CAMERA_zh_TW 61810
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zh_TW 61811
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zh_TW 61812
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zh_TW 61813
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zh_TW 61814
#define IDS_PERMISSION_REQUEST_MICROPHONE_zh_TW 61815
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zh_TW 61816
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zh_TW 61817
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zh_TW 61818
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zh_TW 61819
#define IDS_PERMISSION_REQUEST_CAMERA_zu 61820
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED_zu 61821
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED_zu 61822
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED_zu 61823
#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED_zu 61824
#define IDS_PERMISSION_REQUEST_MICROPHONE_zu 61825
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED_zu 61826
#define IDS_PERMISSION_REQUEST_GEOLOCATION_zu 61827
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_zu 61828
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_zu 61829

// ---------------------------------------------------------------------------
// From permission_element_strings.h:

#define IDS_PERMISSION_REQUEST_CAMERA_ALLOWED 50120
#define IDS_PERMISSION_REQUEST_CAMERA 50121
#define IDS_PERMISSION_REQUEST_MICROPHONE_ALLOWED 50122
#define IDS_PERMISSION_REQUEST_MICROPHONE 50123
#define IDS_PERMISSION_REQUEST_GEOLOCATION_ALLOWED 50124
#define IDS_PERMISSION_REQUEST_GEOLOCATION 50125
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE_ALLOWED 50126
#define IDS_PERMISSION_REQUEST_CAMERA_MICROPHONE 50127
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION_ALLOWED 50128
#define IDS_PERMISSION_REQUEST_PRECISE_GEOLOCATION 50129

// ---------------------------------------------------------------------------
// From platform_locale_settings.h:

#define IDS_STANDARD_FONT_FAMILY 106
#define IDS_FIXED_FONT_FAMILY 107
#define IDS_FIXED_FONT_FAMILY_ALT_WIN 108
#define IDS_SERIF_FONT_FAMILY 109
#define IDS_SANS_SERIF_FONT_FAMILY 110
#define IDS_NTP_FONT_FAMILY 17100
#define IDS_CURSIVE_FONT_FAMILY 111
#define IDS_FANTASY_FONT_FAMILY 112
#define IDS_MATH_FONT_FAMILY 113
#define IDS_STANDARD_FONT_FAMILY_CYRILLIC 131
#define IDS_FIXED_FONT_FAMILY_ARABIC 129
#define IDS_FIXED_FONT_FAMILY_CYRILLIC 132
#define IDS_SANS_SERIF_FONT_FAMILY_ARABIC 130
#define IDS_SERIF_FONT_FAMILY_CYRILLIC 133
#define IDS_SANS_SERIF_FONT_FAMILY_CYRILLIC 134
#define IDS_STANDARD_FONT_FAMILY_GREEK 135
#define IDS_FIXED_FONT_FAMILY_GREEK 136
#define IDS_SERIF_FONT_FAMILY_GREEK 137
#define IDS_SANS_SERIF_FONT_FAMILY_GREEK 138
#define IDS_STANDARD_FONT_FAMILY_JAPANESE 114
#define IDS_FIXED_FONT_FAMILY_JAPANESE 115
#define IDS_SERIF_FONT_FAMILY_JAPANESE 116
#define IDS_SANS_SERIF_FONT_FAMILY_JAPANESE 117
#define IDS_STANDARD_FONT_FAMILY_KOREAN 118
#define IDS_FIXED_FONT_FAMILY_KOREAN 139
#define IDS_SERIF_FONT_FAMILY_KOREAN 119
#define IDS_SANS_SERIF_FONT_FAMILY_KOREAN 120
#define IDS_CURSIVE_FONT_FAMILY_KOREAN 140
#define IDS_STANDARD_FONT_FAMILY_SIMPLIFIED_HAN 121
#define IDS_FIXED_FONT_FAMILY_SIMPLIFIED_HAN 141
#define IDS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 122
#define IDS_SANS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 123
#define IDS_CURSIVE_FONT_FAMILY_SIMPLIFIED_HAN 127
#define IDS_STANDARD_FONT_FAMILY_TRADITIONAL_HAN 124
#define IDS_FIXED_FONT_FAMILY_TRADITIONAL_HAN 142
#define IDS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 125
#define IDS_SANS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 126
#define IDS_CURSIVE_FONT_FAMILY_TRADITIONAL_HAN 128
#define IDS_MINIMUM_FONT_SIZE 143
#define IDS_MINIMUM_LOGICAL_FONT_SIZE 144

// ---------------------------------------------------------------------------
// From services_strings.h:

#define IDS_PROXY_RESOLVER_DISPLAY_NAME 49920
#define IDS_WINDOWS_SYSTEM_PROXY_RESOLVER_DISPLAY_NAME 49921
#define IDS_PDF_OCR_RESULT_BEGIN 49922
#define IDS_PDF_OCR_RESULT_END 49923

// ---------------------------------------------------------------------------
// From ui_strings.h:

#define IDS_TIME_SECS 54490
#define IDS_TIME_LONG_SECS 54491
#define IDS_TIME_LONG_SECS_2ND 54492
#define IDS_TIME_MINS 54493
#define IDS_TIME_LONG_MINS 54494
#define IDS_TIME_LONG_MINS_1ST 54495
#define IDS_TIME_LONG_MINS_2ND 54496
#define IDS_TIME_HOURS 54497
#define IDS_TIME_HOURS_1ST 54498
#define IDS_TIME_HOURS_2ND 54499
#define IDS_TIME_DAYS 54500
#define IDS_TIME_DAYS_1ST 54501
#define IDS_TIME_MONTHS 54502
#define IDS_TIME_YEARS 54503
#define IDS_TIME_REMAINING_SECS 54504
#define IDS_TIME_REMAINING_LONG_SECS 54505
#define IDS_TIME_REMAINING_MINS 54506
#define IDS_TIME_REMAINING_LONG_MINS 54507
#define IDS_TIME_REMAINING_HOURS 54508
#define IDS_TIME_REMAINING_DAYS 54509
#define IDS_TIME_REMAINING_MONTHS 54510
#define IDS_TIME_REMAINING_YEARS 54511
#define IDS_TIME_ELAPSED_SECS 54512
#define IDS_TIME_ELAPSED_LONG_SECS 54513
#define IDS_TIME_ELAPSED_MINS 54514
#define IDS_TIME_ELAPSED_LONG_MINS 54515
#define IDS_TIME_ELAPSED_HOURS 54516
#define IDS_TIME_ELAPSED_DAYS 54517
#define IDS_TIME_ELAPSED_MONTHS 54518
#define IDS_TIME_ELAPSED_YEARS 54519
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_SECS 54520
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_MINS 54521
#define IDS_TIME_TITLE_CASE_ELAPSED_HOURS 54522
#define IDS_TIME_TITLE_CASE_ELAPSED_DAYS 54523
#define IDS_TIME_TITLE_CASE_ELAPSED_MONTHS 54524
#define IDS_TIME_TITLE_CASE_ELAPSED_YEARS 54525
#define IDS_PAST_TIME_TODAY 54526
#define IDS_PAST_TIME_YESTERDAY 54527
#define IDS_TIME_TOMORROW 54528
#define IDS_APP_MENU_EMPTY_SUBMENU 54529
#define IDS_APP_MENU_AX_ANNOUNCE_EMPTY_SUBMENU 54530
#define IDS_CLIPBOARD_MENU_HTML 54531
#define IDS_CLIPBOARD_MENU_IMAGE 54532
#define IDS_CLIPBOARD_MENU_RTF_CONTENT 54533
#define IDS_CLIPBOARD_MENU_WEB_SMART_PASTE 54534
#define IDS_CLIPBOARD_MENU_CLIPBOARD 54535
#define IDS_CLIPBOARD_MENU_DELETE_ALL 54536
#define IDS_EXTENSION_PINNED 54537
#define IDS_EXTENSION_UNPINNED 54538
#define IDS_NEW_BADGE 54539
#define IDS_NEW_BADGE_SCREEN_READER_MESSAGE 54540
#define IDS_SENTENCE_END 54541
#define IDS_CONCAT_TWO_STRINGS_WITH_COMMA 54542
#define IDS_CONCAT_THREE_STRINGS_WITH_COMMA 54543
#define IDS_CONCAT_TWO_STRINGS_WITH_PERIODS 54544
#define IDS_APP_UNTITLED_SHORTCUT_FILE_NAME 54545
#define IDS_APP_SAVEAS_ALL_FILES 54546
#define IDS_APP_SAVEAS_EXTENSION_FORMAT 54547
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_TITLE 54548
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_MENU 54556
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_DEFAULT 54557
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_LTR 54558
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_RTL 54559
#define IDS_SELECT_FOLDER_DIALOG_TITLE 54560
#define IDS_SAVE_AS_DIALOG_TITLE 54561
#define IDS_OPEN_FILE_DIALOG_TITLE 54562
#define IDS_OPEN_FILES_DIALOG_TITLE 54563
#define IDS_SAVEAS_ALL_FILES 54564
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_UPLOAD_BUTTON 54565
#define IDS_APP_ACCNAME_BACK 54566
#define IDS_APP_ACCNAME_CENTER 54567
#define IDS_APP_ACCNAME_CLOSE 404
#define IDS_APP_ACCNAME_MINIMIZE 401
#define IDS_APP_ACCNAME_MAXIMIZE 402
#define IDS_APP_ACCNAME_RESTORE 403
#define IDS_APP_ACCNAME_MENU 54568
#define IDS_APP_ACCNAME_COLOR_CHOOSER_HEX_INPUT 54569
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHERE 54570
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFTEDGE 54571
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHTEDGE 54572
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHOME 54573
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLEND 54574
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEUP 54575
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEDOWN 54576
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFT 54577
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHT 54578
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLUP 54579
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLDOWN 54580
#define IDS_APP_TABLE_COLUMN_NOT_SORTED_ACCNAME 54581
#define IDS_APP_TABLE_COLUMN_SORTED_ASC_ACCNAME 54582
#define IDS_APP_TABLE_COLUMN_SORTED_DESC_ACCNAME 54583
#define IDS_APP_UNDO 54584
#define IDS_APP_CUT 54585
#define IDS_APP_COPY 407
#define IDS_APP_PASTE 54586
#define IDS_APP_DELETE 54587
#define IDS_APP_SELECT_ALL 408
#define IDS_APP_SELECT 54588
#define IDS_CONTENT_CONTEXT_EMOJI 54589
#define IDS_APP_OK 54592
#define IDS_APP_CANCEL 54593
#define IDS_APP_CLOSE 54594
#define IDS_APP_CONTINUE 54595
#define IDS_APP_ESC_KEY 54596
#define IDS_APP_TAB_KEY 54597
#define IDS_APP_INSERT_KEY 54598
#define IDS_APP_HOME_KEY 54599
#define IDS_APP_DELETE_KEY 54600
#define IDS_APP_END_KEY 54601
#define IDS_APP_PAGEUP_KEY 54602
#define IDS_APP_PAGEDOWN_KEY 54603
#define IDS_APP_LEFT_ARROW_KEY 54604
#define IDS_APP_RIGHT_ARROW_KEY 54605
#define IDS_APP_UP_ARROW_KEY 54606
#define IDS_APP_DOWN_ARROW_KEY 54607
#define IDS_APP_ENTER_KEY 54608
#define IDS_APP_SPACE_KEY 54609
#define IDS_APP_F1_KEY 54610
#define IDS_APP_F5_KEY 54611
#define IDS_APP_F6_KEY 54612
#define IDS_APP_F11_KEY 54613
#define IDS_APP_BACKSPACE_KEY 54614
#define IDS_APP_COMMA_KEY 54615
#define IDS_APP_PERIOD_KEY 54616
#define IDS_APP_MEDIA_NEXT_TRACK_KEY 54617
#define IDS_APP_MEDIA_PLAY_PAUSE_KEY 54618
#define IDS_APP_MEDIA_PREV_TRACK_KEY 54619
#define IDS_APP_MEDIA_STOP_KEY 54620
#define IDS_APP_ALT_KEY 54621
#define IDS_APP_COMMAND_KEY 54622
#define IDS_APP_CTRL_KEY 480
#define IDS_APP_SEARCH_KEY 54623
#define IDS_APP_SHIFT_KEY 54624
#define IDS_APP_WINDOWS_KEY 54625
#define IDS_APP_ACCELERATOR_WITH_MODIFIER 481
#define IDS_APP_BYTES 54630
#define IDS_APP_KIBIBYTES 54631
#define IDS_APP_MEBIBYTES 54632
#define IDS_APP_GIBIBYTES 54633
#define IDS_APP_TEBIBYTES 54634
#define IDS_APP_PEBIBYTES 54635
#define IDS_APP_BYTES_PER_SECOND 54636
#define IDS_APP_KIBIBYTES_PER_SECOND 54637
#define IDS_APP_MEBIBYTES_PER_SECOND 54638
#define IDS_APP_GIBIBYTES_PER_SECOND 54639
#define IDS_APP_TEBIBYTES_PER_SECOND 54640
#define IDS_APP_PEBIBYTES_PER_SECOND 54641
#define IDS_MESSAGE_CENTER_ACCESSIBLE_NAME 54642
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME 54643
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME_PLURAL 54644
#define IDS_MESSAGE_CENTER_EXPAND_NOTIFICATION 54645
#define IDS_MESSAGE_CENTER_COLLAPSE_NOTIFICATION 54646
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_MESSAGE_WITH_DIVIDER 54647
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_HEADER_OVERFLOW_INDICATOR 54648
#define IDS_MESSAGE_CENTER_NOTIFICATION_PROGRESS_PERCENTAGE 54649
#define IDS_MESSAGE_CENTER_NOTIFICATION_CHROMEOS_SYSTEM 54650
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_PLACEHOLDER 54651
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_ACCESSIBLE_NAME 54652
#define IDS_MESSAGE_NOTIFICATION_NOW_STRING_SHORTEST 54653
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST 54654
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST 54655
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST 54656
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST 54657
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST_FUTURE 54658
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST_FUTURE 54659
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST_FUTURE 54660
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST_FUTURE 54661
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_SITE 54662
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_APP 54663
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS 54664
#define IDS_MESSAGE_CENTER_DONT_BLOCK_NOTIFICATIONS 54665
#define IDS_MESSAGE_CENTER_SETTINGS_DONE 54666
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_ACCESSIBLE_NAME 54667
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_TOOLTIP 54668
#define IDS_MESSAGE_CENTER_NOTIFICATION_SNOOZE_BUTTON_TOOLTIP 54669
#define IDS_MESSAGE_NOTIFICATION_SETTINGS_BUTTON_ACCESSIBLE_NAME 54670
#define IDS_MESSAGE_NOTIFICATION_ACCESSIBLE_NAME 54671
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_DEVICE_INFO 54672
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_SUCCESS 54673
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_TITLE 54674
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_MESSAGE 54675
#define IDS_CLIPBOARD_HISTORY_MENU_PNG_IMAGE 54677
#define IDS_CLIPBOARD_HISTORY_MENU_HTML_IMAGE 54678
#define IDS_CLIPBOARD_HISTORY_MENU_TITLE 54679
#define IDS_CLIPBOARD_HISTORY_DELETE_ITEM_TEXT 54680
#define IDS_CLIPBOARD_HISTORY_DELETE_BUTTON_HOVER_TEXT 54681
#define IDS_CLIPBOARD_HISTORY_ITEM_DELETION 54682
#define IDS_DISPLAY_TOUCH_CALIBRATION_EXIT_LABEL 54683
#define IDS_DISPLAY_TOUCH_CALIBRATION_SECONDARY_SKIP_LABEL 54684
#define IDS_DISPLAY_TOUCH_CALIBRATION_PRIMARY_SKIP_LABEL 54685
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_LABEL_TEXT 54686
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_SUBLABEL_TEXT 54687
#define IDS_DISPLAY_TOUCH_CALIBRATION_TAP_HERE_LABEL 54688
#define IDS_DISPLAY_TOUCH_CALIBRATION_FINISH_LABEL 54689
#define IDS_DISPLAY_NAME_UNKNOWN 54690
#define IDS_DISPLAY_NAME_INTERNAL 54691
#define IDS_CROSTINI_USE_LOW_DENSITY 54692
#define IDS_CROSTINI_USE_HIGH_DENSITY 54693
#define IDS_CROSTINI_APP_RESTART_BODY 54694
#define IDS_SATURATED_BADGE_CONTENT 54695
#define IDS_BADGE_UNREAD_NOTIFICATIONS_SATURATED 54696
#define IDS_BADGE_UNREAD_NOTIFICATIONS_UNSPECIFIED 54697
#define IDS_BADGE_UNREAD_NOTIFICATIONS 54698
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_LABEL 687
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_NO_DEVICES 54699
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_CALL_BUTTON_LABEL 54700
#define IDS_BROWSER_SHARING_OMNIBOX_SENDING_LABEL 467
#define IDS_BROWSER_SHARING_DIALOG_DEVICE_SUBTITLE_LAST_ACTIVE_DAYS 54701
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_INITIATING_ORIGIN 54702
#define IDS_BROWSER_SHARING_CONTENT_TYPE_TEXT 54703
#define IDS_BROWSER_SHARING_CONTENT_TYPE_NUMBER 54704
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_GENERIC_ERROR 54705
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_INTERNAL_ERROR 54706
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_NETWORK_ERROR 54707
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_ACK_TIMEOUT 54708
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_INTERNAL_ERROR 54709
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TITLE_PAYLOAD_TOO_LARGE 54710
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TEXT_PAYLOAD_TOO_LARGE 54711
#define IDS_SETTINGS_PASSWORD_SHOW 54715
#define IDS_SETTINGS_PASSWORD_HIDE 54716
#define IDS_TABLE_VIEW_AX_ANNOUNCE_ROW_SELECTED 54717
#define IDS_LINK_COPIED 54718

#endif  // CEF_INCLUDE_CEF_PACK_STRINGS_H_
