// Copyright (c) 2023 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_STRINGS_H_
#define CEF_INCLUDE_CEF_PACK_STRINGS_H_
#pragma once

// ---------------------------------------------------------------------------
// From blink_accessibility_strings.h:

#define IDS_AX_UNLABELED_IMAGE_ROLE_DESCRIPTION 41530
#define IDS_AX_IMAGE_ELIGIBLE_FOR_ANNOTATION 41533
#define IDS_AX_IMAGE_ANNOTATION_PENDING 41534
#define IDS_AX_IMAGE_ANNOTATION_ADULT 41535
#define IDS_AX_IMAGE_ANNOTATION_NO_DESCRIPTION 41536
#define IDS_AX_IMAGE_ANNOTATION_OCR_CONTEXT 41537
#define IDS_AX_IMAGE_ANNOTATION_DESCRIPTION_CONTEXT 41538
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLUS 41539
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_BACKWARD 41540
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_FORWARD 41541
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALL 41542
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHAT 41543
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHECK 41544
#define IDS_AX_IMAGE_ANNOTATION_ICON_X 41545
#define IDS_AX_IMAGE_ANNOTATION_ICON_DELETE 41546
#define IDS_AX_IMAGE_ANNOTATION_ICON_EDIT 41547
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI 41548
#define IDS_AX_IMAGE_ANNOTATION_ICON_END_CALL 41549
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_DOWNWARD 41550
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEART 41551
#define IDS_AX_IMAGE_ANNOTATION_ICON_HOME 41552
#define IDS_AX_IMAGE_ANNOTATION_ICON_INFO 41553
#define IDS_AX_IMAGE_ANNOTATION_ICON_LAUNCH_APPS 41554
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_UP 41555
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_BARS 41556
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_DOTS 41557
#define IDS_AX_IMAGE_ANNOTATION_ICON_NOTIFICATIONS 41558
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAUSE 41559
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLAY 41560
#define IDS_AX_IMAGE_ANNOTATION_ICON_REFRESH 41561
#define IDS_AX_IMAGE_ANNOTATION_ICON_MAGNIFYING_GLASS 41562
#define IDS_AX_IMAGE_ANNOTATION_ICON_SEND 41563
#define IDS_AX_IMAGE_ANNOTATION_ICON_SETTINGS 41564
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHARE 41565
#define IDS_AX_IMAGE_ANNOTATION_ICON_STAR 41566
#define IDS_AX_IMAGE_ANNOTATION_ICON_TAKE_PHOTO 41567
#define IDS_AX_IMAGE_ANNOTATION_ICON_TIME 41568
#define IDS_AX_IMAGE_ANNOTATION_ICON_VIDEOCAM 41569
#define IDS_AX_IMAGE_ANNOTATION_ICON_EXPAND 41570
#define IDS_AX_IMAGE_ANNOTATION_ICON_CONTRACT 41571
#define IDS_AX_IMAGE_ANNOTATION_ICON_GOOGLE 41572
#define IDS_AX_IMAGE_ANNOTATION_ICON_TWITTER 41573
#define IDS_AX_IMAGE_ANNOTATION_ICON_FACEBOOK 41574
#define IDS_AX_IMAGE_ANNOTATION_ICON_ASSISTANT 41575
#define IDS_AX_IMAGE_ANNOTATION_ICON_WEATHER 41576
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_CART 41577
#define IDS_AX_IMAGE_ANNOTATION_ICON_UPLOAD 41578
#define IDS_AX_IMAGE_ANNOTATION_ICON_QUESTION 41579
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC 41580
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC_MUTE 41581
#define IDS_AX_IMAGE_ANNOTATION_ICON_GALLERY 41582
#define IDS_AX_IMAGE_ANNOTATION_ICON_COMPASS 41583
#define IDS_AX_IMAGE_ANNOTATION_ICON_PEOPLE 41584
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_UPWARD 41585
#define IDS_AX_IMAGE_ANNOTATION_ICON_ENVELOPE 41586
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI_FACE 41587
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAPERCLIP 41588
#define IDS_AX_IMAGE_ANNOTATION_ICON_CAST 41589
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_UP 41590
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_DOWN 41591
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_STATE 41592
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_MUTE 41593
#define IDS_AX_IMAGE_ANNOTATION_ICON_STOP 41594
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_BAG 41595
#define IDS_AX_IMAGE_ANNOTATION_ICON_LIST 41596
#define IDS_AX_IMAGE_ANNOTATION_ICON_LOCATION 41597
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALENDAR 41598
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_DOWN 41599
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEADSET 41600
#define IDS_AX_IMAGE_ANNOTATION_ICON_REDO 41601
#define IDS_AX_IMAGE_ANNOTATION_ICON_UNDO 41602
#define IDS_AX_IMAGE_ANNOTATION_ICON_DOWNLOAD 41603
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_DOWNWARD 41604
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_UPWARD 41605
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_FORWARD 41606
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_BACKWARD 41607
#define IDS_AX_IMAGE_ANNOTATION_ICON_HISTORY 41608
#define IDS_AX_IMAGE_ANNOTATION_ICON_PERSON 41609
#define IDS_AX_IMAGE_ANNOTATION_ICON_HAPPY_FACE 41610
#define IDS_AX_IMAGE_ANNOTATION_ICON_SAD_FACE 41611
#define IDS_AX_IMAGE_ANNOTATION_ICON_MOON 41612
#define IDS_AX_IMAGE_ANNOTATION_ICON_CLOUD 41613
#define IDS_AX_IMAGE_ANNOTATION_ICON_SUN 41614

// ---------------------------------------------------------------------------
// From blink_strings.h:

#define IDS_DETAILS_WITHOUT_SUMMARY_LABEL 41630
#define IDS_FORM_CALENDAR_CLEAR 41631
#define IDS_FORM_CALENDAR_TODAY 41632
#define IDS_FORM_SUBMIT_LABEL 41633
#define IDS_FORM_INPUT_ALT 41634
#define IDS_FORM_RESET_LABEL 41635
#define IDS_FORM_FILE_BUTTON_LABEL 41636
#define IDS_FORM_MULTIPLE_FILES_BUTTON_LABEL 41637
#define IDS_FORM_FILE_NO_FILE_LABEL 41638
#define IDS_FORM_FILE_MULTIPLE_UPLOAD 41639
#define IDS_FORM_OTHER_COLOR_LABEL 41640
#define IDS_FORM_OTHER_DATE_LABEL 41641
#define IDS_FORM_OTHER_MONTH_LABEL 41642
#define IDS_FORM_OTHER_WEEK_LABEL 41643
#define IDS_FORM_PLACEHOLDER_FOR_DAY_OF_MONTH_FIELD 41644
#define IDS_FORM_PLACEHOLDER_FOR_MONTH_FIELD 41645
#define IDS_FORM_PLACEHOLDER_FOR_YEAR_FIELD 41646
#define IDS_FORM_SELECT_MENU_LIST_TEXT 41647
#define IDS_FORM_THIS_MONTH_LABEL 41648
#define IDS_FORM_THIS_WEEK_LABEL 41649
#define IDS_FORM_WEEK_NUMBER_LABEL 41650
#define IDS_AX_CALENDAR_SHOW_DATE_PICKER 41651
#define IDS_AX_CALENDAR_SHOW_DATE_TIME_LOCAL_PICKER 41652
#define IDS_AX_CALENDAR_SHOW_MONTH_PICKER 41653
#define IDS_AX_CALENDAR_SHOW_TIME_PICKER 41654
#define IDS_AX_CALENDAR_SHOW_WEEK_PICKER 41655
#define IDS_AX_CALENDAR_SHOW_MONTH_SELECTOR 41656
#define IDS_AX_CALENDAR_SHOW_NEXT_MONTH 41657
#define IDS_AX_CALENDAR_SHOW_PREVIOUS_MONTH 41658
#define IDS_AX_CALENDAR_WEEK_DESCRIPTION 41659
#define IDS_AX_COLOR_EDIT_BLUE 41660
#define IDS_AX_COLOR_EDIT_GREEN 41661
#define IDS_AX_COLOR_EDIT_HEXADECIMAL 41662
#define IDS_AX_COLOR_EDIT_HUE 41663
#define IDS_AX_COLOR_EDIT_LIGHTNESS 41664
#define IDS_AX_COLOR_EDIT_RED 41665
#define IDS_AX_COLOR_EDIT_SATURATION 41666
#define IDS_AX_COLOR_EYEDROPPER 41667
#define IDS_AX_COLOR_FORMAT_TOGGLER 41668
#define IDS_AX_COLOR_HUE_SLIDER 41669
#define IDS_AX_COLOR_WELL 41670
#define IDS_AX_COLOR_WELL_ROLEDESCRIPTION 41671
#define IDS_SYSTEM_COLOR_CHOOSER 41672
#define IDS_AX_AM_PM_FIELD_TEXT 41692
#define IDS_AX_DAY_OF_MONTH_FIELD_TEXT 41693
#define IDS_AX_HOUR_FIELD_TEXT 41694
#define IDS_AX_MEDIA_DEFAULT 41695
#define IDS_AX_MEDIA_AUDIO_ELEMENT 41696
#define IDS_AX_MEDIA_VIDEO_ELEMENT 41697
#define IDS_AX_MEDIA_MUTE_BUTTON 41698
#define IDS_AX_MEDIA_UNMUTE_BUTTON 41699
#define IDS_AX_MEDIA_PLAY_BUTTON 41700
#define IDS_AX_MEDIA_PAUSE_BUTTON 41701
#define IDS_AX_MEDIA_CURRENT_TIME_DISPLAY 41702
#define IDS_AX_MEDIA_TIME_REMAINING_DISPLAY 41703
#define IDS_AX_MEDIA_ENTER_FULL_SCREEN_BUTTON 41704
#define IDS_AX_MEDIA_EXIT_FULL_SCREEN_BUTTON 41705
#define IDS_AX_MEDIA_DISPLAY_CUT_OUT_FULL_SCREEN_BUTTON 41706
#define IDS_AX_MEDIA_ENTER_PICTURE_IN_PICTURE_BUTTON 41707
#define IDS_AX_MEDIA_EXIT_PICTURE_IN_PICTURE_BUTTON 41708
#define IDS_AX_MEDIA_LOADING_PANEL 41709
#define IDS_AX_MEDIA_SHOW_CLOSED_CAPTIONS_MENU_BUTTON 41710
#define IDS_AX_MEDIA_SHOW_PLAYBACK_SPEED_MENU_BUTTON 41711
#define IDS_AX_MEDIA_BACK_TO_OPTIONS_BUTTON 41712
#define IDS_AX_MEDIA_CAST_OFF_BUTTON 41713
#define IDS_AX_MEDIA_CAST_ON_BUTTON 41714
#define IDS_AX_MEDIA_DOWNLOAD_BUTTON 41715
#define IDS_AX_MEDIA_OVERFLOW_BUTTON 41716
#define IDS_AX_MEDIA_AUDIO_ELEMENT_HELP 41717
#define IDS_AX_MEDIA_VIDEO_ELEMENT_HELP 41718
#define IDS_AX_MEDIA_AUDIO_SLIDER_HELP 41719
#define IDS_AX_MEDIA_VIDEO_SLIDER_HELP 41720
#define IDS_AX_MEDIA_VOLUME_SLIDER_HELP 41721
#define IDS_AX_MEDIA_CURRENT_TIME_DISPLAY_HELP 41722
#define IDS_AX_MEDIA_TIME_REMAINING_DISPLAY_HELP 41723
#define IDS_AX_MEDIA_OVERFLOW_BUTTON_HELP 41724
#define IDS_AX_MILLISECOND_FIELD_TEXT 41725
#define IDS_AX_MINUTE_FIELD_TEXT 41726
#define IDS_AX_MONTH_FIELD_TEXT 41727
#define IDS_AX_SECOND_FIELD_TEXT 41728
#define IDS_AX_WEEK_OF_YEAR_FIELD_TEXT 41729
#define IDS_AX_YEAR_FIELD_TEXT 41730
#define IDS_AX_OBJECT_SELECTED 41731
#define IDS_AX_OBJECT_NOT_SELECTED 41732
#define IDS_VIEW_SOURCE_LINE_WRAP 41733
#define IDS_FORM_INPUT_WEEK_TEMPLATE 41734
#define IDS_FORM_VALIDATION_VALUE_MISSING_MULTIPLE_FILE 41735
#define IDS_FORM_VALIDATION_TYPE_MISMATCH 41736
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY 41737
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_DOMAIN 41738
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_LOCAL 41739
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOMAIN 41740
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOTS 41741
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_LOCAL 41742
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_NO_AT_SIGN 41743
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_MULTIPLE_EMAIL 41744
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL 41745
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL_DATETIME 41746
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW 41747
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW_DATETIME 41748
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW 41749
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW_DATETIME 41750
#define IDS_FORM_VALIDATION_REVERSED_RANGE_OUT_OF_RANGE_TIME 41751
#define IDS_FORM_VALIDATION_RANGE_INVALID_DATETIME 41752
#define IDS_FORM_VALIDATION_BAD_INPUT_DATETIME 41753
#define IDS_FORM_VALIDATION_BAD_INPUT_NUMBER 41754
#define IDS_PRETTY_PRINT_JSON 41755
#define IDS_FORM_VALIDATION_VALUE_MISSING 41756
#define IDS_FORM_VALIDATION_VALUE_MISSING_CHECKBOX 41757
#define IDS_FORM_VALIDATION_VALUE_MISSING_FILE 41758
#define IDS_FORM_VALIDATION_VALUE_MISSING_RADIO 41759
#define IDS_FORM_VALIDATION_VALUE_MISSING_SELECT 41760
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL 41761
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_URL 41762
#define IDS_FORM_VALIDATION_PATTERN_MISMATCH 41763
#define IDS_FORM_VALIDATION_STEP_MISMATCH 41764
#define IDS_FORM_VALIDATION_STEP_MISMATCH_CLOSE_TO_LIMIT 41765
#define IDS_FORM_VALIDATION_TOO_LONG 41766
#define IDS_FORM_VALIDATION_TOO_SHORT 41767
#define IDS_FORM_VALIDATION_TOO_SHORT_PLURAL 41768
#define IDS_MEDIA_SESSION_FILE_SOURCE 41769
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS 41770
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS_SUBMENU_TITLE 41771
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED 41772
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_SUBMENU_TITLE 41773
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_25X_TITLE 41774
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_5X_TITLE 41775
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_75X_TITLE 41776
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_NORMAL_TITLE 41777
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_25X_TITLE 41778
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_5X_TITLE 41779
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_75X_TITLE 41780
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_2X_TITLE 41781
#define IDS_MEDIA_OVERFLOW_MENU_CAST 41782
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_FULLSCREEN 41783
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_FULLSCREEN 41784
#define IDS_MEDIA_OVERFLOW_MENU_MUTE 41785
#define IDS_MEDIA_OVERFLOW_MENU_UNMUTE 41786
#define IDS_MEDIA_OVERFLOW_MENU_PLAY 41787
#define IDS_MEDIA_OVERFLOW_MENU_PAUSE 41788
#define IDS_MEDIA_OVERFLOW_MENU_DOWNLOAD 41789
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_PICTURE_IN_PICTURE 41790
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_PICTURE_IN_PICTURE 41791
#define IDS_MEDIA_PICTURE_IN_PICTURE_INTERSTITIAL_TEXT 41792
#define IDS_MEDIA_REMOTING_CAST_TEXT 41793
#define IDS_MEDIA_REMOTING_CAST_TO_UNKNOWN_DEVICE_TEXT 41794
#define IDS_MEDIA_REMOTING_STOP_TEXT 41795
#define IDS_MEDIA_REMOTING_STOP_BY_PLAYBACK_QUALITY_TEXT 41796
#define IDS_MEDIA_REMOTING_STOP_BY_ERROR_TEXT 41797
#define IDS_MEDIA_SCRUBBING_MESSAGE_TEXT 41798
#define IDS_MEDIA_TRACKS_NO_LABEL 41799
#define IDS_MEDIA_TRACKS_OFF 41800
#define IDS_PLUGIN_INITIALIZATION_ERROR 41801
#define IDS_MEDIA_PLAYBACK_ERROR 41802
#define IDS_UNITS_KIBIBYTES 41803
#define IDS_UNITS_MEBIBYTES 41804
#define IDS_UNITS_GIBIBYTES 41805
#define IDS_UNITS_TEBIBYTES 41806
#define IDS_UNITS_PEBIBYTES 41807
#define CONTENT_INVALID_TRUE 41808
#define CONTENT_INVALID_SPELLING 41809
#define CONTENT_INVALID_GRAMMAR 41810

// ---------------------------------------------------------------------------
// From cef_strings.h:

#define IDS_TEXT_FILES 64000
#define IDS_CONTENT_CONTEXT_NO_SPELLING_SUGGESTIONS 64001

// ---------------------------------------------------------------------------
// From chromium_strings.h:

#define IDS_RELAUNCH_CONFIRMATION_DIALOG_TITLE 800
#define IDS_SETTINGS_ABOUT_PROGRAM 801
#define IDS_SETTINGS_GET_HELP_USING_CHROME 802
#define IDS_SETTINGS_UPGRADE_UPDATING 803
#define IDS_SETTINGS_UPGRADE_UPDATING_PERCENT 804
#define IDS_SETTINGS_UPGRADE_SUCCESSFUL_RELAUNCH 805
#define IDS_SETTINGS_UPGRADE_UP_TO_DATE 806
#define IDS_SETTINGS_GOOGLE_PAYMENTS_CACHED 810
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_OFFLINE 811
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_SIGNED_OUT 812
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_NO_PASSWORDS 813
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT_GOOGLE_ACCOUNT 814
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT 815
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_GENERIC 816
#define IDS_SETTINGS_NO_COMPROMISED_CREDENTIALS_LABEL 817
#define IDS_SETTINGS_SIGNED_OUT_USER_LABEL 818
#define IDS_SETTINGS_SIGNED_OUT_USER_HAS_COMPROMISED_CREDENTIALS_LABEL 819
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION_GENERATION 820
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_DESCRIPTION 821
#define IDS_SETTINGS_DEFAULT_BROWSER_DEFAULT 822
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT 823
#define IDS_SETTINGS_DEFAULT_BROWSER_ERROR 824
#define IDS_SETTINGS_DEFAULT_BROWSER_SECONDARY 825
#define IDS_SETTINGS_SPELLING_PREF_DESC 826
#define IDS_SETTINGS_RESTART_TO_APPLY_CHANGES 827
#define IDS_SETTINGS_SIGNIN_ALLOWED 828
#define IDS_SETTINGS_SIGNIN_ALLOWED_DESC 829
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_BLOCKED 830
#define IDS_SETTINGS_COOKIES_CLEAR_ON_EXIT_DESC 831
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_SUBLABEL 832
#define IDS_SETTINGS_SITE_DATA_PAGE_DELETE_ON_EXIT_EXCEPTIONS_SUB_HEADING 833
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_BODY 834
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION2 835
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_PRIVACY_DESCRIPTION1 836
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL 837
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_SUB_LABEL 838
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION3 839
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION2 840
#define IDS_SETTINGS_PRIVACY_SEARCH_SUGGESTIONS_PRIVACY_DESCRIPTION2 841
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_TITLE 842
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_TYPES 843
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_USAGE 844
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_MANAGEMENT 845
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_TYPES 846
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_USAGE 847
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION 848
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_TRIALS_OFF 849
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_LISTS_EMPTY 850
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_TITLE 851
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_1 852
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_2 853
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_3 854
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_1 855
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION 856
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION_TRIALS_OFF 857
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_BEFORE 858
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_FAILED_OFFLINE 859
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_FAILED 860
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_UNKNOWN 861
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_SIGNED_OUT 862
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED 863
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_TWO 864
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_TWO 865
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_SINGULAR 866
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_PLURAL 867
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITHOUT_COUNTS 868
#define IDS_SETTINGS_CUSTOMIZE_YOUR_CHROME_PROFILE 869
#define IDS_SETTING_NAME_YOUR_PROFILE 870
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT_SECONDARY_WITH_ACCOUNT 871
#define IDS_SETTINGS_SYNC_DATA_ENCRYPTED_TEXT 873
#define IDS_SETTINGS_SYNC_DISCONNECT_TITLE 874
#define IDS_SETTINGS_SUGGEST_PREF_DESC 875
#define IDS_SETTINGS_DRIVE_SUGGEST_PREF_DESC 876
#define IDS_SETTINGS_SYNC_SIGN_IN_PROMPT_WITH_NO_ACCOUNT 877
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_SETTING_DESCRIPTION 878
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING_DESCRIPTION 879
#define IDS_SETTINGS_LANGUAGES_IS_DISPLAYED_IN_THIS_LANGUAGE 880
#define IDS_SETTINGS_LANGUAGES_DISPLAY_IN_THIS_LANGUAGE 881
#define IDS_SETTINGS_SYSTEM_BACKGROUND_APPS_LABEL 882
#define IDS_SETTINGS_RESET_PROFILE_FEEDBACK 883
#define IDS_SETTINGS_CHROME_CERTIFICATES 884
#define IDS_SETTINGS_CHROME_CERTIFICATES_DESCRIPTION 885
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_NOTHING_TO_DO 886
#define IDS_PRODUCT_NAME 101
#define IDS_SHORT_PRODUCT_NAME 103
#define IDS_SXS_SHORTCUT_NAME 887
#define IDS_SHORTCUT_NAME_BETA 888
#define IDS_SHORTCUT_NAME_DEV 889
#define IDS_PRODUCT_DESCRIPTION 890
#define IDS_WELCOME_TO_CHROME 891
#define IDS_PRODUCT_LOGO_ENTERPRISE_ALT_TEXT 896
#define IDS_SHORTCUT_NEW_WINDOW 897
#define IDS_TASK_MANAGER_TITLE 898
#define IDS_SESSION_CRASHED_VIEW_UMA_OPTIN 899
#define IDS_BROWSER_WINDOW_TITLE_FORMAT 475
#define IDS_CAPTIVE_PORTAL_BROWSER_WINDOW_TITLE_FORMAT 900
#define IDS_ACCESSIBLE_BROWSER_WINDOW_TITLE_FORMAT 694
#define IDS_ACCESSIBLE_BETA_BROWSER_WINDOW_TITLE_FORMAT 901
#define IDS_ACCESSIBLE_DEV_BROWSER_WINDOW_TITLE_FORMAT 902
#define IDS_ACCESSIBLE_CANARY_BROWSER_WINDOW_TITLE_FORMAT 903
#define IDS_ABOUT_VERSION_COMPANY_NAME 904
#define IDS_ABOUT_VERSION_COPYRIGHT 905
#define IDS_ABOUT_TERMS_OF_SERVICE 909
#define IDS_WIN_XP_VISTA_OBSOLETE 912
#define IDS_WIN_7_OBSOLETE 913
#define IDS_WIN_8_OBSOLETE 914
#define IDS_WIN_8_1_OBSOLETE 915
#define IDS_ACCNAME_APP 437
#define IDS_BROWSER_HUNGBROWSER_MESSAGE 917
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES 918
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES_ORIGIN 919
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_NOT_FOUND 920
#define IDS_UNINSTALL_CLOSE_APP 921
#define IDS_UNINSTALL_VERIFY 922
#define IDS_UNINSTALL_CHROME 923
#define IDS_FR_CUSTOMIZE_DEFAULT_BROWSER 924
#define IDS_STATUS_TRAY_KEEP_CHROME_RUNNING_IN_BACKGROUND 925
#define IDS_CANT_WRITE_USER_DIRECTORY_SUMMARY 926
#define IDS_PROFILE_TOO_NEW_ERROR 928
#define IDS_PREFERENCES_UNREADABLE_ERROR 929
#define IDS_PREFERENCES_CORRUPT_ERROR 930
#define IDS_CRASH_RECOVERY_TITLE 383
#define IDS_CRASH_RECOVERY_CONTENT 384
#define IDS_PASSWORD_GENERATION_PROMPT 932
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_C 933
#define IDS_PASSWORD_MANAGER_TITLE_BRAND 934
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SAVING_ON_DEVICE 935
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 936
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 937
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT 939
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT 940
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT 941
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT 942
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT 943
#define IDS_INSTALL_HIGHER_VERSION 944
#define IDS_INSTALL_FAILED 945
#define IDS_SAME_VERSION_REPAIR_FAILED 946
#define IDS_SETUP_PATCH_FAILED 947
#define IDS_INSTALL_OS_NOT_SUPPORTED 948
#define IDS_INSTALL_OS_ERROR 949
#define IDS_INSTALL_SINGLETON_ACQUISITION_FAILED 950
#define IDS_INSTALL_TEMP_DIR_FAILED 951
#define IDS_INSTALL_UNCOMPRESSION_FAILED 952
#define IDS_INSTALL_INVALID_ARCHIVE 953
#define IDS_INSTALL_INSUFFICIENT_RIGHTS 954
#define IDS_INSTALL_EXISTING_VERSION_LAUNCHED 955
#define IDS_SHORTCUT_TOOLTIP 956
#define IDS_UNINSTALL_DELETE_PROFILE 957
#define IDS_UNINSTALL_SET_DEFAULT_BROWSER 958
#define IDS_UNINSTALL_BUTTON_TEXT 959
#define IDS_DEFAULT_BROWSER_INFOBAR_TEXT 960
#define IDS_TRY_TOAST_HEADING 961
#define IDS_TRY_TOAST_HEADING2 962
#define IDS_TRY_TOAST_HEADING3 963
#define IDS_TRY_TOAST_HEADING4 964
#define IDS_TRY_TOAST_HEADING_SKYPE 965
#define IDS_DOWNLOAD_BUBBLE_DANGEROUS_FILE 966
#define IDS_DOWNLOAD_BUBBLE_MALICIOUS_URL_BLOCKED 967
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNKNOWN_SOURCE 968
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_MALWARE 969
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT 970
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_BLOCKED_LEARN_MORE_LINK 971
#define IDS_DOWNLOAD_STATUS_CRX_INSTALL_RUNNING 972
#define IDS_PROMPT_DOWNLOAD_CHANGES_SETTINGS 973
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_URL 974
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_CONTENT 975
#define IDS_BLOCK_REASON_DANGEROUS_DOWNLOAD 976
#define IDS_BLOCK_REASON_UNWANTED_DOWNLOAD 977
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING 978
#define IDS_ABANDON_DOWNLOAD_DIALOG_BROWSER_MESSAGE 979
#define IDS_MISSING_GOOGLE_API_KEYS 981
#define IDS_EXTENSION_INSTALLED_HEADING 982
#define IDS_EXTENSION_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX 983
#define IDS_EXTENSION_ALERT_ITEM_BLOCKLISTED_MALWARE 984
#define IDS_EXTENSIONS_ALERT_ITEM_BLOCKLISTED_MALWARE_TITLE 985
#define IDS_SAFETY_CHECK_EXTENSIONS_MALWARE 986
#define IDS_SAFETY_CHECK_EXTENSIONS_POLICY_VIOLATION 987
#define IDS_SAFETY_CHECK_EXTENSIONS_UNPUBLISHED 988
#define IDS_EXTENSIONS_SAFETY_CHECK_PRIMARY_LABEL 989
#define IDS_EXTENSIONS_ITEM_SHOW_ACCESS_REQUESTS_IN_TOOLBAR 990
#define IDS_EXTENSIONS_INCOGNITO_WARNING 991
#define IDS_EXTENSIONS_UNINSTALL 992
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_IN_CHROME 993
#define IDS_EXTENSIONS_MULTIPLE_UNSUPPORTED_DISABLED_BODY 994
#define IDS_EXTENSIONS_SINGLE_UNSUPPORTED_DISABLED_BODY 995
#define IDS_APPMENU_TOOLTIP 438
#define IDS_APPMENU_TOOLTIP_UPDATE_AVAILABLE 996
#define IDS_APPMENU_TOOLTIP_ALERT 997
#define IDS_OPEN_IN_CHROME 998
#define IDS_ABOUT 999
#define IDS_RELAUNCH_TO_UPDATE 1000
#define IDS_RELAUNCH_TO_UPDATE_ALT 1001
#define IDS_VIEW_PASSWORDS 1005
#define IDS_CHROME_SIGNIN_TITLE 1006
#define IDS_PROFILES_DICE_SYNC_PROMO 1007
#define IDS_SYNC_WRONG_EMAIL 1008
#define IDS_SYNC_USED_PROFILE_ERROR 1009
#define IDS_ENTERPRISE_SIGNIN_TITLE 1010
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITHOUT_PROFILE_CREATION 1011
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITH_PROFILE_CREATION 1012
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_TITLE 1013
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_CREATION 1014
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_ISOLATION_NOTICE 1015
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_EXPLANATION 1016
#define IDS_ONE_CLICK_SIGNIN_DIALOG_TITLE_NEW 1017
#define IDS_ONE_CLICK_SIGNIN_DIALOG_MESSAGE_NEW 1018
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_UNKNOWN_BROWSER 1019
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_KNOWN_BROWSER 1020
#define IDS_NTP_CUSTOMIZE_BUTTON_LABEL 508
#define IDS_SIGNIN_EMAIL_CONFIRMATION_TITLE 1021
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE 1022
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_TITLE 1023
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC 1024
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC 1025
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC_MANAGED_DEVICE 1026
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_DEVICE 1027
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC_V2 1028
#define IDS_PROFILE_CUSTOMIZATION_TEXT 1029
#define IDS_PROFILE_CUSTOMIZATION_TITLE_V2 1030
#define IDS_CHROME_CLEANUP_PROMPT_EXPLANATION 1031
#define IDS_APP_SHORTCUTS_SUBDIR_NAME 1037
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_CANARY 1038
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_BETA 1039
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_DEV 1040
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_AND_VIDEO 1042
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_ONLY 1043
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_VIDEO_ONLY 1044
#define IDS_WEBHID_SYSTEM_TRAY_ICON_TITLE 1045
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_TITLE 1046
#define IDS_LOGIN_POD_USER_REMOVE_WARNING_SYNC 1049
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TITLE 1050
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TEXT 1051
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TITLE 1052
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TEXT 1053
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_GUEST_TEXT 1054
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_FRIENDS_TEXT 1055
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_TEXT 1056
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_ADD_USER 1057
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_APP_MENU 1058
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORD_MANAGER 1059
#define IDS_TUTORIAL_PASSWORD_MANAGER_SUCCESS_BODY 1060
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_BODY 1061
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_START_PAGES_SPECIFIC 1062
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_START_PAGES 1063
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_PAGES 1064
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_HOME 1065
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_SEARCH 1066
#define IDS_WEBSTORE_APP_DESCRIPTION 377
#define IDS_INBOUND_MDNS_RULE_NAME 1067
#define IDS_INBOUND_MDNS_RULE_NAME_BETA 1068
#define IDS_INBOUND_MDNS_RULE_NAME_CANARY 1069
#define IDS_INBOUND_MDNS_RULE_NAME_DEV 1070
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION 1071
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_BETA 1072
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_CANARY 1073
#define IDS_INBOUND_MDNS_RULE_DESCRIPTION_DEV 1074
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT 1075
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT_ONCE 1076
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TEXT 1077
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB_INAPP 1078
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD_INAPP 1079
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE 1080
#define IDS_UPDATE_RECOMMENDED 1081
#define IDS_RELAUNCH_AND_UPDATE 1082
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE_ALT 1083
#define IDS_UPDATE_RECOMMENDED_ALT 1084
#define IDS_REINSTALL_APP 1085
#define IDS_UPGRADE_BUBBLE_MENU_ITEM 1086
#define IDS_UPGRADE_BUBBLE_TITLE 1087
#define IDS_UPGRADE_BUBBLE_TEXT 1088
#define IDS_SYNC_ERROR_USER_MENU_UPGRADE_BUTTON 1089
#define IDS_SYNC_UPGRADE_CLIENT 1090
#define IDS_SYNC_UPGRADE_CLIENT_BUTTON 1091
#define IDS_RECOVERY_BUBBLE_TITLE 1092
#define IDS_RUN_RECOVERY 1093
#define IDS_RECOVERY_BUBBLE_TEXT 1094
#define IDS_CRITICAL_NOTIFICATION_TITLE 1095
#define IDS_CRITICAL_NOTIFICATION_TITLE_ALTERNATE 1096
#define IDS_CRITICAL_NOTIFICATION_TEXT 1097
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_TAB 1098
#define IDS_WELCOME_HEADER 1114
#define IDS_WIN_NOTIFICATION_SETTINGS_CONTEXT_MENU_ITEM_NAME 1115
#define IDS_RELAUNCH_RECOMMENDED_TITLE 1116
#define IDS_RELAUNCH_RECOMMENDED_BODY 1117
#define IDS_RELAUNCH_REQUIRED_TITLE_DAYS 1118
#define IDS_RELAUNCH_REQUIRED_TITLE_HOURS 1119
#define IDS_RELAUNCH_REQUIRED_TITLE_MINUTES 1120
#define IDS_RELAUNCH_REQUIRED_TITLE_SECONDS 1121
#define IDS_RELAUNCH_REQUIRED_BODY 1122
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_TOOLTIP 1123
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_ERROR 1124
#define IDS_ENTERPRISE_STARTUP_RELAUNCH_BUTTON 1125
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WEB_CONTENTS_ONLY 1126
#define IDS_IDLE_BUBBLE_TITLE_CLOSE 1127
#define IDS_IDLE_BUBBLE_BODY_CLOSE_AND_CLEAR 1128
#define IDS_IDLE_BUBBLE_BODY_CLEAR 1129
#define IDS_IDLE_BUBBLE_BODY_CLOSE 1130
#define IDS_IDLE_TIMEOUT_CLOSE_TITLE 1131
#define IDS_IDLE_TIMEOUT_CLEAR_TITLE 1132
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_TITLE 1133
#define IDS_IDLE_TIMEOUT_CLOSE_BODY 1134
#define IDS_IDLE_TIMEOUT_CLEAR_BODY 1135
#define IDS_IDLE_TIMEOUT_CLOSE_AND_CLEAR_BODY 1136
#define IDS_IDLE_DISMISS_BUTTON 1137
#define IDS_HATS_BUBBLE_TITLE 1138
#define IDS_EXTENSION_PERMISSIONS_BLOCKED_BY_PARENT_PROMPT_MESSAGE 1139
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE 1144
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_V2 1145
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE 1146
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE 1147
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_TITLE 1148
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TEXT 1149
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TEXT 1150
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_TITLE 1151
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SUBTITLE 1152
#define IDS_FRE_SIGN_IN_TITLE_0 1157
#define IDS_FRE_SIGN_IN_TITLE_1 1158
#define IDS_FRE_SIGN_IN_TITLE_2 1159
#define IDS_FRE_DEFAULT_BROWSER_TITLE 1160
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE_NEW 1161
#define IDS_FRE_DEFAULT_BROWSER_ILLUSTRATION_ALT_TEXT 1162
#define IDS_PROFILE_SWITCH_PROMO 1163
#define IDS_PROFILE_SWITCH_PROMO_SCREENREADER 1164
#define IDS_PASSWORD_MANAGER_IPH_BODY_WEB_APP_PROFILE_SWITCH 1165
#define IDS_CHROMELABS_RELAUNCH_FOOTER_MESSAGE 1167
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 1168
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_TITLE 1169
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_TITLE 1170
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION 1171
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION_UPDATED 1172
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_ACCEPT 1173
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_SUBTITLE 1174
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_DESCRIPTION_2 1175
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_LABEL 1176
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_HEADER 1177
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_1 1178
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_2 1179
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_3 1180
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_1 1181
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_2 1182
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BOTTOM_SUMMARY 1183
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_SUBTITLE 1184
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_DESCRIPTION_2 1185
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BOTTOM_SUMMARY 1186
#define IDS_FRIENDLY_COMPANY_NAME 1187
#define IDS_NO_UPDATE_RESPONSE 1188
#define IDS_INSTALL_UPDATER_FAILED 1189
#define IDS_INSTALLER_DISPLAY_NAME 1190
#define IDS_CLOSE_BUTTON 1191
#define IDS_MINIMIZE_BUTTON 1192
#define IDS_INITIALIZING 1193
#define IDS_WAITING_TO_CONNECT 1194
#define IDS_DOWNLOADING_SHORT 1195
#define IDS_DOWNLOADING_LONG 1196
#define IDS_DOWNLOADING_VERY_LONG 1197
#define IDS_DOWNLOADING_COMPLETED 1198
#define IDS_DOWNLOADING 1199
#define IDS_WAITING_TO_INSTALL 1200
#define IDS_INSTALLING 1201
#define IDS_CANCELING 1202
#define IDS_TEXT_RESTART_BROWSER 1203
#define IDS_TEXT_RESTART_ALL_BROWSERS 1204
#define IDS_TEXT_RESTART_COMPUTER 1205
#define IDS_UPDATER_CLOSE 1206
#define IDS_RESTART_NOW 1207
#define IDS_RESTART_LATER 1208
#define IDS_GET_HELP_TEXT 1209
#define IDS_INSTALLATION_STOPPED_WINDOW_TITLE 1210
#define IDS_INSTALL_STOPPED 1211
#define IDS_RESUME_INSTALLATION 1212
#define IDS_CANCEL_INSTALLATION 1213
#define IDS_SPLASH_SCREEN_MESSAGE 1214
#define IDS_BUNDLE_INSTALLED_SUCCESSFULLY 1215
#define IDS_HIGH_EFFICIENCY_DIALOG_TITLE 1216
#define IDS_HIGH_EFFICIENCY_DIALOG_BODY_V2 1217
#define IDS_HIGH_EFFICIENCY_MODE_PROMO_TITLE 390

// ---------------------------------------------------------------------------
// From components_chromium_strings.h:

#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_BODY 32050
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_HEADER 32051
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_CLIENT 32052
#define IDS_ERRORPAGES_SUGGESTION_PROXY_DISABLE_PLATFORM 32053
#define IDS_PAYMENTS_AUTOFILL_MANDATORY_REAUTH_PROMPT 32054
#define IDS_PAYMENTS_AUTOFILL_EDIT_CARD_MANDATORY_REAUTH_PROMPT 32055
#define IDS_FLAGS_UI_RELAUNCH_NOTICE 32056
#define IDS_DEPRECATED_FEATURES_RELAUNCH_NOTICE 32057
#define IDS_CRASH_DISABLED_MESSAGE 32058
#define IDS_SHORT_PRODUCT_LOGO_ALT_TEXT 32059
#define IDS_VERSION_UI_LICENSE 32060
#define IDS_PAGE_INFO_INTERNAL_PAGE 32063
#define IDS_SESSION_CRASHED_VIEW_MESSAGE 32064

// ---------------------------------------------------------------------------
// From components_strings.h:

#define IDS_ASH_ARC_APP_COMPAT_DISABLED_COMPAT_MODE_BUTTON_TOOLTIP_PHONE 32090
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_TITLE 32091
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_BODY 32092
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_ACCEPT 32093
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_DONT_ASK_ME 32094
#define IDS_ASH_ARC_NEARBY_SHARE_FILE_PREPARATION_PROGRESS 32095
#define IDS_ASH_ARC_NEARBY_SHARE_FILES_PREPARATION_PROGRESS 32096
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE 32097
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_TITLE 32098
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE 32099
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_STORAGE_BUTTON 32100
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_PHONE 32101
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TABLET 32102
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZABLE 32103
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZE_SETTINGS 32104
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TITLE 32105
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_TITLE 32106
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY 32107
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY_UNRESIZABLE 32108
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_CLOSE 32109
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_LINK 32110
#define IDS_ARC_COMPAT_MODE_DISABLE_RESIZE_LOCK_TOAST 32111
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_ICON 32112
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_THROBBER 32113
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_MESSAGE 32114
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_AOD_MESSAGE 32115
#define IDS_ARC_GHOST_WINDOW_APP_FIXUP_MESSAGE 32116
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_TITLE 32117
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY 32118
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_BODY_WITH_LEARN_MORE 32119
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_SUBSCRIPTION_BODY_WITH_LEARN_MORE 32120
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_LEARN_MORE_LABEL 32121
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_ALLOW_BUTTON 32122
#define IDS_ASH_ARC_PASSPOINT_APP_APPROVAL_DONT_ALLOW_BUTTON 32123
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_TITLE 32124
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_DAYS_UNTIL_DEADLINE 32125
#define IDS_ARC_VM_DATA_MIGRATION_NOTIFICATION_ACCEPT_BUTTON_LABEL 32126
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_TITLE 32127
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SAVE_WORK_MESSAGE 32128
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_DAYS_UNTIL_DEADLINE 32129
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_NOW_BUTTON_LABEL 32130
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_SKIP_BUTTON_LABEL 32131
#define IDS_ARC_VM_DATA_MIGRATION_DIALOG_UPDATE_BUTTON_LABEL 32132
#define IDS_ARC_VM_DATA_MIGRATION_LOADING_SCREEN_MESSAGE 32133
#define IDS_ARC_VM_DATA_MIGRATION_WELCOME_SCREEN_TITLE 32134
#define IDS_ARC_VM_DATA_MIGRATION_WHAT_TO_EXPECT_TITLE 32135
#define IDS_ARC_VM_DATA_MIGRATION_UPDATE_DESCRIPTION 32136
#define IDS_ARC_VM_DATA_MIGRATION_BLOCKING_BEHAVIOR_DESCRIPTION 32137
#define IDS_ARC_VM_DATA_MIGRATION_CONNECT_TO_CHARGER_MESSAGE 32138
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_FREE_DISK_SPACE_MESSAGE 32139
#define IDS_ARC_VM_DATA_MIGRATION_NOT_ENOUGH_BATTERY_MESSAGE 32140
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_UPDATE_BUTTON_LABEL 32141
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_SKIP_BUTTON_LABEL 32142
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_SCREEN_TITLE 32143
#define IDS_ARC_VM_DATA_MIGRATION_RESUME_DESCRIPTION 32144
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_RESUME_BUTTON_LABEL 32145
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_SCREEN_TITLE 32146
#define IDS_ARC_VM_DATA_MIGRATION_PROGRESS_DESCRIPTION 32147
#define IDS_ARC_VM_DATA_MIGRATION_SUCCESS_SCREEN_TITLE 32148
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_FINISH_BUTTON_LABEL 32149
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_SCREEN_TITLE 32150
#define IDS_ARC_VM_DATA_MIGRATION_FAILURE_DESCRIPTION 32151
#define IDS_ARC_VM_DATA_MIGRATION_SEND_FEEDBACK_MESSAGE 32152
#define IDS_ARC_VM_DATA_MIGRATION_SCREEN_REPORT_BUTTON_LABEL 32153
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_LOCAL_SAVE 32154
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_UPLOAD_SAVE 32155
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_LOCAL_SAVE_NO_THANKS 32156
#define IDS_AUTOFILL_FIELD_LABEL_PHONE 32163
#define IDS_AUTOFILL_FIELD_LABEL_BILLING_ADDRESS 32164
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_LOCAL_SAVE_ACCEPT 32166
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_UPLOAD_SAVE_ACCEPT 32167
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CONTINUE 32169
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_LOCAL 32170
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_TITLE_LOCAL 32171
#define IDS_AUTOFILL_SAVE_CVC_PROMPT_EXPLANATION_LOCAL 32172
#define IDS_AUTOFILL_FIX_FLOW_PROMPT_SAVE_CARD_LABEL 32173
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD 32174
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_EXPERIMENT_ENCRYPTED_AND_SECURE 32175
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_EXPERIMENT_FASTER_AND_PROTECTED 32176
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V3 32177
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V4 32178
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V5 32179
#define IDS_AUTOFILL_CARD_SAVED 32180
#define IDS_AUTOFILL_CVC_SAVED 32181
#define IDS_AUTOFILL_DONE 32182
#define IDS_AUTOFILL_FAILURE_BUBBLE_TITLE 32183
#define IDS_AUTOFILL_FAILURE_BUBBLE_EXPLANATION 32184
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION 32185
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3 32186
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_EXPERIMENT_ENCRYPTED_AND_SECURE 32187
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_EXPERIMENT_FASTER_AND_PROTECTED 32188
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3_WITH_NAME 32189
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V4 32190
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME 32191
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME_TOOLTIP 32192
#define IDS_AUTOFILL_SAVE_CARD_CARDHOLDER_NAME_FIX_FLOW_HEADER 32193
#define IDS_AUTOFILL_SAVE_CARD_UPDATE_EXPIRATION_DATE_TITLE 32194
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_TOOLTIP 32197
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_AND_CARDHOLDER_NAME_TOOLTIP 32198
#define IDS_AUTOFILL_GOOGLE_PAY_LOGO_ACCESSIBLE_NAME 32199
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_ANIMATION_LABEL 32200
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_TITLE 32201
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BUTTON_LABEL 32202
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BODY_TEXT 32203
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_OFFER 32204
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_DONE 32205
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_FIX 32206
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_CHECKBOX_UNCHECK_WARNING 32207
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_OFFER 32208
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_DONE 32209
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_ERROR 32210
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_FIX 32211
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_INVALID_CARD_REMOVED 32212
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_SAVE 32213
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_CANCEL 32214
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_DONE 32215
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_VIEW_CARDS 32216
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_LABEL_INVALID_CARDS 32217
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TRASH_CAN_BUTTON_TOOLTIP 32218
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC 32219
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC_AND_EXPIRATION_V2 32220
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_SECURITY_CODE 32221
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_PERMANENT 32222
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_NETWORK 32223
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_BACK_OF_CARD 32224
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_SECURITY_CODE_POSITION_FRONT_OF_CARD 32225
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE 32233
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE_SECURITY_CODE 32234
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_DIALOG_TITLE 32235
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_TITLE 32236
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_EXPIRED_TITLE 32237
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_DEFAULT 32238
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_EXPIRED_CARD 32239
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_VIRTUAL_CARD 32240
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_V2 32241
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION 32242
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION_FOR_AMEX 32243
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_ANNOUNCEMENT 32244
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_ANNOUNCEMENT_AMEX 32245
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRM_BUTTON 32254
#define IDS_AUTOFILL_CARD_UNMASK_VERIFY_BUTTON 32255
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_MONTH 32256
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_YEAR 32257
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_IN_PROGRESS 32258
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_SUCCESS 32259
#define IDS_AUTOFILL_CARD_UNMASK_INVALID_EXPIRATION_DATE 32260
#define IDS_AUTOFILL_EXPIRATION_DATE_SEPARATOR 32261
#define IDS_AUTOFILL_CARD_UNMASK_NEW_CARD_LINK 32262
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_CVC 32263
#define IDS_AUTOFILL_DIALOG_ACCESSIBLE_NAME_SECURITY_CODE 32264
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_BAR_MESSAGE 32265
#define IDS_AUTOFILL_CARD_UNMASK_CANCEL_BUTTON_LABEL 32266
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_MESSAGE 32267
#define IDS_AUTOFILL_FIDO_AUTHENTICATION_PROMPT_TITLE 32268
#define IDS_PAYMENTS_AUTOFILL_FILLING_MANDATORY_REAUTH 32269
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE 32270
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE_ERROR 32271
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION 32272
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_OK_BUTTON_LABEL 32273
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION_ERROR 32274
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL 32275
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL_ERROR 32276
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_TITLE 32277
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_CANCEL_BUTTON_LABEL 32278
#define IDS_AUTOFILL_WALLET_MANAGEMENT_LINK_TEXT 32279
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT_LONG 32280
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_TITLE_LOCAL 32281
#define IDS_AUTOFILL_SAVE_IBAN_LABEL 32282
#define IDS_AUTOFILL_SAVE_IBAN_BUBBLE_LOCAL_SAVE_ACCEPT 32283
#define IDS_AUTOFILL_SAVE_IBAN_PROMPT_NICKNAME 32284
#define IDS_AUTOFILL_SAVE_IBAN_PLACEHOLDER 32285
#define IDS_IBAN_NICKNAME_COUNT_BY 32286
#define IDS_AUTOFILL_IBAN_SAVED 32287
#define IDS_AUTOFILL_MANAGE_SAVED_PAYMENT_METHODS 32288
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_NO_THANKS 32289
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_ACCEPT 32290
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_TITLE 32291
#define IDS_AUTOFILL_MANDATORY_REAUTH_OPT_IN_EXPLANATION 32292
#define IDS_AUTOFILL_MANDATORY_REAUTH_ICON_TOOLTIP 465
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_TITLE 32293
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_EXPLANATION 32294
#define IDS_AUTOFILL_MANDATORY_REAUTH_CONFIRMATION_SETTINGS_LINK 32295
#define IDS_AUTOFILL_CLOUD_TOKEN_DROPDOWN_OPTION_LABEL 32299
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_FALLBACK_ICON_TOOLTIP 464
#define IDS_AUTOFILL_VIRTUAL_CARD_ENTRY_PREFIX 32300
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_CONTENT_TITLE 32301
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_CONTENT_EXPLANATION 32302
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_OK_BUTTON_LABEL 32303
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_CANCEL_BUTTON_LABEL 32304
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_TITLE 32305
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EDUCATIONAL_BODY_LABEL 32306
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_LEARN_MORE_LINK_LABEL 32307
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL 32308
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EXP_DATE_LABEL 32309
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARDHOLDER_NAME_LABEL 32310
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CVC_LABEL 32311
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_VIRTUAL_CARD_LABEL 32312
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_ICON_TOOLTIP 463
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_BUTTON_TOOLTIP_NORMAL 32313
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_BUTTON_TOOLTIP_CLICKED 32314
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL 32315
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_ACCEPT_BUTTON_LABEL 32316
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_TITLE_LABEL 32317
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_CONTENT_LABEL 32318
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_SKIP 32319
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_NO_THANKS 32320
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_LEARN_MORE_LINK_LABEL 32321
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_CARD_IMAGE_TOOLTIP 32322
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_OPTION_VALUE 32323
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_TITLE 32324
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_TITLE 32325
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_DESCRIPTION 32326
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_DESCRIPTION 32327
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_TITLE 32328
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_DESCRIPTION 32329
#define IDS_AUTOFILL_ERROR_DIALOG_NEGATIVE_BUTTON_LABEL 32330
#define IDS_AUTOFILL_VIRTUAL_CARD_NUMBER_SWITCH_LABEL 32331
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL 32335
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_IPH_BUBBLE_LABEL_SCREENREADER 32336
#define IDS_AUTOFILL_VIRTUAL_CARD_STANDALONE_CVC_SUGGESTION_TITLE 32337
#define IDS_AUTOFILL_CARD_AUTH_SELECTION_DIALOG_TITLE_MULTIPLE_OPTIONS 32338
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_ISSUER_CONFIRMATION_TEXT 32339
#define IDS_AUTOFILL_AUTHENTICATION_MODE_SECURITY_CODE 32340
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_TEXT_MESSAGE 32341
#define IDS_AUTOFILL_AUTHENTICATION_MODE_TEXT_MESSAGE 32342
#define IDS_AUTOFILL_AUTHENTICATION_MODE_GET_EMAIL 32343
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CURRENT_INFO_NOT_SEEN_TEXT 32344
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_CONTINUE 32345
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL_SEND 32346
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CVC_CHALLENGE_INFO 32347
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TITLE 32348
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_FOOTER_MESSAGE 32349
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_NEW_CODE_MESSAGE 32350
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TEXTFIELD_PLACEHOLDER_MESSAGE 32351
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_PENDING_MESSAGE 32352
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_VERIFICATION_CODE_EXPIRED_LABEL 32353
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_ENTER_CORRECT_CODE_LABEL 32354
#define IDS_AUTOFILL_SAVE_UPI_PROMPT_TITLE 32355
#define IDS_AUTOFILL_SAVE_UPI_PROMPT_ACCEPT 32356
#define IDS_AUTOFILL_SAVE_UPI_PROMPT_REJECT 32357
#define IDS_AUTOFILL_OFFERS_CASHBACK 32358
#define IDS_AUTOFILL_CARD_LINKED_OFFER_REMINDER_TITLE 32359
#define IDS_AUTOFILL_OFFERS_REMINDER_POSITIVE_BUTTON_LABEL 32360
#define IDS_AUTOFILL_PROMO_CODE_SUGGESTIONS_FOOTER_TEXT 32361
#define IDS_AUTOFILL_OFFERS_REMINDER_ICON_TOOLTIP_TEXT 459
#define IDS_AUTOFILL_OFFERS_REMINDER_DESCRIPTION_TEXT 32362
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_REMINDER_TITLE 32367
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_TITLE 32368
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_NORMAL 32369
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_CLICKED 32370
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_VALUE_PROP_TEXT 32371
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_CANT_FIND_CODE_MESSAGE 32372
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_OTP_INPUT_HINT 32373
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_POSITIVE_BUTTON_LABEL 32374
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_NEGATIVE_BUTTON_LABEL 32375
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_LABEL 32385
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_PAYMENT_METHOD_MANDATORY_REAUTH_SUBLABEL 32386
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_LABEL 32389
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_SUBLABEL 32390
#define IDS_AUTOFILL_SETTINGS_PAGE_ENABLE_CVC_STORAGE_WITH_DELETE_LINK_SUBLABEL 32391
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_TITLE 32392
#define IDS_AUTOFILL_SETTINGS_PAGE_BULK_REMOVE_CVC_DESCRIPTION 32393
#define IDS_AUTOFILL_CLEAR_FORM_MENU_ITEM 32394
#define IDS_AUTOFILL_UNDO_MENU_ITEM 32395
#define IDS_AUTOFILL_WARNING_INSECURE_CONNECTION 32397
#define IDS_AUTOFILL_WARNING_MIXED_FORM 32398
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_CONFIRMATION_BODY 32399
#define IDS_AUTOFILL_DELETE_CREDIT_CARD_SUGGESTION_CONFIRMATION_BODY 32400
#define IDS_AUTOFILL_DELETE_PROFILE_SUGGESTION_CONFIRMATION_BODY 32401
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_TOOLTIP 32402
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_A11Y_HINT 32403
#define IDS_AUTOFILL_CC_AMEX 32404
#define IDS_AUTOFILL_CC_AMEX_SHORT 32405
#define IDS_AUTOFILL_CC_DINERS 32406
#define IDS_AUTOFILL_CC_DISCOVER 32407
#define IDS_AUTOFILL_CC_ELO 32408
#define IDS_AUTOFILL_CC_GOOGLE_PAY 32409
#define IDS_AUTOFILL_CC_JCB 32410
#define IDS_AUTOFILL_CC_MASTERCARD 32411
#define IDS_AUTOFILL_CC_MIR 32412
#define IDS_AUTOFILL_CC_TROY 32413
#define IDS_AUTOFILL_CC_UNION_PAY 32414
#define IDS_AUTOFILL_CC_VISA 32415
#define IDS_AUTOFILL_CC_GENERIC 32416
#define IDS_AUTOFILL_ADDRESS_SUMMARY_SEPARATOR 32417
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILLED_FORM 32418
#define IDS_AUTOFILL_A11Y_ANNOUNCE_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 32419
#define IDS_AUTOFILL_A11Y_ANNOUNCE_CLEARED_FORM 32420
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 32421
#define IDS_AUTOFILL_FILL_ADDRESS_GROUP_POPUP_OPTION_SELECTED 32422
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 32423
#define IDS_AUTOFILL_FILL_NAME_GROUP_POPUP_OPTION_SELECTED 32424
#define IDS_AUTOFILL_A11Y_ANNOUNCE_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 32425
#define IDS_AUTOFILL_HIDE_SUGGESTIONS 32426
#define IDS_AUTOFILL_MANAGE 32427
#define IDS_AUTOFILL_DELETE_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 32428
#define IDS_AUTOFILL_FILL_EVERYTHING_FROM_ADDRESS_PROFILE_POPUP_OPTION_SELECTED 32429
#define IDS_AUTOFILL_MANAGE_ADDRESSES 32430
#define IDS_AUTOFILL_MANAGE_PAYMENT_METHODS 32431
#define IDS_AUTOFILL_MANAGE_PASSWORDS 32432
#define IDS_AUTOFILL_SCAN_CREDIT_CARD 32433
#define IDS_AUTOFILL_SHOW_ALL_SAVED_FALLBACK 32434
#define IDS_AUTOFILL_SHOW_ACCOUNT_CARDS 32435
#define IDS_AUTOFILL_POPUP_ACCESSIBLE_NODE_DATA 32436
#define IDS_AUTOFILL_IPH_EXTERNAL_ACCOUNT_PROFILE_SUGGESTION 32437
#define IDS_AUTOFILL_SUGGESTION_LABEL_SEPARATOR 32438
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR 32439
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR_V2 32440
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_NAME 32441
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_CARD_NUMBER 32442
#define IDS_AUTOFILL_LOADING_REGIONS 32443
#define IDS_AUTOFILL_SELECT 32444
#define IDS_AUTOFILL_NO_SAVED_ADDRESS 32445
#define IDS_AUTOFILL_ADDRESSES 32446
#define IDS_AUTOFILL_ADDRESSES_TABLE_ARIA_LABEL 32447
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_SUBLABEL 32448
#define IDS_AUTOFILL_LOCAL_PROFILE_ACCESSIBILITY_LABEL 32449
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_SUBLABEL 32450
#define IDS_AUTOFILL_DELETE_ACCOUNT_ADDRESS_SOURCE_NOTICE 32451
#define IDS_AUTOFILL_DELETE_SYNC_ADDRESS_SOURCE_NOTICE 32452
#define IDS_AUTOFILL_DELETE_LOCAL_ADDRESS_SOURCE_NOTICE 32453
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_SOURCE_NOTICE 32454
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_MESSAGE_ADDRESS_MIGRATION_SOURCE_NOTICE 32455
#define IDS_AUTOFILL_ADDRESS_ALREADY_SAVED_IN_ACCOUNT_SOURCE_NOTICE 32456
#define IDS_AUTOFILL_ADDRESS_WILL_BE_SAVED_IN_ACCOUNT_SOURCE_NOTICE 32457
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELD_FORM_ERROR 32458
#define IDS_AUTOFILL_EDIT_ADDRESS_REQUIRED_FIELDS_FORM_ERROR 32459
#define IDS_AUTOFILL_LOCAL_ADDRESS_ICON_A11Y_LABEL 32460
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_TITLE 32461
#define IDS_AUTOFILL_PAYMENT_METHODS 32462
#define IDS_AUTOFILL_PAYMENT_METHODS_TABLE_ARIA_LABEL 32463
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_LABEL 32464
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_LABEL 32465
#define IDS_AUTOFILL_DELETE_ADDRESS_CONFIRMATION_DIALOG_TITLE 32466
#define IDS_ENABLE_CREDIT_CARD_FIDO_AUTH_LABEL 32467
#define IDS_ENABLE_CREDIT_CARD_FIDO_AUTH_SUBLABEL 32468
#define IDS_SYNC_DATATYPE_PAYMENTS 32474
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_OK_BUTTON_LABEL 32480
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_MIGRATION_OK_BUTTON_LABEL 32481
#define IDS_AUTOFILL_ACCOUNT_MIGRATE_ADDRESS_PROMPT_TITLE 32482
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OK_BUTTON_LABEL 32483
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_OK_BUTTON_LABEL 32484
#define IDS_AUTOFILL_ADDRESS_MIGRATION_TO_ACCOUNT_PROMPT_CANCEL_BUTTON_LABEL 32485
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_NEW_VALUES_SECTION_LABEL 32486
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OLD_VALUES_SECTION_LABEL 32487
#define IDS_AUTOFILL_MIGRATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 32488
#define IDS_AUTOFILL_SAVE_IN_ACCOUNT_PROMPT_ADDRESS_SOURCE_NOTICE 32489
#define IDS_AUTOFILL_UPDATE_PROMPT_ACCOUNT_ADDRESS_SOURCE_NOTICE 32490
#define IDS_AUTOFILL_SYNCABLE_PROFILE_MIGRATION_PROMPT_NOTICE 32491
#define IDS_AUTOFILL_LOCAL_PROFILE_MIGRATION_PROMPT_NOTICE 32492
#define IDS_AUTOFILL_SAVE_PROMPT_ADDRESS_SECTION_A11Y_LABEL 32493
#define IDS_AUTOFILL_SAVE_PROMPT_PHONE_SECTION_A11Y_LABEL 32494
#define IDS_AUTOFILL_SAVE_PROMPT_EMAIL_SECTION_A11Y_LABEL 32495
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_TITLE 466
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 32513
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_EDIT_BUTTON_TOOLTIP 32499
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_TITLE 32497
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 32514
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_TITLE 32500
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 32515
#define IDS_AUTOFILL_MIGRATE_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 32516
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_UPDATE 32517
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_CANCEL_BUTTON_LABEL 32518
#define IDS_BOOKMARK_BAR_FOLDER_NAME 147
#define IDS_BOOKMARK_BAR_MOBILE_FOLDER_NAME 149
#define IDS_BOOKMARK_BAR_OTHER_FOLDER_NAME 148
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DOMAIN_NAME 32519
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DEFAULT_NAME 150
#define IDS_BOOKMARK_EDITOR_TITLE 32520
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_NAME 32521
#define IDS_BOOKMARK_BUBBLE_REMOVE_BOOKMARK 32522
#define IDS_BOOKMARK_MANAGER_NAME_INPUT_PLACE_HOLDER 32523
#define IDS_BOOKMARK_MANAGER_URL_INPUT_PLACE_HOLDER 32524
#define IDS_TOOLTIP_STAR 469
#define IDS_CLEAR_BROWSING_DATA_CALCULATING 32528
#define IDS_DEL_BROWSING_HISTORY_COUNTER 32529
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SYNCED 32530
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE 32531
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY 32532
#define IDS_DEL_CACHE_COUNTER_BASIC 32533
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE_BASIC 32534
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY_BASIC 32535
#define IDS_DEL_PASSWORDS_COUNTER 32536
#define IDS_DEL_PASSWORDS_COUNTER_SYNCED 32537
#define IDS_DEL_ACCOUNT_PASSWORDS_COUNTER 32538
#define IDS_DEL_PASSWORDS_DOMAINS_DISPLAY 32539
#define IDS_DEL_PASSWORDS_COUNTER_AND_X_MORE 32540
#define IDS_DEL_SIGNIN_DATA_COUNTER 32541
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_NONE 32542
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_COMBINATION 32543
#define IDS_DEL_SITE_SETTINGS_COUNTER 32544
#define IDS_DEL_AUTOFILL_COUNTER_EMPTY 32545
#define IDS_DEL_AUTOFILL_COUNTER_CREDIT_CARDS 32546
#define IDS_DEL_AUTOFILL_COUNTER_ADDRESSES 32547
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS 32548
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_LONG 32549
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_SHORT 32550
#define IDS_DEL_AUTOFILL_COUNTER_ONE_TYPE_SYNCED 32551
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES 32552
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES_SYNCED 32553
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES 32554
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES_SYNCED 32555
#define IDS_DEL_COOKIES_COUNTER 32556
#define IDS_DEL_COOKIES_COUNTER_ADVANCED 32557
#define IDS_DEL_COOKIES_COUNTER_ADVANCED_WITH_EXCEPTION 32558
#define IDS_DEL_DOWNLOADS_COUNTER 32559
#define IDS_DEL_HOSTED_APPS_COUNTER 32560
#define IDS_DEL_HOSTED_APPS_COUNTER_AND_X_MORE 32561
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_TITLE 32562
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_CONTENT 32563
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_NO_THANKS 32564
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_GET_DISCOUNTS 32565
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_TITLE 32566
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_CONTENT 32567
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_DONE 32568
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_ACCEPT_BUTTON 32569
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_TITLE 32570
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_BODY 32571
#define IDS_NTP_CART_DISCOUNT_STEP_ONE_CONTENT 662
#define IDS_OMNIBOX_TRACK_PRICE 444
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE 32572
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION 32573
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_EMAIL_DESCRIPTION 32574
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ACTION_BUTTON 32575
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_DESCRIPTION 32576
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_ERROR_BUTTON 32577
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_TITLE_FIRST_RUN 32578
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_DESCRIPTION_FIRST_RUN 32579
#define IDS_OMNIBOX_TRACK_PRICE_DIALOG_CANCEL_BUTTON 32580
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_BODY 32581
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_TITLE 32582
#define IDS_PRICE_TRACKING_EMAIL_CONSENT_LEARN_MORE_LINK_TEXT 32583
#define IDS_PRICE_TRACKING_NOT_NOW 32584
#define IDS_PRICE_TRACKING_YES_IM_IN 32585
#define IDS_OMNIBOX_TRACKING_PRICE 32586
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_TITLE 32587
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_DESCRIPTION 32588
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_ACTION_BUTTON 32589
#define IDS_OMNIBOX_TRACKING_PRICE_DIALOG_UNTRACK_BUTTON 32590
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_TITLE 32591
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION 32592
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_DESCRIPTION_BOOKMARK_REMOVED 32593
#define IDS_OMNIBOX_PRICE_TRACKING_OFF_DIALOG_ACTION_BUTTON 32594
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION 32595
#define IDS_BOOKMARK_STAR_DIALOG_TRACK_PRICE_DESCRIPTION_EMAIL_OFF 32596
#define IDS_BOOKMARKS_MANAGER_TRACKED_PRODUCTS 32597
#define IDS_BOOKMARKS_MANAGER_UNTRACK_BUTTON 32598
#define IDS_PRICE_TRACKING_SIDE_PANEL_IPH 32599
#define IDS_SIDE_PANEL_TRACKED_PRODUCTS 32600
#define IDS_PRICE_TRACKING_CHIP_IPH 32601
#define IDS_SIDE_PANEL_UNTRACK_BUTTON 32602
#define IDS_SIDE_PANEL_TRACK_BUTTON 32603
#define IDS_BOOKMARKS_MENU_UNTRACK_PRICE 32604
#define IDS_BOOKMARKS_MENU_TRACK_PRICE 32605
#define IDS_PRICE_TRACKING_UNTRACK_PRODUCT_ACCESSIBILITY 32606
#define IDS_PRICE_TRACKING_TRACK_PRODUCT_ACCESSIBILITY 32607
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_BUTTON 32608
#define IDS_PRICE_TRACKING_SETTINGS_TITLE 32609
#define IDS_PRICE_TRACKING_SETTINGS_EMAIL_DESCRIPTION 32610
#define IDS_PRICE_TRACKING_SETTINGS_POPUP_DESCRIPTION 32611
#define IDS_PRICE_TRACKING_SIDE_PANEL_ERROR_MESSAGE 32612
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TITLE 32613
#define IDS_PRICE_HISTORY_TITLE 32614
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_LOW_PRICE 32615
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_HIGH_PRICE 32616
#define IDS_PRICE_HISTORY_MULTIPLE_OPTIONS_TYPICAL_PRICE 32617
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_TITLE 32618
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_LOW_PRICE 32619
#define IDS_SHOPPING_INSIGHTS_ICON_EXPANDED_TEXT_HIGH_PRICE 32620
#define IDS_SHOPPING_INSIGHTS_ICON_TOOLTIP_TEXT 32621
#define IDS_SHOPPING_INSIGHTS_BUYING_OPTIONS 32622
#define IDS_PRICE_HISTORY_TODAY_PRICE 32623
#define IDS_PRICE_HISTORY_YESTERDAY_PRICE 32624
#define IDS_PRICE_HISTORY_DESCRIPTION 32625
#define IDS_SHOPPING_INSIGHTS_COLLECT_FEEDBACK 32626
#define IDS_SHOPPING_INSIGHTS_FEEDBACK_FORM_TITLE 32627
#define IDS_PRICE_RANGE_ALL_OPTIONS 32628
#define IDS_PRICE_RANGE_ALL_OPTIONS_ONE_TYPICAL_PRICE 32629
#define IDS_PRICE_RANGE_SINGLE_OPTION 32630
#define IDS_PRICE_RANGE_SINGLE_OPTION_ONE_TYPICAL_PRICE 32631
#define IDS_PRICE_HISTORY_SINGLE_OPTION_LOW_PRICE 32632
#define IDS_PRICE_HISTORY_SINGLE_OPTION_HIGH_PRICE 32633
#define IDS_PRICE_HISTORY_SINGLE_OPTION_TYPICAL_PRICE 32634
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_DESCRIPTION 32635
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_DONE 32636
#define IDS_SHOPPING_INSIGHTS_SIDE_PANEL_TRACK_PRICE_ERROR 32637
#define IDS_DISCOUNT_USE_THIS_CODE_AT_CHECKOUT 32638
#define IDS_DISCOUNT_EXPIRATION_DATE 32639
#define IDS_DISCOUNT_CODE_COPY_BUTTON_TEXT 32640
#define IDS_DISCOUNT_TERMS_AND_CONDITIONS 32641
#define IDS_DISCOUNT_ICON_EXPANDED_TEXT 32642
#define IDS_PRICE_DROP_POPUP_CONTENT_TITLE 32655
#define IDS_PRICE_DROP_POPUP_CONTENT_TEXT 32656
#define IDS_PRICE_DROP_POPUP_ACTION_BUTTON 32657
#define IDS_PRICE_DROP_POPUP_UNTRACK_BUTTON 32658
#define IDS_SHOPPING_COLLECTION_FOLDER_NAME 32659
#define IDS_LIVE_CAPTION_BUBBLE_TITLE 32660
#define IDS_LIVE_CAPTION_BUBBLE_CLOSE 32661
#define IDS_LIVE_CAPTION_BUBBLE_EXPAND 32662
#define IDS_LIVE_CAPTION_BUBBLE_COLLAPSE 32663
#define IDS_LIVE_CAPTION_BUBBLE_BACK_TO_TAB 32664
#define IDS_LIVE_CAPTION_BUBBLE_PIN 32665
#define IDS_LIVE_CAPTION_BUBBLE_UNPIN 32666
#define IDS_LIVE_CAPTION_BUBBLE_ERROR 32667
#define IDS_LIVE_CAPTION_BUBBLE_CONTENT_SETTINGS 32668
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR 32669
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR_CHECKBOX 32670
#define IDS_LIVE_CAPTION_BUBBLE_APPEAR_SCREENREADER_ANNOUNCEMENT 32671
#define IDS_LIVE_CAPTION_CAPTION_LANGUAGE_AUTODETECTED 32672
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE 32673
#define IDS_LIVE_CAPTION_TRANSLATED_CAPTION_LANGUAGE_AUTODETECTED 32674
#define IDS_LIVE_CAPTION_BUBBLE_CAPTION_SETTINGS 32675
#define IDS_SETTINGS_TITLE 32676
#define IDS_SETTINGS_HIDE_ADVANCED_SETTINGS 32677
#define IDS_SETTINGS_SHOW_ADVANCED_SETTINGS 32678
#define IDS_NETWORK_PREDICTION_ENABLED_DESCRIPTION 32679
#define IDS_OPTIONS_PROXIES_CONFIGURE_BUTTON 32680
#define IDS_CRASH_TITLE 32691
#define IDS_CRASH_CRASH_COUNT_BANNER_FORMAT 32692
#define IDS_CRASH_SHOW_DEVELOPER_DETAILS 32693
#define IDS_CRASH_CAPTURE_TIME_FORMAT 32694
#define IDS_CRASH_REPORT_STATUS 32695
#define IDS_CRASH_REPORT_STATUS_NOT_UPLOADED 32696
#define IDS_CRASH_REPORT_STATUS_PENDING 32697
#define IDS_CRASH_REPORT_STATUS_PENDING_USER_REQUESTED 32698
#define IDS_CRASH_REPORT_STATUS_UPLOADED 32699
#define IDS_CRASH_REPORT_UPLOADED_ID 32700
#define IDS_CRASH_REPORT_UPLOADED_TIME 32701
#define IDS_CRASH_REPORT_LOCAL_ID 32702
#define IDS_CRASH_REPORT_FILE_SIZE 32703
#define IDS_CRASH_BUG_LINK_LABEL 32704
#define IDS_CRASH_NO_CRASHES_MESSAGE 32705
#define IDS_CRASH_DISABLED_HEADER 32706
#define IDS_CRASH_UPLOAD_MESSAGE 32707
#define IDS_CRASH_UPLOAD_NOW_LINK_TEXT 32708
#define IDS_HTTP_POST_WARNING_TITLE 32709
#define IDS_HTTP_POST_WARNING 32710
#define IDS_HTTP_POST_WARNING_RESEND 32711
#define IDS_DOM_DISTILLER_JAVASCRIPT_DISABLED_CONTENT 32712
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_URL 32713
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD 32714
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD_FAILED 32715
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL 32716
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL_FAILED 32717
#define IDS_DOM_DISTILLER_WEBUI_REFRESH 32718
#define IDS_DOM_DISTILLER_WEBUI_FETCHING_ENTRIES 32719
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_TITLE 32720
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_CONTENT 32721
#define IDS_DOM_DISTILLER_VIEWER_LOADING_TITLE 32722
#define IDS_DOM_DISTILLER_VIEWER_CUSTOMIZE_APPEARANCE 32723
#define IDS_DOM_DISTILLER_VIEWER_FONT_STYLE 32724
#define IDS_DOM_DISTILLER_VIEWER_SANS_SERIF_FONT 32725
#define IDS_DOM_DISTILLER_VIEWER_SERIF_FONT 32726
#define IDS_DOM_DISTILLER_VIEWER_MONOSPACE_FONT 32727
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR 32728
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_LIGHT 32729
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_SEPIA 32730
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_DARK 32731
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE 32732
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_SMALL 32733
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_LARGE 32734
#define IDS_DOM_DISTILLER_VIEWER_CLOSE 32735
#define IDS_DOM_DISTILLER_VIEWER_NO_DATA_CONTENT 32736
#define IDS_DOM_DISTILLER_WEBUI_TITLE 32737
#define IDS_DOM_DISTILLER_VIEWER_TITLE_SUFFIX 32738
#define IDS_ENTERPRISE_COPY_PREVENTION_MISSING_LIST_ERROR 32739
#define IDS_ENTERPRISE_COPY_PREVENTION_DISABLE_CONTAINS_WILDCARD_ERROR 32740
#define IDS_ENTERPRISE_COPY_PREVENTION_WARNING_MESSAGE 32741
#define IDS_ERRORPAGE_NET_BUTTON_DETAILS 32742
#define IDS_ERRORPAGE_NET_BUTTON_HIDE_DETAILS 32743
#define IDS_ERRORPAGES_BUTTON_RELOAD 32744
#define IDS_ERRORPAGES_BUTTON_SHOW_SAVED_COPY 32745
#define IDS_ERRORPAGE_FUN_DISABLED 32746
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_REPOST_SUMMARY 32756
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_HEADER 32757
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_BODY 32758
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_HEADER 32759
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_BODY 32760
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_HEADER 32761
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_BODY 32762
#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_HEADER 32763
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_BODY 32764
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_HEADER 32765
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_BODY 32766
#define IDS_ERRORPAGES_SUGGESTION_CAPTIVE_PORTAL_SIGNIN 32767
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_HEADER 32769
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_BODY 32770
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_HEADER 32771
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_BODY 32772
#define IDS_ERRORPAGES_SUGGESTION_NAVIGATE_TO_ORIGIN 32773
#define IDS_ERRORPAGES_HEADING_NOT_AVAILABLE 32774
#define IDS_ERRORPAGES_HEADING_NETWORK_ACCESS_DENIED 32775
#define IDS_ERRORPAGES_HEADING_INTERNET_DISCONNECTED 32776
#define IDS_ERRORPAGES_HEADING_YOU_ARE_OFFLINE 32777
#define IDS_ERRORPAGES_MESSAGE_IWA_INVALID_WEB_BUNDLE 32778
#define IDS_ERRORPAGES_MESSAGE_IWA_CONNECTION_REFUSED 32779
#define IDS_ERRORPAGES_HEADING_CACHE_READ_FAILURE 32780
#define IDS_ERRORPAGES_HEADING_CONNECTION_INTERRUPTED 32781
#define IDS_ERRORPAGES_HEADING_NOT_FOUND 32782
#define IDS_ERRORPAGES_HEADING_FILE_NOT_FOUND 32783
#define IDS_ERRORPAGES_HEADING_BLOCKED 32784
#define IDS_ERRORPAGES_HEADING_BLOCKED_SCHEME 32785
#define IDS_ERRORPAGES_SUMMARY_NOT_AVAILABLE 32786
#define IDS_ERRORPAGES_SUMMARY_TIMED_OUT 32787
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_RESET 32788
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_CLOSED 32789
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_FAILED 32790
#define IDS_ERRORPAGES_SUMMARY_NETWORK_CHANGED 32791
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_REFUSED 32792
#define IDS_ERRORPAGES_SUMMARY_NAME_NOT_RESOLVED 32793
#define IDS_ERRORPAGES_SUMMARY_ICANN_NAME_COLLISION 32794
#define IDS_ERRORPAGES_SUMMARY_ADDRESS_UNREACHABLE 32795
#define IDS_ERRORPAGES_SUMMARY_FILE_ACCESS_DENIED 32796
#define IDS_ERRORPAGES_SUMMARY_NETWORK_ACCESS_DENIED 32797
#define IDS_ERRORPAGES_SUMMARY_PROXY_CONNECTION_FAILED 32798
#define IDS_ERRORPAGES_SUMMARY_CACHE_READ_FAILURE 32799
#define IDS_ERRORPAGES_SUMMARY_NETWORK_IO_SUSPENDED 32800
#define IDS_ERRORPAGES_SUMMARY_NOT_FOUND 32801
#define IDS_ERRORPAGES_SUMMARY_FILE_NOT_FOUND 32802
#define IDS_ERRORPAGES_SUMMARY_TOO_MANY_REDIRECTS 32803
#define IDS_ERRORPAGES_SUMMARY_EMPTY_RESPONSE 32804
#define IDS_ERRORPAGES_SUMMARY_INVALID_RESPONSE 32805
#define IDS_ERRORPAGES_SUMMARY_DNS_PROBE_RUNNING 32806
#define IDS_ERRORPAGES_HEADING_ACCESS_DENIED 32807
#define IDS_ERRORPAGES_HEADING_FILE_ACCESS_DENIED 32808
#define IDS_ERRORPAGES_SUMMARY_FORBIDDEN 32809
#define IDS_ERRORPAGES_SUMMARY_GONE 32810
#define IDS_ERRORPAGES_HEADING_PAGE_NOT_WORKING 32811
#define IDS_ERRORPAGES_SUMMARY_CONTACT_SITE_OWNER 32812
#define IDS_ERRORPAGES_SUMMARY_WEBSITE_CANNOT_HANDLE_REQUEST 32813
#define IDS_ERRORPAGES_SUMMARY_GATEWAY_TIMEOUT 32814
#define IDS_ERRORPAGES_SUMMARY_SSL_SECURITY_ERROR 32815
#define IDS_ERRORPAGES_SUMMARY_SSL_VERSION_OR_CIPHER_MISMATCH 32816
#define IDS_ERRORPAGES_HEADING_INSECURE_CONNECTION 32817
#define IDS_ERRORPAGES_SUMMARY_BAD_SSL_CLIENT_AUTH_CERT 32818
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_EXTENSION 32819
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_ADMINISTRATOR 32820
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_SECURITY 32821
#define IDS_ERRORPAGES_HTTP_POST_WARNING 32822
#define IDS_ERRORPAGES_SUGGESTION_LIST_HEADER 32823
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_SUMMARY 32824
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_DNS_SUMMARY 32826
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SECURE_DNS_SUMMARY 32827
#define IDS_ERRORPAGES_SUGGESTION_CHECK_FIREWALL_ANTIVIRUS_SUMMARY 32828
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SUMMARY 32829
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_ADDRESS_SUMMARY 32830
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY 32831
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY_STANDALONE 32832
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY 32833
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY_STANDALONE 32834
#define IDS_ERRORPAGES_SUGGESTION_CLEAR_COOKIES_SUMMARY 32835
#define IDS_ERRORPAGES_SUGGESTION_CHECK_HARDWARE_SUMMARY 32839
#define IDS_ERRORPAGES_SUGGESTION_CHECK_WIFI_SUMMARY 32840
#define IDS_ERRORPAGES_SUGGESTION_DISABLE_EXTENSION_SUMMARY 32841
#define IDS_ERRORPAGES_CHECK_TYPO_SUMMARY 32842
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE 32843
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_STANDALONE 32844
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_CHECK_TYPO_STANDALONE 32845
#define IDS_ERRORPAGES_GAME_INSTRUCTIONS 32846
#define IDS_ERRORPAGE_DINO_GAME_DESCRIPTION 32847
#define IDS_ERRORPAGE_DINO_ARIA_LABEL 32848
#define IDS_ERRORPAGE_DINO_GAME_START 32849
#define IDS_ERRORPAGE_DINO_GAME_OVER 32850
#define IDS_ERRORPAGE_DINO_HIGH_SCORE 32851
#define IDS_ERRORPAGE_DINO_JUMP 32852
#define IDS_ERRORPAGE_DINO_SLOW_SPEED_TOGGLE 32853
#define IDS_FIND_IN_PAGE_ACCESSIBLE_TITLE 32854
#define IDS_FIND_IN_PAGE_COUNT 32855
#define IDS_ACCESSIBLE_FIND_IN_PAGE_COUNT 32856
#define IDS_ACCESSIBLE_FIND_IN_PAGE_NO_RESULTS 32857
#define IDS_FIND_IN_PAGE_PREVIOUS_TOOLTIP 32858
#define IDS_FIND_IN_PAGE_NEXT_TOOLTIP 32859
#define IDS_FIND_IN_PAGE_CLOSE_TOOLTIP 32860
#define IDS_FLAGS_UI_SEARCH_PLACEHOLDER 32861
#define IDS_FLAGS_UI_SEARCH_LABEL 32862
#define IDS_FLAGS_UI_TITLE 32863
#define IDS_FLAGS_UI_PAGE_RESET 32864
#define IDS_FLAGS_UI_PAGE_WARNING 32865
#define IDS_FLAGS_UI_PAGE_WARNING_EXPLANATION 32866
#define IDS_FLAGS_UI_OWNER_WARNING 32867
#define IDS_FLAGS_UI_AVAILABLE_FEATURE 32868
#define IDS_FLAGS_UI_UNAVAILABLE_FEATURE 32869
#define IDS_FLAGS_UI_ENABLED_FEATURE 32870
#define IDS_FLAGS_UI_DISABLED_FEATURE 32871
#define IDS_FLAGS_UI_NO_RESULTS 32872
#define IDS_FLAGS_UI_NOT_AVAILABLE_ON_PLATFORM 32873
#define IDS_FLAGS_UI_RELAUNCH 32874
#define IDS_FLAGS_UI_CLEAR_SEARCH 32878
#define IDS_FLAGS_UI_RESET_ACKNOWLEDGED 32879
#define IDS_FLAGS_UI_EXPERIMENT_ENABLED 32880
#define IDS_FLAGS_UI_SEARCH_RESULTS_SINGULAR 32881
#define IDS_FLAGS_UI_SEARCH_RESULTS_PLURAL 32882
#define IDS_DEPRECATED_FEATURES_PAGE_RESET 32883
#define IDS_DEPRECATED_FEATURES_OWNER_WARNING 32884
#define IDS_DEPRECATED_FEATURES_AVAILABLE_FEATURE 32885
#define IDS_DEPRECATED_FEATURES_UNAVAILABLE_FEATURE 32886
#define IDS_DEPRECATED_FEATURES_ENABLED_FEATURE 32887
#define IDS_DEPRECATED_FEATURES_DISABLED_FEATURE 32888
#define IDS_DEPRECATED_FEATURES_NOT_AVAILABLE_ON_PLATFORM 32889
#define IDS_DEPRECATED_FEATURES_RELAUNCH 32890
#define IDS_DEPRECATED_FEATURES_SEARCH_PLACEHOLDER 32894
#define IDS_DEPRECATED_FEATURES_TITLE 32895
#define IDS_DEPRECATED_FEATURES_HEADING 32896
#define IDS_DEPRECATED_FEATURES_PAGE_WARNING_EXPLANATION 32897
#define IDS_DEPRECATED_FEATURES_NO_RESULTS 32898
#define IDS_DEPRECATED_UI_CLEAR_SEARCH 32899
#define IDS_DEPRECATED_UI_RESET_ACKNOWLEDGED 32900
#define IDS_DEPRECATED_UI_EXPERIMENT_ENABLED 32901
#define IDS_ENTERPRISE_UI_SEARCH_RESULTS_SINGULAR 32902
#define IDS_ENTERPRISE_UI_SEARCH_RESULTS_PLURAL 32903
#define IDS_EXIT_FULLSCREEN_MODE 32904
#define IDS_FULLSCREEN_HOLD_TO_EXIT_FULLSCREEN 32905
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN 32906
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN_TWO_KEYS 32907
#define IDS_PRESS_TO_EXIT_MOUSELOCK 32908
#define IDS_PRESS_TO_EXIT_MOUSELOCK_TWO_KEYS 32909
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS 32910
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS_AND_EXIT 32911
#define IDS_FULLSCREEN_HOLD_TO_SEE_DOWNLOADS_AND_EXIT 32912
#define IDS_GLOBAL_MEDIA_CONTROLS_BACK_TO_TAB 32913
#define IDS_GLOBAL_MEDIA_CONTROLS_DISMISS_ICON_TOOLTIP_TEXT 32914
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_DETAILS 32915
#define IDS_HEAVY_AD_INTERVENTION_HEADING 32916
#define IDS_HEAVY_AD_INTERVENTION_SUMMARY 32917
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_RELOAD 32918
#define IDS_HISTORY_ACTION_MENU_DESCRIPTION 32919
#define IDS_HISTORY_ARIA_ROLE_DESCRIPTION 32920
#define IDS_HISTORY_CANCEL_EDITING_BUTTON 32921
#define IDS_HISTORY_DATE_WITH_RELATIVE_TIME 32922
#define IDS_HISTORY_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 32923
#define IDS_HISTORY_DELETE_PRIOR_VISITS_WARNING 32924
#define IDS_HISTORY_DELETE_SELECTED_ENTRIES_BUTTON 32925
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_DELETE 32926
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_LABEL 32927
#define IDS_HISTORY_ENTRY_BOOKMARKED 32928
#define IDS_HISTORY_ENTRY_SUMMARY 32929
#define IDS_HISTORY_FOUND_SEARCH_RESULTS 32930
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY 32931
#define IDS_HISTORY_LOADING 32932
#define IDS_HISTORY_MORE_FROM_SITE 32933
#define IDS_HISTORY_NO_RESULTS 32934
#define IDS_HISTORY_NO_SEARCH_RESULTS 32935
#define IDS_HISTORY_OPEN_CLEAR_BROWSING_DATA_DIALOG 32936
#define IDS_HISTORY_OTHER_SESSIONS_COLLAPSE_SESSION 32937
#define IDS_HISTORY_OTHER_SESSIONS_EXPAND_SESSION 32938
#define IDS_HISTORY_OTHER_SESSIONS_HIDE_FOR_NOW 32939
#define IDS_HISTORY_OTHER_SESSIONS_OPEN_ALL 32940
#define IDS_HISTORY_REMOVE_BOOKMARK 32941
#define IDS_HISTORY_REMOVE_PAGE 32942
#define IDS_HISTORY_REMOVE_PAGE_SUCCESS 32943
#define IDS_HISTORY_REMOVE_SELECTED_ITEMS 32944
#define IDS_HISTORY_SEARCH_BUTTON 32945
#define IDS_HISTORY_SEARCH_RESULT 32946
#define IDS_HISTORY_SEARCH_RESULTS 32947
#define IDS_HISTORY_SHOW_HISTORY 32948
#define IDS_HISTORY_SHOWFULLHISTORY_LINK 32949
#define IDS_HISTORY_START_EDITING_BUTTON 32950
#define IDS_HISTORY_TITLE 32951
#define IDS_HISTORY_UNKNOWN_DEVICE 32952
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE 32953
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_IFRAME 32954
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL 32955
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL_IFRAME 32956
#define IDS_JAVASCRIPT_MESSAGEBOX_SUPPRESS_OPTION 32957
#define IDS_BEFOREUNLOAD_MESSAGEBOX_TITLE 32958
#define IDS_BEFOREUNLOAD_APP_MESSAGEBOX_TITLE 32959
#define IDS_BEFOREUNLOAD_MESSAGEBOX_OK_BUTTON_LABEL 32960
#define IDS_BEFOREUNLOAD_MESSAGEBOX_MESSAGE 32961
#define IDS_BEFORERELOAD_MESSAGEBOX_TITLE 32962
#define IDS_BEFORERELOAD_APP_MESSAGEBOX_TITLE 32963
#define IDS_BEFORERELOAD_MESSAGEBOX_OK_BUTTON_LABEL 32964
#define IDS_LOGIN_DIALOG_TITLE 32965
#define IDS_LOGIN_DIALOG_OK_BUTTON_LABEL 32966
#define IDS_LOGIN_DIALOG_AUTHORITY 32967
#define IDS_LOGIN_DIALOG_PROXY_AUTHORITY 32968
#define IDS_LOGIN_DIALOG_NOT_PRIVATE 32969
#define IDS_LOGIN_DIALOG_USERNAME_FIELD 32970
#define IDS_LOGIN_DIALOG_PASSWORD_FIELD 32971
#define IDS_MANAGEMENT_TITLE 32972
#define IDS_MANAGEMENT_TOOLBAR_TITLE 32973
#define IDS_MANAGEMENT_SUBTITLE 32977
#define IDS_MANAGEMENT_SUBTITLE_MANAGED_BY 32975
#define IDS_MANAGEMENT_NOT_MANAGED_SUBTITLE 32976
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY 32978
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY 32979
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_SAME_MANAGED_BY 32980
#define IDS_MANAGEMENT_SUBTITLE_PROFILE_MANAGED_BY 32981
#define IDS_MANAGEMENT_BROWSER_NOTICE 32982
#define IDS_MANAGEMENT_NOT_MANAGED_NOTICE 32983
#define IDS_MANAGEMENT_LEARN_MORE_ACCCESSIBILITY_TEXT 32984
#define IDS_MANAGEMENT_EXTENSION_REPORTING 33017
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED 33018
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED_BY 33019
#define IDS_MANAGEMENT_EXTENSIONS_NAME 33020
#define IDS_MANAGEMENT_EXTENSIONS_PERMISSIONS 33021
#define IDS_MANAGEMENT_APPLICATION_REPORTING 33022
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED 33023
#define IDS_MANAGEMENT_APPLICATIONS_INSTALLED_BY 33024
#define IDS_MANAGEMENT_APPLICATIONS_NAME 33025
#define IDS_MANAGEMENT_APPLICATIONS_PERMISSIONS 33026
#define IDS_MANAGEMENT_APPLICATIONS_RUN_ON_OS_LOGIN 33027
#define IDS_MANAGEMENT_MANAGED_WEBSITES 33028
#define IDS_MANAGEMENT_MANAGED_WEBSITES_EXPLANATION 33029
#define IDS_MANAGEMENT_MANAGED_WEBSITES_BY_EXPLANATION 33030
#define IDS_MANAGEMENT_BROWSER_REPORTING 33031
#define IDS_MANAGEMENT_BROWSER_REPORTING_EXPLANATION 33032
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME 33033
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME_ADDRESS 33034
#define IDS_MANAGEMENT_EXTENSION_REPORT_USERNAME 33035
#define IDS_MANAGEMENT_EXTENSION_REPORT_VERSION 33036
#define IDS_MANAGEMENT_EXTENSION_REPORT_EXTENSIONS_PLUGINS 33037
#define IDS_MANAGEMENT_EXTENSION_REPORT_USER_BROWSING_DATA 33038
#define IDS_MANAGEMENT_EXTENSION_REPORT_PERF_CRASH 33039
#define IDS_MANAGEMENT_THREAT_PROTECTION 33040
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION 33041
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION_BY 33042
#define IDS_MANAGEMENT_CONNECTORS_EVENT 33043
#define IDS_MANAGEMENT_CONNECTORS_VISIBLE_DATA 33044
#define IDS_MANAGEMENT_FILE_ATTACHED_EVENT 33045
#define IDS_MANAGEMENT_FILE_DOWNLOADED_EVENT 33046
#define IDS_MANAGEMENT_TEXT_ENTERED_EVENT 33047
#define IDS_MANAGEMENT_PAGE_PRINTED_EVENT 33048
#define IDS_MANAGEMENT_FILE_TRANSFER_EVENT 33049
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_EVENT 33050
#define IDS_MANAGEMENT_PAGE_VISITED_EVENT 33051
#define IDS_MANAGEMENT_SCREEN_CAPTURE_EVENT 33052
#define IDS_MANAGEMENT_FILE_ATTACHED_VISIBLE_DATA 33053
#define IDS_MANAGEMENT_FILE_DOWNLOADED_VISIBLE_DATA 33054
#define IDS_MANAGEMENT_TEXT_ENTERED_VISIBLE_DATA 33055
#define IDS_MANAGEMENT_PAGE_PRINTED_VISIBLE_DATA 33056
#define IDS_MANAGEMENT_FILE_TRANSFER_VISIBLE_DATA 33057
#define IDS_MANAGEMENT_SCREEN_CAPTURE_DATA 33058
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_VISIBLE_DATA 33059
#define IDS_MANAGEMENT_PAGE_VISITED_VISIBLE_DATA 33060
#define IDS_MANAGEMENT_DEVICE_SIGNALS_DISCLOSURE 33061
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PREVIOUS_TRACK 33062
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_BACKWARD 33063
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PLAY 33064
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PAUSE 33065
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_FORWARD 33066
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_NEXT_TRACK 33067
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_ENTER_PIP 33068
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_EXIT_PIP 33069
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_MUTE 33070
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_UNMUTE 33071
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_START_CASTING 33072
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_STOP_CASTING 33073
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_TIME_SCRUBBER 33074
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACCESSIBLE_NAME 33075
#define IDS_DEFAULT_TAB_TITLE 474
#define IDS_DOWNLOAD_TAB_TITLE 33076
#define IDS_SAD_TAB_TITLE 33077
#define IDS_SAD_TAB_MESSAGE 33078
#define IDS_SAD_TAB_HELP_MESSAGE 33079
#define IDS_SAD_TAB_HELP_LINK 33080
#define IDS_SAD_TAB_RELOAD_LABEL 33081
#define IDS_SAD_TAB_OOM_TITLE 33083
#define IDS_SAD_TAB_RELOAD_TITLE 33084
#define IDS_SAD_TAB_OOM_MESSAGE_TABS 33085
#define IDS_SAD_TAB_OOM_MESSAGE_NOTABS 33086
#define IDS_SAD_TAB_RELOAD_TRY 33087
#define IDS_SAD_TAB_RELOAD_INCOGNITO 33088
#define IDS_SAD_TAB_RELOAD_RESTART_BROWSER 33091
#define IDS_SAD_TAB_RELOAD_RESTART_DEVICE 33092
#define IDS_SAD_TAB_ERROR_CODE 33094
#define IDS_NEW_TAB_TITLE 484
#define IDS_NEW_INCOGNITO_TAB_TITLE 33095
#define IDS_INCOGNITO_TAB_LEARN_MORE_ACCESSIBILITY_LABEL 33096
#define IDS_NEW_TAB_OTR_HEADING 33097
#define IDS_NEW_TAB_OTR_DESCRIPTION 33098
#define IDS_NEW_TAB_OTR_LEARN_MORE_LINK 33099
#define IDS_NEW_TAB_OTR_MESSAGE_WARNING 33100
#define IDS_NEW_TAB_UNDO_THUMBNAIL_REMOVE 485
#define IDS_NEW_TAB_OTR_TITLE 33101
#define IDS_NEW_TAB_OTR_SUBTITLE 33102
#define IDS_NEW_TAB_OTR_SUBTITLE_WITH_READING_LIST 33103
#define IDS_NEW_TAB_OTR_NOT_SAVED 33104
#define IDS_NEW_TAB_OTR_VISIBLE 33105
#define IDS_NEW_TAB_OTR_COOKIE_CONTROLS_CONTROLLED_TOOLTIP_TEXT 33106
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE 33107
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE_SUBLABEL 33108
#define IDS_REVAMPED_INCOGNITO_NTP_TITLE 33109
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_HEADER 33110
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_DESCRIPTION 33111
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_NOT_HEADER 33112
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_NOT_DESCRIPTION 33113
#define IDS_REVAMPED_INCOGNITO_NTP_LEARN_MORE 33114
#define IDS_REVAMPED_INCOGNITO_NTP_OTR_THIRD_PARTY_COOKIE 33115
#define IDS_REVAMPED_INCOGNITO_NTP_OTR_THIRD_PARTY_COOKIE_SUBLABEL 33116
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 154
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUGGESTION_CONTENTS 153
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUFFIX 152
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA 151
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 158
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUGGESTION_CONTENTS 157
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUFFIX 156
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS 155
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 162
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUGGESTION_CONTENTS 161
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUFFIX 160
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD 159
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 166
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 165
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 164
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 163
#define IDS_OMNIBOX_PEDAL_TRANSLATE_HINT 170
#define IDS_OMNIBOX_PEDAL_TRANSLATE_SUGGESTION_CONTENTS 169
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE_SUFFIX 168
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE 167
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_HINT 174
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_SUGGESTION_CONTENTS 173
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME_SUFFIX 172
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME 171
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 178
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUGGESTION_CONTENTS 177
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUFFIX 176
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK 175
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_HINT 182
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUGGESTION_CONTENTS 181
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUFFIX 180
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS 179
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_HINT 186
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_SUGGESTION_CONTENTS 185
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES_SUFFIX 184
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES 183
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_HINT 190
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUGGESTION_CONTENTS 189
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUFFIX 188
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES 187
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_HINT 194
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_SUGGESTION_CONTENTS 193
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC_SUFFIX 192
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC 191
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_HINT 198
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUGGESTION_CONTENTS 197
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUFFIX 196
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS 195
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_HINT 206
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUGGESTION_CONTENTS 205
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUFFIX 204
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC 203
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_HINT 210
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUGGESTION_CONTENTS 209
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUFFIX 208
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET 207
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_HINT 214
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUGGESTION_CONTENTS 213
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUFFIX 212
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE 211
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_HINT 218
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUGGESTION_CONTENTS 217
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUFFIX 216
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT 215
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_HINT 222
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUGGESTION_CONTENTS 221
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUFFIX 220
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE 219
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_HINT 226
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUGGESTION_CONTENTS 225
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUFFIX 224
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE 223
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_HINT 230
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUGGESTION_CONTENTS 229
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUFFIX 228
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM 227
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_HINT 202
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUGGESTION_CONTENTS 201
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUFFIX 200
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS 199
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_HINT 234
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUGGESTION_CONTENTS 233
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUFFIX 232
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT 231
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_HINT 238
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUGGESTION_CONTENTS 237
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUFFIX 236
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD 235
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_HINT 33117
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUGGESTION_CONTENTS 33118
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUFFIX 33119
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS 33120
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 242
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUGGESTION_CONTENTS 241
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUFFIX 240
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME 239
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_HINT 246
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_SUGGESTION_CONTENTS 245
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE_SUFFIX 244
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE 243
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_HINT 250
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUGGESTION_CONTENTS 249
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUFFIX 248
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY 247
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 254
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUGGESTION_CONTENTS 253
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUFFIX 252
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS 251
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_HINT 258
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUGGESTION_CONTENTS 257
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUFFIX 256
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS 255
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 262
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUGGESTION_CONTENTS 261
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUFFIX 260
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY 259
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_HINT 266
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUGGESTION_CONTENTS 265
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUFFIX 264
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE 263
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_HINT 270
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUGGESTION_CONTENTS 269
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUFFIX 268
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY 267
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_HINT 274
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUGGESTION_CONTENTS 273
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUFFIX 272
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS 271
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_HINT 278
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUGGESTION_CONTENTS 277
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUFFIX 276
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES 275
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_HINT 282
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUGGESTION_CONTENTS 281
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUFFIX 280
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES 279
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_HINT 33121
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUGGESTION_CONTENTS 33122
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUFFIX 33123
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY 33124
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 286
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 285
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 284
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 283
#define IDS_ANDROID_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 33125
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 33126
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 33127
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 33128
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 33129
#define IDS_IOS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 33130
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 33131
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 33132
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 33133
#define IDS_IOS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 33134
#define IDS_IOS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 33135
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 33136
#define IDS_IOS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 33137
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 33138
#define IDS_IOS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 33139
#define IDS_IOS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 33140
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 33141
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 33142
#define IDS_AUTOCOMPLETE_SEARCH_DESCRIPTION 33143
#define IDS_EMPTY_KEYWORD_VALUE 471
#define IDS_LINK_FROM_CLIPBOARD 33144
#define IDS_TEXT_FROM_CLIPBOARD 33145
#define IDS_IMAGE_FROM_CLIPBOARD 33146
#define IDS_SECURE_CONNECTION_EV 33147
#define IDS_SECURE_VERBOSE_STATE 33148
#define IDS_NOT_SECURE_VERBOSE_STATE 33149
#define IDS_DANGEROUS_VERBOSE_STATE 33150
#define IDS_OFFLINE_VERBOSE_STATE 33151
#define IDS_OMNIBOX_ADDITIONAL_TEXT_DASH_TEMPLATE 33153
#define IDS_OMNIBOX_ADDITIONAL_TEXT_PARENTHESIS_TEMPLATE 33154
#define IDS_OMNIBOX_TAB_SUGGEST_HINT 33155
#define IDS_OMNIBOX_FILE 33156
#define IDS_OMNIBOX_READER_MODE 33157
#define IDS_DRIVE_SUGGESTION_DOCUMENT 33158
#define IDS_DRIVE_SUGGESTION_FORM 33159
#define IDS_DRIVE_SUGGESTION_SPREADSHEET 33160
#define IDS_DRIVE_SUGGESTION_PRESENTATION 33161
#define IDS_DRIVE_SUGGESTION_GENERAL 33162
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE 33163
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_DATE 33164
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_OWNER 33165
#define IDS_ACCURACY_CHECK_VERBOSE_STATE 33166
#define IDS_OMNIBOX_HISTORY_CLUSTERS_SEARCH_HINT 33167
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_HINT 33168
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUGGESTION_CONTENTS 33169
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUFFIX 33170
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH 33171
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST_SUFFIX 33172
#define IDS_ACC_OMNIBOX_ACTION_IN_SUGGEST 33173
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_HINT 33174
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_CALL_CONTENTS 33175
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_HINT 33176
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_DIRECTIONS_CONTENTS 33177
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_HINT 33178
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_REVIEWS_CONTENTS 33179
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_HINT 33180
#define IDS_OMNIBOX_ACTION_IN_SUGGEST_WEBSITE_CONTENTS 33181
#define IDS_ACC_AUTOCOMPLETE_HISTORY 33182
#define IDS_ACC_AUTOCOMPLETE_SEARCH_HISTORY 33183
#define IDS_ACC_AUTOCOMPLETE_SEARCH 33184
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH 33185
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH_ENTITY 33186
#define IDS_ACC_AUTOCOMPLETE_QUICK_ANSWER 33187
#define IDS_ACC_AUTOCOMPLETE_BOOKMARK 33188
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_IMAGE 33189
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_TEXT 33190
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_URL 33191
#define IDS_ACC_SEARCH_ICON 472
#define IDS_ACC_AUTOCOMPLETE_N_OF_M 33192
#define IDS_ACC_TAB_SWITCH_SUFFIX 33193
#define IDS_ACC_TAB_SWITCH_BUTTON_FOCUSED_PREFIX 33194
#define IDS_ACC_TAB_SWITCH_BUTTON 33195
#define IDS_ACC_MULTIPLE_ACTIONS_SUFFIX 33196
#define IDS_ACC_KEYWORD_SUFFIX 33197
#define IDS_ACC_KEYWORD_MODE 33198
#define IDS_ACC_REMOVE_SUGGESTION_SUFFIX 33199
#define IDS_ACC_REMOVE_SUGGESTION_FOCUSED_PREFIX 33200
#define IDS_ACC_REMOVE_SUGGESTION_BUTTON 33201
#define IDS_TOOLTIP_HEADER_SHOW_SUGGESTIONS_BUTTON 670
#define IDS_TOOLTIP_HEADER_HIDE_SUGGESTIONS_BUTTON 669
#define IDS_ACC_HEADER_SHOW_SUGGESTIONS_BUTTON 33202
#define IDS_ACC_HEADER_HIDE_SUGGESTIONS_BUTTON 33203
#define IDS_ACC_HEADER_SECTION_SHOWN 33204
#define IDS_ACC_HEADER_SECTION_HIDDEN 33205
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_NAME 33206
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_KEYWORD 33207
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_NAME 33208
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_KEYWORD 33209
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_NAME 33210
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_KEYWORD 33211
#define IDS_OMNIBOX_TAB_SEARCH_NO_RESULTS_FOUND 33212
#define IDS_OMNIBOX_ONE_LINE_CALCULATOR_SUGGESTION_TEMPLATE 33213
#define IDS_PAGE_INFO_SECURE_SUMMARY 33214
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY 33215
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY_SHORT 33216
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY 33217
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY_SHORT 33218
#define IDS_PAGE_INFO_MALWARE_SUMMARY 33219
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_SUMMARY 33220
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_SUMMARY 33221
#define IDS_PAGE_INFO_EXTENSION_PAGE 33222
#define IDS_PAGE_INFO_VIEW_SOURCE_PAGE 33223
#define IDS_PAGE_INFO_DEVTOOLS_PAGE 33224
#define IDS_PAGE_INFO_READER_MODE_PAGE_SECURE 33225
#define IDS_PAGE_INFO_READER_MODE_PAGE 33226
#define IDS_PAGE_INFO_SAFETY_TIP_MORE_INFO_LINK 33227
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_LEAVE_BUTTON 33228
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_TITLE 33229
#define IDS_PAGE_INFO_SAFETY_TIP_DESCRIPTION 33230
#define IDS_PAGE_INFO_FILE_PAGE 33231
#define IDS_PAGE_INFO_SECURE_DETAILS 33232
#define IDS_PAGE_INFO_ADMIN_PROVIDED_CERT_DETAILS 33233
#define IDS_PAGE_INFO_MIXED_CONTENT_DETAILS 33234
#define IDS_PAGE_INFO_LEGACY_TLS_DETAILS 33235
#define IDS_PAGE_INFO_NOT_SECURE_DETAILS 33236
#define IDS_PAGE_INFO_MALWARE_DETAILS 33237
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_DETAILS 33238
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_DETAILS 33239
#define IDS_PAGE_INFO_SECURITY_TAB_INSECURE_IDENTITY 33240
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SUMMARY 33241
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SAVED_PASSWORD_SUMMARY 33242
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SAVED 33243
#define IDS_PAGE_INFO_CHECK_PASSWORDS_BUTTON 33244
#define IDS_PAGE_INFO_INVALID_CERTIFICATE_DESCRIPTION 33245
#define IDS_PAGE_INFO_RESET_INVALID_CERTIFICATE_DECISIONS_BUTTON 33246
#define IDS_PAGE_INFO_HELP_CENTER_LINK 33247
#define IDS_PAGE_INFO_SECURITY_TAB_DEPRECATED_SIGNATURE_ALGORITHM 33248
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_CONNECTION_TEXT 33249
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_ERROR 33250
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_WARNING 33251
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_FORM_WARNING 33252
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_SENTENCE_LINK 33253
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS 33254
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS_AEAD 33255
#define IDS_PAGE_INFO_SECURITY_TAB_NON_UNIQUE_NAME 33256
#define IDS_PAGE_INFO_SECURITY_TAB_NOT_ENCRYPTED_CONNECTION_TEXT 33257
#define IDS_PAGE_INFO_SECURITY_TAB_SSL_VERSION 33258
#define IDS_PAGE_INFO_SECURITY_TAB_UNKNOWN_PARTY 33259
#define IDS_PAGE_INFO_SECURITY_TAB_WEAK_ENCRYPTION_CONNECTION_TEXT 33260
#define IDS_PAGE_INFO_CERT_INFO_BUTTON 33261
#define IDS_PAGE_INFO_ADDRESS 33262
#define IDS_PAGE_INFO_PARTIAL_ADDRESS 33263
#define IDS_PAGE_INFO_SECURITY_TAB_SECURE_IDENTITY_EV_VERIFIED 33264
#define IDS_PAGE_INFO_CERTIFICATE 33265
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK 33266
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK 33267
#define IDS_PAGE_INFO_CERTIFICATE_BUTTON_TEXT 33268
#define IDS_PAGE_INFO_CERTIFICATE_VALID_PARENTHESIZED 33269
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_PARENTHESIZED 33270
#define IDS_PAGE_INFO_CERTIFICATE_IS_VALID 33271
#define IDS_PAGE_INFO_CERTIFICATE_IS_NOT_VALID 33272
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK_TOOLTIP 33273
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK_TOOLTIP 33274
#define IDS_PAGE_INFO_COOKIES 33276
#define IDS_PAGE_INFO_COOKIES_BUTTON_TEXT 33277
#define IDS_PAGE_INFO_NUM_COOKIES_PARENTHESIZED 33278
#define IDS_PAGE_INFO_NUM_COOKIES 33279
#define IDS_PAGE_INFO_COOKIES_TOOLTIP 33280
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_USER 33281
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_ONCE_BY_USER 33282
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_USER 33283
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_USER 33284
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_USER 33285
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_USER 33286
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_DEFAULT 33287
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_DEFAULT 33288
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_DEFAULT 33289
#define IDS_PAGE_INFO_BUTTON_TEXT_AUTOMATIC_BY_DEFAULT 33290
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_DEFAULT 33291
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_DEFAULT 33292
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ALLOW 33293
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_BLOCK 33294
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ASK 33295
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_DETECT_IMPORTANT_CONTENT 33296
#define IDS_PAGE_INFO_MENU_ITEM_ALLOW 33297
#define IDS_PAGE_INFO_MENU_ITEM_BLOCK 33298
#define IDS_PAGE_INFO_MENU_ITEM_ASK 33299
#define IDS_PAGE_INFO_MENU_ITEM_DETECT_IMPORTANT_CONTENT 33300
#define IDS_PAGE_INFO_MENU_ITEM_ADS_BLOCK 33301
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED 33302
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_ONCE 33303
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED 33304
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_INCOGNITO 33305
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_GUEST 33306
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_INSECURE 33307
#define IDS_PAGE_INFO_STATE_TEXT_MUTED 33308
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_BY_DEFAULT 33309
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_BY_DEFAULT 33310
#define IDS_PAGE_INFO_SELECTOR_TOOLTIP 33311
#define IDS_PAGE_INFO_STATE_TEXT_AR_ASK 33312
#define IDS_PAGE_INFO_STATE_TEXT_AUTOMATIC_DOWNLOADS_ASK 33313
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_DEVICES_ASK 33314
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_ASK 33315
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_PAN_TILT_ZOOM_ASK 33316
#define IDS_PAGE_INFO_STATE_TEXT_CLIPBOARD_ASK 33317
#define IDS_PAGE_INFO_STATE_TEXT_FILE_SYSTEM_WRITE_ASK 33318
#define IDS_PAGE_INFO_STATE_TEXT_HID_DEVICES_ASK 33319
#define IDS_PAGE_INFO_STATE_TEXT_LOCATION_ASK 33320
#define IDS_PAGE_INFO_STATE_TEXT_MIC_ASK 33321
#define IDS_PAGE_INFO_STATE_TEXT_MIDI_ASK 33322
#define IDS_PAGE_INFO_STATE_TEXT_NOTIFICATIONS_ASK 33323
#define IDS_PAGE_INFO_STATE_TEXT_USB_ASK 33324
#define IDS_PAGE_INFO_STATE_TEXT_VR_ASK 33325
#define IDS_PAGE_INFO_STATE_TEXT_FONT_ACCESS_ASK 33326
#define IDS_PAGE_INFO_STATE_TEXT_SERIAL_ASK 33327
#define IDS_PAGE_INFO_STATE_TEXT_IDLE_DETECTION_ASK 33328
#define IDS_PAGE_INFO_STATE_TEXT_WINDOW_MANAGEMENT_ASK 33329
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_SCANNING_ASK 33330
#define IDS_PAGE_INFO_STATE_TEXT_STORAGE_ACCESS_ASK 33331
#define IDS_PAGE_INFO_USB_DEVICE_SECONDARY_LABEL 33332
#define IDS_PAGE_INFO_USB_DEVICE_ALLOWED_BY_POLICY_LABEL 33333
#define IDS_PAGE_INFO_DELETE_USB_DEVICE_WITH_NAME 33334
#define IDS_PAGE_INFO_SERIAL_PORT_SECONDARY_LABEL 33335
#define IDS_PAGE_INFO_SERIAL_PORT_ALLOWED_BY_POLICY_LABEL 33336
#define IDS_PAGE_INFO_DELETE_SERIAL_PORT_WITH_NAME 33337
#define IDS_PAGE_INFO_BLUETOOTH_DEVICE_SECONDARY_LABEL 33338
#define IDS_PAGE_INFO_DELETE_BLUETOOTH_DEVICE_WITH_NAME 33339
#define IDS_PAGE_INFO_HID_DEVICE_SECONDARY_LABEL 33340
#define IDS_PAGE_INFO_HID_DEVICE_ALLOWED_BY_POLICY_LABEL 33341
#define IDS_PAGE_INFO_DELETE_HID_DEVICE_WITH_NAME 33342
#define IDS_PAGE_INFO_SITE_SETTINGS_LINK 33343
#define IDS_PAGE_INFO_SITE_SETTINGS_TOOLTIP 33344
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_POLICY 33345
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_POLICY 33346
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_POLICY 33347
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_EXTENSION 33348
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_EXTENSION 33349
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_EXTENSION 33350
#define IDS_PAGE_INFO_PERMISSION_AUTOMATICALLY_BLOCKED 33351
#define IDS_PAGE_INFO_PERMISSION_ADS_SUBTITLE 33352
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_POLICY 33353
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_EXTENSION 33354
#define IDS_PAGE_INFO_INFOBAR_TEXT 33355
#define IDS_PAGE_INFO_INFOBAR_BUTTON 33356
#define IDS_PAGE_INFO_PERMISSION_USING_NOW 33357
#define IDS_PAGE_INFO_PERMISSION_RECENTLY_USED 33358
#define IDS_PAGE_INFO_PERMISSION_USED_TIME_AGO 33359
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS 33360
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SYNC 33361
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SIGNED_IN_NON_SYNC 33362
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE 33363
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE_WITH_ORG_NAME 33364
#define IDS_PAGE_INFO_CHANGE_PASSWORD_BUTTON 33365
#define IDS_PAGE_INFO_PROTECT_ACCOUNT_BUTTON 33366
#define IDS_PAGE_INFO_IGNORE_PASSWORD_WARNING_BUTTON 33367
#define IDS_PAGE_INFO_ALLOWLIST_PASSWORD_REUSE_BUTTON 33368
#define IDS_PAGE_INFO_BILLING_SUMMARY 33369
#define IDS_PAGE_INFO_BILLING_DETAILS 33370
#define IDS_PAGE_INFO_VR_PRESENTING_TEXT 33371
#define IDS_PAGE_INFO_VR_TURN_OFF_BUTTON_TEXT 33372
#define IDS_CERT_INFO_SUBJECT_GROUP 33373
#define IDS_CERT_INFO_ISSUER_GROUP 33374
#define IDS_CERT_INFO_COMMON_NAME_LABEL 33375
#define IDS_CERT_INFO_ORGANIZATION_LABEL 33376
#define IDS_CERT_INFO_ORGANIZATIONAL_UNIT_LABEL 33377
#define IDS_CERT_INFO_SERIAL_NUMBER_LABEL 33378
#define IDS_CERT_INFO_VALIDITY_GROUP 33379
#define IDS_CERT_INFO_ISSUED_ON_LABEL 33380
#define IDS_CERT_INFO_EXPIRES_ON_LABEL 33381
#define IDS_CERT_INFO_FINGERPRINTS_GROUP 33382
#define IDS_CERT_INFO_SHA256_FINGERPRINT_LABEL 33383
#define IDS_CERT_INFO_SHA1_FINGERPRINT_LABEL 33384
#define IDS_CERT_DETAILS_EXTENSIONS 33385
#define IDS_CERT_X509_SUBJECT_ALT_NAME 33386
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_BUTTON 33387
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_HEADER 33388
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_BUTTON_TOOLTIP 33389
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON 33390
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON_TOOLTIP 33391
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_REMEMBER_THIS_SETTING 33392
#define IDS_PAGE_INFO_RESET_PERMISSIONS 33393
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_HEADER 33394
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TITLE 33395
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_DESCRIPTION_PLACEHOLDER 33396
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_TOOLTIP 33397
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TOOLTIP 33398
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_SUBPAGE_FROM_LABEL 33399
#define IDS_PAGE_INFO_COOKIES_HEADER 33400
#define IDS_PAGE_INFO_COOKIES_DESCRIPTION 33401
#define IDS_PAGE_INFO_COOKIES_SETTINGS_LINK 33402
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TITLE 33403
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_TOGGLE_TOOLTIP 33404
#define IDS_PAGE_INFO_BLOCK_THIRD_PARTY_COOKIES_MANAGED_BY_SETTINGS_TOOLTIP 33405
#define IDS_PAGE_INFO_COOKIES_BLOCKED_SITES_COUNT 33406
#define IDS_PAGE_INFO_COOKIES_BLOCKED_SITES_COUNT_WHEN_FPS_BLOCKED 33407
#define IDS_PAGE_INFO_COOKIES_ALLOWED_SITES_COUNT 33408
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TITLE 33409
#define IDS_PAGE_INFO_COOKIES_DIALOG_BUTTON_TOOLTIP 33410
#define IDS_PAGE_INFO_FPS_BUTTON_TOOLTIP 33411
#define IDS_PAGE_INFO_FPS_BUTTON_TITLE 33412
#define IDS_PAGE_INFO_FPS_BUTTON_SUBTITLE 33413
#define IDS_PAGE_INFO_HISTORY 33414
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_TODAY 33415
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_YESTERDAY 33416
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DAYS 33417
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DATE 33418
#define IDS_PAGE_INFO_AD_PERSONALIZATION_HEADER 33419
#define IDS_PAGE_INFO_AD_PERSONALIZATION_TOOLTIP 33420
#define IDS_PAGE_INFO_AD_PERSONALIZATION_TOPICS_AND_INTEREST_GROUP_DESCRIPTION 33421
#define IDS_PAGE_INFO_AD_PERSONALIZATION_TOPICS_DESCRIPTION 33422
#define IDS_PAGE_INFO_AD_PERSONALIZATION_INTEREST_GROUP_DESCRIPTION 33423
#define IDS_PAGE_INFO_AD_PERSONALIZATION_SUBPAGE_MANAGE_BUTTON 33424
#define IDS_PAGE_INFO_ENTERPRISE_WARN_SUMMARY 33425
#define IDS_PAGE_INFO_ENTERPRISE_WARN_DETAILS 33426
#define IDS_PAGE_INFO_AD_PRIVACY_HEADER 33427
#define IDS_PAGE_INFO_AD_PRIVACY_TOOLTIP 33428
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_DESCRIPTION 33429
#define IDS_PAGE_INFO_AD_PRIVACY_FLEDGE_DESCRIPTION 33430
#define IDS_PAGE_INFO_AD_PRIVACY_TOPICS_AND_FLEDGE_DESCRIPTION 33431
#define IDS_PAGE_INFO_AD_PRIVACY_SUBPAGE_MANAGE_BUTTON 33432
#define IDS_PAGE_INFO_COOKIES_SITE_NOT_WORKING_TITLE 33433
#define IDS_PAGE_INFO_COOKIES_SITE_NOT_WORKING_DESCRIPTION_TEMPORARY 33434
#define IDS_PAGE_INFO_COOKIES_SITE_NOT_WORKING_DESCRIPTION_PERMANENT 33435
#define IDS_PAGE_INFO_COOKIES_THIRD_PARTY_COOKIES_LABEL 33436
#define IDS_PAGE_INFO_COOKIES_BLOCKING_RESTART_TITLE 33437
#define IDS_PAGE_INFO_COOKIES_BLOCKING_RESTART_DESCRIPTION_TODAY 33438
#define IDS_PAGE_INFO_COOKIES_PERMANENT_ALLOWED_TITLE 33439
#define IDS_PAGE_INFO_COOKIES_PERMANENT_ALLOWED_DESCRIPTION 33440
#define IDS_PAGE_INFO_COOKIES_THIRD_PARTY_COOKIES_ALLOWED_TOGGLE_A11Y 33441
#define IDS_PAGE_INFO_COOKIES_THIRD_PARTY_COOKIES_BLOCKED_TOGGLE_A11Y 33442
#define IDS_PAINT_PREVIEW_COMPOSITOR_SERVICE_DISPLAY_NAME 33443
#define IDS_LEAK_CHECK_CREDENTIALS 33444
#define IDS_CREDENTIAL_LEAK_TITLE_CHANGE 33445
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK 33446
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK_GPM 33447
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE 33448
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE 33449
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE 33450
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 33451
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_BRANDED 33452
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 33453
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 33454
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_NON_BRANDED 33455
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 33456
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE 33458
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE_UPDATED 33459
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE 33460
#define IDS_PASSWORD_MANAGER_EMPTY_LOGIN 33461
#define IDS_PASSWORD_MANAGER_OPT_INTO_ACCOUNT_STORE 33462
#define IDS_PASSWORD_MANAGER_RE_SIGNIN_ACCOUNT_STORE 33463
#define IDS_PASSWORD_MANAGER_NO_ACCOUNT_STORE_MATCHES 33464
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS 33465
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_AND_PASSKEYS 33466
#define IDS_PASSWORD_MANAGER_GENERATE_PASSWORD 33467
#define IDS_PASSWORD_MANAGER_EXCEPTIONS_TAB_TITLE 33468
#define IDS_PASSWORD_MANAGER_SHOW_PASSWORDS_TAB_TITLE 33469
#define IDS_PASSWORD_MANAGER_SMART_LOCK 33470
#define IDS_PASSWORD_MANAGER_DEFAULT_EXPORT_FILENAME 33471
#define IDS_PASSWORD_MANAGER_PASSWORD_FOR_ACCOUNT 33472
#define IDS_PASSWORD_MANAGER_USE_TOUCH_ID 33473
#define IDS_PASSWORD_MANAGER_USE_SCREEN_LOCK 33474
#define IDS_PASSWORD_MANAGER_USE_WINDOWS_HELLO 33475
#define IDS_PASSWORD_MANAGER_USE_GENERIC_DEVICE 33476
#define IDS_PASSWORD_MANAGER_USE_DEVICE_PASSKEY 33477
#define IDS_PASSWORD_MANAGER_FILLING_REAUTH 33478
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_TITLE_WIN 33479
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_MESSAGE_WIN 33480
#define IDS_PASSWORD_MANAGER_TURN_ON_FILLING_REAUTH_WIN 33481
#define IDS_PASSWORD_MANAGER_TURN_OFF_FILLING_REAUTH_WIN 33482
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_CONFIRMATION_TITLE_WIN 33483
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_CONFIRMATION_DESCRIPTION_WIN 33484
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_ACCEPT_BUTTON 33491
#define IDS_PASSWORD_MANAGER_SETTINGS 33492
#define IDS_PASSWORD_MANAGER_BIOMETRIC_AUTHENTICATION_FOR_FILLING_PROMO_CANCEL_BUTTON 33493
#define IDS_PAYMENTS_TITLE 33494
#define IDS_PAYMENTS_ERROR_MESSAGE_DIALOG_TITLE 33495
#define IDS_PAYMENTS_METHOD_OF_PAYMENT_LABEL 33496
#define IDS_PAYMENTS_CONTACT_DETAILS_LABEL 33497
#define IDS_PAYMENTS_ADD_CONTACT_DETAILS_LABEL 33498
#define IDS_PAYMENTS_EDIT_CONTACT_DETAILS_LABEL 33499
#define IDS_PAYMENTS_ADD_MORE_INFORMATION 33500
#define IDS_PAYMENTS_ADD_PHONE_NUMBER 33501
#define IDS_PAYMENTS_ADD_RECIPIENT 33502
#define IDS_PAYMENTS_ADD_VALID_ADDRESS 33503
#define IDS_PAYMENTS_ADD_EMAIL 33504
#define IDS_PAYMENTS_ADD_NAME 33505
#define IDS_PAYMENTS_ORDER_SUMMARY_LABEL 33506
#define IDS_PAYMENT_REQUEST_PAYMENT_METHOD_SECTION_NAME 33507
#define IDS_PAYMENT_REQUEST_CONTACT_INFO_SECTION_NAME 33508
#define IDS_PAYMENTS_SHIPPING_SUMMARY_LABEL 33509
#define IDS_PAYMENTS_SHIPPING_ADDRESS_LABEL 33510
#define IDS_PAYMENTS_SHIPPING_OPTION_LABEL 33511
#define IDS_PAYMENTS_DELIVERY_SUMMARY_LABEL 33512
#define IDS_PAYMENTS_DELIVERY_ADDRESS_LABEL 33513
#define IDS_PAYMENTS_DELIVERY_OPTION_LABEL 33514
#define IDS_PAYMENTS_PICKUP_SUMMARY_LABEL 33515
#define IDS_PAYMENTS_PICKUP_ADDRESS_LABEL 33516
#define IDS_PAYMENTS_PICKUP_OPTION_LABEL 33517
#define IDS_PAYMENTS_EDIT_BUTTON 33518
#define IDS_PAYMENTS_PAY_BUTTON 33519
#define IDS_PAYMENTS_CONTINUE_BUTTON 33520
#define IDS_PAYMENTS_ADD_CONTACT 33521
#define IDS_PAYMENTS_ADD_CARD 33522
#define IDS_PAYMENTS_ADD_ADDRESS 33523
#define IDS_PAYMENTS_EDIT_ADDRESS 33524
#define IDS_PAYMENTS_CANCEL_PAYMENT 33525
#define IDS_PAYMENTS_NAME_FIELD_IN_CONTACT_DETAILS 33526
#define IDS_PAYMENTS_PHONE_FIELD_IN_CONTACT_DETAILS 33527
#define IDS_PAYMENTS_EMAIL_FIELD_IN_CONTACT_DETAILS 33528
#define IDS_PAYMENTS_LOADING_MESSAGE 33529
#define IDS_PAYMENTS_PROCESSING_MESSAGE 33530
#define IDS_PAYMENTS_CHECKING_OPTION 33531
#define IDS_PAYMENTS_UPDATED_LABEL 33532
#define IDS_PAYMENTS_ERROR_MESSAGE 33533
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS 33534
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_IN 33535
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_OUT 33536
#define IDS_SETTINGS_CAN_MAKE_PAYMENT_TOGGLE_LABEL 33537
#define IDS_PAYMENTS_REQUIRED_FIELD_MESSAGE 33538
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRED 33539
#define IDS_PAYMENTS_VALIDATION_UNSUPPORTED_CREDIT_CARD_TYPE 33540
#define IDS_PAYMENTS_PHONE_INVALID_VALIDATION_MESSAGE 33541
#define IDS_PAYMENTS_EMAIL_INVALID_VALIDATION_MESSAGE 33542
#define IDS_PAYMENTS_CARD_NUMBER_INVALID_VALIDATION_MESSAGE 33543
#define IDS_PAYMENTS_INVALID_ADDRESS 33544
#define IDS_PAYMENTS_BILLING_ADDRESS_REQUIRED 33545
#define IDS_PAYMENTS_MORE_INFORMATION_REQUIRED 33546
#define IDS_PAYMENTS_PHONE_NUMBER_REQUIRED 33547
#define IDS_PAYMENTS_RECIPIENT_REQUIRED 33548
#define IDS_PAYMENTS_EMAIL_REQUIRED 33549
#define IDS_PAYMENTS_NAME_REQUIRED 33550
#define IDS_PREF_EDIT_DIALOG_FIELD_REQUIRED_VALIDATION_MESSAGE 33551
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SECTION_TOTAL_FORMAT 33552
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SHEET_TOTAL_FORMAT 33553
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MORE_ITEMS 33554
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MULTIPLE_CURRENCY_INDICATOR 33555
#define IDS_PAYMENTS_SELECT_SHIPPING_ADDRESS_FOR_SHIPPING_METHODS 33556
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_ADDRESS 33557
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_OPTION 33558
#define IDS_PAYMENTS_SELECT_DELIVERY_ADDRESS_FOR_DELIVERY_METHODS 33559
#define IDS_PAYMENTS_UNSUPPORTED_DELIVERY_ADDRESS 33560
#define IDS_PAYMENTS_SELECT_PICKUP_ADDRESS_FOR_PICKUP_METHODS 33561
#define IDS_PAYMENTS_UNSUPPORTED_PICKUP_ADDRESS 33562
#define IDS_PAYMENTS_ANDROID_APP_ERROR 33563
#define IDS_PAYMENT_REQUEST_PAYMENT_METHODS_PREVIEW 33565
#define IDS_PAYMENT_REQUEST_SHIPPING_ADDRESSES_PREVIEW 33566
#define IDS_PAYMENT_REQUEST_SHIPPING_OPTIONS_PREVIEW 33567
#define IDS_PAYMENT_REQUEST_CONTACTS_PREVIEW 33568
#define IDS_PAYMENTS_BACK 33569
#define IDS_PAYMENTS_CLOSE 33570
#define IDS_PAYMENTS_EDIT 33571
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_FORMAT 33572
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_SELECTED_FORMAT 33573
#define IDS_PAYMENTS_PROFILE_LABELS_ACCESSIBLE_FORMAT 33574
#define IDS_PAYMENTS_ACCESSIBLE_LABEL_WITH_ERROR 33575
#define IDS_PAYMENTS_ORDER_SUMMARY_ACCESSIBLE_LABEL 33576
#define IDS_PAYMENT_HANDLER_SHEET_DESCRIPTION 33577
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_HALF 33578
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_FULL 33579
#define IDS_PAYMENT_HANDLER_SHEET_CLOSED 33580
#define IDS_PAYMENT_HANDLER_ICON 33581
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_PURCHASE 33582
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LABEL 33583
#define IDS_SECURE_PAYMENT_CONFIRMATION_STORE_LABEL 33586
#define IDS_SECURE_PAYMENT_CONFIRMATION_TOTAL_LABEL 33587
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_BUTTON_LABEL 33588
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LINK_LABEL 33589
#define IDS_NO_MATCHING_CREDENTIAL_DESCRIPTION 33590
#define IDS_PDF_DOWNLOAD_ORIGINAL 33597
#define IDS_PDF_DOWNLOAD_EDITED 33598
#define IDS_PDF_PRESENT 33599
#define IDS_PDF_NEED_PASSWORD 33600
#define IDS_PDF_PASSWORD_DIALOG_TITLE 33601
#define IDS_PDF_PASSWORD_SUBMIT 33602
#define IDS_PDF_PASSWORD_INVALID 33603
#define IDS_PDF_PAGE_LOADING 33604
#define IDS_PDF_ERROR_DIALOG_TITLE 33605
#define IDS_PDF_PAGE_LOAD_FAILED 33606
#define IDS_PDF_PAGE_RELOAD_BUTTON 33607
#define IDS_PDF_BOOKMARKS 33608
#define IDS_PDF_BOOKMARK_EXPAND_ICON_ARIA_LABEL 33609
#define IDS_PDF_PROPERTIES_DIALOG_TITLE 33610
#define IDS_PDF_PROPERTIES_FILE_NAME 33611
#define IDS_PDF_PROPERTIES_FILE_SIZE 33612
#define IDS_PDF_PROPERTIES_TITLE 33613
#define IDS_PDF_PROPERTIES_AUTHOR 33614
#define IDS_PDF_PROPERTIES_SUBJECT 33615
#define IDS_PDF_PROPERTIES_KEYWORDS 33616
#define IDS_PDF_PROPERTIES_CREATED 33617
#define IDS_PDF_PROPERTIES_MODIFIED 33618
#define IDS_PDF_PROPERTIES_APPLICATION 33619
#define IDS_PDF_PROPERTIES_PDF_PRODUCER 33620
#define IDS_PDF_PROPERTIES_PDF_VERSION 33621
#define IDS_PDF_PROPERTIES_PAGE_COUNT 33622
#define IDS_PDF_PROPERTIES_PAGE_SIZE 33623
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_INCH 33624
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_MM 33625
#define IDS_PDF_PROPERTIES_PAGE_SIZE_PORTRAIT 33626
#define IDS_PDF_PROPERTIES_PAGE_SIZE_LANDSCAPE 33627
#define IDS_PDF_PROPERTIES_PAGE_SIZE_SQUARE 33628
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VARIABLE 33629
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW 33630
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_NO 33631
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_YES 33632
#define IDS_PDF_TOOLTIP_ROTATE_CCW 33633
#define IDS_PDF_ROTATION_STATE_LABEL_0 33634
#define IDS_PDF_ROTATION_STATE_LABEL_90 33635
#define IDS_PDF_ROTATION_STATE_LABEL_180 33636
#define IDS_PDF_ROTATION_STATE_LABEL_270 33637
#define IDS_PDF_TOOLTIP_DOWNLOAD 33638
#define IDS_PDF_TOOLTIP_PRINT 33639
#define IDS_PDF_TOOLTIP_FIT_PAGE 33640
#define IDS_PDF_TOOLTIP_FIT_WIDTH 33641
#define IDS_PDF_TWO_UP_VIEW_ENABLE 33642
#define IDS_PDF_ANNOTATIONS_SHOW_TOGGLE 33643
#define IDS_PDF_ZOOM_TEXT_INPUT_ARIA_LABEL 33644
#define IDS_PDF_TOOLTIP_ZOOM_IN 33645
#define IDS_PDF_TOOLTIP_ZOOM_OUT 33646
#define IDS_PDF_TOOLTIP_THUMBNAILS 33647
#define IDS_PDF_TOOLTIP_DOCUMENT_OUTLINE 33648
#define IDS_PDF_TOOLTIP_ATTACHMENTS 33649
#define IDS_PDF_TOOLTIP_DOWNLOAD_ATTACHMENT 33650
#define IDS_PDF_LABEL_PAGE_NUMBER 33651
#define IDS_PDF_OVERSIZE_ATTACHMENT_WARNING 33652
#define IDS_PDF_PAGE_INDEX 33653
#define IDS_PDF_DOCUMENT_PAGE_COUNT 33654
#define IDS_PDF_THUMBNAIL_PAGE_ARIA_LABEL 33655
#define IDS_AX_ROLE_DESCRIPTION_PDF_HIGHLIGHT 33707
#define IDS_AX_ROLE_DESCRIPTION_PDF_POPUP_NOTE 33708
#define IDS_PDF_OCR_FEATURE_ALERT 33709
#define IDS_PDF_OCR_IN_PROGRESS 33710
#define IDS_PDF_OCR_COMPLETED 33711
#define IDS_PDF_OCR_NO_RESULT 33712
#define IDS_PDF_OCR_RESULT_BEGIN 33713
#define IDS_PDF_OCR_RESULT_END 33714
#define IDS_GEOLOCATION_INFOBAR_TEXT 33715
#define IDS_PROTECTED_MEDIA_IDENTIFIER_PERMISSION_FRAGMENT 33738
#define IDS_PROTECTED_MEDIA_IDENTIFIER_PER_ORIGIN_PROVISIONING_INFOBAR_TEXT 33739
#define IDS_GEOLOCATION_INFOBAR_PERMISSION_FRAGMENT 33740
#define IDS_NOTIFICATION_PERMISSIONS_FRAGMENT 33741
#define IDS_MIDI_SYSEX_PERMISSION_FRAGMENT 33742
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT 33743
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT 33744
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT 33745
#define IDS_ACCESSIBILITY_EVENTS_PERMISSION_FRAGMENT 33746
#define IDS_CLIPBOARD_PERMISSION_FRAGMENT 33747
#define IDS_VR_PERMISSION_FRAGMENT 33748
#define IDS_AR_PERMISSION_FRAGMENT 33749
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_PROMPT_TITLE 33750
#define IDS_STORAGE_ACCESS_PERMISSION_FRAGMENT 33751
#define IDS_STORAGE_ACCESS_PERMISSION_EXPLANATION 33752
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_EXPLANATION 33753
#define IDS_STORAGE_ACCESS_PERMISSION_TWO_ORIGIN_LINK 33754
#define IDS_WINDOW_MANAGEMENT_PERMISSION_FRAGMENT 33755
#define IDS_FONT_ACCESS_PERMISSION_FRAGMENT 33756
#define IDS_IDLE_DETECTION_PERMISSION_FRAGMENT 33757
#define IDS_MULTI_DOWNLOAD_PERMISSION_FRAGMENT 33758
#define IDS_PERMISSION_ALLOW 33759
#define IDS_PERMISSION_DENY 33760
#define IDS_PERMISSION_ALLOW_THIS_TIME 33761
#define IDS_PERMISSION_ALLOW_EVERY_VISIT 33762
#define IDS_PERMISSION_DONT_ALLOW 33763
#define IDS_PERMISSION_NEVER_ALLOW 33764
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PROMPT 33765
#define IDS_BLUETOOTH_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 33766
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PAIR_BUTTON_TEXT 33767
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL 33768
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL_TOOLTIP 33769
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_WITH_ID 33770
#define IDS_BLUETOOTH_SCANNING_PROMPT 33771
#define IDS_BLUETOOTH_SCANNING_DEVICE_UNKNOWN 33772
#define IDS_BLUETOOTH_SCANNING_PROMPT_NO_DEVICES_FOUND_PROMPT 33773
#define IDS_BLUETOOTH_SCANNING_PROMPT_ALLOW_BUTTON_TEXT 33774
#define IDS_BLUETOOTH_SCANNING_PROMPT_BLOCK_BUTTON_TEXT 33775
#define IDS_DEVICE_CHOOSER_CANCEL_BUTTON_TEXT 33776
#define IDS_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 33777
#define IDS_USB_DEVICE_CHOOSER_PROMPT 33778
#define IDS_USB_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 33779
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL 33780
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL_TOOLTIP 33781
#define IDS_PRIVATE_NETWORK_DEVICE_CHOOSER_PROMPT_ORIGIN 33782
#define IDS_PRIVATE_NETWORK_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 33783
#define IDS_GEOLOCATION_PERMISSION_CHIP 33784
#define IDS_NOTIFICATION_PERMISSIONS_CHIP 33785
#define IDS_MIDI_SYSEX_PERMISSION_CHIP 33786
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_CHIP 33787
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_CHIP 33788
#define IDS_MEDIA_CAPTURE_VIDEO_AND_AUDIO_PERMISSION_CHIP 33789
#define IDS_CLIPBOARD_PERMISSION_CHIP 33790
#define IDS_SAA_PERMISSION_CHIP 33791
#define IDS_VR_PERMISSION_CHIP 33792
#define IDS_AR_PERMISSION_CHIP 33793
#define IDS_IDLE_DETECTION_PERMISSION_CHIP 33794
#define IDS_GEOLOCATION_PERMISSION_BLOCKED_CHIP 33795
#define IDS_NOTIFICATION_PERMISSIONS_BLOCKED_CHIP 33796
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_CONFIRMATION 33797
#define IDS_PERMISSIONS_PERMISSION_ALLOWED_ONCE_CONFIRMATION 33798
#define IDS_PERMISSIONS_PERMISSION_NOT_ALLOWED_CONFIRMATION 33799
#define IDS_PERMISSIONS_NOTIFICATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33800
#define IDS_PERMISSIONS_NOTIFICATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33801
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33802
#define IDS_PERMISSIONS_GEOLOCATION_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33803
#define IDS_PERMISSIONS_GEOLOCATION_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33804
#define IDS_PERMISSIONS_CAMERA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33805
#define IDS_PERMISSIONS_CAMERA_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33806
#define IDS_PERMISSIONS_CAMERA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33807
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33808
#define IDS_PERMISSIONS_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33809
#define IDS_PERMISSIONS_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33810
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33811
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_ALLOWED_ONCE_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33812
#define IDS_PERMISSIONS_CAMERA_AND_MICROPHONE_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33813
#define IDS_PERMISSIONS_SAA_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33814
#define IDS_PERMISSIONS_SAA_NOT_ALLOWED_CONFIRMATION_SCREENREADER_ANNOUNCEMENT 33815
#define IDS_REQUEST_QUOTA_INFOBAR_TEXT 33816
#define IDS_REQUEST_LARGE_QUOTA_INFOBAR_TEXT 33817
#define IDS_REQUEST_QUOTA_PERMISSION_FRAGMENT 33818
#define IDS_POLICY_DM_STATUS_SUCCESS 33819
#define IDS_POLICY_DM_STATUS_REQUEST_INVALID 33820
#define IDS_POLICY_DM_STATUS_REQUEST_FAILED 33821
#define IDS_POLICY_DM_STATUS_TEMPORARY_UNAVAILABLE 33822
#define IDS_POLICY_DM_STATUS_HTTP_STATUS_ERROR 33823
#define IDS_POLICY_DM_STATUS_RESPONSE_DECODING_ERROR 33824
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_NOT_SUPPORTED 33825
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NOT_FOUND 33826
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_TOKEN_INVALID 33827
#define IDS_POLICY_DM_STATUS_SERVICE_ACTIVATION_PENDING 33828
#define IDS_POLICY_DM_STATUS_SERVICE_INVALID_SERIAL_NUMBER 33829
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_ID_CONFLICT 33830
#define IDS_POLICY_DM_STATUS_SERVICE_MISSING_LICENSES 33831
#define IDS_POLICY_DM_STATUS_SERVICE_DEPROVISIONED 33832
#define IDS_POLICY_DM_STATUS_SERVICE_POLICY_NOT_FOUND 33833
#define IDS_POLICY_DM_STATUS_UNKNOWN_ERROR 33834
#define IDS_POLICY_DM_STATUS_INVALID_PACKAGED_DEVICE_FOR_KIOSK 33835
#define IDS_POLICY_DM_STATUS_SERVICE_DOMAIN_MISMATCH 33836
#define IDS_POLICY_DM_STATUS_CANNOT_SIGN_REQUEST 33837
#define IDS_POLICY_DM_STATUS_REQUEST_TOO_LARGE 33838
#define IDS_POLICY_DM_STATUS_SERVICE_TOO_MANY_REQUESTS 33839
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NEEDS_RESET 33840
#define IDS_POLICY_DM_STATUS_CONSUMER_ACCOUNT_WITH_PACKAGED_LICENSE 33841
#define IDS_POLICY_DM_STATUS_ENTERPRISE_ACCOUNT_IS_NOT_ELIGIBLE_TO_ENROLL 33842
#define IDS_POLICY_VALIDATION_OK 33843
#define IDS_POLICY_VALIDATION_BAD_INITIAL_SIGNATURE 33844
#define IDS_POLICY_VALIDATION_BAD_SIGNATURE 33845
#define IDS_POLICY_VALIDATION_ERROR_CODE_PRESENT 33846
#define IDS_POLICY_VALIDATION_PAYLOAD_PARSE_ERROR 33847
#define IDS_POLICY_VALIDATION_WRONG_POLICY_TYPE 33848
#define IDS_POLICY_VALIDATION_WRONG_SETTINGS_ENTITY_ID 33849
#define IDS_POLICY_VALIDATION_BAD_TIMESTAMP 33850
#define IDS_POLICY_VALIDATION_BAD_DM_TOKEN 33851
#define IDS_POLICY_VALIDATION_BAD_DEVICE_ID 33852
#define IDS_POLICY_VALIDATION_BAD_USER 33853
#define IDS_POLICY_VALIDATION_POLICY_PARSE_ERROR 33854
#define IDS_POLICY_VALIDATION_BAD_KEY_VERIFICATION_SIGNATURE 33855
#define IDS_POLICY_VALIDATION_VALUE_WARNING 33856
#define IDS_POLICY_VALIDATION_VALUE_ERROR 33857
#define IDS_POLICY_VALIDATION_UNKNOWN_ERROR 33858
#define IDS_POLICY_STORE_STATUS_OK 33859
#define IDS_POLICY_STORE_STATUS_LOAD_ERROR 33860
#define IDS_POLICY_STORE_STATUS_STORE_ERROR 33861
#define IDS_POLICY_STORE_STATUS_PARSE_ERROR 33862
#define IDS_POLICY_STORE_STATUS_SERIALIZE_ERROR 33863
#define IDS_POLICY_STORE_STATUS_VALIDATION_ERROR 33864
#define IDS_POLICY_STORE_STATUS_BAD_STATE 33865
#define IDS_POLICY_STORE_STATUS_UNKNOWN_ERROR 33866
#define IDS_POLICY_ASSOCIATION_STATE_ACTIVE 33867
#define IDS_POLICY_ASSOCIATION_STATE_UNMANAGED 33868
#define IDS_POLICY_ASSOCIATION_STATE_DEPROVISIONED 33869
#define IDS_POLICY_TYPE_ERROR 33870
#define IDS_POLICY_OUT_OF_RANGE_ERROR 33871
#define IDS_POLICY_VALUE_FORMAT_ERROR 33872
#define IDS_POLICY_INVALID_FILE_EXTENSION_ERROR 33873
#define IDS_POLICY_INVALID_HASH_ERROR 33874
#define IDS_POLICY_INVALID_SELECTION_ERROR 33875
#define IDS_POLICY_PAPER_SIZE_CUSTOM_NO_SIZE_ERROR 33876
#define IDS_POLICY_PAPER_SIZE_NOT_CUSTOM_ERROR 33877
#define IDS_POLICY_INVALID_ACCOUNT_PATTERN_FORMAT_ERROR 33878
#define IDS_POLICY_INVALID_PROTOCOL_ERROR 33879
#define IDS_POLICY_INVALID_ORIGIN_ERROR 33880
#define IDS_POLICY_EMPTY_ORIGIN_LIST_ERROR 33881
#define IDS_POLICY_INVALID_EXTENSION_ID_ERROR 33883
#define IDS_POLICY_INVALID_UPDATE_URL_ERROR 33884
#define IDS_POLICY_URL_PATH_SPECIFIED_ERROR 33885
#define IDS_POLICY_MISSING_VENDOR_ID_ERROR 33886
#define IDS_POLICY_INVALID_NUMBER_OF_URLS_ERROR 33887
#define IDS_POLICY_BRUSCHETTA_UNINSTALLABLE_ERROR 33888
#define IDS_POLICY_CLOUD_SOURCE_ONLY_ERROR 33889
#define IDS_POLICY_CLOUD_USER_ONLY_ERROR 33890
#define IDS_POLICY_CLOUD_MANAGEMENT_ENROLLMENT_ONLY_ERROR 33891
#define IDS_POLICY_DEFAULT_SEARCH_DISABLED 33892
#define IDS_POLICY_NOT_SPECIFIED_ERROR 33893
#define IDS_POLICY_EXTENSION_SETTINGS_ORIGIN_LIMIT_WARNING 33894
#define IDS_POLICY_URL_ALLOW_BLOCK_LIST_MAX_FILTERS_LIMIT_WARNING 33895
#define IDS_POLICY_ERROR_WITH_PATH 33896
#define IDS_POLICY_SCHEMA_VALIDATION_ERROR 33897
#define IDS_POLICY_INVALID_JSON_ERROR 33898
#define IDS_POLICY_INVALID_URL_ERROR 33899
#define IDS_POLICY_INVALID_SEARCH_URL_ERROR 33900
#define IDS_POLICY_INVALID_SECURE_DNS_MODE_ERROR 33901
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_ERROR 33902
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_ERROR 33903
#define IDS_POLICY_SECURE_DNS_SALT_INVALID_SIZE_ERROR 33904
#define IDS_POLICY_SECURE_DNS_TEMPLATES_IRRELEVANT_MODE_ERROR 33905
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_MODE_ERROR 33906
#define IDS_POLICY_SECURE_DNS_TEMPLATES_UNSET_MODE_ERROR 33907
#define IDS_POLICY_SECURE_DNS_TEMPLATES_NOT_SPECIFIED_ERROR 33908
#define IDS_POLICY_INVALID_PROXY_MODE_ERROR 33909
#define IDS_POLICY_OFF_CWS_URL_ERROR 33911
#define IDS_POLICY_HOMEPAGE_LOCATION_ERROR 33912
#define IDS_POLICY_PROXY_MODE_DISABLED_ERROR 33913
#define IDS_POLICY_PROXY_MODE_AUTO_DETECT_ERROR 33914
#define IDS_POLICY_PROXY_MODE_PAC_URL_ERROR 33915
#define IDS_POLICY_PROXY_MODE_FIXED_SERVERS_ERROR 33916
#define IDS_POLICY_PROXY_MODE_SYSTEM_ERROR 33917
#define IDS_POLICY_PROXY_BOTH_SPECIFIED_ERROR 33918
#define IDS_POLICY_PROXY_NEITHER_SPECIFIED_ERROR 33919
#define IDS_POLICY_OVERRIDDEN 33920
#define IDS_POLICY_VALUE_DEPRECATED 33921
#define IDS_POLICY_DEPENDENCY_ERROR 33922
#define IDS_POLICY_DEPENDENCY_ERROR_ANY_VALUE 33923
#define IDS_POLICY_IDLE_TIMEOUT_ACTIONS_DEPENDENCY_ERROR 33924
#define IDS_POLICY_USER_IS_NOT_AFFILIATED_ERROR 33925
#define IDS_POLICY_LEVEL_ERROR 33930
#define IDS_POLICY_OK 33931
#define IDS_POLICY_UNSET 33932
#define IDS_POLICY_UNKNOWN 33933
#define IDS_POLICY_PROTO_PARSING_ERROR 33934
#define IDS_POLICY_HEX_COLOR_ERROR 33935
#define IDS_POLICY_TITLE 33936
#define IDS_POLICY_FILTER_PLACEHOLDER 33937
#define IDS_POLICY_RELOAD_POLICIES 33938
#define IDS_POLICY_LOADING_POLICIES 33939
#define IDS_POLICY_LOAD_POLICIES_DONE 33940
#define IDS_EXPORT_POLICIES_JSON 33941
#define IDS_UPLOAD_REPORT 33942
#define IDS_REPORT_UPLOADING 33943
#define IDS_REPORT_UPLOADED 33944
#define IDS_POLICY_STATUS 33945
#define IDS_POLICY_STATUS_DEVICE 33946
#define IDS_POLICY_STATUS_USER 33947
#define IDS_POLICY_STATUS_MACHINE 33948
#define IDS_POLICY_STATUS_UPDATER 33949
#define IDS_POLICY_STATUS_ERROR_MANAGED_NO_POLICY 33950
#define IDS_POLICY_STATUS_FLEX_ORG_NO_POLICY 33951
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DOMAIN 33952
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_TOKEN 33953
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DEVICE_ID 33954
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_MACHINE_NAME 33955
#define IDS_POLICY_LABEL_USERNAME 33956
#define IDS_POLICY_LABEL_GAIA_ID 33957
#define IDS_POLICY_LABEL_CLIENT_ID 33958
#define IDS_POLICY_LABEL_PROFILE_ID 33959
#define IDS_POLICY_LABEL_ASSET_ID 33960
#define IDS_POLICY_LABEL_LOCATION 33961
#define IDS_POLICY_LABEL_DIRECTORY_API_ID 33962
#define IDS_POLICY_LABEL_MANAGED_BY 33963
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_FETCH_ATTEMPT 33964
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_REFRESH 33965
#define IDS_POLICY_LABEL_LAST_CLOUD_REPORT_SENT_TIMESTAMP 33966
#define IDS_POLICY_NOT_SPECIFIED 33967
#define IDS_POLICY_LABEL_PUSH_POLICIES 33968
#define IDS_POLICY_PUSH_POLICIES_ON 33969
#define IDS_POLICY_PUSH_POLICIES_OFF 33970
#define IDS_POLICY_NEVER_FETCHED 33971
#define IDS_POLICY_LABEL_REFRESH_INTERVAL 33972
#define IDS_POLICY_LABEL_CONFLICT 33973
#define IDS_POLICY_LABEL_SUPERSEDING 33974
#define IDS_POLICY_LABEL_CONFLICT_VALUE 33975
#define IDS_POLICY_LABEL_SUPERSEDED_VALUE 33976
#define IDS_POLICY_LABEL_ERROR 33977
#define IDS_POLICY_LABEL_DEPRECATED 33978
#define IDS_POLICY_LABEL_FUTURE 33979
#define IDS_POLICY_LABEL_IGNORED 33980
#define IDS_POLICY_LABEL_VALUE 33981
#define IDS_POLICY_LABEL_VERSION 33982
#define IDS_POLICY_LABEL_STATUS 33983
#define IDS_POLICY_LABEL_INFO 33984
#define IDS_POLICY_LABEL_PRECEDENCE 33985
#define IDS_POLICY_SHOW_UNSET 33986
#define IDS_POLICY_NO_POLICIES_SET 33987
#define IDS_POLICY_HEADER_SCOPE 33988
#define IDS_POLICY_HEADER_LEVEL 33989
#define IDS_POLICY_HEADER_NAME 33990
#define IDS_POLICY_HEADER_VALUE 33991
#define IDS_POLICY_HEADER_STATUS 33992
#define IDS_POLICY_HEADER_SOURCE 33993
#define IDS_POLICY_HEADER_WARNING 33994
#define IDS_POLICY_SHOW_MORE 33995
#define IDS_POLICY_SHOW_LESS 33996
#define IDS_POLICY_LEARN_MORE 33997
#define IDS_POLICY_SCOPE_USER 33998
#define IDS_POLICY_SCOPE_ALL_USERS 33999
#define IDS_POLICY_SCOPE_DEVICE 34000
#define IDS_POLICY_LEVEL_RECOMMENDED 34001
#define IDS_POLICY_LEVEL_MANDATORY 34002
#define IDS_POLICY_SOURCE_ENTERPRISE_DEFAULT 34003
#define IDS_POLICY_SOURCE_DEFAULT 34004
#define IDS_POLICY_SOURCE_COMMAND_LINE 34005
#define IDS_POLICY_SOURCE_CLOUD 34006
#define IDS_POLICY_SOURCE_MERGED 34007
#define IDS_POLICY_SOURCE_CLOUD_FROM_ASH 34008
#define IDS_POLICY_SOURCE_RESTRICTED_MANAGED_GUEST_SESSION_OVERRIDE 34009
#define IDS_POLICY_SOURCE_ACTIVE_DIRECTORY 34010
#define IDS_POLICY_SOURCE_PLATFORM 34011
#define IDS_POLICY_SOURCE_DEVICE_LOCAL_ACCOUNT_OVERRIDE 34012
#define IDS_POLICY_RISK_TAG_FULL_ADMIN_ACCESS 34013
#define IDS_POLICY_RISK_TAG_SYSTEM_SECURITY 34014
#define IDS_POLICY_RISK_TAG_WEBSITE_SHARING 34015
#define IDS_POLICY_RISK_TAG_ADMIN_SHARING 34016
#define IDS_POLICY_RISK_TAG_FILTERING 34017
#define IDS_POLICY_RISK_TAG_LOCAL_DATA_ACCESS 34018
#define IDS_POLICY_RISK_TAG_GOOGLE_SHARING 34019
#define IDS_POLICY_SHOW_EXPANDED_STATUS 34020
#define IDS_POLICY_HIDE_EXPANDED_STATUS 34021
#define IDS_POLICY_LIST_MERGING_WRONG_POLICY_TYPE_SPECIFIED 34022
#define IDS_POLICY_DICTIONARY_MERGING_WRONG_POLICY_TYPE_SPECIFIED 34023
#define IDS_POLICY_DICTIONARY_MERGING_POLICY_NOT_ALLOWED 34024
#define IDS_POLICY_CONFLICT_SAME_VALUE 34025
#define IDS_POLICY_CONFLICT_DIFF_VALUE 34026
#define IDS_POLICY_MIGRATED_OLD_POLICY 34027
#define IDS_POLICY_MIGRATED_NEW_POLICY 34028
#define IDS_POLICY_BLOCKED 34029
#define IDS_POLICY_INVALID 34030
#define IDS_POLICY_IGNORED_BY_GROUP_MERGING 34031
#define IDS_POLICY_INVALID_VALUE 34032
#define IDS_POLICY_IGNORED_MANDATORY_REPORTING_POLICY 34033
#define IDS_POLICY_IGNORED_CHROME_PROFILE 34034
#define IDS_POLICY_IGNORED_UNAFFILIATED 34035
#define IDS_POLICY_PRECEDENCE_PLATFORM_MACHINE 34036
#define IDS_POLICY_PRECEDENCE_PLATFORM_USER 34037
#define IDS_POLICY_PRECEDENCE_CLOUD_MACHINE 34038
#define IDS_POLICY_PRECEDENCE_CLOUD_USER 34039
#define IDS_POLICY_SPELLCHECK_UNKNOWN_LANGUAGE 34040
#define IDS_POLICY_SPELLCHECK_BLOCKLIST_IGNORE 34041
#define IDS_POLICY_LABEL_IS_AFFILIATED 34042
#define IDS_POLICY_IS_AFFILIATED_YES 34043
#define IDS_POLICY_IS_AFFILIATED_NO 34044
#define IDS_POLICY_LABEL_IS_OFFHOURS_ACTIVE 34045
#define IDS_POLICY_OFFHOURS_ACTIVE 34046
#define IDS_POLICY_OFFHOURS_NOT_ACTIVE 34047
#define IDS_POLICY_SIGNIN_PROFILE 34048
#define IDS_POLICY_COPY_VALUE 34049
#define IDS_COPY_POLICIES_JSON 34050
#define IDS_POLICY_LOGS_TITLE 34051
#define IDS_VERSION_INFO 34052
#define IDS_EXPORT_POLICY_LOGS_JSON 34053
#define IDS_REFRESH_POLICY_LOGS 34054
#define IDS_POLICY_TEST_TITLE 34055
#define IDS_POLICY_TEST_RESTART_AND_APPLY 34056
#define IDS_POLICY_TEST_APPLY 34057
#define IDS_POLICY_TEST_IMPORT 34058
#define IDS_POLICY_TEST_DESC 34059
#define IDS_POLICY_TEST_REVERT 34060
#define IDS_POLICY_TEST_TABLE_SCOPE 34061
#define IDS_POLICY_TEST_ADD 34062
#define IDS_POLICY_SELECT_NAME 34063
#define IDS_POLICY_TEST_TABLE_PRESET 34064
#define IDS_LOCAL_TEST_POLICIES_ENABLED 34065
#define IDS_POLICY_TEST_PRESET_CUSTOM 34066
#define IDS_POLICY_TEST_PRESET_LOCAL_MACHINE 34067
#define IDS_POLICY_TEST_PRESET_CLOUD_ACCOUNT 34068
#define IDS_POLICY_TEST_USER_AFFILIATED 34069
#define IDS_CHROME_URLS_DISABLED_PAGE_HEADER 34070
#define IDS_CHROME_URLS_DISABLED_PAGE_TITLE 34071
#define IDS_CHROME_URLS_DISABLED_PAGE_MESSAGE 34072
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_PASTE 34073
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_COPY_VM 34074
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_TOAST_BUTTON 34075
#define IDS_POLICY_DLP_ANDROID_APPS 34076
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_DISMISS_BUTTON 34077
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_PASTE 34078
#define IDS_POLICY_DLP_CLIPBOARD_WARN_PROCEED_BUTTON 34079
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_COPY_VM 34080
#define IDS_POLICY_DLP_PRINTING_BLOCKED_TITLE 34081
#define IDS_POLICY_DLP_PRINTING_BLOCKED_MESSAGE 34082
#define IDS_POLICY_DLP_PRINTING_WARN_TITLE 34083
#define IDS_POLICY_DLP_PRINTING_WARN_MESSAGE 34084
#define IDS_POLICY_DLP_PRINTING_WARN_CONTINUE_BUTTON 34085
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_TITLE 34086
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_MESSAGE 34087
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_TITLE 34088
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_MESSAGE 34089
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_TITLE 34090
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_MESSAGE 34091
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_TITLE 34092
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_MESSAGE 34093
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_TITLE 34094
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_MESSAGE 34095
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_TITLE 34096
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_MESSAGE 34097
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_CONTINUE_BUTTON 34098
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_TITLE 34099
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_MESSAGE 34100
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_CONTINUE_BUTTON 34101
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_TITLE 34102
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_MESSAGE 34103
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CONTINUE_BUTTON 34104
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CANCEL_BUTTON 34105
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_TITLE 34106
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_TITLE 34107
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_TITLE 34108
#define IDS_POLICY_DLP_FILES_MOVE_WARN_TITLE 34109
#define IDS_POLICY_DLP_FILES_COPY_WARN_TITLE 34110
#define IDS_POLICY_DLP_FILES_OPEN_WARN_TITLE 34111
#define IDS_POLICY_DLP_FILES_DOWNLOAD_REVIEW_TITLE 34112
#define IDS_POLICY_DLP_FILES_TRANSFER_REVIEW_TITLE 34113
#define IDS_POLICY_DLP_FILES_UPLOAD_REVIEW_TITLE 34114
#define IDS_POLICY_DLP_FILES_MOVE_REVIEW_TITLE 34115
#define IDS_POLICY_DLP_FILES_COPY_REVIEW_TITLE 34116
#define IDS_POLICY_DLP_FILES_OPEN_REVIEW_TITLE 34117
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_MESSAGE 34118
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_MESSAGE 34119
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_MESSAGE 34120
#define IDS_POLICY_DLP_FILES_MOVE_WARN_MESSAGE 34121
#define IDS_POLICY_DLP_FILES_COPY_WARN_MESSAGE 34122
#define IDS_POLICY_DLP_FILES_OPEN_WARN_MESSAGE 34123
#define IDS_POLICY_DLP_FILES_WARN_MESSAGE 34124
#define IDS_POLICY_DLP_FILES_DOWNLOAD_WARN_CONTINUE_BUTTON 34125
#define IDS_POLICY_DLP_FILES_TRANSFER_WARN_CONTINUE_BUTTON 34126
#define IDS_POLICY_DLP_FILES_UPLOAD_WARN_CONTINUE_BUTTON 34127
#define IDS_POLICY_DLP_FILES_MOVE_WARN_CONTINUE_BUTTON 34128
#define IDS_POLICY_DLP_FILES_COPY_WARN_CONTINUE_BUTTON 34129
#define IDS_POLICY_DLP_FILES_OPEN_WARN_CONTINUE_BUTTON 34130
#define IDS_POLICY_DLP_FILES_DESTINATION_REMOVABLE_STORAGE 34131
#define IDS_POLICY_DLP_FILES_REVIEW_BUTTON 34132
#define IDS_POLICY_DLP_FILES_DISMISS_BUTTON 34133
#define IDS_POLICY_DLP_FILES_OK_BUTTON 34134
#define IDS_POLICY_DLP_WARN_CANCEL_BUTTON 34135
#define IDS_POLICY_DLP_CLIPBOARD_BUBBLE_MESSAGE 34136
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_TITLE 34137
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCK_MESSAGE 34138
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_TITLE 34139
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCK_MESSAGE 34140
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_TITLE 34141
#define IDS_POLICY_DLP_FILES_OPEN_BLOCK_MESSAGE 34142
#define IDS_POLICY_DLP_FILES_DOWNLOAD_BLOCKED_TITLE 34143
#define IDS_POLICY_DLP_FILES_TRANSFER_BLOCKED_TITLE 34144
#define IDS_POLICY_DLP_FILES_UPLOAD_BLOCKED_TITLE 34145
#define IDS_POLICY_DLP_FILES_MOVE_BLOCKED_TITLE 34146
#define IDS_POLICY_DLP_FILES_COPY_BLOCKED_TITLE 34147
#define IDS_POLICY_DLP_FILES_OPEN_BLOCKED_TITLE 34148
#define IDS_POLICY_DLP_FILES_POLICY_BLOCK_MESSAGE 34149
#define IDS_POLICY_DLP_FILES_CONTENT_BLOCK_MESSAGE 34150
#define IDS_POLICY_DLP_FILES_BLOCK_MESSAGE 34151
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_TITLE 34152
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_TITLE 34153
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_TITLE 34154
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_TITLE 34155
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_TITLE 34156
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_TITLE 34157
#define IDS_POLICY_DLP_FILES_DOWNLOAD_TIMEOUT_MESSAGE 34158
#define IDS_POLICY_DLP_FILES_TRANSFER_TIMEOUT_MESSAGE 34159
#define IDS_POLICY_DLP_FILES_UPLOAD_TIMEOUT_MESSAGE 34160
#define IDS_POLICY_DLP_FILES_MOVE_TIMEOUT_MESSAGE 34161
#define IDS_POLICY_DLP_FILES_COPY_TIMEOUT_MESSAGE 34162
#define IDS_POLICY_DLP_FILES_OPEN_TIMEOUT_MESSAGE 34163
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_TITLE 34164
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_MESSAGE 34165
#define IDS_POLICY_REBOOT_BUTTON 34166
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_DIALOG_MESSAGE 34167
#define IDS_REBOOT_SCHEDULED_TITLE_MINUTES 34168
#define IDS_REBOOT_SCHEDULED_TITLE_SECONDS 34169
#define IDS_POLICY_DEVICE_POST_REBOOT_TITLE 34170
#define IDS_POLICY_BROWSING_DATA_DEPENDENCY_APPLIED_INFO 34171
#define PRINT_PREVIEW_MEDIA_ASME_F_28X40IN 34172
#define PRINT_PREVIEW_MEDIA_ISO_2A0_1189X1682MM 34173
#define PRINT_PREVIEW_MEDIA_ISO_A0_841X1189MM 34174
#define PRINT_PREVIEW_MEDIA_ISO_A0X3_1189X2523MM 34175
#define PRINT_PREVIEW_MEDIA_ISO_A10_26X37MM 34176
#define PRINT_PREVIEW_MEDIA_ISO_A1_594X841MM 34177
#define PRINT_PREVIEW_MEDIA_ISO_A1X3_841X1783MM 34178
#define PRINT_PREVIEW_MEDIA_ISO_A1X4_841X2378MM 34179
#define PRINT_PREVIEW_MEDIA_ISO_A2_420X594MM 34180
#define PRINT_PREVIEW_MEDIA_ISO_A2X3_594X1261MM 34181
#define PRINT_PREVIEW_MEDIA_ISO_A2X4_594X1682MM 34182
#define PRINT_PREVIEW_MEDIA_ISO_A2X5_594X2102MM 34183
#define PRINT_PREVIEW_MEDIA_ISO_A3_297X420MM 34184
#define PRINT_PREVIEW_MEDIA_ISO_A3_EXTRA_322X445MM 34185
#define PRINT_PREVIEW_MEDIA_ISO_A3X3_420X891MM 34186
#define PRINT_PREVIEW_MEDIA_ISO_A3X4_420X1189MM 34187
#define PRINT_PREVIEW_MEDIA_ISO_A3X5_420X1486MM 34188
#define PRINT_PREVIEW_MEDIA_ISO_A3X6_420X1783MM 34189
#define PRINT_PREVIEW_MEDIA_ISO_A3X7_420X2080MM 34190
#define PRINT_PREVIEW_MEDIA_ISO_A4_210X297MM 34191
#define PRINT_PREVIEW_MEDIA_ISO_A4_EXTRA_235_5X322_3MM 34192
#define PRINT_PREVIEW_MEDIA_ISO_A4_TAB_225X297MM 34193
#define PRINT_PREVIEW_MEDIA_ISO_A4X3_297X630MM 34194
#define PRINT_PREVIEW_MEDIA_ISO_A4X4_297X841MM 34195
#define PRINT_PREVIEW_MEDIA_ISO_A4X5_297X1051MM 34196
#define PRINT_PREVIEW_MEDIA_ISO_A4X6_297X1261MM 34197
#define PRINT_PREVIEW_MEDIA_ISO_A4X7_297X1471MM 34198
#define PRINT_PREVIEW_MEDIA_ISO_A4X8_297X1682MM 34199
#define PRINT_PREVIEW_MEDIA_ISO_A4X9_297X1892MM 34200
#define PRINT_PREVIEW_MEDIA_ISO_A5_148X210MM 34201
#define PRINT_PREVIEW_MEDIA_ISO_A5_EXTRA_174X235MM 34202
#define PRINT_PREVIEW_MEDIA_ISO_A6_105X148MM 34203
#define PRINT_PREVIEW_MEDIA_ISO_A7_74X105MM 34204
#define PRINT_PREVIEW_MEDIA_ISO_A8_52X74MM 34205
#define PRINT_PREVIEW_MEDIA_ISO_A9_37X52MM 34206
#define PRINT_PREVIEW_MEDIA_ISO_B0_1000X1414MM 34207
#define PRINT_PREVIEW_MEDIA_ISO_B10_31X44MM 34208
#define PRINT_PREVIEW_MEDIA_ISO_B1_707X1000MM 34209
#define PRINT_PREVIEW_MEDIA_ISO_B2_500X707MM 34210
#define PRINT_PREVIEW_MEDIA_ISO_B3_353X500MM 34211
#define PRINT_PREVIEW_MEDIA_ISO_B4_250X353MM 34212
#define PRINT_PREVIEW_MEDIA_ISO_B5_176X250MM 34213
#define PRINT_PREVIEW_MEDIA_ISO_B5_EXTRA_201X276MM 34214
#define PRINT_PREVIEW_MEDIA_ISO_B6C4_125X324MM 34215
#define PRINT_PREVIEW_MEDIA_ISO_B6_125X176MM 34216
#define PRINT_PREVIEW_MEDIA_ISO_B7_88X125MM 34217
#define PRINT_PREVIEW_MEDIA_ISO_B8_62X88MM 34218
#define PRINT_PREVIEW_MEDIA_ISO_B9_44X62MM 34219
#define PRINT_PREVIEW_MEDIA_ISO_C0_917X1297MM 34220
#define PRINT_PREVIEW_MEDIA_ISO_C10_28X40MM 34221
#define PRINT_PREVIEW_MEDIA_ISO_C1_648X917MM 34222
#define PRINT_PREVIEW_MEDIA_ISO_C2_458X648MM 34223
#define PRINT_PREVIEW_MEDIA_ISO_C3_324X458MM 34224
#define PRINT_PREVIEW_MEDIA_ISO_C4_229X324MM 34225
#define PRINT_PREVIEW_MEDIA_ISO_C5_162X229MM 34226
#define PRINT_PREVIEW_MEDIA_ISO_C6C5_114X229MM 34227
#define PRINT_PREVIEW_MEDIA_ISO_C6_114X162MM 34228
#define PRINT_PREVIEW_MEDIA_ISO_C7C6_81X162MM 34229
#define PRINT_PREVIEW_MEDIA_ISO_C7_81X114MM 34230
#define PRINT_PREVIEW_MEDIA_ISO_C8_57X81MM 34231
#define PRINT_PREVIEW_MEDIA_ISO_C9_40X57MM 34232
#define PRINT_PREVIEW_MEDIA_ISO_DL_110X220MM 34233
#define PRINT_PREVIEW_MEDIA_ISO_ID_1_53_98X85_6MM 34234
#define PRINT_PREVIEW_MEDIA_ISO_RA0_860X1220MM 34235
#define PRINT_PREVIEW_MEDIA_ISO_RA1_610X860MM 34236
#define PRINT_PREVIEW_MEDIA_ISO_RA2_430X610MM 34237
#define PRINT_PREVIEW_MEDIA_ISO_RA3_305X430MM 34238
#define PRINT_PREVIEW_MEDIA_ISO_RA4_215X305MM 34239
#define PRINT_PREVIEW_MEDIA_ISO_SRA0_900X1280MM 34240
#define PRINT_PREVIEW_MEDIA_ISO_SRA1_640X900MM 34241
#define PRINT_PREVIEW_MEDIA_ISO_SRA2_450X640MM 34242
#define PRINT_PREVIEW_MEDIA_ISO_SRA3_320X450MM 34243
#define PRINT_PREVIEW_MEDIA_ISO_SRA4_225X320MM 34244
#define PRINT_PREVIEW_MEDIA_JIS_B0_1030X1456MM 34245
#define PRINT_PREVIEW_MEDIA_JIS_B1_728X1030MM 34246
#define PRINT_PREVIEW_MEDIA_JIS_B2_515X728MM 34247
#define PRINT_PREVIEW_MEDIA_JIS_B3_364X515MM 34248
#define PRINT_PREVIEW_MEDIA_JIS_B4_257X364MM 34249
#define PRINT_PREVIEW_MEDIA_JIS_B5_182X257MM 34250
#define PRINT_PREVIEW_MEDIA_JIS_B6_128X182MM 34251
#define PRINT_PREVIEW_MEDIA_JIS_B7_91X128MM 34252
#define PRINT_PREVIEW_MEDIA_JIS_B8_64X91MM 34253
#define PRINT_PREVIEW_MEDIA_JIS_B9_45X64MM 34254
#define PRINT_PREVIEW_MEDIA_JIS_B10_32X45MM 34255
#define PRINT_PREVIEW_MEDIA_JIS_EXEC_216X330MM 34256
#define PRINT_PREVIEW_MEDIA_JPN_CHOU2_111_1X146MM 34257
#define PRINT_PREVIEW_MEDIA_JPN_CHOU3_120X235MM 34258
#define PRINT_PREVIEW_MEDIA_JPN_CHOU4_90X205MM 34259
#define PRINT_PREVIEW_MEDIA_JPN_CHOU40_90X225MM 34260
#define PRINT_PREVIEW_MEDIA_JPN_HAGAKI_100X148MM 34261
#define PRINT_PREVIEW_MEDIA_JPN_KAHU_240X322_1MM 34262
#define PRINT_PREVIEW_MEDIA_JPN_KAKU1_270X382MM 34263
#define PRINT_PREVIEW_MEDIA_JPN_KAKU2_240X332MM 34264
#define PRINT_PREVIEW_MEDIA_JPN_KAKU3_216X277MM 34265
#define PRINT_PREVIEW_MEDIA_JPN_KAKU4_197X267MM 34266
#define PRINT_PREVIEW_MEDIA_JPN_KAKU5_190X240MM 34267
#define PRINT_PREVIEW_MEDIA_JPN_KAKU7_142X205MM 34268
#define PRINT_PREVIEW_MEDIA_JPN_KAKU8_119X197MM 34269
#define PRINT_PREVIEW_MEDIA_JPN_OUFUKU_148X200MM 34270
#define PRINT_PREVIEW_MEDIA_JPN_YOU4_105X235MM 34271
#define PRINT_PREVIEW_MEDIA_JPN_YOU6_98X190MM 34272
#define PRINT_PREVIEW_MEDIA_NA_10X11_10X11IN 34273
#define PRINT_PREVIEW_MEDIA_NA_10X13_10X13IN 34274
#define PRINT_PREVIEW_MEDIA_NA_10X14_10X14IN 34275
#define PRINT_PREVIEW_MEDIA_NA_10X15_10X15IN 34276
#define PRINT_PREVIEW_MEDIA_NA_11X12_11X12IN 34277
#define PRINT_PREVIEW_MEDIA_NA_11X15_11X15IN 34278
#define PRINT_PREVIEW_MEDIA_NA_12X19_12X19IN 34279
#define PRINT_PREVIEW_MEDIA_NA_5X7_5X7IN 34280
#define PRINT_PREVIEW_MEDIA_NA_6X9_6X9IN 34281
#define PRINT_PREVIEW_MEDIA_NA_7X9_7X9IN 34282
#define PRINT_PREVIEW_MEDIA_NA_9X11_9X11IN 34283
#define PRINT_PREVIEW_MEDIA_NA_A2_4_375X5_75IN 34284
#define PRINT_PREVIEW_MEDIA_NA_ARCH_A_9X12IN 34285
#define PRINT_PREVIEW_MEDIA_NA_ARCH_B_12X18IN 34286
#define PRINT_PREVIEW_MEDIA_NA_ARCH_C_18X24IN 34287
#define PRINT_PREVIEW_MEDIA_NA_ARCH_D_24X36IN 34288
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E_36X48IN 34289
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E2_26X38IN 34290
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E3_27X39IN 34291
#define PRINT_PREVIEW_MEDIA_NA_B_PLUS_12X19_17IN 34292
#define PRINT_PREVIEW_MEDIA_NA_C5_6_5X9_5IN 34293
#define PRINT_PREVIEW_MEDIA_NA_C_17X22IN 34294
#define PRINT_PREVIEW_MEDIA_NA_D_22X34IN 34295
#define PRINT_PREVIEW_MEDIA_NA_EDP_11X14IN 34296
#define PRINT_PREVIEW_MEDIA_NA_EUR_EDP_12X14IN 34297
#define PRINT_PREVIEW_MEDIA_NA_E_34X44IN 34298
#define PRINT_PREVIEW_MEDIA_NA_EXECUTIVE_7_25X10_5IN 34299
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_EUR_8_5X12IN 34300
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_US_11X14_875IN 34301
#define PRINT_PREVIEW_MEDIA_NA_FOOLSCAP_8_5X13IN 34302
#define PRINT_PREVIEW_MEDIA_NA_F_44X68IN 34303
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LEGAL_8X13IN 34304
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LETTER_8X10IN 34305
#define PRINT_PREVIEW_MEDIA_NA_INDEX_3X5_3X5IN 34306
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_4X6IN 34307
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_EXT_6X8IN 34308
#define PRINT_PREVIEW_MEDIA_NA_INDEX_5X8_5X8IN 34309
#define PRINT_PREVIEW_MEDIA_NA_INVOICE_5_5X8_5IN 34310
#define PRINT_PREVIEW_MEDIA_NA_LEDGER_11X17IN 34311
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_8_5X14IN 34312
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_EXTRA_9_5X15IN 34313
#define PRINT_PREVIEW_MEDIA_NA_LETTER_8_5X11IN 34314
#define PRINT_PREVIEW_MEDIA_NA_LETTER_EXTRA_9_5X12IN 34315
#define PRINT_PREVIEW_MEDIA_NA_LETTER_PLUS_8_5X12_69IN 34316
#define PRINT_PREVIEW_MEDIA_NA_MONARCH_3_875X7_5IN 34317
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_9_3_875X8_875IN 34318
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_10_4_125X9_5IN 34319
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_11_4_5X10_375IN 34320
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_12_4_75X11IN 34321
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_14_5X11_5IN 34322
#define PRINT_PREVIEW_MEDIA_NA_OFICIO_8_5X13_4IN 34323
#define PRINT_PREVIEW_MEDIA_NA_PERSONAL_3_625X6_5IN 34324
#define PRINT_PREVIEW_MEDIA_NA_QUARTO_8_5X10_83IN 34325
#define PRINT_PREVIEW_MEDIA_NA_SUPER_A_8_94X14IN 34326
#define PRINT_PREVIEW_MEDIA_NA_SUPER_B_13X19IN 34327
#define PRINT_PREVIEW_MEDIA_NA_WIDE_FORMAT_30X42IN 34328
#define PRINT_PREVIEW_MEDIA_OE_12X16_12X16IN 34329
#define PRINT_PREVIEW_MEDIA_OE_14X17_14X17IN 34330
#define PRINT_PREVIEW_MEDIA_OE_18X22_18X22IN 34331
#define PRINT_PREVIEW_MEDIA_OE_A2PLUS_17X24IN 34332
#define PRINT_PREVIEW_MEDIA_OE_BUSINESS_CARD_2X3_5IN 34333
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_10R_10X12IN 34334
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_12R_12X15IN 34335
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_14X18_14X18IN 34336
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_16R_16X20IN 34337
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_20R_20X24IN 34338
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22R_22X29_5IN 34339
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_22X28_22X28IN 34340
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24R_24X31_5IN 34341
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_24X30_24X30IN 34342
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_30R_30X40IN 34343
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_L_3_5X5IN 34344
#define PRINT_PREVIEW_MEDIA_OE_PHOTO_S8R_8X12IN 34345
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_4X4IN 34346
#define PRINT_PREVIEW_MEDIA_OE_SQUARE_PHOTO_5X5IN 34347
#define PRINT_PREVIEW_MEDIA_OM_16K_184X260MM 34348
#define PRINT_PREVIEW_MEDIA_OM_16K_195X270MM 34349
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X85MM 34350
#define PRINT_PREVIEW_MEDIA_OM_BUSINESS_CARD_55X91MM 34351
#define PRINT_PREVIEW_MEDIA_OM_CARD_54X86MM 34352
#define PRINT_PREVIEW_MEDIA_OM_DAI_PA_KAI_275X395MM 34353
#define PRINT_PREVIEW_MEDIA_OM_DSC_PHOTO_89X119MM 34354
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_210X330MM 34355
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_SP_215X315MM 34356
#define PRINT_PREVIEW_MEDIA_OM_INVITE_220X220MM 34357
#define PRINT_PREVIEW_MEDIA_OM_ITALIAN_110X230MM 34358
#define PRINT_PREVIEW_MEDIA_OM_JUURO_KU_KAI_198X275MM 34359
#define PRINT_PREVIEW_MEDIA_OM_LARGE_PHOTO_200X300 34360
#define PRINT_PREVIEW_MEDIA_OM_MEDIUM_PHOTO_130X180MM 34361
#define PRINT_PREVIEW_MEDIA_OM_PA_KAI_267X389MM 34362
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X40_300X400MM 34363
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_30X45_300X450MM 34364
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_35X46_350X460MM 34365
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_40X60_400X600MM 34366
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X75_500X750MM 34367
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_50X76_500X760MM 34368
#define PRINT_PREVIEW_MEDIA_OM_PHOTO_60X90_600X900MM 34369
#define PRINT_PREVIEW_MEDIA_OM_SQUARE_PHOTO_89X89MM 34370
#define PRINT_PREVIEW_MEDIA_OM_WIDE_PHOTO_100X200MM 34371
#define PRINT_PREVIEW_MEDIA_OM_SMALL_PHOTO_100X150MM 34372
#define PRINT_PREVIEW_MEDIA_PRC_16K_146X215MM 34373
#define PRINT_PREVIEW_MEDIA_PRC_1_102X165MM 34374
#define PRINT_PREVIEW_MEDIA_PRC_2_102X176MM 34375
#define PRINT_PREVIEW_MEDIA_PRC_32K_97X151MM 34376
#define PRINT_PREVIEW_MEDIA_PRC_4_110X208MM 34377
#define PRINT_PREVIEW_MEDIA_PRC_6_120X320MM 34378
#define PRINT_PREVIEW_MEDIA_PRC_7_160X230MM 34379
#define PRINT_PREVIEW_MEDIA_PRC_8_120X309MM 34380
#define PRINT_PREVIEW_MEDIA_ROC_16K_7_75X10_75IN 34381
#define PRINT_PREVIEW_MEDIA_ROC_8K_10_75X15_5IN 34382
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_INCHES 34383
#define PRINT_PREVIEW_MEDIA_DIMENSIONS_MM 34384
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_INCHES 34385
#define PRINT_PREVIEW_MEDIA_NAME_WITH_DIMENSIONS_MM 34386
#define IDS_PRINT_PREVIEW_FRIENDLY_WIN_NETWORK_PRINTER_NAME 34387
#define IDS_PRINT_COMPOSITOR_SERVICE_DISPLAY_NAME 34388
#define IDS_PRIVACY_SANDBOX_FLOC_INVALID 34790
#define IDS_PRIVACY_SANDBOX_FLOC_DESCRIPTION 34791
#define IDS_PRIVACY_SANDBOX_FLOC_TIME_TO_NEXT_COMPUTE 34792
#define IDS_PRIVACY_SANDBOX_FLOC_TIME_TO_NEXT_COMPUTE_INVALID 34793
#define IDS_PRIVACY_SANDBOX_FLOC_RESET_EXPLANATION 34794
#define IDS_PRIVACY_SANDBOX_FLOC_STATUS_ACTIVE 34795
#define IDS_PRIVACY_SANDBOX_FLOC_STATUS_ELIGIBLE_NOT_ACTIVE 34796
#define IDS_PRIVACY_SANDBOX_FLOC_STATUS_NOT_ACTIVE 34797
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_TITLE 34798
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_1 34799
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_2 34800
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_3 34801
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_EXPAND_LABEL 34802
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DESCRIPTION_4 34803
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_DECLINE_BUTTON 34804
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_ACCEPT_BUTTON 34805
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_SAVING_LABEL 34806
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_1 34807
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_2 34808
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_BULLET_3 34809
#define IDS_PRIVACY_SANDBOX_M1_CONSENT_LEARN_MORE_LINK 34810
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_TITLE 34811
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_1 34812
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_1 34813
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_BULLET_2 34814
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_EXPAND_LABEL 34815
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_DESCRIPTION_2 34816
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_ACK_BUTTON 34817
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_SETTINGS_BUTTON 34818
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_1 34819
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_1 34820
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_2 34821
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_BULLET_3 34822
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_HEADING_2 34823
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_EEA_LEARN_MORE_DESCRIPTION 34824
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_TITLE 34825
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_1 34826
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_2 34827
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_DESCRIPTION_3 34828
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_ACK_BUTTON 34829
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_RESTRICTED_SETTINGS_BUTTON 34830
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_TITLE 34831
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_1 34832
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_2 34833
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_3 34834
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_EXPAND_LABEL 34835
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_DESCRIPTION_4 34836
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_ACK_BUTTON 34837
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_SETTINGS_BUTTON 34838
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_1 34839
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_1 34840
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_1 34841
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_BULLET_2 34842
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_2 34843
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_3 34844
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_HEADING_2 34845
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_4 34846
#define IDS_PRIVACY_SANDBOX_M1_NOTICE_ROW_LEARN_MORE_DESCRIPTION_5 34847
#define IDS_PRIVACY_SANDBOX_M1_DIALOG_MORE_BUTTON 34848
#define IDS_SETTINGS_TOPICS_PAGE_TITLE 34849
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_LABEL 34850
#define IDS_SETTINGS_TOPICS_PAGE_TOGGLE_SUB_LABEL 34851
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_HEADING 34852
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_CANONICAL 34853
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_DISABLED 34854
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_EMPTY 34855
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC 34856
#define IDS_SETTINGS_TOPICS_PAGE_BLOCK_TOPIC_A11Y_LABEL 34857
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_HEADING 34858
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION 34859
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_DESCRIPTION_EMPTY 34860
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC 34861
#define IDS_SETTINGS_TOPICS_PAGE_ALLOW_TOPIC_A11Y_LABEL 34862
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_HEADING 34863
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_1 34864
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_2 34865
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_3_CANONICAL 34866
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER_CANONICAL 34867
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_STATUS_LABEL 34868
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TIME_LABEL 34869
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_SOURCE_LABEL 34870
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_LAST_UPDATE_TEXT_LABEL 34871
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_SETTINGS 34872
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_DEFAULT 34873
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_UPDATE_SOURCE_CONFIRMATION 34874
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_ACTIVE 34875
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_INACTIVE 34876
#define IDS_PRIVACY_SANDBOX_TOPICS_CONSENT_NOT_REQUIRED 34877
#define IDS_PRIVACY_SANDBOX_TOPICS_INVALID_TOPIC 34878
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_1 34879
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_2 34880
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_3 34881
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_4 34882
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_5 34883
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_6 34884
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_7 34885
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_8 34886
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_9 34887
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_10 34888
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_11 34889
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_12 34890
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_13 34891
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_14 34892
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_15 34893
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_16 34894
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_17 34895
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_18 34896
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_19 34897
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_20 34898
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_21 34899
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_22 34900
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_23 34901
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_24 34902
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_25 34903
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_26 34904
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_27 34905
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_28 34906
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_29 34907
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_30 34908
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_31 34909
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_32 34910
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_33 34911
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_34 34912
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_35 34913
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_36 34914
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_37 34915
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_38 34916
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_39 34917
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_40 34918
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_41 34919
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_42 34920
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_43 34921
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_44 34922
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_45 34923
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_46 34924
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_47 34925
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_48 34926
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_49 34927
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_50 34928
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_51 34929
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_52 34930
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_53 34931
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_54 34932
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_55 34933
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_56 34934
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_57 34935
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_58 34936
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_59 34937
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_60 34938
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_61 34939
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_62 34940
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_63 34941
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_64 34942
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_65 34943
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_66 34944
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_67 34945
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_68 34946
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_69 34947
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_70 34948
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_71 34949
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_72 34950
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_73 34951
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_74 34952
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_75 34953
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_76 34954
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_77 34955
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_78 34956
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_79 34957
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_80 34958
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_81 34959
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_82 34960
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_83 34961
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_84 34962
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_85 34963
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_86 34964
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_87 34965
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_88 34966
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_89 34967
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_90 34968
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_91 34969
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_92 34970
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_93 34971
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_94 34972
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_95 34973
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_96 34974
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_97 34975
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_98 34976
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_99 34977
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_100 34978
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_101 34979
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_102 34980
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_103 34981
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_104 34982
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_105 34983
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_106 34984
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_107 34985
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_108 34986
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_109 34987
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_110 34988
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_111 34989
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_112 34990
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_113 34991
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_114 34992
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_115 34993
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_116 34994
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_117 34995
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_118 34996
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_119 34997
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_120 34998
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_121 34999
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_122 35000
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_123 35001
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_124 35002
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_125 35003
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_126 35004
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_127 35005
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_128 35006
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_129 35007
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_130 35008
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_131 35009
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_132 35010
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_133 35011
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_134 35012
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_135 35013
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_136 35014
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_137 35015
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_138 35016
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_139 35017
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_140 35018
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_141 35019
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_142 35020
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_143 35021
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_144 35022
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_145 35023
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_146 35024
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_147 35025
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_148 35026
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_149 35027
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_150 35028
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_151 35029
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_152 35030
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_153 35031
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_154 35032
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_155 35033
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_156 35034
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_157 35035
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_158 35036
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_159 35037
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_160 35038
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_161 35039
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_162 35040
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_163 35041
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_164 35042
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_165 35043
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_166 35044
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_167 35045
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_168 35046
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_169 35047
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_170 35048
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_171 35049
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_172 35050
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_173 35051
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_174 35052
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_175 35053
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_176 35054
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_177 35055
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_178 35056
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_179 35057
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_180 35058
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_181 35059
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_182 35060
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_183 35061
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_184 35062
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_185 35063
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_186 35064
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_187 35065
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_188 35066
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_189 35067
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_190 35068
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_191 35069
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_192 35070
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_193 35071
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_194 35072
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_195 35073
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_196 35074
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_197 35075
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_198 35076
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_199 35077
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_200 35078
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_201 35079
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_202 35080
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_203 35081
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_204 35082
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_205 35083
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_206 35084
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_207 35085
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_208 35086
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_209 35087
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_210 35088
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_211 35089
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_212 35090
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_213 35091
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_214 35092
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_215 35093
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_216 35094
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_217 35095
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_218 35096
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_219 35097
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_220 35098
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_221 35099
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_222 35100
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_223 35101
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_224 35102
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_225 35103
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_226 35104
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_227 35105
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_228 35106
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_229 35107
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_230 35108
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_231 35109
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_232 35110
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_233 35111
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_234 35112
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_235 35113
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_236 35114
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_237 35115
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_238 35116
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_239 35117
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_240 35118
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_241 35119
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_242 35120
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_243 35121
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_244 35122
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_245 35123
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_246 35124
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_247 35125
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_248 35126
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_249 35127
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_250 35128
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_251 35129
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_252 35130
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_253 35131
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_254 35132
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_255 35133
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_256 35134
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_257 35135
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_258 35136
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_259 35137
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_260 35138
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_261 35139
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_262 35140
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_263 35141
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_264 35142
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_265 35143
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_266 35144
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_267 35145
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_268 35146
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_269 35147
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_270 35148
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_271 35149
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_272 35150
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_273 35151
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_274 35152
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_275 35153
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_276 35154
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_277 35155
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_278 35156
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_279 35157
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_280 35158
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_281 35159
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_282 35160
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_283 35161
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_284 35162
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_285 35163
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_286 35164
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_287 35165
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_288 35166
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_289 35167
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_290 35168
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_291 35169
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_292 35170
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_293 35171
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_294 35172
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_295 35173
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_296 35174
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_297 35175
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_298 35176
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_299 35177
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_300 35178
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_301 35179
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_302 35180
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_303 35181
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_304 35182
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_305 35183
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_306 35184
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_307 35185
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_308 35186
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_309 35187
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_310 35188
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_311 35189
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_312 35190
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_313 35191
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_314 35192
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_315 35193
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_316 35194
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_317 35195
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_318 35196
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_319 35197
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_320 35198
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_321 35199
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_322 35200
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_323 35201
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_324 35202
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_325 35203
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_326 35204
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_327 35205
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_328 35206
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_329 35207
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_330 35208
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_331 35209
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_332 35210
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_333 35211
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_334 35212
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_335 35213
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_336 35214
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_337 35215
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_338 35216
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_339 35217
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_340 35218
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_341 35219
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_342 35220
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_343 35221
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_344 35222
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_345 35223
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_346 35224
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_347 35225
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_348 35226
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_349 35227
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_350 35228
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_351 35229
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_352 35230
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_353 35231
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_354 35232
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_355 35233
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_356 35234
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_357 35235
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_358 35236
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_359 35237
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_360 35238
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_361 35239
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_362 35240
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_363 35241
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_364 35242
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_365 35243
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_366 35244
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_367 35245
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_368 35246
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_369 35247
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_370 35248
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_371 35249
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_372 35250
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_373 35251
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_374 35252
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_375 35253
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_376 35254
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_377 35255
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_378 35256
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_379 35257
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_380 35258
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_381 35259
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_382 35260
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_383 35261
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_384 35262
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_385 35263
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_386 35264
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_387 35265
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_388 35266
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_389 35267
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_390 35268
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_391 35269
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_392 35270
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_393 35271
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_394 35272
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_395 35273
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_396 35274
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_397 35275
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_398 35276
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_399 35277
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_400 35278
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_401 35279
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_402 35280
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_403 35281
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_404 35282
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_405 35283
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_406 35284
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_407 35285
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_408 35286
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_409 35287
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_410 35288
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_411 35289
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_412 35290
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_413 35291
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_414 35292
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_415 35293
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_416 35294
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_417 35295
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_418 35296
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_419 35297
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_420 35298
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_421 35299
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_422 35300
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_423 35301
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_424 35302
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_425 35303
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_426 35304
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_427 35305
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_428 35306
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_429 35307
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_430 35308
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_431 35309
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_432 35310
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_433 35311
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_434 35312
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_435 35313
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_436 35314
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_437 35315
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_438 35316
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_439 35317
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_440 35318
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_441 35319
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_442 35320
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_443 35321
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_444 35322
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_445 35323
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_446 35324
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_447 35325
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_448 35326
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_449 35327
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_450 35328
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_451 35329
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_452 35330
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_453 35331
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_454 35332
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_455 35333
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_456 35334
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_457 35335
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_458 35336
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_459 35337
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_460 35338
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_461 35339
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_462 35340
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_463 35341
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_464 35342
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_465 35343
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_466 35344
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_467 35345
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_468 35346
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_469 35347
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_470 35348
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_471 35349
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_472 35350
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_473 35351
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_474 35352
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_475 35353
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_476 35354
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_477 35355
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_478 35356
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_479 35357
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_480 35358
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_481 35359
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_482 35360
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_483 35361
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_484 35362
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_485 35363
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_486 35364
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_487 35365
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_488 35366
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_489 35367
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_490 35368
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_491 35369
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_492 35370
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_493 35371
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_494 35372
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_495 35373
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_496 35374
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_497 35375
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_498 35376
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_499 35377
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_500 35378
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_501 35379
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_502 35380
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_503 35381
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_504 35382
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_505 35383
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_506 35384
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_507 35385
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_508 35386
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_509 35387
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_510 35388
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_511 35389
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_512 35390
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_513 35391
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_514 35392
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_515 35393
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_516 35394
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_517 35395
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_518 35396
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_519 35397
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_520 35398
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_521 35399
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_522 35400
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_523 35401
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_524 35402
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_525 35403
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_526 35404
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_527 35405
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_528 35406
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_529 35407
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_530 35408
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_531 35409
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_532 35410
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_533 35411
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_534 35412
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_535 35413
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_536 35414
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_537 35415
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_538 35416
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_539 35417
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_540 35418
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_541 35419
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_542 35420
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_543 35421
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_544 35422
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_545 35423
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_546 35424
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_547 35425
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_548 35426
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_549 35427
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_550 35428
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_551 35429
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_552 35430
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_553 35431
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_554 35432
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_555 35433
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_556 35434
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_557 35435
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_558 35436
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_559 35437
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_560 35438
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_561 35439
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_562 35440
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_563 35441
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_564 35442
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_565 35443
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_566 35444
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_567 35445
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_568 35446
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_569 35447
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_570 35448
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_571 35449
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_572 35450
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_573 35451
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_574 35452
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_575 35453
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_576 35454
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_577 35455
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_578 35456
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_579 35457
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_580 35458
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_581 35459
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_582 35460
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_583 35461
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_584 35462
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_585 35463
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_586 35464
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_587 35465
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_588 35466
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_589 35467
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_590 35468
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_591 35469
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_592 35470
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_593 35471
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_594 35472
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_595 35473
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_596 35474
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_597 35475
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_598 35476
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_599 35477
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_600 35478
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_601 35479
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_602 35480
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_603 35481
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_604 35482
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_605 35483
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_606 35484
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_607 35485
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_608 35486
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_609 35487
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_610 35488
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_611 35489
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_612 35490
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_613 35491
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_614 35492
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_615 35493
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_616 35494
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_617 35495
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_618 35496
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_619 35497
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_620 35498
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_621 35499
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_622 35500
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_623 35501
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_624 35502
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_625 35503
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_626 35504
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_627 35505
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_628 35506
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V2_TOPIC_ID_629 35507
#define IDS_REGISTER_PROTOCOL_HANDLER_TOOLTIP 441
#define IDS_REGISTER_PROTOCOL_HANDLER_MAILTO_NAME 35508
#define IDS_REGISTER_PROTOCOL_HANDLER_WEBCAL_NAME 35509
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM 35510
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE 35511
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_FRAGMENT 35512
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE_FRAGMENT 35513
#define IDS_REGISTER_PROTOCOL_HANDLER_ACCEPT 35514
#define IDS_REGISTER_PROTOCOL_HANDLER_DENY 35515
#define IDS_REGISTER_PROTOCOL_HANDLER_IGNORE 35516
#define IDS_RESET_PASSWORD_TITLE 35517
#define IDS_RESET_PASSWORD_WARNING_HEADING 35518
#define IDS_RESET_PASSWORD_HEADING 35519
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH 35520
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 35521
#define IDS_RESET_PASSWORD_BUTTON 35522
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH 35523
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 35524
#define IDS_SSL_OPEN_DETAILS_BUTTON 35525
#define IDS_SSL_CLOSE_DETAILS_BUTTON 35526
#define IDS_CAPTIVE_PORTAL_AUTHORIZATION_DIALOG_NAME 35527
#define IDS_CAPTIVE_PORTAL_HEADING_WIRED 35528
#define IDS_CAPTIVE_PORTAL_HEADING_WIFI 35529
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIRED 35530
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI 35531
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI_SSID 35532
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIRED 35533
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI 35534
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI_SSID 35535
#define IDS_CAPTIVE_PORTAL_BUTTON_OPEN_LOGIN_PAGE 35536
#define IDS_MITM_SOFTWARE_HEADING 35537
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_ENTERPRISE 35538
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_NONENTERPRISE 35539
#define IDS_MITM_SOFTWARE_EXPLANATION_ENTERPRISE 35540
#define IDS_MITM_SOFTWARE_EXPLANATION_NONENTERPRISE 35541
#define IDS_MITM_SOFTWARE_EXPLANATION 35542
#define IDS_LOOKALIKE_URL_TITLE 35543
#define IDS_LOOKALIKE_URL_HEADING 35544
#define IDS_LOOKALIKE_URL_IGNORE 35545
#define IDS_LOOKALIKE_URL_CONTINUE 35546
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH 35547
#define IDS_LOOKALIKE_URL_HEADING_NO_SUGGESTED_URL 35548
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH_NO_SUGGESTED_URL 35549
#define IDS_LOOKALIKE_URL_BACK_TO_SAFETY 35550
#define IDS_LOOKALIKE_URL_CLOSE_PAGE 35551
#define IDS_ENTERPRISE_BLOCK_TITLE 35552
#define IDS_ENTERPRISE_BLOCK_HEADING 35553
#define IDS_ENTERPRISE_BLOCK_PRIMARY_PARAGRAPH 35554
#define IDS_ENTERPRISE_BLOCK_GO_BACK 35555
#define IDS_ENTERPRISE_WARN_TITLE 35556
#define IDS_ENTERPRISE_WARN_HEADING 35557
#define IDS_ENTERPRISE_WARN_PRIMARY_PARAGRAPH 35558
#define IDS_ENTERPRISE_WARN_GO_BACK 35559
#define IDS_ENTERPRISE_WARN_CONTINUE_TO_SITE 35560
#define IDS_ENTERPRISE_INTERSTITIALS_LEARN_MORE_ACCCESSIBILITY_TEXT 35561
#define IDS_CLOCK_ERROR_TITLE 35562
#define IDS_CLOCK_ERROR_AHEAD_HEADING 35563
#define IDS_CLOCK_ERROR_BEHIND_HEADING 35564
#define IDS_CLOCK_ERROR_UPDATE_DATE_AND_TIME 35565
#define IDS_CLOCK_ERROR_PRIMARY_PARAGRAPH 35566
#define IDS_CLOCK_ERROR_EXPLANATION 35567
#define IDS_SSL_V2_TITLE 35568
#define IDS_SSL_V2_HEADING 35569
#define IDS_SSL_V2_PRIMARY_PARAGRAPH 35570
#define IDS_SSL_V2_RECURRENT_ERROR_PARAGRAPH 35571
#define IDS_SSL_OVERRIDABLE_SAFETY_BUTTON 35572
#define IDS_SSL_OVERRIDABLE_CLOSE_PAGE_BUTTON 35573
#define IDS_SSL_OVERRIDABLE_PROCEED_PARAGRAPH 35574
#define IDS_SSL_RELOAD 35575
#define IDS_SSL_NONOVERRIDABLE_PINNED 35576
#define IDS_SSL_NONOVERRIDABLE_HSTS 35577
#define IDS_SSL_NONOVERRIDABLE_REVOKED 35578
#define IDS_SSL_NONOVERRIDABLE_MORE 35579
#define IDS_SSL_NONOVERRIDABLE_INVALID 35580
#define IDS_SAFEBROWSING_V3_TITLE 35581
#define IDS_SAFEBROWSING_V3_OPEN_DETAILS_BUTTON 35582
#define IDS_SAFEBROWSING_V3_CLOSE_DETAILS_BUTTON 35583
#define IDS_SAFEBROWSING_OVERRIDABLE_SAFETY_BUTTON 35584
#define IDS_MALWARE_V3_HEADING 35585
#define IDS_MALWARE_V3_PRIMARY_PARAGRAPH 35586
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH 35587
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH_SUBRESOURCE 35588
#define IDS_MALWARE_V3_PROCEED_PARAGRAPH 35589
#define IDS_SAFE_BROWSING_SCOUT_REPORTING_AGREE 35590
#define IDS_SAFE_BROWSING_ENHANCED_PROTECTION_MESSAGE 35591
#define IDS_HARMFUL_V3_HEADING 35592
#define IDS_HARMFUL_V3_PRIMARY_PARAGRAPH 35593
#define IDS_HARMFUL_V3_EXPLANATION_PARAGRAPH 35594
#define IDS_HARMFUL_V3_PROCEED_PARAGRAPH 35595
#define IDS_PHISHING_V4_HEADING 35596
#define IDS_PHISHING_V4_PRIMARY_PARAGRAPH 35597
#define IDS_PHISHING_V4_EXPLANATION_PARAGRAPH 35598
#define IDS_PHISHING_V4_PROCEED_AND_REPORT_PARAGRAPH 35599
#define IDS_MALWARE_WEBVIEW_HEADING 35600
#define IDS_MALWARE_WEBVIEW_EXPLANATION_PARAGRAPH 35601
#define IDS_PHISHING_WEBVIEW_HEADING 35602
#define IDS_PHISHING_WEBVIEW_EXPLANATION_PARAGRAPH 35603
#define IDS_HARMFUL_WEBVIEW_HEADING 35604
#define IDS_HARMFUL_WEBVIEW_EXPLANATION_PARAGRAPH 35605
#define IDS_BILLING_WEBVIEW_HEADING 35606
#define IDS_BILLING_WEBVIEW_EXPLANATION_PARAGRAPH 35607
#define IDS_CONNECTION_HELP_SHOW_MORE 35608
#define IDS_CONNECTION_HELP_SHOW_LESS 35609
#define IDS_CONNECTION_HELP_TITLE 35610
#define IDS_CONNECTION_HELP_HEADING 35611
#define IDS_CONNECTION_HELP_GENERAL_HELP 35612
#define IDS_CONNECTION_HELP_SPECIFIC_ERROR_HEADING 35613
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_TITLE 35614
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_TITLE 35615
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_TITLE 35616
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_DETAILS 35617
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_DETAILS 35618
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_DETAILS 35619
#define IDS_CONNECTION_HELP_MITM_SOFTWARE_TITLE 35620
#define IDS_CONNECTION_HELP_MITM_SOFTWARE_DETAILS 35621
#define IDS_BILLING_TITLE 35622
#define IDS_BILLING_HEADING 35623
#define IDS_BILLING_PRIMARY_PARAGRAPH 35624
#define IDS_BILLING_PRIMARY_BUTTON 35625
#define IDS_BILLING_PROCEED_BUTTON 35626
#define IDS_BLOCKED_INTERCEPTION_HEADING 35627
#define IDS_KNOWN_INTERCEPTION_TITLE 35628
#define IDS_KNOWN_INTERCEPTION_HEADER 35629
#define IDS_KNOWN_INTERCEPTION_BODY1 35630
#define IDS_KNOWN_INTERCEPTION_BODY2 35631
#define IDS_KNOWN_INTERCEPTION_INFOBAR_HEADING 35632
#define IDS_KNOWN_INTERCEPTION_INFOBAR_BUTTON_TEXT 35633
#define IDS_LEGACY_TLS_HEADING 35634
#define IDS_LEGACY_TLS_PRIMARY_PARAGRAPH 35635
#define IDS_LEGACY_TLS_EXPLANATION 35636
#define IDS_INSECURE_FORM_TITLE 35637
#define IDS_INSECURE_FORM_HEADING 35638
#define IDS_INSECURE_FORM_PRIMARY_PARAGRAPH 35639
#define IDS_INSECURE_FORM_BACK_BUTTON 35640
#define IDS_INSECURE_FORM_SUBMIT_BUTTON 35641
#define IDS_HTTPS_ONLY_MODE_TITLE 35642
#define IDS_HTTPS_ONLY_MODE_HEADING 35643
#define IDS_HTTPS_ONLY_MODE_PRIMARY_PARAGRAPH 35644
#define IDS_HTTPS_ONLY_MODE_WITH_ADVANCED_PROTECTION_PRIMARY_PARAGRAPH 35645
#define IDS_HTTPS_ONLY_MODE_WITH_SITE_ENGAGEMENT_PRIMARY_PARAGRAPH 35646
#define IDS_HTTPS_ONLY_MODE_FOR_TYPICALLY_SECURE_BROWSING_PRIMARY_PARAGRAPH 35647
#define IDS_HTTPS_ONLY_MODE_BACK_BUTTON 35648
#define IDS_HTTPS_ONLY_MODE_SUBMIT_BUTTON 35649
#define IDS_SHARING_DEVICE_TYPE_COMPUTER 35650
#define IDS_SHARING_DEVICE_TYPE_DEVICE 35651
#define IDS_SHARING_DEVICE_TYPE_PHONE 35652
#define IDS_SHARING_DEVICE_TYPE_TABLET 35653
#define IDS_SITE_SETTINGS_TYPE_ADS 35654
#define IDS_SITE_SETTINGS_TYPE_ADS_MID_SENTENCE 35655
#define IDS_SITE_SETTINGS_TYPE_ANTI_ABUSE 35656
#define IDS_SITE_SETTINGS_TYPE_AR 35657
#define IDS_SITE_SETTINGS_TYPE_AR_MID_SENTENCE 35658
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS 35659
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS_MID_SENTENCE 35660
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC 35661
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC_MID_SENTENCE 35662
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES 35663
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES_MID_SENTENCE 35664
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING 35665
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING_MID_SENTENCE 35666
#define IDS_SITE_SETTINGS_TYPE_CAMERA 35667
#define IDS_SITE_SETTINGS_TYPE_CAMERA_MID_SENTENCE 35668
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM 35669
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_MID_SENTENCE 35670
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD 35671
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD_MID_SENTENCE 35672
#define IDS_SITE_SETTINGS_TYPE_COOKIES 35673
#define IDS_SITE_SETTINGS_TYPE_COOKIES_MID_SENTENCE 35674
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API 35675
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API_MID_SENTENCE 35676
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION 35677
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION_MID_SENTENCE 35678
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT 35679
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_MID_SENTENCE 35680
#define IDS_SITE_SETTINGS_TYPE_LOCATION 35681
#define IDS_SITE_SETTINGS_TYPE_LOCATION_MID_SENTENCE 35682
#define IDS_SITE_SETTINGS_TYPE_MIC 35683
#define IDS_SITE_SETTINGS_TYPE_MIC_MID_SENTENCE 35684
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX 35685
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX_MID_SENTENCE 35686
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS 35687
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS_MID_SENTENCE 35688
#define IDS_SITE_SETTINGS_TYPE_NFC 35689
#define IDS_SITE_SETTINGS_TYPE_NFC_MID_SENTENCE 35690
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS 35691
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS_MID_SENTENCE 35692
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS 35693
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS_MID_SENTENCE 35694
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID 35695
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID_MID_SENTENCE 35696
#define IDS_SITE_SETTINGS_TYPE_SENSORS 35697
#define IDS_SITE_SETTINGS_TYPE_SENSORS_MID_SENTENCE 35698
#define IDS_SITE_SETTINGS_TYPE_SOUND 35699
#define IDS_SITE_SETTINGS_TYPE_SOUND_MID_SENTENCE 35700
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES 35701
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES_MID_SENTENCE 35702
#define IDS_SITE_SETTINGS_TYPE_VR 35703
#define IDS_SITE_SETTINGS_TYPE_VR_MID_SENTENCE 35704
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE 35705
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE_MID_SENTENCE 35706
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS 35707
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS_MID_SENTENCE 35708
#define IDS_SITE_SETTINGS_TYPE_HANDLERS 35709
#define IDS_SITE_SETTINGS_TYPE_HANDLERS_MID_SENTENCE 35710
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES 35711
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES_MID_SENTENCE 35712
#define IDS_SITE_SETTINGS_TYPE_IMAGES 35713
#define IDS_SITE_SETTINGS_TYPE_IMAGES_MID_SENTENCE 35714
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT 35715
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT_MID_SENTENCE 35716
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER 35717
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER_MID_SENTENCE 35718
#define IDS_SITE_SETTINGS_TYPE_PDF_DOCUMENTS 35719
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS 35720
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS_MID_SENTENCE 35721
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS 35722
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS_MID_SENTENCE 35723
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT 35724
#define IDS_SITE_SETTINGS_TYPE_WINDOW_MANAGEMENT_MID_SENTENCE 35725
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS 35726
#define IDS_SITE_SETTINGS_TYPE_STORAGE_ACCESS_MID_SENTENCE 35727
#define IDS_SMS_INFOBAR_TITLE 35728
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED 35729
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED_FROM_EMBEDDED_FRAME 35730
#define IDS_SMS_INFOBAR_BUTTON_OK 35731
#define IDS_CERT_ERROR_NO_SUBJECT_ALTERNATIVE_NAMES_DETAILS 35732
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DETAILS 35733
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DESCRIPTION 35734
#define IDS_CERT_ERROR_EXPIRED_DETAILS 35735
#define IDS_CERT_ERROR_EXPIRED_DESCRIPTION 35736
#define IDS_CERT_ERROR_NOT_YET_VALID_DETAILS 35737
#define IDS_CERT_ERROR_NOT_YET_VALID_DESCRIPTION 35738
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DETAILS 35739
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DESCRIPTION 35740
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DESCRIPTION 35741
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DETAILS 35742
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DESCRIPTION 35743
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DETAILS 35744
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DESCRIPTION 35745
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DETAILS 35746
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DESCRIPTION 35747
#define IDS_CERT_ERROR_REVOKED_CERT_DETAILS 35748
#define IDS_CERT_ERROR_REVOKED_CERT_DESCRIPTION 35749
#define IDS_CERT_ERROR_INVALID_CERT_DETAILS 35750
#define IDS_CERT_ERROR_INVALID_CERT_DESCRIPTION 35751
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DETAILS 35752
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DESCRIPTION 35753
#define IDS_CERT_ERROR_WEAK_KEY_DETAILS 35754
#define IDS_CERT_ERROR_WEAK_KEY_DESCRIPTION 35755
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DETAILS 35756
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DESCRIPTION 35757
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DETAILS 35758
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DESCRIPTION 35759
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DETAILS 35760
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DESCRIPTION 35761
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DETAILS 35762
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DESCRIPTION 35763
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DETAILS 35764
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DESCRIPTION 35765
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DETAILS 35766
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DESCRIPTION 35767
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DETAILS 35768
#define IDS_ALWAYS_ALLOW_ADS 35769
#define IDS_BLOCKED_ADS_PROMPT_TITLE 35770
#define IDS_BLOCKED_ADS_PROMPT_EXPLANATION 35771
#define IDS_BLOCK_INTERSTITIAL_TITLE 35778
#define IDS_CHILD_BLOCK_INTERSTITIAL_HEADER 35779
#define IDS_BLOCK_INTERSTITIAL_HEADER_ACCESS_REQUESTS_DISABLED 35780
#define IDS_BLOCK_INTERSTITIAL_HEADER_NOT_SIGNED_IN 35781
#define IDS_CHILD_BLOCK_INTERSTITIAL_MESSAGE_V2 35782
#define IDS_REQUEST_SENT_OK 35783
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_BUTTON 35784
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_PERSON_INSTEAD_BUTTON 35785
#define IDS_BLOCK_INTERSTITIAL_ASK_IN_A_MESSAGE_BUTTON 35786
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_MESSAGE 35787
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_SINGLE_PARENT 35788
#define IDS_CHILD_BLOCK_INTERSTITIAL_WAITING_APPROVAL_DESCRIPTION_MULTI_PARENT 35789
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_SINGLE_PARENT 35790
#define IDS_CHILD_BLOCK_INTERSTITIAL_REQUEST_FAILED_MESSAGE_MULTI_PARENT 35791
#define IDS_BLOCK_INTERSTITIAL_SHOW_DETAILS 35792
#define IDS_BLOCK_INTERSTITIAL_HIDE_DETAILS 35793
#define IDS_GENERIC_SITE_BLOCK_HEADER 35794
#define IDS_SUPERVISED_USER_BLOCK_HEADER 35795
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_SINGLE_PARENT 35796
#define IDS_CHILD_BLOCK_MESSAGE_DEFAULT_MULTI_PARENT 35797
#define IDS_SUPERVISED_USER_BLOCK_MESSAGE_SAFE_SITES 35798
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_SINGLE_PARENT 35799
#define IDS_CHILD_BLOCK_MESSAGE_MANUAL_MULTI_PARENT 35800
#define IDS_SUPERVISED_USER_NOT_SIGNED_IN 35801
#define IDS_PARENT_BLOCKED_SITE_BANNER_TITLE 35802
#define IDS_PARENT_BLOCKED_SITE_BANNER_MESSAGE 35803
#define IDS_SYNC_BASIC_ENCRYPTION_DATA 35804
#define IDS_SYNC_DATATYPE_AUTOFILL 35805
#define IDS_SYNC_DATATYPE_BOOKMARKS 35806
#define IDS_SYNC_DATATYPE_PASSWORDS 35807
#define IDS_SYNC_DATATYPE_PREFERENCES 35808
#define IDS_SYNC_DATATYPE_TABS 35809
#define IDS_SYNC_DATATYPE_TYPED_URLS 35810
#define IDS_SYNC_DATATYPE_HISTORY_AND_TABS 35811
#define IDS_SYNC_DATATYPE_READING_LIST 35812
#define IDS_SYNC_EMPTY_PASSPHRASE_ERROR 35813
#define IDS_SYNC_ENCRYPTION_SECTION_TITLE 35814
#define IDS_SYNC_FULL_ENCRYPTION_DATA 35815
#define IDS_SYNC_LOGIN_SETTING_UP 35816
#define IDS_SYNC_PASSPHRASE_LABEL 35817
#define IDS_SYNC_PASSPHRASE_MISMATCH_ERROR 35818
#define IDS_SYNC_ENTER_PASSPHRASE_BODY_WITH_DATE 35819
#define IDS_SYNC_ENTER_PASSPHRASE_BODY 35820
#define IDS_TRANSLATE_INFOBAR_OPTIONS_MORE_LANGUAGE 35821
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NOT_SOURCE_LANGUAGE 35822
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NEVER_TRANSLATE_LANG 35823
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NEVER_TRANSLATE_SITE 35824
#define IDS_TRANSLATE_INFOBAR_OPTIONS_ALWAYS 35825
#define IDS_TRANSLATE_INFOBAR_OPTIONS_REPORT_ERROR 35826
#define IDS_TRANSLATE_INFOBAR_OPTIONS_ABOUT 35827
#define IDS_TRANSLATE_INFOBAR_ACCEPT 35829
#define IDS_TRANSLATE_INFOBAR_DENY 35830
#define IDS_TRANSLATE_INFOBAR_NEVER_TRANSLATE 35831
#define IDS_TRANSLATE_INFOBAR_ALWAYS_TRANSLATE 35832
#define IDS_TRANSLATE_INFOBAR_AFTER_MESSAGE 35833
#define IDS_TRANSLATE_INFOBAR_AFTER_MESSAGE_AUTODETERMINED_SOURCE_LANGUAGE 35834
#define IDS_TRANSLATE_INFOBAR_REVERT 35835
#define IDS_TRANSLATE_INFOBAR_RETRY 35836
#define IDS_TRANSLATE_NOTIFICATION_ERROR 35860
#define IDS_TRANSLATE_NOTIFICATION_ALWAYS_TRANSLATE 35861
#define IDS_TRANSLATE_NOTIFICATION_LANGUAGE_NEVER 35862
#define IDS_TRANSLATE_NOTIFICATION_SITE_NEVER 35863
#define IDS_TRANSLATE_NOTIFICATION_UNDO 35864
#define IDS_TRANSLATE_DETECTED_LANGUAGE 35865
#define IDS_TAB_GROUP_COLOR_GREY 35866
#define IDS_TAB_GROUP_COLOR_BLUE 35867
#define IDS_TAB_GROUP_COLOR_RED 35868
#define IDS_TAB_GROUP_COLOR_YELLOW 35869
#define IDS_TAB_GROUP_COLOR_GREEN 35870
#define IDS_TAB_GROUP_COLOR_PINK 35871
#define IDS_TAB_GROUP_COLOR_PURPLE 35872
#define IDS_TAB_GROUP_COLOR_CYAN 35873
#define IDS_TAB_GROUP_COLOR_ORANGE 35874
#define IDS_BOOKMARK_BAR_UNDO 35875
#define IDS_BOOKMARK_BAR_REDO 35876
#define IDS_BOOKMARK_BAR_UNDO_ADD 35877
#define IDS_BOOKMARK_BAR_REDO_ADD 35878
#define IDS_BOOKMARK_BAR_UNDO_DELETE 35879
#define IDS_BOOKMARK_BAR_REDO_DELETE 35880
#define IDS_BOOKMARK_BAR_UNDO_EDIT 35881
#define IDS_BOOKMARK_BAR_REDO_EDIT 35882
#define IDS_BOOKMARK_BAR_UNDO_MOVE 35883
#define IDS_BOOKMARK_BAR_REDO_MOVE 35884
#define IDS_BOOKMARK_BAR_UNDO_REORDER 35885
#define IDS_BOOKMARK_BAR_REDO_REORDER 35886
#define IDS_CLOSE_TUTORIAL 35887
#define IDS_CLOSE_PROMO 35888
#define IDS_PROMO_DISMISS_BUTTON 35889
#define IDS_PROMO_SNOOZE_BUTTON 35890
#define IDS_PROMO_SHOW_TUTORIAL_BUTTON 385
#define IDS_TUTORIAL_RESTART_TUTORIAL 35891
#define IDS_TUTORIAL_CLOSE_TUTORIAL 35892
#define IDS_TUTORIAL_NEXT_BUTTON 35893
#define IDS_VERSION_UI_TITLE 35894
#define IDS_VERSION_UI_OFFICIAL 35895
#define IDS_VERSION_UI_UNOFFICIAL 35896
#define IDS_VERSION_UI_32BIT 35897
#define IDS_VERSION_UI_64BIT 35898
#define IDS_VERSION_UI_64BIT_ARM 35901
#define IDS_VERSION_UI_32BIT_TRANSLATED_INTEL 35902
#define IDS_VERSION_UI_64BIT_TRANSLATED_INTEL 35900
#define IDS_VERSION_UI_REVISION 35903
#define IDS_VERSION_UI_OS 35904
#define IDS_VERSION_UI_USER_AGENT 35906
#define IDS_VERSION_UI_COMMAND_LINE 35907
#define IDS_VERSION_UI_COPY_LABEL 35911
#define IDS_VERSION_UI_EXECUTABLE_PATH 35912
#define IDS_VERSION_UI_PROFILE_PATH 35913
#define IDS_VERSION_UI_PATH_NOTFOUND 35914
#define IDS_VERSION_UI_VARIATIONS 35915
#define IDS_VERSION_UI_VARIATIONS_SEED_NAME 35916
#define IDS_VERSION_UI_VARIATIONS_CMD 35917
#define IDS_VERSION_UI_COHORT_NAME 35918
#define IDS_HISTORY_CLUSTERS_ACTION_MENU_DESCRIPTION 35925
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 35926
#define IDS_HISTORY_CLUSTERS_DELETE_PRIOR_VISITS_WARNING 35927
#define IDS_HISTORY_CLUSTERS_DISABLE_MENU_ITEM_LABEL 35928
#define IDS_HISTORY_CLUSTERS_ENABLE_MENU_ITEM_LABEL 35929
#define IDS_HISTORY_CLUSTERS_JOURNEYS_TAB_LABEL 397
#define IDS_HISTORY_CLUSTERS_BY_GROUP_TAB_LABEL 35930
#define IDS_HISTORY_CLUSTERS_LIST_TAB_LABEL 35931
#define IDS_HISTORY_CLUSTERS_BY_DATE_TAB_LABEL 35932
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_SEARCH_TERMS 35933
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_MULTIPLE_HOSTNAMES 35934
#define IDS_HISTORY_CLUSTERS_HIDE_PAGE 35935
#define IDS_HISTORY_CLUSTERS_HIDE_VISITS 35936
#define IDS_HISTORY_CLUSTERS_LOAD_MORE_BUTTON_LABEL 35937
#define IDS_HISTORY_CLUSTERS_NO_RESULTS 35938
#define IDS_HISTORY_CLUSTERS_NO_SEARCH_RESULTS 35939
#define IDS_HISTORY_CLUSTERS_OPEN_ALL_IN_TABGROUP 35940
#define IDS_HISTORY_CLUSTERS_OPEN_INCOGNITO 35941
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_TAB 35942
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_WINDOW 35943
#define IDS_HISTORY_CLUSTERS_RELATED_SEARCHES_HEADER 35944
#define IDS_HISTORY_CLUSTERS_REMOVE_ALL_ITEMS 35945
#define IDS_HISTORY_CLUSTERS_REMOVE_PAGE 35946
#define IDS_HISTORY_CLUSTERS_REMOVE_ITEM_TOAST 35947
#define IDS_HISTORY_CLUSTERS_REMOVE_SELECTED_ITEMS 35948
#define IDS_HISTORY_CLUSTERS_SAVED_IN_TABGROUP_LABEL 35949
#define IDS_HISTORY_CLUSTERS_SEARCH_PROMPT 35950
#define IDS_HISTORY_CLUSTERS_CUT 35951
#define IDS_HISTORY_CLUSTERS_COPY 35952
#define IDS_HISTORY_CLUSTERS_PASTE 35953
#define IDS_HISTORY_CLUSTERS_COPY_LINK 35954
#define IDS_HISTORY_CLUSTERS_SHOW_LESS_BUTTON_LABEL 35955
#define IDS_HISTORY_CLUSTERS_SHOW_MORE_BUTTON_LABEL 35956
#define IDS_HISTORY_CLUSTERS_SEARCH_YOUR_JOURNEYS 35957
#define IDS_HISTORY_CLUSTERS_N_MATCHES 35958
#define IDS_CANCEL 505
#define IDS_CLOSE 35973
#define IDS_CLEAR 35974
#define IDS_DONE 483
#define IDS_LEARN_MORE 423
#define IDS_OK 571
#define IDS_RELOAD 35975
#define IDS_ADD 35976
#define IDS_REMOVE 35977
#define IDS_SAVE 35978
#define IDS_MENU 35979
#define IDS_INSTALL 35980
#define IDS_UPDATE 35981
#define IDS_NO_THANKS 35984
#define IDS_NOT_NOW 35985
#define IDS_TURN_OFF 35986
#define IDS_PLUGIN_NOT_SUPPORTED 35987
#define IDS_PRINT 35988
#define IDS_RECENT_TABS 35989
#define IDS_RECENTLY_CLOSED 35990
#define IDS_YOUR_DEVICES 35991
#define IDS_CHOOSE 35992
#define IDS_ACCNAME_BACK 410
#define IDS_ACCNAME_FORWARD 413
#define IDS_ACCNAME_OK 35993
#define IDS_ACCNAME_CANCEL 35994
#define IDS_ACCNAME_DONE 35995
#define IDS_ACCNAME_SAVE 35996
#define IDS_ACCNAME_CLOSE 674
#define IDS_ACCNAME_OPEN 35997
#define IDS_ACCNAME_OPEN_IN_NEW_TAB 35998
#define IDS_ACCNAME_PREVIOUS 35999
#define IDS_ACCNAME_NEXT 36000
#define IDS_ACCNAME_LOCATION 473
#define IDS_ACCNAME_TAB_LIST 36001
#define IDS_UTILITY_PROCESS_JSON_PARSER_NAME 36002
#define IDS_SESSION_CRASHED_VIEW_RESTORE_BUTTON 36003
#define IDS_SESSION_CRASHED_VIEW_STARTUP_PAGES_BUTTON 36004
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_PRIVACY 36005
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_SAFETY_CHECK 36006
#define IDS_PATCH_SERVICE_DISPLAY_NAME 36007
#define IDS_PASSWORD_MANAGER_CSV_PASSWORD_PARSER_SERVICE_DISPLAY_NAME 36008
#define IDS_UNZIP_SERVICE_DISPLAY_NAME 36009

// ---------------------------------------------------------------------------
// From extensions_strings.h:

#define IDS_EXTENSION_BAD_FILE_ENCODING 41090
#define IDS_EXTENSION_CANT_GET_ABSOLUTE_PATH 41091
#define IDS_EXTENSION_CONTAINS_PRIVATE_KEY 41092
#define IDS_EXTENSION_CRX_EXISTS 41093
#define IDS_EXTENSION_CONTENT_SCRIPT_FILE_TOO_LARGE 41094
#define IDS_EXTENSION_DIRECTORY_NO_EXISTS 41095
#define IDS_EXTENSION_ERROR_WHILE_SIGNING 41096
#define IDS_EXTENSION_FAILED_DURING_PACKAGING 41097
#define IDS_EXTENSION_LOAD_ABOUT_PAGE_FAILED 41098
#define IDS_EXTENSION_LOAD_BACKGROUND_SCRIPT_FAILED 41099
#define IDS_EXTENSION_LOAD_BACKGROUND_PAGE_FAILED 41100
#define IDS_EXTENSION_LOAD_CSS_FAILED 41101
#define IDS_EXTENSION_LOAD_JAVASCRIPT_FAILED 41102
#define IDS_EXTENSION_LOAD_OPTIONS_PAGE_FAILED 41103
#define IDS_EXTENSION_LOCALES_NO_DEFAULT_LOCALE_SPECIFIED 41104
#define IDS_EXTENSION_MANIFEST_UNREADABLE 41105
#define IDS_EXTENSION_MANIFEST_INVALID 41106
#define IDS_EXTENSION_PACKAGE_IMAGE_ERROR 41107
#define IDS_EXTENSION_PACKAGE_UNZIP_ERROR 41108
#define IDS_EXTENSION_PRIVATE_KEY_EXISTS 41109
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_READ 41110
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_EXPORT 41111
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_GENERATE 41112
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_OUTPUT 41113
#define IDS_EXTENSION_PRIVATE_KEY_INVALID 41114
#define IDS_EXTENSION_PRIVATE_KEY_NO_EXISTS 41115
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_PATH 41116
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_FORMAT 41117
#define IDS_EXTENSION_PUBLIC_KEY_FAILED_TO_EXPORT 41118
#define IDS_EXTENSION_SHARING_VIOLATION 41119
#define IDS_EXTENSION_CANT_INSTALL_POLICY_BLOCKED 41120
#define IDS_EXTENSION_CANT_MODIFY_POLICY_REQUIRED 41121
#define IDS_EXTENSION_CANT_UNINSTALL_POLICY_REQUIRED 41122
#define IDS_EXTENSION_DISABLED_UPDATE_REQUIRED_BY_POLICY 41123
#define IDS_EXTENSION_DISABLED_PUBLISHED_IN_STORE_REQUIRED_BY_POLICY 41124
#define IDS_EXTENSION_MANIFEST_VERSION_NOT_SUPPORTED 41125
#define IDS_DEVICE_NAME_WITH_PRODUCT_SERIAL 41126
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR 41127
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR_SERIAL 41128
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR 41129
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR_SERIAL 41130
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR 41131
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR_SERIAL 41132
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR 41133
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR_SERIAL 41134
#define IDS_DEVICE_PERMISSIONS_PROMPT_SINGLE_SELECTION 41135
#define IDS_DEVICE_PERMISSIONS_PROMPT_MULTIPLE_SELECTION 41136
#define IDS_CAMERA_FACING_USER 41137
#define IDS_CAMERA_FACING_ENVIRONMENT 41138
#define IDS_EXTENSION_USB_DEVICE_PRODUCT_NAME_AND_VENDOR 41139
#define IDS_EXTENSION_TASK_MANAGER_APPVIEW_TAG_PREFIX 41140
#define IDS_EXTENSION_TASK_MANAGER_EXTENSIONOPTIONS_TAG_PREFIX 41141
#define IDS_EXTENSION_TASK_MANAGER_MIMEHANDLERVIEW_TAG_PREFIX 41142
#define IDS_EXTENSION_TASK_MANAGER_WEBVIEW_TAG_PREFIX 41143
#define IDS_EXTENSION_WARNINGS_NETWORK_DELAY 41144
#define IDS_EXTENSION_WARNINGS_DOWNLOAD_FILENAME_CONFLICT 41145
#define IDS_EXTENSION_WARNING_RELOAD_TOO_FREQUENT 41146
#define IDS_EXTENSION_WARNING_RULESET_FAILED_TO_LOAD 41147
#define IDS_EXTENSION_WARNING_ENABLED_RULE_COUNT_EXCEEDED 41148
#define IDS_EXTENSION_INSTALL_PROCESS_CRASHED 41149
#define IDS_EXTENSION_PACKAGE_ERROR_CODE 41150
#define IDS_EXTENSION_PACKAGE_ERROR_MESSAGE 41151
#define IDS_EXTENSION_PACKAGE_INSTALL_ERROR 41152
#define IDS_EXTENSION_UNPACK_FAILED 41153
#define IDS_EXTENSION_WEBGL_NOT_SUPPORTED 41154

// ---------------------------------------------------------------------------
// From generated_resources.h:

#define IDS_ACCESS_CODE_CAST_ACCESS_CODE_MESSAGE 1400
#define IDS_ACCESS_CODE_CAST_BACK 1401
#define IDS_ACCESS_CODE_CAST_CAST 1402
#define IDS_ACCESS_CODE_CAST_CONNECT 1403
#define IDS_ACCESS_CODE_CAST_DIALOG_TITLE 1404
#define IDS_ACCESS_CODE_CAST_ENTER_CHARACTER 1405
#define IDS_ACCESS_CODE_CAST_ERROR_ACCESS_CODE 1406
#define IDS_ACCESS_CODE_CAST_ERROR_DIFFERENT_NETWORK 1407
#define IDS_ACCESS_CODE_CAST_ERROR_NETWORK 1408
#define IDS_ACCESS_CODE_CAST_ERROR_PERMISSION 1409
#define IDS_ACCESS_CODE_CAST_ERROR_TOO_MANY_REQUESTS 1410
#define IDS_ACCESS_CODE_CAST_ERROR_UNKNOWN 1411
#define IDS_ACCESS_CODE_CAST_ERROR_PROFILE_SYNC 1412
#define IDS_ACCESS_CODE_CAST_INPUT_ARIA_LABEL 1413
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_DAYS 1414
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_HOURS 1415
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_MONTHS 1416
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_YEARS 1417
#define IDS_ACCESS_CODE_CAST_SUBMIT 1418
#define IDS_ACCESS_CODE_CAST_USE_CAMERA 1419
#define IDS_BOOKMARK_GROUP_FROM_IE 1420
#define IDS_BOOKMARK_GROUP_FROM_EDGE 1421
#define IDS_BOOKMARK_GROUP_FROM_FIREFOX 1422
#define IDS_BOOKMARK_GROUP_FROM_SAFARI 1423
#define IDS_BOOKMARK_GROUP 1424
#define IDS_UNNAMED_BOOKMARK_BUTTON_ACCESSIBLE_NAME 1425
#define IDS_BOOKMARK_BAR_SHOW_APPS_SHORTCUT 1426
#define IDS_BOOKMARK_BAR_SHOW_READING_LIST 1427
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS_DEFAULT_NAME 1428
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS 1429
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_NAME 675
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_TOOLTIP 676
#define IDS_BOOKMARK_BAR_OVERFLOW_BUTTON_TOOLTIP 683
#define IDS_BOOKMARK_BAR_OPEN_ALL 1430
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT 1431
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_WINDOW 1432
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_INCOGNITO 1433
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_TAB_GROUP 1434
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_TAB 1435
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_WINDOW 1436
#define IDS_BOOKMARK_BAR_OPEN_INCOGNITO 1437
#define IDS_BOOKMARK_BAR_EDIT 1438
#define IDS_BOOKMARK_BAR_RENAME_FOLDER 1439
#define IDS_BOOKMARK_BAR_REMOVE 1440
#define IDS_BOOKMARK_BAR_ADD_NEW_BOOKMARK 1441
#define IDS_BOOKMARK_BAR_NEW_FOLDER 1442
#define IDS_SHOW_BOOKMARK_BAR 1443
#define IDS_HIDE_BOOKMARK_BAR 1444
#define IDS_BOOKMARK_BAR_SHOULD_OPEN_ALL 1445
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARKED 1446
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARK 1447
#define IDS_BOOKMARK_BUBBLE_NAME_LABEL 1448
#define IDS_BOOKMARK_AX_BUBBLE_NAME_LABEL 1449
#define IDS_BOOKMARK_BUBBLE_FOLDER_LABEL 1450
#define IDS_BOOKMARK_AX_BUBBLE_FOLDER_LABEL 1451
#define IDS_BOOKMARK_BUBBLE_OPTIONS 1452
#define IDS_BOOKMARK_BUBBLE_CHOOSER_ANOTHER_FOLDER 1453
#define IDS_BOOKMARK_DICE_PROMO_SYNC_MESSAGE 1454
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE 1455
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE_V2 1456
#define IDS_BOOKMARK_BUBBLE_DESKTOP_TO_IOS_PROMO_TITLE_V3 1457
#define IDS_BOOKMARK_FOOTNOTE_DESKTOP_TO_IOS_PROMO_MESSAGE 1458
#define IDS_BOOKMARK_EDITOR_NAME_LABEL 1459
#define IDS_BOOKMARK_AX_EDITOR_NAME_LABEL 1460
#define IDS_BOOKMARK_AX_EDITOR_URL_LABEL 1462
#define IDS_BOOKMARK_EDITOR_URL_LABEL 1463
#define IDS_BOOKMARK_EDITOR_CONFIRM_DELETE 1464
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_BUTTON 1465
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_MENU_ITEM 1466
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE 1467
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE_NEW 1468
#define IDS_UNNAMED_BOOKMARK_FOLDER 678
#define IDS_BOOKMARK_ALL_TABS_DIALOG_TITLE 1469
#define IDS_BOOKMARK_MANAGER_TITLE 396
#define IDS_BOOKMARK_MANAGER_SEARCH_BUTTON 1470
#define IDS_BOOKMARK_MANAGER 1471
#define IDS_BOOKMARK_MANAGER_ORGANIZE_MENU 1472
#define IDS_BOOKMARK_MANAGER_INVALID_URL 1473
#define IDS_EXPORT_BOOKMARKS_DEFAULT_FILENAME 1474
#define IDS_BOOKMARK_MANAGER_ADD_BOOKMARK_TITLE 1475
#define IDS_BOOKMARK_MANAGER_ADD_FOLDER_TITLE 1476
#define IDS_BOOKMARK_MANAGER_CLEAR_SEARCH 1477
#define IDS_BOOKMARK_MANAGER_EMPTY_LIST 1478
#define IDS_BOOKMARK_MANAGER_EMPTY_UNMODIFIABLE_LIST 1479
#define IDS_BOOKMARK_MANAGER_FOLDER_LABEL 1480
#define IDS_BOOKMARK_MANAGER_FOLDER_RENAME_TITLE 1481
#define IDS_BOOKMARK_MANAGER_FOLDER_LIST_CHANGED 1482
#define IDS_BOOKMARK_MANAGER_LIST_AX_LABEL 1483
#define IDS_BOOKMARK_MANAGER_MENU_ADD_BOOKMARK 1484
#define IDS_BOOKMARK_MANAGER_MENU_ADD_FOLDER 1485
#define IDS_BOOKMARK_MANAGER_MENU_CUT 1486
#define IDS_BOOKMARK_MANAGER_MENU_COPY 1487
#define IDS_BOOKMARK_MANAGER_MENU_PASTE 1488
#define IDS_BOOKMARK_MANAGER_MENU_EXPORT 1489
#define IDS_BOOKMARK_MANAGER_MENU_HELP_CENTER 1490
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT 1491
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_BEGAN 1492
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_ENDED 1493
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL 1494
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_WITH_COUNT 1495
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW 1496
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW_WITH_COUNT 1497
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO 1498
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO_WITH_COUNT 1499
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_TAB_GROUP_WITH_COUNT 1500
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB 1501
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_WINDOW 1502
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_INCOGNITO 1503
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB_GROUP 1504
#define IDS_BOOKMARK_MANAGER_MENU_RENAME 1505
#define IDS_BOOKMARK_MANAGER_MENU_SHOW_IN_FOLDER 1506
#define IDS_BOOKMARK_MANAGER_MENU_SORT 1507
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS 1508
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_AX_LABEL 1509
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_MULTI_AX_LABEL 1510
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_TITLE 1511
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_CONFIRM 1512
#define IDS_BOOKMARK_MANAGER_ITEMS_SELECTED 1513
#define IDS_BOOKMARK_MANAGER_ITEMS_UNSELECTED 1514
#define IDS_BOOKMARK_MANAGER_SIDEBAR_AX_LABEL 1515
#define IDS_BOOKMARK_MANAGER_TOAST_FOLDER_SORTED 1516
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_DELETED 1517
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_DELETED 1518
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_COPIED 1519
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_COPIED 1520
#define IDS_BOOKMARKS_MENU 1521
#define IDS_BOOKMARKS_AND_LISTS_MENU 1522
#define IDS_SHOW_BOOKMARK_SIDE_PANEL 1523
#define IDS_BOOKMARK_THIS_TAB 1524
#define IDS_BOOKMARK_ALL_TABS 1525
#define IDS_BOOKMARKS_LIST_TITLE 1526
#define IDS_TOOLTIP_STARRED 1527
#define IDS_BOOKMARK_SCREEN_READER_CREATED 1528
#define IDS_BOOKMARK_SCREEN_READER_FOLDER_CREATED 1529
#define IDS_BOOKMARK_SCREEN_READER_REORDERED 1530
#define IDS_BOOKMARK_SCREEN_READER_MOVED 1531
#define IDS_APP_MANAGEMENT_CAMERA 1532
#define IDS_APP_MANAGEMENT_LOCATION 1533
#define IDS_APP_MANAGEMENT_MICROPHONE 1534
#define IDS_APP_MANAGEMENT_NO_APPS_FOUND 1535
#define IDS_APP_MANAGEMENT_NOTIFICATIONS 1536
#define IDS_APP_MANAGEMENT_PERMISSIONS 1537
#define IDS_APP_MANAGEMENT_MORE_SETTINGS 1538
#define IDS_APP_MANAGEMENT_PIN_TO_SHELF 1539
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES 1540
#define IDS_APP_MANAGEMENT_WINDOW 1541
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES_TEXT 1542
#define IDS_APP_MANAGEMENT_PRINTING 1543
#define IDS_APP_MANAGEMENT_SEARCH_PROMPT 1544
#define IDS_APP_MANAGEMENT_UNINSTALL_APP 1545
#define IDS_APP_MANAGEMENT_CONTACTS 1546
#define IDS_APP_MANAGEMENT_STORAGE 1547
#define IDS_APP_MANAGEMENT_RUN_ON_OS_LOGIN 1548
#define IDS_APP_MANAGEMENT_POLICY_APP_POLICY_STRING 1549
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_TITLE 1550
#define IDS_APP_MANAGEMENT_INTENT_SHARING_APP_OPEN 1551
#define IDS_APP_MANAGEMENT_INTENT_SHARING_BROWSER_OPEN 1552
#define IDS_APP_MANAGEMENT_INTENT_SHARING_TAB_EXPLANATION 1553
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_DIALOG_TITLE 1554
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_CHANGE_BUTTON 1555
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TITLE 1556
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_1_APP 1557
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_2_APPS 1558
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_3_APPS 1559
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_4_APPS 1560
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_5_OR_MORE_APPS 1561
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_1_APP 1562
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_2_APPS 1563
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_3_APPS 1564
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_4_APPS 1565
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_5_OR_MORE_APPS 1566
#define IDS_APP_MANAGEMENT_APP_DETAILS_TITLE 1567
#define IDS_APP_MANAGEMENT_APP_DETAILS_TOOLTIP_CROS_SYSTEM 1568
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_ANDROID 1569
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_CHROME 1570
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_WEB 1571
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_CROS_SYSTEM 1572
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_WEB_STORE 1573
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_PLAY_STORE 1574
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_BROWSER 1575
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_AND_SOURCE_COMBINED 1576
#define IDS_APP_MANAGEMENT_APP_DETAILS_VERSION 1577
#define IDS_APP_MANAGEMENT_APP_DETAILS_STORAGE_TITLE 1578
#define IDS_APP_MANAGEMENT_APP_DETAILS_APP_SIZE 1579
#define IDS_APP_MANAGEMENT_APP_DETAILS_DATA_SIZE 1580
#define IDS_APP_MANAGEMENT_ARC_MANAGE_PERMISSIONS 1581
#define IDS_APP_MANAGEMENT_PERMISSION_ASK 1582
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED 1583
#define IDS_APP_MANAGEMENT_PERMISSION_ALLOWED_WITH_DETAILS 1584
#define IDS_APP_MANAGEMENT_PERMISSION_DENIED 1585
#define IDS_APP_MANAGEMENT_FILE_HANDLING_HEADER 1586
#define IDS_APP_MANAGEMENT_FILE_HANDLING_OVERFLOW_DIALOG_TITLE 1587
#define IDS_APP_MANAGEMENT_FILE_HANDLING_SET_DEFAULTS_LINK 1588
#define IDS_APP_MANAGEMENT_FILE_HANDLING_TYPES 1589
#define IDS_APP_MANAGEMENT_SUB_APPS_LIST_HEADING 1590
#define IDS_APP_MANAGEMENT_PARENT_APP_PERMISSION_EXPLANATION 1591
#define IDS_APP_MANAGEMENT_SUB_APP_PERMISSION_EXPLANATION 1592
#define IDS_MEDIA_ROUTER_ICON_TOOLTIP_TEXT 428
#define IDS_MEDIA_ROUTER_MENU_ITEM_TITLE 1593
#define IDS_MEDIA_ROUTER_PRESENTATION_CAST_MODE 1594
#define IDS_MEDIA_ROUTER_DESKTOP_MIRROR_CAST_MODE 1595
#define IDS_MEDIA_ROUTER_TAB_MIRROR_CAST_MODE 1596
#define IDS_MEDIA_ROUTER_ALTERNATIVE_SOURCES_BUTTON 1597
#define IDS_MEDIA_ROUTER_ABOUT 422
#define IDS_MEDIA_ROUTER_HELP 424
#define IDS_MEDIA_ROUTER_ALWAYS_SHOW_TOOLBAR_ACTION 425
#define IDS_MEDIA_ROUTER_SHOWN_BY_POLICY 1598
#define IDS_MEDIA_ROUTER_TOGGLE_MEDIA_REMOTING 426
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_WITH_HOSTNAME 1599
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT 1600
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_DESKTOP 1601
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_TAB 1602
#define IDS_MEDIA_ROUTER_ISSUE_UNABLE_TO_CAST_DESKTOP 1603
#define IDS_MEDIA_ROUTER_ISSUE_TAB_AUDIO_NOT_SUPPORTED 1604
#define IDS_MEDIA_ROUTER_ISSUE_DESKTOP_AUDIO_NOT_SUPPORTED 1605
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_PENDING_AUTHORIZATION 1607
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_USER_NOT_ALLOWED 1608
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_NOTIFICATION_DISABLED 1609
#define IDS_MEDIA_ROUTER_ISSUE_FAILED_TO_CAST 1610
#define IDS_MEDIA_ROUTER_ISSUE_CANNOT_TERMINATE 1611
#define IDS_MEDIA_ROUTER_STATUS_LOOKING_FOR_DEVICES 1612
#define IDS_MEDIA_ROUTER_STATUS_NO_DEVICES_FOUND 1613
#define IDS_MEDIA_ROUTER_NO_DEVICES_FOUND_BUTTON 1614
#define IDS_MEDIA_ROUTER_DESTINATION_MISSING 1615
#define IDS_MEDIA_ROUTER_SINK_AVAILABLE 1616
#define IDS_MEDIA_ROUTER_SINK_CONNECTING 1617
#define IDS_MEDIA_ROUTER_SINK_DISCONNECTING 1618
#define IDS_MEDIA_ROUTER_SINK_PAUSED 1619
#define IDS_MEDIA_ROUTER_STOP_CASTING 1620
#define IDS_MEDIA_ROUTER_SOURCE_NOT_SUPPORTED 1621
#define IDS_MEDIA_ROUTER_AVAILABLE_SPECIFIC_SITES 1622
#define IDS_MEDIA_ROUTER_CASTING_DESKTOP 1623
#define IDS_MEDIA_ROUTER_CASTING_TAB 1624
#define IDS_MEDIA_ROUTER_PRESENTATION_ROUTE_DESCRIPTION 1625
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE 1626
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_GENERIC_ACCESSIBLE_NAME 1627
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_SCREEN_ACCESSIBLE_NAME 1628
#define IDS_MEDIA_ROUTER_SINK_VIEW_PAUSE_TAB_ACCESSIBLE_NAME 1629
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME 1630
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_GENERIC_ACCESSIBLE_NAME 1631
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_SCREEN_ACCESSIBLE_NAME 1632
#define IDS_MEDIA_ROUTER_SINK_VIEW_RESUME_TAB_ACCESSIBLE_NAME 1633
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP 1634
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_GENERIC_ACCESSIBLE_NAME 1635
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_SCREEN_ACCESSIBLE_NAME 1636
#define IDS_MEDIA_ROUTER_SINK_VIEW_STOP_TAB_ACCESSIBLE_NAME 1637
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_TITLE 1638
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_BODY_TEXT 1639
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CHECKBOX 1640
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_OPTIMIZE_BUTTON 1641
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON 1642
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON_MACOS 1643
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_DEPRECATED 1644
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_REMOVED 1645
#define IDS_MEDIA_ROUTER_WIRED_DISPLAY_SINK_NAME 1646
#define IDS_MEDIA_ROUTER_FEEDBACK_TITLE 1647
#define IDS_MEDIA_ROUTER_FEEDBACK_NA 1648
#define IDS_MEDIA_ROUTER_FEEDBACK_FORM_DESCRIPTION 1649
#define IDS_MEDIA_ROUTER_FEEDBACK_HEADER 1650
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_ANSWER 1651
#define IDS_MEDIA_ROUTER_FEEDBACK_REQUIRED 1652
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_QUESTION 1653
#define IDS_MEDIA_ROUTER_FEEDBACK_PROMPT 1654
#define IDS_MEDIA_ROUTER_FEEDBACK_MIRRORING_QUALITY_SUBHEADING 1655
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTHNESS 1656
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_QUALITY 1657
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_QUALITY 1658
#define IDS_MEDIA_ROUTER_FEEDBACK_CONTENT_QUESTION 1659
#define IDS_MEDIA_ROUTER_FEEDBACK_ADDITIONAL_COMMENTS 1660
#define IDS_MEDIA_ROUTER_FEEDBACK_ALLOW_CONTACT_BY_EMAIL 1661
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_EMAIL_ADDRESS 1662
#define IDS_MEDIA_ROUTER_FEEDBACK_EMAIL_FIELD 1663
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_BUTTON 1664
#define IDS_MEDIA_ROUTER_FEEDBACK_DISCARD_CONFIRMATION 1665
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_BUG_OR_ERROR 1666
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_FEATURE_REQUEST 1667
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_PROJECTION_QUALITY 1668
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_DISCOVERY 1669
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_OTHER 1670
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_FREEZES 1671
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_JERKY 1672
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_STUTTER 1673
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTH 1674
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_PERFECT 1675
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_UNWATCHABLE 1676
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_POOR 1677
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_ACCEPTABLE 1678
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GOOD 1679
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GREAT 1680
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_UNINTELLIGIBLE 1681
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_POOR 1682
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_ACCEPTABLE 1683
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_GOOD 1684
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_PERFECT 1685
#define IDS_MEDIA_ROUTER_FEEDBACK_SENDING 1686
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_FAIL 1687
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_SUCCESS 1688
#define IDS_MEDIA_ROUTER_FEEDBACK_RESENDING 1689
#define IDS_MEDIA_ROUTER_FEEDBACK_LOGS_HEADER 1690
#define IDS_MEDIA_ROUTER_FEEDBACK_FINE_LOGS_WARNING 1691
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS_HTML 1692
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS 1693
#define IDS_MEDIA_ROUTER_FEEDBACK_PRIVACY_DATA_USAGE 1694
#define IDS_MEDIA_ROUTER_FEEDBACK_SETUP_VISIBILITY_QUESTION 1695
#define IDS_MEDIA_ROUTER_FEEDBACK_YES 1696
#define IDS_MEDIA_ROUTER_FEEDBACK_NO 1697
#define IDS_MEDIA_ROUTER_FEEDBACK_DID_NOT_TRY 1698
#define IDS_MEDIA_ROUTER_FEEDBACK_SOFTWARE_QUESTION 1699
#define IDS_MEDIA_ROUTER_FEEDBACK_UNKNOWN 1700
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_QUESTION 1701
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_SAME_WIFI 1702
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_DIFFERENT_WIFI 1703
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_WIRED_PC 1704
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_CAST_SCREEN 1705
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_PAUSED 1706
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_CAN_PAUSE 1707
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_SCREEN_PAUSED 1708
#define IDS_MEDIA_ROUTER_NOTIFICATION_MESSAGE_TAB_CAN_PAUSE 1709
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE 1710
#define IDS_MEDIA_ROUTER_NOTIFICATION_TITLE_UNKNOWN 1711
#define IDS_GLOBAL_MEDIA_CONTROLS_ICON_TOOLTIP_TEXT 430
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL_WITH_COLON 1712
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL 1713
#define IDS_GLOBAL_MEDIA_CONTROLS_STOP_CASTING_BUTTON_LABEL 1714
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_ENGLISH_ONLY 1715
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION 1716
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_SHOW_LANGUAGE 1717
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_PROGRESS 1718
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR 1719
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 1720
#define IDS_GLOBAL_MEDIA_CONTROLS_CAPTION_SETTINGS 1721
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_TRANSLATE_SUBTITLE 1722
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_TRANSLATE_TARGET_LANGUAGE_ACCNAME 1723
#define IDS_GLOBAL_MEDIA_CONTROLS_DIALOG_NAME 1724
#define IDS_GLOBAL_MEDIA_CONTROLS_SHOW_DEVICE_LIST 1725
#define IDS_GLOBAL_MEDIA_CONTROLS_HIDE_DEVICE_LIST 1726
#define IDS_GLOBAL_MEDIA_CONTROLS_CONTROL_CAST_SESSIONS_PROMO 1727
#define IDS_MEDIA_TOOLBAR_CONTEXT_REPORT_CAST_ISSUE 427
#define IDS_MEDIA_TOOLBAR_CONTEXT_SHOW_OTHER_SESSIONS 429
#define IDS_AVATAR_BUTTON_GUEST 1728
#define IDS_AVATAR_BUTTON_GUEST_TOOLTIP 1729
#define IDS_GUEST_BUBBLE_ACCESSIBLE_TITLE 1730
#define IDS_INCOGNITO_BUBBLE_ACCESSIBLE_TITLE 1731
#define IDS_AVATAR_BUTTON_INCOGNITO 1732
#define IDS_AVATAR_BUTTON_INCOGNITO_TOOLTIP 1733
#define IDS_AVATAR_BUTTON_SYNC_ERROR 1734
#define IDS_AVATAR_BUTTON_SYNC_ERROR_TOOLTIP 1735
#define IDS_AVATAR_BUTTON_SYNC_PAUSED 1736
#define IDS_PROFILES_MENU_NAME 1737
#define IDS_PROFILES_PROFILE_BUBBLE_ACCESSIBLE_TITLE 1740
#define IDS_PROFILES_EXIT_PROFILE_BUTTON 1741
#define IDS_PROFILES_GAIA_SIGNIN_TITLE 1742
#define IDS_PROFILES_ACCOUNT_REMOVAL_TITLE 1743
#define IDS_PROFILES_SYNC_COMPLETE_TITLE 1744
#define IDS_PROFILES_OPEN_SYNC_SETTINGS_BUTTON 1745
#define IDS_PROFILES_DICE_SIGNIN_BUTTON 1746
#define IDS_PROFILES_DICE_NOT_SYNCING_TITLE 1747
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON 1748
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON_NO_NAME 1749
#define IDS_PROFILES_DICE_SYNC_DISABLED_TITLE 1750
#define IDS_PROFILES_DICE_SYNC_PAUSED_TITLE 1751
#define IDS_PROFILES_CLOSE_X_WINDOWS_BUTTON 1752
#define IDS_PROFILES_SIGNIN_PROMO 1753
#define IDS_PROFILES_CREDIT_CARDS_LINK 1754
#define IDS_PROFILES_ADDRESSES_LINK 1755
#define IDS_PROFILES_LIST_PROFILES_TITLE 1756
#define IDS_PROFILES_PROFILE_MANAGE_ACCOUNTS_BUTTON 1757
#define IDS_PROFILES_PROFILE_HIDE_MANAGE_ACCOUNTS_BUTTON 1758
#define IDS_PROFILES_MANAGE_PROFILES_BUTTON_TOOLTIP 1759
#define IDS_PROFILES_MANAGE_PROFILES_MANAGED_TOOLTIP 1760
#define IDS_PROFILES_CUSTOMIZE_PROFILE_BUTTON_TOOLTIP 1761
#define IDS_PROFILES_GUEST_PROFILE_NAME 1762
#define IDS_DEFAULT_PROFILE_NAME 1763
#define IDS_LEGACY_DEFAULT_PROFILE_NAME 1764
#define IDS_NUMBERED_PROFILE_NAME 1765
#define IDS_NEW_NUMBERED_PROFILE_NAME 1766
#define IDS_SINGLE_PROFILE_DISPLAY_NAME 1767
#define IDS_GUEST_PROFILE_NAME 1768
#define IDS_DEFAULT_AVATAR_NAME_8 1769
#define IDS_DEFAULT_AVATAR_NAME_9 1770
#define IDS_DEFAULT_AVATAR_NAME_10 1771
#define IDS_DEFAULT_AVATAR_NAME_11 1772
#define IDS_DEFAULT_AVATAR_NAME_12 1773
#define IDS_DEFAULT_AVATAR_NAME_13 1774
#define IDS_DEFAULT_AVATAR_NAME_14 1775
#define IDS_DEFAULT_AVATAR_NAME_15 1776
#define IDS_DEFAULT_AVATAR_NAME_16 1777
#define IDS_DEFAULT_AVATAR_NAME_17 1778
#define IDS_DEFAULT_AVATAR_NAME_18 1779
#define IDS_DEFAULT_AVATAR_NAME_19 1780
#define IDS_DEFAULT_AVATAR_NAME_20 1781
#define IDS_DEFAULT_AVATAR_NAME_21 1782
#define IDS_DEFAULT_AVATAR_NAME_22 1783
#define IDS_DEFAULT_AVATAR_NAME_23 1784
#define IDS_DEFAULT_AVATAR_NAME_24 1785
#define IDS_DEFAULT_AVATAR_NAME_25 1786
#define IDS_DEFAULT_AVATAR_NAME_26 1787
#define IDS_DEFAULT_AVATAR_LABEL_0 1788
#define IDS_DEFAULT_AVATAR_LABEL_1 1789
#define IDS_DEFAULT_AVATAR_LABEL_2 1790
#define IDS_DEFAULT_AVATAR_LABEL_3 1791
#define IDS_DEFAULT_AVATAR_LABEL_4 1792
#define IDS_DEFAULT_AVATAR_LABEL_5 1793
#define IDS_DEFAULT_AVATAR_LABEL_6 1794
#define IDS_DEFAULT_AVATAR_LABEL_7 1795
#define IDS_DEFAULT_AVATAR_LABEL_8 1796
#define IDS_DEFAULT_AVATAR_LABEL_9 1797
#define IDS_DEFAULT_AVATAR_LABEL_10 1798
#define IDS_DEFAULT_AVATAR_LABEL_11 1799
#define IDS_DEFAULT_AVATAR_LABEL_12 1800
#define IDS_DEFAULT_AVATAR_LABEL_13 1801
#define IDS_DEFAULT_AVATAR_LABEL_14 1802
#define IDS_DEFAULT_AVATAR_LABEL_15 1803
#define IDS_DEFAULT_AVATAR_LABEL_16 1804
#define IDS_DEFAULT_AVATAR_LABEL_17 1805
#define IDS_DEFAULT_AVATAR_LABEL_18 1806
#define IDS_DEFAULT_AVATAR_LABEL_19 1807
#define IDS_DEFAULT_AVATAR_LABEL_20 1808
#define IDS_DEFAULT_AVATAR_LABEL_21 1809
#define IDS_DEFAULT_AVATAR_LABEL_22 1810
#define IDS_DEFAULT_AVATAR_LABEL_23 1811
#define IDS_DEFAULT_AVATAR_LABEL_24 1812
#define IDS_DEFAULT_AVATAR_LABEL_25 1813
#define IDS_DEFAULT_AVATAR_LABEL_26 1814
#define IDS_DEFAULT_AVATAR_LABEL_27 1815
#define IDS_DEFAULT_AVATAR_LABEL_28 1816
#define IDS_DEFAULT_AVATAR_LABEL_29 1817
#define IDS_DEFAULT_AVATAR_LABEL_30 1818
#define IDS_DEFAULT_AVATAR_LABEL_31 1819
#define IDS_DEFAULT_AVATAR_LABEL_32 1820
#define IDS_DEFAULT_AVATAR_LABEL_33 1821
#define IDS_DEFAULT_AVATAR_LABEL_34 1822
#define IDS_DEFAULT_AVATAR_LABEL_35 1823
#define IDS_DEFAULT_AVATAR_LABEL_36 1824
#define IDS_DEFAULT_AVATAR_LABEL_37 1825
#define IDS_DEFAULT_AVATAR_LABEL_38 1826
#define IDS_DEFAULT_AVATAR_LABEL_39 1827
#define IDS_DEFAULT_AVATAR_LABEL_40 1828
#define IDS_DEFAULT_AVATAR_LABEL_41 1829
#define IDS_DEFAULT_AVATAR_LABEL_42 1830
#define IDS_DEFAULT_AVATAR_LABEL_43 1831
#define IDS_DEFAULT_AVATAR_LABEL_44 1832
#define IDS_DEFAULT_AVATAR_LABEL_45 1833
#define IDS_DEFAULT_AVATAR_LABEL_46 1834
#define IDS_DEFAULT_AVATAR_LABEL_47 1835
#define IDS_DEFAULT_AVATAR_LABEL_48 1836
#define IDS_DEFAULT_AVATAR_LABEL_49 1837
#define IDS_DEFAULT_AVATAR_LABEL_50 1838
#define IDS_DEFAULT_AVATAR_LABEL_51 1839
#define IDS_DEFAULT_AVATAR_LABEL_52 1840
#define IDS_DEFAULT_AVATAR_LABEL_53 1841
#define IDS_DEFAULT_AVATAR_LABEL_54 1842
#define IDS_DEFAULT_AVATAR_LABEL_55 1843
#define IDS_PROFILES_LOCAL_PROFILE_STATE 1844
#define IDS_PROFILES_CREATE_BUTTON_LABEL 1845
#define IDS_PROFILES_MANAGE_BUTTON_LABEL 1846
#define IDS_PROFILES_DEFAULT_NAME 376
#define IDS_SYNC_LOGIN_NAME_PROHIBITED 1847
#define IDS_SUPERVISED_USER_NOT_ALLOWED_BY_POLICY 1848
#define IDS_OLD_PROFILES_DISABLED_TITLE 1849
#define IDS_OLD_PROFILES_DISABLED_MESSAGE 1850
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION 1851
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION_WITH_DOMAIN 1852
#define IDS_OLD_PROFILES_DISABLED_REMOVED_OLD_PROFILE 1853
#define IDS_SYNC_USER_NAME_IN_USE_ERROR 1854
#define IDS_SYNC_USER_NAME_IN_USE_BY_ERROR 1855
#define IDS_SCREEN_LOCK_SIGN_OUT 1856
#define IDS_PROFILE_CUSTOMIZATION_DONE_BUTTON_LABEL 1863
#define IDS_PROFILE_CUSTOMIZATION_THEMES_CONTAINER_LABEL 1864
#define IDS_PROFILE_CUSTOMIZATION_WELCOME 1865
#define IDS_PROFILE_CUSTOMIZATION_INPUT_LABEL 1866
#define IDS_PROFILE_CUSTOMIZATION_INPUT_PLACEHOLDER 1867
#define IDS_PROFILE_CUSTOMIZATION_INPUT_ERROR_MESSAGE 1868
#define IDS_PROFILE_CUSTOMIZATION_SKIP_BUTTON_LABEL 1869
#define IDS_PROFILE_CUSTOMIZATION_DELETE_PROFILE_BUTTON_LABEL 1870
#define IDS_PROFILE_CUSTOMIZATION_LOCAL_PROFILE_CREATION_TITLE 1871
#define IDS_PROFILE_CUSTOMIZATION_AVATAR_SELECTION_BACK_BUTTON_LABEL 1872
#define IDS_ENTERPRISE_PROFILE_WELCOME_TITLE 1873
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_MANAGED_BY 1874
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_STRICT_SEPARATION 1875
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_MANAGED_SEPARATION 1876
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED 1877
#define IDS_ENTERPRISE_PROFILE_WELCOME_PROFILE_SEPARATION_DEVICE_MANAGED_BY 1878
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_EMAIL_MANAGED_BY 1879
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED_BY 1880
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED 1881
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITH_SYNC 1882
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITHOUT_SYNC 1883
#define IDS_ENTERPRISE_WELCOME_PROFILE_REQUIRED_TITLE 1884
#define IDS_ENTERPRISE_WELCOME_PROFILE_WILL_BE_MANAGED_TITLE 1885
#define IDS_ENTERPRISE_PROFILE_WELCOME_CREATE_PROFILE_BUTTON 1886
#define IDS_ENTERPRISE_PROFILE_WELCOME_LINK_DATA_CHECKBOX 1887
#define IDS_PROFILE_PICKER_ADD_SPACE_BUTTON 1888
#define IDS_PROFILE_PICKER_BROWSE_AS_GUEST_BUTTON 1889
#define IDS_PROFILE_PICKER_BACK_BUTTON_ARIA_LABEL 1890
#define IDS_PROFILE_PICKER_BACK_BUTTON_SIGN_IN_LABEL 1891
#define IDS_PROFILE_PICKER_PROFILE_CARD_NEEDS_SIGNIN_PROMPT 1892
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL 1893
#define IDS_PROFILE_PICKER_PROFILE_CARD_INPUT_LABEL 1894
#define IDS_PROFILE_PICKER_PROFILE_MORE_ACTIONS_ARIA_LABEL 1895
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_TEXT 1896
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_CONFIRM 1897
#define IDS_PROFILE_PICKER_PROFILE_MENU_CUSTOMIZE_TEXT 1898
#define IDS_PROFILE_PICKER_PROFILE_MENU_INCOGNITO_TEXT 1899
#define IDS_PROFILE_PICKER_ASK_ON_STARTUP 1900
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE_TITLE 1901
#define IDS_PROFILE_PICKER_REMOVE_WARNING_HISTORY 1902
#define IDS_PROFILE_PICKER_REMOVE_WARNING_PASSWORDS 1903
#define IDS_PROFILE_PICKER_REMOVE_WARNING_BOOKMARKS 1904
#define IDS_PROFILE_PICKER_REMOVE_WARNING_AUTOFILL 1905
#define IDS_PROFILE_PICKER_REMOVE_WARNING_CALCULATING 1906
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_SIGNIN_BUTTON_LABEL 1907
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_NOT_NOW_BUTTON_LABEL 1908
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_CUSTOMIZE_AVATAR_BUTTON_LABEL 1909
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_AVATAR_TEXT 1910
#define IDS_PROFILE_PICKER_TAKE_A_TOUR_BUTTON_LABEL 1911
#define IDS_PROFILE_PICKER_IPH_NEXT_BUTTON_LABEL 1912
#define IDS_PROFILE_PICKER_IPH_DONE_BUTTON_LABEL 1913
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TITLE 1914
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TITLE 1915
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TITLE 1916
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TEXT 1917
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SWITCH_BUTTON_LABEL 1918
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_BY_DESCRIPTION 1919
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_DESCRIPTION 1920
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE 1921
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE_TITLE 1922
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE 1923
#define IDS_FRE_SIGN_IN_SUBTITLE_0 1935
#define IDS_FRE_SIGN_IN_SUBTITLE_1 1936
#define IDS_FRE_DEVICES_CARD_TITLE 1937
#define IDS_FRE_DEVICES_CARD_DESCRIPTION 1938
#define IDS_FRE_SECURITY_CARD_TITLE 1939
#define IDS_FRE_SECURITY_CARD_DESCRIPTION 1940
#define IDS_FRE_BACKUP_CARD_TITLE 1941
#define IDS_FRE_BACKUP_CARD_DESCRIPTION 1942
#define IDS_FRE_DECLINE_SIGN_IN_BUTTON_TITLE 1943
#define IDS_FRE_ACCEPT_SIGN_IN_BUTTON_TITLE 1944
#define IDS_FRE_MANAGED_DESCRIPTION 1945
#define IDS_FRE_MANAGED_BY_DESCRIPTION 1946
#define IDS_FRE_DEFAULT_BROWSER_TITLE_NEW 1947
#define IDS_FRE_DEFAULT_BROWSER_SUBTITLE 1948
#define IDS_FRE_DEFAULT_BROWSER_SET_AS_DEFAULT 1949
#define IDS_FRE_DEFAULT_BROWSER_SKIP 1950
#define IDS_SETTINGS_EMPTY_STRING 6539
#define IDS_SETTINGS_CONTINUE 6540
#define IDS_SETTINGS_GOT_IT 6541
#define IDS_SETTINGS_MORE_ACTIONS 498
#define IDS_SETTINGS_OPENS_IN_NEW_TAB 6542
#define IDS_SETTINGS_SEND_FEEDBACK_ROLE_DESCRIPTION 6543
#define IDS_RELAUNCH_CONFIRMATION_DIALOG_BODY 6544
#define IDS_SETTINGS_ABOUT_PAGE_BROWSER_VERSION 6545
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_UPDATE_ERRORS 6546
#define IDS_SETTINGS_ABOUT_PAGE_LEARN_MORE_SYSTEM_REQUIREMENTS 6547
#define IDS_SETTINGS_ABOUT_PAGE_RELAUNCH 4188
#define IDS_SETTINGS_ACCESSIBILITY 6560
#define IDS_SETTINGS_ACCESSIBILITY_WEB_STORE 6561
#define IDS_SETTINGS_MORE_FEATURES_LINK 6562
#define IDS_SETTINGS_MORE_FEATURES_LINK_DESCRIPTION 6563
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_TITLE 6564
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_SUBTITLE 6565
#define IDS_SETTINGS_PDF_OCR_DOWNLOAD_COMPLETE 6566
#define IDS_SETTINGS_PDF_OCR_DOWNLOAD_ERROR 6567
#define IDS_SETTINGS_PDF_OCR_DOWNLOAD_PROGRESS 6568
#define IDS_SETTINGS_PDF_OCR_DOWNLOADING 6569
#define IDS_SETTINGS_PDF_OCR_TITLE 6570
#define IDS_SETTINGS_PDF_OCR_SUBTITLE 6571
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_TITLE 6572
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_TITLE 6573
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_TRANSLATE_SUBTITLE 6574
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE_ENGLISH_ONLY 6577
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE 6578
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_PROGRESS 6579
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_COMPLETE 6580
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR 6581
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR_REBOOT_REQUIRED 6582
#define IDS_SETTINGS_CAPTIONS_MASK_OFFENSIVE_WORDS_TITLE 6583
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_TITLE 6584
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_SUBTITLE 6585
#define IDS_SETTINGS_ACCESSIBILITY_FOCUS_HIGHLIGHT_DESCRIPTION 4715
#define IDS_SETTINGS_APPEARANCE 6586
#define IDS_SETTINGS_CUSTOM_WEB_ADDRESS 6587
#define IDS_SETTINGS_ENTER_CUSTOM_WEB_ADDRESS 6588
#define IDS_SETTINGS_HOME_BUTTON_DISABLED 6589
#define IDS_SETTINGS_THEMES 6590
#define IDS_SETTINGS_RESET_TO_DEFAULT_THEME 6597
#define IDS_SETTINGS_CHROME_COLORS 6598
#define IDS_SETTINGS_COLOR_SCHEME_MODE 6599
#define IDS_SETTINGS_SHOW_HOME_BUTTON 6600
#define IDS_SETTINGS_SHOW_BOOKMARKS_BAR 6601
#define IDS_SETTINGS_SHOW_HOVER_CARD_IMAGES 6602
#define IDS_SETTINGS_SIDE_PANEL 6603
#define IDS_SETTINGS_SIDE_PANEL_ALIGN_LEFT 6604
#define IDS_SETTINGS_SIDE_PANEL_ALIGN_RIGHT 6605
#define IDS_SETTINGS_HOME_PAGE_NTP 6606
#define IDS_SETTINGS_CHANGE_HOME_PAGE 6607
#define IDS_SETTINGS_WEB_STORE 6608
#define IDS_SETTINGS_READER_MODE 6611
#define IDS_SETTINGS_READER_MODE_DESCRIPTION 6612
#define IDS_SETTINGS_ADVANCED 6613
#define IDS_SETTINGS_BASIC 6614
#define IDS_SETTINGS_MENU_BUTTON_LABEL 6615
#define IDS_SETTINGS_MENU_EXTENSIONS_LINK_TOOLTIP 6616
#define IDS_SETTINGS_SEARCH_PROMPT 6617
#define IDS_SETTINGS_SEARCH_NO_RESULTS_HELP 6618
#define IDS_SETTINGS_SETTINGS 6619
#define IDS_SETTINGS_ALT_PAGE_TITLE 6620
#define IDS_SETTINGS_SUBPAGE_BUTTON 6621
#define IDS_SETTINGS_RESTART 6622
#define IDS_SETTINGS_CONTROLLED_BY_EXTENSION 6623
#define IDS_SETTINGS_CLEAR 6624
#define IDS_SETTINGS_CUSTOM 6625
#define IDS_SETTINGS_DELETE 6626
#define IDS_SETTINGS_EDIT 6627
#define IDS_SETTINGS_END_TIME 6628
#define IDS_SETTINGS_NOT_VALID 6629
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS 6630
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS_FOR_CONTENT_TYPE 6631
#define IDS_SETTINGS_RETRY 6632
#define IDS_SETTINGS_SLIDER_MIN_MAX_ARIA_ROLE_DESCRIPTION 6633
#define IDS_SETTINGS_START_TIME 6634
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 6635
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 6636
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 6637
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 6638
#define IDS_SETTINGS_AUTOFILL_AND_PASSWORDS 6639
#define IDS_PASSWORDS_PAGE_IMPORT_AUTHENTICATION_PROMPT_BIOMETRIC_SUFFIX 6640
#define IDS_SETTINGS_GOOGLE_PAYMENTS 6641
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_ADD_TITLE 6642
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EDIT_TITLE 6643
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_COUNTRY 6644
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_PHONE 6645
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EMAIL 6646
#define IDS_SETTINGS_AUTOFILL_ADDRESS_HONORIFIC_LABEL 6647
#define IDS_SETTINGS_AUTOFILL_DETAIL 6648
#define IDS_SETTINGS_AUTOFILL_CARD_DESCRIPTION 6649
#define IDS_SETTINGS_AUTOFILL_CARD_A11Y_LABELED 6650
#define IDS_SETTINGS_AUTOFILL_CARD_EXP_DATE_A11Y_LABELED 6651
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_ADDRESS 6652
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD 6653
#define IDS_AUTOFILL_ADD_VIRTUAL_CARD 6654
#define IDS_AUTOFILL_REMOVE_VIRTUAL_CARD 6655
#define IDS_AUTOFILL_EDIT_SERVER_CREDIT_CARD 6656
#define IDS_AUTOFILL_VIRTUAL_CARD_TURNED_ON_LABEL 6657
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_TITLE 6658
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_LABEL 6659
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_CONFIRM_BUTTON_LABEL 6660
#define IDS_SETTINGS_ADDRESS_REMOVE 6661
#define IDS_SETTINGS_ADDRESS_REMOVE_CONFIRMATION_TITLE 6662
#define IDS_SETTINGS_ADDRESS_REMOVED_MESSAGE 6663
#define IDS_SETTINGS_CREDIT_CARD_CLEAR 6664
#define IDS_SETTINGS_EDIT_CREDIT_CARD_TITLE 6665
#define IDS_SETTINGS_LOCAL_CARD_REMOVE_CONFIRMATION_TITLE 6666
#define IDS_SETTINGS_LOCAL_PAYMENT_METHOD_REMOVE_CONFIRMATION_DESCRIPTION 6667
#define IDS_SETTINGS_PAYMENTS_MANAGE_CREDIT_CARDS 6668
#define IDS_SETTINGS_PAYMENTS_SAVED_TO_THIS_DEVICE_ONLY 6669
#define IDS_SETTINGS_ADD_CREDIT_CARD_TITLE 6670
#define IDS_SETTINGS_MIGRATABLE_CARDS_LABEL 6671
#define IDS_SETTINGS_SINGLE_MIGRATABLE_CARD_INFO 6672
#define IDS_SETTINGS_MULTIPLE_MIGRATABLE_CARDS_INFO 6673
#define IDS_SETTINGS_REMOTE_CREDIT_CARD_LINK_LABEL 6674
#define IDS_SETTINGS_NAME_ON_CREDIT_CARD 6675
#define IDS_SETTINGS_CREDIT_CARD_NUMBER 6676
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_DATE 6677
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_MONTH 6678
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_YEAR 6679
#define IDS_SETTINGS_CREDIT_CARD_EXPIRED 6680
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME 6681
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME_INVALID 6682
#define IDS_SETTINGS_ADD_PAYMENT_METHODS 6683
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_CREDIT_OR_DEBIT_CARD 6684
#define IDS_SETTINGS_ADD_PAYMENT_METHOD_IBAN 6685
#define IDS_SETTINGS_IBAN_SAVED_TO_THIS_DEVICE_ONLY 6686
#define IDS_IBAN_NICKNAME 6687
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_IBAN 6688
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_IBAN_DESCRIPTION 6689
#define IDS_SETTINGS_ADD_IBAN_TITLE 6690
#define IDS_SETTINGS_EDIT_IBAN_TITLE 6691
#define IDS_SETTINGS_IBAN_EDIT 6692
#define IDS_SETTINGS_LOCAL_IBAN_REMOVE_CONFIRMATION_TITLE 6693
#define IDS_SETTINGS_UPI_ID_LABEL 6694
#define IDS_SETTINGS_UPI_ID_EXPIRATION_NEVER 6695
#define IDS_SETTINGS_PASSWORD_MANAGER 6696
#define IDS_SETTINGS_PASSWORD_MANAGER_DESCRIPTION 6697
#define IDS_SETTINGS_DEVICE_PASSWORDS 6698
#define IDS_SETTINGS_DEVICE_PASSWORDS_ON_DEVICE_ONLY_HEADING 6699
#define IDS_SETTINGS_DEVICE_PASSWORDS_ON_DEVICE_AND_ACCOUNT_HEADING 6700
#define IDS_SETTINGS_CHECK_PASSWORDS 6701
#define IDS_SETTINGS_CHECK_PASSWORDS_CANCELED 6702
#define IDS_SETTINGS_CHECKED_PASSWORDS 6703
#define IDS_SETTINGS_CHECK_PASSWORDS_DESCRIPTION 6704
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT 6705
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT_SHORT 6706
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT 6707
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT_SHORT 6708
#define IDS_SETTINGS_REUSED_PASSWORDS_COUNT_SHORT 6709
#define IDS_SETTINGS_INSECURE_PASSWORDS_COUNT 6710
#define IDS_SETTINGS_CHECK_PASSWORDS_AGAIN 6711
#define IDS_SETTINGS_CHECK_PASSWORDS_AGAIN_AFTER_ERROR 6712
#define IDS_SETTINGS_CHECK_PASSWORDS_PROGRESS 6713
#define IDS_SETTINGS_CHECK_PASSWORDS_STOP 6714
#define IDS_SETTINGS_PASSWORDS_JUST_NOW 6715
#define IDS_SETTINGS_COMPROMISED_PASSWORDS 6716
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_ADVICE 6717
#define IDS_SETTINGS_MUTED_PASSWORDS 6718
#define IDS_SETTINGS_WEAK_PASSWORDS 6719
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION 6720
#define IDS_SETTINGS_CHANGE_PASSWORD_BUTTON 6721
#define IDS_SETTINGS_CHANGE_PASSWORD_IN_APP_LABEL 6722
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REASON_LEAKED 6723
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REASON_PHISHED 6724
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REASON_PHISHED_AND_LEAKED 6725
#define IDS_SETTINGS_COMPROMISED_PASSWORD_SHOW 6726
#define IDS_SETTINGS_COMPROMISED_PASSWORD_HIDE 6727
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REMOVE 6728
#define IDS_SETTINGS_COMPROMISED_PASSWORD_MUTE 6729
#define IDS_SETTINGS_COMPROMISED_PASSWORD_UNMUTE 6730
#define IDS_SETTINGS_REMOVE_COMPROMISED_PASSWORD_CONFIRMATION_TITLE 6731
#define IDS_SETTINGS_REMOVE_COMPROMISED_PASSWORD_CONFIRMATION_DESCRIPTION 6732
#define IDS_SETTINGS_COMPROMISED_EDIT_PASSWORD_APP 6733
#define IDS_SETTINGS_COMPROMISED_ALREADY_CHANGED_PASSWORD 6734
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_TITLE 6735
#define IDS_SETTINGS_PASSWORDS_SAVE_PASSWORDS_TOGGLE_LABEL 6736
#define IDS_SETTINGS_PASSWORDS_AUTOSIGNIN_CHECKBOX_LABEL 6737
#define IDS_SETTINGS_PASSWORDS_AUTOSIGNIN_CHECKBOX_DESC 6738
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL 6739
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL_UPDATED 6740
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_SIGNED_OUT_ENABLED_DESC 6741
#define IDS_SETTINGS_PASSWORDS_SAVED_HEADING 6742
#define IDS_SETTINGS_PASSWORDS_EXCEPTIONS_HEADING 6743
#define IDS_SETTINGS_PASSWORDS_DELETE_EXCEPTION 6744
#define IDS_SETTINGS_PASSWORD_REMOVE 6745
#define IDS_SETTINGS_PASSWORD_MOVE_TO_ACCOUNT 6746
#define IDS_SETTINGS_PASSWORD_SEARCH 6747
#define IDS_SETTINGS_PASSWORDS_VIEW_DETAILS_TITLE 6748
#define IDS_SETTINGS_PASSWORD_DETAILS 6749
#define IDS_SETTINGS_PASSWORD_EDIT_TITLE 6750
#define IDS_SETTINGS_PASSWORD_EDIT 6751
#define IDS_SETTINGS_PASSWORD_EDIT_FOOTNOTE 6752
#define IDS_SETTINGS_PASSWORD_USERNAME_ALREADY_USED 6753
#define IDS_SETTINGS_PASSWORD_VIEW_EXISTING_PASSWORD 6754
#define IDS_SETTINGS_PASSWORD_VIEW_EXISTING_PASSWORD_ARIA_DESCRIPTION 6755
#define IDS_SETTINGS_PASSWORD_MISSING_TLD 6756
#define IDS_SETTINGS_PASSWORD_ADD_TITLE 6757
#define IDS_SETTINGS_PASSWORD_ADD_FOOTNOTE 6758
#define IDS_SETTINGS_PASSWORD_STORE_PICKER_OPTION_ACCOUNT 6759
#define IDS_SETTINGS_PASSWORD_COPY 6760
#define IDS_SETTINGS_PASSWORD_SEND 6761
#define IDS_SETTINGS_USERNAME_COPY 6762
#define IDS_SETTINGS_PASSWORDS_WEBSITE 6763
#define IDS_SETTINGS_PASSWORDS_ANDROID_APP 6764
#define IDS_SETTINGS_PASSWORDS_USERNAME 6765
#define IDS_SETTINGS_PASSWORDS_PASSWORD 6766
#define IDS_SETTINGS_PASSWORDS_NOTE 6767
#define IDS_SETTINGS_PASSWORDS_NO_NOTE_ADDED 6768
#define IDS_SETTINGS_PASSWORDS_NOTE_CHARACTER_COUNT 6769
#define IDS_SETTINGS_PASSWORDS_NOTE_CHARACTER_COUNT_WARNING 6770
#define IDS_SETTINGS_PASSWORDS_TIMED_OUT 6771
#define IDS_SETTINGS_PASSWORDS_TIMED_OUT_DESCRIPTION 6772
#define IDS_SETTINGS_PASSKEYS_LENGTH_ERROR 6773
#define IDS_SETTINGS_PASSKEYS_SITE_LABEL 6774
#define IDS_SETTINGS_PASSKEYS_DIALOG_TITLE 6775
#define IDS_SETTINGS_PASSKEYS_EDIT_DIALOG_FOOTNOTE 6776
#define IDS_SETTINGS_ADDRESS_NONE 6777
#define IDS_SETTINGS_PAYMENT_METHODS_NONE 6778
#define IDS_SETTINGS_PASSWORDS_NONE 6779
#define IDS_SETTINGS_PASSWORDS_NONE_WITH_IMPORT 6780
#define IDS_SETTINGS_PASSWORDS_EXCEPTIONS_NONE 6781
#define IDS_SETTINGS_PASSWORD_UNDO 6782
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD 6783
#define IDS_SETTINGS_PASSWORD_STORED_ON_DEVICE 6784
#define IDS_SETTINGS_PASSWORD_STORED_IN_ACCOUNT 6785
#define IDS_SETTINGS_PASSWORD_STORED_IN_ACCOUNT_AND_ON_DEVICE 6786
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD_FROM_ACCOUNT 6787
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD_FROM_DEVICE 6788
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD_FROM_ACCOUNT_AND_DEVICE 6789
#define IDS_SETTINGS_PASSWORD_COPIED_TO_CLIPBOARD 6790
#define IDS_SETTINGS_PASSWORD_USERNAME_COPIED_TO_CLIPBOARD 6791
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT 6792
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_COUNT 6793
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_DIALOG_BODY_TEXT 6794
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_DIALOG_TITLE 6795
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_SNACKBAR 6796
#define IDS_SETTINGS_PASSWORD_MOVE_MULTIPLE_PASSWORDS_TO_ACCOUNT_DIALOG_MOVE_BUTTON_TEXT 6797
#define IDS_SETTINGS_PASSWORD_MOVE_MULTIPLE_PASSWORDS_TO_ACCOUNT_DIALOG_CANCEL_BUTTON_TEXT 6798
#define IDS_SETTINGS_PASSWORD_OPEN_MOVE_MULTIPLE_PASSWORDS_TO_ACCOUNT_DIALOG_BUTTON_TEXT 6799
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_TITLE 6800
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_BODY 6801
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_REMOVE_BUTTON_TEXT 6802
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_CANCEL_BUTTON_TEXT 6803
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_FROM_ACCOUNT_CHECKBOX_LABEL 6804
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_FROM_DEVICE_CHECKBOX_LABEL 6805
#define IDS_SETTINGS_DEVICE_PASSWORDS_LINK_LABEL 6806
#define IDS_SETTINGS_PASSWORDS_MANAGE_PASSWORDS_PLAINTEXT 6807
#define IDS_SETTINGS_PASSWORDS_OPT_IN_ACCOUNT_STORAGE_BODY 6808
#define IDS_SETTINGS_PASSWORDS_OPT_IN_ACCOUNT_STORAGE_LABEL 6809
#define IDS_SETTINGS_PASSWORDS_OPT_OUT_ACCOUNT_STORAGE_BODY 6810
#define IDS_SETTINGS_PASSWORDS_OPT_OUT_ACCOUNT_STORAGE_LABEL 6811
#define IDS_SETTINGS_PASSWORDS_IMPORT_MENU_ITEM 6812
#define IDS_SETTINGS_PASSWORDS_IMPORT_TITLE 6813
#define IDS_SETTINGS_PASSWORDS_IMPORT_SUCCESS_TITLE 6814
#define IDS_SETTINGS_PASSWORDS_IMPORT_COMPLETE_TITLE 6815
#define IDS_SETTINGS_PASSWORDS_IMPORT_ERROR_TITLE 6816
#define IDS_SETTINGS_PASSWORDS_IMPORT_CHOOSE_FILE 6817
#define IDS_SETTINGS_PASSWORDS_IMPORT_DESCRIPTION_ACCOUNT_STORE_USERS 6818
#define IDS_SETTINGS_PASSWORDS_IMPORT_DESCRIPTION_SYNCING_USERS 6819
#define IDS_SETTINGS_PASSWORDS_IMPORT_DESCRIPTION_SIGNEDOUT_USERS 6820
#define IDS_SETTINGS_PASSWORDS_IMPORT_SUCCESS_SUMMARY_DEVICE 6821
#define IDS_SETTINGS_PASSWORDS_IMPORT_SUCCESS_SUMMARY_ACCOUNT 6822
#define IDS_SETTINGS_PASSWORDS_IMPORT_STORE_PICKER_ACCESSIBLE_NAME 6823
#define IDS_SETTINGS_PASSWORDS_IMPORT_SUCCESS_TIP 6824
#define IDS_SETTINGS_PASSWORDS_IMPORT_DELETE_FILE_OPTION 6825
#define IDS_SETTINGS_PASSWORDS_IMPORT_ERROR_UNKNOWN 6826
#define IDS_SETTINGS_PASSWORDS_IMPORT_ERROR_BAD_FORMAT 6827
#define IDS_SETTINGS_PASSWORDS_IMPORT_FILE_SIZE_EXCEEDED 6828
#define IDS_SETTINGS_PASSWORDS_IMPORT_ERROR_LIMIT_EXCEEDED 6829
#define IDS_SETTINGS_PASSWORDS_IMPORT_MISSING_PASSWORD 6830
#define IDS_SETTINGS_PASSWORDS_IMPORT_MISSING_URL 6831
#define IDS_SETTINGS_PASSWORDS_IMPORT_INVALID_URL 6832
#define IDS_SETTINGS_PASSWORDS_IMPORT_BAD_ROWS_FORMAT 6833
#define IDS_SETTINGS_PASSWORDS_IMPORT_LONG_URL 6834
#define IDS_SETTINGS_PASSWORDS_IMPORT_LONG_USERNAME 6835
#define IDS_SETTINGS_PASSWORDS_IMPORT_LONG_PASSWORD 6836
#define IDS_SETTINGS_PASSWORDS_IMPORT_LONG_NOTE 6837
#define IDS_SETTINGS_PASSWORDS_IMPORT_CONFLICT_ACCOUNT 6838
#define IDS_SETTINGS_PASSWORDS_IMPORT_CONFLICT_DEVICE 6839
#define IDS_SETTINGS_PASSWORDS_IMPORT_FAILURES_SUMMARY 6840
#define IDS_SETTINGS_PASSWORDS_IMPORT_CONFLICTS_TITLE 6841
#define IDS_SETTINGS_PASSWORDS_IMPORT_CONFLICTS_DESCRIPTION 6842
#define IDS_SETTINGS_PASSWORDS_IMPORT_CANCEL 6843
#define IDS_SETTINGS_PASSWORDS_IMPORT_SKIP 6844
#define IDS_SETTINGS_PASSWORDS_IMPORT_REPLACE 6845
#define IDS_SETTINGS_PASSWORDS_IMPORT_ALREADY_ACTIVE 6846
#define IDS_SETTINGS_PASSWORDS_EXPORT_MENU_ITEM 6847
#define IDS_SETTINGS_PASSWORDS_EXPORT_TITLE 6848
#define IDS_SETTINGS_PASSWORDS_EXPORT_DESCRIPTION 6849
#define IDS_SETTINGS_PASSWORDS_EXPORT 6850
#define IDS_SETTINGS_PASSWORDS_EXPORT_TRY_AGAIN 6851
#define IDS_SETTINGS_PASSWORDS_EXPORTING_TITLE 6852
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TITLE 6853
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TIPS 6854
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TIP_ENOUGH_SPACE 6855
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TIP_ANOTHER_FOLDER 6856
#define IDS_SETTINGS_PASSWORD_ROW_MORE_ACTIONS 6857
#define IDS_SETTINGS_PASSWORD_ROW_FEDERATED_MORE_ACTIONS 6858
#define IDS_SETTINGS_PASSWORD_TABLE_ARIA_LABEL 6859
#define IDS_SETTINGS_PASSWORD_ROW_PASSWORD_DETAIL_PAGE 6860
#define IDS_SETTINGS_TRUSTED_VAULT_BANNER_LABEL 6861
#define IDS_SETTINGS_TRUSTED_VAULT_BANNER_SUB_LABEL_OFFER_OPT_IN 6862
#define IDS_SETTINGS_TRUSTED_VAULT_BANNER_SUB_LABEL_OPTED_IN 6863
#define IDS_AUTOFILL_MANAGE_PASSKEYS_LABEL 6864
#define IDS_AUTOFILL_MANAGE_PASSKEYS_NO_SUPPORT 6865
#define IDS_AUTOFILL_MANAGE_PASSKEYS_TITLE 6866
#define IDS_AUTOFILL_MANAGE_PASSKEYS_SUB_TITLE_WIN 6867
#define IDS_AUTOFILL_MANAGE_PASSKEYS_SEARCH 6869
#define IDS_AUTOFILL_MANAGE_PASSKEYS_DELETE_CONFIRMATION_TITLE 6870
#define IDS_AUTOFILL_MANAGE_PASSKEYS_DELETE_CONFIRMATION_DESCRIPTION 6871
#define IDS_AUTOFILL_MANAGE_PASSKEYS_CANNOT_DELETE_TITLE 6872
#define IDS_AUTOFILL_MANAGE_PASSKEYS_CANNOT_DELETE_BODY 6873
#define IDS_AUTOFILL_MANAGE_PASSKEYS_MORE_ACTIONS_LABEL 6874
#define IDS_SETTINGS_PASSWORD_SHOW_PASSWORD_A11Y 6875
#define IDS_SETTINGS_PASSWORD_HIDE_PASSWORD_A11Y 6876
#define IDS_SETTINGS_PASSWORDS_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_LABEL_WIN 6878
#define IDS_SETTINGS_DEFAULT_BROWSER 6879
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT_BUTTON 6880
#define IDS_SETTINGS_CLEAR_PERIOD_TITLE 6959
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC 6960
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_ERROR 6961
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PASSPHRASE_ERROR 6962
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PAUSED 6963
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY 6964
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC 6965
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_WITH_EXCEPTION 6966
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_MAIN_PROFILE 6967
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_SUPERVISED_PROFILE 6968
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY 6969
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY_SIGNED_IN_NO_LINK 6970
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_GOOGLE_DSE 6971
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_NON_GOOGLE_DSE 6972
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_PREPOPULATED_DSE 6973
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_NON_PREPOPULATED_DSE 6974
#define IDS_SETTINGS_CLEAR_DOWNLOAD_HISTORY 6975
#define IDS_SETTINGS_CLEAR_CACHE 6976
#define IDS_SETTINGS_CLEAR_COOKIES 6977
#define IDS_SETTINGS_CLEAR_PASSWORDS 6978
#define IDS_SETTINGS_CLEAR_FORM_DATA 6979
#define IDS_SETTINGS_CLEAR_HOSTED_APP_DATA 6980
#define IDS_SETTINGS_CLEAR_PERIOD_HOUR 6981
#define IDS_SETTINGS_CLEAR_PERIOD_24_HOURS 6982
#define IDS_SETTINGS_CLEAR_PERIOD_7_DAYS 6983
#define IDS_SETTINGS_CLEAR_PERIOD_FOUR_WEEKS 6984
#define IDS_SETTINGS_CLEAR_PERIOD_EVERYTHING 6985
#define IDS_SETTINGS_NOTIFICATION_WARNING 6986
#define IDS_SETTINGS_DOWNLOADS 6987
#define IDS_SETTINGS_DOWNLOAD_LOCATION 6988
#define IDS_SETTINGS_CHANGE_DOWNLOAD_LOCATION 6989
#define IDS_SETTINGS_PROMPT_FOR_DOWNLOAD 6990
#define IDS_SETTINGS_OPEN_FILE_TYPES_AUTOMATICALLY 6991
#define IDS_SETTINGS_DOWNLOADS_SHOW_WHEN_FINISHED 6992
#define IDS_SETTINGS_ON_STARTUP 6993
#define IDS_SETTINGS_ON_STARTUP_OPEN_NEW_TAB 6994
#define IDS_SETTINGS_ON_STARTUP_CONTINUE 6995
#define IDS_SETTINGS_ON_STARTUP_OPEN_SPECIFIC 6996
#define IDS_SETTINGS_ON_STARTUP_CONTINUE_AND_OPEN_SPECIFIC 6997
#define IDS_SETTINGS_ON_STARTUP_USE_CURRENT 6998
#define IDS_SETTINGS_ON_STARTUP_ADD_NEW_PAGE 6999
#define IDS_SETTINGS_ON_STARTUP_EDIT_PAGE 7000
#define IDS_SETTINGS_ON_STARTUP_SITE_URL 7001
#define IDS_SETTINGS_ON_STARTUP_REMOVE 7002
#define IDS_SETTINGS_ON_STARTUP_PAGE_TOOLTIP 7003
#define IDS_SETTINGS_INVALID_URL 7004
#define IDS_SETTINGS_URL_TOOL_LONG 7005
#define IDS_SETTINGS_PERFORMANCE_PAGE_TITLE 7006
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_SETTING 7007
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_HEURISTICS_LABEL 7008
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_RECOMMENDED_BADGE 7009
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_ON_TIMER_LABEL 7010
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_RADIO_GROUP_ARIA_LABEL 7011
#define IDS_SETTINGS_PERFORMANCE_HIGH_EFFICIENCY_MODE_CHOOSE_DISCARD_TIME_ARIA_LABEL 7012
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_BUTTON_ARIA_LABEL 7013
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_SAVE_BUTTON_ARIA_LABEL 7014
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_HEADER 7015
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADDITIONAL_SITES 7016
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_CURRENT_TABS 7017
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_MANUAL 7018
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ACTIVE_SITE_ARIA_DESCRIPTION 7019
#define IDS_SETTINGS_PERFORMANCE_TAB_DISCARDING_EXCEPTIONS_ADD_DIALOG_HELP 7020
#define IDS_SETTINGS_BATTERY_PAGE_TITLE 7021
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_SETTING 7022
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_ON_BATTERY_LABEL 7023
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_BELOW_THRESHOLD_LABEL 7024
#define IDS_SETTINGS_PERFORMANCE_BATTERY_SAVER_MODE_RADIO_GROUP_ARIA_LABEL 7025
#define IDS_SETTINGS_LANGUAGES_PAGE_TITLE 7026
#define IDS_SETTINGS_LANGUAGES_CARD_TITLE 7027
#define IDS_SETTINGS_LANGUAGE_SEARCH 7028
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_TO_TOP 7029
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_UP 7030
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_DOWN 7031
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_REMOVE 7032
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_ADD 7033
#define IDS_SETTINGS_LANGUAGES_MANAGE_LANGUAGES_TITLE 7034
#define IDS_SETTINGS_LANGUAGES_NO_LANGUAGES_ADDED 7035
#define IDS_SETTINGS_LANGUAGES_EXPAND_ACCESSIBILITY_LABEL 7036
#define IDS_SETTINGS_LANGUAGES_PREFERRED_LANGUAGES_DESC 7037
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE 7038
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE_SUBLABEL 7039
#define IDS_SETTINGS_LANGUAGES_TRANSLATE_TARGET 7040
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_TITLE 7041
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_BODY 7042
#define IDS_SETTINGS_LANGUAGES_ADD_ARIA_LABEL 7043
#define IDS_SETTINGS_LANGUAGES_REMOVE_AUTOMATIC_ARIA_LABEL 7044
#define IDS_SETTINGS_LANGUAGES_REMOVE_NEVER_ARIA_LABEL 7045
#define IDS_SETTINGS_TRANSLATE_PAGE_TITLE 7046
#define IDS_SETTINGS_TARGET_TRANSLATE_LABEL 7047
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE 7048
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE_ADD_ARIA_LABEL 7049
#define IDS_SETTINGS_LANGUAGES_NEVER_LANGUAGES 7050
#define IDS_SETTINGS_LANGUAGES_NEVER_TRANSLATE_ADD_ARIA_LABEL 7051
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_TITLE 7052
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_BASIC_LABEL 7053
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_LABEL 7054
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_DESCRIPTION 7055
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_SPELL_CHECK 7056
#define IDS_SETTING_LANGUAGES_SPELL_CHECK_DISABLED_REASON 7057
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_LANGUAGES_LIST_TITLE 7058
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_MANAGE 7059
#define IDS_SETTINGS_LANGUAGES_EDIT_DICTIONARY_TITLE 7060
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD 7061
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_BUTTON 7062
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_DUPLICATE_ERROR 7063
#define IDS_SETTINGS_LANGUAGES_ADD_DICTIONARY_WORD_LENGTH_ERROR 7064
#define IDS_SETTINGS_LANGUAGES_DELETE_DICTIONARY_WORD_BUTTON 7065
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS 7066
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_WORDS_NONE 7067
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED 7068
#define IDS_SETTINGS_LANGUAGES_DICTIONARY_DOWNLOAD_FAILED_HELP 7069
#define IDS_SETTINGS_PRELOAD_PAGES_TITLE 7072
#define IDS_SETTINGS_PRELOAD_PAGES_SUMMARY 7073
#define IDS_SETTINGS_PRELOAD_PAGES_NO_PRELOADING_TITLE 7074
#define IDS_SETTINGS_PRELOAD_PAGES_NO_PRELOADING_SUMMARY 7075
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_TITLE 7076
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_SUMMARY 7077
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_ONE 7078
#define IDS_SETTINGS_PRELOAD_PAGES_STANDARD_PRELOADING_WHEN_ON_BULLET_TWO 7079
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_TITLE 7080
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_SUMMARY 7081
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_ONE 7082
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_WHEN_ON_BULLET_TWO 7083
#define IDS_SETTINGS_PRELOAD_PAGES_EXTENDED_PRELOADING_THINGS_TO_CONSIDER_BULLET_TWO 7084
#define IDS_SETTINGS_PRELOAD_PAGES_THINGS_TO_CONSIDER_BULLET_ONE 7085
#define IDS_SETTINGS_PRIVACY 7086
#define IDS_SETTINGS_PRIVACY_V2 7087
#define IDS_SETTINGS_PRIVACY_MORE 7088
#define IDS_SETTINGS_ANTI_ABUSE_ENABLED_SUB_LABEL 7090
#define IDS_SETTINGS_ANTI_ABUSE_DISABLED_SUB_LABEL 7091
#define IDS_SETTINGS_ANTI_ABUSE_DESCRIPTION 7092
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_HEADER 7093
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_ONE 7094
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_TWO 7095
#define IDS_SETTINGS_ANTI_ABUSE_WHEN_ON_SECTION_THREE 7096
#define IDS_SETTINGS_ANTI_ABUSE_THINGS_TO_CONSIDER_HEADER 7097
#define IDS_SETTINGS_ANTI_ABUSE_THINGS_TO_CONSIDER_SECTION_ONE 7098
#define IDS_SETTINGS_PRIVACY_SANDBOX_TITLE 7099
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_HEADING 7100
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_DETAILS 7101
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_ENABLED 7102
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_DISABLED 7103
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG 7104
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG_MORE 7105
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_TITLE 7106
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_SUMMARY 7107
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_SUMMARY_LEARN_MORE 7108
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_TITLE 7109
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_SUMMARY 7110
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_TITLE 7111
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_SUMMARY 7112
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_TITLE 7113
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_SUMMARY 7114
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TITLE 7115
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_TITLE 7116
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_DATA_TYPES 7117
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_DATA_USAGE 7118
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_DATA_MANAGEMENT 7119
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_MANAGEMENT 7120
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TITLE 7121
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_REMOVED_DIALOG_TITLE 7122
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_REMOVED_DIALOG_DESCRIPTION 7123
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_EMPTY 7124
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_TOPICS_LABEL 7125
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_TOPICS_EMPTY 7126
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_TITLE 7127
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_EMPTY 7128
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_FLEDGE_LABEL 7129
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_FLEDGE_EMPTY 7130
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_2 7131
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_3 7132
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_TITLE 7133
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_CONTROL_MEASUREMENT 7134
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_TITLE 7135
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_1 7136
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_1_TRIALS_OFF 7137
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_2 7138
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_3 7139
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_LABEL 7140
#define IDS_SETTINGS_AD_PRIVACY_LINK_ROW_SUB_LABEL 7141
#define IDS_SETTINGS_AD_PRIVACY_RESTRICTED_LINK_ROW_SUB_LABEL 7142
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TITLE 7143
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_LABEL 7144
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_ENABLED 7145
#define IDS_SETTINGS_AD_PRIVACY_PAGE_TOPICS_LINK_ROW_SUB_LABEL_DISABLED 7146
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_LABEL 7147
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_ENABLED 7148
#define IDS_SETTINGS_AD_PRIVACY_PAGE_FLEDGE_LINK_ROW_SUB_LABEL_DISABLED 7149
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_LABEL 7150
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_ENABLED 7151
#define IDS_SETTINGS_AD_PRIVACY_PAGE_AD_MEASUREMENT_LINK_ROW_SUB_LABEL_DISABLED 7152
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION 7153
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_LEARN_MORE_A11Y_LABEL 7154
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_DESCRIPTION_LEARN_MORE_LINK 7155
#define IDS_SETTINGS_TOPICS_PAGE_CURRENT_TOPICS_REGION_A11Y_DESCRIPTION 7156
#define IDS_SETTINGS_TOPICS_PAGE_BLOCKED_TOPICS_REGION_A11Y_DESCRIPTION 7157
#define IDS_SETTINGS_TOPICS_PAGE_LEARN_MORE_BULLET_3 7158
#define IDS_SETTINGS_TOPICS_PAGE_FOOTER 7159
#define IDS_SETTINGS_FLEDGE_PAGE_TITLE 7160
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_LABEL 7161
#define IDS_SETTINGS_FLEDGE_PAGE_TOGGLE_SUB_LABEL 7162
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_HEADING 7163
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION 7164
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE 7165
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_DISABLED 7166
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_EMPTY 7167
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_REGION_A11Y_DESCRIPTION 7168
#define IDS_SETTINGS_FLEDGE_PAGE_SEE_ALL_SITES_LABEL 7169
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE 7170
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCK_SITE_A11Y_LABEL 7171
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_HEADING 7172
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION 7173
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_DESCRIPTION_EMPTY 7174
#define IDS_SETTINGS_FLEDGE_PAGE_BLOCKED_SITES_REGION_A11Y_DESCRIPTION 7175
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE 7176
#define IDS_SETTINGS_FLEDGE_PAGE_ALLOW_SITE_A11Y_LABEL 7177
#define IDS_SETTINGS_FLEDGE_PAGE_FOOTER 7178
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_HEADING 7179
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_1 7180
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_2 7181
#define IDS_SETTINGS_FLEDGE_PAGE_LEARN_MORE_BULLET_3 7182
#define IDS_SETTINGS_FLEDGE_PAGE_CURRENT_SITES_DESCRIPTION_LEARN_MORE_A11Y_LABEL 7183
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TITLE 7184
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_LABEL 7185
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_TOGGLE_SUB_LABEL 7186
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_HEADING 7187
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_HEADING 7188
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_1 7189
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_2 7190
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_ENABLED_BULLET_3 7191
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_1 7192
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_2 7193
#define IDS_SETTINGS_AD_MEASUREMENT_PAGE_CONSIDER_BULLET_3 7194
#define IDS_SETTINGS_PRIVACY_GUIDE_LABEL 7195
#define IDS_SETTINGS_PRIVACY_GUIDE_SUBLABEL 7196
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_HEADER 7197
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_START_BUTTON 7198
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_LABEL 7199
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_ROLE_DESC 7200
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_BUTTON 7201
#define IDS_SETTINGS_PRIVACY_GUIDE_STEPS 7202
#define IDS_SETTINGS_PRIVACY_GUIDE_NEXT_BUTTON 7203
#define IDS_SETTINGS_PRIVACY_GUIDE_FEATURE_DESCRIPTION_HEADER 7204
#define IDS_SETTINGS_PRIVACY_GUIDE_THINGS_TO_CONSIDER 7205
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_HEADER 7206
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_SUB_HEADER 7207
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_HEADER 7208
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER 7209
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER_NO_LINKS 7210
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_LEAVE_BUTTON 7211
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_LABEL 7212
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_LABEL 7213
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_CARD_HEADER 7214
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION1 7215
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION2 7216
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION1 7217
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_CARD_HEADER 7218
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_SETTING_LABEL 7219
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION1 7220
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION2 7221
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_PRIVACY_DESCRIPTION1 7222
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_HEADER 7223
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_SUBHEADER 7224
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION1 7225
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION2 7226
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION1 7227
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION2 7228
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_SUBHEADER 7229
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION1 7230
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION2 7231
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_PRIVACY_DESCRIPTION1 7232
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_HEADER 7233
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION1 7234
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION2 7235
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION3 7236
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION1 7237
#define IDS_SETTINGS_PRIVACY_GUIDE_SEARCH_SUGGESTIONS_CARD_HEADER 7238
#define IDS_SETTINGS_PRIVACY_SEARCH_SUGGESTIONS_FEATURE_DESCRIPTION1 7239
#define IDS_SETTINGS_PRIVACY_SEARCH_SUGGESTIONS_PRIVACY_DESCRIPTION1 7240
#define IDS_SETTINGS_SAFETY_CHECK_SECTION_TITLE 7241
#define IDS_SETTINGS_SAFETY_CHECK_RUNNING 7242
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER 7243
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_MINS 7244
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_HOURS 7245
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_TIME 7246
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_TODAY 7247
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_YESTERDAY 7248
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_DAYS 7249
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_DATE 7250
#define IDS_SETTINGS_SAFETY_CHECK_ARIA_LIVE_RUNNING 7251
#define IDS_SETTINGS_SAFETY_CHECK_ARIA_LIVE_AFTER 7252
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_BUTTON 7253
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_BUTTON_ARIA_LABEL 7254
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_RUN_AGAIN_BUTTON_ARIA_LABEL 7255
#define IDS_SETTINGS_SAFETY_CHECK_ICON_RUNNING_ARIA_LABEL 7256
#define IDS_SETTINGS_SAFETY_CHECK_ICON_SAFE_ARIA_LABEL 7257
#define IDS_SETTINGS_SAFETY_CHECK_ICON_INFO_ARIA_LABEL 7258
#define IDS_SETTINGS_SAFETY_CHECK_ICON_WARNING_ARIA_LABEL 7259
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW 7260
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_ARIA_LABEL 7261
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_ALLOW_AGAIN_LABEL 7262
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_HEADER_ARIA_LABEL 7263
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_HEADER_LABEL 7264
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_ONE_PERMISSION_LABEL 7265
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_TWO_PERMISSIONS_LABEL 7266
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_THREE_PERMISSIONS_LABEL 7267
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_REMOVED_FOUR_OR_MORE_PERMISSIONS_LABEL 7268
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_PRIMARY_LABEL 7269
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SECONDARY_LABEL 7270
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_BULK_LABEL 7271
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_TOAST_LABEL 7272
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_LABEL 7273
#define IDS_SETTINGS_SAFETY_CHECK_UNUSED_SITE_PERMISSIONS_SETTING_SUBLABEL 7274
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_PRIMARY_LABEL 7275
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_DISABLED_BY_ADMIN 7276
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_PRIMARY_LABEL 7277
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_FEATURE_UNAVAILABLE 7278
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_BUTTON_ARIA_LABEL 7279
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED 7280
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD 7281
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD_AVAILABLE_ENHANCED 7282
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_ENHANCED 7283
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED_BY_ADMIN 7284
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED_BY_EXTENSION 7285
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_BUTTON 7286
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_BUTTON_ARIA_LABEL 7287
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_PRIMARY_LABEL 7288
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_SAFE 7289
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_OFF 7290
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_USER 7291
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_ADMIN 7292
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BUTTON_ARIA_LABEL 7293
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_EXTENSIONS 7294
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_PRIMARY_LABEL 7295
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSIONS_REVIEW_BUTTON_ARIA_LABEL 7296
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_SECONDARY_LABEL 7297
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_IGNORED_TOAST_LABEL 7298
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCKED_TOAST_LABEL 7299
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_RESET_TOAST_LABEL 7300
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_COUNT_LABEL 7301
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_LABEL 7302
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_DONT_ALLOW_ARIA_LABEL 7303
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_LABEL 7304
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_IGNORE_ARIA_LABEL 7305
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_LABEL 7306
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_RESET_ARIA_LABEL 7307
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_MORE_ACTIONS_ARIA_LABEL 7308
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW_NOTIFICATION_PERMISSIONS_HEADER_LABEL 7309
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_LABEL 7310
#define IDS_SETTINGS_SAFETY_CHECK_NOTIFICATION_PERMISSION_REVIEW_BLOCK_ALL_TOAST_LABEL 7311
#define IDS_SETTINGS_SAFETY_CHECK_SITE_PERMISSIONS_REVIEW_DONE_LABEL 7312
#define IDS_SETTINGS_SAFETY_CHECK_TOAST_UNDO_BUTTON_LABEL 7313
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_LABEL 7314
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC 7315
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC_COOKIES_PAGE 7316
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION 7317
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION_DESC 7318
#define IDS_SETTINGS_SAFEBROWSING_ENABLE_REPORTING_DESC 7319
#define IDS_SETTINGS_SAFEBROWSING_SECTION_LABEL 7320
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED 7321
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC 7322
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_EXPAND_ACCESSIBILITY_LABEL 7323
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_ONE 7324
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_THREE 7325
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FOUR 7326
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FIVE 7327
#define IDS_SETTINGS_SAFEBROWSING_STANDARD 7328
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC 7329
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC_UPDATED 7330
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_EXPAND_ACCESSIBILITY_LABEL 7331
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_ONE 7332
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_HELP_IMPROVE 7333
#define IDS_SETTINGS_SAFEBROWSING_NONE 7334
#define IDS_SETTINGS_SAFEBROWSING_NONE_DESC 7335
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_TITLE 7336
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_DESC 7337
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_CONFIRM 7338
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK 7339
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TITLE 7340
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TEXT 7341
#define IDS_SETTINGS_PERMISSIONS 7342
#define IDS_SETTINGS_PERMISSIONS_DESCRIPTION 7343
#define IDS_SETTINGS_SECURITY 7344
#define IDS_SETTINGS_SECURITY_DESCRIPTION 7345
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM 7346
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM_DESC 7347
#define IDS_SETTINGS_HTTPS_ONLY_MODE 7348
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION 7349
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION_ADVANCED_PROTECTION 7350
#define IDS_SETTINGS_MANAGE_CERTIFICATES 7351
#define IDS_SETTINGS_MANAGE_CERTIFICATES_DESCRIPTION 7352
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES 7353
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES_DESCRIPTION 7354
#define IDS_SETTINGS_MANAGE 7355
#define IDS_SETTINGS_SECURE_DNS 7356
#define IDS_SETTINGS_SECURE_DNS_DESCRIPTION 7357
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION 7359
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION_SECONDARY 7360
#define IDS_SETTINGS_SECURE_MODE_DESCRIPTION_ACCESSIBILITY_LABEL 7361
#define IDS_SETTINGS_SECURE_DNS_DROPDOWN_ACCESSIBILITY_LABEL 7362
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_DESCRIPTION 7363
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_PRIVACY_POLICY 7364
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_MANAGED_ENVIRONMENT 7365
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_PARENTAL_CONTROL 7366
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_PLACEHOLDER 7367
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_FORMAT_ERROR 7368
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_CONNECTION_ERROR 7369
#define IDS_SETTINGS_CONTENT_SETTINGS 7370
#define IDS_SETTINGS_SITE_SETTINGS 7371
#define IDS_SETTINGS_SITE_SETTINGS_DESCRIPTION 7372
#define IDS_SETTINGS_CLEAR_DATA 7373
#define IDS_SETTINGS_CLEARING_DATA 7374
#define IDS_SETTINGS_CLEARED_DATA 7375
#define IDS_SETTINGS_CLEAR_BROWSING_DATA 7376
#define IDS_SETTINGS_CLEAR_DATA_DESCRIPTION 7377
#define IDS_SETTINGS_TITLE_AND_COUNT 7378
#define IDS_SETTINGS_SYNC_AND_GOOGLE_SERVICES_PRIVACY_DESC_UNIFIED_CONSENT 7379
#define IDS_SETTINGS_RECENT_PERMISSIONS_NO_CHANGES 7380
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_ONE_ITEM 7381
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_TWO_ITEMS 7382
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_MORE_THAN_TWO_ITEMS 7383
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_ONE_ITEM 7384
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_TWO_ITEMS 7385
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_MORE_THAN_TWO_ITEMS 7386
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_ONE_ITEM 7387
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_TWO_ITEMS 7388
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_MORE_THAN_TWO_ITEMS 7389
#define IDS_SETTINGS_RESET_PROMPT_TITLE 7390
#define IDS_SETTINGS_RESET 7391
#define IDS_SETTINGS_RESET_SETTINGS_TRIGGER 7392
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_TITLE 7393
#define IDS_SETTINGS_RESET_BANNER_TEXT 7394
#define IDS_SETTINGS_RESET_BANNER_RESET_BUTTON_TEXT 7395
#define IDS_SETTINGS_RESET_LEARN_MORE_ACCESSIBILITY_TEXT 7396
#define IDS_SETTINGS_SEARCH 7399
#define IDS_SETTINGS_SEARCH_EXPLANATION 7400
#define IDS_SETTINGS_SEARCH_EXPLANATION_ACCESSIBILITY_LABEL 7401
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES 7402
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 7403
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_EXPLANATION 7404
#define IDS_SETTINGS_SEARCH_ENGINES 7405
#define IDS_SETTINGS_SEARCH_ENGINES_PAGE_EXPLANATION 7406
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH 7407
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SEARCH_ENGINE 7408
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE 7409
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_TITLE 7410
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_DESCRIPTION 7411
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES 7412
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES_EXPLANATION 7413
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH 7414
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION 7415
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION_STARTER_PACK 7416
#define IDS_SETTINGS_SEARCH_ENGINES_NO_SITES_ADDED 7417
#define IDS_SETTINGS_SEARCH_ENGINES_INACTIVE_SHORTCUTS 7418
#define IDS_SETTINGS_SEARCH_ENGINES_NO_OTHER_ENGINES 7419
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES 7420
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES_EXPLANATION 7421
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINE 7422
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_OR_PAGE 7423
#define IDS_SETTINGS_SEARCH_ENGINES_SHORTCUT 7424
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL 7425
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL_EXPLANATION 7426
#define IDS_SETTINGS_SEARCH_ENGINES_MAKE_DEFAULT 7427
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE 7428
#define IDS_SETTINGS_SEARCH_ENGINES_DEACTIVATE 7429
#define IDS_SETTINGS_SEARCH_ENGINES_MANAGE_EXTENSION 7430
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TITLE 7431
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION 7432
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION_STARTER_PACK 7433
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_SPACE_OR_TAB 7434
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TAB 7435
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_SITES 7436
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_INACTIVE_SITES 7437
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_HOST 7438
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_ANY_HOST 7439
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES 7440
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_DESCRIPTION 7441
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SEARCH 7442
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT 7443
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_MOST_VISITED 7444
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_STORAGE 7445
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_NAME 7446
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_EDIT_HEADER 7447
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANT_LABEL 7448
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_REMOVE_GRANTS 7449
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_HEADER 7450
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_SITE_LIST_VIEW_SITE_DETAILS 7451
#define IDS_SETTINGS_SITE_SETTINGS_SITE_ENTRY_PARTITIONED_LABEL 7452
#define IDS_SETTINGS_SITE_SETTINGS_SITE_REPRESENTATION_SEPARATOR 7453
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR 7454
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR_DESCRIPTION 7455
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DEFAULT_BEHAVIOR_DESC 7456
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS 7457
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION 7458
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION_SHORT 7459
#define IDS_SETTINGS_SITE_SETTINGS_ADS_DESCRIPTION 7460
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED 7461
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED 7462
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED_EXCEPTIONS 7463
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED_EXCEPTIONS 7464
#define IDS_SETTINGS_SITE_SETTINGS_AR_DESCRIPTION 7465
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED 7466
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED 7467
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED_EXCEPTIONS 7468
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED_EXCEPTIONS 7469
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_DESCRIPTION 7470
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED 7471
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED 7472
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED_EXCEPTIONS 7473
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED_EXCEPTIONS 7474
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_DESCRIPTION 7475
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED 7476
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED 7477
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_SUB_LABEL 7478
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED_EXCEPTIONS 7479
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_EXCEPTIONS 7480
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_DESCRIPTION 7481
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_ALLOWED 7482
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_BLOCKED 7483
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_DESCRIPTION 7484
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED 7485
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED 7486
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_SUB_LABEL 7487
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED_EXCEPTIONS 7488
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_EXCEPTIONS 7489
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_DESCRIPTION 7490
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED 7491
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED 7492
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED_EXCEPTIONS 7493
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED_EXCEPTIONS 7494
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_DESCRIPTION 7495
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED 7496
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED 7497
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED_EXCEPTIONS 7498
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED_EXCEPTIONS 7499
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_DESCRIPTION 7500
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED 7501
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED 7502
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED_EXCEPTIONS 7503
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED_EXCEPTIONS 7504
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_DESCRIPTION 7505
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_ALLOWED 7506
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED 7507
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED_EXCEPTIONS 7508
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_DESCRIPTION 7509
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED 7510
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED 7511
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED_EXCEPTIONS 7512
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED_EXCEPTIONS 7513
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_DESCRIPTION 7514
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ALLOWED 7515
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCKED 7516
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_DESCRIPTION 7517
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED 7518
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED 7519
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_SUB_LABEL 7520
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED_EXCEPTIONS 7521
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_EXCEPTIONS 7522
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_DESCRIPTION 7523
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_ALLOWED_EXCEPTIONS 7524
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCKED_EXCEPTIONS 7525
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_DESCRIPTION 7526
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED 7527
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED 7528
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED_EXCEPTIONS 7529
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED_EXCEPTIONS 7530
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_DESCRIPTION 7531
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED 7532
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED 7533
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_SUB_LABEL 7534
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED_EXCEPTIONS 7535
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_EXCEPTIONS 7536
#define IDS_SETTINGS_SITE_SETTINGS_MIC_DESCRIPTION 7537
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED 7538
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED 7539
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_SUB_LABEL 7540
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED_EXCEPTIONS 7541
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_EXCEPTIONS 7542
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_DESCRIPTION 7543
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED 7544
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED 7545
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED_EXCEPTIONS 7546
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED_EXCEPTIONS 7547
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_DESCRIPTION 7548
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED 7549
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED 7550
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_SUB_LABEL 7551
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED_EXCEPTIONS 7552
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_EXCEPTIONS 7553
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DESCRIPTION 7554
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED 7555
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL 7556
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL_SUB_LABEL 7557
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED 7558
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_SUB_LABEL 7559
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED_EXCEPTIONS 7560
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_EXCEPTIONS 7561
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_DESCRIPTION 7562
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED 7563
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED 7564
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED_EXCEPTIONS 7565
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED_EXCEPTIONS 7566
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_DESCRIPTION 7567
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_ALLOWED 7568
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_DESCRIPTION 7569
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED 7570
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED 7571
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED_EXCEPTIONS 7572
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED_EXCEPTIONS 7573
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_DESCRIPTION 7574
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_ALLOWED 7575
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED 7576
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED_SUB_LABEL 7577
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_EXPLANATION 7578
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_ALLOWED 7579
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED 7580
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED_SUB_LABEL 7581
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_ALLOWED_EXCEPTIONS 7582
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_IDENTIFIERS_BLOCKED_EXCEPTIONS 7583
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_DESCRIPTION 7585
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_ALLOWED 7586
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED 7587
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED_EXCEPTIONS 7588
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_DESCRIPTION 7589
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ALLOWED 7590
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_BLOCKED 7591
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_DESCRIPTION 7592
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED 7593
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED 7594
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_SUB_LABEL 7595
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED_EXCEPTIONS 7596
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_EXCEPTIONS 7597
#define IDS_SETTINGS_SITE_SETTINGS_USB_DESCRIPTION 7598
#define IDS_SETTINGS_SITE_SETTINGS_USB_ALLOWED 7599
#define IDS_SETTINGS_SITE_SETTINGS_USB_BLOCKED 7600
#define IDS_SETTINGS_SITE_SETTINGS_VR_DESCRIPTION 7601
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED 7602
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED 7603
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED_EXCEPTIONS 7604
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED_EXCEPTIONS 7605
#define IDS_SETTINGS_SITE_SETTINGS_ZOOM_LEVELS_DESCRIPTION 7606
#define IDS_SETTINGS_SITE_SETTINGS_AR_ASK 7607
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCK 7608
#define IDS_SETTINGS_COOKIES_PAGE 7609
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DESCRIPTION 7610
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DEFAULT_BEHAVIOR_HEADING 7611
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 7612
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 7613
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 7614
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 7615
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_TITLE 7616
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_LABEL 7617
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_ENABLED 7618
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED_INCOGNITO 7619
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_LINK_ROW_SUB_LABEL_DISABLED 7620
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_RADIO_LABEL 7621
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_EXPAND_A11Y_LABEL 7622
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_BULLET_1 7623
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_ALLOW_BULLET_2 7624
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_RADIO_LABEL 7625
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_EXPAND_A11Y_LABEL 7626
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_BULLET_1 7627
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_INCOGNITO_BULLET_2 7628
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_RADIO_LABEL 7629
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_EXPAND_A11Y_LABEL 7630
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_BULLET_1 7631
#define IDS_SETTINGS_THIRD_PARTY_COOKIES_PAGE_BLOCK_BULLET_2 7632
#define IDS_SETTINGS_COOKIES_CONTROLS 7633
#define IDS_SETTINGS_COOKIES_ALLOW_ALL 7634
#define IDS_SETTINGS_COOKIES_ALLOW_ALL_EXPAND_A11Y_LABEL 7635
#define IDS_SETTINGS_COOKIES_ALLOW_ALL_BULLET_ONE 7636
#define IDS_SETTINGS_COOKIES_ALLOW_ALL_BULLET_TWO 7637
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO 7638
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_EXPAND_A11Y_LABEL 7639
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_ONE 7640
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_TWO 7641
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_TWO_FPS 7642
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY 7643
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_EXPAND_A11Y_LABEL 7644
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_BULLET_ONE 7645
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_BULLET_TWO 7646
#define IDS_SETTINGS_COOKIES_BLOCK_ALL 7647
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_EXPAND_A11Y_LABEL 7648
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_BULLET_ONE 7649
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_BULLET_TWO 7650
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_BULLET_THREE 7651
#define IDS_SETTINGS_COOKIES_FIRST_PARTY_SETS_TOGGLE_LABEL 7652
#define IDS_SETTINGS_COOKIES_FIRST_PARTY_SETS_TOGGLE_SUB_LABEL 7653
#define IDS_SETTINGS_COOKIES_CLEAR_ON_EXIT 7654
#define IDS_SETTINGS_COOKIES_ALL_SITES_LINK 7656
#define IDS_SETTINGS_COOKIES_ALLOW_EXCEPTIONS 7657
#define IDS_SETTINGS_COOKIES_SESSION_ONLY_EXCEPTIONS 7658
#define IDS_SETTINGS_COOKIES_BLOCK_EXCEPTIONS 7659
#define IDS_SETTINGS_SITE_SETTINGS_APP_PROTOCOL_HANDLERS 7660
#define IDS_SETTINGS_SITE_SETTINGS_APP_ALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 7661
#define IDS_SETTINGS_SITE_SETTINGS_APP_DISALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 7662
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ASK 7663
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCK 7664
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCK 7665
#define IDS_SETTINGS_SITE_SETTINGS_PDF_DOWNLOAD_PDFS 7666
#define IDS_SETTINGS_SITE_SETTINGS_RECENT_ACTIVITY 7667
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ASK_RECOMMENDED 7668
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_ZOOM_LEVEL 7669
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_SENDING 7670
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATICALLY_BLOCKED_NOTIFICATIONS 7671
#define IDS_SETTINGS_SITE_SETTINGS_SHOW_BLOCKED_NOTIFICATIONS_INDICATOR 7672
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW 7673
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK 7674
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY 7675
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO 7676
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW_SITES 7677
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_ASK_RECOMMENDED 7678
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_BLOCKED 7679
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_DESCRIPTION 7680
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK 7681
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED 7682
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_ASK_EXCEPTIONS 7683
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_MANAGEMENT_BLOCKED_EXCEPTIONS 7684
#define IDS_SETTINGS_SITE_SETTINGS_BLOCKED 7685
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW 7686
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK 7687
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY 7688
#define IDS_SETTINGS_SITE_SETTINGS_ASK_DEFAULT_MENU 7689
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_DEFAULT_MENU 7690
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DEFAULT_MENU 7691
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_DEFAULT_MENU 7692
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_DEFAULT_MENU 7693
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_MENU 7694
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_MENU 7695
#define IDS_SETTINGS_SITE_SETTINGS_ASK_MENU 7696
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_MENU 7697
#define IDS_SETTINGS_SITE_SETTINGS_RESET_MENU 7698
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY_MENU 7699
#define IDS_SETTINGS_SITE_SETTINGS_USAGE 7700
#define IDS_SETTINGS_SITE_SETTINGS_USAGE_NONE 7701
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS 7702
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS_MORE 7703
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT 7704
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT_MORE 7705
#define IDS_SETTINGS_SITE_SETTINGS_ALLOWLISTED 7706
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_BLOCKLISTED_SINGULAR 7707
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_NOT_BLOCKLISTED_SINGULAR 7708
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_KILL_SWITCH 7709
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_INSECURE_ORIGIN 7710
#define IDS_SETTINGS_SITE_SETTINGS_RESET_BUTTON 7711
#define IDS_SETTINGS_SITE_SETTINGS_DELETE 7712
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIES_EXCEPTION_LABEL 7713
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_DIALOG_TITLE 7714
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_DIALOG_TITLE 7715
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_LEARN_MORE 7716
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_LEARN_MORE_ACCESSIBILITY 7717
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_DESCRIPTION 7718
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_DESCRIPTION 7719
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_LABEL 7720
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_LABEL 7721
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DETAILS_SUBPAGE_ACCESSIBILITY_LABEL 7722
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_MEMBERSHIP_LABEL 7723
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_MORE_ACTIONS_TITLE 7724
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_SHOW_RELATED_SITES_BUTTON 7725
#define IDS_SETTINGS_SITE_SETTINGS_FIRST_PARTY_SETS_SITE_DELETE_STORAGE_BUTTON 7726
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION 7727
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION 7728
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_ALL_STORAGE_CONFIRMATION_INSTALLED 7729
#define IDS_SETTINGS_SITE_SETTINGS_DELETE_DISPLAYED_STORAGE_CONFIRMATION_INSTALLED 7730
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_SIGN_OUT 7731
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_SIGN_OUT 7732
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_CONFIRMATION 7733
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_DIALOG_TITLE 7734
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION 7735
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION_NEW 7736
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_SIGN_OUT 7737
#define IDS_SETTINGS_SITE_SETTINGS_SITE_DELETE_STORAGE_OFFLINE_DATA 7738
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_AD_PERSONALIZATION 7739
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_OFFLINE_DATA 7740
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_DIALOG_TITLE 7741
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_APP_DIALOG_TITLE 7742
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_PARTITIONED_DIALOG_TITLE 7743
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_DIALOG_TITLE 7744
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_DIALOG_TITLE 7745
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_PLURAL_DIALOG_TITLE 7746
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_LOGOUT 7747
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_LOGOUT 7748
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_OFFLINE_DATA 7749
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_PERMISSIONS 7750
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_CONFIRM 7751
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_SITE 7752
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_ALL 7753
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE 7754
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_IS_DEFAULT 7755
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_SET_DEFAULT 7756
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE 7757
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_ONLY 7758
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_SITE_EXCEPTION_DESC 7759
#define IDS_SETTINGS_SITE_SETTINGS_NO_ZOOMED_SITES 7760
#define IDS_SETTINGS_SITE_NO_SITES_ADDED 7761
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_AUTOPLAY 7762
#define IDS_SETTINGS_SITE_SETTINGS_EMPTY_ALL_SITES_PAGE 7763
#define IDS_SETTINGS_SITE_SETTINGS_NO_SITES_FOUND 7764
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_DESCRIPTION 7765
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ASK 7766
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCK 7767
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ALLOWED_EXCEPTIONS 7768
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCKED_EXCEPTIONS 7769
#define IDS_SETTINGS_SITE_SETTINGS_EXTENSION_ID_DESCRIPTION 7770
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_ALLOWED_SUB_LABEL 7771
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_BLOCKED_SUB_LABEL 7772
#define IDS_SETTINGS_SITE_SETTINGS_PAGE_SITE_DATA_DELETE_ON_EXIT_SUB_LABEL 7773
#define IDS_SETTINGS_EXPIRES_AFTER_TIME_LABEL 7774
#define IDS_SETTINGS_SITE_DATA_PAGE_TITLE 7775
#define IDS_SETTINGS_SITE_DATA_PAGE_DESCRIPTION 7776
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_HEADING 7777
#define IDS_SETTINGS_SITE_DATA_PAGE_DEFAULT_BEHAVIOR_DESCRIPTION 7778
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_LABEL 7779
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_RADIO_SUB_LABEL 7780
#define IDS_SETTINGS_SITE_DATA_PAGE_CLEAR_ON_EXIT_RADIO_LABEL 7781
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_LABEL 7782
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_RADIO_SUB_LABEL 7783
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_HEADING 7784
#define IDS_SETTINGS_SITE_DATA_PAGE_CUSTOMIZED_BEHAVIOR_DESCRIPTION 7785
#define IDS_SETTINGS_SITE_DATA_PAGE_ALLOW_EXCEPTIONS_SUB_HEADING 7786
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_EXCEPTIONS_SUB_HEADING 7787
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_TITLE 7788
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_DESCRIPTION 7789
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CONFIRM_BUTTON 7790
#define IDS_SETTINGS_SITE_DATA_PAGE_BLOCK_CONFIRM_DIALOG_CANCEL_BUTTON 7791
#define IDS_SETTINGS_STORAGE_ACCESS_DESCRIPTION 7792
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED 7793
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED 7794
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_EXCEPTIONS 7795
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_EXCEPTIONS 7796
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_ALL 7797
#define IDS_SETTINGS_STORAGE_ACCESS_RESET_SITE 7798
#define IDS_SETTINGS_STORAGE_ACCESS_OPEN_EXPAND 7799
#define IDS_SETTINGS_STORAGE_ACCESS_CLOSE_EXPAND 7800
#define IDS_SETTINGS_STORAGE_ACCESS_ALLOWED_SITE_LABEL 7801
#define IDS_SETTINGS_STORAGE_ACCESS_BLOCKED_SITE_LABEL 7802
#define IDS_SETTINGS_NO_BLUETOOTH_DEVICES_FOUND 7803
#define IDS_SETTINGS_NO_USB_DEVICES_FOUND 7804
#define IDS_SETTINGS_NO_SERIAL_PORTS_FOUND 7805
#define IDS_SETTINGS_NO_HID_DEVICES_FOUND 7806
#define IDS_SETTINGS_RESET_BLUETOOTH_CONFIRMATION 7807
#define IDS_SETTINGS_RESET_HID_CONFIRMATION 7808
#define IDS_SETTINGS_RESET_SERIAL_PORTS_CONFIRMATION 7809
#define IDS_SETTINGS_RESET_USB_CONFIRMATION 7810
#define IDS_SETTINGS_ADD_SITE_TITLE 7811
#define IDS_SETTINGS_ADD_SITES_TITLE 7812
#define IDS_SETTINGS_EDIT_SITE_TITLE 7813
#define IDS_SETTINGS_ADD_SITE 7814
#define IDS_SETTINGS_SITE_SETTINGS_NUM_COOKIES 7816
#define IDS_SETTINGS_PEOPLE 7817
#define IDS_SETTINGS_CHANGE_PICTURE_PROFILE_PHOTO 7818
#define IDS_SETTINGS_PEOPLE_SIGN_IN 7819
#define IDS_SETTINGS_SYNC_DISCONNECT_MANAGED_PROFILE_EXPLANATION 7820
#define IDS_SETTINGS_TURN_OFF_SYNC_MANAGED_PROFILE_EXPLANATION 7821
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_TITLE 7822
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE 7823
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_MANAGED_CONFIRM 7824
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_CHECKBOX 7825
#define IDS_SETTINGS_SYNC_SETTINGS_SAVED_TOAST_LABEL 7826
#define IDS_SETTINGS_PROFILE_NAME_INPUT_LABEL 7827
#define IDS_SETTINGS_PROFILE_SHORTCUT_TOGGLE_LABEL 7828
#define IDS_SETTINGS_CUSTOMIZE_PROFILE 7829
#define IDS_SETTINGS_PICK_A_THEME_COLOR 7830
#define IDS_SETTINGS_PICK_AN_AVATAR 7831
#define IDS_SETTINGS_CREATE_SHORTCUT 7832
#define IDS_SETTINGS_CREATE_SHORTCUT_SUBTITLE 7833
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPLANATION 7834
#define IDS_SETTINGS_SYNC_DISCONNECT_MAIN_PROFILE_EXPLANATION 7835
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION 7836
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPAND_ACCESSIBILITY_LABEL 7837
#define IDS_SETTINGS_SYNC_WILL_START 7838
#define IDS_SETTINGS_MANAGE_GOOGLE_ACCOUNT 7839
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_LABEL 7840
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_TEXT 7841
#define IDS_SETTINGS_ENCRYPT_WITH_SYNC_PASSPHRASE_LABEL 7842
#define IDS_NEW_SETTINGS_ENCRYPT_WITH_SYNC_PASSPHRASE_LABEL 7843
#define IDS_SETTINGS_PASSPHRASE_EXPLANATION_TEXT 7844
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_ENCRYPTION 7845
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_TOGGLE 7846
#define IDS_SETTINGS_PASSPHRASE_RECOVER 7847
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE 7848
#define IDS_SETTINGS_IMPORT_SETTINGS_TITLE 7849
#define IDS_SETTINGS_IMPORT_FROM_LABEL 7850
#define IDS_SETTINGS_IMPORT_ITEMS_LABEL 7851
#define IDS_SETTINGS_IMPORT_LOADING_PROFILES 7852
#define IDS_SETTINGS_IMPORT_HISTORY_CHECKBOX 7853
#define IDS_SETTINGS_IMPORT_FAVORITES_CHECKBOX 7854
#define IDS_SETTINGS_IMPORT_PASSWORDS_CHECKBOX 7855
#define IDS_SETTINGS_IMPORT_SEARCH_ENGINES_CHECKBOX 7856
#define IDS_SETTINGS_IMPORT_AUTOFILL_FORM_DATA_CHECKBOX 7857
#define IDS_SETTINGS_IMPORT_CHOOSE_FILE 7858
#define IDS_SETTINGS_IMPORT_COMMIT 7859
#define IDS_SETTINGS_IMPORT_SUCCESS 7860
#define IDS_SETTINGS_IMPORT_NO_PROFILE_FOUND 7861
#define IDS_SETTINGS_PAGE_ZOOM_LABEL 7862
#define IDS_SETTINGS_FONT_SIZE_LABEL 7863
#define IDS_SETTINGS_VERY_SMALL_FONT 7864
#define IDS_SETTINGS_SMALL_FONT 7865
#define IDS_SETTINGS_MEDIUM_FONT 7866
#define IDS_SETTINGS_LARGE_FONT 7867
#define IDS_SETTINGS_VERY_LARGE_FONT 7868
#define IDS_SETTINGS_CUSTOMIZE_FONTS 7869
#define IDS_SETTINGS_FONTS 7870
#define IDS_SETTINGS_STANDARD_FONT_LABEL 7871
#define IDS_SETTINGS_SERIF_FONT_LABEL 7872
#define IDS_SETTINGS_SANS_SERIF_FONT_LABEL 7873
#define IDS_SETTINGS_FIXED_WIDTH_FONT_LABEL 7874
#define IDS_SETTINGS_MATH_FONT_LABEL 7875
#define IDS_SETTINGS_MINIMUM_FONT_SIZE_LABEL 7876
#define IDS_SETTINGS_TINY_FONT_SIZE 7877
#define IDS_SETTINGS_HUGE_FONT_SIZE 7878
#define IDS_SETTINGS_QUICK_BROWN_FOX 7879
#define IDS_SETTINGS_SYSTEM 7880
#define IDS_SETTINGS_SYSTEM_HARDWARE_ACCELERATION_LABEL 7881
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_LABEL 7882
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_EXTENSION_LABEL 7883
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_POLICY_LABEL 7884
#define IDS_PAGE_NOT_AVAILABLE_FOR_GUEST_HEADING 7895
#define IDS_SETTINGS_SECURITY_KEYS_TITLE 7896
#define IDS_SETTINGS_SECURITY_KEYS_DESC 7897
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN 7898
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_BUTTON 7899
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_DESC 7900
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_INITIAL_TITLE 7901
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CREATE_TITLE 7902
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CHANGE_TITLE 7903
#define IDS_SETTINGS_SECURITY_KEYS_RESET 7904
#define IDS_SETTINGS_SECURITY_KEYS_RESET_DESC 7905
#define IDS_SETTINGS_SECURITY_KEYS_RESET_TITLE 7906
#define IDS_SETTINGS_SECURITY_KEYS_RESET_CONFIRM_TITLE 7907
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP1 7908
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP2 7909
#define IDS_SETTINGS_SECURITY_KEYS_NO_RESET 7910
#define IDS_SETTINGS_SECURITY_KEYS_RESET_ERROR 7911
#define IDS_SETTINGS_SECURITY_KEYS_RESET_SUCCESS 7912
#define IDS_SETTINGS_SECURITY_KEYS_RESET_NOTALLOWED 7913
#define IDS_SETTINGS_SECURITY_KEYS_NO_PIN 7914
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN_INTRO 7915
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT 7916
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_SIN 7917
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_PL 7918
#define IDS_SETTINGS_SECURITY_KEYS_SAME_PIN_AS_CURRENT 7919
#define IDS_SETTINGS_SECURITY_KEYS_NEW_PIN 7920
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CONFIRM 7921
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN 7922
#define IDS_SETTINGS_SECURITY_KEYS_PIN 7923
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_SHORT_SMALL 7924
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_LONG 7925
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_INVALID 7926
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_MISMATCH 7927
#define IDS_SETTINGS_SECURITY_KEYS_CONFIRM_PIN 7928
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SUCCESS 7929
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR 7930
#define IDS_SETTINGS_SECURITY_KEYS_PIN_HARD_LOCK 7931
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SOFT_LOCK 7932
#define IDS_SETTINGS_SECURITY_KEYS_SHOW_PINS 7933
#define IDS_SETTINGS_SECURITY_KEYS_HIDE_PINS 7934
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_LABEL 7935
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_USERNAME_LABEL 7936
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_DISPLAYNAME_LABEL 7937
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_WEBSITE_LABEL 7938
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DESC 7939
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DIALOG_TITLE 7940
#define IDS_SETTINGS_SECURITY_KEYS_UPDATE_CREDENTIAL_DIALOG_TITLE 7941
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_TITLE 7942
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_CREDENTIAL 7943
#define IDS_SETTINGS_SECURITY_KEYS_INPUT_ERROR_TOO_LONG 7944
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_CREDENTIALS 7945
#define IDS_SETTINGS_SECURITY_KEYS_NO_CREDENTIAL_MANAGEMENT 7946
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_REMOVED 7947
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_PIN 7948
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_ERROR 7949
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_SUCCESS 7950
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_FAILED 7951
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_SUCCESS 7952
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_FAILED 7953
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_LABEL 7954
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_DESCRIPTION 7955
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DIALOG_TITLE 7956
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ADD_TITLE 7957
#define IDS_SETTINGS_SECURITY_KEYS_BIO_CHOOSE_NAME 7958
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL 7959
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL_TOO_LONG 7960
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_NO_ENROLLMENTS_LABEL 7961
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLMENTS_LABEL 7962
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_LABEL 7963
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_TRY_AGAIN_LABEL 7964
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_FAILED_LABEL 7965
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_COMPLETE_LABEL 7966
#define IDS_SETTINGS_SECURITY_KEYS_NO_BIOMETRIC_ENROLLMENT 7967
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DELETE 7968
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NO_PIN 7969
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_STORAGE_FULL 7970
#define IDS_SETTINGS_SECURITY_KEYS_TOUCH_TO_CONTINUE 7971
#define IDS_SETTINGS_SECURITY_KEYS_PIN_PROMPT 7972
#define IDS_SETTINGS_SECURITY_KEYS_FORCE_PIN_CHANGE 7973
#define IDS_SETTINGS_SECURITY_KEYS_PHONE_EDIT_DIALOG_TITLE 7974
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_YOUR_DEVICES 7975
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_SYNCED_DESC 7976
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DEVICES 7977
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DESC 7978
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE 7979
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE_DESC 7980
#define IDS_SETTINGS_EXTENSION_OR_APP_DISPLAY_NAME 7981
#define IDS_SETTINGS_SAFETY_HUB 7982
#define IDS_SETTINGS_SAFETY_HUB_ENTRY_POINT_BUTTON 7983
#define IDS_SETTINGS_SAFETY_HUB_PAGE_CARD_SECTION_HEADER 7984
#define IDS_SETTINGS_SAFETY_HUB_PAGE_MODULE_SECTION_HEADER 7985
#define IDS_SETTINGS_SAFETY_HUB_PAGE_USER_EDU_SECTION_HEADER 7986
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_LABEL 7987
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 7988
#define IDS_SETTINGS_SUBPAGE_LEARN_MORE_ARIA_LABEL 7989
#define IDS_SETTINGS_CAPTIONS 7990
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_TITLE 7991
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_SUBTITLE 7992
#define IDS_SETTINGS_CAPTIONS_TEXT_SIZE 7993
#define IDS_SETTINGS_CAPTIONS_TEXT_FONT 7994
#define IDS_SETTINGS_CAPTIONS_TEXT_COLOR 7995
#define IDS_SETTINGS_CAPTIONS_TEXT_OPACITY 7996
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_OPACITY 7997
#define IDS_SETTINGS_CAPTIONS_OPACITY_OPAQUE 7998
#define IDS_SETTINGS_CAPTIONS_OPACITY_SEMI_TRANSPARENT 7999
#define IDS_SETTINGS_CAPTIONS_OPACITY_TRANSPARENT 8000
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW 8001
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_NONE 8002
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_RAISED 8003
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DEPRESSED 8004
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_UNIFORM 8005
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DROP_SHADOW 8006
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_COLOR 8007
#define IDS_SETTINGS_CAPTIONS_COLOR_BLACK 8008
#define IDS_SETTINGS_CAPTIONS_COLOR_WHITE 8009
#define IDS_SETTINGS_CAPTIONS_COLOR_RED 8010
#define IDS_SETTINGS_CAPTIONS_COLOR_GREEN 8011
#define IDS_SETTINGS_CAPTIONS_COLOR_BLUE 8012
#define IDS_SETTINGS_CAPTIONS_COLOR_YELLOW 8013
#define IDS_SETTINGS_CAPTIONS_COLOR_CYAN 8014
#define IDS_SETTINGS_CAPTIONS_COLOR_MAGENTA 8015
#define IDS_SETTINGS_CAPTIONS_DEFAULT_SETTING 8016
#define IDS_SETTINGS_CAPTIONS_LANGUAGE 8017
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_TITLE 8018
#define IDS_SETTINGS_CAPTIONS_MANAGE_LANGUAGES_SUBTITLE 8019
#define IDS_SETTINGS_CAPTIONS_LIVE_TRANSLATE_TARGET_LANGUAGE 8020
#define IDS_SETTINGS_CAPTIONS_REMOVE_LANGUAGE_ARIA_LABEL 8021
#define IDS_SETTINGS_NEARBY_SHARE_TITLE 8022
#define IDS_SETTINGS_NEARBY_SHARE_SET_UP_BUTTON_TITLE 8023
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ROW_TITLE 8024
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_DIALOG_TITLE 8025
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_FIELD_LABEL 8026
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DEVICE_NAME 8027
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_TITLE 8028
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_DESCRIPTION 8029
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_ARIA_LABEL 8030
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ARIA_DESCRIPTION 8031
#define IDS_SETTINGS_NEARBY_SHARE_CONFIRM_DEVICE_NAME 8032
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_LABEL 8033
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_ROW_TITLE 8034
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DATA_USAGE 8035
#define IDS_SETTINGS_NEARBY_SHARE_UPDATE_DATA_USAGE 8036
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_DIALOG_TITLE 8037
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_LABEL 8038
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_DESCRIPTION 8039
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_LABEL 8040
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_DESCRIPTION 8041
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_TOOLTIP 8042
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_LABEL 8043
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_DESCRIPTION 8044
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_DATA_DESCRIPTION 8045
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_WIFI_ONLY_DESCRIPTION 8046
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_OFFLINE_DESCRIPTION 8047
#define IDS_SETTINGS_NEARBY_SHARE_CONTACT_VISIBILITY_ROW_TITLE 8048
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_VISIBILITY 8049
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_TITLE 8050
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_SAVE 8051
#define IDS_SETTINGS_NEARBY_SHARE_DESCRIPTION 8052
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_TITLE 8053
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_ON 8054
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_OFF 8055
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION 8056
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION_DESC 8057
#define IDS_SETTINGS_SPELLING_PREF 8058
#define IDS_SETTINGS_ENABLE_LOGGING_PREF 8059
#define IDS_SETTINGS_ENABLE_LOGGING_PREF_DESC 8060
#define IDS_SETTINGS_LINKDOCTOR_PREF 8061
#define IDS_SETTINGS_LINKDOCTOR_PREF_DESC 8062
#define IDS_SETTINGS_SUGGEST_PREF 8063
#define IDS_SETTINGS_DRIVE_SUGGEST_PREF 8064
#define IDS_SETTINGS_PEOPLE_SYNCING_TO_ACCOUNT 8065
#define IDS_SETTINGS_PEOPLE_SYNC_PAUSED 8066
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT 8067
#define IDS_SETTINGS_PEOPLE_SYNC_TURN_OFF 8068
#define IDS_SETTINGS_SETTINGS_CHECKBOX_LABEL 8069
#define IDS_SETTINGS_PEOPLE_SYNC_NOT_WORKING 8070
#define IDS_SETTINGS_PEOPLE_SYNC_PASSWORDS_NOT_WORKING 8071
#define IDS_SETTINGS_SYNC_ADVANCED_PAGE_TITLE 8072
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_PAGE_TITLE 8073
#define IDS_SETTINGS_PEOPLE_SYNC_ANOTHER_ACCOUNT 8074
#define IDS_SETTINGS_SYNC_DISCONNECT_CONFIRM 8075
#define IDS_SETTINGS_PEOPLE_SIGN_OUT 8076
#define IDS_SETTINGS_AUTOFILL_CHECKBOX_LABEL 8077
#define IDS_SETTINGS_HISTORY_CHECKBOX_LABEL 8078
#define IDS_SETTINGS_EXTENSIONS_CHECKBOX_LABEL 8079
#define IDS_SETTINGS_OPEN_TABS_CHECKBOX_LABEL 8080
#define IDS_SETTINGS_SAVED_TAB_GROUPS_CHECKBOX_LABEL 8081
#define IDS_SETTINGS_WIFI_CONFIGURATIONS_CHECKBOX_LABEL 8082
#define IDS_SETTINGS_SYNC_EVERYTHING_CHECKBOX_LABEL 8083
#define IDS_SETTINGS_APPS_CHECKBOX_LABEL 8084
#define IDS_SETTINGS_APPS_CHECKBOX_SUBLABEL 8085
#define IDS_SETTINGS_NON_PERSONALIZED_SERVICES_SECTION_LABEL 8086
#define IDS_SETTINGS_CUSTOMIZE_SYNC 8087
#define IDS_SETTINGS_SYNC_DATA 8088
#define IDS_SETTINGS_PASSWORDS_CHECKBOX_LABEL 8089
#define IDS_SETTINGS_PASSPHRASE_PLACEHOLDER 8090
#define IDS_SETTINGS_EXISTING_PASSPHRASE_TITLE 8091
#define IDS_SETTINGS_SUBMIT_PASSPHRASE 8092
#define IDS_SETTINGS_ENCRYPT_WITH_GOOGLE_CREDENTIALS_LABEL 8093
#define IDS_SETTINGS_BOOKMARKS_CHECKBOX_LABEL 8094
#define IDS_SETTINGS_READING_LIST_CHECKBOX_LABEL 8095
#define IDS_SETTINGS_ENCRYPTION_OPTIONS 8096
#define IDS_SETTINGS_MISMATCHED_PASSPHRASE_ERROR 8097
#define IDS_SETTINGS_EMPTY_PASSPHRASE_ERROR 8098
#define IDS_SETTINGS_INCORRECT_PASSPHRASE_ERROR 8099
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_TITLE_UNIFIED_CONSENT 8100
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_DEVICE_PAGE_TITLE 8101
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_BROWSER_PAGE_TITLE 8102
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_SUBTITLE_UNIFIED_CONSENT 8103
#define IDS_SETTINGS_NEW_MANAGE_BROWSER_SYNCED_DATA_TITLE 8104
#define IDS_SETTINGS_SYNC_SYNC_AND_NON_PERSONALIZED_SERVICES 8105
#define IDS_SETTINGS_PASSPHRASE_CONFIRMATION_PLACEHOLDER 8106
#define IDS_SETTINGS_SYNC_LOADING 8107
#define IDS_SETTINGS_SYNC_TIMEOUT 8108
#define IDS_SETTINGS_SYNC 8109
#define IDS_SETTINGS_SYNC_SETTINGS_CANCEL_SYNC 8110
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_TITLE 8111
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_BODY 8112
#define IDS_SETTINGS_ABOUT_UPGRADE_CHECK_STARTED 8116
#define IDS_SETTINGS_UPDATE_TO_ROLLBACK_VERSION_DISALLOWED 8117
#define IDS_SETTINGS_THEME_CHECKBOX_LABEL 8119
#define IDS_SUPPORT_TOOL_ISSUE_DETAILS_PAGE_TITLE 8123
#define IDS_SUPPORT_TOOL_DATA_SELECTION_PAGE_TITLE 8124
#define IDS_SUPPORT_TOOL_REVIEW_PII_PAGE_TITLE 8125
#define IDS_SUPPORT_TOOL_DATA_EXPORT_DONE_PAGE_TITLE 8126
#define IDS_SUPPORT_TOOL_DATA_EXPORTED_TEXT 8127
#define IDS_SUPPORT_TOOL_SUPPORT_CASE_ID 8128
#define IDS_SUPPORT_TOOL_EMAIL 8129
#define IDS_SUPPORT_TOOL_DESCRIBE_ISSUE_TEXT 8130
#define IDS_SUPPORT_TOOL_ISSUE_DESCRIPTION_PLACEHOLDER 8131
#define IDS_SUPPORT_TOOL_PII_WARNING_TEXT 8132
#define IDS_SUPPORT_TOOL_INCLUDE_ALL_PII_RADIO_BUTTON 8133
#define IDS_SUPPORT_TOOL_REMOVE_PII_RADIO_BUTTON 8134
#define IDS_SUPPORT_TOOL_PII_REMOVAL_DISCLAIMER 8135
#define IDS_SUPPORT_TOOL_MANUALLY_SELECT_PII_RADIO_BUTTON 8136
#define IDS_SUPPORT_TOOL_CANCEL_BUTTON_TEXT 8137
#define IDS_SUPPORT_TOOL_EXPORT_BUTTON_TEXT 8138
#define IDS_SUPPORT_TOOL_BACK_BUTTON_TEXT 8139
#define IDS_SUPPORT_TOOL_DISMISS_BUTTON_TEXT 8140
#define IDS_SUPPORT_TOOL_CONTINUE_BUTTON_TEXT 8141
#define IDS_SUPPORT_TOOL_DATA_COLLECTION_SPINNER 8142
#define IDS_SUPPORT_TOOL_DATA_EXPORT_SPINNER 8143
#define IDS_SUPPORT_TOOL_TAB_TITLE 8144
#define IDS_SUPPORT_TOOL_URL_GENERATOR_PAGE_TITLE 8145
#define IDS_SUPPORT_TOOL_DATA_COLLECTOR_LIST_TITLE 8146
#define IDS_SUPPORT_TOOL_GET_LINK_TEXT 8147
#define IDS_SUPPORT_TOOL_COPY_LINK_DESCRIPTION 8148
#define IDS_SUPPORT_TOOL_COPY_LINK_BUTTON_TEXT 8149
#define IDS_SUPPORT_TOOL_COPY_TOKEN_BUTTON_TEXT 8150
#define IDS_SUPPORT_TOOL_DONT_INCLUDE_EMAIL 8151
#define IDS_SUPPORT_TOOL_LINK_COPIED_TEXT 8152
#define IDS_SUPPORT_TOOL_TOKEN_COPIED_TEXT 8153
#define IDS_SUPPORT_TOOL_SELECT_DATA_COLLECTOR_ERROR 8154
#define IDS_SUPPORT_TOOL_CHROME_SYSTEM_INFO 8155
#define IDS_SUPPORT_TOOL_CRASH_IDS 8156
#define IDS_SUPPORT_TOOL_MEMORY_DETAILS 8157
#define IDS_SUPPORT_TOOL_UI_HIEARCHY 8158
#define IDS_SUPPORT_TOOL_ADDITIONAL_CROS_PLATFROM_LOGS 8159
#define IDS_SUPPORT_TOOL_DEVICE_EVENT 8160
#define IDS_SUPPORT_TOOL_INTEL_WIFI_DEBUG_DUMP 8161
#define IDS_SUPPORT_TOOL_TOUCH_EVENTS 8162
#define IDS_SUPPORT_TOOL_LACROS_SYSTEM_INFO 8163
#define IDS_SUPPORT_TOOL_LACROS 8164
#define IDS_SUPPORT_TOOL_CHROMEOS_FLEX_LOGS 8165
#define IDS_SUPPORT_TOOL_DBUS_DETAILS 8166
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_ROUTES 8167
#define IDS_SUPPORT_TOOL_CHROMEOS_SHILL_LOGS 8168
#define IDS_SUPPORT_TOOL_POLICIES 8169
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_STATE 8170
#define IDS_SUPPORT_TOOL_CHROMEOS_SYSTEM_LOGS 8171
#define IDS_SUPPORT_TOOL_CHROMEOS_CHROME_USER_LOGS 8172
#define IDS_SUPPORT_TOOL_CHROMEOS_BLUETOOTH_FLOSS 8173
#define IDS_SUPPORT_TOOL_CHROMEOS_CONNECTED_INPUT_DEVICES 8174
#define IDS_SUPPORT_TOOL_CHROMEOS_TRAFFIC_COUNTERS 8175
#define IDS_SUPPORT_TOOL_CHROMEOS_VIRTUAL_KEYBOARD 8176
#define IDS_SUPPORT_TOOL_CHROMEOS_NETWORK_HEALTH 8177
#define IDS_SUPPORT_TOOL_PERFORMANCE 8178
#define IDS_SUPPORT_TOOL_SIGN_IN 8179
#define IDS_SUPPORT_TOOL_ANDROID_APP_INFO 8180
#define IDS_SUPPORT_TOOL_WIFI_SSID 8181
#define IDS_SUPPORT_TOOL_CELLULAR_LOCATION_INFO 8182
#define IDS_SUPPORT_TOOL_EMAIL_ADDRESS 8183
#define IDS_SUPPORT_TOOL_GAIA_ID 8184
#define IDS_SUPPORT_TOOL_STABLE_IDENTIDIERS 8185
#define IDS_SUPPORT_TOOL_PRINTING_IPP_ADDRESS 8186
#define IDS_SUPPORT_TOOL_IP_ADDRESS 8187
#define IDS_SUPPORT_TOOL_MAC_ADDRESS 8188
#define IDS_SUPPORT_TOOL_WINDOW_TITLES 8189
#define IDS_SUPPORT_TOOL_URLS 8190
#define IDS_SUPPORT_TOOL_SERIAL_NUMBERS 8191
#define IDS_SUPPORT_TOOL_REMOVABLE_STORAGE_NAMES 8192
#define IDS_SUPPORT_TOOL_EAP 8193
#define IDS_EXTENSIONS_ALLOW_FILE_ACCESS 8194
#define IDS_EXTENSIONS_ALLOW_ON_ALL_URLS 8195
#define IDS_EXTENSIONS_ALLOW_ON_FOLLOWING_SITES 8196
#define IDS_EXTENSIONS_VIEW_ACTIVITY_LOG 8197
#define IDS_EXTENSIONS_BACKGROUND_PAGE 8198
#define IDS_EXTENSIONS_SERVICE_WORKER_BACKGROUND 8199
#define IDS_EXTENSIONS_CORRUPTED_EXTENSION 8200
#define IDS_EXTENSIONS_ENABLE_ERROR_COLLECTION 8201
#define IDS_EXTENSIONS_ERROR_NO_ERRORS_CODE_MESSAGE 8202
#define IDS_EXTENSIONS_INSTALL_DROP_TARGET 8203
#define IDS_EXTENSIONS_INSTALL_WARNINGS 8204
#define IDS_EXTENSIONS_LOG_LEVEL_ERROR 8205
#define IDS_EXTENSIONS_LOG_LEVEL_INFO 8206
#define IDS_EXTENSIONS_LOG_LEVEL_WARN 8207
#define IDS_EXTENSIONS_PATH 8208
#define IDS_EXTENSIONS_PERMISSIONS_OFF 8209
#define IDS_EXTENSIONS_RELOAD_TERMINATED 8210
#define IDS_EXTENSIONS_REPAIR_CORRUPTED 8211
#define IDS_EXTENSIONS_VIEW_IFRAME 8212
#define IDS_EXTENSIONS_VIEW_INACTIVE 8213
#define IDS_EXTENSIONS_VIEW_INCOGNITO 8214
#define IDS_EXTENSIONS_DEVELOPER_MODE 8215
#define IDS_EXTENSIONS_DISABLED_UPDATE_REQUIRED_BY_POLICY 8216
#define IDS_EXTENSIONS_DISABLED_PUBLISHED_IN_STORE_REQUIRED_BY_POLICY 8217
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_ALLOW 8218
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_TITLE 8219
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_WARNING 8220
#define IDS_EXTENSIONS_MENU_BUTTON_LABEL 8221
#define IDS_EXTENSIONS_ERROR_PAGE_HEADING 8222
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_ALLOW_ALL_EXTENSIONS 8223
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_CUSTOMIZE_PER_EXTENSION 8224
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_RESTRICT_EXTENSIONS 8225
#define IDS_EXTENSIONS_ERROR_ANONYMOUS_FUNCTION 8226
#define IDS_EXTENSIONS_ERROR_CONTEXT 8227
#define IDS_EXTENSIONS_ERROR_CONTEXT_UNKNOWN 8228
#define IDS_EXTENSIONS_CLEAR_ACTIVITIES 8229
#define IDS_EXTENSIONS_ERROR_CLEAR_ALL 8230
#define IDS_EXTENSIONS_A11Y_CLEAR_ENTRY 8231
#define IDS_EXTENSIONS_ERROR_STACK_TRACE 8232
#define IDS_EXTENSIONS_ERROR_LINES_NOT_SHOWN 8233
#define IDS_EXTENSIONS_HOST_PERMISSIONS_DESCRIPTION 8234
#define IDS_EXTENSIONS_PERMISSIONS_LEARN_MORE_A11Y_LABEL 8235
#define IDS_EXTENSIONS_HOST_PERMISSIONS_EDIT 8236
#define IDS_EXTENSIONS_ITEM_ERRORS 8237
#define IDS_EXTENSIONS_ITEM_HOST_PERMISSIONS_HEADING 8238
#define IDS_EXTENSIONS_NEW_HOST_PERMISSIONS_HEADING 8239
#define IDS_EXTENSIONS_HOST_PERMISSIONS_SUB_HEADING 8240
#define IDS_EXTENSIONS_HOST_ACCESS_ON_CLICK 8241
#define IDS_EXTENSIONS_HOST_ACCESS_ASK_ON_EVERY_VISIT 8242
#define IDS_EXTENSIONS_HOST_ACCESS_ON_SPECIFIC_SITES 8243
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_SPECIFIC_SITES 8244
#define IDS_EXTENSIONS_HOST_ACCESS_ON_ALL_SITES 8245
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_ALL_SITES 8246
#define IDS_EXTENSIONS_ITEM_ALLOWED_HOSTS 8247
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_LINE 8248
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_MULTI_LINE 8249
#define IDS_EXTENSIONS_ACTIVITY_LOG_PAGE_HEADING 8250
#define IDS_EXTENSIONS_ACTIVITY_LOG_SEARCH_LABEL 8251
#define IDS_EXTENSIONS_ACTIVITY_LOG_TYPE_COLUMN 8252
#define IDS_EXTENSIONS_ACTIVITY_LOG_NAME_COLUMN 8253
#define IDS_EXTENSIONS_ACTIVITY_LOG_COUNT_COLUMN 8254
#define IDS_EXTENSIONS_ACTIVITY_LOG_TIME_COLUMN 8255
#define IDS_EXTENSIONS_ACTIVITY_LOG_HISTORY_TAB_HEADING 8256
#define IDS_EXTENSIONS_ACTIVITY_LOG_STREAM_TAB_HEADING 8257
#define IDS_EXTENSIONS_START_ACTIVITY_STREAM 8258
#define IDS_EXTENSIONS_STOP_ACTIVITY_STREAM 8259
#define IDS_EXTENSIONS_EMPTY_STREAM_STARTED 8260
#define IDS_EXTENSIONS_EMPTY_STREAM_STOPPED 8261
#define IDS_EXTENSIONS_ACTIVITY_ARGUMENTS_HEADING 8262
#define IDS_EXTENSIONS_WEB_REQUEST_INFO_HEADING 8263
#define IDS_EXTENSIONS_ACTIVITY_LOG_MORE_ACTIONS_LABEL 8264
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPAND_ALL 8265
#define IDS_EXTENSIONS_ACTIVITY_LOG_COLLAPSE_ALL 8266
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPORT_HISTORY 8267
#define IDS_EXTENSIONS_ITEM_ID 8268
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS 8269
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS_EXTRA 8270
#define IDS_EXTENSIONS_ITEM_NO_ACTIVE_VIEWS 8271
#define IDS_EXTENSIONS_ITEM_ALLOW_INCOGNITO 8272
#define IDS_EXTENSIONS_ITEM_DEPENDENCIES 8273
#define IDS_EXTENSIONS_DEPENDENT_ENTRY 8274
#define IDS_EXTENSIONS_ITEM_DESCRIPTION 8275
#define IDS_EXTENSIONS_ITEM_DETAILS 8276
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_LABEL 8277
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 8278
#define IDS_EXTENSIONS_EXTENSION_A11Y_ASSOCIATION 8279
#define IDS_EXTENSIONS_APP_ICON 8280
#define IDS_EXTENSIONS_EXTENSION_ICON 8281
#define IDS_EXTENSIONS_ITEM_ID_HEADING 8282
#define IDS_EXTENSIONS_EXTENSION_ENABLED 8283
#define IDS_EXTENSIONS_APP_ENABLED 8284
#define IDS_EXTENSIONS_ITEM_OFF 8285
#define IDS_EXTENSIONS_ITEM_ON 8286
#define IDS_EXTENSIONS_ITEM_EXTENSION_WEBSITE 8287
#define IDS_EXTENSIONS_ITEM_CHROME_WEB_STORE 8288
#define IDS_EXTENSIONS_ITEM_OPTIONS 8289
#define IDS_EXTENSIONS_ITEM_PERMISSIONS 8290
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_EMPTY 8291
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_AND_SITE_ACCESS_EMPTY 8292
#define IDS_EXTENSIONS_ITEM_REMOVE_EXTENSION 8293
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS 8294
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_ADD_HOST 8295
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_EMPTY 8296
#define IDS_EXTENSIONS_REMOVE_SITES_DIALOG_TITLE 8297
#define IDS_EXTENSIONS_ITEM_SOURCE 8298
#define IDS_EXTENSIONS_ITEM_SOURCE_INSTALLED_BY_DEFAULT 8299
#define IDS_EXTENSIONS_ITEM_SOURCE_POLICY 8300
#define IDS_EXTENSIONS_ITEM_SOURCE_SIDELOADED 8301
#define IDS_EXTENSIONS_ITEM_SOURCE_UNPACKED 8302
#define IDS_EXTENSIONS_ITEM_SOURCE_WEBSTORE 8303
#define IDS_EXTENSIONS_ITEM_VERSION 8304
#define IDS_EXTENSIONS_ITEM_RELOADED 8305
#define IDS_EXTENSIONS_ITEM_RELOADING 8306
#define IDS_EXTENSIONS_LOAD_ERROR_HEADING 8307
#define IDS_EXTENSIONS_LOAD_ERROR_ERROR_LABEL 8308
#define IDS_EXTENSIONS_LOAD_ERROR_FILE_LABEL 8309
#define IDS_EXTENSIONS_LOAD_ERROR_COULD_NOT_LOAD_MANIFEST 8310
#define IDS_EXTENSIONS_LOAD_ERROR_RETRY 8311
#define IDS_EXTENSIONS_LOADING_ACTIVITIES 8312
#define IDS_MISSING_OR_UNINSTALLED_EXTENSION 8313
#define IDS_EXTENSIONS_NO_ACTIVITIES 8314
#define IDS_EXTENSIONS_NO_INSTALLED_ITEMS 8315
#define IDS_EXTENSIONS_NO_DESCRIPTION 8316
#define IDS_EXTENSIONS_OPENS_IN_NEW_TAB 8317
#define IDS_EXTENSIONS_PACK_DIALOG_TITLE 8318
#define IDS_EXTENSIONS_PACK_DIALOG_WARNING_TITLE 8319
#define IDS_EXTENSIONS_PACK_DIALOG_ERROR_TITLE 8320
#define IDS_EXTENSIONS_PACK_DIALOG_PROCEED_ANYWAY 8321
#define IDS_EXTENSIONS_PACK_DIALOG_BROWSE_BUTTON 8322
#define IDS_EXTENSIONS_PACK_DIALOG_EXTENSION_ROOT_LABEL 8323
#define IDS_EXTENSIONS_PACK_DIALOG_KEY_FILE_LABEL 8324
#define IDS_EXTENSIONS_PACK_DIALOG_CONFIRM_BUTTON 8325
#define IDS_EXTENSIONS_TOOLBAR_TITLE 8326
#define IDS_EXTENSIONS_SEARCH 8327
#define IDS_EXTENSIONS_SITE_PERMISSIONS 8328
#define IDS_EXTENSIONS_SITE_PERMISSIONS_PAGE_TITLE 8329
#define IDS_EXTENSIONS_SITE_PERMISSIONS_VIEW_ALL_SITES 8330
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_PAGE_TITLE 8331
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_ONE_EXTENSION 8332
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_EXTENSION_COUNT 8333
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_ALL_SITES 8334
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALWAYS_ON_THIS_SITE 8335
#define IDS_EXTENSIONS_SITE_SETTINGS 8336
#define IDS_EXTENSIONS_PERMITTED_SITES 8337
#define IDS_EXTENSIONS_RESTRICTED_SITES 8338
#define IDS_EXTENSIONS_NO_SITES_ADDED 8339
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ADD_SITE_DIALOG_TITLE 8340
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_SITE_DIALOG_TITLE 8341
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_URL 8342
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS_DIALOG_TITLE 8343
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS 8344
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ASK_ON_EVERY_VISIT 8345
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_ERROR 8346
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_LABEL 8347
#define IDS_EXTENSIONS_SITE_PERMISSIONS_INCLUDES_SUBDOMAINS 8348
#define IDS_EXTENSIONS_EDIT_SHORTCUT_INPUT_LABEL 8349
#define IDS_EXTENSIONS_EDIT_SHORTCUT_BUTTON_LABEL 8350
#define IDS_EXTENSIONS_SHORTCUT_NOT_SET 8351
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_LABEL 8352
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_GLOBAL 8353
#define IDS_EXTENSIONS_APPS_TITLE 8354
#define IDS_EXTENSIONS_REMOVE 8355
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_TITLE 8356
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_ERROR 8357
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_LABEL 8358
#define IDS_EXTENSIONS_SIDEBAR_EXTENSIONS 8359
#define IDS_EXTENSIONS_SIDEBAR_DISCOVER_MORE 8360
#define IDS_EXTENSIONS_SIDEBAR_KEYBOARD_SHORTCUTS 8361
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED 8362
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED_DONE 8363
#define IDS_EXTENSIONS_TOOLBAR_PACK 8364
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW 8365
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW_TOOLTIP 8366
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_DONE 8367
#define IDS_EXTENSIONS_TOOLBAR_UPDATING_TOAST 8368
#define IDS_EXTENSIONS_SHORTCUT_SET 8369
#define IDS_EXTENSIONS_TYPE_A_SHORTCUT 8370
#define IDS_EXTENSIONS_SUBPAGE_BUTTON 8371
#define IDS_EXTENSIONS_SC_MALWARE 8372
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_OFF 8373
#define IDS_EXTENSIONS_SC_POLICY_VIOLATION_ON 8374
#define IDS_EXTENSIONS_SC_UNPUBLISHED_OFF 8375
#define IDS_EXTENSIONS_SC_UNPUBLISHED_ON 8376
#define IDS_EXTENSIONS_SC_TITLE 8377
#define IDS_EXTENSIONS_SC_DESCRIPTION 8378
#define IDS_EXTENSIONS_SC_KEEP_EXT 8379
#define IDS_EXTENSIONS_SC_REMOVE_ALL 8380
#define IDS_EXTENSIONS_SC_ALL_DONE_FOR_NOW 8381
#define IDS_EXTENSIONS_SC_ALL_EXTENSIONS 8382
#define IDS_EXTENSIONS_SC_REMOVE_BUTTON_A11Y_LABEL 8383
#define IDS_EXTENSIONS_SC_OPTION_MENU_A11Y_LABEL 8384
#define IDS_EXTENSIONS_INCLUDE_START_MODIFIER 8385
#define IDS_EXTENSIONS_TOO_MANY_MODIFIERS 8386
#define IDS_EXTENSIONS_NEED_CHARACTER 8387
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_SUBTITLE 8398
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_TITLE 8399
#define IDS_NEARBY_CONFIRMATION_PAGE_TITLE 8400
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOAD_FAILED 8401
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOADING 8402
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE 8403
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_TITLE 8404
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE 8405
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL 8406
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL_SELF_SHARE 8407
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_NONE 8408
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME 8409
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME_SELF_SHARE 8410
#define IDS_NEARBY_CONTACT_VISIBILITY_ZERO_STATE_TEXT 8411
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_YOUR_DEVICES 8412
#define IDS_NEARBY_DEVICE_NAME_EMPTY_ERROR 8413
#define IDS_NEARBY_DEVICE_NAME_TOO_LONG_ERROR 8414
#define IDS_NEARBY_DEVICE_NAME_INVALID_CHARACTERS_ERROR 8415
#define IDS_NEARBY_DISCOVERY_PAGE_INFO 8416
#define IDS_NEARBY_DISCOVERY_PAGE_SUBTITLE 8417
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE 8418
#define IDS_NEARBY_DISCOVERY_PAGE_PLACEHOLDER 8419
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME 8420
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME_HELP 8421
#define IDS_NEARBY_ONBOARDING_PAGE_SUBTITLE 8422
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE 8423
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY 8424
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY_HELP_ALL_CONTACTS 8425
#define IDS_NEARBY_VISIBILITY_PAGE_MANAGE_CONTACTS 8426
#define IDS_NEARBY_VISIBILITY_PAGE_SUBTITLE 8427
#define IDS_NEARBY_VISIBILITY_PAGE_TITLE 8428
#define IDS_NEARBY_SHARE_FEATURE_NAME 8429
#define IDS_NEARBY_ACTIONS_ACCEPT 8430
#define IDS_NEARBY_ACTIONS_CANCEL 8431
#define IDS_NEARBY_ACTIONS_CLOSE 8432
#define IDS_NEARBY_ACTIONS_CONFIRM 8433
#define IDS_NEARBY_ACTIONS_DECLINE 8434
#define IDS_NEARBY_ACTIONS_NEXT 8435
#define IDS_NEARBY_ACTIONS_REJECT 8436
#define IDS_NEARBY_DEFAULT_DEVICE_NAME 8437
#define IDS_NEARBY_ERROR_CANCELLED 8438
#define IDS_NEARBY_ERROR_CANT_RECEIVE 8439
#define IDS_NEARBY_ERROR_CANT_SHARE 8440
#define IDS_NEARBY_ERROR_NO_RESPONSE 8441
#define IDS_NEARBY_ERROR_TRANSFER_IN_PROGRESS 8442
#define IDS_NEARBY_ERROR_NOT_ENOUGH_SPACE 8443
#define IDS_NEARBY_ERROR_REJECTED 8444
#define IDS_NEARBY_ERROR_SOMETHING_WRONG 8445
#define IDS_NEARBY_ERROR_TIME_OUT 8446
#define IDS_NEARBY_ERROR_TRY_AGAIN 8447
#define IDS_NEARBY_ERROR_UNSUPPORTED_FILE_TYPE 8448
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_APPS 8449
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_APPS 8450
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_IMAGES 8451
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_IMAGES 8452
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_UNKNOWN 8453
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 8454
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_VIDEOS 8455
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_VIDEOS 8456
#define IDS_NEARBY_SECURE_CONNECTION_ID 8457
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_ADDRESSES 8458
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_ADDRESSES 8459
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_LINKS 8460
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_LINKS 8461
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_PHONE_NUMBERS 8462
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_PHONE_NUMBERS 8463
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_UNKNOWN 8464
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 8465
#define IDS_NEARBY_CAPITALIZED_UNKNOWN_ATTACHMENTS 8466
#define IDS_NEARBY_NOT_CAPITALIZED_UNKNOWN_ATTACHMENTS 8467
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE 8468
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_MINUTES 8469
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_SECONDS 8470
#define IDS_NEARBY_HIGH_VISIBILITY_HELP_TEXT 8471
#define IDS_NEARBY_HIGH_VISIBILITY_TIMEOUT_TEXT 8472
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_ERROR 8473
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_DESCRIPTION 8474
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_ERROR 8475
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION 8476
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_TITLE 8477
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_CONNECTION_ID 8478
#define IDS_NEARBY_PREVIEW_TITLE_MULTIPLE_FILE 8479
#define IDS_NEARBY_ACCOUNT_ROW_LABEL 8480
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_TOP 8481
#define IDS_NEARBY_SETTINGS_HELP_CAPTION_BOTTOM 8482
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS 8483
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS_DESCRIPTION 8484
#define IDS_NEARBY_VISIBILITY_CONTACTS_BUTTON 8485
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS 8486
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS_DESCRIPTION 8487
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES 8488
#define IDS_NEARBY_VISIBILITY_YOUR_DEVICES_DESCRIPTION 8489
#define IDS_NEARBY_VISIBLITY_HIDDEN 8490
#define IDS_NEARBY_VISIBLITY_HIDDEN_DESCRIPTION 8491
#define IDS_NEARBY_VISIBLITY_UNKNOWN 8492
#define IDS_NEARBY_VISIBLITY_UNKNOWN_DESCRIPTION 8493
#define IDS_NEARBY_NOTIFICATION_ACTION_COPY_TO_CLIPBOARD 8494
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_FOLDER 8495
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_NETWORK_LIST 8496
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_URL 8497
#define IDS_NEARBY_NOTIFICATION_ACCEPT_ACTION 8498
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE 8499
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE_WIFI_CREDENTIALS 8500
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE 8501
#define IDS_NEARBY_NOTIFICATION_DECLINE_ACTION 8502
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE 8503
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_MESSAGE 8504
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_TITLE 8505
#define IDS_NEARBY_NOTIFICATION_SET_UP_ACTION 8506
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_ACTION 8507
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_TITLE 8508
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_MESSAGE 8509
#define IDS_NEARBY_NOTIFICATION_GO_TO_SETTINGS_ACTION 8510
#define IDS_NEARBY_NOTIFICATION_DISMISS_ACTION 8511
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE 8512
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE_WIFI_CREDENTIALS 8513
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE 8514
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE_WIFI_CREDENTIALS 8515
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE 8516
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE_WIFI_CREDENTIALS 8517
#define IDS_NEARBY_NOTIFICATION_SEND_FAILURE_TITLE 8518
#define IDS_NEARBY_NOTIFICATION_SEND_PROGRESS_TITLE 8519
#define IDS_NEARBY_NOTIFICATION_SEND_SUCCESS_TITLE 8520
#define IDS_NEARBY_NOTIFICATION_SOURCE 8521
#define IDS_NEARBY_NOTIFICATION_SENDER_CANCELLED 8522
#define IDS_WELCOME_NEXT 8523
#define IDS_WELCOME_SKIP 8524
#define IDS_WELCOME_STEPS 8525
#define IDS_WELCOME_BOOKMARK_ADDED 8526
#define IDS_WELCOME_BOOKMARKS_ADDED 8527
#define IDS_WELCOME_BOOKMARK_REMOVED 8528
#define IDS_WELCOME_BOOKMARKS_REMOVED 8529
#define IDS_DEFAULT_BROWSER_CHANGED 8530
#define IDS_WELCOME_GOOGLE_APPS_DESCRIPTION 8531
#define IDS_WELCOME_GOOGLE_GMAIL 8533
#define IDS_WELCOME_GOOGLE_APPS_MAPS 8534
#define IDS_WELCOME_GOOGLE_APPS_NEWS 8535
#define IDS_WELCOME_GOOGLE_APPS_TRANSLATE 8536
#define IDS_WELCOME_GOOGLE_APPS_YOUTUBE 8537
#define IDS_WELCOME_NTP_BACKGROUND_DESCRIPTION 8538
#define IDS_WELCOME_NTP_BACKGROUND_DEFAULT_TITLE 8539
#define IDS_WELCOME_NTP_BACKGROUND_ART_TITLE 8540
#define IDS_WELCOME_NTP_BACKGROUND_LANDSCAPE_TITLE 8541
#define IDS_WELCOME_NTP_BACKGROUND_CITYSCAPE_TITLE 8542
#define IDS_WELCOME_NTP_BACKGROUND_EARTH_TITLE 8543
#define IDS_WELCOME_NTP_BACKGROUND_GEOMETRIC_SHAPES_TITLE 8544
#define IDS_WELCOME_NTP_BACKGROUND_PHOTO_BY_LABEL 8545
#define IDS_WELCOME_NTP_BACKGROUND_PREVIEW_UPDATED 8546
#define IDS_WELCOME_NTP_BACKGROUND_RESET 8547
#define IDS_WELCOME_SET_AS_DEFAULT_HEADER 8548
#define IDS_WELCOME_SET_AS_DEFAULT_SUB_HEADER 8549
#define IDS_WELCOME_SET_AS_DEFAULT_SET_AS_DEFAULT 8550
#define IDS_WELCOME_LANDING_TITLE 8551
#define IDS_WELCOME_LANDING_DESCRIPTION 8552
#define IDS_WELCOME_LANDING_NEW_USER 8553
#define IDS_WELCOME_LANDING_EXISTING_USER 8554
#define IDS_WELCOME_LANDING_PAUSE_ANIMATIONS 8555
#define IDS_WELCOME_LANDING_PLAY_ANIMATIONS 8556
#define IDS_WELCOME_SIGNIN_VIEW_HEADER 8557
#define IDS_WELCOME_SIGNIN_VIEW_SUB_HEADER 8558
#define IDS_WELCOME_SIGNIN_VIEW_SIGNIN 8559
#define IDS_WHATS_NEW_TITLE 8560
#define IDS_PASSWORD_MANAGER_UI_TITLE 8561
#define IDS_PASSWORD_MANAGER_UI_SEARCH_PROMPT 8562
#define IDS_PASSWORD_MANAGER_UI_CHECKUP 8563
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS 8564
#define IDS_PASSWORD_MANAGER_UI_SETTINGS 8565
#define IDS_PASSWORD_MANAGER_UI_SAVE_PASSWORDS_TOGGLE_LABEL 8566
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_LABEL 8567
#define IDS_PASSWORD_MANAGER_UI_AUTOSIGNIN_TOGGLE_DESC 8568
#define IDS_PASSWORD_MANAGER_UI_PASSWORDS_DESCRIPTION 8569
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_BUTTON 8570
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_TITLE 8571
#define IDS_PASSWORD_MANAGER_UI_ADD_SHORTCUT_DESCRIPTION 8572
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_TITLE 8573
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPT_IN_DESCRIPTION 8574
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_TITLE 8575
#define IDS_PASSWORD_MANAGER_UI_TRUSTED_VAULT_OPTED_IN_DESCRIPTION 8576
#define IDS_PASSWORD_MANAGER_UI_SHARE 8577
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_DESCRIPTION 8578
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_ERROR_TITLE 8579
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_LOADING_TITLE 8580
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_SUCCESS_TITLE 8581
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_CANCELED_TITLE 8582
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NO_MEMBERS_DESCRIPTION 8583
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_FAMILY_PICKER_DESCRIPTION 8584
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_MANAGE_FAMILY 8585
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_MEMBER_UNAVAILABLE 8586
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_NOT_AVAILABLE 8587
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_TRY_AGAIN 8588
#define IDS_PASSWORD_MANAGER_UI_SHARE_PASSWORD_GOT_IT 8589
#define IDS_PASSWORD_MANAGER_UI_SHARE_DIALOG_TITLE 8590
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BANNER_TITLE 8591
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_ACCOUNT_STORE_USERS 8592
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SYNCING_USERS 8593
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DESCRIPTION_SIGNEDOUT_USERS 8594
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_DEVICE 8595
#define IDS_PASSWORD_MANAGER_UI_STORE_PICKER_OPTION_ACCOUNT 8596
#define IDS_PASSWORD_MANAGER_UI_IMPORT_STORE_PICKER_ACCESSIBLE_NAME 8597
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SELECT_FILE_DESCRIPTION 8598
#define IDS_PASSWORD_MANAGER_UI_SELECT_FILE 8599
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_PASSWORD 8600
#define IDS_PASSWORD_MANAGER_UI_IMPORT_MISSING_URL 8601
#define IDS_PASSWORD_MANAGER_UI_IMPORT_INVALID_URL 8602
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_URL 8603
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_USERNAME 8604
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_PASSWORD 8605
#define IDS_PASSWORD_MANAGER_UI_IMPORT_LONG_NOTE 8606
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_ACCOUNT 8607
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICT_DEVICE 8608
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_UNKNOWN 8609
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_BAD_FORMAT 8610
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FILE_SIZE_EXCEEDED 8611
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_LIMIT_EXCEEDED 8612
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ERROR_TITLE 8613
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TITLE 8614
#define IDS_PASSWORD_MANAGER_UI_IMPORT_COMPLETE_TITLE 8615
#define IDS_PASSWORD_MANAGER_UI_IMPORT_DELETE_FILE_OPTION 8616
#define IDS_PASSWORD_MANAGER_UI_IMPORT_VIEW_PASSWORDS 8617
#define IDS_PASSWORD_MANAGER_UI_IMPORT_ALREADY_ACTIVE 8618
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_TIP 8619
#define IDS_PASSWORD_MANAGER_UI_IMPORT_FAILURES_SUMMARY 8620
#define IDS_PASSWORD_MANAGER_UI_IMPORT_BAD_ROWS_FORMAT 8621
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_ACCOUNT 8622
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SUCCESS_SUMMARY_DEVICE 8623
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_TITLE 8624
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CONFLICTS_DESCRIPTION 8625
#define IDS_PASSWORD_MANAGER_UI_IMPORT_CANCEL 8626
#define IDS_PASSWORD_MANAGER_UI_IMPORT_SKIP 8627
#define IDS_PASSWORD_MANAGER_UI_IMPORT_REPLACE 8628
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TITLE 8629
#define IDS_PASSWORD_MANAGER_UI_DOWNLOAD_FILE 8630
#define IDS_PASSWORD_MANAGER_UI_EXPORT_BANNER_DESCRIPTION 8631
#define IDS_PASSWORD_MANAGER_UI_EXPORT_SUCCESSFUL 8632
#define IDS_PASSWORD_MANAGER_UI_EXPORT_TRY_AGAIN 8633
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TITLE 8634
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIPS 8635
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ENOUGH_SPACE 8636
#define IDS_PASSWORD_MANAGER_UI_EXPORTING_FAILURE_TIP_ANOTHER_FOLDER 8637
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_TITLE 8638
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RESULT 8639
#define IDS_PASSWORD_MANAGER_UI_JUST_NOW 8640
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_COUNT 8641
#define IDS_PASSWORD_MANAGER_UI_NO_COMPROMISED_PASSWORDS 8642
#define IDS_PASSWORD_MANAGER_UI_HAS_COMPROMISED_PASSWORDS 8643
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_COUNT 8644
#define IDS_PASSWORD_MANAGER_UI_NO_REUSED_PASSWORDS 8645
#define IDS_PASSWORD_MANAGER_UI_HAS_REUSED_PASSWORDS 8646
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_COUNT 8647
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_GREEN_STATE_A11Y 8648
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_YELLOW_STATE_A11Y 8649
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RED_STATE_A11Y 8650
#define IDS_PASSWORD_MANAGER_UI_NO_WEAK_PASSWORDS 8651
#define IDS_PASSWORD_MANAGER_UI_HAS_WEAK_PASSWORDS 8652
#define IDS_PASSWORD_MANAGER_UI_CHECK_PASSWORDS_AFTER_ERROR 8653
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_TITLE 8654
#define IDS_PASSWORD_MANAGER_UI_BLOCKED_SITES_DESCRIPTION 8655
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_ACCOUNTS 8656
#define IDS_PASSWORD_MANAGER_UI_USERNAME_LABEL 8657
#define IDS_PASSWORD_MANAGER_UI_SITES_LABEL 8658
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LABEL 8659
#define IDS_PASSWORD_MANAGER_UI_NOTE_LABEL 8660
#define IDS_PASSWORD_MANAGER_UI_NO_NOTE_ADDED 8661
#define IDS_PASSWORD_MANAGER_UI_COPY_PASSWORD 8662
#define IDS_PASSWORD_MANAGER_UI_COPY_USERNAME 8663
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD 8664
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD 8665
#define IDS_PASSWORD_MANAGER_UI_SHOW_PASSWORD_A11Y 8666
#define IDS_PASSWORD_MANAGER_UI_HIDE_PASSWORD_A11Y 8667
#define IDS_PASSWORD_MANAGER_UI_FEDERATION_LABEL 8668
#define IDS_PASSWORD_MANAGER_UI_USERNAME_COPIED_TO_CLIPBOARD 8669
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_COPIED_TO_CLIPBOARD 8670
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD 8671
#define IDS_PASSWORD_MANAGER_UI_WEBSITE_LABEL 8672
#define IDS_PASSWORD_MANAGER_UI_ADD_PASSWORD_FOOTNOTE 8673
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_LEAKED 8674
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED 8675
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_PHISHED_AND_LEAKED 8676
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON 8677
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_BUTTON_ARIA_DESCRIPTION 8678
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS 8679
#define IDS_PASSWORD_MANAGER_UI_MORE_ACTIONS_ARIA_DESCRIPTION 8680
#define IDS_PASSWORD_MANAGER_UI_COMPROMISED_PASSWORDS_DESCRIPTION 8681
#define IDS_PASSWORD_MANAGER_UI_REUSED_PASSWORDS_DESCRIPTION 8682
#define IDS_PASSWORD_MANAGER_UI_WEAK_PASSWORDS_DESCRIPTION 8683
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_SIGNED_OUT 8684
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OFFLINE 8685
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_COMPROMISED_SECTION 8686
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_NO_PASSWORDS 8687
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_QUOTA_LIMIT 8688
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_OTHER_ERROR 8689
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_RUNNING_LABEL 8690
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROGRESS 8691
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_CANCELED 8692
#define IDS_PASSWORD_MANAGER_UI_MUTED_COMPROMISED_PASSWORDS 8693
#define IDS_PASSWORD_MANAGER_UI_MUTE_ISSUE 8694
#define IDS_PASSWORD_MANAGER_UI_UNMUTE_ISSUE 8695
#define IDS_PASSWORD_MANAGER_UI_NUMBER_OF_CREDENTIALS_WITH_REUSED_PASSWORD 8696
#define IDS_PASSWORD_MANAGER_UI_HELP 8697
#define IDS_PASSWORD_MANAGER_UI_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_LABEL_WIN 8700
#define IDS_PASSWORD_MANAGER_UI_BIOMETRIC_AUTHENTICATION_FOR_FILLING_TOGGLE_SUBLABEL_WIN 8701
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSWORD 8702
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_EDIT_FOOTNOTE 8703
#define IDS_PASSWORD_MANAGER_UI_PASSWORD_DELETED 8704
#define IDS_PASSWORD_MANAGER_UI_UNDO 8705
#define IDS_PASSWORD_MANAGER_UI_SEARCH_RESULT 8706
#define IDS_PASSWORD_MANAGER_UI_CHANGE_PASSWORD_IN_APP 8707
#define IDS_PASSWORD_MANAGER_UI_ALREADY_CHANGED_PASSWORD 8708
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_DESCRIPTION 8709
#define IDS_PASSWORD_MANAGER_UI_EDIT_DISCLAIMER_TITLE 8710
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_TITLE 8711
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSWORD_CONFIRMATION_DESCRIPTION 8712
#define IDS_PASSWORD_MANAGER_UI_SHOW_MORE 8713
#define IDS_PASSWORD_MANAGER_UI_NOT_VALID_WEB_ADDRESS 8714
#define IDS_PASSWORD_MANAGER_UI_MISSING_TLD 8715
#define IDS_PASSWORD_MANAGER_UI_USERNAME_ALREADY_USED 8716
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT 8717
#define IDS_PASSWORD_MANAGER_UI_NOTE_CHARACTER_COUNT_WARNING 8718
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT 8719
#define IDS_PASSWORD_MANAGER_UI_AUTH_TIMED_OUT_DESCRIPTION 8720
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD 8721
#define IDS_PASSWORD_MANAGER_UI_VIEW_EXISTING_PASSWORD_ARIA_DESCRIPTION 8722
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TO_ACCOUNT 8723
#define IDS_PASSWORD_MANAGER_UI_OPENS_IN_NEW_TAB 8724
#define IDS_PASSWORD_MANAGER_UI_VIEW_PASSWORD_ARIA_DESCRIPTION 8725
#define IDS_PASSWORD_MANAGER_UI_RUN_CHECKUP_ARIA_DESCRIPTION 8726
#define IDS_PASSWORD_MANAGER_UI_REMOVE_BLOCKED_SITE_ARIA_DESCRIPTION 8727
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_ACCOUNT_STORE_USERS 8728
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SYNCING_USERS 8729
#define IDS_PASSWORD_MANAGER_UI_EMPTY_STATE_SIGNEDOUT_USERS 8730
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_TITLE 8731
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_DESCRIPTION 8732
#define IDS_PASSWORD_MANAGER_UI_CHECKUP_PROMO_CARD_ACTION 8733
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_TITLE 8734
#define IDS_PASSWORD_MANAGER_UI_WEB_PROMO_CARD_DESCRIPTION 8735
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_TITLE 8736
#define IDS_PASSWORD_MANAGER_UI_SHORTCUT_PROMO_CARD_DESCRIPTION 8737
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_TITLE 8738
#define IDS_PASSWORD_MANAGER_UI_ANY_DEVICE_PROMO_CARD_DESCRIPTION 8739
#define IDS_PASSWORD_MANAGER_UI_ACCOUNT_STORAGE_TOGGLE_LABEL 8740
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_TITLE 8741
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_BODY 8742
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_ACCOUNT_CHECKBOX_LABEL 8743
#define IDS_PASSWORD_MANAGER_UI_DELETE_DIALOG_FROM_DEVICE_CHECKBOX_LABEL 8744
#define IDS_PASSWORD_MANAGER_UI_APPS_LABEL 8745
#define IDS_PASSWORD_MANAGER_UI_SITES_AND_APPS_LABEL 8746
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_CHECKUP_ARIA_DESCRIPTION 8747
#define IDS_PASSWORD_MANAGER_UI_BACK_TO_PASSWORDS_ARIA_DESCRIPTION 8748
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_TITLE 8749
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_DESCRIPTION 8750
#define IDS_PASSWORD_MANAGER_UI_MOVE_PASSWORDS_BUTTON 8751
#define IDS_PASSWORD_MANAGER_UI_MANAGE_PASSKEYS_LABEL 8752
#define IDS_PASSWORD_MANAGER_UI_NO_PASSWORDS_FOUND 8753
#define IDS_PASSWORD_MANAGER_UI_EDIT_PASSKEY 8754
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_LABEL 8755
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_PLACEHOLDER 8756
#define IDS_PASSWORD_MANAGER_UI_USERNAME_PLACEHOLDER 8757
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_TITLE 8758
#define IDS_PASSWORD_MANAGER_UI_DELETE_PASSKEY_CONFIRMATION_DESCRIPTION 8759
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_MANAGEMENT_INFO_LABEL 8760
#define IDS_PASSWORD_MANAGER_UI_COPY_DISPLAY_NAME_LABEL 8761
#define IDS_PASSWORD_MANAGER_UI_DISPLAY_NAME_COPIED_TO_CLIPBOARD 8762
#define IDS_PASSWORD_MANAGER_UI_PASSKEY_DELETED 8763
#define IDS_UTILITY_PROCESS_PRINTING_SERVICE_NAME 8764
#define IDS_UTILITY_PROCESS_PRINT_BACKEND_SERVICE_NAME 8765
#define IDS_PRINT_INVALID_PRINTER_SETTINGS 8766
#define IDS_PRINT_PREVIEW_TITLE 8767
#define IDS_PRINT_PREVIEW_DESCRIPTION 8768
#define IDS_PRINT_PREVIEW_LOADING 8769
#define IDS_PRINT_PREVIEW_FAILED 8770
#define IDS_PRINT_PREVIEW_INVALID_PRINTER_SETTINGS 8771
#define IDS_PRINT_PREVIEW_PRINT_BUTTON 8772
#define IDS_PRINT_PREVIEW_SAVE_BUTTON 8773
#define IDS_PRINT_PREVIEW_PRINTING 8774
#define IDS_PRINT_PREVIEW_SAVING 8775
#define IDS_PRINT_PREVIEW_OPTION_ALL_PAGES 8776
#define IDS_PRINT_PREVIEW_OPTION_ODD_PAGES 8777
#define IDS_PRINT_PREVIEW_OPTION_EVEN_PAGES 8778
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_PAGES 8779
#define IDS_PRINT_PREVIEW_DESTINATION_LABEL 8780
#define IDS_PRINT_PREVIEW_OPTION_BW 8781
#define IDS_PRINT_PREVIEW_OPTION_COLLATE 8782
#define IDS_PRINT_PREVIEW_OPTION_COLOR 8783
#define IDS_PRINT_PREVIEW_OPTION_LANDSCAPE 8784
#define IDS_PRINT_PREVIEW_OPTION_PORTRAIT 8785
#define IDS_PRINT_PREVIEW_OPTION_TWO_SIDED 8786
#define IDS_PRINT_PREVIEW_PRINT_ON_BOTH_SIDES_LABEL 8787
#define IDS_PRINT_PREVIEW_OPTION_LONG_EDGE 8788
#define IDS_PRINT_PREVIEW_OPTION_SHORT_EDGE 8789
#define IDS_PRINT_PREVIEW_PAGES_LABEL 8790
#define IDS_PRINT_PREVIEW_LAYOUT_LABEL 8791
#define IDS_PRINT_PREVIEW_COPIES_LABEL 8792
#define IDS_PRINT_PREVIEW_SCALING_LABEL 8793
#define IDS_PRINT_PREVIEW_OPTION_DEFAULT_SCALING 8794
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_SCALING 8795
#define IDS_PRINT_PREVIEW_PAGES_PER_SHEET_LABEL 8796
#define IDS_PRINT_PREVIEW_EXAMPLE_PAGE_RANGE_TEXT 8797
#define IDS_PRINT_PREVIEW_PRINT_TO_PDF 8798
#define IDS_PRINT_PREVIEW_SHEET_SUMMARY_LABEL 8799
#define IDS_PRINT_PREVIEW_PAGE_SUMMARY_LABEL 8800
#define IDS_PRINT_PREVIEW_PAGE_RANGE_SYNTAX_INSTRUCTION 8801
#define IDS_PRINT_PREVIEW_PAGE_RANGE_LIMIT_INSTRUCTION_WITH_VALUE 8802
#define IDS_PRINT_PREVIEW_COPIES_INSTRUCTION 8803
#define IDS_PRINT_PREVIEW_SCALING_INSTRUCTION 8804
#define IDS_PRINT_PREVIEW_PRINT_PAGES_LABEL 8805
#define IDS_PRINT_PREVIEW_OPTIONS_LABEL 8806
#define IDS_PRINT_PREVIEW_OPTION_HEADER_FOOTER 8807
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAGE 8808
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAPER 8809
#define IDS_PRINT_PREVIEW_OPTION_BACKGROUND_COLORS_AND_IMAGES 8810
#define IDS_PRINT_PREVIEW_OPTION_SELECTION_ONLY 8811
#define IDS_PRINT_PREVIEW_OPTION_RASTERIZE 8812
#define IDS_PRINT_PREVIEW_MARGINS_LABEL 8813
#define IDS_PRINT_PREVIEW_DEFAULT_MARGINS 8814
#define IDS_PRINT_PREVIEW_NO_MARGINS 8815
#define IDS_PRINT_PREVIEW_CUSTOM_MARGINS 8816
#define IDS_PRINT_PREVIEW_MINIMUM_MARGINS 8817
#define IDS_PRINT_PREVIEW_TOP_MARGIN_LABEL 8818
#define IDS_PRINT_PREVIEW_BOTTOM_MARGIN_LABEL 8819
#define IDS_PRINT_PREVIEW_LEFT_MARGIN_LABEL 8820
#define IDS_PRINT_PREVIEW_RIGHT_MARGIN_LABEL 8821
#define IDS_PRINT_PREVIEW_MEDIA_SIZE_LABEL 8822
#define IDS_PRINT_PREVIEW_MEDIA_TYPE_LABEL 8823
#define IDS_PRINT_PREVIEW_DPI_LABEL 8824
#define IDS_PRINT_PREVIEW_NON_ISOTROPIC_DPI_ITEM_LABEL 8825
#define IDS_PRINT_PREVIEW_DPI_ITEM_LABEL 8826
#define IDS_PRINT_PREVIEW_DESTINATION_SEARCH_TITLE 8827
#define IDS_PRINT_PREVIEW_SEARCH_BOX_PLACEHOLDER 8828
#define IDS_PRINT_PREVIEW_NO_DESTINATIONS_MESSAGE 8829
#define IDS_PRINT_PREVIEW_PRINT_DESTINATIONS_TITLE 8830
#define IDS_PRINT_PREVIEW_MANAGE 8831
#define IDS_PRINT_PREVIEW_SEE_MORE 8832
#define IDS_PRINT_PREVIEW_SEE_MORE_DESTINATIONS_LABEL 8833
#define IDS_PRINT_PREVIEW_EXTENSION_DESTINATION_ICON_TOOLTIP 8834
#define IDS_MORE_OPTIONS_LABEL 8835
#define IDS_PRINT_PREVIEW_COULD_NOT_PRINT 8836
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_SEARCH_BOX_PLACEHOLDER 8837
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_TITLE 8838
#define IDS_PRINT_PREVIEW_NO_ADVANCED_SETTINGS_MATCH_SEARCH_HINT 8839
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_CONFIRM 8840
#define IDS_PRINT_PREVIEW_NEW_SHOW_ADVANCED_OPTIONS 8841
#define IDS_PRINT_PREVIEW_BUTTON_SELECT 8842
#define IDS_PRINT_PREVIEW_BUTTON_GO_BACK 8843
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_DIALOG_TITLE 8844
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_PERMISSION_MESSAGE 8845
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_ERROR_MESSAGE 8846
#define IDS_PRINT_PREVIEW_MANAGED_SETTINGS_TEXT 8847
#define IDS_PRINT_PREVIEW_SYSTEM_DIALOG_OPTION 8876
#define IDS_DEFAULT_PRINT_DOCUMENT_TITLE 8879
#define IDS_PRINT_SPOOL_FAILED_TITLE_TEXT 8880
#define IDS_PRINT_SPOOL_FAILED_ERROR_TEXT 8881
#define IDS_PRESS_APP_TO_EXIT 8882
#define IDS_VR_SHELL_SITE_IS_TRACKING_LOCATION 8883
#define IDS_VR_SHELL_SITE_IS_USING_MICROPHONE 8884
#define IDS_VR_SHELL_SITE_IS_USING_CAMERA 8885
#define IDS_VR_SHELL_SITE_IS_SHARING_SCREEN 8886
#define IDS_VR_SHELL_BG_IS_USING_MICROPHONE 8887
#define IDS_VR_SHELL_BG_IS_USING_CAMERA 8888
#define IDS_VR_SHELL_BG_IS_SHARING_SCREEN 8889
#define IDS_VR_SHELL_SITE_CAN_TRACK_LOCATION 8890
#define IDS_VR_SHELL_SITE_CAN_USE_MICROPHONE 8891
#define IDS_VR_SHELL_SITE_CAN_USE_CAMERA 8892
#define IDS_VR_SHELL_SITE_CAN_SHARE_SCREEN 8893
#define IDS_VR_SHELL_SITE_IS_USING_BLUETOOTH 8894
#define IDS_VR_SHELL_SITE_CAN_USE_BLUETOOTH 8896
#define IDS_DESKTOP_PROMPT_DOFF_HEADSET 8897
#define IDS_VR_DESKTOP_GENERIC_PERMISSION_PROMPT 8898
#define IDS_VR_SHELL_SITE_IS_USING_USB 8899
#define IDS_VR_SHELL_SITE_IS_USING_MIDI 8900
#define IDS_VR_SHELL_SITE_CAN_USE_MIDI 8901
#define IDS_VR_UPDATE_KEYBOARD_PROMPT 8902
#define IDS_VR_SHELL_EXIT_PROMPT_DESCRIPTION 8903
#define IDS_VR_SHELL_EXIT_PROMPT_DESCRIPTION_SITE_INFO 8904
#define IDS_VR_SHELL_AUDIO_PERMISSION_PROMPT_DESCRIPTION 8905
#define IDS_VR_SHELL_AUDIO_PERMISSION_PROMPT_ABORT_BUTTON 8906
#define IDS_VR_SHELL_AUDIO_PERMISSION_PROMPT_CONTINUE_BUTTON 8907
#define IDS_VR_SHELL_EXIT_PROMPT_EXIT_VR_BUTTON 8908
#define IDS_VR_BROWSER_UNSUPPORTED_PAGE 8909
#define IDS_VR_WEB_VR_TIMEOUT_MESSAGE 8910
#define IDS_VR_WEB_VR_EXIT_BUTTON_LABEL 8911
#define IDS_VR_NO_SPEECH_RECOGNITION_RESULT 8912
#define IDS_VR_BUTTON_TRACKPAD 8913
#define IDS_VR_BUTTON_EXIT 8914
#define IDS_VR_BUTTON_BACK 8915
#define IDS_VR_BUTTON_TRACKPAD_REPOSITION 8916
#define IDS_VR_BUTTON_APP_REPOSITION 8917
#define IDS_VR_MENU_NEW_INCOGNITO_TAB 8918
#define IDS_VR_MENU_PREFERENCES 8919
#define IDS_VR_MENU_CLOSE_INCOGNITO_TABS 8920
#define IDS_VR_TABS_BUTTON_REGULAR 8921
#define IDS_VR_TABS_BUTTON_INCOGNITO 8922
#define IDS_BACKGROUND_APP_INSTALLED_BALLOON_TITLE 8923
#define IDS_BACKGROUND_APP_INSTALLED_BALLOON_BODY 8924
#define IDS_BACKGROUND_CRASHED_APP_BALLOON_MESSAGE 8925
#define IDS_BACKGROUND_CRASHED_EXTENSION_BALLOON_MESSAGE 8926
#define IDS_BACKGROUND_APP_NOT_INSTALLED 8927
#define IDS_PERMISSIONS_REQUESTED_SCREENREADER_ANNOUNCEMENT 8928
#define IDS_PERMISSIONS_EXPIRED_SCREENREADER_ANNOUNCEMENT 8929
#define IDS_PERMISSIONS_BUBBLE_PROMPT 8930
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_ONE_PERM 8931
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS 8932
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS_MORE 8933
#define IDS_PERMISSIONS_BUBBLE_PROMPT_THIS_FILE 8934
#define IDS_PERMISSION_CUSTOMIZE 8935
#define IDS_ALTERNATE_NAV_URL_VIEW_LABEL 8936
#define IDS_DOWNLOAD_TITLE 8937
#define IDS_TAB_LOADING_TITLE 696
#define IDS_HOVER_CARD_FILE_URL_SOURCE 8938
#define IDS_HOVER_CARD_BLOB_URL_SOURCE 8939
#define IDS_HOVER_CARD_CRASHED_TITLE 8940
#define IDS_HISTORY_SEARCH_PROMPT 8941
#define IDS_HISTORY_DELETE 8942
#define IDS_HISTORY_ITEMS_SELECTED 8943
#define IDS_HISTORY_ITEMS_UNSELECTED 8944
#define IDS_HISTORY_HISTORY_MENU_DESCRIPTION 8945
#define IDS_HISTORY_HISTORY_MENU_ITEM 8946
#define IDS_HISTORY_NO_SYNCED_RESULTS 8947
#define IDS_HISTORY_OPEN_TABS_MENU_ITEM 8948
#define IDS_HISTORY_TURN_ON_SYNC_BUTTON 8949
#define IDS_HISTORY_TURN_ON_SYNC_PROMO 8950
#define IDS_HISTORY_TURN_ON_SYNC_PROMO_DESC 8951
#define IDS_EDIT 8952
#define IDS_CLEAR_SEARCH 8953
#define IDS_CONFIRM 8954
#define IDS_DISABLE 8955
#define IDS_SEARCH_CLEARED 8956
#define IDS_SEARCH_RESULTS 8957
#define IDS_SEARCH_RESULTS_SINGULAR 8958
#define IDS_SEARCH_RESULTS_PLURAL 8959
#define IDS_SEARCH_RESULT_BUBBLE_TEXT 8960
#define IDS_SEARCH_RESULTS_BUBBLE_TEXT 8961
#define IDS_SEARCH_NO_RESULTS 8962
#define IDS_SHOW_BUBBLE_INACTIVE_DESCRIPTION 8963
#define IDS_FOCUS_HELP_BUBBLE_DESCRIPTION 8964
#define IDS_FOCUS_HELP_BUBBLE_TOGGLE_DESCRIPTION 8965
#define IDS_FOCUS_HELP_BUBBLE_TUTORIAL_DESCRIPTION 8966
#define IDS_CONTENT_CONTEXT_INSPECTELEMENT 8967
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_DIALOG_TITLE 8968
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_ENABLE 8969
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_DISABLE 8970
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_ENABLE 8971
#define IDS_CONTENT_CONTEXT_LIVE_CAPTION_DISABLE 8972
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_AUTOCOMPLETE_UNRECOGNIZED_TITLE 8973
#define IDS_CONTENT_CONTEXT_AUTOFILL_FALLBACK_AUTOCOMPLETE_UNRECOGNIZED 8974
#define IDS_CONTENT_CONTEXT_BACK 8975
#define IDS_CONTENT_CONTEXT_FORWARD 8976
#define IDS_CONTENT_CONTEXT_SAVEPAGEAS 8977
#define IDS_CONTENT_CONTEXT_PRINT 8978
#define IDS_CONTENT_CONTEXT_VIEWPAGESOURCE 8979
#define IDS_CONTENT_CONTEXT_OPENLINKWITH 8980
#define IDS_CONTENT_CONTEXT_OPENLINKWITH_CONFIGURE 8981
#define IDS_CONTENT_CONTEXT_INSPECTBACKGROUNDPAGE 8982
#define IDS_CONTENT_CONTEXT_READING_MODE 8983
#define IDS_CONTENT_CONTEXT_RELOAD 8984
#define IDS_CONTENT_CONTEXT_RESTART_APP 8985
#define IDS_CONTENT_CONTEXT_RELOAD_PACKAGED_APP 8986
#define IDS_CONTENT_CONTEXT_TRANSLATE 8987
#define IDS_CONTENT_CONTEXT_EXIT_FULLSCREEN 8988
#define IDS_CONTENT_CONTEXT_RELOADFRAME 8989
#define IDS_CONTENT_CONTEXT_VIEWFRAMESOURCE 8990
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB 8991
#define IDS_CONTENT_CONTEXT_OPENLINKNEWWINDOW 8992
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD 8993
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILES 8994
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILE 8995
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP 8996
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP_SAMEAPP 8997
#define IDS_CONTENT_CONTEXT_OPENLINKWEBAPP_NEWTAB 8998
#define IDS_CONTENT_CONTEXT_SAVELINKAS 8999
#define IDS_CONTENT_CONTEXT_COPYLINKLOCATION 9000
#define IDS_CONTENT_CONTEXT_COPYEMAILADDRESS 9001
#define IDS_CONTENT_CONTEXT_COPYLINKTEXT 9002
#define IDS_CONTENT_CONTEXT_COPYLINKTOTEXT 9003
#define IDS_CONTENT_CONTEXT_ADD_A_NOTE 9004
#define IDS_CONTENT_CONTEXT_REMOVELINKTOTEXT 9005
#define IDS_CONTENT_CONTEXT_RESHARELINKTOTEXT 9006
#define IDS_CONTENT_CONTEXT_SAVEIMAGEAS 9007
#define IDS_CONTENT_CONTEXT_COPYIMAGELOCATION 9008
#define IDS_CONTENT_CONTEXT_COPYIMAGE 9009
#define IDS_CONTENT_CONTEXT_OPENIMAGENEWTAB 9010
#define IDS_CONTENT_CONTEXT_OPEN_ORIGINAL_IMAGE_NEW_TAB 9011
#define IDS_CONTENT_CONTEXT_LOAD_IMAGE 9012
#define IDS_CONTENT_CONTEXT_LOOP 9013
#define IDS_CONTENT_CONTEXT_CONTROLS 9014
#define IDS_CONTENT_CONTEXT_ROTATECW 9015
#define IDS_CONTENT_CONTEXT_ROTATECCW 9016
#define IDS_CONTENT_CONTEXT_SAVEVIDEOAS 9017
#define IDS_CONTENT_CONTEXT_COPYVIDEOLOCATION 9018
#define IDS_CONTENT_CONTEXT_COPYVIDEOFRAME 9019
#define IDS_CONTENT_CONTEXT_OPENVIDEONEWTAB 9020
#define IDS_CONTENT_CONTEXT_SAVEAUDIOAS 9021
#define IDS_CONTENT_CONTEXT_COPYAUDIOLOCATION 9022
#define IDS_CONTENT_CONTEXT_OPENAUDIONEWTAB 9023
#define IDS_CONTENT_CONTEXT_PICTUREINPICTURE 9024
#define IDS_CONTENT_CONTEXT_UNDO 9025
#define IDS_CONTENT_CONTEXT_REDO 9026
#define IDS_CONTENT_CONTEXT_CUT 9027
#define IDS_CONTENT_CONTEXT_COPY 9028
#define IDS_CONTENT_CONTEXT_PASTE 9029
#define IDS_CONTENT_CONTEXT_PASTE_AND_MATCH_STYLE 9030
#define IDS_CONTENT_CONTEXT_ADD_TO_DICTIONARY 9031
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_MENU_OPTION 9032
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND 9033
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND_ONCE 9034
#define IDS_CONTENT_CONTEXT_PDF_OCR_MENU_OPTION 9035
#define IDS_CONTENT_CONTEXT_PDF_OCR_MENU_OPTION_ALWAYS 9036
#define IDS_CONTENT_CONTEXT_PDF_OCR_MENU_OPTION_ONCE 9037
#define IDS_CONTENT_CONTEXT_RUN_LAYOUT_EXTRACTION 9038
#define IDS_CONTENT_CONTEXT_SPELLING_ASK_GOOGLE 9039
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TITLE 9040
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_ENABLE 9041
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_DISABLE 9042
#define IDS_CONTENT_CONTEXT_SPELLING_CHECKING 9043
#define IDS_CONTENT_CONTEXT_SPELLING_NO_SUGGESTIONS_FROM_GOOGLE 9044
#define IDS_CONTENT_CONTEXT_SELECTALL 9045
#define IDS_CONTENT_CONTEXT_PARTIAL_TRANSLATE 9046
#define IDS_CONTENT_CONTEXT_SEARCHWEBFOR 9047
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORNEWTAB 9048
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORIMAGE 9049
#define IDS_CONTENT_CONTEXT_SEARCHLENSFORIMAGE 9050
#define IDS_CONTENT_CONTEXT_SEARCHLENSFORIMAGE_ALT_TEXT 9051
#define IDS_CONTENT_CONTEXT_TRANSLATEIMAGE 9052
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT1 9053
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH 9054
#define IDS_CONTENT_CONTEXT_GOTOURL 9055
#define IDS_CONTENT_CONTEXT_GENERATEPASSWORD 9056
#define IDS_CONTENT_CONTEXT_MORE_APPS 9057
#define IDS_CONTENT_CONTEXT_OPEN_WITH_APP 9058
#define IDS_CONTENT_CONTEXT_AUTOFILL_FEEDBACK 9059
#define IDS_SHARE_MENU_TITLE 9060
#define IDS_CONTENT_CONTEXT_PLUGIN_RUN 9061
#define IDS_CONTENT_CONTEXT_PLUGIN_HIDE 9062
#define IDS_CONTENT_CONTEXT_ENABLE_FLASH 9063
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MENU 9065
#define IDS_CONTENT_CONTEXT_LANGUAGE_SETTINGS 9064
#define IDS_CONTENT_CONTEXT_SPELLCHECK_MULTI_LINGUAL 9066
#define IDS_CONTENT_CONTEXT_CHECK_SPELLING_WHILE_TYPING 9067
#define IDS_ADDRESSES_AND_MORE_SUBMENU_OPTION 9068
#define IDS_PASSWORDS_AND_AUTOFILL_MENU 9069
#define IDS_NEW_TAB 9070
#define IDS_NEW_INCOGNITO_TAB 9071
#define IDS_SHOW_AS_TAB 9072
#define IDS_NEW_WINDOW 9073
#define IDS_NEW_INCOGNITO_WINDOW 9074
#define IDS_PROFILE_ROW_SIGNED_IN_MESSAGE 9075
#define IDS_PROFILE_ROW_SYNC_IS_ON 9076
#define IDS_PROFILE_ROW_TURN_ON_SYNC 9077
#define IDS_PROFILE_ROW_SYNC_ERROR_MESSAGE 9078
#define IDS_PROFILE_ROW_SIGN_IN_AGAIN 9079
#define IDS_EDIT2 9080
#define IDS_CUT 9081
#define IDS_COPY 9082
#define IDS_PASTE 9083
#define IDS_DELETE 9084
#define IDS_FIND 9085
#define IDS_FIND_AND_EDIT_MENU 9086
#define IDS_PAYMENT_METHOD_SUBMENU_OPTION 9087
#define IDS_SAVE_AND_SHARE_MENU 9088
#define IDS_SAVE_AND_SHARE_MENU_SAVE 9089
#define IDS_SAVE_AND_SHARE_MENU_SHARE 9090
#define IDS_SAVE_PAGE 9091
#define IDS_DISTILL_PAGE 9092
#define IDS_EXIT_DISTILLED_PAGE 9093
#define IDS_MORE_TOOLS_MENU 9094
#define IDS_ZOOM_MENU 9095
#define IDS_ZOOM_MENU2 9096
#define IDS_ZOOM_PLUS 9097
#define IDS_ZOOM_PLUS2 9098
#define IDS_ZOOM_NORMAL 9099
#define IDS_ZOOM_MINUS 9100
#define IDS_ZOOM_MINUS2 9101
#define IDS_COPY_URL 9102
#define IDS_OPEN_IN_APP_WINDOW 9103
#define IDS_MOVE_TAB_TO_NEW_WINDOW 9104
#define IDS_TOGGLE_QUICK_COMMANDS 9105
#define IDS_SEARCH_TABS 9106
#define IDS_CUSTOMIZE_CHROME 9107
#define IDS_CLOSE_PROFILE 9108
#define IDS_MANAGE_GOOGLE_ACCOUNT 9109
#define IDS_OTHER_CHROME_PROFILES_TITLE 9110
#define IDS_OPEN_GUEST_PROFILE 9111
#define IDS_ADD_NEW_PROFILE 9112
#define IDS_MANAGE_CHROME_PROFILES 9113
#define IDS_ACCNAME_ZOOM_PLUS2 9115
#define IDS_ACCNAME_ZOOM_MINUS2 9116
#define IDS_VIEW_SOURCE 9117
#define IDS_FEEDBACK 9118
#define IDS_DEV_TOOLS 9119
#define IDS_DEV_TOOLS_ELEMENTS 9120
#define IDS_DEV_TOOLS_CONSOLE 9121
#define IDS_DEV_TOOLS_DEVICES 9122
#define IDS_TASK_MANAGER 9123
#define IDS_TAKE_SCREENSHOT 9124
#define IDS_RESTORE_ALL_TABS 9125
#define IDS_RESTORE_TAB 9126
#define IDS_REOPEN_WINDOW 9127
#define IDS_REOPEN_GROUP 9128
#define IDS_RESTORE_WINDOW 9129
#define IDS_RESTORE_GROUP 9130
#define IDS_NAME_WINDOW 9131
#define IDS_CHROMELABS 9132
#define IDS_TOS_NOTIFICATION_TITLE 9135
#define IDS_TOS_NOTIFICATION_BODY_TEXT 9136
#define IDS_TOS_NOTIFICATION_ACK_BUTTON_TEXT 9137
#define IDS_TOS_NOTIFICATION_REVIEW_BUTTON_TEXT 9138
#define IDS_TOS_NOTIFICATION_LINK 9139
#define IDS_HELP_MENU 9140
#define IDS_MANAGED 9141
#define IDS_MANAGED_BY 9142
#define IDS_MANAGED_BY_PARENT 9143
#define IDS_PROFILE_MANAGED_BY 9144
#define IDS_BROWSER_PROFILE_MANAGED 9145
#define IDS_CHROME_TIPS 9146
#define IDS_CHROME_WHATS_NEW 9147
#define IDS_IMPORT_SETTINGS_MENU_LABEL 9148
#define IDS_PROFILING_ENABLED 9149
#define IDS_FULLSCREEN 9150
#define IDS_CLEAR_BROWSING_DATA 9151
#define IDS_SHOW_DOWNLOADS 9152
#define IDS_SHOW_EXTENSIONS 9153
#define IDS_EXTENSIONS_SUBMENU 9154
#define IDS_EXTENSIONS_SUBMENU_MANAGE_EXTENSIONS_ITEM 9155
#define IDS_EXTENSIONS_SUBMENU_CHROME_WEBSTORE_ITEM 9156
#define IDS_SHOW_PERFORMANCE 9157
#define IDS_SHOW_SEARCH_COMPANION 9158
#define IDS_SHOW_TRANSLATE 9159
#define IDS_SETTINGS 9160
#define IDS_OPTIONS 9161
#define IDS_HELP_PAGE 9162
#define IDS_BETA_FORUM 9163
#define IDS_GET_HELP 9164
#define IDS_EXIT 9165
#define IDS_AUTOCOMPLETE_MATCH_DESCRIPTION_SEPARATOR 667
#define IDS_MANAGE_SEARCH_ENGINES 9166
#define IDS_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 9167
#define IDS_SEARCH_ENGINES_EDITOR_KEYWORD_COLUMN 9168
#define IDS_SEARCH_ENGINES_EDITOR_DESCRIPTION_COLUMN 9169
#define IDS_SEARCH_ENGINES_EDITOR_DEFAULT_ENGINE 9170
#define IDS_ACCNAME_DOWNLOADS_BAR 9171
#define IDS_HIDE_DOWNLOADS 9172
#define IDS_SHOW_ALL_DOWNLOADS 9173
#define IDS_DOWNLOAD_STARTED 9174
#define IDS_DOWNLOAD_INTERRUPTED_STATUS 9175
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_ACCESS_DENIED 9176
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_ACCESS_DENIED 9177
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_PATH_TOO_LONG 9178
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_PATH_TOO_LONG 9179
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_DISK_FULL 9180
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_DISK_FULL 9181
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_LARGE 9182
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_LARGE 9183
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_TEMPORARY_PROBLEM 9184
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_TEMPORARY_PROBLEM 9185
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_VIRUS 9186
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_VIRUS 9187
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_BLOCKED 9188
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_BLOCKED 9189
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CONTENT_LENGTH_MISMATCH 9190
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CONTENT_LENGTH_MISMATCH 9191
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SECURITY_CHECK_FAILED 9192
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SECURITY_CHECK_FAILED 9193
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_SHORT 9194
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_SHORT 9195
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_SAME_AS_SOURCE 9196
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_SAME_AS_SOURCE 9197
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_TIMEOUT 9198
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_TIMEOUT 9199
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_DISCONNECTED 9200
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_DISCONNECTED 9201
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_DOWN 9202
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_DOWN 9203
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_ERROR 9204
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_ERROR 9205
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NO_FILE 9206
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NO_FILE 9207
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_PROBLEM 9208
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_PROBLEM 9209
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_WEB_DRIVE_ERROR 9210
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SHUTDOWN 9211
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SHUTDOWN 9212
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CRASH 9213
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CRASH 9214
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNAUTHORIZED 9215
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNAUTHORIZED 9216
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_CERT_PROBLEM 9217
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_CERT_PROBLEM 9218
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FORBIDDEN 9219
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FORBIDDEN 9220
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNREACHABLE 9221
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNREACHABLE 9222
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN_WHEN_COMPLETE 9223
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN 9224
#define IDS_DOWNLOAD_STATUS_STARTING 9225
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS 9235
#define IDS_DOWNLOAD_STATUS_SIZES 9236
#define IDS_DOWNLOAD_STATUS_OPEN_IN 9237
#define IDS_DOWNLOAD_STATUS_OPEN_WHEN_COMPLETE 9238
#define IDS_DOWNLOAD_STATUS_OPENING 9239
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_SHORT 9240
#define IDS_DOWNLOAD_STATUS_CANCELLED 9241
#define IDS_DOWNLOAD_STATUS_REMOVED 9242
#define IDS_DOWNLOAD_STATUS_UPLOADING 9243
#define IDS_DOWNLOAD_STATUS_UPLOADED 9244
#define IDS_DOWNLOAD_STATUS_UPLOAD_INTERRUPTED 9245
#define IDS_DOWNLOAD_STATUS_INTERRUPTED 9246
#define IDS_DOWNLOAD_UNCONFIRMED_PREFIX 9247
#define IDS_PROMPT_DANGEROUS_DOWNLOAD 9248
#define IDS_PROMPT_DANGEROUS_DOWNLOAD_EXTENSION 9249
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT 9250
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT_IN_ADVANCED_PROTECTION 9251
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD 9252
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD_SHORT 9253
#define IDS_PROMPT_DEEP_SCANNING_APP_DOWNLOAD 9254
#define IDS_PROMPT_CONFIRM_INSECURE_DOWNLOAD 9255
#define IDS_PROMPT_DOWNLOAD_BLOCKED_TOO_LARGE 9256
#define IDS_PROMPT_DOWNLOAD_BLOCKED_PASSWORD_PROTECTED 9257
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_SAFE 9258
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_WARNING 9259
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_BLOCKED 9260
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_OPENED_DANGEROUS 9261
#define IDS_PROMPT_DOWNLOAD_INSECURE_WARNING 9262
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED 9263
#define IDS_PROMPT_APP_DEEP_SCANNING 9264
#define IDS_PROMPT_DEEP_SCANNING 9265
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD 9266
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD_IN_ADVANCED_PROTECTION 9267
#define IDS_BLOCK_REASON_GENERIC_DOWNLOAD 9268
#define IDS_BLOCK_REASON_INSECURE_DOWNLOAD 9269
#define IDS_BLOCK_REASON_DEEP_SCANNING 9270
#define IDS_BLOCK_REASON_DEEP_SCANNING_UPDATED 9271
#define IDS_BLOCK_REASON_DEEP_SCANNING_SECOND_UPDATED 9272
#define IDS_BLOCK_REASON_ACCOUNT_COMPROMISE 9273
#define IDS_BLOCK_REASON_PROMPT_FOR_SCANNING_UPDATED 9274
#define IDS_DEEP_SCANNED_SAFE_DESCRIPTION 9275
#define IDS_DEEP_SCANNED_OPENED_DANGEROUS_DESCRIPTION 9276
#define IDS_BLOCK_REASON_SENSITIVE_CONTENT_WARNING 9277
#define IDS_SENSITIVE_CONTENT_BLOCKED_DESCRIPTION 9278
#define IDS_BLOCKED_TOO_LARGE_DESCRIPTION 9279
#define IDS_BLOCKED_PASSWORD_PROTECTED_DESCRIPTION 9280
#define IDS_DEEP_SCANNED_FAILED_DESCRIPTION 9281
#define IDS_CONFIRM_KEEP_DANGEROUS_DOWNLOAD_TITLE 9285
#define IDS_KEEP_DANGEROUS_DOWNLOAD_TITLE 9286
#define IDS_KEEP_UNCOMMON_DOWNLOAD_TITLE 9287
#define IDS_PROMPT_CONFIRM_KEEP_DANGEROUS_DOWNLOAD 9288
#define IDS_PROMPT_CONFIRM_KEEP_MALICIOUS_DOWNLOAD_BODY 9289
#define IDS_CONFIRM_DOWNLOAD_AGAIN 9290
#define IDS_CONFIRM_DOWNLOAD 9291
#define IDS_CONFIRM_DOWNLOAD_RESTORE 9292
#define IDS_CONTINUE_EXTENSION_DOWNLOAD 9293
#define IDS_DISCARD_DOWNLOAD 9294
#define IDS_OPEN_DOWNLOAD_NOW 9295
#define IDS_SCAN_DOWNLOAD 9296
#define IDS_REVIEW_DOWNLOAD 9297
#define IDS_OPEN_DOWNLOAD_ANYWAY 9298
#define IDS_DOWNLOAD_LINK_PAUSE 9299
#define IDS_DOWNLOAD_SEARCH 9300
#define IDS_DOWNLOAD_NO_DOWNLOADS 9301
#define IDS_DOWNLOAD_ITEM_DROPDOWN_BUTTON_ACCESSIBLE_TEXT 9302
#define IDS_DOWNLOAD_LINK_RESUME 9303
#define IDS_DOWNLOAD_LINK_REMOVE 9304
#define IDS_DOWNLOAD_LINK_REMOVE_ARIA_LABEL 9305
#define IDS_DOWNLOAD_LINK_CANCEL 9306
#define IDS_DOWNLOAD_LINK_RETRY 9307
#define IDS_DOWNLOAD_LINK_SHOW_IN_WEB_DRIVE 9308
#define IDS_DOWNLOAD_LINK_SHOW 9309
#define IDS_DOWNLOAD_TAB_CANCELLED 9310
#define IDS_DOWNLOAD_FILE_REMOVED 9311
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS_TIME_UNKNOWN 9312
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS 9313
#define IDS_DOWNLOAD_TAB_PROGRESS_SIZE 9314
#define IDS_DOWNLOAD_PROGRESS_PAUSED 9315
#define IDS_DOWNLOAD_LINK_CLEAR_ALL 9316
#define IDS_DOWNLOAD_LINK_OPEN_DOWNLOADS_FOLDER 9317
#define IDS_DOWNLOAD_MORE_ACTIONS 9318
#define IDS_DOWNLOAD_ACTION_MENU_DESCRIPTION 9319
#define IDS_DOWNLOAD_BY_EXTENSION_URL 9320
#define IDS_DOWNLOAD_IN_INCOGNITO 9321
#define IDS_UNDO_DESCRIPTION 482
#define IDS_DOWNLOAD_UNDO 9322
#define IDS_DOWNLOAD_TOAST_REMOVED_FROM_LIST 9323
#define IDS_DOWNLOAD_TOAST_CLEARED_ALL 9324
#define IDS_DOWNLOAD_DEEP_SCAN 9325
#define IDS_DOWNLOAD_DEEP_SCAN_UPDATED 9326
#define IDS_DOWNLOAD_BYPASS_DEEP_SCAN 9327
#define IDS_DOWNLOAD_BYPASS_DEEP_SCAN_UPDATED 9328
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_ACCESSIBLE_ALERT 9329
#define IDS_DOWNLOAD_STATUS_PERCENT_COMPLETE_ACCESSIBLE_ALERT 9330
#define IDS_DOWNLOAD_STATUS_TIME_REMAINING_ACCESSIBLE_ALERT 9331
#define IDS_DOWNLOAD_FAILED_ACCESSIBLE_ALERT 9332
#define IDS_DOWNLOAD_CANCELLED_ACCESSIBLE_ALERT 9333
#define IDS_DOWNLOAD_COMPLETE_ACCESSIBLE_ALERT 9334
#define IDS_PROMPT_APP_DEEP_SCANNING_ACCESSIBLE_ALERT 9335
#define IDS_PROMPT_DEEP_SCANNING_ACCESSIBLE_ALERT 9336
#define IDS_DEEP_SCANNING_ACCESSIBLE_ALERT 9337
#define IDS_PROMPT_DOWNLOAD_INSECURE_BLOCKED_ACCESSIBLE_ALERT 9338
#define IDS_DOWNLOAD_NOTIFICATION_COPY_TO_CLIPBOARD 9339
#define IDS_DOWNLOAD_MENU_SHOW 9340
#define IDS_DOWNLOAD_MENU_OPEN_WHEN_COMPLETE 9341
#define IDS_DOWNLOAD_MENU_OPEN 9342
#define IDS_DOWNLOAD_MENU_ALWAYS_OPEN_TYPE 9343
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN 9344
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN_ALWAYS 9345
#define IDS_DOWNLOAD_MENU_CANCEL 9346
#define IDS_DOWNLOAD_MENU_PAUSE_ITEM 9347
#define IDS_DOWNLOAD_MENU_RESUME_ITEM 9348
#define IDS_DOWNLOAD_MENU_DISCARD 9349
#define IDS_DOWNLOAD_MENU_KEEP 9350
#define IDS_DOWNLOAD_MENU_LEARN_MORE_SCANNING 9351
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INTERRUPTED 9352
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INSECURE 9353
#define IDS_DOWNLOAD_MENU_ALWAYS_OPEN_PDF_IN_READER 9354
#define IDS_DOWNLOAD_MENU_DEEP_SCAN 9355
#define IDS_ABANDON_DOWNLOAD_DIALOG_TITLE 9366
#define IDS_ABANDON_DOWNLOAD_DIALOG_CONTINUE_BUTTON 9367
#define IDS_ABANDON_DOWNLOAD_DIALOG_INCOGNITO_MESSAGE 9368
#define IDS_ABANDON_DOWNLOAD_DIALOG_GUEST_MESSAGE 9369
#define IDS_ABANDON_DOWNLOAD_DIALOG_EXIT_BUTTON 9370
#define IDS_DOWNLOAD_BUBBLE_HEADER_LABEL 9371
#define IDS_DOWNLOAD_BUBBLE_FOOTER_LABEL 9372
#define IDS_DOWNLOAD_BUBBLE_FOOTER_TOOLTIP_LABEL 9373
#define IDS_DOWNLOAD_BUBBLE_HEADER_TEXT 9374
#define IDS_DOWNLOAD_BUBBLE_FOOTER_LINK 9375
#define IDS_DOWNLOAD_BUBBLE_FOOTER_TOOLTIP 9376
#define IDS_DOWNLOAD_BUBBLE_PROMO 9377
#define IDS_DOWNLOAD_BUBBLE_PROMO_SCREENREADER 9378
#define IDS_DOWNLOAD_BUBBLE_PROMO_TITLE 391
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_MESSAGE_WITH_SEPARATOR 9379
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_WITH_SYMBOL 9380
#define IDS_DOWNLOAD_BUBBLE_STATUS_RESUMING 9381
#define IDS_DOWNLOAD_BUBBLE_STATUS_DONE 9382
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_DONE 9383
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_DONE_UPDATED 9384
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_INSECURE 9385
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_SUSPICIOUS 9386
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_DANGEROUS 9387
#define IDS_DOWNLOAD_BUBBLE_STATUS_WARNING_UNVERIFIED 9388
#define IDS_DOWNLOAD_BUBBLE_STATUS_BLOCKED 9389
#define IDS_DOWNLOAD_BUBBLE_STATUS_MALWARE 9390
#define IDS_DOWNLOAD_BUBBLE_STATUS_SUSPICIOUS 9391
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNED_FAILED_UPDATED 9392
#define IDS_DOWNLOAD_BUBBLE_CHECKBOX_BYPASS 9393
#define IDS_DOWNLOAD_BUBBLE_CONTINUE 9394
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_INSECURE_FILE 9395
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_SUSPICIOUS_FILE 9396
#define IDS_DOWNLOAD_BUBBLE_CONTINUE_UNVERIFIED_FILE 9397
#define IDS_DOWNLOAD_BUBBLE_DELETE 9398
#define IDS_DOWNLOAD_BUBBLE_DELETE_FROM_HISTORY 9399
#define IDS_DOWNLOAD_BUBBLE_MAIN_BUTTON_SUBPAGE 9400
#define IDS_DOWNLOAD_BUBBLE_RESUME 9401
#define IDS_DOWNLOAD_BUBBLE_SCAN 9402
#define IDS_DOWNLOAD_BUBBLE_OPEN 9403
#define IDS_DOWNLOAD_BUBBLE_SCAN_UPDATED 9404
#define IDS_DOWNLOAD_BUBBLE_OPEN_UPDATED 9405
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW 9406
#define IDS_DOWNLOAD_BUBBLE_REVIEW 9407
#define IDS_DOWNLOAD_BUBBLE_RETRY 9408
#define IDS_DOWNLOAD_BUBBLE_OPEN_ANYWAY 9409
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_DISK_FULL 9410
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_DISK_FULL 9411
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_PATH_TOO_LONG 9412
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_PATH_TOO_LONG 9413
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NEEDS_PERMISSION 9414
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_TOO_LARGE 9415
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_TOO_LARGE 9416
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_UNFINISHED 9417
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_BLOCKED_ORGANIZATION 9418
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_BLOCKED_ORGANIZATION 9419
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_WRONG 9420
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NETWORK_ERROR 9421
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_SITE_UNAVAILABLE 9422
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNAVAILABLE 9423
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_UNAVAILABLE 9424
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNFINISHED 9425
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_INSECURE 9426
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS 9427
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DECEPTIVE 9428
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_DANGEROUS_FILE_TYPE 9429
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_UNCOMMON_FILE 9430
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_NO_SAFE_BROWSING 9431
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_BLOCKED_LEARN_MORE_LABEL 9432
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LABEL 9433
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_SAFE_BROWSING_SETTING_LINK 9434
#define IDS_DOWNLOAD_BUBBLE_STATUS_DANGEROUS 9435
#define IDS_DOWNLOAD_BUBBLE_STATUS_ENCRYPTED 9436
#define IDS_DOWNLOAD_BUBBLE_STATUS_TOO_BIG 9437
#define IDS_DOWNLOAD_BUBBLE_STATUS_ADVANCED_PROTECTION 9438
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ADVANCED_PROTECTION 9439
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNCOMMON_FILE 9440
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNCOMMON_FILE 9441
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNKNOWN_SOURCE 9442
#define IDS_DOWNLOAD_BUBBLE_STATUS_SENSITIVE_CONTENT 9443
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_WARNING 9444
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_BLOCK 9445
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ENCRYPTED 9446
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_TOO_BIG 9447
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT_UPDATED 9448
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_DEEP_SCANNING_LINK 9449
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING 9450
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_SECONDARY 9451
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_ENTERPRISE_SECONDARY 9452
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_DISCARD 9453
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ASYNC_SCANNING_CANCEL 9454
#define IDS_DOWNLOAD_BUBBLE_TRY_AGAIN 9455
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_PROMPT 9456
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_PROMPT_UPDATED 9457
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING 9458
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING_ENTERPRISE 9459
#define IDS_DOWNLOAD_BUBBLE_INCOGNITO_INFORMATION_ROW 9460
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION 9461
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION_ACCESSIBILITY 9462
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION 9463
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION_ACCESSIBILITY 9464
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION 9465
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION_ACCESSIBILITY 9466
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION 9467
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION_ACCESSIBILITY 9468
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION 9469
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION_ACCESSIBILITY 9470
#define IDS_DOWNLOAD_BUBBLE_BACK_RECENT_DOWNLOADS 9471
#define IDS_DOWNLOAD_BUBBLE_CANCEL_MAIN_BUTTON_ACCESSIBILITY 9472
#define IDS_DOWNLOAD_BUBBLE_DELETE_MAIN_BUTTON_ACCESSIBILITY 9473
#define IDS_DOWNLOAD_BUBBLE_KEEP_MAIN_BUTTON_ACCESSIBILITY 9474
#define IDS_DOWNLOAD_BUBBLE_SCAN_MAIN_BUTTON_ACCESSIBILITY 9475
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW_MAIN_BUTTON_ACCESSIBILITY 9476
#define IDS_DOWNLOAD_BUBBLE_RESUME_MAIN_BUTTON_ACCESSIBILITY 9477
#define IDS_DOWNLOAD_BUBBLE_REVIEW_MAIN_BUTTON_ACCESSIBILITY 9478
#define IDS_DOWNLOAD_BUBBLE_RETRY_MAIN_BUTTON_ACCESSIBILITY 9479
#define IDS_DOWNLOAD_BUBBLE_OPEN_MAIN_BUTTON_ACCESSIBILITY 9480
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW 9481
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_REMINDER 9482
#define IDS_DOWNLOAD_BUBBLE_SUPPRESS_PARTIAL_VIEW_SETTINGS_LINK 9483
#define IDS_DOWNLOAD_BUBBLE_TOOLTIP_IN_PROGRESS_COUNT 9484
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT 9485
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_COOKIE_THEFT_AND_ACCOUNT 9486
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_WARNING_MALWARE 9487
#define IDS_OMNIBOX_PWA_INSTALL_ICON_LABEL 453
#define IDS_OMNIBOX_PWA_INSTALL_ICON_TOOLTIP 688
#define IDS_ADD_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 9488
#define IDS_CREATE_SHORTCUTS_BUTTON_LABEL 9489
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 9490
#define IDS_INSTALL_PWA_BUTTON_LABEL 9491
#define IDS_BOOKMARK_APP_AX_BUBBLE_NAME_LABEL 9492
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TAB 9493
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_WINDOW 9494
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TABBED_WINDOW 9495
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME 9496
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_ICON 9497
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_ICON 9498
#define IDS_WEBAPP_UPDATE_EXPLANATION 9499
#define IDS_WEBAPP_UPDATE_CURRENT_ICON 9500
#define IDS_WEBAPP_UPDATE_NEW_ICON 9501
#define IDS_WEBAPP_UPDATE_NEGATIVE_BUTTON 9502
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION 9503
#define IDS_FINISH_POLICY_WEB_APP_INSTALATION_RESTART 9504
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION_NOT_NOW 9505
#define IDS_ADD_TO_OS_LAUNCH_SURFACE 9510
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE 9511
#define IDS_UNINSTALL_FROM_OS_LAUNCH_SURFACE 9512
#define IDS_APPLICATION_INFO_WEB_STORE_LINK 9513
#define IDS_APPLICATION_INFO_HOMEPAGE_LINK 9514
#define IDS_ARC_APPLICATION_INFO_MANAGE_LINK 9515
#define IDS_APPLICATION_INFO_APP_OVERVIEW_TITLE 9516
#define IDS_APPLICATION_INFO_APP_PERMISSIONS_TITLE 9517
#define IDS_APPLICATION_INFO_UNINSTALL_BUTTON_TEXT 9518
#define IDS_APPLICATION_INFO_LICENSES_BUTTON_TEXT 9519
#define IDS_APPLICATION_INFO_SIZE_LABEL 9520
#define IDS_APPLICATION_INFO_VERSION_LABEL 9521
#define IDS_APPLICATION_INFO_CREATE_SHORTCUTS_BUTTON_TEXT 9522
#define IDS_APPLICATION_INFO_LAUNCH_OPTIONS_ACCNAME 9523
#define IDS_APPLICATION_INFO_SIZE_LOADING_LABEL 9524
#define IDS_APPLICATION_INFO_SIZE_SMALL_LABEL 9525
#define IDS_APPLICATION_INFO_REVOKE_PERMISSION_ALT_TEXT 9526
#define IDS_APPLICATION_INFO_APP_NO_PERMISSIONS_TEXT 9527
#define IDS_APPLICATION_INFO_EXTENSION_NO_PERMISSIONS_TEXT 9528
#define IDS_APPLICATION_INFO_RETAINED_FILES 9529
#define IDS_APPLICATION_INFO_RETAINED_DEVICES 9530
#define IDS_CREATE_SHORTCUTS_TITLE 9531
#define IDS_CREATE_SHORTCUTS_LABEL 9532
#define IDS_CREATE_SHORTCUTS_DESKTOP_CHKBOX 9533
#define IDS_CREATE_SHORTCUTS_MENU_CHKBOX 9534
#define IDS_CREATE_SHORTCUTS_COMMIT 9535
#define IDS_CREATE_SHORTCUTS_START_MENU_CHKBOX 9536
#define IDS_PIN_TO_TASKBAR_CHKBOX 9537
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_TITLE 9538
#define IDS_BLUETOOTH_DEVICE_CREDENTIALS_LABEL 9539
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_TITLE 9540
#define IDS_BLUETOOTH_DEVICE_PAIR_CONFIRM_LABEL 9541
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_TITLE 9542
#define IDS_BLUETOOTH_DEVICE_PASSKEY_CONFIRM_LABEL 9543
#define IDS_MANAGE 9544
#define IDS_LIST_BULLET 9545
#define IDS_BLOCKED_DOWNLOAD_NO_ACTION 9546
#define IDS_BLOCKED_DOWNLOAD_UNBLOCK 9547
#define IDS_ALLOWED_DOWNLOAD_TITLE 9548
#define IDS_BLOCKED_DOWNLOAD_TITLE 9549
#define IDS_BLOCKED_DOWNLOADS_EXPLANATION 9550
#define IDS_ALLOWED_DOWNLOAD_NO_ACTION 9551
#define IDS_ALLOWED_DOWNLOAD_BLOCK 9552
#define IDS_BLOCKED_COOKIES_TITLE 9553
#define IDS_ACCESSED_COOKIES_TITLE 9554
#define IDS_BLOCKED_COOKIES_MESSAGE 9555
#define IDS_ACCESSED_COOKIES_MESSAGE 9556
#define IDS_BLOCKED_COOKIES_INFO 9557
#define IDS_BLOCKED_IMAGES_TITLE 9558
#define IDS_BLOCKED_IMAGES_MESSAGE 9559
#define IDS_BLOCKED_COOKIES_UNBLOCK 9560
#define IDS_BLOCKED_IMAGES_UNBLOCK 9561
#define IDS_BLOCKED_COOKIES_NO_ACTION 9562
#define IDS_ALLOWED_COOKIES_NO_ACTION 9563
#define IDS_ALLOWED_COOKIES_BLOCK 9564
#define IDS_BLOCKED_IMAGES_NO_ACTION 9565
#define IDS_BLOCKED_POPUPS_TOOLTIP 9566
#define IDS_BLOCKED_POPUPS_TITLE 9567
#define IDS_BLOCKED_POPUPS_REDIRECTS_UNBLOCK 9568
#define IDS_BLOCKED_POPUPS_REDIRECTS_NO_ACTION 9569
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ALLOW 9570
#define IDS_BLOCKED_MEDIASTREAM_MIC_ALLOW 9571
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ALLOW 9572
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ASK 9573
#define IDS_BLOCKED_MEDIASTREAM_MIC_ASK 9574
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ASK 9575
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_BLOCK 9576
#define IDS_ALLOWED_MEDIASTREAM_MIC_BLOCK 9577
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_BLOCK 9578
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 9579
#define IDS_BLOCKED_MEDIASTREAM_MIC_NO_ACTION 9580
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_NO_ACTION 9581
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 9582
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_PAN_TILT_ZOOM_NO_ACTION 9583
#define IDS_ALLOWED_MEDIASTREAM_MIC_NO_ACTION 9584
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_NO_ACTION 9585
#define IDS_ALLOWED_CAMERA_PAN_TILT_ZOOM_NO_ACTION 9586
#define IDS_BLOCKED_POPUPS_EXPLANATORY_TEXT 9587
#define IDS_BLOCKED_JAVASCRIPT_TITLE 9588
#define IDS_BLOCKED_JAVASCRIPT_MESSAGE 9589
#define IDS_BLOCKED_JAVASCRIPT_UNBLOCK 9590
#define IDS_BLOCKED_JAVASCRIPT_NO_ACTION 9591
#define IDS_BLOCKED_SOUND_TITLE 9592
#define IDS_BLOCKED_SOUND_UNBLOCK 9593
#define IDS_BLOCKED_SOUND_NO_ACTION 9594
#define IDS_NOTIFICATIONS_OFF_EXPLANATORY_TEXT 442
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_TITLE 9595
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DESCRIPTION 9596
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_DESCRIPTION 9597
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 9598
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_COMPACT_ALLOW_BUTTON 9599
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CONTINUE_BLOCKING_BUTTON 9600
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_EARLY_PROMO 9601
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_NEW_REQUEST_PROMO 9602
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 9603
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ABUSIVE_DESCRIPTION 9604
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DISRUPTIVE_DESCRIPTION 9605
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 9606
#define IDS_GEOLOCATION_OFF_EXPLANATORY_TEXT 9607
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_TITLE 9608
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 9609
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 9610
#define IDS_STORAGE_ACCESS_PERMISSION_BUBBLE_MESSAGE 9611
#define IDS_STORAGE_ACCESS_PERMISSION_ALLOWED_TOOLTIP 9612
#define IDS_STORAGE_ACCESS_PERMISSION_BLOCKED_TOOLTIP 9613
#define IDS_COOKIE_CONTROLS_DIALOG_TITLE 9614
#define IDS_COOKIE_CONTROLS_DIALOG_TITLE_ALL_BLOCKED 9615
#define IDS_COOKIE_CONTROLS_DIALOG_TITLE_OFF 9616
#define IDS_COOKIE_CONTROLS_TURN_ON_BUTTON 9617
#define IDS_COOKIE_CONTROLS_TURN_OFF_BUTTON 9618
#define IDS_COOKIE_CONTROLS_NOT_WORKING_TITLE 9619
#define IDS_COOKIE_CONTROLS_NOT_WORKING_DESCRIPTION 9620
#define IDS_COOKIE_CONTROLS_BLOCKED_MESSAGE 9621
#define IDS_COOKIE_CONTROLS_TOOLTIP 458
#define IDS_COOKIE_CONTROLS_HELP 9622
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_BLOCKED_TITLE 9623
#define IDS_COOKIE_CONTROLS_BUBBLE_COOKIES_ALLOWED_TITLE 9624
#define IDS_COOKIE_CONTROLS_BUBBLE_SITE_NOT_WORKING_TITLE 9625
#define IDS_COOKIE_CONTROLS_BUBBLE_SITE_NOT_WORKING_DESCRIPTION_TEMPORARY 9626
#define IDS_COOKIE_CONTROLS_BUBBLE_SITE_NOT_WORKING_DESCRIPTION_PERMANENT 9627
#define IDS_COOKIE_CONTROLS_BUBBLE_BLOCKING_RESTART_TITLE 9628
#define IDS_COOKIE_CONTROLS_BUBBLE_BLOCKING_RESTART_DESCRIPTION_TODAY 9629
#define IDS_COOKIE_CONTROLS_BUBBLE_PERMANENT_ALLOWED_TITLE 9630
#define IDS_COOKIE_CONTROLS_BUBBLE_PERMANENT_ALLOWED_DESCRIPTION 9631
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_TITLE 9632
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_BUTTON_DESCRIPTION 9633
#define IDS_COOKIE_CONTROLS_BUBBLE_RELOADING_LABEL 9634
#define IDS_COOKIE_CONTROLS_BUBBLE_THIRD_PARTY_COOKIES_LABEL 9635
#define IDS_COOKIE_CONTROLS_BUBBLE_SEND_FEEDBACK_FORM_PLACEHOLDER 9636
#define IDS_COOKIE_CONTROLS_BUBBLE_BLOCKED_SITES_COUNT 9637
#define IDS_COOKIE_CONTROLS_BUBBLE_ALLOWED_SITES_COUNT 9638
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_ALLOWED_LABEL 9639
#define IDS_COOKIE_CONTROLS_PAGE_ACTION_COOKIES_BLOCKED_LABEL 9640
#define IDS_COOKIE_CONTROLS_PROMO_TITLE 9641
#define IDS_COOKIE_CONTROLS_PROMO_TEXT 9642
#define IDS_COOKIE_CONTROLS_PROMO_CLOSE_BUTTON_TEXT 9643
#define IDS_COOKIE_CONTROLS_PROMO_SEE_HOW_BUTTON_TEXT 9644
#define IDS_CERT_SELECTOR_SUBJECT_COLUMN 9645
#define IDS_CERT_SELECTOR_ISSUER_COLUMN 9646
#define IDS_CERT_SELECTOR_PROVIDER_COLUMN 9647
#define IDS_CERT_SELECTOR_SERIAL_COLUMN 9648
#define IDS_CERT_EXPORT_TYPE_BASE64 9649
#define IDS_CERT_EXPORT_TYPE_BASE64_CHAIN 9650
#define IDS_CERT_EXPORT_TYPE_DER 9651
#define IDS_CERT_EXPORT_TYPE_PKCS7 9652
#define IDS_CERT_EXPORT_TYPE_PKCS7_CHAIN 9653
#define IDS_CERT_INFO_DIALOG_TITLE 9654
#define IDS_CERT_INFO_GENERAL_TAB_LABEL 9655
#define IDS_CERT_INFO_DETAILS_TAB_LABEL 9656
#define IDS_CERT_USAGE_SSL_CLIENT 9657
#define IDS_CERT_USAGE_SSL_SERVER 9658
#define IDS_CERT_USAGE_OBJECT_SIGNER 9659
#define IDS_CERT_USAGE_SSL_CA 9660
#define IDS_CERT_INFO_IDN_VALUE_FORMAT 9661
#define IDS_CERT_INFO_FIELD_NOT_PRESENT 9662
#define IDS_CERT_DETAILS_CERTIFICATE_HIERARCHY_LABEL 9663
#define IDS_CERT_DETAILS_CERTIFICATE_FIELDS_LABEL 9664
#define IDS_CERT_DETAILS_CERTIFICATE_FIELD_VALUE_LABEL 9665
#define IDS_CERT_DETAILS_CERTIFICATE 9666
#define IDS_CERT_DETAILS_VERSION 9667
#define IDS_CERT_DETAILS_VERSION_FORMAT 9668
#define IDS_CERT_DETAILS_SERIAL_NUMBER 9669
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_ALG 9670
#define IDS_CERT_DETAILS_ISSUER 9671
#define IDS_CERT_DETAILS_VALIDITY 9672
#define IDS_CERT_DETAILS_NOT_BEFORE 9673
#define IDS_CERT_DETAILS_NOT_AFTER 9674
#define IDS_CERT_DETAILS_SUBJECT 9675
#define IDS_CERT_DETAILS_SUBJECT_KEY_INFO 9676
#define IDS_CERT_DETAILS_SUBJECT_KEY_ALG 9677
#define IDS_CERT_DETAILS_SUBJECT_KEY 9678
#define IDS_CERT_RSA_PUBLIC_KEY_DUMP_FORMAT 9679
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_VALUE 9680
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE 9681
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE_A11Y_LABEL 9682
#define IDS_CERT_OID_AVA_COMMON_NAME 9683
#define IDS_CERT_OID_AVA_STATE_OR_PROVINCE 9684
#define IDS_CERT_OID_AVA_ORGANIZATION_NAME 9685
#define IDS_CERT_OID_AVA_ORGANIZATIONAL_UNIT_NAME 9686
#define IDS_CERT_OID_AVA_DN_QUALIFIER 9687
#define IDS_CERT_OID_AVA_COUNTRY_NAME 9688
#define IDS_CERT_OID_AVA_SERIAL_NUMBER 9689
#define IDS_CERT_OID_AVA_LOCALITY 9690
#define IDS_CERT_OID_AVA_DC 9691
#define IDS_CERT_OID_RFC1274_MAIL 9692
#define IDS_CERT_OID_RFC1274_UID 9693
#define IDS_CERT_OID_PKCS9_EMAIL_ADDRESS 9694
#define IDS_CERT_OID_BUSINESS_CATEGORY 9695
#define IDS_CERT_OID_EV_INCORPORATION_LOCALITY 9696
#define IDS_CERT_OID_EV_INCORPORATION_STATE 9697
#define IDS_CERT_OID_EV_INCORPORATION_COUNTRY 9698
#define IDS_CERT_OID_AVA_STREET_ADDRESS 9699
#define IDS_CERT_OID_AVA_POSTAL_CODE 9700
#define IDS_CERT_OID_PKCS1_RSA_ENCRYPTION 9701
#define IDS_CERT_OID_PKCS1_MD2_WITH_RSA_ENCRYPTION 9702
#define IDS_CERT_OID_PKCS1_MD4_WITH_RSA_ENCRYPTION 9703
#define IDS_CERT_OID_PKCS1_MD5_WITH_RSA_ENCRYPTION 9704
#define IDS_CERT_OID_PKCS1_SHA1_WITH_RSA_ENCRYPTION 9705
#define IDS_CERT_OID_PKCS1_SHA256_WITH_RSA_ENCRYPTION 9706
#define IDS_CERT_OID_PKCS1_SHA384_WITH_RSA_ENCRYPTION 9707
#define IDS_CERT_OID_PKCS1_SHA512_WITH_RSA_ENCRYPTION 9708
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA1_SIGNATURE 9709
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA256_SIGNATURE 9710
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA384_SIGNATURE 9711
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA512_SIGNATURE 9712
#define IDS_CERT_OID_ANSIX962_EC_PUBLIC_KEY 9713
#define IDS_CERT_OID_SECG_EC_SECP256R1 9714
#define IDS_CERT_OID_SECG_EC_SECP384R1 9715
#define IDS_CERT_OID_SECG_EC_SECP521R1 9716
#define IDS_CERT_EXT_NS_CERT_TYPE 9717
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL 9718
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL_CA 9719
#define IDS_CERT_EXT_NS_CERT_BASE_URL 9720
#define IDS_CERT_EXT_NS_CERT_REVOCATION_URL 9721
#define IDS_CERT_EXT_NS_CA_REVOCATION_URL 9722
#define IDS_CERT_EXT_NS_CERT_RENEWAL_URL 9723
#define IDS_CERT_EXT_NS_CA_POLICY_URL 9724
#define IDS_CERT_EXT_NS_SSL_SERVER_NAME 9725
#define IDS_CERT_EXT_NS_COMMENT 9726
#define IDS_CERT_EXT_NS_LOST_PASSWORD_URL 9727
#define IDS_CERT_EXT_NS_CERT_RENEWAL_TIME 9728
#define IDS_CERT_X509_SUBJECT_DIRECTORY_ATTR 9729
#define IDS_CERT_X509_SUBJECT_KEYID 9730
#define IDS_CERT_KEYID_FORMAT 9731
#define IDS_CERT_ISSUER_FORMAT 9732
#define IDS_CERT_SERIAL_NUMBER_FORMAT 9733
#define IDS_CERT_X509_KEY_USAGE 9734
#define IDS_CERT_X509_ISSUER_ALT_NAME 9735
#define IDS_CERT_X509_BASIC_CONSTRAINTS 9736
#define IDS_CERT_X509_NAME_CONSTRAINTS 9737
#define IDS_CERT_X509_CRL_DIST_POINTS 9738
#define IDS_CERT_X509_CERT_POLICIES 9739
#define IDS_CERT_X509_SCT_LIST 9740
#define IDS_CERT_X509_POLICY_MAPPINGS 9741
#define IDS_CERT_X509_POLICY_CONSTRAINTS 9742
#define IDS_CERT_X509_AUTH_KEYID 9743
#define IDS_CERT_X509_EXT_KEY_USAGE 9744
#define IDS_CERT_X509_AUTH_INFO_ACCESS 9745
#define IDS_CERT_X509_KEY_USAGE_SIGNING 9746
#define IDS_CERT_X509_KEY_USAGE_NONREP 9747
#define IDS_CERT_X509_KEY_USAGE_ENCIPHERMENT 9748
#define IDS_CERT_X509_KEY_USAGE_DATA_ENCIPHERMENT 9749
#define IDS_CERT_X509_KEY_USAGE_KEY_AGREEMENT 9750
#define IDS_CERT_X509_KEY_USAGE_CERT_SIGNER 9751
#define IDS_CERT_X509_KEY_USAGE_CRL_SIGNER 9752
#define IDS_CERT_X509_KEY_USAGE_ENCIPHER_ONLY 9753
#define IDS_CERT_X509_KEY_USAGE_DECIPHER_ONLY 9754
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_CA 9755
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_NOT_CA 9756
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN 9757
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN_UNLIMITED 9758
#define IDS_CERT_PKIX_CPS_POINTER_QUALIFIER 9759
#define IDS_CERT_PKIX_USER_NOTICE_QUALIFIER 9760
#define IDS_CERT_REVOCATION_REASON_UNUSED 9761
#define IDS_CERT_REVOCATION_REASON_KEY_COMPROMISE 9762
#define IDS_CERT_REVOCATION_REASON_CA_COMPROMISE 9763
#define IDS_CERT_REVOCATION_REASON_AFFILIATION_CHANGED 9764
#define IDS_CERT_REVOCATION_REASON_SUPERSEDED 9765
#define IDS_CERT_REVOCATION_REASON_CESSATION_OF_OPERATION 9766
#define IDS_CERT_REVOCATION_REASON_CERTIFICATE_HOLD 9767
#define IDS_CERT_OCSP_RESPONDER_FORMAT 9768
#define IDS_CERT_CA_ISSUERS_FORMAT 9769
#define IDS_CERT_UNKNOWN_OID_INFO_FORMAT 9770
#define IDS_CERT_EXT_KEY_USAGE_FORMAT 9771
#define IDS_CERT_MULTILINE_INFO_START_FORMAT 9772
#define IDS_CERT_GENERAL_NAME_RFC822_NAME 9773
#define IDS_CERT_GENERAL_NAME_DNS_NAME 9774
#define IDS_CERT_GENERAL_NAME_X400_ADDRESS 9775
#define IDS_CERT_GENERAL_NAME_DIRECTORY_NAME 9776
#define IDS_CERT_GENERAL_NAME_EDI_PARTY_NAME 9777
#define IDS_CERT_GENERAL_NAME_URI 9778
#define IDS_CERT_GENERAL_NAME_IP_ADDRESS 9779
#define IDS_CERT_GENERAL_NAME_REGISTERED_ID 9780
#define IDS_CERT_EXT_MS_APP_POLICIES 9781
#define IDS_CERT_EXT_MS_CERT_TEMPLATE 9782
#define IDS_CERT_EXT_MS_CERT_TYPE 9783
#define IDS_CERT_EXT_MS_CA_VERSION 9784
#define IDS_CERT_EXT_MS_NT_PRINCIPAL_NAME 9785
#define IDS_CERT_EXT_MS_NTDS_REPLICATION 9786
#define IDS_CERT_EKU_ANY_EKU 9787
#define IDS_CERT_EKU_TLS_WEB_SERVER_AUTHENTICATION 9788
#define IDS_CERT_EKU_TLS_WEB_CLIENT_AUTHENTICATION 9789
#define IDS_CERT_EKU_CODE_SIGNING 9790
#define IDS_CERT_EKU_EMAIL_PROTECTION 9791
#define IDS_CERT_EKU_TIME_STAMPING 9792
#define IDS_CERT_EKU_OCSP_SIGNING 9793
#define IDS_CERT_EKU_MS_INDIVIDUAL_CODE_SIGNING 9794
#define IDS_CERT_EKU_MS_COMMERCIAL_CODE_SIGNING 9795
#define IDS_CERT_EKU_MS_TRUST_LIST_SIGNING 9796
#define IDS_CERT_EKU_MS_TIME_STAMPING 9797
#define IDS_CERT_EKU_MS_SERVER_GATED_CRYPTO 9798
#define IDS_CERT_EKU_MS_ENCRYPTING_FILE_SYSTEM 9799
#define IDS_CERT_EKU_MS_FILE_RECOVERY 9800
#define IDS_CERT_EKU_MS_WINDOWS_HARDWARE_DRIVER_VERIFICATION 9801
#define IDS_CERT_EKU_MS_QUALIFIED_SUBORDINATION 9802
#define IDS_CERT_EKU_MS_KEY_RECOVERY 9803
#define IDS_CERT_EKU_MS_DOCUMENT_SIGNING 9804
#define IDS_CERT_EKU_MS_LIFETIME_SIGNING 9805
#define IDS_CERT_EKU_MS_SMART_CARD_LOGON 9806
#define IDS_CERT_EKU_MS_KEY_RECOVERY_AGENT 9807
#define IDS_CERT_EKU_NETSCAPE_INTERNATIONAL_STEP_UP 9808
#define IDS_CERT_EXTENSION_CRITICAL 9809
#define IDS_CERT_EXTENSION_NON_CRITICAL 9810
#define IDS_CERT_DUMP_ERROR 9811
#define IDS_CERT_EXTENSION_DUMP_ERROR 9812
#define IDS_CERTIFICATE_MANAGER_TITLE 9813
#define IDS_CERT_MANAGER_HARDWARE_BACKED_KEY_FORMAT 9814
#define IDS_CERT_MANAGER_HARDWARE_BACKED 9815
#define IDS_CERT_MANAGER_EXTENSION_PROVIDED_FORMAT 9816
#define IDS_DEV_TOOLS_INFOBAR_LABEL 9817
#define IDS_DEV_TOOLS_CONFIRM_ADD_FILE_SYSTEM_MESSAGE 9818
#define IDS_DEV_TOOLS_CONFIRM_ALLOW_BUTTON 9819
#define IDS_DEV_TOOLS_CONFIRM_DENY_BUTTON 9820
#define IDS_RELOAD_MENU_NORMAL_RELOAD_ITEM 415
#define IDS_RELOAD_MENU_HARD_RELOAD_ITEM 416
#define IDS_RELOAD_MENU_EMPTY_AND_HARD_RELOAD_ITEM 417
#define IDS_TAB_SHARING_INFOBAR_SHARING_CURRENT_TAB_LABEL 9821
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_UNTITLED_TAB_LABEL 9822
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_TAB_LABEL 9823
#define IDS_TAB_SHARING_INFOBAR_SHARE_BUTTON 9824
#define IDS_TAB_SHARING_INFOBAR_STOP_BUTTON 9825
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_BUTTON 9826
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURER_BUTTON 9827
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURED_BUTTON 9828
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_LABEL 9829
#define IDS_TAB_CASTING_INFOBAR_CASTING_CURRENT_TAB_NO_DEVICE_NAME_LABEL 9830
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_LABEL 9831
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_UNTITLED_TAB_NO_DEVICE_NAME_LABEL 9832
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_LABEL 9833
#define IDS_TAB_CASTING_INFOBAR_CASTING_ANOTHER_TAB_NO_DEVICE_NAME_LABEL 9834
#define IDS_TAB_CASTING_INFOBAR_CAST_BUTTON 9835
#define IDS_TAB_CASTING_INFOBAR_STOP_BUTTON 9836
#define IDS_TASK_MANAGER_KILL 9837
#define IDS_TASK_MANAGER_PROCESS_ID_COLUMN 9838
#define IDS_TASK_MANAGER_GDI_HANDLES_COLUMN 9839
#define IDS_TASK_MANAGER_USER_HANDLES_COLUMN 9840
#define IDS_TASK_MANAGER_TASK_COLUMN 9841
#define IDS_TASK_MANAGER_NACL_DEBUG_STUB_PORT_COLUMN 9842
#define IDS_TASK_MANAGER_NET_COLUMN 9843
#define IDS_TASK_MANAGER_CPU_COLUMN 9844
#define IDS_TASK_MANAGER_START_TIME_COLUMN 9845
#define IDS_TASK_MANAGER_CPU_TIME_COLUMN 9846
#define IDS_TASK_MANAGER_MEM_FOOTPRINT_COLUMN 9847
#define IDS_TASK_MANAGER_SWAPPED_MEM_COLUMN 9848
#define IDS_TASK_MANAGER_PROFILE_NAME_COLUMN 9849
#define IDS_TASK_MANAGER_IDLE_WAKEUPS_COLUMN 9850
#define IDS_TASK_MANAGER_HARD_FAULTS_COLUMN 9851
#define IDS_TASK_MANAGER_OPEN_FD_COUNT_COLUMN 9852
#define IDS_TASK_MANAGER_PROCESS_PRIORITY_COLUMN 9853
#define IDS_TASK_MANAGER_WEBCORE_IMAGE_CACHE_COLUMN 9854
#define IDS_TASK_MANAGER_WEBCORE_SCRIPTS_CACHE_COLUMN 9855
#define IDS_TASK_MANAGER_WEBCORE_CSS_CACHE_COLUMN 9856
#define IDS_TASK_MANAGER_VIDEO_MEMORY_COLUMN 9857
#define IDS_TASK_MANAGER_SQLITE_MEMORY_USED_COLUMN 9858
#define IDS_TASK_MANAGER_JAVASCRIPT_MEMORY_ALLOCATED_COLUMN 9859
#define IDS_TASK_MANAGER_KEEPALIVE_COUNT_COLUMN 9860
#define IDS_TASK_MANAGER_MEM_CELL_TEXT 9861
#define IDS_TASK_MANAGER_CACHE_SIZE_CELL_TEXT 9862
#define IDS_TASK_MANAGER_NA_CELL_TEXT 9863
#define IDS_TASK_MANAGER_BACKGROUNDED_TEXT 9864
#define IDS_TASK_MANAGER_FOREGROUNDED_TEXT 9865
#define IDS_TASK_MANAGER_UNKNOWN_VALUE_TEXT 9866
#define IDS_TASK_MANAGER_DISABLED_NACL_DBG_TEXT 9867
#define IDS_TASK_MANAGER_HANDLES_CELL_TEXT 9868
#define IDS_TASK_MANAGER_WEB_BROWSER_CELL_TEXT 9869
#define IDS_TASK_MANAGER_EXTENSION_PREFIX 9870
#define IDS_TASK_MANAGER_EXTENSION_INCOGNITO_PREFIX 9871
#define IDS_TASK_MANAGER_APP_PREFIX 9872
#define IDS_TASK_MANAGER_APP_INCOGNITO_PREFIX 9873
#define IDS_TASK_MANAGER_TAB_PREFIX 9874
#define IDS_TASK_MANAGER_TAB_INCOGNITO_PREFIX 9875
#define IDS_TASK_MANAGER_BACKGROUND_APP_PREFIX 9876
#define IDS_TASK_MANAGER_BACKGROUND_PREFIX 9877
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_PREFIX 9878
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_PREFIX 9879
#define IDS_TASK_MANAGER_PLUGIN_PREFIX 9880
#define IDS_TASK_MANAGER_PLUGIN_BROKER_PREFIX 9881
#define IDS_TASK_MANAGER_NO_STATE_PREFETCH_PREFIX 9882
#define IDS_TASK_MANAGER_PRERENDER_PREFIX 9883
#define IDS_TASK_MANAGER_SPARE_RENDERER_PREFIX 9884
#define IDS_TASK_MANAGER_UNKNOWN_RENDERER_PREFIX 9885
#define IDS_TASK_MANAGER_DEDICATED_WORKER_PREFIX 9886
#define IDS_TASK_MANAGER_SHARED_WORKER_PREFIX 9887
#define IDS_TASK_MANAGER_SERVICE_WORKER_PREFIX 9888
#define IDS_TASK_MANAGER_UNKNOWN_PLUGIN_NAME 9889
#define IDS_TASK_MANAGER_UTILITY_PREFIX 9890
#define IDS_TASK_MANAGER_NACL_PREFIX 9891
#define IDS_TASK_MANAGER_NACL_BROKER_PREFIX 9892
#define IDS_TASK_MANAGER_GPU_PREFIX 9893
#define IDS_TASK_MANAGER_PRINT_PREFIX 9894
#define IDS_TASK_MANAGER_SUBFRAME_PREFIX 9895
#define IDS_TASK_MANAGER_SUBFRAME_INCOGNITO_PREFIX 9896
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_SUBFRAME_PREFIX 9897
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_SUBFRAME_PREFIX 9898
#define IDS_TASK_MANAGER_PORTAL_PREFIX 9899
#define IDS_TASK_MANAGER_PORTAL_INCOGNITO_PREFIX 9900
#define IDS_TASK_MANAGER_FENCED_FRAME_PREFIX 9901
#define IDS_TASK_MANAGER_FENCED_FRAME_INCOGNITO_PREFIX 9902
#define IDS_TASK_MANAGER_ARC_PREFIX 9903
#define IDS_TASK_MANAGER_TOOL_PREFIX 9904
#define IDS_TASK_MANAGER_ARC_PREFIX_BACKGROUND_SERVICE 9905
#define IDS_TASK_MANAGER_ARC_PREFIX_RECEIVER 9906
#define IDS_TASK_MANAGER_ARC_SYSTEM 9907
#define IDS_TASK_MANAGER_LINUX_VM_PREFIX 9908
#define IDS_TASK_MANAGER_PLUGIN_VM_PREFIX 9909
#define IDS_UTILITY_PROCESS_FILE_UTILITY_NAME 9911
#define IDS_UTILITY_PROCESS_PROFILE_IMPORTER_NAME 9912
#define IDS_UTILITY_PROCESS_QRCODE_GENERATOR_SERVICE_NAME 9913
#define IDS_UTILITY_PROCESS_WIFI_CREDENTIALS_GETTER_NAME 9914
#define IDS_UTILITY_PROCESS_IMAGE_WRITER_NAME 9915
#define IDS_UTILITY_PROCESS_MEDIA_GALLERY_UTILITY_NAME 9916
#define IDS_UTILITY_PROCESS_NOOP_SERVICE_NAME 9917
#define IDS_SERVICE_PROCESS_DOCUMENT_ANALYSIS_NAME 9918
#define IDS_THEME_INSTALL_INFOBAR_LABEL 9919
#define IDS_THEME_INSTALL_INFOBAR_UNDO_BUTTON 9920
#define IDS_CRITICAL_NOTIFICATION_RESTART 9921
#define IDS_EXTENSION_DISABLED_ERROR_LABEL 9922
#define IDS_EXTENSION_IS_BLOCKLISTED 9923
#define IDS_EXTENSION_DISABLED_REMOTE_INSTALL_ERROR_TITLE 9924
#define IDS_EXTENSION_DISABLED_ERROR_TITLE 9925
#define IDS_EXTENSION_SITE_RELOAD_PAGE_BUBBLE_HEADING 9926
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_OK_BUTTON 9927
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_SINGLE_EXTENSION_TITLE 9928
#define IDS_EXTENSION_RELOAD_PAGE_BUBBLE_ALLOW_MULTIPLE_EXTENSIONS_TITLE 9929
#define IDS_APP_UNINSTALL_PROMPT_TITLE 9930
#define IDS_ARC_APP_UNINSTALL_PROMPT_DATA_REMOVAL_WARNING 9931
#define IDS_EXTENSION_UNINSTALL_PROMPT_TITLE 9932
#define IDS_EXTENSION_CONFIRM_PERMISSIONS 9933
#define IDS_EXTENSION_DELEGATED_INSTALL_PROMPT_TITLE 9934
#define IDS_EXTENSION_INSTALL_PROMPT_TITLE 9935
#define IDS_EXTENSION_UNINSTALL_PROMPT_HEADING 9936
#define IDS_EXTENSION_REQUEST_PROMPT_TITLE 9937
#define IDS_EXTENSION_PENDING_REQUEST_PROMPT_TITLE 9938
#define IDS_EXTENSION_BLOCKED_BY_POLICY_PROMPT_TITLE 9939
#define IDS_EXTENSION_PROGRAMMATIC_UNINSTALL_PROMPT_HEADING 9940
#define IDS_EXTENSION_RE_ENABLE_PROMPT_TITLE 9941
#define IDS_EXTENSION_PERMISSIONS_PROMPT_TITLE 9942
#define IDS_EXTENSION_REMOTE_INSTALL_PROMPT_TITLE 9943
#define IDS_EXTENSION_REPAIR_PROMPT_TITLE 9944
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_APP 9945
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_EXTENSION 9946
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_THEME 9947
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 9948
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_APP 9949
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 9950
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ABORT_BUTTON 9951
#define IDS_EXTENSION_ALERT_TITLE 9952
#define IDS_APP_ALERT_TITLE 9953
#define IDS_EXTENSION_AND_APP_ALERT_TITLE 9954
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_TITLE 9955
#define IDS_POLICY_BLOCKED_EXTENSIONS_ALERT_ITEM_TITLE 9956
#define IDS_BLOCKLISTED_EXTENSIONS_ALERT_ITEM 9957
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_ITEM_DETAIL 9958
#define IDS_EXTENSION_ALERT_ITEM_OK 9959
#define IDS_EXTENSION_ALERT_ITEM_DETAILS 9960
#define IDS_EXTENSION_PROMPT_APP_CONNECT_FROM_INCOGNITO 9961
#define IDS_EXTENSION_PROMPT_EXTENSION_CONNECT_FROM_INCOGNITO 9962
#define IDS_EXTENSION_PROMPT_WILL_HAVE_ACCESS_TO 9963
#define IDS_EXTENSION_PROMPT_WILL_NOW_HAVE_ACCESS_TO 9964
#define IDS_EXTENSION_PROMPT_WANTS_ACCESS_TO 9965
#define IDS_EXTENSION_PROMPT_CAN_ACCESS 9966
#define IDS_EXTENSION_PROMPT_GRANT_PERMISSIONS_CHECKBOX 9967
#define IDS_EXTENSION_PROMPT_MESSAGE_FROM_ADMIN 9968
#define IDS_EXTENSION_PERMISSION_LINE 9969
#define IDS_EXTENSION_RATING_COUNT 9970
#define IDS_EXTENSION_PROMPT_RATING_ACCESSIBLE_TEXT 9971
#define IDS_EXTENSION_PROMPT_NO_RATINGS_ACCESSIBLE_TEXT 9972
#define IDS_EXTENSION_USER_COUNT 9973
#define IDS_EXTENSION_PROMPT_STORE_LINK 9974
#define IDS_EXTENSION_PROMPT_WARNING_FULL_ACCESS 9975
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS 9976
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS_READ_ONLY 9977
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_CAPTURE 9978
#define IDS_EXTENSION_PROMPT_WARNING_VIDEO_CAPTURE 9979
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_AND_VIDEO_CAPTURE 9980
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH 9981
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_DEVICES 9982
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_PRIVATE 9983
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_SERIAL 9984
#define IDS_EXTENSION_PROMPT_WARNING_BOOKMARKS 9985
#define IDS_EXTENSION_PROMPT_WARNING_READING_LIST 9986
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD 9987
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_READWRITE 9988
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_WRITE 9989
#define IDS_EXTENSION_PROMPT_WARNING_DEBUGGER 9990
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_WEB_REQUEST 9991
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_NET_REQUEST 9992
#define IDS_EXTENSION_PROMPT_WARNING_DOCUMENT_SCAN 9993
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_HARDWARE_PLATFORM 9994
#define IDS_EXTENSION_PROMPT_WARNING_FAVICON 9995
#define IDS_EXTENSION_PROMPT_WARNING_GEOLOCATION 9996
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ 9997
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ_ON_ALL_DEVICES 9998
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_WRITE_ON_ALL_DEVICES 9999
#define IDS_EXTENSION_PROMPT_WARNING_HOME_PAGE_SETTING_OVERRIDE 10000
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST 10001
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST_READ_ONLY 10002
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS 10003
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS_READ_ONLY 10004
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS 10005
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS_READ_ONLY 10006
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST 10007
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST_READ_ONLY 10008
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN 10009
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN_LIST 10010
#define IDS_EXTENSION_PROMPT_WARNING_INPUT 10011
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN 10012
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_UI 10013
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_STORAGE 10014
#define IDS_EXTENSION_PROMPT_WARNING_MANAGEMENT 10015
#define IDS_EXTENSION_PROMPT_WARNING_MDNS 10016
#define IDS_EXTENSION_PROMPT_WARNING_NETWORK_STATE 10017
#define IDS_EXTENSION_PROMPT_WARNING_NETWORKING_PRIVATE 10018
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING 10019
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING_METRICS 10020
#define IDS_EXTENSION_PROMPT_WARNING_SEARCH_SETTINGS_OVERRIDE 10021
#define IDS_EXTENSION_PROMPT_WARNING_SERIAL 10022
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_ANY_HOST 10023
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAIN 10024
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAINS 10025
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOST 10026
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOSTS 10027
#define IDS_EXTENSION_PROMPT_WARNING_SPEECH_RECOGNITION 10028
#define IDS_EXTENSION_PROMPT_WARNING_START_PAGE_SETTING_OVERRIDE 10029
#define IDS_EXTENSION_PROMPT_WARNING_SYSTEM_STORAGE 10030
#define IDS_EXTENSION_PROMPT_WARNING_TAB_GROUPS 10031
#define IDS_EXTENSION_PROMPT_WARNING_TOPSITES 10032
#define IDS_EXTENSION_PROMPT_WARNING_TTS_ENGINE 10033
#define IDS_EXTENSION_PROMPT_WARNING_U2F_DEVICES 10034
#define IDS_EXTENSION_PROMPT_WARNING_NOTIFICATIONS 10035
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE 10036
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST 10037
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_PRODUCT 10038
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_VENDOR 10039
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_PRODUCT 10040
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_VENDOR 10041
#define IDS_EXTENSION_PROMPT_WARNING_VPN 10042
#define IDS_EXTENSION_PROMPT_WARNING_CONTENT_SETTINGS 10043
#define IDS_EXTENSION_PROMPT_WARNING_PRIVACY 10044
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS 10045
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS_OPEN 10046
#define IDS_EXTENSION_PROMPT_WARNING_IDENTITY_EMAIL 10047
#define IDS_EXTENSION_PROMPT_WARNING_WALLPAPER 10048
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_DIRECTORY 10049
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_WRITE_DIRECTORY 10050
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ 10051
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE 10052
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_DELETE 10053
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE_DELETE 10054
#define IDS_EXTENSION_PROMPT_WARNING_SYNCFILESYSTEM 10055
#define IDS_EXTENSION_PROMPT_WARNING_NATIVE_MESSAGING 10056
#define IDS_EXTENSION_PROMPT_WARNING_SCREENLOCK_PRIVATE 10057
#define IDS_EXTENSION_PROMPT_WARNING_ACTIVITY_LOG_PRIVATE 10058
#define IDS_EXTENSION_PROMPT_WARNING_DESKTOP_CAPTURE 10059
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_MODIFY 10060
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ 10061
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ_MODIFY 10062
#define IDS_EXTENSION_PROMPT_WARNING_PLATFORMKEYS 10063
#define IDS_EXTENSION_PROMPT_WARNING_CERTIFICATEPROVIDER 10064
#define IDS_EXTENSION_PROMPT_WARNING_SETTINGS_PRIVATE 10065
#define IDS_EXTENSION_PROMPT_WARNING_AUTOFILL_PRIVATE 10066
#define IDS_EXTENSION_PROMPT_WARNING_PASSWORDS_PRIVATE 10067
#define IDS_EXTENSION_PROMPT_WARNING_USERS_PRIVATE 10068
#define IDS_EXTENSION_PROMPT_WARNING_NEW_TAB_PAGE_OVERRIDE 10069
#define IDS_EXTENSION_PROMPT_WARNING_TRANSIENT_BACKGROUND 10070
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_DEVICE_ATTRIBUTES 10071
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_NETWORKING_ATTRIBUTES 10072
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_PLATFORMKEYS 10073
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE_ENABLED_WIN 10074
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE 10076
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REMOTE_APPS 10077
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_ATTACHED_DEVICE_INFO 10078
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS 10079
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_EVENTS 10080
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY 10081
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_SERIAL_NUMBER 10082
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_NETWORK_INFORMATION 10083
#define IDS_EXTENSION_CANT_DOWNGRADE_VERSION 10084
#define IDS_APP_CANT_DOWNGRADE_VERSION 10085
#define IDS_EXTENSION_MOVE_DIRECTORY_TO_PROFILE_FAILED 10088
#define IDS_EXTENSION_INSTALL_NOT_ENABLED 10089
#define IDS_EXTENSION_INSTALL_INCORRECT_APP_CONTENT_TYPE 10090
#define IDS_EXTENSION_INSTALL_INCORRECT_INSTALL_HOST 10091
#define IDS_EXTENSION_INSTALL_UNEXPECTED_ID 10092
#define IDS_EXTENSION_INSTALL_DISALLOWED_ON_SITE 10093
#define IDS_EXTENSION_INSTALL_UNEXPECTED_VERSION 10094
#define IDS_EXTENSION_INSTALL_DEPENDENCY_OLD_VERSION 10095
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_SHARED_MODULE 10096
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_ALLOWLISTED 10097
#define IDS_EXTENSION_INSTALL_GALLERY_ONLY 10098
#define IDS_EXTENSION_INSTALL_KIOSK_MODE_ONLY 10099
#define IDS_EXTENSION_OVERLAPPING_WEB_EXTENT 10100
#define IDS_EXTENSION_INVALID_IMAGE_PATH 10101
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO 10104
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO_WITH_SHORTCUT 10105
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO 10106
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO_WITH_SHORTCUT 10107
#define IDS_EXTENSION_INSTALLED_OMNIBOX_KEYWORD_INFO 10108
#define IDS_EXTENSION_INSTALLED_MANAGE_INFO 10109
#define IDS_EXTENSION_INSTALLED_MANAGE_SHORTCUTS 10110
#define IDS_EXTENSION_LAUNCH_WEB_AUTH_FLOW_TAB_INFO_BAR_TEXT 10111
#define IDS_EXTENSION_INSTALLED_DICE_PROMO_SYNC_MESSAGE 10112
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_TITLE 10113
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_READ_ONLY 10114
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_WRITABLE 10115
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_TITLE_LABEL 10116
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_ADDRESS_LABEL 10117
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_PORT_LABEL 10118
#define IDS_EXTENSIONS_LOAD_ERROR_ALERT_HEADING 10119
#define IDS_EXTENSIONS_LOAD_ERROR_MESSAGE 10120
#define IDS_EXTENSIONS_WANTS_ACCESS_TO_SITE 10121
#define IDS_EXTENSIONS_HAS_ACCESS_TO_SITE 10122
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON 10123
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_DISMISSED_TEXT 10124
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_SINGLE_EXTENSION 10125
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_MULTIPLE_EXTENSIONS 10126
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_HAS_ACCESS 10127
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_BLOCKED_ACCESS 10128
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_TITLE_REQUESTS_ACCESS 10129
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_ALLOWED_ACCESS 10130
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_ALL_EXTENSIONS_BLOCKED_ACCESS 10131
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_HAS_ACCESS 10132
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_DESCRIPTION_EXTENSION_REQUESTS_ACCESS 10133
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_PINNED_TEXT 10134
#define IDS_EXTENSIONS_TOOLBAR_ACTION_HOVER_CARD_POLICY_LABEL_INSTALLED_TEXT 10135
#define IDS_EXTENSIONS_CONTEXT_MENU_SITE_PERMISSIONS 10136
#define IDS_EXTENSIONS_CONTEXT_MENU_CANT_ACCESS_PAGE 10137
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS 10138
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_GRANTED 10139
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_BLOCKED 10140
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK_V2 10141
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE_V2 10142
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES_V2 10143
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_PERMISSIONS_PAGE 10144
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK 10145
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE 10146
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES 10147
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_LEARN_MORE 10148
#define IDS_EXTENSIONS_CONTEXT_MENU_PIN_TO_TOOLBAR 10149
#define IDS_EXTENSIONS_CONTEXT_MENU_UNPIN_FROM_TOOLBAR 10150
#define IDS_EXTENSIONS_OPTIONS_MENU_ITEM 10151
#define IDS_EXTENSIONS_INSTALLED_BY_ADMIN 10152
#define IDS_EXTENSIONS_DISABLE 10153
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR 10154
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR 10155
#define IDS_EXTENSIONS_PINNED_BY_ADMIN 10156
#define IDS_MANAGE_EXTENSION 10157
#define IDS_MANAGE_EXTENSIONS 10158
#define IDS_VIEW_WEB_PERMISSIONS 10159
#define IDS_EXTENSION_ACTION_INSPECT_POPUP 10160
#define IDS_EXTENSIONS_LOCKED_SUPERVISED_USER 10164
#define IDS_EXTENSION_LOAD_FROM_DIRECTORY 10165
#define IDS_EXTENSION_COMMANDS_GENERIC_ACTIVATE 10166
#define IDS_EXTENSIONS_SUPERVISED_USER_PARENTAL_PERMISSION_FAILURE 10167
#define IDS_EXTENSION_PACK_DIALOG_HEADING 10168
#define IDS_EXTENSION_PACK_DIALOG_SELECT_KEY 10169
#define IDS_EXTENSION_PACK_DIALOG_KEY_FILE_TYPE_DESCRIPTION 10170
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_REQUIRED 10171
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_INVALID 10172
#define IDS_EXTENSION_PACK_DIALOG_ERROR_KEY_INVALID 10173
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_NEW 10174
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_UPDATE 10175
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_CONTINUE_BUTTON 10176
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_TITLE 10177
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_WARNING_TEXT 10178
#define IDS_EXTENSION_PROMPT_INSTALL_BUTTON 10179
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 10180
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_APP 10181
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 10182
#define IDS_EXTENSION_INSTALL_PROMPT_ASK_A_PARENT_BUTTON 10183
#define IDS_EXTENSION_INSTALL_BLOCKED_BY_PARENT_PROMPT_TITLE 10184
#define IDS_EXTENSION_ENABLE_BLOCKED_BY_PARENT_PROMPT_TITLE 10185
#define IDS_PARENT_PERMISSION_PROMPT_GO_GET_A_PARENT_FOR_EXTENSION_LABEL 10186
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_EXTENSION 10187
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_APP 10188
#define IDS_PARENT_PERMISSION_PROMPT_CHILD_WANTS_TO_INSTALL_LABEL 10189
#define IDS_PARENT_PERMISSION_PROMPT_APPROVE_BUTTON 10190
#define IDS_PARENT_PERMISSION_PROMPT_CANCEL_BUTTON 10191
#define IDS_PARENT_PERMISSION_PROMPT_SELECT_PARENT_LABEL 10192
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_LABEL 10193
#define IDS_PARENT_PERMISSION_PROMPT_ENTER_PASSWORD_LABEL 10194
#define IDS_PARENT_PERMISSION_PROMPT_PASSWORD_INCORRECT_LABEL 10195
#define IDS_EXTENSION_INSTALL_PROMPT_REQUEST_BUTTON 10196
#define IDS_EXTENSION_PROMPT_UNINSTALL_BUTTON 10197
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE 10198
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE_FROM_EXTENSION 10199
#define IDS_EXTENSION_PROMPT_UNINSTALL_TITLE 10200
#define IDS_EXTENSION_PROMPT_UNINSTALL_APP_BUTTON 10201
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_NAME_BULLET_POINT 10202
#define IDS_EXTENSION_PROMPT_MULTIPLE_UNINSTALL_TITLE 10203
#define IDS_EXTENSION_PROMPT_UNINSTALL_TRIGGERED_BY_EXTENSION 10204
#define IDS_EXTENSION_PROMPT_RE_ENABLE_BUTTON 10205
#define IDS_EXTENSION_PROMPT_PERMISSIONS_BUTTON 10206
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ACCEPT_BUTTON 10207
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ABORT_BUTTON 10208
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_EXTENSION 10209
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_APP 10210
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_EXTENSION 10211
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_APP 10212
#define IDS_EXTENSION_WEB_STORE_TITLE 10213
#define IDS_EXTENSION_WEB_STORE_TITLE_SHORT 478
#define IDS_EXTENSIONS_SHOW_DETAILS 10214
#define IDS_EXTENSIONS_HIDE_DETAILS 10215
#define IDS_WEBSTORE_DOWNLOAD_ACCESS_DENIED 10216
#define IDS_EXTENSION_WARNINGS_WRENCH_MENU_ITEM 10217
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_EXTENSION 10218
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_APP 10219
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_THEME 10220
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_TITLE 10221
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_APP 10222
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_EXTENSION 10223
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_THEME 10224
#define IDS_EXTENSIONS_UNSUPPORTED_DISABLED_TITLE 10225
#define IDS_EXTENSIONS_DISABLED_AND_N_MORE 10226
#define IDS_EXTENSIONS_UNSUPPORTED_DISABLED_BUTTON 10227
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE 10228
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE_LEARN_MORE 10229
#define IDS_EXTENSIONS_DISABLE_DEVELOPER_MODE_TITLE 10230
#define IDS_EXTENSIONS_DISABLE_DEVELOPER_MODE_BODY 10231
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_CHANGE_IT_BACK 10232
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_KEEP_IT 10233
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_GENERIC 10234
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 10235
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_BODY_GENERIC 10236
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_GENERIC 10237
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 10238
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_OTHER 10239
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_BODY_GENERIC 10240
#define IDS_FORCE_INSTALLED_DEPRECATED_APPS_CONTENT 10241
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_TITLE 10242
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_CONTENT 10243
#define IDS_FORCE_INSTALLED_PREINSTALLED_DEPRECATED_APPS_GO_TO_SITE_BUTTON 10244
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_PLURAL 10245
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_WITH_APP_NAME 10246
#define IDS_DEPRECATED_APPS_MONITOR_RENDERER 10247
#define IDS_DEPRECATED_APPS_LEARN_MORE 10248
#define IDS_DEPRECATED_APPS_LEARN_MORE_AX_LABEL 10249
#define IDS_DEPRECATED_APPS_DELETION_LINK 10250
#define IDS_DEPRECATED_APPS_OK_LABEL 10251
#define IDS_DEPRECATED_APPS_CANCEL_LABEL 10252
#define IDS_DEPRECATED_APPS_LAUNCH_ANYWAY_LABEL 10253
#define IDS_EXTENSIONS_MENU_TITLE 10254
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP 10255
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP_ACCESSIBLE_NAME 10256
#define IDS_EXTENSIONS_MENU_PIN_BUTTON_TOOLTIP 10257
#define IDS_EXTENSIONS_MENU_UNPIN_BUTTON_TOOLTIP 10258
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA_SHORT 10259
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA 10260
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA_SHORT 10261
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA 10262
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA_SHORT 10263
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA 10264
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ON_TOOLTIP 10265
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_OFF_TOOLTIP 10266
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ACCESSIBLE_NAME 10267
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_ON_ACCESSIBLE_NAME 10268
#define IDS_EXTENSIONS_MENU_SITE_SETTINGS_TOGGLE_OFF_ACCESSIBLE_NAME 10269
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RESTRICTED_ACCESS_TEXT 10270
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_USER_BLOCKED_ACCESS_TEXT 10271
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_ENTERPRISE_TOOLTIP_ICON_TEXT 10272
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_USER_CUSTOMIZED_ACCESS_TEXT 10273
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_DESCRIPTION_TEXT 10274
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TEXT 10275
#define IDS_EXTENSIONS_MENU_MESSAGE_SECTION_RELOAD_CONTAINER_BUTTON_TOOLTIP 10276
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_TITLE 10277
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TEXT 10278
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_ALLOW_BUTTON_TOOLTIP 10279
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TEXT 10280
#define IDS_EXTENSIONS_MENU_REQUESTS_ACCESS_SECTION_DISMISS_BUTTON_TOOLTIP 10281
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ON_TOOLTIP 10282
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_OFF_TOOLTIP 10283
#define IDS_EXTENSIONS_MENU_EXTENSION_SITE_ACCESS_TOGGLE_ACCESSIBLE_NAME 10284
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_TOOLTIP 10285
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_ACCESSIBLE_NAME 10286
#define IDS_EXTENSIONS_MENU_EXTENSION_CONTEXT_MENU_BUTTON_PINNED_ACCESSIBLE_NAME 10287
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_NONE 10288
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_OPEN_CHROME_WEBSTORE_ACCESSIBLE_NAME 10289
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_TOOLTIP 10290
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ACCESSIBLE_NAME 10291
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_CLICK 10292
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_SITE 10293
#define IDS_EXTENSIONS_MENU_MAIN_PAGE_EXTENSION_SITE_ACCESS_ON_ALL_SITES 10294
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON 10295
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SETTINGS_BUTTON_TOOLTIP 10296
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_LABEL 10297
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_ON 10298
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SHOW_REQUESTS_TOGGLE_OFF 10299
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_LABEL 10300
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_TEXT 10301
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_TEXT 10302
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_TEXT 10303
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_CLICK_DESCRIPTION 10304
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_SITE_DESCRIPTION 10305
#define IDS_EXTENSIONS_MENU_SITE_PERMISSIONS_PAGE_SITE_ACCESS_ON_ALL_SITES_DESCRIPTION 10306
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_HOME_PAGE_BUBBLE 10307
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_STARTUP_PAGES_BUBBLE 10308
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_SEARCH_ENGINE_BUBBLE 10309
#define IDS_EXTENSIONS_NTP_CONTROLLED_TITLE_HOME_PAGE_BUBBLE 10310
#define IDS_EXTENSIONS_PROXY_CONTROLLED_TITLE_HOME_PAGE_BUBBLE 10311
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_SEARCH_ENGINE_SPECIFIC 10312
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_SEARCH_ENGINE 10313
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE_SPECIFIC 10314
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE 10315
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_SEARCH_ENGINE 10316
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_HOME_PAGE 10317
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_HOME_AND_SEARCH 10318
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_TITLE 10319
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_HEADING 10320
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_ALLOW 10321
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_DENY 10322
#define IDS_EXTENSIONS_NTP_CONTROLLED_FIRST_LINE 10323
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE 10324
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE_EXTENSION_SPECIFIC 10325
#define IDS_EXTENSIONS_SETTINGS_API_THIRD_LINE_CONFIRMATION 10326
#define IDS_EXTENSION_CONTROLLED_RESTORE_SETTINGS 10327
#define IDS_EXTENSION_CONTROLLED_KEEP_CHANGES 10328
#define IDS_WEB_APP_DETAILED_INSTALL_DIALOG_DESCRIPTION_TITLE 10329
#define IDS_SUB_APPS_INSTALL_DIALOG_TITLE 10330
#define IDS_SUB_APPS_INSTALL_DIALOG_DESCRIPTION 10331
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_DESCRIPTION 10332
#define IDS_SUB_APPS_INSTALL_DIALOG_PERMISSIONS_BUTTON 10333
#define IDS_SUB_APPS_INSTALL_DIALOG_CANCEL_BUTTON 10334
#define IDS_WEB_APP_MENU_BUTTON_TOOLTIP 10335
#define IDS_WEB_APP_ENABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 10336
#define IDS_WEB_APP_DISABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 10337
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_ENABLED_ALERT 10338
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_DISABLED_ALERT 10339
#define IDS_APP_HOME_TITLE 10340
#define IDS_APP_HOME_OPEN_IN_WINDOW 10341
#define IDS_APP_HOME_LAUNCH_AT_STARTUP 10342
#define IDS_APP_HOME_CREATE_SHORTCUT 10343
#define IDS_APP_HOME_INSTALL_LOCALLY 10344
#define IDS_APP_HOME_UNINSTALL_APP 10345
#define IDS_APP_HOME_REMOVE_APP 10346
#define IDS_APP_HOME_APP_SETTINGS 10347
#define IDS_ACCNAME_APP_HOME_NOT_INSTALLED 10348
#define IDS_APP_HOME_APP_NO_APPS 10349
#define IDS_APP_HOME_APP_LEARN_INSTALL 10350
#define IDS_WEB_APP_SETTINGS_TITLE 10351
#define IDS_WEB_APP_SETTINGS_LINK 10352
#define IDS_WEB_APP_SETTINGS_LINK_TOOLTIP 10353
#define IDS_COMPONENTS_TITLE 10354
#define IDS_COMPONENTS_VERSION 10355
#define IDS_COMPONENTS_NONE_INSTALLED 10356
#define IDS_COMPONENTS_NO_COMPONENTS 10357
#define IDS_COMPONENTS_CHECK_FOR_UPDATE 10358
#define IDS_COMPONENTS_STATUS_LABEL 10359
#define IDS_COMPONENTS_CHECKING_LABEL 10360
#define IDS_COMPONENTS_SVC_STATUS_NEW 10364
#define IDS_COMPONENTS_SVC_STATUS_CHECKING 10365
#define IDS_COMPONENTS_SVC_STATUS_UPDATE 10366
#define IDS_COMPONENTS_SVC_STATUS_DNL_DIFF 10367
#define IDS_COMPONENTS_SVC_STATUS_DNL 10368
#define IDS_COMPONENTS_SVC_STATUS_DOWNLOADED 10369
#define IDS_COMPONENTS_SVC_STATUS_UPDT_DIFF 10370
#define IDS_COMPONENTS_SVC_STATUS_UPDATING 10371
#define IDS_COMPONENTS_SVC_STATUS_UPDATED 10372
#define IDS_COMPONENTS_SVC_STATUS_UPTODATE 10373
#define IDS_COMPONENTS_SVC_STATUS_UPDATE_ERROR 10374
#define IDS_COMPONENTS_UNKNOWN 10375
#define IDS_COMPONENTS_EVT_STATUS_STARTED 10376
#define IDS_COMPONENTS_EVT_STATUS_SLEEPING 10377
#define IDS_COMPONENTS_EVT_STATUS_FOUND 10378
#define IDS_COMPONENTS_EVT_STATUS_READY 10379
#define IDS_COMPONENTS_EVT_STATUS_UPDATED 10380
#define IDS_COMPONENTS_EVT_STATUS_ALREADY_UP_TO_DATE 10381
#define IDS_COMPONENTS_EVT_STATUS_UPDATE_ERROR 10382
#define IDS_COMPONENTS_EVT_STATUS_DOWNLOADING 10383
#define IDS_COMPONENTS_EVT_STATUS_UPDATING 10384
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_TITLE 10385
#define IDS_PASSWORD_MANAGER_CONFIRM_SAVED_TITLE 10386
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM 10387
#define IDS_PASSWORD_GENERATION_SUGGESTION_TRUSTED_ADVICE 10388
#define IDS_PASSWORD_GENERATION_SUGGESTION_SAFETY_FIRST 10389
#define IDS_PASSWORD_GENERATION_SUGGESTION_TRY_SOMETHING_NEW 10390
#define IDS_PASSWORD_GENERATION_SUGGESTION_CONVENIENCE 10391
#define IDS_PASSWORD_GENERATION_EDIT_PASSWORD 10392
#define IDS_PASSWORD_GENERATION_EDITING_SUGGESTION 10393
#define IDS_SAVE_PASSWORD 10394
#define IDS_SAVE_ACCOUNT 10395
#define IDS_UPDATE_PASSWORD 10396
#define IDS_SIGN_IN_TO_SAVE_PASSWORDS 10397
#define IDS_SIGN_IN_TO_USE_PASSWORDS 10398
#define IDS_PASSWORD_ERROR_DESCRIPTION 10399
#define IDS_SAVE_PASSWORD_DIFFERENT_DOMAINS_TITLE 10401
#define IDS_UPDATE_PASSWORD_DIFFERENT_DOMAINS_TITLE 10402
#define IDS_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION_GOOGLE_ACCOUNT 10403
#define IDS_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION_GOOGLE_ACCOUNT 10404
#define IDS_SAVE_PASSWORD_FOOTER 10405
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SYNCED_TO_ACCOUNT 10406
#define IDS_PASSWORD_BUBBLES_FOOTER_SYNCED_TO_ACCOUNT 10407
#define IDS_PASSWORD_BUBBLES_FOOTER_SAVING_ON_DEVICE 10408
#define IDS_PASSWORD_GENERATION_CONFIRMATION_GOOGLE_PASSWORD_MANAGER 10409
#define IDS_PASSWORD_GENERATION_PROMPT_GOOGLE_PASSWORD_MANAGER 10410
#define IDS_PASSWORD_GENERATION_HELP_TEXT_TRUSTED_ADVICE 10411
#define IDS_PASSWORD_GENERATION_HELP_TEXT_SAFETY_FIRST 10412
#define IDS_PASSWORD_GENERATION_HELP_TEXT_TRY_SOMETHING_NEW 10413
#define IDS_PASSWORD_GENERATION_HELP_TEXT_CONVENIENCE 10414
#define IDS_PASSWORD_GENERATION_BENEFITS 10415
#define IDS_PASSWORD_GENERATION_CROSS_DEVICE 10416
#define IDS_PASSWORD_GENERATION_SECURITY 10417
#define IDS_PASSWORD_GENERATION_PROACTIVE_CHECK 10418
#define IDS_PASSWORD_GENERATION_HELP_TEXT 10419
#define IDS_PASSWORD_MANAGEMENT_BUBBLE_FOOTER_ACCOUNT_STORE_USERS 10420
#define IDS_PASSWORD_MANAGER_GENERATED_PASSWORD_SAVED_MESSAGE_DESCRIPTION 10421
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 10422
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 10423
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_SIGN_IN 10429
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_BUTTON 10430
#define IDS_SHARED_PASSWORDS_NOTIFICATION_GOT_IT_BUTTON 10431
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_SINGLE_PASSWORD 10432
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TEXT_MULTIPLE_PASSWORD 10433
#define IDS_SHARED_PASSWORDS_NOTIFICATION_TITLE 10434
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_A 10435
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_B 10436
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_C 10437
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_A 10438
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_B 10439
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SIGNIN_MESSAGE 10440
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SYNC_MESSAGE 10441
#define IDS_WEBRTC_LOGS_TITLE 10442
#define IDS_WEBRTC_TEXT_LOGS_LOG_COUNT_BANNER_FORMAT 10443
#define IDS_WEBRTC_EVENT_LOGS_LOG_COUNT_BANNER_FORMAT 10444
#define IDS_WEBRTC_LOGS_LOG_HEADER_FORMAT 10445
#define IDS_WEBRTC_LOGS_LOG_LOCAL_FILE_LABEL_FORMAT 10446
#define IDS_WEBRTC_LOGS_NO_LOCAL_LOG_FILE_MESSAGE 10447
#define IDS_WEBRTC_LOGS_LOG_UPLOAD_TIME_FORMAT 10448
#define IDS_WEBRTC_LOGS_LOG_FAILED_UPLOAD_TIME_FORMAT 10449
#define IDS_WEBRTC_LOGS_LOG_REPORT_ID_FORMAT 10450
#define IDS_WEBRTC_LOGS_BUG_LINK_LABEL 10451
#define IDS_WEBRTC_LOGS_LOG_PENDING_MESSAGE 10452
#define IDS_WEBRTC_LOGS_LOG_ACTIVELY_UPLOADED_MESSAGE 10453
#define IDS_WEBRTC_LOGS_LOG_NOT_UPLOADED_MESSAGE 10454
#define IDS_WEBRTC_LOGS_EVENT_LOG_LOCAL_LOG_ID 10455
#define IDS_WEBRTC_LOGS_NO_TEXT_LOGS_MESSAGE 10456
#define IDS_WEBRTC_LOGS_NO_EVENT_LOGS_MESSAGE 10457
#define IDS_PLUGIN_HIDE 10458
#define IDS_PLUGIN_BLOCKED 10459
#define IDS_PLUGIN_BLOCKED_BY_POLICY 10460
#define IDS_PLUGIN_NOT_AUTHORIZED 10462
#define IDS_PLUGIN_DISABLED 10463
#define IDS_PLUGIN_DEPRECATED 10464
#define IDS_SESSION_CRASHED_BUBBLE_TITLE 10465
#define IDS_SESSION_CRASHED_BUBBLE_UMA_LINK_TEXT 10466
#define IDS_IDLE_BUBBLE_TITLE_CLEAR 10467
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_TITLE 10468
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_MESSAGE 10469
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_BUTTON_LABEL 10470
#define IDS_BAD_FLAGS_WARNING_MESSAGE 10471
#define IDS_BAD_FEATURES_WARNING_MESSAGE 10472
#define IDS_BAD_ENVIRONMENT_VARIABLES_WARNING_MESSAGE 10473
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT_TITLE 10474
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT 10475
#define IDS_ALLOW_INSECURE_CONTENT_BUTTON 10476
#define IDS_ADD_TO_SHELF_INFOBAR_TITLE 10477
#define IDS_ADD_TO_SHELF_INFOBAR_ADD_BUTTON 10478
#define IDS_ABOUT_SYS_TITLE 10479
#define IDS_ABOUT_SYS_DESC 10480
#define IDS_ABOUT_SYS_TABLE_TITLE 10481
#define IDS_ABOUT_SYS_LOG_FILE_TABLE_TITLE 10482
#define IDS_ABOUT_SYS_EXPAND_ALL 10483
#define IDS_ABOUT_SYS_COLLAPSE_ALL 10484
#define IDS_ABOUT_SYS_EXPAND 10485
#define IDS_ABOUT_SYS_COLLAPSE 10486
#define IDS_ABOUT_SYS_PARSE_ERROR 10487
#define IDS_ABOUT_BROWSER_SWITCH_TITLE 10488
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_UNKNOWN_BROWSER 10489
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_KNOWN_BROWSER 10490
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_UNKNOWN_BROWSER 10491
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_KNOWN_BROWSER 10492
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_UNKNOWN_BROWSER 10493
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_KNOWN_BROWSER 10494
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_UNKNOWN_BROWSER 10495
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_KNOWN_BROWSER 10496
#define IDS_ABOUT_BROWSER_SWITCH_PROTOCOL_ERROR 10497
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_DESC 10498
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_TITLE 10499
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_NOTHING_SHOWN 10500
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_LBS_DISABLED 10501
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_TITLE 10502
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_DESC 10503
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER 10504
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_PROTOCOL_REASON 10505
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_RULE_REASON 10506
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_INVERT_RULE_REASON 10507
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_DEFAULT_REASON 10508
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_INVALID_URL 10509
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_TITLE 10510
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_DESC 10511
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SOURCE 10512
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_NOT_CONFIGURED 10513
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NOT_FETCHED 10514
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_DOWNLOAD_BUTTON 10515
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_LAST_DOWNLOAD_DATE 10516
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NEXT_DOWNLOAD_DATE 10517
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_TITLE 10518
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_DESCRIPTION 10519
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_FIRST_PARAGRAPH 10520
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_SECOND_PARAGRAPH 10521
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_RULE 10522
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_OPENS_IN 10523
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_SOURCE 10524
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TITLE 10525
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_DESCRIPTION 10526
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_FIRST_PARAGRAPH 10527
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_SECOND_PARAGRAPH 10528
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_RULE 10529
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_SOURCE 10530
#define IDS_NACL_APP_MISSING_ARCH_MESSAGE 10534
#define IDS_ABOUT_BOX_ERROR_DURING_UPDATE_CHECK 10535
#define IDS_ABOUT_BOX_ERROR_UPDATE_CHECK_FAILED 10536
#define IDS_ABOUT_BOX_EXTERNAL_UPDATE_IS_RUNNING 10537
#define IDS_ABOUT_BOX_GOOGLE_UPDATE_ERROR 10538
#define IDS_OMNIBOX_PLACEHOLDER_TEXT 440
#define IDS_PASTE_AND_GO 10539
#define IDS_PASTE_AND_SEARCH 10540
#define IDS_PASTE_AND_GO_EMPTY 10541
#define IDS_OMNIBOX_KEYWORD_HINT 10542
#define IDS_OMNIBOX_EXTENSION_KEYWORD_HINT 10543
#define IDS_OMNIBOX_KEYWORD_HINT_KEY_ACCNAME 10544
#define IDS_OMNIBOX_KEYWORD_HINT_TOUCH 10545
#define IDS_OMNIBOX_EXTENSION_KEYWORD_HINT_TOUCH 10546
#define IDS_OMNIBOX_KEYWORD_TEXT 10547
#define IDS_OMNIBOX_KEYWORD_TEXT_MD 10548
#define IDS_OMNIBOX_CLEAR_ALL 470
#define IDS_SEARCH_OR_TYPE_WEB_ADDRESS 10549
#define IDS_OMNIBOX_WHY_THIS_SUGGESTION 10550
#define IDS_OMNIBOX_REMOVE_SUGGESTION 668
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_TITLE 10551
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_DESCRIPTION 10552
#define IDS_CONTEXT_MENU_SHOW_FULL_URLS 10553
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT 10554
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MD 671
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_SHORT 10555
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TOOLTIP 10556
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TITLE 487
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT_TOOLTIP 10557
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT 488
#define IDS_NTP_CUSTOM_LINKS_MORE_ACTIONS 10558
#define IDS_UPLOAD_IMAGE_FORMAT 10559
#define IDS_NTP_CUSTOM_LINKS_NAME 499
#define IDS_NTP_CUSTOM_LINKS_URL 503
#define IDS_NTP_CUSTOM_LINKS_REMOVE 496
#define IDS_NTP_CUSTOM_LINKS_CANCEL 491
#define IDS_NTP_CUSTOM_LINKS_DONE 494
#define IDS_NTP_CUSTOM_LINKS_INVALID_URL 489
#define IDS_NTP_CUSTOM_LINKS_CANT_CREATE 492
#define IDS_NTP_CUSTOM_LINKS_CANT_EDIT 493
#define IDS_NTP_CUSTOM_LINKS_CANT_REMOVE 10560
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_REMOVED 497
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_EDITED 495
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_ADDED 490
#define IDS_NTP_CUSTOM_LINKS_ALREADY_EXISTS 502
#define IDS_NTP_CONFIRM_MSG_RESTORE_DEFAULTS 500
#define IDS_NTP_CUSTOM_BG_CHROME_WALLPAPERS 10561
#define IDS_NTP_CUSTOM_BG_UPLOAD_AN_IMAGE 10562
#define IDS_NTP_CUSTOM_BG_SELECT_A_COLLECTION 10563
#define IDS_NTP_CUSTOM_BG_DAILY_REFRESH 518
#define IDS_NTP_CUSTOM_BG_RESTORE_DEFAULT 10564
#define IDS_NTP_CUSTOM_BG_CANCEL 10565
#define IDS_NTP_CONNECTION_ERROR_NO_PERIOD 10566
#define IDS_NTP_CONNECTION_ERROR 10567
#define IDS_NTP_ERROR_MORE_INFO 10568
#define IDS_NTP_CUSTOM_BG_BACKGROUNDS_UNAVAILABLE 10569
#define IDS_NTP_CUSTOM_BG_BACK_LABEL 10570
#define IDS_NTP_CUSTOM_BG_IMAGE_SELECTED 10571
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_LABEL 509
#define IDS_NTP_DISMISS_PROMO 10572
#define IDS_NTP_DOODLE_SHARE_LABEL 566
#define IDS_NTP_DOODLE_SHARE_DIALOG_CLOSE_LABEL 10573
#define IDS_NTP_DOODLE_SHARE_DIALOG_FACEBOOK_LABEL 565
#define IDS_NTP_DOODLE_SHARE_DIALOG_TWITTER_LABEL 567
#define IDS_NTP_DOODLE_SHARE_DIALOG_MAIL_LABEL 564
#define IDS_NTP_DOODLE_SHARE_DIALOG_COPY_LABEL 562
#define IDS_NTP_DOODLE_SHARE_DIALOG_LINK_LABEL 563
#define IDS_NTP_CUSTOMIZE_APPEARANCE_LABEL 10574
#define IDS_NTP_CUSTOMIZE_THEMES_HEADER 10575
#define IDS_NTP_CUSTOMIZE_MENU_BACKGROUND_LABEL 504
#define IDS_NTP_CUSTOMIZE_MENU_BACKGROUND_DISABLED_LABEL 507
#define IDS_NTP_CUSTOMIZE_MENU_SHORTCUTS_LABEL 520
#define IDS_NTP_CUSTOMIZE_MENU_MODULES_LABEL 521
#define IDS_NTP_CUSTOMIZE_MENU_COLOR_LABEL 524
#define IDS_NTP_CUSTOMIZE_NO_BACKGROUND_LABEL 517
#define IDS_NTP_CUSTOMIZE_CHROME_COLORS_LABEL 10576
#define IDS_NTP_CUSTOMIZE_CHROME_CHANGE_THEME_LABEL 10577
#define IDS_NTP_CUSTOMIZE_CHROME_RESET_TO_CLASSIC_CHROME_LABEL 10578
#define IDS_NTP_CUSTOMIZE_CHROME_FOLLOW_THEME_LABEL 10579
#define IDS_NTP_CUSTOMIZE_UPLOADED_IMAGE_LABEL 10580
#define IDS_NTP_CUSTOMIZE_UPLOAD_FROM_DEVICE_LABEL 527
#define IDS_NTP_CUSTOMIZE_CHROME_CURRENT_THEME_LABEL 10581
#define IDS_NTP_CUSTOMIZE_HIDE_SHORTCUTS_LABEL 511
#define IDS_NTP_CUSTOMIZE_HIDE_SHORTCUTS_DESC 512
#define IDS_NTP_CUSTOMIZE_SHOW_CARDS_LABEL 10582
#define IDS_NTP_CUSTOMIZE_SHOW_SHORTCUTS_LABEL 10583
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_LABEL 516
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_LABEL 515
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_DESC 522
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_DESC 519
#define IDS_NTP_CUSTOMIZE_HIDE_ALL_CARDS_LABEL 513
#define IDS_NTP_CUSTOMIZE_CUSTOMIZE_CARDS_LABEL 514
#define IDS_NTP_CUSTOMIZE_3PT_THEME_DESC 525
#define IDS_NTP_CUSTOMIZE_3PT_THEME_UNINSTALL 526
#define IDS_NTP_CUSTOMIZE_COLOR_PICKER_LABEL 506
#define IDS_NTP_THEME_MANAGED_DIALOG_TITLE 569
#define IDS_NTP_THEME_MANAGED_DIALOG_BODY 570
#define IDS_NTP_THEMES_CONTAINER_LABEL 523
#define IDS_NTP_CUSTOMIZE_DEFAULT_LABEL 510
#define IDS_NTP_CUSTOMIZE_GREY_DEFAULT_LABEL 10584
#define IDS_NTP_CUSTOMIZE_MAIN_COLOR_LABEL 10585
#define IDS_NTP_COLORS_WARM_GREY 10586
#define IDS_NTP_COLORS_COOL_GREY 10587
#define IDS_NTP_COLORS_MIDNIGHT_BLUE 10588
#define IDS_NTP_COLORS_BLACK 10589
#define IDS_NTP_COLORS_BEIGE_AND_WHITE 10590
#define IDS_NTP_COLORS_YELLOW_AND_WHITE 10591
#define IDS_NTP_COLORS_GREEN_AND_WHITE 10592
#define IDS_NTP_COLORS_LIGHT_TEAL_AND_WHITE 10593
#define IDS_NTP_COLORS_LIGHT_PURPLE_AND_WHITE 10594
#define IDS_NTP_COLORS_PINK_AND_WHITE 10595
#define IDS_NTP_COLORS_BEIGE 10596
#define IDS_NTP_COLORS_ORANGE 10597
#define IDS_NTP_COLORS_LIGHT_GREEN 10598
#define IDS_NTP_COLORS_LIGHT_TEAL 10599
#define IDS_NTP_COLORS_LIGHT_BLUE 10600
#define IDS_NTP_COLORS_PINK 10601
#define IDS_NTP_COLORS_DARK_PINK_AND_RED 10602
#define IDS_NTP_COLORS_DARK_RED_AND_ORANGE 10603
#define IDS_NTP_COLORS_DARK_GREEN 10604
#define IDS_NTP_COLORS_DARK_TEAL 10605
#define IDS_NTP_COLORS_DARK_BLUE 10606
#define IDS_NTP_COLORS_DARK_PURPLE 10607
#define IDS_NTP_COLORS_BLUE 10608
#define IDS_NTP_COLORS_GREY 10609
#define IDS_NTP_COLORS_AQUA 10610
#define IDS_NTP_COLORS_GREEN 10611
#define IDS_NTP_COLORS_VIRIDIAN 10612
#define IDS_NTP_COLORS_CITRON 10613
#define IDS_NTP_COLORS_APRICOT 10614
#define IDS_NTP_COLORS_ROSE 10615
#define IDS_NTP_COLORS_FUCHSIA 10616
#define IDS_NTP_COLORS_VIOLET 10617
#define IDS_NTP_UNDO_DISMISS_PROMO_BUTTON_TOAST 660
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_GROUP_LABEL 10618
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_LIGHT_LABEL 10619
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_DARK_LABEL 10620
#define IDS_NTP_CUSTOMIZE_CHROME_COLOR_SCHEME_MODE_SYSTEM_LABEL 10621
#define IDS_NTP_WEBSTORE_TOAST_MESSAGE 10622
#define IDS_NTP_WEBSTORE_TOAST_BUTTON_TEXT 10623
#define IDS_NTP_MODULES_INFO_BUTTON_TITLE 574
#define IDS_NTP_MODULES_DISMISS_TOAST_MESSAGE 572
#define IDS_NTP_MODULES_DISABLE_TOAST_MESSAGE 573
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_MESSAGE 10624
#define IDS_NTP_MODULES_DISMISS_BUTTON_TEXT 575
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT 576
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT_V2 10625
#define IDS_NTP_MODULES_MORE_ACTIONS 10626
#define IDS_NTP_MODULES_CUSTOMIZE_BUTTON_TEXT 577
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_TODAY 10627
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_YESTERDAY 10628
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_WEEK 10629
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_MONTH 10630
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PREVIOUSLY 10631
#define IDS_NTP_MODULES_SHOPPING_TASKS_SENTENCE 10632
#define IDS_NTP_MODULES_SHOPPING_TASKS_LOWER 10633
#define IDS_NTP_MODULES_RECIPE_INFO 578
#define IDS_NTP_MODULES_RECIPE_EXTENDED_INFO 579
#define IDS_NTP_MODULES_RECIPE_TASKS_SENTENCE 580
#define IDS_NTP_MODULES_RECIPE_TASKS_LOWER 581
#define IDS_NTP_MODULES_RECIPE_TASKS_LOWER_THESE 582
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_SENTENCE 583
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_LOWER 584
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_LOWER_THESE 585
#define IDS_NTP_MODULES_CART_SENTENCE 588
#define IDS_NTP_MODULES_CART_SENTENCE_V2 589
#define IDS_NTP_MODULES_CART_LOWER 590
#define IDS_NTP_MODULES_CART_LOWER_THESE 591
#define IDS_NTP_MODULES_CART_LOWER_YOUR 592
#define IDS_NTP_MODULES_QUEST_CART_ANNOTATION 656
#define IDS_NTP_MODULES_QUEST_CART_TILE_LABEL_PLURAL 657
#define IDS_NTP_MODULES_QUEST_CART_TILE_LABEL_SINGULAR 658
#define IDS_NTP_MODULES_QUEST_CART_TILE_LABEL_DEFAULT 659
#define IDS_NTP_MODULES_CART_INFO 587
#define IDS_NTP_MODULES_CART_ITEM_COUNT_SINGULAR 636
#define IDS_NTP_MODULES_CART_ITEM_COUNT_MULTIPLE 637
#define IDS_NTP_MODULES_DRIVE_SENTENCE 593
#define IDS_NTP_MODULES_DRIVE_SENTENCE_V2 10634
#define IDS_NTP_MODULES_DRIVE_SENTENCE2 594
#define IDS_NTP_MODULES_DRIVE_FILES_SENTENCE 595
#define IDS_NTP_MODULES_DRIVE_FILES_LOWER 596
#define IDS_NTP_MODULES_DUMMY_LOWER 597
#define IDS_NTP_MODULES_DUMMY_TITLE 600
#define IDS_NTP_MODULES_DRIVE_TITLE 598
#define IDS_NTP_MODULES_DRIVE_TITLE_V2 10635
#define IDS_NTP_MODULES_DRIVE_INFO 599
#define IDS_NTP_MODULES_PHOTOS_TITLE 606
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_TITLE 605
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_HIDE_TODAY 609
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_HIDDEN_TODAY 610
#define IDS_NTP_MODULES_PHOTOS_SOFT_OPT_OUT 617
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_DISABLE 607
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_DISABLED 608
#define IDS_NTP_MODULES_PHOTOS_INFO 604
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_EXPLORE 611
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_TITLE 612
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_PERSONALIZED_WELCOME_TITLE_TEMPLATE 10636
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_RH_WELCOME_TITLE 10637
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_FAVORITE_PEOPLE_WELCOME_TITLE 10638
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_TRIPS_WELCOME_TITLE 10639
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_TEXT 613
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_OPT_IN 614
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_OPT_OUT 615
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_SOFT_OPT_OUT 616
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_EXAMPLE 618
#define IDS_NTP_MODULES_PHOTOS_BALOON_ILLUSTRATION_TITLE 619
#define IDS_NTP_MODULES_PHOTOS_NEW 620
#define IDS_NTP_MODULES_KALEIDOSCOPE_TITLE 603
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_TITLE 621
#define IDS_NTP_MODULES_TASKS_INFO 586
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_CLOSE 622
#define IDS_NTP_MODULES_SHOPPING_TASKS_RELATED 10640
#define IDS_NTP_MODULES_RECIPE_TASKS_RECOMMENDED 10641
#define IDS_NTP_MODULES_CART_WARM_WELCOME 623
#define IDS_NTP_MODULES_CART_MODULE_MENU_HIDE_TOAST_MESSAGE 624
#define IDS_NTP_MODULES_CART_CART_MENU_HIDE_MERCHANT 625
#define IDS_NTP_MODULES_CART_CART_MENU_HIDE_MERCHANT_TOAST_MESSAGE 626
#define IDS_NTP_MODULES_CART_CART_MENU_REMOVE_MERCHANT 627
#define IDS_NTP_MODULES_CART_CART_MENU_REMOVE_MERCHANT_TOAST_MESSAGE 628
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_AMOUNT 629
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_UP_TO_AMOUNT 630
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT 10642
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_ACCEPT 631
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_ACCEPT_CONFIRMATION 632
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_REJECT 633
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_REJECT_CONFIRMATION 634
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONFIRMATION_DISMISS 635
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT_V2 661
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT_V3 638
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_MERCHANT_NAME 663
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_TWO_MERCHANT_NAMES 664
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_THREE_MERCHANT_NAMES 665
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_CONTINUE 666
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_TITLE 639
#define IDS_NTP_MODULES_NEW_TAG_LABEL 640
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_TITLE 641
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_BODY_LINE_1 642
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_BODY_LINE_2 643
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_IN 644
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_OUT 645
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_OUT_TOAST 646
#define IDS_NTP_MODULES_FEED_TITLE 602
#define IDS_NTP_MODULES_RESUME_YOUR_JOURNEY 647
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_RESUME_BROWSING 10643
#define IDS_NTP_MODULES_SHOW_ALL 648
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_BOOKMARKED 654
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_INFO 649
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_INFO2 10644
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_WITH_DISCOUNT_INFO 10645
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SENTENCE2 650
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TOAST_NAME 10646
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISMISS_BUTTON 10647
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_TEXT 651
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DISABLE_DROPDOWN_TEXT 10648
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_DONE_BUTTON 10649
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_OPEN_ALL_IN_NEW_TAB_GROUP_BUTTON_TEXT 655
#define IDS_NTP_MODULES_HISTORY_CLUSTERS_SHOW_ALL_BUTTON 10650
#define IDS_ACCNAME_SHOW_ALL 652
#define IDS_ACCNAME_SEARCH_SUGG 653
#define IDS_EXTENSIONS_PROMO_PERFORMANCE 10651
#define IDS_EXTENSIONS_PROMO_PRIVACY 10652
#define IDS_EXTENSIONS_PROMO_NEUTRAL 10653
#define IDS_STAR_VIEW_MENU_ADD_BOOKMARK 10654
#define IDS_STAR_VIEW_MENU_EDIT_BOOKMARK 10655
#define IDS_STAR_VIEW_MENU_MOVE_TO_READ_LATER 10656
#define IDS_STAR_VIEW_MENU_MARK_AS_READ 10657
#define IDS_READ_LATER_TITLE 395
#define IDS_READ_LATER_MENU_UNREAD_HEADER 10658
#define IDS_READ_LATER_MENU_READ_HEADER 10659
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_READ 10660
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_UNREAD 10661
#define IDS_READ_LATER_MENU_EMPTY_STATE_ADD_FROM_DIALOG_SUBHEADER 10662
#define IDS_READ_LATER_MENU_EMPTY_STATE_HEADER 10663
#define IDS_READ_LATER_MENU_EMPTY_STATE_SUBHEADER 10664
#define IDS_READ_LATER_ADD_CURRENT_TAB 10665
#define IDS_READ_LATER_CANT_ADD_CURRENT_TAB 10666
#define IDS_READ_LATER_MARK_CURRENT_TAB_READ 10667
#define IDS_READ_LATER_REMOVE_CURRENT_TAB 10668
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_UNREAD 10669
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_READ 10670
#define IDS_READ_LATER_CONTEXT_MENU_DELETE 10671
#define IDS_READING_LIST_MENU 10672
#define IDS_READING_LIST_MENU_ADD_TAB 10673
#define IDS_READING_LIST_MENU_SHOW_UI 10674
#define IDS_ACCNAME_SIDE_PANEL_RESIZE 10675
#define IDS_ACCNAME_SIDE_PANEL_SELECTOR 10676
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_SHOW 10677
#define IDS_ACCNAME_SIDE_PANEL_COMPANION_HIDE 10678
#define IDS_SIDE_PANEL_COMPANION_TITLE 10679
#define IDS_SIDE_PANEL_COMPANION_TOOLBAR_TOOLTIP 10680
#define IDS_SIDE_PANEL_COMPANION_PROMO 10681
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_FIRST_LINE 10682
#define IDS_SIDE_PANEL_COMPANION_ERROR_PAGE_SECOND_LINE 10683
#define IDS_SIDE_PANEL_CUSTOMIZE_CHROME_TITLE 672
#define IDS_SIDE_PANEL_TOOLBAR_BUTTON_CXMENU_UNPIN 10684
#define IDS_SIDE_PANEL_HEADER_UNPIN_BUTTON_TOOLTIP 10685
#define IDS_SIDE_PANEL_HEADER_PIN_BUTTON_TOOLTIP 10686
#define IDS_BOOKMARKS_SORT_BY_TYPE 10687
#define IDS_BOOKMARKS_ALL_BOOKMARKS 10688
#define IDS_BOOKMARKS_ALL_BOOKMARKS_OPEN_SIDE_PANEL 10689
#define IDS_BOOKMARKS_LABEL_TRACKED_PRODUCTS 10690
#define IDS_BOOKMARKS_SORT_NEWEST 10691
#define IDS_BOOKMARKS_SORT_NEWEST_LOWER 10692
#define IDS_BOOKMARKS_SORT_OLDEST 10693
#define IDS_BOOKMARKS_SORT_OLDEST_LOWER 10694
#define IDS_BOOKMARKS_SORT_ALPHABETICALLY 10695
#define IDS_BOOKMARKS_SORT_REVERSE_ALPHABETICALLY 10696
#define IDS_BOOKMARKS_SORT_LAST_OPENED 10697
#define IDS_BOOKMARKS_SORT_LAST_OPENED_LOWER 10698
#define IDS_BOOKMARKS_VISUAL_VIEW 10699
#define IDS_BOOKMARKS_COMPACT_VIEW 10700
#define IDS_BOOKMARKS_SORT_MENU_A11Y_LABEL 10701
#define IDS_BOOKMARKS_CREATE_NEW_FOLDER_A11Y_LABEL 10702
#define IDS_BOOKMARKS_NEW_FOLDER_TOOLTIP 10703
#define IDS_BOOKMARKS_EDIT_BOOKMARK_LIST_A11Y_LABEL 10704
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE 10705
#define IDS_BOOKMARKS_EMPTY_STATE_BODY 10706
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_FOLDER 10707
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_FOLDER 10708
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_GUEST 10709
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_GUEST 10710
#define IDS_BOOKMARKS_EMPTY_STATE_TITLE_SEARCH 10711
#define IDS_BOOKMARKS_EMPTY_STATE_BODY_SEARCH 10712
#define IDS_BOOKMARK_FOLDER_CHILD_COUNT 10713
#define IDS_BOOKMARKS_EDIT_BOOKMARK 10714
#define IDS_BOOKMARKS_EDIT_MOVE_TO_ANOTHER_FOLDER 10715
#define IDS_BOOKMARKS_EDIT_MORE 10716
#define IDS_BOOKMARKS_EDIT_MOVE_TO 10717
#define IDS_BOOKMARKS_EDIT_NEW_FOLDER 10718
#define IDS_BOOKMARKS_EDIT_CANCEL 10719
#define IDS_BOOKMARKS_EDIT_SAVE 10720
#define IDS_BOOKMARKS_EDIT_NAME 10721
#define IDS_BOOKMARKS_EDIT_URL 10722
#define IDS_BOOKMARK_DELETION_COUNT 10723
#define IDS_UNDO_BOOKMARK_DELETION 10724
#define IDS_BOOKMARKS_MOVE_TO_BOOKMARKS_BAR 10725
#define IDS_BOOKMARKS_MOVE_TO_ALL_BOOKMARKS 10726
#define IDS_BOOKMARKS_EDIT 10727
#define IDS_BOOKMARKS_RENAME 10728
#define IDS_BOOKMARKS_URL_FOLDER_DESCRIPTION 10729
#define IDS_BOOKMARKS_DISABLED_FEATURE 10730
#define IDS_BOOKMARKS_BACK_BUTTON_LABEL 10731
#define IDS_BOOKMARKS_BACK_BUTTON_TOOLTIP 10732
#define IDS_BOOKMARKS_FORWARD_BUTTON_LABEL 10733
#define IDS_BOOKMARK_OPTIONS_LABEL 10734
#define IDS_FOLDER_OPTIONS_LABEL 10735
#define IDS_BOOKMARKS_OPEN_FOLDER_LABEL 10736
#define IDS_BOOKMARKS_OPEN_BOOKMARK_LABEL 10737
#define IDS_BOOKMARKS_SELECT_FOLDER_LABEL 10738
#define IDS_BOOKMARKS_SELECT_BOOKMARK_LABEL 10739
#define IDS_BOOKMARKS_DESELECT_FOLDER_LABEL 10740
#define IDS_BOOKMARKS_DESELECT_BOOKMARK_LABEL 10741
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_TRACKING 10742
#define IDS_BOOKMARK_ACCESSIBLE_DESCRIPTION_PRICE_CHANGE 10743
#define IDS_BOOKMARKS_CHECKBOX_LABEL 10744
#define IDS_BOOKMARKS_PRIMARY_FILTER_HEADING 10745
#define IDS_BOOKMARKS_SECONDARY_FILTER_HEADING 10746
#define IDS_READING_MODE_TITLE 10747
#define IDS_READING_MODE_NOT_SELECTABLE_HEADER 10748
#define IDS_READING_MODE_EMPTY_STATE_HEADER 10749
#define IDS_READING_MODE_EMPTY_STATE_SUBHEADER 10750
#define IDS_READING_MODE_TOOLBAR_LABEL 10751
#define IDS_READING_MODE_DISPLAY_SETTINGS 10752
#define IDS_READING_MODE_FONT_SIZE 10753
#define IDS_READING_MODE_FONT_NAME_COMBOBOX_LABEL 10754
#define IDS_READING_MODE_DECREASE_FONT_SIZE_BUTTON_LABEL 10755
#define IDS_READING_MODE_INCREASE_FONT_SIZE_BUTTON_LABEL 10756
#define IDS_READING_MODE_COLORS_COMBOBOX_LABEL 10757
#define IDS_READING_MODE_LINE_SPACING_COMBOBOX_LABEL 10758
#define IDS_READING_MODE_LETTER_SPACING_COMBOBOX_LABEL 10759
#define IDS_READING_MODE_SPACING_COMBOBOX_STANDARD 10760
#define IDS_READING_MODE_SPACING_COMBOBOX_LOOSE 10761
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_LOOSE 10762
#define IDS_READING_MODE_SPACING_COMBOBOX_WIDE 10763
#define IDS_READING_MODE_SPACING_COMBOBOX_VERY_WIDE 10764
#define IDS_READING_MODE_DEFAULT_COLOR_LABEL 10765
#define IDS_READING_MODE_LIGHT_COLOR_LABEL 10766
#define IDS_READING_MODE_DARK_COLOR_LABEL 10767
#define IDS_READING_MODE_YELLOW_COLOR_LABEL 10768
#define IDS_READING_MODE_BLUE_COLOR_LABEL 10769
#define IDS_READ_ANYTHING_LOADING 10770
#define IDS_READING_MODE_BACK 10771
#define IDS_READING_MODE_SIDE_PANEL_PROMO 10772
#define IDS_USER_NOTE_TITLE 10773
#define IDS_ADD_NEW_USER_NOTE_PLACEHOLDER_TEXT 10774
#define IDS_USER_NOTES_SORT_MENU_A11Y_LABEL 10775
#define IDS_LEARN_MORE_USER_NOTE 10776
#define IDS_ALL_NOTES 10777
#define IDS_USER_NOTES_CURRENT_TAB_HEADER 10778
#define IDS_NOTES_COUNT 10779
#define IDS_USER_NOTES_MENU_OPEN_IN_NEW_TAB 10780
#define IDS_USER_NOTES_MENU_OPEN_IN_NEW_WINDOW 10781
#define IDS_USER_NOTES_MENU_OPEN_IN_INCOGNITO 10782
#define IDS_USER_NOTES_EMPTY_STATE_TITLE 10783
#define IDS_USER_NOTES_EMPTY_STATE_BODY 10784
#define IDS_USER_NOTES_EMPTY_STATE_TITLE_GUEST 10785
#define IDS_USER_NOTES_EMPTY_STATE_BODY_GUEST 10786
#define IDS_FEED_TITLE 10787
#define IDS_GOOGLE_LENS_TITLE 10788
#define IDS_TOOLTIP_BACK 409
#define IDS_ACCDESCRIPTION_BACK 411
#define IDS_TOOLTIP_CHROMELABS_BUTTON 10789
#define IDS_TOOLTIP_LEFT_ALIGNED_SIDE_PANEL_BUTTON 10790
#define IDS_TOOLTIP_CHROMELABS_COMBOBOX 10791
#define IDS_TOOLTIP_CHROMELABS_FEEDBACK_BUTTON 10792
#define IDS_TOOLTIP_FORWARD 412
#define IDS_ACCDESCRIPTION_FORWARD 414
#define IDS_TOOLTIP_DOWNLOAD_ICON 10793
#define IDS_TOOLTIP_HOME 419
#define IDS_TOOLTIP_RELOAD 10794
#define IDS_TOOLTIP_RELOAD_WITH_MENU 10795
#define IDS_TOOLTIP_STOP 695
#define IDS_TOOLTIP_EXTENSIONS_BUTTON 421
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ALL_EXTENSIONS_BLOCKED 10796
#define IDS_TOOLTIP_EXTENSIONS_BUTTON_ANY_EXTENSION_HAS_ACCESS 10797
#define IDS_TOOLTIP_EXTENSIONS_SITE_ACCESS_BUTTON 10798
#define IDS_TOOLTIP_SIDE_PANEL_SHOW 433
#define IDS_TOOLTIP_SIDE_PANEL_HIDE 10799
#define IDS_TOOLTIP_SIDE_PANEL 10800
#define IDS_TOOLTIP_LOCATION_ICON 439
#define IDS_TOOLTIP_NEW_TAB 393
#define IDS_TOOLTIP_MIC_SEARCH 541
#define IDS_TOOLTIP_LENS_SEARCH 543
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_CLOSE_BUTTON_LABEL 544
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TITLE 545
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_TITLE 546
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_UPLOAD_FILE_TITLE 547
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OR_TEXT 548
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_TEXT_PLACEHOLDER 549
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_SEARCH_BUTTON_LABEL 550
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_DRAG_DROP_TITLE 551
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_LOADING_TEXT 552
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_TEXT 553
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_SUBTITLE_TEXT 554
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_OFFLINE_BUTTON_LABEL 555
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_TYPE 556
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_FILE_SIZE 557
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_FILES 558
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_SCHEME 559
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_VALIDATION_ERROR_CONFORMANCE 560
#define IDS_LENS_SEARCH_UPLOAD_DIALOG_ERROR_MULTIPLE_URLS 561
#define IDS_TOOLTIP_SAVE_CREDIT_CARD 461
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_PENDING 10802
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_FAILURE 10803
#define IDS_TOOLTIP_SAVE_CVC 10804
#define IDS_TOOLTIP_SAVE_IBAN 10805
#define IDS_TOOLTIP_MIGRATE_LOCAL_CARD 462
#define IDS_MANAGE_IBAN_VALUE_SHOW_VALUE 10806
#define IDS_MANAGE_IBAN_VALUE_HIDE_VALUE 10807
#define IDS_TOOLTIP_TRANSLATE 455
#define IDS_TOOLTIP_ZOOM 456
#define IDS_TOOLTIP_ZOOM_EXTENSION_ICON 10808
#define IDS_ZOOM_SET_DEFAULT 10809
#define IDS_TOOLTIP_FIND 454
#define IDS_TOOLTIP_TAB_SEARCH 406
#define IDS_TOOLTIP_INTENT_PICKER_ICON 452
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_WITH 10810
#define IDS_INTENT_PICKER_BUBBLE_VIEW_REMEMBER_SELECTION 10811
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN 10812
#define IDS_INTENT_PICKER_BUBBLE_VIEW_STAY_IN_CHROME 10813
#define IDS_INTENT_PICKER_BUBBLE_VIEW_INITIATING_ORIGIN 10814
#define IDS_INTENT_CHIP_OPEN_IN_APP 10815
#define IDS_INTENT_PICKER_SELECT_AN_APP_GENERIC_SUBTITLE 10819
#define IDS_ACCESSIBLE_INCOGNITO_WINDOW_TITLE_FORMAT 10827
#define IDS_ACCESSIBLE_GUEST_WINDOW_TITLE_FORMAT 10828
#define IDS_ACCESSIBLE_WINDOW_TITLE_WITH_PROFILE_FORMAT 10829
#define IDS_ACCNAME_APP_UPGRADE_RECOMMENDED 10830
#define IDS_ACCNAME_FULLSCREEN 10831
#define IDS_ACCNAME_EXIT_FULLSCREEN 10832
#define IDS_ACCNAME_HOME 420
#define IDS_ACCNAME_RELOAD 418
#define IDS_ACCNAME_FIND 10833
#define IDS_ACCNAME_BOOKMARKS 686
#define IDS_ACCNAME_SAVED_TAB_GROUPS 679
#define IDS_ACCNAME_SAVED_TAB_GROUPS_CHEVRON 680
#define IDS_SAVED_TAB_GROUPS_OVERFLOW_BUTTON_TOOLTIP 681
#define IDS_ACCNAME_BOOKMARKS_CHEVRON 682
#define IDS_ACCNAME_BOOKMARK_BUTTON_ROLE_DESCRIPTION 10834
#define IDS_ACCNAME_BOOKMARK_FOLDER_BUTTON_ROLE_DESCRIPTION 689
#define IDS_ACCNAME_SAVED_TAB_GROUP_BUTTON_ROLE_DESCRIPTION 10835
#define IDS_ACCNAME_CHROMELABS_BUTTON 10836
#define IDS_ACCNAME_LEFT_ALIGNED_SIDE_PANEL_BUTTON 10837
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_ADDED_BY_ENTERPRISE_POLICY 10838
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_REMOVED_BY_ENTERPRISE_POLICY 10839
#define IDS_ACCNAME_CHROMELABS_COMBOBOX 10840
#define IDS_ACCNAME_CHROMELABS_COMBOBOX_MAC 10841
#define IDS_ACCNAME_SEPARATOR 690
#define IDS_ACCNAME_EXTENSIONS 10842
#define IDS_ACCNAME_NEWTAB 394
#define IDS_ACCNAME_MINIMIZE 10843
#define IDS_ACCNAME_MAXIMIZE 10844
#define IDS_ACCNAME_RESTORE 10845
#define IDS_ACCNAME_CLOSE_TAB 10846
#define IDS_ACCNAME_ZOOM_SET_DEFAULT 10847
#define IDS_ACCNAME_TAB_SEARCH 405
#define IDS_ACCNAME_TAB_SCROLL_LEADING 10848
#define IDS_ACCNAME_TAB_SCROLL_TRAILING 10849
#define IDS_ACCNAME_MUTE_TAB 673
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_LEADING_SCROLL_BUTTON 10850
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_TRAILING_SCROLL_BUTTON 10851
#define IDS_ALLOWED_CLIPBOARD_TITLE 10852
#define IDS_BLOCKED_CLIPBOARD_TITLE 10853
#define IDS_ALLOWED_CLIPBOARD_MESSAGE 10854
#define IDS_ALLOWED_CLIPBOARD_BLOCK 10855
#define IDS_ALLOWED_CLIPBOARD_NO_ACTION 10856
#define IDS_BLOCKED_CLIPBOARD_MESSAGE 10857
#define IDS_BLOCKED_CLIPBOARD_UNBLOCK 10858
#define IDS_BLOCKED_CLIPBOARD_NO_ACTION 10859
#define IDS_BACK_NAVIGATION_MENU_PROMO 10860
#define IDS_BACK_NAVIGATION_MENU_PROMO_ACCESSIBLE_TEXT 10861
#define IDS_BOOKMARK_PROMO_0 10862
#define IDS_BOOKMARK_PROMO_1 10863
#define IDS_BOOKMARK_PROMO_2 10864
#define IDS_CHROME_TIP 10865
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_TITLE 10866
#define IDS_EXTENSIONS_MENU_IPH_ENTRY_POINT_BODY 10867
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_TITLE 10868
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_IPH_ENTRY_POINT_BODY 10869
#define IDS_GLOBAL_MEDIA_CONTROLS_PROMO 10870
#define IDS_INCOGNITOWINDOW_PROMO_0 10871
#define IDS_INCOGNITOWINDOW_PROMO_1 10872
#define IDS_INCOGNITOWINDOW_PROMO_2 10873
#define IDS_INCOGNITOWINDOW_PROMO_3 10874
#define IDS_NEWTAB_PROMO_0 10875
#define IDS_NEWTAB_PROMO_1 10876
#define IDS_NEWTAB_PROMO_2 10877
#define IDS_POWER_BOOKMARKS_SIDE_PANEL_PROMO 10878
#define IDS_READING_LIST_DISCOVERY_PROMO 10879
#define IDS_READING_LIST_ENTRY_POINT_PROMO 10880
#define IDS_DESKTOP_PWA_INSTALL_PROMO 10881
#define IDS_UPDATED_CONNECTION_SECURITY_INDICATORS_PROMO 10882
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO 10883
#define IDS_TAB_GROUPS_NEW_GROUP_PROMO 10884
#define IDS_TAB_GROUPS_UNNAMED_GROUP_TOOLTIP 10885
#define IDS_TAB_GROUPS_NAMED_GROUP_TOOLTIP 10886
#define IDS_TAB_AUDIO_MUTING_PROMO 10887
#define IDS_SHARED_HIGHLIGHTING_PROMO 10888
#define IDS_BATTERY_SAVER_MODE_PROMO_TITLE 388
#define IDS_BATTERY_SAVER_MODE_PROMO_TEXT 10889
#define IDS_BATTERY_SAVER_MODE_PROMO_ACTION_TEXT 387
#define IDS_HIGH_EFFICIENCY_MODE_PROMO_TEXT 10890
#define IDS_HIGH_EFFICIENCY_MODE_PROMO_ACTION_TEXT 389
#define IDS_TUTORIAL_GENERIC_SUCCESS_TITLE 10891
#define IDS_TUTORIAL_TAB_GROUP_ADD_TAB_TO_GROUP 10892
#define IDS_TUTORIAL_ADD_TAB_TO_GROUP_WITH_EXISTING_GROUP_IN_TAB_STRIP 10893
#define IDS_TUTORIAL_TAB_GROUP_EDIT_BUBBLE 10894
#define IDS_TUTORIAL_TAB_GROUP_DRAG_TAB 10895
#define IDS_TUTORIAL_TAB_GROUP_COLLAPSE 10896
#define IDS_TUTORIAL_TAB_GROUP_SUCCESS_DESCRIPTION 10897
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_OPEN_SIDE_PANEL 10898
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_ADD_TAB 10899
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_MARK_READ 10900
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_CLICK_DROPDOWN 10901
#define IDS_TUTORIAL_SIDE_PANEL_READING_LIST_SUCCESS_BODY 10902
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_BODY 10903
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_POINTER_BODY 10904
#define IDS_IPH_CUSTOMIZE_CHROME_REFRESH_CUSTOM_ACTION 10905
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_START_TUTORIAL_IPH 10906
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_OPEN_SIDE_PANEL 10907
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CHANGE_THEME 10908
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SELECT_COLLECTION 10909
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_APPLY_THEME 10910
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_CLICK_BACK_ARROW 10911
#define IDS_TUTORIAL_CUSTOMIZE_CHROME_SUCCESS_BODY 10912
#define IDS_TUTORIAL_PASSWORD_MANAGER_OPEN_MENU 10913
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_PASSWORDS_MENU 10914
#define IDS_TUTORIAL_PASSWORD_MANAGER_SELECT_SETTINGS 10915
#define IDS_TUTORIAL_PASSWORD_MANAGER_ADD_SHORTCUT 10916
#define IDS_TUTORIAL_PASSWORD_MANAGER_CLICK_INSTALL 10917
#define IDS_BROWSER_HANGMONITOR 10918
#define IDS_BROWSER_HANGMONITOR_RENDERER_TITLE 10919
#define IDS_BROWSER_HANGMONITOR_RENDERER 10920
#define IDS_BROWSER_HANGMONITOR_IFRAME_TITLE 10921
#define IDS_BROWSER_HANGMONITOR_RENDERER_WAIT 10922
#define IDS_BROWSER_HANGMONITOR_RENDERER_END 10923
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR 10924
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR_KILLBUTTON 10925
#define IDS_PASSWORDS_AUTO_SIGNIN_TITLE 10926
#define IDS_PASSWORDS_AUTO_SIGNIN_DESCRIPTION 10927
#define IDS_PASSWORDS_VIA_FEDERATION 10928
#define IDS_CONFIRM_MESSAGEBOX_YES_BUTTON_LABEL 10929
#define IDS_CONFIRM_MESSAGEBOX_NO_BUTTON_LABEL 10930
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_TITLE 10931
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_DESCRIPTION 10932
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_TITLE 10933
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_ACCEPT 10934
#define IDS_TAILORED_SECURITY_DISPLAY_SOURCE 10935
#define IDS_PASSWORD_MANAGER_CANCEL_BUTTON 10936
#define IDS_PASSWORD_MANAGER_USERNAME_LABEL 10937
#define IDS_PASSWORD_MANAGER_PASSWORD_LABEL 10938
#define IDS_PASSWORD_MANAGER_UPDATED_BUBBLE_TITLE 10939
#define IDS_PASSWORD_MANAGER_MORE_TO_FIX_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 10940
#define IDS_PASSWORD_MANAGER_SAFE_STATE_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 10941
#define IDS_PASSWORD_MANAGER_CHECK_REMAINING_BUTTON 10942
#define IDS_PASSWORD_MANAGER_SAVE_BUTTON 10943
#define IDS_PASSWORD_MANAGER_SAVE_BUBBLE_OPT_IN_BUTTON 10944
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_OK_BUTTON 10945
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_CANCEL_BUTTON 10946
#define IDS_PASSWORD_MANAGER_UPDATE_BUTTON 10947
#define IDS_PASSWORD_MANAGER_BUBBLE_BLOCKLIST_BUTTON 10948
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_ACCESSIBLE_NAME 10949
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_ACCOUNT 10950
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_DEVICE 10951
#define IDS_PASSWORD_MANAGER_IPH_TITLE_SAVE_TO_ACCOUNT 386
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_REAUTH_FAIL 10952
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_TO_ACCOUNT 10953
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE 10954
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_AFTER_SAVE_SCREENREADER 10955
#define IDS_PASSWORD_MANAGER_IPH_CREATE_SHORTCUT_TITLE 10956
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN 10957
#define IDS_PASSWORD_MANAGER_IPH_MANAGEMENT_BUBBLE_DURING_SIGNIN_SCREENREADER 10958
#define IDS_PASSWORD_MANAGER_TOOLTIP_SAVE 10959
#define IDS_PASSWORD_MANAGER_TOOLTIP_MANAGE 451
#define IDS_PASSWORD_MANAGER_TOOLTIP_MOVE 10960
#define IDS_PASSWORD_MANAGER_TOOLTIP_PROTECT 10961
#define IDS_PASSWORD_MANAGER_TOOLTIP_SHARED_NOTIFICATION 10962
#define IDS_PASSWORD_MANAGER_IMPORT_DIALOG_TITLE 10963
#define IDS_PASSWORD_MANAGER_EXPORT_DIALOG_TITLE 10964
#define IDS_PASSWORD_MANAGER_MOVE_TITLE 10965
#define IDS_PASSWORD_MANAGER_MOVE_HINT 10966
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_TITLE_GPM 10967
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_DESCRIPTION_GPM 10968
#define IDS_PASSWORD_MANAGER_SAVE_UNSYNCED_CREDENTIALS_BUTTON_GPM 10969
#define IDS_PASSWORD_MANAGER_DISCARD_UNSYNCED_CREDENTIALS_BUTTON 10970
#define IDS_IMPORT_FROM_IE 10987
#define IDS_IMPORT_FROM_EDGE 10988
#define IDS_IMPORT_FROM_FIREFOX 10989
#define IDS_IMPORT_FROM_ICEWEASEL 10990
#define IDS_IMPORT_FROM_SAFARI 10991
#define IDS_IMPORT_FROM_BOOKMARKS_HTML_FILE 10992
#define IDS_IMPORTER_LOCK_TITLE 10996
#define IDS_IMPORTER_LOCK_TEXT 10997
#define IDS_IMPORTER_LOCK_OK 10998
#define IDS_FEEDBACK_REPORT_APP_TITLE 10999
#define IDS_FEEDBACK_REPORT_PAGE_TITLE 11000
#define IDS_FEEDBACK_REPORT_PAGE_TITLE_SAD_TAB_FLOW 11001
#define IDS_FEEDBACK_MINIMIZE_BUTTON_LABEL 11002
#define IDS_FEEDBACK_CLOSE_BUTTON_LABEL 11003
#define IDS_FEEDBACK_FREE_TEXT_LABEL 11004
#define IDS_FEEDBACK_REPORT_URL_LABEL 11005
#define IDS_FEEDBACK_USER_EMAIL_LABEL 11006
#define IDS_FEEDBACK_ANONYMOUS_EMAIL_OPTION 11007
#define IDS_FEEDBACK_CONSENT_CHECKBOX_LABEL 11008
#define IDS_FEEDBACK_SCREENSHOT_LABEL 11009
#define IDS_FEEDBACK_SCREENSHOT_A11Y_TEXT 11010
#define IDS_FEEDBACK_INCLUDE_PERFORMANCE_TRACE_CHECKBOX 11011
#define IDS_FEEDBACK_BLUETOOTH_LOGS_CHECKBOX 11012
#define IDS_FEEDBACK_ASSISTANT_LOGS_MESSAGE 11013
#define IDS_FEEDBACK_BLUETOOTH_LOGS_MESSAGE 11014
#define IDS_FEEDBACK_OFFLINE_DIALOG_TITLE 11015
#define IDS_FEEDBACK_OFFLINE_DIALOG_TEXT 11016
#define IDS_FEEDBACK_INCLUDE_SYSTEM_INFORMATION_CHKBOX 11017
#define IDS_FEEDBACK_INCLUDE_ASSISTANT_INFORMATION_CHKBOX 11020
#define IDS_FEEDBACK_ATTACH_FILE_NOTE 11021
#define IDS_FEEDBACK_ATTACH_FILE_LABEL 11022
#define IDS_FEEDBACK_ATTACH_FILE_TO_BIG 11023
#define IDS_FEEDBACK_INCLUDE_AUTOFILL_METADATA_CHECKBOX 11024
#define IDS_FEEDBACK_IWLWIFI_DEBUG_DUMP_EXPLAINER 11025
#define IDS_FEEDBACK_PRIVACY_NOTE 11026
#define IDS_FEEDBACK_NO_DESCRIPTION 11027
#define IDS_FEEDBACK_SEND_REPORT 11028
#define IDS_FEEDBACK_AUTOFILL_METADATA_PAGE_TITLE 11029
#define IDS_FEEDBACK_SYSINFO_PAGE_TITLE 11030
#define IDS_FEEDBACK_SYSINFO_PAGE_LOADING 11031
#define IDS_FEEDBACK_ADDITIONAL_INFO_LABEL 11032
#define IDS_CLEAR_BROWSING_DATA_TITLE 11033
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE 11034
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_TITLE 11035
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_OK 11036
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE 11037
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_TITLE 11038
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_OK 11039
#define IDS_MEDIA_SELECTED_MIC_LABEL 11040
#define IDS_MEDIA_SELECTED_CAMERA_LABEL 11041
#define IDS_MEDIA_MENU_NO_DEVICE_TITLE 11042
#define IDS_MEDIA_CONTROLS_TITLE_PLACEHOLDER_INCOGNITO 11043
#define IDS_ZOOMLEVELS_CHROME_ERROR_PAGES_LABEL 11044
#define IDS_STORAGE_ACCESS_MANAGE_TEXT 11045
#define IDS_STORAGE_ACCESS_MANAGE_TOOLTIP 11046
#define IDS_UPGRADE_ERROR 11053
#define IDS_UPGRADE_ERROR_DETAILS 11054
#define IDS_UPGRADE_DISABLED_BY_POLICY 11055
#define IDS_UPGRADE_DISABLED_BY_POLICY_MANUAL 11056
#define IDS_REPORT_AN_ISSUE 11057
#define IDS_CHROME_CLEANUP_PROMPT_DETAILS_BUTTON_LABEL 11058
#define IDS_CHROME_CLEANUP_PROMPT_REMOVE_BUTTON_LABEL 11059
#define IDS_CHROME_CLEANUP_PROMPT_TITLE 11060
#define IDS_CHROME_CLEANUP_REBOOT_PROMPT_TITLE 11061
#define IDS_CHROME_CLEANUP_REBOOT_PROMPT_RESTART_BUTTON_LABEL 11062
#define IDS_CHROME_CLEANUP_LOGS_PERMISSION 11063
#define IDS_SETTINGS_RESET_PROMPT_TITLE_SEARCH_ENGINE 11064
#define IDS_SETTINGS_RESET_PROMPT_TITLE_STARTUP_PAGE 11065
#define IDS_SETTINGS_RESET_PROMPT_TITLE_HOMEPAGE 11066
#define IDS_SETTINGS_RESET_PROMPT_ACCEPT_BUTTON_LABEL 11067
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_SEARCH_ENGINE_NO_EXTENSIONS 11068
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_STARTUP_PAGE_SINGLE_NO_EXTENSIONS 11069
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_STARTUP_PAGE_MULTIPLE_NO_EXTENSIONS 11070
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_HOMEPAGE_NO_EXTENSIONS 11071
#define IDS_REENABLE_UPDATES 11072
#define IDS_PICTURE_IN_PICTURE_TITLE_TEXT 11073
#define IDS_PICTURE_IN_PICTURE_PAUSE_CONTROL_TEXT 11074
#define IDS_PICTURE_IN_PICTURE_PLAY_CONTROL_TEXT 11075
#define IDS_PICTURE_IN_PICTURE_REPLAY_CONTROL_TEXT 11076
#define IDS_PICTURE_IN_PICTURE_BACK_TO_TAB_CONTROL_TEXT 11077
#define IDS_PICTURE_IN_PICTURE_SKIP_AD_CONTROL_TEXT 11078
#define IDS_PICTURE_IN_PICTURE_MUTE_MICROPHONE_TEXT 11079
#define IDS_PICTURE_IN_PICTURE_UNMUTE_MICROPHONE_TEXT 11080
#define IDS_PICTURE_IN_PICTURE_TURN_ON_CAMERA_TEXT 11081
#define IDS_PICTURE_IN_PICTURE_TURN_OFF_CAMERA_TEXT 11082
#define IDS_PICTURE_IN_PICTURE_HANG_UP_TEXT 11083
#define IDS_PICTURE_IN_PICTURE_CLOSE_CONTROL_TEXT 11084
#define IDS_PICTURE_IN_PICTURE_RESIZE_HANDLE_TEXT 11085
#define IDS_PICTURE_IN_PICTURE_PLAY_PAUSE_CONTROL_ACCESSIBLE_TEXT 11086
#define IDS_PICTURE_IN_PICTURE_NEXT_TRACK_CONTROL_ACCESSIBLE_TEXT 11087
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_TRACK_CONTROL_ACCESSIBLE_TEXT 11088
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_SLIDE_CONTROL_ACCESSIBLE_TEXT 11089
#define IDS_PICTURE_IN_PICTURE_NEXT_SLIDE_CONTROL_ACCESSIBLE_TEXT 11090
#define IDS_LOAD_STATE_WAITING_FOR_SOCKET_SLOT 11091
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE 11092
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE_GENERIC 11093
#define IDS_LOAD_STATE_WAITING_FOR_CACHE 11094
#define IDS_LOAD_STATE_ESTABLISHING_PROXY_TUNNEL 11095
#define IDS_LOAD_STATE_RESOLVING_PROXY_FOR_URL 11096
#define IDS_LOAD_STATE_RESOLVING_HOST_IN_PAC_FILE 11097
#define IDS_LOAD_STATE_DOWNLOADING_PAC_FILE 11098
#define IDS_LOAD_STATE_RESOLVING_HOST 11099
#define IDS_LOAD_STATE_CONNECTING 11100
#define IDS_LOAD_STATE_SSL_HANDSHAKE 11101
#define IDS_LOAD_STATE_SENDING_REQUEST 11102
#define IDS_LOAD_STATE_SENDING_REQUEST_WITH_PROGRESS 11103
#define IDS_LOAD_STATE_WAITING_FOR_RESPONSE 11104
#define IDS_TAB_CXMENU_NEWTABTORIGHT 11105
#define IDS_TAB_CXMENU_NEWTABTOLEFT 11106
#define IDS_TAB_CXMENU_RELOAD 11107
#define IDS_TAB_CXMENU_DUPLICATE 11108
#define IDS_TAB_CXMENU_CLOSETAB 11109
#define IDS_TAB_CXMENU_CLOSEOTHERTABS 11110
#define IDS_TAB_CXMENU_CLOSETABSTORIGHT 11111
#define IDS_TAB_CXMENU_CLOSETABSTOLEFT 11112
#define IDS_TAB_CXMENU_CLOSEALLTABS 11113
#define IDS_TAB_CXMENU_FOCUS_THIS_TAB 11114
#define IDS_TAB_CXMENU_PIN_TAB 11115
#define IDS_TAB_CXMENU_UNPIN_TAB 11116
#define IDS_TAB_CXMENU_SOUND_MUTE_SITE 11117
#define IDS_TAB_CXMENU_SOUND_UNMUTE_SITE 11118
#define IDS_TAB_CXMENU_READ_LATER 11119
#define IDS_TAB_CXMENU_ADD_TAB_TO_GROUP 11120
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_GROUP 11121
#define IDS_TAB_CXMENU_SUBMENU_NEW_GROUP 11122
#define IDS_TAB_CXMENU_REMOVE_TAB_FROM_GROUP 11123
#define IDS_TAB_CXMENU_PLACEHOLDER_GROUP_TITLE 11124
#define IDS_TAB_CXMENU_MOVE_TABS_TO_NEW_WINDOW 11125
#define IDS_TAB_CXMENU_MOVETOANOTHERWINDOW 11126
#define IDS_TAB_CXMENU_MOVETOANOTHERNEWWINDOW 11127
#define IDS_TAB_CXMENU_FOLLOW_SITE 11128
#define IDS_TAB_CXMENU_UNFOLLOW_SITE 11129
#define IDS_WEBUI_TAB_STRIP_PROMO 11133
#define IDS_TOOLTIP_WEBUI_TAB_STRIP_TAB_COUNTER 11134
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_NEW_TAB 11135
#define IDS_WEBUI_TAB_STRIP_TAB_COUNTER_CXMENU_CLOSE_TAB 11136
#define IDS_TAB_SEARCH_PROMO 11137
#define IDS_TAB_SEARCH_SEARCH_TABS 11138
#define IDS_TAB_SEARCH_NO_RESULTS_FOUND 11139
#define IDS_TAB_SEARCH_CLOSE_TAB 11140
#define IDS_TAB_SEARCH_SUBMIT_FEEDBACK 11141
#define IDS_TAB_SEARCH_A11Y_TAB_CLOSED 11142
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB 11143
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS 11144
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB_FOR 11145
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS_FOR 11146
#define IDS_TAB_SEARCH_A11Y_OPEN_TAB 11147
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB 11148
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB_GROUP 11149
#define IDS_TAB_SEARCH_MEDIA_TABS 11150
#define IDS_TAB_SEARCH_OPEN_TABS 11151
#define IDS_TAB_SEARCH_RECENTLY_CLOSED 11152
#define IDS_TAB_SEARCH_RECENTLY_CLOSED_TABS 11153
#define IDS_TAB_SEARCH_ONE_TAB 11154
#define IDS_TAB_SEARCH_TAB_COUNT 11155
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED_ITEMS 11156
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED 11157
#define IDS_TAB_SEARCH_COLLAPSE_RECENTLY_CLOSED 11158
#define IDS_BROWSER_WINDOW_TITLE_MENU_ENTRY 11159
#define IDS_TAB_GROUP_HEADER_CXMENU_TAB_GROUP_TITLE_ACCESSIBLE_NAME 11160
#define IDS_TAB_GROUP_HEADER_CXMENU_SAVE_GROUP 11161
#define IDS_TAB_GROUP_HEADER_CXMENU_UNSAVE_GROUP 11162
#define IDS_TAB_GROUP_HEADER_CXMENU_NEW_TAB_IN_GROUP 11163
#define IDS_TAB_GROUP_HEADER_CXMENU_UNGROUP 11164
#define IDS_TAB_GROUP_HEADER_CXMENU_CLOSE_GROUP 11165
#define IDS_TAB_GROUP_HEADER_CXMENU_DELETE_GROUP 11166
#define IDS_TAB_GROUP_HEADER_CXMENU_MOVE_GROUP_TO_NEW_WINDOW 11167
#define IDS_TAB_GROUP_HEADER_CXMENU_OPEN_GROUP_IN_NEW_WINDOW 11168
#define IDS_TAB_GROUP_HEADER_CXMENU_SEND_FEEDBACK 11169
#define IDS_TAB_GROUP_HEADER_BUBBLE_TITLE_PLACEHOLDER 11170
#define IDS_APP_MENU_RELOAD 11171
#define IDS_APP_MENU_NEW_WEB_PAGE 11172
#define IDS_APP_MENU_COPY_LINK 11173
#define IDS_APP_MENU_CREATE_QR_CODE 11174
#define IDS_APP_MENU_BUTTON_UPDATE 11175
#define IDS_APP_MENU_BUTTON_UPDATE_ALT1 11176
#define IDS_APP_MENU_BUTTON_UPDATE_ALT2 11177
#define IDS_APP_MENU_BUTTON_UPDATE_ALT3 11178
#define IDS_APP_MENU_BUTTON_ERROR 11179
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TITLE 11180
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TEXT 11181
#define IDS_MEDIA_SCREEN_AND_AUDIO_CAPTURE_CONFIRMATION_TEXT 11182
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_TEXT 11183
#define IDS_MEDIA_SCREEN_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 11184
#define IDS_MEDIA_WINDOW_CAPTURE_NOTIFICATION_TEXT 11185
#define IDS_MEDIA_TAB_CAPTURE_NOTIFICATION_TEXT 11186
#define IDS_MEDIA_TAB_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 11187
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_HIDE 11188
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_SOURCE 11189
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_STOP 11190
#define IDS_PLATFORM_KEYS_SELECT_CERT_DIALOG_TEXT 11191
#define IDS_UNSAFE_FRAME_MESSAGE 11192
#define IDS_CLIENT_CERT_DIALOG_TITLE 11193
#define IDS_CLIENT_CERT_DIALOG_TEXT 11194
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TITLE 11195
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_ENROLLMENT 11196
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CLIENT_AUTH 11197
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_LIST_CERTS 11198
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_IMPORT 11199
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_EXPORT 11200
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_PASSWORD_FIELD 11201
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_OK_BUTTON_LABEL 11202
#define IDS_FR_ENABLE_LOGGING 11204
#define IDS_CRASHED_TAB_FEEDBACK_MESSAGE 11208
#define IDS_CRASHED_TAB_FEEDBACK_LINK 11209
#define IDS_KILLED_TAB_FEEDBACK_MESSAGE 11211
#define IDS_HIDE_ICONS_NOT_SUPPORTED 11212
#define IDS_RELAUNCH_BUTTON 11213
#define IDS_HELP_MANAGED_BY_YOUR_PARENT 11214
#define IDS_TOOLBAR_INFORM_SET_HOME_PAGE 11217
#define IDS_MANAGE_EXTENSIONS_SETTING_WINDOWS_TITLE 11218
#define IDS_CONTROLLED_SETTING_POLICY 486
#define IDS_CONTROLLED_SETTING_EXTENSION 11219
#define IDS_CONTROLLED_SETTING_EXTENSION_WITHOUT_NAME 11220
#define IDS_CONTROLLED_SETTING_RECOMMENDED 11221
#define IDS_CONTROLLED_SETTING_HAS_RECOMMENDATION 11222
#define IDS_CONTROLLED_SETTING_CHILD_RESTRICTION 11223
#define IDS_CONTROLLED_SETTING_PARENT 11224
#define IDS_EXTENSIONS_INSTALL_LOCATION_UNKNOWN 11225
#define IDS_EXTENSIONS_INSTALL_LOCATION_3RD_PARTY 11226
#define IDS_EXTENSIONS_INSTALL_LOCATION_ENTERPRISE 11227
#define IDS_EXTENSIONS_INSTALL_LOCATION_SHARED_MODULE 11228
#define IDS_EXTENSIONS_BLOCKLISTED_MALWARE 11229
#define IDS_EXTENSIONS_BLOCKLISTED_SECURITY_VULNERABILITY 11230
#define IDS_EXTENSIONS_BLOCKLISTED_CWS_POLICY_VIOLATION 11231
#define IDS_EXTENSIONS_BLOCKLISTED_POTENTIALLY_UNWANTED 11232
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING 11233
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING_LEARN_MORE 11234
#define IDS_EXTENSIONS_ACCESS_REQUESTS_LEARN_MORE 11235
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION 11236
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION_IN_BULLET_POINTS 11237
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_TITLE 11238
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_EXPLANATION 11239
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_DEFAULT_TOOL_NAME 11240
#define IDS_RESET_PROFILE_SETTINGS_LOCALE 11241
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_URLS 11242
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_TYPE 11243
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE 11244
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE_IS_NTP 11245
#define IDS_RESET_PROFILE_SETTINGS_YES 11246
#define IDS_RESET_PROFILE_SETTINGS_NO 11247
#define IDS_RESET_PROFILE_SETTINGS_SHOW_HOME_BUTTON 11248
#define IDS_RESET_PROFILE_SETTINGS_DSE 11249
#define IDS_RESET_PROFILE_SETTINGS_EXTENSIONS 11250
#define IDS_RESET_PROFILE_SETTINGS_SHORTCUTS 11251
#define IDS_RESET_PROFILE_SETTINGS_PROCESSING_SHORTCUTS 11252
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_MONTH 11254
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_YEAR 11255
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT 11256
#define IDS_OMNIBOX_ICON_SEND_TAB_TO_SELF 447
#define IDS_OMNIBOX_TOOLTIP_SEND_TAB_TO_SELF 448
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_TODAY_SEND_TAB_TO_SELF 11258
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAY_SEND_TAB_TO_SELF 11259
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAYS_SEND_TAB_TO_SELF 11260
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_FROM_DEVICE 11261
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_TITLE 432
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_LABEL 11262
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_A11Y_NAME 431
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_HINT_TEXT 11263
#define IDS_MENU_SEND_TAB_TO_SELF 11264
#define IDS_SEND_TAB_TO_SELF 11265
#define IDS_SEND_TAB_TO_SELF_SENDING_ANNOUNCE 11268
#define IDS_SEND_TAB_TO_SELF_MANAGE_DEVICES_LINK 11269
#define IDS_SEND_TAB_TO_SELF_SIGN_IN_PROMO_LABEL 11270
#define IDS_SEND_TAB_TO_SELF_NO_TARGET_DEVICE_LABEL 11271
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_PAGE 11272
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_IMAGE 11273
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_LINK 11274
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_LABEL 449
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_TOOLTIP 450
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TITLE 11275
#define IDS_SHARING_HUB_GENERATE_QR_CODE_LABEL 11276
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_URL_TEXTFIELD_ACCESSIBLE_NAME 11277
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TOOLTIP 11278
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_DOWNLOAD_BUTTON_LABEL 11279
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_COPY_BUTTON_LABEL 11280
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_TOO_LONG 11281
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_UNKNOWN 11282
#define IDS_SHARING_HUB_TITLE 11283
#define IDS_SHARING_HUB_TOOLTIP 468
#define IDS_SHARING_HUB_SCREENSHOT_LABEL 11284
#define IDS_SHARING_HUB_COPY_LINK_LABEL 11285
#define IDS_SHARING_HUB_SAVE_PAGE_LABEL 11286
#define IDS_SHARING_HUB_MEDIA_ROUTER_LABEL 11287
#define IDS_SHARING_HUB_SHARE_LABEL 11288
#define IDS_SHARING_HUB_FOLLOW_LABEL 11289
#define IDS_SHARING_HUB_FOLLOWING_LABEL 11290
#define IDS_BROWSER_SHARING_SCREENSHOT_POST_CAPTURE_TITLE 11291
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_DOWNLOAD_BUTTON_LABEL 11292
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_EDIT_BUTTON_LABEL 11293
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_SHARE_BUTTON_LABEL 11294
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SELECTION 11295
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CROP 11296
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_TEXT 11297
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ELLIPSE 11298
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_RECTANGLE 11299
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_LINE 11300
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ARROW 11301
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_BRUSH 11302
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_EMOJI 11303
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_HIGHLIGHTER 11304
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_UNDO 11305
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_REDO 11306
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_IN 11307
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_OUT 11308
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_COMMIT_CROP 11309
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_COMMIT_CROP 11310
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_CANCEL_CROP 11311
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CANCEL_CROP 11312
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_DOWNLOAD_IMAGE 11313
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_COPY 11314
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TITLE 11315
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_TEXT_CLEAR 11316
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_LEFT 11317
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_CENTER 11318
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ALIGN_RIGHT 11319
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_NONE 11320
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_SMALL 11321
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SHADOW_LARGE 11322
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_DEFAULT 11323
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_MONOSPACE 11324
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_ITALIC 11325
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_FONT_OUTLINE 11326
#define IDS_CONTEXT_MENU_SHOW_CLIPBOARD_HISTORY_MENU 11327
#define IDS_CONTEXT_MENU_PASTE_FROM_CLIPBOARD 11328
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT_UNKNOWN_DEVICE 11329
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT 11330
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT_UNKNOWN_DEVICE 11331
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT 11332
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_DESCRIPTION 11333
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_MULTIPLE_DEVICES 11334
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_SINGLE_DEVICE 11335
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_MULTIPLE_DEVICES 11336
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_SINGLE_DEVICE 11337
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE_UNKNOWN_DEVICE 11338
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE 11339
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_DESCRIPTION 11340
#define IDS_OMNIBOX_TOOLTIP_SHARED_CLIPBOARD 11341
#define IDS_COLLECTED_COOKIES_DIALOG_TITLE 11342
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_LABEL 11343
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_LABEL 11344
#define IDS_COLLECTED_COOKIES_BLOCKED_THIRD_PARTY_BLOCKING_ENABLED 11345
#define IDS_COLLECTED_COOKIES_ALLOW_BUTTON 11346
#define IDS_COLLECTED_COOKIES_SESSION_ONLY_BUTTON 11347
#define IDS_COLLECTED_COOKIES_BLOCK_BUTTON 11348
#define IDS_COLLECTED_COOKIES_ALLOW_RULE_CREATED 11349
#define IDS_COLLECTED_COOKIES_BLOCK_RULE_CREATED 11350
#define IDS_COLLECTED_COOKIES_SESSION_RULE_CREATED 11351
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_TAB_LABEL 11352
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_TAB_LABEL 11353
#define IDS_COLLECTED_COOKIES_ALLOWED_AUX_TEXT 11354
#define IDS_COLLECTED_COOKIES_BLOCKED_AUX_TEXT 11355
#define IDS_COLLECTED_COOKIES_CLEAR_ON_EXIT_AUX_TEXT 11356
#define IDS_COLLECTED_COOKIES_INFOBAR_MESSAGE 11357
#define IDS_COLLECTED_COOKIES_INFOBAR_BUTTON 11358
#define IDS_COLLECTED_COOKIES_PARTITIONED_COOKIE 11359
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_TITLE 11360
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_TITLE 11361
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_FIRST_PARTY_SUBTITLE 11362
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_TITLE 11363
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_THIRD_PARTY_SUBTITLE 11364
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_EMPTY_STATE_LABEL 11365
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_MENU_ITEM 11366
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOW_THIRD_PARTY_MENU_ITEM 11367
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCK_MENU_ITEM 11368
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_MENU_ITEM 11369
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_ALLOWED_STATE_SUBTITLE 11370
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_BLOCKED_STATE_SUBTITLE 11371
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_SESSION_ONLY_STATE_SUBTITLE 11372
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_STATE_SUBTITLE 11373
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_PARTITIONED_SESSION_ONLY_STATE_SUBTITLE 11374
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_CONTEXT_MENU_TOOLTIP 11375
#define IDS_PAGE_SPECIFIC_SITE_DATA_DIALOG_DELETE_BUTTON_TOOLTIP 11376
#define IDS_ACCNAME_INFOBAR_CONTAINER 476
#define IDS_ACCNAME_INFOBAR 11377
#define IDS_ONE_CLICK_BUBBLE_UNDO 11378
#define IDS_ONE_CLICK_SIGNIN_BUBBLE_MESSAGE 11379
#define IDS_ONE_CLICK_SIGNIN_DIALOG_OK_BUTTON 11380
#define IDS_ONE_CLICK_SIGNIN_DIALOG_UNDO_BUTTON 11381
#define IDS_ONE_CLICK_SIGNIN_DIALOG_ADVANCED 11382
#define IDS_ENTERPRISE_SIGNIN_CANCEL 11383
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_PROFILE 11384
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_WORK_PROFILE 11385
#define IDS_ENTERPRISE_SIGNIN_CONTINUE 11386
#define IDS_ENTERPRISE_SIGNIN_ALERT 11387
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_TITLE 11388
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_DESCRIPTION 11389
#define IDS_MANAGED_WITH_HYPERLINK 11392
#define IDS_MANAGED_BY_WITH_HYPERLINK 11393
#define IDS_PROFILE_MANAGED_BY_WITH_HYPERLINK 11394
#define IDS_BROWSER_MANAGED_AND_PROFILE_MANAGED_BY_WITH_HYPERLINK 11395
#define IDS_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY_WITH_HYPERLINK 11396
#define IDS_BROWSER_AND_PROFILE_SAME_MANAGED_BY_WITH_HYPERLINK 11397
#define IDS_MANAGED_BY_PARENT_WITH_HYPERLINK 11398
#define IDS_COOKIES_REMOVE_LABEL 11399
#define IDS_COOKIES_COOKIE_NAME_LABEL 11400
#define IDS_COOKIES_COOKIE_CONTENT_LABEL 11401
#define IDS_COOKIES_COOKIE_DOMAIN_LABEL 11402
#define IDS_COOKIES_COOKIE_PATH_LABEL 11403
#define IDS_COOKIES_COOKIE_SENDFOR_LABEL 11404
#define IDS_COOKIES_COOKIE_CREATED_LABEL 11405
#define IDS_COOKIES_COOKIE_EXPIRES_LABEL 11406
#define IDS_COOKIES_COOKIE_EXPIRES_SESSION 11407
#define IDS_COOKIES_COOKIE_SENDFOR_ANY 11408
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE 11409
#define IDS_COOKIES_COOKIE_SENDFOR_SAME_SITE 11410
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE_SAME_SITE 11411
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_YES 11412
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_NO 11413
#define IDS_COOKIES_COOKIE_NONESELECTED 11414
#define IDS_COOKIES_COOKIES 11415
#define IDS_COOKIES_WEB_DATABASES 11416
#define IDS_COOKIES_LOCAL_STORAGE 11417
#define IDS_COOKIES_SESSION_STORAGE 11418
#define IDS_COOKIES_INDEXED_DBS 11419
#define IDS_COOKIES_MEDIA_LICENSE 11420
#define IDS_COOKIES_MEDIA_LICENSES 11421
#define IDS_COOKIES_FILE_SYSTEM 11422
#define IDS_COOKIES_FILE_SYSTEMS 11423
#define IDS_COOKIES_FILE_SYSTEM_USAGE_NONE 11424
#define IDS_COOKIES_SERVICE_WORKER 11425
#define IDS_COOKIES_SERVICE_WORKERS 11426
#define IDS_COOKIES_SHARED_WORKERS 11427
#define IDS_COOKIES_CACHE_STORAGE 11428
#define IDS_CLIENT_CERT_ECDSA_SIGN 11429
#define IDS_APP_DEFAULT_PAGE_NAME 11430
#define IDS_APP_LAUNCHER_TAB_TITLE 11431
#define IDS_NEW_TAB_GUEST_SESSION_HEADING 11432
#define IDS_NEW_TAB_GUEST_SESSION_DESCRIPTION 11433
#define IDS_NEW_TAB_GUEST_SESSION_LEARN_MORE_ACCESSIBILITY_TEXT 11434
#define IDS_NEW_TAB_TILE_GRID_ACCESSIBLE_DESCRIPTION 11435
#define IDS_NEW_TAB_APP_INSTALL_HINT_LABEL 11436
#define IDS_NEW_TAB_MOST_VISITED 11437
#define IDS_NEW_TAB_RESTORE_THUMBNAILS_SHORT_LINK 501
#define IDS_NEW_TAB_ATTRIBUTION_INTRO 568
#define IDS_NEW_TAB_THUMBNAIL_REMOVED_NOTIFICATION 11438
#define IDS_NEW_TAB_REMOVE_THUMBNAIL_TOOLTIP 11439
#define IDS_NEW_TAB_PAGE_SWITCHER_CHANGE_TITLE 11440
#define IDS_NEW_TAB_PAGE_SWITCHER_SAME_TITLE 11441
#define IDS_NEW_TAB_VOICE_AUDIO_ERROR 528
#define IDS_NEW_TAB_VOICE_CLOSE_TOOLTIP 529
#define IDS_NEW_TAB_VOICE_DETAILS 530
#define IDS_NEW_TAB_VOICE_LANGUAGE_ERROR 531
#define IDS_NEW_TAB_VOICE_LISTENING 533
#define IDS_NEW_TAB_VOICE_NETWORK_ERROR 534
#define IDS_NEW_TAB_VOICE_NO_TRANSLATION 535
#define IDS_NEW_TAB_VOICE_NO_VOICE 536
#define IDS_NEW_TAB_VOICE_OTHER_ERROR 537
#define IDS_NEW_TAB_VOICE_PERMISSION_ERROR 538
#define IDS_NEW_TAB_VOICE_LEARN_MORE_ACCESSIBILITY_LABEL 532
#define IDS_NEW_TAB_VOICE_READY 539
#define IDS_NEW_TAB_VOICE_TRY_AGAIN 540
#define IDS_NEW_TAB_VOICE_WAITING 542
#define IDS_NEW_TAB_VOICE_SEARCH_CLOSED 11442
#define IDS_NEW_TAB_APP_OPTIONS 11443
#define IDS_NEW_TAB_APP_DETAILS 11444
#define IDS_NEW_TAB_APP_CREATE_SHORTCUT 11445
#define IDS_NEW_TAB_APP_INSTALL_LOCALLY 11446
#define IDS_APP_CONTEXT_MENU_SHOW_INFO 11447
#define IDS_APP_CONTEXT_MENU_OPEN_PINNED 11448
#define IDS_APP_CONTEXT_MENU_OPEN_REGULAR 11449
#define IDS_APP_CONTEXT_MENU_OPEN_WINDOW 11450
#define IDS_APP_CONTEXT_MENU_OPEN_FULLSCREEN 11451
#define IDS_APP_CONTEXT_MENU_OPEN_MAXIMIZED 11452
#define IDS_APP_CONTEXT_MENU_OPEN_TAB 11453
#define IDS_APP_CONTEXT_MENU_RUN_ON_OS_LOGIN 11458
#define IDS_APPS_PAGE_DEPRECATED_APP_TITLE 11461
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_TITLE 11462
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_PROCEED_BUTTON 11463
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_CANCEL_BUTTON 11464
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_BODY_TEXT 11465
#define IDS_DEVICE_SIGNALS_CONSENT_DIALOG_DEFAULT_BODY_TEXT 11466
#define IDS_SYNC_CONFIRMATION_SETTINGS_INFO 11467
#define IDS_SYNC_CONFIRMATION_CONFIRM_BUTTON_LABEL 11468
#define IDS_SYNC_CONFIRMATION_SETTINGS_BUTTON_LABEL 11469
#define IDS_SYNC_CONFIRMATION_REFRESHED_SETTINGS_BUTTON_LABEL 11470
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_TITLE 11471
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE 11472
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_TITLE_SIGNIN_INTERCEPT_V2 11474
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_BOOKMARKS 11475
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_READING_LIST 11476
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_AUTOFILL 11477
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_EXTENSIONS 11478
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_HISTORY_AND_MORE 11479
#define IDS_SYNC_CONFIRMATION_TANGIBLE_SYNC_INFO_DESC 11480
#define IDS_SYNC_CONFIRMATION_WELCOME_TITLE_SIGNIN_INTERCEPT 11482
#define IDS_SYNC_CONFIRMATION_TURN_ON_SYNC_BUTTON_LABEL 11483
#define IDS_SYNC_DISABLED_CONFIRMATION_CHROME_SYNC_TITLE 11484
#define IDS_SYNC_DISABLED_CONFIRMATION_DETAILS 11485
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_LABEL 11486
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_MANAGED_ACCOUNT_SIGNOUT_DISALLOWED_LABEL 11487
#define IDS_SYNC_DISABLED_CONFIRMATION_UNDO_BUTTON_LABEL 11488
#define IDS_SYNC_LOADING_CONFIRMATION_TITLE 11489
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL 11490
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL_V2 11491
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_BUTTON_LABEL 11492
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_SWITCH_BUTTON_LABEL 11493
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CONFIRM_SWITCH_BUTTON_LABEL 11494
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CONFIRM_SWITCH_BUTTON_LABEL_V2 11495
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_GUEST_LINK 11496
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC 11497
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_BY_TOKEN 11498
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2 11499
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE_V2 11500
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_DISCLAIMER 11501
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_BY_DISCLAIMER 11502
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_PROFILE_NAME 11503
#define IDS_SIGNIN_ERROR_TITLE 11504
#define IDS_SIGNIN_ERROR_EMAIL_TITLE 11505
#define IDS_SIGNIN_ERROR_DICE_EMAIL_TITLE 11506
#define IDS_SIGNIN_ERROR_CLOSE_BUTTON_LABEL 11507
#define IDS_SIGNIN_ERROR_OK_BUTTON_LABEL 11508
#define IDS_SIGNIN_ERROR_SWITCH_BUTTON_LABEL 11509
#define IDS_SIGNIN_ACCESSIBLE_CLOSE_BUTTON 11510
#define IDS_SIGNIN_ACCESSIBLE_BACK_BUTTON 11511
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_TITLE 11512
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_SUBTITLE 11513
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_TITLE 11514
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_SUBTITLE 11515
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CLOSE_BUTTON_LABEL 11516
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CONFIRM_BUTTON_LABEL 11517
#define IDS_ACCOUNT_PASSWORDS_REAUTH_TITLE 11518
#define IDS_ACCOUNT_PASSWORDS_REAUTH_DESC 11519
#define IDS_ACCOUNT_PASSWORDS_REAUTH_DESC_ALREADY_SAVED_LOCALLY 11520
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CONFIRM_BUTTON_LABEL 11521
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CLOSE_BUTTON_LABEL 11522
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CLOSE_BUTTON_LABEL_ALREADY_SAVED_LOCALLY 11523
#define IDS_PLUGIN_CRASHED_PROMPT 11524
#define IDS_PLUGIN_DISCONNECTED_PROMPT 11525
#define IDS_RELOAD_PAGE_WITH_PLUGIN 11526
#define IDS_PLUGIN_INITIALIZATION_ERROR_PROMPT 11527
#define IDS_EXTERNAL_PROTOCOL_TITLE 11528
#define IDS_EXTERNAL_PROTOCOL_MESSAGE_WITH_INITIATING_ORIGIN 11529
#define IDS_EXTERNAL_PROTOCOL_MESSAGE 11530
#define IDS_EXTERNAL_PROTOCOL_OK_BUTTON_TEXT 11531
#define IDS_EXTERNAL_PROTOCOL_CANCEL_BUTTON_TEXT 11532
#define IDS_EXTERNAL_PROTOCOL_CHECKBOX_PER_ORIGIN_TEXT 11533
#define IDS_DIRECTORY_LISTING_HEADER 11535
#define IDS_DIRECTORY_LISTING_PARENT 11536
#define IDS_DIRECTORY_LISTING_NAME 11537
#define IDS_DIRECTORY_LISTING_SIZE 11538
#define IDS_DIRECTORY_LISTING_DATE_MODIFIED 11539
#define IDS_SAVE_PAGE_DESC_HTML_ONLY 11540
#define IDS_SAVE_PAGE_DESC_SINGLE_FILE 11541
#define IDS_SAVE_PAGE_DESC_COMPLETE 11542
#define IDS_PROFILE_ERROR_DIALOG_TITLE 11543
#define IDS_COULDNT_OPEN_PROFILE_ERROR 11544
#define IDS_OPEN_PROFILE_DATA_LOSS 11545
#define IDS_PROFILE_ERROR_DIALOG_CHECKBOX 11546
#define IDS_PROFILE_ERROR_FEEDBACK_DESCRIPTION 11547
#define IDS_COULDNT_STARTUP_PROFILE_ERROR 11548
#define IDS_REFUSE_TO_RUN_AS_ROOT 11549
#define IDS_REFUSE_TO_RUN_AS_ROOT_2 11550
#define IDS_PROFILE_ON_NETWORK_WARNING 11551
#define IDS_CANT_WRITE_USER_DIRECTORY_TITLE 11552
#define IDS_RECENT_TABS_MENU 11553
#define IDS_RECENTLY_CLOSED_WINDOW 11554
#define IDS_RECENTLY_CLOSED_GROUP 11555
#define IDS_RECENTLY_CLOSED_GROUP_UNNAMED 11556
#define IDS_RECENT_TABS_NO_DEVICE_TABS 11557
#define IDS_RECENT_TABS_LOGIN_FOR_DEVICE_TABS 11558
#define IDS_HISTORY_MENU 11559
#define IDS_DEFAULT_DOWNLOAD_FILENAME 11560
#define IDS_DEFAULT_BROWSER_INFOBAR_OK_BUTTON_LABEL 11562
#define IDS_USED_EXISTING_BROWSER 11568
#define IDS_DECLINE_RECOVERY 11569
#define IDS_SYNC_ACCOUNT_SYNCING 11570
#define IDS_SYNC_ACCOUNT_SYNCING_CUSTOM_DATA_TYPES 11571
#define IDS_SIGNIN_ERROR_DISPLAY_SOURCE 11572
#define IDS_SIGNIN_ERROR_BUBBLE_VIEW_TITLE 11573
#define IDS_SYNC_ERROR_BUBBLE_VIEW_TITLE 11574
#define IDS_SYNC_ERROR_PASSWORDS_BUBBLE_VIEW_TITLE 11575
#define IDS_SYNC_ERROR_USER_MENU_TITLE 11576
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE 11577
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE_SIGNED_IN_ONLY 11578
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_EVERYTHING_USER_MENU_TITLE 11579
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_MENU_TITLE 11580
#define IDS_SYNC_ERROR_USER_MENU_SIGNIN_BUTTON 11581
#define IDS_SYNC_NEEDS_VERIFICATION_BUBBLE_VIEW_TITLE 11582
#define IDS_SYNC_ERROR_USER_MENU_PASSPHRASE_BUTTON 11583
#define IDS_SYNC_ERROR_USER_MENU_RECOVERABILITY_BUTTON 11584
#define IDS_SYNC_ERROR_USER_MENU_RETRIEVE_KEYS_BUTTON 11585
#define IDS_SYNC_ERROR_USER_MENU_SIGNOUT_BUTTON 11586
#define IDS_SYNC_ERROR_USER_MENU_CONFIRM_SYNC_SETTINGS_BUTTON 11587
#define IDS_SYNC_OVERVIEW 11593
#define IDS_SYNC_START_SYNC_BUTTON_LABEL 11594
#define IDS_SIGNED_IN_WITH_SYNC_DISABLED_BY_POLICY 11595
#define IDS_SYNC_SETTINGS_NOT_CONFIRMED 11597
#define IDS_SYNC_SETUP_IN_PROGRESS 11598
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR 11599
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR_NEEDS_SIGNOUT 11600
#define IDS_SYNC_STATUS_NEEDS_PASSWORD 11601
#define IDS_SYNC_STATUS_NEEDS_PASSWORD_BUTTON 11602
#define IDS_SYNC_STATUS_NEEDS_KEYS_BUTTON 11603
#define IDS_SYNC_RELOGIN_ERROR 11604
#define IDS_SYNC_RELOGIN_BUTTON 11605
#define IDS_SYNC_ADVANCED_OPTIONS 11610
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM 11612
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM_WITH_DATE 11613
#define IDS_PARTIAL_TRANSLATE_BUBBLE_WAITING_TITLE 11614
#define IDS_TRANSLATE_BUBBLE_BEFORE_TRANSLATE_TITLE 11615
#define IDS_TRANSLATE_BUBBLE_TRANSLATED_TITLE 11616
#define IDS_PARTIAL_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 11617
#define IDS_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 11618
#define IDS_TRANSLATE_BUBBLE_SOURCE_LANG_COMBOBOX_ACCNAME 11619
#define IDS_TRANSLATE_BUBBLE_TARGET_LANG_COMBOBOX_ACCNAME 11620
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_COMPLETE_ANNOUNCEMENT 11621
#define IDS_TRANSLATE_BUBBLE_ADVANCED_BUTTON 11622
#define IDS_TRANSLATE_BUBBLE_ADVANCED_MENU_BUTTON 11623
#define IDS_TRANSLATE_BUBBLE_CHANGE_TARGET_LANGUAGE 11624
#define IDS_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 11625
#define IDS_PARTIAL_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 11626
#define IDS_TRANSLATE_BUBBLE_ACCEPT 11627
#define IDS_TRANSLATE_BUBBLE_DENY 11628
#define IDS_TRANSLATE_BUBBLE_ALWAYS_TRANSLATE_LANG 11629
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_LANG 11630
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_SITE 11631
#define IDS_TRANSLATE_BUBBLE_TRANSLATING 11632
#define IDS_TRANSLATE_BUBBLE_REVERT 11633
#define IDS_TRANSLATE_BUBBLE_TRY_AGAIN 11634
#define IDS_TRANSLATE_BUBBLE_ALWAYS 11635
#define IDS_TRANSLATE_BUBBLE_OPTIONS_MENU_BUTTON 11636
#define IDS_TRANSLATE_BUBBLE_PAGE_LANGUAGE 11637
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_LANGUAGE 11638
#define IDS_TRANSLATE_BUBBLE_ADVANCED_TARGET 11639
#define IDS_TRANSLATE_BUBBLE_ADVANCED_SOURCE 11640
#define IDS_PARTIAL_TRANSLATE_BUBBLE_ADVANCED_SOURCE 11641
#define IDS_PARTIAL_TRANSLATE_BUBBLE_TRANSLATE_FULL_PAGE 11642
#define IDS_TRANSLATE_BUBBLE_RESET 11643
#define IDS_NOTIFICATION_BUTTON_SETTINGS 11644
#define IDS_NOTIFICATION_BUTTON_CLOSE 11645
#define IDS_NOTIFICATION_BUTTON_MORE 11646
#define IDS_NOTIFICATION_REPLY_PLACEHOLDER 11647
#define IDS_NOTIFICATION_MUTED_MESSAGE 11648
#define IDS_NOTIFICATION_MUTED_TITLE 11649
#define IDS_NOTIFICATION_MUTED_ACTION_SHOW 11650
#define IDS_NOTIFICATION_MUTED_ACTION_SNOOZE 11651
#define IDS_ALLOWED_GEOLOCATION_TITLE 11790
#define IDS_BLOCKED_GEOLOCATION_TITLE 11791
#define IDS_ALLOWED_GEOLOCATION_MESSAGE 11792
#define IDS_ALLOWED_GEOLOCATION_BLOCK 11793
#define IDS_ALLOWED_GEOLOCATION_NO_ACTION 11794
#define IDS_BLOCKED_GEOLOCATION_MESSAGE 11795
#define IDS_BLOCKED_GEOLOCATION_UNBLOCK 11796
#define IDS_BLOCKED_GEOLOCATION_NO_ACTION 11797
#define IDS_GEOLOCATION 11798
#define IDS_GEOLOCATION_WILL_ASK_AGAIN 11799
#define IDS_GEOLOCATION_TURNED_OFF 11802
#define IDS_ALLOWED_MIDI_SYSEX_TITLE 11803
#define IDS_BLOCKED_MIDI_SYSEX_TITLE 11804
#define IDS_ALLOWED_MIDI_SYSEX_MESSAGE 11805
#define IDS_ALLOWED_MIDI_SYSEX_BLOCK 11806
#define IDS_ALLOWED_MIDI_SYSEX_NO_ACTION 11807
#define IDS_BLOCKED_MIDI_SYSEX_MESSAGE 11808
#define IDS_BLOCKED_MIDI_SYSEX_UNBLOCK 11809
#define IDS_BLOCKED_MIDI_SYSEX_NO_ACTION 11810
#define IDS_MICROPHONE_CAMERA_ALLOWED 11811
#define IDS_MICROPHONE_CAMERA_BLOCKED 11812
#define IDS_MICROPHONE_ACCESSED 11813
#define IDS_CAMERA_ACCESSED 11814
#define IDS_MICROPHONE_BLOCKED 11815
#define IDS_CAMERA_BLOCKED 11816
#define IDS_MICROPHONE_CAMERA_ALLOWED_TITLE 11817
#define IDS_MICROPHONE_CAMERA_BLOCKED_TITLE 11818
#define IDS_MICROPHONE_ACCESSED_TITLE 11819
#define IDS_CAMERA_ACCESSED_TITLE 11820
#define IDS_MICROPHONE_BLOCKED_TITLE 11821
#define IDS_CAMERA_BLOCKED_TITLE 11822
#define IDS_MEDIASTREAM_SETTING_CHANGED_MESSAGE 11823
#define IDS_A11Y_OMNIBOX_CHIP_HINT 443
#define IDS_MANAGE_PASSWORDS_CONFIRM_GENERATED_TEXT 11833
#define IDS_PASSWORDS_WEB_LINK 11834
#define IDS_MANAGE_PASSWORDS_LINK 11836
#define IDS_MANAGE_PASSWORDS_TITLE 11837
#define IDS_MANAGE_PASSWORDS_NO_PASSWORDS_TITLE 11838
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_TITLE 11839
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_NO_PASSWORDS_TITLE 11840
#define IDS_MANAGE_PASSWORDS_ACCOUNT_STORE_ICON_DESCRIPTION 11841
#define IDS_MANAGE_PASSWORDS_DELETED 11842
#define IDS_MANAGE_PASSWORDS_UNDO 11843
#define IDS_MANAGE_PASSWORDS_UNDO_TOOLTIP 11844
#define IDS_MANAGE_PASSWORDS_DELETE 11845
#define IDS_MANAGE_PASSWORDS_SHOW_PASSWORD 11846
#define IDS_MANAGE_PASSWORDS_HIDE_PASSWORD 11847
#define IDS_MANAGE_PASSWORDS_EMPTY_NOTE 11848
#define IDS_MANAGE_PASSWORDS_EDIT_USERNAME_TOOLTIP 11849
#define IDS_MANAGE_PASSWORDS_EDIT_NOTE_TOOLTIP 11850
#define IDS_MANAGE_PASSWORDS_NOTE_ACCESSIBLE_NAME 11851
#define IDS_MANAGE_PASSWORDS_NOTE_TEXTFIELD 11852
#define IDS_MANAGE_PASSWORDS_UPDATE 11853
#define IDS_MANAGE_PASSWORDS_USERNAME_ACCESSIBLE_NAME 11854
#define IDS_MANAGE_PASSWORDS_USERNAME_TEXTFIELD 11855
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE_MD 11856
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_MANY_DEVICES 11857
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_LOCAL_DEVICE 11858
#define IDS_AUTO_SIGNIN_FIRST_RUN_TEXT 11859
#define IDS_AUTO_SIGNIN_FIRST_RUN_OK 11860
#define IDS_FILE_SELECTION_DIALOG_INFOBAR 11869
#define IDS_IMAGE_FILES 11872
#define IDS_AUDIO_FILES 11873
#define IDS_VIDEO_FILES 11874
#define IDS_CUSTOM_FILES 11875
#define IDS_FULLSCREEN_USER_ENTERED_FULLSCREEN 11876
#define IDS_FULLSCREEN_EXTENSION_TRIGGERED_FULLSCREEN 11877
#define IDS_FULLSCREEN_UNKNOWN_EXTENSION_TRIGGERED_FULLSCREEN 11878
#define IDS_FULLSCREEN_SITE_ENTERED_FULLSCREEN 11879
#define IDS_FULLSCREEN_ENTERED_FULLSCREEN 11880
#define IDS_FULLSCREEN_SITE_ENTERED_FULLSCREEN_MOUSELOCK 11881
#define IDS_FULLSCREEN_ENTERED_FULLSCREEN_MOUSELOCK 11882
#define IDS_FULLSCREEN_SITE_ENTERED_MOUSELOCK 11883
#define IDS_FULLSCREEN_ENTERED_MOUSELOCK 11884
#define IDS_FULLSCREEN_PRESS_ESC_TO_EXIT_MOUSELOCK 11885
#define IDS_SENSORS_ALLOWED_TOOLTIP 11886
#define IDS_MOTION_SENSORS_ALLOWED_TOOLTIP 11887
#define IDS_SENSORS_BLOCKED_TOOLTIP 11888
#define IDS_MOTION_SENSORS_BLOCKED_TOOLTIP 11889
#define IDS_BLOCKED_SENSORS_UNBLOCK 11890
#define IDS_BLOCKED_SENSORS_NO_ACTION 11891
#define IDS_ALLOWED_SENSORS_TITLE 11892
#define IDS_BLOCKED_SENSORS_TITLE 11893
#define IDS_ALLOWED_SENSORS_MESSAGE 11894
#define IDS_ALLOWED_MOTION_SENSORS_MESSAGE 11895
#define IDS_BLOCKED_SENSORS_MESSAGE 11896
#define IDS_BLOCKED_MOTION_SENSORS_MESSAGE 11897
#define IDS_ALLOWED_SENSORS_NO_ACTION 11898
#define IDS_ALLOWED_SENSORS_BLOCK 11899
#define IDS_LIVE_CAPTION_PROMO 11906
#define IDS_LIVE_CAPTION_PROMO_SCREENREADER 11907
#define IDS_ENABLE_CARET_BROWSING_INFO 11908
#define IDS_CARET_BROWSING_DO_NOT_ASK 11909
#define IDS_ENABLE_CARET_BROWSING_TITLE 11910
#define IDS_ENABLE_CARET_BROWSING_TURN_ON 11911
#define IDS_MEDIA_GALLERIES_DIALOG_HEADER 11912
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_WRITE 11913
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_DELETE 11914
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_ONLY 11915
#define IDS_MEDIA_GALLERIES_PERMISSION_SUGGESTIONS 11916
#define IDS_MEDIA_GALLERIES_LAST_ATTACHED 11917
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY 11918
#define IDS_MEDIA_GALLERIES_DIALOG_CONFIRM 11919
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY_TITLE 11920
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_ATTACHED 11921
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_NOT_ATTACHED 11922
#define IDS_MEDIA_GALLERIES_DIALOG_DELETE 11923
#define IDS_CHROME_SHORTCUT_DESCRIPTION 11944
#define IDS_WEBSTORE_NAME_STORE 378
#define IDS_DESKTOP_MEDIA_PICKER_TITLE 11945
#define IDS_DISPLAY_MEDIA_PICKER_TITLE 11946
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_SCREEN_ONLY 11947
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WINDOW_ONLY 11948
#define IDS_DESKTOP_MEDIA_PICKER_TEXT 11949
#define IDS_DISPLAY_MEDIA_PICKER_TEXT 11950
#define IDS_DESKTOP_MEDIA_PICKER_TEXT_DELEGATED 11951
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_SCREEN 11952
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_WINDOW 11953
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_TAB 11954
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_SCREEN_WITH_MUTE_WARNING 11955
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_SYSTEM_AUDIO 11956
#define IDS_DESKTOP_MEDIA_PICKER_ALSO_SHARE_TAB_AUDIO 11957
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB 11958
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_HINT_TAB_OR_SCREEN 11959
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_SCREEN 11960
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_WINDOW 11961
#define IDS_DESKTOP_MEDIA_PICKER_SINGLE_SCREEN_NAME 11962
#define IDS_DESKTOP_MEDIA_PICKER_MULTIPLE_SCREEN_NAME 11963
#define IDS_DESKTOP_MEDIA_PICKER_MANAGED 11964
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_SCREEN 11965
#define IDS_DESKTOP_MEDIA_PICKER_RESELECT_WINDOW 11966
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_THIS_TAB 11967
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_OTHER_TAB 11968
#define IDS_DESKTOP_MEDIA_PICKER_EMPTY_PREVIEW 11969
#define IDS_DESKTOP_MEDIA_PICKER_PREVIEW_ACCESSIBLE_NAME 11970
#define IDS_DESKTOP_MEDIA_SOURCE_EMPTY_ACCESSIBLE_NAME 11971
#define IDS_SHARE_THIS_TAB_DIALOG_TITLE 11972
#define IDS_SHARE_THIS_TAB_DIALOG_TEXT 11973
#define IDS_SHARE_THIS_TAB_DIALOG_ALLOW 11974
#define IDS_SHARE_THIS_TAB_AUDIO_SHARE 11975
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TITLE 11976
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TEXT 11977
#define IDS_TOOLTIP_TAB_ALERT_STATE_MEDIA_RECORDING 11978
#define IDS_TOOLTIP_TAB_ALERT_STATE_TAB_CAPTURING 11979
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_PLAYING 11980
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_MUTING 11981
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_CONNECTED 11982
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_SCAN_ACTIVE 11983
#define IDS_TOOLTIP_TAB_ALERT_STATE_USB_CONNECTED 11984
#define IDS_TOOLTIP_TAB_ALERT_STATE_HID_CONNECTED 11985
#define IDS_TOOLTIP_TAB_ALERT_STATE_SERIAL_CONNECTED 11986
#define IDS_TOOLTIP_TAB_ALERT_STATE_PIP_PLAYING 11987
#define IDS_TOOLTIP_TAB_ALERT_STATE_DESKTOP_CAPTURING 11988
#define IDS_TOOLTIP_TAB_ALERT_STATE_VR_PRESENTING 11989
#define IDS_TAB_AX_LABEL_MEDIA_RECORDING_FORMAT 11990
#define IDS_TAB_AX_LABEL_TAB_CAPTURING_FORMAT 11991
#define IDS_TAB_AX_LABEL_PIP_PLAYING_FORMAT 11992
#define IDS_TAB_AX_LABEL_AUDIO_PLAYING_FORMAT 11993
#define IDS_TAB_AX_LABEL_AUDIO_MUTING_FORMAT 11994
#define IDS_TAB_AX_LABEL_BLUETOOTH_CONNECTED_FORMAT 11995
#define IDS_TAB_AX_LABEL_BLUETOOTH_SCAN_ACTIVE_FORMAT 11996
#define IDS_TAB_AX_LABEL_USB_CONNECTED_FORMAT 11997
#define IDS_TAB_AX_LABEL_HID_CONNECTED_FORMAT 11998
#define IDS_TAB_AX_LABEL_SERIAL_CONNECTED_FORMAT 11999
#define IDS_TAB_AX_LABEL_NETWORK_ERROR_FORMAT 12000
#define IDS_TAB_AX_LABEL_CRASHED_FORMAT 12001
#define IDS_TAB_AX_LABEL_DESKTOP_CAPTURING_FORMAT 12002
#define IDS_TAB_AX_LABEL_VR_PRESENTING 12003
#define IDS_TAB_AX_LABEL_UNNAMED_GROUP_FORMAT 12004
#define IDS_TAB_AX_LABEL_NAMED_GROUP_FORMAT 12005
#define IDS_TAB_AX_LABEL_PINNED_FORMAT 12006
#define IDS_TAB_AX_LABEL_PERMISSION_REQUESTED_FORMAT 12007
#define IDS_GROUP_AX_LABEL_UNNAMED_GROUP_FORMAT 12008
#define IDS_GROUP_AX_LABEL_NAMED_GROUP_FORMAT 12009
#define IDS_GROUP_AX_LABEL_COLLAPSED 12010
#define IDS_GROUP_AX_LABEL_EXPANDED 12011
#define IDS_GROUP_AX_LABEL_UNNAMED_SAVED_GROUP_FORMAT 12012
#define IDS_GROUP_AX_LABEL_NAMED_SAVED_GROUP_FORMAT 12013
#define IDS_SAVED_GROUP_AX_LABEL_OPENED 12014
#define IDS_SAVED_GROUP_AX_LABEL_CLOSED 12015
#define IDS_TAB_AX_ANNOUNCE_MOVED_RIGHT 12016
#define IDS_TAB_AX_ANNOUNCE_MOVED_LEFT 12017
#define IDS_TAB_AX_ANNOUNCE_MOVED_FIRST 12018
#define IDS_TAB_AX_ANNOUNCE_MOVED_LAST 12019
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_UNNAMED_GROUP 12020
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_NAMED_GROUP 12021
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_UNNAMED_GROUP 12022
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_NAMED_GROUP 12023
#define IDS_PAGE_LOADING_AX_TITLE_FORMAT 12024
#define IDS_TAB_AX_INACTIVE_TAB 12025
#define IDS_TAB_AX_MEMORY_SAVINGS 12026
#define IDS_TAB_AX_MEMORY_USAGE 12027
#define IDS_TAB_AX_HIGH_MEMORY_USAGE 12028
#define IDS_PROFILE_IN_USE_LINUX_QUIT 12029
#define IDS_PROFILE_IN_USE_LINUX_RELAUNCH 12030
#define IDS_DESKTOP_MEDIA_PICKER_SHARE 12042
#define IDS_PUSH_MESSAGING_GENERIC_NOTIFICATION_BODY 12043
#define IDS_DEVICE_PERMISSIONS_DIALOG_SELECT 12044
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL 12045
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL_TOOLTIP 12046
#define IDS_DEVICE_LOG_TITLE 12047
#define IDS_DEVICE_AUTO_REFRESH 12048
#define IDS_DEVICE_LOG_REFRESH 12049
#define IDS_DEVICE_LOG_CLEAR 12050
#define IDS_DEVICE_LOG_CLEAR_TYPES 12051
#define IDS_DEVICE_LOG_NO_ENTRIES 12052
#define IDS_DEVICE_LOG_LEVEL_LABEL 12053
#define IDS_DEVICE_LOG_LEVEL_ERROR 12054
#define IDS_DEVICE_LOG_LEVEL_USER 12055
#define IDS_DEVICE_LOG_LEVEL_EVENT 12056
#define IDS_DEVICE_LOG_LEVEL_DEBUG 12057
#define IDS_DEVICE_LOG_TYPE_LOGIN 12058
#define IDS_DEVICE_LOG_TYPE_NETWORK 12059
#define IDS_DEVICE_LOG_TYPE_POWER 12060
#define IDS_DEVICE_LOG_TYPE_BLUETOOTH 12061
#define IDS_DEVICE_LOG_TYPE_USB 12062
#define IDS_DEVICE_LOG_TYPE_HID 12063
#define IDS_DEVICE_LOG_TYPE_PRINTER 12064
#define IDS_DEVICE_LOG_TYPE_FIDO 12065
#define IDS_DEVICE_LOG_TYPE_SERIAL 12066
#define IDS_DEVICE_LOG_TYPE_CAMERA 12067
#define IDS_DEVICE_LOG_TYPE_GEOLOCATION 12068
#define IDS_DEVICE_LOG_TYPE_EXTENSIONS 12069
#define IDS_DEVICE_LOG_TYPE_DISPLAY 12070
#define IDS_DEVICE_LOG_FILEINFO 12071
#define IDS_DEVICE_LOG_TIME_DETAIL 12072
#define IDS_DEVICE_LOG_ENTRY 12073
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION 12075
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION_TITLE 12076
#define IDS_WEBHID_SYSTEM_TRAY_ICON_HID_SETTINGS 12077
#define IDS_WEBHID_SYSTEM_TRAY_ICON_ABOUT_HID_DEVICE 12078
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_USB_SETTINGS 12079
#define IDS_WEBUSB_SYSTEM_TRAY_ICON_ABOUT_USB_DEVICE 12080
#define IDS_DEVICE_CONNECTED_BY_EXTENSION 12083
#define IDS_DEFAULT_AUDIO_DEVICE_NAME 12092
#define IDS_COMMUNICATIONS_AUDIO_DEVICE_NAME 12093
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ADAPTER_OFF 12094
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 12095
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 12096
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN 12097
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN_TOOLTIP 12098
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_SCANNING_STATUS 12099
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_RE_SCAN_LINK 12100
#define IDS_DEVICE_CHOOSER_PAIRED_STATUS_TEXT 12101
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_AND_PAIRED_STATUS_TEXT 12102
#define IDS_DEVICE_CHOOSER_ACCNAME_COMPATIBLE_DEVICES_LIST 12103
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_NAME 12104
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_ID_AND_PRODUCT_ID 12105
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_NAME 12106
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_ID 12107
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_ID 12108
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_NAME 12109
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_ANY_VENDOR 12110
#define IDS_SERIAL_PORT_CHOOSER_PROMPT 12111
#define IDS_SERIAL_PORT_CHOOSER_NAME_WITH_PATH 12112
#define IDS_SERIAL_PORT_CHOOSER_PATH_ONLY 12113
#define IDS_SERIAL_PORT_CHOOSER_CONNECT_BUTTON_TEXT 12114
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL 12115
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL_TOOLTIP 12116
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_NAME 12117
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_ID 12118
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_ID 12119
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_NAME 12120
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_ANY_PORT 12121
#define IDS_HID_CHOOSER_PROMPT 12122
#define IDS_HID_CHOOSER_ITEM_WITHOUT_NAME 12123
#define IDS_HID_CHOOSER_LOADING_LABEL 12124
#define IDS_HID_CHOOSER_LOADING_LABEL_TOOLTIP 12125
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID_AND_PRODUCT_ID 12126
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID 12127
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_AND_USAGE_PAGE 12128
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_PAGE 12129
#define IDS_HID_POLICY_DESCRIPTION_FOR_ANY_DEVICE 12130
#define IDS_WEB_APP_FILE_HANDLING_LIST_SEPARATOR 12131
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION 12132
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION_MULTIPLE 12133
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_STICKY_CHOICE 12134
#define IDS_WEB_APP_FILE_HANDLING_POSITIVE_BUTTON 12135
#define IDS_WEB_APP_FILE_HANDLING_NEGATIVE_BUTTON 12136
#define IDS_WEB_APP_PERMISSION_NEGATIVE_BUTTON 12137
#define IDS_PROTOCOL_HANDLER_INTENT_PICKER_QUESTION 12138
#define IDS_FONT_ACCESS_CHOOSER_PROMPT_ORIGIN 12139
#define IDS_FONT_ACCESS_CHOOSER_NO_FONTS_FOUND_PROMPT 12140
#define IDS_FONT_ACCESS_CHOOSER_IMPORT_BUTTON_TEXT 12141
#define IDS_FONT_ACCESS_CHOOSER_CANCEL_BUTTON_TEXT 12142
#define IDS_FONT_ACCESS_CHOOSER_SELECT_ALL_CHECKBOX_TEXT 12143
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL 12144
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL_TOOLTIP 12145
#define IDS_IME_API_ACTIVATED_WARNING 12146
#define IDS_IME_API_NEVER_SHOW 12147
#define IDS_BLOCKED_ADS_PROMPT_TOOLTIP 12148
#define IDS_UTILITY_PROCESS_UTILITY_WIN_NAME 12149
#define IDS_UTILITY_PROCESS_QUARANTINE_SERVICE_NAME 12150
#define IDS_REDIRECT_BLOCKED_MESSAGE 12151
#define IDS_REDIRECT_BLOCKED_TITLE 12152
#define IDS_REDIRECT_BLOCKED_TOOLTIP 12153
#define IDS_ALWAYS_ALLOW_REDIRECTS 12154
#define IDS_OPEN_REDIRECT 12155
#define IDS_UTILITY_PROCESS_SYSTEM_SIGNALS_NAME 12156
#define IDS_WIN10_TOAST_BROWSE_FAST 12157
#define IDS_WIN10_TOAST_BROWSE_SAFELY 12158
#define IDS_WIN10_TOAST_BROWSE_SMART 12159
#define IDS_WIN10_TOAST_SWITCH_FAST 12160
#define IDS_WIN10_TOAST_SWITCH_SMART 12161
#define IDS_WIN10_TOAST_SWITCH_SECURE 12162
#define IDS_WIN10_TOAST_SWITCH_SMART_AND_SECURE 12163
#define IDS_WIN10_TOAST_RECOMMENDATION 12164
#define IDS_WIN10_TOAST_OPEN_CHROME 12165
#define IDS_WIN10_TOAST_NO_THANKS 12166
#define IDS_CONTROLLED_BY_AUTOMATION 12169
#define IDS_CHROME_FOR_TESTING_DISCLAIMER 12170
#define IDS_DOWNLOAD_CHROME 12171
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_TITLE 12173
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_MESSAGE 12174
#define IDS_CONFIRM_FILE_UPLOAD_TITLE 12175
#define IDS_CONFIRM_FILE_UPLOAD_TEXT 12176
#define IDS_CONFIRM_FILE_UPLOAD_OK_BUTTON 12177
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_TITLE 12178
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_ALLOW_TEXT 12179
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_FILE_TEXT 12180
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_DIRECTORY_TEXT 12181
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_FILE_TEXT 12182
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_DIRECTORY_TEXT 12183
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_FILE_TEXT 12184
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_DIRECTORY_TEXT 12185
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_FILE_TEXT 12186
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_DIRECTORY_TEXT 12187
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_TITLE 12188
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_TITLE 12189
#define IDS_FILE_SYSTEM_ACCESS_READ_FILE_PERMISSION_TITLE 12190
#define IDS_FILE_SYSTEM_ACCESS_READ_DIRECTORY_PERMISSION_TITLE 12191
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_ALLOW_TEXT 12192
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_ALLOW_TEXT 12193
#define IDS_FILE_SYSTEM_ACCESS_VIEW_FILE_PERMISSION_ALLOW_TEXT 12194
#define IDS_FILE_SYSTEM_ACCESS_VIEW_DIRECTORY_PERMISSION_ALLOW_TEXT 12195
#define IDS_FILE_SYSTEM_ACCESS_WRITE_USAGE_TOOLTIP 12196
#define IDS_FILE_SYSTEM_ACCESS_DIRECTORY_USAGE_TOOLTIP 457
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_FILE_TEXT 12197
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_TEXT 12198
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_DIRECTORY_TEXT 12199
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_DIRECTORIES_TEXT 12200
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_AND_DIRECTORIES_TEXT 12201
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_FILE_TEXT 12202
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_TEXT 12203
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_DIRECTORY_TEXT 12204
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_DIRECTORIES_TEXT 12205
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_AND_DIRECTORIES_TEXT 12206
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READ_AND_WRITE 12207
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SAVE_CHANGES 12208
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_VIEW_CHANGES 12209
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_FILES_TEXT 12210
#define IDS_FILE_SYSTEM_ACCESS_USAGE_EXPAND 12211
#define IDS_FILE_SYSTEM_ACCESS_USAGE_COLLAPSE 12212
#define IDS_FILE_SYSTEM_ACCESS_USAGE_REMOVE_ACCESS 12213
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_DIRECTORY_TITLE 12214
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_WRITABLE_DIRECTORY_TITLE 12215
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TITLE 12216
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TEXT 12217
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_BUTTON 12218
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TITLE 12219
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TEXT 12220
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_BUTTON 12221
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TITLE 12222
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_TEXT 12223
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_DONT_SAVE 12224
#define IDS_FILE_SYSTEM_ACCESS_DANGEROUS_FILE_SAVE 12225
#define IDS_RELAUNCH_ACCEPT_BUTTON 12226
#define IDS_RELAUNCH_REQUIRED_CANCEL_BUTTON 12227
#define IDS_IDLE_TIMEOUT_INCOGNITO 12228
#define IDS_IDLE_TIMEOUT_CLOSE_COUNTDOWN 12229
#define IDS_IDLE_TIMEOUT_CLEAR_COUNTDOWN 12230
#define IDS_WEBAUTHN_GENERIC_TITLE 12231
#define IDS_WEBAUTHN_CONTINUE 12232
#define IDS_WEBAUTHN_TRANSPORT_USB 12233
#define IDS_WEBAUTHN_TRANSPORT_INTERNAL 12234
#define IDS_WEBAUTHN_TRANSPORT_CABLE 12235
#define IDS_WEBAUTHN_TRANSPORT_AOA 12236
#define IDS_WEBAUTHN_TRANSPORT_POPUP_DIFFERENT_AUTHENTICATOR_WIN 12237
#define IDS_WEBAUTHN_USB_ACTIVATE_DESCRIPTION 12238
#define IDS_WEBAUTHN_ERROR_GENERIC_TITLE 12239
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_TITLE 12240
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_TITLE 12241
#define IDS_WEBAUTHN_ERROR_WRONG_DEVICE_REGISTER_DESCRIPTION 12242
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_SIGN_DESCRIPTION 12243
#define IDS_WEBAUTHN_ERROR_TIMEOUT_DESCRIPTION 12244
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_TITLE 12245
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_DESCRIPTION 12246
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_TITLE 12247
#define IDS_WEBAUTHN_WINDOWS_HELLO_NOT_ENABLED_DESCRIPTION 12248
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_TITLE 12249
#define IDS_WEBAUTHN_ERROR_NO_PASSKEYS_DESCRIPTION 12250
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_TITLE 12251
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_DESCRIPTION 12252
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_NEXT 12253
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_TITLE 12254
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 12255
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_NEXT 12256
#define IDS_WEBAUTHN_TRANSPORT_POPUP_USB 12258
#define IDS_WEBAUTHN_TRANSPORT_POPUP_PAIR_PHONE 12259
#define IDS_WEBAUTHN_TRANSPORT_POPUP_INTERNAL 12260
#define IDS_WEBAUTHN_TRANSPORT_POPUP_CABLE 12261
#define IDS_WEBAUTHN_TRANSPORT_POPUP_AOA 12262
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE 12263
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE_DEVICE 12264
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION 12265
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DEVICE_NAME_DESCRIPTION 12266
#define IDS_WEBAUTHN_CABLEV2_CONNECTING_TITLE 12267
#define IDS_WEBAUTHN_CABLEV2_CONNECTED_DESCRIPTION 12268
#define IDS_WEBAUTHN_CABLEV2_ERROR_DESCRIPTION 12269
#define IDS_WEBAUTHN_CABLEV2_ERROR_CLOSE 12270
#define IDS_WEBAUTHN_CABLEV2_SERVERLINK_TROUBLE 12271
#define IDS_WEBAUTHN_CABLEV2_AOA_TITLE 12272
#define IDS_WEBAUTHN_CABLEV2_AOA_DESCRIPTION 12273
#define IDS_WEBAUTHN_CABLEV2_AOA_REQUEST_DESCRIPTION 12274
#define IDS_WEBAUTHN_PASSKEY_PHONE_OR_TABLET_LABEL 12275
#define IDS_WEBAUTHN_PASSKEY_DIFFERENT_PHONE_OR_TABLET_LABEL 12276
#define IDS_WEBAUTHN_PHONE_CONFIRMATION_TITLE 12277
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION_SHORT 12278
#define IDS_WEBAUTHN_PIN_ENTRY_TITLE 12279
#define IDS_WEBAUTHN_PIN_ENTRY_DESCRIPTION 12280
#define IDS_WEBAUTHN_PIN_ENTRY_PIN_LABEL 12281
#define IDS_WEBAUTHN_PIN_ENTRY_NEXT 12282
#define IDS_WEBAUTHN_PIN_SETUP_DESCRIPTION 12283
#define IDS_WEBAUTHN_PIN_SETUP_CONFIRMATION_LABEL 12284
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_INVALID_CHARACTERS 12285
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_TOO_SHORT 12286
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED_RETRIES 12287
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED 12288
#define IDS_WEBAUTHN_PIN_SETUP_ERROR_FAILED 12289
#define IDS_WEBAUTHN_PIN_TAP_AGAIN_DESCRIPTION 12290
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_MISMATCH 12291
#define IDS_WEBAUTHN_CLIENT_PIN_SOFT_BLOCK_DESCRIPTION 12292
#define IDS_WEBAUTHN_CLIENT_PIN_HARD_BLOCK_DESCRIPTION 12293
#define IDS_WEBAUTHN_CLIENT_PIN_AUTHENTICATOR_REMOVED_DESCRIPTION 12294
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_SAME_AS_CURRENT 12295
#define IDS_WEBAUTHN_INLINE_ENROLLMENT_CANCEL_LABEL 12296
#define IDS_WEBAUTHN_UV_RETRY_TITLE 12297
#define IDS_WEBAUTHN_UV_RETRY_DESCRIPTION 12298
#define IDS_WEBAUTHN_UV_RETRY_ERROR_FAILED_RETRIES 12299
#define IDS_WEBAUTHN_UV_ERROR_LOCKED 12300
#define IDS_WEBAUTHN_FORCE_PIN_CHANGE 12301
#define IDS_WEBAUTHN_UNKNOWN_ACCOUNT 12302
#define IDS_WEBAUTHN_RESIDENT_KEY_PRIVACY 12303
#define IDS_WEBAUTHN_RESIDENT_KEY_PREFERRED_PRIVACY 12304
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_TITLE 12305
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_DESC 12306
#define IDS_WEBAUTHN_STORAGE_FULL_DESC 12307
#define IDS_WEBAUTHN_REQUEST_ATTESTATION_PERMISSION_TITLE 12308
#define IDS_WEBAUTHN_REQUEST_ATTESTATION_PERMISSION_DESC 12309
#define IDS_WEBAUTHN_REQUEST_ENTERPRISE_ATTESTATION_PERMISSION_TITLE 12310
#define IDS_WEBAUTHN_REQUEST_ENTERPRISE_ATTESTATION_PERMISSION_DESC 12311
#define IDS_WEBAUTHN_ALLOW_ATTESTATION 12312
#define IDS_WEBAUTHN_DENY_ATTESTATION 12313
#define IDS_WEBAUTHN_RETRY 12314
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_TITLE 12315
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DESCRIPTION 12316
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DENY 12317
#define IDS_WEBAUTHN_MANAGE_DEVICES 12318
#define IDS_WEBAUTHN_CREATE_PASSKEY_TITLE 12319
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA 12320
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_INCOGNITO 12321
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_WIN 12322
#define IDS_WEBAUTHN_CREATE_PASSKEY_EXTRA_WIN_INCOGNITO 12323
#define IDS_WEBAUTHN_CREATE_PASSKEY_CHOOSE_DEVICE_TITLE 12324
#define IDS_WEBAUTHN_CREATE_PASSKEY_CHOOSE_DEVICE_BODY 12325
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_TITLE 12326
#define IDS_WEBAUTHN_USE_PASSKEY_CHOOSE_DEVICE_BODY 12327
#define IDS_WEBAUTHN_USE_PASSKEY_TITLE 12328
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_TITLE 12329
#define IDS_WEBAUTHN_CHOOSE_PASSKEY_BODY 12330
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_TITLE 12331
#define IDS_WEBAUTHN_CREATE_PASSKEY_QR_BODY 12332
#define IDS_WEBAUTHN_USE_PASSKEY_QR_TITLE 12333
#define IDS_WEBAUTHN_USE_PASSKEY_QR_BODY 12334
#define IDS_WEBAUTHN_USE_A_DIFFERENT_DEVICE 12335
#define IDS_ACCNAME_SIDE_SEARCH_TOOL 12336
#define IDS_ACCNAME_SIDE_SEARCH_TOOLBAR_BUTTON_ACTIVATED 12337
#define IDS_ACCNAME_SIDE_SEARCH_TOOLBAR_BUTTON_NOT_ACTIVATED 12338
#define IDS_ACCNAME_SIDE_SEARCH_CLOSE_BUTTON 12339
#define IDS_ACCNAME_SIDE_SEARCH_FEEDBACK_BUTTON 12340
#define IDS_SIDE_SEARCH_PROMO 12341
#define IDS_SIDE_SEARCH_TUTORIAL_OPEN_SIDE_PANEL 12342
#define IDS_SIDE_SEARCH_TUTORIAL_OPEN_A_LINK_TO_TAB 12343
#define IDS_SIDE_SEARCH_TUTORIAL_CLOSE_SIDE_PANEL 12344
#define IDS_SIDE_SEARCH_ENTRYPOINT_LABEL 445
#define IDS_TOOLTIP_SIDE_SEARCH_TOOLBAR_BUTTON_ACTIVATED 12345
#define IDS_TOOLTIP_SIDE_SEARCH_TOOLBAR_BUTTON_NOT_ACTIVATED 446
#define IDS_TOOLTIP_SIDE_SEARCH_CLOSE_BUTTON 12346
#define IDS_TOOLTIP_SIDE_SEARCH_FEEDBACK_BUTTON 12347
#define IDS_CABLEV2_MAKE_CREDENTIAL_NOTIFICATION_TITLE 12348
#define IDS_CABLEV2_GET_ASSERTION_NOTIFICATION_TITLE 12349
#define IDS_INCOGNITO_PROFILE_MENU_TITLE 12350
#define IDS_INCOGNITO_WINDOW_COUNT_MESSAGE 12351
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON 12352
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON_NEW 12353
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_PRIMARY_TEXT 12354
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_SECONDARY_TEXT 12355
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_CLOSE_WINDOWS_BUTTON 12356
#define IDS_INCOGNITO_HISTORY_BUBBLE_PRIMARY_TEXT 12357
#define IDS_INCOGNITO_HISTORY_BUBBLE_SECONDARY_TEXT 12358
#define IDS_INCOGNITO_HISTORY_BUBBLE_CLOSE_INCOGNITO_BUTTON_TEXT 12359
#define IDS_INCOGNITO_HISTORY_BUBBLE_CANCEL_BUTTON_TEXT 12360
#define IDS_GUEST_WINDOW_COUNT_MESSAGE 12361
#define IDS_GUEST_PROFILE_MENU_CLOSE_BUTTON 12362
#define IDS_HATS_BUBBLE_OK_LABEL 12363
#define IDS_HATS_BUBBLE_TEXT 12364
#define IDS_NOTIFICATION_DEFAULT_HELPFUL_BUTTON_TEXT 12365
#define IDS_NOTIFICATION_DEFAULT_UNHELPFUL_BUTTON_TEXT 12366
#define IDS_DEEP_SCANNING_DIALOG_TITLE 12367
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_PENDING_MESSAGE 12368
#define IDS_DEEP_SCANNING_DIALOG_PRINT_PENDING_MESSAGE 12369
#define IDS_DEEP_SCANNING_DIALOG_SUCCESS_MESSAGE 12370
#define IDS_DEEP_SCANNING_DIALOG_PRINT_SUCCESS_MESSAGE 12371
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAILURE_MESSAGE 12372
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_WARNING_MESSAGE 12373
#define IDS_DEEP_SCANNING_DIALOG_PRINT_WARNING_MESSAGE 12374
#define IDS_DEEP_SCANNING_DIALOG_TIMEOUT_MESSAGE 12375
#define IDS_DEEP_SCANNING_DIALOG_PROCEED_BUTTON 12376
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_WARNING_BUTTON 12377
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_UPLOAD_BUTTON 12378
#define IDS_DEEP_SCANNING_DIALOG_LARGE_FILE_FAILURE_MESSAGE 12379
#define IDS_DEEP_SCANNING_DIALOG_LARGE_PRINT_FAILURE_MESSAGE 12380
#define IDS_DEEP_SCANNING_DIALOG_ENCRYPTED_FILE_FAILURE_MESSAGE 12381
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE 12382
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_CUSTOM_MESSAGE 12383
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE_LEARN_MORE_LINK 12384
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_DISCARD_FILE_BUTTON 12385
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_BYPASS_JUSTIFICATION_LABEL 12386
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOAD_BYPASS_JUSTIFICATION_LABEL 12387
#define IDS_DEEP_SCANNING_DIALOG_BYPASS_JUSTIFICATION_TEXT_LIMIT_LABEL 12388
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_TITLE 12389
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_MESSAGE 12390
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_ACCEPT_BUTTON 12391
#define IDS_DEEP_SCANNING_INFO_DIALOG_TITLE 12392
#define IDS_APP_DEEP_SCANNING_INFO_DIALOG_MESSAGE 12393
#define IDS_DEEP_SCANNING_INFO_DIALOG_MESSAGE 12394
#define IDS_DEEP_SCANNING_INFO_DIALOG_ACCEPT_BUTTON 12395
#define IDS_DEEP_SCANNING_INFO_DIALOG_CANCEL_BUTTON 12396
#define IDS_DEEP_SCANNING_INFO_DIALOG_OPEN_NOW_BUTTON 12397
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_TITLE 12398
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_MESSAGE 12399
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_ACCEPT_BUTTON 12400
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_CANCEL_BUTTON 12401
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_OPEN_NOW_BUTTON 12402
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_TEXT 12403
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_IPH_BUBBLE_CLOSE_BUTTON_ARIA_LABEL_TEXT 12404
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_TITLE 12405
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_TITLE 12406
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_MAIN_TEXT 12407
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_MAIN_TEXT 12408
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_ACCEPT_BUTTON 12409
#define IDS_TAILORED_SECURITY_DIALOG_SETTINGS_BUTTON 12410
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_TITLE 12411
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_BODY 12412
#define IDS_TAILORED_SECURITY_UNCONSENTED_ACCEPT_BUTTON 12413
#define IDS_TAILORED_SECURITY_UNCONSENTED_CANCEL_BUTTON 12414
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_TITLE 12415
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_DESCRIPTION 12416
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_DESCRIPTION_UPDATED 12417
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_TITLE 12418
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_DESCRIPTION 12419
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_DESCRIPTION_UPDATED 12420
#define IDS_TAILORED_SECURITY_CONSENTED_MESSAGE_OK_BUTTON 12421
#define IDS_PROMPT_APP_UNINSTALL_TITLE 12422
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_NON_GOOGLE 12423
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_GOOGLE 12424
#define IDS_APP_UNINSTALL_PROMPT_LEARN_MORE 12425
#define IDS_APP_UNINSTALL_PROMPT_ADDITIONAL_UNINSTALLS_MESSAGE 12426
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_TITLE 12427
#define IDS_SUB_APPS_UNINSTALL_NOTIFICATION_DESCRIPTION 12428
#define IDS_UTILITY_PROCESS_SPEECH_RECOGNITION_SERVICE_NAME 12429
#define IDS_APP_PAUSE_PROMPT_TITLE 12430
#define IDS_APP_PAUSE_HEADING 12431
#define IDS_APP_PAUSE_HEADING_FOR_WEB_APPS 12432
#define IDS_APP_BLOCK_PROMPT_TITLE 12433
#define IDS_APP_BLOCK_HEADING_FOR_CHILD 12434
#define IDS_APP_BLOCK_HEADING 12435
#define IDS_ENTERPRISE_EXTENSION_REQUEST_APPROVED_TITLE 12436
#define IDS_ENTERPRISE_EXTENSION_REQUEST_REJECTED_TITLE 12437
#define IDS_ENTERPRISE_EXTENSION_REQUEST_FORCE_INSTALLED_TITLE 12438
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_INSTALL 12439
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_VIEW 12440
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION 12441
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_PLACEHOLDER 12442
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_LENGTH_LIMIT 12443
#define IDS_NAME_WINDOW_PROMPT_TITLE 12444
#define IDS_NAME_WINDOW_PROMPT_FIELD_LABEL 12445
#define IDS_QUICK_COMMANDS_LABEL 12446
#define IDS_QUICK_COMMANDS_PLACEHOLDER 12447
#define IDS_QUICK_COMMANDS_NO_RESULTS 12448
#define IDS_CHROMELABS_RELAUNCH_BUTTON_LABEL 12449
#define IDS_WINDOW_TITLE_EXPERIMENTS 12450
#define IDS_CHROMELABS_SEND_FEEDBACK 12451
#define IDS_CHROMELABS_SEND_FEEDBACK_DESCRIPTION_PLACEHOLDER 12452
#define IDS_CHROMELABS_DEFAULT 12453
#define IDS_CHROMELABS_ENABLED 12454
#define IDS_CHROMELABS_DISABLED 12455
#define IDS_CHROMELABS_ENABLED_WITH_VARIATION_NAME 12456
#define IDS_CHROMEREFRESH2023_EXPERIMENT_NAME 12457
#define IDS_CHROMEREFRESH2023_DESCRIPTION 12458
#define IDS_CHROMEREFRESH2023_WITHOUT_OMNIBOX 12459
#define IDS_TAB_SCROLLING_EXPERIMENT_NAME 12460
#define IDS_TAB_SCROLLING_EXPERIMENT_DESCRIPTION 12461
#define IDS_TABS_SHRINK_TO_PINNED_TAB_WIDTH 12462
#define IDS_TABS_SHRINK_TO_MEDIUM_WIDTH 12463
#define IDS_TABS_SHRINK_TO_LARGE_WIDTH 12464
#define IDS_TABS_DO_NOT_SHRINK 12465
#define IDS_LENS_REGION_SEARCH_BUBBLE_TEXT 12466
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_NAME 12467
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_DESCRIPTION 12468
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_DESCRIPTION 12471
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_DESCRIPTION_UPDATED 12472
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_ACCEPT 12473
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_IN 12474
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_SIGN_UP 12475
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_USE 12476
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT_CONTINUE 12477
#define IDS_ACCOUNT_SELECTION_SHEET_SUBTITLE 12478
#define IDS_ACCOUNT_SELECTION_CONTINUE 12479
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP_OR_TOS 12480
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP 12481
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_TOS 12482
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT 12483
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_DIALOG_TITLE 12484
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_DIALOG_CONTINUE 12485
#define IDS_IDP_SIGNIN_STATUS_MISMATCH_DIALOG_BODY 12486
#define IDS_MULTI_IDP_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT 12487
#define IDS_VERIFY_SHEET_TITLE 12488
#define IDS_VERIFY_SHEET_TITLE_AUTO_REAUTHN 12489
#define IDS_AUTO_REAUTHN_OPTOUT_CHECKBOX 12490
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_TITLE 12522
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_TITLE 12523
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_HEADER_1 12524
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION 12525
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_SETTINGS_LINK 12526
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION_ESTIMATES_INTERESTS_LINK 12527
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION_ESTIMATES_INTERESTS_LINK_A11Y_NAME 12528
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_DESCRIPTION_1 12529
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_HEADER_2 12530
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_HEADER 12531
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_3 12532
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_ACCEPT_BUTTON 12533
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_DECLINE_BUTTON 12534
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_HEADER_1 12535
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_DESCRIPTION_1 12536
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_HEADER_2 12537
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_ACKNOWLEDGE_BUTTON 12538
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_OPEN_SETTINGS_BUTTON 12539
#define IDS_BATTERY_SAVER_BUTTON_TOOLTIP 435
#define IDS_BATTERY_SAVER_BUTTON_ACCNAME 434
#define IDS_BATTERY_SAVER_BUBBLE_TITLE 12540
#define IDS_BATTERY_SAVER_BUBBLE_DESCRIPTION 12541
#define IDS_BATTERY_SAVER_SESSION_TURN_OFF 12542
#define IDS_HIGH_EFFICIENCY_CHIP_LABEL 12543
#define IDS_HIGH_EFFICIENCY_CHIP_ACCNAME 460
#define IDS_HIGH_EFFICIENCY_CHIP_WITH_SAVINGS_ACCNAME 12544
#define IDS_HIGH_EFFICIENCY_CHIP_SAVINGS_LABEL 12545
#define IDS_HIGH_EFFICIENCY_DIALOG_TITLE_V2 12546
#define IDS_HIGH_EFFICIENCY_DIALOG_BODY 12547
#define IDS_HIGH_EFFICIENCY_DIALOG_BODY_WITHOUT_LINK 12548
#define IDS_HIGH_EFFICIENCY_DIALOG_BODY_LINK_TEXT 12549
#define IDS_HIGH_EFFICIENCY_DIALOG_BODY_WITH_SAVINGS_AND_LINK 12550
#define IDS_HIGH_EFFICIENCY_DIALOG_BODY_WITH_SAVINGS 12551
#define IDS_HIGH_EFFICIENCY_DIALOG_SAVINGS_ACCNAME 12552
#define IDS_HIGH_EFFICIENCY_DIALOG_BUTTON_ADD_TO_EXCLUSION_LIST 12553
#define IDS_HIGH_EFFICIENCY_DIALOG_SAVINGS_LABEL 12554
#define IDS_HIGH_EFFICIENCY_DIALOG_SMALL_SAVINGS_LABEL 12555
#define IDS_HIGH_EFFICIENCY_DIALOG_MEDIUM_SAVINGS_LABEL 12556
#define IDS_HIGH_EFFICIENCY_DIALOG_LARGE_SAVINGS_LABEL 12557
#define IDS_HIGH_EFFICIENCY_DIALOG_VERY_LARGE_SAVINGS_LABEL 12558
#define IDS_HOVERCARD_TAB_MEMORY_USAGE 12559
#define IDS_HOVERCARD_TAB_HIGH_MEMORY_USAGE 12560
#define IDS_HOVERCARD_INACTIVE_TAB_MEMORY_SAVINGS 12561
#define IDS_HOVERCARD_INACTIVE_TAB 12562
#define IDS_ACCNAME_SIDEBAR_WEBVIEW_LOCATION_BAR 12563
#define IDS_SIDEBAR_WEBVIEW_TITLE 12564
#define IDS_PROTECTED_AUDIENCE_DEBUGGING_DISCLAIMER 12573

// ---------------------------------------------------------------------------
// From locale_settings.h:

#define IDS_SPELLCHECK_DICTIONARY 145
#define IDS_EDITBOOKMARK_DIALOG_WIDTH_CHARS 15000
#define IDS_EDITBOOKMARK_DIALOG_HEIGHT_LINES 15001
#define IDS_THEMES_GALLERY_URL 15002
#define IDS_WEBSTORE_URL 479
#define IDS_MEDIA_GALLERIES_DIALOG_CONTENT_WIDTH_CHARS 15003
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_DIALOG 15005
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_HISTORY 15006

// ---------------------------------------------------------------------------
// From omnibox_pedal_synonyms.h:

#define IDS_OMNIBOX_PEDALS_IGNORE_GROUP 287
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_CLEAR_BROWSER_CACHE 36800
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_OPTIONAL_GOOGLE_CHROME 373
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_DELETE 374
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLEAR_BROWSING_DATA_ONE_REQUIRED_INFORMATION 375
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_MANAGE_CHROME_PASSWORDS 36801
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_GOOGLE_CHROME 367
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_OPTIONAL_MANAGER 368
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_PASSWORDS_ONE_REQUIRED_PASSWORDS 369
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_MANAGE_PAYMENT_METHODS 36802
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_OPTIONAL_GOOGLE_CHROME 364
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CHANGE 365
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CREDIT_CARD_ONE_REQUIRED_CREDIT_CARD_INFORMATION 366
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_ENTER_INCOGNITO_MODE 36803
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_GOOGLE_CHROME 361
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_OPTIONAL_CREATE 362
#define IDS_OMNIBOX_PEDAL_SYNONYMS_LAUNCH_INCOGNITO_ONE_REQUIRED_INCOGNITO_WINDOW 363
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_TRANSLATE_THIS_PAGE 36804
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_OPTIONAL_GOOGLE_CHROME 357
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_CHANGE_LANGUAGE 358
#define IDS_OMNIBOX_PEDAL_SYNONYMS_TRANSLATE_ONE_REQUIRED_THIS_PAGE 359
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_UPDATE_CHROME 36805
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_GOOGLE_CHROME 355
#define IDS_OMNIBOX_PEDAL_SYNONYMS_UPDATE_CHROME_ONE_REQUIRED_INSTALL 356
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_RUN_CHROME_SAFETY_CHECK 36806
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_ACTIVATE 351
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_OPTIONAL_GOOGLE_CHROME 352
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_CHECKUP 353
#define IDS_OMNIBOX_PEDAL_SYNONYMS_RUN_CHROME_SAFETY_CHECK_ONE_REQUIRED_PASSWORDS 354
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_MANAGE_SECURITY_SETTINGS 36807
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ANY_OPTIONAL_GOOGLE_CHROME 348
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_REQUIRED_ENHANCED_PROTECTION 349
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SECURITY_SETTINGS_ONE_OPTIONAL_ALTER 350
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_CHROME_COOKIE_SETTINGS 36808
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ONE_REQUIRED_COOKIE_SETTINGS 345
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_REQUIRED_GOOGLE_CHROME 346
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_COOKIES_ANY_OPTIONAL_THIRD_PARTY 347
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_ADD_ADDRESS 36809
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_CONTROL 342
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_REQUIRED_SHIPPING_ADDRESSES 343
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_ADDRESSES_ONE_OPTIONAL_GOOGLE_CHROME 344
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_CHANGE_CHROME_BROWSER_SYNC_SETTINGS 36810
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ONE_REQUIRED_SYNC_SETTINGS 340
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SYNC_ANY_REQUIRED_GOOGLE_CHROME 341
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_ADJUST_SITE_PERMISSIONS 36811
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ONE_REQUIRED_SITE_PERMISSIONS 338
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_SITE_SETTINGS_ANY_REQUIRED_GOOGLE_CHROME 339
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_CREATE_GOOGLE_DOC 36812
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_GOOGLE_WORKSPACE 332
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ANY_REQUIRED_CREATE 333
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_DOC_ONE_REQUIRED_DOCUMENT 334
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_CREATE_GOOGLE_SHEET 36813
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ANY_REQUIRED_CREATE 329
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_GOOGLE_WORKSPACE 330
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SHEET_ONE_REQUIRED_SPREADSHEET 331
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE_GOOGLE_SLIDE 36814
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_CREATE 326
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ONE_REQUIRED_PRESENTATION 327
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SLIDE_ANY_REQUIRED_WORKSPACE 328
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_CREATE_GOOGLE_CAL_INVITE 36815
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_SCHEDULE 323
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ANY_REQUIRED_WORKSPACE 324
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_CALENDAR_EVENT_ONE_REQUIRED_MEETING 325
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_CREATE_GOOGLE_SITE 36816
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_CREATE 320
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ANY_REQUIRED_WORKSPACE 321
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_SITE_ONE_REQUIRED_WEBSITE 322
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_CREATE_GOOGLE_KEEP_NOTE 36817
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_CREATE 317
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ANY_REQUIRED_WORKSPACE 318
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_KEEP_NOTE_ONE_REQUIRED_NOTES 319
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_CREATE_GOOGLE_FORM 36818
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_CREATE 314
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ANY_REQUIRED_WORKSPACE 315
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CREATE_GOOGLE_FORM_ONE_REQUIRED_SURVEY 316
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_CHROME_FEATURES 36819
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_OPTIONAL_MAKE_THE_MOST_OF 335
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ANY_OPTIONAL_BROWSER 336
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SEE_CHROME_TIPS_ONE_REQUIRED_NEW_CHROME_FEATURES 337
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL_MY_GOOGLE_ACCOUNT 36820
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_GOOGLE_ACCOUNT 311
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ANY_OPTIONAL_BROWSER 312
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_ACCOUNT_ONE_REQUIRED_CONTROL 313
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE_GMAIL_PASSWORD 36821
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_GOOGLE_ACCOUNT_PASSWORD 370
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ANY_OPTIONAL_BROWSER 371
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CHANGE_GOOGLE_PASSWORD_ONE_REQUIRED_CHANGE 372
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_CLOSE_INCOGNITO_WINDOW 36822
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_DELETE 36823
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CLOSE_INCOGNITO_WINDOWS_ONE_REQUIRED_INCOGNITO_WINDOW 36824
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_CHROME_DINO 36825
#define IDS_OMNIBOX_PEDAL_SYNONYMS_PLAY_CHROME_DINO_GAME_ONE_REQUIRED_PLAY_CHROME_DINO_GAME 360
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_FIND_LOST_PHONE 36826
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_HELP_ME_LOCATE 309
#define IDS_OMNIBOX_PEDAL_SYNONYMS_FIND_MY_PHONE_ONE_REQUIRED_LOST_DEVICE 310
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_CHANGE_GOOGLE_PRIVACY_SETTINGS 36827
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_GOOGLE_PRIVACY_ONE_REQUIRED_MANAGE_GOOGLE_PRIVACY_SETTINGS 308
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHANGE_CHROME_SETTINGS 36828
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_OPTIONAL_CONTROL 306
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_SETTINGS_ONE_REQUIRED_CHROME_BROWSER_SETTINGS 307
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_MANAGE_CHROME_DOWNLOADS 36829
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CONTROL 304
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_DOWNLOADS_ONE_REQUIRED_CHROME_BROWSER_DOWNLOADS 305
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_SEE_CHROME_HISTORY 36830
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_REVISIT 302
#define IDS_OMNIBOX_PEDAL_SYNONYMS_VIEW_CHROME_HISTORY_ONE_REQUIRED_GOOGLE_CHROME_BROWSING_HISTORY 303
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_THIS_PAGE 36831
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SHARE_THIS_PAGE_ONE_REQUIRED_SHARE_LINK_WITH_QR_CODE 301
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROME_ACCESSIBILITY 36832
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 299
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 300
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_CHANGE_BROWSER_FONT 36833
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_OPTIONAL_CUSTOMIZE 296
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_GOOGLE_CHROME 297
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_CHROME_FONTS_ONE_REQUIRED_FONT_SIZING 298
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CUSTOMIZE_CHROME_APPEARANCE 36834
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_OPTIONAL_CUSTOMIZE 294
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROME_THEMES_ONE_REQUIRED_CHROME_BACKGROUNDS 295
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_ADD_CUSTOM_SEARCH 36835
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_CUSTOMIZE 291
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_REQUIRED_CUSTOM_SEARCH_ENGINES 292
#define IDS_OMNIBOX_PEDAL_SYNONYMS_CUSTOMIZE_SEARCH_ENGINES_ONE_OPTIONAL_GOOGLE_CHROME 293
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_CUSTOMIZE_CHROMEOS_ACCESSIBILITY 36836
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_OPTIONAL_CUSTOMIZE 36837
#define IDS_OMNIBOX_PEDAL_SYNONYMS_MANAGE_CHROMEOS_ACCESSIBILITY_ONE_REQUIRED_ACCESSIBILITY_SETTINGS 36838
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_ALWAYS_OPEN_LINKS_IN_CHROME 36839
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_REQUIRED_HOW_TO_MAKE_CHROME_MY_DEFAULT_BROWSER 288
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_SELECT 289
#define IDS_OMNIBOX_PEDAL_SYNONYMS_SET_CHROME_AS_DEFAULT_BROWSER_ONE_OPTIONAL_DEFAULT_BROWSER 290

// ---------------------------------------------------------------------------
// From platform_locale_settings.h:

#define IDS_STANDARD_FONT_FAMILY 106
#define IDS_FIXED_FONT_FAMILY 107
#define IDS_FIXED_FONT_FAMILY_ALT_WIN 108
#define IDS_SERIF_FONT_FAMILY 109
#define IDS_SANS_SERIF_FONT_FAMILY 110
#define IDS_NTP_FONT_FAMILY 15100
#define IDS_CURSIVE_FONT_FAMILY 111
#define IDS_FANTASY_FONT_FAMILY 112
#define IDS_MATH_FONT_FAMILY 113
#define IDS_STANDARD_FONT_FAMILY_CYRILLIC 131
#define IDS_FIXED_FONT_FAMILY_ARABIC 129
#define IDS_FIXED_FONT_FAMILY_CYRILLIC 132
#define IDS_SANS_SERIF_FONT_FAMILY_ARABIC 130
#define IDS_SERIF_FONT_FAMILY_CYRILLIC 133
#define IDS_SANS_SERIF_FONT_FAMILY_CYRILLIC 134
#define IDS_STANDARD_FONT_FAMILY_GREEK 135
#define IDS_FIXED_FONT_FAMILY_GREEK 136
#define IDS_SERIF_FONT_FAMILY_GREEK 137
#define IDS_SANS_SERIF_FONT_FAMILY_GREEK 138
#define IDS_STANDARD_FONT_FAMILY_JAPANESE 114
#define IDS_FIXED_FONT_FAMILY_JAPANESE 115
#define IDS_SERIF_FONT_FAMILY_JAPANESE 116
#define IDS_SANS_SERIF_FONT_FAMILY_JAPANESE 117
#define IDS_STANDARD_FONT_FAMILY_KOREAN 118
#define IDS_FIXED_FONT_FAMILY_KOREAN 139
#define IDS_SERIF_FONT_FAMILY_KOREAN 119
#define IDS_SANS_SERIF_FONT_FAMILY_KOREAN 120
#define IDS_CURSIVE_FONT_FAMILY_KOREAN 140
#define IDS_STANDARD_FONT_FAMILY_SIMPLIFIED_HAN 121
#define IDS_FIXED_FONT_FAMILY_SIMPLIFIED_HAN 141
#define IDS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 122
#define IDS_SANS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 123
#define IDS_CURSIVE_FONT_FAMILY_SIMPLIFIED_HAN 127
#define IDS_STANDARD_FONT_FAMILY_TRADITIONAL_HAN 124
#define IDS_FIXED_FONT_FAMILY_TRADITIONAL_HAN 142
#define IDS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 125
#define IDS_SANS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 126
#define IDS_CURSIVE_FONT_FAMILY_TRADITIONAL_HAN 128
#define IDS_MINIMUM_FONT_SIZE 143
#define IDS_MINIMUM_LOGICAL_FONT_SIZE 144

// ---------------------------------------------------------------------------
// From services_strings.h:

#define IDS_PROXY_RESOLVER_DISPLAY_NAME 41420
#define IDS_WINDOWS_SYSTEM_PROXY_RESOLVER_DISPLAY_NAME 41421

// ---------------------------------------------------------------------------
// From ui_strings.h:

#define IDS_TIME_SECS 45980
#define IDS_TIME_LONG_SECS 45981
#define IDS_TIME_LONG_SECS_2ND 45982
#define IDS_TIME_MINS 45983
#define IDS_TIME_LONG_MINS 45984
#define IDS_TIME_LONG_MINS_1ST 45985
#define IDS_TIME_LONG_MINS_2ND 45986
#define IDS_TIME_HOURS 45987
#define IDS_TIME_HOURS_1ST 45988
#define IDS_TIME_HOURS_2ND 45989
#define IDS_TIME_DAYS 45990
#define IDS_TIME_DAYS_1ST 45991
#define IDS_TIME_MONTHS 45992
#define IDS_TIME_YEARS 45993
#define IDS_TIME_REMAINING_SECS 45994
#define IDS_TIME_REMAINING_LONG_SECS 45995
#define IDS_TIME_REMAINING_MINS 45996
#define IDS_TIME_REMAINING_LONG_MINS 45997
#define IDS_TIME_REMAINING_HOURS 45998
#define IDS_TIME_REMAINING_DAYS 45999
#define IDS_TIME_REMAINING_MONTHS 46000
#define IDS_TIME_REMAINING_YEARS 46001
#define IDS_TIME_ELAPSED_SECS 46002
#define IDS_TIME_ELAPSED_LONG_SECS 46003
#define IDS_TIME_ELAPSED_MINS 46004
#define IDS_TIME_ELAPSED_LONG_MINS 46005
#define IDS_TIME_ELAPSED_HOURS 46006
#define IDS_TIME_ELAPSED_DAYS 46007
#define IDS_TIME_ELAPSED_MONTHS 46008
#define IDS_TIME_ELAPSED_YEARS 46009
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_SECS 46010
#define IDS_TIME_TITLE_CASE_ELAPSED_LONG_MINS 46011
#define IDS_TIME_TITLE_CASE_ELAPSED_HOURS 46012
#define IDS_TIME_TITLE_CASE_ELAPSED_DAYS 46013
#define IDS_TIME_TITLE_CASE_ELAPSED_MONTHS 46014
#define IDS_TIME_TITLE_CASE_ELAPSED_YEARS 46015
#define IDS_PAST_TIME_TODAY 46016
#define IDS_PAST_TIME_YESTERDAY 46017
#define IDS_APP_MENU_EMPTY_SUBMENU 46018
#define IDS_CLIPBOARD_MENU_HTML 46019
#define IDS_CLIPBOARD_MENU_IMAGE 46020
#define IDS_CLIPBOARD_MENU_RTF_CONTENT 46021
#define IDS_CLIPBOARD_MENU_WEB_SMART_PASTE 46022
#define IDS_CLIPBOARD_MENU_CLIPBOARD 46023
#define IDS_CLIPBOARD_MENU_DELETE_ALL 46024
#define IDS_EXTENSION_PINNED 46025
#define IDS_EXTENSION_UNPINNED 46026
#define IDS_NEW_BADGE 46027
#define IDS_NEW_BADGE_UPPERCASE 46028
#define IDS_NEW_BADGE_SCREEN_READER_MESSAGE 46029
#define IDS_SENTENCE_END 46030
#define IDS_CONCAT_TWO_STRINGS_WITH_COMMA 46031
#define IDS_CONCAT_THREE_STRINGS_WITH_COMMA 46032
#define IDS_CONCAT_TWO_STRINGS_WITH_PERIODS 46033
#define IDS_APP_UNTITLED_SHORTCUT_FILE_NAME 46034
#define IDS_APP_SAVEAS_ALL_FILES 46035
#define IDS_APP_SAVEAS_EXTENSION_FORMAT 46036
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_TITLE 46037
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_MENU 46045
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_DEFAULT 46046
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_LTR 46047
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_RTL 46048
#define IDS_SELECT_FOLDER_DIALOG_TITLE 46049
#define IDS_SAVE_AS_DIALOG_TITLE 46050
#define IDS_OPEN_FILE_DIALOG_TITLE 46051
#define IDS_OPEN_FILES_DIALOG_TITLE 46052
#define IDS_SAVEAS_ALL_FILES 46053
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_UPLOAD_BUTTON 46054
#define IDS_APP_ACCNAME_BACK 46055
#define IDS_APP_ACCNAME_CENTER 46056
#define IDS_APP_ACCNAME_CLOSE 404
#define IDS_APP_ACCNAME_MINIMIZE 401
#define IDS_APP_ACCNAME_MAXIMIZE 402
#define IDS_APP_ACCNAME_RESTORE 403
#define IDS_APP_ACCNAME_MENU 46057
#define IDS_APP_ACCNAME_COLOR_CHOOSER_HEX_INPUT 46058
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHERE 46059
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFTEDGE 46060
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHTEDGE 46061
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHOME 46062
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLEND 46063
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEUP 46064
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEDOWN 46065
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFT 46066
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHT 46067
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLUP 46068
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLDOWN 46069
#define IDS_APP_TABLE_COLUMN_NOT_SORTED_ACCNAME 46070
#define IDS_APP_TABLE_COLUMN_SORTED_ASC_ACCNAME 46071
#define IDS_APP_TABLE_COLUMN_SORTED_DESC_ACCNAME 46072
#define IDS_APP_UNDO 46073
#define IDS_APP_CUT 46074
#define IDS_APP_COPY 407
#define IDS_APP_PASTE 46075
#define IDS_APP_DELETE 46076
#define IDS_APP_SELECT_ALL 408
#define IDS_APP_SELECT 46077
#define IDS_CONTENT_CONTEXT_EMOJI 46078
#define IDS_APP_OK 46081
#define IDS_APP_CANCEL 46082
#define IDS_APP_CLOSE 46083
#define IDS_APP_ESC_KEY 46084
#define IDS_APP_TAB_KEY 46085
#define IDS_APP_INSERT_KEY 46086
#define IDS_APP_HOME_KEY 46087
#define IDS_APP_DELETE_KEY 46088
#define IDS_APP_END_KEY 46089
#define IDS_APP_PAGEUP_KEY 46090
#define IDS_APP_PAGEDOWN_KEY 46091
#define IDS_APP_LEFT_ARROW_KEY 46092
#define IDS_APP_RIGHT_ARROW_KEY 46093
#define IDS_APP_UP_ARROW_KEY 46094
#define IDS_APP_DOWN_ARROW_KEY 46095
#define IDS_APP_ENTER_KEY 46096
#define IDS_APP_SPACE_KEY 46097
#define IDS_APP_F1_KEY 46098
#define IDS_APP_F5_KEY 46099
#define IDS_APP_F6_KEY 46100
#define IDS_APP_F11_KEY 46101
#define IDS_APP_BACKSPACE_KEY 46102
#define IDS_APP_COMMA_KEY 46103
#define IDS_APP_PERIOD_KEY 46104
#define IDS_APP_MEDIA_NEXT_TRACK_KEY 46105
#define IDS_APP_MEDIA_PLAY_PAUSE_KEY 46106
#define IDS_APP_MEDIA_PREV_TRACK_KEY 46107
#define IDS_APP_MEDIA_STOP_KEY 46108
#define IDS_APP_ALT_KEY 46109
#define IDS_APP_COMMAND_KEY 46110
#define IDS_APP_CTRL_KEY 480
#define IDS_APP_SEARCH_KEY 46111
#define IDS_APP_SHIFT_KEY 46112
#define IDS_APP_WINDOWS_KEY 46113
#define IDS_APP_ACCELERATOR_WITH_MODIFIER 481
#define IDS_APP_BYTES 46117
#define IDS_APP_KIBIBYTES 46118
#define IDS_APP_MEBIBYTES 46119
#define IDS_APP_GIBIBYTES 46120
#define IDS_APP_TEBIBYTES 46121
#define IDS_APP_PEBIBYTES 46122
#define IDS_APP_BYTES_PER_SECOND 46123
#define IDS_APP_KIBIBYTES_PER_SECOND 46124
#define IDS_APP_MEBIBYTES_PER_SECOND 46125
#define IDS_APP_GIBIBYTES_PER_SECOND 46126
#define IDS_APP_TEBIBYTES_PER_SECOND 46127
#define IDS_APP_PEBIBYTES_PER_SECOND 46128
#define IDS_MESSAGE_CENTER_ACCESSIBLE_NAME 46129
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME 46130
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME_PLURAL 46131
#define IDS_MESSAGE_CENTER_EXPAND_NOTIFICATION 46132
#define IDS_MESSAGE_CENTER_COLLAPSE_NOTIFICATION 46133
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_MESSAGE_WITH_DIVIDER 46134
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_HEADER_OVERFLOW_INDICATOR 46135
#define IDS_MESSAGE_CENTER_NOTIFICATION_PROGRESS_PERCENTAGE 46136
#define IDS_MESSAGE_CENTER_NOTIFICATION_CHROMEOS_SYSTEM 46137
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_PLACEHOLDER 46138
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_ACCESSIBLE_NAME 46139
#define IDS_MESSAGE_NOTIFICATION_NOW_STRING_SHORTEST 46140
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST 46141
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST 46142
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST 46143
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST 46144
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST_FUTURE 46145
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST_FUTURE 46146
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST_FUTURE 46147
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST_FUTURE 46148
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_SITE 46149
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_APP 46150
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS 46151
#define IDS_MESSAGE_CENTER_DONT_BLOCK_NOTIFICATIONS 46152
#define IDS_MESSAGE_CENTER_SETTINGS_DONE 46153
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_ACCESSIBLE_NAME 46154
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_TOOLTIP 46155
#define IDS_MESSAGE_CENTER_NOTIFICATION_SNOOZE_BUTTON_TOOLTIP 46156
#define IDS_MESSAGE_NOTIFICATION_SETTINGS_BUTTON_ACCESSIBLE_NAME 46157
#define IDS_MESSAGE_NOTIFICATION_ACCESSIBLE_NAME 46158
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_DEVICE_INFO 46159
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_SUCCESS 46160
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_TITLE 46161
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_MESSAGE 46162
#define IDS_CLIPBOARD_HISTORY_MENU_PNG_IMAGE 46164
#define IDS_CLIPBOARD_HISTORY_MENU_HTML_IMAGE 46165
#define IDS_CLIPBOARD_HISTORY_MENU_TITLE 46166
#define IDS_CLIPBOARD_HISTORY_DELETE_ITEM_TEXT 46167
#define IDS_CLIPBOARD_HISTORY_DELETE_BUTTON_HOVER_TEXT 46168
#define IDS_CLIPBOARD_HISTORY_ITEM_DELETION 46169
#define IDS_DISPLAY_TOUCH_CALIBRATION_EXIT_LABEL 46170
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_LABEL_TEXT 46171
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_SUBLABEL_TEXT 46172
#define IDS_DISPLAY_TOUCH_CALIBRATION_TAP_HERE_LABEL 46173
#define IDS_DISPLAY_TOUCH_CALIBRATION_FINISH_LABEL 46174
#define IDS_DISPLAY_NAME_UNKNOWN 46175
#define IDS_DISPLAY_NAME_INTERNAL 46176
#define IDS_CROSTINI_USE_LOW_DENSITY 46177
#define IDS_CROSTINI_USE_HIGH_DENSITY 46178
#define IDS_CROSTINI_APP_RESTART_BODY 46179
#define IDS_SATURATED_BADGE_CONTENT 46180
#define IDS_BADGE_UNREAD_NOTIFICATIONS_SATURATED 46181
#define IDS_BADGE_UNREAD_NOTIFICATIONS_UNSPECIFIED 46182
#define IDS_BADGE_UNREAD_NOTIFICATIONS 46183
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_LABEL 687
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_NO_DEVICES 46184
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_CALL_BUTTON_LABEL 46185
#define IDS_BROWSER_SHARING_OMNIBOX_SENDING_LABEL 467
#define IDS_BROWSER_SHARING_DIALOG_DEVICE_SUBTITLE_LAST_ACTIVE_DAYS 46186
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_INITIATING_ORIGIN 46187
#define IDS_BROWSER_SHARING_CONTENT_TYPE_TEXT 46188
#define IDS_BROWSER_SHARING_CONTENT_TYPE_NUMBER 46189
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_GENERIC_ERROR 46190
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_INTERNAL_ERROR 46191
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_NETWORK_ERROR 46192
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_ACK_TIMEOUT 46193
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_INTERNAL_ERROR 46194
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TITLE_PAYLOAD_TOO_LARGE 46195
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TEXT_PAYLOAD_TOO_LARGE 46196
#define IDS_SETTINGS_PASSWORD_SHOW 46200
#define IDS_SETTINGS_PASSWORD_HIDE 46201
#define IDS_TABLE_VIEW_AX_ANNOUNCE_ROW_SELECTED 46202
#define IDS_LINK_COPIED 46203

#endif  // CEF_INCLUDE_CEF_PACK_STRINGS_H_
