// Copyright (c) 2023 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_RESOURCES_H_
#define CEF_INCLUDE_CEF_PACK_RESOURCES_H_
#pragma once

// ---------------------------------------------------------------------------
// From blink_resources.h:

#define IDR_UASTYLE_HTML_CSS 35060
#define IDR_UASTYLE_OVERFLOW_REPLACED_CSS 35061
#define IDR_UASTYLE_QUIRKS_CSS 35062
#define IDR_UASTYLE_VIEW_SOURCE_CSS 35063
#define IDR_UASTYLE_THEME_CHROMIUM_ANDROID_CSS 35064
#define IDR_UASTYLE_FULLSCREEN_ANDROID_CSS 35065
#define IDR_UASTYLE_THEME_CHROMIUM_LINUX_CSS 35066
#define IDR_UASTYLE_THEME_MAC_CSS 35067
#define IDR_UASTYLE_THEME_INPUT_MULTIPLE_FIELDS_CSS 35068
#define IDR_UASTYLE_THEME_FORCED_COLORS_CSS 35069
#define IDR_UASTYLE_POPOVER_CSS 35070
#define IDR_UASTYLE_SELECTMENU_CSS 35071
#define IDR_UASTYLE_SVG_CSS 35072
#define IDR_UASTYLE_MARKER_CSS 35073
#define IDR_UASTYLE_MATHML_CSS 35074
#define IDR_UASTYLE_MATHML_FALLBACK_CSS 35075
#define IDR_UASTYLE_FULLSCREEN_CSS 35076
#define IDR_UASTYLE_WEBXR_OVERLAY_CSS 35077
#define IDR_UASTYLE_TRANSITION_CSS 35078
#define IDR_UASTYLE_TRANSITION_ANIMATIONS_CSS 35079
#define IDR_UASTYLE_FORM_CONTROLS_NOT_VERTICAL_CSS 35080
#define IDR_DOCUMENTXMLTREEVIEWER_CSS 35081
#define IDR_DOCUMENTXMLTREEVIEWER_JS 35082
#define IDR_VALIDATION_BUBBLE_ICON 35083
#define IDR_VALIDATION_BUBBLE_CSS 35084
#define IDR_PICKER_COMMON_JS 35085
#define IDR_PICKER_COMMON_CSS 35086
#define IDR_CALENDAR_PICKER_CSS 35087
#define IDR_CALENDAR_PICKER_JS 35088
#define IDR_MONTH_PICKER_JS 35089
#define IDR_TIME_PICKER_CSS 35090
#define IDR_TIME_PICKER_JS 35091
#define IDR_DATETIMELOCAL_PICKER_JS 35092
#define IDR_SUGGESTION_PICKER_CSS 35093
#define IDR_SUGGESTION_PICKER_JS 35094
#define IDR_COLOR_PICKER_COMMON_JS 35095
#define IDR_COLOR_SUGGESTION_PICKER_CSS 35096
#define IDR_COLOR_SUGGESTION_PICKER_JS 35097
#define IDR_COLOR_PICKER_CSS 35098
#define IDR_COLOR_PICKER_JS 35099
#define IDR_LIST_PICKER_CSS 35100
#define IDR_LIST_PICKER_JS 35101
#define IDR_AUDIO_SPATIALIZATION_COMPOSITE 35102

// ---------------------------------------------------------------------------
// From browser_resources.h:

#define IDR_INCOGNITO_TAB_HTML 13800
#define IDR_REVAMPED_INCOGNITO_TAB_HTML 13801
#define IDR_INCOGNITO_TAB_THEME_CSS 13802
#define IDR_GUEST_TAB_HTML 13803
#define IDR_NEW_TAB_4_THEME_CSS 13804
#define IDR_ABOUT_NACL_HTML 13543
#define IDR_ABOUT_NACL_CSS 13544
#define IDR_ABOUT_NACL_JS 13545
#define IDR_ABOUT_SYS_HTML 13546
#define IDR_ABOUT_SYS_CSS 13547
#define IDR_ABOUT_SYS_JS 13548
#define IDR_AD_NETWORK_HASHES 13549
#define IDR_CERTIFICATE_VIEWER_HTML 13550
#define IDR_CERTIFICATE_VIEWER_JS 13551
#define IDR_CERTIFICATE_VIEWER_CSS 13552
#define IDR_PAGE_NOT_AVAILABLE_FOR_GUEST_APP_HTML 13570
#define IDR_IDENTITY_API_SCOPE_APPROVAL_MANIFEST 13572
#define IDR_INSPECT_CSS 13573
#define IDR_INSPECT_HTML 13574
#define IDR_INSPECT_JS 13575
#define IDR_NETWORK_SPEECH_SYNTHESIS_MANIFEST 250
#define IDR_PDF_MANIFEST 252
#define IDR_USB_ENUMERATION_OPTIONS_MOJOM_WEBUI_JS 13578
#define IDR_USB_DEVICE_MANAGER_CLIENT_MOJOM_WEBUI_JS 13579
#define IDR_WEBSTORE_MANIFEST 247
#define IDR_MEDIA_ROUTER_INTERNALS_HTML 13694
#define IDR_MEDIA_ROUTER_INTERNALS_CSS 13695
#define IDR_MEDIA_ROUTER_INTERNALS_JS 13696
#define IDR_IME_WINDOW_CLOSE 13697
#define IDR_IME_WINDOW_CLOSE_C 13698
#define IDR_IME_WINDOW_CLOSE_H 13699
#define IDR_RESET_PASSWORD_HTML 13739
#define IDR_RESET_PASSWORD_JS 13740
#define IDR_RESET_PASSWORD_MOJOM_WEBUI_JS 13741
#define IDR_TAB_RANKER_EXAMPLE_PREPROCESSOR_CONFIG_PB 13742
#define IDR_TAB_RANKER_PAIRWISE_EXAMPLE_PREPROCESSOR_CONFIG_PB 13743
#define IDR_CART_DOMAIN_NAME_MAPPING_JSON 13756
#define IDR_CART_DOMAIN_CART_URL_MAPPING_JSON 13757
#define IDR_DESKTOP_SHARING_HUB_PB 13758

// ---------------------------------------------------------------------------
// From cef_resources.h:

#define IDR_CEF_DEVTOOLS_DISCOVERY_PAGE 63000
#define IDR_CEF_LICENSE_TXT 63001
#define IDR_CEF_VERSION_HTML 63002
#define IDR_CEF_EXTENSION_API_FEATURES 63003

// ---------------------------------------------------------------------------
// From common_resources.h:

#define IDR_CHROME_EXTENSION_API_FEATURES 20500
#define IDR_CHROME_APP_API_FEATURES 20501

// ---------------------------------------------------------------------------
// From component_extension_resources.h:

#define IDR_NETWORK_SPEECH_SYNTHESIS_JS 15360
#define IDR_IDENTITY_API_SCOPE_APPROVAL_BACKGROUND_JS 15370
#define IDR_IDENTITY_API_SCOPE_APPROVAL_DIALOG_CSS 15371
#define IDR_IDENTITY_API_SCOPE_APPROVAL_DIALOG 15372
#define IDR_IDENTITY_API_SCOPE_APPROVAL_DIALOG_JS 15373
#define IDR_IDENTITY_API_SCOPE_APPROVAL_INJECT_JS 15374
#define IDS_READ_ANYTHING_DEFAULT_PNG 15404
#define IDS_READ_ANYTHING_LIGHT_PNG 15405
#define IDS_READ_ANYTHING_DARK_PNG 15406
#define IDS_READ_ANYTHING_YELLOW_PNG 15407
#define IDS_READ_ANYTHING_BLUE_PNG 15408

// ---------------------------------------------------------------------------
// From components_resources.h:

#define IDR_ABOUT_UI_CREDITS_CSS 31070
#define IDR_ABOUT_UI_CREDITS_HTML 31071
#define IDR_ABOUT_UI_CREDITS_JS 31072
#define IDR_CART_DOMAIN_CART_URL_REGEX_JSON 31073
#define IDR_CHECKOUT_URL_REGEX_DOMAIN_MAPPING_JSON 31074
#define IDR_QUERY_SHOPPING_META_JS 31075
#define IDR_DOM_DISTILLER_VIEWER_HTML 31076
#define IDR_DOM_DISTILLER_VIEWER_JS 31077
#define IDR_DISTILLER_JS 31078
#define IDR_DISTILLER_CSS 31079
#define IDR_DISTILLER_DESKTOP_CSS 31080
#define IDR_DISTILLER_LOADING_IMAGE 31081
#define IDR_EXTRACT_PAGE_FEATURES_JS 31082
#define IDR_DISTILLABLE_PAGE_SERIALIZED_MODEL_NEW 31083
#define IDR_LONG_PAGE_SERIALIZED_MODEL 31084
#define IDR_FLAGS_UI_FLAGS_HTML 31085
#define IDR_FLAGS_UI_FLAGS_JS 31086
#define IDR_FLAGS_UI_FLAGS_CSS 31087
#define IDR_MOBILE_MANAGEMENT_CSS 31088
#define IDR_MOBILE_MANAGEMENT_HTML 31089
#define IDR_MOBILE_MANAGEMENT_JS 31090
#define IDR_NET_ERROR_HTML 31091
#define IDR_PRINT_HEADER_FOOTER_TEMPLATE_PAGE 31119
#define IDR_SAFE_BROWSING_HTML 31120
#define IDR_SAFE_BROWSING_CSS 31121
#define IDR_SAFE_BROWSING_JS 31122
#define IDR_REAL_TIME_URL_CHECKS_ALLOWLIST_PB 31123
#define IDR_DOWNLOAD_FILE_TYPES_PB 205
#define IDR_SECURITY_INTERSTITIAL_COMMON_CSS 31124
#define IDR_SECURITY_INTERSTITIAL_CORE_CSS 31125
#define IDR_SECURITY_INTERSTITIAL_HTML 31126
#define IDR_SECURITY_INTERSTITIAL_QUIET_HTML 31127
#define IDR_SECURITY_INTERSTITIAL_CONNECTION_HELP_HTML 31128
#define IDR_SECURITY_INTERSTITIAL_CONNECTION_HELP_CSS 31129
#define IDR_SECURITY_INTERSTITIAL_CONNECTION_HELP_JS 31130
#define IDR_KNOWN_INTERCEPTION_HTML 31131
#define IDR_KNOWN_INTERCEPTION_CSS 31132
#define IDR_KNOWN_INTERCEPTION_ICON_1X_PNG 31133
#define IDR_KNOWN_INTERCEPTION_ICON_2X_PNG 31134
#define IDR_SSL_ERROR_ASSISTANT_PB 31135
#define IDR_TRANSLATE_JS 31136
#define IDR_VERSION_UI_CSS 31137
#define IDR_VERSION_UI_HTML 31139
#define IDR_VERSION_UI_JS 31140
#define IDR_WEBAPP_DEFAULT_OFFLINE_HTML 31141

// ---------------------------------------------------------------------------
// From content_resources.h:

#define IDR_DEVTOOLS_PINCH_CURSOR_ICON 31300
#define IDR_DEVTOOLS_PINCH_CURSOR_ICON_2X 31301
#define IDR_DEVTOOLS_TOUCH_CURSOR_ICON 31302
#define IDR_DEVTOOLS_TOUCH_CURSOR_ICON_2X 31303
#define IDR_GEOMETRY_MOJOM_WEBUI_JS 31304
#define IDR_IMAGE_MOJOM_WEBUI_JS 31305
#define IDR_HISTOGRAMS_INTERNALS_HTML 31306
#define IDR_HISTOGRAMS_INTERNALS_JS 31307
#define IDR_HISTOGRAMS_INTERNALS_CSS 31308
#define IDR_ORIGIN_MOJO_WEBUI_JS 31310
#define IDR_RANGE_MOJOM_WEBUI_JS 31311
#define IDR_TOKEN_MOJO_WEBUI_JS 31312
#define IDR_UI_ACCELERATORS_MOJOM_WEBUI_JS 31313
#define IDR_UI_EVENT_MOJOM_WEBUI_JS 31314
#define IDR_UI_LATENCY_INFO_MOJOM_WEBUI_JS 31315
#define IDR_UI_WINDOW_OPEN_DISPOSITION_MOJO_WEBUI_JS 31317
#define IDR_UKM_INTERNALS_HTML 31318
#define IDR_UKM_INTERNALS_JS 31319
#define IDR_UKM_INTERNALS_CSS 31320
#define IDR_URL_MOJOM_WEBUI_JS 31323
#define IDR_VULKAN_INFO_MOJO_JS 31324
#define IDR_VULKAN_TYPES_MOJO_JS 31325

// ---------------------------------------------------------------------------
// From dev_ui_browser_resources.h:

#define IDR_ACCESSIBILITY_HTML 13500
#define IDR_ACCESSIBILITY_CSS 13501
#define IDR_ACCESSIBILITY_JS 13502
#define IDR_COMPONENTS_COMPONENTS_HTML 13503
#define IDR_COMPONENTS_COMPONENTS_JS 13504
#define IDR_DEVICE_LOG_UI_HTML 13505
#define IDR_DEVICE_LOG_UI_JS 13506
#define IDR_DEVICE_LOG_UI_CSS 13507
#define IDR_MEMORY_INTERNALS_HTML 13508
#define IDR_MEMORY_INTERNALS_JS 13509
#define IDR_PREDICTORS_AUTOCOMPLETE_ACTION_PREDICTOR_JS 13510
#define IDR_PREDICTORS_HTML 13511
#define IDR_PREDICTORS_JS 13512
#define IDR_PREDICTORS_RESOURCE_PREFETCH_PREDICTOR_JS 13513
#define IDR_SITE_ENGAGEMENT_HTML 13516
#define IDR_SITE_ENGAGEMENT_JS 13517
#define IDR_SITE_ENGAGEMENT_DETAILS_MOJOM_WEBUI_JS 13518
#define IDR_TRANSLATE_INTERNALS_CSS 13525
#define IDR_TRANSLATE_INTERNALS_HTML 13526
#define IDR_TRANSLATE_INTERNALS_JS 13527
#define IDR_WEB_APP_INTERNALS_HTML 13528

// ---------------------------------------------------------------------------
// From dev_ui_components_resources.h:

#define IDR_AUTOFILL_AND_PASSWORD_MANAGER_INTERNALS_HTML 20120
#define IDR_AUTOFILL_AND_PASSWORD_MANAGER_INTERNALS_JS 20121
#define IDR_CRASH_CRASHES_HTML 20122
#define IDR_CRASH_CRASHES_JS 20123
#define IDR_CRASH_CRASHES_CSS 20124
#define IDR_CRASH_SADTAB_SVG 20125
#define IDR_GCM_DRIVER_GCM_INTERNALS_HTML 20126
#define IDR_GCM_DRIVER_GCM_INTERNALS_CSS 20127
#define IDR_GCM_DRIVER_GCM_INTERNALS_JS 20128
#define IDR_LOCAL_STATE_HTML 20129
#define IDR_LOCAL_STATE_JS 20130
#define IDR_NET_LOG_NET_EXPORT_CSS 20131
#define IDR_NET_LOG_NET_EXPORT_HTML 20132
#define IDR_NET_LOG_NET_EXPORT_JS 20133
#define IDR_NTP_TILES_INTERNALS_HTML 20134
#define IDR_NTP_TILES_INTERNALS_JS 20135
#define IDR_NTP_TILES_INTERNALS_CSS 20136
#define IDR_POLICY_CSS 20137
#define IDR_POLICY_HTML 20138
#define IDR_POLICY_BASE_JS 20139
#define IDR_POLICY_JS 20140
#define IDR_POLICY_POLICY_CONFLICT_HTML_JS 20141
#define IDR_POLICY_POLICY_CONFLICT_JS 20142
#define IDR_POLICY_POLICY_PRECEDENCE_ROW_HTML_JS 20143
#define IDR_POLICY_POLICY_PRECEDENCE_ROW_JS 20144
#define IDR_POLICY_POLICY_ROW_HTML_JS 20145
#define IDR_POLICY_POLICY_ROW_JS 20146
#define IDR_POLICY_POLICY_TABLE_HTML_JS 20147
#define IDR_POLICY_POLICY_TABLE_JS 20148
#define IDR_POLICY_STATUS_BOX_HTML_JS 20149
#define IDR_POLICY_STATUS_BOX_JS 20150
#define IDR_SECURITY_INTERSTITIAL_UI_HTML 20151
#define IDR_SIGNIN_INTERNALS_INDEX_HTML 20152
#define IDR_SIGNIN_INTERNALS_INDEX_CSS 20153
#define IDR_SIGNIN_INTERNALS_INDEX_JS 20154
#define IDR_USER_ACTIONS_CSS 20155
#define IDR_USER_ACTIONS_HTML 20156
#define IDR_USER_ACTIONS_JS 20157

// ---------------------------------------------------------------------------
// From dev_ui_content_resources.h:

#define IDR_AGGREGATION_SERVICE_INTERNALS_HTML 20260
#define IDR_AGGREGATION_SERVICE_INTERNALS_JS 20261
#define IDR_AGGREGATION_SERVICE_INTERNALS_TABLE_MODEL_JS 20262
#define IDR_AGGREGATION_SERVICE_INTERNALS_TABLE_JS 20263
#define IDR_AGGREGATION_SERVICE_INTERNALS_TABLE_HTML_JS 20264
#define IDR_AGGREGATION_SERVICE_INTERNALS_CSS 20265
#define IDR_AGGREGATION_SERVICE_INTERNALS_MOJOM_JS 20266
#define IDR_ATTRIBUTION_INTERNALS_HTML 20267
#define IDR_ATTRIBUTION_INTERNALS_JS 20268
#define IDR_ATTRIBUTION_INTERNALS_TABLE_MODEL_JS 20269
#define IDR_ATTRIBUTION_INTERNALS_TABLE_JS 20270
#define IDR_ATTRIBUTION_INTERNALS_TABLE_HTML_JS 20271
#define IDR_ATTRIBUTION_INTERNALS_CSS 20272
#define IDR_ATTRIBUTION_INTERNALS_MOJOM_JS 20273
#define IDR_ATTRIBUTION_REPORTING_MOJOM_JS 20274
#define IDR_GPU_BROWSER_BRIDGE_JS 20275
#define IDR_GPU_INTERNALS_HTML 20276
#define IDR_GPU_INTERNALS_JS 20277
#define IDR_GPU_INTERNALS_INFO_VIEW_HTML_JS 20278
#define IDR_GPU_INTERNALS_INFO_VIEW_JS 20279
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_HTML_JS 20280
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_JS 20281
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_ROW_HTML_JS 20282
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_ROW_JS 20283
#define IDR_GPU_VULKAN_INFO_JS 20284
#define IDR_NETWORK_ERROR_LISTING_HTML 20285
#define IDR_NETWORK_ERROR_LISTING_JS 20286
#define IDR_NETWORK_ERROR_LISTING_CSS 20287
#define IDR_PROCESS_INTERNALS_HTML 20288
#define IDR_PROCESS_INTERNALS_MOJO_JS 20289
#define IDR_PROCESS_INTERNALS_CSS 20290
#define IDR_PROCESS_INTERNALS_JS 20291
#define IDR_SERVICE_WORKER_INTERNALS_HTML 20292
#define IDR_SERVICE_WORKER_INTERNALS_JS 20293
#define IDR_SERVICE_WORKER_INTERNALS_CSS 20294
#define IDR_SOURCE_REGISTRATION_ERROR_MOJOM_JS 20295

// ---------------------------------------------------------------------------
// From devtools_resources.h:

#define COMPRESSED_PROTOCOL_JSON 41200
#define IMAGES_IMAGES_JS 41201
#define IMAGES_ACCELEROMETER_BACK_SVG 41202
#define IMAGES_ACCELEROMETER_BOTTOM_PNG 41203
#define IMAGES_ACCELEROMETER_FRONT_SVG 41204
#define IMAGES_ACCELEROMETER_LEFT_PNG 41205
#define IMAGES_ACCELEROMETER_RIGHT_PNG 41206
#define IMAGES_ACCELEROMETER_TOP_PNG 41207
#define IMAGES_ACCESSIBILITY_ICON_SVG 41208
#define IMAGES_ADD_ICON_SVG 41209
#define IMAGES_ALIGN_CONTENT_CENTER_ICON_SVG 41210
#define IMAGES_ALIGN_CONTENT_END_ICON_SVG 41211
#define IMAGES_ALIGN_CONTENT_SPACE_AROUND_ICON_SVG 41212
#define IMAGES_ALIGN_CONTENT_SPACE_BETWEEN_ICON_SVG 41213
#define IMAGES_ALIGN_CONTENT_SPACE_EVENLY_ICON_SVG 41214
#define IMAGES_ALIGN_CONTENT_START_ICON_SVG 41215
#define IMAGES_ALIGN_CONTENT_STRETCH_ICON_SVG 41216
#define IMAGES_ALIGN_ITEMS_CENTER_ICON_SVG 41217
#define IMAGES_ALIGN_ITEMS_FLEX_END_ICON_SVG 41218
#define IMAGES_ALIGN_ITEMS_FLEX_START_ICON_SVG 41219
#define IMAGES_ALIGN_ITEMS_STRETCH_ICON_SVG 41220
#define IMAGES_ALIGN_SELF_CENTER_ICON_SVG 41221
#define IMAGES_ALIGN_SELF_FLEX_END_ICON_SVG 41222
#define IMAGES_ALIGN_SELF_FLEX_START_ICON_SVG 41223
#define IMAGES_ALIGN_SELF_STRETCH_ICON_SVG 41224
#define IMAGES_BASELINE_ICON_SVG 41225
#define IMAGES_CHECKBOXCHECKMARK_SVG 41226
#define IMAGES_CHECKER_PNG 41227
#define IMAGES_CHEVRONS_SVG 41228
#define IMAGES_CHROMEDISABLEDSELECT_PNG 41229
#define IMAGES_CHROMEDISABLEDSELECT_2X_PNG 41230
#define IMAGES_CHROMELEFT_AVIF 41231
#define IMAGES_CHROMEMIDDLE_AVIF 41232
#define IMAGES_CHROMERIGHT_AVIF 41233
#define IMAGES_CHROMESELECT_SVG 41234
#define IMAGES_CHROMESELECTDARK_SVG 41235
#define IMAGES_CIRCLED_BACKSLASH_ICON_SVG 41236
#define IMAGES_CIRCLED_EXCLAMATION_ICON_SVG 41237
#define IMAGES_CLEAR_WARNING_ICON_SVG 41238
#define IMAGES_CLOSE_ICON_SVG 41239
#define IMAGES_COPY_ICON_SVG 41240
#define IMAGES_CSSOVERVIEW_ICONS_2X_AVIF 41241
#define IMAGES_DROPDOWN_7X6_ICON_SVG 41242
#define IMAGES_EDIT_ICON_SVG 41243
#define IMAGES_ELEMENTS_PANEL_ICON_SVG 41244
#define IMAGES_ERRORWAVE_SVG 41245
#define IMAGES_ERROR_ICON_SVG 41246
#define IMAGES_FEEDBACK_BUTTON_ICON_SVG 41247
#define IMAGES_FILE_SYNC_ICON_SVG 41248
#define IMAGES_FILE_ICON_SVG 41249
#define IMAGES_FLEX_DIRECTION_ICON_SVG 41250
#define IMAGES_FLEX_NOWRAP_ICON_SVG 41251
#define IMAGES_FLEX_WRAP_ICON_SVG 41252
#define IMAGES_FRAME_EMBEDDED_ICON_SVG 41253
#define IMAGES_FRAME_ICON_SVG 41254
#define IMAGES_HELP_OUTLINE_SVG 41255
#define IMAGES_IC_CHANGES_SVG 41256
#define IMAGES_IC_CHECKMARK_16X16_SVG 41257
#define IMAGES_IC_COMMAND_GO_TO_LINE_SVG 41258
#define IMAGES_IC_COMMAND_GO_TO_SYMBOL_SVG 41259
#define IMAGES_IC_COMMAND_HELP_SVG 41260
#define IMAGES_IC_COMMAND_OPEN_FILE_SVG 41261
#define IMAGES_IC_COMMAND_RUN_COMMAND_SVG 41262
#define IMAGES_IC_COMMAND_RUN_SNIPPET_SVG 41263
#define IMAGES_IC_DELETE_FILTER_SVG 41264
#define IMAGES_IC_DELETE_LIST_SVG 41265
#define IMAGES_IC_DIMENSION_SINGLE_SVG 41266
#define IMAGES_IC_FILE_DEFAULT_SVG 41267
#define IMAGES_IC_FILE_DOCUMENT_SVG 41268
#define IMAGES_IC_FILE_FONT_SVG 41269
#define IMAGES_IC_FILE_IMAGE_SVG 41270
#define IMAGES_IC_FILE_SCRIPT_SVG 41271
#define IMAGES_IC_FILE_SNIPPET_SVG 41272
#define IMAGES_IC_FILE_STYLESHEET_SVG 41273
#define IMAGES_IC_FILE_WEBBUNDLE_SVG 41274
#define IMAGES_IC_FILE_WEBBUNDLE_INNER_REQUEST_SVG 41275
#define IMAGES_IC_FOLDER_DEFAULT_SVG 41276
#define IMAGES_IC_FOLDER_LOCAL_SVG 41277
#define IMAGES_IC_FOLDER_NETWORK_SVG 41278
#define IMAGES_IC_INFO_BLACK_18DP_SVG 41279
#define IMAGES_IC_LAYERS_16X16_SVG 41280
#define IMAGES_IC_MEMORY_16X16_SVG 41281
#define IMAGES_IC_PAGE_NEXT_16X16_ICON_SVG 41282
#define IMAGES_IC_PAGE_PREV_16X16_ICON_SVG 41283
#define IMAGES_IC_PREVIEW_FEATURE_SVG 41284
#define IMAGES_IC_REDO_16X16_ICON_SVG 41285
#define IMAGES_IC_RENDERING_SVG 41286
#define IMAGES_IC_REQUEST_RESPONSE_SVG 41287
#define IMAGES_IC_RESPONSE_SVG 41288
#define IMAGES_IC_SHOW_NODE_16X16_SVG 41289
#define IMAGES_IC_SOURCES_AUTHORED_SVG 41290
#define IMAGES_IC_SOURCES_DEPLOYED_SVG 41291
#define IMAGES_IC_SUGGEST_COLOR_SVG 41292
#define IMAGES_IC_UNDO_16X16_ICON_SVG 41293
#define IMAGES_IC_WARNING_BLACK_18DP_SVG 41294
#define IMAGES_INFO_ICON_SVG 41295
#define IMAGES_ISSUE_CROSS_ICON_SVG 41296
#define IMAGES_ISSUE_EXCLAMATION_ICON_SVG 41297
#define IMAGES_ISSUE_QUESTIONMARK_ICON_SVG 41298
#define IMAGES_ISSUE_TEXT_ICON_SVG 41299
#define IMAGES_JUSTIFY_CONTENT_CENTER_ICON_SVG 41300
#define IMAGES_JUSTIFY_CONTENT_FLEX_END_ICON_SVG 41301
#define IMAGES_JUSTIFY_CONTENT_FLEX_START_ICON_SVG 41302
#define IMAGES_JUSTIFY_CONTENT_SPACE_AROUND_ICON_SVG 41303
#define IMAGES_JUSTIFY_CONTENT_SPACE_BETWEEN_ICON_SVG 41304
#define IMAGES_JUSTIFY_CONTENT_SPACE_EVENLY_ICON_SVG 41305
#define IMAGES_JUSTIFY_ITEMS_CENTER_ICON_SVG 41306
#define IMAGES_JUSTIFY_ITEMS_END_ICON_SVG 41307
#define IMAGES_JUSTIFY_ITEMS_START_ICON_SVG 41308
#define IMAGES_JUSTIFY_ITEMS_STRETCH_ICON_SVG 41309
#define IMAGES_LARGEICONS_SVG 41310
#define IMAGES_LIGHTHOUSE_LOGO_SVG 41311
#define IMAGES_LINK_ICON_SVG 41312
#define IMAGES_MEDIUMICONS_SVG 41313
#define IMAGES_MINUS_ICON_SVG 41314
#define IMAGES_NAVIGATIONCONTROLS_PNG 41315
#define IMAGES_NAVIGATIONCONTROLS_2X_PNG 41316
#define IMAGES_NETWORK_CONDITIONS_ICON_SVG 41317
#define IMAGES_NETWORK_PANEL_ICON_SVG 41318
#define IMAGES_NODEICON_AVIF 41319
#define IMAGES_NODE_SEARCH_ICON_SVG 41320
#define IMAGES_PLUS_ICON_SVG 41321
#define IMAGES_POPOVERARROWS_PNG 41322
#define IMAGES_PREVIEW_FEATURE_VIDEO_THUMBNAIL_SVG 41323
#define IMAGES_PROFILEGROUPICON_PNG 41324
#define IMAGES_PROFILEICON_PNG 41325
#define IMAGES_PROFILESMALLICON_PNG 41326
#define IMAGES_REFRESH_12X12_ICON_SVG 41327
#define IMAGES_RESIZEDIAGONAL_SVG 41328
#define IMAGES_RESIZEHORIZONTAL_SVG 41329
#define IMAGES_RESIZEVERTICAL_SVG 41330
#define IMAGES_RESOURCESTIMEGRAPHICON_AVIF 41331
#define IMAGES_SEARCHNEXT_PNG 41332
#define IMAGES_SEARCHPREV_PNG 41333
#define IMAGES_SECURITYICONS_SVG 41334
#define IMAGES_SETTINGS_14X14_ICON_SVG 41335
#define IMAGES_SMALLICONS_SVG 41336
#define IMAGES_SOURCES_PANEL_ICON_SVG 41337
#define IMAGES_SPEECH_PNG 41338
#define IMAGES_STAR_OUTLINE_SVG 41339
#define IMAGES_SURVEY_FEEDBACK_ICON_SVG 41340
#define IMAGES_SWITCHERICON_SVG 41341
#define IMAGES_THREE_DOTS_MENU_ICON_SVG 41342
#define IMAGES_TOOLBARRESIZERVERTICAL_PNG 41343
#define IMAGES_TOUCHCURSOR_PNG 41344
#define IMAGES_TOUCHCURSOR_2X_PNG 41345
#define IMAGES_TRASH_BIN_ICON_SVG 41346
#define IMAGES_TRASH_BIN_MATERIAL_ICON_SVG 41347
#define IMAGES_TREEOUTLINETRIANGLES_SVG 41348
#define IMAGES_TRIANGLE_COLLAPSED_SVG 41349
#define IMAGES_TRIANGLE_EXPANDED_SVG 41350
#define IMAGES_WARNING_ICON_SVG 41351
#define IMAGES_WHATSNEW_AVIF 41352
#define TESTS_JS 41353
#define CORE_COMMON_COMMON_LEGACY_JS 41354
#define CORE_COMMON_COMMON_JS 41355
#define CORE_DOM_EXTENSION_DOM_EXTENSION_JS 41356
#define CORE_HOST_HOST_LEGACY_JS 41357
#define CORE_HOST_HOST_JS 41358
#define CORE_I18N_I18N_JS 41359
#define CORE_I18N_LOCALES_EN_US_JSON 41360
#define CORE_I18N_LOCALES_ZH_JSON 41361
#define CORE_PLATFORM_PLATFORM_JS 41362
#define CORE_PROTOCOL_CLIENT_PROTOCOL_CLIENT_LEGACY_JS 41363
#define CORE_PROTOCOL_CLIENT_PROTOCOL_CLIENT_JS 41364
#define CORE_ROOT_ROOT_LEGACY_JS 41365
#define CORE_ROOT_ROOT_JS 41366
#define CORE_SDK_SDK_LEGACY_JS 41367
#define CORE_SDK_SDK_META_JS 41368
#define CORE_SDK_SDK_JS 41369
#define DEVICE_MODE_EMULATION_FRAME_HTML 41370
#define DEVTOOLS_APP_HTML 41371
#define DEVTOOLS_COMPATIBILITY_JS 41372
#define EMULATED_DEVICES_OPTIMIZED_MOTOG4_LANDSCAPE_AVIF 41373
#define EMULATED_DEVICES_OPTIMIZED_MOTOG4_PORTRAIT_AVIF 41374
#define EMULATED_DEVICES_OPTIMIZED_NEXUS5X_LANDSCAPE_AVIF 41375
#define EMULATED_DEVICES_OPTIMIZED_NEXUS5X_PORTRAIT_AVIF 41376
#define EMULATED_DEVICES_OPTIMIZED_NEXUS6P_LANDSCAPE_AVIF 41377
#define EMULATED_DEVICES_OPTIMIZED_NEXUS6P_PORTRAIT_AVIF 41378
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEST_HUB_HORIZONTAL_AVIF 41379
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEST_HUB_MAX_HORIZONTAL_AVIF 41380
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_DEFAULT_1X_AVIF 41381
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_DEFAULT_2X_AVIF 41382
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_KEYBOARD_1X_AVIF 41383
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_KEYBOARD_2X_AVIF 41384
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_NAVIGATION_1X_AVIF 41385
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_NAVIGATION_2X_AVIF 41386
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_DEFAULT_1X_AVIF 41387
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_DEFAULT_2X_AVIF 41388
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_KEYBOARD_1X_AVIF 41389
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_KEYBOARD_2X_AVIF 41390
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_NAVIGATION_1X_AVIF 41391
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_NAVIGATION_2X_AVIF 41392
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_DEFAULT_1X_AVIF 41393
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_DEFAULT_2X_AVIF 41394
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_KEYBOARD_1X_AVIF 41395
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_KEYBOARD_2X_AVIF 41396
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_NAVIGATION_1X_AVIF 41397
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_NAVIGATION_2X_AVIF 41398
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_DEFAULT_1X_AVIF 41399
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_DEFAULT_2X_AVIF 41400
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_KEYBOARD_1X_AVIF 41401
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_KEYBOARD_2X_AVIF 41402
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_NAVIGATION_1X_AVIF 41403
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_NAVIGATION_2X_AVIF 41404
#define EMULATED_DEVICES_OPTIMIZED_IPAD_LANDSCAPE_AVIF 41405
#define EMULATED_DEVICES_OPTIMIZED_IPAD_PORTRAIT_AVIF 41406
#define EMULATED_DEVICES_OPTIMIZED_IPHONE5_LANDSCAPE_AVIF 41407
#define EMULATED_DEVICES_OPTIMIZED_IPHONE5_PORTRAIT_AVIF 41408
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6_LANDSCAPE_AVIF 41409
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6_PORTRAIT_AVIF 41410
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6PLUS_LANDSCAPE_AVIF 41411
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6PLUS_PORTRAIT_AVIF 41412
#define ENTRYPOINTS_DEVICE_MODE_EMULATION_FRAME_DEVICE_MODE_EMULATION_FRAME_JS 41413
#define ENTRYPOINTS_DEVTOOLS_APP_DEVTOOLS_APP_JS 41414
#define ENTRYPOINTS_FORMATTER_WORKER_FORMATTERACTIONS_JS 41415
#define ENTRYPOINTS_FORMATTER_WORKER_FORMATTER_WORKER_ENTRYPOINT_JS 41416
#define ENTRYPOINTS_FORMATTER_WORKER_FORMATTER_WORKER_JS 41417
#define ENTRYPOINTS_HEAP_SNAPSHOT_WORKER_HEAP_SNAPSHOT_WORKER_ENTRYPOINT_JS 41418
#define ENTRYPOINTS_HEAP_SNAPSHOT_WORKER_HEAP_SNAPSHOT_WORKER_LEGACY_JS 41419
#define ENTRYPOINTS_HEAP_SNAPSHOT_WORKER_HEAP_SNAPSHOT_WORKER_JS 41420
#define ENTRYPOINTS_INSPECTOR_INSPECTOR_JS 41421
#define ENTRYPOINTS_INSPECTOR_MAIN_INSPECTOR_MAIN_META_JS 41422
#define ENTRYPOINTS_INSPECTOR_MAIN_INSPECTOR_MAIN_JS 41423
#define ENTRYPOINTS_JS_APP_JS_APP_JS 41424
#define ENTRYPOINTS_LIGHTHOUSE_WORKER_LIGHTHOUSE_WORKER_JS 41425
#define ENTRYPOINTS_MAIN_MAIN_LEGACY_JS 41426
#define ENTRYPOINTS_MAIN_MAIN_META_JS 41427
#define ENTRYPOINTS_MAIN_MAIN_JS 41428
#define ENTRYPOINTS_NDB_APP_NDB_APP_JS 41429
#define ENTRYPOINTS_NODE_APP_NODE_APP_JS 41430
#define ENTRYPOINTS_SHELL_SHELL_JS 41431
#define ENTRYPOINTS_WASMPARSER_WORKER_WASMPARSER_WORKER_ENTRYPOINT_JS 41432
#define ENTRYPOINTS_WASMPARSER_WORKER_WASMPARSER_WORKER_JS 41433
#define ENTRYPOINTS_WORKER_APP_WORKER_APP_JS 41434
#define INSPECTOR_HTML 41435
#define INTEGRATION_TEST_RUNNER_HTML 41436
#define JS_APP_HTML 41437
#define LEGACY_TEST_RUNNER_LEGACY_TEST_RUNNER_JS 41438
#define LEGACY_TEST_RUNNER_TEST_RUNNER_TEST_RUNNER_JS 41439
#define MODELS_BINDINGS_BINDINGS_LEGACY_JS 41440
#define MODELS_BINDINGS_BINDINGS_JS 41441
#define MODELS_EMULATION_EMULATION_JS 41442
#define MODELS_EXTENSIONS_EXTENSIONS_LEGACY_JS 41443
#define MODELS_EXTENSIONS_EXTENSIONS_JS 41444
#define MODELS_FORMATTER_FORMATTER_LEGACY_JS 41445
#define MODELS_FORMATTER_FORMATTER_JS 41446
#define MODELS_HAR_HAR_JS 41447
#define MODELS_HEAP_SNAPSHOT_MODEL_HEAP_SNAPSHOT_MODEL_LEGACY_JS 41448
#define MODELS_HEAP_SNAPSHOT_MODEL_HEAP_SNAPSHOT_MODEL_JS 41449
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCOOPSANDBOXEDIFRAMECANNOTNAVIGATETOCOOPPAGE_MD 41450
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCORPNOTSAMEORIGIN_MD 41451
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCORPNOTSAMEORIGINAFTERDEFAULTEDTOSAMEORIGINBYCOEP_MD 41452
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCORPNOTSAMESITE_MD 41453
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPFRAMERESOURCENEEDSCOEPHEADER_MD 41454
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COMPATIBILITYMODEQUIRKS_MD 41455
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COOKIEATTRIBUTEVALUEEXCEEDSMAXSIZE_MD 41456
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_LOWTEXTCONTRAST_MD 41457
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEEXCLUDECONTEXTDOWNGRADEREAD_MD 41458
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEEXCLUDECONTEXTDOWNGRADESET_MD 41459
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEEXCLUDENAVIGATIONCONTEXTDOWNGRADE_MD 41460
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEINVALIDSAMEPARTY_MD 41461
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREERRORREAD_MD 41462
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREERRORSET_MD 41463
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREWARNREAD_MD 41464
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREWARNSET_MD 41465
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDLAXALLOWUNSAFEREAD_MD 41466
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDLAXALLOWUNSAFESET_MD 41467
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDTREATEDASLAXREAD_MD 41468
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDTREATEDASLAXSET_MD 41469
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEWARNCROSSDOWNGRADEREAD_MD 41470
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEWARNCROSSDOWNGRADESET_MD 41471
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEWARNSTRICTLAXDOWNGRADESTRICT_MD 41472
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_TWADIGITALASSETLINKSFAILED_MD 41473
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_TWAHTTPERROR_MD 41474
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_TWAPAGEUNAVAILABLEOFFLINE_MD 41475
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARINSECURECONTEXT_MD 41476
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARINVALIDELIGIBLEHEADER_MD 41477
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARINVALIDREGISTERSOURCEHEADER_MD 41478
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARINVALIDREGISTERTRIGGERHEADER_MD 41479
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARPERMISSIONPOLICYDISABLED_MD 41480
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARPERMISSIONPOLICYNOTDELEGATED_MD 41481
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARSOURCEANDTRIGGERHEADERS_MD 41482
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARSOURCEIGNORED_MD 41483
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARTRIGGERIGNORED_MD 41484
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARUNTRUSTWORTHYREPORTINGORIGIN_MD 41485
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CLIENTHINTMETATAGALLOWLISTINVALIDORIGIN_MD 41486
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CLIENTHINTMETATAGMODIFIEDHTML_MD 41487
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COOKIEEXCLUDEDOMAINNONASCII_MD 41488
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COOKIEWARNDOMAINNONASCII_MD 41489
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSALLOWCREDENTIALSREQUIRED_MD 41490
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSDISABLEDSCHEME_MD 41491
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSDISALLOWEDBYMODE_MD 41492
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSHEADERDISALLOWEDBYPREFLIGHTRESPONSE_MD 41493
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSINSECUREPRIVATENETWORK_MD 41494
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSINVALIDHEADERVALUES_MD 41495
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSMETHODDISALLOWEDBYPREFLIGHTRESPONSE_MD 41496
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSNOCORSREDIRECTMODENOTFOLLOW_MD 41497
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSORIGINMISMATCH_MD 41498
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSPREFLIGHTALLOWPRIVATENETWORKERROR_MD 41499
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSPREFLIGHTRESPONSEINVALID_MD 41500
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSREDIRECTCONTAINSCREDENTIALS_MD 41501
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSWILDCARDORIGINNOTALLOWED_MD 41502
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPEVALVIOLATION_MD 41503
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPINLINEVIOLATION_MD 41504
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPTRUSTEDTYPESPOLICYVIOLATION_MD 41505
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPTRUSTEDTYPESSINKVIOLATION_MD 41506
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPURLVIOLATION_MD 41507
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_DEPRECATION_MD 41508
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_DEPRECATIONNAVIGATORUSERAGENT_MD 41509
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTACCOUNTSHTTPNOTFOUND_MD 41510
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTACCOUNTSINVALIDRESPONSE_MD 41511
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTACCOUNTSNORESPONSE_MD 41512
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTAPPROVALDECLINED_MD 41513
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCANCELED_MD 41514
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCLIENTMETADATAHTTPNOTFOUND_MD 41515
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCLIENTMETADATAINVALIDRESPONSE_MD 41516
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCLIENTMETADATANORESPONSE_MD 41517
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTERRORFETCHINGSIGNIN_MD 41518
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTERRORIDTOKEN_MD 41519
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENHTTPNOTFOUND_MD 41520
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENINVALIDREQUEST_MD 41521
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENINVALIDRESPONSE_MD 41522
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENNORESPONSE_MD 41523
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTINVALIDSIGNINRESPONSE_MD 41524
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTMANIFESTHTTPNOTFOUND_MD 41525
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTMANIFESTINVALIDRESPONSE_MD 41526
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTMANIFESTNORESPONSE_MD 41527
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTTOOMANYREQUESTS_MD 41528
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_GENERICCROSSORIGINPORTALPOSTMESSAGEERROR_MD 41529
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_HEAVYAD_MD 41530
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_MIXEDCONTENT_MD 41531
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SHAREDARRAYBUFFER_MD 41532
#define MODELS_ISSUES_MANAGER_ISSUES_MANAGER_JS 41533
#define MODELS_JAVASCRIPT_METADATA_JAVASCRIPT_METADATA_JS 41534
#define MODELS_LOGS_LOGS_META_JS 41535
#define MODELS_LOGS_LOGS_JS 41536
#define MODELS_PERSISTENCE_PERSISTENCE_LEGACY_JS 41537
#define MODELS_PERSISTENCE_PERSISTENCE_META_JS 41538
#define MODELS_PERSISTENCE_PERSISTENCE_JS 41539
#define MODELS_SOURCE_MAP_SCOPES_SOURCE_MAP_SCOPES_JS 41540
#define MODELS_TEXT_UTILS_TEXT_UTILS_LEGACY_JS 41541
#define MODELS_TEXT_UTILS_TEXT_UTILS_JS 41542
#define MODELS_TIMELINE_MODEL_TIMELINE_MODEL_LEGACY_JS 41543
#define MODELS_TIMELINE_MODEL_TIMELINE_MODEL_JS 41544
#define MODELS_WORKSPACE_WORKSPACE_LEGACY_JS 41545
#define MODELS_WORKSPACE_WORKSPACE_JS 41546
#define MODELS_WORKSPACE_DIFF_WORKSPACE_DIFF_LEGACY_JS 41547
#define MODELS_WORKSPACE_DIFF_WORKSPACE_DIFF_JS 41548
#define NDB_APP_HTML 41549
#define NODE_APP_HTML 41550
#define PANELS_ACCESSIBILITY_ACCESSIBILITY_LEGACY_JS 41551
#define PANELS_ACCESSIBILITY_ACCESSIBILITY_META_JS 41552
#define PANELS_ACCESSIBILITY_ACCESSIBILITY_JS 41553
#define PANELS_ANIMATION_ANIMATION_LEGACY_JS 41554
#define PANELS_ANIMATION_ANIMATION_META_JS 41555
#define PANELS_ANIMATION_ANIMATION_JS 41556
#define PANELS_APPLICATION_APPLICATION_LEGACY_JS 41557
#define PANELS_APPLICATION_APPLICATION_META_JS 41558
#define PANELS_APPLICATION_APPLICATION_JS 41559
#define PANELS_APPLICATION_COMPONENTS_COMPONENTS_JS 41560
#define PANELS_APPLICATION_PRELOADING_COMPONENTS_COMPONENTS_JS 41561
#define PANELS_BROWSER_DEBUGGER_BROWSER_DEBUGGER_LEGACY_JS 41562
#define PANELS_BROWSER_DEBUGGER_BROWSER_DEBUGGER_META_JS 41563
#define PANELS_BROWSER_DEBUGGER_BROWSER_DEBUGGER_JS 41564
#define PANELS_CHANGES_CHANGES_LEGACY_JS 41565
#define PANELS_CHANGES_CHANGES_META_JS 41566
#define PANELS_CHANGES_CHANGES_JS 41567
#define PANELS_CONSOLE_CONSOLE_LEGACY_JS 41568
#define PANELS_CONSOLE_CONSOLE_META_JS 41569
#define PANELS_CONSOLE_CONSOLE_JS 41570
#define PANELS_CONSOLE_COUNTERS_CONSOLE_COUNTERS_META_JS 41571
#define PANELS_CONSOLE_COUNTERS_CONSOLE_COUNTERS_JS 41572
#define PANELS_COVERAGE_COVERAGE_LEGACY_JS 41573
#define PANELS_COVERAGE_COVERAGE_META_JS 41574
#define PANELS_COVERAGE_COVERAGE_JS 41575
#define PANELS_CSS_OVERVIEW_COMPONENTS_COMPONENTS_JS 41576
#define PANELS_CSS_OVERVIEW_CSS_OVERVIEW_META_JS 41577
#define PANELS_CSS_OVERVIEW_CSS_OVERVIEW_JS 41578
#define PANELS_DEVELOPER_RESOURCES_DEVELOPER_RESOURCES_META_JS 41579
#define PANELS_DEVELOPER_RESOURCES_DEVELOPER_RESOURCES_JS 41580
#define PANELS_ELEMENTS_COMPONENTS_COMPONENTS_JS 41581
#define PANELS_ELEMENTS_ELEMENTS_LEGACY_JS 41582
#define PANELS_ELEMENTS_ELEMENTS_META_JS 41583
#define PANELS_ELEMENTS_ELEMENTS_JS 41584
#define PANELS_EMULATION_COMPONENTS_COMPONENTS_JS 41585
#define PANELS_EMULATION_EMULATION_LEGACY_JS 41586
#define PANELS_EMULATION_EMULATION_META_JS 41587
#define PANELS_EMULATION_EMULATION_JS 41588
#define PANELS_EVENT_LISTENERS_EVENT_LISTENERS_JS 41589
#define PANELS_ISSUES_COMPONENTS_COMPONENTS_JS 41590
#define PANELS_ISSUES_ISSUES_META_JS 41591
#define PANELS_ISSUES_ISSUES_JS 41592
#define PANELS_JS_PROFILER_JS_PROFILER_META_JS 41593
#define PANELS_JS_PROFILER_JS_PROFILER_JS 41594
#define PANELS_LAYER_VIEWER_LAYER_VIEWER_LEGACY_JS 41595
#define PANELS_LAYER_VIEWER_LAYER_VIEWER_META_JS 41596
#define PANELS_LAYER_VIEWER_LAYER_VIEWER_JS 41597
#define PANELS_LAYERS_LAYERS_META_JS 41598
#define PANELS_LAYERS_LAYERS_JS 41599
#define PANELS_LIGHTHOUSE_LIGHTHOUSE_LEGACY_JS 41600
#define PANELS_LIGHTHOUSE_LIGHTHOUSE_META_JS 41601
#define PANELS_LIGHTHOUSE_LIGHTHOUSE_JS 41602
#define PANELS_MEDIA_MEDIA_META_JS 41603
#define PANELS_MEDIA_MEDIA_JS 41604
#define PANELS_MOBILE_THROTTLING_MOBILE_THROTTLING_LEGACY_JS 41605
#define PANELS_MOBILE_THROTTLING_MOBILE_THROTTLING_META_JS 41606
#define PANELS_MOBILE_THROTTLING_MOBILE_THROTTLING_JS 41607
#define PANELS_NETWORK_COMPONENTS_COMPONENTS_JS 41608
#define PANELS_NETWORK_FORWARD_FORWARD_JS 41609
#define PANELS_NETWORK_NETWORK_LEGACY_JS 41610
#define PANELS_NETWORK_NETWORK_META_JS 41611
#define PANELS_NETWORK_NETWORK_JS 41612
#define PANELS_PERFORMANCE_MONITOR_PERFORMANCE_MONITOR_META_JS 41613
#define PANELS_PERFORMANCE_MONITOR_PERFORMANCE_MONITOR_JS 41614
#define PANELS_PROFILER_PROFILER_LEGACY_JS 41615
#define PANELS_PROFILER_PROFILER_META_JS 41616
#define PANELS_PROFILER_PROFILER_JS 41617
#define PANELS_PROTOCOL_MONITOR_PROTOCOL_MONITOR_META_JS 41618
#define PANELS_PROTOCOL_MONITOR_PROTOCOL_MONITOR_JS 41619
#define PANELS_SCREENCAST_SCREENCAST_META_JS 41620
#define PANELS_SCREENCAST_SCREENCAST_JS 41621
#define PANELS_SEARCH_SEARCH_LEGACY_JS 41622
#define PANELS_SEARCH_SEARCH_JS 41623
#define PANELS_SECURITY_SECURITY_LEGACY_JS 41624
#define PANELS_SECURITY_SECURITY_META_JS 41625
#define PANELS_SECURITY_SECURITY_JS 41626
#define PANELS_SENSORS_SENSORS_META_JS 41627
#define PANELS_SENSORS_SENSORS_JS 41628
#define PANELS_SETTINGS_COMPONENTS_COMPONENTS_JS 41629
#define PANELS_SETTINGS_EMULATION_COMPONENTS_COMPONENTS_JS 41630
#define PANELS_SETTINGS_EMULATION_EMULATION_META_JS 41631
#define PANELS_SETTINGS_EMULATION_EMULATION_JS 41632
#define PANELS_SETTINGS_EMULATION_UTILS_UTILS_JS 41633
#define PANELS_SETTINGS_SETTINGS_LEGACY_JS 41634
#define PANELS_SETTINGS_SETTINGS_META_JS 41635
#define PANELS_SETTINGS_SETTINGS_JS 41636
#define PANELS_SNIPPETS_SNIPPETS_LEGACY_JS 41637
#define PANELS_SNIPPETS_SNIPPETS_JS 41638
#define PANELS_SOURCES_COMPONENTS_COMPONENTS_JS 41639
#define PANELS_SOURCES_SOURCES_LEGACY_JS 41640
#define PANELS_SOURCES_SOURCES_META_JS 41641
#define PANELS_SOURCES_SOURCES_JS 41642
#define PANELS_TIMELINE_COMPONENTS_COMPONENTS_JS 41643
#define PANELS_TIMELINE_TIMELINE_LEGACY_JS 41644
#define PANELS_TIMELINE_TIMELINE_META_JS 41645
#define PANELS_TIMELINE_TIMELINE_JS 41646
#define PANELS_UTILS_UTILS_JS 41647
#define PANELS_WEB_AUDIO_GRAPH_VISUALIZER_GRAPH_VISUALIZER_JS 41648
#define PANELS_WEB_AUDIO_WEB_AUDIO_LEGACY_JS 41649
#define PANELS_WEB_AUDIO_WEB_AUDIO_META_JS 41650
#define PANELS_WEB_AUDIO_WEB_AUDIO_JS 41651
#define PANELS_WEBAUTHN_WEBAUTHN_META_JS 41652
#define PANELS_WEBAUTHN_WEBAUTHN_JS 41653
#define SERVICES_PUPPETEER_PUPPETEER_JS 41654
#define SERVICES_WINDOW_BOUNDS_WINDOW_BOUNDS_JS 41655
#define THIRD_PARTY_ACORN_ACORN_JS 41656
#define THIRD_PARTY_CHROMIUM_CLIENT_VARIATIONS_CLIENT_VARIATIONS_JS 41657
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_CODEMIRROR_JS 41658
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_CPP_JS 41659
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_JAVA_JS 41660
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_JSON_JS 41661
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_LEGACY_JS 41662
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_MARKDOWN_JS 41663
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_PHP_JS 41664
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_PYTHON_JS 41665
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_SVELTE_JS 41666
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_WAST_JS 41667
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_XML_JS 41668
#define THIRD_PARTY_CODEMIRROR_NEXT_CODEMIRROR_NEXT_JS 41669
#define THIRD_PARTY_DIFF_DIFF_LEGACY_JS 41670
#define THIRD_PARTY_DIFF_DIFF_JS 41671
#define THIRD_PARTY_I18N_I18N_JS 41672
#define THIRD_PARTY_INTL_MESSAGEFORMAT_INTL_MESSAGEFORMAT_JS 41673
#define THIRD_PARTY_LIGHTHOUSE_LIGHTHOUSE_DT_BUNDLE_JS 41674
#define THIRD_PARTY_LIGHTHOUSE_REPORT_REPORT_JS 41675
#define THIRD_PARTY_LIT_LIT_JS 41676
#define THIRD_PARTY_MARKED_MARKED_JS 41677
#define THIRD_PARTY_PUPPETEER_PUPPETEER_JS 41678
#define THIRD_PARTY_WASMPARSER_WASMPARSER_JS 41679
#define UI_COMPONENTS_ADORNERS_ADORNERS_JS 41680
#define UI_COMPONENTS_BUTTONS_BUTTONS_JS 41681
#define UI_COMPONENTS_CHROME_LINK_CHROME_LINK_JS 41682
#define UI_COMPONENTS_CODE_HIGHLIGHTER_CODE_HIGHLIGHTER_JS 41683
#define UI_COMPONENTS_DATA_GRID_DATA_GRID_JS 41684
#define UI_COMPONENTS_DIFF_VIEW_DIFF_VIEW_JS 41685
#define UI_COMPONENTS_EXPANDABLE_LIST_EXPANDABLE_LIST_JS 41686
#define UI_COMPONENTS_HELPERS_HELPERS_JS 41687
#define UI_COMPONENTS_ICON_BUTTON_ICON_BUTTON_JS 41688
#define UI_COMPONENTS_INPUT_INPUT_JS 41689
#define UI_COMPONENTS_ISSUE_COUNTER_ISSUE_COUNTER_JS 41690
#define UI_COMPONENTS_LINEAR_MEMORY_INSPECTOR_LINEAR_MEMORY_INSPECTOR_META_JS 41691
#define UI_COMPONENTS_LINEAR_MEMORY_INSPECTOR_LINEAR_MEMORY_INSPECTOR_JS 41692
#define UI_COMPONENTS_LINKIFIER_LINKIFIER_JS 41693
#define UI_COMPONENTS_MARKDOWN_VIEW_MARKDOWN_VIEW_JS 41694
#define UI_COMPONENTS_NODE_TEXT_NODE_TEXT_JS 41695
#define UI_COMPONENTS_PANEL_FEEDBACK_PANEL_FEEDBACK_JS 41696
#define UI_COMPONENTS_PANEL_INTRODUCTION_STEPS_PANEL_INTRODUCTION_STEPS_JS 41697
#define UI_COMPONENTS_RENDER_COORDINATOR_RENDER_COORDINATOR_JS 41698
#define UI_COMPONENTS_REPORT_VIEW_REPORT_VIEW_JS 41699
#define UI_COMPONENTS_REQUEST_LINK_ICON_REQUEST_LINK_ICON_JS 41700
#define UI_COMPONENTS_SETTINGS_SETTINGS_JS 41701
#define UI_COMPONENTS_SURVEY_LINK_SURVEY_LINK_JS 41702
#define UI_COMPONENTS_TEXT_EDITOR_TEXT_EDITOR_JS 41703
#define UI_COMPONENTS_TEXT_PROMPT_TEXT_PROMPT_JS 41704
#define UI_COMPONENTS_TREE_OUTLINE_TREE_OUTLINE_JS 41705
#define UI_COMPONENTS_TWO_STATES_COUNTER_TWO_STATES_COUNTER_JS 41706
#define UI_LEGACY_COMPONENTS_COLOR_PICKER_COLOR_PICKER_LEGACY_JS 41707
#define UI_LEGACY_COMPONENTS_COLOR_PICKER_COLOR_PICKER_JS 41708
#define UI_LEGACY_COMPONENTS_COOKIE_TABLE_COOKIE_TABLE_LEGACY_JS 41709
#define UI_LEGACY_COMPONENTS_COOKIE_TABLE_COOKIE_TABLE_JS 41710
#define UI_LEGACY_COMPONENTS_DATA_GRID_DATA_GRID_LEGACY_JS 41711
#define UI_LEGACY_COMPONENTS_DATA_GRID_DATA_GRID_JS 41712
#define UI_LEGACY_COMPONENTS_INLINE_EDITOR_INLINE_EDITOR_LEGACY_JS 41713
#define UI_LEGACY_COMPONENTS_INLINE_EDITOR_INLINE_EDITOR_JS 41714
#define UI_LEGACY_COMPONENTS_OBJECT_UI_OBJECT_UI_LEGACY_JS 41715
#define UI_LEGACY_COMPONENTS_OBJECT_UI_OBJECT_UI_META_JS 41716
#define UI_LEGACY_COMPONENTS_OBJECT_UI_OBJECT_UI_JS 41717
#define UI_LEGACY_COMPONENTS_PERF_UI_PERF_UI_LEGACY_JS 41718
#define UI_LEGACY_COMPONENTS_PERF_UI_PERF_UI_META_JS 41719
#define UI_LEGACY_COMPONENTS_PERF_UI_PERF_UI_JS 41720
#define UI_LEGACY_COMPONENTS_QUICK_OPEN_QUICK_OPEN_LEGACY_JS 41721
#define UI_LEGACY_COMPONENTS_QUICK_OPEN_QUICK_OPEN_META_JS 41722
#define UI_LEGACY_COMPONENTS_QUICK_OPEN_QUICK_OPEN_JS 41723
#define UI_LEGACY_COMPONENTS_SOURCE_FRAME_SOURCE_FRAME_LEGACY_JS 41724
#define UI_LEGACY_COMPONENTS_SOURCE_FRAME_SOURCE_FRAME_META_JS 41725
#define UI_LEGACY_COMPONENTS_SOURCE_FRAME_SOURCE_FRAME_JS 41726
#define UI_LEGACY_COMPONENTS_UTILS_UTILS_LEGACY_JS 41727
#define UI_LEGACY_COMPONENTS_UTILS_UTILS_JS 41728
#define UI_LEGACY_LEGACY_LEGACY_JS 41729
#define UI_LEGACY_LEGACY_JS 41730
#define UI_LEGACY_THEME_SUPPORT_THEME_SUPPORT_JS 41731
#define UI_LEGACY_UTILS_UTILS_JS 41732
#define UI_LIT_HTML_LIT_HTML_JS 41733
#define WORKER_APP_HTML 41734

// ---------------------------------------------------------------------------
// From extensions_browser_resources.h:

#define IDR_APP_DEFAULT_ICON 34570
#define IDR_EXTENSION_DEFAULT_ICON 34571
#define IDR_EXTENSION_ACTION_PLAIN_BACKGROUND 34572
#define IDR_EXTENSION_ICON_PLAIN_BACKGROUND 34573
#define IDR_EXTENSIONS_FAVICON 257

// ---------------------------------------------------------------------------
// From extensions_renderer_resources.h:

#define IDR_APP_VIEW_JS 34590
#define IDR_APP_VIEW_DENY_JS 34591
#define IDR_APP_VIEW_ELEMENT_JS 34592
#define IDR_BROWSER_TEST_ENVIRONMENT_SPECIFIC_BINDINGS_JS 34593
#define IDR_ENTRY_ID_MANAGER 34594
#define IDR_EXTENSIONS_WEB_VIEW_ELEMENT_JS 34595
#define IDR_EXTENSION_OPTIONS_JS 34596
#define IDR_EXTENSION_OPTIONS_ELEMENT_JS 34597
#define IDR_EXTENSION_OPTIONS_ATTRIBUTES_JS 34598
#define IDR_EXTENSION_OPTIONS_CONSTANTS_JS 34599
#define IDR_EXTENSION_OPTIONS_EVENTS_JS 34600
#define IDR_FEEDBACK_PRIVATE_CUSTOM_BINDINGS_JS 34601
#define IDR_GUEST_VIEW_ATTRIBUTES_JS 34602
#define IDR_GUEST_VIEW_CONTAINER_JS 34603
#define IDR_GUEST_VIEW_CONTAINER_ELEMENT_JS 34604
#define IDR_GUEST_VIEW_DENY_JS 34605
#define IDR_GUEST_VIEW_EVENTS_JS 34606
#define IDR_GUEST_VIEW_JS 34607
#define IDR_IMAGE_UTIL_JS 34608
#define IDR_KEEP_ALIVE_JS 34609
#define IDR_KEEP_ALIVE_MOJOM_JS 34610
#define IDR_MIME_HANDLER_PRIVATE_CUSTOM_BINDINGS_JS 34611
#define IDR_MIME_HANDLER_MOJOM_JS 34612
#define IDR_SAFE_METHODS_JS 34613
#define IDR_SET_ICON_JS 34614
#define IDR_TEST_CUSTOM_BINDINGS_JS 34615
#define IDR_UNCAUGHT_EXCEPTION_HANDLER_JS 34616
#define IDR_UTILS_JS 34617
#define IDR_WEB_VIEW_ACTION_REQUESTS_JS 34618
#define IDR_WEB_VIEW_API_METHODS_JS 34619
#define IDR_WEB_VIEW_ATTRIBUTES_JS 34620
#define IDR_WEB_VIEW_CONSTANTS_JS 34621
#define IDR_WEB_VIEW_EVENTS_JS 34622
#define IDR_WEB_VIEW_INTERNAL_CUSTOM_BINDINGS_JS 34623
#define IDR_WEB_VIEW_JS 34624
#define IDR_WEB_VIEW_DENY_JS 34625
#define IDR_WEB_VIEW_ELEMENT_JS 34626
#define IDR_AUTOMATION_CUSTOM_BINDINGS_JS 34627
#define IDR_AUTOMATION_EVENT_JS 34628
#define IDR_AUTOMATION_NODE_JS 34629
#define IDR_AUTOMATION_TREE_CACHE_JS 34630
#define IDR_APP_RUNTIME_CUSTOM_BINDINGS_JS 34631
#define IDR_APP_WINDOW_CUSTOM_BINDINGS_JS 34632
#define IDR_CONTEXT_MENUS_CUSTOM_BINDINGS_JS 34633
#define IDR_CONTEXT_MENUS_HANDLERS_JS 34634
#define IDR_DECLARATIVE_WEBREQUEST_CUSTOM_BINDINGS_JS 34635
#define IDR_FILE_ENTRY_BINDING_UTIL_JS 34636
#define IDR_FILE_SYSTEM_CUSTOM_BINDINGS_JS 34637
#define IDR_GREASEMONKEY_API_JS 34638
#define IDR_MOJO_PRIVATE_CUSTOM_BINDINGS_JS 34639
#define IDR_PERMISSIONS_CUSTOM_BINDINGS_JS 34640
#define IDR_PRINTER_PROVIDER_CUSTOM_BINDINGS_JS 34641
#define IDR_SERVICE_WORKER_BINDINGS_JS 34642
#define IDR_WEB_REQUEST_CUSTOM_BINDINGS_JS 34643
#define IDR_WEB_REQUEST_EVENT_JS 34644
#define IDR_WEB_VIEW_REQUEST_CUSTOM_BINDINGS_JS 34645
#define IDR_PLATFORM_APP_JS 34646
#define IDR_EXTENSION_FONTS_CSS 34647
#define IDR_PLATFORM_APP_CSS 34660
#define IDR_EXTENSION_CSS 34661

// ---------------------------------------------------------------------------
// From extensions_resources.h:

#define IDR_EXTENSION_API_FEATURES 34580

// ---------------------------------------------------------------------------
// From mojo_bindings_resources.h:

#define IDR_MOJO_MOJO_BINDINGS_JS 34760
#define IDR_MOJO_BINDINGS_JS 34761
#define IDR_MOJO_BIG_BUFFER_MOJOM_WEBUI_JS 34765
#define IDR_MOJO_FILE_MOJOM_WEBUI_JS 34766
#define IDR_MOJO_FILE_PATH_MOJOM_WEBUI_JS 34767
#define IDR_MOJO_INT128_MOJOM_WEBUI_JS 34768
#define IDR_MOJO_READ_ONLY_BUFFER_MOJOM_WEBUI_JS 34769
#define IDR_MOJO_SAFE_BASE_NAME_MOJOM_WEBUI_JS 34770
#define IDR_MOJO_STRING16_MOJOM_WEBUI_JS 34772
#define IDR_MOJO_TEXT_DIRECTION_MOJOM_WEBUI_JS 34775
#define IDR_MOJO_TOKEN_MOJOM_WEBUI_JS 34776
#define IDR_MOJO_UNGUESSABLE_TOKEN_MOJOM_WEBUI_JS 34777
#define IDR_MOJO_PROCESS_ID_MOJOM_WEBUI_JS 34778
#define IDR_MOJO_TIME_MOJOM_WEBUI_JS 34779

// ---------------------------------------------------------------------------
// From net_resources.h:

#define IDR_DIR_HEADER_HTML 34790

// ---------------------------------------------------------------------------
// From pdf_resources.h:

#define IDR_PDF_BROWSER_API_JS 16410
#define IDR_PDF_MAIN_JS 16411
#define IDR_PDF_INDEX_CSS 16412
#define IDR_PDF_INDEX_HTML 16413
#define IDR_PDF_PDF_VIEWER_WRAPPER_ROLLUP_JS 16414
#define IDR_PDF_PDF_INTERNAL_PLUGIN_WRAPPER_ROLLUP_JS 16415

// ---------------------------------------------------------------------------
// From renderer_resources.h:

#define IDR_BLOCKED_PLUGIN_HTML 20590
#define IDR_DISABLED_PLUGIN_HTML 20591
#define IDR_PDF_PLUGIN_HTML 20592
#define IDR_CART_PRODUCT_EXTRACTION_JS 20593
#define IDR_CART_DOMAIN_PRODUCT_ID_REGEX_JSON 20594
#define IDR_SKIP_ADD_TO_CART_REQUEST_DOMAIN_MAPPING_JSON 20595
#define IDR_PURCHASE_URL_REGEX_DOMAIN_MAPPING_JSON 20596
#define IDR_ACTION_CUSTOM_BINDINGS_JS 20597
#define IDR_BROWSER_ACTION_CUSTOM_BINDINGS_JS 20598
#define IDR_CHROME_WEB_VIEW_INTERNAL_CUSTOM_BINDINGS_JS 20599
#define IDR_CHROME_WEB_VIEW_JS 20600
#define IDR_DECLARATIVE_CONTENT_CUSTOM_BINDINGS_JS 20601
#define IDR_DESKTOP_CAPTURE_CUSTOM_BINDINGS_JS 20602
#define IDR_DEVELOPER_PRIVATE_CUSTOM_BINDINGS_JS 20603
#define IDR_DOWNLOADS_CUSTOM_BINDINGS_JS 20604
#define IDR_GCM_CUSTOM_BINDINGS_JS 20605
#define IDR_IDENTITY_CUSTOM_BINDINGS_JS 20606
#define IDR_IMAGE_WRITER_PRIVATE_CUSTOM_BINDINGS_JS 20607
#define IDR_INPUT_IME_CUSTOM_BINDINGS_JS 20608
#define IDR_MEDIA_GALLERIES_CUSTOM_BINDINGS_JS 20609
#define IDR_NOTIFICATIONS_CUSTOM_BINDINGS_JS 20610
#define IDR_OMNIBOX_CUSTOM_BINDINGS_JS 20611
#define IDR_PAGE_ACTION_CUSTOM_BINDINGS_JS 20612
#define IDR_PAGE_CAPTURE_CUSTOM_BINDINGS_JS 20613
#define IDR_SYNC_FILE_SYSTEM_CUSTOM_BINDINGS_JS 20614
#define IDR_SYSTEM_INDICATOR_CUSTOM_BINDINGS_JS 20615
#define IDR_TAB_CAPTURE_CUSTOM_BINDINGS_JS 20616
#define IDR_TTS_CUSTOM_BINDINGS_JS 20617
#define IDR_TTS_ENGINE_CUSTOM_BINDINGS_JS 20618
#define IDR_WEBRTC_DESKTOP_CAPTURE_PRIVATE_CUSTOM_BINDINGS_JS 20619
#define IDR_WEBRTC_LOGGING_PRIVATE_CUSTOM_BINDINGS_JS 20620

// ---------------------------------------------------------------------------
// From tracing_proto_resources.h:

#define chrome_track_event_descriptor 34500

// ---------------------------------------------------------------------------
// From tracing_resources.h:

#define IDR_TRACING_ABOUT_TRACING_HTML 31360
#define IDR_TRACING_ABOUT_TRACING_JS 31361

// ---------------------------------------------------------------------------
// From ui_resources.h:

#define IDR_ALIAS_CURSOR 39299
#define IDR_CELL_CURSOR 39300
#define IDR_EAST_RESIZE_CURSOR 39301
#define IDR_EASTWEST_RESIZE_CURSOR 39302
#define IDR_HELP_CURSOR 39303
#define IDR_LINK_CURSOR 39304
#define IDR_MOVE_CURSOR 39305
#define IDR_NONE_CURSOR 39306
#define IDR_NORTHEAST_RESIZE_CURSOR 39307
#define IDR_NORTHEASTSOUTHWEST_RESIZE_CURSOR 39308
#define IDR_NORTH_RESIZE_CURSOR 39309
#define IDR_NORTHSOUTH_RESIZE_CURSOR 39310
#define IDR_NORTHWEST_RESIZE_CURSOR 39311
#define IDR_NORTHWESTSOUTHEAST_RESIZE_CURSOR 39312
#define IDR_PROGRESS_CURSOR 39313
#define IDR_SOUTHEAST_RESIZE_CURSOR 39314
#define IDR_SOUTH_RESIZE_CURSOR 39315
#define IDR_SOUTHWEST_RESIZE_CURSOR 39316
#define IDR_VERTICALTEXT_CURSOR 39317
#define IDR_WAIT_CURSOR 39318
#define IDR_WEST_RESIZE_CURSOR 39319
#define IDR_ZOOMIN_CURSOR 39320
#define IDR_ZOOMOUT_CURSOR 39321
#define IDR_CLOSE_2 39322
#define IDR_CLOSE_2_H 39323
#define IDR_CLOSE_2_P 39324
#define IDR_CLOSE_DIALOG 39325
#define IDR_CLOSE_DIALOG_H 39326
#define IDR_CLOSE_DIALOG_P 39327
#define IDR_DISABLE 39328
#define IDR_DISABLE_H 39329
#define IDR_DISABLE_P 39330
#define IDR_DEFAULT_FAVICON 263
#define IDR_DEFAULT_FAVICON_DARK 39331
#define IDR_DEFAULT_FAVICON_32 39332
#define IDR_DEFAULT_FAVICON_DARK_32 39333
#define IDR_DEFAULT_FAVICON_64 39334
#define IDR_DEFAULT_FAVICON_DARK_64 39335
#define IDR_FINGERPRINT_COMPLETE_CHECK_DARK 39336
#define IDR_FINGERPRINT_COMPLETE_CHECK_LIGHT 39337
#define IDR_FINGERPRINT_ICON_ANIMATION_DARK 39338
#define IDR_FINGERPRINT_ICON_ANIMATION_LIGHT 39339
#define IDR_FOLDER_CLOSED 314
#define IDR_FOLDER_CLOSED_WHITE 315
#define IDR_FOLDER_OPEN 39340
#define IDR_SIGNAL_0_BAR 39341
#define IDR_SIGNAL_1_BAR 39342
#define IDR_SIGNAL_2_BAR 39343
#define IDR_SIGNAL_3_BAR 39344
#define IDR_SIGNAL_4_BAR 39345
#define IDR_TOUCH_DRAG_TIP_COPY 39349
#define IDR_TOUCH_DRAG_TIP_MOVE 39350
#define IDR_TOUCH_DRAG_TIP_LINK 39351
#define IDR_TOUCH_DRAG_TIP_NODROP 39352

// ---------------------------------------------------------------------------
// From views_resources.h:

#define IDR_APP_TOP_CENTER 40050
#define IDR_APP_TOP_LEFT 40051
#define IDR_APP_TOP_RIGHT 40052
#define IDR_CLOSE 40053
#define IDR_CLOSE_H 40054
#define IDR_CLOSE_P 40055
#define IDR_CONTENT_BOTTOM_CENTER 40056
#define IDR_CONTENT_BOTTOM_LEFT_CORNER 40057
#define IDR_CONTENT_BOTTOM_RIGHT_CORNER 40058
#define IDR_CONTENT_LEFT_SIDE 40059
#define IDR_CONTENT_RIGHT_SIDE 40060
#define IDR_FRAME 40061
#define IDR_FRAME_INACTIVE 40062
#define IDR_MAXIMIZE 40063
#define IDR_MAXIMIZE_H 40064
#define IDR_MAXIMIZE_P 40065
#define IDR_MINIMIZE 40066
#define IDR_MINIMIZE_H 40067
#define IDR_MINIMIZE_P 40068
#define IDR_RESTORE 40069
#define IDR_RESTORE_H 40070
#define IDR_RESTORE_P 40071
#define IDR_TEXTBUTTON_HOVER_BOTTOM 40072
#define IDR_TEXTBUTTON_HOVER_BOTTOM_LEFT 40073
#define IDR_TEXTBUTTON_HOVER_BOTTOM_RIGHT 40074
#define IDR_TEXTBUTTON_HOVER_CENTER 40075
#define IDR_TEXTBUTTON_HOVER_LEFT 40076
#define IDR_TEXTBUTTON_HOVER_RIGHT 40077
#define IDR_TEXTBUTTON_HOVER_TOP 40078
#define IDR_TEXTBUTTON_HOVER_TOP_LEFT 40079
#define IDR_TEXTBUTTON_HOVER_TOP_RIGHT 40080
#define IDR_TEXTBUTTON_PRESSED_BOTTOM 40081
#define IDR_TEXTBUTTON_PRESSED_BOTTOM_LEFT 40082
#define IDR_TEXTBUTTON_PRESSED_BOTTOM_RIGHT 40083
#define IDR_TEXTBUTTON_PRESSED_CENTER 40084
#define IDR_TEXTBUTTON_PRESSED_LEFT 40085
#define IDR_TEXTBUTTON_PRESSED_RIGHT 40086
#define IDR_TEXTBUTTON_PRESSED_TOP 40087
#define IDR_TEXTBUTTON_PRESSED_TOP_LEFT 40088
#define IDR_TEXTBUTTON_PRESSED_TOP_RIGHT 40089
#define IDR_WINDOW_BOTTOM_CENTER 40090
#define IDR_WINDOW_BOTTOM_LEFT_CORNER 40091
#define IDR_WINDOW_BOTTOM_RIGHT_CORNER 40092
#define IDR_WINDOW_LEFT_SIDE 40093
#define IDR_WINDOW_RIGHT_SIDE 40094
#define IDR_WINDOW_TOP_CENTER 40095
#define IDR_WINDOW_TOP_LEFT_CORNER 40096
#define IDR_WINDOW_TOP_RIGHT_CORNER 40097

// ---------------------------------------------------------------------------
// From webrtc_internals_resources.h:

#define IDR_WEBRTC_INTERNALS_CANDIDATE_GRID_JS 20230
#define IDR_WEBRTC_INTERNALS_DATA_SERIES_JS 20231
#define IDR_WEBRTC_INTERNALS_DUMP_CREATOR_JS 20232
#define IDR_WEBRTC_INTERNALS_PEER_CONNECTION_UPDATE_TABLE_JS 20233
#define IDR_WEBRTC_INTERNALS_SSRC_INFO_MANAGER_JS 20234
#define IDR_WEBRTC_INTERNALS_STATS_GRAPH_HELPER_JS 20235
#define IDR_WEBRTC_INTERNALS_STATS_HELPER_JS 20236
#define IDR_WEBRTC_INTERNALS_STATS_RATES_CALCULATOR_JS 20237
#define IDR_WEBRTC_INTERNALS_STATS_TABLE_JS 20238
#define IDR_WEBRTC_INTERNALS_TAB_VIEW_JS 20239
#define IDR_WEBRTC_INTERNALS_TIMELINE_GRAPH_VIEW_JS 20240
#define IDR_WEBRTC_INTERNALS_USER_MEDIA_JS 20241
#define IDR_WEBRTC_INTERNALS_WEBRTC_INTERNALS_HTML 20242
#define IDR_WEBRTC_INTERNALS_WEBRTC_INTERNALS_CSS 20243
#define IDR_WEBRTC_INTERNALS_WEBRTC_INTERNALS_JS 20244

// ---------------------------------------------------------------------------
// From webui_generated_resources.h:

#define IDR_WEBUI_CSS_ACTION_LINK_CSS 40140
#define IDR_WEBUI_CSS_BUTTER_BAR_CSS 40141
#define IDR_WEBUI_CSS_CHROME_SHARED_CSS 40142
#define IDR_WEBUI_CSS_LIST_CSS 40143
#define IDR_WEBUI_CSS_MENU_BUTTON_CSS 40144
#define IDR_WEBUI_CSS_MENU_CSS 40145
#define IDR_WEBUI_CSS_ROBOTO_CSS 40146
#define IDR_WEBUI_CSS_SPINNER_CSS 40147
#define IDR_WEBUI_CSS_TEXT_DEFAULTS_CSS 40148
#define IDR_WEBUI_CSS_TEXT_DEFAULTS_MD_CSS 40149
#define IDR_WEBUI_CSS_THROBBER_CSS 40150
#define IDR_WEBUI_CSS_WIDGETS_CSS 40151
#define IDR_WEBUI_CSS_MD_COLORS_CSS 40152
#define IDR_WEBUI_HTML_TEST_LOADER_HTML 40153
#define IDR_WEBUI_IMAGES_ADD_SVG 40154
#define IDR_WEBUI_IMAGES_CANCEL_RED_SVG 40155
#define IDR_WEBUI_IMAGES_CHECKBOX_BLACK_PNG 40156
#define IDR_WEBUI_IMAGES_CHECKBOX_WHITE_PNG 40157
#define IDR_WEBUI_IMAGES_CHECK_CIRCLE_GREEN_SVG 40158
#define IDR_WEBUI_IMAGES_CHECK_PNG 40159
#define IDR_WEBUI_IMAGES_DARK_ICON_SEARCH_SVG 40160
#define IDR_WEBUI_IMAGES_DISABLED_SELECT_PNG 40161
#define IDR_WEBUI_IMAGES_DROP_DOWN_ARROW_BLACK_SVG 40162
#define IDR_WEBUI_IMAGES_DROP_DOWN_ARROW_GRAY_SVG 40163
#define IDR_WEBUI_IMAGES_DROP_DOWN_ARROW_WHITE_SVG 40164
#define IDR_WEBUI_IMAGES_ERROR_SVG 40165
#define IDR_WEBUI_IMAGES_ICON_CANCEL_SVG 40166
#define IDR_WEBUI_IMAGES_ICON_COPY_CONTENT_SVG 40167
#define IDR_WEBUI_IMAGES_ICON_FILE_PNG 40168
#define IDR_WEBUI_IMAGES_ICON_REFRESH_SVG 40169
#define IDR_WEBUI_IMAGES_ICON_SEARCH_SVG 40170
#define IDR_WEBUI_IMAGES_OPEN_IN_NEW_SVG 40171
#define IDR_WEBUI_IMAGES_SELECT_PNG 40172
#define IDR_WEBUI_IMAGES_THROBBER_MEDIUM_SVG 40173
#define IDR_WEBUI_IMAGES_THROBBER_SMALL_DARK_SVG 40174
#define IDR_WEBUI_IMAGES_THROBBER_SMALL_SVG 40175
#define IDR_WEBUI_IMAGES_TREE_TRIANGLE_SVG 40176
#define IDR_WEBUI_IMAGES_2X_CHECKBOX_BLACK_PNG 40177
#define IDR_WEBUI_IMAGES_2X_CHECKBOX_WHITE_PNG 40178
#define IDR_WEBUI_IMAGES_2X_CHECK_PNG 40179
#define IDR_WEBUI_IMAGES_2X_DISABLED_SELECT_PNG 40180
#define IDR_WEBUI_IMAGES_2X_SELECT_PNG 40181
#define IDR_WEBUI_IMAGES_ARROW_DOWN_SVG 40182
#define IDR_WEBUI_IMAGES_ARROW_RIGHT_SVG 40183
#define IDR_WEBUI_IMAGES_BUSINESS_SVG 40184
#define IDR_WEBUI_IMAGES_CHROME_LOGO_DARK_SVG 40185
#define IDR_WEBUI_IMAGES_DARK_ARROW_DOWN_SVG 40186
#define IDR_WEBUI_IMAGES_ICON_ARROW_BACK_SVG 40187
#define IDR_WEBUI_IMAGES_ICON_ARROW_DROPDOWN_SVG 40188
#define IDR_WEBUI_IMAGES_ICON_BOOKMARK_SVG 40189
#define IDR_WEBUI_IMAGES_ICON_CLEAR_SVG 40190
#define IDR_WEBUI_IMAGES_ICON_CLOCK_SVG 40191
#define IDR_WEBUI_IMAGES_ICON_DELETE_GRAY_SVG 40192
#define IDR_WEBUI_IMAGES_ICON_EDIT_SVG 40193
#define IDR_WEBUI_IMAGES_ICON_EXPAND_LESS_SVG 40194
#define IDR_WEBUI_IMAGES_ICON_EXPAND_MORE_SVG 40195
#define IDR_WEBUI_IMAGES_ICON_FOLDER_OPEN_SVG 40196
#define IDR_WEBUI_IMAGES_ICON_JOURNEYS_SVG 40197
#define IDR_WEBUI_IMAGES_ICON_MORE_VERT_SVG 40198
#define IDR_WEBUI_IMAGES_ICON_PICTURE_DELETE_SVG 40199
#define IDR_WEBUI_IMAGES_ICON_SETTINGS_SVG 40200
#define IDR_WEBUI_IMAGES_ICON_VISIBILITY_OFF_SVG 40201
#define IDR_WEBUI_IMAGES_ICON_VISIBILITY_SVG 40202
#define IDR_WEBUI_JS_METRICS_REPORTER_METRICS_REPORTER_JS 40203
#define IDR_WEBUI_JS_METRICS_REPORTER_BROWSER_PROXY_JS 40204
#define IDR_WEBUI_JS_METRICS_REPORTER_METRICS_REPORTER_MOJOM_WEBUI_JS 40205
#define IDR_WEBUI_JS_LOAD_TIME_DATA_DEPRECATED_JS 40206
#define IDR_WEBUI_JS_BROWSER_COMMAND_PROXY_JS 40207
#define IDR_WEBUI_JS_BROWSER_COMMAND_MOJOM_WEBUI_JS 40208
#define IDR_WEBUI_CR_ELEMENTS_CR_TAB_BOX_CR_TAB_BOX_JS 40209
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_JS 40210
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_ITEM_JS 40211
#define IDR_WEBUI_CR_ELEMENTS_CR_TAB_BOX_CR_TAB_BOX_HTML_JS 40212
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_HTML_JS 40213
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_ITEM_HTML_JS 40214
#define IDR_WEBUI_CR_ELEMENTS_CR_LAZY_RENDER_CR_LAZY_RENDER_JS 40215
#define IDR_WEBUI_CR_ELEMENTS_CR_SPLITTER_CR_SPLITTER_JS 40216
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_BASE_JS 40217
#define IDR_WEBUI_CR_ELEMENTS_CR_AUTO_IMG_CR_AUTO_IMG_JS 40218
#define IDR_WEBUI_CR_ELEMENTS_CR_CONTAINER_SHADOW_MIXIN_JS 40219
#define IDR_WEBUI_CR_ELEMENTS_CR_MENU_SELECTOR_CR_MENU_SELECTOR_JS 40220
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_MIXIN_JS 40221
#define IDR_WEBUI_CR_ELEMENTS_CR_SCROLLABLE_MIXIN_JS 40222
#define IDR_WEBUI_CR_ELEMENTS_CR_SEARCH_FIELD_CR_SEARCH_FIELD_MIXIN_JS 40223
#define IDR_WEBUI_CR_ELEMENTS_FIND_SHORTCUT_MIXIN_JS 40224
#define IDR_WEBUI_CR_ELEMENTS_I18N_MIXIN_JS 40225
#define IDR_WEBUI_CR_ELEMENTS_LIST_PROPERTY_UPDATE_MIXIN_JS 40226
#define IDR_WEBUI_CR_ELEMENTS_MOUSE_HOVERABLE_MIXIN_JS 40227
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_POLICY_INDICATOR_MIXIN_JS 40228
#define IDR_WEBUI_CR_ELEMENTS_WEB_UI_LISTENER_MIXIN_JS 40229
#define IDR_WEBUI_CR_ELEMENTS_CR_A11Y_ANNOUNCER_CR_A11Y_ANNOUNCER_JS 40230
#define IDR_WEBUI_CR_ELEMENTS_CR_ACTION_MENU_CR_ACTION_MENU_JS 40231
#define IDR_WEBUI_CR_ELEMENTS_CR_BUTTON_CR_BUTTON_JS 40232
#define IDR_WEBUI_CR_ELEMENTS_CR_CHECKBOX_CR_CHECKBOX_JS 40233
#define IDR_WEBUI_CR_ELEMENTS_CR_DIALOG_CR_DIALOG_JS 40234
#define IDR_WEBUI_CR_ELEMENTS_CR_DRAWER_CR_DRAWER_JS 40235
#define IDR_WEBUI_CR_ELEMENTS_CR_EXPAND_BUTTON_CR_EXPAND_BUTTON_JS 40236
#define IDR_WEBUI_CR_ELEMENTS_CR_FINGERPRINT_CR_FINGERPRINT_PROGRESS_ARC_JS 40237
#define IDR_WEBUI_CR_ELEMENTS_CR_GRID_CR_GRID_JS 40238
#define IDR_WEBUI_CR_ELEMENTS_CR_ICON_BUTTON_CR_ICON_BUTTON_JS 40239
#define IDR_WEBUI_CR_ELEMENTS_CR_INPUT_CR_INPUT_JS 40240
#define IDR_WEBUI_CR_ELEMENTS_CR_LINK_ROW_CR_LINK_ROW_JS 40241
#define IDR_WEBUI_CR_ELEMENTS_CR_LOTTIE_CR_LOTTIE_JS 40242
#define IDR_WEBUI_CR_ELEMENTS_CR_TEXTAREA_CR_TEXTAREA_JS 40243
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_GRID_JS 40244
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_JS 40245
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_BUTTON_CR_CARD_RADIO_BUTTON_JS 40246
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_JS 40247
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_GROUP_CR_RADIO_GROUP_JS 40248
#define IDR_WEBUI_CR_ELEMENTS_CR_SEARCH_FIELD_CR_SEARCH_FIELD_JS 40249
#define IDR_WEBUI_CR_ELEMENTS_CR_SLIDER_CR_SLIDER_JS 40250
#define IDR_WEBUI_CR_ELEMENTS_CR_TABS_CR_TABS_JS 40251
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_MANAGER_JS 40252
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_JS 40253
#define IDR_WEBUI_CR_ELEMENTS_CR_TOGGLE_CR_TOGGLE_JS 40254
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_JS 40255
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SEARCH_FIELD_JS 40256
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SELECTION_OVERLAY_JS 40257
#define IDR_WEBUI_CR_ELEMENTS_CR_VIEW_MANAGER_CR_VIEW_MANAGER_JS 40258
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_POLICY_INDICATOR_JS 40259
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_POLICY_PREF_INDICATOR_JS 40260
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_TOOLTIP_ICON_JS 40261
#define IDR_WEBUI_CR_ELEMENTS_CR_A11Y_ANNOUNCER_CR_A11Y_ANNOUNCER_HTML_JS 40262
#define IDR_WEBUI_CR_ELEMENTS_CR_ACTION_MENU_CR_ACTION_MENU_HTML_JS 40263
#define IDR_WEBUI_CR_ELEMENTS_CR_BUTTON_CR_BUTTON_HTML_JS 40264
#define IDR_WEBUI_CR_ELEMENTS_CR_CHECKBOX_CR_CHECKBOX_HTML_JS 40265
#define IDR_WEBUI_CR_ELEMENTS_CR_DIALOG_CR_DIALOG_HTML_JS 40266
#define IDR_WEBUI_CR_ELEMENTS_CR_DRAWER_CR_DRAWER_HTML_JS 40267
#define IDR_WEBUI_CR_ELEMENTS_CR_EXPAND_BUTTON_CR_EXPAND_BUTTON_HTML_JS 40268
#define IDR_WEBUI_CR_ELEMENTS_CR_FINGERPRINT_CR_FINGERPRINT_PROGRESS_ARC_HTML_JS 40269
#define IDR_WEBUI_CR_ELEMENTS_CR_GRID_CR_GRID_HTML_JS 40270
#define IDR_WEBUI_CR_ELEMENTS_CR_ICON_BUTTON_CR_ICON_BUTTON_HTML_JS 40271
#define IDR_WEBUI_CR_ELEMENTS_CR_INPUT_CR_INPUT_HTML_JS 40272
#define IDR_WEBUI_CR_ELEMENTS_CR_LINK_ROW_CR_LINK_ROW_HTML_JS 40273
#define IDR_WEBUI_CR_ELEMENTS_CR_LOTTIE_CR_LOTTIE_HTML_JS 40274
#define IDR_WEBUI_CR_ELEMENTS_CR_TEXTAREA_CR_TEXTAREA_HTML_JS 40275
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_GRID_HTML_JS 40276
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_HTML_JS 40277
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_BUTTON_CR_CARD_RADIO_BUTTON_HTML_JS 40278
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_HTML_JS 40279
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_GROUP_CR_RADIO_GROUP_HTML_JS 40280
#define IDR_WEBUI_CR_ELEMENTS_CR_SEARCH_FIELD_CR_SEARCH_FIELD_HTML_JS 40281
#define IDR_WEBUI_CR_ELEMENTS_CR_SLIDER_CR_SLIDER_HTML_JS 40282
#define IDR_WEBUI_CR_ELEMENTS_CR_TABS_CR_TABS_HTML_JS 40283
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_MANAGER_HTML_JS 40284
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_HTML_JS 40285
#define IDR_WEBUI_CR_ELEMENTS_CR_TOGGLE_CR_TOGGLE_HTML_JS 40286
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_HTML_JS 40287
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SEARCH_FIELD_HTML_JS 40288
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SELECTION_OVERLAY_HTML_JS 40289
#define IDR_WEBUI_CR_ELEMENTS_CR_VIEW_MANAGER_CR_VIEW_MANAGER_HTML_JS 40290
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_POLICY_INDICATOR_HTML_JS 40291
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_POLICY_PREF_INDICATOR_HTML_JS 40292
#define IDR_WEBUI_CR_ELEMENTS_POLICY_CR_TOOLTIP_ICON_HTML_JS 40293
#define IDR_WEBUI_CR_ELEMENTS_CR_FINGERPRINT_CR_FINGERPRINT_ICONS_HTML_JS 40294
#define IDR_WEBUI_CR_ELEMENTS_ICONS_HTML_JS 40295
#define IDR_WEBUI_CR_ELEMENTS_MWB_SHARED_ICONS_HTML_JS 40296
#define IDR_WEBUI_CR_ELEMENTS_ACTION_LINK_CSS_JS 40297
#define IDR_WEBUI_CR_ELEMENTS_CR_ACTIONABLE_ROW_STYLE_CSS_JS 40298
#define IDR_WEBUI_CR_ELEMENTS_CR_HIDDEN_STYLE_CSS_JS 40299
#define IDR_WEBUI_CR_ELEMENTS_CR_ICONS_CSS_JS 40300
#define IDR_WEBUI_CR_ELEMENTS_CR_NAV_MENU_ITEM_STYLE_CSS_JS 40301
#define IDR_WEBUI_CR_ELEMENTS_CR_PAGE_HOST_STYLE_CSS_JS 40302
#define IDR_WEBUI_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_STYLE_CSS_JS 40303
#define IDR_WEBUI_CR_ELEMENTS_CR_SHARED_STYLE_CSS_JS 40304
#define IDR_WEBUI_CR_ELEMENTS_CR_SHARED_VARS_CSS_JS 40305
#define IDR_WEBUI_CR_ELEMENTS_MD_SELECT_CSS_JS 40306
#define IDR_WEBUI_CR_ELEMENTS_MWB_ELEMENT_SHARED_STYLE_CSS_JS 40307
#define IDR_WEBUI_CR_ELEMENTS_MWB_SHARED_STYLE_CSS_JS 40308
#define IDR_WEBUI_CR_ELEMENTS_MWB_SHARED_VARS_CSS_JS 40309
#define IDR_WEBUI_CR_ELEMENTS_SEARCH_HIGHLIGHT_STYLE_CSS_JS 40310
#define IDR_WEBUI_CR_ELEMENTS_CR_INPUT_CR_INPUT_STYLE_CSS_JS 40311
#define IDR_WEBUI_JS_ACTION_LINK_JS 40312
#define IDR_WEBUI_JS_ASSERT_TS_JS 40313
#define IDR_WEBUI_JS_COLOR_UTILS_JS 40314
#define IDR_WEBUI_JS_CR_JS 40315
#define IDR_WEBUI_JS_CUSTOM_ELEMENT_JS 40316
#define IDR_WEBUI_JS_DRAG_WRAPPER_JS 40317
#define IDR_WEBUI_JS_EVENT_TRACKER_JS 40318
#define IDR_WEBUI_JS_FOCUS_GRID_JS 40319
#define IDR_WEBUI_JS_FOCUS_ROW_JS 40320
#define IDR_WEBUI_JS_FOCUS_OUTLINE_MANAGER_JS 40321
#define IDR_WEBUI_JS_ICON_JS 40322
#define IDR_WEBUI_JS_KEYBOARD_SHORTCUT_LIST_JS 40323
#define IDR_WEBUI_JS_LOAD_TIME_DATA_JS 40324
#define IDR_WEBUI_JS_PARSE_HTML_SUBSET_JS 40325
#define IDR_WEBUI_JS_PROMISE_RESOLVER_JS 40326
#define IDR_WEBUI_JS_PLATFORM_JS 40327
#define IDR_WEBUI_JS_PLURAL_STRING_PROXY_JS 40328
#define IDR_WEBUI_JS_STATIC_TYPES_JS 40329
#define IDR_WEBUI_JS_STORE_TS_JS 40330
#define IDR_WEBUI_JS_TEST_LOADER_JS 40331
#define IDR_WEBUI_JS_TEST_LOADER_UTIL_JS 40332
#define IDR_WEBUI_JS_UTIL_TS_JS 40333
#define IDR_WEBUI_CR_COMPONENTS_LOCALIZED_LINK_LOCALIZED_LINK_HTML_JS 40334
#define IDR_WEBUI_CR_COMPONENTS_LOCALIZED_LINK_LOCALIZED_LINK_JS 40335
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_DIALOG_MANAGED_DIALOG_HTML_JS 40336
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_DIALOG_MANAGED_DIALOG_JS 40337
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_FOOTNOTE_MANAGED_FOOTNOTE_HTML_JS 40338
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_FOOTNOTE_MANAGED_FOOTNOTE_JS 40339
#define IDR_WEBUI_JS_FOCUS_ROW_MIXIN_JS 40340
#define IDR_WEBUI_JS_FOCUS_WITHOUT_INK_JS 40341
#define IDR_WEBUI_JS_SEARCH_HIGHLIGHT_UTILS_JS 40342
#define IDR_JSTEMPLATE_JSTEMPLATE_COMPILED_JS 40343
#define IDR_POLYMER_3_0_IRON_A11Y_ANNOUNCER_IRON_A11Y_ANNOUNCER_JS 40344
#define IDR_POLYMER_3_0_IRON_A11Y_KEYS_BEHAVIOR_IRON_A11Y_KEYS_BEHAVIOR_JS 40345
#define IDR_POLYMER_3_0_IRON_A11Y_KEYS_IRON_A11Y_KEYS_JS 40346
#define IDR_POLYMER_3_0_IRON_BEHAVIORS_IRON_BUTTON_STATE_JS 40347
#define IDR_POLYMER_3_0_IRON_BEHAVIORS_IRON_CONTROL_STATE_JS 40348
#define IDR_POLYMER_3_0_IRON_COLLAPSE_IRON_COLLAPSE_JS 40349
#define IDR_POLYMER_3_0_IRON_FIT_BEHAVIOR_IRON_FIT_BEHAVIOR_JS 40350
#define IDR_POLYMER_3_0_IRON_FLEX_LAYOUT_IRON_FLEX_LAYOUT_CLASSES_JS 40351
#define IDR_POLYMER_3_0_IRON_ICON_IRON_ICON_JS 40352
#define IDR_POLYMER_3_0_IRON_ICONSET_SVG_IRON_ICONSET_SVG_JS 40353
#define IDR_POLYMER_3_0_IRON_LIST_IRON_LIST_JS 40354
#define IDR_POLYMER_3_0_IRON_LOCATION_IRON_LOCATION_JS 40355
#define IDR_POLYMER_3_0_IRON_LOCATION_IRON_QUERY_PARAMS_JS 40356
#define IDR_POLYMER_3_0_IRON_MEDIA_QUERY_IRON_MEDIA_QUERY_JS 40357
#define IDR_POLYMER_3_0_IRON_META_IRON_META_JS 40358
#define IDR_POLYMER_3_0_IRON_PAGES_IRON_PAGES_JS 40359
#define IDR_POLYMER_3_0_IRON_RANGE_BEHAVIOR_IRON_RANGE_BEHAVIOR_JS 40360
#define IDR_POLYMER_3_0_IRON_RESIZABLE_BEHAVIOR_IRON_RESIZABLE_BEHAVIOR_JS 40361
#define IDR_POLYMER_3_0_IRON_SCROLL_TARGET_BEHAVIOR_IRON_SCROLL_TARGET_BEHAVIOR_JS 40362
#define IDR_POLYMER_3_0_IRON_SCROLL_THRESHOLD_IRON_SCROLL_THRESHOLD_JS 40363
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_MULTI_SELECTABLE_JS 40364
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_SELECTABLE_JS 40365
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_SELECTION_JS 40366
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_SELECTOR_JS 40367
#define IDR_POLYMER_3_0_IRON_TEST_HELPERS_MOCK_INTERACTIONS_JS 40368
#define IDR_POLYMER_3_0_PAPER_BEHAVIORS_PAPER_INKY_FOCUS_BEHAVIOR_JS 40369
#define IDR_POLYMER_3_0_PAPER_BEHAVIORS_PAPER_RIPPLE_BEHAVIOR_JS 40370
#define IDR_POLYMER_3_0_PAPER_PROGRESS_PAPER_PROGRESS_JS 40371
#define IDR_POLYMER_3_0_PAPER_RIPPLE_PAPER_RIPPLE_JS 40372
#define IDR_POLYMER_3_0_PAPER_SPINNER_PAPER_SPINNER_BEHAVIOR_JS 40373
#define IDR_POLYMER_3_0_PAPER_SPINNER_PAPER_SPINNER_LITE_JS 40374
#define IDR_POLYMER_3_0_PAPER_SPINNER_PAPER_SPINNER_STYLES_JS 40375
#define IDR_POLYMER_3_0_PAPER_STYLES_COLOR_JS 40376
#define IDR_POLYMER_3_0_PAPER_STYLES_SHADOW_JS 40377
#define IDR_POLYMER_3_0_PAPER_TOOLTIP_PAPER_TOOLTIP_JS 40378
#define IDR_POLYMER_3_0_POLYMER_POLYMER_BUNDLED_MIN_JS 40379
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_FILE_HANDLING_ITEM_JS 40380
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_MORE_PERMISSIONS_ITEM_JS 40381
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_ITEM_JS 40382
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_RUN_ON_OS_LOGIN_ITEM_JS 40383
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_TOGGLE_ROW_JS 40384
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_UNINSTALL_BUTTON_JS 40385
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_WINDOW_MODE_ITEM_JS 40386
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_CONSTANTS_JS 40387
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_CONSTANTS_JS 40388
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_UTIL_JS 40389
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_BROWSER_PROXY_JS 40390
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_UTIL_JS 40391
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_FILE_HANDLING_ITEM_HTML_JS 40392
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_MORE_PERMISSIONS_ITEM_HTML_JS 40393
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_ITEM_HTML_JS 40394
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_RUN_ON_OS_LOGIN_ITEM_HTML_JS 40395
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_TOGGLE_ROW_HTML_JS 40396
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_UNINSTALL_BUTTON_HTML_JS 40397
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_WINDOW_MODE_ITEM_HTML_JS 40398
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_ICONS_HTML_JS 40399
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_SHARED_STYLE_CSS_JS 40400
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_SHARED_VARS_CSS_JS 40401
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_WEBUI_JS 40402
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_TYPES_MOJOM_WEBUI_JS 40403
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_COLORIZE_SVG 40404
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_BRUSH_SVG 40405
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_CUSTOMIZE_THEMES_JS 40406
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_THEME_ICON_JS 40407
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_BROWSER_PROXY_JS 40408
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_CUSTOMIZE_THEMES_HTML_JS 40409
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_THEME_ICON_HTML_JS 40410
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_CUSTOMIZE_THEMES_MOJOM_WEBUI_JS 40411
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_JS 40412
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MIXIN_JS 40413
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_PROXY_JS 40414
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_CONTROLLER_JS 40415
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_HTML_JS 40416
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_ICONS_HTML_JS 40417
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_WEBUI_JS 40418
#define IDR_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_JS 40419
#define IDR_CR_COMPONENTS_MOST_VISITED_BROWSER_PROXY_JS 40420
#define IDR_CR_COMPONENTS_MOST_VISITED_WINDOW_PROXY_JS 40421
#define IDR_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_HTML_JS 40422
#define IDR_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_WEBUI_JS 40423
#define IDR_WEBUI_JS_BROWSER_COMMAND_BROWSER_COMMAND_PROXY_JS 40424
#define IDR_WEBUI_JS_BROWSER_COMMAND_BROWSER_COMMAND_MOJOM_WEBUI_JS 40425
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTER_JS 40426
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTERS_JS 40427
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTER_MENU_JS 40428
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_PAGE_FAVICON_JS 40429
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_SEARCH_QUERY_JS 40430
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_URL_VISIT_JS 40431
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_BROWSER_PROXY_JS 40432
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_METRICS_PROXY_JS 40433
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_UTILS_JS 40434
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_SHARED_STYLE_CSS_JS 40435
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_SHARED_VARS_CSS_JS 40436
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTER_HTML_JS 40437
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTERS_HTML_JS 40438
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTER_MENU_HTML_JS 40439
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_PAGE_FAVICON_HTML_JS 40440
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_SEARCH_QUERY_HTML_JS 40441
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_URL_VISIT_HTML_JS 40442
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_WEBUI_JS 40443
#define IDR_LOTTIE_LOTTIE_WORKER_MIN_JS 40444
#define IDR_CR_COMPONENTS_COLOR_CHANGE_LISTENER_BROWSER_PROXY_JS 40445
#define IDR_CR_COMPONENTS_COLOR_CHANGE_LISTENER_COLORS_CSS_UPDATER_JS 40446
#define IDR_CR_COMPONENTS_COLOR_CHANGE_LISTENER_COLOR_CHANGE_LISTENER_MOJOM_WEBUI_JS 40447
#define IDR_WEBUI_GENERATED_ROBOTO_ROBOTO_BOLD_WOFF2 40448
#define IDR_WEBUI_GENERATED_ROBOTO_ROBOTO_MEDIUM_WOFF2 40449
#define IDR_WEBUI_GENERATED_ROBOTO_ROBOTO_REGULAR_WOFF2 40450

#endif  // CEF_INCLUDE_CEF_PACK_RESOURCES_H_
