// Copyright (c) 2022 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool and should not edited
// by hand. See the translator.README.txt file in the tools directory for
// more information.
//
// $hash=66198e92ec123e753bb427a0b92d73672610136e$
//

#ifndef CEF_INCLUDE_CAPI_CEF_SHARED_PROCESS_MESSAGE_BUILDER_CAPI_H_
#define CEF_INCLUDE_CAPI_CEF_SHARED_PROCESS_MESSAGE_BUILDER_CAPI_H_
#pragma once

#include "include/capi/cef_process_message_capi.h"

#ifdef __cplusplus
extern "C" {
#endif

///
/// Structure that builds a cef_process_message_t containing a shared memory
/// region. This structure is not thread-safe but may be used exclusively on a
/// different thread from the one which constructed it.
///
typedef struct _cef_shared_process_message_builder_t {
  ///
  /// Base structure.
  ///
  cef_base_ref_counted_t base;

  ///
  /// Returns true (1) if the builder is valid.
  ///
  int(CEF_CALLBACK* is_valid)(
      struct _cef_shared_process_message_builder_t* self);

  ///
  /// Returns the size of the shared memory region in bytes. Returns 0 for
  /// invalid instances.
  ///
  size_t(CEF_CALLBACK* size)(
      struct _cef_shared_process_message_builder_t* self);

  ///
  /// Returns the pointer to the writable memory. Returns nullptr for invalid
  /// instances. The returned pointer is only valid for the life span of this
  /// object.
  ///
  void*(CEF_CALLBACK* memory)(
      struct _cef_shared_process_message_builder_t* self);

  ///
  /// Creates a new cef_process_message_t from the data provided to the builder.
  /// Returns nullptr for invalid instances. Invalidates the builder instance.
  ///
  struct _cef_process_message_t*(CEF_CALLBACK* build)(
      struct _cef_shared_process_message_builder_t* self);
} cef_shared_process_message_builder_t;

///
/// Creates a new cef_shared_process_message_builder_t with the specified |name|
/// and shared memory region of specified |byte_size|.
///
CEF_EXPORT cef_shared_process_message_builder_t*
cef_shared_process_message_builder_create(const cef_string_t* name,
                                          size_t byte_size);

#ifdef __cplusplus
}
#endif

#endif  // CEF_INCLUDE_CAPI_CEF_SHARED_PROCESS_MESSAGE_BUILDER_CAPI_H_
