// Copyright 2016 The Chromium Embedded Framework Authors. Portions copyright
// 2013 The Chromium Authors. All rights reserved. Use of this source code is
// governed by a BSD-style license that can be found in the LICENSE file.

#ifndef CEF_TESTS_CEFCLIENT_BROWSER_OSR_TEXT_INPUT_CLIENT_OSR_MAC_H_
#define CEF_TESTS_CEFCLIENT_BROWSER_OSR_TEXT_INPUT_CLIENT_OSR_MAC_H_
#pragma once

#import <Cocoa/Cocoa.h>
#include <string>
#include <vector>

#include "include/cef_browser.h"
#include "include/cef_render_handler.h"

// Implementation for the NSTextInputClient protocol used for enabling IME on
// mac when window rendering is disabled.

@interface CefTextInputClientOSRMac : NSObject<NSTextInputClient> {
 @private

  // The range of current marked text inside the whole content of the DOM node
  // being edited.
  NSRange markedRange_;

  // The current composition character range and its bounds.
  CefRange composition_range_;
  std::vector<CefRect> composition_bounds_;

  // Represents the input-method attributes supported by this object.
  NSArray* validAttributesForMarkedText_;

  // Indicates if we are currently handling a key down event.
  BOOL handlingKeyDown_;

  // Indicates if there is any marked text.
  BOOL hasMarkedText_;

  // Indicates whether there was any marked text prior to handling
  // the current key event.
  BOOL oldHasMarkedText_;

  // Indicates if unmarkText is called or not when handling a keyboard
  // event.
  BOOL unmarkTextCalled_;

  // The selected range, cached from a message sent by the renderer.
  NSRange selectedRange_;

  // Text to be inserted which was generated by handling a key down event.
  std::string textToBeInserted_;

  // Marked text which was generated by handling a key down event.
  CefString markedText_;

  // Underline information of the |markedText_|.
  std::vector<CefCompositionUnderline> underlines_;

  // Replacement range information received from |setMarkedText:|.
  CefRange setMarkedTextReplacementRange_;

  CefRefPtr<CefBrowser> browser_;
}

@property(nonatomic, readonly) NSRange selectedRange;
@property(nonatomic) BOOL handlingKeyDown;

- (id)initWithBrowser:(CefRefPtr<CefBrowser>)browser;
- (void)detach;
- (void)HandleKeyEventBeforeTextInputClient:(NSEvent*)keyEvent;
- (void)HandleKeyEventAfterTextInputClient:(CefKeyEvent)keyEvent;
- (void)ChangeCompositionRange:(CefRange)range
              character_bounds:(const CefRenderHandler::RectList&)bounds;
- (void)cancelComposition;

@end

#endif  // CEF_TESTS_CEFCLIENT_BROWSER_OSR_TEXT_INPUT_CLIENT_OSR_MAC_H_
