// Copyright (c) 2022 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_STRINGS_H_
#define CEF_INCLUDE_CEF_PACK_STRINGS_H_
#pragma once

// ---------------------------------------------------------------------------
// From blink_accessibility_strings.h:

#define IDS_AX_UNLABELED_IMAGE_ROLE_DESCRIPTION 32470
#define IDS_AX_IMAGE_ELIGIBLE_FOR_ANNOTATION 32473
#define IDS_AX_IMAGE_ANNOTATION_PENDING 32474
#define IDS_AX_IMAGE_ANNOTATION_ADULT 32475
#define IDS_AX_IMAGE_ANNOTATION_NO_DESCRIPTION 32476
#define IDS_AX_IMAGE_ANNOTATION_OCR_CONTEXT 32477
#define IDS_AX_IMAGE_ANNOTATION_DESCRIPTION_CONTEXT 32478
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLUS 32479
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_BACKWARD 32480
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_FORWARD 32481
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALL 32482
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHAT 32483
#define IDS_AX_IMAGE_ANNOTATION_ICON_CHECK 32484
#define IDS_AX_IMAGE_ANNOTATION_ICON_X 32485
#define IDS_AX_IMAGE_ANNOTATION_ICON_DELETE 32486
#define IDS_AX_IMAGE_ANNOTATION_ICON_EDIT 32487
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI 32488
#define IDS_AX_IMAGE_ANNOTATION_ICON_END_CALL 32489
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_DOWNWARD 32490
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEART 32491
#define IDS_AX_IMAGE_ANNOTATION_ICON_HOME 32492
#define IDS_AX_IMAGE_ANNOTATION_ICON_INFO 32493
#define IDS_AX_IMAGE_ANNOTATION_ICON_LAUNCH_APPS 32494
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_UP 32495
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_BARS 32496
#define IDS_AX_IMAGE_ANNOTATION_ICON_THREE_DOTS 32497
#define IDS_AX_IMAGE_ANNOTATION_ICON_NOTIFICATIONS 32498
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAUSE 32499
#define IDS_AX_IMAGE_ANNOTATION_ICON_PLAY 32500
#define IDS_AX_IMAGE_ANNOTATION_ICON_REFRESH 32501
#define IDS_AX_IMAGE_ANNOTATION_ICON_MAGNIFYING_GLASS 32502
#define IDS_AX_IMAGE_ANNOTATION_ICON_SEND 32503
#define IDS_AX_IMAGE_ANNOTATION_ICON_SETTINGS 32504
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHARE 32505
#define IDS_AX_IMAGE_ANNOTATION_ICON_STAR 32506
#define IDS_AX_IMAGE_ANNOTATION_ICON_TAKE_PHOTO 32507
#define IDS_AX_IMAGE_ANNOTATION_ICON_TIME 32508
#define IDS_AX_IMAGE_ANNOTATION_ICON_VIDEOCAM 32509
#define IDS_AX_IMAGE_ANNOTATION_ICON_EXPAND 32510
#define IDS_AX_IMAGE_ANNOTATION_ICON_CONTRACT 32511
#define IDS_AX_IMAGE_ANNOTATION_ICON_GOOGLE 32512
#define IDS_AX_IMAGE_ANNOTATION_ICON_TWITTER 32513
#define IDS_AX_IMAGE_ANNOTATION_ICON_FACEBOOK 32514
#define IDS_AX_IMAGE_ANNOTATION_ICON_ASSISTANT 32515
#define IDS_AX_IMAGE_ANNOTATION_ICON_WEATHER 32516
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_CART 32517
#define IDS_AX_IMAGE_ANNOTATION_ICON_UPLOAD 32518
#define IDS_AX_IMAGE_ANNOTATION_ICON_QUESTION 32519
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC 32520
#define IDS_AX_IMAGE_ANNOTATION_ICON_MIC_MUTE 32521
#define IDS_AX_IMAGE_ANNOTATION_ICON_GALLERY 32522
#define IDS_AX_IMAGE_ANNOTATION_ICON_COMPASS 32523
#define IDS_AX_IMAGE_ANNOTATION_ICON_PEOPLE 32524
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_UPWARD 32525
#define IDS_AX_IMAGE_ANNOTATION_ICON_ENVELOPE 32526
#define IDS_AX_IMAGE_ANNOTATION_ICON_EMOJI_FACE 32527
#define IDS_AX_IMAGE_ANNOTATION_ICON_PAPERCLIP 32528
#define IDS_AX_IMAGE_ANNOTATION_ICON_CAST 32529
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_UP 32530
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_DOWN 32531
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_STATE 32532
#define IDS_AX_IMAGE_ANNOTATION_ICON_VOLUME_MUTE 32533
#define IDS_AX_IMAGE_ANNOTATION_ICON_STOP 32534
#define IDS_AX_IMAGE_ANNOTATION_ICON_SHOPPING_BAG 32535
#define IDS_AX_IMAGE_ANNOTATION_ICON_LIST 32536
#define IDS_AX_IMAGE_ANNOTATION_ICON_LOCATION 32537
#define IDS_AX_IMAGE_ANNOTATION_ICON_CALENDAR 32538
#define IDS_AX_IMAGE_ANNOTATION_ICON_THUMBS_DOWN 32539
#define IDS_AX_IMAGE_ANNOTATION_ICON_HEADSET 32540
#define IDS_AX_IMAGE_ANNOTATION_ICON_REDO 32541
#define IDS_AX_IMAGE_ANNOTATION_ICON_UNDO 32542
#define IDS_AX_IMAGE_ANNOTATION_ICON_DOWNLOAD 32543
#define IDS_AX_IMAGE_ANNOTATION_ICON_ARROW_DOWNWARD 32544
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_UPWARD 32545
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_FORWARD 32546
#define IDS_AX_IMAGE_ANNOTATION_ICON_V_BACKWARD 32547
#define IDS_AX_IMAGE_ANNOTATION_ICON_HISTORY 32548
#define IDS_AX_IMAGE_ANNOTATION_ICON_PERSON 32549
#define IDS_AX_IMAGE_ANNOTATION_ICON_HAPPY_FACE 32550
#define IDS_AX_IMAGE_ANNOTATION_ICON_SAD_FACE 32551
#define IDS_AX_IMAGE_ANNOTATION_ICON_MOON 32552
#define IDS_AX_IMAGE_ANNOTATION_ICON_CLOUD 32553
#define IDS_AX_IMAGE_ANNOTATION_ICON_SUN 32554

// ---------------------------------------------------------------------------
// From blink_strings.h:

#define IDS_DETAILS_WITHOUT_SUMMARY_LABEL 32570
#define IDS_FORM_CALENDAR_CLEAR 32571
#define IDS_FORM_CALENDAR_TODAY 32572
#define IDS_FORM_SUBMIT_LABEL 32573
#define IDS_FORM_INPUT_ALT 32574
#define IDS_FORM_RESET_LABEL 32575
#define IDS_FORM_FILE_BUTTON_LABEL 32576
#define IDS_FORM_MULTIPLE_FILES_BUTTON_LABEL 32577
#define IDS_FORM_FILE_NO_FILE_LABEL 32578
#define IDS_FORM_FILE_MULTIPLE_UPLOAD 32579
#define IDS_FORM_OTHER_COLOR_LABEL 32580
#define IDS_FORM_OTHER_DATE_LABEL 32581
#define IDS_FORM_OTHER_MONTH_LABEL 32582
#define IDS_FORM_OTHER_WEEK_LABEL 32583
#define IDS_FORM_PLACEHOLDER_FOR_DAY_OF_MONTH_FIELD 32584
#define IDS_FORM_PLACEHOLDER_FOR_MONTH_FIELD 32585
#define IDS_FORM_PLACEHOLDER_FOR_YEAR_FIELD 32586
#define IDS_FORM_SELECT_MENU_LIST_TEXT 32587
#define IDS_FORM_THIS_MONTH_LABEL 32588
#define IDS_FORM_THIS_WEEK_LABEL 32589
#define IDS_FORM_WEEK_NUMBER_LABEL 32590
#define IDS_AX_CALENDAR_SHOW_DATE_PICKER 32591
#define IDS_AX_CALENDAR_SHOW_DATE_TIME_LOCAL_PICKER 32592
#define IDS_AX_CALENDAR_SHOW_MONTH_PICKER 32593
#define IDS_AX_CALENDAR_SHOW_TIME_PICKER 32594
#define IDS_AX_CALENDAR_SHOW_WEEK_PICKER 32595
#define IDS_AX_CALENDAR_SHOW_MONTH_SELECTOR 32596
#define IDS_AX_CALENDAR_SHOW_NEXT_MONTH 32597
#define IDS_AX_CALENDAR_SHOW_PREVIOUS_MONTH 32598
#define IDS_AX_CALENDAR_WEEK_DESCRIPTION 32599
#define IDS_AX_COLOR_EDIT_BLUE 32600
#define IDS_AX_COLOR_EDIT_GREEN 32601
#define IDS_AX_COLOR_EDIT_HEXADECIMAL 32602
#define IDS_AX_COLOR_EDIT_HUE 32603
#define IDS_AX_COLOR_EDIT_LIGHTNESS 32604
#define IDS_AX_COLOR_EDIT_RED 32605
#define IDS_AX_COLOR_EDIT_SATURATION 32606
#define IDS_AX_COLOR_EYEDROPPER 32607
#define IDS_AX_COLOR_FORMAT_TOGGLER 32608
#define IDS_AX_COLOR_HUE_SLIDER 32609
#define IDS_AX_COLOR_WELL 32610
#define IDS_AX_COLOR_WELL_ROLEDESCRIPTION 32611
#define IDS_SYSTEM_COLOR_CHOOSER 32612
#define IDS_AX_AM_PM_FIELD_TEXT 32634
#define IDS_AX_DAY_OF_MONTH_FIELD_TEXT 32635
#define IDS_AX_HOUR_FIELD_TEXT 32636
#define IDS_AX_MEDIA_DEFAULT 32637
#define IDS_AX_MEDIA_AUDIO_ELEMENT 32638
#define IDS_AX_MEDIA_VIDEO_ELEMENT 32639
#define IDS_AX_MEDIA_MUTE_BUTTON 32640
#define IDS_AX_MEDIA_UNMUTE_BUTTON 32641
#define IDS_AX_MEDIA_PLAY_BUTTON 32642
#define IDS_AX_MEDIA_PAUSE_BUTTON 32643
#define IDS_AX_MEDIA_CURRENT_TIME_DISPLAY 32644
#define IDS_AX_MEDIA_TIME_REMAINING_DISPLAY 32645
#define IDS_AX_MEDIA_ENTER_FULL_SCREEN_BUTTON 32646
#define IDS_AX_MEDIA_EXIT_FULL_SCREEN_BUTTON 32647
#define IDS_AX_MEDIA_DISPLAY_CUT_OUT_FULL_SCREEN_BUTTON 32648
#define IDS_AX_MEDIA_ENTER_PICTURE_IN_PICTURE_BUTTON 32649
#define IDS_AX_MEDIA_EXIT_PICTURE_IN_PICTURE_BUTTON 32650
#define IDS_AX_MEDIA_LOADING_PANEL 32651
#define IDS_AX_MEDIA_SHOW_CLOSED_CAPTIONS_MENU_BUTTON 32652
#define IDS_AX_MEDIA_HIDE_CLOSED_CAPTIONS_MENU_BUTTON 32653
#define IDS_AX_MEDIA_SHOW_PLAYBACK_SPEED_MENU_BUTTON 32654
#define IDS_AX_MEDIA_HIDE_PLAYBACK_SPEED_MENU_BUTTON 32655
#define IDS_AX_MEDIA_CAST_OFF_BUTTON 32656
#define IDS_AX_MEDIA_CAST_ON_BUTTON 32657
#define IDS_AX_MEDIA_DOWNLOAD_BUTTON 32658
#define IDS_AX_MEDIA_OVERFLOW_BUTTON 32659
#define IDS_AX_MEDIA_AUDIO_ELEMENT_HELP 32660
#define IDS_AX_MEDIA_VIDEO_ELEMENT_HELP 32661
#define IDS_AX_MEDIA_AUDIO_SLIDER_HELP 32662
#define IDS_AX_MEDIA_VIDEO_SLIDER_HELP 32663
#define IDS_AX_MEDIA_VOLUME_SLIDER_HELP 32664
#define IDS_AX_MEDIA_CURRENT_TIME_DISPLAY_HELP 32665
#define IDS_AX_MEDIA_TIME_REMAINING_DISPLAY_HELP 32666
#define IDS_AX_MEDIA_OVERFLOW_BUTTON_HELP 32667
#define IDS_AX_MILLISECOND_FIELD_TEXT 32668
#define IDS_AX_MINUTE_FIELD_TEXT 32669
#define IDS_AX_MONTH_FIELD_TEXT 32670
#define IDS_AX_SECOND_FIELD_TEXT 32671
#define IDS_AX_WEEK_OF_YEAR_FIELD_TEXT 32672
#define IDS_AX_YEAR_FIELD_TEXT 32673
#define IDS_AX_OBJECT_SELECTED 32674
#define IDS_AX_OBJECT_NOT_SELECTED 32675
#define IDS_VIEW_SOURCE_LINE_WRAP 32676
#define IDS_FORM_INPUT_WEEK_TEMPLATE 32677
#define IDS_FORM_VALIDATION_VALUE_MISSING_MULTIPLE_FILE 32678
#define IDS_FORM_VALIDATION_TYPE_MISMATCH 32679
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY 32680
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_DOMAIN 32681
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_EMPTY_LOCAL 32682
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOMAIN 32683
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_DOTS 32684
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_INVALID_LOCAL 32685
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL_NO_AT_SIGN 32686
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_MULTIPLE_EMAIL 32687
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL 32688
#define IDS_FORM_VALIDATION_VALUE_NOT_EQUAL_DATETIME 32689
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW 32690
#define IDS_FORM_VALIDATION_RANGE_UNDERFLOW_DATETIME 32691
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW 32692
#define IDS_FORM_VALIDATION_RANGE_OVERFLOW_DATETIME 32693
#define IDS_FORM_VALIDATION_REVERSED_RANGE_OUT_OF_RANGE_TIME 32694
#define IDS_FORM_VALIDATION_RANGE_INVALID_DATETIME 32695
#define IDS_FORM_VALIDATION_BAD_INPUT_DATETIME 32696
#define IDS_FORM_VALIDATION_BAD_INPUT_NUMBER 32697
#define IDS_FORM_VALIDATION_VALUE_MISSING 32698
#define IDS_FORM_VALIDATION_VALUE_MISSING_CHECKBOX 32699
#define IDS_FORM_VALIDATION_VALUE_MISSING_FILE 32700
#define IDS_FORM_VALIDATION_VALUE_MISSING_RADIO 32701
#define IDS_FORM_VALIDATION_VALUE_MISSING_SELECT 32702
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_EMAIL 32703
#define IDS_FORM_VALIDATION_TYPE_MISMATCH_URL 32704
#define IDS_FORM_VALIDATION_PATTERN_MISMATCH 32705
#define IDS_FORM_VALIDATION_STEP_MISMATCH 32706
#define IDS_FORM_VALIDATION_STEP_MISMATCH_CLOSE_TO_LIMIT 32707
#define IDS_FORM_VALIDATION_TOO_LONG 32708
#define IDS_FORM_VALIDATION_TOO_SHORT 32709
#define IDS_FORM_VALIDATION_TOO_SHORT_PLURAL 32710
#define IDS_MEDIA_SESSION_FILE_SOURCE 32711
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS 32712
#define IDS_MEDIA_OVERFLOW_MENU_CLOSED_CAPTIONS_SUBMENU_TITLE 32713
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED 32714
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_SUBMENU_TITLE 32715
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_25X_TITLE 32716
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_5X_TITLE 32717
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_0_75X_TITLE 32718
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_NORMAL_TITLE 32719
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_25X_TITLE 32720
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_5X_TITLE 32721
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_1_75X_TITLE 32722
#define IDS_MEDIA_OVERFLOW_MENU_PLAYBACK_SPEED_2X_TITLE 32723
#define IDS_MEDIA_OVERFLOW_MENU_CAST 32724
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_FULLSCREEN 32725
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_FULLSCREEN 32726
#define IDS_MEDIA_OVERFLOW_MENU_MUTE 32727
#define IDS_MEDIA_OVERFLOW_MENU_UNMUTE 32728
#define IDS_MEDIA_OVERFLOW_MENU_PLAY 32729
#define IDS_MEDIA_OVERFLOW_MENU_PAUSE 32730
#define IDS_MEDIA_OVERFLOW_MENU_DOWNLOAD 32731
#define IDS_MEDIA_OVERFLOW_MENU_ENTER_PICTURE_IN_PICTURE 32732
#define IDS_MEDIA_OVERFLOW_MENU_EXIT_PICTURE_IN_PICTURE 32733
#define IDS_MEDIA_PICTURE_IN_PICTURE_INTERSTITIAL_TEXT 32734
#define IDS_MEDIA_REMOTING_CAST_TEXT 32735
#define IDS_MEDIA_REMOTING_CAST_TO_UNKNOWN_DEVICE_TEXT 32736
#define IDS_MEDIA_REMOTING_STOP_TEXT 32737
#define IDS_MEDIA_REMOTING_STOP_BY_PLAYBACK_QUALITY_TEXT 32738
#define IDS_MEDIA_REMOTING_STOP_BY_ERROR_TEXT 32739
#define IDS_MEDIA_SCRUBBING_MESSAGE_TEXT 32740
#define IDS_MEDIA_TRACKS_NO_LABEL 32741
#define IDS_MEDIA_TRACKS_OFF 32742
#define IDS_PLUGIN_INITIALIZATION_ERROR 32743
#define IDS_MEDIA_PLAYBACK_ERROR 32744
#define IDS_UNITS_KIBIBYTES 32745
#define IDS_UNITS_MEBIBYTES 32746
#define IDS_UNITS_GIBIBYTES 32747
#define IDS_UNITS_TEBIBYTES 32748
#define IDS_UNITS_PEBIBYTES 32749
#define CONTENT_INVALID_TRUE 32750
#define CONTENT_INVALID_SPELLING 32751
#define CONTENT_INVALID_GRAMMAR 32752

// ---------------------------------------------------------------------------
// From cef_strings.h:

#define IDS_TEXT_FILES 64000
#define IDS_CONTENT_CONTEXT_NO_SPELLING_SUGGESTIONS 64001

// ---------------------------------------------------------------------------
// From chromium_strings.h:

#define IDS_RELAUNCH_CONFIRMATION_DIALOG_TITLE 400
#define IDS_SETTINGS_ABOUT_PROGRAM 401
#define IDS_SETTINGS_GET_HELP_USING_CHROME 402
#define IDS_SETTINGS_UPGRADE_UPDATING 403
#define IDS_SETTINGS_UPGRADE_UPDATING_PERCENT 404
#define IDS_SETTINGS_UPGRADE_SUCCESSFUL_RELAUNCH 405
#define IDS_SETTINGS_UPGRADE_UP_TO_DATE 406
#define IDS_SETTINGS_GOOGLE_PAYMENTS_CACHED 411
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_OFFLINE 412
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_SIGNED_OUT 413
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_NO_PASSWORDS 414
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT_GOOGLE_ACCOUNT 415
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_QUOTA_LIMIT 416
#define IDS_SETTINGS_CHECK_PASSWORDS_ERROR_GENERIC 417
#define IDS_SETTINGS_NO_COMPROMISED_CREDENTIALS_LABEL 418
#define IDS_SETTINGS_SIGNED_OUT_USER_LABEL 419
#define IDS_SETTINGS_SIGNED_OUT_USER_HAS_COMPROMISED_CREDENTIALS_LABEL 420
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION_GENERATION 421
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_DESCRIPTION 422
#define IDS_SETTINGS_DEFAULT_BROWSER_DEFAULT 423
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT 424
#define IDS_SETTINGS_DEFAULT_BROWSER_ERROR 425
#define IDS_SETTINGS_DEFAULT_BROWSER_SECONDARY 426
#define IDS_SETTINGS_SPELLING_PREF_DESC 428
#define IDS_SETTINGS_RESTART_TO_APPLY_CHANGES 429
#define IDS_SETTINGS_SIGNIN_ALLOWED 430
#define IDS_SETTINGS_SIGNIN_ALLOWED_DESC 431
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_BLOCKED 432
#define IDS_SETTINGS_COOKIES_CLEAR_ON_EXIT_DESC 433
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_BODY 434
#define IDS_SETTINGS_PRIVACY_GUIDE_CLEAR_ON_EXIT_FEATURE_DESCRIPTION1 435
#define IDS_SETTINGS_PRIVACY_GUIDE_CLEAR_ON_EXIT_FEATURE_DESCRIPTION2 436
#define IDS_SETTINGS_PRIVACY_GUIDE_CLEAR_ON_EXIT_FEATURE_DESCRIPTION3 437
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION2 438
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_PRIVACY_DESCRIPTION1 439
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_SUB_LABEL 440
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_SUB_LABEL 441
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION2 442
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_TITLE 443
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_TYPES 444
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_USAGE 445
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TOPICS_DATA_MANAGEMENT 446
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_TYPES 447
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_USAGE 448
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION 449
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_TRIALS_OFF 450
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_DESCRIPTION_LISTS_EMPTY 451
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_TITLE 452
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_1 453
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_2 454
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_LEARN_MORE_3 455
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_1 456
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION 457
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_DESCRIPTION_TRIALS_OFF 458
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_BEFORE 459
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_FAILED_OFFLINE 460
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_FAILED 461
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_UNKNOWN 462
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_SIGNED_OUT 463
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED 464
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_TWO 465
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_TWO 466
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_SINGULAR 467
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITH_COUNTS_PLURAL 468
#define IDS_SETTINGS_SYNC_DISCONNECT_DELETE_PROFILE_WARNING_WITHOUT_COUNTS 469
#define IDS_SETTINGS_CUSTOMIZE_YOUR_CHROME_PROFILE 470
#define IDS_SETTING_NAME_YOUR_PROFILE 471
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT_SECONDARY_WITH_ACCOUNT 472
#define IDS_SETTINGS_SYNC_DATA_ENCRYPTED_TEXT 474
#define IDS_SETTINGS_SYNC_DISCONNECT_TITLE 475
#define IDS_DRIVE_SUGGEST_PREF_DESC 476
#define IDS_SETTINGS_SYNC_SIGN_IN_PROMPT_WITH_NO_ACCOUNT 477
#define IDS_SETTINGS_AUTOFILL_ASSISTANT_PREF 478
#define IDS_SETTINGS_AUTOFILL_ASSISTANT_PREF_DESC 479
#define IDS_SETTINGS_SYSTEM_BACKGROUND_APPS_LABEL 482
#define IDS_SETTINGS_RESET_PROFILE_FEEDBACK 483
#define IDS_SETTINGS_CHROME_CERTIFICATES 484
#define IDS_SETTINGS_CHROME_CERTIFICATES_DESCRIPTION 485
#define IDS_PRODUCT_NAME 103
#define IDS_SHORT_PRODUCT_NAME 486
#define IDS_FIRST_RUN_DIALOG_WINDOW_TITLE 492
#define IDS_PRODUCT_LOGO_ENTERPRISE_ALT_TEXT 496
#define IDS_TASK_MANAGER_TITLE 498
#define IDS_SESSION_CRASHED_VIEW_UMA_OPTIN 499
#define IDS_BROWSER_WINDOW_TITLE_FORMAT 500
#define IDS_CAPTIVE_PORTAL_BROWSER_WINDOW_TITLE_FORMAT 501
#define IDS_ACCESSIBLE_BROWSER_WINDOW_TITLE_FORMAT 502
#define IDS_ACCESSIBLE_BETA_BROWSER_WINDOW_TITLE_FORMAT 503
#define IDS_ACCESSIBLE_DEV_BROWSER_WINDOW_TITLE_FORMAT 504
#define IDS_ACCESSIBLE_CANARY_BROWSER_WINDOW_TITLE_FORMAT 505
#define IDS_ABOUT_VERSION_COMPANY_NAME 506
#define IDS_ABOUT_VERSION_COPYRIGHT 507
#define IDS_ABOUT_TERMS_OF_SERVICE 511
#define IDS_MAC_10_11_OBSOLETE 512
#define IDS_MAC_10_12_OBSOLETE 513
#define IDS_ACCNAME_APP 313
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES 517
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_HELP_TEXT_NO_DEVICES_ORIGIN 518
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_NOT_FOUND 519
#define IDS_FR_CUSTOMIZE_DEFAULT_BROWSER 523
#define IDS_STATUS_TRAY_KEEP_CHROME_RUNNING_IN_BACKGROUND 524
#define IDS_CANT_WRITE_USER_DIRECTORY_SUMMARY 525
#define IDS_PROFILE_TOO_NEW_ERROR 527
#define IDS_PREFERENCES_UNREADABLE_ERROR 528
#define IDS_PREFERENCES_CORRUPT_ERROR 529
#define IDS_CRASH_RECOVERY_TITLE 532
#define IDS_PASSWORD_GENERATION_PROMPT 534
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_C 535
#define IDS_PASSWORD_MANAGER_TITLE_BRAND 536
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SAVING_ON_DEVICE 537
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 538
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_OUT_MESSAGE_DESCRIPTION 539
#define IDS_PASSWORDS_PAGE_AUTHENTICATION_PROMPT 540
#define IDS_PASSWORDS_PAGE_COPY_AUTHENTICATION_PROMPT 541
#define IDS_PASSWORDS_PAGE_EDIT_AUTHENTICATION_PROMPT 542
#define IDS_PASSWORDS_PAGE_EXPORT_AUTHENTICATION_PROMPT 543
#define IDS_DEFAULT_BROWSER_INFOBAR_TEXT 560
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_NOTIFICATION_DESCRIPTION 561
#define IDS_DOWNLOAD_BUBBLE_DANGEROUS_FILE 567
#define IDS_DOWNLOAD_BUBBLE_MALICIOUS_URL_BLOCKED 568
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNKNOWN_SOURCE 569
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_MALWARE 570
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_DEEP_SCANNING_PROMPT 571
#define IDS_DOWNLOAD_STATUS_CRX_INSTALL_RUNNING 572
#define IDS_PROMPT_DOWNLOAD_CHANGES_SETTINGS 573
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_URL 574
#define IDS_PROMPT_MALICIOUS_DOWNLOAD_CONTENT 575
#define IDS_BLOCK_REASON_DANGEROUS_DOWNLOAD 576
#define IDS_BLOCK_REASON_UNWANTED_DOWNLOAD 577
#define IDS_ABANDON_DOWNLOAD_DIALOG_BROWSER_MESSAGE 578
#define IDS_QUIT_WITH_APPS_TITLE 334
#define IDS_MISSING_GOOGLE_API_KEYS 579
#define IDS_EXTENSION_INSTALLED_HEADING 580
#define IDS_EXTENSION_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX 581
#define IDS_EXTENSION_ALERT_ITEM_BLOCKLISTED_MALWARE 582
#define IDS_EXTENSIONS_ALERT_ITEM_BLOCKLISTED_MALWARE_TITLE 583
#define IDS_EXTENSIONS_INCOGNITO_WARNING 584
#define IDS_EXTENSIONS_UNINSTALL 585
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_IN_CHROME 586
#define IDS_EXTENSIONS_MULTIPLE_UNSUPPORTED_DISABLED_BODY 587
#define IDS_EXTENSIONS_SINGLE_UNSUPPORTED_DISABLED_BODY 588
#define IDS_APPMENU_TOOLTIP 265
#define IDS_APPMENU_TOOLTIP_UPDATE_AVAILABLE 589
#define IDS_APPMENU_TOOLTIP_ALERT 590
#define IDS_OPEN_IN_CHROME 591
#define IDS_ABOUT 302
#define IDS_RELAUNCH_TO_UPDATE 592
#define IDS_APP_MENU_PRODUCT_NAME 102
#define IDS_HELPER_NAME 593
#define IDS_SHORT_HELPER_NAME 594
#define IDS_CHROME_SIGNIN_TITLE 595
#define IDS_PROFILES_DICE_SYNC_PROMO 596
#define IDS_SYNC_WRONG_EMAIL 597
#define IDS_SYNC_USED_PROFILE_ERROR 598
#define IDS_ENTERPRISE_SIGNIN_TITLE 599
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITHOUT_PROFILE_CREATION 600
#define IDS_ENTERPRISE_SIGNIN_EXPLANATION_WITH_PROFILE_CREATION 601
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_TITLE 602
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_CREATION 603
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_ISOLATION_NOTICE 604
#define IDS_ENTERPRISE_SIGNIN_WORK_PROFILE_EXPLANATION 605
#define IDS_ONE_CLICK_SIGNIN_DIALOG_TITLE_NEW 606
#define IDS_ONE_CLICK_SIGNIN_DIALOG_MESSAGE_NEW 607
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_UNKNOWN_BROWSER 608
#define IDS_ABOUT_BROWSER_SWITCH_DESCRIPTION_KNOWN_BROWSER 609
#define IDS_NTP_CUSTOMIZE_BUTTON_LABEL 610
#define IDS_SIGNIN_EMAIL_CONFIRMATION_TITLE 611
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE 612
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_TITLE 613
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC 614
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC 615
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC_MANAGED_DEVICE 616
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC_MANAGED_DEVICE 617
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CONSUMER_BUBBLE_DESC_V2 618
#define IDS_PROFILE_CUSTOMIZATION_TEXT 619
#define IDS_PROFILE_CUSTOMIZATION_TITLE_V2 620
#define IDS_APP_SHORTCUTS_SUBDIR_NAME 627
#define IDS_APP_SHORTCUTS_SUBDIR_NAME_CANARY 628
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_AND_VIDEO 632
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_AUDIO_ONLY 633
#define IDS_MEDIA_STREAM_STATUS_TRAY_TEXT_VIDEO_ONLY 634
#define IDS_PROFILE_IN_USE_POSIX 635
#define IDS_FIRSTRUN_DLG_MAC_SET_DEFAULT_BROWSER_LABEL 636
#define IDS_LOGIN_POD_USER_REMOVE_WARNING_SYNC 637
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TITLE 638
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_INTRO_TEXT 639
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TITLE 640
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_YOUR_CHROME_TEXT 641
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_GUEST_TEXT 642
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_FRIENDS_TEXT 643
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_TEXT 644
#define IDS_USER_MANAGER_TUTORIAL_SLIDE_OUTRO_ADD_USER 645
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_START_PAGES_SPECIFIC 646
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_START_PAGES 647
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_PAGES 648
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_HOME 649
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_START_AND_SEARCH 650
#define IDS_WEBSTORE_APP_DESCRIPTION 246
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT 659
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_TEXT_ONCE 660
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TEXT 661
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB_INAPP 662
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD_INAPP 663
#define IDS_UPDATE_RECOMMENDED_DIALOG_TITLE 664
#define IDS_UPDATE_RECOMMENDED 665
#define IDS_RELAUNCH_AND_UPDATE 666
#define IDS_REINSTALL_APP 667
#define IDS_UPGRADE_BUBBLE_MENU_ITEM 668
#define IDS_UPGRADE_BUBBLE_TITLE 669
#define IDS_UPGRADE_BUBBLE_TEXT 670
#define IDS_SYNC_ERROR_USER_MENU_UPGRADE_BUTTON 671
#define IDS_SYNC_UPGRADE_CLIENT 672
#define IDS_SYNC_UPGRADE_CLIENT_BUTTON 673
#define IDS_RECOVERY_BUBBLE_TITLE 674
#define IDS_RUN_RECOVERY 675
#define IDS_RECOVERY_BUBBLE_TEXT 676
#define IDS_CRITICAL_NOTIFICATION_TITLE 677
#define IDS_CRITICAL_NOTIFICATION_TITLE_ALTERNATE 678
#define IDS_CRITICAL_NOTIFICATION_TEXT 679
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_TAB 680
#define IDS_RUNTIME_PERMISSION_OS_REASON_TEXT 693
#define IDS_WELCOME_HEADER 696
#define IDS_RELAUNCH_RECOMMENDED_TITLE 698
#define IDS_RELAUNCH_RECOMMENDED_BODY 699
#define IDS_RELAUNCH_REQUIRED_TITLE_DAYS 700
#define IDS_RELAUNCH_REQUIRED_TITLE_HOURS 701
#define IDS_RELAUNCH_REQUIRED_TITLE_MINUTES 702
#define IDS_RELAUNCH_REQUIRED_TITLE_SECONDS 703
#define IDS_RELAUNCH_REQUIRED_BODY 704
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_TOOLTIP 705
#define IDS_ENTERPRISE_STARTUP_CLOUD_POLICY_ENROLLMENT_ERROR 706
#define IDS_ENTERPRISE_STARTUP_RELAUNCH_BUTTON 707
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WEB_CONTENTS_ONLY 708
#define IDS_HATS_BUBBLE_TITLE 709
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE 715
#define IDS_PROFILE_PICKER_MAIN_VIEW_TITLE_V2 716
#define IDS_PROFILE_PICKER_MAIN_VIEW_SUBTITLE 717
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_SUBTITLE 718
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_PROFILE_TYPE_CHOICE_TITLE 719
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_TITLE 720
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TEXT 721
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TEXT 722
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_TITLE 723
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SUBTITLE 724
#define IDS_PROFILE_SWITCH_PROMO 729
#define IDS_PROFILE_SWITCH_PROMO_SCREENREADER 730
#define IDS_CHROMELABS_RELAUNCH_FOOTER_MESSAGE 732
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH 733
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_TITLE 734
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_TITLE 735
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_DESCRIPTION 736
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_MESSAGE_ACCEPT 737
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_SUBTITLE 738
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_DESCRIPTION_2 739
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_LABEL 740
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_HEADER 741
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_1 742
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_2 743
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_1_BULLET_POINT_3 744
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_1 745
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_2 746
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BOTTOM_SUMMARY 747
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_SUBTITLE 748
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_DESCRIPTION_2 749
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BOTTOM_SUMMARY 750

// ---------------------------------------------------------------------------
// From components_chromium_strings.h:

#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_BODY 25040
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_HEADER 25041
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_CLIENT 25042
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_ENROLLMENT_CHECK_PENDING 25043
#define IDS_ERRORPAGES_SUGGESTION_PROXY_DISABLE_PLATFORM 25044
#define IDS_FLAGS_UI_RELAUNCH_NOTICE 25045
#define IDS_DEPRECATED_FEATURES_RELAUNCH_NOTICE 25046
#define IDS_CRASH_DISABLED_MESSAGE 25047
#define IDS_SHORT_PRODUCT_LOGO_ALT_TEXT 25048
#define IDS_VERSION_UI_LICENSE 25049
#define IDS_PAGE_INFO_INTERNAL_PAGE 25050
#define IDS_SESSION_CRASHED_VIEW_MESSAGE 25051

// ---------------------------------------------------------------------------
// From components_strings.h:

#define IDS_ASH_ARC_APP_COMPAT_DISABLED_COMPAT_MODE_BUTTON_TOOLTIP_PHONE 25080
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_TITLE 25081
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_BODY 25082
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_ACCEPT 25083
#define IDS_ASH_ARC_APP_COMPAT_RESIZE_CONFIRM_DONT_ASK_ME 25084
#define IDS_ASH_ARC_NEARBY_SHARE_FILE_PREPARATION_PROGRESS 25085
#define IDS_ASH_ARC_NEARBY_SHARE_FILES_PREPARATION_PROGRESS 25086
#define IDS_ASH_ARC_NEARBY_SHARE_ERROR_DIALOG_MESSAGE 25087
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_TITLE 25088
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_MESSAGE 25089
#define IDS_ASH_ARC_NEARBY_SHARE_LOW_DISK_SPACE_DIALOG_STORAGE_BUTTON 25090
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_PHONE 25091
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TABLET 25092
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZABLE 25093
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_RESIZE_SETTINGS 25094
#define IDS_ARC_COMPAT_MODE_RESIZE_TOGGLE_MENU_TITLE 25095
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_TITLE 25096
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY 25097
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_BODY_UNRESIZABLE 25098
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_CLOSE 25099
#define IDS_ARC_COMPAT_MODE_SPLASH_SCREEN_LINK 25100
#define IDS_ARC_COMPAT_MODE_DISABLE_RESIZE_LOCK_TOAST 25101
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_ICON 25102
#define IDS_ARC_GHOST_WINDOW_APP_LAUNCHING_THROBBER 25103
#define IDS_AUTOFILL_ASSISTANT_PAYMENT_INFO_CONFIRM 25104
#define IDS_AUTOFILL_ASSISTANT_PAYMENT_INFORMATION_MISSING 25105
#define IDS_AUTOFILL_ASSISTANT_DEFAULT_ERROR 25106
#define IDS_AUTOFILL_ASSISTANT_LOADING 25107
#define IDS_AUTOFILL_ASSISTANT_GIVE_UP 25108
#define IDS_AUTOFILL_ASSISTANT_MAYBE_GIVE_UP 25109
#define IDS_AUTOFILL_ASSISTANT_DETAILS_DIFFER 25110
#define IDS_AUTOFILL_ASSISTANT_CONTINUE_BUTTON 25111
#define IDS_AUTOFILL_ASSISTANT_STOPPED 25112
#define IDS_AUTOFILL_ASSISTANT_SEND_FEEDBACK 25113
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_LOCAL_SAVE 25114
#define IDS_AUTOFILL_NO_THANKS_DESKTOP_UPLOAD_SAVE 25115
#define IDS_AUTOFILL_FIELD_LABEL_PHONE 25122
#define IDS_AUTOFILL_FIELD_LABEL_BILLING_ADDRESS 25123
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_LOCAL_SAVE_ACCEPT 25125
#define IDS_AUTOFILL_SAVE_CARD_BUBBLE_UPLOAD_SAVE_ACCEPT 25126
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CONTINUE 25133
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_LOCAL 25134
#define IDS_AUTOFILL_FIX_FLOW_PROMPT_SAVE_CARD_LABEL 25135
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD 25136
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_EXPERIMENT_ENCRYPTED_AND_SECURE 25137
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_EXPERIMENT_FASTER_AND_PROTECTED 25138
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V3 25139
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_TITLE_TO_CLOUD_V4 25140
#define IDS_AUTOFILL_CARD_SAVED 25141
#define IDS_AUTOFILL_MANAGE_CARDS 25142
#define IDS_AUTOFILL_DONE 25143
#define IDS_AUTOFILL_FAILURE_BUBBLE_TITLE 25144
#define IDS_AUTOFILL_FAILURE_BUBBLE_EXPLANATION 25145
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION 25146
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3 25147
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_EXPERIMENT_ENCRYPTED_AND_SECURE 25148
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_EXPERIMENT_FASTER_AND_PROTECTED 25149
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_V3_WITH_NAME 25150
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME 25151
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_CARDHOLDER_NAME_TOOLTIP 25152
#define IDS_AUTOFILL_SAVE_CARD_CARDHOLDER_NAME_FIX_FLOW_HEADER 25153
#define IDS_AUTOFILL_SAVE_CARD_UPDATE_EXPIRATION_DATE_TITLE 25154
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_TOOLTIP 25157
#define IDS_AUTOFILL_SAVE_CARD_PROMPT_UPLOAD_EXPLANATION_AND_CARDHOLDER_NAME_TOOLTIP 25158
#define IDS_AUTOFILL_GOOGLE_PAY_LOGO_ACCESSIBLE_NAME 25159
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_ANIMATION_LABEL 25160
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_TITLE 25161
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BUTTON_LABEL 25162
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_BUBBLE_BODY_TEXT 25163
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_OFFER 25164
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_DONE 25165
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TITLE_FIX 25166
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_CHECKBOX_UNCHECK_WARNING 25167
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_OFFER 25168
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_DONE 25169
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_ERROR 25170
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_FIX 25171
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_MESSAGE_INVALID_CARD_REMOVED 25172
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_SAVE 25173
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_CANCEL 25174
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_DONE 25175
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_BUTTON_LABEL_VIEW_CARDS 25176
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_LABEL_INVALID_CARDS 25177
#define IDS_AUTOFILL_LOCAL_CARD_MIGRATION_DIALOG_TRASH_CAN_BUTTON_TOOLTIP 25178
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC 25179
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_TRY_AGAIN_CVC_AND_EXPIRATION_V2 25180
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_PERMANENT 25185
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_ERROR_NETWORK 25186
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE 25187
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_TITLE_V2 25188
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_EXPIRED_TITLE 25189
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS 25190
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_LOCAL_CARD 25191
#define IDS_AUTOFILL_CARD_UNMASK_PROMPT_INSTRUCTIONS_V2 25192
#define IDS_AUTOFILL_CARD_UNMASK_CVC_IMAGE_DESCRIPTION 25193
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRM_BUTTON 25198
#define IDS_AUTOFILL_CARD_UNMASK_VERIFY_BUTTON 25199
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_MONTH 25200
#define IDS_AUTOFILL_CARD_UNMASK_EXPIRATION_YEAR 25201
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_IN_PROGRESS 25202
#define IDS_AUTOFILL_CARD_UNMASK_VERIFICATION_SUCCESS 25203
#define IDS_AUTOFILL_CARD_UNMASK_INVALID_EXPIRATION_DATE 25204
#define IDS_AUTOFILL_EXPIRATION_DATE_SEPARATOR 25205
#define IDS_AUTOFILL_CARD_UNMASK_NEW_CARD_LINK 25206
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_CVC 25207
#define IDS_AUTOFILL_CARD_UNMASK_PROGRESS_BAR_MESSAGE 25208
#define IDS_AUTOFILL_CARD_UNMASK_CANCEL_BUTTON_LABEL 25209
#define IDS_AUTOFILL_CARD_UNMASK_CONFIRMATION_MESSAGE 25210
#define IDS_AUTOFILL_FIDO_AUTHENTICATION_PROMPT_TITLE 25211
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE 25212
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_TITLE_ERROR 25213
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION 25214
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_OK_BUTTON_LABEL 25215
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_INSTRUCTION_ERROR 25216
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL 25217
#define IDS_AUTOFILL_WEBAUTHN_OPT_IN_DIALOG_CANCEL_BUTTON_LABEL_ERROR 25218
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_TITLE 25219
#define IDS_AUTOFILL_WEBAUTHN_VERIFY_PENDING_DIALOG_CANCEL_BUTTON_LABEL 25220
#define IDS_AUTOFILL_WALLET_MANAGEMENT_LINK_TEXT 25221
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT_LONG 25222
#define IDS_AUTOFILL_CLOUD_TOKEN_DROPDOWN_OPTION_LABEL 25223
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_FALLBACK_ICON_TOOLTIP 25224
#define IDS_AUTOFILL_VIRTUAL_CARD_ENTRY_PREFIX 25225
#define IDS_AUTOFILL_VIRTUAL_CARD_ENTRY_PREFIX_TWO 25226
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_CONTENT_TITLE 25227
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_CONTENT_EXPLANATION 25228
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_OK_BUTTON_LABEL 25229
#define IDS_AUTOFILL_VIRTUAL_CARD_SELECTION_DIALOG_CANCEL_BUTTON_LABEL 25230
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_TITLE 25231
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EDUCATIONAL_BODY_LABEL 25232
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_LEARN_MORE_LINK_LABEL 25233
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARD_NUMBER_LABEL 25234
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_EXP_DATE_LABEL 25235
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CARDHOLDER_NAME_LABEL 25236
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_CVC_LABEL 25237
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_ICON_TOOLTIP 25238
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_BUTTON_TOOLTIP_NORMAL 25239
#define IDS_AUTOFILL_VIRTUAL_CARD_MANUAL_FALLBACK_BUBBLE_BUTTON_TOOLTIP_CLICKED 25240
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_IPH_BUBBLE_LABEL 25241
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_ACCEPT_BUTTON_LABEL 25242
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_TITLE_LABEL 25243
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DIALOG_CONTENT_LABEL 25244
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_SKIP 25245
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_DECLINE_BUTTON_LABEL_NO_THANKS 25246
#define IDS_AUTOFILL_VIRTUAL_CARD_ENROLLMENT_LEARN_MORE_LINK_LABEL 25247
#define IDS_AUTOFILL_VIRTUAL_CARD_SUGGESTION_OPTION_VALUE 25248
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_TITLE 25249
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_TITLE 25250
#define IDS_AUTOFILL_VIRTUAL_CARD_TEMPORARY_ERROR_DESCRIPTION 25251
#define IDS_AUTOFILL_VIRTUAL_CARD_PERMANENT_ERROR_DESCRIPTION 25252
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_TITLE 25253
#define IDS_AUTOFILL_VIRTUAL_CARD_NOT_ELIGIBLE_ERROR_DESCRIPTION 25254
#define IDS_AUTOFILL_ERROR_DIALOG_NEGATIVE_BUTTON_LABEL 25255
#define IDS_AUTOFILL_VIRTUAL_CARD_NUMBER_SWITCH_LABEL 25256
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_ISSUER_CONFIRMATION_TEXT 25259
#define IDS_AUTOFILL_AUTHENTICATION_MODE_TEXT_MESSAGE_LABEL 25260
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_CURRENT_INFO_NOT_SEEN_TEXT 25261
#define IDS_AUTOFILL_CARD_UNMASK_AUTHENTICATION_SELECTION_DIALOG_OK_BUTTON_LABEL 25262
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TITLE 25263
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_FOOTER_MESSAGE 25264
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_NEW_CODE_MESSAGE 25265
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_TEXTFIELD_PLACEHOLDER_MESSAGE 25266
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_PENDING_MESSAGE 25267
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_VERIFICATION_CODE_EXPIRED_LABEL 25268
#define IDS_AUTOFILL_CARD_UNMASK_OTP_INPUT_DIALOG_ENTER_CORRECT_CODE_LABEL 25269
#define IDS_AUTOFILL_SAVE_UPI_PROMPT_TITLE 25270
#define IDS_AUTOFILL_SAVE_UPI_PROMPT_ACCEPT 25271
#define IDS_AUTOFILL_SAVE_UPI_PROMPT_REJECT 25272
#define IDS_AUTOFILL_OFFERS_CASHBACK 25273
#define IDS_AUTOFILL_CARD_LINKED_OFFER_REMINDER_TITLE 25274
#define IDS_AUTOFILL_OFFERS_REMINDER_POSITIVE_BUTTON_LABEL 25275
#define IDS_AUTOFILL_PROMO_CODE_SUGGESTIONS_FOOTER_TEXT 25276
#define IDS_AUTOFILL_OFFERS_REMINDER_DESCRIPTION_TEXT 25277
#define IDS_AUTOFILL_OFFERS_REMINDER_ICON_TOOLTIP_TEXT 25278
#define IDS_AUTOFILL_PROMO_CODE_OFFERS_REMINDER_TITLE 25283
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_TITLE 25284
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_NORMAL 25285
#define IDS_AUTOFILL_PROMO_CODE_OFFER_BUTTON_TOOLTIP_CLICKED 25286
#define IDS_AUTOFILL_GPAY_PROMO_CODE_OFFERS_REMINDER_VALUE_PROP_TEXT 25287
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_TITLE 25288
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_CANT_FIND_CODE_MESSAGE 25289
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_OTP_INPUT_HINT 25290
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_POSITIVE_BUTTON_LABEL 25291
#define IDS_AUTOFILL_PAYMENTS_OTP_VERIFICATION_DIALOG_NEGATIVE_BUTTON_LABEL 25292
#define IDS_AUTOFILL_CLEAR_FORM_MENU_ITEM 25295
#define IDS_AUTOFILL_WARNING_INSECURE_CONNECTION 25297
#define IDS_AUTOFILL_WARNING_MIXED_FORM 25298
#define IDS_AUTOFILL_CREDIT_CARD_SIGNIN_PROMO 25299
#define IDS_AUTOFILL_DELETE_AUTOCOMPLETE_SUGGESTION_CONFIRMATION_BODY 25300
#define IDS_AUTOFILL_DELETE_CREDIT_CARD_SUGGESTION_CONFIRMATION_BODY 25301
#define IDS_AUTOFILL_DELETE_PROFILE_SUGGESTION_CONFIRMATION_BODY 25302
#define IDS_AUTOFILL_CC_AMEX 25303
#define IDS_AUTOFILL_CC_AMEX_SHORT 25304
#define IDS_AUTOFILL_CC_DINERS 25305
#define IDS_AUTOFILL_CC_DISCOVER 25306
#define IDS_AUTOFILL_CC_ELO 25307
#define IDS_AUTOFILL_CC_GOOGLE_PAY 25308
#define IDS_AUTOFILL_CC_JCB 25309
#define IDS_AUTOFILL_CC_MASTERCARD 25310
#define IDS_AUTOFILL_CC_MIR 25311
#define IDS_AUTOFILL_CC_TROY 25312
#define IDS_AUTOFILL_CC_UNION_PAY 25313
#define IDS_AUTOFILL_CC_VISA 25314
#define IDS_AUTOFILL_CC_GENERIC 25315
#define IDS_AUTOFILL_ADDRESS_SUMMARY_SEPARATOR 25316
#define IDS_AUTOFILL_HIDE_SUGGESTIONS 25317
#define IDS_AUTOFILL_MANAGE 25318
#define IDS_AUTOFILL_MANAGE_ADDRESSES 25319
#define IDS_AUTOFILL_MANAGE_PAYMENT_METHODS 25320
#define IDS_AUTOFILL_MANAGE_PASSWORDS 25321
#define IDS_AUTOFILL_SCAN_CREDIT_CARD 25322
#define IDS_AUTOFILL_SHOW_ALL_SAVED_FALLBACK 25323
#define IDS_AUTOFILL_SHOW_ACCOUNT_CARDS 25324
#define IDS_AUTOFILL_POPUP_ACCESSIBLE_NODE_DATA 25325
#define IDS_AUTOFILL_SUGGESTION_LABEL_SEPARATOR 25326
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR 25327
#define IDS_AUTOFILL_CREDIT_CARD_EXPIRATION_DATE_ABBR_V2 25328
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_NAME 25329
#define IDS_AUTOFILL_CREDIT_CARD_TWO_LINE_LABEL_FROM_CARD_NUMBER 25330
#define IDS_AUTOFILL_LOADING_REGIONS 25331
#define IDS_AUTOFILL_SELECT 25332
#define IDS_AUTOFILL_NO_SAVED_ADDRESS 25333
#define IDS_AUTOFILL_ADDRESSES 25334
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_SUBLABEL 25335
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_SUBLABEL 25336
#define IDS_AUTOFILL_ADDRESSES_SETTINGS_TITLE 25337
#define IDS_AUTOFILL_PAYMENT_METHODS 25338
#define IDS_AUTOFILL_ENABLE_PROFILES_TOGGLE_LABEL 25339
#define IDS_AUTOFILL_ENABLE_CREDIT_CARDS_TOGGLE_LABEL 25340
#define IDS_ENABLE_CREDIT_CARD_FIDO_AUTH_LABEL 25341
#define IDS_ENABLE_CREDIT_CARD_FIDO_AUTH_SUBLABEL 25342
#define IDS_AUTOFILL_ENABLE_PAYMENTS_INTEGRATION_CHECKBOX_LABEL 25343
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_OK_BUTTON_LABEL 25349
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OK_BUTTON_LABEL 25350
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_NEW_VALUES_SECTION_LABEL 25351
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_OLD_VALUES_SECTION_LABEL 25352
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_TITLE 25353
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 25364
#define IDS_AUTOFILL_SAVE_ADDRESS_PROMPT_EDIT_BUTTON_TOOLTIP 25356
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_TITLE 25354
#define IDS_AUTOFILL_UPDATE_ADDRESS_PROMPT_CANCEL_BUTTON_LABEL 25365
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_TITLE 25357
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_SAVE 25366
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_OK_BUTTON_LABEL_UPDATE 25367
#define IDS_AUTOFILL_EDIT_ADDRESS_DIALOG_CANCEL_BUTTON_LABEL 25368
#define IDS_BOOKMARK_BAR_FOLDER_NAME 239
#define IDS_BOOKMARK_BAR_MOBILE_FOLDER_NAME 241
#define IDS_BOOKMARK_BAR_OTHER_FOLDER_NAME 240
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DOMAIN_NAME 25369
#define IDS_BOOKMARK_BAR_MANAGED_FOLDER_DEFAULT_NAME 259
#define IDS_BOOKMARK_EDITOR_TITLE 25370
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_NAME 25371
#define IDS_BOOKMARK_BUBBLE_REMOVE_BOOKMARK 25372
#define IDS_BOOKMARK_MANAGER_NAME_INPUT_PLACE_HOLDER 25373
#define IDS_BOOKMARK_MANAGER_URL_INPUT_PLACE_HOLDER 25374
#define IDS_TOOLTIP_STAR 273
#define IDS_CLEAR_BROWSING_DATA_CALCULATING 25378
#define IDS_DEL_BROWSING_HISTORY_COUNTER 25379
#define IDS_DEL_BROWSING_HISTORY_COUNTER_SYNCED 25380
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE 25381
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY 25382
#define IDS_DEL_CACHE_COUNTER_BASIC 25383
#define IDS_DEL_CACHE_COUNTER_UPPER_ESTIMATE_BASIC 25384
#define IDS_DEL_CACHE_COUNTER_ALMOST_EMPTY_BASIC 25385
#define IDS_DEL_PASSWORDS_COUNTER 25386
#define IDS_DEL_PASSWORDS_COUNTER_SYNCED 25387
#define IDS_DEL_ACCOUNT_PASSWORDS_COUNTER 25388
#define IDS_DEL_PASSWORDS_DOMAINS_DISPLAY 25389
#define IDS_DEL_PASSWORDS_COUNTER_AND_X_MORE 25390
#define IDS_DEL_SIGNIN_DATA_COUNTER 25391
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_NONE 25392
#define IDS_DEL_PASSWORDS_AND_SIGNIN_DATA_COUNTER_COMBINATION 25393
#define IDS_DEL_SITE_SETTINGS_COUNTER 25394
#define IDS_DEL_AUTOFILL_COUNTER_EMPTY 25395
#define IDS_DEL_AUTOFILL_COUNTER_CREDIT_CARDS 25396
#define IDS_DEL_AUTOFILL_COUNTER_ADDRESSES 25397
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS 25398
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_LONG 25399
#define IDS_DEL_AUTOFILL_COUNTER_SUGGESTIONS_SHORT 25400
#define IDS_DEL_AUTOFILL_COUNTER_ONE_TYPE_SYNCED 25401
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES 25402
#define IDS_DEL_AUTOFILL_COUNTER_TWO_TYPES_SYNCED 25403
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES 25404
#define IDS_DEL_AUTOFILL_COUNTER_THREE_TYPES_SYNCED 25405
#define IDS_DEL_COOKIES_COUNTER 25406
#define IDS_DEL_COOKIES_COUNTER_ADVANCED 25407
#define IDS_DEL_COOKIES_COUNTER_ADVANCED_WITH_EXCEPTION 25408
#define IDS_DEL_DOWNLOADS_COUNTER 25409
#define IDS_DEL_HOSTED_APPS_COUNTER 25410
#define IDS_DEL_HOSTED_APPS_COUNTER_AND_X_MORE 25411
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_TITLE 25412
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_CONTENT 25413
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_NO_THANKS 25414
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_GET_DISCOUNTS 25415
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_TITLE 25416
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_CONTENT 25417
#define IDS_DISCOUNT_CONTEXTUAL_CONSENT_ACCEPTED_CONFIRMATION_DONE 25418
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_ACCEPT_BUTTON 25419
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_TITLE 25420
#define IDS_NATIVE_NTP_CART_DISCOUNT_CONSENT_BODY 25421
#define IDS_LIVE_CAPTION_BUBBLE_TITLE 25422
#define IDS_LIVE_CAPTION_BUBBLE_CLOSE 25423
#define IDS_LIVE_CAPTION_BUBBLE_EXPAND 25424
#define IDS_LIVE_CAPTION_BUBBLE_COLLAPSE 25425
#define IDS_LIVE_CAPTION_BUBBLE_BACK_TO_TAB 25426
#define IDS_LIVE_CAPTION_BUBBLE_ERROR 25427
#define IDS_LIVE_CAPTION_BUBBLE_CONTENT_SETTINGS 25428
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR 25429
#define IDS_LIVE_CAPTION_BUBBLE_MEDIA_FOUNDATION_RENDERER_ERROR_CHECKBOX 25430
#define IDS_LIVE_CAPTION_BUBBLE_APPEAR_SCREENREADER_ANNOUNCEMENT 25431
#define IDS_SETTINGS_TITLE 25432
#define IDS_SETTINGS_HIDE_ADVANCED_SETTINGS 25433
#define IDS_SETTINGS_SHOW_ADVANCED_SETTINGS 25434
#define IDS_NETWORK_PREDICTION_ENABLED_DESCRIPTION 25435
#define IDS_OPTIONS_PROXIES_CONFIGURE_BUTTON 25436
#define IDS_CRASH_TITLE 25457
#define IDS_CRASH_CRASH_COUNT_BANNER_FORMAT 25458
#define IDS_CRASH_SHOW_DEVELOPER_DETAILS 25459
#define IDS_CRASH_CAPTURE_TIME_FORMAT 25460
#define IDS_CRASH_REPORT_STATUS 25461
#define IDS_CRASH_REPORT_STATUS_NOT_UPLOADED 25462
#define IDS_CRASH_REPORT_STATUS_PENDING 25463
#define IDS_CRASH_REPORT_STATUS_PENDING_USER_REQUESTED 25464
#define IDS_CRASH_REPORT_STATUS_UPLOADED 25465
#define IDS_CRASH_REPORT_UPLOADED_ID 25466
#define IDS_CRASH_REPORT_UPLOADED_TIME 25467
#define IDS_CRASH_REPORT_LOCAL_ID 25468
#define IDS_CRASH_REPORT_FILE_SIZE 25469
#define IDS_CRASH_BUG_LINK_LABEL 25470
#define IDS_CRASH_NO_CRASHES_MESSAGE 25471
#define IDS_CRASH_DISABLED_HEADER 25472
#define IDS_CRASH_UPLOAD_MESSAGE 25473
#define IDS_CRASH_UPLOAD_NOW_LINK_TEXT 25474
#define IDS_HTTP_POST_WARNING_TITLE 25475
#define IDS_HTTP_POST_WARNING 25476
#define IDS_HTTP_POST_WARNING_RESEND 25477
#define IDS_DOM_DISTILLER_JAVASCRIPT_DISABLED_CONTENT 25478
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_URL 25479
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD 25480
#define IDS_DOM_DISTILLER_WEBUI_ENTRY_ADD_FAILED 25481
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL 25482
#define IDS_DOM_DISTILLER_WEBUI_VIEW_URL_FAILED 25483
#define IDS_DOM_DISTILLER_WEBUI_REFRESH 25484
#define IDS_DOM_DISTILLER_WEBUI_FETCHING_ENTRIES 25485
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_TITLE 25486
#define IDS_DOM_DISTILLER_VIEWER_FAILED_TO_FIND_ARTICLE_CONTENT 25487
#define IDS_DOM_DISTILLER_VIEWER_LOADING_TITLE 25488
#define IDS_DOM_DISTILLER_VIEWER_CUSTOMIZE_APPEARANCE 25489
#define IDS_DOM_DISTILLER_VIEWER_FONT_STYLE 25490
#define IDS_DOM_DISTILLER_VIEWER_SANS_SERIF_FONT 25491
#define IDS_DOM_DISTILLER_VIEWER_SERIF_FONT 25492
#define IDS_DOM_DISTILLER_VIEWER_MONOSPACE_FONT 25493
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR 25494
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_LIGHT 25495
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_SEPIA 25496
#define IDS_DOM_DISTILLER_VIEWER_PAGE_COLOR_DARK 25497
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE 25498
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_SMALL 25499
#define IDS_DOM_DISTILLER_VIEWER_FONT_SIZE_LARGE 25500
#define IDS_DOM_DISTILLER_VIEWER_CLOSE 25501
#define IDS_DOM_DISTILLER_VIEWER_NO_DATA_CONTENT 25502
#define IDS_DOM_DISTILLER_WEBUI_TITLE 25503
#define IDS_DOM_DISTILLER_VIEWER_TITLE_SUFFIX 25504
#define IDS_ENTERPRISE_COPY_PREVENTION_MISSING_LIST_ERROR 25505
#define IDS_ENTERPRISE_COPY_PREVENTION_DISABLE_CONTAINS_WILDCARD_ERROR 25506
#define IDS_ENTERPRISE_COPY_PREVENTION_WARNING_MESSAGE 25507
#define IDS_ERRORPAGE_NET_BUTTON_DETAILS 25508
#define IDS_ERRORPAGE_NET_BUTTON_HIDE_DETAILS 25509
#define IDS_ERRORPAGES_BUTTON_RELOAD 25510
#define IDS_ERRORPAGES_BUTTON_SHOW_SAVED_COPY 25511
#define IDS_ERRORPAGE_FUN_DISABLED 25512
#define IDS_ERRORPAGES_SUGGESTION_RELOAD_REPOST_SUMMARY 25522
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_HEADER 25523
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_BODY 25524
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_HEADER 25525
#define IDS_ERRORPAGES_SUGGESTION_SECURE_DNS_CONFIG_BODY 25526
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_HEADER 25527
#define IDS_ERRORPAGES_SUGGESTION_DNS_CONFIG_BODY 25528
#define IDS_ERRORPAGES_SUGGESTION_NETWORK_PREDICTION_HEADER 25529
#define IDS_ERRORPAGES_SUGGESTION_FIREWALL_CONFIG_BODY 25530
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_HEADER 25531
#define IDS_ERRORPAGES_SUGGESTION_PROXY_CONFIG_BODY 25532
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_HEADER 25534
#define IDS_ERRORPAGES_SUGGESTION_VIEW_POLICIES_BODY 25535
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_HEADER 25536
#define IDS_ERRORPAGES_SUGGESTION_UNSUPPORTED_CIPHER_BODY 25537
#define IDS_ERRORPAGES_SUGGESTION_NAVIGATE_TO_ORIGIN 25538
#define IDS_ERRORPAGES_HEADING_NOT_AVAILABLE 25539
#define IDS_ERRORPAGES_HEADING_NETWORK_ACCESS_DENIED 25540
#define IDS_ERRORPAGES_HEADING_INTERNET_DISCONNECTED 25541
#define IDS_ERRORPAGES_HEADING_CACHE_READ_FAILURE 25542
#define IDS_ERRORPAGES_HEADING_CONNECTION_INTERRUPTED 25543
#define IDS_ERRORPAGES_HEADING_NOT_FOUND 25544
#define IDS_ERRORPAGES_HEADING_FILE_NOT_FOUND 25545
#define IDS_ERRORPAGES_HEADING_BLOCKED 25546
#define IDS_ERRORPAGES_HEADING_BLOCKED_SCHEME 25547
#define IDS_ERRORPAGES_SUMMARY_NOT_AVAILABLE 25548
#define IDS_ERRORPAGES_SUMMARY_TIMED_OUT 25549
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_RESET 25550
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_CLOSED 25551
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_FAILED 25552
#define IDS_ERRORPAGES_SUMMARY_NETWORK_CHANGED 25553
#define IDS_ERRORPAGES_SUMMARY_CONNECTION_REFUSED 25554
#define IDS_ERRORPAGES_SUMMARY_NAME_NOT_RESOLVED 25555
#define IDS_ERRORPAGES_SUMMARY_ICANN_NAME_COLLISION 25556
#define IDS_ERRORPAGES_SUMMARY_ADDRESS_UNREACHABLE 25557
#define IDS_ERRORPAGES_SUMMARY_FILE_ACCESS_DENIED 25558
#define IDS_ERRORPAGES_SUMMARY_NETWORK_ACCESS_DENIED 25559
#define IDS_ERRORPAGES_SUMMARY_PROXY_CONNECTION_FAILED 25560
#define IDS_ERRORPAGES_SUMMARY_CACHE_READ_FAILURE 25561
#define IDS_ERRORPAGES_SUMMARY_NETWORK_IO_SUSPENDED 25562
#define IDS_ERRORPAGES_SUMMARY_NOT_FOUND 25563
#define IDS_ERRORPAGES_SUMMARY_FILE_NOT_FOUND 25564
#define IDS_ERRORPAGES_SUMMARY_TOO_MANY_REDIRECTS 25565
#define IDS_ERRORPAGES_SUMMARY_EMPTY_RESPONSE 25566
#define IDS_ERRORPAGES_SUMMARY_INVALID_RESPONSE 25567
#define IDS_ERRORPAGES_SUMMARY_DNS_PROBE_RUNNING 25568
#define IDS_ERRORPAGES_HEADING_ACCESS_DENIED 25569
#define IDS_ERRORPAGES_HEADING_FILE_ACCESS_DENIED 25570
#define IDS_ERRORPAGES_SUMMARY_FORBIDDEN 25571
#define IDS_ERRORPAGES_SUMMARY_GONE 25572
#define IDS_ERRORPAGES_HEADING_PAGE_NOT_WORKING 25573
#define IDS_ERRORPAGES_SUMMARY_CONTACT_SITE_OWNER 25574
#define IDS_ERRORPAGES_SUMMARY_WEBSITE_CANNOT_HANDLE_REQUEST 25575
#define IDS_ERRORPAGES_SUMMARY_GATEWAY_TIMEOUT 25576
#define IDS_ERRORPAGES_SUMMARY_SSL_SECURITY_ERROR 25577
#define IDS_ERRORPAGES_SUMMARY_SSL_VERSION_OR_CIPHER_MISMATCH 25578
#define IDS_ERRORPAGES_HEADING_INSECURE_CONNECTION 25579
#define IDS_ERRORPAGES_SUMMARY_BAD_SSL_CLIENT_AUTH_CERT 25580
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_EXTENSION 25581
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_ADMINISTRATOR 25582
#define IDS_ERRORPAGES_SUMMARY_BLOCKED_BY_SECURITY 25583
#define IDS_ERRORPAGES_HTTP_POST_WARNING 25584
#define IDS_ERRORPAGES_SUGGESTION_LIST_HEADER 25585
#define IDS_ERRORPAGES_SUGGESTION_CHECK_CONNECTION_SUMMARY 25586
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_DNS_SUMMARY 25588
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SECURE_DNS_SUMMARY 25589
#define IDS_ERRORPAGES_SUGGESTION_CHECK_FIREWALL_ANTIVIRUS_SUMMARY 25590
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_FIREWALL_SUMMARY 25591
#define IDS_ERRORPAGES_SUGGESTION_CHECK_PROXY_ADDRESS_SUMMARY 25592
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY 25593
#define IDS_ERRORPAGES_SUGGESTION_CONTACT_ADMIN_SUMMARY_STANDALONE 25594
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY 25595
#define IDS_ERRORPAGES_SUGGESTION_LEARNMORE_SUMMARY_STANDALONE 25596
#define IDS_ERRORPAGES_SUGGESTION_CLEAR_COOKIES_SUMMARY 25597
#define IDS_ERRORPAGES_SUGGESTION_CHECK_HARDWARE_SUMMARY 25601
#define IDS_ERRORPAGES_SUGGESTION_CHECK_WIFI_SUMMARY 25602
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_CONNECTION_SUMMARY 25603
#define IDS_ERRORPAGES_SUGGESTION_COMPLETE_SETUP_SUMMARY 25604
#define IDS_ERRORPAGES_SUGGESTION_DISABLE_EXTENSION_SUMMARY 25605
#define IDS_ERRORPAGES_CHECK_TYPO_SUMMARY 25606
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE 25607
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_STANDALONE 25608
#define IDS_ERRORPAGES_SUGGESTION_DIAGNOSE_CHECK_TYPO_STANDALONE 25609
#define IDS_ERRORPAGES_GAME_INSTRUCTIONS 25610
#define IDS_ERRORPAGE_DINO_GAME_DESCRIPTION 25611
#define IDS_ERRORPAGE_DINO_ARIA_LABEL 25612
#define IDS_ERRORPAGE_DINO_GAME_START 25613
#define IDS_ERRORPAGE_DINO_GAME_OVER 25614
#define IDS_ERRORPAGE_DINO_HIGH_SCORE 25615
#define IDS_ERRORPAGE_DINO_JUMP 25616
#define IDS_ERRORPAGE_DINO_SLOW_SPEED_TOGGLE 25617
#define IDS_FIND_IN_PAGE_ACCESSIBLE_TITLE 25618
#define IDS_FIND_IN_PAGE_COUNT 25619
#define IDS_ACCESSIBLE_FIND_IN_PAGE_COUNT 25620
#define IDS_ACCESSIBLE_FIND_IN_PAGE_NO_RESULTS 25621
#define IDS_FIND_IN_PAGE_PREVIOUS_TOOLTIP 25622
#define IDS_FIND_IN_PAGE_NEXT_TOOLTIP 25623
#define IDS_FIND_IN_PAGE_CLOSE_TOOLTIP 25624
#define IDS_FLAGS_UI_SEARCH_PLACEHOLDER 25625
#define IDS_FLAGS_UI_SEARCH_LABEL 25626
#define IDS_FLAGS_UI_TITLE 25627
#define IDS_FLAGS_UI_PAGE_RESET 25628
#define IDS_FLAGS_UI_PAGE_WARNING 25629
#define IDS_FLAGS_UI_PAGE_WARNING_EXPLANATION 25630
#define IDS_FLAGS_UI_OWNER_WARNING 25631
#define IDS_FLAGS_UI_AVAILABLE_FEATURE 25632
#define IDS_FLAGS_UI_UNAVAILABLE_FEATURE 25633
#define IDS_FLAGS_UI_ENABLED_FEATURE 25634
#define IDS_FLAGS_UI_DISABLED_FEATURE 25635
#define IDS_FLAGS_UI_NO_RESULTS 25636
#define IDS_FLAGS_UI_NOT_AVAILABLE_ON_PLATFORM 25637
#define IDS_FLAGS_UI_RELAUNCH 25638
#define IDS_FLAGS_UI_CLEAR_SEARCH 25642
#define IDS_FLAGS_UI_RESET_ACKNOWLEDGED 25643
#define IDS_FLAGS_UI_EXPERIMENT_ENABLED 25644
#define IDS_FLAGS_UI_SEARCH_RESULTS_SINGULAR 25645
#define IDS_FLAGS_UI_SEARCH_RESULTS_PLURAL 25646
#define IDS_DEPRECATED_FEATURES_PAGE_RESET 25647
#define IDS_DEPRECATED_FEATURES_OWNER_WARNING 25648
#define IDS_DEPRECATED_FEATURES_AVAILABLE_FEATURE 25649
#define IDS_DEPRECATED_FEATURES_UNAVAILABLE_FEATURE 25650
#define IDS_DEPRECATED_FEATURES_ENABLED_FEATURE 25651
#define IDS_DEPRECATED_FEATURES_DISABLED_FEATURE 25652
#define IDS_DEPRECATED_FEATURES_NOT_AVAILABLE_ON_PLATFORM 25653
#define IDS_DEPRECATED_FEATURES_RELAUNCH 25654
#define IDS_DEPRECATED_FEATURES_SEARCH_PLACEHOLDER 25658
#define IDS_DEPRECATED_FEATURES_TITLE 25659
#define IDS_DEPRECATED_FEATURES_HEADING 25660
#define IDS_DEPRECATED_FEATURES_PAGE_WARNING_EXPLANATION 25661
#define IDS_DEPRECATED_FEATURES_NO_RESULTS 25662
#define IDS_DEPRECATED_UI_CLEAR_SEARCH 25663
#define IDS_DEPRECATED_UI_RESET_ACKNOWLEDGED 25664
#define IDS_DEPRECATED_UI_EXPERIMENT_ENABLED 25665
#define IDS_ENTERPRISE_UI_SEARCH_RESULTS_SINGULAR 25666
#define IDS_ENTERPRISE_UI_SEARCH_RESULTS_PLURAL 25667
#define IDS_EXIT_FULLSCREEN_MODE 25668
#define IDS_FULLSCREEN_HOLD_TO_EXIT_FULLSCREEN 25669
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN 25670
#define IDS_FULLSCREEN_PRESS_TO_EXIT_FULLSCREEN_TWO_KEYS 25671
#define IDS_PRESS_TO_EXIT_MOUSELOCK 25672
#define IDS_PRESS_TO_EXIT_MOUSELOCK_TWO_KEYS 25673
#define IDS_FULLSCREEN_PRESS_TO_SEE_DOWNLOADS 25674
#define IDS_GLOBAL_MEDIA_CONTROLS_BACK_TO_TAB 25675
#define IDS_GLOBAL_MEDIA_CONTROLS_DISMISS_ICON_TOOLTIP_TEXT 25676
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_DETAILS 25677
#define IDS_HEAVY_AD_INTERVENTION_HEADING 25678
#define IDS_HEAVY_AD_INTERVENTION_SUMMARY 25679
#define IDS_HEAVY_AD_INTERVENTION_BUTTON_RELOAD 25680
#define IDS_HISTORY_ACTION_MENU_DESCRIPTION 25681
#define IDS_HISTORY_ARIA_ROLE_DESCRIPTION 25682
#define IDS_HISTORY_CANCEL_EDITING_BUTTON 25683
#define IDS_HISTORY_DATE_WITH_RELATIVE_TIME 25684
#define IDS_HISTORY_DELETE_PRIOR_VISITS_CONFIRM_BUTTON 25685
#define IDS_HISTORY_DELETE_PRIOR_VISITS_WARNING 25686
#define IDS_HISTORY_DELETE_SELECTED_ENTRIES_BUTTON 25687
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_DELETE 25688
#define IDS_HISTORY_ENTRY_ACCESSIBILITY_LABEL 25689
#define IDS_HISTORY_ENTRY_BOOKMARKED 25690
#define IDS_HISTORY_ENTRY_SUMMARY 25691
#define IDS_HISTORY_FOUND_SEARCH_RESULTS 25692
#define IDS_HISTORY_OTHER_FORMS_OF_HISTORY 25693
#define IDS_HISTORY_LOADING 25694
#define IDS_HISTORY_MORE_FROM_SITE 25695
#define IDS_HISTORY_NO_RESULTS 25696
#define IDS_HISTORY_NO_SEARCH_RESULTS 25697
#define IDS_HISTORY_OPEN_CLEAR_BROWSING_DATA_DIALOG 25698
#define IDS_HISTORY_OTHER_SESSIONS_COLLAPSE_SESSION 25699
#define IDS_HISTORY_OTHER_SESSIONS_EXPAND_SESSION 25700
#define IDS_HISTORY_OTHER_SESSIONS_HIDE_FOR_NOW 25701
#define IDS_HISTORY_OTHER_SESSIONS_OPEN_ALL 25702
#define IDS_HISTORY_REMOVE_BOOKMARK 25703
#define IDS_HISTORY_REMOVE_PAGE 25704
#define IDS_HISTORY_REMOVE_PAGE_SUCCESS 25705
#define IDS_HISTORY_REMOVE_SELECTED_ITEMS 25706
#define IDS_HISTORY_SEARCH_BUTTON 25707
#define IDS_HISTORY_SEARCH_RESULT 25708
#define IDS_HISTORY_SEARCH_RESULTS 25709
#define IDS_HISTORY_SHOW_HISTORY 280
#define IDS_HISTORY_SHOWFULLHISTORY_LINK 172
#define IDS_HISTORY_START_EDITING_BUTTON 25710
#define IDS_HISTORY_TITLE 25711
#define IDS_HISTORY_UNKNOWN_DEVICE 25712
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE 25713
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_IFRAME 25714
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL 25715
#define IDS_JAVASCRIPT_MESSAGEBOX_TITLE_NONSTANDARD_URL_IFRAME 25716
#define IDS_JAVASCRIPT_MESSAGEBOX_SUPPRESS_OPTION 25717
#define IDS_BEFOREUNLOAD_MESSAGEBOX_TITLE 25718
#define IDS_BEFOREUNLOAD_APP_MESSAGEBOX_TITLE 25719
#define IDS_BEFOREUNLOAD_MESSAGEBOX_OK_BUTTON_LABEL 25720
#define IDS_BEFOREUNLOAD_MESSAGEBOX_MESSAGE 25721
#define IDS_BEFORERELOAD_MESSAGEBOX_TITLE 25722
#define IDS_BEFORERELOAD_APP_MESSAGEBOX_TITLE 25723
#define IDS_BEFORERELOAD_MESSAGEBOX_OK_BUTTON_LABEL 25724
#define IDS_LOGIN_DIALOG_TITLE 25725
#define IDS_LOGIN_DIALOG_OK_BUTTON_LABEL 25726
#define IDS_LOGIN_DIALOG_AUTHORITY 25727
#define IDS_LOGIN_DIALOG_PROXY_AUTHORITY 25728
#define IDS_LOGIN_DIALOG_NOT_PRIVATE 25729
#define IDS_LOGIN_DIALOG_USERNAME_FIELD 25730
#define IDS_LOGIN_DIALOG_PASSWORD_FIELD 25731
#define IDS_MANAGEMENT_TITLE 25732
#define IDS_MANAGEMENT_TOOLBAR_TITLE 25733
#define IDS_MANAGEMENT_SUBTITLE 25737
#define IDS_MANAGEMENT_SUBTITLE_MANAGED_BY 25735
#define IDS_MANAGEMENT_NOT_MANAGED_SUBTITLE 25736
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_DIFFERENT_MANAGED_BY 25738
#define IDS_MANAGEMENT_SUBTITLE_BROWSER_AND_PROFILE_SAME_MANAGED_BY 25739
#define IDS_MANAGEMENT_SUBTITLE_PROFILE_MANAGED_BY 25740
#define IDS_MANAGEMENT_BROWSER_NOTICE 25741
#define IDS_MANAGEMENT_NOT_MANAGED_NOTICE 25742
#define IDS_MANAGEMENT_EXTENSION_REPORTING 25774
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED 25775
#define IDS_MANAGEMENT_EXTENSIONS_INSTALLED_BY 25776
#define IDS_MANAGEMENT_EXTENSIONS_NAME 25777
#define IDS_MANAGEMENT_EXTENSIONS_PERMISSIONS 25778
#define IDS_MANAGEMENT_MANAGED_WEBSITES 25779
#define IDS_MANAGEMENT_MANAGED_WEBSITES_EXPLANATION 25780
#define IDS_MANAGEMENT_MANAGED_WEBSITES_BY_EXPLANATION 25781
#define IDS_MANAGEMENT_BROWSER_REPORTING 25782
#define IDS_MANAGEMENT_BROWSER_REPORTING_EXPLANATION 25783
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME 25784
#define IDS_MANAGEMENT_EXTENSION_REPORT_MACHINE_NAME_ADDRESS 25785
#define IDS_MANAGEMENT_EXTENSION_REPORT_USERNAME 25786
#define IDS_MANAGEMENT_EXTENSION_REPORT_VERSION 25787
#define IDS_MANAGEMENT_EXTENSION_REPORT_EXTENSIONS_PLUGINS 25788
#define IDS_MANAGEMENT_EXTENSION_REPORT_USER_BROWSING_DATA 25789
#define IDS_MANAGEMENT_EXTENSION_REPORT_PERF_CRASH 25790
#define IDS_MANAGEMENT_THREAT_PROTECTION 25791
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION 25792
#define IDS_MANAGEMENT_THREAT_PROTECTION_DESCRIPTION_BY 25793
#define IDS_MANAGEMENT_CONNECTORS_EVENT 25794
#define IDS_MANAGEMENT_CONNECTORS_VISIBLE_DATA 25795
#define IDS_MANAGEMENT_FILE_ATTACHED_EVENT 25796
#define IDS_MANAGEMENT_FILE_DOWNLOADED_EVENT 25797
#define IDS_MANAGEMENT_TEXT_ENTERED_EVENT 25798
#define IDS_MANAGEMENT_PAGE_PRINTED_EVENT 25799
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_EVENT 25800
#define IDS_MANAGEMENT_PAGE_VISITED_EVENT 25801
#define IDS_MANAGEMENT_FILE_ATTACHED_VISIBLE_DATA 25802
#define IDS_MANAGEMENT_FILE_DOWNLOADED_VISIBLE_DATA 25803
#define IDS_MANAGEMENT_TEXT_ENTERED_VISIBLE_DATA 25804
#define IDS_MANAGEMENT_PAGE_PRINTED_VISIBLE_DATA 25805
#define IDS_MANAGEMENT_ENTERPRISE_REPORTING_VISIBLE_DATA 25806
#define IDS_MANAGEMENT_PAGE_VISITED_VISIBLE_DATA 25807
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PREVIOUS_TRACK 25808
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_BACKWARD 25809
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PLAY 25810
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_PAUSE 25811
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_SEEK_FORWARD 25812
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_NEXT_TRACK 25813
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_ENTER_PIP 25814
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_EXIT_PIP 25815
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_MUTE 25816
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACTION_UNMUTE 25817
#define IDS_MEDIA_MESSAGE_CENTER_MEDIA_NOTIFICATION_ACCESSIBLE_NAME 25818
#define IDS_DEFAULT_TAB_TITLE 320
#define IDS_DOWNLOAD_TAB_TITLE 25819
#define IDS_SAD_TAB_TITLE 25820
#define IDS_SAD_TAB_MESSAGE 25821
#define IDS_SAD_TAB_HELP_MESSAGE 25822
#define IDS_SAD_TAB_HELP_LINK 25823
#define IDS_SAD_TAB_RELOAD_LABEL 25824
#define IDS_SAD_TAB_RELOAD_TITLE 25827
#define IDS_SAD_TAB_OOM_MESSAGE_TABS 25828
#define IDS_SAD_TAB_OOM_MESSAGE_NOTABS 25829
#define IDS_SAD_TAB_RELOAD_TRY 25830
#define IDS_SAD_TAB_RELOAD_INCOGNITO 25831
#define IDS_SAD_TAB_RELOAD_CLOSE_TABS 25832
#define IDS_SAD_TAB_RELOAD_CLOSE_NOTABS 25833
#define IDS_SAD_TAB_RELOAD_RESTART_BROWSER 25834
#define IDS_SAD_TAB_RELOAD_RESTART_DEVICE 25835
#define IDS_SAD_TAB_ERROR_CODE 25837
#define IDS_NEW_TAB_TITLE 319
#define IDS_NEW_INCOGNITO_TAB_TITLE 25838
#define IDS_NEW_TAB_OTR_HEADING 25839
#define IDS_NEW_TAB_OTR_DESCRIPTION 25840
#define IDS_NEW_TAB_OTR_LEARN_MORE_LINK 25841
#define IDS_NEW_TAB_OTR_MESSAGE_WARNING 25842
#define IDS_NEW_TAB_UNDO_THUMBNAIL_REMOVE 25843
#define IDS_NEW_TAB_OTR_TITLE 25844
#define IDS_NEW_TAB_OTR_SUBTITLE 25845
#define IDS_NEW_TAB_OTR_SUBTITLE_WITH_READING_LIST 25846
#define IDS_NEW_TAB_OTR_NOT_SAVED 25847
#define IDS_NEW_TAB_OTR_VISIBLE 25848
#define IDS_NEW_TAB_OTR_COOKIE_CONTROLS_CONTROLLED_TOOLTIP_TEXT 25849
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE 25850
#define IDS_NEW_TAB_OTR_THIRD_PARTY_COOKIE_SUBLABEL 25851
#define IDS_REVAMPED_INCOGNITO_NTP_TITLE 25852
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_HEADER 25853
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_DESCRIPTION 25854
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_NOT_HEADER 25855
#define IDS_REVAMPED_INCOGNITO_NTP_DOES_NOT_DESCRIPTION 25856
#define IDS_REVAMPED_INCOGNITO_NTP_LEARN_MORE 25857
#define IDS_REVAMPED_INCOGNITO_NTP_OTR_THIRD_PARTY_COOKIE 25858
#define IDS_REVAMPED_INCOGNITO_NTP_OTR_THIRD_PARTY_COOKIE_SUBLABEL 25859
#define IDS_NTP_ARTICLE_SUGGESTIONS_NOT_AVAILABLE 25861
#define IDS_NTP_ARTICLE_SUGGESTIONS_SECTION_HEADER 25862
#define IDS_NTP_ARTICLE_SUGGESTIONS_SECTION_EMPTY 25863
#define IDS_NTP_READING_LIST_SUGGESTIONS_SECTION_HEADER 25864
#define IDS_NTP_READING_LIST_SUGGESTIONS_SECTION_EMPTY 25865
#define IDS_NTP_RECENT_TAB_SUGGESTIONS_SECTION_HEADER 25866
#define IDS_NTP_RECENT_TAB_SUGGESTIONS_SECTION_EMPTY 25867
#define IDS_NTP_NOTIFICATIONS_READ_THIS_STORY_AND_MORE 25868
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 25869
#define IDS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUGGESTION_CONTENTS 25870
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_SUFFIX 25871
#define IDS_ACC_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA 25872
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 25873
#define IDS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUGGESTION_CONTENTS 25874
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS_SUFFIX 25875
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_PASSWORDS 25876
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 25877
#define IDS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUGGESTION_CONTENTS 25878
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_SUFFIX 25879
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD 25880
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 25881
#define IDS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 25882
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 25883
#define IDS_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 25884
#define IDS_OMNIBOX_PEDAL_TRANSLATE_HINT 25885
#define IDS_OMNIBOX_PEDAL_TRANSLATE_SUGGESTION_CONTENTS 25886
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE_SUFFIX 25887
#define IDS_ACC_OMNIBOX_PEDAL_TRANSLATE 25888
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_HINT 25889
#define IDS_OMNIBOX_PEDAL_UPDATE_CHROME_SUGGESTION_CONTENTS 25890
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME_SUFFIX 25891
#define IDS_ACC_OMNIBOX_PEDAL_UPDATE_CHROME 25892
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 25893
#define IDS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUGGESTION_CONTENTS 25894
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_SUFFIX 25895
#define IDS_ACC_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK 25896
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_HINT 25897
#define IDS_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUGGESTION_CONTENTS 25898
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS_SUFFIX 25899
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SECURITY_SETTINGS 25900
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_HINT 25901
#define IDS_OMNIBOX_PEDAL_MANAGE_COOKIES_SUGGESTION_CONTENTS 25902
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES_SUFFIX 25903
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_COOKIES 25904
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_HINT 25905
#define IDS_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUGGESTION_CONTENTS 25906
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES_SUFFIX 25907
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_ADDRESSES 25908
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_HINT 25909
#define IDS_OMNIBOX_PEDAL_MANAGE_SYNC_SUGGESTION_CONTENTS 25910
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC_SUFFIX 25911
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SYNC 25912
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_HINT 25913
#define IDS_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUGGESTION_CONTENTS 25914
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS_SUFFIX 25915
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_SITE_SETTINGS 25916
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_HINT 25917
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUGGESTION_CONTENTS 25918
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC_SUFFIX 25919
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_DOC 25920
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_HINT 25921
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUGGESTION_CONTENTS 25922
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET_SUFFIX 25923
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SHEET 25924
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_HINT 25925
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUGGESTION_CONTENTS 25926
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE_SUFFIX 25927
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SLIDE 25928
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_HINT 25929
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUGGESTION_CONTENTS 25930
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT_SUFFIX 25931
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_CALENDAR_EVENT 25932
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_HINT 25933
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUGGESTION_CONTENTS 25934
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE_SUFFIX 25935
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_SITE 25936
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_HINT 25937
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUGGESTION_CONTENTS 25938
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE_SUFFIX 25939
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_KEEP_NOTE 25940
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_HINT 25941
#define IDS_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUGGESTION_CONTENTS 25942
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM_SUFFIX 25943
#define IDS_ACC_OMNIBOX_PEDAL_CREATE_GOOGLE_FORM 25944
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_HINT 25945
#define IDS_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUGGESTION_CONTENTS 25946
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS_SUFFIX 25947
#define IDS_ACC_OMNIBOX_PEDAL_SEE_CHROME_TIPS 25948
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_HINT 25949
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUGGESTION_CONTENTS 25950
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT_SUFFIX 25951
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_ACCOUNT 25952
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_HINT 25953
#define IDS_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUGGESTION_CONTENTS 25954
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD_SUFFIX 25955
#define IDS_ACC_OMNIBOX_PEDAL_CHANGE_GOOGLE_PASSWORD 25956
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_HINT 25957
#define IDS_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUGGESTION_CONTENTS 25958
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS_SUFFIX 25959
#define IDS_ACC_OMNIBOX_PEDAL_CLOSE_INCOGNITO_WINDOWS 25960
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 25961
#define IDS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUGGESTION_CONTENTS 25962
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_SUFFIX 25963
#define IDS_ACC_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME 25964
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_HINT 25965
#define IDS_OMNIBOX_PEDAL_FIND_MY_PHONE_SUGGESTION_CONTENTS 25966
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE_SUFFIX 25967
#define IDS_ACC_OMNIBOX_PEDAL_FIND_MY_PHONE 25968
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_HINT 25969
#define IDS_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUGGESTION_CONTENTS 25970
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY_SUFFIX 25971
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_GOOGLE_PRIVACY 25972
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 25973
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUGGESTION_CONTENTS 25974
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_SUFFIX 25975
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS 25976
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_HINT 25977
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUGGESTION_CONTENTS 25978
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS_SUFFIX 25979
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_DOWNLOADS 25980
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 25981
#define IDS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUGGESTION_CONTENTS 25982
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_SUFFIX 25983
#define IDS_ACC_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY 25984
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_HINT 25985
#define IDS_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUGGESTION_CONTENTS 25986
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE_SUFFIX 25987
#define IDS_ACC_OMNIBOX_PEDAL_SHARE_THIS_PAGE 25988
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_HINT 25989
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUGGESTION_CONTENTS 25990
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY_SUFFIX 25991
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_ACCESSIBILITY 25992
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_HINT 25993
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUGGESTION_CONTENTS 25994
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS_SUFFIX 25995
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_CHROME_FONTS 25996
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_HINT 25997
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUGGESTION_CONTENTS 25998
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES_SUFFIX 25999
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROME_THEMES 26000
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_HINT 26001
#define IDS_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUGGESTION_CONTENTS 26002
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES_SUFFIX 26003
#define IDS_ACC_OMNIBOX_PEDAL_CUSTOMIZE_SEARCH_ENGINES 26004
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_HINT 26005
#define IDS_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUGGESTION_CONTENTS 26006
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY_SUFFIX 26007
#define IDS_ACC_OMNIBOX_PEDAL_MANAGE_CHROMEOS_ACCESSIBILITY 26008
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 26009
#define IDS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUGGESTION_CONTENTS 26010
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_SUFFIX 26011
#define IDS_ACC_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER 26012
#define IDS_ANDROID_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 26013
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 26014
#define IDS_ANDROID_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 26015
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUFFIX 26016
#define IDS_ANDROID_ACC_OMNIBOX_PEDAL_LAUNCH_INCOGNITO 26017
#define IDS_IOS_OMNIBOX_PEDAL_CLEAR_BROWSING_DATA_HINT 26018
#define IDS_IOS_OMNIBOX_PEDAL_SET_CHROME_AS_DEFAULT_BROWSER_HINT 26019
#define IDS_IOS_OMNIBOX_PEDAL_UPDATE_CREDIT_CARD_HINT 26020
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_HINT 26021
#define IDS_IOS_OMNIBOX_PEDAL_RUN_CHROME_SAFETY_CHECK_HINT 26022
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_CHROME_SETTINGS_HINT 26023
#define IDS_IOS_OMNIBOX_PEDAL_VIEW_CHROME_HISTORY_HINT 26024
#define IDS_IOS_OMNIBOX_PEDAL_PLAY_CHROME_DINO_GAME_HINT 26025
#define IDS_IOS_OMNIBOX_PEDAL_LAUNCH_INCOGNITO_SUGGESTION_CONTENTS 26026
#define IDS_IOS_OMNIBOX_PEDAL_MANAGE_PASSWORDS_HINT 26027
#define IDS_AUTOCOMPLETE_SEARCH_DESCRIPTION 361
#define IDS_EMPTY_KEYWORD_VALUE 26028
#define IDS_LINK_FROM_CLIPBOARD 26029
#define IDS_TEXT_FROM_CLIPBOARD 26030
#define IDS_IMAGE_FROM_CLIPBOARD 26031
#define IDS_SECURE_CONNECTION_EV 26032
#define IDS_SECURE_VERBOSE_STATE 26033
#define IDS_NOT_SECURE_VERBOSE_STATE 26034
#define IDS_DANGEROUS_VERBOSE_STATE 26035
#define IDS_OFFLINE_VERBOSE_STATE 26036
#define IDS_OMNIBOX_TAB_SUGGEST_HINT 26038
#define IDS_OMNIBOX_FILE 26039
#define IDS_OMNIBOX_READER_MODE 26040
#define IDS_DRIVE_SUGGESTION_DOCUMENT 26041
#define IDS_DRIVE_SUGGESTION_FORM 26042
#define IDS_DRIVE_SUGGESTION_SPREADSHEET 26043
#define IDS_DRIVE_SUGGESTION_PRESENTATION 26044
#define IDS_DRIVE_SUGGESTION_GENERAL 26045
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE 26046
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_DATE 26047
#define IDS_DRIVE_SUGGESTION_DESCRIPTION_TEMPLATE_WITHOUT_OWNER 26048
#define IDS_ACCURACY_CHECK_VERBOSE_STATE 26049
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_HINT 26050
#define IDS_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUGGESTION_CONTENTS 26051
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH_SUFFIX 26052
#define IDS_ACC_OMNIBOX_ACTION_HISTORY_CLUSTERS_SEARCH 26053
#define IDS_ACC_AUTOCOMPLETE_HISTORY 26054
#define IDS_ACC_AUTOCOMPLETE_SEARCH_HISTORY 26055
#define IDS_ACC_AUTOCOMPLETE_SEARCH 26056
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH 26057
#define IDS_ACC_AUTOCOMPLETE_SUGGESTED_SEARCH_ENTITY 26058
#define IDS_ACC_AUTOCOMPLETE_QUICK_ANSWER 26059
#define IDS_ACC_AUTOCOMPLETE_BOOKMARK 26060
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_IMAGE 26061
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_TEXT 26062
#define IDS_ACC_AUTOCOMPLETE_CLIPBOARD_URL 26063
#define IDS_ACC_SEARCH_ICON 26064
#define IDS_ACC_AUTOCOMPLETE_N_OF_M 26065
#define IDS_ACC_TAB_SWITCH_SUFFIX 26066
#define IDS_ACC_TAB_SWITCH_BUTTON_FOCUSED_PREFIX 26067
#define IDS_ACC_TAB_SWITCH_BUTTON 26068
#define IDS_ACC_MULTIPLE_ACTIONS_SUFFIX 26069
#define IDS_ACC_KEYWORD_SUFFIX 26070
#define IDS_ACC_KEYWORD_MODE 26071
#define IDS_ACC_REMOVE_SUGGESTION_SUFFIX 26072
#define IDS_ACC_REMOVE_SUGGESTION_FOCUSED_PREFIX 26073
#define IDS_ACC_REMOVE_SUGGESTION_BUTTON 26074
#define IDS_TOOLTIP_HEADER_SHOW_SUGGESTIONS_BUTTON 26075
#define IDS_TOOLTIP_HEADER_HIDE_SUGGESTIONS_BUTTON 26076
#define IDS_ACC_HEADER_SHOW_SUGGESTIONS_BUTTON 26077
#define IDS_ACC_HEADER_HIDE_SUGGESTIONS_BUTTON 26078
#define IDS_ACC_HEADER_SECTION_SHOWN 26079
#define IDS_ACC_HEADER_SECTION_HIDDEN 26080
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_NAME 26081
#define IDS_SEARCH_ENGINES_STARTER_PACK_BOOKMARKS_KEYWORD 26082
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_NAME 26083
#define IDS_SEARCH_ENGINES_STARTER_PACK_HISTORY_KEYWORD 26084
#define IDS_SEARCH_ENGINES_STARTER_PACK_SETTINGS_NAME 26085
#define IDS_SEARCH_ENGINES_STARTER_PACK_SETTINGS_KEYWORD 26086
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_NAME 26087
#define IDS_SEARCH_ENGINES_STARTER_PACK_TABS_KEYWORD 26088
#define IDS_PAGE_INFO_SECURE_SUMMARY 26089
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY 26090
#define IDS_PAGE_INFO_MIXED_CONTENT_SUMMARY_SHORT 26091
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY 26092
#define IDS_PAGE_INFO_NOT_SECURE_SUMMARY_SHORT 26093
#define IDS_PAGE_INFO_MALWARE_SUMMARY 26094
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_SUMMARY 26095
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_SUMMARY 26096
#define IDS_PAGE_INFO_EXTENSION_PAGE 26097
#define IDS_PAGE_INFO_VIEW_SOURCE_PAGE 26098
#define IDS_PAGE_INFO_DEVTOOLS_PAGE 26099
#define IDS_PAGE_INFO_READER_MODE_PAGE_SECURE 26100
#define IDS_PAGE_INFO_READER_MODE_PAGE 26101
#define IDS_PAGE_INFO_SAFETY_TIP_BAD_REPUTATION_TITLE 26102
#define IDS_PAGE_INFO_SAFETY_TIP_BAD_REPUTATION_LEAVE_BUTTON 26103
#define IDS_PAGE_INFO_SAFETY_TIP_MORE_INFO_LINK 26104
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_LEAVE_BUTTON 26105
#define IDS_PAGE_INFO_SAFETY_TIP_LOOKALIKE_TITLE 26106
#define IDS_PAGE_INFO_SAFETY_TIP_DESCRIPTION 26107
#define IDS_PAGE_INFO_ACCURACY_TIP_TITLE 26108
#define IDS_PAGE_INFO_ACCURACY_TIP_LEARN_MORE_BUTTON 26109
#define IDS_PAGE_INFO_ACCURACY_TIP_IGNORE_BUTTON 26110
#define IDS_PAGE_INFO_ACCURACY_TIP_OPT_OUT_BUTTON 26111
#define IDS_PAGE_INFO_ACCURACY_TIP_BODY_LINE_1 26112
#define IDS_PAGE_INFO_ACCURACY_TIP_BODY_LINE_2 26113
#define IDS_PAGE_INFO_ACCURACY_TIP_BODY_LINE_3 26114
#define IDS_PAGE_INFO_FILE_PAGE 26115
#define IDS_PAGE_INFO_SECURE_DETAILS 26116
#define IDS_PAGE_INFO_SECURE_DETAILS_V2 26117
#define IDS_PAGE_INFO_ADMIN_PROVIDED_CERT_DETAILS 26118
#define IDS_PAGE_INFO_MIXED_CONTENT_DETAILS 26119
#define IDS_PAGE_INFO_LEGACY_TLS_DETAILS 26120
#define IDS_PAGE_INFO_NOT_SECURE_DETAILS 26121
#define IDS_PAGE_INFO_MALWARE_DETAILS 26122
#define IDS_PAGE_INFO_SOCIAL_ENGINEERING_DETAILS 26123
#define IDS_PAGE_INFO_UNWANTED_SOFTWARE_DETAILS 26124
#define IDS_PAGE_INFO_SECURITY_TAB_INSECURE_IDENTITY 26125
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SUMMARY 26126
#define IDS_PAGE_INFO_CHANGE_PASSWORD_SAVED_PASSWORD_SUMMARY 26127
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SAVED 26128
#define IDS_PAGE_INFO_CHECK_PASSWORDS_BUTTON 26129
#define IDS_PAGE_INFO_INVALID_CERTIFICATE_DESCRIPTION 26130
#define IDS_PAGE_INFO_RESET_INVALID_CERTIFICATE_DECISIONS_BUTTON 26131
#define IDS_PAGE_INFO_HELP_CENTER_LINK 26132
#define IDS_PAGE_INFO_SECURITY_TAB_DEPRECATED_SIGNATURE_ALGORITHM 26133
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_CONNECTION_TEXT 26134
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_ERROR 26135
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_CONTENT_WARNING 26136
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_INSECURE_FORM_WARNING 26137
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTED_SENTENCE_LINK 26138
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS 26139
#define IDS_PAGE_INFO_SECURITY_TAB_ENCRYPTION_DETAILS_AEAD 26140
#define IDS_PAGE_INFO_SECURITY_TAB_NON_UNIQUE_NAME 26141
#define IDS_PAGE_INFO_SECURITY_TAB_NOT_ENCRYPTED_CONNECTION_TEXT 26142
#define IDS_PAGE_INFO_SECURITY_TAB_SSL_VERSION 26143
#define IDS_PAGE_INFO_SECURITY_TAB_UNKNOWN_PARTY 26144
#define IDS_PAGE_INFO_SECURITY_TAB_WEAK_ENCRYPTION_CONNECTION_TEXT 26145
#define IDS_PAGE_INFO_CERT_INFO_BUTTON 26146
#define IDS_PAGE_INFO_ADDRESS 26147
#define IDS_PAGE_INFO_PARTIAL_ADDRESS 26148
#define IDS_PAGE_INFO_SECURITY_TAB_SECURE_IDENTITY_EV_VERIFIED 26149
#define IDS_PAGE_INFO_CERTIFICATE 26150
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK 26151
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK 26152
#define IDS_PAGE_INFO_CERTIFICATE_BUTTON_TEXT 26153
#define IDS_PAGE_INFO_CERTIFICATE_VALID_PARENTHESIZED 26154
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_PARENTHESIZED 26155
#define IDS_PAGE_INFO_CERTIFICATE_IS_VALID 26156
#define IDS_PAGE_INFO_CERTIFICATE_IS_NOT_VALID 26157
#define IDS_PAGE_INFO_CERTIFICATE_VALID_LINK_TOOLTIP 26158
#define IDS_PAGE_INFO_CERTIFICATE_INVALID_LINK_TOOLTIP 26159
#define IDS_PAGE_INFO_COOKIES 26161
#define IDS_PAGE_INFO_COOKIES_BUTTON_TEXT 26162
#define IDS_PAGE_INFO_NUM_COOKIES_PARENTHESIZED 26163
#define IDS_PAGE_INFO_NUM_COOKIES 26164
#define IDS_PAGE_INFO_COOKIES_TOOLTIP 26165
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_USER 26166
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_ONCE_BY_USER 26167
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_USER 26168
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_USER 26169
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_USER 26170
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_USER 26171
#define IDS_PAGE_INFO_BUTTON_TEXT_ALLOWED_BY_DEFAULT 26172
#define IDS_PAGE_INFO_BUTTON_TEXT_BLOCKED_BY_DEFAULT 26173
#define IDS_PAGE_INFO_BUTTON_TEXT_ASK_BY_DEFAULT 26174
#define IDS_PAGE_INFO_BUTTON_TEXT_AUTOMATIC_BY_DEFAULT 26175
#define IDS_PAGE_INFO_BUTTON_TEXT_MUTED_BY_DEFAULT 26176
#define IDS_PAGE_INFO_BUTTON_TEXT_DETECT_IMPORTANT_CONTENT_BY_DEFAULT 26177
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ALLOW 26178
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_BLOCK 26179
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_ASK 26180
#define IDS_PAGE_INFO_MENU_ITEM_DEFAULT_DETECT_IMPORTANT_CONTENT 26181
#define IDS_PAGE_INFO_MENU_ITEM_ALLOW 26182
#define IDS_PAGE_INFO_MENU_ITEM_BLOCK 26183
#define IDS_PAGE_INFO_MENU_ITEM_ASK 26184
#define IDS_PAGE_INFO_MENU_ITEM_DETECT_IMPORTANT_CONTENT 26185
#define IDS_PAGE_INFO_MENU_ITEM_ADS_BLOCK 26186
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED 26187
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_ONCE_ONE_TAB 26188
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_ONCE_MULTIPLE_TAB 26189
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED 26190
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_IN_INCOGNITO 26191
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_INSECURE 26192
#define IDS_PAGE_INFO_STATE_TEXT_MUTED 26193
#define IDS_PAGE_INFO_STATE_TEXT_ALLOWED_BY_DEFAULT 26194
#define IDS_PAGE_INFO_STATE_TEXT_NOT_ALLOWED_BY_DEFAULT 26195
#define IDS_PAGE_INFO_SELECTOR_TOOLTIP 26196
#define IDS_PAGE_INFO_STATE_TEXT_AR_ASK 26197
#define IDS_PAGE_INFO_STATE_TEXT_AUTOMATIC_DOWNLOADS_ASK 26198
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_DEVICES_ASK 26199
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_ASK 26200
#define IDS_PAGE_INFO_STATE_TEXT_CAMERA_PAN_TILT_ZOOM_ASK 26201
#define IDS_PAGE_INFO_STATE_TEXT_CLIPBOARD_ASK 26202
#define IDS_PAGE_INFO_STATE_TEXT_FILE_SYSTEM_WRITE_ASK 26203
#define IDS_PAGE_INFO_STATE_TEXT_HID_DEVICES_ASK 26204
#define IDS_PAGE_INFO_STATE_TEXT_LOCATION_ASK 26205
#define IDS_PAGE_INFO_STATE_TEXT_MIC_ASK 26206
#define IDS_PAGE_INFO_STATE_TEXT_MIDI_ASK 26207
#define IDS_PAGE_INFO_STATE_TEXT_NOTIFICATIONS_ASK 26208
#define IDS_PAGE_INFO_STATE_TEXT_USB_ASK 26209
#define IDS_PAGE_INFO_STATE_TEXT_VR_ASK 26210
#define IDS_PAGE_INFO_STATE_TEXT_FONT_ACCESS_ASK 26211
#define IDS_PAGE_INFO_STATE_TEXT_SERIAL_ASK 26212
#define IDS_PAGE_INFO_STATE_TEXT_IDLE_DETECTION_ASK 26213
#define IDS_PAGE_INFO_STATE_TEXT_WINDOW_PLACEMENT_ASK 26214
#define IDS_PAGE_INFO_STATE_TEXT_BLUETOOTH_SCANNING_ASK 26215
#define IDS_PAGE_INFO_USB_DEVICE_SECONDARY_LABEL 26216
#define IDS_PAGE_INFO_USB_DEVICE_ALLOWED_BY_POLICY_LABEL 26217
#define IDS_PAGE_INFO_DELETE_USB_DEVICE 26218
#define IDS_PAGE_INFO_SERIAL_PORT_SECONDARY_LABEL 26219
#define IDS_PAGE_INFO_SERIAL_PORT_ALLOWED_BY_POLICY_LABEL 26220
#define IDS_PAGE_INFO_DELETE_SERIAL_PORT 26221
#define IDS_PAGE_INFO_BLUETOOTH_DEVICE_SECONDARY_LABEL 26222
#define IDS_PAGE_INFO_DELETE_BLUETOOTH_DEVICE 26223
#define IDS_PAGE_INFO_HID_DEVICE_SECONDARY_LABEL 26224
#define IDS_PAGE_INFO_HID_DEVICE_ALLOWED_BY_POLICY_LABEL 26225
#define IDS_PAGE_INFO_DELETE_HID_DEVICE 26226
#define IDS_PAGE_INFO_SITE_SETTINGS_LINK 26227
#define IDS_PAGE_INFO_SITE_SETTINGS_TOOLTIP 26228
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_POLICY 26229
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_POLICY 26230
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_POLICY 26231
#define IDS_PAGE_INFO_PERMISSION_ALLOWED_BY_EXTENSION 26232
#define IDS_PAGE_INFO_PERMISSION_BLOCKED_BY_EXTENSION 26233
#define IDS_PAGE_INFO_PERMISSION_ASK_BY_EXTENSION 26234
#define IDS_PAGE_INFO_PERMISSION_AUTOMATICALLY_BLOCKED 26235
#define IDS_PAGE_INFO_PERMISSION_ADS_SUBTITLE 26236
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_POLICY 26237
#define IDS_PAGE_INFO_PERMISSION_MANAGED_BY_EXTENSION 26238
#define IDS_PAGE_INFO_INFOBAR_TEXT 26239
#define IDS_PAGE_INFO_INFOBAR_BUTTON 26240
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS 26241
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SYNC 26242
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_SIGNED_IN_NON_SYNC 26243
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE 26244
#define IDS_PAGE_INFO_CHANGE_PASSWORD_DETAILS_ENTERPRISE_WITH_ORG_NAME 26245
#define IDS_PAGE_INFO_CHANGE_PASSWORD_BUTTON 26246
#define IDS_PAGE_INFO_PROTECT_ACCOUNT_BUTTON 26247
#define IDS_PAGE_INFO_IGNORE_PASSWORD_WARNING_BUTTON 26248
#define IDS_PAGE_INFO_ALLOWLIST_PASSWORD_REUSE_BUTTON 26249
#define IDS_PAGE_INFO_BILLING_SUMMARY 26250
#define IDS_PAGE_INFO_BILLING_DETAILS 26251
#define IDS_PAGE_INFO_VR_PRESENTING_TEXT 26252
#define IDS_PAGE_INFO_VR_TURN_OFF_BUTTON_TEXT 26253
#define IDS_CERT_INFO_SUBJECT_GROUP 26254
#define IDS_CERT_INFO_ISSUER_GROUP 26255
#define IDS_CERT_INFO_COMMON_NAME_LABEL 26256
#define IDS_CERT_INFO_ORGANIZATION_LABEL 26257
#define IDS_CERT_INFO_ORGANIZATIONAL_UNIT_LABEL 26258
#define IDS_CERT_INFO_SERIAL_NUMBER_LABEL 26259
#define IDS_CERT_INFO_VALIDITY_GROUP 26260
#define IDS_CERT_INFO_ISSUED_ON_LABEL 26261
#define IDS_CERT_INFO_EXPIRES_ON_LABEL 26262
#define IDS_CERT_INFO_FINGERPRINTS_GROUP 26263
#define IDS_CERT_INFO_SHA256_FINGERPRINT_LABEL 26264
#define IDS_CERT_INFO_SHA1_FINGERPRINT_LABEL 26265
#define IDS_CERT_DETAILS_EXTENSIONS 26266
#define IDS_CERT_X509_SUBJECT_ALT_NAME 26267
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_BUTTON 26268
#define IDS_PAGE_INFO_SECURITY_SUBPAGE_HEADER 26269
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_BUTTON_TOOLTIP 26270
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON 26271
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_MANAGE_BUTTON_TOOLTIP 26272
#define IDS_PAGE_INFO_PERMISSIONS_SUBPAGE_REMEMBER_THIS_SETTING 26273
#define IDS_PAGE_INFO_RESET_PERMISSIONS 26274
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_HEADER 26275
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TITLE 26276
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_TOOLTIP 26277
#define IDS_PAGE_INFO_ABOUT_THIS_PAGE_TOOLTIP 26278
#define IDS_PAGE_INFO_ABOUT_THIS_SITE_SUBPAGE_FROM_LABEL 26279
#define IDS_PAGE_INFO_HISTORY 26280
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_TODAY 26281
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_YESTERDAY 26282
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DAYS 26283
#define IDS_PAGE_INFO_HISTORY_LAST_VISIT_DATE 26284
#define IDS_PAGE_INFO_AD_PERSONALIZATION_HEADER 26285
#define IDS_PAGE_INFO_AD_PERSONALIZATION_TOOLTIP 26286
#define IDS_PAGE_INFO_AD_PERSONALIZATION_TOPICS_AND_INTEREST_GROUP_DESCRIPTION 26287
#define IDS_PAGE_INFO_AD_PERSONALIZATION_TOPICS_DESCRIPTION 26288
#define IDS_PAGE_INFO_AD_PERSONALIZATION_INTEREST_GROUP_DESCRIPTION 26289
#define IDS_PAGE_INFO_AD_PERSONALIZATION_SUBPAGE_MANAGE_BUTTON 26290
#define IDS_PAINT_PREVIEW_COMPOSITOR_SERVICE_DISPLAY_NAME 26291
#define IDS_LEAK_CHECK_CREDENTIALS 26292
#define IDS_CREDENTIAL_LEAK_CHANGE_AUTOMATICALLY 26293
#define IDS_CREDENTIAL_LEAK_TITLE_CHANGE 26294
#define IDS_CREDENTIAL_LEAK_TITLE_CHANGE_AUTOMATICALLY 26295
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK 26296
#define IDS_CREDENTIAL_LEAK_TITLE_CHECK_GPM 26297
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE 26298
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE 26299
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_AUTOMATICALLY_MESSAGE 26300
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE 26301
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_AUTOMATICALLY_MESSAGE_GPM 26302
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 26303
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_BRANDED 26304
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_BRANDED 26305
#define IDS_CREDENTIAL_LEAK_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 26306
#define IDS_CREDENTIAL_LEAK_CHANGE_PASSWORD_MESSAGE_GPM_NON_BRANDED 26307
#define IDS_CREDENTIAL_LEAK_CHANGE_AND_CHECK_PASSWORDS_MESSAGE_GPM_NON_BRANDED 26308
#define IDS_PASSWORD_MANAGER_LEAK_HELP_MESSAGE 26310
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE 26311
#define IDS_PASSWORD_MANAGER_EMPTY_LOGIN 26312
#define IDS_PASSWORD_MANAGER_OPT_INTO_ACCOUNT_STORE 26313
#define IDS_PASSWORD_MANAGER_RE_SIGNIN_ACCOUNT_STORE 26314
#define IDS_PASSWORD_MANAGER_NO_ACCOUNT_STORE_MATCHES 26315
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS 26316
#define IDS_PASSWORD_MANAGER_GENERATE_PASSWORD 26317
#define IDS_PASSWORD_MANAGER_EXCEPTIONS_TAB_TITLE 26318
#define IDS_PASSWORD_MANAGER_SHOW_PASSWORDS_TAB_TITLE 26319
#define IDS_PASSWORD_MANAGER_SMART_LOCK 26320
#define IDS_PASSWORD_MANAGER_DEFAULT_EXPORT_FILENAME 26321
#define IDS_PASSWORD_MANAGER_PASSWORD_FOR_ACCOUNT 26322
#define IDS_PAYMENTS_TITLE 26323
#define IDS_PAYMENTS_ERROR_MESSAGE_DIALOG_TITLE 26324
#define IDS_PAYMENTS_METHOD_OF_PAYMENT_LABEL 26325
#define IDS_PAYMENTS_CONTACT_DETAILS_LABEL 26326
#define IDS_PAYMENTS_ADD_CONTACT_DETAILS_LABEL 26327
#define IDS_PAYMENTS_EDIT_CONTACT_DETAILS_LABEL 26328
#define IDS_PAYMENTS_ADD_CARD_LABEL 26329
#define IDS_PAYMENTS_ADD_BILLING_ADDRESS 26330
#define IDS_PAYMENTS_ADD_NAME_ON_CARD 26331
#define IDS_PAYMENTS_ADD_VALID_CARD_NUMBER 26332
#define IDS_PAYMENTS_ADD_MORE_INFORMATION 26333
#define IDS_PAYMENTS_EDIT_CARD 26334
#define IDS_PAYMENTS_ADD_PHONE_NUMBER 26335
#define IDS_PAYMENTS_ADD_RECIPIENT 26336
#define IDS_PAYMENTS_ADD_VALID_ADDRESS 26337
#define IDS_PAYMENTS_ADD_EMAIL 26338
#define IDS_PAYMENTS_ADD_NAME 26339
#define IDS_PAYMENTS_ORDER_SUMMARY_LABEL 26340
#define IDS_PAYMENT_REQUEST_PAYMENT_METHOD_SECTION_NAME 26341
#define IDS_PAYMENT_REQUEST_CONTACT_INFO_SECTION_NAME 26342
#define IDS_PAYMENTS_SHIPPING_SUMMARY_LABEL 26343
#define IDS_PAYMENTS_SHIPPING_ADDRESS_LABEL 26344
#define IDS_PAYMENTS_SHIPPING_OPTION_LABEL 26345
#define IDS_PAYMENTS_DELIVERY_SUMMARY_LABEL 26346
#define IDS_PAYMENTS_DELIVERY_ADDRESS_LABEL 26347
#define IDS_PAYMENTS_DELIVERY_OPTION_LABEL 26348
#define IDS_PAYMENTS_PICKUP_SUMMARY_LABEL 26349
#define IDS_PAYMENTS_PICKUP_ADDRESS_LABEL 26350
#define IDS_PAYMENTS_PICKUP_OPTION_LABEL 26351
#define IDS_PAYMENTS_EDIT_BUTTON 26352
#define IDS_PAYMENTS_PAY_BUTTON 26353
#define IDS_PAYMENTS_CONTINUE_BUTTON 26354
#define IDS_PAYMENTS_ADD_CONTACT 26355
#define IDS_PAYMENTS_ADD_CARD 26356
#define IDS_PAYMENTS_ADD_ADDRESS 26357
#define IDS_PAYMENTS_EDIT_ADDRESS 26358
#define IDS_PAYMENTS_CANCEL_PAYMENT 26359
#define IDS_PAYMENTS_NAME_FIELD_IN_CONTACT_DETAILS 26360
#define IDS_PAYMENTS_PHONE_FIELD_IN_CONTACT_DETAILS 26361
#define IDS_PAYMENTS_EMAIL_FIELD_IN_CONTACT_DETAILS 26362
#define IDS_PAYMENTS_SAVE_CARD_TO_DEVICE_CHECKBOX 26363
#define IDS_PAYMENTS_ACCEPTED_CARDS_LABEL 26364
#define IDS_PAYMENTS_ACCEPTED_CREDIT_CARDS_LABEL 26370
#define IDS_PAYMENTS_CREDIT_CARD_EXPIRATION_DATE_ABBR 26365
#define IDS_PAYMENTS_LOADING_MESSAGE 26366
#define IDS_PAYMENTS_PROCESSING_MESSAGE 26367
#define IDS_PAYMENTS_CHECKING_OPTION 26368
#define IDS_PAYMENTS_UPDATED_LABEL 26369
#define IDS_PAYMENTS_ERROR_MESSAGE 26371
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS 26372
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_IN 26373
#define IDS_PAYMENTS_CARD_AND_ADDRESS_SETTINGS_SIGNED_OUT 26374
#define IDS_SETTINGS_CAN_MAKE_PAYMENT_TOGGLE_LABEL 26375
#define IDS_PAYMENTS_REQUIRED_FIELD_MESSAGE 26394
#define IDS_PAYMENTS_VALIDATION_INVALID_NAME 26395
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRATION_YEAR 26396
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRATION_MONTH 26397
#define IDS_PAYMENTS_VALIDATION_INVALID_CREDIT_CARD_EXPIRED 26398
#define IDS_PAYMENTS_VALIDATION_UNSUPPORTED_CREDIT_CARD_TYPE 26399
#define IDS_PAYMENTS_PHONE_INVALID_VALIDATION_MESSAGE 26400
#define IDS_PAYMENTS_EMAIL_INVALID_VALIDATION_MESSAGE 26401
#define IDS_PAYMENTS_CARD_NUMBER_INVALID_VALIDATION_MESSAGE 26402
#define IDS_PAYMENTS_CARD_EXPIRATION_INVALID_VALIDATION_MESSAGE 26403
#define IDS_PAYMENTS_INVALID_ADDRESS 26404
#define IDS_PAYMENTS_BILLING_ADDRESS_REQUIRED 26405
#define IDS_PAYMENTS_NAME_ON_CARD_REQUIRED 26406
#define IDS_PAYMENTS_CARD_BILLING_ADDRESS_REQUIRED 26407
#define IDS_PAYMENTS_MORE_INFORMATION_REQUIRED 26408
#define IDS_PAYMENTS_PHONE_NUMBER_REQUIRED 26409
#define IDS_PAYMENTS_RECIPIENT_REQUIRED 26410
#define IDS_PAYMENTS_EMAIL_REQUIRED 26411
#define IDS_PAYMENTS_NAME_REQUIRED 26412
#define IDS_PREF_EDIT_DIALOG_FIELD_REQUIRED_VALIDATION_MESSAGE 26413
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SECTION_TOTAL_FORMAT 26414
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_SHEET_TOTAL_FORMAT 26415
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MORE_ITEMS 26416
#define IDS_PAYMENT_REQUEST_ORDER_SUMMARY_MULTIPLE_CURRENCY_INDICATOR 26417
#define IDS_PAYMENTS_SELECT_SHIPPING_ADDRESS_FOR_SHIPPING_METHODS 26418
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_ADDRESS 26419
#define IDS_PAYMENTS_UNSUPPORTED_SHIPPING_OPTION 26420
#define IDS_PAYMENTS_SELECT_DELIVERY_ADDRESS_FOR_DELIVERY_METHODS 26421
#define IDS_PAYMENTS_UNSUPPORTED_DELIVERY_ADDRESS 26422
#define IDS_PAYMENTS_UNSUPPORTED_DELIVERY_OPTION 26423
#define IDS_PAYMENTS_SELECT_PICKUP_ADDRESS_FOR_PICKUP_METHODS 26424
#define IDS_PAYMENTS_UNSUPPORTED_PICKUP_ADDRESS 26425
#define IDS_PAYMENTS_UNSUPPORTED_PICKUP_OPTION 26426
#define IDS_PAYMENTS_ANDROID_APP_ERROR 26427
#define IDS_UTILITY_PROCESS_PAYMENT_MANIFEST_PARSER_NAME 26428
#define IDS_PAYMENT_REQUEST_PAYMENT_METHODS_PREVIEW 26430
#define IDS_PAYMENT_REQUEST_SHIPPING_ADDRESSES_PREVIEW 26431
#define IDS_PAYMENT_REQUEST_SHIPPING_OPTIONS_PREVIEW 26432
#define IDS_PAYMENT_REQUEST_CONTACTS_PREVIEW 26433
#define IDS_PAYMENTS_BACK 26434
#define IDS_PAYMENTS_EDIT 26435
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_FORMAT 26436
#define IDS_PAYMENTS_ROW_ACCESSIBLE_NAME_SELECTED_FORMAT 26437
#define IDS_PAYMENTS_PROFILE_LABELS_ACCESSIBLE_FORMAT 26438
#define IDS_PAYMENTS_ACCESSIBLE_LABEL_WITH_ERROR 26439
#define IDS_PAYMENTS_ORDER_SUMMARY_ACCESSIBLE_LABEL 26440
#define IDS_PAYMENT_HANDLER_SHEET_DESCRIPTION 26441
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_HALF 26442
#define IDS_PAYMENT_HANDLER_SHEET_OPENED_FULL 26443
#define IDS_PAYMENT_HANDLER_SHEET_CLOSED 26444
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_PURCHASE 26445
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LABEL 26446
#define IDS_SECURE_PAYMENT_CONFIRMATION_STORE_LABEL 26447
#define IDS_SECURE_PAYMENT_CONFIRMATION_TOTAL_LABEL 26448
#define IDS_SECURE_PAYMENT_CONFIRMATION_VERIFY_BUTTON_LABEL 26449
#define IDS_SECURE_PAYMENT_CONFIRMATION_OPT_OUT_LINK_LABEL 26450
#define IDS_NO_MATCHING_CREDENTIAL_DESCRIPTION 26451
#define IDS_PDF_DOWNLOAD_ORIGINAL 26458
#define IDS_PDF_DOWNLOAD_EDITED 26459
#define IDS_PDF_PRESENT 26460
#define IDS_PDF_NEED_PASSWORD 26461
#define IDS_PDF_PASSWORD_DIALOG_TITLE 26462
#define IDS_PDF_PASSWORD_SUBMIT 26463
#define IDS_PDF_PASSWORD_INVALID 26464
#define IDS_PDF_PAGE_LOADING 26465
#define IDS_PDF_ERROR_DIALOG_TITLE 26466
#define IDS_PDF_PAGE_LOAD_FAILED 26467
#define IDS_PDF_PAGE_RELOAD_BUTTON 26468
#define IDS_PDF_BOOKMARKS 26469
#define IDS_PDF_BOOKMARK_EXPAND_ICON_ARIA_LABEL 26470
#define IDS_PDF_PROPERTIES_DIALOG_TITLE 26471
#define IDS_PDF_PROPERTIES_FILE_NAME 26472
#define IDS_PDF_PROPERTIES_FILE_SIZE 26473
#define IDS_PDF_PROPERTIES_TITLE 26474
#define IDS_PDF_PROPERTIES_AUTHOR 26475
#define IDS_PDF_PROPERTIES_SUBJECT 26476
#define IDS_PDF_PROPERTIES_KEYWORDS 26477
#define IDS_PDF_PROPERTIES_CREATED 26478
#define IDS_PDF_PROPERTIES_MODIFIED 26479
#define IDS_PDF_PROPERTIES_APPLICATION 26480
#define IDS_PDF_PROPERTIES_PDF_PRODUCER 26481
#define IDS_PDF_PROPERTIES_PDF_VERSION 26482
#define IDS_PDF_PROPERTIES_PAGE_COUNT 26483
#define IDS_PDF_PROPERTIES_PAGE_SIZE 26484
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_INCH 26485
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VALUE_MM 26486
#define IDS_PDF_PROPERTIES_PAGE_SIZE_PORTRAIT 26487
#define IDS_PDF_PROPERTIES_PAGE_SIZE_LANDSCAPE 26488
#define IDS_PDF_PROPERTIES_PAGE_SIZE_SQUARE 26489
#define IDS_PDF_PROPERTIES_PAGE_SIZE_VARIABLE 26490
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW 26491
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_NO 26492
#define IDS_PDF_PROPERTIES_FAST_WEB_VIEW_YES 26493
#define IDS_PDF_TOOLTIP_ROTATE_CCW 26494
#define IDS_PDF_TOOLTIP_DOWNLOAD 26495
#define IDS_PDF_TOOLTIP_PRINT 26496
#define IDS_PDF_TOOLTIP_FIT_PAGE 26497
#define IDS_PDF_TOOLTIP_FIT_WIDTH 26498
#define IDS_PDF_TWO_UP_VIEW_ENABLE 26499
#define IDS_PDF_ANNOTATIONS_SHOW_TOGGLE 26500
#define IDS_PDF_ZOOM_TEXT_INPUT_ARIA_LABEL 26501
#define IDS_PDF_TOOLTIP_ZOOM_IN 26502
#define IDS_PDF_TOOLTIP_ZOOM_OUT 26503
#define IDS_PDF_TOOLTIP_THUMBNAILS 26504
#define IDS_PDF_TOOLTIP_DOCUMENT_OUTLINE 26505
#define IDS_PDF_LABEL_PAGE_NUMBER 26506
#define IDS_PDF_PAGE_INDEX 26507
#define IDS_PDF_DOCUMENT_PAGE_COUNT 26508
#define IDS_PDF_THUMBNAIL_PAGE_ARIA_LABEL 26509
#define IDS_AX_ROLE_DESCRIPTION_PDF_HIGHLIGHT 26561
#define IDS_AX_ROLE_DESCRIPTION_PDF_POPUP_NOTE 26562
#define IDS_GEOLOCATION_INFOBAR_TEXT 26563
#define IDS_GEOLOCATION_INFOBAR_PERMISSION_FRAGMENT 26589
#define IDS_NOTIFICATION_PERMISSIONS_FRAGMENT 26590
#define IDS_MIDI_SYSEX_PERMISSION_FRAGMENT 26591
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_FRAGMENT 26592
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_FRAGMENT 26593
#define IDS_MEDIA_CAPTURE_CAMERA_PAN_TILT_ZOOM_PERMISSION_FRAGMENT 26594
#define IDS_ACCESSIBILITY_EVENTS_PERMISSION_FRAGMENT 26595
#define IDS_CLIPBOARD_PERMISSION_FRAGMENT 26596
#define IDS_VR_PERMISSION_FRAGMENT 26597
#define IDS_AR_PERMISSION_FRAGMENT 26598
#define IDS_STORAGE_ACCESS_PERMISSION_FRAGMENT 26599
#define IDS_STORAGE_ACCESS_PERMISSION_EXPLANATION 26600
#define IDS_WINDOW_PLACEMENT_PERMISSION_FRAGMENT 26601
#define IDS_FONT_ACCESS_PERMISSION_FRAGMENT 26602
#define IDS_IDLE_DETECTION_PERMISSION_FRAGMENT 26603
#define IDS_MULTI_DOWNLOAD_PERMISSION_FRAGMENT 26604
#define IDS_SECURITY_KEY_ATTESTATION_PERMISSION_FRAGMENT 26605
#define IDS_U2F_API_PERMISSION_FRAGMENT 26606
#define IDS_U2F_API_PERMISSION_EXPLANATION 26607
#define IDS_PERMISSION_ALLOW 26608
#define IDS_PERMISSION_DENY 26609
#define IDS_PERMISSION_ALLOW_ONCE 26610
#define IDS_PERMISSION_ALLOW_ALWAYS 26611
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ONE_TIME 26612
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PROMPT_ORIGIN 26613
#define IDS_BLUETOOTH_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 26614
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PAIR_BUTTON_TEXT 26615
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL 26616
#define IDS_BLUETOOTH_DEVICE_CHOOSER_SCANNING_LABEL_TOOLTIP 26617
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_WITH_ID 26618
#define IDS_BLUETOOTH_SCANNING_PROMPT_ORIGIN 26619
#define IDS_BLUETOOTH_SCANNING_DEVICE_UNKNOWN 26620
#define IDS_BLUETOOTH_SCANNING_PROMPT_NO_DEVICES_FOUND_PROMPT 26621
#define IDS_BLUETOOTH_SCANNING_PROMPT_ALLOW_BUTTON_TEXT 26622
#define IDS_BLUETOOTH_SCANNING_PROMPT_BLOCK_BUTTON_TEXT 26623
#define IDS_DEVICE_CHOOSER_CANCEL_BUTTON_TEXT 26624
#define IDS_DEVICE_CHOOSER_NO_DEVICES_FOUND_PROMPT 26625
#define IDS_USB_DEVICE_CHOOSER_PROMPT_ORIGIN 26626
#define IDS_USB_DEVICE_CHOOSER_CONNECT_BUTTON_TEXT 26627
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL 26628
#define IDS_USB_DEVICE_CHOOSER_LOADING_LABEL_TOOLTIP 26629
#define IDS_GEOLOCATION_PERMISSION_CHIP 26630
#define IDS_NOTIFICATION_PERMISSIONS_CHIP 26631
#define IDS_MIDI_SYSEX_PERMISSION_CHIP 26632
#define IDS_MEDIA_CAPTURE_AUDIO_ONLY_PERMISSION_CHIP 26633
#define IDS_MEDIA_CAPTURE_VIDEO_ONLY_PERMISSION_CHIP 26634
#define IDS_MEDIA_CAPTURE_VIDEO_AND_AUDIO_PERMISSION_CHIP 26635
#define IDS_CLIPBOARD_PERMISSION_CHIP 26636
#define IDS_VR_PERMISSION_CHIP 26637
#define IDS_AR_PERMISSION_CHIP 26638
#define IDS_IDLE_DETECTION_PERMISSION_CHIP 26639
#define IDS_GEOLOCATION_PERMISSION_BLOCKED_CHIP 26640
#define IDS_NOTIFICATION_PERMISSIONS_BLOCKED_CHIP 26641
#define IDS_REQUEST_QUOTA_INFOBAR_TEXT 26642
#define IDS_REQUEST_LARGE_QUOTA_INFOBAR_TEXT 26643
#define IDS_REQUEST_QUOTA_PERMISSION_FRAGMENT 26644
#define IDS_POLICY_DM_STATUS_SUCCESS 26645
#define IDS_POLICY_DM_STATUS_REQUEST_INVALID 26646
#define IDS_POLICY_DM_STATUS_REQUEST_FAILED 26647
#define IDS_POLICY_DM_STATUS_TEMPORARY_UNAVAILABLE 26648
#define IDS_POLICY_DM_STATUS_HTTP_STATUS_ERROR 26649
#define IDS_POLICY_DM_STATUS_RESPONSE_DECODING_ERROR 26650
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_NOT_SUPPORTED 26651
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NOT_FOUND 26652
#define IDS_POLICY_DM_STATUS_SERVICE_MANAGEMENT_TOKEN_INVALID 26653
#define IDS_POLICY_DM_STATUS_SERVICE_ACTIVATION_PENDING 26654
#define IDS_POLICY_DM_STATUS_SERVICE_INVALID_SERIAL_NUMBER 26655
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_ID_CONFLICT 26656
#define IDS_POLICY_DM_STATUS_SERVICE_MISSING_LICENSES 26657
#define IDS_POLICY_DM_STATUS_SERVICE_DEPROVISIONED 26658
#define IDS_POLICY_DM_STATUS_SERVICE_POLICY_NOT_FOUND 26659
#define IDS_POLICY_DM_STATUS_UNKNOWN_ERROR 26660
#define IDS_POLICY_DM_STATUS_SERVICE_DOMAIN_MISMATCH 26661
#define IDS_POLICY_DM_STATUS_CANNOT_SIGN_REQUEST 26662
#define IDS_POLICY_DM_STATUS_REQUEST_TOO_LARGE 26663
#define IDS_POLICY_DM_STATUS_SERVICE_TOO_MANY_REQUESTS 26664
#define IDS_POLICY_DM_STATUS_SERVICE_DEVICE_NEEDS_RESET 26665
#define IDS_POLICY_DM_STATUS_CONSUMER_ACCOUNT_WITH_PACKAGED_LICENSE 26666
#define IDS_POLICY_DM_STATUS_ENTERPRISE_ACCOUNT_IS_NOT_ELIGIBLE_TO_ENROLL 26667
#define IDS_POLICY_VALIDATION_OK 26668
#define IDS_POLICY_VALIDATION_BAD_INITIAL_SIGNATURE 26669
#define IDS_POLICY_VALIDATION_BAD_SIGNATURE 26670
#define IDS_POLICY_VALIDATION_ERROR_CODE_PRESENT 26671
#define IDS_POLICY_VALIDATION_PAYLOAD_PARSE_ERROR 26672
#define IDS_POLICY_VALIDATION_WRONG_POLICY_TYPE 26673
#define IDS_POLICY_VALIDATION_WRONG_SETTINGS_ENTITY_ID 26674
#define IDS_POLICY_VALIDATION_BAD_TIMESTAMP 26675
#define IDS_POLICY_VALIDATION_BAD_DM_TOKEN 26676
#define IDS_POLICY_VALIDATION_BAD_DEVICE_ID 26677
#define IDS_POLICY_VALIDATION_BAD_USER 26678
#define IDS_POLICY_VALIDATION_POLICY_PARSE_ERROR 26679
#define IDS_POLICY_VALIDATION_BAD_KEY_VERIFICATION_SIGNATURE 26680
#define IDS_POLICY_VALIDATION_VALUE_WARNING 26681
#define IDS_POLICY_VALIDATION_VALUE_ERROR 26682
#define IDS_POLICY_VALIDATION_UNKNOWN_ERROR 26683
#define IDS_POLICY_STORE_STATUS_OK 26684
#define IDS_POLICY_STORE_STATUS_LOAD_ERROR 26685
#define IDS_POLICY_STORE_STATUS_STORE_ERROR 26686
#define IDS_POLICY_STORE_STATUS_PARSE_ERROR 26687
#define IDS_POLICY_STORE_STATUS_SERIALIZE_ERROR 26688
#define IDS_POLICY_STORE_STATUS_VALIDATION_ERROR 26689
#define IDS_POLICY_STORE_STATUS_BAD_STATE 26690
#define IDS_POLICY_STORE_STATUS_UNKNOWN_ERROR 26691
#define IDS_POLICY_ASSOCIATION_STATE_ACTIVE 26692
#define IDS_POLICY_ASSOCIATION_STATE_UNMANAGED 26693
#define IDS_POLICY_ASSOCIATION_STATE_DEPROVISIONED 26694
#define IDS_POLICY_TYPE_ERROR 26695
#define IDS_POLICY_OUT_OF_RANGE_ERROR 26696
#define IDS_POLICY_VALUE_FORMAT_ERROR 26697
#define IDS_POLICY_CLOUD_SOURCE_ONLY_ERROR 26698
#define IDS_POLICY_CLOUD_USER_ONLY_ERROR 26699
#define IDS_POLICY_CLOUD_MANAGEMENT_ENROLLMENT_ONLY_ERROR 26700
#define IDS_POLICY_DEFAULT_SEARCH_DISABLED 26701
#define IDS_POLICY_NOT_SPECIFIED_ERROR 26702
#define IDS_POLICY_EXTENSION_SETTINGS_ORIGIN_LIMIT_WARNING 26703
#define IDS_POLICY_URL_ALLOW_BLOCK_LIST_MAX_FILTERS_LIMIT_WARNING 26704
#define IDS_POLICY_SUBKEY_ERROR 26705
#define IDS_POLICY_LIST_ENTRY_ERROR 26706
#define IDS_POLICY_SCHEMA_VALIDATION_ERROR 26707
#define IDS_POLICY_SCHEMA_VALIDATION_ERROR_WITHOUT_PATH 26708
#define IDS_POLICY_INVALID_JSON_ERROR 26709
#define IDS_POLICY_INVALID_SEARCH_URL_ERROR 26710
#define IDS_POLICY_INVALID_SECURE_DNS_MODE_ERROR 26711
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_ERROR 26712
#define IDS_POLICY_SECURE_DNS_TEMPLATES_IRRELEVANT_MODE_ERROR 26713
#define IDS_POLICY_SECURE_DNS_TEMPLATES_INVALID_MODE_ERROR 26714
#define IDS_POLICY_SECURE_DNS_TEMPLATES_UNSET_MODE_ERROR 26715
#define IDS_POLICY_SECURE_DNS_TEMPLATES_NOT_SPECIFIED_ERROR 26716
#define IDS_POLICY_INVALID_PROXY_MODE_ERROR 26717
#define IDS_POLICY_INVALID_UPDATE_URL_ERROR 26718
#define IDS_POLICY_OFF_CWS_URL_ERROR 26720
#define IDS_POLICY_HOMEPAGE_LOCATION_ERROR 26721
#define IDS_POLICY_PROXY_MODE_DISABLED_ERROR 26722
#define IDS_POLICY_PROXY_MODE_AUTO_DETECT_ERROR 26723
#define IDS_POLICY_PROXY_MODE_PAC_URL_ERROR 26724
#define IDS_POLICY_PROXY_MODE_FIXED_SERVERS_ERROR 26725
#define IDS_POLICY_PROXY_MODE_SYSTEM_ERROR 26726
#define IDS_POLICY_PROXY_BOTH_SPECIFIED_ERROR 26727
#define IDS_POLICY_PROXY_NEITHER_SPECIFIED_ERROR 26728
#define IDS_POLICY_OVERRIDDEN 26729
#define IDS_POLICY_VALUE_DEPRECATED 26730
#define IDS_POLICY_DEPENDENCY_ERROR 26731
#define IDS_POLICY_USER_IS_NOT_AFFILIATED_ERROR 26732
#define IDS_POLICY_LEVEL_ERROR 26737
#define IDS_POLICY_OK 26738
#define IDS_POLICY_UNSET 26739
#define IDS_POLICY_UNKNOWN 26740
#define IDS_POLICY_PROTO_PARSING_ERROR 26741
#define IDS_POLICY_HEX_COLOR_ERROR 26742
#define IDS_POLICY_TITLE 26743
#define IDS_POLICY_FILTER_PLACEHOLDER 26744
#define IDS_POLICY_RELOAD_POLICIES 26745
#define IDS_POLICY_LOADING_POLICIES 26746
#define IDS_POLICY_LOAD_POLICIES_DONE 26747
#define IDS_EXPORT_POLICIES_JSON 26748
#define IDS_POLICY_STATUS 26749
#define IDS_POLICY_STATUS_DEVICE 26750
#define IDS_POLICY_STATUS_USER 26751
#define IDS_POLICY_STATUS_MACHINE 26752
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DOMAIN 26754
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_TOKEN 26755
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_DEVICE_ID 26756
#define IDS_POLICY_LABEL_MACHINE_ENROLLMENT_MACHINE_NAME 26757
#define IDS_POLICY_LABEL_USERNAME 26758
#define IDS_POLICY_LABEL_GAIA_ID 26759
#define IDS_POLICY_LABEL_CLIENT_ID 26760
#define IDS_POLICY_LABEL_ASSET_ID 26761
#define IDS_POLICY_LABEL_LOCATION 26762
#define IDS_POLICY_LABEL_DIRECTORY_API_ID 26763
#define IDS_POLICY_LABEL_MANAGED_BY 26764
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_FETCH_ATTEMPT 26765
#define IDS_POLICY_LABEL_TIME_SINCE_LAST_REFRESH 26766
#define IDS_POLICY_LABEL_LAST_CLOUD_REPORT_SENT_TIMESTAMP 26767
#define IDS_POLICY_NOT_SPECIFIED 26768
#define IDS_POLICY_LABEL_PUSH_POLICIES 26769
#define IDS_POLICY_PUSH_POLICIES_ON 26770
#define IDS_POLICY_PUSH_POLICIES_OFF 26771
#define IDS_POLICY_NEVER_FETCHED 26772
#define IDS_POLICY_LABEL_REFRESH_INTERVAL 26773
#define IDS_POLICY_LABEL_CONFLICT 26774
#define IDS_POLICY_LABEL_SUPERSEDING 26775
#define IDS_POLICY_LABEL_CONFLICT_VALUE 26776
#define IDS_POLICY_LABEL_SUPERSEDED_VALUE 26777
#define IDS_POLICY_LABEL_ERROR 26778
#define IDS_POLICY_LABEL_DEPRECATED 26779
#define IDS_POLICY_LABEL_FUTURE 26780
#define IDS_POLICY_LABEL_IGNORED 26781
#define IDS_POLICY_LABEL_VALUE 26782
#define IDS_POLICY_LABEL_VERSION 26783
#define IDS_POLICY_LABEL_STATUS 26784
#define IDS_POLICY_LABEL_INFO 26785
#define IDS_POLICY_LABEL_PRECEDENCE 26786
#define IDS_POLICY_SHOW_UNSET 26787
#define IDS_POLICY_NO_POLICIES_SET 26788
#define IDS_POLICY_HEADER_SCOPE 26789
#define IDS_POLICY_HEADER_LEVEL 26790
#define IDS_POLICY_HEADER_NAME 26791
#define IDS_POLICY_HEADER_VALUE 26792
#define IDS_POLICY_HEADER_STATUS 26793
#define IDS_POLICY_HEADER_SOURCE 26794
#define IDS_POLICY_HEADER_WARNING 26795
#define IDS_POLICY_SHOW_MORE 26796
#define IDS_POLICY_SHOW_LESS 26797
#define IDS_POLICY_LEARN_MORE 26798
#define IDS_POLICY_SCOPE_USER 26799
#define IDS_POLICY_SCOPE_DEVICE 26800
#define IDS_POLICY_LEVEL_RECOMMENDED 26801
#define IDS_POLICY_LEVEL_MANDATORY 26802
#define IDS_POLICY_SOURCE_ENTERPRISE_DEFAULT 26803
#define IDS_POLICY_SOURCE_DEFAULT 26804
#define IDS_POLICY_SOURCE_COMMAND_LINE 26805
#define IDS_POLICY_SOURCE_CLOUD 26806
#define IDS_POLICY_SOURCE_MERGED 26807
#define IDS_POLICY_SOURCE_CLOUD_FROM_ASH 26808
#define IDS_POLICY_SOURCE_RESTRICTED_MANAGED_GUEST_SESSION_OVERRIDE 26809
#define IDS_POLICY_SOURCE_ACTIVE_DIRECTORY 26810
#define IDS_POLICY_SOURCE_PLATFORM 26811
#define IDS_POLICY_SOURCE_DEVICE_LOCAL_ACCOUNT_OVERRIDE 26812
#define IDS_POLICY_RISK_TAG_FULL_ADMIN_ACCESS 26813
#define IDS_POLICY_RISK_TAG_SYSTEM_SECURITY 26814
#define IDS_POLICY_RISK_TAG_WEBSITE_SHARING 26815
#define IDS_POLICY_RISK_TAG_ADMIN_SHARING 26816
#define IDS_POLICY_RISK_TAG_FILTERING 26817
#define IDS_POLICY_RISK_TAG_LOCAL_DATA_ACCESS 26818
#define IDS_POLICY_RISK_TAG_GOOGLE_SHARING 26819
#define IDS_POLICY_SHOW_EXPANDED_STATUS 26820
#define IDS_POLICY_HIDE_EXPANDED_STATUS 26821
#define IDS_POLICY_LIST_MERGING_WRONG_POLICY_TYPE_SPECIFIED 26822
#define IDS_POLICY_DICTIONARY_MERGING_WRONG_POLICY_TYPE_SPECIFIED 26823
#define IDS_POLICY_DICTIONARY_MERGING_POLICY_NOT_ALLOWED 26824
#define IDS_POLICY_CONFLICT_SAME_VALUE 26825
#define IDS_POLICY_CONFLICT_DIFF_VALUE 26826
#define IDS_POLICY_MIGRATED_OLD_POLICY 26827
#define IDS_POLICY_MIGRATED_NEW_POLICY 26828
#define IDS_POLICY_BLOCKED 26829
#define IDS_POLICY_INVALID 26830
#define IDS_POLICY_IGNORED_BY_GROUP_MERGING 26831
#define IDS_POLICY_INVALID_VALUE 26832
#define IDS_POLICY_IGNORED_MANDATORY_REPORTING_POLICY 26833
#define IDS_POLICY_IGNORED_CHROME_PROFILE 26834
#define IDS_POLICY_PRECEDENCE_PLATFORM_MACHINE 26835
#define IDS_POLICY_PRECEDENCE_PLATFORM_USER 26836
#define IDS_POLICY_PRECEDENCE_CLOUD_MACHINE 26837
#define IDS_POLICY_PRECEDENCE_CLOUD_USER 26838
#define IDS_POLICY_LABEL_IS_AFFILIATED 26841
#define IDS_POLICY_IS_AFFILIATED_YES 26842
#define IDS_POLICY_IS_AFFILIATED_NO 26843
#define IDS_POLICY_LABEL_IS_OFFHOURS_ACTIVE 26844
#define IDS_POLICY_OFFHOURS_ACTIVE 26845
#define IDS_POLICY_OFFHOURS_NOT_ACTIVE 26846
#define IDS_POLICY_SIGNIN_PROFILE 26847
#define IDS_POLICY_COPY_VALUE 26848
#define IDS_COPY_POLICIES_JSON 26849
#define IDS_CHROME_URLS_DISABLED_PAGE_HEADER 26850
#define IDS_CHROME_URLS_DISABLED_PAGE_TITLE 26851
#define IDS_CHROME_URLS_DISABLED_PAGE_MESSAGE 26852
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_PASTE 26853
#define IDS_POLICY_DLP_CLIPBOARD_BLOCKED_ON_COPY_VM 26854
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_TOAST_BUTTON 26855
#define IDS_POLICY_DLP_ANDROID_APPS 26856
#define IDS_POLICY_DLP_CLIPBOARD_BLOCK_DISMISS_BUTTON 26857
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_PASTE 26858
#define IDS_POLICY_DLP_CLIPBOARD_WARN_PROCEED_BUTTON 26859
#define IDS_POLICY_DLP_CLIPBOARD_WARN_DISMISS_BUTTON 26860
#define IDS_POLICY_DLP_CLIPBOARD_WARN_ON_COPY_VM 26861
#define IDS_POLICY_DLP_PRINTING_BLOCKED_TITLE 26862
#define IDS_POLICY_DLP_PRINTING_BLOCKED_MESSAGE 26863
#define IDS_POLICY_DLP_PRINTING_WARN_TITLE 26864
#define IDS_POLICY_DLP_PRINTING_WARN_MESSAGE 26865
#define IDS_POLICY_DLP_PRINTING_WARN_CONTINUE_BUTTON 26866
#define IDS_POLICY_DLP_PRINTING_WARN_CANCEL_BUTTON 26867
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_TITLE 26868
#define IDS_POLICY_DLP_SCREEN_SHARE_BLOCKED_MESSAGE 26869
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_TITLE 26870
#define IDS_POLICY_DLP_SCREEN_SHARE_PAUSED_MESSAGE 26871
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_TITLE 26872
#define IDS_POLICY_DLP_SCREEN_SHARE_RESUMED_MESSAGE 26873
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_TITLE 26874
#define IDS_POLICY_DLP_SCREEN_CAPTURE_DISABLED_MESSAGE 26875
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_TITLE 26876
#define IDS_POLICY_DLP_VIDEO_CAPTURE_STOPPED_MESSAGE 26877
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_TITLE 26878
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_MESSAGE 26879
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_CONTINUE_BUTTON 26880
#define IDS_POLICY_DLP_SCREEN_SHARE_WARN_CANCEL_BUTTON 26881
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_TITLE 26882
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_MESSAGE 26883
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_CONTINUE_BUTTON 26884
#define IDS_POLICY_DLP_SCREEN_CAPTURE_WARN_CANCEL_BUTTON 26885
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_TITLE 26886
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_MESSAGE 26887
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CONTINUE_BUTTON 26888
#define IDS_POLICY_DLP_VIDEO_CAPTURE_WARN_CANCEL_BUTTON 26889
#define IDS_POLICY_DLP_CLIPBOARD_BUBBLE_MESSAGE 26890
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_TITLE 26891
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_MESSAGE 26892
#define IDS_POLICY_REBOOT_BUTTON 26893
#define IDS_POLICY_DEVICE_SCHEDULED_REBOOT_DIALOG_MESSAGE 26894
#define IDS_REBOOT_SCHEDULED_TITLE_MINUTES 26895
#define IDS_REBOOT_SCHEDULED_TITLE_SECONDS 26896
#define IDS_POLICY_DEVICE_POST_REBOOT_TITLE 26897
#define PRINT_PREVIEW_MEDIA_ASME_F_28X40IN 26898
#define PRINT_PREVIEW_MEDIA_ISO_2A0_1189X1682MM 26899
#define PRINT_PREVIEW_MEDIA_ISO_A0_841X1189MM 26900
#define PRINT_PREVIEW_MEDIA_ISO_A10_26X37MM 26901
#define PRINT_PREVIEW_MEDIA_ISO_A1_594X841MM 26902
#define PRINT_PREVIEW_MEDIA_ISO_A2_420X594MM 26903
#define PRINT_PREVIEW_MEDIA_ISO_A3_297X420MM 26904
#define PRINT_PREVIEW_MEDIA_ISO_A4_210X297MM 26905
#define PRINT_PREVIEW_MEDIA_ISO_A4_EXTRA_235_5X322_3MM 26906
#define PRINT_PREVIEW_MEDIA_ISO_A4_TAB_225X297MM 26907
#define PRINT_PREVIEW_MEDIA_ISO_A5_148X210MM 26908
#define PRINT_PREVIEW_MEDIA_ISO_A5_EXTRA_174X235MM 26909
#define PRINT_PREVIEW_MEDIA_ISO_A6_105X148MM 26910
#define PRINT_PREVIEW_MEDIA_ISO_A7_74X105MM 26911
#define PRINT_PREVIEW_MEDIA_ISO_A8_52X74MM 26912
#define PRINT_PREVIEW_MEDIA_ISO_A9_37X52MM 26913
#define PRINT_PREVIEW_MEDIA_ISO_B0_1000X1414MM 26914
#define PRINT_PREVIEW_MEDIA_ISO_B10_31X44MM 26915
#define PRINT_PREVIEW_MEDIA_ISO_B1_707X1000MM 26916
#define PRINT_PREVIEW_MEDIA_ISO_B2_500X707MM 26917
#define PRINT_PREVIEW_MEDIA_ISO_B3_353X500MM 26918
#define PRINT_PREVIEW_MEDIA_ISO_B4_250X353MM 26919
#define PRINT_PREVIEW_MEDIA_ISO_B5_176X250MM 26920
#define PRINT_PREVIEW_MEDIA_ISO_B5_EXTRA_201X276MM 26921
#define PRINT_PREVIEW_MEDIA_ISO_B6C4_125X324MM 26922
#define PRINT_PREVIEW_MEDIA_ISO_B6_125X176MM 26923
#define PRINT_PREVIEW_MEDIA_ISO_B7_88X125MM 26924
#define PRINT_PREVIEW_MEDIA_ISO_B8_62X88MM 26925
#define PRINT_PREVIEW_MEDIA_ISO_B9_44X62MM 26926
#define PRINT_PREVIEW_MEDIA_ISO_C0_917X1297MM 26927
#define PRINT_PREVIEW_MEDIA_ISO_C10_28X40MM 26928
#define PRINT_PREVIEW_MEDIA_ISO_C1_648X917MM 26929
#define PRINT_PREVIEW_MEDIA_ISO_C2_458X648MM 26930
#define PRINT_PREVIEW_MEDIA_ISO_C3_324X458MM 26931
#define PRINT_PREVIEW_MEDIA_ISO_C4_229X324MM 26932
#define PRINT_PREVIEW_MEDIA_ISO_C5_162X229MM 26933
#define PRINT_PREVIEW_MEDIA_ISO_C6C5_114X229MM 26934
#define PRINT_PREVIEW_MEDIA_ISO_C6_114X162MM 26935
#define PRINT_PREVIEW_MEDIA_ISO_C7C6_81X162MM 26936
#define PRINT_PREVIEW_MEDIA_ISO_C7_81X114MM 26937
#define PRINT_PREVIEW_MEDIA_ISO_C8_57X81MM 26938
#define PRINT_PREVIEW_MEDIA_ISO_C9_40X57MM 26939
#define PRINT_PREVIEW_MEDIA_ISO_DL_110X220MM 26940
#define PRINT_PREVIEW_MEDIA_JIS_EXEC_216X330MM 26941
#define PRINT_PREVIEW_MEDIA_JPN_CHOU2_111_1X146MM 26942
#define PRINT_PREVIEW_MEDIA_JPN_CHOU3_120X235MM 26943
#define PRINT_PREVIEW_MEDIA_JPN_CHOU4_90X205MM 26944
#define PRINT_PREVIEW_MEDIA_JPN_HAGAKI_100X148MM 26945
#define PRINT_PREVIEW_MEDIA_JPN_KAHU_240X322_1MM 26946
#define PRINT_PREVIEW_MEDIA_JPN_KAKU2_240X332MM 26947
#define PRINT_PREVIEW_MEDIA_JPN_OUFUKU_148X200MM 26948
#define PRINT_PREVIEW_MEDIA_JPN_YOU4_105X235MM 26949
#define PRINT_PREVIEW_MEDIA_NA_10X11_10X11IN 26950
#define PRINT_PREVIEW_MEDIA_NA_10X13_10X13IN 26951
#define PRINT_PREVIEW_MEDIA_NA_10X14_10X14IN 26952
#define PRINT_PREVIEW_MEDIA_NA_10X15_10X15IN 26953
#define PRINT_PREVIEW_MEDIA_NA_11X12_11X12IN 26954
#define PRINT_PREVIEW_MEDIA_NA_11X15_11X15IN 26955
#define PRINT_PREVIEW_MEDIA_NA_12X19_12X19IN 26956
#define PRINT_PREVIEW_MEDIA_NA_5X7_5X7IN 26957
#define PRINT_PREVIEW_MEDIA_NA_6X9_6X9IN 26958
#define PRINT_PREVIEW_MEDIA_NA_7X9_7X9IN 26959
#define PRINT_PREVIEW_MEDIA_NA_9X11_9X11IN 26960
#define PRINT_PREVIEW_MEDIA_NA_A2_4_375X5_75IN 26961
#define PRINT_PREVIEW_MEDIA_NA_ARCH_A_9X12IN 26962
#define PRINT_PREVIEW_MEDIA_NA_ARCH_B_12X18IN 26963
#define PRINT_PREVIEW_MEDIA_NA_ARCH_C_18X24IN 26964
#define PRINT_PREVIEW_MEDIA_NA_ARCH_D_24X36IN 26965
#define PRINT_PREVIEW_MEDIA_NA_ARCH_E_36X48IN 26966
#define PRINT_PREVIEW_MEDIA_NA_B_PLUS_12X19_17IN 26967
#define PRINT_PREVIEW_MEDIA_NA_C5_6_5X9_5IN 26968
#define PRINT_PREVIEW_MEDIA_NA_C_17X22IN 26969
#define PRINT_PREVIEW_MEDIA_NA_D_22X34IN 26970
#define PRINT_PREVIEW_MEDIA_NA_EDP_11X14IN 26971
#define PRINT_PREVIEW_MEDIA_NA_EUR_EDP_12X14IN 26972
#define PRINT_PREVIEW_MEDIA_NA_E_34X44IN 26973
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_EUR_8_5X12IN 26974
#define PRINT_PREVIEW_MEDIA_NA_FANFOLD_US_11X14_875IN 26975
#define PRINT_PREVIEW_MEDIA_NA_FOOLSCAP_8_5X13IN 26976
#define PRINT_PREVIEW_MEDIA_NA_F_44X68IN 26977
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LEGAL_8X13IN 26978
#define PRINT_PREVIEW_MEDIA_NA_GOVT_LETTER_8X10IN 26979
#define PRINT_PREVIEW_MEDIA_NA_INDEX_3X5_3X5IN 26980
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_4X6IN 26981
#define PRINT_PREVIEW_MEDIA_NA_INDEX_4X6_EXT_6X8IN 26982
#define PRINT_PREVIEW_MEDIA_NA_INDEX_5X8_5X8IN 26983
#define PRINT_PREVIEW_MEDIA_NA_INVOICE_5_5X8_5IN 26984
#define PRINT_PREVIEW_MEDIA_NA_LEDGER_11X17IN 26985
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_8_5X14IN 26986
#define PRINT_PREVIEW_MEDIA_NA_LEGAL_EXTRA_9_5X15IN 26987
#define PRINT_PREVIEW_MEDIA_NA_LETTER_8_5X11IN 26988
#define PRINT_PREVIEW_MEDIA_NA_LETTER_EXTRA_9_5X12IN 26989
#define PRINT_PREVIEW_MEDIA_NA_LETTER_PLUS_8_5X12_69IN 26990
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_10_4_125X9_5IN 26991
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_11_4_5X10_375IN 26992
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_12_4_75X11IN 26993
#define PRINT_PREVIEW_MEDIA_NA_NUMBER_14_5X11_5IN 26994
#define PRINT_PREVIEW_MEDIA_NA_PERSONAL_3_625X6_5IN 26995
#define PRINT_PREVIEW_MEDIA_NA_SUPER_A_8_94X14IN 26996
#define PRINT_PREVIEW_MEDIA_NA_SUPER_B_13X19IN 26997
#define PRINT_PREVIEW_MEDIA_NA_WIDE_FORMAT_30X42IN 26998
#define PRINT_PREVIEW_MEDIA_OM_DAI_PA_KAI_275X395MM 26999
#define PRINT_PREVIEW_MEDIA_OM_FOLIO_SP_215X315MM 27000
#define PRINT_PREVIEW_MEDIA_OM_INVITE_220X220MM 27001
#define PRINT_PREVIEW_MEDIA_OM_ITALIAN_110X230MM 27002
#define PRINT_PREVIEW_MEDIA_OM_JUURO_KU_KAI_198X275MM 27003
#define PRINT_PREVIEW_MEDIA_OM_LARGE_PHOTO_200X300 27004
#define PRINT_PREVIEW_MEDIA_OM_PA_KAI_267X389MM 27005
#define PRINT_PREVIEW_MEDIA_OM_POSTFIX_114X229MM 27006
#define PRINT_PREVIEW_MEDIA_OM_SMALL_PHOTO_100X150MM 27007
#define PRINT_PREVIEW_MEDIA_PRC_10_324X458MM 27008
#define PRINT_PREVIEW_MEDIA_PRC_16K_146X215MM 27009
#define PRINT_PREVIEW_MEDIA_PRC_1_102X165MM 27010
#define PRINT_PREVIEW_MEDIA_PRC_2_102X176MM 27011
#define PRINT_PREVIEW_MEDIA_PRC_32K_97X151MM 27012
#define PRINT_PREVIEW_MEDIA_PRC_3_125X176MM 27013
#define PRINT_PREVIEW_MEDIA_PRC_4_110X208MM 27014
#define PRINT_PREVIEW_MEDIA_PRC_5_110X220MM 27015
#define PRINT_PREVIEW_MEDIA_PRC_6_120X320MM 27016
#define PRINT_PREVIEW_MEDIA_PRC_7_160X230MM 27017
#define PRINT_PREVIEW_MEDIA_PRC_8_120X309MM 27018
#define PRINT_PREVIEW_MEDIA_ROC_16K_7_75X10_75IN 27019
#define PRINT_PREVIEW_MEDIA_ROC_8K_10_75X15_5IN 27020
#define PRINT_PREVIEW_MEDIA_JIS_B0_1030X1456MM 27021
#define PRINT_PREVIEW_MEDIA_JIS_B1_728X1030MM 27022
#define PRINT_PREVIEW_MEDIA_JIS_B2_515X728MM 27023
#define PRINT_PREVIEW_MEDIA_JIS_B3_364X515MM 27024
#define PRINT_PREVIEW_MEDIA_JIS_B4_257X364MM 27025
#define PRINT_PREVIEW_MEDIA_JIS_B5_182X257MM 27026
#define PRINT_PREVIEW_MEDIA_JIS_B6_128X182MM 27027
#define PRINT_PREVIEW_MEDIA_JIS_B7_91X128MM 27028
#define PRINT_PREVIEW_MEDIA_JIS_B8_64X91MM 27029
#define PRINT_PREVIEW_MEDIA_JIS_B9_45X64MM 27030
#define PRINT_PREVIEW_MEDIA_JIS_B10_32X45MM 27031
#define IDS_PRINT_COMPOSITOR_SERVICE_DISPLAY_NAME 27033
#define IDS_PRIVACY_SANDBOX_FLOC_INVALID 27310
#define IDS_PRIVACY_SANDBOX_FLOC_DESCRIPTION 27311
#define IDS_PRIVACY_SANDBOX_FLOC_TIME_TO_NEXT_COMPUTE 27312
#define IDS_PRIVACY_SANDBOX_FLOC_TIME_TO_NEXT_COMPUTE_INVALID 27313
#define IDS_PRIVACY_SANDBOX_FLOC_RESET_EXPLANATION 27314
#define IDS_PRIVACY_SANDBOX_FLOC_STATUS_ACTIVE 27315
#define IDS_PRIVACY_SANDBOX_FLOC_STATUS_ELIGIBLE_NOT_ACTIVE 27316
#define IDS_PRIVACY_SANDBOX_FLOC_STATUS_NOT_ACTIVE 27317
#define IDS_PRIVACY_SANDBOX_TOPICS_INVALID_TOPIC 27318
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_1 27319
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_2 27320
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_3 27321
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_4 27322
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_5 27323
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_6 27324
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_7 27325
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_8 27326
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_9 27327
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_10 27328
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_11 27329
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_12 27330
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_13 27331
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_14 27332
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_15 27333
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_16 27334
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_17 27335
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_18 27336
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_19 27337
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_20 27338
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_21 27339
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_22 27340
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_23 27341
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_24 27342
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_25 27343
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_26 27344
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_27 27345
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_28 27346
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_29 27347
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_30 27348
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_31 27349
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_32 27350
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_33 27351
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_34 27352
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_35 27353
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_36 27354
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_37 27355
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_38 27356
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_39 27357
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_40 27358
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_41 27359
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_42 27360
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_43 27361
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_44 27362
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_45 27363
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_46 27364
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_47 27365
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_48 27366
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_49 27367
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_50 27368
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_51 27369
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_52 27370
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_53 27371
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_54 27372
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_55 27373
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_56 27374
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_57 27375
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_58 27376
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_59 27377
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_60 27378
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_61 27379
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_62 27380
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_63 27381
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_64 27382
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_65 27383
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_66 27384
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_67 27385
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_68 27386
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_69 27387
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_70 27388
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_71 27389
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_72 27390
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_73 27391
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_74 27392
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_75 27393
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_76 27394
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_77 27395
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_78 27396
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_79 27397
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_80 27398
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_81 27399
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_82 27400
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_83 27401
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_84 27402
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_85 27403
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_86 27404
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_87 27405
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_88 27406
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_89 27407
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_90 27408
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_91 27409
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_92 27410
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_93 27411
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_94 27412
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_95 27413
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_96 27414
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_97 27415
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_98 27416
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_99 27417
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_100 27418
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_101 27419
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_102 27420
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_103 27421
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_104 27422
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_105 27423
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_106 27424
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_107 27425
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_108 27426
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_109 27427
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_110 27428
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_111 27429
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_112 27430
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_113 27431
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_114 27432
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_115 27433
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_116 27434
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_117 27435
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_118 27436
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_119 27437
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_120 27438
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_121 27439
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_122 27440
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_123 27441
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_124 27442
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_125 27443
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_126 27444
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_127 27445
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_128 27446
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_129 27447
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_130 27448
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_131 27449
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_132 27450
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_133 27451
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_134 27452
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_135 27453
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_136 27454
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_137 27455
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_138 27456
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_139 27457
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_140 27458
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_141 27459
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_142 27460
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_143 27461
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_144 27462
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_145 27463
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_146 27464
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_147 27465
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_148 27466
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_149 27467
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_150 27468
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_151 27469
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_152 27470
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_153 27471
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_154 27472
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_155 27473
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_156 27474
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_157 27475
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_158 27476
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_159 27477
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_160 27478
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_161 27479
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_162 27480
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_163 27481
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_164 27482
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_165 27483
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_166 27484
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_167 27485
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_168 27486
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_169 27487
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_170 27488
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_171 27489
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_172 27490
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_173 27491
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_174 27492
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_175 27493
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_176 27494
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_177 27495
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_178 27496
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_179 27497
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_180 27498
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_181 27499
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_182 27500
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_183 27501
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_184 27502
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_185 27503
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_186 27504
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_187 27505
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_188 27506
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_189 27507
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_190 27508
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_191 27509
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_192 27510
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_193 27511
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_194 27512
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_195 27513
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_196 27514
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_197 27515
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_198 27516
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_199 27517
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_200 27518
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_201 27519
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_202 27520
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_203 27521
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_204 27522
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_205 27523
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_206 27524
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_207 27525
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_208 27526
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_209 27527
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_210 27528
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_211 27529
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_212 27530
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_213 27531
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_214 27532
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_215 27533
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_216 27534
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_217 27535
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_218 27536
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_219 27537
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_220 27538
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_221 27539
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_222 27540
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_223 27541
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_224 27542
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_225 27543
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_226 27544
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_227 27545
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_228 27546
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_229 27547
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_230 27548
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_231 27549
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_232 27550
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_233 27551
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_234 27552
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_235 27553
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_236 27554
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_237 27555
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_238 27556
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_239 27557
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_240 27558
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_241 27559
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_242 27560
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_243 27561
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_244 27562
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_245 27563
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_246 27564
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_247 27565
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_248 27566
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_249 27567
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_250 27568
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_251 27569
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_252 27570
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_253 27571
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_254 27572
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_255 27573
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_256 27574
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_257 27575
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_258 27576
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_259 27577
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_260 27578
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_261 27579
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_262 27580
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_263 27581
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_264 27582
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_265 27583
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_266 27584
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_267 27585
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_268 27586
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_269 27587
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_270 27588
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_271 27589
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_272 27590
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_273 27591
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_274 27592
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_275 27593
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_276 27594
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_277 27595
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_278 27596
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_279 27597
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_280 27598
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_281 27599
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_282 27600
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_283 27601
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_284 27602
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_285 27603
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_286 27604
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_287 27605
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_288 27606
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_289 27607
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_290 27608
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_291 27609
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_292 27610
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_293 27611
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_294 27612
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_295 27613
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_296 27614
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_297 27615
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_298 27616
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_299 27617
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_300 27618
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_301 27619
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_302 27620
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_303 27621
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_304 27622
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_305 27623
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_306 27624
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_307 27625
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_308 27626
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_309 27627
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_310 27628
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_311 27629
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_312 27630
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_313 27631
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_314 27632
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_315 27633
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_316 27634
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_317 27635
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_318 27636
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_319 27637
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_320 27638
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_321 27639
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_322 27640
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_323 27641
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_324 27642
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_325 27643
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_326 27644
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_327 27645
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_328 27646
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_329 27647
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_330 27648
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_331 27649
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_332 27650
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_333 27651
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_334 27652
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_335 27653
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_336 27654
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_337 27655
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_338 27656
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_339 27657
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_340 27658
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_341 27659
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_342 27660
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_343 27661
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_344 27662
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_345 27663
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_346 27664
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_347 27665
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_348 27666
#define IDS_PRIVACY_SANDBOX_TOPICS_TAXONOMY_V1_TOPIC_ID_349 27667
#define IDS_REGISTER_PROTOCOL_HANDLER_TOOLTIP 274
#define IDS_REGISTER_PROTOCOL_HANDLER_MAILTO_NAME 27668
#define IDS_REGISTER_PROTOCOL_HANDLER_WEBCAL_NAME 27669
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM 27670
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE 27671
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_FRAGMENT 27672
#define IDS_REGISTER_PROTOCOL_HANDLER_CONFIRM_REPLACE_FRAGMENT 27673
#define IDS_REGISTER_PROTOCOL_HANDLER_ACCEPT 27674
#define IDS_REGISTER_PROTOCOL_HANDLER_DENY 27675
#define IDS_REGISTER_PROTOCOL_HANDLER_IGNORE 27676
#define IDS_RESET_PASSWORD_TITLE 27677
#define IDS_RESET_PASSWORD_WARNING_HEADING 27678
#define IDS_RESET_PASSWORD_HEADING 27679
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH 27680
#define IDS_RESET_PASSWORD_WARNING_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 27681
#define IDS_RESET_PASSWORD_BUTTON 27682
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH 27683
#define IDS_RESET_PASSWORD_EXPLANATION_PARAGRAPH_WITH_ORG_NAME 27684
#define IDS_SSL_OPEN_DETAILS_BUTTON 27685
#define IDS_SSL_CLOSE_DETAILS_BUTTON 27686
#define IDS_CAPTIVE_PORTAL_AUTHORIZATION_DIALOG_NAME 27687
#define IDS_CAPTIVE_PORTAL_HEADING_WIRED 27688
#define IDS_CAPTIVE_PORTAL_HEADING_WIFI 27689
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIRED 27690
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI 27691
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_WIFI_SSID 27692
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIRED 27693
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI 27694
#define IDS_CAPTIVE_PORTAL_PRIMARY_PARAGRAPH_NO_LOGIN_URL_WIFI_SSID 27695
#define IDS_CAPTIVE_PORTAL_BUTTON_OPEN_LOGIN_PAGE 27696
#define IDS_MITM_SOFTWARE_HEADING 27697
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_ENTERPRISE 27698
#define IDS_MITM_SOFTWARE_PRIMARY_PARAGRAPH_NONENTERPRISE 27699
#define IDS_MITM_SOFTWARE_EXPLANATION_ENTERPRISE 27700
#define IDS_MITM_SOFTWARE_EXPLANATION_NONENTERPRISE 27701
#define IDS_MITM_SOFTWARE_EXPLANATION 27702
#define IDS_LOOKALIKE_URL_TITLE 27703
#define IDS_LOOKALIKE_URL_HEADING 27704
#define IDS_LOOKALIKE_URL_IGNORE 27705
#define IDS_LOOKALIKE_URL_CONTINUE 27706
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH 27707
#define IDS_LOOKALIKE_URL_HEADING_NO_SUGGESTED_URL 27708
#define IDS_LOOKALIKE_URL_PRIMARY_PARAGRAPH_NO_SUGGESTED_URL 27709
#define IDS_LOOKALIKE_URL_BACK_TO_SAFETY 27710
#define IDS_LOOKALIKE_URL_CLOSE_PAGE 27711
#define IDS_CLOCK_ERROR_TITLE 27712
#define IDS_CLOCK_ERROR_AHEAD_HEADING 27713
#define IDS_CLOCK_ERROR_BEHIND_HEADING 27714
#define IDS_CLOCK_ERROR_UPDATE_DATE_AND_TIME 27715
#define IDS_CLOCK_ERROR_PRIMARY_PARAGRAPH 27716
#define IDS_CLOCK_ERROR_EXPLANATION 27717
#define IDS_SSL_V2_TITLE 27718
#define IDS_SSL_V2_HEADING 27719
#define IDS_SSL_V2_PRIMARY_PARAGRAPH 27720
#define IDS_SSL_V2_RECURRENT_ERROR_PARAGRAPH 27721
#define IDS_SSL_OVERRIDABLE_SAFETY_BUTTON 27722
#define IDS_SSL_OVERRIDABLE_CLOSE_PAGE_BUTTON 27723
#define IDS_SSL_OVERRIDABLE_PROCEED_PARAGRAPH 27724
#define IDS_SSL_RELOAD 27725
#define IDS_SSL_NONOVERRIDABLE_PINNED 27726
#define IDS_SSL_NONOVERRIDABLE_HSTS 27727
#define IDS_SSL_NONOVERRIDABLE_REVOKED 27728
#define IDS_SSL_NONOVERRIDABLE_MORE 27729
#define IDS_SSL_NONOVERRIDABLE_INVALID 27730
#define IDS_SAFEBROWSING_V3_TITLE 27731
#define IDS_SAFEBROWSING_V3_OPEN_DETAILS_BUTTON 27732
#define IDS_SAFEBROWSING_V3_CLOSE_DETAILS_BUTTON 27733
#define IDS_SAFEBROWSING_OVERRIDABLE_SAFETY_BUTTON 27734
#define IDS_MALWARE_V3_HEADING 27735
#define IDS_MALWARE_V3_PRIMARY_PARAGRAPH 27736
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH 27737
#define IDS_MALWARE_V3_EXPLANATION_PARAGRAPH_SUBRESOURCE 27738
#define IDS_MALWARE_V3_PROCEED_PARAGRAPH 27739
#define IDS_SAFE_BROWSING_SCOUT_REPORTING_AGREE 27740
#define IDS_SAFE_BROWSING_ENHANCED_PROTECTION_MESSAGE 27741
#define IDS_HARMFUL_V3_HEADING 27742
#define IDS_HARMFUL_V3_PRIMARY_PARAGRAPH 27743
#define IDS_HARMFUL_V3_EXPLANATION_PARAGRAPH 27744
#define IDS_HARMFUL_V3_PROCEED_PARAGRAPH 27745
#define IDS_PHISHING_V4_HEADING 27746
#define IDS_PHISHING_V4_PRIMARY_PARAGRAPH 27747
#define IDS_PHISHING_V4_EXPLANATION_PARAGRAPH 27748
#define IDS_PHISHING_V4_PROCEED_AND_REPORT_PARAGRAPH 27749
#define IDS_MALWARE_WEBVIEW_HEADING 27750
#define IDS_MALWARE_WEBVIEW_EXPLANATION_PARAGRAPH 27751
#define IDS_PHISHING_WEBVIEW_HEADING 27752
#define IDS_PHISHING_WEBVIEW_EXPLANATION_PARAGRAPH 27753
#define IDS_HARMFUL_WEBVIEW_HEADING 27754
#define IDS_HARMFUL_WEBVIEW_EXPLANATION_PARAGRAPH 27755
#define IDS_BILLING_WEBVIEW_HEADING 27756
#define IDS_BILLING_WEBVIEW_EXPLANATION_PARAGRAPH 27757
#define IDS_CONNECTION_HELP_SHOW_MORE 27758
#define IDS_CONNECTION_HELP_SHOW_LESS 27759
#define IDS_CONNECTION_HELP_TITLE 27760
#define IDS_CONNECTION_HELP_HEADING 27761
#define IDS_CONNECTION_HELP_GENERAL_HELP 27762
#define IDS_CONNECTION_HELP_SPECIFIC_ERROR_HEADING 27763
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_TITLE 27764
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_TITLE 27765
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_TITLE 27766
#define IDS_CONNECTION_HELP_CONNECTION_NOT_PRIVATE_DETAILS 27767
#define IDS_CONNECTION_HELP_CONNECT_TO_NETWORK_DETAILS 27768
#define IDS_CONNECTION_HELP_INCORRECT_CLOCK_DETAILS 27769
#define IDS_BILLING_TITLE 27772
#define IDS_BILLING_HEADING 27773
#define IDS_BILLING_PRIMARY_PARAGRAPH 27774
#define IDS_BILLING_PRIMARY_BUTTON 27775
#define IDS_BILLING_PROCEED_BUTTON 27776
#define IDS_BLOCKED_INTERCEPTION_HEADING 27777
#define IDS_KNOWN_INTERCEPTION_TITLE 27778
#define IDS_KNOWN_INTERCEPTION_HEADER 27779
#define IDS_KNOWN_INTERCEPTION_BODY1 27780
#define IDS_KNOWN_INTERCEPTION_BODY2 27781
#define IDS_KNOWN_INTERCEPTION_INFOBAR_HEADING 27782
#define IDS_KNOWN_INTERCEPTION_INFOBAR_BUTTON_TEXT 27783
#define IDS_LEGACY_TLS_HEADING 27784
#define IDS_LEGACY_TLS_PRIMARY_PARAGRAPH 27785
#define IDS_LEGACY_TLS_EXPLANATION 27786
#define IDS_INSECURE_FORM_TITLE 27787
#define IDS_INSECURE_FORM_HEADING 27788
#define IDS_INSECURE_FORM_PRIMARY_PARAGRAPH 27789
#define IDS_INSECURE_FORM_BACK_BUTTON 27790
#define IDS_INSECURE_FORM_SUBMIT_BUTTON 27791
#define IDS_HTTPS_ONLY_MODE_TITLE 27792
#define IDS_HTTPS_ONLY_MODE_HEADING 27793
#define IDS_HTTPS_ONLY_MODE_PRIMARY_PARAGRAPH 27794
#define IDS_HTTPS_ONLY_MODE_BACK_BUTTON 27795
#define IDS_HTTPS_ONLY_MODE_SUBMIT_BUTTON 27796
#define IDS_SHARING_DEVICE_TYPE_COMPUTER 27797
#define IDS_SHARING_DEVICE_TYPE_DEVICE 27798
#define IDS_SHARING_DEVICE_TYPE_PHONE 27799
#define IDS_SHARING_DEVICE_TYPE_TABLET 27800
#define IDS_SITE_SETTINGS_TYPE_ADS 27801
#define IDS_SITE_SETTINGS_TYPE_ADS_MID_SENTENCE 27802
#define IDS_SITE_SETTINGS_TYPE_AR 27803
#define IDS_SITE_SETTINGS_TYPE_AR_MID_SENTENCE 27804
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS 27805
#define IDS_SITE_SETTINGS_TYPE_AUTOMATIC_DOWNLOADS_MID_SENTENCE 27806
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC 27807
#define IDS_SITE_SETTINGS_TYPE_BACKGROUND_SYNC_MID_SENTENCE 27808
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES 27809
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_DEVICES_MID_SENTENCE 27810
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING 27811
#define IDS_SITE_SETTINGS_TYPE_BLUETOOTH_SCANNING_MID_SENTENCE 27812
#define IDS_SITE_SETTINGS_TYPE_CAMERA 27813
#define IDS_SITE_SETTINGS_TYPE_CAMERA_MID_SENTENCE 27814
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM 27815
#define IDS_SITE_SETTINGS_TYPE_CAMERA_PAN_TILT_ZOOM_MID_SENTENCE 27816
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD 27817
#define IDS_SITE_SETTINGS_TYPE_CLIPBOARD_MID_SENTENCE 27818
#define IDS_SITE_SETTINGS_TYPE_COOKIES 27819
#define IDS_SITE_SETTINGS_TYPE_COOKIES_MID_SENTENCE 27820
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API 27821
#define IDS_SITE_SETTINGS_TYPE_FEDERATED_IDENTITY_API_MID_SENTENCE 27822
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION 27823
#define IDS_SITE_SETTINGS_TYPE_IDLE_DETECTION_MID_SENTENCE 27824
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT 27825
#define IDS_SITE_SETTINGS_TYPE_JAVASCRIPT_MID_SENTENCE 27826
#define IDS_SITE_SETTINGS_TYPE_LOCATION 27827
#define IDS_SITE_SETTINGS_TYPE_LOCATION_MID_SENTENCE 27828
#define IDS_SITE_SETTINGS_TYPE_MIC 27829
#define IDS_SITE_SETTINGS_TYPE_MIC_MID_SENTENCE 27830
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX 27831
#define IDS_SITE_SETTINGS_TYPE_MIDI_SYSEX_MID_SENTENCE 27832
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS 27833
#define IDS_SITE_SETTINGS_TYPE_MOTION_SENSORS_MID_SENTENCE 27834
#define IDS_SITE_SETTINGS_TYPE_NFC 27835
#define IDS_SITE_SETTINGS_TYPE_NFC_MID_SENTENCE 27836
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS 27837
#define IDS_SITE_SETTINGS_TYPE_NOTIFICATIONS_MID_SENTENCE 27838
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS 27839
#define IDS_SITE_SETTINGS_TYPE_POPUPS_REDIRECTS_MID_SENTENCE 27840
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID 27841
#define IDS_SITE_SETTINGS_TYPE_PROTECTED_MEDIA_ID_MID_SENTENCE 27842
#define IDS_SITE_SETTINGS_TYPE_SENSORS 27843
#define IDS_SITE_SETTINGS_TYPE_SENSORS_MID_SENTENCE 27844
#define IDS_SITE_SETTINGS_TYPE_SOUND 27845
#define IDS_SITE_SETTINGS_TYPE_SOUND_MID_SENTENCE 27846
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES 27847
#define IDS_SITE_SETTINGS_TYPE_USB_DEVICES_MID_SENTENCE 27848
#define IDS_SITE_SETTINGS_TYPE_VR 27849
#define IDS_SITE_SETTINGS_TYPE_VR_MID_SENTENCE 27850
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE 27851
#define IDS_SITE_SETTINGS_TYPE_FILE_SYSTEM_ACCESS_WRITE_MID_SENTENCE 27852
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS 27853
#define IDS_SITE_SETTINGS_TYPE_FONT_ACCESS_MID_SENTENCE 27854
#define IDS_SITE_SETTINGS_TYPE_HANDLERS 27855
#define IDS_SITE_SETTINGS_TYPE_HANDLERS_MID_SENTENCE 27856
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES 27857
#define IDS_SITE_SETTINGS_TYPE_HID_DEVICES_MID_SENTENCE 27858
#define IDS_SITE_SETTINGS_TYPE_IMAGES 27859
#define IDS_SITE_SETTINGS_TYPE_IMAGES_MID_SENTENCE 27860
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT 27861
#define IDS_SITE_SETTINGS_TYPE_INSECURE_CONTENT_MID_SENTENCE 27862
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER 27863
#define IDS_SITE_SETTINGS_TYPE_PAYMENT_HANDLER_MID_SENTENCE 27864
#define IDS_SITE_SETTINGS_TYPE_PDF_DOCUMENTS 27865
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS 27866
#define IDS_SITE_SETTINGS_TYPE_SERIAL_PORTS_MID_SENTENCE 27867
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS 27868
#define IDS_SITE_SETTINGS_TYPE_ZOOM_LEVELS_MID_SENTENCE 27869
#define IDS_SITE_SETTINGS_TYPE_WINDOW_PLACEMENT 27870
#define IDS_SITE_SETTINGS_TYPE_WINDOW_PLACEMENT_MID_SENTENCE 27871
#define IDS_SMS_INFOBAR_TITLE 27872
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED 27873
#define IDS_SMS_INFOBAR_STATUS_SMS_RECEIVED_FROM_EMBEDDED_FRAME 27874
#define IDS_SMS_INFOBAR_BUTTON_OK 27875
#define IDS_SODA_LANGUAGE_DISPLAY_NAME_ENGLISH 27876
#define IDS_SODA_LANGUAGE_DISPLAY_NAME_FRENCH 27877
#define IDS_SODA_LANGUAGE_DISPLAY_NAME_GERMAN 27878
#define IDS_SODA_LANGUAGE_DISPLAY_NAME_ITALIAN 27879
#define IDS_SODA_LANGUAGE_DISPLAY_NAME_JAPANESE 27880
#define IDS_SODA_LANGUAGE_DISPLAY_NAME_SPANISH 27881
#define IDS_CERT_ERROR_NO_SUBJECT_ALTERNATIVE_NAMES_DETAILS 27882
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DETAILS 27883
#define IDS_CERT_ERROR_COMMON_NAME_INVALID_DESCRIPTION 27884
#define IDS_CERT_ERROR_EXPIRED_DETAILS 27885
#define IDS_CERT_ERROR_EXPIRED_DESCRIPTION 27886
#define IDS_CERT_ERROR_NOT_YET_VALID_DETAILS 27887
#define IDS_CERT_ERROR_NOT_YET_VALID_DESCRIPTION 27888
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DETAILS 27889
#define IDS_CERT_ERROR_NOT_VALID_AT_THIS_TIME_DESCRIPTION 27890
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DESCRIPTION 27891
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DETAILS 27892
#define IDS_CERT_ERROR_CONTAINS_ERRORS_DESCRIPTION 27893
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DETAILS 27894
#define IDS_CERT_ERROR_UNABLE_TO_CHECK_REVOCATION_DESCRIPTION 27895
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DETAILS 27896
#define IDS_CERT_ERROR_NO_REVOCATION_MECHANISM_DESCRIPTION 27897
#define IDS_CERT_ERROR_REVOKED_CERT_DETAILS 27898
#define IDS_CERT_ERROR_REVOKED_CERT_DESCRIPTION 27899
#define IDS_CERT_ERROR_INVALID_CERT_DETAILS 27900
#define IDS_CERT_ERROR_INVALID_CERT_DESCRIPTION 27901
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DETAILS 27902
#define IDS_CERT_ERROR_WEAK_SIGNATURE_ALGORITHM_DESCRIPTION 27903
#define IDS_CERT_ERROR_WEAK_KEY_DETAILS 27904
#define IDS_CERT_ERROR_WEAK_KEY_DESCRIPTION 27905
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DETAILS 27906
#define IDS_CERT_ERROR_NAME_CONSTRAINT_VIOLATION_DESCRIPTION 27907
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DETAILS 27908
#define IDS_CERT_ERROR_VALIDITY_TOO_LONG_DESCRIPTION 27909
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DETAILS 27910
#define IDS_CERT_ERROR_UNKNOWN_ERROR_DESCRIPTION 27911
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DETAILS 27912
#define IDS_CERT_ERROR_SUMMARY_PINNING_FAILURE_DESCRIPTION 27913
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DETAILS 27914
#define IDS_CERT_ERROR_CERTIFICATE_TRANSPARENCY_REQUIRED_DESCRIPTION 27915
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DETAILS 27916
#define IDS_SSL_ERROR_OBSOLETE_VERSION_DESCRIPTION 27917
#define IDS_CERT_ERROR_AUTHORITY_INVALID_DETAILS 27918
#define IDS_ALWAYS_ALLOW_ADS 27919
#define IDS_BLOCKED_ADS_PROMPT_TITLE 27920
#define IDS_BLOCKED_ADS_PROMPT_EXPLANATION 27921
#define IDS_SYNC_BASIC_ENCRYPTION_DATA 27928
#define IDS_SYNC_DATATYPE_AUTOFILL 27929
#define IDS_SYNC_DATATYPE_BOOKMARKS 27930
#define IDS_SYNC_DATATYPE_PASSWORDS 27931
#define IDS_SYNC_DATATYPE_PREFERENCES 27932
#define IDS_SYNC_DATATYPE_TABS 27933
#define IDS_SYNC_DATATYPE_TYPED_URLS 27934
#define IDS_SYNC_DATATYPE_READING_LIST 27935
#define IDS_SYNC_EMPTY_PASSPHRASE_ERROR 27936
#define IDS_SYNC_ENCRYPTION_SECTION_TITLE 27937
#define IDS_SYNC_FULL_ENCRYPTION_DATA 27938
#define IDS_SYNC_LOGIN_SETTING_UP 27939
#define IDS_SYNC_PASSPHRASE_LABEL 27940
#define IDS_SYNC_PASSPHRASE_MISMATCH_ERROR 27941
#define IDS_SYNC_SERVICE_UNAVAILABLE 27942
#define IDS_SYNC_ENTER_PASSPHRASE_BODY_WITH_DATE 27943
#define IDS_SYNC_ENTER_PASSPHRASE_BODY 27944
#define IDS_TRANSLATE_INFOBAR_OPTIONS_MORE_LANGUAGE 27945
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NOT_SOURCE_LANGUAGE 27946
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NEVER_TRANSLATE_LANG 27947
#define IDS_TRANSLATE_INFOBAR_OPTIONS_NEVER_TRANSLATE_SITE 27948
#define IDS_TRANSLATE_INFOBAR_OPTIONS_ALWAYS 27949
#define IDS_TRANSLATE_INFOBAR_OPTIONS_REPORT_ERROR 27950
#define IDS_TRANSLATE_INFOBAR_OPTIONS_ABOUT 27951
#define IDS_TRANSLATE_INFOBAR_ACCEPT 27953
#define IDS_TRANSLATE_INFOBAR_DENY 27954
#define IDS_TRANSLATE_INFOBAR_NEVER_TRANSLATE 27955
#define IDS_TRANSLATE_INFOBAR_ALWAYS_TRANSLATE 27956
#define IDS_TRANSLATE_INFOBAR_AFTER_MESSAGE 27957
#define IDS_TRANSLATE_INFOBAR_AFTER_MESSAGE_AUTODETERMINED_SOURCE_LANGUAGE 27958
#define IDS_TRANSLATE_INFOBAR_REVERT 27959
#define IDS_TRANSLATE_INFOBAR_RETRY 27960
#define IDS_TRANSLATE_NOTIFICATION_ERROR 27980
#define IDS_TRANSLATE_NOTIFICATION_ALWAYS_TRANSLATE 27981
#define IDS_TRANSLATE_NOTIFICATION_LANGUAGE_NEVER 27982
#define IDS_TRANSLATE_NOTIFICATION_SITE_NEVER 27983
#define IDS_TRANSLATE_NOTIFICATION_UNDO 27984
#define IDS_TRANSLATE_DETECTED_LANGUAGE 27985
#define IDS_TAB_GROUP_COLOR_GREY 27986
#define IDS_TAB_GROUP_COLOR_BLUE 27987
#define IDS_TAB_GROUP_COLOR_RED 27988
#define IDS_TAB_GROUP_COLOR_YELLOW 27989
#define IDS_TAB_GROUP_COLOR_GREEN 27990
#define IDS_TAB_GROUP_COLOR_PINK 27991
#define IDS_TAB_GROUP_COLOR_PURPLE 27992
#define IDS_TAB_GROUP_COLOR_CYAN 27993
#define IDS_TAB_GROUP_COLOR_ORANGE 27994
#define IDS_BOOKMARK_BAR_UNDO 27995
#define IDS_BOOKMARK_BAR_REDO 27996
#define IDS_BOOKMARK_BAR_UNDO_ADD 27997
#define IDS_BOOKMARK_BAR_REDO_ADD 27998
#define IDS_BOOKMARK_BAR_UNDO_DELETE 27999
#define IDS_BOOKMARK_BAR_REDO_DELETE 28000
#define IDS_BOOKMARK_BAR_UNDO_EDIT 28001
#define IDS_BOOKMARK_BAR_REDO_EDIT 28002
#define IDS_BOOKMARK_BAR_UNDO_MOVE 28003
#define IDS_BOOKMARK_BAR_REDO_MOVE 28004
#define IDS_BOOKMARK_BAR_UNDO_REORDER 28005
#define IDS_BOOKMARK_BAR_REDO_REORDER 28006
#define IDS_CLOSE_TUTORIAL 28007
#define IDS_CLOSE_PROMO 28008
#define IDS_PROMO_DISMISS_BUTTON 28009
#define IDS_PROMO_SNOOZE_BUTTON 28010
#define IDS_PROMO_SHOW_TUTORIAL_BUTTON 28011
#define IDS_TUTORIAL_RESTART_TUTORIAL 28012
#define IDS_TUTORIAL_CLOSE_TUTORIAL 28013
#define IDS_VERSION_UI_TITLE 28014
#define IDS_VERSION_UI_OFFICIAL 28015
#define IDS_VERSION_UI_UNOFFICIAL 28016
#define IDS_VERSION_UI_32BIT 28017
#define IDS_VERSION_UI_64BIT 28018
#define IDS_VERSION_UI_64BIT_INTEL 28019
#define IDS_VERSION_UI_64BIT_TRANSLATED_INTEL 28020
#define IDS_VERSION_UI_64BIT_ARM 28021
#define IDS_VERSION_UI_REVISION 28022
#define IDS_VERSION_UI_OS 28023
#define IDS_VERSION_UI_USER_AGENT 28025
#define IDS_VERSION_UI_COMMAND_LINE 28026
#define IDS_VERSION_UI_COPY_LABEL 28030
#define IDS_VERSION_UI_EXECUTABLE_PATH 28031
#define IDS_VERSION_UI_PROFILE_PATH 28032
#define IDS_VERSION_UI_PATH_NOTFOUND 28033
#define IDS_VERSION_UI_VARIATIONS 28034
#define IDS_VERSION_UI_VARIATIONS_CMD 28035
#define IDS_HISTORY_CLUSTERS_ACTION_MENU_DESCRIPTION 28043
#define IDS_HISTORY_CLUSTERS_DISABLE_MENU_ITEM_LABEL 28044
#define IDS_HISTORY_CLUSTERS_ENABLE_MENU_ITEM_LABEL 28045
#define IDS_HISTORY_CLUSTERS_JOURNEYS_TAB_LABEL 28046
#define IDS_HISTORY_CLUSTERS_LIST_TAB_LABEL 28047
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_SEARCH_TERMS 28048
#define IDS_HISTORY_CLUSTERS_CLUSTER_LABEL_MULTIPLE_HOSTNAMES 28049
#define IDS_HISTORY_CLUSTERS_LOAD_MORE_BUTTON_LABEL 28050
#define IDS_HISTORY_CLUSTERS_OPEN_ALL_IN_TABGROUP 28051
#define IDS_HISTORY_CLUSTERS_OPEN_INCOGNITO 28052
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_TAB 28053
#define IDS_HISTORY_CLUSTERS_OPEN_IN_NEW_WINDOW 28054
#define IDS_HISTORY_CLUSTERS_RELATED_SEARCHES_HEADER 28055
#define IDS_HISTORY_CLUSTERS_REMOVE_ALL_ITEMS 28056
#define IDS_HISTORY_CLUSTERS_REMOVE_PAGE 28057
#define IDS_HISTORY_CLUSTERS_REMOVE_ITEM_TOAST 28058
#define IDS_HISTORY_CLUSTERS_SAVED_IN_TABGROUP_LABEL 28059
#define IDS_HISTORY_CLUSTERS_COPY_LINK 28060
#define IDS_HISTORY_CLUSTERS_SHOW_LESS_BUTTON_LABEL 28061
#define IDS_HISTORY_CLUSTERS_SHOW_MORE_BUTTON_LABEL 28062
#define IDS_HISTORY_CLUSTERS_SEARCH_YOUR_JOURNEYS 28063
#define IDS_HISTORY_CLUSTERS_N_MATCHES 28064
#define IDS_CANCEL 28079
#define IDS_CLOSE 28080
#define IDS_CLEAR 28081
#define IDS_DONE 28082
#define IDS_LEARN_MORE 28083
#define IDS_OK 28084
#define IDS_RELOAD 28085
#define IDS_ADD 28086
#define IDS_REMOVE 28087
#define IDS_SAVE 28088
#define IDS_MENU 28089
#define IDS_INSTALL 28090
#define IDS_UPDATE 28091
#define IDS_NO_THANKS 28094
#define IDS_NOT_NOW 28095
#define IDS_TURN_OFF 28096
#define IDS_PLUGIN_NOT_SUPPORTED 28097
#define IDS_PRINT 125
#define IDS_RECENTLY_CLOSED 281
#define IDS_CHOOSE 28098
#define IDS_ACCNAME_BACK 306
#define IDS_ACCNAME_FORWARD 308
#define IDS_ACCNAME_OK 28099
#define IDS_ACCNAME_CANCEL 28100
#define IDS_ACCNAME_DONE 28101
#define IDS_ACCNAME_SAVE 28102
#define IDS_ACCNAME_CLOSE 321
#define IDS_ACCNAME_OPEN 28103
#define IDS_ACCNAME_PREVIOUS 28104
#define IDS_ACCNAME_NEXT 28105
#define IDS_ACCNAME_LOCATION 312
#define IDS_ACCNAME_PARTICLE_DISC 28106
#define IDS_ACCNAME_TAB_LIST 28107
#define IDS_UTILITY_PROCESS_JSON_PARSER_NAME 28108
#define IDS_SESSION_CRASHED_VIEW_RESTORE_BUTTON 28109
#define IDS_SESSION_CRASHED_VIEW_STARTUP_PAGES_BUTTON 28110
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_PRIVACY 28111
#define IDS_OPTIONS_ADVANCED_SECTION_TITLE_SAFETY_CHECK 28112
#define IDS_PATCH_SERVICE_DISPLAY_NAME 28113
#define IDS_PASSWORD_MANAGER_CSV_PASSWORD_PARSER_SERVICE_DISPLAY_NAME 28114
#define IDS_UNZIP_SERVICE_DISPLAY_NAME 28115

// ---------------------------------------------------------------------------
// From extensions_strings.h:

#define IDS_EXTENSION_BAD_FILE_ENCODING 32010
#define IDS_EXTENSION_CANT_GET_ABSOLUTE_PATH 32011
#define IDS_EXTENSION_CONTAINS_PRIVATE_KEY 32012
#define IDS_EXTENSION_CRX_EXISTS 32013
#define IDS_EXTENSION_DIRECTORY_NO_EXISTS 32014
#define IDS_EXTENSION_ERROR_WHILE_SIGNING 32015
#define IDS_EXTENSION_FAILED_DURING_PACKAGING 32016
#define IDS_EXTENSION_LOAD_ABOUT_PAGE_FAILED 32017
#define IDS_EXTENSION_LOAD_BACKGROUND_SCRIPT_FAILED 32018
#define IDS_EXTENSION_LOAD_BACKGROUND_PAGE_FAILED 32019
#define IDS_EXTENSION_LOAD_CSS_FAILED 32020
#define IDS_EXTENSION_LOAD_JAVASCRIPT_FAILED 32021
#define IDS_EXTENSION_LOAD_OPTIONS_PAGE_FAILED 32022
#define IDS_EXTENSION_LOCALES_NO_DEFAULT_LOCALE_SPECIFIED 32023
#define IDS_EXTENSION_MANIFEST_UNREADABLE 32024
#define IDS_EXTENSION_MANIFEST_INVALID 32025
#define IDS_EXTENSION_PACKAGE_IMAGE_ERROR 32026
#define IDS_EXTENSION_PACKAGE_UNZIP_ERROR 32027
#define IDS_EXTENSION_PRIVATE_KEY_EXISTS 32028
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_READ 32029
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_EXPORT 32030
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_GENERATE 32031
#define IDS_EXTENSION_PRIVATE_KEY_FAILED_TO_OUTPUT 32032
#define IDS_EXTENSION_PRIVATE_KEY_INVALID 32033
#define IDS_EXTENSION_PRIVATE_KEY_NO_EXISTS 32034
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_PATH 32035
#define IDS_EXTENSION_PRIVATE_KEY_INVALID_FORMAT 32036
#define IDS_EXTENSION_PUBLIC_KEY_FAILED_TO_EXPORT 32037
#define IDS_EXTENSION_SHARING_VIOLATION 32038
#define IDS_EXTENSION_CANT_INSTALL_POLICY_BLOCKED 32039
#define IDS_EXTENSION_CANT_MODIFY_POLICY_REQUIRED 32040
#define IDS_EXTENSION_CANT_UNINSTALL_POLICY_REQUIRED 32041
#define IDS_EXTENSION_DISABLED_UPDATE_REQUIRED_BY_POLICY 32042
#define IDS_DEVICE_NAME_WITH_PRODUCT_SERIAL 32043
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR 32044
#define IDS_DEVICE_NAME_WITH_PRODUCT_UNKNOWN_VENDOR_SERIAL 32045
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR 32046
#define IDS_DEVICE_NAME_WITH_PRODUCT_VENDOR_SERIAL 32047
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR 32048
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_UNKNOWN_VENDOR_SERIAL 32049
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR 32050
#define IDS_DEVICE_NAME_WITH_UNKNOWN_PRODUCT_VENDOR_SERIAL 32051
#define IDS_DEVICE_PERMISSIONS_PROMPT_SINGLE_SELECTION 32052
#define IDS_DEVICE_PERMISSIONS_PROMPT_MULTIPLE_SELECTION 32053
#define IDS_CAMERA_FACING_USER 32054
#define IDS_CAMERA_FACING_ENVIRONMENT 32055
#define IDS_EXTENSION_USB_DEVICE_PRODUCT_NAME_AND_VENDOR 258
#define IDS_EXTENSION_TASK_MANAGER_APPVIEW_TAG_PREFIX 32056
#define IDS_EXTENSION_TASK_MANAGER_EXTENSIONOPTIONS_TAG_PREFIX 32057
#define IDS_EXTENSION_TASK_MANAGER_MIMEHANDLERVIEW_TAG_PREFIX 32058
#define IDS_EXTENSION_TASK_MANAGER_WEBVIEW_TAG_PREFIX 32059
#define IDS_EXTENSION_WARNINGS_NETWORK_DELAY 32060
#define IDS_EXTENSION_WARNINGS_DOWNLOAD_FILENAME_CONFLICT 32061
#define IDS_EXTENSION_WARNING_RELOAD_TOO_FREQUENT 32062
#define IDS_EXTENSION_WARNING_RULESET_FAILED_TO_LOAD 32063
#define IDS_EXTENSION_WARNING_ENABLED_RULE_COUNT_EXCEEDED 32064
#define IDS_EXTENSION_INSTALL_PROCESS_CRASHED 32065
#define IDS_EXTENSION_PACKAGE_ERROR_CODE 32066
#define IDS_EXTENSION_PACKAGE_ERROR_MESSAGE 32067
#define IDS_EXTENSION_PACKAGE_INSTALL_ERROR 32068
#define IDS_EXTENSION_UNPACK_FAILED 32069
#define IDS_EXTENSION_WEBGL_NOT_SUPPORTED 32070
#define IDS_EXTENSION_WINDOW_SHAPE_NOT_SUPPORTED 32071

// ---------------------------------------------------------------------------
// From generated_resources.h:

#define IDS_ACCESS_CODE_CAST_ACCESS_CODE_MESSAGE 1000
#define IDS_ACCESS_CODE_CAST_BACK 1001
#define IDS_ACCESS_CODE_CAST_CAST 1002
#define IDS_ACCESS_CODE_CAST_CONNECT 1003
#define IDS_ACCESS_CODE_CAST_DIALOG_TITLE 1004
#define IDS_ACCESS_CODE_CAST_ENTER_CHARACTER 1005
#define IDS_ACCESS_CODE_CAST_ERROR_ACCESS_CODE 1006
#define IDS_ACCESS_CODE_CAST_ERROR_NETWORK 1007
#define IDS_ACCESS_CODE_CAST_ERROR_PERMISSION 1008
#define IDS_ACCESS_CODE_CAST_ERROR_TOO_MANY_REQUESTS 1009
#define IDS_ACCESS_CODE_CAST_ERROR_UNKNOWN 1010
#define IDS_ACCESS_CODE_CAST_INPUT_ARIA_LABEL 1011
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_DAYS 1012
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_HOURS 1013
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_MONTHS 1014
#define IDS_ACCESS_CODE_CAST_MANAGED_FOOTNOTE_YEARS 1015
#define IDS_ACCESS_CODE_CAST_SUBMIT 1016
#define IDS_ACCESS_CODE_CAST_USE_CAMERA 1017
#define IDS_BOOKMARK_GROUP_FROM_FIREFOX 1020
#define IDS_BOOKMARK_GROUP_FROM_SAFARI 1021
#define IDS_BOOKMARK_GROUP 1022
#define IDS_BOOKMARK_BAR_SHOW_APPS_SHORTCUT 1023
#define IDS_BOOKMARK_BAR_SHOW_READING_LIST 1024
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS_DEFAULT_NAME 1025
#define IDS_BOOKMARK_BAR_SHOW_MANAGED_BOOKMARKS 1026
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_NAME 343
#define IDS_BOOKMARK_BAR_APPS_SHORTCUT_TOOLTIP 345
#define IDS_BOOKMARK_BAR_OVERFLOW_BUTTON_TOOLTIP 1027
#define IDS_BOOKMARK_BAR_OPEN_ALL 1028
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT 1029
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_WINDOW 1030
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_INCOGNITO 1031
#define IDS_BOOKMARK_BAR_OPEN_ALL_COUNT_NEW_TAB_GROUP 1032
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_TAB 1033
#define IDS_BOOKMARK_BAR_OPEN_IN_NEW_WINDOW 1034
#define IDS_BOOKMARK_BAR_OPEN_INCOGNITO 1035
#define IDS_BOOKMARK_BAR_EDIT 1036
#define IDS_BOOKMARK_BAR_RENAME_FOLDER 1037
#define IDS_BOOKMARK_BAR_REMOVE 1038
#define IDS_BOOKMARK_BAR_ADD_NEW_BOOKMARK 1039
#define IDS_BOOKMARK_BAR_NEW_FOLDER 1040
#define IDS_SHOW_BOOKMARK_BAR 286
#define IDS_BOOKMARK_BAR_SHOULD_OPEN_ALL 1041
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARKED 1042
#define IDS_BOOKMARK_BUBBLE_PAGE_BOOKMARK 1043
#define IDS_BOOKMARK_BUBBLE_NAME_LABEL 1044
#define IDS_BOOKMARK_AX_BUBBLE_NAME_LABEL 1045
#define IDS_BOOKMARK_BUBBLE_FOLDER_LABEL 1046
#define IDS_BOOKMARK_AX_BUBBLE_FOLDER_LABEL 1047
#define IDS_BOOKMARK_BUBBLE_OPTIONS 1048
#define IDS_BOOKMARK_BUBBLE_CHOOSER_ANOTHER_FOLDER 1049
#define IDS_BOOKMARK_DICE_PROMO_SYNC_MESSAGE 1050
#define IDS_BOOKMARK_EDITOR_NAME_LABEL 1055
#define IDS_BOOKMARK_AX_EDITOR_NAME_LABEL 1056
#define IDS_BOOKMARK_BAR_EDIT_FOLDER_LABEL 1057
#define IDS_BOOKMARK_AX_EDITOR_URL_LABEL 1058
#define IDS_BOOKMARK_EDITOR_URL_LABEL 1059
#define IDS_BOOKMARK_EDITOR_CONFIRM_DELETE 1060
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_BUTTON 1061
#define IDS_BOOKMARK_EDITOR_NEW_FOLDER_MENU_ITEM 1062
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE 1063
#define IDS_BOOKMARK_FOLDER_EDITOR_WINDOW_TITLE_NEW 1064
#define IDS_UNNAMED_BOOKMARK_FOLDER 1065
#define IDS_BOOKMARK_ALL_TABS_DIALOG_TITLE 1066
#define IDS_BOOKMARK_MANAGER_TITLE 1067
#define IDS_BOOKMARK_MANAGER_SEARCH_BUTTON 1068
#define IDS_BOOKMARK_MANAGER 174
#define IDS_BOOKMARK_MANAGER_ORGANIZE_MENU 1069
#define IDS_BOOKMARK_MANAGER_INVALID_URL 1070
#define IDS_EXPORT_BOOKMARKS_DEFAULT_FILENAME 1071
#define IDS_BOOKMARK_MANAGER_ADD_BOOKMARK_TITLE 1072
#define IDS_BOOKMARK_MANAGER_ADD_FOLDER_TITLE 1073
#define IDS_BOOKMARK_MANAGER_CLEAR_SEARCH 1074
#define IDS_BOOKMARK_MANAGER_EMPTY_LIST 1075
#define IDS_BOOKMARK_MANAGER_EMPTY_UNMODIFIABLE_LIST 1076
#define IDS_BOOKMARK_MANAGER_FOLDER_LABEL 1077
#define IDS_BOOKMARK_MANAGER_FOLDER_RENAME_TITLE 1078
#define IDS_BOOKMARK_MANAGER_FOLDER_LIST_CHANGED 1079
#define IDS_BOOKMARK_MANAGER_LIST_AX_LABEL 1080
#define IDS_BOOKMARK_MANAGER_MENU_ADD_BOOKMARK 1081
#define IDS_BOOKMARK_MANAGER_MENU_ADD_FOLDER 1082
#define IDS_BOOKMARK_MANAGER_MENU_CUT 1083
#define IDS_BOOKMARK_MANAGER_MENU_COPY 1084
#define IDS_BOOKMARK_MANAGER_MENU_PASTE 1085
#define IDS_BOOKMARK_MANAGER_MENU_EXPORT 1086
#define IDS_BOOKMARK_MANAGER_MENU_HELP_CENTER 1087
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT 1088
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_BEGAN 1089
#define IDS_BOOKMARK_MANAGER_MENU_IMPORT_ENDED 1090
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL 1091
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_WITH_COUNT 1092
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW 1093
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_NEW_WINDOW_WITH_COUNT 1094
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO 1095
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_ALL_INCOGNITO_WITH_COUNT 1096
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_TAB 1097
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_IN_NEW_WINDOW 1098
#define IDS_BOOKMARK_MANAGER_MENU_OPEN_INCOGNITO 1099
#define IDS_BOOKMARK_MANAGER_MENU_RENAME 1100
#define IDS_BOOKMARK_MANAGER_MENU_SHOW_IN_FOLDER 1101
#define IDS_BOOKMARK_MANAGER_MENU_SORT 1102
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS 1103
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_AX_LABEL 1104
#define IDS_BOOKMARK_MANAGER_MORE_ACTIONS_MULTI_AX_LABEL 1105
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_TITLE 1106
#define IDS_BOOKMARK_MANAGER_OPEN_DIALOG_CONFIRM 1107
#define IDS_BOOKMARK_MANAGER_ITEMS_SELECTED 1108
#define IDS_BOOKMARK_MANAGER_ITEMS_UNSELECTED 1109
#define IDS_BOOKMARK_MANAGER_SIDEBAR_AX_LABEL 1110
#define IDS_BOOKMARK_MANAGER_TOAST_FOLDER_SORTED 1111
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_DELETED 1112
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_DELETED 1113
#define IDS_BOOKMARK_MANAGER_TOAST_ITEM_COPIED 1114
#define IDS_BOOKMARK_MANAGER_TOAST_ITEMS_COPIED 1115
#define IDS_BOOKMARKS_MENU 173
#define IDS_BOOKMARK_THIS_TAB 175
#define IDS_BOOKMARK_ALL_TABS 176
#define IDS_TOOLTIP_STARRED 1116
#define IDS_BOOKMARK_SCREEN_READER_CREATED 1117
#define IDS_BOOKMARK_SCREEN_READER_REORDERED 1118
#define IDS_BOOKMARK_SCREEN_READER_MOVED 1119
#define IDS_APP_MANAGEMENT_CAMERA 1120
#define IDS_APP_MANAGEMENT_LOCATION 1121
#define IDS_APP_MANAGEMENT_MICROPHONE 1122
#define IDS_APP_MANAGEMENT_NO_APPS_FOUND 1123
#define IDS_APP_MANAGEMENT_NOTIFICATIONS 1124
#define IDS_APP_MANAGEMENT_PERMISSIONS 1125
#define IDS_APP_MANAGEMENT_MORE_SETTINGS 1126
#define IDS_APP_MANAGEMENT_PIN_TO_SHELF 1127
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES 1128
#define IDS_APP_MANAGEMENT_WINDOW 1129
#define IDS_APP_MANAGEMENT_PRESET_WINDOW_SIZES_TEXT 1130
#define IDS_APP_MANAGEMENT_PRINTING 1131
#define IDS_APP_MANAGEMENT_SEARCH_PROMPT 1132
#define IDS_APP_MANAGEMENT_UNINSTALL_APP 1133
#define IDS_APP_MANAGEMENT_CONTACTS 1134
#define IDS_APP_MANAGEMENT_STORAGE 1135
#define IDS_APP_MANAGEMENT_RUN_ON_OS_LOGIN 1136
#define IDS_APP_MANAGEMENT_POLICY_APP_POLICY_STRING 1137
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_TITLE 1138
#define IDS_APP_MANAGEMENT_INTENT_SHARING_APP_OPEN 1139
#define IDS_APP_MANAGEMENT_INTENT_SHARING_BROWSER_OPEN 1140
#define IDS_APP_MANAGEMENT_INTENT_SHARING_TAB_EXPLANATION 1141
#define IDS_APP_MANAGEMENT_INTENT_SETTINGS_DIALOG_TITLE 1142
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_CHANGE_BUTTON 1143
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TITLE 1144
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_1_APP 1145
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_2_APPS 1146
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_3_APPS 1147
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_4_APPS 1148
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_DIALOG_TEXT_5_OR_MORE_APPS 1149
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_1_APP 1150
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_2_APPS 1151
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_3_APPS 1152
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_4_APPS 1153
#define IDS_APP_MANAGEMENT_INTENT_OVERLAP_WARNING_TEXT_5_OR_MORE_APPS 1154
#define IDS_APP_MANAGEMENT_APP_DETAILS_TITLE 1155
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_ANDROID 1156
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_CHROME 1157
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_WEB 1158
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_SYSTEM 1159
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_CROS_SYSTEM 1160
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_WEB_STORE 1161
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_PLAY_STORE 1162
#define IDS_APP_MANAGEMENT_APP_DETAILS_INSTALL_SOURCE_BROWSER 1163
#define IDS_APP_MANAGEMENT_APP_DETAILS_TYPE_AND_SOURCE_COMBINED 1164
#define IDS_APP_MANAGEMENT_APP_DETAILS_VERSION 1165
#define IDS_APP_MANAGEMENT_APP_DETAILS_STORAGE_TITLE 1166
#define IDS_APP_MANAGEMENT_APP_DETAILS_APP_SIZE 1167
#define IDS_APP_MANAGEMENT_APP_DETAILS_DATA_SIZE 1168
#define IDS_APP_MANAGEMENT_FILE_HANDLING_HEADER 1169
#define IDS_APP_MANAGEMENT_FILE_HANDLING_OVERFLOW_DIALOG_TITLE 1170
#define IDS_APP_MANAGEMENT_FILE_HANDLING_SET_DEFAULTS_LINK 1171
#define IDS_APP_MANAGEMENT_FILE_HANDLING_TYPES 1172
#define IDS_MEDIA_ROUTER_ICON_TOOLTIP_TEXT 1173
#define IDS_MEDIA_ROUTER_MENU_ITEM_TITLE 161
#define IDS_MEDIA_ROUTER_PRESENTATION_CAST_MODE 1174
#define IDS_MEDIA_ROUTER_DESKTOP_MIRROR_CAST_MODE 1175
#define IDS_MEDIA_ROUTER_TAB_MIRROR_CAST_MODE 1176
#define IDS_MEDIA_ROUTER_LOCAL_FILE_CAST_MODE 1177
#define IDS_MEDIA_ROUTER_CAST_LOCAL_MEDIA_TITLE 1178
#define IDS_MEDIA_ROUTER_ALTERNATIVE_SOURCES_BUTTON 1179
#define IDS_MEDIA_ROUTER_ABOUT 1180
#define IDS_MEDIA_ROUTER_HELP 1181
#define IDS_MEDIA_ROUTER_ALWAYS_SHOW_TOOLBAR_ACTION 1182
#define IDS_MEDIA_ROUTER_SHOWN_BY_POLICY 1183
#define IDS_MEDIA_ROUTER_TOGGLE_MEDIA_REMOTING 1184
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT 1185
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_DESKTOP 1186
#define IDS_MEDIA_ROUTER_ISSUE_CREATE_ROUTE_TIMEOUT_FOR_TAB 1187
#define IDS_MEDIA_ROUTER_ISSUE_UNABLE_TO_CAST_DESKTOP 1188
#define IDS_MEDIA_ROUTER_ISSUE_FILE_CAST_GENERIC_ERROR 1189
#define IDS_MEDIA_ROUTER_ISSUE_FILE_CAST_ERROR 1190
#define IDS_MEDIA_ROUTER_ISSUE_TAB_AUDIO_NOT_SUPPORTED 1191
#define IDS_MEDIA_ROUTER_ISSUE_MAC_SCREEN_CAPTURE_PERMISSION_ERROR 1192
#define IDS_MEDIA_ROUTER_STATUS_LOOKING_FOR_DEVICES 1193
#define IDS_MEDIA_ROUTER_STATUS_NO_DEVICES_FOUND 1194
#define IDS_MEDIA_ROUTER_NO_DEVICES_FOUND_BUTTON 1195
#define IDS_MEDIA_ROUTER_DESTINATION_MISSING 1196
#define IDS_MEDIA_ROUTER_SINK_AVAILABLE 1197
#define IDS_MEDIA_ROUTER_SINK_CONNECTING 1198
#define IDS_MEDIA_ROUTER_SINK_DISCONNECTING 1199
#define IDS_MEDIA_ROUTER_STOP_CASTING 1200
#define IDS_MEDIA_ROUTER_SOURCE_NOT_SUPPORTED 1201
#define IDS_MEDIA_ROUTER_AVAILABLE_SPECIFIC_SITES 1202
#define IDS_MEDIA_ROUTER_CASTING_DESKTOP 1203
#define IDS_MEDIA_ROUTER_CASTING_TAB 1204
#define IDS_MEDIA_ROUTER_PRESENTATION_ROUTE_DESCRIPTION 1205
#define IDS_MEDIA_ROUTER_FILE_DIALOG_AUDIO_VIDEO_FILTER 1206
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_TITLE 1207
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_BODY_TEXT 1208
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CHECKBOX 1209
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_OPTIMIZE_BUTTON 1210
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON 1211
#define IDS_MEDIA_ROUTER_REMOTING_DIALOG_CANCEL_BUTTON_MACOS 1212
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_DEPRECATED 1213
#define IDS_MEDIA_ROUTER_CAST_TO_MEETING_REMOVED 1214
#define IDS_MEDIA_ROUTER_WIRED_DISPLAY_SINK_NAME 1215
#define IDS_MEDIA_ROUTER_FEEDBACK_TITLE 1216
#define IDS_MEDIA_ROUTER_FEEDBACK_NA 1217
#define IDS_MEDIA_ROUTER_FEEDBACK_FORM_DESCRIPTION 1218
#define IDS_MEDIA_ROUTER_FEEDBACK_HEADER 1219
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_ANSWER 1220
#define IDS_MEDIA_ROUTER_FEEDBACK_REQUIRED 1221
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_QUESTION 1222
#define IDS_MEDIA_ROUTER_FEEDBACK_PROMPT 1223
#define IDS_MEDIA_ROUTER_FEEDBACK_MIRRORING_QUALITY_SUBHEADING 1224
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTHNESS 1225
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_QUALITY 1226
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_QUALITY 1227
#define IDS_MEDIA_ROUTER_FEEDBACK_CONTENT_QUESTION 1228
#define IDS_MEDIA_ROUTER_FEEDBACK_ADDITIONAL_COMMENTS 1229
#define IDS_MEDIA_ROUTER_FEEDBACK_ALLOW_CONTACT_BY_EMAIL 1230
#define IDS_MEDIA_ROUTER_FEEDBACK_YOUR_EMAIL_ADDRESS 1231
#define IDS_MEDIA_ROUTER_FEEDBACK_EMAIL_FIELD 1232
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_BUTTON 1233
#define IDS_MEDIA_ROUTER_FEEDBACK_DISCARD_CONFIRMATION 1234
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_BUG_OR_ERROR 1235
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_FEATURE_REQUEST 1236
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_PROJECTION_QUALITY 1237
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_DISCOVERY 1238
#define IDS_MEDIA_ROUTER_FEEDBACK_TYPE_OTHER 1239
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_FREEZES 1240
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_JERKY 1241
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_STUTTER 1242
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_SMOOTH 1243
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_PERFECT 1244
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_UNWATCHABLE 1245
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_POOR 1246
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_ACCEPTABLE 1247
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GOOD 1248
#define IDS_MEDIA_ROUTER_FEEDBACK_VIDEO_GREAT 1249
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_UNINTELLIGIBLE 1250
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_POOR 1251
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_ACCEPTABLE 1252
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_GOOD 1253
#define IDS_MEDIA_ROUTER_FEEDBACK_AUDIO_PERFECT 1254
#define IDS_MEDIA_ROUTER_FEEDBACK_SENDING 1255
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_FAIL 1256
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_SUCCESS 1257
#define IDS_MEDIA_ROUTER_FEEDBACK_RESENDING 1258
#define IDS_MEDIA_ROUTER_FEEDBACK_LOGS_HEADER 1259
#define IDS_MEDIA_ROUTER_FEEDBACK_FINE_LOGS_WARNING 1260
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS_HTML 1261
#define IDS_MEDIA_ROUTER_FEEDBACK_SEND_LOGS 1262
#define IDS_MEDIA_ROUTER_FEEDBACK_PRIVACY_DATA_USAGE 1263
#define IDS_MEDIA_ROUTER_FEEDBACK_SETUP_VISIBILITY_QUESTION 1264
#define IDS_MEDIA_ROUTER_FEEDBACK_YES 1265
#define IDS_MEDIA_ROUTER_FEEDBACK_NO 1266
#define IDS_MEDIA_ROUTER_FEEDBACK_DID_NOT_TRY 1267
#define IDS_MEDIA_ROUTER_FEEDBACK_SOFTWARE_QUESTION 1268
#define IDS_MEDIA_ROUTER_FEEDBACK_UNKNOWN 1269
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_QUESTION 1270
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_SAME_WIFI 1271
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_DIFFERENT_WIFI 1272
#define IDS_MEDIA_ROUTER_FEEDBACK_NETWORK_WIRED_PC 1273
#define IDS_GLOBAL_MEDIA_CONTROLS_ICON_TOOLTIP_TEXT 1274
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL_WITH_COLON 1275
#define IDS_GLOBAL_MEDIA_CONTROLS_DEVICES_LABEL 1276
#define IDS_GLOBAL_MEDIA_CONTROLS_STOP_CASTING_BUTTON_LABEL 1277
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_ENGLISH_ONLY 1278
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION 1279
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_SHOW_LANGUAGE 1280
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_PROGRESS 1281
#define IDS_GLOBAL_MEDIA_CONTROLS_LIVE_CAPTION_DOWNLOAD_ERROR 1282
#define IDS_GLOBAL_MEDIA_CONTROLS_DIALOG_NAME 1283
#define IDS_GLOBAL_MEDIA_CONTROLS_SHOW_DEVICE_LIST 1284
#define IDS_GLOBAL_MEDIA_CONTROLS_HIDE_DEVICE_LIST 1285
#define IDS_GLOBAL_MEDIA_CONTROLS_CONTROL_CAST_SESSIONS_PROMO 1286
#define IDS_MEDIA_TOOLBAR_CONTEXT_REPORT_CAST_ISSUE 1287
#define IDS_MEDIA_TOOLBAR_CONTEXT_SHOW_OTHER_SESSIONS 1288
#define IDS_CHILD_INFO_ONE_CUSTODIAN 1289
#define IDS_CHILD_INFO_TWO_CUSTODIANS 1290
#define IDS_AVATAR_BUTTON_GUEST 1291
#define IDS_AVATAR_BUTTON_GUEST_TOOLTIP 1292
#define IDS_GUEST_BUBBLE_ACCESSIBLE_TITLE 1293
#define IDS_INCOGNITO_BUBBLE_ACCESSIBLE_TITLE 1294
#define IDS_AVATAR_BUTTON_INCOGNITO 1295
#define IDS_AVATAR_BUTTON_INCOGNITO_TOOLTIP 1296
#define IDS_AVATAR_BUTTON_SYNC_ERROR 1297
#define IDS_AVATAR_BUTTON_SYNC_ERROR_TOOLTIP 1298
#define IDS_AVATAR_BUTTON_SYNC_PAUSED 1299
#define IDS_BLOCK_INTERSTITIAL_DEFAULT_FEEDBACK_TEXT 1300
#define IDS_PROFILES_MENU_NAME 366
#define IDS_PROFILES_CREATE_NEW_PROFILE_OPTION 341
#define IDS_PROFILES_ADD_PROFILE_LABEL 367
#define IDS_PROFILES_PROFILE_BUBBLE_ACCESSIBLE_TITLE 1301
#define IDS_PROFILES_EXIT_PROFILE_BUTTON 1302
#define IDS_PROFILES_GAIA_SIGNIN_TITLE 1303
#define IDS_PROFILES_ACCOUNT_REMOVAL_TITLE 1304
#define IDS_PROFILES_SYNC_COMPLETE_TITLE 1305
#define IDS_PROFILES_OPEN_SYNC_SETTINGS_BUTTON 1306
#define IDS_PROFILES_DICE_SIGNIN_BUTTON 1307
#define IDS_PROFILES_DICE_NOT_SYNCING_TITLE 1308
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON 1309
#define IDS_PROFILES_DICE_SIGNIN_FIRST_ACCOUNT_BUTTON_NO_NAME 1310
#define IDS_PROFILES_DICE_SYNC_DISABLED_TITLE 1311
#define IDS_PROFILES_DICE_SYNC_PAUSED_TITLE 1312
#define IDS_PROFILES_CLOSE_X_WINDOWS_BUTTON 1313
#define IDS_PROFILES_SIGNIN_PROMO 1314
#define IDS_PROFILES_PASSWORDS_LINK 1315
#define IDS_PROFILES_CREDIT_CARDS_LINK 1316
#define IDS_PROFILES_ADDRESSES_LINK 1317
#define IDS_PROFILES_LIST_PROFILES_TITLE 1318
#define IDS_PROFILES_PROFILE_MANAGE_ACCOUNTS_BUTTON 1319
#define IDS_PROFILES_PROFILE_HIDE_MANAGE_ACCOUNTS_BUTTON 1320
#define IDS_PROFILES_MANAGE_PROFILES_BUTTON_TOOLTIP 1321
#define IDS_PROFILES_CUSTOMIZE_PROFILE_BUTTON_TOOLTIP 1322
#define IDS_PROFILES_GUEST_PROFILE_NAME 1323
#define IDS_DEFAULT_PROFILE_NAME 207
#define IDS_LEGACY_DEFAULT_PROFILE_NAME 208
#define IDS_NUMBERED_PROFILE_NAME 1324
#define IDS_NEW_NUMBERED_PROFILE_NAME 1325
#define IDS_SINGLE_PROFILE_DISPLAY_NAME 1326
#define IDS_GUEST_PROFILE_NAME 1327
#define IDS_DEFAULT_AVATAR_NAME_8 1328
#define IDS_DEFAULT_AVATAR_NAME_9 1329
#define IDS_DEFAULT_AVATAR_NAME_10 1330
#define IDS_DEFAULT_AVATAR_NAME_11 1331
#define IDS_DEFAULT_AVATAR_NAME_12 1332
#define IDS_DEFAULT_AVATAR_NAME_13 1333
#define IDS_DEFAULT_AVATAR_NAME_14 1334
#define IDS_DEFAULT_AVATAR_NAME_15 1335
#define IDS_DEFAULT_AVATAR_NAME_16 1336
#define IDS_DEFAULT_AVATAR_NAME_17 1337
#define IDS_DEFAULT_AVATAR_NAME_18 1338
#define IDS_DEFAULT_AVATAR_NAME_19 1339
#define IDS_DEFAULT_AVATAR_NAME_20 1340
#define IDS_DEFAULT_AVATAR_NAME_21 1341
#define IDS_DEFAULT_AVATAR_NAME_22 1342
#define IDS_DEFAULT_AVATAR_NAME_23 1343
#define IDS_DEFAULT_AVATAR_NAME_24 1344
#define IDS_DEFAULT_AVATAR_NAME_25 1345
#define IDS_DEFAULT_AVATAR_NAME_26 1346
#define IDS_DEFAULT_AVATAR_LABEL_0 1347
#define IDS_DEFAULT_AVATAR_LABEL_1 1348
#define IDS_DEFAULT_AVATAR_LABEL_2 1349
#define IDS_DEFAULT_AVATAR_LABEL_3 1350
#define IDS_DEFAULT_AVATAR_LABEL_4 1351
#define IDS_DEFAULT_AVATAR_LABEL_5 1352
#define IDS_DEFAULT_AVATAR_LABEL_6 1353
#define IDS_DEFAULT_AVATAR_LABEL_7 1354
#define IDS_DEFAULT_AVATAR_LABEL_8 1355
#define IDS_DEFAULT_AVATAR_LABEL_9 1356
#define IDS_DEFAULT_AVATAR_LABEL_10 1357
#define IDS_DEFAULT_AVATAR_LABEL_11 1358
#define IDS_DEFAULT_AVATAR_LABEL_12 1359
#define IDS_DEFAULT_AVATAR_LABEL_13 1360
#define IDS_DEFAULT_AVATAR_LABEL_14 1361
#define IDS_DEFAULT_AVATAR_LABEL_15 1362
#define IDS_DEFAULT_AVATAR_LABEL_16 1363
#define IDS_DEFAULT_AVATAR_LABEL_17 1364
#define IDS_DEFAULT_AVATAR_LABEL_18 1365
#define IDS_DEFAULT_AVATAR_LABEL_19 1366
#define IDS_DEFAULT_AVATAR_LABEL_20 1367
#define IDS_DEFAULT_AVATAR_LABEL_21 1368
#define IDS_DEFAULT_AVATAR_LABEL_22 1369
#define IDS_DEFAULT_AVATAR_LABEL_23 1370
#define IDS_DEFAULT_AVATAR_LABEL_24 1371
#define IDS_DEFAULT_AVATAR_LABEL_25 1372
#define IDS_DEFAULT_AVATAR_LABEL_26 1373
#define IDS_DEFAULT_AVATAR_LABEL_27 1374
#define IDS_DEFAULT_AVATAR_LABEL_28 1375
#define IDS_DEFAULT_AVATAR_LABEL_29 1376
#define IDS_DEFAULT_AVATAR_LABEL_30 1377
#define IDS_DEFAULT_AVATAR_LABEL_31 1378
#define IDS_DEFAULT_AVATAR_LABEL_32 1379
#define IDS_DEFAULT_AVATAR_LABEL_33 1380
#define IDS_DEFAULT_AVATAR_LABEL_34 1381
#define IDS_DEFAULT_AVATAR_LABEL_35 1382
#define IDS_DEFAULT_AVATAR_LABEL_36 1383
#define IDS_DEFAULT_AVATAR_LABEL_37 1384
#define IDS_DEFAULT_AVATAR_LABEL_38 1385
#define IDS_DEFAULT_AVATAR_LABEL_39 1386
#define IDS_DEFAULT_AVATAR_LABEL_40 1387
#define IDS_DEFAULT_AVATAR_LABEL_41 1388
#define IDS_DEFAULT_AVATAR_LABEL_42 1389
#define IDS_DEFAULT_AVATAR_LABEL_43 1390
#define IDS_DEFAULT_AVATAR_LABEL_44 1391
#define IDS_DEFAULT_AVATAR_LABEL_45 1392
#define IDS_DEFAULT_AVATAR_LABEL_46 1393
#define IDS_DEFAULT_AVATAR_LABEL_47 1394
#define IDS_DEFAULT_AVATAR_LABEL_48 1395
#define IDS_DEFAULT_AVATAR_LABEL_49 1396
#define IDS_DEFAULT_AVATAR_LABEL_50 1397
#define IDS_DEFAULT_AVATAR_LABEL_51 1398
#define IDS_DEFAULT_AVATAR_LABEL_52 1399
#define IDS_DEFAULT_AVATAR_LABEL_53 1400
#define IDS_DEFAULT_AVATAR_LABEL_54 1401
#define IDS_DEFAULT_AVATAR_LABEL_55 1402
#define IDS_PROFILES_LOCAL_PROFILE_STATE 339
#define IDS_PROFILES_CREATE_BUTTON_LABEL 1403
#define IDS_PROFILES_MANAGE_BUTTON_LABEL 340
#define IDS_PROFILES_DEFAULT_NAME 242
#define IDS_SYNC_LOGIN_NAME_PROHIBITED 1404
#define IDS_SUPERVISED_USER_NOT_ALLOWED_BY_POLICY 1405
#define IDS_OLD_PROFILES_DISABLED_TITLE 1406
#define IDS_OLD_PROFILES_DISABLED_MESSAGE 1407
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION 1408
#define IDS_OLD_PROFILES_DISABLED_ADD_PERSON_SUGGESTION_WITH_DOMAIN 1409
#define IDS_OLD_PROFILES_DISABLED_REMOVED_OLD_PROFILE 1410
#define IDS_SYNC_USER_NAME_IN_USE_ERROR 1411
#define IDS_SYNC_USER_NAME_IN_USE_BY_ERROR 1412
#define IDS_SCREEN_LOCK_SIGN_OUT 1413
#define IDS_PROFILE_CUSTOMIZATION_DONE_BUTTON_LABEL 1420
#define IDS_PROFILE_CUSTOMIZATION_WELCOME 1421
#define IDS_PROFILE_CUSTOMIZATION_INPUT_LABEL 1422
#define IDS_PROFILE_CUSTOMIZATION_SKIP_BUTTON_LABEL 1423
#define IDS_ENTERPRISE_PROFILE_WELCOME_TITLE 1424
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_MANAGED_BY 1425
#define IDS_ENTERPRISE_PROFILE_WELCOME_ACCOUNT_EMAIL_MANAGED_BY 1426
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED_BY 1427
#define IDS_ENTERPRISE_PROFILE_WELCOME_DEVICE_MANAGED 1428
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITH_SYNC 1429
#define IDS_ENTERPRISE_PROFILE_WELCOME_MANAGED_DESCRIPTION_WITHOUT_SYNC 1430
#define IDS_ENTERPRISE_WELCOME_PROFILE_REQUIRED_TITLE 1431
#define IDS_ENTERPRISE_WELCOME_PROFILE_WILL_BE_MANAGED_TITLE 1432
#define IDS_ENTERPRISE_PROFILE_WELCOME_CREATE_PROFILE_BUTTON 1433
#define IDS_ENTERPRISE_PROFILE_WELCOME_LINK_DATA_CHECKBOX 1434
#define IDS_PROFILE_PICKER_ADD_SPACE_BUTTON 1435
#define IDS_PROFILE_PICKER_BROWSE_AS_GUEST_BUTTON 1436
#define IDS_PROFILE_PICKER_BACK_BUTTON_ARIA_LABEL 1437
#define IDS_PROFILE_PICKER_BACK_BUTTON_SIGN_IN_LABEL 1438
#define IDS_PROFILE_PICKER_PROFILE_CARD_NEEDS_SIGNIN_PROMPT 1439
#define IDS_PROFILE_PICKER_PROFILE_CARD_LABEL 1440
#define IDS_PROFILE_PICKER_PROFILE_CARD_INPUT_LABEL 1441
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_TEXT 1442
#define IDS_PROFILE_PICKER_PROFILE_MENU_REMOVE_CONFIRM 1443
#define IDS_PROFILE_PICKER_PROFILE_MENU_CUSTOMIZE_TEXT 1444
#define IDS_PROFILE_PICKER_PROFILE_MENU_INCOGNITO_TEXT 1445
#define IDS_PROFILE_PICKER_ASK_ON_STARTUP 1446
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE_TITLE 1447
#define IDS_PROFILE_PICKER_REMOVE_WARNING_HISTORY 1448
#define IDS_PROFILE_PICKER_REMOVE_WARNING_PASSWORDS 1449
#define IDS_PROFILE_PICKER_REMOVE_WARNING_BOOKMARKS 1450
#define IDS_PROFILE_PICKER_REMOVE_WARNING_AUTOFILL 1451
#define IDS_PROFILE_PICKER_REMOVE_WARNING_CALCULATING 1452
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_SIGNIN_BUTTON_LABEL 1453
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_NOT_NOW_BUTTON_LABEL 1454
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_CUSTOMIZE_AVATAR_BUTTON_LABEL 1455
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_THEME_TEXT 1456
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_AVATAR_TEXT 1457
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_DONE 1458
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_AVATAR_DONE 1459
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_INPUT_NAME 1460
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_LOCAL_PROFILE_CREATION_SHORTCUT_TEXT 1461
#define IDS_PROFILE_PICKER_TAKE_A_TOUR_BUTTON_LABEL 1462
#define IDS_PROFILE_PICKER_IPH_NEXT_BUTTON_LABEL 1463
#define IDS_PROFILE_PICKER_IPH_DONE_BUTTON_LABEL 1464
#define IDS_PROFILE_PICKER_IPH_FOR_PROFILES_TITLE 1465
#define IDS_PROFILE_PICKER_IPH_FOR_ADD_PROFILE_TITLE 1466
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TITLE 1467
#define IDS_PROFILE_PICKER_IPH_FOR_CUSTOMIZE_PROFILE_TEXT 1468
#define IDS_PROFILE_PICKER_PROFILE_SWITCH_SWITCH_BUTTON_LABEL 1469
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_BY_DESCRIPTION 1470
#define IDS_PROFILE_PICKER_PROFILE_CREATION_FLOW_DEVICE_MANAGED_DESCRIPTION 1471
#define IDS_PROFILE_PICKER_REMOVE_WARNING_LOCAL_PROFILE 1472
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE_TITLE 1473
#define IDS_PROFILE_PICKER_REMOVE_WARNING_SIGNED_IN_PROFILE 1474
#define IDS_SETTINGS_EMPTY_STRING 5270
#define IDS_SETTINGS_CONTINUE 5271
#define IDS_SETTINGS_MORE_ACTIONS 5272
#define IDS_RELAUNCH_CONFIRMATION_DIALOG_BODY 5273
#define IDS_SETTINGS_ABOUT_PAGE_BROWSER_VERSION 5274
#define IDS_SETTINGS_ABOUT_PAGE_RELAUNCH 3403
#define IDS_ABOUT_CHROME_AUTOUPDATE_ALL 5277
#define IDS_ABOUT_CHROME_AUTOUPDATE_ALL_IS_ON 5278
#define IDS_SETTINGS_ACCESSIBILITY 5279
#define IDS_SETTINGS_ACCESSIBILITY_WEB_STORE 5280
#define IDS_SETTINGS_MORE_FEATURES_LINK 5281
#define IDS_SETTINGS_MORE_FEATURES_LINK_DESCRIPTION 5282
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_TITLE 5283
#define IDS_SETTINGS_ACCESSIBLE_IMAGE_LABELS_SUBTITLE 5284
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_TITLE 5285
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE_ENGLISH_ONLY 5286
#define IDS_SETTINGS_CAPTIONS_ENABLE_LIVE_CAPTION_SUBTITLE 5287
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_PROGRESS 5288
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_COMPLETE 5289
#define IDS_SETTINGS_CAPTIONS_LIVE_CAPTION_DOWNLOAD_ERROR 5290
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_TITLE 5291
#define IDS_SETTINGS_ENABLE_CARET_BROWSING_SUBTITLE 5292
#define IDS_SETTINGS_ACCESSIBILITY_FOCUS_HIGHLIGHT_DESCRIPTION 3760
#define IDS_SETTINGS_APPEARANCE 5293
#define IDS_SETTINGS_CUSTOM_WEB_ADDRESS 5294
#define IDS_SETTINGS_ENTER_CUSTOM_WEB_ADDRESS 5295
#define IDS_SETTINGS_HOME_BUTTON_DISABLED 5296
#define IDS_SETTINGS_THEMES 5297
#define IDS_SETTINGS_RESET_TO_DEFAULT_THEME 5302
#define IDS_SETTINGS_CHROME_COLORS 5303
#define IDS_SETTINGS_SHOW_HOME_BUTTON 5304
#define IDS_SETTINGS_SHOW_BOOKMARKS_BAR 5305
#define IDS_SETTINGS_SIDE_PANEL 5306
#define IDS_SETTINGS_SIDE_PANEL_ALIGN_LEFT 5307
#define IDS_SETTINGS_SIDE_PANEL_ALIGN_RIGHT 5308
#define IDS_SETTINGS_HOME_PAGE_NTP 5309
#define IDS_SETTINGS_CHANGE_HOME_PAGE 5310
#define IDS_SETTINGS_WEB_STORE 5311
#define IDS_SETTINGS_TABS_TO_LINKS_PREF 5312
#define IDS_SETTINGS_WARN_BEFORE_QUITTING_PREF 5313
#define IDS_SETTINGS_READER_MODE 5314
#define IDS_SETTINGS_READER_MODE_DESCRIPTION 5315
#define IDS_SETTINGS_ADVANCED 5316
#define IDS_SETTINGS_BASIC 5317
#define IDS_SETTINGS_MENU_BUTTON_LABEL 5318
#define IDS_SETTINGS_MENU_EXTENSIONS_LINK_TOOLTIP 5319
#define IDS_SETTINGS_SEARCH_PROMPT 5320
#define IDS_SETTINGS_SEARCH_NO_RESULTS_HELP 5321
#define IDS_SETTINGS_SETTINGS 5322
#define IDS_SETTINGS_ALT_PAGE_TITLE 5323
#define IDS_SETTINGS_SUBPAGE_BUTTON 5324
#define IDS_SETTINGS_RESTART 5325
#define IDS_SETTINGS_CONTROLLED_BY_EXTENSION 5326
#define IDS_SETTINGS_CLEAR 5327
#define IDS_SETTINGS_CUSTOM 5328
#define IDS_SETTINGS_DELETE 5329
#define IDS_SETTINGS_EDIT 5330
#define IDS_SETTINGS_END_TIME 5331
#define IDS_SETTINGS_NOT_VALID 5332
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS 5333
#define IDS_SETTINGS_NOT_VALID_WEB_ADDRESS_FOR_CONTENT_TYPE 5334
#define IDS_SETTINGS_RETRY 5335
#define IDS_SETTINGS_SLIDER_MIN_MAX_ARIA_ROLE_DESCRIPTION 5336
#define IDS_SETTINGS_START_TIME 5337
#define IDS_SETTINGS_AUTOFILL 5338
#define IDS_SETTINGS_GOOGLE_PAYMENTS 5339
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_ADD_TITLE 5340
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EDIT_TITLE 5341
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_COUNTRY 5342
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_PHONE 5343
#define IDS_SETTINGS_AUTOFILL_ADDRESSES_EMAIL 5344
#define IDS_SETTINGS_AUTOFILL_ADDRESS_HONORIFIC_LABEL 5345
#define IDS_SETTINGS_AUTOFILL_CREDIT_CARD_TYPE_COLUMN_LABEL 5346
#define IDS_SETTINGS_AUTOFILL_DETAIL 5347
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_ADDRESS 5348
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_FOR_CREDIT_CARD 5349
#define IDS_SETTINGS_AUTOFILL_MORE_ACTIONS_CARD_DESCRIPTION 5350
#define IDS_AUTOFILL_ADD_VIRTUAL_CARD 5351
#define IDS_AUTOFILL_REMOVE_VIRTUAL_CARD 5352
#define IDS_AUTOFILL_EDIT_SERVER_CREDIT_CARD 5353
#define IDS_AUTOFILL_VIRTUAL_CARD_ENABLED_LABEL 5354
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_TITLE 5355
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_LABEL 5356
#define IDS_AUTOFILL_VIRTUAL_CARD_UNENROLL_DIALOG_CONFIRM_BUTTON_LABEL 5357
#define IDS_SETTINGS_ADDRESS_REMOVE 5358
#define IDS_SETTINGS_ADDRESS_REMOVE_CONFIRMATION_DESCRIPTION 5359
#define IDS_SETTINGS_ADDRESS_REMOVE_CONFIRMATION_TITLE 5360
#define IDS_SETTINGS_CREDIT_CARD_REMOVE 5361
#define IDS_SETTINGS_CREDIT_CARD_CLEAR 5362
#define IDS_SETTINGS_EDIT_CREDIT_CARD_TITLE 5363
#define IDS_SETTINGS_PAYMENTS_MANAGE_CREDIT_CARDS 5364
#define IDS_SETTINGS_PAYMENTS_SAVED_TO_THIS_DEVICE_ONLY 5365
#define IDS_SETTINGS_ADD_CREDIT_CARD_TITLE 5366
#define IDS_SETTINGS_MIGRATABLE_CARDS_LABEL 5367
#define IDS_SETTINGS_SINGLE_MIGRATABLE_CARD_INFO 5368
#define IDS_SETTINGS_MULTIPLE_MIGRATABLE_CARDS_INFO 5369
#define IDS_SETTINGS_REMOTE_CREDIT_CARD_LINK_LABEL 5370
#define IDS_SETTINGS_NAME_ON_CREDIT_CARD 5371
#define IDS_SETTINGS_CREDIT_CARD_NUMBER 5372
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_DATE 5373
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_MONTH 5374
#define IDS_SETTINGS_CREDIT_CARD_EXPIRATION_YEAR 5375
#define IDS_SETTINGS_CREDIT_CARD_EXPIRED 5376
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME 5377
#define IDS_SETTINGS_CREDIT_CARD_NICKNAME_INVALID 5378
#define IDS_SETTINGS_UPI_ID_LABEL 5379
#define IDS_SETTINGS_UPI_ID_EXPIRATION_NEVER 5380
#define IDS_SETTINGS_PASSWORDS 5381
#define IDS_SETTINGS_PASSWORD_MANAGER 5382
#define IDS_SETTINGS_PASSWORD_MANAGER_DESCRIPTION 5383
#define IDS_SETTINGS_DEVICE_PASSWORDS 5384
#define IDS_SETTINGS_DEVICE_PASSWORDS_ON_DEVICE_ONLY_HEADING 5385
#define IDS_SETTINGS_DEVICE_PASSWORDS_ON_DEVICE_AND_ACCOUNT_HEADING 5386
#define IDS_SETTINGS_CHECK_PASSWORDS 5387
#define IDS_SETTINGS_CHECK_PASSWORDS_CANCELED 5388
#define IDS_SETTINGS_CHECKED_PASSWORDS 5389
#define IDS_SETTINGS_CHECK_PASSWORDS_DESCRIPTION 5390
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT 5391
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_COUNT_SHORT 5392
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT 5393
#define IDS_SETTINGS_WEAK_PASSWORDS_COUNT_SHORT 5394
#define IDS_SETTINGS_INSECURE_PASSWORDS_COUNT 5395
#define IDS_SETTINGS_CHECK_PASSWORDS_AGAIN 5396
#define IDS_SETTINGS_CHECK_PASSWORDS_AGAIN_AFTER_ERROR 5397
#define IDS_SETTINGS_CHECK_PASSWORDS_PROGRESS 5398
#define IDS_SETTINGS_CHECK_PASSWORDS_STOP 5399
#define IDS_SETTINGS_PASSWORDS_JUST_NOW 5400
#define IDS_SETTINGS_COMPROMISED_PASSWORDS 5401
#define IDS_SETTINGS_COMPROMISED_PASSWORDS_ADVICE 5402
#define IDS_SETTINGS_MUTED_PASSWORDS 5403
#define IDS_SETTINGS_WEAK_PASSWORDS 5404
#define IDS_SETTINGS_WEAK_PASSWORDS_DESCRIPTION 5405
#define IDS_SETTINGS_CHANGE_PASSWORD_BUTTON 5406
#define IDS_SETTINGS_CHANGE_PASSWORD_IN_APP_LABEL 5407
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REASON_LEAKED 5408
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REASON_PHISHED 5409
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REASON_PHISHED_AND_LEAKED 5410
#define IDS_SETTINGS_COMPROMISED_PASSWORD_SHOW 5411
#define IDS_SETTINGS_COMPROMISED_PASSWORD_HIDE 5412
#define IDS_SETTINGS_COMPROMISED_PASSWORD_REMOVE 5413
#define IDS_SETTINGS_COMPROMISED_PASSWORD_MUTE 5414
#define IDS_SETTINGS_COMPROMISED_PASSWORD_UNMUTE 5415
#define IDS_SETTINGS_REMOVE_COMPROMISED_PASSWORD_CONFIRMATION_TITLE 5416
#define IDS_SETTINGS_REMOVE_COMPROMISED_PASSWORD_CONFIRMATION_DESCRIPTION 5417
#define IDS_SETTINGS_COMPROMISED_EDIT_PASSWORD_APP 5418
#define IDS_SETTINGS_COMPROMISED_ALREADY_CHANGED_PASSWORD 5419
#define IDS_SETTINGS_COMPROMISED_EDIT_DISCLAIMER_TITLE 5420
#define IDS_SETTINGS_PASSWORDS_SAVE_PASSWORDS_TOGGLE_LABEL 5421
#define IDS_SETTINGS_PASSWORDS_AUTOSIGNIN_CHECKBOX_LABEL 5422
#define IDS_SETTINGS_PASSWORDS_AUTOSIGNIN_CHECKBOX_DESC 5423
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_LABEL 5424
#define IDS_SETTINGS_PASSWORDS_LEAK_DETECTION_SIGNED_OUT_ENABLED_DESC 5425
#define IDS_SETTINGS_PASSWORDS_SAVED_HEADING 5426
#define IDS_SETTINGS_PASSWORDS_EXCEPTIONS_HEADING 5427
#define IDS_SETTINGS_PASSWORDS_DELETE_EXCEPTION 5428
#define IDS_SETTINGS_PASSWORD_REMOVE 5429
#define IDS_SETTINGS_PASSWORD_MOVE_TO_ACCOUNT 5430
#define IDS_SETTINGS_PASSWORD_SEARCH 5431
#define IDS_SETTINGS_PASSWORDS_VIEW_DETAILS_TITLE 5432
#define IDS_SETTINGS_PASSWORD_DETAILS 5433
#define IDS_SETTINGS_PASSWORD_EDIT_TITLE 5434
#define IDS_SETTINGS_PASSWORD_EDIT 5435
#define IDS_SETTINGS_PASSWORD_EDIT_FOOTNOTE 5436
#define IDS_SETTINGS_PASSWORD_USERNAME_ALREADY_USED 5437
#define IDS_SETTINGS_PASSWORD_VIEW_EXISTING_PASSWORD 5438
#define IDS_SETTINGS_PASSWORD_VIEW_EXISTING_PASSWORD_ARIA_DESCRIPTION 5439
#define IDS_SETTINGS_PASSWORD_MISSING_TLD 5440
#define IDS_SETTINGS_PASSWORD_ADD_TITLE 5441
#define IDS_SETTINGS_PASSWORD_ADD_FOOTNOTE 5442
#define IDS_SETTINGS_PASSWORD_ADD_STORE_OPTION_ACCOUNT 5443
#define IDS_SETTINGS_PASSWORD_COPY 5444
#define IDS_SETTINGS_PASSWORD_SEND 5445
#define IDS_SETTINGS_USERNAME_COPY 5446
#define IDS_SETTINGS_PASSWORDS_WEBSITE 5447
#define IDS_SETTINGS_PASSWORDS_ANDROID_APP 5448
#define IDS_SETTINGS_PASSWORDS_USERNAME 5449
#define IDS_SETTINGS_PASSWORDS_PASSWORD 5450
#define IDS_SETTINGS_PASSWORDS_NOTE 5451
#define IDS_SETTINGS_PASSWORDS_NO_NOTE_ADDED 5452
#define IDS_SETTINGS_PASSWORDS_NOTE_CHARACTER_COUNT 5453
#define IDS_SETTINGS_PASSWORDS_NOTE_CHARACTER_COUNT_WARNING 5454
#define IDS_SETTINGS_ADDRESS_NONE 5455
#define IDS_SETTINGS_PAYMENT_METHODS_NONE 5456
#define IDS_SETTINGS_PASSWORDS_NONE 5457
#define IDS_SETTINGS_PASSWORDS_EXCEPTIONS_NONE 5458
#define IDS_SETTINGS_PASSWORD_UNDO 5459
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD 5460
#define IDS_SETTINGS_PASSWORD_STORED_ON_DEVICE 5461
#define IDS_SETTINGS_PASSWORD_STORED_IN_ACCOUNT 5462
#define IDS_SETTINGS_PASSWORD_STORED_IN_ACCOUNT_AND_ON_DEVICE 5463
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD_FROM_ACCOUNT 5464
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD_FROM_DEVICE 5465
#define IDS_SETTINGS_PASSWORD_DELETED_PASSWORD_FROM_ACCOUNT_AND_DEVICE 5466
#define IDS_SETTINGS_PASSWORD_COPIED_TO_CLIPBOARD 5467
#define IDS_SETTINGS_PASSWORD_USERNAME_COPIED_TO_CLIPBOARD 5468
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT 5469
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_COUNT 5470
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_DIALOG_BODY_TEXT 5471
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_DIALOG_TITLE 5472
#define IDS_SETTINGS_PASSWORD_MOVE_PASSWORDS_TO_ACCOUNT_SNACKBAR 5473
#define IDS_SETTINGS_PASSWORD_MOVE_TO_ACCOUNT_DIALOG_TITLE 5474
#define IDS_SETTINGS_PASSWORD_MOVE_TO_ACCOUNT_DIALOG_BODY 5475
#define IDS_SETTINGS_PASSWORD_MOVE_MULTIPLE_PASSWORDS_TO_ACCOUNT_DIALOG_MOVE_BUTTON_TEXT 5476
#define IDS_SETTINGS_PASSWORD_MOVE_MULTIPLE_PASSWORDS_TO_ACCOUNT_DIALOG_CANCEL_BUTTON_TEXT 5477
#define IDS_SETTINGS_PASSWORD_MOVE_TO_ACCOUNT_DIALOG_MOVE_BUTTON_TEXT 5478
#define IDS_SETTINGS_PASSWORD_MOVE_TO_ACCOUNT_DIALOG_CANCEL_BUTTON_TEXT 5479
#define IDS_SETTINGS_PASSWORD_OPEN_MOVE_MULTIPLE_PASSWORDS_TO_ACCOUNT_DIALOG_BUTTON_TEXT 5480
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_TITLE 5481
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_BODY 5482
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_REMOVE_BUTTON_TEXT 5483
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_CANCEL_BUTTON_TEXT 5484
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_FROM_ACCOUNT_CHECKBOX_LABEL 5485
#define IDS_SETTINGS_PASSWORD_REMOVE_DIALOG_FROM_DEVICE_CHECKBOX_LABEL 5486
#define IDS_SETTINGS_DEVICE_PASSWORDS_LINK_LABEL 5487
#define IDS_SETTINGS_PASSWORDS_MANAGE_PASSWORDS 5488
#define IDS_SETTINGS_PASSWORDS_MANAGE_PASSWORDS_PLAINTEXT 5489
#define IDS_SETTINGS_PASSWORDS_OPT_IN_ACCOUNT_STORAGE_BODY 5490
#define IDS_SETTINGS_PASSWORDS_OPT_IN_ACCOUNT_STORAGE_LABEL 5491
#define IDS_SETTINGS_PASSWORDS_OPT_OUT_ACCOUNT_STORAGE_BODY 5492
#define IDS_SETTINGS_PASSWORDS_OPT_OUT_ACCOUNT_STORAGE_LABEL 5493
#define IDS_SETTINGS_PASSWORDS_IMPORT_MENU_ITEM 5494
#define IDS_SETTINGS_PASSWORDS_IMPORT_TITLE 5495
#define IDS_SETTINGS_PASSWORDS_IMPORT_CHOOSE_FILE 5496
#define IDS_SETTINGS_PASSWORDS_IMPORT_DESCRIPTION_GENERIC 5497
#define IDS_SETTINGS_PASSWORDS_EXPORT_MENU_ITEM 5498
#define IDS_SETTINGS_PASSWORDS_EXPORT_TITLE 5499
#define IDS_SETTINGS_PASSWORDS_EXPORT_DESCRIPTION 5500
#define IDS_SETTINGS_PASSWORDS_EXPORT 5501
#define IDS_SETTINGS_PASSWORDS_EXPORT_TRY_AGAIN 5502
#define IDS_SETTINGS_PASSWORDS_EXPORTING_TITLE 5503
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TITLE 5504
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TIPS 5505
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TIP_ENOUGH_SPACE 5506
#define IDS_SETTINGS_PASSWORDS_EXPORTING_FAILURE_TIP_ANOTHER_FOLDER 5507
#define IDS_SETTINGS_PASSWORD_ROW_MORE_ACTIONS 5508
#define IDS_SETTINGS_PASSWORD_ROW_FEDERATED_MORE_ACTIONS 5509
#define IDS_SETTINGS_PASSWORD_ROW_PASSWORD_DETAIL_PAGE 5510
#define IDS_SETTINGS_TRUSTED_VAULT_BANNER_LABEL 5511
#define IDS_SETTINGS_TRUSTED_VAULT_BANNER_SUB_LABEL_OFFER_OPT_IN 5512
#define IDS_SETTINGS_TRUSTED_VAULT_BANNER_SUB_LABEL_OPTED_IN 5513
#define IDS_SETTINGS_PASSWORD_SHOW_PASSWORD_A11Y 5514
#define IDS_SETTINGS_PASSWORD_HIDE_PASSWORD_A11Y 5515
#define IDS_SETTINGS_DEFAULT_BROWSER 5516
#define IDS_SETTINGS_DEFAULT_BROWSER_MAKE_DEFAULT_BUTTON 5517
#define IDS_SETTINGS_CLEAR_PERIOD_TITLE 5592
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC 5593
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_ERROR 5594
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PASSPHRASE_ERROR 5595
#define IDS_SETTINGS_CLEAR_BROWSING_DATA_WITH_SYNC_PAUSED 5596
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY 5597
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC 5598
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_WITH_EXCEPTION 5599
#define IDS_SETTINGS_CLEAR_COOKIES_AND_SITE_DATA_SUMMARY_BASIC_MAIN_PROFILE 5600
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY 5601
#define IDS_SETTINGS_CLEAR_BROWSING_HISTORY_SUMMARY_SIGNED_IN_NO_LINK 5602
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_GOOGLE_DSE 5603
#define IDS_SETTINGS_CLEAR_GOOGLE_SEARCH_HISTORY_NON_GOOGLE_DSE 5604
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_PREPOPULATED_DSE 5605
#define IDS_SETTINGS_CLEAR_NON_GOOGLE_SEARCH_HISTORY_NON_PREPOPULATED_DSE 5606
#define IDS_SETTINGS_CLEAR_DOWNLOAD_HISTORY 5607
#define IDS_SETTINGS_CLEAR_CACHE 5608
#define IDS_SETTINGS_CLEAR_COOKIES 5609
#define IDS_SETTINGS_CLEAR_PASSWORDS 5610
#define IDS_SETTINGS_CLEAR_FORM_DATA 5611
#define IDS_SETTINGS_CLEAR_HOSTED_APP_DATA 5612
#define IDS_SETTINGS_CLEAR_PERIOD_HOUR 5613
#define IDS_SETTINGS_CLEAR_PERIOD_24_HOURS 5614
#define IDS_SETTINGS_CLEAR_PERIOD_7_DAYS 5615
#define IDS_SETTINGS_CLEAR_PERIOD_FOUR_WEEKS 5616
#define IDS_SETTINGS_CLEAR_PERIOD_EVERYTHING 5617
#define IDS_SETTINGS_CLEAR_INSTALLED_APPS_DATA_TITLE 5618
#define IDS_SETTINGS_CLEAR_INSTALLED_APPS_DATA_CONFIRM 5619
#define IDS_SETTINGS_NOTIFICATION_WARNING 5620
#define IDS_SETTINGS_DOWNLOADS 5621
#define IDS_SETTINGS_DOWNLOAD_LOCATION 5622
#define IDS_SETTINGS_CHANGE_DOWNLOAD_LOCATION 5623
#define IDS_SETTINGS_PROMPT_FOR_DOWNLOAD 5624
#define IDS_SETTINGS_OPEN_FILE_TYPES_AUTOMATICALLY 5625
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_TITLE 5626
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_LEARN_MORE 5627
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_UNLINKED_MESSAGE 5628
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_SIGN_IN_BUTTON 5629
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_LINKED_MESSAGE 5630
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_SIGN_OUT_BUTTON 5631
#define IDS_SETTINGS_DOWNLOAD_CONNECTION_ACCOUNT_TITLE 5632
#define IDS_SETTINGS_DOWNLOAD_WEB_DRIVE_LOCATION 5633
#define IDS_SETTINGS_DOWNLOAD_LOCAL_LOCATION 5634
#define IDS_SETTINGS_ON_STARTUP 5635
#define IDS_SETTINGS_ON_STARTUP_OPEN_NEW_TAB 5636
#define IDS_SETTINGS_ON_STARTUP_CONTINUE 5637
#define IDS_SETTINGS_ON_STARTUP_OPEN_SPECIFIC 5638
#define IDS_SETTINGS_ON_STARTUP_CONTINUE_AND_OPEN_SPECIFIC 5639
#define IDS_SETTINGS_ON_STARTUP_USE_CURRENT 5640
#define IDS_SETTINGS_ON_STARTUP_ADD_NEW_PAGE 5641
#define IDS_SETTINGS_ON_STARTUP_EDIT_PAGE 5642
#define IDS_SETTINGS_ON_STARTUP_SITE_URL 5643
#define IDS_SETTINGS_ON_STARTUP_REMOVE 5644
#define IDS_SETTINGS_ON_STARTUP_PAGE_TOOLTIP 5645
#define IDS_SETTINGS_INVALID_URL 5646
#define IDS_SETTINGS_URL_TOOL_LONG 5647
#define IDS_SETTINGS_LANGUAGES_PAGE_TITLE 5648
#define IDS_SETTINGS_LANGUAGES_CARD_TITLE 5649
#define IDS_SETTINGS_LANGUAGE_SEARCH 5650
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_TO_TOP 5651
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_UP 5652
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_MOVE_DOWN 5653
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_LIST_REMOVE 5654
#define IDS_SETTINGS_LANGUAGES_LANGUAGES_ADD 5655
#define IDS_SETTINGS_LANGUAGES_MANAGE_LANGUAGES_TITLE 5656
#define IDS_SETTINGS_LANGUAGES_EXPAND_ACCESSIBILITY_LABEL 5657
#define IDS_SETTINGS_LANGUAGES_BROWSER_LANGUAGES_LIST_ORDERING_INSTRUCTIONS 5658
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_TRANSLATE_IN_THIS_LANGUAGE 5659
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_TRANSLATE 5660
#define IDS_SETTINGS_LANGUAGES_TRANSLATE_TARGET 5661
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_TITLE 5662
#define IDS_SETTINGS_LANGUAGES_MANAGED_DIALOG_BODY 5663
#define IDS_SETTINGS_LANGUAGES_NO_LANGUAGES_ADDED 5664
#define IDS_SETTINGS_LANGUAGES_AUTOMATIC_TRANSLATE 5665
#define IDS_SETTINGS_LANGUAGES_NEVER_LANGUAGES 5666
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_TITLE 5667
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_BASIC_LABEL 5668
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_LABEL 5669
#define IDS_SETTINGS_LANGUAGES_SPELL_CHECK_ENHANCED_DESCRIPTION 5670
#define IDS_SETTINGS_LANGUAGES_OFFER_TO_ENABLE_SPELL_CHECK 5671
#define IDS_SETTINGS_PRIVACY 5687
#define IDS_SETTINGS_PRIVACY_V2 5688
#define IDS_SETTINGS_PRIVACY_MORE 5689
#define IDS_SETTINGS_PRIVACY_SANDBOX_TITLE 5691
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_HEADING 5692
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_EXPLANATION1_PHASE2 5693
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_EXPLANATION2_PHASE2 5694
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_SETTING_TITLE 5695
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_SETTING_EXPLANATION1_PHASE2 5696
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_SETTING_EXPLANATION2_PHASE2 5697
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_SETTING_EXPLANATION3_PHASE2 5698
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_DETAILS 5699
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_ENABLED 5700
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_DISABLED 5701
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_FLOC_HEADING 5702
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_FLOC_EXPLANATION 5703
#define IDS_SETTINGS_PRIVACY_SANDBOX_FLOC_TRIAL_ACTIVE 5704
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_FLOC_STATUS 5705
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_FLOC_COHORT 5706
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_FLOC_COHORT_NEXT_UPDATE 5707
#define IDS_SETTINGS_PRIVACY_SANDBOX_PAGE_FLOC_RESET_COHORT 5708
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG 5709
#define IDS_SETTINGS_PRIVACY_SANDBOX_COOKIES_DIALOG_MORE 5710
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_TITLE 5711
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_SUMMARY 5712
#define IDS_SETTINGS_PRIVACY_SANDBOX_TRIALS_SUMMARY_LEARN_MORE 5713
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_TITLE 5714
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_SUMMARY 5715
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_TITLE 5716
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_SUMMARY 5717
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_TITLE 5718
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_SUMMARY 5719
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_TITLE 5720
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_TITLE 5721
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_DATA_TYPES 5722
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_DATA_USAGE 5723
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_DATA_MANAGEMENT 5724
#define IDS_SETTINGS_PRIVACY_SANDBOX_LEARN_MORE_DIALOG_FLEDGE_DATA_MANAGEMENT 5725
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TITLE 5726
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_REMOVED_DIALOG_TITLE 5727
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_REMOVED_DIALOG_DESCRIPTION 5728
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_TOPICS_EMPTY 5729
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_TOPICS_LABEL 5730
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_TOPICS_EMPTY 5731
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_TITLE 5732
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_EMPTY 5733
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_FLEDGE_LABEL 5734
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_REMOVED_FLEDGE_EMPTY 5735
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_2 5736
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_PERSONALIZATION_DIALOG_FLEDGE_LEARN_MORE_3 5737
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_TITLE 5738
#define IDS_SETTINGS_PRIVACY_SANDBOX_AD_MEASUREMENT_DIALOG_CONTROL_MEASUREMENT 5739
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_TITLE 5740
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_1 5741
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_1_TRIALS_OFF 5742
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_2 5743
#define IDS_SETTINGS_PRIVACY_SANDBOX_SPAM_AND_FRAUD_DIALOG_DESCRIPTION_3 5744
#define IDS_SETTINGS_PRIVACY_GUIDE_LABEL 5745
#define IDS_SETTINGS_PRIVACY_GUIDE_SUBLABEL 5746
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_HEADER 5747
#define IDS_SETTINGS_PRIVACY_GUIDE_PROMO_START_BUTTON 5748
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_LABEL 5749
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_TO_SETTINGS_ARIA_ROLE_DESC 5750
#define IDS_SETTINGS_PRIVACY_GUIDE_BACK_BUTTON 5751
#define IDS_SETTINGS_PRIVACY_GUIDE_STEPS 5752
#define IDS_SETTINGS_PRIVACY_GUIDE_NEXT_BUTTON 5753
#define IDS_SETTINGS_PRIVACY_GUIDE_FEATURE_DESCRIPTION_HEADER 5754
#define IDS_SETTINGS_PRIVACY_GUIDE_THINGS_TO_CONSIDER 5755
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_HEADER 5756
#define IDS_SETTINGS_PRIVACY_GUIDE_WELCOME_CARD_SUB_HEADER 5757
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_HEADER 5758
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER 5759
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_SUB_HEADER_NO_LINKS 5760
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_LEAVE_BUTTON 5761
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_PRIVACY_SANDBOX_LABEL 5762
#define IDS_SETTINGS_PRIVACY_GUIDE_COMPLETION_CARD_WAA_LABEL 5763
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_CARD_HEADER 5764
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION1 5765
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_FEATURE_DESCRIPTION2 5766
#define IDS_SETTINGS_PRIVACY_GUIDE_MSBB_PRIVACY_DESCRIPTION1 5767
#define IDS_SETTINGS_PRIVACY_GUIDE_CLEAR_ON_EXIT_CARD_HEADER 5768
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_CARD_HEADER 5769
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_SETTING_LABEL 5770
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION1 5771
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_FEATURE_DESCRIPTION2 5772
#define IDS_SETTINGS_PRIVACY_GUIDE_HISTORY_SYNC_PRIVACY_DESCRIPTION1 5773
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_HEADER 5774
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_SUBHEADER 5775
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION1 5776
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_FEATURE_DESCRIPTION2 5777
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION1 5778
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_INCOGNITO_PRIVACY_DESCRIPTION2 5779
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_SUBHEADER 5780
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION1 5781
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_FEATURE_DESCRIPTION2 5782
#define IDS_SETTINGS_PRIVACY_GUIDE_COOKIES_CARD_BLOCK_TPC_PRIVACY_DESCRIPTION1 5783
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_HEADER 5784
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION1 5785
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION2 5786
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_ENHANCED_PROTECTION_PRIVACY_DESCRIPTION3 5787
#define IDS_SETTINGS_PRIVACY_GUIDE_SAFE_BROWSING_CARD_STANDARD_PROTECTION_FEATURE_DESCRIPTION1 5788
#define IDS_SETTINGS_SAFETY_CHECK_SECTION_TITLE 5789
#define IDS_SETTINGS_SAFETY_CHECK_RUNNING 5790
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER 5791
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_MINS 5792
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_HOURS 5793
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_TIME 5794
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_TODAY 5795
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_YESTERDAY 5796
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_DAYS 5797
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_PRIMARY_LABEL_AFTER_DATE 5798
#define IDS_SETTINGS_SAFETY_CHECK_ARIA_LIVE_RUNNING 5799
#define IDS_SETTINGS_SAFETY_CHECK_ARIA_LIVE_AFTER 5800
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_BUTTON 5801
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_BUTTON_ARIA_LABEL 5802
#define IDS_SETTINGS_SAFETY_CHECK_PARENT_RUN_AGAIN_BUTTON_ARIA_LABEL 5803
#define IDS_SETTINGS_SAFETY_CHECK_ICON_RUNNING_ARIA_LABEL 5804
#define IDS_SETTINGS_SAFETY_CHECK_ICON_SAFE_ARIA_LABEL 5805
#define IDS_SETTINGS_SAFETY_CHECK_ICON_INFO_ARIA_LABEL 5806
#define IDS_SETTINGS_SAFETY_CHECK_ICON_WARNING_ARIA_LABEL 5807
#define IDS_SETTINGS_SAFETY_CHECK_REVIEW 5808
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_PRIMARY_LABEL 5809
#define IDS_SETTINGS_SAFETY_CHECK_UPDATES_DISABLED_BY_ADMIN 5810
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_PRIMARY_LABEL 5811
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_FEATURE_UNAVAILABLE 5812
#define IDS_SETTINGS_SAFETY_CHECK_PASSWORDS_BUTTON_ARIA_LABEL 5813
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED 5814
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD 5815
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_STANDARD_AVAILABLE_ENHANCED 5816
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_ENABLED_ENHANCED 5817
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED_BY_ADMIN 5818
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_DISABLED_BY_EXTENSION 5819
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_BUTTON 5820
#define IDS_SETTINGS_SAFETY_CHECK_SAFE_BROWSING_BUTTON_ARIA_LABEL 5821
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_PRIMARY_LABEL 5822
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_SAFE 5823
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_OFF 5824
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_USER 5825
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BLOCKLISTED_ON_ADMIN 5826
#define IDS_SETTINGS_SAFETY_CHECK_EXTENSIONS_BUTTON_ARIA_LABEL 5827
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_LABEL 5841
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC 5842
#define IDS_SETTINGS_NETWORK_PREDICTION_ENABLED_DESC_COOKIES_PAGE 5843
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION 5844
#define IDS_SETTINGS_SAFEBROWSING_ENABLEPROTECTION_DESC 5845
#define IDS_SETTINGS_SAFEBROWSING_ENABLE_REPORTING_DESC 5846
#define IDS_SETTINGS_SAFEBROWSING_SECTION_LABEL 5847
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED 5848
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_DESC 5849
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_EXPAND_ACCESSIBILITY_LABEL 5850
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_ONE 5851
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_THREE 5852
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FOUR 5853
#define IDS_SETTINGS_SAFEBROWSING_ENHANCED_BULLET_FIVE 5854
#define IDS_SETTINGS_SAFEBROWSING_STANDARD 5855
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_DESC 5856
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_EXPAND_ACCESSIBILITY_LABEL 5857
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_BULLET_ONE 5858
#define IDS_SETTINGS_SAFEBROWSING_STANDARD_HELP_IMPROVE 5859
#define IDS_SETTINGS_SAFEBROWSING_NONE 5860
#define IDS_SETTINGS_SAFEBROWSING_NONE_DESC 5861
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_TITLE 5862
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_DESC 5863
#define IDS_SETTINGS_SAFEBROWSING_DISABLE_DIALOG_CONFIRM 5864
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK 5865
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TITLE 5866
#define IDS_SETTINGS_ENABLE_DO_NOT_TRACK_DIALOG_TEXT 5867
#define IDS_SETTINGS_PERMISSIONS 5868
#define IDS_SETTINGS_PERMISSIONS_DESCRIPTION 5869
#define IDS_SETTINGS_SECURITY 5870
#define IDS_SETTINGS_SECURITY_DESCRIPTION 5871
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM 5872
#define IDS_SETTINGS_ADVANCED_PROTECTION_PROGRAM_DESC 5873
#define IDS_SETTINGS_HTTPS_ONLY_MODE 5874
#define IDS_SETTINGS_HTTPS_ONLY_MODE_DESCRIPTION 5875
#define IDS_SETTINGS_MANAGE_CERTIFICATES 5876
#define IDS_SETTINGS_MANAGE_CERTIFICATES_DESCRIPTION 5877
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES 5878
#define IDS_SETTINGS_MANAGE_DEVICE_CERTIFICATES_DESCRIPTION 5879
#define IDS_SETTINGS_MANAGE 5880
#define IDS_SETTINGS_SECURE_DNS 5881
#define IDS_SETTINGS_SECURE_DNS_DESCRIPTION 5882
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION 5883
#define IDS_SETTINGS_AUTOMATIC_MODE_DESCRIPTION_SECONDARY 5884
#define IDS_SETTINGS_SECURE_MODE_DESCRIPTION_ACCESSIBILITY_LABEL 5885
#define IDS_SETTINGS_SECURE_DNS_DROPDOWN_ACCESSIBILITY_LABEL 5886
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_DESCRIPTION 5887
#define IDS_SETTINGS_SECURE_DROPDOWN_MODE_PRIVACY_POLICY 5888
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_MANAGED_ENVIRONMENT 5889
#define IDS_SETTINGS_SECURE_DNS_DISABLED_FOR_PARENTAL_CONTROL 5890
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_PLACEHOLDER 5891
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_FORMAT_ERROR 5892
#define IDS_SETTINGS_SECURE_DNS_CUSTOM_CONNECTION_ERROR 5893
#define IDS_SETTINGS_CONTENT_SETTINGS 5894
#define IDS_SETTINGS_SITE_SETTINGS 5895
#define IDS_SETTINGS_SITE_SETTINGS_DESCRIPTION 5896
#define IDS_SETTINGS_CLEAR_DATA 5897
#define IDS_SETTINGS_CLEARING_DATA 5898
#define IDS_SETTINGS_CLEARED_DATA 5899
#define IDS_SETTINGS_CLEAR_BROWSING_DATA 5900
#define IDS_SETTINGS_CLEAR_DATA_DESCRIPTION 5901
#define IDS_SETTINGS_TITLE_AND_COUNT 5902
#define IDS_SETTINGS_SYNC_AND_GOOGLE_SERVICES_PRIVACY_DESC_UNIFIED_CONSENT 5903
#define IDS_SETTINGS_RECENT_PERMISSIONS_NO_CHANGES 5904
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_ONE_ITEM 5905
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_TWO_ITEMS 5906
#define IDS_SETTINGS_RECENT_PERMISSIONS_ALLOWED_MORE_THAN_TWO_ITEMS 5907
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_ONE_ITEM 5908
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_TWO_ITEMS 5909
#define IDS_SETTINGS_RECENT_PERMISSIONS_AUTOMATICALLY_BLOCKED_MORE_THAN_TWO_ITEMS 5910
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_ONE_ITEM 5911
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_TWO_ITEMS 5912
#define IDS_SETTINGS_RECENT_PERMISSIONS_BLOCKED_MORE_THAN_TWO_ITEMS 5913
#define IDS_SETTINGS_RESET_PROMPT_TITLE 5914
#define IDS_SETTINGS_RESET 5915
#define IDS_SETTINGS_RESET_SETTINGS_TRIGGER 5916
#define IDS_SETTINGS_RESET_AUTOMATED_DIALOG_TITLE 5917
#define IDS_SETTINGS_RESET_BANNER_TEXT 5918
#define IDS_SETTINGS_RESET_BANNER_RESET_BUTTON_TEXT 5919
#define IDS_SETTINGS_SEARCH 5922
#define IDS_SETTINGS_SEARCH_EXPLANATION 5923
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES 5924
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 5925
#define IDS_SETTINGS_SEARCH_MANAGE_SEARCH_ENGINES_EXPLANATION 5926
#define IDS_SETTINGS_SEARCH_ENGINES 5927
#define IDS_SETTINGS_SEARCH_ENGINES_PAGE_EXPLANATION 5928
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH 5929
#define IDS_SETTINGS_SEARCH_ENGINES_ADD_SEARCH_ENGINE 5930
#define IDS_SETTINGS_SEARCH_ENGINES_EDIT_SEARCH_ENGINE 5931
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_TITLE 5932
#define IDS_SETTINGS_SEARCH_ENGINES_DELETE_CONFIRMATION_DESCRIPTION 5933
#define IDS_SETTINGS_SEARCH_ENGINES_DEFAULT_ENGINES 5934
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES 5935
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINES_EXPLANATION 5936
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH 5937
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION 5938
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_SEARCH_EXPLANATION_STARTER_PACK 5939
#define IDS_SETTINGS_SEARCH_ENGINES_NO_SITES_ADDED 5940
#define IDS_SETTINGS_SEARCH_ENGINES_INACTIVE_SHORTCUTS 5941
#define IDS_SETTINGS_SEARCH_ENGINES_NO_INACTIVE_SHORTCUTS 5942
#define IDS_SETTINGS_SEARCH_ENGINES_OTHER_ENGINES 5943
#define IDS_SETTINGS_SEARCH_ENGINES_NO_OTHER_ENGINES 5944
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES 5945
#define IDS_SETTINGS_SEARCH_ENGINES_EXTENSION_ENGINES_EXPLANATION 5946
#define IDS_SETTINGS_SEARCH_ENGINES_SEARCH_ENGINE 5947
#define IDS_SETTINGS_SEARCH_ENGINES_SITE_OR_PAGE 5948
#define IDS_SETTINGS_SEARCH_ENGINES_INACTIVE_SITE 5949
#define IDS_SETTINGS_SEARCH_ENGINES_KEYWORD 5950
#define IDS_SETTINGS_SEARCH_ENGINES_SHORTCUT 5951
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL 5952
#define IDS_SETTINGS_SEARCH_ENGINES_QUERY_URL_EXPLANATION 5953
#define IDS_SETTINGS_SEARCH_ENGINES_MAKE_DEFAULT 5954
#define IDS_SETTINGS_SEARCH_ENGINES_ACTIVATE 5955
#define IDS_SETTINGS_SEARCH_ENGINES_DEACTIVATE 5956
#define IDS_SETTINGS_SEARCH_ENGINES_REMOVE_FROM_LIST 5957
#define IDS_SETTINGS_SEARCH_ENGINES_MANAGE_EXTENSION 5958
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TITLE 5959
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION 5960
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_DESCRIPTION_STARTER_PACK 5961
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_SPACE_OR_TAB 5962
#define IDS_SETTINGS_SEARCH_ENGINES_KEYBOARD_SHORTCUTS_TAB 5963
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_SITES 5964
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_INACTIVE_SITES 5965
#define IDS_SETTINGS_SEARCH_ENGINES_ADDITIONAL_EXTENSIONS 5966
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_HOST 5967
#define IDS_SETTINGS_EXCEPTIONS_EMBEDDED_ON_ANY_HOST 5968
#define IDS_SETTINGS_SITE_SETTINGS_CATEGORY 5969
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES 5970
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_DESCRIPTION 5971
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SEARCH 5972
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT 5973
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_MOST_VISITED 5974
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_STORAGE 5975
#define IDS_SETTINGS_SITE_SETTINGS_ALL_SITES_SORT_METHOD_NAME 5976
#define IDS_SETTINGS_SITE_SETTINGS_SITE_ENTRY_PARTITIONED_LABEL 5977
#define IDS_SETTINGS_SITE_SETTINGS_SITE_REPRESENTATION_SEPARATOR 5978
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR 5979
#define IDS_SETTINGS_SITE_SETTINGS_DEFAULT_BEHAVIOR_DESCRIPTION 5980
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS 5981
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION 5982
#define IDS_SETTINGS_SITE_SETTINGS_CUSTOMIZED_BEHAVIORS_DESCRIPTION_SHORT 5983
#define IDS_SETTINGS_SITE_SETTINGS_ADS_DESCRIPTION 5984
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED 5985
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED 5986
#define IDS_SETTINGS_SITE_SETTINGS_ADS_ALLOWED_EXCEPTIONS 5987
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCKED_EXCEPTIONS 5988
#define IDS_SETTINGS_SITE_SETTINGS_AR_DESCRIPTION 5989
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED 5990
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED 5991
#define IDS_SETTINGS_SITE_SETTINGS_AR_ALLOWED_EXCEPTIONS 5992
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCKED_EXCEPTIONS 5993
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_DESCRIPTION 5994
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED 5995
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED 5996
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_ALLOWED_EXCEPTIONS 5997
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOADS_BLOCKED_EXCEPTIONS 5998
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_DESCRIPTION 5999
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED 6000
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED 6001
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_SUB_LABEL 6002
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_ALLOWED_EXCEPTIONS 6003
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCKED_EXCEPTIONS 6004
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_DESCRIPTION 6005
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_ALLOWED 6006
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_BLOCKED 6007
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_DESCRIPTION 6008
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED 6009
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED 6010
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_SUB_LABEL 6011
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_ALLOWED_EXCEPTIONS 6012
#define IDS_SETTINGS_SITE_SETTINGS_CAMERA_BLOCKED_EXCEPTIONS 6013
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_DESCRIPTION 6014
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED 6015
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED 6016
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ALLOWED_EXCEPTIONS 6017
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCKED_EXCEPTIONS 6018
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_DESCRIPTION 6019
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED 6020
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED 6021
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_ALLOWED_EXCEPTIONS 6022
#define IDS_SETTINGS_SITE_SETTINGS_DEVICE_USE_BLOCKED_EXCEPTIONS 6023
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_DESCRIPTION 6024
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED 6025
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED 6026
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_ALLOWED_EXCEPTIONS 6027
#define IDS_SETTINGS_SITE_SETTINGS_FEDERATED_IDENTITY_API_BLOCKED_EXCEPTIONS 6028
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_DESCRIPTION 6029
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_ALLOWED 6030
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED 6031
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_WRITE_BLOCKED_EXCEPTIONS 6032
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_DESCRIPTION 6033
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED 6034
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED 6035
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_ALLOWED_EXCEPTIONS 6036
#define IDS_SETTINGS_SITE_SETTINGS_FONTS_BLOCKED_EXCEPTIONS 6037
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_DESCRIPTION 6038
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ALLOWED 6039
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCKED 6040
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_DESCRIPTION 6041
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED 6042
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED 6043
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_SUB_LABEL 6044
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_ALLOWED_EXCEPTIONS 6045
#define IDS_SETTINGS_SITE_SETTINGS_IMAGES_BLOCKED_EXCEPTIONS 6046
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_DESCRIPTION 6047
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_ALLOWED_EXCEPTIONS 6048
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCKED_EXCEPTIONS 6049
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_DESCRIPTION 6050
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED 6051
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED 6052
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_ALLOWED_EXCEPTIONS 6053
#define IDS_SETTINGS_SITE_SETTINGS_JAVASCRIPT_BLOCKED_EXCEPTIONS 6054
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_DESCRIPTION 6055
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED 6056
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED 6057
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_SUB_LABEL 6058
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_ALLOWED_EXCEPTIONS 6059
#define IDS_SETTINGS_SITE_SETTINGS_LOCATION_BLOCKED_EXCEPTIONS 6060
#define IDS_SETTINGS_SITE_SETTINGS_MIC_DESCRIPTION 6061
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED 6062
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED 6063
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_SUB_LABEL 6064
#define IDS_SETTINGS_SITE_SETTINGS_MIC_ALLOWED_EXCEPTIONS 6065
#define IDS_SETTINGS_SITE_SETTINGS_MIC_BLOCKED_EXCEPTIONS 6066
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_DESCRIPTION 6067
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED 6068
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED 6069
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_ALLOWED_EXCEPTIONS 6070
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_BLOCKED_EXCEPTIONS 6071
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_DESCRIPTION 6072
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED 6073
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED 6074
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_SUB_LABEL 6075
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_ALLOWED_EXCEPTIONS 6076
#define IDS_SETTINGS_SITE_SETTINGS_MOTION_SENSORS_BLOCKED_EXCEPTIONS 6077
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_DESCRIPTION 6078
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED 6079
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL 6080
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_PARTIAL_SUB_LABEL 6081
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED 6082
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_SUB_LABEL 6083
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ALLOWED_EXCEPTIONS 6084
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCKED_EXCEPTIONS 6085
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_DESCRIPTION 6086
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED 6087
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED 6088
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_ALLOWED_EXCEPTIONS 6089
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLERS_BLOCKED_EXCEPTIONS 6090
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_DESCRIPTION 6091
#define IDS_SETTINGS_SITE_SETTINGS_PDFS_ALLOWED 6092
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_DESCRIPTION 6093
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED 6094
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED 6095
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_ALLOWED_EXCEPTIONS 6096
#define IDS_SETTINGS_SITE_SETTINGS_POPUPS_BLOCKED_EXCEPTIONS 6097
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_ENABLE 6098
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_DESCRIPTION 6099
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_ALLOWED 6100
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED 6101
#define IDS_SETTINGS_SITE_SETTINGS_PROTECTED_CONTENT_BLOCKED_SUB_LABEL 6102
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_DESCRIPTION 6111
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_ALLOWED 6112
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED 6113
#define IDS_SETTINGS_SITE_SETTINGS_PROTOCOL_HANDLERS_BLOCKED_EXCEPTIONS 6114
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_DESCRIPTION 6115
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ALLOWED 6116
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_BLOCKED 6117
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_DESCRIPTION 6118
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED 6119
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED 6120
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_SUB_LABEL 6121
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOWED_EXCEPTIONS 6122
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_BLOCKED_EXCEPTIONS 6123
#define IDS_SETTINGS_SITE_SETTINGS_USB_DESCRIPTION 6124
#define IDS_SETTINGS_SITE_SETTINGS_USB_ALLOWED 6125
#define IDS_SETTINGS_SITE_SETTINGS_USB_BLOCKED 6126
#define IDS_SETTINGS_SITE_SETTINGS_VR_DESCRIPTION 6127
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED 6128
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED 6129
#define IDS_SETTINGS_SITE_SETTINGS_VR_ALLOWED_EXCEPTIONS 6130
#define IDS_SETTINGS_SITE_SETTINGS_VR_BLOCKED_EXCEPTIONS 6131
#define IDS_SETTINGS_SITE_SETTINGS_ZOOM_LEVELS_DESCRIPTION 6132
#define IDS_SETTINGS_SITE_SETTINGS_AR_ASK 6133
#define IDS_SETTINGS_SITE_SETTINGS_AR_ASK_RECOMMENDED 6134
#define IDS_SETTINGS_SITE_SETTINGS_AR_BLOCK 6135
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ASK 6136
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_ASK_RECOMMENDED 6137
#define IDS_SETTINGS_SITE_SETTINGS_CLIPBOARD_BLOCK 6138
#define IDS_SETTINGS_COOKIES_PAGE 6139
#define IDS_SETTINGS_COOKIES_CONTROLS 6140
#define IDS_SETTINGS_COOKIES_ALLOW_ALL 6141
#define IDS_SETTINGS_COOKIES_ALLOW_ALL_EXPAND_A11Y_LABEL 6142
#define IDS_SETTINGS_COOKIES_ALLOW_ALL_BULLET_ONE 6143
#define IDS_SETTINGS_COOKIES_ALLOW_ALL_BULLET_TWO 6144
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO 6145
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_EXPAND_A11Y_LABEL 6146
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_ONE 6147
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO_BULLET_TWO 6148
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY 6149
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_EXPAND_A11Y_LABEL 6150
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_BULLET_ONE 6151
#define IDS_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_BULLET_TWO 6152
#define IDS_SETTINGS_COOKIES_BLOCK_ALL 6153
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_EXPAND_A11Y_LABEL 6154
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_BULLET_ONE 6155
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_BULLET_TWO 6156
#define IDS_SETTINGS_COOKIES_BLOCK_ALL_BULLET_THREE 6157
#define IDS_SETTINGS_COOKIES_CLEAR_ON_EXIT 6158
#define IDS_SETTINGS_COOKIES_ALL_SITES_LINK 6160
#define IDS_SETTINGS_COOKIES_SITE_SPECIFIC_EXCEPTIONS 6161
#define IDS_SETTINGS_COOKIES_ALLOW_EXCEPTIONS 6162
#define IDS_SETTINGS_COOKIES_SESSION_ONLY_EXCEPTIONS 6163
#define IDS_SETTINGS_COOKIES_BLOCK_EXCEPTIONS 6164
#define IDS_SETTINGS_SITE_SETTINGS_APP_PROTOCOL_HANDLERS 6165
#define IDS_SETTINGS_SITE_SETTINGS_APP_ALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 6166
#define IDS_SETTINGS_SITE_SETTINGS_APP_DISALLOWED_PROTOCOL_HANDLERS_DESCRIPTION 6167
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ASK 6168
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_ASK_RECOMMENDED 6169
#define IDS_SETTINGS_SITE_SETTINGS_HID_DEVICES_BLOCK 6170
#define IDS_SETTINGS_SITE_SETTINGS_INSECURE_CONTENT_BLOCK 6171
#define IDS_SETTINGS_SITE_SETTINGS_PAYMENT_HANDLER_ALLOW_RECOMMENDED 6172
#define IDS_SETTINGS_SITE_SETTINGS_PDF_DOWNLOAD_PDFS 6173
#define IDS_SETTINGS_SITE_SETTINGS_VR_ASK_RECOMMENDED 6174
#define IDS_SETTINGS_SITE_SETTINGS_RECENT_ACTIVITY 6175
#define IDS_SETTINGS_SITE_SETTINGS_MIDI_DEVICES_ASK_RECOMMENDED 6176
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_DEVICES_ASK_RECOMMENDED 6177
#define IDS_SETTINGS_SITE_SETTINGS_USB_DEVICES_ASK_RECOMMENDED 6178
#define IDS_SETTINGS_SITE_SETTINGS_SERIAL_PORTS_ASK_RECOMMENDED 6179
#define IDS_SETTINGS_SITE_SETTINGS_FILE_SYSTEM_ACCESS_WRITE_ASK_RECOMMENDED 6180
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_ZOOM_LEVEL 6181
#define IDS_SETTINGS_SITE_SETTINGS_MAY_SAVE_COOKIES 6182
#define IDS_SETTINGS_SITE_SETTINGS_ASK_FIRST 6183
#define IDS_SETTINGS_SITE_SETTINGS_ASK_FIRST_RECOMMENDED 6184
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_ACCESSING_RECOMMENDED 6185
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_SENDING 6186
#define IDS_SETTINGS_SITE_SETTINGS_ASK_BEFORE_SENDING_RECOMMENDED 6187
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATICALLY_BLOCKED_NOTIFICATIONS 6188
#define IDS_SETTINGS_SITE_SETTINGS_SHOW_BLOCKED_NOTIFICATIONS_INDICATOR 6189
#define IDS_SETTINGS_SITE_SETTINGS_ENABLE_QUIET_NOTIFICATION_PROMPTS 6190
#define IDS_SETTINGS_SITE_SETTINGS_ENABLE_QUIET_NOTIFICATION_PROMPTS_DESCRIPTION 6191
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_BLOCK 6192
#define IDS_SETTINGS_SITE_SETTINGS_NOTIFICATIONS_ASK 6193
#define IDS_SETTINGS_SITE_SETTINGS_SHOW_ALL_RECOMMENDED 6194
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW 6195
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK 6196
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY 6197
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_BLOCK_THIRD_PARTY_INCOGNITO 6198
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW_SITES 6199
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_ALLOW_SITES_RECOMMENDED 6200
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_RECENTLY_CLOSED_SITES_RECOMMENDED 6201
#define IDS_SETTINGS_SITE_SETTINGS_BACKGROUND_SYNC_BLOCK 6202
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_ASK_RECOMMENDED 6203
#define IDS_SETTINGS_SITE_SETTINGS_HANDLERS_BLOCKED 6204
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_RECOMMENDED 6205
#define IDS_SETTINGS_SITE_SETTINGS_SOUND_ALLOW_RECOMMENDED 6206
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DOWNLOAD_ASK_RECOMMENDED 6207
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_PLACEMENT_DESCRIPTION 6208
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_PLACEMENT_ASK 6209
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_PLACEMENT_BLOCKED 6210
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_PLACEMENT_ASK_EXCEPTIONS 6211
#define IDS_SETTINGS_SITE_SETTINGS_WINDOW_PLACEMENT_BLOCKED_EXCEPTIONS 6212
#define IDS_SETTINGS_SITE_SETTINGS_IDLE_DETECTION_BLOCK 6213
#define IDS_SETTINGS_SITE_SETTINGS_ALLOWED_RECOMMENDED 6214
#define IDS_SETTINGS_SITE_SETTINGS_BLOCKED 6215
#define IDS_SETTINGS_SITE_SETTINGS_BLOCKED_RECOMMENDED 6216
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW 6217
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK 6218
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_SOUND 6219
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY 6220
#define IDS_SETTINGS_SITE_SETTINGS_SITE_URL 6221
#define IDS_SETTINGS_SITE_SETTINGS_ASK_DEFAULT_MENU 6222
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_DEFAULT_MENU 6223
#define IDS_SETTINGS_SITE_SETTINGS_AUTOMATIC_DEFAULT_MENU 6224
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_DEFAULT_MENU 6225
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_DEFAULT_MENU 6226
#define IDS_SETTINGS_SITE_SETTINGS_ALLOW_MENU 6227
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_MENU 6228
#define IDS_SETTINGS_SITE_SETTINGS_ASK_MENU 6229
#define IDS_SETTINGS_SITE_SETTINGS_MUTE_MENU 6230
#define IDS_SETTINGS_SITE_SETTINGS_RESET_MENU 6231
#define IDS_SETTINGS_SITE_SETTINGS_SESSION_ONLY_MENU 6232
#define IDS_SETTINGS_SITE_SETTINGS_USAGE 6233
#define IDS_SETTINGS_SITE_SETTINGS_USAGE_NONE 6234
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS 6235
#define IDS_SETTINGS_SITE_SETTINGS_PERMISSIONS_MORE 6236
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT 6237
#define IDS_SETTINGS_SITE_SETTINGS_CONTENT_MORE 6238
#define IDS_SETTINGS_SITE_SETTINGS_ALLOWLISTED 6239
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_BLOCKLISTED_SINGULAR 6240
#define IDS_SETTINGS_SITE_SETTINGS_ADS_BLOCK_NOT_BLOCKLISTED_SINGULAR 6241
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_KILL_SWITCH 6242
#define IDS_SETTINGS_SITE_SETTINGS_SOURCE_INSECURE_ORIGIN 6243
#define IDS_SETTINGS_SITE_SETTINGS_RESET_BUTTON 6244
#define IDS_SETTINGS_SITE_SETTINGS_DELETE 6245
#define IDS_SETTINGS_SITE_SETTINGS_GROUP_RESET 6246
#define IDS_SETTINGS_SITE_SETTINGS_GROUP_DELETE 6247
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_HEADER 6248
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_LINK 6249
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE 6250
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_ALL 6251
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_ALL_SHOWN 6252
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_ALL_THIRD_PARTY 6253
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIE_REMOVE_DIALOG_TITLE 6254
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIE_REMOVE_CONFIRMATION 6255
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_THIRD_PARTY_COOKIES 6256
#define IDS_SETTINGS_SITE_SETTINGS_THIRD_PARTY_COOKIES_EXCEPTION_LABEL 6257
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_DIALOG_TITLE 6258
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_DIALOG_TITLE 6259
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_DESCRIPTION 6260
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_DESCRIPTION 6261
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_LABEL 6262
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_LABEL 6263
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_CONFIRMATION 6264
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_CONFIRMATION 6265
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_CONFIRMATION_INSTALLED 6266
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_CONFIRMATION_INSTALLED 6267
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_ALL_STORAGE_SIGN_OUT 6268
#define IDS_SETTINGS_SITE_SETTINGS_CLEAR_DISPLAYED_STORAGE_SIGN_OUT 6269
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_DIALOG_TITLE 6270
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_SUBPAGE 6271
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_CONFIRMATION 6272
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_DIALOG_TITLE 6273
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION 6274
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_CONFIRMATION_NEW 6275
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_SIGN_OUT 6276
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_OFFLINE_DATA 6277
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE_APPS 6278
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_RESET_DIALOG_TITLE 6279
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_RESET_CONFIRMATION 6280
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_DIALOG_TITLE 6281
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_CONFIRMATION 6282
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_CONFIRMATION_NEW 6283
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_CONFIRMATION_INSTALLED 6284
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_CONFIRMATION_INSTALLED_PLURAL 6285
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_SIGN_OUT 6286
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_OFFLINE_DATA 6287
#define IDS_SETTINGS_SITE_SETTINGS_SITE_GROUP_DELETE_APPS 6288
#define IDS_SETTINGS_SITE_SETTINGS_ORIGIN_DELETE_CONFIRMATION 6289
#define IDS_SETTINGS_SITE_SETTINGS_ORIGIN_DELETE_CONFIRMATION_INSTALLED 6290
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_MULTIPLE 6291
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_DIALOG_TITLE 6292
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_APP_DIALOG_TITLE 6293
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_PARTITIONED_DIALOG_TITLE 6294
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_DIALOG_TITLE 6295
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_DIALOG_TITLE 6296
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_APP_PLURAL_DIALOG_TITLE 6297
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_ORIGIN_LOGOUT 6298
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_GROUP_LOGOUT 6299
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_OFFLINE_DATA 6300
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_PERMISSIONS 6301
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE_SITE_CONFIRM 6302
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_REMOVE_SITE 6303
#define IDS_SETTINGS_SITE_SETTINGS_COOKIES_CLEAR_ALL 6304
#define IDS_SETTINGS_SITE_SETTINGS_SITE_RESET_ALL 6305
#define IDS_SETTINGS_SITE_SETTINGS_SITE_CLEAR_STORAGE 6306
#define IDS_SETTINGS_SITE_SETTINGS_COOKIE_SEARCH 6307
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_IS_DEFAULT 6308
#define IDS_SETTINGS_SITE_SETTINGS_HANDLER_SET_DEFAULT 6309
#define IDS_SETTINGS_SITE_SETTINGS_REMOVE 6310
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_ONLY 6311
#define IDS_SETTINGS_SITE_SETTINGS_INCOGNITO_SITE_EXCEPTION_DESC 6312
#define IDS_SETTINGS_SITE_SETTINGS_NO_ZOOMED_SITES 6313
#define IDS_SETTINGS_SITE_NO_SITES_ADDED 6314
#define IDS_SETTINGS_SITE_SETTINGS_BLOCK_AUTOPLAY 6315
#define IDS_SETTINGS_SITE_SETTINGS_EMPTY_ALL_SITES_PAGE 6316
#define IDS_SETTINGS_SITE_SETTINGS_NO_SITES_FOUND 6317
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ASK 6318
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_ASK_RECOMMENDED 6319
#define IDS_SETTINGS_SITE_SETTINGS_BLUETOOTH_SCANNING_BLOCK 6320
#define IDS_SETTINGS_NO_BLUETOOTH_DEVICES_FOUND 6321
#define IDS_SETTINGS_NO_USB_DEVICES_FOUND 6322
#define IDS_SETTINGS_NO_SERIAL_PORTS_FOUND 6323
#define IDS_SETTINGS_NO_HID_DEVICES_FOUND 6324
#define IDS_SETTINGS_ADD_SITE_TITLE 6325
#define IDS_SETTINGS_EDIT_SITE_TITLE 6326
#define IDS_SETTINGS_ADD_SITE 6327
#define IDS_SETTINGS_COOKIES_COOKIE_NAME_LABEL 6329
#define IDS_SETTINGS_COOKIES_COOKIE_CONTENT_LABEL 6330
#define IDS_SETTINGS_COOKIES_COOKIE_DOMAIN_LABEL 6331
#define IDS_SETTINGS_COOKIES_COOKIE_PATH_LABEL 6332
#define IDS_SETTINGS_COOKIES_COOKIE_SENDFOR_LABEL 6333
#define IDS_SETTINGS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_LABEL 6334
#define IDS_SETTINGS_COOKIES_COOKIE_CREATED_LABEL 6335
#define IDS_SETTINGS_COOKIES_COOKIE_EXPIRES_LABEL 6336
#define IDS_SETTINGS_COOKIES_FLASH_LSO 6337
#define IDS_SETTINGS_SITE_SETTINGS_NUM_COOKIES 6338
#define IDS_SETTINGS_COOKIES_LOCAL_STORAGE_ORIGIN_LABEL 6339
#define IDS_SETTINGS_COOKIES_LOCAL_STORAGE_SIZE_ON_DISK_LABEL 6340
#define IDS_SETTINGS_COOKIES_LOCAL_STORAGE_LAST_MODIFIED_LABEL 6341
#define IDS_SETTINGS_COOKIES_DATABASE_STORAGE 6342
#define IDS_SETTINGS_COOKIES_LOCAL_STORAGE 6343
#define IDS_SETTINGS_COOKIES_FILE_SYSTEM 6344
#define IDS_SETTINGS_COOKIES_FILE_SYSTEM_TEMPORARY_USAGE_LABEL 6345
#define IDS_SETTINGS_COOKIES_FILE_SYSTEM_PERSISTENT_USAGE_LABEL 6346
#define IDS_SETTINGS_COOKIES_SERVICE_WORKER 6347
#define IDS_SETTINGS_COOKIES_SHARED_WORKER 6348
#define IDS_SETTINGS_COOKIES_SHARED_WORKER_WORKER_LABEL 6349
#define IDS_SETTINGS_COOKIES_CACHE_STORAGE 6350
#define IDS_SETTINGS_COOKIES_QUOTA_STORAGE 6351
#define IDS_SETTINGS_PEOPLE 6352
#define IDS_SETTINGS_CHANGE_PICTURE_PROFILE_PHOTO 6353
#define IDS_SETTINGS_PEOPLE_SIGN_IN 6354
#define IDS_SETTINGS_SYNC_DISCONNECT_MANAGED_PROFILE_EXPLANATION 6355
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_TITLE 6356
#define IDS_SETTINGS_TURN_OFF_SYNC_AND_SIGN_OUT_DIALOG_TITLE 6357
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_MANAGED_CONFIRM 6358
#define IDS_SETTINGS_TURN_OFF_SYNC_DIALOG_CHECKBOX 6359
#define IDS_SETTINGS_SYNC_SETTINGS_SAVED_TOAST_LABEL 6360
#define IDS_SETTINGS_PROFILE_NAME_INPUT_LABEL 6361
#define IDS_SETTINGS_PROFILE_SHORTCUT_TOGGLE_LABEL 6362
#define IDS_SETTINGS_CUSTOMIZE_PROFILE 6363
#define IDS_SETTINGS_PICK_A_THEME_COLOR 6364
#define IDS_SETTINGS_PICK_AN_AVATAR 6365
#define IDS_SETTINGS_CREATE_SHORTCUT 6366
#define IDS_SETTINGS_CREATE_SHORTCUT_SUBTITLE 6367
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPLANATION 6368
#define IDS_SETTINGS_SYNC_DISCONNECT_MAIN_PROFILE_EXPLANATION 6369
#define IDS_SETTINGS_SYNC_DISCONNECT_AND_SIGN_OUT_EXPLANATION 6370
#define IDS_SETTINGS_SYNC_DISCONNECT_EXPAND_ACCESSIBILITY_LABEL 6371
#define IDS_SETTINGS_SYNC_WILL_START 6372
#define IDS_SETTINGS_MANAGE_GOOGLE_ACCOUNT 6373
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_LABEL 6374
#define IDS_SETTINGS_USER_EVENTS_CHECKBOX_TEXT 6375
#define IDS_SETTINGS_ENCRYPT_WITH_SYNC_PASSPHRASE_LABEL 6376
#define IDS_SETTINGS_PASSPHRASE_EXPLANATION_TEXT 6377
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_ENCRYPTION 6378
#define IDS_SETTINGS_PASSPHRASE_RESET_HINT_TOGGLE 6379
#define IDS_SETTINGS_PASSPHRASE_RECOVER 6380
#define IDS_SETTINGS_PERSONALIZE_GOOGLE_SERVICES_TITLE 6381
#define IDS_SETTINGS_IMPORT_SETTINGS_TITLE 6382
#define IDS_SETTINGS_IMPORT_FROM_LABEL 6383
#define IDS_SETTINGS_IMPORT_ITEMS_LABEL 6384
#define IDS_SETTINGS_IMPORT_LOADING_PROFILES 6385
#define IDS_SETTINGS_IMPORT_HISTORY_CHECKBOX 6386
#define IDS_SETTINGS_IMPORT_FAVORITES_CHECKBOX 6387
#define IDS_SETTINGS_IMPORT_PASSWORDS_CHECKBOX 6388
#define IDS_SETTINGS_IMPORT_SEARCH_ENGINES_CHECKBOX 6389
#define IDS_SETTINGS_IMPORT_AUTOFILL_FORM_DATA_CHECKBOX 6390
#define IDS_SETTINGS_IMPORT_CHOOSE_FILE 6391
#define IDS_SETTINGS_IMPORT_COMMIT 6392
#define IDS_SETTINGS_IMPORT_SUCCESS 6393
#define IDS_SETTINGS_IMPORT_NO_PROFILE_FOUND 6394
#define IDS_SETTINGS_PAGE_ZOOM_LABEL 6395
#define IDS_SETTINGS_FONT_SIZE_LABEL 6396
#define IDS_SETTINGS_VERY_SMALL_FONT 6397
#define IDS_SETTINGS_SMALL_FONT 6398
#define IDS_SETTINGS_MEDIUM_FONT 6399
#define IDS_SETTINGS_LARGE_FONT 6400
#define IDS_SETTINGS_VERY_LARGE_FONT 6401
#define IDS_SETTINGS_CUSTOMIZE_FONTS 6402
#define IDS_SETTINGS_FONTS 6403
#define IDS_SETTINGS_STANDARD_FONT_LABEL 6404
#define IDS_SETTINGS_SERIF_FONT_LABEL 6405
#define IDS_SETTINGS_SANS_SERIF_FONT_LABEL 6406
#define IDS_SETTINGS_FIXED_WIDTH_FONT_LABEL 6407
#define IDS_SETTINGS_MATH_FONT_LABEL 6408
#define IDS_SETTINGS_MINIMUM_FONT_SIZE_LABEL 6409
#define IDS_SETTINGS_TINY_FONT_SIZE 6410
#define IDS_SETTINGS_HUGE_FONT_SIZE 6411
#define IDS_SETTINGS_QUICK_BROWN_FOX 6412
#define IDS_SETTINGS_SYSTEM 6413
#define IDS_SETTINGS_SYSTEM_HARDWARE_ACCELERATION_LABEL 6414
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_LABEL 6415
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_EXTENSION_LABEL 6416
#define IDS_SETTINGS_SYSTEM_PROXY_SETTINGS_POLICY_LABEL 6417
#define IDS_PAGE_NOT_AVAILABLE_FOR_GUEST_HEADING 6461
#define IDS_SETTINGS_SECURITY_KEYS_TITLE 6462
#define IDS_SETTINGS_SECURITY_KEYS_DESC 6463
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN 6464
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_BUTTON 6465
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_DESC 6466
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_INITIAL_TITLE 6467
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CREATE_TITLE 6468
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CHANGE_TITLE 6469
#define IDS_SETTINGS_SECURITY_KEYS_RESET 6470
#define IDS_SETTINGS_SECURITY_KEYS_RESET_DESC 6471
#define IDS_SETTINGS_SECURITY_KEYS_RESET_TITLE 6472
#define IDS_SETTINGS_SECURITY_KEYS_RESET_CONFIRM_TITLE 6473
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP1 6474
#define IDS_SETTINGS_SECURITY_KEYS_RESET_STEP2 6475
#define IDS_SETTINGS_SECURITY_KEYS_NO_RESET 6476
#define IDS_SETTINGS_SECURITY_KEYS_RESET_ERROR 6477
#define IDS_SETTINGS_SECURITY_KEYS_RESET_SUCCESS 6478
#define IDS_SETTINGS_SECURITY_KEYS_RESET_NOTALLOWED 6479
#define IDS_SETTINGS_SECURITY_KEYS_NO_PIN 6480
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN_INTRO 6481
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT 6482
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_SIN 6483
#define IDS_SETTINGS_SECURITY_KEYS_PIN_INCORRECT_RETRIES_PL 6484
#define IDS_SETTINGS_SECURITY_KEYS_SAME_PIN_AS_CURRENT 6485
#define IDS_SETTINGS_SECURITY_KEYS_NEW_PIN 6486
#define IDS_SETTINGS_SECURITY_KEYS_SET_PIN_CONFIRM 6487
#define IDS_SETTINGS_SECURITY_KEYS_CURRENT_PIN 6488
#define IDS_SETTINGS_SECURITY_KEYS_PIN 6489
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_SHORT_SMALL 6490
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_TOO_LONG 6491
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_INVALID 6492
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR_MISMATCH 6493
#define IDS_SETTINGS_SECURITY_KEYS_CONFIRM_PIN 6494
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SUCCESS 6495
#define IDS_SETTINGS_SECURITY_KEYS_PIN_ERROR 6496
#define IDS_SETTINGS_SECURITY_KEYS_PIN_HARD_LOCK 6497
#define IDS_SETTINGS_SECURITY_KEYS_PIN_SOFT_LOCK 6498
#define IDS_SETTINGS_SECURITY_KEYS_SHOW_PINS 6499
#define IDS_SETTINGS_SECURITY_KEYS_HIDE_PINS 6500
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_LABEL 6501
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_USERNAME_LABEL 6502
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_DISPLAYNAME_LABEL 6503
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_WEBSITE_LABEL 6504
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DESC 6505
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DIALOG_TITLE 6506
#define IDS_SETTINGS_SECURITY_KEYS_UPDATE_CREDENTIAL_DIALOG_TITLE 6507
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_TITLE 6508
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_CONFIRM_DELETE_CREDENTIAL 6509
#define IDS_SETTINGS_SECURITY_KEYS_INPUT_ERROR_TOO_LONG 6510
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_CREDENTIALS 6511
#define IDS_SETTINGS_SECURITY_KEYS_NO_CREDENTIAL_MANAGEMENT 6512
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_REMOVED 6513
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_NO_PIN 6514
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_ERROR 6515
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_SUCCESS 6516
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_DELETE_FAILED 6517
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_SUCCESS 6518
#define IDS_SETTINGS_SECURITY_KEYS_CREDENTIAL_MANAGEMENT_UPDATE_FAILED 6519
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_LABEL 6520
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_SUBPAGE_DESCRIPTION 6521
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DIALOG_TITLE 6522
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ADD_TITLE 6523
#define IDS_SETTINGS_SECURITY_KEYS_BIO_CHOOSE_NAME 6524
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL 6525
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NAME_LABEL_TOO_LONG 6526
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_NO_ENROLLMENTS_LABEL 6527
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLMENTS_LABEL 6528
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_LABEL 6529
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_TRY_AGAIN_LABEL 6530
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_FAILED_LABEL 6531
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_ENROLLING_COMPLETE_LABEL 6532
#define IDS_SETTINGS_SECURITY_KEYS_NO_BIOMETRIC_ENROLLMENT 6533
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_DELETE 6534
#define IDS_SETTINGS_SECURITY_KEYS_BIO_NO_PIN 6535
#define IDS_SETTINGS_SECURITY_KEYS_BIO_ENROLLMENT_STORAGE_FULL 6536
#define IDS_SETTINGS_SECURITY_KEYS_TOUCH_TO_CONTINUE 6537
#define IDS_SETTINGS_SECURITY_KEYS_PIN_PROMPT 6538
#define IDS_SETTINGS_SECURITY_KEYS_FORCE_PIN_CHANGE 6539
#define IDS_SETTINGS_SECURITY_KEYS_PHONE_EDIT_DIALOG_TITLE 6540
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_YOUR_DEVICES 6541
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_SYNCED_DESC 6542
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DEVICES 6543
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_LINKED_DESC 6544
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE 6545
#define IDS_SETTINGS_SECURITY_KEYS_PHONES_MANAGE_DESC 6546
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_LABEL 6547
#define IDS_SETTINGS_SUBPAGE_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 6548
#define IDS_SETTINGS_CAPTIONS 6549
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_TITLE 6550
#define IDS_SETTINGS_CAPTIONS_PREFERENCES_SUBTITLE 6551
#define IDS_SETTINGS_CAPTIONS_TEXT_SIZE 6552
#define IDS_SETTINGS_CAPTIONS_TEXT_FONT 6553
#define IDS_SETTINGS_CAPTIONS_TEXT_COLOR 6554
#define IDS_SETTINGS_CAPTIONS_TEXT_OPACITY 6555
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_OPACITY 6556
#define IDS_SETTINGS_CAPTIONS_OPACITY_OPAQUE 6557
#define IDS_SETTINGS_CAPTIONS_OPACITY_SEMI_TRANSPARENT 6558
#define IDS_SETTINGS_CAPTIONS_OPACITY_TRANSPARENT 6559
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW 6560
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_NONE 6561
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_RAISED 6562
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DEPRESSED 6563
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_UNIFORM 6564
#define IDS_SETTINGS_CAPTIONS_TEXT_SHADOW_DROP_SHADOW 6565
#define IDS_SETTINGS_CAPTIONS_BACKGROUND_COLOR 6566
#define IDS_SETTINGS_CAPTIONS_COLOR_BLACK 6567
#define IDS_SETTINGS_CAPTIONS_COLOR_WHITE 6568
#define IDS_SETTINGS_CAPTIONS_COLOR_RED 6569
#define IDS_SETTINGS_CAPTIONS_COLOR_GREEN 6570
#define IDS_SETTINGS_CAPTIONS_COLOR_BLUE 6571
#define IDS_SETTINGS_CAPTIONS_COLOR_YELLOW 6572
#define IDS_SETTINGS_CAPTIONS_COLOR_CYAN 6573
#define IDS_SETTINGS_CAPTIONS_COLOR_MAGENTA 6574
#define IDS_SETTINGS_CAPTIONS_DEFAULT_SETTING 6575
#define IDS_SETTINGS_NEARBY_SHARE_TITLE 6576
#define IDS_SETTINGS_NEARBY_SHARE_SET_UP_BUTTON_TITLE 6577
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ROW_TITLE 6578
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_DIALOG_TITLE 6579
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_FIELD_LABEL 6580
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DEVICE_NAME 6581
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_TITLE 6582
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_DESCRIPTION 6583
#define IDS_SETTINGS_NEARBY_SHARE_FAST_INITIATION_NOTIFICATION_TOGGLE_ARIA_LABEL 6584
#define IDS_SETTINGS_NEARBY_SHARE_DEVICE_NAME_ARIA_DESCRIPTION 6585
#define IDS_SETTINGS_NEARBY_SHARE_CONFIRM_DEVICE_NAME 6586
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_LABEL 6587
#define IDS_SETTINGS_NEARBY_SHARE_MANAGE_CONTACTS_ROW_TITLE 6588
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_DATA_USAGE 6589
#define IDS_SETTINGS_NEARBY_SHARE_UPDATE_DATA_USAGE 6590
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_DIALOG_TITLE 6591
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_LABEL 6592
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_WIFI_ONLY_DESCRIPTION 6593
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_LABEL 6594
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_DESCRIPTION 6595
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_MOBILE_DATA_TOOLTIP 6596
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_LABEL 6597
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_OFFLINE_DESCRIPTION 6598
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_DATA_DESCRIPTION 6599
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_WIFI_ONLY_DESCRIPTION 6600
#define IDS_SETTINGS_NEARBY_SHARE_DATA_USAGE_EDIT_BUTTON_OFFLINE_DESCRIPTION 6601
#define IDS_SETTINGS_NEARBY_SHARE_CONTACT_VISIBILITY_ROW_TITLE 6602
#define IDS_SETTINGS_NEARBY_SHARE_EDIT_VISIBILITY 6603
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_TITLE 6604
#define IDS_SETTINGS_NEARBY_SHARE_VISIBILITY_DIALOG_SAVE 6605
#define IDS_SETTINGS_NEARBY_SHARE_DESCRIPTION 6606
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_TITLE 6607
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_ON 6608
#define IDS_SETTINGS_NEARBY_SHARE_HIGH_VISIBILITY_OFF 6609
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION 6610
#define IDS_SETTINGS_ENABLE_URL_KEYED_ANONYMIZED_DATA_COLLECTION_DESC 6611
#define IDS_SETTINGS_SPELLING_PREF 6612
#define IDS_SETTINGS_SUGGEST_PREF 6613
#define IDS_SETTINGS_SUGGEST_PREF_DESC 6614
#define IDS_SETTINGS_ENABLE_LOGGING_PREF 6615
#define IDS_SETTINGS_ENABLE_LOGGING_PREF_DESC 6616
#define IDS_SETTINGS_LINKDOCTOR_PREF 6617
#define IDS_SETTINGS_LINKDOCTOR_PREF_DESC 6618
#define IDS_DRIVE_SUGGEST_PREF 6619
#define IDS_SETTINGS_PEOPLE_SYNCING_TO_ACCOUNT 6620
#define IDS_SETTINGS_PEOPLE_SYNC_PAUSED 6621
#define IDS_SETTINGS_PEOPLE_SIGN_IN_PROMPT 6622
#define IDS_SETTINGS_PEOPLE_SYNC_TURN_OFF 6623
#define IDS_SETTINGS_SETTINGS_CHECKBOX_LABEL 6624
#define IDS_SETTINGS_PEOPLE_SYNC_NOT_WORKING 6625
#define IDS_SETTINGS_PEOPLE_SYNC_PASSWORDS_NOT_WORKING 6626
#define IDS_SETTINGS_SYNC_ADVANCED_PAGE_TITLE 6627
#define IDS_SETTINGS_NEW_SYNC_ADVANCED_PAGE_TITLE 6628
#define IDS_SETTINGS_PEOPLE_SYNC_ANOTHER_ACCOUNT 6629
#define IDS_SETTINGS_SYNC_DISCONNECT_CONFIRM 6630
#define IDS_SETTINGS_PEOPLE_SIGN_OUT 6631
#define IDS_SETTINGS_AUTOFILL_CHECKBOX_LABEL 6632
#define IDS_SETTINGS_HISTORY_CHECKBOX_LABEL 6633
#define IDS_SETTINGS_EXTENSIONS_CHECKBOX_LABEL 6634
#define IDS_SETTINGS_OPEN_TABS_CHECKBOX_LABEL 6635
#define IDS_SETTINGS_WIFI_CONFIGURATIONS_CHECKBOX_LABEL 6636
#define IDS_SETTINGS_SYNC_EVERYTHING_CHECKBOX_LABEL 6637
#define IDS_SETTINGS_APPS_CHECKBOX_LABEL 6638
#define IDS_SETTINGS_NON_PERSONALIZED_SERVICES_SECTION_LABEL 6639
#define IDS_SETTINGS_CUSTOMIZE_SYNC 6640
#define IDS_SETTINGS_SYNC_DATA 6641
#define IDS_SETTINGS_PASSWORDS_CHECKBOX_LABEL 6642
#define IDS_SETTINGS_PASSPHRASE_PLACEHOLDER 6643
#define IDS_SETTINGS_EXISTING_PASSPHRASE_TITLE 6644
#define IDS_SETTINGS_SUBMIT_PASSPHRASE 6645
#define IDS_SETTINGS_ENCRYPT_WITH_GOOGLE_CREDENTIALS_LABEL 6646
#define IDS_SETTINGS_BOOKMARKS_CHECKBOX_LABEL 6647
#define IDS_SETTINGS_READING_LIST_CHECKBOX_LABEL 6648
#define IDS_SETTINGS_ENCRYPTION_OPTIONS 6649
#define IDS_SETTINGS_MISMATCHED_PASSPHRASE_ERROR 6650
#define IDS_SETTINGS_EMPTY_PASSPHRASE_ERROR 6651
#define IDS_SETTINGS_INCORRECT_PASSPHRASE_ERROR 6652
#define IDS_SETTINGS_NEW_MANAGE_SYNCED_DATA_TITLE_UNIFIED_CONSENT 6653
#define IDS_SETTINGS_SYNC_SYNC_AND_NON_PERSONALIZED_SERVICES 6654
#define IDS_SETTINGS_PASSPHRASE_CONFIRMATION_PLACEHOLDER 6655
#define IDS_SETTINGS_SYNC_LOADING 6656
#define IDS_SETTINGS_SYNC_TIMEOUT 6657
#define IDS_SETTINGS_SYNC 6658
#define IDS_SETTINGS_SYNC_SETTINGS_CANCEL_SYNC 6659
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_TITLE 6660
#define IDS_SETTINGS_SYNC_SETUP_CANCEL_DIALOG_BODY 6661
#define IDS_SETTINGS_ABOUT_UPGRADE_CHECK_STARTED 6665
#define IDS_SETTINGS_THEME_CHECKBOX_LABEL 6667
#define IDS_EXTENSIONS_ALLOW_FILE_ACCESS 6671
#define IDS_EXTENSIONS_ALLOW_ON_ALL_URLS 6672
#define IDS_EXTENSIONS_ALLOW_ON_FOLLOWING_SITES 6673
#define IDS_EXTENSIONS_VIEW_ACTIVITY_LOG 6674
#define IDS_EXTENSIONS_BACKGROUND_PAGE 6675
#define IDS_EXTENSIONS_SERVICE_WORKER_BACKGROUND 6676
#define IDS_EXTENSIONS_CORRUPTED_EXTENSION 6677
#define IDS_EXTENSIONS_ENABLE_ERROR_COLLECTION 6678
#define IDS_EXTENSIONS_ERROR_NO_ERRORS_CODE_MESSAGE 6679
#define IDS_EXTENSIONS_INSTALL_DROP_TARGET 6680
#define IDS_EXTENSIONS_INSTALL_WARNINGS 6681
#define IDS_EXTENSIONS_LOG_LEVEL_ERROR 6682
#define IDS_EXTENSIONS_LOG_LEVEL_INFO 6683
#define IDS_EXTENSIONS_LOG_LEVEL_WARN 6684
#define IDS_EXTENSIONS_PATH 6685
#define IDS_EXTENSIONS_PERMISSIONS_OFF 6686
#define IDS_EXTENSIONS_RELOAD_TERMINATED 6687
#define IDS_EXTENSIONS_REPAIR_CORRUPTED 6688
#define IDS_EXTENSIONS_VIEW_IFRAME 6689
#define IDS_EXTENSIONS_VIEW_INACTIVE 6690
#define IDS_EXTENSIONS_VIEW_INCOGNITO 6691
#define IDS_EXTENSIONS_DEVELOPER_MODE 6692
#define IDS_EXTENSIONS_DISABLED_UPDATE_REQUIRED_BY_POLICY 6693
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_ALLOW 6694
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_TITLE 6695
#define IDS_EXTENSIONS_MATCHING_RESTRICTED_SITES_WARNING 6696
#define IDS_EXTENSIONS_MENU_BUTTON_LABEL 6697
#define IDS_EXTENSIONS_ERROR_PAGE_HEADING 6698
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_ALLOW_ALL_EXTENSIONS 6699
#define IDS_EXTENSIONS_EDIT_SITE_PERMISSIONS_RESTRICT_EXTENSIONS 6700
#define IDS_EXTENSIONS_ERROR_ANONYMOUS_FUNCTION 6701
#define IDS_EXTENSIONS_ERROR_CONTEXT 6702
#define IDS_EXTENSIONS_ERROR_CONTEXT_UNKNOWN 6703
#define IDS_EXTENSIONS_CLEAR_ACTIVITIES 6704
#define IDS_EXTENSIONS_ERROR_CLEAR_ALL 6705
#define IDS_EXTENSIONS_A11Y_CLEAR_ENTRY 6706
#define IDS_EXTENSIONS_ERROR_STACK_TRACE 6707
#define IDS_EXTENSIONS_ERROR_LINES_NOT_SHOWN 6708
#define IDS_EXTENSIONS_HOST_PERMISSIONS_DESCRIPTION 6709
#define IDS_EXTENSIONS_HOST_PERMISSIONS_EDIT 6710
#define IDS_EXTENSIONS_ITEM_ERRORS 6711
#define IDS_EXTENSIONS_ITEM_HOST_PERMISSIONS_HEADING 6712
#define IDS_EXTENSIONS_NEW_HOST_PERMISSIONS_HEADING 6713
#define IDS_EXTENSIONS_HOST_PERMISSIONS_SUB_HEADING 6714
#define IDS_EXTENSIONS_HOST_ACCESS_ON_CLICK 6715
#define IDS_EXTENSIONS_HOST_ACCESS_WHEN_CLICKED 6716
#define IDS_EXTENSIONS_HOST_ACCESS_ON_SPECIFIC_SITES 6717
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_SPECIFIC_SITES 6718
#define IDS_EXTENSIONS_HOST_ACCESS_ON_ALL_SITES 6719
#define IDS_EXTENSIONS_HOST_ACCESS_ALLOW_ON_ALL_SITES 6720
#define IDS_EXTENSIONS_ITEM_ALLOWED_HOSTS 6721
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_LINE 6722
#define IDS_EXTENSIONS_ACCESSIBILITY_ERROR_MULTI_LINE 6723
#define IDS_EXTENSIONS_ACTIVITY_LOG_PAGE_HEADING 6724
#define IDS_EXTENSIONS_ACTIVITY_LOG_SEARCH_LABEL 6725
#define IDS_EXTENSIONS_ACTIVITY_LOG_TYPE_COLUMN 6726
#define IDS_EXTENSIONS_ACTIVITY_LOG_NAME_COLUMN 6727
#define IDS_EXTENSIONS_ACTIVITY_LOG_COUNT_COLUMN 6728
#define IDS_EXTENSIONS_ACTIVITY_LOG_TIME_COLUMN 6729
#define IDS_EXTENSIONS_ACTIVITY_LOG_HISTORY_TAB_HEADING 6730
#define IDS_EXTENSIONS_ACTIVITY_LOG_STREAM_TAB_HEADING 6731
#define IDS_EXTENSIONS_START_ACTIVITY_STREAM 6732
#define IDS_EXTENSIONS_STOP_ACTIVITY_STREAM 6733
#define IDS_EXTENSIONS_EMPTY_STREAM_STARTED 6734
#define IDS_EXTENSIONS_EMPTY_STREAM_STOPPED 6735
#define IDS_EXTENSIONS_ACTIVITY_ARGUMENTS_HEADING 6736
#define IDS_EXTENSIONS_WEB_REQUEST_INFO_HEADING 6737
#define IDS_EXTENSIONS_ACTIVITY_LOG_MORE_ACTIONS_LABEL 6738
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPAND_ALL 6739
#define IDS_EXTENSIONS_ACTIVITY_LOG_COLLAPSE_ALL 6740
#define IDS_EXTENSIONS_ACTIVITY_LOG_EXPORT_HISTORY 6741
#define IDS_EXTENSIONS_ITEM_ID 6742
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS 6743
#define IDS_EXTENSIONS_ITEM_INSPECT_VIEWS_EXTRA 6744
#define IDS_EXTENSIONS_ITEM_NO_ACTIVE_VIEWS 6745
#define IDS_EXTENSIONS_ITEM_ALLOW_INCOGNITO 6746
#define IDS_EXTENSIONS_ITEM_DEPENDENCIES 6747
#define IDS_EXTENSIONS_DEPENDENT_ENTRY 6748
#define IDS_EXTENSIONS_ITEM_DESCRIPTION 6749
#define IDS_EXTENSIONS_ITEM_DETAILS 6750
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_LABEL 6751
#define IDS_EXTENSIONS_DETAILS_BACK_BUTTON_ARIA_ROLE_DESCRIPTION 6752
#define IDS_EXTENSIONS_EXTENSION_A11Y_ASSOCIATION 6753
#define IDS_EXTENSIONS_APP_ICON 6754
#define IDS_EXTENSIONS_EXTENSION_ICON 6755
#define IDS_EXTENSIONS_ITEM_ID_HEADING 6756
#define IDS_EXTENSIONS_EXTENSION_ENABLED 6757
#define IDS_EXTENSIONS_APP_ENABLED 6758
#define IDS_EXTENSIONS_ITEM_OFF 6759
#define IDS_EXTENSIONS_ITEM_ON 6760
#define IDS_EXTENSIONS_ITEM_EXTENSION_WEBSITE 6761
#define IDS_EXTENSIONS_ITEM_CHROME_WEB_STORE 6762
#define IDS_EXTENSIONS_ITEM_OPTIONS 6763
#define IDS_EXTENSIONS_ITEM_PERMISSIONS 6764
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_EMPTY 6765
#define IDS_EXTENSIONS_ITEM_PERMISSIONS_AND_SITE_ACCESS_EMPTY 6766
#define IDS_EXTENSIONS_ITEM_REMOVE_EXTENSION 6767
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS 6768
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_ADD_HOST 6769
#define IDS_EXTENSIONS_ITEM_SITE_ACCESS_EMPTY 6770
#define IDS_EXTENSIONS_REMOVE_SITES_DIALOG_TITLE 6771
#define IDS_EXTENSIONS_ITEM_SOURCE 6772
#define IDS_EXTENSIONS_ITEM_SOURCE_POLICY 6773
#define IDS_EXTENSIONS_ITEM_SOURCE_SIDELOADED 6774
#define IDS_EXTENSIONS_ITEM_SOURCE_UNPACKED 6775
#define IDS_EXTENSIONS_ITEM_SOURCE_WEBSTORE 6776
#define IDS_EXTENSIONS_ITEM_VERSION 6777
#define IDS_EXTENSIONS_ITEM_RELOADED 6778
#define IDS_EXTENSIONS_ITEM_RELOADING 6779
#define IDS_EXTENSIONS_LOAD_ERROR_HEADING 6780
#define IDS_EXTENSIONS_LOAD_ERROR_ERROR_LABEL 6781
#define IDS_EXTENSIONS_LOAD_ERROR_FILE_LABEL 6782
#define IDS_EXTENSIONS_LOAD_ERROR_COULD_NOT_LOAD_MANIFEST 6783
#define IDS_EXTENSIONS_LOAD_ERROR_RETRY 6784
#define IDS_EXTENSIONS_LOADING_ACTIVITIES 6785
#define IDS_MISSING_OR_UNINSTALLED_EXTENSION 6786
#define IDS_EXTENSIONS_NO_ACTIVITIES 6787
#define IDS_EXTENSIONS_NO_INSTALLED_ITEMS 6788
#define IDS_EXTENSIONS_NO_DESCRIPTION 6789
#define IDS_EXTENSIONS_PACK_DIALOG_TITLE 6790
#define IDS_EXTENSIONS_PACK_DIALOG_WARNING_TITLE 6791
#define IDS_EXTENSIONS_PACK_DIALOG_ERROR_TITLE 6792
#define IDS_EXTENSIONS_PACK_DIALOG_PROCEED_ANYWAY 6793
#define IDS_EXTENSIONS_PACK_DIALOG_BROWSE_BUTTON 6794
#define IDS_EXTENSIONS_PACK_DIALOG_EXTENSION_ROOT_LABEL 6795
#define IDS_EXTENSIONS_PACK_DIALOG_KEY_FILE_LABEL 6796
#define IDS_EXTENSIONS_PACK_DIALOG_CONFIRM_BUTTON 6797
#define IDS_EXTENSIONS_TOOLBAR_TITLE 6798
#define IDS_EXTENSIONS_SEARCH 6799
#define IDS_EXTENSIONS_SITE_PERMISSIONS 6800
#define IDS_EXTENSIONS_SITE_PERMISSIONS_PAGE_TITLE 6801
#define IDS_EXTENSIONS_SITE_PERMISSIONS_VIEW_ALL_SITES 6802
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ALL_SITES_PAGE_TITLE 6803
#define IDS_EXTENSIONS_PERMITTED_SITES 6804
#define IDS_EXTENSIONS_RESTRICTED_SITES 6805
#define IDS_EXTENSIONS_NO_SITES_ADDED 6806
#define IDS_EXTENSIONS_SITE_PERMISSIONS_ADD_SITE_DIALOG_TITLE 6807
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_SITE_DIALOG_TITLE 6808
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_URL 6809
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS_DIALOG_TITLE 6810
#define IDS_EXTENSIONS_SITE_PERMISSIONS_EDIT_PERMISSIONS 6811
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_ERROR 6812
#define IDS_EXTENSIONS_SITE_PERMISSIONS_DIALOG_INPUT_LABEL 6813
#define IDS_EXTENSIONS_EDIT_SHORTCUT 6814
#define IDS_EXTENSIONS_SHORTCUT_NOT_SET 6815
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_LABEL 6816
#define IDS_EXTENSIONS_SHORTCUT_SCOPE_GLOBAL 6817
#define IDS_EXTENSIONS_APPS_TITLE 6818
#define IDS_EXTENSIONS_REMOVE 6819
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_TITLE 6820
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_ERROR 6821
#define IDS_EXTENSIONS_RUNTIME_HOSTS_DIALOG_INPUT_LABEL 6822
#define IDS_EXTENSIONS_SIDEBAR_EXTENSIONS 6823
#define IDS_EXTENSIONS_SIDEBAR_OPEN_CHROME_WEB_STORE 6824
#define IDS_EXTENSIONS_SIDEBAR_KEYBOARD_SHORTCUTS 6825
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED 6826
#define IDS_EXTENSIONS_TOOLBAR_LOAD_UNPACKED_DONE 6827
#define IDS_EXTENSIONS_TOOLBAR_PACK 6828
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW 6829
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_NOW_TOOLTIP 6830
#define IDS_EXTENSIONS_TOOLBAR_UPDATE_DONE 6831
#define IDS_EXTENSIONS_TOOLBAR_UPDATING_TOAST 6832
#define IDS_EXTENSIONS_SHORTCUT_SET 6833
#define IDS_EXTENSIONS_TYPE_A_SHORTCUT 6834
#define IDS_EXTENSIONS_SUBPAGE_BUTTON 6835
#define IDS_EXTENSIONS_INCLUDE_START_MODIFIER 6836
#define IDS_EXTENSIONS_TOO_MANY_MODIFIERS 6837
#define IDS_EXTENSIONS_NEED_CHARACTER 6838
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_SUBTITLE 6849
#define IDS_NEARBY_CONFIRMATION_PAGE_ADD_CONTACT_TITLE 6850
#define IDS_NEARBY_CONFIRMATION_PAGE_TITLE 6851
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOAD_FAILED 6852
#define IDS_NEARBY_CONTACT_VISIBILITY_DOWNLOADING 6853
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_SUBTITLE 6854
#define IDS_NEARBY_CONTACT_VISIBILITY_NO_CONTACTS_TITLE 6855
#define IDS_NEARBY_CONTACT_VISIBILITY_NUM_UNREACHABLE 6856
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_ALL 6857
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_NONE 6858
#define IDS_NEARBY_CONTACT_VISIBILITY_OWN_SOME 6859
#define IDS_NEARBY_CONTACT_VISIBILITY_ZERO_STATE_TEXT 6860
#define IDS_NEARBY_DEVICE_NAME_EMPTY_ERROR 6861
#define IDS_NEARBY_DEVICE_NAME_TOO_LONG_ERROR 6862
#define IDS_NEARBY_DEVICE_NAME_INVALID_CHARACTERS_ERROR 6863
#define IDS_NEARBY_DISCOVERY_PAGE_INFO 6864
#define IDS_NEARBY_DISCOVERY_PAGE_SUBTITLE 6865
#define IDS_NEARBY_DISCOVERY_PAGE_TITLE 6866
#define IDS_NEARBY_DISCOVERY_PAGE_PLACEHOLDER 6867
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME 6868
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_NAME_HELP 6869
#define IDS_NEARBY_ONBOARDING_PAGE_SUBTITLE 6870
#define IDS_NEARBY_ONBOARDING_PAGE_TITLE 6871
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY 6872
#define IDS_NEARBY_ONBOARDING_PAGE_DEVICE_VISIBILITY_HELP_ALL_CONTACTS 6873
#define IDS_NEARBY_VISIBILITY_PAGE_MANAGE_CONTACTS 6874
#define IDS_NEARBY_VISIBILITY_PAGE_SUBTITLE 6875
#define IDS_NEARBY_VISIBILITY_PAGE_TITLE 6876
#define IDS_NEARBY_SHARE_FEATURE_NAME 6877
#define IDS_NEARBY_ACTIONS_ACCEPT 6878
#define IDS_NEARBY_ACTIONS_CANCEL 6879
#define IDS_NEARBY_ACTIONS_CLOSE 6880
#define IDS_NEARBY_ACTIONS_CONFIRM 6881
#define IDS_NEARBY_ACTIONS_DECLINE 6882
#define IDS_NEARBY_ACTIONS_NEXT 6883
#define IDS_NEARBY_ACTIONS_REJECT 6884
#define IDS_NEARBY_DEFAULT_DEVICE_NAME 6885
#define IDS_NEARBY_ERROR_CANCELLED 6886
#define IDS_NEARBY_ERROR_CANT_RECEIVE 6887
#define IDS_NEARBY_ERROR_CANT_SHARE 6888
#define IDS_NEARBY_ERROR_NO_RESPONSE 6889
#define IDS_NEARBY_ERROR_TRANSFER_IN_PROGRESS 6890
#define IDS_NEARBY_ERROR_NOT_ENOUGH_SPACE 6891
#define IDS_NEARBY_ERROR_REJECTED 6892
#define IDS_NEARBY_ERROR_SOMETHING_WRONG 6893
#define IDS_NEARBY_ERROR_TIME_OUT 6894
#define IDS_NEARBY_ERROR_TRY_AGAIN 6895
#define IDS_NEARBY_ERROR_UNSUPPORTED_FILE_TYPE 6896
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_APPS 6897
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_APPS 6898
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_IMAGES 6899
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_IMAGES 6900
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_UNKNOWN 6901
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 6902
#define IDS_NEARBY_FILE_ATTACHMENTS_CAPITALIZED_VIDEOS 6903
#define IDS_NEARBY_FILE_ATTACHMENTS_NOT_CAPITALIZED_VIDEOS 6904
#define IDS_NEARBY_SECURE_CONNECTION_ID 6905
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_ADDRESSES 6906
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_ADDRESSES 6907
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_LINKS 6908
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_LINKS 6909
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_PHONE_NUMBERS 6910
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_PHONE_NUMBERS 6911
#define IDS_NEARBY_TEXT_ATTACHMENTS_CAPITALIZED_UNKNOWN 6912
#define IDS_NEARBY_TEXT_ATTACHMENTS_NOT_CAPITALIZED_UNKNOWN 6913
#define IDS_NEARBY_CAPITALIZED_UNKNOWN_ATTACHMENTS 6914
#define IDS_NEARBY_NOT_CAPITALIZED_UNKNOWN_ATTACHMENTS 6915
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE 6916
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_MINUTES 6917
#define IDS_NEARBY_HIGH_VISIBILITY_SUB_TITLE_SECONDS 6918
#define IDS_NEARBY_HIGH_VISIBILITY_HELP_TEXT 6919
#define IDS_NEARBY_HIGH_VISIBILITY_TIMEOUT_TEXT 6920
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_ERROR 6921
#define IDS_NEARBY_HIGH_VISIBILITY_TRANSFER_IN_PROGRESS_DESCRIPTION 6922
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_ERROR 6923
#define IDS_NEARBY_HIGH_VISIBILITY_CONNECTION_MEDIUM_DESCRIPTION 6924
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_TITLE 6925
#define IDS_NEARBY_RECEIVE_CONFIRM_PAGE_CONNECTION_ID 6926
#define IDS_NEARBY_PREVIEW_TITLE_MULTIPLE_FILE 6927
#define IDS_NEARBY_ACCOUNT_ROW_LABEL 6928
#define IDS_NEARBY_SETTINGS_HELP_CAPTION 6929
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS 6930
#define IDS_NEARBY_VISIBLITY_ALL_CONTACTS_DESCRIPTION 6931
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS 6932
#define IDS_NEARBY_VISIBLITY_SOME_CONTACTS_DESCRIPTION 6933
#define IDS_NEARBY_VISIBLITY_HIDDEN 6934
#define IDS_NEARBY_VISIBLITY_HIDDEN_DESCRIPTION 6935
#define IDS_NEARBY_VISIBLITY_UNKNOWN 6936
#define IDS_NEARBY_VISIBLITY_UNKNOWN_DESCRIPTION 6937
#define IDS_NEARBY_NOTIFICATION_ACTION_COPY_TO_CLIPBOARD 6938
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_FOLDER 6939
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_NETWORK_LIST 6940
#define IDS_NEARBY_NOTIFICATION_ACTION_OPEN_URL 6941
#define IDS_NEARBY_NOTIFICATION_ACCEPT_ACTION 6942
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE 6943
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_MESSAGE_WIFI_CREDENTIALS 6944
#define IDS_NEARBY_NOTIFICATION_CONNECTION_REQUEST_TITLE 6945
#define IDS_NEARBY_NOTIFICATION_DECLINE_ACTION 6946
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_MESSAGE 6947
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_MESSAGE 6948
#define IDS_NEARBY_NOTIFICATION_ONBOARDING_TITLE 6949
#define IDS_NEARBY_NOTIFICATION_SET_UP_ACTION 6950
#define IDS_NEARBY_NOTIFICATION_GO_VISIBLE_ACTION 6951
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_TITLE 6952
#define IDS_NEARBY_NOTIFICATION_VISIBILITY_REMINDER_MESSAGE 6953
#define IDS_NEARBY_NOTIFICATION_GO_TO_SETTINGS_ACTION 6954
#define IDS_NEARBY_NOTIFICATION_DISMISS_ACTION 6955
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE 6956
#define IDS_NEARBY_NOTIFICATION_RECEIVE_FAILURE_TITLE_WIFI_CREDENTIALS 6957
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE 6958
#define IDS_NEARBY_NOTIFICATION_RECEIVE_PROGRESS_TITLE_WIFI_CREDENTIALS 6959
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE 6960
#define IDS_NEARBY_NOTIFICATION_RECEIVE_SUCCESS_TITLE_WIFI_CREDENTIALS 6961
#define IDS_NEARBY_NOTIFICATION_SEND_FAILURE_TITLE 6962
#define IDS_NEARBY_NOTIFICATION_SEND_PROGRESS_TITLE 6963
#define IDS_NEARBY_NOTIFICATION_SEND_SUCCESS_TITLE 6964
#define IDS_NEARBY_NOTIFICATION_SOURCE 6965
#define IDS_NEARBY_NOTIFICATION_SENDER_CANCELLED 6966
#define IDS_WELCOME_NEXT 6967
#define IDS_WELCOME_SKIP 6968
#define IDS_WELCOME_STEPS 6969
#define IDS_WELCOME_BOOKMARK_ADDED 6970
#define IDS_WELCOME_BOOKMARKS_ADDED 6971
#define IDS_WELCOME_BOOKMARK_REMOVED 6972
#define IDS_WELCOME_BOOKMARKS_REMOVED 6973
#define IDS_DEFAULT_BROWSER_CHANGED 6974
#define IDS_WELCOME_GOOGLE_APPS_DESCRIPTION 6975
#define IDS_WELCOME_GOOGLE_GMAIL 6977
#define IDS_WELCOME_GOOGLE_APPS_MAPS 6978
#define IDS_WELCOME_GOOGLE_APPS_NEWS 6979
#define IDS_WELCOME_GOOGLE_APPS_TRANSLATE 6980
#define IDS_WELCOME_GOOGLE_APPS_YOUTUBE 6981
#define IDS_WELCOME_NTP_BACKGROUND_DESCRIPTION 6982
#define IDS_WELCOME_NTP_BACKGROUND_DEFAULT_TITLE 6983
#define IDS_WELCOME_NTP_BACKGROUND_ART_TITLE 6984
#define IDS_WELCOME_NTP_BACKGROUND_LANDSCAPE_TITLE 6985
#define IDS_WELCOME_NTP_BACKGROUND_CITYSCAPE_TITLE 6986
#define IDS_WELCOME_NTP_BACKGROUND_EARTH_TITLE 6987
#define IDS_WELCOME_NTP_BACKGROUND_GEOMETRIC_SHAPES_TITLE 6988
#define IDS_WELCOME_NTP_BACKGROUND_PHOTO_BY_LABEL 6989
#define IDS_WELCOME_NTP_BACKGROUND_PREVIEW_UPDATED 6990
#define IDS_WELCOME_NTP_BACKGROUND_RESET 6991
#define IDS_WELCOME_SET_AS_DEFAULT_HEADER 6992
#define IDS_WELCOME_SET_AS_DEFAULT_SUB_HEADER 6993
#define IDS_WELCOME_SET_AS_DEFAULT_SET_AS_DEFAULT 6994
#define IDS_WELCOME_LANDING_TITLE 6995
#define IDS_WELCOME_LANDING_DESCRIPTION 6996
#define IDS_WELCOME_LANDING_NEW_USER 6997
#define IDS_WELCOME_LANDING_EXISTING_USER 6998
#define IDS_WELCOME_SIGNIN_VIEW_HEADER 6999
#define IDS_WELCOME_SIGNIN_VIEW_SUB_HEADER 7000
#define IDS_WELCOME_SIGNIN_VIEW_SIGNIN 7001
#define IDS_WHATS_NEW_TITLE 7002
#define IDS_UTILITY_PROCESS_PRINTING_SERVICE_NAME 7003
#define IDS_UTILITY_PROCESS_PRINT_BACKEND_SERVICE_NAME 7004
#define IDS_PRINT_INVALID_PRINTER_SETTINGS 7005
#define IDS_PRINT_PREVIEW_TITLE 7006
#define IDS_PRINT_PREVIEW_DESCRIPTION 7007
#define IDS_PRINT_PREVIEW_LOADING 7008
#define IDS_PRINT_PREVIEW_FAILED 7009
#define IDS_PRINT_PREVIEW_INVALID_PRINTER_SETTINGS 7010
#define IDS_PRINT_PREVIEW_PRINT_BUTTON 7011
#define IDS_PRINT_PREVIEW_SAVE_BUTTON 7012
#define IDS_PRINT_PREVIEW_PRINTING 7013
#define IDS_PRINT_PREVIEW_SAVING 7014
#define IDS_PRINT_PREVIEW_OPTION_ALL_PAGES 7015
#define IDS_PRINT_PREVIEW_OPTION_ODD_PAGES 7016
#define IDS_PRINT_PREVIEW_OPTION_EVEN_PAGES 7017
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_PAGES 7018
#define IDS_PRINT_PREVIEW_DESTINATION_LABEL 7019
#define IDS_PRINT_PREVIEW_OPTION_BW 7020
#define IDS_PRINT_PREVIEW_OPTION_COLLATE 7021
#define IDS_PRINT_PREVIEW_OPTION_COLOR 7022
#define IDS_PRINT_PREVIEW_OPTION_LANDSCAPE 7023
#define IDS_PRINT_PREVIEW_OPTION_PORTRAIT 7024
#define IDS_PRINT_PREVIEW_OPTION_TWO_SIDED 7025
#define IDS_PRINT_PREVIEW_PRINT_ON_BOTH_SIDES_LABEL 7026
#define IDS_PRINT_PREVIEW_OPTION_LONG_EDGE 7027
#define IDS_PRINT_PREVIEW_OPTION_SHORT_EDGE 7028
#define IDS_PRINT_PREVIEW_PAGES_LABEL 7029
#define IDS_PRINT_PREVIEW_LAYOUT_LABEL 7030
#define IDS_PRINT_PREVIEW_COPIES_LABEL 7031
#define IDS_PRINT_PREVIEW_SCALING_LABEL 7032
#define IDS_PRINT_PREVIEW_OPTION_DEFAULT_SCALING 7033
#define IDS_PRINT_PREVIEW_OPTION_CUSTOM_SCALING 7034
#define IDS_PRINT_PREVIEW_PAGES_PER_SHEET_LABEL 7035
#define IDS_PRINT_PREVIEW_EXAMPLE_PAGE_RANGE_TEXT 7036
#define IDS_PRINT_PREVIEW_PRINT_TO_PDF 7037
#define IDS_PRINT_PREVIEW_SHEET_SUMMARY_LABEL 7038
#define IDS_PRINT_PREVIEW_PAGE_SUMMARY_LABEL 7039
#define IDS_PRINT_PREVIEW_PAGE_RANGE_SYNTAX_INSTRUCTION 7040
#define IDS_PRINT_PREVIEW_PAGE_RANGE_LIMIT_INSTRUCTION_WITH_VALUE 7041
#define IDS_PRINT_PREVIEW_COPIES_INSTRUCTION 7042
#define IDS_PRINT_PREVIEW_SCALING_INSTRUCTION 7043
#define IDS_PRINT_PREVIEW_PRINT_PAGES_LABEL 7044
#define IDS_PRINT_PREVIEW_OPTIONS_LABEL 7045
#define IDS_PRINT_PREVIEW_OPTION_HEADER_FOOTER 7046
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAGE 7047
#define IDS_PRINT_PREVIEW_OPTION_FIT_TO_PAPER 7048
#define IDS_PRINT_PREVIEW_OPTION_BACKGROUND_COLORS_AND_IMAGES 7049
#define IDS_PRINT_PREVIEW_OPTION_SELECTION_ONLY 7050
#define IDS_PRINT_PREVIEW_OPTION_RASTERIZE 7051
#define IDS_PRINT_PREVIEW_MARGINS_LABEL 7052
#define IDS_PRINT_PREVIEW_DEFAULT_MARGINS 7053
#define IDS_PRINT_PREVIEW_NO_MARGINS 7054
#define IDS_PRINT_PREVIEW_CUSTOM_MARGINS 7055
#define IDS_PRINT_PREVIEW_MINIMUM_MARGINS 7056
#define IDS_PRINT_PREVIEW_TOP_MARGIN_LABEL 7057
#define IDS_PRINT_PREVIEW_BOTTOM_MARGIN_LABEL 7058
#define IDS_PRINT_PREVIEW_LEFT_MARGIN_LABEL 7059
#define IDS_PRINT_PREVIEW_RIGHT_MARGIN_LABEL 7060
#define IDS_PRINT_PREVIEW_MEDIA_SIZE_LABEL 7061
#define IDS_PRINT_PREVIEW_DPI_LABEL 7062
#define IDS_PRINT_PREVIEW_NON_ISOTROPIC_DPI_ITEM_LABEL 7063
#define IDS_PRINT_PREVIEW_DPI_ITEM_LABEL 7064
#define IDS_PRINT_PREVIEW_DESTINATION_SEARCH_TITLE 7065
#define IDS_PRINT_PREVIEW_SEARCH_BOX_PLACEHOLDER 7066
#define IDS_PRINT_PREVIEW_NO_DESTINATIONS_MESSAGE 7067
#define IDS_PRINT_PREVIEW_PRINT_DESTINATIONS_TITLE 7068
#define IDS_PRINT_PREVIEW_MANAGE 7069
#define IDS_PRINT_PREVIEW_SEE_MORE 7070
#define IDS_PRINT_PREVIEW_SEE_MORE_DESTINATIONS_LABEL 7071
#define IDS_PRINT_PREVIEW_EXTENSION_DESTINATION_ICON_TOOLTIP 7072
#define IDS_MORE_OPTIONS_LABEL 7073
#define IDS_PRINT_PREVIEW_COULD_NOT_PRINT 7074
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_SEARCH_BOX_PLACEHOLDER 7075
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_TITLE 7076
#define IDS_PRINT_PREVIEW_NO_ADVANCED_SETTINGS_MATCH_SEARCH_HINT 7077
#define IDS_PRINT_PREVIEW_ADVANCED_SETTINGS_DIALOG_CONFIRM 7078
#define IDS_PRINT_PREVIEW_NEW_SHOW_ADVANCED_OPTIONS 7079
#define IDS_PRINT_PREVIEW_BUTTON_SELECT 7080
#define IDS_PRINT_PREVIEW_BUTTON_GO_BACK 7081
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_DIALOG_TITLE 7082
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_PERMISSION_MESSAGE 7083
#define IDS_PRINT_PREVIEW_RESOLVE_EXTENSION_USB_ERROR_MESSAGE 7084
#define IDS_PRINT_PREVIEW_MANAGED_SETTINGS_TEXT 7085
#define IDS_PRINT_PREVIEW_SYSTEM_DIALOG_OPTION 7109
#define IDS_PRINT_PREVIEW_OPENING_PDF_IN_PREVIEW_APP 7110
#define IDS_PRINT_PREVIEW_OPEN_PDF_IN_PREVIEW_APP 7111
#define IDS_DEFAULT_PRINT_DOCUMENT_TITLE 7112
#define IDS_PRINT_SPOOL_FAILED_TITLE_TEXT 7113
#define IDS_PRINT_SPOOL_FAILED_ERROR_TEXT 7114
#define IDS_BACK_BUTTON_AUTHENTICATOR_REQUEST_DIALOG 7196
#define IDS_BACKGROUND_CRASHED_APP_BALLOON_MESSAGE 7199
#define IDS_BACKGROUND_CRASHED_EXTENSION_BALLOON_MESSAGE 7200
#define IDS_BACKGROUND_APP_NOT_INSTALLED 7201
#define IDS_PERMISSIONS_REQUESTED_SCREENREADER_ANNOUNCEMENT 7202
#define IDS_PERMISSIONS_EXPIRED_SCREENREADER_ANNOUNCEMENT 7203
#define IDS_PERMISSIONS_BUBBLE_PROMPT 7204
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_ONE_PERM 7205
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS 7206
#define IDS_PERMISSIONS_BUBBLE_PROMPT_ACCESSIBLE_TITLE_TWO_PERMS_MORE 7207
#define IDS_PERMISSIONS_BUBBLE_PROMPT_THIS_FILE 7208
#define IDS_PERMISSION_CUSTOMIZE 7209
#define IDS_ALTERNATE_NAV_URL_VIEW_LABEL 7210
#define IDS_DOWNLOAD_TITLE 7211
#define IDS_TAB_LOADING_TITLE 7212
#define IDS_HOVER_CARD_FILE_URL_SOURCE 7213
#define IDS_HOVER_CARD_BLOB_URL_SOURCE 7214
#define IDS_HOVER_CARD_CRASHED_TITLE 7215
#define IDS_HISTORY_SEARCH_PROMPT 7216
#define IDS_HISTORY_DELETE 7217
#define IDS_HISTORY_ITEMS_SELECTED 7218
#define IDS_HISTORY_ITEMS_UNSELECTED 7219
#define IDS_HISTORY_HISTORY_MENU_DESCRIPTION 7220
#define IDS_HISTORY_HISTORY_MENU_ITEM 7221
#define IDS_HISTORY_NO_SYNCED_RESULTS 7222
#define IDS_HISTORY_OPEN_TABS_MENU_ITEM 7223
#define IDS_HISTORY_TURN_ON_SYNC_BUTTON 7224
#define IDS_HISTORY_TURN_ON_SYNC_PROMO 7225
#define IDS_HISTORY_TURN_ON_SYNC_PROMO_DESC 7226
#define IDS_EDIT 297
#define IDS_CLEAR_SEARCH 7227
#define IDS_CONFIRM 7228
#define IDS_DISABLE 7229
#define IDS_SEARCH_CLEARED 7230
#define IDS_SEARCH_RESULTS 7231
#define IDS_SEARCH_RESULTS_SINGULAR 7232
#define IDS_SEARCH_RESULTS_PLURAL 7233
#define IDS_SEARCH_RESULT_BUBBLE_TEXT 7234
#define IDS_SEARCH_RESULTS_BUBBLE_TEXT 7235
#define IDS_SEARCH_NO_RESULTS 7236
#define IDS_SHOW_BUBBLE_INACTIVE_DESCRIPTION 7237
#define IDS_FOCUS_HELP_BUBBLE_DESCRIPTION 7238
#define IDS_FOCUS_HELP_BUBBLE_TOGGLE_DESCRIPTION 7239
#define IDS_FOCUS_HELP_BUBBLE_TUTORIAL_DESCRIPTION 7240
#define IDS_CONTENT_CONTEXT_INSPECTELEMENT 7241
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_DIALOG_TITLE 7242
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_ENABLE 7243
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_BUBBLE_DISABLE 7244
#define IDS_CONTENT_CONTEXT_BACK 7245
#define IDS_CONTENT_CONTEXT_FORWARD 7246
#define IDS_CONTENT_CONTEXT_SAVEPAGEAS 7247
#define IDS_CONTENT_CONTEXT_PRINT 7248
#define IDS_CONTENT_CONTEXT_VIEWPAGESOURCE 7249
#define IDS_CONTENT_CONTEXT_OPENLINKWITH 7250
#define IDS_CONTENT_CONTEXT_OPENLINKWITH_CONFIGURE 7251
#define IDS_CONTENT_CONTEXT_INSPECTBACKGROUNDPAGE 7252
#define IDS_CONTENT_CONTEXT_READ_ANYTHING 7253
#define IDS_CONTENT_CONTEXT_RUN_PDF_OCR 7254
#define IDS_CONTENT_CONTEXT_RELOAD 7255
#define IDS_CONTENT_CONTEXT_RESTART_APP 7256
#define IDS_CONTENT_CONTEXT_RELOAD_PACKAGED_APP 7257
#define IDS_CONTENT_CONTEXT_TRANSLATE 7258
#define IDS_CONTENT_CONTEXT_EXIT_FULLSCREEN 7259
#define IDS_CONTENT_CONTEXT_RELOADFRAME 7260
#define IDS_CONTENT_CONTEXT_VIEWFRAMESOURCE 7261
#define IDS_CONTENT_CONTEXT_OPENLINKNEWTAB 7262
#define IDS_CONTENT_CONTEXT_OPENLINKNEWWINDOW 7263
#define IDS_CONTENT_CONTEXT_OPENLINKOFFTHERECORD 7264
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILES 7265
#define IDS_CONTENT_CONTEXT_OPENLINKINPROFILE 7266
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP 7267
#define IDS_CONTENT_CONTEXT_OPENLINKBOOKMARKAPP_SAMEAPP 7268
#define IDS_CONTENT_CONTEXT_SAVELINKAS 7269
#define IDS_CONTENT_CONTEXT_COPYLINKLOCATION 7270
#define IDS_CONTENT_CONTEXT_COPYEMAILADDRESS 7271
#define IDS_CONTENT_CONTEXT_COPYLINKTEXT 7272
#define IDS_CONTENT_CONTEXT_COPYLINKTOTEXT 7273
#define IDS_CONTENT_CONTEXT_ADD_A_NOTE 7274
#define IDS_CONTENT_CONTEXT_REMOVELINKTOTEXT 7275
#define IDS_CONTENT_CONTEXT_RESHARELINKTOTEXT 7276
#define IDS_CONTENT_CONTEXT_SAVEIMAGEAS 7277
#define IDS_CONTENT_CONTEXT_COPYIMAGELOCATION 7278
#define IDS_CONTENT_CONTEXT_COPYIMAGE 7279
#define IDS_CONTENT_CONTEXT_OPENIMAGENEWTAB 7280
#define IDS_CONTENT_CONTEXT_OPEN_ORIGINAL_IMAGE_NEW_TAB 7281
#define IDS_CONTENT_CONTEXT_LOAD_IMAGE 7282
#define IDS_CONTENT_CONTEXT_LOOP 7283
#define IDS_CONTENT_CONTEXT_CONTROLS 7284
#define IDS_CONTENT_CONTEXT_ROTATECW 7285
#define IDS_CONTENT_CONTEXT_ROTATECCW 7286
#define IDS_CONTENT_CONTEXT_SAVEVIDEOAS 7287
#define IDS_CONTENT_CONTEXT_COPYVIDEOLOCATION 7288
#define IDS_CONTENT_CONTEXT_OPENVIDEONEWTAB 7289
#define IDS_CONTENT_CONTEXT_SAVEAUDIOAS 7290
#define IDS_CONTENT_CONTEXT_COPYAUDIOLOCATION 7291
#define IDS_CONTENT_CONTEXT_OPENAUDIONEWTAB 7292
#define IDS_CONTENT_CONTEXT_PICTUREINPICTURE 7293
#define IDS_CONTENT_CONTEXT_UNDO 7294
#define IDS_CONTENT_CONTEXT_REDO 7295
#define IDS_CONTENT_CONTEXT_CUT 7296
#define IDS_CONTENT_CONTEXT_COPY 7297
#define IDS_CONTENT_CONTEXT_PASTE 7298
#define IDS_CONTENT_CONTEXT_PASTE_AND_MATCH_STYLE 7299
#define IDS_CONTENT_CONTEXT_ADD_TO_DICTIONARY 7300
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_MENU_OPTION 7301
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND 7302
#define IDS_CONTENT_CONTEXT_ACCESSIBILITY_LABELS_SEND_ONCE 7303
#define IDS_CONTENT_CONTEXT_SPELLING_ASK_GOOGLE 7304
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_TITLE 7305
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_ENABLE 7306
#define IDS_CONTENT_CONTEXT_SPELLING_BUBBLE_DISABLE 7307
#define IDS_CONTENT_CONTEXT_SPELLING_CHECKING 7308
#define IDS_CONTENT_CONTEXT_SPELLING_NO_SUGGESTIONS_FROM_GOOGLE 7309
#define IDS_CONTENT_CONTEXT_SELECTALL 7310
#define IDS_CONTENT_CONTEXT_PARTIAL_TRANSLATE 7311
#define IDS_CONTENT_CONTEXT_SEARCHWEBFOR 7312
#define IDS_CONTENT_CONTEXT_SEARCHWEBFORIMAGE 7313
#define IDS_CONTENT_CONTEXT_SEARCHLENSFORIMAGE 7314
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT1 7315
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT2 7316
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT3 7317
#define IDS_CONTENT_CONTEXT_LENS_REGION_SEARCH_ALT4 7318
#define IDS_CONTENT_CONTEXT_GOTOURL 7319
#define IDS_CONTENT_CONTEXT_GENERATEPASSWORD 7320
#define IDS_SHARE_MENU_TITLE 7323
#define IDS_CONTENT_CONTEXT_PLUGIN_RUN 7324
#define IDS_CONTENT_CONTEXT_PLUGIN_HIDE 7325
#define IDS_CONTENT_CONTEXT_ENABLE_FLASH 7326
#define IDS_CONTENT_CONTEXT_LANGUAGE_SETTINGS 7327
#define IDS_NEW_TAB 277
#define IDS_NEW_INCOGNITO_TAB 7331
#define IDS_SHOW_AS_TAB 182
#define IDS_NEW_WINDOW 278
#define IDS_NEW_INCOGNITO_WINDOW 279
#define IDS_PIN_TO_START_SCREEN 7332
#define IDS_EDIT2 7333
#define IDS_CUT 298
#define IDS_COPY 299
#define IDS_PASTE 300
#define IDS_DELETE 7334
#define IDS_FIND 291
#define IDS_SAVE_PAGE 292
#define IDS_DISTILL_PAGE 7335
#define IDS_EXIT_DISTILLED_PAGE 7336
#define IDS_MORE_TOOLS_MENU 296
#define IDS_ZOOM_MENU 288
#define IDS_ZOOM_MENU2 7337
#define IDS_ZOOM_PLUS 7338
#define IDS_ZOOM_PLUS2 290
#define IDS_ZOOM_NORMAL 7339
#define IDS_ZOOM_MINUS 7340
#define IDS_ZOOM_MINUS2 289
#define IDS_COPY_URL 7341
#define IDS_OPEN_IN_APP_WINDOW 7342
#define IDS_MOVE_TAB_TO_NEW_WINDOW 7343
#define IDS_TOGGLE_QUICK_COMMANDS 7344
#define IDS_SEARCH_TABS 7345
#define IDS_ACCNAME_ZOOM_PLUS2 7347
#define IDS_ACCNAME_ZOOM_MINUS2 7348
#define IDS_VIEW_SOURCE 7349
#define IDS_FEEDBACK 304
#define IDS_DEV_TOOLS 295
#define IDS_DEV_TOOLS_CONSOLE 7351
#define IDS_DEV_TOOLS_DEVICES 7352
#define IDS_DEV_TOOLS_ELEMENTS 7350
#define IDS_TASK_MANAGER 294
#define IDS_TAKE_SCREENSHOT 7353
#define IDS_RESTORE_ALL_TABS 7354
#define IDS_RESTORE_TAB 7355
#define IDS_REOPEN_WINDOW 7356
#define IDS_REOPEN_GROUP 7357
#define IDS_RESTORE_WINDOW 7358
#define IDS_RESTORE_GROUP 7359
#define IDS_NAME_WINDOW 7360
#define IDS_PREFERENCES 105
#define IDS_TOS_NOTIFICATION_TITLE 7362
#define IDS_TOS_NOTIFICATION_BODY_TEXT 7363
#define IDS_TOS_NOTIFICATION_ACK_BUTTON_TEXT 7364
#define IDS_TOS_NOTIFICATION_REVIEW_BUTTON_TEXT 7365
#define IDS_TOS_NOTIFICATION_LINK 7366
#define IDS_HELP_MENU 305
#define IDS_MANAGED 7367
#define IDS_MANAGED_BY 7368
#define IDS_CHROME_TIPS 7369
#define IDS_CHROME_WHATS_NEW 7370
#define IDS_IMPORT_SETTINGS_MENU_LABEL 287
#define IDS_PROFILING_ENABLED 7371
#define IDS_FULLSCREEN 7372
#define IDS_CLEAR_BROWSING_DATA 106
#define IDS_SHOW_DOWNLOADS 284
#define IDS_SHOW_EXTENSIONS 293
#define IDS_SETTINGS 301
#define IDS_OPTIONS 7373
#define IDS_HELP_PAGE 303
#define IDS_BETA_FORUM 7374
#define IDS_GET_HELP 7375
#define IDS_EXIT 7376
#define IDS_AUTOCOMPLETE_MATCH_DESCRIPTION_SEPARATOR 362
#define IDS_MANAGE_SEARCH_ENGINES 7377
#define IDS_MANAGE_SEARCH_ENGINES_AND_SITE_SEARCH 7378
#define IDS_SEARCH_ENGINES_EDITOR_KEYWORD_COLUMN 7379
#define IDS_SEARCH_ENGINES_EDITOR_DESCRIPTION_COLUMN 7380
#define IDS_SEARCH_ENGINES_EDITOR_DEFAULT_ENGINE 7381
#define IDS_ACCNAME_DOWNLOADS_BAR 7382
#define IDS_HIDE_DOWNLOADS 7383
#define IDS_SHOW_ALL_DOWNLOADS 7384
#define IDS_DOWNLOAD_STARTED 7385
#define IDS_DOWNLOAD_INTERRUPTED_STATUS 7386
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_ACCESS_DENIED 7387
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_ACCESS_DENIED 7388
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_PATH_TOO_LONG 7389
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_PATH_TOO_LONG 7390
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_DISK_FULL 7391
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_DISK_FULL 7392
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_LARGE 7393
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_LARGE 7394
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_TEMPORARY_PROBLEM 7395
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_TEMPORARY_PROBLEM 7396
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_VIRUS 7397
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_VIRUS 7398
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_BLOCKED 7399
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_BLOCKED 7400
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CONTENT_LENGTH_MISMATCH 7401
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CONTENT_LENGTH_MISMATCH 7402
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SECURITY_CHECK_FAILED 7403
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SECURITY_CHECK_FAILED 7404
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_TOO_SHORT 7405
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_TOO_SHORT 7406
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FILE_SAME_AS_SOURCE 7407
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FILE_SAME_AS_SOURCE 7408
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_TIMEOUT 7409
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_TIMEOUT 7410
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_DISCONNECTED 7411
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_DISCONNECTED 7412
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_DOWN 7413
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_DOWN 7414
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NETWORK_ERROR 7415
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NETWORK_ERROR 7416
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_NO_FILE 7417
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_NO_FILE 7418
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_PROBLEM 7419
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_PROBLEM 7420
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_WEB_DRIVE_ERROR 7421
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SHUTDOWN 7422
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SHUTDOWN 7423
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_CRASH 7424
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_CRASH 7425
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNAUTHORIZED 7426
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNAUTHORIZED 7427
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_SERVER_CERT_PROBLEM 7428
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_SERVER_CERT_PROBLEM 7429
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_FORBIDDEN 7430
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_FORBIDDEN 7431
#define IDS_DOWNLOAD_INTERRUPTED_STATUS_UNREACHABLE 7432
#define IDS_DOWNLOAD_INTERRUPTED_DESCRIPTION_UNREACHABLE 7433
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN_WHEN_COMPLETE 7434
#define IDS_DOWNLOAD_NOTIFICATION_LABEL_OPEN 7435
#define IDS_DOWNLOAD_STATUS_STARTING 7436
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS 7446
#define IDS_DOWNLOAD_STATUS_SIZES 7447
#define IDS_DOWNLOAD_STATUS_OPEN_IN 7448
#define IDS_DOWNLOAD_STATUS_OPEN_WHEN_COMPLETE 7449
#define IDS_DOWNLOAD_STATUS_OPENING 7450
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_SHORT 7451
#define IDS_DOWNLOAD_STATUS_CANCELLED 7452
#define IDS_DOWNLOAD_STATUS_REMOVED 7453
#define IDS_DOWNLOAD_STATUS_UPLOADING 7454
#define IDS_DOWNLOAD_STATUS_UPLOADED 7455
#define IDS_DOWNLOAD_STATUS_UPLOAD_INTERRUPTED 7456
#define IDS_DOWNLOAD_STATUS_INTERRUPTED 7457
#define IDS_DOWNLOAD_UNCONFIRMED_PREFIX 7458
#define IDS_PROMPT_DANGEROUS_DOWNLOAD 7459
#define IDS_PROMPT_DANGEROUS_DOWNLOAD_EXTENSION 7460
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT 7461
#define IDS_PROMPT_UNCOMMON_DOWNLOAD_CONTENT_IN_ADVANCED_PROTECTION 7462
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD 7463
#define IDS_PROMPT_DEEP_SCANNING_DOWNLOAD_SHORT 7464
#define IDS_PROMPT_DEEP_SCANNING_APP_DOWNLOAD 7465
#define IDS_PROMPT_CONFIRM_MIXED_CONTENT_DOWNLOAD 7466
#define IDS_PROMPT_DOWNLOAD_BLOCKED_TOO_LARGE 7467
#define IDS_PROMPT_DOWNLOAD_BLOCKED_PASSWORD_PROTECTED 7468
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_SAFE 7469
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_WARNING 7470
#define IDS_PROMPT_DOWNLOAD_SENSITIVE_CONTENT_BLOCKED 7471
#define IDS_PROMPT_DOWNLOAD_DEEP_SCANNED_OPENED_DANGEROUS 7472
#define IDS_PROMPT_DOWNLOAD_MIXED_CONTENT_WARNING 7473
#define IDS_PROMPT_DOWNLOAD_MIXED_CONTENT_BLOCKED 7474
#define IDS_PROMPT_APP_DEEP_SCANNING 7475
#define IDS_PROMPT_DEEP_SCANNING 7476
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD 7477
#define IDS_BLOCK_REASON_UNCOMMON_DOWNLOAD_IN_ADVANCED_PROTECTION 7478
#define IDS_BLOCK_REASON_GENERIC_DOWNLOAD 7479
#define IDS_BLOCK_REASON_MIXED_CONTENT 7480
#define IDS_BLOCK_REASON_DEEP_SCANNING 7481
#define IDS_BLOCK_REASON_ACCOUNT_COMPROMISE 7482
#define IDS_DEEP_SCANNED_SAFE_DESCRIPTION 7483
#define IDS_DEEP_SCANNED_OPENED_DANGEROUS_DESCRIPTION 7484
#define IDS_BLOCK_REASON_SENSITIVE_CONTENT_WARNING 7485
#define IDS_SENSITIVE_CONTENT_BLOCKED_DESCRIPTION 7486
#define IDS_BLOCKED_TOO_LARGE_DESCRIPTION 7487
#define IDS_BLOCKED_PASSWORD_PROTECTED_DESCRIPTION 7488
#define IDS_CONFIRM_KEEP_DANGEROUS_DOWNLOAD_TITLE 7492
#define IDS_KEEP_DANGEROUS_DOWNLOAD_TITLE 7493
#define IDS_KEEP_UNCOMMON_DOWNLOAD_TITLE 7494
#define IDS_PROMPT_CONFIRM_KEEP_DANGEROUS_DOWNLOAD 7495
#define IDS_PROMPT_CONFIRM_KEEP_MALICIOUS_DOWNLOAD_BODY 7496
#define IDS_CONFIRM_DOWNLOAD_AGAIN 7497
#define IDS_CONFIRM_DOWNLOAD 7498
#define IDS_CONFIRM_DOWNLOAD_RESTORE 7499
#define IDS_CONTINUE_EXTENSION_DOWNLOAD 7500
#define IDS_DISCARD_DOWNLOAD 7501
#define IDS_OPEN_DOWNLOAD_NOW 7502
#define IDS_SCAN_DOWNLOAD 7503
#define IDS_REVIEW_DOWNLOAD 7504
#define IDS_DOWNLOAD_LINK_PAUSE 7505
#define IDS_DOWNLOAD_SEARCH 7506
#define IDS_DOWNLOAD_NO_DOWNLOADS 7507
#define IDS_DOWNLOAD_ITEM_DROPDOWN_BUTTON_ACCESSIBLE_TEXT 7508
#define IDS_DOWNLOAD_LINK_RESUME 7509
#define IDS_DOWNLOAD_LINK_REMOVE 7510
#define IDS_DOWNLOAD_LINK_REMOVE_ARIA_LABEL 7511
#define IDS_DOWNLOAD_LINK_CANCEL 7512
#define IDS_DOWNLOAD_LINK_RETRY 7513
#define IDS_DOWNLOAD_LINK_SHOW_IN_WEB_DRIVE 7514
#define IDS_DOWNLOAD_LINK_SHOW 7515
#define IDS_DOWNLOAD_TAB_CANCELLED 7516
#define IDS_DOWNLOAD_FILE_REMOVED 7517
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS_TIME_UNKNOWN 7518
#define IDS_DOWNLOAD_TAB_PROGRESS_STATUS 7519
#define IDS_DOWNLOAD_TAB_PROGRESS_SIZE 7520
#define IDS_DOWNLOAD_PROGRESS_PAUSED 7521
#define IDS_DOWNLOAD_LINK_CLEAR_ALL 7522
#define IDS_DOWNLOAD_LINK_OPEN_DOWNLOADS_FOLDER 7523
#define IDS_DOWNLOAD_MORE_ACTIONS 7524
#define IDS_DOWNLOAD_ACTION_MENU_DESCRIPTION 7525
#define IDS_DOWNLOAD_BY_EXTENSION_URL 7526
#define IDS_DOWNLOAD_IN_INCOGNITO 7527
#define IDS_UNDO_DESCRIPTION 7528
#define IDS_DOWNLOAD_UNDO 7529
#define IDS_DOWNLOAD_TOAST_REMOVED_FROM_LIST 7530
#define IDS_DOWNLOAD_TOAST_CLEARED_ALL 7531
#define IDS_DOWNLOAD_STATUS_IN_PROGRESS_ACCESSIBLE_ALERT 7532
#define IDS_DOWNLOAD_STATUS_PERCENT_COMPLETE_ACCESSIBLE_ALERT 7533
#define IDS_DOWNLOAD_STATUS_TIME_REMAINING_ACCESSIBLE_ALERT 7534
#define IDS_DOWNLOAD_FAILED_ACCESSIBLE_ALERT 7535
#define IDS_DOWNLOAD_CANCELLED_ACCESSIBLE_ALERT 7536
#define IDS_DOWNLOAD_COMPLETE_ACCESSIBLE_ALERT 7537
#define IDS_PROMPT_APP_DEEP_SCANNING_ACCESSIBLE_ALERT 7538
#define IDS_PROMPT_DEEP_SCANNING_ACCESSIBLE_ALERT 7539
#define IDS_DEEP_SCANNING_ACCESSIBLE_ALERT 7540
#define IDS_PROMPT_DOWNLOAD_MIXED_CONTENT_BLOCKED_ACCESSIBLE_ALERT 7541
#define IDS_DOWNLOAD_NOTIFICATION_COPY_TO_CLIPBOARD 7542
#define IDS_DOWNLOAD_MENU_SHOW 7543
#define IDS_DOWNLOAD_MENU_OPEN_WHEN_COMPLETE 7544
#define IDS_DOWNLOAD_MENU_OPEN 7545
#define IDS_DOWNLOAD_MENU_ALWAYS_OPEN_TYPE 7546
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN 7547
#define IDS_DOWNLOAD_MENU_PLATFORM_OPEN_ALWAYS 7548
#define IDS_DOWNLOAD_MENU_CANCEL 7549
#define IDS_DOWNLOAD_MENU_PAUSE_ITEM 7550
#define IDS_DOWNLOAD_MENU_RESUME_ITEM 7551
#define IDS_DOWNLOAD_MENU_DISCARD 7552
#define IDS_DOWNLOAD_MENU_KEEP 7553
#define IDS_DOWNLOAD_MENU_LEARN_MORE_SCANNING 7554
#define IDS_DOWNLOAD_MENU_LEARN_MORE_INTERRUPTED 7555
#define IDS_DOWNLOAD_MENU_LEARN_MORE_MIXED_CONTENT 7556
#define IDS_DOWNLOAD_MENU_DEEP_SCAN 7558
#define IDS_CUSTOMIZE_TOUCH_BAR 7559
#define IDS_TOUCH_BAR_GOOGLE_SEARCH 7560
#define IDS_TOUCH_BAR_NO_DEFAULT_SEARCH 7561
#define IDS_TOUCH_BAR_SEARCH 7562
#define IDS_TOUCH_BAR_BACK_FORWARD_CUSTOMIZATION_LABEL 7563
#define IDS_TOUCH_BAR_STOP_RELOAD_CUSTOMIZATION_LABEL 7564
#define IDS_TOUCH_BAR_HOME_CUSTOMIZATION_LABEL 7565
#define IDS_TOUCH_BAR_BOOKMARK_CUSTOMIZATION_LABEL 7566
#define IDS_TOUCH_BAR_NEW_TAB_CUSTOMIZATION_LABEL 7567
#define IDS_TOUCH_BAR_URL_CUSTOMIZATION_LABEL 7568
#define IDS_ABANDON_DOWNLOAD_DIALOG_TITLE 7569
#define IDS_ABANDON_DOWNLOAD_DIALOG_CONTINUE_BUTTON 7570
#define IDS_ABANDON_DOWNLOAD_DIALOG_INCOGNITO_MESSAGE 7571
#define IDS_ABANDON_DOWNLOAD_DIALOG_GUEST_MESSAGE 7572
#define IDS_ABANDON_DOWNLOAD_DIALOG_EXIT_BUTTON 7573
#define IDS_DOWNLOAD_BUBBLE_HEADER_TEXT 7574
#define IDS_DOWNLOAD_BUBBLE_FOOTER_LINK 7575
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_MESSAGE_WITH_SEPARATOR 7576
#define IDS_DOWNLOAD_BUBBLE_DOWNLOAD_STATUS_WITH_SYMBOL 7577
#define IDS_DOWNLOAD_BUBBLE_STATUS_RESUMING 7578
#define IDS_DOWNLOAD_BUBBLE_STATUS_DONE 7579
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_DONE 7580
#define IDS_DOWNLOAD_BUBBLE_STATUS_BLOCKED 7581
#define IDS_DOWNLOAD_BUBBLE_STATUS_MALWARE 7582
#define IDS_DOWNLOAD_BUBBLE_CHECKBOX_BYPASS 7583
#define IDS_DOWNLOAD_BUBBLE_CONTINUE 7584
#define IDS_DOWNLOAD_BUBBLE_DELETE 7585
#define IDS_DOWNLOAD_BUBBLE_RESUME 7586
#define IDS_DOWNLOAD_BUBBLE_SCAN 7587
#define IDS_DOWNLOAD_BUBBLE_OPEN 7588
#define IDS_DOWNLOAD_BUBBLE_OPEN_NOW 7589
#define IDS_DOWNLOAD_BUBBLE_REVIEW 7590
#define IDS_DOWNLOAD_BUBBLE_RETRY 7591
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_DISK_FULL 7592
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_DISK_FULL 7593
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_PATH_TOO_LONG 7594
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_PATH_TOO_LONG 7595
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NEEDS_PERMISSION 7596
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_TOO_LARGE 7597
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_TOO_LARGE 7598
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_UNFINISHED 7599
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_BLOCKED_ORGANIZATION 7600
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_BLOCKED_ORGANIZATION 7601
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_WRONG 7602
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_NETWORK_ERROR 7603
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_SITE_UNAVAILABLE 7604
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNAVAILABLE 7605
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_SUBPAGE_SUMMARY_FILE_UNAVAILABLE 7606
#define IDS_DOWNLOAD_BUBBLE_INTERRUPTED_STATUS_FILE_UNFINISHED 7607
#define IDS_DOWNLOAD_BUBBLE_WARNING_STATUS_INSECURE 7608
#define IDS_DOWNLOAD_BUBBLE_WARNING_SUBPAGE_SUMMARY_INSECURE 7609
#define IDS_DOWNLOAD_BUBBLE_STATUS_DANGEROUS 7610
#define IDS_DOWNLOAD_BUBBLE_STATUS_ENCRYPTED 7611
#define IDS_DOWNLOAD_BUBBLE_STATUS_TOO_BIG 7612
#define IDS_DOWNLOAD_BUBBLE_STATUS_ADVANCED_PROTECTION 7613
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ADVANCED_PROTECTION 7614
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNCOMMON_FILE 7615
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_UNCOMMON_FILE 7616
#define IDS_DOWNLOAD_BUBBLE_STATUS_UNKNOWN_SOURCE 7617
#define IDS_DOWNLOAD_BUBBLE_STATUS_SENSITIVE_CONTENT 7618
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_WARNING 7619
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_SENSITIVE_CONTENT_BLOCK 7620
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_ENCRYPTED 7621
#define IDS_DOWNLOAD_BUBBLE_SUBPAGE_SUMMARY_TOO_BIG 7622
#define IDS_DOWNLOAD_BUBBLE_TRY_AGAIN 7623
#define IDS_DOWNLOAD_BUBBLE_STATUS_DEEP_SCANNING_PROMPT 7624
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING 7625
#define IDS_DOWNLOAD_BUBBLE_STATUS_ASYNC_SCANNING_ENTERPRISE 7626
#define IDS_DOWNLOAD_BUBBLE_INCOGNITO_INFORMATION_ROW 7627
#define IDS_DOWNLOAD_BUBBLE_RESUME_QUICK_ACTION 7628
#define IDS_DOWNLOAD_BUBBLE_PAUSE_QUICK_ACTION 7629
#define IDS_DOWNLOAD_BUBBLE_CANCEL_QUICK_ACTION 7630
#define IDS_DOWNLOAD_BUBBLE_OPEN_QUICK_ACTION 7631
#define IDS_DOWNLOAD_BUBBLE_SHOW_IN_FOLDER_QUICK_ACTION 7632
#define IDS_OMNIBOX_PWA_INSTALL_ICON_LABEL 7633
#define IDS_OMNIBOX_PWA_INSTALL_ICON_TOOLTIP 7634
#define IDS_ADD_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 7635
#define IDS_CREATE_SHORTCUTS_BUTTON_LABEL 7636
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE_BUBBLE_TITLE 7637
#define IDS_INSTALL_PWA_BUTTON_LABEL 7638
#define IDS_BOOKMARK_APP_AX_BUBBLE_NAME_LABEL 7639
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TAB 7640
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_WINDOW 7641
#define IDS_BOOKMARK_APP_BUBBLE_OPEN_AS_TABBED_WINDOW 7642
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME 7643
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_ICON 7644
#define IDS_WEBAPP_UPDATE_DIALOG_TITLE_NAME_AND_ICON 7645
#define IDS_WEBAPP_UPDATE_EXPLANATION 7646
#define IDS_WEBAPP_UPDATE_CURRENT_ICON 7647
#define IDS_WEBAPP_UPDATE_NEW_ICON 7648
#define IDS_WEBAPP_UPDATE_NEGATIVE_BUTTON 7649
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION 7650
#define IDS_FINISH_POLICY_WEB_APP_INSTALATION_RESTART 7651
#define IDS_FINISH_POLICY_WEB_APP_INSTALLATION_NOT_NOW 7652
#define IDS_QUIT_WITH_APPS_NOTIFICATION_DISPLAY_SOURCE 337
#define IDS_QUIT_WITH_APPS_EXPLANATION 335
#define IDS_QUIT_WITH_APPS_QUIT_LABEL 332
#define IDS_QUIT_WITH_APPS_SUPPRESSION_LABEL 333
#define IDS_ADD_TO_OS_LAUNCH_SURFACE 7653
#define IDS_INSTALL_TO_OS_LAUNCH_SURFACE 7654
#define IDS_UNINSTALL_FROM_OS_LAUNCH_SURFACE 7655
#define IDS_APPLICATION_INFO_WEB_STORE_LINK 7656
#define IDS_APPLICATION_INFO_HOMEPAGE_LINK 7657
#define IDS_APPLICATION_INFO_APP_OVERVIEW_TITLE 7659
#define IDS_APPLICATION_INFO_APP_PERMISSIONS_TITLE 7660
#define IDS_APPLICATION_INFO_UNINSTALL_BUTTON_TEXT 7661
#define IDS_APPLICATION_INFO_LICENSES_BUTTON_TEXT 7662
#define IDS_APPLICATION_INFO_SIZE_LABEL 7663
#define IDS_APPLICATION_INFO_VERSION_LABEL 7664
#define IDS_APPLICATION_INFO_CREATE_SHORTCUTS_BUTTON_TEXT 7665
#define IDS_APPLICATION_INFO_LAUNCH_OPTIONS_ACCNAME 7666
#define IDS_APPLICATION_INFO_SIZE_LOADING_LABEL 7667
#define IDS_APPLICATION_INFO_SIZE_SMALL_LABEL 7668
#define IDS_APPLICATION_INFO_REVOKE_PERMISSION_ALT_TEXT 7669
#define IDS_APPLICATION_INFO_APP_NO_PERMISSIONS_TEXT 7670
#define IDS_APPLICATION_INFO_EXTENSION_NO_PERMISSIONS_TEXT 7671
#define IDS_APPLICATION_INFO_RETAINED_FILES 7672
#define IDS_APPLICATION_INFO_RETAINED_DEVICES 7673
#define IDS_MANAGE 7688
#define IDS_LIST_BULLET 7689
#define IDS_BLOCKED_DOWNLOAD_NO_ACTION 7690
#define IDS_BLOCKED_DOWNLOAD_UNBLOCK 7691
#define IDS_ALLOWED_DOWNLOAD_TITLE 7692
#define IDS_BLOCKED_DOWNLOAD_TITLE 7693
#define IDS_BLOCKED_DOWNLOADS_EXPLANATION 7694
#define IDS_ALLOWED_DOWNLOAD_NO_ACTION 7695
#define IDS_ALLOWED_DOWNLOAD_BLOCK 7696
#define IDS_BLOCKED_COOKIES_TITLE 7697
#define IDS_ACCESSED_COOKIES_TITLE 7698
#define IDS_BLOCKED_COOKIES_MESSAGE 7699
#define IDS_ACCESSED_COOKIES_MESSAGE 7700
#define IDS_BLOCKED_COOKIES_INFO 7701
#define IDS_BLOCKED_IMAGES_TITLE 7702
#define IDS_BLOCKED_IMAGES_MESSAGE 7703
#define IDS_BLOCKED_COOKIES_UNBLOCK 7704
#define IDS_BLOCKED_IMAGES_UNBLOCK 7705
#define IDS_BLOCKED_COOKIES_NO_ACTION 7706
#define IDS_ALLOWED_COOKIES_NO_ACTION 7707
#define IDS_ALLOWED_COOKIES_BLOCK 7708
#define IDS_BLOCKED_IMAGES_NO_ACTION 7709
#define IDS_BLOCKED_POPUPS_TOOLTIP 7710
#define IDS_BLOCKED_POPUPS_TITLE 7711
#define IDS_BLOCKED_POPUPS_REDIRECTS_UNBLOCK 7712
#define IDS_BLOCKED_POPUPS_REDIRECTS_NO_ACTION 7713
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ALLOW 7714
#define IDS_BLOCKED_MEDIASTREAM_MIC_ALLOW 7715
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ALLOW 7716
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_ASK 7717
#define IDS_BLOCKED_MEDIASTREAM_MIC_ASK 7718
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_ASK 7719
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_BLOCK 7720
#define IDS_ALLOWED_MEDIASTREAM_MIC_BLOCK 7721
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_BLOCK 7722
#define IDS_BLOCKED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 7723
#define IDS_BLOCKED_MEDIASTREAM_MIC_NO_ACTION 7724
#define IDS_BLOCKED_MEDIASTREAM_CAMERA_NO_ACTION 7725
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_NO_ACTION 7726
#define IDS_ALLOWED_MEDIASTREAM_MIC_AND_CAMERA_PAN_TILT_ZOOM_NO_ACTION 7727
#define IDS_ALLOWED_MEDIASTREAM_MIC_NO_ACTION 7728
#define IDS_ALLOWED_MEDIASTREAM_CAMERA_NO_ACTION 7729
#define IDS_ALLOWED_CAMERA_PAN_TILT_ZOOM_NO_ACTION 7730
#define IDS_BLOCKED_POPUPS_EXPLANATORY_TEXT 7731
#define IDS_BLOCKED_JAVASCRIPT_TITLE 7732
#define IDS_BLOCKED_JAVASCRIPT_MESSAGE 7733
#define IDS_BLOCKED_JAVASCRIPT_UNBLOCK 7734
#define IDS_BLOCKED_JAVASCRIPT_NO_ACTION 7735
#define IDS_BLOCKED_SOUND_TITLE 7736
#define IDS_BLOCKED_SOUND_UNBLOCK 7737
#define IDS_BLOCKED_SOUND_NO_ACTION 7738
#define IDS_NOTIFICATIONS_OFF_EXPLANATORY_TEXT 7739
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_TITLE 7740
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DESCRIPTION 7741
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 7742
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_COMPACT_ALLOW_BUTTON 7743
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CONTINUE_BLOCKING_BUTTON 7744
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_EARLY_PROMO 7745
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_NEW_REQUEST_PROMO 7746
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_CROWD_DENY_DESCRIPTION 7747
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_ABUSIVE_DESCRIPTION 7748
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_DISRUPTIVE_DESCRIPTION 7749
#define IDS_NOTIFICATIONS_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 7750
#define IDS_GEOLOCATION_OFF_EXPLANATORY_TEXT 7751
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_TITLE 7752
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_PREDICTION_SERVICE_DESCRIPTION 7753
#define IDS_GEOLOCATION_QUIET_PERMISSION_BUBBLE_ALLOW_BUTTON 7754
#define IDS_COOKIE_CONTROLS_DIALOG_TITLE 7755
#define IDS_COOKIE_CONTROLS_DIALOG_TITLE_ALL_BLOCKED 7756
#define IDS_COOKIE_CONTROLS_DIALOG_TITLE_OFF 7757
#define IDS_COOKIE_CONTROLS_TURN_ON_BUTTON 7758
#define IDS_COOKIE_CONTROLS_TURN_OFF_BUTTON 7759
#define IDS_COOKIE_CONTROLS_NOT_WORKING_TITLE 7760
#define IDS_COOKIE_CONTROLS_NOT_WORKING_DESCRIPTION 7761
#define IDS_COOKIE_CONTROLS_BLOCKED_MESSAGE 7762
#define IDS_COOKIE_CONTROLS_TOOLTIP 7763
#define IDS_COOKIE_CONTROLS_HELP 7764
#define IDS_CERT_SELECTOR_SUBJECT_COLUMN 7765
#define IDS_CERT_SELECTOR_ISSUER_COLUMN 7766
#define IDS_CERT_SELECTOR_PROVIDER_COLUMN 7767
#define IDS_CERT_SELECTOR_SERIAL_COLUMN 7768
#define IDS_CERT_EXPORT_TYPE_BASE64 7769
#define IDS_CERT_EXPORT_TYPE_BASE64_CHAIN 7770
#define IDS_CERT_EXPORT_TYPE_DER 7771
#define IDS_CERT_EXPORT_TYPE_PKCS7 7772
#define IDS_CERT_EXPORT_TYPE_PKCS7_CHAIN 7773
#define IDS_CERT_INFO_DIALOG_TITLE 7774
#define IDS_CERT_INFO_GENERAL_TAB_LABEL 7775
#define IDS_CERT_INFO_DETAILS_TAB_LABEL 7776
#define IDS_CERT_USAGE_SSL_CLIENT 7777
#define IDS_CERT_USAGE_SSL_SERVER 7778
#define IDS_CERT_USAGE_OBJECT_SIGNER 7779
#define IDS_CERT_USAGE_SSL_CA 7780
#define IDS_CERT_INFO_IDN_VALUE_FORMAT 7781
#define IDS_CERT_INFO_FIELD_NOT_PRESENT 7782
#define IDS_CERT_DETAILS_CERTIFICATE_HIERARCHY_LABEL 7783
#define IDS_CERT_DETAILS_CERTIFICATE_FIELDS_LABEL 7784
#define IDS_CERT_DETAILS_CERTIFICATE_FIELD_VALUE_LABEL 7785
#define IDS_CERT_DETAILS_CERTIFICATE 7786
#define IDS_CERT_DETAILS_VERSION 7787
#define IDS_CERT_DETAILS_VERSION_FORMAT 7788
#define IDS_CERT_DETAILS_SERIAL_NUMBER 7789
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_ALG 7790
#define IDS_CERT_DETAILS_ISSUER 7791
#define IDS_CERT_DETAILS_VALIDITY 7792
#define IDS_CERT_DETAILS_NOT_BEFORE 7793
#define IDS_CERT_DETAILS_NOT_AFTER 7794
#define IDS_CERT_DETAILS_SUBJECT 7795
#define IDS_CERT_DETAILS_SUBJECT_KEY_INFO 7796
#define IDS_CERT_DETAILS_SUBJECT_KEY_ALG 7797
#define IDS_CERT_DETAILS_SUBJECT_KEY 7798
#define IDS_CERT_RSA_PUBLIC_KEY_DUMP_FORMAT 7799
#define IDS_CERT_DETAILS_CERTIFICATE_SIG_VALUE 7800
#define IDS_CERT_DETAILS_EXPORT_CERTIFICATE 7801
#define IDS_CERT_OID_AVA_COMMON_NAME 7802
#define IDS_CERT_OID_AVA_STATE_OR_PROVINCE 7803
#define IDS_CERT_OID_AVA_ORGANIZATION_NAME 7804
#define IDS_CERT_OID_AVA_ORGANIZATIONAL_UNIT_NAME 7805
#define IDS_CERT_OID_AVA_DN_QUALIFIER 7806
#define IDS_CERT_OID_AVA_COUNTRY_NAME 7807
#define IDS_CERT_OID_AVA_SERIAL_NUMBER 7808
#define IDS_CERT_OID_AVA_LOCALITY 7809
#define IDS_CERT_OID_AVA_DC 7810
#define IDS_CERT_OID_RFC1274_MAIL 7811
#define IDS_CERT_OID_RFC1274_UID 7812
#define IDS_CERT_OID_PKCS9_EMAIL_ADDRESS 7813
#define IDS_CERT_OID_BUSINESS_CATEGORY 7814
#define IDS_CERT_OID_EV_INCORPORATION_LOCALITY 7815
#define IDS_CERT_OID_EV_INCORPORATION_STATE 7816
#define IDS_CERT_OID_EV_INCORPORATION_COUNTRY 7817
#define IDS_CERT_OID_AVA_STREET_ADDRESS 7818
#define IDS_CERT_OID_AVA_POSTAL_CODE 7819
#define IDS_CERT_OID_PKCS1_RSA_ENCRYPTION 7820
#define IDS_CERT_OID_PKCS1_MD2_WITH_RSA_ENCRYPTION 7821
#define IDS_CERT_OID_PKCS1_MD4_WITH_RSA_ENCRYPTION 7822
#define IDS_CERT_OID_PKCS1_MD5_WITH_RSA_ENCRYPTION 7823
#define IDS_CERT_OID_PKCS1_SHA1_WITH_RSA_ENCRYPTION 7824
#define IDS_CERT_OID_PKCS1_SHA256_WITH_RSA_ENCRYPTION 7825
#define IDS_CERT_OID_PKCS1_SHA384_WITH_RSA_ENCRYPTION 7826
#define IDS_CERT_OID_PKCS1_SHA512_WITH_RSA_ENCRYPTION 7827
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA1_SIGNATURE 7828
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA256_SIGNATURE 7829
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA384_SIGNATURE 7830
#define IDS_CERT_OID_ANSIX962_ECDSA_SHA512_SIGNATURE 7831
#define IDS_CERT_OID_ANSIX962_EC_PUBLIC_KEY 7832
#define IDS_CERT_OID_SECG_EC_SECP256R1 7833
#define IDS_CERT_OID_SECG_EC_SECP384R1 7834
#define IDS_CERT_OID_SECG_EC_SECP521R1 7835
#define IDS_CERT_EXT_NS_CERT_TYPE 7836
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL 7837
#define IDS_CERT_EXT_NS_CERT_TYPE_EMAIL_CA 7838
#define IDS_CERT_EXT_NS_CERT_BASE_URL 7839
#define IDS_CERT_EXT_NS_CERT_REVOCATION_URL 7840
#define IDS_CERT_EXT_NS_CA_REVOCATION_URL 7841
#define IDS_CERT_EXT_NS_CERT_RENEWAL_URL 7842
#define IDS_CERT_EXT_NS_CA_POLICY_URL 7843
#define IDS_CERT_EXT_NS_SSL_SERVER_NAME 7844
#define IDS_CERT_EXT_NS_COMMENT 7845
#define IDS_CERT_EXT_NS_LOST_PASSWORD_URL 7846
#define IDS_CERT_EXT_NS_CERT_RENEWAL_TIME 7847
#define IDS_CERT_X509_SUBJECT_DIRECTORY_ATTR 7848
#define IDS_CERT_X509_SUBJECT_KEYID 7849
#define IDS_CERT_KEYID_FORMAT 7850
#define IDS_CERT_ISSUER_FORMAT 7851
#define IDS_CERT_SERIAL_NUMBER_FORMAT 7852
#define IDS_CERT_X509_KEY_USAGE 7853
#define IDS_CERT_X509_ISSUER_ALT_NAME 7854
#define IDS_CERT_X509_BASIC_CONSTRAINTS 7855
#define IDS_CERT_X509_NAME_CONSTRAINTS 7856
#define IDS_CERT_X509_CRL_DIST_POINTS 7857
#define IDS_CERT_X509_CERT_POLICIES 7858
#define IDS_CERT_X509_POLICY_MAPPINGS 7859
#define IDS_CERT_X509_POLICY_CONSTRAINTS 7860
#define IDS_CERT_X509_AUTH_KEYID 7861
#define IDS_CERT_X509_EXT_KEY_USAGE 7862
#define IDS_CERT_X509_AUTH_INFO_ACCESS 7863
#define IDS_CERT_X509_KEY_USAGE_SIGNING 7864
#define IDS_CERT_X509_KEY_USAGE_NONREP 7865
#define IDS_CERT_X509_KEY_USAGE_ENCIPHERMENT 7866
#define IDS_CERT_X509_KEY_USAGE_DATA_ENCIPHERMENT 7867
#define IDS_CERT_X509_KEY_USAGE_KEY_AGREEMENT 7868
#define IDS_CERT_X509_KEY_USAGE_CERT_SIGNER 7869
#define IDS_CERT_X509_KEY_USAGE_CRL_SIGNER 7870
#define IDS_CERT_X509_KEY_USAGE_ENCIPHER_ONLY 7871
#define IDS_CERT_X509_KEY_USAGE_DECIPHER_ONLY 7872
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_CA 7873
#define IDS_CERT_X509_BASIC_CONSTRAINT_IS_NOT_CA 7874
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN 7875
#define IDS_CERT_X509_BASIC_CONSTRAINT_PATH_LEN_UNLIMITED 7876
#define IDS_CERT_PKIX_CPS_POINTER_QUALIFIER 7877
#define IDS_CERT_PKIX_USER_NOTICE_QUALIFIER 7878
#define IDS_CERT_REVOCATION_REASON_UNUSED 7879
#define IDS_CERT_REVOCATION_REASON_KEY_COMPROMISE 7880
#define IDS_CERT_REVOCATION_REASON_CA_COMPROMISE 7881
#define IDS_CERT_REVOCATION_REASON_AFFILIATION_CHANGED 7882
#define IDS_CERT_REVOCATION_REASON_SUPERSEDED 7883
#define IDS_CERT_REVOCATION_REASON_CESSATION_OF_OPERATION 7884
#define IDS_CERT_REVOCATION_REASON_CERTIFICATE_HOLD 7885
#define IDS_CERT_OCSP_RESPONDER_FORMAT 7886
#define IDS_CERT_CA_ISSUERS_FORMAT 7887
#define IDS_CERT_UNKNOWN_OID_INFO_FORMAT 7888
#define IDS_CERT_EXT_KEY_USAGE_FORMAT 7889
#define IDS_CERT_MULTILINE_INFO_START_FORMAT 7890
#define IDS_CERT_GENERAL_NAME_RFC822_NAME 7891
#define IDS_CERT_GENERAL_NAME_DNS_NAME 7892
#define IDS_CERT_GENERAL_NAME_X400_ADDRESS 7893
#define IDS_CERT_GENERAL_NAME_DIRECTORY_NAME 7894
#define IDS_CERT_GENERAL_NAME_EDI_PARTY_NAME 7895
#define IDS_CERT_GENERAL_NAME_URI 7896
#define IDS_CERT_GENERAL_NAME_IP_ADDRESS 7897
#define IDS_CERT_GENERAL_NAME_REGISTERED_ID 7898
#define IDS_CERT_EXT_MS_CERT_TYPE 7899
#define IDS_CERT_EXT_MS_CA_VERSION 7900
#define IDS_CERT_EXT_MS_NT_PRINCIPAL_NAME 7901
#define IDS_CERT_EXT_MS_NTDS_REPLICATION 7902
#define IDS_CERT_EKU_ANY_EKU 7903
#define IDS_CERT_EKU_TLS_WEB_SERVER_AUTHENTICATION 7904
#define IDS_CERT_EKU_TLS_WEB_CLIENT_AUTHENTICATION 7905
#define IDS_CERT_EKU_CODE_SIGNING 7906
#define IDS_CERT_EKU_EMAIL_PROTECTION 7907
#define IDS_CERT_EKU_TIME_STAMPING 7908
#define IDS_CERT_EKU_OCSP_SIGNING 7909
#define IDS_CERT_EKU_MS_INDIVIDUAL_CODE_SIGNING 7910
#define IDS_CERT_EKU_MS_COMMERCIAL_CODE_SIGNING 7911
#define IDS_CERT_EKU_MS_TRUST_LIST_SIGNING 7912
#define IDS_CERT_EKU_MS_TIME_STAMPING 7913
#define IDS_CERT_EKU_MS_SERVER_GATED_CRYPTO 7914
#define IDS_CERT_EKU_MS_ENCRYPTING_FILE_SYSTEM 7915
#define IDS_CERT_EKU_MS_FILE_RECOVERY 7916
#define IDS_CERT_EKU_MS_WINDOWS_HARDWARE_DRIVER_VERIFICATION 7917
#define IDS_CERT_EKU_MS_QUALIFIED_SUBORDINATION 7918
#define IDS_CERT_EKU_MS_KEY_RECOVERY 7919
#define IDS_CERT_EKU_MS_DOCUMENT_SIGNING 7920
#define IDS_CERT_EKU_MS_LIFETIME_SIGNING 7921
#define IDS_CERT_EKU_MS_SMART_CARD_LOGON 7922
#define IDS_CERT_EKU_MS_KEY_RECOVERY_AGENT 7923
#define IDS_CERT_EKU_NETSCAPE_INTERNATIONAL_STEP_UP 7924
#define IDS_CERT_EXTENSION_CRITICAL 7925
#define IDS_CERT_EXTENSION_NON_CRITICAL 7926
#define IDS_CERT_DUMP_ERROR 7927
#define IDS_CERT_EXTENSION_DUMP_ERROR 7928
#define IDS_CERTIFICATE_MANAGER_TITLE 7929
#define IDS_CERT_MANAGER_HARDWARE_BACKED_KEY_FORMAT 7930
#define IDS_CERT_MANAGER_HARDWARE_BACKED 7931
#define IDS_CERT_MANAGER_EXTENSION_PROVIDED_FORMAT 7932
#define IDS_DEV_TOOLS_INFOBAR_LABEL 7933
#define IDS_DEV_TOOLS_CONFIRM_ADD_FILE_SYSTEM_MESSAGE 7934
#define IDS_DEV_TOOLS_CONFIRM_ALLOW_BUTTON 7935
#define IDS_DEV_TOOLS_CONFIRM_DENY_BUTTON 7936
#define IDS_RELOAD_MENU_NORMAL_RELOAD_ITEM 270
#define IDS_RELOAD_MENU_HARD_RELOAD_ITEM 271
#define IDS_RELOAD_MENU_EMPTY_AND_HARD_RELOAD_ITEM 272
#define IDS_TAB_SHARING_INFOBAR_SHARING_CURRENT_TAB_LABEL 7937
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_UNTITLED_TAB_LABEL 7938
#define IDS_TAB_SHARING_INFOBAR_SHARING_ANOTHER_TAB_LABEL 7939
#define IDS_TAB_SHARING_INFOBAR_SHARE_BUTTON 7940
#define IDS_TAB_SHARING_INFOBAR_STOP_BUTTON 7941
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_BUTTON 7942
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURER_BUTTON 7943
#define IDS_TAB_SHARING_INFOBAR_SWITCH_TO_CAPTURED_BUTTON 7944
#define IDS_TASK_MANAGER_KILL 7945
#define IDS_TASK_MANAGER_PROCESS_ID_COLUMN 7946
#define IDS_TASK_MANAGER_GDI_HANDLES_COLUMN 7947
#define IDS_TASK_MANAGER_USER_HANDLES_COLUMN 7948
#define IDS_TASK_MANAGER_NACL_DEBUG_STUB_PORT_COLUMN 7950
#define IDS_TASK_MANAGER_TASK_COLUMN 7949
#define IDS_TASK_MANAGER_NET_COLUMN 7951
#define IDS_TASK_MANAGER_CPU_COLUMN 7952
#define IDS_TASK_MANAGER_START_TIME_COLUMN 7953
#define IDS_TASK_MANAGER_CPU_TIME_COLUMN 7954
#define IDS_TASK_MANAGER_MEM_FOOTPRINT_COLUMN 7955
#define IDS_TASK_MANAGER_SWAPPED_MEM_COLUMN 7956
#define IDS_TASK_MANAGER_PROFILE_NAME_COLUMN 7957
#define IDS_TASK_MANAGER_IDLE_WAKEUPS_COLUMN 7958
#define IDS_TASK_MANAGER_HARD_FAULTS_COLUMN 7959
#define IDS_TASK_MANAGER_OPEN_FD_COUNT_COLUMN 7960
#define IDS_TASK_MANAGER_PROCESS_PRIORITY_COLUMN 7961
#define IDS_TASK_MANAGER_WEBCORE_IMAGE_CACHE_COLUMN 7962
#define IDS_TASK_MANAGER_WEBCORE_SCRIPTS_CACHE_COLUMN 7963
#define IDS_TASK_MANAGER_WEBCORE_CSS_CACHE_COLUMN 7964
#define IDS_TASK_MANAGER_VIDEO_MEMORY_COLUMN 7965
#define IDS_TASK_MANAGER_SQLITE_MEMORY_USED_COLUMN 7966
#define IDS_TASK_MANAGER_JAVASCRIPT_MEMORY_ALLOCATED_COLUMN 7967
#define IDS_TASK_MANAGER_KEEPALIVE_COUNT_COLUMN 7968
#define IDS_TASK_MANAGER_MEM_CELL_TEXT 7969
#define IDS_TASK_MANAGER_CACHE_SIZE_CELL_TEXT 7970
#define IDS_TASK_MANAGER_NA_CELL_TEXT 7971
#define IDS_TASK_MANAGER_BACKGROUNDED_TEXT 7972
#define IDS_TASK_MANAGER_FOREGROUNDED_TEXT 7973
#define IDS_TASK_MANAGER_UNKNOWN_VALUE_TEXT 7974
#define IDS_TASK_MANAGER_DISABLED_NACL_DBG_TEXT 7975
#define IDS_TASK_MANAGER_HANDLES_CELL_TEXT 7976
#define IDS_TASK_MANAGER_WEB_BROWSER_CELL_TEXT 7977
#define IDS_TASK_MANAGER_EXTENSION_PREFIX 7978
#define IDS_TASK_MANAGER_EXTENSION_INCOGNITO_PREFIX 7979
#define IDS_TASK_MANAGER_APP_PREFIX 7980
#define IDS_TASK_MANAGER_APP_INCOGNITO_PREFIX 7981
#define IDS_TASK_MANAGER_TAB_PREFIX 7982
#define IDS_TASK_MANAGER_TAB_INCOGNITO_PREFIX 7983
#define IDS_TASK_MANAGER_BACKGROUND_APP_PREFIX 7984
#define IDS_TASK_MANAGER_BACKGROUND_PREFIX 7985
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_PREFIX 7986
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_PREFIX 7987
#define IDS_TASK_MANAGER_PLUGIN_PREFIX 7988
#define IDS_TASK_MANAGER_PLUGIN_BROKER_PREFIX 7989
#define IDS_TASK_MANAGER_NO_STATE_PREFETCH_PREFIX 7990
#define IDS_TASK_MANAGER_PRERENDER_PREFIX 7991
#define IDS_TASK_MANAGER_SPARE_RENDERER_PREFIX 7992
#define IDS_TASK_MANAGER_UNKNOWN_RENDERER_PREFIX 7993
#define IDS_TASK_MANAGER_DEDICATED_WORKER_PREFIX 7994
#define IDS_TASK_MANAGER_SHARED_WORKER_PREFIX 7995
#define IDS_TASK_MANAGER_SERVICE_WORKER_PREFIX 7996
#define IDS_TASK_MANAGER_UNKNOWN_PLUGIN_NAME 7997
#define IDS_TASK_MANAGER_UTILITY_PREFIX 7998
#define IDS_TASK_MANAGER_NACL_PREFIX 7999
#define IDS_TASK_MANAGER_NACL_BROKER_PREFIX 8000
#define IDS_TASK_MANAGER_GPU_PREFIX 8001
#define IDS_TASK_MANAGER_PRINT_PREFIX 8002
#define IDS_TASK_MANAGER_SUBFRAME_PREFIX 8003
#define IDS_TASK_MANAGER_SUBFRAME_INCOGNITO_PREFIX 8004
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_SUBFRAME_PREFIX 8005
#define IDS_TASK_MANAGER_BACK_FORWARD_CACHE_INCOGNITO_SUBFRAME_PREFIX 8006
#define IDS_TASK_MANAGER_PORTAL_PREFIX 8007
#define IDS_TASK_MANAGER_PORTAL_INCOGNITO_PREFIX 8008
#define IDS_TASK_MANAGER_FENCED_FRAME_PREFIX 8009
#define IDS_TASK_MANAGER_FENCED_FRAME_INCOGNITO_PREFIX 8010
#define IDS_TASK_MANAGER_ARC_PREFIX 8011
#define IDS_TASK_MANAGER_TOOL_PREFIX 8012
#define IDS_TASK_MANAGER_ARC_PREFIX_BACKGROUND_SERVICE 8013
#define IDS_TASK_MANAGER_ARC_PREFIX_RECEIVER 8014
#define IDS_TASK_MANAGER_ARC_SYSTEM 8015
#define IDS_TASK_MANAGER_LINUX_VM_PREFIX 8016
#define IDS_TASK_MANAGER_PLUGIN_VM_PREFIX 8017
#define IDS_UTILITY_PROCESS_FILE_UTILITY_NAME 8019
#define IDS_UTILITY_PROCESS_PROFILE_IMPORTER_NAME 8020
#define IDS_UTILITY_PROCESS_QRCODE_GENERATOR_SERVICE_NAME 8021
#define IDS_UTILITY_PROCESS_IMAGE_WRITER_NAME 8023
#define IDS_UTILITY_PROCESS_MEDIA_GALLERY_UTILITY_NAME 8024
#define IDS_UTILITY_PROCESS_NOOP_SERVICE_NAME 8025
#define IDS_SERVICE_PROCESS_DOCUMENT_ANALYSIS_NAME 8026
#define IDS_THEME_INSTALL_INFOBAR_LABEL 8027
#define IDS_THEME_INSTALL_INFOBAR_UNDO_BUTTON 8028
#define IDS_CRITICAL_NOTIFICATION_RESTART 8029
#define IDS_EXTENSION_DISABLED_ERROR_LABEL 8030
#define IDS_EXTENSION_IS_BLOCKLISTED 8031
#define IDS_EXTENSION_DISABLED_REMOTE_INSTALL_ERROR_TITLE 8032
#define IDS_EXTENSION_DISABLED_ERROR_TITLE 8033
#define IDS_EXTENSION_BLOCKED_ACTION_BUBBLE_HEADING 8034
#define IDS_EXTENSION_BLOCKED_ACTION_BUBBLE_OK_BUTTON 8035
#define IDS_EXTENSION_BLOCKED_ACTION_BUBBLE_SINGLE_EXTENSION_TITLE 8036
#define IDS_EXTENSION_BLOCKED_ACTION_BUBBLE_MULTIPLE_EXTENSIONS_TITLE 8037
#define IDS_EXTENSION_BLOCKED_ACTION_BUBBLE_UPDATE_PERMISSIONS_TITLE 8038
#define IDS_APP_UNINSTALL_PROMPT_TITLE 8039
#define IDS_ARC_APP_UNINSTALL_PROMPT_DATA_REMOVAL_WARNING 8040
#define IDS_EXTENSION_UNINSTALL_PROMPT_TITLE 8041
#define IDS_EXTENSION_CONFIRM_PERMISSIONS 8042
#define IDS_EXTENSION_DELEGATED_INSTALL_PROMPT_TITLE 8043
#define IDS_EXTENSION_INSTALL_PROMPT_TITLE 8044
#define IDS_EXTENSION_UNINSTALL_PROMPT_HEADING 8045
#define IDS_EXTENSION_REQUEST_PROMPT_TITLE 8046
#define IDS_EXTENSION_PENDING_REQUEST_PROMPT_TITLE 8047
#define IDS_EXTENSION_BLOCKED_BY_POLICY_PROMPT_TITLE 8048
#define IDS_EXTENSION_PROGRAMMATIC_UNINSTALL_PROMPT_HEADING 8049
#define IDS_EXTENSION_RE_ENABLE_PROMPT_TITLE 8050
#define IDS_EXTENSION_PERMISSIONS_PROMPT_TITLE 8051
#define IDS_EXTENSION_POST_INSTALL_PERMISSIONS_PROMPT_TITLE 8052
#define IDS_EXTENSION_REMOTE_INSTALL_PROMPT_TITLE 8053
#define IDS_EXTENSION_REPAIR_PROMPT_TITLE 8054
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_APP 8055
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_EXTENSION 8056
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_TITLE_THEME 8057
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 8058
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_APP 8059
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 8060
#define IDS_EXTENSION_EXTERNAL_INSTALL_PROMPT_ABORT_BUTTON 8061
#define IDS_EXTENSION_ALERT_TITLE 8062
#define IDS_APP_ALERT_TITLE 8063
#define IDS_EXTENSION_AND_APP_ALERT_TITLE 8064
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_TITLE 8065
#define IDS_POLICY_BLOCKED_EXTENSIONS_ALERT_ITEM_TITLE 8066
#define IDS_BLOCKLISTED_EXTENSIONS_ALERT_ITEM 8067
#define IDS_POLICY_BLOCKED_EXTENSION_ALERT_ITEM_DETAIL 8068
#define IDS_EXTENSION_ALERT_ITEM_OK 8069
#define IDS_EXTENSION_ALERT_ITEM_DETAILS 8070
#define IDS_EXTENSION_PROMPT_APP_CONNECT_FROM_INCOGNITO 8071
#define IDS_EXTENSION_PROMPT_EXTENSION_CONNECT_FROM_INCOGNITO 8072
#define IDS_EXTENSION_PROMPT_WILL_HAVE_ACCESS_TO 8073
#define IDS_EXTENSION_PROMPT_WILL_NOW_HAVE_ACCESS_TO 8074
#define IDS_EXTENSION_PROMPT_WANTS_ACCESS_TO 8075
#define IDS_EXTENSION_PROMPT_CAN_ACCESS 8076
#define IDS_EXTENSION_NO_SPECIAL_PERMISSIONS 8077
#define IDS_EXTENSION_WITHHOLD_PERMISSIONS 8078
#define IDS_EXTENSION_PROMPT_MESSAGE_FROM_ADMIN 8079
#define IDS_EXTENSION_PERMISSION_LINE 8080
#define IDS_EXTENSION_RATING_COUNT 8081
#define IDS_EXTENSION_PROMPT_RATING_ACCESSIBLE_TEXT 8082
#define IDS_EXTENSION_PROMPT_NO_RATINGS_ACCESSIBLE_TEXT 8083
#define IDS_EXTENSION_USER_COUNT 8084
#define IDS_EXTENSION_PROMPT_STORE_LINK 8085
#define IDS_EXTENSION_PROMPT_RETAINED_FILES 8086
#define IDS_EXTENSION_PROMPT_RETAINED_DEVICES 8087
#define IDS_EXTENSION_PROMPT_WARNING_FULL_ACCESS 8088
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS 8089
#define IDS_EXTENSION_PROMPT_WARNING_CURRENT_HOST 8090
#define IDS_EXTENSION_PROMPT_WARNING_ALL_HOSTS_READ_ONLY 8091
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_CAPTURE 8092
#define IDS_EXTENSION_PROMPT_WARNING_VIDEO_CAPTURE 8093
#define IDS_EXTENSION_PROMPT_WARNING_AUDIO_AND_VIDEO_CAPTURE 8094
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH 8095
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_DEVICES 8096
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_PRIVATE 8097
#define IDS_EXTENSION_PROMPT_WARNING_BLUETOOTH_SERIAL 8098
#define IDS_EXTENSION_PROMPT_WARNING_BOOKMARKS 8099
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD 8100
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_READWRITE 364
#define IDS_EXTENSION_PROMPT_WARNING_CLIPBOARD_WRITE 8101
#define IDS_EXTENSION_PROMPT_WARNING_DEBUGGER 8102
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_WEB_REQUEST 8103
#define IDS_EXTENSION_PROMPT_WARNING_DECLARATIVE_NET_REQUEST 8104
#define IDS_EXTENSION_PROMPT_WARNING_DOCUMENT_SCAN 8105
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_HARDWARE_PLATFORM 8106
#define IDS_EXTENSION_PROMPT_WARNING_FAVICON 8107
#define IDS_EXTENSION_PROMPT_WARNING_GEOLOCATION 8108
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ 8109
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_READ_AND_SESSIONS 8110
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_WRITE 8111
#define IDS_EXTENSION_PROMPT_WARNING_HISTORY_WRITE_AND_SESSIONS 8112
#define IDS_EXTENSION_PROMPT_WARNING_HOME_PAGE_SETTING_OVERRIDE 8113
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST 8114
#define IDS_EXTENSION_PROMPT_WARNING_1_HOST_READ_ONLY 8115
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS 8116
#define IDS_EXTENSION_PROMPT_WARNING_2_HOSTS_READ_ONLY 8117
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS 8118
#define IDS_EXTENSION_PROMPT_WARNING_3_HOSTS_READ_ONLY 8119
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST 8120
#define IDS_EXTENSION_PROMPT_WARNING_HOSTS_LIST_READ_ONLY 8121
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN 8122
#define IDS_EXTENSION_PROMPT_WARNING_HOST_AND_SUBDOMAIN_LIST 8123
#define IDS_EXTENSION_PROMPT_WARNING_INPUT 8124
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN 8125
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_UI 8126
#define IDS_EXTENSION_PROMPT_WARNING_LOGIN_SCREEN_STORAGE 8127
#define IDS_EXTENSION_PROMPT_WARNING_MANAGEMENT 8128
#define IDS_EXTENSION_PROMPT_WARNING_MDNS 8129
#define IDS_EXTENSION_PROMPT_WARNING_NETWORK_STATE 8130
#define IDS_EXTENSION_PROMPT_WARNING_NETWORKING_PRIVATE 8131
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING 8132
#define IDS_EXTENSION_PROMPT_WARNING_PRINTING_METRICS 8133
#define IDS_EXTENSION_PROMPT_WARNING_SEARCH_SETTINGS_OVERRIDE 8134
#define IDS_EXTENSION_PROMPT_WARNING_SERIAL 8135
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_ANY_HOST 8136
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAIN 8137
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_HOSTS_IN_DOMAINS 8138
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOST 8139
#define IDS_EXTENSION_PROMPT_WARNING_SOCKET_SPECIFIC_HOSTS 8140
#define IDS_EXTENSION_PROMPT_WARNING_SPEECH_RECOGNITION 8141
#define IDS_EXTENSION_PROMPT_WARNING_START_PAGE_SETTING_OVERRIDE 8142
#define IDS_EXTENSION_PROMPT_WARNING_SYSTEM_STORAGE 8143
#define IDS_EXTENSION_PROMPT_WARNING_TAB_GROUPS 8144
#define IDS_EXTENSION_PROMPT_WARNING_TOPSITES 8145
#define IDS_EXTENSION_PROMPT_WARNING_TTS_ENGINE 8146
#define IDS_EXTENSION_PROMPT_WARNING_U2F_DEVICES 8147
#define IDS_EXTENSION_PROMPT_WARNING_NOTIFICATIONS 365
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE 8148
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST 8149
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_PRODUCT 8150
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_LIST_ITEM_UNKNOWN_VENDOR 8151
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_PRODUCT 8152
#define IDS_EXTENSION_PROMPT_WARNING_USB_DEVICE_UNKNOWN_VENDOR 8153
#define IDS_EXTENSION_PROMPT_WARNING_VPN 8154
#define IDS_EXTENSION_PROMPT_WARNING_CONTENT_SETTINGS 8155
#define IDS_EXTENSION_PROMPT_WARNING_PRIVACY 8156
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS 8157
#define IDS_EXTENSION_PROMPT_WARNING_DOWNLOADS_OPEN 8158
#define IDS_EXTENSION_PROMPT_WARNING_IDENTITY_EMAIL 8159
#define IDS_EXTENSION_PROMPT_WARNING_WALLPAPER 8160
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_DIRECTORY 8161
#define IDS_EXTENSION_PROMPT_WARNING_FILE_SYSTEM_WRITE_DIRECTORY 8162
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ 8163
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE 8164
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_DELETE 8165
#define IDS_EXTENSION_PROMPT_WARNING_MEDIA_GALLERIES_READ_WRITE_DELETE 8166
#define IDS_EXTENSION_PROMPT_WARNING_SYNCFILESYSTEM 8167
#define IDS_EXTENSION_PROMPT_WARNING_NATIVE_MESSAGING 8168
#define IDS_EXTENSION_PROMPT_WARNING_SCREENLOCK_PRIVATE 8169
#define IDS_EXTENSION_PROMPT_WARNING_ACTIVITY_LOG_PRIVATE 8170
#define IDS_EXTENSION_PROMPT_WARNING_DESKTOP_CAPTURE 8171
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_MODIFY 8172
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ 8173
#define IDS_EXTENSION_PROMPT_WARNING_ACCESSIBILITY_FEATURES_READ_MODIFY 8174
#define IDS_EXTENSION_PROMPT_WARNING_PLATFORMKEYS 8175
#define IDS_EXTENSION_PROMPT_WARNING_CERTIFICATEPROVIDER 8176
#define IDS_EXTENSION_PROMPT_WARNING_SETTINGS_PRIVATE 8177
#define IDS_EXTENSION_PROMPT_WARNING_AUTOFILL_PRIVATE 8178
#define IDS_EXTENSION_PROMPT_WARNING_PASSWORDS_PRIVATE 8179
#define IDS_EXTENSION_PROMPT_WARNING_USERS_PRIVATE 8180
#define IDS_EXTENSION_PROMPT_WARNING_NEW_TAB_PAGE_OVERRIDE 8181
#define IDS_EXTENSION_PROMPT_WARNING_TRANSIENT_BACKGROUND 8182
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_DEVICE_ATTRIBUTES 8183
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_NETWORKING_ATTRIBUTES 8184
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_PLATFORMKEYS 8185
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE_ENABLED_LINUX_AND_MACOS 8187
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REPORTING_PRIVATE 8188
#define IDS_EXTENSION_PROMPT_WARNING_ENTERPRISE_REMOTE_APPS 8189
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_DIAGNOSTICS 8190
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY 8191
#define IDS_EXTENSION_PROMPT_WARNING_CHROMEOS_TELEMETRY_SERIAL_NUMBER 8192
#define IDS_EXTENSION_CANT_DOWNGRADE_VERSION 8193
#define IDS_APP_CANT_DOWNGRADE_VERSION 8194
#define IDS_EXTENSION_MOVE_DIRECTORY_TO_PROFILE_FAILED 8197
#define IDS_EXTENSION_INSTALL_NOT_ENABLED 8198
#define IDS_EXTENSION_INSTALL_INCORRECT_APP_CONTENT_TYPE 8199
#define IDS_EXTENSION_INSTALL_INCORRECT_INSTALL_HOST 8200
#define IDS_EXTENSION_INSTALL_UNEXPECTED_ID 8201
#define IDS_EXTENSION_INSTALL_DISALLOWED_ON_SITE 8202
#define IDS_EXTENSION_INSTALL_UNEXPECTED_VERSION 8203
#define IDS_EXTENSION_INSTALL_DEPENDENCY_OLD_VERSION 8204
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_SHARED_MODULE 8205
#define IDS_EXTENSION_INSTALL_DEPENDENCY_NOT_ALLOWLISTED 8206
#define IDS_EXTENSION_INSTALL_GALLERY_ONLY 8207
#define IDS_EXTENSION_INSTALL_KIOSK_MODE_ONLY 8208
#define IDS_EXTENSION_OVERLAPPING_WEB_EXTENT 8209
#define IDS_EXTENSION_INVALID_IMAGE_PATH 8210
#define IDS_EXTENSION_INSTALLED_APP_INFO 8212
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO 8213
#define IDS_EXTENSION_INSTALLED_PAGE_ACTION_INFO_WITH_SHORTCUT 8214
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO 8215
#define IDS_EXTENSION_INSTALLED_BROWSER_ACTION_INFO_WITH_SHORTCUT 8216
#define IDS_EXTENSION_INSTALLED_OMNIBOX_KEYWORD_INFO 8217
#define IDS_EXTENSION_INSTALLED_MANAGE_INFO 8218
#define IDS_EXTENSION_INSTALLED_MANAGE_SHORTCUTS 8219
#define IDS_EXTENSION_INSTALLED_DICE_PROMO_SYNC_MESSAGE 8220
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_TITLE 8221
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_READ_ONLY 8222
#define IDS_EXTENSIONS_DIRECTORY_CONFIRMATION_DIALOG_MESSAGE_WRITABLE 8223
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_TITLE_LABEL 8224
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_ADDRESS_LABEL 8225
#define IDS_DIRECT_SOCKETS_CONNECTION_BUBBLE_PORT_LABEL 8226
#define IDS_EXTENSIONS_LOAD_ERROR_ALERT_HEADING 8227
#define IDS_EXTENSIONS_LOAD_ERROR_MESSAGE 8228
#define IDS_EXTENSIONS_WANTS_ACCESS_TO_SITE 8229
#define IDS_EXTENSIONS_HAS_ACCESS_TO_SITE 8230
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON 8231
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_SINGLE_EXTENSION 8232
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUTTON_TOOLTIP_MULTIPLE_EXTENSIONS 8233
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUBBLE_SINGLE_EXTENSION_TITLE 8234
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUBBLE_MULTIPLE_EXTENSIONS_TITLE 8235
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUBBLE_OK_BUTTON_LABEL 8236
#define IDS_EXTENSIONS_REQUEST_ACCESS_BUBBLE_CANCEL_BUTTON_LABEL 8237
#define IDS_EXTENSIONS_CONTEXT_MENU_CANT_ACCESS_PAGE 8238
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS 8239
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_GRANTED 8240
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_ALL_EXTENSIONS_BLOCKED 8241
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_CLICK 8242
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_SITE 8243
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_RUN_ON_ALL_SITES 8244
#define IDS_EXTENSIONS_CONTEXT_MENU_PAGE_ACCESS_LEARN_MORE 8245
#define IDS_EXTENSIONS_OPTIONS_MENU_ITEM 8246
#define IDS_EXTENSIONS_INSTALLED_BY_ADMIN 8247
#define IDS_EXTENSIONS_DISABLE 8248
#define IDS_EXTENSIONS_HIDE_BUTTON 8258
#define IDS_EXTENSIONS_KEEP_BUTTON_IN_TOOLBAR 8259
#define IDS_EXTENSIONS_SHOW_BUTTON_IN_TOOLBAR 8260
#define IDS_EXTENSIONS_PIN_TO_TOOLBAR 8249
#define IDS_EXTENSIONS_UNPIN_FROM_TOOLBAR 8250
#define IDS_EXTENSIONS_PINNED_BY_ADMIN 8251
#define IDS_MANAGE_EXTENSION 8252
#define IDS_MANAGE_EXTENSIONS 8253
#define IDS_EXTENSION_ACTION_INSPECT_POPUP 8254
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_COMBOBOX_RUN_ON_CLICK 8255
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_COMBOBOX_RUN_ON_SITE 8256
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_COMBOBOX_RUN_ON_ALL_SITES 8257
#define IDS_EXTENSIONS_LOCKED_SUPERVISED_USER 8261
#define IDS_EXTENSION_LOAD_FROM_DIRECTORY 8262
#define IDS_EXTENSION_COMMANDS_GENERIC_ACTIVATE 8263
#define IDS_EXTENSION_PACK_DIALOG_HEADING 8264
#define IDS_EXTENSION_PACK_DIALOG_SELECT_KEY 8265
#define IDS_EXTENSION_PACK_DIALOG_KEY_FILE_TYPE_DESCRIPTION 8266
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_REQUIRED 8267
#define IDS_EXTENSION_PACK_DIALOG_ERROR_ROOT_INVALID 8268
#define IDS_EXTENSION_PACK_DIALOG_ERROR_KEY_INVALID 8269
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_NEW 8270
#define IDS_EXTENSION_PACK_DIALOG_SUCCESS_BODY_UPDATE 8271
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_CONTINUE_BUTTON 8272
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_TITLE 8273
#define IDS_EXTENSION_PROMPT_INSTALL_FRICTION_WARNING_TEXT 8274
#define IDS_EXTENSION_PROMPT_INSTALL_BUTTON 8275
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_EXTENSION 8276
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_APP 8277
#define IDS_EXTENSION_INSTALL_PROMPT_ACCEPT_BUTTON_THEME 8278
#define IDS_EXTENSION_INSTALL_PROMPT_ASK_A_PARENT_BUTTON 8279
#define IDS_EXTENSION_INSTALL_BLOCKED_BY_PARENT_PROMPT_TITLE 8280
#define IDS_EXTENSION_ENABLE_BLOCKED_BY_PARENT_PROMPT_TITLE 8281
#define IDS_PARENT_PERMISSION_PROMPT_GO_GET_A_PARENT_FOR_EXTENSION_LABEL 8282
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_EXTENSION 8283
#define IDS_PARENT_PERMISSION_PROMPT_EXTENSION_TYPE_APP 8284
#define IDS_PARENT_PERMISSION_PROMPT_CHILD_WANTS_TO_INSTALL_LABEL 8285
#define IDS_PARENT_PERMISSION_PROMPT_APPROVE_BUTTON 8286
#define IDS_PARENT_PERMISSION_PROMPT_CANCEL_BUTTON 8287
#define IDS_PARENT_PERMISSION_PROMPT_SELECT_PARENT_LABEL 8288
#define IDS_PARENT_PERMISSION_PROMPT_PARENT_ACCOUNT_LABEL 8289
#define IDS_PARENT_PERMISSION_PROMPT_ENTER_PASSWORD_LABEL 8290
#define IDS_PARENT_PERMISSION_PROMPT_PASSWORD_INCORRECT_LABEL 8291
#define IDS_EXTENSION_INSTALL_PROMPT_REQUEST_BUTTON 8292
#define IDS_EXTENSION_PROMPT_UNINSTALL_BUTTON 8293
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE 8294
#define IDS_EXTENSION_PROMPT_UNINSTALL_REPORT_ABUSE_FROM_EXTENSION 8295
#define IDS_EXTENSION_PROMPT_UNINSTALL_TITLE 8296
#define IDS_EXTENSION_PROMPT_UNINSTALL_APP_BUTTON 8297
#define IDS_EXTENSION_PROMPT_UNINSTALL_TRIGGERED_BY_EXTENSION 8298
#define IDS_EXTENSION_PROMPT_RE_ENABLE_BUTTON 8299
#define IDS_EXTENSION_PROMPT_PERMISSIONS_BUTTON 8300
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ACCEPT_BUTTON 8301
#define IDS_EXTENSION_PROMPT_PERMISSIONS_ABORT_BUTTON 8302
#define IDS_EXTENSION_PROMPT_PERMISSIONS_CLEAR_RETAINED_FILES_BUTTON 8303
#define IDS_EXTENSION_PROMPT_PERMISSIONS_CLEAR_RETAINED_DEVICES_BUTTON 8304
#define IDS_EXTENSION_PROMPT_PERMISSIONS_CLEAR_RETAINED_FILES_AND_DEVICES_BUTTON 8305
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_EXTENSION 8306
#define IDS_EXTENSION_PROMPT_REMOTE_INSTALL_BUTTON_APP 8307
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_EXTENSION 8308
#define IDS_EXTENSION_PROMPT_REPAIR_BUTTON_APP 8309
#define IDS_EXTENSION_WEB_STORE_TITLE 256
#define IDS_EXTENSION_WEB_STORE_TITLE_SHORT 8310
#define IDS_EXTENSIONS_SHOW_DETAILS 8311
#define IDS_EXTENSIONS_HIDE_DETAILS 8312
#define IDS_WEBSTORE_DOWNLOAD_ACCESS_DENIED 8313
#define IDS_EXTENSION_WARNINGS_WRENCH_MENU_ITEM 8314
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_EXTENSION 8315
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_APP 8316
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_THEME 8317
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_TITLE 8318
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_APP 8319
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_EXTENSION 8320
#define IDS_EXTENSION_EXTERNAL_INSTALL_ALERT_BUBBLE_HEADING_THEME 8321
#define IDS_EXTENSIONS_UNSUPPORTED_DISABLED_TITLE 8322
#define IDS_EXTENSIONS_DISABLED_AND_N_MORE 8323
#define IDS_EXTENSIONS_UNSUPPORTED_DISABLED_BUTTON 8324
#define IDS_EXTENSIONS_ADDED_WITHOUT_KNOWLEDGE 8325
#define IDS_EXTENSIONS_DISABLE_DEVELOPER_MODE_TITLE 8326
#define IDS_EXTENSIONS_DISABLE_DEVELOPER_MODE_BODY 8327
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_CHANGE_IT_BACK 8328
#define IDS_EXTENSION_SETTINGS_OVERRIDDEN_DIALOG_KEEP_IT 8329
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_GENERIC 8330
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 8331
#define IDS_EXTENSION_NTP_OVERRIDDEN_DIALOG_BODY_GENERIC 8332
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_GENERIC 8333
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_GOOGLE 8334
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_TITLE_BACK_TO_OTHER 8335
#define IDS_EXTENSION_SEARCH_OVERRIDDEN_DIALOG_BODY_GENERIC 8336
#define IDS_FORCE_INSTALLED_DEPRECATED_APPS_CONTENT 8337
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_PLURAL 8338
#define IDS_DEPRECATED_APPS_RENDERER_TITLE_WITH_APP_NAME 8339
#define IDS_DEPRECATED_APPS_MONITOR_RENDERER 8340
#define IDS_DEPRECATED_APPS_LEARN_MORE 8341
#define IDS_DEPRECATED_APPS_LEARN_MORE_AX_LABEL 8342
#define IDS_DEPRECATED_APPS_DELETION_LINK 8343
#define IDS_DEPRECATED_APPS_OK_LABEL 8344
#define IDS_DEPRECATED_APPS_CANCEL_LABEL 8345
#define IDS_DEPRECATED_APPS_LAUNCH_ANYWAY_LABEL 8346
#define IDS_EXTENSIONS_MENU_TITLE 8347
#define IDS_EXTENSIONS_MENU_CONTEXT_MENU_TOOLTIP 8348
#define IDS_EXTENSIONS_MENU_PIN_BUTTON_TOOLTIP 8349
#define IDS_EXTENSIONS_MENU_UNPIN_BUTTON_TOOLTIP 8350
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA_SHORT 8351
#define IDS_EXTENSIONS_MENU_ACCESSING_SITE_DATA 8352
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA_SHORT 8353
#define IDS_EXTENSIONS_MENU_WANTS_TO_ACCESS_SITE_DATA 8354
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA_SHORT 8355
#define IDS_EXTENSIONS_MENU_CANT_ACCESS_SITE_DATA 8356
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_TITLE 8357
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_HAS_ACCESS_SECTION_TITLE 8358
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_REQUESTS_ACCESS_SECTION_TITLE 8359
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_BLOCK_ALL_EXTENSIONS_TEXT 8360
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_NO_EXTENSIONS_HAVE_ACCESS_TEXT 8361
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_RESTRICTED_SITE_TEXT 8362
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_USER_SETTINGS_TITLE 8363
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_USER_SETTINGS_ALLOW_ALL_TEXT 8364
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_USER_SETTINGS_BLOCK_ALL_TEXT 8365
#define IDS_EXTENSIONS_MENU_SITE_ACCESS_TAB_USER_SETTINGS_CUSTOMIZE_EACH_TEXT 8366
#define IDS_EXTENSIONS_MENU_EXTENSIONS_TAB_TITLE 8367
#define IDS_EXTENSIONS_MENU_EXTENSIONS_TAB_DISCOVER_MORE_TITLE 8368
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_HOME_PAGE_BUBBLE 8369
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_STARTUP_PAGES_BUBBLE 8370
#define IDS_EXTENSIONS_SETTINGS_API_TITLE_SEARCH_ENGINE_BUBBLE 8371
#define IDS_EXTENSIONS_NTP_CONTROLLED_TITLE_HOME_PAGE_BUBBLE 8372
#define IDS_EXTENSIONS_PROXY_CONTROLLED_TITLE_HOME_PAGE_BUBBLE 8373
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_SEARCH_ENGINE_SPECIFIC 8374
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_SEARCH_ENGINE 8375
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE_SPECIFIC 8376
#define IDS_EXTENSIONS_SETTINGS_API_FIRST_LINE_HOME_PAGE 8377
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_SEARCH_ENGINE 8378
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_HOME_PAGE 8379
#define IDS_EXTENSIONS_SETTINGS_API_SECOND_LINE_HOME_AND_SEARCH 8380
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_TITLE 8381
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_BUBBLE_HEADING 8382
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_ALLOW 8383
#define IDS_EXTENSIONS_PRINTING_API_PRINT_REQUEST_DENY 8384
#define IDS_EXTENSIONS_NTP_CONTROLLED_FIRST_LINE 8385
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE 8386
#define IDS_EXTENSIONS_PROXY_CONTROLLED_FIRST_LINE_EXTENSION_SPECIFIC 8387
#define IDS_EXTENSIONS_SETTINGS_API_THIRD_LINE_CONFIRMATION 8388
#define IDS_EXTENSION_CONTROLLED_RESTORE_SETTINGS 8389
#define IDS_EXTENSION_CONTROLLED_KEEP_CHANGES 8390
#define IDS_WEB_APP_MENU_BUTTON_TOOLTIP 8391
#define IDS_WEB_APP_ENABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 8392
#define IDS_WEB_APP_DISABLE_WINDOW_CONTROLS_OVERLAY_TOOLTIP 8393
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_ENABLED_ALERT 8394
#define IDS_WEB_APP_WINDOW_CONTROLS_OVERLAY_DISABLED_ALERT 8395
#define IDS_WEB_APP_SETTINGS_TITLE 8396
#define IDS_WEB_APP_SETTINGS_LINK 8397
#define IDS_WEB_APP_SETTINGS_LINK_TOOLTIP 8398
#define IDS_COMPONENTS_TITLE 8399
#define IDS_COMPONENTS_VERSION 8400
#define IDS_COMPONENTS_NONE_INSTALLED 8401
#define IDS_COMPONENTS_NO_COMPONENTS 8402
#define IDS_COMPONENTS_CHECK_FOR_UPDATE 8403
#define IDS_COMPONENTS_STATUS_LABEL 8404
#define IDS_COMPONENTS_CHECKING_LABEL 8405
#define IDS_COMPONENTS_SVC_STATUS_NEW 8409
#define IDS_COMPONENTS_SVC_STATUS_CHECKING 8410
#define IDS_COMPONENTS_SVC_STATUS_UPDATE 8411
#define IDS_COMPONENTS_SVC_STATUS_DNL_DIFF 8412
#define IDS_COMPONENTS_SVC_STATUS_DNL 8413
#define IDS_COMPONENTS_SVC_STATUS_DOWNLOADED 8414
#define IDS_COMPONENTS_SVC_STATUS_UPDT_DIFF 8415
#define IDS_COMPONENTS_SVC_STATUS_UPDATING 8416
#define IDS_COMPONENTS_SVC_STATUS_UPDATED 8417
#define IDS_COMPONENTS_SVC_STATUS_UPTODATE 8418
#define IDS_COMPONENTS_SVC_STATUS_UPDATE_ERROR 8419
#define IDS_COMPONENTS_UNKNOWN 8420
#define IDS_COMPONENTS_EVT_STATUS_STARTED 8421
#define IDS_COMPONENTS_EVT_STATUS_SLEEPING 8422
#define IDS_COMPONENTS_EVT_STATUS_FOUND 8423
#define IDS_COMPONENTS_EVT_STATUS_READY 8424
#define IDS_COMPONENTS_EVT_STATUS_UPDATED 8425
#define IDS_COMPONENTS_EVT_STATUS_ALREADY_UP_TO_DATE 8426
#define IDS_COMPONENTS_EVT_STATUS_UPDATE_ERROR 8427
#define IDS_COMPONENTS_EVT_STATUS_DOWNLOADING 8428
#define IDS_COMPONENTS_EVT_STATUS_UPDATING 8429
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_TITLE 8430
#define IDS_PASSWORD_MANAGER_CONFIRM_SAVED_TITLE 8431
#define IDS_PASSWORD_GENERATION_SUGGESTION 8432
#define IDS_PASSWORD_GENERATION_SUGGESTION_GPM 8433
#define IDS_PASSWORD_GENERATION_EDITING_SUGGESTION 8434
#define IDS_SAVE_PASSWORD 8435
#define IDS_SAVE_ACCOUNT 8436
#define IDS_UPDATE_PASSWORD 8437
#define IDS_SAVE_PASSWORD_DIFFERENT_DOMAINS_TITLE 8438
#define IDS_UPDATE_PASSWORD_DIFFERENT_DOMAINS_TITLE 8439
#define IDS_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION_GOOGLE_ACCOUNT 8440
#define IDS_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION_GOOGLE_ACCOUNT 8441
#define IDS_SAVE_PASSWORD_FOOTER 8442
#define IDS_PASSWORD_BUBBLES_PASSWORD_MANAGER_LINK_TEXT_SYNCED_TO_ACCOUNT 8443
#define IDS_PASSWORD_BUBBLES_FOOTER_SYNCED_TO_ACCOUNT 8444
#define IDS_PASSWORD_BUBBLES_FOOTER_SAVING_ON_DEVICE 8445
#define IDS_PASSWORD_GENERATION_CONFIRMATION_GOOGLE_PASSWORD_MANAGER 8446
#define IDS_PASSWORD_GENERATION_PROMPT_GOOGLE_PASSWORD_MANAGER 8447
#define IDS_PASSWORD_MANAGEMENT_BUBBLE_FOOTER_ACCOUNT_STORE_USERS 8448
#define IDS_PASSWORD_MANAGER_GENERATED_PASSWORD_SAVED_MESSAGE_DESCRIPTION 8449
#define IDS_PASSWORD_MANAGER_SAVE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 8450
#define IDS_PASSWORD_MANAGER_UPDATE_PASSWORD_SIGNED_IN_MESSAGE_DESCRIPTION 8451
#define IDS_PASSWORD_MANAGER_ACCOUNT_CHOOSER_SIGN_IN 8452
#define IDS_PASSWORD_MANAGER_MANAGE_PASSWORDS_BUTTON 8453
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_A 8454
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_B 8455
#define IDS_PASSWORD_MANAGER_ONBOARDING_TITLE_C 8456
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_A 8457
#define IDS_PASSWORD_MANAGER_ONBOARDING_DETAILS_B 8458
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SIGNIN_MESSAGE 8459
#define IDS_PASSWORD_MANAGER_DICE_PROMO_SYNC_MESSAGE 8460
#define IDS_WEBRTC_LOGS_TITLE 8461
#define IDS_WEBRTC_TEXT_LOGS_LOG_COUNT_BANNER_FORMAT 8462
#define IDS_WEBRTC_EVENT_LOGS_LOG_COUNT_BANNER_FORMAT 8463
#define IDS_WEBRTC_LOGS_LOG_HEADER_FORMAT 8464
#define IDS_WEBRTC_LOGS_LOG_LOCAL_FILE_LABEL_FORMAT 8465
#define IDS_WEBRTC_LOGS_NO_LOCAL_LOG_FILE_MESSAGE 8466
#define IDS_WEBRTC_LOGS_LOG_UPLOAD_TIME_FORMAT 8467
#define IDS_WEBRTC_LOGS_LOG_FAILED_UPLOAD_TIME_FORMAT 8468
#define IDS_WEBRTC_LOGS_LOG_REPORT_ID_FORMAT 8469
#define IDS_WEBRTC_LOGS_BUG_LINK_LABEL 8470
#define IDS_WEBRTC_LOGS_LOG_PENDING_MESSAGE 8471
#define IDS_WEBRTC_LOGS_LOG_ACTIVELY_UPLOADED_MESSAGE 8472
#define IDS_WEBRTC_LOGS_LOG_NOT_UPLOADED_MESSAGE 8473
#define IDS_WEBRTC_LOGS_EVENT_LOG_LOCAL_LOG_ID 8474
#define IDS_WEBRTC_LOGS_NO_TEXT_LOGS_MESSAGE 8475
#define IDS_WEBRTC_LOGS_NO_EVENT_LOGS_MESSAGE 8476
#define IDS_PLUGIN_HIDE 8477
#define IDS_PLUGIN_UPDATE 8478
#define IDS_PLUGIN_BLOCKED 8479
#define IDS_PLUGIN_BLOCKED_BY_POLICY 8480
#define IDS_PLUGIN_BLOCKED_NO_LOADING 8481
#define IDS_PLUGIN_OUTDATED 8483
#define IDS_PLUGIN_NOT_AUTHORIZED 8484
#define IDS_PLUGIN_DOWNLOADING 8485
#define IDS_PLUGIN_DOWNLOAD_ERROR 8486
#define IDS_PLUGIN_DOWNLOAD_ERROR_SHORT 8487
#define IDS_PLUGIN_UPDATING 8488
#define IDS_PLUGIN_DISABLED 8489
#define IDS_PLUGIN_DEPRECATED 8490
#define IDS_SESSION_CRASHED_BUBBLE_TITLE 8491
#define IDS_SESSION_CRASHED_BUBBLE_UMA_LINK_TEXT 8492
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_TITLE 8493
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_MESSAGE 8494
#define IDS_SETTINGS_STORAGE_PRESSURE_BUBBLE_VIEW_BUTTON_LABEL 8495
#define IDS_EXPERIMENTAL_LACROS_WARNING_MESSAGE 8496
#define IDS_EXPERIMENTAL_LACROS_WARNING_MESSAGE_PRIMARY 8497
#define IDS_EXPERIMENTAL_LACROS_WARNING_MESSAGE_MANAGED 8498
#define IDS_EXPERIMENTAL_LACROS_WARNING_LEARN_MORE 8499
#define IDS_BAD_FLAGS_WARNING_MESSAGE 8500
#define IDS_BAD_FEATURES_WARNING_MESSAGE 8501
#define IDS_BAD_ENVIRONMENT_VARIABLES_WARNING_MESSAGE 8502
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT_TITLE 8503
#define IDS_BLOCKED_DISPLAYING_INSECURE_CONTENT 8504
#define IDS_ALLOW_INSECURE_CONTENT_BUTTON 8505
#define IDS_ADD_TO_SHELF_INFOBAR_TITLE 8506
#define IDS_ADD_TO_SHELF_INFOBAR_ADD_BUTTON 8507
#define IDS_ABOUT_SYS_TITLE 8508
#define IDS_ABOUT_SYS_DESC 8509
#define IDS_ABOUT_SYS_TABLE_TITLE 8510
#define IDS_ABOUT_SYS_LOG_FILE_TABLE_TITLE 8511
#define IDS_ABOUT_SYS_EXPAND_ALL 8512
#define IDS_ABOUT_SYS_COLLAPSE_ALL 8513
#define IDS_ABOUT_SYS_EXPAND 8514
#define IDS_ABOUT_SYS_COLLAPSE 8515
#define IDS_ABOUT_SYS_PARSE_ERROR 8516
#define IDS_ABOUT_BROWSER_SWITCH_TITLE 8517
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_UNKNOWN_BROWSER 8518
#define IDS_ABOUT_BROWSER_SWITCH_OPENING_TITLE_KNOWN_BROWSER 8519
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_UNKNOWN_BROWSER 8520
#define IDS_ABOUT_BROWSER_SWITCH_ERROR_TITLE_KNOWN_BROWSER 8521
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_UNKNOWN_BROWSER 8522
#define IDS_ABOUT_BROWSER_SWITCH_COUNTDOWN_TITLE_KNOWN_BROWSER 8523
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_UNKNOWN_BROWSER 8524
#define IDS_ABOUT_BROWSER_SWITCH_GENERIC_ERROR_KNOWN_BROWSER 8525
#define IDS_ABOUT_BROWSER_SWITCH_PROTOCOL_ERROR 8526
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_DESC 8527
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_TITLE 8528
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_NOTHING_SHOWN 8529
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_LBS_DISABLED 8530
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_TITLE 8531
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_URL_CHECKER_DESC 8532
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER 8533
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_PROTOCOL_REASON 8534
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_RULE_REASON 8535
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_INVERT_RULE_REASON 8536
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_OPEN_BROWSER_DEFAULT_REASON 8537
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_INVALID_URL 8538
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_TITLE 8539
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_DESC 8540
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SOURCE 8541
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_NOT_CONFIGURED 8542
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NOT_FETCHED 8543
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_DOWNLOAD_BUTTON 8544
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_LAST_DOWNLOAD_DATE 8545
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_XML_SITELIST_NEXT_DOWNLOAD_DATE 8546
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_TITLE 8547
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_DESCRIPTION 8548
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_FIRST_PARAGRAPH 8549
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_IN_SECOND_PARAGRAPH 8550
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_RULE 8551
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_OPENS_IN 8552
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_FORCE_OPEN_TABLE_COLUMN_SOURCE 8553
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TITLE 8554
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_DESCRIPTION 8555
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_FIRST_PARAGRAPH 8556
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_SECOND_PARAGRAPH 8557
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_RULE 8558
#define IDS_ABOUT_BROWSER_SWITCH_INTERNALS_IGNORE_TABLE_COLUMN_SOURCE 8559
#define IDS_NACL_APP_MISSING_ARCH_MESSAGE 8563
#define IDS_OMNIBOX_PLACEHOLDER_TEXT 8568
#define IDS_PASTE_AND_GO 8569
#define IDS_PASTE_AND_SEARCH 8570
#define IDS_PASTE_AND_GO_EMPTY 8571
#define IDS_OMNIBOX_KEYWORD_HINT 8572
#define IDS_OMNIBOX_EXTENSION_KEYWORD_HINT 8573
#define IDS_OMNIBOX_KEYWORD_HINT_KEY_ACCNAME 8574
#define IDS_OMNIBOX_KEYWORD_HINT_TOUCH 8575
#define IDS_OMNIBOX_EXTENSION_KEYWORD_HINT_TOUCH 8576
#define IDS_OMNIBOX_KEYWORD_TEXT 8577
#define IDS_OMNIBOX_KEYWORD_TEXT_MD 8578
#define IDS_OMNIBOX_CLEAR_ALL 8579
#define IDS_OMNIBOX_WHY_THIS_SUGGESTION 8581
#define IDS_OMNIBOX_REMOVE_SUGGESTION 8582
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_TITLE 8583
#define IDS_OMNIBOX_REMOVE_SUGGESTION_BUBBLE_DESCRIPTION 8584
#define IDS_CONTEXT_MENU_SHOW_FULL_URLS 8585
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT 8586
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_MD 8587
#define IDS_GOOGLE_SEARCH_BOX_EMPTY_HINT_SHORT 8588
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TOOLTIP 8589
#define IDS_NTP_CUSTOM_LINKS_ADD_SHORTCUT_TITLE 8590
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT_TOOLTIP 8591
#define IDS_NTP_CUSTOM_LINKS_EDIT_SHORTCUT 8592
#define IDS_UPLOAD_IMAGE_FORMAT 8593
#define IDS_NTP_CUSTOM_LINKS_NAME 8594
#define IDS_NTP_CUSTOM_LINKS_URL 8595
#define IDS_NTP_CUSTOM_LINKS_REMOVE 8596
#define IDS_NTP_CUSTOM_LINKS_CANCEL 8597
#define IDS_NTP_CUSTOM_LINKS_DONE 8598
#define IDS_NTP_CUSTOM_LINKS_INVALID_URL 8599
#define IDS_NTP_CUSTOM_LINKS_CANT_CREATE 8600
#define IDS_NTP_CUSTOM_LINKS_CANT_EDIT 8601
#define IDS_NTP_CUSTOM_LINKS_CANT_REMOVE 8602
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_REMOVED 8603
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_EDITED 8604
#define IDS_NTP_CONFIRM_MSG_SHORTCUT_ADDED 8605
#define IDS_NTP_CUSTOM_LINKS_ALREADY_EXISTS 8606
#define IDS_NTP_CONFIRM_MSG_RESTORE_DEFAULTS 8607
#define IDS_NTP_CUSTOM_BG_CHROME_WALLPAPERS 8608
#define IDS_NTP_CUSTOM_BG_UPLOAD_AN_IMAGE 8609
#define IDS_NTP_CUSTOM_BG_SELECT_A_COLLECTION 8610
#define IDS_NTP_CUSTOM_BG_DAILY_REFRESH 8611
#define IDS_NTP_CUSTOM_BG_RESTORE_DEFAULT 8612
#define IDS_NTP_CUSTOM_BG_CANCEL 8613
#define IDS_NTP_CONNECTION_ERROR_NO_PERIOD 8614
#define IDS_NTP_CONNECTION_ERROR 8615
#define IDS_NTP_ERROR_MORE_INFO 8616
#define IDS_NTP_CUSTOM_BG_BACKGROUNDS_UNAVAILABLE 8617
#define IDS_NTP_CUSTOM_BG_BACK_LABEL 8618
#define IDS_NTP_CUSTOM_BG_IMAGE_SELECTED 8619
#define IDS_NTP_CUSTOM_BG_CUSTOMIZE_NTP_LABEL 8620
#define IDS_NTP_DISMISS_PROMO 8621
#define IDS_NTP_DOODLE_SHARE_LABEL 8622
#define IDS_NTP_DOODLE_SHARE_DIALOG_CLOSE_LABEL 8623
#define IDS_NTP_DOODLE_SHARE_DIALOG_FACEBOOK_LABEL 8624
#define IDS_NTP_DOODLE_SHARE_DIALOG_TWITTER_LABEL 8625
#define IDS_NTP_DOODLE_SHARE_DIALOG_MAIL_LABEL 8626
#define IDS_NTP_DOODLE_SHARE_DIALOG_COPY_LABEL 8627
#define IDS_NTP_DOODLE_SHARE_DIALOG_LINK_LABEL 8628
#define IDS_NTP_CUSTOMIZE_MENU_BACKGROUND_LABEL 8629
#define IDS_NTP_CUSTOMIZE_MENU_BACKGROUND_DISABLED_LABEL 8630
#define IDS_NTP_CUSTOMIZE_MENU_SHORTCUTS_LABEL 8631
#define IDS_NTP_CUSTOMIZE_MENU_MODULES_LABEL 8632
#define IDS_NTP_CUSTOMIZE_MENU_COLOR_LABEL 8633
#define IDS_NTP_CUSTOMIZE_NO_BACKGROUND_LABEL 8634
#define IDS_NTP_CUSTOMIZE_UPLOAD_FROM_DEVICE_LABEL 8635
#define IDS_NTP_CUSTOMIZE_HIDE_SHORTCUTS_LABEL 8636
#define IDS_NTP_CUSTOMIZE_HIDE_SHORTCUTS_DESC 8637
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_LABEL 8638
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_LABEL 8639
#define IDS_NTP_CUSTOMIZE_MOST_VISITED_DESC 8640
#define IDS_NTP_CUSTOMIZE_MY_SHORTCUTS_DESC 8641
#define IDS_NTP_CUSTOMIZE_HIDE_ALL_CARDS_LABEL 8642
#define IDS_NTP_CUSTOMIZE_CUSTOMIZE_CARDS_LABEL 8643
#define IDS_NTP_CUSTOMIZE_3PT_THEME_DESC 8644
#define IDS_NTP_CUSTOMIZE_3PT_THEME_UNINSTALL 8645
#define IDS_NTP_CUSTOMIZE_COLOR_PICKER_LABEL 8646
#define IDS_NTP_THEME_MANAGED_DIALOG_TITLE 8647
#define IDS_NTP_THEME_MANAGED_DIALOG_BODY 8648
#define IDS_NTP_CUSTOMIZE_DEFAULT_LABEL 8649
#define IDS_NTP_COLORS_WARM_GREY 8650
#define IDS_NTP_COLORS_COOL_GREY 8651
#define IDS_NTP_COLORS_MIDNIGHT_BLUE 8652
#define IDS_NTP_COLORS_BLACK 8653
#define IDS_NTP_COLORS_BEIGE_AND_WHITE 8654
#define IDS_NTP_COLORS_YELLOW_AND_WHITE 8655
#define IDS_NTP_COLORS_GREEN_AND_WHITE 8656
#define IDS_NTP_COLORS_LIGHT_TEAL_AND_WHITE 8657
#define IDS_NTP_COLORS_LIGHT_PURPLE_AND_WHITE 8658
#define IDS_NTP_COLORS_PINK_AND_WHITE 8659
#define IDS_NTP_COLORS_BEIGE 8660
#define IDS_NTP_COLORS_ORANGE 8661
#define IDS_NTP_COLORS_LIGHT_GREEN 8662
#define IDS_NTP_COLORS_LIGHT_TEAL 8663
#define IDS_NTP_COLORS_LIGHT_BLUE 8664
#define IDS_NTP_COLORS_PINK 8665
#define IDS_NTP_COLORS_DARK_PINK_AND_RED 8666
#define IDS_NTP_COLORS_DARK_RED_AND_ORANGE 8667
#define IDS_NTP_COLORS_DARK_GREEN 8668
#define IDS_NTP_COLORS_DARK_TEAL 8669
#define IDS_NTP_COLORS_DARK_BLUE 8670
#define IDS_NTP_COLORS_DARK_PURPLE 8671
#define IDS_NTP_MODULES_INFO_BUTTON_TITLE 8672
#define IDS_NTP_MODULES_DISMISS_TOAST_MESSAGE 8673
#define IDS_NTP_MODULES_DISABLE_TOAST_MESSAGE 8674
#define IDS_NTP_MODULES_DISMISS_BUTTON_TEXT 8675
#define IDS_NTP_MODULES_DISABLE_BUTTON_TEXT 8676
#define IDS_NTP_MODULES_CUSTOMIZE_BUTTON_TEXT 8677
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_TODAY 8678
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_YESTERDAY 8679
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_WEEK 8680
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PAST_MONTH 8681
#define IDS_NTP_MODULES_STATEFUL_TASKS_VIEWED_PREVIOUSLY 8682
#define IDS_NTP_MODULES_SHOPPING_TASKS_SENTENCE 8683
#define IDS_NTP_MODULES_SHOPPING_TASKS_LOWER 8684
#define IDS_NTP_MODULES_RECIPE_INFO 8685
#define IDS_NTP_MODULES_RECIPE_EXTENDED_INFO 8686
#define IDS_NTP_MODULES_RECIPE_TASKS_SENTENCE 8687
#define IDS_NTP_MODULES_RECIPE_TASKS_LOWER 8688
#define IDS_NTP_MODULES_RECIPE_TASKS_LOWER_THESE 8689
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_SENTENCE 8690
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_LOWER 8691
#define IDS_NTP_MODULES_RECIPE_VIEWED_TASKS_LOWER_THESE 8692
#define IDS_NTP_MODULES_CART_SENTENCE 8693
#define IDS_NTP_MODULES_CART_SENTENCE_V2 8694
#define IDS_NTP_MODULES_CART_LOWER 8695
#define IDS_NTP_MODULES_CART_LOWER_THESE 8696
#define IDS_NTP_MODULES_CART_LOWER_YOUR 8697
#define IDS_NTP_MODULES_CART_INFO 8698
#define IDS_NTP_MODULES_CART_ITEM_COUNT_SINGULAR 8699
#define IDS_NTP_MODULES_CART_ITEM_COUNT_MULTIPLE 8700
#define IDS_NTP_MODULES_DRIVE_SENTENCE 8701
#define IDS_NTP_MODULES_DRIVE_SENTENCE2 8702
#define IDS_NTP_MODULES_DRIVE_FILES_SENTENCE 8703
#define IDS_NTP_MODULES_DRIVE_FILES_LOWER 8704
#define IDS_NTP_MODULES_DUMMY_LOWER 8705
#define IDS_NTP_MODULES_DUMMY_TITLE 8706
#define IDS_NTP_MODULES_DUMMY2_TITLE 8707
#define IDS_NTP_MODULES_DRIVE_TITLE 8708
#define IDS_NTP_MODULES_DRIVE_INFO 8709
#define IDS_NTP_MODULES_PHOTOS_TITLE 8710
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_TITLE 8711
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_HIDE_TODAY 8712
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_HIDDEN_TODAY 8713
#define IDS_NTP_MODULES_PHOTOS_SOFT_OPT_OUT 8714
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_DISABLE 8715
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_DISABLED 8716
#define IDS_NTP_MODULES_PHOTOS_INFO 8717
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_EXPLORE 8718
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_TITLE 8719
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_PERSONALIZED_WELCOME_TITLE_TEMPLATE 8720
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_RH_WELCOME_TITLE 8721
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_FAVORITE_PEOPLE_WELCOME_TITLE 8722
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_TRIPS_WELCOME_TITLE 8723
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_TEXT 8724
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_OPT_IN 8725
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_OPT_OUT 8726
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_BUTTON_SOFT_OPT_OUT 8727
#define IDS_NTP_MODULES_PHOTOS_MEMORIES_WELCOME_EXAMPLE 8728
#define IDS_NTP_MODULES_PHOTOS_BALOON_ILLUSTRATION_TITLE 8729
#define IDS_NTP_MODULES_PHOTOS_NEW 8730
#define IDS_NTP_MODULES_KALEIDOSCOPE_TITLE 8731
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_TITLE 8732
#define IDS_NTP_MODULES_TASKS_INFO 8733
#define IDS_NTP_MODULES_SHOPPING_TASKS_INFO_CLOSE 8734
#define IDS_NTP_MODULES_SHOPPING_TASKS_RELATED 8735
#define IDS_NTP_MODULES_RECIPE_TASKS_RECOMMENDED 8736
#define IDS_NTP_MODULES_CART_WARM_WELCOME 8737
#define IDS_NTP_MODULES_CART_MODULE_MENU_HIDE_TOAST_MESSAGE 8738
#define IDS_NTP_MODULES_CART_CART_MENU_HIDE_MERCHANT 8739
#define IDS_NTP_MODULES_CART_CART_MENU_HIDE_MERCHANT_TOAST_MESSAGE 8740
#define IDS_NTP_MODULES_CART_CART_MENU_REMOVE_MERCHANT 8741
#define IDS_NTP_MODULES_CART_CART_MENU_REMOVE_MERCHANT_TOAST_MESSAGE 8742
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_AMOUNT 8743
#define IDS_NTP_MODULES_CART_DISCOUNT_CHIP_UP_TO_AMOUNT 8744
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT 8745
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_ACCEPT 8746
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_ACCEPT_CONFIRMATION 8747
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_REJECT 8748
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_REJECT_CONFIRMATION 8749
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONFIRMATION_DISMISS 8750
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT_V2 8751
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_CONTENT_V3 8752
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_MERCHANT_NAME 8753
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_TWO_MERCHANT_NAMES 8754
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_WITH_THREE_MERCHANT_NAMES 8755
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_STEP_1_CONTINUE 8756
#define IDS_NTP_MODULES_CART_DISCOUNT_CONSENT_TITLE 8757
#define IDS_NTP_MODULES_NEW_TAG_LABEL 8758
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_TITLE 8759
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_BODY_LINE_1 8760
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_BODY_LINE_2 8761
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_IN 8762
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_OUT 8763
#define IDS_NTP_MODULES_FIRST_RUN_EXPERIENCE_OPT_OUT_TOAST 8764
#define IDS_NTP_MODULES_FEED_TITLE 8765
#define IDS_EXTENSIONS_PROMO_PERFORMANCE 8766
#define IDS_EXTENSIONS_PROMO_PRIVACY 8767
#define IDS_EXTENSIONS_PROMO_NEUTRAL 8768
#define IDS_STAR_VIEW_MENU_ADD_BOOKMARK 8770
#define IDS_STAR_VIEW_MENU_EDIT_BOOKMARK 8771
#define IDS_STAR_VIEW_MENU_MOVE_TO_READ_LATER 8772
#define IDS_STAR_VIEW_MENU_MARK_AS_READ 8773
#define IDS_READ_LATER_TITLE 8774
#define IDS_READ_LATER_MENU_UNREAD_HEADER 8775
#define IDS_READ_LATER_MENU_READ_HEADER 8776
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_READ 8777
#define IDS_READ_LATER_MENU_TOOLTIP_MARK_AS_UNREAD 8778
#define IDS_READ_LATER_MENU_EMPTY_STATE_ADD_FROM_DIALOG_SUBHEADER 8779
#define IDS_READ_LATER_MENU_EMPTY_STATE_HEADER 8780
#define IDS_READ_LATER_MENU_EMPTY_STATE_SUBHEADER 8781
#define IDS_READ_LATER_ADD_CURRENT_TAB 8782
#define IDS_READ_LATER_CANT_ADD_CURRENT_TAB 8783
#define IDS_READ_LATER_REMOVE_CURRENT_TAB 8784
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_UNREAD 8785
#define IDS_READ_LATER_CONTEXT_MENU_MARK_AS_READ 8786
#define IDS_READ_LATER_CONTEXT_MENU_DELETE 8787
#define IDS_SIDE_PANEL_TITLE 8788
#define IDS_SIDE_PANEL_COMBO_BOX_GOOGLE_LENS_LABEL 8789
#define IDS_READ_ANYTHING_TITLE 8790
#define IDS_READ_ANYTHING_TOOLBAR_LABEL 8791
#define IDS_READ_ANYTHING_FONT_NAME_COMBOBOX_LABEL 8792
#define IDS_READ_ANYTHING_DECREASE_FONT_SIZE_BUTTON_LABEL 8793
#define IDS_READ_ANYTHING_INCREASE_FONT_SIZE_BUTTON_LABEL 8794
#define IDS_USER_NOTE_TITLE 8795
#define IDS_ADD_NEW_USER_NOTE_PLACEHOLDER_TEXT 8796
#define IDS_LEARN_MORE_USER_NOTE 8797
#define IDS_FEED_TITLE 8798
#define IDS_TOOLTIP_BACK 266
#define IDS_ACCDESCRIPTION_BACK 307
#define IDS_TOOLTIP_CHROMELABS_BUTTON 8799
#define IDS_TOOLTIP_LEFT_ALIGNED_SIDE_PANEL_BUTTON 8800
#define IDS_TOOLTIP_CHROMELABS_COMBOBOX 8801
#define IDS_TOOLTIP_CHROMELABS_FEEDBACK_BUTTON 8802
#define IDS_TOOLTIP_FORWARD 267
#define IDS_ACCDESCRIPTION_FORWARD 309
#define IDS_TOOLTIP_DOWNLOAD_ICON 8803
#define IDS_TOOLTIP_HOME 269
#define IDS_TOOLTIP_RELOAD 268
#define IDS_TOOLTIP_RELOAD_WITH_MENU 8804
#define IDS_TOOLTIP_STOP 329
#define IDS_TOOLTIP_EXTENSIONS_BUTTON 8805
#define IDS_TOOLTIP_EXTENSIONS_SITE_ACCESS_BUTTON 8806
#define IDS_TOOLTIP_SIDE_PANEL_SHOW 8807
#define IDS_TOOLTIP_SIDE_PANEL_HIDE 8808
#define IDS_TOOLTIP_CLOSE_TAB 322
#define IDS_TOOLTIP_LOCATION_ICON 318
#define IDS_TOOLTIP_NEW_TAB 261
#define IDS_TOOLTIP_MIC_SEARCH 8809
#define IDS_TOOLTIP_SAVE_CREDIT_CARD 8810
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_PENDING 8811
#define IDS_TOOLTIP_SAVE_CREDIT_CARD_FAILURE 8812
#define IDS_TOOLTIP_MIGRATE_LOCAL_CARD 8813
#define IDS_TOOLTIP_TRANSLATE 8814
#define IDS_TOOLTIP_ZOOM 8815
#define IDS_TOOLTIP_ZOOM_EXTENSION_ICON 8816
#define IDS_ZOOM_SET_DEFAULT 8817
#define IDS_TOOLTIP_FIND 8818
#define IDS_TOOLTIP_TAB_SEARCH 8819
#define IDS_TOOLTIP_INTENT_PICKER_ICON 8820
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN_WITH 8821
#define IDS_INTENT_PICKER_BUBBLE_VIEW_REMEMBER_SELECTION 8822
#define IDS_INTENT_PICKER_BUBBLE_VIEW_OPEN 8823
#define IDS_INTENT_PICKER_BUBBLE_VIEW_STAY_IN_CHROME 8824
#define IDS_INTENT_PICKER_BUBBLE_VIEW_INITIATING_ORIGIN 8825
#define IDS_INTENT_CHIP_OPEN_IN_APP 8826
#define IDS_INTENT_PICKER_SELECT_AN_APP_GENERIC_SUBTITLE 8831
#define IDS_INTENT_CHIP_IPH_GENERIC 8832
#define IDS_ACCESSIBLE_INCOGNITO_WINDOW_TITLE_FORMAT 8833
#define IDS_ACCESSIBLE_GUEST_WINDOW_TITLE_FORMAT 8834
#define IDS_ACCESSIBLE_WINDOW_TITLE_WITH_PROFILE_FORMAT 8835
#define IDS_ACCNAME_APP_UPGRADE_RECOMMENDED 8836
#define IDS_ACCNAME_FULLSCREEN 8837
#define IDS_ACCNAME_EXIT_FULLSCREEN 8838
#define IDS_ACCNAME_HOME 311
#define IDS_ACCNAME_RELOAD 310
#define IDS_ACCNAME_FIND 8839
#define IDS_ACCNAME_BOOKMARKS 8840
#define IDS_ACCNAME_SAVED_TAB_GROUPS 8841
#define IDS_ACCNAME_BOOKMARKS_CHEVRON 8842
#define IDS_ACCNAME_BOOKMARK_BUTTON_ROLE_DESCRIPTION 8843
#define IDS_ACCNAME_BOOKMARK_FOLDER_BUTTON_ROLE_DESCRIPTION 8844
#define IDS_ACCNAME_SAVED_TAB_GROUP_BUTTON_ROLE_DESCRIPTION 8845
#define IDS_ACCNAME_CHROMELABS_BUTTON 8846
#define IDS_ACCNAME_LEFT_ALIGNED_SIDE_PANEL_BUTTON 8847
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_ADDED_BY_ENTERPRISE_POLICY 8848
#define IDS_ACCESSIBLE_TEXT_CHROMELABS_BUTTON_REMOVED_BY_ENTERPRISE_POLICY 8849
#define IDS_ACCNAME_CHROMELABS_COMBOBOX 8850
#define IDS_ACCNAME_CHROMELABS_COMBOBOX_MAC 8851
#define IDS_ACCNAME_SEPARATOR 8852
#define IDS_ACCNAME_EXTENSIONS 8853
#define IDS_ACCNAME_NEWTAB 264
#define IDS_ACCNAME_MINIMIZE 8854
#define IDS_ACCNAME_MAXIMIZE 8855
#define IDS_ACCNAME_RESTORE 8856
#define IDS_ACCNAME_CLOSE_TAB 323
#define IDS_ACCNAME_ZOOM_SET_DEFAULT 8857
#define IDS_ACCNAME_TAB_SEARCH 8858
#define IDS_ACCNAME_TAB_SCROLL_LEADING 8859
#define IDS_ACCNAME_TAB_SCROLL_TRAILING 8860
#define IDS_ACCNAME_MUTE_TAB 8861
#define IDS_ACCNAME_EXTENSIONS_MENU_SITE_ACCESS_COMBOBOX 8862
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_LEADING_SCROLL_BUTTON 8863
#define IDS_ACCNAME_WEB_APP_DETAILED_INSTALL_DIALOG_TRAILING_SCROLL_BUTTON 8864
#define IDS_ALLOWED_CLIPBOARD_TITLE 8865
#define IDS_BLOCKED_CLIPBOARD_TITLE 8866
#define IDS_ALLOWED_CLIPBOARD_MESSAGE 8867
#define IDS_ALLOWED_CLIPBOARD_BLOCK 8868
#define IDS_ALLOWED_CLIPBOARD_NO_ACTION 8869
#define IDS_BLOCKED_CLIPBOARD_MESSAGE 8870
#define IDS_BLOCKED_CLIPBOARD_UNBLOCK 8871
#define IDS_BLOCKED_CLIPBOARD_NO_ACTION 8872
#define IDS_BOOKMARK_PROMO_0 8873
#define IDS_BOOKMARK_PROMO_1 8874
#define IDS_BOOKMARK_PROMO_2 8875
#define IDS_CHROME_TIP 8876
#define IDS_GLOBAL_MEDIA_CONTROLS_PROMO 8877
#define IDS_INCOGNITOWINDOW_PROMO_0 8878
#define IDS_INCOGNITOWINDOW_PROMO_1 8879
#define IDS_INCOGNITOWINDOW_PROMO_2 8880
#define IDS_INCOGNITOWINDOW_PROMO_3 8881
#define IDS_NEWTAB_PROMO_0 8882
#define IDS_NEWTAB_PROMO_1 8883
#define IDS_NEWTAB_PROMO_2 8884
#define IDS_READING_LIST_DISCOVERY_PROMO 8885
#define IDS_READING_LIST_ENTRY_POINT_PROMO 8886
#define IDS_REOPEN_TAB_PROMO 8887
#define IDS_DESKTOP_PWA_INSTALL_PROMO 8888
#define IDS_UPDATED_CONNECTION_SECURITY_INDICATORS_PROMO 8889
#define IDS_REOPEN_TAB_PROMO_SCREENREADER 8890
#define IDS_READING_LIST_IN_SIDE_PANEL_PROMO 8891
#define IDS_TAB_GROUPS_NEW_GROUP_PROMO 8892
#define IDS_TAB_GROUPS_UNNAMED_GROUP_TOOLTIP 8893
#define IDS_TAB_GROUPS_NAMED_GROUP_TOOLTIP 8894
#define IDS_TAB_AUDIO_MUTING_PROMO 8895
#define IDS_SHARED_HIGHLIGHTING_PROMO 8896
#define IDS_TUTORIAL_TAB_GROUP_ADD_TAB_TO_GROUP 8897
#define IDS_TUTORIAL_TAB_GROUP_EDIT_BUBBLE 8898
#define IDS_TUTORIAL_TAB_GROUP_DRAG_TAB 8899
#define IDS_TUTORIAL_TAB_GROUP_COLLAPSE 8900
#define IDS_TUTORIAL_TAB_GROUP_SUCCESS_TITLE 8901
#define IDS_TUTORIAL_TAB_GROUP_SUCCESS_DESCRIPTION 8902
#define IDS_BROWSER_HANGMONITOR_RENDERER_TITLE 8904
#define IDS_BROWSER_HANGMONITOR_RENDERER 8905
#define IDS_BROWSER_HANGMONITOR_RENDERER_INFOBAR 8906
#define IDS_BROWSER_HANGMONITOR_IFRAME_TITLE 8907
#define IDS_BROWSER_HANGMONITOR_RENDERER_INFOBAR_END 8908
#define IDS_BROWSER_HANGMONITOR_RENDERER_WAIT 8909
#define IDS_BROWSER_HANGMONITOR_RENDERER_END 8910
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR 8911
#define IDS_BROWSER_HANGMONITOR_PLUGIN_INFOBAR_KILLBUTTON 8912
#define IDS_PASSWORDS_AUTO_SIGNIN_TITLE 8913
#define IDS_PASSWORDS_AUTO_SIGNIN_DESCRIPTION 8914
#define IDS_PASSWORDS_VIA_FEDERATION 8915
#define IDS_CONFIRM_MESSAGEBOX_YES_BUTTON_LABEL 8916
#define IDS_CONFIRM_MESSAGEBOX_NO_BUTTON_LABEL 8917
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_TITLE 8918
#define IDS_NEAR_OOM_REDUCTION_MESSAGE_DESCRIPTION 8919
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_TITLE 8920
#define IDS_TAILORED_SECURITY_UNCONSENTED_MESSAGE_ACCEPT 8921
#define IDS_TAILORED_SECURITY_DISPLAY_SOURCE 8922
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_NOTIFICATION_TITLE 8923
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_NOTIFICATION_ACCEPT 8924
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_NOTIFICATION_TITLE 8925
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_NOTIFICATION_DESCRIPTION 8926
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_NOTIFICATION_TURN_OFF 8927
#define IDS_PASSWORD_MANAGER_CANCEL_BUTTON 8928
#define IDS_PASSWORD_MANAGER_USERNAME_LABEL 8929
#define IDS_PASSWORD_MANAGER_PASSWORD_LABEL 8930
#define IDS_PASSWORD_MANAGER_UPDATED_BUBBLE_TITLE 8931
#define IDS_PASSWORD_MANAGER_MORE_TO_FIX_BODY_MESSAGE 8932
#define IDS_PASSWORD_MANAGER_MORE_TO_FIX_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 8933
#define IDS_PASSWORD_MANAGER_SAFE_STATE_BODY_MESSAGE 8934
#define IDS_PASSWORD_MANAGER_SAFE_STATE_BODY_MESSAGE_GOOGLE_PASSWORD_MANAGER 8935
#define IDS_PASSWORD_MANAGER_SAFE_STATE_SETTINGS 8936
#define IDS_PASSWORD_MANAGER_CHECK_REMAINING_BUTTON 8937
#define IDS_PASSWORD_MANAGER_SAVE_BUTTON 8938
#define IDS_PASSWORD_MANAGER_SAVE_BUBBLE_OPT_IN_BUTTON 8939
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_OK_BUTTON 8940
#define IDS_PASSWORD_MANAGER_MOVE_BUBBLE_CANCEL_BUTTON 8941
#define IDS_PASSWORD_MANAGER_UPDATE_BUTTON 8942
#define IDS_PASSWORD_MANAGER_BUBBLE_BLOCKLIST_BUTTON 8943
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_ACCESSIBLE_NAME 8944
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_ACCOUNT 8945
#define IDS_PASSWORD_MANAGER_DESTINATION_DROPDOWN_SAVE_TO_DEVICE 8946
#define IDS_PASSWORD_MANAGER_IPH_TITLE_SAVE_TO_ACCOUNT 8947
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_REAUTH_FAIL 8948
#define IDS_PASSWORD_MANAGER_IPH_BODY_SAVE_TO_ACCOUNT 8949
#define IDS_PASSWORD_MANAGER_TOOLTIP_SAVE 8950
#define IDS_PASSWORD_MANAGER_TOOLTIP_MANAGE 8951
#define IDS_PASSWORD_MANAGER_TOOLTIP_MOVE 8952
#define IDS_PASSWORD_MANAGER_IMPORT_DIALOG_TITLE 8953
#define IDS_PASSWORD_MANAGER_EXPORT_DIALOG_TITLE 8954
#define IDS_PASSWORD_MANAGER_MOVE_TITLE 8955
#define IDS_PASSWORD_MANAGER_MOVE_HINT 8956
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_TITLE 8957
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_TITLE_GPM 8958
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_DESCRIPTION 8959
#define IDS_PASSWORD_MANAGER_UNSYNCED_CREDENTIALS_BUBBLE_DESCRIPTION_GPM 8960
#define IDS_PASSWORD_MANAGER_SAVE_UNSYNCED_CREDENTIALS_BUTTON 8961
#define IDS_PASSWORD_MANAGER_SAVE_UNSYNCED_CREDENTIALS_BUTTON_GPM 8962
#define IDS_PASSWORD_MANAGER_DISCARD_UNSYNCED_CREDENTIALS_BUTTON 8963
#define IDS_IMPORT_FROM_FIREFOX 8980
#define IDS_IMPORT_FROM_ICEWEASEL 8981
#define IDS_IMPORT_FROM_SAFARI 8982
#define IDS_IMPORT_FROM_BOOKMARKS_HTML_FILE 8983
#define IDS_IMPORT_SETTINGS_MENU_MAC 107
#define IDS_CONFIRM_TO_QUIT_DESCRIPTION 8984
#define IDS_CONFIRM_TO_QUIT_OPTION 112
#define IDS_IMPORTER_LOCK_TITLE 8985
#define IDS_IMPORTER_LOCK_TEXT 8986
#define IDS_IMPORTER_LOCK_OK 8987
#define IDS_FEEDBACK_REPORT_APP_TITLE 8988
#define IDS_FEEDBACK_REPORT_PAGE_TITLE 8989
#define IDS_FEEDBACK_REPORT_PAGE_TITLE_SAD_TAB_FLOW 8990
#define IDS_FEEDBACK_MINIMIZE_BUTTON_LABEL 8991
#define IDS_FEEDBACK_CLOSE_BUTTON_LABEL 8992
#define IDS_FEEDBACK_FREE_TEXT_LABEL 8993
#define IDS_FEEDBACK_REPORT_URL_LABEL 8994
#define IDS_FEEDBACK_USER_EMAIL_LABEL 8995
#define IDS_FEEDBACK_ANONYMOUS_EMAIL_OPTION 8996
#define IDS_FEEDBACK_CONSENT_CHECKBOX_LABEL 8997
#define IDS_FEEDBACK_SCREENSHOT_LABEL 8998
#define IDS_FEEDBACK_SCREENSHOT_A11Y_TEXT 8999
#define IDS_FEEDBACK_INCLUDE_PERFORMANCE_TRACE_CHECKBOX 9000
#define IDS_FEEDBACK_BLUETOOTH_LOGS_CHECKBOX 9001
#define IDS_FEEDBACK_ASSISTANT_LOGS_MESSAGE 9002
#define IDS_FEEDBACK_BLUETOOTH_LOGS_MESSAGE 9003
#define IDS_FEEDBACK_OFFLINE_DIALOG_TITLE 9004
#define IDS_FEEDBACK_OFFLINE_DIALOG_TEXT 9005
#define IDS_FEEDBACK_INCLUDE_SYSTEM_INFORMATION_CHKBOX 9006
#define IDS_FEEDBACK_INCLUDE_ASSISTANT_INFORMATION_CHKBOX 9009
#define IDS_FEEDBACK_ATTACH_FILE_NOTE 9010
#define IDS_FEEDBACK_ATTACH_FILE_LABEL 9011
#define IDS_FEEDBACK_ATTACH_FILE_TO_BIG 9012
#define IDS_FEEDBACK_IWLWIFI_DEBUG_DUMP_EXPLAINER 9013
#define IDS_FEEDBACK_PRIVACY_NOTE 9014
#define IDS_FEEDBACK_NO_DESCRIPTION 9015
#define IDS_FEEDBACK_SEND_REPORT 9016
#define IDS_FEEDBACK_SYSINFO_PAGE_TITLE 9017
#define IDS_FEEDBACK_SYSINFO_PAGE_LOADING 9018
#define IDS_FEEDBACK_ADDITIONAL_INFO_LABEL 9019
#define IDS_CLEAR_BROWSING_DATA_TITLE 9020
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE 9021
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_TITLE 9022
#define IDS_CLEAR_BROWSING_DATA_HISTORY_NOTICE_OK 9023
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE 9024
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_TITLE 9025
#define IDS_CLEAR_BROWSING_DATA_PASSWORDS_NOTICE_OK 9026
#define IDS_MEDIA_SELECTED_MIC_LABEL 9027
#define IDS_MEDIA_SELECTED_CAMERA_LABEL 9028
#define IDS_MEDIA_MENU_NO_DEVICE_TITLE 9029
#define IDS_ZOOMLEVELS_CHROME_ERROR_PAGES_LABEL 9030
#define IDS_PROMOTE_INFOBAR_TEXT 9031
#define IDS_PROMOTE_INFOBAR_PROMOTE_BUTTON 9032
#define IDS_PROMOTE_INFOBAR_DONT_ASK_BUTTON 9033
#define IDS_PROMOTE_AUTHENTICATION_PROMPT 9034
#define IDS_PROMOTE_PREFLIGHT_LAUNCH_ERROR 9035
#define IDS_PROMOTE_PREFLIGHT_SCRIPT_ERROR 9036
#define IDS_UPGRADE_ERROR 9037
#define IDS_UPGRADE_ERROR_DETAILS 9038
#define IDS_REPORT_AN_ISSUE 9041
#define IDS_SETTINGS_RESET_PROMPT_TITLE_SEARCH_ENGINE 9048
#define IDS_SETTINGS_RESET_PROMPT_TITLE_STARTUP_PAGE 9049
#define IDS_SETTINGS_RESET_PROMPT_TITLE_HOMEPAGE 9050
#define IDS_SETTINGS_RESET_PROMPT_ACCEPT_BUTTON_LABEL 9051
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_SEARCH_ENGINE_NO_EXTENSIONS 9052
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_STARTUP_PAGE_SINGLE_NO_EXTENSIONS 9053
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_STARTUP_PAGE_MULTIPLE_NO_EXTENSIONS 9054
#define IDS_SETTINGS_RESET_PROMPT_EXPLANATION_FOR_HOMEPAGE_NO_EXTENSIONS 9055
#define IDS_REENABLE_UPDATES 9056
#define IDS_PICTURE_IN_PICTURE_TITLE_TEXT 9057
#define IDS_PICTURE_IN_PICTURE_PAUSE_CONTROL_TEXT 9058
#define IDS_PICTURE_IN_PICTURE_PLAY_CONTROL_TEXT 9059
#define IDS_PICTURE_IN_PICTURE_REPLAY_CONTROL_TEXT 9060
#define IDS_PICTURE_IN_PICTURE_BACK_TO_TAB_CONTROL_TEXT 9061
#define IDS_PICTURE_IN_PICTURE_SKIP_AD_CONTROL_TEXT 9062
#define IDS_PICTURE_IN_PICTURE_MUTE_MICROPHONE_TEXT 9063
#define IDS_PICTURE_IN_PICTURE_UNMUTE_MICROPHONE_TEXT 9064
#define IDS_PICTURE_IN_PICTURE_TURN_ON_CAMERA_TEXT 9065
#define IDS_PICTURE_IN_PICTURE_TURN_OFF_CAMERA_TEXT 9066
#define IDS_PICTURE_IN_PICTURE_HANG_UP_TEXT 9067
#define IDS_PICTURE_IN_PICTURE_CLOSE_CONTROL_TEXT 9068
#define IDS_PICTURE_IN_PICTURE_RESIZE_HANDLE_TEXT 9069
#define IDS_PICTURE_IN_PICTURE_PLAY_PAUSE_CONTROL_ACCESSIBLE_TEXT 9070
#define IDS_PICTURE_IN_PICTURE_NEXT_TRACK_CONTROL_ACCESSIBLE_TEXT 9071
#define IDS_PICTURE_IN_PICTURE_PREVIOUS_TRACK_CONTROL_ACCESSIBLE_TEXT 9072
#define IDS_LOAD_STATE_WAITING_FOR_SOCKET_SLOT 9073
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE 9074
#define IDS_LOAD_STATE_WAITING_FOR_DELEGATE_GENERIC 9075
#define IDS_LOAD_STATE_WAITING_FOR_CACHE 9076
#define IDS_LOAD_STATE_ESTABLISHING_PROXY_TUNNEL 9077
#define IDS_LOAD_STATE_RESOLVING_PROXY_FOR_URL 9078
#define IDS_LOAD_STATE_RESOLVING_HOST_IN_PAC_FILE 9079
#define IDS_LOAD_STATE_DOWNLOADING_PAC_FILE 9080
#define IDS_LOAD_STATE_RESOLVING_HOST 9081
#define IDS_LOAD_STATE_CONNECTING 9082
#define IDS_LOAD_STATE_SSL_HANDSHAKE 9083
#define IDS_LOAD_STATE_SENDING_REQUEST 9084
#define IDS_LOAD_STATE_SENDING_REQUEST_WITH_PROGRESS 9085
#define IDS_LOAD_STATE_WAITING_FOR_RESPONSE 9086
#define IDS_TAB_CXMENU_NEWTABTORIGHT 9087
#define IDS_TAB_CXMENU_NEWTABTOLEFT 9088
#define IDS_TAB_CXMENU_RELOAD 9089
#define IDS_TAB_CXMENU_DUPLICATE 9090
#define IDS_TAB_CXMENU_CLOSETAB 9091
#define IDS_TAB_CXMENU_CLOSEOTHERTABS 9092
#define IDS_TAB_CXMENU_CLOSETABSTORIGHT 9093
#define IDS_TAB_CXMENU_CLOSETABSTOLEFT 9094
#define IDS_TAB_CXMENU_FOCUS_THIS_TAB 9095
#define IDS_TAB_CXMENU_PIN_TAB 9096
#define IDS_TAB_CXMENU_UNPIN_TAB 9097
#define IDS_TAB_CXMENU_SOUND_MUTE_SITE 9098
#define IDS_TAB_CXMENU_SOUND_UNMUTE_SITE 9099
#define IDS_TAB_CXMENU_READ_LATER 9100
#define IDS_TAB_CXMENU_ADD_TAB_TO_GROUP 9101
#define IDS_TAB_CXMENU_ADD_TAB_TO_NEW_GROUP 9102
#define IDS_TAB_CXMENU_SUBMENU_NEW_GROUP 9103
#define IDS_TAB_CXMENU_REMOVE_TAB_FROM_GROUP 9104
#define IDS_TAB_CXMENU_PLACEHOLDER_GROUP_TITLE 9105
#define IDS_TAB_CXMENU_MOVE_TABS_TO_NEW_WINDOW 9106
#define IDS_TAB_CXMENU_MOVETOANOTHERWINDOW 9107
#define IDS_TAB_CXMENU_MOVETOANOTHERNEWWINDOW 9108
#define IDS_TAB_CXMENU_FOLLOW_SITE 9109
#define IDS_TAB_CXMENU_UNFOLLOW_SITE 9110
#define IDS_TAB_SEARCH_PROMO 9118
#define IDS_TAB_SEARCH_SEARCH_TABS 9119
#define IDS_TAB_SEARCH_NO_RESULTS_FOUND 9120
#define IDS_TAB_SEARCH_CLOSE_TAB 9121
#define IDS_TAB_SEARCH_SUBMIT_FEEDBACK 9122
#define IDS_TAB_SEARCH_A11Y_TAB_CLOSED 9123
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB 9124
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS 9125
#define IDS_TAB_SEARCH_A11Y_FOUND_TAB_FOR 9126
#define IDS_TAB_SEARCH_A11Y_FOUND_TABS_FOR 9127
#define IDS_TAB_SEARCH_A11Y_OPEN_TAB 9128
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB 9129
#define IDS_TAB_SEARCH_A11Y_RECENTLY_CLOSED_TAB_GROUP 9130
#define IDS_TAB_SEARCH_MEDIA_TABS 9131
#define IDS_TAB_SEARCH_OPEN_TABS 9132
#define IDS_TAB_SEARCH_RECENTLY_CLOSED 9133
#define IDS_TAB_SEARCH_RECENTLY_CLOSED_TABS 9134
#define IDS_TAB_SEARCH_ONE_TAB 9135
#define IDS_TAB_SEARCH_TAB_COUNT 9136
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED_ITEMS 9137
#define IDS_TAB_SEARCH_EXPAND_RECENTLY_CLOSED 9138
#define IDS_TAB_SEARCH_COLLAPSE_RECENTLY_CLOSED 9139
#define IDS_BROWSER_WINDOW_TITLE_MENU_ENTRY 9140
#define IDS_TAB_GROUP_HEADER_CXMENU_SAVE_GROUP 9141
#define IDS_TAB_GROUP_HEADER_CXMENU_NEW_TAB_IN_GROUP 9142
#define IDS_TAB_GROUP_HEADER_CXMENU_UNGROUP 9143
#define IDS_TAB_GROUP_HEADER_CXMENU_CLOSE_GROUP 9144
#define IDS_TAB_GROUP_HEADER_CXMENU_MOVE_GROUP_TO_NEW_WINDOW 9145
#define IDS_TAB_GROUP_HEADER_CXMENU_SEND_FEEDBACK 9146
#define IDS_TAB_GROUP_HEADER_BUBBLE_TITLE_PLACEHOLDER 9147
#define IDS_APP_MENU_RELOAD 9148
#define IDS_APP_MENU_NEW_WEB_PAGE 9149
#define IDS_APP_MENU_BUTTON_UPDATE 9150
#define IDS_APP_MENU_BUTTON_ERROR 9151
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TITLE 9152
#define IDS_MEDIA_SCREEN_CAPTURE_CONFIRMATION_TEXT 9153
#define IDS_MEDIA_SCREEN_AND_AUDIO_CAPTURE_CONFIRMATION_TEXT 9154
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_TEXT 9155
#define IDS_MEDIA_SCREEN_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 9156
#define IDS_MEDIA_WINDOW_CAPTURE_NOTIFICATION_TEXT 9157
#define IDS_MEDIA_TAB_CAPTURE_NOTIFICATION_TEXT 9158
#define IDS_MEDIA_TAB_CAPTURE_WITH_AUDIO_NOTIFICATION_TEXT 9159
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_HIDE 9160
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_SOURCE 9161
#define IDS_MEDIA_SCREEN_CAPTURE_NOTIFICATION_STOP 9162
#define IDS_PLATFORM_KEYS_SELECT_CERT_DIALOG_TEXT 9163
#define IDS_UNSAFE_FRAME_MESSAGE 9164
#define IDS_CLIENT_CERT_DIALOG_TITLE 9165
#define IDS_CLIENT_CERT_DIALOG_TEXT 9166
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TITLE 9167
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_ENROLLMENT 9168
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CLIENT_AUTH 9169
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_LIST_CERTS 9170
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_IMPORT 9171
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_TEXT_CERT_EXPORT 9172
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_PASSWORD_FIELD 9173
#define IDS_CRYPTO_MODULE_AUTH_DIALOG_OK_BUTTON_LABEL 9174
#define IDS_MENU_EMPTY_SUBMENU 9175
#define IDS_FR_ENABLE_LOGGING 9176
#define IDS_FIRSTRUN_DLG_MAC_COMPLETE_INSTALLATION_LABEL 9177
#define IDS_FIRSTRUN_DLG_MAC_OPTIONS_SEND_USAGE_STATS_LABEL 9178
#define IDS_FIRSTRUN_DLG_MAC_START_CHROME_BUTTON 9179
#define IDS_CRASHED_TAB_FEEDBACK_MESSAGE 9180
#define IDS_CRASHED_TAB_FEEDBACK_LINK 9181
#define IDS_KILLED_TAB_FEEDBACK_MESSAGE 9183
#define IDS_RELAUNCH_BUTTON 9185
#define IDS_TOOLBAR_INFORM_SET_HOME_PAGE 9188
#define IDS_MANAGE_EXTENSIONS_SETTING_WINDOWS_TITLE 9189
#define IDS_CONTROLLED_SETTING_POLICY 9190
#define IDS_CONTROLLED_SETTING_EXTENSION 9191
#define IDS_CONTROLLED_SETTING_EXTENSION_WITHOUT_NAME 9192
#define IDS_CONTROLLED_SETTING_RECOMMENDED 9193
#define IDS_CONTROLLED_SETTING_HAS_RECOMMENDATION 9194
#define IDS_CONTROLLED_SETTING_CHILD_RESTRICTION 9195
#define IDS_EXTENSIONS_INSTALL_LOCATION_UNKNOWN 9196
#define IDS_EXTENSIONS_INSTALL_LOCATION_3RD_PARTY 9197
#define IDS_EXTENSIONS_INSTALL_LOCATION_ENTERPRISE 9198
#define IDS_EXTENSIONS_INSTALL_LOCATION_SHARED_MODULE 9199
#define IDS_EXTENSIONS_BLOCKLISTED_MALWARE 9200
#define IDS_EXTENSIONS_BLOCKLISTED_SECURITY_VULNERABILITY 9201
#define IDS_EXTENSIONS_BLOCKLISTED_CWS_POLICY_VIOLATION 9202
#define IDS_EXTENSIONS_BLOCKLISTED_POTENTIALLY_UNWANTED 9203
#define IDS_EXTENSIONS_SAFE_BROWSING_CRX_ALLOWLIST_WARNING 9204
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION 9205
#define IDS_RESET_PROFILE_SETTINGS_EXPLANATION_IN_BULLET_POINTS 9206
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_TITLE 9207
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_EXPLANATION 9208
#define IDS_TRIGGERED_RESET_PROFILE_SETTINGS_DEFAULT_TOOL_NAME 9209
#define IDS_RESET_PROFILE_SETTINGS_LOCALE 9210
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_URLS 9211
#define IDS_RESET_PROFILE_SETTINGS_STARTUP_TYPE 9212
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE 9213
#define IDS_RESET_PROFILE_SETTINGS_HOMEPAGE_IS_NTP 9214
#define IDS_RESET_PROFILE_SETTINGS_YES 9215
#define IDS_RESET_PROFILE_SETTINGS_NO 9216
#define IDS_RESET_PROFILE_SETTINGS_SHOW_HOME_BUTTON 9217
#define IDS_RESET_PROFILE_SETTINGS_DSE 9218
#define IDS_RESET_PROFILE_SETTINGS_EXTENSIONS 9219
#define IDS_RESET_PROFILE_SETTINGS_SHORTCUTS 9220
#define IDS_RESET_PROFILE_SETTINGS_PROCESSING_SHORTCUTS 9221
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_MONTH 9223
#define IDS_AUTOFILL_DIALOG_PLACEHOLDER_EXPIRY_YEAR 9224
#define IDS_AUTOFILL_FROM_GOOGLE_ACCOUNT 9225
#define IDS_OMNIBOX_ICON_SEND_TAB_TO_SELF 9227
#define IDS_OMNIBOX_TOOLTIP_SEND_TAB_TO_SELF 9228
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_TODAY_SEND_TAB_TO_SELF 9229
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAY_SEND_TAB_TO_SELF 9230
#define IDS_OMNIBOX_BUBBLE_ITEM_SUBTITLE_DAYS_SEND_TAB_TO_SELF 9231
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_FROM_DEVICE 9232
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_TITLE 9233
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_LABEL 9234
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_A11Y_NAME 9235
#define IDS_TOOLBAR_BUTTON_SEND_TAB_TO_SELF_BUTTON_HINT_TEXT 9236
#define IDS_CONTEXT_MENU_SEND_TAB_TO_SELF 9237
#define IDS_SEND_TAB_TO_SELF_SENDING_ANNOUNCE 9240
#define IDS_SEND_TAB_TO_SELF_MANAGE_DEVICES_LINK 9241
#define IDS_SEND_TAB_TO_SELF_SIGN_IN_PROMO_LABEL 9242
#define IDS_SEND_TAB_TO_SELF_NO_TARGET_DEVICE_LABEL 9243
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_PAGE 9244
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_IMAGE 9245
#define IDS_CONTEXT_MENU_GENERATE_QR_CODE_LINK 9246
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_LABEL 9247
#define IDS_OMNIBOX_QRCODE_GENERATOR_ICON_TOOLTIP 9248
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TITLE 9249
#define IDS_SHARING_HUB_GENERATE_QR_CODE_LABEL 9250
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_URL_TEXTFIELD_ACCESSIBLE_NAME 9251
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_TOOLTIP 9252
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_DOWNLOAD_BUTTON_LABEL 9253
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_TOO_LONG 9254
#define IDS_BROWSER_SHARING_QR_CODE_DIALOG_ERROR_UNKNOWN 9255
#define IDS_SHARING_HUB_TITLE 9256
#define IDS_SHARING_HUB_TOOLTIP 9257
#define IDS_SHARING_HUB_SCREENSHOT_LABEL 9258
#define IDS_SHARING_HUB_COPY_LINK_LABEL 9259
#define IDS_SHARING_HUB_SAVE_PAGE_LABEL 9260
#define IDS_SHARING_HUB_MEDIA_ROUTER_LABEL 9261
#define IDS_SHARING_HUB_SHARE_LABEL 9262
#define IDS_SHARING_HUB_SHARE_LABEL_ACCESSIBILITY 9263
#define IDS_SHARING_HUB_FOLLOW_LABEL 9264
#define IDS_SHARING_HUB_FOLLOWING_LABEL 9265
#define IDS_BROWSER_SHARING_SCREENSHOT_POST_CAPTURE_TITLE 9266
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_DOWNLOAD_BUTTON_LABEL 9267
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_EDIT_BUTTON_LABEL 9268
#define IDS_BROWSER_SHARING_SCREENSHOT_DIALOG_SHARE_BUTTON_LABEL 9269
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_SELECTION 9270
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CROP 9271
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_TEXT 9272
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ELLIPSE 9273
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_RECTANGLE 9274
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_LINE 9275
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ARROW 9276
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_BRUSH 9277
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_EMOJI 9278
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_HIGHLIGHTER 9279
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_UNDO 9280
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_REDO 9281
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_IN 9282
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_ZOOM_OUT 9283
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_COMMIT_CROP 9284
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_COMMIT_CROP 9285
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_CANCEL_CROP 9286
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_TOOLTIP_CANCEL_CROP 9287
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_DOWNLOAD_IMAGE 9288
#define IDS_BROWSER_SHARING_SCREENSHOT_IMAGE_EDITOR_BUTTON_COPY 9289
#define IDS_CONTEXT_MENU_SHOW_CLIPBOARD_HISTORY_MENU 9290
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT_UNKNOWN_DEVICE 9291
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_TEXT_CONTENT 9292
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT_UNKNOWN_DEVICE 9293
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_TITLE_IMAGE_CONTENT 9294
#define IDS_SHARING_REMOTE_COPY_NOTIFICATION_DESCRIPTION 9295
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_MULTIPLE_DEVICES 9296
#define IDS_CONTENT_CONTEXT_SHARING_CLICK_TO_CALL_SINGLE_DEVICE 9297
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_MULTIPLE_DEVICES 9298
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_SINGLE_DEVICE 9299
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE_UNKNOWN_DEVICE 9300
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_TITLE 9301
#define IDS_CONTENT_CONTEXT_SHARING_SHARED_CLIPBOARD_NOTIFICATION_DESCRIPTION 9302
#define IDS_OMNIBOX_TOOLTIP_SHARED_CLIPBOARD 9303
#define IDS_COLLECTED_COOKIES_DIALOG_TITLE 9304
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_LABEL 9305
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_LABEL 9306
#define IDS_COLLECTED_COOKIES_BLOCKED_THIRD_PARTY_BLOCKING_ENABLED 9307
#define IDS_COLLECTED_COOKIES_ALLOW_BUTTON 9308
#define IDS_COLLECTED_COOKIES_SESSION_ONLY_BUTTON 9309
#define IDS_COLLECTED_COOKIES_BLOCK_BUTTON 9310
#define IDS_COLLECTED_COOKIES_ALLOW_RULE_CREATED 9311
#define IDS_COLLECTED_COOKIES_BLOCK_RULE_CREATED 9312
#define IDS_COLLECTED_COOKIES_SESSION_RULE_CREATED 9313
#define IDS_COLLECTED_COOKIES_ALLOWED_COOKIES_TAB_LABEL 9314
#define IDS_COLLECTED_COOKIES_BLOCKED_COOKIES_TAB_LABEL 9315
#define IDS_COLLECTED_COOKIES_ALLOWED_AUX_TEXT 9316
#define IDS_COLLECTED_COOKIES_BLOCKED_AUX_TEXT 9317
#define IDS_COLLECTED_COOKIES_CLEAR_ON_EXIT_AUX_TEXT 9318
#define IDS_COLLECTED_COOKIES_INFOBAR_MESSAGE 9319
#define IDS_COLLECTED_COOKIES_INFOBAR_BUTTON 9320
#define IDS_COLLECTED_COOKIES_PARTITIONED_COOKIE 9321
#define IDS_ACCNAME_INFOBAR_CONTAINER 9322
#define IDS_ACCNAME_INFOBAR 9323
#define IDS_ONE_CLICK_BUBBLE_UNDO 9324
#define IDS_ONE_CLICK_SIGNIN_BUBBLE_MESSAGE 9325
#define IDS_ONE_CLICK_SIGNIN_DIALOG_OK_BUTTON 9326
#define IDS_ONE_CLICK_SIGNIN_DIALOG_UNDO_BUTTON 9327
#define IDS_ONE_CLICK_SIGNIN_DIALOG_ADVANCED 9328
#define IDS_ENTERPRISE_SIGNIN_CANCEL 9329
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_PROFILE 9330
#define IDS_ENTERPRISE_SIGNIN_CREATE_NEW_WORK_PROFILE 9331
#define IDS_ENTERPRISE_SIGNIN_CONTINUE 9332
#define IDS_ENTERPRISE_SIGNIN_ALERT 9333
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_TITLE 9334
#define IDS_PROFILE_WILL_BE_DELETED_DIALOG_DESCRIPTION 9335
#define IDS_MANAGED_WITH_HYPERLINK 9338
#define IDS_MANAGED_BY_WITH_HYPERLINK 9339
#define IDS_COOKIES_REMOVE_LABEL 9340
#define IDS_COOKIES_COOKIE_NAME_LABEL 9341
#define IDS_COOKIES_COOKIE_CONTENT_LABEL 9342
#define IDS_COOKIES_COOKIE_DOMAIN_LABEL 9343
#define IDS_COOKIES_COOKIE_PATH_LABEL 9344
#define IDS_COOKIES_COOKIE_SENDFOR_LABEL 9345
#define IDS_COOKIES_COOKIE_CREATED_LABEL 9346
#define IDS_COOKIES_COOKIE_EXPIRES_LABEL 9347
#define IDS_COOKIES_COOKIE_EXPIRES_SESSION 9348
#define IDS_COOKIES_COOKIE_SENDFOR_ANY 9349
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE 9350
#define IDS_COOKIES_COOKIE_SENDFOR_SAME_SITE 9351
#define IDS_COOKIES_COOKIE_SENDFOR_SECURE_SAME_SITE 9352
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_YES 9353
#define IDS_COOKIES_COOKIE_ACCESSIBLE_TO_SCRIPT_NO 9354
#define IDS_COOKIES_COOKIE_NONESELECTED 9355
#define IDS_COOKIES_COOKIES 9356
#define IDS_COOKIES_WEB_DATABASES 9357
#define IDS_COOKIES_LOCAL_STORAGE 9358
#define IDS_COOKIES_SESSION_STORAGE 9359
#define IDS_COOKIES_INDEXED_DBS 9360
#define IDS_COOKIES_MEDIA_LICENSE 9361
#define IDS_COOKIES_MEDIA_LICENSES 9362
#define IDS_COOKIES_FILE_SYSTEM 9363
#define IDS_COOKIES_FILE_SYSTEMS 9364
#define IDS_COOKIES_FILE_SYSTEM_USAGE_NONE 9365
#define IDS_COOKIES_SERVICE_WORKER 9366
#define IDS_COOKIES_SERVICE_WORKERS 9367
#define IDS_COOKIES_SHARED_WORKERS 9368
#define IDS_COOKIES_CACHE_STORAGE 9369
#define IDS_CLIENT_CERT_ECDSA_SIGN 9370
#define IDS_APP_DEFAULT_PAGE_NAME 9371
#define IDS_APP_LAUNCHER_TAB_TITLE 9372
#define IDS_NEW_TAB_GUEST_SESSION_HEADING 9373
#define IDS_NEW_TAB_GUEST_SESSION_DESCRIPTION 9374
#define IDS_NEW_TAB_TILE_GRID_ACCESSIBLE_DESCRIPTION 9375
#define IDS_NEW_TAB_APP_INSTALL_HINT_LABEL 9376
#define IDS_NEW_TAB_MOST_VISITED 9377
#define IDS_NEW_TAB_RESTORE_THUMBNAILS_SHORT_LINK 9378
#define IDS_NEW_TAB_ATTRIBUTION_INTRO 9379
#define IDS_NEW_TAB_THUMBNAIL_REMOVED_NOTIFICATION 9380
#define IDS_NEW_TAB_REMOVE_THUMBNAIL_TOOLTIP 9381
#define IDS_NEW_TAB_PAGE_SWITCHER_CHANGE_TITLE 9382
#define IDS_NEW_TAB_PAGE_SWITCHER_SAME_TITLE 9383
#define IDS_NEW_TAB_VOICE_AUDIO_ERROR 9384
#define IDS_NEW_TAB_VOICE_CLOSE_TOOLTIP 9385
#define IDS_NEW_TAB_VOICE_DETAILS 9386
#define IDS_NEW_TAB_VOICE_LANGUAGE_ERROR 9387
#define IDS_NEW_TAB_VOICE_LISTENING 9388
#define IDS_NEW_TAB_VOICE_NETWORK_ERROR 9389
#define IDS_NEW_TAB_VOICE_NO_TRANSLATION 9390
#define IDS_NEW_TAB_VOICE_NO_VOICE 9391
#define IDS_NEW_TAB_VOICE_OTHER_ERROR 9392
#define IDS_NEW_TAB_VOICE_PERMISSION_ERROR 9393
#define IDS_NEW_TAB_VOICE_READY 9394
#define IDS_NEW_TAB_VOICE_TRY_AGAIN 9395
#define IDS_NEW_TAB_VOICE_WAITING 9396
#define IDS_NEW_TAB_VOICE_SEARCH_CLOSED 9397
#define IDS_NEW_TAB_APP_OPTIONS 9398
#define IDS_NEW_TAB_APP_DETAILS 9399
#define IDS_NEW_TAB_APP_CREATE_SHORTCUT 9400
#define IDS_NEW_TAB_APP_INSTALL_LOCALLY 9401
#define IDS_APP_CONTEXT_MENU_SHOW_INFO 9402
#define IDS_APP_CONTEXT_MENU_OPEN_PINNED 9403
#define IDS_APP_CONTEXT_MENU_OPEN_REGULAR 9404
#define IDS_APP_CONTEXT_MENU_OPEN_WINDOW 9405
#define IDS_APP_CONTEXT_MENU_OPEN_FULLSCREEN 9406
#define IDS_APP_CONTEXT_MENU_OPEN_MAXIMIZED 9407
#define IDS_APP_CONTEXT_MENU_OPEN_TAB 9408
#define IDS_APP_CONTEXT_MENU_RUN_ON_OS_LOGIN 9413
#define IDS_APPS_PAGE_DEPRECATED_APP_TITLE 9416
#define IDS_SYNC_CONFIRMATION_TITLE 9417
#define IDS_SYNC_CONFIRMATION_SYNC_INFO_TITLE 9418
#define IDS_SYNC_CONFIRMATION_SYNC_INFO_DESC 9419
#define IDS_SYNC_CONFIRMATION_SETTINGS_INFO 9420
#define IDS_SYNC_CONFIRMATION_CONFIRM_BUTTON_LABEL 9421
#define IDS_SYNC_CONFIRMATION_SETTINGS_BUTTON_LABEL 9422
#define IDS_SYNC_CONFIRMATION_REFRESHED_SETTINGS_BUTTON_LABEL 9423
#define IDS_SYNC_DISABLED_CONFIRMATION_CHROME_SYNC_TITLE 9426
#define IDS_SYNC_DISABLED_CONFIRMATION_DETAILS 9427
#define IDS_SYNC_DISABLED_CONFIRMATION_CONFIRM_BUTTON_LABEL 9428
#define IDS_SYNC_DISABLED_CONFIRMATION_UNDO_BUTTON_LABEL 9429
#define IDS_SYNC_LOADING_CONFIRMATION_TITLE 9430
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL 9431
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_NEW_PROFILE_BUTTON_LABEL_V2 9432
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_BUTTON_LABEL 9433
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CANCEL_SWITCH_BUTTON_LABEL 9434
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CONFIRM_SWITCH_BUTTON_LABEL 9435
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_CONFIRM_SWITCH_BUTTON_LABEL_V2 9436
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_BUBBLE_GUEST_LINK 9437
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_BUBBLE_DESC 9438
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_SWITCH_BUBBLE_DESC_V2 9439
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_CREATE_BUBBLE_TITLE_V2 9440
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_DISCLAIMER 9441
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_MANAGED_BY_DISCLAIMER 9442
#define IDS_SIGNIN_DICE_WEB_INTERCEPT_ENTERPRISE_PROFILE_NAME 9443
#define IDS_SIGNIN_ERROR_TITLE 9444
#define IDS_SIGNIN_ERROR_EMAIL_TITLE 9445
#define IDS_SIGNIN_ERROR_DICE_EMAIL_TITLE 9446
#define IDS_SIGNIN_ERROR_CLOSE_BUTTON_LABEL 9447
#define IDS_SIGNIN_ERROR_OK_BUTTON_LABEL 9448
#define IDS_SIGNIN_ERROR_SWITCH_BUTTON_LABEL 9449
#define IDS_SIGNIN_ACCESSIBLE_CLOSE_BUTTON 9450
#define IDS_SIGNIN_ACCESSIBLE_BACK_BUTTON 9451
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_TITLE 9452
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CREATE_PROFILE_RADIO_BUTTON_SUBTITLE 9453
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_TITLE 9454
#define IDS_SIGNIN_EMAIL_CONFIRMATION_START_SYNC_RADIO_BUTTON_SUBTITLE 9455
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CLOSE_BUTTON_LABEL 9456
#define IDS_SIGNIN_EMAIL_CONFIRMATION_CONFIRM_BUTTON_LABEL 9457
#define IDS_ACCOUNT_PASSWORDS_REAUTH_TITLE 9458
#define IDS_ACCOUNT_PASSWORDS_REAUTH_DESC 9459
#define IDS_ACCOUNT_PASSWORDS_REAUTH_DESC_ALREADY_SAVED_LOCALLY 9460
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CONFIRM_BUTTON_LABEL 9461
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CLOSE_BUTTON_LABEL 9462
#define IDS_ACCOUNT_PASSWORDS_REAUTH_CLOSE_BUTTON_LABEL_ALREADY_SAVED_LOCALLY 9463
#define IDS_PLUGIN_OUTDATED_PROMPT 9464
#define IDS_PLUGIN_ENABLE_TEMPORARILY 9465
#define IDS_PLUGIN_CRASHED_PROMPT 9466
#define IDS_RELOAD_PAGE_WITH_PLUGIN 9468
#define IDS_PLUGIN_INITIALIZATION_ERROR_PROMPT 9469
#define IDS_EXTERNAL_PROTOCOL_TITLE 9470
#define IDS_EXTERNAL_PROTOCOL_MESSAGE_WITH_INITIATING_ORIGIN 9471
#define IDS_EXTERNAL_PROTOCOL_MESSAGE 9472
#define IDS_EXTERNAL_PROTOCOL_OK_BUTTON_TEXT 9473
#define IDS_EXTERNAL_PROTOCOL_CANCEL_BUTTON_TEXT 9474
#define IDS_EXTERNAL_PROTOCOL_CHECKBOX_PER_ORIGIN_TEXT 9475
#define IDS_DIRECTORY_LISTING_HEADER 9477
#define IDS_DIRECTORY_LISTING_PARENT 9478
#define IDS_DIRECTORY_LISTING_NAME 9479
#define IDS_DIRECTORY_LISTING_SIZE 9480
#define IDS_DIRECTORY_LISTING_DATE_MODIFIED 9481
#define IDS_SAVE_PAGE_DESC_HTML_ONLY 9482
#define IDS_SAVE_PAGE_DESC_SINGLE_FILE 9483
#define IDS_SAVE_PAGE_DESC_COMPLETE 9484
#define IDS_SAVE_PAGE_DESC_WEB_BUNDLE_FILE 9485
#define IDS_PROFILE_ERROR_DIALOG_TITLE 9486
#define IDS_COULDNT_OPEN_PROFILE_ERROR 9487
#define IDS_OPEN_PROFILE_DATA_LOSS 9488
#define IDS_PROFILE_ERROR_DIALOG_CHECKBOX 9489
#define IDS_PROFILE_ERROR_FEEDBACK_DESCRIPTION 9490
#define IDS_COULDNT_STARTUP_PROFILE_ERROR 9491
#define IDS_REFUSE_TO_RUN_AS_ROOT 9492
#define IDS_REFUSE_TO_RUN_AS_ROOT_2 9493
#define IDS_CANT_WRITE_USER_DIRECTORY_TITLE 9495
#define IDS_RECENT_TABS_MENU 9496
#define IDS_RECENTLY_CLOSED_WINDOW 9497
#define IDS_RECENTLY_CLOSED_GROUP 9498
#define IDS_RECENTLY_CLOSED_GROUP_UNNAMED 9499
#define IDS_RECENT_TABS_NO_DEVICE_TABS 282
#define IDS_HISTORY_MENU 283
#define IDS_DEFAULT_DOWNLOAD_FILENAME 9500
#define IDS_BROWSER_WINDOW_MAC_TAB_UNTITLED 9501
#define IDS_DEFAULT_BROWSER_INFOBAR_OK_BUTTON_LABEL 9502
#define IDS_USED_EXISTING_BROWSER 9508
#define IDS_DECLINE_RECOVERY 9509
#define IDS_SYNC_ACCOUNT_SYNCING 9510
#define IDS_SYNC_ACCOUNT_SYNCING_CUSTOM_DATA_TYPES 9511
#define IDS_SIGNIN_ERROR_DISPLAY_SOURCE 9512
#define IDS_SIGNIN_ERROR_BUBBLE_VIEW_TITLE 9513
#define IDS_SYNC_ERROR_BUBBLE_VIEW_TITLE 9514
#define IDS_SYNC_ERROR_PASSWORDS_BUBBLE_VIEW_TITLE 9515
#define IDS_SYNC_ERROR_USER_MENU_TITLE 9516
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE 9517
#define IDS_SYNC_ERROR_PASSWORDS_USER_MENU_TITLE_SIGNED_IN_ONLY 9518
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_EVERYTHING_USER_MENU_TITLE 9519
#define IDS_SYNC_ERROR_RECOVERABILITY_DEGRADED_FOR_PASSWORDS_USER_MENU_TITLE 9520
#define IDS_SYNC_ERROR_USER_MENU_SIGNIN_BUTTON 9521
#define IDS_SYNC_NEEDS_VERIFICATION_BUBBLE_VIEW_TITLE 9522
#define IDS_SYNC_ERROR_USER_MENU_PASSPHRASE_BUTTON 9523
#define IDS_SYNC_ERROR_USER_MENU_RECOVERABILITY_BUTTON 9524
#define IDS_SYNC_ERROR_USER_MENU_RETRIEVE_KEYS_BUTTON 9525
#define IDS_SYNC_ERROR_USER_MENU_SIGNOUT_BUTTON 9526
#define IDS_SYNC_ERROR_USER_MENU_CONFIRM_SYNC_SETTINGS_BUTTON 9527
#define IDS_SYNC_OVERVIEW 9533
#define IDS_SYNC_START_SYNC_BUTTON_LABEL 9534
#define IDS_SIGNED_IN_WITH_SYNC_DISABLED_BY_POLICY 9535
#define IDS_SIGNED_IN_WITH_SYNC_STOPPED_VIA_DASHBOARD 9536
#define IDS_SYNC_SETTINGS_NOT_CONFIRMED 9537
#define IDS_SYNC_SETUP_IN_PROGRESS 9538
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR 9539
#define IDS_SYNC_STATUS_UNRECOVERABLE_ERROR_NEEDS_SIGNOUT 9540
#define IDS_SYNC_STATUS_NEEDS_PASSWORD 9541
#define IDS_SYNC_STATUS_NEEDS_PASSWORD_BUTTON 9542
#define IDS_SYNC_STATUS_NEEDS_KEYS_BUTTON 9543
#define IDS_SYNC_SERVER_IS_UNREACHABLE 9544
#define IDS_SYNC_RELOGIN_ERROR 9545
#define IDS_SYNC_RELOGIN_BUTTON 9546
#define IDS_SYNC_ADVANCED_OPTIONS 9551
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM 9553
#define IDS_SYNC_FULL_ENCRYPTION_BODY_CUSTOM_WITH_DATE 9554
#define IDS_TRANSLATE_BUBBLE_BEFORE_TRANSLATE_TITLE 9555
#define IDS_TRANSLATE_BUBBLE_TRANSLATED_TITLE 9556
#define IDS_TRANSLATE_BUBBLE_COULD_NOT_TRANSLATE_TITLE 9557
#define IDS_TRANSLATE_BUBBLE_SOURCE_LANG_COMBOBOX_ACCNAME 9558
#define IDS_TRANSLATE_BUBBLE_TARGET_LANG_COMBOBOX_ACCNAME 9559
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_COMPLETE_ANNOUNCEMENT 9560
#define IDS_TRANSLATE_BUBBLE_ADVANCED_BUTTON 9561
#define IDS_TRANSLATE_BUBBLE_ADVANCED_MENU_BUTTON 9562
#define IDS_TRANSLATE_BUBBLE_CHANGE_TARGET_LANGUAGE 9563
#define IDS_TRANSLATE_BUBBLE_CHANGE_SOURCE_LANGUAGE 9564
#define IDS_TRANSLATE_BUBBLE_ACCEPT 9565
#define IDS_TRANSLATE_BUBBLE_DENY 9566
#define IDS_TRANSLATE_BUBBLE_ALWAYS_TRANSLATE_LANG 9567
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_LANG 9568
#define IDS_TRANSLATE_BUBBLE_NEVER_TRANSLATE_SITE 9569
#define IDS_TRANSLATE_BUBBLE_TRANSLATING 9570
#define IDS_TRANSLATE_BUBBLE_REVERT 9571
#define IDS_TRANSLATE_BUBBLE_TRY_AGAIN 9572
#define IDS_TRANSLATE_BUBBLE_ALWAYS 9573
#define IDS_TRANSLATE_BUBBLE_OPTIONS_MENU_BUTTON 9574
#define IDS_TRANSLATE_BUBBLE_PAGE_LANGUAGE 9575
#define IDS_TRANSLATE_BUBBLE_TRANSLATION_LANGUAGE 9576
#define IDS_TRANSLATE_BUBBLE_ADVANCED_TARGET 9577
#define IDS_TRANSLATE_BUBBLE_ADVANCED_SOURCE 9578
#define IDS_PARTIAL_TRANSLATE_BUBBLE_TRANSLATE_FULL_PAGE 9579
#define IDS_TRANSLATE_BUBBLE_RESET 9580
#define IDS_NOTIFICATION_BUTTON_SETTINGS 9581
#define IDS_NOTIFICATION_BUTTON_CLOSE 9582
#define IDS_NOTIFICATION_BUTTON_MORE 9583
#define IDS_NOTIFICATION_REPLY_PLACEHOLDER 9584
#define IDS_NOTIFICATION_MUTED_MESSAGE 9585
#define IDS_NOTIFICATION_MUTED_TITLE 9586
#define IDS_NOTIFICATION_MUTED_ACTION_SHOW 9587
#define IDS_NOTIFICATION_MUTED_ACTION_SNOOZE 9588
#define IDS_GET_PROFILE_ERROR_APPLESCRIPT_MAC 9595
#define IDS_BOOKMARK_MODEL_LOAD_ERROR_APPLESCRIPT_MAC 9596
#define IDS_CREATE_BOOKMARK_FOLDER_ERROR_APPLESCRIPT_MAC 9597
#define IDS_CREATE_BOOKMARK_ITEM_ERROR_APPLESCRIPT_MAC 9598
#define IDS_INVALID_URL_APPLESCRIPT_MAC 9599
#define IDS_INITIATE_PRINTING_ERROR_APPLESCRIPT_MAC 9600
#define IDS_INVALID_SAVE_TYPE_ERROR_APPLESCRIPT_MAC 9601
#define IDS_INVALID_MODE_ERROR_APPLESCRIPT_MAC 9602
#define IDS_INVALID_TAB_INDEX_APPLESCRIPT_MAC 9603
#define IDS_SET_MODE_APPLESCRIPT_MAC 9604
#define IDS_WRONG_INDEX_ERROR_APPLESCRIPT_MAC 9605
#define IDS_JAVASCRIPT_UNSUPPORTED_ERROR_APPLESCRIPT_MAC 9606
#define IDS_FILE_MENU_MAC 114
#define IDS_EDIT_MENU_MAC 127
#define IDS_VIEW_MENU_MAC 151
#define IDS_HISTORY_MENU_MAC 166
#define IDS_WINDOW_MENU_MAC 177
#define IDS_TAB_MENU_MAC 9607
#define IDS_HELP_MENU_MAC 187
#define IDS_ABOUT_MAC 104
#define IDS_SERVICES_MAC 108
#define IDS_HIDE_APP_MAC 109
#define IDS_HIDE_OTHERS_MAC 110
#define IDS_SHOW_ALL_MAC 111
#define IDS_EXIT_MAC 113
#define IDS_NEW_MAC 331
#define IDS_NEW_TAB_MAC 115
#define IDS_NEW_WINDOW_MAC 116
#define IDS_NEW_INCOGNITO_WINDOW_MAC 117
#define IDS_REOPEN_CLOSED_TABS_MAC 118
#define IDS_OPEN_FILE_MAC 119
#define IDS_OPEN_LOCATION_MAC 120
#define IDS_CLOSE_WINDOW_MAC 121
#define IDS_CLOSE_TAB_MAC 122
#define IDS_SAVE_PAGE_MAC 123
#define IDS_EMAIL_LINK_MAC 9608
#define IDS_SHARING_MORE_MAC 9609
#define IDS_SHARE_MAC 9610
#define IDS_PRINT_USING_SYSTEM_DIALOG_MAC 126
#define IDS_EDIT_UNDO_MAC 128
#define IDS_EDIT_REDO_MAC 129
#define IDS_CUT_MAC 130
#define IDS_COPY_MAC 131
#define IDS_PASTE_MAC 132
#define IDS_PASTE_MATCH_STYLE_MAC 133
#define IDS_EDIT_DELETE_MAC 134
#define IDS_EDIT_SELECT_ALL_MAC 135
#define IDS_EDIT_FIND_SUBMENU_MAC 136
#define IDS_EDIT_SEARCH_WEB_MAC 137
#define IDS_EDIT_FIND_MAC 138
#define IDS_EDIT_FIND_NEXT_MAC 139
#define IDS_EDIT_FIND_PREVIOUS_MAC 140
#define IDS_EDIT_USE_SELECTION_MAC 141
#define IDS_EDIT_JUMP_TO_SELECTION_MAC 142
#define IDS_EDIT_SPELLING_GRAMMAR_MAC 143
#define IDS_EDIT_SHOW_SPELLING_GRAMMAR_MAC 144
#define IDS_EDIT_CHECK_DOCUMENT_MAC 145
#define IDS_EDIT_CHECK_SPELLING_TYPING_MAC 146
#define IDS_EDIT_CHECK_GRAMMAR_MAC 147
#define IDS_EDIT_SUBSTITUTIONS_MAC 9611
#define IDS_EDIT_SHOW_SUBSTITUTIONS_MAC 9612
#define IDS_EDIT_SMART_QUOTES_MAC 9613
#define IDS_EDIT_SMART_DASHES_MAC 9614
#define IDS_EDIT_TEXT_REPLACEMENT_MAC 9615
#define IDS_EDIT_TRANSFORMATIONS_MAC 9616
#define IDS_EDIT_MAKE_UPPERCASE_MAC 9617
#define IDS_EDIT_MAKE_LOWERCASE_MAC 9618
#define IDS_EDIT_CAPITALIZE_MAC 9619
#define IDS_BOOKMARK_BAR_ALWAYS_SHOW_MAC 152
#define IDS_STOP_MENU_MAC 154
#define IDS_RELOAD_MENU_MAC 155
#define IDS_RELOAD_BYPASSING_CACHE_MENU_MAC 156
#define IDS_ENTER_FULLSCREEN_MAC 157
#define IDS_EXIT_FULLSCREEN_MAC 9620
#define IDS_TOGGLE_FULLSCREEN_TOOLBAR_MAC 153
#define IDS_TEXT_BIGGER_MAC 159
#define IDS_TEXT_DEFAULT_MAC 158
#define IDS_TEXT_SMALLER_MAC 160
#define IDS_DEVELOPER_MENU_MAC 162
#define IDS_VIEW_SOURCE_MAC 163
#define IDS_DEV_TOOLS_MAC 164
#define IDS_DEV_TOOLS_CONSOLE_MAC 165
#define IDS_DEV_TOOLS_ELEMENTS_MAC 9621
#define IDS_ALLOW_JAVASCRIPT_APPLE_EVENTS_MAC 9622
#define IDS_TASK_MANAGER_MAC 185
#define IDS_HISTORY_HOME_MAC 167
#define IDS_HISTORY_BACK_MAC 168
#define IDS_HISTORY_FORWARD_MAC 169
#define IDS_HISTORY_VISITED_MAC 171
#define IDS_HISTORY_CLOSED_MAC 170
#define IDS_HISTORY_CLOSED_RESTORE_WINDOW_MAC 9623
#define IDS_MINIMIZE_WINDOW_MAC 178
#define IDS_ZOOM_WINDOW_MAC 179
#define IDS_NEXT_TAB_MAC 180
#define IDS_PREV_TAB_MAC 181
#define IDS_SHOW_DOWNLOADS_MAC 183
#define IDS_WINDOW_AUDIO_PLAYING_MAC 9624
#define IDS_WINDOW_AUDIO_MUTING_MAC 9625
#define IDS_SHOW_EXTENSIONS_MAC 184
#define IDS_ALL_WINDOWS_FRONT_MAC 186
#define IDS_DUPLICATE_TAB_MAC 9626
#define IDS_DUPLICATE_TARGET_TAB_MAC 9627
#define IDS_MUTE_SITE_MAC 9628
#define IDS_MUTE_TARGET_SITE_MAC 9629
#define IDS_PIN_TAB_MAC 9630
#define IDS_PIN_TARGET_TAB_MAC 9631
#define IDS_GROUP_TAB_MAC 9632
#define IDS_GROUP_TARGET_TAB_MAC 9633
#define IDS_FEEDBACK_MAC 188
#define IDS_HELP_MAC 189
#define IDS_ALLOWED_GEOLOCATION_TITLE 9656
#define IDS_BLOCKED_GEOLOCATION_TITLE 9657
#define IDS_ALLOWED_GEOLOCATION_MESSAGE 9658
#define IDS_ALLOWED_GEOLOCATION_BLOCK 9659
#define IDS_ALLOWED_GEOLOCATION_NO_ACTION 9660
#define IDS_BLOCKED_GEOLOCATION_MESSAGE 9661
#define IDS_BLOCKED_GEOLOCATION_UNBLOCK 9662
#define IDS_BLOCKED_GEOLOCATION_NO_ACTION 9663
#define IDS_GEOLOCATION 9664
#define IDS_GEOLOCATION_WILL_ASK_AGAIN 9665
#define IDS_GEOLOCATION_TURNED_OFF_IN_MACOS 9666
#define IDS_GEOLOCATION_TURNED_OFF_IN_MACOS_SETTINGS 9667
#define IDS_GEOLOCATION_TURNED_OFF 9668
#define IDS_ALLOWED_MIDI_SYSEX_TITLE 9669
#define IDS_BLOCKED_MIDI_SYSEX_TITLE 9670
#define IDS_ALLOWED_MIDI_SYSEX_MESSAGE 9671
#define IDS_ALLOWED_MIDI_SYSEX_BLOCK 9672
#define IDS_ALLOWED_MIDI_SYSEX_NO_ACTION 9673
#define IDS_BLOCKED_MIDI_SYSEX_MESSAGE 9674
#define IDS_BLOCKED_MIDI_SYSEX_UNBLOCK 9675
#define IDS_BLOCKED_MIDI_SYSEX_NO_ACTION 9676
#define IDS_MICROPHONE_CAMERA_ALLOWED 9677
#define IDS_MICROPHONE_CAMERA_BLOCKED 9678
#define IDS_MICROPHONE_ACCESSED 9679
#define IDS_CAMERA_ACCESSED 9680
#define IDS_MICROPHONE_BLOCKED 9681
#define IDS_CAMERA_BLOCKED 9682
#define IDS_MICROPHONE_CAMERA_ALLOWED_TITLE 9683
#define IDS_MICROPHONE_CAMERA_BLOCKED_TITLE 9684
#define IDS_MICROPHONE_ACCESSED_TITLE 9685
#define IDS_CAMERA_ACCESSED_TITLE 9686
#define IDS_MICROPHONE_BLOCKED_TITLE 9687
#define IDS_CAMERA_BLOCKED_TITLE 9688
#define IDS_MEDIASTREAM_SETTING_CHANGED_MESSAGE 9689
#define IDS_CAMERA_MIC_TURNED_OFF_IN_MACOS 9690
#define IDS_CAMERA_TURNED_OFF_IN_MACOS 9691
#define IDS_MIC_TURNED_OFF_IN_MACOS 9692
#define IDS_OPEN_PREFERENCES_LINK 9693
#define IDS_CAMERA 9694
#define IDS_MIC 9695
#define IDS_TURNED_OFF 9696
#define IDS_CAMERA_TURNED_OFF 9697
#define IDS_MIC_TURNED_OFF 9698
#define IDS_A11Y_OMNIBOX_CHIP_HINT 9699
#define IDS_MANAGE_PASSWORDS_CONFIRM_GENERATED_TEXT 9700
#define IDS_PASSWORDS_WEB_LINK 9701
#define IDS_MANAGE_PASSWORDS_LINK 9703
#define IDS_MANAGE_PASSWORDS_TITLE 9704
#define IDS_MANAGE_PASSWORDS_NO_PASSWORDS_TITLE 9705
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_TITLE 9706
#define IDS_MANAGE_PASSWORDS_DIFFERENT_DOMAIN_NO_PASSWORDS_TITLE 9707
#define IDS_MANAGE_PASSWORDS_ACCOUNT_STORE_ICON_DESCRIPTION 9708
#define IDS_MANAGE_PASSWORDS_DELETED 9709
#define IDS_MANAGE_PASSWORDS_UNDO 9710
#define IDS_MANAGE_PASSWORDS_UNDO_TOOLTIP 9711
#define IDS_MANAGE_PASSWORDS_DELETE 9712
#define IDS_MANAGE_PASSWORDS_SHOW_PASSWORD 9713
#define IDS_MANAGE_PASSWORDS_HIDE_PASSWORD 9714
#define IDS_MANAGE_PASSWORDS_AUTO_SIGNIN_TITLE_MD 9715
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_MANY_DEVICES 9716
#define IDS_AUTO_SIGNIN_FIRST_RUN_TITLE_LOCAL_DEVICE 9717
#define IDS_AUTO_SIGNIN_FIRST_RUN_TEXT 9718
#define IDS_AUTO_SIGNIN_FIRST_RUN_OK 9719
#define IDS_PLEASE_RELAUNCH_BROWSER 9720
#define IDS_INSTALL_FROM_DMG_TITLE 9721
#define IDS_INSTALL_FROM_DMG_PROMPT 9722
#define IDS_INSTALL_FROM_DMG_YES 9723
#define IDS_INSTALL_FROM_DMG_NO 9724
#define IDS_INSTALL_FROM_DMG_AUTHENTICATION_PROMPT 9725
#define IDS_INSTALL_FROM_DMG_ERROR_TITLE 9726
#define IDS_INSTALL_FROM_DMG_ERROR 9727
#define IDS_FILE_SELECTION_DIALOG_INFOBAR 9728
#define IDS_IMAGE_FILES 9731
#define IDS_AUDIO_FILES 9732
#define IDS_VIDEO_FILES 9733
#define IDS_CUSTOM_FILES 9734
#define IDS_FULLSCREEN_USER_ENTERED_FULLSCREEN 9735
#define IDS_FULLSCREEN_EXTENSION_TRIGGERED_FULLSCREEN 9736
#define IDS_FULLSCREEN_UNKNOWN_EXTENSION_TRIGGERED_FULLSCREEN 9737
#define IDS_FULLSCREEN_SITE_ENTERED_FULLSCREEN 9738
#define IDS_FULLSCREEN_ENTERED_FULLSCREEN 9739
#define IDS_FULLSCREEN_SITE_ENTERED_FULLSCREEN_MOUSELOCK 9740
#define IDS_FULLSCREEN_ENTERED_FULLSCREEN_MOUSELOCK 9741
#define IDS_FULLSCREEN_SITE_ENTERED_MOUSELOCK 9742
#define IDS_FULLSCREEN_ENTERED_MOUSELOCK 9743
#define IDS_FULLSCREEN_PRESS_ESC_TO_EXIT_MOUSELOCK 9744
#define IDS_SENSORS_ALLOWED_TOOLTIP 9745
#define IDS_MOTION_SENSORS_ALLOWED_TOOLTIP 9746
#define IDS_SENSORS_BLOCKED_TOOLTIP 9747
#define IDS_MOTION_SENSORS_BLOCKED_TOOLTIP 9748
#define IDS_BLOCKED_SENSORS_UNBLOCK 9749
#define IDS_BLOCKED_SENSORS_NO_ACTION 9750
#define IDS_ALLOWED_SENSORS_TITLE 9751
#define IDS_BLOCKED_SENSORS_TITLE 9752
#define IDS_ALLOWED_SENSORS_MESSAGE 9753
#define IDS_ALLOWED_MOTION_SENSORS_MESSAGE 9754
#define IDS_BLOCKED_SENSORS_MESSAGE 9755
#define IDS_BLOCKED_MOTION_SENSORS_MESSAGE 9756
#define IDS_ALLOWED_SENSORS_NO_ACTION 9757
#define IDS_ALLOWED_SENSORS_BLOCK 9758
#define IDS_LIVE_CAPTION_PROMO 9765
#define IDS_LIVE_CAPTION_PROMO_SCREENREADER 9766
#define IDS_ENABLE_CARET_BROWSING_INFO 9767
#define IDS_CARET_BROWSING_DO_NOT_ASK 9768
#define IDS_ENABLE_CARET_BROWSING_TITLE 9769
#define IDS_ENABLE_CARET_BROWSING_TURN_ON 9770
#define IDS_MEDIA_GALLERIES_DIALOG_HEADER 9771
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_WRITE 9772
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_DELETE 9773
#define IDS_MEDIA_GALLERIES_DIALOG_SUBTEXT_READ_ONLY 9774
#define IDS_MEDIA_GALLERIES_PERMISSION_SUGGESTIONS 9775
#define IDS_MEDIA_GALLERIES_LAST_ATTACHED 9776
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY 9777
#define IDS_MEDIA_GALLERIES_DIALOG_CONFIRM 9778
#define IDS_MEDIA_GALLERIES_DIALOG_ADD_GALLERY_TITLE 9779
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_ATTACHED 9780
#define IDS_MEDIA_GALLERIES_DIALOG_DEVICE_NOT_ATTACHED 9781
#define IDS_MEDIA_GALLERIES_DIALOG_DELETE 9782
#define IDS_CHROME_SHORTCUT_DESCRIPTION 9802
#define IDS_WEBSTORE_NAME_STORE 245
#define IDS_DESKTOP_MEDIA_PICKER_TITLE 9803
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_SCREEN_ONLY 9804
#define IDS_DESKTOP_MEDIA_PICKER_TITLE_WINDOW_ONLY 9805
#define IDS_DESKTOP_MEDIA_PICKER_TEXT 9806
#define IDS_DESKTOP_MEDIA_PICKER_TEXT_DELEGATED 9807
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_SCREEN 9808
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_WINDOW 9809
#define IDS_DESKTOP_MEDIA_PICKER_AUDIO_SHARE_TAB 9810
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_SCREEN 9811
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_WINDOW 9812
#define IDS_DESKTOP_MEDIA_PICKER_SINGLE_SCREEN_NAME 9813
#define IDS_DESKTOP_MEDIA_PICKER_MULTIPLE_SCREEN_NAME 9814
#define IDS_DESKTOP_MEDIA_PICKER_MANAGED 9815
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_THIS_TAB 9816
#define IDS_DESKTOP_MEDIA_PICKER_SOURCE_TYPE_OTHER_TAB 9817
#define IDS_DESKTOP_MEDIA_PICKER_EMPTY_PREVIEW 9818
#define IDS_DESKTOP_MEDIA_PICKER_PREVIEW_ACCESSIBLE_NAME 9819
#define IDS_DESKTOP_MEDIA_SOURCE_EMPTY_ACCESSIBLE_NAME 9820
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TITLE 9821
#define IDS_TAB_CAPTURE_TERMINATED_BY_POLICY_TEXT 9822
#define IDS_TOOLTIP_TAB_ALERT_STATE_MEDIA_RECORDING 9823
#define IDS_TOOLTIP_TAB_ALERT_STATE_TAB_CAPTURING 9824
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_PLAYING 9825
#define IDS_TOOLTIP_TAB_ALERT_STATE_AUDIO_MUTING 9826
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_CONNECTED 9827
#define IDS_TOOLTIP_TAB_ALERT_STATE_BLUETOOTH_SCAN_ACTIVE 9828
#define IDS_TOOLTIP_TAB_ALERT_STATE_USB_CONNECTED 9829
#define IDS_TOOLTIP_TAB_ALERT_STATE_HID_CONNECTED 9830
#define IDS_TOOLTIP_TAB_ALERT_STATE_SERIAL_CONNECTED 9831
#define IDS_TOOLTIP_TAB_ALERT_STATE_PIP_PLAYING 9832
#define IDS_TOOLTIP_TAB_ALERT_STATE_DESKTOP_CAPTURING 9833
#define IDS_TOOLTIP_TAB_ALERT_STATE_VR_PRESENTING 9834
#define IDS_TAB_AX_LABEL_MEDIA_RECORDING_FORMAT 9835
#define IDS_TAB_AX_LABEL_TAB_CAPTURING_FORMAT 9836
#define IDS_TAB_AX_LABEL_PIP_PLAYING_FORMAT 9837
#define IDS_TAB_AX_LABEL_AUDIO_PLAYING_FORMAT 9838
#define IDS_TAB_AX_LABEL_AUDIO_MUTING_FORMAT 9839
#define IDS_TAB_AX_LABEL_BLUETOOTH_CONNECTED_FORMAT 9840
#define IDS_TAB_AX_LABEL_BLUETOOTH_SCAN_ACTIVE_FORMAT 9841
#define IDS_TAB_AX_LABEL_USB_CONNECTED_FORMAT 9842
#define IDS_TAB_AX_LABEL_HID_CONNECTED_FORMAT 9843
#define IDS_TAB_AX_LABEL_SERIAL_CONNECTED_FORMAT 9844
#define IDS_TAB_AX_LABEL_NETWORK_ERROR_FORMAT 9845
#define IDS_TAB_AX_LABEL_CRASHED_FORMAT 9846
#define IDS_TAB_AX_LABEL_DESKTOP_CAPTURING_FORMAT 9847
#define IDS_TAB_AX_LABEL_VR_PRESENTING 9848
#define IDS_TAB_AX_LABEL_UNNAMED_GROUP_FORMAT 9849
#define IDS_TAB_AX_LABEL_NAMED_GROUP_FORMAT 9850
#define IDS_TAB_AX_LABEL_PERMISSION_REQUESTED_FORMAT 9851
#define IDS_GROUP_AX_LABEL_UNNAMED_GROUP_FORMAT 9852
#define IDS_GROUP_AX_LABEL_NAMED_GROUP_FORMAT 9853
#define IDS_GROUP_AX_LABEL_COLLAPSED 9854
#define IDS_GROUP_AX_LABEL_EXPANDED 9855
#define IDS_TAB_AX_ANNOUNCE_MOVED_RIGHT 9856
#define IDS_TAB_AX_ANNOUNCE_MOVED_LEFT 9857
#define IDS_TAB_AX_ANNOUNCE_MOVED_FIRST 9858
#define IDS_TAB_AX_ANNOUNCE_MOVED_LAST 9859
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_UNNAMED_GROUP 9860
#define IDS_TAB_AX_ANNOUNCE_TAB_ADDED_TO_NAMED_GROUP 9861
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_UNNAMED_GROUP 9862
#define IDS_TAB_AX_ANNOUNCE_TAB_REMOVED_FROM_NAMED_GROUP 9863
#define IDS_PAGE_LOADING_AX_TITLE_FORMAT 9864
#define IDS_PROFILE_IN_USE_LINUX_QUIT 9865
#define IDS_PROFILE_IN_USE_LINUX_RELAUNCH 9866
#define IDS_DESKTOP_MEDIA_PICKER_SHARE 9877
#define IDS_PUSH_MESSAGING_GENERIC_NOTIFICATION_BODY 9878
#define IDS_DEVICE_PERMISSIONS_DIALOG_SELECT 9879
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL 9880
#define IDS_DEVICE_PERMISSIONS_DIALOG_LOADING_LABEL_TOOLTIP 9881
#define IDS_DEVICE_LOG_TITLE 9882
#define IDS_DEVICE_AUTO_REFRESH 9883
#define IDS_DEVICE_LOG_REFRESH 9884
#define IDS_DEVICE_LOG_CLEAR 9885
#define IDS_DEVICE_LOG_CLEAR_TYPES 9886
#define IDS_DEVICE_LOG_NO_ENTRIES 9887
#define IDS_DEVICE_LOG_LEVEL_LABEL 9888
#define IDS_DEVICE_LOG_LEVEL_ERROR 9889
#define IDS_DEVICE_LOG_LEVEL_USER 9890
#define IDS_DEVICE_LOG_LEVEL_EVENT 9891
#define IDS_DEVICE_LOG_LEVEL_DEBUG 9892
#define IDS_DEVICE_LOG_TYPE_LOGIN 9893
#define IDS_DEVICE_LOG_TYPE_NETWORK 9894
#define IDS_DEVICE_LOG_TYPE_POWER 9895
#define IDS_DEVICE_LOG_TYPE_BLUETOOTH 9896
#define IDS_DEVICE_LOG_TYPE_USB 9897
#define IDS_DEVICE_LOG_TYPE_HID 9898
#define IDS_DEVICE_LOG_TYPE_PRINTER 9899
#define IDS_DEVICE_LOG_TYPE_FIDO 9900
#define IDS_DEVICE_LOG_TYPE_SERIAL 9901
#define IDS_DEVICE_LOG_TYPE_CAMERA 9902
#define IDS_DEVICE_LOG_FILEINFO 9903
#define IDS_DEVICE_LOG_TIME_DETAIL 9904
#define IDS_DEVICE_LOG_ENTRY 9905
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION 9906
#define IDS_WEBUSB_DEVICE_DETECTED_NOTIFICATION_TITLE 9907
#define IDS_DEFAULT_AUDIO_DEVICE_NAME 9916
#define IDS_BLUETOOTH_DEVICE_CHOOSER_PROMPT_EXTENSION_NAME 9918
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ADAPTER_OFF 9919
#define IDS_BLUETOOTH_DEVICE_CHOOSER_TURN_ON_BLUETOOTH_LINK_TEXT 9920
#define IDS_BLUETOOTH_DEVICE_CHOOSER_AUTHORIZE_BLUETOOTH_LINK_TEXT 9921
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN 9922
#define IDS_BLUETOOTH_DEVICE_CHOOSER_RE_SCAN_TOOLTIP 9923
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_SCANNING_STATUS 9924
#define IDS_DEVICE_CHOOSER_GET_HELP_LINK_WITH_RE_SCAN_LINK 9925
#define IDS_DEVICE_CHOOSER_PAIRED_STATUS_TEXT 9926
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_AND_PAIRED_STATUS_TEXT 9927
#define IDS_USB_DEVICE_CHOOSER_PROMPT_EXTENSION_NAME 9928
#define IDS_DEVICE_CHOOSER_ACCNAME_COMPATIBLE_DEVICES_LIST 9929
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_NAME 9930
#define IDS_DEVICE_CHOOSER_DEVICE_NAME_UNKNOWN_DEVICE_WITH_VENDOR_ID_AND_PRODUCT_ID 9931
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_NAME 9932
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_PRODUCT_ID_AND_VENDOR_ID 9933
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_ID 9934
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_VENDOR_NAME 9935
#define IDS_USB_POLICY_DEVICE_DESCRIPTION_FOR_ANY_VENDOR 9936
#define IDS_SERIAL_PORT_CHOOSER_PROMPT_ORIGIN 9937
#define IDS_SERIAL_PORT_CHOOSER_PROMPT_EXTENSION_NAME 9938
#define IDS_SERIAL_PORT_CHOOSER_NAME_WITH_PATH 9939
#define IDS_SERIAL_PORT_CHOOSER_PATH_ONLY 9940
#define IDS_SERIAL_PORT_CHOOSER_CONNECT_BUTTON_TEXT 9941
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL 9942
#define IDS_SERIAL_PORT_CHOOSER_LOADING_LABEL_TOOLTIP 9943
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_NAME 9944
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_PRODUCT_ID_AND_VENDOR_ID 9945
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_ID 9946
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_USB_VENDOR_NAME 9947
#define IDS_SERIAL_POLICY_DESCRIPTION_FOR_ANY_PORT 9948
#define IDS_HID_CHOOSER_PROMPT_ORIGIN 9949
#define IDS_HID_CHOOSER_PROMPT_EXTENSION_NAME 9950
#define IDS_HID_CHOOSER_ITEM_WITHOUT_NAME 9951
#define IDS_HID_CHOOSER_LOADING_LABEL 9952
#define IDS_HID_CHOOSER_LOADING_LABEL_TOOLTIP 9953
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID_AND_PRODUCT_ID 9954
#define IDS_HID_POLICY_DESCRIPTION_FOR_VENDOR_ID 9955
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_AND_USAGE_PAGE 9956
#define IDS_HID_POLICY_DESCRIPTION_FOR_USAGE_PAGE 9957
#define IDS_HID_POLICY_DESCRIPTION_FOR_ANY_DEVICE 9958
#define IDS_WEB_APP_FILE_HANDLING_LIST_SEPARATOR 9959
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION 9960
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_QUESTION_MULTIPLE 9961
#define IDS_WEB_APP_FILE_HANDLING_DIALOG_STICKY_CHOICE 9962
#define IDS_WEB_APP_FILE_HANDLING_POSITIVE_BUTTON 9963
#define IDS_WEB_APP_FILE_HANDLING_NEGATIVE_BUTTON 9964
#define IDS_WEB_APP_PERMISSION_NEGATIVE_BUTTON 9965
#define IDS_PROTOCOL_HANDLER_INTENT_PICKER_QUESTION 9966
#define IDS_FONT_ACCESS_CHOOSER_PROMPT_ORIGIN 9967
#define IDS_FONT_ACCESS_CHOOSER_NO_FONTS_FOUND_PROMPT 9968
#define IDS_FONT_ACCESS_CHOOSER_IMPORT_BUTTON_TEXT 9969
#define IDS_FONT_ACCESS_CHOOSER_CANCEL_BUTTON_TEXT 9970
#define IDS_FONT_ACCESS_CHOOSER_SELECT_ALL_CHECKBOX_TEXT 9971
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL 9972
#define IDS_FONT_ACCESS_CHOOSER_LOADING_LABEL_TOOLTIP 9973
#define IDS_IME_API_ACTIVATED_WARNING 9974
#define IDS_IME_API_NEVER_SHOW 9975
#define IDS_BLOCKED_ADS_PROMPT_TOOLTIP 9976
#define IDS_REDIRECT_BLOCKED_MESSAGE 9980
#define IDS_REDIRECT_BLOCKED_TITLE 9981
#define IDS_REDIRECT_BLOCKED_TOOLTIP 9982
#define IDS_ALWAYS_ALLOW_REDIRECTS 9983
#define IDS_OPEN_REDIRECT 9984
#define IDS_CONTROLLED_BY_AUTOMATION 9997
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_TITLE 9999
#define IDS_DOWNLOAD_OPEN_CONFIRMATION_DIALOG_MESSAGE 10000
#define IDS_CONFIRM_FILE_UPLOAD_TITLE 10001
#define IDS_CONFIRM_FILE_UPLOAD_TEXT 10002
#define IDS_CONFIRM_FILE_UPLOAD_OK_BUTTON 10003
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_TITLE 10004
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_ALLOW_TEXT 10005
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_FILE_TEXT 10006
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_WRITE_PERMISSION_DIRECTORY_TEXT 10007
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_FILE_TEXT 10008
#define IDS_FILE_SYSTEM_ACCESS_ORIGIN_SCOPED_READ_PERMISSION_DIRECTORY_TEXT 10009
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_FILE_TEXT 10010
#define IDS_FILE_SYSTEM_ACCESS_WRITE_PERMISSION_DIRECTORY_TEXT 10011
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_FILE_TEXT 10012
#define IDS_FILE_SYSTEM_ACCESS_READ_PERMISSION_DIRECTORY_TEXT 10013
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_TITLE 10014
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_TITLE 10015
#define IDS_FILE_SYSTEM_ACCESS_READ_FILE_PERMISSION_TITLE 10016
#define IDS_FILE_SYSTEM_ACCESS_READ_DIRECTORY_PERMISSION_TITLE 10017
#define IDS_FILE_SYSTEM_ACCESS_EDIT_FILE_PERMISSION_ALLOW_TEXT 10018
#define IDS_FILE_SYSTEM_ACCESS_EDIT_DIRECTORY_PERMISSION_ALLOW_TEXT 10019
#define IDS_FILE_SYSTEM_ACCESS_VIEW_FILE_PERMISSION_ALLOW_TEXT 10020
#define IDS_FILE_SYSTEM_ACCESS_VIEW_DIRECTORY_PERMISSION_ALLOW_TEXT 10021
#define IDS_FILE_SYSTEM_ACCESS_WRITE_USAGE_TOOLTIP 10022
#define IDS_FILE_SYSTEM_ACCESS_DIRECTORY_USAGE_TOOLTIP 10023
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_FILE_TEXT 10024
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_TEXT 10025
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_WRITABLE_DIRECTORY_TEXT 10026
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_DIRECTORIES_TEXT 10027
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_WRITABLE_FILES_AND_DIRECTORIES_TEXT 10028
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_FILE_TEXT 10029
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_TEXT 10030
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SINGLE_READABLE_DIRECTORY_TEXT 10031
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_DIRECTORIES_TEXT 10032
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READABLE_FILES_AND_DIRECTORIES_TEXT 10033
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_READ_AND_WRITE 10034
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_SAVE_CHANGES 10035
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_VIEW_CHANGES 10036
#define IDS_FILE_SYSTEM_ACCESS_USAGE_BUBBLE_FILES_TEXT 10037
#define IDS_FILE_SYSTEM_ACCESS_USAGE_EXPAND 10038
#define IDS_FILE_SYSTEM_ACCESS_USAGE_COLLAPSE 10039
#define IDS_FILE_SYSTEM_ACCESS_USAGE_REMOVE_ACCESS 10040
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_READABLE_DIRECTORY_TITLE 10041
#define IDS_FILE_SYSTEM_ACCESS_CHOOSER_OPEN_WRITABLE_DIRECTORY_TITLE 10042
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TITLE 10043
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_TEXT 10044
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_DIRECTORY_BUTTON 10045
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TITLE 10046
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_TEXT 10047
#define IDS_FILE_SYSTEM_ACCESS_RESTRICTED_FILE_BUTTON 10048
#define IDS_RELAUNCH_ACCEPT_BUTTON 10049
#define IDS_RELAUNCH_REQUIRED_CANCEL_BUTTON 10050
#define IDS_WEBAUTHN_GENERIC_TITLE 10051
#define IDS_WEBAUTHN_CONTINUE 10052
#define IDS_WEBAUTHN_TRANSPORT_SELECTION_TITLE 10053
#define IDS_WEBAUTHN_TRANSPORT_SELECTION_DESCRIPTION 10054
#define IDS_WEBAUTHN_TRANSPORT_USB 10055
#define IDS_WEBAUTHN_TRANSPORT_INTERNAL 10056
#define IDS_WEBAUTHN_TRANSPORT_CABLE 10057
#define IDS_WEBAUTHN_TRANSPORT_AOA 10058
#define IDS_WEBAUTHN_TRANSPORT_POPUP_DIFFERENT_AUTHENTICATOR_WIN 10059
#define IDS_WEBAUTHN_USB_ACTIVATE_DESCRIPTION 10060
#define IDS_WEBAUTHN_ERROR_GENERIC_TITLE 10061
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_TITLE 10062
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_REGISTER_DESCRIPTION 10063
#define IDS_WEBAUTHN_ERROR_WRONG_KEY_SIGN_DESCRIPTION 10064
#define IDS_WEBAUTHN_ERROR_TIMEOUT_DESCRIPTION 10065
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_TITLE 10066
#define IDS_WEBAUTHN_ERROR_INTERNAL_UNRECOGNIZED_DESCRIPTION 10067
#define IDS_WEBAUTHN_ERROR_NO_TRANSPORTS_TITLE 10068
#define IDS_WEBAUTHN_ERROR_NO_TRANSPORTS_DESCRIPTION 10069
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_TITLE 10070
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_DESCRIPTION 10071
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_AUTO_NEXT 10072
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_TITLE 10073
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_DESCRIPTION 10074
#define IDS_WEBAUTHN_BLUETOOTH_POWER_ON_MANUAL_NEXT 10075
#define IDS_WEBAUTHN_BLUETOOTH_PERMISSION 10076
#define IDS_WEBAUTHN_TRANSPORT_POPUP_LABEL 10077
#define IDS_WEBAUTHN_TRANSPORT_POPUP_USB 10078
#define IDS_WEBAUTHN_TRANSPORT_POPUP_PAIR_PHONE 10079
#define IDS_WEBAUTHN_TRANSPORT_POPUP_INTERNAL 10080
#define IDS_WEBAUTHN_TRANSPORT_POPUP_CABLE 10081
#define IDS_WEBAUTHN_TRANSPORT_POPUP_AOA 10082
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE 10083
#define IDS_WEBAUTHN_CABLE_ACTIVATE_TITLE_ALT 10084
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION 10085
#define IDS_WEBAUTHN_CABLEV2_SERVERLINK_DESCRIPTION 10086
#define IDS_WEBAUTHN_CABLEV2_SERVERLINK_TROUBLE 10087
#define IDS_WEBAUTHN_CABLEV2_SERVERLINK_TROUBLE_ALT 10088
#define IDS_WEBAUTHN_CABLEV2_AOA_TITLE 10089
#define IDS_WEBAUTHN_CABLEV2_AOA_DESCRIPTION 10090
#define IDS_WEBAUTHN_CABLEV2_AOA_REQUEST_DESCRIPTION 10091
#define IDS_WEBAUTHN_CABLEV2_2ND_FACTOR_DESCRIPTION 10092
#define IDS_WEBAUTHN_CABLEV2_ADD_PHONE 10093
#define IDS_WEBAUTHN_CABLE_ACTIVATE_DESCRIPTION_SHORT 10094
#define IDS_WEBAUTHN_CABLE_V2_ACTIVATE_TITLE 10095
#define IDS_WEBAUTHN_CABLE_V2_ACTIVATE_DESCRIPTION_SHORT 10096
#define IDS_WEBAUTHN_PIN_ENTRY_TITLE 10097
#define IDS_WEBAUTHN_PIN_ENTRY_DESCRIPTION 10098
#define IDS_WEBAUTHN_PIN_ENTRY_PIN_LABEL 10099
#define IDS_WEBAUTHN_PIN_ENTRY_NEXT 10100
#define IDS_WEBAUTHN_PIN_SETUP_DESCRIPTION 10101
#define IDS_WEBAUTHN_PIN_SETUP_CONFIRMATION_LABEL 10102
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_INVALID_CHARACTERS 10103
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_TOO_SHORT 10104
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED_RETRIES 10105
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_FAILED 10106
#define IDS_WEBAUTHN_PIN_SETUP_ERROR_FAILED 10107
#define IDS_WEBAUTHN_PIN_TAP_AGAIN_DESCRIPTION 10108
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_MISMATCH 10109
#define IDS_WEBAUTHN_CLIENT_PIN_SOFT_BLOCK_DESCRIPTION 10110
#define IDS_WEBAUTHN_CLIENT_PIN_HARD_BLOCK_DESCRIPTION 10111
#define IDS_WEBAUTHN_CLIENT_PIN_AUTHENTICATOR_REMOVED_DESCRIPTION 10112
#define IDS_WEBAUTHN_PIN_ENTRY_ERROR_SAME_AS_CURRENT 10113
#define IDS_WEBAUTHN_INLINE_ENROLLMENT_CANCEL_LABEL 10114
#define IDS_WEBAUTHN_UV_RETRY_TITLE 10115
#define IDS_WEBAUTHN_UV_RETRY_DESCRIPTION 10116
#define IDS_WEBAUTHN_UV_RETRY_ERROR_FAILED_RETRIES 10117
#define IDS_WEBAUTHN_UV_ERROR_LOCKED 10118
#define IDS_WEBAUTHN_FORCE_PIN_CHANGE 10119
#define IDS_WEBAUTHN_SELECT_ACCOUNT 10120
#define IDS_WEBAUTHN_UNKNOWN_ACCOUNT 10121
#define IDS_WEBAUTHN_RESIDENT_KEY_PRIVACY 10122
#define IDS_WEBAUTHN_RESIDENT_KEY_PREFERRED_PRIVACY 10123
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_TITLE 10124
#define IDS_WEBAUTHN_ERROR_MISSING_CAPABILITY_DESC 10125
#define IDS_WEBAUTHN_STORAGE_FULL_DESC 10126
#define IDS_WEBAUTHN_REQUEST_ATTESTATION_PERMISSION_TITLE 10127
#define IDS_WEBAUTHN_REQUEST_ATTESTATION_PERMISSION_DESC 10128
#define IDS_WEBAUTHN_REQUEST_ENTERPRISE_ATTESTATION_PERMISSION_TITLE 10129
#define IDS_WEBAUTHN_REQUEST_ENTERPRISE_ATTESTATION_PERMISSION_DESC 10130
#define IDS_WEBAUTHN_ALLOW_ATTESTATION 10131
#define IDS_WEBAUTHN_DENY_ATTESTATION 10132
#define IDS_WEBAUTHN_RETRY 10133
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_TITLE 10134
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DESCRIPTION 10135
#define IDS_WEBAUTHN_PLATFORM_AUTHENTICATOR_OFF_THE_RECORD_INTERSTITIAL_DENY 10136
#define IDS_WEBAUTHN_MANAGE_DEVICES 10137
#define IDS_ACCNAME_SIDE_SEARCH_TOOL 10138
#define IDS_ACCNAME_SIDE_SEARCH_TOOLBAR_BUTTON_ACTIVATED 10139
#define IDS_ACCNAME_SIDE_SEARCH_TOOLBAR_BUTTON_NOT_ACTIVATED 10140
#define IDS_ACCNAME_SIDE_SEARCH_CLOSE_BUTTON 10141
#define IDS_ACCNAME_SIDE_SEARCH_FEEDBACK_BUTTON 10142
#define IDS_SIDE_SEARCH_PROMO 10143
#define IDS_SIDE_SEARCH_ENTRYPOINT_LABEL 10144
#define IDS_TOOLTIP_SIDE_SEARCH_TOOLBAR_BUTTON_ACTIVATED 10145
#define IDS_TOOLTIP_SIDE_SEARCH_TOOLBAR_BUTTON_NOT_ACTIVATED 10146
#define IDS_TOOLTIP_SIDE_SEARCH_CLOSE_BUTTON 10147
#define IDS_TOOLTIP_SIDE_SEARCH_FEEDBACK_BUTTON 10148
#define IDS_CABLEV2_MAKE_CREDENTIAL_NOTIFICATION_TITLE 10149
#define IDS_CABLEV2_GET_ASSERTION_NOTIFICATION_TITLE 10150
#define IDS_INCOGNITO_PROFILE_MENU_TITLE 10151
#define IDS_INCOGNITO_WINDOW_COUNT_MESSAGE 10152
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON 10153
#define IDS_INCOGNITO_PROFILE_MENU_CLOSE_BUTTON_NEW 10154
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_PRIMARY_TEXT 10155
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_SECONDARY_TEXT 10156
#define IDS_INCOGNITO_CLEAR_BROWSING_DATA_DIALOG_CLOSE_WINDOWS_BUTTON 10157
#define IDS_INCOGNITO_HISTORY_BUBBLE_PRIMARY_TEXT 10158
#define IDS_INCOGNITO_HISTORY_BUBBLE_SECONDARY_TEXT 10159
#define IDS_INCOGNITO_HISTORY_BUBBLE_CLOSE_INCOGNITO_BUTTON_TEXT 10160
#define IDS_INCOGNITO_HISTORY_BUBBLE_CANCEL_BUTTON_TEXT 10161
#define IDS_GUEST_WINDOW_COUNT_MESSAGE 10162
#define IDS_GUEST_PROFILE_MENU_CLOSE_BUTTON 10163
#define IDS_HATS_BUBBLE_OK_LABEL 10164
#define IDS_HATS_BUBBLE_TEXT 10165
#define IDS_NOTIFICATION_DEFAULT_HELPFUL_BUTTON_TEXT 10166
#define IDS_NOTIFICATION_DEFAULT_UNHELPFUL_BUTTON_TEXT 10167
#define IDS_DEEP_SCANNING_DIALOG_TITLE 10168
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_PENDING_MESSAGE 10169
#define IDS_DEEP_SCANNING_DIALOG_PRINT_PENDING_MESSAGE 10170
#define IDS_DEEP_SCANNING_DIALOG_SUCCESS_MESSAGE 10171
#define IDS_DEEP_SCANNING_DIALOG_PRINT_SUCCESS_MESSAGE 10172
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_FAILURE_MESSAGE 10173
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_WARNING_MESSAGE 10174
#define IDS_DEEP_SCANNING_DIALOG_PRINT_WARNING_MESSAGE 10175
#define IDS_DEEP_SCANNING_DIALOG_TIMEOUT_MESSAGE 10176
#define IDS_DEEP_SCANNING_DIALOG_PROCEED_BUTTON 10177
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_WARNING_BUTTON 10178
#define IDS_DEEP_SCANNING_DIALOG_CANCEL_UPLOAD_BUTTON 10179
#define IDS_DEEP_SCANNING_DIALOG_LARGE_FILE_FAILURE_MESSAGE 10180
#define IDS_DEEP_SCANNING_DIALOG_LARGE_PRINT_FAILURE_MESSAGE 10181
#define IDS_DEEP_SCANNING_DIALOG_ENCRYPTED_FILE_FAILURE_MESSAGE 10182
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE 10183
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_CUSTOM_MESSAGE 10184
#define IDS_DEEP_SCANNING_DIALOG_CUSTOM_MESSAGE_LEARN_MORE_LINK 10185
#define IDS_DEEP_SCANNING_DIALOG_DOWNLOADS_DISCARD_FILE_BUTTON 10186
#define IDS_DEEP_SCANNING_DIALOG_UPLOAD_BYPASS_JUSTIFICATION_LABEL 10187
#define IDS_DEEP_SCANNING_DIALOG_BYPASS_JUSTIFICATION_TEXT_LIMIT_LABEL 10188
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_TITLE 10189
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_MESSAGE 10190
#define IDS_DEEP_SCANNING_DIALOG_OPEN_NOW_ACCEPT_BUTTON 10191
#define IDS_DEEP_SCANNING_INFO_DIALOG_TITLE 10192
#define IDS_APP_DEEP_SCANNING_INFO_DIALOG_MESSAGE 10193
#define IDS_DEEP_SCANNING_INFO_DIALOG_MESSAGE 10194
#define IDS_DEEP_SCANNING_INFO_DIALOG_ACCEPT_BUTTON 10195
#define IDS_DEEP_SCANNING_INFO_DIALOG_CANCEL_BUTTON 10196
#define IDS_DEEP_SCANNING_INFO_DIALOG_OPEN_NOW_BUTTON 10197
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_TITLE 10198
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_MESSAGE 10199
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_ACCEPT_BUTTON 10200
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_CANCEL_BUTTON 10201
#define IDS_DEEP_SCANNING_TIMED_OUT_DIALOG_OPEN_NOW_BUTTON 10202
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_TITLE 10203
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_TITLE 10204
#define IDS_TAILORED_SECURITY_ENABLED_DIALOG_MAIN_TEXT 10205
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_MAIN_TEXT 10206
#define IDS_TAILORED_SECURITY_DISABLED_DIALOG_ACCEPT_BUTTON 10207
#define IDS_TAILORED_SECURITY_DIALOG_SETTINGS_BUTTON 10208
#define IDS_TAILORED_SECURITY_UNCONSENTED_MODAL_TITLE 10209
#define IDS_TAILORED_SECURITY_UNCONSENTED_ACCEPT_BUTTON 10210
#define IDS_TAILORED_SECURITY_UNCONSENTED_CANCEL_BUTTON 10211
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_TITLE 10212
#define IDS_TAILORED_SECURITY_CONSENTED_ENABLE_MESSAGE_DESCRIPTION 10213
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_TITLE 10214
#define IDS_TAILORED_SECURITY_CONSENTED_DISABLE_MESSAGE_DESCRIPTION 10215
#define IDS_TAILORED_SECURITY_CONSENTED_MESSAGE_OK_BUTTON 10216
#define IDS_FILE_SYSTEM_CONNECTOR_BOX 10217
#define IDS_FILE_SYSTEM_CONNECTOR_GOOGLE_DRIVE 10218
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_CONFIRM_TITLE 10219
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_CONFIRM_MESSAGE 10220
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_CONFIRM_CANCEL_BUTTON 10221
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_CONFIRM_ACCEPT_BUTTON 10222
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_REQUIRED_TITLE 10223
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_REQUIRED_MESSAGE 10224
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_REQUIRED_CANCEL_BUTTON 10225
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_REQUIRED_ACCEPT_BUTTON 10226
#define IDS_FILE_SYSTEM_CONNECTOR_SIGNIN_DIALOG_TITLE 10227
#define IDS_PROMPT_APP_UNINSTALL_TITLE 10228
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_NON_GOOGLE 10229
#define IDS_APP_UNINSTALL_PROMPT_REMOVE_DATA_CHECKBOX_FOR_GOOGLE 10230
#define IDS_APP_UNINSTALL_PROMPT_LEARN_MORE 10231
#define IDS_UTILITY_PROCESS_SPEECH_RECOGNITION_SERVICE_NAME 10232
#define IDS_APP_PAUSE_PROMPT_TITLE 10233
#define IDS_APP_PAUSE_HEADING 10234
#define IDS_APP_PAUSE_HEADING_FOR_WEB_APPS 10235
#define IDS_APP_BLOCK_PROMPT_TITLE 10236
#define IDS_APP_BLOCK_HEADING_FOR_CHILD 10237
#define IDS_APP_BLOCK_HEADING 10238
#define IDS_ENTERPRISE_EXTENSION_REQUEST_APPROVED_TITLE 10239
#define IDS_ENTERPRISE_EXTENSION_REQUEST_REJECTED_TITLE 10240
#define IDS_ENTERPRISE_EXTENSION_REQUEST_FORCE_INSTALLED_TITLE 10241
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_INSTALL 10242
#define IDS_ENTERPRISE_EXTENSION_REQUEST_CLICK_TO_VIEW 10243
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION 10244
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_PLACEHOLDER 10245
#define IDS_ENTERPRISE_EXTENSION_REQUEST_JUSTIFICATION_LENGTH_LIMIT 10246
#define IDS_NAME_WINDOW_PROMPT_TITLE 10247
#define IDS_NAME_WINDOW_PROMPT_FIELD_LABEL 10248
#define IDS_QUICK_COMMANDS_LABEL 10249
#define IDS_QUICK_COMMANDS_PLACEHOLDER 10250
#define IDS_QUICK_COMMANDS_NO_RESULTS 10251
#define IDS_CHROMELABS_RELAUNCH_BUTTON_LABEL 10252
#define IDS_WINDOW_TITLE_EXPERIMENTS 10253
#define IDS_CHROMELABS_SEND_FEEDBACK 10254
#define IDS_CHROMELABS_SEND_FEEDBACK_DESCRIPTION_PLACEHOLDER 10255
#define IDS_CHROMELABS_DEFAULT 10256
#define IDS_CHROMELABS_ENABLED 10257
#define IDS_CHROMELABS_DISABLED 10258
#define IDS_CHROMELABS_ENABLED_WITH_VARIATION_NAME 10259
#define IDS_TAB_SEARCH_MEDIA_TABS_EXPERIMENT_NAME 10260
#define IDS_TAB_SEARCH_MEDIA_TABS_EXPERIMENT_DESCRIPTION 10261
#define IDS_MEDIA_TABS_ALSO_SHOWN_IN_OPEN_TABS_SECTION 10262
#define IDS_SIDE_PANEL_EXPERIMENT_NAME 10263
#define IDS_SIDE_PANEL_EXPERIMENT_DESCRIPTION 10264
#define IDS_TAB_SCROLLING_EXPERIMENT_NAME 10265
#define IDS_TAB_SCROLLING_EXPERIMENT_DESCRIPTION 10266
#define IDS_TABS_SHRINK_TO_PINNED_TAB_WIDTH 10267
#define IDS_TABS_SHRINK_TO_MEDIUM_WIDTH 10268
#define IDS_TABS_SHRINK_TO_LARGE_WIDTH 10269
#define IDS_TABS_DO_NOT_SHRINK 10270
#define IDS_TAB_SEARCH_EXPERIMENT_NAME 10271
#define IDS_TAB_SEARCH_EXPERIMENT_DESCRIPTION 10272
#define IDS_LENS_REGION_SEARCH_EXPERIMENT_NAME 10273
#define IDS_LENS_REGION_SEARCH_EXPERIMENT_DESCRIPTION 10274
#define IDS_LENS_REGION_SEARCH_BUBBLE_TEXT 10275
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_NAME 10276
#define IDS_THUMBNAIL_TAB_STRIP_EXPERIMENT_DESCRIPTION 10277
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_DESCRIPTION 10280
#define IDS_TAILORED_SECURITY_UNCONSENTED_PROMOTION_NOTIFICATION_ACCEPT 10281
#define IDS_ACCOUNT_SELECTION_SHEET_TITLE_EXPLICIT 10282
#define IDS_ACCOUNT_SELECTION_CONTINUE 10283
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP_OR_TOS 10284
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_PP 10285
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT_NO_TOS 10286
#define IDS_ACCOUNT_SELECTION_DATA_SHARING_CONSENT 10287
#define IDS_VERIFY_SHEET_TITLE 10288
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_TITLE 10320
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_TITLE 10321
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_HEADER_1 10322
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION 10323
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_SETTINGS_LINK 10324
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION_ESTIMATES_INTERESTS_LINK 10325
#define IDS_PRIVACY_SANDBOX_BUBBLE_NOTICE_DESCRIPTION_ESTIMATES_INTERESTS_LINK_A11Y_NAME 10326
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_DESCRIPTION_1 10327
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_BODY_HEADER_2 10328
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_HEADER 10329
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_LEARN_MORE_SECTION_2_BULLET_POINT_3 10330
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_ACCEPT_BUTTON 10331
#define IDS_PRIVACY_SANDBOX_DIALOG_CONSENT_DECLINE_BUTTON 10332
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_HEADER_1 10333
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_DESCRIPTION_1 10334
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_BODY_HEADER_2 10335
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_ACKNOWLEDGE_BUTTON 10336
#define IDS_PRIVACY_SANDBOX_DIALOG_NOTICE_OPEN_SETTINGS_BUTTON 10337
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_ONBOARDING_TITLE 10338
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_ONBOARDING_DESCRIPTION 10339
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_ONBOARDING_CONSENT_TEXT 10340
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_ONBOARDING_LEARN_MORE 10341
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_ONBOARDING_BUTTON_CANCEL_TEXT 10342
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_ONBOARDING_BUTTON_ACCEPT_TEXT 10343
#define IDS_AUTOFILL_ASSISTANT_PASSWORD_CHANGE_STARTING_SCREEN_TITLE 10344

// ---------------------------------------------------------------------------
// From locale_settings.h:

#define IDS_SPELLCHECK_DICTIONARY 237
#define IDS_EDITBOOKMARK_DIALOG_WIDTH_CHARS 12000
#define IDS_EDITBOOKMARK_DIALOG_HEIGHT_LINES 12001
#define IDS_THEMES_GALLERY_URL 12002
#define IDS_WEBSTORE_URL 255
#define IDS_MEDIA_GALLERIES_DIALOG_CONTENT_WIDTH_CHARS 12003
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_DIALOG 12005
#define IDS_SETTINGS_CLEAR_DATA_MYACTIVITY_URL_IN_HISTORY 12006

// ---------------------------------------------------------------------------
// From omnibox_resources.h:

#define IDR_OMNIBOX_PEDAL_CONCEPTS 28670

// ---------------------------------------------------------------------------
// From platform_locale_settings.h:

#define IDS_STANDARD_FONT_FAMILY 211
#define IDS_FIXED_FONT_FAMILY 212
#define IDS_SERIF_FONT_FAMILY 213
#define IDS_NTP_FONT_FAMILY 12100
#define IDS_SANS_SERIF_FONT_FAMILY 214
#define IDS_CURSIVE_FONT_FAMILY 215
#define IDS_FANTASY_FONT_FAMILY 216
#define IDS_MATH_FONT_FAMILY 368
#define IDS_STANDARD_FONT_FAMILY_JAPANESE 218
#define IDS_FIXED_FONT_FAMILY_JAPANESE 219
#define IDS_SERIF_FONT_FAMILY_JAPANESE 220
#define IDS_SANS_SERIF_FONT_FAMILY_JAPANESE 221
#define IDS_STANDARD_FONT_FAMILY_KOREAN 222
#define IDS_SERIF_FONT_FAMILY_KOREAN 223
#define IDS_SANS_SERIF_FONT_FAMILY_KOREAN 224
#define IDS_STANDARD_FONT_FAMILY_SIMPLIFIED_HAN 225
#define IDS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 226
#define IDS_SANS_SERIF_FONT_FAMILY_SIMPLIFIED_HAN 227
#define IDS_CURSIVE_FONT_FAMILY_SIMPLIFIED_HAN 231
#define IDS_STANDARD_FONT_FAMILY_TRADITIONAL_HAN 228
#define IDS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 229
#define IDS_SANS_SERIF_FONT_FAMILY_TRADITIONAL_HAN 230
#define IDS_CURSIVE_FONT_FAMILY_TRADITIONAL_HAN 232
#define IDS_MINIMUM_FONT_SIZE 235
#define IDS_MINIMUM_LOGICAL_FONT_SIZE 236

// ---------------------------------------------------------------------------
// From services_strings.h:

#define IDS_PROXY_RESOLVER_DISPLAY_NAME 32350
#define IDS_WINDOWS_SYSTEM_PROXY_RESOLVER_DISPLAY_NAME 32351

// ---------------------------------------------------------------------------
// From ui_strings.h:

#define IDS_TIME_SECS 36910
#define IDS_TIME_LONG_SECS 36911
#define IDS_TIME_LONG_SECS_2ND 36912
#define IDS_TIME_MINS 36913
#define IDS_TIME_LONG_MINS 36914
#define IDS_TIME_LONG_MINS_1ST 36915
#define IDS_TIME_LONG_MINS_2ND 36916
#define IDS_TIME_HOURS 36917
#define IDS_TIME_HOURS_1ST 36918
#define IDS_TIME_HOURS_2ND 36919
#define IDS_TIME_DAYS 36920
#define IDS_TIME_DAYS_1ST 36921
#define IDS_TIME_MONTHS 36922
#define IDS_TIME_YEARS 36923
#define IDS_TIME_REMAINING_SECS 36924
#define IDS_TIME_REMAINING_LONG_SECS 36925
#define IDS_TIME_REMAINING_MINS 36926
#define IDS_TIME_REMAINING_LONG_MINS 36927
#define IDS_TIME_REMAINING_HOURS 36928
#define IDS_TIME_REMAINING_DAYS 36929
#define IDS_TIME_REMAINING_MONTHS 36930
#define IDS_TIME_REMAINING_YEARS 36931
#define IDS_TIME_ELAPSED_SECS 36932
#define IDS_TIME_ELAPSED_LONG_SECS 36933
#define IDS_TIME_ELAPSED_MINS 36934
#define IDS_TIME_ELAPSED_LONG_MINS 36935
#define IDS_TIME_ELAPSED_HOURS 36936
#define IDS_TIME_ELAPSED_DAYS 36937
#define IDS_TIME_ELAPSED_MONTHS 36938
#define IDS_TIME_ELAPSED_YEARS 36939
#define IDS_PAST_TIME_TODAY 36940
#define IDS_PAST_TIME_YESTERDAY 36941
#define IDS_APP_MENU_EMPTY_SUBMENU 36942
#define IDS_CLIPBOARD_MENU_HTML 36943
#define IDS_CLIPBOARD_MENU_IMAGE 36944
#define IDS_CLIPBOARD_MENU_RTF_CONTENT 36945
#define IDS_CLIPBOARD_MENU_WEB_SMART_PASTE 36946
#define IDS_CLIPBOARD_MENU_CLIPBOARD 36947
#define IDS_CLIPBOARD_MENU_DELETE_ALL 36948
#define IDS_EXTENSION_PINNED 36949
#define IDS_EXTENSION_UNPINNED 36950
#define IDS_NEW_BADGE 36951
#define IDS_NEW_BADGE_SCREEN_READER_MESSAGE 36952
#define IDS_SENTENCE_END 36953
#define IDS_CONCAT_TWO_STRINGS_WITH_COMMA 36954
#define IDS_CONCAT_TWO_STRINGS_WITH_PERIODS 36955
#define IDS_APP_SAVEAS_ALL_FILES 36957
#define IDS_APP_SAVEAS_EXTENSION_FORMAT 36958
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_TITLE 36959
#define IDS_SAVE_PAGE_FILE_FORMAT_PROMPT_MAC 36960
#define IDS_SELECT_FOLDER_BUTTON_TITLE 36961
#define IDS_SELECT_UPLOAD_FOLDER_BUTTON_TITLE 36962
#define IDS_SPEECH_MAC 148
#define IDS_SPEECH_START_SPEAKING_MAC 149
#define IDS_SPEECH_STOP_SPEAKING_MAC 150
#define IDS_CONTENT_CONTEXT_LOOK_UP 36963
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_MENU 36964
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_DEFAULT 36965
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_LTR 36966
#define IDS_CONTENT_CONTEXT_WRITING_DIRECTION_RTL 36967
#define IDS_SELECT_FOLDER_DIALOG_TITLE 36968
#define IDS_SAVE_AS_DIALOG_TITLE 36969
#define IDS_OPEN_FILE_DIALOG_TITLE 36970
#define IDS_OPEN_FILES_DIALOG_TITLE 36971
#define IDS_SAVEAS_ALL_FILES 36972
#define IDS_SELECT_UPLOAD_FOLDER_DIALOG_UPLOAD_BUTTON 36973
#define IDS_APP_ACCNAME_BACK 36974
#define IDS_APP_ACCNAME_CENTER 36975
#define IDS_APP_ACCNAME_CLOSE 36976
#define IDS_APP_ACCNAME_MINIMIZE 36977
#define IDS_APP_ACCNAME_MAXIMIZE 36978
#define IDS_APP_ACCNAME_RESTORE 36979
#define IDS_APP_ACCNAME_MENU 36980
#define IDS_APP_ACCNAME_FLOAT 36981
#define IDS_APP_ACCNAME_COLOR_CHOOSER_HEX_INPUT 36982
#define IDS_APP_ACCNAME_HALF 36983
#define IDS_APP_ACCNAME_PARTIAL 36984
#define IDS_APP_ACCNAME_FULL 36985
#define IDS_APP_ACCNAME_FLOAT_ON_TOP 36986
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHERE 36987
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFTEDGE 36988
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHTEDGE 36989
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLHOME 36990
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLEND 36991
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEUP 36992
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLPAGEDOWN 36993
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLLEFT 36994
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLRIGHT 36995
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLUP 36996
#define IDS_APP_SCROLLBAR_CXMENU_SCROLLDOWN 36997
#define IDS_APP_TABLE_COLUMN_NOT_SORTED_ACCNAME 36998
#define IDS_APP_TABLE_COLUMN_SORTED_ASC_ACCNAME 36999
#define IDS_APP_TABLE_COLUMN_SORTED_DESC_ACCNAME 37000
#define IDS_APP_UNDO 37001
#define IDS_APP_CUT 37002
#define IDS_APP_COPY 37003
#define IDS_APP_PASTE 37004
#define IDS_APP_DELETE 37005
#define IDS_APP_SELECT_ALL 37006
#define IDS_CONTENT_CONTEXT_EMOJI 37007
#define IDS_APP_OK 37009
#define IDS_APP_CANCEL 37010
#define IDS_APP_CLOSE 37011
#define IDS_APP_ESC_KEY 37012
#define IDS_APP_TAB_KEY 37013
#define IDS_APP_INSERT_KEY 37014
#define IDS_APP_HOME_KEY 37015
#define IDS_APP_DELETE_KEY 37016
#define IDS_APP_END_KEY 37017
#define IDS_APP_PAGEUP_KEY 37018
#define IDS_APP_PAGEDOWN_KEY 37019
#define IDS_APP_LEFT_ARROW_KEY 37020
#define IDS_APP_RIGHT_ARROW_KEY 37021
#define IDS_APP_UP_ARROW_KEY 37022
#define IDS_APP_DOWN_ARROW_KEY 37023
#define IDS_APP_ENTER_KEY 37024
#define IDS_APP_SPACE_KEY 37025
#define IDS_APP_F1_KEY 37026
#define IDS_APP_F5_KEY 37027
#define IDS_APP_F6_KEY 37028
#define IDS_APP_F11_KEY 37029
#define IDS_APP_BACKSPACE_KEY 37030
#define IDS_APP_COMMA_KEY 37031
#define IDS_APP_PERIOD_KEY 37032
#define IDS_APP_MEDIA_NEXT_TRACK_KEY 37033
#define IDS_APP_MEDIA_PLAY_PAUSE_KEY 37034
#define IDS_APP_MEDIA_PREV_TRACK_KEY 37035
#define IDS_APP_MEDIA_STOP_KEY 37036
#define IDS_APP_ALT_KEY 37037
#define IDS_APP_COMMAND_KEY 37038
#define IDS_APP_CTRL_KEY 37039
#define IDS_APP_SEARCH_KEY 37040
#define IDS_APP_SHIFT_KEY 37041
#define IDS_APP_ACCELERATOR_WITH_MODIFIER 37046
#define IDS_APP_BYTES 37047
#define IDS_APP_KIBIBYTES 37048
#define IDS_APP_MEBIBYTES 37049
#define IDS_APP_GIBIBYTES 37050
#define IDS_APP_TEBIBYTES 37051
#define IDS_APP_PEBIBYTES 37052
#define IDS_APP_BYTES_PER_SECOND 37053
#define IDS_APP_KIBIBYTES_PER_SECOND 37054
#define IDS_APP_MEBIBYTES_PER_SECOND 37055
#define IDS_APP_GIBIBYTES_PER_SECOND 37056
#define IDS_APP_TEBIBYTES_PER_SECOND 37057
#define IDS_APP_PEBIBYTES_PER_SECOND 37058
#define IDS_MESSAGE_CENTER_ACCESSIBLE_NAME 37059
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME 37060
#define IDS_MESSAGE_CENTER_NOTIFICATION_ACCESSIBLE_NAME_PLURAL 37061
#define IDS_MESSAGE_CENTER_EXPAND_NOTIFICATION 37062
#define IDS_MESSAGE_CENTER_COLLAPSE_NOTIFICATION 37063
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_MESSAGE_WITH_DIVIDER 37064
#define IDS_MESSAGE_CENTER_LIST_NOTIFICATION_HEADER_OVERFLOW_INDICATOR 37065
#define IDS_MESSAGE_CENTER_NOTIFICATION_PROGRESS_PERCENTAGE 37066
#define IDS_MESSAGE_CENTER_NOTIFICATION_CHROMEOS_SYSTEM 37067
#define IDS_MESSAGE_CENTER_NOTIFICATION_INLINE_REPLY_PLACEHOLDER 37068
#define IDS_MESSAGE_NOTIFICATION_NOW_STRING_SHORTEST 37069
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST 37070
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST 37071
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST 37072
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST 37073
#define IDS_MESSAGE_NOTIFICATION_DURATION_MINUTES_SHORTEST_FUTURE 37074
#define IDS_MESSAGE_NOTIFICATION_DURATION_HOURS_SHORTEST_FUTURE 37075
#define IDS_MESSAGE_NOTIFICATION_DURATION_DAYS_SHORTEST_FUTURE 37076
#define IDS_MESSAGE_NOTIFICATION_DURATION_YEARS_SHORTEST_FUTURE 37077
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_SITE 37078
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS_APP 37079
#define IDS_MESSAGE_CENTER_BLOCK_ALL_NOTIFICATIONS 37080
#define IDS_MESSAGE_CENTER_DONT_BLOCK_NOTIFICATIONS 37081
#define IDS_MESSAGE_CENTER_SETTINGS_DONE 37082
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_ACCESSIBLE_NAME 37083
#define IDS_MESSAGE_CENTER_CLOSE_NOTIFICATION_BUTTON_TOOLTIP 37084
#define IDS_MESSAGE_CENTER_NOTIFICATION_SNOOZE_BUTTON_TOOLTIP 37085
#define IDS_MESSAGE_NOTIFICATION_SETTINGS_BUTTON_ACCESSIBLE_NAME 37086
#define IDS_MESSAGE_NOTIFICATION_ACCESSIBLE_NAME 37087
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_DEVICE_INFO 37088
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_SUCCESS 37089
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_TITLE 37090
#define IDS_MESSAGE_NOTIFICATION_SEND_TAB_TO_SELF_CONFIRMATION_FAILURE_MESSAGE 37091
#define IDS_CLIPBOARD_HISTORY_MENU_PNG_IMAGE 37093
#define IDS_CLIPBOARD_HISTORY_MENU_HTML_IMAGE 37094
#define IDS_CLIPBOARD_HISTORY_MENU_TITLE 37095
#define IDS_CLIPBOARD_HISTORY_DELETE_BUTTON 37096
#define IDS_CLIPBOARD_HISTORY_ITEM_DELETION 37097
#define IDS_DISPLAY_TOUCH_CALIBRATION_EXIT_LABEL 37098
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_LABEL_TEXT 37099
#define IDS_DISPLAY_TOUCH_CALIBRATION_HINT_SUBLABEL_TEXT 37100
#define IDS_DISPLAY_TOUCH_CALIBRATION_TAP_HERE_LABEL 37101
#define IDS_DISPLAY_TOUCH_CALIBRATION_FINISH_LABEL 37102
#define IDS_DISPLAY_NAME_UNKNOWN 37103
#define IDS_DISPLAY_NAME_INTERNAL 37104
#define IDS_CROSTINI_USE_LOW_DENSITY 37105
#define IDS_CROSTINI_USE_HIGH_DENSITY 37106
#define IDS_CROSTINI_APP_RESTART_BODY 37107
#define IDS_SATURATED_BADGE_CONTENT 37108
#define IDS_BADGE_UNREAD_NOTIFICATIONS_SATURATED 37109
#define IDS_BADGE_UNREAD_NOTIFICATIONS_UNSPECIFIED 37110
#define IDS_BADGE_UNREAD_NOTIFICATIONS 37111
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_LABEL 37112
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_TITLE_NO_DEVICES 37113
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_CALL_BUTTON_LABEL 37114
#define IDS_BROWSER_SHARING_OMNIBOX_SENDING_LABEL 37115
#define IDS_BROWSER_SHARING_DIALOG_DEVICE_SUBTITLE_LAST_ACTIVE_DAYS 37116
#define IDS_BROWSER_SHARING_CLICK_TO_CALL_DIALOG_INITIATING_ORIGIN 37117
#define IDS_BROWSER_SHARING_CONTENT_TYPE_TEXT 37118
#define IDS_BROWSER_SHARING_CONTENT_TYPE_NUMBER 37119
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_GENERIC_ERROR 37120
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TITLE_INTERNAL_ERROR 37121
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_NETWORK_ERROR 37122
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_DEVICE_ACK_TIMEOUT 37123
#define IDS_BROWSER_SHARING_ERROR_DIALOG_TEXT_INTERNAL_ERROR 37124
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TITLE_PAYLOAD_TOO_LARGE 37125
#define IDS_BROWSER_SHARING_SHARED_CLIPBOARD_ERROR_DIALOG_TEXT_PAYLOAD_TOO_LARGE 37126
#define IDS_SETTINGS_PASSWORD_SHOW 37130
#define IDS_SETTINGS_PASSWORD_HIDE 37131
#define IDS_TABLE_VIEW_AX_ANNOUNCE_ROW_SELECTED 37132

#endif  // CEF_INCLUDE_CEF_PACK_STRINGS_H_
