// Copyright (c) 2022 Marshall A. Greenblatt. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//    * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//    * Neither the name of Google Inc. nor the name Chromium Embedded
// Framework nor the names of its contributors may be used to endorse
// or promote products derived from this software without specific prior
// written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// ---------------------------------------------------------------------------
//
// This file is generated by the make_pack_header.py tool.
//

#ifndef CEF_INCLUDE_CEF_PACK_RESOURCES_H_
#define CEF_INCLUDE_CEF_PACK_RESOURCES_H_
#pragma once

// ---------------------------------------------------------------------------
// From blink_resources.h:

#define IDR_UASTYLE_HTML_CSS 32390
#define IDR_UASTYLE_OVERFLOW_REPLACED_CSS 32391
#define IDR_UASTYLE_QUIRKS_CSS 32392
#define IDR_UASTYLE_VIEW_SOURCE_CSS 32393
#define IDR_UASTYLE_THEME_CHROMIUM_ANDROID_CSS 32394
#define IDR_UASTYLE_FULLSCREEN_ANDROID_CSS 32395
#define IDR_UASTYLE_THEME_CHROMIUM_LINUX_CSS 32396
#define IDR_UASTYLE_THEME_MAC_CSS 32397
#define IDR_UASTYLE_THEME_INPUT_MULTIPLE_FIELDS_CSS 32398
#define IDR_UASTYLE_THEME_FORCED_COLORS_CSS 32399
#define IDR_UASTYLE_POPUP_CSS 32400
#define IDR_UASTYLE_SELECTMENU_CSS 32401
#define IDR_UASTYLE_SVG_CSS 32402
#define IDR_UASTYLE_MARKER_CSS 32403
#define IDR_UASTYLE_MATHML_CSS 32404
#define IDR_UASTYLE_MATHML_FALLBACK_CSS 32405
#define IDR_UASTYLE_FULLSCREEN_CSS 32406
#define IDR_UASTYLE_WEBXR_OVERLAY_CSS 32407
#define IDR_UASTYLE_XHTMLMP_CSS 32408
#define IDR_UASTYLE_VIEWPORT_ANDROID_CSS 32409
#define IDR_UASTYLE_VIEWPORT_TELEVISION_CSS 32410
#define IDR_UASTYLE_TRANSITION_CSS 32411
#define IDR_UASTYLE_TRANSITION_ANIMATIONS_CSS 32412
#define IDR_DOCUMENTXMLTREEVIEWER_CSS 32413
#define IDR_DOCUMENTXMLTREEVIEWER_JS 32414
#define IDR_VALIDATION_BUBBLE_ICON 32415
#define IDR_VALIDATION_BUBBLE_CSS 32416
#define IDR_PICKER_COMMON_JS 32417
#define IDR_PICKER_COMMON_CSS 32418
#define IDR_CALENDAR_PICKER_CSS 32419
#define IDR_CALENDAR_PICKER_JS 32420
#define IDR_MONTH_PICKER_JS 32421
#define IDR_TIME_PICKER_CSS 32422
#define IDR_TIME_PICKER_JS 32423
#define IDR_DATETIMELOCAL_PICKER_JS 32424
#define IDR_SUGGESTION_PICKER_CSS 32425
#define IDR_SUGGESTION_PICKER_JS 32426
#define IDR_COLOR_PICKER_COMMON_JS 32427
#define IDR_COLOR_SUGGESTION_PICKER_CSS 32428
#define IDR_COLOR_SUGGESTION_PICKER_JS 32429
#define IDR_COLOR_PICKER_CSS 32430
#define IDR_COLOR_PICKER_JS 32431
#define IDR_LIST_PICKER_CSS 32432
#define IDR_LIST_PICKER_JS 32433
#define IDR_AUDIO_SPATIALIZATION_COMPOSITE 32434

// ---------------------------------------------------------------------------
// From browser_resources.h:

#define IDR_INCOGNITO_TAB_HTML 12820
#define IDR_REVAMPED_INCOGNITO_TAB_HTML 12821
#define IDR_INCOGNITO_TAB_THEME_CSS 12822
#define IDR_GUEST_TAB_HTML 12823
#define IDR_NEW_TAB_4_THEME_CSS 12824
#define IDR_ABOUT_NACL_HTML 12553
#define IDR_ABOUT_NACL_CSS 12554
#define IDR_ABOUT_NACL_JS 12555
#define IDR_ABOUT_SYS_HTML 12556
#define IDR_ABOUT_SYS_CSS 12557
#define IDR_ABOUT_SYS_JS 12558
#define IDR_AD_NETWORK_HASHES 12559
#define IDR_CERTIFICATE_VIEWER_HTML 12560
#define IDR_CERTIFICATE_VIEWER_JS 12561
#define IDR_CERTIFICATE_VIEWER_CSS 12562
#define IDR_PAGE_NOT_AVAILABLE_FOR_GUEST_APP_HTML 12579
#define IDR_INLINE_LOGIN_HTML 12580
#define IDR_INLINE_LOGIN_APP_JS 12581
#define IDR_INLINE_LOGIN_BROWSER_PROXY_JS 12582
#define IDR_GAIA_AUTH_WEBVIEW_SAML_INJECTED_JS 12583
#define IDR_IDENTITY_API_SCOPE_APPROVAL_MANIFEST 12588
#define IDR_INSPECT_CSS 12589
#define IDR_INSPECT_HTML 12590
#define IDR_INSPECT_JS 12591
#define IDR_NETWORK_SPEECH_SYNTHESIS_MANIFEST 250
#define IDR_PDF_MANIFEST 252
#define IDR_PLUGIN_DB_JSON 206
#define IDR_USB_ENUMERATION_OPTIONS_MOJOM_WEBUI_JS 12594
#define IDR_USB_DEVICE_MANAGER_CLIENT_MOJOM_WEBUI_JS 12595
#define IDR_WEBSTORE_MANIFEST 247
#define IDR_CRYPTOTOKEN_MANIFEST 251
#define IDR_MEDIA_ROUTER_INTERNALS_HTML 12713
#define IDR_MEDIA_ROUTER_INTERNALS_CSS 12714
#define IDR_MEDIA_ROUTER_INTERNALS_JS 12715
#define IDR_IME_WINDOW_CLOSE 12716
#define IDR_IME_WINDOW_CLOSE_C 12717
#define IDR_IME_WINDOW_CLOSE_H 12718
#define IDR_RESET_PASSWORD_HTML 12756
#define IDR_RESET_PASSWORD_JS 12757
#define IDR_RESET_PASSWORD_MOJOM_WEBUI_JS 12758
#define IDR_TAB_RANKER_EXAMPLE_PREPROCESSOR_CONFIG_PB 12759
#define IDR_TAB_RANKER_PAIRWISE_EXAMPLE_PREPROCESSOR_CONFIG_PB 12760
#define IDR_CART_DOMAIN_NAME_MAPPING_JSON 12774
#define IDR_CART_DOMAIN_CART_URL_MAPPING_JSON 12775
#define IDR_DESKTOP_SHARING_HUB_PB 12776

// ---------------------------------------------------------------------------
// From cef_resources.h:

#define IDR_CEF_DEVTOOLS_DISCOVERY_PAGE 63000
#define IDR_CEF_LICENSE_TXT 63001
#define IDR_CEF_VERSION_HTML 63002
#define IDR_CEF_EXTENSION_API_FEATURES 63003

// ---------------------------------------------------------------------------
// From common_resources.h:

#define IDR_CHROME_EXTENSION_API_FEATURES 19100
#define IDR_CHROME_APP_API_FEATURES 19101

// ---------------------------------------------------------------------------
// From component_extension_resources.h:

#define IDR_NETWORK_SPEECH_SYNTHESIS_JS 14250
#define IDR_IDENTITY_API_SCOPE_APPROVAL_BACKGROUND_JS 14258
#define IDR_IDENTITY_API_SCOPE_APPROVAL_DIALOG_CSS 14259
#define IDR_IDENTITY_API_SCOPE_APPROVAL_DIALOG 14260
#define IDR_IDENTITY_API_SCOPE_APPROVAL_DIALOG_JS 14261
#define IDR_IDENTITY_API_SCOPE_APPROVAL_INJECT_JS 14262
#define IDR_CRYPTOTOKEN_UTIL_JS 14290
#define IDR_CRYPTOTOKEN_B64_JS 14291
#define IDR_CRYPTOTOKEN_COUNTDOWN_JS 14292
#define IDR_CRYPTOTOKEN_COUNTDOWNTIMER_JS 14293
#define IDR_CRYPTOTOKEN_SHA256_JS 14294
#define IDR_CRYPTOTOKEN_TIMER_JS 14295
#define IDR_CRYPTOTOKEN_DEVICESTATUSCODES_JS 14296
#define IDR_CRYPTOTOKEN_ASN1_JS 14297
#define IDR_CRYPTOTOKEN_CBOR_JS 14298
#define IDR_CRYPTOTOKEN_ENROLLER_JS 14299
#define IDR_CRYPTOTOKEN_REQUESTQUEUE_JS 14300
#define IDR_CRYPTOTOKEN_SIGNER_JS 14301
#define IDR_CRYPTOTOKEN_WEBREQUEST_JS 14302
#define IDR_CRYPTOTOKEN_APPID_JS 14303
#define IDR_CRYPTOTOKEN_TEXTFETCHER_JS 14304
#define IDR_CRYPTOTOKEN_REQUESTHELPER_JS 14305
#define IDR_CRYPTOTOKEN_MESSAGETYPES_JS 14306
#define IDR_CRYPTOTOKEN_INHERITS_JS 14307
#define IDR_CRYPTOTOKEN_FACTORYREGISTRY_JS 14308
#define IDR_CRYPTOTOKEN_ERRORCODES_JS 14309
#define IDR_CRYPTOTOKEN_ORIGINCHECK_JS 14310
#define IDR_CRYPTOTOKEN_INDIVIDUALATTEST_JS 14311
#define IDR_CRYPTOTOKEN_GOOGLECORPINDIVIDUALATTEST_JS 14312
#define IDR_CRYPTOTOKEN_APPROVEDORIGINS_JS 14313
#define IDR_CRYPTOTOKEN_WEBREQUESTSENDER_JS 14314
#define IDR_CRYPTOTOKEN_WINDOW_TIMER_JS 14315
#define IDR_CRYPTOTOKEN_WATCHDOG_JS 14316
#define IDR_CRYPTOTOKEN_LOGGING_JS 14317
#define IDR_CRYPTOTOKEN_CRYPTOTOKENAPPROVEDORIGIN_JS 14318
#define IDR_CRYPTOTOKEN_CRYPTOTOKENORIGINCHECK_JS 14319
#define IDR_CRYPTOTOKEN_CRYPTOTOKENBACKGROUND_JS 14320

// ---------------------------------------------------------------------------
// From components_resources.h:

#define IDR_ABOUT_UI_CREDITS_CSS 28690
#define IDR_ABOUT_UI_CREDITS_HTML 28691
#define IDR_ABOUT_UI_CREDITS_JS 28692
#define IDR_CART_DOMAIN_CART_URL_REGEX_JSON 28693
#define IDR_CHECKOUT_URL_REGEX_DOMAIN_MAPPING_JSON 28694
#define IDR_QUERY_SHOPPING_META_JS 28695
#define IDR_DOM_DISTILLER_VIEWER_HTML 28696
#define IDR_DOM_DISTILLER_VIEWER_JS 28697
#define IDR_DISTILLER_JS 28698
#define IDR_DISTILLER_CSS 28699
#define IDR_DISTILLER_DESKTOP_CSS 28700
#define IDR_DISTILLER_LOADING_IMAGE 28701
#define IDR_EXTRACT_PAGE_FEATURES_JS 28702
#define IDR_DISTILLABLE_PAGE_SERIALIZED_MODEL_NEW 28703
#define IDR_LONG_PAGE_SERIALIZED_MODEL 28704
#define IDR_FLAGS_UI_FLAGS_HTML 28705
#define IDR_FLAGS_UI_FLAGS_JS 28706
#define IDR_FLAGS_UI_FLAGS_CSS 28707
#define IDR_MOBILE_MANAGEMENT_CSS 28708
#define IDR_MOBILE_MANAGEMENT_HTML 28709
#define IDR_MOBILE_MANAGEMENT_JS 28710
#define IDR_NET_ERROR_HTML 28711
#define IDR_PRINT_HEADER_FOOTER_TEMPLATE_PAGE 28721
#define IDR_SAFE_BROWSING_HTML 28722
#define IDR_SAFE_BROWSING_CSS 28723
#define IDR_SAFE_BROWSING_JS 28724
#define IDR_DOWNLOAD_FILE_TYPES_PB 205
#define IDR_SECURITY_INTERSTITIAL_COMMON_CSS 28725
#define IDR_SECURITY_INTERSTITIAL_CORE_CSS 28726
#define IDR_SECURITY_INTERSTITIAL_HTML 28727
#define IDR_SECURITY_INTERSTITIAL_QUIET_HTML 28728
#define IDR_SECURITY_INTERSTITIAL_CONNECTION_HELP_HTML 28729
#define IDR_SECURITY_INTERSTITIAL_CONNECTION_HELP_CSS 28730
#define IDR_SECURITY_INTERSTITIAL_CONNECTION_HELP_JS 28731
#define IDR_KNOWN_INTERCEPTION_HTML 28732
#define IDR_KNOWN_INTERCEPTION_CSS 28733
#define IDR_KNOWN_INTERCEPTION_ICON_1X_PNG 28734
#define IDR_KNOWN_INTERCEPTION_ICON_2X_PNG 28735
#define IDR_SSL_ERROR_ASSISTANT_PB 28736
#define IDR_TRANSLATE_JS 28737
#define IDR_VERSION_UI_CSS 28738
#define IDR_VERSION_UI_HTML 28740
#define IDR_VERSION_UI_JS 28741
#define IDR_WEBAPP_DEFAULT_OFFLINE_HTML 28742

// ---------------------------------------------------------------------------
// From content_resources.h:

#define IDR_DEVTOOLS_PINCH_CURSOR_ICON 28900
#define IDR_DEVTOOLS_PINCH_CURSOR_ICON_2X 28901
#define IDR_DEVTOOLS_TOUCH_CURSOR_ICON 28902
#define IDR_DEVTOOLS_TOUCH_CURSOR_ICON_2X 28903
#define IDR_GEOMETRY_MOJOM_WEBUI_JS 28904
#define IDR_IMAGE_MOJOM_WEBUI_JS 28905
#define IDR_HISTOGRAMS_INTERNALS_HTML 28906
#define IDR_HISTOGRAMS_INTERNALS_JS 28907
#define IDR_HISTOGRAMS_INTERNALS_CSS 28908
#define IDR_ORIGIN_MOJO_WEBUI_JS 28911
#define IDR_RANGE_MOJOM_WEBUI_JS 28912
#define IDR_TOKEN_MOJO_WEBUI_JS 28913
#define IDR_UI_WINDOW_OPEN_DISPOSITION_MOJO_WEBUI_JS 28915
#define IDR_UKM_INTERNALS_HTML 28916
#define IDR_UKM_INTERNALS_JS 28917
#define IDR_UKM_INTERNALS_CSS 28918
#define IDR_URL_MOJOM_WEBUI_JS 28923
#define IDR_VULKAN_INFO_MOJO_JS 28924
#define IDR_VULKAN_TYPES_MOJO_JS 28925

// ---------------------------------------------------------------------------
// From dev_ui_browser_resources.h:

#define IDR_ACCESSIBILITY_HTML 12500
#define IDR_ACCESSIBILITY_CSS 12501
#define IDR_ACCESSIBILITY_JS 12502
#define IDR_APC_INTERNALS_HTML 12503
#define IDR_APC_INTERNALS_JS 12504
#define IDR_APC_INTERNALS_CSS 12505
#define IDR_COMPONENTS_COMPONENTS_HTML 12506
#define IDR_COMPONENTS_COMPONENTS_JS 12507
#define IDR_DEVICE_LOG_UI_HTML 12508
#define IDR_DEVICE_LOG_UI_JS 12509
#define IDR_DEVICE_LOG_UI_CSS 12510
#define IDR_MEMORY_INTERNALS_HTML 12511
#define IDR_MEMORY_INTERNALS_JS 12512
#define IDR_PREDICTORS_AUTOCOMPLETE_ACTION_PREDICTOR_JS 12513
#define IDR_PREDICTORS_HTML 12514
#define IDR_PREDICTORS_JS 12515
#define IDR_PREDICTORS_RESOURCE_PREFETCH_PREDICTOR_JS 12516
#define IDR_SITE_ENGAGEMENT_HTML 12519
#define IDR_SITE_ENGAGEMENT_JS 12520
#define IDR_SITE_ENGAGEMENT_DETAILS_MOJOM_WEBUI_JS 12521
#define IDR_TRANSLATE_INTERNALS_CSS 12532
#define IDR_TRANSLATE_INTERNALS_HTML 12533
#define IDR_TRANSLATE_INTERNALS_JS 12534
#define IDR_WEB_APP_INTERNALS_HTML 12535

// ---------------------------------------------------------------------------
// From dev_ui_components_resources.h:

#define IDR_AUTOFILL_AND_PASSWORD_MANAGER_INTERNALS_HTML 18860
#define IDR_AUTOFILL_AND_PASSWORD_MANAGER_INTERNALS_JS 18861
#define IDR_CRASH_CRASHES_HTML 18862
#define IDR_CRASH_CRASHES_JS 18863
#define IDR_CRASH_CRASHES_CSS 18864
#define IDR_CRASH_SADTAB_SVG 18865
#define IDR_GCM_DRIVER_GCM_INTERNALS_HTML 18866
#define IDR_GCM_DRIVER_GCM_INTERNALS_CSS 18867
#define IDR_GCM_DRIVER_GCM_INTERNALS_JS 18868
#define IDR_LOCAL_STATE_HTML 18869
#define IDR_LOCAL_STATE_JS 18870
#define IDR_NET_LOG_NET_EXPORT_CSS 18871
#define IDR_NET_LOG_NET_EXPORT_HTML 18872
#define IDR_NET_LOG_NET_EXPORT_JS 18873
#define IDR_NTP_TILES_INTERNALS_HTML 18874
#define IDR_NTP_TILES_INTERNALS_JS 18875
#define IDR_NTP_TILES_INTERNALS_CSS 18876
#define IDR_POLICY_CSS 18877
#define IDR_POLICY_HTML 18878
#define IDR_POLICY_BASE_JS 18879
#define IDR_POLICY_JS 18880
#define IDR_POLICY_POLICY_CONFLICT_HTML_JS 18881
#define IDR_POLICY_POLICY_CONFLICT_JS 18882
#define IDR_POLICY_POLICY_PRECEDENCE_ROW_HTML_JS 18883
#define IDR_POLICY_POLICY_PRECEDENCE_ROW_JS 18884
#define IDR_POLICY_POLICY_ROW_HTML_JS 18885
#define IDR_POLICY_POLICY_ROW_JS 18886
#define IDR_POLICY_POLICY_TABLE_HTML_JS 18887
#define IDR_POLICY_POLICY_TABLE_JS 18888
#define IDR_POLICY_STATUS_BOX_HTML_JS 18889
#define IDR_POLICY_STATUS_BOX_JS 18890
#define IDR_SECURITY_INTERSTITIAL_UI_HTML 18891
#define IDR_SIGNIN_INTERNALS_INDEX_HTML 18892
#define IDR_SIGNIN_INTERNALS_INDEX_CSS 18893
#define IDR_SIGNIN_INTERNALS_INDEX_JS 18894
#define IDR_USER_ACTIONS_CSS 18895
#define IDR_USER_ACTIONS_HTML 18896
#define IDR_USER_ACTIONS_JS 18897

// ---------------------------------------------------------------------------
// From dev_ui_content_resources.h:

#define IDR_ATTRIBUTION_INTERNALS_HTML 18980
#define IDR_ATTRIBUTION_INTERNALS_JS 18981
#define IDR_ATTRIBUTION_INTERNALS_TABLE_MODEL_JS 18982
#define IDR_ATTRIBUTION_INTERNALS_TABLE_JS 18983
#define IDR_ATTRIBUTION_INTERNALS_TABLE_HTML_JS 18984
#define IDR_ATTRIBUTION_INTERNALS_CSS 18985
#define IDR_ATTRIBUTION_INTERNALS_MOJOM_JS 18986
#define IDR_GPU_BROWSER_BRIDGE_JS 18987
#define IDR_GPU_INTERNALS_HTML 18988
#define IDR_GPU_INTERNALS_JS 18989
#define IDR_GPU_INTERNALS_INFO_VIEW_HTML_JS 18990
#define IDR_GPU_INTERNALS_INFO_VIEW_JS 18991
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_HTML_JS 18992
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_JS 18993
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_ROW_HTML_JS 18994
#define IDR_GPU_INTERNALS_INFO_VIEW_TABLE_ROW_JS 18995
#define IDR_GPU_VULKAN_INFO_JS 18996
#define IDR_INDEXED_DB_INTERNALS_HTML 18997
#define IDR_INDEXED_DB_INTERNALS_JS 18998
#define IDR_INDEXED_DB_INTERNALS_CSS 18999
#define IDR_NETWORK_ERROR_LISTING_HTML 19000
#define IDR_NETWORK_ERROR_LISTING_JS 19001
#define IDR_NETWORK_ERROR_LISTING_CSS 19002
#define IDR_PRERENDER_INTERNALS_HTML 19003
#define IDR_PRERENDER_INTERNALS_MOJO_JS 19004
#define IDR_PRERENDER_INTERNALS_JS 19005
#define IDR_PROCESS_INTERNALS_HTML 19006
#define IDR_PROCESS_INTERNALS_MOJO_JS 19007
#define IDR_PROCESS_INTERNALS_CSS 19008
#define IDR_PROCESS_INTERNALS_JS 19009
#define IDR_SERVICE_WORKER_INTERNALS_HTML 19010
#define IDR_SERVICE_WORKER_INTERNALS_JS 19011
#define IDR_SERVICE_WORKER_INTERNALS_CSS 19012

// ---------------------------------------------------------------------------
// From devtools_resources.h:

#define COMPRESSED_PROTOCOL_JSON 38500
#define IMAGES_IMAGES_JS 38501
#define IMAGES_ACCELEROMETER_BACK_SVG 38502
#define IMAGES_ACCELEROMETER_BOTTOM_PNG 38503
#define IMAGES_ACCELEROMETER_FRONT_SVG 38504
#define IMAGES_ACCELEROMETER_LEFT_PNG 38505
#define IMAGES_ACCELEROMETER_RIGHT_PNG 38506
#define IMAGES_ACCELEROMETER_TOP_PNG 38507
#define IMAGES_ACCESSIBILITY_ICON_SVG 38508
#define IMAGES_ADD_ICON_SVG 38509
#define IMAGES_ALIGN_CONTENT_CENTER_ICON_SVG 38510
#define IMAGES_ALIGN_CONTENT_END_ICON_SVG 38511
#define IMAGES_ALIGN_CONTENT_SPACE_AROUND_ICON_SVG 38512
#define IMAGES_ALIGN_CONTENT_SPACE_BETWEEN_ICON_SVG 38513
#define IMAGES_ALIGN_CONTENT_SPACE_EVENLY_ICON_SVG 38514
#define IMAGES_ALIGN_CONTENT_START_ICON_SVG 38515
#define IMAGES_ALIGN_CONTENT_STRETCH_ICON_SVG 38516
#define IMAGES_ALIGN_ITEMS_CENTER_ICON_SVG 38517
#define IMAGES_ALIGN_ITEMS_FLEX_END_ICON_SVG 38518
#define IMAGES_ALIGN_ITEMS_FLEX_START_ICON_SVG 38519
#define IMAGES_ALIGN_ITEMS_STRETCH_ICON_SVG 38520
#define IMAGES_ALIGN_SELF_CENTER_ICON_SVG 38521
#define IMAGES_ALIGN_SELF_FLEX_END_ICON_SVG 38522
#define IMAGES_ALIGN_SELF_FLEX_START_ICON_SVG 38523
#define IMAGES_ALIGN_SELF_STRETCH_ICON_SVG 38524
#define IMAGES_BASELINE_ICON_SVG 38525
#define IMAGES_CHECKBOXCHECKMARK_SVG 38526
#define IMAGES_CHECKER_PNG 38527
#define IMAGES_CHEVRONS_SVG 38528
#define IMAGES_CHROMEDISABLEDSELECT_PNG 38529
#define IMAGES_CHROMEDISABLEDSELECT_2X_PNG 38530
#define IMAGES_CHROMELEFT_AVIF 38531
#define IMAGES_CHROMEMIDDLE_AVIF 38532
#define IMAGES_CHROMERIGHT_AVIF 38533
#define IMAGES_CHROMESELECT_SVG 38534
#define IMAGES_CHROMESELECTDARK_SVG 38535
#define IMAGES_CIRCLED_BACKSLASH_ICON_SVG 38536
#define IMAGES_CIRCLED_EXCLAMATION_ICON_SVG 38537
#define IMAGES_CLOSE_ICON_SVG 38538
#define IMAGES_COPY_ICON_SVG 38539
#define IMAGES_CSSOVERVIEW_ICONS_2X_AVIF 38540
#define IMAGES_DROPDOWN_7X6_ICON_SVG 38541
#define IMAGES_ELEMENTS_PANEL_ICON_SVG 38542
#define IMAGES_ERRORWAVE_SVG 38543
#define IMAGES_ERROR_ICON_SVG 38544
#define IMAGES_FEEDBACK_BUTTON_ICON_SVG 38545
#define IMAGES_FLEX_DIRECTION_ICON_SVG 38546
#define IMAGES_FLEX_NOWRAP_ICON_SVG 38547
#define IMAGES_FLEX_WRAP_ICON_SVG 38548
#define IMAGES_HELP_OUTLINE_SVG 38549
#define IMAGES_IC_CHANGES_SVG 38550
#define IMAGES_IC_CHECKMARK_16X16_SVG 38551
#define IMAGES_IC_COMMAND_GO_TO_LINE_SVG 38552
#define IMAGES_IC_COMMAND_GO_TO_SYMBOL_SVG 38553
#define IMAGES_IC_COMMAND_HELP_SVG 38554
#define IMAGES_IC_COMMAND_OPEN_FILE_SVG 38555
#define IMAGES_IC_COMMAND_RUN_COMMAND_SVG 38556
#define IMAGES_IC_COMMAND_RUN_SNIPPET_SVG 38557
#define IMAGES_IC_DELETE_FILTER_SVG 38558
#define IMAGES_IC_DELETE_LIST_SVG 38559
#define IMAGES_IC_DIMENSION_SINGLE_SVG 38560
#define IMAGES_IC_FILE_DEFAULT_SVG 38561
#define IMAGES_IC_FILE_DOCUMENT_SVG 38562
#define IMAGES_IC_FILE_FONT_SVG 38563
#define IMAGES_IC_FILE_IMAGE_SVG 38564
#define IMAGES_IC_FILE_SCRIPT_SVG 38565
#define IMAGES_IC_FILE_SNIPPET_SVG 38566
#define IMAGES_IC_FILE_STYLESHEET_SVG 38567
#define IMAGES_IC_FILE_WEBBUNDLE_SVG 38568
#define IMAGES_IC_FILE_WEBBUNDLE_INNER_REQUEST_SVG 38569
#define IMAGES_IC_FOLDER_DEFAULT_SVG 38570
#define IMAGES_IC_FOLDER_LOCAL_SVG 38571
#define IMAGES_IC_FOLDER_NETWORK_SVG 38572
#define IMAGES_IC_INFO_BLACK_18DP_SVG 38573
#define IMAGES_IC_LAYERS_16X16_SVG 38574
#define IMAGES_IC_MEMORY_16X16_SVG 38575
#define IMAGES_IC_PAGE_NEXT_16X16_ICON_SVG 38576
#define IMAGES_IC_PAGE_PREV_16X16_ICON_SVG 38577
#define IMAGES_IC_PREVIEW_FEATURE_SVG 38578
#define IMAGES_IC_REDO_16X16_ICON_SVG 38579
#define IMAGES_IC_RENDERING_SVG 38580
#define IMAGES_IC_REQUEST_RESPONSE_SVG 38581
#define IMAGES_IC_RESPONSE_SVG 38582
#define IMAGES_IC_SHOW_NODE_16X16_SVG 38583
#define IMAGES_IC_SOURCES_AUTHORED_SVG 38584
#define IMAGES_IC_SOURCES_DEPLOYED_SVG 38585
#define IMAGES_IC_SUGGEST_COLOR_SVG 38586
#define IMAGES_IC_UNDO_16X16_ICON_SVG 38587
#define IMAGES_IC_WARNING_BLACK_18DP_SVG 38588
#define IMAGES_INFO_ICON_SVG 38589
#define IMAGES_ISSUE_CROSS_ICON_SVG 38590
#define IMAGES_ISSUE_EXCLAMATION_ICON_SVG 38591
#define IMAGES_ISSUE_QUESTIONMARK_ICON_SVG 38592
#define IMAGES_ISSUE_TEXT_ICON_SVG 38593
#define IMAGES_JUSTIFY_CONTENT_CENTER_ICON_SVG 38594
#define IMAGES_JUSTIFY_CONTENT_FLEX_END_ICON_SVG 38595
#define IMAGES_JUSTIFY_CONTENT_FLEX_START_ICON_SVG 38596
#define IMAGES_JUSTIFY_CONTENT_SPACE_AROUND_ICON_SVG 38597
#define IMAGES_JUSTIFY_CONTENT_SPACE_BETWEEN_ICON_SVG 38598
#define IMAGES_JUSTIFY_CONTENT_SPACE_EVENLY_ICON_SVG 38599
#define IMAGES_JUSTIFY_ITEMS_CENTER_ICON_SVG 38600
#define IMAGES_JUSTIFY_ITEMS_END_ICON_SVG 38601
#define IMAGES_JUSTIFY_ITEMS_START_ICON_SVG 38602
#define IMAGES_JUSTIFY_ITEMS_STRETCH_ICON_SVG 38603
#define IMAGES_LARGEICONS_SVG 38604
#define IMAGES_LIGHTHOUSE_LOGO_SVG 38605
#define IMAGES_LINK_ICON_SVG 38606
#define IMAGES_MEDIUMICONS_SVG 38607
#define IMAGES_MINUS_ICON_SVG 38608
#define IMAGES_NAVIGATIONCONTROLS_PNG 38609
#define IMAGES_NAVIGATIONCONTROLS_2X_PNG 38610
#define IMAGES_NETWORK_CONDITIONS_ICON_SVG 38611
#define IMAGES_NETWORK_PANEL_ICON_SVG 38612
#define IMAGES_NODEICON_AVIF 38613
#define IMAGES_NODE_SEARCH_ICON_SVG 38614
#define IMAGES_PLUS_ICON_SVG 38615
#define IMAGES_POPOVERARROWS_PNG 38616
#define IMAGES_PREVIEW_FEATURE_VIDEO_THUMBNAIL_SVG 38617
#define IMAGES_PROFILEGROUPICON_PNG 38618
#define IMAGES_PROFILEICON_PNG 38619
#define IMAGES_PROFILESMALLICON_PNG 38620
#define IMAGES_REFRESH_12X12_ICON_SVG 38621
#define IMAGES_RESIZEDIAGONAL_SVG 38622
#define IMAGES_RESIZEHORIZONTAL_SVG 38623
#define IMAGES_RESIZEVERTICAL_SVG 38624
#define IMAGES_RESOURCESTIMEGRAPHICON_AVIF 38625
#define IMAGES_SEARCHNEXT_PNG 38626
#define IMAGES_SEARCHPREV_PNG 38627
#define IMAGES_SECURITYICONS_SVG 38628
#define IMAGES_SETTINGS_14X14_ICON_SVG 38629
#define IMAGES_SMALLICONS_SVG 38630
#define IMAGES_SOURCES_PANEL_ICON_SVG 38631
#define IMAGES_SPEECH_PNG 38632
#define IMAGES_STAR_OUTLINE_SVG 38633
#define IMAGES_SURVEY_FEEDBACK_ICON_SVG 38634
#define IMAGES_SWITCHERICON_SVG 38635
#define IMAGES_THREE_DOTS_MENU_ICON_SVG 38636
#define IMAGES_TOOLBARRESIZERVERTICAL_PNG 38637
#define IMAGES_TOUCHCURSOR_PNG 38638
#define IMAGES_TOUCHCURSOR_2X_PNG 38639
#define IMAGES_TRASH_BIN_ICON_SVG 38640
#define IMAGES_TREEOUTLINETRIANGLES_SVG 38641
#define IMAGES_TRIANGLE_COLLAPSED_SVG 38642
#define IMAGES_TRIANGLE_EXPANDED_SVG 38643
#define IMAGES_WARNING_ICON_SVG 38644
#define IMAGES_WHATSNEW_AVIF 38645
#define TESTS_JS 38646
#define CORE_COMMON_COMMON_LEGACY_JS 38647
#define CORE_COMMON_COMMON_JS 38648
#define CORE_DOM_EXTENSION_DOM_EXTENSION_JS 38649
#define CORE_HOST_HOST_LEGACY_JS 38650
#define CORE_HOST_HOST_JS 38651
#define CORE_I18N_I18N_JS 38652
#define CORE_I18N_LOCALES_EN_US_JSON 38653
#define CORE_I18N_LOCALES_ZH_JSON 38654
#define CORE_PLATFORM_PLATFORM_JS 38655
#define CORE_PROTOCOL_CLIENT_PROTOCOL_CLIENT_LEGACY_JS 38656
#define CORE_PROTOCOL_CLIENT_PROTOCOL_CLIENT_JS 38657
#define CORE_ROOT_ROOT_LEGACY_JS 38658
#define CORE_ROOT_ROOT_JS 38659
#define CORE_SDK_SDK_LEGACY_JS 38660
#define CORE_SDK_SDK_META_JS 38661
#define CORE_SDK_SDK_JS 38662
#define DEVICE_MODE_EMULATION_FRAME_HTML 38663
#define DEVTOOLS_APP_HTML 38664
#define DEVTOOLS_COMPATIBILITY_JS 38665
#define EMULATED_DEVICES_OPTIMIZED_MOTOG4_LANDSCAPE_AVIF 38666
#define EMULATED_DEVICES_OPTIMIZED_MOTOG4_PORTRAIT_AVIF 38667
#define EMULATED_DEVICES_OPTIMIZED_NEXUS5X_LANDSCAPE_AVIF 38668
#define EMULATED_DEVICES_OPTIMIZED_NEXUS5X_PORTRAIT_AVIF 38669
#define EMULATED_DEVICES_OPTIMIZED_NEXUS6P_LANDSCAPE_AVIF 38670
#define EMULATED_DEVICES_OPTIMIZED_NEXUS6P_PORTRAIT_AVIF 38671
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEST_HUB_HORIZONTAL_AVIF 38672
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEST_HUB_MAX_HORIZONTAL_AVIF 38673
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_DEFAULT_1X_AVIF 38674
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_DEFAULT_2X_AVIF 38675
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_KEYBOARD_1X_AVIF 38676
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_KEYBOARD_2X_AVIF 38677
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_NAVIGATION_1X_AVIF 38678
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_HORIZONTAL_NAVIGATION_2X_AVIF 38679
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_DEFAULT_1X_AVIF 38680
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_DEFAULT_2X_AVIF 38681
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_KEYBOARD_1X_AVIF 38682
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_KEYBOARD_2X_AVIF 38683
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_NAVIGATION_1X_AVIF 38684
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5_VERTICAL_NAVIGATION_2X_AVIF 38685
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_DEFAULT_1X_AVIF 38686
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_DEFAULT_2X_AVIF 38687
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_KEYBOARD_1X_AVIF 38688
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_KEYBOARD_2X_AVIF 38689
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_NAVIGATION_1X_AVIF 38690
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_HORIZONTAL_NAVIGATION_2X_AVIF 38691
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_DEFAULT_1X_AVIF 38692
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_DEFAULT_2X_AVIF 38693
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_KEYBOARD_1X_AVIF 38694
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_KEYBOARD_2X_AVIF 38695
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_NAVIGATION_1X_AVIF 38696
#define EMULATED_DEVICES_OPTIMIZED_GOOGLE_NEXUS_5X_VERTICAL_NAVIGATION_2X_AVIF 38697
#define EMULATED_DEVICES_OPTIMIZED_IPAD_LANDSCAPE_AVIF 38698
#define EMULATED_DEVICES_OPTIMIZED_IPAD_PORTRAIT_AVIF 38699
#define EMULATED_DEVICES_OPTIMIZED_IPHONE5_LANDSCAPE_AVIF 38700
#define EMULATED_DEVICES_OPTIMIZED_IPHONE5_PORTRAIT_AVIF 38701
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6_LANDSCAPE_AVIF 38702
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6_PORTRAIT_AVIF 38703
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6PLUS_LANDSCAPE_AVIF 38704
#define EMULATED_DEVICES_OPTIMIZED_IPHONE6PLUS_PORTRAIT_AVIF 38705
#define ENTRYPOINTS_DEVICE_MODE_EMULATION_FRAME_DEVICE_MODE_EMULATION_FRAME_JS 38706
#define ENTRYPOINTS_DEVTOOLS_APP_DEVTOOLS_APP_JS 38707
#define ENTRYPOINTS_FORMATTER_WORKER_FORMATTERACTIONS_JS 38708
#define ENTRYPOINTS_FORMATTER_WORKER_FORMATTER_WORKER_ENTRYPOINT_JS 38709
#define ENTRYPOINTS_FORMATTER_WORKER_FORMATTER_WORKER_JS 38710
#define ENTRYPOINTS_HEAP_SNAPSHOT_WORKER_HEAP_SNAPSHOT_WORKER_ENTRYPOINT_JS 38711
#define ENTRYPOINTS_HEAP_SNAPSHOT_WORKER_HEAP_SNAPSHOT_WORKER_LEGACY_JS 38712
#define ENTRYPOINTS_HEAP_SNAPSHOT_WORKER_HEAP_SNAPSHOT_WORKER_JS 38713
#define ENTRYPOINTS_INSPECTOR_INSPECTOR_JS 38714
#define ENTRYPOINTS_INSPECTOR_MAIN_INSPECTOR_MAIN_META_JS 38715
#define ENTRYPOINTS_INSPECTOR_MAIN_INSPECTOR_MAIN_JS 38716
#define ENTRYPOINTS_JS_APP_JS_APP_JS 38717
#define ENTRYPOINTS_LIGHTHOUSE_WORKER_LIGHTHOUSE_WORKER_JS 38718
#define ENTRYPOINTS_MAIN_MAIN_LEGACY_JS 38719
#define ENTRYPOINTS_MAIN_MAIN_META_JS 38720
#define ENTRYPOINTS_MAIN_MAIN_JS 38721
#define ENTRYPOINTS_NDB_APP_NDB_APP_JS 38722
#define ENTRYPOINTS_NODE_APP_NODE_APP_JS 38723
#define ENTRYPOINTS_SHELL_SHELL_JS 38724
#define ENTRYPOINTS_WASMPARSER_WORKER_WASMPARSER_WORKER_ENTRYPOINT_JS 38725
#define ENTRYPOINTS_WASMPARSER_WORKER_WASMPARSER_WORKER_JS 38726
#define ENTRYPOINTS_WORKER_APP_WORKER_APP_JS 38727
#define INSPECTOR_HTML 38728
#define INTEGRATION_TEST_RUNNER_HTML 38729
#define JS_APP_HTML 38730
#define LEGACY_TEST_RUNNER_LEGACY_TEST_RUNNER_JS 38731
#define LEGACY_TEST_RUNNER_TEST_RUNNER_TEST_RUNNER_JS 38732
#define MODELS_BINDINGS_BINDINGS_LEGACY_JS 38733
#define MODELS_BINDINGS_BINDINGS_JS 38734
#define MODELS_EMULATION_EMULATION_JS 38735
#define MODELS_EXTENSIONS_EXTENSIONS_LEGACY_JS 38736
#define MODELS_EXTENSIONS_EXTENSIONS_JS 38737
#define MODELS_FORMATTER_FORMATTER_LEGACY_JS 38738
#define MODELS_FORMATTER_FORMATTER_JS 38739
#define MODELS_HAR_HAR_JS 38740
#define MODELS_HEAP_SNAPSHOT_MODEL_HEAP_SNAPSHOT_MODEL_LEGACY_JS 38741
#define MODELS_HEAP_SNAPSHOT_MODEL_HEAP_SNAPSHOT_MODEL_JS 38742
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCOOPSANDBOXEDIFRAMECANNOTNAVIGATETOCOOPPAGE_MD 38743
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCORPNOTSAMEORIGIN_MD 38744
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCORPNOTSAMEORIGINAFTERDEFAULTEDTOSAMEORIGINBYCOEP_MD 38745
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPCORPNOTSAMESITE_MD 38746
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COEPFRAMERESOURCENEEDSCOEPHEADER_MD 38747
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COMPATIBILITYMODEQUIRKS_MD 38748
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_COOKIEATTRIBUTEVALUEEXCEEDSMAXSIZE_MD 38749
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_LOWTEXTCONTRAST_MD 38750
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEEXCLUDECONTEXTDOWNGRADEREAD_MD 38751
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEEXCLUDECONTEXTDOWNGRADESET_MD 38752
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEEXCLUDENAVIGATIONCONTEXTDOWNGRADE_MD 38753
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEINVALIDSAMEPARTY_MD 38754
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREERRORREAD_MD 38755
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREERRORSET_MD 38756
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREWARNREAD_MD 38757
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITENONEINSECUREWARNSET_MD 38758
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDLAXALLOWUNSAFEREAD_MD 38759
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDLAXALLOWUNSAFESET_MD 38760
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDTREATEDASLAXREAD_MD 38761
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEUNSPECIFIEDTREATEDASLAXSET_MD 38762
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEWARNCROSSDOWNGRADEREAD_MD 38763
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEWARNCROSSDOWNGRADESET_MD 38764
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SAMESITEWARNSTRICTLAXDOWNGRADESTRICT_MD 38765
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_TWADIGITALASSETLINKSFAILED_MD 38766
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_TWAHTTPERROR_MD 38767
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_TWAPAGEUNAVAILABLEOFFLINE_MD 38768
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARATTRIBUTIONSOURCEUNTRUSTWORTHYFRAMEORIGIN_MD 38769
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARATTRIBUTIONSOURCEUNTRUSTWORTHYORIGIN_MD 38770
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARATTRIBUTIONUNTRUSTWORTHYFRAMEORIGIN_MD 38771
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARATTRIBUTIONUNTRUSTWORTHYORIGIN_MD 38772
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARINVALIDHEADER_MD 38773
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_ARPERMISSIONPOLICYDISABLED_MD 38774
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CLIENTHINTMETATAGALLOWLISTINVALIDORIGIN_MD 38775
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CLIENTHINTMETATAGMODIFIEDHTML_MD 38776
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSALLOWCREDENTIALSREQUIRED_MD 38777
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSDISABLEDSCHEME_MD 38778
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSDISALLOWEDBYMODE_MD 38779
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSHEADERDISALLOWEDBYPREFLIGHTRESPONSE_MD 38780
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSINSECUREPRIVATENETWORK_MD 38781
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSINVALIDHEADERVALUES_MD 38782
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSMETHODDISALLOWEDBYPREFLIGHTRESPONSE_MD 38783
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSNOCORSREDIRECTMODENOTFOLLOW_MD 38784
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSORIGINMISMATCH_MD 38785
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSPREFLIGHTALLOWPRIVATENETWORKERROR_MD 38786
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSPREFLIGHTRESPONSEINVALID_MD 38787
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSREDIRECTCONTAINSCREDENTIALS_MD 38788
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CORSWILDCARDORIGINNOTALLOWED_MD 38789
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPEVALVIOLATION_MD 38790
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPINLINEVIOLATION_MD 38791
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPTRUSTEDTYPESPOLICYVIOLATION_MD 38792
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPTRUSTEDTYPESSINKVIOLATION_MD 38793
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_CSPURLVIOLATION_MD 38794
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_DEPRECATION_MD 38795
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_DEPRECATIONNAVIGATORUSERAGENT_MD 38796
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTACCOUNTSHTTPNOTFOUND_MD 38797
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTACCOUNTSINVALIDRESPONSE_MD 38798
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTACCOUNTSNORESPONSE_MD 38799
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTAPPROVALDECLINED_MD 38800
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCANCELED_MD 38801
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCLIENTMETADATAHTTPNOTFOUND_MD 38802
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCLIENTMETADATAINVALIDRESPONSE_MD 38803
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTCLIENTMETADATANORESPONSE_MD 38804
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTERRORFETCHINGSIGNIN_MD 38805
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTERRORIDTOKEN_MD 38806
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENHTTPNOTFOUND_MD 38807
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENINVALIDREQUEST_MD 38808
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENINVALIDRESPONSE_MD 38809
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTIDTOKENNORESPONSE_MD 38810
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTINVALIDSIGNINRESPONSE_MD 38811
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTMANIFESTHTTPNOTFOUND_MD 38812
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTMANIFESTINVALIDRESPONSE_MD 38813
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTMANIFESTNORESPONSE_MD 38814
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_FEDERATEDAUTHREQUESTTOOMANYREQUESTS_MD 38815
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_GENERICCROSSORIGINPORTALPOSTMESSAGEERROR_MD 38816
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_HEAVYAD_MD 38817
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_MIXEDCONTENT_MD 38818
#define MODELS_ISSUES_MANAGER_DESCRIPTIONS_SHAREDARRAYBUFFER_MD 38819
#define MODELS_ISSUES_MANAGER_ISSUES_MANAGER_JS 38820
#define MODELS_JAVASCRIPT_METADATA_JAVASCRIPT_METADATA_JS 38821
#define MODELS_LOGS_LOGS_META_JS 38822
#define MODELS_LOGS_LOGS_JS 38823
#define MODELS_PERSISTENCE_PERSISTENCE_LEGACY_JS 38824
#define MODELS_PERSISTENCE_PERSISTENCE_META_JS 38825
#define MODELS_PERSISTENCE_PERSISTENCE_JS 38826
#define MODELS_SOURCE_MAP_SCOPES_SOURCE_MAP_SCOPES_JS 38827
#define MODELS_TEXT_UTILS_TEXT_UTILS_LEGACY_JS 38828
#define MODELS_TEXT_UTILS_TEXT_UTILS_JS 38829
#define MODELS_TIMELINE_MODEL_TIMELINE_MODEL_LEGACY_JS 38830
#define MODELS_TIMELINE_MODEL_TIMELINE_MODEL_JS 38831
#define MODELS_WORKSPACE_WORKSPACE_LEGACY_JS 38832
#define MODELS_WORKSPACE_WORKSPACE_JS 38833
#define MODELS_WORKSPACE_DIFF_WORKSPACE_DIFF_LEGACY_JS 38834
#define MODELS_WORKSPACE_DIFF_WORKSPACE_DIFF_JS 38835
#define NDB_APP_HTML 38836
#define NODE_APP_HTML 38837
#define PANELS_ACCESSIBILITY_ACCESSIBILITY_LEGACY_JS 38838
#define PANELS_ACCESSIBILITY_ACCESSIBILITY_META_JS 38839
#define PANELS_ACCESSIBILITY_ACCESSIBILITY_JS 38840
#define PANELS_ANIMATION_ANIMATION_LEGACY_JS 38841
#define PANELS_ANIMATION_ANIMATION_META_JS 38842
#define PANELS_ANIMATION_ANIMATION_JS 38843
#define PANELS_APPLICATION_APPLICATION_LEGACY_JS 38844
#define PANELS_APPLICATION_APPLICATION_META_JS 38845
#define PANELS_APPLICATION_APPLICATION_JS 38846
#define PANELS_APPLICATION_COMPONENTS_COMPONENTS_JS 38847
#define PANELS_BROWSER_DEBUGGER_BROWSER_DEBUGGER_LEGACY_JS 38848
#define PANELS_BROWSER_DEBUGGER_BROWSER_DEBUGGER_META_JS 38849
#define PANELS_BROWSER_DEBUGGER_BROWSER_DEBUGGER_JS 38850
#define PANELS_CHANGES_CHANGES_LEGACY_JS 38851
#define PANELS_CHANGES_CHANGES_META_JS 38852
#define PANELS_CHANGES_CHANGES_JS 38853
#define PANELS_CONSOLE_CONSOLE_LEGACY_JS 38854
#define PANELS_CONSOLE_CONSOLE_META_JS 38855
#define PANELS_CONSOLE_CONSOLE_JS 38856
#define PANELS_CONSOLE_COUNTERS_CONSOLE_COUNTERS_META_JS 38857
#define PANELS_CONSOLE_COUNTERS_CONSOLE_COUNTERS_JS 38858
#define PANELS_COVERAGE_COVERAGE_LEGACY_JS 38859
#define PANELS_COVERAGE_COVERAGE_META_JS 38860
#define PANELS_COVERAGE_COVERAGE_JS 38861
#define PANELS_CSS_OVERVIEW_COMPONENTS_COMPONENTS_JS 38862
#define PANELS_CSS_OVERVIEW_CSS_OVERVIEW_META_JS 38863
#define PANELS_CSS_OVERVIEW_CSS_OVERVIEW_JS 38864
#define PANELS_DEVELOPER_RESOURCES_DEVELOPER_RESOURCES_META_JS 38865
#define PANELS_DEVELOPER_RESOURCES_DEVELOPER_RESOURCES_JS 38866
#define PANELS_ELEMENTS_COMPONENTS_COMPONENTS_JS 38867
#define PANELS_ELEMENTS_ELEMENTS_LEGACY_JS 38868
#define PANELS_ELEMENTS_ELEMENTS_META_JS 38869
#define PANELS_ELEMENTS_ELEMENTS_JS 38870
#define PANELS_EMULATION_COMPONENTS_COMPONENTS_JS 38871
#define PANELS_EMULATION_EMULATION_LEGACY_JS 38872
#define PANELS_EMULATION_EMULATION_META_JS 38873
#define PANELS_EMULATION_EMULATION_JS 38874
#define PANELS_EVENT_LISTENERS_EVENT_LISTENERS_JS 38875
#define PANELS_INPUT_INPUT_META_JS 38876
#define PANELS_INPUT_INPUT_JS 38877
#define PANELS_ISSUES_COMPONENTS_COMPONENTS_JS 38878
#define PANELS_ISSUES_ISSUES_META_JS 38879
#define PANELS_ISSUES_ISSUES_JS 38880
#define PANELS_JS_PROFILER_JS_PROFILER_META_JS 38881
#define PANELS_JS_PROFILER_JS_PROFILER_JS 38882
#define PANELS_LAYER_VIEWER_LAYER_VIEWER_LEGACY_JS 38883
#define PANELS_LAYER_VIEWER_LAYER_VIEWER_META_JS 38884
#define PANELS_LAYER_VIEWER_LAYER_VIEWER_JS 38885
#define PANELS_LAYERS_LAYERS_META_JS 38886
#define PANELS_LAYERS_LAYERS_JS 38887
#define PANELS_LIGHTHOUSE_LIGHTHOUSE_LEGACY_JS 38888
#define PANELS_LIGHTHOUSE_LIGHTHOUSE_META_JS 38889
#define PANELS_LIGHTHOUSE_LIGHTHOUSE_JS 38890
#define PANELS_MEDIA_MEDIA_META_JS 38891
#define PANELS_MEDIA_MEDIA_JS 38892
#define PANELS_MOBILE_THROTTLING_MOBILE_THROTTLING_LEGACY_JS 38893
#define PANELS_MOBILE_THROTTLING_MOBILE_THROTTLING_META_JS 38894
#define PANELS_MOBILE_THROTTLING_MOBILE_THROTTLING_JS 38895
#define PANELS_NETWORK_COMPONENTS_COMPONENTS_JS 38896
#define PANELS_NETWORK_FORWARD_FORWARD_JS 38897
#define PANELS_NETWORK_NETWORK_LEGACY_JS 38898
#define PANELS_NETWORK_NETWORK_META_JS 38899
#define PANELS_NETWORK_NETWORK_JS 38900
#define PANELS_PERFORMANCE_MONITOR_PERFORMANCE_MONITOR_META_JS 38901
#define PANELS_PERFORMANCE_MONITOR_PERFORMANCE_MONITOR_JS 38902
#define PANELS_PROFILER_PROFILER_LEGACY_JS 38903
#define PANELS_PROFILER_PROFILER_META_JS 38904
#define PANELS_PROFILER_PROFILER_JS 38905
#define PANELS_PROTOCOL_MONITOR_PROTOCOL_MONITOR_META_JS 38906
#define PANELS_PROTOCOL_MONITOR_PROTOCOL_MONITOR_JS 38907
#define PANELS_SCREENCAST_SCREENCAST_META_JS 38908
#define PANELS_SCREENCAST_SCREENCAST_JS 38909
#define PANELS_SEARCH_SEARCH_LEGACY_JS 38910
#define PANELS_SEARCH_SEARCH_JS 38911
#define PANELS_SECURITY_SECURITY_LEGACY_JS 38912
#define PANELS_SECURITY_SECURITY_META_JS 38913
#define PANELS_SECURITY_SECURITY_JS 38914
#define PANELS_SENSORS_SENSORS_META_JS 38915
#define PANELS_SENSORS_SENSORS_JS 38916
#define PANELS_SETTINGS_COMPONENTS_COMPONENTS_JS 38917
#define PANELS_SETTINGS_EMULATION_COMPONENTS_COMPONENTS_JS 38918
#define PANELS_SETTINGS_EMULATION_EMULATION_META_JS 38919
#define PANELS_SETTINGS_EMULATION_EMULATION_JS 38920
#define PANELS_SETTINGS_EMULATION_UTILS_UTILS_JS 38921
#define PANELS_SETTINGS_SETTINGS_LEGACY_JS 38922
#define PANELS_SETTINGS_SETTINGS_META_JS 38923
#define PANELS_SETTINGS_SETTINGS_JS 38924
#define PANELS_SNIPPETS_SNIPPETS_LEGACY_JS 38925
#define PANELS_SNIPPETS_SNIPPETS_JS 38926
#define PANELS_SOURCES_COMPONENTS_COMPONENTS_JS 38927
#define PANELS_SOURCES_SOURCES_LEGACY_JS 38928
#define PANELS_SOURCES_SOURCES_META_JS 38929
#define PANELS_SOURCES_SOURCES_JS 38930
#define PANELS_TIMELINE_COMPONENTS_COMPONENTS_JS 38931
#define PANELS_TIMELINE_TIMELINE_LEGACY_JS 38932
#define PANELS_TIMELINE_TIMELINE_META_JS 38933
#define PANELS_TIMELINE_TIMELINE_JS 38934
#define PANELS_UTILS_UTILS_JS 38935
#define PANELS_WEB_AUDIO_GRAPH_VISUALIZER_GRAPH_VISUALIZER_JS 38936
#define PANELS_WEB_AUDIO_WEB_AUDIO_LEGACY_JS 38937
#define PANELS_WEB_AUDIO_WEB_AUDIO_META_JS 38938
#define PANELS_WEB_AUDIO_WEB_AUDIO_JS 38939
#define PANELS_WEBAUTHN_WEBAUTHN_META_JS 38940
#define PANELS_WEBAUTHN_WEBAUTHN_JS 38941
#define SERVICES_PUPPETEER_PUPPETEER_JS 38942
#define SERVICES_WINDOW_BOUNDS_WINDOW_BOUNDS_JS 38943
#define THIRD_PARTY_ACORN_LOOSE_ACORN_LOOSE_JS 38944
#define THIRD_PARTY_ACORN_ACORN_JS 38945
#define THIRD_PARTY_CHROMIUM_CLIENT_VARIATIONS_CLIENT_VARIATIONS_JS 38946
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_CODEMIRROR_JS 38947
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_CPP_JS 38948
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_JAVA_JS 38949
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_JSON_JS 38950
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_LEGACY_JS 38951
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_MARKDOWN_JS 38952
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_PHP_JS 38953
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_PYTHON_JS 38954
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_WAST_JS 38955
#define THIRD_PARTY_CODEMIRROR_NEXT_CHUNK_XML_JS 38956
#define THIRD_PARTY_CODEMIRROR_NEXT_CODEMIRROR_NEXT_JS 38957
#define THIRD_PARTY_DIFF_DIFF_LEGACY_JS 38958
#define THIRD_PARTY_DIFF_DIFF_JS 38959
#define THIRD_PARTY_I18N_I18N_JS 38960
#define THIRD_PARTY_INTL_MESSAGEFORMAT_INTL_MESSAGEFORMAT_JS 38961
#define THIRD_PARTY_LIGHTHOUSE_LIGHTHOUSE_DT_BUNDLE_JS 38962
#define THIRD_PARTY_LIGHTHOUSE_REPORT_REPORT_JS 38963
#define THIRD_PARTY_LIT_HTML_LIT_HTML_JS 38964
#define THIRD_PARTY_MARKED_MARKED_JS 38965
#define THIRD_PARTY_PUPPETEER_PUPPETEER_JS 38966
#define THIRD_PARTY_WASMPARSER_WASMPARSER_JS 38967
#define UI_COMPONENTS_ADORNERS_ADORNERS_JS 38968
#define UI_COMPONENTS_BUTTONS_BUTTONS_JS 38969
#define UI_COMPONENTS_CHROME_LINK_CHROME_LINK_JS 38970
#define UI_COMPONENTS_CODE_HIGHLIGHTER_CODE_HIGHLIGHTER_JS 38971
#define UI_COMPONENTS_DATA_GRID_DATA_GRID_JS 38972
#define UI_COMPONENTS_DIFF_VIEW_DIFF_VIEW_JS 38973
#define UI_COMPONENTS_EXPANDABLE_LIST_EXPANDABLE_LIST_JS 38974
#define UI_COMPONENTS_HELPERS_HELPERS_JS 38975
#define UI_COMPONENTS_ICON_BUTTON_ICON_BUTTON_JS 38976
#define UI_COMPONENTS_INPUT_INPUT_JS 38977
#define UI_COMPONENTS_ISSUE_COUNTER_ISSUE_COUNTER_JS 38978
#define UI_COMPONENTS_LINEAR_MEMORY_INSPECTOR_LINEAR_MEMORY_INSPECTOR_META_JS 38979
#define UI_COMPONENTS_LINEAR_MEMORY_INSPECTOR_LINEAR_MEMORY_INSPECTOR_JS 38980
#define UI_COMPONENTS_LINKIFIER_LINKIFIER_JS 38981
#define UI_COMPONENTS_MARKDOWN_VIEW_MARKDOWN_VIEW_JS 38982
#define UI_COMPONENTS_NODE_TEXT_NODE_TEXT_JS 38983
#define UI_COMPONENTS_PANEL_FEEDBACK_PANEL_FEEDBACK_JS 38984
#define UI_COMPONENTS_PANEL_INTRODUCTION_STEPS_PANEL_INTRODUCTION_STEPS_JS 38985
#define UI_COMPONENTS_RENDER_COORDINATOR_RENDER_COORDINATOR_JS 38986
#define UI_COMPONENTS_REPORT_VIEW_REPORT_VIEW_JS 38987
#define UI_COMPONENTS_REQUEST_LINK_ICON_REQUEST_LINK_ICON_JS 38988
#define UI_COMPONENTS_SETTINGS_SETTINGS_JS 38989
#define UI_COMPONENTS_SURVEY_LINK_SURVEY_LINK_JS 38990
#define UI_COMPONENTS_TEXT_EDITOR_TEXT_EDITOR_JS 38991
#define UI_COMPONENTS_TEXT_PROMPT_TEXT_PROMPT_JS 38992
#define UI_COMPONENTS_TREE_OUTLINE_TREE_OUTLINE_JS 38993
#define UI_LEGACY_COMPONENTS_COLOR_PICKER_COLOR_PICKER_LEGACY_JS 38994
#define UI_LEGACY_COMPONENTS_COLOR_PICKER_COLOR_PICKER_JS 38995
#define UI_LEGACY_COMPONENTS_COOKIE_TABLE_COOKIE_TABLE_LEGACY_JS 38996
#define UI_LEGACY_COMPONENTS_COOKIE_TABLE_COOKIE_TABLE_JS 38997
#define UI_LEGACY_COMPONENTS_DATA_GRID_DATA_GRID_LEGACY_JS 38998
#define UI_LEGACY_COMPONENTS_DATA_GRID_DATA_GRID_JS 38999
#define UI_LEGACY_COMPONENTS_INLINE_EDITOR_INLINE_EDITOR_LEGACY_JS 39000
#define UI_LEGACY_COMPONENTS_INLINE_EDITOR_INLINE_EDITOR_JS 39001
#define UI_LEGACY_COMPONENTS_OBJECT_UI_OBJECT_UI_LEGACY_JS 39002
#define UI_LEGACY_COMPONENTS_OBJECT_UI_OBJECT_UI_META_JS 39003
#define UI_LEGACY_COMPONENTS_OBJECT_UI_OBJECT_UI_JS 39004
#define UI_LEGACY_COMPONENTS_PERF_UI_PERF_UI_LEGACY_JS 39005
#define UI_LEGACY_COMPONENTS_PERF_UI_PERF_UI_META_JS 39006
#define UI_LEGACY_COMPONENTS_PERF_UI_PERF_UI_JS 39007
#define UI_LEGACY_COMPONENTS_QUICK_OPEN_QUICK_OPEN_LEGACY_JS 39008
#define UI_LEGACY_COMPONENTS_QUICK_OPEN_QUICK_OPEN_META_JS 39009
#define UI_LEGACY_COMPONENTS_QUICK_OPEN_QUICK_OPEN_JS 39010
#define UI_LEGACY_COMPONENTS_SOURCE_FRAME_SOURCE_FRAME_LEGACY_JS 39011
#define UI_LEGACY_COMPONENTS_SOURCE_FRAME_SOURCE_FRAME_META_JS 39012
#define UI_LEGACY_COMPONENTS_SOURCE_FRAME_SOURCE_FRAME_JS 39013
#define UI_LEGACY_COMPONENTS_UTILS_UTILS_LEGACY_JS 39014
#define UI_LEGACY_COMPONENTS_UTILS_UTILS_JS 39015
#define UI_LEGACY_LEGACY_LEGACY_JS 39016
#define UI_LEGACY_LEGACY_JS 39017
#define UI_LEGACY_THEME_SUPPORT_THEME_SUPPORT_JS 39018
#define UI_LEGACY_UTILS_UTILS_JS 39019
#define UI_LIT_HTML_LIT_HTML_JS 39020
#define WORKER_APP_HTML 39021

// ---------------------------------------------------------------------------
// From extensions_browser_resources.h:

#define IDR_APP_DEFAULT_ICON 31900
#define IDR_EXTENSION_DEFAULT_ICON 31901
#define IDR_EXTENSION_ACTION_PLAIN_BACKGROUND 31902
#define IDR_EXTENSION_ICON_PLAIN_BACKGROUND 31903
#define IDR_EXTENSIONS_FAVICON 257

// ---------------------------------------------------------------------------
// From extensions_renderer_resources.h:

#define IDR_APP_VIEW_JS 31920
#define IDR_APP_VIEW_DENY_JS 31921
#define IDR_APP_VIEW_ELEMENT_JS 31922
#define IDR_BROWSER_TEST_ENVIRONMENT_SPECIFIC_BINDINGS_JS 31923
#define IDR_ENTRY_ID_MANAGER 31924
#define IDR_EXTENSIONS_WEB_VIEW_ELEMENT_JS 31925
#define IDR_EXTENSION_OPTIONS_JS 31926
#define IDR_EXTENSION_OPTIONS_ELEMENT_JS 31927
#define IDR_EXTENSION_OPTIONS_ATTRIBUTES_JS 31928
#define IDR_EXTENSION_OPTIONS_CONSTANTS_JS 31929
#define IDR_EXTENSION_OPTIONS_EVENTS_JS 31930
#define IDR_FEEDBACK_PRIVATE_CUSTOM_BINDINGS_JS 31931
#define IDR_GUEST_VIEW_ATTRIBUTES_JS 31932
#define IDR_GUEST_VIEW_CONTAINER_JS 31933
#define IDR_GUEST_VIEW_CONTAINER_ELEMENT_JS 31934
#define IDR_GUEST_VIEW_DENY_JS 31935
#define IDR_GUEST_VIEW_EVENTS_JS 31936
#define IDR_GUEST_VIEW_JS 31937
#define IDR_IMAGE_UTIL_JS 31938
#define IDR_KEEP_ALIVE_JS 31939
#define IDR_KEEP_ALIVE_MOJOM_JS 31940
#define IDR_MIME_HANDLER_PRIVATE_CUSTOM_BINDINGS_JS 31941
#define IDR_MIME_HANDLER_MOJOM_JS 31942
#define IDR_SAFE_METHODS_JS 31943
#define IDR_SET_ICON_JS 31944
#define IDR_TEST_CUSTOM_BINDINGS_JS 31945
#define IDR_UNCAUGHT_EXCEPTION_HANDLER_JS 31946
#define IDR_UTILS_JS 31947
#define IDR_WEB_VIEW_ACTION_REQUESTS_JS 31948
#define IDR_WEB_VIEW_API_METHODS_JS 31949
#define IDR_WEB_VIEW_ATTRIBUTES_JS 31950
#define IDR_WEB_VIEW_CONSTANTS_JS 31951
#define IDR_WEB_VIEW_EVENTS_JS 31952
#define IDR_WEB_VIEW_INTERNAL_CUSTOM_BINDINGS_JS 31953
#define IDR_WEB_VIEW_JS 31954
#define IDR_WEB_VIEW_DENY_JS 31955
#define IDR_WEB_VIEW_ELEMENT_JS 31956
#define IDR_AUTOMATION_CUSTOM_BINDINGS_JS 31957
#define IDR_AUTOMATION_EVENT_JS 31958
#define IDR_AUTOMATION_NODE_JS 31959
#define IDR_AUTOMATION_TREE_CACHE_JS 31960
#define IDR_APP_RUNTIME_CUSTOM_BINDINGS_JS 31961
#define IDR_APP_WINDOW_CUSTOM_BINDINGS_JS 31962
#define IDR_CONTEXT_MENUS_CUSTOM_BINDINGS_JS 31963
#define IDR_CONTEXT_MENUS_HANDLERS_JS 31964
#define IDR_DECLARATIVE_WEBREQUEST_CUSTOM_BINDINGS_JS 31965
#define IDR_FILE_ENTRY_BINDING_UTIL_JS 31966
#define IDR_FILE_SYSTEM_CUSTOM_BINDINGS_JS 31967
#define IDR_GREASEMONKEY_API_JS 31968
#define IDR_MOJO_PRIVATE_CUSTOM_BINDINGS_JS 31969
#define IDR_PERMISSIONS_CUSTOM_BINDINGS_JS 31970
#define IDR_PRINTER_PROVIDER_CUSTOM_BINDINGS_JS 31971
#define IDR_SERVICE_WORKER_BINDINGS_JS 31972
#define IDR_WEB_REQUEST_CUSTOM_BINDINGS_JS 31973
#define IDR_WEB_REQUEST_EVENT_JS 31974
#define IDR_WEB_VIEW_REQUEST_CUSTOM_BINDINGS_JS 31975
#define IDR_PLATFORM_APP_JS 31976
#define IDR_EXTENSION_FONTS_CSS 31977
#define IDR_PLATFORM_APP_CSS 31990
#define IDR_EXTENSION_CSS 31991

// ---------------------------------------------------------------------------
// From extensions_resources.h:

#define IDR_EXTENSION_API_FEATURES 31910

// ---------------------------------------------------------------------------
// From mojo_bindings_resources.h:

#define IDR_MOJO_MOJO_BINDINGS_JS 32090
#define IDR_MOJO_BINDINGS_JS 32091
#define IDR_MOJO_BIG_BUFFER_MOJOM_WEBUI_JS 32096
#define IDR_MOJO_FILE_MOJOM_WEBUI_JS 32097
#define IDR_MOJO_FILE_PATH_MOJOM_WEBUI_JS 32098
#define IDR_MOJO_READ_ONLY_BUFFER_MOJOM_WEBUI_JS 32099
#define IDR_MOJO_SAFE_BASE_NAME_MOJOM_WEBUI_JS 32100
#define IDR_MOJO_STRING16_MOJOM_WEBUI_JS 32103
#define IDR_MOJO_TEXT_DIRECTION_MOJOM_WEBUI_JS 32108
#define IDR_MOJO_TOKEN_MOJOM_WEBUI_JS 32109
#define IDR_MOJO_UNGUESSABLE_TOKEN_MOJOM_WEBUI_JS 32110
#define IDR_MOJO_PROCESS_ID_MOJOM_WEBUI_JS 32111
#define IDR_MOJO_TIME_MOJOM_WEBUI_JS 32112

// ---------------------------------------------------------------------------
// From net_resources.h:

#define IDR_DIR_HEADER_HTML 32120

// ---------------------------------------------------------------------------
// From pdf_resources.h:

#define IDR_PDF_BROWSER_API_JS 15320
#define IDR_PDF_MAIN_JS 15321
#define IDR_PDF_INDEX_CSS 15322
#define IDR_PDF_INDEX_HTML 15323
#define IDR_PDF_PDF_VIEWER_WRAPPER_ROLLUP_JS 15324
#define IDR_PDF_PDF_INTERNAL_PLUGIN_WRAPPER_ROLLUP_JS 15325

// ---------------------------------------------------------------------------
// From renderer_resources.h:

#define IDR_BLOCKED_PLUGIN_HTML 19190
#define IDR_DISABLED_PLUGIN_HTML 19191
#define IDR_PDF_PLUGIN_HTML 19192
#define IDR_CART_PRODUCT_EXTRACTION_JS 19193
#define IDR_CART_DOMAIN_PRODUCT_ID_REGEX_JSON 19194
#define IDR_SKIP_ADD_TO_CART_REQUEST_DOMAIN_MAPPING_JSON 19195
#define IDR_PURCHASE_URL_REGEX_DOMAIN_MAPPING_JSON 19196
#define IDR_ACTION_CUSTOM_BINDINGS_JS 19197
#define IDR_BROWSER_ACTION_CUSTOM_BINDINGS_JS 19198
#define IDR_CHROME_WEB_VIEW_INTERNAL_CUSTOM_BINDINGS_JS 19199
#define IDR_CHROME_WEB_VIEW_JS 19200
#define IDR_DECLARATIVE_CONTENT_CUSTOM_BINDINGS_JS 19201
#define IDR_DESKTOP_CAPTURE_CUSTOM_BINDINGS_JS 19202
#define IDR_DEVELOPER_PRIVATE_CUSTOM_BINDINGS_JS 19203
#define IDR_DOWNLOADS_CUSTOM_BINDINGS_JS 19204
#define IDR_GCM_CUSTOM_BINDINGS_JS 19205
#define IDR_IDENTITY_CUSTOM_BINDINGS_JS 19206
#define IDR_IMAGE_WRITER_PRIVATE_CUSTOM_BINDINGS_JS 19207
#define IDR_INPUT_IME_CUSTOM_BINDINGS_JS 19208
#define IDR_MEDIA_GALLERIES_CUSTOM_BINDINGS_JS 19209
#define IDR_NOTIFICATIONS_CUSTOM_BINDINGS_JS 19210
#define IDR_OMNIBOX_CUSTOM_BINDINGS_JS 19211
#define IDR_PAGE_ACTION_CUSTOM_BINDINGS_JS 19212
#define IDR_PAGE_CAPTURE_CUSTOM_BINDINGS_JS 19213
#define IDR_SYNC_FILE_SYSTEM_CUSTOM_BINDINGS_JS 19214
#define IDR_SYSTEM_INDICATOR_CUSTOM_BINDINGS_JS 19215
#define IDR_TAB_CAPTURE_CUSTOM_BINDINGS_JS 19216
#define IDR_TTS_CUSTOM_BINDINGS_JS 19217
#define IDR_TTS_ENGINE_CUSTOM_BINDINGS_JS 19218
#define IDR_WEBRTC_DESKTOP_CAPTURE_PRIVATE_CUSTOM_BINDINGS_JS 19219
#define IDR_WEBRTC_LOGGING_PRIVATE_CUSTOM_BINDINGS_JS 19220

// ---------------------------------------------------------------------------
// From tracing_proto_resources.h:

#define chrome_track_event_descriptor 31810

// ---------------------------------------------------------------------------
// From tracing_resources.h:

#define IDR_TRACING_ABOUT_TRACING_HTML 28950
#define IDR_TRACING_ABOUT_TRACING_JS 28951

// ---------------------------------------------------------------------------
// From ui_resources.h:

#define IDR_ALIAS_CURSOR 36609
#define IDR_CELL_CURSOR 36610
#define IDR_EAST_RESIZE_CURSOR 36611
#define IDR_EASTWEST_RESIZE_CURSOR 36612
#define IDR_HELP_CURSOR 36613
#define IDR_LINK_CURSOR 36614
#define IDR_MOVE_CURSOR 36615
#define IDR_NONE_CURSOR 36616
#define IDR_NORTHEAST_RESIZE_CURSOR 36617
#define IDR_NORTHEASTSOUTHWEST_RESIZE_CURSOR 36618
#define IDR_NORTH_RESIZE_CURSOR 36619
#define IDR_NORTHSOUTH_RESIZE_CURSOR 36620
#define IDR_NORTHWEST_RESIZE_CURSOR 36621
#define IDR_NORTHWESTSOUTHEAST_RESIZE_CURSOR 36622
#define IDR_PROGRESS_CURSOR 36623
#define IDR_SOUTHEAST_RESIZE_CURSOR 36624
#define IDR_SOUTH_RESIZE_CURSOR 36625
#define IDR_SOUTHWEST_RESIZE_CURSOR 36626
#define IDR_VERTICALTEXT_CURSOR 36627
#define IDR_WAIT_CURSOR 36628
#define IDR_WEST_RESIZE_CURSOR 36629
#define IDR_ZOOMIN_CURSOR 36630
#define IDR_ZOOMOUT_CURSOR 36631
#define IDR_CLOSE_2 36632
#define IDR_CLOSE_2_H 36633
#define IDR_CLOSE_2_P 36634
#define IDR_CLOSE_DIALOG 36635
#define IDR_CLOSE_DIALOG_H 36636
#define IDR_CLOSE_DIALOG_P 36637
#define IDR_DISABLE 36638
#define IDR_DISABLE_H 36639
#define IDR_DISABLE_P 36640
#define IDR_DEFAULT_FAVICON 263
#define IDR_DEFAULT_FAVICON_DARK 36641
#define IDR_DEFAULT_FAVICON_32 36642
#define IDR_DEFAULT_FAVICON_DARK_32 36643
#define IDR_DEFAULT_FAVICON_64 36644
#define IDR_DEFAULT_FAVICON_DARK_64 36645
#define IDR_FINGERPRINT_COMPLETE_CHECK_DARK 36646
#define IDR_FINGERPRINT_COMPLETE_CHECK_LIGHT 36647
#define IDR_FINGERPRINT_ICON_ANIMATION_DARK 36648
#define IDR_FINGERPRINT_ICON_ANIMATION_LIGHT 36649
#define IDR_FOLDER_CLOSED 314
#define IDR_FOLDER_CLOSED_WHITE 315
#define IDR_FOLDER_OPEN 36650
#define IDR_SIGNAL_0_BAR 36651
#define IDR_SIGNAL_1_BAR 36652
#define IDR_SIGNAL_2_BAR 36653
#define IDR_SIGNAL_3_BAR 36654
#define IDR_SIGNAL_4_BAR 36655
#define IDR_TOUCH_DRAG_TIP_COPY 36659
#define IDR_TOUCH_DRAG_TIP_MOVE 36660
#define IDR_TOUCH_DRAG_TIP_LINK 36661
#define IDR_TOUCH_DRAG_TIP_NODROP 36662

// ---------------------------------------------------------------------------
// From views_resources.h:

#define IDR_APP_TOP_CENTER 37360
#define IDR_APP_TOP_LEFT 37361
#define IDR_APP_TOP_RIGHT 37362
#define IDR_CLOSE 37363
#define IDR_CLOSE_H 37364
#define IDR_CLOSE_P 37365
#define IDR_CONTENT_BOTTOM_CENTER 37366
#define IDR_CONTENT_BOTTOM_LEFT_CORNER 37367
#define IDR_CONTENT_BOTTOM_RIGHT_CORNER 37368
#define IDR_CONTENT_LEFT_SIDE 37369
#define IDR_CONTENT_RIGHT_SIDE 37370
#define IDR_FRAME 37371
#define IDR_FRAME_INACTIVE 37372
#define IDR_MAXIMIZE 37373
#define IDR_MAXIMIZE_H 37374
#define IDR_MAXIMIZE_P 37375
#define IDR_MINIMIZE 37376
#define IDR_MINIMIZE_H 37377
#define IDR_MINIMIZE_P 37378
#define IDR_RESTORE 37379
#define IDR_RESTORE_H 37380
#define IDR_RESTORE_P 37381
#define IDR_TEXTBUTTON_HOVER_BOTTOM 37382
#define IDR_TEXTBUTTON_HOVER_BOTTOM_LEFT 37383
#define IDR_TEXTBUTTON_HOVER_BOTTOM_RIGHT 37384
#define IDR_TEXTBUTTON_HOVER_CENTER 37385
#define IDR_TEXTBUTTON_HOVER_LEFT 37386
#define IDR_TEXTBUTTON_HOVER_RIGHT 37387
#define IDR_TEXTBUTTON_HOVER_TOP 37388
#define IDR_TEXTBUTTON_HOVER_TOP_LEFT 37389
#define IDR_TEXTBUTTON_HOVER_TOP_RIGHT 37390
#define IDR_TEXTBUTTON_PRESSED_BOTTOM 37391
#define IDR_TEXTBUTTON_PRESSED_BOTTOM_LEFT 37392
#define IDR_TEXTBUTTON_PRESSED_BOTTOM_RIGHT 37393
#define IDR_TEXTBUTTON_PRESSED_CENTER 37394
#define IDR_TEXTBUTTON_PRESSED_LEFT 37395
#define IDR_TEXTBUTTON_PRESSED_RIGHT 37396
#define IDR_TEXTBUTTON_PRESSED_TOP 37397
#define IDR_TEXTBUTTON_PRESSED_TOP_LEFT 37398
#define IDR_TEXTBUTTON_PRESSED_TOP_RIGHT 37399
#define IDR_WINDOW_BOTTOM_CENTER 37400
#define IDR_WINDOW_BOTTOM_LEFT_CORNER 37401
#define IDR_WINDOW_BOTTOM_RIGHT_CORNER 37402
#define IDR_WINDOW_LEFT_SIDE 37403
#define IDR_WINDOW_RIGHT_SIDE 37404
#define IDR_WINDOW_TOP_CENTER 37405
#define IDR_WINDOW_TOP_LEFT_CORNER 37406
#define IDR_WINDOW_TOP_RIGHT_CORNER 37407

// ---------------------------------------------------------------------------
// From webrtc_internals_resources.h:

#define IDR_WEBRTC_INTERNALS_CANDIDATE_GRID_JS 18950
#define IDR_WEBRTC_INTERNALS_DATA_SERIES_JS 18951
#define IDR_WEBRTC_INTERNALS_DUMP_CREATOR_JS 18952
#define IDR_WEBRTC_INTERNALS_PEER_CONNECTION_UPDATE_TABLE_JS 18953
#define IDR_WEBRTC_INTERNALS_SSRC_INFO_MANAGER_JS 18954
#define IDR_WEBRTC_INTERNALS_STATS_GRAPH_HELPER_JS 18955
#define IDR_WEBRTC_INTERNALS_STATS_RATES_CALCULATOR_JS 18956
#define IDR_WEBRTC_INTERNALS_STATS_TABLE_JS 18957
#define IDR_WEBRTC_INTERNALS_TAB_VIEW_JS 18958
#define IDR_WEBRTC_INTERNALS_TIMELINE_GRAPH_VIEW_JS 18959
#define IDR_WEBRTC_INTERNALS_WEBRTC_INTERNALS_HTML 18960
#define IDR_WEBRTC_INTERNALS_WEBRTC_INTERNALS_CSS 18961
#define IDR_WEBRTC_INTERNALS_WEBRTC_INTERNALS_JS 18962

// ---------------------------------------------------------------------------
// From webui_generated_resources.h:

#define IDR_WEBUI_CSS_ACTION_LINK_CSS 37440
#define IDR_WEBUI_CSS_BUTTER_BAR_CSS 37441
#define IDR_WEBUI_CSS_CHROME_SHARED_CSS 37442
#define IDR_WEBUI_CSS_I18N_PROCESS_CSS 37443
#define IDR_WEBUI_CSS_LIST_CSS 37444
#define IDR_WEBUI_CSS_MENU_BUTTON_CSS 37445
#define IDR_WEBUI_CSS_MENU_CSS 37446
#define IDR_WEBUI_CSS_ROBOTO_CSS 37447
#define IDR_WEBUI_CSS_SPINNER_CSS 37448
#define IDR_WEBUI_CSS_TEXT_DEFAULTS_CSS 37449
#define IDR_WEBUI_CSS_TEXT_DEFAULTS_MD_CSS 37450
#define IDR_WEBUI_CSS_THROBBER_CSS 37451
#define IDR_WEBUI_CSS_WIDGETS_CSS 37452
#define IDR_WEBUI_CSS_MD_COLORS_CSS 37453
#define IDR_WEBUI_HTML_ASSERT_HTML 37454
#define IDR_WEBUI_HTML_LOAD_TIME_DATA_HTML 37455
#define IDR_WEBUI_HTML_PARSE_HTML_SUBSET_HTML 37456
#define IDR_WEBUI_HTML_TEST_LOADER_HTML 37457
#define IDR_WEBUI_HTML_POLYMER_HTML 37458
#define IDR_WEBUI_IMAGES_ADD_SVG 37459
#define IDR_WEBUI_IMAGES_CANCEL_RED_SVG 37460
#define IDR_WEBUI_IMAGES_CHECKBOX_BLACK_PNG 37461
#define IDR_WEBUI_IMAGES_CHECKBOX_WHITE_PNG 37462
#define IDR_WEBUI_IMAGES_CHECK_CIRCLE_GREEN_SVG 37463
#define IDR_WEBUI_IMAGES_CHECK_PNG 37464
#define IDR_WEBUI_IMAGES_DARK_ICON_SEARCH_SVG 37465
#define IDR_WEBUI_IMAGES_DISABLED_SELECT_PNG 37466
#define IDR_WEBUI_IMAGES_DROP_DOWN_ARROW_BLACK_SVG 37467
#define IDR_WEBUI_IMAGES_DROP_DOWN_ARROW_GRAY_SVG 37468
#define IDR_WEBUI_IMAGES_DROP_DOWN_ARROW_WHITE_SVG 37469
#define IDR_WEBUI_IMAGES_ERROR_SVG 37470
#define IDR_WEBUI_IMAGES_ICON_CANCEL_SVG 37471
#define IDR_WEBUI_IMAGES_ICON_COPY_CONTENT_SVG 37472
#define IDR_WEBUI_IMAGES_ICON_FILE_PNG 37473
#define IDR_WEBUI_IMAGES_ICON_REFRESH_SVG 37474
#define IDR_WEBUI_IMAGES_ICON_SEARCH_SVG 37475
#define IDR_WEBUI_IMAGES_OPEN_IN_NEW_SVG 37476
#define IDR_WEBUI_IMAGES_SELECT_PNG 37477
#define IDR_WEBUI_IMAGES_THROBBER_MEDIUM_SVG 37478
#define IDR_WEBUI_IMAGES_THROBBER_SMALL_DARK_SVG 37479
#define IDR_WEBUI_IMAGES_THROBBER_SMALL_SVG 37480
#define IDR_WEBUI_IMAGES_TREE_TRIANGLE_SVG 37481
#define IDR_WEBUI_IMAGES_2X_CHECKBOX_BLACK_PNG 37482
#define IDR_WEBUI_IMAGES_2X_CHECKBOX_WHITE_PNG 37483
#define IDR_WEBUI_IMAGES_2X_CHECK_PNG 37484
#define IDR_WEBUI_IMAGES_2X_DISABLED_SELECT_PNG 37485
#define IDR_WEBUI_IMAGES_2X_SELECT_PNG 37486
#define IDR_WEBUI_IMAGES_ARROW_DOWN_SVG 37487
#define IDR_WEBUI_IMAGES_ARROW_RIGHT_SVG 37488
#define IDR_WEBUI_IMAGES_BUSINESS_SVG 37489
#define IDR_WEBUI_IMAGES_CHROME_LOGO_DARK_SVG 37490
#define IDR_WEBUI_IMAGES_DARK_ARROW_DOWN_SVG 37491
#define IDR_WEBUI_IMAGES_ICON_ARROW_BACK_SVG 37492
#define IDR_WEBUI_IMAGES_ICON_ARROW_DROPDOWN_SVG 37493
#define IDR_WEBUI_IMAGES_ICON_BOOKMARK_SVG 37494
#define IDR_WEBUI_IMAGES_ICON_CLEAR_SVG 37495
#define IDR_WEBUI_IMAGES_ICON_CLOCK_SVG 37496
#define IDR_WEBUI_IMAGES_ICON_DELETE_GRAY_SVG 37497
#define IDR_WEBUI_IMAGES_ICON_EDIT_SVG 37498
#define IDR_WEBUI_IMAGES_ICON_EXPAND_LESS_SVG 37499
#define IDR_WEBUI_IMAGES_ICON_EXPAND_MORE_SVG 37500
#define IDR_WEBUI_IMAGES_ICON_MORE_VERT_SVG 37501
#define IDR_WEBUI_IMAGES_ICON_PICTURE_DELETE_SVG 37502
#define IDR_WEBUI_IMAGES_ICON_SETTINGS_SVG 37503
#define IDR_WEBUI_IMAGES_ICON_VISIBILITY_OFF_SVG 37504
#define IDR_WEBUI_IMAGES_ICON_VISIBILITY_SVG 37505
#define IDR_WEBUI_JS_CR_UI_FOCUS_OUTLINE_MANAGER_M_JS 37506
#define IDR_WEBUI_JS_CR_UI_FOCUS_ROW_M_JS 37507
#define IDR_WEBUI_JS_CR_UI_KEYBOARD_SHORTCUT_LIST_M_JS 37508
#define IDR_WEBUI_JS_CR_UI_COMMAND_M_JS 37509
#define IDR_WEBUI_JS_CR_UI_CONTEXT_MENU_HANDLER_M_JS 37510
#define IDR_WEBUI_JS_CR_UI_FOCUS_ROW_BEHAVIOR_M_JS 37511
#define IDR_WEBUI_JS_CR_UI_FOCUS_WITHOUT_INK_M_JS 37512
#define IDR_WEBUI_JS_CR_UI_MENU_BUTTON_M_JS 37513
#define IDR_WEBUI_JS_CR_UI_MENU_ITEM_M_JS 37514
#define IDR_WEBUI_JS_CR_UI_MENU_M_JS 37515
#define IDR_WEBUI_JS_CR_UI_POSITION_UTIL_M_JS 37516
#define IDR_WEBUI_JS_CR_UI_STORE_JS 37517
#define IDR_WEBUI_JS_METRICS_REPORTER_METRICS_REPORTER_JS 37518
#define IDR_WEBUI_JS_METRICS_REPORTER_BROWSER_PROXY_JS 37519
#define IDR_WEBUI_JS_METRICS_REPORTER_METRICS_REPORTER_MOJOM_WEBUI_JS 37520
#define IDR_WEBUI_JS_ASSERT_M_JS 37521
#define IDR_WEBUI_JS_CR_EVENT_TARGET_M_JS 37522
#define IDR_WEBUI_JS_CR_UI_M_JS 37523
#define IDR_WEBUI_JS_EVENT_TRACKER_M_JS 37524
#define IDR_WEBUI_JS_LOAD_TIME_DATA_JS 37525
#define IDR_WEBUI_JS_PARSE_HTML_SUBSET_M_JS 37526
#define IDR_WEBUI_JS_PROMISE_RESOLVER_M_JS 37527
#define IDR_WEBUI_JS_UTIL_M_JS 37528
#define IDR_WEBUI_JS_I18N_BEHAVIOR_M_JS 37529
#define IDR_WEBUI_JS_LIST_PROPERTY_UPDATE_BEHAVIOR_M_JS 37530
#define IDR_WEBUI_JS_WEB_UI_LISTENER_BEHAVIOR_M_JS 37531
#define IDR_WEBUI_JS_ACTION_LINK_JS 37532
#define IDR_WEBUI_JS_ASSERT_JS 37533
#define IDR_WEBUI_JS_COLOR_UTILS_JS 37534
#define IDR_WEBUI_JS_CR_M_JS 37535
#define IDR_WEBUI_JS_ICON_JS 37536
#define IDR_WEBUI_JS_LOAD_TIME_DATA_M_JS 37537
#define IDR_WEBUI_JS_PLURAL_STRING_PROXY_JS 37538
#define IDR_WEBUI_JS_STATIC_TYPES_JS 37539
#define IDR_WEBUI_JS_SEARCH_HIGHLIGHT_UTILS_JS 37540
#define IDR_WEBUI_JS_TEST_LOADER_JS 37541
#define IDR_WEBUI_JS_TEST_LOADER_UTIL_JS 37542
#define IDR_WEBUI_JS_UTIL_JS 37543
#define IDR_WEBUI_JS_WEBUI_RESOURCE_TEST_JS 37544
#define IDR_WEBUI_JS_WEBVIEW_MANAGER_JS 37545
#define IDR_WEBUI_JS_BROWSER_COMMAND_PROXY_JS 37546
#define IDR_WEBUI_JS_BROWSER_COMMAND_MOJOM_WEBUI_JS 37547
#define IDR_WEBUI_CR_ELEMENTS_CR_SPLITTER_CR_SPLITTER_JS 37548
#define IDR_WEBUI_CR_ELEMENTS_CR_TAB_BOX_CR_TAB_BOX_JS 37549
#define IDR_WEBUI_CR_ELEMENTS_CR_TAB_BOX_CR_TAB_BOX_HTML_JS 37550
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_JS 37551
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_HTML_JS 37552
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_BASE_JS 37553
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_ITEM_JS 37554
#define IDR_WEBUI_CR_ELEMENTS_CR_TREE_CR_TREE_ITEM_HTML_JS 37555
#define IDR_WEBUI_JS_ASSERT_TS_JS 37556
#define IDR_WEBUI_JS_CUSTOM_ELEMENT_JS 37557
#define IDR_WEBUI_JS_CR_UI_FOCUS_GRID_JS 37558
#define IDR_WEBUI_JS_CR_UI_DRAG_WRAPPER_JS 37559
#define IDR_WEBUI_CR_COMPONENTS_LOCALIZED_LINK_LOCALIZED_LINK_HTML_JS 37560
#define IDR_WEBUI_CR_COMPONENTS_LOCALIZED_LINK_LOCALIZED_LINK_JS 37561
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_FOOTNOTE_MANAGED_FOOTNOTE_HTML_JS 37562
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_FOOTNOTE_MANAGED_FOOTNOTE_JS 37563
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_DIALOG_MANAGED_DIALOG_HTML_JS 37564
#define IDR_WEBUI_CR_COMPONENTS_MANAGED_DIALOG_MANAGED_DIALOG_JS 37565
#define IDR_WEBUI_CR_ELEMENTS_CR_AUTO_IMG_CR_AUTO_IMG_JS 37566
#define IDR_WEBUI_CR_ELEMENTS_CR_GRID_CR_GRID_HTML_JS 37567
#define IDR_WEBUI_CR_ELEMENTS_CR_GRID_CR_GRID_JS 37568
#define IDR_WEBUI_CR_ELEMENTS_CR_A11Y_ANNOUNCER_CR_A11Y_ANNOUNCER_HTML_JS 37569
#define IDR_WEBUI_CR_ELEMENTS_CR_A11Y_ANNOUNCER_CR_A11Y_ANNOUNCER_JS 37570
#define IDR_WEBUI_CR_ELEMENTS_CR_ACTION_MENU_CR_ACTION_MENU_HTML_JS 37571
#define IDR_WEBUI_CR_ELEMENTS_CR_ACTION_MENU_CR_ACTION_MENU_JS 37572
#define IDR_WEBUI_CR_ELEMENTS_CR_CONTAINER_SHADOW_MIXIN_JS 37573
#define IDR_WEBUI_CR_ELEMENTS_CR_DRAWER_CR_DRAWER_HTML_JS 37574
#define IDR_WEBUI_CR_ELEMENTS_CR_DRAWER_CR_DRAWER_JS 37575
#define IDR_WEBUI_CR_ELEMENTS_CR_LINK_ROW_CR_LINK_ROW_HTML_JS 37576
#define IDR_WEBUI_CR_ELEMENTS_CR_LINK_ROW_CR_LINK_ROW_JS 37577
#define IDR_WEBUI_CR_ELEMENTS_CR_MENU_SELECTOR_CR_MENU_SELECTOR_JS 37578
#define IDR_WEBUI_CR_ELEMENTS_CR_NAV_MENU_ITEM_STYLE_CSS_JS 37579
#define IDR_WEBUI_CR_ELEMENTS_CR_PAGE_HOST_STYLE_CSS_JS 37580
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_GRID_HTML_JS 37581
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_GRID_JS 37582
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_HTML_JS 37583
#define IDR_WEBUI_CR_ELEMENTS_CR_PROFILE_AVATAR_SELECTOR_CR_PROFILE_AVATAR_SELECTOR_JS 37584
#define IDR_WEBUI_CR_ELEMENTS_CR_SEARCH_FIELD_CR_SEARCH_FIELD_MIXIN_JS 37585
#define IDR_WEBUI_CR_ELEMENTS_CR_SEARCH_FIELD_CR_SEARCH_FIELD_HTML_JS 37586
#define IDR_WEBUI_CR_ELEMENTS_CR_SEARCH_FIELD_CR_SEARCH_FIELD_JS 37587
#define IDR_WEBUI_CR_ELEMENTS_CR_SLIDER_CR_SLIDER_HTML_JS 37588
#define IDR_WEBUI_CR_ELEMENTS_CR_SLIDER_CR_SLIDER_JS 37589
#define IDR_WEBUI_CR_ELEMENTS_CR_TABS_CR_TABS_HTML_JS 37590
#define IDR_WEBUI_CR_ELEMENTS_CR_TABS_CR_TABS_JS 37591
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_MANAGER_HTML_JS 37592
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_MANAGER_JS 37593
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_HTML_JS 37594
#define IDR_WEBUI_CR_ELEMENTS_CR_TOAST_CR_TOAST_JS 37595
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SEARCH_FIELD_HTML_JS 37596
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SEARCH_FIELD_JS 37597
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SELECTION_OVERLAY_HTML_JS 37598
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_SELECTION_OVERLAY_JS 37599
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_HTML_JS 37600
#define IDR_WEBUI_CR_ELEMENTS_CR_TOOLBAR_CR_TOOLBAR_JS 37601
#define IDR_WEBUI_CR_ELEMENTS_CR_VIEW_MANAGER_CR_VIEW_MANAGER_HTML_JS 37602
#define IDR_WEBUI_CR_ELEMENTS_CR_VIEW_MANAGER_CR_VIEW_MANAGER_JS 37603
#define IDR_WEBUI_CR_ELEMENTS_FIND_SHORTCUT_MIXIN_JS 37604
#define IDR_WEBUI_CR_ELEMENTS_MOUSE_HOVERABLE_MIXIN_JS 37605
#define IDR_WEBUI_CR_ELEMENTS_MWB_ELEMENT_SHARED_STYLE_CSS_JS 37606
#define IDR_WEBUI_CR_ELEMENTS_MWB_SHARED_ICONS_HTML_JS 37607
#define IDR_WEBUI_CR_ELEMENTS_MWB_SHARED_STYLE_CSS_JS 37608
#define IDR_WEBUI_CR_ELEMENTS_MWB_SHARED_VARS_CSS_JS 37609
#define IDR_WEBUI_CR_ELEMENTS_SEARCH_HIGHLIGHT_STYLE_CSS_JS 37610
#define IDR_WEBUI_JS_I18N_MIXIN_JS 37611
#define IDR_WEBUI_JS_LIST_PROPERTY_UPDATE_MIXIN_JS 37612
#define IDR_WEBUI_JS_WEB_UI_LISTENER_MIXIN_JS 37613
#define IDR_JSTEMPLATE_JSTEMPLATE_COMPILED_JS 37614
#define IDR_POLYMER_3_0_IRON_A11Y_ANNOUNCER_IRON_A11Y_ANNOUNCER_JS 37615
#define IDR_POLYMER_3_0_IRON_A11Y_KEYS_BEHAVIOR_IRON_A11Y_KEYS_BEHAVIOR_JS 37616
#define IDR_POLYMER_3_0_IRON_A11Y_KEYS_IRON_A11Y_KEYS_JS 37617
#define IDR_POLYMER_3_0_IRON_BEHAVIORS_IRON_BUTTON_STATE_JS 37618
#define IDR_POLYMER_3_0_IRON_BEHAVIORS_IRON_CONTROL_STATE_JS 37619
#define IDR_POLYMER_3_0_IRON_COLLAPSE_IRON_COLLAPSE_JS 37620
#define IDR_POLYMER_3_0_IRON_FIT_BEHAVIOR_IRON_FIT_BEHAVIOR_JS 37621
#define IDR_POLYMER_3_0_IRON_FLEX_LAYOUT_IRON_FLEX_LAYOUT_CLASSES_JS 37622
#define IDR_POLYMER_3_0_IRON_ICON_IRON_ICON_JS 37623
#define IDR_POLYMER_3_0_IRON_ICONSET_SVG_IRON_ICONSET_SVG_JS 37624
#define IDR_POLYMER_3_0_IRON_LIST_IRON_LIST_JS 37625
#define IDR_POLYMER_3_0_IRON_LOCATION_IRON_LOCATION_JS 37626
#define IDR_POLYMER_3_0_IRON_LOCATION_IRON_QUERY_PARAMS_JS 37627
#define IDR_POLYMER_3_0_IRON_MEDIA_QUERY_IRON_MEDIA_QUERY_JS 37628
#define IDR_POLYMER_3_0_IRON_META_IRON_META_JS 37629
#define IDR_POLYMER_3_0_IRON_PAGES_IRON_PAGES_JS 37630
#define IDR_POLYMER_3_0_IRON_RANGE_BEHAVIOR_IRON_RANGE_BEHAVIOR_JS 37631
#define IDR_POLYMER_3_0_IRON_RESIZABLE_BEHAVIOR_IRON_RESIZABLE_BEHAVIOR_JS 37632
#define IDR_POLYMER_3_0_IRON_SCROLL_TARGET_BEHAVIOR_IRON_SCROLL_TARGET_BEHAVIOR_JS 37633
#define IDR_POLYMER_3_0_IRON_SCROLL_THRESHOLD_IRON_SCROLL_THRESHOLD_JS 37634
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_MULTI_SELECTABLE_JS 37635
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_SELECTABLE_JS 37636
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_SELECTION_JS 37637
#define IDR_POLYMER_3_0_IRON_SELECTOR_IRON_SELECTOR_JS 37638
#define IDR_POLYMER_3_0_IRON_TEST_HELPERS_MOCK_INTERACTIONS_JS 37639
#define IDR_POLYMER_3_0_PAPER_BEHAVIORS_PAPER_INKY_FOCUS_BEHAVIOR_JS 37640
#define IDR_POLYMER_3_0_PAPER_BEHAVIORS_PAPER_RIPPLE_BEHAVIOR_JS 37641
#define IDR_POLYMER_3_0_PAPER_PROGRESS_PAPER_PROGRESS_JS 37642
#define IDR_POLYMER_3_0_PAPER_RIPPLE_PAPER_RIPPLE_JS 37643
#define IDR_POLYMER_3_0_PAPER_SPINNER_PAPER_SPINNER_BEHAVIOR_JS 37644
#define IDR_POLYMER_3_0_PAPER_SPINNER_PAPER_SPINNER_LITE_JS 37645
#define IDR_POLYMER_3_0_PAPER_SPINNER_PAPER_SPINNER_STYLES_JS 37646
#define IDR_POLYMER_3_0_PAPER_STYLES_COLOR_JS 37647
#define IDR_POLYMER_3_0_PAPER_STYLES_SHADOW_JS 37648
#define IDR_POLYMER_3_0_PAPER_TOOLTIP_PAPER_TOOLTIP_JS 37649
#define IDR_POLYMER_3_0_POLYMER_POLYMER_BUNDLED_MIN_JS 37650
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_FILE_HANDLING_ITEM_JS 37651
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_MORE_PERMISSIONS_ITEM_JS 37652
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_ITEM_JS 37653
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_RUN_ON_OS_LOGIN_ITEM_JS 37654
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_TOGGLE_ROW_JS 37655
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_UNINSTALL_BUTTON_JS 37656
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_WINDOW_MODE_ITEM_JS 37657
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_CONSTANTS_JS 37658
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_CONSTANTS_JS 37659
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_UTIL_JS 37660
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_BROWSER_PROXY_JS 37661
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_UTIL_JS 37662
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_FILE_HANDLING_ITEM_HTML_JS 37663
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_MORE_PERMISSIONS_ITEM_HTML_JS 37664
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_PERMISSION_ITEM_HTML_JS 37665
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_RUN_ON_OS_LOGIN_ITEM_HTML_JS 37666
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_TOGGLE_ROW_HTML_JS 37667
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_UNINSTALL_BUTTON_HTML_JS 37668
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_WINDOW_MODE_ITEM_HTML_JS 37669
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_ICONS_HTML_JS 37670
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_SHARED_STYLE_CSS_JS 37671
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_SHARED_VARS_CSS_JS 37672
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_APP_MANAGEMENT_MOJOM_WEBUI_JS 37673
#define IDR_CR_COMPONENTS_APP_MANAGEMENT_TYPES_MOJOM_WEBUI_JS 37674
#define IDR_CR_COMPONENTS_CHROMEOS_TRAFFIC_COUNTERS_TRAFFIC_COUNTERS_ADAPTER_JS 37675
#define IDR_CR_COMPONENTS_CHROMEOS_BLUETOOTH_BLUETOOTH_UTILS_JS 37676
#define IDR_CR_COMPONENTS_CHROMEOS_BLUETOOTH_BLUETOOTH_TYPES_JS 37677
#define IDR_CR_COMPONENTS_CHROMEOS_BLUETOOTH_BLUETOOTH_METRICS_UTILS_JS 37678
#define IDR_CR_COMPONENTS_CHROMEOS_BLUETOOTH_CROS_BLUETOOTH_CONFIG_JS 37679
#define IDR_CR_COMPONENTS_CHROMEOS_NETWORK_HEALTH_MOJO_INTERFACE_PROVIDER_JS 37680
#define IDR_CR_COMPONENTS_CHROMEOS_NETWORK_HEALTH_NETWORK_DIAGNOSTICS_TYPES_JS 37681
#define IDR_CR_COMPONENTS_CHROMEOS_SMB_SHARES_SMB_BROWSER_PROXY_JS 37682
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_COLORIZE_SVG 37683
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_BRUSH_SVG 37684
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_CUSTOMIZE_THEMES_JS 37685
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_THEME_ICON_JS 37686
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_BROWSER_PROXY_JS 37687
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_CUSTOMIZE_THEMES_HTML_JS 37688
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_THEME_ICON_HTML_JS 37689
#define IDR_CR_COMPONENTS_CUSTOMIZE_THEMES_CUSTOMIZE_THEMES_MOJOM_WEBUI_JS 37690
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_JS 37691
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MIXIN_JS 37692
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_PROXY_JS 37693
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_HTML_JS 37694
#define IDR_CR_COMPONENTS_HELP_BUBBLE_HELP_BUBBLE_MOJOM_WEBUI_JS 37695
#define IDR_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_JS 37696
#define IDR_CR_COMPONENTS_MOST_VISITED_BROWSER_PROXY_JS 37697
#define IDR_CR_COMPONENTS_MOST_VISITED_WINDOW_PROXY_JS 37698
#define IDR_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_HTML_JS 37699
#define IDR_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_WEBUI_JS 37700
#define IDR_CR_ELEMENTS_ACTION_LINK_CSS_M_JS 37701
#define IDR_CR_ELEMENTS_CR_ACTIONABLE_ROW_STYLE_M_JS 37702
#define IDR_CR_ELEMENTS_CR_BUTTON_CR_BUTTON_M_JS 37703
#define IDR_CR_ELEMENTS_CR_CHECKBOX_CR_CHECKBOX_M_JS 37704
#define IDR_CR_ELEMENTS_CR_CONTAINER_SHADOW_BEHAVIOR_M_JS 37705
#define IDR_CR_ELEMENTS_CR_DIALOG_CR_DIALOG_M_JS 37706
#define IDR_CR_ELEMENTS_CR_EXPAND_BUTTON_CR_EXPAND_BUTTON_M_JS 37707
#define IDR_CR_ELEMENTS_CR_FINGERPRINT_CR_FINGERPRINT_ICON_M_JS 37708
#define IDR_CR_ELEMENTS_CR_FINGERPRINT_CR_FINGERPRINT_PROGRESS_ARC_M_JS 37709
#define IDR_CR_ELEMENTS_CR_ICON_BUTTON_CR_ICON_BUTTON_M_JS 37710
#define IDR_CR_ELEMENTS_CR_ICONS_CSS_M_JS 37711
#define IDR_CR_ELEMENTS_CR_INPUT_CR_INPUT_M_JS 37712
#define IDR_CR_ELEMENTS_CR_INPUT_CR_INPUT_STYLE_CSS_M_JS 37713
#define IDR_CR_ELEMENTS_CR_LAZY_RENDER_CR_LAZY_RENDER_M_JS 37714
#define IDR_CR_ELEMENTS_CR_LOTTIE_CR_LOTTIE_M_JS 37715
#define IDR_CR_ELEMENTS_CR_RADIO_BUTTON_CR_CARD_RADIO_BUTTON_M_JS 37716
#define IDR_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_BEHAVIOR_M_JS 37717
#define IDR_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_M_JS 37718
#define IDR_CR_ELEMENTS_CR_RADIO_BUTTON_CR_RADIO_BUTTON_STYLE_CSS_M_JS 37719
#define IDR_CR_ELEMENTS_CR_RADIO_GROUP_CR_RADIO_GROUP_M_JS 37720
#define IDR_CR_ELEMENTS_CR_SCROLLABLE_BEHAVIOR_M_JS 37721
#define IDR_CR_ELEMENTS_CR_TOGGLE_CR_TOGGLE_M_JS 37722
#define IDR_CR_ELEMENTS_HIDDEN_STYLE_CSS_M_JS 37723
#define IDR_CR_ELEMENTS_ICONS_M_JS 37724
#define IDR_CR_ELEMENTS_MD_SELECT_CSS_M_JS 37725
#define IDR_CR_ELEMENTS_POLICY_CR_POLICY_INDICATOR_BEHAVIOR_M_JS 37726
#define IDR_CR_ELEMENTS_POLICY_CR_POLICY_INDICATOR_M_JS 37727
#define IDR_CR_ELEMENTS_POLICY_CR_POLICY_PREF_INDICATOR_M_JS 37728
#define IDR_CR_ELEMENTS_POLICY_CR_TOOLTIP_ICON_M_JS 37729
#define IDR_CR_ELEMENTS_SHARED_STYLE_CSS_M_JS 37730
#define IDR_CR_ELEMENTS_SHARED_VARS_CSS_M_JS 37731
#define IDR_WEBUI_JS_BROWSER_COMMAND_BROWSER_COMMAND_PROXY_JS 37732
#define IDR_WEBUI_JS_BROWSER_COMMAND_BROWSER_COMMAND_MOJOM_WEBUI_JS 37733
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTER_JS 37734
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTERS_JS 37735
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_MENU_CONTAINER_JS 37736
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_PAGE_FAVICON_JS 37737
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_SEARCH_QUERY_JS 37738
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_URL_VISIT_JS 37739
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_BROWSER_PROXY_JS 37740
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_METRICS_PROXY_JS 37741
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_UTILS_JS 37742
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_SHARED_STYLE_CSS_JS 37743
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_SHARED_VARS_CSS_JS 37744
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTER_HTML_JS 37745
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_CLUSTERS_HTML_JS 37746
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_MENU_CONTAINER_HTML_JS 37747
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_PAGE_FAVICON_HTML_JS 37748
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_SEARCH_QUERY_HTML_JS 37749
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_URL_VISIT_HTML_JS 37750
#define IDR_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_WEBUI_JS 37751
#define IDR_LOTTIE_LOTTIE_WORKER_MIN_JS 37752
#define IDR_CR_COMPONENTS_COLOR_CHANGE_LISTENER_BROWSER_PROXY_JS 37753
#define IDR_CR_COMPONENTS_COLOR_CHANGE_LISTENER_COLORS_CSS_UPDATER_JS 37754
#define IDR_CR_COMPONENTS_COLOR_CHANGE_LISTENER_COLOR_CHANGE_LISTENER_MOJOM_WEBUI_JS 37755
#define IDR_WEBUI_GENERATED_ROBOTO_ROBOTO_BOLD_WOFF2 37756
#define IDR_WEBUI_GENERATED_ROBOTO_ROBOTO_MEDIUM_WOFF2 37757
#define IDR_WEBUI_GENERATED_ROBOTO_ROBOTO_REGULAR_WOFF2 37758

#endif  // CEF_INCLUDE_CEF_PACK_RESOURCES_H_
